(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2400597,      34283]*)
(*NotebookOutlinePosition[   2479891,      36482]*)
(*  CellTagsIndexPosition[   2473276,      36242]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.11 ", "HeadingNumber"],
  "Manipulating Notebooks"
}], "Section",
  CellTags->{"S2.11.0", "0.1"}],

Cell[CellGroupData[{

Cell[TextData[{
  "2.11.1 Cells as ",
  StyleBox["Mathematica", "SBO"],
  " Expressions"
}], "Subsection",
  CellTags->{"S2.11.1", "1.1"}],

Cell[TextData[{
  "Like other objects in ",
  StyleBox["Mathematica", "TI"],
  ", the cells in a notebook, and in fact the whole notebook itself, are all \
ultimately represented as ",
  StyleBox["Mathematica", "TI"],
  " expressions. With the standard notebook front end, you can use the \
command ",
  StyleBox["Show Expression", "SR"],
  " to see the text of the ",
  StyleBox["Mathematica", "TI"],
  " expression that corresponds to any particular cell.   "
}], "Text",
  CellTags->{"S2.11.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Show Expression", "SR"],
              " menu item "
            }]], Cell[TextData[{
              "toggle between displayed form and underlying ",
              StyleBox["Mathematica", "TI"],
              " expression "
            }]]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["*\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["8\[RightModified]", "MR"],
              "  (between existing cells) "
            }]], Cell[TextData[{
              "put up a dialog box to allow input of a cell in ",
              StyleBox["Mathematica", "TI"],
              " expression form "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.1"],

Cell[TextData[{
  "Handling ",
  StyleBox["Cell", "MR"],
  " expressions in the notebook front end. "
}], "Caption",
  CellTags->"S2.11.1"],

Cell["Here is a cell displayed in its usual way in the front end.", \
"MathCaption",
  CellTags->{"S2.11.1", "1.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008;0000:b000`400?l00000o`00003oo`3ooooo
0?ooo`d0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c2@0c<c<10?ooo`0000<0oooo0>GUi@0c
<c<0o`0c<c?o03<c<`T0<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT709VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT709VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0?l0VIVIo`2IVIT709VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`3UiNGo0>GU
i@40iNGU102IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`03
0>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo80oooo1@000?l60?ooo`030>GUi@2IVIT0VIVI0080
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo
0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`04
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`l0oooo0`0000020?ooo`<0000000<0oooo00000000
00001P0000050?ooo`H000001P3oool2000000030?ooo`000000oooo00<0oooo00<000000?ooo`3o
ool00P0000020?ooo`80000000<0oooo0000000000000P3oool00`000000oooo0?ooo`030?ooo`80
00000`3oool200000080oooo1P0000000`3oool000000?ooo`3o0?oooiL0oooo00<0003o0?ooo`3o
ool0103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<@0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool00`000000
oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000P3oool00`000000
oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool000000P3oool0
1P000000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3oool00`3oool01P000000oooo
0?ooo`000000oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`3o
0?oooiT0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<@0?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`3oool2000000D0oooo00@000000?ooo`3oool0oooo
0P0000040?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool000001P3oool01@00
0000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`03
0?ooo`040000003oool0oooo00000?l0ooooV`3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2I
VIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a00oooo00<00000
0?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`040000003oool00000000000L0oooo
00@000000?ooo`00000000001`3oool3000000@0oooo00<000000?ooo`3oool0100000030?ooo`05
0000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`@000000P3oool01000
0000oooo0?ooo`00003o0?oooi/0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<@0?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000020?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`040000003oool0
oooo000000@0oooo00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo0000
0080oooo00<000000?ooo`3oool00`3oool01P000000oooo0?ooo`000000oooo00000080oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`3o0?oooiT0oooo00<0003o0?ooo`3oool0
103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<@0?ooo`030000003oool0oooo0080oooo0`0000020?ooo`8000000P3oool3000000@0oooo0P00
00020?ooo`<000001@3oool2000000@0oooo0`0000020?ooo`8000000P3oool2000000030?ooo`00
0000000000<000001@3oool2000000<0oooo0P0000030?ooo`040000003oool0oooo00000?l0oooo
V`3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<a00oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0P0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03P3oool010000000oooo0?oo
o`00003o0?oooi/0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`000000@@3oool010000000oooo0?ooo`00003o0?oooi/0oooo00<0003o0?ooo`3o
ool0103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<=0?ooo`T000001@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02d0oooo
0P0000000`3oool000000000003o0?oooi/0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI
09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo<0oooo1000
0?l60?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooolP3oool50000o`H0oooo00<0iNGU09VI
V@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`03
0>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`030>GUi@2IVIT0VIVI0080VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00<0iNGU09VIV@2IVIT00P2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<co`0c<c<00`3UiND0VIVI09VIV@02
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT709VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0?l0VIVIo`2IVIT709VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVI
o`2IVIT709VIV@80<c<c0@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3UiND80>GUi@40<c<c0@3o
ool00?l0ooooo`3oool=0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{523, 43},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.1"],

Cell[TextData[{
  "Here is the underlying ",
  StyleBox["Mathematica", "TI"],
  " expression that corresponds to the cell."
}], "MathCaption",
  CellTags->{"S2.11.1", "1.4"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:R000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`0000<0oooo0>GUi@0c
<c<0o`0c<c?o03<c<`P0<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`3UiNGo0>GU
i@@0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0
VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
oool0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo<0oooo1@000?l40?ooo`030>GUi@2I
VIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool0
0`000?l0oooo0?ooo`020?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<bL0oooo0P00003F0?ooo`800000m@3oool00`000?l0oooo0?ooo`020?oo
o`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bL0
oooo00<000000?ooo`3oool0W03oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo0?<0
oooo00<0003o0?ooo`3oool00P3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<:0?ooo`<00000103oool3000000<0oooo1@0000020?ooo`D00000
103oool00`000000oooo0?ooo`090?ooo`D0000000D0oooo00000000000000000?ooo`0300000003
0?ooo`000000000000<000000P3oool4000000X0oooo1@0000020?ooo`@000002`3oool200000003
0?ooo`000000000000X0oooo0`0000030?ooo`<000000P3oool2000000<0oooo0P0000030?ooo`<0
00002P3oool3000000@0oooo0`0000030?ooo`D000000P3oool5000000<0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0A0?ooo`D000000`3oool300000080oooo0P0000030?ooo`80
00000`3oool3000000/0oooo00<000000?ooo`3oool0l`3oool00`000?l0oooo0?ooo`020?ooo`03
0>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`T0oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`02
0?ooo`050000003oool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`020?ooo`050000003o
ool0oooo0?ooo`0000002@3oool00`000000oooo0?ooo`02000000X0oooo00L000000?ooo`3oool0
oooo0000003oool0000000<0oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`3oool01P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3o
ool0000000X0oooo00<000000?ooo`3oool0l`3oool00`000?l0oooo0?ooo`020?ooo`030>GUi@2I
VIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`P0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00D0oooo0P00000;0?ooo`030000003o
ool0oooo00D0oooo0P0000090?ooo`050000003oool0oooo0?ooo`0000002P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`000000103oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo02L0oooo00D000000?ooo`3oool0oooo000000080?ooo`03
0000003oool0000000@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`3c0?ooo`03
0000o`3oool0oooo0080oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c203oool00`000000oooo0?ooo`040?ooo`H00000103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`030?ooo`80
00003@3oool00`000000oooo0?ooo`030?ooo`800000303oool4000000X0oooo00<000000?ooo`3o
ool00P3oool6000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00@0oooo1P0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool09`3oool010000000oooo0?ooo`3oool6000000@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo0?<0oooo00<0003o0?ooo`3oool00P3oool00`3U
iND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<80?ooo`03
0000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
0080oooo0P0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3o
ool0000000d0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`030?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo000000040?ooo`030000003oool0oooo00X0oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo0?<0oooo00<0003o0?ooo`3oool00P3oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<80?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool0oooo0`0000050?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool000000080oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0000003oool2000000<0oooo0`0000050?ooo`@00000
2@3oool3000000D0oooo100000090?ooo`@000002P3oool5000000<0oooo0`0000020?ooo`<00000
00D0oooo00000000000000000?ooo`05000000X0oooo100000030?ooo`<000001@3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00X0oooo00<000000?ooo`0000004P3oool00`000000
oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`0000020?oo
o`<0000000D0oooo00000000000000000?ooo`05000000<0oooo00<000000?ooo`0000001@3oool0
0`000000oooo0?ooo`3c0?ooo`030000o`3oool0oooo0080oooo00<0iNGU09VIV@2IVIT00P2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2@3oool00`000000oooo0?ooo`020000
00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
000003l0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool02P3oool00`000000oooo0000000B0?ooo`030000003oool0
00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`3c0?ooo`030000o`3o
ool0oooo0080oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c2P3oool2000000030?ooo`000000oooo00P0oooo0`0000040?ooo`<000001P3oool2
000000@0oooo00<000000?ooo`0000000P3oool9000000P0oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0603oool3
000000@0oooo0`00000<0?ooo`030000003oool000000180oooo00<000000?ooo`0000000P3oool7
00000100oooo00<000000?ooo`3oool0103oool00`000000oooo000000040?ooo`800000m@3oool0
0`000?l0oooo0?ooo`020?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooom03oool40000o`@0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo0080
oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3ooooc0?ooo`D0003o103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GU
i@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03o
ool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?n
03<c<`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c
<oh0<c<c00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0
VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU0>GUi@3o
0>GUiOl0iNGU1`3UiND103<c<`40oooo003o0?ooool0oooo303oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 42},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Cell[", "MR"],
              StyleBox["contents", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["style", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["a cell with a specific style "]},
          {Cell[TextData[{
              StyleBox["Cell[", "MR"],
              StyleBox["contents", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["style", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["options", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["a cell with additional options specified "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.1"],

Cell[TextData[{
  StyleBox["Mathematica", "SO"],
  " expressions corresponding to cells in notebooks. "
}], "Caption",
  CellTags->"S2.11.1"],

Cell[TextData[{
  "Within a given notebook, there is always a collection of ",
  StyleBox["styles", "TI"],
  " that can be used to determine the appearance and behavior of cells. \
Typically the styles are named so as to reflect what role cells which have \
them will play in the notebook.   "
}], "Text",
  CellTags->{"S2.11.1", "1.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"Title\"", "MR"],
              " "
            }]], Cell["the title of the notebook "]},
          {Cell[TextData[{
              StyleBox["\"Section\"", "MR"],
              " "
            }]], Cell["a section heading "]},
          {Cell[TextData[{
              StyleBox["\"Subsection\"", "MR"],
              " "
            }]], Cell["a subsection heading "]},
          {Cell[TextData[{
              StyleBox["\"Text\"", "MR"],
              " "
            }]], Cell["ordinary text "]},
          {Cell[TextData[{
              StyleBox["\"Input\"", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " input "
            }]]},
          {Cell[TextData[{
              StyleBox["\"Output\"", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " output "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.1"],

Cell["Some typical cell styles defined in notebooks. ", "Caption",
  CellTags->"S2.11.1"],

Cell["Here are several cells in different styles.", "MathCaption",
  CellTags->{"S2.11.1", "1.6"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000Lb000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon/0oooo1@000?l20?ooo`D0
003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cUP3oool4000002d0
oooo1000003o0?ooob@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>G0?ooo`80
0000;`3oool200000?l0oooo9@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c00
oooo100000020?ooo`P0000000<0oooo000000000000100000020?ooo`D000002`3oool600000080
oooo1@00000;0?ooo`H0000000<0oooo0000000000001P0000090?ooo`H0000000<0oooo00000000
00001P0000000`3oool0000000000003000000@0oooo1P0000030?ooo`<000002`3oool5000000D0
oooo0`0000050?ooo`800000103oool6000000<0oooo100000040?ooo`800000o`3oool=0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<@3oool2000000@0oooo0P0000020?ooo`80
0000103oool2000000@0oooo0P0000020?ooo`800000303oool2000000@0oooo0P0000020?ooo`80
0000303oool2000000@0oooo0P0000020?ooo`800000303oool2000000@0oooo0P0000020?ooo`80
00000P3oool200000080oooo0P0000020?ooo`80000000@0oooo00000000000000000`3oool20000
00030?ooo`000000000000X0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`0000000000
00@0oooo0P0000060?ooo`800000103oool200000080oooo0P00003o0?oooa80oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<a0?ooo`800000103oool200000080oooo0P0000040?oo
o`800000203oool2000000`0oooo0P0000080?ooo`800000303oool2000000@0oooo0P0000020?oo
o`800000303oool2000000@0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?oo
o`8000000P3oool2000000<0oooo0P00000A0?ooo`8000000`3oool2000000H0oooo100000050?oo
o`800000103oool200000?l0oooo5P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<c40oooo0P0000040?ooo`8000000P3oool2000000@0oooo0P0000050?ooo`@000003@3oool20000
00D0oooo1000000=0?ooo`800000103oool200000080oooo0P00000<0?ooo`800000103oool20000
0080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000`3oool20000
00h0oooo100000040?ooo`8000001P3oool4000000D0oooo0P0000040?ooo`H00000o`3ooolB0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<@3oool2000000@0oooo0P0000020?oo
o`800000103oool2000000@0oooo0P0000020?ooo`800000303oool2000000@0oooo0P0000020?oo
o`800000303oool2000000@0oooo0`0000000`3oool000000000000<0?ooo`800000103oool30000
00030?ooo`00000000000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000030?oo
o`8000003@3oool200000080oooo0P0000030?ooo`8000001@3oool200000080oooo0P0000040?oo
o`800000103oool200000080oooo0P00003o0?oooa80oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<^0?ooo`80000000@0oooo000000000000oooo0P0000000`3oool0000000000003
000000<0oooo100000050?ooo`@000002`3oool4000000D0oooo1000000;0?ooo`@000000`3oool6
000000d0oooo0P0000030?ooo`H000000P3oool600000080oooo0`000000103oool0000000000000
00020?ooo`D00000303oool4000000<0oooo1@0000020?ooo`P000000`3oool2000000D0oooo1000
003o0?oooa<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<^0?ooo`80000000@0
oooo000000000000oooo0P0000000`3oool000000000001@0?ooo`8000007@3oool2000001H0oooo
0P00000?0?ooo`800000o`3ooolL0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
;P3oool;000000P0oooo0P00000F0?ooo`8000005P3oool2000001@0oooo1P00000K0?ooo`800000
5P3oool2000000d0oooo1000003o0?oooa`0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon/0oooo1@000?l60?ooo`030000
o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0
103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo
0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
mP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000
o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0
103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooo[0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c=K0?ooo`800000o`3ooonB0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<cF`3oool00`000000oooo0000003o0?oooi40oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c=M0?ooo`030000003oool0oooo0?l0ooooS`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<`l0oooo0`0000020?ooo`<0000000<0oooo000000000000
1P0000050?ooo`H000001@3oool6000000030?ooo`000000000000D0oooo0`0000030?ooo`800000
0P3oool2000000030?ooo`00000000000080oooo00<000000?ooo`3oool00P3oool3000000<0oooo
00D000000?ooo`3oool0oooo000000030?ooo`<0000000<0oooo0000000000000`3oool00`000000
oooo0?ooo`3o0?oooh40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<@0?ooo`03
0000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`030?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3o
ool000000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0oooo00<0
oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`0000000P3oool00`000000oooo0?ooo`3o0?oooh@0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<@0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`3oool2000000D0oooo00@000000?ooo`3oool0oooo0P0000050?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0
000000H0oooo00D000000?ooo`3oool0oooo000000070?ooo`80000000<0oooo0000003oool00P3o
ool00`000000oooo000000030?ooo`030000003oool000000?l0ooooR@3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<a00oooo00<000000?ooo`3oool00P3oool010000000oooo0?oo
o`0000020?ooo`040000003oool00000000000L0oooo00@000000?ooo`00000000001`3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool0oooo1000
00030?ooo`050000003oool0oooo0?ooo`0000001@3oool2000000<0oooo00L000000?ooo`3oool0
oooo0000003oool0000000<0oooo00<000000?ooo`0000000`00003o0?ooohH0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<@0?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool000000P3oool00`000000oooo000000020?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool000000080oooo00H000000?ooo`3oool0
00000?ooo`0000020?ooo`030000003oool0oooo00<0oooo00H000000?ooo`3oool000000?ooo`00
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000020?ooo`030000
003oool0oooo0?l0ooooQ03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a00oooo
00<000000?ooo`3oool00P3oool300000080oooo0P0000020?ooo`<00000103oool200000080oooo
0`0000040?ooo`80000000<0oooo0000003oool00P0000080?ooo`030000003oool0oooo0080oooo
0P0000020?ooo`80000000<0oooo0000000000000`0000050?ooo`T0000000H0oooo000000000000
00000?ooo`0000020?ooo`800000o`3ooon70?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c403oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02L0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0o`3ooon90?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0000002H0oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0?l0ooooR@3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<`d0oooo2@0000050?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`L000007`3oool200000?l0ooooR`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook03oool40000o`H0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooo[0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon/0oooo1@00
0?l60?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<j@0oooo0`00003o0?ooodP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c>U0?ooo`<00000o`3ooom70?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cYP3o
ool200000?l0ooooA`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@00
00090?ooo`800000103oool2000000<0oooo0P0000000`3oool00000000000030?ooo`D000001`3o
ool2000000<0oooo1@0000070?ooo`8000000P3oool2000000<0oooo0P0000080?ooo`D000001@3o
ool3000000D0oooo0`0000040?ooo`8000000P3oool2000000@0oooo0`0000030?ooo`8000000`3o
ool2000000L0oooo1@0000030?ooo`800000103oool2000000@0oooo0P0000040?ooo`<000000`3o
ool200000?l0oooo=@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@00
00090?ooo`800000103oool2000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3o
ool2000000H0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3o
ool2000000L0oooo0P0000030?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
00000`3oool00000000000020?ooo`8000000`3oool2000000<0oooo0P0000000`3oool000000000
00020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo000000000000103o
ool4000000<0oooo0P0000030?ooo`80000000<0oooo000000000000o`3oooli0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool9000000T0oooo0P0000040?ooo`8000000`3o
ool2000000030?ooo`00000000000080oooo0P0000030?ooo`8000001P3oool200000080oooo0P00
00030?ooo`8000001P3oool200000080oooo0P0000030?ooo`8000001P3oool2000000D0oooo0P00
00000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00
0000000000<0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
00060?ooo`8000000`3oool2000000030?ooo`000000000000@0oooo100000030?ooo`8000000P3o
ool2000000<0oooo0P00003o0?ooocP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<<0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`80000000<0oooo0000000000001`3o
ool2000000H0oooo0P0000070?ooo`8000001P3oool200000080oooo0P0000030?ooo`8000001P3o
ool2000000D0oooo0P0000000`3oool00000000000060?ooo`8000001P3oool2000000<0oooo0P00
00020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00000;0?ooo`80000000<0
oooo000000000000103oool4000000<0oooo0P0000020?ooo`800000o`3ooolm0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool9000000T0oooo0P0000040?ooo`8000000`3o
ool2000000030?ooo`000000000000D0oooo0`0000070?ooo`8000001@3oool3000000L0oooo0P00
00020?ooo`8000000`3oool2000000d0oooo0P0000000`3oool0000000000005000000030?ooo`00
0000000000H0oooo0P0000030?ooo`8000000P3oool2000000<0oooo0P0000000`3oool000000000
00030?ooo`8000002@3oool300000080oooo0P0000030?ooo`8000000P3oool200000080oooo0P00
00020?ooo`L00000o`3ooolh0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303o
ool9000000T0oooo0P0000040?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0`00
00090?ooo`8000000`3oool3000000T0oooo0P0000020?ooo`8000000`3oool2000000`0oooo0P00
00020?ooo`8000000`3oool2000000030?ooo`000000000000H0oooo0P0000030?ooo`8000000P3o
ool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000001`3oool3000000@0oooo0P00
00030?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000`3oool200000?l0oooo>03o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@0000090?ooo`800000103o
ool2000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000H0oooo0P00
00020?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool2000000P0oooo1@00
00030?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool000000000
00030?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3o
ool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000000P3oool200000080oooo0P00
00020?ooo`8000000`3oool200000?l0oooo>03oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<``0oooo2@0000090?ooo`800000103oool300000080oooo0P0000000`3oool000000000
00020?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P00
00020?ooo`<000000P3oool2000000L0oooo0P0000080?ooo`80000000<0oooo0000000000000`3o
ool200000080oooo0P0000000`3oool00000000000030?ooo`8000000`3oool2000000030?ooo`00
000000000080oooo0`0000020?ooo`8000001P3oool2000000<0oooo0P0000000`3oool000000000
00020?ooo`800000103oool2000000030?ooo`000000000000<0oooo0P0000000`3oool000000000
003o0?ooocT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T000002@3o
ool2000000@0oooo1P0000020?ooo`8000000`3oool5000000L0oooo0P0000030?ooo`D000001`3o
ool200000080oooo1P0000070?ooo`8000001@3oool2000000<0oooo0`0000050?ooo`@0000000<0
oooo0000000000000P0000020?ooo`800000103oool3000000<0oooo1P0000080?ooo`D0000000<0
oooo0000000000000P0000000`3oool00000000000040?ooo`80000000<0oooo000000000000103o
ool300000?l0oooo>P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ah0oooo0P00
00040?ooo`800000>@3oool2000000D0oooo0P00000A0?ooo`800000903oool2000000/0oooo0P00
003o0?oood40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<N0?ooo`800000103o
ool2000003X0oooo0P0000030?ooo`8000004P3oool2000002@0oooo0P00000;0?ooo`800000o`3o
ooln0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<K0?ooo`P0000000<0oooo0000000000001P3o
ool2000000l0oooo0P00000?0?ooo`8000004@3oool5000001P0oooo0P00000/0?ooo`800000o`3o
oom10?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo[0?ooo`D0003o0P3o
ool50000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<co`0c
<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<co`0c
<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU0>GUi@3o0>GUiOl0
iNGU1`3UiND103<c<`40oooo00000`3oool0iNGU0>GUi@3o0>GUiOl0iNGU203UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 115},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.1"],

Cell["Here are the expressions that correspond to these cells.", "MathCaption",
  CellTags->{"S2.11.1", "1.7"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000GB000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooolP3oool50000o`H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<h`0oooo1000000V0?ooo`@0
0000@P3oool400000?D0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c9P3oool2000006D0oooo00<000000?ooo`3o
ool0:03oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo01X0oooo0P00003I0?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<bH0oooo00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`0X0?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo0=L0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2@3oool3000000@0oooo0`0000030?ooo`D0
00000P3oool5000000@0oooo00<000000?ooo`3oool02@3oool5000000050?ooo`00000000000000
003oool00`0000000`3oool000000000000300000080oooo1000000:0?ooo`D000000P3oool40000
00X0oooo1@0000001@3oool00000000000000000oooo00<00000203oool5000000050?ooo`000000
00000000003oool00`0000000`3oool000000?ooo`02000000@0oooo0P0000000`3oool000000000
00030?ooo`<000002@3oool4000000D0oooo0`0000040?ooo`030000003oool0oooo0080oooo1@00
00030?ooo`<00000103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0140oooo1@00
00001@3oool00000000000000000oooo00<0000000<0oooo0000003oool00P0000040?ooo`800000
00<0oooo0000000000000`3oool3000000/0oooo00<000000?ooo`3oool0e`3oool00`000?l0oooo
0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<80?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool00P3oool01@000000oooo
0?ooo`3oool0000000/0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
0080oooo0P0000020?ooo`040000003oool0oooo00000080oooo0P0000030?ooo`050000003oool0
oooo0?ooo`000000203oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0
oooo000000020?ooo`<000001@3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`0000004@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000020?ooo`8000000P3oool010000000oooo0?ooo`0000020?ooo`8000000`3o
ool01@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool0e`3oool00`000?l0oooo
0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<70?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`050?ooo`80
00002`3oool00`000000oooo0?ooo`050?ooo`8000002`3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000<0oooo00D00000
0?ooo`3oool0oooo0000000?0?ooo`8000000`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0000000D0oooo00D000000?ooo`3oool0oooo0000000/0?ooo`030000003oool0oooo0080oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`00
00000`3oool01@000000oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3oool0e`3oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<70?ooo`030000003oool0oooo00@0oooo1P0000040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00<0oooo0P00000=
0?ooo`030000003oool0oooo00<0oooo0P00000=0?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000`3oool01@000000oooo
0?ooo`3oool0000000d0oooo0P0000050?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3o
ool0oooo000000040?ooo`040000003oool0oooo0?ooo`H000009`3oool00`000000oooo0?ooo`02
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0000000<0oooo00D000000?ooo`3oool0oooo0000000>0?ooo`030000003oool0oooo0=L0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c1`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`020?ooo`8000000P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo0080oooo0P000002
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00P3oool200000080oooo00<00000
0?ooo`3oool00P0000020?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo
0000000<0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`0000009`3oool00`000000oooo0?ooo`020?ooo`8000000P3oool00`000000oooo0?ooo`02
00000080oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool0000000h0oooo
00<000000?ooo`3oool0e`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<70?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool0oooo0`0000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`030?ooo`030000003oool000000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0000003oool2000000<0oooo0`0000050?ooo`@000002@3oool3
000000D0oooo100000090?ooo`<000000`3oool2000000030?ooo`000000000000`0oooo00@00000
0?ooo`3oool0oooo0P0000000`3oool00000000000020?ooo`80000000<0oooo0000000000000P3o
ool200000080oooo0P0000020?ooo`D000002P3oool400000080oooo1@0000001@3oool000000000
00000000oooo00<000000`3oool00`000000oooo0?ooo`030?ooo`<000002`3oool00`000000oooo
0000000B0?ooo`030000003oool0000000D0oooo00@000000?ooo`3oool0oooo0P0000000`3oool0
0000000000020?ooo`80000000<0oooo0000000000000P3oool200000080oooo0P0000020?ooo`D0
00000`3oool00`000000oooo000000050?ooo`030000003oool0oooo0=L0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c203oool00`000000oooo0?ooo`02000000/0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000P3oool010000000
oooo0?ooo`0000020?ooo`030000003oool0000004L0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0000000B0?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`040?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0e`3oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<90?ooo`80000000<0oooo0000003oool0203oool3000000@0oooo0`0000060?oo
o`800000103oool00`000000oooo000000020?ooo`T00000203oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool0403oool5000001P0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0:0?ooo`<000004`3oool00`000000oooo0000000B0?oo
o`030000003oool0000000<0oooo1@00000H0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`000000103oool200000=T0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooc0?ooo`@0003o1P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooolP3oool50000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?oooo80oooo1@000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c>_0?ooo`@00000o`3ooom30?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<bH0oooo0P0000290?ooo`030000003oool0oooo05P0oooo0P00003W0?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<bH0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo
03L0oooo00<000000?ooo`3oool0i@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<90?ooo`<00000103oool30000
00<0oooo1@0000020?ooo`D00000103oool00`000000oooo0?ooo`090?ooo`D0000000D0oooo0000
0000000000000?ooo`03000000030?ooo`000000000000<000000P3oool4000000X0oooo1@000002
0?ooo`@000002P3oool5000000050?ooo`00000000000000003oool00`0000080?ooo`D000000`3o
ool300000080oooo0P0000030?ooo`8000000`3oool3000000T0oooo100000050?ooo`<00000103o
ool00`000000oooo0?ooo`020?ooo`D000000`3oool3000000@0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0A0?ooo`D000000`3oool300000080oooo0P0000030?ooo`8000000`3o
ool3000000/0oooo00<000000?ooo`3oool0i@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<80?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3o
ool0000000/0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000/0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000030?ooo`050000003oool0oooo0?ooo`000000203oool01@000000oooo0?ooo`3o
ool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`<000001@3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000004@3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool0i@3o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<70?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`050?ooo`8000002`3oool00`000000oooo0?ooo`050?ooo`8000002`3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000002`3oool01@000000oooo0?ooo`3oool00000
00P0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`0=0?ooo`8000000`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo0000000/
0?ooo`050000003oool0oooo0?ooo`000000203oool00`000000oooo000000040?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool0i@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<70?ooo`030000003o
ool0oooo00@0oooo1P0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000040?ooo`030000003oool0oooo00<0oooo0P00000=0?ooo`030000003oool0oooo00<0oooo
0P00000=0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000000;0?ooo`04
0000003oool0oooo0?ooo`H00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00/0oooo0P0000050?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo00000004
0?ooo`040000003oool0oooo0?ooo`H000009`3oool010000000oooo0?ooo`3oool6000000@0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0>D0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c1`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`020?ooo`8000000P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo0080oooo0P000002
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`0:0?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000009`3oool00`00
0000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo00000004
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0i@3oool00`000?l0oooo0?ooo`04
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<7
0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0oooo0`0000050?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003o
ool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0000003oool2000000<0
oooo0`0000050?ooo`@000002@3oool3000000D0oooo100000090?ooo`<000000`3oool200000003
0?ooo`000000000000T0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030000
0080oooo0`0000001@3oool00000000000000000oooo00D000002P3oool400000080oooo1@000000
1@3oool00000000000000000oooo00<000000`3oool00`000000oooo0?ooo`030?ooo`<000002`3o
ool00`000000oooo0000000B0?ooo`030000003oool000000080oooo00@000000?ooo`3oool00000
0P3oool00`000000oooo0?ooo`0300000080oooo0`0000001@3oool00000000000000000oooo00D0
00000`3oool00`000000oooo000000050?ooo`030000003oool0oooo0>D0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c203oool00`000000oooo0?ooo`02000000/0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000P3oool010000000
oooo0?ooo`0000020?ooo`030000003oool0000004@0oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool000000180oooo00<000000?ooo`0000000P3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0103o
ool00`000000oooo000000050?ooo`030000003oool0oooo0>D0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2@3o
ool2000000030?ooo`000000oooo00P0oooo0`0000040?ooo`<000001P3oool2000000@0oooo00<0
00000?ooo`0000000P3oool9000000P0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0B0?ooo`030000003oool0oooo00l0oooo1`00000@0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool02P3oool3000001<0oooo00<000000?ooo`0000004P3oool00`000000oooo0000
00020?ooo`L00000403oool00`000000oooo0?ooo`040?ooo`030000003oool0000000@0oooo0P00
003W0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool`3oool40000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?oooo80oooo1@000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooob0?ooo`D0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<ca03oool400000?l0oooo;P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<V0?ooo`800000WP3o
ool00`000000oooo0?ooo`1]0?ooo`800000_@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<V0?ooo`030000003o
ool0oooo09d0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`1<0?ooo`030000003o
ool0oooo0;/0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c2@3oool3000000@0oooo0`0000030?ooo`D000000P3o
ool5000000@0oooo00<000000?ooo`3oool02@3oool5000000050?ooo`00000000000000003oool0
0`0000000`3oool000000000000300000080oooo1000000:0?ooo`D000000P3oool4000000X0oooo
1@0000001@3oool00000000000000000oooo00<00000203oool4000000@0oooo0`0000040?ooo`<0
00001@3oool300000080oooo1@0000030?ooo`<000000P3oool3000000040?ooo`00000000000000
00P0oooo100000050?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`D000000`3oool30000
00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0A0?ooo`@00000103oool30000
00@0oooo0`0000050?ooo`<000000P3oool5000000<0oooo0`0000020?ooo`<0000000@0oooo0000
0000000000002P3oool00`000000oooo0?ooo`2k0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`P0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`0000002`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000002@3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<00000
0?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000090?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
0080oooo0`0000050?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000000A
0?ooo`030000003oool0oooo0140oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`2k0?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<`L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00D0oooo
0P00000;0?ooo`030000003oool0oooo00D0oooo0P00000;0?ooo`030000003oool0oooo0080oooo
00D000000?ooo`3oool0oooo0000000=0?ooo`030000003oool0000000H0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000001@3oool00`00
0000oooo000000030?ooo`030000003oool0oooo00X0oooo0P0000030?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`0000001@3oool01@000000oooo0?ooo`3oool0000002h0oooo00<00000
0?ooo`0000001P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00D00000
0?ooo`3oool0oooo000000050?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`2k0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`L0oooo00<000000?ooo`3oool0103o
ool6000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000@0oooo
00<000000?ooo`3oool00`3oool2000000d0oooo00<000000?ooo`3oool00`3oool2000000d0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000/0oooo0`0000000`3oool0
000000000004000000030?ooo`000000oooo00L0oooo00<000000?ooo`3oool01@3oool01@000000
oooo0?ooo`3oool0000000D0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`080?oo
o`8000001@3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000103oool0
10000000oooo0?ooo`3oool6000002L0oooo0`0000000`3oool0000000000004000000030?ooo`00
0000oooo00L0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000D0oooo
00<000000?ooo`0000000`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0;/0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c1`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`020?ooo`8000000P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo0080oooo0P000002
0?ooo`030000003oool0oooo00L0oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool200000080oooo00<000000?ooo`3o
ool01`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool01@00
0000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3o
ool0000002D0oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool200000080oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`2k0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`L0oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`3oool3000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool000000?ooo`8000000`3oool3000000D0oooo100000090?ooo`<00000
1@3oool4000000T0oooo0`0000030?ooo`80000000<0oooo0000000000002P3oool00`000000oooo
0?ooo`050?ooo`<00000103oool400000080oooo1@0000020?ooo`<000001@3oool300000080oooo
0P0000000`3oool000000000000;0?ooo`@000000P3oool5000000050?ooo`00000000000000003o
ool00`0000030?ooo`030000003oool0oooo00<0oooo0`00000;0?ooo`030000003oool000000180
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`<00000103oool400000080
oooo1@0000020?ooo`<000001@3oool300000080oooo0P0000000`3oool00000000000040?ooo`03
0000003oool0000000D0oooo00<000000?ooo`3oool0^`3oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<80?ooo`03
0000003oool0oooo008000002`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo000000020?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`000000A@3oool01@000000oooo0?ooo`3oool000000140oooo00<00000
0?ooo`3oool09`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`0000004P3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000004@3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0^`3o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<90?ooo`80000000<0oooo0000003oool0203oool3000000@0oooo0`00
00060?ooo`800000103oool00`000000oooo000000020?ooo`T00000203oool00`000000oooo0?oo
o`0B0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04@3oool400000140oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00X0oooo0`00
000C0?ooo`030000003oool000000180oooo00<000000?ooo`000000103oool400000140oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0000000@0oooo0P00
002m0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool`3oool40000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?oooo80oooo1@000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<co`0c
<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<co`0c
<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU0>GUi@3o0>GUiOl0
iNGU1`3UiND103<c<`40oooo00000`3oool0iNGU0>GUi@3o0>GUiOl0iNGU203UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 93},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.1"],

Cell[TextData[{
  "A particular style such as ",
  StyleBox["\"Section\"", "MR"],
  " or ",
  StyleBox["\"Text\"", "MR"],
  " defines various settings for the options associated with a cell. You can \
override these settings by explicitly setting options within a specific cell. \
"
}], "Text",
  CellTags->{"S2.11.1", "1.8"}],

Cell["\<\
Here is the expression for a cell in which options are set to use a \
gray background and to put a frame around the cell. \
\>", "MathCaption",
  CellTags->{"S2.11.1", "1.9"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000>R000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c0000003o00000?l00000200000010?ooo`0000<0oooo0>GUi@0c
<c<0o`0c<c?o03<c<`L0<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI
0@0c<c<100000040oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT103<c<`4000000@3o
ool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@40<c<c0@0000010?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIWo0>GUiOl0iNGU102IVIT103<c<`4000000@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`400000
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2I
VIT103<c<`4000000@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU
09VIV@2IVIT00P2IVIT103<c<`4000000@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
oo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`400000
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2I
VIT103<c<`4000000@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU
09VIV@2IVIT00P2IVIT103<c<`4000000@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
oo80oooo1@000?l50?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<100000040oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c<P3oool4000004P0oooo1000003o0?ooog@0oooo00<0003o0?ooo`3o
ool00`3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<cD0oooo0P0000190?ooo`030000003oool0oooo02P0oooo0P00000B0?ooo`800000
1@3oool200000?l0oooo;P3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI
0@0c<c<100000040oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3oool00`000000oooo0?oo
o`170?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0?l0oooo;03oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2I
VIT0VIVI0080VIVI0@0c<c<100000040oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3oool5
000000@0oooo0P0000000`3oool00000000000020?ooo`<000000P3oool200000080oooo0`000002
0?ooo`80000000@0oooo0000003oool0oooo100000040?ooo`<00000103oool2000000030?ooo`00
0000000000<0000000@0oooo00000000000000000P3oool2000000030?ooo`00000000000100oooo
100000020?ooo`@00000103oool2000000030?ooo`000000000000<0oooo00@000000?ooo`3oool0
oooo1P0000030?ooo`<000001@3oool00`000000oooo0?ooo`030?ooo`<000000`3oool5000000@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`<000001@3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo0?l0oooo;03oool00`000?l0oooo0?ooo`030?ooo`03
0>GUi@2IVIT0VIVI0080VIVI0@0c<c<100000040oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
5P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P0000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0
oooo008000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3o
ool00`000000oooo0?ooo`0200000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0oooo008000002@3oool2000000D0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00P0000030?ooo`<000000`3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`3o0?ooob`0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI
09VIV@0209VIV@40<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aH0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`070000003oool0oooo0?ooo`000000oooo000000070?oo
o`030000003oool0000000<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`090?ooo`8000000P3o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3oool01`000000oooo0?ooo`3oool00000
0?ooo`000000203oool00`000000oooo000000020?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`090?ooo`050000003oool0oooo0?ooo`000000103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0oooo;03oool00`000?l0oooo0?oo
o`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<100000040oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c5P3oool01@000000oooo0?ooo`3oool0000000<0oooo100000000`3oool000000?oo
o`060?ooo`800000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0
00000`3oool00`000000oooo000000040?ooo`030000003oool0oooo00D000001P3oool300000080
oooo100000020?ooo`030000003oool0oooo00@0oooo100000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`030?ooo`H000000P3oool01P000000oooo0?ooo`3oool0
00000?ooo`H00000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00D0
00000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
o`3oool/0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`400000
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<F0?ooo`@000001`3oool010000000oooo0?oo
o`0000030?ooo`060000003oool0oooo0000003oool00000103oool00`000000oooo0?ooo`020000
00<0oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool000000080oooo0P0000020?ooo`040000003oool0oooo00000080oooo0P00000;0?ooo`800000
0P3oool00`000000oooo0?ooo`060?ooo`800000203oool010000000oooo0?ooo`0000030?ooo`04
0000003oool0oooo000000H0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0:0?ooo`<000001@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0?l0oooo;03oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI
0@0c<c<100000040oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5P3oool01@000000oooo0?oo
o`3oool000000080oooo100000040?ooo`@000000P3oool00`000000oooo0?ooo`02000000<0oooo
0P000000103oool000000000003oool2000000030?ooo`000000000000<0oooo0`0000020?ooo`80
00000P3oool2000000040?ooo`00000000000?ooo`800000103oool2000000030?ooo`000000oooo
00P0oooo0P0000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P0000000`3o
ool00000000000020?ooo`@000000P3oool3000000060?ooo`00000000000000003oool000001`3o
ool300000080oooo0`000000103oool000000000000000020?ooo`<000001@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo000000040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3oool/0?ooo`030000o`3oool0oooo00<0
oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<F0?ooo`050000003oool0oooo0?ooo`000000403oool00`000000oooo0?ooo`0[0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool00P00000G0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`090?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0oooo;03oool00`00
0?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<100000040oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c5@3oool500000100oooo0P00000[0?ooo`<000004@3oool200000003
0?ooo`000000oooo01D0oooo1000000I0?ooo`<000001P3oool2000000/0oooo0`0000040?ooo`80
00001@3oool200000?l0oooo;P3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080
VIVI0@0c<c<100000040oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000
o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VI
V@0209VIV@40<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool0
0`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<100000040oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VI
V@2IVIT00P2IVIT103<c<`4000000@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@0000010?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<bH0oooo0P00003o0?ooolh0oooo00<0003o0?ooo`3oool0
0`3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<bH0oooo00<000000?ooo`3oool0SP3oool00`000000oooo0?ooo`0e0?ooo`030000003o
ool0oooo07@0oooo00<000000?ooo`3oool0S03oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2I
VIT0VIVI0080VIVI0@0c<c<100000040oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2@3oool3
000000@0oooo0`0000030?ooo`D000000P3oool5000000@0oooo00<000000?ooo`3oool02@3oool5
000000050?ooo`00000000000000003oool00`0000000`3oool000000000000300000080oooo1000
000:0?ooo`D000000P3oool4000000X0oooo100000040?ooo`<000000P3oool2000000030?ooo`00
0000oooo008000000P3oool3000000`0oooo0`0000030?ooo`<000000P3oool2000000<0oooo0P00
00030?ooo`<000000`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0140oooo1@00
00030?ooo`<000000P3oool2000000<0oooo0P0000030?ooo`<000002P3oool00`000000oooo0?oo
o`0;0?ooo`<00000103oool3000000<0oooo1@0000020?ooo`D0000000<0oooo0000000000000P00
00040?ooo`@00000103oool2000000030?ooo`00000000000080000000<0oooo0000003oool00P00
00020?ooo`<000004@3oool500000080oooo100000040?ooo`80000000<0oooo0000000000000P3o
ool3000000@0oooo00<000000?ooo`3oool0R`3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2I
VIT0VIVI0080VIVI0@0c<c<100000040oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c203oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080
oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000090?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?oo
o`0000002P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool010000000oooo0?oo
o`0000030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000002@3o
ool00`000000oooo0?ooo`0:0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0200000080
oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000002@3oool2
000000L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo008000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0R`3o
ool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<100000040oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c1`3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool01@3oool2000000/0oooo00<000000?ooo`3oool01@3oool2000000`0oooo0P00
00000`3oool000000?ooo`040?ooo`090000003oool000000?ooo`000000oooo0000003oool00000
00l0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`030000003oool00000
00@0oooo00<000000?ooo`3oool0:03oool01@000000oooo0?ooo`3oool0000000P0oooo00<00000
0?ooo`000000103oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01`000000oooo0000003oool000000?ooo`000000403oool2000000D0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`030?ooo`070000003oool0oooo0?ooo`000000oooo0000002F
0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<70?ooo`030000003oool0oooo00@0oooo1P0000040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo00<0oooo0P00000=0?ooo`030000003oool0oooo00<0oooo0P00000<0?ooo`8000000`3oool0
0`000000oooo0?ooo`030?ooo`080000003oool000000?ooo`000000oooo0000003oool6000000X0
oooo00<000000?ooo`3oool00P3oool6000000@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0X0?ooo`040000003oool0oooo0?ooo`H00000103oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool0103oool6000000@0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<000000?oo
o`3oool0103oool400000080oooo00H000000?ooo`000000oooo0000003oool600000080oooo1@00
00060?ooo`8000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00H0
00000?ooo`3oool0oooo0000003oool600000940oooo00<0003o0?ooo`3oool00`3oool00`3UiND0
VIVI09VIV@0209VIV@40<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`L0oooo
00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool00P3oool200000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`0000002@3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
00X0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<00000
0?ooo`000000103oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0080oooo0`0000050?ooo`800000203oool020000000oooo
0?ooo`000000oooo0000003oool000000P3oool01@000000oooo0?ooo`3oool0000000/0oooo0P00
00050?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000940oooo00<0003o0?ooo`3oool00`3oool00`3UiND0
VIVI09VIV@0209VIV@40<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`L0oooo
00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3oool3000000D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`00
00000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool000000?ooo`8000000`3oool3
000000D0oooo100000090?ooo`<000001@3oool4000000X0oooo100000030?ooo`<000000P3oool3
000000030?ooo`000000oooo00<0oooo0`00000:0?ooo`D000000`3oool300000080oooo0`000000
1@3oool00000000000000000oooo00D000002P3oool00`000000oooo0000000B0?ooo`030000003o
ool000000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0300000080oooo
0`0000001@3oool00000000000000000oooo00D000000`3oool00`000000oooo0000000@0?ooo`03
0000003oool0oooo0080oooo00@000000?ooo`3oool0oooo0`0000050?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0000003oool000000080oooo0P000000
0`3oool00000000000020?ooo`@000000P3oool3000000030?ooo`000000oooo00<0oooo0`00000:
0?ooo`800000103oool010000000oooo0?ooo`0000020?ooo`050000003oool000000000003oool0
0P0000000`3oool00000000000020?ooo`8000000`3oool300000980oooo00<0003o0?ooo`3oool0
0`3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<`P0oooo00<000000?ooo`3oool00P00000;0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool000000080oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0000001D0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool02`3oool00`000000oooo0000000B0?ooo`030000003oool000000080oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`0000004@3oool00`000000oooo0?ooo`02000000/0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000:`3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo0:<0oooo00<0003o0?ooo`3oool00`3oool0
0`3UiND0VIVI09VIV@0209VIV@40<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<`T0oooo0P0000000`3oool000000?ooo`080?ooo`<00000103oool3000000H0oooo0P0000040?oo
o`030000003oool000000080oooo2@0000080?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool0=03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`0000004P3oool00`000000oooo000000020?ooo`L00000403oool00`000000oooo0?ooo`040?oo
o`030000003oool000000180oooo0P0000000`3oool000000?ooo`080?ooo`<00000103oool30000
00<0oooo1P00000[0?ooo`L00000Y@3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI
0080VIVI0@0c<c<100000040oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooc0?ooo`@0
003o1@3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI
0@0c<c<100000040oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooob0?ooo`D0003o1@3o
ool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@0000010?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@0000010?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@40
<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI
09VIV@0209VIV@40<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03o
ool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo
03<c<oh0<c<c00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000@3oool000030?ooo`3UiND0VIVI
0080VIVIo`0c<c?n03<c<`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<100000040oooo00000`3oool0
iNGU09VIV@3o09VIVOl0VIVI1P2IVIT103<c<`4000000@3oool000030?ooo`3UiND0VIVI0?l0VIVI
o`2IVIT609VIV@40<c<c0@0000010?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0@0c
<c<100000040oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT103<c<`4000000@3oool0
00030?ooo`3UiND0iNGU0?l0iNGUo`3UiND70>GUi@4000000@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 58},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.1"],

Cell["This is how the cell looks in a notebook. ", "MathCaption",
  CellTags->{"S2.11.1", "1.10"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000@2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o03<c<ol0<c<c2`0c<c<10?ooo`0000<0oooo03<c<`0c<c<0o`0c<c?o03<c<`P0
<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0iNGUo`3UiND10>GUi@@0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooood0oooo00<0iNGU09VIV@2IVIT00P2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo@3oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooom0?ooo`030>GUi@2IVIT0
VIVI0080VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooood0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo@3oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooom
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooood0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0ooooo@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3oooom0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooood0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<`l0ooooo`00003I000000`0oooo1@16ATH40?ooo`030>GUi@2IVIT0
VIVI0080VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<?0?ooo`030000003<c<`0
c<c<0?l0c<c<e@3<c<`00`000000oooo0?ooo`0>0?ooo`0304I6AP3oool0oooo0080oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`l0oooo00<00000
0<c<c03<c<`0o`3<c<cE0<c<c0030000003oool0oooo00h0oooo00<0ATI60?ooo`3oool00P3oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3`3oool0
0`000000c<c<0<c<c03o0<c<c=D0c<c<00<000000?ooo`3oool03P3oool00`16ATH0oooo0?ooo`02
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<?
0?ooo`030000003<c<`0c<c<0?l0c<c<e@3<c<`00`000000oooo0?ooo`0>0?ooo`0304I6AP3oool0
oooo0080oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<`l0oooo00<000000<c<c03<c<`0o`3<c<cE0<c<c0030000003oool0oooo00h0oooo00<0ATI6
0?ooo`3oool00P3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c3`3oool00`000000c<c<0<c<c03o0<c<c=D0c<c<00<000000?ooo`3oool03P3oool0
0`16ATH0oooo0?ooo`020?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<?0?ooo`030000003<c<`0c<c<0?l0c<c<e@3<c<`00`000000oooo0?ooo`0>
0?ooo`0304I6AP3oool0oooo0080oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<`l0oooo00<000000<c<c03<c<`0o`3<c<cE0<c<c0030000003oool0
oooo00h0oooo00<0ATI60?ooo`3oool00P3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c3`3oool00`000000c<c<0<c<c03o0<c<c=D0c<c<00<00000
0?ooo`3oool03P3oool00`16ATH0oooo0?ooo`020?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<?0?ooo`030000003<c<`0c<c<0?l0c<c<e@3<c<`0
0`000000oooo0?ooo`0>0?ooo`0304I6AP3oool0oooo0080oooo00<0iNGU09VIV@2IVIT00P2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`l0oooo00<000000<c<c03<c<`0o`3<c<cE
0<c<c0030000003oool0oooo00h0oooo00<0ATI60?ooo`3oool00P3oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3`3oool00`000000c<c<0<c<c03o
0<c<c=D0c<c<00<000000?ooo`3oool03P3oool00`16ATH0oooo0?ooo`020?ooo`030>GUi@2IVIT0
VIVI0080VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<?0?ooo`030000003<c<`0
c<c<00L0c<c<0`0000020<c<c0<0000000<0c<c<0000000000001P0000050<c<c0H000001@3<c<`3
000000<0c<c<0`0000020<c<c0<0000000@0c<c<000000000000c<c<0P0000020<c<c08000001P3<
c<`00`000000c<c<0<c<c00200000080c<c<0P0000000`3<c<`00000000000020<c<c0040000003<
c<`0c<c<00000?l0c<c<O@3<c<`00`000000oooo0?ooo`0>0?ooo`0304I6AP3oool0oooo0080oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`l0oooo
00<000000<c<c03<c<`0203<c<`00`000000c<c<0<c<c0020<c<c0040000003<c<`0c<c<00000080
c<c<00<000000<c<c00000000P3<c<`00`000000c<c<0<c<c0030<c<c0030000003<c<`000000080
c<c<00<000000<c<c03<c<`00P3<c<`01P000000c<c<0<c<c0000000c<c<000000<0c<c<00@00000
0<c<c03<c<`000000P3<c<`010000000c<c<0<c<c00000020<c<c0040000003<c<`0c<c<000000@0
c<c<00@000000<c<c03<c<`000000P3<c<`01P000000c<c<0<c<c0000000c<c<00000080c<c<00<0
00000<c<c03<c<`0o`3<c<ao0<c<c0030000003oool0oooo00h0oooo00<0ATI60?ooo`3oool00P3o
ool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3`3o
ool00`000000c<c<0<c<c0080<c<c0030000003<c<`0c<c<0080c<c<00@000000<c<c03<c<`00000
0P3<c<`010000000c<c<0<c<c03<c<`2000000D0c<c<00@000000<c<c03<c<`0c<c<0P0000060<c<
c080000000<0c<c<0000003<c<`00P3<c<`010000000c<c<0<c<c00000020<c<c0040000003<c<`0
c<c<00000080c<c<00<000000<c<c03<c<`01@3<c<`010000000c<c<0<c<c00000060<c<c0050000
003<c<`0c<c<0<c<c0000000o`3<c<b10<c<c0030000003oool0oooo00h0oooo00<0ATI60?ooo`3o
ool00P3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c3`3oool00`000000c<c<0<c<c0080<c<c0030000003<c<`0c<c<0080c<c<00@000000<c<c03<
c<`000000P3<c<`010000000c<c<0000000000070<c<c0040000003<c<`00000000000H0c<c<0P00
00030<c<c0050000003<c<`0c<c<0<c<c00000000P3<c<`010000000c<c<0<c<c00000020<c<c003
0000003<c<`0c<c<00@00000103<c<`00`000000c<c<0<c<c004000000<0c<c<00D000000<c<c03<
c<`0c<c<0000003o0<c<c840c<c<00<000000?ooo`3oool03P3oool00`16ATH0oooo0?ooo`020?oo
o`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<?0?oo
o`030000003<c<`0c<c<00P0c<c<00<000000<c<c03<c<`00P3<c<`010000000c<c<0<c<c0000002
0<c<c0030000003<c<`000000080c<c<00<000000<c<c03<c<`00`3<c<`00`000000c<c<00000002
0<c<c0030000003<c<`0c<c<0080c<c<00H000000<c<c03<c<`000000<c<c00000030<c<c0040000
003<c<`0c<c<00000080c<c<00@000000<c<c03<c<`000000P3<c<`010000000c<c<0<c<c0000004
0<c<c0040000003<c<`0c<c<00000080c<c<00H000000<c<c03<c<`000000<c<c00000020<c<c003
0000003<c<`0c<c<0?l0c<c<O`3<c<`00`000000oooo0?ooo`0>0?ooo`0304I6AP3oool0oooo0080
oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`l0
oooo00<000000<c<c03<c<`0203<c<`00`000000c<c<0<c<c0020<c<c0<000000P3<c<`200000080
c<c<0`0000040<c<c08000000P3<c<`3000000D0c<c<0`0000020<c<c0<000000P3<c<`01@000000
c<c<000000000000c<c<00800000103<c<`2000000@0c<c<0`0000020<c<c08000000P3<c<`20000
00030<c<c0000000000000<00000o`3<c<b00<c<c0030000003oool0oooo00h0oooo00<0ATI60?oo
o`3oool00P3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c3`3oool00`000000c<c<0<c<c0080<c<c0030000003<c<`0c<c<0080c<c<00<000000<c<
c03<c<`0=@3<c<`00`000000c<c<0<c<c00;0<c<c0030000003<c<`0c<c<0?l0c<c<O`3<c<`00`00
0000oooo0?ooo`0>0?ooo`0304I6AP3oool0oooo0080oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`l0oooo00<000000<c<c03<c<`01@3<c<`01000
0000c<c<0<c<c00000020<c<c0030000003<c<`000000?l0c<c<a`3<c<`00`000000oooo0?ooo`0>
0?ooo`0304I6AP3oool0oooo0080oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<`l0oooo00<000000<c<c03<c<`01@3<c<`9000000D0c<c<00<00000
0<c<c03<c<`0203<c<`00`000000c<c<0<c<c03o0<c<c;@0c<c<00<000000?ooo`3oool03P3oool0
0`16ATH0oooo0?ooo`020?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<?0?ooo`030000003<c<`0c<c<0?l0c<c<e@3<c<`00`000000oooo0?ooo`0>
0?ooo`0304I6AP3oool0oooo0080oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<`l0oooo00<000000<c<c03<c<`0o`3<c<cE0<c<c0030000003oool0
oooo00h0oooo00<0ATI60?ooo`3oool00P3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c3`3oool00`000000c<c<0<c<c03o0<c<c=D0c<c<00<00000
0?ooo`3oool03P3oool00`16ATH0oooo0?ooo`020?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<?0?ooo`030000003<c<`0c<c<0?l0c<c<e@3<c<`0
0`000000oooo0?ooo`0>0?ooo`0304I6AP3oool0oooo0080oooo00<0iNGU09VIV@2IVIT00P2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`l0oooo00<000000<c<c03<c<`0o`3<c<cE
0<c<c0030000003oool0oooo00h0oooo00<0ATI60?ooo`3oool00P3oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3`3oool00`000000c<c<0<c<c03o
0<c<c=D0c<c<00<000000?ooo`3oool03P3oool00`16ATH0oooo0?ooo`020?ooo`030>GUi@2IVIT0
VIVI0080VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<?0?ooo`030000003<c<`0
c<c<0?l0c<c<e@3<c<`00`000000oooo0?ooo`0>0?ooo`0304I6AP3oool0oooo0080oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`l0oooo00<00000
0<c<c03<c<`0o`3<c<cE0<c<c0030000003oool0oooo00h0oooo00<0ATI60?ooo`3oool00P3oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3`3oool0
0`000000c<c<0<c<c03o0<c<c=D0c<c<00<000000?ooo`3oool02`3oool404I6AP@0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`l0oooo00<00000
0<c<c03<c<`0o`3<c<cE0<c<c0030000003oool0oooo00h0oooo00<0ATI60?ooo`3oool00P3oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3`3ooooo
00000=T00000303oool504I6AP@0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0ooooo@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooom0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooood0oooo00<0iNGU09VIV@2IVIT00P2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo@3oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooom0?ooo`030>GUi@2IVIT0
VIVI0080VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooood0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo@3oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0<c<co`0c<c<0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0<c<co`0c<c<0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VI
V@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GU
i@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool00?l0iNGUo`3UiND:0>GUi@40<c<c0@3o
ool00?l0iNGUo`3UiND:0>GUi@80oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 64},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["CellFrame", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell["whether to draw a frame around the cell "]},
          {Cell[TextData[{
              StyleBox["Background", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["GrayLevel[1]", "MR"],
              " "
            }]], Cell["what color to draw the background for the cell "]},
          {Cell[TextData[{
              StyleBox["Editable", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell[
            "whether to allow the contents of the cell to be edited "]},
          {Cell[TextData[{
              StyleBox["TextAlignment", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Left", "MR"],
              " "
            }]], Cell["how to align text in the cell "]},
          {Cell[TextData[{
              StyleBox["FontSize", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["12", "MR"],
              " "
            }]], Cell["the point size of the font for text "]},
          {Cell[TextData[{
              StyleBox["CellTags", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{", "MR"],
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["tags to be associated with the cell "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.11.1"],

Cell["A few of the large number of possible options for cells. ", "Caption",
  CellTags->"S2.11.1"],

Cell[TextData[{
  "The standard notebook front end for ",
  StyleBox["Mathematica", "TI"],
  " provides several ways to change the options of a cell. In simple cases, \
such as changing the size or color of text, there will often be a specific \
menu item for the purpose. But in general you can use the ",
  StyleBox["option inspector", "TI"],
  " that is built into the front end. This is typically accessed using the ",
  StyleBox["Option Inspector", "SR"],
  " menu item in the ",
  StyleBox["Format", "SR"],
  " menu.   "
}], "Text",
  CellTags->{"S2.11.1", "1.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            Cell["\<\
\[FilledSmallSquare] Change settings for specific \
options with menus. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Look at and modify all options \
with the option inspector. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Edit the textual form of the \
expression corresponding to the cell. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Change the settings for all cells \
with a particular style. \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True}},
  CellTags->"S2.11.1"],

Cell["Ways to manipulate cells in the front end.", "Caption",
  CellTags->"S2.11.1"],

Cell[TextData[{
  "Sometimes you will want just to change the options associated with a \
specific cell. But often you may want to change the options associated with \
all cells in your notebook that have a particular style. You can do this by \
using the ",
  StyleBox["Edit Style Sheet", "SR"],
  " command in the front end to open up the style sheet associated with your \
notebook, and then modifying the options for the cells in this style sheet \
that represent the style you want to change.   "
}], "Text",
  CellTags->{"S2.11.1", "1.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CellPrint[Cell[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]]", "MR"],
              " "
            }]], Cell[
            "insert a cell into your currently selected notebook "]},
          {Cell[TextData[{
              StyleBox["CellPrint[{Cell[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["],", "MR"],
              " ",
              StyleBox["Cell[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], 
            Cell["\<\
insert a sequence of cells into your currently selected \
notebook \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.1"],

Cell["Inserting cells into a notebook. ", "Caption",
  CellTags->"S2.11.1"],

Cell["This inserts a section cell into the current notebook. ", "MathCaption",
  CellTags->{"S2.11.1", "1.13"}],

Cell[CellGroupData[{

Cell["CellPrint[Cell[\"The heading\", \"Section\"]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.11.1"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000@b000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o03<c<ol0<c<c2`0c<c<10?ooo`0000<0iNGU03<c<`0c<c<0o`0c<c?o03<c<`P0
<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0iNGUo`3UiND20>GUi@<0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooo40oooo1@000?l80?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo
00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=U
0?ooo`@00000o`3ooon<0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=T0?ooo`8000000P3oool200000?l0ooooR`3o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<cJ@3oool200000?l0ooooRP3oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c2`3oool9000000T0
oooo0P0000040?ooo`8000000`3oool2000000<0oooo0`0000080?ooo`8000000`3oool2000000<0
oooo0`0000040?ooo`L000000P3oool5000000030?ooo`00000000000080oooo0P0000030?ooo`80
00000`3oool500000?l0ooooRP3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c2`3oool9000000T0oooo0P0000040?oo
o`8000000`3oool200000080oooo0P0000000`3oool00000000000070?ooo`8000000`3oool20000
0080oooo0P0000000`3oool00000000000020?ooo`8000000P3oool300000080oooo0P0000001@3o
ool00000000000000000oooo008000000P3oool2000000<0oooo0P0000020?ooo`80000000@0oooo
0000000000000000o`3ooon:0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<;0?ooo`T000002@3oool2000000@0oooo
0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool00000
000000030?ooo`800000o`3ooon:0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<;0?ooo`T000002@3oool2000000@0
oooo0P0000030?ooo`80000000<0oooo0000000000002`3oool2000000<0oooo0P0000000`3oool0
0000000000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0
0000000000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?ooohX0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<`/0oooo2@0000090?ooo`800000103oool2000000<0oooo0P0000000`3o
ool0000000000005000000H0oooo0P0000030?ooo`80000000<0oooo0000000000001@0000020?oo
o`H0000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000030?oo
o`80000000<0oooo0000000000000`3oool200000?l0ooooRP3oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c2`3oool9
000000T0oooo0P0000040?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P000006
0?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000050?ooo`<0000000<0oooo
0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo
0000000000000`3oool200000?l0ooooRP3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c2`3oool9000000T0oooo0P00
00040?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3o
ool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0
oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`80000000<0
oooo0000000000000`3oool200000?l0ooooRP3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c2`3oool9000000T0oooo
0P0000040?ooo`<000000P3oool200000080oooo0P0000000`3oool00000000000070?ooo`<00000
0P3oool200000080oooo0P0000000`3oool00000000000020?ooo`8000000`3oool200000080oooo
0P0000001@3oool00000000000000000oooo008000000P3oool300000080oooo0P0000020?ooo`80
000000@0oooo0000000000000000o`3ooon:0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<;0?ooo`T000002@3oool2
000000@0oooo1P0000040?ooo`<00000203oool6000000@0oooo0`0000040?ooo`D00000103oool5
000000030?ooo`00000000000080oooo1P0000040?ooo`D00000o`3ooon:0?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<M0?ooo`800000103oool2000001<0oooo0P00000K0?ooo`800000o`3ooonN0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c<M0?ooo`800000103oool2000001<0oooo0P00000K0?ooo`800000o`3ooonK0?ooo`@0003o
203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<aX0
oooo200000000`3oool000000000000C0?ooo`8000006`3oool2000000030?ooo`00000000000?l0
ooooV`3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooa0?ooo`D0003o203oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
oP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VI
V@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT2
03<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo003o0>GUiOl0
iNGU2P3UiND103<c<`40oooo003o0?ooool0oooo303oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 67},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.1"]
}, Open  ]],

Cell["This inserts a text cell with a frame around it. ", "MathCaption",
  CellTags->{"S2.11.1", "1.14"}],

Cell[CellGroupData[{

Cell["CellPrint[Cell[\"Some text\", \"Text\", CellFrame->True]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.11.1"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000IB000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool00?l0<c<co`0c<c<;03<c<`40oooo00000`3UiND0<c<c
03<c<`3o03<c<ol0<c<c200c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c
<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VI
V@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GU
i@80iNGU0`2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
oP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<`d0ooooo`00003B000000`0oooo1@000?l20?ooo`D0003o1`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo00<00000
0?ooo`3oool0o`3oooo>0?ooo`030000003oool0oooo00h0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c3@3oool00`000000oooo0?ooo`3o0?ooolh0oooo00<000000?ooo`3oool03P3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`030000003oool0oooo0?l0oooo
cP3oool00`000000oooo0?ooo`0>0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0
oooo00<000000?ooo`3oool0o`3oooo>0?ooo`030000003oool0oooo00h0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool00`000000oooo0?ooo`3o0?ooolh0oooo00<000000?oo
o`3oool03P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`030000003oool0
oooo0?l0oooocP3oool00`000000oooo0?ooo`0>0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<`d0oooo00<000000?ooo`3oool0o`3oooo>0?ooo`030000003oool0oooo00h0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool00`000000oooo0?ooo`3o0?ooolh0oooo
00<000000?ooo`3oool03P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`03
0000003oool0oooo0?l0oooocP3oool00`000000oooo0?ooo`0>0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool0o`3oooo>0?ooo`030000003oool0oooo
00h0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool00`000000oooo0?ooo`3o
0?ooolh0oooo00<000000?ooo`3oool03P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<=0?ooo`030000003oool0oooo0?l0oooocP3oool00`000000oooo0?ooo`0>0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool01@3oool00`000000oooo
00000002000000<0oooo0`0000020?ooo`<0000000@0oooo000000000000oooo0P0000020?ooo`80
00001P3oool00`000000oooo0?ooo`0200000080oooo0P0000000`3oool00000000000020?ooo`03
0000003oool0oooo0?l0ooooV03oool00`000000oooo0?ooo`0>0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool01@3oool200000080oooo0P0000000`3o
ool000000?ooo`020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3o
ool000000?ooo`0000020?ooo`030000003oool0oooo0?l0ooooV@3oool00`000000oooo0?ooo`0>
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3o
ool000001P3oool01@000000oooo0?ooo`3oool000000?l0ooooV`3oool00`000000oooo0?ooo`0>
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool02@3o
ool2000000030?ooo`000000oooo0080oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000020?ooo`@00000103oool00`000000oooo0?ooo`04000000<0oooo00D000000?ooo`3o
ool0oooo0000003o0?oooi/0oooo00<000000?ooo`3oool03P3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<=0?ooo`030000003oool0oooo00L0oooo0`0000020?ooo`050000003oool0
oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`060000003oool0oooo
0000003oool000000P3oool00`000000oooo0?ooo`3o0?oooiT0oooo00<000000?ooo`3oool03P3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`030000003oool0oooo00H0oooo
0P0000050?ooo`<000000P3oool01@000000oooo000000000000oooo00800000103oool2000000@0
oooo0`0000020?ooo`8000000P3oool2000000030?ooo`000000000000<00000o`3ooonJ0?ooo`03
0000003oool0oooo00h0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo0?l0ooooV@3oool00`000000oooo0?ooo`0>0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool01@3oool0
10000000oooo0?ooo`3oool200000?l0oooo``3oool00`000000oooo0?ooo`0>0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool01P3oool3000000030?oo
o`000000oooo0?l0oooo`P3oool00`000000oooo0?ooo`0>0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool0o`3oooo>0?ooo`030000003oool0oooo00h0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool00`000000oooo0?ooo`3o0?oo
olh0oooo00<000000?ooo`3oool03P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=
0?ooo`030000003oool0oooo0?l0oooocP3oool00`000000oooo0?ooo`0>0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool0o`3oooo>0?ooo`030000003o
ool0oooo00h0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool00`000000oooo
0?ooo`3o0?ooolh0oooo00<000000?ooo`3oool03P3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<=0?ooo`030000003oool0oooo0?l0oooocP3oool00`000000oooo0?ooo`0>0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool0o`3oooo>0?oo
o`030000003oool0oooo00h0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool0
0`000000oooo0?ooo`3o0?ooolh0oooo00<000000?ooo`3oool03P3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<=0?ooo`030000003oool0oooo0?l0oooocP3oool00`000000oooo0?oo
o`0;0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool00`000000oooo0?ooo`3o0?ooolh0oooo
00<000000?ooo`3oool03P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooool0
0000dP00000<0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo[0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<fH0oooo1000003o0?ooohD0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cI@3oool200000080oooo0P00003o0?oooh@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cJP3oool200000?l0ooooP`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?ooo`T000002@3oool2000000@0oooo0P0000030?oo
o`8000000`3oool3000000P0oooo0P0000030?ooo`8000000`3oool3000000@0oooo1`0000020?oo
o`D0000000<0oooo0000000000000P3oool2000000<0oooo0P0000030?ooo`D00000o`3ooon30?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo2@0000090?ooo`800000103oool2
000000<0oooo0P0000020?ooo`80000000<0oooo0000000000001`3oool2000000<0oooo0P000002
0?ooo`80000000<0oooo0000000000000P3oool200000080oooo0`0000020?ooo`80000000D0oooo
00000000000000000?ooo`0200000080oooo0P0000030?ooo`8000000P3oool2000000040?ooo`00
0000000000000?l0ooooP`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?ooo`T0
00002@3oool2000000@0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0
oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0P0000000`3oool00000000000030?ooo`800000o`3ooon30?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<``0oooo2@0000090?ooo`800000103oool2000000<0oooo0P0000000`3o
ool000000000000;0?ooo`8000000`3oool2000000030?ooo`000000000000H0oooo0P0000030?oo
o`80000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000030?oo
o`80000000<0oooo0000000000000`3oool200000?l0ooooP`3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<<0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`80000000<0oooo
0000000000001@0000060?ooo`8000000`3oool2000000030?ooo`000000000000D000000P3oool6
000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2
000000030?ooo`000000000000<0oooo0P00003o0?oooh<0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c303oool9000000T0oooo0P0000040?ooo`8000000`3oool2000000030?ooo`00
0000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
00050?ooo`<0000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P00
00030?ooo`80000000<0oooo0000000000000`3oool200000?l0ooooP`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<<0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo000000000000
0`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`800000
00<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000
o`3ooon30?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo2@0000090?ooo`80
0000103oool300000080oooo0P0000020?ooo`80000000<0oooo0000000000001`3oool300000080
oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000020?ooo`80
000000D0oooo00000000000000000?ooo`0200000080oooo0`0000020?ooo`8000000P3oool20000
00040?ooo`000000000000000?l0ooooP`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<<0?ooo`T000002@3oool2000000@0oooo1P0000040?ooo`<00000203oool6000000@0oooo0`00
00040?ooo`D00000103oool5000000030?ooo`00000000000080oooo1P0000040?ooo`D00000o`3o
oon30?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ah0oooo0P0000040?ooo`800000
4`3oool2000001/0oooo0P00003o0?oooiL0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c7P3oool2000000@0oooo0P00000C0?ooo`8000006`3oool200000?l0ooooU03oool40000o`H0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<a/0oooo200000000`3oool000000000000C0?ooo`8000006`3oool20000
00030?ooo`00000000000?l0ooooU03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooon/0oooo1@000?l20?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c
<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3U
iND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0
VIVI1P2IVIT203<c<`40oooo003o0>GUiOl0iNGU2P3UiND103<c<`40oooo003o0?ooool0oooo303o
ool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 101},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["CellPrint", "MR"],
  " allows you to take a raw ",
  StyleBox["Cell", "MR"],
  " expression and insert it into your current notebook. Sometimes, however, \
you may find it more convenient to give an ordinary ",
  StyleBox["Mathematica", "TI"],
  " expression, and then have ",
  StyleBox["Mathematica", "TI"],
  " convert it into a ",
  StyleBox["Cell", "MR"],
  " of a certain style, and insert this cell into a notebook. You can do this \
using the function ",
  StyleBox["StylePrint", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.11.1", "1.15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StylePrint[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["style", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "create a new cell of the specified style, and write ",
              StyleBox["expr", "TI"],
              " into it "
            }]]},
          {Cell[TextData[{
              StyleBox["StylePrint[", "MR"],
              StyleBox["contents", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["style", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["options", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["use the specified options for the new cell "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.1"],

Cell["Writing expressions into cells with specified styles. ", "Caption",
  CellTags->"S2.11.1"],

Cell["\<\
This inserts a cell in section style into your current notebook. \
\
\>", "MathCaption",
  CellTags->{"S2.11.1", "1.16"}],

Cell[CellGroupData[{

Cell["StylePrint[\"The heading\", \"Section\"]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.11.1"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000>b000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool`3oool50000o`D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c=W0?ooo`@00000o`3ooon<0?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<fH0
oooo0P0000020?ooo`800000o`3ooon;0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f/0oooo0P00003o0?ooohX0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c3@3oool9000000T0oooo0P0000040?ooo`8000000`3oool2000000<0
oooo0`0000080?ooo`8000000`3oool2000000<0oooo0`0000040?ooo`L000000P3oool500000003
0?ooo`00000000000080oooo0P0000030?ooo`8000000`3oool500000?l0ooooRP3oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<=0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`8000000P3oool200000003
0?ooo`000000000000L0oooo0P0000030?ooo`8000000P3oool2000000030?ooo`00000000000080
oooo0P0000020?ooo`<000000P3oool2000000050?ooo`00000000000000003oool00P0000020?oo
o`8000000`3oool200000080oooo0P000000103oool0000000000000003o0?ooohX0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c3@3oool9000000T0oooo0P0000040?ooo`8000000`3oool2000000030?ooo`000000
000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P000000
0`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000
00000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool200000?l0ooooRP3oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<=0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`80000000<0oooo
0000000000002`3oool2000000<0oooo0P0000000`3oool00000000000060?ooo`8000000`3oool2
000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2
000000030?ooo`000000000000<0oooo0P00003o0?ooohX0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool9
000000T0oooo0P0000040?ooo`8000000`3oool2000000030?ooo`000000000000D000001P3oool2
000000<0oooo0P0000000`3oool000000000000500000080oooo1P0000000`3oool0000000000003
0?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool0000000000003
0?ooo`800000o`3ooon:0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`d0oooo2@0000090?ooo`800000103oool2
000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2000000<0oooo0P000000
0`3oool00000000000030?ooo`8000001@3oool3000000030?ooo`000000000000<0oooo0P000000
0`3oool00000000000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00003o
0?ooohX0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool9000000T0oooo0P0000040?ooo`8000000`3oool2
000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000
000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2
000000030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2
00000?l0ooooRP3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`T000002@3oool2000000@0oooo0`000002
0?ooo`8000000P3oool2000000030?ooo`000000000000L0oooo0`0000020?ooo`8000000P3oool2
000000030?ooo`00000000000080oooo0P0000030?ooo`8000000P3oool2000000050?ooo`000000
00000000003oool00P0000020?ooo`<000000P3oool200000080oooo0P000000103oool000000000
0000003o0?ooohX0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool9000000T0oooo0P0000040?ooo`H00000
103oool3000000P0oooo1P0000040?ooo`<00000103oool5000000@0oooo1@0000000`3oool00000
000000020?ooo`H00000103oool500000?l0ooooRP3oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<O0?ooo`800000
103oool2000001<0oooo0P00000K0?ooo`800000o`3ooonN0?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<al0oooo
0P0000040?ooo`8000004`3oool2000001/0oooo0P00003o0?oooi/0oooo10000?l50?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<L0?ooo`P00000
00<0oooo0000000000004`3oool2000001/0oooo0P0000000`3oool000000000003o0?oooi/0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3ooooc0?ooo`D0003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@40iNGU0@0c<c<10?oo
o`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3oool00?l0ooooo`3oool<0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 59},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.1"]
}, Open  ]],

Cell["This creates several cells in output style. ", "MathCaption",
  CellTags->{"S2.11.1", "1.17"}],

Cell[CellGroupData[{

Cell["Do[StylePrint[Factor[x^i - 1], \"Output\"], {i, 7, 10}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.11.1"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000/B000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<803<c<`80oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c1`0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@D0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0`2IVIT203<c
<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo03oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo03oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0VIVI09VIV@2IVIT203<c
<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooZ0?ooo`D0
003o0P3oool50000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooookP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0
oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`1`0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c=@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo06/0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo06l0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<d0?ooo`030000003oool0oooo00T0
oooo1@00000>0?ooo`8000000`3oool2000000<0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`020?ooo`D000003@3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool00P3oool5000000h0oooo0P0000030?ooo`8000003@3oool2000000<0
oooo0P00000C0?ooo`8000000`3oool2000001<0oooo0P0000030?ooo`8000002@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo0080oooo1@00000>0?ooo`8000000`3oool2000000d0
oooo0P0000030?ooo`8000004`3oool2000000<0oooo0P00000C0?ooo`8000000`3oool2000000T0
oooo00<000000?ooo`3oool0KP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c@0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0
oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00D000000?oo
o`3oool0oooo000000040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0?0?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?oo
o`050?ooo`050000003oool0oooo0?ooo`0000005@3oool01@000000oooo0?ooo`3oool0000000d0
oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000X0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01@3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool01@3oool0
1@000000oooo0?ooo`3oool0000000d0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?oo
o`3oool0000000d0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000X0
oooo00<000000?ooo`3oool0KP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c@0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000D0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0100
oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`060?ooo`030000003oool0000001L0
oooo00<000000?ooo`0000003P3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000/0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01P3oool00`000000oooo000000080?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`0000003P3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000h0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000;0?ooo`030000003oool0oooo06h0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<d0?ooo`030000003oool0oooo0080
oooo1@0000040?ooo`030000003oool0oooo00D0oooo1@0000070?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0
oooo1@0000060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo1@0000070?ooo`030000003oool0oooo00D0
oooo1@0000070?ooo`030000003oool0oooo00/0oooo1@0000070?ooo`030000003oool0oooo00/0
oooo1@0000070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo1@0000070?ooo`030000003oool0oooo00D0
oooo1@0000070?ooo`030000003oool0oooo00/0oooo1@0000070?ooo`030000003oool0oooo00/0
oooo1@0000070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0KP3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c@0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000001@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo0100oooo00<000000?ooo`000000203oool00`000000
oooo0?ooo`060?ooo`030000003oool0000001L0oooo00<000000?ooo`0000003P3oool00`000000
oooo0?ooo`060?ooo`030000003oool0000000/0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000
oooo000000080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000003P3oool00`000000
oooo0?ooo`060?ooo`030000003oool0000000h0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0000000;0?ooo`030000003oool0oooo06h0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<d0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`040?ooo`<0000000@0oooo00000000000000000`3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`030?oo
o`<0000000@0oooo00000000000000000`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool03P3oool3000000040?ooo`0000000000000000H0oooo00<0
00000?ooo`3oool0103oool3000000040?ooo`0000000000000001<0oooo0`000000103oool00000
00000000000<0?ooo`030000003oool0oooo00@0oooo0`000000103oool000000000000000090?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00@0oooo0`000000103oool000000000000000060?ooo`030000003oool0
oooo00@0oooo0`000000103oool0000000000000000<0?ooo`030000003oool0oooo00@0oooo0`00
0000103oool0000000000000000<0?ooo`030000003oool0oooo00@0oooo0`000000103oool00000
0000000000090?ooo`030000003oool0oooo06h0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<e0?ooo`030000003oool0oooo00P0oooo0`00000I0?ooo`030000003oool0oooo00T0
oooo00@000000?ooo`3oool0oooo0`00000H0?ooo`030000003oool0oooo00T0oooo00@000000?oo
o`3oool0oooo0`00000/0?ooo`@000005@3oool3000001T0oooo0`0000030?ooo`030000003oool0
oooo00T0oooo00@000000?ooo`3oool0oooo0`00000/0?ooo`@000005@3oool3000001T0oooo0`00
00030?ooo`030000003oool0oooo06`0oooo10000?l60?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0Z0?ooo`8000006P3oool00`000000oooo0?oo
o`0G0?ooo`050000003oool0oooo0?ooo`0000003@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo02X0oooo0P00000J0?ooo`030000003oool0oooo01L0oooo00D000000?ooo`3oool0
oooo0000001b0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cb03oool00`000000
oooo0?ooo`0E0?ooo`800000603oool4000004@0oooo00<000000?ooo`3oool05@3oool2000001P0
oooo1000001d0?ooo`80003o1P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?90?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool05@3oool00`000000oooo000000160?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool05@3oool00`000000oooo0000001d0?ooo`030000o`3oool0003o00H0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<caP3oool010000000oooo0?ooo`00000E0?ooo`040000003oool0oooo
000001P0oooo0P0000130?ooo`040000003oool0oooo000001D0oooo00@000000?ooo`3oool00000
603oool2000007<0oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?70?ooo`80
00005`3oool2000001X0oooo00<000000?ooo`3oool0@P3oool2000001L0oooo0P00000J0?ooo`03
0000003oool0oooo0700oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooj@3oool60000o`H0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0oooom@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<2
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ooD0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooZ0?ooo`D0003o1P3oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooonh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<f0?oo
o`030000003oool0oooo0280oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0e0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`3m0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=@3oool00`000000oooo0?ooo`0T0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo03d0oooo00<000000?ooo`3oool0o03oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<c@0oooo00<000000?ooo`3oool02@3oool5000000h0oooo0P0000030?oo
o`8000000`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo1@00000=0?oo
o`8000000`3oool2000000d0oooo0P0000030?ooo`8000002P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo0080oooo1@00000=0?ooo`8000000`3oool2000001<0oooo0P0000030?oo
o`8000002P3oool00`000000oooo0?ooo`3k0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c=03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01@3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool0
1@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?oo
o`3oool0000000/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000d0
oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?oo
o`3oool0n`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c@0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`0000001@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000P0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0000000<0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`0000003P3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000`0oooo00<000000?oo
o`3oool0n`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c@0oooo00<000000?oo
o`3oool00P3oool5000000@0oooo00<000000?ooo`3oool01@3oool5000000L0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool01@3oool5000000H0oooo00<000000?ooo`3oool01@3oool5000000L0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0103oool5000000L0oooo00<000000?ooo`3oool02`3oool5000000L0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`3k0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c=03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01P3oool00`000000oooo000000050?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`000000203oool00`000000oooo0?ooo`060?ooo`030000003oool0000000`0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0000000>0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`000000303oool00`000000oooo0?ooo`3k0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c=03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0103oool3000000040?ooo`0000000000000000<0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool3
000000040?ooo`0000000000000000H0oooo00<000000?ooo`3oool0103oool3000000040?ooo`00
00000000000000X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0103oool3000000040?ooo`0000000000000000`0
oooo00<000000?ooo`3oool0103oool3000000040?ooo`0000000000000000X0oooo00<000000?oo
o`3oool0n`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cD0oooo00<000000?oo
o`3oool0203oool3000001T0oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`3oool3
000002/0oooo100000040?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool0oooo0`00
000F0?ooo`<000006@3oool2000000D0oooo00<000000?ooo`3oool0n@3oool40000o`H0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c=P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02T0oooo0P00
00050?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01D0oooo00@000000?ooo`3oool000000`3oool00`000000oooo
0?ooo`3m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI
09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cW03oool00`000000oooo
0?ooo`0]0?ooo`800000603oool010000000oooo0?ooo`00003o0?ooo`<0oooo0P000?l60?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<id0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0E0?ooo`<0
0000o`3oool30?ooo`030000o`3oool0003o00H0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cVP3oool010000000
oooo0?ooo`00000]0?ooo`040000003oool0oooo000001P0oooo00<000000?ooo`3oool0o`3oool1
0?ooo`040000o`3oool0oooo0000o`H0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cV`3oool2000002l0oooo0P00
000J0?ooo`800000o`3oool01@000?l0oooo0?ooo`3oool0003o00H0oooo00<0003o0?ooo`3oool0
103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3ooooY0?ooo`H0003o1P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0
103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3ooooe0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`040?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo
0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI
09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000
o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonX0oooo1@000?l60?ooo`030000
o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooookP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo
00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01X0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`3o0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c=@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0703oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02@0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0?h0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<d0?ooo`030000003oool0oooo00T0oooo
1@00000>0?ooo`8000000`3oool2000000<0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`020?ooo`D000003@3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool00P3oool5000000h0oooo0P0000030?ooo`8000002P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0080oooo1@00000=0?ooo`8000000`3oool2000000X0oooo
00<000000?ooo`3oool0o@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c@0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000000;
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003o
ool0oooo0?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<d0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0000000D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo000000050?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`000000303oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0000000`0oooo00<000000?ooo`3oool0o@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<c@0oooo00<000000?ooo`3oool00P3oool5000000@0oooo00<000000?ooo`3oool01@3o
ool5000000L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01@3oool5000000H0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3o
ool5000000L0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0103oool5000000L0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`3m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=03o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo000000050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000001@3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0000000`0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0000000<0?ooo`030000003oool0oooo0?d0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<d0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`040?ooo`<0000000@0oooo00000000000000000`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`030?ooo`<0000000@0oooo00000000000000000`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`<0
000000@0oooo00000000000000002P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`<0000000@0oooo0000
0000000000002P3oool00`000000oooo0?ooo`3m0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c=@3oool00`000000oooo0?ooo`080?ooo`<000006@3oool00`000000oooo0?ooo`09
0?ooo`040000003oool0oooo0?ooo`<00000603oool00`000000oooo0?ooo`090?ooo`040000003o
ool0oooo0?ooo`<00000603oool4000000@0oooo00<000000?ooo`3oool02@3oool010000000oooo
0?ooo`3oool3000001P0oooo0`0000040?ooo`030000003oool0oooo0?/0oooo10000?l60?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<cH0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0E0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0F0?ooo`80
00001@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c>d0?ooo`030000003oool0oooo02d0oooo1000003o0?ooo`D0
oooo0P000?l60?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<kD0oooo00<000000?ooo`3oool0;03oool00`000000
oooo0000003o0?ooo`D0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>b0?ooo`04
0000003oool0oooo000002l0oooo0P00003o0?ooo`@0oooo00@0003o0?ooo`3oool0003o1P3oool0
0`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c>c0?ooo`800000<@3oool00`000000oooo0?ooo`3o0?ooo`40oooo00D0003o
0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj@3oool60000o`H0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
oooe0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3ooooZ0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonh0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<f0?ooo`030000003oool0oooo0280oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`2M0?ooo`030000003oool0oooo0>40oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<e0?ooo`030000003oool0oooo02@0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo0>00oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<d0?ooo`030000003oool0oooo00T0oooo1@00
000>0?ooo`8000000`3oool2000000<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`020?ooo`D000003@3oool2000000<0oooo0P00000=0?ooo`8000000`3oool2000001<0oooo0P00
00030?ooo`8000004`3oool2000000<0oooo0P00000C0?ooo`8000000`3oool2000001<0oooo0P00
00030?ooo`8000002P3oool00`000000oooo0?ooo`3O0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c=03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
103oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool01@3oool01@000000
oooo0?ooo`3oool0000000d0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0
000000d0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000d0oooo00<0
00000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3oool0
103oool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool0g`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c@0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000001@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0000000>0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000003P3oool00`000000
oooo0?ooo`060?ooo`030000003oool0000000h0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0000000?0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`000000303oool00`000000
oooo0?ooo`3O0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=03oool00`000000
oooo0?ooo`020?ooo`D00000103oool00`000000oooo0?ooo`050?ooo`D000001`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`050?ooo`D000001P3oool00`000000oooo0?ooo`050?ooo`D000001`3oool00`000000
oooo0?ooo`0;0?ooo`D000001`3oool00`000000oooo0?ooo`0;0?ooo`D000001`3oool00`000000
oooo0?ooo`0;0?ooo`D000001`3oool00`000000oooo0?ooo`0<0?ooo`D000001P3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo0=l0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<d0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000
oooo000000080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000003P3oool00`000000
oooo0?ooo`060?ooo`030000003oool0000000h0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0000000>0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000003`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0000000`0oooo00<000000?ooo`3oool0g`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c@0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo0`000000103oool000000000000000030?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00<0oooo0`000000103oool000000000000000060?ooo`030000003oool0
oooo00@0oooo0`000000103oool0000000000000000<0?ooo`030000003oool0oooo00@0oooo0`00
0000103oool0000000000000000<0?ooo`030000003oool0oooo00@0oooo0`000000103oool00000
00000000000<0?ooo`030000003oool0oooo00@0oooo0`000000103oool0000000000000000=0?oo
o`030000003oool0oooo00<0oooo0`000000103oool0000000000000000:0?ooo`030000003oool0
oooo0=l0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<e0?ooo`030000003oool0
oooo00P0oooo0`00000I0?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool0oooo0`00
000[0?ooo`@000005@3oool3000001T0oooo0`00000F0?ooo`<00000603oool2000000D0oooo00<0
00000?ooo`3oool0g@3oool40000o`H0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo02T0oooo0P00000J0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0D0?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool0h@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<i`0oooo
00<000000?ooo`3oool05@3oool2000001P0oooo1000000I0?ooo`030000003oool0oooo01@0oooo
00@000000?ooo`3oool00000iP3oool20000o`H0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cW@3oool00`000000
oooo0?ooo`0F0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`0000005`3oool3000001L0
oooo0`00003V0?ooo`030000o`3oool0003o00H0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cVP3oool010000000
oooo0?ooo`00000E0?ooo`040000003oool0oooo000001P0oooo0P00000G0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0i03oool010000?l0oooo0?ooo`000?l60?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<i/0oooo0P00000G0?ooo`8000006P3oool00`000000oooo0?ooo`0E0?ooo`<000006@3o
ool200000><0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
j@3oool60000o`H0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI
09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000
o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0
103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3ooooe0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`040?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo
0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
jP3oool50000o`H0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo^0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<cI@3oool400000?l0ooooQ@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<f@0oooo0P0000020?ooo`800000o`3ooon40?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<cJ@3oool200000?l0ooooP`3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<`/0oooo2@0000090?ooo`800000103oool2000000<0oooo0P0000030?ooo`<00000
203oool2000000<0oooo0P0000030?ooo`<00000103oool700000080oooo1@0000000`3oool00000
000000020?ooo`8000000`3oool2000000<0oooo1@00003o0?oooh<0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<;0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`800000
0P3oool2000000030?ooo`000000000000L0oooo0P0000030?ooo`8000000P3oool2000000030?oo
o`00000000000080oooo0P0000020?ooo`<000000P3oool2000000050?ooo`00000000000000003o
ool00P0000020?ooo`8000000`3oool200000080oooo0P000000103oool0000000000000003o0?oo
oh<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<;0?ooo`T000002@3oool20000
00@0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?oo
o`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3o
ool00000000000030?ooo`800000o`3ooon30?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c2`3oool9000000T0oooo0P0000040?ooo`8000000`3oool2000000030?ooo`0000000000
00/0oooo0P0000030?ooo`80000000<0oooo0000000000001P3oool2000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3o
ool00000000000030?ooo`800000o`3ooon30?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c2`3oool9000000T0oooo0P0000040?ooo`8000000`3oool2000000030?ooo`0000000000
00D000001P3oool2000000<0oooo0P0000000`3oool000000000000500000080oooo1P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3o
ool00000000000030?ooo`800000o`3ooon30?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c2`3oool9000000T0oooo0P0000040?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000050?oo
o`<0000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000030?oo
o`80000000<0oooo0000000000000`3oool200000?l0ooooP`3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<`/0oooo2@0000090?ooo`800000103oool2000000<0oooo0P0000000`3o
ool00000000000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?oo
oh<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<;0?ooo`T000002@3oool20000
00@0oooo0`0000020?ooo`8000000P3oool2000000030?ooo`000000000000L0oooo0`0000020?oo
o`8000000P3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`8000000P3oool20000
00050?ooo`00000000000000003oool00P0000020?ooo`<000000P3oool200000080oooo0P000000
103oool0000000000000003o0?oooh<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<;0?ooo`T000002@3oool2000000@0oooo1P0000040?ooo`<00000203oool6000000@0oooo0`00
00040?ooo`D00000103oool5000000030?ooo`00000000000080oooo1P0000040?ooo`D00000o`3o
oon30?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c7@3oool2000000@0oooo0P00
000C0?ooo`8000006`3oool200000?l0ooooU`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ad0oooo0P0000040?ooo`8000004`3oool2000001/0oooo0P00003o0?oooi@0oooo1000
0?l60?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<aX0oooo200000000`3oool000000000000C0?ooo`8000006`3o
ool2000000030?ooo`00000000000?l0ooooU03oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooojP3oool50000o`80oooo1@000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0VIVI09VI
V@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03o
ool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
oool0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo03oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?n03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?n03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT509VIV@80<c<c0P3oool000030?ooo`3UiND0
VIVI0?l0VIVIo`2IVIT509VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT509VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT509VIV@030>GUi@0c<c<0oooo0040
oooo00000`3oool0iNGU0>GUi@3o0>GUiOl0iNGU1`3UiND20?ooo`00o`3ooooo0?ooo``0oooo0000
\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 177},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.1"]
}, Open  ]],

Cell[TextData[{
  "You can use any cell options in ",
  StyleBox["StylePrint", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.11.1", "1.18"}],

Cell[CellGroupData[{

Cell["\<\
StylePrint[\"Another heading\", \"Section\", CellFrame->True, \
FontSize->28]\
\>", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.11.1"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:000102000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool00080ooooo`0c<c?o03<c<`T0<c<c0@3oool000030?oo
o`3UiND0iNGU0?l0<c<co`0c<c<803<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0
iNGUo`3UiND10>GUi@<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<K0?ooool00000d`0000050?ooo`D0003o1@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6`3oool00`000000oooo
0?ooo`3o0?oooll0oooo00<000000?ooo`3oool01`3oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<K0?ooo`030000
003oool0oooo0?l0ooooc`3oool00`000000oooo0?ooo`070?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo
00<000000?ooo`3oool0o`3oooo?0?ooo`030000003oool0oooo00L0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
6`3oool00`000000oooo0?ooo`3o0?oooll0oooo00<000000?ooo`3oool01`3oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<K0?ooo`030000003oool0oooo0?l0ooooc`3oool00`000000oooo0?ooo`070?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<a/0oooo00<000000?ooo`3oool0o`3oooo?0?ooo`030000003oool0oooo00L0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c6`3oool00`000000oooo0?ooo`3o0?oooll0oooo00<000000?ooo`3oool0
1`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<K0?ooo`030000003oool0oooo0?l0ooooc`3oool00`000000oooo
0?ooo`070?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo00<000000?ooo`3oool0`@3oool700000?l0oooo
1`3oool00`000000oooo0?ooo`070?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo00<000000?ooo`3oool0
`03oool900000?l0oooo1P3oool00`000000oooo0?ooo`070?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo
00<000000?ooo`3oool0_`3oool4000000<0oooo1000003o0?ooo`D0oooo00<000000?ooo`3oool0
1`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<K0?ooo`030000003oool0oooo0;l0oooo0`0000050?ooo`<00000
o`3oool50?ooo`030000003oool0oooo00L0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6`3oool00`000000oooo
0?ooo`380?ooo`<00000o`3oool40?ooo`030000003oool0oooo00L0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
6`3oool00`000000oooo0?ooo`380?ooo`<00000o`3oool40?ooo`030000003oool0oooo00L0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c1P3ooolA000000@0oooo00<000000?ooo`3oool01@3oool3000000X0oooo
0`0000020?ooo`<000001@3oool3000000L0oooo1P0000080?ooo`@000000P3oool3000000D0oooo
0`0000070?ooo`H000001P3oool3000000l0oooo0`0000050?ooo`<000001`3oool6000000P0oooo
1@0000020?ooo`<000001P3oool5000000040?ooo`0000000000000000<0oooo0`0000040?ooo`<0
00001@3oool3000000L0oooo1@000000103oool0000000000000003o0?ooo`@0oooo00<000000?oo
o`3oool01`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<60?oooa400000103oool00`000000oooo0?ooo`050?oo
o`@00000203oool400000080oooo0`0000050?ooo`<000001P3oool8000000H0oooo1@0000020?oo
o`<000001@3oool3000000H0oooo200000050?ooo`<000003`3oool3000000D0oooo0`0000060?oo
o`P000001P3oool;000000D0oooo2P0000030?ooo`<00000103oool3000000D0oooo0`0000060?oo
o`X00000o`3oool40?ooo`030000003oool0oooo00L0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1P3ooolA0000
00@0oooo00<000000?ooo`3oool01P3oool3000000P0oooo0`0000030?ooo`<000001@3oool30000
00D0oooo100000020?ooo`@000001@3oool3000000@0oooo0`0000050?ooo`<000001@3oool40000
0080oooo100000040?ooo`<000003`3oool3000000D0oooo0`0000050?ooo`@000000P3oool40000
00@0oooo100000020?ooo`D000001@3oool400000080oooo1@0000030?ooo`<00000103oool30000
00D0oooo0`0000050?ooo`@000000P3oool500000?l0oooo103oool00`000000oooo0?ooo`070?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<`H0oooo4@0000040?ooo`030000003oool0oooo00H0oooo0`0000080?oo
o`<000000`3oool3000000D0oooo0`0000050?ooo`<00000103oool3000000D0oooo0`0000040?oo
o`<000001@3oool3000000D0oooo0`0000040?ooo`@000000`3oool3000000l0oooo0`0000050?oo
o`<000001@3oool3000000@0oooo100000030?ooo`<00000103oool4000000D0oooo0`0000040?oo
o`@000000`3oool3000000@0oooo0`0000050?ooo`<000001@3oool3000000@0oooo1000003o0?oo
o`@0oooo00<000000?ooo`3oool01`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<60?oooa400000103oool00`00
0000oooo0?ooo`060?ooo`@000001P3oool4000000<0oooo0`0000050?ooo`<00000103oool30000
00D0oooo100000040?ooo`<00000103oool3000000D0oooo0`0000040?ooo`<000001P3oool30000
00<0oooo0`00000?0?ooo`<000001@3oool3000000@0oooo0`0000060?ooo`<000000`3oool30000
00D0oooo0`0000040?ooo`<000001P3oool3000000<0oooo0`0000040?ooo`<000001@3oool30000
00@0oooo0`0000060?ooo`<00000o`3oool40?ooo`030000003oool0oooo00L0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c1P3ooolA000000@0oooo00<000000?ooo`3oool01`3oool3000000H0oooo0`0000040?oo
o`<000001@3oool3000000@0oooo0`0000060?ooo`<00000103oool3000000@0oooo0`0000050?oo
o`<00000103oool3000000`0oooo0`00000?0?ooo`<000001@3oool3000000@0oooo0`00000<0?oo
o`<000001@3oool3000000@0oooo0`0000060?ooo`<000000`3oool3000000@0oooo0`0000050?oo
o`<00000103oool3000000H0oooo0`00003o0?ooo`@0oooo00<000000?ooo`3oool01`3oool00`00
0?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<60?oooa400000103oool00`000000oooo0?ooo`070?ooo``00000103oool30000
00D0oooo0`0000040?ooo`<000001P3oool3000000@0oooo0`0000040?ooo`<000001@3oool30000
00@0oooo0`00000<0?ooo`<000003`3oool3000000D0oooo0`0000040?ooo`<000003@3oool40000
00<0oooo0`0000040?ooo`<000001P3oool3000000<0oooo0`0000040?ooo`<000001@3oool30000
00@0oooo0`0000060?ooo`<00000o`3oool40?ooo`030000003oool0oooo00L0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c1P3ooolA000000@0oooo00<000000?ooo`3oool01`3oool<000000@0oooo0`0000050?oo
o`<00000103oool3000000H0oooo0`0000040?ooo`<00000103oool3000000D0oooo0`0000040?oo
o``000000`3oool3000000l0oooo0`0000050?ooo`<00000103oool<000000@0oooo2P0000040?oo
o`<000001P3oool3000000<0oooo0`0000040?ooo`<000001@3oool3000000@0oooo0`0000060?oo
o`<00000o`3oool40?ooo`030000003oool0oooo00L0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1P3ooolA0000
00@0oooo00<000000?ooo`3oool0203oool3000000@0oooo0`0000050?ooo`<000001@3oool30000
00@0oooo0`0000060?ooo`<00000103oool3000000@0oooo0`0000050?ooo`<00000103oool<0000
00<0oooo0`00000?0?ooo`<000001@3oool3000000@0oooo300000060?ooo`P00000103oool30000
00H0oooo0`0000030?ooo`<00000103oool3000000D0oooo0`0000040?ooo`<000001P3oool30000
0?l0oooo103oool00`000000oooo0?ooo`070?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`H0oooo4@0000040?oo
o`030000003oool0oooo00P0oooo0`0000040?ooo`<000001@3oool3000000D0oooo0`0000040?oo
o`<000001P3oool3000000@0oooo0`0000040?ooo`<000001@3oool3000000@0oooo0`0000060?oo
o`<000000`3oool3000000l0oooo0`0000050?ooo`<00000103oool3000000H0oooo0`00000;0?oo
o`<00000103oool3000000H0oooo0`0000030?ooo`<00000103oool3000000D0oooo0`0000040?oo
o`<000001P3oool300000?l0oooo103oool00`000000oooo0?ooo`070?ooo`030000o`3oool0oooo
00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<`H0oooo4@0000040?ooo`030000003oool0oooo00P0oooo0`0000040?ooo`<000001@3oool30000
00D0oooo0`0000040?ooo`<000001P3oool3000000@0oooo0`0000040?ooo`<000001@3oool30000
00@0oooo0`0000060?ooo`<000000`3oool3000000l0oooo0`0000050?ooo`<00000103oool30000
00H0oooo0`0000040?ooo`<00000103oool3000000@0oooo0`0000060?ooo`<000000`3oool30000
00@0oooo0`0000050?ooo`<00000103oool3000000H0oooo0`00003o0?ooo`@0oooo00<000000?oo
o`3oool01`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<60?oooa400000103oool00`000000oooo0?ooo`090?oo
o`<000000P3oool3000000H0oooo100000040?ooo`<000001@3oool3000000@0oooo0`0000050?oo
o`<00000103oool4000000@0oooo0`0000050?ooo`<00000103oool3000000@0oooo1000000>0?oo
o`@00000103oool3000000D0oooo0`0000040?ooo`<000001@3oool3000000@0oooo0`0000050?oo
o`<00000103oool4000000<0oooo0`0000040?ooo`@00000103oool3000000D0oooo0`0000040?oo
o`@00000o`3oool40?ooo`030000003oool0oooo00L0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1P3ooolA0000
00@0oooo00<000000?ooo`3oool02@3oool300000080oooo0`0000060?ooo`D000000P3oool40000
00D0oooo100000020?ooo`@000001@3oool3000000@0oooo1@0000020?ooo`@000001@3oool40000
0080oooo100000040?ooo`D000003@3oool500000080oooo100000050?ooo`@000000P3oool40000
00D0oooo100000020?ooo`@000001@3oool400000080oooo1@0000030?ooo`<00000103oool50000
0080oooo100000050?ooo`@000000P3oool500000?l0oooo103oool00`000000oooo0?ooo`070?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<`H0oooo4@0000040?ooo`030000003oool0oooo00T0oooo0`0000020?oo
o`<000001P3oool:000000L0oooo200000040?ooo`L000000P3oool:000000L0oooo200000050?oo
o`L000002`3oool:000000L0oooo200000070?ooo`P000001`3oool:000000<0oooo0`0000040?oo
o`X000001`3oool:00000?l0oooo103oool00`000000oooo0?ooo`070?ooo`030000o`3oool0oooo
00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<`H0oooo4@0000040?ooo`030000003oool0oooo00X0oooo1P0000070?ooo`<0000000<0oooo0000
000000000`0000090?ooo`H000001@3oool700000080oooo0`0000000`3oool00000000000030000
00T0oooo1P0000060?ooo`<0000000@0oooo00000000000000002`3oool3000000030?ooo`000000
000000<000002@3oool6000000T0oooo1P0000090?ooo`D0000000@0oooo00000000000000000`3o
ool3000000@0oooo0`0000000`3oool0000000000003000000T0oooo1@000000103oool000000000
0000003o0?ooo`@0oooo00<000000?ooo`3oool01`3oool00`000?l0oooo0?ooo`040?ooo`<0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo00<000000?ooo`3oool02P3o
ool6000002H0oooo0`0000040?ooo`<00000;@3oool3000003<0oooo0`00003o0?ooobT0oooo00<0
00000?ooo`3oool01`3oool00`000?l0oooo0?ooo`040?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<a/0oooo00<000000?ooo`3oool02P3oool6000002H0oooo0`000004
0?ooo`<00000;@3oool3000003<0oooo0`00003o0?ooobT0oooo00<000000?ooo`3oool01`3oool0
0`000?l0oooo0?ooo`040?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<a/0oooo00<000000?ooo`3oool02`3oool4000002L0oooo0`0000040?ooo`<00000;@3oool30000
03<0oooo0`00003o0?ooobT0oooo00<000000?ooo`3oool01`3oool00`000?l0oooo0?ooo`040?oo
o`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo00<000000?ooo`3o
ool02`3oool4000002L0oooo0`0000040?ooo`<00000;@3oool3000003<0oooo0`0000030?ooo`<0
0000o`3ooolS0?ooo`030000003oool0oooo00L0oooo00<0003o0?ooo`3oool0103oool309VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<K0?ooo`030000003oool0oooo00/0oooo
1000000^0?ooo`<00000;@3oool3000003<0oooo0`0000030?ooo`<00000o`3ooolS0?ooo`030000
003oool0oooo00L0oooo00<0003o0?ooo`3oool0103oool309VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<K0?ooo`030000003oool0oooo0?l0ooooc`3oool00`000000oooo0?oo
o`070?ooo`030000o`3oool0oooo00@0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c6`3oool00`000000oooo0?ooo`3o0?oooll0oooo00<000000?ooo`3oool01`3oool0
0`000?l0oooo0?ooo`040?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<a/0oooo00<000000?ooo`3oool0o`3oooo?0?ooo`030000003oool0oooo00L0oooo00<0003o0?oo
o`3oool0103oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<K0?ooo`03
0000003oool0oooo0?l0ooooc`3oool00`000000oooo0?ooo`070?ooo`030000o`3oool0oooo00@0
oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6`3oool00`000000oooo
0?ooo`3o0?oooll0oooo00<000000?ooo`3oool01`3oool00`000?l0oooo0?ooo`040?ooo`<0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo00<000000?ooo`3oool0o`3o
ooo?0?ooo`030000003oool0oooo00L0oooo00<0003o0?ooo`3oool0103oool309VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<K0?ooo`030000003oool0oooo0?l0ooooc`3oool0
0`000000oooo0?ooo`070?ooo`030000o`3oool0oooo00@0oooo0`2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c6`3oool00`000000oooo0?ooo`3o0?oooll0oooo00<000000?oo
o`3oool01`3oool00`000?l0oooo0?ooo`040?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<a/0oooo00<000000?ooo`3oool0o`3oooo?0?ooo`030000003oool0oooo00@0
oooo10000?l60?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo
00<000000?ooo`3oool0o`3oooo?0?ooo`030000003oool0oooo00L0oooo00<0003o0?ooo`3oool0
103oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<K0?ooool00000d`00
00050?ooo`D0003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon`0oooo1@00
0?l20?ooo`D0003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooo`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>03o
ool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool06P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo0700oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<g0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0J`3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0K`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo00<000000?ooo`3oool02@3o
ool5000000h0oooo0P0000030?ooo`8000000`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo0080oooo1@00000=0?ooo`8000000`3oool2000000<0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`020?ooo`D000003P3oool2000000<0oooo0P00000=0?ooo`8000000`3o
ool2000001<0oooo0P0000030?ooo`8000004`3oool2000000<0oooo0P0000090?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool00P3oool5000000h0oooo0P0000030?ooo`8000003@3o
ool2000000<0oooo0P00000C0?ooo`8000000`3oool2000001<0oooo0P0000030?ooo`8000002@3o
ool00`000000oooo0?ooo`1^0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3o
ool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00l0oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003oool0oooo
00D0oooo00D000000?ooo`3oool0oooo0000000E0?ooo`050000003oool0oooo0?ooo`0000003@3o
ool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000002P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`050?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`050?ooo`05
0000003oool0oooo0?ooo`0000003@3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo
0?ooo`0000003@3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000002P3o
ool00`000000oooo0?ooo`1^0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo000000050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000001@3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0403o
ool00`000000oooo000000080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000005`3o
ool00`000000oooo0000000>0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000002`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0000000>0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000003P3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0000000/0oooo00<000000?ooo`3oool0KP3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo00<000000?ooo`3oool00P3o
ool5000000@0oooo00<000000?ooo`3oool01@3oool5000000L0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3o
ool5000000H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01@3oool5000000L0oooo00<000000?ooo`3oool01@3o
ool5000000L0oooo00<000000?ooo`3oool02`3oool5000000L0oooo00<000000?ooo`3oool02`3o
ool5000000L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01@3oool5000000L0oooo00<000000?ooo`3oool01@3o
ool5000000L0oooo00<000000?ooo`3oool02`3oool5000000L0oooo00<000000?ooo`3oool02`3o
ool5000000L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1^0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo000000050?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0403oool00`000000oooo000000080?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`0000005`3oool00`000000oooo0000000>0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`0000002`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0000000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000>0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`0000003P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0000000/0oooo00<000000?ooo`3oool0KP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<cH0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00@0oooo0`000000103oool000000000000000030?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo
0`000000103oool000000000000000030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0>0?ooo`<0000000@0oooo00000000000000001P3oool00`00
0000oooo0?ooo`040?ooo`<0000000@0oooo00000000000000004`3oool3000000040?ooo`000000
0000000000`0oooo00<000000?ooo`3oool0103oool3000000040?ooo`0000000000000000T0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0103oool3000000040?ooo`0000000000000000H0oooo00<000000?ooo`3o
ool0103oool3000000040?ooo`0000000000000000`0oooo00<000000?ooo`3oool0103oool30000
00040?ooo`0000000000000000`0oooo00<000000?ooo`3oool0103oool3000000040?ooo`000000
0000000000T0oooo00<000000?ooo`3oool0KP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<cL0oooo00<000000?ooo`3oool0203oool3000001T0oooo00<000000?ooo`3oool02@3o
ool010000000oooo0?ooo`3oool3000001P0oooo00<000000?ooo`3oool02@3oool010000000oooo
0?ooo`3oool3000002`0oooo1000000E0?ooo`<000006@3oool3000000<0oooo00<000000?ooo`3o
ool02@3oool010000000oooo0?ooo`3oool3000002`0oooo1000000E0?ooo`<000006@3oool30000
00<0oooo00<000000?ooo`3oool0K03oool40000o`H0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>03oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo02X0oooo0P00000J0?ooo`030000003oool0oooo
01L0oooo00D000000?ooo`3oool0oooo0000000=0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0:P3oool2000001X0oooo00<000000?ooo`3oool05`3oool01@000000oooo0?ooo`3o
ool000000780oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?:0?ooo`030000003o
ool0oooo01D0oooo0P00000H0?ooo`@00000A03oool00`000000oooo0?ooo`0E0?ooo`800000603o
ool4000007@0oooo0P000?l60?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<l/0oooo00<000000?ooo`3oool05P3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0000004H0oooo00<000000?ooo`3oool05P3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0000007@0oooo00<0003o0?ooo`000?l01P3o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?80?ooo`040000003oool0oooo000001D0oooo00@000000?ooo`3oool0
0000603oool2000004<0oooo00@000000?ooo`3oool000005@3oool010000000oooo0?ooo`00000H
0?ooo`800000L`3oool010000?l0oooo0?ooo`000?l60?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<lT0oooo0P00
000G0?ooo`8000006P3oool00`000000oooo0?ooo`120?ooo`8000005`3oool2000001X0oooo00<0
00000?ooo`3oool0L03oool01@000?l0oooo0?ooo`3oool0003o00H0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooo[0?ooo`H0003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon`0oooo1@000?l60?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0oooo
00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03D0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo0?d0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`030000003oool0oooo02@0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`3l0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c=P3oool00`000000oooo0?ooo`090?ooo`D000003P3oool2000000<0oooo
0P0000030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00P3oool5000000d0oooo
0P0000030?ooo`8000003@3oool2000000<0oooo0P00000:0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool00P3oool5000000d0oooo0P0000030?ooo`8000004`3oool2000000<0oooo
0P00000:0?ooo`030000003oool0oooo0?/0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<f0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`050?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`05
0000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo
0?ooo`0000002`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000003@3o
ool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000002`3oool00`000000oooo
0?ooo`3k0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo
000000050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`000000203oool00`000000oooo
0?ooo`060?ooo`030000003oool0000000`0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0000000>0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`000000303oool00`000000oooo
0?ooo`3k0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3oool00`000000oooo
0?ooo`020?ooo`D00000103oool00`000000oooo0?ooo`050?ooo`D000001`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`050?ooo`D000001P3oool00`000000oooo0?ooo`050?ooo`D000001`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`D000001`3oool00`000000oooo0?ooo`0;0?ooo`D000001`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo0?/0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<f0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo
000000080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`000000303oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0000000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0000000<0?ooo`030000003oool0oooo0?/0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<f0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`040?ooo`<0000000@0oooo00000000000000000`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`<0
000000@0oooo00000000000000001P3oool00`000000oooo0?ooo`040?ooo`<0000000@0oooo0000
0000000000002P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`<0000000@0oooo0000000000000000303o
ool00`000000oooo0?ooo`040?ooo`<0000000@0oooo00000000000000002P3oool00`000000oooo
0?ooo`3k0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=`3oool00`000000oooo
0?ooo`080?ooo`<000006@3oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo0?ooo`<0
0000:`3oool4000000@0oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`3oool30000
01H0oooo0`00000I0?ooo`8000001@3oool00`000000oooo0?ooo`3i0?ooo`@0003o1P3oool00`00
0?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<h0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0:@3oool20000
00D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool05@3oool010000000oooo0?ooo`0000030?ooo`030000003oool0
oooo0?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>N0?ooo`030000003oool0
oooo02d0oooo0P00000H0?ooo`040000003oool0oooo00000?l0oooo0`3oool20000o`H0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<cW`3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo01D0oooo0`00
003o0?ooo`<0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>L0?ooo`040000003o
ool0oooo000002d0oooo00@000000?ooo`3oool00000603oool00`000000oooo0?ooo`3o0?ooo`40
oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>M0?ooo`800000;`3oool20000
01X0oooo0P00003o0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooon/0oooo1P000?l60?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook03oool50000o`H0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooo`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>03oool0
0`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool06P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0?l0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<g0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0903oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0oP3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo00<000000?ooo`3oool02@3oool5
000000h0oooo0P0000030?ooo`8000000`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo0080oooo1@00000=0?ooo`8000000`3oool2000000<0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`020?ooo`D000003P3oool2000000<0oooo0P00000:0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool00P3oool5000000d0oooo0P0000030?ooo`8000002P3oool0
0`000000oooo0?ooo`3m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool0
1@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000/0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?oo
o`3oool0o@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`0000001@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000D0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0000000<0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`000000303oool00`000000oooo0?ooo`3m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c=P3oool00`000000oooo0?ooo`020?ooo`D00000103oool00`000000oooo0?ooo`050?oo
o`D000001`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`050?ooo`D000001P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`D000001`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`040?ooo`D000001`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo0?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<f0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0000000D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo000000050?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`000000303oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0000000`0oooo00<000000?ooo`3oool0o@3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<cH0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00@0oooo0`000000103oool000000000000000030?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00<0oooo0`000000103oool000000000000000030?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo0`00
0000103oool0000000000000000:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo0`000000103oool00000
00000000000:0?ooo`030000003oool0oooo0?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<g0?ooo`030000003oool0oooo00P0oooo0`00000I0?ooo`030000003oool0oooo00T0
oooo00@000000?ooo`3oool0oooo0`00000H0?ooo`030000003oool0oooo00T0oooo00@000000?oo
o`3oool0oooo0`00000H0?ooo`@00000103oool00`000000oooo0?ooo`090?ooo`040000003oool0
oooo0?ooo`<00000603oool3000000@0oooo00<000000?ooo`3oool0n`3oool40000o`H0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c>03oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01H0oooo0P00
00050?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0o`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<kH0oooo00<000000?ooo`3oool0;@3oool400000?l0oooo1@3o
ool20000o`H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c]`3oool00`000000oooo0?ooo`0/0?ooo`030000003o
ool000000?l0oooo1@3oool00`000?l0oooo0000o`060?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<k@0oooo00@0
00000?ooo`3oool00000;`3oool200000?l0oooo103oool010000?l0oooo0?ooo`000?l60?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<kD0oooo0P00000a0?ooo`030000003oool0oooo0?l0oooo0@3oool01@000?l0
oooo0?ooo`3oool0003o00H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo[0?ooo`H0003o1P3oool00`00
0?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo
00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`00
0?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooon`0oooo1@000?l60?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0oooo00<000000?ooo`3oool08P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo09d0oooo00<000000?ooo`3oool0h@3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo09l0oooo00<000000?ooo`3oool0h03oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo00<000000?ooo`3oool02@3oool50000
00h0oooo0P0000030?ooo`8000000`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
0080oooo1@00000=0?ooo`8000000`3oool2000000d0oooo0P0000030?ooo`8000004`3oool20000
00<0oooo0P00000C0?ooo`8000000`3oool2000001<0oooo0P0000030?ooo`8000004`3oool20000
00<0oooo0P00000:0?ooo`030000003oool0oooo0=l0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<f0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`050?ooo`050000003o
ool0oooo0?ooo`0000003@3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`00
00003@3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000003@3oool00`00
0000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000003P3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`3O0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo000000050?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`060?ooo`030000003o
ool0000000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000>0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`0000003P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0000000l0oooo00<000000?ooo`3oool01@3oool00`000000oooo0000000<0?ooo`030000003o
ool0oooo0=l0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<f0?ooo`030000003o
ool0oooo0080oooo1@0000040?ooo`030000003oool0oooo00D0oooo1@0000070?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00D0oooo1@0000060?ooo`030000003oool0oooo00D0oooo1@0000070?ooo`030000003o
ool0oooo00/0oooo1@0000070?ooo`030000003oool0oooo00/0oooo1@0000070?ooo`030000003o
ool0oooo00/0oooo1@0000070?ooo`030000003oool0oooo00`0oooo1@0000060?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0g`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<cH0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0000000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000>0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`0000003P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0000000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000?0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`000000303oool00`000000oooo0?ooo`3O0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0103oool3000000040?ooo`0000000000000000<0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool00`3oool3000000040?ooo`0000000000000000H0oooo00<000000?ooo`3o
ool0103oool3000000040?ooo`0000000000000000`0oooo00<000000?ooo`3oool0103oool30000
00040?ooo`0000000000000000`0oooo00<000000?ooo`3oool0103oool3000000040?ooo`000000
0000000000`0oooo00<000000?ooo`3oool0103oool3000000040?ooo`0000000000000000d0oooo
00<000000?ooo`3oool00`3oool3000000040?ooo`0000000000000000X0oooo00<000000?ooo`3o
ool0g`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo00<000000?ooo`3o
ool0203oool3000001T0oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`3oool30000
02/0oooo1000000E0?ooo`<000006@3oool3000001H0oooo0`00000H0?ooo`8000001@3oool00`00
0000oooo0?ooo`3M0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<h0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0:@3oool2000001X0oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo01@0oooo00@000000?ooo`3oool000000`3oool0
0`000000oooo0?ooo`3Q0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cWP3oool0
0`000000oooo0?ooo`0E0?ooo`800000603oool4000001T0oooo00<000000?ooo`3oool0503oool0
10000000oooo0?ooo`00003V0?ooo`80003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>O0?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool05@3oool00`000000oooo0000000G0?ooo`<000005`3o
ool300000>H0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>L0?ooo`040000003o
ool0oooo000001D0oooo00@000000?ooo`3oool00000603oool2000001L0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`3T0?ooo`040000o`3oool0oooo0000o`H0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<cW@3oool2000001L0oooo0P00000J0?ooo`030000003oool0oooo01D0oooo0`00000I0?oo
o`800000h`3oool01@000?l0oooo0?ooo`3oool0003o00H0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo[
0?ooo`H0003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo/
0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo00oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c=W0?ooo`@00000o`3ooon50?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<cIP3oool200000080oooo0P00003o0?oooh@0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c=[0?ooo`800000o`3ooon30?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c3@3oool9000000T0oooo0P0000040?ooo`8000000`3oool2000000<0oooo0`000008
0?ooo`8000000`3oool2000000<0oooo0`0000040?ooo`L000000P3oool5000000030?ooo`000000
00000080oooo0P0000030?ooo`8000000`3oool500000?l0ooooP`3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<`d0oooo2@0000090?ooo`800000103oool2000000<0oooo0P000002
0?ooo`80000000<0oooo0000000000001`3oool2000000<0oooo0P0000020?ooo`80000000<0oooo
0000000000000P3oool200000080oooo0`0000020?ooo`80000000D0oooo00000000000000000?oo
o`0200000080oooo0P0000030?ooo`8000000P3oool2000000040?ooo`000000000000000?l0oooo
P`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`d0oooo2@0000090?ooo`800000
103oool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2000000<0oooo
0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000030?oo
o`000000000000<0oooo0P00003o0?oooh<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<=0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`80000000<0oooo000000000000
2`3oool2000000<0oooo0P0000000`3oool00000000000060?ooo`8000000`3oool2000000030?oo
o`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000030?oo
o`000000000000<0oooo0P00003o0?oooh<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<=0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`80000000<0oooo000000000000
1@0000060?ooo`8000000`3oool2000000030?ooo`000000000000D000000P3oool6000000030?oo
o`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000030?oo
o`000000000000<0oooo0P00003o0?oooh<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<=0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`80000000<0oooo000000000000
0`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000D0oooo
0`0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo
0P0000000`3oool00000000000030?ooo`800000o`3ooon30?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c3@3oool9000000T0oooo0P0000040?ooo`8000000`3oool2000000030?oo
o`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo
0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`00000000000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool200000?l0oooo
P`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`d0oooo2@0000090?ooo`800000
103oool300000080oooo0P0000020?ooo`80000000<0oooo0000000000001`3oool300000080oooo
0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000020?ooo`800000
00D0oooo00000000000000000?ooo`0200000080oooo0`0000020?ooo`8000000P3oool200000004
0?ooo`000000000000000?l0ooooP`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<`d0oooo2@0000090?ooo`800000103oool6000000@0oooo0`0000080?ooo`H00000103oool30000
00@0oooo1@0000040?ooo`D0000000<0oooo0000000000000P3oool6000000@0oooo1@00003o0?oo
oh<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<O0?ooo`800000103oool20000
01<0oooo0P00000K0?ooo`800000o`3ooonG0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c7`3oool2000000@0oooo0P00000C0?ooo`8000006`3oool200000?l0ooooU03oool40000
o`H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c703oool8000000030?ooo`000000000001<0oooo0P00000K0?oo
o`80000000<0oooo000000000000o`3ooonD0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooo/0?ooo`D0003o0P3oool50000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI
0@3UiND103<c<`40oooo00000`3oool0iNGU0>GUi@3o0>GUiOl0iNGU203UiND10?ooo`00o`3ooooo
0?ooo``0oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 256},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["CellPrint", "MR"],
  " and ",
  StyleBox["StylePrint", "MR"],
  " provide simple ways to modify open notebooks in the front end from within \
the kernel. Later in this section we will discuss more sophisticated and \
flexible ways to do this. "
}], "Text",
  CellTags->{"S2.11.1", "1.19"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.11.2 Notebooks as ",
  StyleBox["Mathematica", "SBO"],
  " Expressions"
}], "Subsection",
  CellTags->{"S2.11.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Notebook[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cell",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cell",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["a notebook containing a sequence of cells "]},
          {Cell[TextData[{
              StyleBox["Notebook[", "MR"],
              StyleBox["cells", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["options", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["a notebook with options specified "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.2"],

Cell["Expressions corresponding to notebooks. ", "Caption",
  CellTags->"S2.11.2"],

Cell[TextData[{
  "Here is a simple ",
  StyleBox["Mathematica", "TI"],
  " notebook."
}], "MathCaption",
  CellTags->{"S2.11.2", "2.2"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000N2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj`3oool50000o`80
oooo1@000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<=0?ooo`<000000P3oool00`000000oooo0?ooo`03000000040?ooo`00000000000000
0080oooo0`0000020?ooo`8000001P3oool00`000000oooo0?ooo`0200000080oooo0P0000000`3o
ool00000000000020?ooo`040000003oool0oooo00000?l0oooo/P3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<`h0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`04
0000003oool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003o
ool0oooo0?l0oooo]03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo00H0
00000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0000000<0oooo00@000000?ooo`3o
ool000000P3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo000000H0oooo00D00000
0?ooo`3oool0oooo0000003o0?oookH0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<>0?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo000000030?ooo`04
0000003oool0oooo00000080oooo100000040?ooo`030000003oool0oooo00@000000`3oool01@00
0000oooo0?ooo`3oool000000?l0oooo]P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<`h0oooo00<000000?ooo`0000000`3oool01@000000oooo0000003oool0000000<0oooo00<0
00000?ooo`3oool00P0000001@3oool000000?ooo`3oool0000000@0oooo00@000000?ooo`3oool0
00000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3oool0o`3ooond
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool00`000000oooo00000003
0?ooo`030000003oool000000080oooo0`0000020?ooo`050000003oool000000000003oool00P00
00040?ooo`<000000P3oool200000080oooo0P0000000`3oool000000000000300000?l0oooo]@3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo0P0000050?ooo`8000004`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0?l0oooo]03oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo0P0000050?ooo`800000o`3ooooH0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool2000000L0oooo0P00003o0?ooomL0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon`0oooo10000?l60?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj`3o
ool50000o`H0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooon/0oooo1@000?l60?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`d0oooo00<0
00000?ooo`0000000P0000030?ooo`<000000P3oool3000000040?ooo`00000000000?ooo`800000
0P3oool2000000H0oooo00<000000?ooo`3oool00P0000020?ooo`80000000<0oooo000000000000
0P3oool010000000oooo0?ooo`00003o0?oook00oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<=0?ooo`8000000P3oool2000000030?ooo`000000oooo0080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00@0
00000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?oo
o`3oool0o`3ooonb0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool00000
1P3oool01@000000oooo0?ooo`3oool000000?l0oooo]03oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<a40oooo0P0000000`3oool000000?ooo`020?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000000P3oool4000000@0oooo00<000000?ooo`3oool010000003
0?ooo`050000003oool0oooo0?ooo`000000o`3ooond0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c3`3oool300000080oooo00D000000?ooo`3oool0oooo000000020?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000
003oool0oooo0?l0oooo/P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo
0P0000050?ooo`<000000P3oool01@000000oooo000000000000oooo00800000103oool2000000@0
oooo0`0000020?ooo`8000000P3oool2000000030?ooo`000000000000<00000o`3ooonc0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3o0?oook80
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`040000003oool0oooo0?oo
o`800000o`3ooooL0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool30000
00030?ooo`000000oooo0?l0oooof`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooook03oool40000o`H0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooo[0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooon/0oooo1@000?l60?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook`3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<h00oooo1000003o0?ooof/0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c=o0?ooo`8000000P3oool200000?l0ooooJP3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<h@0oooo0P00003o0?ooofT0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T00000203oool5000000D0oooo0`0000050?oo
o`<00000103oool200000080oooo0P0000040?ooo`<000000`3oool2000000<0oooo0P0000060?oo
o`8000000`3oool2000000<0oooo0`0000040?ooo`L000000P3oool5000000030?ooo`0000000000
0080oooo0P0000030?ooo`8000000`3oool500000?l0ooooJ@3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<``0oooo2@0000070?ooo`8000000`3oool2000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000030?oo
o`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000060?ooo`8000000`3oool20000
0080oooo0P0000000`3oool00000000000020?ooo`8000000P3oool300000080oooo0P0000001@3o
ool00000000000000000oooo008000000P3oool2000000<0oooo0P0000020?ooo`80000000@0oooo
0000000000000000o`3ooomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303o
ool9000000H0oooo0P0000050?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00
0000000000<0oooo0P0000000`3oool00000000000030?ooo`8000000P3oool2000000<0oooo0P00
00000`3oool00000000000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool000000000
00030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P00
00000`3oool00000000000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T000001P3o
ool2000000D0oooo0P0000000`3oool00000000000060?ooo`8000001P3oool2000000<0oooo0P00
00020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3o
ool2000000030?ooo`000000000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3o
ool2000000030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3o
ool200000?l0ooooJ@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@00
000=0?ooo`80000000<0oooo0000000000001@0000000`3oool00000000000060?ooo`8000000`3o
ool200000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P00
00030?ooo`80000000<0oooo0000000000001@0000020?ooo`H0000000<0oooo0000000000000`3o
ool2000000030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3o
ool200000?l0ooooJ@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@00
000<0?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000060?ooo`8000000`3o
ool200000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P00
00030?ooo`80000000<0oooo0000000000000`3oool2000000D0oooo0`0000000`3oool000000000
00030?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool000000000
00030?ooo`800000o`3ooomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303o
ool9000000P0oooo1@0000030?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
00000`3oool00000000000030?ooo`8000000P3oool2000000<0oooo0P0000000`3oool000000000
00030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0
oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool000000000
00020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?ooofT0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T000001`3oool2000000P0oooo0P00
00000`3oool00000000000030?ooo`8000000P3oool2000000030?ooo`000000000000<0oooo0P00
00030?ooo`80000000<0oooo0000000000000P3oool300000080oooo0P0000060?ooo`<000000P3o
ool200000080oooo0P0000000`3oool00000000000020?ooo`8000000`3oool200000080oooo0P00
00001@3oool00000000000000000oooo008000000P3oool300000080oooo0P0000020?ooo`800000
00@0oooo0000000000000000o`3ooomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c303oool9000000H0oooo0P0000050?ooo`8000000`3oool3000000D0oooo100000000`3oool0
00000000000200000080oooo0P0000040?ooo`<000000`3oool6000000L0oooo1P0000040?ooo`<0
0000103oool5000000@0oooo1@0000000`3oool00000000000020?ooo`H00000103oool500000?l0
ooooJ@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo0P0000050?ooo`80
00004@3oool2000001`0oooo0P00000K0?ooo`800000o`3ooomm0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c703oool2000000<0oooo0P00000B0?ooo`800000703oool2000001/0
oooo0P00003o0?ooogX0oooo10000?l60?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ad0oooo1@00000H0?ooo`80
00005`3oool2000001/0oooo0P0000000`3oool000000000003o0?ooogX0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon/0oooo1@000?l20?ooo`D0003o1P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2I
VIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0@3UiND1
03<c<`40oooo00000`3oool0iNGU0>GUi@3o0>GUiOl0iNGU203UiND10?ooo`00o`3ooooo0?ooo``0
oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 120},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.2"],

Cell["Here is the expression that corresponds to this notebook.", \
"MathCaption",
  CellTags->{"S2.11.2", "2.3"}],

Cell[TextData[{
  "Notebook[",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n    Cell[\"Section heading\", \"Section\"],\n    Cell[\"Some text.\", \
\"Text\"],\n    Cell[\"More text.\", \"Text\"]",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "]"
}], "Program",
  CellTags->{"S2.11.2", "2.4"}],

Cell[TextData[{
  "Just like individual cells, notebooks in ",
  StyleBox["Mathematica", "TI"],
  " can also have options. You can look at and modify these options using the \
options inspector in the standard notebook front end. "
}], "Text",
  CellTags->{"S2.11.2", "2.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["WindowSize", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["nx", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ny", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], 
            Cell["\<\
the size in pixels of the window used to display the \
notebook \
\>"]},
          {Cell[TextData[{
              StyleBox["WindowFloating", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell["whether the window should float on top of others "]},
          {Cell[TextData[{
              StyleBox["WindowToolbars", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{", "MR"],
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["what toolbars to include at the top of the window "]},
          {Cell[TextData[{
              StyleBox["ShowPageBreaks", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], 
            Cell["\<\
whether to show where page breaks would occur if the \
notebook were printed \
\>"]},
          {Cell[TextData[{
              StyleBox["CellGrouping", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["how to group cells in the notebook "]},
          {Cell[TextData[{
              StyleBox["Evaluator", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["\"Local\"", "MR"],
              " "
            }]], 
            Cell["\<\
what kernel should be used to do evaluations in the \
notebook \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.11.2"],

Cell["\<\
A few of the large number of possible options for notebooks. \
\>", \
"Caption",
  CellTags->"S2.11.2"],

Cell[TextData[{
  "In addition to notebook options, you can also set any cell option at the \
notebook level. Doing this tells ",
  StyleBox["Mathematica", "TI"],
  " to use that option setting as the default for all the cells in the \
notebook. You can override the default by explicitly setting the options \
within a particular cell.  "
}], "Text",
  CellTags->{"S2.11.2", "2.6"}],

Cell["\<\
Here is the expression corresponding to a notebook with a ruler \
displayed in the toolbar at the top of the window. \
\>", "MathCaption",
  CellTags->{"S2.11.2", "2.7"}],

Cell[TextData[{
  "Notebook[",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n    Cell[\"Section heading\", \"Section\"],\n    Cell[\"Some text.\", \
\"Text\"]",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  ",\n       WindowToolbars->",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\"RulerBar\"",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "]"
}], "Program",
  CellTags->{"S2.11.2", "2.8"}],

Cell["This is what the notebook looks like in the front end.", "MathCaption",
  CellTags->{"S2.11.2", "2.9"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008L0000_b000`400?l00000o`00003ooomVIWko
ofIVOQkoIVIn00000omVIWkonocmoo_lo@3ooo_loOoonocm6_oko?d1ofIVOP0000?oIVInoo_loOnX
ZK/0oonXZK_oojRY^aWoZ:Vk0Ooko?d1ofIVOP0000?oIVInoo_loOnXZK/0oomVIWkoofIVOQSoIVIn
0OnXZK/1oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWjHooooocOoh=oS00?ok>gdoh^<VOnMWZ/0
3?nMWZ/01?n:RiWohnK]onk]iOni^[jJoifNZ`03okfm_oo^kNGoiNK^07?oiNK^00?ok>gdoh^<VOnM
WZ/03?nMWZ/00on:RiWohnK]on3Oh`0@on3Oh`03ofIVO_nXZK_onocm007oIVIn00001OmVIWkonocm
ojRY^omVIWkoWIfQ09Koh=oS00?oooooon3OhooPgn<0=OoPgn<00onDUJ;ogMkQomWJi00<omWJi004
omgNhOnDUJ;oU9FRom[KgY[oalSF00?of]_Noj6R[_oknoh0Looknoh00onDUJ;ogMkQomWJi00<omWJ
i003omgNhOnDUJ;oh=oS00Goh=oS0_ooool2on3Oh`;ooooo0_oPgn<2ooooo`04on3OhomVIWkoZ:Vk
oo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS00?oooooon3OhooPgn<0=OoPgn<0
0onDUJ;ooooool_<fP0<ol_<fP04oooooonDUJ;oU9FRoooooi[ocLkL00?ooooooiBEX_oknoh0Look
noh00onDUJ;ooooool_<fP0<ol_<fP03oooooonDUJ;oh=oS00Coh=oS00oo^;BSokReXOooooooh=oS
okRdXonh]J7oooooon3Ohonh]:?o^;FQoooooooPgn?oIVInojRY^ooko?d00OmVIWh00005ofIVO_ok
o?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3Oh`0eon3Oh`03oiBEX_ooooooblcJ00coblcJ
00CooooooiBEX_nDUJ;oooooV_o<cM/00oooooooU9FRoo_koP1coo_koP03oiBEX_ooooooblcJ00co
blcJ00?ooooooiBEX_oPgn<01?oPgn<01_nh]:?o^;BQon3OhooPgn?o^;BSokRdX@;oh=oS00Oo^;BS
okRdXOoPgn?oh=oSofIVO_nXZK_onocm007oIVIn00001OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS
00?oooooon3OhooPgn<00ooPgn<3o`0000?oh=oS0ol00003on3Oh`?o00001OoPgn<01?l0003oh=oS
on3OhooPgn<2o`0001Soh=oS00?oU9FRooooooo;c=X01Oo;c=X00olo?CgoblcJol_<fP04ol_<fP07
oooooonDUJ;oU9FRooooooo>cmgoc/oLolk@g@0Iolk?g0cocloM3?o?cm`=olk@g@coc/oM3?o>cm`=
olk@gASoc/oL3Oo?cmd<olo?g005olk@gOo>cmgoc/oMoooooonDUJ80M?ojn_d00onDUJ;ooooool_<
fP04ol_<fP03oclm?Oo;c=[oblcJ00GoblcJ00?ooooooiBEX_oPgn<04?oPgn<00omVIWkoZ:Vkoo_l
o@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS00Coh=oS00Go
0000on3OhooPgn?oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<0
0_oPgn<01?l0003oh=oSon3Ohol00002on3Oh`03o`000?oPgn?oh=oS01Goh=oS00?oU9FRooooooo;
c=X01?o;c=X3oclm?@GoblcJ00CooooooiBEX_nDUJ;ooooo3ooDeN0IomCEh@coeMGQ3OoDeN49omCE
h007ohjEX_oDeN3oSYFRomCEh?n>UJ;oe=GPohjEXP0QomCEh1Woe=GQ3?oEeN43omCEh@03oooooonD
UJ;onOWk07?onOWk00?oU9FRooooooo;c=X00oo;c=X3oclm?@KoblcJ00?ooooooiBEX_oPgn<02OoP
gn<2ooooo`;oh=oS0_ooool01?oPgn?oIVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVIn
oifMX@2Fon3Oh`03oooooooPgn?oh=oS00Coh=oS00Go0000on3OhooPgn?oh=oSo`000003on3Oh`03
o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00ooPgn<00ol0003oh=oSo`000002on3Oh`03
o`000?oPgn?oh=oS01Goh=oS00?oU9FRooooooo<cM/00oo<cM/3oclm?@Koc<gK00CooooooiBEX_nD
UJ;ooooo0_oKfnH00ooKfnGofmcUom_Li@0_om_LiAGofm_V00SoooooohjEX_ooooooSYFRoooooon>
UJ;oooooohjEXPSofm_V3OoKfnDaom_Li@;ofm_V00?ofmcUoooooonDUJ80M?oinO/00onDUJ;ooooo
olc=f`04olc=f`?o?cdm1Oo<cM/00oooooooU9FRon3Oh`08on3Oh`0;okRdXonh]J7oooooon3Ohonh
]:?o^;FQoooooooPgn?oIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oP
gn<00oooooooh=oSon3Oh`04on3Oh`05o`000?oPgn?oh=oSon3Ohol000000ooPgn<00ol0003oh=oS
o`000003on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<00_l0000<on3Oh`Oo0000
1OoPgn<00onDUJ;oooooom7Bh002om7Bh0?o?cdm1ooAd^001?ooooooU9FRoiBEX_ooool2om_KiP03
om_KiOoKg>GofmcU02oofmcU5OoKfnH02?ooooooSYFRoooooon>UJ;oooooohjEX_ooooooSYFR2?oK
fnH=om_KiC7ofmcU0_oKfnH00ooKg>GooooooiBEXP1dooShn`03oiBEX_oooooodM;P00GodM;P0olo
?Cd4om7Bh003oooooonDUJ;oh=oS00Soh=oS00Ko^;BSokRdXOoPgn?oh=oSokRdXonh]:42on3Oh`03
ofIVO_nXZK_onocm007oIVIn00001OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS00?oooooon3OhooP
gn<01?oPgn<01Ol0003oh=oSon3OhooPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0
003oh=oSon3Oh`02o`0000;oh=oS00?o0000on3OhooPgn<03_oPgn<5o`0000Koh=oS00CoU9FRoooo
oooIf^CofM[T0olo?Cd8omWJi007oooooonDUJ;oU9FRoooooooShn[ohn;[on;RjP0<on?SjPgohn;Z
3?oRh^X<on;SjQGohn?Z00SoooooohjEX_ooooooSYFRoooooon>UJ;oooooohjEXPSohn;[3OoRh^X<
on?SjPcohn;Z3OoRh^X<on;SjP05on?Sj_oRh^_oh^?[oooooonDUJ80M?ogmoT00onDUJ;oooooomWJ
i006omWJi0?o?cdm0ooIf^@00oooooooU9FRon3Oh`0@on3Oh`03ofIVO_nXZK_onocm007oIVIn0000
1OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS00?oooooon3OhooPgn<01?oPgn<01Ol0003oh=oSon3O
hooPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`03o`00
0?oPgn?o0000017oh=oS0ol00007on3Oh`03oiBEX_oooooohn?[00;ohn?[0olo?Cd7on?Sj`07oooo
oonDUJ;oU9FRoooooooYjNkoj>W^onSXk`0<onWYkPgojNS^6?oXjNh=onSYk`SojNW^00SoooooohjE
X_ooooooSYFRoooooon>UJ;oooooohjEXPSoj>W^3OoXj>l<onWYkPcojNS^6OoXjNh01OoXjNooj>S^
onSXk_ooooooU9FR07Com?Gi00?oU9FRoooooooShn/01OoShn/3oclm?@Cohn?[00?ooooooiBEX_oP
gn<03OoPgn<2ooooo`04on3OhomVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoWIfQ
09Koh=oS00?oooooon3OhooPgn<00ooPgn<2o`0000?oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oP
gn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol0000Aon3Oh`03o`00
0?oPgn?oh=oS00Koh=oS00?oU9FRooooooo/k?400oo/k?43oclm?@Kok>ca00OooooooiBEX_nDUJ;o
ooooonWYk_oXjNkoj>S_00cojNW^3OoYj>hHonSYkPgoj>W_2?oYjNh02?ooooooSYFRoooooon>UJ;o
ooooohjEX_ooooooSYFR2?oXjNh=onSXk`cojNW^3?oYj>hIonSYkP05onSYkooXj>koj>S^oooooonD
UJ80M?ocloL00onDUJ;oooooonc/l@04onc/l@?o?cdm1Oo/k?400oooooooU9FRon3Oh`0<on3Oh`07
okRdXonh]J7oooooon3OhomVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2F
on3Oh`03oooooooPgn?oh=oS00Coh=oS00?o0000on3OhooPgn<00_oPgn<3o`0000?oh=oS0ol00003
on3Oh`;o00000ooPgn<00ol0003oh=oSon3Oh`0Hon3Oh`03oiBEX_oooooom?Cg00Com?Cg0olo?Cd5
ooCdm`04oooooonDUJ;oU9FRooooodWok>ca00Ooooooonc/lOooooook>caooooooo/k?7ooooo04[o
k>ca00?ooooooiBEX_o`lOH0Loo`lOH00onDUJ;oooooooCdm`03ooCdm`?o?cdm1_odm?L00ooooooo
U9FRon3Oh`0<on3Oh`07okRdXonh]:7oh=oSon3OhomVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_l
oOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS03Goh=oS00?oU9FRoooooooko?`01Ooko?`0
0olo?Cgonocloo_lo004oo_lo004oooooonDUJ;oU9FRoooooi[ok>ca00?ooooooiBEX_o_l?D0Loo_
l?D00onDUJ;ooooooo_lo004oo_lo003oclm?Ooko?conocl00Gonocl00?ooooooiBEX_oPgn<04?oP
gn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooooP
gn?oh=oS03Goh=oS00?oU9FRooooooooool03Oooool2oiBEXP03ooooooogmoWomoOi09SomoOi00?o
oooooiBEX_o^ko@0Loo^ko@00onDUJ;oooooooooo`0=ooooo`03oiBEX_oPgn?oh=oS00ooh=oS00?o
IVInojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3O
h`0eon3Oh`03oiBEX_oFe]_ooooo00cooooo00Coe]KKoiBEX_nDUJ;on_[kV_ooool00oojn__oU9FR
onc_m01conc_m003oiBEX_oFe]_ooooo00cooooo00?oe]KKoiBEX_oPgn<04?oPgn<00omVIWkoZ:Vk
oo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS03Goh=oS
00Coe]_Iohn@W_ne]Kko];Bn1ond];d02?nc];go];BmokBd_Onc/kgoS8fLomKKfOoEe]Wo[ZniV_ng
]kl00onUZ;KoblkEonc^l`1conc^l`04omKKfOn?T9ko]KFnokBd_POo];Bm00Ko/kBmokBd_Ond];go
/k>mohb=W?oFfmTAon3Oh`03ofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWjGoifM
X@03oooooooPgn?oh=oS03Goh=oS4Oo^kNFNon_[igCoiNK^4Oo^kNDAon3Oh`03ofIVO_nXZK_onocm
007oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool00oo^kNGok>gdoh^<V@0<oifN
Z`05ohZ;VOoSi^goIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5
ooooo`03onk]iOnDUJ;ogMkQ00cofM[T00GogMkQoiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVIn
oo_loOnXZK_oIVInooooooooooooo`Gooooo00?ok^gUoiBEX_ooool03?o;c=X01OooooooU9FRofIV
O_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool00oo^kNGoU9FR
ooooo`0<ol_<fP05oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oo
ooooooooool5ooooo`03onk]iOnDUJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIV
OP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00?ok^gUoiBEX_ooool01Oo;c=X00olo
?CgoblcJol_<fP04ol_<fP05oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_ooooooooooool5ooooo`03onk]iOnDUJ;ooooo00CoblcJ0olo?Cd5ol_<fP05oooooonDUJ;o
IVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5ooooo`03onk]iOnD
UJ;ooooo00?oc<gK1Olo?Cd4olc=f`05oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_ooooooooooool5ooooo`03onk]iOnDUJ;ooooo00;odM;P0olo?Cd01?oAd^3o?cdm
oclm?Olo?Cd3om7Bh005oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIV
O_ooooooooooool5ooooo`04onk]iOnDUJ;oooooomWJi0?o?cdm0ooIf^@3oclm?@;ofM[T00Gooooo
oiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00?o
k^gUoiBEX_ooool00_oShn/00olo?Cgohn?[on?Sj`03on?Sj`09oclm?OoShn_ohn?[on?Sjooooooo
U9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool00oo^
kNGoU9FRooooo`0<onc/l@05oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_ooooooooooool5ooooo`03onk]iOnDUJ;ooooo00com?Cg00GooooooiBEX_mVIWkoZ:Vkoo_l
o@01ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00?ok^gUoiBEX_ooool03?ok
o?`01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo
1Oooool00oo^kNGoU9FRooooo`0=ooooo`04oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkooooooooooooo1Oooool00oo^kNGoU9FRomKFf`0<ooooo`05omKFfonDUJ;oIVInojRY
^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5ooooo`05onk]iOoFfmWoSi2N
okFe__nd];h01Ond];d02_nc];go];Bmok>d_Ond];go/k>mohb=W?oFfmWoIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00[oiNK^onc^loo/koCok^odono`mOo`
lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Go
l?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00[oiNK^onc^loo/koCok^odono`
mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5ooooo`0:onGVk_o/k_?ok>odonk_m?o_
l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool02_oUi^kok>kconc_m?o^koCo
ko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5ooooo`0:onGVk_o/k_?ok>odonk_
m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool02_oUi^kok>kconc_m?o^
koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00[oiNK^onc^loo/koCo
k^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5ooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool02_oUi^kok>kconc_
m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00[oiNK^onc^loo/
koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIV
O_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5ooooo`0:onGVk_o/k_?o
k>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00[oiNK^onc^
loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5ooooo`0:onGVk_o/
k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGV
k_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool02_oUi^ko
k>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oU
i^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5ooooo`0:onGV
k_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_n
onGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool02_oU
i^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_k
o_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00[o
iNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_ok
nokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5ooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool0
2_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_n
oo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooodooooo`Go003o
0_ooool5o`00o`Cooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oi
nO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
O_oooooon?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00;ooooo00[oiNK^onc^
loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooon?ooool00ol00?oooooooooo
o`04ooooo`03o`00oooooooooooo00;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCe
nOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVO_oooooon?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00;o
oooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_n
oo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooon?ooool0
0ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00;ooooo00[oiNK^onc^loo/koCok^odono`
mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVOPcooooo1?l00003ooooo`?o00000_ooool3o`000004oooo
ool0003o0000ooooo`;o000000?oooooo`000?l000001_ooool2o`0000;ooooo0_l00002ooooo`;o
000000Coooooo`000?l0003ooooo0_l00002ooooo`03o`000?oooooooooo0?oooooo^Oooool00ol0
0?ooooooooooo`04ooooo`03o`00oooooooooooo00;ooooo00[oiNK^onc^loo/koCok^odono`mOo`
lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVOPcooooo00Oo0000ooooooooooooooooo`000?oooooo000000?o
oooo00Co0000oooooooooooo00000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o
0000ooooooooool00oooool01?l0003oooooooooool00002ooooo`06o`000?ooooooooooo`000?oo
oooo00000_ooool00ol0003oooooooooo`3ooooookgooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`02ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;o
nOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWh@ooooo`03o`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool01_l0003ooooo
ooooool0003oooooo`0000Sooooo00Co0000oooooooooooo00001_ooool01Ol0003ooooooooooooo
oooo00000?oooooo_oooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00;ooooo00[o
iNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_ok
nokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQ3ooooo00?o0000ooooool0
00000oooool01?l0003oooooooooool00002ooooo`05o`000?ooooooooooo`000?ooool01?l00005
ooooo`03o`000?oooooooooo00Co00000oooool01Ol0003ooooooooooooooooo00000?oooooo_ooo
ool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00;ooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOPkooooo0_l00002ooooo`05o`000?oooooooooooooo
ool000000_ooool2o`000007ooooool0003o0000ooooool0003oooooo`000002ooooo`03o`000?oo
oooooooo00?ooooo00Co0000oooooooooooo00000_ooool01_l0003oooooooooool0003oooooo`00
00;ooooo00?o0000ooooooooool0oooooonmooooo`03o`00oooooooooooo00Cooooo00?o003ooooo
ooooool00_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08
oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn3Ooo
ool00ol0003oooooooooo`03ooooo`?o00000_ooool2o`000005ooooool0003oooooooooool00000
0oooool2o`0000Gooooo0ol00002ooooo`;o00000_ooool2o`000003ooooool0003o000000?o0000
oooooonnooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool00_ooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn3?ooool00ol0003oooooooooo`0Koooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0oooooonmooooo`03o`00oooooooooooo
00Cooooo00?o003oooooooooool00_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVIn3?ooool01Ol0003ooooooooooooooooo000001Wooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`3ooooookgooooo00?o003oooooooooool01?ooool00ol00?oooooo
ooooo`02ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWh=oooo
o`Co0000oooooooWooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool00_ooool02_oU
i^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_k
o_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooohooooo`03o`00oooo
oooooooo00Cooooo00?o003oooooooooool00_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_oc
loOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVInooooooohooooo`03o`00oooooooooooo00Cooooo00?o003ooooooooo
ool00_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[j
oOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooe
ooooo`Co003o1_ooool00ol00?ooooooooooo`02ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooooSooooo00?o003oooooooooool01?ooool00ol00?oooooo
ooooo`02ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
ooCooooo1Ol00?l6ooooo`03o`00oooooooooooo00;ooooo00[oiNK^onc^loo/koCok^odono`mOo`
lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool00ol00?ooooooooooo`02ooooo`0:onGVk_o/
k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGV
k_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo00?o003ooooooooo
ool00_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[j
oOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooo
ooooo`03o`00oooooooooooo00;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOog
moWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_ooooooooooool00ol00?ooooooooooo`02ooooo`03onk]iOo]l?;oRhbJ00GoWIj/
00?oWIj[oifN[?nMWZ`00onMWZ`01_nMWjcoSHnKonk]iOmVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWkooooooooooooo00?o003oooooooooool00_ooool00oo^kNGoU9FRomgNh@0<om3A
g`05omgNhOnDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool0
0ol00?ooooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>h03?oRhn_ofmcUom_L
iOoDeN7oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWkooooooooooooo00?o003oooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>S^
00coh^;[om_Ki_oKfnKoe=GQolk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInooooooooooooo`03o`00oooooooooooo00;ooooo00Cok^gUoiBEX_oooooo
moOi0_o/k?42onSYk`0<on?Sj_oKfnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool00ol00?ooooooooooo`02ooooo`04
onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooo
oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo00?o003ooooo
ooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?
g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooo
ooooo`03o`00oooooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Sj_oK
g>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVO_ooooooooooool00ol00?ooooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca
0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkooooooooooooo00?o003oooooooooool00_ooool01?o^kNGoU9FR
ooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`03o`00oooooooooooo00;o
oooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>
g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool00ol0
0?ooooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoD
eN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWko
ooooooCooooo1Ol00?l6ooooo`03o`00oooooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/
k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVO_oooooon?ooool00ol00?ooooooooooo`04ooooo`03o`00oooo
oooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?
cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooo
n?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00;ooooo00Cok^gUoiBEX_oooooo
moOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooon?ooool00ol00?ooooooooooo`04ooooo`03
o`00oooooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcU
omCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
O_oooooon?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00;ooooo00Cok^gUoiBE
X_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIV
O_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOXgooooo00KoYjNWofQXJ?l0003o0000ofQX
J?nb/[;oooooofGooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`02ooooo`04onk]
iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBE
X_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWj<ooooo`03ohb<S?l0003o000000Co
000000?o_Kfmooooooooool0oooooomRooooo`03o`00oooooooooooo00Cooooo00?o003ooooooooo
ool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<
cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInS?ooool2o`00
0006on7QhOooooooooooolO7aol0003oJ6QXoooooomTooooo`03o`00oooooooooooo00Cooooo00?o
003oooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Go
e=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
2_ooool9o`000003okfm_Ooooooooooo00Gooooo00?ol?3`ojNWYom=CDd00_l000000on<S8cofMWI
ooooo`03ooooo`05omWIfOmXJ6So0000ode=COo7alL01?ooool01OoIfMWoJ6QXo`000?m=CDgo_Kfm
00?ooooo00God=3@ode=COl0003oS8b<ooooo`02o`0000?ooooo00KojNWYoiZJV_l0003o0000oiZJ
V_oYjNT3ooooo`;o00001?ooool2o`0000Kooooo0_l00004ooooo`;o00000oooool01OoIfMWoJ6QX
o`000?m=CDgoalO700Cooooo00OoVYZJo`000?m=CDgoYjNWonWYjOl0003oYjNW00;ooooo00GofMWI
ofQXJ?l0003oJ6QXomWIf@02o`0000;ooooo0_l00002ooooo`;o00001?ooool2o`0000?ooooo00Go
fMWIofQXJ?l0003oVYZJooooo`02o`000?ooooooI?ooool00ol00?ooooooooooo`04ooooo`03o`00
oooooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCE
h?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOP[o
oooo2Ol000000onm_Kgoooooooooo`04ooooo`03oo3`l?m=CDgo000000Go000000CofMWIoooooooo
oooohN7Q1Ol000001?oIfMWooooooooooooQhN45o`000004okfm_Oooooooooooode=C@;o000000Co
VYZJooooool0003o00000_ooool00ooYjNWoCDe=o`000003o`000004ode=COo`l?3oooooooooo`;o
00001?ooool2o`0000Kooooo0_l00004ooooo`;o00000_ooool00ooQhN7o0000o`000003o`000004
omWIfOooooooooooohb<S0Co000000GoCDe=o`000?o`l?3oooooon7Qh@07o`0000;ooooo0_l00002
ooooo`;o00001?ooool2o`0000;ooooo00?ohN7Qo`000?l000000_l000000omlO7co0000o`00003o
ooooofCooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`02ooooo`04onk]iOnDUJ;o
ooooooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWh:ooooo`Wo000000?o_Kfmooooooooool01?oo
ool01?nWYjOo0000ogalO?o`l?02ooooo`03ok:b/_l0003oJ6QX00;ooooo00OoVYZJo`000?nWYjOo
ooooomWIfOl0003oJ6QX00;ooooo00OoVYZJo`000?nWYjOoooooomWIfOl0003oJ6QX00;ooooo0_l0
0003ooooo`;o00000_ooool00onWYjOo0000oiZJVP02ooooo`03oiZJV_l0003oYjNW00;ooooo0_l0
0004ooooo`;o00001_ooool2o`0000Cooooo0_l00002ooooo`07oiZJV_l0003oYjNWoooooooIfMWo
0000ofQXJ002ooooo`;o000000?ojNWYooooooo7alL00_l00002ooooo`03oiZJV_l0003oYjNW00;o
oooo00?oYjNWo`000?l000000_ooool2o`0000;ooooo0_l00004ooooo`;o00000_ooool00onJVY[o
0000ojNWY`02ooooo`03ohb<S?l0003o00000?ooooooI?ooool00ol00?ooooooooooo`04ooooo`03
o`00oooooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcU
omCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
OP[ooooo2Ol000000onm_Kgoooooooooo`04ooooo`03ode=COl0003ol?3`00Cooooo0_l00002oooo
o`;o00001oooool2o`0000Oooooo0_l00003ooooo`;o00000_ooool00om=CDgo0000oo3`l002oooo
o`03oo3`l?l0003oCDe=00;ooooo0_l00004ooooo`;o00001_ooool2o`0000Cooooo0_l00002oooo
o`;o00001oooool01OmXJ6So0000ok:b/_oQhN7ol?3`00;o00000_ooool00om=CDgo0000oo3`l002
ooooo`03oo3`l?l0003o000000;ooooo0_l00002ooooo`;o00001?ooool2o`0000;ooooo0_l00000
1?o`l?3oooooooooooo`l?02o`000?ooooooI?ooool00ol00?ooooooooooo`04ooooo`03o`00oooo
oooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>
cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOP[ooooo
2Ol000000onm_Kgoooooooooo`09ooooo`04omWIfOn<S8co0000ofQXJ0;ooooo1ol00002ooooo`;o
00001oooool2o`0000?ooooo0_l00002ooooo`;o00001?ooool2o`0000;ooooo0_l00004ooooo`;o
00001_ooool2o`0000Cooooo0_l00002ooooo`Oo00000_ooool00ooIfMWoCDe=o`000004o`0000;o
oooo0_l00004ooooo`;o00000_ooool2o`0000;ooooo0_l00004ooooo`;o00000_ooool2o`0000Co
oooo0_l0003oooooofCooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`02ooooo`04
onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>l03?oRh^[ofm_Uom_KiOoDeN3oc]3Molc=foo=c]cooooo
oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWh:ooooo`Wo000000?o_Kfmoooo
ooooool01_ooool00oo@d=3oVYZJo`000003o`000004omWIfOooooooooooode=C@Go000000?oCDe=
ooooooooool00_l00007ooooo`;o00000oooool2o`0000;ooooo00?oCDe=o`000?o`l?000_ooool0
0oo`l?3o0000ode=C@02ooooo`;o000000Col?3`oooooooooooooooo0_l00006ooooo`;o000000Co
l?3`oooooooooooooooo0_l00002ooooo`03ode=COl0003o000000?o000000?oCDe=ooooooooool0
0_ooool00ooIfMWo/[:bogalO002o`0000;ooooo0_l000001?o`l?3oooooooooooo`l?02o`0000;o
oooo0_l00002ooooo`;o000000Col?3`oooooooooooooooo0_l00002ooooo`;o000000Col?3`oooo
ooooooool?3`0_l0003oooooofCooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`02
ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>l03?oRh^[ofm_Uom_KiOoDeN3oc]3Molc=foo=
c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWh:ooooo`Wo000000?o
_Kfmooooooooool01Oooool01omlO7co0000o`000?l0003oCDe=ojNWYoo`l?000oooool01onJVY[o
0000on7QhOoooooohN7Qo`000?nJVYX00_ooool01OnJVY[o0000ojNWYooooooohN7Q00;o00000_oo
ool2o`0000?ooooo0_l00002ooooo`03ojNWYol0003oVYZJ00;ooooo00?oVYZJo`000?nWYjL00_oo
ool2o`000004oiZJV_o`l?3ooooookfm_@;o00001_ooool2o`000004ojNWYoo`l?3ooooookfm_@;o
00000_ooool01onJVY[o0000on7QhOoooooohN7Qo`000?nJVYX00_ooool01Om=CDgo0000omWIfOoo
oooojNWY00;o00000_ooool00onJVY[o0000ojNWY`02ooooo`03ojNWYol0003o000000;ooooo0_l0
0002ooooo`;o000000CoVYZJoo3`l?oooooo_Kfm0_l00002ooooo`03oiZJV_l0003oYjNW00;ooooo
00?oVYZJo`000?l00000oooooomTooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool0
0_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>S_00coh^;Zom_KiOoKfnGoe=GPolk@gOo<cM_o
cLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn2_ooool9o`000003
okfm_Ooooooooooo00Cooooo00GoVYZJo`000?l0003oYjNWomWIf@06ooooo`03on7QhOl0003o0000
00?o000000CohN7QoooooooooooohN7Q1Ol000000onJVY[oooooo`000004o`000003ooooool0003o
000000;ooooo00?ol?3`ode=COl000000ol000001?m=CDgol?3`ooooooooool7o`000003oiZJV_oo
oooooooo00Cooooo0_l000000onJVY[o0000o`000002o`000004ojNWYoooooooooooon7Qh@Go0000
00CohN7Qoooooooooooo_Kfm1Ol000001?n<S8cooooooooooooQhN47o`0000;ooooo0_l00002oooo
o`Oo000000CoVYZJoooooooooooohN7Q1?l000000omXJ6So0000o`00003oooooofCooooo00?o003o
ooooooooool01?ooool00ol00?ooooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oX
j>l03?oRh^[ofm_Uom_KiOoDeN3oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWh:ooooo`Wo000000?o_Kfmooooooooool01?ooool2o`000005onWYjOoo
ooooooooooooooo`l?000_l00003ooooo`05omWIfOmXJ6So0000ofQXJ?oIfMT01?ooool01ooIfMWo
O7alo`000?l0003oS8b<onWYjOooool01Ol000000ooooooo0000o`000003ooooo`06onWYjOnJVY[o
0000o`000?nJVY[ojNWY0oooool2o`000005on7QhOnJVY[o0000o`000?nWYjL01oooool2o`000005
oooooonb/[;o0000ode=COnWYjL01?ooool01OoIfMWoJ6QXo`000?mXJ6SofMWI00Cooooo00Ko_Kfm
ode=COl0003o0000oiZJV_oYjNT3ooooo`05omWIfOmXJ6So0000ofQXJ?oIfMT00_l00002ooooo`;o
00000_ooool2o`000005on7QhOnJVY[o0000o`000?nWYjL01?ooool01OoIfMWoJ6QXo`000?n<S8co
jNWY00;o0000oooooomTooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool00_ooool0
1?o^kNGoU9FRooooooogmoT2onc/l@;oj>S_00coh^;Zom_KiOoKfnGoe=GPolk@gOo<cM_ocLkLoooo
oonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn6_ooool00omXJ6So0000okfm
_@02ooooo`04oo3`l?n<S8co0000oiZJVQCooooo0_l0000Oooooo`;o00008?ooool2o`000?oooooo
O?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00;ooooo00Cok^gUoiBEX_oooooo
moOi0_o/k?42onSYkP0<on?RjooKfnKofm_VomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQ[ooooo00?od=3@o`000?l000001?l000000om=CDgo
jNWYooooo`0Cooooo`;o00000oooool2o`0001[ooooo0_l0000Pooooo`;o00000_ooool2o`000?oo
ooooN?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00;ooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?46ohjEXP08olk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVIn6oooool01ooIfMWoS8b<o`000?l0003oCDe=oiZJV_oYjNT05Oooool00ooQ
hN7oS8b<ooooo`02ooooo`;o00006_ooool2o`00023ooooo0_l00002ooooo`;o0000oooooomhoooo
o`03o`00oooooooooooo00Cooooo00?o003oooooooooool00_ooool01Oo^kNGoU9FRooooooogmoWo
k>ca00Kooooo00Woe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIV
O_oko?goZ:VkofIVO_oooooon?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00;o
oooo00Cok^gUoiBEX_oooooomoOi0_o/k?46ohjEXP08olk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooohooooo`03o`00oooooooooooo00Cooooo
00?o003oooooooooool00_ooool01Oo^kNGoU9FRooooooogmoWok>ca00Kooooo00Woe=GPolk?gOo<
cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooon?oo
ool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi
0_o/k?46ohjEXP08olk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVInooooooohooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool00_ooool0
1Oo^kNGoU9FRooooooogmoWok>ca00Kooooo00Woe=GPolk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY
^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooomOooool4o`00o`Kooooo00?o003ooooo
ooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@KoSYFR00Soc/oMolc=foo=c]cooooooiBE
X_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooSooooo00?o003ooooooooo
ool01?ooool00ol00?ooooooooooo`02ooooo`05onk]iOnDUJ;oooooooOgnOo/k?401_ooool02OoD
eN3oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn
ooooooodooooo`Go003o0_ooool5o`00o`Cooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYk`0<
on?Sj_oKfnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVO_ooooooooooool5ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNl03?oS
hn[ofm_Vom_Ki_oDeN7oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWkooooooooooooo1Oooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W_00cohn?Z
om_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVInooooooooooooo`Gooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYk`0<on?Sj_oK
fnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVO_ooooooooooool5ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNl03?oShn[ofm_V
om_Ki_oDeN7oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWkooooooooooooo1Oooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoK
g>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVInooooooooooooo`Gooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Sj_oKg>GofmcU
omGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
O_ooooooooooool5ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoE
eN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWko
oooooooooooo1Oooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQ
olo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooo
ooooooooo`Gooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?
cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooo
ooooool5ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloM
olc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooo
oooo1Oooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<
cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooo
o`Gooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gK
olg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5
ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=
c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Ooo
ool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkL
oooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo
00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?oo
ooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5ooooo`04
onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooo
oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool01?o^
kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonD
UJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00Cok^gU
oiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FR
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5ooooo`04onk]iOnD
UJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool01?o^kNGoU9FR
ooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooooooool5ooooo`04onk]iOnDUJ;ooooo
ooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo1Oooool01?o^kNGoU9FRooooooog
moT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooooooooo`Gooooo00Cok^gUoiBEX_oooooomoOi
0_o/k?42onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooWIfQoonMWJ45oifMX@04onk]iOnDUJ;oooooooOgn@;o
k>ca0_oXjNh03?oSh^_ofm_Vom_Ki_oDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWkoon3Ohoooh=oS1OoPgn<01?o^kNGoU9FRooooooogmoT2onc/
l@;ojNW^00cohn?Zom_Ki_oKfnKoe=GPolk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInoooPgn?oon3Oh`Goh=oS00?ok^gUoiBEX_oFe]/03?ooool01OoF
e]_oU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWh<on3Oh`Oo0000oooPgn?Q
on3Oh`Oo00002OoPgn<00oo^kNGooOgjoi2AW`05okNg_`03okBd_Ong]koo]kNo00Co]kNo00GoT96O
onk]iOmVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn3?oPgn<7o`000?ooh=oShOoP
gn<7o`0000Woh=oS00?ok^gUonc]m?n;S9T03?nMWZ/01On:RiWohnK]ofIVO_nXZK_onocm007oIVIn
00001?mVIWkonocmojRY^omVIWh<on3Oh`Oo0000oooPgn?Qon3Oh`Oo00002OoPgn<00oo^kNGoU9FR
omgNh@0<omWJi005omgNhOnDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVOPco
h=oS00?o0000on3OhooPgn<0oooPgn?[on3Oh`03o`000?oPgn?oh=oS00Ooh=oS00?ok^gUoiBEX_oo
ool03?o;c=X01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWh<on3O
h`03o`000?oPgn?oh=oS0?ooh=oSjooPgn<00ol0003oh=oSon3Oh`07on3Oh`03onk]iOnDUJ;ooooo
00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn3?oPgn<0
0ol0003oh=oSon3Oh`3oon3Ohn_oh=oS00?o0000on3OhooPgn<01ooPgn<00oo^kNGoU9FRooooo`0<
ol_<fP05oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVOPcoh=oS00?o
0000on3OhooPgn<0oooPgn?[on3Oh`03o`000?oPgn?oh=oS00Ooh=oS00?ok^gUoiBEX_ooool03?o;
c=X01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoo`000?oo0000
1Ol000000oo^kNGoU9FRooooo`02ol_<fP03oclm?Oo;c=[oblcJ00?oblcJ00Wo?cdmol_<f_o;c=[o
blcJoooooonDUJ;oIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_l000002?oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`06on3Oh`;o00001ooPgn<01_l0003oh=oSonk]iOnDUJ;oooooolc=f`?o?cdm
0oo<cM/3oclm?@;oc<gK00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_o
IVIno`000008on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Koh=oS0_l00007on3Oh`05o`000?oPgn?ok^gUoiBE
X_ooool00_oAd^03oclm?@04om7Bh?lo?Cgo?cdmoclm?@?odM;P00GooooooiBEX_mVIWkoZ:Vkoo_l
o@01ofIVOP0000GoIVInoo_loOnXZK_oIVIno`00000Aon3Oh`05o`000?oPgn?oh=oSon3Ohol00000
3OoPgn<00ol0003oh=oSon3Oh`0?on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<0
3ooPgn<00ol0003oh=oSo`000003o`0000coh=oS00?o0000on3OhooPgn<03ooPgn<00ol0003oh=oS
on3Oh`0?on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<00_l0000=on3Oh`03o`00
0?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<03ooPgn<00ol0003oh=oSon3Oh`0?on3Oh`05o`00
0?oPgn?oh=oSon3Ohol000003OoPgn<00ol0003oh=oSon3Oh`0?on3Oh`03o`000?oPgn?oh=oS00oo
h=oS00?o0000on3OhooPgn<03ooPgn<00ol0003oh=oSon3Oh`02o`0000goh=oS00?o0000on3OhooP
gn<03ooPgn<00ol0003oh=oSon3Oh`0?on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooP
gn<00_l0000=on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<03ooPgn<00ol0003o
h=oSon3Oh`0?on3Oh`04o`000?oPgn?oh=oSo`0000koh=oS00?o0000on3OhooPgn<03ooPgn<00ol0
003oh=oSon3Oh`0>on3Oh`?o00002OoPgn<00oo^kNGoU9FRooooo`03omWJi0Go?cdm1?oIf^@01Ooo
ooooU9FRofIVO_nXZK_onocm007oIVIn00001OmVIWkonocmojRY^omVIWko0000017oh=oS00Go0000
on3OhooPgn?oh=oSo`00000=on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<03ooP
gn<00ol0003oh=oSon3Oh`0?on3Oh`04o`000?oPgn?oh=oSo`0000koh=oS00?o0000on3OhooPgn<0
3ooPgn<00ol0003oh=oSon3Oh`0?on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3Ohol00000
0_oPgn<00ol0003oh=oSon3Oh`0:on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<0
3ooPgn<00ol0003oh=oSon3Oh`0?on3Oh`03o`000?oPgn?oh=oS00?o00003?oPgn<00ol0003oh=oS
on3Oh`0?on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<03ooPgn<00ol0003oh=oS
o`000002on3Oh`03o`000?oPgn?oh=oS00[oh=oS00?o0000on3OhooPgn<03ooPgn<00ol0003oh=oS
on3Oh`0?on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oS
on3Oh`0:on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<03ooPgn<00ol0003oh=oS
on3Oh`0?on3Oh`04o`000?oPgn?oh=oSo`0000koh=oS00?o0000on3OhooPgn<03ooPgn<00ol0003o
h=oSon3Oh`0=on3Oh`Co00002OoPgn<00oo^kNGoU9FRooooo`04on?Sj`?o?cdm1OoShn/01Ooooooo
U9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWhBon3Oh`05o`000?oPgn?oh=oS
on3Ohol000007ooPgn<00ol0003oh=oSon3Oh`0Qon3Oh`05o`000?oPgn?oh=oSon3Ohol000007ooP
gn<00ol0003oh=oSon3Oh`0Qon3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<07?oP
gn<00ol0003oh=oSon3Oh`0Qon3Oh`03o`000?oPgn?oh=oS00;o00007ooPgn<00ol0003oh=oSon3O
h`0Qon3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<07?oPgn<00ol0003oh=oSon3O
h`0Qon3Oh`03o`000?oPgn?o000000;oh=oS00?o0000on3OhooPgn<07?oPgn<00ol0003oh=oSon3O
h`0Qon3Oh`04o`000?oPgn?oh=oSo`00023oh=oS00?o0000on3OhooPgn<02ooPgn<6o`0000Woh=oS
00?ok^gUoiBEX_ooool01Oo/k?400olo?Cgok>caonc/l@04onc/l@05oooooonDUJ;oIVInojRY^ook
o?d00OmVIWh00004ofIVO_oko?goZ:VkofIVOQ;oh=oS00Go0000on3OhooPgn?oh=oSo`00000Oon3O
h`03o`000?oPgn?oh=oS027oh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003oh=oSon3Oh`0Lon3O
h`03o`000?oPgn?oh=oS027oh=oS00Co0000on3OhooPgn?oh=oS0_l0000Non3Oh`03o`000?oPgn?o
h=oS027oh=oS00?o0000on3OhooPgn<00_l0000Oon3Oh`03o`000?oPgn?oh=oS027oh=oS00?o0000
on3Ohol000000_l0000Oon3Oh`03o`000?oPgn?oh=oS027oh=oS00?o0000on3Ohol000000_l0000O
on3Oh`03o`000?oPgn?oh=oS027oh=oS00Co0000on3OhooPgn?o00008?oPgn<00ol0003oh=oSon3O
h`0=on3Oh`Co00002OoPgn<00oo^kNGoU9FRooooo`0<ooCdm`05oooooonDUJ;oIVInojRY^ooko?d0
0OmVIWh00004ofIVO_oko?goZ:VkofIVOQ;oh=oS00?o0000on3OhooPgn<00_l00013on3Oh`03o`00
0?oPgn?o000000;oh=oS00?o0000on3OhooPgn<0@?oPgn<00ol0003oh=oSon3Oh`02on3Oh`03o`00
0?oPgn?oh=oS043oh=oS00Go0000on3OhooPgn?oh=oSo`000013on3Oh`03o`000?oPgn?o000004Go
h=oS00?o0000on3Ohol00000AOoPgn<01Ol0003oh=oSon3OhooPgn?o0000033oh=oS0ol00009on3O
h`03onk]iOnDUJ;ooooo00conocl00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_l
oOnXZK_oIVIn4_oPgn<01Ol0003oh=oSon3OhooPgn?o000004?oh=oS00?o0000on3OhooPgn<00ol0
0012on3Oh`03o`000?oPgn?o000000?o0000@_oPgn<01Ol0003oh=oSon3OhooPgn?o000004?oh=oS
00?o0000on3OhooPgn<00ol00012on3Oh`03o`000?oPgn?oh=oS00?o0000@_oPgn<00ol0003oh=oS
o`000002o`00037oh=oS0_l00009on3Oh`03onk]iOnDUJ;ooooo00gooooo00CoU9FRofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQ;oh=oS00?o0000on3OhooPgn<0AOoPgn<00ol0003o
h=oSon3Oh`15on3Oh`03o`000?oPgn?oh=oS04Goh=oS00?o0000on3OhooPgn<0AOoPgn<00ol0003o
h=oSon3Oh`15on3Oh`03o`000?oPgn?oh=oS04Goh=oS00?o0000on3OhooPgn<0=?oPgn<00ol0003o
h=oSon3Oh`07on3Oh`03onk]iOnDUJ;oe]KK00cooooo00Goe]KKoiBEX_mVIWkoZ:Vkoo_lo@01ofIV
OP0000CoIVInoo_loOnXZK_oIVIn4_ooool00ol0003oooooooooo`15ooooo`03o`000?oooooooooo
04Gooooo00?o0000ooooooooool0AOooool00ol0003oooooooooo`15ooooo`03o`000?oooooooooo
04Gooooo00?o0000ooooooooool0AOooool00ol0003oooooooooo`0nooooo`05onk]iOoFfmWoSi2N
okFe__nd];h01Ond];d02_nc];go];Bmok>d_Ond];go/k>mohb=W?oFfmWoIVInojRY^ooko?d1ofIV
OP0000?oIVInooOgnOnHV:L0oomgMi;oogMgTQSoMgNB0OnHV:L1ooOgn@7oIVIn00000omVIWkomoOi
okbmc@3ookbmcOoo_;g=6Onl_Ld1ooOgn@7oIVIn00000omVIWkomoOionCSh`3oonCShoooi>?S6OoT
hn<1ooOgn@7oIVIn00000omVIWkol?7dooooo`04ooooo`03ojNWYonSXZ?oXZ:R00;oXJ6Q00?oX:2P
ojFNUOnZW8T00_nOWil2oj2PX0;oXJ6Q00?oYjNWooooooooool0oooooooAooooo`03onCShonLY;Wo
JgF?00;oJgF?0_m/MY05of]eS`06oibT^OoThn?ooooooooooooThn?oW:Bi0om[MHl2ofafT0GoJgF?
00KoW:BionCShooooooooooooncZj_nLY;T3ojHiA0;oYcY41OnV>D@00onLY;Wok>[Zooooo`03oooo
o`7ol?7d0OmVIWh00009ofIVO_oRhN;onocloo_ko?oko?goo?_moiRHVOnKVi_o[:b/00?ojNWY00[o
j^[Zon?6N_oINQCok>c/ong]kOo^k^kolNOEoo3`l?obl_;oXj>S0_olo?`01?olo?goo?cloo_koOol
o?fOoocko9oonoclS_oko?d00onLY;WoJgF?ohF9/009ohF9/006of]eSonLY;Wonocmoo_loOnLY;Wo
JgF?2_n5RK001_m[MHooW:Bioo_ko?oko?goW:BiojHiA0[oZSaE00OoYSU4oibT^Ooko?coo?cloock
oOoko?goh^7R007oIVIn00001?mVIWkoh>3QooKgnOogmoT2ooKgn@05ooKgn?nPX:3oj^[ZonWYjOoj
j:T00_oZj^X02_ohiASocFL0ong]kOo^k^komZPcooK>S?obl_;olo?coj>SXoogmoT3ooKgn@05ooKg
n?ogmoWoal;AooOgnOo7`]400oogmoT01?o7`]7omoOiooOgnOogmoT2olO2d@;omoOi00?oal;AooOg
nOogmoT00_ogmoT3olO2d@?omoOi00Coal;AooOgnOogmoWoal;A0oogmoT00oo7`]7omoOiolO2d@03
olO2dGWomoOiWoofmoV>ooOgn@03of]eSon5RK3oW9jn00WoW9jn00KoQHV`of]eSoogmoWomoOiof]e
Son5RK0:oibN_P08ohF9/?m[MHoomoOhooOgnOnV>DCoZSaEol9BFoo6E5X6olIEG009olIDF_o2DU_o
ZSaEojHiA?ogmoSomoOiooOgn?ogmoWoh>3Q007oIVIn00007omVIWkog]gQoo7am?oalOCol?7doo3b
m?nQXJ?oShn?ohj>S_oYjNWodG/0olXa0?o:MUGoooL0on^[0?oKWWooiJ1iomM20?obl_;olo?cooCd
m?nTY:ColO7doo3bmOoalOColO;doo3bm?l>413oal;Ao`h@4?o7`]400_o`lOD01?l>413oal;Aoo3a
mOo`lOD2o`h@40;ol?7e00?o3Q0@olO2dOo`lOD00_o`lOD3o`h@4008oo3amOo7`]7ol?7eo`h@4?o7
`]7ol?7eo`h@4?o7`]42oo3am@03o`h@4?o7`]7o3Q0@00?o3Q0@00?ol?7eolO2dOo`lOD0ooo`lODG
oo3amHkol?7d00?oJgF?ok:ed?nWZ<802OnWZ<801_nb]M3oJgF?oo3am?o`lOCoJgF?ok:ed0Oooooo
0onWZ<801Onb]M3oJgF?oo3am?o`lOCoYSU400;o`U9K00?obeAIoleIG_o=FEh01?o=FEh01?o;E5Wo
`U9Kol9BFonV>D@2oo3am003oo7am?o`l_Cog]gQ007oIVIn00002OmVIWkog=_Pon[[l?oZjo3oj^c`
onW[konDU9OoXj>SonOViP02on[ZjP0;okL<0?o@N03oonD0oo_<0?oHR03o_dX0okM40?njD3[ofIYQ
oogL0?ni[WX00_oZjo001ooZjnooj^_`on[[l?l>413oal;Ao`h@4?o7`]400_oZjo001Ol>413oal;A
on[[l?l>413oal;A00?oj^_`00Ko3Q0@olO2dOoZjo3oj^_`o`h@4?o7`]42on[[l004o`h@4?o7`]7o
j^_`o`h@40;oj^_`00So3Q0@olO2dOoZjo3oj^_`o`h@4?o7`]7o3Q0@olO2d@;oj^_`00?o3Q0@olO2
dOoZjo00MooZjo2Oon[/l8koj^__00?oJgF?okJidOn][/H01_ooool2ojf^aP03ojb^a_nf^M7oJgF?
00;oj^__00?oJgF?okJidOooool01_m^KHl01OlU9CKo[Jk6ojb^a_nf^M7oJgF?00;oj^_`00?oYSU4
oleIG_o;E5T00_ooool3om1JG`;ooooo00KocEIKol]DFOo=FEkoYSU4on[[kooZjo02on[[k`7og=_P
0OmVIWh00003ofIVO_oGf=kog=kV00?og=kV017og=kUohJ7Q_nnSUKonMm8ooW^@_o/]P3onm00oo2j
0?oZ/03ojK80omZ;0?o?U@3oh[l0ookO0?ofl=coY:FUomcNiP02omcNi@06omcNi_oLg^Go3Q0@olO2
dOl>413oal;A0_oLg^D01Ol>413oal;AomcNiOl>413oal;A00?og=kU00Ko3Q0@olO2dOoLg^Gog=kU
o`h@4?o7`]42omcNi@03o`h@4?o7`]7og=kU00?og=kU00So3Q0@olO2dOoLg^Gog=kUo`h@4?o7`]7o
3Q0@olO2d@;og=kU00?o3Q0@olO2dOoLg^D0oooLg^FUomcNi@04of]eSono`MKo^;W>ooooo`CoKVf?
00Ko9BDfokRic_nh^Lko^;W>oko1e_m[MHl2omcNi@04of]eSono`MKoooooofi]S`Co^;W>00Kooooo
obDU=_nh^Lko^;W>oko1e_m[MHl2omcNi@03ojHiA?o=FEkodEYN00?ooooo00SoeUmSoooooooooooo
ooooomAMHOoAFUkocEUNojHiA0;og=kU00?og=kVomcNiOoGf=h00OmVIWh00004ofIVO_oEe]goeMSP
omKHh@;oeMSP013oNg^0oiBDU?nMO4[oag80onNT0?ooj03ojkH0onVZ0?oX[03odh40okY<0?oR^P3o
n_9gooKfm_ohn?SoYJBU0_oEf>401ooEen3oe]SPomKHhOl>413oal;Ao`h@4?o7`]400_oFen001Ol>
413oal;AomKGh?l>413oal;A00?oe]OP00Ko3Q0@olO2dOo7`]7oe]OPo`h@4?o7`]42omKGh003o`h@
4?o7`]7oe]OP00?oe]OP00So3Q0@olO2dOoFen3oe]OPo`h@4?o7`]7o3Q0@olO2d@;oe]OP00?o3Q0@
olO2dOoFen00MooFen2OomKHh8koeMSQ00?oJgF?ol_<g_o8b]T01_lU9CH01Oo8b]Wob<WIolS:fOo;
c=koJgF?00;oeMSQ00CoJgF?ol_<g_ooooooKVf?0oo8b]T03Oo8bMWoooooobDU=_o8bMWob<[Iol_<
g_m[MHooe]SQomKHh?nV>DCoeemOom]TI?m67QX01Oooool02_m67Q[oh6MUom]TI?oGGeooYSU4omKH
h?oEf>7oeMOPomGHhOoEe]d1ofIVOP0000GoIVInom;DgOo?d]cod=;Lom3Bg@02om3Bg00?oiNGUong
]kOok>c/omjfO_oIR03ol/@0onfa0?oXZP3oe7D0okiX0?ole@3onmmiooSflOoinOWoYJFU00?od=;L
00Gocm;Lom3Bg?l>413oal;Ao`h@4003olO2d@04o`h@4?o@d]cod=;Lo`h@40?oal;A00Ood=;Lo`h@
4?l>413od=;LolO2dOl>413od=;L00;oal;A00?o3Q0@om3Bg?o@d]`00oo@d]`01ol>413oal;AolO2
dOo7`]7o3Q0@om3Bg?l>41000oo7`]400ol>413od=;Lom3Bg01gom3Bg9oocm;MS_o@d]`00om[MHoo
dm?Rolo@g@09olo@g@08om?Ch_m[MHood=;Lom3Bg?m[MHoodm?Roooooom^KHl4olo@g@0=oooooolU
9CKocm3Molo@gOoCdn;oJgF?om3Bg?o?d]coYSU4om]TI?oQJFGoh6aYodHN6P03ooooo`07odHN6_oP
K6Woh6aYon5YIOoKI6CoYSU4om3Bg@02om3Bg07ocm;L0OoBe=d1ofIVOP0001[oIVInom3Bfoo;cMSo
b/gIol_>f?o:cMSoNWb2oiVIVOnVYjKokNg]onO:R_o7J03ol[T0omb90?o:I`3o]S40ok]B0?oobP3o
ok`0oo^i0?og/P3obZ]Pol_=f?o;cMWob/gIol_>f0;o3Q0@00?oblgIo`h@4?l>41000_l>4102ol_=
f@Co3Q0@0_o;cMT00ol>413oblgIo`h@4002ol_=f@?o3Q0@1_o;cMT4o`h@40;oblgI1?l>411jol_=
fIooblkIS_o;cMP01?m[MHooe]KTomSHiOoHf>H2omSHi@;of=SV00Kof=SUomSHi_oHf>Gof=SUomKF
i?m[MHl2ol_=f004of]eSooFe^Coooooofi]S`Gooooo00_o9BDfomSHiOoHf>Goe]KTof]eSoo;cMWo
b/kHojHiA?oTKVgoi7A_onMaK`05ooooo`07onAdKooWLFooi7A_onA^KOnV>DCob/kHol[>f@02ol_=
f@7od=;K0OmVIWh00003ofIVO_o?cm[oaLSD00CoaLSD013oWYjMon?Shoo//UkofYP0om9l0?oNT`3o
fG`0omQi0?nd=03oX0H0onnJ0?oo[03on_K/oo_hlOnfZ8OoaLSD0_o5am@3olG7e@03olO2dOo4amGo
a<OE00Goa<OE00?o3Q0@olO2dOo4amD05_o4amD00ol>413oal;AolC7e@1kolC7eIooa<SDS_o4am@0
0om[MHooeMCSon3OjP09on3OjP07omGDhom[MHooa<ODolC7e?m[MHooeMCSooooo`06ofi]S`0:obDU
=_oPgn[oh=oZomGDhom[MHooaLSDolC8e?nV>DCojWUconUlN0?ooooo00WoAQhJoooooooooooooooo
onn1N_oYO7SojWUcojHiA?o4b=D00_o4b=@1olG7e@7ocloJ0OmVIWh00004ofIVO_o<c][o`/CBol74
d@;o`LCB013oPH><ohf=SOmoMfooh9/0oo3`l?oT_ISok:d0oooO0?ooaP3ojZL0ol9P0?oAM@3on:L]
oo_knoolo?coYZJV0oo1a=800oo2a=7o`LCBo`h@4008ol74d@03o`h@4?o1a=7o`LCA01Ko`LCA00?o
3Q0@ol74dOo1a=40Noo1a=6Ool74dXko`/CB00?oJgF?ong[looYj?402OoYj?401oo]jo?oJgF?ol;4
d_o2a=;oJgF?ong[looYj?401olU9CH2onWXl@07ong[lom[MHoo`/CAol74dOnV>DColH1eoo24O002
ooooo`03odHN6_oa/Y_oAQhJ00;ooooo00WomHb4oo24O?oaP7GoYSU4ol74d_o2a=7o`LCAol74d_o<
c]X00OmVIWh00004ofIVO_o:c=So_/3?okg0c`;o_/3>01GoRhfHoijNW_oEe=Col?3`oo;bl_oXbj_o
n=80ooKTQoocdXgolZ80ono9TOoWaJ;ohH40ooclo?omoOgoYZNWokk0c_nn`<oo_/3>okk0conm`<h0
X?nn`<jOokg0cXko_/3>00?oJgF?om;AhooblOL02OoblOL01_oBdN?oJgF?okk0c_nn`<koJgF?om;A
h`[ol_7g00Ood]7Sof]eSonm`<ko_/3>ojHiA?odRWgomI2500;oAQhJ0oob^9h2odHN6P;omI2500?o
m8YmojHiA?nm`<l00_nn`<l1okk0cP7ob/cH0OmVIWh0000LofIVO_o9b]So][S8okVlbonj_<_o^[c<
okZlbon6QXKoU9BCoo;bl_oclo?oiZ@0ooS][_ofm_Kolm^/onZG0?ojn_[ono_koo7J^ooi]Rooo_kn
ojNWYoni_<co^[_<okVlbonj_<_o^Kc<okVlbioo^Kc<Wonj_<b>okZlb`04ohB<X_m[MHooc<_Moo_k
o0Kooooo00Cono_lolc;gOm[MHooQ8bR0_nj_</01?n4S:;oJgF?olc;gOokno`6ooooo`0;oo_ko?o<
bmgoJgF?ohB<X_nj_<co^Kc<oi6HZ_nV>DCooin=oojoY?ojg;L00_ojjKH2ooWY]P0:oo[L]oon_jCo
oin=ojHiA?nAV:[o^[c<okZkc?ni_<_o][S8olW:f07oIVIn00000omVIWkoa/SGokRgc`03ojn^a`0=
og=bP_nPX:3ohN3Qoo?cloo/ilool^cNooKfm_ohn?SonOWionJ;0?okno_oo?cloogmo@02ooknoP03
ojNWYon_[/Oo[jk70?oo[jk7d_n_[/L00on4S:;oJgF?of]eS`08of]eS`03ohB<X_n_[/Oo[jk700;o
[jk700?oQ8bRof]eSom[MHl02?m[MHl00on4S:;o[jk7ojn^a`02ojn^a`03ohB<X_nV>DCoYSU400So
YSU400?oQ8bRojn^aon_[/L00_n_[/L1okRgc`7oa/SG0OmVIWh00003ofIVO_o0`M7oalOD00Co[:_4
00?oSHf=ojZZZ_nZZZX01OnZZZX00ondYXkoZZZZojZZZP04ojZZZ_oo[:_4oon/Zl@5ojb[a07oalOD
0Oo0`M41ofIVOP0000KoooooojRW_ooVi^god];Pokblcona/<CoojRW_oooZ:No4_nXYkl01Ona/<Co
_;c?om;Bh?oVi^goZ:No007ooooo00001oooooooQhNKomOHh_olo?coi>?Xom3@h?o:b]X0oonl_<oo
okblca3o_;c?00Kob/[Jom3@h?oThnSoo?clomOHh_n7Qi/1ooooo`000_ooool01_nEU:_oemSRoocl
o?oblO?ok>_^on7RjoooemSRoooGf>8>omOHhP06on7Rjoo/jnkol_7cooclo?oGf>;oUIB[0_ooool0
00?ooooo0_mVIWh00on8QigoUIB[ojRW_`3oojRW_oooZ:No3onXYkl01?nEU:_oR8NMofIVO_mVIWh3
ooooo`001OooooooofIVO_ooIVIn5?mVIWh5ooooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{540, 191},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.2"],

Cell["\<\
This sets the default background color for all cells in the \
notebook.\
\>", "MathCaption",
  CellTags->{"S2.11.2", "2.10"}],

Cell[TextData[{
  "Notebook[",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n    Cell[\"Section heading\", \"Section\"],\n    Cell[\"Some text.\", \
\"Text\"]",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  ",\n       Background->GrayLevel[.7]]"
}], "Program",
  CellTags->{"S2.11.2", "2.11"}],

Cell["Now each cell has a gray background. ", "MathCaption",
  CellTags->{"S2.11.2", "2.12"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000EB000`400?l00000o`00003oo`3no_ko
0?knoP`0o_kn00020?kno_l0<c<co`0c<c<903<c<`40o_kn00000`3no_h0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c?o0;:b/_d0/[:b00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<ol0/[:bo@2b/[80103UiND0
VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<co`2b/[;m0;:b/P04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c?o0;:b/_d0
/[:b00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<ol0
/[:bo@2b/[80103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80
<c<co`2b/[;m0;:b/P040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080
VIVI0P0c<c?o0;:b/_d0/[:b00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2I
VIT00P2IVIT203<c<ol0/[:bo@2b/[80103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0
iNGU09VIV@0209VIV@80<c<co`2b/[;m0;:b/P040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h00003
0?knoP3UiND0VIVI0080VIVI0P0c<c?o0;:b/_d0/[:b00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?kn
oP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<ol0/[:bo@2b/[80103UiND0VIVI09VIV@2IVIT203<c
<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<co`2b/[;m0;:b/P040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c?o0;:b/_d0/[:b00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:bo`2c/k?a0;>c/`D0
ATI6102c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI
0P0c<c<20;:b/_l0/k>cm@2c/k<00`16ATH0/k>c0;>c/`020;>c/`030;:b/P3UiND0VIVI0080VIVI
0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:bo`2c/k?e0;>c/`0304I6AP2c
/k<0/k>c0080/k>c00<0/[:b0>GUi@2IVIT00P2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@02
09VIV@80<c<c0P2b/[;o0;>c/oD0/k>c00<0ATI60;>c/`2c/k<00P2c/k<00`2b/[80iNGU09VIV@02
09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/_l0/k>cm@2c/k<00`16
ATH0/k>c0;>c/`020;>c/`030;:b/P3UiND0VIVI0080VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2I
VIT00P2IVIT203<c<`80/[:b302c/k<00`000000/k>c00000002000000<0/k>c0`0000020;>c/`<0
000000@0/k>c000000000000/k>c0P0000020;>c/`8000001P2c/k<00`000000/k>c0;>c/`020000
0080/k>c0P0000000`2c/k<00000000000020;>c/`040000002c/k<0/k>c00000?l0/k>c]`2c/k<0
0`16ATH0/k>c0;>c/`020;>c/`030;:b/P3UiND0VIVI0080VIVI0P0c<c<10?knoP0000<0o_kn0>GU
i@2IVIT00P2IVIT203<c<`80/[:b302c/k<200000080/k>c0P0000000`2c/k<000000;>c/`020;>c
/`040000002c/k<0/k>c00000080/k>c00@000000;>c/`2c/k<000000P2c/k<010000000/k>c0;>c
/`0000040;>c/`040000002c/k<0/k>c00000080/k>c00H000000;>c/`2c/k<000000;>c/`000002
0;>c/`030000002c/k<0/k>c0?l0/k>c^@2c/k<00`16ATH0/k>c0;>c/`020;>c/`030;:b/P3UiND0
VIVI0080VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:b302c/k<00`00
0000/k>c0;>c/`020;>c/`030000002c/k<0000000<0/k>c00@000000;>c/`2c/k<000000P2c/k<0
10000000/k>c0;>c/`0000020;>c/`030000002c/k<0/k>c00D0/k>c00@000000;>c/`2c/k<00000
1P2c/k<01@000000/k>c0;>c/`2c/k<000000?l0/k>c^`2c/k<00`16ATH0/k>c0;>c/`020;>c/`03
0;:b/P3UiND0VIVI0080VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:b
402c/k<2000000030;>c/`000000/k>c0080/k>c00@000000;>c/`2c/k<000000P2c/k<010000000
/k>c0;>c/`0000020;>c/`@00000102c/k<00`000000/k>c0;>c/`04000000<0/k>c00D000000;>c
/`2c/k<0/k>c0000003o0;>c/k/0/k>c00<0ATI60;>c/`2c/k<00P2c/k<00`2b/[80iNGU09VIV@02
09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/Ph0/k>c0`0000020;>c
/`050000002c/k<0/k>c0;>c/`0000000P2c/k<010000000/k>c0;>c/`0000020;>c/`040000002c
/k<0/k>c00000080/k>c00<000000;>c/`2c/k<00P2c/k<010000000/k>c0;>c/`0000020;>c/`06
0000002c/k<0/k>c0000002c/k<000000P2c/k<00`000000/k>c0;>c/`3o0;>c/kT0/k>c00<0ATI6
0;>c/`2c/k<00P2c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI
0080VIVI0P0c<c<20;:b/Pd0/k>c0P0000050;>c/`<000000P2c/k<01@000000/k>c000000000000
/k>c00800000102c/k<2000000@0/k>c0`0000020;>c/`8000000P2c/k<2000000030;>c/`000000
000000<00000o`2c/k>j0;>c/`0304I6AP2c/k<0/k>c0080/k>c00<0/[:b0>GUi@2IVIT00P2IVIT2
03<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c0P2b/[8<0;>c/`030000002c/k<0/k>c
0080/k>c00<000000;>c/`2c/k<05`2c/k<00`000000/k>c0;>c/`0;0;>c/`030000002c/k<0/k>c
0?l0/k>c^@2c/k<00`16ATH0/k>c0;>c/`020;>c/`030;:b/P3UiND0VIVI0080VIVI0P0c<c<10?kn
oP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:b302c/k<010000000/k>c0;>c/`2c/k<20000
0?l0/k>ch`2c/k<00`16ATH0/k>c0;>c/`020;>c/`030;:b/P3UiND0VIVI0080VIVI0P0c<c<10?kn
oP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:b3@2c/k<3000000030;>c/`000000/k>c0?l0
/k>chP2c/k<00`16ATH0/k>c0;>c/`020;>c/`030;:b/P3UiND0VIVI0080VIVI0P0c<c<10?knoP00
00<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:bo`2c/k?b0;>c/`@0ATI6102c/k<00`2b/[80iNGU
09VIV@0209VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/_l0/k>cm@2c
/k<00`16ATH0/k>c0;>c/`020;>c/`030;:b/P3UiND0VIVI0080VIVI0P0c<c<10?knoP0000<0o_kn
0>GUi@2IVIT00P2IVIT203<c<`80/[:bo`2c/k?a0;>c/`D0ATI6102c/k<00`2b/[80iNGU09VIV@02
09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/_l0/k>cnP2c/k<00`2b
/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/_l0
/k>cnP2c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI
0P0c<c<20;:b/_l0/k>cnP2c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3U
iND0VIVI0080VIVI0P0c<c<20;:b/_l0/k>cnP2c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3n
o_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/_l0/k>cnP2c/k<00`2b/[80iNGU09VIV@02
09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/_l0/k>cnP2c/k<00`2b
/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/_l0
/k>cnP2c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI
0P0c<c<20;:b/_l0/k>cnP2c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3U
iND0VIVI0080VIVI0P0c<c<20;:b/_l0/k>cnP2c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3n
o_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/_l0/k>cnP2c/k<00`2b/[80iNGU09VIV@02
09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/_l0/k>cnP2c/k<00`2b
/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/_l0
/k>cnP2c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI
0P0c<c<20;:b/_l0/k>cnP2c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3U
iND0VIVI0080VIVI0P0c<c<20;:b/_l0/k>cnP2c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3n
o_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/_l0/k>cnP2c/k<00`2b/[80iNGU09VIV@02
09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/_l0/k>cl@2c/k<504I6
AP@0/k>c00<0/[:b0>GUi@2IVIT00P2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80
<c<c0P2b/[;o0;>c/oD0/k>c00<0ATI60;>c/`2c/k<00P2c/k<00`2b/[80iNGU09VIV@0209VIV@80
<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/Wl0/k>c1000003o0;>c/g80/k>c
00<0ATI60;>c/`2c/k<00P2c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3U
iND0VIVI0080VIVI0P0c<c<20;:b/Wh0/k>c0P0000020;>c/`800000o`2c/k=a0;>c/`0304I6AP2c
/k<0/k>c0080/k>c00<0/[:b0>GUi@2IVIT00P2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@02
09VIV@80<c<c0P2b/[:30;>c/`800000o`2c/k=`0;>c/`0304I6AP2c/k<0/k>c0080/k>c00<0/[:b
0>GUi@2IVIT00P2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c0P2b/[8;0;>c
/`T00000202c/k<5000000D0/k>c0`0000050;>c/`<00000102c/k<200000080/k>c0P0000040;>c
/`<000000`2c/k<2000000<0/k>c0P0000060;>c/`8000000`2c/k<2000000<0/k>c0`0000040;>c
/`L000000P2c/k<5000000030;>c/`00000000000080/k>c0P0000030;>c/`8000000`2c/k<50000
0?l0/k>cL02c/k<00`16ATH0/k>c0;>c/`020;>c/`030;:b/P3UiND0VIVI0080VIVI0P0c<c<10?kn
oP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:b2`2c/k<9000000L0/k>c0P0000030;>c/`80
00000`2c/k<2000000030;>c/`000000000000<0/k>c0P0000000`2c/k<00000000000020;>c/`80
00000`2c/k<2000000<0/k>c0P0000000`2c/k<00000000000020;>c/`8000000`2c/k<2000000H0
/k>c0P0000030;>c/`8000000P2c/k<2000000030;>c/`00000000000080/k>c0P0000020;>c/`<0
00000P2c/k<2000000050;>c/`00000000000000002c/k<00P0000020;>c/`8000000`2c/k<20000
0080/k>c0P000000102c/k<0000000000000003o0;>c/g00/k>c00<0ATI60;>c/`2c/k<00P2c/k<0
0`2b/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b
/P/0/k>c2@0000060;>c/`8000001@2c/k<2000000030;>c/`000000000000<0/k>c0P0000000`2c
/k<00000000000030;>c/`80000000<0/k>c0000000000000`2c/k<200000080/k>c0P0000030;>c
/`80000000<0/k>c0000000000000`2c/k<2000000H0/k>c0P0000030;>c/`80000000<0/k>c0000
000000000`2c/k<2000000030;>c/`000000000000<0/k>c0P0000000`2c/k<00000000000030;>c
/`80000000<0/k>c0000000000000P2c/k<2000000<0/k>c0P0000000`2c/k<00000000000030;>c
/`800000o`2c/k=`0;>c/`0304I6AP2c/k<0/k>c0080/k>c00<0/[:b0>GUi@2IVIT00P2IVIT203<c
<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c0P2b/[8;0;>c/`T000001P2c/k<2000000D0
/k>c0P0000000`2c/k<00000000000060;>c/`8000001P2c/k<2000000<0/k>c0P0000020;>c/`80
00000`2c/k<2000000030;>c/`000000000000<0/k>c0P0000060;>c/`8000000`2c/k<200000003
0;>c/`000000000000H0/k>c0P0000030;>c/`80000000<0/k>c0000000000000`2c/k<200000003
0;>c/`00000000000080/k>c0P0000030;>c/`80000000<0/k>c0000000000000`2c/k<200000?l0
/k>cL02c/k<00`16ATH0/k>c0;>c/`020;>c/`030;:b/P3UiND0VIVI0080VIVI0P0c<c<10?knoP00
00<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:b2`2c/k<9000000d0/k>c0P0000000`2c/k<00000
00000005000000030;>c/`000000000000H0/k>c0P0000030;>c/`8000000P2c/k<2000000<0/k>c
0P0000000`2c/k<00000000000030;>c/`8000001P2c/k<2000000<0/k>c0P0000000`2c/k<00000
0000000500000080/k>c1P0000000`2c/k<00000000000030;>c/`80000000<0/k>c000000000000
0P2c/k<2000000<0/k>c0P0000000`2c/k<00000000000030;>c/`800000o`2c/k=`0;>c/`0304I6
AP2c/k<0/k>c0080/k>c00<0/[:b0>GUi@2IVIT00P2IVIT203<c<`40o_kn00000`3no_h0iNGU09VI
V@0209VIV@80<c<c0P2b/[8;0;>c/`T00000302c/k<200000080/k>c0P0000030;>c/`80000000<0
/k>c0000000000001P2c/k<2000000<0/k>c0P0000020;>c/`8000000`2c/k<2000000030;>c/`00
0000000000<0/k>c0P0000060;>c/`8000000`2c/k<2000000030;>c/`000000000000<0/k>c0P00
00050;>c/`<0000000<0/k>c0000000000000`2c/k<2000000030;>c/`00000000000080/k>c0P00
00030;>c/`80000000<0/k>c0000000000000`2c/k<200000?l0/k>cL02c/k<00`16ATH0/k>c0;>c
/`020;>c/`030;:b/P3UiND0VIVI0080VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT2
03<c<`80/[:b2`2c/k<9000000P0/k>c1@0000030;>c/`8000000`2c/k<2000000030;>c/`000000
000000<0/k>c0P0000000`2c/k<00000000000030;>c/`8000000P2c/k<2000000<0/k>c0P000000
0`2c/k<00000000000030;>c/`8000001P2c/k<2000000<0/k>c0P0000000`2c/k<0000000000003
0;>c/`80000000<0/k>c0000000000000`2c/k<2000000030;>c/`000000000000<0/k>c0P000000
0`2c/k<00000000000020;>c/`8000000`2c/k<2000000030;>c/`000000000000<0/k>c0P00003o
0;>c/g00/k>c00<0ATI60;>c/`2c/k<00P2c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3no_h0
00030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/P/0/k>c2@0000070;>c/`800000202c/k<20000
00030;>c/`000000000000<0/k>c0P0000020;>c/`80000000<0/k>c0000000000000`2c/k<20000
00<0/k>c0P0000000`2c/k<00000000000020;>c/`<000000P2c/k<2000000H0/k>c0`0000020;>c
/`8000000P2c/k<2000000030;>c/`00000000000080/k>c0P0000030;>c/`8000000P2c/k<20000
00050;>c/`00000000000000002c/k<00P0000020;>c/`<000000P2c/k<200000080/k>c0P000000
102c/k<0000000000000003o0;>c/g00/k>c00<0ATI60;>c/`2c/k<00P2c/k<00`2b/[80iNGU09VI
V@0209VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<20;:b/P/0/k>c2@000006
0;>c/`8000001@2c/k<2000000<0/k>c0`0000050;>c/`@0000000<0/k>c0000000000000P000002
0;>c/`800000102c/k<3000000<0/k>c1P0000070;>c/`H00000102c/k<3000000@0/k>c1@000004
0;>c/`D0000000<0/k>c0000000000000P2c/k<6000000@0/k>c1@00003o0;>c/g00/k>c00<0ATI6
0;>c/`2c/k<00P2c/k<00`2b/[80iNGU09VIV@0209VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI
0080VIVI0P0c<c<20;:b/QX0/k>c0P0000050;>c/`8000004@2c/k<2000001`0/k>c0P00000K0;>c
/`800000o`2c/k>40;>c/`0304I6AP2c/k<0/k>c0080/k>c00<0/[:b0>GUi@2IVIT00P2IVIT203<c
<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c0P2b/[8K0;>c/`8000000`2c/k<200000180
/k>c0P00000L0;>c/`8000006`2c/k<200000?l0/k>cP@2c/k<404I6AP@0/k>c00<0/[:b0>GUi@2I
VIT00P2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c0P2b/[8L0;>c/`D00000
602c/k<2000001L0/k>c0P00000K0;>c/`80000000<0/k>c000000000000o`2c/k>10;>c/`0304I6
AP2c/k<0/k>c0080/k>c00<0/[:b0>GUi@2IVIT00P2IVIT203<c<`40o_kn00000`3no_h0iNGU09VI
V@0209VIV@80<c<c0P2b/[;o0;>c/o40/k>c1@16ATH40;>c/`030;:b/P3UiND0VIVI0080VIVI0P0c
<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:bo`2c/k?j0;>c/`030;:b/P3UiND0
VIVI0080VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:bo`2c/k?j0;>c
/`030;:b/P3UiND0VIVI0080VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80
/[:bo`2c/k?j0;>c/`030;:b/P3UiND0VIVI0080VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT0
0P2IVIT203<c<`80/[:bo`2c/k?j0;>c/`030;:b/P3UiND0VIVI0080VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:bo`2c/k?j0;>c/`030;:b/P3UiND0VIVI0080VIVI0P0c
<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:bo`2c/k?j0;>c/`030;:b/P3UiND0
VIVI0080VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`80/[:bo`2c/k?j0;>c
/`030;:b/P3UiND0VIVI0080VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<a/0
/[:bb@2ZZZ[o0;:b/QT0/[:b00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2I
VIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2I
VIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2I
VIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI
0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?knoP0000<0o_kn
0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0@3UiND103<c<`40o_kn00000`3no_h0iNGU0>GUi@3o0>GU
iOl0iNGU203UiND10?knoP00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 85},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.2"],

Cell[TextData[{
  "If you go outside of ",
  StyleBox["Mathematica", "TI"],
  " and look at the raw text of the file that corresponds to a ",
  StyleBox["Mathematica", "TI"],
  " notebook, you will find that what is in the file is just the textual form \
of the expression that represents the notebook. One way to create a ",
  StyleBox["Mathematica", "TI"],
  " notebook is therefore to construct an appropriate expression and put it \
in a file.   "
}], "Text",
  CellTags->{"S2.11.2", "2.13"}],

Cell[TextData[{
  "In notebook files that are written out by ",
  StyleBox["Mathematica", "TI"],
  ", some additional information is typically included to make it faster for \
",
  StyleBox["Mathematica", "TI"],
  " to read the file in again. The information is enclosed in ",
  StyleBox["Mathematica", "TI"],
  " comments indicated by ",
  StyleBox["(*", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["*)", "MR"],
  " so that it does not affect the actual expression stored in the file. "
}], "Text",
  CellTags->{"S2.11.2", "2.14"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NotebookOpen[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox[".nb\"]", "MR"],
              " "
            }]], Cell["open a notebook file in the front end "]},
          {Cell[TextData[{
              StyleBox["NotebookPut[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create a notebook corresponding to ",
              StyleBox["expr", "TI"],
              " in the front end "
            }]]},
          {Cell[TextData[{
              StyleBox["NotebookGet[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
get the expression corresponding to an open notebook in \
the front end \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.11.2"],

Cell["Setting up notebooks in the front end from the kernel. ", "Caption",
  CellTags->"S2.11.2"],

Cell[TextData[{
  "This writes a notebook expression out to the file ",
  StyleBox["sample.nb", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.11.2", "2.15"}],

Cell["\<\
Notebook[{Cell[\"Section heading\", \"Section\"], Cell[\"Some text.\
\", \"Text\"]}] >> \"sample.nb\"\
\>", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.11.2"],

Cell["This reads the notebook expression back from the file. ", "MathCaption",
  CellTags->{"S2.11.2", "2.16"}],

Cell[CellGroupData[{

Cell["<<sample.nb", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.11.2"],

Cell[BoxData[
    \(Notebook[{Cell["Section heading", "Section"], 
        Cell["Some text.", "Text"]}]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.11.2"]
}, Open  ]],

Cell[TextData[{
  "This opens ",
  StyleBox["sample.nb", "MR"],
  " as a notebook in the front end. "
}], "MathCaption",
  CellTags->{"S2.11.2", "2.17"}],

Cell[CellGroupData[{

Cell["NotebookOpen[\"sample.nb\"]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.11.2"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000E2000`400?l00000o`00003oo`3no_ko
0?knoP`0o_kn00020?kno_l0<c<co`0c<c<903<c<`40o_kn00000`3no_h0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0
iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`3o0?ooooH0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3o
ool0o`3ooooR0?ooo`D0003o0P3oool50000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?kn
oP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3ooooV0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`3o0?ooonH0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<40?ooo`030?knoP3oool0oooo0?l0
ooooiP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3o
ool0o`3ooooV0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0
oooo0?ooo`060?ooo`030000003oool00000008000000`3oool300000080oooo0`000000103oool0
00000000003oool200000080oooo0P0000060?ooo`030000003oool0oooo008000000P3oool20000
00030?ooo`00000000000080oooo00@000000?ooo`3oool00000o`3ooon^0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn0000
0`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`060?ooo`8000000P3oool2
000000030?ooo`000000oooo0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool000000P3oool01P00
0000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3oool0o`3ooon`0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn
00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`060?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000060?oo
o`050000003oool0oooo0?ooo`000000o`3ooonb0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@02
09VIV@80<c<c103oool00`3no_h0oooo0?ooo`0:0?ooo`80000000<0oooo0000003oool00P3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo100000040?ooo`030000
003oool0oooo00@000000`3oool01@000000oooo0?ooo`3oool000000?l0oooo/P3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?kn
oP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0203oool300000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo
00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0oooo0?l0oooo/03oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool01`3oool20000
00D0oooo0`0000020?ooo`050000003oool000000000003oool00P0000040?ooo`800000103oool3
00000080oooo0P0000020?ooo`80000000<0oooo0000000000000`00003o0?oook40oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3n
o_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<40?ooo`030?knoP3oool0oooo00H0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0o`3ooon`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool0
0`3no_h0oooo0?ooo`060?ooo`040000003oool0oooo0?ooo`800000o`3ooooJ0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn
00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`070?ooo`<0000000<0
oooo0000003oool0o`3ooooI0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103o
ool00`3no_h0oooo0?ooo`3o0?ooon<0oooo10000?l60?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0
o_kn0?ooo`3oool0o`3ooooV0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103o
ool00`3no_h0oooo0?ooo`3o0?ooon80oooo1@000?l60?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0
o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3o
ooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2I
VIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0
o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3o
ooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2I
VIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0
o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3o
ooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2I
VIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0
o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3o
ooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2I
VIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3ooooR0?ooo`D0003o1P3oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c
<c<40?ooo`030?knoP3oool0oooo0?l0ooooiP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2I
VIT203<c<`@0oooo00<0o_kn0?ooo`3oool0N@3oool400000?l0ooooJ@3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0N03oool200000080oooo0P00
003o0?ooofP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<40?ooo`030?knoP3o
ool0oooo07d0oooo0P00003o0?ooofL0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c
<c<40?ooo`030?knoP3oool0oooo00D0oooo2@0000080?ooo`D000001@3oool3000000D0oooo0`00
00040?ooo`8000000P3oool2000000@0oooo0`0000030?ooo`8000000`3oool2000000H0oooo0P00
00030?ooo`8000000`3oool3000000@0oooo1`0000020?ooo`D0000000<0oooo0000000000000P3o
ool2000000<0oooo0P0000030?ooo`D00000o`3ooomW0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VI
V@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`050?ooo`T000001`3oool2000000<0oooo0P00
00030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P00
00030?ooo`8000000`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`8000001P3o
ool2000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool200000080oooo0`00
00020?ooo`80000000D0oooo00000000000000000?ooo`0200000080oooo0P0000030?ooo`800000
0P3oool2000000040?ooo`000000000000000?l0ooooI`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2I
VIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool01@3oool9000000H0oooo0P0000050?ooo`80
000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0
0000000000030?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80
00001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`80
00000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?ooofL0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h00003
0?knoP3UiND0VIVI0080VIVI0P0c<c<40?ooo`030?knoP3oool0oooo00D0oooo2@0000060?ooo`80
00001@3oool2000000030?ooo`000000000000H0oooo0P0000060?ooo`8000000`3oool200000080
oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`80
000000<0oooo0000000000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80
000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80
0000o`3ooomW0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0
oooo0?ooo`050?ooo`T000003@3oool2000000030?ooo`000000000000D0000000<0oooo00000000
00001P3oool2000000<0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0
oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000D000000P3oool600000003
0?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool200000003
0?ooo`000000000000<0oooo0P00003o0?ooofL0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080
VIVI0P0c<c<40?ooo`030?knoP3oool0oooo00D0oooo2@00000<0?ooo`8000000P3oool2000000<0
oooo0P0000000`3oool00000000000060?ooo`8000000`3oool200000080oooo0P0000030?ooo`80
000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo00000000
00000`3oool2000000D0oooo0`0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooomW0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`050?ooo`T0
0000203oool5000000<0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool200000003
0?ooo`000000000000<0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0
oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0
0000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080
oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool200000?l0ooooI`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?kn
oP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool01@3oool9000000L0
oooo0P0000080?ooo`80000000<0oooo0000000000000`3oool200000080oooo0P0000000`3oool0
0000000000030?ooo`8000000`3oool2000000030?ooo`00000000000080oooo0`0000020?ooo`80
00001P3oool300000080oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0P0000020?ooo`80000000D0oooo00000000000000000?ooo`0200000080oooo0`0000020?oo
o`8000000P3oool2000000040?ooo`000000000000000?l0ooooI`3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn
0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool01@3oool9000000H0oooo0P000005
0?ooo`8000000`3oool3000000D0oooo100000000`3oool000000000000200000080oooo0P000004
0?ooo`<000000`3oool6000000L0oooo1P0000040?ooo`<00000103oool5000000@0oooo1@000000
0`3oool00000000000020?ooo`H00000103oool500000?l0ooooI`3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn
0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0503oool2000000D0oooo0P00000A
0?ooo`800000703oool2000001/0oooo0P00003o0?ooog/0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0
VIVI0080VIVI0P0c<c<40?ooo`030?knoP3oool0oooo01D0oooo0P0000030?ooo`8000004P3oool2
000001`0oooo0P00000K0?ooo`800000o`3ooomh0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<4
0?ooo`030?knoP3oool0oooo01H0oooo1@00000H0?ooo`8000005`3oool2000001/0oooo0P000000
0`3oool000000000003o0?ooogP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<4
0?ooo`030?knoP3oool0oooo0?l0oooohP3oool50000o`80oooo1@000?l80?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<40?ooo`030?knoP3oool0
oooo0?l0oooomP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@02
09VIV@80<c<c103oool00`3no_h0oooo0?ooo`3o0?ooooH0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooof
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<4
0?ooo`030?knoP3oool0oooo0?l0oooomP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn0000
0`3no_h0iNGU09VIV@0209VIV@80<c<c103ooooo0?kno_@0o_kn1@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103ooooo0?kno_@0o_kn1@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103ooooo
0?kno_@0o_kn1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@02
09VIV@80<c<c103ooooo0?kno_@0o_kn1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn0000
0`3no_h0iNGU09VIV@0209VIV@80<c<c103ooooo0?kno_@0o_kn1@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<1
0?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2I
VIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI
0@3UiND103<c<`40o_kn00000`3no_h0iNGU0>GUi@3o0>GUiOl0iNGU203UiND10?knoP00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 84},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.2"]
}, Open  ]],

Cell[TextData[{
  "Once you have set up a notebook in the front end using ",
  StyleBox["NotebookOpen", "MR"],
  ", you can then manipulate the notebook interactively just as you would any \
other notebook. But in order to use ",
  StyleBox["NotebookOpen", "MR"],
  ", you have to explicitly have a notebook expression in a file. With ",
  StyleBox["NotebookPut", "MR"],
  ", however, you can take a notebook expression that you have created in the \
kernel, and immediately display it as a notebook in the front end.  "
}], "Text",
  CellTags->{"S2.11.2", "2.18"}],

Cell["Here is a notebook expression in the kernel. ", "MathCaption",
  CellTags->{"S2.11.2", "2.19"}],

Cell[CellGroupData[{

Cell["\<\
Notebook[{Cell[\"Section heading\", \"Section\"], Cell[\"Some text.\
\", \"Text\"]}]\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.11.2"],

Cell[BoxData[
    \(Notebook[{Cell["Section heading", "Section"], 
        Cell["Some text.", "Text"]}]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.11.2"]
}, Open  ]],

Cell["\<\
This uses the expression to set up a notebook in the front end. \
\
\>", "MathCaption",
  CellTags->{"S2.11.2", "2.20"}],

Cell[CellGroupData[{

Cell["NotebookPut[%]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.11.2"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000E2000`400?l00000o`00003oo`3no_ko
0?knoP`0o_kn00020?kno_l0<c<co`0c<c<903<c<`40o_kn00000`3no_h0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0
iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`3o0?ooooH0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3o
ool0o`3ooooR0?ooo`D0003o0P3oool50000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?kn
oP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3ooooV0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`3o0?ooonH0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<40?ooo`030?knoP3oool0oooo0?l0
ooooiP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3o
ool0o`3ooooV0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0
oooo0?ooo`060?ooo`030000003oool00000008000000`3oool300000080oooo0`000000103oool0
00000000003oool200000080oooo0P0000060?ooo`030000003oool0oooo008000000P3oool20000
00030?ooo`00000000000080oooo00@000000?ooo`3oool00000o`3ooon^0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn0000
0`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`060?ooo`8000000P3oool2
000000030?ooo`000000oooo0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool000000P3oool01P00
0000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3oool0o`3ooon`0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn
00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`060?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000060?oo
o`050000003oool0oooo0?ooo`000000o`3ooonb0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@02
09VIV@80<c<c103oool00`3no_h0oooo0?ooo`0:0?ooo`80000000<0oooo0000003oool00P3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo100000040?ooo`030000
003oool0oooo00@000000`3oool01@000000oooo0?ooo`3oool000000?l0oooo/P3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?kn
oP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0203oool300000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo
00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0oooo0?l0oooo/03oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool01`3oool20000
00D0oooo0`0000020?ooo`050000003oool000000000003oool00P0000040?ooo`800000103oool3
00000080oooo0P0000020?ooo`80000000<0oooo0000000000000`00003o0?oook40oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3n
o_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<40?ooo`030?knoP3oool0oooo00H0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0o`3ooon`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool0
0`3no_h0oooo0?ooo`060?ooo`040000003oool0oooo0?ooo`800000o`3ooooJ0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn
00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`070?ooo`<0000000<0
oooo0000003oool0o`3ooooI0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103o
ool00`3no_h0oooo0?ooo`3o0?ooon<0oooo10000?l60?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0
o_kn0?ooo`3oool0o`3ooooV0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103o
ool00`3no_h0oooo0?ooo`3o0?ooon80oooo1@000?l60?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0
o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3o
ooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2I
VIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0
o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3o
ooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2I
VIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0
o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3o
ooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2I
VIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0
o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3o
ooo]0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooo]0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2I
VIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3ooooR0?ooo`D0003o1P3oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c
<c<40?ooo`030?knoP3oool0oooo0?l0ooooiP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2I
VIT203<c<`@0oooo00<0o_kn0?ooo`3oool0N@3oool400000?l0ooooJ@3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0
o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0N03oool200000080oooo0P00
003o0?ooofP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<40?ooo`030?knoP3o
ool0oooo07d0oooo0P00003o0?ooofL0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c
<c<40?ooo`030?knoP3oool0oooo00D0oooo2@0000080?ooo`D000001@3oool3000000D0oooo0`00
00040?ooo`8000000P3oool2000000@0oooo0`0000030?ooo`8000000`3oool2000000H0oooo0P00
00030?ooo`8000000`3oool3000000@0oooo1`0000020?ooo`D0000000<0oooo0000000000000P3o
ool2000000<0oooo0P0000030?ooo`D00000o`3ooomW0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VI
V@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`050?ooo`T000001`3oool2000000<0oooo0P00
00030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P00
00030?ooo`8000000`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`8000001P3o
ool2000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool200000080oooo0`00
00020?ooo`80000000D0oooo00000000000000000?ooo`0200000080oooo0P0000030?ooo`800000
0P3oool2000000040?ooo`000000000000000?l0ooooI`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2I
VIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool01@3oool9000000H0oooo0P0000050?ooo`80
000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0
0000000000030?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80
00001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`80
00000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?ooofL0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h00003
0?knoP3UiND0VIVI0080VIVI0P0c<c<40?ooo`030?knoP3oool0oooo00D0oooo2@0000060?ooo`80
00001@3oool2000000030?ooo`000000000000H0oooo0P0000060?ooo`8000000`3oool200000080
oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`80
000000<0oooo0000000000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80
000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80
0000o`3ooomW0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0
oooo0?ooo`050?ooo`T000003@3oool2000000030?ooo`000000000000D0000000<0oooo00000000
00001P3oool2000000<0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0
oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000D000000P3oool600000003
0?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool200000003
0?ooo`000000000000<0oooo0P00003o0?ooofL0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080
VIVI0P0c<c<40?ooo`030?knoP3oool0oooo00D0oooo2@00000<0?ooo`8000000P3oool2000000<0
oooo0P0000000`3oool00000000000060?ooo`8000000`3oool200000080oooo0P0000030?ooo`80
000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo00000000
00000`3oool2000000D0oooo0`0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooomW0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103oool00`3no_h0oooo0?ooo`050?ooo`T0
0000203oool5000000<0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool200000003
0?ooo`000000000000<0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0
oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0
0000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080
oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool200000?l0ooooI`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?kn
oP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool01@3oool9000000L0
oooo0P0000080?ooo`80000000<0oooo0000000000000`3oool200000080oooo0P0000000`3oool0
0000000000030?ooo`8000000`3oool2000000030?ooo`00000000000080oooo0`0000020?ooo`80
00001P3oool300000080oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0P0000020?ooo`80000000D0oooo00000000000000000?ooo`0200000080oooo0`0000020?oo
o`8000000P3oool2000000040?ooo`000000000000000?l0ooooI`3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn
0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool01@3oool9000000H0oooo0P000005
0?ooo`8000000`3oool3000000D0oooo100000000`3oool000000000000200000080oooo0P000004
0?ooo`<000000`3oool6000000L0oooo1P0000040?ooo`<00000103oool5000000@0oooo1@000000
0`3oool00000000000020?ooo`H00000103oool500000?l0ooooI`3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn
0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0503oool2000000D0oooo0P00000A
0?ooo`800000703oool2000001/0oooo0P00003o0?ooog/0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0
VIVI0080VIVI0P0c<c<40?ooo`030?knoP3oool0oooo01D0oooo0P0000030?ooo`8000004P3oool2
000001`0oooo0P00000K0?ooo`800000o`3ooomh0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<4
0?ooo`030?knoP3oool0oooo01H0oooo1@00000H0?ooo`8000005`3oool2000001/0oooo0P000000
0`3oool000000000003o0?ooogP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<4
0?ooo`030?knoP3oool0oooo0?l0oooohP3oool50000o`80oooo1@000?l80?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<40?ooo`030?knoP3oool0
oooo0?l0oooomP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@02
09VIV@80<c<c103oool00`3no_h0oooo0?ooo`3o0?ooooH0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIT203<c<`@0oooo00<0o_kn0?ooo`3oool0o`3oooof
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c<4
0?ooo`030?knoP3oool0oooo0?l0oooomP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn0000
0`3no_h0iNGU09VIV@0209VIV@80<c<c103ooooo0?kno_@0o_kn1@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103ooooo0?kno_@0o_kn1@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<c103ooooo
0?kno_@0o_kn1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn00000`3no_h0iNGU09VIV@02
09VIV@80<c<c103ooooo0?kno_@0o_kn1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40o_kn0000
0`3no_h0iNGU09VIV@0209VIV@80<c<c103ooooo0?kno_@0o_kn1@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40o_kn00000`3no_h0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3no_h000030?knoP3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<1
0?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2I
VIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?knoP0000<0o_kn0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI
0@3UiND103<c<`40o_kn00000`3no_h0iNGU0>GUi@3o0>GUiOl0iNGU203UiND10?knoP00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 84},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.2"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["NotebookGet", "MR"],
  " to get the notebook corresponding to a particular ",
  StyleBox["NotebookObject", "MR"],
  " back into the kernel. "
}], "MathCaption",
  CellTags->{"S2.11.2", "2.21"}],

Cell[CellGroupData[{

Cell["NotebookGet[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.11.2"],

Cell[BoxData[
    \(Notebook[{Cell[
          CellGroupData[{Cell[TextData["Section heading"], "Section"], 
              Cell[TextData["Some text."], "Text"]}, Open]]}]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.11.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.11.3 Manipulating Notebooks from the Kernel", "Subsection",
  CellTags->{"S2.11.3", "3.1"}],

Cell[TextData[{
  "If you want to do simple operations on ",
  StyleBox["Mathematica", "TI"],
  " notebooks, then you will usually find it convenient just to use the \
interactive capabilities of the standard ",
  StyleBox["Mathematica", "TI"],
  " front end. But if you want to do more complicated and systematic \
operations, then you will often find it better to use the kernel. "
}], "Text",
  CellTags->{"S2.11.3", "3.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Notebooks[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["a list of all your open notebooks "]},
          {Cell[TextData[{
              StyleBox["Notebooks[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[
            "a list of all open notebooks with the specified name "]},
          {Cell[TextData[{
              StyleBox["SelectedNotebook[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["the notebook that is currently selected "]},
          {Cell[TextData[{
              StyleBox["InputNotebook[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["the notebook into which typed input will go "]},
          {Cell[TextData[{
              StyleBox["EvaluationNotebook[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "the notebook in which this function is being evaluated "]},
          {Cell[TextData[{
              StyleBox["ButtonNotebook[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
the notebook containing the button (if any) which \
initiated this evaluation \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.3"],

Cell["\<\
Functions that give the notebook objects corresponding to \
particular notebooks. \
\>", "Caption",
  CellTags->"S2.11.3"],

Cell[TextData[{
  "Within the ",
  StyleBox["Mathematica", "TI"],
  " kernel, notebooks that you have open in the front end are referred to by \
",
  StyleBox["notebook objects", "TI"],
  " of the form ",
  StyleBox["NotebookObject[", "MR"],
  StyleBox["fe", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["id", "TI"],
  StyleBox["]", "MR"],
  ". The first argument of ",
  StyleBox["NotebookObject", "MR"],
  " specifies the ",
  StyleBox["FrontEndObject", "MR"],
  " for the front end in which the notebook resides, while the second \
argument gives a unique serial number for the notebook. "
}], "Text",
  CellTags->{"S2.11.3", "3.3"}],

Cell[TextData[{
  "Here is a notebook named ",
  StyleBox["Example.nb", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.11.3", "3.4"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000Jb000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooob0?ooo`D0003o1P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<h40oooo1000003o0?ooog40oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cP03oool200000080
oooo0P00003o0?ooog00oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cQ@3oool200000?l0ooooK`3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<<0?ooo`T00000203oool5000000D0oooo0`0000050?ooo`<000001@3oool3000000<0
oooo0P0000030?ooo`8000000`3oool5000000H0oooo0P0000050?ooo`8000000`3oool3000000@0
oooo1`0000020?ooo`D0000000<0oooo0000000000000P3oool2000000<0oooo0P0000030?ooo`D0
0000o`3ooom_0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@0000070?ooo`8000000`3oool2000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool200000003
0?ooo`00000000000080oooo0P0000030?ooo`8000000P3oool2000000040?ooo`00000000000000
00H0oooo0P0000050?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P0000020?oo
o`<000000P3oool2000000050?ooo`00000000000000003oool00P0000020?ooo`8000000`3oool2
00000080oooo0P000000103oool0000000000000003o0?ooofl0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303o
ool9000000H0oooo0P0000050?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00
0000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3o
ool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000001@3oool2000000030?ooo`00
0000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3o
ool2000000030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3o
ool200000?l0ooooK`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T000001P3oool2000000D0oooo0P00
00000`3oool00000000000060?ooo`8000001P3oool2000000<0oooo0P0000000`3oool000000000
00030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000050?ooo`80000000<0
oooo0000000000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0
oooo0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3o
oom_0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@00000=0?ooo`80000000<0oooo0000000000001@00
00000`3oool00000000000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
00000`3oool00000000000030?ooo`8000001P3oool2000000D0oooo0P0000000`3oool000000000
000500000080oooo1P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3o
ool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom_0?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<``0oooo2@00000<0?ooo`8000000P3oool2000000<0oooo0P0000000`3oool000000000
00060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool000000000
00030?ooo`8000001P3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`8000001@3o
ool3000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3o
ool2000000030?ooo`000000000000<0oooo0P00003o0?ooofl0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303o
ool9000000P0oooo1@0000030?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
00000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00
0000000000<0oooo0P0000060?ooo`T0000000<0oooo0000000000000`3oool2000000030?ooo`00
0000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3o
ool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom_0?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<``0oooo2@0000070?ooo`800000203oool2000000030?ooo`000000000000<0oooo0P00
00020?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0`0000020?ooo`8000000P3o
ool2000000040?ooo`0000000000000000H0oooo0P0000050?ooo`8000000P3oool2000000030?oo
o`00000000000080oooo0P0000030?ooo`8000000P3oool2000000050?ooo`00000000000000003o
ool00P0000020?ooo`<000000P3oool200000080oooo0P000000103oool0000000000000003o0?oo
ofl0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c303oool9000000H0oooo0P0000050?ooo`8000000`3oool30000
00D0oooo100000040?ooo`<000000`3oool6000000@0oooo1@0000060?ooo`8000001@3oool20000
00<0oooo0`0000040?ooo`D00000103oool5000000030?ooo`00000000000080oooo1P0000040?oo
o`D00000o`3ooom_0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo0P0000050?ooo`8000009P3oool20000
00H0oooo0P0000050?ooo`8000005P3oool200000?l0ooooP`3oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<L0?oo
o`8000000`3oool2000002L0oooo0P0000060?ooo`8000001@3oool2000001H0oooo0P00003o0?oo
oh00oooo10000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<M0?ooo`D00000:03oool2000000H0oooo0P0000050?ooo`8000005P3oool20000
00030?ooo`00000000000?l0ooooP03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo80oooo1@000?l60?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooob0?ooo`D0003o1P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<fh0oooo1000003o0?oooh@0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cK@3oool20000
0080oooo0P00003o0?oooh<0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cLP3oool200000?l0ooooPP3oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<<0?ooo`T000001P3oool2000000L0oooo0P0000020?ooo`800000103oool50000
00<0oooo0P0000070?ooo`8000001@3oool2000000<0oooo0`0000040?ooo`L000000P3oool50000
00030?ooo`00000000000080oooo0P0000030?ooo`8000000`3oool500000?l0ooooPP3oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<<0?ooo`T000001P3oool2000000L0oooo0P0000020?ooo`8000000`3oool20000
00<0oooo0P0000000`3oool00000000000080?ooo`8000001@3oool200000080oooo0P0000000`3o
ool00000000000020?ooo`8000000P3oool300000080oooo0P0000001@3oool00000000000000000
oooo008000000P3oool2000000<0oooo0P0000020?ooo`80000000@0oooo0000000000000000o`3o
oon20?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@0000060?ooo`8000001`3oool200000080oooo0P00
00030?ooo`8000000`3oool2000000030?ooo`000000000000P0oooo0P0000050?ooo`80000000<0
oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool000000000
00030?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool000000000
00030?ooo`800000o`3ooon20?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@0000060?ooo`8000001`3o
ool200000080oooo0P0000080?ooo`80000000<0oooo000000000000203oool2000000D0oooo0P00
00000`3oool00000000000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
00000`3oool00000000000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
003o0?oooh80oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool9000000H0oooo0P0000070?ooo`8000000P3o
ool2000000H0oooo0`0000020?ooo`800000203oool2000000D0oooo0P0000000`3oool000000000
000500000080oooo1P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3o
ool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooon20?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<``0oooo2@0000060?ooo`8000001`3oool200000080oooo0P0000040?ooo`<00000103o
ool2000000P0oooo0P0000050?ooo`80000000<0oooo0000000000000`3oool2000000D0oooo0`00
00000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P00
00000`3oool00000000000030?ooo`800000o`3ooon20?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@00
00060?ooo`L000000P3oool200000080oooo0P0000030?ooo`8000000`3oool2000000030?ooo`00
0000000000P0oooo2@0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3o
ool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3o
ool2000000030?ooo`000000000000<0oooo0P00003o0?oooh80oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303o
ool9000000H0oooo0P0000070?ooo`8000000P3oool300000080oooo0P0000030?ooo`80000000<0
oooo000000000000203oool2000000D0oooo0P0000020?ooo`80000000<0oooo0000000000000P3o
ool2000000<0oooo0P0000020?ooo`80000000D0oooo00000000000000000?ooo`0200000080oooo
0`0000020?ooo`8000000P3oool2000000040?ooo`000000000000000?l0ooooPP3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<<0?ooo`T000001P3oool2000000L0oooo0P0000020?ooo`@000000P3oool500000003
0?ooo`0000000000008000001`3oool2000000D0oooo0P0000030?ooo`<00000103oool5000000@0
oooo1@0000000`3oool00000000000020?ooo`H00000103oool500000?l0ooooPP3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<K0?ooo`800000603oool2000000P0oooo0P0000050?ooo`8000005P3oool200000?l0
ooooUP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<K0?ooo`800000603oool2000000P0oooo0P0000050?ooo`80
00005P3oool200000?l0ooooT`3oool40000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo200000000`3oool000000000000I0?ooo`80
00001@3oool2000001H0oooo0P0000000`3oool000000000003o0?oooi<0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooob0?ooo`D0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0@3UiND103<c<`40oooo00000`3o
ool0iNGU0>GUi@3o0>GUiOl0iNGU203UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 107},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"],

Cell["\<\
This finds the corresponding notebook object in the front end. \
\
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.5"}],

Cell[CellGroupData[{

Cell["Notebooks[\"Example.nb\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.11.3"],

Cell["{NotebookObject[<<Example.nb>>]}", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["\<\
This gets the expression corresponding to the notebook into the \
kernel. \
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.6"}],

Cell[CellGroupData[{

Cell["NotebookGet[First[%]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.11.3"],

Cell["\<\
Notebook[{Cell[First Heading, Section],
    Cell[Second Heading, Section]}]\
\>", "Output",
  CellLabel->"Out[2]=",
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[TextData[{
  "This replaces every occurrence of the string ",
  StyleBox["\"Section\"", "MR"],
  " by ",
  StyleBox["\"Text\"", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.11.3", "3.7"}],

Cell[CellGroupData[{

Cell["% /. \"Section\" -> \"Text\"", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.11.3"],

Cell["\<\
Notebook[{Cell[First Heading, Text],
    Cell[Second Heading, Text]}]\
\>", "Output",
  CellLabel->"Out[3]=",
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["This creates a new modified notebook in the front end. ", "MathCaption",
  CellTags->{"S2.11.3", "3.8"}],

Cell[CellGroupData[{

Cell["NotebookPut[%]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000BB000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU102IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GUi@2IVIT0VIVI0080
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI
09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3ooooa0?ooo`D0003o1P3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0103o
ool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=E
0?ooo`<00000o`3ooonM0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cE03oool01@000000oooo0?ooo`3oool0
00000?l0ooooW03oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<e@0oooo00D000000?ooo`3oool0oooo0000003o
0?oooi`0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`030000003oool00000008000000`3oool20000
00<0oooo0P0000030?ooo`<000000P3oool3000000040?ooo`00000000000?ooo`80000000<0oooo
0000000000000`3oool300000080oooo0`0000020?ooo`8000000`3oool2000000030?ooo`000000
oooo0080000000<0oooo0000000000001P000000103oool000000000003oool300000?l0ooooW@3o
ool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<``0oooo0P0000020?ooo`80000000L0oooo0000003oool0oooo0000
003oool000000080oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool000000080oooo0P0000050?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000000P3oool00`000000oooo000000020?ooo`030000003oool000000080oooo0P0000020?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`000000o`3ooonP0?ooo`030000o`3oool0
oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c303oool00`000000oooo0?ooo`020?ooo`030000003oool0000000@0oooo00<000000?oo
o`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00H000000?ooo`3oool000000?oo
o`0000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool010000000oooo
0?ooo`0000040?ooo`060000003oool0oooo0000003oool000000`3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo00000080oooo0P00003o0?oooih0oooo00<0003o0?ooo`3oool0
103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<@0?ooo`80000000<0oooo0000000000000P0000000`3oool000000?ooo`030?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@000000P3oool30000
00030?ooo`000000oooo0080oooo00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`00
0000oooo00000080oooo00<000000?ooo`3oool0o`3ooonK0?ooo`030000o`3oool0oooo00@0oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3o
ool300000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0000000<0
oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000020?ooo`8000001@3oool60000
0080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool000000080oooo0P00
00020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool00`000000oooo
0?ooo`3o0?oooi/0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`8000001@3oool2000000<0oooo0P00
00030?ooo`<000000P3oool010000000oooo0000000000030?ooo`80000000<0oooo0000003oool0
103oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0?ooo`8000000`3oool2000000<0
oooo0P0000000`3oool000000?ooo`02000000030?ooo`000000oooo008000000`3oool400000?l0
ooooW03oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo0?l0ooooZ@3oool00`000?l0oooo0?ooo`040?ooo`030>GU
i@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo00@0
00000?ooo`3oool0oooo0P00000K0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0?l0ooooZ@3oool00`000?l0oooo
0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<`d0oooo0`0000000`3oool000000?ooo`0I0?ooo`800000103oool300000080oooo0`00
000>0?ooo`8000000P3oool00`000000oooo0?ooo`3o0?ooojH0oooo00<0003o0?ooo`3oool0103o
ool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?oooo80oooo10000?l60?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI
0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool@3oool50000o`H0
oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3ooool0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT0
0P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GUi@2I
VIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
oo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3ooool0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo40oooo1@000?l60?ooo`03
0>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m@3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<dP0oooo0`00003o0?ooojX0oooo00<0003o0?ooo`3oool0103o
ool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=7
0?ooo`050000003oool0oooo0?ooo`000000o`3ooonY0?ooo`030000o`3oool0oooo00@0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cA`3oool0
1@000000oooo0?ooo`3oool000000?l0ooooZ@3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2I
VIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo10000003
0?ooo`H0000000@0oooo00000000000000000`3oool00`000000oooo0?ooo`020?ooo`<000000P3o
ool300000080oooo0P0000030?ooo`80000000<0oooo0000003oool00P0000000`3oool000000000
0006000000040?ooo`00000000000?ooo`<00000o`3ooonZ0?ooo`030000o`3oool0oooo00@0oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3o
ool00`000000oooo0?ooo`040?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool0
00000?ooo`0000060?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo000000020?ooo`030000003oool000000080oooo0P0000020?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`000000o`3ooon]0?ooo`030000o`3oool0oooo00@0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool0
0`000000oooo0?ooo`040?ooo`040000003oool0oooo000000@0oooo0P0000000`3oool000000?oo
o`050?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool01P000000oooo
0?ooo`000000oooo000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`800000o`3ooon[0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool01@000000oooo0?ooo`3o
ool000000080oooo00@000000?ooo`3oool000000P3oool2000000<0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@000000P3oool3000000030?oo
o`000000oooo0080oooo00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo
00000080oooo00<000000?ooo`3oool0o`3ooonX0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool50000
0080oooo00<000000?ooo`3oool00P0000001`3oool000000?ooo`3oool000000?ooo`0000001P3o
ool600000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool000000080
oooo0P0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool00`00
0000oooo0?ooo`3o0?ooojP0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`060000003oool0oooo0?oo
o`000000oooo0P0000000`3oool000000?ooo`02000000030?ooo`000000000000@000001@3oool0
0`000000oooo0?ooo`020?ooo`040000003oool0oooo0?ooo`8000000`3oool2000000<0oooo0P00
00000`3oool000000?ooo`02000000030?ooo`000000oooo008000000`3oool400000?l0ooooZ@3o
ool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<`d0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`3o
0?oookH0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0o`3ooonf0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool7000000030?ooo`000000oooo00l0
oooo0`0000020?ooo`<000003P3oool200000080oooo00<000000?ooo`3oool0o`3ooonc0?ooo`03
0000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooob0?ooo`@0003o1P3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0103o
ool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?oooo40oooo1@000?l60?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GUi@2IVIT0VIVI0080VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI09VI
V@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<coP0c<c<00`3U
iND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?n03<c<`03
0>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GU
i@L0iNGU0@0c<c<10?ooo`00o`3ooooo0?ooo``0oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 73},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"],

Cell["{NotebookObject[<<Untitled-1.nb>>]}", "Output",
  CellLabel->"Out[4]=",
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NotebookGet[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "get the notebook expression corresponding to the notebook \
object ",
              StyleBox["obj", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NotebookPut[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "make ",
              StyleBox["expr", "TI"],
              " the expression corresponding to the notebook object ",
              StyleBox["obj", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NotebookPut[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "make ",
              StyleBox["expr", "TI"],
              
              " the expression corresponding to the currently selected \
notebook "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.3"],

Cell["\<\
Exchanging whole notebook expressions between the kernel and front \
end. \
\>", "Caption",
  CellTags->"S2.11.3"],

Cell[TextData[{
  "If you want to do extensive manipulations on a particular notebook you \
will usually find it convenient to use ",
  StyleBox["NotebookGet", "MR"],
  " to get the whole notebook into the kernel as a single expression. But if \
instead you want to do a sequence of small operations on a notebook, then it \
is often better to leave the notebook in the front end, and then to send \
specific commands from the kernel to the front end to tell it what operations \
to do. "
}], "Text",
  CellTags->{"S2.11.3", "3.9"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " is set up so that anything you can do interactively to a notebook in the \
front end you can also do by sending appropriate commands to the front end \
from the kernel. "
}], "Text",
  CellTags->{"S2.11.3", "3.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "give a list of all options set for the notebook corresponding \
to notebook object ",
              StyleBox["obj", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["give the value of a specific option "]},
          {Cell[TextData[{
              StyleBox["AbsoluteOptions[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give absolute option values even when the actual setting is ",
              StyleBox["Automatic", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SetOptions[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["->", "MR"],
              StyleBox["value", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["set the value of an option "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.3"],

Cell["Finding and setting options for notebooks. ", "Caption",
  CellTags->"S2.11.3"],

Cell[TextData[{
  "This gives the setting of the ",
  StyleBox["WindowSize", "MR"],
  " option for your currently selected notebook. "
}], "MathCaption",
  CellTags->{"S2.11.3", "3.11"}],

Cell[CellGroupData[{

Cell["Options[SelectedNotebook[ ], WindowSize]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.11.3"],

Cell[BoxData[
    \({WindowSize \[Rule] {550.`, 600.`}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["\<\
This changes the size of the currently selected notebook on the \
screen. \
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.12"}],

Cell[CellGroupData[{

Cell["SetOptions[SelectedNotebook[ ], WindowSize -> {250, 100}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.11.3"],

Cell["ToBitmap[] FAILED!!!", "Message"],

Cell[TextData[{
  "{WindowSize ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  " {250., 100.}}"
}], "Output",
  CellLabel->"Out[6]=",
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[TextData[{
  "Within any open notebook, the front end always maintains a ",
  StyleBox["current selection", "TI"],
  ". The selection can consist for example of a region of text within a cell \
or of a complete cell. Usually the selection is indicated on the screen by \
some form of highlighting. The selection can also be between two characters \
of text, or between two cells, in which case it is usually indicated on the \
screen by a vertical or horizontal insertion bar.  "
}], "Text",
  CellTags->{"S2.11.3", "3.13"}],

Cell["\<\
You can modify the current selection in an open notebook by issuing \
commands from the kernel.   \
\>", "Text",
  CellTags->{"S2.11.3", "3.14"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SelectionMove[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Next,", "MR"],
              " ",
              StyleBox["unit", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
move the current selection to make it be the next unit \
of the specified type \
\>"]},
          {Cell[TextData[{
              StyleBox["SelectionMove[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Previous,", "MR"],
              " ",
              StyleBox["unit", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["move to the previous unit "]},
          {Cell[TextData[{
              StyleBox["SelectionMove[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["After,", "MR"],
              " ",
              StyleBox["unit", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
move to just after the end of the present unit of the \
specified type \
\>"]},
          {Cell[TextData[{
              StyleBox["SelectionMove[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Before,", "MR"],
              " ",
              StyleBox["unit", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "move to just before the beginning of the present unit "]},
          {Cell[TextData[{
              StyleBox["SelectionMove[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["All,", "MR"],
              " ",
              StyleBox["unit", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
extend the current selection to cover the whole unit of \
the specified type \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.3"],

Cell["Moving the current selection in a notebook. ", "Caption",
  CellTags->"S2.11.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Character", "MR"],
              " "
            }]], Cell["individual character "]},
          {Cell[TextData[{
              StyleBox["Word", "MR"],
              " "
            }]], Cell["word or other token "]},
          {Cell[TextData[{
              StyleBox["Expression", "MR"],
              " "
            }]], Cell["complete subexpression "]},
          {Cell[TextData[{
              StyleBox["TextLine", "MR"],
              " "
            }]], Cell["line of text "]},
          {Cell[TextData[{
              StyleBox["TextParagraph", "MR"],
              " "
            }]], Cell["paragraph of text "]},
          {Cell[TextData[{
              StyleBox["CellContents", "MR"],
              " "
            }]], Cell["the contents of the cell "]},
          {Cell[TextData[{
              StyleBox["Cell", "MR"],
              " "
            }]], Cell["complete cell "]},
          {Cell[TextData[{
              StyleBox["CellGroup", "MR"],
              " "
            }]], Cell["cell group "]},
          {Cell[TextData[{
              StyleBox["EvaluationCell", "MR"],
              " "
            }]], Cell["cell associated with the current evaluation "]},
          {Cell[TextData[{
              StyleBox["ButtonCell", "MR"],
              " "
            }]], 
            Cell["\<\
cell associated with any button that initiated the \
evaluation \
\>"]},
          {Cell[TextData[{
              StyleBox["GeneratedCell", "MR"],
              " "
            }]], Cell["cell generated by the current evaluation "]},
          {Cell[TextData[{
              StyleBox["Notebook", "MR"],
              " "
            }]], Cell["complete notebook "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.3"],

Cell["Units used in specifying selections. ", "Caption",
  CellTags->"S2.11.3"],

Cell["Here is a simple notebook. ", "MathCaption",
  CellTags->{"S2.11.3", "3.15"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000JR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3UiND0oooo03<c<`3o03<c<ol0<c<c200c<c<10>GUi@000P3oool00`3UiND0
<c<c03<c<`3o03<c<ol0<c<c1P0c<c<10?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo
00020?ooool0VIVIo`2IVIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<1
0?ooo`000P3oool309VIVOl0iNGUo`3UiND10>GUi@<0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooool@3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3ooooe0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<c2`3oool9000000H0oooo0P0000050?ooo`8000000`3oool3000000<0oooo0P0000050?ooo`<0
0000203oool2000000<0oooo1@0000080?ooo`L000001P3oool5000000@0oooo0`0000050?ooo`<0
00001@3oool3000000<0oooo0P0000030?ooo`8000000`3oool5000000P0oooo0`0000030?ooo`80
00000`3oool2000000<0oooo0`0000030?ooo`800000o`3ooom:0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0
oooo0P0000050?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P0000040?ooo`80
000000<0oooo0000000000001`3oool200000080oooo0P0000030?ooo`8000001P3oool200000080
oooo0`0000060?ooo`8000000`3oool200000080oooo0P0000000`3oool00000000000030?ooo`80
000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`80
00000P3oool2000000040?ooo`0000000000000000L0oooo0P0000000`3oool00000000000020?oo
o`8000000`3oool200000080oooo0P0000000`3oool000000000003o0?ooodh0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?oo
o`T000001P3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000<0oooo0P0000060?ooo`8000000P3oool2000000<0oooo0P0000060?oo
o`8000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom=0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<c2`3oool9000000H0oooo0P0000050?ooo`80000000<0oooo0000000000001P3oool20000
00<0oooo0P00000;0?ooo`8000001`3oool2000000H0oooo0P0000030?ooo`8000002`3oool20000
00030?ooo`000000000000H0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo000000000000o`3ooomB0?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool90000
00H0oooo0P0000050?ooo`80000000<0oooo0000000000001@0000000`3oool00000000000030?oo
o`L000001P3oool2000000D0oooo0`0000080?ooo`H000002@3oool300000080oooo1`0000000`3o
ool00000000000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000001@00003o0?ooodd0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool20000
00D0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool20000
00<0oooo0P0000060?ooo`8000000`3oool3000000d0oooo0`0000070?ooo`<00000103oool20000
00<0oooo0P0000000`3oool00000000000060?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000`3oool200000?l0ooooC@3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<`/0oooo2@0000060?ooo`T0000000<0oooo0000000000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000030?ooo`8000001P3oool200000080oooo0P0000030?ooo`8000001P3oool20000
00<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000`3oool200000?l0ooooC@3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<`/0oooo2@0000060?ooo`8000001@3oool200000080oooo0P0000000`3oool00000000000020?oo
o`<000000`3oool2000000030?ooo`000000000000L0oooo0P0000020?ooo`8000000`3oool20000
00H0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000020?ooo`80000000<0oooo0000
000000000`3oool200000080oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool30000
0080oooo0P0000020?ooo`80000000@0oooo00000000000000001`3oool2000000030?ooo`000000
00000080oooo0`0000020?ooo`8000000P3oool2000000030?ooo`00000000000?l0ooooCP3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<`/0oooo2@0000060?ooo`8000001@3oool2000000<0oooo0`0000030?ooo`@000000`3oool3
000000P0oooo0P0000030?ooo`D00000203oool5000000P0oooo1@0000040?ooo`<000001@3oool4
000000@0oooo0`0000030?ooo`H00000103oool5000000P0oooo0`0000030?ooo`H00000103oool3
00000?l0ooooC`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`800000IP3oool200000?l0ooooJP3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<aX0oooo0P0000050?ooo`800000IP3oool200000?l0ooooI`3oool40000o`L0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c6P3oool2000000D0oooo0P00000K
0?ooo`800000B@3oool200000?l0ooooJP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooool@3oool50000o`L0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c=K
0?oooa/0fMWIo`3ooomk0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c=K0?oooa/0fMWIo`3ooomo0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<cF`3ooolK0=WIfOl0ooooO`3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<e/0oooo6`3IfMWo0?ooogl0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c=K0?oooa/0fMWIo`3ooomo0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9
000000H0oooo0P0000050?ooo`8000000`3oool3000000<0oooo0P0000050?ooo`<00000203oool2
000000<0oooo1@0000080?ooo`L00000103oool00`3IfMT00000000000030=WIf@8000000P3IfMT2
000000@0fMWI1@0000030=WIf@80000000<0fMWI0?ooo`3oool01P3oool3000000D0oooo0`000003
0?ooo`8000000P3oool200000080oooo0P00003o0?oooel0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2
000000D0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000@0oooo0P000000
0`3oool00000000000070?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000000P3oool3
000000D0oooo00<0fMWI0000000000000`3IfMT200000080fMWI0P0000030=WIf@8000000`3IfMT2
000000030=WIf@00000000000080fMWI1`3oool2000000030?ooo`000000000000<0oooo0P000000
0`3oool00000000000020?ooo`8000000P3oool200000?l0ooooH`3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@000006
0?ooo`8000001@3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0000000000003
0?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P000003
0?ooo`8000001@3oool00`3IfMT00000000000030=WIf@8000000P3IfMT2000000<0fMWI0P000003
0=WIf@80000000<0fMWI0000000000000P3IfMT60?ooo`8000000`3oool2000000030?ooo`000000
000000<0oooo0P0000000`3oool00000000000020?ooo`800000o`3ooomS0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9
000000H0oooo0P0000050?ooo`80000000<0oooo0000000000001P3oool2000000<0oooo0P00000;
0?ooo`8000001`3oool2000000H0oooo0P0000030?ooo`8000001@3oool00`3IfMT0000000000003
0=WIf@8000000P3IfMT2000000P0fMWI0P0000000`3IfMT00000000000020=WIf@H0oooo0P000006
0?ooo`8000001P3oool200000080oooo0P00003o0?ooof<0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2
000000D0oooo0P0000000`3oool0000000000005000000030?ooo`000000000000<0oooo1`000006
0?ooo`8000001@3oool3000000P0oooo1P0000050?ooo`030=WIf@000000000000<0fMWI0P000002
0=WIf@8000001P3IfMT300000080fMWI0P0000020=WIf@H0oooo0P0000060?ooo`L0000000<0oooo
0000000000000P3oool200000?l0ooooH`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool2
000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`8000000`3oool2
000000H0oooo0P0000030?ooo`<000003@3oool3000000D0oooo00<0fMWI0000000000000`3IfMT2
00000080fMWI0P0000040=WIf@<00000103IfMT200000080fMWI1P3oool2000000H0oooo0P000003
0?ooo`80000000<0oooo0000000000000P3oool200000?l0ooooH`3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@000006
0?ooo`T0000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P000003
0?ooo`8000001P3oool200000080oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P000005
0?ooo`030=WIf@000000000000<0fMWI0P0000020=WIf@8000000`3IfMT2000000<0fMWI0P000000
0`3IfMT00000000000020=WIf@H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2
000000030?ooo`00000000000080oooo0P00003o0?ooof<0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2
000000D0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool3000000<0oooo0P000000
0`3oool00000000000070?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2
000000D0oooo00<0fMWI0000000000000`3IfMT200000080fMWI0`0000020=WIf@8000000`3IfMT2
000000030=WIf@00000000000080fMWI1`3oool200000080oooo0P0000020?ooo`80000000<0oooo
0000000000000P3oool200000080oooo0P00003o0?ooof<0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2
000000D0oooo0P0000030?ooo`<000000`3oool4000000<0oooo0`0000080?ooo`8000000`3oool5
000000P0oooo1@0000060?ooo`@000000P3IfMT200000080fMWI100000020=WIf@D0000000<0fMWI
0000000000000P0000000`3IfMT0oooo0?ooo`060?ooo`@00000103oool3000000<0oooo0P000002
0?ooo`800000o`3ooomS0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<c6P3oool2000000D0oooo0P00000h0?ooo`030=WIf@000000
000001@0fMWI0P0000020=WIfAH0oooo0P0000020?ooo`800000o`3ooomS0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c6P3oool2
000000D0oooo0P00000h0?ooo`030=WIf@000000000001@0fMWI0P0000020=WIfAH0oooo0P000002
0?ooo`800000o`3ooomP0?ooo`@0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c<J0?ooo`8000001@3oool2000001/0oooo0P00000K0?ooo`80fMWI0P000002
0=WIf@8000004`3IfMTF0?ooo`8000000P3oool200000?l0ooooH`3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<e/0oooo6`3IfMWo
0?ooog/0oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVIo`0c<c?o
03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<1
0?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo00020?ooool0VIVIo`2IVIT709VIV@80
<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0@3UiND103<c<`40oooo00020?ooool0iNGUo`3U
iND90>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 106},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"],

Cell[TextData[{
  "This sets ",
  StyleBox["nb", "MR"],
  " to be the notebook object corresponding to the currently selected \
notebook. "
}], "MathCaption",
  CellTags->{"S2.11.3", "3.16"}],

Cell["nb = SelectedNotebook[ ];", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.11.3"],

Cell["\<\
This moves the current selection within the notebook to be the next \
word. \
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.17"}],

Cell[CellGroupData[{

Cell["SelectionMove[nb, Next, Word]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000JR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3UiND0oooo03<c<`3o03<c<ol0<c<c200c<c<10>GUi@000P3oool00`3UiND0
<c<c03<c<`3o03<c<ol0<c<c1P0c<c<10?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo
00020?ooool0VIVIo`2IVIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<1
0?ooo`000P3oool309VIVOl0iNGUo`3UiND10>GUi@<0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3ooooa0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000000`3oool2000000D0
oooo0`0000080?ooo`8000000`3oool5000000P0oooo1`0000060?ooo`D00000103oool3000000D0
oooo0`0000050?ooo`<000000`3oool2000000<0oooo0P0000030?ooo`D00000203oool3000000<0
oooo0P0000030?ooo`8000000`3oool3000000<0oooo0P00003o0?ooodX0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T0
00001P3oool2000000D0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000@0
oooo0P0000000`3oool00000000000070?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`80
00000P3oool3000000H0oooo0P0000030?ooo`8000000P3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0P0000020?ooo`80000000@0oooo00000000000000001`3oool2000000030?ooo`0000000000
0080oooo0P0000030?ooo`8000000P3oool2000000030?ooo`00000000000?l0ooooCP3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<`/0oooo2@0000060?ooo`8000001@3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool20000
00H0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?oo
o`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?oo
odd0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000060?oo
o`8000000`3oool2000000/0oooo0P0000070?ooo`8000001P3oool2000000<0oooo0P00000;0?oo
o`80000000<0oooo0000000000001P3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool000000000003o0?oooe80oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?oo
o`T000001P3oool2000000D0oooo0P0000000`3oool0000000000005000000030?ooo`0000000000
00<0oooo1`0000060?ooo`8000001@3oool3000000P0oooo1P0000090?ooo`<000000P3oool70000
00030?ooo`000000000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool000000000000500000?l0ooooC@3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?oo
o`8000001@3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?oo
o`8000000`3oool2000000H0oooo0P0000030?ooo`<000003@3oool3000000L0oooo0`0000040?oo
o`8000000`3oool2000000030?ooo`000000000000H0oooo0P0000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom=0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<c2`3oool9000000H0oooo2@0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000<0oooo0P0000060?ooo`8000000P3oool2000000<0oooo0P0000060?oo
o`8000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom=0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<c2`3oool9000000H0oooo0P0000050?ooo`8000000P3oool2000000030?ooo`0000000000
0080oooo0`0000030?ooo`80000000<0oooo0000000000001`3oool200000080oooo0P0000030?oo
o`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool200000080oooo0P0000000`3o
ool00000000000030?ooo`8000000P3oool200000080oooo0P0000000`3oool00000000000020?oo
o`<000000P3oool200000080oooo0P000000103oool000000000000000070?ooo`80000000<0oooo
0000000000000P3oool300000080oooo0P0000020?ooo`80000000<0oooo000000000000o`3ooom>
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`8000000`3oool3000000<0oooo10000003
0?ooo`<00000203oool2000000<0oooo1@0000080?ooo`D00000203oool5000000@0oooo0`000005
0?ooo`@00000103oool3000000<0oooo1P0000040?ooo`D00000203oool3000000<0oooo1P000004
0?ooo`<00000o`3ooom?0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<c6P3oool2000000D0oooo0P00001V0?ooo`800000o`3ooomZ
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<c6P3oool2000000D0oooo0P00001V0?ooo`800000o`3ooomW0?ooo`@0003o1`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<J0?ooo`8000001@3oool2
000001/0oooo0P0000190?ooo`800000o`3ooomZ0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3ooooa0?ooo`D0003o1`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<g/0oooo603IfMWo0?oooeh0oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<g/0oooo603IfMWo0?ooof80oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c=k0?oooaP0fMWIo`3ooomR
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<cN`3ooolH0=WIfOl0ooooHP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<g/0oooo603IfMWo0?ooof80oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;
0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000000`3oool2000000D0oooo0`000008
0?ooo`8000000`3oool5000000P0oooo1`0000050?ooo`8000000`3oool200000080oooo0P000004
0?ooo`D000000`3oool2000000H0oooo0`3IfMT3000000D0fMWI0`0000030=WIf@8000000P3IfMT2
000000040=WIf@3oool0000000000?l0ooooG`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3o
ool200000080oooo0P0000000`3oool00000000000020?ooo`800000103oool2000000030?ooo`00
0000000000L0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`<000001P3o
ool2000000<0oooo0P0000020?ooo`8000000`3oool2000000<0oooo0P0000000`3oool000000000
00070?ooo`80fMWI0P0000000`3IfMT00000000000030=WIf@80000000<0fMWI0000000000000P3I
fMT200000080fMWI0P0000000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3o
ool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3o
ool2000000<0oooo0P0000060?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000000`3o
ool2000000H0oooo0P0000030?ooo`8000000P3oool2000000<0oooo0P0000030?ooo`80000000<0
oooo0000000000001`3oool00`3IfMT00000000000030=WIf@80000000<0fMWI0000000000000`3I
fMT2000000030=WIf@00000000000080fMWI0P0000000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000060?ooo`8000000`3o
ool2000000/0oooo0P0000070?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3o
ool200000080oooo0P0000080?ooo`80000000<0oooo0000000000001`3oool00`3IfMT000000000
00060=WIf@8000001P3IfMT200000080fMWI0P0000000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool0000000000005000000030?ooo`00
0000000000<0oooo1`0000060?ooo`8000001@3oool3000000P0oooo1P0000060?ooo`8000000`3o
ool200000080oooo0P0000060?ooo`<000000P3oool2000000L0oooo00<0fMWI0000000000001P3I
fMT7000000030=WIf@00000000000080fMWI0P0000000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0
oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`8000000`3oool3000000d0oooo0`00
00060?ooo`8000000`3oool200000080oooo0P0000040?ooo`<00000103oool2000000L0oooo00<0
fMWI0000000000001P3IfMT2000000<0fMWI0P0000000`3IfMT00000000000020=WIf@80000000<0
fMWI0?ooo`3oool0o`3ooomP0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo2@0000000`3oool000000000
00030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`8000000P3o
ool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`8000000P3o
ool2000000<0oooo0P0000030?ooo`80000000<0oooo0000000000001`3oool00`3IfMT000000000
00030=WIf@80000000<0fMWI0000000000000`3IfMT2000000030=WIf@00000000000080fMWI0P00
00000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P00
00020?ooo`80000000<0oooo0000000000000P3oool3000000<0oooo0P0000000`3oool000000000
00070?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0oooo0P00
00030?ooo`8000000P3oool300000080oooo0P0000030?ooo`80000000<0oooo0000000000001`3o
ool20=WIf@8000000P3IfMT200000080fMWI0P0000000`3IfMT00000000000020=WIf@8000000P3I
fMT2000000030=WIf@3oool0oooo0?l0ooooH03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3o
ool2000000<0oooo0`0000030?ooo`@000000`3oool3000000P0oooo0P0000030?ooo`D00000203o
ool5000000H0oooo100000020?ooo`8000000P3oool400000080oooo1@0000000`3oool000000000
0002000000H0oooo0`3IfMT4000000@0fMWI0`0000030=WIf@8000000P3IfMT2000000030=WIf@3o
ool0oooo0?l0ooooH03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`800000>@3oool2000001@0oooo0P00
00070?oooa40fMWI0P0000020=WIf@80000000<0fMWI0?ooo`3oool0o`3ooomP0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c6P3o
ool2000000D0oooo0P00000i0?ooo`800000503oool2000000L0oooo4@3IfMT200000080fMWI0P00
00000`3IfMT0oooo0?ooo`3o0?oooed0oooo10000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`8000006`3oool2000001d0oooo0P00
00020?ooo`800000603ooolA0=WIf@8000000P3IfMT2000000030=WIf@3oool0oooo0?l0ooooH03o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2I
VIT203<c<g/0oooo603IfMWo0?oooeh0oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3o
ool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3o
ool309VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooool0VIVIo`2I
VIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<10?ooo`000P3ooooo09VI
VOl0VIVI1`2IVIT203<c<`40oooo00020?ooool0VIVIo`2IVIT709VIV@40iNGU0@0c<c<10?ooo`00
0P3ooooo0>GUiOl0iNGU2@3UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 106},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["This extends the selection to the complete first cell. ", "MathCaption",
  CellTags->{"S2.11.3", "3.18"}],

Cell[CellGroupData[{

Cell["SelectionMove[nb, All, Cell]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000JR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3UiND0oooo03<c<`3o03<c<ol0<c<c200c<c<10>GUi@000P3oool00`3UiND0
<c<c03<c<`3o03<c<ol0<c<c1P0c<c<10?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo
00020?ooool0VIVIo`2IVIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<1
0?ooo`000P3oool309VIVOl0iNGUo`3UiND10>GUi@<0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oooo40
oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooom@3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0
oooo2@0000060?ooo`8000001@3oool2000000<0oooo0`0000030?ooo`8000001@3oool3000000P0
oooo0P0000030?ooo`D00000203oool7000000H0oooo1@0000040?ooo`<000001@3oool3000000D0
oooo0`0000030?ooo`8000000`3oool2000000<0oooo1@0000080?ooo`<000000`3oool2000000<0
oooo0P0000030?ooo`<000000`3oool200000?l0ooooBP3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`80
00001@3oool200000080oooo0P0000000`3oool00000000000020?ooo`800000103oool200000003
0?ooo`000000000000L0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`<0
00001P3oool2000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000`3oool200000003
0?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool200000080
oooo0P000000103oool000000000000000070?ooo`80000000<0oooo0000000000000P3oool20000
00<0oooo0P0000020?ooo`80000000<0oooo000000000000o`3ooom>0?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool90000
00H0oooo0P0000050?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000030?ooo`8000001P3oool200000080oooo0P0000030?ooo`8000001P3oool20000
00<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000`3oool200000?l0ooooC@3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<`/0oooo2@0000060?ooo`8000001@3oool2000000030?ooo`000000000000H0oooo0P0000030?oo
o`8000002`3oool2000000L0oooo0P0000060?ooo`8000000`3oool2000000/0oooo0P0000000`3o
ool00000000000060?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`00000000000?l0ooooDP3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?oo
o`8000001@3oool2000000030?ooo`000000000000D0000000<0oooo0000000000000`3oool70000
00H0oooo0P0000050?ooo`<00000203oool6000000T0oooo0`0000020?ooo`L0000000<0oooo0000
000000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000D00000o`3ooom=0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo0P0000050?oo
o`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000030?oo
o`8000001P3oool2000000<0oooo0`00000=0?ooo`<000001`3oool3000000@0oooo0P0000030?oo
o`80000000<0oooo0000000000001P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?ooodd0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?oo
o`T000001P3oool9000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?oo
o`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000030?oo
o`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?ooodd0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?oo
o`T000001P3oool2000000D0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool30000
00<0oooo0P0000000`3oool00000000000070?ooo`8000000P3oool2000000<0oooo0P0000060?oo
o`8000000`3oool2000000H0oooo0P0000030?ooo`8000000P3oool2000000030?ooo`0000000000
00<0oooo0P0000020?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0`0000020?oo
o`8000000P3oool2000000040?ooo`0000000000000000L0oooo0P0000000`3oool0000000000002
0?ooo`<000000P3oool200000080oooo0P0000000`3oool000000000003o0?ooodh0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;
0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000000`3oool4000000<0oooo0`000008
0?ooo`8000000`3oool5000000P0oooo1@0000080?ooo`D00000103oool3000000D0oooo10000004
0?ooo`<000000`3oool6000000@0oooo1@0000080?ooo`<000000`3oool6000000@0oooo0`00003o
0?ooodl0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c<J0?ooo`8000001@3oool2000006H0oooo0P00003o0?ooofX0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<J
0?ooo`8000001@3oool2000006H0oooo0P00003o0?ooofL0oooo10000?l70?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`8000006`3oool2
000004T0oooo0P00003o0?ooofX0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oooo40oooo1@000?l70?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooool@3oool5000000L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooo`0?ooo`L000001P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?oooo00oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`04
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooool03oool5
000000030?ooo`000000oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooo`0?ooo`D0000000<0oooo0000003oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oooo00oooo1@0000000`3oool000000?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooool03oool5
000000030?ooo`000000oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`8000000`3oool3000000<0oooo0P000005
0?ooo`<00000203oool2000000<0oooo1@0000080?ooo`L000001@3oool2000000<0oooo0P000002
0?ooo`800000103oool5000000<0oooo0P0000090?ooo`<000001@3oool3000000<0oooo0P000002
0?ooo`8000000P3oool200000?l0ooooFP3oool5000000030?ooo`000000oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo0P000005
0?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P0000040?ooo`80000000<0oooo
0000000000001`3oool200000080oooo0P0000030?ooo`8000001P3oool200000080oooo0`000006
0?ooo`8000000`3oool200000080oooo0P0000030?ooo`8000000`3oool2000000030?ooo`000000
000000T0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool2
00000080oooo0P00003o0?oooeh0oooo1@0000000`3oool000000?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool2
000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`8000000`3oool2
000000H0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`8000001P3oool2
000000<0oooo0P0000020?ooo`8000000`3oool2000000<0oooo0P0000000`3oool0000000000008
0?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0000000000002
0?ooo`800000o`3ooomN0?ooo`D0000000<0oooo0000003oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P000000
0`3oool00000000000060?ooo`8000000`3oool2000000/0oooo0P0000070?ooo`8000001P3oool2
000000<0oooo0P0000060?ooo`8000000`3oool200000080oooo0P0000080?ooo`80000000<0oooo
000000000000203oool2000000H0oooo0P0000060?ooo`8000000P3oool200000?l0ooooGP3oool5
000000030?ooo`000000oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`80000000<0oooo0000000000001@000000
0`3oool00000000000030?ooo`L000001P3oool2000000D0oooo0`0000080?ooo`H000001P3oool2
000000<0oooo0P0000020?ooo`8000001P3oool300000080oooo0P0000080?ooo`8000001P3oool7
000000030?ooo`00000000000080oooo0P00003o0?oooeh0oooo1@0000000`3oool000000?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@000006
0?ooo`8000001@3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0000000000003
0?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`<000003@3oool3000000H0oooo0P000003
0?ooo`8000000P3oool2000000@0oooo0`0000040?ooo`800000203oool2000000H0oooo0P000003
0?ooo`80000000<0oooo0000000000000P3oool200000?l0ooooGP3oool5000000030?ooo`000000
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9
000000H0oooo2@0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2
000000<0oooo0P0000060?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2
000000H0oooo0P0000030?ooo`8000000P3oool2000000<0oooo0P0000030?ooo`80000000<0oooo
000000000000203oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo
0000000000000P3oool200000?l0ooooGP3oool5000000030?ooo`000000oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo0P000005
0?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0`0000030?ooo`80000000<0oooo
0000000000001`3oool200000080oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P000006
0?ooo`8000000`3oool200000080oooo0`0000020?ooo`8000000`3oool2000000030?ooo`000000
000000T0oooo0P0000020?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P000002
0?ooo`800000o`3ooomN0?ooo`D0000000<0oooo0000003oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P000003
0?ooo`<000000`3oool4000000<0oooo0`0000080?ooo`8000000`3oool5000000P0oooo1@000006
0?ooo`@000000P3oool200000080oooo100000020?ooo`D0000000<0oooo0000000000000P000009
0?ooo`@00000103oool3000000<0oooo0P0000020?ooo`800000o`3ooomN0?ooo`D0000000<0oooo
0000003oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<J
0?ooo`8000001@3oool2000003T0oooo0P00000D0?ooo`800000603oool200000080oooo0P00003o
0?oooeh0oooo1@0000000`3oool000000?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`800000>@3oool2000001@0oooo0P00000H
0?ooo`8000000P3oool200000?l0ooooGP3oool2000000@0oooo00<000000?ooo`3oool0103oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<J0?ooo`8000001@3oool2
000001/0oooo0P00000M0?ooo`8000000P3oool2000002T0oooo0P0000020?ooo`800000o`3ooomN
0?ooo`D0000000<0oooo0000003oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?oooo00oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`04
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooool03oool7
000000H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3ooooa
0?ooo`D000001`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooool0VIVIo`2IVIT7
09VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<10?ooo`000P3ooooo09VIVOl0
VIVI1`2IVIT203<c<`40oooo00020?ooool0VIVIo`2IVIT709VIV@40iNGU0@0c<c<10?ooo`000P3o
oooo0>GUiOl0iNGU2@3UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 106},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["This puts the selection at the end of the whole notebook. ", \
"MathCaption",
  CellTags->{"S2.11.3", "3.19"}],

Cell[CellGroupData[{

Cell["SelectionMove[nb, After, Notebook]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000P2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool000030>GUi@3oool0<c<c0?l0<c<co`0c<c<803<c<`40
iNGU00020?ooo`030>GUi@0c<c<0<c<c0?l0<c<co`0c<c<603<c<`40oooo00020?ooool0VIVIo`2I
VIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<10?ooo`000P3ooooo09VI
VOl0VIVI1`2IVIT203<c<`40oooo00020?ooo`<0VIVIo`3UiNGo0>GUi@40iNGU0`2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
0P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo
0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c<50?ooool0<c<cm`0c<c<00`3oool0iNGU09VIV@0209VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3o
ool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3o
ool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c?o0?oooo40oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2I
VIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooom@3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2I
VIT203<c<`/0oooo2@0000060?ooo`8000001@3oool2000000<0oooo0`0000030?ooo`8000001@3o
ool3000000P0oooo0P0000030?ooo`D00000203oool7000000H0oooo1@0000040?ooo`<000001@3o
ool3000000D0oooo0`0000030?ooo`8000000`3oool2000000<0oooo1@0000080?ooo`<000000`3o
ool2000000<0oooo0P0000030?ooo`<000000`3oool200000?l0ooooBP3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@00
00060?ooo`8000001@3oool200000080oooo0P0000000`3oool00000000000020?ooo`800000103o
ool2000000030?ooo`000000000000L0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P00
00020?ooo`<000001P3oool2000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000`3o
ool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3o
ool200000080oooo0P000000103oool000000000000000070?ooo`80000000<0oooo000000000000
0P3oool2000000<0oooo0P0000020?ooo`80000000<0oooo000000000000o`3ooom>0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c
2`3oool9000000H0oooo0P0000050?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`000000000000<0oooo0P0000030?ooo`8000001P3oool200000080oooo0P0000030?ooo`800000
1P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo
0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`000000000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2000000<0oooo
0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool200000?l0oooo
C@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo
0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool2000000030?ooo`000000000000H0oooo
0P0000030?ooo`8000002`3oool2000000L0oooo0P0000060?ooo`8000000`3oool2000000/0oooo
0P0000000`3oool00000000000060?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000030?ooo`00000000000?l0ooooDP3oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo
2@0000060?ooo`8000001@3oool2000000030?ooo`000000000000D0000000<0oooo000000000000
0`3oool7000000H0oooo0P0000050?ooo`<00000203oool6000000T0oooo0`0000020?ooo`L00000
00<0oooo0000000000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000
00<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo000000000000
0`3oool2000000030?ooo`000000000000D00000o`3ooom=0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo
0P0000050?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo
0P0000030?ooo`8000001P3oool2000000<0oooo0`00000=0?ooo`<000001`3oool3000000@0oooo
0P0000030?ooo`80000000<0oooo0000000000001P3oool2000000<0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?ooodd0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI
0P0c<c<;0?ooo`T000001P3oool9000000030?ooo`000000000000<0oooo0P0000000`3oool00000
000000030?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool2000000H0oooo
0P0000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000
00<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?ooodd0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI
0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000020?ooo`80000000<0oooo000000000000
0P3oool3000000<0oooo0P0000000`3oool00000000000070?ooo`8000000P3oool2000000<0oooo
0P0000060?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`8000000P3oool2000000030?oo
o`000000000000<0oooo0P0000020?ooo`8000000P3oool2000000030?ooo`00000000000080oooo
0`0000020?ooo`8000000P3oool2000000040?ooo`0000000000000000L0oooo0P0000000`3oool0
0000000000020?ooo`<000000P3oool200000080oooo0P0000000`3oool000000000003o0?ooodh0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000000`3oool4000000<0
oooo0`0000080?ooo`8000000`3oool5000000P0oooo1@0000080?ooo`D00000103oool3000000D0
oooo100000040?ooo`<000000`3oool6000000@0oooo1@0000080?ooo`<000000`3oool6000000@0
oooo0`00003o0?ooodl0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c<J0?ooo`8000001@3oool2000006H0oooo0P00003o0?ooofX0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c<J0?ooo`8000001@3oool2000006H0oooo0P00003o0?ooofL0oooo10000?l70?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`80
00006`3oool2000004T0oooo0P00003o0?ooofX0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oooo40oooo1@000?l70?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3ooooa0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000000`3oool2000000D0
oooo0`0000080?ooo`8000000`3oool5000000P0oooo1`0000050?ooo`8000000`3oool200000080
oooo0P0000040?ooo`D000000`3oool2000000T0oooo0`0000050?ooo`<000000`3oool200000080
oooo0P0000020?ooo`800000o`3ooomO0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`80
00000P3oool2000000030?ooo`00000000000080oooo0P0000040?ooo`80000000<0oooo00000000
00001`3oool200000080oooo0P0000030?ooo`8000001P3oool200000080oooo0`0000060?ooo`80
00000`3oool200000080oooo0P0000030?ooo`8000000`3oool2000000030?ooo`000000000000T0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool200000080
oooo0P00003o0?ooof<0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool0
0000000000030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`80
00000P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`80
00000P3oool2000000<0oooo0P0000030?ooo`80000000<0oooo000000000000203oool2000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool200000?l0
ooooH`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool2000000030?ooo`000000000000H0
oooo0P0000030?ooo`8000002`3oool2000000L0oooo0P0000060?ooo`8000000`3oool2000000H0
oooo0P0000030?ooo`8000000P3oool2000000P0oooo0P0000000`3oool00000000000080?ooo`80
00001P3oool2000000H0oooo0P0000020?ooo`800000o`3ooomS0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0
oooo0P0000050?ooo`80000000<0oooo0000000000001@0000000`3oool00000000000030?ooo`L0
00001P3oool2000000D0oooo0`0000080?ooo`H000001P3oool2000000<0oooo0P0000020?ooo`80
00001P3oool300000080oooo0P0000080?ooo`8000001P3oool7000000030?ooo`00000000000080
oooo0P00003o0?ooof<0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool0
0000000000030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`80
00000`3oool3000000d0oooo0`0000060?ooo`8000000`3oool200000080oooo0P0000040?ooo`<0
0000103oool2000000P0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`00000000000080
oooo0P00003o0?ooof<0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool9000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`80
00000`3oool2000000H0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000020?ooo`80
00000`3oool2000000<0oooo0P0000000`3oool00000000000080?ooo`8000000`3oool200000003
0?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`800000o`3ooomS0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<c2`3oool9000000H0oooo0P0000050?ooo`8000000P3oool2000000030?ooo`00000000000080
oooo0`0000030?ooo`80000000<0oooo0000000000001`3oool200000080oooo0P0000030?ooo`80
00001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool200000080oooo0`0000020?ooo`80
00000`3oool2000000030?ooo`000000000000T0oooo0P0000020?ooo`8000000P3oool200000003
0?ooo`00000000000080oooo0P0000020?ooo`800000o`3ooomS0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0
oooo0P0000050?ooo`8000000`3oool3000000<0oooo100000030?ooo`<00000203oool2000000<0
oooo1@0000080?ooo`D000001P3oool400000080oooo0P0000020?ooo`@000000P3oool500000003
0?ooo`0000000000008000002@3oool4000000@0oooo0`0000030?ooo`8000000P3oool200000?l0
ooooH`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`800000>@3oool2000001@0oooo0P00000H0?ooo`80
00000P3oool200000?l0ooooH`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`800000>@3oool2000001@0
oooo0P00000H0?ooo`8000000P3oool200000?l0ooooH03oool40000o`L0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c6P3oool2000000D0oooo0P00000K0?ooo`80
00007@3oool200000080oooo0P00000Y0?ooo`8000000P3oool200000?l0ooooH`3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooool@3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooool0VIVIo`2IVIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI
0P0c<c<10?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo00020?ooool0VIVIo`2IVIT7
09VIV@40iNGU0@0c<c<10?ooo`000P3ooooo0>GUiOl0iNGU2@3UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 128},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NotebookFind[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["data", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
move the current selection to the next occurrence of \
the specified data in a notebook \
\>"]},
          {Cell[TextData[{
              StyleBox["NotebookFind[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["data", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Previous]", "MR"],
              " "
            }]], Cell["move to the previous occurrence "]},
          {Cell[TextData[{
              StyleBox["NotebookFind[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["data", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["All]", "MR"],
              " "
            }]], Cell["make the current selection cover all occurrences "]},
          {Cell[TextData[{
              StyleBox["NotebookFind[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["data", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dir", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["elems", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "search in the specified elements of each cell, going in \
direction ",
              StyleBox["dir", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NotebookFind[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["text", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["IgnoreCase->True]", "MR"],
              " "
            }]], 
            Cell["\<\
do not distinguish upper\[Hyphen] and \
lower\[Hyphen]case letters in text \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.3"],

Cell["Searching the contents of a notebook. ", "Caption",
  CellTags->"S2.11.3"],

Cell[TextData[{
  "This moves the current selection to the position of the previous \
occurrence of the word ",
  StyleBox["cell", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.11.3", "3.20"}],

Cell[CellGroupData[{

Cell["NotebookFind[nb, \"cell\", Previous]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000JR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3UiND0oooo03<c<`3o03<c<ol0<c<c200c<c<10>GUi@000P3oool00`3UiND0
<c<c03<c<`3o03<c<ol0<c<c1P0c<c<10?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo
00020?ooool0VIVIo`2IVIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<1
0?ooo`000P3oool309VIVOl0iNGUo`3UiND10>GUi@<0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3ooooa0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000000`3oool2000000D0
oooo0`0000080?ooo`8000000`3oool5000000P0oooo1`0000060?ooo`D00000103oool3000000D0
oooo0`0000050?ooo`<000000`3oool2000000<0oooo0P0000030?ooo`D00000203oool3000000<0
oooo0P0000030?ooo`8000000`3oool3000000<0oooo0P00003o0?ooodX0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T0
00001P3oool2000000D0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000@0
oooo0P0000000`3oool00000000000070?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`80
00000P3oool3000000H0oooo0P0000030?ooo`8000000P3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0P0000020?ooo`80000000@0oooo00000000000000001`3oool2000000030?ooo`0000000000
0080oooo0P0000030?ooo`8000000P3oool2000000030?ooo`00000000000?l0ooooCP3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<`/0oooo2@0000060?ooo`8000001@3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool20000
00H0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?oo
o`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?oo
odd0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000060?oo
o`8000000`3oool2000000/0oooo0P0000070?ooo`8000001P3oool2000000<0oooo0P00000;0?oo
o`80000000<0oooo0000000000001P3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool000000000003o0?oooe80oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?oo
o`T000001P3oool2000000D0oooo0P0000000`3oool0000000000005000000030?ooo`0000000000
00<0oooo1`0000060?ooo`8000001@3oool3000000P0oooo1P0000090?ooo`<000000P3oool70000
00030?ooo`000000000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool000000000000500000?l0ooooC@3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?oo
o`8000001@3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?oo
o`8000000`3oool2000000H0oooo0P0000030?ooo`<000003@3oool3000000L0oooo0`0000040?oo
o`8000000`3oool2000000030?ooo`000000000000H0oooo0P0000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom=0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<c2`3oool9000000H0oooo2@0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000<0oooo0P0000060?ooo`8000000P3oool2000000<0oooo0P0000060?oo
o`8000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom=0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<c2`3oool9000000H0oooo0P0000050?ooo`8000000P3oool2000000030?ooo`0000000000
0080oooo0`0000030?ooo`80000000<0oooo0000000000001`3oool200000080oooo0P0000030?oo
o`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool200000080oooo0P0000000`3o
ool00000000000030?ooo`8000000P3oool200000080oooo0P0000000`3oool00000000000020?oo
o`<000000P3oool200000080oooo0P000000103oool000000000000000070?ooo`80000000<0oooo
0000000000000P3oool300000080oooo0P0000020?ooo`80000000<0oooo000000000000o`3ooom>
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`8000000`3oool3000000<0oooo10000003
0?ooo`<00000203oool2000000<0oooo1@0000080?ooo`D00000203oool5000000@0oooo0`000005
0?ooo`@00000103oool3000000<0oooo1P0000040?ooo`D00000203oool3000000<0oooo1P000004
0?ooo`<00000o`3ooom?0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<c6P3oool2000000D0oooo0P00001V0?ooo`800000o`3ooomZ
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<c6P3oool2000000D0oooo0P00001V0?ooo`800000o`3ooomW0?ooo`@0003o1`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<J0?ooo`8000001@3oool2
000001/0oooo0P0000190?ooo`800000o`3ooomZ0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3ooooa0?ooo`D0003o1`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<g/0oooo603IfMWo0?oooeh0oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<g/0oooo603IfMWo0?ooof80oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c=k0?oooaP0fMWIo`3ooomR
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<cN`3ooolH0=WIfOl0ooooHP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<g/0oooo603IfMWo0?ooof80oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;
0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000000`3oool2000000D0oooo0`000008
0?ooo`8000000`3oool5000000P0oooo1`0000050?ooo`8000000`3oool200000080oooo0P000004
0?ooo`D000000`3oool2000000H0oooo0`3IfMT3000000D0fMWI0`0000030=WIf@8000000P3IfMT2
000000040=WIf@3oool0000000000?l0ooooG`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3o
ool200000080oooo0P0000000`3oool00000000000020?ooo`800000103oool2000000030?ooo`00
0000000000L0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`<000001P3o
ool2000000<0oooo0P0000020?ooo`8000000`3oool2000000<0oooo0P0000000`3oool000000000
00070?ooo`80fMWI0P0000000`3IfMT00000000000030=WIf@80000000<0fMWI0000000000000P3I
fMT200000080fMWI0P0000000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3o
ool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3o
ool2000000<0oooo0P0000060?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000000`3o
ool2000000H0oooo0P0000030?ooo`8000000P3oool2000000<0oooo0P0000030?ooo`80000000<0
oooo0000000000001`3oool00`3IfMT00000000000030=WIf@80000000<0fMWI0000000000000`3I
fMT2000000030=WIf@00000000000080fMWI0P0000000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000060?ooo`8000000`3o
ool2000000/0oooo0P0000070?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3o
ool200000080oooo0P0000080?ooo`80000000<0oooo0000000000001`3oool00`3IfMT000000000
00060=WIf@8000001P3IfMT200000080fMWI0P0000000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool0000000000005000000030?ooo`00
0000000000<0oooo1`0000060?ooo`8000001@3oool3000000P0oooo1P0000060?ooo`8000000`3o
ool200000080oooo0P0000060?ooo`<000000P3oool2000000L0oooo00<0fMWI0000000000001P3I
fMT7000000030=WIf@00000000000080fMWI0P0000000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0
oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`8000000`3oool3000000d0oooo0`00
00060?ooo`8000000`3oool200000080oooo0P0000040?ooo`<00000103oool2000000L0oooo00<0
fMWI0000000000001P3IfMT2000000<0fMWI0P0000000`3IfMT00000000000020=WIf@80000000<0
fMWI0?ooo`3oool0o`3ooomP0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo2@0000000`3oool000000000
00030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`8000000P3o
ool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`8000000P3o
ool2000000<0oooo0P0000030?ooo`80000000<0oooo0000000000001`3oool00`3IfMT000000000
00030=WIf@80000000<0fMWI0000000000000`3IfMT2000000030=WIf@00000000000080fMWI0P00
00000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P00
00020?ooo`80000000<0oooo0000000000000P3oool3000000<0oooo0P0000000`3oool000000000
00070?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0oooo0P00
00030?ooo`8000000P3oool300000080oooo0P0000030?ooo`80000000<0oooo0000000000001`3o
ool20=WIf@8000000P3IfMT200000080fMWI0P0000000`3IfMT00000000000020=WIf@8000000P3I
fMT2000000030=WIf@3oool0oooo0?l0ooooH03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3o
ool2000000<0oooo0`0000030?ooo`@000000`3oool3000000P0oooo0P0000030?ooo`D00000203o
ool5000000H0oooo100000020?ooo`8000000P3oool400000080oooo1@0000000`3oool000000000
0002000000H0oooo0`3IfMT4000000@0fMWI0`0000030=WIf@8000000P3IfMT2000000030=WIf@3o
ool0oooo0?l0ooooH03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`800000>@3oool2000001@0oooo0P00
00070?oooa40fMWI0P0000020=WIf@80000000<0fMWI0?ooo`3oool0o`3ooomP0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c6P3o
ool2000000D0oooo0P00000i0?ooo`800000503oool2000000L0oooo4@3IfMT200000080fMWI0P00
00000`3IfMT0oooo0?ooo`3o0?oooed0oooo10000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`8000006`3oool2000001d0oooo0P00
00020?ooo`800000603ooolA0=WIf@8000000P3IfMT2000000030=WIf@3oool0oooo0?l0ooooH03o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2I
VIT203<c<g/0oooo603IfMWo0?oooeh0oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3o
ool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3o
ool309VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooool0VIVIo`2I
VIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<10?ooo`000P3ooooo09VI
VOl0VIVI1`2IVIT203<c<`40oooo00020?ooool0VIVIo`2IVIT709VIV@40iNGU0@0c<c<10?ooo`00
0P3ooooo0>GUiOl0iNGU2@3UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 106},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[TextData[{
  "The letter ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\)], "InlineFormula"],
  " does not appear in the current notebook, so ",
  StyleBox["$Failed", "MR"],
  " is returned, and the selection is not moved. "
}], "MathCaption",
  CellTags->{"S2.11.3", "3.21"}],

Cell[CellGroupData[{

Cell["NotebookFind[nb, \"\\[Alpha]\", Next]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000JR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3UiND0oooo03<c<`3o03<c<ol0<c<c200c<c<10>GUi@000P3oool00`3UiND0
<c<c03<c<`3o03<c<ol0<c<c1P0c<c<10?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo
00020?ooool0VIVIo`2IVIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<1
0?ooo`000P3oool309VIVOl0iNGUo`3UiND10>GUi@<0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3ooooa0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000000`3oool2000000D0
oooo0`0000080?ooo`8000000`3oool5000000P0oooo1`0000060?ooo`D00000103oool3000000D0
oooo0`0000050?ooo`<000000`3oool2000000<0oooo0P0000030?ooo`D00000203oool3000000<0
oooo0P0000030?ooo`8000000`3oool3000000<0oooo0P00003o0?ooodX0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T0
00001P3oool2000000D0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000@0
oooo0P0000000`3oool00000000000070?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`80
00000P3oool3000000H0oooo0P0000030?ooo`8000000P3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0P0000020?ooo`80000000@0oooo00000000000000001`3oool2000000030?ooo`0000000000
0080oooo0P0000030?ooo`8000000P3oool2000000030?ooo`00000000000?l0ooooCP3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<`/0oooo2@0000060?ooo`8000001@3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool20000
00H0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?oo
o`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?oo
odd0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000060?oo
o`8000000`3oool2000000/0oooo0P0000070?ooo`8000001P3oool2000000<0oooo0P00000;0?oo
o`80000000<0oooo0000000000001P3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool000000000003o0?oooe80oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?oo
o`T000001P3oool2000000D0oooo0P0000000`3oool0000000000005000000030?ooo`0000000000
00<0oooo1`0000060?ooo`8000001@3oool3000000P0oooo1P0000090?ooo`<000000P3oool70000
00030?ooo`000000000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool000000000000500000?l0ooooC@3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?oo
o`8000001@3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?oo
o`8000000`3oool2000000H0oooo0P0000030?ooo`<000003@3oool3000000L0oooo0`0000040?oo
o`8000000`3oool2000000030?ooo`000000000000H0oooo0P0000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom=0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<c2`3oool9000000H0oooo2@0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000<0oooo0P0000060?ooo`8000000P3oool2000000<0oooo0P0000060?oo
o`8000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom=0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<c2`3oool9000000H0oooo0P0000050?ooo`8000000P3oool2000000030?ooo`0000000000
0080oooo0`0000030?ooo`80000000<0oooo0000000000001`3oool200000080oooo0P0000030?oo
o`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool200000080oooo0P0000000`3o
ool00000000000030?ooo`8000000P3oool200000080oooo0P0000000`3oool00000000000020?oo
o`<000000P3oool200000080oooo0P000000103oool000000000000000070?ooo`80000000<0oooo
0000000000000P3oool300000080oooo0P0000020?ooo`80000000<0oooo000000000000o`3ooom>
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`8000000`3oool3000000<0oooo10000003
0?ooo`<00000203oool2000000<0oooo1@0000080?ooo`D00000203oool5000000@0oooo0`000005
0?ooo`@00000103oool3000000<0oooo1P0000040?ooo`D00000203oool3000000<0oooo1P000004
0?ooo`<00000o`3ooom?0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<c6P3oool2000000D0oooo0P00001V0?ooo`800000o`3ooomZ
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<c6P3oool2000000D0oooo0P00001V0?ooo`800000o`3ooomW0?ooo`@0003o1`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<J0?ooo`8000001@3oool2
000001/0oooo0P0000190?ooo`800000o`3ooomZ0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3ooooa0?ooo`D0003o1`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<g/0oooo603IfMWo0?oooeh0oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<g/0oooo603IfMWo0?ooof80oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c=k0?oooaP0fMWIo`3ooomR
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<cN`3ooolH0=WIfOl0ooooHP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<g/0oooo603IfMWo0?ooof80oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;
0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000000`3oool2000000D0oooo0`000008
0?ooo`8000000`3oool5000000P0oooo1`0000050?ooo`8000000`3oool200000080oooo0P000004
0?ooo`D000000`3oool2000000H0oooo0`3IfMT3000000D0fMWI0`0000030=WIf@8000000P3IfMT2
000000040=WIf@3oool0000000000?l0ooooG`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3o
ool200000080oooo0P0000000`3oool00000000000020?ooo`800000103oool2000000030?ooo`00
0000000000L0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`<000001P3o
ool2000000<0oooo0P0000020?ooo`8000000`3oool2000000<0oooo0P0000000`3oool000000000
00070?ooo`80fMWI0P0000000`3IfMT00000000000030=WIf@80000000<0fMWI0000000000000P3I
fMT200000080fMWI0P0000000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3o
ool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3o
ool2000000<0oooo0P0000060?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000000`3o
ool2000000H0oooo0P0000030?ooo`8000000P3oool2000000<0oooo0P0000030?ooo`80000000<0
oooo0000000000001`3oool00`3IfMT00000000000030=WIf@80000000<0fMWI0000000000000`3I
fMT2000000030=WIf@00000000000080fMWI0P0000000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000060?ooo`8000000`3o
ool2000000/0oooo0P0000070?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3o
ool200000080oooo0P0000080?ooo`80000000<0oooo0000000000001`3oool00`3IfMT000000000
00060=WIf@8000001P3IfMT200000080fMWI0P0000000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool0000000000005000000030?ooo`00
0000000000<0oooo1`0000060?ooo`8000001@3oool3000000P0oooo1P0000060?ooo`8000000`3o
ool200000080oooo0P0000060?ooo`<000000P3oool2000000L0oooo00<0fMWI0000000000001P3I
fMT7000000030=WIf@00000000000080fMWI0P0000000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0
oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`8000000`3oool3000000d0oooo0`00
00060?ooo`8000000`3oool200000080oooo0P0000040?ooo`<00000103oool2000000L0oooo00<0
fMWI0000000000001P3IfMT2000000<0fMWI0P0000000`3IfMT00000000000020=WIf@80000000<0
fMWI0?ooo`3oool0o`3ooomP0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo2@0000000`3oool000000000
00030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`8000000P3o
ool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`8000000P3o
ool2000000<0oooo0P0000030?ooo`80000000<0oooo0000000000001`3oool00`3IfMT000000000
00030=WIf@80000000<0fMWI0000000000000`3IfMT2000000030=WIf@00000000000080fMWI0P00
00000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P00
00020?ooo`80000000<0oooo0000000000000P3oool3000000<0oooo0P0000000`3oool000000000
00070?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0oooo0P00
00030?ooo`8000000P3oool300000080oooo0P0000030?ooo`80000000<0oooo0000000000001`3o
ool20=WIf@8000000P3IfMT200000080fMWI0P0000000`3IfMT00000000000020=WIf@8000000P3I
fMT2000000030=WIf@3oool0oooo0?l0ooooH03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3o
ool2000000<0oooo0`0000030?ooo`@000000`3oool3000000P0oooo0P0000030?ooo`D00000203o
ool5000000H0oooo100000020?ooo`8000000P3oool400000080oooo1@0000000`3oool000000000
0002000000H0oooo0`3IfMT4000000@0fMWI0`0000030=WIf@8000000P3IfMT2000000030=WIf@3o
ool0oooo0?l0ooooH03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`800000>@3oool2000001@0oooo0P00
00070?oooa40fMWI0P0000020=WIf@80000000<0fMWI0?ooo`3oool0o`3ooomP0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c6P3o
ool2000000D0oooo0P00000i0?ooo`800000503oool2000000L0oooo4@3IfMT200000080fMWI0P00
00000`3IfMT0oooo0?ooo`3o0?oooed0oooo10000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`8000006`3oool2000001d0oooo0P00
00020?ooo`800000603ooolA0=WIf@8000000P3IfMT2000000030=WIf@3oool0oooo0?l0ooooH03o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2I
VIT203<c<g/0oooo603IfMWo0?oooeh0oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3o
ool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3o
ool309VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooool0VIVIo`2I
VIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<10?ooo`000P3ooooo09VI
VOl0VIVI1`2IVIT203<c<`40oooo00020?ooool0VIVIo`2IVIT709VIV@40iNGU0@0c<c<10?ooo`00
0P3ooooo0>GUiOl0iNGU2@3UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 106},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"],

Cell["$Failed", "Output",
  CellLabel->"Out[12]=",
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CellContents", "MR"],
              " "
            }]], Cell["contents of each cell "]},
          {Cell[TextData[{
              StyleBox["CellStyle", "MR"],
              " "
            }]], Cell["the name of the style for each cell "]},
          {Cell[TextData[{
              StyleBox["CellLabel", "MR"],
              " "
            }]], Cell["the label for each cell "]},
          {Cell[TextData[{
              StyleBox["CellTags", "MR"],
              " "
            }]], Cell["tags associated with each cell "]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["elem",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["elem",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["several kinds of elements "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.3"],

Cell[TextData[{
  "Possible elements of cells to be searched by ",
  StyleBox["NotebookFind", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.11.3"],

Cell[TextData[{
  "In setting up large notebooks, it is often convenient to insert tags which \
are not usually displayed, but which mark particular cells in such a way that \
they can be found using ",
  StyleBox["NotebookFind", "MR"],
  ". You can set up tags for cells either interactively in the front end, or \
by explicitly setting the ",
  StyleBox["CellTags", "MR"],
  " option for a cell. "
}], "Text",
  CellTags->{"S2.11.3", "3.22"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NotebookLocate[\"", "MR"],
              StyleBox["tag", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
locate and select cells with the specified tag in the \
current notebook \
\>"]},
          {Cell[TextData[{
              StyleBox["NotebookLocate[{\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["tag", "TI"],
              StyleBox["\"}]", "MR"],
              " "
            }]], Cell["open another notebook if necessary "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.3"],

Cell["Globally locating cells in notebooks. ", "Caption",
  CellTags->"S2.11.3"],

Cell[TextData[{
  StyleBox["NotebookLocate", "MR"],
  " is the underlying function that ",
  StyleBox["Mathematica", "TI"],
  " calls when you follow a hyperlink in a notebook. The menu item ",
  StyleBox["Create Hyperlink", "SR"],
  " sets up the appropriate ",
  StyleBox["NotebookLocate", "MR"],
  " as part of the script for a particular hyperlink button.  "
}], "Text",
  CellTags->{"S2.11.3", "3.23"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NotebookWrite[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["data", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "write ",
              StyleBox["data", "TI"],
              " into a notebook at the current selection "
            }]]},
          {Cell[TextData[{
              StyleBox["NotebookApply[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["data", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "write ",
              StyleBox["data", "TI"],
              
              " into a notebook, inserting the current selection in place of \
the first ",
              Cell[BoxData[
                  \(TraditionalForm\`\[SelectionPlaceholder]\)], 
                "InlineFormula"],
              " that appears in ",
              StyleBox["data", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NotebookDelete[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "delete whatever is currently selected in a notebook "]},
          {Cell[TextData[{
              StyleBox["NotebookRead[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
get the expression that corresponds to the current \
selection in a notebook \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.3"],

Cell["Writing and reading in notebooks. ", "Caption",
  CellTags->"S2.11.3"],

Cell[TextData[{
  StyleBox["NotebookWrite[", "MR"],
  StyleBox["obj", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["data", "TI"],
  StyleBox["]", "MR"],
  " is similar to a ",
  StyleBox["Paste", "SR"],
  " operation in the front end: it replaces the current selection in your \
notebook by ",
  StyleBox["data", "TI"],
  ". If the current selection is a cell ",
  StyleBox["NotebookWrite[", "MR"],
  StyleBox["obj", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["data", "TI"],
  StyleBox["]", "MR"],
  "]  will replace the cell with ",
  StyleBox["data", "TI"],
  ". If the current selection lies between two cells, however, then ",
  StyleBox["NotebookWrite[", "MR"],
  StyleBox["obj", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["data", "TI"],
  StyleBox["]", "MR"],
  " will create an appropriate new cell or cells. "
}], "Text",
  CellTags->{"S2.11.3", "3.24"}],

Cell["Here is a notebook with a word of text selected. ", "MathCaption",
  CellTags->{"S2.11.3", "3.25"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000JR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool000030>GUi@3oool0<c<c0?l0<c<co`0c<c<803<c<`40
iNGU00020?ooo`030>GUi@0c<c<0<c<c0?l0<c<co`0c<c<603<c<`40oooo00020?ooool0VIVIo`2I
VIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<10?ooo`000P3ooooo09VI
VOl0VIVI1`2IVIT203<c<`40oooo00020?ooo`<0VIVIo`3UiNGo0>GUi@40iNGU0`2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
0P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo
0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c?o0?oooo80oooo1@000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooomP3oool00`000?l0oooo
0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooo
mP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo
0`2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool00080oooo0`2IVIT203<c<``0oooo2@0000060?ooo`8000001@3oool2000000<0oooo
0`0000030?ooo`8000001@3oool3000000P0oooo0P0000030?ooo`D00000203oool7000000H0oooo
1@0000040?ooo`<000001@3oool3000000D0oooo0`0000030?ooo`8000000`3oool2000000<0oooo
1@0000080?ooo`<000000`3oool2000000<0oooo0P0000030?ooo`<000000`3oool200000?l0oooo
BP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo
0`2IVIT203<c<``0oooo2@0000060?ooo`8000001@3oool200000080oooo0P0000000`3oool00000
000000020?ooo`800000103oool2000000030?ooo`000000000000L0oooo0P0000020?ooo`800000
0`3oool2000000H0oooo0P0000020?ooo`<000001P3oool2000000<0oooo0P0000020?ooo`800000
00<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000
000000020?ooo`8000000`3oool200000080oooo0P000000103oool000000000000000070?ooo`80
000000<0oooo0000000000000P3oool2000000<0oooo0P0000020?ooo`80000000<0oooo00000000
0000o`3ooom>0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<c303oool9000000H0oooo0P0000050?ooo`80000000<0oooo00000000
00000`3oool2000000030?ooo`000000000000<0oooo0P0000030?ooo`8000001P3oool200000080
oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool200000003
0?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80
00001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool200000?l0ooooC@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<``0oooo2@0000060?ooo`8000001@3oool200000003
0?ooo`000000000000H0oooo0P0000030?ooo`8000002`3oool2000000L0oooo0P0000060?ooo`80
00000`3oool2000000/0oooo0P0000000`3oool00000000000060?ooo`8000001P3oool2000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000H0
oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00000000000?l0
ooooDP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<``0oooo2@0000060?ooo`8000001@3oool2000000030?ooo`000000000000D0
000000<0oooo0000000000000`3oool7000000H0oooo0P0000050?ooo`<00000203oool6000000T0
oooo0`0000020?ooo`L0000000<0oooo0000000000001P3oool2000000<0oooo0P0000000`3oool0
0000000000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`80
000000<0oooo0000000000000`3oool2000000030?ooo`000000000000D00000o`3ooom=0?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<c303oool9000000H0oooo0P0000050?ooo`80000000<0oooo0000000000000`3oool200000003
0?ooo`000000000000<0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0`00000=0?ooo`<0
00001`3oool3000000@0oooo0P0000030?ooo`80000000<0oooo0000000000001P3oool2000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000H0
oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0
oooo0P00003o0?ooodd0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c<<0?ooo`T000001P3oool9000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`80
00000`3oool2000000H0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool0
0000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000H0
oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0
oooo0P00003o0?ooodd0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c<<0?ooo`T000001P3oool2000000D0oooo0P0000020?ooo`80
000000<0oooo0000000000000P3oool3000000<0oooo0P0000000`3oool00000000000070?ooo`80
00000P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`80
00000P3oool2000000030?ooo`000000000000<0oooo0P0000020?ooo`8000000P3oool200000003
0?ooo`00000000000080oooo0`0000020?ooo`8000000P3oool2000000040?ooo`00000000000000
00L0oooo0P0000000`3oool00000000000020?ooo`<000000P3oool200000080oooo0P0000000`3o
ool000000000003o0?ooodh0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c<<0?ooo`T000001P3oool2000000D0oooo0P0000030?oo
o`<000000`3oool4000000<0oooo0`0000080?ooo`8000000`3oool5000000P0oooo1@0000080?oo
o`D00000103oool3000000D0oooo100000040?ooo`<000000`3oool6000000@0oooo1@0000080?oo
o`<000000`3oool6000000@0oooo0`00003o0?ooodl0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<K0?ooo`8000001@3oool20000
06H0oooo0P00003o0?ooofX0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c<K0?ooo`8000001@3oool2000006H0oooo0P00003o0?oo
ofL0oooo10000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<a/0oooo0P0000050?ooo`8000006`3oool2000004T0oooo0P00003o0?ooofX0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oo
oo80oooo1@000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<cO03ooolH0=WIfOl0ooooGP3oool50000o`H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<cO03ooolH0=WIfOl0ooooHP3oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<g`0oooo603IfMWo0?ooof80oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c=l0?oooaP0fMWIo`3ooomR0?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<cO03ooolH0=WI
fOl0ooooHP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<``0oooo2@0000060?ooo`8000001@3oool2000000<0oooo0`0000030?oo
o`8000001@3oool3000000P0oooo0P0000030?ooo`D00000203oool7000000D0oooo0P0000030?oo
o`8000000P3oool2000000@0oooo1@0000030?ooo`8000001P3oool30=WIf@<000001@3IfMT30000
00<0fMWI0P0000020=WIf@80000000@0fMWI0?ooo`0000000000o`3ooomO0?ooo`030000o`3oool0
oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c303oool9
000000H0oooo0P0000050?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P000004
0?ooo`80000000<0oooo0000000000001`3oool200000080oooo0P0000030?ooo`8000001P3oool2
00000080oooo0`0000060?ooo`8000000`3oool200000080oooo0P0000030?ooo`8000000`3oool2
000000030?ooo`000000000000L0oooo0P3IfMT2000000030=WIf@000000000000<0fMWI0P000000
0`3IfMT00000000000020=WIf@8000000P3IfMT2000000030=WIf@3oool0oooo0?l0ooooH03oool0
0`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<``0oooo2@0000060?ooo`8000001@3oool2000000030?ooo`000000000000<0oooo0P000000
0`3oool00000000000030?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool2
000000H0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000020?ooo`8000000`3oool2
000000<0oooo0P0000000`3oool00000000000070?ooo`030=WIf@000000000000<0fMWI0P000000
0`3IfMT00000000000030=WIf@80000000<0fMWI0000000000000P3IfMT2000000030=WIf@3oool0
oooo0?l0ooooH03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<``0oooo2@0000060?ooo`8000001@3oool2000000030?ooo`000000
000000H0oooo0P0000030?ooo`8000002`3oool2000000L0oooo0P0000060?ooo`8000000`3oool2
000000H0oooo0P0000030?ooo`8000000P3oool2000000P0oooo0P0000000`3oool0000000000007
0?ooo`030=WIf@000000000000H0fMWI0P0000060=WIf@8000000P3IfMT2000000030=WIf@3oool0
oooo0?l0ooooH03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<``0oooo2@0000060?ooo`8000001@3oool2000000030?ooo`000000
000000D0000000<0oooo0000000000000`3oool7000000H0oooo0P0000050?ooo`<00000203oool6
000000H0oooo0P0000030?ooo`8000000P3oool2000000H0oooo0`0000020?ooo`8000001`3oool0
0`3IfMT00000000000060=WIf@L0000000<0fMWI0000000000000P3IfMT2000000030=WIf@3oool0
oooo0?l0ooooH03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<``0oooo2@0000060?ooo`8000001@3oool2000000030?ooo`000000
000000<0oooo0P0000000`3oool00000000000030?ooo`8000000`3oool2000000H0oooo0P000003
0?ooo`<000003@3oool3000000H0oooo0P0000030?ooo`8000000P3oool2000000@0oooo0`000004
0?ooo`8000001`3oool00`3IfMT00000000000060=WIf@8000000`3IfMT2000000030=WIf@000000
00000080fMWI0P0000000`3IfMT0oooo0?ooo`3o0?ooof00oooo00<0003o0?ooo`3oool0103oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<<0?ooo`T000001P3oool9
000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`8000000`3oool2
000000H0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`8000001P3oool2
000000<0oooo0P0000020?ooo`8000000`3oool2000000<0oooo0P0000000`3oool0000000000007
0?ooo`030=WIf@000000000000<0fMWI0P0000000`3IfMT00000000000030=WIf@80000000<0fMWI
0000000000000P3IfMT2000000030=WIf@3oool0oooo0?l0ooooH03oool00`000?l0oooo0?ooo`04
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<``0oooo2@000006
0?ooo`8000001@3oool200000080oooo0P0000000`3oool00000000000020?ooo`<000000`3oool2
000000030?ooo`000000000000L0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P000003
0?ooo`8000001P3oool2000000<0oooo0P0000020?ooo`<000000P3oool2000000<0oooo0P000000
0`3oool00000000000070?ooo`80fMWI0P0000020=WIf@8000000P3IfMT2000000030=WIf@000000
00000080fMWI0P0000020=WIf@80000000<0fMWI0?ooo`3oool0o`3ooomP0?ooo`030000o`3oool0
oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c303oool9
000000H0oooo0P0000050?ooo`8000000`3oool3000000<0oooo100000030?ooo`<00000203oool2
000000<0oooo1@0000080?ooo`D000001P3oool400000080oooo0P0000020?ooo`@000000P3oool5
000000030?ooo`0000000000008000001P3oool30=WIf@@00000103IfMT3000000<0fMWI0P000002
0=WIf@80000000<0fMWI0?ooo`3oool0o`3ooomP0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c6`3oool2000000D0oooo0P00000i
0?ooo`800000503oool2000000L0oooo4@3IfMT200000080fMWI0P0000000`3IfMT0oooo0?ooo`3o
0?ooof00oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c<K0?ooo`8000001@3oool2000003T0oooo0P00000D0?ooo`8000001`3ooolA
0=WIf@8000000P3IfMT2000000030=WIf@3oool0oooo0?l0ooooG@3oool40000o`H0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c6`3oool2000000D0oooo0P00000K
0?ooo`8000007@3oool200000080oooo0P00000H0?oooa40fMWI0P0000020=WIf@80000000<0fMWI
0?ooo`3oool0o`3ooomP0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<cO03ooolH0=WIfOl0ooooGP3oool50000o`H0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVIo`0c<c?o03<c<`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo00020?ooool0VIVIo`2IVIT709VI
V@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<10?ooo`000P3ooooo09VIVOl0VIVI
1`2IVIT10>GUi@40<c<c0@3oool00080ooooo`3UiNGo0>GUi@T0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 106},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"],

Cell["This replaces the selected word by new text. ", "MathCaption",
  CellTags->{"S2.11.3", "3.26"}],

Cell[CellGroupData[{

Cell["NotebookWrite[nb, \"<<inserted text>>\"]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000JR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool000030>GUi@3oool0<c<c0?l0<c<co`0c<c<803<c<`40
iNGU00020?ooo`030>GUi@0c<c<0<c<c0?l0<c<co`0c<c<603<c<`40oooo00020?ooool0VIVIo`2I
VIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<10?ooo`000P3ooooo09VI
VOl0VIVI1`2IVIT203<c<`40oooo00020?ooo`<0VIVIo`3UiNGo0>GUi@40iNGU0`2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
0P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo
0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooool@3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3ooooe0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c
o`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
0P3oool309VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`800000
0`3oool3000000<0oooo0P0000050?ooo`<00000203oool2000000<0oooo1@0000080?ooo`L00000
1P3oool5000000@0oooo0`0000050?ooo`<000001@3oool3000000<0oooo0P0000030?ooo`800000
0`3oool5000000P0oooo0`0000030?ooo`8000000`3oool2000000<0oooo0`0000030?ooo`800000
o`3ooom:0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
0P3oool309VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`8000000P3oool2000000030?oo
o`00000000000080oooo0P0000040?ooo`80000000<0oooo0000000000001`3oool200000080oooo
0P0000030?ooo`8000001P3oool200000080oooo0`0000060?ooo`8000000`3oool200000080oooo
0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`00000000000080oooo0P0000030?ooo`8000000P3oool2000000040?ooo`0000000000000000L0
oooo0P0000000`3oool00000000000020?ooo`8000000`3oool200000080oooo0P0000000`3oool0
00000000003o0?ooodh0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool0
0000000000030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`80
00000P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`80
000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0
0000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0
oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0
0000000000030?ooo`800000o`3ooom=0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`80
000000<0oooo0000000000001P3oool2000000<0oooo0P00000;0?ooo`8000001`3oool2000000H0
oooo0P0000030?ooo`8000002`3oool2000000030?ooo`000000000000H0oooo0P0000060?ooo`80
00000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80
00001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
0000o`3ooomB0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`80000000<0oooo00000000
00001@0000000`3oool00000000000030?ooo`L000001P3oool2000000D0oooo0`0000080?ooo`H0
00002@3oool300000080oooo1`0000000`3oool00000000000060?ooo`8000000`3oool200000003
0?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000001@00003o0?ooodd0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`80
000000<0oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`8000000`3oool3000000d0
oooo0`0000070?ooo`<00000103oool2000000<0oooo0P0000000`3oool00000000000060?ooo`80
00000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80
00001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool200000?l0ooooC@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`T0000000<0oooo00000000
00000`3oool2000000030?ooo`000000000000<0oooo0P0000030?ooo`8000001P3oool200000080
oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool200000003
0?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80
00001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool200000?l0ooooC@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool200000080
oooo0P0000000`3oool00000000000020?ooo`<000000`3oool2000000030?ooo`000000000000L0
oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`8000001P3oool2000000<0
oooo0P0000020?ooo`80000000<0oooo0000000000000`3oool200000080oooo0P0000020?ooo`80
000000<0oooo0000000000000P3oool300000080oooo0P0000020?ooo`80000000@0oooo00000000
000000001`3oool2000000030?ooo`00000000000080oooo0`0000020?ooo`8000000P3oool20000
00030?ooo`00000000000?l0ooooCP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool20000
00<0oooo0`0000030?ooo`@000000`3oool3000000P0oooo0P0000030?ooo`D00000203oool50000
00P0oooo1@0000040?ooo`<000001@3oool4000000@0oooo0`0000030?ooo`H00000103oool50000
00P0oooo0`0000030?ooo`H00000103oool300000?l0ooooC`3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?oo
o`800000IP3oool200000?l0ooooJP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`800000IP3oool20000
0?l0ooooI`3oool40000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<c6P3oool2000000D0oooo0P00000K0?ooo`800000B@3oool200000?l0ooooJP3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<ol0ooool@3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c=k0?ooogT0fMWIo03oool50000o`L0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<cN`3ooomi0=WIfOl0oooo0@3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<g/0ooooN@3IfMWo0?ooo`40oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c=k0?ooogT0fMWIo`3oool10?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<cN`3ooomi0=WI
fOl0oooo0@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool2000000<0oooo0`0000030?oo
o`8000001@3oool3000000P0oooo0P0000030?ooo`D00000203oool7000000D0oooo0P0000030?oo
o`8000000P3oool2000000@0oooo1@0000030?ooo`8000001P3oool60=WIf@8000001`3IfMT20000
0080fMWI0P0000020=WIf@8000000`3IfMT200000080fMWI1@0000040=WIf@<000000`3IfMT20000
00@0fMWI0P0000040=WIf@<000001@3IfMT5000000L0fMWI0P0000040=WIf@<000000`3IfMT20000
00<0fMWI0P0000020=WIf@80000000<0fMWI0000000000001`3IfMT2000000L0fMWI00<0oooo0000
00000000o@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool200000080oooo0P0000000`3o
ool00000000000020?ooo`800000103oool2000000030?ooo`000000000000L0oooo0P0000020?oo
o`8000000`3oool2000000H0oooo0P0000020?ooo`<000001P3oool2000000<0oooo0P0000020?oo
o`8000000`3oool2000000<0oooo0P0000000`3oool00000000000070?ooo`D0fMWI0P0000070=WI
f@8000000`3IfMT200000080fMWI0P0000030=WIf@80000000<0fMWI0000000000000`3IfMT20000
0080fMWI0P0000000`3IfMT00000000000020=WIf@8000000`3IfMT2000000@0fMWI0P0000000`3I
fMT00000000000030=WIf@80000000@0fMWI00000000000000001P3IfMT2000000@0fMWI0P000000
0`3IfMT00000000000030=WIf@80000000<0fMWI0000000000000P3IfMT2000000<0fMWI0P000007
0=WIf@8000001P3IfMWo0?ooo`40oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P000000
0`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P000006
0?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0oooo0P000003
0?ooo`8000000P3oool2000000<0oooo0P0000030?ooo`80000000<0oooo0000000000001`3oool3
0=WIf@<000001P3IfMT3000000@0fMWI0P0000020=WIf@8000000`3IfMT2000000030=WIf@000000
000000<0fMWI0P0000000`3IfMT00000000000030=WIf@80000000<0fMWI0000000000000`3IfMT2
000000<0fMWI0P0000030=WIf@80000000<0fMWI0000000000000`3IfMT2000000H0fMWI0P000003
0=WIf@8000000`3IfMT200000080fMWI0P0000000`3IfMT00000000000020=WIf@800000103IfMT3
000000H0fMWI0`0000040=WIfOl0oooo0@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool2
000000030?ooo`000000000000H0oooo0P0000030?ooo`8000002`3oool2000000L0oooo0P000006
0?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`8000000P3oool2000000P0oooo0P000000
0`3oool00000000000070?ooo`040=WIf@0000000000000000H0fMWI0`0000060=WIf@8000000P3I
fMT2000000<0fMWI0P0000060=WIf@80000000<0fMWI0000000000001P3IfMT2000000<0fMWI0P00
00030=WIf@8000001P3IfMT2000000<0fMWI0P0000060=WIf@8000000`3IfMT2000000P0fMWI0`00
00030=WIf@8000001P3IfMT3000000H0fMWI0`0000020=WIfOl0oooo0@3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@00
00060?ooo`8000001@3oool2000000030?ooo`000000000000D0000000<0oooo0000000000000`3o
ool7000000H0oooo0P0000050?ooo`<00000203oool6000000H0oooo0P0000030?ooo`8000000P3o
ool2000000H0oooo0`0000020?ooo`8000001`3oool2000000L0fMWI0P0000080=WIf@8000000P3I
fMT2000000<0fMWI0P0000040=WIf@<000000P3IfMT7000000030=WIf@000000000000<0fMWI0P00
00030=WIf@L0000000<0fMWI0000000000000`3IfMT2000000H0fMWI0P0000030=WIf@L000000`3I
fMT3000000<0fMWI0P0000080=WIf@8000001`3IfMT2000000030=WIf@3oool0oooo0?h0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0
oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`8000000`3oool3000000d0oooo0`00
00060?ooo`8000000`3oool200000080oooo0P0000040?ooo`<00000103oool2000000L0oooo00@0
fMWI00000000000000001P3IfMT3000000H0fMWI0P0000020=WIf@8000000`3IfMT200000080fMWI
0`0000040=WIf@8000000`3IfMT2000000030=WIf@000000000000<0fMWI0P0000030=WIf@800000
0`3IfMT2000000030=WIf@000000000000<0fMWI0P0000060=WIf@8000000`3IfMT2000000<0fMWI
0P0000030=WIf@<000000`3IfMT2000000H0fMWI0`0000060=WIf@<000000P3IfMWo0?ooo`40oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI
0P0c<c<;0?ooo`T000001P3oool9000000030?ooo`000000000000<0oooo0P0000000`3oool00000
000000030?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool2000000H0oooo
0P0000030?ooo`8000001P3oool2000000<0oooo0P0000020?ooo`8000000`3oool2000000<0oooo
0P0000000`3oool00000000000070?ooo`<0fMWI0`0000060=WIf@<00000103IfMT200000080fMWI
0P0000030=WIf@80000000<0fMWI0000000000000`3IfMT2000000030=WIf@000000000000<0fMWI
0P0000000`3IfMT00000000000030=WIf@8000000`3IfMT2000000<0fMWI0P0000000`3IfMT00000
000000030=WIf@8000001P3IfMT2000000<0fMWI0P0000030=WIf@8000000P3IfMT2000000030=WI
f@00000000000080fMWI0P0000040=WIf@<000001P3IfMT3000000@0fMWIo`3oool10?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c
2`3oool9000000H0oooo0P0000050?ooo`8000000P3oool2000000030?ooo`00000000000080oooo
0`0000030?ooo`80000000<0oooo0000000000001`3oool200000080oooo0P0000030?ooo`800000
1P3oool2000000<0oooo0P0000060?ooo`8000000`3oool200000080oooo0`0000020?ooo`800000
0`3oool2000000030?ooo`000000000000L0oooo1@3IfMT2000000L0fMWI0P0000030=WIf@800000
0P3IfMT300000080fMWI0P0000000`3IfMT00000000000030=WIf@8000000P3IfMT2000000030=WI
f@00000000000080fMWI0`0000020=WIf@800000103IfMT2000000030=WIf@000000000000<0fMWI
0P000000103IfMT000000000000000060=WIf@800000103IfMT2000000030=WIf@000000000000<0
fMWI0P0000000`3IfMT00000000000020=WIf@8000000`3IfMT2000000L0fMWI0P0000060=WIfOl0
oooo0@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool2000000<0oooo0`0000030?ooo`@0
00000`3oool3000000P0oooo0P0000030?ooo`D00000203oool5000000H0oooo100000020?ooo`80
00000P3oool400000080oooo1@0000000`3oool0000000000002000000H0oooo1P3IfMT2000000L0
fMWI0P0000020=WIf@8000000P3IfMT6000000<0fMWI1@0000040=WIf@<000000`3IfMT8000000@0
fMWI0`0000050=WIf@D000001@3IfMT4000000@0fMWI0`0000030=WIf@8000000`3IfMT600000003
0=WIf@000000000000L0fMWI0P0000070=WIfOl0oooo0@3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`80
0000>@3oool2000001@0oooo0P0000070?oooc@0fMWI0P00000@0=WIf@8000001P3IfMT2000001<0
fMWI0P00000D0=WIfOl0oooo0@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`800000>@3oool2000001@0
oooo0P0000070?oooc@0fMWI0P00000@0=WIf@8000001P3IfMT2000001<0fMWI0P00000D0=WIfOd0
oooo10000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0
oooo0P0000050?ooo`8000006`3oool2000001d0oooo0P0000020?ooo`800000603ooolC0=WIf@80
0000<@3IfMT200000340fMWIo`3oool10?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<cN`3ooomi0=WIfO`0oooo1@000?l70?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooool0VIVIo`2IVIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI
0P0c<c<10?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo00020?ooool0VIVIo`2IVIT7
09VIV@40iNGU0@0c<c<10?ooo`000P3ooooo0>GUiOl0iNGU2@3UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 106},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["\<\
This moves the current selection to just after the first cell in \
the notebook. \
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.27"}],

Cell[CellGroupData[{

Cell["SelectionMove[nb, After, Cell]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000JR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool000030>GUi@3oool0<c<c0?l0<c<co`0c<c<803<c<`40
iNGU00020?ooo`030>GUi@0c<c<0<c<c0?l0<c<co`0c<c<603<c<`40oooo00020?ooool0VIVIo`2I
VIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<10?ooo`000P3ooooo09VI
VOl0VIVI1`2IVIT203<c<`40oooo00020?ooo`<0VIVIo`3UiNGo0>GUi@40iNGU0`2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
0P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo
0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooool@3oool50000o`L0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3ooooe0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c
o`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
0P3oool309VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo
0P0000050?ooo`8000000`3oool3000000<0oooo0P0000050?ooo`<00000203oool2000000<0oooo
1@0000080?ooo`L000001P3oool5000000@0oooo0`0000050?ooo`<000001@3oool3000000<0oooo
0P0000030?ooo`8000000`3oool5000000P0oooo0`0000030?ooo`8000000`3oool2000000<0oooo
0`0000030?ooo`800000o`3ooom:0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`800000
0P3oool2000000030?ooo`00000000000080oooo0P0000040?ooo`80000000<0oooo000000000000
1`3oool200000080oooo0P0000030?ooo`8000001P3oool200000080oooo0`0000060?ooo`800000
0`3oool200000080oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo000000000000
0`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`8000000P3oool2000000040?oo
o`0000000000000000L0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool200000080
oooo0P0000000`3oool000000000003o0?ooodh0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000<0
oooo0P0000060?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0
oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool200000003
0?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom=0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0
oooo0P0000050?ooo`80000000<0oooo0000000000001P3oool2000000<0oooo0P00000;0?ooo`80
00001`3oool2000000H0oooo0P0000030?ooo`8000002`3oool2000000030?ooo`000000000000H0
oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0
0000000000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80
000000<0oooo000000000000o`3ooomB0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`80
000000<0oooo0000000000001@0000000`3oool00000000000030?ooo`L000001P3oool2000000D0
oooo0`0000080?ooo`H000002@3oool300000080oooo1`0000000`3oool00000000000060?ooo`80
00000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80
00001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00001@00003o0?ooodd0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool0
0000000000030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`80
00000`3oool3000000d0oooo0`0000070?ooo`<00000103oool2000000<0oooo0P0000000`3oool0
0000000000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0
0000000000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80
000000<0oooo0000000000000`3oool200000?l0ooooC@3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`T0
000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000030?ooo`80
00001P3oool200000080oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`80
00000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80
000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0
0000000000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80
000000<0oooo0000000000000`3oool200000?l0ooooC@3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`80
00001@3oool200000080oooo0P0000000`3oool00000000000020?ooo`<000000`3oool200000003
0?ooo`000000000000L0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`80
00001P3oool2000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000`3oool200000080
oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool300000080oooo0P0000020?ooo`80
000000@0oooo00000000000000001`3oool2000000030?ooo`00000000000080oooo0`0000020?oo
o`8000000P3oool2000000030?ooo`00000000000?l0ooooCP3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?oo
o`8000001@3oool2000000<0oooo0`0000030?ooo`@000000`3oool3000000P0oooo0P0000030?oo
o`D00000203oool5000000P0oooo1@0000040?ooo`<000001@3oool4000000@0oooo0`0000030?oo
o`H00000103oool5000000P0oooo0`0000030?ooo`H00000103oool300000?l0ooooC`3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<aX0oooo0P0000050?ooo`800000IP3oool200000?l0ooooJP3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?oo
o`800000IP3oool200000?l0ooooI`3oool40000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<c6P3oool2000000D0oooo0P00000K0?ooo`800000B@3oool20000
0?l0ooooJP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<ol0ooool@3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c0`3ooooo03<c<oT0<c<c0P3UiND309VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?oooo40oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooom@3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool2000000<0oooo0`0000030?ooo`80
00001@3oool3000000P0oooo0P0000030?ooo`D00000203oool7000000D0oooo0P0000030?ooo`80
00000P3oool2000000@0oooo1@0000030?ooo`800000303oool2000000L0oooo0P0000020?ooo`80
00000P3oool2000000<0oooo0P0000020?ooo`D00000103oool3000000<0oooo0P0000040?ooo`80
0000103oool3000000D0oooo1@0000070?ooo`800000103oool3000000<0oooo0P0000030?ooo`80
00000P3oool2000000030?ooo`000000000000L0oooo0P0000080?ooo`800000o@3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0
oooo2@0000060?ooo`8000001@3oool200000080oooo0P0000000`3oool00000000000020?ooo`80
0000103oool2000000030?ooo`000000000000L0oooo0P0000020?ooo`8000000`3oool2000000H0
oooo0P0000020?ooo`<000001P3oool2000000<0oooo0P0000020?ooo`8000000`3oool2000000<0
oooo0P0000000`3oool000000000000<0?ooo`8000001`3oool2000000<0oooo0P0000020?ooo`80
00000`3oool2000000030?ooo`000000000000<0oooo0P0000020?ooo`80000000<0oooo00000000
00000P3oool2000000<0oooo0P0000040?ooo`80000000<0oooo0000000000000`3oool200000004
0?ooo`0000000000000000H0oooo0P0000040?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`00000000000080oooo0P0000030?ooo`8000001`3oool200000?l0oooo1`3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<`/0oooo2@0000060?ooo`8000001@3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool20000
00H0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000020?ooo`8000000`3oool20000
00<0oooo0P0000000`3oool000000000000:0?ooo`<000001P3oool3000000@0oooo0P0000020?oo
o`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000030?ooo`80000000<0oooo0000
000000000`3oool2000000H0oooo0P0000030?ooo`8000000`3oool200000080oooo0P0000000`3o
ool00000000000020?ooo`800000103oool3000000H0oooo0`00003o0?ooo`D0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?oo
o`T000001P3oool2000000D0oooo0P0000000`3oool00000000000060?ooo`8000000`3oool20000
00/0oooo0P0000070?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool20000
0080oooo0P0000080?ooo`80000000<0oooo000000000000203oool3000000H0oooo0`0000060?oo
o`8000000P3oool2000000<0oooo0P0000060?ooo`80000000<0oooo0000000000001P3oool20000
00<0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool20000
00P0oooo0`0000030?ooo`8000001P3oool3000000H0oooo0`00003o0?ooo`<0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?oo
o`T000001P3oool2000000D0oooo0P0000000`3oool0000000000005000000030?ooo`0000000000
00<0oooo1`0000060?ooo`8000001@3oool3000000P0oooo1P0000060?ooo`8000000`3oool20000
0080oooo0P0000060?ooo`<000000P3oool2000000L0oooo0P0000070?ooo`800000203oool20000
0080oooo0P0000030?ooo`800000103oool300000080oooo1`0000000`3oool00000000000030?oo
o`8000000`3oool7000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool70000
00<0oooo0`0000030?ooo`800000203oool2000000L0oooo0P00003o0?ooo`80oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?oo
o`T000001P3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000<0oooo0P0000060?ooo`8000000`3oool3000000d0oooo0`0000060?oo
o`8000000`3oool200000080oooo0P0000040?ooo`<00000103oool2000000P0oooo0`0000060?oo
o`<000001P3oool200000080oooo0P0000030?ooo`8000000P3oool3000000@0oooo0P0000030?oo
o`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000030?ooo`80000000<0oooo0000
000000000`3oool2000000H0oooo0P0000030?ooo`8000000`3oool2000000<0oooo0`0000030?oo
o`8000001P3oool3000000H0oooo0`00003o0?ooo`<0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool90000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`8000000`3oool20000
00H0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`8000001P3oool20000
00<0oooo0P0000020?ooo`8000000`3oool2000000<0oooo0P0000000`3oool000000000000:0?oo
o`<000001P3oool3000000@0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool20000
00<0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?oo
o`8000000`3oool200000080oooo0P0000000`3oool00000000000020?ooo`800000103oool30000
00H0oooo0`00003o0?ooo`D0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000020?oo
o`80000000<0oooo0000000000000P3oool3000000<0oooo0P0000000`3oool00000000000070?oo
o`8000000P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0oooo0P0000030?oo
o`8000000P3oool300000080oooo0P0000030?ooo`80000000<0oooo000000000000303oool20000
00L0oooo0P0000030?ooo`8000000P3oool300000080oooo0P0000000`3oool00000000000030?oo
o`8000000P3oool2000000030?ooo`00000000000080oooo0`0000020?ooo`800000103oool20000
00030?ooo`000000000000<0oooo0P000000103oool000000000000000060?ooo`800000103oool2
000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2
000000L0oooo0P00003o0?ooo`L0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P000003
0?ooo`<000000`3oool4000000<0oooo0`0000080?ooo`8000000`3oool5000000P0oooo1@000006
0?ooo`@000000P3oool200000080oooo100000020?ooo`D0000000<0oooo0000000000000P00000<
0?ooo`8000001`3oool200000080oooo0P0000020?ooo`H000000`3oool5000000@0oooo0`000003
0?ooo`P00000103oool3000000D0oooo1@0000050?ooo`@00000103oool3000000<0oooo0P000003
0?ooo`H0000000<0oooo0000000000001`3oool200000?l0oooo203oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo0P000005
0?ooo`800000>@3oool2000001@0oooo0P00000k0?ooo`800000403oool2000000H0oooo0P00000C
0?ooo`800000o`3ooolE0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<c6P3oool2000000D0oooo0P00000i0?ooo`800000503oool2
000003/0oooo0P00000@0?ooo`8000001P3oool2000001<0oooo0P00003o0?oooa80oooo10000?l7
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo0P000005
0?ooo`8000006`3oool2000001d0oooo0P0000020?ooo`800000:`3oool200000340oooo0P00003o
0?oooc80oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?oooo40oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooool0VIVIo`2IVIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<10?oo
o`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo00020?ooool0VIVIo`2IVIT709VIV@40iNGU
0@0c<c<10?ooo`000P3ooooo0>GUiOl0iNGU2@3UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 106},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["\<\
This now inserts a text cell after the first cell in the notebook. \
\
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.28"}],

Cell[CellGroupData[{

Cell["NotebookWrite[nb, Cell[\"This cell contains text.\", \"Text\"]]", \
"Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000P2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool000030>GUi@3oool0<c<c0?l0<c<co`0c<c<803<c<`40
iNGU00020?ooo`030>GUi@0c<c<0<c<c0?l0<c<co`0c<c<603<c<`40oooo00020?ooool0VIVIo`2I
VIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<10?ooo`000P3ooooo09VI
VOl0VIVI1`2IVIT203<c<`40oooo00020?ooo`<0VIVIo`3UiNGo0>GUi@40iNGU0`2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
0P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo
0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3ooooa0?ooo`D0003o
1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI
0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T00000
1P3oool2000000D0oooo0P0000030?ooo`<000000`3oool2000000D0oooo0`0000080?ooo`800000
0`3oool5000000P0oooo1`0000060?ooo`D00000103oool3000000D0oooo0`0000050?ooo`<00000
0`3oool2000000<0oooo0P0000030?ooo`D00000203oool3000000<0oooo0P0000030?ooo`800000
0`3oool3000000<0oooo0P00003o0?ooodX0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo
0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000@0oooo0P0000000`3oool00000
000000070?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000000P3oool3000000H0oooo
0P0000030?ooo`8000000P3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000020?ooo`800000
00@0oooo00000000000000001`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`80
00000P3oool2000000030?ooo`00000000000?l0ooooCP3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`80
00001@3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80
00000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`80
00001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80
000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo00000000
00000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?ooodd0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T0
00001P3oool2000000D0oooo0P0000000`3oool00000000000060?ooo`8000000`3oool2000000/0
oooo0P0000070?ooo`8000001P3oool2000000<0oooo0P00000;0?ooo`80000000<0oooo00000000
00001P3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool200000003
0?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool000000000003o0?oooe80oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0
oooo0P0000000`3oool0000000000005000000030?ooo`000000000000<0oooo1`0000060?ooo`80
00001@3oool3000000P0oooo1P0000090?ooo`<000000P3oool7000000030?ooo`000000000000H0
oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0
oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0
00000000000500000?l0ooooC@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool200000003
0?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`8000000`3oool2000000H0
oooo0P0000030?ooo`<000003@3oool3000000L0oooo0`0000040?ooo`8000000`3oool200000003
0?ooo`000000000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool200000003
0?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom=0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0
oooo2@0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000<0
oooo0P0000060?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0
oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool200000003
0?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom=0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0
oooo0P0000050?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0`0000030?ooo`80
000000<0oooo0000000000001`3oool200000080oooo0P0000030?ooo`8000001P3oool2000000<0
oooo0P0000060?ooo`8000000`3oool200000080oooo0P0000000`3oool00000000000030?ooo`80
00000P3oool200000080oooo0P0000000`3oool00000000000020?ooo`<000000P3oool200000080
oooo0P000000103oool000000000000000070?ooo`80000000<0oooo0000000000000P3oool30000
0080oooo0P0000020?ooo`80000000<0oooo000000000000o`3ooom>0?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool90000
00H0oooo0P0000050?ooo`8000000`3oool3000000<0oooo100000030?ooo`<00000203oool20000
00<0oooo1@0000080?ooo`D00000203oool5000000@0oooo0`0000050?ooo`@00000103oool30000
00<0oooo1P0000040?ooo`D00000203oool3000000<0oooo1P0000040?ooo`<00000o`3ooom?0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<c6P3oool2000000D0oooo0P00001V0?ooo`800000o`3ooomZ0?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c6P3oool20000
00D0oooo0P00001V0?ooo`800000o`3ooomW0?ooo`@0003o1`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c<J0?ooo`8000001@3oool2000001/0oooo0P0000190?oo
o`800000o`3ooomZ0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<co`3ooooa0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3ooooZ0?oo
o`D0003o0P3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<co`3oooo^0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooonh0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
0080oooo0`2IVIT203<c<ol0ooookP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooo^0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c<>0?ooo`<000000P3oool3000000030?ooo`0000000000
00H000001P3oool2000000<0oooo0P0000020?ooo`H00000103oool2000000<0oooo0`0000020?oo
o`<0000000D0oooo000000000000oooo000000020?ooo`80000000<0oooo0000000000001@000000
0`3oool0000000000003000000H0oooo00<000000?ooo`3oool00P0000020?ooo`80000000<0oooo
0000000000000P3oool010000000oooo0?ooo`00003o0?ooogX0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2I
VIT203<c<`l0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`030000
003oool000000080oooo00<000000?ooo`3oool00P3oool01P000000oooo0?ooo`000000oooo0000
0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`060000003oool0
oooo0000003oool000000`3oool010000000oooo0?ooo`0000020?ooo`030000003oool000000080
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
00000080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`060000003o
ool0oooo0000003oool000000P3oool00`000000oooo0?ooo`3o0?ooog`0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<`l0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00<0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0?ooo`800000
103oool010000000oooo0?ooo`0000060?ooo`050000003oool0oooo0?ooo`000000o`3ooomn0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c<?0?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0000000000060?ooo`030000003oool0oooo0080oooo1000
00020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo
0?ooo`3oool000000080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`<000000P3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool00000000000H0oooo00<000000?ooo`3oool0
100000030?ooo`050000003oool0oooo0?ooo`000000o`3ooomn0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c<?0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo000000020?ooo`030000003oool0oooo0080oooo00H000000?ooo`3oool000000?ooo`00
00020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool01P000000oooo
0?ooo`000000oooo000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo00000002
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo
000000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool01P000000
oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3oool0o`3oooml0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c<?0?ooo`030000003oool0oooo0080oooo0`0000020?ooo`8000000P3oool3
000000D0oooo0P0000030?ooo`8000000`3oool010000000oooo0?ooo`0000050?ooo`8000000`3o
ool300000080oooo00D000000?ooo`00000000000?ooo`0300000080oooo0P0000020?ooo`800000
00<0oooo0000003oool00P0000030?ooo`<000000`3oool300000080oooo0P0000020?ooo`800000
00<0oooo0000000000000`00003o0?ooogd0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`l0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000001D0
oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0?l0
ooooO03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c303oool010000000oooo0?ooo`0000020?oo
o`030000003oool0000001X0oooo00@000000?ooo`3oool00000o`3ooonk0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c<<0?ooo`T000001@3oool00`000000oooo0?ooo`0A0?ooo`80000000<0oooo
0000000000007P3oool00`000000oooo0?ooo`3o0?oooiX0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooj`3oool40000o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooonh0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0oooojP3oool50000o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooonX0oooo1@000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooo^0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooonh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooookP3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooo^0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;
0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000000`3oool2000000D0oooo0`000008
0?ooo`8000000`3oool5000000P0oooo1`0000050?ooo`8000000`3oool200000080oooo0P000004
0?ooo`D000000`3oool2000000`0oooo0P0000070?ooo`8000000P3oool200000080oooo0P000003
0?ooo`8000000P3oool5000000@0oooo0`0000030?ooo`800000103oool2000000@0oooo0`000005
0?ooo`D000001`3oool2000000@0oooo0`0000030?ooo`8000000`3oool200000080oooo0P000000
0`3oool00000000000070?ooo`800000203oool200000?H0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<`/0oooo2@0000060?ooo`8000001@3oool200000080oooo0P0000000`3oool0000000000002
0?ooo`800000103oool2000000030?ooo`000000000000L0oooo0P0000020?ooo`8000000`3oool2
000000H0oooo0P0000020?ooo`<000001P3oool2000000<0oooo0P0000020?ooo`8000000`3oool2
000000<0oooo0P0000000`3oool000000000000<0?ooo`8000001`3oool2000000<0oooo0P000002
0?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000020?ooo`80000000<0oooo
0000000000000P3oool2000000<0oooo0P0000040?ooo`80000000<0oooo0000000000000`3oool2
000000040?ooo`0000000000000000H0oooo0P0000040?ooo`80000000<0oooo0000000000000`3o
ool2000000030?ooo`00000000000080oooo0P0000030?ooo`8000001`3oool200000?l0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool2000000030?ooo`00
0000000000<0oooo0P0000000`3oool00000000000030?ooo`8000000`3oool2000000H0oooo0P00
00020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P00
00020?ooo`8000000`3oool2000000<0oooo0P0000000`3oool000000000000:0?ooo`<000001P3o
ool3000000@0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
00000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P00
00030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`8000000`3o
ool200000080oooo0P0000000`3oool00000000000020?ooo`800000103oool3000000H0oooo0`00
003m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P00
00000`3oool00000000000060?ooo`8000000`3oool2000000/0oooo0P0000070?ooo`8000001P3o
ool2000000<0oooo0P0000060?ooo`8000000`3oool200000080oooo0P0000080?ooo`80000000<0
oooo000000000000203oool3000000H0oooo0`0000060?ooo`8000000P3oool2000000<0oooo0P00
00060?ooo`80000000<0oooo0000000000001P3oool2000000<0oooo0P0000030?ooo`8000001P3o
ool2000000<0oooo0P0000060?ooo`8000000`3oool2000000P0oooo0`0000030?ooo`8000001P3o
ool3000000H0oooo0`00003k0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3o
ool2000000D0oooo0P0000000`3oool0000000000005000000030?ooo`000000000000<0oooo1`00
00060?ooo`8000001@3oool3000000P0oooo1P0000060?ooo`8000000`3oool200000080oooo0P00
00060?ooo`<000000P3oool2000000L0oooo0P0000070?ooo`800000203oool200000080oooo0P00
00030?ooo`800000103oool300000080oooo1`0000000`3oool00000000000030?ooo`8000000`3o
ool7000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool7000000<0oooo0`00
00030?ooo`800000203oool2000000L0oooo0P00003j0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0
oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`8000000`3oool3000000d0oooo0`00
00060?ooo`8000000`3oool200000080oooo0P0000040?ooo`<00000103oool2000000P0oooo0`00
00060?ooo`<000001P3oool200000080oooo0P0000030?ooo`8000000P3oool3000000@0oooo0P00
00030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000030?ooo`80000000<0
oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`8000000`3oool2000000<0oooo0`00
00030?ooo`8000001P3oool3000000H0oooo0`00003k0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c<;0?ooo`T000001P3oool9000000030?ooo`000000000000<0oooo0P0000000`3oool000000000
00030?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P00
00030?ooo`8000001P3oool2000000<0oooo0P0000020?ooo`8000000`3oool2000000<0oooo0P00
00000`3oool000000000000:0?ooo`<000001P3oool3000000@0oooo0P0000020?ooo`8000000`3o
ool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0
oooo0000000000000`3oool2000000<0oooo0P0000030?ooo`80000000<0oooo0000000000000`3o
ool2000000H0oooo0P0000030?ooo`8000000`3oool200000080oooo0P0000000`3oool000000000
00020?ooo`800000103oool3000000H0oooo0`00003m0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c<;0?ooo`T000001P3oool2000000D0oooo0P0000020?ooo`80000000<0oooo0000000000000P3o
ool3000000<0oooo0P0000000`3oool00000000000070?ooo`8000000P3oool2000000<0oooo0P00
00060?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`8000000P3oool300000080oooo0P00
00030?ooo`80000000<0oooo000000000000303oool2000000L0oooo0P0000030?ooo`8000000P3o
ool300000080oooo0P0000000`3oool00000000000030?ooo`8000000P3oool2000000030?ooo`00
000000000080oooo0`0000020?ooo`800000103oool2000000030?ooo`000000000000<0oooo0P00
0000103oool000000000000000060?ooo`800000103oool2000000030?ooo`000000000000<0oooo
0P0000000`3oool00000000000020?ooo`8000000`3oool2000000L0oooo0P00003o0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<00000
0`3oool4000000<0oooo0`0000080?ooo`8000000`3oool5000000P0oooo1@0000060?ooo`@00000
0P3oool200000080oooo100000020?ooo`D0000000<0oooo0000000000000P00000<0?ooo`800000
1`3oool200000080oooo0P0000020?ooo`H000000`3oool5000000@0oooo0`0000030?ooo`P00000
103oool3000000D0oooo1@0000050?ooo`@00000103oool3000000<0oooo0P0000030?ooo`H00000
00<0oooo0000000000001`3oool200000?l0oooo0@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c
6P3oool2000000D0oooo0P00000i0?ooo`800000503oool2000003/0oooo0P00000@0?ooo`800000
1P3oool2000001<0oooo0P00003o0?ooo`h0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo
0P0000050?ooo`800000>@3oool2000001@0oooo0P00000k0?ooo`800000403oool2000000H0oooo
0P00000C0?ooo`800000o`3oool;0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`800000
6`3oool2000001d0oooo0P0000020?ooo`800000:`3oool200000340oooo0P00003o0?ooob/0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooojP3oool50000o`80oooo1@000?l70?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
0P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo
0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI
o`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIWo03<c<ol0<c<c
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo
00020?ooool0VIVIo`2IVIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<1
0?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT10>GUi@40<c<c0@3oool00080ooooo`3UiNGo0>GUi@T0
iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 128},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["\<\
This makes the current selection be the next cell in the notebook. \
\
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.29"}],

Cell[CellGroupData[{

Cell["SelectionMove[nb, Next, Cell]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000S2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3UiND0oooo03<c<`3o03<c<ol0<c<c200c<c<10>GUi@000P3oool00`3UiND0
<c<c03<c<`3o03<c<ol0<c<c1P0c<c<10?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo
00020?ooool0VIVIo`2IVIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<1
0?ooo`000P3oool309VIVOl0iNGUo`3UiND10>GUi@<0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooool@3oool5000000L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooo`0?ooo`L000001P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?oooo00oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooool03oool500000003
0?ooo`000000oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooo`0?ooo`D0000000<0oooo0000003oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oooo00oooo1@0000000`3oool000000?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooool03oool500000003
0?ooo`000000oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<c2`3oool9000000H0oooo0P0000050?ooo`8000000`3oool3000000<0oooo0P0000050?ooo`<0
0000203oool2000000<0oooo1@0000080?ooo`L000001P3oool5000000@0oooo0`0000050?ooo`<0
00001@3oool3000000<0oooo0P0000030?ooo`8000000`3oool5000000P0oooo0`0000030?ooo`80
00000`3oool2000000<0oooo0`0000030?ooo`800000o`3ooom50?ooo`D0000000<0oooo0000003o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T0
00001P3oool2000000D0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000@0
oooo0P0000000`3oool00000000000070?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`80
00000P3oool3000000H0oooo0P0000030?ooo`8000000P3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0P0000020?ooo`80000000@0oooo00000000000000001`3oool2000000030?ooo`0000000000
0080oooo0P0000030?ooo`8000000P3oool2000000030?ooo`00000000000?l0ooooB@3oool50000
00030?ooo`000000oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<c2`3oool9000000H0oooo0P0000050?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000030?ooo`8000001P3oool200000080oooo0P0000030?oo
o`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool20000
00<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool20000
0?l0ooooB03oool5000000030?ooo`000000oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`80000000<0oooo0000
000000001P3oool2000000<0oooo0P00000;0?ooo`8000001`3oool2000000H0oooo0P0000030?oo
o`8000002`3oool2000000030?ooo`000000000000H0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool20000
00<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo000000000000o`3ooom=0?oo
o`D0000000<0oooo0000003oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000050000
00030?ooo`000000000000<0oooo1`0000060?ooo`8000001@3oool3000000P0oooo1P0000090?oo
o`<000000P3oool7000000030?ooo`000000000000H0oooo0P0000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool000000000000500000?l0ooooB03oool50000
00030?ooo`000000oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<c2`3oool9000000H0oooo0P0000050?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0`00000=0?oo
o`<000001`3oool3000000@0oooo0P0000030?ooo`80000000<0oooo0000000000001P3oool20000
00<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool20000
00H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`0000000000
00<0oooo0P00003o0?ooodP0oooo1@0000000`3oool000000?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`T0000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000030?ooo`8000001P3oool20000
0080oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?oo
o`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool200000?l0ooooB03oool5000000030?ooo`000000oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo0P0000050?oo
o`8000000P3oool2000000030?ooo`00000000000080oooo0`0000030?ooo`80000000<0oooo0000
000000001`3oool200000080oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000060?oo
o`8000000`3oool200000080oooo0P0000000`3oool00000000000030?ooo`8000000P3oool20000
0080oooo0P0000000`3oool00000000000020?ooo`<000000P3oool200000080oooo0P000000103o
ool000000000000000070?ooo`80000000<0oooo0000000000000P3oool300000080oooo0P000002
0?ooo`80000000<0oooo000000000000o`3ooom90?ooo`D0000000<0oooo0000003oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2
000000D0oooo0P0000030?ooo`<000000`3oool4000000<0oooo0`0000080?ooo`8000000`3oool5
000000P0oooo1@0000080?ooo`D00000103oool3000000D0oooo100000040?ooo`<000000`3oool6
000000@0oooo1@0000080?ooo`<000000`3oool6000000@0oooo0`00003o0?ooodX0oooo1@000000
0`3oool000000?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<aX0oooo0P0000050?ooo`800000IP3oool200000?l0ooooI@3oool5000000030?ooo`000000
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c6P3oool2
000000D0oooo0P00001V0?ooo`800000o`3ooomU0?ooo`800000103oool00`000000oooo0?ooo`04
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo0P000005
0?ooo`8000006`3oool2000004T0oooo0P00003o0?ooofD0oooo1@0000000`3oool000000?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooool03oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooo`0?ooo`L000001P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oooo40oooo1@0000070?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3ooooZ0?ooo`D0003o0P3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooo^0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooonh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooookP3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooo^0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<>0?ooo`<000000P3oool3
000000030?ooo`000000000000H000001P3oool2000000<0oooo0P0000020?ooo`H00000103oool2
000000<0oooo0`0000020?ooo`<0000000D0oooo000000000000oooo000000020?ooo`80000000<0
oooo0000000000001@0000000`3oool0000000000003000000H0oooo00<000000?ooo`3oool00P00
00020?ooo`80000000<0oooo0000000000000P3oool010000000oooo0?ooo`00003o0?ooogX0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool00080oooo0`2IVIT203<c<`l0oooo00<000000?ooo`3oool00P3oool010000000oooo
0?ooo`0000020?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P3oool01P000000
oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`020?ooo`060000003oool0oooo0000003oool000000`3oool010000000oooo0?ooo`0000020?oo
o`030000003oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P3oool010000000oooo0?oo
o`0000020?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo0?ooo`3o0?oo
og`0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`l0oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo0?ooo`800000103oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000103oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo
00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo0?ooo`800000103oool010000000oooo0?ooo`0000060?ooo`050000003oool0oooo
0?ooo`000000o`3ooomn0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<?0?ooo`030000003oool0
oooo0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0000000000060?ooo`030000
003oool0oooo0080oooo100000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool000000080oooo00H000000?ooo`3oool000000?ooo`00
00030?ooo`<000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool00000000000H0
oooo00<000000?ooo`3oool0100000030?ooo`050000003oool0oooo0?ooo`000000o`3ooomn0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c<?0?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool000000P3oool00`000000oooo000000020?ooo`030000003oool0oooo0080oooo00H00000
0?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool00P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo000000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo000000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3oool0o`3o
ooml0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<?0?ooo`030000003oool0oooo0080oooo0`00
00020?ooo`8000000P3oool3000000D0oooo0P0000030?ooo`8000000`3oool010000000oooo0?oo
o`0000050?ooo`8000000`3oool300000080oooo00D000000?ooo`00000000000?ooo`0300000080
oooo0P0000020?ooo`80000000<0oooo0000003oool00P0000030?ooo`<000000`3oool300000080
oooo0P0000020?ooo`80000000<0oooo0000000000000`00003o0?ooogd0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<`l0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0H0?ooo`04
0000003oool0oooo000001D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo0?l0ooooO03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c303oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0000001X0oooo00@000000?ooo`3oool00000o`3o
oonk0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<<0?ooo`T000001@3oool00`000000oooo0?oo
o`0A0?ooo`80000000<0oooo0000000000007P3oool00`000000oooo0?ooo`3o0?oooiX0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<ol0ooooj`3oool40000o`H0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooonh0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<ol0oooojP3oool50000o`H0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooonX0oooo1@000?l60?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3o
ooo^0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooonh0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2I
VIT203<c<ol0ooookP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooo^0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000000`3o
ool2000000D0oooo0`0000080?ooo`8000000`3oool5000000P0oooo1`0000050?ooo`8000000`3o
ool200000080oooo0P0000040?ooo`D000000`3oool2000000`0oooo0P0000070?ooo`8000000P3o
ool200000080oooo0P0000030?ooo`8000000P3oool5000000@0oooo0`0000030?ooo`800000103o
ool2000000@0oooo0`0000050?ooo`D000001`3oool2000000@0oooo0`0000030?ooo`8000000`3o
ool200000080oooo0P0000000`3oool00000000000070?ooo`800000203oool200000?H0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool200000080oooo0P00
00000`3oool00000000000020?ooo`800000103oool2000000030?ooo`000000000000L0oooo0P00
00020?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`<000001P3oool2000000<0oooo0P00
00020?ooo`8000000`3oool2000000<0oooo0P0000000`3oool000000000000<0?ooo`8000001`3o
ool2000000<0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
00020?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000040?ooo`80000000<0
oooo0000000000000`3oool2000000040?ooo`0000000000000000H0oooo0P0000040?ooo`800000
00<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`800000
1`3oool200000?l0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`800000
1@3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`800000
0`3oool2000000H0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`800000
1P3oool2000000<0oooo0P0000020?ooo`8000000`3oool2000000<0oooo0P0000000`3oool00000
0000000:0?ooo`<000001P3oool3000000@0oooo0P0000020?ooo`8000000`3oool2000000030?oo
o`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo000000000000
0`3oool2000000<0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo
0P0000030?ooo`8000000`3oool200000080oooo0P0000000`3oool00000000000020?ooo`800000
103oool3000000H0oooo0`00003m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T00000
1P3oool2000000D0oooo0P0000000`3oool00000000000060?ooo`8000000`3oool2000000/0oooo
0P0000070?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool200000080oooo
0P0000080?ooo`80000000<0oooo000000000000203oool3000000H0oooo0`0000060?ooo`800000
0P3oool2000000<0oooo0P0000060?ooo`80000000<0oooo0000000000001P3oool2000000<0oooo
0P0000030?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000P0oooo
0`0000030?ooo`8000001P3oool3000000H0oooo0`00003k0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI
0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool0000000000005000000030?oo
o`000000000000<0oooo1`0000060?ooo`8000001@3oool3000000P0oooo1P0000060?ooo`800000
0`3oool200000080oooo0P0000060?ooo`<000000P3oool2000000L0oooo0P0000070?ooo`800000
203oool200000080oooo0P0000030?ooo`800000103oool300000080oooo1`0000000`3oool00000
000000030?ooo`8000000`3oool7000000030?ooo`000000000000<0oooo0P0000060?ooo`800000
0`3oool7000000<0oooo0`0000030?ooo`800000203oool2000000L0oooo0P00003j0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`800000
0`3oool3000000d0oooo0`0000060?ooo`8000000`3oool200000080oooo0P0000040?ooo`<00000
103oool2000000P0oooo0`0000060?ooo`<000001P3oool200000080oooo0P0000030?ooo`800000
0P3oool3000000@0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo
0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`800000
0`3oool2000000<0oooo0`0000030?ooo`8000001P3oool3000000H0oooo0`00003k0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool9000000030?ooo`000000000000<0oooo
0P0000000`3oool00000000000030?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`800000
0`3oool2000000H0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000020?ooo`800000
0`3oool2000000<0oooo0P0000000`3oool000000000000:0?ooo`<000001P3oool3000000@0oooo
0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`8000000`3oool200000080oooo
0P0000000`3oool00000000000020?ooo`800000103oool3000000H0oooo0`00003m0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000020?ooo`800000
00<0oooo0000000000000P3oool3000000<0oooo0P0000000`3oool00000000000070?ooo`800000
0P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`800000
0P3oool300000080oooo0P0000030?ooo`80000000<0oooo000000000000303oool2000000L0oooo
0P0000030?ooo`8000000P3oool300000080oooo0P0000000`3oool00000000000030?ooo`800000
0P3oool2000000030?ooo`00000000000080oooo0`0000020?ooo`800000103oool2000000030?oo
o`000000000000<0oooo0P000000103oool000000000000000060?ooo`800000103oool200000003
0?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000L0
oooo0P00003o0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0
oooo0P0000030?ooo`<000000`3oool4000000<0oooo0`0000080?ooo`8000000`3oool5000000P0
oooo1@0000060?ooo`@000000P3oool200000080oooo100000020?ooo`D0000000<0oooo00000000
00000P00000<0?ooo`8000001`3oool200000080oooo0P0000020?ooo`H000000`3oool5000000@0
oooo0`0000030?ooo`P00000103oool3000000D0oooo1@0000050?ooo`@00000103oool3000000<0
oooo0P0000030?ooo`H0000000<0oooo0000000000001`3oool200000?l0oooo0@3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<c6P3oool2000000D0oooo0P00000i0?ooo`800000503oool2000003/0
oooo0P00000@0?ooo`8000001P3oool2000001<0oooo0P00003o0?ooo`h0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`800000>@3oool2000001@0oooo0P00000k0?ooo`80
0000403oool2000000H0oooo0P00000C0?ooo`800000o`3oool;0?ooo`@0003o1P3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0
oooo0P0000050?ooo`8000006`3oool2000001d0oooo0P0000020?ooo`800000:`3oool200000340
oooo0P00003o0?ooob/0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooojP3oool50000o`80
oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIWo03<c<ol0
<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIVOl0<c<co`0c<c<0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooool0VIVIo`2IVIT709VIV@80<c<c0@3oool00080oooo
o`2IVIWo09VIV@L0VIVI0P0c<c<10?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo0002
0?ooool0VIVIo`2IVIT709VIV@40iNGU0@0c<c<10?ooo`000P3ooooo0>GUiOl0iNGU2@3UiND10?oo
o`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 140},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["\<\
This reads the current selection, returning it as an expression in \
the kernel. \
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.30"}],

Cell[CellGroupData[{

Cell["NotebookRead[nb]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000S2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3UiND0oooo03<c<`3o03<c<ol0<c<c200c<c<10>GUi@000P3oool00`3UiND0
<c<c03<c<`3o03<c<ol0<c<c1P0c<c<10?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo
00020?ooool0VIVIo`2IVIT709VIV@80<c<c0@3oool00080ooooo`2IVIWo09VIV@L0VIVI0P0c<c<1
0?ooo`000P3oool309VIVOl0iNGUo`3UiND10>GUi@<0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooool@3oool5000000L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooo`0?ooo`L000001P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?oooo00oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooool03oool500000003
0?ooo`000000oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooo`0?ooo`D0000000<0oooo0000003oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oooo00oooo1@0000000`3oool000000?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooool03oool500000003
0?ooo`000000oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<c2`3oool9000000H0oooo0P0000050?ooo`8000000`3oool3000000<0oooo0P0000050?ooo`<0
0000203oool2000000<0oooo1@0000080?ooo`L000001P3oool5000000@0oooo0`0000050?ooo`<0
00001@3oool3000000<0oooo0P0000030?ooo`8000000`3oool5000000P0oooo0`0000030?ooo`80
00000`3oool2000000<0oooo0`0000030?ooo`800000o`3ooom50?ooo`D0000000<0oooo0000003o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T0
00001P3oool2000000D0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000@0
oooo0P0000000`3oool00000000000070?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`80
00000P3oool3000000H0oooo0P0000030?ooo`8000000P3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0P0000020?ooo`80000000@0oooo00000000000000001`3oool2000000030?ooo`0000000000
0080oooo0P0000030?ooo`8000000P3oool2000000030?ooo`00000000000?l0ooooB@3oool50000
00030?ooo`000000oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<c2`3oool9000000H0oooo0P0000050?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000030?ooo`8000001P3oool200000080oooo0P0000030?oo
o`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool20000
00<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool20000
0?l0ooooB03oool5000000030?ooo`000000oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo0P0000050?ooo`80000000<0oooo0000
000000001P3oool2000000<0oooo0P00000;0?ooo`8000001`3oool2000000H0oooo0P0000030?oo
o`8000002`3oool2000000030?ooo`000000000000H0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool20000
00<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo000000000000o`3ooom=0?oo
o`D0000000<0oooo0000003oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?oo
o`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000050000
00030?ooo`000000000000<0oooo1`0000060?ooo`8000001@3oool3000000P0oooo1P0000090?oo
o`<000000P3oool7000000030?ooo`000000000000H0oooo0P0000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool000000000000500000?l0ooooB03oool50000
00030?ooo`000000oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VI
V@80<c<c2`3oool9000000H0oooo0P0000050?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0`00000=0?oo
o`<000001`3oool3000000@0oooo0P0000030?ooo`80000000<0oooo0000000000001P3oool20000
00<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool20000
00H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`0000000000
00<0oooo0P00003o0?ooodP0oooo1@0000000`3oool000000?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`T0000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000030?ooo`8000001P3oool20000
0080oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?oo
o`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool200000?l0ooooB03oool5000000030?ooo`000000oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c2`3oool9000000H0oooo0P0000050?oo
o`8000000P3oool2000000030?ooo`00000000000080oooo0`0000030?ooo`80000000<0oooo0000
000000001`3oool200000080oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000060?oo
o`8000000`3oool200000080oooo0P0000000`3oool00000000000030?ooo`8000000P3oool20000
0080oooo0P0000000`3oool00000000000020?ooo`<000000P3oool200000080oooo0P000000103o
ool000000000000000070?ooo`80000000<0oooo0000000000000P3oool300000080oooo0P000002
0?ooo`80000000<0oooo000000000000o`3ooom90?ooo`D0000000<0oooo0000003oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2
000000D0oooo0P0000030?ooo`<000000`3oool4000000<0oooo0`0000080?ooo`8000000`3oool5
000000P0oooo1@0000080?ooo`D00000103oool3000000D0oooo100000040?ooo`<000000`3oool6
000000@0oooo1@0000080?ooo`<000000`3oool6000000@0oooo0`00003o0?ooodX0oooo1@000000
0`3oool000000?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<aX0oooo0P0000050?ooo`800000IP3oool200000?l0ooooI@3oool5000000030?ooo`000000
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c6P3oool2
000000D0oooo0P00001V0?ooo`800000o`3ooomU0?ooo`800000103oool00`000000oooo0?ooo`04
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0oooo0P000005
0?ooo`8000006`3oool2000004T0oooo0P00003o0?ooofD0oooo1@0000000`3oool000000?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooool03oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooo`0?ooo`L000001P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?oooo40oooo1@0000070?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0002
0?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3ooooZ0?ooo`D0003o0P3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`000P3oool309VIV@80<c<co`3oooo^0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o
0?ooonh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooookP3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool3
09VIV@80<c<co`3oooo^0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<>0?ooo`<000000P3oool3
000000030?ooo`000000000000H000001P3oool2000000<0oooo0P0000020?ooo`H00000103oool2
000000<0oooo0`0000020?ooo`<0000000D0oooo000000000000oooo000000020?ooo`80000000<0
oooo0000000000001@0000000`3oool0000000000003000000H0oooo00<000000?ooo`3oool00P00
00020?ooo`80000000<0oooo0000000000000P3oool010000000oooo0?ooo`00003o0?ooogX0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool00080oooo0`2IVIT203<c<`l0oooo00<000000?ooo`3oool00P3oool010000000oooo
0?ooo`0000020?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P3oool01P000000
oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`020?ooo`060000003oool0oooo0000003oool000000`3oool010000000oooo0?ooo`0000020?oo
o`030000003oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P3oool010000000oooo0?oo
o`0000020?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo0?ooo`3o0?oo
og`0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`l0oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo0?ooo`800000103oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000103oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo
00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo0?ooo`800000103oool010000000oooo0?ooo`0000060?ooo`050000003oool0oooo
0?ooo`000000o`3ooomn0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<?0?ooo`030000003oool0
oooo0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0000000000060?ooo`030000
003oool0oooo0080oooo100000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool000000080oooo00H000000?ooo`3oool000000?ooo`00
00030?ooo`<000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool00000000000H0
oooo00<000000?ooo`3oool0100000030?ooo`050000003oool0oooo0?ooo`000000o`3ooomn0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00020?ooo`<0VIVI0P0c<c<?0?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool000000P3oool00`000000oooo000000020?ooo`030000003oool0oooo0080oooo00H00000
0?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool00P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo000000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo000000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3oool0o`3o
ooml0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<?0?ooo`030000003oool0oooo0080oooo0`00
00020?ooo`8000000P3oool3000000D0oooo0P0000030?ooo`8000000`3oool010000000oooo0?oo
o`0000050?ooo`8000000`3oool300000080oooo00D000000?ooo`00000000000?ooo`0300000080
oooo0P0000020?ooo`80000000<0oooo0000003oool00P0000030?ooo`<000000`3oool300000080
oooo0P0000020?ooo`80000000<0oooo0000000000000`00003o0?ooogd0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<`l0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0H0?ooo`04
0000003oool0oooo000001D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo0?l0ooooO03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<c303oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0000001X0oooo00@000000?ooo`3oool00000o`3o
oonk0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<<0?ooo`T000001@3oool00`000000oooo0?oo
o`0A0?ooo`80000000<0oooo0000000000007P3oool00`000000oooo0?ooo`3o0?oooiX0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<ol0ooooj`3oool40000o`H0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooonh0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<ol0oooojP3oool50000o`H0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooonX0oooo1@000?l60?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3o
ooo^0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooonh0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2I
VIT203<c<ol0ooookP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooo^0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000000`3o
ool2000000D0oooo0`0000080?ooo`8000000`3oool5000000P0oooo1`0000050?ooo`8000000`3o
ool200000080oooo0P0000040?ooo`D000000`3oool2000000`0oooo0P0000070?ooo`8000000P3o
ool200000080oooo0P0000030?ooo`8000000P3oool5000000@0oooo0`0000030?ooo`800000103o
ool2000000@0oooo0`0000050?ooo`D000001`3oool2000000@0oooo0`0000030?ooo`8000000`3o
ool200000080oooo0P0000000`3oool00000000000070?ooo`800000203oool200000?H0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`8000001@3oool200000080oooo0P00
00000`3oool00000000000020?ooo`800000103oool2000000030?ooo`000000000000L0oooo0P00
00020?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`<000001P3oool2000000<0oooo0P00
00020?ooo`8000000`3oool2000000<0oooo0P0000000`3oool000000000000<0?ooo`8000001`3o
ool2000000<0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
00020?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000040?ooo`80000000<0
oooo0000000000000`3oool2000000040?ooo`0000000000000000H0oooo0P0000040?ooo`800000
00<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`800000
1`3oool200000?l0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<`/0oooo2@0000060?ooo`800000
1@3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`800000
0`3oool2000000H0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`800000
1P3oool2000000<0oooo0P0000020?ooo`8000000`3oool2000000<0oooo0P0000000`3oool00000
0000000:0?ooo`<000001P3oool3000000@0oooo0P0000020?ooo`8000000`3oool2000000030?oo
o`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo000000000000
0`3oool2000000<0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo
0P0000030?ooo`8000000`3oool200000080oooo0P0000000`3oool00000000000020?ooo`800000
103oool3000000H0oooo0`00003m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T00000
1P3oool2000000D0oooo0P0000000`3oool00000000000060?ooo`8000000`3oool2000000/0oooo
0P0000070?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool200000080oooo
0P0000080?ooo`80000000<0oooo000000000000203oool3000000H0oooo0`0000060?ooo`800000
0P3oool2000000<0oooo0P0000060?ooo`80000000<0oooo0000000000001P3oool2000000<0oooo
0P0000030?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000P0oooo
0`0000030?ooo`8000001P3oool3000000H0oooo0`00003k0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI
0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool0000000000005000000030?oo
o`000000000000<0oooo1`0000060?ooo`8000001@3oool3000000P0oooo1P0000060?ooo`800000
0`3oool200000080oooo0P0000060?ooo`<000000P3oool2000000L0oooo0P0000070?ooo`800000
203oool200000080oooo0P0000030?ooo`800000103oool300000080oooo1`0000000`3oool00000
000000030?ooo`8000000`3oool7000000030?ooo`000000000000<0oooo0P0000060?ooo`800000
0`3oool7000000<0oooo0`0000030?ooo`800000203oool2000000L0oooo0P00003j0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000060?ooo`800000
0`3oool3000000d0oooo0`0000060?ooo`8000000`3oool200000080oooo0P0000040?ooo`<00000
103oool2000000P0oooo0`0000060?ooo`<000001P3oool200000080oooo0P0000030?ooo`800000
0P3oool3000000@0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo
0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`800000
0`3oool2000000<0oooo0`0000030?ooo`8000001P3oool3000000H0oooo0`00003k0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool9000000030?ooo`000000000000<0oooo
0P0000000`3oool00000000000030?ooo`8000000`3oool2000000H0oooo0P0000020?ooo`800000
0`3oool2000000H0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000020?ooo`800000
0`3oool2000000<0oooo0P0000000`3oool000000000000:0?ooo`<000001P3oool3000000@0oooo
0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`8000000`3oool200000080oooo
0P0000000`3oool00000000000020?ooo`800000103oool3000000H0oooo0`00003m0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0oooo0P0000020?ooo`800000
00<0oooo0000000000000P3oool3000000<0oooo0P0000000`3oool00000000000070?ooo`800000
0P3oool2000000<0oooo0P0000060?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`800000
0P3oool300000080oooo0P0000030?ooo`80000000<0oooo000000000000303oool2000000L0oooo
0P0000030?ooo`8000000P3oool300000080oooo0P0000000`3oool00000000000030?ooo`800000
0P3oool2000000030?ooo`00000000000080oooo0`0000020?ooo`800000103oool2000000030?oo
o`000000000000<0oooo0P000000103oool000000000000000060?ooo`800000103oool200000003
0?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000L0
oooo0P00003o0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c<;0?ooo`T000001P3oool2000000D0
oooo0P0000030?ooo`<000000`3oool4000000<0oooo0`0000080?ooo`8000000`3oool5000000P0
oooo1@0000060?ooo`@000000P3oool200000080oooo100000020?ooo`D0000000<0oooo00000000
00000P00000<0?ooo`8000001`3oool200000080oooo0P0000020?ooo`H000000`3oool5000000@0
oooo0`0000030?ooo`P00000103oool3000000D0oooo1@0000050?ooo`@00000103oool3000000<0
oooo0P0000030?ooo`H0000000<0oooo0000000000001`3oool200000?l0oooo0@3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<c6P3oool2000000D0oooo0P00000i0?ooo`800000503oool2000003/0
oooo0P00000@0?ooo`8000001P3oool2000001<0oooo0P00003o0?ooo`h0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<aX0oooo0P0000050?ooo`800000>@3oool2000001@0oooo0P00000k0?ooo`80
0000403oool2000000H0oooo0P00000C0?ooo`800000o`3oool;0?ooo`@0003o1P3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<aX0
oooo0P0000050?ooo`8000006`3oool2000001d0oooo0P0000020?ooo`800000:`3oool200000340
oooo0P00003o0?ooob/0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0oooojP3oool50000o`80
oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool00080oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00020?ooo`<0VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`000P3oool309VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080
oooo0`2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00020?ooo`<0
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00080oooo0`2IVIWo03<c<ol0
<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`000P3oool309VIVOl0<c<co`0c<c<0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00020?ooool0VIVIo`2IVIT709VIV@80<c<c0@3oool00080oooo
o`2IVIWo09VIV@L0VIVI0P0c<c<10?ooo`000P3ooooo09VIVOl0VIVI1`2IVIT203<c<`40oooo0002
0?ooool0VIVIo`2IVIT709VIV@40iNGU0@0c<c<10?ooo`000P3ooooo0>GUiOl0iNGU2@3UiND10?oo
o`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 140},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"],

Cell[BoxData[
    \(Cell["Here is a second one.", "Section"]\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NotebookWrite[", "MR"],
  StyleBox["obj", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["data", "TI"],
  StyleBox["]", "MR"],
  " just discards the current selection and replaces it with ",
  StyleBox["data", "TI"],
  ". But particularly if you are setting up palettes, it is often convenient \
first to modify ",
  StyleBox["data", "TI"],
  " by inserting the current selection somewhere inside it. You can do this \
using ",
  StyleBox["selection placeholders", "TI"],
  " and ",
  StyleBox["NotebookApply", "MR"],
  ". The first time the character ",
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\)], "InlineFormula"],
  " , entered as \[Backslash]",
  StyleBox["[SelectionPlaceholder]", "MR"],
  " or \[EscapeKey]",
  StyleBox["spl\[EscapeKey]", "MR"],
  ", appears anywhere in ",
  StyleBox["data", "TI"],
  ", ",
  StyleBox["NotebookApply", "MR"],
  " will replace this character by the current selection.    "
}], "Text",
  CellTags->{"S2.11.3", "3.31"}],

Cell["\<\
Here is a simple notebook with the current selection being the \
contents of a cell. \
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.32"}],

Cell[CellGroupData[{

Cell["nb = SelectedNotebook[ ] ;", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooo`0?ooo`D0003o203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c<0oooo403Ng]h4000001h0
g]kN100000050=kNgP8000007`3Ng]h2000000`0g]kN100000020=kNg_l0ooooD@3oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<c0?oooa40g]kN0P00000O0=kNgP8000001P3Ng]h200000240g]kN0P00000=0=kNgP80
00000P3Ng]ko0?oooe40oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<`3oool700000080g]kN1P0000020=kNgPD0
00000`3Ng]h6000000030=kNgP000000000000H0000000<0g]kN000000000000100000030=kNgP80
00001P3Ng]h2000000<0g]kN1P0000070=kNgP030000003Ng]h0g]kN00D0g]kN1P0000030=kNgP80
00003@3Ng]h200000080g]kNo`3ooomA0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c<0oooo00<0g]kN00000000
00000P3Ng]h2000000<0g]kN100000030=kNgP8000000P3Ng]h2000000030=kNgP00000000000080
g]kN0P0000030=kNgP8000000P3Ng]h2000000030=kNgP00000000000080g]kN0P0000040=kNgP80
00001@3Ng]h2000000H0g]kN0P0000090=kNgP030000003Ng]h0g]kN00H0g]kN100000050=kNgP80
0000303Ng]h200000080g]kNo`3ooomA0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c<0oooo00<0g]kN00000000
0000203Ng]h2000000@0g]kN0P0000020=kNgP80000000<0g]kN0000000000000P3Ng]h2000000<0
g]kN0P0000020=kNgP80000000<0g]kN0000000000000P3Ng]h2000000@0g]kN0P0000050=kNgP80
00001P3Ng]h2000000L0g]kN1@0000070=kNgP8000001P3Ng]h2000000`0g]kN0P0000020=kNg_l0
ooooD@3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<c0?ooo`030=kNgP0000000000008000001P3Ng]h2000000@0
g]kN0P0000020=kNgP8000000P3Ng]h5000000<0g]kN0P0000020=kNgP80000000<0g]kN00000000
00000P3Ng]h2000000@0g]kN0P0000050=kNgP8000001P3Ng]h2000000T0g]kN00<000000=kNgP3N
g]h01`3Ng]h2000000H0g]kN0P00000<0=kNgP8000000P3Ng]ko0?oooe40oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c<`3oool00`3Ng]h0000000000002000000D0g]kN100000030=kNgP8000000P3Ng]h200000003
0=kNgP00000000000080g]kN0P0000030=kNgP<0000000@0g]kN000000000000g]kN0P0000020=kN
gP800000103Ng]h2000000D0g]kN0P0000060=kNgP8000002@3Ng]h00`000000g]kN0=kNgP060=kN
gP@000001@3Ng]h2000000`0g]kN0P0000020=kNg_l0ooooD@3oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<c0?oo
o`030=kNgP000000000000800000103Ng]h6000000030=kNgP000000000000@000000`3Ng]h40000
00<0g]kN1P0000030=kNgPD00000103Ng]h2000000H0g]kN0P0000030=kNgP@000004@3Ng]h60000
00<0g]kN0P0000060=kNgP8000001@3Ng]h200000080g]kNo`3ooomA0?ooo`030000o`3oool0oooo
00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<c<0oooo00<0g]kN0000000000000P3Ng]h2000002D0g]kN0P0000040=kNgP8000001P3Ng]h20000
00@0g]kN0`00000J0=kNgP8000001P3Ng]h2000000D0g]kN0P0000020=kNg_l0ooooD@3oool00`00
0?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<c0?ooo`L00000903Ng]h3000000@0g]kN100000050=kNgP800000103Ng]h20000
01T0g]kN0P0000040=kNgPD000000`3Ng]h400000080g]kNo`3ooomA0?ooo`030000o`3oool0oooo
00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<c<0ooooH`3Ng]h4000000T0g]kNo`3ooom@0?ooo`80003o203oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<`3ooomT0=kNgP<000002@3Ng]ko0?oo
odl0oooo00<0003o0?ooo`000?l0203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c<`3ooomU0=kNgP8000002@3Ng]ko0?ooodh0oooo00@0003o0?oo
o`3oool0003o203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooo`0?ooo`050000o`3oool0oooo0?ooo`000?l0203oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo_0?ooo`H0003o203o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@40iNGU0@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0
o`3UiNGo0>GUi@P0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["\<\
This replaces the current selection by a string that contains a \
copy of its previous form. \
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.33"}],

Cell[CellGroupData[{

Cell["NotebookApply[nb, \"x + 1/\[SelectionPlaceholder]\"]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooob0?ooo`D0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=/0?ooo`@000007P3oool4000000D0oooo0P00000O0?ooo`800000303oool400000?l0
oooo;03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c=C0?ooo`030000003oool0oooo01L0oooo0P00000O0?ooo`80
00001P3oool200000240oooo0P00000=0?ooo`800000o`3oool/0?ooo`030000o`3oool0oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c@0
oooo1P0000070?ooo`030000003oool0oooo00D0oooo1P0000040?ooo`8000001`3oool700000080
oooo1P0000020?ooo`D000000`3oool6000000030?ooo`000000000000H0000000<0oooo00000000
0000100000030?ooo`8000001P3oool2000000<0oooo1P0000070?ooo`030000003oool0oooo00D0
oooo1P0000030?ooo`8000003@3oool200000?l0oooo;03oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<e0?ooo`@0
0000203oool00`000000oooo0?ooo`070?ooo`8000001`3oool00`000000oooo0?ooo`060?ooo`80
00000P3oool2000000<0oooo100000030?ooo`8000000P3oool2000000030?ooo`00000000000080
oooo0P0000030?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P0000040?ooo`80
00001@3oool2000000H0oooo0P0000090?ooo`030000003oool0oooo00H0oooo100000050?ooo`80
0000303oool200000?l0oooo;03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<f0?ooo`8000001`3oool5000000L0
oooo0P0000070?ooo`8000001`3oool2000000P0oooo0P0000040?ooo`8000000P3oool200000003
0?ooo`00000000000080oooo0P0000030?ooo`8000000P3oool2000000030?ooo`00000000000080
oooo0P0000040?ooo`8000001@3oool2000000H0oooo0P0000070?ooo`D000001`3oool2000000H0
oooo0P00000<0?ooo`800000o`3oool/0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo0P0000090?ooo`03
0000003oool0oooo00L0oooo0P0000080?ooo`030000003oool0oooo00D0oooo100000060?ooo`80
0000103oool200000080oooo0P0000020?ooo`D000000`3oool200000080oooo0P0000000`3oool0
0000000000020?ooo`800000103oool2000000D0oooo0P0000060?ooo`8000002@3oool00`000000
oooo0?ooo`070?ooo`8000001P3oool2000000`0oooo0P00003o0?ooob`0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c=@3oool4000000P0oooo00<000000?ooo`3oool01`3oool2000000P0oooo0P0000060?ooo`@0
00001@3oool4000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0`000000103oool000000000003oool200000080oooo0P0000040?ooo`8000001@3oool20000
00H0oooo0P0000090?ooo`030000003oool0oooo00H0oooo100000050?ooo`800000303oool20000
0?l0oooo;03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<d0?ooo`H000003`3oool4000000T0oooo00<000000?oo
o`3oool0103oool4000000@0oooo1P0000000`3oool0000000000004000000<0oooo100000030?oo
o`H000000`3oool5000000@0oooo0P0000060?ooo`8000000`3oool400000140oooo1P0000030?oo
o`8000001P3oool2000000D0oooo0P00003o0?ooob`0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cBP3oool30000
00T0oooo0P0000050?ooo`8000000P3oool2000002D0oooo0P0000040?ooo`8000001P3oool20000
00@0oooo0`00000J0?ooo`8000001P3oool2000000D0oooo0P00003o0?ooob`0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<cB`3oool2000000X0oooo00<000000?ooo`3oool00P3oool7000002@0oooo0`0000040?oo
o`@000001@3oool2000000@0oooo0P00000I0?ooo`800000103oool5000000<0oooo1000003o0?oo
ob/0oooo0P000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c>o0?ooo`@00000o`3ooola0?ooo`030000o`3oool0003o00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<l00oooo0`00003o0?oo
oc00oooo00@0003o0?ooo`3oool0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c`@3oool200000?l0oooo;`3oool01@000?l0oooo0?ooo`3o
ool0003o00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooool@3oool60000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VI
VOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT10>GUi@40
<c<c0@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3UiND80>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SelectionEvaluate[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["evaluate the current selection in place "]},
          {Cell[TextData[{
              StyleBox["SelectionCreateCell[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "create a new cell containing just the current selection "]},
          {Cell[TextData[{
              StyleBox["SelectionEvaluateCreateCell[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
evaluate the current selection and create a new cell \
for the result \
\>"]},
          {Cell[TextData[{
              StyleBox["SelectionAnimate[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["animate graphics in the current selection "]},
          {Cell[TextData[{
              StyleBox["SelectionAnimate[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "animate graphics for ",
              StyleBox["t", "TI"],
              " seconds "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.3"],

Cell["Operations on the current selection. ", "Caption",
  CellTags->"S2.11.3"],

Cell["\<\
This makes the current selection be the whole contents of the cell. \
\
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.34"}],

Cell[CellGroupData[{

Cell["SelectionMove[nb, All, CellContents]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
oooolP3oool50000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c>`3oooli0=kNgP@000007P3Ng]h4000000D0g]kN0P00000O0=kNgP800000303Ng]h400000080
g]kNo`3ooolR0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo803Ng]h00`000000g]kN0=kNgP0G0=kNgP80
00007`3Ng]h2000000H0g]kN0P00000Q0=kNgP8000003@3Ng]h200000080g]kNo`3ooolR0?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<c/0oooo00<0g]kN000000000000100000070=kNgP030000003Ng]h0g]kN00D0
g]kN1P0000040=kNgP8000001`3Ng]h700000080g]kN1P0000020=kNgPD000000`3Ng]h600000003
0=kNgP000000000000H0000000<0g]kN000000000000100000030=kNgP8000001P3Ng]h2000000<0
g]kN1P0000070=kNgP030000003Ng]h0g]kN00D0g]kN1P0000030=kNgP8000003@3Ng]h200000080
g]kNo`3ooolR0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo0P3Ng]h4000000P0g]kN00<000000=kNgP3N
g]h01`3Ng]h2000000L0g]kN00<000000=kNgP3Ng]h01P3Ng]h200000080g]kN0P0000030=kNgP@0
00000`3Ng]h200000080g]kN0P0000000`3Ng]h00000000000020=kNgP8000000`3Ng]h200000080
g]kN0P0000000`3Ng]h00000000000020=kNgP800000103Ng]h2000000D0g]kN0P0000060=kNgP80
00002@3Ng]h00`000000g]kN0=kNgP060=kNgP@000001@3Ng]h2000000`0g]kN0P0000020=kNg_l0
oooo8P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<k0?ooo`<0g]kN0P0000070=kNgPD000001`3Ng]h2000000L0
g]kN0P0000070=kNgP800000203Ng]h2000000@0g]kN0P0000020=kNgP80000000<0g]kN00000000
00000P3Ng]h2000000<0g]kN0P0000020=kNgP80000000<0g]kN0000000000000P3Ng]h2000000@0
g]kN0P0000050=kNgP8000001P3Ng]h2000000L0g]kN1@0000070=kNgP8000001P3Ng]h2000000`0
g]kN0P0000020=kNg_l0oooo8P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<k0?ooo`<0g]kN0P0000090=kNgP03
0000003Ng]h0g]kN00L0g]kN0P0000080=kNgP030000003Ng]h0g]kN00D0g]kN100000060=kNgP80
0000103Ng]h200000080g]kN0P0000020=kNgPD000000`3Ng]h200000080g]kN0P0000000`3Ng]h0
0000000000020=kNgP800000103Ng]h2000000D0g]kN0P0000060=kNgP8000002@3Ng]h00`000000
g]kN0=kNgP070=kNgP8000001P3Ng]h2000000`0g]kN0P0000020=kNg_l0oooo8P3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<k0?ooo`80g]kN100000080=kNgP030000003Ng]h0g]kN00L0g]kN0P0000080=kNgP80
00001P3Ng]h4000000D0g]kN100000030=kNgP8000000P3Ng]h2000000030=kNgP00000000000080
g]kN0P0000030=kNgP<0000000@0g]kN000000000000g]kN0P0000020=kNgP800000103Ng]h20000
00D0g]kN0P0000060=kNgP8000002@3Ng]h00`000000g]kN0=kNgP060=kNgP@000001@3Ng]h20000
00`0g]kN0P0000020=kNg_l0oooo8P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<k0?ooo`030=kNgP0000000000
00@000003`3Ng]h4000000T0g]kN00<000000=kNgP3Ng]h0103Ng]h4000000@0g]kN1P0000000`3N
g]h0000000000004000000<0g]kN100000030=kNgPH000000`3Ng]h5000000@0g]kN0P0000060=kN
gP8000000`3Ng]h400000140g]kN1P0000030=kNgP8000001P3Ng]h2000000D0g]kN0P0000020=kN
g_l0oooo8P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<k0?oooaL0g]kN0`0000090=kNgP8000001@3Ng]h20000
0080g]kN0P00000U0=kNgP800000103Ng]h2000000H0g]kN0P0000040=kNgP<000006P3Ng]h20000
00H0g]kN0P0000050=kNgP8000000P3Ng]ko0?ooob80oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3ooolH0=kN
gP8000002P3Ng]h00`000000g]kN0=kNgP020=kNgPL00000903Ng]h3000000@0g]kN100000050=kN
gP800000103Ng]h2000001T0g]kN0P0000040=kNgPD000000`3Ng]h400000080g]kNo`3ooolQ0?oo
o`80003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c>`3ooon<0=kNgP@000002@3Ng]ko0?ooob00oooo00<0003o0?ooo`000?l01P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3ooon=0=kN
gP<000002@3Ng]ko0?oooal0oooo00@0003o0?ooo`3oool0003o1P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3ooon>0=kNgP8000002@3Ng]ko
0?oooah0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo40oooo1P000?l60?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@3o09VIVOl0VIVI1P2IVIT10>GUi@40<c<c0@3oool000030?ooo`3UiND0iNGU0?l0iNGU
o`3UiND80>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["This evaluates the current selection in place. ", "MathCaption",
  CellTags->{"S2.11.3", "3.35"}],

Cell[CellGroupData[{

Cell["SelectionEvaluate[nb]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000=B000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
oooolP3oool50000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<cA03oool6000000L0oooo00<000000?ooo`3oool01`3oool4000000D0oooo1P0000080?ooo`03
0000003oool0oooo00H0oooo100000060?ooo`H000003P3oool00`000000oooo0?ooo`070?ooo`@0
00001@3oool6000000l0oooo00<000000?ooo`3oool01@3oool600000?l0oooo9`3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=60?ooo`8000002@3oool00`000000oooo0?ooo`080?ooo`8000001`3oool4000000T0
oooo00<000000?ooo`3oool01@3oool200000080oooo0P0000060?ooo`@000003`3oool00`000000
oooo0?ooo`080?ooo`8000001`3oool400000100oooo00<000000?ooo`3oool01P3oool400000?l0
oooo:03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c=60?ooo`8000001`3oool5000000P0oooo0P0000080?ooo`80
0000203oool5000000D0oooo0P0000020?ooo`8000001`3oool2000000h0oooo1@0000080?ooo`80
0000203oool2000000l0oooo1@0000070?ooo`800000o`3ooolY0?ooo`030000o`3oool0oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dH0
oooo0P0000090?ooo`030000003oool0oooo00D0oooo1P0000070?ooo`8000002P3oool00`000000
oooo0?ooo`050?ooo`8000000P3oool2000000L0oooo0P00000@0?ooo`030000003oool0oooo00D0
oooo1P0000070?ooo`8000004@3oool00`000000oooo0?ooo`070?ooo`800000o`3ooolY0?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<dH0oooo0P0000090?ooo`030000003oool0oooo00D0oooo0P0000000`3oool0
0000000000070?ooo`@000002@3oool00`000000oooo0?ooo`050?ooo`D000001`3oool400000080
oooo1@0000080?ooo`030000003oool0oooo00D0oooo0P0000000`3oool00000000000070?ooo`@0
00000`3oool3000000X0oooo00<000000?ooo`3oool01P3oool4000000D0oooo0P00003o0?ooob40
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<cA03oool400000180oooo100000060?ooo`H00000403oool2000000T0
oooo1P0000020?ooo`8000004`3oool4000000H0oooo1P000000103oool000000000003oool20000
0140oooo1P0000040?ooo`800000o`3ooolQ0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dD0oooo0`00000C0?oo
o`<000007@3oool200000140oooo0P00000C0?ooo`<00000403oool2000001P0oooo1@00003o0?oo
ob40oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<cAP3oool2000001@0oooo0P00000N0?ooo`<00000403oool20000
01<0oooo0P00000?0?ooo`8000006P3oool400000?l0oooo8@3oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c><0?oo
o`80000000<0oooo0000000000008P3oool2000000030?ooo`000000000001X0oooo0`00003o0?oo
ob40oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<cS@3oool3000002@0oooo0`00000L0?ooo`800000o`3ooolQ0?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<[0?ooo`H000001`3oool00`00
0000oooo0?ooo`3o0?oook/0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c;03oool4000000P0oooo00<000000?oo
o`3oool0o`3ooonk0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bd0oooo0P0000070?ooo`D000001P3ooonG0000
0?l0oooo7P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<]0?ooo`8000002@3oool00`000000oooo0?ooo`3o0?oo
ok/0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c;03oool4000000P0oooo00<000000?ooo`3oool0o`3ooonk0?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<b/0oooo1P00003o0?ooolD0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>:0?ooo`H00000o`3ooomV0?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<h`0oooo0P00003o0?ooofP0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cS03oool20000
0?l0ooooJ03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c><0?ooo`800000o`3ooomW0?ooo`80003o1P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cS03oool20000
0?l0ooooIP3oool00`000?l0oooo0000o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c>:0?ooo`@00000o`3ooomU0?ooo`040000o`3oool0oooo
0000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<h/0oooo0`00003o0?ooof@0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c><0?ooo`800000o`3o
oomS0?ooo`H0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VI
V@H0VIVI0@3UiND103<c<`40oooo00000`3oool0iNGU0>GUi@3o0>GUiOl0iNGU203UiND10?ooo`00
o`3ooooo0?ooo``0oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 53},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["SelectionEvaluate", "MR"],
  " allows you to take material from a notebook and send it through the \
kernel for evaluation. On its own, however, ",
  StyleBox["SelectionEvaluate", "MR"],
  " always overwrites the material you took. But by using functions like ",
  StyleBox["SelectionCreateCell", "MR"],
  " you can maintain a record of the sequence of forms that are generated\
\[LongDash]just like in a standard ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Text",
  CellTags->{"S2.11.3", "3.36"}],

Cell["This makes the current selection be the whole cell. ", "MathCaption",
  CellTags->{"S2.11.3", "3.37"}],

Cell[CellGroupData[{

Cell["SelectionMove[nb, All, Cell]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000>R000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0k^k^0>k^kP3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>k^kP2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>k^kP2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT50>k^k_l0oooon@3oool20>k^
kP<0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<ol0ooooo@3oool0103^k^h0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0k^k^09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103^k^h0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080
VIVI0P0c<c?o0?oooo80oooo1@0000060?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3^k^h0VIVI0080VIVI0P0c<c?o0?oooo40oooo1`0000050?ooo`040>k^kP2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c?o0?oooo40oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`030?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3^k^h0VIVI0080VIVI0P0c<c?o0?oooo40oooo1@0000000`3oool000000?ooo`040?ooo`04
0>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=:0?ooo`H0
00001`3oool00`000000oooo0?ooo`070?ooo`@000001@3oool6000000P0oooo00<000000?ooo`3o
ool01P3oool4000000H0oooo1P00000>0?ooo`030000003oool0oooo00L0oooo100000050?ooo`H0
00003`3oool00`000000oooo0?ooo`050?ooo`H00000o`3ooolL0?ooo`D0000000<0oooo0000003o
ool0103oool0103^k^h0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80
<c<cC03oool2000000T0oooo00<000000?ooo`3oool0203oool2000000L0oooo100000090?ooo`03
0000003oool0oooo00D0oooo0P0000020?ooo`8000001P3oool4000000l0oooo00<000000?ooo`3o
ool0203oool2000000L0oooo1000000@0?ooo`030000003oool0oooo00H0oooo1000003o0?oooad0
oooo1@0000000`3oool000000?ooo`040?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3^k^h0VIVI0080VIVI0P0c<c=<0?ooo`8000001`3oool5000000P0oooo0P0000080?ooo`80
0000203oool5000000D0oooo0P0000020?ooo`8000001`3oool2000000h0oooo1@0000080?ooo`80
0000203oool2000000l0oooo1@0000070?ooo`800000o`3ooolN0?ooo`D0000000<0oooo0000003o
ool0103oool0103^k^h0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80
<c<cC03oool2000000T0oooo00<000000?ooo`3oool01@3oool6000000L0oooo0P00000:0?ooo`03
0000003oool0oooo00D0oooo0P0000020?ooo`8000001`3oool2000000<0oooo1@0000080?ooo`03
0000003oool0oooo00D0oooo1P0000070?ooo`800000103oool3000000X0oooo00<000000?ooo`3o
ool01`3oool2000000H0oooo0P00003o0?oooaH0oooo1@0000000`3oool000000?ooo`040?ooo`04
0>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=<0?ooo`80
00002@3oool00`000000oooo0?ooo`050?ooo`80000000<0oooo0000000000001`3oool4000000T0
oooo00<000000?ooo`3oool01@3oool5000000L0oooo100000030?ooo`8000002P3oool00`000000
oooo0?ooo`050?ooo`80000000<0oooo0000000000001`3oool400000080oooo0P0000000`3oool0
0000000000090?ooo`030000003oool0oooo00H0oooo100000050?ooo`800000o`3ooolF0?ooo`D0
000000<0oooo0000003oool0103oool0103^k^h0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
k^k^09VIV@0209VIV@80<c<cBP3oool400000180oooo100000060?ooo`H00000403oool2000000T0
oooo1P0000030?ooo`8000004P3oool4000000H0oooo1P0000040?ooo`8000004@3oool600000003
0?ooo`000000000000<00000o`3ooolF0?ooo`D0000000<0oooo0000003oool0103oool0103^k^h0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<cB`3oool3000001<0
oooo0`00000M0?ooo`8000004P3oool200000180oooo0`00000?0?ooo`8000006P3oool400000?l0
oooo5P3oool5000000030?ooo`000000oooo00@0oooo00@0k^k^09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<d`0oooo0P00000D0?ooo`8000007P3oool3000000d0
oooo0P0000000`3oool000000000000C0?ooo`8000003@3oool2000000030?ooo`000000000001X0
oooo0`00003o0?oooaH0oooo1@0000000`3oool000000?ooo`040?ooo`040>k^kP2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c>C0?ooo`<00000903oool3000001`0
oooo0P00003o0?oooaH0oooo1@0000000`3oool000000?ooo`040?ooo`040>k^kP2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c?o0?oooo40oooo1@0000000`3oool0
00000?ooo`040?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080
VIVI0P0c<c<a0?ooo`H000001`3oool00`000000oooo0?ooo`3o0?oook00oooo1@0000000`3oool0
00000?ooo`040?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080
VIVI0P0c<c<b0?ooo`@00000203oool00`000000oooo0?ooo`3o0?oook00oooo1@0000000`3oool0
00000?ooo`040?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080
VIVI0P0c<c<c0?ooo`8000001`3oool5000000H0ooooU`00003o0?oooa<0oooo1@0000000`3oool0
00000?ooo`040?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080
VIVI0P0c<c<c0?ooo`8000002@3oool00`000000oooo0?ooo`3o0?oook00oooo1@0000000`3oool0
00000?ooo`040?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080
VIVI0P0c<c<b0?ooo`@00000203oool00`000000oooo0?ooo`3o0?oook00oooo1@0000000`3oool0
00000?ooo`040?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080
VIVI0P0c<c<a0?ooo`H00000o`3ooonj0?ooo`D0000000<0oooo0000003oool0103oool0103^k^h0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<co`3ooooa0?ooo`D0
000000<0oooo0000003oool0103oool0103^k^h0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
k^k^09VIV@0209VIV@80<c<co`3ooooa0?ooo`D0000000<0oooo0000003oool0103oool0103^k^h0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<co`3ooooa0?ooo`D0
000000<0oooo0000003oool0103oool0103^k^h0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
k^k^09VIV@0209VIV@80<c<cT03oool600000?l0ooooF`3oool5000000030?ooo`000000oooo00@0
oooo00@0k^k^09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<i80
oooo0P00003o0?oooed0oooo1@0000000`3oool000000?ooo`040?ooo`040>k^kP2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c>B0?ooo`800000o`3ooomM0?ooo`D0
000000<0oooo0000003oool0103oool0103^k^h0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
k^k^09VIV@0209VIV@80<c<cTP3oool200000?l0ooooG@3oool5000000030?ooo`000000oooo00@0
oooo00@0k^k^09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<i80
oooo0P00003o0?oooed0oooo100000020?ooo`030000003oool0oooo00<0oooo00@0k^k^09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<i00oooo1000003o0?oooed0
oooo0`000000103oool000000?ooo`0000050?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3^k^h0VIVI0080VIVI0P0c<c>A0?ooo`<00000o`3ooomM0?ooo`80000000D0oooo0000
00000000oooo000000050?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3^k^h0
VIVI0080VIVI0P0c<c>B0?ooo`800000o`3ooomM0?ooo`030000003oool000000080000000<0oooo
0000003oool0103oool0103^k^h0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0k^k^09VIV@02
09VIV@80<c<co`3oooog0?ooo`030000003oool0oooo00<0oooo00@0k^k^09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<ol0ooool@3oool7000000D0oooo00@0k^k^
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<ol0oooolP3oool5
000000H0oooo00@0k^k^09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT2
03<c<ol0ooooo@3oool0103^k^h0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0k^k^09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3^k^h0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0k^k^09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>k^kP2IVIT00P2IVIT203<c<ol0ooooo@3oool0103^k^h0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0k^k^09VIV@0209VIV@80<c<co`3oooom0?ooo`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3^k^h0VIVI0080VIVIo`0c<c?o03<c<`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3^k^h0VIVI0080VIVIo`0c<c?o03<c<`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3^k^h0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI
0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0?l0VIVIo`2IVIT609VIV@40
k^k^0@0c<c<10?ooo`0000<0oooo0>k^kP3^k^h0o`3^k^ko0>k^kPP0k^k^0@3oool00?l0ooooo`3o
ool<0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 58},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["\<\
This creates a new cell, and copies the current selection into it. \
\
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.38"}],

Cell[CellGroupData[{

Cell["SelectionCreateCell[nb]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000IB000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooob0?ooo`D0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b80
oooo6P3Ng]h6000000L0g]kN00<000000=kNgP3Ng]h01`3Ng]h4000000D0g]kN1P0000080=kNgP03
0000003Ng]h0g]kN00H0g]kN100000060=kNgPH000003P3Ng]h00`000000g]kN0=kNgP070=kNgP@0
00001@3Ng]h6000000l0g]kN00<000000=kNgP3Ng]h01@3Ng]h6000000`0g]kNo`3ooolS0?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<b80oooo703Ng]h2000000T0g]kN00<000000=kNgP3Ng]h0203Ng]h2000000L0
g]kN100000090=kNgP030000003Ng]h0g]kN00D0g]kN0P0000020=kNgP8000001P3Ng]h4000000l0
g]kN00<000000=kNgP3Ng]h0203Ng]h2000000L0g]kN1000000@0=kNgP030000003Ng]h0g]kN00H0
g]kN1000000=0=kNg_l0oooo8`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<R0?oooa`0g]kN0P0000070=kNgPD0
0000203Ng]h2000000P0g]kN0P0000080=kNgPD000001@3Ng]h200000080g]kN0P0000070=kNgP80
00003P3Ng]h5000000P0g]kN0P0000080=kNgP8000003`3Ng]h5000000L0g]kN0P00000>0=kNg_l0
oooo8`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<R0?oooa`0g]kN0P0000090=kNgP030000003Ng]h0g]kN00D0
g]kN1P0000070=kNgP8000002P3Ng]h00`000000g]kN0=kNgP050=kNgP8000000P3Ng]h2000000L0
g]kN0P00000@0=kNgP030000003Ng]h0g]kN00D0g]kN1P0000070=kNgP8000004@3Ng]h00`000000
g]kN0=kNgP070=kNgP8000003P3Ng]ko0?ooob<0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8P3ooolL0=kNgP80
00002@3Ng]h00`000000g]kN0=kNgP050=kNgP80000000<0g]kN0000000000001`3Ng]h4000000T0
g]kN00<000000=kNgP3Ng]h01@3Ng]h5000000L0g]kN100000020=kNgPD00000203Ng]h00`000000
g]kN0=kNgP050=kNgP80000000<0g]kN0000000000001`3Ng]h4000000<0g]kN0`00000:0=kNgP03
0000003Ng]h0g]kN00H0g]kN100000050=kNgP8000001P3Ng]ko0?ooob<0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c8P3ooolJ0=kNgP@000004P3Ng]h4000000H0g]kN1P00000@0=kNgP8000002@3Ng]h600000080
g]kN0P00000C0=kNgP@000001P3Ng]h6000000040=kNgP00000000000=kNgP8000004@3Ng]h60000
00@0g]kN0P0000060=kNg_l0oooo8`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<R0?oooa/0g]kN0`00000C0=kN
gP<000007@3Ng]h200000140g]kN0P00000C0=kNgP<00000403Ng]h2000001P0g]kN1@0000060=kN
g_l0oooo8`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<R0?oooa`0g]kN0P00000D0=kNgP8000007P3Ng]h30000
0100g]kN0P00000C0=kNgP8000003`3Ng]h2000001X0g]kN100000060=kNg_l0oooo8`3oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<R0?ooof80g]kN0P0000000`3Ng]h000000000000R0=kNgP80000000<0g]kN0000
000000006P3Ng]h3000000H0g]kNo`3ooolS0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b80ooooH`3Ng]h30000
02@0g]kN0`00000L0=kNgP8000001P3Ng]ko0?ooob<0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8P3ooona0=kN
g_l0oooo8`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<R0?ooo`030=kNgP000000000000@000001`3Ng]h00`00
0000g]kN0=kNgP2P0=kNg_l0oooo8`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<R0?ooo`80g]kN100000080=kN
gP030000003Ng]h0g]kN0:00g]kNo`3ooolS0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b80oooo0`3Ng]h20000
00L0g]kN1@0000060=kNgYL000000`3Ng]ko0?ooob<0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8P3oool30=kN
gP8000002@3Ng]h00`000000g]kN0=kNgP2P0=kNg_l0oooo8`3oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<R0?oo
o`80g]kN100000080=kNgP030000003Ng]h0g]kN0:00g]kNo`3ooolS0?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<b80oooo00<0g]kN0000000000001000002Z0=kNg_l0oooo8`3oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<R0?oo
ok40g]kNo`3ooolS0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b80oooo/@3Ng]ko0?ooob<0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c8P3ooomP0=kNgPH00000B`3Ng]ko0?ooob<0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8P3ooomR0=kN
gP800000C@3Ng]ko0?ooob<0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8P3ooomR0=kNgP800000C@3Ng]ko0?oo
ob<0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c8P3ooomR0=kNgP800000C@3Ng]ko0?ooob<0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c8P3ooomR0=kNgP800000C@3Ng]ko0?ooob80oooo0P000?l60?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<R0?ooof00g]kN1000001=0=kN
g_l0oooo8@3oool00`000?l0oooo0000o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<R0?ooof40g]kN0`00001=0=kNg_l0oooo803oool01000
0?l0oooo0?ooo`000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<R0?ooof80g]kN0P00001=0=kNg_l0oooo7`3oool01@000?l0oooo0?ooo`3o
ool0003o00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooool@3oool60000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooolP3oool50000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<l0?ooo`H000001`3oool00`000000oooo0?ooo`070?ooo`@000001@3oool6000000P0oooo00<0
00000?ooo`3oool01P3oool4000000H0oooo1P00000>0?ooo`030000003oool0oooo00L0oooo1000
00050?ooo`H000003`3oool00`000000oooo0?ooo`050?ooo`H00000o`3oool_0?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ch0oooo0P0000090?ooo`030000003oool0oooo00P0oooo0P0000070?ooo`@000002@3o
ool00`000000oooo0?ooo`050?ooo`8000000P3oool2000000H0oooo1000000?0?ooo`030000003o
ool0oooo00P0oooo0P0000070?ooo`@00000403oool00`000000oooo0?ooo`060?ooo`@00000o`3o
ool`0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ch0oooo0P0000070?ooo`D00000203oool2000000P0oooo0P00
00080?ooo`D000001@3oool200000080oooo0P0000070?ooo`8000003P3oool5000000P0oooo0P00
00080?ooo`8000003`3oool5000000L0oooo0P00003o0?oooc40oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?P3o
ool2000000T0oooo00<000000?ooo`3oool01@3oool6000000L0oooo0P00000:0?ooo`030000003o
ool0oooo00D0oooo0P0000020?ooo`8000001`3oool200000100oooo00<000000?ooo`3oool01@3o
ool6000000L0oooo0P00000A0?ooo`030000003oool0oooo00L0oooo0P00003o0?oooc40oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c?P3oool2000000T0oooo00<000000?ooo`3oool01@3oool2000000030?ooo`00
0000000000L0oooo100000090?ooo`030000003oool0oooo00D0oooo1@0000070?ooo`@000000P3o
ool5000000P0oooo00<000000?ooo`3oool01@3oool2000000030?ooo`000000000000L0oooo1000
00030?ooo`<000002P3oool00`000000oooo0?ooo`060?ooo`@000001@3oool200000?l0oooo:@3o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<l0?ooo`@000004P3oool4000000H0oooo1P00000@0?ooo`8000002@3o
ool600000080oooo0P00000C0?ooo`@000001P3oool6000000040?ooo`00000000000?ooo`800000
4@3oool6000000@0oooo0P00003o0?ooobT0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?@3oool3000001<0oooo
0`00000M0?ooo`8000004@3oool2000001<0oooo0`00000@0?ooo`800000603oool500000?l0oooo
:@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<n0?ooo`800000503oool2000001h0oooo0`00000@0?ooo`800000
4`3oool2000000l0oooo0P00000J0?ooo`@00000o`3ooolY0?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<h@0oooo
0P0000000`3oool000000000000R0?ooo`80000000<0oooo0000000000006P3oool300000?l0oooo
:@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c>50?ooo`<00000903oool3000001`0oooo0P00003o0?ooobT0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b<0oooo1P0000070?ooo`030000
003oool0oooo0?l0oooo``3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<T0?ooo`@00000203oool00`000000oooo
0?ooo`3o0?oool<0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c9@3oool2000000L0oooo1@0000060?oooiL00000
o`3ooolV0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<bD0oooo0P0000090?ooo`030000003oool0oooo0?l0oooo
``3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<T0?ooo`@00000203oool00`000000oooo0?ooo`3o0?oool<0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c8`3oool600000?l0ooooc@3oool00`000?l0oooo0?ooo`040?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<h80oooo1P00003o0?ooofh0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<cQ03oool200000?l0ooooL03oool00`000?l0oooo0?ooo`040?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>40?ooo`800000
o`3ooom`0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<h@0oooo0P00003o0?ooog00oooo00<0003o0?ooo`3oool0
103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
Q03oool200000?l0ooooK`3oool20000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<h80oooo1000003o0?ooofh0oooo00<0003o0?ooo`000?l0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
P`3oool300000?l0ooooK@3oool010000?l0oooo0?ooo`000?l60?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>40?ooo`800000o`3ooom/0?ooo`05
0000o`3oool0oooo0?ooo`000?l01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3ooooa0?ooo`H0003o1P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@40iNGU0@0c<c<10?ooo`0000<0
oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3oool00?l0ooooo`3oool<0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 101},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[TextData[{
  "This wraps ",
  StyleBox["Factor", "MR"],
  " around the contents of the current cell. "
}], "MathCaption",
  CellTags->{"S2.11.3", "3.39"}],

Cell[CellGroupData[{

Cell["NotebookApply[nb, \"Factor[\[SelectionPlaceholder]]\"]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000IR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo<0oooo1@000?l50?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=n0?ooo`H0
00001`3oool00`000000oooo0?ooo`070?ooo`@000001@3oool6000000P0oooo00<000000?ooo`3o
ool01P3oool4000000H0oooo1P00000>0?ooo`030000003oool0oooo00L0oooo100000050?ooo`H0
00003`3oool00`000000oooo0?ooo`050?ooo`H00000k@3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>00?ooo`80
00002@3oool00`000000oooo0?ooo`080?ooo`8000001`3oool4000000T0oooo00<000000?ooo`3o
ool01@3oool200000080oooo0P0000060?ooo`@000003`3oool00`000000oooo0?ooo`080?ooo`80
00001`3oool400000100oooo00<000000?ooo`3oool01P3oool400000>h0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<cP03oool2000000L0oooo1@0000080?ooo`800000203oool2000000P0oooo1@0000050?ooo`80
00000P3oool2000000L0oooo0P00000>0?ooo`D00000203oool2000000P0oooo0P00000?0?ooo`D0
00001`3oool200000>l0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cP03oool2000000T0oooo00<000000?ooo`3o
ool01@3oool6000000L0oooo0P00000:0?ooo`030000003oool0oooo00D0oooo0P0000020?ooo`80
00001`3oool200000100oooo00<000000?ooo`3oool01@3oool6000000L0oooo0P00000A0?ooo`03
0000003oool0oooo00L0oooo0P00003_0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<h00oooo0P0000090?ooo`03
0000003oool0oooo00D0oooo0P0000000`3oool00000000000070?ooo`@000002@3oool00`000000
oooo0?ooo`050?ooo`D000001`3oool400000080oooo1@0000080?ooo`030000003oool0oooo00D0
oooo0P0000000`3oool00000000000070?ooo`@000000`3oool3000000X0oooo00<000000?ooo`3o
ool01P3oool4000000D0oooo0P00003W0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<gh0oooo1000000B0?ooo`@0
00001P3oool600000100oooo0P0000090?ooo`H000000P3oool2000001<0oooo100000060?ooo`H0
000000@0oooo000000000000oooo0P00000A0?ooo`H00000103oool200000>L0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<cG`3oool4000001`0oooo0`00000C0?ooo`<000007@3oool200000140oooo0P00000C0?oo
o`<00000403oool2000001P0oooo1@0000070?ooo`@00000g03oool00`000?l0oooo0?ooo`030?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=O0?oo
o`8000007`3oool2000001@0oooo0P00000N0?ooo`<00000403oool2000001<0oooo0P00000?0?oo
o`8000006P3oool4000000T0oooo0P00003L0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<el0oooo0P00001U0?oo
o`80000000<0oooo0000000000008P3oool2000000030?ooo`000000000001X0oooo0`0000090?oo
o`800000g03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c=O0?ooo`800000IP3oool3000002@0oooo0`00000L0?oo
o`8000002@3oool200000=`0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cG`3oool200000;L0oooo0P00003L0?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<bd0oooo1@0000040?ooo`H000000`3oool4000000D0oooo0`0000040?oo
o`@000000`3oool5000000@0oooo0P0000040?ooo`H000001`3oool00`000000oooo0?ooo`2S0?oo
o`800000g03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<^0?ooo`8000001@3oool200000080oooo0P0000030?oo
o`8000000P3oool2000000<0oooo0P0000000`3oool00000000000020?ooo`8000000P3oool20000
00<0oooo0P0000060?ooo`8000001@3oool4000000P0oooo00<000000?ooo`3oool0X`3oool20000
0=`0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c;P3oool2000000D0oooo0P0000020?ooo`8000000`3oool20000
00L0oooo0P0000050?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000001P3oool20000
00L0oooo1@0000060?oooiL000001P3oool200000=`0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c;P3oool40000
00@0oooo1@0000030?ooo`8000001`3oool2000000D0oooo0P0000020?ooo`8000000`3oool20000
00H0oooo0P0000060?ooo`8000002@3oool00`000000oooo0?ooo`2S0?ooo`800000g03oool00`00
0?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<^0?ooo`@000000`3oool200000080oooo0P0000030?ooo`8000000P3oool20000
00<0oooo0P0000050?ooo`8000000P3oool2000000<0oooo0`0000050?ooo`8000001@3oool40000
00P0oooo00<000000?ooo`3oool0X`3oool200000=`0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c;P3oool40000
00@0oooo100000050?ooo`@000000`3oool5000000@0oooo100000030?ooo`H000000`3oool20000
00@0oooo1P00002]0?ooo`800000g03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<^0?ooo`8000000P3oool20000
01<0oooo0P00000F0?ooo`800000]`3oool200000=`0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c;@3oool70000
01<0oooo0P00000F0?ooo`800000]`3oool200000=`0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cG`3oool20000
06<0oooo1P00001>0?ooo`800000g03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=O0?ooo`@00000H`3oool20000
04h0oooo1000003L0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<lH0oooo0P00003o0?ooobh0oooo0P000?l50?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?60?oo
o`800000o`3oool]0?ooo`030000o`3oool0003o00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<lH0oooo0P00003o0?ooob`0oooo00@0003o0?oo
o`3oool0003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<ca03oool400000?l0oooo:`3oool01@000?l0oooo0?ooo`3oool0003o00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<lD0oooo0`00
003o0?ooobX0oooo1P000?l50?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?60?ooo`800000o`3ooole0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooc0?ooo`D0003o1@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cA`3o
ool6000000L0oooo00<000000?ooo`3oool01`3oool4000000D0oooo1P0000080?ooo`030000003o
ool0oooo00H0oooo100000060?ooo`H000003P3oool00`000000oooo0?ooo`070?ooo`@000001@3o
ool6000000l0oooo00<000000?ooo`3oool01@3oool600000?l0oooo9@3oool00`000?l0oooo0?oo
o`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c=90?ooo`8000002@3oool00`000000oooo0?ooo`080?ooo`8000001`3oool4000000T0oooo00<0
00000?ooo`3oool01@3oool200000080oooo0P0000060?ooo`@000003`3oool00`000000oooo0?oo
o`080?ooo`8000001`3oool400000100oooo00<000000?ooo`3oool01P3oool400000?l0oooo9P3o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c=90?ooo`8000001`3oool5000000P0oooo0P0000080?ooo`800000203o
ool5000000D0oooo0P0000020?ooo`8000001`3oool2000000h0oooo1@0000080?ooo`800000203o
ool2000000l0oooo1@0000070?ooo`800000o`3ooolW0?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dT0oooo0P00
00090?ooo`030000003oool0oooo00D0oooo1P0000070?ooo`8000002P3oool00`000000oooo0?oo
o`050?ooo`8000000P3oool2000000L0oooo0P00000@0?ooo`030000003oool0oooo00D0oooo1P00
00070?ooo`8000004@3oool00`000000oooo0?ooo`070?ooo`800000o`3ooolW0?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<dT0oooo0P0000090?ooo`030000003oool0oooo00D0oooo0P0000000`3oool000000000
00070?ooo`@000002@3oool00`000000oooo0?ooo`050?ooo`D000001`3oool400000080oooo1@00
00080?ooo`030000003oool0oooo00D0oooo0P0000000`3oool00000000000070?ooo`@000000`3o
ool3000000X0oooo00<000000?ooo`3oool01P3oool4000000D0oooo0P00003o0?oooal0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<cA`3oool400000180oooo100000060?ooo`H00000403oool2000000T0oooo1P00
00020?ooo`8000004`3oool4000000H0oooo1P000000103oool000000000003oool200000140oooo
1P0000040?ooo`800000o`3ooolO0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dP0oooo0`00000C0?ooo`<00000
7@3oool200000140oooo0P00000C0?ooo`<00000403oool2000001P0oooo1@00003o0?oooal0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<cB@3oool2000001@0oooo0P00000N0?ooo`<00000403oool2000001<0oooo
0P00000?0?ooo`8000006P3oool400000?l0oooo7`3oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>?0?ooo`800000
00<0oooo0000000000008P3oool2000000030?ooo`000000000001X0oooo0`00003o0?oooal0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<cT03oool3000002@0oooo0`00000L0?ooo`800000o`3ooolO0?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<^0?ooo`H000001`3oool00`000000oooo
0?ooo`3o0?oookT0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c;`3oool4000000P0oooo00<000000?ooo`3oool0
o`3oooni0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<c00oooo0P0000070?ooo`D000001P3ooonG00000?l0oooo
703oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<`0?ooo`8000002@3oool00`000000oooo0?ooo`3o0?oookT0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c;`3oool4000000P0oooo00<000000?ooo`3oool0o`3oooni0?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<bh0oooo1P00003o0?oool<0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>=0?ooo`H00000o`3ooomT0?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<hl0oooo0P00003o0?ooofH0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cS`3oool200000?l0oooo
I@3oool20000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<hl0oooo0P00003o0?ooof@0oooo00<0003o0?ooo`000?l01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cS`3oool200000?l0oooo
H`3oool010000?l0oooo0?ooo`000?l50?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c>=0?ooo`@00000o`3ooomR0?ooo`050000o`3oool0oooo0?oo
o`000?l01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<cSP3oool300000?l0ooooH@3oool60000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<hl0oooo0P00003o0?ooof`0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0@3UiND103<c<`40oooo
00000`3oool0iNGU0>GUi@3o0>GUiOl0iNGU203UiND10?ooo`00o`3ooooo0?ooo``0oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 102},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["\<\
This evaluates the contents of the current cell, and creates a new \
cell to give the result. \
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.40"}],

Cell[CellGroupData[{

Cell["SelectionEvaluateCreateCell[nb]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000UB000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool00080ooooo`0c<c?o03<c<`T0<c<c0@3oool000030?oo
o`3UiND0iNGU0?l0<c<co`0c<c<803<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0
iNGUo`3UiND10>GUi@<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<gD0oooo0P00000O0?ooo`800000
o`3ooom@0?ooo`D0003o1P3oool50000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<g@0oooo0P00000Q0?ooo`800000o`3ooomC0?ooo`030000
o`3oool0oooo00P0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cM03oool2000000<0oooo1P0000070?ooo`030000
003oool0oooo00D0oooo1P0000030?ooo`800000o`3ooomC0?ooo`030000o`3oool0oooo00P0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<cL`3oool2000000H0oooo0P0000090?ooo`030000003oool0oooo00H0oooo
100000050?ooo`800000o`3ooomB0?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
L`3oool2000000H0oooo0P0000070?ooo`D000001`3oool2000000H0oooo0P00003o0?oooe80oooo
00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=c0?ooo`8000001P3oool2000000T0oooo
00<000000?ooo`3oool01`3oool2000000H0oooo0P0000050?ooo`800000o`3ooom;0?ooo`030000
o`3oool0oooo00P0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cL`3oool2000000H0oooo0P0000090?ooo`030000
003oool0oooo00H0oooo100000050?ooo`8000001@3oool200000?l0ooooB`3oool00`000?l0oooo
0?ooo`080?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<g@0oooo0P0000030?ooo`@000004@3oool6000000<0oooo
0P0000030?ooo`D00000o`3ooom;0?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
M03oool2000000@0oooo0`00000J0?ooo`800000103oool400000?l0ooooB`3oool00`000?l0oooo
0?ooo`080?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<gD0oooo0P0000040?ooo`8000006@3oool2000000H0oooo
0`00003o0?oood/0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>O0?ooo`800000
o`3ooom;0?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo/0?ooo`030000
o`3oool0oooo00P0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo/0?ooo`030000o`3oool0oooo00P0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooo/0?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
<03ooonc00000?l0oooo2@3oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
k03oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook03oool00`000?l0oooo
0?ooo`080?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook03oool00`000?l0oooo0?ooo`080?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooook03oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
k03oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook03oool00`000?l0oooo
0?ooo`080?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<c<0oooo1P0000070?ooo`030000003oool0oooo00D0oooo
1P0000070?ooo`030000003oool0oooo00L0oooo100000050?ooo`H000003`3oool00`000000oooo
0?ooo`060?ooo`@000001P3oool6000000h0oooo00<000000?ooo`3oool01`3oool4000000D0oooo
1P00000?0?ooo`030000003oool0oooo00D0oooo1P00003o0?oooa80oooo00<0003o0?ooo`3oool0
203oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<e0?ooo`8000002@3oool00`000000oooo0?ooo`060?ooo`@00000
203oool00`000000oooo0?ooo`080?ooo`8000001`3oool400000100oooo00<000000?ooo`3oool0
1@3oool200000080oooo0P0000060?ooo`@000003`3oool00`000000oooo0?ooo`080?ooo`800000
1`3oool400000100oooo00<000000?ooo`3oool01P3oool400000?l0oooo4`3oool00`000?l0oooo
0?ooo`080?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<cD0oooo0P0000070?ooo`D000001`3oool2000000L0oooo
1@0000080?ooo`800000203oool2000000l0oooo1@0000050?ooo`8000000P3oool2000000L0oooo
0P00000>0?ooo`D00000203oool2000000P0oooo0P00000?0?ooo`D000001`3oool200000?l0oooo
503oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cD0oooo0P0000090?ooo`030000
003oool0oooo00L0oooo0P0000090?ooo`030000003oool0oooo00D0oooo1P0000070?ooo`800000
4@3oool00`000000oooo0?ooo`050?ooo`8000000P3oool2000000L0oooo0P00000@0?ooo`030000
003oool0oooo00D0oooo1P0000070?ooo`8000004@3oool00`000000oooo0?ooo`070?ooo`800000
o`3ooolD0?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=@3oool2000000T0oooo
00<000000?ooo`3oool01P3oool4000000P0oooo00<000000?ooo`3oool01@3oool2000000030?oo
o`000000000000L0oooo100000020?ooo`D000002@3oool00`000000oooo0?ooo`050?ooo`D00000
1`3oool4000000<0oooo0`0000090?ooo`030000003oool0oooo00D0oooo0P0000000`3oool00000
000000070?ooo`@000001@3oool2000000T0oooo00<000000?ooo`3oool01P3oool4000000<0oooo
0`00003o0?ooo`d0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<c0?ooo`@00000
4@3oool600000100oooo100000060?ooo`H000000P3oool2000001<0oooo0P0000090?ooo`H00000
00@0oooo000000000000oooo0P00000A0?ooo`@000001P3oool6000000@0oooo0P00000A0?ooo`H0
000000@0oooo000000000000oooo0P00003o0?ooo``0oooo00<0003o0?ooo`3oool0203oool00`00
0?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<d0?ooo`<00000:03oool3000000l0oooo0P00000C0?ooo`8000004P3oool20000
0180oooo0`00000=0?ooo`D000006`3oool200000?l0oooo303oool00`000?l0oooo0?ooo`080?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<cD0oooo0P00000Y0?ooo`800000403oool2000001<0oooo0`00000?0?oo
o`800000503oool2000000h0oooo1000000H0?ooo`@00000o`3oool=0?ooo`030000o`3oool0oooo
00P0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<cK`3oool2000000030?ooo`000000000002<0oooo0P0000000`3o
ool000000000000T0?ooo`<00000603oool200000?l0oooo3P3oool20000o`X0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<cL03oool3000002D0oooo0`00000V0?ooo`800000603oool500000?l0oooo2P3oool00`00
0?l0oooo0000o`0:0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj@3oool010000?l0oooo0?ooo`000?l:
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooj03oool01@000?l0oooo0?ooo`3oool0003o00X0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3ooooW0?ooo`H0003o2P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?oo
o`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=o0?ooo`H000001`3o
ool00`000000oooo0?ooo`070?ooo`@000001@3oool6000000P0oooo00<000000?ooo`3oool01P3o
ool4000000H0oooo1P00000>0?ooo`030000003oool0oooo00L0oooo100000050?ooo`H000003`3o
ool00`000000oooo0?ooo`050?ooo`H00000g@3oool50000o`X0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cP@3o
ool2000000T0oooo00<000000?ooo`3oool0203oool2000000L0oooo100000090?ooo`030000003o
ool0oooo00D0oooo0P0000020?ooo`8000001P3oool4000000l0oooo00<000000?ooo`3oool0203o
ool2000000L0oooo1000000@0?ooo`030000003oool0oooo00H0oooo1000003R0?ooo`030000o`3o
ool0oooo00P0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<cP@3oool2000000L0oooo1@0000080?ooo`800000203o
ool2000000P0oooo1@0000050?ooo`8000000P3oool2000000L0oooo0P00000>0?ooo`D00000203o
ool2000000P0oooo0P00000?0?ooo`D000001`3oool200000><0oooo00<0003o0?ooo`3oool0203o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c>10?ooo`8000002@3oool00`000000oooo0?ooo`050?ooo`H000001`3o
ool2000000X0oooo00<000000?ooo`3oool01@3oool200000080oooo0P0000070?ooo`800000403o
ool00`000000oooo0?ooo`050?ooo`H000001`3oool200000140oooo00<000000?ooo`3oool01`3o
ool200000><0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>10?ooo`8000002@3o
ool00`000000oooo0?ooo`050?ooo`80000000<0oooo0000000000001`3oool4000000T0oooo00<0
00000?ooo`3oool01@3oool5000000L0oooo100000020?ooo`D00000203oool00`000000oooo0?oo
o`050?ooo`80000000<0oooo0000000000001`3oool4000000<0oooo0`00000:0?ooo`030000003o
ool0oooo00H0oooo100000050?ooo`800000f`3oool00`000?l0oooo0?ooo`080?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<gl0oooo1000000B0?ooo`@000001P3oool600000100oooo0P0000090?ooo`H000000P3o
ool2000001<0oooo100000060?ooo`H0000000@0oooo000000000000oooo0P00000A0?ooo`H00000
103oool200000=/0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=P0?ooo`@00000
703oool3000001<0oooo0`00000M0?ooo`8000004@3oool2000001<0oooo0`00000@0?ooo`800000
603oool5000000L0oooo1000003@0?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
H03oool2000001l0oooo0P00000D0?ooo`8000007P3oool300000100oooo0P00000C0?ooo`800000
3`3oool2000001X0oooo100000090?ooo`800000d03oool00`000?l0oooo0?ooo`080?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<f00oooo0P00001U0?ooo`80000000<0oooo0000000000008P3oool2000000030?oo
o`000000000001X0oooo0`0000090?ooo`800000d03oool00`000?l0oooo0?ooo`080?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<f00oooo0P00001V0?ooo`<00000903oool3000001`0oooo0P0000090?ooo`800000
d03oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f00oooo0P00002g0?ooo`800000
d03oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bh0oooo1@0000040?ooo`H00000
0`3oool4000000D0oooo0`0000040?ooo`@000000`3oool5000000@0oooo0P0000040?ooo`H00000
1`3oool00`000000oooo0?ooo`2S0?ooo`800000d03oool00`000?l0oooo0?ooo`080?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<bl0oooo0P0000050?ooo`8000000P3oool2000000<0oooo0P0000020?ooo`800000
0`3oool2000000030?ooo`00000000000080oooo0P0000020?ooo`8000000`3oool2000000H0oooo
0P0000050?ooo`@00000203oool00`000000oooo0?ooo`2S0?ooo`800000d03oool00`000?l0oooo
0?ooo`080?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<bl0oooo0P0000050?ooo`8000000P3oool2000000<0oooo
0P0000070?ooo`8000001@3oool200000080oooo0P0000030?ooo`8000001P3oool2000000H0oooo
0P0000070?ooo`D000001P3ooonG000000H0oooo0P00003@0?ooo`030000o`3oool0oooo00P0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c;`3oool4000000@0oooo1@0000030?ooo`8000001`3oool2000000D0oooo
0P0000020?ooo`8000000`3oool2000000H0oooo0P0000060?ooo`8000002@3oool00`000000oooo
0?ooo`2S0?ooo`800000d03oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bl0oooo
100000030?ooo`8000000P3oool2000000<0oooo0P0000020?ooo`8000000`3oool2000000D0oooo
0P0000020?ooo`8000000`3oool3000000D0oooo0P0000050?ooo`@00000203oool00`000000oooo
0?ooo`2S0?ooo`800000d03oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bl0oooo
100000040?ooo`@000001@3oool4000000<0oooo1@0000040?ooo`@000000`3oool6000000<0oooo
0P0000040?ooo`H00000[@3oool200000=00oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<_0?ooo`8000000P3oool2000001<0oooo0P00000F0?ooo`800000]`3oool200000=00oooo
00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<^0?ooo`L000004`3oool2000001H0oooo
0P00002g0?ooo`800000d03oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f00oooo
0P00001S0?ooo`H00000CP3oool200000=00oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c=P0?ooo`@00000H`3oool2000004h0oooo1000003@0?ooo`030000o`3oool0oooo00P0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<ca`3oool200000?l0oooo8`3oool00`000?l0oooo0?ooo`080?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<lL0oooo0P00003o0?ooob<0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?70?ooo`800000o`3ooolS0?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
a@3oool400000?l0oooo8`3oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<lH0oooo
0`00003o0?ooob80oooo0P000?l:0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<lL0oooo0P00003o0?ooob40oooo
00<0003o0?ooo`000?l02P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonT0oooo00@0003o0?ooo`3oool0
003o2P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonP0oooo00D0003o0?ooo`3oool0oooo0000o`0:0?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooi`3oool60000o`D0oooo1P000?l50?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool`3oool50000o`D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`00
0?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c=80?ooo`H000001`3oool00`000000oooo0?ooo`070?ooo`@000001@3oool60000
00P0oooo00<000000?ooo`3oool01P3oool4000000H0oooo1P00000>0?ooo`030000003oool0oooo
00L0oooo100000050?ooo`H000003`3oool00`000000oooo0?ooo`050?ooo`H00000o`3ooolT0?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<dX0oooo0P0000090?ooo`030000003oool0oooo00P0oooo0P0000070?oo
o`@000002@3oool00`000000oooo0?ooo`050?ooo`8000000P3oool2000000H0oooo1000000?0?oo
o`030000003oool0oooo00P0oooo0P0000070?ooo`@00000403oool00`000000oooo0?ooo`060?oo
o`@00000o`3ooolU0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dX0oooo0P0000070?ooo`D00000203oool20000
00P0oooo0P0000080?ooo`D000001@3oool200000080oooo0P0000070?ooo`8000003P3oool50000
00P0oooo0P0000080?ooo`8000003`3oool5000000L0oooo0P00003o0?ooobH0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<cBP3oool2000000T0oooo00<000000?ooo`3oool01@3oool6000000L0oooo0P00000:0?oo
o`030000003oool0oooo00D0oooo0P0000020?ooo`8000001`3oool200000100oooo00<000000?oo
o`3oool01@3oool6000000L0oooo0P00000A0?ooo`030000003oool0oooo00L0oooo0P00003o0?oo
obH0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<cBP3oool2000000T0oooo00<000000?ooo`3oool01@3oool20000
00030?ooo`000000000000L0oooo100000090?ooo`030000003oool0oooo00D0oooo1@0000070?oo
o`@000000P3oool5000000P0oooo00<000000?ooo`3oool01@3oool2000000030?ooo`0000000000
00L0oooo100000030?ooo`<000002P3oool00`000000oooo0?ooo`060?ooo`@000001@3oool20000
0?l0oooo7P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c=80?ooo`@000004P3oool4000000H0oooo1P00000@0?oo
o`8000002@3oool600000080oooo0P00000C0?ooo`@000001P3oool6000000040?ooo`0000000000
0?ooo`8000004@3oool6000000@0oooo0P00003o0?oooah0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cB@3oool3
000001<0oooo0`00000M0?ooo`8000004@3oool2000001<0oooo0`00000@0?ooo`800000603oool5
00000?l0oooo7P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=:0?ooo`800000503oool2000001h0oooo0`00000@
0?ooo`8000004`3oool2000000l0oooo0P00000J0?ooo`@00000o`3ooolN0?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<i00oooo0P0000000`3oool000000000000R0?ooo`80000000<0oooo0000000000006P3oool3
00000?l0oooo7P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>A0?ooo`<00000903oool3000001`0oooo0P00003o
0?oooah0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bl0oooo1P000007
0?ooo`030000003oool0oooo0?l0oooo^03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<`0?ooo`@00000203oool0
0`000000oooo0?ooo`3o0?oookP0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<@3oool2000000L0oooo1@000006
0?oooiL00000o`3ooolK0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c40oooo0P0000090?ooo`030000003oool0
oooo0?l0oooo^03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<`0?ooo`@00000203oool00`000000oooo0?ooo`3o
0?oookP0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c;`3oool600000?l0oooo`P3oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<hh0oooo1P00003o
0?ooof<0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<cT03oool200000?l0ooooI@3oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>@
0?ooo`800000o`3ooomU0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<i00oooo0P00003o0?ooofD0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<cT03oool200000?l0ooooI03oool20000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<hh0oooo1000003o0?ooof<0oooo00<0003o
0?ooo`000?l01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<cS`3oool300000?l0ooooHP3oool010000?l0oooo0?ooo`000?l50?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>@0?ooo`800000o`3o
oomQ0?ooo`050000o`3oool0oooo0?ooo`000?l01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooob0?ooo`H0003o1@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2I
VIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0@3UiND103<c<`40oooo00000`3oool0
iNGU0>GUi@3o0>GUiOl0iNGU203UiND10?ooo`00o`3ooooo0?ooo``0oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 149},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[TextData[{
  "Functions like ",
  StyleBox["NotebookWrite", "MR"],
  " and ",
  StyleBox["SelectionEvaluate", "MR"],
  " by default leave the current selection just after whatever material they \
insert into your notebook. You can then always move the selection by \
explicitly using ",
  StyleBox["SelectionMove", "MR"],
  ". But functions like ",
  StyleBox["NotebookWrite", "MR"],
  " and ",
  StyleBox["SelectionEvaluate", "MR"],
  " can also take an additional argument which specifies where the current \
selection should be left after they do their work. "
}], "Text",
  CellTags->{"S2.11.3", "3.41"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NotebookWrite[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["data", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sel", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "write ",
              StyleBox["data", "TI"],
              
              " into a notebook, leaving the current selection as specified \
by ",
              StyleBox["sel", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NotebookApply[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["data", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sel", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "write ",
              StyleBox["data", "TI"],
              " replacing ",
              Cell[BoxData[
                  \(TraditionalForm\`\[SelectionPlaceholder]\)], 
                "InlineFormula"],
              
              " by the previous current selection, then leaving the current \
selection as specified by ",
              StyleBox["sel", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SelectionEvaluate[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sel", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "evaluate the current selection, making the new current \
selection be as specified by ",
              StyleBox["sel", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SelectionCreateCell[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sel", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "create a new cell containing just the current selection, and \
make the new current selection be as specified by ",
              StyleBox["sel", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SelectionEvaluateCreateCell[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sel", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "evaluate the current selection, make a new cell for the \
result, and make the new current selection be as specified by ",
              StyleBox["sel", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.3"],

Cell["\<\
Performing operations and specifying what the new current selection \
should be.\
\>", "Caption",
  CellTags->"S2.11.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["After", "MR"],
              " "
            }]], Cell[
            "immediately after whatever material is inserted (default) "]},
          {Cell[TextData[{
              StyleBox["Before", "MR"],
              " "
            }]], Cell["immediately before whatever material is inserted "]},
          {Cell[TextData[{
              StyleBox["All", "MR"],
              " "
            }]], Cell["the inserted material itself "]},
          {Cell[TextData[{
              StyleBox["Placeholder", "MR"],
              " "
            }]], Cell[TextData[{
              "the first ",
              Cell[BoxData[
                  \(TraditionalForm\`\[SelectionPlaceholder]\)], 
                "InlineFormula"],
              " in the inserted material "
            }]]},
          {Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell["leave the current selection unchanged "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.3"],

Cell["Specifications for the new current selection. ", "Caption",
  CellTags->"S2.11.3"],

Cell["Here is a blank notebook. ", "MathCaption",
  CellTags->{"S2.11.3", "3.42"}],

Cell[CellGroupData[{

Cell["nb = SelectedNotebook[ ] ;", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008;0000:b000`400?l00000o`00003oo`3no_ko
0?knoPd0o_kn00000`0c<c<000000000003o00000?l000002@0000010?knoP0000<0k^k^03<c<`0c
<c<0o`0c<c?o03<c<`P0<c<c0@0000010?knoP0000<0k^k^09VIV@2IVIT0o`2IVIWo09VIV@L0VIVI
0@0c<c<100000040o_kn00000`3^k^h0VIVI09VIV@3o09VIVOl0VIVI1`2IVIT103<c<`4000000@3n
o_h000030>k^kP2IVIT0VIVI0?l0VIVIo`2IVIT709VIV@40<c<c0@0000010?knoP0000@0k^k^09VI
V@2IVIT0VIVIo`3^k^ko0>k^kP80k^k^102IVIT103<c<`4000000@3no_h000040>k^kP2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0VIVI0080VIVI0@0c<c<100000040o_kn0000103^
k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3^k^h0VIVI09VIV@0209VIV@40<c<c0@000001
0?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT1
03<c<`4000000@3no_h000040>k^kP2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0
VIVI0080VIVI0@0c<c<100000040o_kn0000103^k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
0`3^k^h0VIVI09VIV@0209VIV@40<c<c0@0000010?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT103<c<`4000000@3no_h000040>k^kP2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0VIVI0080VIVI0@0c<c<100000040o_kn0000103^
k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3^k^h0VIVI09VIV@0209VIV@40<c<c0@000001
0?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT1
03<c<`4000000@3no_h000040>k^kP2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0
VIVI0080VIVI0@0c<c<100000040o_kn0000103^k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
0`3^k^h0VIVI09VIV@0209VIV@40<c<c0@0000010?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT103<c<`4000000@3no_h000040>k^kP2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0VIVI0080VIVI0@0c<c<100000040o_kn0000103^
k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3^k^h0VIVI09VIV@0209VIV@40<c<c0@000001
0?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT1
03<c<`4000000@3no_h000040>k^kP2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0
VIVI0080VIVI0@0c<c<100000040o_kn0000103^k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
0`3^k^h0VIVI09VIV@0209VIV@40<c<c0@0000010?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT103<c<`4000000@3no_h000040>k^kP2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0VIVI0080VIVI0@0c<c<100000040o_kn0000103^
k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3^k^h0VIVI09VIV@0209VIV@40<c<c0@000001
0?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT1
03<c<`4000000@3no_h000040>k^kP2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0
VIVI0080VIVI0@0c<c<100000040o_kn0000103^k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
0`3^k^h0VIVI09VIV@0209VIV@40<c<c0@0000010?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT103<c<`4000000@3no_h000040>k^kP2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0VIVI0080VIVI0@0c<c<100000040o_kn0000103^
k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3^k^h0VIVI09VIV@0209VIV@40<c<c0@000001
0?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT1
03<c<`4000000@3no_h000040>k^kP2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0
VIVI0080VIVI0@0c<c<100000040o_kn0000103^k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
0`3^k^h0VIVI09VIV@0209VIV@40<c<c0@0000010?knoP0000@0k^k^09VIV@2IVIT0VIVIo`0c<c?o
03<c<`40<c<c00<0k^k^09VIV@2IVIT00P2IVIT103<c<`4000000@3no_h000040>k^kP2IVIT0VIVI
09VIVOl0<c<co`0c<c<103<c<`030>k^kP2IVIT0VIVI0080VIVI0@0c<c<100000040o_kn00000`3^
k^h0VIVI09VIV@3o09VIVOl0VIVI1`2IVIT103<c<`4000000@3no_h000030>k^kP2IVIT0VIVI0?l0
VIVIo`2IVIT709VIV@40<c<c0@0000010?knoP0000<0k^k^09VIV@2IVIT0o`2IVIWo09VIV@L0VIVI
0@0c<c<100000040o_kn003o0>k^k_l0k^k^2`3^k^h100000040o_kn003o0?ooool0oooo303oool1
0?knoP00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{523, 43},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[TextData[{
  "This writes ",
  StyleBox["10!", "MR"],
  " into the notebook, making the current selection be what was written. "
}], "MathCaption",
  CellTags->{"S2.11.3", "3.43"}],

Cell[CellGroupData[{

Cell["NotebookWrite[nb, \"10!\", All]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooool@3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c=@3oool00`3Ng]h0000000000004000000<0g]kN100000050=kNgP80
00000P3Ng]ko0?ooojT0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=@3oool30=kNgP800000103Ng]h200000080
g]kN0P0000040=kNgP8000000P3Ng]ko0?ooojT0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=@3oool30=kNgP80
0000103Ng]h200000080g]kN0P0000080=kNg_l0ooooZ@3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<e0?ooo`<0
g]kN0P0000040=kNgP8000000P3Ng]h2000000@0g]kN0P0000020=kNg_l0ooooZ@3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<e0?ooo`<0g]kN0P0000040=kNgP8000000P3Ng]h2000000@0g]kN0P0000020=kNg_l0
ooooZ@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<e0?ooo`030=kNgP000000000000800000103Ng]h200000080
g]kN0P0000040=kNgP8000000P3Ng]ko0?ooojT0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=@3oool20=kNgP<0
0000103Ng]h200000080g]kN0P0000040=kNgP8000000P3Ng]ko0?ooojT0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c=@3oool30=kNgP8000001@3Ng]h4000000D0g]kN0P0000020=kNg_l0ooooZ03oool20000o`L0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooool`3oool00`000?l0oooo0000o`070?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo80oooo00@0003o0?ooo`3oool0003o1`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooa0?oo
o`050000o`3oool0oooo0?ooo`000?l01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`H0003o1`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o
03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o
03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVI
o`2IVIT609VIV@40iNGU0@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3o
ool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["\<\
This evaluates the current selection, creating a new cell for the \
result, and making the current selection be the whole of the result.\
\>", \
"MathCaption",
  CellTags->{"S2.11.3", "3.44"}],

Cell[CellGroupData[{

Cell["SelectionEvaluateCreateCell[nb, All]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000A2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3ooooc0?ooo`D0003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c`0
oooo0P3Ng]h4000000@0g]kN100000030=kNgPH000000`3Ng]h4000000@0g]kN100000040=kNgP@0
0000103Ng]h400000080g]kNo`3ooon30?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c`0oooo00<0g]kN00000000
00000P3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h200000080g]kN0P0000020=kNgP80
00000P3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h200000080g]kN0P0000020=kNgP80
00000P3Ng]h2000000030=kNgP3oool0oooo0?l0ooooP@3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<l0?ooo`D0
g]kN0P0000020=kNgP8000000P3Ng]h2000000<0g]kN0P0000050=kNgP8000000P3Ng]h200000080
g]kN0P0000020=kNgP8000000P3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h200000003
0=kNgP3oool0oooo0?l0ooooP@3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<l0?ooo`D0g]kN0P0000020=kNgP80
00000P3Ng]h2000000@0g]kN0P0000040=kNgP8000000P3Ng]h200000080g]kN0P0000020=kNgP80
00000P3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h2000000030=kNgP3oool0oooo0?l0
ooooP@3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<l0?ooo`<0g]kN0`0000030=kNgPD000001P3Ng]h2000000@0
g]kN100000040=kNgP@000000`3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h200000003
0=kNgP3oool0oooo0?l0ooooP@3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<l0?ooo`D0g]kN0P0000020=kNgP80
00002P3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h200000080g]kN0P0000020=kNgP80
00000P3Ng]h200000080g]kN0P0000020=kNgP80000000<0g]kN0?ooo`3oool0o`3ooon00?ooo`80
003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c?03oool00`3Ng]h00000000000020=kNgP8000000`3Ng]h2000000D0g]kN0P0000020=kNgP80
00000P3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h200000080g]kN0P0000020=kNgP80
00000P3Ng]h200000080g]kN0P0000000`3Ng]h0oooo0?ooo`3o0?ooogl0oooo00<0003o0?ooo`00
0?l01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c?03oool20=kNgP@000001@3Ng]h3000000@0g]kN100000040=kNgP@00000103Ng]h4000000@0
g]kN100000040=kNgP@000000P3Ng]ko0?oooh00oooo00@0003o0?ooo`3oool0003o1@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooc0?oo
o`050000o`3oool0oooo0?ooo`000?l01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooob0?ooo`H0003o1@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooc0?ooo`D0003o1@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cd0oooo1P0000030?ooo`@000001@3oool2
00000?l0ooooYP3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<o0?ooo`800000103oool200000080oooo0P000004
0?ooo`800000o`3ooonV0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cl0oooo0P0000040?ooo`8000000P3oool2
00000?l0oooo[03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<o0?ooo`800000103oool200000080oooo0P000004
0?ooo`800000o`3ooonV0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cl0oooo0P0000040?ooo`8000000P3oool2
000000@0oooo0P00003o0?ooojH0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?@3oool4000000@0oooo0P000002
0?ooo`800000103oool200000?l0ooooY@3oool20000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ch0oooo0`0000040?ooo`8000000P3oool2
000000@0oooo0P00003o0?oooj@0oooo00<0003o0?ooo`000?l01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?`3oool2000000D0oooo10000005
0?ooo`800000o`3ooonS0?ooo`040000o`3oool0oooo0000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool`3oool01@000?l0oooo0?oo
o`3oool0003o00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooolP3oool60000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<c
o`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<c
o`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI
1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT10>GUi@40<c<c0@3oool000030?ooo`3UiND0iNGU
0?l0iNGUo`3UiND80>GUi@40oooo003o0?ooool0oooo303oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 68},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[TextData[{
  "This wraps ",
  StyleBox["FactorInteger", "MR"],
  " around the current selection. "
}], "MathCaption",
  CellTags->{"S2.11.3", "3.45"}],

Cell[CellGroupData[{

Cell["\<\
NotebookApply[nb, \"FactorInteger[\[SelectionPlaceholder]]\", \
All]\
\>", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000C2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo1@000?l90?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo<0oooo00<0003o0?ooo`3o
ool01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3ooooc0?ooo`030000o`3oool0oooo00L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool`3oool00`000?l0oooo0?ooo`070?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<h0?oooe40
g]kN1000000E0=kNgP@00000>P3Ng]h400000080g]kNo`3oool=0?ooo`030000o`3oool0oooo00L0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0
ooooE03Ng]h2000001@0g]kN0P00000n0=kNgP8000000P3Ng]ko0?ooo`d0oooo00<0003o0?ooo`3o
ool01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c>03oool5000000@0g]kN1P0000030=kNgP@000001@3Ng]h3000000@0g]kN100000030=kNgPD0
00000`3Ng]h6000000030=kNgP000000000000H000000`3Ng]h3000000@0g]kN100000030=kNgPD0
0000103Ng]h4000000<0g]kN1@0000040=kNgP8000001@3Ng]h4000000@0g]kN100000030=kNgPH0
00000`3Ng]h4000000@0g]kN100000040=kNgP@00000103Ng]h4000000D0g]kN0P0000020=kNg_l0
oooo3@3oool00`000?l0oooo0?ooo`070?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<h0?ooo`030=kNgP000000000000D0g]kN0P0000020=kNgP80
00000`3Ng]h200000080g]kN0P0000030=kNgP80000000<0g]kN0000000000000P3Ng]h200000080
g]kN0P0000030=kNgP8000001`3Ng]h2000000@0g]kN0P0000020=kNgP8000000`3Ng]h200000003
0=kNgP00000000000080g]kN0P0000020=kNgP80000000<0g]kN0000000000000P3Ng]h2000000<0
g]kN0P0000020=kNgP8000000`3Ng]h2000000H0g]kN0P0000040=kNgP8000000P3Ng]h200000080
g]kN0P0000020=kNgP8000000P3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h200000080
g]kN0P0000020=kNgP8000000P3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h2000000@0
g]kN0P0000020=kNg_l0oooo3@3oool00`000?l0oooo0?ooo`070?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<h0?ooo`030=kNgP000000000000D0
g]kN0P0000020=kNgP8000000`3Ng]h2000000L0g]kN0P0000050=kNgP8000000P3Ng]h2000000<0
g]kN0P0000070=kNgP800000103Ng]h200000080g]kN0P0000030=kNgP8000001@3Ng]h2000000D0
g]kN0P0000020=kNgP8000000`3Ng]h2000000L0g]kN0P0000060=kNgP800000203Ng]h200000080
g]kN0P0000020=kNgP8000000`3Ng]h2000000D0g]kN0P0000020=kNgP8000000P3Ng]h200000080
g]kN0P0000020=kNgP8000000P3Ng]h200000080g]kN0P0000020=kNgP800000103Ng]h200000080
g]kNo`3oool=0?ooo`030000o`3oool0oooo00L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0oooo00<0g]kN0000000000000P0000040=kNgPD0
00000`3Ng]h2000000L0g]kN0P0000050=kNgP8000000P3Ng]h2000000<0g]kN0P0000070=kNgP80
0000103Ng]h200000080g]kN0P0000030=kNgP8000001@3Ng]h6000000030=kNgP00000000000080
g]kN0P0000030=kNgPH000000`3Ng]h2000000H0g]kN0P0000080=kNgP8000000P3Ng]h200000080
g]kN0P0000040=kNgP800000103Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h200000080
g]kN0P0000020=kNgP8000000P3Ng]h200000080g]kN0P0000040=kNgP8000000P3Ng]ko0?ooo`d0
oooo00<0003o0?ooo`3oool01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c>03oool00`3Ng]h0000000000002000000<0g]kN0P0000020=kNgP80
00000`3Ng]h200000080g]kN0P0000030=kNgP8000001@3Ng]h200000080g]kN0P0000030=kNgP<0
00001P3Ng]h2000000@0g]kN0`0000000`3Ng]h00000000000030=kNgP8000001@3Ng]h200000080
g]kN0P0000000`3Ng]h00000000000020=kNgP8000000`3Ng]h200000080g]kN0P0000030=kNgP<0
00001@3Ng]h2000000H0g]kN0`0000030=kNgPD000001P3Ng]h2000000@0g]kN100000040=kNgP@0
00000`3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h2000000@0g]kN0P0000020=kNg_l0
oooo303oool20000o`T0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<cP0oooo00<0g]kN0000000000000P0000040=kNgP@000001@3Ng]h4000000<0
g]kN1@0000040=kNgP@000000`3Ng]h6000000@0g]kN0P0000030=kNgPH000000`3Ng]h5000000@0
g]kN100000030=kNgPH000000`3Ng]h4000000<0g]kN1P0000030=kNgP800000203Ng]h200000080
g]kN0P00000:0=kNgP8000000P3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h200000080
g]kN0P0000020=kNgP8000000P3Ng]h200000080g]kN0P0000040=kNgP8000000P3Ng]ko0?ooo`/0
oooo00<0003o0?ooo`000?l02@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c>03oool00`3Ng]h00000000000020=kNgP8000004`3Ng]h2000001L0
g]kN0P00000=0=kNgP8000009P3Ng]h2000000@0g]kN0P0000020=kNgP8000000`3Ng]h2000000D0
g]kN0P0000020=kNgP8000000P3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h200000080
g]kN0P0000020=kNgP8000000P3Ng]h200000080g]kN0P0000040=kNgP8000000P3Ng]ko0?ooo`X0
oooo00@0003o0?ooo`3oool0003o2@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c>03oool7000001<0g]kN0P00000E0=kNgPH000002`3Ng]h20000
02H0g]kN100000030=kNgP@000001@3Ng]h3000000@0g]kN100000040=kNgP@00000103Ng]h40000
00@0g]kN100000040=kNgP@000000`3Ng]h400000080g]kNo`3oool90?ooo`050000o`3oool0oooo
0?ooo`000?l02@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooo^0?ooo`H0003o2@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo_0?ooo`D0003o2@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooc0?ooo`030000o`3oool0
oooo00L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooool`3oool00`000?l0oooo0?ooo`070?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo<0oooo00<0003o0?ooo`3oool01`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooc
0?ooo`030000o`3oool0oooo00L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooool`3oool00`000?l0oooo0?ooo`070?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<i0?ooo`H000000`3oool4
000000D0oooo0P00003o0?ooojH0oooo00<0003o0?ooo`3oool01`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3oool2000000@0oooo0P000002
0?ooo`800000103oool200000?l0ooooYP3oool00`000?l0oooo0?ooo`070?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<k0?ooo`800000103oool2
00000080oooo0P00003o0?oooj`0oooo00<0003o0?ooo`3oool01`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3oool2000000@0oooo0P000002
0?ooo`800000103oool200000?l0ooooYP3oool00`000?l0oooo0?ooo`070?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<k0?ooo`800000103oool2
00000080oooo0P0000040?ooo`800000o`3ooonU0?ooo`80003o2@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>@3oool4000000@0oooo0P000002
0?ooo`800000103oool200000?l0ooooY03oool00`000?l0oooo0000o`090?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<j0?ooo`<00000103oool2
00000080oooo0P0000040?ooo`800000o`3ooonS0?ooo`040000o`3oool0oooo0000o`T0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo0P00
00050?ooo`@000001@3oool200000?l0ooooXP3oool01@000?l0oooo0?ooo`3oool0003o00T0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
kP3oool60000o`T0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
o`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
o`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVI
o`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@40iNGU0@0c<c<10?ooo`0000<0oooo0>GU
i@3UiND0o`3UiNGo0>GUi@P0iNGU0@3oool00?l0ooooo`3oool<0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 76},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["\<\
This evaluates the current selection, leaving the selection just \
before the result. \
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.46"}],

Cell[CellGroupData[{

Cell["SelectionEvaluate[nb, Before]", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000A2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooob0?ooo`D0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3oool2000000P0oooo0P0000050?ooo`80
00008@3oool2000001<0oooo0P00000P0?ooo`8000004`3oool200000240oooo0P00000C0?ooo`80
00008@3oool2000000D0oooo0P00003F0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo0P0000070?ooo`80
00001@3oool2000000d0oooo0P00000D0?ooo`800000103oool2000000/0oooo0P00000=0?ooo`80
00004`3oool2000000@0oooo0P00000;0?ooo`8000003@3oool2000001@0oooo0P0000040?ooo`80
00002`3oool2000000d0oooo0P00000D0?ooo`8000001@3oool200000=D0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c>`3oool2000000L0oooo0P0000050?ooo`800000103oool6000000@0oooo0P00000:0?ooo`@0
00001@3oool2000000D0oooo0P00000:0?ooo`8000001@3oool4000000D0oooo0P00000:0?ooo`@0
0000103oool2000000D0oooo0P00000:0?ooo`8000001@3oool4000000D0oooo0P0000090?ooo`H0
0000103oool2000000D0oooo0P00000:0?ooo`8000001P3oool2000000H0oooo0P0000090?ooo`H0
0000103oool2000000D0oooo0P00003E0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo0P0000070?ooo`80
00001@3oool2000000@0oooo0P0000020?ooo`8000003`3oool200000080oooo0P0000040?ooo`80
00004@3oool2000000@0oooo0P0000020?ooo`8000004@3oool2000000D0oooo0P00000A0?ooo`80
0000103oool200000080oooo0P00000?0?ooo`8000000P3oool2000000@0oooo0P00000A0?ooo`80
00001P3oool2000001<0oooo0P0000060?ooo`8000001@3oool200000=D0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c>`3oool2000000H0oooo0P0000050?ooo`8000001P3oool200000180oooo0P0000020?ooo`80
00001@3oool2000000l0oooo0P0000090?ooo`8000004@3oool2000000H0oooo0P00000?0?ooo`80
00002@3oool200000100oooo0P0000080?ooo`8000003`3oool2000000L0oooo0P00000C0?ooo`80
00001`3oool2000000D0oooo0P00003D0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo0P0000070?ooo`80
00001@3oool2000000H0oooo0P00000A0?ooo`8000000P3oool2000000@0oooo0P00000A0?ooo`80
0000203oool2000000h0oooo1P0000040?ooo`8000004@3oool2000000@0oooo0P0000020?ooo`80
00004@3oool2000000H0oooo0P00000A0?ooo`8000001`3oool200000180oooo0P0000060?ooo`80
00001@3oool200000=D0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3oool2000000L0oooo0P0000050?ooo`80
00001`3oool200000140oooo100000050?ooo`8000004@3oool2000000H0oooo0`00000?0?ooo`80
000000<0oooo0000000000001@3oool200000140oooo0P0000040?ooo`D000004`3oool2000000D0
oooo0P00000A0?ooo`8000001`3oool200000180oooo0P0000060?ooo`8000001@3oool200000=@0
oooo0P000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<k0?ooo`8000001`3oool2000000D0oooo0P0000080?ooo`8000003`3oool200000080
oooo0P0000040?ooo`8000004@3oool2000000P0oooo0P00000?0?ooo`@000001@3oool200000140
oooo0P0000040?ooo`8000005`3oool2000000@0oooo0P00000A0?ooo`800000203oool2000000l0
oooo100000060?ooo`8000001@3oool200000=<0oooo00<0003o0?ooo`000?l01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3oool2000000L0
oooo0P0000050?ooo`800000103oool200000080oooo0P00000?0?ooo`8000000P3oool2000000@0
oooo0P00000A0?ooo`800000103oool200000080oooo0P00000@0?ooo`<000001@3oool200000140
oooo0P0000040?ooo`8000004`3oool200000080oooo0P0000040?ooo`8000004@3oool2000000@0
oooo0P0000020?ooo`800000403oool3000000H0oooo0P0000050?ooo`800000dP3oool010000?l0
oooo0?ooo`000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<k0?ooo`800000203oool2000000D0oooo0P0000040?ooo`@000004@3oool40000
00@0oooo0P00000C0?ooo`800000103oool400000180oooo0P0000040?ooo`8000004`3oool20000
00<0oooo1P00000@0?ooo`@00000103oool2000001<0oooo0P0000030?ooo`H000004@3oool20000
00D0oooo0P0000050?ooo`800000dP3oool01@000?l0oooo0?ooo`3oool0003o00H0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool@3oool6
0000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0oooolP3oool50000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`04
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c=P3oool6000000<0oooo100000050?ooo`800000o`3ooon/
0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<cP0oooo0P0000040?ooo`8000000P3oool2000000@0oooo0P00003o
0?oooj`0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c>03oool2000000@0oooo0P0000020?ooo`800000o`3ooonb
0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<cP0oooo0P0000040?ooo`8000000P3oool2000000@0oooo0P00003o
0?oooj`0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c>03oool2000000@0oooo0P0000020?ooo`800000103oool2
00000?l0ooooZ`3oool20000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<cH0oooo100000040?ooo`8000000P3oool2000000@0oooo0P00003o
0?ooojX0oooo00<0003o0?ooo`000?l01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c=`3oool3000000@0oooo0P0000020?ooo`800000103oool2
00000?l0ooooZ@3oool010000?l0oooo0?ooo`000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<h0?ooo`8000001@3oool4000000D0oooo0P00
003o0?ooojP0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo40oooo1P000?l60?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2I
VIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0@3UiND1
03<c<`40oooo00000`3oool0iNGU0>GUi@3o0>GUiOl0iNGU203UiND10?ooo`00o`3ooooo0?ooo``0
oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 68},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["\<\
This now inserts additional text at the position of the current \
selection. \
\>", "MathCaption",
  CellTags->{"S2.11.3", "3.47"}],

Cell[CellGroupData[{

Cell["NotebookWrite[nb, \"a = \"]", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000A2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3ooooa0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=D0?ooo`8000001@3oool200000200oooo0P00000C0?ooo`8000008@3oool2000001<0
oooo0P00000Q0?ooo`8000004P3oool200000240oooo0P0000050?ooo`800000a`3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=C0?ooo`8000001@3oool2000000d0oooo0P00000C0?ooo`800000103oool2000000/0
oooo0P00000=0?ooo`800000503oool2000000@0oooo0P00000;0?ooo`8000003@3oool2000001@0
oooo0P0000040?ooo`8000002P3oool2000000d0oooo0P00000D0?ooo`8000001@3oool200000<H0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c>`3oool600000180oooo0P0000050?ooo`800000103oool6000000@0
oooo0P0000090?ooo`@000001@3oool2000000D0oooo0P00000:0?ooo`8000001@3oool4000000D0
oooo0P00000;0?ooo`@00000103oool2000000D0oooo0P00000:0?ooo`8000001@3oool4000000D0
oooo0P0000090?ooo`H00000103oool2000000D0oooo0P0000090?ooo`8000001P3oool2000000H0
oooo0P0000090?ooo`H00000103oool2000000D0oooo0P0000360?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cX0
oooo0P0000020?ooo`8000001`3oool5000000L0oooo0P0000050?ooo`800000103oool200000080
oooo0P00000>0?ooo`8000000P3oool2000000@0oooo0P00000A0?ooo`800000103oool200000080
oooo0P00000B0?ooo`8000001@3oool200000140oooo0P0000040?ooo`8000000P3oool2000000l0
oooo0P0000020?ooo`800000103oool200000100oooo0P0000060?ooo`8000004`3oool2000000H0
oooo0P0000050?ooo`800000aP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<j0?ooo`8000000P3oool200000180
oooo0P0000050?ooo`8000001P3oool200000140oooo0P0000020?ooo`8000001@3oool2000000l0
oooo0P0000090?ooo`8000004P3oool2000000H0oooo0P00000?0?ooo`8000002@3oool200000100
oooo0P0000080?ooo`8000003P3oool2000000L0oooo0P00000C0?ooo`8000001`3oool2000000D0
oooo0P0000350?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo1@0000070?ooo`D000001`3oool2000000D0
oooo0P0000060?ooo`800000403oool200000080oooo0P0000040?ooo`8000004@3oool2000000P0
oooo0P00000?0?ooo`H00000103oool200000140oooo0P0000040?ooo`8000000P3oool200000140
oooo0P0000060?ooo`800000403oool2000000L0oooo0P00000B0?ooo`8000001P3oool2000000D0
oooo0P0000360?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cX0oooo0P0000020?ooo`8000004`3oool2000000D0
oooo0P0000070?ooo`800000403oool4000000D0oooo0P00000A0?ooo`8000001P3oool300000100
oooo0P0000000`3oool00000000000050?ooo`8000004@3oool2000000@0oooo1@00000C0?ooo`80
00001@3oool200000100oooo0P0000070?ooo`8000004P3oool2000000H0oooo0P0000050?ooo`80
0000aP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<k0?ooo`@00000503oool2000000D0oooo0P0000080?ooo`80
00003P3oool200000080oooo0P0000040?ooo`8000004@3oool2000000P0oooo0P00000@0?ooo`@0
00001@3oool200000140oooo0P0000040?ooo`8000005`3oool2000000@0oooo0P00000@0?ooo`80
0000203oool2000000l0oooo100000060?ooo`8000001@3oool200000<D0oooo0P000?l70?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=C0?ooo`80
00001@3oool2000000@0oooo0P0000020?ooo`8000003P3oool200000080oooo0P0000040?ooo`80
00004@3oool2000000@0oooo0P0000020?ooo`8000004@3oool3000000D0oooo0P00000A0?ooo`80
0000103oool2000001<0oooo0P0000020?ooo`800000103oool200000100oooo0P0000040?ooo`80
00000P3oool200000100oooo0`0000060?ooo`8000001@3oool200000<@0oooo00<0003o0?ooo`00
0?l01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<cE03oool2000000D0oooo0P0000040?ooo`@00000403oool4000000@0oooo0P00000C0?ooo`80
0000103oool4000001<0oooo0P0000040?ooo`8000004`3oool2000000<0oooo1P00000@0?ooo`@0
0000103oool200000180oooo0P0000030?ooo`H000004@3oool2000000D0oooo0P0000050?ooo`80
0000a03oool010000?l0oooo0?ooo`000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo40oooo00D0003o0?ooo`3oool0oooo0000o`07
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?oooo00oooo1P000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?oooo40oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c>`3oool6000000<0oooo100000050?ooo`800000o`3ooonV0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<cd0oooo0P0000040?ooo`8000000P3oool2000000@0oooo0P00003o0?ooojH0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c?@3oool2000000@0oooo0P0000020?ooo`800000o`3ooon/0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<cd0oooo0P0000040?ooo`8000000P3oool2000000@0oooo0P00003o0?ooojH0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c?@3oool2000000@0oooo0P0000020?ooo`800000103oool200000?l0ooooYP3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<k0?ooo`@00000103oool200000080oooo0P0000040?ooo`800000o`3ooonU
0?ooo`80003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c?03oool3000000@0oooo0P0000020?ooo`800000103oool200000?l0ooooY03oool0
0`000?l0oooo0000o`070?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<m0?ooo`8000001@3oool4000000D0oooo0P00003o0?oooj<0oooo00@0003o
0?ooo`3oool0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3ooooa0?ooo`050000o`3oool0oooo0?ooo`000?l01`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`H0003o
1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT6
09VIV@40iNGU0@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3oool00?l0
ooooo`3oool<0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 68},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "find the value of an option for a complete notebook "]},
          {Cell[TextData[{
              StyleBox["Options[NotebookSelection[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["find the value for the current selection "]},
          {Cell[TextData[{
              StyleBox["SetOptions[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["->", "MR"],
              StyleBox["value", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "set the value of an option for a complete notebook "]},
          {Cell[TextData[{
              StyleBox["SetOptions[NotebookSelection[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["->", "MR"],
              StyleBox["value", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["set the value for the current selection "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.11.3"],

Cell["\<\
Finding and setting options for whole notebooks and for the current \
selection. \
\>", "Caption",
  CellTags->"S2.11.3"],

Cell["Make the current selection be a complete cell. ", "MathCaption",
  CellTags->{"S2.11.3", "3.48"}],

Cell[CellGroupData[{

Cell["SelectionMove[nb, All, Cell]", "Input",
  CellLabel->"In[32]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000A2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo80
oooo1@0000060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?oooo40oooo1`0000050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo40oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?oooo40oooo1@0000000`3oool000000?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=:0?ooo`8000001@3oool200000200
oooo0P00000C0?ooo`8000008@3oool2000001<0oooo0P00000Q0?ooo`8000004P3oool200000240
oooo0P0000050?ooo`800000c@3oool5000000030?ooo`000000oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dT0oooo0P0000050?ooo`80
00003@3oool2000001<0oooo0P0000040?ooo`8000002`3oool2000000d0oooo0P00000D0?ooo`80
0000103oool2000000/0oooo0P00000=0?ooo`800000503oool2000000@0oooo0P00000:0?ooo`80
00003@3oool2000001@0oooo0P0000050?ooo`800000c03oool5000000030?ooo`000000oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c40
oooo1P00000B0?ooo`8000001@3oool2000000@0oooo1P0000040?ooo`8000002@3oool4000000D0
oooo0P0000050?ooo`8000002P3oool2000000D0oooo100000050?ooo`8000002`3oool4000000@0
oooo0P0000050?ooo`8000002P3oool2000000D0oooo100000050?ooo`8000002@3oool6000000@0
oooo0P0000050?ooo`8000002@3oool2000000H0oooo0P0000060?ooo`8000002@3oool6000000@0
oooo0P0000050?ooo`800000c03oool5000000030?ooo`000000oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c00oooo0P0000020?ooo`80
00001`3oool5000000L0oooo0P0000050?ooo`800000103oool200000080oooo0P00000>0?ooo`80
00000P3oool2000000@0oooo0P00000A0?ooo`800000103oool200000080oooo0P00000B0?ooo`80
00001@3oool200000140oooo0P0000040?ooo`8000000P3oool2000000l0oooo0P0000020?ooo`80
0000103oool200000100oooo0P0000060?ooo`8000004`3oool2000000H0oooo0P0000050?ooo`80
0000c03oool5000000030?ooo`000000oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c00oooo0P0000020?ooo`8000004P3oool2000000D0
oooo0P0000060?ooo`8000004@3oool200000080oooo0P0000050?ooo`8000003`3oool2000000T0
oooo0P00000B0?ooo`8000001P3oool2000000l0oooo0P0000090?ooo`800000403oool2000000P0
oooo0P00000>0?ooo`8000001`3oool2000001<0oooo0P0000070?ooo`8000001@3oool200000</0
oooo1@0000000`3oool000000?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<a0?ooo`D000001`3oool5000000L0oooo0P0000050?ooo`80
00001P3oool200000100oooo0P0000020?ooo`800000103oool200000140oooo0P0000080?ooo`80
00003`3oool6000000@0oooo0P00000A0?ooo`800000103oool200000080oooo0P00000A0?ooo`80
00001P3oool200000100oooo0P0000070?ooo`8000004P3oool2000000H0oooo0P0000050?ooo`80
0000c03oool5000000030?ooo`000000oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c00oooo0P0000020?ooo`8000004`3oool2000000D0
oooo0P0000070?ooo`800000403oool4000000D0oooo0P00000A0?ooo`8000001P3oool300000100
oooo0P0000000`3oool00000000000050?ooo`8000004@3oool2000000@0oooo1@00000C0?ooo`80
00001@3oool200000100oooo0P0000070?ooo`8000004P3oool2000000H0oooo0P0000050?ooo`80
0000c03oool5000000030?ooo`000000oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c40oooo1000000D0?ooo`8000001@3oool2000000P0
oooo0P00000>0?ooo`8000000P3oool2000000@0oooo0P00000A0?ooo`800000203oool200000100
oooo100000050?ooo`8000004@3oool2000000@0oooo0P00000G0?ooo`800000103oool200000100
oooo0P0000080?ooo`8000003`3oool4000000H0oooo0P0000050?ooo`800000c03oool500000003
0?ooo`000000oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<dT0oooo0P0000050?ooo`800000103oool200000080oooo0P00000>0?ooo`80
00000P3oool2000000@0oooo0P00000A0?ooo`800000103oool200000080oooo0P00000A0?ooo`<0
00001@3oool200000140oooo0P0000040?ooo`8000004`3oool200000080oooo0P0000040?ooo`80
0000403oool2000000@0oooo0P0000020?ooo`800000403oool3000000H0oooo0P0000050?ooo`80
0000c03oool400000080oooo00<000000?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cBP3oool2000000D0oooo0P0000040?ooo`@0
0000403oool4000000@0oooo0P00000C0?ooo`800000103oool4000001<0oooo0P0000040?ooo`80
00004`3oool2000000<0oooo1P00000@0?ooo`@00000103oool200000180oooo0P0000030?ooo`H0
00004@3oool2000000D0oooo0P0000050?ooo`800000c@3oool3000000040?ooo`000000oooo0000
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooool@3oool2000000050?ooo`00000000000?ooo`0000001@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooa0?ooo`030000003oool0
00000080000000<0oooo0000003oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000003oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool@3oool7
000000D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0oooolP3oool5000000H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooob0?ooo`D0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool0
0`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<@3oool6000000<0oooo10000006
0?ooo`800000o`3ooon`0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c<0oooo0P0000040?ooo`8000000P3oool2
000000D0oooo0P00003o0?oook00oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<`3oool2000000@0oooo0P000002
0?ooo`800000o`3ooong0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c<0oooo0P0000040?ooo`8000000P3oool2
000000D0oooo0P00003o0?oook00oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<`3oool2000000@0oooo0P000002
0?ooo`8000001@3oool200000?l0oooo/03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<a0?ooo`@00000103oool2
00000080oooo0P0000050?ooo`800000o`3ooon`0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c80oooo0`000004
0?ooo`8000000P3oool2000000D0oooo0P00003o0?ooojl0oooo0P000?l60?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<c0?ooo`8000001@3oool4
000000H0oooo0P00003o0?ooojh0oooo00<0003o0?ooo`000?l01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooc0?ooo`040000o`3oool0
oooo0000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooolP3oool01@000?l0oooo0?ooo`3oool0003o00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool@3oool60000o`H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT1
0>GUi@40<c<c0@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3UiND80>GUi@40oooo003o0?ooool0
oooo303oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 68},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell["Put a frame around the cell that is the current selection. ", \
"MathCaption",
  CellTags->{"S2.11.3", "3.49"}],

Cell[CellGroupData[{

Cell["SetOptions[NotebookSelection[nb], CellFrame->True]", "Input",
  CellLabel->"In[33]:= ",
  CellTags->"S2.11.3"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000FB000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c603ooooo000006/00000J`3oool5000000X0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aP0oooo00<000000?ooo`3o
ool0o`3ooomW0?ooo`030000003oool0oooo06P0oooo1`0000090?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<H0?ooo`030000003oool0oooo0?l0
ooooI`3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c603oool00`000000oooo0?ooo`3o0?ooofL0oooo00<000000?ooo`3oool0J03oool500000003
0?ooo`000000oooo00P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<aP0oooo00<000000?ooo`3oool0o`3ooomW0?ooo`030000003oool0oooo06P0
oooo1@0000000`3oool000000?ooo`080?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<H0?ooo`030000003oool0oooo0?l0ooooI`3oool00`000000
oooo0?ooo`1X0?ooo`D0000000<0oooo0000003oool0203oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c603oool00`000000oooo0?ooo`3o0?ooofL0
oooo00<000000?ooo`3oool0J03oool5000000030?ooo`000000oooo00P0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aP0oooo00<000000?ooo`3o
ool0o`3ooomW0?ooo`030000003oool0oooo06P0oooo1@0000000`3oool000000?ooo`080?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<H0?ooo`03
0000003oool0oooo0?l0ooooI`3oool00`000000oooo0?ooo`1X0?ooo`D0000000<0oooo0000003o
ool0203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c603oool00`000000oooo0?ooo`3o0?ooofL0oooo00<000000?ooo`3oool0J03oool500000003
0?ooo`000000oooo00P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<aP0oooo00<000000?ooo`3oool0803oool2000000D0oooo0P00000Q0?ooo`80
00004P3oool200000240oooo0P00000C0?ooo`8000008@3oool2000001<0oooo0P00000P0?ooo`80
00001@3oool2000006d0oooo00<000000?ooo`3oool0J03oool5000000030?ooo`000000oooo00P0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aP0
oooo00<000000?ooo`3oool07`3oool2000000D0oooo0P00000=0?ooo`800000503oool2000000@0
oooo0P00000:0?ooo`8000003@3oool2000001@0oooo0P0000040?ooo`8000002`3oool2000000d0
oooo0P00000D0?ooo`800000103oool2000000/0oooo0P00000=0?ooo`8000004`3oool2000000D0
oooo0P00001/0?ooo`030000003oool0oooo06P0oooo1@0000000`3oool000000?ooo`080?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<H0?ooo`03
0000003oool0oooo00L0oooo1P00000B0?ooo`8000001@3oool2000000@0oooo1P0000040?ooo`80
00002P3oool4000000D0oooo0P0000050?ooo`8000002@3oool2000000D0oooo100000050?ooo`80
00002`3oool4000000@0oooo0P0000050?ooo`8000002P3oool2000000D0oooo100000050?ooo`80
00002@3oool6000000@0oooo0P0000050?ooo`8000002P3oool2000000H0oooo0P0000060?ooo`80
0000203oool6000000@0oooo0P0000050?ooo`800000K03oool00`000000oooo0?ooo`1X0?ooo`D0
000000<0oooo0000003oool0203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c603oool00`000000oooo0?ooo`060?ooo`8000000P3oool2000000L0
oooo1@0000070?ooo`8000001@3oool2000000@0oooo0P0000020?ooo`8000003`3oool200000080
oooo0P0000040?ooo`800000403oool2000000@0oooo0P0000020?ooo`8000004P3oool2000000D0
oooo0P00000A0?ooo`800000103oool200000080oooo0P00000?0?ooo`8000000P3oool2000000@0
oooo0P00000A0?ooo`8000001P3oool200000180oooo0P0000060?ooo`8000001@3oool2000006`0
oooo00<000000?ooo`3oool0J03oool5000000030?ooo`000000oooo00P0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aP0oooo00<000000?ooo`3o
ool01P3oool200000080oooo0P00000B0?ooo`8000001@3oool2000000H0oooo0P00000B0?ooo`80
00000P3oool2000000D0oooo0P00000>0?ooo`8000002@3oool200000180oooo0P0000060?ooo`80
00003`3oool2000000T0oooo0P00000@0?ooo`800000203oool2000000l0oooo0P0000070?ooo`80
00004P3oool2000000L0oooo0P0000050?ooo`800000J`3oool00`000000oooo0?ooo`1X0?ooo`D0
000000<0oooo0000003oool0203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c603oool00`000000oooo0?ooo`070?ooo`D000001`3oool5000000L0
oooo0P0000050?ooo`8000001P3oool200000140oooo0P0000020?ooo`800000103oool200000100
oooo0P0000080?ooo`8000003`3oool6000000@0oooo0P00000A0?ooo`800000103oool200000080
oooo0P00000A0?ooo`8000001P3oool200000140oooo0P0000070?ooo`8000004@3oool2000000H0
oooo0P0000050?ooo`800000K03oool00`000000oooo0?ooo`1X0?ooo`D0000000<0oooo0000003o
ool0203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c603oool00`000000oooo0?ooo`060?ooo`8000000P3oool2000001<0oooo0P0000050?ooo`80
00001`3oool200000140oooo100000050?ooo`800000403oool2000000H0oooo0`00000@0?ooo`80
000000<0oooo0000000000001@3oool200000140oooo0P0000040?ooo`D000004`3oool2000000D0
oooo0P00000A0?ooo`8000001`3oool200000140oooo0P0000060?ooo`8000001@3oool2000006`0
oooo00<000000?ooo`3oool0J03oool5000000030?ooo`000000oooo00P0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aP0oooo00<000000?ooo`3o
ool01`3oool4000001@0oooo0P0000050?ooo`800000203oool2000000l0oooo0P0000020?ooo`80
0000103oool200000100oooo0P0000080?ooo`800000403oool4000000D0oooo0P00000A0?ooo`80
0000103oool2000001L0oooo0P0000040?ooo`8000004@3oool2000000P0oooo0P00000>0?ooo`@0
00001P3oool2000000D0oooo0P00001/0?ooo`030000003oool0oooo06P0oooo1@0000000`3oool0
00000?ooo`080?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<H0?ooo`030000003oool0oooo01l0oooo0P0000050?ooo`800000103oool200000080
oooo0P00000?0?ooo`8000000P3oool2000000@0oooo0P00000@0?ooo`800000103oool200000080
oooo0P00000A0?ooo`<000001@3oool200000140oooo0P0000040?ooo`8000004`3oool200000080
oooo0P0000040?ooo`8000004@3oool2000000@0oooo0P0000020?ooo`8000003`3oool3000000H0
oooo0P0000050?ooo`800000K03oool00`000000oooo0?ooo`1X0?ooo`D0000000<0oooo0000003o
ool0203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c603oool00`000000oooo0?ooo`0P0?ooo`8000001@3oool2000000@0oooo1000000A0?ooo`@0
0000103oool200000180oooo0P0000040?ooo`@000004`3oool2000000@0oooo0P00000C0?ooo`80
00000`3oool600000100oooo100000040?ooo`8000004`3oool2000000<0oooo1P00000@0?ooo`80
00001@3oool2000000D0oooo0P00001]0?ooo`030000003oool0oooo06P0oooo1@0000000`3oool0
00000?ooo`080?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<H0?ooo`030000003oool0oooo0?l0ooooI`3oool00`000000oooo0?ooo`1X0?ooo`D0
000000<0oooo0000003oool0203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c603oool00`000000oooo0?ooo`3o0?ooofL0oooo00<000000?ooo`3o
ool0J03oool5000000030?ooo`000000oooo00P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aP0oooo00<000000?ooo`3oool0o`3ooomW0?ooo`03
0000003oool0oooo06P0oooo1@0000000`3oool000000?ooo`080?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<H0?ooo`030000003oool0oooo0?l0
ooooI`3oool00`000000oooo0?ooo`1X0?ooo`D0000000<0oooo0000003oool0203oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c603oool00`000000
oooo0?ooo`3o0?ooofL0oooo00<000000?ooo`3oool0J03oool5000000030?ooo`000000oooo00P0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aP0
oooo00<000000?ooo`3oool0o`3ooomW0?ooo`030000003oool0oooo06P0oooo1@0000000`3oool0
00000?ooo`080?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<H0?ooo`030000003oool0oooo0?l0ooooI`3oool00`000000oooo0?ooo`1X0?ooo`D0
000000<0oooo0000003oool0203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c603oool00`000000oooo0?ooo`3o0?ooofL0oooo00<000000?ooo`3o
ool0J03oool5000000030?ooo`000000oooo00P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aP0oooo00<000000?ooo`3oool0o`3ooomW0?ooo`03
0000003oool0oooo06P0oooo100000020?ooo`030000003oool0oooo00L0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aP0ooooo`00001[000006X0
oooo0`000000103oool000000?ooo`0000090?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooond0oooo0P0000001@3oool000000000003oool0
000000T0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooook@3oool00`000000oooo00000002000000030?ooo`000000oooo00P0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool`3oool0
0`000000oooo0?ooo`070?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooond0oooo1`0000090?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonh0oooo1@00000:0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooookP3oool50000o`X0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooolP3oool0
0`000?l0oooo0?ooo`080?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<J0?ooo`H000000`3oool4000000D0oooo0P00003o0?oool@0oooo00<0003o
0?ooo`3oool0203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c703oool2000000@0oooo0P0000020?ooo`800000103oool200000?l0ooooa03oool0
0`000?l0oooo0?ooo`080?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<L0?ooo`800000103oool200000080oooo0P00003o0?ooolX0oooo00<0003o
0?ooo`3oool0203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c703oool2000000@0oooo0P0000020?ooo`800000103oool200000?l0ooooa03oool0
0`000?l0oooo0?ooo`080?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<L0?ooo`800000103oool200000080oooo0P0000040?ooo`800000o`3oooo4
0?ooo`030000o`3oool0oooo00P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<aX0oooo100000040?ooo`8000000P3oool2000000@0oooo0P00003o
0?oool@0oooo00<0003o0?ooo`3oool0203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c6`3oool3000000@0oooo0P0000020?ooo`800000103oool2
00000?l0ooooa03oool00`000?l0oooo0?ooo`080?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<L0?ooo`8000001@3oool4000000D0oooo0P00003o
0?oool@0oooo00<0003o0?ooo`3oool0203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooa0?ooo`80003o2P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`030000o`3oool0
003o00X0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooook`3oool010000?l0oooo0?ooo`000?l:0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonh0oooo00D0003o0?ooo`3oool0oooo
0000o`0:0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooond0oooo1P000?l:0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GU
i@L0iNGU0@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 89},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NotebookCreate[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["create a new notebook "]},
          {Cell[TextData[{
              StyleBox["NotebookCreate[", "MR"],
              StyleBox["options", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["create a notebook with specified options "]},
          {Cell[TextData[{
              StyleBox["NotebookOpen[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["open an existing notebook "]},
          {Cell[TextData[{
              StyleBox["NotebookOpen[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["options", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["open a notebook with specified options "]},
          {Cell[TextData[{
              StyleBox["SetSelectedNotebook[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["make the specified notebook the selected one "]},
          {Cell[TextData[{
              StyleBox["NotebookPrint[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["send a notebook to your printer "]},
          {Cell[TextData[{
              StyleBox["NotebookPrint[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["send a PostScript version of a notebook to a file "]},
          {Cell[TextData[{
              StyleBox["NotebookPrint[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"!", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
send a PostScript version of a notebook to an external \
command \
\>"]},
          {Cell[TextData[{
              StyleBox["NotebookSave[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["save the current version of a notebook in a file "]},
          {Cell[TextData[{
              StyleBox["NotebookSave[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[
            "save the notebook in a file with the specified name "]},
          {Cell[TextData[{
              StyleBox["NotebookClose[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["close a notebook "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.3"],

Cell["Operations on whole notebooks. ", "Caption",
  CellTags->"S2.11.3"],

Cell[TextData[{
  "If you call ",
  StyleBox["NotebookCreate[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " a new empty notebook will appear on your screen.   "
}], "Text",
  CellTags->{"S2.11.3", "3.50"}],

Cell[TextData[{
  "By executing commands like ",
  StyleBox["SetSelectedNotebook", "MR"],
  " and ",
  StyleBox["NotebookOpen", "MR"],
  ", you tell the ",
  StyleBox["Mathematica", "TI"],
  " front end to change the windows you see. Sometimes you may want to \
manipulate a notebook without ever having it displayed on the screen. You can \
do this by using the option setting ",
  StyleBox["Visible->False", "MR"],
  " in ",
  StyleBox["NotebookOpen", "MR"],
  " or ",
  StyleBox["NotebookCreate", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.11.3", "3.51"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.11.4 Manipulating the Front End from the Kernel", "Subsection",
  CellTags->{"S2.11.4", "4.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$FrontEnd", "MR"],
              " "
            }]], Cell["the front end currently in use "]},
          {Cell[TextData[{
              StyleBox["Options[$FrontEnd,", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the setting for a global option in the front end "]},
          {Cell[TextData[{
              StyleBox["AbsoluteOptions[$FrontEnd,", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the absolute setting for an option "]},
          {Cell[TextData[{
              StyleBox["SetOptions[$FrontEnd,", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["->", "MR"],
              StyleBox["value", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["reset an option in the front end "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.4"],

Cell["Manipulating global options in the front end. ", "Caption",
  CellTags->"S2.11.4"],

Cell[TextData[{
  "Just like cells and notebooks, the complete ",
  StyleBox["Mathematica", "TI"],
  " front end has various options, which you can look at and manipulate from \
the kernel.  "
}], "Text",
  CellTags->{"S2.11.4", "4.2"}],

Cell["\<\
This gives the object corresponding to the front end currently in \
use. \
\>", "MathCaption",
  CellTags->{"S2.11.4", "4.3"}],

Cell[CellGroupData[{

Cell["$FrontEnd", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.11.4"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        FrontEndObject  \[SkeletonIndicator]\),
      FrontEndObject[ 
        LinkObject[ "ParentLink", 1, 1]],
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.11.4"]
}, Open  ]],

Cell["\<\
This gives the current directory used by the front end for notebook \
files. \
\>", "MathCaption",
  CellTags->{"S2.11.4", "4.4"}],

Cell[CellGroupData[{

Cell["Options[$FrontEnd, NotebookDirectory]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.11.4"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "NotebookDirectory",
  Cell[BoxData[
      \(TraditionalForm\` \[RuleDelayed] \)], "InlineFormula"],
  "$InstallationDirectory",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Output",
  CellLabel->"Out[2]=",
  CellTags->"S2.11.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["NotebookDirectory", "MR"],
              " "
            }]], Cell["(system dependent) "], Cell[
            "the default directory for opening and saving notebook files "]},
          {Cell[TextData[{
              StyleBox["NotebookPath", "MR"],
              " "
            }]], Cell["(system dependent) "], Cell[
            "the path to search when trying to open notebooks "]},
          {Cell[TextData[{
              StyleBox["Language", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["\"English\"", "MR"],
              " "
            }]], Cell["default language for text "]},
          {Cell[TextData[{
              StyleBox["MessageOptions", "MR"],
              " "
            }]], Cell["(list of settings) "], Cell[
            "how to handle various help and warning messages "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.11.4"],

Cell[TextData[{
  "A few global options for the ",
  StyleBox["Mathematica", "SO"],
  " front end. "
}], "Caption",
  CellTags->"S2.11.4"],

Cell[TextData[{
  "By using ",
  StyleBox["NotebookWrite", "MR"],
  " you can effectively input to the front end any ordinary text that you can \
enter on the keyboard. ",
  StyleBox["FrontEndTokenExecute", "MR"],
  " allows you to send from the kernel any command that the front end can \
execute. These commands include both menu items and control sequences. "
}], "Text",
  CellTags->{"S2.11.4", "4.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FrontEndTokenExecute[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["execute a named command in the front end "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.4"],

Cell["Executing a named command in the front end. ", "Caption",
  CellTags->"S2.11.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"Indent\"", "MR"],
              " "
            }]], Cell["indent all selected lines by one tab "]},
          {Cell[TextData[{
              StyleBox["\"NotebookStatisticsDialog\"", "MR"],
              " "
            }]], Cell["display statistics about the current notebook "]},
          {Cell[TextData[{
              StyleBox["\"OpenCloseGroup\"", "MR"],
              " "
            }]], Cell["toggle a cell group between open and closed "]},
          {Cell[TextData[{
              StyleBox["\"CellSplit\"", "MR"],
              " "
            }]], Cell[
            "split a cell in two at the current insertion point "]},
          {Cell[TextData[{
              StyleBox["\"DuplicatePreviousInput\"", "MR"],
              " "
            }]], 
            Cell["\<\
create a new cell which is a duplicate of the nearest \
input cell above \
\>"]},
          {Cell[TextData[{
              StyleBox["\"FindDialog\"", "MR"],
              " "
            }]], Cell["bring up the find dialog "]},
          {Cell[TextData[{
              StyleBox["\"ColorSelectorDialog\"", "MR"],
              " "
            }]], Cell["bring up the color selector dialog "]},
          {Cell[TextData[{
              StyleBox["\"GraphicsAlign\"", "MR"],
              " "
            }]], Cell["align selected graphics "]},
          {Cell[TextData[{
              StyleBox["\"CompleteSelection\"", "MR"],
              " "
            }]], Cell[
            "complete the command name that is the current selection "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.4"],

Cell["\<\
A few named commands that can be given to the front end. These \
commands usually correspond to menu items. \
\>", "Caption",
  CellTags->"S2.11.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.11.5 Advanced Topic: Executing Notebook Commands Directly in the \
Front End\
\>", "Subsection",
  CellTags->{"S2.11.5", "5.1"}],

Cell[TextData[{
  "When you execute a command like ",
  StyleBox["NotebookWrite[", "MR"],
  StyleBox["obj", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["data", "TI"],
  StyleBox["]", "MR"],
  " the actual operation of inserting data into your notebook is performed in \
the front end. Normally, however, the kernel is needed in order to evaluate \
the original command, and to construct the appropriate request to send to the \
front end. But it turns out that the front end is set up to execute a limited \
collection of commands directly, without ever involving the kernel. "
}], "Text",
  CellTags->{"S2.11.5", "5.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NotebookWrite[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["data", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "version of ",
              StyleBox["NotebookWrite", "MR"],
              " to be executed in the kernel "
            }]]},
          {Cell[TextData[{
              StyleBox["FrontEnd`NotebookWrite[", "MR"],
              StyleBox["obj", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["data", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "version of ",
              StyleBox["NotebookWrite", "MR"],
              " to be executed directly in the front end "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.5"],

Cell["Distinguishing kernel and front end versions of commands. ", "Caption",
  CellTags->"S2.11.5"],

Cell[TextData[{
  "The basic way that ",
  StyleBox["Mathematica", "TI"],
  " distinguishes between commands to be executed in the kernel and to be \
executed directly in the front end is by using contexts. The kernel commands \
are in the usual ",
  StyleBox["System`", "MR"],
  " context, but the front end commands are in the ",
  StyleBox["FrontEnd`", "MR"],
  " context. "
}], "Text",
  CellTags->{"S2.11.5", "5.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FrontEndExecute[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "send ",
              StyleBox["expr", "TI"],
              " to be executed in the front end "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.5"],

Cell["Sending an expression to be executed in the front end. ", "Caption",
  CellTags->"S2.11.5"],

Cell["Here is a blank notebook. ", "MathCaption",
  CellTags->{"S2.11.5", "5.4"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008;0000:b000`400?l00000o`00003oo`3no_ko
0?knoPd0o_kn00000`0c<c<000000000003o00000?l000002@0000010?knoP0000<0k^k^03<c<`0c
<c<0o`0c<c?o03<c<`P0<c<c0@0000010?knoP0000<0k^k^09VIV@2IVIT0o`2IVIWo09VIV@L0VIVI
0@0c<c<100000040o_kn00000`3^k^h0VIVI09VIV@3o09VIVOl0VIVI1`2IVIT103<c<`4000000@3n
o_h000030>k^kP2IVIT0VIVI0?l0VIVIo`2IVIT709VIV@40<c<c0@0000010?knoP0000@0k^k^09VI
V@2IVIT0VIVIo`3^k^ko0>k^kP80k^k^102IVIT103<c<`4000000@3no_h000040>k^kP2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0VIVI0080VIVI0@0c<c<100000040o_kn0000103^
k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3^k^h0VIVI09VIV@0209VIV@40<c<c0@000001
0?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT1
03<c<`4000000@3no_h000040>k^kP2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0
VIVI0080VIVI0@0c<c<100000040o_kn0000103^k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
0`3^k^h0VIVI09VIV@0209VIV@40<c<c0@0000010?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT103<c<`4000000@3no_h000040>k^kP2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0VIVI0080VIVI0@0c<c<100000040o_kn0000103^
k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3^k^h0VIVI09VIV@0209VIV@40<c<c0@000001
0?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT1
03<c<`4000000@3no_h000040>k^kP2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0
VIVI0080VIVI0@0c<c<100000040o_kn0000103^k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
0`3^k^h0VIVI09VIV@0209VIV@40<c<c0@0000010?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT103<c<`4000000@3no_h000040>k^kP2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0VIVI0080VIVI0@0c<c<100000040o_kn0000103^
k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3^k^h0VIVI09VIV@0209VIV@40<c<c0@000001
0?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT1
03<c<`4000000@3no_h000040>k^kP2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0
VIVI0080VIVI0@0c<c<100000040o_kn0000103^k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
0`3^k^h0VIVI09VIV@0209VIV@40<c<c0@0000010?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT103<c<`4000000@3no_h000040>k^kP2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0VIVI0080VIVI0@0c<c<100000040o_kn0000103^
k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3^k^h0VIVI09VIV@0209VIV@40<c<c0@000001
0?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT1
03<c<`4000000@3no_h000040>k^kP2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0
VIVI0080VIVI0@0c<c<100000040o_kn0000103^k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
0`3^k^h0VIVI09VIV@0209VIV@40<c<c0@0000010?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT103<c<`4000000@3no_h000040>k^kP2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0VIVI0080VIVI0@0c<c<100000040o_kn0000103^
k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3^k^h0VIVI09VIV@0209VIV@40<c<c0@000001
0?knoP0000@0k^k^09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0k^k^09VIV@2IVIT00P2IVIT1
03<c<`4000000@3no_h000040>k^kP2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>k^kP2IVIT0
VIVI0080VIVI0@0c<c<100000040o_kn0000103^k^h0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
0`3^k^h0VIVI09VIV@0209VIV@40<c<c0@0000010?knoP0000@0k^k^09VIV@2IVIT0VIVIo`0c<c?o
03<c<`40<c<c00<0k^k^09VIV@2IVIT00P2IVIT103<c<`4000000@3no_h000040>k^kP2IVIT0VIVI
09VIVOl0<c<co`0c<c<103<c<`030>k^kP2IVIT0VIVI0080VIVI0@0c<c<100000040o_kn00000`3^
k^h0VIVI09VIV@3o09VIVOl0VIVI1`2IVIT103<c<`4000000@3no_h000030>k^kP2IVIT0VIVI0?l0
VIVIo`2IVIT709VIV@40<c<c0@0000010?knoP0000<0k^k^09VIV@2IVIT0o`2IVIWo09VIV@L0VIVI
0@0c<c<100000040o_kn003o0>k^k_l0k^k^2`3^k^h100000040o_kn003o0?ooool0oooo303oool1
0?knoP00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{523, 43},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.5"],

Cell["This uses kernel commands to write data into the notebook. ", \
"MathCaption",
  CellTags->{"S2.11.5", "5.5"}],

Cell[CellGroupData[{

Cell["NotebookWrite[SelectedNotebook[ ], \"x + y + z\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.11.5"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooob0?ooo`D0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=:0?ooo`@00000o`3ooonX0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d/0oooo0P00003o0?ooojT0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c=@3oool6000000L0oooo00<000000?ooo`3oool01`3oool2000000T0
oooo00<000000?ooo`3oool01@3oool600000?l0ooooT@3oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<f0?ooo`@0
0000203oool00`000000oooo0?ooo`070?ooo`8000002@3oool00`000000oooo0?ooo`050?ooo`80
00000P3oool200000?l0ooooT@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`8000001`3oool5000000H0
oooo100000060?ooo`D000001P3oool200000?l0ooooU03oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`80
00002@3oool00`000000oooo0?ooo`060?ooo`@00000203oool00`000000oooo0?ooo`070?ooo`80
0000o`3ooonC0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo100000080?ooo`030000003oool0oooo00D0
oooo0P0000020?ooo`8000001`3oool00`000000oooo0?ooo`050?ooo`80000000<0oooo00000000
0000o`3ooonB0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cD0oooo1P00000>0?ooo`P000003P3oool600000?l0
ooooT03oool20000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0000o`060?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo<0oooo00@0003o0?ooo`3o
ool0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooob0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooa0?ooo`H0003o1P3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VI
VOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT10>GUi@40<c<c0@3oool000030?ooo`3U
iND0iNGU0?l0iNGUo`3UiND80>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.5"]
}, Open  ]],

Cell["In the kernel, these commands do absolutely nothing. ", "MathCaption",
  CellTags->{"S2.11.5", "5.6"}],

Cell[CellGroupData[{

Cell["\<\
FrontEnd`NotebookWrite[FrontEnd`SelectedNotebook[ ], \"a + b + c + \
d\"]\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.11.5"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooob0?ooo`D0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=:0?ooo`@00000o`3ooonX0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d/0oooo0P00003o0?ooojT0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c=@3oool6000000L0oooo00<000000?ooo`3oool01`3oool2000000T0
oooo00<000000?ooo`3oool01@3oool600000?l0ooooT@3oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<f0?ooo`@0
0000203oool00`000000oooo0?ooo`070?ooo`8000002@3oool00`000000oooo0?ooo`050?ooo`80
00000P3oool200000?l0ooooT@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`8000001`3oool5000000H0
oooo100000060?ooo`D000001P3oool200000?l0ooooU03oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`80
00002@3oool00`000000oooo0?ooo`060?ooo`@00000203oool00`000000oooo0?ooo`070?ooo`80
0000o`3ooonC0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo100000080?ooo`030000003oool0oooo00D0
oooo0P0000020?ooo`8000001`3oool00`000000oooo0?ooo`050?ooo`80000000<0oooo00000000
0000o`3ooonB0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cD0oooo1P00000>0?ooo`P000003P3oool600000?l0
ooooT03oool20000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0000o`060?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo<0oooo00@0003o0?ooo`3o
ool0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooob0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooa0?ooo`H0003o1P3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VI
VOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT10>GUi@40<c<c0@3oool000030?ooo`3U
iND0iNGU0?l0iNGUo`3UiND80>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.5"]
}, Open  ]],

Cell["\<\
If they are sent to the front end, however, they cause data to be \
written into the notebook. \
\>", "MathCaption",
  CellTags->{"S2.11.5", "5.7"}],

Cell[CellGroupData[{

Cell["FrontEndExecute[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.11.5"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000A2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<803<c<`80oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c1`0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@D0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0`2IVIT203<c
<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooool03oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3ooood0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<h0?ooo`H0
00001`3oool00`000000oooo0?ooo`040?ooo`H00000203oool00`000000oooo0?ooo`060?ooo`@0
0000203oool00`000000oooo0?ooo`060?ooo`H00000o`3ooomf0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0
oooo0P0000020?ooo`800000203oool00`000000oooo0?ooo`050?ooo`8000000P3oool2000000L0
oooo00<000000?ooo`3oool01@3oool200000080oooo0P0000070?ooo`030000003oool0oooo00D0
oooo0P0000020?ooo`800000o`3ooomg0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo0P0000020?ooo`80
00001P3oool5000000D0oooo0P0000020?ooo`8000001@3oool5000000D0oooo0P0000090?ooo`D0
00001@3oool200000080oooo0P00003o0?ooogL0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>03oool5000000P0
oooo00<000000?ooo`3oool01@3oool200000080oooo0P0000070?ooo`030000003oool0oooo00D0
oooo0P00000;0?ooo`030000003oool0oooo00D0oooo0P0000020?ooo`800000o`3ooomg0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<cL0oooo0P0000020?ooo`800000203oool00`000000oooo0?ooo`050?ooo`80
00000P3oool2000000L0oooo00<000000?ooo`3oool01@3oool200000080oooo0P0000070?ooo`03
0000003oool0oooo00D0oooo0P0000020?ooo`800000o`3ooomg0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0
oooo1000000A0?ooo`D000004@3oool400000140oooo1@00003o0?ooogH0oooo0P000?l70?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c==0?ooo`80
0000;03oool200000?l0ooooM@3oool00`000?l0oooo0000o`070?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=<0?ooo`<00000:`3oool300000?l0
ooooM03oool010000?l0oooo0?ooo`000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo00oooo00D0003o0?ooo`3oool0oooo0000o`07
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooonl0oooo1P000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0
103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo03oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?oooo00oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<dd0oooo1000003o0?oooj<0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cCP3oool2
00000?l0ooooY03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<h0?ooo`H000001`3oool00`000000oooo0?ooo`07
0?ooo`8000002@3oool00`000000oooo0?ooo`050?ooo`H00000o`3ooon<0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<cT0oooo100000080?ooo`030000003oool0oooo00L0oooo0P0000090?ooo`030000003oool0
oooo00D0oooo0P0000020?ooo`800000o`3ooon<0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cX0oooo0P000007
0?ooo`D000001P3oool4000000H0oooo1@0000060?ooo`800000o`3ooon?0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<cX0oooo0P0000090?ooo`030000003oool0oooo00H0oooo100000080?ooo`030000003oool0
oooo00L0oooo0P00003o0?ooohh0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>@3oool4000000P0oooo00<00000
0?ooo`3oool01@3oool200000080oooo0P0000070?ooo`030000003oool0oooo00D0oooo0P000000
0`3oool000000000003o0?ooohd0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>03oool6000000h0oooo2000000>
0?ooo`H00000o`3ooon;0?ooo`80003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooob0?ooo`030000o`3oool0003o00L0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool@3oool0
10000?l0oooo0?ooo`000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?oooo00oooo00D0003o0?ooo`3oool0oooo0000o`070?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo
1P000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo03oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<oh0<c<c00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<oh0<c<c00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@D0VIVI00<0iNGU03<c<`3oool00@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3UiND70>GU
i@80oooo003o0?ooool0oooo303oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 68},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.5"]
}, Open  ]],

Cell["\<\
If you write sophisticated programs for manipulating notebooks, \
then you will have no choice but to execute these programs primarily in the \
kernel. But for the kinds of operations typically performed by simple \
buttons, you may find that it is possible to execute all the commands you \
need directly in the front end\[LongDash]without the kernel even needing to \
be running. \
\>", "Text",
  CellTags->{"S2.11.5", "5.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.11.6 Button Boxes and Active Elements in Notebooks", "Subsection",
  CellTags->{"S2.11.6", "6.1"}],

Cell[TextData[{
  "Within any cell in a notebook it is possible to set up ",
  StyleBox["ButtonBox", "MR"],
  " objects that perform actions whenever you click on them. ",
  StyleBox["ButtonBox", "MR"],
  " objects are the way that palette buttons, hyperlinks and other active \
elements are implemented in ",
  StyleBox["Mathematica", "TI"],
  " notebooks.   "
}], "Text",
  CellTags->{"S2.11.6", "6.2"}],

Cell[TextData[{
  "When you first enter a ",
  StyleBox["ButtonBox", "MR"],
  " object in a cell, it will behave just like any other expression, and by \
clicking on it you can select it, edit it, and so on. But if you set the ",
  StyleBox["Active", "MR"],
  " option for the cell, say by choosing the ",
  StyleBox["Cell Active", "SR"],
  " item in the ",
  StyleBox["Cell Properties", "SR"],
  " menu, then the ",
  StyleBox["ButtonBox", "MR"],
  " will become active, and when you click on it, it will perform whatever \
action you have specified for it.  "
}], "Text",
  CellTags->{"S2.11.6", "6.3"}],

Cell["Here is a button. ", "MathCaption",
  CellTags->{"S2.11.6", "6.4"}],

Cell[CellGroupData[{

Cell["\<\
ButtonBox[\"Expand[\[SelectionPlaceholder]]\"] // DisplayForm\
\>", \
"Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.11.6"],

Cell[BoxData[
    TagBox[
      ButtonBox[\(Expand[\[SelectionPlaceholder]]\)],
      DisplayForm]], "Output",
  CellLabel->"Out[1]//DisplayForm= ",
  CellTags->"S2.11.6"]
}, Open  ]],

Cell["\<\
When the button appears in an active cell, it will paste its \
contents whenever you click on it. \
\>", "MathCaption",
  CellTags->{"S2.11.6", "6.5"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000<R000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<803<c<`80oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c1`0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@D0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0`2IVIT203<c
<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo03oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo03oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo40oooo1@000?l60?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c<@3ooom<00000?l0ooooN03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<b0?ooodX0DU9B00<000000?ooo`3o
ool0o`3ooomf0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c80ooooB@3Fe]H00`1BDU8000000?ooo`3o0?ooogL0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c<P3ooom90=KFeP03059BDP000000oooo0?l0ooooM`3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<b0?oooa80e]KF1000000N0=KFeP@000002@3Fe]H4000000@0e]KF00<0DU9B0000003o
ool0o`3ooomg0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c80oooo4`3Fe]H2000001l0e]KF0P00000=0=KFeP80
0000103Fe]H00`1BDU8000000?ooo`3o0?ooogL0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<P3oool20=KFePL0
00000P3Fe]H600000080e]KF1@0000030=KFePH0000000<0e]KF0000000000001P0000000`3Fe]H0
000000000004000000<0e]KF0P0000040=KFePH000000`3Fe]H2000000@0e]KF00<0DU9B0000003o
ool0o`3ooomc0?ooo`050000o`3oool0003o0?ooo`000?l01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<P3oool30=KFeP8000000P3Fe]H20000
00<0e]KF100000030=KFeP8000000P3Fe]H2000000030=KFeP00000000000080e]KF0P0000030=KF
eP8000000P3Fe]H2000000030=KFeP00000000000080e]KF0P0000040=KFeP800000103Fe]H60000
00<0e]KF0P0000040=KFeP03059BDP000000oooo0?l0ooooL`3oool01@000?l0oooo0000o`3oool0
003o00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<c80oooo0`3Fe]H2000000P0e]KF0P0000040=KFeP8000000P3Fe]H2000000030=KFeP000000
00000080e]KF0P0000030=KFeP8000000P3Fe]H2000000030=KFeP00000000000080e]KF0P000004
0=KFeP800000103Fe]H6000000<0e]KF0P0000040=KFeP03059BDP000000oooo0?l0ooooL`3oool3
0000o`030?ooo`000?l0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<c80oooo0`3Fe]H4000000H0e]KF0P0000040=KFeP8000000P3Fe]H2
00000080e]KF1@0000030=KFeP8000000P3Fe]H2000000030=KFeP00000000000080e]KF0P000004
0=KFeP800000103Fe]H6000000<0e]KF0P0000040=KFeP03059BDP000000oooo0?l0ooooL`3oool0
1@000?l0oooo0000o`3oool0003o00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<c80oooo0`3Fe]H4000000D0e]KF100000030=KFeP8000000P3F
e]H2000000030=KFeP00000000000080e]KF0P0000030=KFeP<0000000@0e]KF000000000000e]KF
0P0000020=KFeP800000103Fe]H2000000@0e]KF1P0000030=KFeP800000103Fe]H00`1BDU800000
0?ooo`3o0?ooog@0oooo00@0003o0?ooo`3oool0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c
<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<P3oool30=KFeP@00000103Fe]H600000003
0=KFeP000000000000@000000`3Fe]H4000000<0e]KF1P0000030=KFePD00000103Fe]H2000000@0
e]KF1P0000030=KFeP800000103Fe]H00`1BDU8000000?ooo`3o0?ooogL0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c<P3oool30=KFeP8000000P3Fe]H2000002D0e]KF0P0000040=KFeP8000003@3Fe]H2000000@0
e]KF00<0DU9B0000003oool0o`3ooomf0?ooo`80003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c
<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<P3oool20=KFePL00000903Fe]H3000000@0
e]KF100000090=KFeP@00000103Fe]H00`1BDU8000000?ooo`3o0?ooogD0oooo00<0003o0?ooo`00
0?l01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c<P3ooom90=KFeP03059BDP000000oooo0?l0ooooM03oool010000?l0oooo0?ooo`000?l60?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<b0?oo
odT0e]KF00<0DU9B0000003oool0o`3ooomc0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool0
103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cO03oool0
0`000000oooo0?ooo`3o0?ooog40oooo1P000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0
103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo
03<c<oh0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo
03<c<oh0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@D0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0
o`2IVIWo09VIV@D0VIVI00<0iNGU03<c<`3oool00@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3U
iND70>GUi@80oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 50},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.6"],

Cell["Here is a typical palette.", "MathCaption",
  CellTags->{"S2.11.6", "6.6"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001100007B000`400?l00000o`00003o@@3oool0
0440<c<c00000`3^k^h0EEEE03<c<`0n03<c<`0000<0k^k^09VIV@2IVIT0?02IVIT203<c<`0000<0
k^k^09VIV@2IVIT0?02IVIT203<c<`0000<0k^k^09VIV@2IVIT0?02IVIT203<c<`0000@0k^k^09VI
V@2IVIT0VIVI>03oool309VIV@80<c<c00001@3oool0VIVI09VIV@2IVIT0<c<c03H0000000@0oooo
09VIV@2IVIT0VIVI0P0c<c<000060>k^kP2IVIT0VIVI09VIV@000000oooo7@1EEED00`3oool0EEEE
05EEE@0D05EEE@030000003^k^h0VIVI0080VIVI0P0c<c<000060>k^kP2IVIT0VIVI09VIV@0c<c<0
oooo703MgMd00`1EEED0oooo0=gMg@0D0=gMg@0305EEE@000000k^k^00<0VIVI0P0c<c<000060>k^
kP2IVIT0VIVI09VIV@0c<c<0oooo703MgMd00`1EEED0oooo0=gMg@0D0=gMg@0305EEE@000000k^k^
00<0VIVI0P0c<c<000060>k^kP2IVIT0VIVI09VIV@0c<c<0oooo703MgMd00`1EEED0oooo0=gMg@0:
0=gMg@@000001P3MgMd00`1EEED000000>k^kP0309VIV@80<c<c00001P3^k^h0VIVI09VIV@2IVIT0
<c<c0?oooa`0gMgM00<0EEEE0?ooo`3MgMd02`3MgMd2000000L0gMgM00<0EEEE0000003^k^h00`2I
VIT203<c<`0000H0k^k^09VIV@2IVIT0VIVI03<c<`3oool30=gMg@H0000000<0gMgM000000000000
100000040=gMg@@00000103MgMd00`1EEED0oooo0=gMg@020=gMg@H00000103MgMd2000000H0gMgM
00<0EEEE0000003^k^h00`2IVIT203<c<`0000H0k^k^09VIV@2IVIT0VIVI03<c<`3oool20=gMg@80
00000P3MgMd2000000<0gMgM0P0000020=gMg@8000000P3MgMd200000080gMgM0P0000030=gMg@03
05EEE@3oool0gMgM00<0gMgM100000050=gMg@8000001P3MgMd00`1EEED000000>k^kP0309VIV@80
<c<c00001P3^k^h0VIVI09VIV@2IVIT0<c<c0?ooo`80gMgM0P0000020=gMg@8000000`3MgMd20000
0080gMgM0P0000020=gMg@8000001`3MgMd00`1EEED0oooo0=gMg@040=gMg@8000001@3MgMd40000
00D0gMgM00<0EEEE0000003^k^h00`2IVIT203<c<`0000H0k^k^09VIV@2IVIT0VIVI03<c<`3oool3
0=gMg@D000000`3MgMd200000080gMgM0P0000020=gMg@8000001`3MgMd00`1EEED0oooo0=gMg@04
0=gMg@8000001@3MgMd4000000D0gMgM00<0EEEE0000003^k^h00`2IVIT203<c<`0000H0k^k^09VI
V@2IVIT0VIVI03<c<`3oool20=gMg@8000000P3MgMd2000000<0gMgM0P0000020=gMg@8000000P3M
gMd200000080gMgM0P0000030=gMg@0305EEE@3oool0gMgM00<0gMgM100000030=gMg@8000000P3M
gMd2000000@0gMgM00<0EEEE0000003^k^h00`2IVIT203<c<`0000H0k^k^09VIV@2IVIT0VIVI03<c
<`3oool30=gMg@@00000103MgMd5000000@0gMgM100000040=gMg@0305EEE@3oool0gMgM0080gMgM
1P0000000`3MgMd0000000000006000000<0gMgM00<0EEEE0000003^k^h00`2IVIT203<c<`0000H0
k^k^09VIV@2IVIT0VIVI03<c<`3oool;0=gMg@8000003`3MgMd00`1EEED0oooo0=gMg@0D0=gMg@03
05EEE@000000k^k^00<0VIVI0P0c<c<000060>k^kP2IVIT0VIVI09VIV@0c<c<0oooo2P3MgMd30000
00l0gMgM00<0EEEE0?ooo`3MgMd0503MgMd00`1EEED000000>k^kP0309VIV@80<c<c00001P3^k^h0
VIVI09VIV@2IVIT0<c<c0?oooa`0gMgM00<0EEEE0?ooo`3MgMd0503MgMd00`1EEED000000>k^kP03
09VIV@80<c<c00001P3^k^h0VIVI09VIV@2IVIT0<c<c0?oooa`0gMgM00<0EEEE0?ooo`3MgMd0503M
gMd00`1EEED000000>k^kP0309VIV@80<c<c00001@3^k^h0VIVI09VIV@2IVIT0<c<c01d0oooo00<0
EEEE0?ooo`3oool05@3oool00`000000k^k^09VIV@0209VIV@80<c<c0000103^k^h0VIVI09VIV@2I
VITg000000040>k^kP2IVIT0VIVI09VIV@80<c<c00000`3^k^h0VIVI09VIV@0l09VIV@80<c<c0000
0`3^k^h0VIVI09VIV@0l09VIV@80<c<c00000`3^k^h0VIVI09VIV@0l09VIV@40EEEE0@0c<c<00400
k^k^0@0c<c<00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{65, 29},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.6"],

Cell[TextData[{
  "In the expression corresponding to the palette each button corresponds to \
a ",
  StyleBox["ButtonBox", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S2.11.6", "6.7"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000NB000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cE`3oool300000280oooo0`00001?0?ooo`<0
0000o`3oool/0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=H0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool07@3oool2000000D0
oooo0P00000W0?ooo`030000003oool0oooo07`0oooo0P00002/0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=H0?ooo`030000003oool0oooo02@0
oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0640
oooo00<000000?ooo`3oool0ZP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c:03oool3000000@0oooo0`0000030?ooo`H000000P3oool300000007
0?ooo`00000000000000003oool000000?ooo`0500000080oooo0P0000000`3oool0000000000002
000000<0oooo100000040?ooo`<0000000@0oooo0000003oool0oooo0`0000030?ooo`D0000000@0
oooo00000000000000000P3oool200000080oooo100000030?ooo`<000002`3oool00`000000oooo
0?ooo`040?ooo`<000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool04@3oool5000000040?ooo`000000000000000080oooo0P0000000`3oool0
000000000002000000@0oooo0`0000000`3oool000000?ooo`020?ooo`<000002P3oool00`000000
oooo0?ooo`090?ooo`<0000000@0oooo00000000000000000P3oool3000000D0oooo0`0000020?oo
o`D00000103oool00`000000oooo0?ooo`030?ooo`<000002`3oool00`000000oooo0?ooo`030?oo
o`D000000P3oool4000000@0oooo0`000000103oool000000?ooo`3oool3000000D0oooo00<00000
0?ooo`3oool0ZP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c9`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool00P3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3o
ool01@000000oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool02P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`<000000`3oool01@000000oooo0?ooo`3o
ool0000000/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`2Z0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<W0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`00
00001P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00@00000
0?ooo`3oool00000203oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool02P3oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo0?ooo`0H0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000
oooo000000030?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0ZP3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c9`3oool00`000000oooo0?ooo`040?oo
o`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0000003oool000000080oooo00D000000?ooo`3oool0
oooo000000040?ooo`<000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo100000020?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000030?ooo`<000000`3oool5000000H0oooo00@0
00000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0oooo01P0oooo1@0000020?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool500000080oooo1@0000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool5000000@0oooo
00<000000?ooo`3oool0ZP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c9`3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0000003oool000000080oooo0P0000020?ooo`030000003oool0oooo00<00000103oool0
1@000000oooo0?ooo`3oool0000000H0oooo00@000000?ooo`3oool000000`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0080oooo0P0000020?ooo`040000003oool0oooo000000<0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`0:0?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`020?ooo`8000000P3oool010000000oooo0?ooo`00
00030?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo0000000K0?ooo`03
0000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0ZP3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c9`3oool01@000000oooo0?ooo`3oool00000
00<0oooo0`0000050?ooo`040000003oool0oooo0?ooo`8000000P3oool2000000060?ooo`000000
00000000003oool000000P3oool00`000000oooo00000002000000<0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo00000002000000<0oooo100000040?ooo`<000000`3oool3000000<0oooo
00<000000?ooo`0000000P0000040?ooo`<0000000@0oooo0000003oool0oooo0`00000<0?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool04@3oool00`000000oooo000000050?ooo`060000003oool0oooo
0?ooo`000000oooo0`0000020?ooo`030000003oool00000008000000P3oool200000080oooo0P00
00020?ooo`D000000`3oool00`000000oooo0000000B0?ooo`030000003oool0000000@0oooo0`00
00030?ooo`D000000P3oool3000000<0oooo0`000000103oool000000000000000020?ooo`<00000
303oool01@000000oooo0?ooo`3oool000000080oooo00L000000?ooo`3oool000000?ooo`000000
oooo00<0000000<0oooo0000000000000P3oool2000000<0oooo0`0000050?ooo`030000003oool0
oooo0:X0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<bL0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo01L0oooo00D0
00000?ooo`3oool0oooo0000000k0?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0
oooo000000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04@3oool00`000000
oooo000000050?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0103oool00`000000
oooo0000000C0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`2Z0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<X0?ooo`<000002P3oool3000001X0oooo1000000I0?ooo`030000003oool0oooo
02H0oooo0`0000040?ooo`8000001@3oool2000001<0oooo00<000000?ooo`0000000`3oool50000
01P0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000A0?ooo`<00000303oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo01d0oooo1`00000G0?ooo`800000[03oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<cH0oooo00<000000?ooo`3oool0o`3oooo40?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0o`3ooonn0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0o`3ooonm0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<g0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooonm0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?oo
o`030000003oool0oooo0?l0oooo``3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c>03oool00`000000oooo0?ooo`3o0?oool80oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo00<000000?oo
o`3oool0o`3oooo30?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<g0?ooo`030000003oool0oooo0?l0oooo``3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=`3oool00`000000oooo0?ooo`3o0?oo
ol<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<cH0oooo00<000000?ooo`3oool0o`3oooo40?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<iL0oooo0P00003o0?oo
of@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<h@0oooo0P00000C0?ooo`030000003oool0oooo00X0oooo0P0000050?ooo`030000003oool0oooo
0?l0ooooC@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<cQ03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`3o0?oood`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d80oooo1@0000040?ooo`<0000000<0oooo0000
003oool00P3oool3000000@0oooo0`0000030?ooo`<000000P3oool300000080oooo1`0000040?oo
o`<000000P3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo00P0oooo0P0000030?oo
o`8000000`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0o`3ooom<0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c=30?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`070000003oool0oooo0?ooo`00
0000oooo000000030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3o
ool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`090?ooo`050000003oool0oooo0?ooo`0000000`3oool30000
00`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oood`0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d<0oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo000000040?ooo`030000003oool0000000`0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`3o0?oood`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<d<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`020?ooo`050000003o
ool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo
B`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
@`3oool4000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo0P0000020?oo
o`030000003oool0oooo00@000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<00000
0?ooo`0000001@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0000000<0oooo00D00000
0?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3o
oom<0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c=30?ooo`060000003oool0oooo0?ooo`000000oooo0P0000020?ooo`8000000P3oool500000080
oooo1@0000030?ooo`<000000P3oool00`000000oooo00000002000000<0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`<000000P3oool3000000040?ooo`0000000000000000<0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo000000020?ooo`<0000000<0oooo00000000000010000000
103oool000000000000000020?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`3o0?oood`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<d<0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool04@3oool01@000000oooo0?ooo`3oool000000180
oooo00<000000?ooo`3oool00`3oool00`000000oooo0000000B0?ooo`030000003oool0000000D0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oood`0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d80oooo1@00000;0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0403oool5000001<0oooo0P0000040?ooo`03
0000003oool000000180oooo00<000000?ooo`000000103oool2000000D0oooo00<000000?ooo`3o
ool0o`3ooom=0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cQ03oool2000002L0oooo0P00003o0?ooodh0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<h@0
oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0
ooooA`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c@P3oool5000000@0oooo0`0000000`3oool000000?ooo`020?ooo`<00000103oool3000000<0
oooo0`0000020?ooo`<000000P3oool7000000@0oooo0`0000020?ooo`8000000`3oool2000000<0
oooo00<000000?ooo`3oool02P3oool3000000040?ooo`00000000000?ooo`<00000103oool30000
00`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3o0?ooodH0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d<0oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?oo
o`3oool000000080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00@000000?oo
o`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`3o0?ooodH0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<d<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000D0oooo
00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0o`3ooom<0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=30?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00X0oooo100000020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo0?l0ooooC03oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c@`3oool4000000<0oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo
0?ooo`3oool000000080oooo0P0000020?ooo`030000003oool0oooo00@000000`3oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`0=0?oo
o`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo0?l0ooooC03oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c@`3oool01P000000oooo0?ooo`3oool000000?ooo`80
00000P3oool200000080oooo1@0000020?ooo`D000000`3oool300000080oooo00<000000?ooo`00
00000P0000030?ooo`050000003oool0oooo0?ooo`0000000`3oool300000080oooo0`000000103o
ool000000000000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool4
000000<0oooo100000040?ooo`<00000103oool00`000000oooo000000050?ooo`030000003oool0
oooo0?l0ooooC03oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c@`3oool01@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0A0?ooo`050000003oool0oooo0?ooo`0000004P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0000000X0oooo00<000000?ooo`3oool0303oool00`000000oooo
000000050?ooo`030000003oool0oooo0?l0ooooC03oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c@P3oool5000000/0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0@0?ooo`D000004`3oool2000000@0oooo00<000000?ooo`000000
2@3oool2000000h0oooo00<000000?ooo`000000103oool200000?l0ooooCP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<cP0oooo00<000000?ooo`3oool0o`3oooo20?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`030000003oool0oooo0?l0oooo
``3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
=`3oool00`000000oooo0?ooo`3o0?oool<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo00<000000?ooo`3oool0o`3oooo30?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`030000
003oool0oooo0?l0oooo``3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c=P3oool00`000000oooo0?ooo`3o0?oool@0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo00<000000?ooo`3oool0
o`3oooo30?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<g0?ooo`030000003oool0oooo0?l0oooo``3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=`3oool00`000000oooo0?ooo`3o0?oool<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0oooo
00<000000?ooo`3oool0o`3oooo20?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c:@3oool2000003H0oooo
0P00000f0?ooo`8000001P3oool00`000000oooo0?ooo`3o0?oooeT0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bT0oooo00<000000?ooo`3oool0
=@3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
o`3ooomJ0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<<0?ooo`<00000103oool3000000<0oooo1P0000000`3oool0000000000004000000<0oooo
00@000000?ooo`3oool0oooo1@0000040?ooo`<000000P3oool2000000<0oooo1`0000040?ooo`<0
000000<0oooo0000003oool00P3oool3000000<0oooo0`0000000`3oool000000?ooo`020?ooo`03
0000003oool0oooo00<0oooo0`0000030?ooo`@000000`3oool5000000<0oooo0`0000000`3oool0
000000000004000000@0oooo0`0000020?ooo`8000000`3oool2000000<0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`3o0?oooeX0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`/0oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`070000003oool0
oooo0?ooo`000000oooo000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooFP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2`3oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0?l0ooooFP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2`3oool00`000000oooo0?ooo`040?ooo`D00000
103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`@000000`3oool0
0`000000oooo0?ooo`040?ooo`@00000103oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo008000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0?l0ooooF`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c2`3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool00P3oool4000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
000000<0oooo00D000000?ooo`3oool0oooo000000060?ooo`050000003oool0oooo0?ooo`000000
2@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0
oooo000000020?ooo`@000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`0000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooFP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2`3oool01@00
0000oooo0?ooo`3oool0000000<0oooo0`0000050?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3o
ool300000080oooo0`0000001P3oool00000000000000000oooo000000<0oooo00<000000?ooo`3o
ool0100000030?ooo`D000000P3oool4000000D0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`0000000P0000020?ooo`<000001@3oool40000
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`<000000P3oool3000000040?ooo`000000
0000000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oooeX0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`/0oooo00D0
00000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000403oool01@000000
oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`000000503oool010000000oooo0?ooo`0000030?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oooeX0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo0`00
000:0?ooo`<00000103oool3000000H0oooo0P0000020?ooo`D00000403oool5000000/0oooo00<0
00000?ooo`3oool0303oool2000000@0oooo0`00000<0?ooo`030000003oool0oooo00D0oooo0P00
00000`3oool0000000000003000001<0oooo0P0000060?ooo`030000003oool0oooo0?l0ooooF@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3UiND70>GUi@40
<c<c0@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3UiND80>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 121},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.6"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ButtonBox[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
a button that will paste its contents when it appears \
in an active cell \
\>"]},
          {Cell[TextData[{
              StyleBox["ButtonBox[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Active->True]", "MR"],
              " "
            }]], Cell["a button that will always be active "]},
          {Cell[TextData[{
              StyleBox["ButtonBox[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ButtonStyle->\"", "MR"],
              StyleBox["style", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
a button whose properties are taken from the specified \
style \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.6"],

Cell[TextData[{
  "Basic ",
  StyleBox["ButtonBox", "MR"],
  " objects. "
}], "Caption",
  CellTags->"S2.11.6"],

Cell[TextData[{
  "By setting the ",
  StyleBox["ButtonStyle", "MR"],
  " you can specify defaults both for how a button will be displayed, and \
what its action will be. The notebook front end provides a number of standard \
",
  StyleBox["ButtonStyle", "MR"],
  " settings, which you can access from the ",
  StyleBox["Create Button", "SR"],
  " and ",
  StyleBox["Edit Button", "SR"],
  " menu items.   "
}], "Text",
  CellTags->{"S2.11.6", "6.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"Paste\"", "MR"],
              " "
            }]], Cell["paste the contents of the button (default) "]},
          {Cell[TextData[{
              StyleBox["\"Evaluate\"", "MR"],
              " "
            }]], Cell["paste then evaluate in place what has been pasted "]},
          {Cell[TextData[{
              StyleBox["\"EvaluateCell\"", "MR"],
              " "
            }]], Cell["paste then evaluate the whole cell "]},
          {Cell[TextData[{
              StyleBox["\"CopyEvaluate\"", "MR"],
              " "
            }]], 
            Cell["\<\
copy the current selection into a new cell, then paste \
and evaluate in place \
\>"]},
          {Cell[TextData[{
              StyleBox["\"CopyEvaluateCell\"", "MR"],
              " "
            }]], 
            Cell["\<\
copy the current selection into a new cell, then paste \
and evaluate the whole cell \
\>"]},
          {Cell[TextData[{
              StyleBox["\"Hyperlink\"", "MR"],
              " "
            }]], Cell["jump to a different location in the notebook "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.6"],

Cell[TextData[{
  "Standard settings for the ",
  StyleBox["ButtonStyle", "MR"],
  " option. "
}], "Caption",
  CellTags->"S2.11.6"],

Cell[TextData[{
  "Here is the expression corresponding to a ",
  StyleBox["CopyEvaluateCell", "MR"],
  " button. "
}], "MathCaption",
  CellTags->{"S2.11.6", "6.9"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000KB000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=_0?ooo`80
0000o`3ooon<0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=`0?ooo`030000003oool0oooo0?l0ooooRP3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3oool3000000040?ooo`00000000000000
0080oooo0`0000050?ooo`<000000P3oool5000000@0oooo00<000000?ooo`3oool00`3oool30000
00/0oooo00<000000?ooo`3oool00`3oool500000080oooo100000040?ooo`<0000000@0oooo0000
003oool0oooo0`0000050?ooo`030000003oool0oooo0?l0ooooRP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`030?ooo`<000000`3oool01@000000oooo0?ooo`3oool00000
00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103o
ool00`000000oooo0?ooo`3o0?ooohX0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<aX0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000
003oool0000000<0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3o0?ooohX0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aX0oooo1@0000020?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool500000080oooo1@0000060?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo
0?ooo`0000000P3oool5000000@0oooo00<000000?ooo`3oool0o`3ooon:0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<K0?ooo`030000003oool0
000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo0000000<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool0o`3ooon:0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<K0?ooo`030000003oool0000000@0oooo0`000003
0?ooo`D000000P3oool3000000<0oooo0`000000103oool000000000000000020?ooo`<00000303o
ool01@000000oooo0?ooo`3oool000000080oooo00L000000?ooo`3oool000000?ooo`000000oooo
00<0000000<0oooo0000000000000P3oool2000000<0oooo0`0000050?ooo`030000003oool0oooo
0?l0ooooRP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c703oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0200oooo00<000000?oo
o`3oool00P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool0o`3ooon:0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<J0?ooo`<00000303oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo01d0oooo1`00000G0?ooo`800000o`3ooon<0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f00oooo0P00000e
0?ooo`<000001@3oool200000900oooo0`0000380?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=R0?ooo`030000003oool0oooo03<0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`1N0?ooo`8000001@3oool2000002L0oooo00<00000
0?ooo`3oool0a`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<cHP3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0G`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0803oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0:/0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bL0oooo1@000004
0?ooo`<0000000<0oooo0000003oool00P3oool3000000@0oooo0`0000030?ooo`<000000P3oool3
00000080oooo0P0000000`3oool0000000000002000000D0oooo0`0000040?ooo`030000003oool0
oooo0080oooo1P0000020?ooo`<000002`3oool00`000000oooo0?ooo`0;0?ooo`<00000103oool3
000000<0oooo100000050?ooo`040000003oool0oooo0?ooo`H00000103oool00`000000oooo0?oo
o`030?ooo`<0000000<0oooo0000003oool01P0000020?ooo`<0000000@0oooo0000003oool0oooo
0`0000000`3oool000000?ooo`020?ooo`<000000`3oool3000000@0oooo0`0000040?ooo`<00000
0`3oool6000000030?ooo`000000000000@000002P3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool04@3oool5000000040?ooo`000000000000000080
oooo0P0000000`3oool0000000000002000000@0oooo0`0000000`3oool000000?ooo`020?ooo`<0
00002P3oool00`000000oooo0?ooo`2Z0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<X0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`040000003oool0oooo000000<0oooo00@000000?oo
o`3oool000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`00
00050?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000
003oool0oooo00T0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo0`0000030?ooo`050000003oool0
oooo0?ooo`0000000`3oool3000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool010000000oooo0?oo
o`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool0
ZP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
:03oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000060?ooo`050000003oool0oooo0?ooo`000000
1P3oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo000000030?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo0?ooo`2h0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<X0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo0`00
00030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo0080oooo1@0000020?ooo`D000001P3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000`3o
ool01@000000oooo0?ooo`3oool0000000<0oooo100000040?ooo`030000003oool0oooo0080oooo
00D000000?ooo`3oool0oooo000000030?ooo`@000000`3oool00`000000oooo0?ooo`030?ooo`D0
00000P3oool00`000000oooo0?ooo`040?ooo`D00000103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0^03o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c:03o
ool4000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo0P0000020?ooo`03
0000003oool0oooo00<000001@3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000303oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo100000030?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000060?ooo`050000003oool0
oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
103oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`020?ooo`8000000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo
000000<0oooo00D000000?ooo`3oool0oooo0000002j0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<X0?ooo`060000003oool0oooo0?ooo`000000
oooo0P0000020?ooo`8000000P3oool500000080oooo1@0000030?ooo`<000000P3oool00`000000
oooo00000002000000<0oooo00<000000?ooo`3oool0103oool5000000050?ooo`00000000000000
003oool00`0000030?ooo`030000003oool0oooo00<0oooo0`00000<0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo0`000002
0?ooo`030000003oool00000008000000P3oool3000000060?ooo`00000000000000003oool00000
0P3oool00`000000oooo0?ooo`03000000050?ooo`00000000000000003oool0100000050?ooo`04
0000003oool0oooo0?ooo`8000000P3oool200000080oooo100000030?ooo`D000000`3oool30000
00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`<000001@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`0000001@3oool01P000000oooo0?ooo`3o
ool000000?ooo`<000000P3oool00`000000oooo0000000200000080oooo0P0000020?ooo`800000
0P3oool5000000<0oooo00<000000?ooo`000000/@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c:03oool01@000000oooo0?ooo`3oool0000000X0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0A0?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0103oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000005`3oool0
1@000000oooo0?ooo`3oool000000180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0:0?ooo`050000003oool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0140oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`000000/@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c9`3oool5000000/0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0B0?ooo`@000000`3oool00`000000oooo0?ooo`0:0?ooo`<00000
6P3oool00`000000oooo000000040?ooo`<000005`3oool600000100oooo0`00000C0?ooo`030000
003oool0oooo00/0oooo0`00000:0?ooo`<00000103oool3000000D0oooo00<000000?ooo`000000
103oool2000000D0oooo0P00000C0?ooo`030000003oool0000000<0oooo1@00000H0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`000000/@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=d0?ooo`<00000
o`3ooon60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c=D0?ooo`8000001P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03L0oooo
0P00000X0?ooo`800000T03oool200000240oooo0P00000<0?ooo`030000003oool0oooo00@0oooo
0P00001G0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c=D0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`0P0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0G0?ooo`050000003oool0oooo0?ooo`000000TP3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0D03oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c9`3oool300000080oooo0P0000020?ooo`<0
0000103oool00`000000oooo000000020?ooo`D00000103oool300000080oooo0P0000030?ooo`80
00000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00P0oooo1P0000000`3oool0
0000000000030?ooo`80000000<0oooo0000000000000P0000040?ooo`<0000000<0oooo00000000
00000P0000020?ooo`8000000P3oool3000000030?ooo`000000oooo00P0oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`@00000103oool3000000<0oooo1P0000020?ooo`<0
0000103oool3000000D0oooo0`0000020?ooo`D000000`3oool300000080oooo0`0000020?ooo`H0
0000103oool600000080oooo0`000000103oool000000?ooo`3oool3000000@0oooo0`0000020?oo
o`<0000000@0oooo00000000000000000P3oool3000000<0oooo1P0000020?ooo`<0000000@0oooo
0000003oool0oooo0`0000030?ooo`@000001@3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0C`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c:03oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`090?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo0000000:0?ooo`030000003oool0oooo01<0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1?0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<X0?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`00
0000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool01@3oool00`000000oooo000000030?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000803oool00`000000oooo0?ooo`0Q
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`00
00080?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo0200oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo05D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<bP0oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00X0oooo00@000000?ooo`3oool000001@3oool00`000000
oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool400000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000803oool00`000000oooo0?oo
o`0Q0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool300000080oooo1@00
00040?ooo`030000003oool0oooo0080oooo1@0000020?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo100000050?ooo`030000003oool0oooo00<0
oooo100000020?ooo`030000003oool0oooo00@0oooo1@0000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool0
1@000000oooo0?ooo`3oool000000080oooo1@0000030?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0803oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0E@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c:03oool4000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool4000000<0oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`090?oo
o`@00000103oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000001P3oool0
0`000000oooo0?ooo`0200000080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`020?ooo`<00000103oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0
00000080oooo0P0000020?ooo`040000003oool0oooo00000080oooo0P0000040?ooo`030000003o
ool0oooo00H0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`03
0000003oool0oooo008000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0803o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0E@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c:03o
ool01@000000oooo0?ooo`3oool0000000<0oooo0`0000020?ooo`<0000000H0oooo000000000000
00000?ooo`0000030?ooo`040000003oool0oooo0?ooo`<000000P3oool3000000040?ooo`000000
0000000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0000000<0oooo00@000000?ooo`3oool000000P3oool3000000030?ooo`000000000000800000
00@0oooo00000000000000000`3oool400000080oooo00<000000?ooo`0000000P0000040?ooo`@0
00000`3oool00`000000oooo0000000B0?ooo`030000003oool0000000D0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0000000B0?ooo`030000003oool0000000D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo0`0000050?ooo`03
0000003oool0oooo00<0oooo0`0000040?ooo`<000000`3oool500000080oooo0`0000050?ooo`<0
00000P3oool00`000000oooo00000002000000<0oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo0080oooo100000040?ooo`<00000103oool3000000<0oooo00@000000?oo
o`0000000000103oool3000000D0oooo00<000000?ooo`3oool00`3oool4000000<0oooo0`000003
0?ooo`030000003oool0000000800000103oool00`000000oooo0?ooo`030?ooo`030000003oool0
00000180oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1E0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<X0?ooo`050000003oool0
oooo0?ooo`000000403oool01@000000oooo0?ooo`3oool000000180oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0
oooo0000000R0?ooo`070000003oool0oooo0?ooo`000000oooo0000000B0?ooo`030000003oool0
000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0000000B0?ooo`030000003oool0
000000@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000002`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool00P0000040?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0000000B0?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo000000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0E@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c9`3o
ool500000100oooo1@00000C0?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool000000080oooo1P00000Q0?ooo`8000000`3oool00`000000oooo0000000B0?ooo`030000003o
ool0000000D0oooo0P0000040?ooo`030000003oool000000180oooo00<000000?ooo`000000103o
ool00`000000oooo0?ooo`050?ooo`800000103oool4000000T0oooo0`00000C0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool03`3oool5000000<0oooo0`00000H0?ooo`8000003@3o
ool3000000L0oooo0P00000A0?ooo`8000001@3oool00`000000oooo0000000B0?ooo`030000003o
ool0000000@0oooo0P0000050?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool0103o
ool2000005L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<m00oooo00<000000?ooo`3oool0o`3ooolZ0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<e/0oooo0P00
003o0?oooj00oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<e/0oooo00<000000?ooo`3oool0o`3ooonO0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<I0?ooo`D00000103oool3000000030?ooo`00
0000oooo0080oooo0`0000040?ooo`<000000`3oool300000080oooo0`0000020?ooo`L00000103o
ool300000080oooo0P0000030?ooo`8000000`3oool00`000000oooo0?ooo`3o0?oooil0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aX0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000
oooo0?ooo`3oool000000080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00@0
00000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo0000
00<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0?l0ooooW`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c6P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001@3o
ool00`000000oooo0?ooo`3o0?oooil0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<aX0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0o`3ooonO0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<J0?ooo`@000000`3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`0000000P3oool200000080oooo00<000000?ooo`3oool0100000030?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000050?ooo`030000003oool0
oooo0?l0ooooW`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c6P3oool01P000000oooo0?ooo`3oool000000?ooo`8000000P3oool200000080oooo
1@0000020?ooo`D000000`3oool300000080oooo00<000000?ooo`0000000P0000030?ooo`050000
003oool0oooo0?ooo`0000000`3oool300000080oooo0`000000103oool000000000000000030?oo
o`030000003oool0oooo0?l0ooooW`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c6P3oool01@000000oooo0?ooo`3oool0000000X0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0A0?ooo`050000003oool0oooo0?ooo`0000004P3o
ool00`000000oooo0?ooo`3o0?oooil0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<aT0oooo1@00000;0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0403oool5000001<0oooo0P00003o0?oooj00oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<Z0?ooo`800000=P3oool200000?l0ooooV@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c:P3oool00`000000oooo0?ooo`0e0?ooo`030000003o
ool0oooo0?l0ooooV03oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c3@3oool3000000@0oooo0`0000030?ooo`H0000000<0oooo0000000000001000
00030?ooo`040000003oool0oooo0?ooo`D00000103oool300000080oooo0P0000030?ooo`L00000
103oool3000000030?ooo`000000oooo0080oooo0`0000030?ooo`<0000000<0oooo0000003oool0
0P3oool00`000000oooo0?ooo`3o0?oooiP0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`070000003oool0oooo
0?ooo`000000oooo000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0o`3o
oonH0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<<0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`0000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo0?l0ooooV03oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c303oool00`000000oooo0?ooo`040?ooo`D00000103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`@000000`3oool00`000000oooo0?ooo`04
0?ooo`@00000103oool00`000000oooo0?ooo`3o0?oooiP0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo00<000000?ooo`3oool0103oool0
1@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0080oooo100000030?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000001P3oool01@000000
oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3o0?oo
oiP0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<``0oooo00D000000?ooo`3oool0oooo000000030?ooo`<000001@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo0`0000020?ooo`<0000000H0oooo00000000000000000?ooo`0000030?ooo`03
0000003oool0oooo00@000000`3oool500000080oooo100000050?ooo`030000003oool0oooo0?l0
ooooV03oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c303oool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000000@
0?ooo`050000003oool0oooo0?ooo`0000002P3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo0?l0ooooV03oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c3@3oool3000000X0oooo0`0000040?ooo`<000001P3oool200000080oooo1@00
000@0?ooo`D000002`3oool00`000000oooo0?ooo`0<0?ooo`800000o`3ooonI0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VI
V@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@L0iNGU0@0c<c<10?ooo`00
00<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 109},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.6"],

Cell["This is what the button looks like. ", "MathCaption",
  CellTags->{"S2.11.6", "6.10"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000<R000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?P3ooom<00000?l0ooooJ@3oool50000o`D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cl0
ooooBP1BDU800`000000oooo0?ooo`3o0?ooof/0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?`3ooom90=KFeP03
059BDP000000oooo0?l0ooooK03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<o0?ooodT0e]KF00<0DU9B0000003o
ool0o`3ooom/0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cl0oooo4P3Fe]H4000001h0e]KF100000090=KFeP@0
0000103Fe]H00`1BDU8000000?ooo`3o0?ooof`0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?`3ooolC0=KFeP80
00007`3Fe]H2000000d0e]KF0P0000040=KFeP03059BDP000000oooo0?l0ooooK03oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<o0?ooo`80e]KF1`0000020=KFePH000000P3Fe]H5000000<0e]KF1P0000000`3Fe]H0
000000000006000000030=KFeP000000000000@000000`3Fe]H2000000@0e]KF1P0000030=KFeP80
0000103Fe]H00`1BDU8000000?ooo`3o0?ooof`0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?`3oool30=KFeP80
00000P3Fe]H2000000<0e]KF100000030=KFeP8000000P3Fe]H2000000030=KFeP00000000000080
e]KF0P0000030=KFeP8000000P3Fe]H2000000030=KFeP00000000000080e]KF0P0000040=KFeP80
0000103Fe]H6000000<0e]KF0P0000040=KFeP03059BDP000000oooo0?l0ooooK03oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<o0?ooo`<0e]KF0P0000080=KFeP800000103Fe]H200000080e]KF0P0000000`3Fe]H0
0000000000020=KFeP8000000`3Fe]H200000080e]KF0P0000000`3Fe]H00000000000020=KFeP80
0000103Fe]H2000000@0e]KF1P0000030=KFeP800000103Fe]H00`1BDU8000000?ooo`3o0?ooofP0
oooo00D0003o0?ooo`000?l0oooo0000o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<o0?ooo`<0e]KF100000060=KFeP800000103Fe]H20000
0080e]KF0P0000020=KFePD000000`3Fe]H200000080e]KF0P0000000`3Fe]H00000000000020=KF
eP800000103Fe]H2000000@0e]KF1P0000030=KFeP800000103Fe]H00`1BDU8000000?ooo`3o0?oo
ofP0oooo00D0003o0?ooo`000?l0oooo0000o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<o0?ooo`<0e]KF100000050=KFeP@000000`3Fe]H2
00000080e]KF0P0000000`3Fe]H00000000000020=KFeP8000000`3Fe]H3000000040=KFeP000000
00000=KFeP8000000P3Fe]H2000000@0e]KF0P0000040=KFePH000000`3Fe]H2000000@0e]KF00<0
DU9B0000003oool0o`3ooomX0?ooo`<0003o00<0oooo0000o`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?`3oool30=KFeP@00000103F
e]H6000000030=KFeP000000000000@000000`3Fe]H4000000<0e]KF1P0000030=KFePD00000103F
e]H2000000@0e]KF1P0000030=KFeP800000103Fe]H00`1BDU8000000?ooo`3o0?ooofP0oooo00D0
003o0?ooo`000?l0oooo0000o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<o0?ooo`<0e]KF0P0000020=KFeP8000009@3Fe]H2000000@0e]KF
0P00000=0=KFeP800000103Fe]H00`1BDU8000000?ooo`3o0?ooofT0oooo00@0003o0?ooo`3oool0
003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c?`3oool20=KFePL00000903Fe]H3000000@0e]KF100000090=KFeP@00000103Fe]H00`1BDU80
00000?ooo`3o0?ooof`0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?`3ooom90=KFeP03059BDP000000oooo0?l0
ooooJ`3oool20000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<cl0ooooB@3Fe]H00`1BDU8000000?ooo`3o0?ooofX0oooo00<0003o0?ooo`00
0?l01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<cR@3oool00`000000oooo0?ooo`3o0?ooofP0oooo00@0003o0?ooo`3oool0003o1@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooc0?oo
o`050000o`3oool0oooo0?ooo`000?l01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooob0?ooo`H0003o1@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o
09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@3o09VIVOl0VIVI1P2IVIT10>GUi@40<c<c0@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3U
iND80>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 50},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.6"],

Cell["Here is a notebook with a selection made. ", "MathCaption",
  CellTags->{"S2.11.6", "6.11"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooob0?ooo`D0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c`0oooo103Ng]h2000001l0
g]kN0P00000;0=kNg_l0ooooR03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<l0?ooo`<0g]kN0P00000Q0=kNgP80
00002P3Ng]ko0?ooohP0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?03oool30=kNgP8000000`3Ng]h6000000L0
g]kN00<000000=kNgP3Ng]h01@3Ng]h6000000<0g]kN0P00000:0=kNg_l0ooooR03oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<l0?ooo`80g]kN0P0000060=kNgP8000002@3Ng]h00`000000g]kN0=kNgP060=kNgP@0
00001@3Ng]h2000000T0g]kNo`3ooon80?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c`0oooo0P3Ng]h2000000H0
g]kN0P0000070=kNgPD000001`3Ng]h2000000H0g]kN0P0000090=kNg_l0ooooR03oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<l0?ooo`80g]kN0P0000060=kNgP8000002@3Ng]h00`000000g]kN0=kNgP070=kNgP80
00001P3Ng]h2000000T0g]kNo`3ooon80?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c`0oooo0P3Ng]h2000000H0
g]kN0P0000090=kNgP030000003Ng]h0g]kN00H0g]kN100000050=kNgP8000002@3Ng]ko0?ooohP0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c?03oool30=kNgP8000000`3Ng]h400000140g]kN1P0000030=kNgP80
0000103Ng]h3000000<0g]kNo`3ooon80?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c`0oooo0`3Ng]h2000000@0
g]kN0`00000J0=kNgP8000000`3Ng]h2000000030=kNgP00000000000080g]kNo`3ooon80?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<c`0oooo103Ng]h2000000@0g]kN0P00000I0=kNgP800000103Ng]h200000003
0=kNgP00000000000080g]kNo`3ooon80?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c`0oooo:`3Ng]h4000000<0
g]kNo`3ooon70?ooo`80003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c?03oool/0=kNgP800000103Ng]ko0?ooohH0oooo00<0003o0?ooo`00
0?l01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c?03oool]0=kNgP8000000`3Ng]ko0?ooohD0oooo00@0003o0?ooo`3oool0003o1P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooob0?oo
o`050000o`3oool0oooo0?ooo`000?l01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooa0?ooo`H0003o1P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o
03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o
03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVI
o`2IVIT609VIV@40iNGU0@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3o
ool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.6"],

Cell["This is what happens when one then clicks on the button. ", \
"MathCaption",
  CellTags->{"S2.11.6", "6.12"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000Gb000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3ooooZ0?ooo`D0003o0P3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aP0oooo0P000?l60?ooo`80003oo`3oooo<0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c603oool00`000?l0oooo0?ooo`060?ooo`03
0000o`3oool0oooo0?l0oooobP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`/0
oooo0P000?l40?ooo`030000o`3oool0003o0080oooo00<0003o0?ooo`000?l0103oool01@000?l0
oooo0?ooo`3oool0003o00h0oooo1@00000?0?ooo`<000001@3oool2000000<0oooo0P00000>0?oo
o`D000000P3oool4000000D0oooo0P0000030?ooo`8000004`3oool5000000<0oooo0`0000050?oo
o`8000000`3oool2000001@0oooo1@0000020?ooo`@000001@3oool2000000<0oooo0P00000E0?oo
o`<000001@3oool2000000<0oooo0P00000C0?ooo`8000000`3oool200000>80oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?ooo`040000o`3oool0oooo0000o`80oooo00H0003o
0?ooo`000?l0003o0?ooo`000?l20?ooo`030000o`3oool0oooo0080oooo00H0003o0?ooo`3oool0
oooo0000o`3oool40000o`/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?oo
o`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3oool0000000L0oooo00<0
00000?ooo`3oool01`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0?ooo`3oool0000000d0oooo00<000000?ooo`3oool0103oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000050?ooo`050000003oool0
oooo0?ooo`0000003@3oool00`000000oooo0?ooo`070?ooo`050000003oool0oooo0?ooo`000000
103oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000003@3oool00`000000
oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3oool0
000000d0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool000000><0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<90?ooo`030000o`3oool0oooo0080oooo00<0
003o0?ooo`000?l00P3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0oooo0080oooo00D0
003o0?ooo`3oool0oooo0000o`0@0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1@3oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`000000203oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000
oooo0000000>0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool01@000000
oooo0?ooo`3oool0000000H0oooo00<000000?ooo`0000003P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000>0?oo
o`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0
000000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000003T0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c2@3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0
003o0080oooo00<0003o0?ooo`000?l00P3oool00`000?l0oooo0?ooo`020?ooo`060000o`3oool0
oooo0?ooo`000?l0oooo10000?l;0?ooo`030000003oool0oooo00@0oooo1@0000050?ooo`050000
003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`050?ooo`D000001`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02`3oool5000000H0
oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?oo
o`3oool02`3oool5000000L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00/0oooo1@0000050?ooo`050000003oool0oooo0?ooo`0000001`3oool0
0`000000oooo0?ooo`0;0?ooo`D000001`3oool00`000000oooo0?ooo`3S0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c2@3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0
003o0080oooo00H0003o0?ooo`000?l0003o0?ooo`000?l40?ooo`050000o`3oool0oooo0?ooo`00
0?l0403oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo100000070?ooo`03
0000003oool0000000P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`@0
00001`3oool00`000000oooo0000000>0?ooo`030000003oool0oooo00L0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000003P3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo100000070?ooo`030000003oool00000
00h0oooo00<000000?ooo`3oool01@3oool4000000L0oooo00<000000?ooo`0000003P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool000000>@0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<:0?ooo`040000o`3oool0oooo0000o`L0oooo00@0003o0?ooo`3oool0003o0`3o
ool20000o`<0oooo00<0003o0?ooo`3oool03P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01P3oool3000000040?ooo`0000000000000000H0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo
0`0000000`3oool0000000000005000000P0oooo00<000000?ooo`3oool0103oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`<0000000D0oooo0000
0000000000000?ooo`02000000T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00H0oooo0`000000103oool000000000000000030?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`<0000000D0
oooo00000000000000000?ooo`02000000T0oooo00<000000?ooo`3oool0103oool3000000050?oo
o`00000000000000003oool00P00003O0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c2`3oool20000o`/0oooo0P000?l30?ooo`030000o`3oool0oooo0080003o3P3oool300000140
oooo00<000000?ooo`3oool06P3oool3000000@0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0?0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
000000/0oooo00@000000?ooo`3oool00000403oool3000000@0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00`0oooo00@000000?ooo`3oool00000
5P3oool010000000oooo0?ooo`00003N0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c<P3oool00`000000oooo0?ooo`0@0?ooo`<000006`3oool00`000000oooo0?ooo`020?ooo`D0
00003@3oool00`000000oooo0?ooo`0?0?ooo`<00000103oool3000000l0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`020?ooo`D000002`3oool400000180oooo0`00000>0?ooo`03
0000003oool0oooo01@0oooo00@000000?ooo`3oool00000f`3oool40000o`H0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<cN`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02L0oooo00<000000?oo
o`000000803oool3000001L0oooo0`00003O0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<cN03oool010000000oooo0?ooo`00000V0?ooo`040000003oool0oooo000002T0oooo0P00
000P0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0g@3oool20000o`H0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<cN@3oool2000002P0oooo0P00000[0?ooo`030000003oool0oooo01h0oooo1000
000H0?ooo`030000003oool0oooo0=/0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooon/0oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonX0oooo
00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj@3oool60000o`H0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooojP3oool50000o`H0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c503oool20000o`H0oooo0P000?lO0?ooo`@000007P3oool4000000D0oooo0P00000O0?ooo`80
0000303oool400000?l0ooooD`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a@0
oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`0N0?ooo`8000007`3oool2000000H0
oooo0P00000Q0?ooo`8000003@3oool200000?l0ooooD`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<`d0oooo00<0003o0?ooo`000?l00P3oool00`000?l0oooo0000o`040?ooo`05
0000o`3oool0oooo0?ooo`000?l00P3oool00`000?l0oooo0?ooo`0:0?ooo`L000000P3oool60000
0080oooo1@0000030?ooo`H0000000<0oooo0000000000001P0000000`3oool00000000000040000
00<0oooo0P0000060?ooo`8000000`3oool6000000L0oooo00<000000?ooo`3oool01@3oool60000
00<0oooo0P00000=0?ooo`800000o`3ooomC0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c3@3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0003o00@0oooo00D0003o0?oo
o`3oool0oooo0000o`040?ooo`@0003o203oool200000080oooo0P0000030?ooo`@000000`3oool2
00000080oooo0P0000000`3oool00000000000020?ooo`8000000`3oool200000080oooo0P000000
0`3oool00000000000020?ooo`800000103oool2000000D0oooo0P0000060?ooo`8000002@3oool0
0`000000oooo0?ooo`060?ooo`@000001@3oool2000000`0oooo0P00003o0?oooe<0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`030000o`3oool0003o0080oooo00<0003o
0?ooo`000?l0103oool01@000?l0oooo0?ooo`3oool0003o0100oooo0P0000080?ooo`800000103o
ool200000080oooo0P0000000`3oool00000000000020?ooo`8000000`3oool200000080oooo0P00
00000`3oool00000000000020?ooo`800000103oool2000000D0oooo0P0000060?ooo`8000001`3o
ool5000000L0oooo0P0000060?ooo`800000303oool200000?l0ooooD`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<`d0oooo00P0003o0?ooo`000?l0003o0?ooo`000?l0oooo0000
o`@0oooo00D0003o0?ooo`3oool0oooo0000o`040?ooo`@0003o203oool4000000H0oooo0P000004
0?ooo`8000000P3oool200000080oooo1@0000030?ooo`8000000P3oool2000000030?ooo`000000
00000080oooo0P0000040?ooo`8000001@3oool2000000H0oooo0P0000090?ooo`030000003oool0
oooo00L0oooo0P0000060?ooo`800000303oool200000?l0ooooD`3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<`d0oooo00D0003o0?ooo`000?l0oooo0000o`020?ooo`030000o`3o
ool0oooo0080oooo00D0003o0?ooo`3oool0oooo0000o`020?ooo`030000o`3oool0oooo00/0oooo
100000050?ooo`@000000`3oool200000080oooo0P0000000`3oool00000000000020?ooo`800000
0`3oool3000000040?ooo`00000000000?ooo`8000000P3oool2000000@0oooo0P0000050?ooo`80
00001P3oool2000000T0oooo00<000000?ooo`3oool01P3oool4000000D0oooo0P00000<0?ooo`80
0000o`3ooomC0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool00`000?l0
oooo0?ooo`040?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`0>0?oo
o`@00000103oool6000000030?ooo`000000000000@000000`3oool4000000<0oooo1P0000030?oo
o`D00000103oool2000000H0oooo0P0000030?ooo`@000004@3oool6000000<0oooo0P0000040?oo
o`<000001P3oool200000?l0ooooD`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<`d0oooo00<0003o0?ooo`3oool0103oool20000o`<0oooo00<0003o0?ooo`3oool00P000?l@0?oo
o`8000000P3oool2000002D0oooo0P0000040?ooo`8000001P3oool2000000@0oooo0`00000J0?oo
o`8000000`3oool2000000030?ooo`000000000000D0oooo0P00003o0?oooe<0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<]0?ooo`L00000903oool3000000@0oooo100000050?oo
o`800000103oool2000001T0oooo0P0000040?ooo`80000000<0oooo0000000000000`3oool40000
0?l0ooooD`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<hl0oooo1000003o0?oo
oe/0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>@0?ooo`800000o`3ooomK0?oo
o`80003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c>A0?ooo`800000o`3ooomI0?ooo`030000o`3oool0003o
00H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooo[0?ooo`040000o`3oool0oooo0000o`H0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3ooooZ0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooonT0oooo1P000?l20?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooa0?ooo`D0003o1`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<@3oool2000001l0oooo0P00
003o0?oooj40oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c<03oool200000240oooo0P00003o0?oooj00oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c<03oool2000000<0oooo1P0000070?ooo`030000003oool0oooo00D0oooo1P00
00030?ooo`800000o`3ooonP0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bl0oooo0P0000060?ooo`8000002@3o
ool00`000000oooo0?ooo`060?ooo`@000001@3oool200000?l0ooooW`3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<_0?ooo`8000001P3oool2000000L0oooo1@0000070?ooo`8000001P3oool200000?l0ooooW`3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<_0?ooo`8000001P3oool2000000T0oooo00<000000?ooo`3oool01`3o
ool2000000H0oooo0P00003o0?oooil0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c;`3oool2000000H0oooo0P00
00090?ooo`030000003oool0oooo00H0oooo100000050?ooo`800000o`3ooonO0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<c00oooo0P0000030?ooo`@000004@3oool6000000<0oooo0P0000040?ooo`<00000o`3o
oonI0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<c00oooo0P0000040?ooo`<000006P3oool2000000<0oooo0P00
00000`3oool000000000003o0?oooiP0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<@3oool2000000@0oooo0P00
000I0?ooo`800000103oool2000000030?ooo`00000000000?l0ooooV03oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c=H0?ooo`@00000o`3ooonI0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<eT0oooo0P00003o0?oooiT0oooo0P00
0?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c=J0?ooo`800000o`3ooonG0?ooo`030000o`3oool0003o00L0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooolP3oool010000?l0oooo0?oo
o`000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?oooo40oooo00D0003o0?ooo`3oool0oooo0000o`070?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo00oooo1P000?l70?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0
VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0?l0VIVIo`2IVIT609VIV@40iNGU0@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GU
i@P0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 95},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.6"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["ButtonFunction", "MR"],
              " "
            }]], Cell["(pasting function) "], Cell[
            "the function to apply when the button is clicked "]},
          {Cell[TextData[{
              StyleBox["ButtonSource", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[
            "where to get the first argument of the button function from "]},
          {Cell[TextData[{
              StyleBox["ButtonData", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[
            "the second argument to supply to the button function "]},
          {Cell[TextData[{
              StyleBox["ButtonEvaluator", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell["where to send the button function for evaluation "]},
          {Cell[TextData[{
              StyleBox["ButtonNote", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], 
            Cell["\<\
what to display in the window status line when the \
cursor is over the button \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.11.6"],

Cell["Options that affect the action of buttons. ", "Caption",
  CellTags->"S2.11.6"],

Cell[TextData[{
  "A particular ",
  StyleBox["ButtonStyle", "MR"],
  " setting will specify defaults for all other button options. Some of these \
options will affect the display of the button, as discussed in Section\
\[NonBreakingSpace]",
  ButtonBox["2.9.11",
    ButtonData:>{"2.9.11", "11.20"},
    ButtonStyle->"MainBookLink"],
  ". Others affect the action it performs. "
}], "Text",
  CellTags->{"S2.11.6", "6.13"}],

Cell[TextData[{
  "What ultimately determines the action of a button is the setting for the \
",
  StyleBox["ButtonFunction", "MR"],
  " option. This setting gives the ",
  StyleBox["Mathematica", "TI"],
  " function which is to be executed whenever the button is clicked. \
Typically this function will be a combination of various notebook \
manipulation commands. "
}], "Text",
  CellTags->{"S2.11.6", "6.14"}],

Cell[TextData[{
  "Thus, for example, in its most basic form, a ",
  StyleBox["Paste", "MR"],
  " button will have a ",
  StyleBox["ButtonFunction", "MR"],
  " given effectively by ",
  StyleBox["NotebookApply[SelectedNotebook[", "MR"],
  " ",
  StyleBox["],", "MR"],
  " ",
  StyleBox["#]&", "MR"],
  ", while a ",
  StyleBox["Hyperlink", "MR"],
  " button will have a ",
  StyleBox["ButtonFunction", "MR"],
  " given effectively by ",
  StyleBox["NotebookLocate[#2]&", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.11.6", "6.15"}],

Cell[TextData[{
  "When a button is clicked, two arguments are supplied to its ",
  StyleBox["ButtonFunction", "MR"],
  ". The first is specified by ",
  StyleBox["ButtonSource", "MR"],
  ", and the second by ",
  StyleBox["ButtonData", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.11.6", "6.16"}],

Cell[TextData[{
  "Typically ",
  StyleBox["ButtonData", "MR"],
  " is set to be a fixed expression, defined when the button was first \
created. ",
  StyleBox["ButtonSource", "MR"],
  ", on the other hand, usually changes with the contents of the button, or \
the environment in which the button appears. "
}], "Text",
  CellTags->{"S2.11.6", "6.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["ButtonData", "MR"],
              " if it is set, otherwise ",
              StyleBox["ButtonContents", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ButtonContents", "MR"],
              " "
            }]], Cell["the expression displayed on the button "]},
          {Cell[TextData[{
              StyleBox["ButtonData", "MR"],
              " "
            }]], Cell[TextData[{
              "the setting for the ",
              StyleBox["ButtonData", "MR"],
              " option "
            }]]},
          {Cell[TextData[{
              StyleBox["CellContents", "MR"],
              " "
            }]], Cell[
            "the contents of the cell in which the button appears "]},
          {Cell[TextData[{
              StyleBox["Cell", "MR"],
              " "
            }]], Cell["the whole cell in which the button appears "]},
          {Cell[TextData[{
              StyleBox["Notebook", "MR"],
              " "
            }]], Cell["the whole notebook in which the button appears "]},
          {Cell[TextData[{
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "the expression ",
              StyleBox["n", "TI"],
              " levels up from the button in the notebook "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.6"],

Cell[TextData[{
  "Possible settings for the ",
  StyleBox["ButtonSource", "MR"],
  " option. "
}], "Caption",
  CellTags->"S2.11.6"],

Cell[TextData[{
  "For a simple ",
  StyleBox["Paste", "MR"],
  " button, the setting for ",
  StyleBox["ButtonSource", "MR"],
  " is typically ",
  StyleBox["ButtonContents", "MR"],
  ". This means that whatever is displayed in the button will be what is \
passed as the first argument of the button function. The button function can \
then take this argument and feed it to ",
  StyleBox["NotebookApply", "MR"],
  ", thereby actually pasting it into the notebook. "
}], "Text",
  CellTags->{"S2.11.6", "6.18"}],

Cell[TextData[{
  "By using settings other than ",
  StyleBox["ButtonContents", "MR"],
  " for ",
  StyleBox["ButtonSource", "MR"],
  ", you can create buttons which effectively pull in various aspects of \
their environment for processing. Thus, for example, with the setting ",
  StyleBox["ButtonSource->Cell", "MR"],
  ", the first argument to the button function will be the expression that \
represents the whole cell in which the button appears. By having the button \
function manipulate this expression you can then make the button have a \
global effect on the whole cell, say by restructuring it in some specified \
way.   "
}], "Text",
  CellTags->{"S2.11.6", "6.19"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell["the front end "]},
          {Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["the current kernel "]},
          {Cell[TextData[{
              StyleBox["\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["a kernel with the specified name "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.6"],

Cell[TextData[{
  "Settings for the ",
  StyleBox["ButtonEvaluator", "MR"],
  " option. "
}], "Caption",
  CellTags->"S2.11.6"],

Cell[TextData[{
  "Once the arguments to a ",
  StyleBox["ButtonFunction", "MR"],
  " have been found, and an expression has been constructed, there is then \
the question of where that expression should be sent for evaluation. The ",
  StyleBox["ButtonEvaluator", "MR"],
  " option for a ",
  StyleBox["ButtonBox", "MR"],
  " allows you to specify this. "
}], "Text",
  CellTags->{"S2.11.6", "6.20"}],

Cell[TextData[{
  "In general, if the expression involves a range of ",
  StyleBox["Mathematica", "TI"],
  " functions, then there will be no choice but to evaluate it in an actual \
",
  StyleBox["Mathematica", "TI"],
  " kernel. But if the expression involves only simple notebook manipulation \
commands, then it may be possible to execute the expression directly in the \
front end, without ever involving the kernel. You can specify that this \
should be done by setting the option ",
  StyleBox["ButtonEvaluator->None", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.11.6", "6.21"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FrontEndExecute[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["execute an expression in the front end "]},
          {Cell[TextData[{
              StyleBox["FrontEnd`NotebookApply[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              ", etc. "
            }]], Cell["front end versions of notebook commands "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.6"],

Cell["Expressions to be executed directly in the front end. ", "Caption",
  CellTags->"S2.11.6"],

Cell[TextData[{
  "As discussed in the previous section, the standard notebook front end can \
handle only a limited set of commands, all identified as being in the ",
  StyleBox["FrontEnd`", "MR"],
  " context. But these commands are sufficient to be able to implement all of \
the actions associated with standard button styles such as ",
  StyleBox["Paste", "MR"],
  ", ",
  StyleBox["EvaluateCell", "MR"],
  " and ",
  StyleBox["Hyperlink", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.11.6", "6.22"}],

Cell[TextData[{
  "Note that even if an expression is sent to the front end, it will be \
executed only if it is wrapped in a ",
  StyleBox["FrontEndExecute", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.11.6", "6.23"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.11.7 Advanced Topic: The Structure of Cells", "Subsection",
  CellTags->{"S2.11.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Cell[", "MR"],
              StyleBox["contents", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["style", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["a cell in a particular style "]},
          {Cell[TextData[{
              StyleBox["Cell[", "MR"],
              StyleBox["contents", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["style", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["options", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["a cell with additional options set "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.11.7"],

Cell["Expressions corresponding to cells. ", "Caption",
  CellTags->"S2.11.7"],

Cell[TextData[{
  "Here is a notebook containing a text cell and a ",
  StyleBox["Mathematica", "TI"],
  " input cell. "
}], "MathCaption",
  CellTags->{"S2.11.7", "7.2"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000AR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`0000<0oooo0>GUi@00
00006@00003o03<c<nh0<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`3UiNGo0>GU
i@40iNGU0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooolP3oool50000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=:0?ooo`@0
0000o`3ooonX0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d40oooo00<000000?ooo`3oool01`3oool200000?l0
ooooZ@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<a0?ooo`H000002P3oool2000000T0oooo0P00003o0?ooojP0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c<P3oool4000000`0oooo00<000000?ooo`3oool01`3oool200000?l0
ooooZ03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<c0?ooo`8000003@3oool2000000L0oooo1000003o0?ooojL0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c<`3oool2000000h0oooo00<000000?ooo`3oool01@3oool400000?l0
ooooY`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<b0?ooo`@000003@3oool2000000D0oooo0P0000020?ooo`80
0000o`3ooonV0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c40oooo1P00000=0?ooo`030000003oool0oooo0080
oooo2000003o0?ooojD0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>@3oool2000000030?ooo`000000oooo00H0
oooo0P00003o0?oook00oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>03oool010000000oooo0?ooo`0000090?oo
o`030000003oool0oooo0?l0oooo[@3oool20000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0oooo00@000000?ooo`3oool00000o`3ooonh
0?ooo`030000o`3oool0003o00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<cP0oooo00@000000?ooo`3oool00000o`3ooong0?ooo`040000o`3o
ool0oooo0000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<cT0oooo0P0000000`3oool000000?ooo`3o0?oook@0oooo00D0003o0?ooo`3oool0
oooo0000o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?oooo40oooo1P000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooob0?ooo`D0003o1P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<g00oooo0P00003o0?oooh@0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cL03oool00`000000
oooo0000003o0?oooh<0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cLP3oool00`000000oooo0?ooo`3o0?oooh40
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c3@3oool300000080oooo0`0000020?ooo`8000000P3oool300000080
oooo0P0000050?ooo`H000001@3oool3000000<0oooo0`0000020?ooo`<0000000@0oooo00000000
0000oooo0P0000020?ooo`8000001P3oool300000080oooo0`0000020?ooo`80000000<0oooo0000
000000001P000000103oool000000000003oool2000000030?ooo`0000000000008000000`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo008000000P3oool2000000030?ooo`000000
00000080oooo00@000000?ooo`3oool00000o`3ooomY0?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool000001@3oool00`000000oooo000000020?ooo`030000003oool0oooo
0080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`050000003oool0oooo
0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`8000000P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool000000080oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`040?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`00
00020?ooo`030000003oool0oooo0?l0ooooJ`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool000001@3oool010000000oooo0?ooo`0000080?ooo`04
0000003oool0oooo0?ooo`8000001P3oool2000000030?ooo`000000oooo0080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00D0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3o
ool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo000000050?ooo`040000003oool0oooo000000H0oooo00D000000?ooo`3o
ool0oooo0000003o0?ooofd0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00@000000P3oool00`000000oooo0?ooo`04000000D0oooo00@000000?oo
o`00000000001P3oool2000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003o
ool0oooo00000080oooo00<000000?ooo`3oool0100000040?ooo`050000003oool0oooo0?ooo`00
00000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool300000080oooo00L000000?ooo`3oool0oooo0000003oool0000000D0
oooo00<000000?ooo`3oool0100000030?ooo`050000003oool0oooo0?ooo`000000o`3ooom]0?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<`h0oooo1P0000020?ooo`040000003oool0oooo00000080oooo0P000000
1@3oool000000?ooo`3oool0000000D0oooo00<000000?ooo`0000000P3oool00`000000oooo0?oo
o`020?ooo`060000003oool0oooo0000003oool000000`3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool01@000000oooo0?oo
o`3oool000000080oooo0P000000103oool000000?ooo`3oool200000080oooo00@000000?ooo`3o
ool000000P3oool00`000000oooo000000020?ooo`030000003oool0oooo0080000000<0oooo0000
003oool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00H00000
0?ooo`3oool000000?ooo`0000020?ooo`030000003oool0oooo0?l0ooooJ`3oool00`000?l0oooo
0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<>0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0oooo0P0000020?ooo`05
0000003oool000000000003oool00P0000050?ooo`8000000P3oool3000000D0oooo0`0000020?oo
o`<000000P3oool01@000000oooo000000000000oooo00800000103oool2000000H0oooo0`000002
0?ooo`050000003oool000000000003oool00P0000000`3oool000000?ooo`02000000030?ooo`00
0000oooo008000000`3oool200000080oooo00<000000?ooo`0000000`000000103oool000000000
000000020?ooo`<000000P3oool200000080oooo0P0000000`3oool000000000000300000?l0oooo
K03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
A`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
o`3ooom[0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`170?ooo`030000003oool0oooo0?l0ooooUP3oool00`000?l0oooo0?ooo`040?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`<00000
0P3oool3000001<0oooo00<000000?ooo`3oool0<@3oool200000080oooo00<000000?ooo`3oool0
o`3ooonC0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool`3oool40000o`H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo
0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?oooo80oooo1@000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@L0iNGU0@0c<c<10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 70},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.11.7"],

Cell["Here are the expressions corresponding to these cells. ", "MathCaption",
  CellTags->{"S2.11.7", "7.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000I2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`0000<0oooo0>GUi@0c
<c<0o`0c<c?o03<c<`P0<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`3UiNGo0>GU
i@@0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0
VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
oool0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GUi@2IVIT0
VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3U
iND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo40
oooo1@000?l60?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<c<0oooo1000000]0?ooo`@00000K03oool4000005h0oooo100000120?ooo`@00000
M03oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<c@0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?oo
o`0R0?ooo`800000=P3oool200000140oooo00<000000?ooo`3oool04`3oool2000000`0oooo0P00
000m0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool2000000D0oooo0P00
000W0?ooo`030000003oool0oooo01X0oooo0P00001H0?ooo`030000o`3oool0oooo00@0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=03oool0
0`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0G0?ooo`050000003oool0oooo0?ooo`0000004P3oool00`000000oooo0?oo
o`0D0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0B0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool06`3oool00`000000oooo0?oo
o`1F0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c9P3oool4000000@0oooo0P0000001P3oool000000000003o
ool000000?ooo`800000103oool3000000<0oooo100000030?ooo`@00000103oool3000000<0oooo
100000030?ooo`D000000P3oool010000000oooo0000000000050?ooo`<0000000<0oooo00000000
00000`0000040?ooo`<000000P3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo00P0
oooo0P0000030?ooo`8000002@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0080
oooo00@000000?ooo`3oool0oooo0`0000001@3oool00000000000000000oooo00D000000P3oool0
10000000oooo0000000000020?ooo`<0000000@0oooo00000000000000000P3oool2000000030?oo
o`000000000000<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool04@3oool5000000050?ooo`00000000000000003o
ool00`0000000`3oool000000?ooo`02000000@0oooo0P0000000`3oool00000000000030?ooo`<0
00002`3oool00`000000oooo0?ooo`1F0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c9P3oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool00P0000020?ooo`8000000P3oool010000000
oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool00P3oool200000080oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`000003
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3o
ool0000000X0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo
0P0000020?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000P3oool20000
00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0B0?ooo`<00000303oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`8000000P3oool010000000oooo0?ooo`0000020?ooo`8000000`3oool01@000000oooo0?oo
o`3oool0000000X0oooo00<000000?ooo`3oool0EP3oool00`000?l0oooo0?ooo`040?ooo`030>GU
i@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bX0oooo00@0
00000?ooo`3oool000000`3oool010000000oooo0?ooo`0000040?ooo`800000203oool00`000000
oooo0?ooo`060?ooo`80000000<0oooo0000003oool01`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000050?oo
o`070000003oool0oooo0?ooo`000000oooo000000050?ooo`060000003oool0oooo0000003oool0
00001@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool000000280oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000`3oool01000
0000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`000000303oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000000>0?ooo`030000
003oool0oooo05H0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<X0?ooo`<000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`3oool00P3oool7000000<0oooo00<000000?ooo`3oool0
103oool2000000<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000050?ooo`07
0000003oool0oooo0?ooo`000000oooo000000050?ooo`050000003oool0oooo0?ooo`0000001P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`D00000103oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`3oool4000000@0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01h0oooo
00D000000?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000`3oool01@00
0000oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3oool0EP3oool00`000?l0oooo0?ooo`04
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<bH0oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool200000080oooo00@00000
0?ooo`3oool000000`3oool010000000oooo0?ooo`3oool2000000@0oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool2000000H0oooo00<000000?oo
o`3oool00P3oool200000080oooo00D000000?ooo`3oool0oooo000000050?ooo`@000000`3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool000000240oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool00P3oool200000080oooo00<0
00000?ooo`3oool00P0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool07@3o
ool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool00P3oool200000080oooo
00<000000?ooo`3oool00P0000020?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3o
ool0oooo0000000>0?ooo`030000003oool0oooo05H0oooo00<0003o0?ooo`3oool0103oool00`3U
iND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<V0?ooo`03
0000003oool0oooo00<0oooo0P0000020?ooo`80000000@0oooo000000000000oooo0P0000040?oo
o`<000000`3oool2000000030?ooo`000000000000<0oooo100000030?ooo`@000000P3oool20000
00030?ooo`00000000000080oooo0`0000030?ooo`80000000<0oooo0000000000000`3oool50000
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`<000000P3oool3000000040?ooo`000000
0000000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000020?ooo`<0000000@0
oooo00000000000000000P3oool00`000000oooo0000000B0?ooo`030000003oool0000000D0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000D0oooo
00@000000?ooo`3oool0oooo0P0000000`3oool00000000000030?ooo`040000003oool000000000
00<0oooo100000050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001@3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0000000B0?ooo`030000003oool000000080oooo0`000000103oool00000000000000002
0?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`0000001@3oool010000000oooo0?ooo`3o
ool2000000030?ooo`00000000000080oooo0P0000000`3oool00000000000020?ooo`8000000P3o
ool200000080oooo1@0000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0EP3o
ool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<bH0oooo00D000000?ooo`3oool0oooo000000120?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo0000000B0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`0000002`3oool00`000000oooo0000000B0?ooo`030000003oool0000000@0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`0000001@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0000000L0oooo
00L000000?ooo`3oool0oooo0000003oool000000180oooo00<000000?ooo`0000002`3oool00`00
0000oooo000000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`040?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0EP3oool00`00
0?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<bL0oooo1000000e0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool00P3oool5000001<0oooo0P0000040?ooo`030000003oool0000000/0oooo00<000000?ooo`00
00004P3oool00`000000oooo000000040?ooo`030000003oool0oooo00D0oooo0P0000030?ooo`<0
0000103oool3000000X0oooo0P00000>0?ooo`8000001@3oool00`000000oooo000000040?ooo`80
00004`3oool00`000000oooo000000070?ooo`070000003oool0oooo0?ooo`000000oooo0000000B
0?ooo`030000003oool0000000/0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`04
0?ooo`8000001@3oool2000001<0oooo00<000000?ooo`0000000`3oool5000001P0oooo00<00000
0?ooo`3oool0103oool00`000000oooo000000040?ooo`800000F03oool00`000?l0oooo0?ooo`04
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<kT0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`3H0?ooo`030000o`3oool0oooo
00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3ooooe0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00@0oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
oooe0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cA03oool20000
00H0oooo00<000000?ooo`3oool0o`3ooonV0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VI
V@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cA03oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooY`3oool00`000?l0oooo0?ooo`040?ooo`03
0>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aL0oooo
0`0000020?ooo`8000000P3oool3000000@0oooo00<000000?ooo`0000000P3oool5000000@0oooo
0`0000020?ooo`8000000`3oool2000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`3o0?ooojL0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<H0?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooY`3o
ool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<aP0oooo00L000000?ooo`3oool0oooo0000003oool0000000D0oooo
00L000000?ooo`000000oooo0000003oool000000080oooo00L000000?ooo`3oool0oooo0000003o
ool0000000D0oooo00H000000?ooo`3oool000000?ooo`0000050?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0o`3ooonW0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c603oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00L000000?ooo`000000oooo0000003oool0
00000080oooo00L000000?ooo`3oool0oooo0000003oool0000000D0oooo00D000000?ooo`3oool0
oooo000000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooonX0?ooo`03
0000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c603oool4000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?oo