(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    210887,       7536]*)
(*NotebookOutlinePosition[    302377,      10143]*)
(*  CellTagsIndexPosition[    294647,       9842]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.12 ", "HeadingNumber"],
  "Files and Streams"
}], "Section",
  CellTags->{"S2.12.0", "0.1"}],

Cell[CellGroupData[{

Cell[TextData[{
  "2.12.1 Reading and Writing ",
  StyleBox["Mathematica", "SBO"],
  " Files"
}], "Subsection",
  CellTags->{"S2.12.1", "1.1"}],

Cell[TextData[{
  "Particularly if you use a text\[Hyphen]based ",
  StyleBox["Mathematica", "TI"],
  " interface, you will often need to read and write files containing \
definitions and results from ",
  StyleBox["Mathematica", "TI"],
  ". Section ",
  ButtonBox["1.11.1",
    ButtonData:>{"1.11.1", "1.1"},
    ButtonStyle->"MainBookLink"],
  " gave a general discussion of how to do this. This section gives some more \
details. "
}], "Text",
  CellTags->{"S2.12.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["<<", "MR"],
              StyleBox["file", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Get[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "read in a file of ",
              StyleBox["Mathematica", "TI"],
              " input, and return the last expression in the file "
            }]]},
          {Cell[TextData[{
              StyleBox["!!", "MR"],
              StyleBox["file", "TI"],
              " "
            }]], Cell["display the contents of a file "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.1"],

Cell["Reading files. ", "Caption",
  CellTags->"S2.12.1"],

Cell[TextData[{
  "This shows the contents of the file ",
  StyleBox["factors", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.3"}],

Cell[CellGroupData[{

Cell["!!factors", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.12.1"],

Cell["\<\
(* Factors of x^20 - 1 *)
  (-1 + x)*(1 + x)*(1 + x^2)*(1 - x + x^2 - x^3 + x^4)*
   (1 + x + x^2 + x^3 + x^4)*(1 - x^2 + x^4 - x^6 + x^8)\
\>", "Print",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell["\<\
This reads in the file, and returns the last expression in it. \
\
\>", "MathCaption",
  CellTags->{"S2.12.1", "1.4"}],

Cell[CellGroupData[{

Cell["<<factors", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.12.1"],

Cell[BoxData[
    \(\((\(-1\) + x)\)\ \((1 + x)\)\ \((1 + x\^2)\)\ \((1 - x + x\^2 - x\^3 + 
          x\^4)\)\ \((1 + x + x\^2 + x\^3 + x\^4)\)\ \((1 - x\^2 + x\^4 - 
          x\^6 + x\^8)\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[TextData[{
  "If ",
  StyleBox["Mathematica", "TI"],
  " cannot find the file you ask it to read, it prints a message, then \
returns the symbol ",
  StyleBox["$Failed", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.5"}],

Cell[CellGroupData[{

Cell["<<faxors", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.12.1"],

Cell[BoxData[
    \(Get::"noopen" \(\(:\)\(\ \)\) 
      "Cannot open \!\(\"faxors\"\)."\)], "Message",
  CellTags->"S2.12.1"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " input files can contain any number of expressions. Each expression, \
however, must start on a new line. The expressions may however continue for \
as many lines as necessary. Just as in a standard interactive ",
  StyleBox["Mathematica", "TI"],
  " session, the expressions are processed as soon as they are complete. \
Note, however, that in a file, unlike an interactive session, you can insert \
a blank line at any point without effect. "
}], "Text",
  CellTags->{"S2.12.1", "1.6"}],

Cell[TextData[{
  "When you read in a file with ",
  StyleBox["<<", "MR"],
  StyleBox["file", "TI"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " returns the last expression it evaluates in the file. You can avoid \
getting any visible result from reading a file by ending the last expression \
in the file with a semicolon, or by explicitly adding ",
  StyleBox["Null", "MR"],
  " after that expression. "
}], "Text",
  CellTags->{"S2.12.1", "1.7"}],

Cell[TextData[{
  "If ",
  StyleBox["Mathematica", "TI"],
  " encounters a syntax error while reading a file, it reports the error, \
skips the remainder of the file, then returns ",
  StyleBox["$Failed", "MR"],
  ". If the syntax error occurs in the middle of a package which uses ",
  StyleBox["BeginPackage", "MR"],
  " and other context manipulation functions, then ",
  StyleBox["Mathematica", "TI"],
  " tries to restore the context to what it was before the package was read. \
"
}], "Text",
  CellTags->{"S2.12.1", "1.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox[">>", "MR"],
              " ",
              StyleBox["file", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Put[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["write an expression to a file "]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox[">>>", "MR"],
              " ",
              StyleBox["file", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["PutAppend[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["append an expression to a file "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.1"],

Cell["Writing expressions to files. ", "Caption",
  CellTags->"S2.12.1"],

Cell[TextData[{
  "This writes an expression to the file ",
  StyleBox["tmp", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.9"}],

Cell["Factor[x^6 - 1] >> tmp", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.12.1"],

Cell["Here are the contents of the file. ", "MathCaption",
  CellTags->{"S2.12.1", "1.10"}],

Cell[CellGroupData[{

Cell["!!tmp", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.12.1"],

Cell["(-1 + x)*(1 + x)*(1 - x + x^2)*(1 + x + x^2)", "Print",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell["This appends another expression to the same file. ", "MathCaption",
  CellTags->{"S2.12.1", "1.11"}],

Cell["Factor[x^8 - 1] >>> tmp", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.12.1"],

Cell["Both expressions are now in the file. ", "MathCaption",
  CellTags->{"S2.12.1", "1.12"}],

Cell[CellGroupData[{

Cell["!!tmp", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.12.1"],

Cell["\<\
(-1 + x)*(1 + x)*(1 - x + x^2)*(1 + x + x^2)
(-1 + x)*(1 + x)*(1 + x^2)*(1 + x^4)\
\>", "Print",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[TextData[{
  "When you use ",
  StyleBox["expr", "TI"],
  " ",
  StyleBox[">>>", "MR"],
  " ",
  StyleBox["file", "TI"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " appends each new expression you give to the end of your file. If you use \
",
  StyleBox["expr", "TI"],
  " ",
  StyleBox[">>", "MR"],
  " ",
  StyleBox["file", "TI"],
  ", however, then ",
  StyleBox["Mathematica", "TI"],
  " instead wipes out anything that was in the file before, and then puts ",
  StyleBox["expr", "TI"],
  " into the file. "
}], "Text",
  CellTags->{"S2.12.1", "1.13"}],

Cell[TextData[{
  "When you use either ",
  StyleBox[">>", "MR"],
  " or ",
  StyleBox[">>>", "MR"],
  " to write expressions to files, the expressions are usually given in ",
  StyleBox["Mathematica", "TI"],
  " input format, so that you can read them back into ",
  StyleBox["Mathematica", "TI"],
  ". Sometimes, however, you may want to save expressions in other formats. \
You can do this by explicitly wrapping a format directive such as ",
  StyleBox["OutputForm", "MR"],
  " around the expression you write out. "
}], "Text",
  CellTags->{"S2.12.1", "1.14"}],

Cell[TextData[{
  "This writes an expression to the file ",
  StyleBox["tmp", "MR"],
  " in output format. "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.15"}],

Cell["OutputForm[ Factor[x^6 - 1] ] >> tmp", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.12.1"],

Cell[TextData[{
  "The expression in ",
  StyleBox["tmp", "MR"],
  " is now in output format. "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.16"}],

Cell[CellGroupData[{

Cell["!!tmp", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.12.1"],

Cell["\<\
                           2            2
(-1 + x) (1 + x) (1 - x + x ) (1 + x + x )\
\>", "Print",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[TextData[{
  "One of the most common reasons for using files is to save definitions of \
",
  StyleBox["Mathematica", "TI"],
  " objects, to be able to read them in again in a subsequent ",
  StyleBox["Mathematica", "TI"],
  " session. The operators ",
  StyleBox[">>", "MR"],
  " and ",
  StyleBox[">>>", "MR"],
  " allow you to save ",
  StyleBox["Mathematica", "TI"],
  " expressions in files. You can use the function ",
  StyleBox["Save", "MR"],
  " to save complete definitions of ",
  StyleBox["Mathematica", "TI"],
  " objects, in a form suitable for execution in subsequent ",
  StyleBox["Mathematica", "TI"],
  " sessions.  "
}], "Text",
  CellTags->{"S2.12.1", "1.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Save[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["symbol", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "save the complete definitions for a symbol in a file "]},
          {Cell[TextData[{
              StyleBox["Save[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["form", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "save definitions for symbols whose names match the string \
pattern ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Save[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["context", "TI"],
              StyleBox["`\"]", "MR"],
              " "
            }]], Cell[
            "save definitions for all symbols in the specified context "]},
          {Cell[TextData[{
              StyleBox["Save[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["object",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["object",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["save definitions for several objects "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.1"],

Cell["Writing out definitions. ", "Caption",
  CellTags->"S2.12.1"],

Cell[TextData[{
  "This assigns a value to the symbol ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.18"}],

Cell[CellGroupData[{

Cell["a = 2 - x^2", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.12.1"],

Cell[BoxData[
    \(2 - x\^2\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Save", "MR"],
  " to write the definition of ",
  StyleBox["a", "MR"],
  " to a file. "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.19"}],

Cell["Save[\"afile\", a]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.12.1"],

Cell[TextData[{
  "Here is the definition of ",
  StyleBox["a", "MR"],
  " that was saved in the file. "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.20"}],

Cell[CellGroupData[{

Cell["!!afile", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.12.1"],

Cell["a = 2 - x^2", "Print",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[TextData[{
  "When you define a new object in ",
  StyleBox["Mathematica", "TI"],
  ", your definition will often depend on other objects that you defined \
before. If you are going to be able to reconstruct the definition of your new \
object in a subsequent ",
  StyleBox["Mathematica", "TI"],
  " session, it is important that you store not only its own definition, but \
also the definitions of other objects on which it depends. The function ",
  StyleBox["Save", "MR"],
  " looks through the definitions of the objects you ask it to save, and \
automatically also saves all definitions of other objects on which it can see \
that these depend. However, in order to avoid saving a large amount of \
unnecessary material, ",
  StyleBox["Save", "MR"],
  " never includes definitions for symbols that have the attribute ",
  StyleBox["Protected", "MR"],
  ". It assumes that the definitions for these symbols are also built in. \
Nevertheless, with such definitions taken care of, it should always be the \
case that reading the output generated by ",
  StyleBox["Save", "MR"],
  " back into a new ",
  StyleBox["Mathematica", "TI"],
  " session will set up the definitions of your objects exactly as you had \
them before.  "
}], "Text",
  CellTags->{"S2.12.1", "1.21"}],

Cell[TextData[{
  "This defines a function ",
  StyleBox["f", "MR"],
  " which depends on the symbol ",
  StyleBox["a", "MR"],
  " defined above. "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.22"}],

Cell["f[z_] := a^2 - 2", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.12.1"],

Cell[TextData[{
  "This saves the complete definition of ",
  StyleBox["f", "MR"],
  " in a file. "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.23"}],

Cell["Save[\"ffile\", f]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.12.1"],

Cell[TextData[{
  "The file contains not only the definition of ",
  StyleBox["f", "MR"],
  " itself, but also the definition of the symbol ",
  StyleBox["a", "MR"],
  " on which ",
  StyleBox["f", "MR"],
  " depends. "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.24"}],

Cell[CellGroupData[{

Cell["!!ffile", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.12.1"],

Cell["\<\
f[z_] := a^2 - 2
 
a = 2 - x^2\
\>", "Print",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["Save", "MR"],
  " makes use of the output forms ",
  StyleBox["Definition", "MR"],
  " and ",
  StyleBox["FullDefinition", "MR"],
  ", which print as definitions of ",
  StyleBox["Mathematica", "TI"],
  " symbols. In some cases, you may find it convenient to use these output \
forms directly. "
}], "Text",
  CellTags->{"S2.12.1", "1.25"}],

Cell[TextData[{
  "The output form ",
  StyleBox["Definition[", "MR"],
  StyleBox["f", "TI"],
  StyleBox["]", "MR"],
  " prints as the sequence of definitions that have been made for ",
  StyleBox["f", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.26"}],

Cell[CellGroupData[{

Cell["Definition[f]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.12.1"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(f[z_] := a\^2 - 2\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ f],
      Editable->False]], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FullDefinition[", "MR"],
  StyleBox["f", "TI"],
  StyleBox["]", "MR"],
  " includes definitions of the objects on which ",
  StyleBox["f", "TI"],
  " depends. "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.27"}],

Cell[CellGroupData[{

Cell["FullDefinition[f]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.12.1"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {GridBox[{
                      {\(f[z_] := a\^2 - 2\)}
                      },
                    GridBaseline->{Baseline, {1, 1}},
                    ColumnWidths->0.999,
                    ColumnAlignments->{Left}]}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnAlignments->{Left}]},
          {" "},
          {GridBox[{
                {GridBox[{
                      {\(a = 2 - x\^2\)}
                      },
                    GridBaseline->{Baseline, {1, 1}},
                    ColumnWidths->0.999,
                    ColumnAlignments->{Left}]}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      FullDefinition[ f],
      Editable->False]], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[TextData[{
  "When you create files for input to ",
  StyleBox["Mathematica", "TI"],
  ", you usually want them to contain only \[OpenCurlyDoubleQuote]plain text\
\[CloseCurlyDoubleQuote], which can be read or modified directly. Sometimes, \
however, you may want the contents of a file to be \
\[OpenCurlyDoubleQuote]encoded\[CloseCurlyDoubleQuote] so that they cannot be \
read or modified directly as plain text, but can be loaded into ",
  StyleBox["Mathematica", "TI"],
  ". You can create encoded files using the ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["Encode", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.1", "1.28"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Encode[\"", "MR"],
              StyleBox["source", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["dest", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "write an encoded version of the file ",
              StyleBox["source", "TI"],
              " to the file ",
              StyleBox["dest", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["<<", "MR"],
              StyleBox["dest", "TI"],
              " "
            }]], Cell["read in an encoded file "]},
          {Cell[TextData[{
              StyleBox["Encode[\"", "MR"],
              StyleBox["source", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["dest", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["key", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["encode with the specified key "]},
          {Cell[TextData[{
              StyleBox["Get[\"", "MR"],
              StyleBox["dest", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["key", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["read in a file that was encoded with a key "]},
          {Cell[TextData[{
              StyleBox["Encode[\"", "MR"],
              StyleBox["source", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["dest", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["MachineID", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["ID", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
create an encoded file which can only be read on a \
machine with a particular ID \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.1"],

Cell["Creating and reading encoded files. ", "Caption",
  CellTags->"S2.12.1"],

Cell[TextData[{
  "This writes an expression in plain text to the file ",
  StyleBox["tmp", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.29"}],

Cell["Factor[x^2 - 1] >> tmp", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.12.1"],

Cell[TextData[{
  "This writes an encoded version of the file ",
  StyleBox["tmp", "MR"],
  " to the file ",
  StyleBox["tmp.x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.30"}],

Cell["Encode[\"tmp\", \"tmp.x\"]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.12.1"],

Cell[TextData[{
  "Here are the contents of the encoded file. The only recognizable part is \
the special ",
  StyleBox["Mathematica", "TI"],
  " comment at the beginning. "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.31"}],

Cell[CellGroupData[{

Cell["!!tmp.x", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.12.1"],

Cell["\<\
(*!1N!*)mcm
_QZ9tcI1cfre*Wo8:) P\
\>", "Print",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[TextData[{
  "Even though the file is encoded, you can still read it into ",
  StyleBox["Mathematica", "TI"],
  " using the ",
  StyleBox["<<", "MR"],
  " operator. "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.32"}],

Cell[CellGroupData[{

Cell["<<tmp.x", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.12.1"],

Cell[BoxData[
    \(\((\(-1\) + x)\)\ \((1 + x)\)\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DumpSave[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox[".mx\",", "MR"],
              " ",
              StyleBox["symbol", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "save definitions for a symbol in internal ",
              StyleBox["Mathematica", "TI"],
              " format "
            }]]},
          {Cell[TextData[{
              StyleBox["DumpSave[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox[".mx\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["context", "TI"],
              StyleBox["`\"]", "MR"],
              " "
            }]], Cell["save definitions for all symbols in a context "]},
          {Cell[TextData[{
              StyleBox["DumpSave[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox[".mx\",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["object",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["object",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["save definitions for several symbols or contexts "]},
          {Cell[TextData[{
              StyleBox["DumpSave[\"", "MR"],
              StyleBox["package", "TI"],
              StyleBox["`\",", "MR"],
              " ",
              StyleBox["objects", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "save definitions in a file with a specially chosen name "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.1"],

Cell[TextData[{
  "Saving definitions in internal ",
  StyleBox["Mathematica", "SO"],
  " format. "
}], "Caption",
  CellTags->"S2.12.1"],

Cell[TextData[{
  "If you have to read in very large or complicated definitions, you will \
often find it more efficient to store these definitions in internal ",
  StyleBox["Mathematica", "TI"],
  " format, rather than as text. You can do this using ",
  StyleBox["DumpSave", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.1", "1.33"}],

Cell[TextData[{
  "This saves the definition for ",
  StyleBox["f", "MR"],
  " in internal ",
  StyleBox["Mathematica", "TI"],
  " format. "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.34"}],

Cell[CellGroupData[{

Cell["DumpSave[\"ffile.mx\", f]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.12.1"],

Cell[BoxData[
    \({f}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[TextData[{
  "You can still use ",
  StyleBox["<<", "MR"],
  " to read the definition in. "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.35"}],

Cell["<<ffile.mx", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.12.1"],

Cell[TextData[{
  StyleBox["<<", "MR"],
  " recognizes when a file contains definitions in internal ",
  StyleBox["Mathematica", "TI"],
  " format, and operates accordingly. One subtlety is that the internal ",
  StyleBox["Mathematica", "TI"],
  " format differs from one computer system to another. As a result, ",
  StyleBox[".mx", "MR"],
  " files created on one computer cannot typically be read on another. "
}], "Text",
  CellTags->{"S2.12.1", "1.36"}],

Cell[TextData[{
  "If you use ",
  StyleBox["DumpSave[\"", "MR"],
  StyleBox["package", "TI"],
  StyleBox["`\",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " then ",
  StyleBox["Mathematica", "TI"],
  " will write out definitions to a file with a name like ",
  StyleBox["package", "TI"],
  StyleBox[".mx/", "MR"],
  StyleBox["system", "TI"],
  StyleBox["/", "MR"],
  StyleBox["package", "TI"],
  StyleBox[".mx", "MR"],
  ", where ",
  StyleBox["system", "TI"],
  " identifies your type of computer system.    "
}], "Text",
  CellTags->{"S2.12.1", "1.37"}],

Cell["\<\
This creates a file with a name that reflects the name of the \
computer system being used. \
\>", "MathCaption",
  CellTags->{"S2.12.1", "1.38"}],

Cell[CellGroupData[{

Cell["DumpSave[\"gffile`\", f]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.12.1"],

Cell[BoxData[
    \({f}\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["<<", "MR"],
  " automatically picks out the file with the appropriate name for your \
computer system. "
}], "MathCaption",
  CellTags->{"S2.12.1", "1.39"}],

Cell["<<gffile`", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.12.2 External Programs", "Subsection",
  CellTags->{"S2.12.2", "2.1"}],

Cell[TextData[{
  "On most computer systems, you can execute external programs or commands \
from within ",
  StyleBox["Mathematica", "TI"],
  ". Often you will want to take expressions you have generated in ",
  StyleBox["Mathematica", "TI"],
  ", and send them to an external program, or take results from external \
programs, and read them into ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.12.2", "2.2"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " supports two basic forms of communication with external programs: ",
  StyleBox["structured", "TI"],
  " and ",
  StyleBox["unstructured", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.12.2", "2.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Structured communication "], Cell[TextData[{
              "use ",
              StyleBox["MathLink", "TI"],
              " to exchange expressions with ",
              StyleBox["MathLink", "TI"],
              "\[Hyphen]compatible external programs "
            }]]},
          {Cell["Unstructured communication "], 
            Cell["\<\
use file reading and writing operations to exchange \
ordinary text \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.2"],

Cell[TextData[{
  "Two kinds of communication with external programs in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.12.2"],

Cell[TextData[{
  "The idea of structured communication is to exchange complete ",
  StyleBox["Mathematica", "TI"],
  " expressions to external programs which are specially set up to handle \
such objects. The basis for structured communication is the ",
  StyleBox["MathLink", "TI"],
  " system, discussed in Section ",
  ButtonBox["2.13",
    ButtonData:>{"2.13"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.12.2", "2.4"}],

Cell["\<\
Unstructured communication consists in sending and receiving \
ordinary text from external programs. The basic idea is to treat an external \
program very much like a file, and to support the same kinds of reading and \
writing operations. \
\>", "Text",
  CellTags->{"S2.12.2", "2.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox[">>", "MR"],
              " ",
              StyleBox["\"!", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell[
            "send the text of an expression to an external program "]},
          {Cell[TextData[{
              StyleBox["<<", "MR"],
              " ",
              StyleBox["\"!", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell[TextData[{
              "read in text from an external program as ",
              StyleBox["Mathematica", "TI"],
              " input "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.2"],

Cell["Reading and writing to external programs. ", "Caption",
  CellTags->"S2.12.2"],

Cell[TextData[{
  "In general, wherever you might use an ordinary file name, ",
  StyleBox["Mathematica", "TI"],
  " allows you instead to give a ",
  StyleBox["pipe", "TI"],
  ", written as an external command, prefaced by an exclamation point. When \
you use the pipe, ",
  StyleBox["Mathematica", "TI"],
  " will execute the external command, and send or receive text from it. "
}], "Text",
  CellTags->{"S2.12.2", "2.6"}],

Cell[TextData[{
  "This sends the result from ",
  StyleBox["FactorInteger", "MR"],
  " to the external program ",
  StyleBox["lpr", "MR"],
  ". On many Unix systems, this program generates a printout. "
}], "MathCaption",
  CellTags->{"S2.12.2", "2.7"}],

Cell["FactorInteger[2^31 - 1] >> !lpr", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.12.2"],

Cell[TextData[{
  "This executes the external command ",
  StyleBox["echo", "MR"],
  " ",
  StyleBox["$TERM", "MR"],
  ", then reads the result as ",
  StyleBox["Mathematica", "TI"],
  " input. "
}], "MathCaption",
  CellTags->{"S2.12.2", "2.8"}],

Cell[CellGroupData[{

Cell["<<\"!echo $TERM\"", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.12.2"],

Cell[BoxData[
    \(dumb\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.12.2"]
}, Open  ]],

Cell[TextData[{
  "One point to notice is that you can get away with dropping the double \
quotes around the name of a pipe on the right\[Hyphen]hand side of ",
  StyleBox["<<", "MR"],
  " or ",
  StyleBox[">>", "MR"],
  " if the name does not contain any spaces or other special characters. "
}], "Text",
  CellTags->{"S2.12.2", "2.9"}],

Cell[TextData[{
  "Pipes in ",
  StyleBox["Mathematica", "TI"],
  " provide a very general mechanism for unstructured communication with \
external programs. On many computer systems, ",
  StyleBox["Mathematica", "TI"],
  " pipes are implemented using pipe mechanisms in the underlying operating \
system; in some cases, however, other interprocess communication mechanisms \
are used. One restriction of unstructured communication in ",
  StyleBox["Mathematica", "TI"],
  " is that a given pipe can only be used for input or for output, and not \
for both at the same time. In order to do genuine two\[Hyphen]way \
communication, you need to use ",
  StyleBox["MathLink", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.12.2", "2.10"}],

Cell["\<\
Even with unstructured communication, you can nevertheless set up \
somewhat more complicated arrangements by using temporary files. The basic \
idea is to write data to a file, then to read it as needed. \
\>", "Text",
  CellTags->{"S2.12.2", "2.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["OpenTemporary[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["open a temporary file with a unique name "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.2"],

Cell["Opening a temporary file. ", "Caption",
  CellTags->"S2.12.2"],

Cell[TextData[{
  "Particularly when you work with temporary files, you may find it useful to \
be able to execute external commands which do not explicitly send or receive \
data from ",
  StyleBox["Mathematica", "TI"],
  ". You can do this using the ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["Run", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.2", "2.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Run[\"", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["arg",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "run an external command from within ",
              StyleBox["Mathematica", "TI"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.2"],

Cell["Running external commands without input or output. ", "Caption",
  CellTags->"S2.12.2"],

Cell[TextData[{
  "This executes the external Unix command ",
  StyleBox["date", "MR"],
  ". The returned value is an \[OpenCurlyDoubleQuote]exit code\
\[CloseCurlyDoubleQuote] from the operating system. "
}], "MathCaption",
  CellTags->{"S2.12.2", "2.13"}],

Cell[CellGroupData[{

Cell["Run[\"date\"]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.12.2"],

Cell[BoxData[
    \("Mon Jun 20 19:06:11 CDT 2005"\)], "Print",
  CellTags->"S2.12.2"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.12.2"]
}, Open  ]],

Cell[TextData[{
  "Note that when you use ",
  StyleBox["Run", "MR"],
  ", you must not preface commands with exclamation points. ",
  StyleBox["Run", "MR"],
  " simply takes the textual forms of the arguments you specify, then joins \
them together with spaces in between, and executes the resulting string as an \
external command. "
}], "Text",
  CellTags->{"S2.12.2", "2.14"}],

Cell[TextData[{
  "It is important to realize that ",
  StyleBox["Run", "MR"],
  " never \[OpenCurlyDoubleQuote]captures\[CloseCurlyDoubleQuote] any of the \
output from an external command. As a result, where this output goes is \
purely determined by your operating system. Similarly, ",
  StyleBox["Run", "MR"],
  " does not supply input to external commands. This means that the commands \
can get input through any mechanism provided by your operating system. \
Sometimes external commands may be able to access the same input and output \
streams that are used by ",
  StyleBox["Mathematica", "TI"],
  " itself. In some cases, this may be what you want. But particularly if you \
are using ",
  StyleBox["Mathematica", "TI"],
  " with a front end, this can cause considerable trouble. "
}], "Text",
  CellTags->{"S2.12.2", "2.15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["!", "MR"],
              StyleBox["command", "TI"],
              " "
            }]], Cell[TextData[{
              "intercept a line of ",
              StyleBox["Mathematica", "TI"],
              " input, and run it as an external command "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.2"],

Cell[TextData[{
  "Shell escapes in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.12.2"],

Cell[TextData[{
  "If you use ",
  StyleBox["Mathematica", "TI"],
  " with a text\[Hyphen]based interface, there is usually a special mechanism \
for executing external commands. With such an interface, ",
  StyleBox["Mathematica", "TI"],
  " takes any line of input that starts with an exclamation point, and \
executes the text on the remainder of the line as an external command. "
}], "Text",
  CellTags->{"S2.12.2", "2.16"}],

Cell[TextData[{
  "The way ",
  StyleBox["Mathematica", "TI"],
  " uses ",
  StyleBox["!", "MR"],
  StyleBox["command", "TI"],
  " is typical of the way \[OpenCurlyDoubleQuote]shell escapes\
\[CloseCurlyDoubleQuote] work in programs running under the Unix operating \
system. In most versions of ",
  StyleBox["Mathematica", "TI"],
  ", you will be able to start an interactive shell from ",
  StyleBox["Mathematica", "TI"],
  " simply by typing a single exclamation point on its own on a line. "
}], "Text",
  CellTags->{"S2.12.2", "2.17"}],

Cell[TextData[{
  "This line is taken as a \[OpenCurlyDoubleQuote]shell escape\
\[CloseCurlyDoubleQuote], and executes the Unix command ",
  StyleBox["date", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.2", "2.18"}],

Cell[CellGroupData[{

Cell["!date", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.12.2"],

Cell[BoxData[
    \("Mon Jun 20 19:06:11 CDT 2005"\)], "Print",
  CellTags->"S2.12.2"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.12.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["RunThrough[\"", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "run ",
              StyleBox["command", "TI"],
              ", using ",
              StyleBox["expr", "TI"],
              " as input, and reading the output back into ",
              StyleBox["Mathematica", "TI"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.2"],

Cell[TextData[{
  "Running ",
  StyleBox["Mathematica", "SO"],
  " expressions through external programs. "
}], "Caption",
  CellTags->"S2.12.2"],

Cell[TextData[{
  "As discussed above, ",
  StyleBox["<<", "MR"],
  " and ",
  StyleBox[">>", "MR"],
  " cannot be used to both send and receive data from an external program at \
the same time. Nevertheless, by using temporary files, you can effectively \
both send and receive data from an external program while still using \
unstructured communication. "
}], "Text",
  CellTags->{"S2.12.2", "2.19"}],

Cell[TextData[{
  "The function ",
  StyleBox["RunThrough", "MR"],
  " writes the text of an expression to a temporary file, then feeds this \
file as input to an external program, and captures the output as input to ",
  StyleBox["Mathematica", "TI"],
  ". Note that in ",
  StyleBox["RunThrough", "MR"],
  ", like ",
  StyleBox["Run", "MR"],
  ", you should not preface the names of external commands with exclamation \
points. "
}], "Text",
  CellTags->{"S2.12.2", "2.20"}],

Cell[TextData[{
  "This feeds the expression ",
  StyleBox["789", "MR"],
  " to the external program ",
  StyleBox["cat", "MR"],
  ", which in this case simply echoes the text of the expression. The output \
from ",
  StyleBox["cat", "MR"],
  " is then read back into ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.2", "2.21"}],

Cell[CellGroupData[{

Cell["RunThrough[\"cat\", 789]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.12.2"],

Cell[BoxData[
    \(789\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.12.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.12.3 Advanced Topic: Streams and Low\[Hyphen]Level Input and \
Output\
\>", "Subsection",
  CellTags->{"S2.12.3", "3.1"}],

Cell[TextData[{
  "Files and pipes are both examples of general ",
  StyleBox["Mathematica", "TI"],
  " objects known as ",
  StyleBox["streams", "TI"],
  ". A stream in ",
  StyleBox["Mathematica", "TI"],
  " is a source of input or output. There are many operations that you can \
perform on streams. "
}], "Text",
  CellTags->{"S2.12.3", "3.2"}],

Cell[TextData[{
  "You can think of ",
  StyleBox[">>", "MR"],
  " and ",
  StyleBox["<<", "MR"],
  " as \[OpenCurlyDoubleQuote]high\[Hyphen]level\[CloseCurlyDoubleQuote] ",
  StyleBox["Mathematica", "TI"],
  " input\[Hyphen]output functions. They are based on a set of \
lower\[Hyphen]level input\[Hyphen]output primitives that work directly with \
streams. By using these primitives, you can exercise more control over \
exactly how ",
  StyleBox["Mathematica", "TI"],
  " does input and output. You will often need to do this, for example, if \
you write ",
  StyleBox["Mathematica", "TI"],
  " programs which store and retrieve intermediate data from files or pipes. \
"
}], "Text",
  CellTags->{"S2.12.3", "3.3"}],

Cell[TextData[{
  "The basic low\[Hyphen]level scheme for writing output to a stream in ",
  StyleBox["Mathematica", "TI"],
  " is as follows. First, you call ",
  StyleBox["OpenWrite", "MR"],
  " or ",
  StyleBox["OpenAppend", "MR"],
  " to \[OpenCurlyDoubleQuote]open the stream\[CloseCurlyDoubleQuote], \
telling ",
  StyleBox["Mathematica", "TI"],
  " that you want to write output to a particular file or external program, \
and in what form the output should be written. Having opened a stream, you \
can then call ",
  StyleBox["Write", "MR"],
  " or ",
  StyleBox["WriteString", "MR"],
  " to write a sequence of expressions or strings to the stream. When you \
have finished, you call ",
  StyleBox["Close", "MR"],
  " to \[OpenCurlyDoubleQuote]close the stream\[CloseCurlyDoubleQuote]. "
}], "Text",
  CellTags->{"S2.12.3", "3.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["a file, specified by name "]},
          {Cell[TextData[{
              StyleBox["\"!", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["a command, specified by name "]},
          {Cell[TextData[{
              StyleBox["InputStream[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["an input stream "]},
          {Cell[TextData[{
              StyleBox["OutputStream[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["an output stream "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.3"],

Cell[TextData[{
  "Streams in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.12.3"],

Cell[TextData[{
  "When you open a file or a pipe, ",
  StyleBox["Mathematica", "TI"],
  " creates a \[OpenCurlyDoubleQuote]stream object\[CloseCurlyDoubleQuote] \
that specifies the open stream associated with the file or pipe. In general, \
the stream object contains the name of the file or the external command used \
in a pipe, together with a unique number. "
}], "Text",
  CellTags->{"S2.12.3", "3.5"}],

Cell["\<\
The reason that the stream object needs to include a unique number \
is that in general you can have several streams connected to the same file or \
external program at the same time. For example, you may start several \
different instances of the same external program, each connected to a \
different stream. \
\>", "Text",
  CellTags->{"S2.12.3", "3.6"}],

Cell["\<\
Nevertheless, when you have opened a stream, you can still refer to \
it using a simple file name or external command name so long as there is only \
one stream associated with this object. \
\>", "Text",
  CellTags->{"S2.12.3", "3.7"}],

Cell[TextData[{
  "This opens an output stream to the file ",
  StyleBox["tmp", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.3", "3.8"}],

Cell[CellGroupData[{

Cell["stmp = OpenWrite[\"tmp\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.12.3"],

Cell[BoxData[
    \(OutputStream["tmp", 20]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell["This writes a sequence of expressions to the file. ", "MathCaption",
  CellTags->{"S2.12.3", "3.9"}],

Cell["Write[stmp, a, b, c]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.12.3"],

Cell[TextData[{
  "Since you only have one stream associated with file ",
  StyleBox["tmp", "MR"],
  ", you can refer to it simply by giving the name of the file. "
}], "MathCaption",
  CellTags->{"S2.12.3", "3.10"}],

Cell["Write[\"tmp\", x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.12.3"],

Cell["This closes the stream. ", "MathCaption",
  CellTags->{"S2.12.3", "3.11"}],

Cell[CellGroupData[{

Cell["Close[stmp]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.12.3"],

Cell[BoxData[
    \("tmp"\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell["Here is what was written to the file. ", "MathCaption",
  CellTags->{"S2.12.3", "3.12"}],

Cell[CellGroupData[{

Cell["!!tmp", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.12.3"],

Cell["\<\
abc
x\
\>", "Print",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["OpenWrite[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
open an output stream to a file, wiping out the \
previous contents of the file \
\>"]},
          {Cell[TextData[{
              StyleBox["OpenAppend[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
open an output stream to a file, appending to what was \
already in the file \
\>"]},
          {Cell[TextData[{
              StyleBox["OpenWrite[\"!", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["open an output stream to an external command "]},
          {Cell[TextData[{
              StyleBox["Write[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
write a sequence of expressions to a stream, ending the \
output with a newline (line feed) \
\>"]},
          {Cell[TextData[{
              StyleBox["WriteString[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["str",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["str",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
write a sequence of character strings to a stream, with \
no extra newlines \
\>"]},
          {Cell[TextData[{
              StyleBox["Display[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["graphics", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
write graphics or sound output to a stream, in \
PostScript form \
\>"]},
          {Cell[TextData[{
              StyleBox["Close[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "tell ",
              StyleBox["Mathematica", "TI"],
              " that you are finished with a stream "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.3"],

Cell["Low\[Hyphen]level output functions. ", "Caption",
  CellTags->"S2.12.3"],

Cell[TextData[{
  "When you call ",
  StyleBox["Write[", "MR"],
  StyleBox["stream", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  ", it writes an expression to the specified stream. The default is to write \
the expression in ",
  StyleBox["Mathematica", "TI"],
  " input form. If you call ",
  StyleBox["Write", "MR"],
  " with a sequence of expressions, it will write these expressions one after \
another to the stream. In general, it leaves no space between the successive \
expressions. However, when it has finished writing all the expressions, ",
  StyleBox["Write", "MR"],
  " always ends its output with a newline. "
}], "Text",
  CellTags->{"S2.12.3", "3.13"}],

Cell[TextData[{
  "This re\[Hyphen]opens the file ",
  StyleBox["tmp", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.3", "3.14"}],

Cell[CellGroupData[{

Cell["stmp = OpenWrite[\"tmp\"]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.12.3"],

Cell[BoxData[
    \(OutputStream["tmp", 21]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell["\<\
This writes a sequence of expressions to the file, then closes the \
file. \
\>", "MathCaption",
  CellTags->{"S2.12.3", "3.15"}],

Cell[CellGroupData[{

Cell["Write[stmp, a^2, 1 + b^2]; Write[stmp, c^3]; Close[stmp]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.12.3"],

Cell[BoxData[
    \("tmp"\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell[TextData[{
  "All the expressions are written in input form. The expressions from a \
single ",
  StyleBox["Write", "MR"],
  " are put on the same line. "
}], "MathCaption",
  CellTags->{"S2.12.3", "3.16"}],

Cell[CellGroupData[{

Cell["!!tmp", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.12.3"],

Cell["\<\
a^21 + b^2
c^3\
\>", "Print",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Write", "MR"],
  " provides a way of writing out complete ",
  StyleBox["Mathematica", "TI"],
  " expressions. Sometimes, however, you may want to write out less \
structured data. ",
  StyleBox["WriteString", "MR"],
  " allows you to write out any character string. Unlike ",
  StyleBox["Write", "MR"],
  ", ",
  StyleBox["WriteString", "MR"],
  " adds no newlines or other characters. "
}], "Text",
  CellTags->{"S2.12.3", "3.17"}],

Cell["This opens the stream. ", "MathCaption",
  CellTags->{"S2.12.3", "3.18"}],

Cell[CellGroupData[{

Cell["stmp = OpenWrite[\"tmp\"]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.12.3"],

Cell[BoxData[
    \(OutputStream["tmp", 22]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell["This writes two strings to the stream. ", "MathCaption",
  CellTags->{"S2.12.3", "3.19"}],

Cell["WriteString[stmp, \"Arbitrary output.\\n\", \"More output.\"]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.12.3"],

Cell["This writes another string, then closes the stream. ", "MathCaption",
  CellTags->{"S2.12.3", "3.20"}],

Cell[CellGroupData[{

Cell["WriteString[stmp, \" Second line.\\n\"]; Close[stmp]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.12.3"],

Cell[BoxData[
    \("tmp"\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell["\<\
Here are the contents of the file. The strings were written exactly \
as specified, including only the newlines that were explicitly given. \
\>", \
"MathCaption",
  CellTags->{"S2.12.3", "3.21"}],

Cell[CellGroupData[{

Cell["!!tmp", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.12.3"],

Cell["\<\
Arbitrary output.
More output.  Second line.\
\>", "Print",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Write[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["stream",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["stream",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] ]",
              StyleBox[" ", "TR"]
            }]], Cell["write expressions to a list of streams "]},
          {Cell[TextData[{
              StyleBox["WriteString[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["stream",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["stream",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["str",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] ]",
              StyleBox[" ", "TR"]
            }]], Cell["write strings to a list of streams "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.3"],

Cell["Writing output to lists of streams. ", "Caption",
  CellTags->"S2.12.3"],

Cell[TextData[{
  "An important feature of the functions ",
  StyleBox["Write", "MR"],
  " and ",
  StyleBox["WriteString", "MR"],
  " is that they allow you to write output not just to a single stream, but \
also to a list of streams. "
}], "Text",
  CellTags->{"S2.12.3", "3.22"}],

Cell[TextData[{
  "In using ",
  StyleBox["Mathematica", "TI"],
  ", it is often convenient to define a ",
  StyleBox["channel", "TI"],
  " which consists of a list of streams. You can then simply tell ",
  StyleBox["Mathematica", "TI"],
  " to write to the channel, and have it automatically write the same object \
to several streams. "
}], "Text",
  CellTags->{"S2.12.3", "3.23"}],

Cell[TextData[{
  "In a standard interactive ",
  StyleBox["Mathematica", "TI"],
  " session, there are several output channels that are usually defined. \
These specify where particular kinds of output should be sent. Thus, for \
example, ",
  StyleBox["$Output", "MR"],
  " specifies where standard output should go, while ",
  StyleBox["$Messages", "MR"],
  " specifies where messages should go. The function ",
  StyleBox["Print", "MR"],
  " then works essentially by calling ",
  StyleBox["Write", "MR"],
  " with the ",
  StyleBox["$Output", "MR"],
  " channel. ",
  StyleBox["Message", "MR"],
  " works in the same way by calling ",
  StyleBox["Write", "MR"],
  " with the ",
  StyleBox["$Messages", "MR"],
  " channel. Section\[NonBreakingSpace]",
  ButtonBox["2.14.1",
    ButtonData:>{"2.14.1", "1.30"},
    ButtonStyle->"MainBookLink"],
  " lists the channels used in a typical ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Text",
  CellTags->{"S2.12.3", "3.24"}],

Cell[TextData[{
  "Note that when you run ",
  StyleBox["Mathematica", "TI"],
  " through ",
  StyleBox["MathLink", "TI"],
  ", a different approach is usually used. All output is typically written to \
a single ",
  StyleBox["MathLink", "TI"],
  " link, but each piece of output appears in a \[OpenCurlyDoubleQuote]packet\
\[CloseCurlyDoubleQuote] which indicates what type it is. "
}], "Text",
  CellTags->{"S2.12.3", "3.25"}],

Cell[TextData[{
  "In most cases, the names of files or external commands that you use in ",
  StyleBox["Mathematica", "TI"],
  " correspond exactly with those used by your computer's operating system. \
On some systems, however, ",
  StyleBox["Mathematica", "TI"],
  " supports various streams with special names. "
}], "Text",
  CellTags->{"S2.12.3", "3.26"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"stdout\"", "MR"],
              " "
            }]], Cell["standard output "]},
          {Cell[TextData[{
              StyleBox["\"stderr\"", "MR"],
              " "
            }]], Cell["standard error "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.3"],

Cell["Special streams used on some computer systems. ", "Caption",
  CellTags->"S2.12.3"],

Cell[TextData[{
  "The special stream ",
  StyleBox["\"stdout\"", "MR"],
  " allows you to give output to the \[OpenCurlyDoubleQuote]standard output\
\[CloseCurlyDoubleQuote] provided by the operating system. Note however that \
you can use this stream only with simple text\[Hyphen]based interfaces to ",
  StyleBox["Mathematica", "TI"],
  ". If your interaction with ",
  StyleBox["Mathematica", "TI"],
  " is more complicated, then this stream will not work, and trying to use it \
may cause considerable trouble. "
}], "Text",
  CellTags->{"S2.12.3", "3.27"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["FormatType", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["InputForm", "MR"],
              " "
            }]], Cell["the default output format to use "]},
          {Cell[TextData[{
              StyleBox["PageWidth", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["78", "MR"],
              " "
            }]], Cell["the width of the page in characters "]},
          {Cell[TextData[{
              StyleBox["NumberMarks", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["$NumberMarks", "MR"],
              " "
            }]], Cell[TextData[{
              "whether to include ",
              StyleBox["`", "MR"],
              " marks in approximate numbers "
            }]]},
          {Cell[TextData[{
              StyleBox["CharacterEncoding", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["$CharacterEncoding", "MR"],
              " "
            }]], Cell["encoding to be used for special characters "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.12.3"],

Cell["Some options for output streams. ", "Caption",
  CellTags->"S2.12.3"],

Cell[TextData[{
  "You can associate a number of options with output streams. You can specify \
these options when you first open a stream using ",
  StyleBox["OpenWrite", "MR"],
  " or ",
  StyleBox["OpenAppend", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.3", "3.28"}],

Cell[TextData[{
  "This opens a stream, specifying that the default output format used should \
be ",
  StyleBox["OutputForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.3", "3.29"}],

Cell[CellGroupData[{

Cell["stmp = OpenWrite[\"tmp\", FormatType -> OutputForm]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.12.3"],

Cell[BoxData[
    \(OutputStream["tmp", 23]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell["\<\
This writes expressions to the stream, then closes the stream. \
\
\>", "MathCaption",
  CellTags->{"S2.12.3", "3.30"}],

Cell[CellGroupData[{

Cell["Write[stmp, x^2 + y^2, \" \", z^2]; Close[stmp]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.12.3"],

Cell[BoxData[
    \("tmp"\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell[TextData[{
  "The expressions were written to the stream in ",
  StyleBox["OutputForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.3", "3.31"}],

Cell[CellGroupData[{

Cell["!!tmp", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.12.3"],

Cell["\<\
 2    2       2
x  + y       z\
\>", "Print",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell[TextData[{
  "Note that you can always override the output format specified for a \
particular stream by wrapping a particular expression you write to the stream \
with an explicit ",
  StyleBox["Mathematica", "TI"],
  " format directive, such as ",
  StyleBox["OutputForm", "MR"],
  " or ",
  StyleBox["TeXForm", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.3", "3.32"}],

Cell[TextData[{
  "The option ",
  StyleBox["PageWidth", "MR"],
  " gives the width of the page available for textual output from ",
  StyleBox["Mathematica", "TI"],
  ". All lines of output are broken so that they fit in this width. If you do \
not want any lines to be broken, you can set ",
  StyleBox["PageWidth", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Infinity", "MR"],
  ". Usually, however, you will want to set ",
  StyleBox["PageWidth", "MR"],
  " to the value appropriate for your particular output device. On many \
systems, you will have to run an external program to find out what this value \
is. Using ",
  StyleBox["SetOptions", "MR"],
  ", you can make the default rule for ",
  StyleBox["PageWidth", "MR"],
  " be, for example, ",
  StyleBox["PageWidth", "MR"],
  " ",
  StyleBox[":>", "MR"],
  " ",
  StyleBox["<<\"!devicewidth\"", "MR"],
  ", so that an external program is run automatically to find the value of \
the option. "
}], "Text",
  CellTags->{"S2.12.3", "3.33"}],

Cell["\<\
This opens a stream, specifying that the page width is 20 \
characters. \
\>", "MathCaption",
  CellTags->{"S2.12.3", "3.34"}],

Cell[CellGroupData[{

Cell["stmp = OpenWrite[\"tmp\", PageWidth -> 20]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.12.3"],

Cell[BoxData[
    \(OutputStream["tmp", 24]\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell["This writes out an expression, then closes the stream. ", "MathCaption",
  CellTags->{"S2.12.3", "3.35"}],

Cell[CellGroupData[{

Cell["Write[stmp, Expand[(1 + x)^5]]; Close[stmp]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.12.3"],

Cell[BoxData[
    \("tmp"\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell["\<\
The lines in the expression written out are all broken so as to be \
at most 20 characters long. \
\>", "MathCaption",
  CellTags->{"S2.12.3", "3.36"}],

Cell[CellGroupData[{

Cell["!!tmp", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.12.3"],

Cell["\<\
1 + 5*x + 10*x^2 + 
 10*x^3 + 5*x^4 + 
 x^5\
\>", "Print",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell[TextData[{
  "The option ",
  StyleBox["CharacterEncoding", "MR"],
  " allows you to specify a character encoding that will be used for all \
strings containing special characters which are sent to a particular output \
stream, whether by ",
  StyleBox["Write", "MR"],
  " or ",
  StyleBox["WriteString", "MR"],
  ". You will typically need to use ",
  StyleBox["CharacterEncoding", "MR"],
  " if you want to modify an international character set, or prevent a \
particular output device from receiving characters that it cannot handle. "
}], "Text",
  CellTags->{"S2.12.3", "3.37"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["find the options that have been set for a stream "]},
          {Cell[TextData[{
              StyleBox["SetOptions[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["opt",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["val",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["reset options for an open stream "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.3"],

Cell["Manipulating options of streams. ", "Caption",
  CellTags->"S2.12.3"],

Cell["This opens a stream with the default settings for options. ", \
"MathCaption",
  CellTags->{"S2.12.3", "3.38"}],

Cell[CellGroupData[{

Cell["stmp = OpenWrite[\"tmp\"]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.12.3"],

Cell[BoxData[
    \(OutputStream["tmp", 25]\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell[TextData[{
  "This changes the ",
  StyleBox["FormatType", "MR"],
  " option for the open stream. "
}], "MathCaption",
  CellTags->{"S2.12.3", "3.39"}],

Cell["SetOptions[stmp, FormatType -> TeXForm];", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.12.3"],

Cell[TextData[{
  StyleBox["Options", "MR"],
  " shows the options you have set for the open stream. "
}], "MathCaption",
  CellTags->{"S2.12.3", "3.40"}],

Cell[CellGroupData[{

Cell["Options[stmp]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.12.3"],

Cell[BoxData[
    \({BinaryFormat \[Rule] False, FormatType \[Rule] TeXForm, 
      PageWidth \[Rule] 78, PageHeight \[Rule] 22, 
      TotalWidth \[Rule] \[Infinity], TotalHeight \[Rule] \[Infinity], 
      CharacterEncoding \[RuleDelayed] Automatic, 
      NumberMarks \[RuleDelayed] $NumberMarks}\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell["This closes the stream again. ", "MathCaption",
  CellTags->{"S2.12.3", "3.41"}],

Cell[CellGroupData[{

Cell["Close[stmp]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.12.3"],

Cell[BoxData[
    \("tmp"\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.12.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Options[$Output]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the options set for all streams in the channel ",
              StyleBox["$Output", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SetOptions[$Output,", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["opt",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["val",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "set options for all streams in the channel ",
              StyleBox["$Output", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.3"],

Cell["Manipulating options for the standard output channel. ", "Caption",
  CellTags->"S2.12.3"],

Cell[TextData[{
  "At every point in your session, ",
  StyleBox["Mathematica", "TI"],
  " maintains a list ",
  StyleBox["Streams[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " of all the input and output streams that are currently open, together \
with their options. In some cases, you may find it useful to look at this \
list directly. ",
  StyleBox["Mathematica", "TI"],
  " will not, however, allow you to modify the list, except indirectly \
through ",
  StyleBox["OpenRead", "MR"],
  " and so on. "
}], "Text",
  CellTags->{"S2.12.3", "3.42"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.12.4 Naming and Finding Files", "Subsection",
  CellTags->{"S2.12.4", "4.1"}],

Cell[TextData[{
  "The precise details of the naming of files differ from one computer system \
to another. Nevertheless, ",
  StyleBox["Mathematica", "TI"],
  " provides some fairly general mechanisms that work on all systems. "
}], "Text",
  CellTags->{"S2.12.4", "4.2"}],

Cell[TextData[{
  "As mentioned in Section ",
  ButtonBox["1.11.2",
    ButtonData:>{"1.11.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " assumes that all your files are arranged in a hierarchy of ",
  StyleBox["directories", "TI"],
  ". To find a particular file, ",
  StyleBox["Mathematica", "TI"],
  " must know both what the name of the file is, and what sequence of \
directories it is in. "
}], "Text",
  CellTags->{"S2.12.4", "4.3"}],

Cell[TextData[{
  "At any given time, however, you have a ",
  StyleBox["current working directory", "TI"],
  ", and you can refer to files or other directories by specifying where they \
are relative to this directory. Typically you can refer to files or \
directories that are actually ",
  StyleBox["in", "TI"],
  " this directory simply by giving their names, with no directory \
information. "
}], "Text",
  CellTags->{"S2.12.4", "4.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Directory[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["your current working directory "]},
          {Cell[TextData[{
              StyleBox["SetDirectory[\"", "MR"],
              StyleBox["dir", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["set your current working directory "]},
          {Cell[TextData[{
              StyleBox["ResetDirectory[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["revert to your previous working directory "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.4"],

Cell["Manipulating directories. ", "Caption",
  CellTags->"S2.12.4"],

Cell["\<\
This gives a string representing your current working directory. \
\
\>", "MathCaption",
  CellTags->{"S2.12.4", "4.5"}],

Cell[CellGroupData[{

Cell["Directory[ ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.12.4"],

Cell["/users/sw", "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.12.4"]
}, Open  ]],

Cell[TextData[{
  "This sets your current working directory to be the ",
  StyleBox["Packages", "MR"],
  " subdirectory. "
}], "MathCaption",
  CellTags->{"S2.12.4", "4.6"}],

Cell[CellGroupData[{

Cell["SetDirectory[\"Packages\"]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.12.4"],

Cell["/users/sw/Packages", "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.12.4"]
}, Open  ]],

Cell["Now your current working directory is different. ", "MathCaption",
  CellTags->{"S2.12.4", "4.7"}],

Cell[CellGroupData[{

Cell["Directory[ ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.12.4"],

Cell["/users/sw/Packages", "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.12.4"]
}, Open  ]],

Cell["This reverts to your previous working directory. ", "MathCaption",
  CellTags->{"S2.12.4", "4.8"}],

Cell[CellGroupData[{

Cell["ResetDirectory[ ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.12.4"],

Cell["/users/sw", "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.12.4"]
}, Open  ]],

Cell[TextData[{
  "When you call ",
  StyleBox["SetDirectory", "MR"],
  ", you can give any directory name that is recognized by your operating \
system. Thus, for example, on Unix\[Hyphen]based systems, you can specify a \
directory one level up in the directory hierarchy using the notation ",
  StyleBox["..", "MR"],
  ", and you can specify your \[OpenCurlyDoubleQuote]home\
\[CloseCurlyDoubleQuote] directory as ",
  StyleBox["~", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.4", "4.9"}],

Cell[TextData[{
  "Whenever you go to a new directory using ",
  StyleBox["SetDirectory", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " always remembers what the previous directory was. You can return to this \
previous directory using ",
  StyleBox["ResetDirectory", "MR"],
  ". In general, ",
  StyleBox["Mathematica", "TI"],
  " maintains a stack of directories, given by ",
  StyleBox["DirectoryStack[", "MR"],
  " ",
  StyleBox["]", "MR"],
  ". Every time you call ",
  StyleBox["SetDirectory", "MR"],
  ", it adds a new directory to the stack, and every time you call ",
  StyleBox["ResetDirectory", "MR"],
  " it removes a directory from the stack. "
}], "Text",
  CellTags->{"S2.12.4", "4.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ParentDirectory[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["the parent of your current working directory "]},
          {Cell[TextData[{
              StyleBox["$InitialDirectory", "MR"],
              " "
            }]], Cell[TextData[{
              "the initial directory when ",
              StyleBox["Mathematica", "TI"],
              " was started "
            }]]},
          {Cell[TextData[{
              StyleBox["$HomeDirectory", "MR"],
              " "
            }]], Cell["your home directory, if this is defined "]},
          {Cell[TextData[{
              StyleBox["$BaseDirectory", "MR"],
              " "
            }]], Cell[TextData[{
              
              "the base directory for system\[Hyphen]wide files to be loaded \
by ",
              StyleBox["Mathematica", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["$UserBaseDirectory", "MR"],
              " "
            }]], Cell[TextData[{
              
              "the base directory for user\[Hyphen]specific files to be \
loaded by ",
              StyleBox["Mathematica", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["$InstallationDirectory", "MR"],
              " "
            }]], Cell[TextData[{
              "the top\[Hyphen]level directory in which your ",
              StyleBox["Mathematica", "TI"],
              " installation resides "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.4"],

Cell["Special directories. ", "Caption",
  CellTags->"S2.12.4"],

Cell[TextData[{
  "Whenever you ask for a particular file, ",
  StyleBox["Mathematica", "TI"],
  " in general goes through several steps to try and find the file you want. \
The first step is to use whatever standard mechanisms exist in your operating \
system or shell. "
}], "Text",
  CellTags->{"S2.12.4", "4.11"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " scans the full name you give for a file, and looks to see whether it \
contains any of the \[OpenCurlyDoubleQuote]metacharacters\
\[CloseCurlyDoubleQuote] ",
  StyleBox["*", "MR"],
  ", ",
  StyleBox["$", "MR"],
  ", ",
  StyleBox["~", "MR"],
  ", ",
  StyleBox["?", "MR"],
  ", ",
  StyleBox["[", "MR"],
  ", ",
  StyleBox["\"", "MR"],
  ", \[Backslash] and ",
  StyleBox["'", "MR"],
  ". If it finds such characters, then it passes the full name to your \
operating system or shell for interpretation. This means that if you are \
using a Unix\[Hyphen]based system, then constructions like ",
  StyleBox["name", "TI"],
  StyleBox["*", "MR"],
  " and ",
  StyleBox["$", "MR"],
  StyleBox["VAR", "TI"],
  " will be expanded at this point. But in general, ",
  StyleBox["Mathematica", "TI"],
  " takes whatever was returned by your operating system or shell, and treats \
this as the full file name. "
}], "Text",
  CellTags->{"S2.12.4", "4.12"}],

Cell[TextData[{
  "For output files, this is the end of the processing that ",
  StyleBox["Mathematica", "TI"],
  " does. If ",
  StyleBox["Mathematica", "TI"],
  " cannot find a unique file with the name you specified, then it will \
proceed to create the file. "
}], "Text",
  CellTags->{"S2.12.4", "4.13"}],

Cell[TextData[{
  "If you are trying to get input from a file, however, then there is another \
round of processing that ",
  StyleBox["Mathematica", "TI"],
  " does. What happens is that ",
  StyleBox["Mathematica", "TI"],
  " looks at the value of the ",
  StyleBox["Path", "MR"],
  " option for the function you are using to determine the names of \
directories relative to which it should search for the file. The default \
setting for the ",
  StyleBox["Path", "MR"],
  " option is the global variable ",
  StyleBox["$Path", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.4", "4.14"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Get[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["Path", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["dir",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["dir",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "get a file, searching for it relative to the directories ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["dir",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["$Path", "MR"],
              " "
            }]], 
            Cell["\<\
default list of directories relative to which to search \
for input files \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.4"],

Cell["Search path for files. ", "Caption",
  CellTags->"S2.12.4"],

Cell[TextData[{
  "In general, the global variable ",
  StyleBox["$Path", "MR"],
  " is defined to be a list of strings, with each string representing a \
directory. Every time you ask for an input file, what ",
  StyleBox["Mathematica", "TI"],
  " effectively does is temporarily to make each of these directories in turn \
your current working directory, and then from that directory to try and find \
the file you have requested. "
}], "Text",
  CellTags->{"S2.12.4", "4.15"}],

Cell[TextData[{
  "Here is a typical setting for ",
  StyleBox["$Path", "MR"],
  ". The current directory (",
  StyleBox[".", "MR"],
  ") and your home directory (",
  StyleBox["~", "MR"],
  ") are listed first. "
}], "MathCaption",
  CellTags->{"S2.12.4", "4.16"}],

Cell[CellGroupData[{

Cell["$Path", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.12.4"],

Cell["{., ~, /users/math/bin, /users/math/Packages}", "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.12.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FileNames[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["list all files in your current working directory "]},
          {Cell[TextData[{
              StyleBox["FileNames[\"", "MR"],
              StyleBox["form", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "list all files in your current working directory whose names \
match the string pattern ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FileNames[{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["form",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["form",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "list all files whose names match any of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["form",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FileNames[", "MR"],
              StyleBox["forms", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["dir",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["dir",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the full names of all files whose names match ",
              StyleBox["forms", "TI"],
              " in any of the directories ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["dir",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FileNames[", "MR"],
              StyleBox["forms", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dirs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "include files that are in subdirectories up to ",
              StyleBox["n", "TI"],
              " levels down "
            }]]},
          {Cell[TextData[{
              StyleBox["FileNames[", "MR"],
              StyleBox["forms", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dirs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Infinity]", "MR"],
              " "
            }]], Cell["include files in all subdirectories "]},
          {Cell[TextData[{
              StyleBox["FileNames[", "MR"],
              StyleBox["forms", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["$Path,", "MR"],
              " ",
              StyleBox["Infinity]", "MR"],
              " "
            }]], Cell[TextData[{
              "give all files whose names match ",
              StyleBox["forms", "TI"],
              " in any subdirectory of the directories in ",
              StyleBox["$Path", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.4"],

Cell["Getting lists of files in particular directories. ", "Caption",
  CellTags->"S2.12.4"],

Cell[TextData[{
  "Here is a list of all files in the current working directory whose names \
end with ",
  StyleBox[".m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.4", "4.17"}],

Cell[CellGroupData[{

Cell["FileNames[\"*.m\"]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.12.4"],

Cell["{alpha.m, control.m, signals.m, test.m}", "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.12.4"]
}, Open  ]],

Cell[TextData[{
  "This lists files whose names start with ",
  StyleBox["a", "MR"],
  " in the current directory, and in subdirectories with names that start \
with ",
  StyleBox["P", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.4", "4.18"}],

Cell[CellGroupData[{

Cell["FileNames[\"a*\", {\".\", \"P*\"}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.12.4"],

Cell["\<\
{alpha.m, Packages/astrodata, Packages/astro.m,

  Previous/atmp}\
\>", "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.12.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FileNames", "MR"],
  " returns a list of strings corresponding to file names. When it returns a \
file that is not in your current directory, it gives the name of the file \
relative to the current directory. Note that all names are given in the \
format appropriate for the particular computer system on which they were \
generated. "
}], "Text",
  CellTags->{"S2.12.4", "4.19"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DirectoryName[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["extract the directory name from a file name "]},
          {Cell[TextData[{
              StyleBox["ToFileName[\"", "MR"],
              StyleBox["directory", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
assemble a full file name from a directory name and a \
file name \
\>"]},
          {Cell[TextData[{
              StyleBox["ParentDirectory[\"", "MR"],
              StyleBox["directory", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["give the parent of a directory "]},
          {Cell[TextData[{
              StyleBox["ToFileName[{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["dir",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["dir",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
assemble a full file name from a hierarchy of directory \
names \
\>"]},
          {Cell[TextData[{
              StyleBox["ToFileName[{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["dir",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["dir",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], 
            Cell["\<\
assemble a single directory name from a hierarchy of \
directory names \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.4"],

Cell["Manipulating file names. ", "Caption",
  CellTags->"S2.12.4"],

Cell[TextData[{
  "You should realize that different computer systems may give file names in \
different ways. Thus, for example, Windows systems typically give names in \
the form ",
  StyleBox["dir", "TI"],
  StyleBox[":\[Backslash]", "MR"],
  StyleBox["dir", "TI"],
  "\[Backslash]",
  StyleBox["#dir\[Backslash]#name", "MR"],
  ", Unix systems in the form ",
  StyleBox["dir", "TI"],
  StyleBox["/", "MR"],
  StyleBox["dir", "TI"],
  StyleBox["/", "MR"],
  StyleBox["name", "TI"],
  " and Macintosh systems in the form ",
  StyleBox[":", "MR"],
  StyleBox["dir", "TI"],
  StyleBox[":", "MR"],
  StyleBox["dir", "TI"],
  StyleBox[":", "MR"],
  StyleBox["name", "TI"],
  ". The function ",
  StyleBox["ToFileName", "MR"],
  " assembles file names in the appropriate way for the particular computer \
system you are using.  "
}], "Text",
  CellTags->{"S2.12.4", "4.20"}],

Cell["This gives the directory portion of the file name. ", "MathCaption",
  CellTags->{"S2.12.4", "4.21"}],

Cell[CellGroupData[{

Cell["DirectoryName[\"Packages/Math/test.m\"]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.12.4"],

Cell[BoxData[
    \("Packages/Math/"\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.12.4"]
}, Open  ]],

Cell[TextData[{
  "This constructs the full name of another file in the same directory as ",
  StyleBox["test.m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.4", "4.22"}],

Cell[CellGroupData[{

Cell["ToFileName[%, \"abc.m\"]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.12.4"],

Cell[BoxData[
    \("Packages/Math/abc.m"\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.12.4"]
}, Open  ]],

Cell[TextData[{
  "If you want to set up a collection of related files, it is often \
convenient to be able to refer to one file when you are reading another one. \
The global variable ",
  StyleBox["$Input", "MR"],
  " gives the name of the file from which input is currently being taken. \
Using ",
  StyleBox["DirectoryName", "MR"],
  " and ",
  StyleBox["ToFileName", "MR"],
  " you can then conveniently specify the names of other related files.  "
}], "Text",
  CellTags->{"S2.12.4", "4.23"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$Input", "MR"],
              " "
            }]], 
            Cell["\<\
the name of the file or stream from which input is \
currently being taken \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.4"],

Cell[TextData[{
  "Finding out how to refer to a file currently being read by ",
  StyleBox["Mathematica", "SO"],
  "."
}], "Caption",
  CellTags->"S2.12.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.12.5 Files for Packages", "Subsection",
  CellTags->{"S2.12.5", "5.1"}],

Cell[TextData[{
  "When you create or use ",
  StyleBox["Mathematica", "TI"],
  " packages, you will often want to refer to files in a \
system\[Hyphen]independent way. You can use contexts to do this. "
}], "Text",
  CellTags->{"S2.12.5", "5.2"}],

Cell[TextData[{
  "The basic idea is that on every computer system there is a convention \
about how files corresponding to ",
  StyleBox["Mathematica", "TI"],
  " contexts should be named. Then, when you refer to a file using a context, \
the particular version of ",
  StyleBox["Mathematica", "TI"],
  " you are using converts the context name to the file name appropriate for \
the computer system you are on. "
}], "Text",
  CellTags->{"S2.12.5", "5.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["<<", "MR"],
              StyleBox["context", "TI"],
              StyleBox["`", "MR"],
              " "
            }]], Cell[
            "read in the file corresponding to the specified context "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.5"],

Cell["Using contexts to specify files. ", "Caption",
  CellTags->"S2.12.5"],

Cell[TextData[{
  "This reads in one of the standard packages that come with ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.5", "5.4"}],

Cell["<<Graphics`Colors`", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.12.5"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox[".mx", "MR"],
              " "
            }]], Cell[TextData[{
              "file in ",
              StyleBox["DumpSave", "MR"],
              " format "
            }]]},
          {Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox[".mx/$SystemID/", "MR"],
              StyleBox["name", "TI"],
              StyleBox[".mx", "MR"],
              " "
            }]], Cell[TextData[{
              "file in ",
              StyleBox["DumpSave", "MR"],
              " format for your computer system "
            }]]},
          {Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox[".m", "MR"],
              " "
            }]], Cell[TextData[{
              "file in ",
              StyleBox["Mathematica", "TI"],
              " source format "
            }]]},
          {Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox["/init.m", "MR"],
              " "
            }]], Cell["initialization file for a particular directory "]},
          {Cell[TextData[{
              StyleBox["dir", "TI"],
              StyleBox["/", "MR"],
              "\[Ellipsis]",
              " ",
              " "
            }]], Cell[TextData[{
              "files in other directories specified by ",
              StyleBox["$Path", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.5"],

Cell[TextData[{
  "The typical sequence of files looked for by ",
  StyleBox["<<", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.12.5"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " is set up so that ",
  StyleBox["<<", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`", "MR"],
  " will automatically try to load the appropriate version of a file. It will \
first try to load a ",
  StyleBox["name", "TI"],
  StyleBox[".mx", "MR"],
  " file that is optimized for your particular computer system. If it finds \
no such file, then it will try to load a ",
  StyleBox["name", "TI"],
  StyleBox[".m", "MR"],
  " file containing ordinary system\[Hyphen]independent ",
  StyleBox["Mathematica", "TI"],
  " input. "
}], "Text",
  CellTags->{"S2.12.5", "5.5"}],

Cell[TextData[{
  "If ",
  StyleBox["name", "TI"],
  " is a directory, then ",
  StyleBox["Mathematica", "TI"],
  " will try to load the initialization file ",
  StyleBox["init.m", "MR"],
  " in that directory. The purpose of the ",
  StyleBox["init.m", "MR"],
  " file is to provide a convenient way to set up ",
  StyleBox["Mathematica", "TI"],
  " packages that involve many separate files. The idea is to allow you to \
give just the command ",
  StyleBox["<<", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`", "MR"],
  ", but then to load ",
  StyleBox["init.m", "MR"],
  " to initialize the whole package, reading in whatever other files are \
necessary.  "
}], "Text",
  CellTags->{"S2.12.5", "5.6"}],

Cell[TextData[{
  "This reads in the file ",
  StyleBox["Graphics/init.m", "MR"],
  ", which initializes all standard ",
  StyleBox["Mathematica", "TI"],
  " graphics packages. "
}], "MathCaption",
  CellTags->{"S2.12.5", "5.7"}],

Cell["<<Graphics`", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.12.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.12.6 Manipulating Files and Directories", "Subsection",
  CellTags->{"S2.12.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CopyFile[\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "copy ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["RenameFile[\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " the name ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["DeleteFile[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["delete a file "]},
          {Cell[TextData[{
              StyleBox["FileByteCount[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["give the number of bytes in a file "]},
          {Cell[TextData[{
              StyleBox["FileDate[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["give the modification date for a file "]},
          {Cell[TextData[{
              StyleBox["SetFileDate[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[
            "set the modification date for a file to be the current date "]},
          {Cell[TextData[{
              StyleBox["FileType[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the type of a file as ",
              StyleBox["File", "MR"],
              ", ",
              StyleBox["Directory", "MR"],
              " or ",
              StyleBox["None", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.6"],

Cell["Functions for manipulating files. ", "Caption",
  CellTags->"S2.12.6"],

Cell[TextData[{
  "Different operating systems have different commands for manipulating \
files. ",
  StyleBox["Mathematica", "TI"],
  " provides a simple set of file manipulation functions, intended to work in \
the same way under all operating systems. "
}], "Text",
  CellTags->{"S2.12.6", "6.2"}],

Cell[TextData[{
  "Notice that ",
  StyleBox["CopyFile", "MR"],
  " and ",
  StyleBox["RenameFile", "MR"],
  " give the final file the same modification date as the original one. ",
  StyleBox["FileDate", "MR"],
  " returns modification dates in the ",
  StyleBox["{", "MR"],
  StyleBox["year", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["month", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["day", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["hour", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["minute", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["second", "TI"],
  StyleBox["}", "MR"],
  " format used by ",
  StyleBox["Date", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.6", "6.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CreateDirectory[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["create a new directory "]},
          {Cell[TextData[{
              StyleBox["DeleteDirectory[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["delete an empty directory "]},
          {Cell[TextData[{
              StyleBox["DeleteDirectory[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["DeleteContents", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True]", "MR"],
              " "
            }]], 
            Cell["\<\
delete a directory and all files and directories it \
contains \
\>"]},
          {Cell[TextData[{
              StyleBox["RenameDirectory[\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["name",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["name",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["rename a directory "]},
          {Cell[TextData[{
              StyleBox["CopyDirectory[\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["name",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["name",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["copy a directory and all the files in it "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.6"],

Cell["Functions for manipulating directories. ", "Caption",
  CellTags->"S2.12.6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.12.7 Importing and Exporting Files", "Subsection",
  CellTags->{"S2.12.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Import[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"List\"]", "MR"],
              " "
            }]], 
            Cell["\<\
import a one\[Hyphen]dimensional list of data from a \
file \
\>"]},
          {Cell[TextData[{
              StyleBox["Export[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"List\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "export ",
              StyleBox["list", "TI"],
              " to a file as a one\[Hyphen]dimensional list of data "
            }]]},
          {Cell[TextData[{
              StyleBox["Import[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"Table\"]", "MR"],
              " "
            }]], 
            Cell["\<\
import a two\[Hyphen]dimensional table of data from a \
file \
\>"]},
          {Cell[TextData[{
              StyleBox["Export[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"Table\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "export ",
              StyleBox["list", "TI"],
              " to a file as a two\[Hyphen]dimensional table of data "
            }]]},
          {Cell[TextData[{
              StyleBox["Import[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"CSV\"]", "MR"],
              " "
            }]], 
            Cell["\<\
import data in comma\[Hyphen]separated format \
\>"]},
          {Cell[TextData[{
              StyleBox["Export[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"CSV\"]", "MR"],
              " "
            }]], 
            Cell["\<\
export data in comma\[Hyphen]separated format \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.12.7"],

Cell["Importing and exporting lists and tables of data. ", "Caption",
  CellTags->"S2.12.7"],

Cell[TextData[{
  "This exports a list of data to the file ",
  StyleBox["out1.dat", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.7", "7.2"}],

Cell[CellGroupData[{

Cell["Export[\"out1.dat\", {6.7, 8.2, -5.3}, \"List\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.12.7"],

Cell[BoxData[
    \("out1.dat"\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell["Here are the contents of the file. ", "MathCaption",
  CellTags->{"S2.12.7", "7.3"}],

Cell[CellGroupData[{

Cell["!!out1.dat", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.12.7"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"6.7`"},
          {"8.2`"},
          {\(-5.299999999999999`\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {6.7000000000000002, 
        8.1999999999999993, -5.2999999999999989}],
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell[TextData[{
  "This imports the contents back into ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.7", "7.4"}],

Cell[CellGroupData[{

Cell["Import[\"out1.dat\", \"List\"]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.12.7"],

Cell[BoxData[
    \({6.7`, 8.2`, \(-5.299999999999999`\)}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell[TextData[{
  "If you want to use data purely within ",
  StyleBox["Mathematica", "TI"],
  ", then the best way to keep it in a file is usually as a complete ",
  StyleBox["Mathematica", "TI"],
  " expression, with all its structure preserved, as discussed in Section\
\[NonBreakingSpace]",
  ButtonBox["2.12.1",
    ButtonData:>{"2.12.1", "1.1"},
    ButtonStyle->"MainBookLink"],
  ". But if you want to exchange data with other programs, it is often more \
convenient to have the data in a simple list or table format. "
}], "Text",
  CellTags->{"S2.12.7", "7.5"}],

Cell["\<\
This exports a two\[Hyphen]dimensional array of data. \
\>", \
"MathCaption",
  CellTags->{"S2.12.7", "7.6"}],

Cell[CellGroupData[{

Cell["\<\
Export[\"out2.dat\", {{5.6 10^12, 7.2 10^12}, {3, 5}}, \"Table\"]\
\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.12.7"],

Cell[BoxData[
    \("out2.dat"\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell["\<\
When necessary, numbers are written in C or Fortran\[Hyphen]like \
\[OpenCurlyDoubleQuote]E\[CloseCurlyDoubleQuote] notation. \
\>", \
"MathCaption",
  CellTags->{"S2.12.7", "7.7"}],

Cell[CellGroupData[{

Cell["!!out2.dat", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.12.7"],

Cell["\<\
5.6e+12   7.2e+12
3   5\
\>", "Print",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell[TextData[{
  "This imports the array back into ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.7", "7.8"}],

Cell[CellGroupData[{

Cell["Import[\"out2.dat\", \"Table\"]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.12.7"],

Cell[BoxData[
    \({{5.6`*^12, 7.2`*^12}, {3, 5}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell[TextData[{
  "If you have a file in which each line consists of a single number, then \
you can use ",
  StyleBox["Import[\"", "MR"],
  StyleBox["file", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["\"List\"]", "MR"],
  " to import the contents of the file as a list of numbers. If each line \
consists of a sequence of numbers separated by tabs or spaces, then ",
  StyleBox["Import[\"", "MR"],
  StyleBox["file", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["\"Table\"]", "MR"],
  " will yield a list of lists of numbers. If the file contains items that \
are not numbers, then these are returned as ",
  StyleBox["Mathematica", "TI"],
  " strings. "
}], "Text",
  CellTags->{"S2.12.7", "7.9"}],

Cell["This exports a mixture of textual and numerical data. ", "MathCaption",
  CellTags->{"S2.12.7", "7.10"}],

Cell[CellGroupData[{

Cell["Export[\"out3.dat\", {{\"first\", 3.4}, {\"second\", 7.8}}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.12.7"],

Cell[BoxData[
    \("out3.dat"\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell["Here is the exported data. ", "MathCaption",
  CellTags->{"S2.12.7", "7.11"}],

Cell[CellGroupData[{

Cell["!!out3.dat", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.12.7"],

Cell["\<\
first   3.399999999999999
second   7.799999999999999\
\>", "Print",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell[TextData[{
  "This imports the data back into ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.7", "7.12"}],

Cell[CellGroupData[{

Cell["Import[\"out3.dat\", \"Table\"]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.12.7"],

Cell[BoxData[
    \({{"first", 3.399999999999999`}, {"second", 
        7.799999999999999`}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["InputForm", "MR"],
  ", you can explicitly see the strings. "
}], "MathCaption",
  CellTags->{"S2.12.7", "7.13"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.12.7"],

Cell["\<\
{{\"first\", 3.399999999999999},   {\"second\", 7.799999999999999}}\
\
\>", "Output",
  CellLabel->"Out[10]//InputForm= ",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Import[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"List\"]", "MR"],
              " "
            }]], Cell[
            "treat each line as a separate numerical or other data item "]},
          {Cell[TextData[{
              StyleBox["Import[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"Table\"]", "MR"],
              " "
            }]], 
            Cell["\<\
treat each element on each line as a separate numerical \
or other data item \
\>"]},
          {Cell[TextData[{
              StyleBox["Import[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"String\"]", "MR"],
              " "
            }]], Cell["treat the whole file as a single character string "]},
          {Cell[TextData[{
              StyleBox["Import[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"Text\"]", "MR"],
              " "
            }]], Cell["treat the whole file as a single string of text "]},
          {Cell[TextData[{
              StyleBox["Import[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"Lines\"]", "MR"],
              " "
            }]], Cell["treat each line as a string of text "]},
          {Cell[TextData[{
              StyleBox["Import[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"Words\"]", "MR"],
              " "
            }]], Cell["treat each separated word as a string of text "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.12.7"],

Cell["Importing files in different formats. ", "Caption",
  CellTags->"S2.12.7"],

Cell["This creates a file with two lines of text. ", "MathCaption",
  CellTags->{"S2.12.7", "7.14"}],

Cell[CellGroupData[{

Cell["\<\
Export[\"out4.dat\", {\"The first line.\", \"The second line.\"}, \
\"Lines\"]\
\>", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.12.7"],

Cell[BoxData[
    \("out4.dat"\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell["Here are the contents of the file. ", "MathCaption",
  CellTags->{"S2.12.7", "7.15"}],

Cell[CellGroupData[{

Cell["!!out4.dat", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.12.7"],

Cell["\<\
The first line.
The second line.\
\>", "Print",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell["This imports the whole file as a single string. ", "MathCaption",
  CellTags->{"S2.12.7", "7.16"}],

Cell[CellGroupData[{

Cell["Import[\"out4.dat\", \"Text\"]//InputForm", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.12.7"],

Cell["\"The first line.\\nThe second line.\"", "Output",
  CellLabel->"Out[13]//InputForm= ",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell["This imports the file as a list of lines of text. ", "MathCaption",
  CellTags->{"S2.12.7", "7.17"}],

Cell[CellGroupData[{

Cell["Import[\"out4.dat\", \"Lines\"]//InputForm", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.12.7"],

Cell["{\"The first line.\", \"The second line.\"}", "Output",
  CellLabel->"Out[14]//InputForm= ",
  CellTags->"S2.12.7"]
}, Open  ]],

Cell["\<\
This imports the file as a list of words separated by white space. \
\
\>", "MathCaption",
  CellTags->{"S2.12.7", "7.18"}],

Cell[CellGroupData[{

Cell["Import[\"out4.dat\", \"Words\"]//InputForm", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.12.7"],

Cell["{\"The\", \"first\", \"line.\", \"The\", \"second\",   \"line.\"}", \
"Output",
  CellLabel->"Out[15]//InputForm= ",
  CellTags->"S2.12.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.12.8 Reading Textual Data", "Subsection",
  CellTags->{"S2.12.8", "8.1"}],

Cell[TextData[{
  "With ",
  StyleBox["<<", "MR"],
  ", you can read files which contain ",
  StyleBox["Mathematica", "TI"],
  " expressions given in input form. Sometimes, however, you may instead need \
to read files of ",
  StyleBox["data", "TI"],
  " in other formats. For example, you may have data generated by an external \
program which consists of a sequence of numbers separated by spaces. This \
data cannot be read directly as ",
  StyleBox["Mathematica", "TI"],
  " input. However, the function ",
  StyleBox["ReadList", "MR"],
  " can take such data from a file or input stream, and convert it to a ",
  StyleBox["Mathematica", "TI"],
  " list. "
}], "Text",
  CellTags->{"S2.12.8", "8.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ReadList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["Number]", "MR"],
              " "
            }]], Cell[TextData[{
              "read a sequence of numbers from a file, and put them in a ",
              StyleBox["Mathematica", "TI"],
              " list "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.8"],

Cell["Reading numbers from a file. ", "Caption",
  CellTags->"S2.12.8"],

Cell["Here is a file of numbers. ", "MathCaption",
  CellTags->{"S2.12.8", "8.3"}],

Cell[CellGroupData[{

Cell["!!numbers", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.12.8"],

Cell["\<\
11.1   22.2    33.3
44.4   55.5    66.6\
\>", "Print",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["\<\
This reads all the numbers in the file, and returns a list of them. \
\
\>", "MathCaption",
  CellTags->{"S2.12.8", "8.4"}],

Cell[CellGroupData[{

Cell["ReadList[\"numbers\", Number]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({11.1`, 22.2`, 33.3`, 44.4`, 55.5`, 66.6`}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ReadList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["{Number,", "MR"],
              " ",
              StyleBox["Number}]", "MR"],
              " "
            }]], 
            Cell["\<\
read numbers from a file, putting each successive pair \
into a separate list \
\>"]},
          {Cell[TextData[{
              StyleBox["ReadList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["Table[Number,", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}]]", "MR"],
              " "
            }]], Cell[TextData[{
              "put each successive block of ",
              StyleBox["n", "TI"],
              " numbers in a separate list "
            }]]},
          {Cell[TextData[{
              StyleBox["ReadList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["Number,", "MR"],
              " ",
              StyleBox["RecordLists", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True]", "MR"],
              " "
            }]], 
            Cell["\<\
put all the numbers on each line of the file into a \
separate list \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.8"],

Cell["Reading blocks of numbers. ", "Caption",
  CellTags->"S2.12.8"],

Cell["\<\
This puts each successive pair of numbers from the file into a \
separate list. \
\>", "MathCaption",
  CellTags->{"S2.12.8", "8.5"}],

Cell[CellGroupData[{

Cell["ReadList[\"numbers\", {Number, Number}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({{11.1`, 22.2`}, {33.3`, 44.4`}, {55.5`, 66.6`}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["This makes each line in the file into a separate list. ", "MathCaption",
  CellTags->{"S2.12.8", "8.6"}],

Cell[CellGroupData[{

Cell["ReadList[\"numbers\", Number, RecordLists -> True]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({{11.1`, 22.2`, 33.3`}, {44.4`, 55.5`, 66.6`}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ReadList", "MR"],
  " can handle numbers which are given in Fortran\[Hyphen]like \
\[OpenCurlyDoubleQuote]",
  StyleBox["E", "MR"],
  "\[CloseCurlyDoubleQuote] notation. Thus, for example, ",
  StyleBox["ReadList", "MR"],
  " will read ",
  StyleBox["2.5E+5", "MR"],
  " as ",
  Cell[BoxData[
      \(TraditionalForm\`2.5\[Cross]10\^5\)], "InlineFormula"],
  ". Note that ",
  StyleBox["ReadList", "MR"],
  " can handle numbers with any number of digits of precision. "
}], "Text",
  CellTags->{"S2.12.8", "8.7"}],

Cell[TextData[{
  "Here is a file containing numbers in Fortran\[Hyphen]like \
\[OpenCurlyDoubleQuote]",
  StyleBox["E", "MR"],
  "\[CloseCurlyDoubleQuote] notation. "
}], "MathCaption",
  CellTags->{"S2.12.8", "8.8"}],

Cell[CellGroupData[{

Cell["!!bignum", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.12.8"],

Cell["\<\
4.5E-5      7.8E4
2.5E2      -8.9\
\>", "Print",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ReadList", "MR"],
  " can handle numbers in this form. "
}], "MathCaption",
  CellTags->{"S2.12.8", "8.9"}],

Cell[CellGroupData[{

Cell["ReadList[\"bignum\", Number]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({0.000045`, 78000.`, 250.`, \(-8.9`\)}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ReadList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["type", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["read a sequence of objects of a particular type "]},
          {Cell[TextData[{
              StyleBox["ReadList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["type", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "read at most ",
              StyleBox["n", "TI"],
              " objects "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.8"],

Cell["Reading objects of various types. ", "Caption",
  CellTags->"S2.12.8"],

Cell[TextData[{
  StyleBox["ReadList", "MR"],
  " can read not only numbers, but also a variety of other types of object. \
Each type of object is specified by a symbol such as ",
  StyleBox["Number", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.8", "8.10"}],

Cell["Here is a file containing text. ", "MathCaption",
  CellTags->{"S2.12.8", "8.11"}],

Cell[CellGroupData[{

Cell["!!strings", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.12.8"],

Cell["\<\
Here is text. 
And more text.\
\>", "Print",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["\<\
This produces a list of the characters in the file, each given as a \
one\[Hyphen]character string. \
\>", "MathCaption",
  CellTags->{"S2.12.8", "8.12"}],

Cell[CellGroupData[{

Cell["ReadList[\"strings\", Character]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({"H", "e", "r", "e", " ", "i", "s", " ", "t", "e", "x", "t", ".", " ", 
      "\n", "A", "n", "d", " ", "m", "o", "r", "e", " ", "t", "e", "x", "t", 
      ".", "\n"}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["\<\
Here are the integer codes corresponding to each of the bytes in \
the file. \
\>", "MathCaption",
  CellTags->{"S2.12.8", "8.13"}],

Cell[CellGroupData[{

Cell["ReadList[\"strings\", Byte]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({72, 101, 114, 101, 32, 105, 115, 32, 116, 101, 120, 116, 46, 32, 10, 
      65, 110, 100, 32, 109, 111, 114, 101, 32, 116, 101, 120, 116, 46, 
      10}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["\<\
This puts the data from each line in the file into a separate list. \
\
\>", "MathCaption",
  CellTags->{"S2.12.8", "8.14"}],

Cell[CellGroupData[{

Cell["ReadList[\"strings\", Byte, RecordLists -> True]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({{72, 101, 114, 101, 32, 105, 115, 32, 116, 101, 120, 116, 46, 
        32}, {65, 110, 100, 32, 109, 111, 114, 101, 32, 116, 101, 120, 116, 
        46}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Byte", "MR"],
              " "
            }]], Cell["single byte of data, returned as an integer "]},
          {Cell[TextData[{
              StyleBox["Character", "MR"],
              " "
            }]], 
            Cell["\<\
single character, returned as a one\[Hyphen]character \
string \
\>"]},
          {Cell[TextData[{
              StyleBox["Real", "MR"],
              " "
            }]], 
            Cell["\<\
approximate number in Fortran\[Hyphen]like notation \
\
\>"]},
          {Cell[TextData[{
              StyleBox["Number", "MR"],
              " "
            }]], 
            Cell["\<\
exact or approximate number in Fortran\[Hyphen]like \
notation \
\>"]},
          {Cell[TextData[{
              StyleBox["Word", "MR"],
              " "
            }]], Cell[
            "sequence of characters delimited by word separators "]},
          {Cell[TextData[{
              StyleBox["Record", "MR"],
              " "
            }]], Cell[
            "sequence of characters delimited by record separators "]},
          {Cell[TextData[{
              StyleBox["String", "MR"],
              " "
            }]], Cell["string terminated by a newline "]},
          {Cell[TextData[{
              StyleBox["Expression", "MR"],
              " "
            }]], Cell[TextData[{
              "complete ",
              StyleBox["Mathematica", "TI"],
              " expression "
            }]]},
          {Cell[TextData[{
              StyleBox["Hold[Expression]", "MR"],
              " "
            }]], Cell[TextData[{
              "complete ",
              StyleBox["Mathematica", "TI"],
              " expression, returned inside ",
              StyleBox["Hold", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.8"],

Cell["Types of objects to read.", "Caption",
  CellTags->"S2.12.8"],

Cell[TextData[{
  "This returns a list of the \[OpenCurlyDoubleQuote]words\
\[CloseCurlyDoubleQuote] in the file ",
  StyleBox["strings", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.8", "8.15"}],

Cell[CellGroupData[{

Cell["ReadList[\"strings\", Word]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({"Here", "is", "text.", "And", "more", "text."}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ReadList", "MR"],
  " allows you to read \[OpenCurlyDoubleQuote]words\[CloseCurlyDoubleQuote] \
from a file. It considers a \[OpenCurlyDoubleQuote]word\
\[CloseCurlyDoubleQuote] to be any sequence of characters delimited by word \
separators. You can set the option ",
  StyleBox["WordSeparators", "MR"],
  " to specify the strings you want to treat as word separators. The default \
is to include spaces and tabs, but not to include, for example, standard \
punctuation characters. Note that in all cases successive words can be \
separated by any number of word separators. These separators are never taken \
to be part of the actual words returned by ",
  StyleBox["ReadList", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.8", "8.16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["RecordLists", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], 
            Cell["\<\
whether to make a separate list for the objects in each \
record \
\>"]},
          {Cell[TextData[{
              StyleBox["RecordSeparators", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{\"\[Backslash]n\"}", "MR"],
              " "
            }]], Cell["separators for records "]},
          {Cell[TextData[{
              StyleBox["WordSeparators", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{\"", "MR"],
              " ",
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"\[Backslash]t\"}", "MR"],
              " "
            }]], Cell["separators for words "]},
          {Cell[TextData[{
              StyleBox["NullRecords", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], 
            Cell["\<\
whether to keep zero\[Hyphen]length records \
\>"]},
          {Cell[TextData[{
              StyleBox["NullWords", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell["\<\
whether to keep zero\[Hyphen]length words \
\>"]},
          {Cell[TextData[{
              StyleBox["TokenWords", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{}", "MR"],
              " "
            }]], Cell["words to take as tokens "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.12.8"],

Cell[TextData[{
  "Options for ",
  StyleBox["ReadList", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.12.8"],

Cell[TextData[{
  "This reads the text in the file ",
  StyleBox["strings", "MR"],
  " as a sequence of words, using the letter ",
  StyleBox["e", "MR"],
  " and ",
  StyleBox[".", "MR"],
  " as word separators. "
}], "MathCaption",
  CellTags->{"S2.12.8", "8.17"}],

Cell[CellGroupData[{

Cell["ReadList[\"strings\", Word, WordSeparators -> {\"e\", \".\"}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({"H", "r", " is t", "xt", " ", "And mor", " t", "xt"}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " considers any data file to consist of a sequence of ",
  StyleBox["records", "TI"],
  ". By default, each line is considered to be a separate record. In general, \
you can set the option ",
  StyleBox["RecordSeparators", "MR"],
  " to give a list of separators for records. Note that words can never cross \
record separators. As with word separators, any number of record separators \
can exist between successive records, and these separators are not considered \
to be part of the records themselves. "
}], "Text",
  CellTags->{"S2.12.8", "8.18"}],

Cell["\<\
By default, each line of the file is considered to be a record. \
\
\>", "MathCaption",
  CellTags->{"S2.12.8", "8.19"}],

Cell[CellGroupData[{

Cell["ReadList[\"strings\", Record] // InputForm", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.12.8"],

Cell["{\"Here is text. \", \"And more text.\"}", "Output",
  CellLabel->"Out[13]//InputForm= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["\<\
Here is a file containing three \[OpenCurlyDoubleQuote]sentences\
\[CloseCurlyDoubleQuote] ending with periods. \
\>", "MathCaption",
  CellTags->{"S2.12.8", "8.20"}],

Cell[CellGroupData[{

Cell["!!sentences", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.12.8"],

Cell["\<\
Here is text. And more.
And a second line.\
\>", "Print",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["This allows both periods and newlines as record separators. ", \
"MathCaption",
  CellTags->{"S2.12.8", "8.21"}],

Cell[CellGroupData[{

Cell["\<\
ReadList[\"sentences\", Record, RecordSeparators -> {\".\", \
\"\\n\"}]\
\>", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({"Here is text", " And more", "And a second line"}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["\<\
This puts the words in each \[OpenCurlyDoubleQuote]sentence\
\[CloseCurlyDoubleQuote] into a separate list. \
\>", "MathCaption",
  CellTags->{"S2.12.8", "8.22"}],

Cell[CellGroupData[{

Cell["\<\
ReadList[\"sentences\", Word, RecordLists -> True, RecordSeparators \
-> {\".\", \"\\n\"}]\
\>", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({{"Here", "is", "text"}, {"And", "more"}, {"And", "a", "second", 
        "line"}}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ReadList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["Record,", "MR"],
              " ",
              StyleBox["RecordSeparators", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{", "MR"],
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["read the whole of a file as a single string "]},
          {Cell[TextData[{
              StyleBox["ReadList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["Record,", "MR"],
              " ",
              StyleBox["RecordSeparators", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lsep",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rsep",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "\", \[Ellipsis] }}]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "make a list of those parts of a file which lie between the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lsep",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " and the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rsep",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.8"],

Cell[TextData[{
  "Settings for the ",
  StyleBox["RecordSeparators", "MR"],
  " option. "
}], "Caption",
  CellTags->"S2.12.8"],

Cell["Here is a file containing some text. ", "MathCaption",
  CellTags->{"S2.12.8", "8.23"}],

Cell[CellGroupData[{

Cell["!!source", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.12.8"],

Cell["\<\
f[x] (: function f :)
g[x] (: function g :)\
\>", "Print",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[TextData[{
  "This reads all the text in the file ",
  StyleBox["source", "MR"],
  ", and returns it as a single string. "
}], "MathCaption",
  CellTags->{"S2.12.8", "8.24"}],

Cell[CellGroupData[{

Cell["\<\
InputForm[ ReadList[\"source\", Record, RecordSeparators -> { }] \
]\
\>", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.12.8"],

Cell["{\"f[x] (: function f :)\\ng[x] (: function g :)\\n\"}", "Output",
  CellLabel->"Out[18]//InputForm= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[TextData[{
  "This gives a list of the parts of the file that lie between ",
  StyleBox["(:", "MR"],
  " and ",
  StyleBox[":)", "MR"],
  " separators. "
}], "MathCaption",
  CellTags->{"S2.12.8", "8.25"}],

Cell[CellGroupData[{

Cell["\<\
ReadList[\"source\", Record, RecordSeparators -> {{\"(: \"}, {\" :)\
\"}}]\
\>", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({"function f", "function g"}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["\<\
By choosing appropriate separators, you can pick out specific parts \
of files. \
\>", "MathCaption",
  CellTags->{"S2.12.8", "8.26"}],

Cell[CellGroupData[{

Cell["\<\
ReadList[ \"source\", Record, RecordSeparators -> {{\"(: function \
\", \"[\"}, {\" :)\", \"]\"}} ]\
\>", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({"x", "f", "x", "g"}\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " usually allows any number of appropriate separators to appear between \
successive records or words. Sometimes, however, when several separators are \
present, you may want to assume that a \[OpenCurlyDoubleQuote]null record\
\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]null word\
\[CloseCurlyDoubleQuote] appears between each pair of adjacent separators. \
You can do this by setting the options ",
  StyleBox["NullRecords", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["NullWords", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.8", "8.27"}],

Cell["\<\
Here is a file containing \[OpenCurlyDoubleQuote]words\
\[CloseCurlyDoubleQuote] separated by colons. \
\>", "MathCaption",
  CellTags->{"S2.12.8", "8.28"}],

Cell[CellGroupData[{

Cell["!!words", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.12.8"],

Cell["first:second::fourth:::seventh", "Print",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["Here the repeated colons are treated as single separators. ", \
"MathCaption",
  CellTags->{"S2.12.8", "8.29"}],

Cell[CellGroupData[{

Cell["ReadList[\"words\", Word, WordSeparators -> {\":\"}]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({"first", "second", "fourth", "seventh"}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["\<\
Now repeated colons are taken to have null words in between. \
\>", \
"MathCaption",
  CellTags->{"S2.12.8", "8.30"}],

Cell[CellGroupData[{

Cell["\<\
ReadList[\"words\", Word, WordSeparators -> {\":\"}, NullWords -> \
True]\
\>", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({"first", "second", \*"\<\"\"\>", "fourth", \*"\<\"\"\>", \*"\<\"\"\>", 
      "seventh"}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[TextData[{
  "In most cases, you want words to be delimited by separators which are not \
themselves considered as words. Sometimes, however, it is convenient to allow \
words to be delimited by special \[OpenCurlyDoubleQuote]token words\
\[CloseCurlyDoubleQuote], which are themselves words. You can give a list of \
such token words as a setting for the option ",
  StyleBox["TokenWords", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.8", "8.31"}],

Cell["Here is some text. ", "MathCaption",
  CellTags->{"S2.12.8", "8.32"}],

Cell[CellGroupData[{

Cell["!!language", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.12.8"],

Cell["22*a*b+56*c+13*a*d", "Print",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["\<\
This reads the text, using the specified token words to delimit \
words in the text. \
\>", "MathCaption",
  CellTags->{"S2.12.8", "8.33"}],

Cell[CellGroupData[{

Cell["ReadList[\"language\", Word, TokenWords -> {\"+\", \"*\"}]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({"22", "*", "a", "*", "b", "+", "56", "*", "c", "+", "13", "*", "a", 
      "*", "d"}\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["ReadList", "MR"],
  " to read ",
  StyleBox["Mathematica", "TI"],
  " expressions from files. In general, each expression must end with a \
newline, although a single expression may go on for several lines. "
}], "Text",
  CellTags->{"S2.12.8", "8.34"}],

Cell[TextData[{
  "Here is a file containing text that can be used as ",
  StyleBox["Mathematica", "TI"],
  " input. "
}], "MathCaption",
  CellTags->{"S2.12.8", "8.35"}],

Cell[CellGroupData[{

Cell["!!exprs", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.12.8"],

Cell["\<\
x + y +
z
2^8\
\>", "Print",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[TextData[{
  "This reads the text in ",
  StyleBox["exprs", "MR"],
  " as ",
  StyleBox["Mathematica", "TI"],
  " expressions. "
}], "MathCaption",
  CellTags->{"S2.12.8", "8.36"}],

Cell[CellGroupData[{

Cell["ReadList[\"exprs\", Expression]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({x + y + z, 256}\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["This prevents the expressions from being evaluated. ", "MathCaption",
  CellTags->{"S2.12.8", "8.37"}],

Cell[CellGroupData[{

Cell["ReadList[\"exprs\", Hold[Expression]]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({Hold[x + y + z], Hold[2\^8]}\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ReadList", "MR"],
  " can insert the objects it reads into any ",
  StyleBox["Mathematica", "TI"],
  " expression. The second argument to ",
  StyleBox["ReadList", "MR"],
  " can consist of any expression containing symbols such as ",
  StyleBox["Number", "MR"],
  " and ",
  StyleBox["Word", "MR"],
  " specifying objects to read. Thus, for example, ",
  StyleBox["ReadList[\"", "MR"],
  StyleBox["file", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["{Number,", "MR"],
  " ",
  StyleBox["Number}]", "MR"],
  " inserts successive pairs of numbers that it reads into lists. Similarly, \
",
  StyleBox["ReadList[\"", "MR"],
  StyleBox["file", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["Hold[Expression]]", "MR"],
  " puts expressions that it reads inside ",
  StyleBox["Hold", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.8", "8.38"}],

Cell[TextData[{
  "If ",
  StyleBox["ReadList", "MR"],
  " reaches the end of your file before it has finished reading a particular \
set of objects you have asked for, then it inserts the special symbol ",
  StyleBox["EndOfFile", "MR"],
  " in place of the objects it has not yet read. "
}], "Text",
  CellTags->{"S2.12.8", "8.39"}],

Cell["Here is a file of numbers. ", "MathCaption",
  CellTags->{"S2.12.8", "8.40"}],

Cell[CellGroupData[{

Cell["!!numbers", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S2.12.8"],

Cell["\<\
11.1   22.2    33.3
44.4   55.5    66.6\
\>", "Print",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[TextData[{
  "The symbol ",
  StyleBox["EndOfFile", "MR"],
  " appears in place of numbers that were needed after the end of the file \
was reached. "
}], "MathCaption",
  CellTags->{"S2.12.8", "8.41"}],

Cell[CellGroupData[{

Cell["ReadList[\"numbers\", {Number, Number, Number, Number}]", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({{11.1`, 22.2`, 33.3`, 44.4`}, {55.5`, 66.6`, EndOfFile, 
        EndOfFile}}\)], "Output",
  CellLabel->"Out[30]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ReadList[\"!", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["type", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["execute a command, and read its output "]},
          {Cell[TextData[{
              StyleBox["ReadList[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["type", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["read any input stream "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.8"],

Cell["Reading from commands and streams. ", "Caption",
  CellTags->"S2.12.8"],

Cell[TextData[{
  "This executes the Unix command ",
  StyleBox["date", "MR"],
  ", and reads its output as a string. "
}], "MathCaption",
  CellTags->{"S2.12.8", "8.42"}],

Cell[CellGroupData[{

Cell["ReadList[\"!date\", String]", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({"Mon Jun 20 19:06:12 CDT 2005"}\)], "Output",
  CellLabel->"Out[31]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["OpenRead[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["open a file for reading "]},
          {Cell[TextData[{
              StyleBox["OpenRead[\"!", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["open a pipe for reading "]},
          {Cell[TextData[{
              StyleBox["Read[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["type", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "read an object of the specified type from a stream "]},
          {Cell[TextData[{
              StyleBox["Skip[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["type", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
skip over an object of the specified type in an input \
stream \
\>"]},
          {Cell[TextData[{
              StyleBox["Skip[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["type", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "skip over ",
              StyleBox["n", "TI"],
              " objects of the specified type in an input stream "
            }]]},
          {Cell[TextData[{
              StyleBox["Close[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["close an input stream "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.8"],

Cell["Functions for reading from input streams. ", "Caption",
  CellTags->"S2.12.8"],

Cell[TextData[{
  StyleBox["ReadList", "MR"],
  " allows you to read ",
  StyleBox["all", "TI"],
  " the data in a particular file or input stream. Sometimes, however, you \
want to get data a piece at a time, perhaps doing tests to find out what kind \
of data to expect next. "
}], "Text",
  CellTags->{"S2.12.8", "8.43"}],

Cell[TextData[{
  "When you read individual pieces of data from a file, ",
  StyleBox["Mathematica", "TI"],
  " always remembers the \[OpenCurlyDoubleQuote]current point\
\[CloseCurlyDoubleQuote] that you are at in the file. When you call ",
  StyleBox["OpenRead", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " sets up an input stream from a file, and makes your current point the \
beginning of the file. Every time you read an object from the file using ",
  StyleBox["Read", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " sets your current point to be just after the object you have read. Using \
",
  StyleBox["Skip", "MR"],
  ", you can advance the current point past a sequence of objects without \
actually reading the objects. "
}], "Text",
  CellTags->{"S2.12.8", "8.44"}],

Cell["Here is a file of numbers. ", "MathCaption",
  CellTags->{"S2.12.8", "8.45"}],

Cell[CellGroupData[{

Cell["!!numbers", "Input",
  CellLabel->"In[32]:= ",
  CellTags->"S2.12.8"],

Cell["\<\
11.1   22.2    33.3
44.4   55.5    66.6\
\>", "Print",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["This opens an input stream from the file. ", "MathCaption",
  CellTags->{"S2.12.8", "8.46"}],

Cell[CellGroupData[{

Cell["snum = OpenRead[\"numbers\"]", "Input",
  CellLabel->"In[33]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \(InputStream["numbers", 69]\)], "Output",
  CellLabel->"Out[33]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["This reads the first number from the file. ", "MathCaption",
  CellTags->{"S2.12.8", "8.47"}],

Cell[CellGroupData[{

Cell["Read[snum, Number]", "Input",
  CellLabel->"In[34]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \(11.1`\)], "Output",
  CellLabel->"Out[34]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["This reads the second pair of numbers. ", "MathCaption",
  CellTags->{"S2.12.8", "8.48"}],

Cell[CellGroupData[{

Cell["Read[snum, {Number, Number}]", "Input",
  CellLabel->"In[35]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({22.2`, 33.3`}\)], "Output",
  CellLabel->"Out[35]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["This skips the next number. ", "MathCaption",
  CellTags->{"S2.12.8", "8.49"}],

Cell["Skip[snum, Number]", "Input",
  CellLabel->"In[36]:= ",
  CellTags->"S2.12.8"],

Cell["And this reads the remaining numbers. ", "MathCaption",
  CellTags->{"S2.12.8", "8.50"}],

Cell[CellGroupData[{

Cell["ReadList[snum, Number]", "Input",
  CellLabel->"In[37]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \({55.5`, 66.6`}\)], "Output",
  CellLabel->"Out[37]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell["This closes the input stream. ", "MathCaption",
  CellTags->{"S2.12.8", "8.51"}],

Cell[CellGroupData[{

Cell["Close[snum]", "Input",
  CellLabel->"In[38]:= ",
  CellTags->"S2.12.8"],

Cell[BoxData[
    \("numbers"\)], "Output",
  CellLabel->"Out[38]= ",
  CellTags->"S2.12.8"]
}, Open  ]],

Cell[TextData[{
  "You can use the options ",
  StyleBox["WordSeparators", "MR"],
  " and ",
  StyleBox["RecordSeparators", "MR"],
  " in ",
  StyleBox["Read", "MR"],
  " and ",
  StyleBox["Skip", "MR"],
  " just as you do in ",
  StyleBox["ReadList", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.8", "8.52"}],

Cell[TextData[{
  "Note that if you try to read past the end of file, ",
  StyleBox["Read", "MR"],
  " returns the symbol ",
  StyleBox["EndOfFile", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.8", "8.53"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.12.9 Searching Files", "Subsection",
  CellTags->{"S2.12.9", "9.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FindList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["text", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
get a list of all the lines in the file that contain \
the specified text \
\>"]},
          {Cell[TextData[{
              StyleBox["FindList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["text", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "get a list of the first ",
              StyleBox["n", "TI"],
              " lines that contain the specified text "
            }]]},
          {Cell[TextData[{
              StyleBox["FindList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["text",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["text",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "get lines that contain any of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["text",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.9"],

Cell["Finding lines that contain specified text. ", "Caption",
  CellTags->"S2.12.9"],

Cell["Here is a file containing some text. ", "MathCaption",
  CellTags->{"S2.12.9", "9.2"}],

Cell[CellGroupData[{

Cell["!!textfile", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.12.9"],

Cell["\<\
Here is the first line of text.
And the second.
And the third. Here is the end.\
\>", "Print",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[TextData[{
  "This returns a list of all the lines in the file containing the text ",
  StyleBox["is", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.3"}],

Cell[CellGroupData[{

Cell["FindList[\"textfile\", \"is\"]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \({"Here is the first line of text.", 
      "And the third. Here is the end."}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[TextData[{
  "The text ",
  StyleBox["fourth", "MR"],
  " appears nowhere in the file. "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.4"}],

Cell[CellGroupData[{

Cell["FindList[\"textfile\", \"fourth\"]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[TextData[{
  "By default, ",
  StyleBox["FindList", "MR"],
  " scans successive lines of a file, and returns those lines which contain \
the text you specify. In general, however, you can get ",
  StyleBox["FindList", "MR"],
  " to scan successive ",
  StyleBox["records", "TI"],
  ", and return complete records which contain specified text. As in ",
  StyleBox["ReadList", "MR"],
  ", the option ",
  StyleBox["RecordSeparators", "MR"],
  " allows you to tell ",
  StyleBox["Mathematica", "TI"],
  " what strings you want to consider as record separators. Note that by \
giving a pair of lists as the setting for ",
  StyleBox["RecordSeparators", "MR"],
  ", you can specify different left and right separators. By doing this, you \
can make ",
  StyleBox["FindList", "MR"],
  " search only for text which is between specific pairs of separators. "
}], "Text",
  CellTags->{"S2.12.9", "9.5"}],

Cell[TextData[{
  "This finds all \[OpenCurlyDoubleQuote]sentences\[CloseCurlyDoubleQuote] \
ending with a period which contain ",
  StyleBox["And", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.6"}],

Cell[CellGroupData[{

Cell["FindList[\"textfile\", \"And\", RecordSeparators -> {\".\"}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \({"\nAnd the second", "\nAnd the third"}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["RecordSeparators", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{\"\[Backslash]n\"}", "MR"],
              " "
            }]], Cell["separators for records "]},
          {Cell[TextData[{
              StyleBox["AnchoredSearch", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], 
            Cell["\<\
whether to require the text searched for to be at the \
beginning of a record \
\>"]},
          {Cell[TextData[{
              StyleBox["WordSeparators", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{\"", "MR"],
              " ",
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"\[Backslash]t\"}", "MR"],
              " "
            }]], Cell["separators for words "]},
          {Cell[TextData[{
              StyleBox["WordSearch", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], 
            Cell["\<\
whether to require that the text searched for appear as \
a word \
\>"]},
          {Cell[TextData[{
              StyleBox["IgnoreCase", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], 
            Cell["\<\
whether to treat lower\[Hyphen] and upper\[Hyphen]case \
letters as equivalent \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.12.9"],

Cell[TextData[{
  "Options for ",
  StyleBox["FindList", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.12.9"],

Cell[TextData[{
  "This finds only the occurrence of ",
  StyleBox["Here", "MR"],
  " which is at the beginning of a line in the file. "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.7"}],

Cell[CellGroupData[{

Cell["FindList[\"textfile\", \"Here\", AnchoredSearch -> True]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \({"Here is the first line of text."}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[TextData[{
  "In general, ",
  StyleBox["FindList", "MR"],
  " finds text that appears anywhere inside a record. By setting the option \
",
  StyleBox["WordSearch", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ", however, you can tell ",
  StyleBox["FindList", "MR"],
  " to require that the text it is looking for appears as a separate ",
  StyleBox["word", "TI"],
  " in the record. The option ",
  StyleBox["WordSeparators", "MR"],
  " specifies the list of separators for words. "
}], "Text",
  CellTags->{"S2.12.9", "9.8"}],

Cell[TextData[{
  "The text ",
  StyleBox["th", "MR"],
  " does appear in the file, but not as a word. As a result, the ",
  StyleBox["FindList", "MR"],
  " fails. "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.9"}],

Cell[CellGroupData[{

Cell["FindList[\"textfile\", \"th\", WordSearch -> True]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FindList[{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["text", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "search for occurrences of the text in any of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.9"],

Cell["Searching in multiple files. ", "Caption",
  CellTags->"S2.12.9"],

Cell[TextData[{
  "This searches for ",
  StyleBox["third", "MR"],
  " in two copies of ",
  StyleBox["textfile", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.10"}],

Cell[CellGroupData[{

Cell["FindList[{\"textfile\", \"textfile\"}, \"third\"]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \({"And the third. Here is the end.", 
      "And the third. Here is the end."}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[TextData[{
  "It is often useful to call ",
  StyleBox["FindList", "MR"],
  " on lists of files generated by functions such as ",
  StyleBox["FileNames", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.9", "9.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FindList[\"!", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "run an external command, and find text in its output "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.9"],

Cell["Finding text in the output from an external program. ", "Caption",
  CellTags->"S2.12.9"],

Cell[TextData[{
  "This runs the external Unix command ",
  StyleBox["date", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.12"}],

Cell[CellGroupData[{

Cell["!date", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \("Mon Jun 20 19:06:12 CDT 2005"\)], "Print",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell["\<\
This finds the time\[Hyphen]of\[Hyphen]day field in the date. \
\
\>", "MathCaption",
  CellTags->{"S2.12.9", "9.13"}],

Cell[CellGroupData[{

Cell["FindList[\"!date\", \":\", RecordSeparators -> {\" \"}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \({"19:06:12"}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["OpenRead[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["open a file for reading "]},
          {Cell[TextData[{
              StyleBox["OpenRead[\"!", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["open a pipe for reading "]},
          {Cell[TextData[{
              StyleBox["Find[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["text", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the next occurrence of ",
              StyleBox["text", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Close[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["close an input stream "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.9"],

Cell["Finding successive occurrences of text. ", "Caption",
  CellTags->"S2.12.9"],

Cell[TextData[{
  StyleBox["FindList", "MR"],
  " works by making one pass through a particular file, looking for \
occurrences of the text you specify. Sometimes, however, you may want to \
search incrementally for successive occurrences of a piece of text. You can \
do this using ",
  StyleBox["Find", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.9", "9.14"}],

Cell[TextData[{
  "In order to use ",
  StyleBox["Find", "MR"],
  ", you first explicitly have to open an input stream using ",
  StyleBox["OpenRead", "MR"],
  ". Then, every time you call ",
  StyleBox["Find", "MR"],
  " on this stream, it will search for the text you specify, and make the \
current point in the file be just after the record it finds. As a result, you \
can call ",
  StyleBox["Find", "MR"],
  " several times to find successive pieces of text. "
}], "Text",
  CellTags->{"S2.12.9", "9.15"}],

Cell[TextData[{
  "This opens an input stream for ",
  StyleBox["textfile", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.16"}],

Cell[CellGroupData[{

Cell["stext = OpenRead[\"textfile\"]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \(InputStream["textfile", 80]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[TextData[{
  "This finds the first line containing ",
  StyleBox["And", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.17"}],

Cell[CellGroupData[{

Cell["Find[stext, \"And\"]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \("And the second."\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[TextData[{
  "Calling ",
  StyleBox["Find", "MR"],
  " again gives you the next line containing ",
  StyleBox["And", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.18"}],

Cell[CellGroupData[{

Cell["Find[stext, \"And\"]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \("And the third. Here is the end."\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell["This closes the input stream. ", "MathCaption",
  CellTags->{"S2.12.9", "9.19"}],

Cell[CellGroupData[{

Cell["Close[stext]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \("textfile"\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[TextData[{
  "Once you have an input stream, you can mix calls to ",
  StyleBox["Find", "MR"],
  ", ",
  StyleBox["Skip", "MR"],
  " and ",
  StyleBox["Read", "MR"],
  ". If you ever call ",
  StyleBox["FindList", "MR"],
  " or ",
  StyleBox["ReadList", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will immediately read to the end of the input stream. "
}], "Text",
  CellTags->{"S2.12.9", "9.20"}],

Cell["This opens the input stream. ", "MathCaption",
  CellTags->{"S2.12.9", "9.21"}],

Cell[CellGroupData[{

Cell["stext = OpenRead[\"textfile\"]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \(InputStream["textfile", 81]\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[TextData[{
  "This finds the first line which contains ",
  StyleBox["second", "MR"],
  ", and leaves the current point in the file at the beginning of the next \
line. "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.22"}],

Cell[CellGroupData[{

Cell["Find[stext, \"second\"]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \("And the second."\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Read", "MR"],
  " can then read the word that appears at the beginning of the line. "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.23"}],

Cell[CellGroupData[{

Cell["Read[stext, Word]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \("And"\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell["This skips over the next three words. ", "MathCaption",
  CellTags->{"S2.12.9", "9.24"}],

Cell["Skip[stext, Word, 3]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.12.9"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " finds ",
  StyleBox["is", "MR"],
  " in the remaining text, and prints the entire record as output. "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.25"}],

Cell[CellGroupData[{

Cell["Find[stext, \"is\"]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \("And the third. Here is the end."\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell["This closes the input stream. ", "MathCaption",
  CellTags->{"S2.12.9", "9.26"}],

Cell[CellGroupData[{

Cell["Close[stext]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \("textfile"\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StreamPosition[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "find the position of the current point in an open stream "]},
          {Cell[TextData[{
              StyleBox["SetStreamPosition[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["set the position of the current point "]},
          {Cell[TextData[{
              StyleBox["SetStreamPosition[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["0]", "MR"],
              " "
            }]], Cell[
            "set the current point to the beginning of a stream "]},
          {Cell[TextData[{
              StyleBox["SetStreamPosition[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Infinity]", "MR"],
              " "
            }]], Cell["set the current point to the end of a stream "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.9"],

Cell["Finding and setting the current point in a stream. ", "Caption",
  CellTags->"S2.12.9"],

Cell[TextData[{
  "Functions like ",
  StyleBox["Read", "MR"],
  ", ",
  StyleBox["Skip", "MR"],
  " and ",
  StyleBox["Find", "MR"],
  " usually operate on streams in an entirely sequential fashion. Each time \
one of the functions is called, the current point in the stream moves on. "
}], "Text",
  CellTags->{"S2.12.9", "9.27"}],

Cell[TextData[{
  "Sometimes, you may need to know where the current point in a stream is, \
and be able to reset it. On most computer systems, ",
  StyleBox["StreamPosition", "MR"],
  " returns the position of the current point as an integer giving the number \
of bytes from the beginning of the stream. "
}], "Text",
  CellTags->{"S2.12.9", "9.28"}],

Cell["This opens the stream. ", "MathCaption",
  CellTags->{"S2.12.9", "9.29"}],

Cell[CellGroupData[{

Cell["stext = OpenRead[\"textfile\"]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \(InputStream["textfile", 82]\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[TextData[{
  "When you first open the file, the current point is at the beginning, and \
",
  StyleBox["StreamPosition", "MR"],
  " returns ",
  StyleBox["0", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.30"}],

Cell[CellGroupData[{

Cell["StreamPosition[stext]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell["This reads the first line in the file. ", "MathCaption",
  CellTags->{"S2.12.9", "9.31"}],

Cell[CellGroupData[{

Cell["Read[stext, Record]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \("Here is the first line of text."\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell["Now the current point has advanced. ", "MathCaption",
  CellTags->{"S2.12.9", "9.32"}],

Cell[CellGroupData[{

Cell["StreamPosition[stext]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \(31\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell["This sets the stream position back. ", "MathCaption",
  CellTags->{"S2.12.9", "9.33"}],

Cell[CellGroupData[{

Cell["SetStreamPosition[stext, 5]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["Read", "MR"],
  " returns the remainder of the first line. "
}], "MathCaption",
  CellTags->{"S2.12.9", "9.34"}],

Cell[CellGroupData[{

Cell["Read[stext, Record]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \("is the first line of text."\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S2.12.9"]
}, Open  ]],

Cell["This closes the stream. ", "MathCaption",
  CellTags->{"S2.12.9", "9.35"}],

Cell[CellGroupData[{

Cell["Close[stext]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.12.9"],

Cell[BoxData[
    \("textfile"\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S2.12.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.12.10 Searching and Reading Strings", "Subsection",
  CellTags->{"S2.12.10", "10.1"}],

Cell[TextData[{
  "Functions like ",
  StyleBox["Read", "MR"],
  " and ",
  StyleBox["Find", "MR"],
  " are most often used for processing text and data from external files. In \
some cases, however, you may find it convenient to use these same functions \
to process strings within ",
  StyleBox["Mathematica", "TI"],
  ". You can do this by using the function ",
  StyleBox["StringToStream", "MR"],
  ", which opens an input stream that takes characters not from an external \
file, but instead from a ",
  StyleBox["Mathematica", "TI"],
  " string. "
}], "Text",
  CellTags->{"S2.12.10", "10.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StringToStream[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["open an input stream for reading from a string "]},
          {Cell[TextData[{
              StyleBox["Close[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["close an input stream "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.10"],

Cell["Treating strings as input streams. ", "Caption",
  CellTags->"S2.12.10"],

Cell["This opens an input stream for reading from the string. ", "MathCaption",
  CellTags->{"S2.12.10", "10.3"}],

Cell[CellGroupData[{

Cell["str = StringToStream[\"A string of words.\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(InputStream[String, 84]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell["\<\
This reads the first \[OpenCurlyDoubleQuote]word\
\[CloseCurlyDoubleQuote] from the string. \
\>", "MathCaption",
  CellTags->{"S2.12.10", "10.4"}],

Cell[CellGroupData[{

Cell["Read[str, Word]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \("A"\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell["This reads the remaining words from the string. ", "MathCaption",
  CellTags->{"S2.12.10", "10.5"}],

Cell[CellGroupData[{

Cell["ReadList[str, Word]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \({"string", "of", "words."}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell["This closes the input stream. ", "MathCaption",
  CellTags->{"S2.12.10", "10.6"}],

Cell[CellGroupData[{

Cell["Close[str]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(String\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell[TextData[{
  "Input streams associated with strings work just like those with files. At \
any given time, there is a current position in the stream, which advances \
when you use functions like ",
  StyleBox["Read", "MR"],
  ". The current position is given as the number of bytes from the beginning \
of the string by the function ",
  StyleBox["StreamPosition[", "MR"],
  StyleBox["stream", "TI"],
  StyleBox["]", "MR"],
  ". You can explicitly set the current position using ",
  StyleBox["SetStreamPosition[", "MR"],
  StyleBox["stream", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.10", "10.7"}],

Cell["Here is an input stream associated with a string. ", "MathCaption",
  CellTags->{"S2.12.10", "10.8"}],

Cell[CellGroupData[{

Cell["str = StringToStream[\"123 456 789\"]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(InputStream[String, 85]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell["\<\
The current position is initially 0 bytes from the beginning of the \
string. \
\>", "MathCaption",
  CellTags->{"S2.12.10", "10.9"}],

Cell[CellGroupData[{

Cell["StreamPosition[str]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell["This reads a number from the stream. ", "MathCaption",
  CellTags->{"S2.12.10", "10.10"}],

Cell[CellGroupData[{

Cell["Read[str, Number]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(123\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell["\<\
The current position is now 3 bytes from the beginning of the \
string. \
\>", "MathCaption",
  CellTags->{"S2.12.10", "10.11"}],

Cell[CellGroupData[{

Cell["StreamPosition[str]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell["\<\
This sets the current position to be 1 byte from the beginning of \
the string. \
\>", "MathCaption",
  CellTags->{"S2.12.10", "10.12"}],

Cell[CellGroupData[{

Cell["SetStreamPosition[str, 1]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell[TextData[{
  "If you now read a number from the string, you get the ",
  StyleBox["23", "MR"],
  " part of ",
  StyleBox["123", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.10", "10.13"}],

Cell[CellGroupData[{

Cell["Read[str, Number]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(23\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell["This sets the current position to the end of the string. ", \
"MathCaption",
  CellTags->{"S2.12.10", "10.14"}],

Cell[CellGroupData[{

Cell["SetStreamPosition[str, Infinity]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(11\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell[TextData[{
  "If you now try to read from the stream, you will always get ",
  StyleBox["EndOfFile", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.10", "10.15"}],

Cell[CellGroupData[{

Cell["Read[str, Number]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(EndOfFile\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell["This closes the stream. ", "MathCaption",
  CellTags->{"S2.12.10", "10.16"}],

Cell[CellGroupData[{

Cell["Close[str]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(String\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell[TextData[{
  "Particularly when you are processing large volumes of textual data, it is \
common to read fairly long strings into ",
  StyleBox["Mathematica", "TI"],
  ", then to use ",
  StyleBox["StringToStream", "MR"],
  " to allow further processing of these strings within ",
  StyleBox["Mathematica", "TI"],
  ". Once you have created an input stream using ",
  StyleBox["StringToStream", "MR"],
  ", you can read and search the string using any of the functions discussed \
for files above. "
}], "Text",
  CellTags->{"S2.12.10", "10.17"}],

Cell[TextData[{
  "This puts the whole contents of ",
  StyleBox["textfile", "MR"],
  " into a string. "
}], "MathCaption",
  CellTags->{"S2.12.10", "10.18"}],

Cell[CellGroupData[{

Cell["\<\
s = First[ ReadList[\"textfile\", Record, RecordSeparators -> {}] ]\
\
\>", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \("Here is the first line of text.\nAnd the second.\nAnd the third. Here \
is the end.\n"\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell["This opens an input stream for the string. ", "MathCaption",
  CellTags->{"S2.12.10", "10.19"}],

Cell[CellGroupData[{

Cell["str = StringToStream[s]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(InputStream[String, 87]\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell[TextData[{
  "This gives the lines of text in the string that contain ",
  StyleBox["is", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.10", "10.20"}],

Cell[CellGroupData[{

Cell["FindList[str, \"is\"]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \({"Here is the first line of text.", 
      "And the third. Here is the end."}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell["\<\
This resets the current position back to the beginning of the \
string. \
\>", "MathCaption",
  CellTags->{"S2.12.10", "10.21"}],

Cell[CellGroupData[{

Cell["SetStreamPosition[str, 0]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell[TextData[{
  "This finds the first occurrence of ",
  StyleBox["the", "MR"],
  " in the string, and leaves the current point just after it. "
}], "MathCaption",
  CellTags->{"S2.12.10", "10.22"}],

Cell[CellGroupData[{

Cell["Find[str, \"the\", RecordSeparators -> {\" \"}]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \("the"\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell[TextData[{
  "This reads the \[OpenCurlyDoubleQuote]word\[CloseCurlyDoubleQuote] which \
appears immediately after ",
  StyleBox["the", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.12.10", "10.23"}],

Cell[CellGroupData[{

Cell["Read[str, Word]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \("first"\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.12.10"]
}, Open  ]],

Cell["This closes the input stream. ", "MathCaption",
  CellTags->{"S2.12.10", "10.24"}],

Cell[CellGroupData[{

Cell["Close[str]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.12.10"],

Cell[BoxData[
    \(String\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.12.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.12.11 Advanced Topic: Binary Files", "Subsection",
  CellTags->{"S2.12.11", "11.1"}],

Cell[TextData[{
  "Functions like ",
  StyleBox["Read", "MR"],
  " and ",
  StyleBox["Write", "MR"],
  " handle ordinary printable text. But in dealing with external data files \
or devices it is sometimes necessary to go to a lower level, and work \
directly with raw binary data. You can do this using ",
  StyleBox["BinaryRead", "MR"],
  " and ",
  StyleBox["BinaryWrite", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.11", "11.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["BinaryRead[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["read one byte "]},
          {Cell[TextData[{
              StyleBox["BinaryRead[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["type", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["read an object of the specified type "]},
          {Cell[TextData[{
              StyleBox["BinaryRead[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["type",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["type",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["read a list of objects "]},
          {Cell[TextData[{
              StyleBox["BinaryWrite[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["write one byte "]},
          {Cell[TextData[{
              StyleBox["BinaryWrite[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["write a sequence of bytes "]},
          {Cell[TextData[{
              StyleBox["BinaryWrite[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["write the characters in a string "]},
          {Cell[TextData[{
              StyleBox["BinaryWrite[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["type", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["write an object of the specified type "]},
          {Cell[TextData[{
              StyleBox["BinaryWrite[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["type", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["write a sequence of objects "]},
          {Cell[TextData[{
              StyleBox["BinaryWrite[", "MR"],
              StyleBox["stream", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["type",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["type",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell["write objects of different types "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False}},
  CellTags->"S2.12.11"],

Cell["Reading and writing binary data. ", "Caption",
  CellTags->"S2.12.11"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"Byte\"", "MR"],
              " "
            }]], Cell["8\[Hyphen]bit unsigned integer "]},
          {Cell[TextData[{
              StyleBox["\"Character8\"", "MR"],
              " "
            }]], Cell["8\[Hyphen]bit character "]},
          {Cell[TextData[{
              StyleBox["\"Character16\"", "MR"],
              " "
            }]], Cell["16\[Hyphen]bit character "]},
          {Cell[TextData[{
              StyleBox["\"Complex64\"", "MR"],
              " "
            }]], 
            Cell["\<\
IEEE single\[Hyphen]precision complex number \
\>"]},
          {Cell[TextData[{
              StyleBox["\"Complex128\"", "MR"],
              " "
            }]], 
            Cell["\<\
IEEE double\[Hyphen]precision complex number \
\>"]},
          {Cell[TextData[{
              StyleBox["\"Complex256\"", "MR"],
              " "
            }]], 
            Cell["\<\
IEEE quad\[Hyphen]precision complex number \
\>"]},
          {Cell[TextData[{
              StyleBox["\"Integer8\"", "MR"],
              " "
            }]], Cell["8\[Hyphen]bit signed integer "]},
          {Cell[TextData[{
              StyleBox["\"Integer16\"", "MR"],
              " "
            }]], Cell["16\[Hyphen]bit signed integer "]},
          {Cell[TextData[{
              StyleBox["\"Integer32\"", "MR"],
              " "
            }]], Cell["32\[Hyphen]bit signed integer "]},
          {Cell[TextData[{
              StyleBox["\"Integer64\"", "MR"],
              " "
            }]], Cell["64\[Hyphen]bit signed integer "]},
          {Cell[TextData[{
              StyleBox["\"Integer128\"", "MR"],
              " "
            }]], Cell["128\[Hyphen]bit signed integer "]},
          {Cell[TextData[{
              StyleBox["\"Real32\"", "MR"],
              " "
            }]], Cell["\<\
IEEE single\[Hyphen]precision real number \
\>"]},
          {Cell[TextData[{
              StyleBox["\"Real64\"", "MR"],
              " "
            }]], Cell["\<\
IEEE double\[Hyphen]precision real number \
\>"]},
          {Cell[TextData[{
              StyleBox["\"Real128\"", "MR"],
              " "
            }]], Cell["\<\
IEEE quad\[Hyphen]precision real number \
\>"]},
          {Cell[TextData[{
              StyleBox["\"TerminatedString\"", "MR"],
              " "
            }]], 
            Cell["\<\
null\[Hyphen]terminated string of 8\[Hyphen]bit \
characters \
\>"]},
          {Cell[TextData[{
              StyleBox["\"UnsignedInteger8\"", "MR"],
              " "
            }]], Cell["8\[Hyphen]bit unsigned integer "]},
          {Cell[TextData[{
              StyleBox["\"UnsignedInteger16\"", "MR"],
              " "
            }]], Cell["16\[Hyphen]bit unsigned integer "]},
          {Cell[TextData[{
              StyleBox["\"UnsignedInteger32\"", "MR"],
              " "
            }]], Cell["32\[Hyphen]bit unsigned integer "]},
          {Cell[TextData[{
              StyleBox["\"UnsignedInteger64\"", "MR"],
              " "
            }]], Cell["64\[Hyphen]bit unsigned integer "]},
          {Cell[TextData[{
              StyleBox["\"UnsignedInteger128\"", "MR"],
              " "
            }]], Cell["128\[Hyphen]bit unsigned integer "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.11"],

Cell[TextData[{
  "Types supported in ",
  StyleBox["BinaryRead", "MR"],
  " and ",
  StyleBox["BinaryWrite", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.12.11"],

Cell["This writes a sequence of bytes to a file. ", "MathCaption",
  CellTags->{"S2.12.11", "11.3"}],

Cell[CellGroupData[{

Cell["BinaryWrite[\"tmp\", {97,98,99,100,101}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.12.11"],

Cell[BoxData[
    \("tmp"\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.12.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["BinaryWrite", "MR"],
  " automatically opens a stream for the file. This closes it. "
}], "MathCaption",
  CellTags->{"S2.12.11", "11.4"}],

Cell["Close[\"tmp\"];", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.12.11"],

Cell["\<\
This reads the first byte from the file, returning it as an \
integer. \
\>", "MathCaption",
  CellTags->{"S2.12.11", "11.5"}],

Cell[CellGroupData[{

Cell["BinaryRead[\"tmp\"]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.12.11"],

Cell[BoxData[
    \(97\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.12.11"]
}, Open  ]],

Cell["This reads the second 8 bits in the file as character. ", "MathCaption",
  CellTags->{"S2.12.11", "11.6"}],

Cell[CellGroupData[{

Cell["BinaryRead[\"tmp\", \"Character8\"]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.12.11"],

Cell[BoxData[
    \("b"\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.12.11"]
}, Open  ]],

Cell["\<\
This reads the next 32 bits as a 32\[Hyphen]bit integer. \
\>", \
"MathCaption",
  CellTags->{"S2.12.11", "11.7"}],

Cell[CellGroupData[{

Cell["BinaryRead[\"tmp\", \"Integer32\"]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.12.11"],

Cell[BoxData[
    \(EndOfFile\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.12.11"]
}, Open  ]],

Cell[TextData[{
  "Like ",
  StyleBox["Read", "MR"],
  " and ",
  StyleBox["Write", "MR"],
  ", ",
  StyleBox["BinaryRead", "MR"],
  " and ",
  StyleBox["BinaryWrite", "MR"],
  " work with streams. But if you give a file name, they automatically open \
the specified file as a stream. To create a stream directly you can use ",
  StyleBox["OpenRead", "MR"],
  " or ",
  StyleBox["OpenWrite", "MR"],
  ". On some computer systems, the option setting ",
  StyleBox["BinaryFormat->True", "MR"],
  " is required for any stream to be used with ",
  StyleBox["BinaryRead", "MR"],
  " and ",
  StyleBox["BinaryWrite", "MR"],
  ", in order to prevent possible corruption from such issues as newline \
translation.  "
}], "Text",
  CellTags->{"S2.12.11", "11.8"}],

Cell[TextData[{
  "In using ",
  StyleBox["Mathematica", "TI"],
  " you are normally completely insulated from the raw representation of data \
inside your computer. But with ",
  StyleBox["BinaryRead", "MR"],
  " and ",
  StyleBox["BinaryWrite", "MR"],
  " this is no longer so. One of the subtleties that then arises is that \
different computers may take the bytes that make up numbers to be in \
different orders, as specified by their setting for ",
  StyleBox["$ByteOrdering", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.11", "11.9"}],

Cell["\<\
This write a 32\[Hyphen]bit integer to a file. \
\>", "MathCaption",
  CellTags->{"S2.12.11", "11.10"}],

Cell[CellGroupData[{

Cell["BinaryWrite[\"tmp2\", 45671, \"Integer32\"]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.12.11"],

Cell[BoxData[
    \("tmp2"\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.12.11"]
}, Open  ]],

Cell["This closes the file. ", "MathCaption",
  CellTags->{"S2.12.11", "11.11"}],

Cell["Close[\"tmp2\"];", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.12.11"],

Cell["\<\
This reads the integer back, but assuming an opposite byte \
ordering. \
\>", "MathCaption",
  CellTags->{"S2.12.11", "11.12"}],

Cell[CellGroupData[{

Cell["\<\
BinaryRead[\"tmp2\", \"Integer32\", ByteOrdering -> -$ByteOrdering]\
\
\>", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.12.11"],

Cell[BoxData[
    \(1739718656\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.12.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["BinaryReadList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["read all the bytes in a file "]},
          {Cell[TextData[{
              StyleBox["BinaryReadList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["type", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "read all the data, treating it as objects of a certain type "]},
          {Cell[TextData[{
              StyleBox["BinaryReadList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["type",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["type",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["treat the data as objects of a sequence of types "]},
          {Cell[TextData[{
              StyleBox["BinaryReadList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["types", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "read only the first ",
              StyleBox["n", "TI"],
              " objects "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.12.11"],

Cell["Reading complete binary files. ", "Caption",
  CellTags->"S2.12.11"],

Cell["\<\
This writes out a 128\[Hyphen]bit real number. \
\>", "MathCaption",
  CellTags->{"S2.12.11", "11.13"}],

Cell[CellGroupData[{

Cell["BinaryWrite[\"tmp3\", 5.67891, \"Real128\"]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.12.11"],

Cell[BoxData[
    \("tmp3"\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.12.11"]
}, Open  ]],

Cell["This reads back the bytes in the number. ", "MathCaption",
  CellTags->{"S2.12.11", "11.14"}],

Cell[CellGroupData[{

Cell["BinaryReadList[\"tmp3\", \"Byte\"]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.12.11"],

Cell[BoxData[
    \({0, 0, 0, 0, 0, 0, 0, 224, 89, 187, 237, 66, 115, 107, 1, 
      64}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.12.11"]
}, Open  ]],

Cell["\<\
This reads back the bytes as a sequence of 32\[Hyphen]bit real \
numbers. \
\>", "MathCaption",
  CellTags->{"S2.12.11", "11.15"}],

Cell[CellGroupData[{

Cell["BinaryReadList[\"tmp3\", \"Real32\"]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.12.11"],

Cell[BoxData[
    \({0.`, \(-3.6893488147419103`*^19\), 118.86591339111328`, 
      2.0221831798553467`}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.12.11"]
}, Open  ]],

Cell["\<\
This treats the data as pairs containing a byte and a \
32\[Hyphen]bit real. \
\>", "MathCaption",
  CellTags->{"S2.12.11", "11.16"}],

Cell[CellGroupData[{

Cell["BinaryReadList[\"tmp3\", {\"Byte\", \"Real32\"}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.12.11"],

Cell[BoxData[
    \({{0, 0.`}, {0, \(-0.0033245086669921875`\)}, {237, 
        4.3245376619232606`*^-38}, {64, EndOfFile}}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.12.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["BinaryRead", "MR"],
  " and ",
  StyleBox["BinaryWrite", "MR"],
  " allow complete flexibility in reading and writing raw binary data. But in \
many practical applications one instead wants to work only with particular \
predefined formats. You can do this using ",
  StyleBox["Import", "MR"],
  " and ",
  StyleBox["Export", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.11", "11.17"}],

Cell[TextData[{
  "In addition to many complex formats, ",
  StyleBox["Import", "MR"],
  " and ",
  StyleBox["Export", "MR"],
  " support files containing sequences of identical data elements, of the \
same types as in ",
  StyleBox["BinaryRead", "MR"],
  " and ",
  StyleBox["BinaryWrite", "MR"],
  ". They also support the ",
  StyleBox["\"Bit\"", "MR"],
  " format, consisting of individual binary bits, represented as ",
  StyleBox["0", "MR"],
  " or ",
  StyleBox["1", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.12.11", "11.18"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.12.0"->{
    Cell[1776, 53, 122, 4, 65, "Section",
      CellTags->{"S2.12.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 122, 4, 65, "Section",
      CellTags->{"S2.12.0", "0.1"}]},
  "S2.12.1"->{
    Cell[1923, 61, 143, 5, 70, "Subsection",
      CellTags->{"S2.12.1", "1.1"}],
    Cell[2069, 68, 478, 13, 70, "Text",
      CellTags->{"S2.12.1", "1.2"}],
    Cell[2550, 83, 863, 24, 70, "DefinitionBox",
      CellTags->"S2.12.1"],
    Cell[3416, 109, 57, 1, 70, "Caption",
      CellTags->"S2.12.1"],
    Cell[3476, 112, 144, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.3"}],
    Cell[3645, 121, 74, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[3722, 125, 186, 5, 70, "Print",
      CellTags->"S2.12.1"],
    Cell[3923, 133, 128, 4, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.4"}],
    Cell[4076, 141, 74, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[4153, 145, 254, 5, 70, "Output",
      CellTags->"S2.12.1"],
    Cell[4422, 153, 239, 8, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.5"}],
    Cell[4686, 165, 73, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[4762, 169, 126, 3, 70, "Message",
      CellTags->"S2.12.1"],
    Cell[4891, 174, 89, 3, 70, "Output",
      CellTags->"S2.12.1"],
    Cell[4995, 180, 540, 10, 70, "Text",
      CellTags->{"S2.12.1", "1.6"}],
    Cell[5538, 192, 450, 12, 70, "Text",
      CellTags->{"S2.12.1", "1.7"}],
    Cell[5991, 206, 530, 13, 70, "Text",
      CellTags->{"S2.12.1", "1.8"}],
    Cell[6524, 221, 1293, 38, 70, "DefinitionBox",
      CellTags->"S2.12.1"],
    Cell[7820, 261, 72, 1, 70, "Caption",
      CellTags->"S2.12.1"],
    Cell[7895, 264, 142, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.9"}],
    Cell[8040, 271, 87, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[8130, 275, 91, 1, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.10"}],
    Cell[8246, 280, 70, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[8319, 284, 84, 1, 70, "Print",
      CellTags->"S2.12.1"],
    Cell[8418, 288, 106, 1, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.11"}],
    Cell[8527, 291, 88, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[8618, 295, 94, 1, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.12"}],
    Cell[8737, 300, 70, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[8810, 304, 129, 4, 70, "Print",
      CellTags->"S2.12.1"],
    Cell[8954, 311, 562, 22, 70, "Text",
      CellTags->{"S2.12.1", "1.13"}],
    Cell[9519, 335, 565, 14, 70, "Text",
      CellTags->{"S2.12.1", "1.14"}],
    Cell[10087, 351, 160, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.15"}],
    Cell[10250, 358, 101, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[10354, 362, 147, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.16"}],
    Cell[10526, 371, 70, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[10599, 375, 132, 4, 70, "Print",
      CellTags->"S2.12.1"],
    Cell[10746, 382, 685, 20, 70, "Text",
      CellTags->{"S2.12.1", "1.17"}],
    Cell[11434, 404, 2327, 68, 70, "DefinitionBox",
      CellTags->"S2.12.1"],
    Cell[13764, 474, 67, 1, 70, "Caption",
      CellTags->"S2.12.1"],
    Cell[13834, 477, 138, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.18"}],
    Cell[13997, 486, 77, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[14077, 490, 91, 3, 70, "Output",
      CellTags->"S2.12.1"],
    Cell[14183, 496, 185, 7, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.19"}],
    Cell[14371, 505, 84, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[14458, 509, 156, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.20"}],
    Cell[14639, 518, 73, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[14715, 522, 51, 1, 70, "Print",
      CellTags->"S2.12.1"],
    Cell[14781, 526, 1278, 26, 70, "Text",
      CellTags->{"S2.12.1", "1.21"}],
    Cell[16062, 554, 199, 7, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.22"}],
    Cell[16264, 563, 82, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[16349, 567, 151, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.23"}],
    Cell[16503, 574, 84, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[16590, 578, 271, 9, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.24"}],
    Cell[16886, 591, 73, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[16962, 595, 78, 5, 70, "Print",
      CellTags->"S2.12.1"],
    Cell[17055, 603, 387, 12, 70, "Text",
      CellTags->{"S2.12.1", "1.25"}],
    Cell[17445, 617, 267, 9, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.26"}],
    Cell[17737, 630, 79, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[17819, 634, 445, 14, 70, "Output",
      CellTags->"S2.12.1"],
    Cell[18279, 651, 240, 8, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.27"}],
    Cell[18544, 663, 83, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[18630, 667, 996, 29, 70, "Output",
      CellTags->"S2.12.1"],
    Cell[19641, 699, 655, 15, 70, "Text",
      CellTags->{"S2.12.1", "1.28"}],
    Cell[20299, 716, 2417, 73, 70, "DefinitionBox",
      CellTags->"S2.12.1"],
    Cell[22719, 791, 78, 1, 70, "Caption",
      CellTags->"S2.12.1"],
    Cell[22800, 794, 157, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.29"}],
    Cell[22960, 801, 88, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[23051, 805, 194, 7, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.30"}],
    Cell[23248, 814, 92, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[23343, 818, 225, 6, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.31"}],
    Cell[23593, 828, 73, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[23669, 832, 80, 4, 70, "Print",
      CellTags->"S2.12.1"],
    Cell[23764, 839, 223, 7, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.32"}],
    Cell[24012, 850, 73, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[24088, 854, 112, 3, 70, "Output",
      CellTags->"S2.12.1"],
    Cell[24215, 860, 2284, 64, 70, "DefinitionBox",
      CellTags->"S2.12.1"],
    Cell[26502, 926, 137, 5, 70, "Caption",
      CellTags->"S2.12.1"],
    Cell[26642, 933, 335, 8, 70, "Text",
      CellTags->{"S2.12.1", "1.33"}],
    Cell[26980, 943, 192, 7, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.34"}],
    Cell[27197, 954, 91, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[27291, 958, 86, 3, 70, "Output",
      CellTags->"S2.12.1"],
    Cell[27392, 964, 148, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.35"}],
    Cell[27543, 971, 76, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[27622, 975, 458, 10, 70, "Text",
      CellTags->{"S2.12.1", "1.36"}],
    Cell[28083, 987, 577, 22, 70, "Text",
      CellTags->{"S2.12.1", "1.37"}],
    Cell[28663, 1011, 156, 4, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.38"}],
    Cell[28844, 1019, 90, 2, 70, "Input",
      CellTags->"S2.12.1"],
    Cell[28937, 1023, 86, 3, 70, "Output",
      CellTags->"S2.12.1"],
    Cell[29038, 1029, 184, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.39"}],
    Cell[29225, 1036, 75, 2, 70, "Input",
      CellTags->"S2.12.1"]},
  "1.1"->{
    Cell[1923, 61, 143, 5, 70, "Subsection",
      CellTags->{"S2.12.1", "1.1"}]},
  "1.2"->{
    Cell[2069, 68, 478, 13, 70, "Text",
      CellTags->{"S2.12.1", "1.2"}]},
  "1.3"->{
    Cell[3476, 112, 144, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.3"}]},
  "1.4"->{
    Cell[3923, 133, 128, 4, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.4"}]},
  "1.5"->{
    Cell[4422, 153, 239, 8, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.5"}]},
  "1.6"->{
    Cell[4995, 180, 540, 10, 70, "Text",
      CellTags->{"S2.12.1", "1.6"}]},
  "1.7"->{
    Cell[5538, 192, 450, 12, 70, "Text",
      CellTags->{"S2.12.1", "1.7"}]},
  "1.8"->{
    Cell[5991, 206, 530, 13, 70, "Text",
      CellTags->{"S2.12.1", "1.8"}]},
  "1.9"->{
    Cell[7895, 264, 142, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.9"}]},
  "1.10"->{
    Cell[8130, 275, 91, 1, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.10"}]},
  "1.11"->{
    Cell[8418, 288, 106, 1, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.11"}]},
  "1.12"->{
    Cell[8618, 295, 94, 1, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.12"}]},
  "1.13"->{
    Cell[8954, 311, 562, 22, 70, "Text",
      CellTags->{"S2.12.1", "1.13"}]},
  "1.14"->{
    Cell[9519, 335, 565, 14, 70, "Text",
      CellTags->{"S2.12.1", "1.14"}]},
  "1.15"->{
    Cell[10087, 351, 160, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.15"}]},
  "1.16"->{
    Cell[10354, 362, 147, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.16"}]},
  "1.17"->{
    Cell[10746, 382, 685, 20, 70, "Text",
      CellTags->{"S2.12.1", "1.17"}]},
  "1.18"->{
    Cell[13834, 477, 138, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.18"}]},
  "1.19"->{
    Cell[14183, 496, 185, 7, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.19"}]},
  "1.20"->{
    Cell[14458, 509, 156, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.20"}]},
  "1.21"->{
    Cell[14781, 526, 1278, 26, 70, "Text",
      CellTags->{"S2.12.1", "1.21"}]},
  "1.22"->{
    Cell[16062, 554, 199, 7, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.22"}]},
  "1.23"->{
    Cell[16349, 567, 151, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.23"}]},
  "1.24"->{
    Cell[16590, 578, 271, 9, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.24"}]},
  "1.25"->{
    Cell[17055, 603, 387, 12, 70, "Text",
      CellTags->{"S2.12.1", "1.25"}]},
  "1.26"->{
    Cell[17445, 617, 267, 9, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.26"}]},
  "1.27"->{
    Cell[18279, 651, 240, 8, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.27"}]},
  "1.28"->{
    Cell[19641, 699, 655, 15, 70, "Text",
      CellTags->{"S2.12.1", "1.28"}]},
  "1.29"->{
    Cell[22800, 794, 157, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.29"}]},
  "1.30"->{
    Cell[23051, 805, 194, 7, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.30"}]},
  "1.31"->{
    Cell[23343, 818, 225, 6, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.31"}]},
  "1.32"->{
    Cell[23764, 839, 223, 7, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.32"}]},
  "1.33"->{
    Cell[26642, 933, 335, 8, 70, "Text",
      CellTags->{"S2.12.1", "1.33"}]},
  "1.34"->{
    Cell[26980, 943, 192, 7, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.34"}]},
  "1.35"->{
    Cell[27392, 964, 148, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.35"}]},
  "1.36"->{
    Cell[27622, 975, 458, 10, 70, "Text",
      CellTags->{"S2.12.1", "1.36"}]},
  "1.37"->{
    Cell[28083, 987, 577, 22, 70, "Text",
      CellTags->{"S2.12.1", "1.37"}]},
  "1.38"->{
    Cell[28663, 1011, 156, 4, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.38"}]},
  "1.39"->{
    Cell[29038, 1029, 184, 5, 70, "MathCaption",
      CellTags->{"S2.12.1", "1.39"}]},
  "S2.12.2"->{
    Cell[29337, 1043, 78, 1, 70, "Subsection",
      CellTags->{"S2.12.2", "2.1"}],
    Cell[29418, 1046, 434, 11, 70, "Text",
      CellTags->{"S2.12.2", "2.2"}],
    Cell[29855, 1059, 249, 8, 70, "Text",
      CellTags->{"S2.12.2", "2.3"}],
    Cell[30107, 1069, 642, 18, 70, "DefinitionBox",
      CellTags->"S2.12.2"],
    Cell[30752, 1089, 152, 5, 70, "Caption",
      CellTags->"S2.12.2"],
    Cell[30907, 1096, 451, 12, 70, "Text",
      CellTags->{"S2.12.2", "2.4"}],
    Cell[31361, 1110, 296, 6, 70, "Text",
      CellTags->{"S2.12.2", "2.5"}],
    Cell[31660, 1118, 964, 29, 70, "DefinitionBox",
      CellTags->"S2.12.2"],
    Cell[32627, 1149, 84, 1, 70, "Caption",
      CellTags->"S2.12.2"],
    Cell[32714, 1152, 425, 10, 70, "Text",
      CellTags->{"S2.12.2", "2.6"}],
    Cell[33142, 1164, 254, 7, 70, "MathCaption",
      CellTags->{"S2.12.2", "2.7"}],
    Cell[33399, 1173, 96, 2, 70, "Input",
      CellTags->"S2.12.2"],
    Cell[33498, 1177, 246, 9, 70, "MathCaption",
      CellTags->{"S2.12.2", "2.8"}],
    Cell[33769, 1190, 82, 2, 70, "Input",
      CellTags->"S2.12.2"],
    Cell[33854, 1194, 86, 3, 70, "Output",
      CellTags->"S2.12.2"],
    Cell[33955, 1200, 337, 8, 70, "Text",
      CellTags->{"S2.12.2", "2.9"}],
    Cell[34295, 1210, 731, 16, 70, "Text",
      CellTags->{"S2.12.2", "2.10"}],
    Cell[35029, 1228, 262, 5, 70, "Text",
      CellTags->{"S2.12.2", "2.11"}],
    Cell[35294, 1235, 421, 12, 70, "DefinitionBox",
      CellTags->"S2.12.2"],
    Cell[35718, 1249, 68, 1, 70, "Caption",
      CellTags->"S2.12.2"],
    Cell[35789, 1252, 380, 11, 70, "Text",
      CellTags->{"S2.12.2", "2.12"}],
    Cell[36172, 1265, 874, 26, 70, "DefinitionBox",
      CellTags->"S2.12.2"],
    Cell[37049, 1293, 93, 1, 70, "Caption",
      CellTags->"S2.12.2"],
    Cell[37145, 1296, 257, 6, 70, "MathCaption",
      CellTags->{"S2.12.2", "2.13"}],
    Cell[37427, 1306, 78, 2, 70, "Input",
      CellTags->"S2.12.2"],
    Cell[37508, 1310, 86, 2, 70, "Print",
      CellTags->"S2.12.2"],
    Cell[37597, 1314, 83, 3, 70, "Output",
      CellTags->"S2.12.2"],
    Cell[37695, 1320, 380, 9, 70, "Text",
      CellTags->{"S2.12.2", "2.14"}],
    Cell[38078, 1331, 837, 17, 70, "Text",
      CellTags->{"S2.12.2", "2.15"}],
    Cell[38918, 1350, 519, 15, 70, "DefinitionBox",
      CellTags->"S2.12.2"],
    Cell[39440, 1367, 116, 5, 70, "Caption",
      CellTags->"S2.12.2"],
    Cell[39559, 1374, 429, 9, 70, "Text",
      CellTags->{"S2.12.2", "2.16"}],
    Cell[39991, 1385, 541, 14, 70, "Text",
      CellTags->{"S2.12.2", "2.17"}],
    Cell[40535, 1401, 223, 6, 70, "MathCaption",
      CellTags->{"S2.12.2", "2.18"}],
    Cell[40783, 1411, 70, 2, 70, "Input",
      CellTags->"S2.12.2"],
    Cell[40856, 1415, 86, 2, 70, "Print",
      CellTags->"S2.12.2"],
    Cell[40945, 1419, 83, 3, 70, "Output",
      CellTags->"S2.12.2"],
    Cell[41043, 1425, 751, 22, 70, "DefinitionBox",
      CellTags->"S2.12.2"],
    Cell[41797, 1449, 145, 5, 70, "Caption",
      CellTags->"S2.12.2"],
    Cell[41945, 1456, 403, 10, 70, "Text",
      CellTags->{"S2.12.2", "2.19"}],
    Cell[42351, 1468, 476, 13, 70, "Text",
      CellTags->{"S2.12.2", "2.20"}],
    Cell[42830, 1483, 362, 12, 70, "MathCaption",
      CellTags->{"S2.12.2", "2.21"}],
    Cell[43217, 1499, 89, 2, 70, "Input",
      CellTags->"S2.12.2"],
    Cell[43309, 1503, 85, 3, 70, "Output",
      CellTags->"S2.12.2"]},
  "2.1"->{
    Cell[29337, 1043, 78, 1, 70, "Subsection",
      CellTags->{"S2.12.2", "2.1"}]},
  "2.2"->{
    Cell[29418, 1046, 434, 11, 70, "Text",
      CellTags->{"S2.12.2", "2.2"}]},
  "2.3"->{
    Cell[29855, 1059, 249, 8, 70, "Text",
      CellTags->{"S2.12.2", "2.3"}]},
  "2.4"->{
    Cell[30907, 1096, 451, 12, 70, "Text",
      CellTags->{"S2.12.2", "2.4"}]},
  "2.5"->{
    Cell[31361, 1110, 296, 6, 70, "Text",
      CellTags->{"S2.12.2", "2.5"}]},
  "2.6"->{
    Cell[32714, 1152, 425, 10, 70, "Text",
      CellTags->{"S2.12.2", "2.6"}]},
  "2.7"->{
    Cell[33142, 1164, 254, 7, 70, "MathCaption",
      CellTags->{"S2.12.2", "2.7"}]},
  "2.8"->{
    Cell[33498, 1177, 246, 9, 70, "MathCaption",
      CellTags->{"S2.12.2", "2.8"}]},
  "2.9"->{
    Cell[33955, 1200, 337, 8, 70, "Text",
      CellTags->{"S2.12.2", "2.9"}]},
  "2.10"->{
    Cell[34295, 1210, 731, 16, 70, "Text",
      CellTags->{"S2.12.2", "2.10"}]},
  "2.11"->{
    Cell[35029, 1228, 262, 5, 70, "Text",
      CellTags->{"S2.12.2", "2.11"}]},
  "2.12"->{
    Cell[35789, 1252, 380, 11, 70, "Text",
      CellTags->{"S2.12.2", "2.12"}]},
  "2.13"->{
    Cell[37145, 1296, 257, 6, 70, "MathCaption",
      CellTags->{"S2.12.2", "2.13"}]},
  "2.14"->{
    Cell[37695, 1320, 380, 9, 70, "Text",
      CellTags->{"S2.12.2", "2.14"}]},
  "2.15"->{
    Cell[38078, 1331, 837, 17, 70, "Text",
      CellTags->{"S2.12.2", "2.15"}]},
  "2.16"->{
    Cell[39559, 1374, 429, 9, 70, "Text",
      CellTags->{"S2.12.2", "2.16"}]},
  "2.17"->{
    Cell[39991, 1385, 541, 14, 70, "Text",
      CellTags->{"S2.12.2", "2.17"}]},
  "2.18"->{
    Cell[40535, 1401, 223, 6, 70, "MathCaption",
      CellTags->{"S2.12.2", "2.18"}]},
  "2.19"->{
    Cell[41945, 1456, 403, 10, 70, "Text",
      CellTags->{"S2.12.2", "2.19"}]},
  "2.20"->{
    Cell[42351, 1468, 476, 13, 70, "Text",
      CellTags->{"S2.12.2", "2.20"}]},
  "2.21"->{
    Cell[42830, 1483, 362, 12, 70, "MathCaption",
      CellTags->{"S2.12.2", "2.21"}]},
  "S2.12.3"->{
    Cell[43443, 1512, 133, 4, 70, "Subsection",
      CellTags->{"S2.12.3", "3.1"}],
    Cell[43579, 1518, 348, 10, 70, "Text",
      CellTags->{"S2.12.3", "3.2"}],
    Cell[43930, 1530, 718, 18, 70, "Text",
      CellTags->{"S2.12.3", "3.3"}],
    Cell[44651, 1550, 841, 21, 70, "Text",
      CellTags->{"S2.12.3", "3.4"}],
    Cell[45495, 1573, 1231, 36, 70, "DefinitionBox",
      CellTags->"S2.12.3"],
    Cell[46729, 1611, 110, 5, 70, "Caption",
      CellTags->"S2.12.3"],
    Cell[46842, 1618, 409, 8, 70, "Text",
      CellTags->{"S2.12.3", "3.5"}],
    Cell[47254, 1628, 367, 7, 70, "Text",
      CellTags->{"S2.12.3", "3.6"}],
    Cell[47624, 1637, 246, 5, 70, "Text",
      CellTags->{"S2.12.3", "3.7"}],
    Cell[47873, 1644, 144, 5, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.8"}],
    Cell[48042, 1653, 90, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[48135, 1657, 105, 3, 70, "Output",
      CellTags->"S2.12.3"],
    Cell[48255, 1663, 106, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.9"}],
    Cell[48364, 1666, 85, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[48452, 1670, 216, 5, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.10"}],
    Cell[48671, 1677, 82, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[48756, 1681, 80, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.11"}],
    Cell[48861, 1686, 76, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[48940, 1690, 87, 3, 70, "Output",
      CellTags->"S2.12.3"],
    Cell[49042, 1696, 94, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.12"}],
    Cell[49161, 1701, 70, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[49234, 1705, 53, 4, 70, "Print",
      CellTags->"S2.12.3"],
    Cell[49302, 1712, 3559, 111, 70, "DefinitionBox",
      CellTags->"S2.12.3"],
    Cell[52864, 1825, 78, 1, 70, "Caption",
      CellTags->"S2.12.3"],
    Cell[52945, 1828, 713, 19, 70, "Text",
      CellTags->{"S2.12.3", "3.13"}],
    Cell[53661, 1849, 136, 5, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.14"}],
    Cell[53822, 1858, 90, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[53915, 1862, 105, 3, 70, "Output",
      CellTags->"S2.12.3"],
    Cell[54035, 1868, 139, 4, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.15"}],
    Cell[54199, 1876, 121, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[54323, 1880, 87, 3, 70, "Output",
      CellTags->"S2.12.3"],
    Cell[54425, 1886, 211, 6, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.16"}],
    Cell[54661, 1896, 70, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[54734, 1900, 62, 4, 70, "Print",
      CellTags->"S2.12.3"],
    Cell[54811, 1907, 461, 13, 70, "Text",
      CellTags->{"S2.12.3", "3.17"}],
    Cell[55275, 1922, 79, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.18"}],
    Cell[55379, 1927, 90, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[55472, 1931, 105, 3, 70, "Output",
      CellTags->"S2.12.3"],
    Cell[55592, 1937, 95, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.19"}],
    Cell[55690, 1940, 127, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[55820, 1944, 108, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.20"}],
    Cell[55953, 1949, 118, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[56074, 1953, 88, 3, 70, "Output",
      CellTags->"S2.12.3"],
    Cell[56177, 1959, 206, 5, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.21"}],
    Cell[56408, 1968, 71, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[56482, 1972, 92, 4, 70, "Print",
      CellTags->"S2.12.3"],
    Cell[56589, 1979, 2252, 62, 70, "DefinitionBox",
      CellTags->"S2.12.3"],
    Cell[58844, 2043, 78, 1, 70, "Caption",
      CellTags->"S2.12.3"],
    Cell[58925, 2046, 282, 8, 70, "Text",
      CellTags->{"S2.12.3", "3.22"}],
    Cell[59210, 2056, 383, 10, 70, "Text",
      CellTags->{"S2.12.3", "3.23"}],
    Cell[59596, 2068, 984, 29, 70, "Text",
      CellTags->{"S2.12.3", "3.24"}],
    Cell[60583, 2099, 428, 11, 70, "Text",
      CellTags->{"S2.12.3", "3.25"}],
    Cell[61014, 2112, 361, 8, 70, "Text",
      CellTags->{"S2.12.3", "3.26"}],
    Cell[61378, 2122, 470, 14, 70, "DefinitionBox",
      CellTags->"S2.12.3"],
    Cell[61851, 2138, 89, 1, 70, "Caption",
      CellTags->"S2.12.3"],
    Cell[61943, 2141, 563, 12, 70, "Text",
      CellTags->{"S2.12.3", "3.27"}],
    Cell[62509, 2155, 1540, 45, 70, "DefinitionBox3Col",
      CellTags->"S2.12.3"],
    Cell[64052, 2202, 75, 1, 70, "Caption",
      CellTags->"S2.12.3"],
    Cell[64130, 2205, 272, 8, 70, "Text",
      CellTags->{"S2.12.3", "3.28"}],
    Cell[64405, 2215, 192, 6, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.29"}],
    Cell[64622, 2225, 117, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[64742, 2229, 106, 3, 70, "Output",
      CellTags->"S2.12.3"],
    Cell[64863, 2235, 129, 4, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.30"}],
    Cell[65017, 2243, 113, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[65133, 2247, 88, 3, 70, "Output",
      CellTags->"S2.12.3"],
    Cell[65236, 2253, 158, 5, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.31"}],
    Cell[65419, 2262, 71, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[65493, 2266, 78, 4, 70, "Print",
      CellTags->"S2.12.3"],
    Cell[65586, 2273, 377, 11, 70, "Text",
      CellTags->{"S2.12.3", "3.32"}],
    Cell[65966, 2286, 1011, 29, 70, "Text",
      CellTags->{"S2.12.3", "3.33"}],
    Cell[66980, 2317, 136, 4, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.34"}],
    Cell[67141, 2325, 108, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[67252, 2329, 106, 3, 70, "Output",
      CellTags->"S2.12.3"],
    Cell[67373, 2335, 111, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.35"}],
    Cell[67509, 2340, 109, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[67621, 2344, 88, 3, 70, "Output",
      CellTags->"S2.12.3"],
    Cell[67724, 2350, 161, 4, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.36"}],
    Cell[67910, 2358, 71, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[67984, 2362, 91, 5, 70, "Print",
      CellTags->"S2.12.3"],
    Cell[68090, 2370, 588, 14, 70, "Text",
      CellTags->{"S2.12.3", "3.37"}],
    Cell[68681, 2386, 1302, 37, 70, "DefinitionBox",
      CellTags->"S2.12.3"],
    Cell[69986, 2425, 75, 1, 70, "Caption",
      CellTags->"S2.12.3"],
    Cell[70064, 2428, 117, 2, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.38"}],
    Cell[70206, 2434, 91, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[70300, 2438, 106, 3, 70, "Output",
      CellTags->"S2.12.3"],
    Cell[70421, 2444, 156, 5, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.39"}],
    Cell[70580, 2451, 106, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[70689, 2455, 154, 4, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.40"}],
    Cell[70868, 2463, 79, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[70950, 2467, 362, 7, 70, "Output",
      CellTags->"S2.12.3"],
    Cell[71327, 2477, 86, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.41"}],
    Cell[71438, 2482, 77, 2, 70, "Input",
      CellTags->"S2.12.3"],
    Cell[71518, 2486, 88, 3, 70, "Output",
      CellTags->"S2.12.3"],
    Cell[71621, 2492, 1381, 41, 70, "DefinitionBox",
      CellTags->"S2.12.3"],
    Cell[73005, 2535, 96, 1, 70, "Caption",
      CellTags->"S2.12.3"],
    Cell[73104, 2538, 549, 16, 70, "Text",
      CellTags->{"S2.12.3", "3.42"}]},
  "3.1"->{
    Cell[43443, 1512, 133, 4, 70, "Subsection",
      CellTags->{"S2.12.3", "3.1"}]},
  "3.2"->{
    Cell[43579, 1518, 348, 10, 70, "Text",
      CellTags->{"S2.12.3", "3.2"}]},
  "3.3"->{
    Cell[43930, 1530, 718, 18, 70, "Text",
      CellTags->{"S2.12.3", "3.3"}]},
  "3.4"->{
    Cell[44651, 1550, 841, 21, 70, "Text",
      CellTags->{"S2.12.3", "3.4"}]},
  "3.5"->{
    Cell[46842, 1618, 409, 8, 70, "Text",
      CellTags->{"S2.12.3", "3.5"}]},
  "3.6"->{
    Cell[47254, 1628, 367, 7, 70, "Text",
      CellTags->{"S2.12.3", "3.6"}]},
  "3.7"->{
    Cell[47624, 1637, 246, 5, 70, "Text",
      CellTags->{"S2.12.3", "3.7"}]},
  "3.8"->{
    Cell[47873, 1644, 144, 5, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.8"}]},
  "3.9"->{
    Cell[48255, 1663, 106, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.9"}]},
  "3.10"->{
    Cell[48452, 1670, 216, 5, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.10"}]},
  "3.11"->{
    Cell[48756, 1681, 80, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.11"}]},
  "3.12"->{
    Cell[49042, 1696, 94, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.12"}]},
  "3.13"->{
    Cell[52945, 1828, 713, 19, 70, "Text",
      CellTags->{"S2.12.3", "3.13"}]},
  "3.14"->{
    Cell[53661, 1849, 136, 5, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.14"}]},
  "3.15"->{
    Cell[54035, 1868, 139, 4, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.15"}]},
  "3.16"->{
    Cell[54425, 1886, 211, 6, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.16"}]},
  "3.17"->{
    Cell[54811, 1907, 461, 13, 70, "Text",
      CellTags->{"S2.12.3", "3.17"}]},
  "3.18"->{
    Cell[55275, 1922, 79, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.18"}]},
  "3.19"->{
    Cell[55592, 1937, 95, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.19"}]},
  "3.20"->{
    Cell[55820, 1944, 108, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.20"}]},
  "3.21"->{
    Cell[56177, 1959, 206, 5, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.21"}]},
  "3.22"->{
    Cell[58925, 2046, 282, 8, 70, "Text",
      CellTags->{"S2.12.3", "3.22"}]},
  "3.23"->{
    Cell[59210, 2056, 383, 10, 70, "Text",
      CellTags->{"S2.12.3", "3.23"}]},
  "3.24"->{
    Cell[59596, 2068, 984, 29, 70, "Text",
      CellTags->{"S2.12.3", "3.24"}]},
  "3.25"->{
    Cell[60583, 2099, 428, 11, 70, "Text",
      CellTags->{"S2.12.3", "3.25"}]},
  "3.26"->{
    Cell[61014, 2112, 361, 8, 70, "Text",
      CellTags->{"S2.12.3", "3.26"}]},
  "3.27"->{
    Cell[61943, 2141, 563, 12, 70, "Text",
      CellTags->{"S2.12.3", "3.27"}]},
  "3.28"->{
    Cell[64130, 2205, 272, 8, 70, "Text",
      CellTags->{"S2.12.3", "3.28"}]},
  "3.29"->{
    Cell[64405, 2215, 192, 6, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.29"}]},
  "3.30"->{
    Cell[64863, 2235, 129, 4, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.30"}]},
  "3.31"->{
    Cell[65236, 2253, 158, 5, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.31"}]},
  "3.32"->{
    Cell[65586, 2273, 377, 11, 70, "Text",
      CellTags->{"S2.12.3", "3.32"}]},
  "3.33"->{
    Cell[65966, 2286, 1011, 29, 70, "Text",
      CellTags->{"S2.12.3", "3.33"}]},
  "3.34"->{
    Cell[66980, 2317, 136, 4, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.34"}]},
  "3.35"->{
    Cell[67373, 2335, 111, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.35"}]},
  "3.36"->{
    Cell[67724, 2350, 161, 4, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.36"}]},
  "3.37"->{
    Cell[68090, 2370, 588, 14, 70, "Text",
      CellTags->{"S2.12.3", "3.37"}]},
  "3.38"->{
    Cell[70064, 2428, 117, 2, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.38"}]},
  "3.39"->{
    Cell[70421, 2444, 156, 5, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.39"}]},
  "3.40"->{
    Cell[70689, 2455, 154, 4, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.40"}]},
  "3.41"->{
    Cell[71327, 2477, 86, 1, 70, "MathCaption",
      CellTags->{"S2.12.3", "3.41"}]},
  "3.42"->{
    Cell[73104, 2538, 549, 16, 70, "Text",
      CellTags->{"S2.12.3", "3.42"}]},
  "S2.12.4"->{
    Cell[73690, 2559, 85, 1, 70, "Subsection",
      CellTags->{"S2.12.4", "4.1"}],
    Cell[73778, 2562, 273, 6, 70, "Text",
      CellTags->{"S2.12.4", "4.2"}],
    Cell[74054, 2570, 484, 14, 70, "Text",
      CellTags->{"S2.12.4", "4.3"}],
    Cell[74541, 2586, 442, 10, 70, "Text",
      CellTags->{"S2.12.4", "4.4"}],
    Cell[74986, 2598, 856, 24, 70, "DefinitionBox",
      CellTags->"S2.12.4"],
    Cell[75845, 2624, 68, 1, 70, "Caption",
      CellTags->"S2.12.4"],
    Cell[75916, 2627, 130, 4, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.5"}],
    Cell[76071, 2635, 77, 2, 70, "Input",
      CellTags->"S2.12.4"],
    Cell[76151, 2639, 75, 2, 70, "Output",
      CellTags->"S2.12.4"],
    Cell[76241, 2644, 173, 5, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.6"}],
    Cell[76439, 2653, 91, 2, 70, "Input",
      CellTags->"S2.12.4"],
    Cell[76533, 2657, 84, 2, 70, "Output",
      CellTags->"S2.12.4"],
    Cell[76632, 2662, 104, 1, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.7"}],
    Cell[76761, 2667, 77, 2, 70, "Input",
      CellTags->"S2.12.4"],
    Cell[76841, 2671, 84, 2, 70, "Output",
      CellTags->"S2.12.4"],
    Cell[76940, 2676, 104, 1, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.8"}],
    Cell[77069, 2681, 82, 2, 70, "Input",
      CellTags->"S2.12.4"],
    Cell[77154, 2685, 75, 2, 70, "Output",
      CellTags->"S2.12.4"],
    Cell[77244, 2690, 493, 12, 70, "Text",
      CellTags->{"S2.12.4", "4.9"}],
    Cell[77740, 2704, 708, 20, 70, "Text",
      CellTags->{"S2.12.4", "4.10"}],
    Cell[78451, 2726, 1775, 52, 70, "DefinitionBox",
      CellTags->"S2.12.4"],
    Cell[80229, 2780, 63, 1, 70, "Caption",
      CellTags->"S2.12.4"],
    Cell[80295, 2783, 317, 7, 70, "Text",
      CellTags->{"S2.12.4", "4.11"}],
    Cell[80615, 2792, 998, 31, 70, "Text",
      CellTags->{"S2.12.4", "4.12"}],
    Cell[81616, 2825, 309, 8, 70, "Text",
      CellTags->{"S2.12.4", "4.13"}],
    Cell[81928, 2835, 588, 16, 70, "Text",
      CellTags->{"S2.12.4", "4.14"}],
    Cell[82519, 2853, 1782, 54, 70, "DefinitionBox",
      CellTags->"S2.12.4"],
    Cell[84304, 2909, 65, 1, 70, "Caption",
      CellTags->"S2.12.4"],
    Cell[84372, 2912, 479, 10, 70, "Text",
      CellTags->{"S2.12.4", "4.15"}],
    Cell[84854, 2924, 265, 9, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.16"}],
    Cell[85144, 2937, 70, 2, 70, "Input",
      CellTags->"S2.12.4"],
    Cell[85217, 2941, 111, 2, 70, "Output",
      CellTags->"S2.12.4"],
    Cell[85343, 2946, 4731, 137, 70, "DefinitionBox",
      CellTags->"S2.12.4"],
    Cell[90077, 3085, 92, 1, 70, "Caption",
      CellTags->"S2.12.4"],
    Cell[90172, 3088, 188, 6, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.17"}],
    Cell[90385, 3098, 83, 2, 70, "Input",
      CellTags->"S2.12.4"],
    Cell[90471, 3102, 105, 2, 70, "Output",
      CellTags->"S2.12.4"],
    Cell[90591, 3107, 250, 8, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.18"}],
    Cell[90866, 3119, 99, 2, 70, "Input",
      CellTags->"S2.12.4"],
    Cell[90968, 3123, 139, 6, 70, "Output",
      CellTags->"S2.12.4"],
    Cell[91122, 3132, 408, 8, 70, "Text",
      CellTags->{"S2.12.4", "4.19"}],
    Cell[91533, 3142, 2917, 88, 70, "DefinitionBox",
      CellTags->"S2.12.4"],
    Cell[94453, 3232, 67, 1, 70, "Caption",
      CellTags->"S2.12.4"],
    Cell[94523, 3235, 871, 27, 70, "Text",
      CellTags->{"S2.12.4", "4.20"}],
    Cell[95397, 3264, 107, 1, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.21"}],
    Cell[95529, 3269, 104, 2, 70, "Input",
      CellTags->"S2.12.4"],
    Cell[95636, 3273, 98, 3, 70, "Output",
      CellTags->"S2.12.4"],
    Cell[95749, 3279, 179, 5, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.22"}],
    Cell[95953, 3288, 89, 2, 70, "Input",
      CellTags->"S2.12.4"],
    Cell[96045, 3292, 103, 3, 70, "Output",
      CellTags->"S2.12.4"],
    Cell[96163, 3298, 498, 12, 70, "Text",
      CellTags->{"S2.12.4", "4.23"}],
    Cell[96664, 3312, 414, 14, 70, "DefinitionBox",
      CellTags->"S2.12.4"],
    Cell[97081, 3328, 157, 5, 70, "Caption",
      CellTags->"S2.12.4"]},
  "4.1"->{
    Cell[73690, 2559, 85, 1, 70, "Subsection",
      CellTags->{"S2.12.4", "4.1"}]},
  "4.2"->{
    Cell[73778, 2562, 273, 6, 70, "Text",
      CellTags->{"S2.12.4", "4.2"}]},
  "4.3"->{
    Cell[74054, 2570, 484, 14, 70, "Text",
      CellTags->{"S2.12.4", "4.3"}]},
  "4.4"->{
    Cell[74541, 2586, 442, 10, 70, "Text",
      CellTags->{"S2.12.4", "4.4"}]},
  "4.5"->{
    Cell[75916, 2627, 130, 4, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.5"}]},
  "4.6"->{
    Cell[76241, 2644, 173, 5, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.6"}]},
  "4.7"->{
    Cell[76632, 2662, 104, 1, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.7"}]},
  "4.8"->{
    Cell[76940, 2676, 104, 1, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.8"}]},
  "4.9"->{
    Cell[77244, 2690, 493, 12, 70, "Text",
      CellTags->{"S2.12.4", "4.9"}]},
  "4.10"->{
    Cell[77740, 2704, 708, 20, 70, "Text",
      CellTags->{"S2.12.4", "4.10"}]},
  "4.11"->{
    Cell[80295, 2783, 317, 7, 70, "Text",
      CellTags->{"S2.12.4", "4.11"}]},
  "4.12"->{
    Cell[80615, 2792, 998, 31, 70, "Text",
      CellTags->{"S2.12.4", "4.12"}]},
  "4.13"->{
    Cell[81616, 2825, 309, 8, 70, "Text",
      CellTags->{"S2.12.4", "4.13"}]},
  "4.14"->{
    Cell[81928, 2835, 588, 16, 70, "Text",
      CellTags->{"S2.12.4", "4.14"}]},
  "4.15"->{
    Cell[84372, 2912, 479, 10, 70, "Text",
      CellTags->{"S2.12.4", "4.15"}]},
  "4.16"->{
    Cell[84854, 2924, 265, 9, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.16"}]},
  "4.17"->{
    Cell[90172, 3088, 188, 6, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.17"}]},
  "4.18"->{
    Cell[90591, 3107, 250, 8, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.18"}]},
  "4.19"->{
    Cell[91122, 3132, 408, 8, 70, "Text",
      CellTags->{"S2.12.4", "4.19"}]},
  "4.20"->{
    Cell[94523, 3235, 871, 27, 70, "Text",
      CellTags->{"S2.12.4", "4.20"}]},
  "4.21"->{
    Cell[95397, 3264, 107, 1, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.21"}]},
  "4.22"->{
    Cell[95749, 3279, 179, 5, 70, "MathCaption",
      CellTags->{"S2.12.4", "4.22"}]},
  "4.23"->{
    Cell[96163, 3298, 498, 12, 70, "Text",
      CellTags->{"S2.12.4", "4.23"}]},
  "S2.12.5"->{
    Cell[97275, 3338, 79, 1, 70, "Subsection",
      CellTags->{"S2.12.5", "5.1"}],
    Cell[97357, 3341, 247, 6, 70, "Text",
      CellTags->{"S2.12.5", "5.2"}],
    Cell[97607, 3349, 458, 10, 70, "Text",
      CellTags->{"S2.12.5", "5.3"}],
    Cell[98068, 3361, 459, 13, 70, "DefinitionBox",
      CellTags->"S2.12.5"],
    Cell[98530, 3376, 75, 1, 70, "Caption",
      CellTags->"S2.12.5"],
    Cell[98608, 3379, 170, 5, 70, "MathCaption",
      CellTags->{"S2.12.5", "5.4"}],
    Cell[98781, 3386, 83, 2, 70, "Input",
      CellTags->"S2.12.5"],
    Cell[98867, 3390, 1647, 51, 70, "DefinitionBox",
      CellTags->"S2.12.5"],
    Cell[100517, 3443, 183, 7, 70, "Caption",
      CellTags->"S2.12.5"],
    Cell[100703, 3452, 621, 18, 70, "Text",
      CellTags->{"S2.12.5", "5.5"}],
    Cell[101327, 3472, 707, 21, 70, "Text",
      CellTags->{"S2.12.5", "5.6"}],
    Cell[102037, 3495, 229, 7, 70, "MathCaption",
      CellTags->{"S2.12.5", "5.7"}],
    Cell[102269, 3504, 76, 2, 70, "Input",
      CellTags->"S2.12.5"]},
  "5.1"->{
    Cell[97275, 3338, 79, 1, 70, "Subsection",
      CellTags->{"S2.12.5", "5.1"}]},
  "5.2"->{
    Cell[97357, 3341, 247, 6, 70, "Text",
      CellTags->{"S2.12.5", "5.2"}]},
  "5.3"->{
    Cell[97607, 3349, 458, 10, 70, "Text",
      CellTags->{"S2.12.5", "5.3"}]},
  "5.4"->{
    Cell[98608, 3379, 170, 5, 70, "MathCaption",
      CellTags->{"S2.12.5", "5.4"}]},
  "5.5"->{
    Cell[100703, 3452, 621, 18, 70, "Text",
      CellTags->{"S2.12.5", "5.5"}]},
  "5.6"->{
    Cell[101327, 3472, 707, 21, 70, "Text",
      CellTags->{"S2.12.5", "5.6"}]},
  "5.7"->{
    Cell[102037, 3495, 229, 7, 70, "MathCaption",
      CellTags->{"S2.12.5", "5.7"}]},
  "S2.12.6"->{
    Cell[102382, 3511, 95, 1, 70, "Subsection",
      CellTags->{"S2.12.6", "6.1"}],
    Cell[102480, 3514, 3877, 109, 70, "DefinitionBox",
      CellTags->"S2.12.6"],
    Cell[106360, 3625, 76, 1, 70, "Caption",
      CellTags->"S2.12.6"],
    Cell[106439, 3628, 300, 7, 70, "Text",
      CellTags->{"S2.12.6", "6.2"}],
    Cell[106742, 3637, 707, 30, 70, "Text",
      CellTags->{"S2.12.6", "6.3"}],
    Cell[107452, 3669, 2492, 70, 70, "DefinitionBox",
      CellTags->"S2.12.6"],
    Cell[109947, 3741, 82, 1, 70, "Caption",
      CellTags->"S2.12.6"]},
  "6.1"->{
    Cell[102382, 3511, 95, 1, 70, "Subsection",
      CellTags->{"S2.12.6", "6.1"}]},
  "6.2"->{
    Cell[106439, 3628, 300, 7, 70, "Text",
      CellTags->{"S2.12.6", "6.2"}]},
  "6.3"->{
    Cell[106742, 3637, 707, 30, 70, "Text",
      CellTags->{"S2.12.6", "6.3"}]},
  "S2.12.7"->{
    Cell[110066, 3747, 90, 1, 70, "Subsection",
      CellTags->{"S2.12.7", "7.1"}],
    Cell[110159, 3750, 2624, 85, 70, "DefinitionBox",
      CellTags->"S2.12.7"],
    Cell[112786, 3837, 92, 1, 70, "Caption",
      CellTags->"S2.12.7"],
    Cell[112881, 3840, 149, 5, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.2"}],
    Cell[113055, 3849, 113, 2, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[113171, 3853, 92, 3, 70, "Output",
      CellTags->"S2.12.7"],
    Cell[113278, 3859, 90, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.3"}],
    Cell[113393, 3864, 75, 2, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[113471, 3868, 385, 12, 70, "Output",
      CellTags->"S2.12.7"],
    Cell[113871, 3883, 148, 5, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.4"}],
    Cell[114044, 3892, 95, 2, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[114142, 3896, 119, 3, 70, "Output",
      CellTags->"S2.12.7"],
    Cell[114276, 3902, 571, 13, 70, "Text",
      CellTags->{"S2.12.7", "7.5"}],
    Cell[114850, 3917, 119, 4, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.6"}],
    Cell[114994, 3925, 140, 5, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[115137, 3932, 92, 3, 70, "Output",
      CellTags->"S2.12.7"],
    Cell[115244, 3938, 191, 5, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.7"}],
    Cell[115460, 3947, 75, 2, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[115538, 3951, 71, 4, 70, "Print",
      CellTags->"S2.12.7"],
    Cell[115624, 3958, 145, 5, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.8"}],
    Cell[115794, 3967, 96, 2, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[115893, 3971, 112, 3, 70, "Output",
      CellTags->"S2.12.7"],
    Cell[116020, 3977, 711, 20, 70, "Text",
      CellTags->{"S2.12.7", "7.9"}],
    Cell[116734, 3999, 110, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.10"}],
    Cell[116869, 4004, 124, 2, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[116996, 4008, 92, 3, 70, "Output",
      CellTags->"S2.12.7"],
    Cell[117103, 4014, 83, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.11"}],
    Cell[117211, 4019, 75, 2, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[117289, 4023, 100, 4, 70, "Print",
      CellTags->"S2.12.7"],
    Cell[117404, 4030, 145, 5, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.12"}],
    Cell[117574, 4039, 96, 2, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[117673, 4043, 154, 4, 70, "Output",
      CellTags->"S2.12.7"],
    Cell[117842, 4050, 152, 5, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.13"}],
    Cell[118019, 4059, 78, 2, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[118100, 4063, 155, 5, 70, "Output",
      CellTags->"S2.12.7"],
    Cell[118270, 4071, 2093, 59, 70, "DefinitionBox",
      CellTags->"S2.12.7"],
    Cell[120366, 4132, 80, 1, 70, "Caption",
      CellTags->"S2.12.7"],
    Cell[120449, 4135, 100, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.14"}],
    Cell[120574, 4140, 152, 5, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[120729, 4147, 93, 3, 70, "Output",
      CellTags->"S2.12.7"],
    Cell[120837, 4153, 91, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.15"}],
    Cell[120953, 4158, 76, 2, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[121032, 4162, 80, 4, 70, "Print",
      CellTags->"S2.12.7"],
    Cell[121127, 4169, 104, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.16"}],
    Cell[121256, 4174, 107, 2, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[121366, 4178, 116, 2, 70, "Output",
      CellTags->"S2.12.7"],
    Cell[121497, 4183, 106, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.17"}],
    Cell[121628, 4188, 108, 2, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[121739, 4192, 121, 2, 70, "Output",
      CellTags->"S2.12.7"],
    Cell[121875, 4197, 133, 4, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.18"}],
    Cell[122033, 4205, 108, 2, 70, "Input",
      CellTags->"S2.12.7"],
    Cell[122144, 4209, 145, 3, 70, "Output",
      CellTags->"S2.12.7"]},
  "7.1"->{
    Cell[110066, 3747, 90, 1, 70, "Subsection",
      CellTags->{"S2.12.7", "7.1"}]},
  "7.2"->{
    Cell[112881, 3840, 149, 5, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.2"}]},
  "7.3"->{
    Cell[113278, 3859, 90, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.3"}]},
  "7.4"->{
    Cell[113871, 3883, 148, 5, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.4"}]},
  "7.5"->{
    Cell[114276, 3902, 571, 13, 70, "Text",
      CellTags->{"S2.12.7", "7.5"}]},
  "7.6"->{
    Cell[114850, 3917, 119, 4, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.6"}]},
  "7.7"->{
    Cell[115244, 3938, 191, 5, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.7"}]},
  "7.8"->{
    Cell[115624, 3958, 145, 5, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.8"}]},
  "7.9"->{
    Cell[116020, 3977, 711, 20, 70, "Text",
      CellTags->{"S2.12.7", "7.9"}]},
  "7.10"->{
    Cell[116734, 3999, 110, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.10"}]},
  "7.11"->{
    Cell[117103, 4014, 83, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.11"}]},
  "7.12"->{
    Cell[117404, 4030, 145, 5, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.12"}]},
  "7.13"->{
    Cell[117842, 4050, 152, 5, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.13"}]},
  "7.14"->{
    Cell[120449, 4135, 100, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.14"}]},
  "7.15"->{
    Cell[120837, 4153, 91, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.15"}]},
  "7.16"->{
    Cell[121127, 4169, 104, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.16"}]},
  "7.17"->{
    Cell[121497, 4183, 106, 1, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.17"}]},
  "7.18"->{
    Cell[121875, 4197, 133, 4, 70, "MathCaption",
      CellTags->{"S2.12.7", "7.18"}]},
  "S2.12.8"->{
    Cell[122338, 4218, 81, 1, 70, "Subsection",
      CellTags->{"S2.12.8", "8.1"}],
    Cell[122422, 4221, 704, 18, 70, "Text",
      CellTags->{"S2.12.8", "8.2"}],
    Cell[123129, 4241, 625, 18, 70, "DefinitionBox",
      CellTags->"S2.12.8"],
    Cell[123757, 4261, 71, 1, 70, "Caption",
      CellTags->"S2.12.8"],
    Cell[123831, 4264, 82, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.3"}],
    Cell[123938, 4269, 74, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[124015, 4273, 87, 4, 70, "Print",
      CellTags->"S2.12.8"],
    Cell[124117, 4280, 133, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.4"}],
    Cell[124275, 4288, 94, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[124372, 4292, 124, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[124511, 4298, 1673, 54, 70, "DefinitionBox",
      CellTags->"S2.12.8"],
    Cell[126187, 4354, 69, 1, 70, "Caption",
      CellTags->"S2.12.8"],
    Cell[126259, 4357, 143, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.5"}],
    Cell[126427, 4365, 104, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[126534, 4369, 130, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[126679, 4375, 110, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.6"}],
    Cell[126814, 4380, 115, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[126932, 4384, 128, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[127075, 4390, 541, 16, 70, "Text",
      CellTags->{"S2.12.8", "8.7"}],
    Cell[127619, 4408, 218, 6, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.8"}],
    Cell[127862, 4418, 73, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[127938, 4422, 81, 4, 70, "Print",
      CellTags->"S2.12.8"],
    Cell[128034, 4429, 135, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.9"}],
    Cell[128194, 4437, 93, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[128290, 4441, 120, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[128425, 4447, 1027, 31, 70, "DefinitionBox",
      CellTags->"S2.12.8"],
    Cell[129455, 4480, 76, 1, 70, "Caption",
      CellTags->"S2.12.8"],
    Cell[129534, 4483, 259, 7, 70, "Text",
      CellTags->{"S2.12.8", "8.10"}],
    Cell[129796, 4492, 88, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.11"}],
    Cell[129909, 4497, 74, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[129986, 4501, 77, 4, 70, "Print",
      CellTags->"S2.12.8"],
    Cell[130078, 4508, 164, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.12"}],
    Cell[130267, 4516, 97, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[130367, 4520, 248, 5, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[130630, 4528, 141, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.13"}],
    Cell[130796, 4536, 92, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[130891, 4540, 235, 5, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[131141, 4548, 134, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.14"}],
    Cell[131300, 4556, 114, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[131417, 4560, 236, 5, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[131668, 4568, 2005, 66, 70, "DefinitionBox",
      CellTags->"S2.12.8"],
    Cell[133676, 4636, 67, 1, 70, "Caption",
      CellTags->"S2.12.8"],
    Cell[133746, 4639, 203, 6, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.15"}],
    Cell[133974, 4649, 93, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[134070, 4653, 130, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[134215, 4659, 766, 15, 70, "Text",
      CellTags->{"S2.12.8", "8.16"}],
    Cell[134984, 4676, 2088, 68, 70, "DefinitionBox3Col",
      CellTags->"S2.12.8"],
    Cell[137075, 4746, 108, 5, 70, "Caption",
      CellTags->"S2.12.8"],
    Cell[137186, 4753, 265, 9, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.17"}],
    Cell[137476, 4766, 127, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[137606, 4770, 136, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[137757, 4776, 603, 12, 70, "Text",
      CellTags->{"S2.12.8", "8.18"}],
    Cell[138363, 4790, 130, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.19"}],
    Cell[138518, 4798, 108, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[138629, 4802, 118, 2, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[138762, 4807, 176, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.20"}],
    Cell[138963, 4815, 77, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[139043, 4819, 90, 4, 70, "Print",
      CellTags->"S2.12.8"],
    Cell[139148, 4826, 118, 2, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.21"}],
    Cell[139291, 4832, 145, 5, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[139439, 4839, 133, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[139587, 4845, 172, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.22"}],
    Cell[139784, 4853, 164, 5, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[139951, 4860, 165, 4, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[140131, 4867, 2497, 72, 70, "DefinitionBox",
      CellTags->"S2.12.8"],
    Cell[142631, 4941, 128, 5, 70, "Caption",
      CellTags->"S2.12.8"],
    Cell[142762, 4948, 93, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.23"}],
    Cell[142880, 4953, 74, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[142957, 4957, 91, 4, 70, "Print",
      CellTags->"S2.12.8"],
    Cell[143063, 4964, 179, 5, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.24"}],
    Cell[143267, 4973, 142, 5, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[143412, 4980, 132, 2, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[143559, 4985, 210, 7, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.25"}],
    Cell[143794, 4996, 148, 5, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[143945, 5003, 111, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[144071, 5009, 144, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.26"}],
    Cell[144240, 5017, 173, 5, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[144416, 5024, 103, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[144534, 5030, 713, 21, 70, "Text",
      CellTags->{"S2.12.8", "8.27"}],
    Cell[145250, 5053, 166, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.28"}],
    Cell[145441, 5061, 73, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[145517, 5065, 70, 1, 70, "Print",
      CellTags->"S2.12.8"],
    Cell[145602, 5069, 117, 2, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.29"}],
    Cell[145744, 5075, 118, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[145865, 5079, 123, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[146003, 5085, 127, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.30"}],
    Cell[146155, 5093, 147, 5, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[146305, 5100, 172, 4, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[146492, 5107, 454, 9, 70, "Text",
      CellTags->{"S2.12.8", "8.31"}],
    Cell[146949, 5118, 75, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.32"}],
    Cell[147049, 5123, 76, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[147128, 5127, 58, 1, 70, "Print",
      CellTags->"S2.12.8"],
    Cell[147201, 5131, 149, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.33"}],
    Cell[147375, 5139, 124, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[147502, 5143, 168, 4, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[147685, 5150, 299, 8, 70, "Text",
      CellTags->{"S2.12.8", "8.34"}],
    Cell[147987, 5160, 170, 5, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.35"}],
    Cell[148182, 5169, 73, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[148258, 5173, 61, 5, 70, "Print",
      CellTags->"S2.12.8"],
    Cell[148334, 5181, 185, 7, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.36"}],
    Cell[148544, 5192, 97, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[148644, 5196, 99, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[148758, 5202, 108, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.37"}],
    Cell[148891, 5207, 103, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[148997, 5211, 112, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[149124, 5217, 874, 29, 70, "Text",
      CellTags->{"S2.12.8", "8.38"}],
    Cell[150001, 5248, 333, 8, 70, "Text",
      CellTags->{"S2.12.8", "8.39"}],
    Cell[150337, 5258, 83, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.40"}],
    Cell[150445, 5263, 75, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[150523, 5267, 87, 4, 70, "Print",
      CellTags->"S2.12.8"],
    Cell[150625, 5274, 207, 6, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.41"}],
    Cell[150857, 5284, 121, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[150981, 5288, 160, 4, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[151156, 5295, 838, 24, 70, "DefinitionBox",
      CellTags->"S2.12.8"],
    Cell[151997, 5321, 77, 1, 70, "Caption",
      CellTags->"S2.12.8"],
    Cell[152077, 5324, 171, 5, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.42"}],
    Cell[152273, 5333, 93, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[152369, 5337, 115, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[152499, 5343, 2080, 63, 70, "DefinitionBox",
      CellTags->"S2.12.8"],
    Cell[154582, 5408, 84, 1, 70, "Caption",
      CellTags->"S2.12.8"],
    Cell[154669, 5411, 324, 8, 70, "Text",
      CellTags->{"S2.12.8", "8.43"}],
    Cell[154996, 5421, 792, 19, 70, "Text",
      CellTags->{"S2.12.8", "8.44"}],
    Cell[155791, 5442, 83, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.45"}],
    Cell[155899, 5447, 75, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[155977, 5451, 87, 4, 70, "Print",
      CellTags->"S2.12.8"],
    Cell[156079, 5458, 98, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.46"}],
    Cell[156202, 5463, 94, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[156299, 5467, 109, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[156423, 5473, 99, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.47"}],
    Cell[156547, 5478, 84, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[156634, 5482, 88, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[156737, 5488, 95, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.48"}],
    Cell[156857, 5493, 94, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[156954, 5497, 97, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[157066, 5503, 84, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.49"}],
    Cell[157153, 5506, 84, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[157240, 5510, 94, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.50"}],
    Cell[157359, 5515, 88, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[157450, 5519, 97, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[157562, 5525, 86, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.51"}],
    Cell[157673, 5530, 77, 2, 70, "Input",
      CellTags->"S2.12.8"],
    Cell[157753, 5534, 92, 3, 70, "Output",
      CellTags->"S2.12.8"],
    Cell[157860, 5540, 310, 13, 70, "Text",
      CellTags->{"S2.12.8", "8.52"}],
    Cell[158173, 5555, 207, 7, 70, "Text",
      CellTags->{"S2.12.8", "8.53"}]},
  "8.1"->{
    Cell[122338, 4218, 81, 1, 70, "Subsection",
      CellTags->{"S2.12.8", "8.1"}]},
  "8.2"->{
    Cell[122422, 4221, 704, 18, 70, "Text",
      CellTags->{"S2.12.8", "8.2"}]},
  "8.3"->{
    Cell[123831, 4264, 82, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.3"}]},
  "8.4"->{
    Cell[124117, 4280, 133, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.4"}]},
  "8.5"->{
    Cell[126259, 4357, 143, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.5"}]},
  "8.6"->{
    Cell[126679, 4375, 110, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.6"}]},
  "8.7"->{
    Cell[127075, 4390, 541, 16, 70, "Text",
      CellTags->{"S2.12.8", "8.7"}]},
  "8.8"->{
    Cell[127619, 4408, 218, 6, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.8"}]},
  "8.9"->{
    Cell[128034, 4429, 135, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.9"}]},
  "8.10"->{
    Cell[129534, 4483, 259, 7, 70, "Text",
      CellTags->{"S2.12.8", "8.10"}]},
  "8.11"->{
    Cell[129796, 4492, 88, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.11"}]},
  "8.12"->{
    Cell[130078, 4508, 164, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.12"}]},
  "8.13"->{
    Cell[130630, 4528, 141, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.13"}]},
  "8.14"->{
    Cell[131141, 4548, 134, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.14"}]},
  "8.15"->{
    Cell[133746, 4639, 203, 6, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.15"}]},
  "8.16"->{
    Cell[134215, 4659, 766, 15, 70, "Text",
      CellTags->{"S2.12.8", "8.16"}]},
  "8.17"->{
    Cell[137186, 4753, 265, 9, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.17"}]},
  "8.18"->{
    Cell[137757, 4776, 603, 12, 70, "Text",
      CellTags->{"S2.12.8", "8.18"}]},
  "8.19"->{
    Cell[138363, 4790, 130, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.19"}]},
  "8.20"->{
    Cell[138762, 4807, 176, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.20"}]},
  "8.21"->{
    Cell[139148, 4826, 118, 2, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.21"}]},
  "8.22"->{
    Cell[139587, 4845, 172, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.22"}]},
  "8.23"->{
    Cell[142762, 4948, 93, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.23"}]},
  "8.24"->{
    Cell[143063, 4964, 179, 5, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.24"}]},
  "8.25"->{
    Cell[143559, 4985, 210, 7, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.25"}]},
  "8.26"->{
    Cell[144071, 5009, 144, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.26"}]},
  "8.27"->{
    Cell[144534, 5030, 713, 21, 70, "Text",
      CellTags->{"S2.12.8", "8.27"}]},
  "8.28"->{
    Cell[145250, 5053, 166, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.28"}]},
  "8.29"->{
    Cell[145602, 5069, 117, 2, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.29"}]},
  "8.30"->{
    Cell[146003, 5085, 127, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.30"}]},
  "8.31"->{
    Cell[146492, 5107, 454, 9, 70, "Text",
      CellTags->{"S2.12.8", "8.31"}]},
  "8.32"->{
    Cell[146949, 5118, 75, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.32"}]},
  "8.33"->{
    Cell[147201, 5131, 149, 4, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.33"}]},
  "8.34"->{
    Cell[147685, 5150, 299, 8, 70, "Text",
      CellTags->{"S2.12.8", "8.34"}]},
  "8.35"->{
    Cell[147987, 5160, 170, 5, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.35"}]},
  "8.36"->{
    Cell[148334, 5181, 185, 7, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.36"}]},
  "8.37"->{
    Cell[148758, 5202, 108, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.37"}]},
  "8.38"->{
    Cell[149124, 5217, 874, 29, 70, "Text",
      CellTags->{"S2.12.8", "8.38"}]},
  "8.39"->{
    Cell[150001, 5248, 333, 8, 70, "Text",
      CellTags->{"S2.12.8", "8.39"}]},
  "8.40"->{
    Cell[150337, 5258, 83, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.40"}]},
  "8.41"->{
    Cell[150625, 5274, 207, 6, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.41"}]},
  "8.42"->{
    Cell[152077, 5324, 171, 5, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.42"}]},
  "8.43"->{
    Cell[154669, 5411, 324, 8, 70, "Text",
      CellTags->{"S2.12.8", "8.43"}]},
  "8.44"->{
    Cell[154996, 5421, 792, 19, 70, "Text",
      CellTags->{"S2.12.8", "8.44"}]},
  "8.45"->{
    Cell[155791, 5442, 83, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.45"}]},
  "8.46"->{
    Cell[156079, 5458, 98, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.46"}]},
  "8.47"->{
    Cell[156423, 5473, 99, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.47"}]},
  "8.48"->{
    Cell[156737, 5488, 95, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.48"}]},
  "8.49"->{
    Cell[157066, 5503, 84, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.49"}]},
  "8.50"->{
    Cell[157240, 5510, 94, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.50"}]},
  "8.51"->{
    Cell[157562, 5525, 86, 1, 70, "MathCaption",
      CellTags->{"S2.12.8", "8.51"}]},
  "8.52"->{
    Cell[157860, 5540, 310, 13, 70, "Text",
      CellTags->{"S2.12.8", "8.52"}]},
  "8.53"->{
    Cell[158173, 5555, 207, 7, 70, "Text",
      CellTags->{"S2.12.8", "8.53"}]},
  "S2.12.9"->{
    Cell[158417, 5567, 76, 1, 70, "Subsection",
      CellTags->{"S2.12.9", "9.1"}],
    Cell[158496, 5570, 2434, 73, 70, "DefinitionBox",
      CellTags->"S2.12.9"],
    Cell[160933, 5645, 85, 1, 70, "Caption",
      CellTags->"S2.12.9"],
    Cell[161021, 5648, 92, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.2"}],
    Cell[161138, 5653, 75, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[161216, 5657, 127, 5, 70, "Print",
      CellTags->"S2.12.9"],
    Cell[161358, 5665, 172, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.3"}],
    Cell[161555, 5674, 95, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[161653, 5678, 159, 4, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[161827, 5685, 144, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.4"}],
    Cell[161996, 5694, 99, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[162098, 5698, 84, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[162197, 5704, 899, 22, 70, "Text",
      CellTags->{"S2.12.9", "9.5"}],
    Cell[163099, 5728, 213, 6, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.6"}],
    Cell[163337, 5738, 125, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[163465, 5742, 121, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[163601, 5748, 1947, 64, 70, "DefinitionBox3Col",
      CellTags->"S2.12.9"],
    Cell[165551, 5814, 108, 5, 70, "Caption",
      CellTags->"S2.12.9"],
    Cell[165662, 5821, 187, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.7"}],
    Cell[165874, 5830, 121, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[165998, 5834, 117, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[166130, 5840, 561, 18, 70, "Text",
      CellTags->{"S2.12.9", "9.8"}],
    Cell[166694, 5860, 216, 7, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.9"}],
    Cell[166935, 5871, 115, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[167053, 5875, 84, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[167152, 5881, 1463, 42, 70, "DefinitionBox",
      CellTags->"S2.12.9"],
    Cell[168618, 5925, 71, 1, 70, "Caption",
      CellTags->"S2.12.9"],
    Cell[168692, 5928, 179, 7, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.10"}],
    Cell[168896, 5939, 114, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[169013, 5943, 159, 4, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[169187, 5950, 217, 7, 70, "Text",
      CellTags->{"S2.12.9", "9.11"}],
    Cell[169407, 5959, 570, 17, 70, "DefinitionBox",
      CellTags->"S2.12.9"],
    Cell[169980, 5978, 95, 1, 70, "Caption",
      CellTags->"S2.12.9"],
    Cell[170078, 5981, 142, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.12"}],
    Cell[170245, 5990, 70, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[170318, 5994, 86, 2, 70, "Print",
      CellTags->"S2.12.9"],
    Cell[170407, 5998, 83, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[170505, 6004, 128, 4, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.13"}],
    Cell[170658, 6012, 120, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[170781, 6016, 94, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[170890, 6022, 1257, 37, 70, "DefinitionBox",
      CellTags->"S2.12.9"],
    Cell[172150, 6061, 82, 1, 70, "Caption",
      CellTags->"S2.12.9"],
    Cell[172235, 6064, 363, 9, 70, "Text",
      CellTags->{"S2.12.9", "9.14"}],
    Cell[172601, 6075, 511, 13, 70, "Text",
      CellTags->{"S2.12.9", "9.15"}],
    Cell[173115, 6090, 141, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.16"}],
    Cell[173281, 6099, 96, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[173380, 6103, 110, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[173505, 6109, 142, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.17"}],
    Cell[173672, 6118, 86, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[173761, 6122, 100, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[173876, 6128, 187, 7, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.18"}],
    Cell[174088, 6139, 86, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[174177, 6143, 116, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[174308, 6149, 86, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.19"}],
    Cell[174419, 6154, 78, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[174500, 6158, 93, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[174608, 6164, 411, 15, 70, "Text",
      CellTags->{"S2.12.9", "9.20"}],
    Cell[175022, 6181, 85, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.21"}],
    Cell[175132, 6186, 96, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[175231, 6190, 110, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[175356, 6196, 227, 6, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.22"}],
    Cell[175608, 6206, 89, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[175700, 6210, 100, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[175815, 6216, 165, 4, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.23"}],
    Cell[176005, 6224, 83, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[176091, 6228, 88, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[176194, 6234, 94, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.24"}],
    Cell[176291, 6237, 86, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[176380, 6241, 206, 6, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.25"}],
    Cell[176611, 6251, 85, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[176699, 6255, 116, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[176830, 6261, 86, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.26"}],
    Cell[176941, 6266, 78, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[177022, 6270, 93, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[177130, 6276, 1425, 39, 70, "DefinitionBox",
      CellTags->"S2.12.9"],
    Cell[178558, 6317, 93, 1, 70, "Caption",
      CellTags->"S2.12.9"],
    Cell[178654, 6320, 332, 10, 70, "Text",
      CellTags->{"S2.12.9", "9.27"}],
    Cell[178989, 6332, 352, 7, 70, "Text",
      CellTags->{"S2.12.9", "9.28"}],
    Cell[179344, 6341, 79, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.29"}],
    Cell[179448, 6346, 96, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[179547, 6350, 110, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[179672, 6356, 229, 8, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.30"}],
    Cell[179926, 6368, 87, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[180016, 6372, 84, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[180115, 6378, 95, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.31"}],
    Cell[180235, 6383, 85, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[180323, 6387, 116, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[180454, 6393, 92, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.32"}],
    Cell[180571, 6398, 87, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[180661, 6402, 85, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[180761, 6408, 92, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.33"}],
    Cell[180878, 6413, 93, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[180974, 6417, 84, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[181073, 6423, 150, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.34"}],
    Cell[181248, 6432, 85, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[181336, 6436, 111, 3, 70, "Output",
      CellTags->"S2.12.9"],
    Cell[181462, 6442, 80, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.35"}],
    Cell[181567, 6447, 78, 2, 70, "Input",
      CellTags->"S2.12.9"],
    Cell[181648, 6451, 93, 3, 70, "Output",
      CellTags->"S2.12.9"]},
  "9.1"->{
    Cell[158417, 5567, 76, 1, 70, "Subsection",
      CellTags->{"S2.12.9", "9.1"}]},
  "9.2"->{
    Cell[161021, 5648, 92, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.2"}]},
  "9.3"->{
    Cell[161358, 5665, 172, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.3"}]},
  "9.4"->{
    Cell[161827, 5685, 144, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.4"}]},
  "9.5"->{
    Cell[162197, 5704, 899, 22, 70, "Text",
      CellTags->{"S2.12.9", "9.5"}]},
  "9.6"->{
    Cell[163099, 5728, 213, 6, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.6"}]},
  "9.7"->{
    Cell[165662, 5821, 187, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.7"}]},
  "9.8"->{
    Cell[166130, 5840, 561, 18, 70, "Text",
      CellTags->{"S2.12.9", "9.8"}]},
  "9.9"->{
    Cell[166694, 5860, 216, 7, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.9"}]},
  "9.10"->{
    Cell[168692, 5928, 179, 7, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.10"}]},
  "9.11"->{
    Cell[169187, 5950, 217, 7, 70, "Text",
      CellTags->{"S2.12.9", "9.11"}]},
  "9.12"->{
    Cell[170078, 5981, 142, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.12"}]},
  "9.13"->{
    Cell[170505, 6004, 128, 4, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.13"}]},
  "9.14"->{
    Cell[172235, 6064, 363, 9, 70, "Text",
      CellTags->{"S2.12.9", "9.14"}]},
  "9.15"->{
    Cell[172601, 6075, 511, 13, 70, "Text",
      CellTags->{"S2.12.9", "9.15"}]},
  "9.16"->{
    Cell[173115, 6090, 141, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.16"}]},
  "9.17"->{
    Cell[173505, 6109, 142, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.17"}]},
  "9.18"->{
    Cell[173876, 6128, 187, 7, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.18"}]},
  "9.19"->{
    Cell[174308, 6149, 86, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.19"}]},
  "9.20"->{
    Cell[174608, 6164, 411, 15, 70, "Text",
      CellTags->{"S2.12.9", "9.20"}]},
  "9.21"->{
    Cell[175022, 6181, 85, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.21"}]},
  "9.22"->{
    Cell[175356, 6196, 227, 6, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.22"}]},
  "9.23"->{
    Cell[175815, 6216, 165, 4, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.23"}]},
  "9.24"->{
    Cell[176194, 6234, 94, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.24"}]},
  "9.25"->{
    Cell[176380, 6241, 206, 6, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.25"}]},
  "9.26"->{
    Cell[176830, 6261, 86, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.26"}]},
  "9.27"->{
    Cell[178654, 6320, 332, 10, 70, "Text",
      CellTags->{"S2.12.9", "9.27"}]},
  "9.28"->{
    Cell[178989, 6332, 352, 7, 70, "Text",
      CellTags->{"S2.12.9", "9.28"}]},
  "9.29"->{
    Cell[179344, 6341, 79, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.29"}]},
  "9.30"->{
    Cell[179672, 6356, 229, 8, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.30"}]},
  "9.31"->{
    Cell[180115, 6378, 95, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.31"}]},
  "9.32"->{
    Cell[180454, 6393, 92, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.32"}]},
  "9.33"->{
    Cell[180761, 6408, 92, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.33"}]},
  "9.34"->{
    Cell[181073, 6423, 150, 5, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.34"}]},
  "9.35"->{
    Cell[181462, 6442, 80, 1, 70, "MathCaption",
      CellTags->{"S2.12.9", "9.35"}]},
  "S2.12.10"->{
    Cell[181790, 6460, 93, 1, 70, "Subsection",
      CellTags->{"S2.12.10", "10.1"}],
    Cell[181886, 6463, 599, 16, 70, "Text",
      CellTags->{"S2.12.10", "10.2"}],
    Cell[182488, 6481, 664, 18, 70, "DefinitionBox",
      CellTags->"S2.12.10"],
    Cell[183155, 6501, 78, 1, 70, "Caption",
      CellTags->"S2.12.10"],
    Cell[183236, 6504, 113, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.3"}],
    Cell[183374, 6509, 110, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[183487, 6513, 106, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[183608, 6519, 157, 4, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.4"}],
    Cell[183790, 6527, 81, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[183874, 6531, 86, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[183975, 6537, 105, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.5"}],
    Cell[184105, 6542, 85, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[184193, 6546, 109, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[184317, 6552, 87, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.6"}],
    Cell[184429, 6557, 76, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[184508, 6561, 89, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[184612, 6567, 682, 19, 70, "Text",
      CellTags->{"S2.12.10", "10.7"}],
    Cell[185297, 6588, 107, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.8"}],
    Cell[185429, 6593, 103, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[185535, 6597, 106, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[185656, 6603, 143, 4, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.9"}],
    Cell[185824, 6611, 85, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[185912, 6615, 84, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[186011, 6621, 95, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.10"}],
    Cell[186131, 6626, 83, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[186217, 6630, 86, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[186318, 6636, 138, 4, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.11"}],
    Cell[186481, 6644, 85, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[186569, 6648, 84, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[186668, 6654, 146, 4, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.12"}],
    Cell[186839, 6662, 91, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[186933, 6666, 84, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[187032, 6672, 200, 7, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.13"}],
    Cell[187257, 6683, 84, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[187344, 6687, 86, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[187445, 6693, 117, 2, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.14"}],
    Cell[187587, 6699, 99, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[187689, 6703, 86, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[187790, 6709, 173, 5, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.15"}],
    Cell[187988, 6718, 84, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[188075, 6722, 93, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[188183, 6728, 82, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.16"}],
    Cell[188290, 6733, 77, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[188370, 6737, 90, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[188475, 6743, 551, 13, 70, "Text",
      CellTags->{"S2.12.10", "10.17"}],
    Cell[189029, 6758, 158, 5, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.18"}],
    Cell[189212, 6767, 144, 5, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[189359, 6774, 171, 4, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[189545, 6781, 101, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.19"}],
    Cell[189671, 6786, 90, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[189764, 6790, 107, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[189886, 6796, 162, 5, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.20"}],
    Cell[190073, 6805, 88, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[190164, 6809, 161, 4, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[190340, 6816, 138, 4, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.21"}],
    Cell[190503, 6824, 92, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[190598, 6828, 85, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[190698, 6834, 200, 5, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.22"}],
    Cell[190923, 6843, 114, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[191040, 6847, 89, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[191144, 6853, 208, 6, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.23"}],
    Cell[191377, 6863, 82, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[191462, 6867, 91, 3, 70, "Output",
      CellTags->"S2.12.10"],
    Cell[191568, 6873, 88, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.24"}],
    Cell[191681, 6878, 77, 2, 70, "Input",
      CellTags->"S2.12.10"],
    Cell[191761, 6882, 90, 3, 70, "Output",
      CellTags->"S2.12.10"]},
  "10.1"->{
    Cell[181790, 6460, 93, 1, 70, "Subsection",
      CellTags->{"S2.12.10", "10.1"}]},
  "10.2"->{
    Cell[181886, 6463, 599, 16, 70, "Text",
      CellTags->{"S2.12.10", "10.2"}]},
  "10.3"->{
    Cell[183236, 6504, 113, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.3"}]},
  "10.4"->{
    Cell[183608, 6519, 157, 4, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.4"}]},
  "10.5"->{
    Cell[183975, 6537, 105, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.5"}]},
  "10.6"->{
    Cell[184317, 6552, 87, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.6"}]},
  "10.7"->{
    Cell[184612, 6567, 682, 19, 70, "Text",
      CellTags->{"S2.12.10", "10.7"}]},
  "10.8"->{
    Cell[185297, 6588, 107, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.8"}]},
  "10.9"->{
    Cell[185656, 6603, 143, 4, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.9"}]},
  "10.10"->{
    Cell[186011, 6621, 95, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.10"}]},
  "10.11"->{
    Cell[186318, 6636, 138, 4, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.11"}]},
  "10.12"->{
    Cell[186668, 6654, 146, 4, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.12"}]},
  "10.13"->{
    Cell[187032, 6672, 200, 7, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.13"}]},
  "10.14"->{
    Cell[187445, 6693, 117, 2, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.14"}]},
  "10.15"->{
    Cell[187790, 6709, 173, 5, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.15"}]},
  "10.16"->{
    Cell[188183, 6728, 82, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.16"}]},
  "10.17"->{
    Cell[188475, 6743, 551, 13, 70, "Text",
      CellTags->{"S2.12.10", "10.17"}]},
  "10.18"->{
    Cell[189029, 6758, 158, 5, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.18"}]},
  "10.19"->{
    Cell[189545, 6781, 101, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.19"}]},
  "10.20"->{
    Cell[189886, 6796, 162, 5, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.20"}]},
  "10.21"->{
    Cell[190340, 6816, 138, 4, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.21"}]},
  "10.22"->{
    Cell[190698, 6834, 200, 5, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.22"}]},
  "10.23"->{
    Cell[191144, 6853, 208, 6, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.23"}]},
  "10.24"->{
    Cell[191568, 6873, 88, 1, 70, "MathCaption",
      CellTags->{"S2.12.10", "10.24"}]},
  "S2.12.11"->{
    Cell[191900, 6891, 92, 1, 70, "Subsection",
      CellTags->{"S2.12.11", "11.1"}],
    Cell[191995, 6894, 435, 13, 70, "Text",
      CellTags->{"S2.12.11", "11.2"}],
    Cell[192433, 6909, 5914, 169, 70, "DefinitionBox",
      CellTags->"S2.12.11"],
    Cell[198350, 7080, 76, 1, 70, "Caption",
      CellTags->"S2.12.11"],
    Cell[198429, 7083, 3461, 105, 70, "DefinitionBox",
      CellTags->"S2.12.11"],
    Cell[201893, 7190, 162, 7, 70, "Caption",
      CellTags->"S2.12.11"],
    Cell[202058, 7199, 100, 1, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.3"}],
    Cell[202183, 7204, 106, 2, 70, "Input",
      CellTags->"S2.12.11"],
    Cell[202292, 7208, 88, 3, 70, "Output",
      CellTags->"S2.12.11"],
    Cell[202395, 7214, 166, 4, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.4"}],
    Cell[202564, 7220, 81, 2, 70, "Input",
      CellTags->"S2.12.11"],
    Cell[202648, 7224, 136, 4, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.5"}],
    Cell[202809, 7232, 85, 2, 70, "Input",
      CellTags->"S2.12.11"],
    Cell[202897, 7236, 85, 3, 70, "Output",
      CellTags->"S2.12.11"],
    Cell[202997, 7242, 112, 1, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.6"}],
    Cell[203134, 7247, 101, 2, 70, "Input",
      CellTags->"S2.12.11"],
    Cell[203238, 7251, 86, 3, 70, "Output",
      CellTags->"S2.12.11"],
    Cell[203339, 7257, 124, 4, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.7"}],
    Cell[203488, 7265, 100, 2, 70, "Input",
      CellTags->"S2.12.11"],
    Cell[203591, 7269, 92, 3, 70, "Output",
      CellTags->"S2.12.11"],
    Cell[203698, 7275, 754, 23, 70, "Text",
      CellTags->{"S2.12.11", "11.8"}],
    Cell[204455, 7300, 542, 14, 70, "Text",
      CellTags->{"S2.12.11", "11.9"}],
    Cell[205000, 7316, 113, 3, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.10"}],
    Cell[205138, 7323, 109, 2, 70, "Input",
      CellTags->"S2.12.11"],
    Cell[205250, 7327, 89, 3, 70, "Output",
      CellTags->"S2.12.11"],
    Cell[205354, 7333, 80, 1, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.11"}],
    Cell[205437, 7336, 82, 2, 70, "Input",
      CellTags->"S2.12.11"],
    Cell[205522, 7340, 137, 4, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.12"}],
    Cell[205684, 7348, 143, 5, 45, "Input",
      CellTags->"S2.12.11"],
    Cell[205830, 7355, 93, 3, 70, "Output",
      CellTags->"S2.12.11"],
    Cell[205938, 7361, 2199, 63, 162, "DefinitionBox",
      CellTags->"S2.12.11"],
    Cell[208140, 7426, 74, 1, 16, "Caption",
      CellTags->"S2.12.11"],
    Cell[208217, 7429, 113, 3, 40, "MathCaption",
      CellTags->{"S2.12.11", "11.13"}],
    Cell[208355, 7436, 109, 2, 28, "Input",
      CellTags->"S2.12.11"],
    Cell[208467, 7440, 89, 3, 25, "Output",
      CellTags->"S2.12.11"],
    Cell[208571, 7446, 99, 1, 40, "MathCaption",
      CellTags->{"S2.12.11", "11.14"}],
    Cell[208695, 7451, 101, 2, 28, "Input",
      CellTags->"S2.12.11"],
    Cell[208799, 7455, 152, 4, 25, "Output",
      CellTags->"S2.12.11"],
    Cell[208966, 7462, 140, 4, 40, "MathCaption",
      CellTags->{"S2.12.11", "11.15"}],
    Cell[209131, 7470, 103, 2, 28, "Input",
      CellTags->"S2.12.11"],
    Cell[209237, 7474, 168, 4, 27, "Output",
      CellTags->"S2.12.11"],
    Cell[209420, 7481, 143, 4, 40, "MathCaption",
      CellTags->{"S2.12.11", "11.16"}],
    Cell[209588, 7489, 115, 2, 28, "Input",
      CellTags->"S2.12.11"],
    Cell[209706, 7493, 187, 4, 43, "Output",
      CellTags->"S2.12.11"],
    Cell[209908, 7500, 414, 12, 56, "Text",
      CellTags->{"S2.12.11", "11.17"}],
    Cell[210325, 7514, 534, 18, 72, "Text",
      CellTags->{"S2.12.11", "11.18"}]},
  "11.1"->{
    Cell[191900, 6891, 92, 1, 70, "Subsection",
      CellTags->{"S2.12.11", "11.1"}]},
  "11.2"->{
    Cell[191995, 6894, 435, 13, 70, "Text",
      CellTags->{"S2.12.11", "11.2"}]},
  "11.3"->{
    Cell[202058, 7199, 100, 1, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.3"}]},
  "11.4"->{
    Cell[202395, 7214, 166, 4, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.4"}]},
  "11.5"->{
    Cell[202648, 7224, 136, 4, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.5"}]},
  "11.6"->{
    Cell[202997, 7242, 112, 1, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.6"}]},
  "11.7"->{
    Cell[203339, 7257, 124, 4, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.7"}]},
  "11.8"->{
    Cell[203698, 7275, 754, 23, 70, "Text",
      CellTags->{"S2.12.11", "11.8"}]},
  "11.9"->{
    Cell[204455, 7300, 542, 14, 70, "Text",
      CellTags->{"S2.12.11", "11.9"}]},
  "11.10"->{
    Cell[205000, 7316, 113, 3, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.10"}]},
  "11.11"->{
    Cell[205354, 7333, 80, 1, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.11"}]},
  "11.12"->{
    Cell[205522, 7340, 137, 4, 70, "MathCaption",
      CellTags->{"S2.12.11", "11.12"}]},
  "11.13"->{
    Cell[208217, 7429, 113, 3, 40, "MathCaption",
      CellTags->{"S2.12.11", "11.13"}]},
  "11.14"->{
    Cell[208571, 7446, 99, 1, 40, "MathCaption",
      CellTags->{"S2.12.11", "11.14"}]},
  "11.15"->{
    Cell[208966, 7462, 140, 4, 40, "MathCaption",
      CellTags->{"S2.12.11", "11.15"}]},
  "11.16"->{
    Cell[209420, 7481, 143, 4, 40, "MathCaption",
      CellTags->{"S2.12.11", "11.16"}]},
  "11.17"->{
    Cell[209908, 7500, 414, 12, 56, "Text",
      CellTags->{"S2.12.11", "11.17"}]},
  "11.18"->{
    Cell[210325, 7514, 534, 18, 72, "Text",
      CellTags->{"S2.12.11", "11.18"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.12.0", 211503, 7552},
  {"0.1", 211594, 7555},
  {"S2.12.1", 211689, 7558},
  {"1.1", 218541, 7739},
  {"1.2", 218635, 7742},
  {"1.3", 218724, 7745},
  {"1.4", 218820, 7748},
  {"1.5", 218916, 7751},
  {"1.6", 219012, 7754},
  {"1.7", 219102, 7757},
  {"1.8", 219192, 7760},
  {"1.9", 219282, 7763},
  {"1.10", 219379, 7766},
  {"1.11", 219476, 7769},
  {"1.12", 219574, 7772},
  {"1.13", 219671, 7775},
  {"1.14", 219763, 7778},
  {"1.15", 219855, 7781},
  {"1.16", 219954, 7784},
  {"1.17", 220053, 7787},
  {"1.18", 220146, 7790},
  {"1.19", 220245, 7793},
  {"1.20", 220344, 7796},
  {"1.21", 220443, 7799},
  {"1.22", 220537, 7802},
  {"1.23", 220636, 7805},
  {"1.24", 220735, 7808},
  {"1.25", 220834, 7811},
  {"1.26", 220927, 7814},
  {"1.27", 221026, 7817},
  {"1.28", 221125, 7820},
  {"1.29", 221218, 7823},
  {"1.30", 221317, 7826},
  {"1.31", 221416, 7829},
  {"1.32", 221515, 7832},
  {"1.33", 221614, 7835},
  {"1.34", 221706, 7838},
  {"1.35", 221805, 7841},
  {"1.36", 221904, 7844},
  {"1.37", 221997, 7847},
  {"1.38", 222090, 7850},
  {"1.39", 222190, 7853},
  {"S2.12.2", 222293, 7856},
  {"2.1", 225715, 7945},
  {"2.2", 225811, 7948},
  {"2.3", 225903, 7951},
  {"2.4", 225994, 7954},
  {"2.5", 226086, 7957},
  {"2.6", 226177, 7960},
  {"2.7", 226269, 7963},
  {"2.8", 226367, 7966},
  {"2.9", 226465, 7969},
  {"2.10", 226557, 7972},
  {"2.11", 226651, 7975},
  {"2.12", 226744, 7978},
  {"2.13", 226838, 7981},
  {"2.14", 226938, 7984},
  {"2.15", 227031, 7987},
  {"2.16", 227125, 7990},
  {"2.17", 227218, 7993},
  {"2.18", 227312, 7996},
  {"2.19", 227412, 7999},
  {"2.20", 227506, 8002},
  {"2.21", 227600, 8005},
  {"S2.12.3", 227704, 8008},
  {"3.1", 235140, 8201},
  {"3.2", 235237, 8204},
  {"3.3", 235329, 8207},
  {"3.4", 235421, 8210},
  {"3.5", 235513, 8213},
  {"3.6", 235604, 8216},
  {"3.7", 235695, 8219},
  {"3.8", 235786, 8222},
  {"3.9", 235884, 8225},
  {"3.10", 235983, 8228},
  {"3.11", 236083, 8231},
  {"3.12", 236182, 8234},
  {"3.13", 236281, 8237},
  {"3.14", 236375, 8240},
  {"3.15", 236475, 8243},
  {"3.16", 236575, 8246},
  {"3.17", 236675, 8249},
  {"3.18", 236769, 8252},
  {"3.19", 236868, 8255},
  {"3.20", 236967, 8258},
  {"3.21", 237067, 8261},
  {"3.22", 237167, 8264},
  {"3.23", 237260, 8267},
  {"3.24", 237354, 8270},
  {"3.25", 237448, 8273},
  {"3.26", 237542, 8276},
  {"3.27", 237635, 8279},
  {"3.28", 237729, 8282},
  {"3.29", 237822, 8285},
  {"3.30", 237922, 8288},
  {"3.31", 238022, 8291},
  {"3.32", 238122, 8294},
  {"3.33", 238216, 8297},
  {"3.34", 238311, 8300},
  {"3.35", 238411, 8303},
  {"3.36", 238511, 8306},
  {"3.37", 238611, 8309},
  {"3.38", 238705, 8312},
  {"3.39", 238805, 8315},
  {"3.40", 238905, 8318},
  {"3.41", 239005, 8321},
  {"3.42", 239104, 8324},
  {"S2.12.4", 239201, 8327},
  {"4.1", 243313, 8434},
  {"4.2", 243409, 8437},
  {"4.3", 243500, 8440},
  {"4.4", 243592, 8443},
  {"4.5", 243684, 8446},
  {"4.6", 243782, 8449},
  {"4.7", 243880, 8452},
  {"4.8", 243978, 8455},
  {"4.9", 244076, 8458},
  {"4.10", 244169, 8461},
  {"4.11", 244263, 8464},
  {"4.12", 244356, 8467},
  {"4.13", 244450, 8470},
  {"4.14", 244543, 8473},
  {"4.15", 244637, 8476},
  {"4.16", 244731, 8479},
  {"4.17", 244831, 8482},
  {"4.18", 244931, 8485},
  {"4.19", 245031, 8488},
  {"4.20", 245124, 8491},
  {"4.21", 245218, 8494},
  {"4.22", 245318, 8497},
  {"4.23", 245418, 8500},
  {"S2.12.5", 245515, 8503},
  {"5.1", 246553, 8530},
  {"5.2", 246649, 8533},
  {"5.3", 246740, 8536},
  {"5.4", 246832, 8539},
  {"5.5", 246930, 8542},
  {"5.6", 247023, 8545},
  {"5.7", 247116, 8548},
  {"S2.12.6", 247219, 8551},
  {"6.1", 247788, 8566},
  {"6.2", 247885, 8569},
  {"6.3", 247977, 8572},
  {"S2.12.7", 248074, 8575},
  {"7.1", 252113, 8680},
  {"7.2", 252210, 8683},
  {"7.3", 252309, 8686},
  {"7.4", 252407, 8689},
  {"7.5", 252506, 8692},
  {"7.6", 252599, 8695},
  {"7.7", 252698, 8698},
  {"7.8", 252797, 8701},
  {"7.9", 252896, 8704},
  {"7.10", 252990, 8707},
  {"7.11", 253091, 8710},
  {"7.12", 253191, 8713},
  {"7.13", 253292, 8716},
  {"7.14", 253393, 8719},
  {"7.15", 253494, 8722},
  {"7.16", 253594, 8725},
  {"7.17", 253695, 8728},
  {"7.18", 253796, 8731},
  {"S2.12.8", 253900, 8734},
  {"8.1", 265096, 9023},
  {"8.2", 265193, 9026},
  {"8.3", 265286, 9029},
  {"8.4", 265384, 9032},
  {"8.5", 265483, 9035},
  {"8.6", 265582, 9038},
  {"8.7", 265681, 9041},
  {"8.8", 265774, 9044},
  {"8.9", 265873, 9047},
  {"8.10", 265973, 9050},
  {"8.11", 266067, 9053},
  {"8.12", 266167, 9056},
  {"8.13", 266268, 9059},
  {"8.14", 266369, 9062},
  {"8.15", 266470, 9065},
  {"8.16", 266571, 9068},
  {"8.17", 266666, 9071},
  {"8.18", 266767, 9074},
  {"8.19", 266862, 9077},
  {"8.20", 266963, 9080},
  {"8.21", 267064, 9083},
  {"8.22", 267165, 9086},
  {"8.23", 267266, 9089},
  {"8.24", 267366, 9092},
  {"8.25", 267467, 9095},
  {"8.26", 267568, 9098},
  {"8.27", 267669, 9101},
  {"8.28", 267764, 9104},
  {"8.29", 267865, 9107},
  {"8.30", 267966, 9110},
  {"8.31", 268067, 9113},
  {"8.32", 268161, 9116},
  {"8.33", 268261, 9119},
  {"8.34", 268362, 9122},
  {"8.35", 268456, 9125},
  {"8.36", 268557, 9128},
  {"8.37", 268658, 9131},
  {"8.38", 268759, 9134},
  {"8.39", 268854, 9137},
  {"8.40", 268948, 9140},
  {"8.41", 269048, 9143},
  {"8.42", 269149, 9146},
  {"8.43", 269250, 9149},
  {"8.44", 269344, 9152},
  {"8.45", 269439, 9155},
  {"8.46", 269539, 9158},
  {"8.47", 269639, 9161},
  {"8.48", 269739, 9164},
  {"8.49", 269839, 9167},
  {"8.50", 269939, 9170},
  {"8.51", 270039, 9173},
  {"8.52", 270139, 9176},
  {"8.53", 270234, 9179},
  {"S2.12.9", 270331, 9182},
  {"9.1", 278020, 9381},
  {"9.2", 278117, 9384},
  {"9.3", 278215, 9387},
  {"9.4", 278314, 9390},
  {"9.5", 278413, 9393},
  {"9.6", 278506, 9396},
  {"9.7", 278605, 9399},
  {"9.8", 278704, 9402},
  {"9.9", 278797, 9405},
  {"9.10", 278897, 9408},
  {"9.11", 278998, 9411},
  {"9.12", 279092, 9414},
  {"9.13", 279193, 9417},
  {"9.14", 279294, 9420},
  {"9.15", 279388, 9423},
  {"9.16", 279483, 9426},
  {"9.17", 279584, 9429},
  {"9.18", 279685, 9432},
  {"9.19", 279786, 9435},
  {"9.20", 279886, 9438},
  {"9.21", 279981, 9441},
  {"9.22", 280081, 9444},
  {"9.23", 280182, 9447},
  {"9.24", 280283, 9450},
  {"9.25", 280383, 9453},
  {"9.26", 280484, 9456},
  {"9.27", 280584, 9459},
  {"9.28", 280679, 9462},
  {"9.29", 280773, 9465},
  {"9.30", 280873, 9468},
  {"9.31", 280974, 9471},
  {"9.32", 281074, 9474},
  {"9.33", 281174, 9477},
  {"9.34", 281274, 9480},
  {"9.35", 281375, 9483},
  {"S2.12.10", 281479, 9486},
  {"10.1", 286685, 9619},
  {"10.2", 286785, 9622},
  {"10.3", 286881, 9625},
  {"10.4", 286983, 9628},
  {"10.5", 287085, 9631},
  {"10.6", 287187, 9634},
  {"10.7", 287288, 9637},
  {"10.8", 287384, 9640},
  {"10.9", 287486, 9643},
  {"10.10", 287589, 9646},
  {"10.11", 287692, 9649},
  {"10.12", 287796, 9652},
  {"10.13", 287900, 9655},
  {"10.14", 288004, 9658},
  {"10.15", 288108, 9661},
  {"10.16", 288212, 9664},
  {"10.17", 288315, 9667},
  {"10.18", 288413, 9670},
  {"10.19", 288517, 9673},
  {"10.20", 288621, 9676},
  {"10.21", 288725, 9679},
  {"10.22", 288829, 9682},
  {"10.23", 288933, 9685},
  {"10.24", 289037, 9688},
  {"S2.12.11", 289143, 9691},
  {"11.1", 292814, 9784},
  {"11.2", 292914, 9787},
  {"11.3", 293010, 9790},
  {"11.4", 293112, 9793},
  {"11.5", 293214, 9796},
  {"11.6", 293316, 9799},
  {"11.7", 293418, 9802},
  {"11.8", 293520, 9805},
  {"11.9", 293616, 9808},
  {"11.10", 293713, 9811},
  {"11.11", 293817, 9814},
  {"11.12", 293920, 9817},
  {"11.13", 294024, 9820},
  {"11.14", 294128, 9823},
  {"11.15", 294231, 9826},
  {"11.16", 294335, 9829},
  {"11.17", 294439, 9832},
  {"11.18", 294537, 9835}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 122, 4, 65, "Section",
  CellTags->{"S2.12.0", "0.1"}],

Cell[CellGroupData[{
Cell[1923, 61, 143, 5, 70, "Subsection",
  CellTags->{"S2.12.1", "1.1"}],
Cell[2069, 68, 478, 13, 70, "Text",
  CellTags->{"S2.12.1", "1.2"}],
Cell[2550, 83, 863, 24, 70, "DefinitionBox",
  CellTags->"S2.12.1"],
Cell[3416, 109, 57, 1, 70, "Caption",
  CellTags->"S2.12.1"],
Cell[3476, 112, 144, 5, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.3"}],

Cell[CellGroupData[{
Cell[3645, 121, 74, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[3722, 125, 186, 5, 70, "Print",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[3923, 133, 128, 4, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.4"}],

Cell[CellGroupData[{
Cell[4076, 141, 74, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[4153, 145, 254, 5, 70, "Output",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[4422, 153, 239, 8, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.5"}],

Cell[CellGroupData[{
Cell[4686, 165, 73, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[4762, 169, 126, 3, 70, "Message",
  CellTags->"S2.12.1"],
Cell[4891, 174, 89, 3, 70, "Output",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[4995, 180, 540, 10, 70, "Text",
  CellTags->{"S2.12.1", "1.6"}],
Cell[5538, 192, 450, 12, 70, "Text",
  CellTags->{"S2.12.1", "1.7"}],
Cell[5991, 206, 530, 13, 70, "Text",
  CellTags->{"S2.12.1", "1.8"}],
Cell[6524, 221, 1293, 38, 70, "DefinitionBox",
  CellTags->"S2.12.1"],
Cell[7820, 261, 72, 1, 70, "Caption",
  CellTags->"S2.12.1"],
Cell[7895, 264, 142, 5, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.9"}],
Cell[8040, 271, 87, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[8130, 275, 91, 1, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.10"}],

Cell[CellGroupData[{
Cell[8246, 280, 70, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[8319, 284, 84, 1, 70, "Print",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[8418, 288, 106, 1, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.11"}],
Cell[8527, 291, 88, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[8618, 295, 94, 1, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.12"}],

Cell[CellGroupData[{
Cell[8737, 300, 70, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[8810, 304, 129, 4, 70, "Print",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[8954, 311, 562, 22, 70, "Text",
  CellTags->{"S2.12.1", "1.13"}],
Cell[9519, 335, 565, 14, 70, "Text",
  CellTags->{"S2.12.1", "1.14"}],
Cell[10087, 351, 160, 5, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.15"}],
Cell[10250, 358, 101, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[10354, 362, 147, 5, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.16"}],

Cell[CellGroupData[{
Cell[10526, 371, 70, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[10599, 375, 132, 4, 70, "Print",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[10746, 382, 685, 20, 70, "Text",
  CellTags->{"S2.12.1", "1.17"}],
Cell[11434, 404, 2327, 68, 70, "DefinitionBox",
  CellTags->"S2.12.1"],
Cell[13764, 474, 67, 1, 70, "Caption",
  CellTags->"S2.12.1"],
Cell[13834, 477, 138, 5, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.18"}],

Cell[CellGroupData[{
Cell[13997, 486, 77, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[14077, 490, 91, 3, 70, "Output",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[14183, 496, 185, 7, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.19"}],
Cell[14371, 505, 84, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[14458, 509, 156, 5, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.20"}],

Cell[CellGroupData[{
Cell[14639, 518, 73, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[14715, 522, 51, 1, 70, "Print",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[14781, 526, 1278, 26, 70, "Text",
  CellTags->{"S2.12.1", "1.21"}],
Cell[16062, 554, 199, 7, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.22"}],
Cell[16264, 563, 82, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[16349, 567, 151, 5, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.23"}],
Cell[16503, 574, 84, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[16590, 578, 271, 9, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.24"}],

Cell[CellGroupData[{
Cell[16886, 591, 73, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[16962, 595, 78, 5, 70, "Print",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[17055, 603, 387, 12, 70, "Text",
  CellTags->{"S2.12.1", "1.25"}],
Cell[17445, 617, 267, 9, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.26"}],

Cell[CellGroupData[{
Cell[17737, 630, 79, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[17819, 634, 445, 14, 70, "Output",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[18279, 651, 240, 8, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.27"}],

Cell[CellGroupData[{
Cell[18544, 663, 83, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[18630, 667, 996, 29, 70, "Output",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[19641, 699, 655, 15, 70, "Text",
  CellTags->{"S2.12.1", "1.28"}],
Cell[20299, 716, 2417, 73, 70, "DefinitionBox",
  CellTags->"S2.12.1"],
Cell[22719, 791, 78, 1, 70, "Caption",
  CellTags->"S2.12.1"],
Cell[22800, 794, 157, 5, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.29"}],
Cell[22960, 801, 88, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[23051, 805, 194, 7, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.30"}],
Cell[23248, 814, 92, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[23343, 818, 225, 6, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.31"}],

Cell[CellGroupData[{
Cell[23593, 828, 73, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[23669, 832, 80, 4, 70, "Print",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[23764, 839, 223, 7, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.32"}],

Cell[CellGroupData[{
Cell[24012, 850, 73, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[24088, 854, 112, 3, 70, "Output",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[24215, 860, 2284, 64, 70, "DefinitionBox",
  CellTags->"S2.12.1"],
Cell[26502, 926, 137, 5, 70, "Caption",
  CellTags->"S2.12.1"],
Cell[26642, 933, 335, 8, 70, "Text",
  CellTags->{"S2.12.1", "1.33"}],
Cell[26980, 943, 192, 7, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.34"}],

Cell[CellGroupData[{
Cell[27197, 954, 91, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[27291, 958, 86, 3, 70, "Output",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[27392, 964, 148, 5, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.35"}],
Cell[27543, 971, 76, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[27622, 975, 458, 10, 70, "Text",
  CellTags->{"S2.12.1", "1.36"}],
Cell[28083, 987, 577, 22, 70, "Text",
  CellTags->{"S2.12.1", "1.37"}],
Cell[28663, 1011, 156, 4, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.38"}],

Cell[CellGroupData[{
Cell[28844, 1019, 90, 2, 70, "Input",
  CellTags->"S2.12.1"],
Cell[28937, 1023, 86, 3, 70, "Output",
  CellTags->"S2.12.1"]
}, Open  ]],
Cell[29038, 1029, 184, 5, 70, "MathCaption",
  CellTags->{"S2.12.1", "1.39"}],
Cell[29225, 1036, 75, 2, 70, "Input",
  CellTags->"S2.12.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29337, 1043, 78, 1, 70, "Subsection",
  CellTags->{"S2.12.2", "2.1"}],
Cell[29418, 1046, 434, 11, 70, "Text",
  CellTags->{"S2.12.2", "2.2"}],
Cell[29855, 1059, 249, 8, 70, "Text",
  CellTags->{"S2.12.2", "2.3"}],
Cell[30107, 1069, 642, 18, 70, "DefinitionBox",
  CellTags->"S2.12.2"],
Cell[30752, 1089, 152, 5, 70, "Caption",
  CellTags->"S2.12.2"],
Cell[30907, 1096, 451, 12, 70, "Text",
  CellTags->{"S2.12.2", "2.4"}],
Cell[31361, 1110, 296, 6, 70, "Text",
  CellTags->{"S2.12.2", "2.5"}],
Cell[31660, 1118, 964, 29, 70, "DefinitionBox",
  CellTags->"S2.12.2"],
Cell[32627, 1149, 84, 1, 70, "Caption",
  CellTags->"S2.12.2"],
Cell[32714, 1152, 425, 10, 70, "Text",
  CellTags->{"S2.12.2", "2.6"}],
Cell[33142, 1164, 254, 7, 70, "MathCaption",
  CellTags->{"S2.12.2", "2.7"}],
Cell[33399, 1173, 96, 2, 70, "Input",
  CellTags->"S2.12.2"],
Cell[33498, 1177, 246, 9, 70, "MathCaption",
  CellTags->{"S2.12.2", "2.8"}],

Cell[CellGroupData[{
Cell[33769, 1190, 82, 2, 70, "Input",
  CellTags->"S2.12.2"],
Cell[33854, 1194, 86, 3, 70, "Output",
  CellTags->"S2.12.2"]
}, Open  ]],
Cell[33955, 1200, 337, 8, 70, "Text",
  CellTags->{"S2.12.2", "2.9"}],
Cell[34295, 1210, 731, 16, 70, "Text",
  CellTags->{"S2.12.2", "2.10"}],
Cell[35029, 1228, 262, 5, 70, "Text",
  CellTags->{"S2.12.2", "2.11"}],
Cell[35294, 1235, 421, 12, 70, "DefinitionBox",
  CellTags->"S2.12.2"],
Cell[35718, 1249, 68, 1, 70, "Caption",
  CellTags->"S2.12.2"],
Cell[35789, 1252, 380, 11, 70, "Text",
  CellTags->{"S2.12.2", "2.12"}],
Cell[36172, 1265, 874, 26, 70, "DefinitionBox",
  CellTags->"S2.12.2"],
Cell[37049, 1293, 93, 1, 70, "Caption",
  CellTags->"S2.12.2"],
Cell[37145, 1296, 257, 6, 70, "MathCaption",
  CellTags->{"S2.12.2", "2.13"}],

Cell[CellGroupData[{
Cell[37427, 1306, 78, 2, 70, "Input",
  CellTags->"S2.12.2"],
Cell[37508, 1310, 86, 2, 70, "Print",
  CellTags->"S2.12.2"],
Cell[37597, 1314, 83, 3, 70, "Output",
  CellTags->"S2.12.2"]
}, Open  ]],
Cell[37695, 1320, 380, 9, 70, "Text",
  CellTags->{"S2.12.2", "2.14"}],
Cell[38078, 1331, 837, 17, 70, "Text",
  CellTags->{"S2.12.2", "2.15"}],
Cell[38918, 1350, 519, 15, 70, "DefinitionBox",
  CellTags->"S2.12.2"],
Cell[39440, 1367, 116, 5, 70, "Caption",
  CellTags->"S2.12.2"],
Cell[39559, 1374, 429, 9, 70, "Text",
  CellTags->{"S2.12.2", "2.16"}],
Cell[39991, 1385, 541, 14, 70, "Text",
  CellTags->{"S2.12.2", "2.17"}],
Cell[40535, 1401, 223, 6, 70, "MathCaption",
  CellTags->{"S2.12.2", "2.18"}],

Cell[CellGroupData[{
Cell[40783, 1411, 70, 2, 70, "Input",
  CellTags->"S2.12.2"],
Cell[40856, 1415, 86, 2, 70, "Print",
  CellTags->"S2.12.2"],
Cell[40945, 1419, 83, 3, 70, "Output",
  CellTags->"S2.12.2"]
}, Open  ]],
Cell[41043, 1425, 751, 22, 70, "DefinitionBox",
  CellTags->"S2.12.2"],
Cell[41797, 1449, 145, 5, 70, "Caption",
  CellTags->"S2.12.2"],
Cell[41945, 1456, 403, 10, 70, "Text",
  CellTags->{"S2.12.2", "2.19"}],
Cell[42351, 1468, 476, 13, 70, "Text",
  CellTags->{"S2.12.2", "2.20"}],
Cell[42830, 1483, 362, 12, 70, "MathCaption",
  CellTags->{"S2.12.2", "2.21"}],

Cell[CellGroupData[{
Cell[43217, 1499, 89, 2, 70, "Input",
  CellTags->"S2.12.2"],
Cell[43309, 1503, 85, 3, 70, "Output",
  CellTags->"S2.12.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[43443, 1512, 133, 4, 70, "Subsection",
  CellTags->{"S2.12.3", "3.1"}],
Cell[43579, 1518, 348, 10, 70, "Text",
  CellTags->{"S2.12.3", "3.2"}],
Cell[43930, 1530, 718, 18, 70, "Text",
  CellTags->{"S2.12.3", "3.3"}],
Cell[44651, 1550, 841, 21, 70, "Text",
  CellTags->{"S2.12.3", "3.4"}],
Cell[45495, 1573, 1231, 36, 70, "DefinitionBox",
  CellTags->"S2.12.3"],
Cell[46729, 1611, 110, 5, 70, "Caption",
  CellTags->"S2.12.3"],
Cell[46842, 1618, 409, 8, 70, "Text",
  CellTags->{"S2.12.3", "3.5"}],
Cell[47254, 1628, 367, 7, 70, "Text",
  CellTags->{"S2.12.3", "3.6"}],
Cell[47624, 1637, 246, 5, 70, "Text",
  CellTags->{"S2.12.3", "3.7"}],
Cell[47873, 1644, 144, 5, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.8"}],

Cell[CellGroupData[{
Cell[48042, 1653, 90, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[48135, 1657, 105, 3, 70, "Output",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[48255, 1663, 106, 1, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.9"}],
Cell[48364, 1666, 85, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[48452, 1670, 216, 5, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.10"}],
Cell[48671, 1677, 82, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[48756, 1681, 80, 1, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.11"}],

Cell[CellGroupData[{
Cell[48861, 1686, 76, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[48940, 1690, 87, 3, 70, "Output",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[49042, 1696, 94, 1, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.12"}],

Cell[CellGroupData[{
Cell[49161, 1701, 70, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[49234, 1705, 53, 4, 70, "Print",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[49302, 1712, 3559, 111, 70, "DefinitionBox",
  CellTags->"S2.12.3"],
Cell[52864, 1825, 78, 1, 70, "Caption",
  CellTags->"S2.12.3"],
Cell[52945, 1828, 713, 19, 70, "Text",
  CellTags->{"S2.12.3", "3.13"}],
Cell[53661, 1849, 136, 5, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.14"}],

Cell[CellGroupData[{
Cell[53822, 1858, 90, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[53915, 1862, 105, 3, 70, "Output",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[54035, 1868, 139, 4, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.15"}],

Cell[CellGroupData[{
Cell[54199, 1876, 121, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[54323, 1880, 87, 3, 70, "Output",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[54425, 1886, 211, 6, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.16"}],

Cell[CellGroupData[{
Cell[54661, 1896, 70, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[54734, 1900, 62, 4, 70, "Print",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[54811, 1907, 461, 13, 70, "Text",
  CellTags->{"S2.12.3", "3.17"}],
Cell[55275, 1922, 79, 1, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.18"}],

Cell[CellGroupData[{
Cell[55379, 1927, 90, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[55472, 1931, 105, 3, 70, "Output",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[55592, 1937, 95, 1, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.19"}],
Cell[55690, 1940, 127, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[55820, 1944, 108, 1, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.20"}],

Cell[CellGroupData[{
Cell[55953, 1949, 118, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[56074, 1953, 88, 3, 70, "Output",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[56177, 1959, 206, 5, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.21"}],

Cell[CellGroupData[{
Cell[56408, 1968, 71, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[56482, 1972, 92, 4, 70, "Print",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[56589, 1979, 2252, 62, 70, "DefinitionBox",
  CellTags->"S2.12.3"],
Cell[58844, 2043, 78, 1, 70, "Caption",
  CellTags->"S2.12.3"],
Cell[58925, 2046, 282, 8, 70, "Text",
  CellTags->{"S2.12.3", "3.22"}],
Cell[59210, 2056, 383, 10, 70, "Text",
  CellTags->{"S2.12.3", "3.23"}],
Cell[59596, 2068, 984, 29, 70, "Text",
  CellTags->{"S2.12.3", "3.24"}],
Cell[60583, 2099, 428, 11, 70, "Text",
  CellTags->{"S2.12.3", "3.25"}],
Cell[61014, 2112, 361, 8, 70, "Text",
  CellTags->{"S2.12.3", "3.26"}],
Cell[61378, 2122, 470, 14, 70, "DefinitionBox",
  CellTags->"S2.12.3"],
Cell[61851, 2138, 89, 1, 70, "Caption",
  CellTags->"S2.12.3"],
Cell[61943, 2141, 563, 12, 70, "Text",
  CellTags->{"S2.12.3", "3.27"}],
Cell[62509, 2155, 1540, 45, 70, "DefinitionBox3Col",
  CellTags->"S2.12.3"],
Cell[64052, 2202, 75, 1, 70, "Caption",
  CellTags->"S2.12.3"],
Cell[64130, 2205, 272, 8, 70, "Text",
  CellTags->{"S2.12.3", "3.28"}],
Cell[64405, 2215, 192, 6, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.29"}],

Cell[CellGroupData[{
Cell[64622, 2225, 117, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[64742, 2229, 106, 3, 70, "Output",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[64863, 2235, 129, 4, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.30"}],

Cell[CellGroupData[{
Cell[65017, 2243, 113, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[65133, 2247, 88, 3, 70, "Output",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[65236, 2253, 158, 5, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.31"}],

Cell[CellGroupData[{
Cell[65419, 2262, 71, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[65493, 2266, 78, 4, 70, "Print",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[65586, 2273, 377, 11, 70, "Text",
  CellTags->{"S2.12.3", "3.32"}],
Cell[65966, 2286, 1011, 29, 70, "Text",
  CellTags->{"S2.12.3", "3.33"}],
Cell[66980, 2317, 136, 4, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.34"}],

Cell[CellGroupData[{
Cell[67141, 2325, 108, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[67252, 2329, 106, 3, 70, "Output",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[67373, 2335, 111, 1, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.35"}],

Cell[CellGroupData[{
Cell[67509, 2340, 109, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[67621, 2344, 88, 3, 70, "Output",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[67724, 2350, 161, 4, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.36"}],

Cell[CellGroupData[{
Cell[67910, 2358, 71, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[67984, 2362, 91, 5, 70, "Print",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[68090, 2370, 588, 14, 70, "Text",
  CellTags->{"S2.12.3", "3.37"}],
Cell[68681, 2386, 1302, 37, 70, "DefinitionBox",
  CellTags->"S2.12.3"],
Cell[69986, 2425, 75, 1, 70, "Caption",
  CellTags->"S2.12.3"],
Cell[70064, 2428, 117, 2, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.38"}],

Cell[CellGroupData[{
Cell[70206, 2434, 91, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[70300, 2438, 106, 3, 70, "Output",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[70421, 2444, 156, 5, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.39"}],
Cell[70580, 2451, 106, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[70689, 2455, 154, 4, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.40"}],

Cell[CellGroupData[{
Cell[70868, 2463, 79, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[70950, 2467, 362, 7, 70, "Output",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[71327, 2477, 86, 1, 70, "MathCaption",
  CellTags->{"S2.12.3", "3.41"}],

Cell[CellGroupData[{
Cell[71438, 2482, 77, 2, 70, "Input",
  CellTags->"S2.12.3"],
Cell[71518, 2486, 88, 3, 70, "Output",
  CellTags->"S2.12.3"]
}, Open  ]],
Cell[71621, 2492, 1381, 41, 70, "DefinitionBox",
  CellTags->"S2.12.3"],
Cell[73005, 2535, 96, 1, 70, "Caption",
  CellTags->"S2.12.3"],
Cell[73104, 2538, 549, 16, 70, "Text",
  CellTags->{"S2.12.3", "3.42"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[73690, 2559, 85, 1, 70, "Subsection",
  CellTags->{"S2.12.4", "4.1"}],
Cell[73778, 2562, 273, 6, 70, "Text",
  CellTags->{"S2.12.4", "4.2"}],
Cell[74054, 2570, 484, 14, 70, "Text",
  CellTags->{"S2.12.4", "4.3"}],
Cell[74541, 2586, 442, 10, 70, "Text",
  CellTags->{"S2.12.4", "4.4"}],
Cell[74986, 2598, 856, 24, 70, "DefinitionBox",
  CellTags->"S2.12.4"],
Cell[75845, 2624, 68, 1, 70, "Caption",
  CellTags->"S2.12.4"],
Cell[75916, 2627, 130, 4, 70, "MathCaption",
  CellTags->{"S2.12.4", "4.5"}],

Cell[CellGroupData[{
Cell[76071, 2635, 77, 2, 70, "Input",
  CellTags->"S2.12.4"],
Cell[76151, 2639, 75, 2, 70, "Output",
  CellTags->"S2.12.4"]
}, Open  ]],
Cell[76241, 2644, 173, 5, 70, "MathCaption",
  CellTags->{"S2.12.4", "4.6"}],

Cell[CellGroupData[{
Cell[76439, 2653, 91, 2, 70, "Input",
  CellTags->"S2.12.4"],
Cell[76533, 2657, 84, 2, 70, "Output",
  CellTags->"S2.12.4"]
}, Open  ]],
Cell[76632, 2662, 104, 1, 70, "MathCaption",
  CellTags->{"S2.12.4", "4.7"}],

Cell[CellGroupData[{
Cell[76761, 2667, 77, 2, 70, "Input",
  CellTags->"S2.12.4"],
Cell[76841, 2671, 84, 2, 70, "Output",
  CellTags->"S2.12.4"]
}, Open  ]],
Cell[76940, 2676, 104, 1, 70, "MathCaption",
  CellTags->{"S2.12.4", "4.8"}],

Cell[CellGroupData[{
Cell[77069, 2681, 82, 2, 70, "Input",
  CellTags->"S2.12.4"],
Cell[77154, 2685, 75, 2, 70, "Output",
  CellTags->"S2.12.4"]
}, Open  ]],
Cell[77244, 2690, 493, 12, 70, "Text",
  CellTags->{"S2.12.4", "4.9"}],
Cell[77740, 2704, 708, 20, 70, "Text",
  CellTags->{"S2.12.4", "4.10"}],
Cell[78451, 2726, 1775, 52, 70, "DefinitionBox",
  CellTags->"S2.12.4"],
Cell[80229, 2780, 63, 1, 70, "Caption",
  CellTags->"S2.12.4"],
Cell[80295, 2783, 317, 7, 70, "Text",
  CellTags->{"S2.12.4", "4.11"}],
Cell[80615, 2792, 998, 31, 70, "Text",
  CellTags->{"S2.12.4", "4.12"}],
Cell[81616, 2825, 309, 8, 70, "Text",
  CellTags->{"S2.12.4", "4.13"}],
Cell[81928, 2835, 588, 16, 70, "Text",
  CellTags->{"S2.12.4", "4.14"}],
Cell[82519, 2853, 1782, 54, 70, "DefinitionBox",
  CellTags->"S2.12.4"],
Cell[84304, 2909, 65, 1, 70, "Caption",
  CellTags->"S2.12.4"],
Cell[84372, 2912, 479, 10, 70, "Text",
  CellTags->{"S2.12.4", "4.15"}],
Cell[84854, 2924, 265, 9, 70, "MathCaption",
  CellTags->{"S2.12.4", "4.16"}],

Cell[CellGroupData[{
Cell[85144, 2937, 70, 2, 70, "Input",
  CellTags->"S2.12.4"],
Cell[85217, 2941, 111, 2, 70, "Output",
  CellTags->"S2.12.4"]
}, Open  ]],
Cell[85343, 2946, 4731, 137, 70, "DefinitionBox",
  CellTags->"S2.12.4"],
Cell[90077, 3085, 92, 1, 70, "Caption",
  CellTags->"S2.12.4"],
Cell[90172, 3088, 188, 6, 70, "MathCaption",
  CellTags->{"S2.12.4", "4.17"}],

Cell[CellGroupData[{
Cell[90385, 3098, 83, 2, 70, "Input",
  CellTags->"S2.12.4"],
Cell[90471, 3102, 105, 2, 70, "Output",
  CellTags->"S2.12.4"]
}, Open  ]],
Cell[90591, 3107, 250, 8, 70, "MathCaption",
  CellTags->{"S2.12.4", "4.18"}],

Cell[CellGroupData[{
Cell[90866, 3119, 99, 2, 70, "Input",
  CellTags->"S2.12.4"],
Cell[90968, 3123, 139, 6, 70, "Output",
  CellTags->"S2.12.4"]
}, Open  ]],
Cell[91122, 3132, 408, 8, 70, "Text",
  CellTags->{"S2.12.4", "4.19"}],
Cell[91533, 3142, 2917, 88, 70, "DefinitionBox",
  CellTags->"S2.12.4"],
Cell[94453, 3232, 67, 1, 70, "Caption",
  CellTags->"S2.12.4"],
Cell[94523, 3235, 871, 27, 70, "Text",
  CellTags->{"S2.12.4", "4.20"}],
Cell[95397, 3264, 107, 1, 70, "MathCaption",
  CellTags->{"S2.12.4", "4.21"}],

Cell[CellGroupData[{
Cell[95529, 3269, 104, 2, 70, "Input",
  CellTags->"S2.12.4"],
Cell[95636, 3273, 98, 3, 70, "Output",
  CellTags->"S2.12.4"]
}, Open  ]],
Cell[95749, 3279, 179, 5, 70, "MathCaption",
  CellTags->{"S2.12.4", "4.22"}],

Cell[CellGroupData[{
Cell[95953, 3288, 89, 2, 70, "Input",
  CellTags->"S2.12.4"],
Cell[96045, 3292, 103, 3, 70, "Output",
  CellTags->"S2.12.4"]
}, Open  ]],
Cell[96163, 3298, 498, 12, 70, "Text",
  CellTags->{"S2.12.4", "4.23"}],
Cell[96664, 3312, 414, 14, 70, "DefinitionBox",
  CellTags->"S2.12.4"],
Cell[97081, 3328, 157, 5, 70, "Caption",
  CellTags->"S2.12.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[97275, 3338, 79, 1, 70, "Subsection",
  CellTags->{"S2.12.5", "5.1"}],
Cell[97357, 3341, 247, 6, 70, "Text",
  CellTags->{"S2.12.5", "5.2"}],
Cell[97607, 3349, 458, 10, 70, "Text",
  CellTags->{"S2.12.5", "5.3"}],
Cell[98068, 3361, 459, 13, 70, "DefinitionBox",
  CellTags->"S2.12.5"],
Cell[98530, 3376, 75, 1, 70, "Caption",
  CellTags->"S2.12.5"],
Cell[98608, 3379, 170, 5, 70, "MathCaption",
  CellTags->{"S2.12.5", "5.4"}],
Cell[98781, 3386, 83, 2, 70, "Input",
  CellTags->"S2.12.5"],
Cell[98867, 3390, 1647, 51, 70, "DefinitionBox",
  CellTags->"S2.12.5"],
Cell[100517, 3443, 183, 7, 70, "Caption",
  CellTags->"S2.12.5"],
Cell[100703, 3452, 621, 18, 70, "Text",
  CellTags->{"S2.12.5", "5.5"}],
Cell[101327, 3472, 707, 21, 70, "Text",
  CellTags->{"S2.12.5", "5.6"}],
Cell[102037, 3495, 229, 7, 70, "MathCaption",
  CellTags->{"S2.12.5", "5.7"}],
Cell[102269, 3504, 76, 2, 70, "Input",
  CellTags->"S2.12.5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[102382, 3511, 95, 1, 70, "Subsection",
  CellTags->{"S2.12.6", "6.1"}],
Cell[102480, 3514, 3877, 109, 70, "DefinitionBox",
  CellTags->"S2.12.6"],
Cell[106360, 3625, 76, 1, 70, "Caption",
  CellTags->"S2.12.6"],
Cell[106439, 3628, 300, 7, 70, "Text",
  CellTags->{"S2.12.6", "6.2"}],
Cell[106742, 3637, 707, 30, 70, "Text",
  CellTags->{"S2.12.6", "6.3"}],
Cell[107452, 3669, 2492, 70, 70, "DefinitionBox",
  CellTags->"S2.12.6"],
Cell[109947, 3741, 82, 1, 70, "Caption",
  CellTags->"S2.12.6"]
}, Open  ]],

Cell[CellGroupData[{
Cell[110066, 3747, 90, 1, 70, "Subsection",
  CellTags->{"S2.12.7", "7.1"}],
Cell[110159, 3750, 2624, 85, 70, "DefinitionBox",
  CellTags->"S2.12.7"],
Cell[112786, 3837, 92, 1, 70, "Caption",
  CellTags->"S2.12.7"],
Cell[112881, 3840, 149, 5, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.2"}],

Cell[CellGroupData[{
Cell[113055, 3849, 113, 2, 70, "Input",
  CellTags->"S2.12.7"],
Cell[113171, 3853, 92, 3, 70, "Output",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[113278, 3859, 90, 1, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.3"}],

Cell[CellGroupData[{
Cell[113393, 3864, 75, 2, 70, "Input",
  CellTags->"S2.12.7"],
Cell[113471, 3868, 385, 12, 70, "Output",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[113871, 3883, 148, 5, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.4"}],

Cell[CellGroupData[{
Cell[114044, 3892, 95, 2, 70, "Input",
  CellTags->"S2.12.7"],
Cell[114142, 3896, 119, 3, 70, "Output",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[114276, 3902, 571, 13, 70, "Text",
  CellTags->{"S2.12.7", "7.5"}],
Cell[114850, 3917, 119, 4, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.6"}],

Cell[CellGroupData[{
Cell[114994, 3925, 140, 5, 70, "Input",
  CellTags->"S2.12.7"],
Cell[115137, 3932, 92, 3, 70, "Output",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[115244, 3938, 191, 5, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.7"}],

Cell[CellGroupData[{
Cell[115460, 3947, 75, 2, 70, "Input",
  CellTags->"S2.12.7"],
Cell[115538, 3951, 71, 4, 70, "Print",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[115624, 3958, 145, 5, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.8"}],

Cell[CellGroupData[{
Cell[115794, 3967, 96, 2, 70, "Input",
  CellTags->"S2.12.7"],
Cell[115893, 3971, 112, 3, 70, "Output",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[116020, 3977, 711, 20, 70, "Text",
  CellTags->{"S2.12.7", "7.9"}],
Cell[116734, 3999, 110, 1, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.10"}],

Cell[CellGroupData[{
Cell[116869, 4004, 124, 2, 70, "Input",
  CellTags->"S2.12.7"],
Cell[116996, 4008, 92, 3, 70, "Output",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[117103, 4014, 83, 1, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.11"}],

Cell[CellGroupData[{
Cell[117211, 4019, 75, 2, 70, "Input",
  CellTags->"S2.12.7"],
Cell[117289, 4023, 100, 4, 70, "Print",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[117404, 4030, 145, 5, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.12"}],

Cell[CellGroupData[{
Cell[117574, 4039, 96, 2, 70, "Input",
  CellTags->"S2.12.7"],
Cell[117673, 4043, 154, 4, 70, "Output",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[117842, 4050, 152, 5, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.13"}],

Cell[CellGroupData[{
Cell[118019, 4059, 78, 2, 70, "Input",
  CellTags->"S2.12.7"],
Cell[118100, 4063, 155, 5, 70, "Output",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[118270, 4071, 2093, 59, 70, "DefinitionBox",
  CellTags->"S2.12.7"],
Cell[120366, 4132, 80, 1, 70, "Caption",
  CellTags->"S2.12.7"],
Cell[120449, 4135, 100, 1, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.14"}],

Cell[CellGroupData[{
Cell[120574, 4140, 152, 5, 70, "Input",
  CellTags->"S2.12.7"],
Cell[120729, 4147, 93, 3, 70, "Output",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[120837, 4153, 91, 1, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.15"}],

Cell[CellGroupData[{
Cell[120953, 4158, 76, 2, 70, "Input",
  CellTags->"S2.12.7"],
Cell[121032, 4162, 80, 4, 70, "Print",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[121127, 4169, 104, 1, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.16"}],

Cell[CellGroupData[{
Cell[121256, 4174, 107, 2, 70, "Input",
  CellTags->"S2.12.7"],
Cell[121366, 4178, 116, 2, 70, "Output",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[121497, 4183, 106, 1, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.17"}],

Cell[CellGroupData[{
Cell[121628, 4188, 108, 2, 70, "Input",
  CellTags->"S2.12.7"],
Cell[121739, 4192, 121, 2, 70, "Output",
  CellTags->"S2.12.7"]
}, Open  ]],
Cell[121875, 4197, 133, 4, 70, "MathCaption",
  CellTags->{"S2.12.7", "7.18"}],

Cell[CellGroupData[{
Cell[122033, 4205, 108, 2, 70, "Input",
  CellTags->"S2.12.7"],
Cell[122144, 4209, 145, 3, 70, "Output",
  CellTags->"S2.12.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[122338, 4218, 81, 1, 70, "Subsection",
  CellTags->{"S2.12.8", "8.1"}],
Cell[122422, 4221, 704, 18, 70, "Text",
  CellTags->{"S2.12.8", "8.2"}],
Cell[123129, 4241, 625, 18, 70, "DefinitionBox",
  CellTags->"S2.12.8"],
Cell[123757, 4261, 71, 1, 70, "Caption",
  CellTags->"S2.12.8"],
Cell[123831, 4264, 82, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.3"}],

Cell[CellGroupData[{
Cell[123938, 4269, 74, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[124015, 4273, 87, 4, 70, "Print",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[124117, 4280, 133, 4, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.4"}],

Cell[CellGroupData[{
Cell[124275, 4288, 94, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[124372, 4292, 124, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[124511, 4298, 1673, 54, 70, "DefinitionBox",
  CellTags->"S2.12.8"],
Cell[126187, 4354, 69, 1, 70, "Caption",
  CellTags->"S2.12.8"],
Cell[126259, 4357, 143, 4, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.5"}],

Cell[CellGroupData[{
Cell[126427, 4365, 104, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[126534, 4369, 130, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[126679, 4375, 110, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.6"}],

Cell[CellGroupData[{
Cell[126814, 4380, 115, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[126932, 4384, 128, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[127075, 4390, 541, 16, 70, "Text",
  CellTags->{"S2.12.8", "8.7"}],
Cell[127619, 4408, 218, 6, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.8"}],

Cell[CellGroupData[{
Cell[127862, 4418, 73, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[127938, 4422, 81, 4, 70, "Print",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[128034, 4429, 135, 4, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.9"}],

Cell[CellGroupData[{
Cell[128194, 4437, 93, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[128290, 4441, 120, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[128425, 4447, 1027, 31, 70, "DefinitionBox",
  CellTags->"S2.12.8"],
Cell[129455, 4480, 76, 1, 70, "Caption",
  CellTags->"S2.12.8"],
Cell[129534, 4483, 259, 7, 70, "Text",
  CellTags->{"S2.12.8", "8.10"}],
Cell[129796, 4492, 88, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.11"}],

Cell[CellGroupData[{
Cell[129909, 4497, 74, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[129986, 4501, 77, 4, 70, "Print",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[130078, 4508, 164, 4, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.12"}],

Cell[CellGroupData[{
Cell[130267, 4516, 97, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[130367, 4520, 248, 5, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[130630, 4528, 141, 4, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.13"}],

Cell[CellGroupData[{
Cell[130796, 4536, 92, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[130891, 4540, 235, 5, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[131141, 4548, 134, 4, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.14"}],

Cell[CellGroupData[{
Cell[131300, 4556, 114, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[131417, 4560, 236, 5, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[131668, 4568, 2005, 66, 70, "DefinitionBox",
  CellTags->"S2.12.8"],
Cell[133676, 4636, 67, 1, 70, "Caption",
  CellTags->"S2.12.8"],
Cell[133746, 4639, 203, 6, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.15"}],

Cell[CellGroupData[{
Cell[133974, 4649, 93, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[134070, 4653, 130, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[134215, 4659, 766, 15, 70, "Text",
  CellTags->{"S2.12.8", "8.16"}],
Cell[134984, 4676, 2088, 68, 70, "DefinitionBox3Col",
  CellTags->"S2.12.8"],
Cell[137075, 4746, 108, 5, 70, "Caption",
  CellTags->"S2.12.8"],
Cell[137186, 4753, 265, 9, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.17"}],

Cell[CellGroupData[{
Cell[137476, 4766, 127, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[137606, 4770, 136, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[137757, 4776, 603, 12, 70, "Text",
  CellTags->{"S2.12.8", "8.18"}],
Cell[138363, 4790, 130, 4, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.19"}],

Cell[CellGroupData[{
Cell[138518, 4798, 108, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[138629, 4802, 118, 2, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[138762, 4807, 176, 4, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.20"}],

Cell[CellGroupData[{
Cell[138963, 4815, 77, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[139043, 4819, 90, 4, 70, "Print",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[139148, 4826, 118, 2, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.21"}],

Cell[CellGroupData[{
Cell[139291, 4832, 145, 5, 70, "Input",
  CellTags->"S2.12.8"],
Cell[139439, 4839, 133, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[139587, 4845, 172, 4, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.22"}],

Cell[CellGroupData[{
Cell[139784, 4853, 164, 5, 70, "Input",
  CellTags->"S2.12.8"],
Cell[139951, 4860, 165, 4, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[140131, 4867, 2497, 72, 70, "DefinitionBox",
  CellTags->"S2.12.8"],
Cell[142631, 4941, 128, 5, 70, "Caption",
  CellTags->"S2.12.8"],
Cell[142762, 4948, 93, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.23"}],

Cell[CellGroupData[{
Cell[142880, 4953, 74, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[142957, 4957, 91, 4, 70, "Print",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[143063, 4964, 179, 5, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.24"}],

Cell[CellGroupData[{
Cell[143267, 4973, 142, 5, 70, "Input",
  CellTags->"S2.12.8"],
Cell[143412, 4980, 132, 2, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[143559, 4985, 210, 7, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.25"}],

Cell[CellGroupData[{
Cell[143794, 4996, 148, 5, 70, "Input",
  CellTags->"S2.12.8"],
Cell[143945, 5003, 111, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[144071, 5009, 144, 4, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.26"}],

Cell[CellGroupData[{
Cell[144240, 5017, 173, 5, 70, "Input",
  CellTags->"S2.12.8"],
Cell[144416, 5024, 103, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[144534, 5030, 713, 21, 70, "Text",
  CellTags->{"S2.12.8", "8.27"}],
Cell[145250, 5053, 166, 4, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.28"}],

Cell[CellGroupData[{
Cell[145441, 5061, 73, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[145517, 5065, 70, 1, 70, "Print",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[145602, 5069, 117, 2, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.29"}],

Cell[CellGroupData[{
Cell[145744, 5075, 118, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[145865, 5079, 123, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[146003, 5085, 127, 4, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.30"}],

Cell[CellGroupData[{
Cell[146155, 5093, 147, 5, 70, "Input",
  CellTags->"S2.12.8"],
Cell[146305, 5100, 172, 4, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[146492, 5107, 454, 9, 70, "Text",
  CellTags->{"S2.12.8", "8.31"}],
Cell[146949, 5118, 75, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.32"}],

Cell[CellGroupData[{
Cell[147049, 5123, 76, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[147128, 5127, 58, 1, 70, "Print",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[147201, 5131, 149, 4, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.33"}],

Cell[CellGroupData[{
Cell[147375, 5139, 124, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[147502, 5143, 168, 4, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[147685, 5150, 299, 8, 70, "Text",
  CellTags->{"S2.12.8", "8.34"}],
Cell[147987, 5160, 170, 5, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.35"}],

Cell[CellGroupData[{
Cell[148182, 5169, 73, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[148258, 5173, 61, 5, 70, "Print",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[148334, 5181, 185, 7, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.36"}],

Cell[CellGroupData[{
Cell[148544, 5192, 97, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[148644, 5196, 99, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[148758, 5202, 108, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.37"}],

Cell[CellGroupData[{
Cell[148891, 5207, 103, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[148997, 5211, 112, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[149124, 5217, 874, 29, 70, "Text",
  CellTags->{"S2.12.8", "8.38"}],
Cell[150001, 5248, 333, 8, 70, "Text",
  CellTags->{"S2.12.8", "8.39"}],
Cell[150337, 5258, 83, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.40"}],

Cell[CellGroupData[{
Cell[150445, 5263, 75, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[150523, 5267, 87, 4, 70, "Print",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[150625, 5274, 207, 6, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.41"}],

Cell[CellGroupData[{
Cell[150857, 5284, 121, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[150981, 5288, 160, 4, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[151156, 5295, 838, 24, 70, "DefinitionBox",
  CellTags->"S2.12.8"],
Cell[151997, 5321, 77, 1, 70, "Caption",
  CellTags->"S2.12.8"],
Cell[152077, 5324, 171, 5, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.42"}],

Cell[CellGroupData[{
Cell[152273, 5333, 93, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[152369, 5337, 115, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[152499, 5343, 2080, 63, 70, "DefinitionBox",
  CellTags->"S2.12.8"],
Cell[154582, 5408, 84, 1, 70, "Caption",
  CellTags->"S2.12.8"],
Cell[154669, 5411, 324, 8, 70, "Text",
  CellTags->{"S2.12.8", "8.43"}],
Cell[154996, 5421, 792, 19, 70, "Text",
  CellTags->{"S2.12.8", "8.44"}],
Cell[155791, 5442, 83, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.45"}],

Cell[CellGroupData[{
Cell[155899, 5447, 75, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[155977, 5451, 87, 4, 70, "Print",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[156079, 5458, 98, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.46"}],

Cell[CellGroupData[{
Cell[156202, 5463, 94, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[156299, 5467, 109, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[156423, 5473, 99, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.47"}],

Cell[CellGroupData[{
Cell[156547, 5478, 84, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[156634, 5482, 88, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[156737, 5488, 95, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.48"}],

Cell[CellGroupData[{
Cell[156857, 5493, 94, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[156954, 5497, 97, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[157066, 5503, 84, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.49"}],
Cell[157153, 5506, 84, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[157240, 5510, 94, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.50"}],

Cell[CellGroupData[{
Cell[157359, 5515, 88, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[157450, 5519, 97, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[157562, 5525, 86, 1, 70, "MathCaption",
  CellTags->{"S2.12.8", "8.51"}],

Cell[CellGroupData[{
Cell[157673, 5530, 77, 2, 70, "Input",
  CellTags->"S2.12.8"],
Cell[157753, 5534, 92, 3, 70, "Output",
  CellTags->"S2.12.8"]
}, Open  ]],
Cell[157860, 5540, 310, 13, 70, "Text",
  CellTags->{"S2.12.8", "8.52"}],
Cell[158173, 5555, 207, 7, 70, "Text",
  CellTags->{"S2.12.8", "8.53"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[158417, 5567, 76, 1, 70, "Subsection",
  CellTags->{"S2.12.9", "9.1"}],
Cell[158496, 5570, 2434, 73, 70, "DefinitionBox",
  CellTags->"S2.12.9"],
Cell[160933, 5645, 85, 1, 70, "Caption",
  CellTags->"S2.12.9"],
Cell[161021, 5648, 92, 1, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.2"}],

Cell[CellGroupData[{
Cell[161138, 5653, 75, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[161216, 5657, 127, 5, 70, "Print",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[161358, 5665, 172, 5, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.3"}],

Cell[CellGroupData[{
Cell[161555, 5674, 95, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[161653, 5678, 159, 4, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[161827, 5685, 144, 5, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.4"}],

Cell[CellGroupData[{
Cell[161996, 5694, 99, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[162098, 5698, 84, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[162197, 5704, 899, 22, 70, "Text",
  CellTags->{"S2.12.9", "9.5"}],
Cell[163099, 5728, 213, 6, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.6"}],

Cell[CellGroupData[{
Cell[163337, 5738, 125, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[163465, 5742, 121, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[163601, 5748, 1947, 64, 70, "DefinitionBox3Col",
  CellTags->"S2.12.9"],
Cell[165551, 5814, 108, 5, 70, "Caption",
  CellTags->"S2.12.9"],
Cell[165662, 5821, 187, 5, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.7"}],

Cell[CellGroupData[{
Cell[165874, 5830, 121, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[165998, 5834, 117, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[166130, 5840, 561, 18, 70, "Text",
  CellTags->{"S2.12.9", "9.8"}],
Cell[166694, 5860, 216, 7, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.9"}],

Cell[CellGroupData[{
Cell[166935, 5871, 115, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[167053, 5875, 84, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[167152, 5881, 1463, 42, 70, "DefinitionBox",
  CellTags->"S2.12.9"],
Cell[168618, 5925, 71, 1, 70, "Caption",
  CellTags->"S2.12.9"],
Cell[168692, 5928, 179, 7, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.10"}],

Cell[CellGroupData[{
Cell[168896, 5939, 114, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[169013, 5943, 159, 4, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[169187, 5950, 217, 7, 70, "Text",
  CellTags->{"S2.12.9", "9.11"}],
Cell[169407, 5959, 570, 17, 70, "DefinitionBox",
  CellTags->"S2.12.9"],
Cell[169980, 5978, 95, 1, 70, "Caption",
  CellTags->"S2.12.9"],
Cell[170078, 5981, 142, 5, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.12"}],

Cell[CellGroupData[{
Cell[170245, 5990, 70, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[170318, 5994, 86, 2, 70, "Print",
  CellTags->"S2.12.9"],
Cell[170407, 5998, 83, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[170505, 6004, 128, 4, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.13"}],

Cell[CellGroupData[{
Cell[170658, 6012, 120, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[170781, 6016, 94, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[170890, 6022, 1257, 37, 70, "DefinitionBox",
  CellTags->"S2.12.9"],
Cell[172150, 6061, 82, 1, 70, "Caption",
  CellTags->"S2.12.9"],
Cell[172235, 6064, 363, 9, 70, "Text",
  CellTags->{"S2.12.9", "9.14"}],
Cell[172601, 6075, 511, 13, 70, "Text",
  CellTags->{"S2.12.9", "9.15"}],
Cell[173115, 6090, 141, 5, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.16"}],

Cell[CellGroupData[{
Cell[173281, 6099, 96, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[173380, 6103, 110, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[173505, 6109, 142, 5, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.17"}],

Cell[CellGroupData[{
Cell[173672, 6118, 86, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[173761, 6122, 100, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[173876, 6128, 187, 7, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.18"}],

Cell[CellGroupData[{
Cell[174088, 6139, 86, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[174177, 6143, 116, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[174308, 6149, 86, 1, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.19"}],

Cell[CellGroupData[{
Cell[174419, 6154, 78, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[174500, 6158, 93, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[174608, 6164, 411, 15, 70, "Text",
  CellTags->{"S2.12.9", "9.20"}],
Cell[175022, 6181, 85, 1, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.21"}],

Cell[CellGroupData[{
Cell[175132, 6186, 96, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[175231, 6190, 110, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[175356, 6196, 227, 6, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.22"}],

Cell[CellGroupData[{
Cell[175608, 6206, 89, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[175700, 6210, 100, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[175815, 6216, 165, 4, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.23"}],

Cell[CellGroupData[{
Cell[176005, 6224, 83, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[176091, 6228, 88, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[176194, 6234, 94, 1, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.24"}],
Cell[176291, 6237, 86, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[176380, 6241, 206, 6, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.25"}],

Cell[CellGroupData[{
Cell[176611, 6251, 85, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[176699, 6255, 116, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[176830, 6261, 86, 1, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.26"}],

Cell[CellGroupData[{
Cell[176941, 6266, 78, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[177022, 6270, 93, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[177130, 6276, 1425, 39, 70, "DefinitionBox",
  CellTags->"S2.12.9"],
Cell[178558, 6317, 93, 1, 70, "Caption",
  CellTags->"S2.12.9"],
Cell[178654, 6320, 332, 10, 70, "Text",
  CellTags->{"S2.12.9", "9.27"}],
Cell[178989, 6332, 352, 7, 70, "Text",
  CellTags->{"S2.12.9", "9.28"}],
Cell[179344, 6341, 79, 1, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.29"}],

Cell[CellGroupData[{
Cell[179448, 6346, 96, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[179547, 6350, 110, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[179672, 6356, 229, 8, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.30"}],

Cell[CellGroupData[{
Cell[179926, 6368, 87, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[180016, 6372, 84, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[180115, 6378, 95, 1, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.31"}],

Cell[CellGroupData[{
Cell[180235, 6383, 85, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[180323, 6387, 116, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[180454, 6393, 92, 1, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.32"}],

Cell[CellGroupData[{
Cell[180571, 6398, 87, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[180661, 6402, 85, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[180761, 6408, 92, 1, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.33"}],

Cell[CellGroupData[{
Cell[180878, 6413, 93, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[180974, 6417, 84, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[181073, 6423, 150, 5, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.34"}],

Cell[CellGroupData[{
Cell[181248, 6432, 85, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[181336, 6436, 111, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]],
Cell[181462, 6442, 80, 1, 70, "MathCaption",
  CellTags->{"S2.12.9", "9.35"}],

Cell[CellGroupData[{
Cell[181567, 6447, 78, 2, 70, "Input",
  CellTags->"S2.12.9"],
Cell[181648, 6451, 93, 3, 70, "Output",
  CellTags->"S2.12.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[181790, 6460, 93, 1, 70, "Subsection",
  CellTags->{"S2.12.10", "10.1"}],
Cell[181886, 6463, 599, 16, 70, "Text",
  CellTags->{"S2.12.10", "10.2"}],
Cell[182488, 6481, 664, 18, 70, "DefinitionBox",
  CellTags->"S2.12.10"],
Cell[183155, 6501, 78, 1, 70, "Caption",
  CellTags->"S2.12.10"],
Cell[183236, 6504, 113, 1, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.3"}],

Cell[CellGroupData[{
Cell[183374, 6509, 110, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[183487, 6513, 106, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[183608, 6519, 157, 4, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.4"}],

Cell[CellGroupData[{
Cell[183790, 6527, 81, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[183874, 6531, 86, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[183975, 6537, 105, 1, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.5"}],

Cell[CellGroupData[{
Cell[184105, 6542, 85, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[184193, 6546, 109, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[184317, 6552, 87, 1, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.6"}],

Cell[CellGroupData[{
Cell[184429, 6557, 76, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[184508, 6561, 89, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[184612, 6567, 682, 19, 70, "Text",
  CellTags->{"S2.12.10", "10.7"}],
Cell[185297, 6588, 107, 1, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.8"}],

Cell[CellGroupData[{
Cell[185429, 6593, 103, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[185535, 6597, 106, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[185656, 6603, 143, 4, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.9"}],

Cell[CellGroupData[{
Cell[185824, 6611, 85, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[185912, 6615, 84, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[186011, 6621, 95, 1, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.10"}],

Cell[CellGroupData[{
Cell[186131, 6626, 83, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[186217, 6630, 86, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[186318, 6636, 138, 4, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.11"}],

Cell[CellGroupData[{
Cell[186481, 6644, 85, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[186569, 6648, 84, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[186668, 6654, 146, 4, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.12"}],

Cell[CellGroupData[{
Cell[186839, 6662, 91, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[186933, 6666, 84, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[187032, 6672, 200, 7, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.13"}],

Cell[CellGroupData[{
Cell[187257, 6683, 84, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[187344, 6687, 86, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[187445, 6693, 117, 2, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.14"}],

Cell[CellGroupData[{
Cell[187587, 6699, 99, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[187689, 6703, 86, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[187790, 6709, 173, 5, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.15"}],

Cell[CellGroupData[{
Cell[187988, 6718, 84, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[188075, 6722, 93, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[188183, 6728, 82, 1, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.16"}],

Cell[CellGroupData[{
Cell[188290, 6733, 77, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[188370, 6737, 90, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[188475, 6743, 551, 13, 70, "Text",
  CellTags->{"S2.12.10", "10.17"}],
Cell[189029, 6758, 158, 5, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.18"}],

Cell[CellGroupData[{
Cell[189212, 6767, 144, 5, 70, "Input",
  CellTags->"S2.12.10"],
Cell[189359, 6774, 171, 4, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[189545, 6781, 101, 1, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.19"}],

Cell[CellGroupData[{
Cell[189671, 6786, 90, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[189764, 6790, 107, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[189886, 6796, 162, 5, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.20"}],

Cell[CellGroupData[{
Cell[190073, 6805, 88, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[190164, 6809, 161, 4, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[190340, 6816, 138, 4, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.21"}],

Cell[CellGroupData[{
Cell[190503, 6824, 92, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[190598, 6828, 85, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[190698, 6834, 200, 5, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.22"}],

Cell[CellGroupData[{
Cell[190923, 6843, 114, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[191040, 6847, 89, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[191144, 6853, 208, 6, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.23"}],

Cell[CellGroupData[{
Cell[191377, 6863, 82, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[191462, 6867, 91, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]],
Cell[191568, 6873, 88, 1, 70, "MathCaption",
  CellTags->{"S2.12.10", "10.24"}],

Cell[CellGroupData[{
Cell[191681, 6878, 77, 2, 70, "Input",
  CellTags->"S2.12.10"],
Cell[191761, 6882, 90, 3, 70, "Output",
  CellTags->"S2.12.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[191900, 6891, 92, 1, 70, "Subsection",
  CellTags->{"S2.12.11", "11.1"}],
Cell[191995, 6894, 435, 13, 70, "Text",
  CellTags->{"S2.12.11", "11.2"}],
Cell[192433, 6909, 5914, 169, 70, "DefinitionBox",
  CellTags->"S2.12.11"],
Cell[198350, 7080, 76, 1, 70, "Caption",
  CellTags->"S2.12.11"],
Cell[198429, 7083, 3461, 105, 70, "DefinitionBox",
  CellTags->"S2.12.11"],
Cell[201893, 7190, 162, 7, 70, "Caption",
  CellTags->"S2.12.11"],
Cell[202058, 7199, 100, 1, 70, "MathCaption",
  CellTags->{"S2.12.11", "11.3"}],

Cell[CellGroupData[{
Cell[202183, 7204, 106, 2, 70, "Input",
  CellTags->"S2.12.11"],
Cell[202292, 7208, 88, 3, 70, "Output",
  CellTags->"S2.12.11"]
}, Open  ]],
Cell[202395, 7214, 166, 4, 70, "MathCaption",
  CellTags->{"S2.12.11", "11.4"}],
Cell[202564, 7220, 81, 2, 70, "Input",
  CellTags->"S2.12.11"],
Cell[202648, 7224, 136, 4, 70, "MathCaption",
  CellTags->{"S2.12.11", "11.5"}],

Cell[CellGroupData[{
Cell[202809, 7232, 85, 2, 70, "Input",
  CellTags->"S2.12.11"],
Cell[202897, 7236, 85, 3, 70, "Output",
  CellTags->"S2.12.11"]
}, Open  ]],
Cell[202997, 7242, 112, 1, 70, "MathCaption",
  CellTags->{"S2.12.11", "11.6"}],

Cell[CellGroupData[{
Cell[203134, 7247, 101, 2, 70, "Input",
  CellTags->"S2.12.11"],
Cell[203238, 7251, 86, 3, 70, "Output",
  CellTags->"S2.12.11"]
}, Open  ]],
Cell[203339, 7257, 124, 4, 70, "MathCaption",
  CellTags->{"S2.12.11", "11.7"}],

Cell[CellGroupData[{
Cell[203488, 7265, 100, 2, 70, "Input",
  CellTags->"S2.12.11"],
Cell[203591, 7269, 92, 3, 70, "Output",
  CellTags->"S2.12.11"]
}, Open  ]],
Cell[203698, 7275, 754, 23, 70, "Text",
  CellTags->{"S2.12.11", "11.8"}],
Cell[204455, 7300, 542, 14, 70, "Text",
  CellTags->{"S2.12.11", "11.9"}],
Cell[205000, 7316, 113, 3, 70, "MathCaption",
  CellTags->{"S2.12.11", "11.10"}],

Cell[CellGroupData[{
Cell[205138, 7323, 109, 2, 70, "Input",
  CellTags->"S2.12.11"],
Cell[205250, 7327, 89, 3, 70, "Output",
  CellTags->"S2.12.11"]
}, Open  ]],
Cell[205354, 7333, 80, 1, 70, "MathCaption",
  CellTags->{"S2.12.11", "11.11"}],
Cell[205437, 7336, 82, 2, 70, "Input",
  CellTags->"S2.12.11"],
Cell[205522, 7340, 137, 4, 70, "MathCaption",
  CellTags->{"S2.12.11", "11.12"}],

Cell[CellGroupData[{
Cell[205684, 7348, 143, 5, 45, "Input",
  CellTags->"S2.12.11"],
Cell[205830, 7355, 93, 3, 70, "Output",
  CellTags->"S2.12.11"]
}, Open  ]],
Cell[205938, 7361, 2199, 63, 162, "DefinitionBox",
  CellTags->"S2.12.11"],
Cell[208140, 7426, 74, 1, 16, "Caption",
  CellTags->"S2.12.11"],
Cell[208217, 7429, 113, 3, 40, "MathCaption",
  CellTags->{"S2.12.11", "11.13"}],

Cell[CellGroupData[{
Cell[208355, 7436, 109, 2, 28, "Input",
  CellTags->"S2.12.11"],
Cell[208467, 7440, 89, 3, 25, "Output",
  CellTags->"S2.12.11"]
}, Open  ]],
Cell[208571, 7446, 99, 1, 40, "MathCaption",
  CellTags->{"S2.12.11", "11.14"}],

Cell[CellGroupData[{
Cell[208695, 7451, 101, 2, 28, "Input",
  CellTags->"S2.12.11"],
Cell[208799, 7455, 152, 4, 25, "Output",
  CellTags->"S2.12.11"]
}, Open  ]],
Cell[208966, 7462, 140, 4, 40, "MathCaption",
  CellTags->{"S2.12.11", "11.15"}],

Cell[CellGroupData[{
Cell[209131, 7470, 103, 2, 28, "Input",
  CellTags->"S2.12.11"],
Cell[209237, 7474, 168, 4, 27, "Output",
  CellTags->"S2.12.11"]
}, Open  ]],
Cell[209420, 7481, 143, 4, 40, "MathCaption",
  CellTags->{"S2.12.11", "11.16"}],

Cell[CellGroupData[{
Cell[209588, 7489, 115, 2, 28, "Input",
  CellTags->"S2.12.11"],
Cell[209706, 7493, 187, 4, 43, "Output",
  CellTags->"S2.12.11"]
}, Open  ]],
Cell[209908, 7500, 414, 12, 56, "Text",
  CellTags->{"S2.12.11", "11.17"}],
Cell[210325, 7514, 534, 18, 72, "Text",
  CellTags->{"S2.12.11", "11.18"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

