(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    213936,       7889]*)
(*NotebookOutlinePosition[    348324,      11724]*)
(*  CellTagsIndexPosition[    333346,      11158]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.13 ", "HeadingNumber"],
  StyleBox["MathLink", "SBO"],
  " and External Program Communication"
}], "Section",
  CellTags->{"S2.13.0", "0.1"}],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.1 How ",
  StyleBox["MathLink", "SBO"],
  " Is Used"
}], "Subsection",
  CellTags->{"S2.13.1", "1.1"}],

Cell[TextData[{
  "Most of this book has been concerned with how human users interact with ",
  StyleBox["Mathematica", "TI"],
  ". ",
  StyleBox["MathLink", "TI"],
  " provides a mechanism through which ",
  StyleBox["programs", "TI"],
  " rather than human users can interact with ",
  StyleBox["Mathematica", "TI"],
  "."
}], "Text",
  CellTags->{"S2.13.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              
              "\[FilledSmallSquare] Calling functions in an external program \
from within ",
              StyleBox["Mathematica", "TI"],
              ". "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Calling ",
              StyleBox["Mathematica", "TI"],
              " from within an external program. "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Setting up alternative front ends to ",
              StyleBox["Mathematica", "TI"],
              ". "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Exchanging data between ",
              StyleBox["Mathematica", "TI"],
              " and external programs. "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Exchanging data between concurrent ",
              StyleBox["Mathematica", "TI"],
              " processes. "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.1"],

Cell[TextData[{
  "Some typical uses of ",
  StyleBox["MathLink", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.1"],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " provides a general interface for external programs to communicate with ",
  StyleBox["Mathematica", "TI"],
  ". Many standard software systems now have ",
  StyleBox["MathLink", "TI"],
  " compatibility either built in or available in add\[Hyphen]on modules. "
}], "Text",
  CellTags->{"S2.13.1", "1.3"}],

Cell[TextData[{
  "In addition, the ",
  StyleBox["MathLink", "TI"],
  " Developer Kit bundled with most versions of ",
  StyleBox["Mathematica", "TI"],
  " provides the tools you need to create your own ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible programs. "
}], "Text",
  CellTags->{"S2.13.1", "1.4"}],

Cell[TextData[{
  "Once you have a ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible program, you can transparently establish a link \
between it and ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.13.1", "1.5"}],

Cell["\<\
The link can either be on a single computer, or it can be over a \
network, potentially with a different type of computer at each end. \
\>", \
"Text",
  CellTags->{"S2.13.1", "1.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            Cell["\<\
\[FilledSmallSquare] Implementing inner loops in a low\
\[Hyphen]level language. \
\>"]},
          {Cell[TextData[{
              
              "\[FilledSmallSquare] Handling large volumes of data external \
to ",
              StyleBox["Mathematica", "TI"],
              ". "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Sending ",
              StyleBox["Mathematica", "TI"],
              " graphics or other data for special processing. "
            }]]},
          {
            Cell["\<\
\[FilledSmallSquare] Connecting to a system with an \
existing user interface. \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.1"],

Cell[TextData[{
  "A few uses of ",
  StyleBox["MathLink", "SO"],
  "\[Hyphen]compatible programs. "
}], "Caption",
  CellTags->"S2.13.1"],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible programs range from very simple to very complex. A \
minimal ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible program is just a few lines long. But it is also \
possible to build very large and sophisticated ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible programs. Indeed, the ",
  StyleBox["Mathematica", "TI"],
  " notebook front end is one example of a sophisticated ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible program. "
}], "Text",
  CellTags->{"S2.13.1", "1.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["MathLink", "TI"],
              " is a mechanism for exchanging ",
              StyleBox["Mathematica", "TI"],
              " expressions between programs. "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.1"],

Cell[TextData[{
  "The basic idea of ",
  StyleBox["MathLink", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.1"],

Cell[TextData[{
  "Much of the power of ",
  StyleBox["MathLink", "TI"],
  " comes from its use of ",
  StyleBox["Mathematica", "TI"],
  " expressions. The basic idea is that ",
  StyleBox["MathLink", "TI"],
  " provides a way to exchange ",
  StyleBox["Mathematica", "TI"],
  " expressions between programs, and such expressions can represent \
absolutely any kind of data. "
}], "Text",
  CellTags->{"S2.13.1", "1.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["\[FilledSmallSquare] An array of numbers. "]},
          {
            Cell["\<\
\[FilledSmallSquare] A collection of geometrical \
objects. \
\>"]},
          {Cell["\[FilledSmallSquare] A sequence of commands. "]},
          {Cell["\[FilledSmallSquare] A stream of text. "]},
          {Cell["\[FilledSmallSquare] Records in a database. "]},
          {Cell[TextData[{
              "\[FilledSmallSquare] The cells of a ",
              StyleBox["Mathematica", "TI"],
              " notebook. "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.1"],

Cell[TextData[{
  "A few examples of data represented by ",
  StyleBox["Mathematica", "SO"],
  " expressions in ",
  StyleBox["MathLink", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.1"],

Cell[TextData[{
  "The ",
  StyleBox["MathLink", "TI"],
  " library consists of a collection of routines that allow external programs \
to send and receive ",
  StyleBox["Mathematica", "TI"],
  " expressions.  "
}], "Text",
  CellTags->{"S2.13.1", "1.9"}],

Cell[TextData[{
  "The ",
  StyleBox["MathLink", "TI"],
  " Developer Kit provides utilities for incorporating these routines into \
external programs. Utilities are included for a variety of languages, \
although in this chapter we discuss mainly the case of C. "
}], "Text",
  CellTags->{"S2.13.1", "1.10"}],

Cell[TextData[{
  "An important feature of the ",
  StyleBox["MathLink", "TI"],
  " library is that it is completely platform independent: it can \
transparently use any interprogram communication mechanism that exists on \
your computer system. "
}], "Text",
  CellTags->{"S2.13.1", "1.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.2 Installing Existing ",
  StyleBox["MathLink", "SBO"],
  "\[Hyphen]Compatible Programs"
}], "Subsection",
  CellTags->{"S2.13.2", "2.1"}],

Cell[TextData[{
  "One of the most common uses of ",
  StyleBox["MathLink", "TI"],
  " is to allow you to call functions in an external program from within ",
  StyleBox["Mathematica", "TI"],
  ". Once the external program has been set up, all you need do to be able to \
use it is to \[OpenCurlyDoubleQuote]install\[CloseCurlyDoubleQuote] it in \
your current ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Text",
  CellTags->{"S2.13.2", "2.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Install[\"", "MR"],
              StyleBox["prog", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "install a ",
              StyleBox["MathLink", "TI"],
              "\[Hyphen]compatible external program "
            }]]},
          {Cell[TextData[{
              StyleBox["Uninstall[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["uninstall the program "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.2"],

Cell[TextData[{
  "Setting up external programs with functions to be called from within ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.2"],

Cell[TextData[{
  "This installs a ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible external program called ",
  StyleBox["bitprog", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.2", "2.3"}],

Cell[CellGroupData[{

Cell["Install[\"bitprog\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.13.2"],

Cell[BoxData[
    \(LinkObject["./bitprog", 4, 3]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.13.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["BitShift", "MR"],
  " is one of the functions inside ",
  StyleBox["bitprog", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.2", "2.4"}],

Cell[CellGroupData[{

Cell["BitShift[111, 3]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.13.2"],

Cell[BoxData[
    \(13\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.13.2"]
}, Open  ]],

Cell[TextData[{
  "You can use it just as you would a function within ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.2", "2.5"}],

Cell[CellGroupData[{

Cell["Table[BitShift[111, i], {i, 30, 35}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.13.2"],

Cell[BoxData[
    \({0, 0, 111, 55, 27, 13}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.13.2"]
}, Open  ]],

Cell[TextData[{
  "When you have a package written in the ",
  StyleBox["Mathematica", "TI"],
  " language a single version will run unchanged on any computer system. But \
external programs typically need to be compiled separately for every \
different type of computer. "
}], "Text",
  CellTags->{"S2.13.2", "2.6"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " has a convention of keeping versions of external programs in directories \
that are named after the types of computers on which they will run. And \
assuming that this convention has been followed, ",
  StyleBox["Install[\"", "MR"],
  StyleBox["prog", "TI"],
  StyleBox["\"]", "MR"],
  " should always install the version of ",
  StyleBox["prog", "TI"],
  " appropriate for the particular kind of computer that you are currently \
using. "
}], "Text",
  CellTags->{"S2.13.2", "2.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Install[\"name`\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "install a program found anywhere on ",
              StyleBox["$Path", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.2"],

Cell["Using context names to specify programs to install. ", "Caption",
  CellTags->"S2.13.2"],

Cell[TextData[{
  "When you ask to read in a ",
  StyleBox["Mathematica", "TI"],
  " language file using ",
  StyleBox["<<", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will automatically search all directories in the list ",
  StyleBox["$Path", "MR"],
  " in order to find a file with the appropriate name. Similarly, if you use \
",
  StyleBox["Install[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`\"]", "MR"],
  " ",
  StyleBox["Mathematica", "TI"],
  " will automatically search all directories in ",
  StyleBox["$Path", "MR"],
  " in order to find an external program with the name ",
  StyleBox["name", "TI"],
  StyleBox[".exe", "MR"],
  ". ",
  StyleBox["Install[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`\"]", "MR"],
  " allows you to install programs that are stored in a central directory \
without explicitly having to specify their location.    "
}], "Text",
  CellTags->{"S2.13.2", "2.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.3 Setting Up External Functions to Be Called from ",
  StyleBox["Mathematica", "SBO"]
}], "Subsection",
  CellTags->{"S2.13.3", "3.1"}],

Cell[TextData[{
  "If you have a function defined in an external program, then what you need \
to do in order to make it possible to call the function from within ",
  StyleBox["Mathematica", "TI"],
  " is to add appropriate ",
  StyleBox["MathLink", "TI"],
  " code that passes arguments to the function, and takes back the results it \
produces. "
}], "Text",
  CellTags->{"S2.13.3", "3.2"}],

Cell[TextData[{
  "In simple cases, you can generate the necessary code just by giving an \
appropriate ",
  StyleBox["MathLink", "TI"],
  " ",
  StyleBox["template", "TI"],
  " for each external function.   "
}], "Text",
  CellTags->{"S2.13.3", "3.3"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.4"}],

Cell["\<\
:Begin:
:Function:      f
:Pattern:       f[x_Integer, y_Integer]
:Arguments:     {x, y}
:ArgumentTypes: {Integer, Integer}
:ReturnType:    Integer
:End:\
\>", "Program",
  CellTags->{"S2.13.3", "3.5"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.6"}],

Cell[TextData[{
  "A file ",
  StyleBox["f.tm", "MR"],
  " containing a ",
  StyleBox["MathLink", "SO"],
  " template for an external function ",
  StyleBox["f", "MR"],
  "."
}], "Caption",
  CellTags->"S2.13.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox[":Begin:", "MR"],
              " "
            }]], Cell["begin the template for a particular function "]},
          {Cell[TextData[{
              StyleBox[":Function:", "MR"],
              " "
            }]], Cell["the name of the function in the external program "]},
          {Cell[TextData[{
              StyleBox[":Pattern:", "MR"],
              " "
            }]], Cell["the pattern to be defined to call the function "]},
          {Cell[TextData[{
              StyleBox[":Arguments:", "MR"],
              " "
            }]], Cell["the arguments to the function "]},
          {Cell[TextData[{
              StyleBox[":ArgumentTypes:", "MR"],
              " "
            }]], Cell["the types of the arguments to the function "]},
          {Cell[TextData[{
              StyleBox[":ReturnType:", "MR"],
              " "
            }]], Cell["the type of the value returned by the function "]},
          {Cell[TextData[{
              StyleBox[":End:", "MR"],
              " "
            }]], Cell["end the template for a particular function "]},
          {Cell[TextData[{
              StyleBox[":Evaluate:", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " input to evaluate when the function is installed "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, False, False, True}},
  CellTags->"S2.13.3"],

Cell[TextData[{
  "The elements of a ",
  StyleBox["MathLink", "SO"],
  " template. "
}], "Caption",
  CellTags->"S2.13.3"],

Cell[TextData[{
  "Once you have constructed a ",
  StyleBox["MathLink", "TI"],
  " template for a particular external function, you have to combine this \
template with the actual source code for the function. Assuming that the \
source code is written in the C programming language, you can do this just by \
adding a line to include the standard ",
  StyleBox["MathLink", "TI"],
  " header file, and then inserting a small ",
  StyleBox["main", "MR"],
  " program. "
}], "Text",
  CellTags->{"S2.13.3", "3.7"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.8"}],

Cell[TextData[{
  "Include the standard ",
  StyleBox["MathLink", "TI"],
  " header file. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.9"}],

Cell["\<\
#include \"mathlink.h\"
\
\>", "Program",
  CellTags->{"S2.13.3", "3.10"}],

Cell[TextData[{
  "Here is the actual source code for the function ",
  StyleBox["f", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.11"}],

Cell[TextData[{
  "int f(int x, int y) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n   return x+y;\n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.3", "3.12"}],

Cell[TextData[{
  "This sets up the external program to be ready to take requests from ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.13"}],

Cell[TextData[{
  "int main(int argc, char *argv[]) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n   return MLMain(argc, argv);\n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.3", "3.14"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.15"}],

Cell[TextData[{
  "A file ",
  StyleBox["f.c", "MR"],
  " containing C source code. "
}], "Caption",
  CellTags->"S2.13.3"],

Cell[TextData[{
  "Note that the form of ",
  StyleBox["main", "MR"],
  " required on different systems may be slightly different. The release \
notes included in the ",
  StyleBox["MathLink", "TI"],
  " Developer Kit on your particular computer system should give the \
appropriate form. "
}], "Text",
  CellTags->{"S2.13.3", "3.16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["mcc", "MR"],
              " "
            }]], Cell[TextData[{
              "preprocess and compile ",
              StyleBox["MathLink", "TI"],
              " source files "
            }]]},
          {Cell[TextData[{
              StyleBox["mprep", "MR"],
              " "
            }]], Cell[TextData[{
              "preprocess ",
              StyleBox["MathLink", "TI"],
              " source files "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.3"],

Cell[TextData[{
  "Typical external programs for processing ",
  StyleBox["MathLink", "SO"],
  " source files. "
}], "Caption",
  CellTags->"S2.13.3"],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " templates are conventionally put in files with names of the form ",
  StyleBox["file", "TI"],
  StyleBox[".tm", "MR"],
  ". Such files can also contain C source code, interspersed between \
templates for different functions. "
}], "Text",
  CellTags->{"S2.13.3", "3.17"}],

Cell[TextData[{
  "Once you have set up the appropriate files, you then need to process the \
",
  StyleBox["MathLink", "TI"],
  " template information, and compile all of your source code. Typically you \
do this by running various external programs, but the details will depend on \
your computer system. "
}], "Text",
  CellTags->{"S2.13.3", "3.18"}],

Cell[TextData[{
  "Under Unix, for example, the ",
  StyleBox["MathLink", "TI"],
  " Developer Kit includes a program named ",
  StyleBox["mcc", "MR"],
  " which will preprocess ",
  StyleBox["MathLink", "TI"],
  " templates in any file whose name ends with ",
  StyleBox[".tm", "MR"],
  ", and then call ",
  StyleBox["cc", "MR"],
  " on the resulting C source code. ",
  StyleBox["mcc", "MR"],
  " will pass command\[Hyphen]line options and other files directly to ",
  StyleBox["cc", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.3", "3.19"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.20"}],

Cell[TextData[{
  "This preprocesses ",
  StyleBox["f.tm", "MR"],
  ", then compiles the resulting C source file together with the file ",
  StyleBox["f.c", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.21"}],

Cell["mcc -o f.exe f.tm f.c", "Program",
  CellTags->{"S2.13.3", "3.22"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.23"}],

Cell[TextData[{
  "This installs the binary in the current ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.24"}],

Cell[CellGroupData[{

Cell["Install[\"f.exe\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \(LinkObject["f.exe", 4, 4]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["f[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  " calls the external function ",
  StyleBox["f(int", "MR"],
  " ",
  StyleBox["x,", "MR"],
  " ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["y)", "MR"],
  " and adds two integers together. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.25"}],

Cell[CellGroupData[{

Cell["f[6, 9]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \(15\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell["\<\
The external program handles only machine integers, so this gives a \
peculiar result. \
\>", "MathCaption",
  CellTags->{"S2.13.3", "3.26"}],

Cell[CellGroupData[{

Cell["f[2^31-1, 5]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \(\(-2147483644\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  "On systems other than Unix, the ",
  StyleBox["MathLink", "TI"],
  " Developer Kit typically includes a program named ",
  StyleBox["mprep", "MR"],
  ", which you have to call directly, giving as input all of the ",
  StyleBox[".tm", "MR"],
  " files that you want to preprocess. ",
  StyleBox["mprep", "MR"],
  " will generate C source code as output, which you can then feed to a C \
compiler. "
}], "Text",
  CellTags->{"S2.13.3", "3.27"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Install[\"", "MR"],
              StyleBox["prog", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["install an external program "]},
          {Cell[TextData[{
              StyleBox["Uninstall[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["uninstall an external program "]},
          {Cell[TextData[{
              StyleBox["Links[\"", "MR"],
              StyleBox["prog", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "show active links associated with ",
              StyleBox["\"", "MR"],
              StyleBox["prog", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Links[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["show all active links "]},
          {Cell[TextData[{
              StyleBox["LinkPatterns[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "show patterns that can be evaluated on a particular link "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.3"],

Cell["Handling links to external programs. ", "Caption",
  CellTags->"S2.13.3"],

Cell[TextData[{
  "This finds the link to the ",
  StyleBox["f.exe", "MR"],
  " program. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.28"}],

Cell[CellGroupData[{

Cell["Links[\"f.exe\"]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \({LinkObject["./f.exe", 6, 4]}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  "This shows the ",
  StyleBox["Mathematica", "TI"],
  " patterns that can be evaluated using the link. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.29"}],

Cell[CellGroupData[{

Cell["LinkPatterns[%[[1]]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    RowBox[{"{", 
      TagBox[\(f[x_Integer, y_Integer]\),
        HoldForm], "}"}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Install", "MR"],
  " sets up the actual function ",
  StyleBox["f", "MR"],
  " to execute an appropriate ",
  StyleBox["ExternalCall", "MR"],
  " function. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.30"}],

Cell[CellGroupData[{

Cell["?f", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \("Global`f"\)], "Print",
  CellTags->"S2.13.3"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(f[x_Integer, y_Integer] := 
                    ExternalCall[LinkObject["./f.exe", 6, 4], 
                      CallPacket[0, {x, y}]]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ f],
      Editable->False]], "Print",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  "When a ",
  StyleBox["MathLink", "TI"],
  " template file is processed, two basic things are done. First, the ",
  StyleBox[":Pattern:", "MR"],
  " and ",
  StyleBox[":Arguments:", "MR"],
  " specifications are used to generate a ",
  StyleBox["Mathematica", "TI"],
  " definition that calls an external function via ",
  StyleBox["MathLink", "TI"],
  ". And second, the ",
  StyleBox[":Function:", "MR"],
  ", ",
  StyleBox[":ArgumentTypes:", "MR"],
  " and ",
  StyleBox[":ReturnType:", "MR"],
  " specifications are used to generate C source code that calls your \
function within the external program. "
}], "Text",
  CellTags->{"S2.13.3", "3.31"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.32"}],

Cell[":Begin:", "Program",
  CellTags->{"S2.13.3", "3.33"}],

Cell["\<\
This gives the name of the actual C function to call in the \
external program.\
\>", "MathCaption",
  CellTags->{"S2.13.3", "3.34"}],

Cell[":Function:      prog_add", "Program",
  CellTags->{"S2.13.3", "3.35"}],

Cell[TextData[{
  "This gives the ",
  StyleBox["Mathematica", "TI"],
  " pattern for which a definition should be set up."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.36"}],

Cell[":Pattern:       SkewAdd[x_Integer, y_Integer:1]", "Program",
  CellTags->{"S2.13.3", "3.37"}],

Cell["\<\
The values of the two list elements are the actual arguments to be \
passed to the external function. \
\>", "MathCaption",
  CellTags->{"S2.13.3", "3.38"}],

Cell[TextData[{
  ":Arguments:     ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "x, If[x > 1, y, y + x - 2]",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.3", "3.39"}],

Cell["\<\
This specifies that the arguments should be passed as integers to \
the C function.\
\>", "MathCaption",
  CellTags->{"S2.13.3", "3.40"}],

Cell[TextData[{
  ":ArgumentTypes: ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Integer, Integer",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.3", "3.41"}],

Cell["\<\
This specifies that the return value from the C function will be an \
integer.\
\>", "MathCaption",
  CellTags->{"S2.13.3", "3.42"}],

Cell[":ReturnType:    Integer", "Program",
  CellTags->{"S2.13.3", "3.43"}],

Cell[":End:", "Program",
  CellTags->{"S2.13.3", "3.44"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.45"}],

Cell[TextData[{
  "Both the ",
  StyleBox[":Pattern:", "MR"],
  " and ",
  StyleBox[":Arguments:", "MR"],
  " specifications in a ",
  StyleBox["MathLink", "TI"],
  " template can be any ",
  StyleBox["Mathematica", "TI"],
  " expressions. Whatever you give as the ",
  StyleBox[":Arguments:", "MR"],
  " specification will be evaluated every time you call the external \
function. The result of the evaluation will be used as the list of arguments \
to pass to the function. "
}], "Text",
  CellTags->{"S2.13.3", "3.46"}],

Cell[TextData[{
  "Sometimes you may want to set up ",
  StyleBox["Mathematica", "TI"],
  " expressions that should be evaluated not when an external function is \
called, but instead only when the external function is first installed. "
}], "Text",
  CellTags->{"S2.13.3", "3.47"}],

Cell[TextData[{
  "You can do this by inserting ",
  StyleBox[":Evaluate:", "MR"],
  " specifications in your ",
  StyleBox["MathLink", "TI"],
  " template. The expression you give after ",
  StyleBox[":Evaluate:", "MR"],
  " can go on for several lines: it is assumed to end when there is first a \
blank line, or a line that does not begin with spaces or tabs. "
}], "Text",
  CellTags->{"S2.13.3", "3.48"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.49"}],

Cell[TextData[{
  "This specifies that a usage message for ",
  StyleBox["SkewAdd", "MR"],
  " should be set up when the external program is installed."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.50"}],

Cell["\<\
:Evaluate:    SkewAdd::usage = \"SkewAdd[x, y] performs
       a skew addition in an external program.\"\
\>", "Program",
  CellTags->{"S2.13.3", "3.51"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.52"}],

Cell[TextData[{
  "When an external program is installed, the specifications in its ",
  StyleBox["MathLink", "TI"],
  " template file are used in the order they were given. This means that any \
expressions given in ",
  StyleBox[":Evaluate:", "MR"],
  " specifications that appear before ",
  StyleBox[":Begin:", "MR"],
  " will have been evaluated before definitions for the external function are \
set up. "
}], "Text",
  CellTags->{"S2.13.3", "3.53"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.54"}],

Cell[TextData[{
  "Here are ",
  StyleBox["Mathematica", "TI"],
  " expressions to be evaluated before the definitions for external functions \
are set up."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.55"}],

Cell["\<\
:Evaluate:  BeginPackage[\"XPack`\"]
:Evaluate:  XF1::usage = \"XF1[x, y] is one external function.\"
:Evaluate:  XF2::usage = \"XF2[x] is another external function.\"
:Evaluate:  Begin[\"`Private`\"]
\
\>", "Program",
  CellTags->{"S2.13.3", "3.56"}],

Cell[TextData[{
  "This specifies that the function ",
  StyleBox["XF1", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " should be set up to call the function ",
  StyleBox["f", "MR"],
  " in the external C program."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.57"}],

Cell[TextData[{
  ":Begin:\n:Function:       f\n:Pattern:        XF1[x_Integer, y_Integer]\n\
:Arguments:      ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "x, y",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Integer, Integer",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ReturnType:     Integer\n:End:\n"
}], "Program",
  CellTags->{"S2.13.3", "3.58"}],

Cell[TextData[{
  "This specifies that ",
  StyleBox["XF2", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " should call ",
  StyleBox["g", "MR"],
  ". Its argument and return value are taken to be approximate real numbers. \
"
}], "MathCaption",
  CellTags->{"S2.13.3", "3.59"}],

Cell[TextData[{
  ":Begin:\n:Function:       g\n:Pattern:        XF2[x_?NumberQ]\n:Arguments: \
     ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "x",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Real",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ReturnType:     Real\n:End:\n"
}], "Program",
  CellTags->{"S2.13.3", "3.60"}],

Cell[TextData[{
  "These ",
  StyleBox["Mathematica", "TI"],
  " expressions are evaluated after the definitions for the external \
functions. They end the special context used for the definitions."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.61"}],

Cell["\<\
:Evaluate:  End[ ]
:Evaluate:  EndPackage[ ]\
\>", "Program",
  CellTags->{"S2.13.3", "3.62"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.63"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.64"}],

Cell[TextData[{
  "Here is the actual source code for the function ",
  StyleBox["f", "MR"],
  ". There is no need for the arguments of this function to have the same \
names as their ",
  StyleBox["Mathematica", "TI"],
  " counterparts."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.65"}],

Cell[TextData[{
  "int f(int i, int j) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n   return i + j;\n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n"
}], "Program",
  CellTags->{"S2.13.3", "3.66"}],

Cell[TextData[{
  "Here is the actual source code for ",
  StyleBox["g", "MR"],
  ". Numbers that you give in ",
  StyleBox["Mathematica", "TI"],
  " will automatically be converted into C ",
  StyleBox["double", "MR"],
  " types before being passed to ",
  StyleBox["g", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.67"}],

Cell[TextData[{
  "double g(double x) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n   return x*x;\n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.3", "3.68"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.69"}],

Cell[TextData[{
  "By using ",
  StyleBox[":Evaluate:", "MR"],
  " specifications, you can evaluate ",
  StyleBox["Mathematica", "TI"],
  " expressions when an external program is first installed. You can also \
execute code inside the external program at this time simply by inserting the \
code in ",
  StyleBox["main()", "MR"],
  " before the call to ",
  StyleBox["MLMain()", "MR"],
  ". This is sometimes useful if you need to initialize the external program \
before any functions in it are used. "
}], "Text",
  CellTags->{"S2.13.3", "3.70"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLEvaluateString(stdlink,", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\")", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate a string as ",
              StyleBox["Mathematica", "TI"],
              " input "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.3"],

Cell[TextData[{
  "Executing a command in ",
  StyleBox["Mathematica", "SO"],
  " from within an external program. "
}], "Caption",
  CellTags->"S2.13.3"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.71"}],

Cell["int diff(int i, int j) {", "Program",
  CellTags->{"S2.13.3", "3.72"}],

Cell[TextData[{
  "This evaluates a ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["Print", "MR"],
  " function if ",
  StyleBox["i", "MR"],
  " ",
  StyleBox["<", "MR"],
  " ",
  StyleBox["j", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.73"}],

Cell["\<\
    if (i < j) MLEvaluateString(stdlink, \
\"Print[\\\"negative\\\"]\");\
\>", "Program",
  CellTags->{"S2.13.3", "3.74"}],

Cell["\<\
    return i - j;
}\
\>", "Program",
  CellTags->{"S2.13.3", "3.75"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.76"}],

Cell[TextData[{
  "This installs an external program containing the ",
  StyleBox["diff", "MR"],
  " function defined above. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.77"}],

Cell[CellGroupData[{

Cell["Install[\"diffprog\"]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \(LinkObject["./diffprog", 7, 5]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  "Calling ",
  StyleBox["diff", "MR"],
  " causes ",
  StyleBox["Print", "MR"],
  " to be executed. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.78"}],

Cell[CellGroupData[{

Cell["diff[4, 7]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \("negative"\)], "Print",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \(\(-3\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  "Note that any results generated in the evaluation requested by ",
  StyleBox["MLEvaluateString()", "MR"],
  " are ignored. To make use of such results requires full two\[Hyphen]way \
communication between ",
  StyleBox["Mathematica", "TI"],
  " and external programs, as discussed in Section\[NonBreakingSpace]",
  ButtonBox["2.13.9",
    ButtonData:>{"2.13.9", "9.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.13.3", "3.79"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.13.4 Handling Lists, Arrays and Other Expressions", "Subsection",
  CellTags->{"S2.13.4", "4.1"}],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " allows you to exchange data of any type with external programs. For more \
common types of data, you simply need to give appropriate ",
  StyleBox[":ArgumentTypes:", "MR"],
  " or ",
  StyleBox[":ReturnType:", "MR"],
  " specifications in your ",
  StyleBox["MathLink", "TI"],
  " template file. "
}], "Text",
  CellTags->{"S2.13.4", "4.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              StyleBox[" specification", "SO10"],
              " "
            }]], Cell[""], Cell[TextData[{
              StyleBox["C specification", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Integer", "MR"],
              " "
            }]], Cell["integer "], Cell[TextData[{
              StyleBox["int", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Real", "MR"],
              " "
            }]], Cell["floating\[Hyphen]point number "], Cell[TextData[{
              StyleBox["double", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["IntegerList", "MR"],
              " "
            }]], Cell["list of integers "], Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["*", "MR"],
              ", ",
              StyleBox["long", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["RealList", "MR"],
              " "
            }]], Cell["\<\
list of floating\[Hyphen]point numbers \
\>"], 
            Cell[TextData[{
              StyleBox["double", "MR"],
              " ",
              StyleBox["*", "MR"],
              ", ",
              StyleBox["long", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["String", "MR"],
              " "
            }]], Cell["character string "], Cell[TextData[{
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Symbol", "MR"],
              " "
            }]], Cell["symbol name "], Cell[TextData[{
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Manual", "MR"],
              " "
            }]], Cell[TextData[{
              "call ",
              StyleBox["MathLink", "TI"],
              " routines directly "
            }]], Cell[TextData[{
              StyleBox["void", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False, False, False, False, False, True}},
  CellTags->"S2.13.4"],

Cell["Basic type specifications. ", "Caption",
  CellTags->"S2.13.4"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.3"}],

Cell[TextData[{
  "Here is the ",
  StyleBox["MathLink", "TI"],
  " template for a function that takes a list of integers as its argument. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.4"}],

Cell[TextData[{
  ":Begin:\n:Function:       h\n:Pattern:        h[a_List]\n:Arguments:      \
",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "a",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "IntegerList",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ReturnType:     Integer\n:End:\n"
}], "Program",
  CellTags->{"S2.13.4", "4.5"}],

Cell[TextData[{
  "Here is the C source code for the function. Note the extra argument ",
  StyleBox["alen", "MR"],
  " which is used to pass the length of the list. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.6"}],

Cell[TextData[{
  "int h(int *a, long alen) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n\n   int i, tot=0;\n\n   for(i=0; i<alen; i++)\n      tot += a[i];\n\n   \
return tot;\n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.4", "4.7"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.8"}],

Cell[TextData[{
  "This installs an external program containing the specifications for the \
function ",
  StyleBox["h", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.9"}],

Cell[CellGroupData[{

Cell["Install[\"hprog\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \(LinkObject["./hprog", 9, 6]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell["This calls the external code. ", "MathCaption",
  CellTags->{"S2.13.4", "4.10"}],

Cell[CellGroupData[{

Cell["h[{3, 5, 6}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \(14\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  "This does not match the pattern ",
  StyleBox["h[a_List]", "MR"],
  " so does not call the external code. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.11"}],

Cell[CellGroupData[{

Cell["h[67]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \(h[67]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  "The pattern is matched, but the elements in the list are of the wrong type \
for the external code, so ",
  StyleBox["$Failed", "MR"],
  " is returned. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.12"}],

Cell[CellGroupData[{

Cell["h[{a, b, c}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  "You can mix basic types of arguments in any way you want. Whenever you use \
",
  StyleBox["IntegerList", "MR"],
  " or ",
  StyleBox["RealList", "MR"],
  ", however, you have to include an extra argument in your C program to \
represent the length of the list. "
}], "Text",
  CellTags->{"S2.13.4", "4.13"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.14"}],

Cell[TextData[{
  "Here is an ",
  StyleBox[":ArgumentTypes:", "MR"],
  " specification. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.15"}],

Cell[TextData[{
  ":ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "IntegerList, RealList, Integer",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n"
}], "Program",
  CellTags->{"S2.13.4", "4.16"}],

Cell["Here is a possible corresponding C function declaration. ", \
"MathCaption",
  CellTags->{"S2.13.4", "4.17"}],

Cell["void f(int *a, long alen, double *b, long blen, int c)", "Program",
  CellTags->{"S2.13.4", "4.18"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.19"}],

Cell[TextData[{
  "Note that when a list is passed to a C program by ",
  StyleBox["MathLink", "TI"],
  " its first element is assumed to be at position 0, as is standard in C, \
rather than at position 1, as is standard in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.13.4", "4.20"}],

Cell[TextData[{
  "In addition, following C standards, character strings specified by ",
  StyleBox["String", "MR"],
  " are passed as ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  " objects, terminated by \[Backslash]",
  StyleBox["0", "MR"],
  " null bytes. Section\[NonBreakingSpace]",
  ButtonBox["2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  " discusses how to handle special characters. "
}], "Text",
  CellTags->{"S2.13.4", "4.21"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLPutInteger(stdlink,", "MR"],
              " ",
              StyleBox["int", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a single integer "]},
          {Cell[TextData[{
              StyleBox["MLPutReal(stdlink,", "MR"],
              " ",
              StyleBox["double", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
put a single floating\[Hyphen]point number \
\>"]},
          {Cell[TextData[{
              StyleBox["MLPutIntegerList(stdlink,", "MR"],
              " ",
              StyleBox["int", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "put a list of ",
              StyleBox["n", "TI"],
              " integers starting from location\[NonBreakingSpace]",
              StyleBox["a", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutRealList(stdlink,", "MR"],
              " ",
              StyleBox["double", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "put a list of ",
              StyleBox["n", "TI"],
              
              " floating\[Hyphen]point numbers starting from location\
\[NonBreakingSpace]",
              StyleBox["a", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutIntegerArray(stdlink,", "MR"],
              " ",
              StyleBox["int", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["dims", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["NULL,", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "put an array of integers to form a depth ",
              StyleBox["d", "TI"],
              " list with dimensions ",
              StyleBox["dims", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutRealArray(stdlink,", "MR"],
              " ",
              StyleBox["double", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["dims", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["NULL,", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
put an array of floating\[Hyphen]point numbers \
\>"]},
          {Cell[TextData[{
              StyleBox["MLPutString(stdlink,", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a character string "]},
          {Cell[TextData[{
              StyleBox["MLPutSymbol(stdlink,", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a character string as a symbol name "]},
          {Cell[TextData[{
              StyleBox["MLPutFunction(stdlink,", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "begin putting a function with head ",
              StyleBox["s", "TI"],
              " and ",
              StyleBox["n", "TI"],
              " arguments "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False, True, False, True, False, True}},
  CellTags->"S2.13.4"],

Cell[TextData[{
  StyleBox["MathLink", "SO"],
  " functions for sending data to ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.4"],

Cell[TextData[{
  "When you use a ",
  StyleBox["MathLink", "TI"],
  " template file, what ",
  StyleBox["mprep", "MR"],
  " and ",
  StyleBox["mcc", "MR"],
  " actually do is to create a C program that includes explicit calls to ",
  StyleBox["MathLink", "TI"],
  " library functions. If you want to understand how ",
  StyleBox["MathLink", "TI"],
  " works, you can look at the source code of this program. Note when you use \
",
  StyleBox["mcc", "MR"],
  ", you typically need to give a ",
  StyleBox["-g", "MR"],
  " option, otherwise the source code that is generated is automatically \
deleted.  "
}], "Text",
  CellTags->{"S2.13.4", "4.22"}],

Cell[TextData[{
  "If your external function just returns a single integer or floating\
\[Hyphen]point number, then you can specify this just by giving ",
  StyleBox["Integer", "MR"],
  " or ",
  StyleBox["Real", "MR"],
  " as the ",
  StyleBox[":ReturnType:", "MR"],
  " in your ",
  StyleBox["MathLink", "TI"],
  " template file. But because of the way memory allocation and deallocation \
work in C, you cannot directly give ",
  StyleBox[":ReturnType:", "MR"],
  " specifications such as ",
  StyleBox["IntegerList", "MR"],
  " or ",
  StyleBox["RealList", "MR"],
  ". And instead, to return such structures, you must explicitly call ",
  StyleBox["MathLink", "TI"],
  " library functions within your C program, and give ",
  StyleBox["Manual", "MR"],
  " as the ",
  StyleBox[":ReturnType:", "MR"],
  " specification. "
}], "Text",
  CellTags->{"S2.13.4", "4.23"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.24"}],

Cell[TextData[{
  "Here is the ",
  StyleBox["MathLink", "TI"],
  " template for a function that takes an integer as an argument, and returns \
its value using explicit ",
  StyleBox["MathLink", "TI"],
  " functions. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.25"}],

Cell[TextData[{
  ":Begin:\n:Function:       bits\n:Pattern:        bits[i_Integer]\n\
:Arguments:      ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "i",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Integer",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ReturnType:     Manual\n:End:\n"
}], "Program",
  CellTags->{"S2.13.4", "4.26"}],

Cell[TextData[{
  "The function is declared as ",
  StyleBox["void", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.27"}],

Cell["\<\
void bits(int i) {

   int a[32], k;
\
\>", "Program",
  CellTags->{"S2.13.4", "4.28"}],

Cell[TextData[{
  "This puts values into the C array ",
  StyleBox["a", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.4", "4.29"}],

Cell[TextData[{
  "   for(k=0; k<32; k++) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n       a[k] = i%2;\n       i >>= 1;\n       if (i==0) break;\n   ",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n\n   if (k<32) k++;\n"
}], "Program",
  CellTags->{"S2.13.4", "4.30"}],

Cell[TextData[{
  "This sends ",
  StyleBox["k", "MR"],
  " elements of the array ",
  StyleBox["a", "MR"],
  " back to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.31"}],

Cell["\<\
    MLPutIntegerList(stdlink, a, k);
    return ;
}\
\>", "Program",
  CellTags->{"S2.13.4", "4.32"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.33"}],

Cell[TextData[{
  "This installs the program containing the external function ",
  StyleBox["bits", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.34"}],

Cell[CellGroupData[{

Cell["Install[\"bitsprog\"]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \(LinkObject[bitsprog, 5, 5]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell["The external function now returns a list of bits. ", "MathCaption",
  CellTags->{"S2.13.4", "4.35"}],

Cell[CellGroupData[{

Cell["bits[14]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \({0, 1, 1, 1}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  "If you declare an array in C as ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox["[", "MR"],
  StyleBox["n1", "TI"],
  StyleBox["][", "MR"],
  StyleBox["n2", "TI"],
  StyleBox["][", "MR"],
  StyleBox["n3", "TI"],
  StyleBox["]", "MR"],
  " then you can use ",
  StyleBox["MLPutIntegerArray()", "MR"],
  " to send it to ",
  StyleBox["Mathematica", "TI"],
  " as a depth 3 list. "
}], "Text",
  CellTags->{"S2.13.4", "4.36"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.37"}],

Cell["...", "Program",
  CellTags->{"S2.13.4", "4.38"}],

Cell["\<\
Here is a declaration for a 3\[Hyphen]dimensional C array.\
\>", \
"MathCaption",
  CellTags->{"S2.13.4", "4.39"}],

Cell["   int a[8][16][100];", "Program",
  CellTags->{"S2.13.4", "4.40"}],

Cell[TextData[{
  "This sets up the array ",
  StyleBox["dims", "MR"],
  " and initializes it to the dimensions of ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.41"}],

Cell[TextData[{
  "   long dims[] = ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "8, 16, 100",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  ";"
}], "Program",
  CellTags->{"S2.13.4", "4.42"}],

Cell["\<\
   ...
\
\>", "Program",
  CellTags->{"S2.13.4", "4.43"}],

Cell[TextData[{
  "This sends the 3\[Hyphen]dimensional array ",
  StyleBox["a", "MR"],
  " to ",
  StyleBox["Mathematica", "TI"],
  ", creating a depth 3 list. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.44"}],

Cell["    MLPutIntegerArray(stdlink, a, dims, NULL, 3);", "Program",
  CellTags->{"S2.13.4", "4.45"}],

Cell["...", "Program",
  CellTags->{"S2.13.4", "4.46"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.47"}],

Cell[TextData[{
  "You can use ",
  StyleBox["MathLink", "TI"],
  " functions to create absolutely any ",
  StyleBox["Mathematica", "TI"],
  " expression. The basic idea is to call a sequence of ",
  StyleBox["MathLink", "TI"],
  " functions that correspond directly to the ",
  StyleBox["FullForm", "MR"],
  " representation of the ",
  StyleBox["Mathematica", "TI"],
  " expression. "
}], "Text",
  CellTags->{"S2.13.4", "4.48"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.49"}],

Cell[TextData[{
  "This sets up the ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["Plus", "MR"],
  " with 2 arguments. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.50"}],

Cell["MLPutFunction(stdlink, \"Plus\", 2);", "Program",
  CellTags->{"S2.13.4", "4.51"}],

Cell[TextData[{
  "This specifies that the first argument is the integer ",
  StyleBox["77", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.4", "4.52"}],

Cell["MLPutInteger(stdlink, 77);", "Program",
  CellTags->{"S2.13.4", "4.53"}],

Cell[TextData[{
  "And this specifies that the second argument is the symbol ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.54"}],

Cell["MLPutSymbol(stdlink, \"x\");", "Program",
  CellTags->{"S2.13.4", "4.55"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.56"}],

Cell[TextData[{
  "In general, you first call ",
  StyleBox["MLPutFunction()", "MR"],
  ", giving the head of the ",
  StyleBox["Mathematica", "TI"],
  " function you want to create, and the number of arguments it has. Then you \
call other ",
  StyleBox["MathLink", "TI"],
  " functions to fill in each of these arguments in turn. Section ",
  ButtonBox["2.1",
    ButtonData:>{"2.1"},
    ButtonStyle->"MainBookLink"],
  " discusses the general structure of ",
  StyleBox["Mathematica", "TI"],
  " expressions and the notion of heads. "
}], "Text",
  CellTags->{"S2.13.4", "4.57"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.58"}],

Cell[TextData[{
  "This creates a ",
  StyleBox["Mathematica", "TI"],
  " list with 2 elements. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.59"}],

Cell["MLPutFunction(stdlink, \"List\", 2);", "Program",
  CellTags->{"S2.13.4", "4.60"}],

Cell[TextData[{
  "The first element of the list is a list of 10 integers from the C array ",
  StyleBox["r", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.61"}],

Cell["MLPutIntegerList(stdlink, r, 10);", "Program",
  CellTags->{"S2.13.4", "4.62"}],

Cell["\<\
The second element of the main list is itself a list with 2 \
elements. \
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.63"}],

Cell["MLPutFunction(stdlink, \"List\", 2);", "Program",
  CellTags->{"S2.13.4", "4.64"}],

Cell["\<\
The first element of this sublist is a floating\[Hyphen]point \
number. \
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.65"}],

Cell["MLPutReal(stdlink, 4.5);", "Program",
  CellTags->{"S2.13.4", "4.66"}],

Cell["The second element is an integer. ", "MathCaption",
  CellTags->{"S2.13.4", "4.67"}],

Cell["MLPutInteger(stdlink, 11);", "Program",
  CellTags->{"S2.13.4", "4.68"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.69"}],

Cell[TextData[{
  StyleBox["MLPutIntegerArray()", "MR"],
  " and ",
  StyleBox["MLPutRealArray()", "MR"],
  " allow you to send arrays which are laid out in memory in the \
one\[Hyphen]dimensional way that C pre\[Hyphen]allocates them. But if you \
create arrays during the execution of a C program, it is more common to set \
them up as nested collections of pointers. You can send such arrays to ",
  StyleBox["Mathematica", "TI"],
  " by using a sequence of ",
  StyleBox["MLPutFunction()", "MR"],
  " calls, ending with an ",
  StyleBox["MLPutIntegerList()", "MR"],
  " call. "
}], "Text",
  CellTags->{"S2.13.4", "4.70"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.71"}],

Cell["...", "Program",
  CellTags->{"S2.13.4", "4.72"}],

Cell[TextData[{
  "This declares ",
  StyleBox["a", "MR"],
  " to be a nested list of lists of lists of integers. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.73"}],

Cell["int ***a;", "Program",
  CellTags->{"S2.13.4", "4.74"}],

Cell["...", "Program",
  CellTags->{"S2.13.4", "4.75"}],

Cell[TextData[{
  "This creates a ",
  StyleBox["Mathematica", "TI"],
  " list with ",
  StyleBox["n1", "MR"],
  " elements. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.76"}],

Cell["MLPutFunction(stdlink, \"List\", n1);", "Program",
  CellTags->{"S2.13.4", "4.77"}],

Cell["for (i=0; i<n1; i++) {", "Program",
  CellTags->{"S2.13.4", "4.78"}],

Cell[TextData[{
  "This creates a sublist with ",
  StyleBox["n2", "MR"],
  " elements. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.79"}],

Cell["    MLPutFunction(stdlink, \"List\", n2);", "Program",
  CellTags->{"S2.13.4", "4.80"}],

Cell["    for (j=0; j<n2; j++) {", "Program",
  CellTags->{"S2.13.4", "4.81"}],

Cell["This writes out lists of integers. ", "MathCaption",
  CellTags->{"S2.13.4", "4.82"}],

Cell["        MLPutIntegerList(stdlink, a[i][j], n3);", "Program",
  CellTags->{"S2.13.4", "4.83"}],

Cell["\<\
    }
}\
\>", "Program",
  CellTags->{"S2.13.4", "4.84"}],

Cell["...", "Program",
  CellTags->{"S2.13.4", "4.85"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.86"}],

Cell[TextData[{
  "It is important to realize that any expression you create using ",
  StyleBox["MathLink", "TI"],
  " functions will be evaluated as soon as it is sent to ",
  StyleBox["Mathematica", "TI"],
  ". This means, for example, that if you wanted to transpose an array that \
you were sending back to ",
  StyleBox["Mathematica", "TI"],
  ", all you would need to do is to wrap a ",
  StyleBox["Transpose", "MR"],
  " around the expression representing the array. You can then do this simply \
by calling ",
  StyleBox["MLPutFunction(stdlink,", "MR"],
  " ",
  StyleBox["\"Transpose\",", "MR"],
  " ",
  StyleBox["1);", "MR"],
  " just before you start creating the expression that represents the array. \
"
}], "Text",
  CellTags->{"S2.13.4", "4.87"}],

Cell[TextData[{
  "The idea of post\[Hyphen]processing data that you send back to ",
  StyleBox["Mathematica", "TI"],
  " has many uses. One example is as a way of sending lists whose length you \
do not know in advance.  "
}], "Text",
  CellTags->{"S2.13.4", "4.88"}],

Cell[TextData[{
  "This creates a list in ",
  StyleBox["Mathematica", "TI"],
  " by explicitly appending successive elements. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.89"}],

Cell[CellGroupData[{

Cell["t = {}; Do[t = Append[t, i^2], {i, 5}]; t", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \({1, 4, 9, 16, 25}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell["\<\
This creates a list in which each successive element is in a nested \
sublist. \
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.90"}],

Cell[CellGroupData[{

Cell["t = {}; Do[t = {t, i^2}, {i, 5}]; t", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \({{{{{{}, 1}, 4}, 9}, 16}, 25}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Flatten", "MR"],
  " flattens out the list. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.91"}],

Cell[CellGroupData[{

Cell["Flatten[t]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \({1, 4, 9, 16, 25}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Sequence", "MR"],
  " automatically flattens itself. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.92"}],

Cell[CellGroupData[{

Cell["{Sequence[1, Sequence[4, Sequence[ ]]]}", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \({1, 4}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  "In order to call ",
  StyleBox["MLPutIntegerList()", "MR"],
  ", you need to know the length of the list you want to send. But by \
creating a sequence of nested ",
  StyleBox["Sequence", "MR"],
  " objects, you can avoid having to know the length of your whole list in \
advance. "
}], "Text",
  CellTags->{"S2.13.4", "4.93"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.94"}],

Cell[TextData[{
  "This sets up the ",
  StyleBox["List", "MR"],
  " around your result. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.95"}],

Cell["MLPutFunction(stdlink, \"List\", 1);", "Program",
  CellTags->{"S2.13.4", "4.96"}],

Cell[TextData[{
  "while(",
  StyleBox[" condition", "MO"],
  " ) {\n    ",
  StyleBox[" generate an element", "MO"]
}], "Program",
  CellTags->{"S2.13.4", "4.97"}],

Cell[TextData[{
  "Create the next level ",
  StyleBox["Sequence", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.98"}],

Cell["    MLPutFunction(stdlink, \"Sequence\", 2);", "Program",
  CellTags->{"S2.13.4", "4.99"}],

Cell["Put the element. ", "MathCaption",
  CellTags->{"S2.13.4", "4.100"}],

Cell[TextData[{
  "    MLPutInteger(stdlink, ",
  StyleBox[" i", "MO"],
  " );"
}], "Program",
  CellTags->{"S2.13.4", "4.101"}],

Cell["}", "Program",
  CellTags->{"S2.13.4", "4.102"}],

Cell[TextData[{
  "This closes off your last ",
  StyleBox["Sequence", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.103"}],

Cell["MLPutFunction(stdlink, \"Sequence\", 0);", "Program",
  CellTags->{"S2.13.4", "4.104"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.105"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLGetInteger(stdlink,", "MR"],
              " ",
              StyleBox["int", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["i", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "get an integer, storing it at address ",
              StyleBox["i", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MLGetReal(stdlink,", "MR"],
              " ",
              StyleBox["double", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["x", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "get a floating\[Hyphen]point number, storing it at address ",
              StyleBox["x", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.4"],

Cell[TextData[{
  "Basic functions for explicitly getting data from ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.4"],

Cell[TextData[{
  "Just as ",
  StyleBox["MathLink", "TI"],
  " provides functions like ",
  StyleBox["MLPutInteger()", "MR"],
  " to send data from an external program into ",
  StyleBox["Mathematica", "TI"],
  ", so also ",
  StyleBox["MathLink", "TI"],
  " provides functions like ",
  StyleBox["MLGetInteger()", "MR"],
  " that allow you to get data from ",
  StyleBox["Mathematica", "TI"],
  " into an external program. "
}], "Text",
  CellTags->{"S2.13.4", "4.106"}],

Cell[TextData[{
  "The list that you give for ",
  StyleBox[":ArgumentTypes:", "MR"],
  " in a ",
  StyleBox["MathLink", "TI"],
  " template can end with ",
  StyleBox["Manual", "MR"],
  ", indicating that after other arguments have been received, you will call \
",
  StyleBox["MathLink", "TI"],
  " functions to get additional expressions. "
}], "Text",
  CellTags->{"S2.13.4", "4.107"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.108"}],

Cell["\<\
:Begin:
:Function:       f\
\>", "Program",
  CellTags->{"S2.13.4", "4.109"}],

Cell[TextData[{
  "The function ",
  StyleBox["f", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " takes 3 arguments. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.110"}],

Cell[":Pattern:        f[i_Integer, x_Real, y_Real]", "Program",
  CellTags->{"S2.13.4", "4.111"}],

Cell["\<\
All these arguments are passed directly to the external \
program.\
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.112"}],

Cell[TextData[{
  ":Arguments:      ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "i, x, y",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.4", "4.113"}],

Cell["\<\
Only the first argument is sent directly to the external function. \
\
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.114"}],

Cell[TextData[{
  ":ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Integer, Manual",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.4", "4.115"}],

Cell["\<\
:ReturnType:     Real
:End:
\
\>", "Program",
  CellTags->{"S2.13.4", "4.116"}],

Cell["The external function only takes one explicit argument. ", "MathCaption",
  CellTags->{"S2.13.4", "4.117"}],

Cell["\<\
double f(int i) {
\
\>", "Program",
  CellTags->{"S2.13.4", "4.118"}],

Cell[TextData[{
  "This declares the variables ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.119"}],

Cell["\<\
   double x, y;
\
\>", "Program",
  CellTags->{"S2.13.4", "4.120"}],

Cell[TextData[{
  StyleBox["MLGetReal()", "MR"],
  " explicitly gets data from the link. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.121"}],

Cell["\<\
   MLGetReal(stdlink, &x);
   MLGetReal(stdlink, &y);
\
\>", "Program",
  CellTags->{"S2.13.4", "4.122"}],

Cell["\<\
   return i+x+y;
}\
\>", "Program",
  CellTags->{"S2.13.4", "4.123"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.124"}],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " functions such as ",
  StyleBox["MLGetInteger(", "MR"],
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["pi", "TI"],
  StyleBox[")", "MR"],
  " work much like standard C library functions such as ",
  StyleBox["fscanf(", "MR"],
  StyleBox["fp", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["\"%d\",", "MR"],
  " ",
  StyleBox["pi", "TI"],
  StyleBox[")", "MR"],
  ". The first argument specifies the link from which to get data. The last \
argument gives the address at which the data that is obtained should be \
stored. "
}], "Text",
  CellTags->{"S2.13.4", "4.125"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLCheckFunction(stdlink,", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
check the head of a function and store how many \
arguments it has \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.4"],

Cell[TextData[{
  "Getting a function via ",
  StyleBox["MathLink", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.4"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.126"}],

Cell["\<\
:Begin:
:Function:       f\
\>", "Program",
  CellTags->{"S2.13.4", "4.127"}],

Cell[TextData[{
  "The function ",
  StyleBox["f", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " takes a list of integers as an argument. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.128"}],

Cell[TextData[{
  ":Pattern:        f[a:",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "___Integer",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "]"
}], "Program",
  CellTags->{"S2.13.4", "4.129"}],

Cell["The list is passed directly to the external program.", "MathCaption",
  CellTags->{"S2.13.4", "4.130"}],

Cell[TextData[{
  ":Arguments:      ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "a",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.4", "4.131"}],

Cell["\<\
The argument is to be retrieved manually by the external program. \
\
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.132"}],

Cell[TextData[{
  ":ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Manual",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.4", "4.133"}],

Cell["\<\
:ReturnType:     Integer
:End:
\
\>", "Program",
  CellTags->{"S2.13.4", "4.134"}],

Cell["The external function takes no explicit arguments. ", "MathCaption",
  CellTags->{"S2.13.4", "4.135"}],

Cell["\<\
int f(void) {
\
\>", "Program",
  CellTags->{"S2.13.4", "4.136"}],

Cell["This declares local variables. ", "MathCaption",
  CellTags->{"S2.13.4", "4.137"}],

Cell["\<\
    long n, i;
    int a[MAX];
\
\>", "Program",
  CellTags->{"S2.13.4", "4.138"}],

Cell[TextData[{
  "This checks that the function being sent is a list, and stores how many \
elements it has in ",
  StyleBox["n", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.139"}],

Cell["\<\
    MLCheckFunction(stdlink, \"List\", &n);
\
\>", "Program",
  CellTags->{"S2.13.4", "4.140"}],

Cell[TextData[{
  "This gets each element in the list, storing it in ",
  StyleBox["a[i]", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.4", "4.141"}],

Cell["\<\
   for (i=0; i<n; i++)
      MLGetInteger(stdlink, a+i);\
\>", "Program",
  CellTags->{"S2.13.4", "4.142"}],

Cell["\<\
...
}\
\>", "Program",
  CellTags->{"S2.13.4", "4.143"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.144"}],

Cell[TextData[{
  "In simple cases, it is usually possible to ensure on the ",
  StyleBox["Mathematica", "TI"],
  " side that the data you send to an external program has the structure that \
is expected. But in general the return value from ",
  StyleBox["MLCheckFunction()", "MR"],
  " will be non\[Hyphen]zero only if the data consists of a function with the \
name you specify. "
}], "Text",
  CellTags->{"S2.13.4", "4.145"}],

Cell[TextData[{
  "Note that if you want to get a nested collection of lists or other \
objects, you can do this by making an appropriate sequence of calls to ",
  StyleBox["MLCheckFunction()", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.4", "4.146"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLGetIntegerList(stdlink,", "MR"],
              " ",
              StyleBox["int", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
get a list of integers, allocating the memory needed to \
store\[NonBreakingSpace]it\
\>"]},
          {Cell[TextData[{
              StyleBox["MLGetRealList(stdlink,", "MR"],
              " ",
              StyleBox["double", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
get a list of floating\[Hyphen]point numbers \
\>"]},
          {Cell[TextData[{
              StyleBox["MLDisownIntegerList(stdlink,", "MR"],
              " ",
              StyleBox["int", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[
            "disown the memory associated with a list of integers "]},
          {Cell[TextData[{
              StyleBox["MLDisownRealList(stdlink,", "MR"],
              " ",
              StyleBox["double", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
disown the memory associated with a list of floating\
\[Hyphen]point numbers \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.4"],

Cell["Getting lists of numbers. ", "Caption",
  CellTags->"S2.13.4"],

Cell[TextData[{
  "When an external program gets data from ",
  StyleBox["Mathematica", "TI"],
  ", it must set up a place to store the data. If the data consists of a \
single integer, as in ",
  StyleBox["MLGetInteger(stdlink,", "MR"],
  " ",
  StyleBox["&", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  ", then it suffices just to have declared this integer using ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["n", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.4", "4.147"}],

Cell["\<\
But when the data consists of a list of integers of potentially any \
length, memory must be allocated to store this list at the time when the \
external program is actually called. \
\>", "Text",
  CellTags->{"S2.13.4", "4.148"}],

Cell[TextData[{
  StyleBox["MLGetIntegerList(stdlink,", "MR"],
  " ",
  StyleBox["&", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["&", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " will automatically do this allocation, setting ",
  StyleBox["a", "TI"],
  " to be a pointer to the result. Note that memory allocated by functions \
like ",
  StyleBox["MLGetIntegerList()", "MR"],
  " is always in a special reserved area, so you cannot modify or free it \
directly. "
}], "Text",
  CellTags->{"S2.13.4", "4.149"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.150"}],

Cell["\<\
Here is an external program that will be sent a list of integers. \
\
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.151"}],

Cell["\<\
int f(void) {
\
\>", "Program",
  CellTags->{"S2.13.4", "4.152"}],

Cell[TextData[{
  "This declares local variables. ",
  StyleBox["a", "MR"],
  " is an array of integers. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.153"}],

Cell["\<\
    long n;
    int *a;
\
\>", "Program",
  CellTags->{"S2.13.4", "4.154"}],

Cell[TextData[{
  "This gets a list of integers, making ",
  StyleBox["a", "MR"],
  " be a pointer to the result. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.155"}],

Cell["\<\
    MLGetIntegerList(stdlink, &a, &n);
\
\>", "Program",
  CellTags->{"S2.13.4", "4.156"}],

Cell["...", "Program",
  CellTags->{"S2.13.4", "4.157"}],

Cell["This disowns the memory used to store the list of integers. ", \
"MathCaption",
  CellTags->{"S2.13.4", "4.158"}],

Cell["    MLDisownIntegerList(stdlink, a, n);", "Program",
  CellTags->{"S2.13.4", "4.159"}],

Cell["\<\
...
}\
\>", "Program",
  CellTags->{"S2.13.4", "4.160"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.161"}],

Cell[TextData[{
  "If you use ",
  StyleBox["IntegerList", "MR"],
  " as an ",
  StyleBox[":ArgumentTypes:", "MR"],
  " specification, then ",
  StyleBox["MathLink", "TI"],
  " will automatically disown the memory used for the list after your \
external function exits. But if you get a list of integers explicitly using \
",
  StyleBox["MLGetIntegerList()", "MR"],
  ", then you must not forget to disown the memory used to store the list \
after you have finished with it. "
}], "Text",
  CellTags->{"S2.13.4", "4.162"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLGetIntegerArray(stdlink,", "MR"],
              " ",
              StyleBox["int", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["dims", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["***", "MR"],
              StyleBox["heads", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["d", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get an array of integers of any depth "]},
          {Cell[TextData[{
              StyleBox["MLGetRealArray(stdlink,", "MR"],
              " ",
              StyleBox["double", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["dims", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["***", "MR"],
              StyleBox["heads", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["d", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
get an array of floating\[Hyphen]point numbers of any \
depth \
\>"]},
          {Cell[TextData[{
              StyleBox["MLDisownIntegerArray(stdlink,", "MR"],
              " ",
              StyleBox["int", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["dims", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["heads", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["disown memory associated with an integer array "]},
          {Cell[TextData[{
              StyleBox["MLDisownRealArray(stdlink,", "MR"],
              " ",
              StyleBox["double", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["dims", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["heads", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
disown memory associated with a floating\[Hyphen]point \
array \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.4"],

Cell["Getting arrays of numbers. ", "Caption",
  CellTags->"S2.13.4"],

Cell[TextData[{
  StyleBox["MLGetIntegerList()", "MR"],
  " extracts a one\[Hyphen]dimensional array of integers from a single ",
  StyleBox["Mathematica", "TI"],
  " list. ",
  StyleBox["MLGetIntegerArray()", "MR"],
  " extracts an array of integers from a collection of lists or other ",
  StyleBox["Mathematica", "TI"],
  " functions nested to any depth. "
}], "Text",
  CellTags->{"S2.13.4", "4.163"}],

Cell[TextData[{
  "The name of the ",
  StyleBox["Mathematica", "TI"],
  " function at level ",
  StyleBox["i", "TI"],
  " in the structure is stored as a string in ",
  StyleBox["heads", "TI"],
  StyleBox["[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  ". The size of the structure at level ",
  StyleBox["i", "TI"],
  " is stored in ",
  StyleBox["dims", "TI"],
  StyleBox["[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  ", while the total depth is stored in ",
  StyleBox["d", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.13.4", "4.164"}],

Cell[TextData[{
  "If you pass a list of complex numbers to your external program, then ",
  StyleBox["MLGetRealArray()", "MR"],
  " will create a two\[Hyphen]dimensional array containing a sequence of \
pairs of real and imaginary parts. In this case, ",
  StyleBox["heads", "TI"],
  StyleBox["[0]", "MR"],
  " will be ",
  StyleBox["\"List\"", "MR"],
  " while ",
  StyleBox["heads", "TI"],
  StyleBox["[1]", "MR"],
  " will be ",
  StyleBox["\"Complex\"", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.4", "4.165"}],

Cell[TextData[{
  "Note that you can conveniently exchange arbitrary\[Hyphen]precision \
numbers with external programs by converting them to lists of digits in ",
  StyleBox["Mathematica", "TI"],
  " using ",
  StyleBox["IntegerDigits", "MR"],
  " and ",
  StyleBox["RealDigits", "MR"],
  ".   "
}], "Text",
  CellTags->{"S2.13.4", "4.166"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLGetString(stdlink,", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get a character string "]},
          {Cell[TextData[{
              StyleBox["MLGetSymbol(stdlink,", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get a symbol name "]},
          {Cell[TextData[{
              StyleBox["MLDisownString(stdlink,", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["disown memory associated with a character string "]},
          {Cell[TextData[{
              StyleBox["MLDisownSymbol(stdlink,", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["disown memory associated with a symbol name "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.4"],

Cell["Getting character strings and symbol names. ", "Caption",
  CellTags->"S2.13.4"],

Cell[TextData[{
  "If you use ",
  StyleBox["String", "MR"],
  " as an ",
  StyleBox[":ArgumentTypes:", "MR"],
  " specification, then ",
  StyleBox["MathLink", "TI"],
  " will automatically disown the memory that is used to store the string \
after your function exits. This means that if you want to continue to refer \
to the string, you must allocate memory for it, and explicitly copy each \
character in it. "
}], "Text",
  CellTags->{"S2.13.4", "4.167"}],

Cell[TextData[{
  "If you get a string using ",
  StyleBox["MLGetString()", "MR"],
  ", however, then ",
  StyleBox["MathLink", "TI"],
  " will not automatically disown the memory used for the string when your \
function exits. As a result, you can continue referring to the string. When \
you no longer need the string, you must nevertheless explicitly call ",
  StyleBox["MLDisownString()", "MR"],
  " in order to disown the memory associated with it. "
}], "Text",
  CellTags->{"S2.13.4", "4.168"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLGetFunction(stdlink,", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "begin getting a function, storing the name of the head in ",
              StyleBox["s", "TI"],
              " and the number of arguments in ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MLDisownSymbol(stdlink,", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["disown memory associated with a function name "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->True},
  CellTags->"S2.13.4"],

Cell["Getting an arbitrary function. ", "Caption",
  CellTags->"S2.13.4"],

Cell[TextData[{
  "If you know what function to expect in your external program, then it is \
usually simpler to call ",
  StyleBox["MLCheckFunction()", "MR"],
  ". But if you do not know what function to expect, you have no choice but \
to call ",
  StyleBox["MLGetFunction()", "MR"],
  ". If you do this, you need to be sure to call ",
  StyleBox["MLDisownSymbol()", "MR"],
  " to disown the memory associated with the name of the function that is \
found by ",
  StyleBox["MLGetFunction()", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.4", "4.169"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.5 Special Topic: Portability of ",
  StyleBox["MathLink", "SBO"],
  " Programs"
}], "Subsection",
  CellTags->{"S2.13.5", "5.1"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " side of a ",
  StyleBox["MathLink", "TI"],
  " connection is set up to work exactly the same on all computer systems. \
But inevitably there are differences between external programs on different \
computer systems."
}], "Text",
  CellTags->{"S2.13.5", "5.2"}],

Cell[TextData[{
  "For a start, different computer systems almost always require different \
executable binaries. When you call ",
  StyleBox["Install[\"", "MR"],
  StyleBox["prog", "TI"],
  StyleBox["\"]", "MR"],
  ", therefore, you must be sure that ",
  StyleBox["prog", "TI"],
  " corresponds to a program that can be executed on your particular computer \
system.  "
}], "Text",
  CellTags->{"S2.13.5", "5.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Install[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to execute ",
              StyleBox["file", "TI"],
              " directly "
            }]]},
          {Cell[TextData[{
              StyleBox["Install[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["LinkProtocol->\"", "MR"],
              StyleBox["type", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
use the specified protocol for low\[Hyphen]level data \
transport \
\>"]},
          {Cell[TextData[{
              StyleBox["$SystemID", "MR"],
              " "
            }]], Cell["identify the type of computer system being used "]},
          {Cell[TextData[{
              StyleBox["Install[\"", "MR"],
              StyleBox["dir", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to execute a file with a name of the form ",
              StyleBox["dir", "TI"],
              StyleBox["/$SystemID/", "MR"],
              StyleBox["dir", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.5"],

Cell["Installing programs on different computer systems.", "Caption",
  CellTags->"S2.13.5"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " follows the convention that if ",
  StyleBox["prog", "TI"],
  " is an ordinary file, then ",
  StyleBox["Install[\"", "MR"],
  StyleBox["prog", "TI"],
  StyleBox["\"]", "MR"],
  " will just try to execute it. But if ",
  StyleBox["prog", "TI"],
  " is a directory, then ",
  StyleBox["Mathematica", "TI"],
  " will look for a subdirectory of that directory whose name agrees with the \
current value of ",
  StyleBox["$SystemID", "MR"],
  ", and will then try to execute a file named ",
  StyleBox["prog", "TI"],
  " within that subdirectory. "
}], "Text",
  CellTags->{"S2.13.5", "5.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["mcc", "MR"],
              " ",
              StyleBox["-o", "MR"],
              " ",
              StyleBox["prog", "TI"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]], Cell[TextData[{
              "put compiled code in the file ",
              StyleBox["prog", "TI"],
              " in the current directory "
            }]]},
          {Cell[TextData[{
              StyleBox["mcc", "MR"],
              " ",
              StyleBox["-xo", "MR"],
              " ",
              StyleBox["prog", "TI"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]], Cell[TextData[{
              "put compiled code in ",
              StyleBox["prog", "TI"],
              StyleBox["/$SystemID/", "MR"],
              StyleBox["prog", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.5"],

Cell["Typical Unix commands for compiling external programs. ", "Caption",
  CellTags->"S2.13.5"],

Cell["\<\
Even though the executable binary of an external program is \
inevitably different on different computer systems, it can still be the case \
that the source code in a language such as C from which this binary is \
obtained can be essentially the same.  \
\>", "Text",
  CellTags->{"S2.13.5", "5.5"}],

Cell["\<\
But to achieve portability in your C source code there are several \
points that you need to watch. \
\>", "Text",
  CellTags->{"S2.13.5", "5.6"}],

Cell["\<\
For a start, you should never make use of extra features of the C \
language or C run\[Hyphen]time libraries that happen to be provided on a \
particular system, but are not part of standard C. In addition, you should \
try to avoid dealing with segmented or otherwise special memory models. \
\
\>", "Text",
  CellTags->{"S2.13.5", "5.7"}],

Cell[TextData[{
  "The include file ",
  StyleBox["mathlink.h", "MR"],
  " contains standard C prototypes for all the functions in the ",
  StyleBox["MathLink", "TI"],
  " library. If your compiler does not support such prototypes, you can \
ignore them by giving the directive ",
  StyleBox["#define", "MR"],
  " ",
  StyleBox["MLPROTOTYPES", "MR"],
  " ",
  StyleBox["0", "MR"],
  " before ",
  StyleBox["#include", "MR"],
  " ",
  StyleBox["\"mathlink.h\"", "MR"],
  ". But assuming that it does support prototypes, your compiler will always \
be able to check that the calls you make to functions in the ",
  StyleBox["MathLink", "TI"],
  " library have arguments of appropriate types.  "
}], "Text",
  CellTags->{"S2.13.5", "5.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLPutInteger()", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MLGetInteger()", "MR"],
              " "
            }]], Cell[TextData[{
              "default integer of type ",
              StyleBox["int", "MR"],
              "; sometimes 16 bits, sometimes 32 bits "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutShortInteger()", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MLGetShortInteger()", "MR"],
              " "
            }]], Cell[TextData[{
              "short integer of type ",
              StyleBox["short", "MR"],
              "; usually 16 bits "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutLongInteger()", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MLGetLongInteger()", "MR"],
              " "
            }]], Cell[TextData[{
              "long integer of type ",
              StyleBox["long", "MR"],
              "; usually 32 bits "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutReal()", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MLGetReal()", "MR"],
              " "
            }]], Cell[TextData[{
              "default real number of type ",
              StyleBox["double", "MR"],
              "; usually at least 64 bits "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutFloat()", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MLGetFloat()", "MR"],
              " "
            }]], Cell[TextData[{
              
              "single\[Hyphen]precision floating\[Hyphen]point number of type \
",
              StyleBox["float", "MR"],
              "; often 32 bits "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutDouble()", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MLGetDouble()", "MR"],
              " "
            }]], Cell[TextData[{
              
              "double\[Hyphen]precision floating\[Hyphen]point number of type \
",
              StyleBox["double", "MR"],
              "; usually at least 64 bits "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False}},
  CellTags->"S2.13.5"],

Cell[TextData[{
  StyleBox["MathLink", "SO"],
  " functions that use specific C types. "
}], "Caption",
  CellTags->"S2.13.5"],

Cell[TextData[{
  "On some computer systems and with some compilers, a C language ",
  StyleBox["int", "MR"],
  " may be equivalent to a ",
  StyleBox["long", "MR"],
  ". But the standard for the C language equally well allows ",
  StyleBox["int", "MR"],
  " to be equivalent to ",
  StyleBox["short", "MR"],
  ". And if you are going to call ",
  StyleBox["MathLink", "TI"],
  " library functions in a portable way, it is essential that you use the \
same types as they do. "
}], "Text",
  CellTags->{"S2.13.5", "5.9"}],

Cell[TextData[{
  "Once you have passed your data into the ",
  StyleBox["MathLink", "TI"],
  " library functions, these functions then take care of all further issues \
associated with differences between data representations on different \
computer systems. Thus, for example, ",
  StyleBox["MathLink", "TI"],
  " automatically swaps bytes when it sends data between big and little \
endian machines, and converts floating\[Hyphen]point formats losing as little \
precision as possible. "
}], "Text",
  CellTags->{"S2.13.5", "5.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLPutString(stdlink,", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a string without special characters "]},
          {Cell[TextData[{
              StyleBox["MLPutUnicodeString(stdlink,", "MR"],
              " ",
              StyleBox["unsigned", "MR"],
              " ",
              StyleBox["short", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
put a string encoded in terms of 16\[Hyphen]bit Unicode \
characters \
\>"]},
          {Cell[TextData[{
              StyleBox["MLPutByteString(stdlink,", "MR"],
              " ",
              StyleBox["unsigned", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
put a string containing only 8\[Hyphen]bit character \
codes \
\>"]},
          {Cell[TextData[{
              StyleBox["MLGetString(stdlink,", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get a string without special characters "]},
          {Cell[TextData[{
              StyleBox["MLGetUnicodeString(stdlink,", "MR"],
              " ",
              StyleBox["unsigned", "MR"],
              " ",
              StyleBox["short", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
get a string encoded in terms of 16\[Hyphen]bit Unicode \
characters \
\>"]},
          {Cell[TextData[{
              StyleBox["MLGetByteString(stdlink,", "MR"],
              " ",
              StyleBox["unsigned", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["spec", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              
              "get a string containing only 8\[Hyphen]bit character codes, \
using ",
              StyleBox["spec", "TI"],
              " as the code for all 16\[Hyphen]bit characters "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False}},
  CellTags->"S2.13.5"],

Cell["Manipulating general strings. ", "Caption",
  CellTags->"S2.13.5"],

Cell[TextData[{
  "In simple C programs, it is typical to use strings that contain only \
ordinary ASCII characters. But in ",
  StyleBox["Mathematica", "TI"],
  " it is possible to have strings containing all sorts of special \
characters. These characters are specified within ",
  StyleBox["Mathematica", "TI"],
  " using Unicode character codes, as discussed in \
Section\[NonBreakingSpace]",
  ButtonBox["2.8.9",
    ButtonData:>{"2.8.9", "9.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Text",
  CellTags->{"S2.13.5", "5.11"}],

Cell[TextData[{
  "C language ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  " strings typically use only 8 bits to store the code for each character. \
Unicode character codes, however, require 16 bits. As a result, the functions \
",
  StyleBox["MLPutUnicodeString()", "MR"],
  " and ",
  StyleBox["MLGetUnicodeString()", "MR"],
  " work with arrays of ",
  StyleBox["unsigned", "MR"],
  " ",
  StyleBox["short", "MR"],
  " integers.  "
}], "Text",
  CellTags->{"S2.13.5", "5.12"}],

Cell[TextData[{
  "If you know that your program will not have to handle special characters, \
then you may find it convenient to use ",
  StyleBox["MLPutByteString()", "MR"],
  " and ",
  StyleBox["MLGetByteString()", "MR"],
  ". These functions represent all characters directly using 8\[Hyphen]bit \
character codes. If a special character is sent from ",
  StyleBox["Mathematica", "TI"],
  ", then it will be converted by ",
  StyleBox["MLGetByteString()", "MR"],
  " to a fixed code that you specify. "
}], "Text",
  CellTags->{"S2.13.5", "5.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["main()", "MR"],
              " may need to be different on different computer systems "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.5"],

Cell[TextData[{
  "A point to watch in creating portable ",
  StyleBox["MathLink", "SO"],
  " programs. "
}], "Caption",
  CellTags->"S2.13.5"],

Cell[TextData[{
  "Computer systems and compilers that have C run\[Hyphen]time libraries \
based on the Unix model allow ",
  StyleBox["MathLink", "TI"],
  " programs to have a main program of the form ",
  StyleBox["main(argc,", "MR"],
  " ",
  StyleBox["argv)", "MR"],
  " which simply calls ",
  StyleBox["MLMain(argc,", "MR"],
  " ",
  StyleBox["argv)", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.5", "5.14"}],

Cell[TextData[{
  "Some computer systems or compilers may however require main programs of a \
different form. You should realize that you can do whatever initialization \
you want inside ",
  StyleBox["main()", "MR"],
  " before calling ",
  StyleBox["MLMain()", "MR"],
  ". Once you have called ",
  StyleBox["MLMain()", "MR"],
  ", however, your program will effectively go into an infinite loop, \
responding to requests from ",
  StyleBox["Mathematica", "TI"],
  " until the link to it is closed. "
}], "Text",
  CellTags->{"S2.13.5", "5.15"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.6 Using ",
  StyleBox["MathLink", "SBO"],
  " to Communicate between ",
  StyleBox["Mathematica", "SBO"],
  " Sessions"
}], "Subsection",
  CellTags->{"S2.13.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LinkCreate[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["create a link for another program to connect to "]},
          {Cell[TextData[{
              StyleBox["LinkConnect[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["connect to a link created by another program "]},
          {Cell[TextData[{
              StyleBox["LinkClose[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "close a ",
              StyleBox["MathLink", "TI"],
              " connection "
            }]]},
          {Cell[TextData[{
              StyleBox["LinkWrite[", "MR"],
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "write an expression to a ",
              StyleBox["MathLink", "TI"],
              " connection "
            }]]},
          {Cell[TextData[{
              StyleBox["LinkRead[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "read an expression from a ",
              StyleBox["MathLink", "TI"],
              " connection "
            }]]},
          {Cell[TextData[{
              StyleBox["LinkRead[", "MR"],
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Hold]", "MR"],
              " "
            }]], Cell[TextData[{
              "read an expression and immediately wrap it with ",
              StyleBox["Hold", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LinkReadyQ[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "find out whether there is data ready to be read from a link "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False, False, True}},
  CellTags->"S2.13.6"],

Cell[TextData[{
  StyleBox["MathLink", "SO"],
  " connections between ",
  StyleBox["Mathematica", "SO"],
  " sessions. "
}], "Caption",
  CellTags->"S2.13.6"],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.6", "6.2"}],

Cell["This starts up a link on port number 8000. ", "MathCaption",
  CellTags->{"S2.13.6", "6.3"}],

Cell[CellGroupData[{

Cell["link = LinkCreate[\"8000\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.13.6"],

Cell["LinkObject[8000@frog.wolfram.com, 4, 4]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell["Session B", "SessionLabel",
  CellTags->{"S2.13.6", "6.4"}],

Cell["This connects to the link on port 8000. ", "MathCaption",
  CellTags->{"S2.13.6", "6.5"}],

Cell[CellGroupData[{

Cell["Link = LinkConnect[\"8000\"]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"S2.13.6"],

Cell["LinkObject[\"8000@frog.wolfram.com\", 4, 4]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.6", "6.6"}],

Cell[TextData[{
  "This evaluates ",
  StyleBox["15!", "MR"],
  " and writes it to the link. "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.7"}],

Cell["LinkWrite[link, 15!]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"S2.13.6"],

Cell["Session B", "SessionLabel",
  CellTags->{"S2.13.6", "6.8"}],

Cell[TextData[{
  "This reads from the link, getting the ",
  StyleBox["15!", "MR"],
  " that was sent. "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.9"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"S2.13.6"],

Cell["1307674368000", "Output",
  CellLabel->"Out[2]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell["This writes data back on the link. ", "MathCaption",
  CellTags->{"S2.13.6", "6.10"}],

Cell["LinkWrite[link, N[%^6]]", "Input",
  CellLabel->"In[3]:=",
  CellTags->"S2.13.6"],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.6", "6.11"}],

Cell["And this reads the data written in session B. ", "MathCaption",
  CellTags->{"S2.13.6", "6.12"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[3]:=",
  CellTags->"S2.13.6"],

Cell[BoxData[
    \(5.000318485342659`*^72\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell[TextData[{
  "One use of ",
  StyleBox["MathLink", "TI"],
  " connections between ",
  StyleBox["Mathematica", "TI"],
  " sessions is simply as a way to transfer data without using intermediate \
files. "
}], "Text",
  CellTags->{"S2.13.6", "6.13"}],

Cell["\<\
Another use is as a way to dispatch different parts of a \
computation to different sessions. \
\>", "Text",
  CellTags->{"S2.13.6", "6.14"}],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.6", "6.15"}],

Cell[TextData[{
  "This writes the expression ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2", "MR"],
  " without evaluating it. "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.16"}],

Cell["LinkWrite[link, Unevaluated[2 + 2]]", "Input",
  CellLabel->"In[4]:=",
  CellTags->"S2.13.6"],

Cell["Session B", "SessionLabel",
  CellTags->{"S2.13.6", "6.17"}],

Cell[TextData[{
  "This reads the expression from the link, immediately wrapping it in ",
  StyleBox["Hold", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.18"}],

Cell[CellGroupData[{

Cell["LinkRead[link, Hold]", "Input",
  CellLabel->"In[4]:=",
  CellTags->"S2.13.6"],

Cell["Hold[2 + 2]", "Output",
  CellLabel->"Out[4]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell["This evaluates the expression. ", "MathCaption",
  CellTags->{"S2.13.6", "6.19"}],

Cell[CellGroupData[{

Cell["ReleaseHold[%]", "Input",
  CellLabel->"In[5]:=",
  CellTags->"S2.13.6"],

Cell["4", "Output",
  CellLabel->"Out[5]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell[TextData[{
  "When you call ",
  StyleBox["LinkWrite", "MR"],
  ", it writes an expression to the ",
  StyleBox["MathLink", "TI"],
  " connection and immediately returns. But when you call ",
  StyleBox["LinkRead", "MR"],
  ", it will not return until it has read a complete expression from the ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Text",
  CellTags->{"S2.13.6", "6.20"}],

Cell[TextData[{
  "You can tell whether anything is ready to be read by calling ",
  StyleBox["LinkReadyQ[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  ". If ",
  StyleBox["LinkReadyQ", "MR"],
  " returns ",
  StyleBox["True", "MR"],
  ", then you can safely call ",
  StyleBox["LinkRead", "MR"],
  " and expect immediately to start reading an expression. But if ",
  StyleBox["LinkReadyQ", "MR"],
  " returns ",
  StyleBox["False", "MR"],
  ", then ",
  StyleBox["LinkRead", "MR"],
  " would block until an expression for it to read had been written by a ",
  StyleBox["LinkWrite", "MR"],
  " in your other ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Text",
  CellTags->{"S2.13.6", "6.21"}],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.6", "6.22"}],

Cell[TextData[{
  "There is nothing waiting to be read on the link, so if ",
  StyleBox["LinkRead", "MR"],
  " were to be called, it would block. "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.23"}],

Cell[CellGroupData[{

Cell["LinkReadyQ[link]", "Input",
  CellLabel->"In[5]:=",
  CellTags->"S2.13.6"],

Cell["False", "Output",
  CellLabel->"Out[5]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell["Session B", "SessionLabel",
  CellTags->{"S2.13.6", "6.24"}],

Cell["This writes an expression to the link. ", "MathCaption",
  CellTags->{"S2.13.6", "6.25"}],

Cell["LinkWrite[link, x + y]", "Input",
  CellLabel->"In[6]:=",
  CellTags->"S2.13.6"],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.6", "6.26"}],

Cell["Now there is an expression waiting to be read on the link. ", \
"MathCaption",
  CellTags->{"S2.13.6", "6.27"}],

Cell[CellGroupData[{

Cell["LinkReadyQ[link]", "Input",
  CellLabel->"In[6]:=",
  CellTags->"S2.13.6"],

Cell["True", "Output",
  CellLabel->"Out[6]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["LinkRead", "MR"],
  " can thus be called without fear of blocking. "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.28"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[7]:=",
  CellTags->"S2.13.6"],

Cell["x + y", "Output",
  CellLabel->"Out[7]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LinkCreate[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["pick any unused port on your computer "]},
          {Cell[TextData[{
              StyleBox["LinkCreate[\"", "MR"],
              StyleBox["number", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["use a specific port "]},
          {Cell[TextData[{
              StyleBox["LinkConnect[\"", "MR"],
              StyleBox["number", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["connect to a port on the same computer "]},
          {Cell[TextData[{
              StyleBox["LinkConnect[\"", "MR"],
              StyleBox["number", "TI"],
              StyleBox["@", "MR"],
              StyleBox["host", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["connect a port on another computer "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.6"],

Cell[TextData[{
  "Ways to set up ",
  StyleBox["MathLink", "SO"],
  " links. "
}], "Caption",
  CellTags->"S2.13.6"],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " can use whatever mechanism for interprogram communication your computer \
system supports. In setting up connections between concurrent ",
  StyleBox["Mathematica", "TI"],
  " sessions, the most common mechanism is internet TCP ports.  "
}], "Text",
  CellTags->{"S2.13.6", "6.29"}],

Cell["\<\
Most computer systems have a few thousand possible numbered ports, \
some of which are typically allocated to standard system services. \
\>", \
"Text",
  CellTags->{"S2.13.6", "6.30"}],

Cell[TextData[{
  "You can use any of the unallocated ports for ",
  StyleBox["MathLink", "TI"],
  " connections. "
}], "Text",
  CellTags->{"S2.13.6", "6.31"}],

Cell[TextData[{
  "Session on ",
  StyleBox["frog.wolfram.com", "MR"]
}], "SessionLabel",
  CellTags->{"S2.13.6", "6.32"}],

Cell[TextData[{
  "This finds an unallocated port on ",
  StyleBox["frog.wolfram.com", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.33"}],

Cell[CellGroupData[{

Cell["link = LinkCreate[ ]", "Input",
  CellLabel->"In[8]:=",
  CellTags->"S2.13.6"],

Cell["LinkObject[\"2981@frog.wolfram.com\", 5, 5]", "Output",
  CellLabel->"Out[8]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell[TextData[{
  "Session on ",
  StyleBox["toad.wolfram.com", "MR"]
}], "SessionLabel",
  CellTags->{"S2.13.6", "6.34"}],

Cell[TextData[{
  "This connects to the port on ",
  StyleBox["frog.wolfram.com", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.35"}],

Cell[CellGroupData[{

Cell["link = LinkConnect[\"2981@frog.wolfram.com\"]", "Input",
  CellLabel->"In[7]:=",
  CellTags->"S2.13.6"],

Cell["LinkObject[\"2981@frog.wolfram.com\", 5, 5]", "Output",
  CellLabel->"Out[7]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell["This sends the current machine name over the link. ", "MathCaption",
  CellTags->{"S2.13.6", "6.36"}],

Cell["LinkWrite[link, $MachineName]", "Input",
  CellLabel->"In[8]:=",
  CellTags->"S2.13.6"],

Cell[TextData[{
  "Session on ",
  StyleBox["frog.wolfram.com", "MR"]
}], "SessionLabel",
  CellTags->{"S2.13.6", "6.37"}],

Cell[TextData[{
  "This reads the expression written on ",
  StyleBox["toad", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.38"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[9]:=",
  CellTags->"S2.13.6"],

Cell["toad", "Output",
  CellLabel->"Out[9]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell[TextData[{
  "By using internet ports for ",
  StyleBox["MathLink", "TI"],
  " connections, you can easily transfer data between ",
  StyleBox["Mathematica", "TI"],
  " sessions on different machines. All that is needed is that an internet \
connection exists between the machines. "
}], "Text",
  CellTags->{"S2.13.6", "6.39"}],

Cell[TextData[{
  "Note that because ",
  StyleBox["MathLink", "TI"],
  " is completely system independent, the computers at each end of a ",
  StyleBox["MathLink", "TI"],
  " connection do not have to be of the same type. ",
  StyleBox["MathLink", "TI"],
  " nevertheless notices when they are, and optimizes data transmission in \
this case. "
}], "Text",
  CellTags->{"S2.13.6", "6.40"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.7 Calling Subsidiary ",
  StyleBox["Mathematica", "SBO"],
  " Processes"
}], "Subsection",
  CellTags->{"S2.13.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LinkLaunch[\"", "MR"],
              StyleBox["prog", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[
            "start an external program and open a connection to it "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Connecting to a subsidiary program via ",
  StyleBox["MathLink", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "This starts a subsidiary ",
  StyleBox["Mathematica", "TI"],
  " process on the computer system used here. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.2"}],

Cell[CellGroupData[{

Cell["link = LinkLaunch[\"math -mathlink\"]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"S2.13.7"],

Cell["LinkObject[math -mathlink, 4, 4]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "Here is a packet representing the first input prompt from the subsidiary \
",
  StyleBox["Mathematica", "TI"],
  " process. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.3"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.13.7"],

Cell["InputNamePacket[In[1]:= ]", "Output",
  CellLabel->"Out[2]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "This writes a packet representing text to enter in the subsidiary ",
  StyleBox["Mathematica", "TI"],
  " process. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.4"}],

Cell["LinkWrite[link, EnterTextPacket[\"10!\"]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Here is a packet representing the output prompt from the subsidiary ",
  StyleBox["Mathematica", "TI"],
  " process. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.5"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.13.7"],

Cell["OutputNamePacket[Out[1]= ]", "Output",
  CellLabel->"Out[4]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell["And here is the actual result from the computation. ", "MathCaption",
  CellTags->{"S2.13.7", "7.6"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.13.7"],

Cell["ReturnTextPacket[3628800]", "Output",
  CellLabel->"Out[5]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "The basic way that the various different objects involved in a ",
  StyleBox["Mathematica", "TI"],
  " session are kept organized is by using ",
  StyleBox["MathLink", "TI"],
  " ",
  StyleBox["packets", "TI"],
  ". A ",
  StyleBox["MathLink", "TI"],
  " packet is simply an expression with a definite head that indicates its \
role or meaning.  "
}], "Text",
  CellTags->{"S2.13.7", "7.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["EnterTextPacket[\"", "MR"],
              StyleBox["input", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["text to enter corresponding to an input line "]},
          {Cell[TextData[{
              StyleBox["ReturnTextPacket[\"", "MR"],
              StyleBox["output", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["text returned corresponding to an output line "]},
          {Cell[TextData[{
              StyleBox["InputNamePacket[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["text returned for the name of an input line "]},
          {Cell[TextData[{
              StyleBox["OutputNamePacket[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["text returned for the name of an output line "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Basic packets used in ",
  StyleBox["Mathematica", "SO"],
  " sessions. "
}], "Caption",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "The fact that ",
  StyleBox["LinkRead", "MR"],
  " returns an ",
  StyleBox["InputNamePacket", "MR"],
  " indicates that the subsidiary ",
  StyleBox["Mathematica", "TI"],
  " is now ready for new input. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.8"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.13.7"],

Cell["InputNamePacket[In[2]:= ]", "Output",
  CellLabel->"Out[6]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "This enters two ",
  StyleBox["Print", "MR"],
  " commands as input. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.9"}],

Cell["LinkWrite[link, EnterTextPacket[\"Print[a]; Print[b];\"]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Here is the text from the first ",
  StyleBox["Print", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.10"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.13.7"],

Cell["\<\
TextPacket[a
]\
\>", "Output",
  CellLabel->"Out[8]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "And here is the text from the second ",
  StyleBox["Print", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.11"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.13.7"],

Cell["\<\
TextPacket[b
]\
\>", "Output",
  CellLabel->"Out[9]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "No output line is generated, so the new packet is an ",
  StyleBox["InputNamePacket", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.12"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.13.7"],

Cell["InputNamePacket[In[3]:= ]", "Output",
  CellLabel->"Out[10]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["TextPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "text from ",
              StyleBox["Print", "MR"],
              " etc. "
            }]]},
          {Cell[TextData[{
              StyleBox["MessagePacket[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["tag", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["a message name "]},
          {Cell[TextData[{
              StyleBox["DisplayPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["parts of PostScript graphics "]},
          {Cell[TextData[{
              StyleBox["DisplayEndPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["the end of PostScript graphics "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Some additional packets generated in ",
  StyleBox["Mathematica", "SO"],
  " sessions. "
}], "Caption",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "If you enter input to ",
  StyleBox["Mathematica", "TI"],
  " using ",
  StyleBox["EnterTextPacket[\"", "MR"],
  StyleBox["input", "TI"],
  StyleBox["\"]", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " will automatically generate a string version of your output, and will \
respond with ",
  StyleBox["ReturnTextPacket[\"", "MR"],
  StyleBox["output", "TI"],
  StyleBox["\"]", "MR"],
  ". But if you instead enter input using ",
  StyleBox["EnterExpressionPacket[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " then ",
  StyleBox["Mathematica", "TI"],
  " will respond with ",
  StyleBox["ReturnExpressionPacket[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " and will not turn your output into a string. "
}], "Text",
  CellTags->{"S2.13.7", "7.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["EnterExpressionPacket[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "an expression to enter corresponding to an input line "]},
          {Cell[TextData[{
              StyleBox["ReturnExpressionPacket[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "an expression returned corresponding to an output line "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.7"],

Cell["\<\
Packets for representing input and output lines using expressions. \
\
\>", "Caption",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "This enters an expression into the subsidiary ",
  StyleBox["Mathematica", "TI"],
  " session without evaluating it. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.14"}],

Cell["\<\
LinkWrite[link, Unevaluated[EnterExpressionPacket[ Factor[x^6 - \
1]]]]\
\>", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Here are the next 3 packets that come back from the subsidiary ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.15"}],

Cell[CellGroupData[{

Cell["Table[LinkRead[link], {3}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.13.7"],

Cell[BoxData[
    \({OutputNamePacket["Out[3]="], 
      ReturnExpressionPacket[\((\(-1\) + x)\)\ \((1 + x)\)\ \((1 - x - 
              x\^2)\)\ \((1 + x + x\^2)\)], 
      InputNamePacket["In[4]:="]}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["InputNamePacket", "MR"],
  " and ",
  StyleBox["OutputNamePacket", "MR"],
  " packets are often convenient for making it possible totell the current \
state of a subsidiary ",
  StyleBox["Mathematica", "TI"],
  " session. But you can suppress the generation of these packets by calling \
the subsidiary ",
  StyleBox["Mathematica", "TI"],
  " session with a string such as ",
  StyleBox["\"math", "MR"],
  " ",
  StyleBox["-mathlink", "MR"],
  " ",
  StyleBox["-batchoutput\"", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.7", "7.16"}],

Cell[TextData[{
  "Even if you suppress the explicit generation of ",
  StyleBox["InputNamePacket", "MR"],
  " and ",
  StyleBox["OutputNamePacket", "MR"],
  " packets, ",
  StyleBox["Mathematica", "TI"],
  " will still process any input that you give with ",
  StyleBox["EnterTextPacket", "MR"],
  " or ",
  StyleBox["EnterExpressionPacket", "MR"],
  " as if you were entering an input line. This means for example that ",
  StyleBox["Mathematica", "TI"],
  " will call ",
  StyleBox["$Pre", "MR"],
  " and ",
  StyleBox["$Post", "MR"],
  ", and will assign values to ",
  StyleBox["In[$Line]", "MR"],
  " and ",
  StyleBox["Out[$Line]", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.13.7", "7.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["EvaluatePacket[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["an expression to be sent purely for evaluation "]},
          {Cell[TextData[{
              StyleBox["ReturnPacket[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["an expression returned from an evaluation "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.7"],

Cell["\<\
Evaluating expressions without explicit input and output lines. \
\
\>", "Caption",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "This sends an ",
  StyleBox["EvaluatePacket", "MR"],
  ". The ",
  StyleBox["Unevaluated", "MR"],
  " prevents evaluation before the packet is sent. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.18"}],

Cell["LinkWrite[link, Unevaluated[EvaluatePacket[10!]]]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "The result is a pure ",
  StyleBox["ReturnPacket", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.19"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.13.7"],

Cell[BoxData[
    \(ReturnPacket[3628800]\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "This sends an ",
  StyleBox["EvaluatePacket", "MR"],
  " requesting evaluation of ",
  StyleBox["Print[x]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.20"}],

Cell["LinkWrite[link, Unevaluated[EvaluatePacket[Print[x]]]]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "The first packet to come back is a ",
  StyleBox["TextPacket", "MR"],
  " representing text generated by the ",
  StyleBox["Print", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.21"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.13.7"],

Cell["\<\
TextPacket[x
]\
\>", "Output",
  CellLabel->"Out[16]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "After that, the actual result of the ",
  StyleBox["Print", "MR"],
  " is returned. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.22"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.13.7"],

Cell["ReturnPacket[Null]", "Output",
  CellLabel->"Out[17]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "In most cases, it is reasonable to assume that sending an ",
  StyleBox["EvaluatePacket", "MR"],
  " to ",
  StyleBox["Mathematica", "TI"],
  " will simply cause ",
  StyleBox["Mathematica", "TI"],
  " to do a computation and to return various other packets, ending with a ",
  StyleBox["ReturnPacket", "MR"],
  ". However, if the computation involves a function like ",
  StyleBox["Input", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " will have to request additional input before it can proceed with the \
computation. "
}], "Text",
  CellTags->{"S2.13.7", "7.23"}],

Cell[TextData[{
  "This sends a packet whose evaluation involves an ",
  StyleBox["Input", "MR"],
  " function. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.24"}],

Cell["\<\
LinkWrite[link, Unevaluated[EvaluatePacket[2 + Input[\"data =\"]]]]\
\
\>", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "What comes back is an ",
  StyleBox["InputPacket", "MR"],
  " which indicates that further input is required. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.25"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.13.7"],

Cell["InputPacket[data =]", "Output",
  CellLabel->"Out[19]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell["There is nothing more to be read on the link at this point. ", \
"MathCaption",
  CellTags->{"S2.13.7", "7.26"}],

Cell[CellGroupData[{

Cell["LinkReadyQ[link]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.13.7"],

Cell["False", "Output",
  CellLabel->"Out[20]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell["This enters more input. ", "MathCaption",
  CellTags->{"S2.13.7", "7.27"}],

Cell["LinkWrite[link, EnterTextPacket[\"x + y\"]]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Now the ",
  StyleBox["Input", "MR"],
  " function can be evaluated, and a ",
  StyleBox["ReturnPacket", "MR"],
  " is generated. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.28"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.13.7"],

Cell["ReturnPacket[2 + x + y]", "Output",
  CellLabel->"Out[22]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LinkInterrupt[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "send an interrupt to a ",
              StyleBox["MathLink", "TI"],
              "\[Hyphen]compatible program "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Interrupting a ",
  StyleBox["MathLink", "SO"],
  "\[Hyphen]compatible program. "
}], "Caption",
  CellTags->"S2.13.7"],

Cell["\<\
This sends a very time\[Hyphen]consuming calculation to the \
subsidiary process. \
\>", "MathCaption",
  CellTags->{"S2.13.7", "7.29"}],

Cell["LinkWrite[link, EnterTextPacket[\"FactorInteger[2^777-1]\"]]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.13.7"],

Cell["The calculation is still going on. ", "MathCaption",
  CellTags->{"S2.13.7", "7.30"}],

Cell[CellGroupData[{

Cell["LinkReadyQ[link]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.13.7"],

Cell["False", "Output",
  CellLabel->"Out[24]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell["This sends an interrupt. ", "MathCaption",
  CellTags->{"S2.13.7", "7.31"}],

Cell["LinkInterrupt[link]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.13.7"],

Cell["\<\
Now the subsidiary process has stopped, and is sending back an \
interrupt menu. \
\>", "MathCaption",
  CellTags->{"S2.13.7", "7.32"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.13.7"],

Cell["MenuPacket[1, Interrupt> ]", "Output",
  CellLabel->"Out[26]=",
  CellTags->"S2.13.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.8 Special Topic: Communication with ",
  StyleBox["Mathematica", "SBO"],
  " Front Ends"
}], "Subsection",
  CellTags->{"S2.13.8", "8.1"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " kernel uses ",
  StyleBox["MathLink", "TI"],
  " to communicate with ",
  StyleBox["Mathematica", "TI"],
  " front ends. If you start a ",
  StyleBox["Mathematica", "TI"],
  " kernel from within a front end, therefore, the kernel will be controlled \
through a ",
  StyleBox["MathLink", "TI"],
  " connection to this front end.  "
}], "Text",
  CellTags->{"S2.13.8", "8.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$ParentLink", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["MathLink", "TI"],
              " connection to use for kernel input and output "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.8"],

Cell["The link to the front end for a particular kernel. ", "Caption",
  CellTags->"S2.13.8"],

Cell[TextData[{
  "The global variable ",
  StyleBox["$ParentLink", "MR"],
  " specifies the ",
  StyleBox["MathLink", "TI"],
  " connection that a particular kernel will use for input and output. "
}], "Text",
  CellTags->{"S2.13.8", "8.3"}],

Cell[TextData[{
  "It is sometimes useful to reset ",
  StyleBox["$ParentLink", "MR"],
  " in the middle of a ",
  StyleBox["Mathematica", "TI"],
  " session, thereby effectively changing the front end to which the kernel \
is connected. "
}], "Text",
  CellTags->{"S2.13.8", "8.4"}],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.8", "8.5"}],

Cell["This creates a link on port 8000. ", "MathCaption",
  CellTags->{"S2.13.8", "8.6"}],

Cell[CellGroupData[{

Cell["link = LinkCreate[\"8000\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.13.8"],

Cell["LinkObject[8000@frog.wolfram.com, 4, 4]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.8"]
}, Open  ]],

Cell["Session B", "SessionLabel",
  CellTags->{"S2.13.8", "8.7"}],

Cell["This connects to the link opened in session A. ", "MathCaption",
  CellTags->{"S2.13.8", "8.8"}],

Cell[CellGroupData[{

Cell["LinkConnect[\"8000\"]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.13.8"],

Cell["LinkObject[8000@frog.wolfram.com, 4, 4]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.8"]
}, Open  ]],

Cell["\<\
This tells session B that it should use session A as a front end. \
\
\>", "MathCaption",
  CellTags->{"S2.13.8", "8.9"}],

Cell["$ParentLink = %", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.13.8"],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.8", "8.10"}],

Cell["\<\
Session A now acts as a front end to session B and gets all output \
from it. \
\>", "MathCaption",
  CellTags->{"S2.13.8", "8.11"}],

Cell[CellGroupData[{

Cell["Table[LinkRead[link], {4}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.13.8"],

Cell["\<\
{ResumePacket[LinkObject[ParentLink, 1, 1]],
 OutputNamePacket[Out[2]= ], ReturnTextPacket[
  LinkObject[8000@frog.wolfram.com, 4, 4]],
 InputNamePacket[In[3]:= ]}\
\>", "Output",
  CellLabel->"Out[2]=",
  CellTags->"S2.13.8"]
}, Open  ]],

Cell["This releases session B again. ", "MathCaption",
  CellTags->{"S2.13.8", "8.12"}],

Cell["LinkWrite[link, EnterTextPacket[\"$ParentLink=.\"]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.13.8"],

Cell[TextData[{
  "Much like the ",
  StyleBox["Mathematica", "TI"],
  " kernel, the standard notebook front end for ",
  StyleBox["Mathematica", "TI"],
  " is set up to handle a certain set of ",
  StyleBox["MathLink", "TI"],
  " packets. "
}], "Text",
  CellTags->{"S2.13.8", "8.13"}],

Cell[TextData[{
  "Usually it is best to use functions like ",
  StyleBox["NotebookWrite", "MR"],
  " and ",
  StyleBox["FrontEndExecute", "MR"],
  " if you want to control the ",
  StyleBox["Mathematica", "TI"],
  " front end from the kernel. But in some cases you may find it convenient \
to send packets directly to the front end using ",
  StyleBox["LinkWrite", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.8", "8.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.13.9 Two\[Hyphen]Way Communication with External Programs\
\>", \
"Subsection",
  CellTags->{"S2.13.9", "9.1"}],

Cell[TextData[{
  "When you install a ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible external program using ",
  StyleBox["Install", "MR"],
  ", the program is set up to behave somewhat like a simplified ",
  StyleBox["Mathematica", "TI"],
  " kernel. Every time you call a function in the external program, a ",
  StyleBox["CallPacket", "MR"],
  " is sent to the program, and the program responds by sending back a result \
wrapped in a ",
  StyleBox["ReturnPacket", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.9", "9.2"}],

Cell[TextData[{
  "This installs an external program, returning the ",
  StyleBox["LinkObject", "MR"],
  " used for the connection to that program. "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.3"}],

Cell[CellGroupData[{

Cell["link = Install[\"bitsprog\"]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \(LinkObject[bitsprog, 4, 4]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["ExternalCall", "MR"],
  " sends a ",
  StyleBox["CallPacket", "MR"],
  " to the external program. "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.4"}],

Cell[CellGroupData[{

Cell["?bits", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \("Global`bits"\)], "Print",
  CellTags->"S2.13.9"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(bits[i_Integer] := 
                    ExternalCall[LinkObject["./bitsprog", 13, 7], 
                      CallPacket[0, {i}]]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ bits],
      Editable->False]], "Print",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell[TextData[{
  "You can send the ",
  StyleBox["CallPacket", "MR"],
  " explicitly using ",
  StyleBox["LinkWrite", "MR"],
  ". The first argument of the ",
  StyleBox["CallPacket", "MR"],
  " specifies which function in the external program to call. "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.5"}],

Cell["LinkWrite[link, CallPacket[0, {67}]]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.13.9"],

Cell[TextData[{
  "Here is the response to the ",
  StyleBox["CallPacket", "MR"],
  " from the external program. "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.6"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \({1, 1, 0, 0, 0, 0, 1}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell[TextData[{
  "If you use ",
  StyleBox["Install", "MR"],
  " several times on a single external program, ",
  StyleBox["Mathematica", "TI"],
  " will open several ",
  StyleBox["MathLink", "TI"],
  " connections to the program. Each connection will however always \
correspond to a unique ",
  StyleBox["LinkObject", "MR"],
  ". Note that on some computer systems, you may need to make an explicit \
copy of the file containing the external program in order to be able to call \
it multiple times. "
}], "Text",
  CellTags->{"S2.13.9", "9.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$CurrentLink", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["MathLink", "TI"],
              " connection to the external program currently being run "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.9"],

Cell["\<\
Identifying different instances of a single external program. \
\
\>", "Caption",
  CellTags->"S2.13.9"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.9", "9.8"}],

Cell["\<\
:Begin:
:Function:      addto\
\>", "Program",
  CellTags->{"S2.13.9", "9.9"}],

Cell[TextData[{
  "This gives ",
  StyleBox["$CurrentLink", "MR"],
  " as an argument to ",
  StyleBox["addto", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.9", "9.10"}],

Cell[":Pattern:       addto[$CurrentLink, n_Integer]", "Program",
  CellTags->{"S2.13.9", "9.11"}],

Cell[TextData[{
  ":Arguments:     ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ArgumentTypes: ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Integer",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ReturnType:    Integer\n:End:\n"
}], "Program",
  CellTags->{"S2.13.9", "9.12"}],

Cell[TextData[{
  "This zeros the global variable ",
  StyleBox["counter", "MR"],
  " every time the program is started."
}], "MathCaption",
  CellTags->{"S2.13.9", "9.13"}],

Cell["\<\
int counter = 0;
\
\>", "Program",
  CellTags->{"S2.13.9", "9.14"}],

Cell[TextData[{
  "int addto(int n) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n    counter += n;\n    return counter;\n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.9", "9.15"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.9", "9.16"}],

Cell[TextData[{
  "This installs one instance of the external program containing ",
  StyleBox["addto", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.17"}],

Cell[CellGroupData[{

Cell["ct1 = Install[\"addtoprog\"]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \(LinkObject[addtoprog, 5, 5]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell["This installs another instance. ", "MathCaption",
  CellTags->{"S2.13.9", "9.18"}],

Cell[CellGroupData[{

Cell["ct2 = Install[\"addtoprog\"]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \(LinkObject[addtoprog, 6, 6]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell["\<\
This adds 10 to the counter in the first instance of the external \
program. \
\>", "MathCaption",
  CellTags->{"S2.13.9", "9.19"}],

Cell[CellGroupData[{

Cell["addto[ct1, 10]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \(10\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell["\<\
This adds 15 to the counter in the second instance of the external \
program. \
\>", "MathCaption",
  CellTags->{"S2.13.9", "9.20"}],

Cell[CellGroupData[{

Cell["addto[ct2, 15]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \(15\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell["This operates on the first instance of the program again. ", \
"MathCaption",
  CellTags->{"S2.13.9", "9.21"}],

Cell[CellGroupData[{

Cell["addto[ct1, 20]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \(30\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell[TextData[{
  "If an external program maintains information about its state then you can \
use different instances of the program to represent different states. ",
  StyleBox["$CurrentLink", "MR"],
  " then provides a way to refer to each instance of the program. "
}], "Text",
  CellTags->{"S2.13.9", "9.22"}],

Cell[TextData[{
  "The value of ",
  StyleBox["$CurrentLink", "MR"],
  " is temporarily set every time a particular instance of the program is \
called, as well as when each instance of the program is first installed. "
}], "Text",
  CellTags->{"S2.13.9", "9.23"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLEvaluateString(stdlink,", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\")", "MR"],
              " "
            }]], Cell[TextData[{
              "send input to ",
              StyleBox["Mathematica", "TI"],
              " but return no results "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.9"],

Cell[TextData[{
  "Sending a string for evaluation by ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.9"],

Cell[TextData[{
  "The two\[Hyphen]way nature of ",
  StyleBox["MathLink", "TI"],
  " connections allows you not only to have ",
  StyleBox["Mathematica", "TI"],
  " call an external program, but also to have that external program call \
back to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.13.9", "9.24"}],

Cell[TextData[{
  "In the simplest case, you can use the ",
  StyleBox["MathLink", "TI"],
  " function ",
  StyleBox["MLEvaluateString()", "MR"],
  " to send a string to ",
  StyleBox["Mathematica", "TI"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " will evaluate this string, producing whatever effects the string \
specifies, but it will not return any results from the evaluation back to the \
external program. "
}], "Text",
  CellTags->{"S2.13.9", "9.25"}],

Cell[TextData[{
  "To get results back you need explicitly to send an ",
  StyleBox["EvaluatePacket", "MR"],
  " to ",
  StyleBox["Mathematica", "TI"],
  ", and then read the contents of the ",
  StyleBox["ReturnPacket", "MR"],
  " that comes back. "
}], "Text",
  CellTags->{"S2.13.9", "9.26"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.9", "9.27"}],

Cell["...", "Program",
  CellTags->{"S2.13.9", "9.28"}],

Cell[TextData[{
  "This starts an ",
  StyleBox["EvaluatePacket", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.29"}],

Cell["MLPutFunction(stdlink, \"EvaluatePacket\", 1);", "Program",
  CellTags->{"S2.13.9", "9.30"}],

Cell[TextData[{
  "This constructs the expression ",
  StyleBox["Factorial[7]", "MR"],
  " or ",
  StyleBox["7!", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.9", "9.31"}],

Cell["\<\
  MLPutFunction(stdlink, \"Factorial\", 1);
    MLPutInteger(stdlink, 7);\
\>", "Program",
  CellTags->{"S2.13.9", "9.32"}],

Cell["\<\
This specifies that the packet you are constructing is finished. \
\
\>", "MathCaption",
  CellTags->{"S2.13.9", "9.33"}],

Cell["\<\
MLEndPacket(stdlink);
\
\>", "Program",
  CellTags->{"S2.13.9", "9.34"}],

Cell[TextData[{
  "This checks the ",
  StyleBox["ReturnPacket", "MR"],
  " that comes back. "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.35"}],

Cell["MLCheckFunction(stdlink, \"ReturnPacket\", &n);", "Program",
  CellTags->{"S2.13.9", "9.36"}],

Cell[TextData[{
  "This extracts the integer result for ",
  StyleBox["7!", "MR"],
  " from the packet. "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.37"}],

Cell["MLGetInteger(stdlink, &ans);", "Program",
  CellTags->{"S2.13.9", "9.38"}],

Cell["...", "Program",
  CellTags->{"S2.13.9", "9.39"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.9", "9.40"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLEndPacket(stdlink)", "MR"],
              " "
            }]], Cell[TextData[{
              "specify that a packet is finished and ready to be sent to ",
              StyleBox["Mathematica", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.9"],

Cell[TextData[{
  "Sending a packet to ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.9"],

Cell[TextData[{
  "When you can send ",
  StyleBox["Mathematica", "TI"],
  " an ",
  StyleBox["EvaluatePacket[", "MR"],
  StyleBox["input", "TI"],
  StyleBox["]", "MR"],
  ", it may in general produce many packets in response, but the final packet \
should be ",
  StyleBox["ReturnPacket[", "MR"],
  StyleBox["output", "TI"],
  StyleBox["]", "MR"],
  ". Section\[NonBreakingSpace]",
  ButtonBox["2.13.12",
    ButtonData:>{"2.13.12", "12.52"},
    ButtonStyle->"MainBookLink"],
  " will discuss how to handle sequences of packets and expressions whose \
structure you do not know in advance. "
}], "Text",
  CellTags->{"S2.13.9", "9.41"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.13.10 Special Topic: Running Programs on Remote Computers", \
"Subsection",
  CellTags->{"S2.13.10", "10.1"}],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " allows you to call an external program from within ",
  StyleBox["Mathematica", "TI"],
  " even when that program is running on a remote computer. Typically, you \
need to start the program directly from the operating system on the remote \
computer. But then you can connect to it using commands within your ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Text",
  CellTags->{"S2.13.10", "10.2"}],

Cell[TextData[{
  "Operating system on ",
  StyleBox["toad.wolfram.com", "MR"]
}], "SessionLabel",
  CellTags->{"S2.13.10", "10.3"}],

Cell[TextData[{
  "This starts the program ",
  StyleBox["fprog", "MR"],
  " and tells it to create a new link."
}], "MathCaption",
  CellTags->{"S2.13.10", "10.4"}],

Cell[TextData[{
  StyleBox["fprog -linkcreate", "MB"],
  " "
}], "Program",
  CellTags->{"S2.13.10", "10.5"}],

Cell["\<\
The program responds with the specification of the link it has \
created. \
\>", "MathCaption",
  CellTags->{"S2.13.10", "10.6"}],

Cell[TextData[{
  "Link",
  StyleBox[" ", "TR"],
  "created",
  StyleBox[" ", "TR"],
  "on:",
  StyleBox[" ", "TR"],
  "2976@toad.wolfram.com "
}], "Program",
  CellTags->{"S2.13.10", "10.7"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " session on ",
  StyleBox["frog.wolfram.com", "MR"]
}], "SessionLabel",
  CellTags->{"S2.13.10", "10.8"}],

Cell["This connects to the link that has been created. ", "MathCaption",
  CellTags->{"S2.13.10", "10.9"}],

Cell[CellGroupData[{

Cell["Install[LinkConnect[\"2976@toad.wolfram.com\"]]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"S2.13.10"],

Cell["LinkObject[2976@toad.wolfram.com, 1]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.10"]
}, Open  ]],

Cell[TextData[{
  "This now executes code in the external program on ",
  StyleBox["toad.wolfram.com", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.10", "10.10"}],

Cell[CellGroupData[{

Cell["f[16]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"S2.13.10"],

Cell["561243", "Output",
  CellLabel->"Out[2]=",
  CellTags->"S2.13.10"]
}, Open  ]],

Cell[TextData[{
  "External programs that are created using ",
  StyleBox["mcc", "MR"],
  " or ",
  StyleBox["mprep", "MR"],
  " always contain the code that is needed to set up ",
  StyleBox["MathLink", "TI"],
  " connections. If you start such programs directly from your operating \
system, they will prompt you to specify what kind of connection you want. \
Alternatively, if your operating system supports it, you can also give this \
information as a command\[Hyphen]line argument to the external program. "
}], "Text",
  CellTags->{"S2.13.10", "10.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["prog", "TI"],
              " ",
              StyleBox["-linkcreate", "MR"],
              " "
            }]], 
            Cell["\<\
operating system command to run a program and have it \
create a link \
\>"]},
          {Cell[TextData[{
              StyleBox["Install[LinkConnect[\"", "MR"],
              StyleBox["port", "TI"],
              StyleBox["@", "MR"],
              StyleBox["host", "TI"],
              StyleBox["\"]]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " command to connect to the external program "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.10"],

Cell["Running an external program on a remote computer. ", "Caption",
  CellTags->"S2.13.10"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.13.11 Special Topic: Running External Programs under a Debugger\
\
\>", "Subsection",
  CellTags->{"S2.13.11", "11.1"}],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " allows you to run external programs under whatever debugger is provided \
in your software environment. "
}], "Text",
  CellTags->{"S2.13.11", "11.2"}],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible programs are typically set up to take arguments, \
usually on the command line, which specify what ",
  StyleBox["MathLink", "TI"],
  " connections they should use. "
}], "Text",
  CellTags->{"S2.13.11", "11.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["In debugger: "], Cell[TextData[{
              StyleBox["run", "MR"],
              " ",
              StyleBox["-linkcreate", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "In ",
              StyleBox["Mathematica", "TI"],
              ": "
            }]], Cell[TextData[{
              StyleBox["Install[LinkConnect[\"", "MR"],
              StyleBox["port", "TI"],
              StyleBox["\"]]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.11"],

Cell["Running an external program under a debugger. ", "Caption",
  CellTags->"S2.13.11"],

Cell[TextData[{
  "Note that in order to get a version of an external program that can be run \
under a debugger, you may need to specify ",
  StyleBox["-g", "MR"],
  " or other flags when you compile the program. "
}], "Text",
  CellTags->{"S2.13.11", "11.4"}],

Cell["Debugger", "SessionLabel",
  CellTags->{"S2.13.11", "11.5"}],

Cell[TextData[{
  "Set a breakpoint in the C function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.11", "11.6"}],

Cell[TextData[{
  StyleBox["break f", "MB"],
  "\nBreakpoint",
  StyleBox[" ", "TR"],
  "set:",
  StyleBox[" ", "TR"],
  "f:",
  StyleBox[" ", "TR"],
  "line",
  StyleBox[" ", "TR"],
  "1 "
}], "Program",
  CellTags->{"S2.13.11", "11.7"}],

Cell["Start the external program.", "MathCaption",
  CellTags->{"S2.13.11", "11.8"}],

Cell[TextData[{
  StyleBox["run -linkcreate", "MB"],
  " "
}], "Program",
  CellTags->{"S2.13.11", "11.9"}],

Cell["The program responds with what port it is listening on.", "MathCaption",
  CellTags->{"S2.13.11", "11.10"}],

Cell[TextData[{
  "Link",
  StyleBox[" ", "TR"],
  "created",
  StyleBox[" ", "TR"],
  "on:",
  StyleBox[" ", "TR"],
  "2981@frog.wolfram.com "
}], "Program",
  CellTags->{"S2.13.11", "11.11"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " session"
}], "SessionLabel",
  CellTags->{"S2.13.11", "11.12"}],

Cell["This connects to the program running under the debugger. ", \
"MathCaption",
  CellTags->{"S2.13.11", "11.13"}],

Cell[CellGroupData[{

Cell["Install[LinkConnect[\"2981@frog.wolfram.com\"]]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"S2.13.11"],

Cell["LinkObject[2981@frog.wolfram.com, 1]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.11"]
}, Open  ]],

Cell["\<\
This calls a function which executes code in the external program. \
\
\>", "MathCaption",
  CellTags->{"S2.13.11", "11.14"}],

Cell["f[16]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"S2.13.11"],

Cell["Debugger", "SessionLabel",
  CellTags->{"S2.13.11", "11.15"}],

Cell["The external program stops at the breakpoint. ", "MathCaption",
  CellTags->{"S2.13.11", "11.16"}],

Cell[TextData[{
  "Breakpoint:",
  StyleBox[" ", "TR"],
  "f(16) "
}], "Program",
  CellTags->{"S2.13.11", "11.17"}],

Cell["This tells the debugger to continue.", "MathCaption",
  CellTags->{"S2.13.11", "11.18"}],

Cell[TextData[{
  StyleBox["continue", "MB"],
  " "
}], "Program",
  CellTags->{"S2.13.11", "11.19"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " session"
}], "SessionLabel",
  CellTags->{"S2.13.11", "11.20"}],

Cell[TextData[{
  "Now ",
  StyleBox["f", "MR"],
  " returns. "
}], "MathCaption",
  CellTags->{"S2.13.11", "11.21"}],

Cell["561243", "Output",
  CellLabel->"Out[2]=",
  CellTags->"S2.13.11"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.13.12 Manipulating Expressions in External Programs", "Subsection",
  CellTags->{"S2.13.12", "12.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " expressions provide a very general way to handle all kinds of data, and \
you may sometimes want to use such expressions inside your external programs. \
A language like C, however, offers no direct way to store general ",
  StyleBox["Mathematica", "TI"],
  " expressions. But it is nevertheless possible to do this by using the ",
  StyleBox["loopback links", "TI"],
  " provided by the ",
  StyleBox["MathLink", "TI"],
  " library. A loopback link is a local ",
  StyleBox["MathLink", "TI"],
  " connection inside your external program, to which you can write \
expressions that can later be read back. "
}], "Text",
  CellTags->{"S2.13.12", "12.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLINK", "MR"],
              " ",
              StyleBox["MLLoopbackOpen(stdenv,", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["errno", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["open a loopback link "]},
          {Cell[TextData[{
              StyleBox["void", "MR"],
              " ",
              StyleBox["MLClose(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["close a link "]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLTransferExpression(MLINK", "MR"],
              " ",
              StyleBox["dest", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["MLINK", "MR"],
              " ",
              StyleBox["src", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "get an expression from ",
              StyleBox["src", "TI"],
              " and put it onto ",
              StyleBox["dest", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True}},
  CellTags->"S2.13.12"],

Cell["Functions for manipulating loopback links. ", "Caption",
  CellTags->"S2.13.12"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.12", "12.3"}],

Cell["...", "Program",
  CellTags->{"S2.13.12", "12.4"}],

Cell["This opens a loopback link. ", "MathCaption",
  CellTags->{"S2.13.12", "12.5"}],

Cell["ml = MLLoopbackOpen(stdenv, &errno);", "Program",
  CellTags->{"S2.13.12", "12.6"}],

Cell[TextData[{
  "This puts the expression ",
  StyleBox["Power[x,", "MR"],
  " ",
  StyleBox["3]", "MR"],
  " onto the loopback link. "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.7"}],

Cell["\<\
MLPutFunction(ml, \"Power\", 2);
  MLPutSymbol(ml, \"x\");
  MLPutInteger(ml, 3);\
\>", "Program",
  CellTags->{"S2.13.12", "12.8"}],

Cell["...", "Program",
  CellTags->{"S2.13.12", "12.9"}],

Cell["This gets the expression back from the loopback link. ", "MathCaption",
  CellTags->{"S2.13.12", "12.10"}],

Cell["\<\
MLGetFunction(ml, &head, &n);
  MLGetSymbol(ml, &sname);
  MLGetInteger(ml, &k);\
\>", "Program",
  CellTags->{"S2.13.12", "12.11"}],

Cell["...", "Program",
  CellTags->{"S2.13.12", "12.12"}],

Cell["This closes the loopback link again. ", "MathCaption",
  CellTags->{"S2.13.12", "12.13"}],

Cell["MLClose(ml);", "Program",
  CellTags->{"S2.13.12", "12.14"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.12", "12.15"}],

Cell[TextData[{
  "You can use ",
  StyleBox["MLTransferExpression()", "MR"],
  " to take an expression that you get via ",
  StyleBox["stdlink", "MR"],
  " from ",
  StyleBox["Mathematica", "TI"],
  ", and save it in a local loopback link for later processing. "
}], "Text",
  CellTags->{"S2.13.12", "12.16"}],

Cell[TextData[{
  "You can also use ",
  StyleBox["MLTransferExpression()", "MR"],
  " to take an expression that you have built up on a local loopback link, \
and transfer it back to ",
  StyleBox["Mathematica", "TI"],
  " via ",
  StyleBox["stdlink", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.12", "12.17"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.12", "12.18"}],

Cell["...", "Program",
  CellTags->{"S2.13.12", "12.19"}],

Cell[TextData[{
  "This puts ",
  StyleBox["21!", "MR"],
  " onto a local loopback link. "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.20"}],

Cell["\<\
MLPutFunction(ml, \"Factorial\", 1);
  MLPutInteger(ml, 21);\
\>", "Program",
  CellTags->{"S2.13.12", "12.21"}],

Cell[TextData[{
  "This sends the head ",
  StyleBox["FactorInteger", "MR"],
  " to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.22"}],

Cell["MLPutFunction(stdlink, \"FactorInteger\", 1);", "Program",
  CellTags->{"S2.13.12", "12.23"}],

Cell[TextData[{
  "This transfers the ",
  StyleBox["21!", "MR"],
  " from the loopback link to ",
  StyleBox["stdlink", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.12", "12.24"}],

Cell["MLTransferExpression(stdlink, ml);", "Program",
  CellTags->{"S2.13.12", "12.25"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.12", "12.26"}],

Cell["\<\
You can put any sequence of expressions onto a loopback link. \
Usually you get the expressions off the link in the same order as you put \
them on. \
\>", "Text",
  CellTags->{"S2.13.12", "12.27"}],

Cell[TextData[{
  "And once you have got an expression off the link it is usually no longer \
saved. But by using ",
  StyleBox["MLCreateMark()", "MR"],
  " you can mark a particular position in a sequence of expressions on a \
link, forcing ",
  StyleBox["MathLink", "TI"],
  " to save every expression after the mark so that you can go back to it \
later. "
}], "Text",
  CellTags->{"S2.13.12", "12.28"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLMARK", "MR"],
              " ",
              StyleBox["MLCreateMark(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
create a mark at the current position in a sequence of \
expressions on a link \
\>"]},
          {Cell[TextData[{
              StyleBox["MLSeekMark(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["MLMARK", "MR"],
              " ",
              StyleBox["mark", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "go back to a position ",
              StyleBox["n", "TI"],
              " expressions after the specified mark on a link "
            }]]},
          {Cell[TextData[{
              StyleBox["MLDestroyMark(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["MLMARK", "MR"],
              " ",
              StyleBox["mark", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["destroy a mark in a link "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.12"],

Cell[TextData[{
  "Setting up marks in ",
  StyleBox["MathLink", "SO"],
  " links. "
}], "Caption",
  CellTags->"S2.13.12"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.12", "12.29"}],

Cell["...", "Program",
  CellTags->{"S2.13.12", "12.30"}],

Cell[TextData[{
  "This puts the integer ",
  StyleBox["45", "MR"],
  " onto a loopback link. "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.31"}],

Cell["MLPutInteger(ml, 45);", "Program",
  CellTags->{"S2.13.12", "12.32"}],

Cell[TextData[{
  "This puts ",
  StyleBox["33", "MR"],
  " onto the link. "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.33"}],

Cell["MLPutInteger(ml, 33);", "Program",
  CellTags->{"S2.13.12", "12.34"}],

Cell[TextData[{
  "And this puts ",
  StyleBox["76", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.35"}],

Cell["\<\
MLPutInteger(ml, 76);
\
\>", "Program",
  CellTags->{"S2.13.12", "12.36"}],

Cell[TextData[{
  "This will read ",
  StyleBox["45", "MR"],
  " from the link. The ",
  StyleBox["45", "MR"],
  " will no longer be saved. "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.37"}],

Cell["MLGetInteger(ml, &i);", "Program",
  CellTags->{"S2.13.12", "12.38"}],

Cell["This creates a mark at the current position on the link. ", \
"MathCaption",
  CellTags->{"S2.13.12", "12.39"}],

Cell["mark = MLCreateMark(ml);", "Program",
  CellTags->{"S2.13.12", "12.40"}],

Cell[TextData[{
  "This will now read ",
  StyleBox["33", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.41"}],

Cell["MLGetInteger(ml, &i);", "Program",
  CellTags->{"S2.13.12", "12.42"}],

Cell[TextData[{
  "And this will read ",
  StyleBox["76", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.43"}],

Cell["MLGetInteger(ml, &i);", "Program",
  CellTags->{"S2.13.12", "12.44"}],

Cell["This goes back to the position of the mark. ", "MathCaption",
  CellTags->{"S2.13.12", "12.45"}],

Cell["MLSeekMark(ml, mark, 0);", "Program",
  CellTags->{"S2.13.12", "12.46"}],

Cell[TextData[{
  "Now this will read ",
  StyleBox["33", "MR"],
  " again. "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.47"}],

Cell["MLGetInteger(ml, &i);", "Program",
  CellTags->{"S2.13.12", "12.48"}],

Cell["\<\
It is important to destroy marks when you have finished with them, \
so no unnecessary expressions will be saved.\
\>", "MathCaption",
  CellTags->{"S2.13.12", "12.49"}],

Cell["MLDestroyMark(ml, mark);", "Program",
  CellTags->{"S2.13.12", "12.50"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.12", "12.51"}],

Cell[TextData[{
  "The way the ",
  StyleBox["MathLink", "TI"],
  " library is implemented, it is very efficient to open and close loopback \
links, and to create and destroy marks in them. The only point to remember is \
that as soon as you create a mark on a particular link, ",
  StyleBox["MathLink", "TI"],
  " will save subsequent expressions that are put on that link, and will go \
on doing this until the mark is destroyed. "
}], "Text",
  CellTags->{"S2.13.12", "12.52"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLGetNext(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["find the type of the next object on a link "]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLGetArgCount(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "store in ",
              StyleBox["n", "TI"],
              " the number of arguments for a function on a link "
            }]]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLGetSymbol(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["name", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get the name of a symbol "]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLGetInteger(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["int", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["i", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get a machine integer "]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLGetReal(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["double", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["x", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
get a machine floating\[Hyphen]point number \
\>"]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLGetString(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["string", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get a character string "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, True, False}},
  CellTags->"S2.13.12"],

Cell["Functions for getting pieces of expressions from a link. ", "Caption",
  CellTags->"S2.13.12"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLTKFUNC", "MR"],
              " "
            }]], 
            Cell["\<\
composite function\[LongDash]head and arguments \
\
\>"]},
          {Cell[TextData[{
              StyleBox["MLTKSYM", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " symbol "
            }]]},
          {Cell[TextData[{
              StyleBox["MLTKINT", "MR"],
              " "
            }]], Cell["integer "]},
          {Cell[TextData[{
              StyleBox["MLTKREAL", "MR"],
              " "
            }]], Cell["floating\[Hyphen]point number "]},
          {Cell[TextData[{
              StyleBox["MLTKSTR", "MR"],
              " "
            }]], Cell["character string "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.13.12"],

Cell[TextData[{
  "Constants returned by ",
  StyleBox["MLGetNext()", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.13.12"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.12", "12.53"}],

Cell["switch(MLGetNext(ml)) {", "Program",
  CellTags->{"S2.13.12", "12.54"}],

Cell["This reads a composite function. ", "MathCaption",
  CellTags->{"S2.13.12", "12.55"}],

Cell[TextData[{
  "    case MLTKFUNC:\n    MLGetArgCount(ml, &n);\n    ",
  StyleBox[" recurse for head", "MO"],
  "\n    for (i = 0; i < n; i++) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n        ",
  StyleBox[" recurse for each argument", "MO"],
  "\n    ",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n    \[Ellipsis] "
}], "Program",
  CellTags->{"S2.13.12", "12.56"}],

Cell["This reads a single symbol. ", "MathCaption",
  CellTags->{"S2.13.12", "12.57"}],

Cell["\<\
    case MLTKSYM:
    MLGetSymbol(ml, &name);
    \[Ellipsis] \
\>", "Program",
  CellTags->{"S2.13.12", "12.58"}],

Cell["This reads a machine integer. ", "MathCaption",
  CellTags->{"S2.13.12", "12.59"}],

Cell["\<\
    case MLTKINT:
    MLGetInteger(ml, &i);
    \[Ellipsis] \
\>", "Program",
  CellTags->{"S2.13.12", "12.60"}],

Cell["}", "Program",
  CellTags->{"S2.13.12", "12.61"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.12", "12.62"}],

Cell[TextData[{
  "By using ",
  StyleBox["MLGetNext()", "MR"],
  " it is straightforward to write programs that can read any expression. The \
way ",
  StyleBox["MathLink", "TI"],
  " works, the head and arguments of a function appear as successive \
expressions on the link, which you read one after another. "
}], "Text",
  CellTags->{"S2.13.12", "12.63"}],

Cell[TextData[{
  "Note that if you know that the head of a function will be a symbol, then \
you can use ",
  StyleBox["MLGetFunction()", "MR"],
  " instead of ",
  StyleBox["MLGetNext()", "MR"],
  ". In this case, however, you still need to call ",
  StyleBox["MLDisownSymbol()", "MR"],
  " to disown the memory used to store the symbol name. "
}], "Text",
  CellTags->{"S2.13.12", "12.64"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLPutNext(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["int", "MR"],
              " ",
              StyleBox["type", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[
            "prepare to put an object of the specified type on a link "]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLPutArgCount(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[
            "give the number of arguments for a composite function "]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLPutSymbol(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["name", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a symbol on the link "]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLPutInteger(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["int", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a machine integer "]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLPutReal(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["double", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
put a machine floating\[Hyphen]point number \
\>"]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLPutString(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["string", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a character string "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, True, False}},
  CellTags->"S2.13.12"],

Cell["Functions for putting pieces of expressions onto a link. ", "Caption",
  CellTags->"S2.13.12"],

Cell[TextData[{
  StyleBox["MLPutNext()", "MR"],
  " specifies types of expressions using constants such as ",
  StyleBox["MLTKFUNC", "MR"],
  " from the ",
  StyleBox["mathlink.h", "MR"],
  " header file\[LongDash]just like ",
  StyleBox["MLGetNext()", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.12", "12.65"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.13.13 Advanced Topic: Error and Interrupt Handling", "Subsection",
  CellTags->{"S2.13.13", "13.1"}],

Cell[TextData[{
  "When you are putting and getting data via ",
  StyleBox["MathLink", "TI"],
  " various kinds of errors can occur. Whenever any error occurs, ",
  StyleBox["MathLink", "TI"],
  " goes into a completely inactive state, and all ",
  StyleBox["MathLink", "TI"],
  " functions you call will return 0 immediately.  "
}], "Text",
  CellTags->{"S2.13.13", "13.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["long", "MR"],
              " ",
              StyleBox["MLError(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "return a number identifying the current error, or ",
              StyleBox["0", "MR"],
              " if none has occurred "
            }]]},
          {Cell[TextData[{
              StyleBox["char", "MR"],
              " ",
              StyleBox["*MLErrorMessage(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[
            "return a character string describing the current error "]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLClearError(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "clear the current error, returning ",
              StyleBox["MathLink", "TI"],
              " if possible to an active state "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True}},
  CellTags->"S2.13.13"],

Cell[TextData[{
  "Handling errors in ",
  StyleBox["MathLink", "SO"],
  " programs. "
}], "Caption",
  CellTags->"S2.13.13"],

Cell[TextData[{
  "When you do complicated operations, it is often convenient to check for \
errors only at the end. If you find that an error occurred, you must then \
call ",
  StyleBox["MLClearError()", "MR"],
  " to activate ",
  StyleBox["MathLink", "TI"],
  " again. "
}], "Text",
  CellTags->{"S2.13.13", "13.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLNewPacket(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["skip to the end of the current packet "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.13"],

Cell["Clearing out the remains of a packet. ", "Caption",
  CellTags->"S2.13.13"],

Cell[TextData[{
  "After an error, it is common to want to discard the remainder of the \
packet or expression that you are currently processing. You can do this using \
",
  StyleBox["MLNewPacket()", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.13", "13.4"}],

Cell[TextData[{
  "In some cases, you may want to set it up so that if an error occurs while \
you are processing particular data, you can then later go back and reprocess \
the data in a different way. You can do this by calling ",
  StyleBox["MLCreateMark()", "MR"],
  " to create a mark before you first process the data, and then calling ",
  StyleBox["MLSeekMark()", "MR"],
  " to seek back to the mark if you need to reprocess the data. You should \
not forgot to call ",
  StyleBox["MLDestroyMark()", "MR"],
  " when you have finally finished with the data\[LongDash]otherwise ",
  StyleBox["MathLink", "TI"],
  " will continue to store it. "
}], "Text",
  CellTags->{"S2.13.13", "13.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLAbort", "MR"],
              " "
            }]], Cell[TextData[{
              "a global variable set when a program set up by ",
              StyleBox["Install", "MR"],
              " is sent an abort interrupt "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.13"],

Cell["Aborting an external program. ", "Caption",
  CellTags->"S2.13.13"],

Cell[TextData[{
  "If you interrupt ",
  StyleBox["Mathematica", "TI"],
  " while it is in the middle of executing an external function, it will \
typically give you the opportunity to try to abort the external function. If \
you choose to do this, what will happen is that the global variable ",
  StyleBox["MLAbort", "MR"],
  " will be set to ",
  StyleBox["1", "MR"],
  " inside your external program. "
}], "Text",
  CellTags->{"S2.13.13", "13.6"}],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " cannot automatically back out of an external function call that has been \
made. So if you have a function that can take a long time, you should \
explicitly check ",
  StyleBox["MLAbort", "MR"],
  " every so often, returning from the function if you find that the variable \
has been set. "
}], "Text",
  CellTags->{"S2.13.13", "13.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.14 Running ",
  StyleBox["Mathematica", "SBO"],
  " from Within an External Program"
}], "Subsection",
  CellTags->{"S2.13.14", "14.1"}],

Cell[TextData[{
  "To run ",
  StyleBox["Mathematica", "TI"],
  " from within an external program requires making use of many general \
features of ",
  StyleBox["MathLink", "TI"],
  ". The first issue is how to establish a ",
  StyleBox["MathLink", "TI"],
  " connection to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.13.14", "14.2"}],

Cell[TextData[{
  "When you use ",
  StyleBox["MathLink", "TI"],
  " templates to create external programs that can be called from ",
  StyleBox["Mathematica", "TI"],
  ", source code to establish a ",
  StyleBox["MathLink", "TI"],
  " connection is automatically generated, and all you have to do in your \
external program is to call ",
  StyleBox["MLMain(", "MR"],
  StyleBox["argc", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["argv", "TI"],
  StyleBox[")", "MR"],
  ". But in general you need to call several functions to establish a ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Text",
  CellTags->{"S2.13.14", "14.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLENV", "MR"],
              " ",
              StyleBox["MLInitialize(0)", "MR"],
              " "
            }]], Cell[TextData[{
              "initialize ",
              StyleBox["MathLink", "TI"],
              " library functions "
            }]]},
          {Cell[TextData[{
              StyleBox["MLINK", "MR"],
              " ",
              StyleBox["MLOpenArgv(MLENV", "MR"],
              " ",
              StyleBox["env", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["argv0", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["**", "MR"],
              StyleBox["argv1", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["errno", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "open a ",
              StyleBox["MathLink", "TI"],
              " connection taking parameters from an ",
              StyleBox["argv", "MR"],
              " array "
            }]]},
          {Cell[TextData[{
              StyleBox["MLINK", "MR"],
              " ",
              StyleBox["MLOpenString(MLENV", "MR"],
              " ",
              StyleBox["env", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["string", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["long", "MR"],
              " ",
              StyleBox["*", "MR"],
              StyleBox["errno", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "open a ",
              StyleBox["MathLink", "TI"],
              " connection taking parameters from a single character string "
            }]]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLActivate(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "activate a ",
              StyleBox["MathLink", "TI"],
              
              " connection, waiting for the program at the other end to \
respond "
            }]]},
          {Cell[TextData[{
              StyleBox["void", "MR"],
              " ",
              StyleBox["MLClose(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "close a ",
              StyleBox["MathLink", "TI"],
              " connection "
            }]]},
          {Cell[TextData[{
              StyleBox["void", "MR"],
              " ",
              StyleBox["MLDeinitialize(MLENV", "MR"],
              " ",
              StyleBox["env", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "deinitialize ",
              StyleBox["MathLink", "TI"],
              " library functions "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, True, False}},
  CellTags->"S2.13.14"],

Cell[TextData[{
  "Opening and closing ",
  StyleBox["MathLink", "SO"],
  " connections. "
}], "Caption",
  CellTags->"S2.13.14"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.14", "14.4"}],

Cell[TextData[{
  "Include the standard ",
  StyleBox["MathLink", "TI"],
  " header file. "
}], "MathCaption",
  CellTags->{"S2.13.14", "14.5"}],

Cell["\<\
#include \"mathlink.h\"
\
\>", "Program",
  CellTags->{"S2.13.14", "14.6"}],

Cell["int main(int argc, char *argv[]) {", "Program",
  CellTags->{"S2.13.14", "14.7"}],

Cell["\<\
   MLENV env;
   MLINK link;
   long errno;
\
\>", "Program",
  CellTags->{"S2.13.14", "14.8"}],

Cell[TextData[{
  "This initializes ",
  StyleBox["MathLink", "TI"],
  " library functions. "
}], "MathCaption",
  CellTags->{"S2.13.14", "14.9"}],

Cell["   env = MLInitialize(0);", "Program",
  CellTags->{"S2.13.14", "14.10"}],

Cell[TextData[{
  "This opens a ",
  StyleBox["MathLink", "TI"],
  " connection, using the same arguments as were passed to the main program. \
"
}], "MathCaption",
  CellTags->{"S2.13.14", "14.11"}],

Cell["   link = MLOpenArgv(env, argv, argv+argc, &errno);", "Program",
  CellTags->{"S2.13.14", "14.12"}],

Cell["\<\
This activates the connection, waiting for the other program to \
respond.\
\>", "MathCaption",
  CellTags->{"S2.13.14", "14.13"}],

Cell["   MLActivate(link);", "Program",
  CellTags->{"S2.13.14", "14.14"}],

Cell["\<\
   ...
}\
\>", "Program",
  CellTags->{"S2.13.14", "14.15"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.14", "14.16"}],

Cell[TextData[{
  "Often the ",
  StyleBox["argv", "MR"],
  " that you pass to ",
  StyleBox["MLOpenArgv()", "MR"],
  " will come directly from the ",
  StyleBox["argv", "MR"],
  " that is passed to ",
  StyleBox["main()", "MR"],
  " when your whole program is started. Note that ",
  StyleBox["MLOpenArgv()", "MR"],
  " takes pointers to the beginning and end of the ",
  StyleBox["argv", "MR"],
  " array. By not using ",
  StyleBox["argc", "MR"],
  " directly it avoids having to know the size of an ",
  StyleBox["int", "MR"],
  ".   "
}], "Text",
  CellTags->{"S2.13.14", "14.17"}],

Cell[TextData[{
  "The elements in the ",
  StyleBox["argv", "MR"],
  " array are character strings which mirror the arguments and options used \
in the ",
  StyleBox["Mathematica", "TI"],
  " functions ",
  StyleBox["LinkLaunch", "MR"],
  ", ",
  StyleBox["LinkCreate", "MR"],
  " and ",
  StyleBox["LinkConnect", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.14", "14.18"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"-linklaunch\"", "MR"],
              " "
            }]], Cell[TextData[{
              "operate like ",
              StyleBox["LinkLaunch[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["\"-linkcreate\"", "MR"],
              " "
            }]], Cell[TextData[{
              "operate like ",
              StyleBox["LinkCreate[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["\"-linkconnect\"", "MR"],
              " "
            }]], Cell[TextData[{
              "operate like ",
              StyleBox["LinkConnect[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["\"-linkname\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["give the name to use "]},
          {Cell[TextData[{
              StyleBox["\"-linkprotocol\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["protocol", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell[TextData[{
              "give the link protocol to use (",
              StyleBox["tcp", "MR"],
              ", ",
              StyleBox["pipes", "MR"],
              ", etc.) "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True}},
  CellTags->"S2.13.14"],

Cell[TextData[{
  "Possible elements of the ",
  StyleBox["argv", "MR"],
  " array passed to ",
  StyleBox["MLOpenArgv()", "MR"],
  "."
}], "Caption",
  CellTags->"S2.13.14"],

Cell[TextData[{
  "As an alternative to ",
  StyleBox["MLOpenArgv()", "MR"],
  " you can use ",
  StyleBox["MLOpenString()", "MR"],
  ", which takes parameters concatenated into a single character string with \
spaces in between. "
}], "Text",
  CellTags->{"S2.13.14", "14.19"}],

Cell[TextData[{
  "Once you have successfully opened a ",
  StyleBox["MathLink", "TI"],
  " connection to the ",
  StyleBox["Mathematica", "TI"],
  " kernel, you can then use standard ",
  StyleBox["MathLink", "TI"],
  " functions to exchange data with it. "
}], "Text",
  CellTags->{"S2.13.14", "14.20"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLEndPacket(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["indicate the end of a packet "]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLNextPacket(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["find the head of the next packet "]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLNewPacket(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["skip to the end of the current packet "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.14"],

Cell[TextData[{
  "Functions often used in communicating with the ",
  StyleBox["Mathematica", "SO"],
  " kernel. "
}], "Caption",
  CellTags->"S2.13.14"],

Cell[TextData[{
  "Once you have sent all the pieces of a packet using ",
  StyleBox["MLPutFunction()", "MR"],
  " etc., ",
  StyleBox["MathLink", "TI"],
  " requires you to call ",
  StyleBox["MLEndPacket()", "MR"],
  " to ensure synchronization and consistency. "
}], "Text",
  CellTags->{"S2.13.14", "14.21"}],

Cell[TextData[{
  "One of the main issues in writing an external program which communicates \
directly with the ",
  StyleBox["Mathematica", "TI"],
  " kernel is handling all the various kinds of packets that the kernel can \
generate. "
}], "Text",
  CellTags->{"S2.13.14", "14.22"}],

Cell[TextData[{
  "The function ",
  StyleBox["MLNextPacket()", "MR"],
  " finds the head of the next packet that comes from the kernel, and returns \
a constant that indicates the type of the packet. "
}], "Text",
  CellTags->{"S2.13.14", "14.23"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              StyleBox[" packet", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["constant", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["ReturnPacket[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["RETURNPKT", "MR"],
              " "
            }]], Cell["result from a computation "]},
          {Cell[TextData[{
              StyleBox["ReturnTextPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["RETURNTEXTPKT", "MR"],
              " "
            }]], Cell["textual form of a result "]},
          {Cell[TextData[{
              StyleBox["InputNamePacket[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["INPUTNAMEPKT", "MR"],
              " "
            }]], Cell["name of an input line "]},
          {Cell[TextData[{
              StyleBox["OutputNamePacket[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["OUTPUTNAMEPKT", "MR"],
              " "
            }]], Cell["name of an output line "]},
          {Cell[TextData[{
              StyleBox["TextPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["TEXTPKT", "MR"],
              " "
            }]], Cell[TextData[{
              "textual output from functions like ",
              StyleBox["Print", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MessagePacket[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["tag", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MESSAGEPKT", "MR"],
              " "
            }]], Cell[TextData[{
              "name of a message generated by ",
              StyleBox["Mathematica", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["DisplayPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["DISPLAYPKT", "MR"],
              " "
            }]], Cell["part of PostScript graphics "]},
          {Cell[TextData[{
              StyleBox["DisplayEndPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["DISPLAYENDPKT", "MR"],
              " "
            }]], Cell["end of PostScript graphics "]},
          {Cell[TextData[{
              StyleBox["InputPacket[\"", "MR"],
              StyleBox["prompt", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["INPUTPKT", "MR"],
              " "
            }]], Cell[TextData[{
              "request for a response to an ",
              StyleBox["Input", "MR"],
              " function "
            }]]},
          {Cell[TextData[{
              StyleBox["CallPacket[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["CALLPKT", "MR"],
              " "
            }]], Cell["request for a call to an external function "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, False, False, False, False, False, False, False, True, False}},
  CellTags->"S2.13.14"],

Cell[TextData[{
  "Some packets recognized by ",
  StyleBox["MLNextPacket()", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.13.14"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.14", "14.24"}],

Cell[TextData[{
  "This keeps on reading data from a link, discarding it until an error or a \
",
  StyleBox["ReturnPacket", "MR"],
  " is found. "
}], "MathCaption",
  CellTags->{"S2.13.14", "14.25"}],

Cell["\<\
while ((p = MLNextPacket(link)) && p != RETURNPKT)
    MLNewPacket(link);\
\>", "Program",
  CellTags->{"S2.13.14", "14.26"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.14", "14.27"}],

Cell[TextData[{
  "If you want to write a complete front end to ",
  StyleBox["Mathematica", "TI"],
  ", you will need to handle all of the possible types of packets that the \
kernel can generate. Typically you can do this by setting up an appropriate \
",
  StyleBox["switch", "MR"],
  " on the value returned by ",
  StyleBox["MLNextPacket()", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.14", "14.28"}],

Cell[TextData[{
  "The ",
  StyleBox["MathLink", "TI"],
  " Developer Kit contains sample source code for several simple but complete \
front ends. "
}], "Text",
  CellTags->{"S2.13.14", "14.29"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLReady(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[
            "test whether there is data waiting to be read on a link "]},
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLFlush(MLINK", "MR"],
              " ",
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
flush out buffers containing data waiting to be sent on \
a link\
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.14"],

Cell["Flow of data on links. ", "Caption",
  CellTags->"S2.13.14"],

Cell[TextData[{
  "One feature of more sophisticated external programs such as front ends is \
that they may need to perform operations while they are waiting for data to \
be sent to them by ",
  StyleBox["Mathematica", "TI"],
  ". When you call a standard ",
  StyleBox["MathLink", "TI"],
  " library function such as ",
  StyleBox["MLNextPacket()", "MR"],
  " your program will normally block until all the data needed by this \
function is available.   "
}], "Text",
  CellTags->{"S2.13.14", "14.30"}],

Cell[TextData[{
  "You can avoid blocking by repeatedly calling ",
  StyleBox["MLReady()", "MR"],
  ", and only calling functions like ",
  StyleBox["MLNextPacket()", "MR"],
  " when ",
  StyleBox["MLReady()", "MR"],
  " no longer returns ",
  StyleBox["0", "MR"],
  ". ",
  StyleBox["MLReady()", "MR"],
  " is the analog of the ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["LinkReadyQ", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.14", "14.31"}],

Cell[TextData[{
  "Note that ",
  StyleBox["MathLink", "TI"],
  " sometimes buffers the data that you tell it to send. To make sure that \
all necessary data has been sent you should call ",
  StyleBox["MLFlush()", "MR"],
  ". Only after doing this does it make sense to call ",
  StyleBox["MLReady()", "MR"],
  " and wait for data to be sent back. "
}], "Text",
  CellTags->{"S2.13.14", "14.32"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.13.0"->{
    Cell[1776, 53, 171, 5, 91, "Section",
      CellTags->{"S2.13.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 171, 5, 91, "Section",
      CellTags->{"S2.13.0", "0.1"}]},
  "S2.13.1"->{
    Cell[1972, 62, 126, 5, 70, "Subsection",
      CellTags->{"S2.13.1", "1.1"}],
    Cell[2101, 69, 368, 11, 70, "Text",
      CellTags->{"S2.13.1", "1.2"}],
    Cell[2472, 82, 1172, 33, 70, "FramedBox",
      CellTags->"S2.13.1"],
    Cell[3647, 117, 117, 5, 70, "Caption",
      CellTags->"S2.13.1"],
    Cell[3767, 124, 354, 8, 70, "Text",
      CellTags->{"S2.13.1", "1.3"}],
    Cell[4124, 134, 315, 9, 70, "Text",
      CellTags->{"S2.13.1", "1.4"}],
    Cell[4442, 145, 242, 8, 70, "Text",
      CellTags->{"S2.13.1", "1.5"}],
    Cell[4687, 155, 193, 5, 70, "Text",
      CellTags->{"S2.13.1", "1.6"}],
    Cell[4883, 162, 850, 28, 70, "FramedBox",
      CellTags->"S2.13.1"],
    Cell[5736, 192, 138, 5, 70, "Caption",
      CellTags->"S2.13.1"],
    Cell[5877, 199, 565, 14, 70, "Text",
      CellTags->{"S2.13.1", "1.7"}],
    Cell[6445, 215, 462, 13, 70, "FramedBox",
      CellTags->"S2.13.1"],
    Cell[6910, 230, 114, 5, 70, "Caption",
      CellTags->"S2.13.1"],
    Cell[7027, 237, 420, 12, 70, "Text",
      CellTags->{"S2.13.1", "1.8"}],
    Cell[7450, 251, 727, 20, 70, "FramedBox",
      CellTags->"S2.13.1"],
    Cell[8180, 273, 189, 7, 70, "Caption",
      CellTags->"S2.13.1"],
    Cell[8372, 282, 255, 8, 70, "Text",
      CellTags->{"S2.13.1", "1.9"}],
    Cell[8630, 292, 309, 7, 70, "Text",
      CellTags->{"S2.13.1", "1.10"}],
    Cell[8942, 301, 292, 7, 70, "Text",
      CellTags->{"S2.13.1", "1.11"}]},
  "1.1"->{
    Cell[1972, 62, 126, 5, 70, "Subsection",
      CellTags->{"S2.13.1", "1.1"}]},
  "1.2"->{
    Cell[2101, 69, 368, 11, 70, "Text",
      CellTags->{"S2.13.1", "1.2"}]},
  "1.3"->{
    Cell[3767, 124, 354, 8, 70, "Text",
      CellTags->{"S2.13.1", "1.3"}]},
  "1.4"->{
    Cell[4124, 134, 315, 9, 70, "Text",
      CellTags->{"S2.13.1", "1.4"}]},
  "1.5"->{
    Cell[4442, 145, 242, 8, 70, "Text",
      CellTags->{"S2.13.1", "1.5"}]},
  "1.6"->{
    Cell[4687, 155, 193, 5, 70, "Text",
      CellTags->{"S2.13.1", "1.6"}]},
  "1.7"->{
    Cell[5877, 199, 565, 14, 70, "Text",
      CellTags->{"S2.13.1", "1.7"}]},
  "1.8"->{
    Cell[7027, 237, 420, 12, 70, "Text",
      CellTags->{"S2.13.1", "1.8"}]},
  "1.9"->{
    Cell[8372, 282, 255, 8, 70, "Text",
      CellTags->{"S2.13.1", "1.9"}]},
  "1.10"->{
    Cell[8630, 292, 309, 7, 70, "Text",
      CellTags->{"S2.13.1", "1.10"}]},
  "1.11"->{
    Cell[8942, 301, 292, 7, 70, "Text",
      CellTags->{"S2.13.1", "1.11"}]},
  "S2.13.2"->{
    Cell[9271, 313, 162, 5, 70, "Subsection",
      CellTags->{"S2.13.2", "2.1"}],
    Cell[9436, 320, 455, 11, 70, "Text",
      CellTags->{"S2.13.2", "2.2"}],
    Cell[9894, 333, 756, 22, 70, "DefinitionBox",
      CellTags->"S2.13.2"],
    Cell[10653, 357, 168, 5, 70, "Caption",
      CellTags->"S2.13.2"],
    Cell[10824, 364, 204, 7, 70, "MathCaption",
      CellTags->{"S2.13.2", "2.3"}],
    Cell[11053, 375, 85, 2, 70, "Input",
      CellTags->"S2.13.2"],
    Cell[11141, 379, 111, 3, 70, "Output",
      CellTags->"S2.13.2"],
    Cell[11267, 385, 170, 6, 70, "MathCaption",
      CellTags->{"S2.13.2", "2.4"}],
    Cell[11462, 395, 81, 2, 70, "Input",
      CellTags->"S2.13.2"],
    Cell[11546, 399, 84, 3, 70, "Output",
      CellTags->"S2.13.2"],
    Cell[11645, 405, 163, 5, 70, "MathCaption",
      CellTags->{"S2.13.2", "2.5"}],
    Cell[11833, 414, 101, 2, 70, "Input",
      CellTags->"S2.13.2"],
    Cell[11937, 418, 105, 3, 70, "Output",
      CellTags->"S2.13.2"],
    Cell[12057, 424, 317, 7, 70, "Text",
      CellTags->{"S2.13.2", "2.6"}],
    Cell[12377, 433, 536, 13, 70, "Text",
      CellTags->{"S2.13.2", "2.7"}],
    Cell[12916, 448, 464, 14, 70, "DefinitionBox",
      CellTags->"S2.13.2"],
    Cell[13383, 464, 94, 1, 70, "Caption",
      CellTags->"S2.13.2"],
    Cell[13480, 467, 974, 30, 70, "Text",
      CellTags->{"S2.13.2", "2.8"}]},
  "2.1"->{
    Cell[9271, 313, 162, 5, 70, "Subsection",
      CellTags->{"S2.13.2", "2.1"}]},
  "2.2"->{
    Cell[9436, 320, 455, 11, 70, "Text",
      CellTags->{"S2.13.2", "2.2"}]},
  "2.3"->{
    Cell[10824, 364, 204, 7, 70, "MathCaption",
      CellTags->{"S2.13.2", "2.3"}]},
  "2.4"->{
    Cell[11267, 385, 170, 6, 70, "MathCaption",
      CellTags->{"S2.13.2", "2.4"}]},
  "2.5"->{
    Cell[11645, 405, 163, 5, 70, "MathCaption",
      CellTags->{"S2.13.2", "2.5"}]},
  "2.6"->{
    Cell[12057, 424, 317, 7, 70, "Text",
      CellTags->{"S2.13.2", "2.6"}]},
  "2.7"->{
    Cell[12377, 433, 536, 13, 70, "Text",
      CellTags->{"S2.13.2", "2.7"}]},
  "2.8"->{
    Cell[13480, 467, 974, 30, 70, "Text",
      CellTags->{"S2.13.2", "2.8"}]},
  "S2.13.3"->{
    Cell[14491, 502, 159, 4, 70, "Subsection",
      CellTags->{"S2.13.3", "3.1"}],
    Cell[14653, 508, 393, 9, 70, "Text",
      CellTags->{"S2.13.3", "3.2"}],
    Cell[15049, 519, 253, 8, 70, "Text",
      CellTags->{"S2.13.3", "3.3"}],
    Cell[15305, 529, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.4"}],
    Cell[15363, 532, 212, 9, 70, "Program",
      CellTags->{"S2.13.3", "3.5"}],
    Cell[15578, 543, 58, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.6"}],
    Cell[15639, 546, 212, 9, 70, "Caption",
      CellTags->"S2.13.3"],
    Cell[15854, 557, 1622, 41, 70, "DefinitionBox",
      CellTags->"S2.13.3"],
    Cell[17479, 600, 123, 5, 70, "Caption",
      CellTags->"S2.13.3"],
    Cell[17605, 607, 513, 12, 70, "Text",
      CellTags->{"S2.13.3", "3.7"}],
    Cell[18121, 621, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.8"}],
    Cell[18179, 624, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.9"}],
    Cell[18324, 631, 84, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.10"}],
    Cell[18411, 637, 150, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.11"}],
    Cell[18564, 644, 326, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.12"}],
    Cell[18893, 658, 181, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.13"}],
    Cell[19077, 665, 354, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.14"}],
    Cell[19434, 679, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.15"}],
    Cell[19496, 682, 123, 5, 70, "Caption",
      CellTags->"S2.13.3"],
    Cell[19622, 689, 335, 9, 70, "Text",
      CellTags->{"S2.13.3", "3.16"}],
    Cell[19960, 700, 689, 22, 70, "DefinitionBox",
      CellTags->"S2.13.3"],
    Cell[20652, 724, 150, 5, 70, "Caption",
      CellTags->"S2.13.3"],
    Cell[20805, 731, 321, 8, 70, "Text",
      CellTags->{"S2.13.3", "3.17"}],
    Cell[21129, 741, 353, 8, 70, "Text",
      CellTags->{"S2.13.3", "3.18"}],
    Cell[21485, 751, 545, 17, 70, "Text",
      CellTags->{"S2.13.3", "3.19"}],
    Cell[22033, 770, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.20"}],
    Cell[22092, 773, 222, 7, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.21"}],
    Cell[22317, 782, 73, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.22"}],
    Cell[22393, 785, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.23"}],
    Cell[22455, 788, 161, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.24"}],
    Cell[22641, 797, 83, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[22727, 801, 107, 3, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[22849, 807, 394, 18, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.25"}],
    Cell[23268, 829, 72, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[23343, 833, 84, 3, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[23442, 839, 151, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.26"}],
    Cell[23618, 847, 77, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[23698, 851, 97, 3, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[23810, 857, 461, 12, 70, "Text",
      CellTags->{"S2.13.3", "3.27"}],
    Cell[24274, 871, 1505, 43, 70, "DefinitionBox",
      CellTags->"S2.13.3"],
    Cell[25782, 916, 79, 1, 70, "Caption",
      CellTags->"S2.13.3"],
    Cell[25864, 919, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.28"}],
    Cell[26031, 928, 81, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[26115, 932, 111, 3, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[26241, 938, 174, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.29"}],
    Cell[26440, 947, 85, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[26528, 951, 158, 5, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[26701, 959, 237, 8, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.30"}],
    Cell[26963, 971, 67, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[27033, 975, 66, 2, 70, "Print",
      CellTags->"S2.13.3"],
    Cell[27102, 979, 536, 15, 70, "Print",
      CellTags->"S2.13.3"],
    Cell[27653, 997, 671, 20, 70, "Text",
      CellTags->{"S2.13.3", "3.31"}],
    Cell[28327, 1019, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.32"}],
    Cell[28386, 1022, 59, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.33"}],
    Cell[28448, 1025, 143, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.34"}],
    Cell[28594, 1031, 76, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.35"}],
    Cell[28673, 1034, 175, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.36"}],
    Cell[28851, 1041, 99, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.37"}],
    Cell[28953, 1044, 166, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.38"}],
    Cell[29122, 1050, 330, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.39"}],
    Cell[29455, 1064, 147, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.40"}],
    Cell[29605, 1070, 320, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.41"}],
    Cell[29928, 1084, 142, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.42"}],
    Cell[30073, 1090, 75, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.43"}],
    Cell[30151, 1093, 57, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.44"}],
    Cell[30211, 1096, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.45"}],
    Cell[30273, 1099, 522, 15, 70, "Text",
      CellTags->{"S2.13.3", "3.46"}],
    Cell[30798, 1116, 282, 6, 70, "Text",
      CellTags->{"S2.13.3", "3.47"}],
    Cell[31083, 1124, 409, 10, 70, "Text",
      CellTags->{"S2.13.3", "3.48"}],
    Cell[31495, 1136, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.49"}],
    Cell[31554, 1139, 204, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.50"}],
    Cell[31761, 1146, 164, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.51"}],
    Cell[31928, 1152, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.52"}],
    Cell[31990, 1155, 456, 11, 70, "Text",
      CellTags->{"S2.13.3", "3.53"}],
    Cell[32449, 1168, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.54"}],
    Cell[32508, 1171, 208, 6, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.55"}],
    Cell[32719, 1179, 261, 7, 70, "Program",
      CellTags->{"S2.13.3", "3.56"}],
    Cell[32983, 1188, 274, 9, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.57"}],
    Cell[33260, 1199, 686, 24, 70, "Program",
      CellTags->{"S2.13.3", "3.58"}],
    Cell[33949, 1225, 284, 10, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.59"}],
    Cell[34236, 1237, 658, 24, 70, "Program",
      CellTags->{"S2.13.3", "3.60"}],
    Cell[34897, 1263, 250, 6, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.61"}],
    Cell[35150, 1271, 104, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.62"}],
    Cell[35257, 1277, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.63"}],
    Cell[35319, 1280, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.64"}],
    Cell[35378, 1283, 290, 8, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.65"}],
    Cell[35671, 1293, 336, 13, 70, "Program",
      CellTags->{"S2.13.3", "3.66"}],
    Cell[36010, 1308, 336, 11, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.67"}],
    Cell[36349, 1321, 325, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.68"}],
    Cell[36677, 1335, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.69"}],
    Cell[36739, 1338, 549, 14, 70, "Text",
      CellTags->{"S2.13.3", "3.70"}],
    Cell[37291, 1354, 600, 18, 70, "DefinitionBox",
      CellTags->"S2.13.3"],
    Cell[37894, 1374, 154, 5, 70, "Caption",
      CellTags->"S2.13.3"],
    Cell[38051, 1381, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.71"}],
    Cell[38110, 1384, 76, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.72"}],
    Cell[38189, 1387, 265, 13, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.73"}],
    Cell[38457, 1402, 132, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.74"}],
    Cell[38592, 1408, 79, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.75"}],
    Cell[38674, 1414, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.76"}],
    Cell[38736, 1417, 178, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.77"}],
    Cell[38939, 1426, 86, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[39028, 1430, 112, 3, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[39155, 1436, 170, 7, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.78"}],
    Cell[39350, 1447, 75, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[39428, 1451, 66, 2, 70, "Print",
      CellTags->"S2.13.3"],
    Cell[39497, 1455, 88, 3, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[39600, 1461, 474, 12, 70, "Text",
      CellTags->{"S2.13.3", "3.79"}]},
  "3.1"->{
    Cell[14491, 502, 159, 4, 70, "Subsection",
      CellTags->{"S2.13.3", "3.1"}]},
  "3.2"->{
    Cell[14653, 508, 393, 9, 70, "Text",
      CellTags->{"S2.13.3", "3.2"}]},
  "3.3"->{
    Cell[15049, 519, 253, 8, 70, "Text",
      CellTags->{"S2.13.3", "3.3"}]},
  "3.4"->{
    Cell[15305, 529, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.4"}]},
  "3.5"->{
    Cell[15363, 532, 212, 9, 70, "Program",
      CellTags->{"S2.13.3", "3.5"}]},
  "3.6"->{
    Cell[15578, 543, 58, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.6"}]},
  "3.7"->{
    Cell[17605, 607, 513, 12, 70, "Text",
      CellTags->{"S2.13.3", "3.7"}]},
  "3.8"->{
    Cell[18121, 621, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.8"}]},
  "3.9"->{
    Cell[18179, 624, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.9"}]},
  "3.10"->{
    Cell[18324, 631, 84, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.10"}]},
  "3.11"->{
    Cell[18411, 637, 150, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.11"}]},
  "3.12"->{
    Cell[18564, 644, 326, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.12"}]},
  "3.13"->{
    Cell[18893, 658, 181, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.13"}]},
  "3.14"->{
    Cell[19077, 665, 354, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.14"}]},
  "3.15"->{
    Cell[19434, 679, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.15"}]},
  "3.16"->{
    Cell[19622, 689, 335, 9, 70, "Text",
      CellTags->{"S2.13.3", "3.16"}]},
  "3.17"->{
    Cell[20805, 731, 321, 8, 70, "Text",
      CellTags->{"S2.13.3", "3.17"}]},
  "3.18"->{
    Cell[21129, 741, 353, 8, 70, "Text",
      CellTags->{"S2.13.3", "3.18"}]},
  "3.19"->{
    Cell[21485, 751, 545, 17, 70, "Text",
      CellTags->{"S2.13.3", "3.19"}]},
  "3.20"->{
    Cell[22033, 770, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.20"}]},
  "3.21"->{
    Cell[22092, 773, 222, 7, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.21"}]},
  "3.22"->{
    Cell[22317, 782, 73, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.22"}]},
  "3.23"->{
    Cell[22393, 785, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.23"}]},
  "3.24"->{
    Cell[22455, 788, 161, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.24"}]},
  "3.25"->{
    Cell[22849, 807, 394, 18, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.25"}]},
  "3.26"->{
    Cell[23442, 839, 151, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.26"}]},
  "3.27"->{
    Cell[23810, 857, 461, 12, 70, "Text",
      CellTags->{"S2.13.3", "3.27"}]},
  "3.28"->{
    Cell[25864, 919, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.28"}]},
  "3.29"->{
    Cell[26241, 938, 174, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.29"}]},
  "3.30"->{
    Cell[26701, 959, 237, 8, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.30"}]},
  "3.31"->{
    Cell[27653, 997, 671, 20, 70, "Text",
      CellTags->{"S2.13.3", "3.31"}]},
  "3.32"->{
    Cell[28327, 1019, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.32"}]},
  "3.33"->{
    Cell[28386, 1022, 59, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.33"}]},
  "3.34"->{
    Cell[28448, 1025, 143, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.34"}]},
  "3.35"->{
    Cell[28594, 1031, 76, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.35"}]},
  "3.36"->{
    Cell[28673, 1034, 175, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.36"}]},
  "3.37"->{
    Cell[28851, 1041, 99, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.37"}]},
  "3.38"->{
    Cell[28953, 1044, 166, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.38"}]},
  "3.39"->{
    Cell[29122, 1050, 330, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.39"}]},
  "3.40"->{
    Cell[29455, 1064, 147, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.40"}]},
  "3.41"->{
    Cell[29605, 1070, 320, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.41"}]},
  "3.42"->{
    Cell[29928, 1084, 142, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.42"}]},
  "3.43"->{
    Cell[30073, 1090, 75, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.43"}]},
  "3.44"->{
    Cell[30151, 1093, 57, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.44"}]},
  "3.45"->{
    Cell[30211, 1096, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.45"}]},
  "3.46"->{
    Cell[30273, 1099, 522, 15, 70, "Text",
      CellTags->{"S2.13.3", "3.46"}]},
  "3.47"->{
    Cell[30798, 1116, 282, 6, 70, "Text",
      CellTags->{"S2.13.3", "3.47"}]},
  "3.48"->{
    Cell[31083, 1124, 409, 10, 70, "Text",
      CellTags->{"S2.13.3", "3.48"}]},
  "3.49"->{
    Cell[31495, 1136, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.49"}]},
  "3.50"->{
    Cell[31554, 1139, 204, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.50"}]},
  "3.51"->{
    Cell[31761, 1146, 164, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.51"}]},
  "3.52"->{
    Cell[31928, 1152, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.52"}]},
  "3.53"->{
    Cell[31990, 1155, 456, 11, 70, "Text",
      CellTags->{"S2.13.3", "3.53"}]},
  "3.54"->{
    Cell[32449, 1168, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.54"}]},
  "3.55"->{
    Cell[32508, 1171, 208, 6, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.55"}]},
  "3.56"->{
    Cell[32719, 1179, 261, 7, 70, "Program",
      CellTags->{"S2.13.3", "3.56"}]},
  "3.57"->{
    Cell[32983, 1188, 274, 9, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.57"}]},
  "3.58"->{
    Cell[33260, 1199, 686, 24, 70, "Program",
      CellTags->{"S2.13.3", "3.58"}]},
  "3.59"->{
    Cell[33949, 1225, 284, 10, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.59"}]},
  "3.60"->{
    Cell[34236, 1237, 658, 24, 70, "Program",
      CellTags->{"S2.13.3", "3.60"}]},
  "3.61"->{
    Cell[34897, 1263, 250, 6, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.61"}]},
  "3.62"->{
    Cell[35150, 1271, 104, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.62"}]},
  "3.63"->{
    Cell[35257, 1277, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.63"}]},
  "3.64"->{
    Cell[35319, 1280, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.64"}]},
  "3.65"->{
    Cell[35378, 1283, 290, 8, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.65"}]},
  "3.66"->{
    Cell[35671, 1293, 336, 13, 70, "Program",
      CellTags->{"S2.13.3", "3.66"}]},
  "3.67"->{
    Cell[36010, 1308, 336, 11, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.67"}]},
  "3.68"->{
    Cell[36349, 1321, 325, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.68"}]},
  "3.69"->{
    Cell[36677, 1335, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.69"}]},
  "3.70"->{
    Cell[36739, 1338, 549, 14, 70, "Text",
      CellTags->{"S2.13.3", "3.70"}]},
  "3.71"->{
    Cell[38051, 1381, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.71"}]},
  "3.72"->{
    Cell[38110, 1384, 76, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.72"}]},
  "3.73"->{
    Cell[38189, 1387, 265, 13, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.73"}]},
  "3.74"->{
    Cell[38457, 1402, 132, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.74"}]},
  "3.75"->{
    Cell[38592, 1408, 79, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.75"}]},
  "3.76"->{
    Cell[38674, 1414, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.76"}]},
  "3.77"->{
    Cell[38736, 1417, 178, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.77"}]},
  "3.78"->{
    Cell[39155, 1436, 170, 7, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.78"}]},
  "3.79"->{
    Cell[39600, 1461, 474, 12, 70, "Text",
      CellTags->{"S2.13.3", "3.79"}]},
  "S2.13.4"->{
    Cell[40111, 1478, 105, 1, 70, "Subsection",
      CellTags->{"S2.13.4", "4.1"}],
    Cell[40219, 1481, 391, 11, 70, "Text",
      CellTags->{"S2.13.4", "4.2"}],
    Cell[40613, 1494, 2536, 82, 70, "DefinitionBox3Col",
      CellTags->"S2.13.4"],
    Cell[43152, 1578, 69, 1, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[43224, 1581, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.3"}],
    Cell[43282, 1584, 191, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.4"}],
    Cell[43476, 1591, 661, 24, 70, "Program",
      CellTags->{"S2.13.4", "4.5"}],
    Cell[44140, 1617, 218, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.6"}],
    Cell[44361, 1624, 402, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.7"}],
    Cell[44766, 1639, 58, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.8"}],
    Cell[44827, 1642, 185, 6, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.9"}],
    Cell[45037, 1652, 83, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[45123, 1656, 109, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[45247, 1662, 86, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.10"}],
    Cell[45358, 1667, 77, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[45438, 1671, 84, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[45537, 1677, 178, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.11"}],
    Cell[45740, 1686, 70, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[45813, 1690, 87, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[45915, 1696, 224, 6, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.12"}],
    Cell[46164, 1706, 77, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[46244, 1710, 89, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[46348, 1716, 327, 9, 70, "Text",
      CellTags->{"S2.13.4", "4.13"}],
    Cell[46678, 1727, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.14"}],
    Cell[46737, 1730, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.15"}],
    Cell[46882, 1737, 343, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.16"}],
    Cell[47228, 1752, 115, 2, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.17"}],
    Cell[47346, 1756, 106, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.18"}],
    Cell[47455, 1759, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.19"}],
    Cell[47517, 1762, 311, 8, 70, "Text",
      CellTags->{"S2.13.4", "4.20"}],
    Cell[47831, 1772, 490, 15, 70, "Text",
      CellTags->{"S2.13.4", "4.21"}],
    Cell[48324, 1789, 5277, 167, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[53604, 1958, 160, 6, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[53767, 1966, 649, 19, 70, "Text",
      CellTags->{"S2.13.4", "4.22"}],
    Cell[54419, 1987, 869, 25, 70, "Text",
      CellTags->{"S2.13.4", "4.23"}],
    Cell[55291, 2014, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.24"}],
    Cell[55350, 2017, 270, 8, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.25"}],
    Cell[55623, 2027, 666, 24, 70, "Program",
      CellTags->{"S2.13.4", "4.26"}],
    Cell[56292, 2053, 134, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.27"}],
    Cell[56429, 2060, 97, 6, 70, "Program",
      CellTags->{"S2.13.4", "4.28"}],
    Cell[56529, 2068, 136, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.29"}],
    Cell[56668, 2075, 407, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.30"}],
    Cell[57078, 2090, 214, 9, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.31"}],
    Cell[57295, 2101, 111, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.32"}],
    Cell[57409, 2108, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.33"}],
    Cell[57471, 2111, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.34"}],
    Cell[57661, 2120, 86, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[57750, 2124, 108, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[57873, 2130, 106, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.35"}],
    Cell[58004, 2135, 73, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[58080, 2139, 94, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[58189, 2145, 463, 18, 70, "Text",
      CellTags->{"S2.13.4", "4.36"}],
    Cell[58655, 2165, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.37"}],
    Cell[58714, 2168, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.38"}],
    Cell[58772, 2171, 124, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.39"}],
    Cell[58899, 2177, 73, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.40"}],
    Cell[58975, 2180, 199, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.41"}],
    Cell[59177, 2189, 322, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.42"}],
    Cell[59502, 2204, 67, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.43"}],
    Cell[59572, 2210, 214, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.44"}],
    Cell[59789, 2219, 101, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.45"}],
    Cell[59893, 2222, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.46"}],
    Cell[59951, 2225, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.47"}],
    Cell[60013, 2228, 431, 13, 70, "Text",
      CellTags->{"S2.13.4", "4.48"}],
    Cell[60447, 2243, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.49"}],
    Cell[60506, 2246, 189, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.50"}],
    Cell[60698, 2255, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.51"}],
    Cell[60789, 2258, 157, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.52"}],
    Cell[60949, 2265, 78, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.53"}],
    Cell[61030, 2268, 161, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.54"}],
    Cell[61194, 2275, 80, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.55"}],
    Cell[61277, 2278, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.56"}],
    Cell[61339, 2281, 583, 16, 70, "Text",
      CellTags->{"S2.13.4", "4.57"}],
    Cell[61925, 2299, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.58"}],
    Cell[61984, 2302, 149, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.59"}],
    Cell[62136, 2309, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.60"}],
    Cell[62227, 2312, 175, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.61"}],
    Cell[62405, 2319, 85, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.62"}],
    Cell[62493, 2322, 136, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.63"}],
    Cell[62632, 2328, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.64"}],
    Cell[62723, 2331, 136, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.65"}],
    Cell[62862, 2337, 76, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.66"}],
    Cell[62941, 2340, 90, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.67"}],
    Cell[63034, 2343, 78, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.68"}],
    Cell[63115, 2346, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.69"}],
    Cell[63177, 2349, 626, 15, 70, "Text",
      CellTags->{"S2.13.4", "4.70"}],
    Cell[63806, 2366, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.71"}],
    Cell[63865, 2369, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.72"}],
    Cell[63923, 2372, 167, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.73"}],
    Cell[64093, 2379, 61, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.74"}],
    Cell[64157, 2382, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.75"}],
    Cell[64215, 2385, 178, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.76"}],
    Cell[64396, 2394, 89, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.77"}],
    Cell[64488, 2397, 74, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.78"}],
    Cell[64565, 2400, 141, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.79"}],
    Cell[64709, 2407, 93, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.80"}],
    Cell[64805, 2410, 78, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.81"}],
    Cell[64886, 2413, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.82"}],
    Cell[64980, 2416, 99, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.83"}],
    Cell[65082, 2419, 67, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.84"}],
    Cell[65152, 2425, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.85"}],
    Cell[65210, 2428, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.86"}],
    Cell[65272, 2431, 763, 20, 70, "Text",
      CellTags->{"S2.13.4", "4.87"}],
    Cell[66038, 2453, 268, 6, 70, "Text",
      CellTags->{"S2.13.4", "4.88"}],
    Cell[66309, 2461, 180, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.89"}],
    Cell[66514, 2470, 106, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[66623, 2474, 99, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[66737, 2480, 143, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.90"}],
    Cell[66905, 2488, 100, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[67008, 2492, 111, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[67134, 2498, 125, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.91"}],
    Cell[67284, 2506, 75, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[67362, 2510, 99, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[67476, 2516, 134, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.92"}],
    Cell[67635, 2524, 105, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[67743, 2528, 89, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[67847, 2534, 346, 9, 70, "Text",
      CellTags->{"S2.13.4", "4.93"}],
    Cell[68196, 2545, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.94"}],
    Cell[68255, 2548, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.95"}],
    Cell[68400, 2555, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.96"}],
    Cell[68491, 2558, 164, 6, 70, "Program",
      CellTags->{"S2.13.4", "4.97"}],
    Cell[68658, 2566, 139, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.98"}],
    Cell[68800, 2573, 96, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.99"}],
    Cell[68899, 2576, 74, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.100"}],
    Cell[68976, 2579, 128, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.101"}],
    Cell[69107, 2586, 54, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.102"}],
    Cell[69164, 2589, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.103"}],
    Cell[69311, 2596, 93, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.104"}],
    Cell[69407, 2599, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.105"}],
    Cell[69470, 2602, 1106, 34, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[70579, 2638, 148, 5, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[70730, 2645, 472, 15, 70, "Text",
      CellTags->{"S2.13.4", "4.106"}],
    Cell[71205, 2662, 389, 12, 70, "Text",
      CellTags->{"S2.13.4", "4.107"}],
    Cell[71597, 2676, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.108"}],
    Cell[71657, 2679, 87, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.109"}],
    Cell[71747, 2685, 178, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.110"}],
    Cell[71928, 2694, 98, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.111"}],
    Cell[72029, 2697, 131, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.112"}],
    Cell[72163, 2703, 313, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.113"}],
    Cell[72479, 2717, 134, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.114"}],
    Cell[72616, 2723, 321, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.115"}],
    Cell[72940, 2737, 89, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.116"}],
    Cell[73032, 2744, 113, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.117"}],
    Cell[73148, 2747, 79, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.118"}],
    Cell[73230, 2753, 166, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.119"}],
    Cell[73399, 2762, 77, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.120"}],
    Cell[73479, 2768, 143, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.121"}],
    Cell[73625, 2774, 115, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.122"}],
    Cell[73743, 2781, 79, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.123"}],
    Cell[73825, 2787, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.124"}],
    Cell[73888, 2790, 641, 22, 70, "Text",
      CellTags->{"S2.13.4", "4.125"}],
    Cell[74532, 2814, 735, 24, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[75270, 2840, 119, 5, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[75392, 2847, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.126"}],
    Cell[75452, 2850, 87, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.127"}],
    Cell[75542, 2856, 200, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.128"}],
    Cell[75745, 2865, 327, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.129"}],
    Cell[76075, 2880, 109, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.130"}],
    Cell[76187, 2883, 307, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.131"}],
    Cell[76497, 2897, 133, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.132"}],
    Cell[76633, 2903, 312, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.133"}],
    Cell[76948, 2917, 92, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.134"}],
    Cell[77043, 2924, 108, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.135"}],
    Cell[77154, 2927, 75, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.136"}],
    Cell[77232, 2933, 88, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.137"}],
    Cell[77323, 2936, 92, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.138"}],
    Cell[77418, 2943, 197, 6, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.139"}],
    Cell[77618, 2951, 105, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.140"}],
    Cell[77726, 2957, 156, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.141"}],
    Cell[77885, 2964, 117, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.142"}],
    Cell[78005, 2970, 66, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.143"}],
    Cell[78074, 2976, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.144"}],
    Cell[78137, 2979, 429, 9, 70, "Text",
      CellTags->{"S2.13.4", "4.145"}],
    Cell[78569, 2990, 253, 6, 70, "Text",
      CellTags->{"S2.13.4", "4.146"}],
    Cell[78825, 2998, 2465, 80, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[81293, 3080, 68, 1, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[81364, 3083, 487, 16, 70, "Text",
      CellTags->{"S2.13.4", "4.147"}],
    Cell[81854, 3101, 240, 5, 70, "Text",
      CellTags->{"S2.13.4", "4.148"}],
    Cell[82097, 3108, 550, 18, 70, "Text",
      CellTags->{"S2.13.4", "4.149"}],
    Cell[82650, 3128, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.150"}],
    Cell[82710, 3131, 133, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.151"}],
    Cell[82846, 3137, 75, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.152"}],
    Cell[82924, 3143, 159, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.153"}],
    Cell[83086, 3150, 85, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.154"}],
    Cell[83174, 3157, 168, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.155"}],
    Cell[83345, 3164, 100, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.156"}],
    Cell[83448, 3170, 56, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.157"}],
    Cell[83507, 3173, 119, 2, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.158"}],
    Cell[83629, 3177, 92, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.159"}],
    Cell[83724, 3180, 66, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.160"}],
    Cell[83793, 3186, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.161"}],
    Cell[83856, 3189, 522, 14, 70, "Text",
      CellTags->{"S2.13.4", "4.162"}],
    Cell[84381, 3205, 3870, 124, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[88254, 3331, 69, 1, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[88326, 3334, 405, 10, 70, "Text",
      CellTags->{"S2.13.4", "4.163"}],
    Cell[88734, 3346, 563, 21, 70, "Text",
      CellTags->{"S2.13.4", "4.164"}],
    Cell[89300, 3369, 518, 16, 70, "Text",
      CellTags->{"S2.13.4", "4.165"}],
    Cell[89821, 3387, 342, 10, 70, "Text",
      CellTags->{"S2.13.4", "4.166"}],
    Cell[90166, 3399, 1594, 46, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[91763, 3447, 86, 1, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[91852, 3450, 461, 12, 70, "Text",
      CellTags->{"S2.13.4", "4.167"}],
    Cell[92316, 3464, 501, 11, 70, "Text",
      CellTags->{"S2.13.4", "4.168"}],
    Cell[92820, 3477, 1290, 38, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[94113, 3517, 73, 1, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[94189, 3520, 553, 14, 70, "Text",
      CellTags->{"S2.13.4", "4.169"}]},
  "4.1"->{
    Cell[40111, 1478, 105, 1, 70, "Subsection",
      CellTags->{"S2.13.4", "4.1"}]},
  "4.2"->{
    Cell[40219, 1481, 391, 11, 70, "Text",
      CellTags->{"S2.13.4", "4.2"}]},
  "4.3"->{
    Cell[43224, 1581, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.3"}]},
  "4.4"->{
    Cell[43282, 1584, 191, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.4"}]},
  "4.5"->{
    Cell[43476, 1591, 661, 24, 70, "Program",
      CellTags->{"S2.13.4", "4.5"}]},
  "4.6"->{
    Cell[44140, 1617, 218, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.6"}]},
  "4.7"->{
    Cell[44361, 1624, 402, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.7"}]},
  "4.8"->{
    Cell[44766, 1639, 58, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.8"}]},
  "4.9"->{
    Cell[44827, 1642, 185, 6, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.9"}]},
  "4.10"->{
    Cell[45247, 1662, 86, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.10"}]},
  "4.11"->{
    Cell[45537, 1677, 178, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.11"}]},
  "4.12"->{
    Cell[45915, 1696, 224, 6, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.12"}]},
  "4.13"->{
    Cell[46348, 1716, 327, 9, 70, "Text",
      CellTags->{"S2.13.4", "4.13"}]},
  "4.14"->{
    Cell[46678, 1727, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.14"}]},
  "4.15"->{
    Cell[46737, 1730, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.15"}]},
  "4.16"->{
    Cell[46882, 1737, 343, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.16"}]},
  "4.17"->{
    Cell[47228, 1752, 115, 2, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.17"}]},
  "4.18"->{
    Cell[47346, 1756, 106, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.18"}]},
  "4.19"->{
    Cell[47455, 1759, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.19"}]},
  "4.20"->{
    Cell[47517, 1762, 311, 8, 70, "Text",
      CellTags->{"S2.13.4", "4.20"}]},
  "4.21"->{
    Cell[47831, 1772, 490, 15, 70, "Text",
      CellTags->{"S2.13.4", "4.21"}]},
  "4.22"->{
    Cell[53767, 1966, 649, 19, 70, "Text",
      CellTags->{"S2.13.4", "4.22"}]},
  "4.23"->{
    Cell[54419, 1987, 869, 25, 70, "Text",
      CellTags->{"S2.13.4", "4.23"}]},
  "4.24"->{
    Cell[55291, 2014, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.24"}]},
  "4.25"->{
    Cell[55350, 2017, 270, 8, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.25"}]},
  "4.26"->{
    Cell[55623, 2027, 666, 24, 70, "Program",
      CellTags->{"S2.13.4", "4.26"}]},
  "4.27"->{
    Cell[56292, 2053, 134, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.27"}]},
  "4.28"->{
    Cell[56429, 2060, 97, 6, 70, "Program",
      CellTags->{"S2.13.4", "4.28"}]},
  "4.29"->{
    Cell[56529, 2068, 136, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.29"}]},
  "4.30"->{
    Cell[56668, 2075, 407, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.30"}]},
  "4.31"->{
    Cell[57078, 2090, 214, 9, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.31"}]},
  "4.32"->{
    Cell[57295, 2101, 111, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.32"}]},
  "4.33"->{
    Cell[57409, 2108, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.33"}]},
  "4.34"->{
    Cell[57471, 2111, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.34"}]},
  "4.35"->{
    Cell[57873, 2130, 106, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.35"}]},
  "4.36"->{
    Cell[58189, 2145, 463, 18, 70, "Text",
      CellTags->{"S2.13.4", "4.36"}]},
  "4.37"->{
    Cell[58655, 2165, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.37"}]},
  "4.38"->{
    Cell[58714, 2168, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.38"}]},
  "4.39"->{
    Cell[58772, 2171, 124, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.39"}]},
  "4.40"->{
    Cell[58899, 2177, 73, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.40"}]},
  "4.41"->{
    Cell[58975, 2180, 199, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.41"}]},
  "4.42"->{
    Cell[59177, 2189, 322, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.42"}]},
  "4.43"->{
    Cell[59502, 2204, 67, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.43"}]},
  "4.44"->{
    Cell[59572, 2210, 214, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.44"}]},
  "4.45"->{
    Cell[59789, 2219, 101, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.45"}]},
  "4.46"->{
    Cell[59893, 2222, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.46"}]},
  "4.47"->{
    Cell[59951, 2225, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.47"}]},
  "4.48"->{
    Cell[60013, 2228, 431, 13, 70, "Text",
      CellTags->{"S2.13.4", "4.48"}]},
  "4.49"->{
    Cell[60447, 2243, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.49"}]},
  "4.50"->{
    Cell[60506, 2246, 189, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.50"}]},
  "4.51"->{
    Cell[60698, 2255, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.51"}]},
  "4.52"->{
    Cell[60789, 2258, 157, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.52"}]},
  "4.53"->{
    Cell[60949, 2265, 78, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.53"}]},
  "4.54"->{
    Cell[61030, 2268, 161, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.54"}]},
  "4.55"->{
    Cell[61194, 2275, 80, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.55"}]},
  "4.56"->{
    Cell[61277, 2278, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.56"}]},
  "4.57"->{
    Cell[61339, 2281, 583, 16, 70, "Text",
      CellTags->{"S2.13.4", "4.57"}]},
  "4.58"->{
    Cell[61925, 2299, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.58"}]},
  "4.59"->{
    Cell[61984, 2302, 149, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.59"}]},
  "4.60"->{
    Cell[62136, 2309, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.60"}]},
  "4.61"->{
    Cell[62227, 2312, 175, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.61"}]},
  "4.62"->{
    Cell[62405, 2319, 85, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.62"}]},
  "4.63"->{
    Cell[62493, 2322, 136, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.63"}]},
  "4.64"->{
    Cell[62632, 2328, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.64"}]},
  "4.65"->{
    Cell[62723, 2331, 136, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.65"}]},
  "4.66"->{
    Cell[62862, 2337, 76, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.66"}]},
  "4.67"->{
    Cell[62941, 2340, 90, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.67"}]},
  "4.68"->{
    Cell[63034, 2343, 78, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.68"}]},
  "4.69"->{
    Cell[63115, 2346, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.69"}]},
  "4.70"->{
    Cell[63177, 2349, 626, 15, 70, "Text",
      CellTags->{"S2.13.4", "4.70"}]},
  "4.71"->{
    Cell[63806, 2366, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.71"}]},
  "4.72"->{
    Cell[63865, 2369, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.72"}]},
  "4.73"->{
    Cell[63923, 2372, 167, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.73"}]},
  "4.74"->{
    Cell[64093, 2379, 61, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.74"}]},
  "4.75"->{
    Cell[64157, 2382, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.75"}]},
  "4.76"->{
    Cell[64215, 2385, 178, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.76"}]},
  "4.77"->{
    Cell[64396, 2394, 89, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.77"}]},
  "4.78"->{
    Cell[64488, 2397, 74, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.78"}]},
  "4.79"->{
    Cell[64565, 2400, 141, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.79"}]},
  "4.80"->{
    Cell[64709, 2407, 93, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.80"}]},
  "4.81"->{
    Cell[64805, 2410, 78, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.81"}]},
  "4.82"->{
    Cell[64886, 2413, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.82"}]},
  "4.83"->{
    Cell[64980, 2416, 99, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.83"}]},
  "4.84"->{
    Cell[65082, 2419, 67, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.84"}]},
  "4.85"->{
    Cell[65152, 2425, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.85"}]},
  "4.86"->{
    Cell[65210, 2428, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.86"}]},
  "4.87"->{
    Cell[65272, 2431, 763, 20, 70, "Text",
      CellTags->{"S2.13.4", "4.87"}]},
  "4.88"->{
    Cell[66038, 2453, 268, 6, 70, "Text",
      CellTags->{"S2.13.4", "4.88"}]},
  "4.89"->{
    Cell[66309, 2461, 180, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.89"}]},
  "4.90"->{
    Cell[66737, 2480, 143, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.90"}]},
  "4.91"->{
    Cell[67134, 2498, 125, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.91"}]},
  "4.92"->{
    Cell[67476, 2516, 134, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.92"}]},
  "4.93"->{
    Cell[67847, 2534, 346, 9, 70, "Text",
      CellTags->{"S2.13.4", "4.93"}]},
  "4.94"->{
    Cell[68196, 2545, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.94"}]},
  "4.95"->{
    Cell[68255, 2548, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.95"}]},
  "4.96"->{
    Cell[68400, 2555, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.96"}]},
  "4.97"->{
    Cell[68491, 2558, 164, 6, 70, "Program",
      CellTags->{"S2.13.4", "4.97"}]},
  "4.98"->{
    Cell[68658, 2566, 139, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.98"}]},
  "4.99"->{
    Cell[68800, 2573, 96, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.99"}]},
  "4.100"->{
    Cell[68899, 2576, 74, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.100"}]},
  "4.101"->{
    Cell[68976, 2579, 128, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.101"}]},
  "4.102"->{
    Cell[69107, 2586, 54, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.102"}]},
  "4.103"->{
    Cell[69164, 2589, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.103"}]},
  "4.104"->{
    Cell[69311, 2596, 93, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.104"}]},
  "4.105"->{
    Cell[69407, 2599, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.105"}]},
  "4.106"->{
    Cell[70730, 2645, 472, 15, 70, "Text",
      CellTags->{"S2.13.4", "4.106"}]},
  "4.107"->{
    Cell[71205, 2662, 389, 12, 70, "Text",
      CellTags->{"S2.13.4", "4.107"}]},
  "4.108"->{
    Cell[71597, 2676, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.108"}]},
  "4.109"->{
    Cell[71657, 2679, 87, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.109"}]},
  "4.110"->{
    Cell[71747, 2685, 178, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.110"}]},
  "4.111"->{
    Cell[71928, 2694, 98, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.111"}]},
  "4.112"->{
    Cell[72029, 2697, 131, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.112"}]},
  "4.113"->{
    Cell[72163, 2703, 313, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.113"}]},
  "4.114"->{
    Cell[72479, 2717, 134, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.114"}]},
  "4.115"->{
    Cell[72616, 2723, 321, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.115"}]},
  "4.116"->{
    Cell[72940, 2737, 89, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.116"}]},
  "4.117"->{
    Cell[73032, 2744, 113, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.117"}]},
  "4.118"->{
    Cell[73148, 2747, 79, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.118"}]},
  "4.119"->{
    Cell[73230, 2753, 166, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.119"}]},
  "4.120"->{
    Cell[73399, 2762, 77, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.120"}]},
  "4.121"->{
    Cell[73479, 2768, 143, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.121"}]},
  "4.122"->{
    Cell[73625, 2774, 115, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.122"}]},
  "4.123"->{
    Cell[73743, 2781, 79, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.123"}]},
  "4.124"->{
    Cell[73825, 2787, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.124"}]},
  "4.125"->{
    Cell[73888, 2790, 641, 22, 70, "Text",
      CellTags->{"S2.13.4", "4.125"}]},
  "4.126"->{
    Cell[75392, 2847, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.126"}]},
  "4.127"->{
    Cell[75452, 2850, 87, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.127"}]},
  "4.128"->{
    Cell[75542, 2856, 200, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.128"}]},
  "4.129"->{
    Cell[75745, 2865, 327, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.129"}]},
  "4.130"->{
    Cell[76075, 2880, 109, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.130"}]},
  "4.131"->{
    Cell[76187, 2883, 307, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.131"}]},
  "4.132"->{
    Cell[76497, 2897, 133, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.132"}]},
  "4.133"->{
    Cell[76633, 2903, 312, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.133"}]},
  "4.134"->{
    Cell[76948, 2917, 92, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.134"}]},
  "4.135"->{
    Cell[77043, 2924, 108, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.135"}]},
  "4.136"->{
    Cell[77154, 2927, 75, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.136"}]},
  "4.137"->{
    Cell[77232, 2933, 88, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.137"}]},
  "4.138"->{
    Cell[77323, 2936, 92, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.138"}]},
  "4.139"->{
    Cell[77418, 2943, 197, 6, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.139"}]},
  "4.140"->{
    Cell[77618, 2951, 105, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.140"}]},
  "4.141"->{
    Cell[77726, 2957, 156, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.141"}]},
  "4.142"->{
    Cell[77885, 2964, 117, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.142"}]},
  "4.143"->{
    Cell[78005, 2970, 66, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.143"}]},
  "4.144"->{
    Cell[78074, 2976, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.144"}]},
  "4.145"->{
    Cell[78137, 2979, 429, 9, 70, "Text",
      CellTags->{"S2.13.4", "4.145"}]},
  "4.146"->{
    Cell[78569, 2990, 253, 6, 70, "Text",
      CellTags->{"S2.13.4", "4.146"}]},
  "4.147"->{
    Cell[81364, 3083, 487, 16, 70, "Text",
      CellTags->{"S2.13.4", "4.147"}]},
  "4.148"->{
    Cell[81854, 3101, 240, 5, 70, "Text",
      CellTags->{"S2.13.4", "4.148"}]},
  "4.149"->{
    Cell[82097, 3108, 550, 18, 70, "Text",
      CellTags->{"S2.13.4", "4.149"}]},
  "4.150"->{
    Cell[82650, 3128, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.150"}]},
  "4.151"->{
    Cell[82710, 3131, 133, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.151"}]},
  "4.152"->{
    Cell[82846, 3137, 75, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.152"}]},
  "4.153"->{
    Cell[82924, 3143, 159, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.153"}]},
  "4.154"->{
    Cell[83086, 3150, 85, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.154"}]},
  "4.155"->{
    Cell[83174, 3157, 168, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.155"}]},
  "4.156"->{
    Cell[83345, 3164, 100, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.156"}]},
  "4.157"->{
    Cell[83448, 3170, 56, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.157"}]},
  "4.158"->{
    Cell[83507, 3173, 119, 2, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.158"}]},
  "4.159"->{
    Cell[83629, 3177, 92, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.159"}]},
  "4.160"->{
    Cell[83724, 3180, 66, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.160"}]},
  "4.161"->{
    Cell[83793, 3186, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.161"}]},
  "4.162"->{
    Cell[83856, 3189, 522, 14, 70, "Text",
      CellTags->{"S2.13.4", "4.162"}]},
  "4.163"->{
    Cell[88326, 3334, 405, 10, 70, "Text",
      CellTags->{"S2.13.4", "4.163"}]},
  "4.164"->{
    Cell[88734, 3346, 563, 21, 70, "Text",
      CellTags->{"S2.13.4", "4.164"}]},
  "4.165"->{
    Cell[89300, 3369, 518, 16, 70, "Text",
      CellTags->{"S2.13.4", "4.165"}]},
  "4.166"->{
    Cell[89821, 3387, 342, 10, 70, "Text",
      CellTags->{"S2.13.4", "4.166"}]},
  "4.167"->{
    Cell[91852, 3450, 461, 12, 70, "Text",
      CellTags->{"S2.13.4", "4.167"}]},
  "4.168"->{
    Cell[92316, 3464, 501, 11, 70, "Text",
      CellTags->{"S2.13.4", "4.168"}]},
  "4.169"->{
    Cell[94189, 3520, 553, 14, 70, "Text",
      CellTags->{"S2.13.4", "4.169"}]},
  "S2.13.5"->{
    Cell[94779, 3539, 153, 5, 70, "Subsection",
      CellTags->{"S2.13.5", "5.1"}],
    Cell[94935, 3546, 323, 9, 70, "Text",
      CellTags->{"S2.13.5", "5.2"}],
    Cell[95261, 3557, 415, 11, 70, "Text",
      CellTags->{"S2.13.5", "5.3"}],
    Cell[95679, 3570, 1535, 46, 70, "DefinitionBox",
      CellTags->"S2.13.5"],
    Cell[97217, 3618, 92, 1, 70, "Caption",
      CellTags->"S2.13.5"],
    Cell[97312, 3621, 641, 19, 70, "Text",
      CellTags->{"S2.13.5", "5.4"}],
    Cell[97956, 3642, 1137, 38, 70, "DefinitionBox",
      CellTags->"S2.13.5"],
    Cell[99096, 3682, 97, 1, 70, "Caption",
      CellTags->"S2.13.5"],
    Cell[99196, 3685, 309, 6, 70, "Text",
      CellTags->{"S2.13.5", "5.5"}],
    Cell[99508, 3693, 156, 4, 70, "Text",
      CellTags->{"S2.13.5", "5.6"}],
    Cell[99667, 3699, 350, 7, 70, "Text",
      CellTags->{"S2.13.5", "5.7"}],
    Cell[100020, 3708, 736, 21, 70, "Text",
      CellTags->{"S2.13.5", "5.8"}],
    Cell[100759, 3731, 2531, 76, 70, "DefinitionBox3Col",
      CellTags->"S2.13.5"],
    Cell[103293, 3809, 126, 4, 70, "Caption",
      CellTags->"S2.13.5"],
    Cell[103422, 3815, 520, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.9"}],
    Cell[103945, 3831, 535, 11, 70, "Text",
      CellTags->{"S2.13.5", "5.10"}],
    Cell[104483, 3844, 3717, 119, 70, "DefinitionBox",
      CellTags->"S2.13.5"],
    Cell[108203, 3965, 72, 1, 70, "Caption",
      CellTags->"S2.13.5"],
    Cell[108278, 3968, 536, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.11"}],
    Cell[108817, 3984, 497, 17, 70, "Text",
      CellTags->{"S2.13.5", "5.12"}],
    Cell[109317, 4003, 552, 13, 70, "Text",
      CellTags->{"S2.13.5", "5.13"}],
    Cell[109872, 4018, 391, 11, 70, "FramedBox",
      CellTags->"S2.13.5"],
    Cell[110266, 4031, 143, 5, 70, "Caption",
      CellTags->"S2.13.5"],
    Cell[110412, 4038, 416, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.14"}],
    Cell[110831, 4054, 548, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.15"}]},
  "5.1"->{
    Cell[94779, 3539, 153, 5, 70, "Subsection",
      CellTags->{"S2.13.5", "5.1"}]},
  "5.2"->{
    Cell[94935, 3546, 323, 9, 70, "Text",
      CellTags->{"S2.13.5", "5.2"}]},
  "5.3"->{
    Cell[95261, 3557, 415, 11, 70, "Text",
      CellTags->{"S2.13.5", "5.3"}]},
  "5.4"->{
    Cell[97312, 3621, 641, 19, 70, "Text",
      CellTags->{"S2.13.5", "5.4"}]},
  "5.5"->{
    Cell[99196, 3685, 309, 6, 70, "Text",
      CellTags->{"S2.13.5", "5.5"}]},
  "5.6"->{
    Cell[99508, 3693, 156, 4, 70, "Text",
      CellTags->{"S2.13.5", "5.6"}]},
  "5.7"->{
    Cell[99667, 3699, 350, 7, 70, "Text",
      CellTags->{"S2.13.5", "5.7"}]},
  "5.8"->{
    Cell[100020, 3708, 736, 21, 70, "Text",
      CellTags->{"S2.13.5", "5.8"}]},
  "5.9"->{
    Cell[103422, 3815, 520, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.9"}]},
  "5.10"->{
    Cell[103945, 3831, 535, 11, 70, "Text",
      CellTags->{"S2.13.5", "5.10"}]},
  "5.11"->{
    Cell[108278, 3968, 536, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.11"}]},
  "5.12"->{
    Cell[108817, 3984, 497, 17, 70, "Text",
      CellTags->{"S2.13.5", "5.12"}]},
  "5.13"->{
    Cell[109317, 4003, 552, 13, 70, "Text",
      CellTags->{"S2.13.5", "5.13"}]},
  "5.14"->{
    Cell[110412, 4038, 416, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.14"}]},
  "5.15"->{
    Cell[110831, 4054, 548, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.15"}]},
  "S2.13.6"->{
    Cell[111416, 4073, 193, 7, 70, "Subsection",
      CellTags->{"S2.13.6", "6.1"}],
    Cell[111612, 4082, 2436, 70, 70, "DefinitionBox",
      CellTags->"S2.13.6"],
    Cell[114051, 4154, 159, 6, 70, "Caption",
      CellTags->"S2.13.6"],
    Cell[114213, 4162, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.2"}],
    Cell[114281, 4165, 98, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.3"}],
    Cell[114404, 4170, 92, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[114499, 4174, 104, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[114618, 4179, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.4"}],
    Cell[114686, 4182, 95, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.5"}],
    Cell[114806, 4187, 92, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[114901, 4191, 108, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[115024, 4196, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.6"}],
    Cell[115092, 4199, 145, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.7"}],
    Cell[115240, 4206, 84, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[115327, 4210, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.8"}],
    Cell[115395, 4213, 156, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.9"}],
    Cell[115576, 4222, 78, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[115657, 4226, 78, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[115750, 4231, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.10"}],
    Cell[115844, 4234, 87, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[115934, 4238, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.11"}],
    Cell[116003, 4241, 102, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.12"}],
    Cell[116130, 4246, 78, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[116211, 4250, 104, 3, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[116330, 4256, 254, 8, 70, "Text",
      CellTags->{"S2.13.6", "6.13"}],
    Cell[116587, 4266, 151, 4, 70, "Text",
      CellTags->{"S2.13.6", "6.14"}],
    Cell[116741, 4272, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.15"}],
    Cell[116810, 4275, 212, 9, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.16"}],
    Cell[117025, 4286, 99, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[117127, 4290, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.17"}],
    Cell[117196, 4293, 174, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.18"}],
    Cell[117395, 4302, 84, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[117482, 4306, 76, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[117573, 4311, 87, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.19"}],
    Cell[117685, 4316, 78, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[117766, 4320, 66, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[117847, 4325, 395, 11, 70, "Text",
      CellTags->{"S2.13.6", "6.20"}],
    Cell[118245, 4338, 718, 23, 70, "Text",
      CellTags->{"S2.13.6", "6.21"}],
    Cell[118966, 4363, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.22"}],
    Cell[119035, 4366, 199, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.23"}],
    Cell[119259, 4375, 80, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[119342, 4379, 70, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[119427, 4384, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.24"}],
    Cell[119496, 4387, 95, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.25"}],
    Cell[119594, 4390, 86, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[119683, 4394, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.26"}],
    Cell[119752, 4397, 117, 2, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.27"}],
    Cell[119894, 4403, 80, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[119977, 4407, 69, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[120061, 4412, 148, 4, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.28"}],
    Cell[120234, 4420, 78, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[120315, 4424, 70, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[120400, 4429, 1190, 32, 70, "DefinitionBox",
      CellTags->"S2.13.6"],
    Cell[121593, 4463, 117, 5, 70, "Caption",
      CellTags->"S2.13.6"],
    Cell[121713, 4470, 332, 7, 70, "Text",
      CellTags->{"S2.13.6", "6.29"}],
    Cell[122048, 4479, 195, 5, 70, "Text",
      CellTags->{"S2.13.6", "6.30"}],
    Cell[122246, 4486, 160, 5, 70, "Text",
      CellTags->{"S2.13.6", "6.31"}],
    Cell[122409, 4493, 122, 4, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.32"}],
    Cell[122534, 4499, 152, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.33"}],
    Cell[122711, 4508, 84, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[122798, 4512, 108, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[122921, 4517, 122, 4, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.34"}],
    Cell[123046, 4523, 147, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.35"}],
    Cell[123218, 4532, 109, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[123330, 4536, 108, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[123453, 4541, 107, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.36"}],
    Cell[123563, 4544, 93, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[123659, 4548, 122, 4, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.37"}],
    Cell[123784, 4554, 143, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.38"}],
    Cell[123952, 4563, 78, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[124033, 4567, 69, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[124117, 4572, 333, 8, 70, "Text",
      CellTags->{"S2.13.6", "6.39"}],
    Cell[124453, 4582, 390, 10, 70, "Text",
      CellTags->{"S2.13.6", "6.40"}]},
  "6.1"->{
    Cell[111416, 4073, 193, 7, 70, "Subsection",
      CellTags->{"S2.13.6", "6.1"}]},
  "6.2"->{
    Cell[114213, 4162, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.2"}]},
  "6.3"->{
    Cell[114281, 4165, 98, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.3"}]},
  "6.4"->{
    Cell[114618, 4179, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.4"}]},
  "6.5"->{
    Cell[114686, 4182, 95, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.5"}]},
  "6.6"->{
    Cell[115024, 4196, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.6"}]},
  "6.7"->{
    Cell[115092, 4199, 145, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.7"}]},
  "6.8"->{
    Cell[115327, 4210, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.8"}]},
  "6.9"->{
    Cell[115395, 4213, 156, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.9"}]},
  "6.10"->{
    Cell[115750, 4231, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.10"}]},
  "6.11"->{
    Cell[115934, 4238, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.11"}]},
  "6.12"->{
    Cell[116003, 4241, 102, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.12"}]},
  "6.13"->{
    Cell[116330, 4256, 254, 8, 70, "Text",
      CellTags->{"S2.13.6", "6.13"}]},
  "6.14"->{
    Cell[116587, 4266, 151, 4, 70, "Text",
      CellTags->{"S2.13.6", "6.14"}]},
  "6.15"->{
    Cell[116741, 4272, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.15"}]},
  "6.16"->{
    Cell[116810, 4275, 212, 9, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.16"}]},
  "6.17"->{
    Cell[117127, 4290, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.17"}]},
  "6.18"->{
    Cell[117196, 4293, 174, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.18"}]},
  "6.19"->{
    Cell[117573, 4311, 87, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.19"}]},
  "6.20"->{
    Cell[117847, 4325, 395, 11, 70, "Text",
      CellTags->{"S2.13.6", "6.20"}]},
  "6.21"->{
    Cell[118245, 4338, 718, 23, 70, "Text",
      CellTags->{"S2.13.6", "6.21"}]},
  "6.22"->{
    Cell[118966, 4363, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.22"}]},
  "6.23"->{
    Cell[119035, 4366, 199, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.23"}]},
  "6.24"->{
    Cell[119427, 4384, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.24"}]},
  "6.25"->{
    Cell[119496, 4387, 95, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.25"}]},
  "6.26"->{
    Cell[119683, 4394, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.26"}]},
  "6.27"->{
    Cell[119752, 4397, 117, 2, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.27"}]},
  "6.28"->{
    Cell[120061, 4412, 148, 4, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.28"}]},
  "6.29"->{
    Cell[121713, 4470, 332, 7, 70, "Text",
      CellTags->{"S2.13.6", "6.29"}]},
  "6.30"->{
    Cell[122048, 4479, 195, 5, 70, "Text",
      CellTags->{"S2.13.6", "6.30"}]},
  "6.31"->{
    Cell[122246, 4486, 160, 5, 70, "Text",
      CellTags->{"S2.13.6", "6.31"}]},
  "6.32"->{
    Cell[122409, 4493, 122, 4, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.32"}]},
  "6.33"->{
    Cell[122534, 4499, 152, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.33"}]},
  "6.34"->{
    Cell[122921, 4517, 122, 4, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.34"}]},
  "6.35"->{
    Cell[123046, 4523, 147, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.35"}]},
  "6.36"->{
    Cell[123453, 4541, 107, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.36"}]},
  "6.37"->{
    Cell[123659, 4548, 122, 4, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.37"}]},
  "6.38"->{
    Cell[123784, 4554, 143, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.38"}]},
  "6.39"->{
    Cell[124117, 4572, 333, 8, 70, "Text",
      CellTags->{"S2.13.6", "6.39"}]},
  "6.40"->{
    Cell[124453, 4582, 390, 10, 70, "Text",
      CellTags->{"S2.13.6", "6.40"}]},
  "S2.13.7"->{
    Cell[124880, 4597, 146, 5, 70, "Subsection",
      CellTags->{"S2.13.7", "7.1"}],
    Cell[125029, 4604, 467, 13, 70, "DefinitionBox",
      CellTags->"S2.13.7"],
    Cell[125499, 4619, 135, 5, 70, "Caption",
      CellTags->"S2.13.7"],
    Cell[125637, 4626, 178, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.2"}],
    Cell[125840, 4635, 101, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[125944, 4639, 97, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[126056, 4644, 195, 6, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.3"}],
    Cell[126276, 4654, 79, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[126358, 4658, 90, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[126463, 4663, 186, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.4"}],
    Cell[126652, 4670, 106, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[126761, 4674, 188, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.5"}],
    Cell[126974, 4683, 79, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[127056, 4687, 91, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[127162, 4692, 107, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.6"}],
    Cell[127294, 4697, 79, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[127376, 4701, 90, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[127481, 4706, 410, 12, 70, "Text",
      CellTags->{"S2.13.7", "7.7"}],
    Cell[127894, 4720, 1205, 30, 70, "DefinitionBox",
      CellTags->"S2.13.7"],
    Cell[129102, 4752, 130, 5, 70, "Caption",
      CellTags->"S2.13.7"],
    Cell[129235, 4759, 275, 9, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.8"}],
    Cell[129535, 4772, 79, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[129617, 4776, 90, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[129722, 4781, 140, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.9"}],
    Cell[129865, 4788, 122, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[129990, 4792, 139, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.10"}],
    Cell[130154, 4801, 79, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[130236, 4805, 87, 5, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[130338, 4813, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.11"}],
    Cell[130507, 4822, 79, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[130589, 4826, 87, 5, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[130691, 4834, 170, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.12"}],
    Cell[130886, 4843, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[130969, 4847, 91, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[131075, 4852, 1316, 38, 70, "DefinitionBox",
      CellTags->"S2.13.7"],
    Cell[132394, 4892, 145, 5, 70, "Caption",
      CellTags->"S2.13.7"],
    Cell[132542, 4899, 811, 26, 70, "Text",
      CellTags->{"S2.13.7", "7.13"}],
    Cell[133356, 4927, 745, 20, 70, "DefinitionBox",
      CellTags->"S2.13.7"],
    Cell[134104, 4949, 119, 4, 70, "Caption",
      CellTags->"S2.13.7"],
    Cell[134226, 4955, 189, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.14"}],
    Cell[134418, 4962, 145, 5, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[134566, 4969, 184, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.15"}],
    Cell[134775, 4978, 92, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[134870, 4982, 264, 6, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[135149, 4991, 564, 18, 70, "Text",
      CellTags->{"S2.13.7", "7.16"}],
    Cell[135716, 5011, 698, 23, 70, "Text",
      CellTags->{"S2.13.7", "7.17"}],
    Cell[136417, 5036, 682, 18, 70, "DefinitionBox",
      CellTags->"S2.13.7"],
    Cell[137102, 5056, 116, 4, 70, "Caption",
      CellTags->"S2.13.7"],
    Cell[137221, 5062, 221, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.18"}],
    Cell[137445, 5071, 115, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[137563, 5075, 135, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.19"}],
    Cell[137723, 5084, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[137806, 5088, 104, 3, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[137925, 5094, 192, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.20"}],
    Cell[138120, 5103, 120, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[138243, 5107, 216, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.21"}],
    Cell[138484, 5118, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[138567, 5122, 88, 5, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[138670, 5130, 156, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.22"}],
    Cell[138851, 5139, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[138934, 5143, 84, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[139033, 5148, 597, 16, 70, "Text",
      CellTags->{"S2.13.7", "7.23"}],
    Cell[139633, 5166, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.24"}],
    Cell[139801, 5173, 143, 5, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[139947, 5180, 182, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.25"}],
    Cell[140154, 5189, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[140237, 5193, 85, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[140337, 5198, 118, 2, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.26"}],
    Cell[140480, 5204, 82, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[140565, 5208, 71, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[140651, 5213, 80, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.27"}],
    Cell[140734, 5216, 109, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[140846, 5220, 202, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.28"}],
    Cell[141073, 5231, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[141156, 5235, 89, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[141260, 5240, 550, 16, 70, "DefinitionBox",
      CellTags->"S2.13.7"],
    Cell[141813, 5258, 138, 5, 70, "Caption",
      CellTags->"S2.13.7"],
    Cell[141954, 5265, 146, 4, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.29"}],
    Cell[142103, 5271, 126, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[142232, 5275, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.30"}],
    Cell[142348, 5280, 82, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[142433, 5284, 71, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[142519, 5289, 81, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.31"}],
    Cell[142603, 5292, 85, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[142691, 5296, 145, 4, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.32"}],
    Cell[142861, 5304, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[142944, 5308, 92, 2, 70, "Output",
      CellTags->"S2.13.7"]},
  "7.1"->{
    Cell[124880, 4597, 146, 5, 70, "Subsection",
      CellTags->{"S2.13.7", "7.1"}]},
  "7.2"->{
    Cell[125637, 4626, 178, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.2"}]},
  "7.3"->{
    Cell[126056, 4644, 195, 6, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.3"}]},
  "7.4"->{
    Cell[126463, 4663, 186, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.4"}]},
  "7.5"->{
    Cell[126761, 4674, 188, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.5"}]},
  "7.6"->{
    Cell[127162, 4692, 107, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.6"}]},
  "7.7"->{
    Cell[127481, 4706, 410, 12, 70, "Text",
      CellTags->{"S2.13.7", "7.7"}]},
  "7.8"->{
    Cell[129235, 4759, 275, 9, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.8"}]},
  "7.9"->{
    Cell[129722, 4781, 140, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.9"}]},
  "7.10"->{
    Cell[129990, 4792, 139, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.10"}]},
  "7.11"->{
    Cell[130338, 4813, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.11"}]},
  "7.12"->{
    Cell[130691, 4834, 170, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.12"}]},
  "7.13"->{
    Cell[132542, 4899, 811, 26, 70, "Text",
      CellTags->{"S2.13.7", "7.13"}]},
  "7.14"->{
    Cell[134226, 4955, 189, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.14"}]},
  "7.15"->{
    Cell[134566, 4969, 184, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.15"}]},
  "7.16"->{
    Cell[135149, 4991, 564, 18, 70, "Text",
      CellTags->{"S2.13.7", "7.16"}]},
  "7.17"->{
    Cell[135716, 5011, 698, 23, 70, "Text",
      CellTags->{"S2.13.7", "7.17"}]},
  "7.18"->{
    Cell[137221, 5062, 221, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.18"}]},
  "7.19"->{
    Cell[137563, 5075, 135, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.19"}]},
  "7.20"->{
    Cell[137925, 5094, 192, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.20"}]},
  "7.21"->{
    Cell[138243, 5107, 216, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.21"}]},
  "7.22"->{
    Cell[138670, 5130, 156, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.22"}]},
  "7.23"->{
    Cell[139033, 5148, 597, 16, 70, "Text",
      CellTags->{"S2.13.7", "7.23"}]},
  "7.24"->{
    Cell[139633, 5166, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.24"}]},
  "7.25"->{
    Cell[139947, 5180, 182, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.25"}]},
  "7.26"->{
    Cell[140337, 5198, 118, 2, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.26"}]},
  "7.27"->{
    Cell[140651, 5213, 80, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.27"}]},
  "7.28"->{
    Cell[140846, 5220, 202, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.28"}]},
  "7.29"->{
    Cell[141954, 5265, 146, 4, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.29"}]},
  "7.30"->{
    Cell[142232, 5275, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.30"}]},
  "7.31"->{
    Cell[142519, 5289, 81, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.31"}]},
  "7.32"->{
    Cell[142691, 5296, 145, 4, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.32"}]},
  "S2.13.8"->{
    Cell[143085, 5316, 162, 5, 70, "Subsection",
      CellTags->{"S2.13.8", "8.1"}],
    Cell[143250, 5323, 437, 14, 70, "Text",
      CellTags->{"S2.13.8", "8.2"}],
    Cell[143690, 5339, 474, 14, 70, "DefinitionBox",
      CellTags->"S2.13.8"],
    Cell[144167, 5355, 93, 1, 70, "Caption",
      CellTags->"S2.13.8"],
    Cell[144263, 5358, 242, 7, 70, "Text",
      CellTags->{"S2.13.8", "8.3"}],
    Cell[144508, 5367, 283, 8, 70, "Text",
      CellTags->{"S2.13.8", "8.4"}],
    Cell[144794, 5377, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.8", "8.5"}],
    Cell[144862, 5380, 89, 1, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.6"}],
    Cell[144976, 5385, 92, 2, 70, "Input",
      CellTags->"S2.13.8"],
    Cell[145071, 5389, 104, 2, 70, "Output",
      CellTags->"S2.13.8"],
    Cell[145190, 5394, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.8", "8.7"}],
    Cell[145258, 5397, 102, 1, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.8"}],
    Cell[145385, 5402, 86, 2, 70, "Input",
      CellTags->"S2.13.8"],
    Cell[145474, 5406, 104, 2, 70, "Output",
      CellTags->"S2.13.8"],
    Cell[145593, 5411, 131, 4, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.9"}],
    Cell[145727, 5417, 80, 2, 70, "Input",
      CellTags->"S2.13.8"],
    Cell[145810, 5421, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.8", "8.10"}],
    Cell[145879, 5424, 142, 4, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.11"}],
    Cell[146046, 5432, 91, 2, 70, "Input",
      CellTags->"S2.13.8"],
    Cell[146140, 5436, 236, 7, 70, "Output",
      CellTags->"S2.13.8"],
    Cell[146391, 5446, 87, 1, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.12"}],
    Cell[146481, 5449, 116, 2, 70, "Input",
      CellTags->"S2.13.8"],
    Cell[146600, 5453, 286, 9, 70, "Text",
      CellTags->{"S2.13.8", "8.13"}],
    Cell[146889, 5464, 424, 12, 70, "Text",
      CellTags->{"S2.13.8", "8.14"}]},
  "8.1"->{
    Cell[143085, 5316, 162, 5, 70, "Subsection",
      CellTags->{"S2.13.8", "8.1"}]},
  "8.2"->{
    Cell[143250, 5323, 437, 14, 70, "Text",
      CellTags->{"S2.13.8", "8.2"}]},
  "8.3"->{
    Cell[144263, 5358, 242, 7, 70, "Text",
      CellTags->{"S2.13.8", "8.3"}]},
  "8.4"->{
    Cell[144508, 5367, 283, 8, 70, "Text",
      CellTags->{"S2.13.8", "8.4"}]},
  "8.5"->{
    Cell[144794, 5377, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.8", "8.5"}]},
  "8.6"->{
    Cell[144862, 5380, 89, 1, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.6"}]},
  "8.7"->{
    Cell[145190, 5394, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.8", "8.7"}]},
  "8.8"->{
    Cell[145258, 5397, 102, 1, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.8"}]},
  "8.9"->{
    Cell[145593, 5411, 131, 4, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.9"}]},
  "8.10"->{
    Cell[145810, 5421, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.8", "8.10"}]},
  "8.11"->{
    Cell[145879, 5424, 142, 4, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.11"}]},
  "8.12"->{
    Cell[146391, 5446, 87, 1, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.12"}]},
  "8.13"->{
    Cell[146600, 5453, 286, 9, 70, "Text",
      CellTags->{"S2.13.8", "8.13"}]},
  "8.14"->{
    Cell[146889, 5464, 424, 12, 70, "Text",
      CellTags->{"S2.13.8", "8.14"}]},
  "S2.13.9"->{
    Cell[147350, 5481, 123, 4, 70, "Subsection",
      CellTags->{"S2.13.9", "9.1"}],
    Cell[147476, 5487, 534, 14, 70, "Text",
      CellTags->{"S2.13.9", "9.2"}],
    Cell[148013, 5503, 200, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.3"}],
    Cell[148238, 5512, 93, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[148334, 5516, 108, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[148457, 5522, 197, 7, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.4"}],
    Cell[148679, 5533, 70, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[148752, 5537, 69, 2, 70, "Print",
      CellTags->"S2.13.9"],
    Cell[148824, 5541, 532, 15, 70, "Print",
      CellTags->"S2.13.9"],
    Cell[149371, 5559, 306, 9, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.5"}],
    Cell[149680, 5570, 101, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[149784, 5574, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.6"}],
    Cell[149974, 5583, 79, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[150056, 5587, 103, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[150174, 5593, 548, 14, 70, "Text",
      CellTags->{"S2.13.9", "9.7"}],
    Cell[150725, 5609, 484, 14, 70, "DefinitionBox",
      CellTags->"S2.13.9"],
    Cell[151212, 5625, 114, 4, 70, "Caption",
      CellTags->"S2.13.9"],
    Cell[151329, 5631, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.9", "9.8"}],
    Cell[151387, 5634, 88, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.9"}],
    Cell[151478, 5640, 176, 7, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.10"}],
    Cell[151657, 5649, 98, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.11"}],
    Cell[151758, 5652, 596, 23, 70, "Program",
      CellTags->{"S2.13.9", "9.12"}],
    Cell[152357, 5677, 173, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.13"}],
    Cell[152533, 5684, 77, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.14"}],
    Cell[152613, 5690, 347, 12, 70, "Program",
      CellTags->{"S2.13.9", "9.15"}],
    Cell[152963, 5704, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.9", "9.16"}],
    Cell[153025, 5707, 169, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.17"}],
    Cell[153219, 5716, 94, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[153316, 5720, 110, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[153441, 5726, 88, 1, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.18"}],
    Cell[153554, 5731, 94, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[153651, 5735, 110, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[153776, 5741, 141, 4, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.19"}],
    Cell[153942, 5749, 80, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[154025, 5753, 85, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[154125, 5759, 142, 4, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.20"}],
    Cell[154292, 5767, 80, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[154375, 5771, 85, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[154475, 5777, 116, 2, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.21"}],
    Cell[154616, 5783, 80, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[154699, 5787, 85, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[154799, 5793, 314, 6, 70, "Text",
      CellTags->{"S2.13.9", "9.22"}],
    Cell[155116, 5801, 264, 6, 70, "Text",
      CellTags->{"S2.13.9", "9.23"}],
    Cell[155383, 5809, 609, 18, 70, "DefinitionBox",
      CellTags->"S2.13.9"],
    Cell[155995, 5829, 134, 5, 70, "Caption",
      CellTags->"S2.13.9"],
    Cell[156132, 5836, 333, 10, 70, "Text",
      CellTags->{"S2.13.9", "9.24"}],
    Cell[156468, 5848, 462, 13, 70, "Text",
      CellTags->{"S2.13.9", "9.25"}],
    Cell[156933, 5863, 295, 9, 70, "Text",
      CellTags->{"S2.13.9", "9.26"}],
    Cell[157231, 5874, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.9", "9.27"}],
    Cell[157290, 5877, 55, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.28"}],
    Cell[157348, 5880, 131, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.29"}],
    Cell[157482, 5887, 98, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.30"}],
    Cell[157583, 5890, 178, 7, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.31"}],
    Cell[157764, 5899, 133, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.32"}],
    Cell[157900, 5905, 131, 4, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.33"}],
    Cell[158034, 5911, 82, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.34"}],
    Cell[158119, 5917, 146, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.35"}],
    Cell[158268, 5924, 99, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.36"}],
    Cell[158370, 5927, 157, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.37"}],
    Cell[158530, 5934, 80, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.38"}],
    Cell[158613, 5937, 55, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.39"}],
    Cell[158671, 5940, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.9", "9.40"}],
    Cell[158733, 5943, 494, 14, 70, "DefinitionBox",
      CellTags->"S2.13.9"],
    Cell[159230, 5959, 119, 5, 70, "Caption",
      CellTags->"S2.13.9"],
    Cell[159352, 5966, 638, 19, 70, "Text",
      CellTags->{"S2.13.9", "9.41"}]},
  "9.1"->{
    Cell[147350, 5481, 123, 4, 70, "Subsection",
      CellTags->{"S2.13.9", "9.1"}]},
  "9.2"->{
    Cell[147476, 5487, 534, 14, 70, "Text",
      CellTags->{"S2.13.9", "9.2"}]},
  "9.3"->{
    Cell[148013, 5503, 200, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.3"}]},
  "9.4"->{
    Cell[148457, 5522, 197, 7, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.4"}]},
  "9.5"->{
    Cell[149371, 5559, 306, 9, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.5"}]},
  "9.6"->{
    Cell[149784, 5574, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.6"}]},
  "9.7"->{
    Cell[150174, 5593, 548, 14, 70, "Text",
      CellTags->{"S2.13.9", "9.7"}]},
  "9.8"->{
    Cell[151329, 5631, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.9", "9.8"}]},
  "9.9"->{
    Cell[151387, 5634, 88, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.9"}]},
  "9.10"->{
    Cell[151478, 5640, 176, 7, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.10"}]},
  "9.11"->{
    Cell[151657, 5649, 98, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.11"}]},
  "9.12"->{
    Cell[151758, 5652, 596, 23, 70, "Program",
      CellTags->{"S2.13.9", "9.12"}]},
  "9.13"->{
    Cell[152357, 5677, 173, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.13"}]},
  "9.14"->{
    Cell[152533, 5684, 77, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.14"}]},
  "9.15"->{
    Cell[152613, 5690, 347, 12, 70, "Program",
      CellTags->{"S2.13.9", "9.15"}]},
  "9.16"->{
    Cell[152963, 5704, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.9", "9.16"}]},
  "9.17"->{
    Cell[153025, 5707, 169, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.17"}]},
  "9.18"->{
    Cell[153441, 5726, 88, 1, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.18"}]},
  "9.19"->{
    Cell[153776, 5741, 141, 4, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.19"}]},
  "9.20"->{
    Cell[154125, 5759, 142, 4, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.20"}]},
  "9.21"->{
    Cell[154475, 5777, 116, 2, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.21"}]},
  "9.22"->{
    Cell[154799, 5793, 314, 6, 70, "Text",
      CellTags->{"S2.13.9", "9.22"}]},
  "9.23"->{
    Cell[155116, 5801, 264, 6, 70, "Text",
      CellTags->{"S2.13.9", "9.23"}]},
  "9.24"->{
    Cell[156132, 5836, 333, 10, 70, "Text",
      CellTags->{"S2.13.9", "9.24"}]},
  "9.25"->{
    Cell[156468, 5848, 462, 13, 70, "Text",
      CellTags->{"S2.13.9", "9.25"}]},
  "9.26"->{
    Cell[156933, 5863, 295, 9, 70, "Text",
      CellTags->{"S2.13.9", "9.26"}]},
  "9.27"->{
    Cell[157231, 5874, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.9", "9.27"}]},
  "9.28"->{
    Cell[157290, 5877, 55, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.28"}]},
  "9.29"->{
    Cell[157348, 5880, 131, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.29"}]},
  "9.30"->{
    Cell[157482, 5887, 98, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.30"}]},
  "9.31"->{
    Cell[157583, 5890, 178, 7, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.31"}]},
  "9.32"->{
    Cell[157764, 5899, 133, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.32"}]},
  "9.33"->{
    Cell[157900, 5905, 131, 4, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.33"}]},
  "9.34"->{
    Cell[158034, 5911, 82, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.34"}]},
  "9.35"->{
    Cell[158119, 5917, 146, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.35"}]},
  "9.36"->{
    Cell[158268, 5924, 99, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.36"}]},
  "9.37"->{
    Cell[158370, 5927, 157, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.37"}]},
  "9.38"->{
    Cell[158530, 5934, 80, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.38"}]},
  "9.39"->{
    Cell[158613, 5937, 55, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.39"}]},
  "9.40"->{
    Cell[158671, 5940, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.9", "9.40"}]},
  "9.41"->{
    Cell[159352, 5966, 638, 19, 70, "Text",
      CellTags->{"S2.13.9", "9.41"}]},
  "S2.13.10"->{
    Cell[160027, 5990, 117, 2, 70, "Subsection",
      CellTags->{"S2.13.10", "10.1"}],
    Cell[160147, 5994, 455, 10, 70, "Text",
      CellTags->{"S2.13.10", "10.2"}],
    Cell[160605, 6006, 132, 4, 70, "SessionLabel",
      CellTags->{"S2.13.10", "10.3"}],
    Cell[160740, 6012, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.4"}],
    Cell[160908, 6019, 109, 4, 70, "Program",
      CellTags->{"S2.13.10", "10.5"}],
    Cell[161020, 6025, 139, 4, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.6"}],
    Cell[161162, 6031, 192, 9, 70, "Program",
      CellTags->{"S2.13.10", "10.7"}],
    Cell[161357, 6042, 157, 5, 70, "SessionLabel",
      CellTags->{"S2.13.10", "10.8"}],
    Cell[161517, 6049, 106, 1, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.9"}],
    Cell[161648, 6054, 112, 2, 70, "Input",
      CellTags->"S2.13.10"],
    Cell[161763, 6058, 102, 2, 70, "Output",
      CellTags->"S2.13.10"],
    Cell[161880, 6063, 170, 5, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.10"}],
    Cell[162075, 6072, 70, 2, 70, "Input",
      CellTags->"S2.13.10"],
    Cell[162148, 6076, 72, 2, 70, "Output",
      CellTags->"S2.13.10"],
    Cell[162235, 6081, 560, 12, 70, "Text",
      CellTags->{"S2.13.10", "10.11"}],
    Cell[162798, 6095, 879, 27, 70, "DefinitionBox",
      CellTags->"S2.13.10"],
    Cell[163680, 6124, 93, 1, 70, "Caption",
      CellTags->"S2.13.10"]},
  "10.1"->{
    Cell[160027, 5990, 117, 2, 70, "Subsection",
      CellTags->{"S2.13.10", "10.1"}]},
  "10.2"->{
    Cell[160147, 5994, 455, 10, 70, "Text",
      CellTags->{"S2.13.10", "10.2"}]},
  "10.3"->{
    Cell[160605, 6006, 132, 4, 70, "SessionLabel",
      CellTags->{"S2.13.10", "10.3"}]},
  "10.4"->{
    Cell[160740, 6012, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.4"}]},
  "10.5"->{
    Cell[160908, 6019, 109, 4, 70, "Program",
      CellTags->{"S2.13.10", "10.5"}]},
  "10.6"->{
    Cell[161020, 6025, 139, 4, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.6"}]},
  "10.7"->{
    Cell[161162, 6031, 192, 9, 70, "Program",
      CellTags->{"S2.13.10", "10.7"}]},
  "10.8"->{
    Cell[161357, 6042, 157, 5, 70, "SessionLabel",
      CellTags->{"S2.13.10", "10.8"}]},
  "10.9"->{
    Cell[161517, 6049, 106, 1, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.9"}]},
  "10.10"->{
    Cell[161880, 6063, 170, 5, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.10"}]},
  "10.11"->{
    Cell[162235, 6081, 560, 12, 70, "Text",
      CellTags->{"S2.13.10", "10.11"}]},
  "S2.13.11"->{
    Cell[163810, 6130, 131, 4, 70, "Subsection",
      CellTags->{"S2.13.11", "11.1"}],
    Cell[163944, 6136, 201, 5, 70, "Text",
      CellTags->{"S2.13.11", "11.2"}],
    Cell[164148, 6143, 281, 7, 70, "Text",
      CellTags->{"S2.13.11", "11.3"}],
    Cell[164432, 6152, 706, 22, 70, "DefinitionBox",
      CellTags->"S2.13.11"],
    Cell[165141, 6176, 89, 1, 70, "Caption",
      CellTags->"S2.13.11"],
    Cell[165233, 6179, 261, 6, 70, "Text",
      CellTags->{"S2.13.11", "11.4"}],
    Cell[165497, 6187, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.5"}],
    Cell[165566, 6190, 139, 5, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.6"}],
    Cell[165708, 6197, 238, 12, 70, "Program",
      CellTags->{"S2.13.11", "11.7"}],
    Cell[165949, 6211, 84, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.8"}],
    Cell[166036, 6214, 107, 4, 70, "Program",
      CellTags->{"S2.13.11", "11.9"}],
    Cell[166146, 6220, 113, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.10"}],
    Cell[166262, 6223, 193, 9, 70, "Program",
      CellTags->{"S2.13.11", "11.11"}],
    Cell[166458, 6234, 116, 4, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.12"}],
    Cell[166577, 6240, 117, 2, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.13"}],
    Cell[166719, 6246, 112, 2, 70, "Input",
      CellTags->"S2.13.11"],
    Cell[166834, 6250, 102, 2, 70, "Output",
      CellTags->"S2.13.11"],
    Cell[166951, 6255, 135, 4, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.14"}],
    Cell[167089, 6261, 70, 2, 70, "Input",
      CellTags->"S2.13.11"],
    Cell[167162, 6265, 67, 1, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.15"}],
    Cell[167232, 6268, 104, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.16"}],
    Cell[167339, 6271, 116, 5, 70, "Program",
      CellTags->{"S2.13.11", "11.17"}],
    Cell[167458, 6278, 94, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.18"}],
    Cell[167555, 6281, 101, 4, 70, "Program",
      CellTags->{"S2.13.11", "11.19"}],
    Cell[167659, 6287, 116, 4, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.20"}],
    Cell[167778, 6293, 117, 5, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.21"}],
    Cell[167898, 6300, 72, 2, 70, "Output",
      CellTags->"S2.13.11"]},
  "11.1"->{
    Cell[163810, 6130, 131, 4, 70, "Subsection",
      CellTags->{"S2.13.11", "11.1"}]},
  "11.2"->{
    Cell[163944, 6136, 201, 5, 70, "Text",
      CellTags->{"S2.13.11", "11.2"}]},
  "11.3"->{
    Cell[164148, 6143, 281, 7, 70, "Text",
      CellTags->{"S2.13.11", "11.3"}]},
  "11.4"->{
    Cell[165233, 6179, 261, 6, 70, "Text",
      CellTags->{"S2.13.11", "11.4"}]},
  "11.5"->{
    Cell[165497, 6187, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.5"}]},
  "11.6"->{
    Cell[165566, 6190, 139, 5, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.6"}]},
  "11.7"->{
    Cell[165708, 6197, 238, 12, 70, "Program",
      CellTags->{"S2.13.11", "11.7"}]},
  "11.8"->{
    Cell[165949, 6211, 84, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.8"}]},
  "11.9"->{
    Cell[166036, 6214, 107, 4, 70, "Program",
      CellTags->{"S2.13.11", "11.9"}]},
  "11.10"->{
    Cell[166146, 6220, 113, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.10"}]},
  "11.11"->{
    Cell[166262, 6223, 193, 9, 70, "Program",
      CellTags->{"S2.13.11", "11.11"}]},
  "11.12"->{
    Cell[166458, 6234, 116, 4, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.12"}]},
  "11.13"->{
    Cell[166577, 6240, 117, 2, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.13"}]},
  "11.14"->{
    Cell[166951, 6255, 135, 4, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.14"}]},
  "11.15"->{
    Cell[167162, 6265, 67, 1, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.15"}]},
  "11.16"->{
    Cell[167232, 6268, 104, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.16"}]},
  "11.17"->{
    Cell[167339, 6271, 116, 5, 70, "Program",
      CellTags->{"S2.13.11", "11.17"}]},
  "11.18"->{
    Cell[167458, 6278, 94, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.18"}]},
  "11.19"->{
    Cell[167555, 6281, 101, 4, 70, "Program",
      CellTags->{"S2.13.11", "11.19"}]},
  "11.20"->{
    Cell[167659, 6287, 116, 4, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.20"}]},
  "11.21"->{
    Cell[167778, 6293, 117, 5, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.21"}]},
  "S2.13.12"->{
    Cell[168007, 6307, 109, 1, 70, "Subsection",
      CellTags->{"S2.13.12", "12.1"}],
    Cell[168119, 6310, 705, 15, 70, "Text",
      CellTags->{"S2.13.12", "12.2"}],
    Cell[168827, 6327, 1511, 47, 70, "DefinitionBox",
      CellTags->"S2.13.12"],
    Cell[170341, 6376, 86, 1, 70, "Caption",
      CellTags->"S2.13.12"],
    Cell[170430, 6379, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.3"}],
    Cell[170490, 6382, 56, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.4"}],
    Cell[170549, 6385, 85, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.5"}],
    Cell[170637, 6388, 89, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.6"}],
    Cell[170729, 6391, 190, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.7"}],
    Cell[170922, 6400, 142, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.8"}],
    Cell[171067, 6407, 56, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.9"}],
    Cell[171126, 6410, 112, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.10"}],
    Cell[171241, 6413, 142, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.11"}],
    Cell[171386, 6420, 57, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.12"}],
    Cell[171446, 6423, 95, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.13"}],
    Cell[171544, 6426, 66, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.14"}],
    Cell[171613, 6429, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.15"}],
    Cell[171677, 6432, 310, 9, 70, "Text",
      CellTags->{"S2.13.12", "12.16"}],
    Cell[171990, 6443, 313, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.17"}],
    Cell[172306, 6455, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.18"}],
    Cell[172367, 6458, 57, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.19"}],
    Cell[172427, 6461, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.20"}],
    Cell[172574, 6468, 122, 4, 70, "Program",
      CellTags->{"S2.13.12", "12.21"}],
    Cell[172699, 6474, 180, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.22"}],
    Cell[172882, 6483, 99, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.23"}],
    Cell[172984, 6486, 187, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.24"}],
    Cell[173174, 6495, 88, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.25"}],
    Cell[173265, 6498, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.26"}],
    Cell[173329, 6501, 208, 5, 70, "Text",
      CellTags->{"S2.13.12", "12.27"}],
    Cell[173540, 6508, 406, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.28"}],
    Cell[173949, 6520, 1651, 52, 70, "DefinitionBox",
      CellTags->"S2.13.12"],
    Cell[175603, 6574, 123, 5, 70, "Caption",
      CellTags->"S2.13.12"],
    Cell[175729, 6581, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.29"}],
    Cell[175790, 6584, 57, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.30"}],
    Cell[175850, 6587, 149, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.31"}],
    Cell[176002, 6594, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.32"}],
    Cell[176080, 6597, 130, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.33"}],
    Cell[176213, 6604, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.34"}],
    Cell[176291, 6607, 120, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.35"}],
    Cell[176414, 6614, 84, 4, 70, "Program",
      CellTags->{"S2.13.12", "12.36"}],
    Cell[176501, 6620, 195, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.37"}],
    Cell[176699, 6629, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.38"}],
    Cell[176777, 6632, 117, 2, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.39"}],
    Cell[176897, 6636, 78, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.40"}],
    Cell[176978, 6639, 125, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.41"}],
    Cell[177106, 6646, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.42"}],
    Cell[177184, 6649, 125, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.43"}],
    Cell[177312, 6656, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.44"}],
    Cell[177390, 6659, 102, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.45"}],
    Cell[177495, 6662, 78, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.46"}],
    Cell[177576, 6665, 131, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.47"}],
    Cell[177710, 6672, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.48"}],
    Cell[177788, 6675, 179, 4, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.49"}],
    Cell[177970, 6681, 78, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.50"}],
    Cell[178051, 6684, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.51"}],
    Cell[178115, 6687, 480, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.52"}],
    Cell[178598, 6699, 3097, 97, 70, "DefinitionBox",
      CellTags->"S2.13.12"],
    Cell[181698, 6798, 100, 1, 70, "Caption",
      CellTags->"S2.13.12"],
    Cell[181801, 6801, 1005, 33, 70, "DefinitionBox",
      CellTags->"S2.13.12"],
    Cell[182809, 6836, 122, 5, 70, "Caption",
      CellTags->"S2.13.12"],
    Cell[182934, 6843, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.53"}],
    Cell[182995, 6846, 77, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.54"}],
    Cell[183075, 6849, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.55"}],
    Cell[183169, 6852, 511, 17, 70, "Program",
      CellTags->{"S2.13.12", "12.56"}],
    Cell[183683, 6871, 86, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.57"}],
    Cell[183772, 6874, 124, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.58"}],
    Cell[183899, 6881, 88, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.59"}],
    Cell[183990, 6884, 122, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.60"}],
    Cell[184115, 6891, 55, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.61"}],
    Cell[184173, 6894, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.62"}],
    Cell[184237, 6897, 359, 9, 70, "Text",
      CellTags->{"S2.13.12", "12.63"}],
    Cell[184599, 6908, 393, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.64"}],
    Cell[184995, 6920, 3080, 97, 70, "DefinitionBox",
      CellTags->"S2.13.12"],
    Cell[188078, 7019, 100, 1, 70, "Caption",
      CellTags->"S2.13.12"],
    Cell[188181, 7022, 314, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.65"}]},
  "12.1"->{
    Cell[168007, 6307, 109, 1, 70, "Subsection",
      CellTags->{"S2.13.12", "12.1"}]},
  "12.2"->{
    Cell[168119, 6310, 705, 15, 70, "Text",
      CellTags->{"S2.13.12", "12.2"}]},
  "12.3"->{
    Cell[170430, 6379, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.3"}]},
  "12.4"->{
    Cell[170490, 6382, 56, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.4"}]},
  "12.5"->{
    Cell[170549, 6385, 85, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.5"}]},
  "12.6"->{
    Cell[170637, 6388, 89, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.6"}]},
  "12.7"->{
    Cell[170729, 6391, 190, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.7"}]},
  "12.8"->{
    Cell[170922, 6400, 142, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.8"}]},
  "12.9"->{
    Cell[171067, 6407, 56, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.9"}]},
  "12.10"->{
    Cell[171126, 6410, 112, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.10"}]},
  "12.11"->{
    Cell[171241, 6413, 142, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.11"}]},
  "12.12"->{
    Cell[171386, 6420, 57, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.12"}]},
  "12.13"->{
    Cell[171446, 6423, 95, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.13"}]},
  "12.14"->{
    Cell[171544, 6426, 66, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.14"}]},
  "12.15"->{
    Cell[171613, 6429, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.15"}]},
  "12.16"->{
    Cell[171677, 6432, 310, 9, 70, "Text",
      CellTags->{"S2.13.12", "12.16"}]},
  "12.17"->{
    Cell[171990, 6443, 313, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.17"}]},
  "12.18"->{
    Cell[172306, 6455, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.18"}]},
  "12.19"->{
    Cell[172367, 6458, 57, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.19"}]},
  "12.20"->{
    Cell[172427, 6461, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.20"}]},
  "12.21"->{
    Cell[172574, 6468, 122, 4, 70, "Program",
      CellTags->{"S2.13.12", "12.21"}]},
  "12.22"->{
    Cell[172699, 6474, 180, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.22"}]},
  "12.23"->{
    Cell[172882, 6483, 99, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.23"}]},
  "12.24"->{
    Cell[172984, 6486, 187, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.24"}]},
  "12.25"->{
    Cell[173174, 6495, 88, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.25"}]},
  "12.26"->{
    Cell[173265, 6498, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.26"}]},
  "12.27"->{
    Cell[173329, 6501, 208, 5, 70, "Text",
      CellTags->{"S2.13.12", "12.27"}]},
  "12.28"->{
    Cell[173540, 6508, 406, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.28"}]},
  "12.29"->{
    Cell[175729, 6581, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.29"}]},
  "12.30"->{
    Cell[175790, 6584, 57, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.30"}]},
  "12.31"->{
    Cell[175850, 6587, 149, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.31"}]},
  "12.32"->{
    Cell[176002, 6594, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.32"}]},
  "12.33"->{
    Cell[176080, 6597, 130, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.33"}]},
  "12.34"->{
    Cell[176213, 6604, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.34"}]},
  "12.35"->{
    Cell[176291, 6607, 120, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.35"}]},
  "12.36"->{
    Cell[176414, 6614, 84, 4, 70, "Program",
      CellTags->{"S2.13.12", "12.36"}]},
  "12.37"->{
    Cell[176501, 6620, 195, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.37"}]},
  "12.38"->{
    Cell[176699, 6629, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.38"}]},
  "12.39"->{
    Cell[176777, 6632, 117, 2, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.39"}]},
  "12.40"->{
    Cell[176897, 6636, 78, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.40"}]},
  "12.41"->{
    Cell[176978, 6639, 125, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.41"}]},
  "12.42"->{
    Cell[177106, 6646, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.42"}]},
  "12.43"->{
    Cell[177184, 6649, 125, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.43"}]},
  "12.44"->{
    Cell[177312, 6656, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.44"}]},
  "12.45"->{
    Cell[177390, 6659, 102, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.45"}]},
  "12.46"->{
    Cell[177495, 6662, 78, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.46"}]},
  "12.47"->{
    Cell[177576, 6665, 131, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.47"}]},
  "12.48"->{
    Cell[177710, 6672, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.48"}]},
  "12.49"->{
    Cell[177788, 6675, 179, 4, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.49"}]},
  "12.50"->{
    Cell[177970, 6681, 78, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.50"}]},
  "12.51"->{
    Cell[178051, 6684, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.51"}]},
  "12.52"->{
    Cell[178115, 6687, 480, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.52"}]},
  "12.53"->{
    Cell[182934, 6843, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.53"}]},
  "12.54"->{
    Cell[182995, 6846, 77, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.54"}]},
  "12.55"->{
    Cell[183075, 6849, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.55"}]},
  "12.56"->{
    Cell[183169, 6852, 511, 17, 70, "Program",
      CellTags->{"S2.13.12", "12.56"}]},
  "12.57"->{
    Cell[183683, 6871, 86, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.57"}]},
  "12.58"->{
    Cell[183772, 6874, 124, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.58"}]},
  "12.59"->{
    Cell[183899, 6881, 88, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.59"}]},
  "12.60"->{
    Cell[183990, 6884, 122, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.60"}]},
  "12.61"->{
    Cell[184115, 6891, 55, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.61"}]},
  "12.62"->{
    Cell[184173, 6894, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.62"}]},
  "12.63"->{
    Cell[184237, 6897, 359, 9, 70, "Text",
      CellTags->{"S2.13.12", "12.63"}]},
  "12.64"->{
    Cell[184599, 6908, 393, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.64"}]},
  "12.65"->{
    Cell[188181, 7022, 314, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.65"}]},
  "S2.13.13"->{
    Cell[188532, 7037, 108, 1, 70, "Subsection",
      CellTags->{"S2.13.13", "13.1"}],
    Cell[188643, 7040, 375, 9, 70, "Text",
      CellTags->{"S2.13.13", "13.2"}],
    Cell[189021, 7051, 1433, 42, 70, "DefinitionBox",
      CellTags->"S2.13.13"],
    Cell[190457, 7095, 125, 5, 70, "Caption",
      CellTags->"S2.13.13"],
    Cell[190585, 7102, 320, 9, 70, "Text",
      CellTags->{"S2.13.13", "13.3"}],
    Cell[190908, 7113, 516, 15, 70, "DefinitionBox",
      CellTags->"S2.13.13"],
    Cell[191427, 7130, 81, 1, 70, "Caption",
      CellTags->"S2.13.13"],
    Cell[191511, 7133, 260, 7, 70, "Text",
      CellTags->{"S2.13.13", "13.4"}],
    Cell[191774, 7142, 695, 14, 70, "Text",
      CellTags->{"S2.13.13", "13.5"}],
    Cell[192472, 7158, 550, 16, 70, "DefinitionBox",
      CellTags->"S2.13.13"],
    Cell[193025, 7176, 73, 1, 70, "Caption",
      CellTags->"S2.13.13"],
    Cell[193101, 7179, 452, 11, 70, "Text",
      CellTags->{"S2.13.13", "13.6"}],
    Cell[193556, 7192, 387, 9, 70, "Text",
      CellTags->{"S2.13.13", "13.7"}]},
  "13.1"->{
    Cell[188532, 7037, 108, 1, 70, "Subsection",
      CellTags->{"S2.13.13", "13.1"}]},
  "13.2"->{
    Cell[188643, 7040, 375, 9, 70, "Text",
      CellTags->{"S2.13.13", "13.2"}]},
  "13.3"->{
    Cell[190585, 7102, 320, 9, 70, "Text",
      CellTags->{"S2.13.13", "13.3"}]},
  "13.4"->{
    Cell[191511, 7133, 260, 7, 70, "Text",
      CellTags->{"S2.13.13", "13.4"}]},
  "13.5"->{
    Cell[191774, 7142, 695, 14, 70, "Text",
      CellTags->{"S2.13.13", "13.5"}]},
  "13.6"->{
    Cell[193101, 7179, 452, 11, 70, "Text",
      CellTags->{"S2.13.13", "13.6"}]},
  "13.7"->{
    Cell[193556, 7192, 387, 9, 70, "Text",
      CellTags->{"S2.13.13", "13.7"}]},
  "S2.13.14"->{
    Cell[193980, 7206, 160, 5, 70, "Subsection",
      CellTags->{"S2.13.14", "14.1"}],
    Cell[194143, 7213, 363, 12, 70, "Text",
      CellTags->{"S2.13.14", "14.2"}],
    Cell[194509, 7227, 639, 19, 70, "Text",
      CellTags->{"S2.13.14", "14.3"}],
    Cell[195151, 7248, 3655, 115, 70, "DefinitionBox",
      CellTags->"S2.13.14"],
    Cell[198809, 7365, 129, 5, 70, "Caption",
      CellTags->"S2.13.14"],
    Cell[198941, 7372, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.14", "14.4"}],
    Cell[199001, 7375, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.5"}],
    Cell[199148, 7382, 85, 4, 70, "Program",
      CellTags->{"S2.13.14", "14.6"}],
    Cell[199236, 7388, 87, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.7"}],
    Cell[199326, 7391, 105, 6, 70, "Program",
      CellTags->{"S2.13.14", "14.8"}],
    Cell[199434, 7399, 146, 5, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.9"}],
    Cell[199583, 7406, 79, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.10"}],
    Cell[199665, 7409, 199, 6, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.11"}],
    Cell[199867, 7417, 105, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.12"}],
    Cell[199975, 7420, 140, 4, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.13"}],
    Cell[200118, 7426, 74, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.14"}],
    Cell[200195, 7429, 70, 4, 70, "Program",
      CellTags->{"S2.13.14", "14.15"}],
    Cell[200268, 7435, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.14", "14.16"}],
    Cell[200332, 7438, 586, 19, 70, "Text",
      CellTags->{"S2.13.14", "14.17"}],
    Cell[200921, 7459, 375, 14, 70, "Text",
      CellTags->{"S2.13.14", "14.18"}],
    Cell[201299, 7475, 1893, 58, 70, "DefinitionBox",
      CellTags->"S2.13.14"],
    Cell[203195, 7535, 174, 7, 70, "Caption",
      CellTags->"S2.13.14"],
    Cell[203372, 7544, 278, 8, 70, "Text",
      CellTags->{"S2.13.14", "14.19"}],
    Cell[203653, 7554, 305, 9, 70, "Text",
      CellTags->{"S2.13.14", "14.20"}],
    Cell[203961, 7565, 1123, 33, 70, "DefinitionBox",
      CellTags->"S2.13.14"],
    Cell[205087, 7600, 154, 5, 70, "Caption",
      CellTags->"S2.13.14"],
    Cell[205244, 7607, 312, 9, 70, "Text",
      CellTags->{"S2.13.14", "14.21"}],
    Cell[205559, 7618, 284, 7, 56, "Text",
      CellTags->{"S2.13.14", "14.22"}],
    Cell[205846, 7627, 249, 6, 70, "Text",
      CellTags->{"S2.13.14", "14.23"}],
    Cell[206098, 7635, 4256, 123, 420, "DefinitionBox3Col",
      CellTags->"S2.13.14"],
    Cell[210357, 7760, 130, 5, 16, "Caption",
      CellTags->"S2.13.14"],
    Cell[210490, 7767, 58, 1, 20, "ProgramTop",
      CellTags->{"S2.13.14", "14.24"}],
    Cell[210551, 7770, 201, 6, 56, "MathCaption",
      CellTags->{"S2.13.14", "14.25"}],
    Cell[210755, 7778, 135, 4, 44, "Program",
      CellTags->{"S2.13.14", "14.26"}],
    Cell[210893, 7784, 61, 1, 8, "ProgramBottom",
      CellTags->{"S2.13.14", "14.27"}],
    Cell[210957, 7787, 407, 11, 56, "Text",
      CellTags->{"S2.13.14", "14.28"}],
    Cell[211367, 7800, 196, 6, 40, "Text",
      CellTags->{"S2.13.14", "14.29"}],
    Cell[211566, 7808, 896, 29, 102, "DefinitionBox",
      CellTags->"S2.13.14"],
    Cell[212465, 7839, 66, 1, 16, "Caption",
      CellTags->"S2.13.14"],
    Cell[212534, 7842, 505, 12, 88, "Text",
      CellTags->{"S2.13.14", "14.30"}],
    Cell[213042, 7856, 466, 17, 56, "Text",
      CellTags->{"S2.13.14", "14.31"}],
    Cell[213511, 7875, 397, 10, 56, "Text",
      CellTags->{"S2.13.14", "14.32"}]},
  "14.1"->{
    Cell[193980, 7206, 160, 5, 70, "Subsection",
      CellTags->{"S2.13.14", "14.1"}]},
  "14.2"->{
    Cell[194143, 7213, 363, 12, 70, "Text",
      CellTags->{"S2.13.14", "14.2"}]},
  "14.3"->{
    Cell[194509, 7227, 639, 19, 70, "Text",
      CellTags->{"S2.13.14", "14.3"}]},
  "14.4"->{
    Cell[198941, 7372, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.14", "14.4"}]},
  "14.5"->{
    Cell[199001, 7375, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.5"}]},
  "14.6"->{
    Cell[199148, 7382, 85, 4, 70, "Program",
      CellTags->{"S2.13.14", "14.6"}]},
  "14.7"->{
    Cell[199236, 7388, 87, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.7"}]},
  "14.8"->{
    Cell[199326, 7391, 105, 6, 70, "Program",
      CellTags->{"S2.13.14", "14.8"}]},
  "14.9"->{
    Cell[199434, 7399, 146, 5, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.9"}]},
  "14.10"->{
    Cell[199583, 7406, 79, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.10"}]},
  "14.11"->{
    Cell[199665, 7409, 199, 6, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.11"}]},
  "14.12"->{
    Cell[199867, 7417, 105, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.12"}]},
  "14.13"->{
    Cell[199975, 7420, 140, 4, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.13"}]},
  "14.14"->{
    Cell[200118, 7426, 74, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.14"}]},
  "14.15"->{
    Cell[200195, 7429, 70, 4, 70, "Program",
      CellTags->{"S2.13.14", "14.15"}]},
  "14.16"->{
    Cell[200268, 7435, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.14", "14.16"}]},
  "14.17"->{
    Cell[200332, 7438, 586, 19, 70, "Text",
      CellTags->{"S2.13.14", "14.17"}]},
  "14.18"->{
    Cell[200921, 7459, 375, 14, 70, "Text",
      CellTags->{"S2.13.14", "14.18"}]},
  "14.19"->{
    Cell[203372, 7544, 278, 8, 70, "Text",
      CellTags->{"S2.13.14", "14.19"}]},
  "14.20"->{
    Cell[203653, 7554, 305, 9, 70, "Text",
      CellTags->{"S2.13.14", "14.20"}]},
  "14.21"->{
    Cell[205244, 7607, 312, 9, 70, "Text",
      CellTags->{"S2.13.14", "14.21"}]},
  "14.22"->{
    Cell[205559, 7618, 284, 7, 56, "Text",
      CellTags->{"S2.13.14", "14.22"}]},
  "14.23"->{
    Cell[205846, 7627, 249, 6, 70, "Text",
      CellTags->{"S2.13.14", "14.23"}]},
  "14.24"->{
    Cell[210490, 7767, 58, 1, 20, "ProgramTop",
      CellTags->{"S2.13.14", "14.24"}]},
  "14.25"->{
    Cell[210551, 7770, 201, 6, 56, "MathCaption",
      CellTags->{"S2.13.14", "14.25"}]},
  "14.26"->{
    Cell[210755, 7778, 135, 4, 44, "Program",
      CellTags->{"S2.13.14", "14.26"}]},
  "14.27"->{
    Cell[210893, 7784, 61, 1, 8, "ProgramBottom",
      CellTags->{"S2.13.14", "14.27"}]},
  "14.28"->{
    Cell[210957, 7787, 407, 11, 56, "Text",
      CellTags->{"S2.13.14", "14.28"}]},
  "14.29"->{
    Cell[211367, 7800, 196, 6, 40, "Text",
      CellTags->{"S2.13.14", "14.29"}]},
  "14.30"->{
    Cell[212534, 7842, 505, 12, 88, "Text",
      CellTags->{"S2.13.14", "14.30"}]},
  "14.31"->{
    Cell[213042, 7856, 466, 17, 56, "Text",
      CellTags->{"S2.13.14", "14.31"}]},
  "14.32"->{
    Cell[213511, 7875, 397, 10, 56, "Text",
      CellTags->{"S2.13.14", "14.32"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.13.0", 214552, 7905},
  {"0.1", 214643, 7908},
  {"S2.13.1", 214738, 7911},
  {"1.1", 216186, 7950},
  {"1.2", 216280, 7953},
  {"1.3", 216369, 7956},
  {"1.4", 216458, 7959},
  {"1.5", 216547, 7962},
  {"1.6", 216636, 7965},
  {"1.7", 216725, 7968},
  {"1.8", 216815, 7971},
  {"1.9", 216905, 7974},
  {"1.10", 216995, 7977},
  {"1.11", 217086, 7980},
  {"S2.13.2", 217180, 7983},
  {"2.1", 218564, 8020},
  {"2.2", 218659, 8023},
  {"2.3", 218749, 8026},
  {"2.4", 218846, 8029},
  {"2.5", 218943, 8032},
  {"2.6", 219040, 8035},
  {"2.7", 219130, 8038},
  {"2.8", 219221, 8041},
  {"S2.13.3", 219316, 8044},
  {"3.1", 227982, 8259},
  {"3.2", 228078, 8262},
  {"3.3", 228168, 8265},
  {"3.4", 228258, 8268},
  {"3.5", 228353, 8271},
  {"3.6", 228446, 8274},
  {"3.7", 228544, 8277},
  {"3.8", 228635, 8280},
  {"3.9", 228730, 8283},
  {"3.10", 228828, 8286},
  {"3.11", 228922, 8289},
  {"3.12", 229021, 8292},
  {"3.13", 229117, 8295},
  {"3.14", 229216, 8298},
  {"3.15", 229312, 8301},
  {"3.16", 229412, 8304},
  {"3.17", 229504, 8307},
  {"3.18", 229596, 8310},
  {"3.19", 229688, 8313},
  {"3.20", 229781, 8316},
  {"3.21", 229878, 8319},
  {"3.22", 229977, 8322},
  {"3.23", 230071, 8325},
  {"3.24", 230171, 8328},
  {"3.25", 230270, 8331},
  {"3.26", 230370, 8334},
  {"3.27", 230469, 8337},
  {"3.28", 230562, 8340},
  {"3.29", 230661, 8343},
  {"3.30", 230760, 8346},
  {"3.31", 230859, 8349},
  {"3.32", 230952, 8352},
  {"3.33", 231050, 8355},
  {"3.34", 231145, 8358},
  {"3.35", 231245, 8361},
  {"3.36", 231340, 8364},
  {"3.37", 231440, 8367},
  {"3.38", 231535, 8370},
  {"3.39", 231635, 8373},
  {"3.40", 231732, 8376},
  {"3.41", 231832, 8379},
  {"3.42", 231929, 8382},
  {"3.43", 232029, 8385},
  {"3.44", 232124, 8388},
  {"3.45", 232219, 8391},
  {"3.46", 232320, 8394},
  {"3.47", 232414, 8397},
  {"3.48", 232507, 8400},
  {"3.49", 232601, 8403},
  {"3.50", 232699, 8406},
  {"3.51", 232799, 8409},
  {"3.52", 232895, 8412},
  {"3.53", 232996, 8415},
  {"3.54", 233090, 8418},
  {"3.55", 233188, 8421},
  {"3.56", 233288, 8424},
  {"3.57", 233384, 8427},
  {"3.58", 233484, 8430},
  {"3.59", 233581, 8433},
  {"3.60", 233682, 8436},
  {"3.61", 233779, 8439},
  {"3.62", 233879, 8442},
  {"3.63", 233975, 8445},
  {"3.64", 234076, 8448},
  {"3.65", 234174, 8451},
  {"3.66", 234274, 8454},
  {"3.67", 234371, 8457},
  {"3.68", 234472, 8460},
  {"3.69", 234569, 8463},
  {"3.70", 234670, 8466},
  {"3.71", 234764, 8469},
  {"3.72", 234862, 8472},
  {"3.73", 234957, 8475},
  {"3.74", 235058, 8478},
  {"3.75", 235154, 8481},
  {"3.76", 235249, 8484},
  {"3.77", 235350, 8487},
  {"3.78", 235450, 8490},
  {"3.79", 235550, 8493},
  {"S2.13.4", 235647, 8496},
  {"4.1", 252589, 8907},
  {"4.2", 252686, 8910},
  {"4.3", 252778, 8913},
  {"4.4", 252874, 8916},
  {"4.5", 252972, 8919},
  {"4.6", 253067, 8922},
  {"4.7", 253165, 8925},
  {"4.8", 253260, 8928},
  {"4.9", 253359, 8931},
  {"4.10", 253458, 8934},
  {"4.11", 253557, 8937},
  {"4.12", 253657, 8940},
  {"4.13", 253757, 8943},
  {"4.14", 253850, 8946},
  {"4.15", 253948, 8949},
  {"4.16", 254048, 8952},
  {"4.17", 254145, 8955},
  {"4.18", 254245, 8958},
  {"4.19", 254341, 8961},
  {"4.20", 254442, 8964},
  {"4.21", 254535, 8967},
  {"4.22", 254629, 8970},
  {"4.23", 254723, 8973},
  {"4.24", 254817, 8976},
  {"4.25", 254915, 8979},
  {"4.26", 255015, 8982},
  {"4.27", 255112, 8985},
  {"4.28", 255212, 8988},
  {"4.29", 255307, 8991},
  {"4.30", 255407, 8994},
  {"4.31", 255504, 8997},
  {"4.32", 255604, 9000},
  {"4.33", 255700, 9003},
  {"4.34", 255801, 9006},
  {"4.35", 255901, 9009},
  {"4.36", 256001, 9012},
  {"4.37", 256095, 9015},
  {"4.38", 256193, 9018},
  {"4.39", 256288, 9021},
  {"4.40", 256388, 9024},
  {"4.41", 256483, 9027},
  {"4.42", 256583, 9030},
  {"4.43", 256680, 9033},
  {"4.44", 256775, 9036},
  {"4.45", 256875, 9039},
  {"4.46", 256971, 9042},
  {"4.47", 257066, 9045},
  {"4.48", 257167, 9048},
  {"4.49", 257261, 9051},
  {"4.50", 257359, 9054},
  {"4.51", 257459, 9057},
  {"4.52", 257554, 9060},
  {"4.53", 257654, 9063},
  {"4.54", 257749, 9066},
  {"4.55", 257849, 9069},
  {"4.56", 257944, 9072},
  {"4.57", 258045, 9075},
  {"4.58", 258139, 9078},
  {"4.59", 258237, 9081},
  {"4.60", 258337, 9084},
  {"4.61", 258432, 9087},
  {"4.62", 258532, 9090},
  {"4.63", 258627, 9093},
  {"4.64", 258727, 9096},
  {"4.65", 258822, 9099},
  {"4.66", 258922, 9102},
  {"4.67", 259017, 9105},
  {"4.68", 259116, 9108},
  {"4.69", 259211, 9111},
  {"4.70", 259312, 9114},
  {"4.71", 259406, 9117},
  {"4.72", 259504, 9120},
  {"4.73", 259599, 9123},
  {"4.74", 259699, 9126},
  {"4.75", 259794, 9129},
  {"4.76", 259889, 9132},
  {"4.77", 259989, 9135},
  {"4.78", 260084, 9138},
  {"4.79", 260179, 9141},
  {"4.80", 260279, 9144},
  {"4.81", 260374, 9147},
  {"4.82", 260469, 9150},
  {"4.83", 260568, 9153},
  {"4.84", 260663, 9156},
  {"4.85", 260758, 9159},
  {"4.86", 260853, 9162},
  {"4.87", 260954, 9165},
  {"4.88", 261048, 9168},
  {"4.89", 261141, 9171},
  {"4.90", 261241, 9174},
  {"4.91", 261341, 9177},
  {"4.92", 261441, 9180},
  {"4.93", 261541, 9183},
  {"4.94", 261634, 9186},
  {"4.95", 261732, 9189},
  {"4.96", 261832, 9192},
  {"4.97", 261927, 9195},
  {"4.98", 262023, 9198},
  {"4.99", 262123, 9201},
  {"4.100", 262219, 9204},
  {"4.101", 262320, 9207},
  {"4.102", 262418, 9210},
  {"4.103", 262515, 9213},
  {"4.104", 262617, 9216},
  {"4.105", 262714, 9219},
  {"4.106", 262817, 9222},
  {"4.107", 262913, 9225},
  {"4.108", 263009, 9228},
  {"4.109", 263109, 9231},
  {"4.110", 263206, 9234},
  {"4.111", 263308, 9237},
  {"4.112", 263405, 9240},
  {"4.113", 263507, 9243},
  {"4.114", 263606, 9246},
  {"4.115", 263708, 9249},
  {"4.116", 263807, 9252},
  {"4.117", 263904, 9255},
  {"4.118", 264006, 9258},
  {"4.119", 264103, 9261},
  {"4.120", 264205, 9264},
  {"4.121", 264302, 9267},
  {"4.122", 264404, 9270},
  {"4.123", 264502, 9273},
  {"4.124", 264599, 9276},
  {"4.125", 264702, 9279},
  {"4.126", 264798, 9282},
  {"4.127", 264898, 9285},
  {"4.128", 264995, 9288},
  {"4.129", 265097, 9291},
  {"4.130", 265196, 9294},
  {"4.131", 265298, 9297},
  {"4.132", 265397, 9300},
  {"4.133", 265499, 9303},
  {"4.134", 265598, 9306},
  {"4.135", 265695, 9309},
  {"4.136", 265797, 9312},
  {"4.137", 265894, 9315},
  {"4.138", 265995, 9318},
  {"4.139", 266092, 9321},
  {"4.140", 266194, 9324},
  {"4.141", 266292, 9327},
  {"4.142", 266394, 9330},
  {"4.143", 266492, 9333},
  {"4.144", 266589, 9336},
  {"4.145", 266692, 9339},
  {"4.146", 266787, 9342},
  {"4.147", 266882, 9345},
  {"4.148", 266978, 9348},
  {"4.149", 267073, 9351},
  {"4.150", 267169, 9354},
  {"4.151", 267269, 9357},
  {"4.152", 267371, 9360},
  {"4.153", 267468, 9363},
  {"4.154", 267570, 9366},
  {"4.155", 267667, 9369},
  {"4.156", 267769, 9372},
  {"4.157", 267867, 9375},
  {"4.158", 267964, 9378},
  {"4.159", 268066, 9381},
  {"4.160", 268163, 9384},
  {"4.161", 268260, 9387},
  {"4.162", 268363, 9390},
  {"4.163", 268459, 9393},
  {"4.164", 268555, 9396},
  {"4.165", 268651, 9399},
  {"4.166", 268747, 9402},
  {"4.167", 268843, 9405},
  {"4.168", 268939, 9408},
  {"4.169", 269035, 9411},
  {"S2.13.5", 269133, 9414},
  {"5.1", 271133, 9465},
  {"5.2", 271230, 9468},
  {"5.3", 271321, 9471},
  {"5.4", 271413, 9474},
  {"5.5", 271505, 9477},
  {"5.6", 271596, 9480},
  {"5.7", 271687, 9483},
  {"5.8", 271778, 9486},
  {"5.9", 271871, 9489},
  {"5.10", 271965, 9492},
  {"5.11", 272060, 9495},
  {"5.12", 272155, 9498},
  {"5.13", 272250, 9501},
  {"5.14", 272345, 9504},
  {"5.15", 272440, 9507},
  {"S2.13.6", 272538, 9510},
  {"6.1", 278387, 9657},
  {"6.2", 278485, 9660},
  {"6.3", 278584, 9663},
  {"6.4", 278682, 9666},
  {"6.5", 278781, 9669},
  {"6.6", 278879, 9672},
  {"6.7", 278978, 9675},
  {"6.8", 279077, 9678},
  {"6.9", 279176, 9681},
  {"6.10", 279276, 9684},
  {"6.11", 279376, 9687},
  {"6.12", 279477, 9690},
  {"6.13", 279578, 9693},
  {"6.14", 279672, 9696},
  {"6.15", 279766, 9699},
  {"6.16", 279867, 9702},
  {"6.17", 279968, 9705},
  {"6.18", 280069, 9708},
  {"6.19", 280170, 9711},
  {"6.20", 280270, 9714},
  {"6.21", 280365, 9717},
  {"6.22", 280460, 9720},
  {"6.23", 280561, 9723},
  {"6.24", 280662, 9726},
  {"6.25", 280763, 9729},
  {"6.26", 280863, 9732},
  {"6.27", 280964, 9735},
  {"6.28", 281065, 9738},
  {"6.29", 281166, 9741},
  {"6.30", 281260, 9744},
  {"6.31", 281354, 9747},
  {"6.32", 281448, 9750},
  {"6.33", 281550, 9753},
  {"6.34", 281651, 9756},
  {"6.35", 281753, 9759},
  {"6.36", 281854, 9762},
  {"6.37", 281955, 9765},
  {"6.38", 282057, 9768},
  {"6.39", 282158, 9771},
  {"6.40", 282252, 9774},
  {"S2.13.7", 282350, 9777},
  {"7.1", 289148, 9952},
  {"7.2", 289246, 9955},
  {"7.3", 289345, 9958},
  {"7.4", 289444, 9961},
  {"7.5", 289543, 9964},
  {"7.6", 289642, 9967},
  {"7.7", 289741, 9970},
  {"7.8", 289834, 9973},
  {"7.9", 289933, 9976},
  {"7.10", 290033, 9979},
  {"7.11", 290134, 9982},
  {"7.12", 290235, 9985},
  {"7.13", 290336, 9988},
  {"7.14", 290431, 9991},
  {"7.15", 290532, 9994},
  {"7.16", 290633, 9997},
  {"7.17", 290728, 10000},
  {"7.18", 290823, 10003},
  {"7.19", 290924, 10006},
  {"7.20", 291025, 10009},
  {"7.21", 291126, 10012},
  {"7.22", 291227, 10015},
  {"7.23", 291328, 10018},
  {"7.24", 291423, 10021},
  {"7.25", 291524, 10024},
  {"7.26", 291625, 10027},
  {"7.27", 291726, 10030},
  {"7.28", 291826, 10033},
  {"7.29", 291927, 10036},
  {"7.30", 292028, 10039},
  {"7.31", 292128, 10042},
  {"7.32", 292228, 10045},
  {"S2.13.8", 292332, 10048},
  {"8.1", 294260, 10097},
  {"8.2", 294358, 10100},
  {"8.3", 294451, 10103},
  {"8.4", 294543, 10106},
  {"8.5", 294635, 10109},
  {"8.6", 294734, 10112},
  {"8.7", 294832, 10115},
  {"8.8", 294931, 10118},
  {"8.9", 295030, 10121},
  {"8.10", 295130, 10124},
  {"8.11", 295231, 10127},
  {"8.12", 295332, 10130},
  {"8.13", 295432, 10133},
  {"8.14", 295526, 10136},
  {"S2.13.9", 295624, 10139},
  {"9.1", 300882, 10270},
  {"9.2", 300980, 10273},
  {"9.3", 301073, 10276},
  {"9.4", 301172, 10279},
  {"9.5", 301271, 10282},
  {"9.6", 301370, 10285},
  {"9.7", 301469, 10288},
  {"9.8", 301562, 10291},
  {"9.9", 301659, 10294},
  {"9.10", 301754, 10297},
  {"9.11", 301855, 10300},
  {"9.12", 301951, 10303},
  {"9.13", 302049, 10306},
  {"9.14", 302150, 10309},
  {"9.15", 302246, 10312},
  {"9.16", 302344, 10315},
  {"9.17", 302446, 10318},
  {"9.18", 302547, 10321},
  {"9.19", 302647, 10324},
  {"9.20", 302748, 10327},
  {"9.21", 302849, 10330},
  {"9.22", 302950, 10333},
  {"9.23", 303044, 10336},
  {"9.24", 303138, 10339},
  {"9.25", 303233, 10342},
  {"9.26", 303328, 10345},
  {"9.27", 303422, 10348},
  {"9.28", 303521, 10351},
  {"9.29", 303617, 10354},
  {"9.30", 303718, 10357},
  {"9.31", 303814, 10360},
  {"9.32", 303915, 10363},
  {"9.33", 304012, 10366},
  {"9.34", 304113, 10369},
  {"9.35", 304209, 10372},
  {"9.36", 304310, 10375},
  {"9.37", 304406, 10378},
  {"9.38", 304507, 10381},
  {"9.39", 304603, 10384},
  {"9.40", 304699, 10387},
  {"9.41", 304801, 10390},
  {"S2.13.10", 304900, 10393},
  {"10.1", 306323, 10428},
  {"10.2", 306424, 10431},
  {"10.3", 306520, 10434},
  {"10.4", 306623, 10437},
  {"10.5", 306725, 10440},
  {"10.6", 306823, 10443},
  {"10.7", 306925, 10446},
  {"10.8", 307023, 10449},
  {"10.9", 307126, 10452},
  {"10.10", 307229, 10455},
  {"10.11", 307333, 10458},
  {"S2.13.11", 307434, 10461},
  {"11.1", 309735, 10516},
  {"11.2", 309836, 10519},
  {"11.3", 309931, 10522},
  {"11.4", 310026, 10525},
  {"11.5", 310121, 10528},
  {"11.6", 310223, 10531},
  {"11.7", 310325, 10534},
  {"11.8", 310424, 10537},
  {"11.9", 310525, 10540},
  {"11.10", 310624, 10543},
  {"11.11", 310728, 10546},
  {"11.12", 310828, 10549},
  {"11.13", 310933, 10552},
  {"11.14", 311037, 10555},
  {"11.15", 311141, 10558},
  {"11.16", 311245, 10561},
  {"11.17", 311349, 10564},
  {"11.18", 311449, 10567},
  {"11.19", 311552, 10570},
  {"11.20", 311652, 10573},
  {"11.21", 311757, 10576},
  {"S2.13.12", 311864, 10579},
  {"12.1", 318312, 10730},
  {"12.2", 318413, 10733},
  {"12.3", 318509, 10736},
  {"12.4", 318609, 10739},
  {"12.5", 318706, 10742},
  {"12.6", 318807, 10745},
  {"12.7", 318904, 10748},
  {"12.8", 319006, 10751},
  {"12.9", 319104, 10754},
  {"12.10", 319202, 10757},
  {"12.11", 319306, 10760},
  {"12.12", 319406, 10763},
  {"12.13", 319505, 10766},
  {"12.14", 319608, 10769},
  {"12.15", 319707, 10772},
  {"12.16", 319812, 10775},
  {"12.17", 319909, 10778},
  {"12.18", 320007, 10781},
  {"12.19", 320109, 10784},
  {"12.20", 320208, 10787},
  {"12.21", 320312, 10790},
  {"12.22", 320412, 10793},
  {"12.23", 320516, 10796},
  {"12.24", 320615, 10799},
  {"12.25", 320719, 10802},
  {"12.26", 320818, 10805},
  {"12.27", 320923, 10808},
  {"12.28", 321020, 10811},
  {"12.29", 321118, 10814},
  {"12.30", 321220, 10817},
  {"12.31", 321319, 10820},
  {"12.32", 321423, 10823},
  {"12.33", 321522, 10826},
  {"12.34", 321626, 10829},
  {"12.35", 321725, 10832},
  {"12.36", 321829, 10835},
  {"12.37", 321928, 10838},
  {"12.38", 322032, 10841},
  {"12.39", 322131, 10844},
  {"12.40", 322235, 10847},
  {"12.41", 322334, 10850},
  {"12.42", 322438, 10853},
  {"12.43", 322537, 10856},
  {"12.44", 322641, 10859},
  {"12.45", 322740, 10862},
  {"12.46", 322844, 10865},
  {"12.47", 322943, 10868},
  {"12.48", 323047, 10871},
  {"12.49", 323146, 10874},
  {"12.50", 323250, 10877},
  {"12.51", 323349, 10880},
  {"12.52", 323454, 10883},
  {"12.53", 323552, 10886},
  {"12.54", 323654, 10889},
  {"12.55", 323753, 10892},
  {"12.56", 323856, 10895},
  {"12.57", 323957, 10898},
  {"12.58", 324060, 10901},
  {"12.59", 324160, 10904},
  {"12.60", 324263, 10907},
  {"12.61", 324363, 10910},
  {"12.62", 324462, 10913},
  {"12.63", 324567, 10916},
  {"12.64", 324664, 10919},
  {"12.65", 324762, 10922},
  {"S2.13.13", 324863, 10925},
  {"13.1", 325928, 10952},
  {"13.2", 326029, 10955},
  {"13.3", 326124, 10958},
  {"13.4", 326219, 10961},
  {"13.5", 326314, 10964},
  {"13.6", 326410, 10967},
  {"13.7", 326506, 10970},
  {"S2.13.14", 326605, 10973},
  {"14.1", 330154, 11058},
  {"14.2", 330255, 11061},
  {"14.3", 330351, 11064},
  {"14.4", 330447, 11067},
  {"14.5", 330547, 11070},
  {"14.6", 330649, 11073},
  {"14.7", 330746, 11076},
  {"14.8", 330843, 11079},
  {"14.9", 330941, 11082},
  {"14.10", 331044, 11085},
  {"14.11", 331143, 11088},
  {"14.12", 331247, 11091},
  {"14.13", 331347, 11094},
  {"14.14", 331451, 11097},
  {"14.15", 331550, 11100},
  {"14.16", 331649, 11103},
  {"14.17", 331754, 11106},
  {"14.18", 331852, 11109},
  {"14.19", 331950, 11112},
  {"14.20", 332047, 11115},
  {"14.21", 332144, 11118},
  {"14.22", 332241, 11121},
  {"14.23", 332338, 11124},
  {"14.24", 332435, 11127},
  {"14.25", 332537, 11130},
  {"14.26", 332641, 11133},
  {"14.27", 332741, 11136},
  {"14.28", 332845, 11139},
  {"14.29", 332943, 11142},
  {"14.30", 333040, 11145},
  {"14.31", 333138, 11148},
  {"14.32", 333236, 11151}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 171, 5, 91, "Section",
  CellTags->{"S2.13.0", "0.1"}],

Cell[CellGroupData[{
Cell[1972, 62, 126, 5, 70, "Subsection",
  CellTags->{"S2.13.1", "1.1"}],
Cell[2101, 69, 368, 11, 70, "Text",
  CellTags->{"S2.13.1", "1.2"}],
Cell[2472, 82, 1172, 33, 70, "FramedBox",
  CellTags->"S2.13.1"],
Cell[3647, 117, 117, 5, 70, "Caption",
  CellTags->"S2.13.1"],
Cell[3767, 124, 354, 8, 70, "Text",
  CellTags->{"S2.13.1", "1.3"}],
Cell[4124, 134, 315, 9, 70, "Text",
  CellTags->{"S2.13.1", "1.4"}],
Cell[4442, 145, 242, 8, 70, "Text",
  CellTags->{"S2.13.1", "1.5"}],
Cell[4687, 155, 193, 5, 70, "Text",
  CellTags->{"S2.13.1", "1.6"}],
Cell[4883, 162, 850, 28, 70, "FramedBox",
  CellTags->"S2.13.1"],
Cell[5736, 192, 138, 5, 70, "Caption",
  CellTags->"S2.13.1"],
Cell[5877, 199, 565, 14, 70, "Text",
  CellTags->{"S2.13.1", "1.7"}],
Cell[6445, 215, 462, 13, 70, "FramedBox",
  CellTags->"S2.13.1"],
Cell[6910, 230, 114, 5, 70, "Caption",
  CellTags->"S2.13.1"],
Cell[7027, 237, 420, 12, 70, "Text",
  CellTags->{"S2.13.1", "1.8"}],
Cell[7450, 251, 727, 20, 70, "FramedBox",
  CellTags->"S2.13.1"],
Cell[8180, 273, 189, 7, 70, "Caption",
  CellTags->"S2.13.1"],
Cell[8372, 282, 255, 8, 70, "Text",
  CellTags->{"S2.13.1", "1.9"}],
Cell[8630, 292, 309, 7, 70, "Text",
  CellTags->{"S2.13.1", "1.10"}],
Cell[8942, 301, 292, 7, 70, "Text",
  CellTags->{"S2.13.1", "1.11"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9271, 313, 162, 5, 70, "Subsection",
  CellTags->{"S2.13.2", "2.1"}],
Cell[9436, 320, 455, 11, 70, "Text",
  CellTags->{"S2.13.2", "2.2"}],
Cell[9894, 333, 756, 22, 70, "DefinitionBox",
  CellTags->"S2.13.2"],
Cell[10653, 357, 168, 5, 70, "Caption",
  CellTags->"S2.13.2"],
Cell[10824, 364, 204, 7, 70, "MathCaption",
  CellTags->{"S2.13.2", "2.3"}],

Cell[CellGroupData[{
Cell[11053, 375, 85, 2, 70, "Input",
  CellTags->"S2.13.2"],
Cell[11141, 379, 111, 3, 70, "Output",
  CellTags->"S2.13.2"]
}, Open  ]],
Cell[11267, 385, 170, 6, 70, "MathCaption",
  CellTags->{"S2.13.2", "2.4"}],

Cell[CellGroupData[{
Cell[11462, 395, 81, 2, 70, "Input",
  CellTags->"S2.13.2"],
Cell[11546, 399, 84, 3, 70, "Output",
  CellTags->"S2.13.2"]
}, Open  ]],
Cell[11645, 405, 163, 5, 70, "MathCaption",
  CellTags->{"S2.13.2", "2.5"}],

Cell[CellGroupData[{
Cell[11833, 414, 101, 2, 70, "Input",
  CellTags->"S2.13.2"],
Cell[11937, 418, 105, 3, 70, "Output",
  CellTags->"S2.13.2"]
}, Open  ]],
Cell[12057, 424, 317, 7, 70, "Text",
  CellTags->{"S2.13.2", "2.6"}],
Cell[12377, 433, 536, 13, 70, "Text",
  CellTags->{"S2.13.2", "2.7"}],
Cell[12916, 448, 464, 14, 70, "DefinitionBox",
  CellTags->"S2.13.2"],
Cell[13383, 464, 94, 1, 70, "Caption",
  CellTags->"S2.13.2"],
Cell[13480, 467, 974, 30, 70, "Text",
  CellTags->{"S2.13.2", "2.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[14491, 502, 159, 4, 70, "Subsection",
  CellTags->{"S2.13.3", "3.1"}],
Cell[14653, 508, 393, 9, 70, "Text",
  CellTags->{"S2.13.3", "3.2"}],
Cell[15049, 519, 253, 8, 70, "Text",
  CellTags->{"S2.13.3", "3.3"}],
Cell[15305, 529, 55, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.4"}],
Cell[15363, 532, 212, 9, 70, "Program",
  CellTags->{"S2.13.3", "3.5"}],
Cell[15578, 543, 58, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.6"}],
Cell[15639, 546, 212, 9, 70, "Caption",
  CellTags->"S2.13.3"],
Cell[15854, 557, 1622, 41, 70, "DefinitionBox",
  CellTags->"S2.13.3"],
Cell[17479, 600, 123, 5, 70, "Caption",
  CellTags->"S2.13.3"],
Cell[17605, 607, 513, 12, 70, "Text",
  CellTags->{"S2.13.3", "3.7"}],
Cell[18121, 621, 55, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.8"}],
Cell[18179, 624, 142, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.9"}],
Cell[18324, 631, 84, 4, 70, "Program",
  CellTags->{"S2.13.3", "3.10"}],
Cell[18411, 637, 150, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.11"}],
Cell[18564, 644, 326, 12, 70, "Program",
  CellTags->{"S2.13.3", "3.12"}],
Cell[18893, 658, 181, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.13"}],
Cell[19077, 665, 354, 12, 70, "Program",
  CellTags->{"S2.13.3", "3.14"}],
Cell[19434, 679, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.15"}],
Cell[19496, 682, 123, 5, 70, "Caption",
  CellTags->"S2.13.3"],
Cell[19622, 689, 335, 9, 70, "Text",
  CellTags->{"S2.13.3", "3.16"}],
Cell[19960, 700, 689, 22, 70, "DefinitionBox",
  CellTags->"S2.13.3"],
Cell[20652, 724, 150, 5, 70, "Caption",
  CellTags->"S2.13.3"],
Cell[20805, 731, 321, 8, 70, "Text",
  CellTags->{"S2.13.3", "3.17"}],
Cell[21129, 741, 353, 8, 70, "Text",
  CellTags->{"S2.13.3", "3.18"}],
Cell[21485, 751, 545, 17, 70, "Text",
  CellTags->{"S2.13.3", "3.19"}],
Cell[22033, 770, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.20"}],
Cell[22092, 773, 222, 7, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.21"}],
Cell[22317, 782, 73, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.22"}],
Cell[22393, 785, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.23"}],
Cell[22455, 788, 161, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.24"}],

Cell[CellGroupData[{
Cell[22641, 797, 83, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[22727, 801, 107, 3, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[22849, 807, 394, 18, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.25"}],

Cell[CellGroupData[{
Cell[23268, 829, 72, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[23343, 833, 84, 3, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[23442, 839, 151, 4, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.26"}],

Cell[CellGroupData[{
Cell[23618, 847, 77, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[23698, 851, 97, 3, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[23810, 857, 461, 12, 70, "Text",
  CellTags->{"S2.13.3", "3.27"}],
Cell[24274, 871, 1505, 43, 70, "DefinitionBox",
  CellTags->"S2.13.3"],
Cell[25782, 916, 79, 1, 70, "Caption",
  CellTags->"S2.13.3"],
Cell[25864, 919, 142, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.28"}],

Cell[CellGroupData[{
Cell[26031, 928, 81, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[26115, 932, 111, 3, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[26241, 938, 174, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.29"}],

Cell[CellGroupData[{
Cell[26440, 947, 85, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[26528, 951, 158, 5, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[26701, 959, 237, 8, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.30"}],

Cell[CellGroupData[{
Cell[26963, 971, 67, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[27033, 975, 66, 2, 70, "Print",
  CellTags->"S2.13.3"],
Cell[27102, 979, 536, 15, 70, "Print",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[27653, 997, 671, 20, 70, "Text",
  CellTags->{"S2.13.3", "3.31"}],
Cell[28327, 1019, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.32"}],
Cell[28386, 1022, 59, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.33"}],
Cell[28448, 1025, 143, 4, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.34"}],
Cell[28594, 1031, 76, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.35"}],
Cell[28673, 1034, 175, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.36"}],
Cell[28851, 1041, 99, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.37"}],
Cell[28953, 1044, 166, 4, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.38"}],
Cell[29122, 1050, 330, 12, 70, "Program",
  CellTags->{"S2.13.3", "3.39"}],
Cell[29455, 1064, 147, 4, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.40"}],
Cell[29605, 1070, 320, 12, 70, "Program",
  CellTags->{"S2.13.3", "3.41"}],
Cell[29928, 1084, 142, 4, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.42"}],
Cell[30073, 1090, 75, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.43"}],
Cell[30151, 1093, 57, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.44"}],
Cell[30211, 1096, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.45"}],
Cell[30273, 1099, 522, 15, 70, "Text",
  CellTags->{"S2.13.3", "3.46"}],
Cell[30798, 1116, 282, 6, 70, "Text",
  CellTags->{"S2.13.3", "3.47"}],
Cell[31083, 1124, 409, 10, 70, "Text",
  CellTags->{"S2.13.3", "3.48"}],
Cell[31495, 1136, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.49"}],
Cell[31554, 1139, 204, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.50"}],
Cell[31761, 1146, 164, 4, 70, "Program",
  CellTags->{"S2.13.3", "3.51"}],
Cell[31928, 1152, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.52"}],
Cell[31990, 1155, 456, 11, 70, "Text",
  CellTags->{"S2.13.3", "3.53"}],
Cell[32449, 1168, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.54"}],
Cell[32508, 1171, 208, 6, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.55"}],
Cell[32719, 1179, 261, 7, 70, "Program",
  CellTags->{"S2.13.3", "3.56"}],
Cell[32983, 1188, 274, 9, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.57"}],
Cell[33260, 1199, 686, 24, 70, "Program",
  CellTags->{"S2.13.3", "3.58"}],
Cell[33949, 1225, 284, 10, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.59"}],
Cell[34236, 1237, 658, 24, 70, "Program",
  CellTags->{"S2.13.3", "3.60"}],
Cell[34897, 1263, 250, 6, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.61"}],
Cell[35150, 1271, 104, 4, 70, "Program",
  CellTags->{"S2.13.3", "3.62"}],
Cell[35257, 1277, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.63"}],
Cell[35319, 1280, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.64"}],
Cell[35378, 1283, 290, 8, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.65"}],
Cell[35671, 1293, 336, 13, 70, "Program",
  CellTags->{"S2.13.3", "3.66"}],
Cell[36010, 1308, 336, 11, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.67"}],
Cell[36349, 1321, 325, 12, 70, "Program",
  CellTags->{"S2.13.3", "3.68"}],
Cell[36677, 1335, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.69"}],
Cell[36739, 1338, 549, 14, 70, "Text",
  CellTags->{"S2.13.3", "3.70"}],
Cell[37291, 1354, 600, 18, 70, "DefinitionBox",
  CellTags->"S2.13.3"],
Cell[37894, 1374, 154, 5, 70, "Caption",
  CellTags->"S2.13.3"],
Cell[38051, 1381, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.71"}],
Cell[38110, 1384, 76, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.72"}],
Cell[38189, 1387, 265, 13, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.73"}],
Cell[38457, 1402, 132, 4, 70, "Program",
  CellTags->{"S2.13.3", "3.74"}],
Cell[38592, 1408, 79, 4, 70, "Program",
  CellTags->{"S2.13.3", "3.75"}],
Cell[38674, 1414, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.76"}],
Cell[38736, 1417, 178, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.77"}],

Cell[CellGroupData[{
Cell[38939, 1426, 86, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[39028, 1430, 112, 3, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[39155, 1436, 170, 7, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.78"}],

Cell[CellGroupData[{
Cell[39350, 1447, 75, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[39428, 1451, 66, 2, 70, "Print",
  CellTags->"S2.13.3"],
Cell[39497, 1455, 88, 3, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[39600, 1461, 474, 12, 70, "Text",
  CellTags->{"S2.13.3", "3.79"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[40111, 1478, 105, 1, 70, "Subsection",
  CellTags->{"S2.13.4", "4.1"}],
Cell[40219, 1481, 391, 11, 70, "Text",
  CellTags->{"S2.13.4", "4.2"}],
Cell[40613, 1494, 2536, 82, 70, "DefinitionBox3Col",
  CellTags->"S2.13.4"],
Cell[43152, 1578, 69, 1, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[43224, 1581, 55, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.3"}],
Cell[43282, 1584, 191, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.4"}],
Cell[43476, 1591, 661, 24, 70, "Program",
  CellTags->{"S2.13.4", "4.5"}],
Cell[44140, 1617, 218, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.6"}],
Cell[44361, 1624, 402, 13, 70, "Program",
  CellTags->{"S2.13.4", "4.7"}],
Cell[44766, 1639, 58, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.8"}],
Cell[44827, 1642, 185, 6, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.9"}],

Cell[CellGroupData[{
Cell[45037, 1652, 83, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[45123, 1656, 109, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[45247, 1662, 86, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.10"}],

Cell[CellGroupData[{
Cell[45358, 1667, 77, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[45438, 1671, 84, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[45537, 1677, 178, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.11"}],

Cell[CellGroupData[{
Cell[45740, 1686, 70, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[45813, 1690, 87, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[45915, 1696, 224, 6, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.12"}],

Cell[CellGroupData[{
Cell[46164, 1706, 77, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[46244, 1710, 89, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[46348, 1716, 327, 9, 70, "Text",
  CellTags->{"S2.13.4", "4.13"}],
Cell[46678, 1727, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.14"}],
Cell[46737, 1730, 142, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.15"}],
Cell[46882, 1737, 343, 13, 70, "Program",
  CellTags->{"S2.13.4", "4.16"}],
Cell[47228, 1752, 115, 2, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.17"}],
Cell[47346, 1756, 106, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.18"}],
Cell[47455, 1759, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.19"}],
Cell[47517, 1762, 311, 8, 70, "Text",
  CellTags->{"S2.13.4", "4.20"}],
Cell[47831, 1772, 490, 15, 70, "Text",
  CellTags->{"S2.13.4", "4.21"}],
Cell[48324, 1789, 5277, 167, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[53604, 1958, 160, 6, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[53767, 1966, 649, 19, 70, "Text",
  CellTags->{"S2.13.4", "4.22"}],
Cell[54419, 1987, 869, 25, 70, "Text",
  CellTags->{"S2.13.4", "4.23"}],
Cell[55291, 2014, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.24"}],
Cell[55350, 2017, 270, 8, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.25"}],
Cell[55623, 2027, 666, 24, 70, "Program",
  CellTags->{"S2.13.4", "4.26"}],
Cell[56292, 2053, 134, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.27"}],
Cell[56429, 2060, 97, 6, 70, "Program",
  CellTags->{"S2.13.4", "4.28"}],
Cell[56529, 2068, 136, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.29"}],
Cell[56668, 2075, 407, 13, 70, "Program",
  CellTags->{"S2.13.4", "4.30"}],
Cell[57078, 2090, 214, 9, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.31"}],
Cell[57295, 2101, 111, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.32"}],
Cell[57409, 2108, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.33"}],
Cell[57471, 2111, 165, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.34"}],

Cell[CellGroupData[{
Cell[57661, 2120, 86, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[57750, 2124, 108, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[57873, 2130, 106, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.35"}],

Cell[CellGroupData[{
Cell[58004, 2135, 73, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[58080, 2139, 94, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[58189, 2145, 463, 18, 70, "Text",
  CellTags->{"S2.13.4", "4.36"}],
Cell[58655, 2165, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.37"}],
Cell[58714, 2168, 55, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.38"}],
Cell[58772, 2171, 124, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.39"}],
Cell[58899, 2177, 73, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.40"}],
Cell[58975, 2180, 199, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.41"}],
Cell[59177, 2189, 322, 13, 70, "Program",
  CellTags->{"S2.13.4", "4.42"}],
Cell[59502, 2204, 67, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.43"}],
Cell[59572, 2210, 214, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.44"}],
Cell[59789, 2219, 101, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.45"}],
Cell[59893, 2222, 55, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.46"}],
Cell[59951, 2225, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.47"}],
Cell[60013, 2228, 431, 13, 70, "Text",
  CellTags->{"S2.13.4", "4.48"}],
Cell[60447, 2243, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.49"}],
Cell[60506, 2246, 189, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.50"}],
Cell[60698, 2255, 88, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.51"}],
Cell[60789, 2258, 157, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.52"}],
Cell[60949, 2265, 78, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.53"}],
Cell[61030, 2268, 161, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.54"}],
Cell[61194, 2275, 80, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.55"}],
Cell[61277, 2278, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.56"}],
Cell[61339, 2281, 583, 16, 70, "Text",
  CellTags->{"S2.13.4", "4.57"}],
Cell[61925, 2299, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.58"}],
Cell[61984, 2302, 149, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.59"}],
Cell[62136, 2309, 88, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.60"}],
Cell[62227, 2312, 175, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.61"}],
Cell[62405, 2319, 85, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.62"}],
Cell[62493, 2322, 136, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.63"}],
Cell[62632, 2328, 88, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.64"}],
Cell[62723, 2331, 136, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.65"}],
Cell[62862, 2337, 76, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.66"}],
Cell[62941, 2340, 90, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.67"}],
Cell[63034, 2343, 78, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.68"}],
Cell[63115, 2346, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.69"}],
Cell[63177, 2349, 626, 15, 70, "Text",
  CellTags->{"S2.13.4", "4.70"}],
Cell[63806, 2366, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.71"}],
Cell[63865, 2369, 55, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.72"}],
Cell[63923, 2372, 167, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.73"}],
Cell[64093, 2379, 61, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.74"}],
Cell[64157, 2382, 55, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.75"}],
Cell[64215, 2385, 178, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.76"}],
Cell[64396, 2394, 89, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.77"}],
Cell[64488, 2397, 74, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.78"}],
Cell[64565, 2400, 141, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.79"}],
Cell[64709, 2407, 93, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.80"}],
Cell[64805, 2410, 78, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.81"}],
Cell[64886, 2413, 91, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.82"}],
Cell[64980, 2416, 99, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.83"}],
Cell[65082, 2419, 67, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.84"}],
Cell[65152, 2425, 55, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.85"}],
Cell[65210, 2428, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.86"}],
Cell[65272, 2431, 763, 20, 70, "Text",
  CellTags->{"S2.13.4", "4.87"}],
Cell[66038, 2453, 268, 6, 70, "Text",
  CellTags->{"S2.13.4", "4.88"}],
Cell[66309, 2461, 180, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.89"}],

Cell[CellGroupData[{
Cell[66514, 2470, 106, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[66623, 2474, 99, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[66737, 2480, 143, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.90"}],

Cell[CellGroupData[{
Cell[66905, 2488, 100, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[67008, 2492, 111, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[67134, 2498, 125, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.91"}],

Cell[CellGroupData[{
Cell[67284, 2506, 75, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[67362, 2510, 99, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[67476, 2516, 134, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.92"}],

Cell[CellGroupData[{
Cell[67635, 2524, 105, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[67743, 2528, 89, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[67847, 2534, 346, 9, 70, "Text",
  CellTags->{"S2.13.4", "4.93"}],
Cell[68196, 2545, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.94"}],
Cell[68255, 2548, 142, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.95"}],
Cell[68400, 2555, 88, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.96"}],
Cell[68491, 2558, 164, 6, 70, "Program",
  CellTags->{"S2.13.4", "4.97"}],
Cell[68658, 2566, 139, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.98"}],
Cell[68800, 2573, 96, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.99"}],
Cell[68899, 2576, 74, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.100"}],
Cell[68976, 2579, 128, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.101"}],
Cell[69107, 2586, 54, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.102"}],
Cell[69164, 2589, 144, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.103"}],
Cell[69311, 2596, 93, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.104"}],
Cell[69407, 2599, 60, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.105"}],
Cell[69470, 2602, 1106, 34, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[70579, 2638, 148, 5, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[70730, 2645, 472, 15, 70, "Text",
  CellTags->{"S2.13.4", "4.106"}],
Cell[71205, 2662, 389, 12, 70, "Text",
  CellTags->{"S2.13.4", "4.107"}],
Cell[71597, 2676, 57, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.108"}],
Cell[71657, 2679, 87, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.109"}],
Cell[71747, 2685, 178, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.110"}],
Cell[71928, 2694, 98, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.111"}],
Cell[72029, 2697, 131, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.112"}],
Cell[72163, 2703, 313, 12, 70, "Program",
  CellTags->{"S2.13.4", "4.113"}],
Cell[72479, 2717, 134, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.114"}],
Cell[72616, 2723, 321, 12, 70, "Program",
  CellTags->{"S2.13.4", "4.115"}],
Cell[72940, 2737, 89, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.116"}],
Cell[73032, 2744, 113, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.117"}],
Cell[73148, 2747, 79, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.118"}],
Cell[73230, 2753, 166, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.119"}],
Cell[73399, 2762, 77, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.120"}],
Cell[73479, 2768, 143, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.121"}],
Cell[73625, 2774, 115, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.122"}],
Cell[73743, 2781, 79, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.123"}],
Cell[73825, 2787, 60, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.124"}],
Cell[73888, 2790, 641, 22, 70, "Text",
  CellTags->{"S2.13.4", "4.125"}],
Cell[74532, 2814, 735, 24, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[75270, 2840, 119, 5, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[75392, 2847, 57, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.126"}],
Cell[75452, 2850, 87, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.127"}],
Cell[75542, 2856, 200, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.128"}],
Cell[75745, 2865, 327, 13, 70, "Program",
  CellTags->{"S2.13.4", "4.129"}],
Cell[76075, 2880, 109, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.130"}],
Cell[76187, 2883, 307, 12, 70, "Program",
  CellTags->{"S2.13.4", "4.131"}],
Cell[76497, 2897, 133, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.132"}],
Cell[76633, 2903, 312, 12, 70, "Program",
  CellTags->{"S2.13.4", "4.133"}],
Cell[76948, 2917, 92, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.134"}],
Cell[77043, 2924, 108, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.135"}],
Cell[77154, 2927, 75, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.136"}],
Cell[77232, 2933, 88, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.137"}],
Cell[77323, 2936, 92, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.138"}],
Cell[77418, 2943, 197, 6, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.139"}],
Cell[77618, 2951, 105, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.140"}],
Cell[77726, 2957, 156, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.141"}],
Cell[77885, 2964, 117, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.142"}],
Cell[78005, 2970, 66, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.143"}],
Cell[78074, 2976, 60, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.144"}],
Cell[78137, 2979, 429, 9, 70, "Text",
  CellTags->{"S2.13.4", "4.145"}],
Cell[78569, 2990, 253, 6, 70, "Text",
  CellTags->{"S2.13.4", "4.146"}],
Cell[78825, 2998, 2465, 80, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[81293, 3080, 68, 1, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[81364, 3083, 487, 16, 70, "Text",
  CellTags->{"S2.13.4", "4.147"}],
Cell[81854, 3101, 240, 5, 70, "Text",
  CellTags->{"S2.13.4", "4.148"}],
Cell[82097, 3108, 550, 18, 70, "Text",
  CellTags->{"S2.13.4", "4.149"}],
Cell[82650, 3128, 57, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.150"}],
Cell[82710, 3131, 133, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.151"}],
Cell[82846, 3137, 75, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.152"}],
Cell[82924, 3143, 159, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.153"}],
Cell[83086, 3150, 85, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.154"}],
Cell[83174, 3157, 168, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.155"}],
Cell[83345, 3164, 100, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.156"}],
Cell[83448, 3170, 56, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.157"}],
Cell[83507, 3173, 119, 2, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.158"}],
Cell[83629, 3177, 92, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.159"}],
Cell[83724, 3180, 66, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.160"}],
Cell[83793, 3186, 60, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.161"}],
Cell[83856, 3189, 522, 14, 70, "Text",
  CellTags->{"S2.13.4", "4.162"}],
Cell[84381, 3205, 3870, 124, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[88254, 3331, 69, 1, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[88326, 3334, 405, 10, 70, "Text",
  CellTags->{"S2.13.4", "4.163"}],
Cell[88734, 3346, 563, 21, 70, "Text",
  CellTags->{"S2.13.4", "4.164"}],
Cell[89300, 3369, 518, 16, 70, "Text",
  CellTags->{"S2.13.4", "4.165"}],
Cell[89821, 3387, 342, 10, 70, "Text",
  CellTags->{"S2.13.4", "4.166"}],
Cell[90166, 3399, 1594, 46, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[91763, 3447, 86, 1, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[91852, 3450, 461, 12, 70, "Text",
  CellTags->{"S2.13.4", "4.167"}],
Cell[92316, 3464, 501, 11, 70, "Text",
  CellTags->{"S2.13.4", "4.168"}],
Cell[92820, 3477, 1290, 38, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[94113, 3517, 73, 1, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[94189, 3520, 553, 14, 70, "Text",
  CellTags->{"S2.13.4", "4.169"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[94779, 3539, 153, 5, 70, "Subsection",
  CellTags->{"S2.13.5", "5.1"}],
Cell[94935, 3546, 323, 9, 70, "Text",
  CellTags->{"S2.13.5", "5.2"}],
Cell[95261, 3557, 415, 11, 70, "Text",
  CellTags->{"S2.13.5", "5.3"}],
Cell[95679, 3570, 1535, 46, 70, "DefinitionBox",
  CellTags->"S2.13.5"],
Cell[97217, 3618, 92, 1, 70, "Caption",
  CellTags->"S2.13.5"],
Cell[97312, 3621, 641, 19, 70, "Text",
  CellTags->{"S2.13.5", "5.4"}],
Cell[97956, 3642, 1137, 38, 70, "DefinitionBox",
  CellTags->"S2.13.5"],
Cell[99096, 3682, 97, 1, 70, "Caption",
  CellTags->"S2.13.5"],
Cell[99196, 3685, 309, 6, 70, "Text",
  CellTags->{"S2.13.5", "5.5"}],
Cell[99508, 3693, 156, 4, 70, "Text",
  CellTags->{"S2.13.5", "5.6"}],
Cell[99667, 3699, 350, 7, 70, "Text",
  CellTags->{"S2.13.5", "5.7"}],
Cell[100020, 3708, 736, 21, 70, "Text",
  CellTags->{"S2.13.5", "5.8"}],
Cell[100759, 3731, 2531, 76, 70, "DefinitionBox3Col",
  CellTags->"S2.13.5"],
Cell[103293, 3809, 126, 4, 70, "Caption",
  CellTags->"S2.13.5"],
Cell[103422, 3815, 520, 14, 70, "Text",
  CellTags->{"S2.13.5", "5.9"}],
Cell[103945, 3831, 535, 11, 70, "Text",
  CellTags->{"S2.13.5", "5.10"}],
Cell[104483, 3844, 3717, 119, 70, "DefinitionBox",
  CellTags->"S2.13.5"],
Cell[108203, 3965, 72, 1, 70, "Caption",
  CellTags->"S2.13.5"],
Cell[108278, 3968, 536, 14, 70, "Text",
  CellTags->{"S2.13.5", "5.11"}],
Cell[108817, 3984, 497, 17, 70, "Text",
  CellTags->{"S2.13.5", "5.12"}],
Cell[109317, 4003, 552, 13, 70, "Text",
  CellTags->{"S2.13.5", "5.13"}],
Cell[109872, 4018, 391, 11, 70, "FramedBox",
  CellTags->"S2.13.5"],
Cell[110266, 4031, 143, 5, 70, "Caption",
  CellTags->"S2.13.5"],
Cell[110412, 4038, 416, 14, 70, "Text",
  CellTags->{"S2.13.5", "5.14"}],
Cell[110831, 4054, 548, 14, 70, "Text",
  CellTags->{"S2.13.5", "5.15"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[111416, 4073, 193, 7, 70, "Subsection",
  CellTags->{"S2.13.6", "6.1"}],
Cell[111612, 4082, 2436, 70, 70, "DefinitionBox",
  CellTags->"S2.13.6"],
Cell[114051, 4154, 159, 6, 70, "Caption",
  CellTags->"S2.13.6"],
Cell[114213, 4162, 65, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.2"}],
Cell[114281, 4165, 98, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.3"}],

Cell[CellGroupData[{
Cell[114404, 4170, 92, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[114499, 4174, 104, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[114618, 4179, 65, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.4"}],
Cell[114686, 4182, 95, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.5"}],

Cell[CellGroupData[{
Cell[114806, 4187, 92, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[114901, 4191, 108, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[115024, 4196, 65, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.6"}],
Cell[115092, 4199, 145, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.7"}],
Cell[115240, 4206, 84, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[115327, 4210, 65, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.8"}],
Cell[115395, 4213, 156, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.9"}],

Cell[CellGroupData[{
Cell[115576, 4222, 78, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[115657, 4226, 78, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[115750, 4231, 91, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.10"}],
Cell[115844, 4234, 87, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[115934, 4238, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.11"}],
Cell[116003, 4241, 102, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.12"}],

Cell[CellGroupData[{
Cell[116130, 4246, 78, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[116211, 4250, 104, 3, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[116330, 4256, 254, 8, 70, "Text",
  CellTags->{"S2.13.6", "6.13"}],
Cell[116587, 4266, 151, 4, 70, "Text",
  CellTags->{"S2.13.6", "6.14"}],
Cell[116741, 4272, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.15"}],
Cell[116810, 4275, 212, 9, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.16"}],
Cell[117025, 4286, 99, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[117127, 4290, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.17"}],
Cell[117196, 4293, 174, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.18"}],

Cell[CellGroupData[{
Cell[117395, 4302, 84, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[117482, 4306, 76, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[117573, 4311, 87, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.19"}],

Cell[CellGroupData[{
Cell[117685, 4316, 78, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[117766, 4320, 66, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[117847, 4325, 395, 11, 70, "Text",
  CellTags->{"S2.13.6", "6.20"}],
Cell[118245, 4338, 718, 23, 70, "Text",
  CellTags->{"S2.13.6", "6.21"}],
Cell[118966, 4363, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.22"}],
Cell[119035, 4366, 199, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.23"}],

Cell[CellGroupData[{
Cell[119259, 4375, 80, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[119342, 4379, 70, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[119427, 4384, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.24"}],
Cell[119496, 4387, 95, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.25"}],
Cell[119594, 4390, 86, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[119683, 4394, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.26"}],
Cell[119752, 4397, 117, 2, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.27"}],

Cell[CellGroupData[{
Cell[119894, 4403, 80, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[119977, 4407, 69, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[120061, 4412, 148, 4, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.28"}],

Cell[CellGroupData[{
Cell[120234, 4420, 78, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[120315, 4424, 70, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[120400, 4429, 1190, 32, 70, "DefinitionBox",
  CellTags->"S2.13.6"],
Cell[121593, 4463, 117, 5, 70, "Caption",
  CellTags->"S2.13.6"],
Cell[121713, 4470, 332, 7, 70, "Text",
  CellTags->{"S2.13.6", "6.29"}],
Cell[122048, 4479, 195, 5, 70, "Text",
  CellTags->{"S2.13.6", "6.30"}],
Cell[122246, 4486, 160, 5, 70, "Text",
  CellTags->{"S2.13.6", "6.31"}],
Cell[122409, 4493, 122, 4, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.32"}],
Cell[122534, 4499, 152, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.33"}],

Cell[CellGroupData[{
Cell[122711, 4508, 84, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[122798, 4512, 108, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[122921, 4517, 122, 4, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.34"}],
Cell[123046, 4523, 147, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.35"}],

Cell[CellGroupData[{
Cell[123218, 4532, 109, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[123330, 4536, 108, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[123453, 4541, 107, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.36"}],
Cell[123563, 4544, 93, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[123659, 4548, 122, 4, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.37"}],
Cell[123784, 4554, 143, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.38"}],

Cell[CellGroupData[{
Cell[123952, 4563, 78, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[124033, 4567, 69, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[124117, 4572, 333, 8, 70, "Text",
  CellTags->{"S2.13.6", "6.39"}],
Cell[124453, 4582, 390, 10, 70, "Text",
  CellTags->{"S2.13.6", "6.40"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[124880, 4597, 146, 5, 70, "Subsection",
  CellTags->{"S2.13.7", "7.1"}],
Cell[125029, 4604, 467, 13, 70, "DefinitionBox",
  CellTags->"S2.13.7"],
Cell[125499, 4619, 135, 5, 70, "Caption",
  CellTags->"S2.13.7"],
Cell[125637, 4626, 178, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.2"}],

Cell[CellGroupData[{
Cell[125840, 4635, 101, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[125944, 4639, 97, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[126056, 4644, 195, 6, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.3"}],

Cell[CellGroupData[{
Cell[126276, 4654, 79, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[126358, 4658, 90, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[126463, 4663, 186, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.4"}],
Cell[126652, 4670, 106, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[126761, 4674, 188, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.5"}],

Cell[CellGroupData[{
Cell[126974, 4683, 79, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[127056, 4687, 91, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[127162, 4692, 107, 1, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.6"}],

Cell[CellGroupData[{
Cell[127294, 4697, 79, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[127376, 4701, 90, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[127481, 4706, 410, 12, 70, "Text",
  CellTags->{"S2.13.7", "7.7"}],
Cell[127894, 4720, 1205, 30, 70, "DefinitionBox",
  CellTags->"S2.13.7"],
Cell[129102, 4752, 130, 5, 70, "Caption",
  CellTags->"S2.13.7"],
Cell[129235, 4759, 275, 9, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.8"}],

Cell[CellGroupData[{
Cell[129535, 4772, 79, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[129617, 4776, 90, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[129722, 4781, 140, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.9"}],
Cell[129865, 4788, 122, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[129990, 4792, 139, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.10"}],

Cell[CellGroupData[{
Cell[130154, 4801, 79, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[130236, 4805, 87, 5, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[130338, 4813, 144, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.11"}],

Cell[CellGroupData[{
Cell[130507, 4822, 79, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[130589, 4826, 87, 5, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[130691, 4834, 170, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.12"}],

Cell[CellGroupData[{
Cell[130886, 4843, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[130969, 4847, 91, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[131075, 4852, 1316, 38, 70, "DefinitionBox",
  CellTags->"S2.13.7"],
Cell[132394, 4892, 145, 5, 70, "Caption",
  CellTags->"S2.13.7"],
Cell[132542, 4899, 811, 26, 70, "Text",
  CellTags->{"S2.13.7", "7.13"}],
Cell[133356, 4927, 745, 20, 70, "DefinitionBox",
  CellTags->"S2.13.7"],
Cell[134104, 4949, 119, 4, 70, "Caption",
  CellTags->"S2.13.7"],
Cell[134226, 4955, 189, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.14"}],
Cell[134418, 4962, 145, 5, 70, "Input",
  CellTags->"S2.13.7"],
Cell[134566, 4969, 184, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.15"}],

Cell[CellGroupData[{
Cell[134775, 4978, 92, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[134870, 4982, 264, 6, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[135149, 4991, 564, 18, 70, "Text",
  CellTags->{"S2.13.7", "7.16"}],
Cell[135716, 5011, 698, 23, 70, "Text",
  CellTags->{"S2.13.7", "7.17"}],
Cell[136417, 5036, 682, 18, 70, "DefinitionBox",
  CellTags->"S2.13.7"],
Cell[137102, 5056, 116, 4, 70, "Caption",
  CellTags->"S2.13.7"],
Cell[137221, 5062, 221, 7, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.18"}],
Cell[137445, 5071, 115, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[137563, 5075, 135, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.19"}],

Cell[CellGroupData[{
Cell[137723, 5084, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[137806, 5088, 104, 3, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[137925, 5094, 192, 7, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.20"}],
Cell[138120, 5103, 120, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[138243, 5107, 216, 7, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.21"}],

Cell[CellGroupData[{
Cell[138484, 5118, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[138567, 5122, 88, 5, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[138670, 5130, 156, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.22"}],

Cell[CellGroupData[{
Cell[138851, 5139, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[138934, 5143, 84, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[139033, 5148, 597, 16, 70, "Text",
  CellTags->{"S2.13.7", "7.23"}],
Cell[139633, 5166, 165, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.24"}],
Cell[139801, 5173, 143, 5, 70, "Input",
  CellTags->"S2.13.7"],
Cell[139947, 5180, 182, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.25"}],

Cell[CellGroupData[{
Cell[140154, 5189, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[140237, 5193, 85, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[140337, 5198, 118, 2, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.26"}],

Cell[CellGroupData[{
Cell[140480, 5204, 82, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[140565, 5208, 71, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[140651, 5213, 80, 1, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.27"}],
Cell[140734, 5216, 109, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[140846, 5220, 202, 7, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.28"}],

Cell[CellGroupData[{
Cell[141073, 5231, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[141156, 5235, 89, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[141260, 5240, 550, 16, 70, "DefinitionBox",
  CellTags->"S2.13.7"],
Cell[141813, 5258, 138, 5, 70, "Caption",
  CellTags->"S2.13.7"],
Cell[141954, 5265, 146, 4, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.29"}],
Cell[142103, 5271, 126, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[142232, 5275, 91, 1, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.30"}],

Cell[CellGroupData[{
Cell[142348, 5280, 82, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[142433, 5284, 71, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[142519, 5289, 81, 1, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.31"}],
Cell[142603, 5292, 85, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[142691, 5296, 145, 4, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.32"}],

Cell[CellGroupData[{
Cell[142861, 5304, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[142944, 5308, 92, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[143085, 5316, 162, 5, 70, "Subsection",
  CellTags->{"S2.13.8", "8.1"}],
Cell[143250, 5323, 437, 14, 70, "Text",
  CellTags->{"S2.13.8", "8.2"}],
Cell[143690, 5339, 474, 14, 70, "DefinitionBox",
  CellTags->"S2.13.8"],
Cell[144167, 5355, 93, 1, 70, "Caption",
  CellTags->"S2.13.8"],
Cell[144263, 5358, 242, 7, 70, "Text",
  CellTags->{"S2.13.8", "8.3"}],
Cell[144508, 5367, 283, 8, 70, "Text",
  CellTags->{"S2.13.8", "8.4"}],
Cell[144794, 5377, 65, 1, 70, "SessionLabel",
  CellTags->{"S2.13.8", "8.5"}],
Cell[144862, 5380, 89, 1, 70, "MathCaption",
  CellTags->{"S2.13.8", "8.6"}],

Cell[CellGroupData[{
Cell[144976, 5385, 92, 2, 70, "Input",
  CellTags->"S2.13.8"],
Cell[145071, 5389, 104, 2, 70, "Output",
  CellTags->"S2.13.8"]
}, Open  ]],
Cell[145190, 5394, 65, 1, 70, "SessionLabel",
  CellTags->{"S2.13.8", "8.7"}],
Cell[145258, 5397, 102, 1, 70, "MathCaption",
  CellTags->{"S2.13.8", "8.8"}],

Cell[CellGroupData[{
Cell[145385, 5402, 86, 2, 70, "Input",
  CellTags->"S2.13.8"],
Cell[145474, 5406, 104, 2, 70, "Output",
  CellTags->"S2.13.8"]
}, Open  ]],
Cell[145593, 5411, 131, 4, 70, "MathCaption",
  CellTags->{"S2.13.8", "8.9"}],
Cell[145727, 5417, 80, 2, 70, "Input",
  CellTags->"S2.13.8"],
Cell[145810, 5421, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.8", "8.10"}],
Cell[145879, 5424, 142, 4, 70, "MathCaption",
  CellTags->{"S2.13.8", "8.11"}],

Cell[CellGroupData[{
Cell[146046, 5432, 91, 2, 70, "Input",
  CellTags->"S2.13.8"],
Cell[146140, 5436, 236, 7, 70, "Output",
  CellTags->"S2.13.8"]
}, Open  ]],
Cell[146391, 5446, 87, 1, 70, "MathCaption",
  CellTags->{"S2.13.8", "8.12"}],
Cell[146481, 5449, 116, 2, 70, "Input",
  CellTags->"S2.13.8"],
Cell[146600, 5453, 286, 9, 70, "Text",
  CellTags->{"S2.13.8", "8.13"}],
Cell[146889, 5464, 424, 12, 70, "Text",
  CellTags->{"S2.13.8", "8.14"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[147350, 5481, 123, 4, 70, "Subsection",
  CellTags->{"S2.13.9", "9.1"}],
Cell[147476, 5487, 534, 14, 70, "Text",
  CellTags->{"S2.13.9", "9.2"}],
Cell[148013, 5503, 200, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.3"}],

Cell[CellGroupData[{
Cell[148238, 5512, 93, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[148334, 5516, 108, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[148457, 5522, 197, 7, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.4"}],

Cell[CellGroupData[{
Cell[148679, 5533, 70, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[148752, 5537, 69, 2, 70, "Print",
  CellTags->"S2.13.9"],
Cell[148824, 5541, 532, 15, 70, "Print",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[149371, 5559, 306, 9, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.5"}],
Cell[149680, 5570, 101, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[149784, 5574, 165, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.6"}],

Cell[CellGroupData[{
Cell[149974, 5583, 79, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[150056, 5587, 103, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[150174, 5593, 548, 14, 70, "Text",
  CellTags->{"S2.13.9", "9.7"}],
Cell[150725, 5609, 484, 14, 70, "DefinitionBox",
  CellTags->"S2.13.9"],
Cell[151212, 5625, 114, 4, 70, "Caption",
  CellTags->"S2.13.9"],
Cell[151329, 5631, 55, 1, 70, "ProgramTop",
  CellTags->{"S2.13.9", "9.8"}],
Cell[151387, 5634, 88, 4, 70, "Program",
  CellTags->{"S2.13.9", "9.9"}],
Cell[151478, 5640, 176, 7, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.10"}],
Cell[151657, 5649, 98, 1, 70, "Program",
  CellTags->{"S2.13.9", "9.11"}],
Cell[151758, 5652, 596, 23, 70, "Program",
  CellTags->{"S2.13.9", "9.12"}],
Cell[152357, 5677, 173, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.13"}],
Cell[152533, 5684, 77, 4, 70, "Program",
  CellTags->{"S2.13.9", "9.14"}],
Cell[152613, 5690, 347, 12, 70, "Program",
  CellTags->{"S2.13.9", "9.15"}],
Cell[152963, 5704, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.9", "9.16"}],
Cell[153025, 5707, 169, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.17"}],

Cell[CellGroupData[{
Cell[153219, 5716, 94, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[153316, 5720, 110, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[153441, 5726, 88, 1, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.18"}],

Cell[CellGroupData[{
Cell[153554, 5731, 94, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[153651, 5735, 110, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[153776, 5741, 141, 4, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.19"}],

Cell[CellGroupData[{
Cell[153942, 5749, 80, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[154025, 5753, 85, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[154125, 5759, 142, 4, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.20"}],

Cell[CellGroupData[{
Cell[154292, 5767, 80, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[154375, 5771, 85, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[154475, 5777, 116, 2, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.21"}],

Cell[CellGroupData[{
Cell[154616, 5783, 80, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[154699, 5787, 85, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[154799, 5793, 314, 6, 70, "Text",
  CellTags->{"S2.13.9", "9.22"}],
Cell[155116, 5801, 264, 6, 70, "Text",
  CellTags->{"S2.13.9", "9.23"}],
Cell[155383, 5809, 609, 18, 70, "DefinitionBox",
  CellTags->"S2.13.9"],
Cell[155995, 5829, 134, 5, 70, "Caption",
  CellTags->"S2.13.9"],
Cell[156132, 5836, 333, 10, 70, "Text",
  CellTags->{"S2.13.9", "9.24"}],
Cell[156468, 5848, 462, 13, 70, "Text",
  CellTags->{"S2.13.9", "9.25"}],
Cell[156933, 5863, 295, 9, 70, "Text",
  CellTags->{"S2.13.9", "9.26"}],
Cell[157231, 5874, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.9", "9.27"}],
Cell[157290, 5877, 55, 1, 70, "Program",
  CellTags->{"S2.13.9", "9.28"}],
Cell[157348, 5880, 131, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.29"}],
Cell[157482, 5887, 98, 1, 70, "Program",
  CellTags->{"S2.13.9", "9.30"}],
Cell[157583, 5890, 178, 7, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.31"}],
Cell[157764, 5899, 133, 4, 70, "Program",
  CellTags->{"S2.13.9", "9.32"}],
Cell[157900, 5905, 131, 4, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.33"}],
Cell[158034, 5911, 82, 4, 70, "Program",
  CellTags->{"S2.13.9", "9.34"}],
Cell[158119, 5917, 146, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.35"}],
Cell[158268, 5924, 99, 1, 70, "Program",
  CellTags->{"S2.13.9", "9.36"}],
Cell[158370, 5927, 157, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.37"}],
Cell[158530, 5934, 80, 1, 70, "Program",
  CellTags->{"S2.13.9", "9.38"}],
Cell[158613, 5937, 55, 1, 70, "Program",
  CellTags->{"S2.13.9", "9.39"}],
Cell[158671, 5940, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.9", "9.40"}],
Cell[158733, 5943, 494, 14, 70, "DefinitionBox",
  CellTags->"S2.13.9"],
Cell[159230, 5959, 119, 5, 70, "Caption",
  CellTags->"S2.13.9"],
Cell[159352, 5966, 638, 19, 70, "Text",
  CellTags->{"S2.13.9", "9.41"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[160027, 5990, 117, 2, 70, "Subsection",
  CellTags->{"S2.13.10", "10.1"}],
Cell[160147, 5994, 455, 10, 70, "Text",
  CellTags->{"S2.13.10", "10.2"}],
Cell[160605, 6006, 132, 4, 70, "SessionLabel",
  CellTags->{"S2.13.10", "10.3"}],
Cell[160740, 6012, 165, 5, 70, "MathCaption",
  CellTags->{"S2.13.10", "10.4"}],
Cell[160908, 6019, 109, 4, 70, "Program",
  CellTags->{"S2.13.10", "10.5"}],
Cell[161020, 6025, 139, 4, 70, "MathCaption",
  CellTags->{"S2.13.10", "10.6"}],
Cell[161162, 6031, 192, 9, 70, "Program",
  CellTags->{"S2.13.10", "10.7"}],
Cell[161357, 6042, 157, 5, 70, "SessionLabel",
  CellTags->{"S2.13.10", "10.8"}],
Cell[161517, 6049, 106, 1, 70, "MathCaption",
  CellTags->{"S2.13.10", "10.9"}],

Cell[CellGroupData[{
Cell[161648, 6054, 112, 2, 70, "Input",
  CellTags->"S2.13.10"],
Cell[161763, 6058, 102, 2, 70, "Output",
  CellTags->"S2.13.10"]
}, Open  ]],
Cell[161880, 6063, 170, 5, 70, "MathCaption",
  CellTags->{"S2.13.10", "10.10"}],

Cell[CellGroupData[{
Cell[162075, 6072, 70, 2, 70, "Input",
  CellTags->"S2.13.10"],
Cell[162148, 6076, 72, 2, 70, "Output",
  CellTags->"S2.13.10"]
}, Open  ]],
Cell[162235, 6081, 560, 12, 70, "Text",
  CellTags->{"S2.13.10", "10.11"}],
Cell[162798, 6095, 879, 27, 70, "DefinitionBox",
  CellTags->"S2.13.10"],
Cell[163680, 6124, 93, 1, 70, "Caption",
  CellTags->"S2.13.10"]
}, Open  ]],

Cell[CellGroupData[{
Cell[163810, 6130, 131, 4, 70, "Subsection",
  CellTags->{"S2.13.11", "11.1"}],
Cell[163944, 6136, 201, 5, 70, "Text",
  CellTags->{"S2.13.11", "11.2"}],
Cell[164148, 6143, 281, 7, 70, "Text",
  CellTags->{"S2.13.11", "11.3"}],
Cell[164432, 6152, 706, 22, 70, "DefinitionBox",
  CellTags->"S2.13.11"],
Cell[165141, 6176, 89, 1, 70, "Caption",
  CellTags->"S2.13.11"],
Cell[165233, 6179, 261, 6, 70, "Text",
  CellTags->{"S2.13.11", "11.4"}],
Cell[165497, 6187, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.11", "11.5"}],
Cell[165566, 6190, 139, 5, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.6"}],
Cell[165708, 6197, 238, 12, 70, "Program",
  CellTags->{"S2.13.11", "11.7"}],
Cell[165949, 6211, 84, 1, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.8"}],
Cell[166036, 6214, 107, 4, 70, "Program",
  CellTags->{"S2.13.11", "11.9"}],
Cell[166146, 6220, 113, 1, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.10"}],
Cell[166262, 6223, 193, 9, 70, "Program",
  CellTags->{"S2.13.11", "11.11"}],
Cell[166458, 6234, 116, 4, 70, "SessionLabel",
  CellTags->{"S2.13.11", "11.12"}],
Cell[166577, 6240, 117, 2, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.13"}],

Cell[CellGroupData[{
Cell[166719, 6246, 112, 2, 70, "Input",
  CellTags->"S2.13.11"],
Cell[166834, 6250, 102, 2, 70, "Output",
  CellTags->"S2.13.11"]
}, Open  ]],
Cell[166951, 6255, 135, 4, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.14"}],
Cell[167089, 6261, 70, 2, 70, "Input",
  CellTags->"S2.13.11"],
Cell[167162, 6265, 67, 1, 70, "SessionLabel",
  CellTags->{"S2.13.11", "11.15"}],
Cell[167232, 6268, 104, 1, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.16"}],
Cell[167339, 6271, 116, 5, 70, "Program",
  CellTags->{"S2.13.11", "11.17"}],
Cell[167458, 6278, 94, 1, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.18"}],
Cell[167555, 6281, 101, 4, 70, "Program",
  CellTags->{"S2.13.11", "11.19"}],
Cell[167659, 6287, 116, 4, 70, "SessionLabel",
  CellTags->{"S2.13.11", "11.20"}],
Cell[167778, 6293, 117, 5, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.21"}],
Cell[167898, 6300, 72, 2, 70, "Output",
  CellTags->"S2.13.11"]
}, Open  ]],

Cell[CellGroupData[{
Cell[168007, 6307, 109, 1, 70, "Subsection",
  CellTags->{"S2.13.12", "12.1"}],
Cell[168119, 6310, 705, 15, 70, "Text",
  CellTags->{"S2.13.12", "12.2"}],
Cell[168827, 6327, 1511, 47, 70, "DefinitionBox",
  CellTags->"S2.13.12"],
Cell[170341, 6376, 86, 1, 70, "Caption",
  CellTags->"S2.13.12"],
Cell[170430, 6379, 57, 1, 70, "ProgramTop",
  CellTags->{"S2.13.12", "12.3"}],
Cell[170490, 6382, 56, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.4"}],
Cell[170549, 6385, 85, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.5"}],
Cell[170637, 6388, 89, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.6"}],
Cell[170729, 6391, 190, 7, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.7"}],
Cell[170922, 6400, 142, 5, 70, "Program",
  CellTags->{"S2.13.12", "12.8"}],
Cell[171067, 6407, 56, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.9"}],
Cell[171126, 6410, 112, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.10"}],
Cell[171241, 6413, 142, 5, 70, "Program",
  CellTags->{"S2.13.12", "12.11"}],
Cell[171386, 6420, 57, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.12"}],
Cell[171446, 6423, 95, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.13"}],
Cell[171544, 6426, 66, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.14"}],
Cell[171613, 6429, 61, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.12", "12.15"}],
Cell[171677, 6432, 310, 9, 70, "Text",
  CellTags->{"S2.13.12", "12.16"}],
Cell[171990, 6443, 313, 10, 70, "Text",
  CellTags->{"S2.13.12", "12.17"}],
Cell[172306, 6455, 58, 1, 70, "ProgramTop",
  CellTags->{"S2.13.12", "12.18"}],
Cell[172367, 6458, 57, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.19"}],
Cell[172427, 6461, 144, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.20"}],
Cell[172574, 6468, 122, 4, 70, "Program",
  CellTags->{"S2.13.12", "12.21"}],
Cell[172699, 6474, 180, 7, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.22"}],
Cell[172882, 6483, 99, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.23"}],
Cell[172984, 6486, 187, 7, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.24"}],
Cell[173174, 6495, 88, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.25"}],
Cell[173265, 6498, 61, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.12", "12.26"}],
Cell[173329, 6501, 208, 5, 70, "Text",
  CellTags->{"S2.13.12", "12.27"}],
Cell[173540, 6508, 406, 10, 70, "Text",
  CellTags->{"S2.13.12", "12.28"}],
Cell[173949, 6520, 1651, 52, 70, "DefinitionBox",
  CellTags->"S2.13.12"],
Cell[175603, 6574, 123, 5, 70, "Caption",
  CellTags->"S2.13.12"],
Cell[175729, 6581, 58, 1, 70, "ProgramTop",
  CellTags->{"S2.13.12", "12.29"}],
Cell[175790, 6584, 57, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.30"}],
Cell[175850, 6587, 149, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.31"}],
Cell[176002, 6594, 75, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.32"}],
Cell[176080, 6597, 130, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.33"}],
Cell[176213, 6604, 75, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.34"}],
Cell[176291, 6607, 120, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.35"}],
Cell[176414, 6614, 84, 4, 70, "Program",
  CellTags->{"S2.13.12", "12.36"}],
Cell[176501, 6620, 195, 7, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.37"}],
Cell[176699, 6629, 75, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.38"}],
Cell[176777, 6632, 117, 2, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.39"}],
Cell[176897, 6636, 78, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.40"}],
Cell[176978, 6639, 125, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.41"}],
Cell[177106, 6646, 75, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.42"}],
Cell[177184, 6649, 125, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.43"}],
Cell[177312, 6656, 75, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.44"}],
Cell[177390, 6659, 102, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.45"}],
Cell[177495, 6662, 78, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.46"}],
Cell[177576, 6665, 131, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.47"}],
Cell[177710, 6672, 75, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.48"}],
Cell[177788, 6675, 179, 4, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.49"}],
Cell[177970, 6681, 78, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.50"}],
Cell[178051, 6684, 61, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.12", "12.51"}],
Cell[178115, 6687, 480, 10, 70, "Text",
  CellTags->{"S2.13.12", "12.52"}],
Cell[178598, 6699, 3097, 97, 70, "DefinitionBox",
  CellTags->"S2.13.12"],
Cell[181698, 6798, 100, 1, 70, "Caption",
  CellTags->"S2.13.12"],
Cell[181801, 6801, 1005, 33, 70, "DefinitionBox",
  CellTags->"S2.13.12"],
Cell[182809, 6836, 122, 5, 70, "Caption",
  CellTags->"S2.13.12"],
Cell[182934, 6843, 58, 1, 70, "ProgramTop",
  CellTags->{"S2.13.12", "12.53"}],
Cell[182995, 6846, 77, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.54"}],
Cell[183075, 6849, 91, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.55"}],
Cell[183169, 6852, 511, 17, 70, "Program",
  CellTags->{"S2.13.12", "12.56"}],
Cell[183683, 6871, 86, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.57"}],
Cell[183772, 6874, 124, 5, 70, "Program",
  CellTags->{"S2.13.12", "12.58"}],
Cell[183899, 6881, 88, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.59"}],
Cell[183990, 6884, 122, 5, 70, "Program",
  CellTags->{"S2.13.12", "12.60"}],
Cell[184115, 6891, 55, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.61"}],
Cell[184173, 6894, 61, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.12", "12.62"}],
Cell[184237, 6897, 359, 9, 70, "Text",
  CellTags->{"S2.13.12", "12.63"}],
Cell[184599, 6908, 393, 10, 70, "Text",
  CellTags->{"S2.13.12", "12.64"}],
Cell[184995, 6920, 3080, 97, 70, "DefinitionBox",
  CellTags->"S2.13.12"],
Cell[188078, 7019, 100, 1, 70, "Caption",
  CellTags->"S2.13.12"],
Cell[188181, 7022, 314, 10, 70, "Text",
  CellTags->{"S2.13.12", "12.65"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[188532, 7037, 108, 1, 70, "Subsection",
  CellTags->{"S2.13.13", "13.1"}],
Cell[188643, 7040, 375, 9, 70, "Text",
  CellTags->{"S2.13.13", "13.2"}],
Cell[189021, 7051, 1433, 42, 70, "DefinitionBox",
  CellTags->"S2.13.13"],
Cell[190457, 7095, 125, 5, 70, "Caption",
  CellTags->"S2.13.13"],
Cell[190585, 7102, 320, 9, 70, "Text",
  CellTags->{"S2.13.13", "13.3"}],
Cell[190908, 7113, 516, 15, 70, "DefinitionBox",
  CellTags->"S2.13.13"],
Cell[191427, 7130, 81, 1, 70, "Caption",
  CellTags->"S2.13.13"],
Cell[191511, 7133, 260, 7, 70, "Text",
  CellTags->{"S2.13.13", "13.4"}],
Cell[191774, 7142, 695, 14, 70, "Text",
  CellTags->{"S2.13.13", "13.5"}],
Cell[192472, 7158, 550, 16, 70, "DefinitionBox",
  CellTags->"S2.13.13"],
Cell[193025, 7176, 73, 1, 70, "Caption",
  CellTags->"S2.13.13"],
Cell[193101, 7179, 452, 11, 70, "Text",
  CellTags->{"S2.13.13", "13.6"}],
Cell[193556, 7192, 387, 9, 70, "Text",
  CellTags->{"S2.13.13", "13.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[193980, 7206, 160, 5, 70, "Subsection",
  CellTags->{"S2.13.14", "14.1"}],
Cell[194143, 7213, 363, 12, 70, "Text",
  CellTags->{"S2.13.14", "14.2"}],
Cell[194509, 7227, 639, 19, 70, "Text",
  CellTags->{"S2.13.14", "14.3"}],
Cell[195151, 7248, 3655, 115, 70, "DefinitionBox",
  CellTags->"S2.13.14"],
Cell[198809, 7365, 129, 5, 70, "Caption",
  CellTags->"S2.13.14"],
Cell[198941, 7372, 57, 1, 70, "ProgramTop",
  CellTags->{"S2.13.14", "14.4"}],
Cell[199001, 7375, 144, 5, 70, "MathCaption",
  CellTags->{"S2.13.14", "14.5"}],
Cell[199148, 7382, 85, 4, 70, "Program",
  CellTags->{"S2.13.14", "14.6"}],
Cell[199236, 7388, 87, 1, 70, "Program",
  CellTags->{"S2.13.14", "14.7"}],
Cell[199326, 7391, 105, 6, 70, "Program",
  CellTags->{"S2.13.14", "14.8"}],
Cell[199434, 7399, 146, 5, 70, "MathCaption",
  CellTags->{"S2.13.14", "14.9"}],
Cell[199583, 7406, 79, 1, 70, "Program",
  CellTags->{"S2.13.14", "14.10"}],
Cell[199665, 7409, 199, 6, 70, "MathCaption",
  CellTags->{"S2.13.14", "14.11"}],
Cell[199867, 7417, 105, 1, 70, "Program",
  CellTags->{"S2.13.14", "14.12"}],
Cell[199975, 7420, 140, 4, 70, "MathCaption",
  CellTags->{"S2.13.14", "14.13"}],
Cell[200118, 7426, 74, 1, 70, "Program",
  CellTags->{"S2.13.14", "14.14"}],
Cell[200195, 7429, 70, 4, 70, "Program",
  CellTags->{"S2.13.14", "14.15"}],
Cell[200268, 7435, 61, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.14", "14.16"}],
Cell[200332, 7438, 586, 19, 70, "Text",
  CellTags->{"S2.13.14", "14.17"}],
Cell[200921, 7459, 375, 14, 70, "Text",
  CellTags->{"S2.13.14", "14.18"}],
Cell[201299, 7475, 1893, 58, 70, "DefinitionBox",
  CellTags->"S2.13.14"],
Cell[203195, 7535, 174, 7, 70, "Caption",
  CellTags->"S2.13.14"],
Cell[203372, 7544, 278, 8, 70, "Text",
  CellTags->{"S2.13.14", "14.19"}],
Cell[203653, 7554, 305, 9, 70, "Text",
  CellTags->{"S2.13.14", "14.20"}],
Cell[203961, 7565, 1123, 33, 70, "DefinitionBox",
  CellTags->"S2.13.14"],
Cell[205087, 7600, 154, 5, 70, "Caption",
  CellTags->"S2.13.14"],
Cell[205244, 7607, 312, 9, 70, "Text",
  CellTags->{"S2.13.14", "14.21"}],
Cell[205559, 7618, 284, 7, 56, "Text",
  CellTags->{"S2.13.14", "14.22"}],
Cell[205846, 7627, 249, 6, 70, "Text",
  CellTags->{"S2.13.14", "14.23"}],
Cell[206098, 7635, 4256, 123, 420, "DefinitionBox3Col",
  CellTags->"S2.13.14"],
Cell[210357, 7760, 130, 5, 16, "Caption",
  CellTags->"S2.13.14"],
Cell[210490, 7767, 58, 1, 20, "ProgramTop",
  CellTags->{"S2.13.14", "14.24"}],
Cell[210551, 7770, 201, 6, 56, "MathCaption",
  CellTags->{"S2.13.14", "14.25"}],
Cell[210755, 7778, 135, 4, 44, "Program",
  CellTags->{"S2.13.14", "14.26"}],
Cell[210893, 7784, 61, 1, 8, "ProgramBottom",
  CellTags->{"S2.13.14", "14.27"}],
Cell[210957, 7787, 407, 11, 56, "Text",
  CellTags->{"S2.13.14", "14.28"}],
Cell[211367, 7800, 196, 6, 40, "Text",
  CellTags->{"S2.13.14", "14.29"}],
Cell[211566, 7808, 896, 29, 102, "DefinitionBox",
  CellTags->"S2.13.14"],
Cell[212465, 7839, 66, 1, 16, "Caption",
  CellTags->"S2.13.14"],
Cell[212534, 7842, 505, 12, 88, "Text",
  CellTags->{"S2.13.14", "14.30"}],
Cell[213042, 7856, 466, 17, 56, "Text",
  CellTags->{"S2.13.14", "14.31"}],
Cell[213511, 7875, 397, 10, 56, "Text",
  CellTags->{"S2.13.14", "14.32"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

