(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     87979,       2971]*)
(*NotebookOutlinePosition[    121635,       3956]*)
(*  CellTagsIndexPosition[    118567,       3832]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.14 ", "HeadingNumber"],
  "Global Aspects of ",
  StyleBox["Mathematica", "SBO"],
  " Sessions"
}], "Section",
  CellTags->{"S2.14.0", "0.1"}],

Cell[CellGroupData[{

Cell["2.14.1 The Main Loop", "Subsection",
  CellTags->{"S2.14.1", "1.1"}],

Cell[TextData[{
  "In any interactive session, ",
  StyleBox["Mathematica", "TI"],
  " effectively operates in a loop. It waits for your input, processes the \
input, prints the result, then goes back to waiting for input again. As part \
of this \[OpenCurlyDoubleQuote]main loop\[CloseCurlyDoubleQuote], ",
  StyleBox["Mathematica", "TI"],
  " maintains and uses various global objects. You will often find it useful \
to work with these objects. "
}], "Text",
  CellTags->{"S2.14.1", "1.2"}],

Cell[TextData[{
  "You should realize, however, that if you use ",
  StyleBox["Mathematica", "TI"],
  " through a special front end, your front end may set up its own main loop, \
and what is said in this section may not apply. "
}], "Text",
  CellTags->{"S2.14.1", "1.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["In[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the expression on the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " input line "
            }]]},
          {Cell[TextData[{
              StyleBox["InString[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the textual form of the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " input line "
            }]]},
          {Cell[TextData[{
              StyleBox["%", "MR"],
              StyleBox["n", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Out[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the expression on the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " output line "
            }]]},
          {Cell[TextData[{
              StyleBox["Out[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["a list of output expressions "]},
          {Cell[TextData[{
              StyleBox["%%", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["%", "MR"],
              " (",
              StyleBox["n", "TI"],
              " times) \[ThinSpace]or \[ThinSpace]",
              StyleBox["Out[-", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the expression on the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " previous output line "
            }]]},
          {Cell[TextData[{
              StyleBox["MessageList[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a list of messages produced while processing the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " line "
            }]]},
          {Cell[TextData[{
              StyleBox["$Line", "MR"],
              " "
            }]], Cell["the current line number (resettable) "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.1"],

Cell["Input and output expressions. ", "Caption",
  CellTags->"S2.14.1"],

Cell[TextData[{
  "In a standard interactive session, there is a sequence of input and output \
lines. ",
  StyleBox["Mathematica", "TI"],
  " stores the values of the expressions on these lines in ",
  StyleBox["In[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["Out[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.14.1", "1.4"}],

Cell[TextData[{
  "As indicated by the usual ",
  StyleBox["In[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]:=", "MR"],
  " prompt, the input expressions are stored with delayed assignments. This \
means that whenever you ask for ",
  StyleBox["In[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ", the input expression will always be re\[Hyphen]evaluated in your current \
environment. "
}], "Text",
  CellTags->{"S2.14.1", "1.5"}],

Cell[TextData[{
  "This assigns a value to ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.14.1", "1.6"}],

Cell[CellGroupData[{

Cell["x = 7", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.14.1"],

Cell[BoxData[
    \(7\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.14.1"]
}, Open  ]],

Cell[TextData[{
  "Now the value for ",
  StyleBox["x", "MR"],
  " is used. "
}], "MathCaption",
  CellTags->{"S2.14.1", "1.7"}],

Cell[CellGroupData[{

Cell["x - x^2 + 5x - 1", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.14.1"],

Cell[BoxData[
    \(\(-8\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.14.1"]
}, Open  ]],

Cell[TextData[{
  "This removes the value assigned to ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.14.1", "1.8"}],

Cell["x =.", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.14.1"],

Cell[TextData[{
  "This is re\[Hyphen]evaluated in your current environment, where there is \
no value assigned to ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.14.1", "1.9"}],

Cell[CellGroupData[{

Cell["In[2]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.14.1"],

Cell[BoxData[
    \(\(-1\) + 6\ x - x\^2\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.14.1"]
}, Open  ]],

Cell["\<\
This gives the textual form of the second input line, appropriate \
for editing or other textual manipulation. \
\>", "MathCaption",
  CellTags->{"S2.14.1", "1.10"}],

Cell[CellGroupData[{

Cell["InString[2] // InputForm", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.14.1"],

Cell["\"x - x^2 + 5x - 1\"", "Output",
  CellLabel->"Out[5]//InputForm= ",
  CellTags->"S2.14.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$HistoryLength", "MR"],
              " "
            }]], Cell[
            "the number of previous lines of input and output to keep "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.1"],

Cell["Specifying the length of session history to keep. ", "Caption",
  CellTags->"S2.14.1"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " by default stores ",
  StyleBox["all", "TI"],
  " your input and output lines for the duration of the session. In a very \
long session, this may take up a large amount of computer memory. You can \
nevertheless get rid of the input and output lines by explicitly clearing the \
values of ",
  StyleBox["In", "MR"],
  " and ",
  StyleBox["Out", "MR"],
  ", using ",
  StyleBox["Unprotect[In,", "MR"],
  " ",
  StyleBox["Out]", "MR"],
  ", followed by ",
  StyleBox["Clear[In,", "MR"],
  " ",
  StyleBox["Out]", "MR"],
  ". You can also tell ",
  StyleBox["Mathematica", "TI"],
  " to keep only a limited number of lines of history by setting the global \
variable ",
  StyleBox["$HistoryLength", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.14.1", "1.11"}],

Cell[TextData[{
  "Note that at any point in a session, you can reset the line number counter \
",
  StyleBox["$Line", "MR"],
  ", so that for example new lines are numbered so as to overwrite previous \
ones. "
}], "Text",
  CellTags->{"S2.14.1", "1.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$PreRead", "MR"],
              " "
            }]], Cell[TextData[{
              "a function applied to each input string before being fed to ",
              StyleBox["Mathematica", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["$Pre", "MR"],
              " "
            }]], 
            Cell["\<\
a function applied to each input expression before \
evaluation \
\>"]},
          {Cell[TextData[{
              StyleBox["$Post", "MR"],
              " "
            }]], Cell[
            "a function applied to each expression after evaluation "]},
          {Cell[TextData[{
              StyleBox["$PrePrint", "MR"],
              " "
            }]], Cell[TextData[{
              "a function applied after ",
              StyleBox["Out[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " is assigned, but before the result is printed "
            }]]},
          {Cell[TextData[{
              StyleBox["$SyntaxHandler", "MR"],
              " "
            }]], 
            Cell["\<\
a function applied to any input line that yields a \
syntax error \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.1"],

Cell["Global functions used in the main loop. ", "Caption",
  CellTags->"S2.14.1"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " provides a variety of \
\[OpenCurlyDoubleQuote]hooks\[CloseCurlyDoubleQuote] that allow you to insert \
functions to be applied to expressions at various stages in the main loop. \
Thus, for example, any function you assign as the value of the global \
variable ",
  StyleBox["$Pre", "MR"],
  " will automatically be applied before evaluation to any expression you \
give as input. "
}], "Text",
  CellTags->{"S2.14.1", "1.13"}],

Cell[TextData[{
  "For a particular input line, the standard main loop begins by getting a \
text string of input. Particularly if you need to deal with special \
characters, you may want to modify this text string before it is further \
processed by ",
  StyleBox["Mathematica", "TI"],
  ". You can do this by assigning a function as the value of the global \
variable ",
  StyleBox["$PreRead", "MR"],
  ". This function will be applied to the text string, and the result will be \
used as the actual input string for the particular input line. "
}], "Text",
  CellTags->{"S2.14.1", "1.14"}],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " to replace ",
  StyleBox["<<", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox[">>", "MR"],
  " by ",
  StyleBox["{", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  " in every input string. "
}], "MathCaption",
  CellTags->{"S2.14.1", "1.15"}],

Cell[CellGroupData[{

Cell["$PreRead = StringReplace[#, {\"<<\" -> \"{\", \">>\" -> \"}\"}]&", \
"Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.14.1"],

Cell[BoxData[
    \(StringReplace[#1, {"<<" \[Rule] "{", ">>" \[Rule] "}"}] &\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.14.1"]
}, Open  ]],

Cell["You can now enter braces as double angle brackets. ", "MathCaption",
  CellTags->{"S2.14.1", "1.16"}],

Cell[CellGroupData[{

Cell["<<4, 5, 6>>", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.14.1"],

Cell[BoxData[
    \({4, 5, 6}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.14.1"]
}, Open  ]],

Cell[TextData[{
  "You can remove the value for ",
  StyleBox["$PreRead", "MR"],
  " like this, at least so long as your definition for ",
  StyleBox["$PreRead", "MR"],
  " does not modify this very input string. "
}], "MathCaption",
  CellTags->{"S2.14.1", "1.17"}],

Cell["$PreRead =.", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.14.1"],

Cell[TextData[{
  "Once any ",
  StyleBox["$PreRead", "MR"],
  " processing on an input string is finished, the string is read by ",
  StyleBox["Mathematica", "TI"],
  ". At this point, ",
  StyleBox["Mathematica", "TI"],
  " may find that there is a syntax error in the string. If this happens, \
then ",
  StyleBox["Mathematica", "TI"],
  " calls whatever function you have specified as the value of ",
  StyleBox["$SyntaxHandler", "MR"],
  ". It supplies two arguments: the input string, and the character position \
at which the syntax error was detected. With ",
  StyleBox["$SyntaxHandler", "MR"],
  " you can, for example, generate an analysis of the syntax error, or call \
an editor. If your function returns a string, then ",
  StyleBox["Mathematica", "TI"],
  " will use this string as a new input string. "
}], "Text",
  CellTags->{"S2.14.1", "1.18"}],

Cell[TextData[{
  "This specifies what ",
  StyleBox["Mathematica", "TI"],
  " should do when it gets a syntax error. "
}], "MathCaption",
  CellTags->{"S2.14.1", "1.19"}],

Cell[CellGroupData[{

Cell["\<\
$SyntaxHandler = (Print[StringForm[\"Error at char `1` in `2`\", \
#2, #1]]; $Failed)&\
\>", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.14.1"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(", 
        RowBox[{
          RowBox[{"Print", "[", 
            
            InterpretationBox["\<\"Error at char \\!\\(#2\\) in \\!\\(#1\\)\"\
\>",
              StringForm[ "Error at char `1` in `2`", #2, #],
              Editable->False], "]"}], ";", "$Failed"}], ")"}], 
      "&"}]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.14.1"]
}, Open  ]],

Cell["This input generates a syntax error. ", "MathCaption",
  CellTags->{"S2.14.1", "1.20"}],

Cell[CellGroupData[{

Cell["3 +/+ 5", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.14.1"],

Cell["Syntax::sntxf: \"3 +\" cannot be followed by \"/+ 5\". ", "Message",
  CellTags->"S2.14.1"],

Cell[BoxData[
    InterpretationBox["\<\"Error at char \\!\\(4\\) in 3 +/+ 5\\n\"\>",
      StringForm[ "Error at char `1` in `2`", 4, "3 +/+ 5 "],
      Editable->False]], "Print",
  CellTags->"S2.14.1"]
}, Open  ]],

Cell[TextData[{
  "Once ",
  StyleBox["Mathematica", "TI"],
  " has successfully read an input expression, it then evaluates this \
expression. Before doing the evaluation, ",
  StyleBox["Mathematica", "TI"],
  " applies any function you have specified as the value of ",
  StyleBox["$Pre", "MR"],
  ", and after the evaluation, it applies any function specified as the value \
of ",
  StyleBox["$Post", "MR"],
  ". Note that unless the ",
  StyleBox["$Pre", "MR"],
  " function holds its arguments unevaluated, the function will have exactly \
the same effect as ",
  StyleBox["$Post", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.14.1", "1.21"}],

Cell[TextData[{
  StyleBox["$Post", "MR"],
  " allows you to specify arbitrary \[OpenCurlyDoubleQuote]post processing\
\[CloseCurlyDoubleQuote] to be done on results obtained from ",
  StyleBox["Mathematica", "TI"],
  ". Thus, for example, to make ",
  StyleBox["Mathematica", "TI"],
  " get a numerical approximation to every result it generates, all you need \
do is to set ",
  StyleBox["$Post", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["N", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.14.1", "1.22"}],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " to apply ",
  StyleBox["N", "MR"],
  " to every result it generates. "
}], "MathCaption",
  CellTags->{"S2.14.1", "1.23"}],

Cell[CellGroupData[{

Cell["$Post = N", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.14.1"],

Cell[BoxData[
    \(N\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.14.1"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["Mathematica", "TI"],
  " gets a numerical approximation to anything you type in. "
}], "MathCaption",
  CellTags->{"S2.14.1", "1.24"}],

Cell[CellGroupData[{

Cell["Sqrt[7]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.14.1"],

Cell[BoxData[
    \(2.6457513110645907`\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.14.1"]
}, Open  ]],

Cell["\<\
This removes the post\[Hyphen]processing function you specified. \
\
\>", "MathCaption",
  CellTags->{"S2.14.1", "1.25"}],

Cell["$Post =.", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.14.1"],

Cell[TextData[{
  "As soon as ",
  StyleBox["Mathematica", "TI"],
  " has generated a result, and applied any ",
  StyleBox["$Post", "MR"],
  " function you have specified, it takes the result, and assigns it as the \
value of ",
  StyleBox["Out[$Line]", "MR"],
  ". The next step is for ",
  StyleBox["Mathematica", "TI"],
  " to print the result. However, before doing this, it applies any function \
you have specified as the value of ",
  StyleBox["$PrePrint", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.14.1", "1.26"}],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " to shorten all output to two lines. "
}], "MathCaption",
  CellTags->{"S2.14.1", "1.27"}],

Cell["$PrePrint = Short[#, 2]& ;", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.14.1"],

Cell["\<\
Only a two\[Hyphen]line version of the output is now shown. \
\>", \
"MathCaption",
  CellTags->{"S2.14.1", "1.28"}],

Cell[CellGroupData[{

Cell["Expand[(x + y)^40]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.14.1"],

Cell[BoxData[
    TagBox[\(x\^40 + 40\ x\^39\ y + 
        780\ x\^38\ y\^2 + \[LeftSkeleton]35\[RightSkeleton] + 
        780\ x\^2\ y\^38 + 40\ x\ y\^39 + y\^40\),
      (Short[ #, 2]&)]], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.14.1"]
}, Open  ]],

Cell[TextData[{
  "This removes the value you assigned to ",
  StyleBox["$PrePrint", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.14.1", "1.29"}],

Cell["$PrePrint =.", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.14.1"],

Cell[TextData[{
  "There are various kinds of output generated in a typical ",
  StyleBox["Mathematica", "TI"],
  " session. In general, each kind of output is sent to a definite ",
  StyleBox["output channel", "TI"],
  ", as discussed in Section\[NonBreakingSpace]",
  ButtonBox["2.12.3",
    ButtonData:>{"2.12.3", "3.23"},
    ButtonStyle->"MainBookLink"],
  ". Associated with each output channel, there is a global variable which \
gives a list of the output streams to be included in that output channel. "
}], "Text",
  CellTags->{"S2.14.1", "1.30"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$Output", "MR"],
              " "
            }]], Cell[TextData[{
              "standard output and text generated by ",
              StyleBox["Print", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["$Echo", "MR"],
              " "
            }]], Cell[TextData[{
              "an echo of each input line (as stored in ",
              StyleBox["InString[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["$Urgent", "MR"],
              " "
            }]], Cell["input prompts and other urgent output "]},
          {Cell[TextData[{
              StyleBox["$Messages", "MR"],
              " "
            }]], Cell[TextData[{
              "standard messages and output generated by ",
              StyleBox["Message", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["$Display", "MR"],
              " "
            }]], Cell[TextData[{
              "graphics output generated by the default ",
              StyleBox["$DisplayFunction", "MR"]
            }]]},
          {Cell[TextData[{
              StyleBox["$SoundDisplay", "MR"],
              " "
            }]], Cell[TextData[{
              "sound output generated by the default ",
              StyleBox["$SoundDisplayFunction", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.1"],

Cell[TextData[{
  "Output channels in a standard ",
  StyleBox["Mathematica", "SO"],
  " session. "
}], "Caption",
  CellTags->"S2.14.1"],

Cell[TextData[{
  "By modifying the list of streams in a given output channel, you can \
redirect or copy particular kinds of ",
  StyleBox["Mathematica", "TI"],
  " output. Thus, for example, by opening an output stream to a file, and \
including that stream in the ",
  StyleBox["$Echo", "MR"],
  " list, you can get each piece of input you give to ",
  StyleBox["Mathematica", "TI"],
  " saved in a file. "
}], "Text",
  CellTags->{"S2.14.1", "1.31"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Streams[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["list of all open streams "]},
          {Cell[TextData[{
              StyleBox["Streams[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["list of all open streams with the specified name "]},
          {Cell[TextData[{
              StyleBox["$Input", "MR"],
              " "
            }]], Cell["the name of the current input stream "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.1"],

Cell[TextData[{
  "Open streams in a ",
  StyleBox["Mathematica", "SO"],
  " session. "
}], "Caption",
  CellTags->"S2.14.1"],

Cell[TextData[{
  "The function ",
  StyleBox["Streams", "MR"],
  " shows you all the input, output and other streams that are open at a \
particular point in a ",
  StyleBox["Mathematica", "TI"],
  " session. The variable ",
  StyleBox["$Input", "MR"],
  " gives the name of the current stream from which ",
  StyleBox["Mathematica", "TI"],
  " input is being taken at a particular point. ",
  StyleBox["$Input", "MR"],
  " is reset, for example, during the execution of a ",
  StyleBox["Get", "MR"],
  " command. "
}], "Text",
  CellTags->{"S2.14.1", "1.32"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$MessagePrePrint", "MR"],
              " "
            }]], 
            Cell["\<\
a function to be applied to expressions that are given \
in messages \
\>"]},
          {Cell[TextData[{
              StyleBox["$Language", "MR"],
              " "
            }]], Cell["list of default languages to use for messages "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.1"],

Cell["Parameters for messages. ", "Caption",
  CellTags->"S2.14.1"],

Cell[TextData[{
  "There are various global parameters which determine the form of messages \
generated by ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.14.1", "1.33"}],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["2.9.21",
    ButtonData:>{"2.9.21", "21.1"},
    ButtonStyle->"MainBookLink"],
  ", typical messages include a sequence of expressions which are combined \
with the text of the message through ",
  StyleBox["StringForm", "MR"],
  ". ",
  StyleBox["$MessagePrePrint", "MR"],
  " gives a function to be applied to the expressions before they are \
printed. The default value of ",
  StyleBox["$MessagePrePrint", "MR"],
  " is ",
  StyleBox["Short", "MR"],
  "."
}], "Text",
  CellTags->{"S2.14.1", "1.34"}],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["2.9.22",
    ButtonData:>{"2.9.22", "22.1"},
    ButtonStyle->"MainBookLink"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " allows you to specify the language in which you want messages to be \
produced. In a particular ",
  StyleBox["Mathematica", "TI"],
  " session, you can assign a list of language names as the value of ",
  StyleBox["$Language", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.14.1", "1.35"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Exit[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Quit[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "terminate your ",
              StyleBox["Mathematica", "TI"],
              " session "
            }]]},
          {Cell[TextData[{
              StyleBox["$Epilog", "MR"],
              " "
            }]], Cell[
            "a global variable to be evaluated before termination "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.1"],

Cell[TextData[{
  "Terminating ",
  StyleBox["Mathematica", "SO"],
  " sessions. "
}], "Caption",
  CellTags->"S2.14.1"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " will continue in its main loop until you explicitly tell it to exit. Most \
",
  StyleBox["Mathematica", "TI"],
  " interfaces provide special ways to do this. Nevertheless, you can always \
do it by explicitly calling ",
  StyleBox["Exit", "MR"],
  " or ",
  StyleBox["Quit", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.14.1", "1.36"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to give a value to the global variable ",
  StyleBox["$Epilog", "MR"],
  " to specify operations to perform just before ",
  StyleBox["Mathematica", "TI"],
  " actually exits. In this way, you can for example make ",
  StyleBox["Mathematica", "TI"],
  " always save certain objects before exiting. "
}], "Text",
  CellTags->{"S2.14.1", "1.37"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$IgnoreEOF", "MR"],
              " "
            }]], 
            Cell["\<\
whether to ignore the end\[Hyphen]of\[Hyphen]file \
character \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.1"],

Cell["\<\
A global variable that determines the treatment of end\[Hyphen]of\
\[Hyphen]file characters. \
\>", "Caption",
  CellTags->"S2.14.1"],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["2.8.6",
    ButtonData:>{"2.8.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " usually does not treat special characters in a special way. There is one \
potential exception, however. With the default setting ",
  StyleBox["$IgnoreEOF", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["False", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " recognizes end\[Hyphen]of\[Hyphen]file characters. If ",
  StyleBox["Mathematica", "TI"],
  " receives an end\[Hyphen]of\[Hyphen]file character as the only thing on a \
particular input line in a standard interactive ",
  StyleBox["Mathematica", "TI"],
  " session, then it will exit the session. "
}], "Text",
  CellTags->{"S2.14.1", "1.38"}],

Cell["\<\
Exactly how you enter an end\[Hyphen]of\[Hyphen]file character \
depends on the computer system you are using. Under Unix, for example, you \
typically press Control\[Hyphen]D. \
\>", "Text",
  CellTags->{"S2.14.1", "1.39"}],

Cell[TextData[{
  "Note that if you use ",
  StyleBox["Mathematica", "TI"],
  " in a \[OpenCurlyDoubleQuote]batch mode\[CloseCurlyDoubleQuote], with all \
its input coming from a file, then it will automatically exit when it reaches \
the end of the file, regardless of the value of ",
  StyleBox["$IgnoreEOF", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.14.1", "1.40"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.14.2 Dialogs", "Subsection",
  CellTags->{"S2.14.2", "2.1"}],

Cell[TextData[{
  "Within a standard interactive session, you can create \
\[OpenCurlyDoubleQuote]subsessions\[CloseCurlyDoubleQuote] or ",
  StyleBox["dialogs", "TI"],
  " using the ",
  StyleBox["Mathematica", "TI"],
  " command ",
  StyleBox["Dialog", "MR"],
  ". Dialogs are often useful if you want to interact with ",
  StyleBox["Mathematica", "TI"],
  " while it is in the middle of doing a calculation. As mentioned in Section \
",
  ButtonBox["2.6.11",
    ButtonData:>{"2.6.11", "11.1"},
    ButtonStyle->"MainBookLink"],
  ", ",
  StyleBox["TraceDialog", "MR"],
  " for example automatically calls ",
  StyleBox["Dialog", "MR"],
  " at specified points in the evaluation of a particular expression. In \
addition, if you interrupt ",
  StyleBox["Mathematica", "TI"],
  " during a computation, you can typically \[OpenCurlyDoubleQuote]inspect\
\[CloseCurlyDoubleQuote] its state using a dialog. "
}], "Text",
  CellTags->{"S2.14.2", "2.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Dialog[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "initiate a ",
              StyleBox["Mathematica", "TI"],
              " dialog "
            }]]},
          {Cell[TextData[{
              StyleBox["Dialog[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "initiate a dialog with ",
              StyleBox["expr", "TI"],
              " as the current value of ",
              StyleBox["%", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Return[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "return from a dialog, taking the current value of ",
              StyleBox["%", "MR"],
              " as the return value "
            }]]},
          {Cell[TextData[{
              StyleBox["Return[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "return from a dialog, taking ",
              StyleBox["expr", "TI"],
              " as the return value "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.2"],

Cell["Initiating and returning from dialogs. ", "Caption",
  CellTags->"S2.14.2"],

Cell["This initiates a dialog. ", "MathCaption",
  CellTags->{"S2.14.2", "2.3"}],

Cell["Dialog[ ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.14.2"],

Cell[TextData[{
  "You can do computations in a dialog just as you would in any ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "MathCaption",
  CellTags->{"S2.14.2", "2.4"}],

Cell[CellGroupData[{

Cell["2^41", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.14.2"],

Cell[BoxData[
    \(2199023255552\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.14.2"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Return", "MR"],
  " to exit from a dialog. "
}], "MathCaption",
  CellTags->{"S2.14.2", "2.5"}],

Cell[CellGroupData[{

Cell["Return[ ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.14.2"],

Cell[BoxData[
    \(2199023255552\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.14.2"]
}, Open  ]],

Cell[TextData[{
  "When you exit a dialog, you can return a value for the dialog using ",
  StyleBox["Return[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  ". If you do not want to return a value, and you have set ",
  StyleBox["$IgnoreEOF", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["False", "MR"],
  ", then you can also exit a dialog simply by giving an end\[Hyphen]of\
\[Hyphen]file character, at least on systems with text\[Hyphen]based \
interfaces. "
}], "Text",
  CellTags->{"S2.14.2", "2.6"}],

Cell[TextData[{
  "To evaluate this expression, ",
  StyleBox["Mathematica", "TI"],
  " initiates a dialog. "
}], "MathCaption",
  CellTags->{"S2.14.2", "2.7"}],

Cell["1 + Dialog[ ]^2", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.14.2"],

Cell[TextData[{
  "The value ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  " returned from the dialog is now inserted in the original expression. "
}], "MathCaption",
  CellTags->{"S2.14.2", "2.8"}],

Cell[CellGroupData[{

Cell["Return[a + b]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.14.2"],

Cell[BoxData[
    \(1 + \((a + b)\)\^2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.14.2"]
}, Open  ]],

Cell[TextData[{
  "In starting a dialog, you will often find it useful to have some \
\[OpenCurlyDoubleQuote]initial expression\[CloseCurlyDoubleQuote]. If you use \
",
  StyleBox["Dialog[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " will start a dialog, using ",
  StyleBox["expr", "TI"],
  " as the initial expression, accessible for example as the value of ",
  StyleBox["%", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.14.2", "2.9"}],

Cell[TextData[{
  "This first starts a dialog with initial expression ",
  StyleBox["a^2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.14.2", "2.10"}],

Cell[CellGroupData[{

Cell["Map[Dialog, {a^2, b + c}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.14.2"],

Cell[BoxData[
    \(a\^2\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.14.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["%", "MR"],
  " is the initial expression in the dialog. "
}], "MathCaption",
  CellTags->{"S2.14.2", "2.11"}],

Cell[CellGroupData[{

Cell["%^2 + 1", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.14.2"],

Cell[BoxData[
    \(1 + a\^4\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.14.2"]
}, Open  ]],

Cell[TextData[{
  "This returns a value from the first dialog, and starts the second dialog, \
with initial expression ",
  StyleBox["b", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["c", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.14.2", "2.12"}],

Cell[CellGroupData[{

Cell["Return[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.14.2"],

Cell[BoxData[
    \(b + c\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.14.2"]
}, Open  ]],

Cell["\<\
This returns a value from the second dialog. The final result is \
the original expression, with values from the two dialogs inserted. \
\>", \
"MathCaption",
  CellTags->{"S2.14.2", "2.13"}],

Cell[CellGroupData[{

Cell["Return[444]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.14.2"],

Cell[BoxData[
    \({1 + a\^4, 444}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.14.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Dialog", "MR"],
  " effectively works by running a subsidiary version of the standard ",
  StyleBox["Mathematica", "TI"],
  " main loop. Each dialog you start effectively \
\[OpenCurlyDoubleQuote]inherits\[CloseCurlyDoubleQuote] various values from \
the overall main loop. Some of the values are, however, local to the dialog, \
so their original values are restored when you exit the dialog."
}], "Text",
  CellTags->{"S2.14.2", "2.14"}],

Cell[TextData[{
  "Thus, for example, dialogs inherit the current line number ",
  StyleBox["$Line", "MR"],
  " when they start. This means that the lines in a dialog have numbers that \
follow the sequence used in the main loop. Nevertheless, the value of ",
  StyleBox["$Line", "MR"],
  " is local to the dialog. As a result, when you exit the dialog, the value \
of ",
  StyleBox["$Line", "MR"],
  " reverts to what it was in the main loop. "
}], "Text",
  CellTags->{"S2.14.2", "2.15"}],

Cell[TextData[{
  "If you start a dialog on line ",
  StyleBox["10", "MR"],
  " of your ",
  StyleBox["Mathematica", "TI"],
  " session, then the first line of the dialog will be labeled ",
  StyleBox["In[11]", "MB"],
  ". Successive lines of the dialog will be labeled ",
  StyleBox["In[12]", "MB"],
  ", ",
  StyleBox["In[13]", "MB"],
  " and so on. Then, when you exit the dialog, the next line in your main \
loop will be labeled ",
  StyleBox["In[11]", "MB"],
  ". At this point, you can still refer to results generated within the \
dialog as ",
  StyleBox["Out[11]", "MB"],
  ", ",
  StyleBox["Out[12]", "MB"],
  " and so on. These results will be overwritten, however, when you reach \
lines ",
  StyleBox["In[12]", "MB"],
  ", ",
  StyleBox["In[13]", "MB"],
  ", and so on in the main loop. "
}], "Text",
  CellTags->{"S2.14.2", "2.16"}],

Cell[TextData[{
  "In a standard ",
  StyleBox["Mathematica", "TI"],
  " session, you can tell whether you are in a dialog by seeing whether your \
input and output lines are indented. If you call a dialog from within a \
dialog, you will get two levels of indentation. In general, the indentation \
you get inside ",
  StyleBox["d", "TI"],
  " nested dialogs is determined by the output form of the object ",
  StyleBox["DialogIndent[", "MR"],
  StyleBox["d", "TI"],
  StyleBox["]", "MR"],
  ". By defining the format for this object, you can specify how dialogs \
should be indicated in your ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Text",
  CellTags->{"S2.14.2", "2.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DialogSymbols", "MR"],
              " ",
              StyleBox[":>", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], 
            Cell["\<\
symbols whose values should be treated as local to the \
dialog \
\>"]},
          {Cell[TextData[{
              StyleBox["DialogSymbols", "MR"],
              " ",
              StyleBox[":>", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["symbols with initial values "]},
          {Cell[TextData[{
              StyleBox["DialogProlog", "MR"],
              " ",
              StyleBox[":>", "MR"],
              " ",
              StyleBox["expr", "TI"],
              " "
            }]], Cell[
            "an expression to evaluate before starting the dialog "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.2"],

Cell[TextData[{
  "Options for ",
  StyleBox["Dialog", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.14.2"],

Cell[TextData[{
  "Whatever setting you give for ",
  StyleBox["DialogSymbols", "MR"],
  ", ",
  StyleBox["Dialog", "MR"],
  " will always treat the values of ",
  StyleBox["$Line", "MR"],
  ", ",
  StyleBox["$Epilog", "MR"],
  " and ",
  StyleBox["$MessageList", "MR"],
  " as local. Note that if you give a value for ",
  StyleBox["$Epilog", "MR"],
  ", it will automatically be evaluated when you exit the dialog. "
}], "Text",
  CellTags->{"S2.14.2", "2.18"}],

Cell[TextData[{
  "When you call ",
  StyleBox["Dialog", "MR"],
  ", its first step is to localize the values of variables. Then it evaluates \
any expression you have set for the option ",
  StyleBox["DialogProlog", "MR"],
  ". If you have given an explicit argument to the ",
  StyleBox["Dialog", "MR"],
  " function, this is then evaluated next. Finally, the actual dialog is \
started. "
}], "Text",
  CellTags->{"S2.14.2", "2.19"}],

Cell[TextData[{
  "When you exit the dialog, you can explicitly specify the return value \
using ",
  StyleBox["Return[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  ". If you do not do this, the return value will be taken to be the last \
value generated in the dialog. "
}], "Text",
  CellTags->{"S2.14.2", "2.20"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.14.3 Date and Time Functions", "Subsection",
  CellTags->{"S2.14.3", "3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Date[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the current local date and time in the form ",
              StyleBox["{", "MR"],
              StyleBox["year", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["month", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["day", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["hour", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["minute", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["second", "TI"],
              StyleBox["}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Date[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the current date and time in time zone ",
              StyleBox["z", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["TimeZone[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["give the time zone assumed by your computer system "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.3"],

Cell["Finding the date and time. ", "Caption",
  CellTags->"S2.14.3"],

Cell["This gives the current date and time. ", "MathCaption",
  CellTags->{"S2.14.3", "3.2"}],

Cell[CellGroupData[{

Cell["Date[ ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.14.3"],

Cell[BoxData[
    \({2005, 6, 20, 19, 6, 29.434348`8.221429401451358}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.14.3"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["Date", "MR"],
  " function returns whatever your computer system gives as the current date \
and time. It assumes that any corrections for daylight saving time and so on \
have already been done by your computer system. In addition, it assumes that \
your computer system has been set for the appropriate time zone. "
}], "Text",
  CellTags->{"S2.14.3", "3.3"}],

Cell[TextData[{
  "The function ",
  StyleBox["TimeZone[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " returns the current time zone assumed by your computer system. The time \
zone is given as the number of hours which must be added to Greenwich mean \
time (GMT) to obtain the correct local time. Thus, for example, U.S. eastern \
standard time (EST) corresponds to time zone ",
  Cell[BoxData[
      \(TraditionalForm\`\(-5\)\)], "InlineFormula"],
  ". Note that daylight saving time corrections must be included in the time \
zone, so U.S. eastern daylight time (EDT) corresponds to time zone ",
  Cell[BoxData[
      \(TraditionalForm\`\(-4\)\)], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S2.14.3", "3.4"}],

Cell["\<\
This gives the current time zone assumed by your computer system. \
\
\>", "MathCaption",
  CellTags->{"S2.14.3", "3.5"}],

Cell[CellGroupData[{

Cell["TimeZone[ ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.14.3"],

Cell[BoxData[
    \(\(-5.`\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.14.3"]
}, Open  ]],

Cell["\<\
This gives the current date and time in time zone +9, the time zone \
for Japan. \
\>", "MathCaption",
  CellTags->{"S2.14.3", "3.6"}],

Cell[CellGroupData[{

Cell["Date[9]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.14.3"],

Cell[BoxData[
    \({2005, 6, 21, 9, 6, 29.442698`8.221552585584893}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.14.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["AbsoluteTime[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
total number of seconds since the beginning of January \
1, 1900 \
\>"]},
          {Cell[TextData[{
              StyleBox["SessionTime[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "total number of seconds elapsed since the beginning of your \
current ",
              StyleBox["Mathematica", "TI"],
              " session "
            }]]},
          {Cell[TextData[{
              StyleBox["TimeUsed[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "total number of seconds of CPU time used in your current ",
              StyleBox["Mathematica", "TI"],
              " session "
            }]]},
          {Cell[TextData[{
              StyleBox["$TimeUnit", "MR"],
              " "
            }]], Cell[
            "the minimum time interval recorded on your computer system "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.3"],

Cell["Time functions. ", "Caption",
  CellTags->"S2.14.3"],

Cell[TextData[{
  "You should realize that on any computer system, there is a certain \
\[OpenCurlyDoubleQuote]granularity\[CloseCurlyDoubleQuote] in the times that \
can be measured. This granularity is given as the value of the global \
variable ",
  StyleBox["$TimeUnit", "MR"],
  ". Typically it is either about ",
  Cell[BoxData[
      \(TraditionalForm\`1\/100\)], "InlineFormula"],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`1\/1000\)], "InlineFormula"],
  " of a second. "
}], "Text",
  CellTags->{"S2.14.3", "3.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Pause[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "pause for at least ",
              StyleBox["n", "TI"],
              " seconds "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.3"],

Cell["Pausing during a calculation. ", "Caption",
  CellTags->"S2.14.3"],

Cell["This gives various time functions. ", "MathCaption",
  CellTags->{"S2.14.3", "3.8"}],

Cell[CellGroupData[{

Cell["{AbsoluteTime[ ], SessionTime[ ], TimeUsed[ ]}", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.14.3"],

Cell[BoxData[
    \({3.328283189460137`16.27479526062103*^9, 3.102394`6.943241945310087, 
      0.42`}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.14.3"]
}, Open  ]],

Cell[TextData[{
  "This pauses for 10 seconds, then re\[Hyphen]evaluates the time functions. \
Note that ",
  StyleBox["TimeUsed[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " is not affected by the pause. "
}], "MathCaption",
  CellTags->{"S2.14.3", "3.9"}],

Cell[CellGroupData[{

Cell["Pause[10]; {AbsoluteTime[ ], SessionTime[ ], TimeUsed[ ]}", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.14.3"],

Cell[BoxData[
    \({3.328283199469428`16.274795261927107*^9, 13.111678`7.569203268672487, 
      0.42`}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.14.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FromDate[", "MR"],
              StyleBox["date", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["convert from date to absolute time "]},
          {Cell[TextData[{
              StyleBox["ToDate[", "MR"],
              StyleBox["time", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["convert from absolute time to date "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.3"],

Cell["Converting between dates and absolute times. ", "Caption",
  CellTags->"S2.14.3"],

Cell[TextData[{
  "This sets ",
  StyleBox["d", "MR"],
  " to be the current date. "
}], "MathCaption",
  CellTags->{"S2.14.3", "3.10"}],

Cell[CellGroupData[{

Cell["d = Date[ ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.14.3"],

Cell[BoxData[
    \({2005, 6, 20, 19, 6, 39.473385`8.34887934899681}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.14.3"]
}, Open  ]],

Cell["This adds one month to the current date. ", "MathCaption",
  CellTags->{"S2.14.3", "3.11"}],

Cell[CellGroupData[{

Cell["Date[ ] + {0, 1, 0, 0, 0, 0}", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.14.3"],

Cell[BoxData[
    \({2005, 7, 20, 19, 6, 39.474697`8.348893783656802}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.14.3"]
}, Open  ]],

Cell["This gives the number of seconds in the additional month. ", \
"MathCaption",
  CellTags->{"S2.14.3", "3.12"}],

Cell[CellGroupData[{

Cell["FromDate[%] - FromDate[d]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.14.3"],

Cell[BoxData[
    \(2.592000001312`12.865179980276992*^6\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.14.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Timing[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              
              ", and return a list of the CPU time needed, together with the \
result obtained "
            }]]},
          {Cell[TextData[{
              StyleBox["AbsoluteTiming[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              ", giving the absolute time taken "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.3"],

Cell[TextData[{
  "Timing ",
  StyleBox["Mathematica", "SO"],
  " operations. "
}], "Caption",
  CellTags->"S2.14.3"],

Cell[TextData[{
  StyleBox["Timing", "MR"],
  " allows you to measure the CPU time, corresponding to the increase in ",
  StyleBox["TimeUsed", "MR"],
  ", associated with the evaluation of a single ",
  StyleBox["Mathematica", "TI"],
  " expression. Note that only CPU time associated with the actual evaluation \
of the expression within the ",
  StyleBox["Mathematica", "TI"],
  " kernel is included. The time needed to format the expression for output, \
and any time associated with external programs, is not included. "
}], "Text",
  CellTags->{"S2.14.3", "3.13"}],

Cell[TextData[{
  StyleBox["AbsoluteTiming", "MR"],
  " allows you to measure absolute total elapsed time. You should realize, \
however, that the time reported for a particular calculation by both ",
  StyleBox["AbsoluteTiming", "MR"],
  " and ",
  StyleBox["Timing", "MR"],
  " depends on many factors. "
}], "Text",
  CellTags->{"S2.14.3", "3.14"}],

Cell[TextData[{
  "First, the time depends in detail on the computer system you are using. It \
depends not only on instruction times, but also on memory caching, as well as \
on the details of the optimization done in compiling the parts of the \
internal code of ",
  StyleBox["Mathematica", "TI"],
  " used in the calculation. "
}], "Text",
  CellTags->{"S2.14.3", "3.15"}],

Cell[TextData[{
  "The time also depends on the precise state of your ",
  StyleBox["Mathematica", "TI"],
  " session when the calculation was done. Many of the internal optimizations \
used by ",
  StyleBox["Mathematica", "TI"],
  " depend on details of preceding calculations. For example, ",
  StyleBox["Mathematica", "TI"],
  " often uses previous results it has obtained, and avoids unnecessarily re\
\[Hyphen]evaluating expressions. In addition, some ",
  StyleBox["Mathematica", "TI"],
  " functions build internal tables when they are first called in a \
particular way, so that if they are called in that way again, they run much \
faster. For all of these kinds of reasons, it is often the case that a \
particular calculation may not take the same amount of time if you run it at \
different points in the same ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Text",
  CellTags->{"S2.14.3", "3.16"}],

Cell[TextData[{
  "This gives the CPU time needed for the calculation. The semicolon causes \
the result of the calculation to be given as ",
  StyleBox["Null", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.14.3", "3.17"}],

Cell[CellGroupData[{

Cell["Timing[100000!;]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.14.3"],

Cell[BoxData[
    \({0.2`\ Second, Null}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.14.3"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["Mathematica", "TI"],
  " has built internal tables for factorial functions, and the calculation \
takes no measurable CPU time. "
}], "MathCaption",
  CellTags->{"S2.14.3", "3.18"}],

Cell[CellGroupData[{

Cell["Timing[100000!;]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.14.3"],

Cell[BoxData[
    \({0.`\ Second, Null}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.14.3"]
}, Open  ]],

Cell["However, some absolute time does elapse. ", "MathCaption",
  CellTags->{"S2.14.3", "3.19"}],

Cell[CellGroupData[{

Cell["AbsoluteTiming[100000!;]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.14.3"],

Cell[BoxData[
    \({0.00003`1.9286662482156358\ Second, Null}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.14.3"]
}, Open  ]],

Cell[TextData[{
  "Note that the results you get from ",
  StyleBox["Timing", "MR"],
  " are only accurate to the timing granularity ",
  StyleBox["$TimeUnit", "MR"],
  " of your computer system. Thus, for example, a timing reported as ",
  StyleBox["0", "MR"],
  " could in fact be as much as ",
  StyleBox["$TimeUnit", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.14.3", "3.20"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["TimeConstrained[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to evaluate ",
              StyleBox["expr", "TI"],
              ", aborting the calculation after ",
              StyleBox["t", "TI"],
              " seconds "
            }]]},
          {Cell[TextData[{
              StyleBox["TimeConstrained[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["failexpr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "return ",
              StyleBox["failexpr", "TI"],
              " if the time constraint is not met "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.3"],

Cell["Time\[Hyphen]constrained calculation. ", "Caption",
  CellTags->"S2.14.3"],

Cell[TextData[{
  "When you use ",
  StyleBox["Mathematica", "TI"],
  " interactively, it is quite common to try doing a calculation, but to \
abort the calculation if it seems to be taking too long. You can emulate this \
behavior inside a program by using ",
  StyleBox["TimeConstrained", "MR"],
  ". ",
  StyleBox["TimeConstrained", "MR"],
  " tries to evaluate a particular expression for a specified amount of time. \
If it does not succeed, then it aborts the evaluation, and returns either ",
  StyleBox["$Aborted", "MR"],
  ", or an expression you specify. "
}], "Text",
  CellTags->{"S2.14.3", "3.21"}],

Cell[TextData[{
  "You can use ",
  StyleBox["TimeConstrained", "MR"],
  ", for example, to have ",
  StyleBox["Mathematica", "TI"],
  " try a particular approach to a problem for a certain amount of time, and \
then to switch to another approach if the first one has not yet succeeded. \
You should realize however that ",
  StyleBox["TimeConstrained", "MR"],
  " may overrun the time you specify if ",
  StyleBox["Mathematica", "TI"],
  " cannot be interrupted during a particular part of a calculation. In \
addition, you should realize that because different computer systems run at \
different speeds, programs that use ",
  StyleBox["TimeConstrained", "MR"],
  " will often give different results on different systems. "
}], "Text",
  CellTags->{"S2.14.3", "3.22"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.14.4 Memory Management", "Subsection",
  CellTags->{"S2.14.4", "4.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MemoryInUse[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "number of bytes of memory currently being used by ",
              StyleBox["Mathematica", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["MaxMemoryUsed[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "maximum number of bytes of memory used by ",
              StyleBox["Mathematica", "TI"],
              " in this session "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.4"],

Cell["Finding memory usage. ", "Caption",
  CellTags->"S2.14.4"],

Cell["\<\
Particularly for symbolic computations, memory is usually the \
primary resource which limits the size of computations you can do. If a \
computation runs slowly, you can always potentially let it run longer. But if \
the computation generates intermediate expressions which simply cannot fit in \
the memory of your computer system, then you cannot proceed with the \
computation. \
\>", "Text",
  CellTags->{"S2.14.4", "4.2"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " is careful about the way it uses memory. Every time an intermediate \
expression you have generated is no longer needed, ",
  StyleBox["Mathematica", "TI"],
  " immediately reclaims the memory allocated to it. This means that at any \
point in a session, ",
  StyleBox["Mathematica", "TI"],
  " stores only those expressions that are actually needed; it does not keep \
unnecessary objects which have to be \[OpenCurlyDoubleQuote]garbage collected\
\[CloseCurlyDoubleQuote] later. "
}], "Text",
  CellTags->{"S2.14.4", "4.3"}],

Cell[TextData[{
  "This gives the number of bytes of memory currently being used by ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.14.4", "4.4"}],

Cell[CellGroupData[{

Cell["MemoryInUse[ ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.14.4"],

Cell[BoxData[
    \(947712\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.14.4"]
}, Open  ]],

Cell["\<\
This generates a 10000\[Hyphen]element list. \
\>", "MathCaption",
  CellTags->{"S2.14.4", "4.5"}],

Cell[CellGroupData[{

Cell["Range[10000] // Short", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.14.4"],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7, 8, \[LeftSkeleton]9985\[RightSkeleton], 9994, 
      9995, 9996, 9997, 9998, 9999, 10000}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.14.4"]
}, Open  ]],

Cell["Additional memory is needed to store the list. ", "MathCaption",
  CellTags->{"S2.14.4", "4.6"}],

Cell[CellGroupData[{

Cell["MemoryInUse[ ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.14.4"],

Cell[BoxData[
    \(989616\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.14.4"]
}, Open  ]],

Cell[TextData[{
  "This list is kept because it is the value of ",
  StyleBox["Out[2]", "MR"],
  ". If you clear ",
  StyleBox["Out[2]", "MR"],
  ", the list is no longer needed. "
}], "MathCaption",
  CellTags->{"S2.14.4", "4.7"}],

Cell["Unprotect[Out]; Out[2]=.", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.14.4"],

Cell["The memory in use goes down again. ", "MathCaption",
  CellTags->{"S2.14.4", "4.8"}],

Cell[CellGroupData[{

Cell["MemoryInUse[ ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.14.4"],

Cell[BoxData[
    \(954408\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.14.4"]
}, Open  ]],

Cell["\<\
This shows the maximum memory needed at any point in the session. \
\
\>", "MathCaption",
  CellTags->{"S2.14.4", "4.9"}],

Cell[CellGroupData[{

Cell["MaxMemoryUsed[ ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.14.4"],

Cell[BoxData[
    \(1467536\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.14.4"]
}, Open  ]],

Cell[TextData[{
  "One issue that often comes up is exactly how much memory ",
  StyleBox["Mathematica", "TI"],
  " can actually use on a particular computer system. Usually there is a \
certain amount of memory available for ",
  StyleBox["all", "TI"],
  " processes running on the computer at a particular time. Sometimes this \
amount of memory is equal to the physical number of bytes of RAM in the \
computer. Often, it includes a certain amount of \
\[OpenCurlyDoubleQuote]virtual memory\[CloseCurlyDoubleQuote], obtained by \
swapping data on and off a mass storage device. "
}], "Text",
  CellTags->{"S2.14.4", "4.10"}],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " runs, it needs space both for data and for code. The complete code of ",
  StyleBox["Mathematica", "TI"],
  " is typically several megabytes in size. For any particular calculation, \
only a small fraction of this code is usually used. However, in trying to \
work out the total amount of space available for ",
  StyleBox["Mathematica", "TI"],
  " data, you should not forget what is needed for ",
  StyleBox["Mathematica", "TI"],
  " code. In addition, you must include the space that is taken up by other \
processes running in the computer. If there are fewer jobs running, you will \
usually find that your job can use more memory. "
}], "Text",
  CellTags->{"S2.14.4", "4.11"}],

Cell[TextData[{
  "It is also worth realizing that the time needed to do a calculation can \
depend very greatly on how much physical memory you have. Although virtual \
memory allows you in principle to use large amounts of memory space, it is \
usually hundreds or even thousands of times slower to access than physical \
memory. As a result, if your calculation becomes so large that it needs to \
make use of virtual memory, it may run ",
  StyleBox["much", "TI"],
  " more slowly. "
}], "Text",
  CellTags->{"S2.14.4", "4.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MemoryConstrained[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to evaluate ",
              StyleBox["expr", "TI"],
              ", aborting if more than ",
              StyleBox["b", "TI"],
              " additional bytes of memory are requested "
            }]]},
          {Cell[TextData[{
              StyleBox["MemoryConstrained[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["failexpr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "return ",
              StyleBox["failexpr", "TI"],
              " if the memory constraint is not met "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.4"],

Cell["\<\
Memory\[Hyphen]constrained computation. \
\>", "Caption",
  CellTags->"S2.14.4"],

Cell[TextData[{
  StyleBox["MemoryConstrained", "MR"],
  " works much like ",
  StyleBox["TimeConstrained", "MR"],
  ". If more than the specified amount of memory is requested, ",
  StyleBox["MemoryConstrained", "MR"],
  " attempts to abort your computation. As with ",
  StyleBox["TimeConstrained", "MR"],
  ", there may be some overshoot in the actual amount of memory used before \
the computation is aborted. "
}], "Text",
  CellTags->{"S2.14.4", "4.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ByteCount[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the maximum number of bytes of memory needed to store ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LeafCount[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the number of terminal nodes in the expression tree for ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.4"],

Cell["Finding the size of expressions. ", "Caption",
  CellTags->"S2.14.4"],

Cell[TextData[{
  "Although you may find ",
  StyleBox["ByteCount", "MR"],
  " useful in estimating how large an expression of a particular kind you can \
handle, you should realize that the specific results given by ",
  StyleBox["ByteCount", "MR"],
  " can differ substantially from one version of ",
  StyleBox["Mathematica", "TI"],
  " to another. "
}], "Text",
  CellTags->{"S2.14.4", "4.14"}],

Cell[TextData[{
  "Another important point is that ",
  StyleBox["ByteCount", "MR"],
  " always gives you the ",
  StyleBox["maximum", "TI"],
  " amount of memory needed to store a particular expression. Often ",
  StyleBox["Mathematica", "TI"],
  " will actually use a much smaller amount of memory to store the \
expression. The main issue is how many of the subexpressions in the \
expression can be ",
  StyleBox["shared", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.14.4", "4.15"}],

Cell[TextData[{
  "In an expression like ",
  StyleBox["f[1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x,", "MR"],
  " ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x]", "MR"],
  ", the two subexpressions ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x", "MR"],
  " are identical, but they may or may not actually be stored in the same \
piece of computer memory. ",
  StyleBox["ByteCount", "MR"],
  " gives you the number of bytes needed to store expressions with the \
assumption that no subexpressions are shared. You should realize that the \
sharing of subexpressions is often destroyed as soon as you use an operation \
like the ",
  StyleBox["/.", "MR"],
  " operator. "
}], "Text",
  CellTags->{"S2.14.4", "4.16"}],

Cell[TextData[{
  "Nevertheless, you can explicitly tell ",
  StyleBox["Mathematica", "TI"],
  " to share subexpressions using the function ",
  StyleBox["Share", "MR"],
  ". In this way, you can significantly reduce the actual amount of memory \
needed to store a particular expression. "
}], "Text",
  CellTags->{"S2.14.4", "4.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Share[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "share common subexpressions in the storage of ",
              StyleBox["expr", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["Share[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["share common subexpressions throughout memory "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.4"],

Cell["Optimizing memory usage. ", "Caption",
  CellTags->"S2.14.4"],

Cell["\<\
On most computer systems, the memory used by a running program is \
divided into two parts: memory explicitly allocated by the program, and \
\[OpenCurlyDoubleQuote]stack space\[CloseCurlyDoubleQuote]. Every time an \
internal routine is called in the program, a certain amount of stack space is \
used to store parameters associated with the call. On many computer systems, \
the maximum amount of stack space that can be used by a program must be \
specified in advance. If the specified stack space limit is exceeded, the \
program usually just exits. \
\>", "Text",
  CellTags->{"S2.14.4", "4.18"}],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica", "TI"],
  ", one of the primary uses of stack space is in handling the calling of one \
",
  StyleBox["Mathematica", "TI"],
  " function by another. All such calls are explicitly recorded in the ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["Stack", "MR"],
  " discussed in Section ",
  ButtonBox["2.6.12",
    ButtonData:>{"2.6.12", "12.1"},
    ButtonStyle->"MainBookLink"],
  ". You can control the size of this stack by setting the global parameter \
",
  StyleBox["$RecursionLimit", "MR"],
  ". You should be sure that this parameter is set small enough that you do \
not run out of stack space on your particular computer system. "
}], "Text",
  CellTags->{"S2.14.4", "4.19"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.14.5 Advanced Topic: Global System Information", "Subsection",
  CellTags->{"S2.14.5", "5.1"}],

Cell[TextData[{
  "In order to write the most general ",
  StyleBox["Mathematica", "TI"],
  " programs you will sometimes need to find out global information about the \
setup under which your program is being run. "
}], "Text",
  CellTags->{"S2.14.5", "5.2"}],

Cell[TextData[{
  "Thus, for example, to tell whether your program should be calling \
functions like ",
  StyleBox["NotebookWrite", "MR"],
  ", you need to find out whether the program is being run in a ",
  StyleBox["Mathematica", "TI"],
  " session that is using the notebook front end. You can do this by testing \
the global variable ",
  StyleBox["$Notebooks", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.14.5", "5.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$Notebooks", "MR"],
              " "
            }]], Cell["whether a notebook front end is being used "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.5"],

Cell["Determining whether a notebook front end is being used. ", "Caption",
  CellTags->"S2.14.5"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " is usually used interactively, but it can also operate in a batch mode\
\[LongDash]say taking input from a file and writing output to a file. In such \
a case, a program cannot for example expect to get interactive input from the \
user. "
}], "Text",
  CellTags->{"S2.14.5", "5.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$BatchInput", "MR"],
              " "
            }]], Cell["whether input is being given in batch mode "]},
          {Cell[TextData[{
              StyleBox["$BatchOutput", "MR"],
              " "
            }]], 
            Cell["\<\
whether output should be given in batch mode, without \
labeling, etc. \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.5"],

Cell["Variables specifying batch mode operation. ", "Caption",
  CellTags->"S2.14.5"],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " kernel is a process that runs under the operating system on your \
computer. Within ",
  StyleBox["Mathematica", "TI"],
  " there are several global variables that allow you to find the \
characteristics of this process and its environment. "
}], "Text",
  CellTags->{"S2.14.5", "5.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$CommandLine", "MR"],
              " "
            }]], Cell[TextData[{
              "the original command line used to invoke the ",
              StyleBox["Mathematica", "TI"],
              " kernel "
            }]]},
          {Cell[TextData[{
              StyleBox["$ParentLink", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["MathLink", "TI"],
              " ",
              StyleBox["LinkObject", "MR"],
              " specifying the program that invoked the kernel (or ",
              StyleBox["Null", "MR"],
              " if the kernel was invoked directly) "
            }]]},
          {Cell[TextData[{
              StyleBox["$ProcessID", "MR"],
              " "
            }]], Cell[TextData[{
              "the ID assigned to the ",
              StyleBox["Mathematica", "TI"],
              " kernel process by the operating system "
            }]]},
          {Cell[TextData[{
              StyleBox["$ParentProcessID", "MR"],
              " "
            }]], Cell[TextData[{
              "the ID of the process that invoked the ",
              StyleBox["Mathematica", "TI"],
              " kernel "
            }]]},
          {Cell[TextData[{
              StyleBox["$UserName", "MR"],
              " "
            }]], Cell[TextData[{
              "the login name of the user running the ",
              StyleBox["Mathematica", "TI"],
              " kernel "
            }]]},
          {Cell[TextData[{
              StyleBox["Environment[\"", "MR"],
              StyleBox["var", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[
            "the value of a variable defined by the operating system "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.5"],

Cell[TextData[{
  "Variables associated with the ",
  StyleBox["Mathematica", "SO"],
  " kernel process. "
}], "Caption",
  CellTags->"S2.14.5"],

Cell[TextData[{
  "If you have a variable such as ",
  StyleBox["x", "MR"],
  " in a particular ",
  StyleBox["Mathematica", "TI"],
  " session, you may or may not want that variable to be the same as an ",
  StyleBox["x", "MR"],
  " in another ",
  StyleBox["Mathematica", "TI"],
  " session. In order to make it possible to maintain distinct objects in \
different sessions, ",
  StyleBox["Mathematica", "TI"],
  " supports the variable ",
  StyleBox["$SessionID", "MR"],
  ", which uses information such as starting time, process ID and machine ID \
to try to give a different value for every single ",
  StyleBox["Mathematica", "TI"],
  " session, whether it is run on the same computer or a different one. "
}], "Text",
  CellTags->{"S2.14.5", "5.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$SessionID", "MR"],
              " "
            }]], Cell[TextData[{
              "a number set up to be different for every ",
              StyleBox["Mathematica", "TI"],
              " session "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.5"],

Cell[TextData[{
  "A unique number different for every ",
  StyleBox["Mathematica", "SO"],
  " session. "
}], "Caption",
  CellTags->"S2.14.5"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " provides various global variables that allow you to tell which version of \
the kernel you are running. This is important if you write programs that make \
use of features that are, say, new in Version 5.2. You can then check ",
  StyleBox["$VersionNumber", "MR"],
  " to find out if these features will be available. "
}], "Text",
  CellTags->{"S2.14.5", "5.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$Version", "MR"],
              " "
            }]], Cell[TextData[{
              "a string giving the complete version of ",
              StyleBox["Mathematica", "TI"],
              " in use "
            }]]},
          {Cell[TextData[{
              StyleBox["$VersionNumber", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["Mathematica", "TI"],
              " kernel version number (e.g. ",
              StyleBox["5.2", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["$ReleaseNumber", "MR"],
              " "
            }]], Cell[TextData[{
              "the release number for your version of the ",
              StyleBox["Mathematica", "TI"],
              " kernel on your particular computer system "
            }]]},
          {Cell[TextData[{
              StyleBox["$CreationDate", "MR"],
              " "
            }]], Cell[TextData[{
              "the date, in ",
              StyleBox["Date", "MR"],
              " format, on which your particular ",
              StyleBox["Mathematica", "TI"],
              " release was created "
            }]]},
          {Cell[TextData[{
              StyleBox["$InstallationDate", "MR"],
              " "
            }]], Cell[TextData[{
              "the date on which your copy of ",
              StyleBox["Mathematica", "TI"],
              " was installed "
            }]]},
          {Cell[TextData[{
              StyleBox["$ProductInformation", "MR"],
              " "
            }]], Cell["a list of detailed product information "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.5"],

Cell[TextData[{
  "Variables specifying the version of ",
  StyleBox["Mathematica", "SO"],
  " used. "
}], "Caption",
  CellTags->"S2.14.5"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " itself is set up to be as independent of the details of the particular \
computer system on which it is run as possible. However, if you want to \
access external aspects of your computer system, then you will often need to \
find out its characteristics. "
}], "Text",
  CellTags->{"S2.14.5", "5.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$System", "MR"],
              " "
            }]], Cell[
            "a full string describing the computer system in use "]},
          {Cell[TextData[{
              StyleBox["$SystemID", "MR"],
              " "
            }]], Cell[
            "a short string specifying the computer system in use "]},
          {Cell[TextData[{
              StyleBox["$ProcessorType", "MR"],
              " "
            }]], Cell[
            "the architecture of the processor in your computer system "]},
          {Cell[TextData[{
              StyleBox["$MachineType", "MR"],
              " "
            }]], Cell["the general type of your computer system "]},
          {Cell[TextData[{
              StyleBox["$ByteOrdering", "MR"],
              " "
            }]], Cell[
            "the native byte ordering convention on your computer system "]},
          {Cell[TextData[{
              StyleBox["$OperatingSystem", "MR"],
              " "
            }]], Cell["the basic operating system in use "]},
          {Cell[TextData[{
              StyleBox["$SystemCharacterEncoding", "MR"],
              " "
            }]], 
            Cell["\<\
the default raw character encoding used by your \
operating system \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.5"],

Cell["\<\
Variables specifying the characteristics of your computer system. \
\
\>", "Caption",
  CellTags->"S2.14.5"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " uses the values of ",
  StyleBox["$SystemID", "MR"],
  " to label directories that contain versions of files for different \
computer systems, as discussed in Sections\[NonBreakingSpace]",
  ButtonBox["2.12.1",
    ButtonData:>{"2.12.1", "1.37"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["2.13.5",
    ButtonData:>{"2.13.5", "5.3"},
    ButtonStyle->"MainBookLink"],
  ". Computer systems for which ",
  StyleBox["$SystemID", "MR"],
  " is the same will normally be binary compatible. "
}], "Text",
  CellTags->{"S2.14.5", "5.9"}],

Cell[TextData[{
  StyleBox["$OperatingSystem", "MR"],
  " has values such as ",
  StyleBox["\"Windows\"", "MR"],
  " or ",
  StyleBox["\"Unix\"", "MR"],
  ". By testing ",
  StyleBox["$OperatingSystem", "MR"],
  " you can determine whether a particular external program is likely to be \
available on your computer system. "
}], "Text",
  CellTags->{"S2.14.5", "5.10"}],

Cell["\<\
This gives some characteristics of the computer system used to \
generate the examples for this book. \
\>", "MathCaption",
  CellTags->{"S2.14.5", "5.11"}],

Cell[CellGroupData[{

Cell["{$System, $ProcessorType, $OperatingSystem}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.14.5"],

Cell[BoxData[
    \({"Linux", "x86", "Unix"}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.14.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$MachineName", "MR"],
              " "
            }]], Cell[TextData[{
              "the name of the computer on which ",
              StyleBox["Mathematica", "TI"],
              " is running "
            }]]},
          {Cell[TextData[{
              StyleBox["$MachineDomain", "MR"],
              " "
            }]], Cell["the network domain for the computer "]},
          {Cell[TextData[{
              StyleBox["$MachineID", "MR"],
              " "
            }]], Cell[TextData[{
              "the unique ID assigned by ",
              StyleBox["Mathematica", "TI"],
              " to the computer "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.5"],

Cell[TextData[{
  "Variables identifying the computer on which ",
  StyleBox["Mathematica", "SO"],
  " is running. "
}], "Caption",
  CellTags->"S2.14.5"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$LicenseID", "MR"],
              " "
            }]], Cell[TextData[{
              "the ID for the license under which ",
              StyleBox["Mathematica", "TI"],
              " is running "
            }]]},
          {Cell[TextData[{
              StyleBox["$LicenseExpirationDate", "MR"],
              " "
            }]], Cell["the date on which the license expires "]},
          {Cell[TextData[{
              StyleBox["$NetworkLicense", "MR"],
              " "
            }]], Cell["whether this is a network license "]},
          {Cell[TextData[{
              StyleBox["$LicenseServer", "MR"],
              " "
            }]], Cell["the full name of the machine serving the license "]},
          {Cell[TextData[{
              StyleBox["$LicenseProcesses", "MR"],
              " "
            }]], Cell[TextData[{
              "the number of ",
              StyleBox["Mathematica", "TI"],
              " processes currently being run under the license "
            }]]},
          {Cell[TextData[{
              StyleBox["$MaxLicenseProcesses", "MR"],
              " "
            }]], Cell[
            "the maximum number of processes provided by the license "]},
          {Cell[TextData[{
              StyleBox["$PasswordFile", "MR"],
              " "
            }]], Cell["password file used when the kernel was started "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.14.5"],

Cell["Variables associated with license management. ", "Caption",
  CellTags->"S2.14.5"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.14.0"->{
    Cell[1776, 53, 172, 6, 91, "Section",
      CellTags->{"S2.14.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 172, 6, 91, "Section",
      CellTags->{"S2.14.0", "0.1"}]},
  "S2.14.1"->{
    Cell[1973, 63, 74, 1, 70, "Subsection",
      CellTags->{"S2.14.1", "1.1"}],
    Cell[2050, 66, 493, 10, 70, "Text",
      CellTags->{"S2.14.1", "1.2"}],
    Cell[2546, 78, 273, 6, 70, "Text",
      CellTags->{"S2.14.1", "1.3"}],
    Cell[2822, 86, 3529, 102, 70, "DefinitionBox",
      CellTags->"S2.14.1"],
    Cell[6354, 190, 72, 1, 70, "Caption",
      CellTags->"S2.14.1"],
    Cell[6429, 193, 405, 14, 70, "Text",
      CellTags->{"S2.14.1", "1.4"}],
    Cell[6837, 209, 443, 13, 70, "Text",
      CellTags->{"S2.14.1", "1.5"}],
    Cell[7283, 224, 126, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.6"}],
    Cell[7434, 233, 70, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[7507, 237, 83, 3, 70, "Output",
      CellTags->"S2.14.1"],
    Cell[7605, 243, 128, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.7"}],
    Cell[7758, 252, 81, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[7842, 256, 88, 3, 70, "Output",
      CellTags->"S2.14.1"],
    Cell[7945, 262, 137, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.8"}],
    Cell[8085, 269, 69, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[8157, 273, 198, 6, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.9"}],
    Cell[8380, 283, 70, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[8453, 287, 102, 3, 70, "Output",
      CellTags->"S2.14.1"],
    Cell[8570, 293, 175, 4, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.10"}],
    Cell[8770, 301, 89, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[8862, 305, 97, 2, 70, "Output",
      CellTags->"S2.14.1"],
    Cell[8974, 310, 396, 11, 70, "DefinitionBox",
      CellTags->"S2.14.1"],
    Cell[9373, 323, 92, 1, 70, "Caption",
      CellTags->"S2.14.1"],
    Cell[9468, 326, 808, 26, 70, "Text",
      CellTags->{"S2.14.1", "1.11"}],
    Cell[10279, 354, 256, 7, 70, "Text",
      CellTags->{"S2.14.1", "1.12"}],
    Cell[10538, 363, 1403, 44, 70, "DefinitionBox",
      CellTags->"S2.14.1"],
    Cell[11944, 409, 82, 1, 70, "Caption",
      CellTags->"S2.14.1"],
    Cell[12029, 412, 481, 11, 70, "Text",
      CellTags->{"S2.14.1", "1.13"}],
    Cell[12513, 425, 592, 12, 70, "Text",
      CellTags->{"S2.14.1", "1.14"}],
    Cell[13108, 439, 330, 17, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.15"}],
    Cell[13463, 460, 131, 3, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[13597, 465, 139, 3, 70, "Output",
      CellTags->"S2.14.1"],
    Cell[13751, 471, 107, 1, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.16"}],
    Cell[13883, 476, 76, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[13962, 480, 91, 3, 70, "Output",
      CellTags->"S2.14.1"],
    Cell[14068, 486, 266, 7, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.17"}],
    Cell[14337, 495, 76, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[14416, 499, 863, 20, 70, "Text",
      CellTags->{"S2.14.1", "1.18"}],
    Cell[15282, 521, 171, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.19"}],
    Cell[15478, 530, 159, 5, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[15640, 537, 392, 12, 70, "Output",
      CellTags->"S2.14.1"],
    Cell[16047, 552, 93, 1, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.20"}],
    Cell[16165, 557, 73, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[16241, 561, 97, 1, 70, "Message",
      CellTags->"S2.14.1"],
    Cell[16341, 564, 204, 4, 70, "Print",
      CellTags->"S2.14.1"],
    Cell[16560, 571, 645, 18, 70, "Text",
      CellTags->{"S2.14.1", "1.21"}],
    Cell[17208, 591, 517, 16, 70, "Text",
      CellTags->{"S2.14.1", "1.22"}],
    Cell[17728, 609, 192, 7, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.23"}],
    Cell[17945, 620, 75, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[18023, 624, 84, 3, 70, "Output",
      CellTags->"S2.14.1"],
    Cell[18122, 630, 172, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.24"}],
    Cell[18319, 639, 73, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[18395, 643, 102, 3, 70, "Output",
      CellTags->"S2.14.1"],
    Cell[18512, 649, 131, 4, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.25"}],
    Cell[18646, 655, 74, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[18723, 659, 523, 15, 70, "Text",
      CellTags->{"S2.14.1", "1.26"}],
    Cell[19249, 676, 159, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.27"}],
    Cell[19411, 683, 92, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[19506, 687, 126, 4, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.28"}],
    Cell[19657, 695, 84, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[19744, 699, 249, 6, 70, "Output",
      CellTags->"S2.14.1"],
    Cell[20008, 708, 150, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.29"}],
    Cell[20161, 715, 78, 2, 70, "Input",
      CellTags->"S2.14.1"],
    Cell[20242, 719, 557, 12, 70, "Text",
      CellTags->{"S2.14.1", "1.30"}],
    Cell[20802, 733, 1709, 51, 70, "DefinitionBox",
      CellTags->"S2.14.1"],
    Cell[22514, 786, 137, 5, 70, "Caption",
      CellTags->"S2.14.1"],
    Cell[22654, 793, 454, 11, 70, "Text",
      CellTags->{"S2.14.1", "1.31"}],
    Cell[23111, 806, 790, 22, 70, "DefinitionBox",
      CellTags->"S2.14.1"],
    Cell[23904, 830, 125, 5, 70, "Caption",
      CellTags->"S2.14.1"],
    Cell[24032, 837, 561, 16, 70, "Text",
      CellTags->{"S2.14.1", "1.32"}],
    Cell[24596, 855, 580, 18, 70, "DefinitionBox",
      CellTags->"S2.14.1"],
    Cell[25179, 875, 67, 1, 70, "Caption",
      CellTags->"S2.14.1"],
    Cell[25249, 878, 194, 6, 70, "Text",
      CellTags->{"S2.14.1", "1.33"}],
    Cell[25446, 886, 563, 17, 70, "Text",
      CellTags->{"S2.14.1", "1.34"}],
    Cell[26012, 905, 469, 14, 70, "Text",
      CellTags->{"S2.14.1", "1.35"}],
    Cell[26484, 921, 817, 25, 70, "DefinitionBox",
      CellTags->"S2.14.1"],
    Cell[27304, 948, 120, 5, 70, "Caption",
      CellTags->"S2.14.1"],
    Cell[27427, 955, 388, 12, 70, "Text",
      CellTags->{"S2.14.1", "1.36"}],
    Cell[27818, 969, 408, 10, 70, "Text",
      CellTags->{"S2.14.1", "1.37"}],
    Cell[28229, 981, 405, 14, 70, "DefinitionBox",
      CellTags->"S2.14.1"],
    Cell[28637, 997, 143, 4, 70, "Caption",
      CellTags->"S2.14.1"],
    Cell[28783, 1003, 797, 23, 70, "Text",
      CellTags->{"S2.14.1", "1.38"}],
    Cell[29583, 1028, 234, 5, 70, "Text",
      CellTags->{"S2.14.1", "1.39"}],
    Cell[29820, 1035, 369, 9, 70, "Text",
      CellTags->{"S2.14.1", "1.40"}]},
  "1.1"->{
    Cell[1973, 63, 74, 1, 70, "Subsection",
      CellTags->{"S2.14.1", "1.1"}]},
  "1.2"->{
    Cell[2050, 66, 493, 10, 70, "Text",
      CellTags->{"S2.14.1", "1.2"}]},
  "1.3"->{
    Cell[2546, 78, 273, 6, 70, "Text",
      CellTags->{"S2.14.1", "1.3"}]},
  "1.4"->{
    Cell[6429, 193, 405, 14, 70, "Text",
      CellTags->{"S2.14.1", "1.4"}]},
  "1.5"->{
    Cell[6837, 209, 443, 13, 70, "Text",
      CellTags->{"S2.14.1", "1.5"}]},
  "1.6"->{
    Cell[7283, 224, 126, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.6"}]},
  "1.7"->{
    Cell[7605, 243, 128, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.7"}]},
  "1.8"->{
    Cell[7945, 262, 137, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.8"}]},
  "1.9"->{
    Cell[8157, 273, 198, 6, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.9"}]},
  "1.10"->{
    Cell[8570, 293, 175, 4, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.10"}]},
  "1.11"->{
    Cell[9468, 326, 808, 26, 70, "Text",
      CellTags->{"S2.14.1", "1.11"}]},
  "1.12"->{
    Cell[10279, 354, 256, 7, 70, "Text",
      CellTags->{"S2.14.1", "1.12"}]},
  "1.13"->{
    Cell[12029, 412, 481, 11, 70, "Text",
      CellTags->{"S2.14.1", "1.13"}]},
  "1.14"->{
    Cell[12513, 425, 592, 12, 70, "Text",
      CellTags->{"S2.14.1", "1.14"}]},
  "1.15"->{
    Cell[13108, 439, 330, 17, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.15"}]},
  "1.16"->{
    Cell[13751, 471, 107, 1, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.16"}]},
  "1.17"->{
    Cell[14068, 486, 266, 7, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.17"}]},
  "1.18"->{
    Cell[14416, 499, 863, 20, 70, "Text",
      CellTags->{"S2.14.1", "1.18"}]},
  "1.19"->{
    Cell[15282, 521, 171, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.19"}]},
  "1.20"->{
    Cell[16047, 552, 93, 1, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.20"}]},
  "1.21"->{
    Cell[16560, 571, 645, 18, 70, "Text",
      CellTags->{"S2.14.1", "1.21"}]},
  "1.22"->{
    Cell[17208, 591, 517, 16, 70, "Text",
      CellTags->{"S2.14.1", "1.22"}]},
  "1.23"->{
    Cell[17728, 609, 192, 7, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.23"}]},
  "1.24"->{
    Cell[18122, 630, 172, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.24"}]},
  "1.25"->{
    Cell[18512, 649, 131, 4, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.25"}]},
  "1.26"->{
    Cell[18723, 659, 523, 15, 70, "Text",
      CellTags->{"S2.14.1", "1.26"}]},
  "1.27"->{
    Cell[19249, 676, 159, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.27"}]},
  "1.28"->{
    Cell[19506, 687, 126, 4, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.28"}]},
  "1.29"->{
    Cell[20008, 708, 150, 5, 70, "MathCaption",
      CellTags->{"S2.14.1", "1.29"}]},
  "1.30"->{
    Cell[20242, 719, 557, 12, 70, "Text",
      CellTags->{"S2.14.1", "1.30"}]},
  "1.31"->{
    Cell[22654, 793, 454, 11, 70, "Text",
      CellTags->{"S2.14.1", "1.31"}]},
  "1.32"->{
    Cell[24032, 837, 561, 16, 70, "Text",
      CellTags->{"S2.14.1", "1.32"}]},
  "1.33"->{
    Cell[25249, 878, 194, 6, 70, "Text",
      CellTags->{"S2.14.1", "1.33"}]},
  "1.34"->{
    Cell[25446, 886, 563, 17, 70, "Text",
      CellTags->{"S2.14.1", "1.34"}]},
  "1.35"->{
    Cell[26012, 905, 469, 14, 70, "Text",
      CellTags->{"S2.14.1", "1.35"}]},
  "1.36"->{
    Cell[27427, 955, 388, 12, 70, "Text",
      CellTags->{"S2.14.1", "1.36"}]},
  "1.37"->{
    Cell[27818, 969, 408, 10, 70, "Text",
      CellTags->{"S2.14.1", "1.37"}]},
  "1.38"->{
    Cell[28783, 1003, 797, 23, 70, "Text",
      CellTags->{"S2.14.1", "1.38"}]},
  "1.39"->{
    Cell[29583, 1028, 234, 5, 70, "Text",
      CellTags->{"S2.14.1", "1.39"}]},
  "1.40"->{
    Cell[29820, 1035, 369, 9, 70, "Text",
      CellTags->{"S2.14.1", "1.40"}]},
  "S2.14.2"->{
    Cell[30226, 1049, 68, 1, 70, "Subsection",
      CellTags->{"S2.14.2", "2.1"}],
    Cell[30297, 1052, 950, 25, 70, "Text",
      CellTags->{"S2.14.2", "2.2"}],
    Cell[31250, 1079, 1545, 48, 70, "DefinitionBox",
      CellTags->"S2.14.2"],
    Cell[32798, 1129, 81, 1, 70, "Caption",
      CellTags->"S2.14.2"],
    Cell[32882, 1132, 80, 1, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.3"}],
    Cell[32965, 1135, 74, 2, 70, "Input",
      CellTags->"S2.14.2"],
    Cell[33042, 1139, 181, 5, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.4"}],
    Cell[33248, 1148, 69, 2, 70, "Input",
      CellTags->"S2.14.2"],
    Cell[33320, 1152, 95, 3, 70, "Output",
      CellTags->"S2.14.2"],
    Cell[33430, 1158, 141, 5, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.5"}],
    Cell[33596, 1167, 74, 2, 70, "Input",
      CellTags->"S2.14.2"],
    Cell[33673, 1171, 95, 3, 70, "Output",
      CellTags->"S2.14.2"],
    Cell[33783, 1177, 528, 15, 70, "Text",
      CellTags->{"S2.14.2", "2.6"}],
    Cell[34314, 1194, 160, 5, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.7"}],
    Cell[34477, 1201, 80, 2, 70, "Input",
      CellTags->"S2.14.2"],
    Cell[34560, 1205, 240, 9, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.8"}],
    Cell[34825, 1218, 78, 2, 70, "Input",
      CellTags->"S2.14.2"],
    Cell[34906, 1222, 100, 3, 70, "Output",
      CellTags->"S2.14.2"],
    Cell[35021, 1228, 499, 15, 70, "Text",
      CellTags->{"S2.14.2", "2.9"}],
    Cell[35523, 1245, 156, 5, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.10"}],
    Cell[35704, 1254, 90, 2, 70, "Input",
      CellTags->"S2.14.2"],
    Cell[35797, 1258, 86, 3, 70, "Output",
      CellTags->"S2.14.2"],
    Cell[35898, 1264, 137, 4, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.11"}],
    Cell[36060, 1272, 72, 2, 70, "Input",
      CellTags->"S2.14.2"],
    Cell[36135, 1276, 90, 3, 70, "Output",
      CellTags->"S2.14.2"],
    Cell[36240, 1282, 263, 10, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.12"}],
    Cell[36528, 1296, 74, 2, 70, "Input",
      CellTags->"S2.14.2"],
    Cell[36605, 1300, 87, 3, 70, "Output",
      CellTags->"S2.14.2"],
    Cell[36707, 1306, 201, 5, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.13"}],
    Cell[36933, 1315, 76, 2, 70, "Input",
      CellTags->"S2.14.2"],
    Cell[37012, 1319, 97, 3, 70, "Output",
      CellTags->"S2.14.2"],
    Cell[37124, 1325, 467, 9, 70, "Text",
      CellTags->{"S2.14.2", "2.14"}],
    Cell[37594, 1336, 490, 11, 70, "Text",
      CellTags->{"S2.14.2", "2.15"}],
    Cell[38087, 1349, 846, 26, 70, "Text",
      CellTags->{"S2.14.2", "2.16"}],
    Cell[38936, 1377, 689, 17, 70, "Text",
      CellTags->{"S2.14.2", "2.17"}],
    Cell[39628, 1396, 2139, 69, 70, "DefinitionBox",
      CellTags->"S2.14.2"],
    Cell[41770, 1467, 106, 5, 70, "Caption",
      CellTags->"S2.14.2"],
    Cell[41879, 1474, 463, 15, 70, "Text",
      CellTags->{"S2.14.2", "2.18"}],
    Cell[42345, 1491, 436, 11, 70, "Text",
      CellTags->{"S2.14.2", "2.19"}],
    Cell[42784, 1504, 331, 9, 70, "Text",
      CellTags->{"S2.14.2", "2.20"}]},
  "2.1"->{
    Cell[30226, 1049, 68, 1, 70, "Subsection",
      CellTags->{"S2.14.2", "2.1"}]},
  "2.2"->{
    Cell[30297, 1052, 950, 25, 70, "Text",
      CellTags->{"S2.14.2", "2.2"}]},
  "2.3"->{
    Cell[32882, 1132, 80, 1, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.3"}]},
  "2.4"->{
    Cell[33042, 1139, 181, 5, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.4"}]},
  "2.5"->{
    Cell[33430, 1158, 141, 5, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.5"}]},
  "2.6"->{
    Cell[33783, 1177, 528, 15, 70, "Text",
      CellTags->{"S2.14.2", "2.6"}]},
  "2.7"->{
    Cell[34314, 1194, 160, 5, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.7"}]},
  "2.8"->{
    Cell[34560, 1205, 240, 9, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.8"}]},
  "2.9"->{
    Cell[35021, 1228, 499, 15, 70, "Text",
      CellTags->{"S2.14.2", "2.9"}]},
  "2.10"->{
    Cell[35523, 1245, 156, 5, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.10"}]},
  "2.11"->{
    Cell[35898, 1264, 137, 4, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.11"}]},
  "2.12"->{
    Cell[36240, 1282, 263, 10, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.12"}]},
  "2.13"->{
    Cell[36707, 1306, 201, 5, 70, "MathCaption",
      CellTags->{"S2.14.2", "2.13"}]},
  "2.14"->{
    Cell[37124, 1325, 467, 9, 70, "Text",
      CellTags->{"S2.14.2", "2.14"}]},
  "2.15"->{
    Cell[37594, 1336, 490, 11, 70, "Text",
      CellTags->{"S2.14.2", "2.15"}]},
  "2.16"->{
    Cell[38087, 1349, 846, 26, 70, "Text",
      CellTags->{"S2.14.2", "2.16"}]},
  "2.17"->{
    Cell[38936, 1377, 689, 17, 70, "Text",
      CellTags->{"S2.14.2", "2.17"}]},
  "2.18"->{
    Cell[41879, 1474, 463, 15, 70, "Text",
      CellTags->{"S2.14.2", "2.18"}]},
  "2.19"->{
    Cell[42345, 1491, 436, 11, 70, "Text",
      CellTags->{"S2.14.2", "2.19"}]},
  "2.20"->{
    Cell[42784, 1504, 331, 9, 70, "Text",
      CellTags->{"S2.14.2", "2.20"}]},
  "S2.14.3"->{
    Cell[43152, 1518, 84, 1, 70, "Subsection",
      CellTags->{"S2.14.3", "3.1"}],
    Cell[43239, 1521, 1592, 49, 70, "DefinitionBox",
      CellTags->"S2.14.3"],
    Cell[44834, 1572, 69, 1, 70, "Caption",
      CellTags->"S2.14.3"],
    Cell[44906, 1575, 93, 1, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.2"}],
    Cell[45024, 1580, 72, 2, 70, "Input",
      CellTags->"S2.14.3"],
    Cell[45099, 1584, 131, 3, 70, "Output",
      CellTags->"S2.14.3"],
    Cell[45245, 1590, 439, 10, 70, "Text",
      CellTags->{"S2.14.3", "3.3"}],
    Cell[45687, 1602, 717, 17, 70, "Text",
      CellTags->{"S2.14.3", "3.4"}],
    Cell[46407, 1621, 131, 4, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.5"}],
    Cell[46563, 1629, 76, 2, 70, "Input",
      CellTags->"S2.14.3"],
    Cell[46642, 1633, 90, 3, 70, "Output",
      CellTags->"S2.14.3"],
    Cell[46747, 1639, 144, 4, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.6"}],
    Cell[46916, 1647, 72, 2, 70, "Input",
      CellTags->"S2.14.3"],
    Cell[46991, 1651, 130, 3, 70, "Output",
      CellTags->"S2.14.3"],
    Cell[47136, 1657, 1362, 43, 70, "DefinitionBox",
      CellTags->"S2.14.3"],
    Cell[48501, 1702, 58, 1, 70, "Caption",
      CellTags->"S2.14.3"],
    Cell[48562, 1705, 532, 14, 70, "Text",
      CellTags->{"S2.14.3", "3.7"}],
    Cell[49097, 1721, 509, 16, 70, "DefinitionBox",
      CellTags->"S2.14.3"],
    Cell[49609, 1739, 72, 1, 70, "Caption",
      CellTags->"S2.14.3"],
    Cell[49684, 1742, 90, 1, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.8"}],
    Cell[49799, 1747, 111, 2, 70, "Input",
      CellTags->"S2.14.3"],
    Cell[49913, 1751, 164, 4, 70, "Output",
      CellTags->"S2.14.3"],
    Cell[50092, 1758, 255, 8, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.9"}],
    Cell[50372, 1770, 122, 2, 70, "Input",
      CellTags->"S2.14.3"],
    Cell[50497, 1774, 166, 4, 70, "Output",
      CellTags->"S2.14.3"],
    Cell[50678, 1781, 651, 18, 70, "DefinitionBox",
      CellTags->"S2.14.3"],
    Cell[51332, 1801, 87, 1, 70, "Caption",
      CellTags->"S2.14.3"],
    Cell[51422, 1804, 136, 5, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.10"}],
    Cell[51583, 1813, 76, 2, 70, "Input",
      CellTags->"S2.14.3"],
    Cell[51662, 1817, 130, 3, 70, "Output",
      CellTags->"S2.14.3"],
    Cell[51807, 1823, 97, 1, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.11"}],
    Cell[51929, 1828, 93, 2, 70, "Input",
      CellTags->"S2.14.3"],
    Cell[52025, 1832, 131, 3, 70, "Output",
      CellTags->"S2.14.3"],
    Cell[52171, 1838, 116, 2, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.12"}],
    Cell[52312, 1844, 90, 2, 70, "Input",
      CellTags->"S2.14.3"],
    Cell[52405, 1848, 118, 3, 70, "Output",
      CellTags->"S2.14.3"],
    Cell[52538, 1854, 925, 28, 70, "DefinitionBox",
      CellTags->"S2.14.3"],
    Cell[53466, 1884, 117, 5, 70, "Caption",
      CellTags->"S2.14.3"],
    Cell[53586, 1891, 569, 12, 70, "Text",
      CellTags->{"S2.14.3", "3.13"}],
    Cell[54158, 1905, 351, 9, 70, "Text",
      CellTags->{"S2.14.3", "3.14"}],
    Cell[54512, 1916, 376, 8, 70, "Text",
      CellTags->{"S2.14.3", "3.15"}],
    Cell[54891, 1926, 917, 19, 70, "Text",
      CellTags->{"S2.14.3", "3.16"}],
    Cell[55811, 1947, 226, 6, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.17"}],
    Cell[56062, 1957, 81, 2, 70, "Input",
      CellTags->"S2.14.3"],
    Cell[56146, 1961, 102, 3, 70, "Output",
      CellTags->"S2.14.3"],
    Cell[56263, 1967, 219, 6, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.18"}],
    Cell[56507, 1977, 82, 2, 70, "Input",
      CellTags->"S2.14.3"],
    Cell[56592, 1981, 102, 3, 70, "Output",
      CellTags->"S2.14.3"],
    Cell[56709, 1987, 97, 1, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.19"}],
    Cell[56831, 1992, 90, 2, 70, "Input",
      CellTags->"S2.14.3"],
    Cell[56924, 1996, 125, 3, 70, "Output",
      CellTags->"S2.14.3"],
    Cell[57064, 2002, 379, 11, 70, "Text",
      CellTags->{"S2.14.3", "3.20"}],
    Cell[57446, 2015, 1220, 37, 70, "DefinitionBox",
      CellTags->"S2.14.3"],
    Cell[58669, 2054, 80, 1, 70, "Caption",
      CellTags->"S2.14.3"],
    Cell[58752, 2057, 611, 14, 70, "Text",
      CellTags->{"S2.14.3", "3.21"}],
    Cell[59366, 2073, 771, 17, 70, "Text",
      CellTags->{"S2.14.3", "3.22"}]},
  "3.1"->{
    Cell[43152, 1518, 84, 1, 70, "Subsection",
      CellTags->{"S2.14.3", "3.1"}]},
  "3.2"->{
    Cell[44906, 1575, 93, 1, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.2"}]},
  "3.3"->{
    Cell[45245, 1590, 439, 10, 70, "Text",
      CellTags->{"S2.14.3", "3.3"}]},
  "3.4"->{
    Cell[45687, 1602, 717, 17, 70, "Text",
      CellTags->{"S2.14.3", "3.4"}]},
  "3.5"->{
    Cell[46407, 1621, 131, 4, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.5"}]},
  "3.6"->{
    Cell[46747, 1639, 144, 4, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.6"}]},
  "3.7"->{
    Cell[48562, 1705, 532, 14, 70, "Text",
      CellTags->{"S2.14.3", "3.7"}]},
  "3.8"->{
    Cell[49684, 1742, 90, 1, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.8"}]},
  "3.9"->{
    Cell[50092, 1758, 255, 8, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.9"}]},
  "3.10"->{
    Cell[51422, 1804, 136, 5, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.10"}]},
  "3.11"->{
    Cell[51807, 1823, 97, 1, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.11"}]},
  "3.12"->{
    Cell[52171, 1838, 116, 2, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.12"}]},
  "3.13"->{
    Cell[53586, 1891, 569, 12, 70, "Text",
      CellTags->{"S2.14.3", "3.13"}]},
  "3.14"->{
    Cell[54158, 1905, 351, 9, 70, "Text",
      CellTags->{"S2.14.3", "3.14"}]},
  "3.15"->{
    Cell[54512, 1916, 376, 8, 70, "Text",
      CellTags->{"S2.14.3", "3.15"}]},
  "3.16"->{
    Cell[54891, 1926, 917, 19, 70, "Text",
      CellTags->{"S2.14.3", "3.16"}]},
  "3.17"->{
    Cell[55811, 1947, 226, 6, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.17"}]},
  "3.18"->{
    Cell[56263, 1967, 219, 6, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.18"}]},
  "3.19"->{
    Cell[56709, 1987, 97, 1, 70, "MathCaption",
      CellTags->{"S2.14.3", "3.19"}]},
  "3.20"->{
    Cell[57064, 2002, 379, 11, 70, "Text",
      CellTags->{"S2.14.3", "3.20"}]},
  "3.21"->{
    Cell[58752, 2057, 611, 14, 70, "Text",
      CellTags->{"S2.14.3", "3.21"}]},
  "3.22"->{
    Cell[59366, 2073, 771, 17, 70, "Text",
      CellTags->{"S2.14.3", "3.22"}]},
  "S2.14.4"->{
    Cell[60174, 2095, 78, 1, 70, "Subsection",
      CellTags->{"S2.14.4", "4.1"}],
    Cell[60255, 2098, 850, 25, 70, "DefinitionBox",
      CellTags->"S2.14.4"],
    Cell[61108, 2125, 64, 1, 70, "Caption",
      CellTags->"S2.14.4"],
    Cell[61175, 2128, 438, 8, 70, "Text",
      CellTags->{"S2.14.4", "4.2"}],
    Cell[61616, 2138, 579, 12, 70, "Text",
      CellTags->{"S2.14.4", "4.3"}],
    Cell[62198, 2152, 177, 5, 70, "MathCaption",
      CellTags->{"S2.14.4", "4.4"}],
    Cell[62400, 2161, 79, 2, 70, "Input",
      CellTags->"S2.14.4"],
    Cell[62482, 2165, 88, 3, 70, "Output",
      CellTags->"S2.14.4"],
    Cell[62585, 2171, 108, 3, 70, "MathCaption",
      CellTags->{"S2.14.4", "4.5"}],
    Cell[62718, 2178, 86, 2, 70, "Input",
      CellTags->"S2.14.4"],
    Cell[62807, 2182, 193, 4, 70, "Output",
      CellTags->"S2.14.4"],
    Cell[63015, 2189, 102, 1, 70, "MathCaption",
      CellTags->{"S2.14.4", "4.6"}],
    Cell[63142, 2194, 79, 2, 70, "Input",
      CellTags->"S2.14.4"],
    Cell[63224, 2198, 88, 3, 70, "Output",
      CellTags->"S2.14.4"],
    Cell[63327, 2204, 231, 7, 70, "MathCaption",
      CellTags->{"S2.14.4", "4.7"}],
    Cell[63561, 2213, 89, 2, 70, "Input",
      CellTags->"S2.14.4"],
    Cell[63653, 2217, 90, 1, 70, "MathCaption",
      CellTags->{"S2.14.4", "4.8"}],
    Cell[63768, 2222, 79, 2, 70, "Input",
      CellTags->"S2.14.4"],
    Cell[63850, 2226, 88, 3, 70, "Output",
      CellTags->"S2.14.4"],
    Cell[63953, 2232, 131, 4, 70, "MathCaption",
      CellTags->{"S2.14.4", "4.9"}],
    Cell[64109, 2240, 81, 2, 70, "Input",
      CellTags->"S2.14.4"],
    Cell[64193, 2244, 89, 3, 70, "Output",
      CellTags->"S2.14.4"],
    Cell[64297, 2250, 627, 12, 70, "Text",
      CellTags->{"S2.14.4", "4.10"}],
    Cell[64927, 2264, 747, 15, 70, "Text",
      CellTags->{"S2.14.4", "4.11"}],
    Cell[65677, 2281, 532, 10, 70, "Text",
      CellTags->{"S2.14.4", "4.12"}],
    Cell[66212, 2293, 1250, 37, 70, "DefinitionBox",
      CellTags->"S2.14.4"],
    Cell[67465, 2332, 90, 3, 70, "Caption",
      CellTags->"S2.14.4"],
    Cell[67558, 2337, 460, 11, 70, "Text",
      CellTags->{"S2.14.4", "4.13"}],
    Cell[68021, 2350, 889, 26, 70, "DefinitionBox",
      CellTags->"S2.14.4"],
    Cell[68913, 2378, 75, 1, 70, "Caption",
      CellTags->"S2.14.4"],
    Cell[68991, 2381, 398, 10, 70, "Text",
      CellTags->{"S2.14.4", "4.14"}],
    Cell[69392, 2393, 485, 13, 70, "Text",
      CellTags->{"S2.14.4", "4.15"}],
    Cell[69880, 2408, 795, 29, 70, "Text",
      CellTags->{"S2.14.4", "4.16"}],
    Cell[70678, 2439, 334, 8, 70, "Text",
      CellTags->{"S2.14.4", "4.17"}],
    Cell[71015, 2449, 728, 21, 70, "DefinitionBox",
      CellTags->"S2.14.4"],
    Cell[71746, 2472, 67, 1, 70, "Caption",
      CellTags->"S2.14.4"],
    Cell[71816, 2475, 612, 10, 70, "Text",
      CellTags->{"S2.14.4", "4.18"}],
    Cell[72431, 2487, 740, 20, 70, "Text",
      CellTags->{"S2.14.4", "4.19"}]},
  "4.1"->{
    Cell[60174, 2095, 78, 1, 70, "Subsection",
      CellTags->{"S2.14.4", "4.1"}]},
  "4.2"->{
    Cell[61175, 2128, 438, 8, 70, "Text",
      CellTags->{"S2.14.4", "4.2"}]},
  "4.3"->{
    Cell[61616, 2138, 579, 12, 70, "Text",
      CellTags->{"S2.14.4", "4.3"}]},
  "4.4"->{
    Cell[62198, 2152, 177, 5, 70, "MathCaption",
      CellTags->{"S2.14.4", "4.4"}]},
  "4.5"->{
    Cell[62585, 2171, 108, 3, 70, "MathCaption",
      CellTags->{"S2.14.4", "4.5"}]},
  "4.6"->{
    Cell[63015, 2189, 102, 1, 70, "MathCaption",
      CellTags->{"S2.14.4", "4.6"}]},
  "4.7"->{
    Cell[63327, 2204, 231, 7, 70, "MathCaption",
      CellTags->{"S2.14.4", "4.7"}]},
  "4.8"->{
    Cell[63653, 2217, 90, 1, 70, "MathCaption",
      CellTags->{"S2.14.4", "4.8"}]},
  "4.9"->{
    Cell[63953, 2232, 131, 4, 70, "MathCaption",
      CellTags->{"S2.14.4", "4.9"}]},
  "4.10"->{
    Cell[64297, 2250, 627, 12, 70, "Text",
      CellTags->{"S2.14.4", "4.10"}]},
  "4.11"->{
    Cell[64927, 2264, 747, 15, 70, "Text",
      CellTags->{"S2.14.4", "4.11"}]},
  "4.12"->{
    Cell[65677, 2281, 532, 10, 70, "Text",
      CellTags->{"S2.14.4", "4.12"}]},
  "4.13"->{
    Cell[67558, 2337, 460, 11, 70, "Text",
      CellTags->{"S2.14.4", "4.13"}]},
  "4.14"->{
    Cell[68991, 2381, 398, 10, 70, "Text",
      CellTags->{"S2.14.4", "4.14"}]},
  "4.15"->{
    Cell[69392, 2393, 485, 13, 70, "Text",
      CellTags->{"S2.14.4", "4.15"}]},
  "4.16"->{
    Cell[69880, 2408, 795, 29, 70, "Text",
      CellTags->{"S2.14.4", "4.16"}]},
  "4.17"->{
    Cell[70678, 2439, 334, 8, 70, "Text",
      CellTags->{"S2.14.4", "4.17"}]},
  "4.18"->{
    Cell[71816, 2475, 612, 10, 70, "Text",
      CellTags->{"S2.14.4", "4.18"}]},
  "4.19"->{
    Cell[72431, 2487, 740, 20, 70, "Text",
      CellTags->{"S2.14.4", "4.19"}]},
  "S2.14.5"->{
    Cell[73208, 2512, 102, 1, 70, "Subsection",
      CellTags->{"S2.14.5", "5.1"}],
    Cell[73313, 2515, 260, 6, 70, "Text",
      CellTags->{"S2.14.5", "5.2"}],
    Cell[73576, 2523, 424, 11, 70, "Text",
      CellTags->{"S2.14.5", "5.3"}],
    Cell[74003, 2536, 365, 10, 70, "DefinitionBox",
      CellTags->"S2.14.5"],
    Cell[74371, 2548, 98, 1, 70, "Caption",
      CellTags->"S2.14.5"],
    Cell[74472, 2551, 336, 7, 70, "Text",
      CellTags->{"S2.14.5", "5.4"}],
    Cell[74811, 2560, 577, 18, 70, "DefinitionBox",
      CellTags->"S2.14.5"],
    Cell[75391, 2580, 85, 1, 70, "Caption",
      CellTags->"S2.14.5"],
    Cell[75479, 2583, 349, 9, 70, "Text",
      CellTags->{"S2.14.5", "5.5"}],
    Cell[75831, 2594, 1996, 57, 70, "DefinitionBox",
      CellTags->"S2.14.5"],
    Cell[77830, 2653, 144, 5, 70, "Caption",
      CellTags->"S2.14.5"],
    Cell[77977, 2660, 756, 19, 70, "Text",
      CellTags->{"S2.14.5", "5.6"}],
    Cell[78736, 2681, 476, 14, 70, "DefinitionBox",
      CellTags->"S2.14.5"],
    Cell[79215, 2697, 143, 5, 70, "Caption",
      CellTags->"S2.14.5"],
    Cell[79361, 2704, 416, 8, 70, "Text",
      CellTags->{"S2.14.5", "5.7"}],
    Cell[79780, 2714, 1880, 54, 70, "DefinitionBox",
      CellTags->"S2.14.5"],
    Cell[81663, 2770, 140, 5, 70, "Caption",
      CellTags->"S2.14.5"],
    Cell[81806, 2777, 354, 7, 70, "Text",
      CellTags->{"S2.14.5", "5.8"}],
    Cell[82163, 2786, 1487, 42, 262, "DefinitionBox",
      CellTags->"S2.14.5"],
    Cell[83653, 2830, 118, 4, 70, "Caption",
      CellTags->"S2.14.5"],
    Cell[83774, 2836, 617, 17, 72, "Text",
      CellTags->{"S2.14.5", "5.9"}],
    Cell[84394, 2855, 369, 11, 56, "Text",
      CellTags->{"S2.14.5", "5.10"}],
    Cell[84766, 2868, 166, 4, 56, "MathCaption",
      CellTags->{"S2.14.5", "5.11"}],
    Cell[84957, 2876, 108, 2, 28, "Input",
      CellTags->"S2.14.5"],
    Cell[85068, 2880, 106, 3, 25, "Output",
      CellTags->"S2.14.5"],
    Cell[85189, 2886, 893, 26, 124, "DefinitionBox",
      CellTags->"S2.14.5"],
    Cell[86085, 2914, 154, 5, 16, "Caption",
      CellTags->"S2.14.5"],
    Cell[86242, 2921, 1618, 43, 226, "DefinitionBox",
      CellTags->"S2.14.5"],
    Cell[87863, 2966, 88, 1, 16, "Caption",
      CellTags->"S2.14.5"]},
  "5.1"->{
    Cell[73208, 2512, 102, 1, 70, "Subsection",
      CellTags->{"S2.14.5", "5.1"}]},
  "5.2"->{
    Cell[73313, 2515, 260, 6, 70, "Text",
      CellTags->{"S2.14.5", "5.2"}]},
  "5.3"->{
    Cell[73576, 2523, 424, 11, 70, "Text",
      CellTags->{"S2.14.5", "5.3"}]},
  "5.4"->{
    Cell[74472, 2551, 336, 7, 70, "Text",
      CellTags->{"S2.14.5", "5.4"}]},
  "5.5"->{
    Cell[75479, 2583, 349, 9, 70, "Text",
      CellTags->{"S2.14.5", "5.5"}]},
  "5.6"->{
    Cell[77977, 2660, 756, 19, 70, "Text",
      CellTags->{"S2.14.5", "5.6"}]},
  "5.7"->{
    Cell[79361, 2704, 416, 8, 70, "Text",
      CellTags->{"S2.14.5", "5.7"}]},
  "5.8"->{
    Cell[81806, 2777, 354, 7, 70, "Text",
      CellTags->{"S2.14.5", "5.8"}]},
  "5.9"->{
    Cell[83774, 2836, 617, 17, 72, "Text",
      CellTags->{"S2.14.5", "5.9"}]},
  "5.10"->{
    Cell[84394, 2855, 369, 11, 56, "Text",
      CellTags->{"S2.14.5", "5.10"}]},
  "5.11"->{
    Cell[84766, 2868, 166, 4, 56, "MathCaption",
      CellTags->{"S2.14.5", "5.11"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.14.0", 88595, 2987},
  {"0.1", 88686, 2990},
  {"S2.14.1", 88781, 2993},
  {"1.1", 95215, 3162},
  {"1.2", 95308, 3165},
  {"1.3", 95397, 3168},
  {"1.4", 95485, 3171},
  {"1.5", 95575, 3174},
  {"1.6", 95665, 3177},
  {"1.7", 95761, 3180},
  {"1.8", 95857, 3183},
  {"1.9", 95953, 3186},
  {"1.10", 96050, 3189},
  {"1.11", 96148, 3192},
  {"1.12", 96240, 3195},
  {"1.13", 96332, 3198},
  {"1.14", 96425, 3201},
  {"1.15", 96518, 3204},
  {"1.16", 96618, 3207},
  {"1.17", 96717, 3210},
  {"1.18", 96816, 3213},
  {"1.19", 96909, 3216},
  {"1.20", 97008, 3219},
  {"1.21", 97106, 3222},
  {"1.22", 97199, 3225},
  {"1.23", 97292, 3228},
  {"1.24", 97391, 3231},
  {"1.25", 97490, 3234},
  {"1.26", 97589, 3237},
  {"1.27", 97682, 3240},
  {"1.28", 97781, 3243},
  {"1.29", 97880, 3246},
  {"1.30", 97979, 3249},
  {"1.31", 98072, 3252},
  {"1.32", 98165, 3255},
  {"1.33", 98258, 3258},
  {"1.34", 98350, 3261},
  {"1.35", 98443, 3264},
  {"1.36", 98536, 3267},
  {"1.37", 98629, 3270},
  {"1.38", 98722, 3273},
  {"1.39", 98816, 3276},
  {"1.40", 98909, 3279},
  {"S2.14.2", 99005, 3282},
  {"2.1", 102119, 3363},
  {"2.2", 102215, 3366},
  {"2.3", 102307, 3369},
  {"2.4", 102404, 3372},
  {"2.5", 102502, 3375},
  {"2.6", 102600, 3378},
  {"2.7", 102692, 3381},
  {"2.8", 102790, 3384},
  {"2.9", 102888, 3387},
  {"2.10", 102981, 3390},
  {"2.11", 103081, 3393},
  {"2.12", 103181, 3396},
  {"2.13", 103282, 3399},
  {"2.14", 103382, 3402},
  {"2.15", 103475, 3405},
  {"2.16", 103569, 3408},
  {"2.17", 103663, 3411},
  {"2.18", 103757, 3414},
  {"2.19", 103851, 3417},
  {"2.20", 103945, 3420},
  {"S2.14.3", 104041, 3423},
  {"3.1", 108369, 3536},
  {"3.2", 108465, 3539},
  {"3.3", 108562, 3542},
  {"3.4", 108654, 3545},
  {"3.5", 108746, 3548},
  {"3.6", 108844, 3551},
  {"3.7", 108942, 3554},
  {"3.8", 109034, 3557},
  {"3.9", 109131, 3560},
  {"3.10", 109230, 3563},
  {"3.11", 109330, 3566},
  {"3.12", 109429, 3569},
  {"3.13", 109529, 3572},
  {"3.14", 109623, 3575},
  {"3.15", 109716, 3578},
  {"3.16", 109809, 3581},
  {"3.17", 109903, 3584},
  {"3.18", 110003, 3587},
  {"3.19", 110103, 3590},
  {"3.20", 110202, 3593},
  {"3.21", 110296, 3596},
  {"3.22", 110390, 3599},
  {"S2.14.4", 110487, 3602},
  {"4.1", 113451, 3679},
  {"4.2", 113547, 3682},
  {"4.3", 113638, 3685},
  {"4.4", 113730, 3688},
  {"4.5", 113828, 3691},
  {"4.6", 113926, 3694},
  {"4.7", 114024, 3697},
  {"4.8", 114122, 3700},
  {"4.9", 114219, 3703},
  {"4.10", 114318, 3706},
  {"4.11", 114412, 3709},
  {"4.12", 114506, 3712},
  {"4.13", 114600, 3715},
  {"4.14", 114694, 3718},
  {"4.15", 114788, 3721},
  {"4.16", 114882, 3724},
  {"4.17", 114976, 3727},
  {"4.18", 115069, 3730},
  {"4.19", 115163, 3733},
  {"S2.14.5", 115260, 3736},
  {"5.1", 117531, 3795},
  {"5.2", 117628, 3798},
  {"5.3", 117719, 3801},
  {"5.4", 117811, 3804},
  {"5.5", 117902, 3807},
  {"5.6", 117993, 3810},
  {"5.7", 118085, 3813},
  {"5.8", 118176, 3816},
  {"5.9", 118267, 3819},
  {"5.10", 118360, 3822},
  {"5.11", 118454, 3825}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 172, 6, 91, "Section",
  CellTags->{"S2.14.0", "0.1"}],

Cell[CellGroupData[{
Cell[1973, 63, 74, 1, 70, "Subsection",
  CellTags->{"S2.14.1", "1.1"}],
Cell[2050, 66, 493, 10, 70, "Text",
  CellTags->{"S2.14.1", "1.2"}],
Cell[2546, 78, 273, 6, 70, "Text",
  CellTags->{"S2.14.1", "1.3"}],
Cell[2822, 86, 3529, 102, 70, "DefinitionBox",
  CellTags->"S2.14.1"],
Cell[6354, 190, 72, 1, 70, "Caption",
  CellTags->"S2.14.1"],
Cell[6429, 193, 405, 14, 70, "Text",
  CellTags->{"S2.14.1", "1.4"}],
Cell[6837, 209, 443, 13, 70, "Text",
  CellTags->{"S2.14.1", "1.5"}],
Cell[7283, 224, 126, 5, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.6"}],

Cell[CellGroupData[{
Cell[7434, 233, 70, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[7507, 237, 83, 3, 70, "Output",
  CellTags->"S2.14.1"]
}, Open  ]],
Cell[7605, 243, 128, 5, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.7"}],

Cell[CellGroupData[{
Cell[7758, 252, 81, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[7842, 256, 88, 3, 70, "Output",
  CellTags->"S2.14.1"]
}, Open  ]],
Cell[7945, 262, 137, 5, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.8"}],
Cell[8085, 269, 69, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[8157, 273, 198, 6, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.9"}],

Cell[CellGroupData[{
Cell[8380, 283, 70, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[8453, 287, 102, 3, 70, "Output",
  CellTags->"S2.14.1"]
}, Open  ]],
Cell[8570, 293, 175, 4, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.10"}],

Cell[CellGroupData[{
Cell[8770, 301, 89, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[8862, 305, 97, 2, 70, "Output",
  CellTags->"S2.14.1"]
}, Open  ]],
Cell[8974, 310, 396, 11, 70, "DefinitionBox",
  CellTags->"S2.14.1"],
Cell[9373, 323, 92, 1, 70, "Caption",
  CellTags->"S2.14.1"],
Cell[9468, 326, 808, 26, 70, "Text",
  CellTags->{"S2.14.1", "1.11"}],
Cell[10279, 354, 256, 7, 70, "Text",
  CellTags->{"S2.14.1", "1.12"}],
Cell[10538, 363, 1403, 44, 70, "DefinitionBox",
  CellTags->"S2.14.1"],
Cell[11944, 409, 82, 1, 70, "Caption",
  CellTags->"S2.14.1"],
Cell[12029, 412, 481, 11, 70, "Text",
  CellTags->{"S2.14.1", "1.13"}],
Cell[12513, 425, 592, 12, 70, "Text",
  CellTags->{"S2.14.1", "1.14"}],
Cell[13108, 439, 330, 17, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.15"}],

Cell[CellGroupData[{
Cell[13463, 460, 131, 3, 70, "Input",
  CellTags->"S2.14.1"],
Cell[13597, 465, 139, 3, 70, "Output",
  CellTags->"S2.14.1"]
}, Open  ]],
Cell[13751, 471, 107, 1, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.16"}],

Cell[CellGroupData[{
Cell[13883, 476, 76, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[13962, 480, 91, 3, 70, "Output",
  CellTags->"S2.14.1"]
}, Open  ]],
Cell[14068, 486, 266, 7, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.17"}],
Cell[14337, 495, 76, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[14416, 499, 863, 20, 70, "Text",
  CellTags->{"S2.14.1", "1.18"}],
Cell[15282, 521, 171, 5, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.19"}],

Cell[CellGroupData[{
Cell[15478, 530, 159, 5, 70, "Input",
  CellTags->"S2.14.1"],
Cell[15640, 537, 392, 12, 70, "Output",
  CellTags->"S2.14.1"]
}, Open  ]],
Cell[16047, 552, 93, 1, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.20"}],

Cell[CellGroupData[{
Cell[16165, 557, 73, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[16241, 561, 97, 1, 70, "Message",
  CellTags->"S2.14.1"],
Cell[16341, 564, 204, 4, 70, "Print",
  CellTags->"S2.14.1"]
}, Open  ]],
Cell[16560, 571, 645, 18, 70, "Text",
  CellTags->{"S2.14.1", "1.21"}],
Cell[17208, 591, 517, 16, 70, "Text",
  CellTags->{"S2.14.1", "1.22"}],
Cell[17728, 609, 192, 7, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.23"}],

Cell[CellGroupData[{
Cell[17945, 620, 75, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[18023, 624, 84, 3, 70, "Output",
  CellTags->"S2.14.1"]
}, Open  ]],
Cell[18122, 630, 172, 5, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.24"}],

Cell[CellGroupData[{
Cell[18319, 639, 73, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[18395, 643, 102, 3, 70, "Output",
  CellTags->"S2.14.1"]
}, Open  ]],
Cell[18512, 649, 131, 4, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.25"}],
Cell[18646, 655, 74, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[18723, 659, 523, 15, 70, "Text",
  CellTags->{"S2.14.1", "1.26"}],
Cell[19249, 676, 159, 5, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.27"}],
Cell[19411, 683, 92, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[19506, 687, 126, 4, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.28"}],

Cell[CellGroupData[{
Cell[19657, 695, 84, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[19744, 699, 249, 6, 70, "Output",
  CellTags->"S2.14.1"]
}, Open  ]],
Cell[20008, 708, 150, 5, 70, "MathCaption",
  CellTags->{"S2.14.1", "1.29"}],
Cell[20161, 715, 78, 2, 70, "Input",
  CellTags->"S2.14.1"],
Cell[20242, 719, 557, 12, 70, "Text",
  CellTags->{"S2.14.1", "1.30"}],
Cell[20802, 733, 1709, 51, 70, "DefinitionBox",
  CellTags->"S2.14.1"],
Cell[22514, 786, 137, 5, 70, "Caption",
  CellTags->"S2.14.1"],
Cell[22654, 793, 454, 11, 70, "Text",
  CellTags->{"S2.14.1", "1.31"}],
Cell[23111, 806, 790, 22, 70, "DefinitionBox",
  CellTags->"S2.14.1"],
Cell[23904, 830, 125, 5, 70, "Caption",
  CellTags->"S2.14.1"],
Cell[24032, 837, 561, 16, 70, "Text",
  CellTags->{"S2.14.1", "1.32"}],
Cell[24596, 855, 580, 18, 70, "DefinitionBox",
  CellTags->"S2.14.1"],
Cell[25179, 875, 67, 1, 70, "Caption",
  CellTags->"S2.14.1"],
Cell[25249, 878, 194, 6, 70, "Text",
  CellTags->{"S2.14.1", "1.33"}],
Cell[25446, 886, 563, 17, 70, "Text",
  CellTags->{"S2.14.1", "1.34"}],
Cell[26012, 905, 469, 14, 70, "Text",
  CellTags->{"S2.14.1", "1.35"}],
Cell[26484, 921, 817, 25, 70, "DefinitionBox",
  CellTags->"S2.14.1"],
Cell[27304, 948, 120, 5, 70, "Caption",
  CellTags->"S2.14.1"],
Cell[27427, 955, 388, 12, 70, "Text",
  CellTags->{"S2.14.1", "1.36"}],
Cell[27818, 969, 408, 10, 70, "Text",
  CellTags->{"S2.14.1", "1.37"}],
Cell[28229, 981, 405, 14, 70, "DefinitionBox",
  CellTags->"S2.14.1"],
Cell[28637, 997, 143, 4, 70, "Caption",
  CellTags->"S2.14.1"],
Cell[28783, 1003, 797, 23, 70, "Text",
  CellTags->{"S2.14.1", "1.38"}],
Cell[29583, 1028, 234, 5, 70, "Text",
  CellTags->{"S2.14.1", "1.39"}],
Cell[29820, 1035, 369, 9, 70, "Text",
  CellTags->{"S2.14.1", "1.40"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[30226, 1049, 68, 1, 70, "Subsection",
  CellTags->{"S2.14.2", "2.1"}],
Cell[30297, 1052, 950, 25, 70, "Text",
  CellTags->{"S2.14.2", "2.2"}],
Cell[31250, 1079, 1545, 48, 70, "DefinitionBox",
  CellTags->"S2.14.2"],
Cell[32798, 1129, 81, 1, 70, "Caption",
  CellTags->"S2.14.2"],
Cell[32882, 1132, 80, 1, 70, "MathCaption",
  CellTags->{"S2.14.2", "2.3"}],
Cell[32965, 1135, 74, 2, 70, "Input",
  CellTags->"S2.14.2"],
Cell[33042, 1139, 181, 5, 70, "MathCaption",
  CellTags->{"S2.14.2", "2.4"}],

Cell[CellGroupData[{
Cell[33248, 1148, 69, 2, 70, "Input",
  CellTags->"S2.14.2"],
Cell[33320, 1152, 95, 3, 70, "Output",
  CellTags->"S2.14.2"]
}, Open  ]],
Cell[33430, 1158, 141, 5, 70, "MathCaption",
  CellTags->{"S2.14.2", "2.5"}],

Cell[CellGroupData[{
Cell[33596, 1167, 74, 2, 70, "Input",
  CellTags->"S2.14.2"],
Cell[33673, 1171, 95, 3, 70, "Output",
  CellTags->"S2.14.2"]
}, Open  ]],
Cell[33783, 1177, 528, 15, 70, "Text",
  CellTags->{"S2.14.2", "2.6"}],
Cell[34314, 1194, 160, 5, 70, "MathCaption",
  CellTags->{"S2.14.2", "2.7"}],
Cell[34477, 1201, 80, 2, 70, "Input",
  CellTags->"S2.14.2"],
Cell[34560, 1205, 240, 9, 70, "MathCaption",
  CellTags->{"S2.14.2", "2.8"}],

Cell[CellGroupData[{
Cell[34825, 1218, 78, 2, 70, "Input",
  CellTags->"S2.14.2"],
Cell[34906, 1222, 100, 3, 70, "Output",
  CellTags->"S2.14.2"]
}, Open  ]],
Cell[35021, 1228, 499, 15, 70, "Text",
  CellTags->{"S2.14.2", "2.9"}],
Cell[35523, 1245, 156, 5, 70, "MathCaption",
  CellTags->{"S2.14.2", "2.10"}],

Cell[CellGroupData[{
Cell[35704, 1254, 90, 2, 70, "Input",
  CellTags->"S2.14.2"],
Cell[35797, 1258, 86, 3, 70, "Output",
  CellTags->"S2.14.2"]
}, Open  ]],
Cell[35898, 1264, 137, 4, 70, "MathCaption",
  CellTags->{"S2.14.2", "2.11"}],

Cell[CellGroupData[{
Cell[36060, 1272, 72, 2, 70, "Input",
  CellTags->"S2.14.2"],
Cell[36135, 1276, 90, 3, 70, "Output",
  CellTags->"S2.14.2"]
}, Open  ]],
Cell[36240, 1282, 263, 10, 70, "MathCaption",
  CellTags->{"S2.14.2", "2.12"}],

Cell[CellGroupData[{
Cell[36528, 1296, 74, 2, 70, "Input",
  CellTags->"S2.14.2"],
Cell[36605, 1300, 87, 3, 70, "Output",
  CellTags->"S2.14.2"]
}, Open  ]],
Cell[36707, 1306, 201, 5, 70, "MathCaption",
  CellTags->{"S2.14.2", "2.13"}],

Cell[CellGroupData[{
Cell[36933, 1315, 76, 2, 70, "Input",
  CellTags->"S2.14.2"],
Cell[37012, 1319, 97, 3, 70, "Output",
  CellTags->"S2.14.2"]
}, Open  ]],
Cell[37124, 1325, 467, 9, 70, "Text",
  CellTags->{"S2.14.2", "2.14"}],
Cell[37594, 1336, 490, 11, 70, "Text",
  CellTags->{"S2.14.2", "2.15"}],
Cell[38087, 1349, 846, 26, 70, "Text",
  CellTags->{"S2.14.2", "2.16"}],
Cell[38936, 1377, 689, 17, 70, "Text",
  CellTags->{"S2.14.2", "2.17"}],
Cell[39628, 1396, 2139, 69, 70, "DefinitionBox",
  CellTags->"S2.14.2"],
Cell[41770, 1467, 106, 5, 70, "Caption",
  CellTags->"S2.14.2"],
Cell[41879, 1474, 463, 15, 70, "Text",
  CellTags->{"S2.14.2", "2.18"}],
Cell[42345, 1491, 436, 11, 70, "Text",
  CellTags->{"S2.14.2", "2.19"}],
Cell[42784, 1504, 331, 9, 70, "Text",
  CellTags->{"S2.14.2", "2.20"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[43152, 1518, 84, 1, 70, "Subsection",
  CellTags->{"S2.14.3", "3.1"}],
Cell[43239, 1521, 1592, 49, 70, "DefinitionBox",
  CellTags->"S2.14.3"],
Cell[44834, 1572, 69, 1, 70, "Caption",
  CellTags->"S2.14.3"],
Cell[44906, 1575, 93, 1, 70, "MathCaption",
  CellTags->{"S2.14.3", "3.2"}],

Cell[CellGroupData[{
Cell[45024, 1580, 72, 2, 70, "Input",
  CellTags->"S2.14.3"],
Cell[45099, 1584, 131, 3, 70, "Output",
  CellTags->"S2.14.3"]
}, Open  ]],
Cell[45245, 1590, 439, 10, 70, "Text",
  CellTags->{"S2.14.3", "3.3"}],
Cell[45687, 1602, 717, 17, 70, "Text",
  CellTags->{"S2.14.3", "3.4"}],
Cell[46407, 1621, 131, 4, 70, "MathCaption",
  CellTags->{"S2.14.3", "3.5"}],

Cell[CellGroupData[{
Cell[46563, 1629, 76, 2, 70, "Input",
  CellTags->"S2.14.3"],
Cell[46642, 1633, 90, 3, 70, "Output",
  CellTags->"S2.14.3"]
}, Open  ]],
Cell[46747, 1639, 144, 4, 70, "MathCaption",
  CellTags->{"S2.14.3", "3.6"}],

Cell[CellGroupData[{
Cell[46916, 1647, 72, 2, 70, "Input",
  CellTags->"S2.14.3"],
Cell[46991, 1651, 130, 3, 70, "Output",
  CellTags->"S2.14.3"]
}, Open  ]],
Cell[47136, 1657, 1362, 43, 70, "DefinitionBox",
  CellTags->"S2.14.3"],
Cell[48501, 1702, 58, 1, 70, "Caption",
  CellTags->"S2.14.3"],
Cell[48562, 1705, 532, 14, 70, "Text",
  CellTags->{"S2.14.3", "3.7"}],
Cell[49097, 1721, 509, 16, 70, "DefinitionBox",
  CellTags->"S2.14.3"],
Cell[49609, 1739, 72, 1, 70, "Caption",
  CellTags->"S2.14.3"],
Cell[49684, 1742, 90, 1, 70, "MathCaption",
  CellTags->{"S2.14.3", "3.8"}],

Cell[CellGroupData[{
Cell[49799, 1747, 111, 2, 70, "Input",
  CellTags->"S2.14.3"],
Cell[49913, 1751, 164, 4, 70, "Output",
  CellTags->"S2.14.3"]
}, Open  ]],
Cell[50092, 1758, 255, 8, 70, "MathCaption",
  CellTags->{"S2.14.3", "3.9"}],

Cell[CellGroupData[{
Cell[50372, 1770, 122, 2, 70, "Input",
  CellTags->"S2.14.3"],
Cell[50497, 1774, 166, 4, 70, "Output",
  CellTags->"S2.14.3"]
}, Open  ]],
Cell[50678, 1781, 651, 18, 70, "DefinitionBox",
  CellTags->"S2.14.3"],
Cell[51332, 1801, 87, 1, 70, "Caption",
  CellTags->"S2.14.3"],
Cell[51422, 1804, 136, 5, 70, "MathCaption",
  CellTags->{"S2.14.3", "3.10"}],

Cell[CellGroupData[{
Cell[51583, 1813, 76, 2, 70, "Input",
  CellTags->"S2.14.3"],
Cell[51662, 1817, 130, 3, 70, "Output",
  CellTags->"S2.14.3"]
}, Open  ]],
Cell[51807, 1823, 97, 1, 70, "MathCaption",
  CellTags->{"S2.14.3", "3.11"}],

Cell[CellGroupData[{
Cell[51929, 1828, 93, 2, 70, "Input",
  CellTags->"S2.14.3"],
Cell[52025, 1832, 131, 3, 70, "Output",
  CellTags->"S2.14.3"]
}, Open  ]],
Cell[52171, 1838, 116, 2, 70, "MathCaption",
  CellTags->{"S2.14.3", "3.12"}],

Cell[CellGroupData[{
Cell[52312, 1844, 90, 2, 70, "Input",
  CellTags->"S2.14.3"],
Cell[52405, 1848, 118, 3, 70, "Output",
  CellTags->"S2.14.3"]
}, Open  ]],
Cell[52538, 1854, 925, 28, 70, "DefinitionBox",
  CellTags->"S2.14.3"],
Cell[53466, 1884, 117, 5, 70, "Caption",
  CellTags->"S2.14.3"],
Cell[53586, 1891, 569, 12, 70, "Text",
  CellTags->{"S2.14.3", "3.13"}],
Cell[54158, 1905, 351, 9, 70, "Text",
  CellTags->{"S2.14.3", "3.14"}],
Cell[54512, 1916, 376, 8, 70, "Text",
  CellTags->{"S2.14.3", "3.15"}],
Cell[54891, 1926, 917, 19, 70, "Text",
  CellTags->{"S2.14.3", "3.16"}],
Cell[55811, 1947, 226, 6, 70, "MathCaption",
  CellTags->{"S2.14.3", "3.17"}],

Cell[CellGroupData[{
Cell[56062, 1957, 81, 2, 70, "Input",
  CellTags->"S2.14.3"],
Cell[56146, 1961, 102, 3, 70, "Output",
  CellTags->"S2.14.3"]
}, Open  ]],
Cell[56263, 1967, 219, 6, 70, "MathCaption",
  CellTags->{"S2.14.3", "3.18"}],

Cell[CellGroupData[{
Cell[56507, 1977, 82, 2, 70, "Input",
  CellTags->"S2.14.3"],
Cell[56592, 1981, 102, 3, 70, "Output",
  CellTags->"S2.14.3"]
}, Open  ]],
Cell[56709, 1987, 97, 1, 70, "MathCaption",
  CellTags->{"S2.14.3", "3.19"}],

Cell[CellGroupData[{
Cell[56831, 1992, 90, 2, 70, "Input",
  CellTags->"S2.14.3"],
Cell[56924, 1996, 125, 3, 70, "Output",
  CellTags->"S2.14.3"]
}, Open  ]],
Cell[57064, 2002, 379, 11, 70, "Text",
  CellTags->{"S2.14.3", "3.20"}],
Cell[57446, 2015, 1220, 37, 70, "DefinitionBox",
  CellTags->"S2.14.3"],
Cell[58669, 2054, 80, 1, 70, "Caption",
  CellTags->"S2.14.3"],
Cell[58752, 2057, 611, 14, 70, "Text",
  CellTags->{"S2.14.3", "3.21"}],
Cell[59366, 2073, 771, 17, 70, "Text",
  CellTags->{"S2.14.3", "3.22"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[60174, 2095, 78, 1, 70, "Subsection",
  CellTags->{"S2.14.4", "4.1"}],
Cell[60255, 2098, 850, 25, 70, "DefinitionBox",
  CellTags->"S2.14.4"],
Cell[61108, 2125, 64, 1, 70, "Caption",
  CellTags->"S2.14.4"],
Cell[61175, 2128, 438, 8, 70, "Text",
  CellTags->{"S2.14.4", "4.2"}],
Cell[61616, 2138, 579, 12, 70, "Text",
  CellTags->{"S2.14.4", "4.3"}],
Cell[62198, 2152, 177, 5, 70, "MathCaption",
  CellTags->{"S2.14.4", "4.4"}],

Cell[CellGroupData[{
Cell[62400, 2161, 79, 2, 70, "Input",
  CellTags->"S2.14.4"],
Cell[62482, 2165, 88, 3, 70, "Output",
  CellTags->"S2.14.4"]
}, Open  ]],
Cell[62585, 2171, 108, 3, 70, "MathCaption",
  CellTags->{"S2.14.4", "4.5"}],

Cell[CellGroupData[{
Cell[62718, 2178, 86, 2, 70, "Input",
  CellTags->"S2.14.4"],
Cell[62807, 2182, 193, 4, 70, "Output",
  CellTags->"S2.14.4"]
}, Open  ]],
Cell[63015, 2189, 102, 1, 70, "MathCaption",
  CellTags->{"S2.14.4", "4.6"}],

Cell[CellGroupData[{
Cell[63142, 2194, 79, 2, 70, "Input",
  CellTags->"S2.14.4"],
Cell[63224, 2198, 88, 3, 70, "Output",
  CellTags->"S2.14.4"]
}, Open  ]],
Cell[63327, 2204, 231, 7, 70, "MathCaption",
  CellTags->{"S2.14.4", "4.7"}],
Cell[63561, 2213, 89, 2, 70, "Input",
  CellTags->"S2.14.4"],
Cell[63653, 2217, 90, 1, 70, "MathCaption",
  CellTags->{"S2.14.4", "4.8"}],

Cell[CellGroupData[{
Cell[63768, 2222, 79, 2, 70, "Input",
  CellTags->"S2.14.4"],
Cell[63850, 2226, 88, 3, 70, "Output",
  CellTags->"S2.14.4"]
}, Open  ]],
Cell[63953, 2232, 131, 4, 70, "MathCaption",
  CellTags->{"S2.14.4", "4.9"}],

Cell[CellGroupData[{
Cell[64109, 2240, 81, 2, 70, "Input",
  CellTags->"S2.14.4"],
Cell[64193, 2244, 89, 3, 70, "Output",
  CellTags->"S2.14.4"]
}, Open  ]],
Cell[64297, 2250, 627, 12, 70, "Text",
  CellTags->{"S2.14.4", "4.10"}],
Cell[64927, 2264, 747, 15, 70, "Text",
  CellTags->{"S2.14.4", "4.11"}],
Cell[65677, 2281, 532, 10, 70, "Text",
  CellTags->{"S2.14.4", "4.12"}],
Cell[66212, 2293, 1250, 37, 70, "DefinitionBox",
  CellTags->"S2.14.4"],
Cell[67465, 2332, 90, 3, 70, "Caption",
  CellTags->"S2.14.4"],
Cell[67558, 2337, 460, 11, 70, "Text",
  CellTags->{"S2.14.4", "4.13"}],
Cell[68021, 2350, 889, 26, 70, "DefinitionBox",
  CellTags->"S2.14.4"],
Cell[68913, 2378, 75, 1, 70, "Caption",
  CellTags->"S2.14.4"],
Cell[68991, 2381, 398, 10, 70, "Text",
  CellTags->{"S2.14.4", "4.14"}],
Cell[69392, 2393, 485, 13, 70, "Text",
  CellTags->{"S2.14.4", "4.15"}],
Cell[69880, 2408, 795, 29, 70, "Text",
  CellTags->{"S2.14.4", "4.16"}],
Cell[70678, 2439, 334, 8, 70, "Text",
  CellTags->{"S2.14.4", "4.17"}],
Cell[71015, 2449, 728, 21, 70, "DefinitionBox",
  CellTags->"S2.14.4"],
Cell[71746, 2472, 67, 1, 70, "Caption",
  CellTags->"S2.14.4"],
Cell[71816, 2475, 612, 10, 70, "Text",
  CellTags->{"S2.14.4", "4.18"}],
Cell[72431, 2487, 740, 20, 70, "Text",
  CellTags->{"S2.14.4", "4.19"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[73208, 2512, 102, 1, 70, "Subsection",
  CellTags->{"S2.14.5", "5.1"}],
Cell[73313, 2515, 260, 6, 70, "Text",
  CellTags->{"S2.14.5", "5.2"}],
Cell[73576, 2523, 424, 11, 70, "Text",
  CellTags->{"S2.14.5", "5.3"}],
Cell[74003, 2536, 365, 10, 70, "DefinitionBox",
  CellTags->"S2.14.5"],
Cell[74371, 2548, 98, 1, 70, "Caption",
  CellTags->"S2.14.5"],
Cell[74472, 2551, 336, 7, 70, "Text",
  CellTags->{"S2.14.5", "5.4"}],
Cell[74811, 2560, 577, 18, 70, "DefinitionBox",
  CellTags->"S2.14.5"],
Cell[75391, 2580, 85, 1, 70, "Caption",
  CellTags->"S2.14.5"],
Cell[75479, 2583, 349, 9, 70, "Text",
  CellTags->{"S2.14.5", "5.5"}],
Cell[75831, 2594, 1996, 57, 70, "DefinitionBox",
  CellTags->"S2.14.5"],
Cell[77830, 2653, 144, 5, 70, "Caption",
  CellTags->"S2.14.5"],
Cell[77977, 2660, 756, 19, 70, "Text",
  CellTags->{"S2.14.5", "5.6"}],
Cell[78736, 2681, 476, 14, 70, "DefinitionBox",
  CellTags->"S2.14.5"],
Cell[79215, 2697, 143, 5, 70, "Caption",
  CellTags->"S2.14.5"],
Cell[79361, 2704, 416, 8, 70, "Text",
  CellTags->{"S2.14.5", "5.7"}],
Cell[79780, 2714, 1880, 54, 70, "DefinitionBox",
  CellTags->"S2.14.5"],
Cell[81663, 2770, 140, 5, 70, "Caption",
  CellTags->"S2.14.5"],
Cell[81806, 2777, 354, 7, 70, "Text",
  CellTags->{"S2.14.5", "5.8"}],
Cell[82163, 2786, 1487, 42, 262, "DefinitionBox",
  CellTags->"S2.14.5"],
Cell[83653, 2830, 118, 4, 70, "Caption",
  CellTags->"S2.14.5"],
Cell[83774, 2836, 617, 17, 72, "Text",
  CellTags->{"S2.14.5", "5.9"}],
Cell[84394, 2855, 369, 11, 56, "Text",
  CellTags->{"S2.14.5", "5.10"}],
Cell[84766, 2868, 166, 4, 56, "MathCaption",
  CellTags->{"S2.14.5", "5.11"}],

Cell[CellGroupData[{
Cell[84957, 2876, 108, 2, 28, "Input",
  CellTags->"S2.14.5"],
Cell[85068, 2880, 106, 3, 25, "Output",
  CellTags->"S2.14.5"]
}, Open  ]],
Cell[85189, 2886, 893, 26, 124, "DefinitionBox",
  CellTags->"S2.14.5"],
Cell[86085, 2914, 154, 5, 16, "Caption",
  CellTags->"S2.14.5"],
Cell[86242, 2921, 1618, 43, 226, "DefinitionBox",
  CellTags->"S2.14.5"],
Cell[87863, 2966, 88, 1, 16, "Caption",
  CellTags->"S2.14.5"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

