(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    128846,       4845]*)
(*NotebookOutlinePosition[    195065,       6770]*)
(*  CellTagsIndexPosition[    189511,       6551]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["3.1 ", "HeadingNumber"],
  "Numbers"
}], "Section",
  CellTags->{"S3.1.0", "0.1"}],

Cell[CellGroupData[{

Cell["3.1.1 Types of Numbers", "Subsection",
  CellTags->{"S3.1.1", "1.1"}],

Cell[TextData[{
  "Four underlying types of numbers are built into ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.1.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Integer", "MR"],
              " "
            }]], Cell["\<\
arbitrary\[Hyphen]length exact integer \
\>"]},
          {Cell[TextData[{
              StyleBox["Rational", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["integer", "TI"],
              StyleBox["/", "MR"],
              StyleBox["integer", "TI"],
              " in lowest terms "
            }]]},
          {Cell[TextData[{
              StyleBox["Real", "MR"],
              " "
            }]], Cell[
            "approximate real number, with any specified precision "]},
          {Cell[TextData[{
              StyleBox["Complex", "MR"],
              " "
            }]], Cell[TextData[{
              "complex number of the form ",
              StyleBox["number", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["number", "TI"],
              " ",
              StyleBox["I", "MR"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.1"],

Cell[TextData[{
  "Intrinsic types of numbers in ",
  StyleBox["Mathematica", "SO"],
  "."
}], "Caption",
  CellTags->"S3.1.1"],

Cell["\<\
Rational numbers always consist of a ratio of two integers, reduced \
to lowest terms. \
\>", "MathCaption",
  CellTags->{"S3.1.1", "1.3"}],

Cell[CellGroupData[{

Cell["12344/2222", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.1.1"],

Cell[BoxData[
    \(6172\/1111\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.1.1"]
}, Open  ]],

Cell["\<\
Approximate real numbers are distinguished by the presence of an \
explicit decimal point. \
\>", "MathCaption",
  CellTags->{"S3.1.1", "1.4"}],

Cell[CellGroupData[{

Cell["5456.", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.1.1"],

Cell[BoxData[
    \(5456.`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.1.1"]
}, Open  ]],

Cell["An approximate real number can have any number of digits. ", \
"MathCaption",
  CellTags->{"S3.1.1", "1.5"}],

Cell[CellGroupData[{

Cell["4.54543523454543523453452345234543", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.1.1"],

Cell[BoxData[
    \(4.54543523454543523453452345234543`32.657575474117195\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.1.1"]
}, Open  ]],

Cell["Complex numbers can have integer or rational components. ", \
"MathCaption",
  CellTags->{"S3.1.1", "1.6"}],

Cell[CellGroupData[{

Cell["4 + 7/8 I", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.1.1"],

Cell[BoxData[
    \(4 + \(7\ \[ImaginaryI]\)\/8\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.1.1"]
}, Open  ]],

Cell["They can also have approximate real number components. ", "MathCaption",
  CellTags->{"S3.1.1", "1.7"}],

Cell[CellGroupData[{

Cell["4 + 5.6 I", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.1.1"],

Cell[BoxData[
    \(4 + 5.6`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.1.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["123", "MR"],
              " "
            }]], Cell["an exact integer "]},
          {Cell[TextData[{
              StyleBox["123.", "MR"],
              " "
            }]], Cell["an approximate real number "]},
          {Cell[TextData[{
              StyleBox["123.0000000000000", "MR"],
              " "
            }]], Cell[
            "an approximate real number with a certain precision "]},
          {Cell[TextData[{
              StyleBox["123.", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["0.", "MR"],
              " ",
              StyleBox["I", "MR"],
              " "
            }]], Cell[
            "a complex number with approximate real number components "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.1"],

Cell["Several versions of the number 123. ", "Caption",
  CellTags->"S3.1.1"],

Cell[TextData[{
  "You can distinguish different types of numbers in ",
  StyleBox["Mathematica", "TI"],
  " by looking at their heads. (Although numbers in ",
  StyleBox["Mathematica", "TI"],
  " have heads like other expressions, they do not have explicit elements \
which you can extract.)  "
}], "Text",
  CellTags->{"S3.1.1", "1.8"}],

Cell[TextData[{
  "The object ",
  StyleBox["123", "MR"],
  " is taken to be an exact integer, with head ",
  StyleBox["Integer", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.1", "1.9"}],

Cell[CellGroupData[{

Cell["Head[123]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.1.1"],

Cell[BoxData[
    \(Integer\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.1.1"]
}, Open  ]],

Cell[TextData[{
  "The presence of an explicit decimal point makes ",
  StyleBox["Mathematica", "TI"],
  " treat ",
  StyleBox["123.", "MR"],
  " as an approximate real number, with head ",
  StyleBox["Real", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.1", "1.10"}],

Cell[CellGroupData[{

Cell["Head[123.]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.1.1"],

Cell[BoxData[
    \(Real\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.1.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NumberQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["x", "TI"],
              " is any kind of number "
            }]]},
          {Cell[TextData[{
              StyleBox["IntegerQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["x", "TI"],
              " is an integer "
            }]]},
          {Cell[TextData[{
              StyleBox["EvenQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["x", "TI"],
              " is even "
            }]]},
          {Cell[TextData[{
              StyleBox["OddQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["x", "TI"],
              " is odd "
            }]]},
          {Cell[TextData[{
              StyleBox["PrimeQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["x", "TI"],
              " is a prime integer "
            }]]},
          {Cell[TextData[{
              StyleBox["Head[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]===", "MR"],
              StyleBox["type", "TI"],
              " "
            }]], Cell["test the type of a number"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.1"],

Cell["Tests for different types of numbers.", "Caption",
  CellTags->"S3.1.1"],

Cell[TextData[{
  StyleBox["NumberQ[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " tests for any kind of number. "
}], "MathCaption",
  CellTags->{"S3.1.1", "1.11"}],

Cell[CellGroupData[{

Cell["NumberQ[5.6]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.1.1"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.1.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["5.", "MR"],
  " is treated as a ",
  StyleBox["Real", "MR"],
  ", so ",
  StyleBox["IntegerQ", "MR"],
  " gives ",
  StyleBox["False", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.1", "1.12"}],

Cell[CellGroupData[{

Cell["IntegerQ[5.]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.1.1"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.1.1"]
}, Open  ]],

Cell[TextData[{
  "If you use complex numbers extensively, there is one subtlety you should \
be aware of. When you enter a number like ",
  StyleBox["123.", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " treats it as an approximate real number, but assumes that its imaginary \
part is exactly zero. Sometimes you may want to enter approximate complex \
numbers with imaginary parts that are zero, but only to a certain precision.  \
"
}], "Text",
  CellTags->{"S3.1.1", "1.13"}],

Cell[TextData[{
  "When the imaginary part is the exact integer ",
  StyleBox["0", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " simplifies complex numbers to real ones. "
}], "MathCaption",
  CellTags->{"S3.1.1", "1.14"}],

Cell[CellGroupData[{

Cell["Head[ 123 + 0 I ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.1.1"],

Cell[BoxData[
    \(Integer\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.1.1"]
}, Open  ]],

Cell[TextData[{
  "Here the imaginary part is only zero to a certain precision, so ",
  StyleBox["Mathematica", "TI"],
  " retains the complex number form. "
}], "MathCaption",
  CellTags->{"S3.1.1", "1.15"}],

Cell[CellGroupData[{

Cell["Head[ 123. + 0. I ]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.1.1"],

Cell[BoxData[
    \(Complex\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.1.1"]
}, Open  ]],

Cell[TextData[{
  "The distinction between complex numbers whose imaginary parts are exactly \
zero, or are only zero to a certain precision, may seem like a pedantic one. \
However, when we discuss, for example, the interpretation of powers and roots \
of complex numbers in Section ",
  ButtonBox["3.2.8",
    ButtonData:>{"3.2.8", "8.1"},
    ButtonStyle->"MainBookLink"],
  ", the distinction will become significant. "
}], "Text",
  CellTags->{"S3.1.1", "1.16"}],

Cell[TextData[{
  "One way to find out the type of a number in ",
  StyleBox["Mathematica", "TI"],
  " is just to pick out its head using ",
  StyleBox["Head[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  ". For many purposes, however, it is better to use functions like ",
  StyleBox["IntegerQ", "MR"],
  " which explicitly test for particular types. Functions like this are set \
up to return ",
  StyleBox["True", "MR"],
  " if their argument is manifestly of the required type, and to return ",
  StyleBox["False", "MR"],
  " otherwise. As a result, ",
  StyleBox["IntegerQ[x]", "MR"],
  " will give ",
  StyleBox["False", "MR"],
  ", unless ",
  StyleBox["x", "MR"],
  " has an explicit integer value.  "
}], "Text",
  CellTags->{"S3.1.1", "1.17"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.1.2 Numeric Quantities", "Subsection",
  CellTags->{"S3.1.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NumberQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["expr", "TI"],
              " is explicitly a number "
            }]]},
          {Cell[TextData[{
              StyleBox["NumericQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["expr", "TI"],
              " has a numerical value "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.2"],

Cell["Testing for numeric quantities. ", "Caption",
  CellTags->"S3.1.2"],

Cell[TextData[{
  StyleBox["Pi", "MR"],
  " is a symbol, so ",
  StyleBox["Pi", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["3", "MR"],
  " is not explicitly a number. "
}], "MathCaption",
  CellTags->{"S3.1.2", "2.2"}],

Cell[CellGroupData[{

Cell["NumberQ[Pi + 3]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.1.2"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.1.2"]
}, Open  ]],

Cell["It does however have a numerical value. ", "MathCaption",
  CellTags->{"S3.1.2", "2.3"}],

Cell[CellGroupData[{

Cell["NumericQ[Pi + 3]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.1.2"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.1.2"]
}, Open  ]],

Cell[TextData[{
  "This finds the explicit numerical value of ",
  StyleBox["Pi", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["3", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.2", "2.4"}],

Cell[CellGroupData[{

Cell["N[Pi + 3]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.1.2"],

Cell[BoxData[
    \(6.141592653589793`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.1.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " knows that constants such as ",
  StyleBox["Pi", "MR"],
  " are numeric quantities. It also knows that standard mathematical \
functions such as ",
  StyleBox["Log", "MR"],
  " and ",
  StyleBox["Sin", "MR"],
  " have numerical values when their arguments are numerical.  "
}], "Text",
  CellTags->{"S3.1.2", "2.5"}],

Cell[TextData[{
  StyleBox["Log[2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x]", "MR"],
  " contains ",
  StyleBox["x", "MR"],
  ", and is therefore not a numeric quantity. "
}], "MathCaption",
  CellTags->{"S3.1.2", "2.6"}],

Cell[CellGroupData[{

Cell["{NumericQ[Log[2]], NumericQ[Log[2 + x]]}", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.1.2"],

Cell[BoxData[
    \({True, False}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.1.2"]
}, Open  ]],

Cell["\<\
Many functions implicitly use the numerical values of numeric \
quantities. \
\>", "MathCaption",
  CellTags->{"S3.1.2", "2.7"}],

Cell[CellGroupData[{

Cell["Min[Exp[2], Log[2], Sqrt[2]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.1.2"],

Cell[BoxData[
    \(Log[2]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.1.2"]
}, Open  ]],

Cell[TextData[{
  "In general, ",
  StyleBox["Mathematica", "TI"],
  " assumes that any function which has the attribute ",
  StyleBox["NumericFunction", "MR"],
  " will yield numerical values when its arguments are numerical. All \
standard mathematical functions in ",
  StyleBox["Mathematica", "TI"],
  " already have this attribute. But when you define your own functions, you \
can explicitly set the attribute to tell ",
  StyleBox["Mathematica", "TI"],
  " to assume that these functions will have numerical values when their \
arguments are numerical.  "
}], "Text",
  CellTags->{"S3.1.2", "2.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.1.3 Digits in Numbers", "Subsection",
  CellTags->{"S3.1.3", "3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["IntegerDigits[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a list of the decimal digits in the integer ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["IntegerDigits[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the digits of ",
              StyleBox["n", "TI"],
              " in base ",
              StyleBox["b", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["IntegerDigits[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["len", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "the list of digits padded on the left with zeros to give total \
length ",
              StyleBox["len", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["IntegerExponent[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the number of zeros at the end of ",
              StyleBox["n", "TI"],
              " in base ",
              StyleBox["b", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["RealDigits[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a list of the decimal digits in the approximate real number ",
              StyleBox["x", "TI"],
              
              ", together with the number of digits to the left of the \
decimal point "
            }]]},
          {Cell[TextData[{
              StyleBox["RealDigits[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the digits of ",
              StyleBox["x", "TI"],
              " in base ",
              StyleBox["b", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["RealDigits[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["len", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the first ",
              StyleBox["len", "TI"],
              " digits of ",
              StyleBox["x", "TI"],
              " in base ",
              StyleBox["b", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["RealDigits[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["len", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the first ",
              StyleBox["len", "TI"],
              " digits starting with the coefficient of ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["b",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FromDigits[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "reconstruct a number from its decimal digit sequence "]},
          {Cell[TextData[{
              StyleBox["FromDigits[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "reconstruct a number from its digit sequence in base ",
              StyleBox["b", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, True, False, False, False, True, False}},
  CellTags->"S3.1.3"],

Cell["Converting between numbers and lists of digits. ", "Caption",
  CellTags->"S3.1.3"],

Cell["Here is the list of base 16 digits for an integer. ", "MathCaption",
  CellTags->{"S3.1.3", "3.2"}],

Cell[CellGroupData[{

Cell["IntegerDigits[1234135634, 16]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    \({4, 9, 8, 15, 6, 10, 5, 2}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.1.3"]
}, Open  ]],

Cell["\<\
This gives a list of digits, together with the number of digits \
that appear to the left of the decimal point. \
\>", "MathCaption",
  CellTags->{"S3.1.3", "3.3"}],

Cell[CellGroupData[{

Cell["RealDigits[123.4567890123456]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    \({{1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6}, 3}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.1.3"]
}, Open  ]],

Cell["\<\
Here is the binary digit sequence for 56, padded with zeros so that \
it is of total length 8. \
\>", "MathCaption",
  CellTags->{"S3.1.3", "3.4"}],

Cell[CellGroupData[{

Cell["IntegerDigits[56, 2, 8]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    \({0, 0, 1, 1, 1, 0, 0, 0}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.1.3"]
}, Open  ]],

Cell["\<\
This reconstructs the original number from its binary digit \
sequence. \
\>", "MathCaption",
  CellTags->{"S3.1.3", "3.5"}],

Cell[CellGroupData[{

Cell["FromDigits[%, 2]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    \(56\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.1.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["b", "TI"],
              StyleBox["^^", "MR"],
              StyleBox["nnnn", "TI"],
              " "
            }]], Cell[TextData[{
              "a number in base ",
              StyleBox["b", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["BaseForm[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "print with ",
              StyleBox["x", "TI"],
              " in base ",
              StyleBox["b", "TI"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.3"],

Cell["Numbers in other bases. ", "Caption",
  CellTags->"S3.1.3"],

Cell[TextData[{
  "When the base is larger than ",
  StyleBox["10", "MR"],
  ", extra digits are represented by letters ",
  StyleBox["a", "MR"],
  "\[Dash]",
  StyleBox["z", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.1.3", "3.6"}],

Cell[TextData[{
  "The number ",
  Cell[BoxData[
      \(TraditionalForm\`100101\_2\)], "InlineFormula"],
  " in base 2 is ",
  Cell[BoxData[
      \(TraditionalForm\`37\)], "InlineFormula"],
  " in base 10. "
}], "MathCaption",
  CellTags->{"S3.1.3", "3.7"}],

Cell[CellGroupData[{

Cell["2^^100101", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    \(37\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.1.3"]
}, Open  ]],

Cell[TextData[{
  "This prints ",
  Cell[BoxData[
      \(TraditionalForm\`37\)], "InlineFormula"],
  " in base 2. "
}], "MathCaption",
  CellTags->{"S3.1.3", "3.8"}],

Cell[CellGroupData[{

Cell["BaseForm[37, 2]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("100101"\_"2"\),
        37,
        Editable->False],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[6]//BaseForm= ",
  CellTags->"S3.1.3"]
}, Open  ]],

Cell["Here is a number in base 16. ", "MathCaption",
  CellTags->{"S3.1.3", "3.9"}],

Cell[CellGroupData[{

Cell["16^^ffffaa00", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    \(4294945280\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.1.3"]
}, Open  ]],

Cell["\<\
You can do computations with numbers in base 16. Here the result is \
given in base 10. \
\>", "MathCaption",
  CellTags->{"S3.1.3", "3.10"}],

Cell[CellGroupData[{

Cell["16^^fffaa2 + 16^^ff - 1", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    \(16776096\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.1.3"]
}, Open  ]],

Cell["This gives the result in base 16. ", "MathCaption",
  CellTags->{"S3.1.3", "3.11"}],

Cell[CellGroupData[{

Cell["BaseForm[%, 16]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("fffba0"\_"16"\),
        16776096,
        Editable->False],
      (BaseForm[ #, 16]&)]], "Output",
  CellLabel->"Out[9]//BaseForm= ",
  CellTags->"S3.1.3"]
}, Open  ]],

Cell["\<\
You can give approximate real numbers, as well as integers, in \
other bases. \
\>", "MathCaption",
  CellTags->{"S3.1.3", "3.12"}],

Cell[CellGroupData[{

Cell["2^^101.100101", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    \(5.578125`\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.1.3"]
}, Open  ]],

Cell[TextData[{
  "Here are the first few digits of ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)], "InlineFormula"],
  " in octal. "
}], "MathCaption",
  CellTags->{"S3.1.3", "3.13"}],

Cell[CellGroupData[{

Cell["BaseForm[N[Sqrt[2], 30], 8]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("1.324047463177167462204262766115467"\_8\),
        1.414213562373095048801688724209698078569671875377`48.15051499783199,
        AutoDelete->True],
      (BaseForm[ #, 8]&)]], "Output",
  CellLabel->"Out[11]//BaseForm= ",
  CellTags->"S3.1.3"]
}, Open  ]],

Cell["This gives an explicit list of the first 15 octal digits. ", \
"MathCaption",
  CellTags->{"S3.1.3", "3.14"}],

Cell[CellGroupData[{

Cell["RealDigits[Sqrt[2], 8, 15]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    \({{1, 3, 2, 4, 0, 4, 7, 4, 6, 3, 1, 7, 7, 1, 7}, 1}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.1.3"]
}, Open  ]],

Cell[TextData[{
  "This gives 15 octal digits starting with the coefficient of ",
  Cell[BoxData[
      \(TraditionalForm\`8\^\(-10\)\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.3", "3.15"}],

Cell[CellGroupData[{

Cell["RealDigits[Sqrt[2], 8, 15, -10]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    \({{1, 7, 7, 1, 6, 7, 4, 6, 2, 2, 0, 4, 2, 6, 3}, \(-9\)}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.1.3"]
}, Open  ]],

Cell[TextData[{
  "Section ",
  ButtonBox["2.9.7",
    ButtonData:>{"2.9.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  " describes how to print numbers in various formats. If you want to create \
your own formats, you will often need to use ",
  StyleBox["MantissaExponent", "MR"],
  " to separate the pieces of real numbers. "
}], "Text",
  CellTags->{"S3.1.3", "3.16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MantissaExponent[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list containing the mantissa and exponent of ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MantissaExponent[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the mantissa and exponent in base ",
              StyleBox["b", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.3"],

Cell["Separating the mantissa and exponent of numbers. ", "Caption",
  CellTags->"S3.1.3"],

Cell["\<\
This gives a list in which the mantissa and exponent of the number \
are separated. \
\>", "MathCaption",
  CellTags->{"S3.1.3", "3.17"}],

Cell[CellGroupData[{

Cell["MantissaExponent[3.45 10^125]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.1.3"],

Cell[BoxData[
    \({0.345`, 126}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.1.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.1.4 Numerical Precision", "Subsection",
  CellTags->{"S3.1.4", "4.1"}],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["1.1.2",
    ButtonData:>{"1.1.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " can handle approximate real numbers with any number of digits. In \
general, the ",
  StyleBox["precision", "TI"],
  " of an approximate real number is the effective number of decimal digits \
in it which are treated as significant for computations. The ",
  StyleBox["accuracy", "TI"],
  " is the effective number of these digits which appear to the right of the \
decimal point. Note that to achieve full consistency in the treatment of \
numbers, precision and accuracy often have values that do not correspond to \
integer numbers of digits. "
}], "Text",
  CellTags->{"S3.1.4", "4.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Precision[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the total number of significant decimal digits in ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Accuracy[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "the number of significant decimal digits to the right of the \
decimal point in ",
              StyleBox["x", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.4"],

Cell["Precision and accuracy of real numbers. ", "Caption",
  CellTags->"S3.1.4"],

Cell["\<\
This generates a number with 30\[Hyphen]digit precision. \
\>", \
"MathCaption",
  CellTags->{"S3.1.4", "4.3"}],

Cell[CellGroupData[{

Cell["x = N[Pi^10, 30]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \(93648.0474760830209737166901849193456359978`30. \)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell["This gives the precision of the number. ", "MathCaption",
  CellTags->{"S3.1.4", "4.4"}],

Cell[CellGroupData[{

Cell["Precision[x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \(30.`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell["\<\
The accuracy is lower since only some of the digits are to the \
right of the decimal point. \
\>", "MathCaption",
  CellTags->{"S3.1.4", "4.5"}],

Cell[CellGroupData[{

Cell["Accuracy[x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \(25.028501273058666`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell["\<\
This number has all its digits to the right of the decimal point. \
\
\>", "MathCaption",
  CellTags->{"S3.1.4", "4.6"}],

Cell[CellGroupData[{

Cell["x / 10^6", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \(0.093648047476083020973716690184919345635997801029`30. \)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell["Now the accuracy is larger than the precision. ", "MathCaption",
  CellTags->{"S3.1.4", "4.7"}],

Cell[CellGroupData[{

Cell["{Precision[%], Accuracy[%]}", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \({30.`, 31.02850127305866`}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell["\<\
An approximate real number always has some uncertainty in its \
value, associated with digits beyond those known. One can think of precision \
as providing a measure of the relative size of this uncertainty. Accuracy \
gives a measure of the absolute size of the uncertainty. \
\>", "Text",
  CellTags->{"S3.1.4", "4.8"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " is set up so that if a number ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " has uncertainty ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta]\)], "InlineFormula"],
  ", then its true value can lie anywhere in an interval of size ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta]\)], "InlineFormula"],
  " from ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "-", "\[Delta]", "/", "2"}], TraditionalForm]], 
    "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "+", "\[Delta]", "/", "2"}], TraditionalForm]], 
    "InlineFormula"],
  ". An approximate number with accuracy ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is defined to have uncertainty ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["10", 
          RowBox[{"-", 
            StyleBox["a",
              "TI"]}]], TraditionalForm]], "InlineFormula"],
  ", while a non\[Hyphen]zero approximate number with precision ",
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is defined to have uncertainty ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[VerticalSeparator]", 
          StyleBox["x",
            "TI"], "\[VerticalSeparator]", 
          SuperscriptBox["10", 
            RowBox[{"-", 
              StyleBox["p",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.1.4", "4.9"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Precision[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{"-", \(log\_10\), 
                      RowBox[{"(", 
                        RowBox[{"\[Delta]", "/", "\[VerticalSeparator]", 
                          StyleBox["x",
                            "TI"], "\[VerticalSeparator]"}], ")"}]}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Accuracy[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\(-log\_10\) \((\[Delta])\)\)], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.4"],

Cell["\<\
Definitions of precision and accuracy in terms of uncertainty. \
\
\>", "Caption",
  CellTags->"S3.1.4"],

Cell["\<\
Adding or subtracting a quantity smaller than the uncertainty has \
no visible effect. \
\>", "MathCaption",
  CellTags->{"S3.1.4", "4.10"}],

Cell[CellGroupData[{

Cell["{x - 10^-26, x, x + 10^-26}", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \({93648.0474760830209737166901849093456359976`30. , 
      93648.0474760830209737166901849193456359978`30. , 
      93648.0474760830209737166901849293456359976`30. }\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["N[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " to ",
              StyleBox["n", "TI"],
              
              "\[Hyphen]digit precision using arbitrary\[Hyphen]precision \
numbers "
            }]]},
          {Cell[TextData[{
              StyleBox["N[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " numerically using machine\[Hyphen]precision numbers "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.4"],

Cell["\<\
Numerical evaluation with arbitrary\[Hyphen]precision and machine\
\[Hyphen]precision numbers. \
\>", "Caption",
  CellTags->"S3.1.4"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " distinguishes two kinds of approximate real numbers: ",
  StyleBox["arbitrary\[Hyphen]precision", "TI"],
  " numbers, and ",
  StyleBox["machine\[Hyphen]precision", "TI"],
  " numbers or ",
  StyleBox["machine numbers", "TI"],
  ". Arbitrary\[Hyphen]precision numbers can contain any number of digits, \
and maintain information on their precision. Machine numbers, on the other \
hand, always contain the same number of digits, and maintain no information \
on their precision. "
}], "Text",
  CellTags->{"S3.1.4", "4.11"}],

Cell[TextData[{
  "Here is a machine\[Hyphen]number approximation to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.4", "4.12"}],

Cell[CellGroupData[{

Cell["N[Pi]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \(3.141592653589793`\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell["\<\
These are both arbitrary\[Hyphen]precision numbers. \
\>", \
"MathCaption",
  CellTags->{"S3.1.4", "4.13"}],

Cell[CellGroupData[{

Cell["{N[Pi, 4], N[Pi, 20]}", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \({3.1415926535897932385`4.000000000000001, 
      3.1415926535897932384626433832795028842`20. }\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell["\<\
As discussed in more detail below, machine numbers work by making \
direct use of the numerical capabilities of your underlying computer system. \
As a result, computations with them can often be done more quickly. They are \
however much less flexible than arbitrary\[Hyphen]precision numbers, and \
difficult numerical analysis can be needed to determine whether results \
obtained with them are correct. \
\>", "Text",
  CellTags->{"S3.1.4", "4.14"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MachinePrecision", "MR"],
              " "
            }]], 
            Cell["\<\
the precision specification used to indicate machine \
numbers \
\>"]},
          {Cell[TextData[{
              StyleBox["$MachinePrecision", "MR"],
              " "
            }]], 
            Cell["\<\
the effective precision for machine numbers on your \
computer system \
\>"]},
          {Cell[TextData[{
              StyleBox["MachineNumberQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["x", "TI"],
              " is a machine number "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.4"],

Cell["Machine numbers. ", "Caption",
  CellTags->"S3.1.4"],

Cell[TextData[{
  "This returns the symbol ",
  StyleBox["MachinePrecision", "MR"],
  " to indicate a machine number. "
}], "MathCaption",
  CellTags->{"S3.1.4", "4.15"}],

Cell[CellGroupData[{

Cell["Precision[ N[Pi] ]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \(MachinePrecision\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell["\<\
On this computer, machine numbers have slightly less than 16 \
decimal digits. \
\>", "MathCaption",
  CellTags->{"S3.1.4", "4.16"}],

Cell[CellGroupData[{

Cell["$MachinePrecision", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \(15.954589770191003`\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell[TextData[{
  "When you enter an approximate real number, ",
  StyleBox["Mathematica", "TI"],
  " has to decide whether to treat it as a machine number or an arbitrary\
\[Hyphen]precision number. Unless you specify otherwise, then if you give \
less than ",
  StyleBox["$MachinePrecision", "MR"],
  " digits, ",
  StyleBox["Mathematica", "TI"],
  " will treat the number as machine precision, and if you give more digits, \
it will treat the number as arbitrary precision.   "
}], "Text",
  CellTags->{"S3.1.4", "4.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["123.4", "MR"],
              " "
            }]], Cell["a machine\[Hyphen]precision number "]},
          {Cell[TextData[{
              StyleBox["123.45678901234567890", "MR"],
              " "
            }]], 
            Cell["\<\
an arbitrary\[Hyphen]precision number on some computer \
systems \
\>"]},
          {Cell[TextData[{
              StyleBox["123.45678901234567890`", "MR"],
              " "
            }]], 
            Cell["\<\
a machine\[Hyphen]precision number on all computer \
systems \
\>"]},
          {Cell[TextData[{
              StyleBox["123.456`200", "MR"],
              " "
            }]], 
            Cell["\<\
an arbitrary\[Hyphen]precision number with 200 digits \
of precision \
\>"]},
          {Cell[TextData[{
              StyleBox["123.456``200", "MR"],
              " "
            }]], 
            Cell["\<\
an arbitrary\[Hyphen]precision number with 200 digits \
of accuracy \
\>"]},
          {Cell[TextData[{
              StyleBox["1.234*^6", "MR"],
              " "
            }]], Cell[TextData[{
              "a machine\[Hyphen]precision number in scientific notation (",
              Cell[BoxData[
                  \(TraditionalForm\`1.234\[Cross]10\^6\)], "InlineFormula"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["1.234`200*^6", "MR"],
              " "
            }]], 
            Cell["\<\
a number in scientific notation with 200 digits of \
precision \
\>"]},
          {Cell[TextData[{
              StyleBox["2^^101.111`200", "MR"],
              " "
            }]], Cell[
            "a number in base 2 with 200 binary digits of precision "]},
          {Cell[TextData[{
              StyleBox["2^^101.111`200*^6", "MR"],
              " "
            }]], Cell[TextData[{
              "a number in base 2 scientific notation (",
              Cell[BoxData[
                  \(TraditionalForm\`101.111\_2\[Cross]2\^6\)], 
                "InlineFormula"],
              ") "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.4"],

Cell["Input forms for numbers. ", "Caption",
  CellTags->"S3.1.4"],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " prints out numbers, it usually tries to give them in a form that will be \
as easy as possible to read. But if you want to take numbers that are printed \
out by ",
  StyleBox["Mathematica", "TI"],
  ", and then later use them as input to ",
  StyleBox["Mathematica", "TI"],
  ", you need to make sure that no information gets lost.   "
}], "Text",
  CellTags->{"S3.1.4", "4.18"}],

Cell[TextData[{
  "In standard output form, ",
  StyleBox["Mathematica", "TI"],
  " prints a number like this to six digits. "
}], "MathCaption",
  CellTags->{"S3.1.4", "4.19"}],

Cell[CellGroupData[{

Cell["N[Pi]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \(3.141592653589793`\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell[TextData[{
  "In input form, ",
  StyleBox["Mathematica", "TI"],
  " prints all the digits it knows. "
}], "MathCaption",
  CellTags->{"S3.1.4", "4.20"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.1.4"],

Cell["3.141592653589793", "Output",
  CellLabel->"Out[12]//InputForm= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell["\<\
Here is an arbitrary\[Hyphen]precision number in standard output \
form. \
\>", "MathCaption",
  CellTags->{"S3.1.4", "4.21"}],

Cell[CellGroupData[{

Cell["N[Pi, 20]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \(3.1415926535897932384626433832795028842`20. \)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell[TextData[{
  "In input form, ",
  StyleBox["Mathematica", "TI"],
  " explicitly indicates the precision of the number, and gives extra digits \
to make sure the number can be reconstructed correctly. "
}], "MathCaption",
  CellTags->{"S3.1.4", "4.22"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.1.4"],

Cell["3.1415926535897932384626433832795028842`20.", "Output",
  CellLabel->"Out[14]//InputForm= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell[TextData[{
  "This makes ",
  StyleBox["Mathematica", "TI"],
  " not explicitly indicate precision. "
}], "MathCaption",
  CellTags->{"S3.1.4", "4.23"}],

Cell[CellGroupData[{

Cell["InputForm[%, NumberMarks->False]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.1.4"],

Cell["3.1415926535897932384626433832795028842", "Output",
  CellLabel->"Out[15]//InputForm= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["InputForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["NumberMarks->True]", "MR"],
              " "
            }]], Cell[TextData[{
              "use ",
              StyleBox["`", "MR"],
              " marks in all approximate numbers "
            }]]},
          {Cell[TextData[{
              StyleBox["InputForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["NumberMarks->Automatic]", "MR"],
              " "
            }]], Cell[TextData[{
              "use ",
              StyleBox["`", "MR"],
              " only in arbitrary\[Hyphen]precision numbers "
            }]]},
          {Cell[TextData[{
              StyleBox["InputForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["NumberMarks->False]", "MR"],
              " "
            }]], Cell[TextData[{
              "never use ",
              StyleBox["`", "MR"],
              " marks "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.4"],

Cell["Controlling printing of numbers. ", "Caption",
  CellTags->"S3.1.4"],

Cell[TextData[{
  "The default setting for the ",
  StyleBox["NumberMarks", "MR"],
  " option, both in ",
  StyleBox["InputForm", "MR"],
  " and in functions such as ",
  StyleBox["ToString", "MR"],
  " and ",
  StyleBox["OpenWrite", "MR"],
  " is given by the value of ",
  StyleBox["$NumberMarks", "MR"],
  ". By resetting ",
  StyleBox["$NumberMarks", "MR"],
  ", therefore, you can globally change the way that numbers are printed in \
",
  StyleBox["InputForm", "MR"],
  ".   "
}], "Text",
  CellTags->{"S3.1.4", "4.24"}],

Cell[TextData[{
  "This makes ",
  StyleBox["Mathematica", "TI"],
  " by default always include number marks in input form. "
}], "MathCaption",
  CellTags->{"S3.1.4", "4.25"}],

Cell[CellGroupData[{

Cell["$NumberMarks = True", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell["\<\
Even a machine\[Hyphen]precision number is now printed with an \
explicit number mark. \
\>", "MathCaption",
  CellTags->{"S3.1.4", "4.26"}],

Cell[CellGroupData[{

Cell["InputForm[N[Pi]]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.1.4"],

Cell["3.141592653589793`", "Output",
  CellLabel->"Out[17]//InputForm= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell[TextData[{
  "Even with no number marks, ",
  StyleBox["InputForm", "MR"],
  " still uses ",
  StyleBox["*^", "MR"],
  " for scientific notation. "
}], "MathCaption",
  CellTags->{"S3.1.4", "4.27"}],

Cell[CellGroupData[{

Cell["InputForm[N[Exp[600], 20], NumberMarks->False]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.1.4"],

Cell["3.77302030092993982340143119348313509718*^260", "Output",
  CellLabel->"Out[18]//InputForm= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell[TextData[{
  "In doing numerical computations, it is inevitable that you will sometimes \
end up with results that are less precise than you want. Particularly when \
you get numerical results that are very close to zero, you may well want to \
",
  StyleBox["assume", "TI"],
  " that the results should be exactly zero. The function ",
  StyleBox["Chop", "MR"],
  " allows you to replace approximate real numbers that are close to zero by \
the exact integer ",
  StyleBox["0", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.1.4", "4.28"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Chop[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace all approximate real numbers in ",
              StyleBox["expr", "TI"],
              " with magnitude less than ",
              Cell[BoxData[
                  \(TraditionalForm\`10\^\(-10\)\)], "InlineFormula"],
              " by 0 "
            }]]},
          {Cell[TextData[{
              StyleBox["Chop[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dx", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace numbers with magnitude less than ",
              StyleBox["dx", "TI"],
              " by 0 "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.4"],

Cell["Removing numbers close to zero. ", "Caption",
  CellTags->"S3.1.4"],

Cell["This computation gives a small imaginary part. ", "MathCaption",
  CellTags->{"S3.1.4", "4.29"}],

Cell[CellGroupData[{

Cell["Exp[ N[2 Pi I] ]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \(\(\(1.`\)\(\[InvisibleSpace]\)\) - 
      2.4492127076447545`*^-16\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.1.4"]
}, Open  ]],

Cell[TextData[{
  "You can get rid of the imaginary part using ",
  StyleBox["Chop", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.4", "4.30"}],

Cell[CellGroupData[{

Cell["Chop[%]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.1.4"],

Cell[BoxData[
    \(1.`\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.1.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
3.1.5 Arbitrary\[Hyphen]Precision Numbers\
\>", "Subsection",
  CellTags->{"S3.1.5", "5.1"}],

Cell[TextData[{
  "When you do calculations with arbitrary\[Hyphen]precision numbers, ",
  StyleBox["Mathematica", "TI"],
  " keeps track of precision at all points. In general, ",
  StyleBox["Mathematica", "TI"],
  " tries to give you results which have the highest possible precision, \
given the precision of the input you provided. "
}], "Text",
  CellTags->{"S3.1.5", "5.2"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " treats arbitrary\[Hyphen]precision numbers as representing the values of \
quantities where a certain number of digits are known, and the rest are \
unknown. In general, an arbitrary\[Hyphen]precision number ",
  StyleBox["x", "TI"],
  " is taken to have ",
  StyleBox["Precision[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " digits which are known exactly, followed by an infinite number of digits \
which are completely unknown. "
}], "Text",
  CellTags->{"S3.1.5", "5.3"}],

Cell[TextData[{
  "This computes ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " to 10\[Hyphen]digit precision. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.4"}],

Cell[CellGroupData[{

Cell["N[Pi, 10]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(3.1415926535897932385`10.000000000000004\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["After a certain point, all digits are indeterminate. ", "MathCaption",
  CellTags->{"S3.1.5", "5.5"}],

Cell[CellGroupData[{

Cell["RealDigits[%, 10, 13]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \({{3, 1, 4, 1, 5, 9, 2, 6, 5, 3, 5, Indeterminate, Indeterminate}, 
      1}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "When you do a computation, ",
  StyleBox["Mathematica", "TI"],
  " keeps track of which digits in your result could be affected by unknown \
digits in your input. It sets the precision of your result so that no \
affected digits are ever included. This procedure ensures that all digits \
returned by ",
  StyleBox["Mathematica", "TI"],
  " are correct, whatever the values of the unknown digits may be. "
}], "Text",
  CellTags->{"S3.1.5", "5.6"}],

Cell[TextData[{
  "This evaluates ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalGamma](1/7)\)], "InlineFormula"],
  " to 30\[Hyphen]digit precision. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.7"}],

Cell[CellGroupData[{

Cell["N[Gamma[1/7], 30]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(6.548062940247824437714093349428996262581763512364`30. \)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["The result has a precision of exactly 30 digits. ", "MathCaption",
  CellTags->{"S3.1.5", "5.8"}],

Cell[CellGroupData[{

Cell["Precision[%]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(30.`\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "If you give input only to a few digits of precision, ",
  StyleBox["Mathematica", "TI"],
  " cannot give you such high\[Hyphen]precision output. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.9"}],

Cell[CellGroupData[{

Cell["N[Gamma[0.142], 30]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(6.589647294920399`\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "If you want ",
  StyleBox["Mathematica", "TI"],
  " to assume that the argument is ",
  StyleBox["exactly", "TI"],
  " ",
  StyleBox["142/1000", "MR"],
  ", then you have to say so explicitly. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.10"}],

Cell[CellGroupData[{

Cell["N[Gamma[142/1000], 30]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(6.589647294920397883284819174959777852274733913396`30. \)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["\<\
In many computations, the precision of the results you get \
progressively degrades as a result of \[OpenCurlyDoubleQuote]roundoff error\
\[CloseCurlyDoubleQuote]. A typical case of this occurs if you subtract two \
numbers that are close together. The result you get depends on \
high\[Hyphen]order digits in each number, and typically has far fewer digits \
of precision than either of the original numbers. \
\>", "Text",
  CellTags->{"S3.1.5", "5.11"}],

Cell["\<\
Both input numbers have a precision of around 20 digits, but the \
result has much lower precision. \
\>", "MathCaption",
  CellTags->{"S3.1.5", "5.12"}],

Cell[CellGroupData[{

Cell["1.11111111111111111111 - 1.11111111111111111000", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(1.11`1.7442929831226766*^-18\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["\<\
Adding extra digits in one number but not the other is not \
sufficient to allow extra digits to be found in the result. \
\>", \
"MathCaption",
  CellTags->{"S3.1.5", "5.13"}],

Cell[CellGroupData[{

Cell["1.11111111111111111111345 - 1.11111111111111111000", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(1.11345`2.0462366421290494*^-18\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["\<\
The precision of the output from a function can depend in a \
complicated way on the precision of the input. Functions that vary rapidly \
typically give less precise output, since the variation of the output \
associated with uncertainties in the input is larger. Functions that are \
close to constants can actually give output that is more precise than their \
input.   \
\>", "Text",
  CellTags->{"S3.1.5", "5.14"}],

Cell[TextData[{
  "Functions like ",
  StyleBox["Sin", "MR"],
  " that vary rapidly typically give output that is less precise than their \
input. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.15"}],

Cell[CellGroupData[{

Cell["Sin[111111111.0000000000000000]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(\(-0.2975351033349432332680631439`15.493666339996429\)\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "Here is ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["e",
            "TI"], \(-40\)], TraditionalForm]], "InlineFormula"],
  " evaluated to 20\[Hyphen]digit precision. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.16"}],

Cell[CellGroupData[{

Cell["N[Exp[-40], 20]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(4.248354255291588995329234782859`20.000000000000007*^-18\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "The result you get by adding the exact integer ",
  StyleBox["1", "MR"],
  " has a higher precision. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.17"}],

Cell[CellGroupData[{

Cell["1 + %", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(1.000000000000000004248354255291588995329234782859`37.371779276130084\)]\
, "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["\<\
It is worth realizing that different ways of doing the same \
calculation can end up giving you results with very different precisions. \
Typically, if you once lose precision in a calculation, it is essentially \
impossible to regain it; in losing precision, you are effectively losing \
information about your result. \
\>", "Text",
  CellTags->{"S3.1.5", "5.18"}],

Cell["\<\
Here is a 40\[Hyphen]digit number that is close to 1. \
\>", \
"MathCaption",
  CellTags->{"S3.1.5", "5.19"}],

Cell[CellGroupData[{

Cell["x = N[1 - 10^-30, 40]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(0.999999999999999999999999999999`40. \)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "Adding ",
  StyleBox["1", "MR"],
  " to it gives another 40\[Hyphen]digit number. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.20"}],

Cell[CellGroupData[{

Cell["1 + x", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(1.999999999999999999999999999999`40.30102999566398\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["The original precision has been maintained. ", "MathCaption",
  CellTags->{"S3.1.5", "5.21"}],

Cell[CellGroupData[{

Cell["Precision[%]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(40.30102999566398`\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "This way of computing ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x", "MR"],
  " loses precision. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.22"}],

Cell[CellGroupData[{

Cell["(x^2 - 1) / (x - 1)", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(2.`9.698970004336017\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["The result obtained in this way has quite low precision. ", \
"MathCaption",
  CellTags->{"S3.1.5", "5.23"}],

Cell[CellGroupData[{

Cell["Precision[%]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(9.698970004336017`\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "The fact that different ways of doing the same calculation can give you \
different numerical answers means, among other things, that comparisons \
between approximate real numbers must be treated with care. In testing \
whether two real numbers are \[OpenCurlyDoubleQuote]equal\
\[CloseCurlyDoubleQuote], ",
  StyleBox["Mathematica", "TI"],
  " effectively finds their difference, and tests whether the result is \
\[OpenCurlyDoubleQuote]consistent with zero\[CloseCurlyDoubleQuote] to the \
precision given.  "
}], "Text",
  CellTags->{"S3.1.5", "5.24"}],

Cell["These numbers are equal to the precision given. ", "MathCaption",
  CellTags->{"S3.1.5", "5.25"}],

Cell[CellGroupData[{

Cell["3 == 3.000000000000000000", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "The internal algorithms that ",
  StyleBox["Mathematica", "TI"],
  " uses to evaluate mathematical functions are set up to maintain as much \
precision as possible. In most cases, built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions will give you results that have as much precision as can be \
justified on the basis of your input. In some cases, however, it is simply \
impractical to do this, and ",
  StyleBox["Mathematica", "TI"],
  " will give you results that have lower precision. If you give higher\
\[Hyphen]precision input, ",
  StyleBox["Mathematica", "TI"],
  " will use higher precision in its internal calculations, and you will \
usually be able to get a higher\[Hyphen]precision result. "
}], "Text",
  CellTags->{"S3.1.5", "5.26"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["N[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " numerically to machine precision "
            }]]},
          {Cell[TextData[{
              StyleBox["N[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " numerically trying to get a result with ",
              StyleBox["n", "TI"],
              " digits of precision "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.5"],

Cell["Numerical evaluation. ", "Caption",
  CellTags->"S3.1.5"],

Cell[TextData[{
  "If you start with an expression that contains only integers and other \
exact numeric quantities, then ",
  StyleBox["N[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " will in almost all cases succeed in giving you a result to ",
  StyleBox["n", "TI"],
  " digits of precision. You should realize, however, that to do this ",
  StyleBox["Mathematica", "TI"],
  " sometimes has to perform internal intermediate calculations to much \
higher precision.  "
}], "Text",
  CellTags->{"S3.1.5", "5.27"}],

Cell[TextData[{
  "The global variable ",
  StyleBox["$MaxExtraPrecision", "MR"],
  " specifies how many additional digits should be allowed in such \
intermediate calculations. "
}], "Text",
  CellTags->{"S3.1.5", "5.28"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["variable", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["$MaxExtraPrecision", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["50", "MR"],
              " "
            }]], Cell["maximum additional precision to use "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->True},
  CellTags->"S3.1.5"],

Cell["Controlling precision in intermediate calculations. ", "Caption",
  CellTags->"S3.1.5"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " automatically increases the precision that it uses internally in order to \
get the correct answer here. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.29"}],

Cell[CellGroupData[{

Cell["N[Sin[10^40], 30]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(\(-0.569633400953636327308034181573568723132921316046`30. \)\)], \
"Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "Using the default setting ",
  StyleBox["$MaxExtraPrecision=50", "MR"],
  " ",
  StyleBox["Mathematica", "TI"],
  " cannot get the correct answer here. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.30"}],

Cell[CellGroupData[{

Cell["N[Sin[10^100], 30]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(N::"meprec" \(\(:\)\(\ \)\) 
      "Internal precision limit $MaxExtraPrecision = \!\(50.`\) reached while \
evaluating \!\(Sin[\(\(10000000000000000000000000000000 \(\(\[LeftSkeleton] \
36 \[RightSkeleton]\)\) 000000000000000000000000000000000\)\)]\)."\)], \
"Message",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(0``0\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " that it can use more digits in its internal calculations. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.31"}],

Cell[CellGroupData[{

Cell["$MaxExtraPrecision = 200", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(200\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["Now it gets the correct answer. ", "MathCaption",
  CellTags->{"S3.1.5", "5.32"}],

Cell[CellGroupData[{

Cell["N[Sin[10^100], 30]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(\(-0.372376123661276688262086695553164295719667883568`30. \)\)], \
"Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "This resets ",
  StyleBox["$MaxExtraPrecision", "MR"],
  " to its default value. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.33"}],

Cell[CellGroupData[{

Cell["$MaxExtraPrecision = 50", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(50\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "Even when you are doing computations that give exact results, ",
  StyleBox["Mathematica", "TI"],
  " still occasionally uses approximate numbers for some of its internal \
calculations, so that the value of ",
  StyleBox["$MaxExtraPrecision", "MR"],
  " can thus have an effect. "
}], "Text",
  CellTags->{"S3.1.5", "5.34"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " works this out using bounds from approximate numbers. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.35"}],

Cell[CellGroupData[{

Cell["Sin[Exp[100]] > 0", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "With the default value of ",
  StyleBox["$MaxExtraPrecision", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " cannot work this out. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.36"}],

Cell[CellGroupData[{

Cell["Sin[Exp[200]] > 0", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(N::"meprec" \(\(:\)\(\ \)\) 
      "Internal precision limit $MaxExtraPrecision = \!\(50.`\) reached while \
evaluating \!\(-\(\(Sin[\(\(\[ExponentialE]\^200\)\)]\)\)\)."\)], "Message",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(Sin[\[ExponentialE]\^200] > 0\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "Temporarily resetting ",
  StyleBox["$MaxExtraPrecision", "MR"],
  " allows ",
  StyleBox["Mathematica", "TI"],
  " to get the result. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.37"}],

Cell[CellGroupData[{

Cell["Block[{$MaxExtraPrecision = 100}, Sin[Exp[200]] > 0 ]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "In doing calculations that degrade precision, it is possible to end up \
with numbers that have no significant digits at all. But even in such cases, \
",
  StyleBox["Mathematica", "TI"],
  " still maintains information on the accuracy of the numbers. Given a \
number with no significant digits, but accuracy ",
  StyleBox["a", "TI"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " can then still tell that the actual value of the number must be in the \
range ",
  Cell[BoxData[
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{"-", 
              SuperscriptBox["10", 
                RowBox[{"-", 
                  StyleBox["a",
                    "TI"]}]]}], ",", 
            RowBox[{"+", 
              SuperscriptBox["10", 
                RowBox[{"-", 
                  StyleBox["a",
                    "TI"]}]]}]}], "}"}], "/", "2"}]], "InlineFormula"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " by default prints such numbers in the form ",
  Cell[BoxData[
      RowBox[{"0.", "\[Times]", 
        SuperscriptBox["10", 
          StyleBox["e",
            "TI"]]}]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.1.5", "5.38"}],

Cell["\<\
Here is a number with 20\[Hyphen]digit precision. \
\>", \
"MathCaption",
  CellTags->{"S3.1.5", "5.39"}],

Cell[CellGroupData[{

Cell["x = N[Exp[50], 20]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(5.184705528587072464087453322934`20.*^21\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["Here there are no significant digits left. ", "MathCaption",
  CellTags->{"S3.1.5", "5.40"}],

Cell[CellGroupData[{

Cell["Sin[x]/x", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(0``21.71472409516259\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "But ",
  StyleBox["Mathematica", "TI"],
  " still keeps track of the accuracy of the result. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.41"}],

Cell[CellGroupData[{

Cell["Accuracy[%]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(21.71472409516259`\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "Adding this to an exact ",
  StyleBox["1", "MR"],
  " gives a number with quite high precision. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.42"}],

Cell[CellGroupData[{

Cell["1 + %", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(22.71472409516259`\)], "Output",
  CellLabel->"Out[29]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["\<\
One subtlety in characterizing numbers by their precision is that \
any number that is consistent with zero must be treated as having zero \
precision. The reason for this is that such a number has no digits that can \
be recognized as significant, since all its known digits are just zero. \
\
\>", "Text",
  CellTags->{"S3.1.5", "5.43"}],

Cell["This gives a number whose value is consistent with zero. ", \
"MathCaption",
  CellTags->{"S3.1.5", "5.44"}],

Cell[CellGroupData[{

Cell["d = N[Pi, 20] - Pi", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(0``19.502850127305866\)], "Output",
  CellLabel->"Out[30]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["\<\
The number has no recognizable significant digits of precision. \
\
\>", "MathCaption",
  CellTags->{"S3.1.5", "5.45"}],

Cell[CellGroupData[{

Cell["Precision[d]", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(0.`\)], "Output",
  CellLabel->"Out[31]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["\<\
But it still has a definite accuracy, that characterizes the \
uncertainty in it. \
\>", "MathCaption",
  CellTags->{"S3.1.5", "5.46"}],

Cell[CellGroupData[{

Cell["Accuracy[d]", "Input",
  CellLabel->"In[32]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(19.502850127305866`\)], "Output",
  CellLabel->"Out[32]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["\<\
If you do computations whose results are likely to be near zero, it \
can be convenient to specify the accuracy, rather than the precision, that \
you want to get. \
\>", "Text",
  CellTags->{"S3.1.5", "5.47"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["N[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["p", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " to precision ",
              StyleBox["p", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["N[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["p", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " to at most precision ",
              StyleBox["p", "TI"],
              " and accuracy ",
              StyleBox["a", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["N[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{Infinity,", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " to any precision but to accuracy ",
              StyleBox["a", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.5"],

Cell["Specifying accuracy as well as precision. ", "Caption",
  CellTags->"S3.1.5"],

Cell["Here is a symbolic expression. ", "MathCaption",
  CellTags->{"S3.1.5", "5.48"}],

Cell[CellGroupData[{

Cell["u = ArcTan[1/3] - ArcCot[3]", "Input",
  CellLabel->"In[33]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(\(-ArcCot[3]\) + ArcTan[1\/3]\)], "Output",
  CellLabel->"Out[33]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["This shows that the expression is equivalent to zero. ", "MathCaption",
  CellTags->{"S3.1.5", "5.49"}],

Cell[CellGroupData[{

Cell["FullSimplify[u]", "Input",
  CellLabel->"In[34]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[34]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["N", "MR"],
  " cannot guarantee to get a result to precision 20. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.50"}],

Cell[CellGroupData[{

Cell["N[u, 20]", "Input",
  CellLabel->"In[35]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(N::"meprec" \(\(:\)\(\ \)\) 
      "Internal precision limit $MaxExtraPrecision = \!\(50.`\) reached while \
evaluating \!\(\(\(-\(\(ArcCot[3]\)\)\)\) + \
\(\(ArcTan[\(\(1\/3\)\)]\)\)\)."\)], "Message",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(0``70.0153594413863\)], "Output",
  CellLabel->"Out[35]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["But it can get a result to accuracy 20. ", "MathCaption",
  CellTags->{"S3.1.5", "5.51"}],

Cell[CellGroupData[{

Cell["N[u, {Infinity, 20}]", "Input",
  CellLabel->"In[36]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(0``19.999999999999996\)], "Output",
  CellLabel->"Out[36]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " works out the potential effect of unknown digits in \
arbitrary\[Hyphen]precision numbers, it assumes by default that these digits \
are completely independent in different numbers. While this assumption will \
never yield too high a precision in a result, it may lead to unnecessary loss \
of precision. "
}], "Text",
  CellTags->{"S3.1.5", "5.52"}],

Cell[TextData[{
  "In particular, if two numbers are generated in the same way in a \
computation, some of their unknown digits may be equal. Then, when these \
numbers are, for example, subtracted, the unknown digits may cancel. By \
assuming that the unknown digits are always independent, however, ",
  StyleBox["Mathematica", "TI"],
  " will miss such cancellations. "
}], "Text",
  CellTags->{"S3.1.5", "5.53"}],

Cell["\<\
Here is a number computed to 20\[Hyphen]digit precision. \
\>", \
"MathCaption",
  CellTags->{"S3.1.5", "5.54"}],

Cell[CellGroupData[{

Cell["d = N[3^-30, 20]", "Input",
  CellLabel->"In[37]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(4.856935749618861137906242664974575`20.*^-15\)], "Output",
  CellLabel->"Out[37]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "The quantity ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["d", "MR"],
  " has about 34\[Hyphen]digit precision. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.55"}],

Cell[CellGroupData[{

Cell["Precision[1 + d]", "Input",
  CellLabel->"In[38]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(34.31363764158988`\)], "Output",
  CellLabel->"Out[38]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "This quantity still has the same precision, since ",
  StyleBox["Mathematica", "TI"],
  " assumes that the unknown digits in each number ",
  StyleBox["d", "MR"],
  " are independent. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.56"}],

Cell[CellGroupData[{

Cell["Precision[(1 + d) - d]", "Input",
  CellLabel->"In[39]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(34.0126076459259`\)], "Output",
  CellLabel->"Out[39]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["\<\
Numerical algorithms sometimes rely on cancellations between \
unknown digits in different numbers yielding results of higher precision. If \
you can be sure that certain unknown digits will eventually cancel, then you \
can explicitly introduce fixed digits in place of the unknown ones. You can \
carry these fixed digits through your computation, then let them cancel, and \
get a result of higher precision. \
\>", "Text",
  CellTags->{"S3.1.5", "5.57"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SetPrecision[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create a number with ",
              StyleBox["n", "TI"],
              
              " decimal digits of precision, padding with base\[Hyphen]2 \
zeros if necessary "
            }]]},
          {Cell[TextData[{
              StyleBox["SetAccuracy[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create a number with ",
              StyleBox["n", "TI"],
              " decimal digits of accuracy "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.5"],

Cell["Functions for modifying precision and accuracy. ", "Caption",
  CellTags->"S3.1.5"],

Cell[TextData[{
  "This introduces 10 more digits in ",
  StyleBox["d", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.58"}],

Cell[CellGroupData[{

Cell["d = SetPrecision[d, 30]", "Input",
  CellLabel->"In[40]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(4.856935749618861137906242664974575387236605`30.*^-15\)], "Output",
  CellLabel->"Out[40]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["The digits that were added cancel out here. ", "MathCaption",
  CellTags->{"S3.1.5", "5.59"}],

Cell[CellGroupData[{

Cell["(1 + d) - d", "Input",
  CellLabel->"In[41]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(1.`44.0126076459259\)], "Output",
  CellLabel->"Out[41]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["\<\
The precision of the result is now about 44 digits, rather than 34. \
\
\>", "MathCaption",
  CellTags->{"S3.1.5", "5.60"}],

Cell[CellGroupData[{

Cell["Precision[%]", "Input",
  CellLabel->"In[42]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(44.0126076459259`\)], "Output",
  CellLabel->"Out[42]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["SetPrecision", "MR"],
  " works by adding digits which are zero in base 2. Sometimes, ",
  StyleBox["Mathematica", "TI"],
  " stores slightly more digits in an arbitrary\[Hyphen]precision number than \
it displays, and in such cases, ",
  StyleBox["SetPrecision", "MR"],
  " will use these extra digits before introducing zeros. "
}], "Text",
  CellTags->{"S3.1.5", "5.61"}],

Cell["\<\
This creates a number with a precision of 40 decimal digits. The \
extra digits come from conversion to base 10. \
\>", "MathCaption",
  CellTags->{"S3.1.5", "5.62"}],

Cell[CellGroupData[{

Cell["SetPrecision[0.400000000000000, 40]", "Input",
  CellLabel->"In[43]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(0.40000000000000002220446049250313080847263336181640625`40. \)], \
"Output",
  CellLabel->"Out[43]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["variable", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["$MaxPrecision", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Infinity", "MR"],
              " "
            }]], Cell["maximum total precision to be used "]},
          {Cell[TextData[{
              StyleBox["$MinPrecision", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-Infinity", "MR"],
              " "
            }]], Cell["minimum precision to be used "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S3.1.5"],

Cell["Global precision control parameters. ", "Caption",
  CellTags->"S3.1.5"],

Cell[TextData[{
  "By making the global assignment ",
  StyleBox["$MinPrecision", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["n", "TI"],
  ", you can effectively apply ",
  StyleBox["SetPrecision[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " at every step in a computation. This means that even when the number of \
correct digits in an arbitrary\[Hyphen]precision number drops below ",
  StyleBox["n", "TI"],
  ", the number will always be padded to have ",
  StyleBox["n", "TI"],
  " digits. "
}], "Text",
  CellTags->{"S3.1.5", "5.63"}],

Cell[TextData[{
  "If you set ",
  StyleBox["$MaxPrecision", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["n", "TI"],
  " as well as ",
  StyleBox["$MinPrecision", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["n", "TI"],
  ", then you can force all arbitrary\[Hyphen]precision numbers to have a \
fixed precision of ",
  StyleBox["n", "TI"],
  " digits. In effect, what this does is to make ",
  StyleBox["Mathematica", "TI"],
  " treat arbitrary\[Hyphen]precision numbers in much the same way as it \
treats machine numbers\[LongDash]but with more digits of precision.  "
}], "Text",
  CellTags->{"S3.1.5", "5.64"}],

Cell["\<\
Fixed\[Hyphen]precision computation can make some calculations more \
efficient, but without careful analysis you can never be sure how many digits \
are correct in the results you get.  \
\>", "Text",
  CellTags->{"S3.1.5", "5.65"}],

Cell["\<\
Here is a small number with 20\[Hyphen]digit precision. \
\>", \
"MathCaption",
  CellTags->{"S3.1.5", "5.66"}],

Cell[CellGroupData[{

Cell["k = N[Exp[-60], 20]", "Input",
  CellLabel->"In[44]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(8.756510762696520338488732800739`20.*^-27\)], "Output",
  CellLabel->"Out[44]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["Mathematica", "TI"],
  "'s usual arithmetic, this works fine. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.67"}],

Cell[CellGroupData[{

Cell["Evaluate[1 + k] - 1", "Input",
  CellLabel->"In[45]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(8.756510762696520338488732800739`19.999999999999996*^-27\)], "Output",
  CellLabel->"Out[45]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " to use fixed\[Hyphen]precision arithmetic. "
}], "MathCaption",
  CellTags->{"S3.1.5", "5.68"}],

Cell[CellGroupData[{

Cell["$MinPrecision = $MaxPrecision = 20", "Input",
  CellLabel->"In[46]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(20\)], "Output",
  CellLabel->"Out[46]= ",
  CellTags->"S3.1.5"]
}, Open  ]],

Cell["The first few digits are correct, but the rest are wrong. ", \
"MathCaption",
  CellTags->{"S3.1.5", "5.69"}],

Cell[CellGroupData[{

Cell["Evaluate[1 + k] - 1", "Input",
  CellLabel->"In[47]:= ",
  CellTags->"S3.1.5"],

Cell[BoxData[
    \(8.7565107626963908935`20.*^-27\)], "Output",
  CellLabel->"Out[47]= ",
  CellTags->"S3.1.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
3.1.6 Machine\[Hyphen]Precision Numbers\
\>", "Subsection",
  CellTags->{"S3.1.6", "6.1"}],

Cell[TextData[{
  "Whenever machine\[Hyphen]precision numbers appear in a calculation, the \
whole calculation is typically done in machine precision. ",
  StyleBox["Mathematica", "TI"],
  " will then give machine\[Hyphen]precision numbers as the result. "
}], "Text",
  CellTags->{"S3.1.6", "6.2"}],

Cell[TextData[{
  "Whenever the input contains any machine\[Hyphen]precision numbers, ",
  StyleBox["Mathematica", "TI"],
  " does the computation to machine precision. "
}], "MathCaption",
  CellTags->{"S3.1.6", "6.3"}],

Cell[CellGroupData[{

Cell["1.4444444444444444444 ^ 5.7", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.1.6"],

Cell[BoxData[
    \(8.133824626581532`\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.1.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Zeta[5.6]", "MR"],
  " yields a machine\[Hyphen]precision result, so the ",
  StyleBox["N", "MR"],
  " is irrelevant. "
}], "MathCaption",
  CellTags->{"S3.1.6", "6.4"}],

Cell[CellGroupData[{

Cell["N[Zeta[5.6], 30]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.1.6"],

Cell[BoxData[
    \(1.0233754792270298`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.1.6"]
}, Open  ]],

Cell["\<\
This gives a higher\[Hyphen]precision result. \
\>", "MathCaption",
  CellTags->{"S3.1.6", "6.5"}],

Cell[CellGroupData[{

Cell["N[Zeta[56/10], 30]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.1.6"],

Cell[BoxData[
    \(1.023375479227029910860417881026012811450908405451`30. \)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.1.6"]
}, Open  ]],

Cell[TextData[{
  "When you do calculations with arbitrary\[Hyphen]precision numbers, as \
discussed in the previous section, ",
  StyleBox["Mathematica", "TI"],
  " always keeps track of the precision of your results, and gives only those \
digits which are known to be correct, given the precision of your input. When \
you do calculations with machine\[Hyphen]precision numbers, however, ",
  StyleBox["Mathematica", "TI"],
  " always gives you a machine\[Hyphen]precision result, whether or not all \
the digits in the result can, in fact, be determined to be correct on the \
basis of your input. "
}], "Text",
  CellTags->{"S3.1.6", "6.6"}],

Cell["\<\
This subtracts two machine\[Hyphen]precision numbers. \
\>", \
"MathCaption",
  CellTags->{"S3.1.6", "6.7"}],

Cell[CellGroupData[{

Cell["diff = 1.11111111 - 1.11111000", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.1.6"],

Cell[BoxData[
    \(1.1099999999153454`*^-6\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.1.6"]
}, Open  ]],

Cell["The result is taken to have machine precision. ", "MathCaption",
  CellTags->{"S3.1.6", "6.8"}],

Cell[CellGroupData[{

Cell["Precision[diff]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.1.6"],

Cell[BoxData[
    \(MachinePrecision\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.1.6"]
}, Open  ]],

Cell["Here are all the digits in the result. ", "MathCaption",
  CellTags->{"S3.1.6", "6.9"}],

Cell[CellGroupData[{

Cell["InputForm[diff]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.1.6"],

Cell["1.1099999999153454`*^-6", "Output",
  CellLabel->"Out[6]//InputForm= ",
  CellTags->"S3.1.6"]
}, Open  ]],

Cell[TextData[{
  "The fact that you can get spurious digits in machine\[Hyphen]precision \
numerical calculations with ",
  StyleBox["Mathematica", "TI"],
  " is in many respects quite unsatisfactory. The ultimate reason, however, \
that ",
  StyleBox["Mathematica", "TI"],
  " uses fixed precision for these calculations is a matter of computational \
efficiency. "
}], "Text",
  CellTags->{"S3.1.6", "6.10"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " is usually set up to insulate you as much as possible from the details of \
the computer system you are using. In dealing with machine\[Hyphen]precision \
numbers, you would lose too much, however, if ",
  StyleBox["Mathematica", "TI"],
  " did not make use of some specific features of your computer. "
}], "Text",
  CellTags->{"S3.1.6", "6.11"}],

Cell[TextData[{
  "The important point is that almost all computers have special hardware or \
microcode for doing floating\[Hyphen]point calculations to a particular fixed \
precision. ",
  StyleBox["Mathematica", "TI"],
  " makes use of these features when doing machine\[Hyphen]precision \
numerical calculations. "
}], "Text",
  CellTags->{"S3.1.6", "6.12"}],

Cell[TextData[{
  "The typical arrangement is that all machine\[Hyphen]precision numbers in \
",
  StyleBox["Mathematica", "TI"],
  " are represented as \[OpenCurlyDoubleQuote]double\[Hyphen]precision \
floating\[Hyphen]point numbers\[CloseCurlyDoubleQuote] in the underlying \
computer system. On most current computers, such numbers contain a total of \
64 binary bits, typically yielding 16 decimal digits of mantissa. "
}], "Text",
  CellTags->{"S3.1.6", "6.13"}],

Cell["\<\
The main advantage of using the built\[Hyphen]in \
floating\[Hyphen]point capabilities of your computer is speed. Arbitrary\
\[Hyphen]precision numerical calculations, which do not make such direct use \
of these capabilities, are usually many times slower than \
machine\[Hyphen]precision calculations. \
\>", "Text",
  CellTags->{"S3.1.6", "6.14"}],

Cell["\<\
There are several disadvantages of using built\[Hyphen]in floating\
\[Hyphen]point capabilities. One already mentioned is that it forces all \
numbers to have a fixed precision, independent of what precision can be \
justified for them. \
\>", "Text",
  CellTags->{"S3.1.6", "6.15"}],

Cell[TextData[{
  "A second disadvantage is that the treatment of machine\[Hyphen]precision \
numbers can vary slightly from one computer system to another. In working \
with machine\[Hyphen]precision numbers, ",
  StyleBox["Mathematica", "TI"],
  " is at the mercy of the floating\[Hyphen]point arithmetic system of each \
particular computer. If floating\[Hyphen]point arithmetic is done differently \
on two computers, you may get slightly different results for \
machine\[Hyphen]precision ",
  StyleBox["Mathematica", "TI"],
  " calculations on those computers.  "
}], "Text",
  CellTags->{"S3.1.6", "6.16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$MachinePrecision", "MR"],
              " "
            }]], Cell["the number of decimal digits of precision "]},
          {Cell[TextData[{
              StyleBox["$MachineEpsilon", "MR"],
              " "
            }]], 
            Cell["\<\
the minimum positive machine\[Hyphen]precision number \
which can be added to 1.0 to give a result distinguishable from 1.0 \
\>"]},
          {Cell[TextData[{
              StyleBox["$MaxMachineNumber", "MR"],
              " "
            }]], 
            Cell["\<\
the maximum machine\[Hyphen]precision number \
\>"]},
          {Cell[TextData[{
              StyleBox["$MinMachineNumber", "MR"],
              " "
            }]], 
            Cell["\<\
the minimum positive machine\[Hyphen]precision number \
\
\>"]},
          {Cell[TextData[{
              StyleBox["$MaxNumber", "MR"],
              " "
            }]], 
            Cell["\<\
the maximum magnitude of an arbitrary\[Hyphen]precision \
number \
\>"]},
          {Cell[TextData[{
              StyleBox["$MinNumber", "MR"],
              " "
            }]], 
            Cell["\<\
the minimum magnitude of a positive \
arbitrary\[Hyphen]precision number \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.6"],

Cell["Properties of numbers on a particular computer system. ", "Caption",
  CellTags->"S3.1.6"],

Cell[TextData[{
  "Since machine\[Hyphen]precision numbers on any particular computer system \
are represented by a definite number of binary bits, numbers which are too \
close together will have the same bit pattern, and so cannot be \
distinguished. The parameter ",
  StyleBox["$MachineEpsilon", "MR"],
  " gives the distance between ",
  StyleBox["1.0", "MR"],
  " and the closest number which has a distinct binary representation. "
}], "Text",
  CellTags->{"S3.1.6", "6.17"}],

Cell[TextData[{
  "This gives the value of ",
  StyleBox["$MachineEpsilon", "MR"],
  " for the computer system on which these examples are run. "
}], "MathCaption",
  CellTags->{"S3.1.6", "6.18"}],

Cell[CellGroupData[{

Cell["$MachineEpsilon", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.1.6"],

Cell[BoxData[
    \(2.220446049250313`*^-16\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.1.6"]
}, Open  ]],

Cell[TextData[{
  "Although this prints as ",
  StyleBox["1.", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " knows that the result is larger than 1. "
}], "MathCaption",
  CellTags->{"S3.1.6", "6.19"}],

Cell[CellGroupData[{

Cell["1. + $MachineEpsilon", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.1.6"],

Cell[BoxData[
    \(1.0000000000000002`\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.1.6"]
}, Open  ]],

Cell[TextData[{
  "Subtracting 1 gives ",
  StyleBox["$MachineEpsilon", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.6", "6.20"}],

Cell[CellGroupData[{

Cell["% - 1.", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.1.6"],

Cell[BoxData[
    \(2.220446049250313`*^-16\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.1.6"]
}, Open  ]],

Cell[TextData[{
  "This again prints as ",
  StyleBox["1.", "MR"],
  " "
}], "MathCaption",
  CellTags->{"S3.1.6", "6.21"}],

Cell[CellGroupData[{

Cell["1. + $MachineEpsilon/2", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.1.6"],

Cell[BoxData[
    \(1.`\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.1.6"]
}, Open  ]],

Cell[TextData[{
  "In this case, however, subtracting 1 yields 0, since ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["$MachineEpsilon/2", "MR"],
  " is not distinguished from ",
  StyleBox["1.", "MR"],
  " to machine precision. "
}], "MathCaption",
  CellTags->{"S3.1.6", "6.22"}],

Cell[CellGroupData[{

Cell["% - 1.", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.1.6"],

Cell[BoxData[
    \(0.`\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.1.6"]
}, Open  ]],

Cell[TextData[{
  "Machine numbers have not only limited precision, but also limited \
magnitude. If you generate a number which lies outside the range specified by \
",
  StyleBox["$MinMachineNumber", "MR"],
  " and ",
  StyleBox["$MaxMachineNumber", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will automatically convert the number to arbitrary\[Hyphen]precision \
form. "
}], "Text",
  CellTags->{"S3.1.6", "6.23"}],

Cell["\<\
This is the maximum machine\[Hyphen]precision number which can be \
handled on the computer system used for this example. \
\>", "MathCaption",
  CellTags->{"S3.1.6", "6.24"}],

Cell[CellGroupData[{

Cell["$MaxMachineNumber", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.1.6"],

Cell[BoxData[
    \(1.7976931348623157`*^308\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.1.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " automatically converts the result of this computation to arbitrary \
precision. "
}], "MathCaption",
  CellTags->{"S3.1.6", "6.25"}],

Cell[CellGroupData[{

Cell["Exp[1000.]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.1.6"],

Cell[BoxData[
    \(1.97007111401704699388887935224`12.954589770191003*^434\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.1.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.1.7 Advanced Topic: Interval Arithmetic", "Subsection",
  CellTags->{"S3.1.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Interval[{", "MR"],
              StyleBox["min", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["max", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the interval from ",
              StyleBox["min", "TI"],
              " to ",
              StyleBox["max", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Interval[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["min",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["max",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["min",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["max",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the union of intervals from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["min",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["max",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ",  ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["min",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["max",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ",  \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.7"],

Cell["Representations of real intervals. ", "Caption",
  CellTags->"S3.1.7"],

Cell[TextData[{
  "This represents all numbers between ",
  Cell[BoxData[
      \(TraditionalForm\`\(-2\)\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(+5\)\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.7", "7.2"}],

Cell[CellGroupData[{

Cell["Interval[{-2, 5}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \(Interval[{\(-2\), 5}]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.1.7"]
}, Open  ]],

Cell[TextData[{
  "The square of any number between ",
  Cell[BoxData[
      \(TraditionalForm\`\(-2\)\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(+5\)\)], "InlineFormula"],
  " is always between 0 and 25. "
}], "MathCaption",
  CellTags->{"S3.1.7", "7.3"}],

Cell[CellGroupData[{

Cell["Interval[{-2, 5}]^2", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \(Interval[{0, 25}]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.1.7"]
}, Open  ]],

Cell["Taking the reciprocal gives two distinct intervals. ", "MathCaption",
  CellTags->{"S3.1.7", "7.4"}],

Cell[CellGroupData[{

Cell["1/Interval[{-2, 5}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \(Interval[{\(-\[Infinity]\), \(-\(1\/2\)\)}, {1\/5, \[Infinity]}]\)], \
"Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.1.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Abs", "MR"],
  " folds the intervals back together again. "
}], "MathCaption",
  CellTags->{"S3.1.7", "7.5"}],

Cell[CellGroupData[{

Cell["Abs[%]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \(Interval[{1\/5, \[Infinity]}]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.1.7"]
}, Open  ]],

Cell["You can use intervals in many kinds of functions. ", "MathCaption",
  CellTags->{"S3.1.7", "7.6"}],

Cell[CellGroupData[{

Cell["Solve[3 x + 2 == Interval[{-2, 5}], x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \({{x \[Rule] Interval[{\(-\(4\/3\)\), 1}]}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.1.7"]
}, Open  ]],

Cell["Some functions automatically generate intervals. ", "MathCaption",
  CellTags->{"S3.1.7", "7.7"}],

Cell[CellGroupData[{

Cell["Limit[Sin[1/x], x -> 0]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \(Interval[{\(-1\), 1}]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.1.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["IntervalUnion[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["interval",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["interval",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["find the union of several intervals "]},
          {Cell[TextData[{
              StyleBox["IntervalIntersection[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["interval",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["interval",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["find the intersection of several intervals "]},
          {Cell[TextData[{
              StyleBox["IntervalMemberQ[", "MR"],
              StyleBox["interval", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether the point ",
              StyleBox["x", "TI"],
              " lies within an interval "
            }]]},
          {Cell[TextData[{
              StyleBox["IntervalMemberQ[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["interval",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["interval",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["interval",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " lies completely within ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["interval",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.7"],

Cell["Operations on intervals. ", "Caption",
  CellTags->"S3.1.7"],

Cell["This finds the overlap of the two intervals. ", "MathCaption",
  CellTags->{"S3.1.7", "7.8"}],

Cell[CellGroupData[{

Cell["IntervalIntersection[Interval[{3, 7}], Interval[{-2, 5}]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \(Interval[{3, 5}]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.1.7"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Max", "MR"],
  " and ",
  StyleBox["Min", "MR"],
  " to find the end points of intervals. "
}], "MathCaption",
  CellTags->{"S3.1.7", "7.9"}],

Cell[CellGroupData[{

Cell["Max[%]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.1.7"]
}, Open  ]],

Cell["\<\
This finds out which of a list of intervals contains the point 7.   \
\
\>", "MathCaption",
  CellTags->{"S3.1.7", "7.10"}],

Cell[CellGroupData[{

Cell["\<\
IntervalMemberQ[ Table[Interval[{i, i+1}], {i, 1, 20, 3}], 7]\
\>", \
"Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \({False, False, True, False, False, False, False}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.1.7"]
}, Open  ]],

Cell[TextData[{
  "You can use intervals not only with exact quantities but also with \
approximate numbers. Even with machine\[Hyphen]precision numbers, ",
  StyleBox["Mathematica", "TI"],
  " always tries to do rounding in such a way as to preserve the validity of \
results.  "
}], "Text",
  CellTags->{"S3.1.7", "7.11"}],

Cell[TextData[{
  "This shows explicitly the interval treated by ",
  StyleBox["Mathematica", "TI"],
  " as the machine\[Hyphen]precision number ",
  StyleBox["0.", "MR"],
  " "
}], "MathCaption",
  CellTags->{"S3.1.7", "7.12"}],

Cell[CellGroupData[{

Cell["Interval[0.]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \(Interval[{\(-2.2250738585072014`*^-308\), 
        2.2250738585072014`*^-308}]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.1.7"]
}, Open  ]],

Cell[TextData[{
  "This shows the corresponding interval around ",
  StyleBox["100.", "MR"],
  ", shifted back to zero. "
}], "MathCaption",
  CellTags->{"S3.1.7", "7.13"}],

Cell[CellGroupData[{

Cell["Interval[100.] - 100", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \(Interval[{\(-1.4210854715202007`*^-14\), 
        1.4210854715202007`*^-14}]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.1.7"]
}, Open  ]],

Cell["The same kind of thing works with numbers of any precision. ", \
"MathCaption",
  CellTags->{"S3.1.7", "7.14"}],

Cell[CellGroupData[{

Cell["Interval[N[Pi, 50]] - Pi", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \(Interval[{\(-8.55284707229502606`0.4349608340769259*^-50\), 
        8.55284707229502607`0.4349608340769259*^-50}]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.1.7"]
}, Open  ]],

Cell["\<\
With ordinary machine\[Hyphen]precision arithmetic, this \
computation gives an incorrect result. \
\>", "MathCaption",
  CellTags->{"S3.1.7", "7.15"}],

Cell[CellGroupData[{

Cell["Sin[N[Pi]]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \(1.2246063538223773`*^-16\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.1.7"]
}, Open  ]],

Cell["\<\
The interval generated here, however, includes the correct value of \
0. \
\>", "MathCaption",
  CellTags->{"S3.1.7", "7.16"}],

Cell[CellGroupData[{

Cell["Sin[Interval[N[Pi]]]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.1.7"],

Cell[BoxData[
    \(Interval[{\(-3.2162857446782494`*^-16\), 
        5.665498452323004`*^-16}]\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.1.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.1.8 Advanced Topic: Indeterminate and Infinite Results", "Subsection",
  CellTags->{"S3.1.8", "8.1"}],

Cell[TextData[{
  "If you type in an expression like ",
  StyleBox["0/0", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " prints a message, and returns the result ",
  StyleBox["Indeterminate", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.8", "8.2"}],

Cell[CellGroupData[{

Cell["0/0", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0\) encountered."\)], "Message",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(\[Infinity]::"indet" \(\(:\)\(\ \)\) 
      "Indeterminate expression \!\(0\\ ComplexInfinity\) encountered."\)], \
"Message",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(Indeterminate\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.1.8"]
}, Open  ]],

Cell[TextData[{
  "An expression like ",
  StyleBox["0/0", "MR"],
  " is an example of an ",
  StyleBox["indeterminate numerical result", "TI"],
  ". If you type in ",
  StyleBox["0/0", "MR"],
  ", there is no way for ",
  StyleBox["Mathematica", "TI"],
  " to know what answer you want. If you got ",
  StyleBox["0/0", "MR"],
  " by taking the limit of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "/", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "\[Rule]", "0"}], TraditionalForm]], "InlineFormula"],
  ", then you might want the answer ",
  StyleBox["1", "MR"],
  ". On the other hand, if you got ",
  StyleBox["0/0", "MR"],
  " instead as the limit of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"2", 
          StyleBox["x",
            "TI"], "/", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ", then you probably want the answer ",
  StyleBox["2", "MR"],
  ". The expression ",
  StyleBox["0/0", "MR"],
  " on its own does not contain enough information to choose between these \
and other cases. As a result, its value must be considered indeterminate.  "
}], "Text",
  CellTags->{"S3.1.8", "8.3"}],

Cell[TextData[{
  "Whenever an indeterminate result is produced in an arithmetic computation, \
",
  StyleBox["Mathematica", "TI"],
  " prints a warning message, and then returns ",
  StyleBox["Indeterminate", "MR"],
  " as the result of the computation. If you ever try to use ",
  StyleBox["Indeterminate", "MR"],
  " in an arithmetic computation, you always get the result ",
  StyleBox["Indeterminate", "MR"],
  ". A single indeterminate expression effectively \
\[OpenCurlyDoubleQuote]poisons\[CloseCurlyDoubleQuote] any arithmetic \
computation. (The symbol ",
  StyleBox["Indeterminate", "MR"],
  " plays a role in ",
  StyleBox["Mathematica", "TI"],
  " similar to the \[OpenCurlyDoubleQuote]not a \
number\[CloseCurlyDoubleQuote] object in the IEEE Floating Point Standard.)  \
"
}], "Text",
  CellTags->{"S3.1.8", "8.4"}],

Cell[TextData[{
  "The usual laws of arithmetic simplification are suspended in the case of \
",
  StyleBox["Indeterminate", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.8", "8.5"}],

Cell[CellGroupData[{

Cell["Indeterminate - Indeterminate", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(Indeterminate\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.1.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Indeterminate", "MR"],
  " \[OpenCurlyDoubleQuote]poisons\[CloseCurlyDoubleQuote] any arithmetic \
computation, and leads to an indeterminate result. "
}], "MathCaption",
  CellTags->{"S3.1.8", "8.6"}],

Cell[CellGroupData[{

Cell["2 Indeterminate - 7", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(Indeterminate\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.1.8"]
}, Open  ]],

Cell[TextData[{
  "When you do arithmetic computations inside ",
  StyleBox["Mathematica", "TI"],
  " programs, it is often important to be able to tell whether indeterminate \
results were generated in the computations. You can do this by using the \
function ",
  StyleBox["Check", "MR"],
  " discussed in Section\[NonBreakingSpace]",
  ButtonBox["2.9.21",
    ButtonData:>{"2.9.21", "21.23"},
    ButtonStyle->"MainBookLink"],
  " to test whether any warning messages associated with indeterminate \
results were produced. "
}], "Text",
  CellTags->{"S3.1.8", "8.7"}],

Cell[TextData[{
  "You can use ",
  StyleBox["Check", "MR"],
  " inside a program to test whether warning messages are generated in a \
computation. "
}], "MathCaption",
  CellTags->{"S3.1.8", "8.8"}],

Cell[CellGroupData[{

Cell["Check[(7 - 7)/(8 - 8), meaningless]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0\) encountered."\)], "Message",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(\[Infinity]::"indet" \(\(:\)\(\ \)\) 
      "Indeterminate expression \!\(0\\ ComplexInfinity\) encountered."\)], \
"Message",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(meaningless\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.1.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Indeterminate", "MR"],
              " "
            }]], Cell["an indeterminate numerical result "]},
          {Cell[TextData[{
              StyleBox["Infinity", "MR"],
              " "
            }]], Cell["a positive infinite quantity "]},
          {Cell[TextData[{
              StyleBox["-Infinity", "MR"],
              " "
            }]], Cell[TextData[{
              "a negative infinite quantity (",
              StyleBox["DirectedInfinity[-1]", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["DirectedInfinity[", "MR"],
              StyleBox["r", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "an infinite quantity with complex direction ",
              StyleBox["r", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ComplexInfinity", "MR"],
              " "
            }]], Cell[
            "an infinite quantity with an undetermined direction "]},
          {Cell[TextData[{
              StyleBox["DirectedInfinity[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "equivalent to ",
              StyleBox["ComplexInfinity", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.8"],

Cell["Indeterminate and infinite quantities. ", "Caption",
  CellTags->"S3.1.8"],

Cell[TextData[{
  "There are many situations where it is convenient to be able to do \
calculations with infinite quantities. The symbol ",
  StyleBox["Infinity", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " represents a positive infinite quantity. You can use it to specify such \
things as limits of sums and integrals. You can also do some arithmetic \
calculations with it. "
}], "Text",
  CellTags->{"S3.1.8", "8.9"}],

Cell["Here is an integral with an infinite limit. ", "MathCaption",
  CellTags->{"S3.1.8", "8.10"}],

Cell[CellGroupData[{

Cell["Integrate[1/x^3, {x, 1, Infinity}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(1\/2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.1.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " knows that ",
  Cell[BoxData[
      \(TraditionalForm\`1/\[Infinity] = 0\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.8", "8.11"}],

Cell[CellGroupData[{

Cell["1/Infinity", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.1.8"]
}, Open  ]],

Cell["\<\
If you try to find the difference between two infinite quantities, \
you get an indeterminate result. \
\>", "MathCaption",
  CellTags->{"S3.1.8", "8.12"}],

Cell[CellGroupData[{

Cell["Infinity - Infinity", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(\[Infinity]::"indet" \(\(:\)\(\ \)\) 
      "Indeterminate expression \!\(\(\(-\[Infinity]\)\) + \[Infinity]\) \
encountered."\)], "Message",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(Indeterminate\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.1.8"]
}, Open  ]],

Cell[TextData[{
  "There are a number of subtle points that arise in handling infinite \
quantities. One of them concerns the \[OpenCurlyDoubleQuote]direction\
\[CloseCurlyDoubleQuote] of an infinite quantity. When you do an infinite \
integral, you typically think of performing the integration along a path in \
the complex plane that goes to infinity in some direction. In this case, it \
is important to distinguish different versions of infinity that correspond to \
different directions in the complex plane. ",
  Cell[BoxData[
      \(TraditionalForm\`\(+\[Infinity]\)\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " are two examples, but for some purposes one also needs ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["i",
            "TI"], "\[Infinity]"}], TraditionalForm]], "InlineFormula"],
  " and so on.  "
}], "Text",
  CellTags->{"S3.1.8", "8.13"}],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica", "TI"],
  ", infinite quantities can have a \[OpenCurlyDoubleQuote]direction\
\[CloseCurlyDoubleQuote], specified by a complex number. When you type in the \
symbol ",
  StyleBox["Infinity", "MR"],
  ", representing a positive infinite quantity, this is converted internally \
to the form ",
  StyleBox["DirectedInfinity[1]", "MR"],
  ", which represents an infinite quantity in the ",
  Cell[BoxData[
      \(TraditionalForm\`\(+1\)\)], "InlineFormula"],
  " direction. Similarly, ",
  StyleBox["-Infinity", "MR"],
  " becomes ",
  StyleBox["DirectedInfinity[-1]", "MR"],
  ", and ",
  StyleBox["I", "MR"],
  " ",
  StyleBox["Infinity", "MR"],
  " becomes ",
  StyleBox["DirectedInfinity[I]", "MR"],
  ". Although the ",
  StyleBox["DirectedInfinity", "MR"],
  " form is always used internally, the standard output format for ",
  StyleBox["DirectedInfinity[", "MR"],
  StyleBox["r", "TI"],
  StyleBox["]", "MR"],
  " is ",
  StyleBox["r", "TI"],
  " ",
  StyleBox["Infinity", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.1.8", "8.14"}],

Cell[TextData[{
  StyleBox["Infinity", "MR"],
  " is converted internally to ",
  StyleBox["DirectedInfinity[1]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.8", "8.15"}],

Cell[CellGroupData[{

Cell["Infinity // FullForm", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.1.8"],

Cell[BoxData[
    TagBox[
      StyleBox[\(DirectedInfinity[1]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[8]//FullForm= ",
  CellTags->"S3.1.8"]
}, Open  ]],

Cell[TextData[{
  "Although the notion of a \[OpenCurlyDoubleQuote]directed infinity\
\[CloseCurlyDoubleQuote] is often useful, it is not always available. If you \
type in ",
  StyleBox["1/0", "MR"],
  ", you get an infinite result, but there is no way to determine the \
\[OpenCurlyDoubleQuote]direction\[CloseCurlyDoubleQuote] of the infinity. ",
  StyleBox["Mathematica", "TI"],
  " represents the result of ",
  StyleBox["1/0", "MR"],
  " as ",
  StyleBox["DirectedInfinity[", "MR"],
  " ",
  StyleBox["]", "MR"],
  ". In standard output form, this undirected infinity is printed out as ",
  StyleBox["ComplexInfinity", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.1.8", "8.16"}],

Cell[TextData[{
  StyleBox["1/0", "MR"],
  " gives an undirected form of infinity. "
}], "MathCaption",
  CellTags->{"S3.1.8", "8.17"}],

Cell[CellGroupData[{

Cell["1/0", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0\) encountered."\)], "Message",
  CellTags->"S3.1.8"],

Cell[BoxData[
    \(ComplexInfinity\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.1.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.1.9 Advanced Topic: Controlling Numerical Evaluation", "Subsection",
  CellTags->{"S3.1.9", "9.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NHoldAll", "MR"],
              " "
            }]], Cell[TextData[{
              
              "prevent any arguments of a function from being affected by\
\[NonBreakingSpace]",
              StyleBox["N", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NHoldFirst", "MR"],
              " "
            }]], Cell["prevent the first argument from being affected "]},
          {Cell[TextData[{
              StyleBox["NHoldRest", "MR"],
              " "
            }]], Cell[
            "prevent all but the first argument from being affected "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.1.9"],

Cell["Attributes for controlling numerical evaluation. ", "Caption",
  CellTags->"S3.1.9"],

Cell[TextData[{
  "Usually ",
  StyleBox["N", "MR"],
  " goes inside functions and gets applied to each of their arguments. "
}], "MathCaption",
  CellTags->{"S3.1.9", "9.2"}],

Cell[CellGroupData[{

Cell["N[f[2/3, Pi]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.1.9"],

Cell[BoxData[
    \(f[0.6666666666666666`, 3.141592653589793`]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.1.9"]
}, Open  ]],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " not to apply ",
  StyleBox["N", "MR"],
  " to the first argument of ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.1.9", "9.3"}],

Cell["SetAttributes[f, NHoldFirst]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.1.9"],

Cell[TextData[{
  "Now the first argument of ",
  StyleBox["f", "MR"],
  " is left in its exact form. "
}], "MathCaption",
  CellTags->{"S3.1.9", "9.4"}],

Cell[CellGroupData[{

Cell["N[f[2/3, Pi]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.1.9"],

Cell[BoxData[
    \(f[2\/3, 3.141592653589793`]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.1.9"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{50, Automatic}, {Automatic, 29}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S3.1.0"->{
    Cell[1776, 53, 110, 4, 65, "Section",
      CellTags->{"S3.1.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 110, 4, 65, "Section",
      CellTags->{"S3.1.0", "0.1"}]},
  "S3.1.1"->{
    Cell[1911, 61, 75, 1, 70, "Subsection",
      CellTags->{"S3.1.1", "1.1"}],
    Cell[1989, 64, 152, 5, 70, "Text",
      CellTags->{"S3.1.1", "1.2"}],
    Cell[2144, 71, 1220, 39, 70, "DefinitionBox",
      CellTags->"S3.1.1"],
    Cell[3367, 112, 127, 5, 70, "Caption",
      CellTags->"S3.1.1"],
    Cell[3497, 119, 149, 4, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.3"}],
    Cell[3671, 127, 74, 2, 70, "Input",
      CellTags->"S3.1.1"],
    Cell[3748, 131, 91, 3, 70, "Output",
      CellTags->"S3.1.1"],
    Cell[3854, 137, 153, 4, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.4"}],
    Cell[4032, 145, 69, 2, 70, "Input",
      CellTags->"S3.1.1"],
    Cell[4104, 149, 87, 3, 70, "Output",
      CellTags->"S3.1.1"],
    Cell[4206, 155, 114, 2, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.5"}],
    Cell[4345, 161, 98, 2, 70, "Input",
      CellTags->"S3.1.1"],
    Cell[4446, 165, 134, 3, 70, "Output",
      CellTags->"S3.1.1"],
    Cell[4595, 171, 113, 2, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.6"}],
    Cell[4733, 177, 73, 2, 70, "Input",
      CellTags->"S3.1.1"],
    Cell[4809, 181, 108, 3, 70, "Output",
      CellTags->"S3.1.1"],
    Cell[4932, 187, 109, 1, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.7"}],
    Cell[5066, 192, 73, 2, 70, "Input",
      CellTags->"S3.1.1"],
    Cell[5142, 196, 104, 3, 70, "Output",
      CellTags->"S3.1.1"],
    Cell[5261, 202, 1002, 30, 70, "DefinitionBox",
      CellTags->"S3.1.1"],
    Cell[6266, 234, 77, 1, 70, "Caption",
      CellTags->"S3.1.1"],
    Cell[6346, 237, 338, 8, 70, "Text",
      CellTags->{"S3.1.1", "1.8"}],
    Cell[6687, 247, 193, 7, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.9"}],
    Cell[6905, 258, 73, 2, 70, "Input",
      CellTags->"S3.1.1"],
    Cell[6981, 262, 88, 3, 70, "Output",
      CellTags->"S3.1.1"],
    Cell[7084, 268, 273, 9, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.10"}],
    Cell[7382, 281, 74, 2, 70, "Input",
      CellTags->"S3.1.1"],
    Cell[7459, 285, 85, 3, 70, "Output",
      CellTags->"S3.1.1"],
    Cell[7559, 291, 1977, 63, 70, "DefinitionBox",
      CellTags->"S3.1.1"],
    Cell[9539, 356, 78, 1, 70, "Caption",
      CellTags->"S3.1.1"],
    Cell[9620, 359, 178, 6, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.11"}],
    Cell[9823, 369, 76, 2, 70, "Input",
      CellTags->"S3.1.1"],
    Cell[9902, 373, 85, 3, 70, "Output",
      CellTags->"S3.1.1"],
    Cell[10002, 379, 227, 10, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.12"}],
    Cell[10254, 393, 76, 2, 70, "Input",
      CellTags->"S3.1.1"],
    Cell[10333, 397, 86, 3, 70, "Output",
      CellTags->"S3.1.1"],
    Cell[10434, 403, 485, 11, 70, "Text",
      CellTags->{"S3.1.1", "1.13"}],
    Cell[10922, 416, 228, 7, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.14"}],
    Cell[11175, 427, 82, 2, 70, "Input",
      CellTags->"S3.1.1"],
    Cell[11260, 431, 89, 3, 70, "Output",
      CellTags->"S3.1.1"],
    Cell[11364, 437, 208, 5, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.15"}],
    Cell[11597, 446, 84, 2, 70, "Input",
      CellTags->"S3.1.1"],
    Cell[11684, 450, 89, 3, 70, "Output",
      CellTags->"S3.1.1"],
    Cell[11788, 456, 467, 10, 70, "Text",
      CellTags->{"S3.1.1", "1.16"}],
    Cell[12258, 468, 767, 22, 70, "Text",
      CellTags->{"S3.1.1", "1.17"}]},
  "1.1"->{
    Cell[1911, 61, 75, 1, 70, "Subsection",
      CellTags->{"S3.1.1", "1.1"}]},
  "1.2"->{
    Cell[1989, 64, 152, 5, 70, "Text",
      CellTags->{"S3.1.1", "1.2"}]},
  "1.3"->{
    Cell[3497, 119, 149, 4, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.3"}]},
  "1.4"->{
    Cell[3854, 137, 153, 4, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.4"}]},
  "1.5"->{
    Cell[4206, 155, 114, 2, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.5"}]},
  "1.6"->{
    Cell[4595, 171, 113, 2, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.6"}]},
  "1.7"->{
    Cell[4932, 187, 109, 1, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.7"}]},
  "1.8"->{
    Cell[6346, 237, 338, 8, 70, "Text",
      CellTags->{"S3.1.1", "1.8"}]},
  "1.9"->{
    Cell[6687, 247, 193, 7, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.9"}]},
  "1.10"->{
    Cell[7084, 268, 273, 9, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.10"}]},
  "1.11"->{
    Cell[9620, 359, 178, 6, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.11"}]},
  "1.12"->{
    Cell[10002, 379, 227, 10, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.12"}]},
  "1.13"->{
    Cell[10434, 403, 485, 11, 70, "Text",
      CellTags->{"S3.1.1", "1.13"}]},
  "1.14"->{
    Cell[10922, 416, 228, 7, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.14"}]},
  "1.15"->{
    Cell[11364, 437, 208, 5, 70, "MathCaption",
      CellTags->{"S3.1.1", "1.15"}]},
  "1.16"->{
    Cell[11788, 456, 467, 10, 70, "Text",
      CellTags->{"S3.1.1", "1.16"}]},
  "1.17"->{
    Cell[12258, 468, 767, 22, 70, "Text",
      CellTags->{"S3.1.1", "1.17"}]},
  "S3.1.2"->{
    Cell[13062, 495, 77, 1, 70, "Subsection",
      CellTags->{"S3.1.2", "2.1"}],
    Cell[13142, 498, 846, 26, 70, "DefinitionBox",
      CellTags->"S3.1.2"],
    Cell[13991, 526, 73, 1, 70, "Caption",
      CellTags->"S3.1.2"],
    Cell[14067, 529, 230, 10, 70, "MathCaption",
      CellTags->{"S3.1.2", "2.2"}],
    Cell[14322, 543, 79, 2, 70, "Input",
      CellTags->"S3.1.2"],
    Cell[14404, 547, 86, 3, 70, "Output",
      CellTags->"S3.1.2"],
    Cell[14505, 553, 94, 1, 70, "MathCaption",
      CellTags->{"S3.1.2", "2.3"}],
    Cell[14624, 558, 80, 2, 70, "Input",
      CellTags->"S3.1.2"],
    Cell[14707, 562, 85, 3, 70, "Output",
      CellTags->"S3.1.2"],
    Cell[14807, 568, 205, 9, 70, "MathCaption",
      CellTags->{"S3.1.2", "2.4"}],
    Cell[15037, 581, 73, 2, 70, "Input",
      CellTags->"S3.1.2"],
    Cell[15113, 585, 99, 3, 70, "Output",
      CellTags->"S3.1.2"],
    Cell[15227, 591, 369, 11, 70, "Text",
      CellTags->{"S3.1.2", "2.5"}],
    Cell[15599, 604, 240, 10, 70, "MathCaption",
      CellTags->{"S3.1.2", "2.6"}],
    Cell[15864, 618, 104, 2, 70, "Input",
      CellTags->"S3.1.2"],
    Cell[15971, 622, 94, 3, 70, "Output",
      CellTags->"S3.1.2"],
    Cell[16080, 628, 138, 4, 70, "MathCaption",
      CellTags->{"S3.1.2", "2.7"}],
    Cell[16243, 636, 92, 2, 70, "Input",
      CellTags->"S3.1.2"],
    Cell[16338, 640, 87, 3, 70, "Output",
      CellTags->"S3.1.2"],
    Cell[16440, 646, 605, 14, 70, "Text",
      CellTags->{"S3.1.2", "2.8"}]},
  "2.1"->{
    Cell[13062, 495, 77, 1, 70, "Subsection",
      CellTags->{"S3.1.2", "2.1"}]},
  "2.2"->{
    Cell[14067, 529, 230, 10, 70, "MathCaption",
      CellTags->{"S3.1.2", "2.2"}]},
  "2.3"->{
    Cell[14505, 553, 94, 1, 70, "MathCaption",
      CellTags->{"S3.1.2", "2.3"}]},
  "2.4"->{
    Cell[14807, 568, 205, 9, 70, "MathCaption",
      CellTags->{"S3.1.2", "2.4"}]},
  "2.5"->{
    Cell[15227, 591, 369, 11, 70, "Text",
      CellTags->{"S3.1.2", "2.5"}]},
  "2.6"->{
    Cell[15599, 604, 240, 10, 70, "MathCaption",
      CellTags->{"S3.1.2", "2.6"}]},
  "2.7"->{
    Cell[16080, 628, 138, 4, 70, "MathCaption",
      CellTags->{"S3.1.2", "2.7"}]},
  "2.8"->{
    Cell[16440, 646, 605, 14, 70, "Text",
      CellTags->{"S3.1.2", "2.8"}]},
  "S3.1.3"->{
    Cell[17082, 665, 76, 1, 70, "Subsection",
      CellTags->{"S3.1.3", "3.1"}],
    Cell[17161, 668, 5110, 158, 70, "DefinitionBox",
      CellTags->"S3.1.3"],
    Cell[22274, 828, 89, 1, 70, "Caption",
      CellTags->"S3.1.3"],
    Cell[22366, 831, 105, 1, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.2"}],
    Cell[22496, 836, 93, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[22592, 840, 107, 3, 70, "Output",
      CellTags->"S3.1.3"],
    Cell[22714, 846, 174, 4, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.3"}],
    Cell[22913, 854, 93, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[23009, 858, 134, 3, 70, "Output",
      CellTags->"S3.1.3"],
    Cell[23158, 864, 157, 4, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.4"}],
    Cell[23340, 872, 87, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[23430, 876, 105, 3, 70, "Output",
      CellTags->"S3.1.3"],
    Cell[23550, 882, 134, 4, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.5"}],
    Cell[23709, 890, 80, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[23792, 894, 83, 3, 70, "Output",
      CellTags->"S3.1.3"],
    Cell[23890, 900, 920, 30, 70, "DefinitionBox",
      CellTags->"S3.1.3"],
    Cell[24813, 932, 65, 1, 70, "Caption",
      CellTags->"S3.1.3"],
    Cell[24881, 935, 231, 9, 70, "Text",
      CellTags->{"S3.1.3", "3.6"}],
    Cell[25115, 946, 259, 9, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.7"}],
    Cell[25399, 959, 73, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[25475, 963, 83, 3, 70, "Output",
      CellTags->"S3.1.3"],
    Cell[25573, 969, 166, 6, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.8"}],
    Cell[25764, 979, 79, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[25846, 983, 201, 7, 70, "Output",
      CellTags->"S3.1.3"],
    Cell[26062, 993, 83, 1, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.9"}],
    Cell[26170, 998, 76, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[26249, 1002, 91, 3, 70, "Output",
      CellTags->"S3.1.3"],
    Cell[26355, 1008, 151, 4, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.10"}],
    Cell[26531, 1016, 87, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[26621, 1020, 89, 3, 70, "Output",
      CellTags->"S3.1.3"],
    Cell[26725, 1026, 89, 1, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.11"}],
    Cell[26839, 1031, 79, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[26921, 1035, 209, 7, 70, "Output",
      CellTags->"S3.1.3"],
    Cell[27145, 1045, 141, 4, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.12"}],
    Cell[27311, 1053, 78, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[27392, 1057, 91, 3, 70, "Output",
      CellTags->"S3.1.3"],
    Cell[27498, 1063, 188, 6, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.13"}],
    Cell[27711, 1073, 92, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[27806, 1077, 296, 7, 70, "Output",
      CellTags->"S3.1.3"],
    Cell[28117, 1087, 115, 2, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.14"}],
    Cell[28257, 1093, 91, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[28351, 1097, 132, 3, 70, "Output",
      CellTags->"S3.1.3"],
    Cell[28498, 1103, 213, 6, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.15"}],
    Cell[28736, 1113, 96, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[28835, 1117, 137, 3, 70, "Output",
      CellTags->"S3.1.3"],
    Cell[28987, 1123, 373, 10, 70, "Text",
      CellTags->{"S3.1.3", "3.16"}],
    Cell[29363, 1135, 960, 29, 70, "DefinitionBox",
      CellTags->"S3.1.3"],
    Cell[30326, 1166, 90, 1, 70, "Caption",
      CellTags->"S3.1.3"],
    Cell[30419, 1169, 147, 4, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.17"}],
    Cell[30591, 1177, 94, 2, 70, "Input",
      CellTags->"S3.1.3"],
    Cell[30688, 1181, 95, 3, 70, "Output",
      CellTags->"S3.1.3"]},
  "3.1"->{
    Cell[17082, 665, 76, 1, 70, "Subsection",
      CellTags->{"S3.1.3", "3.1"}]},
  "3.2"->{
    Cell[22366, 831, 105, 1, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.2"}]},
  "3.3"->{
    Cell[22714, 846, 174, 4, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.3"}]},
  "3.4"->{
    Cell[23158, 864, 157, 4, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.4"}]},
  "3.5"->{
    Cell[23550, 882, 134, 4, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.5"}]},
  "3.6"->{
    Cell[24881, 935, 231, 9, 70, "Text",
      CellTags->{"S3.1.3", "3.6"}]},
  "3.7"->{
    Cell[25115, 946, 259, 9, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.7"}]},
  "3.8"->{
    Cell[25573, 969, 166, 6, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.8"}]},
  "3.9"->{
    Cell[26062, 993, 83, 1, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.9"}]},
  "3.10"->{
    Cell[26355, 1008, 151, 4, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.10"}]},
  "3.11"->{
    Cell[26725, 1026, 89, 1, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.11"}]},
  "3.12"->{
    Cell[27145, 1045, 141, 4, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.12"}]},
  "3.13"->{
    Cell[27498, 1063, 188, 6, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.13"}]},
  "3.14"->{
    Cell[28117, 1087, 115, 2, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.14"}]},
  "3.15"->{
    Cell[28498, 1103, 213, 6, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.15"}]},
  "3.16"->{
    Cell[28987, 1123, 373, 10, 70, "Text",
      CellTags->{"S3.1.3", "3.16"}]},
  "3.17"->{
    Cell[30419, 1169, 147, 4, 70, "MathCaption",
      CellTags->{"S3.1.3", "3.17"}]},
  "S3.1.4"->{
    Cell[30832, 1190, 78, 1, 70, "Subsection",
      CellTags->{"S3.1.4", "4.1"}],
    Cell[30913, 1193, 770, 18, 70, "Text",
      CellTags->{"S3.1.4", "4.2"}],
    Cell[31686, 1213, 910, 28, 70, "DefinitionBox",
      CellTags->"S3.1.4"],
    Cell[32599, 1243, 81, 1, 70, "Caption",
      CellTags->"S3.1.4"],
    Cell[32683, 1246, 121, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.3"}],
    Cell[32829, 1254, 80, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[32912, 1258, 129, 3, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[33056, 1264, 94, 1, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.4"}],
    Cell[33175, 1269, 76, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[33254, 1273, 85, 3, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[33354, 1279, 155, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.5"}],
    Cell[33534, 1287, 75, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[33612, 1291, 100, 3, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[33727, 1297, 130, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.6"}],
    Cell[33882, 1305, 72, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[33957, 1309, 136, 3, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[34108, 1315, 101, 1, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.7"}],
    Cell[34234, 1320, 91, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[34328, 1324, 107, 3, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[34450, 1330, 331, 6, 70, "Text",
      CellTags->{"S3.1.4", "4.8"}],
    Cell[34784, 1338, 1687, 56, 70, "Text",
      CellTags->{"S3.1.4", "4.9"}],
    Cell[36474, 1396, 1171, 33, 70, "DefinitionBox",
      CellTags->"S3.1.4"],
    Cell[37648, 1431, 114, 4, 70, "Caption",
      CellTags->"S3.1.4"],
    Cell[37765, 1437, 150, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.10"}],
    Cell[37940, 1445, 91, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[38034, 1449, 245, 5, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[38294, 1457, 1061, 33, 70, "DefinitionBox",
      CellTags->"S3.1.4"],
    Cell[39358, 1492, 144, 4, 70, "Caption",
      CellTags->"S3.1.4"],
    Cell[39505, 1498, 577, 13, 70, "Text",
      CellTags->{"S3.1.4", "4.11"}],
    Cell[40085, 1513, 198, 6, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.12"}],
    Cell[40308, 1523, 69, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[40380, 1527, 99, 3, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[40494, 1533, 117, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.13"}],
    Cell[40636, 1541, 85, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[40724, 1545, 175, 4, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[40914, 1552, 463, 8, 70, "Text",
      CellTags->{"S3.1.4", "4.14"}],
    Cell[41380, 1562, 945, 32, 70, "DefinitionBox",
      CellTags->"S3.1.4"],
    Cell[42328, 1596, 58, 1, 70, "Caption",
      CellTags->"S3.1.4"],
    Cell[42389, 1599, 170, 5, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.15"}],
    Cell[42584, 1608, 82, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[42669, 1612, 97, 3, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[42781, 1618, 142, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.16"}],
    Cell[42948, 1626, 82, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[43033, 1630, 101, 3, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[43149, 1636, 524, 12, 70, "Text",
      CellTags->{"S3.1.4", "4.17"}],
    Cell[43676, 1650, 2275, 74, 70, "DefinitionBox",
      CellTags->"S3.1.4"],
    Cell[45954, 1726, 66, 1, 70, "Caption",
      CellTags->"S3.1.4"],
    Cell[46023, 1729, 444, 11, 70, "Text",
      CellTags->{"S3.1.4", "4.18"}],
    Cell[46470, 1742, 177, 5, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.19"}],
    Cell[46672, 1751, 70, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[46745, 1755, 100, 3, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[46860, 1761, 158, 5, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.20"}],
    Cell[47043, 1770, 77, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[47123, 1774, 94, 2, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[47232, 1779, 136, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.21"}],
    Cell[47393, 1787, 74, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[47470, 1791, 126, 3, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[47611, 1797, 257, 6, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.22"}],
    Cell[47893, 1807, 77, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[47973, 1811, 120, 2, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[48108, 1816, 157, 5, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.23"}],
    Cell[48290, 1825, 97, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[48390, 1829, 116, 2, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[48521, 1834, 1376, 42, 70, "DefinitionBox",
      CellTags->"S3.1.4"],
    Cell[49900, 1878, 74, 1, 70, "Caption",
      CellTags->"S3.1.4"],
    Cell[49977, 1881, 526, 18, 70, "Text",
      CellTags->{"S3.1.4", "4.24"}],
    Cell[50506, 1901, 176, 5, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.25"}],
    Cell[50707, 1910, 84, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[50794, 1914, 86, 3, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[50895, 1920, 150, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.26"}],
    Cell[51070, 1928, 81, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[51154, 1932, 95, 2, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[51264, 1937, 203, 7, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.27"}],
    Cell[51492, 1948, 111, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[51606, 1952, 122, 2, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[51743, 1957, 541, 13, 70, "Text",
      CellTags->{"S3.1.4", "4.28"}],
    Cell[52287, 1972, 1090, 32, 70, "DefinitionBox",
      CellTags->"S3.1.4"],
    Cell[53380, 2006, 73, 1, 70, "Caption",
      CellTags->"S3.1.4"],
    Cell[53456, 2009, 102, 1, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.29"}],
    Cell[53583, 2014, 81, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[53667, 2018, 163, 4, 70, "Output",
      CellTags->"S3.1.4"],
    Cell[53845, 2025, 149, 5, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.30"}],
    Cell[54019, 2034, 72, 2, 70, "Input",
      CellTags->"S3.1.4"],
    Cell[54094, 2038, 85, 3, 70, "Output",
      CellTags->"S3.1.4"]},
  "4.1"->{
    Cell[30832, 1190, 78, 1, 70, "Subsection",
      CellTags->{"S3.1.4", "4.1"}]},
  "4.2"->{
    Cell[30913, 1193, 770, 18, 70, "Text",
      CellTags->{"S3.1.4", "4.2"}]},
  "4.3"->{
    Cell[32683, 1246, 121, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.3"}]},
  "4.4"->{
    Cell[33056, 1264, 94, 1, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.4"}]},
  "4.5"->{
    Cell[33354, 1279, 155, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.5"}]},
  "4.6"->{
    Cell[33727, 1297, 130, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.6"}]},
  "4.7"->{
    Cell[34108, 1315, 101, 1, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.7"}]},
  "4.8"->{
    Cell[34450, 1330, 331, 6, 70, "Text",
      CellTags->{"S3.1.4", "4.8"}]},
  "4.9"->{
    Cell[34784, 1338, 1687, 56, 70, "Text",
      CellTags->{"S3.1.4", "4.9"}]},
  "4.10"->{
    Cell[37765, 1437, 150, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.10"}]},
  "4.11"->{
    Cell[39505, 1498, 577, 13, 70, "Text",
      CellTags->{"S3.1.4", "4.11"}]},
  "4.12"->{
    Cell[40085, 1513, 198, 6, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.12"}]},
  "4.13"->{
    Cell[40494, 1533, 117, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.13"}]},
  "4.14"->{
    Cell[40914, 1552, 463, 8, 70, "Text",
      CellTags->{"S3.1.4", "4.14"}]},
  "4.15"->{
    Cell[42389, 1599, 170, 5, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.15"}]},
  "4.16"->{
    Cell[42781, 1618, 142, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.16"}]},
  "4.17"->{
    Cell[43149, 1636, 524, 12, 70, "Text",
      CellTags->{"S3.1.4", "4.17"}]},
  "4.18"->{
    Cell[46023, 1729, 444, 11, 70, "Text",
      CellTags->{"S3.1.4", "4.18"}]},
  "4.19"->{
    Cell[46470, 1742, 177, 5, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.19"}]},
  "4.20"->{
    Cell[46860, 1761, 158, 5, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.20"}]},
  "4.21"->{
    Cell[47232, 1779, 136, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.21"}]},
  "4.22"->{
    Cell[47611, 1797, 257, 6, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.22"}]},
  "4.23"->{
    Cell[48108, 1816, 157, 5, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.23"}]},
  "4.24"->{
    Cell[49977, 1881, 526, 18, 70, "Text",
      CellTags->{"S3.1.4", "4.24"}]},
  "4.25"->{
    Cell[50506, 1901, 176, 5, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.25"}]},
  "4.26"->{
    Cell[50895, 1920, 150, 4, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.26"}]},
  "4.27"->{
    Cell[51264, 1937, 203, 7, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.27"}]},
  "4.28"->{
    Cell[51743, 1957, 541, 13, 70, "Text",
      CellTags->{"S3.1.4", "4.28"}]},
  "4.29"->{
    Cell[53456, 2009, 102, 1, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.29"}]},
  "4.30"->{
    Cell[53845, 2025, 149, 5, 70, "MathCaption",
      CellTags->{"S3.1.4", "4.30"}]},
  "S3.1.5"->{
    Cell[54228, 2047, 102, 3, 70, "Subsection",
      CellTags->{"S3.1.5", "5.1"}],
    Cell[54333, 2052, 380, 8, 70, "Text",
      CellTags->{"S3.1.5", "5.2"}],
    Cell[54716, 2062, 542, 13, 70, "Text",
      CellTags->{"S3.1.5", "5.3"}],
    Cell[55261, 2077, 191, 6, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.4"}],
    Cell[55477, 2087, 73, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[55553, 2091, 121, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[55689, 2097, 107, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.5"}],
    Cell[55821, 2102, 85, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[55909, 2106, 156, 4, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[56080, 2113, 467, 10, 70, "Text",
      CellTags->{"S3.1.5", "5.6"}],
    Cell[56550, 2125, 207, 6, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.7"}],
    Cell[56782, 2135, 81, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[56866, 2139, 136, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[57017, 2145, 103, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.8"}],
    Cell[57145, 2150, 76, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[57224, 2154, 85, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[57324, 2160, 215, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.9"}],
    Cell[57564, 2169, 83, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[57650, 2173, 99, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[57764, 2179, 264, 9, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.10"}],
    Cell[58053, 2192, 86, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[58142, 2196, 136, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[58293, 2202, 466, 8, 70, "Text",
      CellTags->{"S3.1.5", "5.11"}],
    Cell[58762, 2212, 163, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.12"}],
    Cell[58950, 2220, 111, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[59064, 2224, 109, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[59188, 2230, 186, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.13"}],
    Cell[59399, 2239, 114, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[59516, 2243, 112, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[59643, 2249, 429, 8, 70, "Text",
      CellTags->{"S3.1.5", "5.14"}],
    Cell[60075, 2259, 199, 6, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.15"}],
    Cell[60299, 2269, 95, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[60397, 2273, 135, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[60547, 2279, 272, 9, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.16"}],
    Cell[60844, 2292, 80, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[60927, 2296, 138, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[61080, 2302, 172, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.17"}],
    Cell[61277, 2311, 70, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[61350, 2315, 153, 4, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[61518, 2322, 376, 7, 70, "Text",
      CellTags->{"S3.1.5", "5.18"}],
    Cell[61897, 2331, 119, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.19"}],
    Cell[62041, 2339, 86, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[62130, 2343, 119, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[62264, 2349, 153, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.20"}],
    Cell[62442, 2358, 70, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[62515, 2362, 132, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[62662, 2368, 99, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.21"}],
    Cell[62786, 2373, 77, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[62866, 2377, 100, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[62981, 2383, 200, 9, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.22"}],
    Cell[63206, 2396, 84, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[63293, 2400, 102, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[63410, 2406, 114, 2, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.23"}],
    Cell[63549, 2412, 77, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[63629, 2416, 100, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[63744, 2422, 575, 11, 70, "Text",
      CellTags->{"S3.1.5", "5.24"}],
    Cell[64322, 2435, 103, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.25"}],
    Cell[64450, 2440, 90, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[64543, 2444, 86, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[64644, 2450, 782, 16, 70, "Text",
      CellTags->{"S3.1.5", "5.26"}],
    Cell[65429, 2468, 1016, 31, 70, "DefinitionBox",
      CellTags->"S3.1.5"],
    Cell[66448, 2501, 63, 1, 70, "Caption",
      CellTags->"S3.1.5"],
    Cell[66514, 2504, 584, 16, 70, "Text",
      CellTags->{"S3.1.5", "5.27"}],
    Cell[67101, 2522, 223, 6, 70, "Text",
      CellTags->{"S3.1.5", "5.28"}],
    Cell[67327, 2530, 665, 20, 70, "DefinitionBox3Col",
      CellTags->"S3.1.5"],
    Cell[67995, 2552, 93, 1, 70, "Caption",
      CellTags->"S3.1.5"],
    Cell[68091, 2555, 210, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.29"}],
    Cell[68326, 2564, 82, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[68411, 2568, 144, 4, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[68570, 2575, 223, 7, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.30"}],
    Cell[68818, 2586, 83, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[68904, 2590, 312, 6, 70, "Message",
      CellTags->"S3.1.5"],
    Cell[69219, 2598, 86, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[69320, 2604, 180, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.31"}],
    Cell[69525, 2613, 89, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[69617, 2617, 85, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[69717, 2623, 87, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.32"}],
    Cell[69829, 2628, 83, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[69915, 2632, 144, 4, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[70074, 2639, 152, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.33"}],
    Cell[70251, 2648, 88, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[70342, 2652, 84, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[70441, 2658, 344, 8, 70, "Text",
      CellTags->{"S3.1.5", "5.34"}],
    Cell[70788, 2668, 159, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.35"}],
    Cell[70972, 2676, 82, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[71057, 2680, 86, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[71158, 2686, 207, 7, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.36"}],
    Cell[71390, 2697, 82, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[71475, 2701, 227, 4, 70, "Message",
      CellTags->"S3.1.5"],
    Cell[71705, 2707, 111, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[71831, 2713, 206, 7, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.37"}],
    Cell[72062, 2724, 118, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[72183, 2728, 87, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[72285, 2734, 1198, 36, 70, "Text",
      CellTags->{"S3.1.5", "5.38"}],
    Cell[73486, 2772, 115, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.39"}],
    Cell[73626, 2780, 83, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[73712, 2784, 122, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[73849, 2790, 98, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.40"}],
    Cell[73972, 2795, 73, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[74048, 2799, 102, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[74165, 2805, 164, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.41"}],
    Cell[74354, 2814, 76, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[74433, 2818, 100, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[74548, 2824, 167, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.42"}],
    Cell[74740, 2833, 70, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[74813, 2837, 100, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[74928, 2843, 349, 7, 70, "Text",
      CellTags->{"S3.1.5", "5.43"}],
    Cell[75280, 2852, 114, 2, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.44"}],
    Cell[75419, 2858, 83, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[75505, 2862, 103, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[75623, 2868, 129, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.45"}],
    Cell[75777, 2876, 77, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[75857, 2880, 85, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[75957, 2886, 145, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.46"}],
    Cell[76127, 2894, 76, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[76206, 2898, 101, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[76322, 2904, 220, 5, 70, "Text",
      CellTags->{"S3.1.5", "5.47"}],
    Cell[76545, 2911, 1820, 59, 70, "DefinitionBox",
      CellTags->"S3.1.5"],
    Cell[78368, 2972, 83, 1, 70, "Caption",
      CellTags->"S3.1.5"],
    Cell[78454, 2975, 86, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.48"}],
    Cell[78565, 2980, 92, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[78660, 2984, 111, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[78786, 2990, 109, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.49"}],
    Cell[78920, 2995, 80, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[79003, 2999, 83, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[79101, 3005, 145, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.50"}],
    Cell[79271, 3013, 73, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[79347, 3017, 244, 5, 70, "Message",
      CellTags->"S3.1.5"],
    Cell[79594, 3024, 101, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[79710, 3030, 95, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.51"}],
    Cell[79830, 3035, 85, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[79918, 3039, 103, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[80036, 3045, 414, 9, 70, "Text",
      CellTags->{"S3.1.5", "5.52"}],
    Cell[80453, 3056, 416, 8, 70, "Text",
      CellTags->{"S3.1.5", "5.53"}],
    Cell[80872, 3066, 122, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.54"}],
    Cell[81019, 3074, 81, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[81103, 3078, 126, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[81244, 3084, 212, 9, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.55"}],
    Cell[81481, 3097, 81, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[81565, 3101, 100, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[81680, 3107, 255, 7, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.56"}],
    Cell[81960, 3118, 87, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[82050, 3122, 99, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[82164, 3128, 468, 8, 70, "Text",
      CellTags->{"S3.1.5", "5.57"}],
    Cell[82635, 3138, 1111, 34, 70, "DefinitionBox",
      CellTags->"S3.1.5"],
    Cell[83749, 3174, 89, 1, 70, "Caption",
      CellTags->"S3.1.5"],
    Cell[83841, 3177, 136, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.58"}],
    Cell[84002, 3186, 88, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[84093, 3190, 135, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[84243, 3196, 99, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.59"}],
    Cell[84367, 3201, 76, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[84446, 3205, 101, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[84562, 3211, 133, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.60"}],
    Cell[84720, 3219, 77, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[84800, 3223, 99, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[84914, 3229, 402, 9, 70, "Text",
      CellTags->{"S3.1.5", "5.61"}],
    Cell[85319, 3240, 176, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.62"}],
    Cell[85520, 3248, 100, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[85623, 3252, 144, 4, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[85782, 3259, 917, 27, 70, "DefinitionBox3Col",
      CellTags->"S3.1.5"],
    Cell[86702, 3288, 78, 1, 70, "Caption",
      CellTags->"S3.1.5"],
    Cell[86783, 3291, 621, 21, 70, "Text",
      CellTags->{"S3.1.5", "5.63"}],
    Cell[87407, 3314, 636, 21, 70, "Text",
      CellTags->{"S3.1.5", "5.64"}],
    Cell[88046, 3337, 243, 5, 70, "Text",
      CellTags->{"S3.1.5", "5.65"}],
    Cell[88292, 3344, 121, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.66"}],
    Cell[88438, 3352, 84, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[88525, 3356, 123, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[88663, 3362, 153, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.67"}],
    Cell[88841, 3371, 84, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[88928, 3375, 138, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[89081, 3381, 165, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.68"}],
    Cell[89271, 3390, 99, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[89373, 3394, 84, 3, 70, "Output",
      CellTags->"S3.1.5"],
    Cell[89472, 3400, 115, 2, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.69"}],
    Cell[89612, 3406, 84, 2, 70, "Input",
      CellTags->"S3.1.5"],
    Cell[89699, 3410, 112, 3, 70, "Output",
      CellTags->"S3.1.5"]},
  "5.1"->{
    Cell[54228, 2047, 102, 3, 70, "Subsection",
      CellTags->{"S3.1.5", "5.1"}]},
  "5.2"->{
    Cell[54333, 2052, 380, 8, 70, "Text",
      CellTags->{"S3.1.5", "5.2"}]},
  "5.3"->{
    Cell[54716, 2062, 542, 13, 70, "Text",
      CellTags->{"S3.1.5", "5.3"}]},
  "5.4"->{
    Cell[55261, 2077, 191, 6, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.4"}]},
  "5.5"->{
    Cell[55689, 2097, 107, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.5"}]},
  "5.6"->{
    Cell[56080, 2113, 467, 10, 70, "Text",
      CellTags->{"S3.1.5", "5.6"}]},
  "5.7"->{
    Cell[56550, 2125, 207, 6, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.7"}]},
  "5.8"->{
    Cell[57017, 2145, 103, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.8"}]},
  "5.9"->{
    Cell[57324, 2160, 215, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.9"}]},
  "5.10"->{
    Cell[57764, 2179, 264, 9, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.10"}]},
  "5.11"->{
    Cell[58293, 2202, 466, 8, 70, "Text",
      CellTags->{"S3.1.5", "5.11"}]},
  "5.12"->{
    Cell[58762, 2212, 163, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.12"}]},
  "5.13"->{
    Cell[59188, 2230, 186, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.13"}]},
  "5.14"->{
    Cell[59643, 2249, 429, 8, 70, "Text",
      CellTags->{"S3.1.5", "5.14"}]},
  "5.15"->{
    Cell[60075, 2259, 199, 6, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.15"}]},
  "5.16"->{
    Cell[60547, 2279, 272, 9, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.16"}]},
  "5.17"->{
    Cell[61080, 2302, 172, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.17"}]},
  "5.18"->{
    Cell[61518, 2322, 376, 7, 70, "Text",
      CellTags->{"S3.1.5", "5.18"}]},
  "5.19"->{
    Cell[61897, 2331, 119, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.19"}]},
  "5.20"->{
    Cell[62264, 2349, 153, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.20"}]},
  "5.21"->{
    Cell[62662, 2368, 99, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.21"}]},
  "5.22"->{
    Cell[62981, 2383, 200, 9, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.22"}]},
  "5.23"->{
    Cell[63410, 2406, 114, 2, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.23"}]},
  "5.24"->{
    Cell[63744, 2422, 575, 11, 70, "Text",
      CellTags->{"S3.1.5", "5.24"}]},
  "5.25"->{
    Cell[64322, 2435, 103, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.25"}]},
  "5.26"->{
    Cell[64644, 2450, 782, 16, 70, "Text",
      CellTags->{"S3.1.5", "5.26"}]},
  "5.27"->{
    Cell[66514, 2504, 584, 16, 70, "Text",
      CellTags->{"S3.1.5", "5.27"}]},
  "5.28"->{
    Cell[67101, 2522, 223, 6, 70, "Text",
      CellTags->{"S3.1.5", "5.28"}]},
  "5.29"->{
    Cell[68091, 2555, 210, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.29"}]},
  "5.30"->{
    Cell[68570, 2575, 223, 7, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.30"}]},
  "5.31"->{
    Cell[69320, 2604, 180, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.31"}]},
  "5.32"->{
    Cell[69717, 2623, 87, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.32"}]},
  "5.33"->{
    Cell[70074, 2639, 152, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.33"}]},
  "5.34"->{
    Cell[70441, 2658, 344, 8, 70, "Text",
      CellTags->{"S3.1.5", "5.34"}]},
  "5.35"->{
    Cell[70788, 2668, 159, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.35"}]},
  "5.36"->{
    Cell[71158, 2686, 207, 7, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.36"}]},
  "5.37"->{
    Cell[71831, 2713, 206, 7, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.37"}]},
  "5.38"->{
    Cell[72285, 2734, 1198, 36, 70, "Text",
      CellTags->{"S3.1.5", "5.38"}]},
  "5.39"->{
    Cell[73486, 2772, 115, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.39"}]},
  "5.40"->{
    Cell[73849, 2790, 98, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.40"}]},
  "5.41"->{
    Cell[74165, 2805, 164, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.41"}]},
  "5.42"->{
    Cell[74548, 2824, 167, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.42"}]},
  "5.43"->{
    Cell[74928, 2843, 349, 7, 70, "Text",
      CellTags->{"S3.1.5", "5.43"}]},
  "5.44"->{
    Cell[75280, 2852, 114, 2, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.44"}]},
  "5.45"->{
    Cell[75623, 2868, 129, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.45"}]},
  "5.46"->{
    Cell[75957, 2886, 145, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.46"}]},
  "5.47"->{
    Cell[76322, 2904, 220, 5, 70, "Text",
      CellTags->{"S3.1.5", "5.47"}]},
  "5.48"->{
    Cell[78454, 2975, 86, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.48"}]},
  "5.49"->{
    Cell[78786, 2990, 109, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.49"}]},
  "5.50"->{
    Cell[79101, 3005, 145, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.50"}]},
  "5.51"->{
    Cell[79710, 3030, 95, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.51"}]},
  "5.52"->{
    Cell[80036, 3045, 414, 9, 70, "Text",
      CellTags->{"S3.1.5", "5.52"}]},
  "5.53"->{
    Cell[80453, 3056, 416, 8, 70, "Text",
      CellTags->{"S3.1.5", "5.53"}]},
  "5.54"->{
    Cell[80872, 3066, 122, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.54"}]},
  "5.55"->{
    Cell[81244, 3084, 212, 9, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.55"}]},
  "5.56"->{
    Cell[81680, 3107, 255, 7, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.56"}]},
  "5.57"->{
    Cell[82164, 3128, 468, 8, 70, "Text",
      CellTags->{"S3.1.5", "5.57"}]},
  "5.58"->{
    Cell[83841, 3177, 136, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.58"}]},
  "5.59"->{
    Cell[84243, 3196, 99, 1, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.59"}]},
  "5.60"->{
    Cell[84562, 3211, 133, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.60"}]},
  "5.61"->{
    Cell[84914, 3229, 402, 9, 70, "Text",
      CellTags->{"S3.1.5", "5.61"}]},
  "5.62"->{
    Cell[85319, 3240, 176, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.62"}]},
  "5.63"->{
    Cell[86783, 3291, 621, 21, 70, "Text",
      CellTags->{"S3.1.5", "5.63"}]},
  "5.64"->{
    Cell[87407, 3314, 636, 21, 70, "Text",
      CellTags->{"S3.1.5", "5.64"}]},
  "5.65"->{
    Cell[88046, 3337, 243, 5, 70, "Text",
      CellTags->{"S3.1.5", "5.65"}]},
  "5.66"->{
    Cell[88292, 3344, 121, 4, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.66"}]},
  "5.67"->{
    Cell[88663, 3362, 153, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.67"}]},
  "5.68"->{
    Cell[89081, 3381, 165, 5, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.68"}]},
  "5.69"->{
    Cell[89472, 3400, 115, 2, 70, "MathCaption",
      CellTags->{"S3.1.5", "5.69"}]},
  "S3.1.6"->{
    Cell[89860, 3419, 100, 3, 70, "Subsection",
      CellTags->{"S3.1.6", "6.1"}],
    Cell[89963, 3424, 299, 6, 70, "Text",
      CellTags->{"S3.1.6", "6.2"}],
    Cell[90265, 3432, 220, 5, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.3"}],
    Cell[90510, 3441, 91, 2, 70, "Input",
      CellTags->"S3.1.6"],
    Cell[90604, 3445, 99, 3, 70, "Output",
      CellTags->"S3.1.6"],
    Cell[90718, 3451, 197, 6, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.4"}],
    Cell[90940, 3461, 80, 2, 70, "Input",
      CellTags->"S3.1.6"],
    Cell[91023, 3465, 100, 3, 70, "Output",
      CellTags->"S3.1.6"],
    Cell[91138, 3471, 108, 3, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.5"}],
    Cell[91271, 3478, 82, 2, 70, "Input",
      CellTags->"S3.1.6"],
    Cell[91356, 3482, 136, 3, 70, "Output",
      CellTags->"S3.1.6"],
    Cell[91507, 3488, 646, 12, 70, "Text",
      CellTags->{"S3.1.6", "6.6"}],
    Cell[92156, 3502, 118, 4, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.7"}],
    Cell[92299, 3510, 94, 2, 70, "Input",
      CellTags->"S3.1.6"],
    Cell[92396, 3514, 104, 3, 70, "Output",
      CellTags->"S3.1.6"],
    Cell[92515, 3520, 101, 1, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.8"}],
    Cell[92641, 3525, 79, 2, 70, "Input",
      CellTags->"S3.1.6"],
    Cell[92723, 3529, 97, 3, 70, "Output",
      CellTags->"S3.1.6"],
    Cell[92835, 3535, 93, 1, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.9"}],
    Cell[92953, 3540, 79, 2, 70, "Input",
      CellTags->"S3.1.6"],
    Cell[93035, 3544, 99, 2, 70, "Output",
      CellTags->"S3.1.6"],
    Cell[93149, 3549, 411, 10, 70, "Text",
      CellTags->{"S3.1.6", "6.10"}],
    Cell[93563, 3561, 400, 8, 70, "Text",
      CellTags->{"S3.1.6", "6.11"}],
    Cell[93966, 3571, 362, 8, 70, "Text",
      CellTags->{"S3.1.6", "6.12"}],
    Cell[94331, 3581, 467, 9, 70, "Text",
      CellTags->{"S3.1.6", "6.13"}],
    Cell[94801, 3592, 360, 7, 70, "Text",
      CellTags->{"S3.1.6", "6.14"}],
    Cell[95164, 3601, 293, 6, 70, "Text",
      CellTags->{"S3.1.6", "6.15"}],
    Cell[95460, 3609, 612, 12, 70, "Text",
      CellTags->{"S3.1.6", "6.16"}],
    Cell[96075, 3623, 1442, 49, 70, "DefinitionBox",
      CellTags->"S3.1.6"],
    Cell[97520, 3674, 96, 1, 70, "Caption",
      CellTags->"S3.1.6"],
    Cell[97619, 3677, 482, 10, 70, "Text",
      CellTags->{"S3.1.6", "6.17"}],
    Cell[98104, 3689, 196, 5, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.18"}],
    Cell[98325, 3698, 79, 2, 70, "Input",
      CellTags->"S3.1.6"],
    Cell[98407, 3702, 104, 3, 70, "Output",
      CellTags->"S3.1.6"],
    Cell[98526, 3708, 207, 7, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.19"}],
    Cell[98758, 3719, 84, 2, 70, "Input",
      CellTags->"S3.1.6"],
    Cell[98845, 3723, 100, 3, 70, "Output",
      CellTags->"S3.1.6"],
    Cell[98960, 3729, 136, 5, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.20"}],
    Cell[99121, 3738, 70, 2, 70, "Input",
      CellTags->"S3.1.6"],
    Cell[99194, 3742, 104, 3, 70, "Output",
      CellTags->"S3.1.6"],
    Cell[99313, 3748, 123, 5, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.21"}],
    Cell[99461, 3757, 87, 2, 70, "Input",
      CellTags->"S3.1.6"],
    Cell[99551, 3761, 85, 3, 70, "Output",
      CellTags->"S3.1.6"],
    Cell[99651, 3767, 309, 11, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.22"}],
    Cell[99985, 3782, 71, 2, 70, "Input",
      CellTags->"S3.1.6"],
    Cell[100059, 3786, 85, 3, 70, "Output",
      CellTags->"S3.1.6"],
    Cell[100159, 3792, 426, 12, 70, "Text",
      CellTags->{"S3.1.6", "6.23"}],
    Cell[100588, 3806, 185, 4, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.24"}],
    Cell[100798, 3814, 82, 2, 70, "Input",
      CellTags->"S3.1.6"],
    Cell[100883, 3818, 106, 3, 70, "Output",
      CellTags->"S3.1.6"],
    Cell[101004, 3824, 185, 5, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.25"}],
    Cell[101214, 3833, 75, 2, 70, "Input",
      CellTags->"S3.1.6"],
    Cell[101292, 3837, 137, 3, 70, "Output",
      CellTags->"S3.1.6"]},
  "6.1"->{
    Cell[89860, 3419, 100, 3, 70, "Subsection",
      CellTags->{"S3.1.6", "6.1"}]},
  "6.2"->{
    Cell[89963, 3424, 299, 6, 70, "Text",
      CellTags->{"S3.1.6", "6.2"}]},
  "6.3"->{
    Cell[90265, 3432, 220, 5, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.3"}]},
  "6.4"->{
    Cell[90718, 3451, 197, 6, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.4"}]},
  "6.5"->{
    Cell[91138, 3471, 108, 3, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.5"}]},
  "6.6"->{
    Cell[91507, 3488, 646, 12, 70, "Text",
      CellTags->{"S3.1.6", "6.6"}]},
  "6.7"->{
    Cell[92156, 3502, 118, 4, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.7"}]},
  "6.8"->{
    Cell[92515, 3520, 101, 1, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.8"}]},
  "6.9"->{
    Cell[92835, 3535, 93, 1, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.9"}]},
  "6.10"->{
    Cell[93149, 3549, 411, 10, 70, "Text",
      CellTags->{"S3.1.6", "6.10"}]},
  "6.11"->{
    Cell[93563, 3561, 400, 8, 70, "Text",
      CellTags->{"S3.1.6", "6.11"}]},
  "6.12"->{
    Cell[93966, 3571, 362, 8, 70, "Text",
      CellTags->{"S3.1.6", "6.12"}]},
  "6.13"->{
    Cell[94331, 3581, 467, 9, 70, "Text",
      CellTags->{"S3.1.6", "6.13"}]},
  "6.14"->{
    Cell[94801, 3592, 360, 7, 70, "Text",
      CellTags->{"S3.1.6", "6.14"}]},
  "6.15"->{
    Cell[95164, 3601, 293, 6, 70, "Text",
      CellTags->{"S3.1.6", "6.15"}]},
  "6.16"->{
    Cell[95460, 3609, 612, 12, 70, "Text",
      CellTags->{"S3.1.6", "6.16"}]},
  "6.17"->{
    Cell[97619, 3677, 482, 10, 70, "Text",
      CellTags->{"S3.1.6", "6.17"}]},
  "6.18"->{
    Cell[98104, 3689, 196, 5, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.18"}]},
  "6.19"->{
    Cell[98526, 3708, 207, 7, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.19"}]},
  "6.20"->{
    Cell[98960, 3729, 136, 5, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.20"}]},
  "6.21"->{
    Cell[99313, 3748, 123, 5, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.21"}]},
  "6.22"->{
    Cell[99651, 3767, 309, 11, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.22"}]},
  "6.23"->{
    Cell[100159, 3792, 426, 12, 70, "Text",
      CellTags->{"S3.1.6", "6.23"}]},
  "6.24"->{
    Cell[100588, 3806, 185, 4, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.24"}]},
  "6.25"->{
    Cell[101004, 3824, 185, 5, 70, "MathCaption",
      CellTags->{"S3.1.6", "6.25"}]},
  "S3.1.7"->{
    Cell[101478, 3846, 94, 1, 70, "Subsection",
      CellTags->{"S3.1.7", "7.1"}],
    Cell[101575, 3849, 2922, 85, 70, "DefinitionBox",
      CellTags->"S3.1.7"],
    Cell[104500, 3936, 76, 1, 70, "Caption",
      CellTags->"S3.1.7"],
    Cell[104579, 3939, 265, 9, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.2"}],
    Cell[104869, 3952, 81, 2, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[104953, 3956, 102, 3, 70, "Output",
      CellTags->"S3.1.7"],
    Cell[105070, 3962, 289, 9, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.3"}],
    Cell[105384, 3975, 83, 2, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[105470, 3979, 98, 3, 70, "Output",
      CellTags->"S3.1.7"],
    Cell[105583, 3985, 106, 1, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.4"}],
    Cell[105714, 3990, 83, 2, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[105800, 3994, 147, 4, 70, "Output",
      CellTags->"S3.1.7"],
    Cell[105962, 4001, 137, 4, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.5"}],
    Cell[106124, 4009, 70, 2, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[106197, 4013, 110, 3, 70, "Output",
      CellTags->"S3.1.7"],
    Cell[106322, 4019, 104, 1, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.6"}],
    Cell[106451, 4024, 102, 2, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[106556, 4028, 123, 3, 70, "Output",
      CellTags->"S3.1.7"],
    Cell[106694, 4034, 103, 1, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.7"}],
    Cell[106822, 4039, 87, 2, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[106912, 4043, 102, 3, 70, "Output",
      CellTags->"S3.1.7"],
    Cell[107029, 4049, 3318, 92, 70, "DefinitionBox",
      CellTags->"S3.1.7"],
    Cell[110350, 4143, 66, 1, 70, "Caption",
      CellTags->"S3.1.7"],
    Cell[110419, 4146, 99, 1, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.8"}],
    Cell[110543, 4151, 121, 2, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[110667, 4155, 97, 3, 70, "Output",
      CellTags->"S3.1.7"],
    Cell[110779, 4161, 187, 7, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.9"}],
    Cell[110991, 4172, 70, 2, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[111064, 4176, 82, 3, 70, "Output",
      CellTags->"S3.1.7"],
    Cell[111161, 4182, 133, 4, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.10"}],
    Cell[111319, 4190, 135, 5, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[111457, 4197, 129, 3, 70, "Output",
      CellTags->"S3.1.7"],
    Cell[111601, 4203, 324, 7, 70, "Text",
      CellTags->{"S3.1.7", "7.11"}],
    Cell[111928, 4212, 228, 7, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.12"}],
    Cell[112181, 4223, 77, 2, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[112261, 4227, 160, 4, 70, "Output",
      CellTags->"S3.1.7"],
    Cell[112436, 4234, 172, 5, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.13"}],
    Cell[112633, 4243, 85, 2, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[112721, 4247, 158, 4, 70, "Output",
      CellTags->"S3.1.7"],
    Cell[112894, 4254, 117, 2, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.14"}],
    Cell[113036, 4260, 89, 2, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[113128, 4264, 196, 4, 70, "Output",
      CellTags->"S3.1.7"],
    Cell[113339, 4271, 161, 4, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.15"}],
    Cell[113525, 4279, 75, 2, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[113603, 4283, 106, 3, 70, "Output",
      CellTags->"S3.1.7"],
    Cell[113724, 4289, 136, 4, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.16"}],
    Cell[113885, 4297, 85, 2, 70, "Input",
      CellTags->"S3.1.7"],
    Cell[113973, 4301, 157, 4, 70, "Output",
      CellTags->"S3.1.7"]},
  "7.1"->{
    Cell[101478, 3846, 94, 1, 70, "Subsection",
      CellTags->{"S3.1.7", "7.1"}]},
  "7.2"->{
    Cell[104579, 3939, 265, 9, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.2"}]},
  "7.3"->{
    Cell[105070, 3962, 289, 9, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.3"}]},
  "7.4"->{
    Cell[105583, 3985, 106, 1, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.4"}]},
  "7.5"->{
    Cell[105962, 4001, 137, 4, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.5"}]},
  "7.6"->{
    Cell[106322, 4019, 104, 1, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.6"}]},
  "7.7"->{
    Cell[106694, 4034, 103, 1, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.7"}]},
  "7.8"->{
    Cell[110419, 4146, 99, 1, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.8"}]},
  "7.9"->{
    Cell[110779, 4161, 187, 7, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.9"}]},
  "7.10"->{
    Cell[111161, 4182, 133, 4, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.10"}]},
  "7.11"->{
    Cell[111601, 4203, 324, 7, 70, "Text",
      CellTags->{"S3.1.7", "7.11"}]},
  "7.12"->{
    Cell[111928, 4212, 228, 7, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.12"}]},
  "7.13"->{
    Cell[112436, 4234, 172, 5, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.13"}]},
  "7.14"->{
    Cell[112894, 4254, 117, 2, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.14"}]},
  "7.15"->{
    Cell[113339, 4271, 161, 4, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.15"}]},
  "7.16"->{
    Cell[113724, 4289, 136, 4, 70, "MathCaption",
      CellTags->{"S3.1.7", "7.16"}]},
  "S3.1.8"->{
    Cell[114179, 4311, 109, 1, 70, "Subsection",
      CellTags->{"S3.1.8", "8.1"}],
    Cell[114291, 4314, 261, 9, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.2"}],
    Cell[114577, 4327, 67, 2, 70, "Input",
      CellTags->"S3.1.8"],
    Cell[114647, 4331, 139, 3, 70, "Message",
      CellTags->"S3.1.8"],
    Cell[114789, 4336, 168, 4, 70, "Message",
      CellTags->"S3.1.8"],
    Cell[114960, 4342, 94, 3, 70, "Output",
      CellTags->"S3.1.8"],
    Cell[115069, 4348, 1341, 44, 70, "Text",
      CellTags->{"S3.1.8", "8.3"}],
    Cell[116413, 4394, 831, 20, 70, "Text",
      CellTags->{"S3.1.8", "8.4"}],
    Cell[117247, 4416, 188, 6, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.5"}],
    Cell[117460, 4426, 93, 2, 70, "Input",
      CellTags->"S3.1.8"],
    Cell[117556, 4430, 94, 3, 70, "Output",
      CellTags->"S3.1.8"],
    Cell[117665, 4436, 229, 5, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.6"}],
    Cell[117919, 4445, 83, 2, 70, "Input",
      CellTags->"S3.1.8"],
    Cell[118005, 4449, 94, 3, 70, "Output",
      CellTags->"S3.1.8"],
    Cell[118114, 4455, 570, 14, 70, "Text",
      CellTags->{"S3.1.8", "8.7"}],
    Cell[118687, 4471, 200, 6, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.8"}],
    Cell[118912, 4481, 99, 2, 70, "Input",
      CellTags->"S3.1.8"],
    Cell[119014, 4485, 139, 3, 70, "Message",
      CellTags->"S3.1.8"],
    Cell[119156, 4490, 168, 4, 70, "Message",
      CellTags->"S3.1.8"],
    Cell[119327, 4496, 92, 3, 70, "Output",
      CellTags->"S3.1.8"],
    Cell[119434, 4502, 1581, 47, 70, "DefinitionBox",
      CellTags->"S3.1.8"],
    Cell[121018, 4551, 80, 1, 70, "Caption",
      CellTags->"S3.1.8"],
    Cell[121101, 4554, 431, 10, 70, "Text",
      CellTags->{"S3.1.8", "8.9"}],
    Cell[121535, 4566, 99, 1, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.10"}],
    Cell[121659, 4571, 98, 2, 70, "Input",
      CellTags->"S3.1.8"],
    Cell[121760, 4575, 85, 3, 70, "Output",
      CellTags->"S3.1.8"],
    Cell[121860, 4581, 205, 7, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.11"}],
    Cell[122090, 4592, 74, 2, 70, "Input",
      CellTags->"S3.1.8"],
    Cell[122167, 4596, 82, 3, 70, "Output",
      CellTags->"S3.1.8"],
    Cell[122264, 4602, 165, 4, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.12"}],
    Cell[122454, 4610, 83, 2, 70, "Input",
      CellTags->"S3.1.8"],
    Cell[122540, 4614, 183, 4, 70, "Message",
      CellTags->"S3.1.8"],
    Cell[122726, 4620, 94, 3, 70, "Output",
      CellTags->"S3.1.8"],
    Cell[122835, 4626, 957, 21, 70, "Text",
      CellTags->{"S3.1.8", "8.13"}],
    Cell[123795, 4649, 1086, 35, 70, "Text",
      CellTags->{"S3.1.8", "8.14"}],
    Cell[124884, 4686, 178, 6, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.15"}],
    Cell[125087, 4696, 84, 2, 70, "Input",
      CellTags->"S3.1.8"],
    Cell[125174, 4700, 252, 8, 38, "Output",
      CellTags->"S3.1.8"],
    Cell[125441, 4711, 682, 18, 70, "Text",
      CellTags->{"S3.1.8", "8.16"}],
    Cell[126126, 4731, 135, 4, 40, "MathCaption",
      CellTags->{"S3.1.8", "8.17"}],
    Cell[126286, 4739, 67, 2, 28, "Input",
      CellTags->"S3.1.8"],
    Cell[126356, 4743, 139, 3, 35, "Message",
      CellTags->"S3.1.8"],
    Cell[126498, 4748, 96, 3, 25, "Output",
      CellTags->"S3.1.8"]},
  "8.1"->{
    Cell[114179, 4311, 109, 1, 70, "Subsection",
      CellTags->{"S3.1.8", "8.1"}]},
  "8.2"->{
    Cell[114291, 4314, 261, 9, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.2"}]},
  "8.3"->{
    Cell[115069, 4348, 1341, 44, 70, "Text",
      CellTags->{"S3.1.8", "8.3"}]},
  "8.4"->{
    Cell[116413, 4394, 831, 20, 70, "Text",
      CellTags->{"S3.1.8", "8.4"}]},
  "8.5"->{
    Cell[117247, 4416, 188, 6, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.5"}]},
  "8.6"->{
    Cell[117665, 4436, 229, 5, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.6"}]},
  "8.7"->{
    Cell[118114, 4455, 570, 14, 70, "Text",
      CellTags->{"S3.1.8", "8.7"}]},
  "8.8"->{
    Cell[118687, 4471, 200, 6, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.8"}]},
  "8.9"->{
    Cell[121101, 4554, 431, 10, 70, "Text",
      CellTags->{"S3.1.8", "8.9"}]},
  "8.10"->{
    Cell[121535, 4566, 99, 1, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.10"}]},
  "8.11"->{
    Cell[121860, 4581, 205, 7, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.11"}]},
  "8.12"->{
    Cell[122264, 4602, 165, 4, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.12"}]},
  "8.13"->{
    Cell[122835, 4626, 957, 21, 70, "Text",
      CellTags->{"S3.1.8", "8.13"}]},
  "8.14"->{
    Cell[123795, 4649, 1086, 35, 70, "Text",
      CellTags->{"S3.1.8", "8.14"}]},
  "8.15"->{
    Cell[124884, 4686, 178, 6, 70, "MathCaption",
      CellTags->{"S3.1.8", "8.15"}]},
  "8.16"->{
    Cell[125441, 4711, 682, 18, 70, "Text",
      CellTags->{"S3.1.8", "8.16"}]},
  "8.17"->{
    Cell[126126, 4731, 135, 4, 40, "MathCaption",
      CellTags->{"S3.1.8", "8.17"}]},
  "S3.1.9"->{
    Cell[126643, 4757, 107, 1, 38, "Subsection",
      CellTags->{"S3.1.9", "9.1"}],
    Cell[126753, 4760, 855, 25, 124, "DefinitionBox",
      CellTags->"S3.1.9"],
    Cell[127611, 4787, 90, 1, 16, "Caption",
      CellTags->"S3.1.9"],
    Cell[127704, 4790, 175, 5, 40, "MathCaption",
      CellTags->{"S3.1.9", "9.2"}],
    Cell[127904, 4799, 77, 2, 28, "Input",
      CellTags->"S3.1.9"],
    Cell[127984, 4803, 123, 3, 25, "Output",
      CellTags->"S3.1.9"],
    Cell[128122, 4809, 220, 9, 40, "MathCaption",
      CellTags->{"S3.1.9", "9.3"}],
    Cell[128345, 4820, 92, 2, 28, "Input",
      CellTags->"S3.1.9"],
    Cell[128440, 4824, 153, 5, 40, "MathCaption",
      CellTags->{"S3.1.9", "9.4"}],
    Cell[128618, 4833, 77, 2, 28, "Input",
      CellTags->"S3.1.9"],
    Cell[128698, 4837, 108, 3, 42, "Output",
      CellTags->"S3.1.9"]},
  "9.1"->{
    Cell[126643, 4757, 107, 1, 38, "Subsection",
      CellTags->{"S3.1.9", "9.1"}]},
  "9.2"->{
    Cell[127704, 4790, 175, 5, 40, "MathCaption",
      CellTags->{"S3.1.9", "9.2"}]},
  "9.3"->{
    Cell[128122, 4809, 220, 9, 40, "MathCaption",
      CellTags->{"S3.1.9", "9.3"}]},
  "9.4"->{
    Cell[128440, 4824, 153, 5, 40, "MathCaption",
      CellTags->{"S3.1.9", "9.4"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S3.1.0", 129460, 4861},
  {"0.1", 129550, 4864},
  {"S3.1.1", 129643, 4867},
  {"1.1", 132980, 4958},
  {"1.2", 133072, 4961},
  {"1.3", 133159, 4964},
  {"1.4", 133254, 4967},
  {"1.5", 133349, 4970},
  {"1.6", 133444, 4973},
  {"1.7", 133539, 4976},
  {"1.8", 133634, 4979},
  {"1.9", 133722, 4982},
  {"1.10", 133818, 4985},
  {"1.11", 133915, 4988},
  {"1.12", 134012, 4991},
  {"1.13", 134111, 4994},
  {"1.14", 134203, 4997},
  {"1.15", 134301, 5000},
  {"1.16", 134399, 5003},
  {"1.17", 134491, 5006},
  {"S3.1.2", 134585, 5009},
  {"2.1", 136090, 5050},
  {"2.2", 136184, 5053},
  {"2.3", 136281, 5056},
  {"2.4", 136376, 5059},
  {"2.5", 136472, 5062},
  {"2.6", 136562, 5065},
  {"2.7", 136659, 5068},
  {"2.8", 136755, 5071},
  {"S3.1.3", 136848, 5074},
  {"3.1", 140676, 5177},
  {"3.2", 140770, 5180},
  {"3.3", 140866, 5183},
  {"3.4", 140962, 5186},
  {"3.5", 141058, 5189},
  {"3.6", 141154, 5192},
  {"3.7", 141243, 5195},
  {"3.8", 141339, 5198},
  {"3.9", 141435, 5201},
  {"3.10", 141531, 5204},
  {"3.11", 141630, 5207},
  {"3.12", 141728, 5210},
  {"3.13", 141827, 5213},
  {"3.14", 141926, 5216},
  {"3.15", 142025, 5219},
  {"3.16", 142124, 5222},
  {"3.17", 142217, 5225},
  {"S3.1.4", 142318, 5228},
  {"4.1", 148694, 5397},
  {"4.2", 148789, 5400},
  {"4.3", 148880, 5403},
  {"4.4", 148977, 5406},
  {"4.5", 149073, 5409},
  {"4.6", 149170, 5412},
  {"4.7", 149267, 5415},
  {"4.8", 149364, 5418},
  {"4.9", 149454, 5421},
  {"4.10", 149547, 5424},
  {"4.11", 149646, 5427},
  {"4.12", 149739, 5430},
  {"4.13", 149838, 5433},
  {"4.14", 149937, 5436},
  {"4.15", 150029, 5439},
  {"4.16", 150128, 5442},
  {"4.17", 150227, 5445},
  {"4.18", 150320, 5448},
  {"4.19", 150413, 5451},
  {"4.20", 150512, 5454},
  {"4.21", 150611, 5457},
  {"4.22", 150710, 5460},
  {"4.23", 150809, 5463},
  {"4.24", 150908, 5466},
  {"4.25", 151001, 5469},
  {"4.26", 151100, 5472},
  {"4.27", 151199, 5475},
  {"4.28", 151298, 5478},
  {"4.29", 151391, 5481},
  {"4.30", 151490, 5484},
  {"S3.1.5", 151591, 5487},
  {"5.1", 164931, 5840},
  {"5.2", 165027, 5843},
  {"5.3", 165117, 5846},
  {"5.4", 165208, 5849},
  {"5.5", 165305, 5852},
  {"5.6", 165402, 5855},
  {"5.7", 165493, 5858},
  {"5.8", 165590, 5861},
  {"5.9", 165687, 5864},
  {"5.10", 165785, 5867},
  {"5.11", 165884, 5870},
  {"5.12", 165976, 5873},
  {"5.13", 166075, 5876},
  {"5.14", 166174, 5879},
  {"5.15", 166266, 5882},
  {"5.16", 166365, 5885},
  {"5.17", 166464, 5888},
  {"5.18", 166563, 5891},
  {"5.19", 166655, 5894},
  {"5.20", 166754, 5897},
  {"5.21", 166853, 5900},
  {"5.22", 166951, 5903},
  {"5.23", 167050, 5906},
  {"5.24", 167149, 5909},
  {"5.25", 167242, 5912},
  {"5.26", 167341, 5915},
  {"5.27", 167434, 5918},
  {"5.28", 167527, 5921},
  {"5.29", 167619, 5924},
  {"5.30", 167718, 5927},
  {"5.31", 167817, 5930},
  {"5.32", 167916, 5933},
  {"5.33", 168014, 5936},
  {"5.34", 168113, 5939},
  {"5.35", 168205, 5942},
  {"5.36", 168304, 5945},
  {"5.37", 168403, 5948},
  {"5.38", 168502, 5951},
  {"5.39", 168596, 5954},
  {"5.40", 168695, 5957},
  {"5.41", 168793, 5960},
  {"5.42", 168892, 5963},
  {"5.43", 168991, 5966},
  {"5.44", 169083, 5969},
  {"5.45", 169182, 5972},
  {"5.46", 169281, 5975},
  {"5.47", 169380, 5978},
  {"5.48", 169472, 5981},
  {"5.49", 169570, 5984},
  {"5.50", 169669, 5987},
  {"5.51", 169768, 5990},
  {"5.52", 169866, 5993},
  {"5.53", 169958, 5996},
  {"5.54", 170050, 5999},
  {"5.55", 170149, 6002},
  {"5.56", 170248, 6005},
  {"5.57", 170347, 6008},
  {"5.58", 170439, 6011},
  {"5.59", 170538, 6014},
  {"5.60", 170636, 6017},
  {"5.61", 170735, 6020},
  {"5.62", 170827, 6023},
  {"5.63", 170926, 6026},
  {"5.64", 171019, 6029},
  {"5.65", 171112, 6032},
  {"5.66", 171204, 6035},
  {"5.67", 171303, 6038},
  {"5.68", 171402, 6041},
  {"5.69", 171501, 6044},
  {"S3.1.6", 171602, 6047},
  {"6.1", 175656, 6154},
  {"6.2", 175752, 6157},
  {"6.3", 175842, 6160},
  {"6.4", 175939, 6163},
  {"6.5", 176036, 6166},
  {"6.6", 176133, 6169},
  {"6.7", 176224, 6172},
  {"6.8", 176321, 6175},
  {"6.9", 176418, 6178},
  {"6.10", 176515, 6181},
  {"6.11", 176608, 6184},
  {"6.12", 176700, 6187},
  {"6.13", 176792, 6190},
  {"6.14", 176884, 6193},
  {"6.15", 176976, 6196},
  {"6.16", 177068, 6199},
  {"6.17", 177161, 6202},
  {"6.18", 177254, 6205},
  {"6.19", 177353, 6208},
  {"6.20", 177452, 6211},
  {"6.21", 177551, 6214},
  {"6.22", 177650, 6217},
  {"6.23", 177750, 6220},
  {"6.24", 177844, 6223},
  {"6.25", 177944, 6226},
  {"S3.1.7", 178046, 6229},
  {"7.1", 181725, 6326},
  {"7.2", 181821, 6329},
  {"7.3", 181919, 6332},
  {"7.4", 182017, 6335},
  {"7.5", 182115, 6338},
  {"7.6", 182213, 6341},
  {"7.7", 182311, 6344},
  {"7.8", 182409, 6347},
  {"7.9", 182506, 6350},
  {"7.10", 182605, 6353},
  {"7.11", 182705, 6356},
  {"7.12", 182798, 6359},
  {"7.13", 182898, 6362},
  {"7.14", 182998, 6365},
  {"7.15", 183098, 6368},
  {"7.16", 183198, 6371},
  {"S3.1.8", 183300, 6374},
  {"8.1", 186601, 6461},
  {"8.2", 186698, 6464},
  {"8.3", 186796, 6467},
  {"8.4", 186889, 6470},
  {"8.5", 186981, 6473},
  {"8.6", 187079, 6476},
  {"8.7", 187177, 6479},
  {"8.8", 187269, 6482},
  {"8.9", 187367, 6485},
  {"8.10", 187460, 6488},
  {"8.11", 187559, 6491},
  {"8.12", 187659, 6494},
  {"8.13", 187759, 6497},
  {"8.14", 187853, 6500},
  {"8.15", 187948, 6503},
  {"8.16", 188048, 6506},
  {"8.17", 188142, 6509},
  {"S3.1.9", 188244, 6512},
  {"9.1", 189106, 6535},
  {"9.2", 189203, 6538},
  {"9.3", 189301, 6541},
  {"9.4", 189399, 6544}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 110, 4, 65, "Section",
  CellTags->{"S3.1.0", "0.1"}],

Cell[CellGroupData[{
Cell[1911, 61, 75, 1, 70, "Subsection",
  CellTags->{"S3.1.1", "1.1"}],
Cell[1989, 64, 152, 5, 70, "Text",
  CellTags->{"S3.1.1", "1.2"}],
Cell[2144, 71, 1220, 39, 70, "DefinitionBox",
  CellTags->"S3.1.1"],
Cell[3367, 112, 127, 5, 70, "Caption",
  CellTags->"S3.1.1"],
Cell[3497, 119, 149, 4, 70, "MathCaption",
  CellTags->{"S3.1.1", "1.3"}],

Cell[CellGroupData[{
Cell[3671, 127, 74, 2, 70, "Input",
  CellTags->"S3.1.1"],
Cell[3748, 131, 91, 3, 70, "Output",
  CellTags->"S3.1.1"]
}, Open  ]],
Cell[3854, 137, 153, 4, 70, "MathCaption",
  CellTags->{"S3.1.1", "1.4"}],

Cell[CellGroupData[{
Cell[4032, 145, 69, 2, 70, "Input",
  CellTags->"S3.1.1"],
Cell[4104, 149, 87, 3, 70, "Output",
  CellTags->"S3.1.1"]
}, Open  ]],
Cell[4206, 155, 114, 2, 70, "MathCaption",
  CellTags->{"S3.1.1", "1.5"}],

Cell[CellGroupData[{
Cell[4345, 161, 98, 2, 70, "Input",
  CellTags->"S3.1.1"],
Cell[4446, 165, 134, 3, 70, "Output",
  CellTags->"S3.1.1"]
}, Open  ]],
Cell[4595, 171, 113, 2, 70, "MathCaption",
  CellTags->{"S3.1.1", "1.6"}],

Cell[CellGroupData[{
Cell[4733, 177, 73, 2, 70, "Input",
  CellTags->"S3.1.1"],
Cell[4809, 181, 108, 3, 70, "Output",
  CellTags->"S3.1.1"]
}, Open  ]],
Cell[4932, 187, 109, 1, 70, "MathCaption",
  CellTags->{"S3.1.1", "1.7"}],

Cell[CellGroupData[{
Cell[5066, 192, 73, 2, 70, "Input",
  CellTags->"S3.1.1"],
Cell[5142, 196, 104, 3, 70, "Output",
  CellTags->"S3.1.1"]
}, Open  ]],
Cell[5261, 202, 1002, 30, 70, "DefinitionBox",
  CellTags->"S3.1.1"],
Cell[6266, 234, 77, 1, 70, "Caption",
  CellTags->"S3.1.1"],
Cell[6346, 237, 338, 8, 70, "Text",
  CellTags->{"S3.1.1", "1.8"}],
Cell[6687, 247, 193, 7, 70, "MathCaption",
  CellTags->{"S3.1.1", "1.9"}],

Cell[CellGroupData[{
Cell[6905, 258, 73, 2, 70, "Input",
  CellTags->"S3.1.1"],
Cell[6981, 262, 88, 3, 70, "Output",
  CellTags->"S3.1.1"]
}, Open  ]],
Cell[7084, 268, 273, 9, 70, "MathCaption",
  CellTags->{"S3.1.1", "1.10"}],

Cell[CellGroupData[{
Cell[7382, 281, 74, 2, 70, "Input",
  CellTags->"S3.1.1"],
Cell[7459, 285, 85, 3, 70, "Output",
  CellTags->"S3.1.1"]
}, Open  ]],
Cell[7559, 291, 1977, 63, 70, "DefinitionBox",
  CellTags->"S3.1.1"],
Cell[9539, 356, 78, 1, 70, "Caption",
  CellTags->"S3.1.1"],
Cell[9620, 359, 178, 6, 70, "MathCaption",
  CellTags->{"S3.1.1", "1.11"}],

Cell[CellGroupData[{
Cell[9823, 369, 76, 2, 70, "Input",
  CellTags->"S3.1.1"],
Cell[9902, 373, 85, 3, 70, "Output",
  CellTags->"S3.1.1"]
}, Open  ]],
Cell[10002, 379, 227, 10, 70, "MathCaption",
  CellTags->{"S3.1.1", "1.12"}],

Cell[CellGroupData[{
Cell[10254, 393, 76, 2, 70, "Input",
  CellTags->"S3.1.1"],
Cell[10333, 397, 86, 3, 70, "Output",
  CellTags->"S3.1.1"]
}, Open  ]],
Cell[10434, 403, 485, 11, 70, "Text",
  CellTags->{"S3.1.1", "1.13"}],
Cell[10922, 416, 228, 7, 70, "MathCaption",
  CellTags->{"S3.1.1", "1.14"}],

Cell[CellGroupData[{
Cell[11175, 427, 82, 2, 70, "Input",
  CellTags->"S3.1.1"],
Cell[11260, 431, 89, 3, 70, "Output",
  CellTags->"S3.1.1"]
}, Open  ]],
Cell[11364, 437, 208, 5, 70, "MathCaption",
  CellTags->{"S3.1.1", "1.15"}],

Cell[CellGroupData[{
Cell[11597, 446, 84, 2, 70, "Input",
  CellTags->"S3.1.1"],
Cell[11684, 450, 89, 3, 70, "Output",
  CellTags->"S3.1.1"]
}, Open  ]],
Cell[11788, 456, 467, 10, 70, "Text",
  CellTags->{"S3.1.1", "1.16"}],
Cell[12258, 468, 767, 22, 70, "Text",
  CellTags->{"S3.1.1", "1.17"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13062, 495, 77, 1, 70, "Subsection",
  CellTags->{"S3.1.2", "2.1"}],
Cell[13142, 498, 846, 26, 70, "DefinitionBox",
  CellTags->"S3.1.2"],
Cell[13991, 526, 73, 1, 70, "Caption",
  CellTags->"S3.1.2"],
Cell[14067, 529, 230, 10, 70, "MathCaption",
  CellTags->{"S3.1.2", "2.2"}],

Cell[CellGroupData[{
Cell[14322, 543, 79, 2, 70, "Input",
  CellTags->"S3.1.2"],
Cell[14404, 547, 86, 3, 70, "Output",
  CellTags->"S3.1.2"]
}, Open  ]],
Cell[14505, 553, 94, 1, 70, "MathCaption",
  CellTags->{"S3.1.2", "2.3"}],

Cell[CellGroupData[{
Cell[14624, 558, 80, 2, 70, "Input",
  CellTags->"S3.1.2"],
Cell[14707, 562, 85, 3, 70, "Output",
  CellTags->"S3.1.2"]
}, Open  ]],
Cell[14807, 568, 205, 9, 70, "MathCaption",
  CellTags->{"S3.1.2", "2.4"}],

Cell[CellGroupData[{
Cell[15037, 581, 73, 2, 70, "Input",
  CellTags->"S3.1.2"],
Cell[15113, 585, 99, 3, 70, "Output",
  CellTags->"S3.1.2"]
}, Open  ]],
Cell[15227, 591, 369, 11, 70, "Text",
  CellTags->{"S3.1.2", "2.5"}],
Cell[15599, 604, 240, 10, 70, "MathCaption",
  CellTags->{"S3.1.2", "2.6"}],

Cell[CellGroupData[{
Cell[15864, 618, 104, 2, 70, "Input",
  CellTags->"S3.1.2"],
Cell[15971, 622, 94, 3, 70, "Output",
  CellTags->"S3.1.2"]
}, Open  ]],
Cell[16080, 628, 138, 4, 70, "MathCaption",
  CellTags->{"S3.1.2", "2.7"}],

Cell[CellGroupData[{
Cell[16243, 636, 92, 2, 70, "Input",
  CellTags->"S3.1.2"],
Cell[16338, 640, 87, 3, 70, "Output",
  CellTags->"S3.1.2"]
}, Open  ]],
Cell[16440, 646, 605, 14, 70, "Text",
  CellTags->{"S3.1.2", "2.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[17082, 665, 76, 1, 70, "Subsection",
  CellTags->{"S3.1.3", "3.1"}],
Cell[17161, 668, 5110, 158, 70, "DefinitionBox",
  CellTags->"S3.1.3"],
Cell[22274, 828, 89, 1, 70, "Caption",
  CellTags->"S3.1.3"],
Cell[22366, 831, 105, 1, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.2"}],

Cell[CellGroupData[{
Cell[22496, 836, 93, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[22592, 840, 107, 3, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]],
Cell[22714, 846, 174, 4, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.3"}],

Cell[CellGroupData[{
Cell[22913, 854, 93, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[23009, 858, 134, 3, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]],
Cell[23158, 864, 157, 4, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.4"}],

Cell[CellGroupData[{
Cell[23340, 872, 87, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[23430, 876, 105, 3, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]],
Cell[23550, 882, 134, 4, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[23709, 890, 80, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[23792, 894, 83, 3, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]],
Cell[23890, 900, 920, 30, 70, "DefinitionBox",
  CellTags->"S3.1.3"],
Cell[24813, 932, 65, 1, 70, "Caption",
  CellTags->"S3.1.3"],
Cell[24881, 935, 231, 9, 70, "Text",
  CellTags->{"S3.1.3", "3.6"}],
Cell[25115, 946, 259, 9, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.7"}],

Cell[CellGroupData[{
Cell[25399, 959, 73, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[25475, 963, 83, 3, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]],
Cell[25573, 969, 166, 6, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.8"}],

Cell[CellGroupData[{
Cell[25764, 979, 79, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[25846, 983, 201, 7, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]],
Cell[26062, 993, 83, 1, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.9"}],

Cell[CellGroupData[{
Cell[26170, 998, 76, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[26249, 1002, 91, 3, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]],
Cell[26355, 1008, 151, 4, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.10"}],

Cell[CellGroupData[{
Cell[26531, 1016, 87, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[26621, 1020, 89, 3, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]],
Cell[26725, 1026, 89, 1, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.11"}],

Cell[CellGroupData[{
Cell[26839, 1031, 79, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[26921, 1035, 209, 7, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]],
Cell[27145, 1045, 141, 4, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.12"}],

Cell[CellGroupData[{
Cell[27311, 1053, 78, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[27392, 1057, 91, 3, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]],
Cell[27498, 1063, 188, 6, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.13"}],

Cell[CellGroupData[{
Cell[27711, 1073, 92, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[27806, 1077, 296, 7, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]],
Cell[28117, 1087, 115, 2, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.14"}],

Cell[CellGroupData[{
Cell[28257, 1093, 91, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[28351, 1097, 132, 3, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]],
Cell[28498, 1103, 213, 6, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.15"}],

Cell[CellGroupData[{
Cell[28736, 1113, 96, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[28835, 1117, 137, 3, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]],
Cell[28987, 1123, 373, 10, 70, "Text",
  CellTags->{"S3.1.3", "3.16"}],
Cell[29363, 1135, 960, 29, 70, "DefinitionBox",
  CellTags->"S3.1.3"],
Cell[30326, 1166, 90, 1, 70, "Caption",
  CellTags->"S3.1.3"],
Cell[30419, 1169, 147, 4, 70, "MathCaption",
  CellTags->{"S3.1.3", "3.17"}],

Cell[CellGroupData[{
Cell[30591, 1177, 94, 2, 70, "Input",
  CellTags->"S3.1.3"],
Cell[30688, 1181, 95, 3, 70, "Output",
  CellTags->"S3.1.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30832, 1190, 78, 1, 70, "Subsection",
  CellTags->{"S3.1.4", "4.1"}],
Cell[30913, 1193, 770, 18, 70, "Text",
  CellTags->{"S3.1.4", "4.2"}],
Cell[31686, 1213, 910, 28, 70, "DefinitionBox",
  CellTags->"S3.1.4"],
Cell[32599, 1243, 81, 1, 70, "Caption",
  CellTags->"S3.1.4"],
Cell[32683, 1246, 121, 4, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.3"}],

Cell[CellGroupData[{
Cell[32829, 1254, 80, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[32912, 1258, 129, 3, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[33056, 1264, 94, 1, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.4"}],

Cell[CellGroupData[{
Cell[33175, 1269, 76, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[33254, 1273, 85, 3, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[33354, 1279, 155, 4, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.5"}],

Cell[CellGroupData[{
Cell[33534, 1287, 75, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[33612, 1291, 100, 3, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[33727, 1297, 130, 4, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.6"}],

Cell[CellGroupData[{
Cell[33882, 1305, 72, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[33957, 1309, 136, 3, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[34108, 1315, 101, 1, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.7"}],

Cell[CellGroupData[{
Cell[34234, 1320, 91, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[34328, 1324, 107, 3, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[34450, 1330, 331, 6, 70, "Text",
  CellTags->{"S3.1.4", "4.8"}],
Cell[34784, 1338, 1687, 56, 70, "Text",
  CellTags->{"S3.1.4", "4.9"}],
Cell[36474, 1396, 1171, 33, 70, "DefinitionBox",
  CellTags->"S3.1.4"],
Cell[37648, 1431, 114, 4, 70, "Caption",
  CellTags->"S3.1.4"],
Cell[37765, 1437, 150, 4, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.10"}],

Cell[CellGroupData[{
Cell[37940, 1445, 91, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[38034, 1449, 245, 5, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[38294, 1457, 1061, 33, 70, "DefinitionBox",
  CellTags->"S3.1.4"],
Cell[39358, 1492, 144, 4, 70, "Caption",
  CellTags->"S3.1.4"],
Cell[39505, 1498, 577, 13, 70, "Text",
  CellTags->{"S3.1.4", "4.11"}],
Cell[40085, 1513, 198, 6, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.12"}],

Cell[CellGroupData[{
Cell[40308, 1523, 69, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[40380, 1527, 99, 3, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[40494, 1533, 117, 4, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.13"}],

Cell[CellGroupData[{
Cell[40636, 1541, 85, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[40724, 1545, 175, 4, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[40914, 1552, 463, 8, 70, "Text",
  CellTags->{"S3.1.4", "4.14"}],
Cell[41380, 1562, 945, 32, 70, "DefinitionBox",
  CellTags->"S3.1.4"],
Cell[42328, 1596, 58, 1, 70, "Caption",
  CellTags->"S3.1.4"],
Cell[42389, 1599, 170, 5, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.15"}],

Cell[CellGroupData[{
Cell[42584, 1608, 82, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[42669, 1612, 97, 3, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[42781, 1618, 142, 4, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.16"}],

Cell[CellGroupData[{
Cell[42948, 1626, 82, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[43033, 1630, 101, 3, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[43149, 1636, 524, 12, 70, "Text",
  CellTags->{"S3.1.4", "4.17"}],
Cell[43676, 1650, 2275, 74, 70, "DefinitionBox",
  CellTags->"S3.1.4"],
Cell[45954, 1726, 66, 1, 70, "Caption",
  CellTags->"S3.1.4"],
Cell[46023, 1729, 444, 11, 70, "Text",
  CellTags->{"S3.1.4", "4.18"}],
Cell[46470, 1742, 177, 5, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.19"}],

Cell[CellGroupData[{
Cell[46672, 1751, 70, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[46745, 1755, 100, 3, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[46860, 1761, 158, 5, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.20"}],

Cell[CellGroupData[{
Cell[47043, 1770, 77, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[47123, 1774, 94, 2, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[47232, 1779, 136, 4, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.21"}],

Cell[CellGroupData[{
Cell[47393, 1787, 74, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[47470, 1791, 126, 3, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[47611, 1797, 257, 6, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.22"}],

Cell[CellGroupData[{
Cell[47893, 1807, 77, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[47973, 1811, 120, 2, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[48108, 1816, 157, 5, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.23"}],

Cell[CellGroupData[{
Cell[48290, 1825, 97, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[48390, 1829, 116, 2, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[48521, 1834, 1376, 42, 70, "DefinitionBox",
  CellTags->"S3.1.4"],
Cell[49900, 1878, 74, 1, 70, "Caption",
  CellTags->"S3.1.4"],
Cell[49977, 1881, 526, 18, 70, "Text",
  CellTags->{"S3.1.4", "4.24"}],
Cell[50506, 1901, 176, 5, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.25"}],

Cell[CellGroupData[{
Cell[50707, 1910, 84, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[50794, 1914, 86, 3, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[50895, 1920, 150, 4, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.26"}],

Cell[CellGroupData[{
Cell[51070, 1928, 81, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[51154, 1932, 95, 2, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[51264, 1937, 203, 7, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.27"}],

Cell[CellGroupData[{
Cell[51492, 1948, 111, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[51606, 1952, 122, 2, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[51743, 1957, 541, 13, 70, "Text",
  CellTags->{"S3.1.4", "4.28"}],
Cell[52287, 1972, 1090, 32, 70, "DefinitionBox",
  CellTags->"S3.1.4"],
Cell[53380, 2006, 73, 1, 70, "Caption",
  CellTags->"S3.1.4"],
Cell[53456, 2009, 102, 1, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.29"}],

Cell[CellGroupData[{
Cell[53583, 2014, 81, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[53667, 2018, 163, 4, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]],
Cell[53845, 2025, 149, 5, 70, "MathCaption",
  CellTags->{"S3.1.4", "4.30"}],

Cell[CellGroupData[{
Cell[54019, 2034, 72, 2, 70, "Input",
  CellTags->"S3.1.4"],
Cell[54094, 2038, 85, 3, 70, "Output",
  CellTags->"S3.1.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[54228, 2047, 102, 3, 70, "Subsection",
  CellTags->{"S3.1.5", "5.1"}],
Cell[54333, 2052, 380, 8, 70, "Text",
  CellTags->{"S3.1.5", "5.2"}],
Cell[54716, 2062, 542, 13, 70, "Text",
  CellTags->{"S3.1.5", "5.3"}],
Cell[55261, 2077, 191, 6, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.4"}],

Cell[CellGroupData[{
Cell[55477, 2087, 73, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[55553, 2091, 121, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[55689, 2097, 107, 1, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.5"}],

Cell[CellGroupData[{
Cell[55821, 2102, 85, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[55909, 2106, 156, 4, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[56080, 2113, 467, 10, 70, "Text",
  CellTags->{"S3.1.5", "5.6"}],
Cell[56550, 2125, 207, 6, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.7"}],

Cell[CellGroupData[{
Cell[56782, 2135, 81, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[56866, 2139, 136, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[57017, 2145, 103, 1, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.8"}],

Cell[CellGroupData[{
Cell[57145, 2150, 76, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[57224, 2154, 85, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[57324, 2160, 215, 5, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.9"}],

Cell[CellGroupData[{
Cell[57564, 2169, 83, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[57650, 2173, 99, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[57764, 2179, 264, 9, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.10"}],

Cell[CellGroupData[{
Cell[58053, 2192, 86, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[58142, 2196, 136, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[58293, 2202, 466, 8, 70, "Text",
  CellTags->{"S3.1.5", "5.11"}],
Cell[58762, 2212, 163, 4, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.12"}],

Cell[CellGroupData[{
Cell[58950, 2220, 111, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[59064, 2224, 109, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[59188, 2230, 186, 5, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.13"}],

Cell[CellGroupData[{
Cell[59399, 2239, 114, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[59516, 2243, 112, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[59643, 2249, 429, 8, 70, "Text",
  CellTags->{"S3.1.5", "5.14"}],
Cell[60075, 2259, 199, 6, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.15"}],

Cell[CellGroupData[{
Cell[60299, 2269, 95, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[60397, 2273, 135, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[60547, 2279, 272, 9, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.16"}],

Cell[CellGroupData[{
Cell[60844, 2292, 80, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[60927, 2296, 138, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[61080, 2302, 172, 5, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.17"}],

Cell[CellGroupData[{
Cell[61277, 2311, 70, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[61350, 2315, 153, 4, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[61518, 2322, 376, 7, 70, "Text",
  CellTags->{"S3.1.5", "5.18"}],
Cell[61897, 2331, 119, 4, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.19"}],

Cell[CellGroupData[{
Cell[62041, 2339, 86, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[62130, 2343, 119, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[62264, 2349, 153, 5, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.20"}],

Cell[CellGroupData[{
Cell[62442, 2358, 70, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[62515, 2362, 132, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[62662, 2368, 99, 1, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.21"}],

Cell[CellGroupData[{
Cell[62786, 2373, 77, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[62866, 2377, 100, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[62981, 2383, 200, 9, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.22"}],

Cell[CellGroupData[{
Cell[63206, 2396, 84, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[63293, 2400, 102, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[63410, 2406, 114, 2, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.23"}],

Cell[CellGroupData[{
Cell[63549, 2412, 77, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[63629, 2416, 100, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[63744, 2422, 575, 11, 70, "Text",
  CellTags->{"S3.1.5", "5.24"}],
Cell[64322, 2435, 103, 1, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.25"}],

Cell[CellGroupData[{
Cell[64450, 2440, 90, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[64543, 2444, 86, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[64644, 2450, 782, 16, 70, "Text",
  CellTags->{"S3.1.5", "5.26"}],
Cell[65429, 2468, 1016, 31, 70, "DefinitionBox",
  CellTags->"S3.1.5"],
Cell[66448, 2501, 63, 1, 70, "Caption",
  CellTags->"S3.1.5"],
Cell[66514, 2504, 584, 16, 70, "Text",
  CellTags->{"S3.1.5", "5.27"}],
Cell[67101, 2522, 223, 6, 70, "Text",
  CellTags->{"S3.1.5", "5.28"}],
Cell[67327, 2530, 665, 20, 70, "DefinitionBox3Col",
  CellTags->"S3.1.5"],
Cell[67995, 2552, 93, 1, 70, "Caption",
  CellTags->"S3.1.5"],
Cell[68091, 2555, 210, 5, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.29"}],

Cell[CellGroupData[{
Cell[68326, 2564, 82, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[68411, 2568, 144, 4, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[68570, 2575, 223, 7, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.30"}],

Cell[CellGroupData[{
Cell[68818, 2586, 83, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[68904, 2590, 312, 6, 70, "Message",
  CellTags->"S3.1.5"],
Cell[69219, 2598, 86, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[69320, 2604, 180, 5, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.31"}],

Cell[CellGroupData[{
Cell[69525, 2613, 89, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[69617, 2617, 85, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[69717, 2623, 87, 1, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.32"}],

Cell[CellGroupData[{
Cell[69829, 2628, 83, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[69915, 2632, 144, 4, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[70074, 2639, 152, 5, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.33"}],

Cell[CellGroupData[{
Cell[70251, 2648, 88, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[70342, 2652, 84, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[70441, 2658, 344, 8, 70, "Text",
  CellTags->{"S3.1.5", "5.34"}],
Cell[70788, 2668, 159, 4, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.35"}],

Cell[CellGroupData[{
Cell[70972, 2676, 82, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[71057, 2680, 86, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[71158, 2686, 207, 7, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.36"}],

Cell[CellGroupData[{
Cell[71390, 2697, 82, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[71475, 2701, 227, 4, 70, "Message",
  CellTags->"S3.1.5"],
Cell[71705, 2707, 111, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[71831, 2713, 206, 7, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.37"}],

Cell[CellGroupData[{
Cell[72062, 2724, 118, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[72183, 2728, 87, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[72285, 2734, 1198, 36, 70, "Text",
  CellTags->{"S3.1.5", "5.38"}],
Cell[73486, 2772, 115, 4, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.39"}],

Cell[CellGroupData[{
Cell[73626, 2780, 83, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[73712, 2784, 122, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[73849, 2790, 98, 1, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.40"}],

Cell[CellGroupData[{
Cell[73972, 2795, 73, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[74048, 2799, 102, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[74165, 2805, 164, 5, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.41"}],

Cell[CellGroupData[{
Cell[74354, 2814, 76, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[74433, 2818, 100, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[74548, 2824, 167, 5, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.42"}],

Cell[CellGroupData[{
Cell[74740, 2833, 70, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[74813, 2837, 100, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[74928, 2843, 349, 7, 70, "Text",
  CellTags->{"S3.1.5", "5.43"}],
Cell[75280, 2852, 114, 2, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.44"}],

Cell[CellGroupData[{
Cell[75419, 2858, 83, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[75505, 2862, 103, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[75623, 2868, 129, 4, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.45"}],

Cell[CellGroupData[{
Cell[75777, 2876, 77, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[75857, 2880, 85, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[75957, 2886, 145, 4, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.46"}],

Cell[CellGroupData[{
Cell[76127, 2894, 76, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[76206, 2898, 101, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[76322, 2904, 220, 5, 70, "Text",
  CellTags->{"S3.1.5", "5.47"}],
Cell[76545, 2911, 1820, 59, 70, "DefinitionBox",
  CellTags->"S3.1.5"],
Cell[78368, 2972, 83, 1, 70, "Caption",
  CellTags->"S3.1.5"],
Cell[78454, 2975, 86, 1, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.48"}],

Cell[CellGroupData[{
Cell[78565, 2980, 92, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[78660, 2984, 111, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[78786, 2990, 109, 1, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.49"}],

Cell[CellGroupData[{
Cell[78920, 2995, 80, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[79003, 2999, 83, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[79101, 3005, 145, 4, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.50"}],

Cell[CellGroupData[{
Cell[79271, 3013, 73, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[79347, 3017, 244, 5, 70, "Message",
  CellTags->"S3.1.5"],
Cell[79594, 3024, 101, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[79710, 3030, 95, 1, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.51"}],

Cell[CellGroupData[{
Cell[79830, 3035, 85, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[79918, 3039, 103, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[80036, 3045, 414, 9, 70, "Text",
  CellTags->{"S3.1.5", "5.52"}],
Cell[80453, 3056, 416, 8, 70, "Text",
  CellTags->{"S3.1.5", "5.53"}],
Cell[80872, 3066, 122, 4, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.54"}],

Cell[CellGroupData[{
Cell[81019, 3074, 81, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[81103, 3078, 126, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[81244, 3084, 212, 9, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.55"}],

Cell[CellGroupData[{
Cell[81481, 3097, 81, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[81565, 3101, 100, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[81680, 3107, 255, 7, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.56"}],

Cell[CellGroupData[{
Cell[81960, 3118, 87, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[82050, 3122, 99, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[82164, 3128, 468, 8, 70, "Text",
  CellTags->{"S3.1.5", "5.57"}],
Cell[82635, 3138, 1111, 34, 70, "DefinitionBox",
  CellTags->"S3.1.5"],
Cell[83749, 3174, 89, 1, 70, "Caption",
  CellTags->"S3.1.5"],
Cell[83841, 3177, 136, 5, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.58"}],

Cell[CellGroupData[{
Cell[84002, 3186, 88, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[84093, 3190, 135, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[84243, 3196, 99, 1, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.59"}],

Cell[CellGroupData[{
Cell[84367, 3201, 76, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[84446, 3205, 101, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[84562, 3211, 133, 4, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.60"}],

Cell[CellGroupData[{
Cell[84720, 3219, 77, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[84800, 3223, 99, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[84914, 3229, 402, 9, 70, "Text",
  CellTags->{"S3.1.5", "5.61"}],
Cell[85319, 3240, 176, 4, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.62"}],

Cell[CellGroupData[{
Cell[85520, 3248, 100, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[85623, 3252, 144, 4, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[85782, 3259, 917, 27, 70, "DefinitionBox3Col",
  CellTags->"S3.1.5"],
Cell[86702, 3288, 78, 1, 70, "Caption",
  CellTags->"S3.1.5"],
Cell[86783, 3291, 621, 21, 70, "Text",
  CellTags->{"S3.1.5", "5.63"}],
Cell[87407, 3314, 636, 21, 70, "Text",
  CellTags->{"S3.1.5", "5.64"}],
Cell[88046, 3337, 243, 5, 70, "Text",
  CellTags->{"S3.1.5", "5.65"}],
Cell[88292, 3344, 121, 4, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.66"}],

Cell[CellGroupData[{
Cell[88438, 3352, 84, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[88525, 3356, 123, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[88663, 3362, 153, 5, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.67"}],

Cell[CellGroupData[{
Cell[88841, 3371, 84, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[88928, 3375, 138, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[89081, 3381, 165, 5, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.68"}],

Cell[CellGroupData[{
Cell[89271, 3390, 99, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[89373, 3394, 84, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]],
Cell[89472, 3400, 115, 2, 70, "MathCaption",
  CellTags->{"S3.1.5", "5.69"}],

Cell[CellGroupData[{
Cell[89612, 3406, 84, 2, 70, "Input",
  CellTags->"S3.1.5"],
Cell[89699, 3410, 112, 3, 70, "Output",
  CellTags->"S3.1.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[89860, 3419, 100, 3, 70, "Subsection",
  CellTags->{"S3.1.6", "6.1"}],
Cell[89963, 3424, 299, 6, 70, "Text",
  CellTags->{"S3.1.6", "6.2"}],
Cell[90265, 3432, 220, 5, 70, "MathCaption",
  CellTags->{"S3.1.6", "6.3"}],

Cell[CellGroupData[{
Cell[90510, 3441, 91, 2, 70, "Input",
  CellTags->"S3.1.6"],
Cell[90604, 3445, 99, 3, 70, "Output",
  CellTags->"S3.1.6"]
}, Open  ]],
Cell[90718, 3451, 197, 6, 70, "MathCaption",
  CellTags->{"S3.1.6", "6.4"}],

Cell[CellGroupData[{
Cell[90940, 3461, 80, 2, 70, "Input",
  CellTags->"S3.1.6"],
Cell[91023, 3465, 100, 3, 70, "Output",
  CellTags->"S3.1.6"]
}, Open  ]],
Cell[91138, 3471, 108, 3, 70, "MathCaption",
  CellTags->{"S3.1.6", "6.5"}],

Cell[CellGroupData[{
Cell[91271, 3478, 82, 2, 70, "Input",
  CellTags->"S3.1.6"],
Cell[91356, 3482, 136, 3, 70, "Output",
  CellTags->"S3.1.6"]
}, Open  ]],
Cell[91507, 3488, 646, 12, 70, "Text",
  CellTags->{"S3.1.6", "6.6"}],
Cell[92156, 3502, 118, 4, 70, "MathCaption",
  CellTags->{"S3.1.6", "6.7"}],

Cell[CellGroupData[{
Cell[92299, 3510, 94, 2, 70, "Input",
  CellTags->"S3.1.6"],
Cell[92396, 3514, 104, 3, 70, "Output",
  CellTags->"S3.1.6"]
}, Open  ]],
Cell[92515, 3520, 101, 1, 70, "MathCaption",
  CellTags->{"S3.1.6", "6.8"}],

Cell[CellGroupData[{
Cell[92641, 3525, 79, 2, 70, "Input",
  CellTags->"S3.1.6"],
Cell[92723, 3529, 97, 3, 70, "Output",
  CellTags->"S3.1.6"]
}, Open  ]],
Cell[92835, 3535, 93, 1, 70, "MathCaption",
  CellTags->{"S3.1.6", "6.9"}],

Cell[CellGroupData[{
Cell[92953, 3540, 79, 2, 70, "Input",
  CellTags->"S3.1.6"],
Cell[93035, 3544, 99, 2, 70, "Output",
  CellTags->"S3.1.6"]
}, Open  ]],
Cell[93149, 3549, 411, 10, 70, "Text",
  CellTags->{"S3.1.6", "6.10"}],
Cell[93563, 3561, 400, 8, 70, "Text",
  CellTags->{"S3.1.6", "6.11"}],
Cell[93966, 3571, 362, 8, 70, "Text",
  CellTags->{"S3.1.6", "6.12"}],
Cell[94331, 3581, 467, 9, 70, "Text",
  CellTags->{"S3.1.6", "6.13"}],
Cell[94801, 3592, 360, 7, 70, "Text",
  CellTags->{"S3.1.6", "6.14"}],
Cell[95164, 3601, 293, 6, 70, "Text",
  CellTags->{"S3.1.6", "6.15"}],
Cell[95460, 3609, 612, 12, 70, "Text",
  CellTags->{"S3.1.6", "6.16"}],
Cell[96075, 3623, 1442, 49, 70, "DefinitionBox",
  CellTags->"S3.1.6"],
Cell[97520, 3674, 96, 1, 70, "Caption",
  CellTags->"S3.1.6"],
Cell[97619, 3677, 482, 10, 70, "Text",
  CellTags->{"S3.1.6", "6.17"}],
Cell[98104, 3689, 196, 5, 70, "MathCaption",
  CellTags->{"S3.1.6", "6.18"}],

Cell[CellGroupData[{
Cell[98325, 3698, 79, 2, 70, "Input",
  CellTags->"S3.1.6"],
Cell[98407, 3702, 104, 3, 70, "Output",
  CellTags->"S3.1.6"]
}, Open  ]],
Cell[98526, 3708, 207, 7, 70, "MathCaption",
  CellTags->{"S3.1.6", "6.19"}],

Cell[CellGroupData[{
Cell[98758, 3719, 84, 2, 70, "Input",
  CellTags->"S3.1.6"],
Cell[98845, 3723, 100, 3, 70, "Output",
  CellTags->"S3.1.6"]
}, Open  ]],
Cell[98960, 3729, 136, 5, 70, "MathCaption",
  CellTags->{"S3.1.6", "6.20"}],

Cell[CellGroupData[{
Cell[99121, 3738, 70, 2, 70, "Input",
  CellTags->"S3.1.6"],
Cell[99194, 3742, 104, 3, 70, "Output",
  CellTags->"S3.1.6"]
}, Open  ]],
Cell[99313, 3748, 123, 5, 70, "MathCaption",
  CellTags->{"S3.1.6", "6.21"}],

Cell[CellGroupData[{
Cell[99461, 3757, 87, 2, 70, "Input",
  CellTags->"S3.1.6"],
Cell[99551, 3761, 85, 3, 70, "Output",
  CellTags->"S3.1.6"]
}, Open  ]],
Cell[99651, 3767, 309, 11, 70, "MathCaption",
  CellTags->{"S3.1.6", "6.22"}],

Cell[CellGroupData[{
Cell[99985, 3782, 71, 2, 70, "Input",
  CellTags->"S3.1.6"],
Cell[100059, 3786, 85, 3, 70, "Output",
  CellTags->"S3.1.6"]
}, Open  ]],
Cell[100159, 3792, 426, 12, 70, "Text",
  CellTags->{"S3.1.6", "6.23"}],
Cell[100588, 3806, 185, 4, 70, "MathCaption",
  CellTags->{"S3.1.6", "6.24"}],

Cell[CellGroupData[{
Cell[100798, 3814, 82, 2, 70, "Input",
  CellTags->"S3.1.6"],
Cell[100883, 3818, 106, 3, 70, "Output",
  CellTags->"S3.1.6"]
}, Open  ]],
Cell[101004, 3824, 185, 5, 70, "MathCaption",
  CellTags->{"S3.1.6", "6.25"}],

Cell[CellGroupData[{
Cell[101214, 3833, 75, 2, 70, "Input",
  CellTags->"S3.1.6"],
Cell[101292, 3837, 137, 3, 70, "Output",
  CellTags->"S3.1.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[101478, 3846, 94, 1, 70, "Subsection",
  CellTags->{"S3.1.7", "7.1"}],
Cell[101575, 3849, 2922, 85, 70, "DefinitionBox",
  CellTags->"S3.1.7"],
Cell[104500, 3936, 76, 1, 70, "Caption",
  CellTags->"S3.1.7"],
Cell[104579, 3939, 265, 9, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.2"}],

Cell[CellGroupData[{
Cell[104869, 3952, 81, 2, 70, "Input",
  CellTags->"S3.1.7"],
Cell[104953, 3956, 102, 3, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]],
Cell[105070, 3962, 289, 9, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.3"}],

Cell[CellGroupData[{
Cell[105384, 3975, 83, 2, 70, "Input",
  CellTags->"S3.1.7"],
Cell[105470, 3979, 98, 3, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]],
Cell[105583, 3985, 106, 1, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.4"}],

Cell[CellGroupData[{
Cell[105714, 3990, 83, 2, 70, "Input",
  CellTags->"S3.1.7"],
Cell[105800, 3994, 147, 4, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]],
Cell[105962, 4001, 137, 4, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.5"}],

Cell[CellGroupData[{
Cell[106124, 4009, 70, 2, 70, "Input",
  CellTags->"S3.1.7"],
Cell[106197, 4013, 110, 3, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]],
Cell[106322, 4019, 104, 1, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.6"}],

Cell[CellGroupData[{
Cell[106451, 4024, 102, 2, 70, "Input",
  CellTags->"S3.1.7"],
Cell[106556, 4028, 123, 3, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]],
Cell[106694, 4034, 103, 1, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.7"}],

Cell[CellGroupData[{
Cell[106822, 4039, 87, 2, 70, "Input",
  CellTags->"S3.1.7"],
Cell[106912, 4043, 102, 3, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]],
Cell[107029, 4049, 3318, 92, 70, "DefinitionBox",
  CellTags->"S3.1.7"],
Cell[110350, 4143, 66, 1, 70, "Caption",
  CellTags->"S3.1.7"],
Cell[110419, 4146, 99, 1, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.8"}],

Cell[CellGroupData[{
Cell[110543, 4151, 121, 2, 70, "Input",
  CellTags->"S3.1.7"],
Cell[110667, 4155, 97, 3, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]],
Cell[110779, 4161, 187, 7, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.9"}],

Cell[CellGroupData[{
Cell[110991, 4172, 70, 2, 70, "Input",
  CellTags->"S3.1.7"],
Cell[111064, 4176, 82, 3, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]],
Cell[111161, 4182, 133, 4, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.10"}],

Cell[CellGroupData[{
Cell[111319, 4190, 135, 5, 70, "Input",
  CellTags->"S3.1.7"],
Cell[111457, 4197, 129, 3, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]],
Cell[111601, 4203, 324, 7, 70, "Text",
  CellTags->{"S3.1.7", "7.11"}],
Cell[111928, 4212, 228, 7, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.12"}],

Cell[CellGroupData[{
Cell[112181, 4223, 77, 2, 70, "Input",
  CellTags->"S3.1.7"],
Cell[112261, 4227, 160, 4, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]],
Cell[112436, 4234, 172, 5, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.13"}],

Cell[CellGroupData[{
Cell[112633, 4243, 85, 2, 70, "Input",
  CellTags->"S3.1.7"],
Cell[112721, 4247, 158, 4, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]],
Cell[112894, 4254, 117, 2, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.14"}],

Cell[CellGroupData[{
Cell[113036, 4260, 89, 2, 70, "Input",
  CellTags->"S3.1.7"],
Cell[113128, 4264, 196, 4, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]],
Cell[113339, 4271, 161, 4, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.15"}],

Cell[CellGroupData[{
Cell[113525, 4279, 75, 2, 70, "Input",
  CellTags->"S3.1.7"],
Cell[113603, 4283, 106, 3, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]],
Cell[113724, 4289, 136, 4, 70, "MathCaption",
  CellTags->{"S3.1.7", "7.16"}],

Cell[CellGroupData[{
Cell[113885, 4297, 85, 2, 70, "Input",
  CellTags->"S3.1.7"],
Cell[113973, 4301, 157, 4, 70, "Output",
  CellTags->"S3.1.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[114179, 4311, 109, 1, 70, "Subsection",
  CellTags->{"S3.1.8", "8.1"}],
Cell[114291, 4314, 261, 9, 70, "MathCaption",
  CellTags->{"S3.1.8", "8.2"}],

Cell[CellGroupData[{
Cell[114577, 4327, 67, 2, 70, "Input",
  CellTags->"S3.1.8"],
Cell[114647, 4331, 139, 3, 70, "Message",
  CellTags->"S3.1.8"],
Cell[114789, 4336, 168, 4, 70, "Message",
  CellTags->"S3.1.8"],
Cell[114960, 4342, 94, 3, 70, "Output",
  CellTags->"S3.1.8"]
}, Open  ]],
Cell[115069, 4348, 1341, 44, 70, "Text",
  CellTags->{"S3.1.8", "8.3"}],
Cell[116413, 4394, 831, 20, 70, "Text",
  CellTags->{"S3.1.8", "8.4"}],
Cell[117247, 4416, 188, 6, 70, "MathCaption",
  CellTags->{"S3.1.8", "8.5"}],

Cell[CellGroupData[{
Cell[117460, 4426, 93, 2, 70, "Input",
  CellTags->"S3.1.8"],
Cell[117556, 4430, 94, 3, 70, "Output",
  CellTags->"S3.1.8"]
}, Open  ]],
Cell[117665, 4436, 229, 5, 70, "MathCaption",
  CellTags->{"S3.1.8", "8.6"}],

Cell[CellGroupData[{
Cell[117919, 4445, 83, 2, 70, "Input",
  CellTags->"S3.1.8"],
Cell[118005, 4449, 94, 3, 70, "Output",
  CellTags->"S3.1.8"]
}, Open  ]],
Cell[118114, 4455, 570, 14, 70, "Text",
  CellTags->{"S3.1.8", "8.7"}],
Cell[118687, 4471, 200, 6, 70, "MathCaption",
  CellTags->{"S3.1.8", "8.8"}],

Cell[CellGroupData[{
Cell[118912, 4481, 99, 2, 70, "Input",
  CellTags->"S3.1.8"],
Cell[119014, 4485, 139, 3, 70, "Message",
  CellTags->"S3.1.8"],
Cell[119156, 4490, 168, 4, 70, "Message",
  CellTags->"S3.1.8"],
Cell[119327, 4496, 92, 3, 70, "Output",
  CellTags->"S3.1.8"]
}, Open  ]],
Cell[119434, 4502, 1581, 47, 70, "DefinitionBox",
  CellTags->"S3.1.8"],
Cell[121018, 4551, 80, 1, 70, "Caption",
  CellTags->"S3.1.8"],
Cell[121101, 4554, 431, 10, 70, "Text",
  CellTags->{"S3.1.8", "8.9"}],
Cell[121535, 4566, 99, 1, 70, "MathCaption",
  CellTags->{"S3.1.8", "8.10"}],

Cell[CellGroupData[{
Cell[121659, 4571, 98, 2, 70, "Input",
  CellTags->"S3.1.8"],
Cell[121760, 4575, 85, 3, 70, "Output",
  CellTags->"S3.1.8"]
}, Open  ]],
Cell[121860, 4581, 205, 7, 70, "MathCaption",
  CellTags->{"S3.1.8", "8.11"}],

Cell[CellGroupData[{
Cell[122090, 4592, 74, 2, 70, "Input",
  CellTags->"S3.1.8"],
Cell[122167, 4596, 82, 3, 70, "Output",
  CellTags->"S3.1.8"]
}, Open  ]],
Cell[122264, 4602, 165, 4, 70, "MathCaption",
  CellTags->{"S3.1.8", "8.12"}],

Cell[CellGroupData[{
Cell[122454, 4610, 83, 2, 70, "Input",
  CellTags->"S3.1.8"],
Cell[122540, 4614, 183, 4, 70, "Message",
  CellTags->"S3.1.8"],
Cell[122726, 4620, 94, 3, 70, "Output",
  CellTags->"S3.1.8"]
}, Open  ]],
Cell[122835, 4626, 957, 21, 70, "Text",
  CellTags->{"S3.1.8", "8.13"}],
Cell[123795, 4649, 1086, 35, 70, "Text",
  CellTags->{"S3.1.8", "8.14"}],
Cell[124884, 4686, 178, 6, 70, "MathCaption",
  CellTags->{"S3.1.8", "8.15"}],

Cell[CellGroupData[{
Cell[125087, 4696, 84, 2, 70, "Input",
  CellTags->"S3.1.8"],
Cell[125174, 4700, 252, 8, 38, "Output",
  CellTags->"S3.1.8"]
}, Open  ]],
Cell[125441, 4711, 682, 18, 70, "Text",
  CellTags->{"S3.1.8", "8.16"}],
Cell[126126, 4731, 135, 4, 40, "MathCaption",
  CellTags->{"S3.1.8", "8.17"}],

Cell[CellGroupData[{
Cell[126286, 4739, 67, 2, 28, "Input",
  CellTags->"S3.1.8"],
Cell[126356, 4743, 139, 3, 35, "Message",
  CellTags->"S3.1.8"],
Cell[126498, 4748, 96, 3, 25, "Output",
  CellTags->"S3.1.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[126643, 4757, 107, 1, 38, "Subsection",
  CellTags->{"S3.1.9", "9.1"}],
Cell[126753, 4760, 855, 25, 124, "DefinitionBox",
  CellTags->"S3.1.9"],
Cell[127611, 4787, 90, 1, 16, "Caption",
  CellTags->"S3.1.9"],
Cell[127704, 4790, 175, 5, 40, "MathCaption",
  CellTags->{"S3.1.9", "9.2"}],

Cell[CellGroupData[{
Cell[127904, 4799, 77, 2, 28, "Input",
  CellTags->"S3.1.9"],
Cell[127984, 4803, 123, 3, 25, "Output",
  CellTags->"S3.1.9"]
}, Open  ]],
Cell[128122, 4809, 220, 9, 40, "MathCaption",
  CellTags->{"S3.1.9", "9.3"}],
Cell[128345, 4820, 92, 2, 28, "Input",
  CellTags->"S3.1.9"],
Cell[128440, 4824, 153, 5, 40, "MathCaption",
  CellTags->{"S3.1.9", "9.4"}],

Cell[CellGroupData[{
Cell[128618, 4833, 77, 2, 28, "Input",
  CellTags->"S3.1.9"],
Cell[128698, 4837, 108, 3, 42, "Output",
  CellTags->"S3.1.9"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

