(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1214852,      44035]*)
(*NotebookOutlinePosition[   1326861,      47186]*)
(*  CellTagsIndexPosition[   1315440,      46780]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["3.2 ", "HeadingNumber"],
  "Mathematical Functions"
}], "Section",
  CellTags->{"S3.2.0", "0.1"}],

Cell[CellGroupData[{

Cell["3.2.1 Naming Conventions", "Subsection",
  CellTags->{"S3.2.1", "1.1"}],

Cell[TextData[{
  "Mathematical functions in ",
  StyleBox["Mathematica", "TI"],
  " are given names according to definite rules. As with most ",
  StyleBox["Mathematica", "TI"],
  " functions, the names are usually complete English words, fully spelled \
out. For a few very common functions, ",
  StyleBox["Mathematica", "TI"],
  " uses the traditional abbreviations. Thus the modulo function, for \
example, is ",
  StyleBox["Mod", "MR"],
  ", not ",
  StyleBox["Modulo", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.2.1", "1.2"}],

Cell[TextData[{
  "Mathematical functions that are usually referred to by a person's name \
have names in ",
  StyleBox["Mathematica", "TI"],
  " of the form ",
  StyleBox["PersonSymbol", "TI"],
  ". Thus, for example, the Legendre polynomials ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["P",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " are denoted ",
  StyleBox["LegendreP[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". Although this convention does lead to longer function names, it avoids \
any ambiguity or confusion. "
}], "Text",
  CellTags->{"S3.2.1", "1.3"}],

Cell[TextData[{
  "When the standard notation for a mathematical function involves both \
subscripts and superscripts, the subscripts are given ",
  StyleBox["before", "TI"],
  " the superscripts in the ",
  StyleBox["Mathematica", "TI"],
  " form. Thus, for example, the associated Legendre polynomials ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["P",
              "TI"], 
            StyleBox["n",
              "TI"], 
            StyleBox["m",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " are denoted ",
  StyleBox["LegendreP[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.2.1", "1.4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2.2 Numerical Functions", "Subsection",
  CellTags->{"S3.2.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["IntegerPart[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "integer part of ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FractionalPart[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "fractional part of ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Round[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "integer ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[LeftAngleBracket]", 
                      StyleBox["x",
                        "TI"], "\[RightAngleBracket]"}], TraditionalForm]], 
                "InlineFormula"],
              " closest to ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Floor[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "greatest integer ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[LeftFloor]", 
                      StyleBox["x",
                        "TI"], "\[RightFloor]"}], TraditionalForm]], 
                "InlineFormula"],
              " not larger than ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Ceiling[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "least integer ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[LeftCeiling]", 
                      StyleBox["x",
                        "TI"], "\[RightCeiling]"}], TraditionalForm]], 
                "InlineFormula"],
              " not smaller than ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Rationalize[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "rational number approximation to ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Rationalize[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dx", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "rational approximation within tolerance ",
              StyleBox["dx", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, True, False}},
  CellTags->"S3.2.2"],

Cell["Functions relating real numbers and integers.", "Caption",
  CellTags->"S3.2.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["IntegerPart[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["FractionalPart[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Round[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Floor[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Ceiling[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["2.4", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["2", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["0.4", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["2", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["2", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["3", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["2.5", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["2", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["0.5", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["2", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["2", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["3", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["2.6", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["2", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["0.6", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["3", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["2", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["3", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["-2.4", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-2", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-0.4", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-2", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-3", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-2", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["-2.5", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-2", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-0.5", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-2", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-3", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-2", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["-2.6", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-2", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-0.6", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-3", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-3", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["-2", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox6Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S3.2.2"],

Cell["Extracting integer and fractional parts. ", "Caption",
  CellTags->"S3.2.2"],

Cell[TextData[{
  StyleBox["IntegerPart[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["FractionalPart[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " can be thought of as extracting digits to the left and right of the \
decimal point. ",
  StyleBox["Round[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " is often used for forcing numbers that are close to integers to be \
exactly integers. ",
  StyleBox["Floor[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["Ceiling[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " often arise in working out how many elements there will be in sequences \
of numbers with non\[Hyphen]integer spacings. "
}], "Text",
  CellTags->{"S3.2.2", "2.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Sign[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["1", "MR"],
              " for ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["x",
                        "TI"], ">", "0"}], TraditionalForm]], 
                "InlineFormula"],
              ", ",
              StyleBox["-1", "MR"],
              " for ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["x",
                        "TI"], "<", "0"}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["UnitStep[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["1", "MR"],
              " for ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["x",
                        "TI"], "\[GreaterEqual]", "0"}], TraditionalForm]], 
                "InlineFormula"],
              ", ",
              StyleBox["0", "MR"],
              " for ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["x",
                        "TI"], "<", "0"}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Abs[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "absolute value ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[VerticalSeparator]", 
                      StyleBox["x",
                        "TI"], "\[VerticalSeparator]"}], TraditionalForm]], 
                "InlineFormula"],
              " of ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Clip[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " clipped to be between \[Hyphen]1 and + 1 "
            }]]},
          {Cell[TextData[{
              StyleBox["Rescale[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " rescaled to run from 0 to 1 "
            }]]},
          {Cell[TextData[{
              StyleBox["Max[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Max[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] ]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "the maximum of ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Min[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Min[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] ]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "the minimum of ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, True, False}},
  CellTags->"S3.2.2"],

Cell["Numerical functions of real variables. ", "Caption",
  CellTags->"S3.2.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["I", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "the complex number ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["x",
                        "TI"], "+", 
                      StyleBox["i",
                        "TI"], 
                      StyleBox["y",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Re[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the real part ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"Re", " ", 
                      StyleBox["z",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Im[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the imaginary part ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"Im", " ", 
                      StyleBox["z",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Conjugate[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the complex conjugate ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["z",
                        "TI"], "*"], TraditionalForm]], "InlineFormula"],
              " or ",
              Cell[BoxData[
                  FormBox[
                    OverscriptBox[
                      StyleBox["z",
                        "TI"], "_"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Abs[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the absolute value ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[VerticalSeparator]", 
                      StyleBox["z",
                        "TI"], "\[VerticalSeparator]"}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Arg[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the argument ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
              " such that ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["z",
                        "TI"], "=", "\[VerticalSeparator]", 
                      StyleBox["z",
                        "TI"], "\[VerticalSeparator]", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{
                          StyleBox["i",
                            "TI"], "\[Phi]"}]]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.2"],

Cell["Numerical functions of complex variables.", "Caption",
  CellTags->"S3.2.2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2.3 Piecewise Functions", "Subsection",
  CellTags->{"S3.2.3", "3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Boole[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give 1 if ",
              StyleBox["expr", "TI"],
              " is ",
              StyleBox["True", "MR"],
              ", and 0 if it is ",
              StyleBox["False", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.3"],

Cell["Turning conditions into numbers. ", "Caption",
  CellTags->"S3.2.3"],

Cell[TextData[{
  StyleBox["Boole[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " is a basic function that turns ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " into ",
  StyleBox["1", "MR"],
  " and ",
  StyleBox["0", "MR"],
  ". It is sometimes known as the ",
  StyleBox["characteristic function", "TB"],
  " or ",
  StyleBox["indicator function", "TB"],
  ". "
}], "Text",
  CellTags->{"S3.2.3", "3.2"}],

Cell["This gives the area of a unit disk. ", "MathCaption",
  CellTags->{"S3.2.3", "3.3"}],

Cell[CellGroupData[{

Cell["Integrate[Boole[x^2 + y^2 <= 1], {x, -1, 1}, {y, -1, 1}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.2.3"],

Cell[BoxData[
    \(\[Pi]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.2.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Piecewise[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["val",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cond",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["val",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cond",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the first ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["val",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " for which ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cond",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " is ",
              StyleBox["True", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Piecewise[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["val",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cond",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["val", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["val", "TI"],
              " if all ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cond",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " are ",
              StyleBox["False", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.3"],

Cell["Piecewise functions. ", "Caption",
  CellTags->"S3.2.3"],

Cell[TextData[{
  "It is often convenient to have functions with different forms in different \
regions. You can do this using ",
  StyleBox["Piecewise", "MR"],
  ".          "
}], "Text",
  CellTags->{"S3.2.3", "3.4"}],

Cell["This plots a piecewise function. ", "MathCaption",
  CellTags->{"S3.2.3", "3.5"}],

Cell[CellGroupData[{

Cell["Plot[Piecewise[{{x^2, x < 0}, {1-x, x > 0}}], {x, -1, 1}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.2.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.0147151 0.588604 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.2619 .00222 -12 -9 ]
[.2619 .00222 12 0 ]
[.7381 .00222 -9 -9 ]
[.7381 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.4875 .13244 -18 -4.5 ]
[.4875 .13244 0 4.5 ]
[.4875 .25016 -18 -4.5 ]
[.4875 .25016 0 4.5 ]
[.4875 .36788 -18 -4.5 ]
[.4875 .36788 0 4.5 ]
[.4875 .4856 -18 -4.5 ]
[.4875 .4856 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-1)] .02381 .00222 0 1 Mshowa
.2619 .01472 m
.2619 .02097 L
s
[(-0.5)] .2619 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(0.5)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .13244 m
.50625 .13244 L
s
[(0.2)] .4875 .13244 1 0 Mshowa
.5 .25016 m
.50625 .25016 L
s
[(0.4)] .4875 .25016 1 0 Mshowa
.5 .36788 m
.50625 .36788 L
s
[(0.6)] .4875 .36788 1 0 Mshowa
.5 .4856 m
.50625 .4856 L
s
[(0.8)] .4875 .4856 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .16187 m
.50375 .16187 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .45617 m
.50375 .45617 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .51168 L
.10458 .42058 L
.14415 .34341 L
.18221 .27686 L
.22272 .21429 L
.26171 .16211 L
.30316 .11529 L
.34309 .07863 L
.3815 .05117 L
.40095 .04018 L
.42237 .03036 L
.44268 .02324 L
.45178 .02075 L
.46172 .01852 L
.4671 .01752 L
.4721 .01674 L
.47727 .01606 L
.48196 .01556 L
.48658 .01518 L
.4887 .01505 L
.49093 .01493 L
.49332 .01483 L
.49438 .0148 L
.49552 .01477 L
.49675 .01474 L
.49789 .01473 L
.49859 .01472 L
.49925 .01472 L
.50049 .60272 L
.50163 .60131 L
.50286 .59979 L
.50508 .59704 L
.51014 .59078 L
.5204 .57811 L
.53882 .55534 L
.57996 .50449 L
.61958 .45551 L
.65769 .4084 L
.69825 .35827 L
.7373 .31 L
.77879 .25871 L
.81878 .20929 L
.85724 .16174 L
.89816 .11116 L
.93756 .06246 L
.97545 .01563 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.2.3"]
}, Open  ]],

Cell[TextData[{
  "Piecewise functions appear in systems where there is discrete switching \
between different domains. They are also at the core of many computational \
methods, including splines and finite elements. Special cases include such \
functions as ",
  StyleBox["Abs", "MR"],
  ", ",
  StyleBox["UnitStep", "MR"],
  ", ",
  StyleBox["Clip", "MR"],
  ", ",
  StyleBox["Sign", "MR"],
  ", ",
  StyleBox["Floor", "MR"],
  " and ",
  StyleBox["Max", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " handles piecewise functions in both symbolic and numerical situations. "
}], "Text",
  CellTags->{"S3.2.3", "3.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2.4 Pseudorandom Numbers", "Subsection",
  CellTags->{"S3.2.4", "4.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Random[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a pseudorandom real between ",
              StyleBox["0", "MR"],
              " and ",
              StyleBox["1", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Random[Real,", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a pseudorandom real between ",
              StyleBox["0", "MR"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Random[Real,", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "a pseudorandom real between ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Random[Complex]", "MR"],
              " "
            }]], Cell["a pseudorandom complex number in the unit square "]},
          {Cell[TextData[{
              StyleBox["Random[Complex,", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "a pseudorandom complex number in the rectangle defined by ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Random[", "MR"],
              StyleBox["type", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["range", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "an ",
              StyleBox["n", "TI"],
              "\[Hyphen]digit pseudorandom number "
            }]]},
          {Cell[TextData[{
              StyleBox["Random[Integer]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["0", "MR"],
              " or ",
              StyleBox["1", "MR"],
              " with probability ",
              Cell[BoxData[
                  \(TraditionalForm\`1\/2\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Random[Integer,", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "a pseudorandom integer between ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", inclusive "
            }]]},
          {Cell[TextData[{
              StyleBox["SeedRandom[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "reseed the pseudorandom generator, with the time of day "]},
          {Cell[TextData[{
              StyleBox["SeedRandom[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "reseed with the integer ",
              StyleBox["s", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["$RandomState", "MR"],
              " "
            }]], Cell["the current state of the pseudorandom generator "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    False, False, False, False, False, False, False, True, False, True}},
  CellTags->"S3.2.4"],

Cell["Pseudorandom number generation.", "Caption",
  CellTags->"S3.2.4"],

Cell["This gives a list of 3 pseudorandom numbers. ", "MathCaption",
  CellTags->{"S3.2.4", "4.2"}],

Cell[CellGroupData[{

Cell["Table[Random[ ], {3}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.2.4"],

Cell[BoxData[
    \({0.056070794834861534`, 0.630299795779359`, 
      0.3598942942214413`}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.2.4"]
}, Open  ]],

Cell["\<\
Here is a 30\[Hyphen]digit pseudorandom real number in the range 0 \
to 1.  \
\>", "MathCaption",
  CellTags->{"S3.2.4", "4.3"}],

Cell[CellGroupData[{

Cell["Random[Real, {0, 1}, 30]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.2.4"],

Cell[BoxData[
    \(0.748823044099679773836330229337755413908328911678`30. \)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.2.4"]
}, Open  ]],

Cell["\<\
This gives a list of 8 pseudorandom integers between 100 and 200 \
(inclusive). \
\>", "MathCaption",
  CellTags->{"S3.2.4", "4.4"}],

Cell[CellGroupData[{

Cell["Table[Random[Integer, {100, 200}], {8}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.2.4"],

Cell[BoxData[
    \({120, 108, 109, 147, 146, 189, 188, 187}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.2.4"]
}, Open  ]],

Cell[TextData[{
  "If you call ",
  StyleBox["Random[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " repeatedly, you should get a \[OpenCurlyDoubleQuote]typical\
\[CloseCurlyDoubleQuote] sequence of numbers, with no particular pattern. \
There are many ways to use such numbers. "
}], "Text",
  CellTags->{"S3.2.4", "4.5"}],

Cell["\<\
One common way to use pseudorandom numbers is in making numerical \
tests of hypotheses. For example, if you believe that two symbolic \
expressions are mathematically equal, you can test this by plugging in \
\[OpenCurlyDoubleQuote]typical\[CloseCurlyDoubleQuote] numerical values for \
symbolic parameters, and then comparing the numerical results. (If you do \
this, you should be careful about numerical accuracy problems and about \
functions of complex variables that may not have unique values.)  \
\>", \
"Text",
  CellTags->{"S3.2.4", "4.6"}],

Cell["Here is a symbolic equation. ", "MathCaption",
  CellTags->{"S3.2.4", "4.7"}],

Cell[CellGroupData[{

Cell["Sin[Cos[x]] == Cos[Sin[x]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.2.4"],

Cell[BoxData[
    \(Sin[Cos[x]] \[Equal] Cos[Sin[x]]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.2.4"]
}, Open  ]],

Cell[TextData[{
  "Substituting in a random numerical value shows that the equation is not \
always ",
  StyleBox["True", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.4", "4.8"}],

Cell[CellGroupData[{

Cell["% /. x -> Random[ ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.2.4"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.2.4"]
}, Open  ]],

Cell[TextData[{
  "Other common uses of pseudorandom numbers include simulating probabilistic \
processes, and sampling large spaces of possibilities. The pseudorandom \
numbers that ",
  StyleBox["Mathematica", "TI"],
  " generates are always uniformly distributed over the range you specify. "
}], "Text",
  CellTags->{"S3.2.4", "4.9"}],

Cell[TextData[{
  StyleBox["Random", "MR"],
  " is unlike almost any other ",
  StyleBox["Mathematica", "TI"],
  " function in that every time you call it, you potentially get a different \
result. If you use ",
  StyleBox["Random", "MR"],
  " in a calculation, therefore, you may get different answers on different \
occasions. "
}], "Text",
  CellTags->{"S3.2.4", "4.10"}],

Cell[TextData[{
  "The sequences that you get from ",
  StyleBox["Random[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " are not in most senses \[OpenCurlyDoubleQuote]truly random\
\[CloseCurlyDoubleQuote], although they should be \
\[OpenCurlyDoubleQuote]random enough\[CloseCurlyDoubleQuote] for practical \
purposes. The sequences are in fact produced by applying a definite \
mathematical algorithm, starting from a particular \
\[OpenCurlyDoubleQuote]seed\[CloseCurlyDoubleQuote]. If you give the same \
seed, then you get the same sequence. "
}], "Text",
  CellTags->{"S3.2.4", "4.11"}],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " starts up, it takes the time of day (measured in small fractions of a \
second) as the seed for the pseudorandom number generator. Two different ",
  StyleBox["Mathematica", "TI"],
  " sessions will therefore almost always give different sequences of \
pseudorandom numbers.  "
}], "Text",
  CellTags->{"S3.2.4", "4.12"}],

Cell[TextData[{
  "If you want to make sure that you always get the same sequence of \
pseudorandom numbers, you can explicitly give a seed for the pseudorandom \
generator, using ",
  StyleBox["SeedRandom", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.2.4", "4.13"}],

Cell["This reseeds the pseudorandom generator. ", "MathCaption",
  CellTags->{"S3.2.4", "4.14"}],

Cell["SeedRandom[143]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.2.4"],

Cell["Here are three pseudorandom numbers. ", "MathCaption",
  CellTags->{"S3.2.4", "4.15"}],

Cell[CellGroupData[{

Cell["Table[Random[ ], {3}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.2.4"],

Cell[BoxData[
    \({0.9523115480664808`, 0.9359100153747634`, 
      0.8137543571180729`}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.2.4"]
}, Open  ]],

Cell["\<\
If you reseed the pseudorandom generator with the same seed, you \
get the same sequence of pseudorandom numbers. \
\>", "MathCaption",
  CellTags->{"S3.2.4", "4.16"}],

Cell[CellGroupData[{

Cell["SeedRandom[143]; Table[Random[ ], {3}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.2.4"],

Cell[BoxData[
    \({0.9523115480664808`, 0.9359100153747634`, 
      0.8137543571180729`}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.2.4"]
}, Open  ]],

Cell[TextData[{
  "Every single time ",
  StyleBox["Random", "MR"],
  " is called, the internal state of the pseudorandom generator that it uses \
is changed. This means that calls to ",
  StyleBox["Random", "MR"],
  " made in subsidiary calculations will have an effect on the numbers \
returned by ",
  StyleBox["Random", "MR"],
  " in your main calculation. To avoid any problems associated with this, you \
can save the value of ",
  StyleBox["$RandomState", "MR"],
  " before you do subsidiary calculations, and then restore it afterwards. "
}], "Text",
  CellTags->{"S3.2.4", "4.17"}],

Cell[TextData[{
  "By localizing the value of ",
  StyleBox["$RandomState", "MR"],
  " using ",
  StyleBox["Block", "MR"],
  ", the internal state of the pseudorandom generator is restored after \
generating the first list. "
}], "MathCaption",
  CellTags->{"S3.2.4", "4.18"}],

Cell[CellGroupData[{

Cell["\<\
{Block[{$RandomState}, {Random[ ], Random[ ]}], {Random[ ], Random[ \
]}}\
\>", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.2.4"],

Cell[BoxData[
    \({{0.11689987659996486`, 0.783447432283927`}, {0.11689987659996486`, 
        0.783447432283927`}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.2.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
3.2.5 Integer and Number\[Hyphen]Theoretical Functions\
\>", \
"Subsection",
  CellTags->{"S3.2.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Mod[", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["k", "TI"],
              " modulo ",
              StyleBox["n", "TI"],
              " (remainder from dividing ",
              StyleBox["k", "TI"],
              " by ",
              StyleBox["n", "TI"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["Quotient[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the quotient of ",
              StyleBox["m", "TI"],
              " and ",
              StyleBox["n", "TI"],
              " (integer part of ",
              StyleBox["m", "TI"],
              StyleBox["/", "MR"],
              StyleBox["n", "TI"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["GCD[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the greatest common divisor of ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LCM[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the least common multiple of ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["KroneckerDelta[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the Kronecker delta ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox["\[Delta]", 
                      RowBox[{
                        SubscriptBox[
                          StyleBox["n",
                            "TI"], "1"], 
                        SubscriptBox[
                          StyleBox["n",
                            "TI"], "2"], \(\(\[Ellipsis]\)\(\ \)\)}]], 
                    TraditionalForm]], "InlineFormula"],
              " equal to 1 if all the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " are equal, and 0 otherwise "
            }]]},
          {Cell[TextData[{
              StyleBox["IntegerDigits[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the digits of ",
              StyleBox["n", "TI"],
              " in base ",
              StyleBox["b", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["IntegerExponent[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the highest power of ",
              StyleBox["b", "TI"],
              " that divides ",
              StyleBox["n", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.5"],

Cell["Some integer functions.", "Caption",
  CellTags->"S3.2.5"],

Cell[TextData[{
  "The remainder on dividing ",
  Cell[BoxData[
      \(TraditionalForm\`17\)], "InlineFormula"],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`3\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.2"}],

Cell[CellGroupData[{

Cell["Mod[17, 3]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "The integer part of ",
  Cell[BoxData[
      \(TraditionalForm\`17/3\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.3"}],

Cell[CellGroupData[{

Cell["Quotient[17, 3]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mod", "MR"],
  " also works with real numbers. "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.4"}],

Cell[CellGroupData[{

Cell["Mod[5.6, 1.2]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(0.7999999999999998`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "The result from ",
  StyleBox["Mod", "MR"],
  " always has the same sign as the second argument. "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.5"}],

Cell[CellGroupData[{

Cell["Mod[-5.6, 1.2]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(0.40000000000000013`\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "For any integers ",
  StyleBox["a", "TI"],
  " and ",
  StyleBox["b", "TI"],
  ", it is always true that ",
  StyleBox["b", "TI"],
  StyleBox["*Quotient[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["Mod[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " is equal to ",
  StyleBox["a", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.2.5", "5.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Mod[", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "result in the range 0 to ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["n",
                        "TI"], "-", "1"}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Mod[", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["1]", "MR"],
              " "
            }]], Cell[TextData[{
              "result in the range 1 to ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Mod[", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["-", "MR"],
              StyleBox["n", "TI"],
              StyleBox["/2]", "MR"],
              " "
            }]], Cell[TextData[{
              "result in the range ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[LeftCeiling]", "-", 
                      StyleBox["n",
                        "TI"], "/", "2", "\[RightCeiling]"}], 
                    TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[LeftFloor]", "+", 
                      StyleBox["n",
                        "TI"], "/", "2", "\[RightFloor]"}], TraditionalForm]],
                 "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Mod[", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "result in the range ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["d",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["d",
                        "TI"], "+", 
                      StyleBox["n",
                        "TI"], "-", "1"}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.5"],

Cell["Integer remainders with offsets. ", "Caption",
  CellTags->"S3.2.5"],

Cell[TextData[{
  "Particularly when you are using ",
  StyleBox["Mod", "MR"],
  " to get indices for parts of objects, you will often find it convenient to \
specify an offset. "
}], "Text",
  CellTags->{"S3.2.5", "5.7"}],

Cell[TextData[{
  "This effectively extracts the 18",
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " part of the list, with the list treated cyclically. "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.8"}],

Cell[CellGroupData[{

Cell["Part[{a, b, c}, Mod[18, 3, 1]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(c\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["greatest common divisor", "TB"],
  " function ",
  StyleBox["GCD[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " gives the largest integer that divides all the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " exactly. When you enter a ratio of two integers, ",
  StyleBox["Mathematica", "TI"],
  " effectively uses ",
  StyleBox["GCD", "MR"],
  " to cancel out common factors, and give a rational number in lowest terms. \
 "
}], "Text",
  CellTags->{"S3.2.5", "5.9"}],

Cell[TextData[{
  "The ",
  StyleBox["least common multiple", "TB"],
  " function ",
  StyleBox["LCM[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " gives the smallest integer that contains all the factors of each of the \
",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.5", "5.10"}],

Cell["The largest integer that divides both 24 and 15 is 3. ", "MathCaption",
  CellTags->{"S3.2.5", "5.11"}],

Cell[CellGroupData[{

Cell["GCD[24, 15]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Kronecker delta", "TB"],
  " or ",
  StyleBox["Kronecker symbol", "TB"],
  " ",
  StyleBox["KroneckerDelta[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " is equal to 1 if all the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " are equal, and is 0 otherwise. ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Delta]", 
          RowBox[{
            SubscriptBox[
              StyleBox["n",
                "TI"], "1"], 
            SubscriptBox[
              StyleBox["n",
                "TI"], "2"], \(\(\[Ellipsis]\)\(\ \)\)}]], TraditionalForm]], 
    "InlineFormula"],
  " can be thought of as a totally symmetric tensor. "
}], "Text",
  CellTags->{"S3.2.5", "5.12"}],

Cell["This gives a totally symmetric tensor of rank 3. ", "MathCaption",
  CellTags->{"S3.2.5", "5.13"}],

Cell[CellGroupData[{

Cell["Array[KroneckerDelta, {3, 3, 3}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({{{1, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 1, 0}, {0, 0, 
          0}}, {{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FactorInteger[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a list of the prime factors of ",
              StyleBox["n", "TI"],
              ", and their exponents  "
            }]]},
          {Cell[TextData[{
              StyleBox["Divisors[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a list of the integers that divide ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Prime[", "MR"],
              StyleBox["k", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["k", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " prime number "
            }]]},
          {Cell[TextData[{
              StyleBox["PrimePi[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the number of primes less than or equal to ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PrimeQ[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["True", "MR"],
              " if ",
              StyleBox["n", "TI"],
              " is a prime, and ",
              StyleBox["False", "MR"],
              " otherwise "
            }]]},
          {Cell[TextData[{
              StyleBox["FactorInteger[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["GaussianIntegers->True]", "MR"],
              " "
            }]], Cell[TextData[{
              "a list of the Gaussian prime factors of the Gaussian integer ",
              
              StyleBox["n", "TI"],
              ", and their exponents "
            }]]},
          {Cell[TextData[{
              StyleBox["PrimeQ[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["GaussianIntegers->True]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["True", "MR"],
              " if ",
              StyleBox["n", "TI"],
              " is a Gaussian prime, and ",
              StyleBox["False", "MR"],
              " otherwise "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.5"],

Cell["Integer factoring and related functions.", "Caption",
  CellTags->"S3.2.5"],

Cell[TextData[{
  "This gives the factors of 24 as ",
  Cell[BoxData[
      \(TraditionalForm\`2\^3\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`3\^1\)], "InlineFormula"],
  ". The first element in each list is the factor; the second is its \
exponent. "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.14"}],

Cell[CellGroupData[{

Cell["FactorInteger[24]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({{2, 3}, {3, 1}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell["Here are the factors of a larger integer. ", "MathCaption",
  CellTags->{"S3.2.5", "5.15"}],

Cell[CellGroupData[{

Cell["FactorInteger[111111111111111111]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({{3, 2}, {7, 1}, {11, 1}, {13, 1}, {19, 1}, {37, 1}, {52579, 
        1}, {333667, 1}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "You should realize that according to current mathematical thinking, \
integer factoring is a fundamentally difficult computational problem. As a \
result, you can easily type in an integer that ",
  StyleBox["Mathematica", "TI"],
  " will not be able to factor in anything short of an astronomical length of \
time. But as long as the integers you give are less than about 50 digits \
long, ",
  StyleBox["FactorInteger", "MR"],
  " should have no trouble. And in special cases it will be able to deal with \
much longer integers. (You can make some factoring problems go faster by \
setting the option ",
  StyleBox["FactorComplete->False", "MR"],
  ", so that ",
  StyleBox["FactorInteger[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " tries to pull out only easy factors from ",
  StyleBox["n", "TI"],
  ".) "
}], "Text",
  CellTags->{"S3.2.5", "5.16"}],

Cell["Here is a rather special long integer. ", "MathCaption",
  CellTags->{"S3.2.5", "5.17"}],

Cell[CellGroupData[{

Cell["30!", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(265252859812191058636308480000000\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can easily factor this special integer. "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.18"}],

Cell[CellGroupData[{

Cell["FactorInteger[%]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({{2, 26}, {3, 14}, {5, 7}, {7, 4}, {11, 2}, {13, 2}, {17, 1}, {19, 
        1}, {23, 1}, {29, 1}}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "Although ",
  StyleBox["Mathematica", "TI"],
  " may not be able to factor a large integer, it can often still test \
whether or not the integer is a prime. In addition, ",
  StyleBox["Mathematica", "TI"],
  " has a fast way of finding the ",
  StyleBox["k", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " prime number. "
}], "Text",
  CellTags->{"S3.2.5", "5.19"}],

Cell["\<\
It is often much faster to test whether a number is prime than to \
factor it. \
\>", "MathCaption",
  CellTags->{"S3.2.5", "5.20"}],

Cell[CellGroupData[{

Cell["PrimeQ[234242423]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell["Here is a plot of the first 100 primes. ", "MathCaption",
  CellTags->{"S3.2.5", "5.21"}],

Cell[CellGroupData[{

Cell["ListPlot[ Table[ Prime[n], {n, 100} ] ]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.2.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00952381 0.0147151 0.00108799 [
[.21429 .00222 -6 -9 ]
[.21429 .00222 6 0 ]
[.40476 .00222 -6 -9 ]
[.40476 .00222 6 0 ]
[.59524 .00222 -6 -9 ]
[.59524 .00222 6 0 ]
[.78571 .00222 -6 -9 ]
[.78571 .00222 6 0 ]
[.97619 .00222 -9 -9 ]
[.97619 .00222 9 0 ]
[.01131 .12351 -18 -4.5 ]
[.01131 .12351 0 4.5 ]
[.01131 .23231 -18 -4.5 ]
[.01131 .23231 0 4.5 ]
[.01131 .34111 -18 -4.5 ]
[.01131 .34111 0 4.5 ]
[.01131 .44991 -18 -4.5 ]
[.01131 .44991 0 4.5 ]
[.01131 .55871 -18 -4.5 ]
[.01131 .55871 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(20)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(40)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(60)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(80)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(100)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .12351 m
.03006 .12351 L
s
[(100)] .01131 .12351 1 0 Mshowa
.02381 .23231 m
.03006 .23231 L
s
[(200)] .01131 .23231 1 0 Mshowa
.02381 .34111 m
.03006 .34111 L
s
[(300)] .01131 .34111 1 0 Mshowa
.02381 .44991 m
.03006 .44991 L
s
[(400)] .01131 .44991 1 0 Mshowa
.02381 .55871 m
.03006 .55871 L
s
[(500)] .01131 .55871 1 0 Mshowa
.125 Mabswid
.02381 .03647 m
.02756 .03647 L
s
.02381 .05823 m
.02756 .05823 L
s
.02381 .07999 m
.02756 .07999 L
s
.02381 .10175 m
.02756 .10175 L
s
.02381 .14527 m
.02756 .14527 L
s
.02381 .16703 m
.02756 .16703 L
s
.02381 .18879 m
.02756 .18879 L
s
.02381 .21055 m
.02756 .21055 L
s
.02381 .25407 m
.02756 .25407 L
s
.02381 .27583 m
.02756 .27583 L
s
.02381 .29759 m
.02756 .29759 L
s
.02381 .31935 m
.02756 .31935 L
s
.02381 .36287 m
.02756 .36287 L
s
.02381 .38463 m
.02756 .38463 L
s
.02381 .40639 m
.02756 .40639 L
s
.02381 .42815 m
.02756 .42815 L
s
.02381 .47167 m
.02756 .47167 L
s
.02381 .49343 m
.02756 .49343 L
s
.02381 .51519 m
.02756 .51519 L
s
.02381 .53695 m
.02756 .53695 L
s
.02381 .58047 m
.02756 .58047 L
s
.02381 .60223 m
.02756 .60223 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.03333 .01689 Mdot
.04286 .01798 Mdot
.05238 .02016 Mdot
.0619 .02233 Mdot
.07143 .02668 Mdot
.08095 .02886 Mdot
.09048 .03321 Mdot
.1 .03539 Mdot
.10952 .03974 Mdot
.11905 .04627 Mdot
.12857 .04844 Mdot
.1381 .05497 Mdot
.14762 .05932 Mdot
.15714 .0615 Mdot
.16667 .06585 Mdot
.17619 .07238 Mdot
.18571 .07891 Mdot
.19524 .08108 Mdot
.20476 .08761 Mdot
.21429 .09196 Mdot
.22381 .09414 Mdot
.23333 .10067 Mdot
.24286 .10502 Mdot
.25238 .11155 Mdot
.2619 .12025 Mdot
.27143 .1246 Mdot
.28095 .12678 Mdot
.29048 .13113 Mdot
.3 .13331 Mdot
.30952 .13766 Mdot
.31905 .15289 Mdot
.32857 .15724 Mdot
.3381 .16377 Mdot
.34762 .16595 Mdot
.35714 .17683 Mdot
.36667 .179 Mdot
.37619 .18553 Mdot
.38571 .19206 Mdot
.39524 .19641 Mdot
.40476 .20294 Mdot
.41429 .20947 Mdot
.42381 .21164 Mdot
.43333 .22252 Mdot
.44286 .2247 Mdot
.45238 .22905 Mdot
.4619 .23123 Mdot
.47143 .24428 Mdot
.48095 .25734 Mdot
.49048 .26169 Mdot
.5 .26387 Mdot
.50952 .26822 Mdot
.51905 .27475 Mdot
.52857 .27692 Mdot
.5381 .2878 Mdot
.54762 .29433 Mdot
.55714 .30086 Mdot
.56667 .30739 Mdot
.57619 .30956 Mdot
.58571 .31609 Mdot
.59524 .32044 Mdot
.60476 .32262 Mdot
.61429 .3335 Mdot
.62381 .34873 Mdot
.63333 .35308 Mdot
.64286 .35526 Mdot
.65238 .35961 Mdot
.6619 .37484 Mdot
.67143 .38137 Mdot
.68095 .39225 Mdot
.69048 .39442 Mdot
.7 .39878 Mdot
.70952 .4053 Mdot
.71905 .41401 Mdot
.72857 .42054 Mdot
.7381 .42706 Mdot
.74762 .43142 Mdot
.75714 .43794 Mdot
.76667 .44665 Mdot
.77619 .451 Mdot
.78571 .4597 Mdot
.79524 .47058 Mdot
.80476 .47276 Mdot
.81429 .48364 Mdot
.82381 .48582 Mdot
.83333 .49234 Mdot
.84286 .4967 Mdot
.85238 .50322 Mdot
.8619 .51193 Mdot
.87143 .51628 Mdot
.88095 .51846 Mdot
.89048 .52281 Mdot
.9 .53586 Mdot
.90952 .54457 Mdot
.91905 .54892 Mdot
.92857 .55762 Mdot
.9381 .56198 Mdot
.94762 .5685 Mdot
.95714 .58156 Mdot
.96667 .58374 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell["This is the millionth prime. ", "MathCaption",
  CellTags->{"S3.2.5", "5.22"}],

Cell[CellGroupData[{

Cell["Prime[1000000]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(15485863\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "Particularly in number theory, it is often more important to know the \
distribution of primes than their actual values. The function ",
  StyleBox["PrimePi[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " gives the number of primes ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Pi]", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " that are less than or equal to ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.5", "5.23"}],

Cell["This gives the number of primes less than a billion. ", "MathCaption",
  CellTags->{"S3.2.5", "5.24"}],

Cell[CellGroupData[{

Cell["PrimePi[10^9]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(50847534\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "By default, ",
  StyleBox["FactorInteger", "MR"],
  " allows only real integers. But with the option setting ",
  StyleBox["GaussianIntegers", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ", it also handles ",
  StyleBox["Gaussian integers", "TB"],
  ", which are complex numbers with integer real and imaginary parts. Just as \
it is possible to factor uniquely in terms of real primes, it is also \
possible to factor uniquely in terms of Gaussian primes. There is \
nevertheless some potential ambiguity in the choice of Gaussian primes. In ",
  StyleBox["Mathematica", "TI"],
  ", they are always chosen to have positive real parts, and \
non\[Hyphen]negative imaginary parts, except for a possible initial factor of \
",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " or ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[PlusMinus]", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.2.5", "5.25"}],

Cell[TextData[{
  "Over the Gaussian integers, 2 can be factored as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"(", 
            RowBox[{"-", 
              StyleBox["i",
                "TI"]}], ")"}], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "+", 
                StyleBox["i",
                  "TI"]}], ")"}], "2"]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.26"}],

Cell[CellGroupData[{

Cell["FactorInteger[2, GaussianIntegers -> True]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({{\(-\[ImaginaryI]\), 1}, {1 + \[ImaginaryI], 2}}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell["Here are the factors of a Gaussian integer. ", "MathCaption",
  CellTags->{"S3.2.5", "5.27"}],

Cell[CellGroupData[{

Cell["FactorInteger[111 + 78 I, GaussianIntegers -> True]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({{2 + \[ImaginaryI], 1}, {3, 1}, {20 + 3\ \[ImaginaryI], 
        1}}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PowerMod[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the power ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["a",
                        "TI"], 
                      StyleBox["b",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " modulo ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["EulerPhi[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the Euler totient function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Phi]", 
                      RowBox[{"(", 
                        StyleBox["n",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MoebiusMu[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the M\[ODoubleDot]bius function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Mu]", 
                      RowBox[{"(", 
                        StyleBox["n",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["DivisorSigma[", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the divisor function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox["\[Sigma]", 
                        StyleBox["k",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["n",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["JacobiSymbol[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the Jacobi symbol ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"(", 
                      FractionBox[
                        StyleBox["n",
                          "TI"], 
                        StyleBox["m",
                          "TI"]], ")"}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ExtendedGCD[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the extended gcd of ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MultiplicativeOrder[", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the multiplicative order of ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["k",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " modulo ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MultiplicativeOrder[", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the generalized multiplicative order with residues ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["CarmichaelLambda[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the Carmichael function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Lambda]", 
                      RowBox[{"(", 
                        StyleBox["n",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LatticeReduce[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the reduced lattice basis for the set of integer vectors ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.5"],

Cell["Some functions from number theory.", "Caption",
  CellTags->"S3.2.5"],

Cell[TextData[{
  "The ",
  StyleBox["modular power function", "TB"],
  " ",
  StyleBox["PowerMod[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " gives exactly the same results as ",
  StyleBox["Mod[", "MR"],
  StyleBox["a", "TI"],
  StyleBox["^", "MR"],
  StyleBox["b", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["b",
            "TI"], ">", "0"}], TraditionalForm]], "InlineFormula"],
  ". ",
  StyleBox["PowerMod", "MR"],
  " is much more efficient, however, because it avoids generating the full \
form of ",
  StyleBox["a", "TI"],
  StyleBox["^", "MR"],
  StyleBox["b", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.2.5", "5.28"}],

Cell[TextData[{
  "You can use ",
  StyleBox["PowerMod", "MR"],
  " not only to find positive modular powers, but also to find ",
  StyleBox["modular inverses", "TB"],
  ". For negative ",
  StyleBox["b", "TI"],
  ", ",
  StyleBox["PowerMod[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " gives, if possible, an integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " such that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k",
            "TI"], 
          SuperscriptBox[
            StyleBox["a",
              "TI"], 
            RowBox[{"-", 
              StyleBox["b",
                "TI"]}]], "\[Congruent]", "1", "mod", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". (Whenever such an integer exists, it is guaranteed to be unique modulo \
",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ".) If no such integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " exists, ",
  StyleBox["Mathematica", "TI"],
  " leaves ",
  StyleBox["PowerMod", "MR"],
  " unevaluated. "
}], "Text",
  CellTags->{"S3.2.5", "5.29"}],

Cell[TextData[{
  StyleBox["PowerMod", "MR"],
  " is equivalent to using ",
  StyleBox["Power", "MR"],
  ", then ",
  StyleBox["Mod", "MR"],
  ", but is much more efficient. "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.30"}],

Cell[CellGroupData[{

Cell["PowerMod[2, 13451, 3]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell["This gives the modular inverse of 3 modulo 7. ", "MathCaption",
  CellTags->{"S3.2.5", "5.31"}],

Cell[CellGroupData[{

Cell["PowerMod[3, -1, 7]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell["Multiplying the inverse by 3 modulo 7 gives 1, as expected. ", \
"MathCaption",
  CellTags->{"S3.2.5", "5.32"}],

Cell[CellGroupData[{

Cell["Mod[3 %, 7]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Euler totient function", "TB"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Phi]", 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " gives the number of integers less than ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " that are relatively prime to ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". An important relation (Fermat's Little Theorem) is that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["a",
              "TI"], 
            RowBox[{"\[Phi]", 
              RowBox[{"(", 
                StyleBox["n",
                  "TI"], ")"}]}]], "\[Congruent]", "1", "mod", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " for all ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  " relatively prime to ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.5", "5.33"}],

Cell[TextData[{
  "The ",
  StyleBox["M\[ODoubleDot]bius function", "TB"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Mu]", 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is defined to be ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[\((\(-1\))\), 
          StyleBox["k",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " if ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is a product of ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " distinct primes, and ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " if ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " contains a squared factor (other than 1). An important relation is the M\
\[ODoubleDot]bius inversion formula, which states that if ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["g",
            "TI"], 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}], "=", 
          UnderscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["d",
                "TI"], " ", \(\(\[VerticalSeparator]\)\(\ \)\), 
              StyleBox["n",
                "TI"]}],
            LimitsPositioning->True], 
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["d",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " for all ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", then ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}], "=", 
          UnderscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["d",
                "TI"], " ", \(\(\[VerticalSeparator]\)\(\ \)\), 
              StyleBox["n",
                "TI"]}],
            LimitsPositioning->True], "\[Mu]", 
          RowBox[{"(", 
            StyleBox["d",
              "TI"], ")"}], 
          StyleBox["g",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], "/", 
              StyleBox["d",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", where the sums are over all positive integers ",
  Cell[BoxData[
      FormBox[
        StyleBox["d",
          "TI"], TraditionalForm]], "InlineFormula"],
  " that divide ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.5", "5.34"}],

Cell[TextData[{
  "The ",
  StyleBox["divisor function", "TB"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Sigma]", 
            StyleBox["k",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is the sum of the ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " powers of the divisors of ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". The function ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Sigma]\_0\), 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " gives the total number of divisors of ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", and is variously denoted ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["d",
            "TI"], 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Nu]", 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Tau]", 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". The function ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Sigma]\_1\), 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", equal to the sum of the divisors of ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", is often denoted ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Sigma]", 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.5", "5.35"}],

Cell[TextData[{
  "For prime ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Phi]", 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}], "=", 
          StyleBox["n",
            "TI"], "-", "1"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.36"}],

Cell[CellGroupData[{

Cell["EulerPhi[17]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(16\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell["The result is 1, as guaranteed by Fermat's Little Theorem. ", \
"MathCaption",
  CellTags->{"S3.2.5", "5.37"}],

Cell[CellGroupData[{

Cell["PowerMod[3, %, 17]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell["This gives a list of all the divisors of 24. ", "MathCaption",
  CellTags->{"S3.2.5", "5.38"}],

Cell[CellGroupData[{

Cell["Divisors[24]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({1, 2, 3, 4, 6, 8, 12, 24}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Sigma]\_0\), 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " gives the total number of distinct divisors of 24. "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.39"}],

Cell[CellGroupData[{

Cell["DivisorSigma[0, 24]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(8\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Jacobi symbol", "TB"],
  " ",
  StyleBox["JacobiSymbol[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " reduces to the ",
  StyleBox["Legendre symbol", "TB"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          FractionBox[
            StyleBox["n",
              "TI"], 
            StyleBox["m",
              "TI"]], ")"}], TraditionalForm]], "InlineFormula"],
  " when ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is an odd prime. The Legendre symbol is equal to zero if ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is divisible by ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", otherwise it is equal to ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  " if ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is a quadratic residue modulo the prime ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", and to ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " if it is not. An integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " relatively prime to ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is said to be a quadratic residue modulo ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " if there exists an integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " such that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["k",
              "TI"], "2"], "\[Congruent]", 
          StyleBox["n",
            "TI"], "mod", 
          StyleBox["m",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". The full Jacobi symbol is a product of the Legendre symbols ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          FractionBox[
            StyleBox["n",
              "TI"], 
            SubscriptBox[
              StyleBox["p",
                "TI"], 
              StyleBox["i",
                "TI"]]], ")"}], TraditionalForm]], "InlineFormula"],
  " for each of the prime factors ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["p",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " such that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "=", 
          UnderscriptBox["\[Product]", 
            StyleBox["i",
              "TI"],
            LimitsPositioning->True], 
          SubscriptBox[
            StyleBox["p",
              "TI"], 
            StyleBox["i",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.5", "5.40"}],

Cell[TextData[{
  "The ",
  StyleBox["extended gcd", "TB"],
  " ",
  StyleBox["ExtendedGCD[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " gives a list ",
  StyleBox["{", "MR"],
  StyleBox["g", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}}", "MR"],
  " where ",
  Cell[BoxData[
      FormBox[
        StyleBox["g",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is the greatest common divisor of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", and the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " are integers such that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["g",
            "TI"], "=", 
          SubscriptBox[
            StyleBox["r",
              "TI"], "1"], 
          SubscriptBox[
            StyleBox["n",
              "TI"], "1"], "+", 
          SubscriptBox[
            StyleBox["r",
              "TI"], "2"], 
          SubscriptBox[
            StyleBox["n",
              "TI"], "2"], "+", "\[Ellipsis]"}], TraditionalForm]], 
    "InlineFormula"],
  ". The extended gcd is important in finding integer solutions to linear \
Diophantine equations.   "
}], "Text",
  CellTags->{"S3.2.5", "5.41"}],

Cell["The first number in the list is the gcd of 105 and 196. ", "MathCaption",
  CellTags->{"S3.2.5", "5.42"}],

Cell[CellGroupData[{

Cell["ExtendedGCD[105, 196]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({7, {\(-13\), 7}}\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "The second pair of numbers satisfies ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["g",
            "TI"], "=", 
          StyleBox["r",
            "TI"], 
          StyleBox["m",
            "TI"], "+", 
          StyleBox["s",
            "TI"], 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.43"}],

Cell[CellGroupData[{

Cell["-13 105 + 7 196", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(7\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["multiplicative order function", "TB"],
  " ",
  StyleBox["MultiplicativeOrder[", "MR"],
  StyleBox["k", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " gives the smallest integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " such that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["k",
              "TI"], 
            StyleBox["m",
              "TI"]], "\[Congruent]", "1", "mod", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". The function is sometimes known as the ",
  StyleBox["index", "TB"],
  " or ",
  StyleBox["discrete log", "TB"],
  " of ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". The notation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["ord", 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["k",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is occasionally used. "
}], "Text",
  CellTags->{"S3.2.5", "5.44"}],

Cell[TextData[{
  "The ",
  StyleBox["generalized multiplicative order function", "TB"],
  " ",
  StyleBox["MultiplicativeOrder[", "MR"],
  StyleBox["k", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " gives the smallest integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " such that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["k",
              "TI"], 
            StyleBox["m",
              "TI"]], "\[Congruent]", 
          SubscriptBox[
            StyleBox["r",
              "TI"], 
            StyleBox["i",
              "TI"]], "mod", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " for some ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". ",
  StyleBox["MultiplicativeOrder[", "MR"],
  StyleBox["k", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{-1,", "MR"],
  " ",
  StyleBox["1}]", "MR"],
  " is sometimes known as the ",
  StyleBox["suborder function", "TB"],
  " of ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " modulo ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", denoted ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["sord", 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["k",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.5", "5.45"}],

Cell[TextData[{
  "The ",
  StyleBox["Carmichael function", "TB"],
  " or ",
  StyleBox["least universal exponent", "TB"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Lambda]", 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " gives the smallest integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " such that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["k",
              "TI"], 
            StyleBox["m",
              "TI"]], "\[Congruent]", "1", "mod", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " for all integers ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " relatively prime to ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.5", "5.46"}],

Cell[TextData[{
  "The lattice reduction function ",
  StyleBox["LatticeReduce[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["v",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["v",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " is used in several kinds of modern algorithms. The basic idea is to think \
of the vectors ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["v",
            "TI"], 
          StyleBox["k",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " of integers as defining a mathematical ",
  StyleBox["lattice", "TI"],
  ". Any vector representing a point in the lattice can be written as a \
linear combination of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Sum]", 
          SubscriptBox[
            StyleBox["c",
              "TI"], 
            StyleBox["k",
              "TI"]], " ", 
          SubscriptBox[
            StyleBox["v",
              "TI"], 
            StyleBox["k",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ", where the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            "TI"], 
          StyleBox["k",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " are integers. For a particular lattice, there are many possible choices \
of the \[OpenCurlyDoubleQuote]basis vectors\[CloseCurlyDoubleQuote] ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["v",
            "TI"], 
          StyleBox["k",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". What ",
  StyleBox["LatticeReduce", "MR"],
  " does is to find a reduced set of basis vectors ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          OverscriptBox[
            StyleBox["v",
              "TI"], "_"], 
          StyleBox["k",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " for the lattice, with certain special properties.  "
}], "Text",
  CellTags->{"S3.2.5", "5.47"}],

Cell["\<\
Three unit vectors along the three coordinate axes already form a \
reduced basis. \
\>", "MathCaption",
  CellTags->{"S3.2.5", "5.48"}],

Cell[CellGroupData[{

Cell["LatticeReduce[{{1,0,0},{0,1,0},{0,0,1}}]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell["\<\
This gives the reduced basis for a lattice in \
four\[Hyphen]dimensional space specified by three vectors. \
\>", \
"MathCaption",
  CellTags->{"S3.2.5", "5.49"}],

Cell[CellGroupData[{

Cell["LatticeReduce[{{1,0,0,12345}, {0,1,0,12435}, {0,0,1,12354}}]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({{\(-1\), 0, 1, 9}, {9, 1, \(-10\), 0}, {85, \(-143\), 59, 
        6}}\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "Notice that in the last example, ",
  StyleBox["LatticeReduce", "MR"],
  " replaces vectors that are nearly parallel by vectors that are more \
perpendicular. In the process, it finds some quite short basis vectors. "
}], "Text",
  CellTags->{"S3.2.5", "5.50"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ContinuedFraction[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate the first ",
              StyleBox["n", "TI"],
              " terms in the continued fraction representation of ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FromContinuedFraction[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
reconstruct a number from its continued fraction \
representation \
\>"]},
          {Cell[TextData[{
              StyleBox["Rationalize[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dx", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find a rational approximation to ",
              StyleBox["x", "TI"],
              " with tolerance ",
              StyleBox["dx", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.5"],

Cell["Continued fractions. ", "Caption",
  CellTags->"S3.2.5"],

Cell[TextData[{
  "This generates the first 10 terms in the continued fraction representation \
for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.51"}],

Cell[CellGroupData[{

Cell["ContinuedFraction[Pi, 10]", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({3, 7, 15, 1, 292, 1, 1, 1, 2, 1}\)], "Output",
  CellLabel->"Out[29]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell["\<\
This reconstructs the number represented by the list of continued \
fraction terms. \
\>", "MathCaption",
  CellTags->{"S3.2.5", "5.52"}],

Cell[CellGroupData[{

Cell["FromContinuedFraction[%]", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(1146408\/364913\)], "Output",
  CellLabel->"Out[30]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "The result is close to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.53"}],

Cell[CellGroupData[{

Cell["N[%]", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(3.141592653591404`\)], "Output",
  CellLabel->"Out[31]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "This gives directly a rational approximation to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.54"}],

Cell[CellGroupData[{

Cell["Rationalize[Pi, 1/1000]", "Input",
  CellLabel->"In[32]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(201\/64\)], "Output",
  CellLabel->"Out[32]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Continued fractions", "TB"],
  " appear in many number\[Hyphen]theoretical settings. Rational numbers have \
terminating continued fraction representations. Quadratic irrational numbers \
have continued fraction representations that become repetitive. "
}], "Text",
  CellTags->{"S3.2.5", "5.55"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ContinuedFraction[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
the complete continued fraction representation for a \
rational or quadratic irrational number \
\>"]},
          {Cell[TextData[{
              StyleBox["RealDigits[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the complete digit sequence for a rational number "]},
          {Cell[TextData[{
              StyleBox["RealDigits[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the complete digit sequence in base ",
              StyleBox["b", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.5"],

Cell["Complete representations for numbers. ", "Caption",
  CellTags->"S3.2.5"],

Cell[TextData[{
  "The continued fraction representation of ",
  Cell[BoxData[
      \(TraditionalForm\`\@79\)], "InlineFormula"],
  " starts with the term 8, then involves a sequence of terms that repeat \
forever. "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.56"}],

Cell[CellGroupData[{

Cell["ContinuedFraction[Sqrt[79]]", "Input",
  CellLabel->"In[33]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({8, {1, 7, 1, 16}}\)], "Output",
  CellLabel->"Out[33]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "This reconstructs ",
  Cell[BoxData[
      \(TraditionalForm\`\@79\)], "InlineFormula"],
  " from its continued fraction representation. "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.57"}],

Cell[CellGroupData[{

Cell["FromContinuedFraction[%]", "Input",
  CellLabel->"In[34]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(\@79\)], "Output",
  CellLabel->"Out[34]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "This shows the recurring sequence of decimal digits in ",
  Cell[BoxData[
      \(TraditionalForm\`3/7\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.58"}],

Cell[CellGroupData[{

Cell["RealDigits[3/7]", "Input",
  CellLabel->"In[35]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({{{4, 2, 8, 5, 7, 1}}, 0}\)], "Output",
  CellLabel->"Out[35]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FromDigits", "MR"],
  " reconstructs the original number. "
}], "MathCaption",
  CellTags->{"S3.2.5", "5.59"}],

Cell[CellGroupData[{

Cell["FromDigits[%]", "Input",
  CellLabel->"In[36]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(3\/7\)], "Output",
  CellLabel->"Out[36]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DigitCount[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the number of ",
              StyleBox["d", "TI"],
              " digits in the base ",
              StyleBox["b", "TI"],
              " representation of ",
              StyleBox["n", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.5"],

Cell["Digit count function. ", "Caption",
  CellTags->"S3.2.5"],

Cell["\<\
Here are the digits in the base 2 representation of the number 77. \
\
\>", "MathCaption",
  CellTags->{"S3.2.5", "5.60"}],

Cell[CellGroupData[{

Cell["IntegerDigits[77, 2]", "Input",
  CellLabel->"In[37]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \({1, 0, 0, 1, 1, 0, 1}\)], "Output",
  CellLabel->"Out[37]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell["\<\
This directly computes the number of ones in the base 2 \
representation. \
\>", "MathCaption",
  CellTags->{"S3.2.5", "5.61"}],

Cell[CellGroupData[{

Cell["DigitCount[77, 2, 1]", "Input",
  CellLabel->"In[38]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[38]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell["\<\
The plot of the digit count function is self\[Hyphen]similar.  \
\
\>", "MathCaption",
  CellTags->{"S3.2.5", "5.62"}],

Cell[CellGroupData[{

Cell["\<\
ListPlot[Table[DigitCount[n, 2, 1], {n, 128}], \
PlotJoined->True]\
\>", "Input",
  CellLabel->"In[39]:= ",
  CellTags->"S3.2.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00744048 0.0147151 0.0840863 [
[.17262 .00222 -6 -9 ]
[.17262 .00222 6 0 ]
[.32143 .00222 -6 -9 ]
[.32143 .00222 6 0 ]
[.47024 .00222 -6 -9 ]
[.47024 .00222 6 0 ]
[.61905 .00222 -6 -9 ]
[.61905 .00222 6 0 ]
[.76786 .00222 -9 -9 ]
[.76786 .00222 9 0 ]
[.91667 .00222 -9 -9 ]
[.91667 .00222 9 0 ]
[.01131 .0988 -6 -4.5 ]
[.01131 .0988 0 4.5 ]
[.01131 .18289 -6 -4.5 ]
[.01131 .18289 0 4.5 ]
[.01131 .26697 -6 -4.5 ]
[.01131 .26697 0 4.5 ]
[.01131 .35106 -6 -4.5 ]
[.01131 .35106 0 4.5 ]
[.01131 .43515 -6 -4.5 ]
[.01131 .43515 0 4.5 ]
[.01131 .51923 -6 -4.5 ]
[.01131 .51923 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17262 .01472 m
.17262 .02097 L
s
[(20)] .17262 .00222 0 1 Mshowa
.32143 .01472 m
.32143 .02097 L
s
[(40)] .32143 .00222 0 1 Mshowa
.47024 .01472 m
.47024 .02097 L
s
[(60)] .47024 .00222 0 1 Mshowa
.61905 .01472 m
.61905 .02097 L
s
[(80)] .61905 .00222 0 1 Mshowa
.76786 .01472 m
.76786 .02097 L
s
[(100)] .76786 .00222 0 1 Mshowa
.91667 .01472 m
.91667 .02097 L
s
[(120)] .91667 .00222 0 1 Mshowa
.125 Mabswid
.06101 .01472 m
.06101 .01847 L
s
.09821 .01472 m
.09821 .01847 L
s
.13542 .01472 m
.13542 .01847 L
s
.20982 .01472 m
.20982 .01847 L
s
.24702 .01472 m
.24702 .01847 L
s
.28423 .01472 m
.28423 .01847 L
s
.35863 .01472 m
.35863 .01847 L
s
.39583 .01472 m
.39583 .01847 L
s
.43304 .01472 m
.43304 .01847 L
s
.50744 .01472 m
.50744 .01847 L
s
.54464 .01472 m
.54464 .01847 L
s
.58185 .01472 m
.58185 .01847 L
s
.65625 .01472 m
.65625 .01847 L
s
.69345 .01472 m
.69345 .01847 L
s
.73065 .01472 m
.73065 .01847 L
s
.80506 .01472 m
.80506 .01847 L
s
.84226 .01472 m
.84226 .01847 L
s
.87946 .01472 m
.87946 .01847 L
s
.95387 .01472 m
.95387 .01847 L
s
.99107 .01472 m
.99107 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .0988 m
.03006 .0988 L
s
[(1)] .01131 .0988 1 0 Mshowa
.02381 .18289 m
.03006 .18289 L
s
[(2)] .01131 .18289 1 0 Mshowa
.02381 .26697 m
.03006 .26697 L
s
[(3)] .01131 .26697 1 0 Mshowa
.02381 .35106 m
.03006 .35106 L
s
[(4)] .01131 .35106 1 0 Mshowa
.02381 .43515 m
.03006 .43515 L
s
[(5)] .01131 .43515 1 0 Mshowa
.02381 .51923 m
.03006 .51923 L
s
[(6)] .01131 .51923 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(7)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03153 m
.02756 .03153 L
s
.02381 .04835 m
.02756 .04835 L
s
.02381 .06517 m
.02756 .06517 L
s
.02381 .08198 m
.02756 .08198 L
s
.02381 .11562 m
.02756 .11562 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .14925 m
.02756 .14925 L
s
.02381 .16607 m
.02756 .16607 L
s
.02381 .1997 m
.02756 .1997 L
s
.02381 .21652 m
.02756 .21652 L
s
.02381 .23334 m
.02756 .23334 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .28379 m
.02756 .28379 L
s
.02381 .30061 m
.02756 .30061 L
s
.02381 .31743 m
.02756 .31743 L
s
.02381 .33424 m
.02756 .33424 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .38469 m
.02756 .38469 L
s
.02381 .40151 m
.02756 .40151 L
s
.02381 .41833 m
.02756 .41833 L
s
.02381 .45196 m
.02756 .45196 L
s
.02381 .46878 m
.02756 .46878 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .50242 m
.02756 .50242 L
s
.02381 .53605 m
.02756 .53605 L
s
.02381 .55287 m
.02756 .55287 L
s
.02381 .56968 m
.02756 .56968 L
s
.02381 .5865 m
.02756 .5865 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.03125 .0988 m
.03869 .0988 L
.04613 .18289 L
.05357 .0988 L
.06101 .18289 L
.06845 .18289 L
.07589 .26697 L
.08333 .0988 L
.09077 .18289 L
.09821 .18289 L
.10565 .26697 L
.1131 .18289 L
.12054 .26697 L
.12798 .26697 L
.13542 .35106 L
.14286 .0988 L
.1503 .18289 L
.15774 .18289 L
.16518 .26697 L
.17262 .18289 L
.18006 .26697 L
.1875 .26697 L
.19494 .35106 L
.20238 .18289 L
.20982 .26697 L
.21726 .26697 L
.2247 .35106 L
.23214 .26697 L
.23958 .35106 L
.24702 .35106 L
.25446 .43515 L
.2619 .0988 L
.26935 .18289 L
.27679 .18289 L
.28423 .26697 L
.29167 .18289 L
.29911 .26697 L
.30655 .26697 L
.31399 .35106 L
.32143 .18289 L
.32887 .26697 L
.33631 .26697 L
.34375 .35106 L
.35119 .26697 L
.35863 .35106 L
.36607 .35106 L
.37351 .43515 L
.38095 .18289 L
.38839 .26697 L
.39583 .26697 L
Mistroke
.40327 .35106 L
.41071 .26697 L
.41815 .35106 L
.4256 .35106 L
.43304 .43515 L
.44048 .26697 L
.44792 .35106 L
.45536 .35106 L
.4628 .43515 L
.47024 .35106 L
.47768 .43515 L
.48512 .43515 L
.49256 .51923 L
.5 .0988 L
.50744 .18289 L
.51488 .18289 L
.52232 .26697 L
.52976 .18289 L
.5372 .26697 L
.54464 .26697 L
.55208 .35106 L
.55952 .18289 L
.56696 .26697 L
.5744 .26697 L
.58185 .35106 L
.58929 .26697 L
.59673 .35106 L
.60417 .35106 L
.61161 .43515 L
.61905 .18289 L
.62649 .26697 L
.63393 .26697 L
.64137 .35106 L
.64881 .26697 L
.65625 .35106 L
.66369 .35106 L
.67113 .43515 L
.67857 .26697 L
.68601 .35106 L
.69345 .35106 L
.70089 .43515 L
.70833 .35106 L
.71577 .43515 L
.72321 .43515 L
.73065 .51923 L
.7381 .18289 L
.74554 .26697 L
.75298 .26697 L
.76042 .35106 L
.76786 .26697 L
Mistroke
.7753 .35106 L
.78274 .35106 L
.79018 .43515 L
.79762 .26697 L
.80506 .35106 L
.8125 .35106 L
.81994 .43515 L
.82738 .35106 L
.83482 .43515 L
.84226 .43515 L
.8497 .51923 L
.85714 .26697 L
.86458 .35106 L
.87202 .35106 L
.87946 .43515 L
.8869 .35106 L
.89435 .43515 L
.90179 .43515 L
.90923 .51923 L
.91667 .35106 L
.92411 .43515 L
.93155 .43515 L
.93899 .51923 L
.94643 .43515 L
.95387 .51923 L
.96131 .51923 L
.96875 .60332 L
.97619 .0988 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[39]= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["BitAnd[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "bitwise AND of the integers ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["BitOr[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "bitwise OR of the integers ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["BitXor[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "bitwise XOR of the integers ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["BitNot[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "bitwise NOT of the integer ",
              StyleBox["n", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.5"],

Cell["Bitwise operations. ", "Caption",
  CellTags->"S3.2.5"],

Cell[TextData[{
  "Bitwise operations act on integers represented as binary bits. ",
  StyleBox["BitAnd[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " yields the integer whose binary bit representation has ones at positions \
where the binary bit representations of all of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " have ones. ",
  StyleBox["BitOr[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " yields the integer with ones at positions where any of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " have ones. ",
  StyleBox["BitXor[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["]", "MR"],
  " yields the integer with ones at positions where ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " or ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " but not both have ones. ",
  StyleBox["BitXor[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " has ones where an odd number of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " have ones. "
}], "Text",
  CellTags->{"S3.2.5", "5.63"}],

Cell["\<\
This finds the bitwise AND of the numbers 23 and 29 entered in base \
2. \
\>", "MathCaption",
  CellTags->{"S3.2.5", "5.64"}],

Cell[CellGroupData[{

Cell["BaseForm[BitAnd[2^^10111, 2^^11101], 2]", "Input",
  CellLabel->"In[40]:= ",
  CellTags->"S3.2.5"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("10101"\_"2"\),
        21,
        Editable->False],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[40]//BaseForm= ",
  CellTags->"S3.2.5"]
}, Open  ]],

Cell[TextData[{
  "Bitwise operations are used in various combinatorial algorithms. They are \
also commonly used in manipulating bitfields in low\[Hyphen]level computer \
languages. In such languages, however, integers normally have a limited \
number of digits, typically a multiple of 8. Bitwise operations in ",
  StyleBox["Mathematica", "TI"],
  " in effect allow integers to have an unlimited number of digits. When an \
integer is negative, it is taken to be represented in two's complement form, \
with an infinite sequence of ones on the left. This allows ",
  StyleBox["BitNot[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " to be equivalent simply to ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(-1\), "-", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.2.5", "5.65"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2.6 Combinatorial Functions", "Subsection",
  CellTags->{"S3.2.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["n", "TI"],
              StyleBox["!", "MR"],
              " "
            }]], Cell[TextData[{
              "factorial ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["n",
                        "TI"], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["n",
                            "TI"], "-", "1"}], ")"}], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["n",
                            "TI"], "-", "2"}], ")"}], "\[Cross]", 
                      "\[Ellipsis]", "\[Cross]", "1"}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["n", "TI"],
              StyleBox["!!", "MR"],
              " "
            }]], Cell[TextData[{
              "double factorial ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["n",
                        "TI"], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["n",
                            "TI"], "-", "2"}], ")"}], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["n",
                            "TI"], "-", "4"}], ")"}], "\[Cross]", 
                      "\[Ellipsis]"}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Binomial[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "binomial coefficient ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      RowBox[{"(", 
                        FractionBox[
                          StyleBox["n",
                            "TI"], 
                          StyleBox["m",
                            "TI"],
                          FractionLine->None], ")"}], "=", 
                      StyleBox["n",
                        "TI"], "!", "/", 
                      RowBox[{"[", 
                        RowBox[{
                          StyleBox["m",
                            "TI"], "!", 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["n",
                                "TI"], "-", 
                              StyleBox["m",
                                "TI"]}], ")"}], "!"}], "]"}]}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Multinomial[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "multinomial coefficient ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      RowBox[{"(", 
                        RowBox[{
                          SubscriptBox[
                            StyleBox["n",
                              "TI"], "1"], "+", 
                          SubscriptBox[
                            StyleBox["n",
                              "TI"], "2"], "+", "\[Ellipsis]"}], ")"}], "!", 
                      "/", 
                      RowBox[{"(", 
                        RowBox[{
                          SubscriptBox[
                            StyleBox["n",
                              "TI"], "1"], "!", 
                          SubscriptBox[
                            StyleBox["n",
                              "TI"], "2"], "!", "\[Ellipsis]"}], ")"}]}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Fibonacci[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Fibonacci number ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["F",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Fibonacci[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Fibonacci polynomial ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["F",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["x",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["HarmonicNumber[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "harmonic number ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["H",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["HarmonicNumber[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["r", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "harmonic number ",
              Cell[BoxData[
                  FormBox[
                    SubsuperscriptBox[
                      StyleBox["H",
                        "TI"], 
                      StyleBox["n",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["r",
                          "TI"], ")"}]], TraditionalForm]], "InlineFormula"],
              " of order ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["r",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["BernoulliB[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Bernoulli number ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["B",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["BernoulliB[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Bernoulli polynomial ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["B",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["x",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["EulerE[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Euler number ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["E",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["EulerE[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Euler polynomial ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["E",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["x",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StirlingS1[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Stirling number of the first kind ",
              Cell[BoxData[
                  FormBox[
                    SubsuperscriptBox[
                      StyleBox["S",
                        "TI"], 
                      StyleBox["n",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["m",
                          "TI"], ")"}]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StirlingS2[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Stirling number of the second kind ",
              Cell[BoxData[
                  FormBox[
                    SubsuperscriptBox["\[ScriptCapitalS]", 
                      StyleBox["n",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["m",
                          "TI"], ")"}]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PartitionsP[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the number ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["p",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["n",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " of unrestricted partitions of the integer ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PartitionsQ[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the number ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["q",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["n",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " of partitions of ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " into distinct parts "
            }]]},
          {Cell[TextData[{
              StyleBox["Signature[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["the signature of a permutation "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    False, False, False, True, False, True, False, True, False, False, False, 
      True, False, False, False, True}},
  CellTags->"S3.2.6"],

Cell["Combinatorial functions.", "Caption",
  CellTags->"S3.2.6"],

Cell[TextData[{
  "The ",
  StyleBox["factorial function", "TB"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["!", "MR"],
  " gives the number of ways of ordering ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " objects. For non\[Hyphen]integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", the numerical value of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "!"}], TraditionalForm]], "InlineFormula"],
  " is obtained from the gamma function, discussed in Section ",
  ButtonBox["3.2.11",
    ButtonData:>{"3.2.11", "11.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S3.2.6", "6.2"}],

Cell[TextData[{
  "The ",
  StyleBox["binomial coefficient", "TB"],
  " ",
  StyleBox["Binomial[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " can be written as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"(", 
            FractionBox[
              StyleBox["n",
                "TI"], 
              StyleBox["m",
                "TI"],
              FractionLine->None], ")"}], "=", 
          StyleBox["n",
            "TI"], "!", "/", 
          RowBox[{"[", 
            RowBox[{
              StyleBox["m",
                "TI"], "!", 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["n",
                    "TI"], "-", 
                  StyleBox["m",
                    "TI"]}], ")"}], "!"}], "]"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". It gives the number of ways of choosing ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " objects from a collection of ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " objects, without regard to order. The ",
  StyleBox["Catalan numbers", "TB"],
  ", which appear in various tree enumeration problems, are given in terms of \
binomial coefficients as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["c",
              "TI"], 
            StyleBox["n",
              "TI"]], "=", 
          RowBox[{"(", 
            FractionBox[
              RowBox[{"2", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["n",
                "TI"],
              FractionLine->None], ")"}], "/", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], "+", "1"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.6", "6.3"}],

Cell[TextData[{
  "The ",
  StyleBox["multinomial coefficient", "TB"],
  " ",
  StyleBox["Multinomial[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ", denoted ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              StyleBox["N",
                "TI"], ";", 
              SubscriptBox[
                StyleBox["n",
                  "TI"], "1"], ",", 
              SubscriptBox[
                StyleBox["n",
                  "TI"], "2"], ",", "...", ",", 
              SubscriptBox[
                StyleBox["n",
                  "TI"], 
                StyleBox["m",
                  "TI"]]}], ")"}], " ", "="}], TraditionalForm]], 
    "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["N",
              "TI"], "!"}], "/", 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox[
                StyleBox["n",
                  "TI"], "1"], "!", 
              SubscriptBox[
                StyleBox["n",
                  "TI"], "2"], \(!  ... \), 
              SubscriptBox[
                StyleBox["n",
                  "TI"], 
                StyleBox["m",
                  "TI"]], "!"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ", gives the number of ways of partitioning ",
  Cell[BoxData[
      FormBox[
        StyleBox["N",
          "TI"], TraditionalForm]], "InlineFormula"],
  " distinct objects into ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " sets of sizes ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " (with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["N",
            "TI"], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["i",
                "TI"], "=", "1"}], 
            StyleBox["m",
              "TI"],
            LimitsPositioning->True], 
          SubscriptBox[
            StyleBox["n",
              "TI"], 
            StyleBox["i",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ").  "
}], "Text",
  CellTags->{"S3.2.6", "6.4"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " gives the exact integer result for the factorial of an integer. "
}], "MathCaption",
  CellTags->{"S3.2.6", "6.5"}],

Cell[CellGroupData[{

Cell["30!", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.2.6"],

Cell[BoxData[
    \(265252859812191058636308480000000\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.2.6"]
}, Open  ]],

Cell[TextData[{
  "For non\[Hyphen]integers, ",
  StyleBox["Mathematica", "TI"],
  " evaluates factorials using the gamma function. "
}], "MathCaption",
  CellTags->{"S3.2.6", "6.6"}],

Cell[CellGroupData[{

Cell["3.6!", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.2.6"],

Cell[BoxData[
    \(13.381285870932443`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.2.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can give symbolic results for some binomial coefficients. "
}], "MathCaption",
  CellTags->{"S3.2.6", "6.7"}],

Cell[CellGroupData[{

Cell["Binomial[n, 2]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.2.6"],

Cell[BoxData[
    \(1\/2\ \((\(-1\) + n)\)\ n\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.2.6"]
}, Open  ]],

Cell[TextData[{
  "This gives the number of ways of partitioning ",
  Cell[BoxData[
      \(TraditionalForm\`6 + 5 = 11\)], "InlineFormula"],
  " objects into sets containing 6 and 5 objects. "
}], "MathCaption",
  CellTags->{"S3.2.6", "6.8"}],

Cell[CellGroupData[{

Cell["Multinomial[6, 5]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.2.6"],

Cell[BoxData[
    \(462\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.2.6"]
}, Open  ]],

Cell[TextData[{
  "The result is the same as ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          FractionBox["11", "6",
            FractionLine->None], ")"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.6", "6.9"}],

Cell[CellGroupData[{

Cell["Binomial[11, 6]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.2.6"],

Cell[BoxData[
    \(462\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.2.6"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Fibonacci numbers", "TB"],
  " ",
  StyleBox["Fibonacci[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " satisfy the recurrence relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["F",
              "TI"], 
            StyleBox["n",
              "TI"]], "=", 
          SubscriptBox[
            StyleBox["F",
              "TI"], 
            RowBox[{
              StyleBox["n",
                "TI"], "-", "1"}]], "+", 
          SubscriptBox[
            StyleBox["F",
              "TI"], 
            RowBox[{
              StyleBox["n",
                "TI"], "-", "2"}]]}], TraditionalForm]], "InlineFormula"],
  " with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], "=", 
          SubscriptBox[
            StyleBox["F",
              "TI"], "2"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  ". They appear in a wide range of discrete mathematical problems. For large \
",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["F",
              "TI"], 
            StyleBox["n",
              "TI"]], "/", 
          SubscriptBox[
            StyleBox["F",
              "TI"], 
            RowBox[{
              StyleBox["n",
                "TI"], "-", "1"}]]}], TraditionalForm]], "InlineFormula"],
  " approaches the golden ratio. "
}], "Text",
  CellTags->{"S3.2.6", "6.10"}],

Cell[TextData[{
  "The ",
  StyleBox["Fibonacci polynomials", "TB"],
  " ",
  StyleBox["Fibonacci[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " appear as the coefficients of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["t",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " in the expansion of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["t",
            "TI"], "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", 
              StyleBox["x",
                "TI"], 
              StyleBox["t",
                "TI"], "-", 
              SuperscriptBox[
                StyleBox["t",
                  "TI"], "2"]}], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["n",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          SubscriptBox[
            StyleBox["F",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            StyleBox["n",
              "TI"]], " "}], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.6", "6.11"}],

Cell[TextData[{
  "The ",
  StyleBox["harmonic numbers", "TB"],
  " ",
  StyleBox["HarmonicNumber[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " are given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["H",
              "TI"], 
            StyleBox["n",
              "TI"]], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["i",
                "TI"], "=", "1"}], 
            StyleBox["n",
              "TI"],
            LimitsPositioning->True], "1", "/", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  "; the harmonic numbers of order ",
  Cell[BoxData[
      FormBox[
        StyleBox["r",
          "TI"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["HarmonicNumber[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["r", "TI"],
  StyleBox["]", "MR"],
  " are given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["H",
              "TI"], 
            StyleBox["n",
              "TI"], 
            RowBox[{"(", 
              StyleBox["r",
                "TI"], ")"}]], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["i",
                "TI"], "=", "1"}], 
            StyleBox["n",
              "TI"],
            LimitsPositioning->True], "1", "/", 
          SuperscriptBox[
            StyleBox["i",
              "TI"], 
            StyleBox["r",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". Harmonic numbers appear in many combinatorial estimation problems, often \
playing the role of discrete analogs of logarithms. "
}], "Text",
  CellTags->{"S3.2.6", "6.12"}],

Cell[TextData[{
  "The ",
  StyleBox["Bernoulli polynomials", "TB"],
  " ",
  StyleBox["BernoulliB[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " satisfy the generating function relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["t",
              "TI"], 
            SuperscriptBox[
              StyleBox["e",
                "TI"], 
              StyleBox[\(x  t\),
                "TI"]]}], "/", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["e",
                  "TI"], 
                StyleBox["t",
                  "TI"]], "-", "1"}], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["n",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          SubscriptBox[
            StyleBox["B",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            StyleBox["n",
              "TI"]], "/", 
          RowBox[{
            StyleBox["n",
              "TI"], "!"}], " "}], TraditionalForm]], "InlineFormula"],
  ". The ",
  StyleBox["Bernoulli numbers", "TB"],
  " ",
  StyleBox["BernoulliB[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " are given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["B",
              "TI"], 
            StyleBox["n",
              "TI"]], "=", 
          SubscriptBox[
            StyleBox["B",
              "TI"], 
            StyleBox["n",
              "TI"]], \((0)\)}], TraditionalForm]], "InlineFormula"],
  ". The ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["B",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " appear as the coefficients of the terms in the Euler\[Hyphen]Maclaurin \
summation formula for approximating integrals. The Bernoulli numbers are \
related to the ",
  StyleBox["Genocchi numbers", "TB"],
  " by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["G",
              "TI"], 
            StyleBox["n",
              "TI"]], "=", "2", 
          RowBox[{"(", 
            RowBox[{"1", "-", 
              SuperscriptBox["2", 
                StyleBox["n",
                  "TI"]]}], ")"}], 
          SubscriptBox[
            StyleBox["B",
              "TI"], 
            StyleBox["n",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.6", "6.13"}],

Cell[TextData[{
  "Numerical values for Bernoulli numbers are needed in many numerical \
algorithms. You can always get these numerical values by first finding exact \
rational results using ",
  StyleBox["BernoulliB[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ", and then applying ",
  StyleBox["N", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.2.6", "6.14"}],

Cell[TextData[{
  "The ",
  StyleBox["Euler polynomials", "TB"],
  " ",
  StyleBox["EulerE[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " have generating function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"2", 
            SuperscriptBox[
              StyleBox["e",
                "TI"], 
              StyleBox[\(x  t\),
                "TI"]]}], "/", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["e",
                  "TI"], 
                StyleBox["t",
                  "TI"]], "+", "1"}], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["n",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          SubscriptBox[
            StyleBox["E",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            StyleBox["n",
              "TI"]], "/", 
          RowBox[{
            StyleBox["n",
              "TI"], "!"}], " "}], TraditionalForm]], "InlineFormula"],
  ", and the ",
  StyleBox["Euler numbers", "TB"],
  " ",
  StyleBox["EulerE[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " are given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["E",
              "TI"], 
            StyleBox["n",
              "TI"]], "=", 
          SuperscriptBox["2", 
            StyleBox["n",
              "TI"]], 
          SubscriptBox[
            StyleBox["E",
              "TI"], 
            StyleBox["n",
              "TI"]], \((1\/2)\)}], TraditionalForm]], "InlineFormula"],
  "."
}], "Text",
  CellTags->{"S3.2.6", "6.15"}],

Cell[TextData[{
  "This gives the second Bernoulli polynomial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["B",
              "TI"], "2"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.6", "6.16"}],

Cell[CellGroupData[{

Cell["BernoulliB[2, x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.2.6"],

Cell[BoxData[
    \(1\/6 - x + x\^2\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.2.6"]
}, Open  ]],

Cell["\<\
You can also get Bernoulli polynomials by explicitly computing the \
power series for the generating function. \
\>", "MathCaption",
  CellTags->{"S3.2.6", "6.17"}],

Cell[CellGroupData[{

Cell["Series[t Exp[x t]/(Exp[t] - 1), {t, 0, 4}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.2.6"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", \(\((\(-\(1\/2\)\) + x)\)\ t\), 
        "+", \(\((1\/12 - x\/2 + x\^2\/2)\)\ t\^2\), 
        "+", \(\((x\/12 - x\^2\/4 + x\^3\/6)\)\ t\^3\), 
        "+", \(\((\(-\(1\/720\)\) + x\^2\/24 - x\^3\/12 + x\^4\/24)\)\ t\^4\),
         "+", 
        InterpretationBox[\(O[t]\^5\),
          SeriesData[ t, 0, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ t, 0, {1, 
        Plus[ 
          Rational[ -1, 2], x], 
        Plus[ 
          Rational[ 1, 12], 
          Times[ 
            Rational[ -1, 2], x], 
          Times[ 
            Rational[ 1, 2], 
            Power[ x, 2]]], 
        Plus[ 
          Times[ 
            Rational[ 1, 12], x], 
          Times[ 
            Rational[ -1, 4], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 1, 6], 
            Power[ x, 3]]], 
        Plus[ 
          Rational[ -1, 720], 
          Times[ 
            Rational[ 1, 24], 
            Power[ x, 2]], 
          Times[ 
            Rational[ -1, 12], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 1, 24], 
            Power[ x, 4]]]}, 0, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.2.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["BernoulliB[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " gives exact rational\[Hyphen]number results for Bernoulli numbers. "
}], "MathCaption",
  CellTags->{"S3.2.6", "6.18"}],

Cell[CellGroupData[{

Cell["BernoulliB[20]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.2.6"],

Cell[BoxData[
    \(\(-\(174611\/330\)\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.2.6"]
}, Open  ]],

Cell[TextData[{
  "Stirling numbers show up in many combinatorial enumeration problems. For \
",
  StyleBox["Stirling numbers of the first kind", "TB"],
  " ",
  StyleBox["StirlingS1[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[\((\(-1\))\), 
            RowBox[{
              StyleBox["n",
                "TI"], "-", 
              StyleBox["m",
                "TI"]}]], 
          SubsuperscriptBox[
            StyleBox["S",
              "TI"], 
            StyleBox["n",
              "TI"], 
            RowBox[{"(", 
              StyleBox["m",
                "TI"], ")"}]]}], TraditionalForm]], "InlineFormula"],
  " gives the number of permutations of ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " elements which contain exactly ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " cycles. These Stirling numbers satisfy the generating function relation \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], "-", "1"}], ")"}], "\[Ellipsis]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], "-", 
              StyleBox["n",
                "TI"], "+", "1"}], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["m",
                "TI"], "=", "0"}], 
            StyleBox["n",
              "TI"],
            LimitsPositioning->True], 
          SubsuperscriptBox[
            StyleBox["S",
              "TI"], 
            StyleBox["n",
              "TI"], 
            RowBox[{"(", 
              StyleBox["m",
                "TI"], ")"}]], 
          SuperscriptBox[
            StyleBox["x",
              "TI"], 
            StyleBox["m",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". Note that some definitions of the ",
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox[
          StyleBox["S",
            "TI"], 
          StyleBox["n",
            "TI"], 
          RowBox[{"(", 
            StyleBox["m",
              "TI"], ")"}]], TraditionalForm]], "InlineFormula"],
  " differ by a factor ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[\((\(-1\))\), 
          RowBox[{
            StyleBox["n",
              "TI"], "-", 
            StyleBox["m",
              "TI"]}]], TraditionalForm]], "InlineFormula"],
  " from what is used in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.2.6", "6.19"}],

Cell[TextData[{
  StyleBox["Stirling numbers of the second kind", "TB"],
  " ",
  StyleBox["StirlingS2[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " give the number of ways of partitioning a set of ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " elements into ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " non\[Hyphen]empty subsets. They satisfy the relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], 
            StyleBox["n",
              "TI"]], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["m",
                "TI"], "=", "0"}], 
            StyleBox["n",
              "TI"],
            LimitsPositioning->True], 
          SubsuperscriptBox["\[ScriptCapitalS]", 
            StyleBox["n",
              "TI"], 
            RowBox[{"(", 
              StyleBox["m",
                "TI"], ")"}]], 
          StyleBox["x",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], "-", "1"}], ")"}], "...", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], "-", 
              StyleBox["m",
                "TI"], "+", "1"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.6", "6.20"}],

Cell[TextData[{
  "The ",
  StyleBox["partition function", "TB"],
  " ",
  StyleBox["PartitionsP[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " gives the number of ways of writing the integer ",
  StyleBox["n", "TI"],
  " as a sum of positive integers, without regard to order. ",
  StyleBox["PartitionsQ[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " gives the number of ways of writing ",
  StyleBox["n", "TI"],
  " as a sum of positive integers, with the constraint that all the integers \
in each sum are distinct.  "
}], "Text",
  CellTags->{"S3.2.6", "6.21"}],

Cell["This gives a table of Stirling numbers of the first kind. ", \
"MathCaption",
  CellTags->{"S3.2.6", "6.22"}],

Cell[CellGroupData[{

Cell["Table[StirlingS1[5, i], {i, 5}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.2.6"],

Cell[BoxData[
    \({24, \(-50\), 35, \(-10\), 1}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.2.6"]
}, Open  ]],

Cell["\<\
The Stirling numbers appear as coefficients in this product. \
\>", \
"MathCaption",
  CellTags->{"S3.2.6", "6.23"}],

Cell[CellGroupData[{

Cell["Expand[Product[x - i, {i, 0, 4}]]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.2.6"],

Cell[BoxData[
    \(24\ x - 50\ x\^2 + 35\ x\^3 - 10\ x\^4 + x\^5\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.2.6"]
}, Open  ]],

Cell["\<\
This gives the number of partitions of 100, with and without the \
constraint that the terms should be distinct. \
\>", "MathCaption",
  CellTags->{"S3.2.6", "6.24"}],

Cell[CellGroupData[{

Cell["{PartitionsQ[100], PartitionsP[100]}", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.2.6"],

Cell[BoxData[
    \({444793, 190569292}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.2.6"]
}, Open  ]],

Cell[TextData[{
  "The partition function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["p",
            "TI"], 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " increases asymptotically like ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["e",
            "TI"], 
          SqrtBox[
            StyleBox["n",
              "TI"]]], TraditionalForm]], "InlineFormula"],
  ". Note that you cannot simply use ",
  StyleBox["Plot", "MR"],
  " to generate a plot of a function like ",
  StyleBox["PartitionsP", "MR"],
  " because the function can only be evaluated with integer arguments. "
}], "MathCaption",
  CellTags->{"S3.2.6", "6.25"}],

Cell[CellGroupData[{

Cell["ListPlot[ Table[ N[Log[ PartitionsP[n] ]], {n, 100} ] ]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.2.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00952381 0.0147151 0.0308727 [
[.21429 .00222 -6 -9 ]
[.21429 .00222 6 0 ]
[.40476 .00222 -6 -9 ]
[.40476 .00222 6 0 ]
[.59524 .00222 -6 -9 ]
[.59524 .00222 6 0 ]
[.78571 .00222 -6 -9 ]
[.78571 .00222 6 0 ]
[.97619 .00222 -9 -9 ]
[.97619 .00222 9 0 ]
[.01131 .16908 -6 -4.5 ]
[.01131 .16908 0 4.5 ]
[.01131 .32344 -12 -4.5 ]
[.01131 .32344 0 4.5 ]
[.01131 .47781 -12 -4.5 ]
[.01131 .47781 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(20)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(40)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(60)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(80)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(100)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .16908 m
.03006 .16908 L
s
[(5)] .01131 .16908 1 0 Mshowa
.02381 .32344 m
.03006 .32344 L
s
[(10)] .01131 .32344 1 0 Mshowa
.02381 .47781 m
.03006 .47781 L
s
[(15)] .01131 .47781 1 0 Mshowa
.125 Mabswid
.02381 .04559 m
.02756 .04559 L
s
.02381 .07646 m
.02756 .07646 L
s
.02381 .10733 m
.02756 .10733 L
s
.02381 .13821 m
.02756 .13821 L
s
.02381 .19995 m
.02756 .19995 L
s
.02381 .23082 m
.02756 .23082 L
s
.02381 .2617 m
.02756 .2617 L
s
.02381 .29257 m
.02756 .29257 L
s
.02381 .35431 m
.02756 .35431 L
s
.02381 .38519 m
.02756 .38519 L
s
.02381 .41606 m
.02756 .41606 L
s
.02381 .44693 m
.02756 .44693 L
s
.02381 .50868 m
.02756 .50868 L
s
.02381 .53955 m
.02756 .53955 L
s
.02381 .57042 m
.02756 .57042 L
s
.02381 .6013 m
.02756 .6013 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.03333 .01472 Mdot
.04286 .03611 Mdot
.05238 .04863 Mdot
.0619 .0644 Mdot
.07143 .07479 Mdot
.08095 .08874 Mdot
.09048 .09832 Mdot
.1 .11014 Mdot
.10952 .11972 Mdot
.11905 .13011 Mdot
.12857 .13899 Mdot
.1381 .14882 Mdot
.14762 .1572 Mdot
.15714 .16615 Mdot
.16667 .17434 Mdot
.17619 .18274 Mdot
.18571 .1905 Mdot
.19524 .19851 Mdot
.20476 .20595 Mdot
.21429 .21356 Mdot
.22381 .22078 Mdot
.23333 .22804 Mdot
.24286 .23499 Mdot
.25238 .242 Mdot
.2619 .24872 Mdot
.27143 .25546 Mdot
.28095 .262 Mdot
.29048 .26852 Mdot
.3 .27485 Mdot
.30952 .28118 Mdot
.31905 .28735 Mdot
.32857 .29349 Mdot
.3381 .2995 Mdot
.34762 .30548 Mdot
.35714 .31134 Mdot
.36667 .31717 Mdot
.37619 .32289 Mdot
.38571 .32858 Mdot
.39524 .33418 Mdot
.40476 .33974 Mdot
.41429 .34521 Mdot
.42381 .35065 Mdot
.43333 .35601 Mdot
.44286 .36134 Mdot
.45238 .3666 Mdot
.4619 .37182 Mdot
.47143 .37698 Mdot
.48095 .3821 Mdot
.49048 .38717 Mdot
.5 .39219 Mdot
.50952 .39717 Mdot
.51905 .40211 Mdot
.52857 .407 Mdot
.5381 .41186 Mdot
.54762 .41667 Mdot
.55714 .42145 Mdot
.56667 .42619 Mdot
.57619 .43089 Mdot
.58571 .43555 Mdot
.59524 .44018 Mdot
.60476 .44478 Mdot
.61429 .44934 Mdot
.62381 .45387 Mdot
.63333 .45837 Mdot
.64286 .46283 Mdot
.65238 .46727 Mdot
.6619 .47167 Mdot
.67143 .47604 Mdot
.68095 .48039 Mdot
.69048 .48471 Mdot
.7 .489 Mdot
.70952 .49326 Mdot
.71905 .49749 Mdot
.72857 .5017 Mdot
.7381 .50589 Mdot
.74762 .51005 Mdot
.75714 .51418 Mdot
.76667 .51829 Mdot
.77619 .52238 Mdot
.78571 .52644 Mdot
.79524 .53048 Mdot
.80476 .53449 Mdot
.81429 .53849 Mdot
.82381 .54246 Mdot
.83333 .54641 Mdot
.84286 .55034 Mdot
.85238 .55425 Mdot
.8619 .55814 Mdot
.87143 .56201 Mdot
.88095 .56586 Mdot
.89048 .56969 Mdot
.9 .5735 Mdot
.90952 .57729 Mdot
.91905 .58106 Mdot
.92857 .58481 Mdot
.9381 .58855 Mdot
.94762 .59227 Mdot
.95714 .59597 Mdot
.96667 .59965 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.2.6"]
}, Open  ]],

Cell[TextData[{
  "The functions in this section allow you to ",
  StyleBox["enumerate", "TI"],
  " various kinds of combinatorial objects. Functions like ",
  StyleBox["Permutations", "MR"],
  " allow you instead to ",
  StyleBox["generate", "TI"],
  " lists of various combinations of elements. "
}], "Text",
  CellTags->{"S3.2.6", "6.26"}],

Cell[TextData[{
  "The ",
  StyleBox["signature function", "TB"],
  " ",
  StyleBox["Signature[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " gives the signature of a permutation. It is equal to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+1\)\)], "InlineFormula"],
  " for even permutations (composed of an even number of transpositions), and \
to ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " for odd permutations. The signature function can be thought of as a \
totally antisymmetric tensor, ",
  StyleBox["Levi\[Hyphen]Civita symbol", "TB"],
  " or ",
  StyleBox["epsilon symbol", "TB"],
  ".  "
}], "Text",
  CellTags->{"S3.2.6", "6.27"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ClebschGordan[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["Clebsch\[Hyphen]Gordan coefficient "]},
          {Cell[TextData[{
              StyleBox["ThreeJSymbol[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["Wigner 3\[Hyphen]j symbol "]},
          {Cell[TextData[{
              StyleBox["SixJSymbol[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "4"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "5"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "6"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["Racah 6\[Hyphen]j symbol "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.6"],

Cell["Rotational coupling coefficients. ", "Caption",
  CellTags->"S3.2.6"],

Cell[TextData[{
  "Clebsch\[Hyphen]Gordan coefficients and ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]j symbols arise in the study of angular momenta in quantum \
mechanics, and in other applications of the rotation group. The ",
  StyleBox["Clebsch\[Hyphen]Gordan coefficients", "TB"],
  " ",
  StyleBox["ClebschGordan[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["m",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["m",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["j", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox["}]", "MR"],
  " give the coefficients in the expansion of the quantum mechanical angular \
momentum state ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[VerticalSeparator]", 
          StyleBox["j",
            "TI"], ",", 
          StyleBox["m",
            "TI"], "\[RightAngleBracket]"}], TraditionalForm]], 
    "InlineFormula"],
  " in terms of products of states ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[VerticalSeparator]", 
          SubscriptBox[
            StyleBox["j",
              "TI"], "1"], ",", 
          SubscriptBox[
            StyleBox["m",
              "TI"], "1"], \(\(\[RightAngleBracket]\)\(\ \)\), 
          "\[VerticalSeparator]", 
          SubscriptBox[
            StyleBox["j",
              "TI"], "2"], ",", 
          SubscriptBox[
            StyleBox["m",
              "TI"], "2"], "\[RightAngleBracket]"}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.6", "6.28"}],

Cell[TextData[{
  "The ",
  StyleBox["3\[Hyphen]j symbols", "TB"],
  " or ",
  StyleBox["Wigner coefficients", "TB"],
  " ",
  StyleBox["ThreeJSymbol[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["m",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["m",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], "3"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["m",
            "TI"], "3"], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  " are a more symmetrical form of Clebsch\[Hyphen]Gordan coefficients. In ",
  StyleBox["Mathematica", "TI"],
  ", the Clebsch\[Hyphen]Gordan coefficients are given in terms of \
3\[Hyphen]j symbols by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["C",
              "TI"], 
            RowBox[{
              SubscriptBox[
                StyleBox["m",
                  "TI"], "1"], 
              SubscriptBox[
                StyleBox["m",
                  "TI"], "2"], 
              SubscriptBox[
                StyleBox["m",
                  "TI"], "3"]}], 
            RowBox[{
              SubscriptBox[
                StyleBox["j",
                  "TI"], "1"], 
              SubscriptBox[
                StyleBox["j",
                  "TI"], "2"], 
              SubscriptBox[
                StyleBox["j",
                  "TI"], "3"]}]], " ", \(\(=\)\(\ \)\), 
          SuperscriptBox[\((\(-1\))\), 
            RowBox[{
              SubscriptBox[
                StyleBox["m",
                  "TI"], "3"], "+", 
              SubscriptBox[
                StyleBox["j",
                  "TI"], "1"], "-", 
              SubscriptBox[
                StyleBox["j",
                  "TI"], "2"]}]], 
          SqrtBox[
            RowBox[{"2", 
              SubscriptBox[
                StyleBox["j",
                  "TI"], "3"], "+", "1"}]], 
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                SubscriptBox[
                  StyleBox["j",
                    "TI"], "1"], 
                SubscriptBox[
                  StyleBox["m",
                    "TI"], "1"],
                FractionLine->None], " ", 
              FractionBox[
                SubscriptBox[
                  StyleBox["j",
                    "TI"], "2"], 
                SubscriptBox[
                  StyleBox["m",
                    "TI"], "2"],
                FractionLine->None], " ", 
              FractionBox[
                SubscriptBox[
                  StyleBox["j",
                    "TI"], "3"], 
                RowBox[{"-", 
                  SubscriptBox[
                    StyleBox["m",
                      "TI"], "3"]}],
                FractionLine->None]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.6", "6.29"}],

Cell[TextData[{
  "The ",
  StyleBox["6\[Hyphen]j symbols", "TB"],
  " ",
  StyleBox["SixJSymbol[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], "3"], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], "4"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], "5"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], "6"], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  " give the couplings of three quantum mechanical angular momentum states. \
The ",
  StyleBox["Racah coefficients", "TB"],
  " are related by a phase to the 6\[Hyphen]j symbols. "
}], "Text",
  CellTags->{"S3.2.6", "6.30"}],

Cell["\<\
You can give symbolic parameters in 3\[Hyphen]j symbols. \
\>", \
"MathCaption",
  CellTags->{"S3.2.6", "6.31"}],

Cell[CellGroupData[{

Cell["ThreeJSymbol[{j, m}, {j+1/2, -m-1/2}, {1/2, 1/2}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.2.6"],

Cell[BoxData[
    \(\(-\(\(\((\(-1\))\)\^\(\(-j\) + m\)\ \@\(1 + j + m\)\)\/\(\@2\ \@\(1 + \
j\)\ \@\(1 + 2\ j\)\)\)\)\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.2.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2.7 Elementary Transcendental Functions", "Subsection",
  CellTags->{"S3.2.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Exp[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "exponential function ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["e",
                        "TI"], 
                      StyleBox["z",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Log[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "logarithm ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox["log", 
                        StyleBox["e",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Log[", "MR"],
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "logarithm ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox["log", 
                        StyleBox["b",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " to base ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["b",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Sin[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Cos[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Tan[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Csc[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Sec[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Cot[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "trigonometric functions (with arguments in radians) "]},
          {Cell[TextData[{
              StyleBox["ArcSin[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["ArcCos[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["ArcTan[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["ArcCsc[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["ArcSec[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["ArcCot[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "inverse trigonometric functions (giving results in radians) "]},
          {Cell[TextData[{
              StyleBox["ArcTan[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the argument of ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["x",
                        "TI"], "+", 
                      StyleBox["i",
                        "TI"], 
                      StyleBox["y",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Sinh[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Cosh[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Tanh[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Csch[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Sech[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Coth[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["hyperbolic functions "]},
          {Cell[TextData[{
              StyleBox["ArcSinh[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["ArcCosh[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["ArcTanh[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["ArcCsch[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["ArcSech[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["ArcCoth[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["inverse hyperbolic functions"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.7"],

Cell["Elementary transcendental functions.", "Caption",
  CellTags->"S3.2.7"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " gives exact results for logarithms whenever it can. Here is ",
  Cell[BoxData[
      \(TraditionalForm\`\(log\_2\) 1024\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.7", "7.2"}],

Cell[CellGroupData[{

Cell["Log[2, 1024]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.2.7"],

Cell[BoxData[
    \(10\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.2.7"]
}, Open  ]],

Cell["\<\
You can find the numerical values of mathematical functions to any \
precision. \
\>", "MathCaption",
  CellTags->{"S3.2.7", "7.3"}],

Cell[CellGroupData[{

Cell["N[Log[2], 40]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.2.7"],

Cell[BoxData[
    \(0.69314718055994530941723212145817656807550013435994896456`40. \)], \
"Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.2.7"]
}, Open  ]],

Cell["This gives a complex number result. ", "MathCaption",
  CellTags->{"S3.2.7", "7.4"}],

Cell[CellGroupData[{

Cell["N[ Log[-2] ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.2.7"],

Cell[BoxData[
    \(\(\(0.6931471805599453`\)\(\[InvisibleSpace]\)\) + 
      3.141592653589793`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.2.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can evaluate logarithms with complex arguments. "
}], "MathCaption",
  CellTags->{"S3.2.7", "7.5"}],

Cell[CellGroupData[{

Cell["N[ Log[2 + 8 I] ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.2.7"],

Cell[BoxData[
    \(\(\(2.1097538525880535`\)\(\[InvisibleSpace]\)\) + 
      1.3258176636680326`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.2.7"]
}, Open  ]],

Cell["\<\
The arguments of trigonometric functions are always given in \
radians.  \
\>", "MathCaption",
  CellTags->{"S3.2.7", "7.6"}],

Cell[CellGroupData[{

Cell["Sin[Pi/2]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.2.7"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.2.7"]
}, Open  ]],

Cell[TextData[{
  "You can convert from degrees by explicitly multiplying by the constant ",
  StyleBox["Degree", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.7", "7.7"}],

Cell[CellGroupData[{

Cell["N[ Sin[30 Degree] ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.2.7"],

Cell[BoxData[
    \(0.5`\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.2.7"]
}, Open  ]],

Cell["\<\
Here is a plot of the hyperbolic tangent function. It has a \
characteristic \[OpenCurlyDoubleQuote]sigmoidal\[CloseCurlyDoubleQuote] form. \
\
\>", "MathCaption",
  CellTags->{"S3.2.7", "7.8"}],

Cell[CellGroupData[{

Cell["Plot[ Tanh[x], {x, -8, 8} ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.2.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0595238 0.309017 0.294302 [
[.05357 .29652 -12 -9 ]
[.05357 .29652 12 0 ]
[.20238 .29652 -6 -9 ]
[.20238 .29652 6 0 ]
[.35119 .29652 -12 -9 ]
[.35119 .29652 12 0 ]
[.64881 .29652 -9 -9 ]
[.64881 .29652 9 0 ]
[.79762 .29652 -3 -9 ]
[.79762 .29652 3 0 ]
[.94643 .29652 -9 -9 ]
[.94643 .29652 9 0 ]
[.4875 .01472 -12 -4.5 ]
[.4875 .01472 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.05357 .30902 m
.05357 .31527 L
s
[(-7.5)] .05357 .29652 0 1 Mshowa
.20238 .30902 m
.20238 .31527 L
s
[(-5)] .20238 .29652 0 1 Mshowa
.35119 .30902 m
.35119 .31527 L
s
[(-2.5)] .35119 .29652 0 1 Mshowa
.64881 .30902 m
.64881 .31527 L
s
[(2.5)] .64881 .29652 0 1 Mshowa
.79762 .30902 m
.79762 .31527 L
s
[(5)] .79762 .29652 0 1 Mshowa
.94643 .30902 m
.94643 .31527 L
s
[(7.5)] .94643 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.1131 .30902 m
.1131 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.17262 .30902 m
.17262 .31277 L
s
.23214 .30902 m
.23214 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.29167 .30902 m
.29167 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.41071 .30902 m
.41071 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.47024 .30902 m
.47024 .31277 L
s
.52976 .30902 m
.52976 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.58929 .30902 m
.58929 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.70833 .30902 m
.70833 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.76786 .30902 m
.76786 .31277 L
s
.82738 .30902 m
.82738 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.8869 .30902 m
.8869 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.02381 .30902 m
.02381 .31277 L
s
.97619 .30902 m
.97619 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01472 m
.50625 .01472 L
s
[(-1)] .4875 .01472 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.03279 .01472 L
.04262 .01472 L
.05288 .01472 L
.06244 .01472 L
.0731 .01472 L
.0828 .01472 L
.08817 .01472 L
.094 .01472 L
.10458 .01472 L
.11402 .01472 L
.12442 .01472 L
.12965 .01472 L
.13527 .01472 L
.14545 .01472 L
.15555 .01472 L
.16127 .01472 L
.16658 .01472 L
.1763 .01473 L
.18667 .01473 L
.19696 .01474 L
.20275 .01474 L
.20808 .01475 L
.21789 .01476 L
.22825 .01478 L
.23773 .0148 L
.24789 .01484 L
.25748 .01489 L
.26622 .01494 L
.27614 .01503 L
.28531 .01515 L
.29538 .01532 L
.30607 .01558 L
.31544 .01591 L
.32554 .01639 L
.33508 .01701 L
.34382 .01779 L
.35362 .01899 L
.36274 .0205 L
.37275 .02279 L
.38344 .02621 L
.39369 .0308 L
.40479 .03779 L
.41528 .047 L
.42494 .05847 L
.43464 .07363 L
.44371 .09187 L
.45366 .11716 L
.46435 .15117 L
.50562 .33673 L
Mistroke
.52625 .43101 L
.53629 .4691 L
.54538 .49811 L
.55429 .52153 L
.56391 .54176 L
.57407 .5582 L
.58363 .56989 L
.59316 .57867 L
.60361 .58575 L
.61451 .59103 L
.62468 .59453 L
.63516 .59711 L
.64508 .59886 L
.65398 .6 L
.66364 .60092 L
.67307 .60157 L
.68346 .60208 L
.68868 .60228 L
.69431 .60246 L
.70448 .60271 L
.71407 .60288 L
.72456 .60301 L
.72985 .60306 L
.7355 .6031 L
.74567 .60317 L
.75594 .60321 L
.76173 .60323 L
.76706 .60324 L
.77686 .60327 L
.78722 .60328 L
.79668 .60329 L
.80683 .6033 L
.81642 .6033 L
.82516 .60331 L
.83506 .60331 L
.84422 .60331 L
.85428 .60331 L
.86497 .60332 L
.87433 .60332 L
.88442 .60332 L
.89395 .60332 L
.90269 .60332 L
.91248 .60332 L
.92159 .60332 L
.93159 .60332 L
.94228 .60332 L
.95065 .60332 L
.95972 .60332 L
.96829 .60332 L
.97619 .60332 L
Mistroke
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.2.7"]
}, Open  ]],

Cell[TextData[{
  "There are a number of additional trigonometric and hyperbolic functions \
that are sometimes used. The ",
  StyleBox["versine", "TB"],
  " function is defined as ",
  Cell[BoxData[
      FormBox[
        RowBox[{"vers", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", "1", "-", "cos", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". The ",
  StyleBox["haversine", "TB"],
  " is simply ",
  Cell[BoxData[
      FormBox[
        RowBox[{"hav", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", \(1\/2\), "vers", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". The complex exponential ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox[\(i  x\),
            "TI"]], TraditionalForm]], "InlineFormula"],
  " is sometimes written as ",
  Cell[BoxData[
      FormBox[
        RowBox[{"cis", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". The ",
  StyleBox["gudermannian function", "TB"],
  " is defined as ",
  Cell[BoxData[
      FormBox[
        RowBox[{"gd", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", "2", \(tan\^\(-1\)\), 
          RowBox[{"(", 
            SuperscriptBox[
              StyleBox["e",
                "TI"], 
              StyleBox["z",
                "TI"]], ")"}], "-", \(\[Pi]\/2\)}], TraditionalForm]], 
    "InlineFormula"],
  ". The ",
  StyleBox["inverse gudermannian", "TB"],
  " is ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(gd\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", "log", 
          RowBox[{"[", 
            RowBox[{"sec", 
              RowBox[{"(", 
                StyleBox["z",
                  "TI"], ")"}], "+", "tan", 
              RowBox[{"(", 
                StyleBox["z",
                  "TI"], ")"}]}], "]"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". The gudermannian satisfies such relations as ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sinh", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", "tan", 
          RowBox[{"[", 
            RowBox[{"gd", 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}], "]"}]}], TraditionalForm]], 
    "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.7", "7.9"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2.8 Functions That Do Not Have Unique Values", "Subsection",
  CellTags->{"S3.2.8", "8.1"}],

Cell[TextData[{
  "When you ask for the square root ",
  Cell[BoxData[
      FormBox[
        StyleBox["s",
          "TI"], TraditionalForm]], "InlineFormula"],
  " of a number ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", you are effectively asking for the solution to the equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["s",
              "TI"], "2"], "=", 
          StyleBox["a",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". This equation, however, in general has two different solutions. Both ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["s",
            "TI"], "=", "2"}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["s",
            "TI"], "=", \(-2\)}], TraditionalForm]], "InlineFormula"],
  " are, for example, solutions to the equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["s",
              "TI"], "2"], "=", "4"}], TraditionalForm]], "InlineFormula"],
  ". When you evaluate the \[OpenCurlyDoubleQuote]function\
\[CloseCurlyDoubleQuote] ",
  Cell[BoxData[
      \(TraditionalForm\`\@4\)], "InlineFormula"],
  ", however, you usually want to get a single number, and so you have to \
choose one of these two solutions. A standard choice is that ",
  Cell[BoxData[
      FormBox[
        SqrtBox[
          StyleBox["x",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " should be positive for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], ">", "0"}], TraditionalForm]], "InlineFormula"],
  ". This is what the ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["Sqrt[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " does.  "
}], "Text",
  CellTags->{"S3.2.8", "8.2"}],

Cell[TextData[{
  "The need to make one choice from two solutions means that ",
  StyleBox["Sqrt[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " cannot be a true ",
  StyleBox["inverse function", "TI"],
  " for ",
  StyleBox["x", "TI"],
  StyleBox["^2", "MR"],
  ". Taking a number, squaring it, and then taking the square root can give \
you a different number than you started with. "
}], "Text",
  CellTags->{"S3.2.8", "8.3"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\@4\)], "InlineFormula"],
  " gives ",
  Cell[BoxData[
      \(TraditionalForm\`\(+2\)\)], "InlineFormula"],
  ", not ",
  Cell[BoxData[
      \(TraditionalForm\`\(-2\)\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.8", "8.4"}],

Cell[CellGroupData[{

Cell["Sqrt[4]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.2.8"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.2.8"]
}, Open  ]],

Cell["\<\
Squaring and taking the square root does not necessarily give you \
the number you started with. \
\>", "MathCaption",
  CellTags->{"S3.2.8", "8.5"}],

Cell[CellGroupData[{

Cell["Sqrt[(-2)^2]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.2.8"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.2.8"]
}, Open  ]],

Cell[TextData[{
  "When you evaluate ",
  Cell[BoxData[
      FormBox[
        SqrtBox[
          RowBox[{\(-2\), 
            StyleBox["i",
              "TI"]}]], TraditionalForm]], "InlineFormula"],
  ", there are again two possible answers: ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(-1\), "+", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "-", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". In this case, however, it is less clear which one to choose. "
}], "Text",
  CellTags->{"S3.2.8", "8.6"}],

Cell[TextData[{
  "There is in fact no way to choose ",
  Cell[BoxData[
      FormBox[
        SqrtBox[
          StyleBox["z",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " so that it is continuous for all complex values of ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". There has to be a \[OpenCurlyDoubleQuote]branch cut\
\[CloseCurlyDoubleQuote]\[LongDash]a line in the complex plane across which \
the function ",
  Cell[BoxData[
      FormBox[
        SqrtBox[
          StyleBox["z",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " is discontinuous. ",
  StyleBox["Mathematica", "TI"],
  " adopts the usual convention of taking the branch cut for ",
  Cell[BoxData[
      FormBox[
        SqrtBox[
          StyleBox["z",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " to be along the negative real axis.   "
}], "Text",
  CellTags->{"S3.2.8", "8.7"}],

Cell[TextData[{
  "This gives ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "-", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ", not ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(-1\), "+", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.8", "8.8"}],

Cell[CellGroupData[{

Cell["N[ Sqrt[-2 I] ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.2.8"],

Cell[BoxData[
    \(\(\(1.`\)\(\[InvisibleSpace]\)\) - 1.`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.2.8"]
}, Open  ]],

Cell[TextData[{
  "The branch cut in ",
  StyleBox["Sqrt", "MR"],
  " along the negative real axis means that values of ",
  StyleBox["Sqrt[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " with ",
  StyleBox["z", "TI"],
  " just above and below the axis are very different. "
}], "MathCaption",
  CellTags->{"S3.2.8", "8.9"}],

Cell[CellGroupData[{

Cell["{Sqrt[-2 + 0.1 I], Sqrt[-2 - 0.1 I]}", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.2.8"],

Cell[BoxData[
    \({\(\(0.03534430258244289`\)\(\[InvisibleSpace]\)\) + 
        1.4146551592967944`\ \[ImaginaryI], \(\(0.03534430258244289`\)\(\
\[InvisibleSpace]\)\) - 1.4146551592967944`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.2.8"]
}, Open  ]],

Cell["Their squares are nevertheless close. ", "MathCaption",
  CellTags->{"S3.2.8", "8.10"}],

Cell[CellGroupData[{

Cell["%^2", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.2.8"],

Cell[BoxData[
    \({\(-1.9999999999999996`\) + 
        0.09999999999999969`\ \[ImaginaryI], \(-1.9999999999999996`\) - 
        0.09999999999999969`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.2.8"]
}, Open  ]],

Cell["\<\
The discontinuity along the negative real axis is quite clear in \
this three\[Hyphen]dimensional picture of the imaginary part of the square \
root function. \
\>", "MathCaption",
  CellTags->{"S3.2.8", "8.11"}],

Cell[CellGroupData[{

Cell["Plot3D[ Im[Sqrt[x + I y]], {x, -4, 4}, {y, -4, 4} ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.2.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
6.32903e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -12 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -11.7989 -9 ]
[.17646 .18758 .20112 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.50253 .05935 -5.27396 -9 ]
[.50253 .05935 .72604 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02262 .27447 -12 -2.75022 ]
[.02262 .27447 0 6.24978 ]
[.01491 .32279 -12 -2.79109 ]
[.01491 .32279 0 6.20891 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00125 .4241 -6 -2.8772 ]
[-0.00125 .4241 0 6.1228 ]
[-0.00973 .47725 -6 -2.9226 ]
[-0.00973 .47725 0 6.0774 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-4)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-2)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(2)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(4)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.07346 .24092 m
.0763 .24365 L
s
.11029 .2265 m
.1131 .22926 L
s
.14766 .21187 m
.15043 .21466 L
s
.22407 .18195 m
.22677 .18482 L
s
.26314 .16665 m
.2658 .16956 L
s
.3028 .15112 m
.30541 .15406 L
s
.38395 .11935 m
.38647 .12237 L
s
.42547 .10309 m
.42794 .10615 L
s
.46763 .08658 m
.47006 .08968 L
s
.55397 .05277 m
.55629 .05595 L
s
.59817 .03546 m
.60044 .03868 L
s
.64309 .01787 m
.6453 .02113 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-4)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-2)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(2)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(4)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.71016 .03277 m
.70649 .03419 L
s
.73096 .06459 m
.72728 .06598 L
s
.75117 .0955 m
.74748 .09687 L
s
.78989 .15473 m
.78618 .15605 L
s
.80845 .18312 m
.80473 .18442 L
s
.8265 .21073 m
.82278 .21202 L
s
.86118 .26378 m
.85745 .26503 L
s
.87784 .28927 m
.87411 .2905 L
s
.89408 .3141 m
.89033 .31531 L
s
.92532 .36189 m
.92156 .36307 L
s
.94036 .3849 m
.9366 .38606 L
s
.95503 .40734 m
.95127 .40849 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03485 .26971 m
.04097 .26734 L
s
[(-2)] .02262 .27447 1 -0.38884 Mshowa
.02718 .31813 m
.03331 .3158 L
s
[(-1)] .01491 .32279 1 -0.37976 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.01109 .41965 m
.01726 .41742 L
s
[(1)] -0.00125 .4241 1 -0.36062 Mshowa
.00265 .47291 m
.00884 .47074 L
s
[(2)] -0.00973 .47725 1 -0.35053 Mshowa
.125 Mabswid
.03333 .27928 m
.03701 .27786 L
s
.03181 .2889 m
.03548 .28748 L
s
.03028 .29858 m
.03395 .29717 L
s
.02873 .30832 m
.03241 .30692 L
s
.02561 .32799 m
.0293 .3266 L
s
.02404 .33792 m
.02773 .33653 L
s
.02246 .34791 m
.02615 .34653 L
s
.02087 .35796 m
.02455 .35659 L
s
.01765 .37826 m
.02134 .3769 L
s
.01602 .38851 m
.01972 .38715 L
s
.01439 .39882 m
.01809 .39747 L
s
.01275 .4092 m
.01645 .40786 L
s
.00942 .43016 m
.01313 .42883 L
s
.00775 .44075 m
.01145 .43942 L
s
.00606 .4514 m
.00977 .45008 L
s
.00436 .46212 m
.00807 .46081 L
s
.03636 .26021 m
.04002 .25878 L
s
.00093 .48377 m
.00465 .48248 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.7 .753 .893 r
.38453 .79347 .39806 .80578 .42077 .79666 .40737 .78414 Metetra
.7 .752 .892 r
.40737 .78414 .42077 .79666 .44364 .78744 .43037 .77471 Metetra
.7 .75 .891 r
.43037 .77471 .44364 .78744 .46666 .77813 .45352 .76517 Metetra
.701 .749 .889 r
.45352 .76517 .46666 .77813 .48983 .76874 .47682 .75554 Metetra
.701 .747 .888 r
.47682 .75554 .48983 .76874 .51316 .75928 .50028 .74582 Metetra
.7 .745 .886 r
.50028 .74582 .51316 .75928 .53665 .74975 .5239 .73602 Metetra
.7 .743 .884 r
.5239 .73602 .53665 .74975 .56029 .74017 .54767 .72617 Metetra
.7 .741 .883 r
.54767 .72617 .56029 .74017 .5841 .73055 .57161 .71627 Metetra
.699 .738 .882 r
.57161 .71627 .5841 .73055 .60807 .72091 .59571 .70636 Metetra
.698 .736 .88 r
.59571 .70636 .60807 .72091 .6322 .71128 .61997 .69644 Metetra
.696 .733 .879 r
.61997 .69644 .6322 .71128 .65651 .70166 .64441 .68655 Metetra
.694 .731 .878 r
.64441 .68655 .65651 .70166 .68099 .69208 .66902 .67671 Metetra
.692 .728 .878 r
.66902 .67671 .68099 .69208 .70565 .68255 .69381 .66694 Metetra
.69 .726 .877 r
.69381 .66694 .70565 .68255 .73049 .67309 .71879 .65725 Metetra
.688 .724 .877 r
.71879 .65725 .73049 .67309 .75553 .6637 .74396 .64766 Metetra
.686 .722 .877 r
.74396 .64766 .75553 .6637 .78076 .6544 .76932 .63817 Metetra
.684 .721 .877 r
.76932 .63817 .78076 .6544 .80619 .64517 .79489 .62877 Metetra
.682 .719 .878 r
.79489 .62877 .80619 .64517 .83183 .63602 .82067 .61948 Metetra
.68 .718 .878 r
.82067 .61948 .83183 .63602 .85768 .62695 .84667 .61027 Metetra
.678 .718 .879 r
.84667 .61027 .85768 .62695 .88374 .61794 .87289 .60114 Metetra
.676 .717 .88 r
.87289 .60114 .88374 .61794 .91003 .60899 .89933 .59208 Metetra
.675 .717 .88 r
.89933 .59208 .91003 .60899 .93655 .60009 .926 .58308 Metetra
.673 .716 .881 r
.926 .58308 .93655 .60009 .9633 .59123 .95291 .57412 Metetra
.672 .716 .882 r
.95291 .57412 .9633 .59123 .99028 .58241 .98006 .56519 Metetra
.701 .754 .893 r
.3708 .78103 .38453 .79347 .40737 .78414 .39377 .77149 Metetra
.702 .753 .892 r
.39377 .77149 .40737 .78414 .43037 .77471 .4169 .76182 Metetra
.702 .751 .89 r
.4169 .76182 .43037 .77471 .45352 .76517 .44018 .75204 Metetra
.702 .75 .888 r
.44018 .75204 .45352 .76517 .47682 .75554 .46362 .74215 Metetra
.703 .748 .887 r
.46362 .74215 .47682 .75554 .50028 .74582 .48721 .73216 Metetra
.703 .746 .885 r
.48721 .73216 .50028 .74582 .5239 .73602 .51096 .72209 Metetra
.702 .743 .883 r
.51096 .72209 .5239 .73602 .54767 .72617 .53487 .71194 Metetra
.702 .741 .882 r
.53487 .71194 .54767 .72617 .57161 .71627 .55894 .70174 Metetra
.701 .738 .88 r
.55894 .70174 .57161 .71627 .59571 .70636 .58317 .69152 Metetra
.7 .735 .879 r
.58317 .69152 .59571 .70636 .61997 .69644 .60756 .6813 Metetra
.698 .732 .877 r
.60756 .6813 .61997 .69644 .64441 .68655 .63213 .67111 Metetra
.696 .73 .876 r
.63213 .67111 .64441 .68655 .66902 .67671 .65687 .66098 Metetra
.694 .727 .875 r
.65687 .66098 .66902 .67671 .69381 .66694 .68179 .65094 Metetra
.691 .724 .875 r
.68179 .65094 .69381 .66694 .71879 .65725 .7069 .64102 Metetra
.689 .722 .875 r
.7069 .64102 .71879 .65725 .74396 .64766 .73221 .63121 Metetra
.686 .72 .875 r
.73221 .63121 .74396 .64766 .76932 .63817 .75771 .62152 Metetra
.684 .718 .875 r
.75771 .62152 .76932 .63817 .79489 .62877 .78342 .61197 Metetra
.682 .717 .876 r
.78342 .61197 .79489 .62877 .82067 .61948 .80934 .60253 Metetra
.679 .716 .877 r
.80934 .60253 .82067 .61948 .84667 .61027 .83549 .59319 Metetra
.677 .715 .877 r
.83549 .59319 .84667 .61027 .87289 .60114 .86185 .58395 Metetra
.676 .715 .878 r
.86185 .58395 .87289 .60114 .89933 .59208 .88845 .57478 Metetra
.674 .715 .879 r
.88845 .57478 .89933 .59208 .926 .58308 .91529 .56568 Metetra
.672 .715 .88 r
.91529 .56568 .926 .58308 .95291 .57412 .94236 .55663 Metetra
.671 .715 .881 r
.94236 .55663 .95291 .57412 .98006 .56519 .96967 .54762 Metetra
.703 .755 .893 r
.35686 .76846 .3708 .78103 .39377 .77149 .37996 .75869 Metetra
.703 .754 .891 r
.37996 .75869 .39377 .77149 .4169 .76182 .40322 .74879 Metetra
.704 .752 .89 r
.40322 .74879 .4169 .76182 .44018 .75204 .42664 .73876 Metetra
.704 .751 .888 r
.42664 .73876 .44018 .75204 .46362 .74215 .45021 .72861 Metetra
.705 .749 .886 r
.45021 .72861 .46362 .74215 .48721 .73216 .47394 .71833 Metetra
.705 .746 .884 r
.47394 .71833 .48721 .73216 .51096 .72209 .49783 .70795 Metetra
.705 .744 .882 r
.49783 .70795 .51096 .72209 .53487 .71194 .52187 .69748 Metetra
.704 .741 .88 r
.52187 .69748 .53487 .71194 .55894 .70174 .54607 .68695 Metetra
.703 .738 .878 r
.54607 .68695 .55894 .70174 .58317 .69152 .57044 .67638 Metetra
.702 .735 .877 r
.57044 .67638 .58317 .69152 .60756 .6813 .59497 .66582 Metetra
.7 .732 .875 r
.59497 .66582 .60756 .6813 .63213 .67111 .61967 .6553 Metetra
.698 .728 .874 r
.61967 .6553 .63213 .67111 .65687 .66098 .64454 .64486 Metetra
.695 .725 .873 r
.64454 .64486 .65687 .66098 .68179 .65094 .66959 .63453 Metetra
.693 .722 .873 r
.66959 .63453 .68179 .65094 .7069 .64102 .69483 .62435 Metetra
.69 .72 .872 r
.69483 .62435 .7069 .64102 .73221 .63121 .72027 .61431 Metetra
.687 .718 .873 r
.72027 .61431 .73221 .63121 .75771 .62152 .74591 .60444 Metetra
.684 .716 .873 r
.74591 .60444 .75771 .62152 .78342 .61197 .77176 .59472 Metetra
.681 .715 .874 r
.77176 .59472 .78342 .61197 .80934 .60253 .79783 .58514 Metetra
.679 .714 .875 r
.79783 .58514 .80934 .60253 .83549 .59319 .82412 .57569 Metetra
.677 .713 .876 r
.82412 .57569 .83549 .59319 .86185 .58395 .85064 .56635 Metetra
.675 .713 .877 r
.85064 .56635 .86185 .58395 .88845 .57478 .8774 .55709 Metetra
.673 .713 .878 r
.8774 .55709 .88845 .57478 .91529 .56568 .90439 .5479 Metetra
.672 .713 .879 r
.90439 .5479 .91529 .56568 .94236 .55663 .93163 .53877 Metetra
.67 .713 .88 r
.93163 .53877 .94236 .55663 .96967 .54762 .95911 .52968 Metetra
.704 .757 .893 r
.3427 .75577 .35686 .76846 .37996 .75869 .36594 .74577 Metetra
.705 .755 .891 r
.36594 .74577 .37996 .75869 .40322 .74879 .38933 .73563 Metetra
.706 .754 .889 r
.38933 .73563 .40322 .74879 .42664 .73876 .41289 .72534 Metetra
.706 .752 .887 r
.41289 .72534 .42664 .73876 .45021 .72861 .4366 .7149 Metetra
.707 .75 .885 r
.4366 .7149 .45021 .72861 .47394 .71833 .46047 .70432 Metetra
.707 .748 .883 r
.46047 .70432 .47394 .71833 .49783 .70795 .48449 .69362 Metetra
.707 .745 .881 r
.48449 .69362 .49783 .70795 .52187 .69748 .50868 .6828 Metetra
.707 .742 .879 r
.50868 .6828 .52187 .69748 .54607 .68695 .53302 .6719 Metetra
.706 .738 .876 r
.53302 .6719 .54607 .68695 .57044 .67638 .55752 .66095 Metetra
.705 .735 .874 r
.55752 .66095 .57044 .67638 .59497 .66582 .58218 .65001 Metetra
.703 .731 .873 r
.58218 .65001 .59497 .66582 .61967 .6553 .60702 .63911 Metetra
.7 .727 .871 r
.60702 .63911 .61967 .6553 .64454 .64486 .63202 .62831 Metetra
.697 .724 .87 r
.63202 .62831 .64454 .64486 .66959 .63453 .65721 .61767 Metetra
.694 .72 .87 r
.65721 .61767 .66959 .63453 .69483 .62435 .68258 .6072 Metetra
.69 .717 .87 r
.68258 .6072 .69483 .62435 .72027 .61431 .70815 .59694 Metetra
.687 .715 .87 r
.70815 .59694 .72027 .61431 .74591 .60444 .73393 .58688 Metetra
.684 .713 .871 r
.73393 .58688 .74591 .60444 .77176 .59472 .75992 .577 Metetra
.681 .712 .872 r
.75992 .577 .77176 .59472 .79783 .58514 .78613 .5673 Metetra
.678 .711 .873 r
.78613 .5673 .79783 .58514 .82412 .57569 .81257 .55775 Metetra
.676 .711 .874 r
.81257 .55775 .82412 .57569 .85064 .56635 .83925 .54832 Metetra
.674 .71 .876 r
.83925 .54832 .85064 .56635 .8774 .55709 .86616 .53898 Metetra
.672 .71 .877 r
.86616 .53898 .8774 .55709 .90439 .5479 .89332 .52973 Metetra
.67 .711 .878 r
.89332 .52973 .90439 .5479 .93163 .53877 .92072 .52052 Metetra
.669 .711 .879 r
.92072 .52052 .93163 .53877 .95911 .52968 .94838 .51136 Metetra
.706 .758 .893 r
.32831 .74296 .3427 .75577 .36594 .74577 .35169 .73274 Metetra
.707 .757 .891 r
.35169 .73274 .36594 .74577 .38933 .73563 .37523 .72235 Metetra
.708 .755 .889 r
.37523 .72235 .38933 .73563 .41289 .72534 .39892 .71179 Metetra
.709 .754 .887 r
.39892 .71179 .41289 .72534 .4366 .7149 .42278 .70106 Metetra
.709 .751 .885 r
.42278 .70106 .4366 .7149 .46047 .70432 .44679 .69016 Metetra
.71 .749 .882 r
.44679 .69016 .46047 .70432 .48449 .69362 .47096 .67911 Metetra
.71 .746 .88 r
.47096 .67911 .48449 .69362 .50868 .6828 .49528 .66791 Metetra
.71 .743 .877 r
.49528 .66791 .50868 .6828 .53302 .6719 .51977 .6566 Metetra
.71 .739 .874 r
.51977 .6566 .53302 .6719 .55752 .66095 .54441 .64522 Metetra
.708 .735 .872 r
.54441 .64522 .55752 .66095 .58218 .65001 .56921 .63383 Metetra
.706 .73 .87 r
.56921 .63383 .58218 .65001 .60702 .63911 .59417 .6225 Metetra
.703 .726 .868 r
.59417 .6225 .60702 .63911 .63202 .62831 .61931 .6113 Metetra
.699 .721 .867 r
.61931 .6113 .63202 .62831 .65721 .61767 .64463 .60029 Metetra
.695 .717 .866 r
.64463 .60029 .65721 .61767 .68258 .6072 .67013 .58953 Metetra
.691 .714 .867 r
.67013 .58953 .68258 .6072 .70815 .59694 .69584 .57903 Metetra
.687 .712 .867 r
.69584 .57903 .70815 .59694 .73393 .58688 .72175 .56879 Metetra
.683 .71 .868 r
.72175 .56879 .73393 .58688 .75992 .577 .74789 .55878 Metetra
.68 .709 .87 r
.74789 .55878 .75992 .577 .78613 .5673 .77425 .54898 Metetra
.677 .708 .871 r
.77425 .54898 .78613 .5673 .81257 .55775 .80084 .53934 Metetra
.675 .708 .873 r
.80084 .53934 .81257 .55775 .83925 .54832 .82767 .52985 Metetra
.673 .708 .874 r
.82767 .52985 .83925 .54832 .86616 .53898 .85474 .52045 Metetra
.671 .708 .876 r
.85474 .52045 .86616 .53898 .89332 .52973 .88206 .51114 Metetra
.669 .708 .877 r
.88206 .51114 .89332 .52973 .92072 .52052 .90964 .50188 Metetra
.668 .709 .878 r
.90964 .50188 .92072 .52052 .94838 .51136 .93746 .49265 Metetra
.707 .76 .893 r
.3137 .73005 .32831 .74296 .35169 .73274 .33722 .7196 Metetra
.708 .759 .891 r
.33722 .7196 .35169 .73274 .37523 .72235 .3609 .70897 Metetra
.71 .757 .889 r
.3609 .70897 .37523 .72235 .39892 .71179 .38474 .69814 Metetra
.711 .755 .887 r
.38474 .69814 .39892 .71179 .42278 .70106 .40874 .68711 Metetra
.712 .753 .884 r
.40874 .68711 .42278 .70106 .44679 .69016 .4329 .67588 Metetra
.713 .751 .882 r
.4329 .67588 .44679 .69016 .47096 .67911 .45721 .66445 Metetra
.714 .748 .879 r
.45721 .66445 .47096 .67911 .49528 .66791 .48168 .65284 Metetra
.714 .744 .876 r
.48168 .65284 .49528 .66791 .51977 .6566 .50631 .64107 Metetra
.714 .74 .872 r
.50631 .64107 .51977 .6566 .54441 .64522 .5311 .6292 Metetra
.712 .735 .869 r
.5311 .6292 .54441 .64522 .56921 .63383 .55604 .61729 Metetra
.71 .73 .866 r
.55604 .61729 .56921 .63383 .59417 .6225 .58114 .60544 Metetra
.706 .724 .864 r
.58114 .60544 .59417 .6225 .61931 .6113 .60641 .59375 Metetra
.701 .719 .863 r
.60641 .59375 .61931 .6113 .64463 .60029 .63186 .58234 Metetra
.696 .714 .863 r
.63186 .58234 .64463 .60029 .67013 .58953 .65749 .57125 Metetra
.691 .71 .863 r
.65749 .57125 .67013 .58953 .69584 .57903 .68333 .56052 Metetra
.686 .708 .864 r
.68333 .56052 .69584 .57903 .72175 .56879 .70939 .55012 Metetra
.682 .706 .865 r
.70939 .55012 .72175 .56879 .74789 .55878 .73566 .54 Metetra
.679 .705 .867 r
.73566 .54 .74789 .55878 .77425 .54898 .76217 .53013 Metetra
.675 .704 .869 r
.76217 .53013 .77425 .54898 .80084 .53934 .78891 .52045 Metetra
.673 .705 .871 r
.78891 .52045 .80084 .53934 .82767 .52985 .8159 .51091 Metetra
.671 .705 .873 r
.8159 .51091 .82767 .52985 .85474 .52045 .84313 .50149 Metetra
.669 .705 .875 r
.84313 .50149 .85474 .52045 .88206 .51114 .87062 .49213 Metetra
.668 .706 .876 r
.87062 .49213 .88206 .51114 .90964 .50188 .89837 .48283 Metetra
.666 .707 .878 r
.89837 .48283 .90964 .50188 .93746 .49265 .92637 .47356 Metetra
.709 .762 .894 r
.29885 .71705 .3137 .73005 .33722 .7196 .32251 .70638 Metetra
.71 .761 .892 r
.32251 .70638 .33722 .7196 .3609 .70897 .34633 .6955 Metetra
.712 .759 .89 r
.34633 .6955 .3609 .70897 .38474 .69814 .37032 .68439 Metetra
.713 .758 .887 r
.37032 .68439 .38474 .69814 .40874 .68711 .39447 .67306 Metetra
.715 .756 .884 r
.39447 .67306 .40874 .68711 .4329 .67588 .41878 .66149 Metetra
.716 .753 .881 r
.41878 .66149 .4329 .67588 .45721 .66445 .44325 .64967 Metetra
.718 .75 .878 r
.44325 .64967 .45721 .66445 .48168 .65284 .46788 .63762 Metetra
.718 .746 .874 r
.46788 .63762 .48168 .65284 .50631 .64107 .49265 .62534 Metetra
.718 .742 .87 r
.49265 .62534 .50631 .64107 .5311 .6292 .51759 .61289 Metetra
.717 .736 .866 r
.51759 .61289 .5311 .6292 .55604 .61729 .54267 .60036 Metetra
.715 .73 .863 r
.54267 .60036 .55604 .61729 .58114 .60544 .56791 .58787 Metetra
.71 .723 .86 r
.56791 .58787 .58114 .60544 .60641 .59375 .59331 .57561 Metetra
.704 .716 .858 r
.59331 .57561 .60641 .59375 .63186 .58234 .61889 .56371 Metetra
.697 .71 .858 r
.61889 .56371 .63186 .58234 .65749 .57125 .64465 .55228 Metetra
.691 .705 .859 r
.64465 .55228 .65749 .57125 .68333 .56052 .67063 .54133 Metetra
.685 .702 .86 r
.67063 .54133 .68333 .56052 .70939 .55012 .69682 .5308 Metetra
.68 .701 .862 r
.69682 .5308 .70939 .55012 .73566 .54 .72324 .52064 Metetra
.676 .7 .865 r
.72324 .52064 .73566 .54 .76217 .53013 .74989 .51074 Metetra
.673 .701 .867 r
.74989 .51074 .76217 .53013 .78891 .52045 .77679 .50105 Metetra
.671 .701 .869 r
.77679 .50105 .78891 .52045 .8159 .51091 .80394 .49151 Metetra
.669 .702 .872 r
.80394 .49151 .8159 .51091 .84313 .50149 .83134 .48207 Metetra
.667 .703 .874 r
.83134 .48207 .84313 .50149 .87062 .49213 .85899 .47271 Metetra
.666 .704 .875 r
.85899 .47271 .87062 .49213 .89837 .48283 .88691 .46338 Metetra
.665 .705 .877 r
.88691 .46338 .89837 .48283 .92637 .47356 .9151 .45408 Metetra
.71 .764 .894 r
.28375 .70397 .29885 .71705 .32251 .70638 .30756 .69308 Metetra
.712 .763 .892 r
.30756 .69308 .32251 .70638 .34633 .6955 .33153 .68196 Metetra
.714 .762 .89 r
.33153 .68196 .34633 .6955 .37032 .68439 .35567 .67059 Metetra
.716 .76 .888 r
.35567 .67059 .37032 .68439 .39447 .67306 .37997 .65896 Metetra
.718 .758 .885 r
.37997 .65896 .39447 .67306 .41878 .66149 .40444 .64705 Metetra
.72 .756 .881 r
.40444 .64705 .41878 .66149 .44325 .64967 .42906 .63483 Metetra
.722 .753 .877 r
.42906 .63483 .44325 .64967 .46788 .63762 .45385 .62231 Metetra
.723 .749 .873 r
.45385 .62231 .46788 .63762 .49265 .62534 .47878 .60947 Metetra
.724 .744 .868 r
.47878 .60947 .49265 .62534 .51759 .61289 .50387 .59636 Metetra
.724 .738 .863 r
.50387 .59636 .51759 .61289 .54267 .60036 .5291 .58306 Metetra
.721 .73 .858 r
.5291 .58306 .54267 .60036 .56791 .58787 .55448 .56976 Metetra
.715 .721 .854 r
.55448 .56976 .56791 .58787 .59331 .57561 .58002 .55673 Metetra
.707 .712 .852 r
.58002 .55673 .59331 .57561 .61889 .56371 .60572 .54425 Metetra
.698 .704 .852 r
.60572 .54425 .61889 .56371 .64465 .55228 .63161 .53246 Metetra
.69 .699 .853 r
.63161 .53246 .64465 .55228 .67063 .54133 .65772 .52135 Metetra
.683 .696 .856 r
.65772 .52135 .67063 .54133 .69682 .5308 .68405 .51078 Metetra
.678 .695 .859 r
.68405 .51078 .69682 .5308 .72324 .52064 .71062 .50063 Metetra
.674 .695 .862 r
.71062 .50063 .72324 .52064 .74989 .51074 .73742 .49078 Metetra
.671 .696 .865 r
.73742 .49078 .74989 .51074 .77679 .50105 .76448 .48114 Metetra
.668 .697 .868 r
.76448 .48114 .77679 .50105 .80394 .49151 .79179 .47163 Metetra
.666 .699 .871 r
.79179 .47163 .80394 .49151 .83134 .48207 .81935 .46222 Metetra
.665 .7 .873 r
.81935 .46222 .83134 .48207 .85899 .47271 .84718 .45286 Metetra
.664 .702 .875 r
.84718 .45286 .85899 .47271 .88691 .46338 .87527 .44353 Metetra
.663 .703 .877 r
.87527 .44353 .88691 .46338 .9151 .45408 .90363 .43421 Metetra
.711 .766 .895 r
.2684 .69082 .28375 .70397 .30756 .69308 .29236 .67973 Metetra
.713 .765 .893 r
.29236 .67973 .30756 .69308 .33153 .68196 .31648 .66838 Metetra
.715 .764 .891 r
.31648 .66838 .33153 .68196 .35567 .67059 .34077 .65676 Metetra
.718 .763 .888 r
.34077 .65676 .35567 .67059 .37997 .65896 .36523 .64485 Metetra
.72 .762 .885 r
.36523 .64485 .37997 .65896 .40444 .64705 .38986 .6326 Metetra
.723 .76 .882 r
.38986 .6326 .40444 .64705 .42906 .63483 .41465 .62 Metetra
.726 .757 .877 r
.41465 .62 .42906 .63483 .45385 .62231 .43959 .607 Metetra
.729 .754 .872 r
.43959 .607 .45385 .62231 .47878 .60947 .46469 .59357 Metetra
.731 .749 .866 r
.46469 .59357 .47878 .60947 .50387 .59636 .48994 .57969 Metetra
.732 .742 .859 r
.48994 .57969 .50387 .59636 .5291 .58306 .51533 .56544 Metetra
.73 .732 .852 r
.51533 .56544 .5291 .58306 .55448 .56976 .54086 .55103 Metetra
.723 .72 .847 r
.54086 .55103 .55448 .56976 .58002 .55673 .56652 .53693 Metetra
.711 .706 .844 r
.56652 .53693 .58002 .55673 .60572 .54425 .59235 .52372 Metetra
.698 .696 .844 r
.59235 .52372 .60572 .54425 .63161 .53246 .61837 .5116 Metetra
.687 .69 .847 r
.61837 .5116 .63161 .53246 .65772 .52135 .64461 .50045 Metetra
.679 .688 .852 r
.64461 .50045 .65772 .52135 .68405 .51078 .67108 .48998 Metetra
.673 .688 .856 r
.67108 .48998 .68405 .51078 .71062 .50063 .69779 .47996 Metetra
.67 .69 .86 r
.69779 .47996 .71062 .50063 .73742 .49078 .72475 .47024 Metetra
.667 .692 .864 r
.72475 .47024 .73742 .49078 .76448 .48114 .75197 .46071 Metetra
.665 .694 .867 r
.75197 .46071 .76448 .48114 .79179 .47163 .77944 .45128 Metetra
.664 .696 .87 r
.77944 .45128 .79179 .47163 .81935 .46222 .80717 .44193 Metetra
.663 .698 .872 r
.80717 .44193 .81935 .46222 .84718 .45286 .83517 .4326 Metetra
.662 .699 .874 r
.83517 .4326 .84718 .45286 .87527 .44353 .86344 .42328 Metetra
.661 .701 .876 r
.86344 .42328 .87527 .44353 .90363 .43421 .89199 .41395 Metetra
.712 .768 .896 r
.25279 .67762 .2684 .69082 .29236 .67973 .27689 .66633 Metetra
.714 .768 .894 r
.27689 .66633 .29236 .67973 .31648 .66838 .30117 .65477 Metetra
.717 .767 .892 r
.30117 .65477 .31648 .66838 .34077 .65676 .32562 .64292 Metetra
.72 .766 .89 r
.32562 .64292 .34077 .65676 .36523 .64485 .35024 .63075 Metetra
.723 .765 .887 r
.35024 .63075 .36523 .64485 .38986 .6326 .37503 .61821 Metetra
.726 .764 .883 r
.37503 .61821 .38986 .6326 .41465 .62 .39998 .60525 Metetra
.73 .762 .878 r
.39998 .60525 .41465 .62 .43959 .607 .4251 .5918 Metetra
.734 .759 .873 r
.4251 .5918 .43959 .607 .46469 .59357 .45037 .57779 Metetra
.739 .755 .865 r
.45037 .57779 .46469 .59357 .48994 .57969 .47579 .5631 Metetra
.743 .748 .856 r
.47579 .5631 .48994 .57969 .51533 .56544 .50135 .54768 Metetra
.744 .737 .846 r
.50135 .54768 .51533 .56544 .54086 .55103 .52703 .53165 Metetra
.736 .72 .836 r
.52703 .53165 .54086 .55103 .56652 .53693 .55283 .51584 Metetra
.716 .698 .832 r
.55283 .51584 .56652 .53693 .59235 .52372 .57878 .50163 Metetra
.694 .682 .835 r
.57878 .50163 .59235 .52372 .61837 .5116 .60492 .4894 Metetra
.68 .677 .84 r
.60492 .4894 .61837 .5116 .64461 .50045 .63129 .4785 Metetra
.672 .678 .847 r
.63129 .4785 .64461 .50045 .67108 .48998 .6579 .46836 Metetra
.667 .681 .853 r
.6579 .46836 .67108 .48998 .69779 .47996 .68477 .45863 Metetra
.665 .684 .858 r
.68477 .45863 .69779 .47996 .72475 .47024 .71188 .44914 Metetra
.663 .687 .863 r
.71188 .44914 .72475 .47024 .75197 .46071 .73926 .43978 Metetra
.661 .69 .866 r
.73926 .43978 .75197 .46071 .77944 .45128 .76689 .43048 Metetra
.66 .693 .869 r
.76689 .43048 .77944 .45128 .80717 .44193 .7948 .42121 Metetra
.66 .695 .872 r
.7948 .42121 .80717 .44193 .83517 .4326 .82297 .41194 Metetra
.659 .697 .874 r
.82297 .41194 .83517 .4326 .86344 .42328 .85142 .40265 Metetra
.659 .699 .876 r
.85142 .40265 .86344 .42328 .89199 .41395 .88015 .39331 Metetra
.713 .771 .898 r
.2369 .66436 .25279 .67762 .27689 .66633 .26115 .65289 Metetra
.715 .77 .896 r
.26115 .65289 .27689 .66633 .30117 .65477 .28558 .64115 Metetra
.718 .77 .894 r
.28558 .64115 .30117 .65477 .32562 .64292 .31019 .6291 Metetra
.721 .77 .891 r
.31019 .6291 .32562 .64292 .35024 .63075 .33498 .61671 Metetra
.725 .77 .888 r
.33498 .61671 .35024 .63075 .37503 .61821 .35993 .60391 Metetra
.729 .769 .885 r
.35993 .60391 .37503 .61821 .39998 .60525 .38506 .59066 Metetra
.733 .768 .881 r
.38506 .59066 .39998 .60525 .4251 .5918 .41035 .57685 Metetra
.739 .766 .875 r
.41035 .57685 .4251 .5918 .45037 .57779 .4358 .56234 Metetra
.746 .764 .867 r
.4358 .56234 .45037 .57779 .47579 .5631 .46141 .54694 Metetra
.755 .759 .856 r
.46141 .54694 .47579 .5631 .50135 .54768 .48715 .53029 Metetra
.764 .749 .839 r
.48715 .53029 .50135 .54768 .52703 .53165 .51301 .51192 Metetra
.763 .726 .819 r
.51301 .51192 .52703 .53165 .55283 .51584 .53894 .49249 Metetra
.718 .682 .814 r
.53894 .49249 .55283 .51584 .57878 .50163 .565 .47702 Metetra
.68 .657 .821 r
.565 .47702 .57878 .50163 .60492 .4894 .59126 .46553 Metetra
.667 .659 .833 r
.59126 .46553 .60492 .4894 .63129 .4785 .61777 .45547 Metetra
.662 .666 .844 r
.61777 .45547 .63129 .4785 .6579 .46836 .64453 .44596 Metetra
.66 .673 .851 r
.64453 .44596 .6579 .46836 .68477 .45863 .67154 .43669 Metetra
.659 .678 .857 r
.67154 .43669 .68477 .45863 .71188 .44914 .69882 .42753 Metetra
.658 .683 .862 r
.69882 .42753 .71188 .44914 .73926 .43978 .72635 .4184 Metetra
.657 .687 .866 r
.72635 .4184 .73926 .43978 .76689 .43048 .75415 .40926 Metetra
.657 .69 .869 r
.75415 .40926 .76689 .43048 .7948 .42121 .78223 .4001 Metetra
.657 .693 .872 r
.78223 .4001 .7948 .42121 .82297 .41194 .81058 .3909 Metetra
.657 .695 .874 r
.81058 .3909 .82297 .41194 .85142 .40265 .83921 .38164 Metetra
.657 .698 .876 r
.83921 .38164 .85142 .40265 .88015 .39331 .86812 .37231 Metetra
.713 .773 .899 r
.22072 .65106 .2369 .66436 .26115 .65289 .24513 .63943 Metetra
.716 .773 .898 r
.24513 .63943 .26115 .65289 .28558 .64115 .26972 .62753 Metetra
.719 .773 .896 r
.26972 .62753 .28558 .64115 .31019 .6291 .29449 .61531 Metetra
.722 .774 .894 r
.29449 .61531 .31019 .6291 .33498 .61671 .31944 .60274 Metetra
.726 .774 .891 r
.31944 .60274 .33498 .61671 .35993 .60391 .34456 .58976 Metetra
.73 .774 .888 r
.34456 .58976 .35993 .60391 .38506 .59066 .36986 .5763 Metetra
.736 .774 .884 r
.36986 .5763 .38506 .59066 .41035 .57685 .39533 .56225 Metetra
.742 .775 .879 r
.39533 .56225 .41035 .57685 .4358 .56234 .42096 .54745 Metetra
.751 .774 .872 r
.42096 .54745 .4358 .56234 .46141 .54694 .44676 .53164 Metetra
.764 .774 .861 r
.44676 .53164 .46141 .54694 .48715 .53029 .4727 .5143 Metetra
.784 .771 .841 r
.4727 .5143 .48715 .53029 .51301 .51192 .49876 .49408 Metetra
.858 .759 .753 r
.49876 .49408 .51301 .51192 .53894 .49249 .52489 .45693 Metetra
.631 .567 .764 r
.52489 .45693 .53894 .49249 .565 .47702 .55103 .44856 Metetra
.642 .614 .806 r
.55103 .44856 .565 .47702 .59126 .46553 .57742 .44011 Metetra
.647 .64 .829 r
.57742 .44011 .59126 .46553 .61777 .45547 .60407 .43158 Metetra
.649 .656 .843 r
.60407 .43158 .61777 .45547 .64453 .44596 .63097 .42297 Metetra
.651 .666 .852 r
.63097 .42297 .64453 .44596 .67154 .43669 .65813 .41427 Metetra
.652 .674 .858 r
.65813 .41427 .67154 .43669 .69882 .42753 .68556 .40549 Metetra
.653 .679 .863 r
.68556 .40549 .69882 .42753 .72635 .4184 .71325 .39662 Metetra
.653 .684 .867 r
.71325 .39662 .72635 .4184 .75415 .40926 .74122 .38767 Metetra
.653 .688 .87 r
.74122 .38767 .75415 .40926 .78223 .4001 .76946 .37863 Metetra
.654 .691 .873 r
.76946 .37863 .78223 .4001 .81058 .3909 .79799 .36949 Metetra
.654 .694 .875 r
.79799 .36949 .81058 .3909 .83921 .38164 .8268 .36027 Metetra
.654 .696 .877 r
.8268 .36027 .83921 .38164 .86812 .37231 .8559 .35095 Metetra
.554 .362 .575 r
.22228 .44319 .22072 .65106 .24513 .63943 .24485 .43927 Metetra
.555 .364 .577 r
.24485 .43927 .24513 .63943 .26972 .62753 .26765 .4355 Metetra
.555 .365 .579 r
.26765 .4355 .26972 .62753 .29449 .61531 .29071 .43189 Metetra
.555 .367 .581 r
.29071 .43189 .29449 .61531 .31944 .60274 .31401 .42848 Metetra
.555 .369 .584 r
.31401 .42848 .31944 .60274 .34456 .58976 .33758 .42532 Metetra
.555 .371 .588 r
.33758 .42532 .34456 .58976 .36986 .5763 .36141 .42248 Metetra
.554 .374 .592 r
.36141 .42248 .36986 .5763 .39533 .56225 .38552 .42005 Metetra
.554 .377 .597 r
.38552 .42005 .39533 .56225 .42096 .54745 .40992 .41817 Metetra
.553 .382 .603 r
.40992 .41817 .42096 .54745 .44676 .53164 .43462 .41705 Metetra
.55 .387 .613 r
.43462 .41705 .44676 .53164 .4727 .5143 .45963 .41702 Metetra
.545 .394 .627 r
.45963 .41702 .4727 .5143 .49876 .49408 .485 .4186 Metetra
.539 .412 .655 r
.485 .4186 .49876 .49408 .52489 .45693 .51076 .42119 Metetra
.563 .53 .776 r
.51076 .42119 .52489 .45693 .55103 .44856 .53693 .41982 Metetra
.608 .597 .815 r
.53693 .41982 .55103 .44856 .57742 .44011 .56342 .41439 Metetra
.628 .631 .835 r
.56342 .41439 .57742 .44011 .60407 .43158 .59018 .40738 Metetra
.637 .65 .846 r
.59018 .40738 .60407 .43158 .63097 .42297 .61722 .39966 Metetra
.642 .662 .854 r
.61722 .39966 .63097 .42297 .65813 .41427 .64453 .39153 Metetra
.645 .671 .86 r
.64453 .39153 .65813 .41427 .68556 .40549 .67211 .38313 Metetra
.647 .677 .864 r
.67211 .38313 .68556 .40549 .71325 .39662 .69996 .37452 Metetra
.649 .682 .868 r
.69996 .37452 .71325 .39662 .74122 .38767 .72809 .36575 Metetra
.65 .686 .871 r
.72809 .36575 .74122 .38767 .76946 .37863 .75651 .35682 Metetra
.651 .69 .873 r
.75651 .35682 .76946 .37863 .79799 .36949 .78521 .34776 Metetra
.651 .693 .876 r
.78521 .34776 .79799 .36949 .8268 .36027 .8142 .33857 Metetra
.652 .695 .877 r
.8142 .33857 .8268 .36027 .8559 .35095 .84348 .32926 Metetra
.588 .717 .933 r
.20666 .42846 .22228 .44319 .24485 .43927 .22932 .4244 Metetra
.585 .715 .933 r
.22932 .4244 .24485 .43927 .26765 .4355 .25223 .42047 Metetra
.58 .713 .934 r
.25223 .42047 .26765 .4355 .29071 .43189 .27538 .41668 Metetra
.575 .711 .935 r
.27538 .41668 .29071 .43189 .31401 .42848 .2988 .41309 Metetra
.569 .708 .935 r
.2988 .41309 .31401 .42848 .33758 .42532 .32247 .40972 Metetra
.563 .704 .936 r
.32247 .40972 .33758 .42532 .36141 .42248 .34641 .40662 Metetra
.555 .699 .936 r
.34641 .40662 .36141 .42248 .38552 .42005 .37064 .40388 Metetra
.545 .692 .936 r
.37064 .40388 .38552 .42005 .40992 .41817 .39515 .40156 Metetra
.534 .683 .934 r
.39515 .40156 .40992 .41817 .43462 .41705 .41997 .39978 Metetra
.522 .67 .93 r
.41997 .39978 .43462 .41705 .45963 .41702 .44511 .39861 Metetra
.517 .654 .92 r
.44511 .39861 .45963 .41702 .485 .4186 .47059 .39794 Metetra
.533 .635 .897 r
.47059 .39794 .485 .4186 .51076 .42119 .49645 .39698 Metetra
.569 .616 .86 r
.49645 .39698 .51076 .42119 .53693 .41982 .52268 .39434 Metetra
.599 .62 .845 r
.52268 .39434 .53693 .41982 .56342 .41439 .54926 .38963 Metetra
.617 .637 .848 r
.54926 .38963 .56342 .41439 .59018 .40738 .57613 .38343 Metetra
.628 .651 .854 r
.57613 .38343 .59018 .40738 .61722 .39966 .60329 .37633 Metetra
.635 .662 .859 r
.60329 .37633 .61722 .39966 .64453 .39153 .63074 .36865 Metetra
.639 .67 .863 r
.63074 .36865 .64453 .39153 .67211 .38313 .65846 .36056 Metetra
.642 .676 .867 r
.65846 .36056 .67211 .38313 .69996 .37452 .68647 .35218 Metetra
.645 .681 .87 r
.68647 .35218 .69996 .37452 .72809 .36575 .71477 .34355 Metetra
.646 .685 .872 r
.71477 .34355 .72809 .36575 .75651 .35682 .74335 .33472 Metetra
.648 .689 .875 r
.74335 .33472 .75651 .35682 .78521 .34776 .77222 .32571 Metetra
.649 .692 .877 r
.77222 .32571 .78521 .34776 .8142 .33857 .80139 .31655 Metetra
.65 .695 .878 r
.80139 .31655 .8142 .33857 .84348 .32926 .83086 .30723 Metetra
.59 .716 .931 r
.1908 .41334 .20666 .42846 .22932 .4244 .21356 .40911 Metetra
.587 .714 .931 r
.21356 .40911 .22932 .4244 .25223 .42047 .23657 .40499 Metetra
.583 .711 .931 r
.23657 .40499 .25223 .42047 .27538 .41668 .25983 .401 Metetra
.579 .709 .931 r
.25983 .401 .27538 .41668 .2988 .41309 .28335 .39718 Metetra
.574 .705 .931 r
.28335 .39718 .2988 .41309 .32247 .40972 .30713 .39354 Metetra
.568 .701 .931 r
.30713 .39354 .32247 .40972 .34641 .40662 .33119 .39012 Metetra
.563 .696 .93 r
.33119 .39012 .34641 .40662 .37064 .40388 .35553 .38697 Metetra
.556 .69 .929 r
.35553 .38697 .37064 .40388 .39515 .40156 .38016 .38412 Metetra
.551 .682 .926 r
.38016 .38412 .39515 .40156 .41997 .39978 .40511 .38158 Metetra
.547 .672 .92 r
.40511 .38158 .41997 .39978 .44511 .39861 .43037 .37929 Metetra
.55 .661 .91 r
.43037 .37929 .44511 .39861 .47059 .39794 .45598 .37706 Metetra
.561 .649 .894 r
.45598 .37706 .47059 .39794 .49645 .39698 .48194 .3744 Metetra
.58 .64 .875 r
.48194 .3744 .49645 .39698 .52268 .39434 .50826 .37077 Metetra
.598 .641 .864 r
.50826 .37077 .52268 .39434 .54926 .38963 .53492 .36591 Metetra
.612 .647 .861 r
.53492 .36591 .54926 .38963 .57613 .38343 .5619 .35996 Metetra
.622 .656 .862 r
.5619 .35996 .57613 .38343 .60329 .37633 .58918 .35316 Metetra
.63 .664 .865 r
.58918 .35316 .60329 .37633 .63074 .36865 .61676 .34575 Metetra
.635 .671 .867 r
.61676 .34575 .63074 .36865 .65846 .36056 .64463 .33788 Metetra
.638 .676 .87 r
.64463 .33788 .65846 .36056 .68647 .35218 .67279 .32964 Metetra
.641 .681 .872 r
.67279 .32964 .68647 .35218 .71477 .34355 .70124 .32112 Metetra
.643 .685 .874 r
.70124 .32112 .71477 .34355 .74335 .33472 .72999 .31236 Metetra
.645 .689 .876 r
.72999 .31236 .74335 .33472 .77222 .32571 .75904 .30339 Metetra
.646 .692 .878 r
.75904 .30339 .77222 .32571 .80139 .31655 .78839 .29422 Metetra
.648 .694 .879 r
.78839 .29422 .80139 .31655 .83086 .30723 .81805 .28489 Metetra
.592 .714 .929 r
.17469 .39783 .1908 .41334 .21356 .40911 .19755 .39341 Metetra
.589 .712 .929 r
.19755 .39341 .21356 .40911 .23657 .40499 .22067 .38908 Metetra
.586 .71 .929 r
.22067 .38908 .23657 .40499 .25983 .401 .24403 .38486 Metetra
.582 .707 .928 r
.24403 .38486 .25983 .401 .28335 .39718 .26766 .38077 Metetra
.579 .704 .928 r
.26766 .38077 .28335 .39718 .30713 .39354 .29156 .37682 Metetra
.575 .7 .927 r
.29156 .37682 .30713 .39354 .33119 .39012 .31573 .37305 Metetra
.571 .695 .926 r
.31573 .37305 .33119 .39012 .35553 .38697 .34019 .36945 Metetra
.567 .69 .923 r
.34019 .36945 .35553 .38697 .38016 .38412 .36495 .36603 Metetra
.564 .683 .919 r
.36495 .36603 .38016 .38412 .40511 .38158 .39002 .36276 Metetra
.564 .675 .914 r
.39002 .36276 .40511 .38158 .43037 .37929 .41541 .35955 Metetra
.568 .667 .905 r
.41541 .35955 .43037 .37929 .45598 .37706 .44114 .35623 Metetra
.576 .66 .894 r
.44114 .35623 .45598 .37706 .48194 .3744 .46721 .35251 Metetra
.588 .655 .883 r
.46721 .35251 .48194 .3744 .50826 .37077 .49363 .34813 Metetra
.6 .654 .875 r
.49363 .34813 .50826 .37077 .53492 .36591 .52039 .34293 Metetra
.611 .657 .871 r
.52039 .34293 .53492 .36591 .5619 .35996 .54748 .33691 Metetra
.619 .662 .87 r
.54748 .33691 .5619 .35996 .58918 .35316 .57488 .33018 Metetra
.626 .668 .87 r
.57488 .33018 .58918 .35316 .61676 .34575 .60259 .32288 Metetra
.631 .673 .872 r
.60259 .32288 .61676 .34575 .64463 .33788 .6306 .31511 Metetra
.635 .678 .873 r
.6306 .31511 .64463 .33788 .67279 .32964 .65891 .30696 Metetra
.638 .682 .875 r
.65891 .30696 .67279 .32964 .70124 .32112 .68752 .2985 Metetra
.641 .686 .876 r
.68752 .2985 .70124 .32112 .72999 .31236 .71643 .28976 Metetra
.643 .689 .878 r
.71643 .28976 .72999 .31236 .75904 .30339 .74565 .28079 Metetra
.644 .692 .879 r
.74565 .28079 .75904 .30339 .78839 .29422 .77518 .27161 Metetra
.646 .694 .881 r
.77518 .27161 .78839 .29422 .81805 .28489 .80503 .26224 Metetra
.594 .713 .927 r
.15833 .38194 .17469 .39783 .19755 .39341 .1813 .3773 Metetra
.592 .711 .926 r
.1813 .3773 .19755 .39341 .22067 .38908 .20452 .37274 Metetra
.589 .709 .926 r
.20452 .37274 .22067 .38908 .24403 .38486 .22799 .36827 Metetra
.586 .706 .926 r
.22799 .36827 .24403 .38486 .26766 .38077 .25173 .36389 Metetra
.583 .703 .925 r
.25173 .36389 .26766 .38077 .29156 .37682 .27575 .35962 Metetra
.58 .699 .924 r
.27575 .35962 .29156 .37682 .31573 .37305 .30004 .35546 Metetra
.578 .695 .922 r
.30004 .35546 .31573 .37305 .34019 .36945 .32462 .35141 Metetra
.576 .69 .919 r
.32462 .35141 .34019 .36945 .36495 .36603 .3495 .34745 Metetra
.575 .685 .915 r
.3495 .34745 .36495 .36603 .39002 .36276 .3747 .34353 Metetra
.576 .679 .91 r
.3747 .34353 .39002 .36276 .41541 .35955 .40021 .33956 Metetra
.58 .673 .903 r
.40021 .33956 .41541 .35955 .44114 .35623 .42606 .33543 Metetra
.586 .668 .896 r
.42606 .33543 .44114 .35623 .46721 .35251 .45225 .33095 Metetra
.594 .665 .888 r
.45225 .33095 .46721 .35251 .49363 .34813 .47878 .32597 Metetra
.602 .664 .882 r
.47878 .32597 .49363 .34813 .52039 .34293 .50565 .32038 Metetra
.611 .665 .878 r
.50565 .32038 .52039 .34293 .54748 .33691 .53285 .31416 Metetra
.618 .668 .876 r
.53285 .31416 .54748 .33691 .57488 .33018 .56037 .30736 Metetra
.624 .672 .876 r
.56037 .30736 .57488 .33018 .60259 .32288 .58821 .30005 Metetra
.629 .676 .876 r
.58821 .30005 .60259 .32288 .6306 .31511 .61636 .29229 Metetra
.633 .68 .877 r
.61636 .29229 .6306 .31511 .65891 .30696 .64482 .28415 Metetra
.636 .683 .878 r
.64482 .28415 .65891 .30696 .68752 .2985 .67359 .27569 Metetra
.639 .686 .879 r
.67359 .27569 .68752 .2985 .71643 .28976 .70267 .26695 Metetra
.641 .689 .88 r
.70267 .26695 .71643 .28976 .74565 .28079 .73206 .25795 Metetra
.642 .692 .881 r
.73206 .25795 .74565 .28079 .77518 .27161 .76177 .24873 Metetra
.644 .694 .882 r
.76177 .24873 .77518 .27161 .80503 .26224 .7918 .23929 Metetra
.596 .712 .925 r
.14172 .36566 .15833 .38194 .1813 .3773 .16479 .3608 Metetra
.594 .71 .924 r
.16479 .3608 .1813 .3773 .20452 .37274 .18812 .356 Metetra
.592 .708 .924 r
.18812 .356 .20452 .37274 .22799 .36827 .2117 .35126 Metetra
.59 .705 .923 r
.2117 .35126 .22799 .36827 .25173 .36389 .23556 .34658 Metetra
.588 .702 .922 r
.23556 .34658 .25173 .36389 .27575 .35962 .25969 .34197 Metetra
.586 .699 .921 r
.25969 .34197 .27575 .35962 .30004 .35546 .2841 .33743 Metetra
.584 .695 .919 r
.2841 .33743 .30004 .35546 .32462 .35141 .30881 .33293 Metetra
.583 .691 .916 r
.30881 .33293 .32462 .35141 .3495 .34745 .33381 .32846 Metetra
.583 .687 .912 r
.33381 .32846 .3495 .34745 .3747 .34353 .35913 .32397 Metetra
.585 .682 .908 r
.35913 .32397 .3747 .34353 .40021 .33956 .38477 .31938 Metetra
.588 .678 .902 r
.38477 .31938 .40021 .33956 .42606 .33543 .41075 .31459 Metetra
.593 .674 .897 r
.41075 .31459 .42606 .33543 .45225 .33095 .43705 .30951 Metetra
.599 .672 .891 r
.43705 .30951 .45225 .33095 .47878 .32597 .4637 .30402 Metetra
.605 .671 .886 r
.4637 .30402 .47878 .32597 .50565 .32038 .49069 .29806 Metetra
.612 .672 .883 r
.49069 .29806 .50565 .32038 .53285 .31416 .51801 .29159 Metetra
.618 .673 .881 r
.51801 .29159 .53285 .31416 .56037 .30736 .54565 .28463 Metetra
.623 .676 .88 r
.54565 .28463 .56037 .30736 .58821 .30005 .57362 .27722 Metetra
.627 .679 .879 r
.57362 .27722 .58821 .30005 .61636 .29229 .60191 .2694 Metetra
.631 .682 .88 r
.60191 .2694 .61636 .29229 .64482 .28415 .63052 .26121 Metetra
.634 .685 .88 r
.63052 .26121 .64482 .28415 .67359 .27569 .65944 .25271 Metetra
.637 .688 .881 r
.65944 .25271 .67359 .27569 .70267 .26695 .68868 .24391 Metetra
.639 .69 .882 r
.68868 .24391 .70267 .26695 .73206 .25795 .71825 .23485 Metetra
.641 .692 .882 r
.71825 .23485 .73206 .25795 .76177 .24873 .74814 .22556 Metetra
.642 .695 .883 r
.74814 .22556 .76177 .24873 .7918 .23929 .77835 .21605 Metetra
.599 .711 .923 r
.12485 .34901 .14172 .36566 .16479 .3608 .14803 .34392 Metetra
.597 .709 .923 r
.14803 .34392 .16479 .3608 .18812 .356 .17146 .33886 Metetra
.595 .707 .922 r
.17146 .33886 .18812 .356 .2117 .35126 .19516 .33384 Metetra
.593 .705 .921 r
.19516 .33384 .2117 .35126 .23556 .34658 .21913 .32886 Metetra
.592 .702 .92 r
.21913 .32886 .23556 .34658 .25969 .34197 .24337 .32391 Metetra
.591 .699 .918 r
.24337 .32391 .25969 .34197 .2841 .33743 .26791 .31898 Metetra
.59 .696 .916 r
.26791 .31898 .2841 .33743 .30881 .33293 .29273 .31407 Metetra
.589 .693 .914 r
.29273 .31407 .30881 .33293 .33381 .32846 .31787 .30913 Metetra
.59 .689 .91 r
.31787 .30913 .33381 .32846 .35913 .32397 .34331 .30413 Metetra
.592 .685 .907 r
.34331 .30413 .35913 .32397 .38477 .31938 .36908 .299 Metetra
.594 .682 .902 r
.36908 .299 .38477 .31938 .41075 .31459 .39518 .29368 Metetra
.598 .679 .898 r
.39518 .29368 .41075 .31459 .43705 .30951 .42161 .28809 Metetra
.603 .677 .893 r
.42161 .28809 .43705 .30951 .4637 .30402 .44838 .28215 Metetra
.608 .677 .89 r
.44838 .28215 .4637 .30402 .49069 .29806 .47548 .27583 Metetra
.613 .677 .887 r
.47548 .27583 .49069 .29806 .51801 .29159 .50293 .26908 Metetra
.618 .678 .885 r
.50293 .26908 .51801 .29159 .54565 .28463 .5307 .26192 Metetra
.622 .68 .883 r
.5307 .26192 .54565 .28463 .57362 .27722 .5588 .25436 Metetra
.626 .682 .883 r
.5588 .25436 .57362 .27722 .60191 .2694 .58723 .24642 Metetra
.63 .684 .882 r
.58723 .24642 .60191 .2694 .63052 .26121 .61599 .23813 Metetra
.633 .687 .883 r
.61599 .23813 .63052 .26121 .65944 .25271 .64507 .22954 Metetra
.635 .689 .883 r
.64507 .22954 .65944 .25271 .68868 .24391 .67448 .22065 Metetra
.638 .691 .883 r
.67448 .22065 .68868 .24391 .71825 .23485 .70422 .21151 Metetra
.639 .693 .884 r
.70422 .21151 .71825 .23485 .74814 .22556 .73429 .20212 Metetra
.641 .695 .885 r
.73429 .20212 .74814 .22556 .77835 .21605 .76469 .19251 Metetra
.601 .711 .921 r
.10771 .33199 .12485 .34901 .14803 .34392 .13099 .32665 Metetra
.599 .709 .921 r
.13099 .32665 .14803 .34392 .17146 .33886 .15454 .32133 Metetra
.598 .707 .92 r
.15454 .32133 .17146 .33886 .19516 .33384 .17835 .31603 Metetra
.597 .705 .919 r
.17835 .31603 .19516 .33384 .21913 .32886 .20243 .31074 Metetra
.596 .702 .918 r
.20243 .31074 .21913 .32886 .24337 .32391 .22679 .30546 Metetra
.595 .7 .916 r
.22679 .30546 .24337 .32391 .26791 .31898 .25145 .30017 Metetra
.594 .697 .914 r
.25145 .30017 .26791 .31898 .29273 .31407 .2764 .29485 Metetra
.595 .694 .912 r
.2764 .29485 .29273 .31407 .31787 .30913 .30166 .28948 Metetra
.595 .691 .909 r
.30166 .28948 .31787 .30913 .34331 .30413 .32723 .28402 Metetra
.597 .688 .906 r
.32723 .28402 .34331 .30413 .36908 .299 .35313 .27842 Metetra
.599 .685 .902 r
.35313 .27842 .36908 .299 .39518 .29368 .37935 .27263 Metetra
.602 .683 .899 r
.37935 .27263 .39518 .29368 .42161 .28809 .40591 .26659 Metetra
.606 .682 .895 r
.40591 .26659 .42161 .28809 .44838 .28215 .4328 .26026 Metetra
.61 .681 .892 r
.4328 .26026 .44838 .28215 .47548 .27583 .46003 .25359 Metetra
.614 .681 .89 r
.46003 .25359 .47548 .27583 .50293 .26908 .4876 .24656 Metetra
.619 .682 .888 r
.4876 .24656 .50293 .26908 .5307 .26192 .51551 .23916 Metetra
.622 .683 .886 r
.51551 .23916 .5307 .26192 .5588 .25436 .54375 .23141 Metetra
.626 .685 .885 r
.54375 .23141 .5588 .25436 .58723 .24642 .57233 .22331 Metetra
.629 .687 .885 r
.57233 .22331 .58723 .24642 .61599 .23813 .60123 .21489 Metetra
.632 .688 .885 r
.60123 .21489 .61599 .23813 .64507 .22954 .63047 .20617 Metetra
.634 .69 .885 r
.63047 .20617 .64507 .22954 .67448 .22065 .66005 .19717 Metetra
.636 .692 .885 r
.66005 .19717 .67448 .22065 .70422 .21151 .68996 .18791 Metetra
.638 .694 .886 r
.68996 .18791 .70422 .21151 .73429 .20212 .72021 .1784 Metetra
.64 .696 .886 r
.72021 .1784 .73429 .20212 .76469 .19251 .7508 .16866 Metetra
.603 .711 .92 r
.0903 .31461 .10771 .33199 .13099 .32665 .11369 .30902 Metetra
.602 .709 .919 r
.11369 .30902 .13099 .32665 .15454 .32133 .13734 .30344 Metetra
.601 .707 .918 r
.13734 .30344 .15454 .32133 .17835 .31603 .16126 .29785 Metetra
.6 .705 .917 r
.16126 .29785 .17835 .31603 .20243 .31074 .18546 .29226 Metetra
.599 .703 .916 r
.18546 .29226 .20243 .31074 .22679 .30546 .20995 .28664 Metetra
.599 .7 .915 r
.20995 .28664 .22679 .30546 .25145 .30017 .23472 .281 Metetra
.599 .698 .913 r
.23472 .281 .25145 .30017 .2764 .29485 .2598 .2753 Metetra
.599 .695 .911 r
.2598 .2753 .2764 .29485 .30166 .28948 .28518 .26953 Metetra
.6 .693 .908 r
.28518 .26953 .30166 .28948 .32723 .28402 .31088 .26365 Metetra
.601 .691 .905 r
.31088 .26365 .32723 .28402 .35313 .27842 .33691 .25763 Metetra
.603 .688 .902 r
.33691 .25763 .35313 .27842 .37935 .27263 .36326 .25142 Metetra
.606 .687 .899 r
.36326 .25142 .37935 .27263 .40591 .26659 .38994 .24498 Metetra
.609 .686 .897 r
.38994 .24498 .40591 .26659 .4328 .26026 .41697 .23827 Metetra
.612 .685 .894 r
.41697 .23827 .4328 .26026 .46003 .25359 .44433 .23127 Metetra
.616 .685 .892 r
.44433 .23127 .46003 .25359 .4876 .24656 .47203 .22395 Metetra
.619 .685 .89 r
.47203 .22395 .4876 .24656 .51551 .23916 .50007 .21631 Metetra
.623 .686 .889 r
.50007 .21631 .51551 .23916 .54375 .23141 .52845 .20834 Metetra
.626 .687 .888 r
.52845 .20834 .54375 .23141 .57233 .22331 .55717 .20006 Metetra
.629 .689 .887 r
.55717 .20006 .57233 .22331 .60123 .21489 .58623 .19147 Metetra
.631 .69 .887 r
.58623 .19147 .60123 .21489 .63047 .20617 .61563 .1826 Metetra
.633 .692 .887 r
.61563 .1826 .63047 .20617 .66005 .19717 .64537 .17345 Metetra
.636 .694 .887 r
.64537 .17345 .66005 .19717 .68996 .18791 .67546 .16404 Metetra
.637 .695 .887 r
.67546 .16404 .68996 .18791 .72021 .1784 .70589 .15439 Metetra
.639 .697 .887 r
.70589 .15439 .72021 .1784 .7508 .16866 .73667 .14451 Metetra
.605 .71 .919 r
.0726 .29687 .0903 .31461 .11369 .30902 .0961 .29103 Metetra
.604 .709 .918 r
.0961 .29103 .11369 .30902 .13734 .30344 .11986 .28518 Metetra
.603 .707 .917 r
.11986 .28518 .13734 .30344 .16126 .29785 .1439 .27931 Metetra
.603 .705 .916 r
.1439 .27931 .16126 .29785 .18546 .29226 .16821 .27341 Metetra
.602 .703 .915 r
.16821 .27341 .18546 .29226 .20995 .28664 .19282 .26747 Metetra
.602 .701 .913 r
.19282 .26747 .20995 .28664 .23472 .281 .21772 .26149 Metetra
.602 .699 .912 r
.21772 .26149 .23472 .281 .2598 .2753 .24292 .25543 Metetra
.603 .697 .91 r
.24292 .25543 .2598 .2753 .28518 .26953 .26843 .24928 Metetra
.603 .695 .907 r
.26843 .24928 .28518 .26953 .31088 .26365 .29426 .24302 Metetra
.605 .693 .905 r
.29426 .24302 .31088 .26365 .33691 .25763 .32041 .2366 Metetra
.607 .691 .903 r
.32041 .2366 .33691 .25763 .36326 .25142 .34689 .23001 Metetra
.609 .69 .9 r
.34689 .23001 .36326 .25142 .38994 .24498 .37371 .2232 Metetra
.611 .689 .898 r
.37371 .2232 .38994 .24498 .41697 .23827 .40086 .21614 Metetra
.614 .688 .896 r
.40086 .21614 .41697 .23827 .44433 .23127 .42836 .20882 Metetra
.617 .688 .894 r
.42836 .20882 .44433 .23127 .47203 .22395 .45619 .20121 Metetra
.62 .688 .892 r
.45619 .20121 .47203 .22395 .50007 .21631 .48437 .19331 Metetra
.623 .689 .891 r
.48437 .19331 .50007 .21631 .52845 .20834 .5129 .18511 Metetra
.626 .69 .89 r
.5129 .18511 .52845 .20834 .55717 .20006 .54177 .17662 Metetra
.628 .691 .889 r
.54177 .17662 .55717 .20006 .58623 .19147 .57098 .16784 Metetra
.631 .692 .889 r
.57098 .16784 .58623 .19147 .61563 .1826 .60055 .15878 Metetra
.633 .693 .888 r
.60055 .15878 .61563 .1826 .64537 .17345 .63046 .14946 Metetra
.635 .695 .888 r
.63046 .14946 .64537 .17345 .67546 .16404 .66072 .13989 Metetra
.637 .696 .888 r
.66072 .13989 .67546 .16404 .70589 .15439 .69133 .13008 Metetra
.638 .698 .889 r
.69133 .13008 .70589 .15439 .73667 .14451 .7223 .12003 Metetra
.607 .71 .918 r
.05462 .27878 .0726 .29687 .0961 .29103 .07822 .27269 Metetra
.606 .709 .917 r
.07822 .27269 .0961 .29103 .11986 .28518 .10209 .26656 Metetra
.606 .707 .916 r
.10209 .26656 .11986 .28518 .1439 .27931 .12624 .26041 Metetra
.605 .706 .915 r
.12624 .26041 .1439 .27931 .16821 .27341 .15068 .25421 Metetra
.605 .704 .914 r
.15068 .25421 .16821 .27341 .19282 .26747 .1754 .24796 Metetra
.605 .702 .912 r
.1754 .24796 .19282 .26747 .21772 .26149 .20042 .24164 Metetra
.605 .7 .911 r
.20042 .24164 .21772 .26149 .24292 .25543 .22575 .23524 Metetra
.606 .698 .909 r
.22575 .23524 .24292 .25543 .26843 .24928 .25139 .22874 Metetra
.607 .697 .907 r
.25139 .22874 .26843 .24928 .29426 .24302 .27735 .22211 Metetra
.608 .695 .905 r
.27735 .22211 .29426 .24302 .32041 .2366 .30363 .21533 Metetra
.609 .693 .903 r
.30363 .21533 .32041 .2366 .34689 .23001 .33024 .20837 Metetra
.611 .692 .901 r
.33024 .20837 .34689 .23001 .37371 .2232 .35719 .20121 Metetra
.614 .691 .899 r
.35719 .20121 .37371 .2232 .40086 .21614 .38448 .19382 Metetra
.616 .691 .897 r
.38448 .19382 .40086 .21614 .42836 .20882 .41211 .18619 Metetra
.619 .691 .895 r
.41211 .18619 .42836 .20882 .45619 .20121 .44009 .17829 Metetra
.621 .691 .894 r
.44009 .17829 .45619 .20121 .48437 .19331 .46841 .17012 Metetra
.624 .691 .892 r
.46841 .17012 .48437 .19331 .5129 .18511 .49708 .16168 Metetra
.626 .692 .891 r
.49708 .16168 .5129 .18511 .54177 .17662 .5261 .15296 Metetra
.628 .693 .891 r
.5261 .15296 .54177 .17662 .57098 .16784 .55548 .14397 Metetra
.631 .694 .89 r
.55548 .14397 .57098 .16784 .60055 .15878 .5852 .13472 Metetra
.633 .695 .89 r
.5852 .13472 .60055 .15878 .63046 .14946 .61528 .12521 Metetra
.634 .696 .89 r
.61528 .12521 .63046 .14946 .66072 .13989 .64572 .11545 Metetra
.636 .697 .89 r
.64572 .11545 .66072 .13989 .69133 .13008 .67652 .10545 Metetra
.638 .699 .89 r
.67652 .10545 .69133 .13008 .7223 .12003 .70768 .09522 Metetra
.609 .71 .916 r
.03634 .26033 .05462 .27878 .07822 .27269 .06005 .25398 Metetra
.609 .709 .916 r
.06005 .25398 .07822 .27269 .10209 .26656 .08403 .24759 Metetra
.608 .708 .915 r
.08403 .24759 .10209 .26656 .12624 .26041 .1083 .24115 Metetra
.608 .706 .914 r
.1083 .24115 .12624 .26041 .15068 .25421 .13285 .23466 Metetra
.608 .704 .913 r
.13285 .23466 .15068 .25421 .1754 .24796 .15769 .2281 Metetra
.608 .703 .911 r
.15769 .2281 .1754 .24796 .20042 .24164 .18284 .22146 Metetra
.608 .701 .91 r
.18284 .22146 .20042 .24164 .22575 .23524 .20829 .21473 Metetra
.609 .7 .908 r
.20829 .21473 .22575 .23524 .25139 .22874 .23405 .20789 Metetra
.609 .698 .907 r
.23405 .20789 .25139 .22874 .27735 .22211 .26014 .20091 Metetra
.611 .697 .905 r
.26014 .20091 .27735 .22211 .30363 .21533 .28655 .19379 Metetra
.612 .695 .903 r
.28655 .19379 .30363 .21533 .33024 .20837 .3133 .18648 Metetra
.614 .694 .901 r
.3133 .18648 .33024 .20837 .35719 .20121 .34038 .17899 Metetra
.616 .694 .899 r
.34038 .17899 .35719 .20121 .38448 .19382 .36781 .17128 Metetra
.618 .693 .898 r
.36781 .17128 .38448 .19382 .41211 .18619 .39558 .16334 Metetra
.62 .693 .896 r
.39558 .16334 .41211 .18619 .44009 .17829 .4237 .15515 Metetra
.622 .693 .895 r
.4237 .15515 .44009 .17829 .46841 .17012 .45217 .14671 Metetra
.624 .693 .894 r
.45217 .14671 .46841 .17012 .49708 .16168 .48099 .13801 Metetra
.626 .694 .893 r
.48099 .13801 .49708 .16168 .5261 .15296 .51016 .12905 Metetra
.629 .695 .892 r
.51016 .12905 .5261 .15296 .55548 .14397 .5397 .11984 Metetra
.631 .695 .892 r
.5397 .11984 .55548 .14397 .5852 .13472 .56959 .11037 Metetra
.632 .696 .891 r
.56959 .11037 .5852 .13472 .61528 .12521 .59984 .10065 Metetra
.634 .697 .891 r
.59984 .10065 .61528 .12521 .64572 .11545 .63046 .09069 Metetra
.636 .698 .891 r
.63046 .09069 .64572 .11545 .67652 .10545 .66145 .08049 Metetra
.637 .7 .891 r
.66145 .08049 .67652 .10545 .70768 .09522 .6928 .07006 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-4)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-2)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(2)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(4)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.07346 .24092 m
.0763 .24365 L
s
.11029 .2265 m
.1131 .22926 L
s
.14766 .21187 m
.15043 .21466 L
s
.22407 .18195 m
.22677 .18482 L
s
.26314 .16665 m
.2658 .16956 L
s
.3028 .15112 m
.30541 .15406 L
s
.38395 .11935 m
.38647 .12237 L
s
.42547 .10309 m
.42794 .10615 L
s
.46763 .08658 m
.47006 .08968 L
s
.55397 .05277 m
.55629 .05595 L
s
.59817 .03546 m
.60044 .03868 L
s
.64309 .01787 m
.6453 .02113 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.8"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.2.8"]
}, Open  ]],

Cell[TextData[{
  "When you find an ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " root using ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["z",
            "TI"], 
          RowBox[{"1", "/", 
            StyleBox["n",
              "TI"]}]], TraditionalForm]], "InlineFormula"],
  ", there are, in principle, ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " possible results. To get a single value, you have to choose a particular \
",
  StyleBox["principal root", "TI"],
  ". There is absolutely no guarantee that taking the ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " root of an ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " power will leave you with the same number. "
}], "Text",
  CellTags->{"S3.2.8", "8.12"}],

Cell["\<\
This takes the tenth power of a complex number. The result is \
unique. \
\>", "MathCaption",
  CellTags->{"S3.2.8", "8.13"}],

Cell[CellGroupData[{

Cell["(2.5 + I)^10", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.2.8"],

Cell[BoxData[
    \(\(-15781.1513671875`\) - 12335.83984375`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.2.8"]
}, Open  ]],

Cell[TextData[{
  "There are ten possible tenth roots. ",
  StyleBox["Mathematica", "TI"],
  " chooses one of them. In this case it is not the number whose tenth power \
you took. "
}], "MathCaption",
  CellTags->{"S3.2.8", "8.14"}],

Cell[CellGroupData[{

Cell["%^(1/10)", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.2.8"],

Cell[BoxData[
    \(\(\(2.610327738229842`\)\(\[InvisibleSpace]\)\) - 
      0.6604461363562355`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.2.8"]
}, Open  ]],

Cell[TextData[{
  "There are many mathematical functions which, like roots, essentially give \
solutions to equations. The logarithm function and the inverse trigonometric \
functions are examples. In almost all cases, there are many possible \
solutions to the equations. Unique \[OpenCurlyDoubleQuote]principal\
\[CloseCurlyDoubleQuote] values nevertheless have to be chosen for the \
functions. The choices cannot be made continuous over the whole complex \
plane. Instead, lines of discontinuity, or branch cuts, must occur. The \
positions of these branch cuts are often quite arbitrary. ",
  StyleBox["Mathematica", "TI"],
  " makes the most standard mathematical choices for them.  "
}], "Text",
  CellTags->{"S3.2.8", "8.15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Sqrt[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]and \[ThinSpace]",
              StyleBox["z", "TI"],
              StyleBox["^", "MR"],
              StyleBox["s", "TI"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\((\(-\[Infinity]\), 0)\)\)], 
                "InlineFormula"],
              " for ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"Re", " ", 
                      StyleBox["s",
                        "TI"], ">", "0"}], TraditionalForm]], 
                "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\((\(-\[Infinity]\), 0]\)\)], 
                "InlineFormula"],
              " for ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"Re", " ", 
                      StyleBox["s",
                        "TI"], "\[LessEqual]", "0"}], TraditionalForm]], 
                "InlineFormula"],
              "  (",
              StyleBox["s", "TI"],
              " not an integer) "
            }]]},
          {Cell[TextData[{
              StyleBox["Exp[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["none "]},
          {Cell[TextData[{
              StyleBox["Log[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\((\(-\[Infinity]\), 0]\)\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell["trigonometric functions "], Cell["none "]},
          {Cell[TextData[{
              StyleBox["ArcSin[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]and \[ThinSpace]",
              StyleBox["ArcCos[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\((\(-\[Infinity]\), \(-1\))\)\)], 
                "InlineFormula"],
              " and ",
              Cell[BoxData[
                  \(TraditionalForm\`\((\(+1\), \(+\[Infinity]\))\)\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ArcTan[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{"(", 
                      RowBox[{"-", 
                        StyleBox["i",
                          "TI"], "\[Infinity]", ",", "-", 
                        StyleBox["i",
                          "TI"]}], "]"}], TraditionalForm]], "InlineFormula"],
              
              " and ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"[", 
                      RowBox[{
                        StyleBox["i",
                          "TI"], ",", 
                        StyleBox["i",
                          "TI"], "\[Infinity]"}], ")"}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ArcCsc[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]and \[ThinSpace]",
              StyleBox["ArcSec[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\((\(-1\), \(+1\))\)\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ArcCot[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{"[", 
                      RowBox[{"-", 
                        StyleBox["i",
                          "TI"], ",", "+", 
                        StyleBox["i",
                          "TI"]}], "]"}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell["hyperbolic functions "], Cell["none "]},
          {Cell[TextData[{
              StyleBox["ArcSinh[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{"(", 
                      RowBox[{"-", 
                        StyleBox["i",
                          "TI"], "\[Infinity]", ",", "-", 
                        StyleBox["i",
                          "TI"]}], ")"}], TraditionalForm]], "InlineFormula"],
              
              " and ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"(", 
                      RowBox[{"+", 
                        StyleBox["i",
                          "TI"], ",", "+", 
                        StyleBox["i",
                          "TI"], "\[Infinity]"}], ")"}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ArcCosh[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\((\(-\[Infinity]\), \(+1\))\)\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ArcTanh[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\((\(-\[Infinity]\), \(-1\)]\)\)], 
                "InlineFormula"],
              " and ",
              Cell[BoxData[
                  \(TraditionalForm\`\(\([\)\(\(+1\), \(+\[Infinity]\)\)\()\)\
\)\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ArcCsch[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{"(", 
                      RowBox[{"-", 
                        StyleBox["i",
                          "TI"], ",", 
                        StyleBox["i",
                          "TI"]}], ")"}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ArcSech[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\((\(-\[Infinity]\), 0]\)\)], 
                "InlineFormula"],
              " and ",
              Cell[BoxData[
                  \(TraditionalForm\`\((\(+1\), \(+\[Infinity]\))\)\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ArcCoth[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[Cell[BoxData[
                \(TraditionalForm\`\(\([\)\(\(-1\), \(+1\)\)\(]\)\)\)], 
              "InlineFormula"]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.8"],

Cell["\<\
Some branch\[Hyphen]cut discontinuities in the complex plane.\
\>", \
"Caption",
  CellTags->"S3.2.8"],

Cell[TextData[{
  StyleBox["ArcSin", "MR"],
  " is a multiple\[Hyphen]valued function, so there is no guarantee that it \
always gives the \[OpenCurlyDoubleQuote]inverse\[CloseCurlyDoubleQuote] of ",
  StyleBox["Sin", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.8", "8.16"}],

Cell[CellGroupData[{

Cell["ArcSin[Sin[4.5]]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.2.8"],

Cell[BoxData[
    \(\(-1.3584073464102064`\)\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.2.8"]
}, Open  ]],

Cell[TextData[{
  "Values of ",
  StyleBox["ArcSin[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " on opposite sides of the branch cut can be very different. "
}], "MathCaption",
  CellTags->{"S3.2.8", "8.17"}],

Cell[CellGroupData[{

Cell["{ArcSin[2 + 0.1 I], ArcSin[2 - 0.1 I]}", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.2.8"],

Cell[BoxData[
    \({\(\(1.5131571227434844`\)\(\[InvisibleSpace]\)\) + 
        1.3188765472109005`\ \[ImaginaryI], \(\(1.5131571227434844`\)\(\
\[InvisibleSpace]\)\) - 1.3188765472109005`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.2.8"]
}, Open  ]],

Cell[TextData[{
  "A three\[Hyphen]dimensional picture, showing the two branch cuts for the \
function ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(sin\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.8", "8.18"}],

Cell[CellGroupData[{

Cell["Plot3D[ Im[ArcSin[x + I y]], {x, -4, 4}, {y, -4, 4}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.2.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
6.22603e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -12 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -11.7989 -9 ]
[.17646 .18758 .20112 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.50253 .05935 -5.27396 -9 ]
[.50253 .05935 .72604 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02118 .28347 -12 -2.75782 ]
[.02118 .28347 0 6.24218 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00811 .4671 -6 -2.91391 ]
[-0.00811 .4671 0 6.08609 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-4)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-2)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(2)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(4)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.07346 .24092 m
.0763 .24365 L
s
.11029 .2265 m
.1131 .22926 L
s
.14766 .21187 m
.15043 .21466 L
s
.22407 .18195 m
.22677 .18482 L
s
.26314 .16665 m
.2658 .16956 L
s
.3028 .15112 m
.30541 .15406 L
s
.38395 .11935 m
.38647 .12237 L
s
.42547 .10309 m
.42794 .10615 L
s
.46763 .08658 m
.47006 .08968 L
s
.55397 .05277 m
.55629 .05595 L
s
.59817 .03546 m
.60044 .03868 L
s
.64309 .01787 m
.6453 .02113 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-4)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-2)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(2)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(4)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.71016 .03277 m
.70649 .03419 L
s
.73096 .06459 m
.72728 .06598 L
s
.75117 .0955 m
.74748 .09687 L
s
.78989 .15473 m
.78618 .15605 L
s
.80845 .18312 m
.80473 .18442 L
s
.8265 .21073 m
.82278 .21202 L
s
.86118 .26378 m
.85745 .26503 L
s
.87784 .28927 m
.87411 .2905 L
s
.89408 .3141 m
.89033 .31531 L
s
.92532 .36189 m
.92156 .36307 L
s
.94036 .3849 m
.9366 .38606 L
s
.95503 .40734 m
.95127 .40849 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03342 .27873 m
.03954 .27636 L
s
[(-2)] .02118 .28347 1 -0.38715 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.00426 .46273 m
.01045 .46055 L
s
[(2)] -0.00811 .4671 1 -0.35246 Mshowa
.125 Mabswid
.02996 .30059 m
.03363 .29919 L
s
.02644 .32277 m
.03012 .32137 L
s
.02288 .34526 m
.02656 .34388 L
s
.01559 .39123 m
.01929 .38988 L
s
.01187 .41472 m
.01557 .41338 L
s
.00809 .43855 m
.0118 .43722 L
s
.03684 .25717 m
.0405 .25573 L
s
.00037 .48728 m
.00409 .48599 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.681 .741 .896 r
.38455 .79289 .39806 .80578 .42073 .79803 .40735 .78487 Metetra
.68 .738 .894 r
.40735 .78487 .42073 .79803 .44358 .79024 .43031 .77679 Metetra
.68 .736 .893 r
.43031 .77679 .44358 .79024 .46659 .78244 .45345 .76869 Metetra
.679 .733 .891 r
.45345 .76869 .46659 .78244 .48978 .77465 .47675 .76059 Metetra
.678 .729 .889 r
.47675 .76059 .48978 .77465 .51314 .76688 .50024 .75251 Metetra
.676 .726 .888 r
.50024 .75251 .51314 .76688 .53668 .75918 .5239 .7445 Metetra
.673 .723 .887 r
.5239 .7445 .53668 .75918 .56041 .75157 .54774 .73658 Metetra
.67 .719 .886 r
.54774 .73658 .56041 .75157 .58433 .74409 .57178 .72881 Metetra
.667 .716 .885 r
.57178 .72881 .58433 .74409 .60844 .73676 .59601 .72122 Metetra
.663 .713 .885 r
.59601 .72122 .60844 .73676 .63276 .72962 .62045 .71385 Metetra
.659 .71 .885 r
.62045 .71385 .63276 .72962 .65729 .72268 .6451 .70673 Metetra
.654 .707 .886 r
.6451 .70673 .65729 .72268 .68205 .71597 .66997 .69987 Metetra
.649 .705 .887 r
.66997 .69987 .68205 .71597 .70704 .70948 .69509 .69329 Metetra
.645 .703 .889 r
.69509 .69329 .70704 .70948 .73226 .70321 .72044 .68697 Metetra
.64 .703 .891 r
.72044 .68697 .73226 .70321 .75774 .69716 .74605 .68092 Metetra
.636 .702 .894 r
.74605 .68092 .75774 .69716 .78347 .6913 .77193 .67509 Metetra
.632 .703 .897 r
.77193 .67509 .78347 .6913 .80947 .6856 .79807 .66945 Metetra
.629 .704 .9 r
.79807 .66945 .80947 .6856 .83573 .68004 .8245 .66396 Metetra
.626 .705 .903 r
.8245 .66396 .83573 .68004 .86227 .67458 .8512 .65859 Metetra
.624 .707 .906 r
.8512 .65859 .86227 .67458 .88909 .6692 .87819 .6533 Metetra
.622 .709 .908 r
.87819 .6533 .88909 .6692 .91619 .66385 .90547 .64803 Metetra
.621 .712 .911 r
.90547 .64803 .91619 .66385 .94358 .65852 .93304 .64278 Metetra
.62 .714 .913 r
.93304 .64278 .94358 .65852 .97125 .65318 .9609 .6375 Metetra
.619 .717 .916 r
.9609 .6375 .97125 .65318 .99922 .6478 .98906 .63218 Metetra
.683 .741 .895 r
.37085 .77982 .38455 .79289 .40735 .78487 .39377 .7715 Metetra
.683 .739 .893 r
.39377 .7715 .40735 .78487 .43031 .77679 .41686 .76312 Metetra
.683 .736 .891 r
.41686 .76312 .43031 .77679 .45345 .76869 .44012 .75469 Metetra
.682 .733 .889 r
.44012 .75469 .45345 .76869 .47675 .76059 .46355 .74624 Metetra
.681 .729 .887 r
.46355 .74624 .47675 .76059 .50024 .75251 .48715 .73781 Metetra
.679 .725 .885 r
.48715 .73781 .50024 .75251 .5239 .7445 .51093 .72944 Metetra
.676 .721 .883 r
.51093 .72944 .5239 .7445 .54774 .73658 .53489 .72118 Metetra
.673 .717 .882 r
.53489 .72118 .54774 .73658 .57178 .72881 .55905 .71307 Metetra
.669 .713 .881 r
.55905 .71307 .57178 .72881 .59601 .72122 .58339 .70518 Metetra
.665 .709 .881 r
.58339 .70518 .59601 .72122 .62045 .71385 .60795 .69755 Metetra
.66 .706 .881 r
.60795 .69755 .62045 .71385 .6451 .70673 .63272 .69021 Metetra
.655 .703 .882 r
.63272 .69021 .6451 .70673 .66997 .69987 .65771 .6832 Metetra
.649 .7 .884 r
.65771 .6832 .66997 .69987 .69509 .69329 .68295 .67653 Metetra
.644 .699 .886 r
.68295 .67653 .69509 .69329 .72044 .68697 .70844 .67019 Metetra
.638 .698 .889 r
.70844 .67019 .72044 .68697 .74605 .68092 .73418 .66415 Metetra
.634 .698 .892 r
.73418 .66415 .74605 .68092 .77193 .67509 .7602 .65838 Metetra
.629 .698 .895 r
.7602 .65838 .77193 .67509 .79807 .66945 .7865 .65284 Metetra
.626 .7 .898 r
.7865 .65284 .79807 .66945 .8245 .66396 .81308 .64747 Metetra
.623 .702 .902 r
.81308 .64747 .8245 .66396 .8512 .65859 .83995 .64223 Metetra
.62 .704 .905 r
.83995 .64223 .8512 .65859 .87819 .6533 .86711 .63705 Metetra
.619 .707 .908 r
.86711 .63705 .87819 .6533 .90547 .64803 .89457 .63191 Metetra
.617 .709 .911 r
.89457 .63191 .90547 .64803 .93304 .64278 .92232 .62676 Metetra
.616 .712 .914 r
.92232 .62676 .93304 .64278 .9609 .6375 .95038 .62156 Metetra
.616 .715 .916 r
.95038 .62156 .9609 .6375 .98906 .63218 .97874 .61631 Metetra
.686 .742 .894 r
.35694 .76658 .37085 .77982 .39377 .7715 .37999 .75795 Metetra
.686 .74 .892 r
.37999 .75795 .39377 .7715 .41686 .76312 .40321 .74923 Metetra
.686 .736 .889 r
.40321 .74923 .41686 .76312 .44012 .75469 .42659 .74044 Metetra
.686 .733 .887 r
.42659 .74044 .44012 .75469 .46355 .74624 .45015 .73161 Metetra
.684 .729 .884 r
.45015 .73161 .46355 .74624 .48715 .73781 .47387 .72278 Metetra
.682 .725 .882 r
.47387 .72278 .48715 .73781 .51093 .72944 .49778 .714 Metetra
.68 .72 .88 r
.49778 .714 .51093 .72944 .53489 .72118 .52186 .70533 Metetra
.676 .716 .878 r
.52186 .70533 .53489 .72118 .55905 .71307 .54613 .69683 Metetra
.672 .711 .877 r
.54613 .69683 .55905 .71307 .58339 .70518 .5706 .68859 Metetra
.667 .706 .877 r
.5706 .68859 .58339 .70518 .60795 .69755 .59527 .68065 Metetra
.661 .702 .877 r
.59527 .68065 .60795 .69755 .63272 .69021 .62015 .67307 Metetra
.655 .698 .878 r
.62015 .67307 .63272 .69021 .65771 .6832 .64527 .6659 Metetra
.649 .695 .88 r
.64527 .6659 .65771 .6832 .68295 .67653 .67062 .65914 Metetra
.642 .693 .882 r
.67062 .65914 .68295 .67653 .70844 .67019 .69624 .65279 Metetra
.636 .692 .885 r
.69624 .65279 .70844 .67019 .73418 .66415 .72212 .64681 Metetra
.631 .692 .889 r
.72212 .64681 .73418 .66415 .7602 .65838 .74828 .64115 Metetra
.626 .693 .893 r
.74828 .64115 .7602 .65838 .7865 .65284 .77473 .63576 Metetra
.622 .695 .897 r
.77473 .63576 .7865 .65284 .81308 .64747 .80147 .63056 Metetra
.618 .697 .901 r
.80147 .63056 .81308 .64747 .83995 .64223 .82851 .62548 Metetra
.616 .7 .905 r
.82851 .62548 .83995 .64223 .86711 .63705 .85585 .62048 Metetra
.614 .704 .908 r
.85585 .62048 .86711 .63705 .89457 .63191 .88349 .61548 Metetra
.613 .707 .911 r
.88349 .61548 .89457 .63191 .92232 .62676 .91143 .61046 Metetra
.613 .71 .914 r
.91143 .61046 .92232 .62676 .95038 .62156 .93969 .60537 Metetra
.613 .714 .917 r
.93969 .60537 .95038 .62156 .97874 .61631 .96825 .6002 Metetra
.689 .744 .893 r
.34283 .75318 .35694 .76658 .37999 .75795 .366 .74423 Metetra
.69 .741 .89 r
.366 .74423 .37999 .75795 .40321 .74923 .38935 .73514 Metetra
.69 .737 .887 r
.38935 .73514 .40321 .74923 .42659 .74044 .41287 .72596 Metetra
.69 .734 .884 r
.41287 .72596 .42659 .74044 .45015 .73161 .43655 .7167 Metetra
.689 .729 .881 r
.43655 .7167 .45015 .73161 .47387 .72278 .46041 .70742 Metetra
.687 .725 .879 r
.46041 .70742 .47387 .72278 .49778 .714 .48444 .69816 Metetra
.684 .719 .876 r
.48444 .69816 .49778 .714 .52186 .70533 .50865 .68901 Metetra
.68 .714 .874 r
.50865 .68901 .52186 .70533 .54613 .69683 .53304 .68005 Metetra
.675 .708 .872 r
.53304 .68005 .54613 .69683 .5706 .68859 .55762 .67138 Metetra
.669 .702 .872 r
.55762 .67138 .5706 .68859 .59527 .68065 .5824 .66308 Metetra
.663 .697 .872 r
.5824 .66308 .59527 .68065 .62015 .67307 .6074 .65523 Metetra
.655 .693 .873 r
.6074 .65523 .62015 .67307 .64527 .6659 .63263 .64787 Metetra
.648 .689 .875 r
.63263 .64787 .64527 .6659 .67062 .65914 .6581 .64103 Metetra
.64 .687 .878 r
.6581 .64103 .67062 .65914 .69624 .65279 .68384 .6347 Metetra
.633 .686 .882 r
.68384 .6347 .69624 .65279 .72212 .64681 .70986 .62883 Metetra
.626 .686 .886 r
.70986 .62883 .72212 .64681 .74828 .64115 .73616 .62334 Metetra
.621 .687 .891 r
.73616 .62334 .74828 .64115 .77473 .63576 .76277 .61817 Metetra
.617 .69 .895 r
.76277 .61817 .77473 .63576 .80147 .63056 .78967 .6132 Metetra
.613 .693 .9 r
.78967 .6132 .80147 .63056 .82851 .62548 .81688 .60837 Metetra
.611 .697 .905 r
.81688 .60837 .82851 .62548 .85585 .62048 .8444 .60358 Metetra
.61 .701 .909 r
.8444 .60358 .85585 .62048 .88349 .61548 .87223 .59877 Metetra
.609 .705 .912 r
.87223 .59877 .88349 .61548 .91143 .61046 .90037 .59391 Metetra
.609 .709 .915 r
.90037 .59391 .91143 .61046 .93969 .60537 .92882 .58895 Metetra
.609 .712 .918 r
.92882 .58895 .93969 .60537 .96825 .6002 .95759 .58387 Metetra
.692 .745 .892 r
.3285 .73966 .34283 .75318 .366 .74423 .35181 .73036 Metetra
.693 .742 .889 r
.35181 .73036 .366 .74423 .38935 .73514 .37529 .72089 Metetra
.694 .739 .886 r
.37529 .72089 .38935 .73514 .41287 .72596 .39894 .71127 Metetra
.694 .735 .882 r
.39894 .71127 .41287 .72596 .43655 .7167 .42276 .70154 Metetra
.693 .73 .879 r
.42276 .70154 .43655 .7167 .46041 .70742 .44675 .69173 Metetra
.692 .725 .875 r
.44675 .69173 .46041 .70742 .48444 .69816 .47091 .68192 Metetra
.689 .719 .872 r
.47091 .68192 .48444 .69816 .50865 .68901 .49525 .6722 Metetra
.685 .712 .869 r
.49525 .6722 .50865 .68901 .53304 .68005 .51976 .66268 Metetra
.68 .705 .867 r
.51976 .66268 .53304 .68005 .55762 .67138 .54445 .65348 Metetra
.673 .698 .866 r
.54445 .65348 .55762 .67138 .5824 .66308 .56935 .64475 Metetra
.665 .692 .866 r
.56935 .64475 .5824 .66308 .6074 .65523 .59446 .63656 Metetra
.656 .686 .867 r
.59446 .63656 .6074 .65523 .63263 .64787 .6198 .62901 Metetra
.647 .682 .869 r
.6198 .62901 .63263 .64787 .6581 .64103 .64539 .6221 Metetra
.637 .679 .873 r
.64539 .6221 .6581 .64103 .68384 .6347 .67125 .61583 Metetra
.629 .678 .877 r
.67125 .61583 .68384 .6347 .70986 .62883 .6974 .61014 Metetra
.621 .678 .883 r
.6974 .61014 .70986 .62883 .73616 .62334 .72385 .60492 Metetra
.615 .68 .888 r
.72385 .60492 .73616 .62334 .76277 .61817 .75061 .60005 Metetra
.61 .683 .894 r
.75061 .60005 .76277 .61817 .78967 .6132 .77768 .59541 Metetra
.607 .688 .9 r
.77768 .59541 .78967 .6132 .81688 .60837 .80507 .59088 Metetra
.605 .693 .905 r
.80507 .59088 .81688 .60837 .8444 .60358 .83277 .58637 Metetra
.604 .698 .909 r
.83277 .58637 .8444 .60358 .87223 .59877 .8608 .5818 Metetra
.604 .702 .913 r
.8608 .5818 .87223 .59877 .90037 .59391 .88913 .57713 Metetra
.604 .707 .917 r
.88913 .57713 .90037 .59391 .92882 .58895 .91779 .57232 Metetra
.605 .711 .92 r
.91779 .57232 .92882 .58895 .95759 .58387 .94676 .56735 Metetra
.696 .748 .891 r
.31394 .72604 .3285 .73966 .35181 .73036 .33739 .71638 Metetra
.697 .745 .888 r
.33739 .71638 .35181 .73036 .37529 .72089 .36101 .7065 Metetra
.698 .741 .884 r
.36101 .7065 .37529 .72089 .39894 .71127 .3848 .69642 Metetra
.699 .737 .88 r
.3848 .69642 .39894 .71127 .42276 .70154 .40877 .68616 Metetra
.699 .732 .876 r
.40877 .68616 .42276 .70154 .44675 .69173 .4329 .67576 Metetra
.698 .726 .871 r
.4329 .67576 .44675 .69173 .47091 .68192 .4572 .6653 Metetra
.695 .719 .867 r
.4572 .6653 .47091 .68192 .49525 .6722 .48166 .65488 Metetra
.691 .711 .863 r
.48166 .65488 .49525 .6722 .51976 .66268 .50629 .64466 Metetra
.685 .702 .86 r
.50629 .64466 .51976 .66268 .54445 .65348 .53111 .63482 Metetra
.677 .694 .859 r
.53111 .63482 .54445 .65348 .56935 .64475 .55611 .62553 Metetra
.667 .686 .859 r
.55611 .62553 .56935 .64475 .59446 .63656 .58133 .61695 Metetra
.656 .679 .86 r
.58133 .61695 .59446 .63656 .6198 .62901 .60678 .60916 Metetra
.645 .674 .863 r
.60678 .60916 .6198 .62901 .64539 .6221 .63248 .60221 Metetra
.634 .67 .867 r
.63248 .60221 .64539 .6221 .67125 .61583 .65846 .59607 Metetra
.623 .668 .873 r
.65846 .59607 .67125 .61583 .6974 .61014 .68474 .59065 Metetra
.614 .669 .879 r
.68474 .59065 .6974 .61014 .72385 .60492 .71134 .58581 Metetra
.607 .672 .886 r
.71134 .58581 .72385 .60492 .75061 .60005 .73826 .58139 Metetra
.602 .676 .893 r
.73826 .58139 .75061 .60005 .77768 .59541 .7655 .57719 Metetra
.599 .682 .9 r
.7655 .57719 .77768 .59541 .80507 .59088 .79307 .57307 Metetra
.597 .688 .906 r
.79307 .57307 .80507 .59088 .83277 .58637 .82096 .5689 Metetra
.597 .695 .911 r
.82096 .5689 .83277 .58637 .8608 .5818 .84918 .56462 Metetra
.598 .701 .915 r
.84918 .56462 .8608 .5818 .88913 .57713 .87772 .56016 Metetra
.599 .706 .919 r
.87772 .56016 .88913 .57713 .91779 .57232 .90658 .55551 Metetra
.601 .711 .922 r
.90658 .55551 .91779 .57232 .94676 .56735 .93576 .55066 Metetra
.699 .75 .891 r
.29915 .71235 .31394 .72604 .33739 .71638 .32274 .70233 Metetra
.701 .747 .887 r
.32274 .70233 .33739 .71638 .36101 .7065 .34651 .69203 Metetra
.703 .744 .883 r
.34651 .69203 .36101 .7065 .3848 .69642 .37045 .68146 Metetra
.705 .74 .878 r
.37045 .68146 .3848 .69642 .40877 .68616 .39456 .67063 Metetra
.706 .734 .873 r
.39456 .67063 .40877 .68616 .4329 .67576 .41884 .65956 Metetra
.705 .728 .868 r
.41884 .65956 .4329 .67576 .4572 .6653 .44328 .64832 Metetra
.703 .72 .862 r
.44328 .64832 .4572 .6653 .48166 .65488 .46788 .63705 Metetra
.699 .71 .857 r
.46788 .63705 .48166 .65488 .50629 .64466 .49265 .62594 Metetra
.692 .7 .853 r
.49265 .62594 .50629 .64466 .53111 .63482 .51758 .61526 Metetra
.682 .689 .85 r
.51758 .61526 .53111 .63482 .55611 .62553 .5427 .60527 Metetra
.67 .679 .85 r
.5427 .60527 .55611 .62553 .58133 .61695 .56801 .59619 Metetra
.657 .67 .851 r
.56801 .59619 .58133 .61695 .60678 .60916 .59356 .58814 Metetra
.643 .663 .855 r
.59356 .58814 .60678 .60916 .63248 .60221 .61937 .58116 Metetra
.629 .659 .86 r
.61937 .58116 .63248 .60221 .65846 .59607 .64547 .57523 Metetra
.616 .656 .867 r
.64547 .57523 .65846 .59607 .68474 .59065 .67188 .57024 Metetra
.605 .657 .875 r
.67188 .57024 .68474 .59065 .71134 .58581 .69862 .56598 Metetra
.596 .662 .884 r
.69862 .56598 .71134 .58581 .73826 .58139 .7257 .56218 Metetra
.591 .668 .893 r
.7257 .56218 .73826 .58139 .7655 .57719 .75312 .55858 Metetra
.589 .676 .901 r
.75312 .55858 .7655 .57719 .79307 .57307 .78088 .55497 Metetra
.589 .684 .907 r
.78088 .55497 .79307 .57307 .82096 .5689 .80897 .55123 Metetra
.59 .692 .913 r
.80897 .55123 .82096 .5689 .84918 .56462 .83738 .54727 Metetra
.591 .699 .918 r
.83738 .54727 .84918 .56462 .87772 .56016 .86613 .54305 Metetra
.594 .705 .921 r
.86613 .54305 .87772 .56016 .90658 .55551 .8952 .53858 Metetra
.596 .711 .924 r
.8952 .53858 .90658 .55551 .93576 .55066 .92459 .53384 Metetra
.702 .753 .891 r
.28412 .69864 .29915 .71235 .32274 .70233 .30786 .68826 Metetra
.705 .751 .887 r
.30786 .68826 .32274 .70233 .34651 .69203 .33178 .67754 Metetra
.708 .748 .883 r
.33178 .67754 .34651 .69203 .37045 .68146 .35587 .66647 Metetra
.711 .743 .877 r
.35587 .66647 .37045 .68146 .39456 .67063 .38014 .65503 Metetra
.713 .738 .871 r
.38014 .65503 .39456 .67063 .41884 .65956 .40457 .64322 Metetra
.714 .731 .864 r
.40457 .64322 .41884 .65956 .44328 .64832 .42917 .63108 Metetra
.713 .722 .857 r
.42917 .63108 .44328 .64832 .46788 .63705 .45392 .61874 Metetra
.709 .711 .85 r
.45392 .61874 .46788 .63705 .49265 .62594 .47882 .60647 Metetra
.7 .698 .844 r
.47882 .60647 .49265 .62594 .51758 .61526 .50388 .59466 Metetra
.688 .684 .84 r
.50388 .59466 .51758 .61526 .5427 .60527 .5291 .58374 Metetra
.673 .671 .839 r
.5291 .58374 .5427 .60527 .56801 .59619 .55452 .57404 Metetra
.657 .66 .841 r
.55452 .57404 .56801 .59619 .59356 .58814 .58016 .56569 Metetra
.64 .651 .845 r
.58016 .56569 .59356 .58814 .61937 .58116 .60607 .55872 Metetra
.623 .645 .851 r
.60607 .55872 .61937 .58116 .64547 .57523 .63227 .55312 Metetra
.606 .642 .86 r
.63227 .55312 .64547 .57523 .67188 .57024 .65881 .54876 Metetra
.591 .643 .87 r
.65881 .54876 .67188 .57024 .69862 .56598 .6857 .54535 Metetra
.582 .649 .882 r
.6857 .54535 .69862 .56598 .7257 .56218 .71295 .54245 Metetra
.577 .659 .893 r
.71295 .54245 .7257 .56218 .75312 .55858 .74056 .53965 Metetra
.576 .67 .903 r
.74056 .53965 .75312 .55858 .78088 .55497 .76851 .5367 Metetra
.578 .681 .911 r
.76851 .5367 .78088 .55497 .80897 .55123 .79679 .53344 Metetra
.581 .69 .917 r
.79679 .53344 .80897 .55123 .83738 .54727 .82541 .52984 Metetra
.584 .699 .921 r
.82541 .52984 .83738 .54727 .86613 .54305 .85436 .52587 Metetra
.588 .706 .924 r
.85436 .52587 .86613 .54305 .8952 .53858 .88364 .52156 Metetra
.591 .712 .927 r
.88364 .52156 .8952 .53858 .92459 .53384 .91325 .51692 Metetra
.705 .757 .892 r
.26883 .68495 .28412 .69864 .30786 .68826 .29272 .67423 Metetra
.709 .755 .888 r
.29272 .67423 .30786 .68826 .33178 .67754 .31679 .66311 Metetra
.713 .752 .883 r
.31679 .66311 .33178 .67754 .35587 .66647 .34105 .65156 Metetra
.717 .749 .877 r
.34105 .65156 .35587 .66647 .38014 .65503 .36548 .6395 Metetra
.721 .743 .87 r
.36548 .6395 .38014 .65503 .40457 .64322 .39008 .6269 Metetra
.724 .736 .861 r
.39008 .6269 .40457 .64322 .42917 .63108 .41485 .61373 Metetra
.725 .727 .852 r
.41485 .61373 .42917 .63108 .45392 .61874 .43977 .60006 Metetra
.722 .713 .842 r
.43977 .60006 .45392 .61874 .47882 .60647 .46482 .5862 Metetra
.713 .696 .833 r
.46482 .5862 .47882 .60647 .50388 .59466 .49001 .57279 Metetra
.696 .677 .828 r
.49001 .57279 .50388 .59466 .5291 .58374 .51534 .56063 Metetra
.676 .66 .827 r
.51534 .56063 .5291 .58374 .55452 .57404 .54085 .55019 Metetra
.656 .647 .829 r
.54085 .55019 .55452 .57404 .58016 .56569 .56658 .54151 Metetra
.636 .637 .833 r
.56658 .54151 .58016 .56569 .60607 .55872 .59257 .53455 Metetra
.615 .628 .841 r
.59257 .53455 .60607 .55872 .63227 .55312 .61887 .52938 Metetra
.592 .622 .851 r
.61887 .52938 .63227 .55312 .65881 .54876 .64553 .52598 Metetra
.572 .623 .865 r
.64553 .52598 .65881 .54876 .6857 .54535 .67258 .52389 Metetra
.56 .633 .88 r
.67258 .52389 .6857 .54535 .71295 .54245 .70001 .52231 Metetra
.558 .648 .895 r
.70001 .52231 .71295 .54245 .74056 .53965 .72781 .52059 Metetra
.56 .664 .907 r
.72781 .52059 .74056 .53965 .76851 .5367 .75596 .51841 Metetra
.565 .678 .915 r
.75596 .51841 .76851 .5367 .79679 .53344 .78444 .51569 Metetra
.571 .69 .921 r
.78444 .51569 .79679 .53344 .82541 .52984 .81327 .51243 Metetra
.577 .699 .926 r
.81327 .51243 .82541 .52984 .85436 .52587 .84242 .50869 Metetra
.582 .707 .929 r
.84242 .50869 .85436 .52587 .88364 .52156 .87191 .50452 Metetra
.587 .713 .931 r
.87191 .50452 .88364 .52156 .91325 .51692 .90174 .49995 Metetra
.708 .761 .894 r
.25328 .67132 .26883 .68495 .29272 .67423 .27732 .6603 Metetra
.712 .76 .89 r
.27732 .6603 .29272 .67423 .31679 .66311 .30155 .64883 Metetra
.717 .758 .884 r
.30155 .64883 .31679 .66311 .34105 .65156 .32597 .63683 Metetra
.723 .755 .878 r
.32597 .63683 .34105 .65156 .36548 .6395 .35057 .62421 Metetra
.729 .751 .87 r
.35057 .62421 .36548 .6395 .39008 .6269 .37535 .61084 Metetra
.735 .745 .86 r
.37535 .61084 .39008 .6269 .41485 .61373 .4003 .59657 Metetra
.74 .735 .847 r
.4003 .59657 .41485 .61373 .43977 .60006 .4254 .58131 Metetra
.741 .72 .832 r
.4254 .58131 .43977 .60006 .46482 .5862 .45065 .56518 Metetra
.731 .698 .819 r
.45065 .56518 .46482 .5862 .49001 .57279 .47599 .54924 Metetra
.706 .669 .812 r
.47599 .54924 .49001 .57279 .51534 .56063 .50144 .53537 Metetra
.677 .645 .811 r
.50144 .53537 .51534 .56063 .54085 .55019 .52703 .52422 Metetra
.654 .631 .815 r
.52703 .52422 .54085 .55019 .56658 .54151 .55282 .51528 Metetra
.633 .621 .82 r
.55282 .51528 .56658 .54151 .59257 .53455 .57888 .50826 Metetra
.608 .609 .827 r
.57888 .50826 .59257 .53455 .61887 .52938 .60526 .50347 Metetra
.572 .596 .838 r
.60526 .50347 .61887 .52938 .64553 .52598 .63203 .50148 Metetra
.539 .593 .857 r
.63203 .50148 .64553 .52598 .67258 .52389 .65925 .50165 Metetra
.527 .611 .88 r
.65925 .50165 .67258 .52389 .70001 .52231 .68688 .50207 Metetra
.531 .637 .9 r
.68688 .50207 .70001 .52231 .72781 .52059 .71489 .5017 Metetra
.541 .661 .914 r
.71489 .5017 .72781 .52059 .75596 .51841 .74324 .50035 Metetra
.552 .679 .923 r
.74324 .50035 .75596 .51841 .78444 .51569 .77193 .49813 Metetra
.561 .692 .928 r
.77193 .49813 .78444 .51569 .81327 .51243 .80095 .49517 Metetra
.569 .702 .931 r
.80095 .49517 .81327 .51243 .84242 .50869 .83031 .4916 Metetra
.576 .71 .933 r
.83031 .4916 .84242 .50869 .87191 .50452 .86001 .48751 Metetra
.582 .716 .935 r
.86001 .48751 .87191 .50452 .90174 .49995 .89005 .48297 Metetra
.71 .766 .896 r
.23744 .65777 .25328 .67132 .27732 .6603 .26164 .64651 Metetra
.715 .765 .892 r
.26164 .64651 .27732 .6603 .30155 .64883 .28603 .63475 Metetra
.721 .764 .887 r
.28603 .63475 .30155 .64883 .32597 .63683 .31061 .62241 Metetra
.727 .763 .881 r
.31061 .62241 .32597 .63683 .35057 .62421 .33538 .60934 Metetra
.735 .76 .873 r
.33538 .60934 .35057 .62421 .37535 .61084 .36034 .59535 Metetra
.745 .756 .862 r
.36034 .59535 .37535 .61084 .4003 .59657 .38549 .58013 Metetra
.756 .749 .846 r
.38549 .58013 .4003 .59657 .4254 .58131 .41081 .56322 Metetra
.768 .736 .823 r
.41081 .56322 .4254 .58131 .45065 .56518 .43629 .54391 Metetra
.765 .708 .798 r
.43629 .54391 .45065 .56518 .47599 .54924 .46186 .52295 Metetra
.714 .654 .789 r
.46186 .52295 .47599 .54924 .50144 .53537 .48741 .50681 Metetra
.667 .62 .793 r
.48741 .50681 .50144 .53537 .52703 .52422 .51307 .49578 Metetra
.648 .613 .8 r
.51307 .49578 .52703 .52422 .55282 .51528 .53892 .48691 Metetra
.634 .607 .806 r
.53892 .48691 .55282 .51528 .57888 .50826 .56503 .47948 Metetra
.61 .594 .81 r
.56503 .47948 .57888 .50826 .60526 .50347 .59144 .47423 Metetra
.549 .56 .818 r
.59144 .47423 .60526 .50347 .63203 .50148 .6183 .47418 Metetra
.471 .534 .84 r
.6183 .47418 .63203 .50148 .65925 .50165 .64575 .47912 Metetra
.471 .582 .884 r
.64575 .47912 .65925 .50165 .68688 .50207 .67361 .48248 Metetra
.497 .632 .913 r
.67361 .48248 .68688 .50207 .71489 .5017 .70181 .4835 Metetra
.52 .664 .926 r
.70181 .4835 .71489 .5017 .74324 .50035 .73036 .48283 Metetra
.538 .684 .933 r
.73036 .48283 .74324 .50035 .77193 .49813 .75924 .48096 Metetra
.552 .697 .936 r
.75924 .48096 .77193 .49813 .80095 .49517 .78846 .47818 Metetra
.563 .707 .938 r
.78846 .47818 .80095 .49517 .83031 .4916 .81803 .47468 Metetra
.571 .714 .939 r
.81803 .47468 .83031 .4916 .86001 .48751 .84793 .4706 Metetra
.579 .72 .939 r
.84793 .4706 .86001 .48751 .89005 .48297 .87819 .46601 Metetra
.711 .771 .899 r
.22131 .64435 .23744 .65777 .26164 .64651 .24566 .63291 Metetra
.716 .771 .895 r
.24566 .63291 .26164 .64651 .28603 .63475 .27021 .62096 Metetra
.723 .771 .891 r
.27021 .62096 .28603 .63475 .31061 .62241 .29495 .60839 Metetra
.73 .772 .886 r
.29495 .60839 .31061 .62241 .33538 .60934 .3199 .59505 Metetra
.74 .771 .879 r
.3199 .59505 .33538 .60934 .36034 .59535 .34504 .58073 Metetra
.752 .771 .868 r
.34504 .58073 .36034 .59535 .38549 .58013 .37037 .56502 Metetra
.769 .769 .853 r
.37037 .56502 .38549 .58013 .41081 .56322 .3959 .54721 Metetra
.793 .764 .826 r
.3959 .54721 .41081 .56322 .43629 .54391 .42164 .52547 Metetra
.867 .745 .726 r
.42164 .52547 .43629 .54391 .46186 .52295 .44792 .48157 Metetra
.622 .536 .736 r
.44792 .48157 .46186 .52295 .48741 .50681 .47334 .47343 Metetra
.633 .577 .773 r
.47334 .47343 .48741 .50681 .51307 .49578 .49899 .46522 Metetra
.638 .596 .791 r
.49899 .46522 .51307 .49578 .53892 .48691 .52489 .45693 Metetra
.639 .601 .795 r
.52489 .45693 .53892 .48691 .56503 .47948 .55103 .44856 Metetra
.638 .596 .791 r
.55103 .44856 .56503 .47948 .59144 .47423 .57742 .44011 Metetra
.633 .577 .773 r
.57742 .44011 .59144 .47423 .6183 .47418 .60407 .43158 Metetra
.215 .282 .717 r
.60407 .43158 .6183 .47418 .64575 .47912 .63216 .45945 Metetra
.392 .577 .913 r
.63216 .45945 .64575 .47912 .67361 .48248 .66022 .465 Metetra
.46 .646 .938 r
.66022 .465 .67361 .48248 .70181 .4835 .6886 .46663 Metetra
.501 .677 .944 r
.6886 .46663 .70181 .4835 .73036 .48283 .71732 .46617 Metetra
.527 .695 .946 r
.71732 .46617 .73036 .48283 .75924 .48096 .74639 .46435 Metetra
.545 .706 .946 r
.74639 .46435 .75924 .48096 .78846 .47818 .7758 .46155 Metetra
.558 .714 .945 r
.7758 .46155 .78846 .47818 .81803 .47468 .80556 .45798 Metetra
.568 .72 .945 r
.80556 .45798 .81803 .47468 .84793 .4706 .83567 .4538 Metetra
.576 .725 .944 r
.83567 .4538 .84793 .4706 .87819 .46601 .86613 .44911 Metetra
.555 .365 .578 r
.22173 .44913 .22131 .64435 .24566 .63291 .24435 .44506 Metetra
.555 .366 .58 r
.24435 .44506 .24566 .63291 .27021 .62096 .26719 .44132 Metetra
.555 .368 .582 r
.26719 .44132 .27021 .62096 .29495 .60839 .29027 .43801 Metetra
.554 .369 .585 r
.29027 .43801 .29495 .60839 .3199 .59505 .31357 .43526 Metetra
.553 .371 .589 r
.31357 .43526 .3199 .59505 .34504 .58073 .33712 .43326 Metetra
.551 .373 .594 r
.33712 .43326 .34504 .58073 .37037 .56502 .36091 .4323 Metetra
.547 .376 .6 r
.36091 .4323 .37037 .56502 .3959 .54721 .38497 .43288 Metetra
.54 .379 .612 r
.38497 .43288 .3959 .54721 .42164 .52547 .4093 .4357 Metetra
.531 .39 .634 r
.4093 .4357 .42164 .52547 .44792 .48157 .43397 .44014 Metetra
.554 .496 .745 r
.43397 .44014 .44792 .48157 .47334 .47343 .45918 .43985 Metetra
.606 .563 .779 r
.45918 .43985 .47334 .47343 .49899 .46522 .4848 .43441 Metetra
.631 .592 .792 r
.4848 .43441 .49899 .46522 .52489 .45693 .51073 .42669 Metetra
.646 .605 .793 r
.51073 .42669 .52489 .45693 .55103 .44856 .53692 .41739 Metetra
.664 .609 .783 r
.53692 .41739 .55103 .44856 .57742 .44011 .56331 .40578 Metetra
.694 .608 .756 r
.56331 .40578 .57742 .44011 .60407 .43158 .58981 .38893 Metetra
.7 .58 .717 r
.58981 .38893 .60407 .43158 .63216 .45945 .61629 .36719 Metetra
.624 .455 .632 r
.61629 .36719 .63216 .45945 .66022 .465 .64287 .347 Metetra
.603 .424 .613 r
.64287 .347 .66022 .465 .6886 .46663 .66962 .32901 Metetra
.591 .408 .602 r
.66962 .32901 .6886 .46663 .71732 .46617 .69656 .31251 Metetra
.584 .397 .595 r
.69656 .31251 .71732 .46617 .74639 .46435 .72371 .29702 Metetra
.579 .39 .59 r
.72371 .29702 .74639 .46435 .7758 .46155 .75107 .28225 Metetra
.576 .385 .586 r
.75107 .28225 .7758 .46155 .80556 .45798 .77866 .268 Metetra
.573 .381 .583 r
.77866 .268 .80556 .45798 .83567 .4538 .80647 .25414 Metetra
.571 .378 .581 r
.80647 .25414 .83567 .4538 .86613 .44911 .83452 .24058 Metetra
.594 .716 .929 r
.2061 .43419 .22173 .44913 .24435 .44506 .22882 .42991 Metetra
.586 .712 .93 r
.22882 .42991 .24435 .44506 .26719 .44132 .25177 .42592 Metetra
.578 .707 .931 r
.25177 .42592 .26719 .44132 .29027 .43801 .27495 .4223 Metetra
.567 .701 .931 r
.27495 .4223 .29027 .43801 .31357 .43526 .29837 .41915 Metetra
.554 .692 .931 r
.29837 .41915 .31357 .43526 .33712 .43326 .32204 .41659 Metetra
.538 .679 .929 r
.32204 .41659 .33712 .43326 .36091 .4323 .34596 .41477 Metetra
.522 .662 .924 r
.34596 .41477 .36091 .4323 .38497 .43288 .37016 .41381 Metetra
.513 .639 .911 r
.37016 .41381 .38497 .43288 .4093 .4357 .39467 .41359 Metetra
.531 .613 .88 r
.39467 .41359 .4093 .4357 .43397 .44014 .41953 .41312 Metetra
.573 .589 .831 r
.41953 .41312 .43397 .44014 .45918 .43985 .44481 .41056 Metetra
.607 .591 .809 r
.44481 .41056 .45918 .43985 .4848 .43441 .47047 .4052 Metetra
.631 .605 .805 r
.47047 .4052 .4848 .43441 .51073 .42669 .49645 .39753 Metetra
.651 .616 .801 r
.49645 .39753 .51073 .42669 .53692 .41739 .52269 .38782 Metetra
.67 .623 .794 r
.52269 .38782 .53692 .41739 .56331 .40578 .54915 .37577 Metetra
.692 .632 .784 r
.54915 .37577 .56331 .40578 .58981 .38893 .57577 .36086 Metetra
.714 .655 .79 r
.57577 .36086 .58981 .38893 .61629 .36719 .6025 .34376 Metetra
.733 .699 .818 r
.6025 .34376 .61629 .36719 .64287 .347 .62933 .32634 Metetra
.738 .728 .842 r
.62933 .32634 .64287 .347 .66962 .32901 .65633 .30961 Metetra
.735 .742 .857 r
.65633 .30961 .66962 .32901 .69656 .31251 .6835 .29369 Metetra
.729 .749 .868 r
.6835 .29369 .69656 .31251 .72371 .29702 .71086 .27846 Metetra
.724 .752 .875 r
.71086 .27846 .72371 .29702 .75107 .28225 .73844 .26379 Metetra
.719 .754 .88 r
.73844 .26379 .75107 .28225 .77866 .268 .76624 .24955 Metetra
.715 .755 .884 r
.76624 .24955 .77866 .268 .80647 .25414 .79427 .23564 Metetra
.711 .755 .887 r
.79427 .23564 .80647 .25414 .83452 .24058 .82253 .22199 Metetra
.598 .713 .925 r
.19024 .41873 .2061 .43419 .22882 .42991 .21307 .41417 Metetra
.592 .709 .925 r
.21307 .41417 .22882 .42991 .25177 .42592 .23613 .40985 Metetra
.585 .704 .925 r
.23613 .40985 .25177 .42592 .27495 .4223 .25943 .40584 Metetra
.578 .698 .924 r
.25943 .40584 .27495 .4223 .29837 .41915 .28297 .40217 Metetra
.57 .689 .921 r
.28297 .40217 .29837 .41915 .32204 .41659 .30677 .39889 Metetra
.562 .678 .917 r
.30677 .39889 .32204 .41659 .34596 .41477 .33083 .39605 Metetra
.557 .665 .909 r
.33083 .39605 .34596 .41477 .37016 .41381 .35518 .39357 Metetra
.559 .649 .895 r
.35518 .39357 .37016 .41381 .39467 .41359 .37985 .39117 Metetra
.572 .632 .873 r
.37985 .39117 .39467 .41359 .41953 .41312 .40486 .38823 Metetra
.593 .619 .847 r
.40486 .38823 .41953 .41312 .44481 .41056 .43023 .38396 Metetra
.615 .617 .829 r
.43023 .38396 .44481 .41056 .47047 .4052 .45596 .37788 Metetra
.635 .622 .82 r
.45596 .37788 .47047 .4052 .49645 .39753 .482 .36993 Metetra
.653 .63 .814 r
.482 .36993 .49645 .39753 .52269 .38782 .50832 .36014 Metetra
.671 .638 .809 r
.50832 .36014 .52269 .38782 .54915 .37577 .53487 .34846 Metetra
.688 .65 .807 r
.53487 .34846 .54915 .37577 .57577 .36086 .56161 .33492 Metetra
.704 .668 .812 r
.56161 .33492 .57577 .36086 .6025 .34376 .58851 .31999 Metetra
.716 .692 .826 r
.58851 .31999 .6025 .34376 .62933 .32634 .61556 .30446 Metetra
.722 .713 .842 r
.61556 .30446 .62933 .32634 .65633 .30961 .64278 .28895 Metetra
.723 .728 .854 r
.64278 .28895 .65633 .30961 .6835 .29369 .67017 .27375 Metetra
.721 .737 .864 r
.67017 .27375 .6835 .29369 .71086 .27846 .69776 .25894 Metetra
.718 .742 .871 r
.69776 .25894 .71086 .27846 .73844 .26379 .72555 .24449 Metetra
.714 .746 .877 r
.72555 .24449 .73844 .26379 .76624 .24955 .75357 .23034 Metetra
.711 .748 .881 r
.75357 .23034 .76624 .24955 .79427 .23564 .78182 .21645 Metetra
.708 .749 .884 r
.78182 .21645 .79427 .23564 .82253 .22199 .8103 .20276 Metetra
.602 .711 .921 r
.17415 .40275 .19024 .41873 .21307 .41417 .1971 .39788 Metetra
.598 .707 .92 r
.1971 .39788 .21307 .41417 .23613 .40985 .22028 .39319 Metetra
.593 .702 .919 r
.22028 .39319 .23613 .40985 .25943 .40584 .2437 .38871 Metetra
.588 .696 .917 r
.2437 .38871 .25943 .40584 .28297 .40217 .26737 .38446 Metetra
.584 .689 .914 r
.26737 .38446 .28297 .40217 .30677 .39889 .2913 .38044 Metetra
.58 .679 .908 r
.2913 .38044 .30677 .39889 .33083 .39605 .3155 .37661 Metetra
.58 .669 .9 r
.3155 .37661 .33083 .39605 .35518 .39357 .34 .37285 Metetra
.584 .657 .888 r
.34 .37285 .35518 .39357 .37985 .39117 .36481 .36891 Metetra
.594 .647 .872 r
.36481 .36891 .37985 .39117 .40486 .38823 .38995 .3644 Metetra
.608 .639 .856 r
.38995 .3644 .40486 .38823 .43023 .38396 .41543 .35889 Metetra
.624 .636 .842 r
.41543 .35889 .43023 .38396 .45596 .37788 .44125 .35205 Metetra
.64 .638 .833 r
.44125 .35205 .45596 .37788 .482 .36993 .46737 .34376 Metetra
.655 .644 .827 r
.46737 .34376 .482 .36993 .50832 .36014 .49377 .33396 Metetra
.669 .651 .823 r
.49377 .33396 .50832 .36014 .53487 .34846 .52042 .32268 Metetra
.683 .662 .823 r
.52042 .32268 .53487 .34846 .56161 .33492 .54729 .31005 Metetra
.695 .676 .827 r
.54729 .31005 .56161 .33492 .58851 .31999 .57435 .29636 Metetra
.704 .692 .835 r
.57435 .29636 .58851 .31999 .61556 .30446 .60158 .28206 Metetra
.71 .707 .845 r
.60158 .28206 .61556 .30446 .64278 .28895 .62899 .26752 Metetra
.713 .719 .855 r
.62899 .26752 .64278 .28895 .67017 .27375 .6566 .253 Metetra
.713 .729 .863 r
.6566 .253 .67017 .27375 .69776 .25894 .6844 .23862 Metetra
.711 .735 .869 r
.6844 .23862 .69776 .25894 .72555 .24449 .71241 .22443 Metetra
.709 .739 .875 r
.71241 .22443 .72555 .24449 .75357 .23034 .74065 .21043 Metetra
.707 .742 .879 r
.74065 .21043 .75357 .23034 .78182 .21645 .76912 .1966 Metetra
.705 .745 .882 r
.76912 .1966 .78182 .21645 .8103 .20276 .79782 .18292 Metetra
.607 .71 .917 r
.15783 .3863 .17415 .40275 .1971 .39788 .18089 .38108 Metetra
.604 .706 .916 r
.18089 .38108 .1971 .39788 .22028 .39319 .20419 .37599 Metetra
.601 .701 .914 r
.20419 .37599 .22028 .39319 .2437 .38871 .22774 .37103 Metetra
.598 .696 .912 r
.22774 .37103 .2437 .38871 .26737 .38446 .25154 .36619 Metetra
.595 .689 .908 r
.25154 .36619 .26737 .38446 .2913 .38044 .2756 .36145 Metetra
.595 .682 .902 r
.2756 .36145 .2913 .38044 .3155 .37661 .29995 .35675 Metetra
.596 .674 .894 r
.29995 .35675 .3155 .37661 .34 .37285 .32459 .35195 Metetra
.601 .665 .885 r
.32459 .35195 .34 .37285 .36481 .36891 .34954 .34687 Metetra
.609 .658 .873 r
.34954 .34687 .36481 .36891 .38995 .3644 .37481 .34124 Metetra
.619 .653 .861 r
.37481 .34124 .38995 .3644 .41543 .35889 .4004 .33479 Metetra
.631 .651 .851 r
.4004 .33479 .41543 .35889 .44125 .35205 .42632 .32732 Metetra
.644 .652 .843 r
.42632 .32732 .44125 .35205 .46737 .34376 .45254 .3187 Metetra
.656 .656 .838 r
.45254 .3187 .46737 .34376 .49377 .33396 .47904 .30887 Metetra
.668 .662 .835 r
.47904 .30887 .49377 .33396 .52042 .32268 .50579 .29788 Metetra
.679 .671 .835 r
.50579 .29788 .52042 .32268 .54729 .31005 .53278 .28583 Metetra
.689 .682 .838 r
.53278 .28583 .54729 .31005 .57435 .29636 .55998 .27292 Metetra
.696 .693 .843 r
.55998 .27292 .57435 .29636 .60158 .28206 .58739 .25943 Metetra
.701 .705 .85 r
.58739 .25943 .60158 .28206 .62899 .26752 .61499 .2456 Metetra
.704 .715 .857 r
.61499 .2456 .62899 .26752 .6566 .253 .64279 .23164 Metetra
.706 .723 .864 r
.64279 .23164 .6566 .253 .6844 .23862 .6708 .21766 Metetra
.706 .729 .869 r
.6708 .21766 .6844 .23862 .71241 .22443 .69903 .20374 Metetra
.705 .734 .874 r
.69903 .20374 .71241 .22443 .74065 .21043 .72748 .1899 Metetra
.703 .738 .878 r
.72748 .1899 .74065 .21043 .76912 .1966 .75617 .17615 Metetra
.702 .74 .881 r
.75617 .17615 .76912 .1966 .79782 .18292 .7851 .16249 Metetra
.612 .709 .914 r
.14127 .36942 .15783 .3863 .18089 .38108 .16445 .36383 Metetra
.609 .705 .912 r
.16445 .36383 .18089 .38108 .20419 .37599 .18787 .35832 Metetra
.607 .701 .91 r
.18787 .35832 .20419 .37599 .22774 .37103 .21154 .35288 Metetra
.606 .696 .907 r
.21154 .35288 .22774 .37103 .25154 .36619 .23548 .34748 Metetra
.605 .691 .903 r
.23548 .34748 .25154 .36619 .2756 .36145 .25968 .34208 Metetra
.606 .685 .898 r
.25968 .34208 .2756 .36145 .29995 .35675 .28416 .33661 Metetra
.608 .679 .891 r
.28416 .33661 .29995 .35675 .32459 .35195 .30894 .33097 Metetra
.612 .672 .883 r
.30894 .33097 .32459 .35195 .34954 .34687 .33402 .32499 Metetra
.619 .667 .875 r
.33402 .32499 .34954 .34687 .37481 .34124 .35942 .31852 Metetra
.627 .664 .866 r
.35942 .31852 .37481 .34124 .4004 .33479 .38513 .31135 Metetra
.637 .662 .858 r
.38513 .31135 .4004 .33479 .42632 .32732 .41115 .30336 Metetra
.647 .663 .852 r
.41115 .30336 .42632 .32732 .45254 .3187 .43748 .29443 Metetra
.657 .666 .848 r
.43748 .29443 .45254 .3187 .47904 .30887 .46408 .28455 Metetra
.667 .672 .845 r
.46408 .28455 .47904 .30887 .50579 .29788 .49095 .27372 Metetra
.676 .678 .845 r
.49095 .27372 .50579 .29788 .53278 .28583 .51807 .26203 Metetra
.684 .687 .847 r
.51807 .26203 .53278 .28583 .55998 .27292 .54542 .24963 Metetra
.69 .696 .85 r
.54542 .24963 .55998 .27292 .58739 .25943 .57298 .23668 Metetra
.695 .705 .855 r
.57298 .23668 .58739 .25943 .61499 .2456 .60076 .22337 Metetra
.698 .713 .86 r
.60076 .22337 .61499 .2456 .64279 .23164 .62876 .20983 Metetra
.7 .72 .865 r
.62876 .20983 .64279 .23164 .6708 .21766 .65697 .19618 Metetra
.7 .726 .87 r
.65697 .19618 .6708 .21766 .69903 .20374 .6854 .1825 Metetra
.7 .73 .874 r
.6854 .1825 .69903 .20374 .72748 .1899 .71407 .16881 Metetra
.7 .734 .877 r
.71407 .16881 .72748 .1899 .75617 .17615 .74298 .15514 Metetra
.699 .737 .881 r
.74298 .15514 .75617 .17615 .7851 .16249 .77213 .14151 Metetra
.616 .709 .911 r
.12446 .35212 .14127 .36942 .16445 .36383 .14776 .34617 Metetra
.615 .705 .909 r
.14776 .34617 .16445 .36383 .18787 .35832 .1713 .34024 Metetra
.613 .702 .907 r
.1713 .34024 .18787 .35832 .21154 .35288 .19511 .33433 Metetra
.613 .697 .904 r
.19511 .33433 .21154 .35288 .23548 .34748 .21917 .3284 Metetra
.613 .693 .9 r
.21917 .3284 .23548 .34748 .25968 .34208 .24351 .3224 Metetra
.614 .688 .896 r
.24351 .3224 .25968 .34208 .28416 .33661 .26813 .31627 Metetra
.617 .683 .89 r
.26813 .31627 .28416 .33661 .30894 .33097 .29304 .30992 Metetra
.621 .679 .883 r
.29304 .30992 .30894 .33097 .33402 .32499 .31826 .30324 Metetra
.626 .675 .877 r
.31826 .30324 .33402 .32499 .35942 .31852 .34378 .29609 Metetra
.633 .672 .87 r
.34378 .29609 .35942 .31852 .38513 .31135 .36961 .28835 Metetra
.641 .672 .864 r
.36961 .28835 .38513 .31135 .41115 .30336 .39575 .27992 Metetra
.649 .672 .859 r
.39575 .27992 .41115 .30336 .43748 .29443 .42219 .27072 Metetra
.657 .675 .855 r
.42219 .27072 .43748 .29443 .46408 .28455 .44891 .26074 Metetra
.665 .679 .853 r
.44891 .26074 .46408 .28455 .49095 .27372 .4759 .24998 Metetra
.673 .684 .853 r
.4759 .24998 .49095 .27372 .51807 .26203 .50314 .23851 Metetra
.68 .691 .854 r
.50314 .23851 .51807 .26203 .54542 .24963 .53063 .22642 Metetra
.685 .698 .856 r
.53063 .22642 .54542 .24963 .57298 .23668 .55836 .21384 Metetra
.69 .705 .859 r
.55836 .21384 .57298 .23668 .60076 .22337 .58631 .20088 Metetra
.693 .712 .863 r
.58631 .20088 .60076 .22337 .62876 .20983 .61449 .18766 Metetra
.695 .718 .867 r
.61449 .18766 .62876 .20983 .65697 .19618 .6429 .17427 Metetra
.696 .723 .871 r
.6429 .17427 .65697 .19618 .6854 .1825 .67154 .16077 Metetra
.696 .728 .874 r
.67154 .16077 .6854 .1825 .71407 .16881 .70042 .14721 Metetra
.696 .731 .878 r
.70042 .14721 .71407 .16881 .74298 .15514 .72954 .13362 Metetra
.696 .734 .88 r
.72954 .13362 .74298 .15514 .77213 .14151 .75892 .12 Metetra
.62 .709 .909 r
.10739 .33444 .12446 .35212 .14776 .34617 .13081 .32813 Metetra
.619 .706 .907 r
.13081 .32813 .14776 .34617 .1713 .34024 .15448 .3218 Metetra
.619 .702 .905 r
.15448 .3218 .1713 .34024 .19511 .33433 .17841 .31544 Metetra
.619 .699 .902 r
.17841 .31544 .19511 .33433 .21917 .3284 .20261 .30901 Metetra
.619 .695 .898 r
.20261 .30901 .21917 .3284 .24351 .3224 .22708 .30248 Metetra
.621 .691 .894 r
.22708 .30248 .24351 .3224 .26813 .31627 .25183 .29577 Metetra
.624 .687 .889 r
.25183 .29577 .26813 .31627 .29304 .30992 .27688 .28883 Metetra
.627 .684 .884 r
.27688 .28883 .29304 .30992 .31826 .30324 .30223 .28155 Metetra
.632 .681 .878 r
.30223 .28155 .31826 .30324 .34378 .29609 .32788 .27385 Metetra
.638 .68 .873 r
.32788 .27385 .34378 .29609 .36961 .28835 .35384 .26563 Metetra
.644 .679 .868 r
.35384 .26563 .36961 .28835 .39575 .27992 .38009 .25682 Metetra
.651 .68 .864 r
.38009 .25682 .39575 .27992 .42219 .27072 .40665 .24738 Metetra
.658 .682 .861 r
.40665 .24738 .42219 .27072 .44891 .26074 .43349 .23727 Metetra
.665 .685 .859 r
.43349 .23727 .44891 .26074 .4759 .24998 .46061 .22652 Metetra
.671 .69 .859 r
.46061 .22652 .4759 .24998 .50314 .23851 .48799 .21516 Metetra
.677 .695 .86 r
.48799 .21516 .50314 .23851 .53063 .22642 .51562 .20326 Metetra
.681 .7 .861 r
.51562 .20326 .53063 .22642 .55836 .21384 .5435 .1909 Metetra
.685 .706 .863 r
.5435 .1909 .55836 .21384 .58631 .20088 .57162 .17818 Metetra
.688 .712 .866 r
.57162 .17818 .58631 .20088 .61449 .18766 .59998 .16518 Metetra
.69 .717 .869 r
.59998 .16518 .61449 .18766 .6429 .17427 .62858 .15197 Metetra
.692 .722 .872 r
.62858 .15197 .6429 .17427 .67154 .16077 .65743 .13862 Metetra
.693 .726 .875 r
.65743 .13862 .67154 .16077 .70042 .14721 .68652 .12515 Metetra
.693 .729 .878 r
.68652 .12515 .70042 .14721 .72954 .13362 .71586 .11161 Metetra
.693 .732 .881 r
.71586 .11161 .72954 .13362 .75892 .12 .74546 .098 Metetra
.624 .709 .907 r
.09005 .31641 .10739 .33444 .13081 .32813 .11359 .30974 Metetra
.624 .706 .905 r
.11359 .30974 .13081 .32813 .15448 .3218 .13739 .30302 Metetra
.623 .704 .903 r
.13739 .30302 .15448 .3218 .17841 .31544 .16145 .29623 Metetra
.624 .7 .9 r
.16145 .29623 .17841 .31544 .20261 .30901 .18578 .28935 Metetra
.625 .697 .897 r
.18578 .28935 .20261 .30901 .22708 .30248 .21038 .28233 Metetra
.627 .694 .893 r
.21038 .28233 .22708 .30248 .25183 .29577 .23527 .27512 Metetra
.629 .691 .889 r
.23527 .27512 .25183 .29577 .27688 .28883 .26045 .26766 Metetra
.632 .689 .885 r
.26045 .26766 .27688 .28883 .30223 .28155 .28593 .25987 Metetra
.637 .687 .88 r
.28593 .25987 .30223 .28155 .32788 .27385 .31171 .2517 Metetra
.641 .685 .876 r
.31171 .2517 .32788 .27385 .35384 .26563 .33779 .24308 Metetra
.647 .685 .872 r
.33779 .24308 .35384 .26563 .38009 .25682 .36418 .23394 Metetra
.653 .686 .869 r
.36418 .23394 .38009 .25682 .40665 .24738 .39086 .22426 Metetra
.658 .688 .866 r
.39086 .22426 .40665 .24738 .43349 .23727 .41782 .21401 Metetra
.664 .69 .865 r
.41782 .21401 .43349 .23727 .46061 .22652 .44507 .2032 Metetra
.669 .694 .864 r
.44507 .2032 .46061 .22652 .48799 .21516 .47259 .19188 Metetra
.674 .698 .864 r
.47259 .19188 .48799 .21516 .51562 .20326 .50037 .18007 Metetra
.678 .703 .865 r
.50037 .18007 .51562 .20326 .5435 .1909 .52841 .16785 Metetra
.682 .707 .867 r
.52841 .16785 .5435 .1909 .57162 .17818 .5567 .15528 Metetra
.685 .712 .869 r
.5567 .15528 .57162 .17818 .59998 .16518 .58524 .14242 Metetra
.687 .717 .872 r
.58524 .14242 .59998 .16518 .62858 .15197 .61403 .12933 Metetra
.688 .721 .874 r
.61403 .12933 .62858 .15197 .65743 .13862 .64307 .11606 Metetra
.689 .724 .876 r
.64307 .11606 .65743 .13862 .68652 .12515 .67236 .10266 Metetra
.69 .727 .879 r
.67236 .10266 .68652 .12515 .71586 .11161 .70192 .08914 Metetra
.69 .73 .881 r
.70192 .08914 .71586 .11161 .74546 .098 .73175 .07553 Metetra
.627 .71 .905 r
.07243 .29804 .09005 .31641 .11359 .30974 .0961 .29102 Metetra
.627 .707 .903 r
.0961 .29102 .11359 .30974 .13739 .30302 .12002 .28393 Metetra
.628 .705 .901 r
.12002 .28393 .13739 .30302 .16145 .29623 .14421 .27674 Metetra
.628 .702 .899 r
.14421 .27674 .16145 .29623 .18578 .28935 .16867 .26944 Metetra
.629 .7 .896 r
.16867 .26944 .18578 .28935 .21038 .28233 .19341 .26197 Metetra
.631 .697 .893 r
.19341 .26197 .21038 .28233 .23527 .27512 .21843 .25431 Metetra
.633 .695 .889 r
.21843 .25431 .23527 .27512 .26045 .26766 .24375 .24639 Metetra
.637 .693 .885 r
.24375 .24639 .26045 .26766 .28593 .25987 .26936 .23817 Metetra
.64 .691 .882 r
.26936 .23817 .28593 .25987 .31171 .2517 .29527 .22959 Metetra
.644 .69 .878 r
.29527 .22959 .31171 .2517 .33779 .24308 .32148 .2206 Metetra
.649 .69 .875 r
.32148 .2206 .33779 .24308 .36418 .23394 .34799 .21116 Metetra
.654 .691 .872 r
.34799 .21116 .36418 .23394 .39086 .22426 .3748 .20124 Metetra
.659 .692 .87 r
.3748 .20124 .39086 .22426 .41782 .21401 .40189 .19084 Metetra
.663 .695 .869 r
.40189 .19084 .41782 .21401 .44507 .2032 .42928 .17995 Metetra
.668 .698 .868 r
.42928 .17995 .44507 .2032 .47259 .19188 .45693 .1686 Metetra
.672 .701 .868 r
.45693 .1686 .47259 .19188 .50037 .18007 .48486 .15682 Metetra
.676 .705 .869 r
.48486 .15682 .50037 .18007 .52841 .16785 .51306 .14466 Metetra
.679 .709 .87 r
.51306 .14466 .52841 .16785 .5567 .15528 .54152 .13216 Metetra
.682 .713 .872 r
.54152 .13216 .5567 .15528 .58524 .14242 .57024 .11938 Metetra
.684 .716 .874 r
.57024 .11938 .58524 .14242 .61403 .12933 .59922 .10636 Metetra
.685 .72 .876 r
.59922 .10636 .61403 .12933 .64307 .11606 .62846 .09314 Metetra
.687 .723 .878 r
.62846 .09314 .64307 .11606 .67236 .10266 .65796 .07975 Metetra
.687 .726 .88 r
.65796 .07975 .67236 .10266 .70192 .08914 .68773 .06623 Metetra
.688 .729 .882 r
.68773 .06623 .70192 .08914 .73175 .07553 .71778 .0526 Metetra
.631 .71 .904 r
.05453 .27934 .07243 .29804 .0961 .29102 .07832 .27199 Metetra
.631 .708 .902 r
.07832 .27199 .0961 .29102 .12002 .28393 .10237 .26454 Metetra
.631 .706 .9 r
.10237 .26454 .12002 .28393 .14421 .27674 .12669 .25697 Metetra
.632 .704 .898 r
.12669 .25697 .14421 .27674 .16867 .26944 .15128 .24927 Metetra
.633 .702 .895 r
.15128 .24927 .16867 .26944 .19341 .26197 .17615 .2414 Metetra
.635 .7 .892 r
.17615 .2414 .19341 .26197 .21843 .25431 .2013 .23333 Metetra
.637 .698 .889 r
.2013 .23333 .21843 .25431 .24375 .24639 .22675 .225 Metetra
.64 .696 .886 r
.22675 .225 .24375 .24639 .26936 .23817 .2525 .21639 Metetra
.643 .695 .883 r
.2525 .21639 .26936 .23817 .29527 .22959 .27854 .20744 Metetra
.647 .695 .88 r
.27854 .20744 .29527 .22959 .32148 .2206 .30488 .19812 Metetra
.651 .695 .878 r
.30488 .19812 .32148 .2206 .34799 .21116 .33152 .1884 Metetra
.655 .695 .876 r
.33152 .1884 .34799 .21116 .3748 .20124 .35846 .17826 Metetra
.659 .697 .874 r
.35846 .17826 .3748 .20124 .40189 .19084 .38569 .16768 Metetra
.663 .698 .873 r
.38569 .16768 .40189 .19084 .42928 .17995 .41321 .15668 Metetra
.667 .701 .872 r
.41321 .15668 .42928 .17995 .45693 .1686 .44102 .14526 Metetra
.671 .704 .872 r
.44102 .14526 .45693 .1686 .48486 .15682 .4691 .13346 Metetra
.674 .707 .872 r
.4691 .13346 .48486 .15682 .51306 .14466 .49746 .1213 Metetra
.677 .71 .873 r
.49746 .1213 .51306 .14466 .54152 .13216 .52609 .10882 Metetra
.679 .713 .874 r
.52609 .10882 .54152 .13216 .57024 .11938 .55498 .09606 Metetra
.681 .717 .876 r
.55498 .09606 .57024 .11938 .59922 .10636 .58415 .08305 Metetra
.683 .72 .877 r
.58415 .08305 .59922 .10636 .62846 .09314 .61359 .06984 Metetra
.684 .723 .879 r
.61359 .06984 .62846 .09314 .65796 .07975 .64329 .05645 Metetra
.685 .725 .881 r
.64329 .05645 .65796 .07975 .68773 .06623 .67328 .0429 Metetra
.685 .728 .882 r
.67328 .0429 .68773 .06623 .71778 .0526 .70355 .02921 Metetra
.633 .711 .903 r
.03634 .26033 .05453 .27934 .07832 .27199 .06025 .25265 Metetra
.634 .709 .901 r
.06025 .25265 .07832 .27199 .10237 .26454 .08443 .24486 Metetra
.634 .707 .899 r
.08443 .24486 .10237 .26454 .12669 .25697 .10887 .23694 Metetra
.635 .706 .897 r
.10887 .23694 .12669 .25697 .15128 .24927 .13359 .22887 Metetra
.636 .704 .895 r
.13359 .22887 .15128 .24927 .17615 .2414 .15859 .22062 Metetra
.638 .702 .892 r
.15859 .22062 .17615 .2414 .2013 .23333 .18388 .21217 Metetra
.64 .701 .89 r
.18388 .21217 .2013 .23333 .22675 .225 .20946 .20347 Metetra
.643 .699 .887 r
.20946 .20347 .22675 .225 .2525 .21639 .23534 .19449 Metetra
.645 .699 .885 r
.23534 .19449 .2525 .21639 .27854 .20744 .26152 .18521 Metetra
.649 .698 .882 r
.26152 .18521 .27854 .20744 .30488 .19812 .28799 .17558 Metetra
.652 .698 .88 r
.28799 .17558 .30488 .19812 .33152 .1884 .31477 .1656 Metetra
.656 .699 .878 r
.31477 .1656 .33152 .1884 .35846 .17826 .34184 .15523 Metetra
.659 .7 .877 r
.34184 .15523 .35846 .17826 .38569 .16768 .36921 .14448 Metetra
.663 .702 .876 r
.36921 .14448 .38569 .16768 .41321 .15668 .39688 .13333 Metetra
.666 .704 .875 r
.39688 .13333 .41321 .15668 .44102 .14526 .42483 .12182 Metetra
.669 .706 .875 r
.42483 .12182 .44102 .14526 .4691 .13346 .45307 .10995 Metetra
.672 .709 .875 r
.45307 .10995 .4691 .13346 .49746 .1213 .48159 .09774 Metetra
.675 .711 .876 r
.48159 .09774 .49746 .1213 .52609 .10882 .51038 .08523 Metetra
.677 .714 .877 r
.51038 .08523 .52609 .10882 .55498 .09606 .53946 .07245 Metetra
.679 .717 .878 r
.53946 .07245 .55498 .09606 .58415 .08305 .56881 .05943 Metetra
.681 .72 .879 r
.56881 .05943 .58415 .08305 .61359 .06984 .59845 .04618 Metetra
.682 .722 .88 r
.59845 .04618 .61359 .06984 .64329 .05645 .62836 .03275 Metetra
.683 .725 .882 r
.62836 .03275 .64329 .05645 .67328 .0429 .65856 .01915 Metetra
.683 .727 .883 r
.65856 .01915 .67328 .0429 .70355 .02921 .68905 .00539 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-4)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-2)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(2)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(4)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.07346 .24092 m
.0763 .24365 L
s
.11029 .2265 m
.1131 .22926 L
s
.14766 .21187 m
.15043 .21466 L
s
.22407 .18195 m
.22677 .18482 L
s
.26314 .16665 m
.2658 .16956 L
s
.3028 .15112 m
.30541 .15406 L
s
.38395 .11935 m
.38647 .12237 L
s
.42547 .10309 m
.42794 .10615 L
s
.46763 .08658 m
.47006 .08968 L
s
.55397 .05277 m
.55629 .05595 L
s
.59817 .03546 m
.60044 .03868 L
s
.64309 .01787 m
.6453 .02113 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.8"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.2.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2.9 Mathematical Constants", "Subsection",
  CellTags->{"S3.2.9", "9.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["I", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["i",
                        "TI"], "=", \(\@\(-1\)\)}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Infinity", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Pi", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Pi] \[TildeEqual] 3.14159\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Degree", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Pi]/180\)], "InlineFormula"],
              ": degrees to radians conversion factor "
            }]]},
          {Cell[TextData[{
              StyleBox["GoldenRatio", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Phi] = \((1 + \@5)\)/2 \[TildeEqual] 
                      1.61803\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["E", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["e",
                        "TI"], "\[TildeEqual]", "2.71828"}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["EulerGamma", "MR"],
              " "
            }]], Cell[TextData[{
              "Euler's constant ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Gamma] \[TildeEqual] 0.577216\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Catalan", "MR"],
              " "
            }]], Cell[TextData[{
              "Catalan's constant ",
              Cell[BoxData[
                  \(TraditionalForm\`\(\(\[TildeEqual]\)\(0.915966\)\)\)], 
                "InlineFormula"]
            }]]},
          {Cell[TextData[{
              StyleBox["Khinchin", "MR"],
              " "
            }]], Cell[TextData[{
              "Khinchin's constant ",
              Cell[BoxData[
                  \(TraditionalForm\`\(\(\[TildeEqual]\)\(2.68545\)\)\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Glaisher", "MR"],
              " "
            }]], Cell[TextData[{
              "Glaisher's constant ",
              Cell[BoxData[
                  \(TraditionalForm\`\(\(\[TildeEqual]\)\(1.28243\)\)\)], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.9"],

Cell["Mathematical constants.", "Caption",
  CellTags->"S3.2.9"],

Cell[TextData[{
  StyleBox["Euler's constant", "TB"],
  " ",
  StyleBox["EulerGamma", "MR"],
  " is given by the limit ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Gamma]", "=", 
          UnderscriptBox["lim", 
            RowBox[{
              StyleBox["m",
                "TI"], "\[Rule]", "\[Infinity]"}],
            LimitsPositioning->True], 
          RowBox[{"(", 
            RowBox[{
              UnderoverscriptBox["\[Sum]", 
                RowBox[{
                  StyleBox["k",
                    "TI"], "=", "1"}], 
                StyleBox["m",
                  "TI"],
                LimitsPositioning->True], 
              FractionBox["1", 
                StyleBox["k",
                  "TI"]], " ", \(\(-\)\(\ \)\), "log", 
              StyleBox["m",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". It appears in many integrals, and asymptotic formulas. It is sometimes \
known as the ",
  StyleBox["Euler\[Hyphen]Mascheroni constant", "TB"],
  ", and denoted ",
  Cell[BoxData[
      FormBox[
        StyleBox["C",
          "TI"], TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.2.9", "9.2"}],

Cell[TextData[{
  StyleBox["Catalan's constant", "TB"],
  " ",
  StyleBox["Catalan", "MR"],
  " is given by the sum ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          SuperscriptBox[\((\(-1\))\), 
            StyleBox["k",
              "TI"]], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"2", 
                StyleBox["k",
                  "TI"], "+", "1"}], ")"}], \(-2\)]}], TraditionalForm]], 
    "InlineFormula"],
  ". It often appears in asymptotic estimates of combinatorial functions. "
}], "Text",
  CellTags->{"S3.2.9", "9.3"}],

Cell[TextData[{
  StyleBox["Khinchin's constant", "TB"],
  " ",
  StyleBox["Khinchin", "MR"],
  " (sometimes called Khintchine's constant) is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Product]", 
            RowBox[{
              StyleBox["s",
                "TI"], "=", "1"}], "\[Infinity]",
            LimitsPositioning->True], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "+", 
                FractionBox["1", 
                  RowBox[{
                    StyleBox["s",
                      "TI"], 
                    RowBox[{"(", 
                      RowBox[{
                        StyleBox["s",
                          "TI"], "+", "2"}], ")"}]}]]}], ")"}], 
            RowBox[{\(log\_2\), 
              StyleBox["s",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  ". It gives the geometric mean of the terms in the continued fraction \
representation for a typical real number. "
}], "Text",
  CellTags->{"S3.2.9", "9.4"}],

Cell[TextData[{
  StyleBox["Glaisher's constant", "TB"],
  " ",
  StyleBox["Glaisher", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        StyleBox["A",
          "TI"], TraditionalForm]], "InlineFormula"],
  " (sometimes called the Glaisher\[Hyphen]Kinkelin constant) satisfies ",
  Cell[BoxData[
      FormBox[
        RowBox[{"log", 
          RowBox[{"(", 
            StyleBox["A",
              "TI"], ")"}], "=", \(1\/12\), 
          "-", \(\[Zeta]\^\[Prime]\), \((\(-1\))\)}], TraditionalForm]], 
    "InlineFormula"],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Zeta]\)], "InlineFormula"],
  " is the Riemann zeta function. It appears in various sums and integrals, \
particularly those involving gamma and zeta functions.  "
}], "Text",
  CellTags->{"S3.2.9", "9.5"}],

Cell["\<\
Mathematical constants can be evaluated to arbitrary precision. \
\
\>", "MathCaption",
  CellTags->{"S3.2.9", "9.6"}],

Cell[CellGroupData[{

Cell["N[EulerGamma, 40]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.2.9"],

Cell[BoxData[
    \(0.577215664901532860606512090082402431042165671474999864649`40. \)], \
"Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.2.9"]
}, Open  ]],

Cell["Exact computations can also be done with them. ", "MathCaption",
  CellTags->{"S3.2.9", "9.7"}],

Cell[CellGroupData[{

Cell["IntegerPart[GoldenRatio^100]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.2.9"],

Cell[BoxData[
    \(792070839848372253126\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.2.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2.10 Orthogonal Polynomials", "Subsection",
  CellTags->{"S3.2.10", "10.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LegendreP[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Legendre polynomials ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["P",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["x",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LegendreP[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "associated Legendre polynomials ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox[
                        StyleBox["P",
                          "TI"], 
                        StyleBox["n",
                          "TI"], 
                        StyleBox["m",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["x",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SphericalHarmonicY[", "MR"],
              StyleBox["l", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Theta]\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "spherical harmonics ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox[
                        StyleBox["Y",
                          "TI"], 
                        StyleBox["l",
                          "TI"], 
                        StyleBox["m",
                          "TI"]], \((\[Theta], \[Phi])\)}], TraditionalForm]],
                 "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["GegenbauerC[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Gegenbauer polynomials ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox[
                        StyleBox["C",
                          "TI"], 
                        StyleBox["n",
                          "TI"], 
                        RowBox[{"(", 
                          StyleBox["m",
                            "TI"], ")"}]], 
                      RowBox[{"(", 
                        StyleBox["x",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ChebyshevT[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["ChebyshevU[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Chebyshev polynomials ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["T",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["x",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " and ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["U",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["x",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " of the first and second kinds "
            }]]},
          {Cell[TextData[{
              StyleBox["HermiteH[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Hermite polynomials ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["H",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["x",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LaguerreL[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Laguerre polynomials ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["L",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["x",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LaguerreL[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generalized Laguerre polynomials ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox[
                        StyleBox["L",
                          "TI"], 
                        StyleBox["n",
                          "TI"], 
                        StyleBox["a",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["x",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["JacobiP[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Jacobi polynomials ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox[
                        StyleBox["P",
                          "TI"], 
                        StyleBox["n",
                          "TI"], 
                        RowBox[{"(", 
                          RowBox[{
                            StyleBox["a",
                              "TI"], ",", 
                            StyleBox["b",
                              "TI"]}], ")"}]], 
                      RowBox[{"(", 
                        StyleBox["x",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.10"],

Cell["Orthogonal polynomials.", "Caption",
  CellTags->"S3.2.10"],

Cell[TextData[{
  StyleBox["Legendre polynomials", "TB"],
  " ",
  StyleBox["LegendreP[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " arise in studies of systems with three\[Hyphen]dimensional spherical \
symmetry. They satisfy the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"(", 
            RowBox[{"1", "-", 
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "2"]}], ")"}], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "-", "2", 
          StyleBox["x",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "+", 
          StyleBox["n",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], "+", "1"}], ")"}], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", and the orthogonality relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\(-1\)\%1\), 
          SubscriptBox[
            StyleBox["P",
              "TI"], 
            StyleBox["m",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SubscriptBox[
            StyleBox["P",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "\[DifferentialD]", 
          StyleBox["x",
            "TI"], " ", \(\(=\)\(\ \)\), "0"}], TraditionalForm]], 
    "InlineFormula"],
  " for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "\[NotEqual]", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.10", "10.2"}],

Cell[TextData[{
  "The ",
  StyleBox["associated Legendre polynomials", "TB"],
  " ",
  StyleBox["LegendreP[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " are obtained from derivatives of the Legendre polynomials according to ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["P",
              "TI"], 
            StyleBox["n",
              "TI"], 
            StyleBox["m",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          SuperscriptBox[\((\(-1\))\), 
            StyleBox["m",
              "TI"]], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                SuperscriptBox[
                  StyleBox["x",
                    "TI"], "2"]}], ")"}], 
            RowBox[{
              StyleBox["m",
                "TI"], "/", "2"}]], " ", 
          SuperscriptBox[
            StyleBox["d",
              "TI"], 
            StyleBox["m",
              "TI"]], 
          RowBox[{"[", 
            RowBox[{
              SubscriptBox[
                StyleBox["P",
                  "TI"], 
                StyleBox["n",
                  "TI"]], 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}], "]"}], "/", 
          RowBox[{
            StyleBox["d",
              "TI"], 
            SuperscriptBox[
              StyleBox["x",
                "TI"], 
              StyleBox["m",
                "TI"]]}]}], TraditionalForm]], "InlineFormula"],
  ". Notice that for odd integers ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "\[LessEqual]", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ", the ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["P",
              "TI"], 
            StyleBox["n",
              "TI"], 
            StyleBox["m",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " contain powers of ",
  Cell[BoxData[
      FormBox[
        SqrtBox[
          RowBox[{"1", "-", 
            SuperscriptBox[
              StyleBox["x",
                "TI"], "2"]}]], TraditionalForm]], "InlineFormula"],
  ", and are therefore not strictly polynomials. The ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["P",
              "TI"], 
            StyleBox["n",
              "TI"], 
            StyleBox["m",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " reduce to ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["P",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " when ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.10", "10.3"}],

Cell[TextData[{
  "The ",
  StyleBox["spherical harmonics", "TB"],
  " ",
  StyleBox["SphericalHarmonicY[", "MR"],
  StyleBox["l", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta]\)], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
  StyleBox["]", "MR"],
  " are related to associated Legendre polynomials. They satisfy the \
orthogonality relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          SubsuperscriptBox[
            StyleBox["Y",
              "TI"], 
            StyleBox["l",
              "TI"], 
            RowBox[{" ", 
              StyleBox["m",
                "TI"]}]], \((\[Theta], \[Phi])\), 
          SubsuperscriptBox[
            OverscriptBox[
              StyleBox["Y",
                "TI"], "_"], 
            SuperscriptBox[
              StyleBox["l",
                "TI"], "\[Prime]"], 
            RowBox[{" ", 
              SuperscriptBox[
                StyleBox["m",
                  "TI"], "\[Prime]"]}]], \((\[Theta], \[Phi])\), 
          "\[DifferentialD]", \(\(\[Omega]\)\(\ \)\), \(\(=\)\(\ \)\), "0"}], 
        TraditionalForm]], "InlineFormula"],
  " for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["l",
            "TI"], "\[NotEqual]", 
          SuperscriptBox[
            StyleBox["l",
              "TI"], "\[Prime]"]}], TraditionalForm]], "InlineFormula"],
  " or ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "\[NotEqual]", 
          SuperscriptBox[
            StyleBox["m",
              "TI"], "\[Prime]"]}], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["d",
            "TI"], "\[Omega]"}], TraditionalForm]], "InlineFormula"],
  " represents integration over the surface of the unit sphere. "
}], "Text",
  CellTags->{"S3.2.10", "10.4"}],

Cell[TextData[{
  "This gives the algebraic form of the Legendre polynomial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["P",
              "TI"], "8"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.10", "10.5"}],

Cell[CellGroupData[{

Cell["LegendreP[8, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.2.10"],

Cell[BoxData[
    \(1\/128\ \((35 - 1260\ x\^2 + 6930\ x\^4 - 12012\ x\^6 + 
          6435\ x\^8)\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.2.10"]
}, Open  ]],

Cell[TextData[{
  "The integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\(-1\)\%1\), 
          SubscriptBox[
            StyleBox["P",
              "TI"], "7"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], " ", 
          SubscriptBox[
            StyleBox["P",
              "TI"], "8"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], " ", 
          StyleBox["d",
            "TI"], 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " gives zero by virtue of the orthogonality of the Legendre polynomials. "
}], "MathCaption",
  CellTags->{"S3.2.10", "10.6"}],

Cell[CellGroupData[{

Cell["Integrate[LegendreP[7,x] LegendreP[8,x], {x, -1, 1}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.2.10"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.2.10"]
}, Open  ]],

Cell["\<\
Integrating the square of a single Legendre polynomial gives a non\
\[Hyphen]zero result. \
\>", "MathCaption",
  CellTags->{"S3.2.10", "10.7"}],

Cell[CellGroupData[{

Cell["Integrate[LegendreP[8, x]^2, {x, -1, 1}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.2.10"],

Cell[BoxData[
    \(2\/17\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.2.10"]
}, Open  ]],

Cell["\<\
High\[Hyphen]degree Legendre polynomials oscillate rapidly. \
\>", \
"MathCaption",
  CellTags->{"S3.2.10", "10.8"}],

Cell[CellGroupData[{

Cell["Plot[LegendreP[10, x], {x, -1, 1}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.2.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.185057 0.418264 [
[.02381 .17256 -6 -9 ]
[.02381 .17256 6 0 ]
[.2619 .17256 -12 -9 ]
[.2619 .17256 12 0 ]
[.7381 .17256 -9 -9 ]
[.7381 .17256 9 0 ]
[.97619 .17256 -3 -9 ]
[.97619 .17256 3 0 ]
[.4875 .01775 -24 -4.5 ]
[.4875 .01775 0 4.5 ]
[.4875 .1014 -24 -4.5 ]
[.4875 .1014 0 4.5 ]
[.4875 .26871 -18 -4.5 ]
[.4875 .26871 0 4.5 ]
[.4875 .35236 -18 -4.5 ]
[.4875 .35236 0 4.5 ]
[.4875 .43602 -18 -4.5 ]
[.4875 .43602 0 4.5 ]
[.4875 .51967 -18 -4.5 ]
[.4875 .51967 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .18506 m
.02381 .19131 L
s
[(-1)] .02381 .17256 0 1 Mshowa
.2619 .18506 m
.2619 .19131 L
s
[(-0.5)] .2619 .17256 0 1 Mshowa
.7381 .18506 m
.7381 .19131 L
s
[(0.5)] .7381 .17256 0 1 Mshowa
.97619 .18506 m
.97619 .19131 L
s
[(1)] .97619 .17256 0 1 Mshowa
.125 Mabswid
.07143 .18506 m
.07143 .18881 L
s
.11905 .18506 m
.11905 .18881 L
s
.16667 .18506 m
.16667 .18881 L
s
.21429 .18506 m
.21429 .18881 L
s
.30952 .18506 m
.30952 .18881 L
s
.35714 .18506 m
.35714 .18881 L
s
.40476 .18506 m
.40476 .18881 L
s
.45238 .18506 m
.45238 .18881 L
s
.54762 .18506 m
.54762 .18881 L
s
.59524 .18506 m
.59524 .18881 L
s
.64286 .18506 m
.64286 .18881 L
s
.69048 .18506 m
.69048 .18881 L
s
.78571 .18506 m
.78571 .18881 L
s
.83333 .18506 m
.83333 .18881 L
s
.88095 .18506 m
.88095 .18881 L
s
.92857 .18506 m
.92857 .18881 L
s
.25 Mabswid
0 .18506 m
1 .18506 L
s
.5 .01775 m
.50625 .01775 L
s
[(-0.4)] .4875 .01775 1 0 Mshowa
.5 .1014 m
.50625 .1014 L
s
[(-0.2)] .4875 .1014 1 0 Mshowa
.5 .26871 m
.50625 .26871 L
s
[(0.2)] .4875 .26871 1 0 Mshowa
.5 .35236 m
.50625 .35236 L
s
[(0.4)] .4875 .35236 1 0 Mshowa
.5 .43602 m
.50625 .43602 L
s
[(0.6)] .4875 .43602 1 0 Mshowa
.5 .51967 m
.50625 .51967 L
s
[(0.8)] .4875 .51967 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .03866 m
.50375 .03866 L
s
.5 .05958 m
.50375 .05958 L
s
.5 .08049 m
.50375 .08049 L
s
.5 .12232 m
.50375 .12232 L
s
.5 .14323 m
.50375 .14323 L
s
.5 .16414 m
.50375 .16414 L
s
.5 .20597 m
.50375 .20597 L
s
.5 .22688 m
.50375 .22688 L
s
.5 .2478 m
.50375 .2478 L
s
.5 .28962 m
.50375 .28962 L
s
.5 .31054 m
.50375 .31054 L
s
.5 .33145 m
.50375 .33145 L
s
.5 .37328 m
.50375 .37328 L
s
.5 .39419 m
.50375 .39419 L
s
.5 .4151 m
.50375 .4151 L
s
.5 .45693 m
.50375 .45693 L
s
.5 .47784 m
.50375 .47784 L
s
.5 .49875 m
.50375 .49875 L
s
.5 .54058 m
.50375 .54058 L
s
.5 .56149 m
.50375 .56149 L
s
.5 .58241 m
.50375 .58241 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02846 .40678 L
.03279 .26869 L
.03754 .15888 L
.0402 .11357 L
.04262 .0811 L
.04516 .05499 L
.0475 .03734 L
.04873 .03035 L
.05008 .02427 L
.05076 .02182 L
.05149 .01962 L
.05281 .01671 L
.05404 .01518 L
.05474 .01479 L
.05539 .01472 L
.05658 .01527 L
.05784 .01679 L
.05908 .01913 L
.06026 .02206 L
.06244 .02919 L
.06757 .05273 L
.07299 .08473 L
.08269 .14953 L
.09325 .21683 L
.09907 .24817 L
.10458 .27275 L
.1095 .29007 L
.11209 .29738 L
.11485 .30376 L
.11716 .30802 L
.11839 .30988 L
.11972 .31158 L
.12093 .31285 L
.12204 .31379 L
.1231 .31449 L
.12422 .31501 L
.12537 .31532 L
.12641 .31542 L
.12762 .31531 L
.12875 .31498 L
.12981 .3145 L
.13078 .31391 L
.13297 .31205 L
.13519 .30946 L
.13763 .30585 L
.14255 .29632 L
.15271 .26893 L
.162 .23778 L
.18289 .16236 L
Mistroke
.19211 .1326 L
.20191 .10628 L
.20756 .09422 L
.21268 .08546 L
.21515 .08199 L
.21782 .07881 L
.22035 .07634 L
.22265 .07456 L
.22503 .07319 L
.22634 .07264 L
.22758 .07225 L
.22873 .072 L
.22979 .07186 L
.23095 .07182 L
.23218 .07189 L
.23342 .07208 L
.23411 .07224 L
.23475 .07243 L
.23715 .0734 L
.23843 .07409 L
.23982 .07499 L
.24263 .07724 L
.24792 .08296 L
.25356 .09106 L
.26371 .11007 L
.28366 .15856 L
.30526 .21517 L
.31539 .23899 L
.3261 .26026 L
.33525 .27438 L
.34044 .28052 L
.34529 .28495 L
.34789 .28678 L
.35029 .28814 L
.35292 .28926 L
.35426 .28968 L
.35497 .28986 L
.35573 .29002 L
.35701 .29022 L
.35818 .29033 L
.35944 .29035 L
.36016 .29033 L
.36083 .29028 L
.36204 .29012 L
.36314 .28991 L
.36442 .28959 L
.36562 .2892 L
.36787 .28826 L
.37025 .28697 L
.37452 .28391 L
Mistroke
.37911 .27959 L
.38417 .27368 L
.40359 .24138 L
.42448 .19576 L
.4442 .15098 L
.45462 .1296 L
.46572 .11017 L
.47129 .10207 L
.47653 .09559 L
.48163 .09044 L
.48633 .08676 L
.4908 .08423 L
.49305 .08333 L
.49431 .08293 L
.49551 .08263 L
.49681 .08238 L
.498 .08222 L
.49927 .08214 L
.49999 .08212 L
.50065 .08214 L
.50176 .0822 L
.50298 .08235 L
.50425 .08258 L
.50545 .08286 L
.50788 .08367 L
.51015 .08469 L
.51529 .08791 L
.5203 .09225 L
.52565 .09814 L
.53535 .11185 L
.54416 .12727 L
.58416 .2154 L
.60249 .25291 L
.6129 .26973 L
.618 .27635 L
.62264 .28137 L
.62757 .28552 L
.62983 .28701 L
.63224 .28831 L
.63358 .28889 L
.63479 .28934 L
.63603 .28971 L
.63716 .28998 L
.6378 .2901 L
.6385 .2902 L
.63919 .29028 L
.63993 .29033 L
.64058 .29035 L
.64128 .29035 L
.64253 .29027 L
Mistroke
.64322 .2902 L
.64395 .29008 L
.64525 .28981 L
.64665 .2894 L
.6482 .28883 L
.65096 .28747 L
.65355 .28581 L
.65838 .28171 L
.66358 .27589 L
.67368 .26065 L
.68471 .23878 L
.70479 .18926 L
.7261 .13353 L
.73617 .11034 L
.74543 .09272 L
.75004 .08567 L
.7551 .07946 L
.75756 .07707 L
.76019 .07498 L
.76164 .07405 L
.76297 .07334 L
.76423 .07279 L
.76557 .07233 L
.76672 .07206 L
.76799 .07187 L
.76915 .07182 L
.77023 .07186 L
.77151 .07204 L
.77268 .07232 L
.77396 .07276 L
.77531 .07336 L
.7776 .07473 L
.77972 .0764 L
.78455 .08159 L
.78959 .08908 L
.79506 .09952 L
.80499 .12416 L
.82358 .18524 L
.84305 .25526 L
.84839 .27232 L
.85412 .28838 L
.8595 .30063 L
.86448 .30902 L
.86693 .31195 L
.8683 .31321 L
.86953 .31412 L
.8702 .31451 L
.8709 .31484 L
.87167 .31513 L
.87237 .3153 L
Mistroke
.87364 .31542 L
.87437 .31537 L
.87504 .31524 L
.87634 .31477 L
.87757 .31407 L
.87868 .31321 L
.87988 .31203 L
.88257 .30844 L
.88506 .30393 L
.8894 .29331 L
.89419 .2775 L
.90388 .23295 L
.91411 .17091 L
.92488 .09855 L
.92933 .07041 L
.93407 .04429 L
.9368 .03209 L
.93928 .0234 L
.94047 .02016 L
.94177 .01743 L
.94299 .01569 L
.94412 .01484 L
.94509 .01474 L
.94597 .01519 L
.94699 .01639 L
.94796 .01823 L
.94885 .02058 L
.94967 .02334 L
.95154 .03179 L
.95342 .04362 L
.9555 .06101 L
.95767 .08451 L
.95971 .1121 L
.96384 .18663 L
.96763 .28037 L
.9718 .41624 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.10"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.2.10"]
}, Open  ]],

Cell["\<\
The associated Legendre \[OpenCurlyDoubleQuote]polynomials\
\[CloseCurlyDoubleQuote] involve fractional powers. \
\>", "MathCaption",
  CellTags->{"S3.2.10", "10.9"}],

Cell[CellGroupData[{

Cell["LegendreP[8, 3, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.2.10"],

Cell[BoxData[
    \(3465\/8\ \@\(1 - x\^2\)\ \((\(-1\) + x\^2)\)\ \((3\ x - 26\ x\^3 + 
          39\ x\^5)\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.2.10"]
}, Open  ]],

Cell[TextData[{
  "Section ",
  ButtonBox["3.2.11",
    ButtonData:>{"3.2.11", "11.1"},
    ButtonStyle->"MainBookLink"],
  " discusses the generalization of Legendre polynomials to Legendre \
functions, which can have non\[Hyphen]integer degrees. "
}], "MathCaption",
  CellTags->{"S3.2.10", "10.10"}],

Cell[CellGroupData[{

Cell["LegendreP[8.1, 0]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.2.10"],

Cell[BoxData[
    \(0.2685015408609046`\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.2.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Gegenbauer polynomials", "TB"],
  " ",
  StyleBox["GegenbauerC[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " can be viewed as generalizations of the Legendre polynomials to systems \
with ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            StyleBox["m",
              "TI"], "+", "2"}], ")"}], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]dimensional spherical symmetry. They are sometimes known as ",
  StyleBox["ultraspherical polynomials", "TB"],
  ". "
}], "Text",
  CellTags->{"S3.2.10", "10.11"}],

Cell[TextData[{
  StyleBox["GegenbauerC[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["0,", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " is always equal to zero. ",
  StyleBox["GegenbauerC[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " is however given by the limit ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderscriptBox["lim", 
            RowBox[{
              StyleBox["m",
                "TI"], "\[Rule]", "0"}],
            LimitsPositioning->True], 
          SubsuperscriptBox[
            StyleBox["C",
              "TI"], 
            StyleBox["n",
              "TI"], 
            RowBox[{"(", 
              StyleBox["m",
                "TI"], ")"}]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "/", 
          StyleBox["m",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". This form is sometimes denoted ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["C",
              "TI"], 
            StyleBox["n",
              "TI"], \((0)\)], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.10", "10.12"}],

Cell[TextData[{
  "Series of Chebyshev polynomials are often used in making numerical \
approximations to functions. The ",
  StyleBox["Chebyshev polynomials of the first kind", "TB"],
  " ",
  StyleBox["ChebyshevT[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " are defined by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["T",
              "TI"], 
            StyleBox["n",
              "TI"]], \((cos  \[Theta])\), "=", "cos", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], "\[Theta]"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". They are normalized so that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["T",
              "TI"], 
            StyleBox["n",
              "TI"]], \((1)\), "=", "1"}], TraditionalForm]], 
    "InlineFormula"],
  ". They satisfy the orthogonality relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\(-1\)\%1\), 
          SubscriptBox[
            StyleBox["T",
              "TI"], 
            StyleBox["m",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SubscriptBox[
            StyleBox["T",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                SuperscriptBox[
                  StyleBox["x",
                    "TI"], "2"]}], ")"}], \(\(-1\)/2\)], "\[DifferentialD]", 
          StyleBox["x",
            "TI"], " ", \(\(=\)\(\ \)\), "0"}], TraditionalForm]], 
    "InlineFormula"],
  " for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "\[NotEqual]", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". The ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["T",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " also satisfy an orthogonality relation under summation at discrete points \
in ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " corresponding to the roots of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["T",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.10", "10.13"}],

Cell[TextData[{
  "The ",
  StyleBox["Chebyshev polynomials of the second kind", "TB"],
  " ",
  StyleBox["ChebyshevU[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " are defined by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["U",
              "TI"], 
            StyleBox["n",
              "TI"]], \((cos  \[Theta])\), "=", 
          RowBox[{"sin", 
            RowBox[{"[", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["n",
                      "TI"], "+", "1"}], ")"}], "\[Theta]"}], "]"}]}], 
          "/", \(sin  \[Theta]\)}], TraditionalForm]], "InlineFormula"],
  ". With this definition, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["U",
              "TI"], 
            StyleBox["n",
              "TI"]], \((1)\), "=", 
          StyleBox["n",
            "TI"], "+", "1"}], TraditionalForm]], "InlineFormula"],
  ". The ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["U",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " satisfy the orthogonality relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\(-1\)\%1\), 
          SubscriptBox[
            StyleBox["U",
              "TI"], 
            StyleBox["m",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SubscriptBox[
            StyleBox["U",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                SuperscriptBox[
                  StyleBox["x",
                    "TI"], "2"]}], ")"}], \(1/2\)], "\[DifferentialD]", 
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  " for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "\[NotEqual]", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.10", "10.14"}],

Cell["\<\
The name \[OpenCurlyDoubleQuote]Chebyshev\[CloseCurlyDoubleQuote] \
is a transliteration from the Cyrillic alphabet; several other spellings, \
such as \[OpenCurlyDoubleQuote]Tschebyscheff\[CloseCurlyDoubleQuote], are \
sometimes used. \
\>", "Text",
  CellTags->{"S3.2.10", "10.15"}],

Cell[TextData[{
  StyleBox["Hermite polynomials", "TB"],
  " ",
  StyleBox["HermiteH[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " arise as the quantum\[Hyphen]mechanical wave functions for a harmonic \
oscillator. They satisfy the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "-", "2", 
          StyleBox["x",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "+", "2", 
          StyleBox["n",
            "TI"], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", and the orthogonality relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\), 
          SubscriptBox[
            StyleBox["H",
              "TI"], 
            StyleBox["m",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SubscriptBox[
            StyleBox["H",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "2"]}]], "\[DifferentialD]", 
          StyleBox["x",
            "TI"], " ", \(\(=\)\(\ \)\), "0"}], TraditionalForm]], 
    "InlineFormula"],
  " for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "\[NotEqual]", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". An alternative form of Hermite polynomials sometimes used is ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["He",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          SuperscriptBox["2", 
            RowBox[{"-", 
              StyleBox["n",
                "TI"], "/", "2"}]], 
          SubscriptBox[
            StyleBox["H",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], "/", \(\@2\)}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  " (a different overall normalization of the ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["He",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is also sometimes used). "
}], "Text",
  CellTags->{"S3.2.10", "10.16"}],

Cell[TextData[{
  "The Hermite polynomials are related to the ",
  StyleBox["parabolic cylinder functions", "TB"],
  " or ",
  StyleBox["Weber functions", "TB"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["D",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["D",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          SuperscriptBox["2", 
            RowBox[{"-", 
              StyleBox["n",
                "TI"], "/", "2"}]], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "2"], "/", "4"}]], 
          SubscriptBox[
            StyleBox["H",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], "/", \(\@2\)}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.10", "10.17"}],

Cell["\<\
This gives the density for an excited state of a \
quantum\[Hyphen]mechanical harmonic oscillator. The average of the wiggles is \
roughly the classical physics result. \
\>", "MathCaption",
  CellTags->{"S3.2.10", "10.18"}],

Cell[CellGroupData[{

Cell["Plot[(HermiteH[6, x] Exp[-x^2/2])^2, {x, -6, 6}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.2.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0793651 0.0147151 2.35205e-05 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.18254 .00222 -6 -9 ]
[.18254 .00222 6 0 ]
[.34127 .00222 -6 -9 ]
[.34127 .00222 6 0 ]
[.65873 .00222 -3 -9 ]
[.65873 .00222 3 0 ]
[.81746 .00222 -3 -9 ]
[.81746 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.4875 .13232 -24 -4.5 ]
[.4875 .13232 0 4.5 ]
[.4875 .24992 -30 -4.5 ]
[.4875 .24992 0 4.5 ]
[.4875 .36752 -30 -4.5 ]
[.4875 .36752 0 4.5 ]
[.4875 .48513 -30 -4.5 ]
[.4875 .48513 0 4.5 ]
[.4875 .60273 -30 -4.5 ]
[.4875 .60273 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-6)] .02381 .00222 0 1 Mshowa
.18254 .01472 m
.18254 .02097 L
s
[(-4)] .18254 .00222 0 1 Mshowa
.34127 .01472 m
.34127 .02097 L
s
[(-2)] .34127 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(2)] .65873 .00222 0 1 Mshowa
.81746 .01472 m
.81746 .02097 L
s
[(4)] .81746 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(6)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.06349 .01472 m
.06349 .01847 L
s
.10317 .01472 m
.10317 .01847 L
s
.14286 .01472 m
.14286 .01847 L
s
.22222 .01472 m
.22222 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30159 .01472 m
.30159 .01847 L
s
.38095 .01472 m
.38095 .01847 L
s
.42063 .01472 m
.42063 .01847 L
s
.46032 .01472 m
.46032 .01847 L
s
.53968 .01472 m
.53968 .01847 L
s
.57937 .01472 m
.57937 .01847 L
s
.61905 .01472 m
.61905 .01847 L
s
.69841 .01472 m
.69841 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.77778 .01472 m
.77778 .01847 L
s
.85714 .01472 m
.85714 .01847 L
s
.89683 .01472 m
.89683 .01847 L
s
.93651 .01472 m
.93651 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .13232 m
.50625 .13232 L
s
[(5000)] .4875 .13232 1 0 Mshowa
.5 .24992 m
.50625 .24992 L
s
[(10000)] .4875 .24992 1 0 Mshowa
.5 .36752 m
.50625 .36752 L
s
[(15000)] .4875 .36752 1 0 Mshowa
.5 .48513 m
.50625 .48513 L
s
[(20000)] .4875 .48513 1 0 Mshowa
.5 .60273 m
.50625 .60273 L
s
[(25000)] .4875 .60273 1 0 Mshowa
.125 Mabswid
.5 .03824 m
.50375 .03824 L
s
.5 .06176 m
.50375 .06176 L
s
.5 .08528 m
.50375 .08528 L
s
.5 .1088 m
.50375 .1088 L
s
.5 .15584 m
.50375 .15584 L
s
.5 .17936 m
.50375 .17936 L
s
.5 .20288 m
.50375 .20288 L
s
.5 .2264 m
.50375 .2264 L
s
.5 .27344 m
.50375 .27344 L
s
.5 .29696 m
.50375 .29696 L
s
.5 .32048 m
.50375 .32048 L
s
.5 .344 m
.50375 .344 L
s
.5 .39104 m
.50375 .39104 L
s
.5 .41456 m
.50375 .41456 L
s
.5 .43808 m
.50375 .43808 L
s
.5 .4616 m
.50375 .4616 L
s
.5 .50865 m
.50375 .50865 L
s
.5 .53217 m
.50375 .53217 L
s
.5 .55569 m
.50375 .55569 L
s
.5 .57921 m
.50375 .57921 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02605 .01472 L
.02846 .01472 L
.03072 .01472 L
.03279 .01472 L
.03521 .01472 L
.03784 .01472 L
.04032 .01472 L
.04262 .01472 L
.04498 .01472 L
.0472 .01472 L
.04963 .01472 L
.05224 .01472 L
.05497 .01472 L
.05757 .01472 L
.0599 .01472 L
.06244 .01472 L
.0653 .01472 L
.06799 .01472 L
.07041 .01472 L
.07302 .01472 L
.07588 .01473 L
.07889 .01473 L
.08147 .01474 L
.08429 .01474 L
.08694 .01475 L
.08936 .01476 L
.09215 .01477 L
.09479 .01479 L
.09948 .01483 L
.10213 .01487 L
.10458 .01491 L
.10921 .01501 L
.11182 .01508 L
.11421 .01517 L
.11861 .01538 L
.12082 .01551 L
.12324 .01569 L
.1284 .01621 L
.13129 .0166 L
.13392 .01704 L
.13902 .01816 L
.14385 .01967 L
.14848 .02165 L
.15357 .02465 L
.15888 .02898 L
.16386 .03448 L
.16851 .04122 L
.17276 .04904 L
.18231 .07406 L
Mistroke
.18709 .09133 L
.19218 .1139 L
.20134 .16674 L
.21222 .25129 L
.22207 .34529 L
.23146 .44139 L
.24136 .5333 L
.24654 .57006 L
.24948 .58564 L
.25088 .59151 L
.25222 .59604 L
.25342 .59925 L
.25474 .6017 L
.25593 .60298 L
.25703 .60332 L
.25822 .60276 L
.25954 .60101 L
.2602 .59967 L
.26091 .59787 L
.26219 .59371 L
.2646 .58267 L
.26717 .56623 L
.27179 .52481 L
.27728 .45761 L
.28227 .38338 L
.29326 .20278 L
.29809 .13057 L
.30064 .09737 L
.30338 .06696 L
.30591 .04451 L
.30821 .02923 L
.30932 .02376 L
.31053 .01925 L
.31167 .0164 L
.31273 .01499 L
.3139 .01483 L
.315 .01602 L
.31621 .01881 L
.31752 .02355 L
.31881 .02998 L
.32017 .03855 L
.32261 .05823 L
.32775 .11547 L
.33254 .18191 L
.33776 .2587 L
.34342 .33381 L
.34607 .36206 L
.34752 .37496 L
.34888 .38518 L
.35014 .39291 L
Mistroke
.35128 .39848 L
.35256 .40292 L
.35326 .40456 L
.35392 .40558 L
.35512 .40609 L
.35639 .40474 L
.35759 .4017 L
.35867 .39747 L
.35995 .39071 L
.36134 .38132 L
.36385 .35909 L
.36856 .30214 L
.37353 .22787 L
.38243 .09512 L
.38498 .06506 L
.3874 .04227 L
.38956 .02729 L
.39079 .02132 L
.39192 .01748 L
.39313 .01519 L
.39426 .01477 L
.39551 .01623 L
.39621 .01794 L
.39685 .02005 L
.39807 .0255 L
.3994 .03353 L
.40208 .05587 L
.40668 .11 L
.41159 .18146 L
.41588 .24576 L
.42042 .30526 L
.42296 .33121 L
.42431 .3422 L
.42576 .35163 L
.42644 .35518 L
.42709 .35799 L
.4283 .3618 L
.42944 .36359 L
.43068 .36354 L
.43143 .3625 L
.43214 .36081 L
.43278 .35872 L
.43347 .35587 L
.43502 .3472 L
.43644 .33662 L
.43904 .31139 L
.44178 .27779 L
.45152 .13213 L
.45432 .09313 L
.45698 .06168 L
Mistroke
.45936 .03944 L
.4607 .0298 L
.46194 .02293 L
.46307 .01845 L
.46429 .01556 L
.46544 .01472 L
.46649 .01555 L
.46772 .01846 L
.46841 .02102 L
.46906 .02398 L
.47024 .03081 L
.4715 .04002 L
.47423 .06631 L
.47681 .09773 L
.48163 .16758 L
.48592 .23275 L
.49045 .29354 L
.49281 .31859 L
.49407 .32941 L
.49541 .33892 L
.49665 .34563 L
.49778 .34997 L
.49891 .35258 L
.49998 .35341 L
.50112 .35253 L
.50235 .34957 L
.50351 .34488 L
.50457 .33902 L
.50704 .31998 L
.50963 .2926 L
.51988 .14459 L
.52414 .08553 L
.52647 .05876 L
.52868 .03861 L
.52993 .02972 L
.53059 .02583 L
.53129 .02233 L
.53252 .01773 L
.53366 .01534 L
.5348 .01474 L
.53587 .01582 L
.53704 .01882 L
.5383 .02412 L
.53964 .03201 L
.54085 .04108 L
.54355 .06746 L
.54843 .13136 L
.55373 .21257 L
.55652 .25428 L
.55947 .2939 L
Mistroke
.56204 .32276 L
.5634 .33532 L
.56486 .34641 L
.56621 .3543 L
.56743 .35946 L
.56866 .36266 L
.56982 .36381 L
.571 .36311 L
.57225 .36032 L
.57331 .35631 L
.57449 .35019 L
.57575 .34173 L
.57711 .33054 L
.57957 .30539 L
.58997 .15801 L
.59504 .08781 L
.59724 .06264 L
.59964 .04064 L
.60094 .03126 L
.60215 .0244 L
.6033 .01952 L
.60452 .01619 L
.6058 .01475 L
.607 .01534 L
.60831 .01813 L
.60905 .02067 L
.60972 .02358 L
.61113 .03147 L
.61243 .04087 L
.61538 .06897 L
.62075 .13919 L
.62971 .27735 L
.63442 .34019 L
.63678 .36531 L
.63938 .38644 L
.64076 .39472 L
.64152 .39833 L
.64224 .40113 L
.64291 .40318 L
.64364 .40479 L
.64491 .40609 L
.64619 .40544 L
.64684 .40437 L
.64755 .40261 L
.64881 .39808 L
.64999 .3922 L
.6525 .37475 L
.6548 .35343 L
.65997 .2907 L
.66916 .15736 L
Mistroke
.67421 .0915 L
.67668 .06497 L
.67896 .04496 L
.68025 .03571 L
.68167 .02742 L
.68309 .02112 L
.68387 .01858 L
.6846 .01677 L
.68589 .01496 L
.68706 .01485 L
.68771 .01543 L
.68842 .01658 L
.68971 .02002 L
.6909 .02477 L
.69222 .03172 L
.69489 .051 L
.69736 .07465 L
.69968 .10136 L
.71817 .39027 L
.72323 .46461 L
.72864 .52924 L
.73126 .55383 L
.73374 .57259 L
.73597 .58565 L
.73713 .59103 L
.73838 .59571 L
.73963 .59925 L
.74079 .60156 L
.7415 .6025 L
.74218 .60306 L
.74345 .60327 L
.74409 .60296 L
.74478 .60233 L
.74601 .60043 L
.74677 .59879 L
.74748 .59693 L
.74881 .59265 L
.75122 .58235 L
.75343 .57024 L
.75843 .53504 L
.77953 .32922 L
.78864 .2438 L
.79839 .16855 L
.804 .13396 L
.8091 .10779 L
.81394 .0873 L
.81907 .06969 L
.8238 .05675 L
.82902 .04557 L
.83376 .03772 L
Mistroke
.8382 .03201 L
.84343 .02693 L
.84821 .02349 L
.85085 .022 L
.85373 .02063 L
.85898 .01873 L
.86153 .01802 L
.86428 .01739 L
.86671 .01692 L
.86928 .01652 L
.8716 .01621 L
.87415 .01593 L
.87863 .01555 L
.88137 .01538 L
.88386 .01525 L
.88655 .01514 L
.88947 .01504 L
.89217 .01497 L
.89467 .01492 L
.89724 .01488 L
.8996 .01485 L
.90422 .0148 L
.90665 .01478 L
.90921 .01477 L
.91353 .01475 L
.91597 .01474 L
.91825 .01474 L
.92093 .01473 L
.92346 .01473 L
.92573 .01472 L
.9282 .01472 L
.93089 .01472 L
.93374 .01472 L
.93617 .01472 L
.93884 .01472 L
.94115 .01472 L
.94366 .01472 L
.94604 .01472 L
.94824 .01472 L
.95039 .01472 L
.95241 .01472 L
.95473 .01472 L
.95684 .01472 L
.9592 .01472 L
.96169 .01472 L
.96381 .01472 L
.96614 .01472 L
.96865 .01472 L
.97134 .01472 L
.97388 .01472 L
Mistroke
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.10"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.2.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Generalized Laguerre polynomials", "TB"],
  " ",
  StyleBox["LaguerreL[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " are related to hydrogen atom wave functions in quantum mechanics. They \
satisfy the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "+", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], "+", "1", "-", 
              StyleBox["x",
                "TI"]}], ")"}], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "+", 
          StyleBox["n",
            "TI"], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", and the orthogonality relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%\[Infinity]\), 
          SubsuperscriptBox[
            StyleBox["L",
              "TI"], 
            StyleBox["m",
              "TI"], 
            StyleBox["a",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SubsuperscriptBox[
            StyleBox["L",
              "TI"], 
            StyleBox["n",
              "TI"], 
            StyleBox["a",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SuperscriptBox[
            StyleBox["x",
              "TI"], 
            StyleBox["a",
              "TI"]], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["x",
                "TI"]}]], "\[DifferentialD]", 
          StyleBox["x",
            "TI"], " ", \(\(=\)\(\ \)\), "0"}], TraditionalForm]], 
    "InlineFormula"],
  " for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "\[NotEqual]", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". The ",
  StyleBox["Laguerre polynomials", "TB"],
  " ",
  StyleBox["LaguerreL[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " correspond to the special case ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["a",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.10", "10.19"}],

Cell[TextData[{
  StyleBox["Jacobi polynomials", "TB"],
  " ",
  StyleBox["JacobiP[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " occur in studies of the rotation group, particularly in quantum \
mechanics. They satisfy the orthogonality relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\(-1\)\%1\), 
          SubsuperscriptBox[
            StyleBox["P",
              "TI"], 
            StyleBox["m",
              "TI"], 
            RowBox[{"(", 
              RowBox[{
                StyleBox["a",
                  "TI"], ",", 
                StyleBox["b",
                  "TI"]}], ")"}]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SubsuperscriptBox[
            StyleBox["P",
              "TI"], 
            StyleBox["n",
              "TI"], 
            RowBox[{"(", 
              RowBox[{
                StyleBox["a",
                  "TI"], ",", 
                StyleBox["b",
                  "TI"]}], ")"}]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                StyleBox["x",
                  "TI"]}], ")"}], 
            StyleBox["a",
              "TI"]], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "+", 
                StyleBox["x",
                  "TI"]}], ")"}], 
            StyleBox["b",
              "TI"]], "\[DifferentialD]", 
          StyleBox["x",
            "TI"], " ", \(\(=\)\(\ \)\), "0"}], TraditionalForm]], 
    "InlineFormula"],
  " for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "\[NotEqual]", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". Legendre, Gegenbauer and Chebyshev polynomials can all be viewed as \
special cases of Jacobi polynomials. The Jacobi polynomials are sometimes \
given in the alternative form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["G",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["p",
                "TI"], ",", 
              StyleBox["q",
                "TI"], ",", 
              StyleBox["x",
                "TI"]}], ")"}], "=", 
          RowBox[{
            StyleBox["n",
              "TI"], \(\(!\)\(\ \)\), "\[CapitalGamma]", 
            RowBox[{"(", 
              RowBox[{
                StyleBox["n",
                  "TI"], "+", 
                StyleBox["p",
                  "TI"]}], ")"}]}], "/", 
          RowBox[{"\[CapitalGamma]", 
            RowBox[{"(", 
              RowBox[{"2", 
                StyleBox["n",
                  "TI"], "+", 
                StyleBox["p",
                  "TI"]}], ")"}]}], " ", 
          SubsuperscriptBox[
            StyleBox["P",
              "TI"], 
            StyleBox["n",
              "TI"], 
            RowBox[{"(", 
              RowBox[{
                StyleBox["p",
                  "TI"], "-", 
                StyleBox["q",
                  "TI"], ",", 
                StyleBox["q",
                  "TI"], "-", "1"}], ")"}]], 
          RowBox[{"(", 
            RowBox[{"2", 
              StyleBox["x",
                "TI"], "-", "1"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.10", "10.20"}],

Cell[TextData[{
  "You can get formulas for generalized Laguerre polynomials with arbitrary \
values of ",
  StyleBox["a", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.10", "10.21"}],

Cell[CellGroupData[{

Cell["LaguerreL[2, a, x]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.2.10"],

Cell[BoxData[
    \(1\/2\ \((2 + 3\ a + a\^2 - 4\ x - 2\ a\ x + x\^2)\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.2.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2.11 Special Functions", "Subsection",
  CellTags->{"S3.2.11", "11.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " includes all the common special functions of mathematical physics found \
in standard handbooks. We will discuss each of the various classes of \
functions in turn.  "
}], "Text",
  CellTags->{"S3.2.11", "11.2"}],

Cell[TextData[{
  "One point you should realize is that in the technical literature there are \
often several conflicting definitions of any particular special function. \
When you use a special function in ",
  StyleBox["Mathematica", "TI"],
  ", therefore, you should be sure to look at the definition given here to \
confirm that it is exactly what you want. "
}], "Text",
  CellTags->{"S3.2.11", "11.3"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " gives exact results for some values of special functions. "
}], "MathCaption",
  CellTags->{"S3.2.11", "11.4"}],

Cell[CellGroupData[{

Cell["Gamma[15/2]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.2.11"],

Cell[BoxData[
    \(\(135135\ \@\[Pi]\)\/128\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.2.11"]
}, Open  ]],

Cell["No exact result is known here. ", "MathCaption",
  CellTags->{"S3.2.11", "11.5"}],

Cell[CellGroupData[{

Cell["Gamma[15/7]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.2.11"],

Cell[BoxData[
    \(Gamma[15\/7]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.2.11"]
}, Open  ]],

Cell["\<\
A numerical result, to arbitrary precision, can nevertheless be \
found. \
\>", "MathCaption",
  CellTags->{"S3.2.11", "11.6"}],

Cell[CellGroupData[{

Cell["N[%, 40]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.2.11"],

Cell[BoxData[
    \(1.069071500448624397994137689702693267366715948961591012082`40. \)], \
"Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.2.11"]
}, Open  ]],

Cell["You can give complex arguments to special functions. ", "MathCaption",
  CellTags->{"S3.2.11", "11.7"}],

Cell[CellGroupData[{

Cell["Gamma[3 + 4I] //N", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.2.11"],

Cell[BoxData[
    \(\(\(0.005225538471369119`\)\(\[InvisibleSpace]\)\) - 
      0.17254707929430008`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.2.11"]
}, Open  ]],

Cell["\<\
Special functions automatically get applied to each element in a \
list. \
\>", "MathCaption",
  CellTags->{"S3.2.11", "11.8"}],

Cell[CellGroupData[{

Cell["Gamma[{3/2, 5/2, 7/2}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.2.11"],

Cell[BoxData[
    \({\@\[Pi]\/2, \(3\ \@\[Pi]\)\/4, \(15\ \@\[Pi]\)\/8}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.2.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " knows analytical properties of special functions, such as derivatives. "
}], "MathCaption",
  CellTags->{"S3.2.11", "11.9"}],

Cell[CellGroupData[{

Cell["D[Gamma[x], {x, 2}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.2.11"],

Cell[BoxData[
    \(Gamma[x]\ PolyGamma[0, x]\^2 + Gamma[x]\ PolyGamma[1, x]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.2.11"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["FindRoot", "MR"],
  " to find roots of special functions. "
}], "MathCaption",
  CellTags->{"S3.2.11", "11.10"}],

Cell[CellGroupData[{

Cell["FindRoot[ BesselJ[0, x], {x, 1} ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.2.11"],

Cell[BoxData[
    \({x \[Rule] 2.404825557695773`}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.2.11"]
}, Open  ]],

Cell[TextData[{
  "Special functions in ",
  StyleBox["Mathematica", "TI"],
  " can usually be evaluated for arbitrary complex values of their arguments. \
Often, however, the defining relations given below apply only for some \
special choices of arguments. In these cases, the full function corresponds \
to a suitable extension or \[OpenCurlyDoubleQuote]analytic continuation\
\[CloseCurlyDoubleQuote] of these defining relations. Thus, for example, \
integral representations of functions are valid only when the integral \
exists, but the functions themselves can usually be defined elsewhere by \
analytic continuation. "
}], "Text",
  CellTags->{"S3.2.11", "11.11"}],

Cell[TextData[{
  "As a simple example of how the domain of a function can be extended, \
consider the function represented by the sum ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          SuperscriptBox[
            StyleBox["x",
              "TI"], 
            StyleBox["k",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". This sum converges only when ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[VerticalSeparator]", 
          StyleBox["x",
            "TI"], "\[VerticalSeparator]", "<", "1"}], TraditionalForm]], 
    "InlineFormula"],
  ". Nevertheless, it is easy to show analytically that for any ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", the complete function is equal to ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", 
              StyleBox["x",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". Using this form, you can easily find a value of the function for any ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", at least so long as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "\[NotEqual]", "1"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.12"}],

Cell[CellGroupData[{

Cell["Gamma and Related Functions", "Subsubsection",
  CellTags->{"S3.2.11", "11.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Beta[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Euler beta function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[CapitalBeta]", 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["a",
                            "TI"], ",", 
                          StyleBox["b",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Beta[", "MR"],
              StyleBox["z", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "incomplete beta function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox["\[CapitalBeta]", 
                        StyleBox["z",
                          "TI"]], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["a",
                            "TI"], ",", 
                          StyleBox["b",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["BetaRegularized[", "MR"],
              StyleBox["z", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "regularized incomplete beta function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["I",
                        "TI"], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["z",
                            "TI"], ",", 
                          StyleBox["a",
                            "TI"], ",", 
                          StyleBox["b",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Gamma[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Euler gamma function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[CapitalGamma]", 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Gamma[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "incomplete gamma function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[CapitalGamma]", 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["a",
                            "TI"], ",", 
                          StyleBox["z",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Gamma[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generalized incomplete gamma function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[CapitalGamma]", 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["a",
                            "TI"], ",", 
                          SubscriptBox[
                            StyleBox["z",
                              "TI"], "0"]}], ")"}], "-", "\[CapitalGamma]", 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["a",
                            "TI"], ",", 
                          SubscriptBox[
                            StyleBox["z",
                              "TI"], "1"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["GammaRegularized[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "regularized incomplete gamma function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["Q",
                        "TI"], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["a",
                            "TI"], ",", 
                          StyleBox["z",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InverseBetaRegularized[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["inverse beta function "]},
          {Cell[TextData[{
              StyleBox["InverseGammaRegularized[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["inverse gamma function "]},
          {Cell[TextData[{
              StyleBox["Pochhammer[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Pochhammer symbol ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      RowBox[{"(", 
                        StyleBox["a",
                          "TI"], ")"}], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PolyGamma[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "digamma function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Psi]", 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PolyGamma[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " derivative of the digamma function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SuperscriptBox["\[Psi]", 
                        RowBox[{"(", 
                          StyleBox["n",
                            "TI"], ")"}]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.11"],

Cell["Gamma and related functions.", "Caption",
  CellTags->"S3.2.11"],

Cell[TextData[{
  "The ",
  StyleBox["Euler gamma function", "TB"],
  " ",
  StyleBox["Gamma[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is defined by the integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalGamma]", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", \(\[Integral]\_0\%\[Infinity]\), 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            RowBox[{
              StyleBox["z",
                "TI"], "-", "1"}]], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["t",
                "TI"]}]], 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". For positive integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalGamma]", 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}], "=", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], "-", "1"}], ")"}], \(\(!\)\(\ \)\)}], 
        TraditionalForm]], "InlineFormula"],
  ". ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalGamma]", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " can be viewed as a generalization of the factorial function, valid for \
complex arguments ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.2.11", "11.14"}],

Cell[TextData[{
  "There are some computations, particularly in number theory, where the \
logarithm of the gamma function often appears. For positive real arguments, \
you can evaluate this simply as ",
  StyleBox["Log[Gamma[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]]", "MR"],
  ". For complex arguments, however, this form yields spurious \
discontinuities. ",
  StyleBox["Mathematica", "TI"],
  " therefore includes the separate function ",
  StyleBox["LogGamma[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  ", which yields the ",
  StyleBox["logarithm of the gamma function", "TB"],
  " with a single branch cut along the negative real axis.  "
}], "Text",
  CellTags->{"S3.2.11", "11.15"}],

Cell[TextData[{
  "The ",
  StyleBox["Euler beta function", "TB"],
  " ",
  StyleBox["Beta[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " is ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalBeta]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}], "=", 
          RowBox[{"\[CapitalGamma]", 
            RowBox[{"(", 
              StyleBox["a",
                "TI"], ")"}], "\[CapitalGamma]", 
            RowBox[{"(", 
              StyleBox["b",
                "TI"], ")"}]}], "/", 
          RowBox[{"\[CapitalGamma]", 
            RowBox[{"(", 
              RowBox[{
                StyleBox["a",
                  "TI"], "+", 
                StyleBox["b",
                  "TI"]}], ")"}]}], "=", \(\[Integral]\_0\%1\), 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            RowBox[{
              StyleBox["a",
                "TI"], "-", "1"}]], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                StyleBox["t",
                  "TI"]}], ")"}], 
            RowBox[{
              StyleBox["b",
                "TI"], "-", "1"}]], 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.16"}],

Cell[TextData[{
  "The ",
  StyleBox["Pochhammer symbol", "TB"],
  " or ",
  StyleBox["rising factorial", "TB"],
  " ",
  StyleBox["Pochhammer[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " is ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            RowBox[{"(", 
              StyleBox["a",
                "TI"], ")"}], 
            StyleBox["n",
              "TI"]], "=", 
          StyleBox["a",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], "+", "1"}], ")"}], "\[Ellipsis]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], "+", 
              StyleBox["n",
                "TI"], "-", "1"}], ")"}], "=", 
          RowBox[{"\[CapitalGamma]", 
            RowBox[{"(", 
              RowBox[{
                StyleBox["a",
                  "TI"], "+", 
                StyleBox["n",
                  "TI"]}], ")"}]}], "/", 
          RowBox[{"\[CapitalGamma]", 
            RowBox[{"(", 
              StyleBox["a",
                "TI"], ")"}]}]}], TraditionalForm]], "InlineFormula"],
  ". It often appears in series expansions for hypergeometric functions. Note \
that the Pochhammer symbol has a definite value even when the gamma functions \
which appear in its definition are infinite.   "
}], "Text",
  CellTags->{"S3.2.11", "11.17"}],

Cell[TextData[{
  "The ",
  StyleBox["incomplete gamma function", "TB"],
  " ",
  StyleBox["Gamma[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is defined by the integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalGamma]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["z",
                "TI"]}], ")"}], "=", 
          SubsuperscriptBox["\[Integral]", 
            StyleBox["z",
              "TI"], "\[Infinity]"], 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            RowBox[{
              StyleBox["a",
                "TI"], "-", "1"}]], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["t",
                "TI"]}]], 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " includes a generalized incomplete gamma function ",
  StyleBox["Gamma[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["z",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["z",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox["]", "MR"],
  " defined as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox["\[Integral]", 
            SubscriptBox[
              StyleBox["z",
                "TI"], "0"], 
            SubscriptBox[
              StyleBox["z",
                "TI"], "1"]], 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            RowBox[{
              StyleBox["a",
                "TI"], "-", "1"}]], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["t",
                "TI"]}]], 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.18"}],

Cell[TextData[{
  "The alternative incomplete gamma function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Gamma]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " can therefore be obtained in ",
  StyleBox["Mathematica", "TI"],
  " as ",
  StyleBox["Gamma[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["0,", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.19"}],

Cell[TextData[{
  "The ",
  StyleBox["incomplete beta function", "TB"],
  " ",
  StyleBox["Beta[", "MR"],
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[CapitalBeta]", 
            StyleBox["z",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}], "=", 
          SubsuperscriptBox["\[Integral]", "0", 
            StyleBox["z",
              "TI"]], 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            RowBox[{
              StyleBox["a",
                "TI"], "-", "1"}]], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                StyleBox["t",
                  "TI"]}], ")"}], 
            RowBox[{
              StyleBox["b",
                "TI"], "-", "1"}]], 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". Notice that in the incomplete beta function, the parameter ",
  StyleBox["z", "TI"],
  " is an ",
  StyleBox["upper", "TI"],
  " limit of integration, and appears as the ",
  StyleBox["first", "TI"],
  " argument of the function. In the incomplete gamma function, on the other \
hand, ",
  StyleBox["z", "TI"],
  " is a ",
  StyleBox["lower", "TI"],
  " limit of integration, and appears as the ",
  StyleBox["second", "TI"],
  " argument of the function.  "
}], "Text",
  CellTags->{"S3.2.11", "11.20"}],

Cell[TextData[{
  "In certain cases, it is convenient not to compute the incomplete beta and \
gamma functions on their own, but instead to compute ",
  StyleBox["regularized forms", "TI"],
  " in which these functions are divided by complete beta and gamma \
functions. ",
  StyleBox["Mathematica", "TI"],
  " includes the ",
  StyleBox["regularized incomplete beta function", "TB"],
  " ",
  StyleBox["BetaRegularized[", "MR"],
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " defined for most arguments by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["I",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["z",
                "TI"], ",", 
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}], "=", "\[CapitalBeta]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["z",
                "TI"], ",", 
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}], "/", "\[CapitalBeta]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", but taking into account singular cases. ",
  StyleBox["Mathematica", "TI"],
  " also includes the ",
  StyleBox["regularized incomplete gamma function", "TB"],
  " ",
  StyleBox["GammaRegularized[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " defined by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Q",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["z",
                "TI"]}], ")"}], "=", "\[CapitalGamma]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["z",
                "TI"]}], ")"}], "/", "\[CapitalGamma]", 
          RowBox[{"(", 
            StyleBox["a",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", with singular cases taken into account. "
}], "Text",
  CellTags->{"S3.2.11", "11.21"}],

Cell[TextData[{
  "The incomplete beta and gamma functions, and their inverses, are common in \
statistics. The ",
  StyleBox["inverse beta function", "TB"],
  " ",
  StyleBox["InverseBetaRegularized[", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " is the solution for ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  " in ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["s",
            "TI"], "=", 
          StyleBox["I",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["z",
                "TI"], ",", 
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". The ",
  StyleBox["inverse gamma function", "TB"],
  " ",
  StyleBox["InverseGammaRegularized[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["s", "TI"],
  StyleBox["]", "MR"],
  " is similarly the solution for ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  " in ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["s",
            "TI"], "=", 
          StyleBox["Q",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.22"}],

Cell[TextData[{
  "Derivatives of the gamma function often appear in summing rational series. \
The ",
  StyleBox["digamma function", "TB"],
  " ",
  StyleBox["PolyGamma[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is the logarithmic derivative of the gamma function, given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Psi]", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          RowBox[{\(\[CapitalGamma]\^\[Prime]\), 
            RowBox[{"(", 
              StyleBox["z",
                "TI"], ")"}]}], "/", 
          RowBox[{"\[CapitalGamma]", 
            RowBox[{"(", 
              StyleBox["z",
                "TI"], ")"}]}]}], TraditionalForm]], "InlineFormula"],
  ". For integer arguments, the digamma function satisfies the relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Psi]", 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}], "=", "-", "\[Gamma]", "+", 
          SubscriptBox[
            StyleBox["H",
              "TI"], 
            RowBox[{
              StyleBox["n",
                "TI"], "-", "1"}]]}], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)], "InlineFormula"],
  " is Euler's constant (",
  StyleBox["EulerGamma", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ") and ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " are the harmonic numbers.   "
}], "Text",
  CellTags->{"S3.2.11", "11.23"}],

Cell[TextData[{
  "The ",
  StyleBox["polygamma functions", "TB"],
  " ",
  StyleBox["PolyGamma[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " are given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["\[Psi]", 
            RowBox[{"(", 
              StyleBox["n",
                "TI"], ")"}]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SuperscriptBox[
            StyleBox["d",
              "TI"], 
            StyleBox["n",
              "TI"]], "\[Psi]", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "/", 
          RowBox[{
            StyleBox["d",
              "TI"], 
            SuperscriptBox[
              StyleBox["z",
                "TI"], 
              StyleBox["n",
                "TI"]]}]}], TraditionalForm]], "InlineFormula"],
  ". Notice that the digamma function corresponds to ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Psi]\^\((0)\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". The general form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["\[Psi]", 
            RowBox[{"(", 
              StyleBox["n",
                "TI"], ")"}]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is the ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            StyleBox["n",
              "TI"], "+", "1"}], ")"}], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  ", not the ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  ", logarithmic derivative of the gamma function. The polygamma functions \
satisfy the relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["\[Psi]", 
            RowBox[{"(", 
              StyleBox["n",
                "TI"], ")"}]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SuperscriptBox[\((\(-1\))\), 
            RowBox[{
              StyleBox["n",
                "TI"], "+", "1"}]], 
          StyleBox["n",
            "TI"], "!", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], "1", "/", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                StyleBox["z",
                  "TI"], "+", 
                StyleBox["k",
                  "TI"]}], ")"}], 
            RowBox[{
              StyleBox["n",
                "TI"], "+", "1"}]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.24"}],

Cell[TextData[{
  "Many exact results for gamma and polygamma functions are built into ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.11", "11.25"}],

Cell[CellGroupData[{

Cell["PolyGamma[6]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.2.11"],

Cell[BoxData[
    \(137\/60 - EulerGamma\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.2.11"]
}, Open  ]],

Cell["\<\
Here is a contour plot of the gamma function in the complex plane. \
\
\>", "MathCaption",
  CellTags->{"S3.2.11", "11.26"}],

Cell[CellGroupData[{

Cell["\<\
ContourPlot[ Abs[Gamma[x + I y]], {x, -3, 3}, {y, -2, 2}, \
PlotPoints->50 ]\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.2.11"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.160256 0.5 0.240385 [
[.01923 -0.0125 -6 -9 ]
[.01923 -0.0125 6 0 ]
[.17949 -0.0125 -6 -9 ]
[.17949 -0.0125 6 0 ]
[.33974 -0.0125 -6 -9 ]
[.33974 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.66026 -0.0125 -3 -9 ]
[.66026 -0.0125 3 0 ]
[.82051 -0.0125 -3 -9 ]
[.82051 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -12 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(-3)] .01923 -0.0125 0 1 Mshowa
.17949 0 m
.17949 .00625 L
s
[(-2)] .17949 -0.0125 0 1 Mshowa
.33974 0 m
.33974 .00625 L
s
[(-1)] .33974 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.66026 0 m
.66026 .00625 L
s
[(1)] .66026 -0.0125 0 1 Mshowa
.82051 0 m
.82051 .00625 L
s
[(2)] .82051 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(3)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.05128 0 m
.05128 .00375 L
s
.08333 0 m
.08333 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.14744 0 m
.14744 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.24359 0 m
.24359 .00375 L
s
.27564 0 m
.27564 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.37179 0 m
.37179 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.4359 0 m
.4359 .00375 L
s
.46795 0 m
.46795 .00375 L
s
.53205 0 m
.53205 .00375 L
s
.5641 0 m
.5641 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.62821 0 m
.62821 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.72436 0 m
.72436 .00375 L
s
.75641 0 m
.75641 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.85256 0 m
.85256 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.91667 0 m
.91667 .00375 L
s
.94872 0 m
.94872 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-2)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(-1)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(1)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(2)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.17949 .99375 m
.17949 1 L
s
.33974 .99375 m
.33974 1 L
s
.5 .99375 m
.5 1 L
s
.66026 .99375 m
.66026 1 L
s
.82051 .99375 m
.82051 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.05128 .99625 m
.05128 1 L
s
.08333 .99625 m
.08333 1 L
s
.11538 .99625 m
.11538 1 L
s
.14744 .99625 m
.14744 1 L
s
.21154 .99625 m
.21154 1 L
s
.24359 .99625 m
.24359 1 L
s
.27564 .99625 m
.27564 1 L
s
.30769 .99625 m
.30769 1 L
s
.37179 .99625 m
.37179 1 L
s
.40385 .99625 m
.40385 1 L
s
.4359 .99625 m
.4359 1 L
s
.46795 .99625 m
.46795 1 L
s
.53205 .99625 m
.53205 1 L
s
.5641 .99625 m
.5641 1 L
s
.59615 .99625 m
.59615 1 L
s
.62821 .99625 m
.62821 1 L
s
.69231 .99625 m
.69231 1 L
s
.72436 .99625 m
.72436 1 L
s
.75641 .99625 m
.75641 1 L
s
.78846 .99625 m
.78846 1 L
s
.85256 .99625 m
.85256 1 L
s
.88462 .99625 m
.88462 1 L
s
.91667 .99625 m
.91667 1 L
s
.94872 .99625 m
.94872 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.3 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.2 g
.01923 .45161 m
.01999 .45094 L
.03885 .45003 L
.04404 .45094 L
.05848 .45606 L
.0781 .46001 L
.0967 .45094 L
.09772 .45 L
.11644 .43132 L
.11735 .43016 L
.13679 .4117 L
.13697 .41153 L
.15659 .39716 L
.16516 .39207 L
.17622 .3867 L
.19584 .37896 L
.21546 .37246 L
.21548 .37245 L
.23509 .36592 L
.25471 .35847 L
.2683 .35283 L
.27433 .35029 L
.29396 .34211 L
.31358 .33455 L
.31736 .3332 L
.3332 .32811 L
.35283 .32277 L
.37245 .31834 L
.39207 .31457 L
.39762 .31358 L
.4117 .31124 L
.43132 .30828 L
.45094 .30581 L
.47057 .30411 L
.49019 .3035 L
.50981 .30426 L
.52943 .30659 L
.54906 .31059 L
.56013 .31358 L
.56868 .31627 L
.5883 .32352 L
.60793 .33212 L
.61017 .3332 L
.62755 .34169 L
.64717 .35162 L
.64925 .35283 L
.6668 .36101 L
.68642 .36858 L
.7039 .37245 L
.70604 .37267 L
.72041 .37245 L
.72567 .37155 L
.74529 .36397 L
.76155 .35283 L
.76491 .34967 L
.78116 .3332 L
.78454 .32921 L
.79694 .31358 L
.80416 .30353 L
.81074 .29396 L
.82332 .27433 L
.82378 .27358 L
.83509 .25471 L
.84341 .24012 L
.84622 .23509 L
.85687 .21546 L
.86303 .20373 L
.86711 .19584 L
.87704 .17622 L
.88265 .16484 L
.88668 .15659 L
.89608 .13697 L
.90228 .12377 L
.90526 .11735 L
.91427 .09772 L
.9219 .08076 L
.92309 .0781 L
.93177 .05848 L
.9403 .03885 L
.94152 .03601 L
.94871 .01923 L
.01923 .01923 L
F
0 g
.01923 .45161 m
.01999 .45094 L
.03885 .45003 L
.04404 .45094 L
.05848 .45606 L
.0781 .46001 L
.0967 .45094 L
.09772 .45 L
.11644 .43132 L
.11735 .43016 L
.13679 .4117 L
.13697 .41153 L
.15659 .39716 L
.16516 .39207 L
.17622 .3867 L
.19584 .37896 L
.21546 .37246 L
.21548 .37245 L
.23509 .36592 L
.25471 .35847 L
.2683 .35283 L
.27433 .35029 L
.29396 .34211 L
.31358 .33455 L
.31736 .3332 L
.3332 .32811 L
.35283 .32277 L
.37245 .31834 L
.39207 .31457 L
.39762 .31358 L
.4117 .31124 L
.43132 .30828 L
.45094 .30581 L
.47057 .30411 L
.49019 .3035 L
.50981 .30426 L
.52943 .30659 L
.54906 .31059 L
.56013 .31358 L
.56868 .31627 L
.5883 .32352 L
.60793 .33212 L
.61017 .3332 L
.62755 .34169 L
.64717 .35162 L
.64925 .35283 L
.6668 .36101 L
.68642 .36858 L
.7039 .37245 L
.70604 .37267 L
Mistroke
.72041 .37245 L
.72567 .37155 L
.74529 .36397 L
.76155 .35283 L
.76491 .34967 L
.78116 .3332 L
.78454 .32921 L
.79694 .31358 L
.80416 .30353 L
.81074 .29396 L
.82332 .27433 L
.82378 .27358 L
.83509 .25471 L
.84341 .24012 L
.84622 .23509 L
.85687 .21546 L
.86303 .20373 L
.86711 .19584 L
.87704 .17622 L
.88265 .16484 L
.88668 .15659 L
.89608 .13697 L
.90228 .12377 L
.90526 .11735 L
.91427 .09772 L
.9219 .08076 L
.92309 .0781 L
.93177 .05848 L
.9403 .03885 L
.94152 .03601 L
.94871 .01923 L
Mfstroke
.2 g
.01923 .54839 m
.01999 .54906 L
.03885 .54997 L
.04404 .54906 L
.05848 .54394 L
.0781 .53999 L
.0967 .54906 L
.09772 .55 L
.11644 .56868 L
.11735 .56984 L
.13679 .5883 L
.13697 .58847 L
.15659 .60284 L
.16516 .60793 L
.17622 .6133 L
.19584 .62104 L
.21546 .62754 L
.21548 .62755 L
.23509 .63408 L
.25471 .64153 L
.2683 .64717 L
.27433 .64971 L
.29396 .65789 L
.31358 .66545 L
.31736 .6668 L
.3332 .67189 L
.35283 .67723 L
.37245 .68166 L
.39207 .68543 L
.39762 .68642 L
.4117 .68876 L
.43132 .69172 L
.45094 .69419 L
.47057 .69589 L
.49019 .6965 L
.50981 .69574 L
.52943 .69341 L
.54906 .68941 L
.56013 .68642 L
.56868 .68373 L
.5883 .67648 L
.60793 .66788 L
.61017 .6668 L
.62755 .65831 L
.64717 .64838 L
.64925 .64717 L
.6668 .63899 L
.68642 .63142 L
.7039 .62755 L
.70604 .62733 L
.72041 .62755 L
.72567 .62845 L
.74529 .63603 L
.76155 .64717 L
.76491 .65033 L
.78116 .6668 L
.78454 .67079 L
.79694 .68642 L
.80416 .69647 L
.81074 .70604 L
.82332 .72567 L
.82378 .72642 L
.83509 .74529 L
.84341 .75988 L
.84622 .76491 L
.85687 .78454 L
.86303 .79627 L
.86711 .80416 L
.87704 .82378 L
.88265 .83516 L
.88668 .84341 L
.89608 .86303 L
.90228 .87623 L
.90526 .88265 L
.91427 .90228 L
.9219 .91924 L
.92309 .9219 L
.93177 .94152 L
.9403 .96115 L
.94152 .96399 L
.94871 .98077 L
.01923 .98077 L
F
0 g
.01923 .54839 m
.01999 .54906 L
.03885 .54997 L
.04404 .54906 L
.05848 .54394 L
.0781 .53999 L
.0967 .54906 L
.09772 .55 L
.11644 .56868 L
.11735 .56984 L
.13679 .5883 L
.13697 .58847 L
.15659 .60284 L
.16516 .60793 L
.17622 .6133 L
.19584 .62104 L
.21546 .62754 L
.21548 .62755 L
.23509 .63408 L
.25471 .64153 L
.2683 .64717 L
.27433 .64971 L
.29396 .65789 L
.31358 .66545 L
.31736 .6668 L
.3332 .67189 L
.35283 .67723 L
.37245 .68166 L
.39207 .68543 L
.39762 .68642 L
.4117 .68876 L
.43132 .69172 L
.45094 .69419 L
.47057 .69589 L
.49019 .6965 L
.50981 .69574 L
.52943 .69341 L
.54906 .68941 L
.56013 .68642 L
.56868 .68373 L
.5883 .67648 L
.60793 .66788 L
.61017 .6668 L
.62755 .65831 L
.64717 .64838 L
.64925 .64717 L
.6668 .63899 L
.68642 .63142 L
.7039 .62755 L
.70604 .62733 L
Mistroke
.72041 .62755 L
.72567 .62845 L
.74529 .63603 L
.76155 .64717 L
.76491 .65033 L
.78116 .6668 L
.78454 .67079 L
.79694 .68642 L
.80416 .69647 L
.81074 .70604 L
.82332 .72567 L
.82378 .72642 L
.83509 .74529 L
.84341 .75988 L
.84622 .76491 L
.85687 .78454 L
.86303 .79627 L
.86711 .80416 L
.87704 .82378 L
.88265 .83516 L
.88668 .84341 L
.89608 .86303 L
.90228 .87623 L
.90526 .88265 L
.91427 .90228 L
.9219 .91924 L
.92309 .9219 L
.93177 .94152 L
.9403 .96115 L
.94152 .96399 L
.94871 .98077 L
Mfstroke
.1 g
.01923 .42825 m
.03885 .42201 L
.05848 .41785 L
.07761 .4117 L
.0781 .4115 L
.09772 .40088 L
.11089 .39207 L
.11735 .38752 L
.13697 .37412 L
.13955 .37245 L
.15659 .36223 L
.17447 .35283 L
.17622 .35198 L
.19584 .34311 L
.21546 .33484 L
.21939 .3332 L
.23509 .32675 L
.25471 .31851 L
.26636 .31358 L
.27433 .31026 L
.29396 .30226 L
.31358 .29472 L
.31566 .29396 L
.3332 .28789 L
.35283 .28172 L
.37245 .27613 L
.37921 .27433 L
.39207 .2711 L
.4117 .26651 L
.43132 .26236 L
.45094 .25869 L
.47057 .25561 L
.4769 .25471 L
.49019 .2532 L
.50981 .25151 L
.52943 .2505 L
.54906 .25009 L
.56868 .2501 L
.5883 .25025 L
.60793 .2502 L
.62755 .24953 L
.64717 .24773 L
.6668 .24429 L
.68642 .23869 L
.69591 .23509 L
.70604 .23046 L
.72567 .21922 L
.73123 .21546 L
.74529 .20473 L
.75554 .19584 L
.76491 .18687 L
.77516 .17622 L
.78454 .16566 L
.79212 .15659 L
.80416 .14119 L
.80731 .13697 L
.82126 .11735 L
.82378 .11363 L
.83426 .09772 L
.84341 .08317 L
.84652 .0781 L
.85818 .05848 L
.86303 .05004 L
.86934 .03885 L
.88009 .01923 L
.01923 .01923 L
F
0 g
.01923 .42825 m
.03885 .42201 L
.05848 .41785 L
.07761 .4117 L
.0781 .4115 L
.09772 .40088 L
.11089 .39207 L
.11735 .38752 L
.13697 .37412 L
.13955 .37245 L
.15659 .36223 L
.17447 .35283 L
.17622 .35198 L
.19584 .34311 L
.21546 .33484 L
.21939 .3332 L
.23509 .32675 L
.25471 .31851 L
.26636 .31358 L
.27433 .31026 L
.29396 .30226 L
.31358 .29472 L
.31566 .29396 L
.3332 .28789 L
.35283 .28172 L
.37245 .27613 L
.37921 .27433 L
.39207 .2711 L
.4117 .26651 L
.43132 .26236 L
.45094 .25869 L
.47057 .25561 L
.4769 .25471 L
.49019 .2532 L
.50981 .25151 L
.52943 .2505 L
.54906 .25009 L
.56868 .2501 L
.5883 .25025 L
.60793 .2502 L
.62755 .24953 L
.64717 .24773 L
.6668 .24429 L
.68642 .23869 L
.69591 .23509 L
.70604 .23046 L
.72567 .21922 L
.73123 .21546 L
.74529 .20473 L
.75554 .19584 L
Mistroke
.76491 .18687 L
.77516 .17622 L
.78454 .16566 L
.79212 .15659 L
.80416 .14119 L
.80731 .13697 L
.82126 .11735 L
.82378 .11363 L
.83426 .09772 L
.84341 .08317 L
.84652 .0781 L
.85818 .05848 L
.86303 .05004 L
.86934 .03885 L
.88009 .01923 L
Mfstroke
.1 g
.01923 .57175 m
.03885 .57799 L
.05848 .58215 L
.07761 .5883 L
.0781 .5885 L
.09772 .59912 L
.11089 .60793 L
.11735 .61248 L
.13697 .62588 L
.13955 .62755 L
.15659 .63777 L
.17447 .64717 L
.17622 .64802 L
.19584 .65689 L
.21546 .66516 L
.21939 .6668 L
.23509 .67325 L
.25471 .68149 L
.26636 .68642 L
.27433 .68974 L
.29396 .69774 L
.31358 .70528 L
.31566 .70604 L
.3332 .71211 L
.35283 .71828 L
.37245 .72387 L
.37921 .72567 L
.39207 .7289 L
.4117 .73349 L
.43132 .73764 L
.45094 .74131 L
.47057 .74439 L
.4769 .74529 L
.49019 .7468 L
.50981 .74849 L
.52943 .7495 L
.54906 .74991 L
.56868 .7499 L
.5883 .74975 L
.60793 .7498 L
.62755 .75047 L
.64717 .75227 L
.6668 .75571 L
.68642 .76131 L
.69591 .76491 L
.70604 .76954 L
.72567 .78078 L
.73123 .78454 L
.74529 .79527 L
.75554 .80416 L
.76491 .81313 L
.77516 .82378 L
.78454 .83434 L
.79212 .84341 L
.80416 .85881 L
.80731 .86303 L
.82126 .88265 L
.82378 .88637 L
.83426 .90228 L
.84341 .91683 L
.84652 .9219 L
.85818 .94152 L
.86303 .94996 L
.86934 .96115 L
.88009 .98077 L
.01923 .98077 L
F
0 g
.01923 .57175 m
.03885 .57799 L
.05848 .58215 L
.07761 .5883 L
.0781 .5885 L
.09772 .59912 L
.11089 .60793 L
.11735 .61248 L
.13697 .62588 L
.13955 .62755 L
.15659 .63777 L
.17447 .64717 L
.17622 .64802 L
.19584 .65689 L
.21546 .66516 L
.21939 .6668 L
.23509 .67325 L
.25471 .68149 L
.26636 .68642 L
.27433 .68974 L
.29396 .69774 L
.31358 .70528 L
.31566 .70604 L
.3332 .71211 L
.35283 .71828 L
.37245 .72387 L
.37921 .72567 L
.39207 .7289 L
.4117 .73349 L
.43132 .73764 L
.45094 .74131 L
.47057 .74439 L
.4769 .74529 L
.49019 .7468 L
.50981 .74849 L
.52943 .7495 L
.54906 .74991 L
.56868 .7499 L
.5883 .74975 L
.60793 .7498 L
.62755 .75047 L
.64717 .75227 L
.6668 .75571 L
.68642 .76131 L
.69591 .76491 L
.70604 .76954 L
.72567 .78078 L
.73123 .78454 L
.74529 .79527 L
.75554 .80416 L
Mistroke
.76491 .81313 L
.77516 .82378 L
.78454 .83434 L
.79212 .84341 L
.80416 .85881 L
.80731 .86303 L
.82126 .88265 L
.82378 .88637 L
.83426 .90228 L
.84341 .91683 L
.84652 .9219 L
.85818 .94152 L
.86303 .94996 L
.86934 .96115 L
.88009 .98077 L
Mfstroke
.01923 .37053 m
.03885 .3595 L
.0511 .35283 L
.05848 .34882 L
.0781 .33779 L
.08593 .3332 L
.09772 .32626 L
.11735 .3145 L
.11889 .31358 L
.13697 .30299 L
.15281 .29396 L
.15659 .29187 L
.17622 .28128 L
.1895 .27433 L
.19584 .27111 L
.21546 .26128 L
.22881 .25471 L
.23509 .25169 L
.25471 .24233 L
.27018 .23509 L
.27433 .23319 L
.29396 .22436 L
.31358 .21581 L
.31439 .21546 L
.3332 .20764 L
.35283 .19976 L
.36287 .19584 L
.37245 .1922 L
.39207 .18492 L
.4117 .17786 L
.41635 .17622 L
.43132 .17104 L
.45094 .16439 L
.47057 .15785 L
.47438 .15659 L
.49019 .1514 L
.50981 .14489 L
.52943 .13821 L
.533 .13697 L
.54906 .13122 L
.56868 .12371 L
.58402 .11735 L
.5883 .11548 L
.60793 .1063 L
.62436 .09772 L
.62755 .09595 L
.64717 .0842 L
.65645 .0781 L
.6668 .07085 L
.683 .05848 L
.68642 .0557 L
.70578 .03885 L
.70604 .03861 L
.72567 .01946 L
.72589 .01923 L
.01923 .01923 L
F
.01923 .37053 m
.03885 .3595 L
.0511 .35283 L
.05848 .34882 L
.0781 .33779 L
.08593 .3332 L
.09772 .32626 L
.11735 .3145 L
.11889 .31358 L
.13697 .30299 L
.15281 .29396 L
.15659 .29187 L
.17622 .28128 L
.1895 .27433 L
.19584 .27111 L
.21546 .26128 L
.22881 .25471 L
.23509 .25169 L
.25471 .24233 L
.27018 .23509 L
.27433 .23319 L
.29396 .22436 L
.31358 .21581 L
.31439 .21546 L
.3332 .20764 L
.35283 .19976 L
.36287 .19584 L
.37245 .1922 L
.39207 .18492 L
.4117 .17786 L
.41635 .17622 L
.43132 .17104 L
.45094 .16439 L
.47057 .15785 L
.47438 .15659 L
.49019 .1514 L
.50981 .14489 L
.52943 .13821 L
.533 .13697 L
.54906 .13122 L
.56868 .12371 L
.58402 .11735 L
.5883 .11548 L
.60793 .1063 L
.62436 .09772 L
.62755 .09595 L
.64717 .0842 L
.65645 .0781 L
.6668 .07085 L
.683 .05848 L
Mistroke
.68642 .0557 L
.70578 .03885 L
.70604 .03861 L
.72567 .01946 L
.72589 .01923 L
Mfstroke
.01923 .62947 m
.03885 .6405 L
.0511 .64717 L
.05848 .65118 L
.0781 .66221 L
.08593 .6668 L
.09772 .67374 L
.11735 .6855 L
.11889 .68642 L
.13697 .69701 L
.15281 .70604 L
.15659 .70813 L
.17622 .71872 L
.1895 .72567 L
.19584 .72889 L
.21546 .73872 L
.22881 .74529 L
.23509 .74831 L
.25471 .75767 L
.27018 .76491 L
.27433 .76681 L
.29396 .77564 L
.31358 .78419 L
.31439 .78454 L
.3332 .79236 L
.35283 .80024 L
.36287 .80416 L
.37245 .8078 L
.39207 .81508 L
.4117 .82214 L
.41635 .82378 L
.43132 .82896 L
.45094 .83561 L
.47057 .84215 L
.47438 .84341 L
.49019 .8486 L
.50981 .85511 L
.52943 .86179 L
.533 .86303 L
.54906 .86878 L
.56868 .87629 L
.58402 .88265 L
.5883 .88452 L
.60793 .8937 L
.62436 .90228 L
.62755 .90405 L
.64717 .9158 L
.65645 .9219 L
.6668 .92915 L
.683 .94152 L
.68642 .9443 L
.70578 .96115 L
.70604 .96139 L
.72567 .98054 L
.72589 .98077 L
.01923 .98077 L
F
.01923 .62947 m
.03885 .6405 L
.0511 .64717 L
.05848 .65118 L
.0781 .66221 L
.08593 .6668 L
.09772 .67374 L
.11735 .6855 L
.11889 .68642 L
.13697 .69701 L
.15281 .70604 L
.15659 .70813 L
.17622 .71872 L
.1895 .72567 L
.19584 .72889 L
.21546 .73872 L
.22881 .74529 L
.23509 .74831 L
.25471 .75767 L
.27018 .76491 L
.27433 .76681 L
.29396 .77564 L
.31358 .78419 L
.31439 .78454 L
.3332 .79236 L
.35283 .80024 L
.36287 .80416 L
.37245 .8078 L
.39207 .81508 L
.4117 .82214 L
.41635 .82378 L
.43132 .82896 L
.45094 .83561 L
.47057 .84215 L
.47438 .84341 L
.49019 .8486 L
.50981 .85511 L
.52943 .86179 L
.533 .86303 L
.54906 .86878 L
.56868 .87629 L
.58402 .88265 L
.5883 .88452 L
.60793 .8937 L
.62436 .90228 L
.62755 .90405 L
.64717 .9158 L
.65645 .9219 L
.6668 .92915 L
.683 .94152 L
Mistroke
.68642 .9443 L
.70578 .96115 L
.70604 .96139 L
.72567 .98054 L
.72589 .98077 L
Mfstroke
.4 g
.01923 .53448 m
.03885 .53278 L
.04016 .52943 L
.05193 .50981 L
.05193 .49019 L
.04016 .47057 L
.03885 .46722 L
.01923 .46552 L
F
0 g
.01923 .53448 m
.03885 .53278 L
.04016 .52943 L
.05193 .50981 L
.05193 .49019 L
.04016 .47057 L
.03885 .46722 L
.01923 .46552 L
s
.5 g
.01923 .52941 m
.03885 .52033 L
.04245 .50981 L
.04245 .49019 L
.03885 .47967 L
.01923 .47059 L
F
0 g
.01923 .52941 m
.03885 .52033 L
.04245 .50981 L
.04245 .49019 L
.03885 .47967 L
.01923 .47059 L
s
.6 g
.01923 .52727 m
.03768 .50981 L
.03768 .49019 L
.01923 .47273 L
F
0 g
.01923 .52727 m
.03768 .50981 L
.03768 .49019 L
.01923 .47273 L
s
.7 g
.01923 .52526 m
.03421 .50981 L
.03421 .49019 L
.01923 .47474 L
F
0 g
.01923 .52526 m
.03421 .50981 L
.03421 .49019 L
.01923 .47474 L
s
.8 g
.01923 .52334 m
.0314 .50981 L
.0314 .49019 L
.01923 .47666 L
F
0 g
.01923 .52334 m
.0314 .50981 L
.0314 .49019 L
.01923 .47666 L
s
.9 g
.01923 .52146 m
.029 .50981 L
.029 .49019 L
.01923 .47854 L
F
0 g
.01923 .52146 m
.029 .50981 L
.029 .49019 L
.01923 .47854 L
s
1 g
.01923 .51959 m
.0269 .50981 L
.0269 .49019 L
.01923 .48041 L
F
0 g
.01923 .51959 m
.0269 .50981 L
.0269 .49019 L
.01923 .48041 L
s
.4 g
.35283 .34964 m
.37245 .34623 L
.39207 .34359 L
.4117 .34122 L
.43132 .33892 L
.45094 .33687 L
.47057 .33563 L
.49019 .33582 L
.50981 .33804 L
.52943 .34276 L
.54906 .35041 L
.55395 .35283 L
.56868 .36149 L
.58341 .37245 L
.5883 .37663 L
.60361 .39207 L
.60793 .39706 L
.61871 .4117 L
.62755 .42595 L
.63025 .43132 L
.6386 .45094 L
.64426 .47057 L
.64711 .49019 L
.64711 .50981 L
.64426 .52943 L
.6386 .54906 L
.63025 .56868 L
.62755 .57405 L
.61871 .5883 L
.60793 .60294 L
.60361 .60793 L
.5883 .62337 L
.58341 .62755 L
.56868 .63851 L
.55395 .64717 L
.54906 .64959 L
.52943 .65724 L
.50981 .66196 L
.49019 .66418 L
.47057 .66437 L
.45094 .66313 L
.43132 .66108 L
.4117 .65878 L
.39207 .65641 L
.37245 .65377 L
.35283 .65036 L
.33875 .64717 L
.3332 .64561 L
.31358 .63913 L
.29396 .63106 L
.28619 .62755 L
.27433 .62206 L
.25471 .61354 L
.23841 .60793 L
.23509 .60695 L
.21546 .60233 L
.19584 .59801 L
.17622 .59156 L
.16873 .5883 L
.15659 .58043 L
.1431 .56868 L
.13697 .56196 L
.12841 .54906 L
.11746 .52943 L
.11735 .52918 L
.11222 .50981 L
.11222 .49019 L
.11735 .47082 L
.11746 .47057 L
.12841 .45094 L
.13697 .43804 L
.1431 .43132 L
.15659 .41957 L
.16873 .4117 L
.17622 .40844 L
.19584 .40199 L
.21546 .39767 L
.23509 .39305 L
.23841 .39207 L
.25471 .38646 L
.27433 .37794 L
.28619 .37245 L
.29396 .36894 L
.31358 .36087 L
.3332 .35439 L
.33875 .35283 L
F
0 g
.35283 .34964 m
.37245 .34623 L
.39207 .34359 L
.4117 .34122 L
.43132 .33892 L
.45094 .33687 L
.47057 .33563 L
.49019 .33582 L
.50981 .33804 L
.52943 .34276 L
.54906 .35041 L
.55395 .35283 L
.56868 .36149 L
.58341 .37245 L
.5883 .37663 L
.60361 .39207 L
.60793 .39706 L
.61871 .4117 L
.62755 .42595 L
.63025 .43132 L
.6386 .45094 L
.64426 .47057 L
.64711 .49019 L
.64711 .50981 L
.64426 .52943 L
.6386 .54906 L
.63025 .56868 L
.62755 .57405 L
.61871 .5883 L
.60793 .60294 L
.60361 .60793 L
.5883 .62337 L
.58341 .62755 L
.56868 .63851 L
.55395 .64717 L
.54906 .64959 L
.52943 .65724 L
.50981 .66196 L
.49019 .66418 L
.47057 .66437 L
.45094 .66313 L
.43132 .66108 L
.4117 .65878 L
.39207 .65641 L
.37245 .65377 L
.35283 .65036 L
.33875 .64717 L
.3332 .64561 L
.31358 .63913 L
.29396 .63106 L
Mistroke
.28619 .62755 L
.27433 .62206 L
.25471 .61354 L
.23841 .60793 L
.23509 .60695 L
.21546 .60233 L
.19584 .59801 L
.17622 .59156 L
.16873 .5883 L
.15659 .58043 L
.1431 .56868 L
.13697 .56196 L
.12841 .54906 L
.11746 .52943 L
.11735 .52918 L
.11222 .50981 L
.11222 .49019 L
.11735 .47082 L
.11746 .47057 L
.12841 .45094 L
.13697 .43804 L
.1431 .43132 L
.15659 .41957 L
.16873 .4117 L
.17622 .40844 L
.19584 .40199 L
.21546 .39767 L
.23509 .39305 L
.23841 .39207 L
.25471 .38646 L
.27433 .37794 L
.28619 .37245 L
.29396 .36894 L
.31358 .36087 L
.3332 .35439 L
.33875 .35283 L
.35283 .34964 L
Mfstroke
.5 g
.35283 .36926 m
.37245 .36685 L
.39207 .36538 L
.4117 .36393 L
.43132 .36203 L
.45094 .35996 L
.47057 .3586 L
.49019 .35899 L
.50981 .36207 L
.52943 .36865 L
.53738 .37245 L
.54906 .3797 L
.56407 .39207 L
.56868 .39671 L
.58083 .4117 L
.5883 .42325 L
.59249 .43132 L
.60053 .45094 L
.60576 .47057 L
.60793 .48534 L
.6083 .49019 L
.6083 .50981 L
.60793 .51466 L
.60576 .52943 L
.60053 .54906 L
.59249 .56868 L
.5883 .57675 L
.58083 .5883 L
.56868 .60329 L
.56407 .60793 L
.54906 .6203 L
.53738 .62755 L
.52943 .63135 L
.50981 .63793 L
.49019 .64101 L
.47057 .6414 L
.45094 .64004 L
.43132 .63797 L
.4117 .63607 L
.39207 .63462 L
.37245 .63315 L
.35283 .63074 L
.3365 .62755 L
.3332 .62649 L
.31358 .61977 L
.29396 .61073 L
.2886 .60793 L
.27433 .60035 L
.25471 .59107 L
.24766 .5883 L
.23509 .58548 L
.21546 .58343 L
.19584 .58166 L
.17622 .57643 L
.15995 .56868 L
.15659 .56446 L
.14312 .54906 L
.13697 .53966 L
.13383 .52943 L
.12874 .50981 L
.12874 .49019 L
.13383 .47057 L
.13697 .46034 L
.14312 .45094 L
.15659 .43554 L
.15995 .43132 L
.17622 .42357 L
.19584 .41834 L
.21546 .41657 L
.23509 .41452 L
.24766 .4117 L
.25471 .40893 L
.27433 .39965 L
.2886 .39207 L
.29396 .38927 L
.31358 .38023 L
.3332 .37351 L
.3365 .37245 L
F
0 g
.35283 .36926 m
.37245 .36685 L
.39207 .36538 L
.4117 .36393 L
.43132 .36203 L
.45094 .35996 L
.47057 .3586 L
.49019 .35899 L
.50981 .36207 L
.52943 .36865 L
.53738 .37245 L
.54906 .3797 L
.56407 .39207 L
.56868 .39671 L
.58083 .4117 L
.5883 .42325 L
.59249 .43132 L
.60053 .45094 L
.60576 .47057 L
.60793 .48534 L
.6083 .49019 L
.6083 .50981 L
.60793 .51466 L
.60576 .52943 L
.60053 .54906 L
.59249 .56868 L
.5883 .57675 L
.58083 .5883 L
.56868 .60329 L
.56407 .60793 L
.54906 .6203 L
.53738 .62755 L
.52943 .63135 L
.50981 .63793 L
.49019 .64101 L
.47057 .6414 L
.45094 .64004 L
.43132 .63797 L
.4117 .63607 L
.39207 .63462 L
.37245 .63315 L
.35283 .63074 L
.3365 .62755 L
.3332 .62649 L
.31358 .61977 L
.29396 .61073 L
.2886 .60793 L
.27433 .60035 L
.25471 .59107 L
.24766 .5883 L
Mistroke
.23509 .58548 L
.21546 .58343 L
.19584 .58166 L
.17622 .57643 L
.15995 .56868 L
.15659 .56446 L
.14312 .54906 L
.13697 .53966 L
.13383 .52943 L
.12874 .50981 L
.12874 .49019 L
.13383 .47057 L
.13697 .46034 L
.14312 .45094 L
.15659 .43554 L
.15995 .43132 L
.17622 .42357 L
.19584 .41834 L
.21546 .41657 L
.23509 .41452 L
.24766 .4117 L
.25471 .40893 L
.27433 .39965 L
.2886 .39207 L
.29396 .38927 L
.31358 .38023 L
.3332 .37351 L
.3365 .37245 L
.35283 .36926 L
Mfstroke
.6 g
.3332 .38829 m
.35283 .38448 L
.37245 .3831 L
.39207 .38292 L
.4117 .38245 L
.43132 .3808 L
.45094 .37833 L
.47057 .3764 L
.49019 .37658 L
.50981 .38017 L
.52943 .38834 L
.53569 .39207 L
.54906 .40282 L
.55739 .4117 L
.56868 .42744 L
.57084 .43132 L
.57954 .45094 L
.58508 .47057 L
.58779 .49019 L
.58779 .50981 L
.58508 .52943 L
.57954 .54906 L
.57084 .56868 L
.56868 .57256 L
.55739 .5883 L
.54906 .59718 L
.53569 .60793 L
.52943 .61166 L
.50981 .61983 L
.49019 .62342 L
.47057 .6236 L
.45094 .62167 L
.43132 .6192 L
.4117 .61755 L
.39207 .61708 L
.37245 .6169 L
.35283 .61552 L
.3332 .61171 L
.32065 .60793 L
.31358 .60464 L
.29396 .59422 L
.28473 .5883 L
.27433 .58182 L
.25471 .57115 L
.24734 .56868 L
.23509 .56691 L
.21546 .56823 L
.21182 .56868 L
.19584 .56942 L
.1892 .56868 L
.17622 .56544 L
.15659 .55223 L
.15384 .54906 L
.14273 .52943 L
.13727 .50981 L
.13727 .49019 L
.14273 .47057 L
.15384 .45094 L
.15659 .44777 L
.17622 .43456 L
.1892 .43132 L
.19584 .43058 L
.21182 .43132 L
.21546 .43177 L
.23509 .43309 L
.24734 .43132 L
.25471 .42885 L
.27433 .41818 L
.28473 .4117 L
.29396 .40578 L
.31358 .39536 L
.32065 .39207 L
F
0 g
.3332 .38829 m
.35283 .38448 L
.37245 .3831 L
.39207 .38292 L
.4117 .38245 L
.43132 .3808 L
.45094 .37833 L
.47057 .3764 L
.49019 .37658 L
.50981 .38017 L
.52943 .38834 L
.53569 .39207 L
.54906 .40282 L
.55739 .4117 L
.56868 .42744 L
.57084 .43132 L
.57954 .45094 L
.58508 .47057 L
.58779 .49019 L
.58779 .50981 L
.58508 .52943 L
.57954 .54906 L
.57084 .56868 L
.56868 .57256 L
.55739 .5883 L
.54906 .59718 L
.53569 .60793 L
.52943 .61166 L
.50981 .61983 L
.49019 .62342 L
.47057 .6236 L
.45094 .62167 L
.43132 .6192 L
.4117 .61755 L
.39207 .61708 L
.37245 .6169 L
.35283 .61552 L
.3332 .61171 L
.32065 .60793 L
.31358 .60464 L
.29396 .59422 L
.28473 .5883 L
.27433 .58182 L
.25471 .57115 L
.24734 .56868 L
.23509 .56691 L
.21546 .56823 L
.21182 .56868 L
.19584 .56942 L
.1892 .56868 L
Mistroke
.17622 .56544 L
.15659 .55223 L
.15384 .54906 L
.14273 .52943 L
.13727 .50981 L
.13727 .49019 L
.14273 .47057 L
.15384 .45094 L
.15659 .44777 L
.17622 .43456 L
.1892 .43132 L
.19584 .43058 L
.21182 .43132 L
.21546 .43177 L
.23509 .43309 L
.24734 .43132 L
.25471 .42885 L
.27433 .41818 L
.28473 .4117 L
.29396 .40578 L
.31358 .39536 L
.32065 .39207 L
.3332 .38829 L
Mfstroke
.7 g
.47057 .39078 m
.49019 .39045 L
.50131 .39207 L
.50981 .39429 L
.52943 .40394 L
.53938 .4117 L
.54906 .42213 L
.55552 .43132 L
.56552 .45094 L
.56868 .45881 L
.57144 .47057 L
.57415 .49019 L
.57415 .50981 L
.57144 .52943 L
.56868 .54119 L
.56552 .54906 L
.55552 .56868 L
.54906 .57787 L
.53938 .5883 L
.52943 .59606 L
.50981 .60571 L
.50131 .60793 L
.49019 .60955 L
.47057 .60922 L
.46015 .60793 L
.45094 .60638 L
.43132 .60316 L
.4117 .60164 L
.39207 .60229 L
.37245 .60358 L
.35283 .60334 L
.3332 .5999 L
.31358 .59231 L
.30617 .5883 L
.29396 .58016 L
.27964 .56868 L
.27433 .5648 L
.25471 .5516 L
.23509 .54922 L
.21546 .55525 L
.19584 .55962 L
.17622 .55684 L
.1628 .54906 L
.15659 .54239 L
.14996 .52943 L
.14719 .50981 L
.14719 .49019 L
.14996 .47057 L
.15659 .45761 L
.1628 .45094 L
.17622 .44316 L
.19584 .44038 L
.21546 .44475 L
.23509 .45078 L
.25471 .4484 L
.27433 .4352 L
.27964 .43132 L
.29396 .41984 L
.30617 .4117 L
.31358 .40769 L
.3332 .4001 L
.35283 .39666 L
.37245 .39642 L
.39207 .39771 L
.4117 .39836 L
.43132 .39684 L
.45094 .39362 L
.46015 .39207 L
F
0 g
.47057 .39078 m
.49019 .39045 L
.50131 .39207 L
.50981 .39429 L
.52943 .40394 L
.53938 .4117 L
.54906 .42213 L
.55552 .43132 L
.56552 .45094 L
.56868 .45881 L
.57144 .47057 L
.57415 .49019 L
.57415 .50981 L
.57144 .52943 L
.56868 .54119 L
.56552 .54906 L
.55552 .56868 L
.54906 .57787 L
.53938 .5883 L
.52943 .59606 L
.50981 .60571 L
.50131 .60793 L
.49019 .60955 L
.47057 .60922 L
.46015 .60793 L
.45094 .60638 L
.43132 .60316 L
.4117 .60164 L
.39207 .60229 L
.37245 .60358 L
.35283 .60334 L
.3332 .5999 L
.31358 .59231 L
.30617 .5883 L
.29396 .58016 L
.27964 .56868 L
.27433 .5648 L
.25471 .5516 L
.23509 .54922 L
.21546 .55525 L
.19584 .55962 L
.17622 .55684 L
.1628 .54906 L
.15659 .54239 L
.14996 .52943 L
.14719 .50981 L
.14719 .49019 L
.14996 .47057 L
.15659 .45761 L
.1628 .45094 L
Mistroke
.17622 .44316 L
.19584 .44038 L
.21546 .44475 L
.23509 .45078 L
.25471 .4484 L
.27433 .4352 L
.27964 .43132 L
.29396 .41984 L
.30617 .4117 L
.31358 .40769 L
.3332 .4001 L
.35283 .39666 L
.37245 .39642 L
.39207 .39771 L
.4117 .39836 L
.43132 .39684 L
.45094 .39362 L
.46015 .39207 L
.47057 .39078 L
Mfstroke
.8 g
.3332 .40972 m
.35283 .40673 L
.37245 .40769 L
.39207 .41064 L
.39995 .4117 L
.4117 .41262 L
.42763 .4117 L
.43132 .41115 L
.45094 .40686 L
.47057 .40279 L
.49019 .40175 L
.50981 .4057 L
.52424 .4117 L
.52943 .41667 L
.54366 .43132 L
.54906 .43921 L
.55491 .45094 L
.56142 .47057 L
.56458 .49019 L
.56458 .50981 L
.56142 .52943 L
.55491 .54906 L
.54906 .56079 L
.54366 .56868 L
.52943 .58333 L
.52424 .5883 L
.50981 .5943 L
.49019 .59825 L
.47057 .59721 L
.45094 .59314 L
.43132 .58885 L
.42763 .5883 L
.4117 .58738 L
.39995 .5883 L
.39207 .58936 L
.37245 .59231 L
.35283 .59327 L
.3332 .59028 L
.32472 .5883 L
.31358 .58199 L
.29509 .56868 L
.29396 .56771 L
.27586 .54906 L
.27433 .5478 L
.25665 .52943 L
.25471 .52821 L
.2354 .52943 L
.23509 .52968 L
.21546 .5438 L
.20603 .54906 L
.19584 .55188 L
.17622 .55046 L
.17279 .54906 L
.15659 .53399 L
.15466 .52943 L
.1506 .50981 L
.1506 .49019 L
.15466 .47057 L
.15659 .46601 L
.17279 .45094 L
.17622 .44954 L
.19584 .44812 L
.20603 .45094 L
.21546 .4562 L
.23509 .47032 L
.2354 .47057 L
.25471 .47179 L
.25665 .47057 L
.27433 .4522 L
.27586 .45094 L
.29396 .43229 L
.29509 .43132 L
.31358 .41801 L
.32472 .4117 L
F
0 g
.3332 .40972 m
.35283 .40673 L
.37245 .40769 L
.39207 .41064 L
.39995 .4117 L
.4117 .41262 L
.42763 .4117 L
.43132 .41115 L
.45094 .40686 L
.47057 .40279 L
.49019 .40175 L
.50981 .4057 L
.52424 .4117 L
.52943 .41667 L
.54366 .43132 L
.54906 .43921 L
.55491 .45094 L
.56142 .47057 L
.56458 .49019 L
.56458 .50981 L
.56142 .52943 L
.55491 .54906 L
.54906 .56079 L
.54366 .56868 L
.52943 .58333 L
.52424 .5883 L
.50981 .5943 L
.49019 .59825 L
.47057 .59721 L
.45094 .59314 L
.43132 .58885 L
.42763 .5883 L
.4117 .58738 L
.39995 .5883 L
.39207 .58936 L
.37245 .59231 L
.35283 .59327 L
.3332 .59028 L
.32472 .5883 L
.31358 .58199 L
.29509 .56868 L
.29396 .56771 L
.27586 .54906 L
.27433 .5478 L
.25665 .52943 L
.25471 .52821 L
.2354 .52943 L
.23509 .52968 L
.21546 .5438 L
.20603 .54906 L
Mistroke
.19584 .55188 L
.17622 .55046 L
.17279 .54906 L
.15659 .53399 L
.15466 .52943 L
.1506 .50981 L
.1506 .49019 L
.15466 .47057 L
.15659 .46601 L
.17279 .45094 L
.17622 .44954 L
.19584 .44812 L
.20603 .45094 L
.21546 .4562 L
.23509 .47032 L
.2354 .47057 L
.25471 .47179 L
.25665 .47057 L
.27433 .4522 L
.27586 .45094 L
.29396 .43229 L
.29509 .43132 L
.31358 .41801 L
.32472 .4117 L
.3332 .40972 L
Mfstroke
.9 g
.17622 .4571 m
.19584 .4546 L
.21546 .46757 L
.21788 .47057 L
.22667 .49019 L
.22667 .50981 L
.21788 .52943 L
.21546 .53243 L
.19584 .5454 L
.17622 .5429 L
.15796 .52943 L
.15659 .52655 L
.15301 .50981 L
.15301 .49019 L
.15659 .47345 L
.15796 .47057 L
F
0 g
.17622 .4571 m
.19584 .4546 L
.21546 .46757 L
.21788 .47057 L
.22667 .49019 L
.22667 .50981 L
.21788 .52943 L
.21546 .53243 L
.19584 .5454 L
.17622 .5429 L
.15796 .52943 L
.15659 .52655 L
.15301 .50981 L
.15301 .49019 L
.15659 .47345 L
.15796 .47057 L
.17622 .4571 L
s
1 g
.17622 .46158 m
.19584 .46023 L
.20885 .47057 L
.21546 .4804 L
.21831 .49019 L
.21831 .50981 L
.21546 .5196 L
.20885 .52943 L
.19584 .53977 L
.17622 .53842 L
.1612 .52943 L
.15659 .51923 L
.15493 .50981 L
.15493 .49019 L
.15659 .48077 L
.1612 .47057 L
F
0 g
.17622 .46158 m
.19584 .46023 L
.20885 .47057 L
.21546 .4804 L
.21831 .49019 L
.21831 .50981 L
.21546 .5196 L
.20885 .52943 L
.19584 .53977 L
.17622 .53842 L
.1612 .52943 L
.15659 .51923 L
.15493 .50981 L
.15493 .49019 L
.15659 .48077 L
.1612 .47057 L
.17622 .46158 L
s
.9 g
.49019 .411 m
.49684 .4117 L
.50981 .41501 L
.52943 .42735 L
.53346 .43132 L
.54679 .45094 L
.54906 .45529 L
.55381 .47057 L
.55697 .49019 L
.55697 .50981 L
.55381 .52943 L
.54906 .54471 L
.54679 .54906 L
.53346 .56868 L
.52943 .57265 L
.50981 .58499 L
.49684 .5883 L
.49019 .589 L
.47779 .5883 L
.47057 .58705 L
.45094 .58138 L
.43132 .57557 L
.4117 .57405 L
.39207 .57767 L
.37245 .58257 L
.35283 .58483 L
.3332 .58215 L
.31358 .57319 L
.30726 .56868 L
.29396 .5562 L
.2893 .54906 L
.27552 .52943 L
.27433 .52725 L
.26823 .50981 L
.26823 .49019 L
.27433 .47275 L
.27552 .47057 L
.2893 .45094 L
.29396 .4438 L
.30726 .43132 L
.31358 .42681 L
.3332 .41785 L
.35283 .41517 L
.37245 .41743 L
.39207 .42233 L
.4117 .42595 L
.43132 .42443 L
.45094 .41862 L
.47057 .41295 L
.47779 .4117 L
F
0 g
.49019 .411 m
.49684 .4117 L
.50981 .41501 L
.52943 .42735 L
.53346 .43132 L
.54679 .45094 L
.54906 .45529 L
.55381 .47057 L
.55697 .49019 L
.55697 .50981 L
.55381 .52943 L
.54906 .54471 L
.54679 .54906 L
.53346 .56868 L
.52943 .57265 L
.50981 .58499 L
.49684 .5883 L
.49019 .589 L
.47779 .5883 L
.47057 .58705 L
.45094 .58138 L
.43132 .57557 L
.4117 .57405 L
.39207 .57767 L
.37245 .58257 L
.35283 .58483 L
.3332 .58215 L
.31358 .57319 L
.30726 .56868 L
.29396 .5562 L
.2893 .54906 L
.27552 .52943 L
.27433 .52725 L
.26823 .50981 L
.26823 .49019 L
.27433 .47275 L
.27552 .47057 L
.2893 .45094 L
.29396 .4438 L
.30726 .43132 L
.31358 .42681 L
.3332 .41785 L
.35283 .41517 L
.37245 .41743 L
.39207 .42233 L
.4117 .42595 L
.43132 .42443 L
.45094 .41862 L
.47057 .41295 L
.47779 .4117 L
Mistroke
.49019 .411 L
Mfstroke
1 g
.3332 .42471 m
.35283 .42243 L
.37245 .42601 L
.38642 .43132 L
.39207 .43317 L
.4117 .43887 L
.43132 .4372 L
.44646 .43132 L
.45094 .42937 L
.47057 .42183 L
.49019 .41892 L
.50981 .42286 L
.52655 .43132 L
.52943 .43653 L
.53977 .45094 L
.54807 .47057 L
.54906 .47401 L
.55142 .49019 L
.55142 .50981 L
.54906 .52599 L
.54807 .52943 L
.53977 .54906 L
.52943 .56347 L
.52655 .56868 L
.50981 .57714 L
.49019 .58108 L
.47057 .57817 L
.45094 .57063 L
.44646 .56868 L
.43132 .5628 L
.4117 .56113 L
.39207 .56683 L
.38642 .56868 L
.37245 .57399 L
.35283 .57757 L
.3332 .57529 L
.31817 .56868 L
.31358 .56554 L
.2971 .54906 L
.29396 .54531 L
.28548 .52943 L
.27995 .50981 L
.27995 .49019 L
.28548 .47057 L
.29396 .45469 L
.2971 .45094 L
.31358 .43446 L
.31817 .43132 L
F
0 g
.3332 .42471 m
.35283 .42243 L
.37245 .42601 L
.38642 .43132 L
.39207 .43317 L
.4117 .43887 L
.43132 .4372 L
.44646 .43132 L
.45094 .42937 L
.47057 .42183 L
.49019 .41892 L
.50981 .42286 L
.52655 .43132 L
.52943 .43653 L
.53977 .45094 L
.54807 .47057 L
.54906 .47401 L
.55142 .49019 L
.55142 .50981 L
.54906 .52599 L
.54807 .52943 L
.53977 .54906 L
.52943 .56347 L
.52655 .56868 L
.50981 .57714 L
.49019 .58108 L
.47057 .57817 L
.45094 .57063 L
.44646 .56868 L
.43132 .5628 L
.4117 .56113 L
.39207 .56683 L
.38642 .56868 L
.37245 .57399 L
.35283 .57757 L
.3332 .57529 L
.31817 .56868 L
.31358 .56554 L
.2971 .54906 L
.29396 .54531 L
.28548 .52943 L
.27995 .50981 L
.27995 .49019 L
.28548 .47057 L
.29396 .45469 L
.2971 .45094 L
.31358 .43446 L
.31817 .43132 L
.3332 .42471 L
s
.4 g
.98077 .95023 m
.97749 .94152 L
.97013 .9219 L
.96276 .90228 L
.96115 .898 L
.95535 .88265 L
.94791 .86303 L
.94152 .84626 L
.94044 .84341 L
.93297 .82378 L
.92549 .80416 L
.9219 .79474 L
.91802 .78454 L
.91058 .76491 L
.90317 .74529 L
.90228 .74292 L
.89584 .72567 L
.8886 .70604 L
.88265 .68967 L
.88149 .68642 L
.8746 .6668 L
.86795 .64717 L
.86303 .63198 L
.86165 .62755 L
.85584 .60793 L
.8506 .5883 L
.84609 .56868 L
.84341 .55481 L
.84251 .54906 L
.84003 .52943 L
.83875 .50981 L
.83875 .49019 L
.84003 .47057 L
.84251 .45094 L
.84341 .44519 L
.84609 .43132 L
.8506 .4117 L
.85584 .39207 L
.86165 .37245 L
.86303 .36802 L
.86795 .35283 L
.8746 .3332 L
.88149 .31358 L
.88265 .31033 L
.8886 .29396 L
.89584 .27433 L
.90228 .25708 L
.90317 .25471 L
.91058 .23509 L
.91802 .21546 L
.9219 .20526 L
.92549 .19584 L
.93297 .17622 L
.94044 .15659 L
.94152 .15374 L
.94791 .13697 L
.95535 .11735 L
.96115 .102 L
.96276 .09772 L
.97013 .0781 L
.97749 .05848 L
.98077 .04977 L
F
0 g
.98077 .95023 m
.97749 .94152 L
.97013 .9219 L
.96276 .90228 L
.96115 .898 L
.95535 .88265 L
.94791 .86303 L
.94152 .84626 L
.94044 .84341 L
.93297 .82378 L
.92549 .80416 L
.9219 .79474 L
.91802 .78454 L
.91058 .76491 L
.90317 .74529 L
.90228 .74292 L
.89584 .72567 L
.8886 .70604 L
.88265 .68967 L
.88149 .68642 L
.8746 .6668 L
.86795 .64717 L
.86303 .63198 L
.86165 .62755 L
.85584 .60793 L
.8506 .5883 L
.84609 .56868 L
.84341 .55481 L
.84251 .54906 L
.84003 .52943 L
.83875 .50981 L
.83875 .49019 L
.84003 .47057 L
.84251 .45094 L
.84341 .44519 L
.84609 .43132 L
.8506 .4117 L
.85584 .39207 L
.86165 .37245 L
.86303 .36802 L
.86795 .35283 L
.8746 .3332 L
.88149 .31358 L
.88265 .31033 L
.8886 .29396 L
.89584 .27433 L
.90228 .25708 L
.90317 .25471 L
.91058 .23509 L
.91802 .21546 L
Mistroke
.9219 .20526 L
.92549 .19584 L
.93297 .17622 L
.94044 .15659 L
.94152 .15374 L
.94791 .13697 L
.95535 .11735 L
.96115 .102 L
.96276 .09772 L
.97013 .0781 L
.97749 .05848 L
.98077 .04977 L
Mfstroke
.5 g
.98077 .85266 m
.97771 .84341 L
.97131 .82378 L
.96501 .80416 L
.96115 .79198 L
.9588 .78454 L
.95271 .76491 L
.94674 .74529 L
.94152 .72766 L
.94094 .72567 L
.93537 .70604 L
.93003 .68642 L
.92497 .6668 L
.9219 .65422 L
.92026 .64717 L
.91595 .62755 L
.91209 .60793 L
.90874 .5883 L
.90596 .56868 L
.90382 .54906 L
.90237 .52943 L
.90228 .52778 L
.90163 .50981 L
.90163 .49019 L
.90228 .47222 L
.90237 .47057 L
.90382 .45094 L
.90596 .43132 L
.90874 .4117 L
.91209 .39207 L
.91595 .37245 L
.92026 .35283 L
.9219 .34578 L
.92497 .3332 L
.93003 .31358 L
.93537 .29396 L
.94094 .27433 L
.94152 .27234 L
.94674 .25471 L
.95271 .23509 L
.9588 .21546 L
.96115 .20802 L
.96501 .19584 L
.97131 .17622 L
.97771 .15659 L
.98077 .14734 L
F
0 g
.98077 .85266 m
.97771 .84341 L
.97131 .82378 L
.96501 .80416 L
.96115 .79198 L
.9588 .78454 L
.95271 .76491 L
.94674 .74529 L
.94152 .72766 L
.94094 .72567 L
.93537 .70604 L
.93003 .68642 L
.92497 .6668 L
.9219 .65422 L
.92026 .64717 L
.91595 .62755 L
.91209 .60793 L
.90874 .5883 L
.90596 .56868 L
.90382 .54906 L
.90237 .52943 L
.90228 .52778 L
.90163 .50981 L
.90163 .49019 L
.90228 .47222 L
.90237 .47057 L
.90382 .45094 L
.90596 .43132 L
.90874 .4117 L
.91209 .39207 L
.91595 .37245 L
.92026 .35283 L
.9219 .34578 L
.92497 .3332 L
.93003 .31358 L
.93537 .29396 L
.94094 .27433 L
.94152 .27234 L
.94674 .25471 L
.95271 .23509 L
.9588 .21546 L
.96115 .20802 L
.96501 .19584 L
.97131 .17622 L
.97771 .15659 L
.98077 .14734 L
s
.6 g
.98077 .75301 m
.97874 .74529 L
.97376 .72567 L
.96902 .70604 L
.96454 .68642 L
.96115 .67061 L
.96036 .6668 L
.9565 .64717 L
.953 .62755 L
.94991 .60793 L
.94726 .5883 L
.94509 .56868 L
.94342 .54906 L
.9423 .52943 L
.94173 .50981 L
.94173 .49019 L
.9423 .47057 L
.94342 .45094 L
.94509 .43132 L
.94726 .4117 L
.94991 .39207 L
.953 .37245 L
.9565 .35283 L
.96036 .3332 L
.96115 .32939 L
.96454 .31358 L
.96902 .29396 L
.97376 .27433 L
.97874 .25471 L
.98077 .24699 L
F
0 g
.98077 .75301 m
.97874 .74529 L
.97376 .72567 L
.96902 .70604 L
.96454 .68642 L
.96115 .67061 L
.96036 .6668 L
.9565 .64717 L
.953 .62755 L
.94991 .60793 L
.94726 .5883 L
.94509 .56868 L
.94342 .54906 L
.9423 .52943 L
.94173 .50981 L
.94173 .49019 L
.9423 .47057 L
.94342 .45094 L
.94509 .43132 L
.94726 .4117 L
.94991 .39207 L
.953 .37245 L
.9565 .35283 L
.96036 .3332 L
.96115 .32939 L
.96454 .31358 L
.96902 .29396 L
.97376 .27433 L
.97874 .25471 L
.98077 .24699 L
s
.7 g
.98077 .62423 m
.97857 .60793 L
.97628 .5883 L
.97443 .56868 L
.97302 .54906 L
.97207 .52943 L
.97159 .50981 L
.97159 .49019 L
.97207 .47057 L
.97302 .45094 L
.97443 .43132 L
.97628 .4117 L
.97857 .39207 L
.98077 .37577 L
F
0 g
.98077 .62423 m
.97857 .60793 L
.97628 .5883 L
.97443 .56868 L
.97302 .54906 L
.97207 .52943 L
.97159 .50981 L
.97159 .49019 L
.97207 .47057 L
.97302 .45094 L
.97443 .43132 L
.97628 .4117 L
.97857 .39207 L
.98077 .37577 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.11"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.2.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Zeta and Related Functions", "Subsubsection",
  CellTags->{"S3.2.11", "11.27"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LerchPhi[", "MR"],
              StyleBox["z", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Lerch's transcendent ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[CapitalPhi]", 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["z",
                            "TI"], ",", 
                          StyleBox["s",
                            "TI"], ",", 
                          StyleBox["a",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PolyLog[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "polylogarithm function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox["Li", 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PolyLog[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["p", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Nielsen generalized polylogarithm function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["S",
                          "TI"], 
                        RowBox[{
                          StyleBox["n",
                            "TI"], ",", 
                          StyleBox["p",
                            "TI"]}]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["RiemannSiegelTheta[", "MR"],
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Riemann\[Hyphen]Siegel function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[CurlyTheta]", 
                      RowBox[{"(", 
                        StyleBox["t",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["RiemannSiegelZ[", "MR"],
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Riemann\[Hyphen]Siegel function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["Z",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["t",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StieltjesGamma[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Stieltjes constants ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox["\[Gamma]", 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Zeta[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Riemann zeta function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Zeta]", 
                      RowBox[{"(", 
                        StyleBox["s",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Zeta[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generalized Riemann zeta function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Zeta]", 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["s",
                            "TI"], ",", 
                          StyleBox["a",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.11"],

Cell["Zeta and related functions. ", "Caption",
  CellTags->"S3.2.11"],

Cell[TextData[{
  "The ",
  StyleBox["Riemann zeta function", "TB"],
  " ",
  StyleBox["Zeta[", "MR"],
  StyleBox["s", "TI"],
  StyleBox["]", "MR"],
  " is defined by the relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Zeta]", 
          RowBox[{"(", 
            StyleBox["s",
              "TI"], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "1"}], "\[Infinity]",
            LimitsPositioning->True], 
          SuperscriptBox[
            StyleBox["k",
              "TI"], 
            RowBox[{"-", 
              StyleBox["s",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  " (for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["s",
            "TI"], ">", "1"}], TraditionalForm]], "InlineFormula"],
  "). Zeta functions with integer arguments arise in evaluating various sums \
and integrals. ",
  StyleBox["Mathematica", "TI"],
  " gives exact results when possible for zeta functions with integer \
arguments.  "
}], "Text",
  CellTags->{"S3.2.11", "11.28"}],

Cell[TextData[{
  "There is an analytic continuation of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Zeta]", 
          RowBox[{"(", 
            StyleBox["s",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " for arbitrary complex ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["s",
            "TI"], "\[NotEqual]", "1"}], TraditionalForm]], "InlineFormula"],
  ". The zeta function for complex arguments is central to \
number\[Hyphen]theoretical studies of the distribution of primes. Of \
particular importance are the values on the critical line ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Re", " ", 
          StyleBox["s",
            "TI"], "=", \(1\/2\)}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.29"}],

Cell[TextData[{
  "In studying ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Zeta]", 
          RowBox[{"(", 
            RowBox[{\(1\/2\), "+", 
              StyleBox["i",
                "TI"], 
              StyleBox["t",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", it is often convenient to define the two analytic ",
  StyleBox["Riemann\[Hyphen]Siegel functions", "TB"],
  " ",
  StyleBox["RiemannSiegelZ[", "MR"],
  StyleBox["t", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["RiemannSiegelTheta[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " according to ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Z",
            "TI"], 
          RowBox[{"(", 
            StyleBox["t",
              "TI"], ")"}], "=", 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{
              StyleBox["i",
                "TI"], "\[CurlyTheta]", 
              RowBox[{"(", 
                StyleBox["t",
                  "TI"], ")"}]}]], "\[Zeta]", 
          RowBox[{"(", 
            RowBox[{\(1\/2\), "+", 
              StyleBox["i",
                "TI"], 
              StyleBox["t",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CurlyTheta]", 
          RowBox[{"(", 
            StyleBox["t",
              "TI"], ")"}], "=", "Im", " ", "log", "\[CapitalGamma]", 
          RowBox[{"(", 
            RowBox[{\(1\/4\), "+", 
              StyleBox["i",
                "TI"], 
              StyleBox["t",
                "TI"], "/", "2"}], ")"}], "-", 
          StyleBox["t",
            "TI"], " ", \(log(\[Pi])\), "/", "2"}], TraditionalForm]], 
    "InlineFormula"],
  " (for ",
  Cell[BoxData[
      FormBox[
        StyleBox["t",
          "TI"], TraditionalForm]], "InlineFormula"],
  " real). Note that the Riemann\[Hyphen]Siegel functions are both real as \
long as ",
  Cell[BoxData[
      FormBox[
        StyleBox["t",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is real. "
}], "Text",
  CellTags->{"S3.2.11", "11.30"}],

Cell[TextData[{
  "The ",
  StyleBox["Stieltjes constants", "TB"],
  " ",
  StyleBox["StieltjesGamma[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " are generalizations of Euler's constant which appear in the series \
expansion of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Zeta]", 
          RowBox[{"(", 
            StyleBox["s",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " around its pole at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["s",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  "; the coefficient of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"1", "-", 
              StyleBox["s",
                "TI"]}], ")"}], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " is ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Gamma]", 
            StyleBox["n",
              "TI"]], "/", 
          StyleBox["n",
            "TI"], \(\(!\)\(\ \)\)}], TraditionalForm]], "InlineFormula"],
  ". Euler's constant is ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_0\)], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.31"}],

Cell[TextData[{
  "The ",
  StyleBox["generalized Riemann zeta function", "TB"],
  " or ",
  StyleBox["Hurwitz zeta function", "TB"],
  " ",
  StyleBox["Zeta[", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox["]", "MR"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Zeta]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["s",
                "TI"], ",", 
              StyleBox["a",
                "TI"]}], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                StyleBox["k",
                  "TI"], "+", 
                StyleBox["a",
                  "TI"]}], ")"}], 
            RowBox[{"-", 
              StyleBox["s",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  ", where any term with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k",
            "TI"], "+", 
          StyleBox["a",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  " is excluded.  "
}], "Text",
  CellTags->{"S3.2.11", "11.32"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " gives exact results for ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Zeta]", 
          RowBox[{"(", 
            RowBox[{"2", 
              StyleBox["n",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.11", "11.33"}],

Cell[CellGroupData[{

Cell["Zeta[6]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.2.11"],

Cell[BoxData[
    \(\[Pi]\^6\/945\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.2.11"]
}, Open  ]],

Cell["\<\
Here is a three\[Hyphen]dimensional picture of the Riemann zeta \
function in the complex plane. \
\>", "MathCaption",
  CellTags->{"S3.2.11", "11.34"}],

Cell[CellGroupData[{

Cell["Plot3D[ Abs[ Zeta[x + I y] ], {x, -3, 3}, {y, 2, 35}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.2.11"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
3.19569e-17 1.04977 -0.0679587 1.04977 [
[.12586 .2075 -12 -8.99448 ]
[.12586 .2075 0 .00552 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.56094 .0364 -5.16972 -9 ]
[.56094 .0364 .83028 0 ]
[.78078 .11744 0 -6.14207 ]
[.78078 .11744 12 2.85793 ]
[.869 .25253 0 -6.01325 ]
[.869 .25253 12 2.98675 ]
[.94655 .3713 0 -5.90318 ]
[.94655 .3713 12 3.09682 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.0122 .33978 -12 -2.80549 ]
[.0122 .33978 0 6.19451 ]
[-0.00031 .41816 -12 -2.87213 ]
[-0.00031 .41816 0 6.12787 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.13514 .21677 m
.13978 .22141 L
s
[(-2)] .12586 .2075 1 .99877 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.56863 .04703 m
.57247 .05235 L
s
[(2)] .56094 .0364 .72324 1 Mshowa
.125 Mabswid
.18558 .19702 m
.18832 .19985 L
s
.23703 .17687 m
.23971 .17975 L
s
.28951 .15632 m
.29214 .15925 L
s
.39772 .11395 m
.40023 .11699 L
s
.4535 .09211 m
.45595 .0952 L
s
.51046 .06981 m
.51284 .07294 L
s
.08568 .23614 m
.08851 .23887 L
s
.62804 .02377 m
.63027 .02701 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.76845 .12194 m
.76229 .12419 L
s
[(10)] .78078 .11744 -1 .3649 Mshowa
.85656 .25671 m
.85034 .25881 L
s
[(20)] .869 .25253 -1 .33628 Mshowa
.93402 .37521 m
.92776 .37716 L
s
[(30)] .94655 .3713 -1 .31182 Mshowa
.125 Mabswid
.78703 .15035 m
.78332 .15168 L
s
.80511 .17801 m
.8014 .17932 L
s
.82271 .20494 m
.81899 .20623 L
s
.83986 .23116 m
.83613 .23244 L
s
.87284 .28162 m
.8691 .28285 L
s
.88871 .30589 m
.88497 .30711 L
s
.90419 .32957 m
.90044 .33077 L
s
.91929 .35267 m
.91554 .35385 L
s
.74936 .09273 m
.74567 .0941 L
s
.72972 .06269 m
.72604 .06408 L
s
.70952 .0318 m
.70585 .03321 L
s
.94841 .39721 m
.94464 .39836 L
s
.96245 .41869 m
.95868 .41983 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02448 .33515 m
.03062 .33284 L
s
[(10)] .0122 .33978 1 -0.37656 Mshowa
.01203 .41369 m
.0182 .41146 L
s
[(20)] -0.00031 .41816 1 -0.36175 Mshowa
.125 Mabswid
.03401 .27501 m
.03768 .27359 L
s
.03166 .28983 m
.03534 .28842 L
s
.02929 .30479 m
.03297 .30339 L
s
.0269 .3199 m
.03058 .3185 L
s
.02204 .35055 m
.02573 .34918 L
s
.01957 .36611 m
.02327 .36474 L
s
.01709 .38181 m
.02078 .38045 L
s
.01457 .39767 m
.01827 .39632 L
s
.00947 .42987 m
.01318 .42854 L
s
.00688 .44621 m
.01059 .44489 L
s
.00426 .46272 m
.00798 .46141 L
s
.00162 .47939 m
.00534 .4781 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.645 .763 .934 r
.38427 .80015 .39787 .81114 .42053 .8052 .40705 .79412 Metetra
.645 .763 .934 r
.40705 .79412 .42053 .8052 .44337 .79922 .43002 .78805 Metetra
.645 .763 .934 r
.43002 .78805 .44337 .79922 .46642 .79319 .45318 .78192 Metetra
.645 .763 .934 r
.45318 .78192 .46642 .79319 .48965 .78711 .47655 .77574 Metetra
.645 .763 .934 r
.47655 .77574 .48965 .78711 .51309 .78097 .50012 .7695 Metetra
.778 .786 .86 r
.50012 .7695 .51309 .78097 .53673 .77478 .52389 .75283 Metetra
.889 .705 .648 r
.52389 .75283 .53673 .77478 .56027 .73759 .54734 .67377 Metetra
.748 .564 .646 r
.54734 .67377 .56027 .73759 .58314 .67281 .57035 .62099 Metetra
.732 .567 .668 r
.57035 .62099 .58314 .67281 .6059 .62835 .59327 .58457 Metetra
.716 .571 .69 r
.59327 .58457 .6059 .62835 .62872 .59674 .61625 .55856 Metetra
.701 .576 .712 r
.61625 .55856 .62872 .59674 .65172 .57336 .63939 .5393 Metetra
.687 .582 .733 r
.63939 .5393 .65172 .57336 .67491 .55533 .66275 .5245 Metetra
.675 .59 .752 r
.66275 .5245 .67491 .55533 .69834 .54081 .68635 .51274 Metetra
.665 .599 .771 r
.68635 .51274 .69834 .54081 .72199 .52859 .7102 .50312 Metetra
.658 .612 .791 r
.7102 .50312 .72199 .52859 .74588 .51789 .73431 .49485 Metetra
.656 .63 .812 r
.73431 .49485 .74588 .51789 .77 .5082 .75866 .48726 Metetra
.656 .649 .831 r
.75866 .48726 .77 .5082 .79434 .49917 .78324 .47989 Metetra
.658 .667 .847 r
.78324 .47989 .79434 .49917 .81892 .49057 .80805 .47253 Metetra
.66 .683 .861 r
.80805 .47253 .81892 .49057 .84372 .48225 .83306 .4651 Metetra
.661 .695 .871 r
.83306 .4651 .84372 .48225 .86874 .47411 .8583 .45758 Metetra
.662 .705 .88 r
.8583 .45758 .86874 .47411 .89399 .46606 .88375 .44998 Metetra
.662 .713 .886 r
.88375 .44998 .89399 .46606 .91947 .45808 .90942 .44229 Metetra
.663 .719 .891 r
.90942 .44229 .91947 .45808 .94518 .45011 .93532 .43451 Metetra
.663 .724 .894 r
.93532 .43451 .94518 .45011 .97111 .44214 .96145 .42666 Metetra
.645 .763 .934 r
.37046 .78898 .38427 .80015 .40705 .79412 .39336 .78287 Metetra
.645 .763 .934 r
.39336 .78287 .40705 .79412 .43002 .78805 .41645 .77669 Metetra
.645 .763 .934 r
.41645 .77669 .43002 .78805 .45318 .78192 .43974 .77047 Metetra
.645 .763 .934 r
.43974 .77047 .45318 .78192 .47655 .77574 .46324 .76419 Metetra
.645 .763 .934 r
.46324 .76419 .47655 .77574 .50012 .7695 .48694 .75785 Metetra
.91 .756 .679 r
.48694 .75785 .50012 .7695 .52389 .75283 .51106 .69523 Metetra
.78 .591 .644 r
.51106 .69523 .52389 .75283 .54734 .67377 .53464 .63081 Metetra
.771 .605 .673 r
.53464 .63081 .54734 .67377 .57035 .62099 .55783 .58752 Metetra
.759 .622 .708 r
.55783 .58752 .57035 .62099 .59327 .58457 .58094 .55748 Metetra
.745 .641 .745 r
.58094 .55748 .59327 .58457 .61625 .55856 .60413 .53583 Metetra
.73 .661 .782 r
.60413 .53583 .61625 .55856 .63939 .5393 .62748 .51955 Metetra
.714 .68 .816 r
.62748 .51955 .63939 .5393 .66275 .5245 .65103 .50673 Metetra
.698 .695 .844 r
.65103 .50673 .66275 .5245 .68635 .51274 .6748 .49621 Metetra
.683 .705 .864 r
.6748 .49621 .68635 .51274 .7102 .50312 .69882 .48722 Metetra
.671 .711 .878 r
.69882 .48722 .7102 .50312 .73431 .49485 .72308 .47919 Metetra
.664 .713 .884 r
.72308 .47919 .73431 .49485 .75866 .48726 .74758 .47165 Metetra
.661 .714 .887 r
.74758 .47165 .75866 .48726 .78324 .47989 .7723 .46427 Metetra
.66 .715 .889 r
.7723 .46427 .78324 .47989 .80805 .47253 .79725 .45692 Metetra
.66 .717 .891 r
.79725 .45692 .80805 .47253 .83306 .4651 .82242 .44951 Metetra
.66 .719 .892 r
.82242 .44951 .83306 .4651 .8583 .45758 .84782 .44202 Metetra
.66 .721 .894 r
.84782 .44202 .8583 .45758 .88375 .44998 .87343 .43445 Metetra
.66 .723 .896 r
.87343 .43445 .88375 .44998 .90942 .44229 .89928 .42678 Metetra
.661 .726 .897 r
.89928 .42678 .90942 .44229 .93532 .43451 .92536 .41902 Metetra
.661 .728 .899 r
.92536 .41902 .93532 .43451 .96145 .42666 .95167 .41117 Metetra
.645 .763 .934 r
.35643 .77765 .37046 .78898 .39336 .78287 .37944 .77143 Metetra
.645 .763 .934 r
.37944 .77143 .39336 .78287 .41645 .77669 .40266 .76516 Metetra
.645 .763 .934 r
.40266 .76516 .41645 .77669 .43974 .77047 .42608 .75883 Metetra
.645 .763 .934 r
.42608 .75883 .43974 .77047 .46324 .76419 .44971 .75245 Metetra
.645 .763 .934 r
.44971 .75245 .46324 .76419 .48694 .75785 .47354 .74601 Metetra
.919 .749 .655 r
.47354 .74601 .48694 .75785 .51106 .69523 .49812 .67017 Metetra
.857 .69 .674 r
.49812 .67017 .51106 .69523 .53464 .63081 .52194 .611 Metetra
.845 .714 .718 r
.52194 .611 .53464 .63081 .55783 .58752 .54537 .57046 Metetra
.822 .732 .765 r
.54537 .57046 .55783 .58752 .58094 .55748 .56869 .54175 Metetra
.793 .742 .806 r
.56869 .54175 .58094 .55748 .60413 .53583 .59205 .52066 Metetra
.761 .743 .837 r
.59205 .52066 .60413 .53583 .62748 .51955 .61556 .5045 Metetra
.731 .739 .858 r
.61556 .5045 .62748 .51955 .65103 .50673 .63925 .49158 Metetra
.706 .732 .871 r
.63925 .49158 .65103 .50673 .6748 .49621 .66316 .48091 Metetra
.683 .724 .881 r
.66316 .48091 .6748 .49621 .69882 .48722 .68732 .47197 Metetra
.666 .721 .89 r
.68732 .47197 .69882 .48722 .72308 .47919 .71174 .46425 Metetra
.658 .724 .897 r
.71174 .46425 .72308 .47919 .74758 .47165 .7364 .45702 Metetra
.656 .729 .903 r
.7364 .45702 .74758 .47165 .7723 .46427 .76129 .44982 Metetra
.657 .734 .906 r
.76129 .44982 .7723 .46427 .79725 .45692 .78641 .44251 Metetra
.658 .737 .908 r
.78641 .44251 .79725 .45692 .82242 .44951 .81174 .43509 Metetra
.658 .739 .909 r
.81174 .43509 .82242 .44951 .84782 .44202 .8373 .42754 Metetra
.659 .74 .91 r
.8373 .42754 .84782 .44202 .87343 .43445 .86308 .41987 Metetra
.66 .741 .91 r
.86308 .41987 .87343 .43445 .89928 .42678 .8891 .41209 Metetra
.66 .741 .91 r
.8891 .41209 .89928 .42678 .92536 .41902 .91535 .40421 Metetra
.661 .741 .91 r
.91535 .40421 .92536 .41902 .95167 .41117 .94183 .39623 Metetra
.645 .763 .934 r
.34217 .76612 .35643 .77765 .37944 .77143 .36531 .75981 Metetra
.645 .763 .934 r
.36531 .75981 .37944 .77143 .40266 .76516 .38865 .75343 Metetra
.645 .763 .934 r
.38865 .75343 .40266 .76516 .42608 .75883 .4122 .74701 Metetra
.645 .763 .934 r
.4122 .74701 .42608 .75883 .44971 .75245 .43596 .74052 Metetra
.645 .763 .934 r
.43596 .74052 .44971 .75245 .47354 .74601 .45993 .73398 Metetra
.908 .758 .684 r
.45993 .73398 .47354 .74601 .49812 .67017 .48473 .67326 Metetra
.97 .86 .674 r
.48473 .67326 .49812 .67017 .52194 .611 .509 .61337 Metetra
.954 .913 .735 r
.509 .61337 .52194 .611 .54537 .57046 .53278 .57119 Metetra
.916 .947 .804 r
.53278 .57119 .54537 .57046 .56869 .54175 .55639 .54057 Metetra
.864 .956 .867 r
.55639 .54057 .56869 .54175 .59205 .52066 .58 .51763 Metetra
.808 .944 .914 r
.58 .51763 .59205 .52066 .61556 .5045 .60371 .49987 Metetra
.759 .921 .943 r
.60371 .49987 .61556 .5045 .63925 .49158 .62759 .48564 Metetra
.719 .895 .959 r
.62759 .48564 .63925 .49158 .66316 .48091 .65167 .47388 Metetra
.69 .871 .967 r
.65167 .47388 .66316 .48091 .68732 .47197 .67599 .46381 Metetra
.672 .847 .967 r
.67599 .46381 .68732 .47197 .71174 .46425 .70054 .45484 Metetra
.664 .823 .96 r
.70054 .45484 .71174 .46425 .7364 .45702 .72532 .4465 Metetra
.661 .803 .951 r
.72532 .4465 .7364 .45702 .76129 .44982 .75034 .43845 Metetra
.66 .79 .944 r
.75034 .43845 .76129 .44982 .78641 .44251 .77559 .4305 Metetra
.661 .781 .938 r
.77559 .4305 .78641 .44251 .81174 .43509 .80107 .42255 Metetra
.661 .774 .933 r
.80107 .42255 .81174 .43509 .8373 .42754 .82677 .41456 Metetra
.661 .769 .929 r
.82677 .41456 .8373 .42754 .86308 .41987 .85271 .4065 Metetra
.662 .764 .926 r
.85271 .4065 .86308 .41987 .8891 .41209 .87888 .39836 Metetra
.662 .761 .923 r
.87888 .39836 .8891 .41209 .91535 .40421 .90529 .39016 Metetra
.662 .758 .921 r
.90529 .39016 .91535 .40421 .94183 .39623 .93193 .38187 Metetra
.645 .763 .934 r
.32768 .75442 .34217 .76612 .36531 .75981 .35095 .748 Metetra
.645 .763 .934 r
.35095 .748 .36531 .75981 .38865 .75343 .37442 .74152 Metetra
.645 .763 .934 r
.37442 .74152 .38865 .75343 .4122 .74701 .3981 .73499 Metetra
.645 .763 .934 r
.3981 .73499 .4122 .74701 .43596 .74052 .42198 .7284 Metetra
.645 .763 .934 r
.42198 .7284 .43596 .74052 .45993 .73398 .44609 .72174 Metetra
.883 .772 .735 r
.44609 .72174 .45993 .73398 .48473 .67326 .47096 .67913 Metetra
.977 .882 .671 r
.47096 .67913 .48473 .67326 .509 .61337 .49569 .62004 Metetra
.955 .948 .714 r
.49569 .62004 .509 .61337 .53278 .57119 .51988 .5773 Metetra
.895 .988 .756 r
.51988 .5773 .53278 .57119 .55639 .54057 .54385 .54546 Metetra
.814 .999 .796 r
.54385 .54546 .55639 .54057 .58 .51763 .56776 .52096 Metetra
.74 .992 .837 r
.56776 .52096 .58 .51763 .60371 .49987 .59174 .50148 Metetra
.691 .981 .88 r
.59174 .50148 .60371 .49987 .62759 .48564 .61585 .48544 Metetra
.668 .967 .921 r
.61585 .48544 .62759 .48564 .65167 .47388 .64013 .47177 Metetra
.663 .949 .955 r
.64013 .47177 .65167 .47388 .67599 .46381 .66461 .45974 Metetra
.667 .925 .974 r
.66461 .45974 .67599 .46381 .70054 .45484 .6893 .44885 Metetra
.671 .894 .978 r
.6893 .44885 .70054 .45484 .72532 .4465 .71421 .43874 Metetra
.673 .863 .972 r
.71421 .43874 .72532 .4465 .75034 .43845 .73934 .42916 Metetra
.673 .836 .962 r
.73934 .42916 .75034 .43845 .77559 .4305 .7647 .41995 Metetra
.672 .814 .952 r
.7647 .41995 .77559 .4305 .80107 .42255 .7903 .41097 Metetra
.67 .798 .943 r
.7903 .41097 .80107 .42255 .82677 .41456 .81614 .40215 Metetra
.669 .785 .936 r
.81614 .40215 .82677 .41456 .85271 .4065 .84221 .39342 Metetra
.668 .775 .93 r
.84221 .39342 .85271 .4065 .87888 .39836 .86852 .38474 Metetra
.667 .768 .926 r
.86852 .38474 .87888 .39836 .90529 .39016 .89508 .37607 Metetra
.666 .763 .922 r
.89508 .37607 .90529 .39016 .93193 .38187 .92188 .3674 Metetra
.645 .763 .934 r
.31296 .74252 .32768 .75442 .35095 .748 .33635 .736 Metetra
.645 .763 .934 r
.33635 .736 .35095 .748 .37442 .74152 .35995 .72941 Metetra
.645 .763 .934 r
.35995 .72941 .37442 .74152 .3981 .73499 .38376 .72277 Metetra
.645 .763 .934 r
.38376 .72277 .3981 .73499 .42198 .7284 .40778 .71607 Metetra
.645 .763 .934 r
.40778 .71607 .42198 .7284 .44609 .72174 .43202 .70931 Metetra
.912 .754 .672 r
.43202 .70931 .44609 .72174 .47096 .67913 .45765 .64192 Metetra
.808 .64 .673 r
.45765 .64192 .47096 .67913 .49569 .62004 .48247 .5898 Metetra
.798 .656 .705 r
.48247 .5898 .49569 .62004 .51988 .5773 .50679 .55147 Metetra
.784 .67 .738 r
.50679 .55147 .51988 .5773 .54385 .54546 .53091 .5225 Metetra
.767 .682 .769 r
.53091 .5225 .54385 .54546 .56776 .52096 .55498 .49993 Metetra
.749 .691 .796 r
.55498 .49993 .56776 .52096 .59174 .50148 .57911 .48179 Metetra
.731 .698 .819 r
.57911 .48179 .59174 .50148 .61585 .48544 .60338 .46673 Metetra
.716 .704 .837 r
.60338 .46673 .61585 .48544 .64013 .47177 .62782 .45381 Metetra
.703 .709 .852 r
.62782 .45381 .64013 .47177 .66461 .45974 .65246 .44237 Metetra
.693 .713 .864 r
.65246 .44237 .66461 .45974 .6893 .44885 .67731 .43196 Metetra
.685 .718 .874 r
.67731 .43196 .6893 .44885 .71421 .43874 .70239 .42222 Metetra
.679 .722 .882 r
.70239 .42222 .71421 .43874 .73934 .42916 .7277 .41293 Metetra
.675 .726 .888 r
.7277 .41293 .73934 .42916 .7647 .41995 .75324 .40392 Metetra
.672 .73 .893 r
.75324 .40392 .7647 .41995 .7903 .41097 .77901 .39509 Metetra
.67 .733 .897 r
.77901 .39509 .7903 .41097 .81614 .40215 .80502 .38634 Metetra
.668 .735 .9 r
.80502 .38634 .81614 .40215 .84221 .39342 .83128 .37763 Metetra
.667 .737 .902 r
.83128 .37763 .84221 .39342 .86852 .38474 .85777 .36894 Metetra
.666 .739 .904 r
.85777 .36894 .86852 .38474 .89508 .37607 .88451 .36022 Metetra
.666 .74 .905 r
.88451 .36022 .89508 .37607 .92188 .3674 .9115 .35148 Metetra
.645 .763 .934 r
.298 .73043 .31296 .74252 .33635 .736 .32151 .7238 Metetra
.645 .763 .934 r
.32151 .7238 .33635 .736 .35995 .72941 .34524 .7171 Metetra
.645 .763 .934 r
.34524 .7171 .35995 .72941 .38376 .72277 .36918 .71035 Metetra
.645 .763 .934 r
.36918 .71035 .38376 .72277 .40778 .71607 .39333 .70354 Metetra
.901 .759 .695 r
.39333 .70354 .40778 .71607 .43202 .70931 .41924 .64641 Metetra
.765 .577 .644 r
.41924 .64641 .43202 .70931 .45765 .64192 .44473 .58679 Metetra
.746 .573 .661 r
.44473 .58679 .45765 .64192 .48247 .5898 .46943 .54333 Metetra
.734 .579 .682 r
.46943 .54333 .48247 .5898 .50679 .55147 .49373 .51079 Metetra
.72 .585 .703 r
.49373 .51079 .50679 .55147 .53091 .5225 .51786 .48574 Metetra
.707 .589 .722 r
.51786 .48574 .53091 .5225 .55498 .49993 .54197 .46586 Metetra
.694 .593 .739 r
.54197 .46586 .55498 .49993 .57911 .48179 .56617 .44962 Metetra
.682 .595 .753 r
.56617 .44962 .57911 .48179 .60338 .46673 .5905 .436 Metetra
.67 .597 .765 r
.5905 .436 .60338 .46673 .62782 .45381 .61502 .42442 Metetra
.657 .599 .777 r
.61502 .42442 .62782 .45381 .65246 .44237 .63978 .41481 Metetra
.645 .605 .794 r
.63978 .41481 .65246 .44237 .67731 .43196 .6648 .40686 Metetra
.643 .622 .814 r
.6648 .40686 .67731 .43196 .70239 .42222 .69009 .39948 Metetra
.647 .644 .834 r
.69009 .39948 .70239 .42222 .7277 .41293 .71561 .39203 Metetra
.651 .665 .851 r
.71561 .39203 .7277 .41293 .75324 .40392 .74136 .38435 Metetra
.655 .682 .864 r
.74136 .38435 .75324 .40392 .77901 .39509 .76735 .37645 Metetra
.657 .696 .874 r
.76735 .37645 .77901 .39509 .80502 .38634 .79357 .36836 Metetra
.659 .706 .882 r
.79357 .36836 .80502 .38634 .83128 .37763 .82003 .3601 Metetra
.66 .714 .888 r
.82003 .3601 .83128 .37763 .85777 .36894 .84673 .35169 Metetra
.661 .72 .893 r
.84673 .35169 .85777 .36894 .88451 .36022 .87367 .34316 Metetra
.662 .725 .896 r
.87367 .34316 .88451 .36022 .9115 .35148 .90086 .33452 Metetra
.645 .763 .934 r
.28278 .71814 .298 .73043 .32151 .7238 .30643 .71139 Metetra
.645 .763 .934 r
.30643 .71139 .32151 .7238 .34524 .7171 .33028 .70459 Metetra
.645 .763 .934 r
.33028 .70459 .34524 .7171 .36918 .71035 .35436 .69772 Metetra
.824 .782 .813 r
.35436 .69772 .36918 .71035 .39333 .70354 .3794 .67271 Metetra
.851 .674 .662 r
.3794 .67271 .39333 .70354 .41924 .64641 .4059 .605 Metetra
.791 .623 .673 r
.4059 .605 .41924 .64641 .44473 .58679 .43125 .5559 Metetra
.791 .652 .708 r
.43125 .5559 .44473 .58679 .46943 .54333 .45597 .51941 Metetra
.788 .684 .749 r
.45597 .51941 .46943 .54333 .49373 .51079 .48037 .49158 Metetra
.78 .716 .793 r
.48037 .49158 .49373 .51079 .51786 .48574 .50465 .46976 Metetra
.767 .747 .835 r
.50465 .46976 .51786 .48574 .54197 .46586 .52894 .45215 Metetra
.75 .774 .873 r
.52894 .45215 .54197 .46586 .56617 .44962 .55333 .43752 Metetra
.73 .796 .905 r
.55333 .43752 .56617 .44962 .5905 .436 .57787 .42502 Metetra
.709 .812 .929 r
.57787 .42502 .5905 .436 .61502 .42442 .60259 .41405 Metetra
.689 .82 .946 r
.60259 .41405 .61502 .42442 .63978 .41481 .62753 .40417 Metetra
.674 .814 .95 r
.62753 .40417 .63978 .41481 .6648 .40686 .6527 .39503 Metetra
.668 .794 .942 r
.6527 .39503 .6648 .40686 .69009 .39948 .67811 .38632 Metetra
.665 .773 .93 r
.67811 .38632 .69009 .39948 .71561 .39203 .70375 .37783 Metetra
.663 .758 .921 r
.70375 .37783 .71561 .39203 .74136 .38435 .72964 .36942 Metetra
.662 .749 .914 r
.72964 .36942 .74136 .38435 .76735 .37645 .75576 .36099 Metetra
.662 .743 .91 r
.75576 .36099 .76735 .37645 .79357 .36836 .78214 .35252 Metetra
.662 .74 .908 r
.78214 .35252 .79357 .36836 .82003 .3601 .80875 .34398 Metetra
.662 .738 .906 r
.80875 .34398 .82003 .3601 .84673 .35169 .83562 .33536 Metetra
.662 .737 .905 r
.83562 .33536 .84673 .35169 .87367 .34316 .86273 .32665 Metetra
.662 .736 .905 r
.86273 .32665 .87367 .34316 .90086 .33452 .8901 .31785 Metetra
.645 .763 .934 r
.26732 .70564 .28278 .71814 .30643 .71139 .29109 .69879 Metetra
.645 .763 .934 r
.29109 .69879 .30643 .71139 .33028 .70459 .31508 .69187 Metetra
.645 .763 .934 r
.31508 .69187 .33028 .70459 .35436 .69772 .33928 .68488 Metetra
.897 .758 .699 r
.33928 .68488 .35436 .69772 .3794 .67271 .36599 .62834 Metetra
.797 .621 .663 r
.36599 .62834 .3794 .67271 .4059 .605 .39222 .57225 Metetra
.799 .65 .696 r
.39222 .57225 .4059 .605 .43125 .5559 .41751 .53059 Metetra
.797 .68 .735 r
.41751 .53059 .43125 .5559 .45597 .51941 .44228 .49892 Metetra
.789 .709 .776 r
.44228 .49892 .45597 .51941 .48037 .49158 .4668 .47421 Metetra
.776 .735 .815 r
.4668 .47421 .48037 .49158 .50465 .46976 .49123 .45441 Metetra
.759 .756 .849 r
.49123 .45441 .50465 .46976 .52894 .45215 .51569 .43805 Metetra
.74 .77 .877 r
.51569 .43805 .52894 .45215 .55333 .43752 .54026 .42414 Metetra
.722 .779 .897 r
.54026 .42414 .55333 .43752 .57787 .42502 .56497 .41195 Metetra
.706 .782 .911 r
.56497 .41195 .57787 .42502 .60259 .41405 .58987 .40097 Metetra
.692 .78 .918 r
.58987 .40097 .60259 .41405 .62753 .40417 .61498 .39083 Metetra
.683 .775 .921 r
.61498 .39083 .62753 .40417 .6527 .39503 .64031 .38125 Metetra
.676 .768 .921 r
.64031 .38125 .6527 .39503 .67811 .38632 .66587 .37205 Metetra
.671 .761 .918 r
.66587 .37205 .67811 .38632 .70375 .37783 .69167 .36308 Metetra
.668 .755 .916 r
.69167 .36308 .70375 .37783 .72964 .36942 .71771 .35424 Metetra
.666 .75 .913 r
.71771 .35424 .72964 .36942 .75576 .36099 .74399 .34545 Metetra
.664 .747 .911 r
.74399 .34545 .75576 .36099 .78214 .35252 .77053 .33668 Metetra
.663 .744 .91 r
.77053 .33668 .78214 .35252 .80875 .34398 .79731 .32788 Metetra
.663 .742 .909 r
.79731 .32788 .80875 .34398 .83562 .33536 .82435 .31904 Metetra
.663 .741 .908 r
.82435 .31904 .83562 .33536 .86273 .32665 .85164 .31014 Metetra
.662 .741 .908 r
.85164 .31014 .86273 .32665 .8901 .31785 .87919 .30117 Metetra
.645 .763 .934 r
.2516 .69293 .26732 .70564 .29109 .69879 .27549 .68596 Metetra
.645 .763 .934 r
.27549 .68596 .29109 .69879 .31508 .69187 .29961 .67893 Metetra
.831 .779 .803 r
.29961 .67893 .31508 .69187 .33928 .68488 .3251 .65197 Metetra
.841 .666 .666 r
.3251 .65197 .33928 .68488 .36599 .62834 .35243 .58745 Metetra
.791 .625 .675 r
.35243 .58745 .36599 .62834 .39222 .57225 .37847 .53918 Metetra
.786 .643 .704 r
.37847 .53918 .39222 .57225 .41751 .53059 .40373 .50224 Metetra
.775 .658 .734 r
.40373 .50224 .41751 .53059 .44228 .49892 .42856 .47333 Metetra
.76 .668 .76 r
.42856 .47333 .44228 .49892 .4668 .47421 .45317 .45013 Metetra
.743 .672 .781 r
.45317 .45013 .4668 .47421 .49123 .45441 .47771 .43103 Metetra
.726 .671 .797 r
.47771 .43103 .49123 .45441 .51569 .43805 .50228 .41488 Metetra
.709 .668 .807 r
.50228 .41488 .51569 .43805 .54026 .42414 .52695 .40086 Metetra
.695 .663 .814 r
.52695 .40086 .54026 .42414 .56497 .41195 .55176 .38841 Metetra
.683 .656 .818 r
.55176 .38841 .56497 .41195 .58987 .40097 .57676 .37722 Metetra
.667 .649 .823 r
.57676 .37722 .58987 .40097 .61498 .39083 .60197 .3675 Metetra
.648 .646 .834 r
.60197 .3675 .61498 .39083 .64031 .38125 .62746 .35957 Metetra
.645 .661 .851 r
.62746 .35957 .64031 .38125 .66587 .37205 .6532 .35201 Metetra
.649 .681 .867 r
.6532 .35201 .66587 .37205 .69167 .36308 .67919 .34425 Metetra
.652 .698 .88 r
.67919 .34425 .69167 .36308 .71771 .35424 .70543 .33623 Metetra
.655 .711 .889 r
.70543 .33623 .71771 .35424 .74399 .34545 .73191 .32798 Metetra
.657 .721 .896 r
.73191 .32798 .74399 .34545 .77053 .33668 .75864 .31953 Metetra
.659 .728 .9 r
.75864 .31953 .77053 .33668 .79731 .32788 .78562 .31091 Metetra
.66 .733 .904 r
.78562 .31091 .79731 .32788 .82435 .31904 .81285 .30214 Metetra
.66 .736 .906 r
.81285 .30214 .82435 .31904 .85164 .31014 .84034 .29323 Metetra
.661 .738 .907 r
.84034 .29323 .85164 .31014 .87919 .30117 .86809 .2842 Metetra
.645 .763 .934 r
.2356 .68001 .2516 .69293 .27549 .68596 .25963 .67292 Metetra
.645 .763 .934 r
.25963 .67292 .27549 .68596 .29961 .67893 .28388 .66576 Metetra
.883 .763 .725 r
.28388 .66576 .29961 .67893 .3251 .65197 .31083 .6188 Metetra
.825 .661 .679 r
.31083 .6188 .3251 .65197 .35243 .58745 .33787 .56428 Metetra
.835 .702 .717 r
.33787 .56428 .35243 .58745 .37847 .53918 .36386 .5222 Metetra
.839 .745 .76 r
.36386 .5222 .37847 .53918 .40373 .50224 .38922 .48906 Metetra
.835 .785 .805 r
.38922 .48906 .40373 .50224 .42856 .47333 .4142 .46241 Metetra
.821 .819 .847 r
.4142 .46241 .42856 .47333 .45317 .45013 .43901 .44053 Metetra
.799 .842 .884 r
.43901 .44053 .45317 .45013 .47771 .43103 .46376 .42218 Metetra
.773 .857 .913 r
.46376 .42218 .47771 .43103 .50228 .41488 .48854 .40645 Metetra
.746 .865 .935 r
.48854 .40645 .50228 .41488 .52695 .40086 .51343 .39271 Metetra
.72 .869 .952 r
.51343 .39271 .52695 .40086 .55176 .38841 .53847 .38048 Metetra
.696 .871 .964 r
.53847 .38048 .55176 .38841 .57676 .37722 .56369 .3694 Metetra
.675 .871 .973 r
.56369 .3694 .57676 .37722 .60197 .3675 .58912 .35919 Metetra
.662 .861 .975 r
.58912 .35919 .60197 .3675 .62746 .35957 .61477 .34959 Metetra
.662 .834 .966 r
.61477 .34959 .62746 .35957 .6532 .35201 .64067 .34038 Metetra
.662 .808 .953 r
.64067 .34038 .6532 .35201 .67919 .34425 .66681 .33137 Metetra
.662 .79 .943 r
.66681 .33137 .67919 .34425 .70543 .33623 .69319 .32244 Metetra
.662 .778 .935 r
.69319 .32244 .70543 .33623 .73191 .32798 .71983 .3135 Metetra
.662 .769 .929 r
.71983 .3135 .73191 .32798 .75864 .31953 .74672 .30451 Metetra
.662 .764 .925 r
.74672 .30451 .75864 .31953 .78562 .31091 .77387 .29545 Metetra
.663 .759 .922 r
.77387 .29545 .78562 .31091 .81285 .30214 .80128 .2863 Metetra
.663 .756 .92 r
.80128 .2863 .81285 .30214 .84034 .29323 .82895 .27706 Metetra
.663 .754 .918 r
.82895 .27706 .84034 .29323 .86809 .2842 .85688 .26773 Metetra
.645 .763 .934 r
.21934 .66687 .2356 .68001 .25963 .67292 .2435 .65966 Metetra
.746 .78 .881 r
.2435 .65966 .25963 .67292 .28388 .66576 .26843 .64505 Metetra
.869 .717 .691 r
.26843 .64505 .28388 .66576 .31083 .6188 .29636 .58748 Metetra
.812 .663 .697 r
.29636 .58748 .31083 .6188 .33787 .56428 .32305 .54246 Metetra
.825 .71 .738 r
.32305 .54246 .33787 .56428 .36386 .5222 .34896 .50658 Metetra
.832 .76 .783 r
.34896 .50658 .36386 .5222 .38922 .48906 .37437 .47743 Metetra
.83 .808 .83 r
.37437 .47743 .38922 .48906 .4142 .46241 .3995 .45329 Metetra
.817 .848 .872 r
.3995 .45329 .4142 .46241 .43901 .44053 .4245 .43289 Metetra
.795 .876 .906 r
.4245 .43289 .43901 .44053 .46376 .42218 .44947 .41529 Metetra
.769 .892 .931 r
.44947 .41529 .46376 .42218 .48854 .40645 .47449 .3998 Metetra
.742 .897 .948 r
.47449 .3998 .48854 .40645 .51343 .39271 .49962 .3859 Metetra
.72 .895 .959 r
.49962 .3859 .51343 .39271 .53847 .38048 .52489 .3732 Metetra
.703 .887 .965 r
.52489 .3732 .53847 .38048 .56369 .3694 .55033 .36139 Metetra
.691 .874 .967 r
.55033 .36139 .56369 .3694 .58912 .35919 .57597 .35025 Metetra
.684 .859 .966 r
.57597 .35025 .58912 .35919 .61477 .34959 .60183 .3396 Metetra
.679 .843 .962 r
.60183 .3396 .61477 .34959 .64067 .34038 .62791 .32931 Metetra
.676 .826 .956 r
.62791 .32931 .64067 .34038 .66681 .33137 .65422 .31928 Metetra
.674 .811 .949 r
.65422 .31928 .66681 .33137 .69319 .32244 .68077 .30941 Metetra
.672 .797 .942 r
.68077 .30941 .69319 .32244 .71983 .3135 .70758 .29965 Metetra
.67 .786 .936 r
.70758 .29965 .71983 .3135 .74672 .30451 .73464 .28996 Metetra
.669 .777 .931 r
.73464 .28996 .74672 .30451 .77387 .29545 .76195 .28029 Metetra
.668 .77 .926 r
.76195 .28029 .77387 .29545 .80128 .2863 .78953 .27062 Metetra
.667 .764 .923 r
.78953 .27062 .80128 .2863 .82895 .27706 .81737 .26093 Metetra
.666 .76 .92 r
.81737 .26093 .82895 .27706 .85688 .26773 .84549 .2512 Metetra
.731 .778 .891 r
.20279 .6535 .21934 .66687 .2435 .65966 .22759 .64026 Metetra
.87 .723 .697 r
.22759 .64026 .2435 .65966 .26843 .64505 .25586 .58482 Metetra
.738 .564 .657 r
.25586 .58482 .26843 .64505 .29636 .58748 .28287 .54078 Metetra
.744 .589 .683 r
.28287 .54078 .29636 .58748 .32305 .54246 .30903 .5052 Metetra
.747 .615 .712 r
.30903 .5052 .32305 .54246 .34896 .50658 .33466 .47593 Metetra
.748 .641 .741 r
.33466 .47593 .34896 .50658 .37437 .47743 .35995 .45143 Metetra
.747 .666 .771 r
.35995 .45143 .37437 .47743 .3995 .45329 .38507 .43055 Metetra
.742 .688 .799 r
.38507 .43055 .3995 .45329 .4245 .43289 .41012 .41241 Metetra
.735 .706 .824 r
.41012 .41241 .4245 .43289 .44947 .41529 .43519 .39637 Metetra
.726 .72 .845 r
.43519 .39637 .44947 .41529 .47449 .3998 .46034 .38193 Metetra
.717 .731 .862 r
.46034 .38193 .47449 .3998 .49962 .3859 .48561 .36871 Metetra
.709 .738 .875 r
.48561 .36871 .49962 .3859 .52489 .3732 .51104 .35642 Metetra
.701 .743 .884 r
.51104 .35642 .52489 .3732 .55033 .36139 .53665 .34484 Metetra
.694 .746 .892 r
.53665 .34484 .55033 .36139 .57597 .35025 .56246 .33379 Metetra
.688 .747 .897 r
.56246 .33379 .57597 .35025 .60183 .3396 .58848 .32314 Metetra
.683 .747 .9 r
.58848 .32314 .60183 .3396 .62791 .32931 .61473 .31278 Metetra
.679 .747 .903 r
.61473 .31278 .62791 .32931 .65422 .31928 .64122 .30263 Metetra
.675 .747 .905 r
.64122 .30263 .65422 .31928 .68077 .30941 .66795 .29262 Metetra
.673 .746 .906 r
.66795 .29262 .68077 .30941 .70758 .29965 .69493 .28271 Metetra
.671 .745 .906 r
.69493 .28271 .70758 .29965 .73464 .28996 .72217 .27284 Metetra
.669 .745 .907 r
.72217 .27284 .73464 .28996 .76195 .28029 .74967 .263 Metetra
.668 .744 .907 r
.74967 .263 .76195 .28029 .78953 .27062 .77744 .25315 Metetra
.667 .744 .907 r
.77744 .25315 .78953 .27062 .81737 .26093 .80547 .24329 Metetra
.666 .743 .908 r
.80547 .24329 .81737 .26093 .84549 .2512 .83379 .23338 Metetra
.788 .621 .674 r
.18885 .61041 .20279 .6535 .22759 .64026 .2169 .56084 Metetra
.699 .518 .64 r
.2169 .56084 .22759 .64026 .25586 .58482 .2438 .52068 Metetra
.701 .534 .659 r
.2438 .52068 .25586 .58482 .28287 .54078 .26992 .48763 Metetra
.703 .551 .679 r
.26992 .48763 .28287 .54078 .30903 .5052 .29552 .46001 Metetra
.703 .568 .7 r
.29552 .46001 .30903 .5052 .33466 .47593 .32079 .43657 Metetra
.701 .584 .722 r
.32079 .43657 .33466 .47593 .35995 .45143 .34588 .41635 Metetra
.698 .599 .742 r
.34588 .41635 .35995 .45143 .38507 .43055 .37089 .39863 Metetra
.695 .613 .76 r
.37089 .39863 .38507 .43055 .41012 .41241 .3959 .38287 Metetra
.69 .624 .777 r
.3959 .38287 .41012 .41241 .43519 .39637 .42098 .36864 Metetra
.685 .634 .792 r
.42098 .36864 .43519 .39637 .46034 .38193 .44617 .35561 Metetra
.681 .643 .805 r
.44617 .35561 .46034 .38193 .48561 .36871 .47151 .34353 Metetra
.676 .651 .817 r
.47151 .34353 .48561 .36871 .51104 .35642 .49702 .3322 Metetra
.672 .658 .828 r
.49702 .3322 .51104 .35642 .53665 .34484 .52273 .32145 Metetra
.669 .666 .838 r
.52273 .32145 .53665 .34484 .56246 .33379 .54866 .31115 Metetra
.666 .673 .847 r
.54866 .31115 .56246 .33379 .58848 .32314 .57482 .30118 Metetra
.664 .68 .855 r
.57482 .30118 .58848 .32314 .61473 .31278 .60121 .29143 Metetra
.663 .688 .863 r
.60121 .29143 .61473 .31278 .64122 .30263 .62786 .28182 Metetra
.662 .695 .87 r
.62786 .28182 .64122 .30263 .66795 .29262 .65476 .27226 Metetra
.662 .702 .876 r
.65476 .27226 .66795 .29262 .69493 .28271 .68192 .26272 Metetra
.662 .708 .881 r
.68192 .26272 .69493 .28271 .72217 .27284 .70935 .25315 Metetra
.662 .713 .886 r
.70935 .25315 .72217 .27284 .74967 .263 .73704 .24353 Metetra
.662 .718 .89 r
.73704 .24353 .74967 .263 .77744 .25315 .76501 .23383 Metetra
.662 .722 .893 r
.76501 .23383 .77744 .25315 .80547 .24329 .79325 .22406 Metetra
.662 .725 .896 r
.79325 .22406 .80547 .24329 .83379 .23338 .82177 .2142 Metetra
.689 .513 .644 r
.17833 .53408 .18885 .61041 .2169 .56084 .20489 .49906 Metetra
.694 .532 .664 r
.20489 .49906 .2169 .56084 .2438 .52068 .2308 .46952 Metetra
.698 .552 .685 r
.2308 .46952 .2438 .52068 .26992 .48763 .25627 .44424 Metetra
.7 .572 .707 r
.25627 .44424 .26992 .48763 .29552 .46001 .28146 .4223 Metetra
.701 .59 .729 r
.28146 .4223 .29552 .46001 .32079 .43657 .30649 .40298 Metetra
.7 .607 .749 r
.30649 .40298 .32079 .43657 .34588 .41635 .33145 .38573 Metetra
.697 .621 .768 r
.33145 .38573 .34588 .41635 .37089 .39863 .35642 .37011 Metetra
.694 .633 .783 r
.35642 .37011 .37089 .39863 .3959 .38287 .38144 .35578 Metetra
.689 .641 .796 r
.38144 .35578 .3959 .38287 .42098 .36864 .40657 .34248 Metetra
.685 .647 .806 r
.40657 .34248 .42098 .36864 .44617 .35561 .43183 .32998 Metetra
.68 .65 .813 r
.43183 .32998 .44617 .35561 .47151 .34353 .45725 .31812 Metetra
.675 .651 .818 r
.45725 .31812 .47151 .34353 .49702 .3322 .48285 .3068 Metetra
.669 .65 .822 r
.48285 .3068 .49702 .3322 .52273 .32145 .50865 .29599 Metetra
.66 .646 .826 r
.50865 .29599 .52273 .32145 .54866 .31115 .53467 .28602 Metetra
.647 .645 .834 r
.53467 .28602 .54866 .31115 .57482 .30118 .56094 .27724 Metetra
.644 .656 .846 r
.56094 .27724 .57482 .30118 .60121 .29143 .58748 .26878 Metetra
.647 .671 .859 r
.58748 .26878 .60121 .29143 .62786 .28182 .61428 .26018 Metetra
.65 .684 .869 r
.61428 .26018 .62786 .28182 .65476 .27226 .64135 .25138 Metetra
.653 .695 .877 r
.64135 .25138 .65476 .27226 .68192 .26272 .6687 .24238 Metetra
.655 .704 .883 r
.6687 .24238 .68192 .26272 .70935 .25315 .69631 .23319 Metetra
.656 .711 .888 r
.69631 .23319 .70935 .25315 .73704 .24353 .7242 .22382 Metetra
.658 .717 .892 r
.7242 .22382 .73704 .24353 .76501 .23383 .75237 .21429 Metetra
.659 .722 .895 r
.75237 .21429 .76501 .23383 .79325 .22406 .78082 .20461 Metetra
.659 .725 .898 r
.78082 .20461 .79325 .22406 .82177 .2142 .80955 .19478 Metetra
.694 .547 .683 r
.16559 .48147 .17833 .53408 .20489 .49906 .19115 .45635 Metetra
.702 .575 .709 r
.19115 .45635 .20489 .49906 .2308 .46952 .21639 .43427 Metetra
.709 .604 .738 r
.21639 .43427 .2308 .46952 .25627 .44424 .24143 .41463 Metetra
.714 .634 .766 r
.24143 .41463 .25627 .44424 .28146 .4223 .26636 .39695 Metetra
.717 .662 .795 r
.26636 .39695 .28146 .4223 .30649 .40298 .29127 .38085 Metetra
.718 .689 .821 r
.29127 .38085 .30649 .40298 .33145 .38573 .31619 .36603 Metetra
.717 .713 .845 r
.31619 .36603 .33145 .38573 .35642 .37011 .34119 .35225 Metetra
.713 .733 .867 r
.34119 .35225 .35642 .37011 .38144 .35578 .36629 .33932 Metetra
.708 .751 .885 r
.36629 .33932 .38144 .35578 .40657 .34248 .39153 .3271 Metetra
.703 .765 .901 r
.39153 .3271 .40657 .34248 .43183 .32998 .41693 .31546 Metetra
.696 .777 .914 r
.41693 .31546 .43183 .32998 .45725 .31812 .44251 .30432 Metetra
.689 .788 .926 r
.44251 .30432 .45725 .31812 .48285 .3068 .46828 .29362 Metetra
.681 .798 .937 r
.46828 .29362 .48285 .3068 .50865 .29599 .49427 .28331 Metetra
.673 .806 .946 r
.49427 .28331 .50865 .29599 .53467 .28602 .52049 .27332 Metetra
.667 .806 .95 r
.52049 .27332 .53467 .28602 .56094 .27724 .54696 .26359 Metetra
.664 .793 .943 r
.54696 .26359 .56094 .27724 .58748 .26878 .57367 .25402 Metetra
.662 .778 .935 r
.57367 .25402 .58748 .26878 .61428 .26018 .60065 .24452 Metetra
.661 .767 .928 r
.60065 .24452 .61428 .26018 .64135 .25138 .6279 .23502 Metetra
.661 .759 .923 r
.6279 .23502 .64135 .25138 .6687 .24238 .65542 .22546 Metetra
.661 .754 .919 r
.65542 .22546 .6687 .24238 .69631 .23319 .68321 .21583 Metetra
.661 .75 .917 r
.68321 .21583 .69631 .23319 .7242 .22382 .71128 .20609 Metetra
.661 .748 .915 r
.71128 .20609 .7242 .22382 .75237 .21429 .73964 .19624 Metetra
.661 .746 .913 r
.73964 .19624 .75237 .21429 .78082 .20461 .76828 .18627 Metetra
.661 .745 .912 r
.76828 .18627 .78082 .20461 .80955 .19478 .79721 .17618 Metetra
.687 .573 .721 r
.15162 .44059 .16559 .48147 .19115 .45635 .17647 .42227 Metetra
.695 .603 .749 r
.17647 .42227 .19115 .45635 .21639 .43427 .20123 .4055 Metetra
.702 .634 .778 r
.20123 .4055 .21639 .43427 .24143 .41463 .22597 .39 Metetra
.707 .665 .807 r
.22597 .39 .24143 .41463 .26636 .39695 .25074 .37554 Metetra
.709 .694 .834 r
.25074 .37554 .26636 .39695 .29127 .38085 .27556 .36195 Metetra
.71 .721 .858 r
.27556 .36195 .29127 .38085 .31619 .36603 .30049 .34906 Metetra
.708 .744 .88 r
.30049 .34906 .31619 .36603 .34119 .35225 .32555 .33676 Metetra
.705 .764 .898 r
.32555 .33676 .34119 .35225 .36629 .33932 .35075 .32495 Metetra
.7 .78 .913 r
.35075 .32495 .36629 .33932 .39153 .3271 .37612 .31353 Metetra
.695 .792 .925 r
.37612 .31353 .39153 .3271 .41693 .31546 .40168 .30244 Metetra
.689 .801 .934 r
.40168 .30244 .41693 .31546 .44251 .30432 .42743 .29162 Metetra
.684 .807 .941 r
.42743 .29162 .44251 .30432 .46828 .29362 .4534 .28101 Metetra
.679 .81 .945 r
.4534 .28101 .46828 .29362 .49427 .28331 .4796 .27057 Metetra
.676 .809 .947 r
.4796 .27057 .49427 .28331 .52049 .27332 .50602 .26026 Metetra
.673 .806 .947 r
.50602 .26026 .52049 .27332 .54696 .26359 .53269 .25004 Metetra
.67 .801 .945 r
.53269 .25004 .54696 .26359 .57367 .25402 .55961 .23988 Metetra
.669 .794 .941 r
.55961 .23988 .57367 .25402 .60065 .24452 .58679 .22976 Metetra
.668 .787 .938 r
.58679 .22976 .60065 .24452 .6279 .23502 .61423 .21963 Metetra
.667 .78 .934 r
.61423 .21963 .6279 .23502 .65542 .22546 .64194 .20948 Metetra
.666 .773 .93 r
.64194 .20948 .65542 .22546 .68321 .21583 .66992 .1993 Metetra
.665 .768 .926 r
.66992 .1993 .68321 .21583 .71128 .20609 .69818 .18906 Metetra
.665 .763 .924 r
.69818 .18906 .71128 .20609 .73964 .19624 .72673 .17876 Metetra
.664 .76 .921 r
.72673 .17876 .73964 .19624 .76828 .18627 .75557 .16838 Metetra
.664 .756 .919 r
.75557 .16838 .76828 .18627 .79721 .17618 .7847 .15791 Metetra
.669 .58 .746 r
.13711 .40408 .15162 .44059 .17647 .42227 .16146 .39024 Metetra
.675 .604 .769 r
.16146 .39024 .17647 .42227 .20123 .4055 .18588 .37708 Metetra
.679 .629 .792 r
.18588 .37708 .20123 .4055 .22597 .39 .2104 .36448 Metetra
.683 .652 .813 r
.2104 .36448 .22597 .39 .25074 .37554 .23503 .35235 Metetra
.685 .673 .832 r
.23503 .35235 .25074 .37554 .27556 .36195 .2598 .3406 Metetra
.686 .692 .85 r
.2598 .3406 .27556 .36195 .30049 .34906 .28473 .32918 Metetra
.686 .708 .865 r
.28473 .32918 .30049 .34906 .32555 .33676 .30983 .31802 Metetra
.685 .722 .878 r
.30983 .31802 .32555 .33676 .35075 .32495 .33511 .30707 Metetra
.684 .734 .888 r
.33511 .30707 .35075 .32495 .37612 .31353 .36059 .29629 Metetra
.682 .743 .897 r
.36059 .29629 .37612 .31353 .40168 .30244 .38628 .28565 Metetra
.68 .751 .904 r
.38628 .28565 .40168 .30244 .42743 .29162 .41218 .27512 Metetra
.679 .756 .91 r
.41218 .27512 .42743 .29162 .4534 .28101 .43831 .26467 Metetra
.677 .76 .914 r
.43831 .26467 .4534 .28101 .4796 .27057 .46468 .25427 Metetra
.675 .762 .916 r
.46468 .25427 .4796 .27057 .50602 .26026 .49128 .24391 Metetra
.673 .763 .918 r
.49128 .24391 .50602 .26026 .53269 .25004 .51813 .23356 Metetra
.672 .763 .919 r
.51813 .23356 .53269 .25004 .55961 .23988 .54524 .22322 Metetra
.67 .763 .92 r
.54524 .22322 .55961 .23988 .58679 .22976 .57261 .21286 Metetra
.669 .761 .919 r
.57261 .21286 .58679 .22976 .61423 .21963 .60024 .20248 Metetra
.668 .76 .919 r
.60024 .20248 .61423 .21963 .64194 .20948 .62815 .19205 Metetra
.668 .759 .918 r
.62815 .19205 .64194 .20948 .66992 .1993 .65633 .18158 Metetra
.667 .757 .918 r
.65633 .18158 .66992 .1993 .69818 .18906 .68479 .17105 Metetra
.666 .755 .917 r
.68479 .17105 .69818 .18906 .72673 .17876 .71354 .16045 Metetra
.666 .754 .916 r
.71354 .16045 .72673 .17876 .75557 .16838 .74259 .14978 Metetra
.665 .752 .915 r
.74259 .14978 .75557 .16838 .7847 .15791 .77193 .13902 Metetra
.656 .592 .771 r
.12205 .37125 .13711 .40408 .16146 .39024 .1461 .36011 Metetra
.659 .61 .788 r
.1461 .36011 .16146 .39024 .18588 .37708 .1703 .3492 Metetra
.663 .627 .804 r
.1703 .3492 .18588 .37708 .2104 .36448 .19467 .33847 Metetra
.665 .643 .818 r
.19467 .33847 .2104 .36448 .23503 .35235 .21922 .32789 Metetra
.667 .658 .831 r
.21922 .32789 .23503 .35235 .2598 .3406 .24395 .31743 Metetra
.669 .671 .843 r
.24395 .31743 .2598 .3406 .28473 .32918 .26888 .30706 Metetra
.67 .683 .854 r
.26888 .30706 .28473 .32918 .30983 .31802 .29402 .29675 Metetra
.67 .693 .863 r
.29402 .29675 .30983 .31802 .33511 .30707 .31936 .28649 Metetra
.67 .702 .871 r
.31936 .28649 .33511 .30707 .36059 .29629 .34493 .27627 Metetra
.67 .71 .878 r
.34493 .27627 .36059 .29629 .38628 .28565 .37072 .26606 Metetra
.67 .717 .884 r
.37072 .26606 .38628 .28565 .41218 .27512 .39675 .25585 Metetra
.67 .722 .889 r
.39675 .25585 .41218 .27512 .43831 .26467 .42302 .24563 Metetra
.669 .727 .893 r
.42302 .24563 .43831 .26467 .46468 .25427 .44953 .23539 Metetra
.669 .731 .896 r
.44953 .23539 .46468 .25427 .49128 .24391 .47629 .22512 Metetra
.668 .734 .899 r
.47629 .22512 .49128 .24391 .51813 .23356 .50331 .21481 Metetra
.668 .737 .901 r
.50331 .21481 .51813 .23356 .54524 .22322 .53059 .20446 Metetra
.667 .738 .903 r
.53059 .20446 .54524 .22322 .57261 .21286 .55814 .19405 Metetra
.667 .74 .905 r
.55814 .19405 .57261 .21286 .60024 .20248 .58596 .18358 Metetra
.666 .741 .906 r
.58596 .18358 .60024 .20248 .62815 .19205 .61405 .17304 Metetra
.666 .742 .907 r
.61405 .17304 .62815 .19205 .65633 .18158 .64243 .16244 Metetra
.666 .743 .907 r
.64243 .16244 .65633 .18158 .68479 .17105 .67109 .15175 Metetra
.665 .743 .908 r
.67109 .15175 .68479 .17105 .71354 .16045 .70005 .14098 Metetra
.665 .743 .908 r
.70005 .14098 .71354 .16045 .74259 .14978 .7293 .13013 Metetra
.665 .743 .909 r
.7293 .13013 .74259 .14978 .77193 .13902 .75886 .11918 Metetra
.651 .618 .804 r
.10627 .34287 .12205 .37125 .1461 .36011 .13018 .33314 Metetra
.654 .631 .815 r
.13018 .33314 .1461 .36011 .1703 .3492 .15429 .32343 Metetra
.656 .642 .825 r
.15429 .32343 .1703 .3492 .19467 .33847 .1786 .31374 Metetra
.657 .653 .834 r
.1786 .31374 .19467 .33847 .21922 .32789 .20312 .30403 Metetra
.659 .663 .842 r
.20312 .30403 .21922 .32789 .24395 .31743 .22786 .29432 Metetra
.66 .671 .85 r
.22786 .29432 .24395 .31743 .26888 .30706 .25281 .28458 Metetra
.661 .679 .857 r
.25281 .28458 .26888 .30706 .29402 .29675 .278 .27481 Metetra
.662 .687 .863 r
.278 .27481 .29402 .29675 .31936 .28649 .30342 .265 Metetra
.662 .693 .869 r
.30342 .265 .31936 .28649 .34493 .27627 .32907 .25514 Metetra
.663 .699 .873 r
.32907 .25514 .34493 .27627 .37072 .26606 .35497 .24524 Metetra
.663 .704 .878 r
.35497 .24524 .37072 .26606 .39675 .25585 .38111 .23527 Metetra
.663 .709 .882 r
.38111 .23527 .39675 .25585 .42302 .24563 .4075 .22524 Metetra
.663 .713 .885 r
.4075 .22524 .42302 .24563 .44953 .23539 .43415 .21514 Metetra
.664 .717 .888 r
.43415 .21514 .44953 .23539 .47629 .22512 .46106 .20497 Metetra
.664 .72 .891 r
.46106 .20497 .47629 .22512 .50331 .21481 .48823 .19473 Metetra
.664 .723 .893 r
.48823 .19473 .50331 .21481 .53059 .20446 .51568 .1844 Metetra
.664 .726 .895 r
.51568 .1844 .53059 .20446 .55814 .19405 .5434 .17399 Metetra
.664 .728 .897 r
.5434 .17399 .55814 .19405 .58596 .18358 .57139 .1635 Metetra
.664 .73 .899 r
.57139 .1635 .58596 .18358 .61405 .17304 .59967 .15291 Metetra
.664 .732 .9 r
.59967 .15291 .61405 .17304 .64243 .16244 .62824 .14223 Metetra
.664 .733 .901 r
.62824 .14223 .64243 .16244 .67109 .15175 .6571 .13145 Metetra
.664 .734 .902 r
.6571 .13145 .67109 .15175 .70005 .14098 .68626 .12057 Metetra
.663 .735 .903 r
.68626 .12057 .70005 .14098 .7293 .13013 .71573 .10959 Metetra
.663 .736 .904 r
.71573 .10959 .7293 .13013 .75886 .11918 .7455 .0985 Metetra
.653 .655 .839 r
.08972 .31876 .10627 .34287 .13018 .33314 .11361 .30959 Metetra
.654 .662 .845 r
.11361 .30959 .13018 .33314 .15429 .32343 .13772 .30037 Metetra
.655 .668 .851 r
.13772 .30037 .15429 .32343 .1786 .31374 .16205 .29109 Metetra
.656 .674 .856 r
.16205 .29109 .1786 .31374 .20312 .30403 .1866 .28176 Metetra
.657 .68 .86 r
.1866 .28176 .20312 .30403 .22786 .29432 .21139 .27236 Metetra
.657 .685 .864 r
.21139 .27236 .22786 .29432 .25281 .28458 .23641 .26289 Metetra
.658 .689 .868 r
.23641 .26289 .25281 .28458 .278 .27481 .26168 .25336 Metetra
.658 .694 .872 r
.26168 .25336 .278 .27481 .30342 .265 .28718 .24375 Metetra
.659 .698 .875 r
.28718 .24375 .30342 .265 .32907 .25514 .31294 .23406 Metetra
.659 .702 .878 r
.31294 .23406 .32907 .25514 .35497 .24524 .33894 .22428 Metetra
.659 .705 .881 r
.33894 .22428 .35497 .24524 .38111 .23527 .3652 .21443 Metetra
.66 .709 .884 r
.3652 .21443 .38111 .23527 .4075 .22524 .39172 .20448 Metetra
.66 .712 .886 r
.39172 .20448 .4075 .22524 .43415 .21514 .41851 .19445 Metetra
.66 .715 .888 r
.41851 .19445 .43415 .21514 .46106 .20497 .44557 .18432 Metetra
.661 .717 .891 r
.44557 .18432 .46106 .20497 .48823 .19473 .4729 .17409 Metetra
.661 .72 .892 r
.4729 .17409 .48823 .19473 .51568 .1844 .5005 .16377 Metetra
.661 .722 .894 r
.5005 .16377 .51568 .1844 .5434 .17399 .52839 .15334 Metetra
.661 .724 .896 r
.52839 .15334 .5434 .17399 .57139 .1635 .55656 .1428 Metetra
.661 .726 .897 r
.55656 .1428 .57139 .1635 .59967 .15291 .58503 .13216 Metetra
.662 .728 .899 r
.58503 .13216 .59967 .15291 .62824 .14223 .61379 .12141 Metetra
.662 .729 .9 r
.61379 .12141 .62824 .14223 .6571 .13145 .64284 .11054 Metetra
.662 .731 .901 r
.64284 .11054 .6571 .13145 .68626 .12057 .67221 .09956 Metetra
.662 .732 .902 r
.67221 .09956 .68626 .12057 .71573 .10959 .70188 .08846 Metetra
.662 .733 .903 r
.70188 .08846 .71573 .10959 .7455 .0985 .73187 .07724 Metetra
.657 .69 .869 r
.07247 .29782 .08972 .31876 .11361 .30959 .09641 .28875 Metetra
.657 .692 .872 r
.09641 .28875 .11361 .30959 .13772 .30037 .12059 .2796 Metetra
.657 .695 .874 r
.12059 .2796 .13772 .30037 .16205 .29109 .14499 .27038 Metetra
.657 .697 .876 r
.14499 .27038 .16205 .29109 .1866 .28176 .16963 .26109 Metetra
.657 .7 .878 r
.16963 .26109 .1866 .28176 .21139 .27236 .19451 .25172 Metetra
.657 .702 .88 r
.19451 .25172 .21139 .27236 .23641 .26289 .21963 .24228 Metetra
.658 .704 .881 r
.21963 .24228 .23641 .26289 .26168 .25336 .245 .23275 Metetra
.658 .706 .883 r
.245 .23275 .26168 .25336 .28718 .24375 .27061 .22315 Metetra
.658 .708 .885 r
.27061 .22315 .28718 .24375 .31294 .23406 .29648 .21346 Metetra
.658 .711 .887 r
.29648 .21346 .31294 .23406 .33894 .22428 .32261 .20369 Metetra
.658 .713 .888 r
.32261 .20369 .33894 .22428 .3652 .21443 .349 .19382 Metetra
.658 .715 .89 r
.349 .19382 .3652 .21443 .39172 .20448 .37566 .18386 Metetra
.658 .717 .891 r
.37566 .18386 .39172 .20448 .41851 .19445 .40259 .17381 Metetra
.659 .719 .893 r
.40259 .17381 .41851 .19445 .44557 .18432 .42979 .16365 Metetra
.659 .721 .894 r
.42979 .16365 .44557 .18432 .4729 .17409 .45728 .15338 Metetra
.659 .722 .896 r
.45728 .15338 .4729 .17409 .5005 .16377 .48505 .14301 Metetra
.659 .724 .897 r
.48505 .14301 .5005 .16377 .52839 .15334 .51311 .13253 Metetra
.66 .726 .898 r
.51311 .13253 .52839 .15334 .55656 .1428 .54146 .12192 Metetra
.66 .728 .9 r
.54146 .12192 .55656 .1428 .58503 .13216 .57011 .1112 Metetra
.66 .729 .901 r
.57011 .1112 .58503 .13216 .61379 .12141 .59906 .10035 Metetra
.66 .731 .902 r
.59906 .10035 .61379 .12141 .64284 .11054 .62832 .08938 Metetra
.661 .732 .903 r
.62832 .08938 .64284 .11054 .67221 .09956 .65789 .07828 Metetra
.661 .733 .903 r
.65789 .07828 .67221 .09956 .70188 .08846 .68778 .06705 Metetra
.661 .734 .904 r
.68778 .06705 .70188 .08846 .73187 .07724 .71798 .05569 Metetra
.66 .715 .889 r
.05461 .27881 .07247 .29782 .09641 .28875 .07867 .26961 Metetra
.659 .715 .89 r
.07867 .26961 .09641 .28875 .12059 .2796 .10295 .26033 Metetra
.659 .716 .89 r
.10295 .26033 .12059 .2796 .14499 .27038 .12746 .25098 Metetra
.659 .716 .891 r
.12746 .25098 .14499 .27038 .16963 .26109 .15222 .24156 Metetra
.659 .717 .891 r
.15222 .24156 .16963 .26109 .19451 .25172 .17721 .23207 Metetra
.659 .717 .892 r
.17721 .23207 .19451 .25172 .21963 .24228 .20245 .2225 Metetra
.658 .718 .892 r
.20245 .2225 .21963 .24228 .245 .23275 .22794 .21286 Metetra
.658 .718 .893 r
.22794 .21286 .245 .23275 .27061 .22315 .25368 .20315 Metetra
.658 .719 .894 r
.25368 .20315 .27061 .22315 .29648 .21346 .27968 .19337 Metetra
.658 .72 .895 r
.27968 .19337 .29648 .21346 .32261 .20369 .30595 .1835 Metetra
.657 .721 .896 r
.30595 .1835 .32261 .20369 .349 .19382 .33248 .17356 Metetra
.657 .722 .897 r
.33248 .17356 .349 .19382 .37566 .18386 .35928 .16353 Metetra
.657 .724 .898 r
.35928 .16353 .37566 .18386 .40259 .17381 .38636 .15342 Metetra
.657 .725 .899 r
.38636 .15342 .40259 .17381 .42979 .16365 .41372 .1432 Metetra
.657 .727 .9 r
.41372 .1432 .42979 .16365 .45728 .15338 .44137 .13288 Metetra
.658 .729 .902 r
.44137 .13288 .45728 .15338 .48505 .14301 .46931 .12245 Metetra
.658 .73 .903 r
.46931 .12245 .48505 .14301 .51311 .13253 .49755 .11189 Metetra
.658 .732 .904 r
.49755 .11189 .51311 .13253 .54146 .12192 .52608 .10121 Metetra
.659 .734 .905 r
.52608 .10121 .54146 .12192 .57011 .1112 .55492 .09038 Metetra
.659 .735 .906 r
.55492 .09038 .57011 .1112 .59906 .10035 .58407 .07942 Metetra
.66 .737 .907 r
.58407 .07942 .59906 .10035 .62832 .08938 .61354 .06832 Metetra
.66 .738 .907 r
.61354 .06832 .62832 .08938 .65789 .07828 .64332 .05706 Metetra
.661 .739 .908 r
.64332 .05706 .65789 .07828 .68778 .06705 .67342 .04566 Metetra
.661 .74 .908 r
.67342 .04566 .68778 .06705 .71798 .05569 .70385 .03411 Metetra
.662 .73 .9 r
.03628 .26071 .05461 .27881 .07867 .26961 .06045 .25132 Metetra
.662 .73 .9 r
.06045 .25132 .07867 .26961 .10295 .26033 .08486 .24184 Metetra
.661 .729 .9 r
.08486 .24184 .10295 .26033 .12746 .25098 .1095 .23229 Metetra
.661 .729 .9 r
.1095 .23229 .12746 .25098 .15222 .24156 .13439 .22266 Metetra
.66 .728 .899 r
.13439 .22266 .15222 .24156 .17721 .23207 .15951 .21296 Metetra
.66 .728 .899 r
.15951 .21296 .17721 .23207 .20245 .2225 .18489 .20319 Metetra
.659 .727 .899 r
.18489 .20319 .20245 .2225 .22794 .21286 .21051 .19337 Metetra
.659 .727 .9 r
.21051 .19337 .22794 .21286 .25368 .20315 .23639 .1835 Metetra
.658 .727 .9 r
.23639 .1835 .25368 .20315 .27968 .19337 .26253 .17358 Metetra
.657 .727 .901 r
.26253 .17358 .27968 .19337 .30595 .1835 .28894 .16361 Metetra
.656 .728 .902 r
.28894 .16361 .30595 .1835 .33248 .17356 .31561 .15361 Metetra
.655 .729 .904 r
.31561 .15361 .33248 .17356 .35928 .16353 .34256 .14357 Metetra
.655 .731 .906 r
.34256 .14357 .35928 .16353 .38636 .15342 .36979 .13347 Metetra
.654 .734 .908 r
.36979 .13347 .38636 .15342 .41372 .1432 .39731 .12331 Metetra
.654 .737 .91 r
.39731 .12331 .41372 .1432 .44137 .13288 .42513 .11305 Metetra
.655 .74 .912 r
.42513 .11305 .44137 .13288 .46931 .12245 .45324 .10265 Metetra
.656 .743 .914 r
.45324 .10265 .46931 .12245 .49755 .11189 .48167 .09209 Metetra
.657 .746 .916 r
.48167 .09209 .49755 .11189 .52608 .10121 .5104 .08135 Metetra
.658 .749 .917 r
.5104 .08135 .52608 .10121 .55492 .09038 .53945 .07041 Metetra
.66 .75 .917 r
.53945 .07041 .55492 .09038 .58407 .07942 .56881 .05927 Metetra
.661 .751 .917 r
.56881 .05927 .58407 .07942 .61354 .06832 .59849 .04793 Metetra
.662 .751 .917 r
.59849 .04793 .61354 .06832 .64332 .05706 .6285 .03641 Metetra
.662 .751 .916 r
.6285 .03641 .64332 .05706 .67342 .04566 .65882 .02471 Metetra
.663 .751 .916 r
.65882 .02471 .67342 .04566 .70385 .03411 .68948 .01286 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.13514 .21677 m
.13978 .22141 L
s
[(-2)] .12586 .2075 1 .99877 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.56863 .04703 m
.57247 .05235 L
s
[(2)] .56094 .0364 .72324 1 Mshowa
.125 Mabswid
.18558 .19702 m
.18832 .19985 L
s
.23703 .17687 m
.23971 .17975 L
s
.28951 .15632 m
.29214 .15925 L
s
.39772 .11395 m
.40023 .11699 L
s
.4535 .09211 m
.45595 .0952 L
s
.51046 .06981 m
.51284 .07294 L
s
.08568 .23614 m
.08851 .23887 L
s
.62804 .02377 m
.63027 .02701 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.11"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.2.11"]
}, Open  ]],

Cell[TextData[{
  "This is a plot of the absolute value of the Riemann zeta function on the \
critical line ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Re", " ", 
          StyleBox["z",
            "TI"], "=", \(1\/2\)}], TraditionalForm]], "InlineFormula"],
  ". You can see the first few zeros of the zeta function. "
}], "MathCaption",
  CellTags->{"S3.2.11", "11.35"}],

Cell[CellGroupData[{

Cell["Plot[ Abs[ Zeta[ 1/2 + I y ] ], {y, 0, 40} ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.2.11"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0238095 0.0147151 0.200066 [
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.7381 .00222 -6 -9 ]
[.7381 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .11475 -18 -4.5 ]
[.01131 .11475 0 4.5 ]
[.01131 .21478 -6 -4.5 ]
[.01131 .21478 0 4.5 ]
[.01131 .31481 -18 -4.5 ]
[.01131 .31481 0 4.5 ]
[.01131 .41485 -6 -4.5 ]
[.01131 .41485 0 4.5 ]
[.01131 .51488 -18 -4.5 ]
[.01131 .51488 0 4.5 ]
[.01131 .61491 -6 -4.5 ]
[.01131 .61491 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(10)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(20)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(30)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(40)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .11475 m
.03006 .11475 L
s
[(0.5)] .01131 .11475 1 0 Mshowa
.02381 .21478 m
.03006 .21478 L
s
[(1)] .01131 .21478 1 0 Mshowa
.02381 .31481 m
.03006 .31481 L
s
[(1.5)] .01131 .31481 1 0 Mshowa
.02381 .41485 m
.03006 .41485 L
s
[(2)] .01131 .41485 1 0 Mshowa
.02381 .51488 m
.03006 .51488 L
s
[(2.5)] .01131 .51488 1 0 Mshowa
.02381 .61491 m
.03006 .61491 L
s
[(3)] .01131 .61491 1 0 Mshowa
.125 Mabswid
.02381 .03472 m
.02756 .03472 L
s
.02381 .05473 m
.02756 .05473 L
s
.02381 .07473 m
.02756 .07473 L
s
.02381 .09474 m
.02756 .09474 L
s
.02381 .13475 m
.02756 .13475 L
s
.02381 .15476 m
.02756 .15476 L
s
.02381 .17477 m
.02756 .17477 L
s
.02381 .19477 m
.02756 .19477 L
s
.02381 .23479 m
.02756 .23479 L
s
.02381 .25479 m
.02756 .25479 L
s
.02381 .2748 m
.02756 .2748 L
s
.02381 .29481 m
.02756 .29481 L
s
.02381 .33482 m
.02756 .33482 L
s
.02381 .35483 m
.02756 .35483 L
s
.02381 .37483 m
.02756 .37483 L
s
.02381 .39484 m
.02756 .39484 L
s
.02381 .43485 m
.02756 .43485 L
s
.02381 .45486 m
.02756 .45486 L
s
.02381 .47487 m
.02756 .47487 L
s
.02381 .49487 m
.02756 .49487 L
s
.02381 .53489 m
.02756 .53489 L
s
.02381 .55489 m
.02756 .55489 L
s
.02381 .5749 m
.02756 .5749 L
s
.02381 .59491 m
.02756 .59491 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30688 m
.03279 .2522 L
.03793 .21141 L
.04262 .18337 L
.04758 .16217 L
.0503 .15339 L
.05288 .14654 L
.05747 .13715 L
.06006 .1331 L
.06244 .13001 L
.06487 .12743 L
.06747 .12519 L
.06972 .12364 L
.07218 .12231 L
.07367 .12167 L
.07505 .12118 L
.07648 .12077 L
.07778 .12047 L
.07905 .12026 L
.08025 .12012 L
.08152 .12003 L
.08224 .12001 L
.0829 .12 L
.08415 .12003 L
.08486 .12008 L
.0855 .12013 L
.08674 .12027 L
.08792 .12045 L
.09057 .12101 L
.09344 .12183 L
.09923 .12414 L
.10458 .12696 L
.11421 .13352 L
.12324 .14123 L
.14385 .16376 L
.18253 .22072 L
.20218 .25353 L
.22367 .28776 L
.2336 .30141 L
.23905 .30796 L
.2442 .31338 L
.249 .31765 L
.25421 .32132 L
.2565 .32259 L
.25894 .32369 L
.26101 .32441 L
.26219 .32473 L
.2633 .32497 L
.26455 .32516 L
.26525 .32524 L
Mistroke
.26588 .32528 L
.26712 .32531 L
.26828 .32527 L
.26894 .32521 L
.26964 .32512 L
.27089 .32489 L
.27223 .32455 L
.2737 .32406 L
.27617 .32294 L
.27882 .32134 L
.28358 .31731 L
.28857 .31147 L
.29329 .30433 L
.30212 .28647 L
.3118 .25982 L
.32207 .22316 L
.3405 .13584 L
.3499 .08153 L
.35483 .05076 L
.35752 .03341 L
.35883 .02482 L
.36001 .01696 L
.36115 .02006 L
.36222 .02726 L
.36458 .04327 L
.36956 .07781 L
.37831 .13982 L
.39666 .26911 L
.40709 .3365 L
.41682 .39153 L
.42643 .43533 L
.43182 .45435 L
.43674 .46775 L
.43943 .47338 L
.44191 .47747 L
.44332 .47929 L
.44464 .48068 L
.44602 .48178 L
.44676 .48222 L
.44755 .48258 L
.44879 .48292 L
.44949 .48298 L
.45015 .48295 L
.45084 .48283 L
.45148 .48264 L
.4522 .48232 L
.45289 .48193 L
.45412 .481 L
.45524 .47989 L
.4578 .47645 L
Mistroke
.46023 .47196 L
.46246 .46683 L
.46747 .4517 L
.47212 .43328 L
.47654 .41197 L
.4864 .35171 L
.49717 .26867 L
.50731 .17816 L
.51685 .08689 L
.51943 .06198 L
.52214 .03575 L
.52356 .0221 L
.52437 .01504 L
.52512 .02221 L
.52786 .04807 L
.53783 .13704 L
.54829 .21608 L
.55344 .24743 L
.5582 .27109 L
.56251 .28765 L
.56469 .29413 L
.56709 .29976 L
.56826 .30191 L
.56949 .30375 L
.57014 .30453 L
.57084 .30525 L
.57208 .30616 L
.57325 .3066 L
.57451 .30661 L
.57569 .30619 L
.57676 .30545 L
.57796 .3042 L
.57907 .30265 L
.58161 .29768 L
.58409 .29094 L
.58675 .28162 L
.59156 .25936 L
.59596 .23312 L
.60663 .14788 L
.61195 .09553 L
.61676 .04361 L
.61792 .03054 L
.61915 .01655 L
.61979 .02027 L
.62049 .02843 L
.62172 .0429 L
.62638 .0989 L
.63662 .22494 L
.65503 .432 L
.66029 .47947 L
Mistroke
.66527 .51732 L
.66974 .5447 L
.67459 .56667 L
.6771 .57469 L
.67853 .5782 L
.67987 .58078 L
.68059 .58189 L
.68128 .58275 L
.68257 .58389 L
.68329 .58424 L
.68396 .58439 L
.68469 .58435 L
.68547 .58407 L
.68678 .58309 L
.68751 .58224 L
.68819 .58128 L
.68943 .57904 L
.69074 .57602 L
.69302 .56921 L
.69552 .55946 L
.70076 .53159 L
.70572 .49642 L
.71502 .41055 L
.72516 .29507 L
.73594 .16085 L
.74049 .10458 L
.74539 .04637 L
.74676 .03082 L
.74751 .02248 L
.7482 .01482 L
.74943 .02793 L
.75078 .04212 L
.75584 .09124 L
.76041 .1291 L
.76474 .15814 L
.76713 .17114 L
.76972 .1826 L
.77208 .19056 L
.77312 .19331 L
.77425 .19577 L
.7755 .19782 L
.77669 .19912 L
.77785 .19978 L
.77892 .19984 L
.7802 .19924 L
.78135 .19806 L
.78199 .19714 L
.78269 .19594 L
.78394 .19321 L
.78624 .18636 L
Mistroke
.78867 .17657 L
.79301 .15265 L
.7981 .1147 L
.80285 .07054 L
.80553 .04235 L
.80685 .0277 L
.80806 .0157 L
.80874 .02366 L
.80946 .03223 L
.81098 .05073 L
.81364 .08427 L
.83337 .35106 L
.842 .45604 L
.84656 .50303 L
.85143 .54462 L
.854 .56248 L
.85633 .57606 L
.8587 .58718 L
.86088 .59493 L
.86207 .59812 L
.86333 .60069 L
.8646 .60242 L
.86532 .60301 L
.86599 .60332 L
.86721 .60325 L
.86831 .60249 L
.8696 .60077 L
.87081 .59831 L
.872 .59511 L
.87332 .59066 L
.876 .57878 L
.87847 .56436 L
.8808 .54791 L
.88603 .5011 L
.89168 .4367 L
.90204 .289 L
.91168 .13134 L
.91418 .08957 L
.91655 .05032 L
.91785 .02883 L
.91859 .01678 L
.91927 .0237 L
.92047 .04307 L
.92175 .06332 L
.93277 .22075 L
.9376 .27584 L
.94219 .31817 L
.94472 .3369 L
.94748 .35341 L
.94869 .35934 L
Mistroke
.94998 .36474 L
.95112 .36868 L
.95231 .37206 L
.95355 .37468 L
.95469 .37632 L
.95591 .37725 L
.95661 .3774 L
.95726 .37729 L
.95843 .37648 L
.9595 .37506 L
.96074 .37262 L
.96191 .36954 L
.96408 .36187 L
.96608 .35257 L
.97062 .32413 L
.97619 .27658 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.11"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.2.11"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["polylogarithm functions", "TB"],
  " ",
  StyleBox["PolyLog[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " are given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["Li", 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "1"}], "\[Infinity]",
            LimitsPositioning->True], 
          SuperscriptBox[
            StyleBox["z",
              "TI"], 
            StyleBox["k",
              "TI"]], "/", 
          SuperscriptBox[
            StyleBox["k",
              "TI"], 
            StyleBox["n",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". The polylogarithm function is sometimes known as ",
  StyleBox["Jonqui\[EGrave]re's function", "TB"],
  ". The ",
  StyleBox["dilogarithm", "TB"],
  " ",
  StyleBox["PolyLog[2,", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " satisfies ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(Li\_2\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SubsuperscriptBox["\[Integral]", 
            StyleBox["z",
              "TI"], "0"], 
          RowBox[{"log", 
            RowBox[{"(", 
              RowBox[{"1", "-", 
                StyleBox["t",
                  "TI"]}], ")"}]}], "/", 
          StyleBox["t",
            "TI"], "\[DifferentialD]", 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". Sometimes ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(Li\_2\), 
          RowBox[{"(", 
            RowBox[{"1", "-", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is known as ",
  StyleBox["Spence's integral", "TB"],
  ". The ",
  StyleBox["Nielsen generalized polylogarithm functions", "TB"],
  " or ",
  StyleBox["hyperlogarithms", "TB"],
  " ",
  StyleBox["PolyLog[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["p", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " are given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["S",
              "TI"], 
            RowBox[{
              StyleBox["n",
                "TI"], ",", 
              StyleBox["p",
                "TI"]}]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SuperscriptBox[\((\(-1\))\), 
            RowBox[{
              StyleBox["n",
                "TI"], "+", 
              StyleBox["p",
                "TI"], "-", "1"}]], "/", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  StyleBox["n",
                    "TI"], "-", "1"}], ")"}], "!", 
              StyleBox["p",
                "TI"], "!"}], ")"}], \(\[Integral]\_0\%1\), 
          SuperscriptBox["log", 
            RowBox[{
              StyleBox["n",
                "TI"], "-", "1"}]], 
          RowBox[{"(", 
            StyleBox["t",
              "TI"], ")"}], 
          SuperscriptBox["log", 
            StyleBox["p",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{"1", "-", 
              StyleBox["z",
                "TI"], 
              StyleBox["t",
                "TI"]}], ")"}], "/", 
          StyleBox["t",
            "TI"], "\[DifferentialD]", 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". Polylogarithm functions appear in Feynman diagram integrals in \
elementary particle physics, as well as in algebraic K\[Hyphen]theory.  "
}], "Text",
  CellTags->{"S3.2.11", "11.36"}],

Cell[TextData[{
  "The ",
  StyleBox["Lerch transcendent", "TB"],
  " ",
  StyleBox["LerchPhi[", "MR"],
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox["]", "MR"],
  " is a generalization of the zeta and polylogarithm functions, given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalPhi]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["z",
                "TI"], ",", 
              StyleBox["s",
                "TI"], ",", 
              StyleBox["a",
                "TI"]}], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          SuperscriptBox[
            StyleBox["z",
              "TI"], 
            StyleBox["k",
              "TI"]], "/", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                StyleBox["a",
                  "TI"], "+", 
                StyleBox["k",
                  "TI"]}], ")"}], 
            StyleBox["s",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ", where any term with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["a",
            "TI"], "+", 
          StyleBox["k",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  " is excluded. Many sums of reciprocal powers can be expressed in terms of \
the Lerch transcendent. For example, the ",
  StyleBox["Catalan beta function", "TB"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Beta]", 
          RowBox[{"(", 
            StyleBox["s",
              "TI"], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          SuperscriptBox[\((\(-1\))\), 
            StyleBox["k",
              "TI"]], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"2", 
                StyleBox["k",
                  "TI"], "+", "1"}], ")"}], 
            RowBox[{"-", 
              StyleBox["s",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  " can be obtained as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["2", 
            RowBox[{"-", 
              StyleBox["s",
                "TI"]}]], "\[CapitalPhi]", 
          RowBox[{"(", 
            RowBox[{\(-1\), ",", 
              StyleBox["s",
                "TI"], ",", \(1\/2\)}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.11", "11.37"}],

Cell[TextData[{
  "The Lerch transcendent is related to integrals of the ",
  StyleBox["Fermi\[Hyphen]Dirac", "TB"],
  " distribution in statistical mechanics by ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%\[Infinity]\), 
          SuperscriptBox[
            StyleBox["k",
              "TI"], 
            StyleBox["s",
              "TI"]], "/", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["e",
                  "TI"], 
                RowBox[{
                  StyleBox["k",
                    "TI"], "-", "\[Mu]"}]], "+", "1"}], ")"}], 
          "\[DifferentialD]", 
          StyleBox["k",
            "TI"], "=", 
          SuperscriptBox[
            StyleBox["e",
              "TI"], "\[Mu]"], "\[CapitalGamma]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["s",
                "TI"], "+", "1"}], ")"}], "\[CapitalPhi]", 
          RowBox[{"(", 
            RowBox[{"-", 
              SuperscriptBox[
                StyleBox["e",
                  "TI"], "\[Mu]"], ",", 
              StyleBox["s",
                "TI"], "+", "1", ",", "1"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.38"}],

Cell[TextData[{
  "The Lerch transcendent can also be used to evaluate ",
  StyleBox["Dirichlet ", "TB"],
  StyleBox["L", "TBI"],
  StyleBox["\[Hyphen]series", "TB"],
  " which appear in number theory. The basic ",
  Cell[BoxData[
      FormBox[
        StyleBox["L",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]series has the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["L",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["s",
                "TI"], ",", "\[Chi]"}], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "1"}], "\[Infinity]",
            LimitsPositioning->True], "\[Chi]", 
          RowBox[{"(", 
            StyleBox["k",
              "TI"], ")"}], 
          SuperscriptBox[
            StyleBox["k",
              "TI"], 
            RowBox[{"-", 
              StyleBox["s",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  ", where the \[OpenCurlyDoubleQuote]character\[CloseCurlyDoubleQuote] ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Chi]", 
          RowBox[{"(", 
            StyleBox["k",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is an integer function with period ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". ",
  Cell[BoxData[
      FormBox[
        StyleBox["L",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]series of this kind can be written as sums of Lerch functions \
with ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  " a power of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["e",
            "TI"], 
          RowBox[{"2", "\[Pi]", 
            StyleBox["i",
              "TI"], "/", 
            StyleBox["m",
              "TI"]}]], TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.2.11", "11.39"}],

Cell[TextData[{
  StyleBox["LerchPhi[", "MR"],
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["DoublyInfinite->True]", "MR"],
  " gives the doubly infinite sum ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "-", "\[Infinity]"}], "\[Infinity]",
            LimitsPositioning->True], 
          SuperscriptBox[
            StyleBox["z",
              "TI"], 
            StyleBox["k",
              "TI"]], "/", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                StyleBox["a",
                  "TI"], "+", 
                StyleBox["k",
                  "TI"]}], ")"}], 
            StyleBox["s",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.40"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exponential Integral and Related Functions", "Subsubsection",
  CellTags->{"S3.2.11", "11.41"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CosIntegral[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "cosine integral function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"Ci", 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["CoshIntegral[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "hyperbolic cosine integral function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"Chi", 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ExpIntegralE[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "exponential integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["E",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ExpIntegralEi[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "exponential integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"Ei", 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LogIntegral[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "logarithmic integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"li", 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SinIntegral[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "sine integral function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"Si", 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SinhIntegral[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "hyperbolic sine integral function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"Shi", 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.11"],

Cell["Exponential integral and related functions. ", "Caption",
  CellTags->"S3.2.11"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " has two forms of exponential integral: ",
  StyleBox["ExpIntegralE", "MR"],
  " and ",
  StyleBox["ExpIntegralEi", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.2.11", "11.42"}],

Cell[TextData[{
  "The ",
  StyleBox["exponential integral function", "TB"],
  " ",
  StyleBox["ExpIntegralE[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is defined by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["E",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", \(\[Integral]\_1\%\[Infinity]\), 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["z",
                "TI"], 
              StyleBox["t",
                "TI"]}]], "/", 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            StyleBox["n",
              "TI"]], "\[DifferentialD]", 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.43"}],

Cell[TextData[{
  "The second ",
  StyleBox["exponential integral function", "TB"],
  " ",
  StyleBox["ExpIntegralEi[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is defined by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Ei", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", "-", 
          SubsuperscriptBox["\[Integral]", 
            RowBox[{"-", 
              StyleBox["z",
                "TI"]}], "\[Infinity]"], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["t",
                "TI"]}]], "/", 
          StyleBox["t",
            "TI"], "\[DifferentialD]", 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " (for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            "TI"], ">", "0"}], TraditionalForm]], "InlineFormula"],
  "), where the principal value of the integral is taken. "
}], "Text",
  CellTags->{"S3.2.11", "11.44"}],

Cell[TextData[{
  "The ",
  StyleBox["logarithmic integral function", "TB"],
  " ",
  StyleBox["LogIntegral[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"li", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SubsuperscriptBox["\[Integral]", "0", 
            StyleBox["z",
              "TI"]], 
          StyleBox[\(d  t\),
            "TI"], "/", 
          RowBox[{"log", 
            StyleBox["t",
              "TI"]}]}], TraditionalForm]], "InlineFormula"],
  " (for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            "TI"], ">", "1"}], TraditionalForm]], "InlineFormula"],
  "), where the principal value of the integral is taken. ",
  Cell[BoxData[
      FormBox[
        RowBox[{"li", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is central to the study of the distribution of primes in number theory. \
The logarithmic integral function is sometimes also denoted by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Li", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". In some number\[Hyphen]theoretical applications, ",
  Cell[BoxData[
      FormBox[
        RowBox[{"li", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is defined as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox["\[Integral]", "2", 
            StyleBox["z",
              "TI"]], 
          StyleBox[\(d  t\),
            "TI"], "/", 
          RowBox[{"log", 
            StyleBox["t",
              "TI"]}]}], TraditionalForm]], "InlineFormula"],
  ", with no principal value taken. This differs from the definition used in \
",
  StyleBox["Mathematica", "TI"],
  " by the constant ",
  Cell[BoxData[
      \(TraditionalForm\`li(2)\)], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.11", "11.45"}],

Cell[TextData[{
  "The ",
  StyleBox["sine and cosine integral functions", "TB"],
  " ",
  StyleBox["SinIntegral[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["CosIntegral[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " are defined by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Si", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SubsuperscriptBox["\[Integral]", "0", 
            StyleBox["z",
              "TI"]], 
          RowBox[{"sin", 
            RowBox[{"(", 
              StyleBox["t",
                "TI"], ")"}]}], "/", 
          StyleBox["t",
            "TI"], "\[DifferentialD]", 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Ci", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", "-", 
          SubsuperscriptBox["\[Integral]", 
            StyleBox["z",
              "TI"], "\[Infinity]"], 
          RowBox[{"cos", 
            RowBox[{"(", 
              StyleBox["t",
                "TI"], ")"}]}], "/", 
          StyleBox["t",
            "TI"], "\[DifferentialD]", 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". The ",
  StyleBox["hyperbolic sine and cosine integral functions", "TB"],
  " ",
  StyleBox["SinhIntegral[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["CoshIntegral[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " are defined by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Shi", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SubsuperscriptBox["\[Integral]", "0", 
            StyleBox["z",
              "TI"]], 
          RowBox[{"sinh", 
            RowBox[{"(", 
              StyleBox["t",
                "TI"], ")"}]}], "/", 
          StyleBox["t",
            "TI"], "\[DifferentialD]", 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Chi", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", "\[Gamma]", "+", "log", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "+", 
          SubsuperscriptBox["\[Integral]", "0", 
            StyleBox["z",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{"cosh", 
              RowBox[{"(", 
                StyleBox["t",
                  "TI"], ")"}], "-", "1"}], ")"}], "/", 
          StyleBox["t",
            "TI"], "\[DifferentialD]", 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.2.11", "11.46"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Error Function and Related Functions", "Subsubsection",
  CellTags->{"S3.2.11", "11.47"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Erf[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "error function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"erf", 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Erf[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generalized error function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"erf", 
                      RowBox[{"(", 
                        SubscriptBox[
                          StyleBox["z",
                            "TI"], "1"], ")"}], "-", "erf", 
                      RowBox[{"(", 
                        SubscriptBox[
                          StyleBox["z",
                            "TI"], "0"], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Erfc[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "complementary error function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"erfc", 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Erfi[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "imaginary error function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"erfi", 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FresnelC[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Fresnel integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["C",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FresnelS[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Fresnel integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["S",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InverseErf[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["inverse error function "]},
          {Cell[TextData[{
              StyleBox["InverseErfc[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["inverse complementary error function "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.11"],

Cell["Error function and related functions. ", "Caption",
  CellTags->"S3.2.11"],

Cell[TextData[{
  "The ",
  StyleBox["error function", "TB"],
  " ",
  StyleBox["Erf[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is the integral of the Gaussian distribution, given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"erf", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", "2", "/", \(\@\[Pi]\), 
          SubsuperscriptBox["\[Integral]", "0", 
            StyleBox["z",
              "TI"]], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              SuperscriptBox[
                StyleBox["t",
                  "TI"], "2"]}]], 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". The ",
  StyleBox["complementary error function", "TB"],
  " ",
  StyleBox["Erfc[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is given simply by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"erfc", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", "1", "-", "erf", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". The ",
  StyleBox["imaginary error function", "TB"],
  " ",
  StyleBox["Erfi[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"erfi", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", "erf", 
          RowBox[{"(", 
            StyleBox[\(i  z\),
              "TI"], ")"}], "/", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". The generalized error function ",
  StyleBox["Erf[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["z",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["z",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox["]", "MR"],
  " is defined by the integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{"2", "/", \(\@\[Pi]\), 
          SubsuperscriptBox["\[Integral]", 
            SubscriptBox[
              StyleBox["z",
                "TI"], "0"], 
            SubscriptBox[
              StyleBox["z",
                "TI"], "1"]], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              SuperscriptBox[
                StyleBox["t",
                  "TI"], "2"]}]], 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". The error function is central to many calculations in statistics."
}], "Text",
  CellTags->{"S3.2.11", "11.48"}],

Cell[TextData[{
  "The ",
  StyleBox["inverse error function", "TB"],
  " ",
  StyleBox["InverseErf[", "MR"],
  StyleBox["s", "TI"],
  StyleBox["]", "MR"],
  " is defined as the solution for ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  " in the equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["s",
            "TI"], "=", "erf", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". The inverse error function appears in computing confidence intervals in \
statistics as well as in some algorithms for generating Gaussian random \
numbers.   "
}], "Text",
  CellTags->{"S3.2.11", "11.49"}],

Cell[TextData[{
  "Closely related to the error function are the ",
  StyleBox["Fresnel integrals", "TB"],
  " ",
  StyleBox["FresnelC[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " defined by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["C",
            "TI"], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SubsuperscriptBox["\[Integral]", "0", 
            StyleBox["z",
              "TI"]], "cos", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"\[Pi]", 
                SuperscriptBox[
                  StyleBox["t",
                    "TI"], "2"]}], "/", "2"}], ")"}], 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " and ",
  StyleBox["FresnelS[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " defined by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["S",
            "TI"], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SubsuperscriptBox["\[Integral]", "0", 
            StyleBox["z",
              "TI"]], "sin", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"\[Pi]", 
                SuperscriptBox[
                  StyleBox["t",
                    "TI"], "2"]}], "/", "2"}], ")"}], 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". Fresnel integrals occur in diffraction theory.  "
}], "Text",
  CellTags->{"S3.2.11", "11.50"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bessel and Related Functions", "Subsubsection",
  CellTags->{"S3.2.11", "11.51"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["AiryAi[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              "\[ThinSpace]and\[ThinSpace]",
              StyleBox["AiryBi[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Airy functions ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"Ai", 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " and ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"Bi", 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["AiryAiPrime[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              "\[ThinSpace]and\[ThinSpace]",
              StyleBox["AiryBiPrime[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "derivatives of Airy functions ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(Ai\^\[Prime]\), 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " and ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(Bi\^\[Prime]\), 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["BesselJ[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              "\[ThinSpace]and\[ThinSpace]",
              StyleBox["BesselY[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Bessel functions ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["J",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " and ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["Y",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["BesselI[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              "\[ThinSpace]and\[ThinSpace]",
              StyleBox["BesselK[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "modified Bessel functions ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["I",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " and ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["K",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StruveH[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              "\[ThinSpace]and\[ThinSpace]",
              StyleBox["StruveL[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Struve function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["H",
                          "TB"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " and modified Struve function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["L",
                          "TB"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.11"],

Cell["Bessel and related functions. ", "Caption",
  CellTags->"S3.2.11"],

Cell[TextData[{
  "The ",
  StyleBox["Bessel functions", "TB"],
  " ",
  StyleBox["BesselJ[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["BesselY[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " are linearly independent solutions to the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["z",
              "TI"], "2"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "+", 
          StyleBox["z",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "+", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["z",
                  "TI"], "2"], "-", 
              SuperscriptBox[
                StyleBox["n",
                  "TI"], "2"]}], ")"}], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". For integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", the ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["J",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " are regular at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", while the ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["Y",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " have a logarithmic divergence at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.11", "11.52"}],

Cell["\<\
Bessel functions arise in solving differential equations for \
systems with cylindrical symmetry.   \
\>", "Text",
  CellTags->{"S3.2.11", "11.53"}],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["J",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is often called the ",
  StyleBox["Bessel function of the first kind", "TB"],
  ", or simply ",
  StyleBox["the", "TI"],
  " Bessel function. ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["Y",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is referred to as the ",
  StyleBox["Bessel function of the second kind", "TB"],
  ", the ",
  StyleBox["Weber function", "TB"],
  ", or the ",
  StyleBox["Neumann function", "TB"],
  " (denoted ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["N",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ").  "
}], "Text",
  CellTags->{"S3.2.11", "11.54"}],

Cell[TextData[{
  "The ",
  StyleBox["Hankel functions", "TB"],
  " (or ",
  StyleBox["Bessel functions of the third kind", "TB"],
  ") ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["H",
              "TI"], 
            StyleBox["n",
              "TI"], \((1, 2)\)], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SubscriptBox[
            StyleBox["J",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "\[PlusMinus]", 
          StyleBox["i",
            "TI"], 
          SubscriptBox[
            StyleBox["Y",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " give an alternative pair of solutions to the Bessel differential \
equation. "
}], "Text",
  CellTags->{"S3.2.11", "11.55"}],

Cell[TextData[{
  "In studying systems with spherical symmetry, ",
  StyleBox["spherical Bessel functions", "TB"],
  " arise, defined by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["f",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SqrtBox[
            RowBox[{"\[Pi]", "/", 
              RowBox[{"2", 
                StyleBox["z",
                  "TI"]}]}]], 
          SubscriptBox[
            StyleBox["F",
              "TI"], 
            RowBox[{
              StyleBox["n",
                "TI"], "+", \(1\/2\)}]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        StyleBox["f",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          "TI"], TraditionalForm]], "InlineFormula"],
  " can be ",
  Cell[BoxData[
      FormBox[
        StyleBox["j",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["J",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["Y",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", or ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["h",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["H",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". For integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " gives exact algebraic formulas for spherical Bessel functions. "
}], "Text",
  CellTags->{"S3.2.11", "11.56"}],

Cell[TextData[{
  "The ",
  StyleBox["modified Bessel functions", "TB"],
  " ",
  StyleBox["BesselI[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["BesselK[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " are solutions to the differential equation  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["z",
              "TI"], "2"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "+", 
          StyleBox["z",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "-", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["z",
                  "TI"], "2"], "+", 
              SuperscriptBox[
                StyleBox["n",
                  "TI"], "2"]}], ")"}], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". For integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["I",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is regular at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  "; ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["K",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " always has a logarithmic divergence at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". The ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["I",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " are sometimes known as ",
  StyleBox["hyperbolic Bessel functions", "TB"],
  ".  "
}], "Text",
  CellTags->{"S3.2.11", "11.57"}],

Cell[TextData[{
  "Particularly in electrical engineering, one often defines the ",
  StyleBox["Kelvin functions", "TB"],
  ", according to ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["ber", 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "+", 
          StyleBox["i",
            "TI"], " ", 
          SubscriptBox["bei", 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{
              StyleBox["n",
                "TI"], "\[Pi]", 
              StyleBox["i",
                "TI"]}]], 
          SubscriptBox[
            StyleBox["J",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["z",
                "TI"], 
              SuperscriptBox[
                StyleBox["e",
                  "TI"], 
                RowBox[{"-", "\[Pi]", 
                  StyleBox["i",
                    "TI"], "/", "4"}]]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["ker", 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "+", 
          StyleBox["i",
            "TI"], " ", 
          SubscriptBox["kei", 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["n",
                "TI"], "\[Pi]", 
              StyleBox["i",
                "TI"], "/", "2"}]], 
          SubscriptBox[
            StyleBox["K",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["z",
                "TI"], 
              SuperscriptBox[
                StyleBox["e",
                  "TI"], 
                RowBox[{"\[Pi]", 
                  StyleBox["i",
                    "TI"], "/", "4"}]]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.58"}],

Cell[TextData[{
  "The ",
  StyleBox["Airy functions", "TB"],
  " ",
  StyleBox["AiryAi[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["AiryBi[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " are the two independent solutions ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Ai", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Bi", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " to the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "-", 
          StyleBox["z",
            "TI"], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Ai", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " tends to zero for large positive ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", while ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Bi", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " increases unboundedly. The Airy functions are related to modified Bessel \
functions with one\[Hyphen]third\[Hyphen]integer orders. The Airy functions \
often appear as the solutions to boundary value problems in electromagnetic \
theory and quantum mechanics. In many cases the ",
  StyleBox["derivatives of the Airy functions", "TB"],
  " ",
  StyleBox["AiryAiPrime[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["AiryBiPrime[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " also appear.  "
}], "Text",
  CellTags->{"S3.2.11", "11.59"}],

Cell[TextData[{
  "The ",
  StyleBox["Struve function", "TB"],
  " ",
  StyleBox["StruveH[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " appears in the solution of the inhomogeneous Bessel equation which for \
integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " has the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["z",
              "TI"], "2"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "+", 
          StyleBox["z",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "+", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["z",
                  "TI"], "2"], "-", 
              SuperscriptBox[
                StyleBox["n",
                  "TI"], "2"]}], ")"}], 
          StyleBox["y",
            "TI"], "=", \(2\/\[Pi]\), 
          FractionBox[
            SuperscriptBox[
              StyleBox["z",
                "TI"], 
              RowBox[{
                StyleBox["n",
                  "TI"], "+", "1"}]], 
            RowBox[{
              RowBox[{"(", 
                RowBox[{"2", 
                  StyleBox["n",
                    "TI"], "-", "1"}], ")"}], "!!"}]]}], TraditionalForm]], 
    "InlineFormula"],
  "; the general solution to this equation consists of a linear combination \
of Bessel functions with the Struve function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["H",
              "TB"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " added. The ",
  StyleBox["modified Struve function", "TB"],
  " ",
  StyleBox["StruveL[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is given in terms of the ordinary Struve function by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["L",
              "TB"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", "-", 
          StyleBox["i",
            "TI"], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["i",
                "TI"], 
              StyleBox["n",
                "TI"], "\[Pi]", "/", "2"}]], 
          SubscriptBox[
            StyleBox["H",
              "TB"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". Struve functions appear particularly in electromagnetic theory.  "
}], "Text",
  CellTags->{"S3.2.11", "11.60"}],

Cell[TextData[{
  "Here is a plot of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["J",
              "TI"], "0"], 
          RowBox[{"(", 
            SqrtBox[
              StyleBox["x",
                "TI"]], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". This is a curve that an idealized chain hanging from one end can form \
when you wiggle it. "
}], "MathCaption",
  CellTags->{"S3.2.11", "11.61"}],

Cell[CellGroupData[{

Cell["Plot[ BesselJ[0, Sqrt[x]], {x, 0, 50} ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.2.11"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0190476 0.183714 0.419605 [
[.21429 .17121 -6 -9 ]
[.21429 .17121 6 0 ]
[.40476 .17121 -6 -9 ]
[.40476 .17121 6 0 ]
[.59524 .17121 -6 -9 ]
[.59524 .17121 6 0 ]
[.78571 .17121 -6 -9 ]
[.78571 .17121 6 0 ]
[.97619 .17121 -6 -9 ]
[.97619 .17121 6 0 ]
[.01131 .01587 -24 -4.5 ]
[.01131 .01587 0 4.5 ]
[.01131 .09979 -24 -4.5 ]
[.01131 .09979 0 4.5 ]
[.01131 .26763 -18 -4.5 ]
[.01131 .26763 0 4.5 ]
[.01131 .35156 -18 -4.5 ]
[.01131 .35156 0 4.5 ]
[.01131 .43548 -18 -4.5 ]
[.01131 .43548 0 4.5 ]
[.01131 .5194 -18 -4.5 ]
[.01131 .5194 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .18371 m
.21429 .18996 L
s
[(10)] .21429 .17121 0 1 Mshowa
.40476 .18371 m
.40476 .18996 L
s
[(20)] .40476 .17121 0 1 Mshowa
.59524 .18371 m
.59524 .18996 L
s
[(30)] .59524 .17121 0 1 Mshowa
.78571 .18371 m
.78571 .18996 L
s
[(40)] .78571 .17121 0 1 Mshowa
.97619 .18371 m
.97619 .18996 L
s
[(50)] .97619 .17121 0 1 Mshowa
.125 Mabswid
.0619 .18371 m
.0619 .18746 L
s
.1 .18371 m
.1 .18746 L
s
.1381 .18371 m
.1381 .18746 L
s
.17619 .18371 m
.17619 .18746 L
s
.25238 .18371 m
.25238 .18746 L
s
.29048 .18371 m
.29048 .18746 L
s
.32857 .18371 m
.32857 .18746 L
s
.36667 .18371 m
.36667 .18746 L
s
.44286 .18371 m
.44286 .18746 L
s
.48095 .18371 m
.48095 .18746 L
s
.51905 .18371 m
.51905 .18746 L
s
.55714 .18371 m
.55714 .18746 L
s
.63333 .18371 m
.63333 .18746 L
s
.67143 .18371 m
.67143 .18746 L
s
.70952 .18371 m
.70952 .18746 L
s
.74762 .18371 m
.74762 .18746 L
s
.82381 .18371 m
.82381 .18746 L
s
.8619 .18371 m
.8619 .18746 L
s
.9 .18371 m
.9 .18746 L
s
.9381 .18371 m
.9381 .18746 L
s
.25 Mabswid
0 .18371 m
1 .18371 L
s
.02381 .01587 m
.03006 .01587 L
s
[(-0.4)] .01131 .01587 1 0 Mshowa
.02381 .09979 m
.03006 .09979 L
s
[(-0.2)] .01131 .09979 1 0 Mshowa
.02381 .26763 m
.03006 .26763 L
s
[(0.2)] .01131 .26763 1 0 Mshowa
.02381 .35156 m
.03006 .35156 L
s
[(0.4)] .01131 .35156 1 0 Mshowa
.02381 .43548 m
.03006 .43548 L
s
[(0.6)] .01131 .43548 1 0 Mshowa
.02381 .5194 m
.03006 .5194 L
s
[(0.8)] .01131 .5194 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03685 m
.02756 .03685 L
s
.02381 .05783 m
.02756 .05783 L
s
.02381 .07881 m
.02756 .07881 L
s
.02381 .12077 m
.02756 .12077 L
s
.02381 .14175 m
.02756 .14175 L
s
.02381 .16273 m
.02756 .16273 L
s
.02381 .20469 m
.02756 .20469 L
s
.02381 .22567 m
.02756 .22567 L
s
.02381 .24665 m
.02756 .24665 L
s
.02381 .28862 m
.02756 .28862 L
s
.02381 .3096 m
.02756 .3096 L
s
.02381 .33058 m
.02756 .33058 L
s
.02381 .37254 m
.02756 .37254 L
s
.02381 .39352 m
.02756 .39352 L
s
.02381 .4145 m
.02756 .4145 L
s
.02381 .45646 m
.02756 .45646 L
s
.02381 .47744 m
.02756 .47744 L
s
.02381 .49842 m
.02756 .49842 L
s
.02381 .54038 m
.02756 .54038 L
s
.02381 .56136 m
.02756 .56136 L
s
.02381 .58234 m
.02756 .58234 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .41604 L
.10458 .26338 L
.12507 .20574 L
.14415 .16059 L
.18221 .09217 L
.20263 .06582 L
.2212 .04729 L
.24035 .03305 L
.25115 .027 L
.26113 .02257 L
.2708 .01929 L
.27986 .01705 L
.28505 .01612 L
.28979 .01548 L
.29241 .01521 L
.29527 .01499 L
.29658 .0149 L
.29797 .01484 L
.29929 .01478 L
.30048 .01475 L
.30168 .01473 L
.30281 .01472 L
.30404 .01472 L
.30536 .01473 L
.30602 .01474 L
.30674 .01476 L
.30805 .0148 L
.30933 .01485 L
.31051 .01491 L
.31498 .01523 L
.31724 .01544 L
.31973 .01572 L
.3249 .01644 L
.33047 .01742 L
.34055 .0197 L
.36059 .02599 L
.38169 .03481 L
.4198 .05518 L
.46036 .08125 L
.4994 .10876 L
.5409 .13892 L
.58088 .16758 L
.61935 .19385 L
.66027 .21963 L
.69967 .24183 L
.73756 .26038 L
.7779 .27693 L
.81672 .28961 L
.83647 .29484 L
Mistroke
.858 .29962 L
.87886 .30333 L
.89776 .30593 L
.91747 .3079 L
.92828 .30866 L
.93314 .30893 L
.93846 .30918 L
.94341 .30936 L
.94803 .30949 L
.95058 .30954 L
.9529 .30958 L
.95419 .3096 L
.95558 .30961 L
.9569 .30963 L
.95812 .30964 L
.95916 .30964 L
.96027 .30964 L
.96133 .30964 L
.96229 .30964 L
.96336 .30964 L
.96453 .30963 L
.96575 .30963 L
.96689 .30962 L
.96925 .30959 L
.97139 .30955 L
.97619 .30945 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.11"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.2.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " generates explicit formulas for half\[Hyphen]integer\[Hyphen]order Bessel \
functions. "
}], "MathCaption",
  CellTags->{"S3.2.11", "11.62"}],

Cell[CellGroupData[{

Cell["BesselK[3/2, x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.2.11"],

Cell[BoxData[
    \(\(\[ExponentialE]\^\(-x\)\ \@\(\[Pi]\/2\)\ \((1 + 1\/x)\)\)\/\@x\)], \
"Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.2.11"]
}, Open  ]],

Cell["\<\
The Airy function plotted here gives the quantum\[Hyphen]mechanical \
amplitude for a particle in a potential that increases linearly from left to \
right. The amplitude is exponentially damped in the classically inaccessible \
region on the right. \
\>", "MathCaption",
  CellTags->{"S3.2.11", "11.63"}],

Cell[CellGroupData[{

Cell["Plot[ AiryAi[x], {x, -10, 10} ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.2.11"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0476191 0.273063 0.616577 [
[.02381 .26056 -9 -9 ]
[.02381 .26056 9 0 ]
[.2619 .26056 -6 -9 ]
[.2619 .26056 6 0 ]
[.7381 .26056 -3 -9 ]
[.7381 .26056 3 0 ]
[.97619 .26056 -6 -9 ]
[.97619 .26056 6 0 ]
[.4875 .02643 -24 -4.5 ]
[.4875 .02643 0 4.5 ]
[.4875 .14975 -24 -4.5 ]
[.4875 .14975 0 4.5 ]
[.4875 .39638 -18 -4.5 ]
[.4875 .39638 0 4.5 ]
[.4875 .51969 -18 -4.5 ]
[.4875 .51969 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .27306 m
.02381 .27931 L
s
[(-10)] .02381 .26056 0 1 Mshowa
.2619 .27306 m
.2619 .27931 L
s
[(-5)] .2619 .26056 0 1 Mshowa
.7381 .27306 m
.7381 .27931 L
s
[(5)] .7381 .26056 0 1 Mshowa
.97619 .27306 m
.97619 .27931 L
s
[(10)] .97619 .26056 0 1 Mshowa
.125 Mabswid
.07143 .27306 m
.07143 .27681 L
s
.11905 .27306 m
.11905 .27681 L
s
.16667 .27306 m
.16667 .27681 L
s
.21429 .27306 m
.21429 .27681 L
s
.30952 .27306 m
.30952 .27681 L
s
.35714 .27306 m
.35714 .27681 L
s
.40476 .27306 m
.40476 .27681 L
s
.45238 .27306 m
.45238 .27681 L
s
.54762 .27306 m
.54762 .27681 L
s
.59524 .27306 m
.59524 .27681 L
s
.64286 .27306 m
.64286 .27681 L
s
.69048 .27306 m
.69048 .27681 L
s
.78571 .27306 m
.78571 .27681 L
s
.83333 .27306 m
.83333 .27681 L
s
.88095 .27306 m
.88095 .27681 L
s
.92857 .27306 m
.92857 .27681 L
s
.25 Mabswid
0 .27306 m
1 .27306 L
s
.5 .02643 m
.50625 .02643 L
s
[(-0.4)] .4875 .02643 1 0 Mshowa
.5 .14975 m
.50625 .14975 L
s
[(-0.2)] .4875 .14975 1 0 Mshowa
.5 .39638 m
.50625 .39638 L
s
[(0.2)] .4875 .39638 1 0 Mshowa
.5 .51969 m
.50625 .51969 L
s
[(0.4)] .4875 .51969 1 0 Mshowa
.125 Mabswid
.5 .05726 m
.50375 .05726 L
s
.5 .08809 m
.50375 .08809 L
s
.5 .11892 m
.50375 .11892 L
s
.5 .18058 m
.50375 .18058 L
s
.5 .21141 m
.50375 .21141 L
s
.5 .24223 m
.50375 .24223 L
s
.5 .30389 m
.50375 .30389 L
s
.5 .33472 m
.50375 .33472 L
s
.5 .36555 m
.50375 .36555 L
s
.5 .42721 m
.50375 .42721 L
s
.5 .45804 m
.50375 .45804 L
s
.5 .48886 m
.50375 .48886 L
s
.5 .55052 m
.50375 .55052 L
s
.5 .58135 m
.50375 .58135 L
s
.5 .61218 m
.50375 .61218 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .29788 m
.02846 .35571 L
.03279 .40274 L
.03523 .42486 L
.03754 .44221 L
.03881 .45017 L
.0402 .45741 L
.04145 .46266 L
.04262 .46643 L
.04376 .46904 L
.045 .47064 L
.0457 .47098 L
.04637 .47092 L
.04762 .46981 L
.04894 .46726 L
.05016 .46363 L
.0515 .45829 L
.05293 .45108 L
.0555 .43437 L
.05792 .41461 L
.06244 .36903 L
.07229 .2486 L
.07766 .18367 L
.08269 .13195 L
.08553 .10844 L
.08812 .09143 L
.0895 .08426 L
.091 .078 L
.09182 .07528 L
.09259 .0732 L
.09331 .07163 L
.09409 .0704 L
.09533 .06938 L
.09602 .06932 L
.09666 .06959 L
.09784 .0709 L
.09908 .0734 L
.09973 .07519 L
.10044 .07746 L
.1017 .08245 L
.10458 .09788 L
.10717 .11632 L
.10991 .13999 L
.11482 .19094 L
.12593 .32427 L
.13055 .37671 L
.13552 .42457 L
.13837 .44656 L
.14098 .46255 L
.14223 .46873 L
Mistroke
.14359 .47432 L
.14488 .47846 L
.14608 .4813 L
.14737 .48327 L
.14802 .48382 L
.14873 .4841 L
.14999 .48374 L
.15117 .48242 L
.15189 .48117 L
.15256 .47966 L
.15383 .47603 L
.15519 .47095 L
.15667 .4641 L
.16185 .43011 L
.16664 .38695 L
.18526 .17702 L
.18991 .13134 L
.19235 .11072 L
.19491 .092 L
.19717 .0783 L
.19964 .06651 L
.20072 .06242 L
.20188 .05882 L
.20297 .05615 L
.20396 .05433 L
.20525 .05286 L
.2059 .0525 L
.20661 .05239 L
.20788 .05295 L
.20906 .05432 L
.20977 .05556 L
.21045 .057 L
.21172 .06043 L
.21308 .06513 L
.21457 .07143 L
.21977 .10232 L
.22458 .1416 L
.23431 .24171 L
.24481 .35719 L
.24963 .40474 L
.25472 .44715 L
.25906 .47538 L
.26152 .48767 L
.26381 .49654 L
.26496 .50001 L
.26617 .50298 L
.2668 .50424 L
.2675 .5054 L
.26872 .50685 L
.26988 .50752 L
Mistroke
.27112 .50751 L
.27229 .50679 L
.27336 .50555 L
.27446 .50367 L
.27549 .50141 L
.27781 .49445 L
.27986 .48627 L
.28204 .47556 L
.28731 .44196 L
.29226 .40189 L
.30153 .31246 L
.31992 .13054 L
.32496 .09068 L
.33036 .05629 L
.33298 .04312 L
.33546 .03289 L
.33768 .02561 L
.33893 .02234 L
.3401 .0198 L
.34125 .0178 L
.34249 .0162 L
.34316 .01558 L
.34387 .0151 L
.34513 .01472 L
.34645 .01494 L
.34768 .01573 L
.34839 .01643 L
.34903 .01722 L
.35047 .01954 L
.35284 .02491 L
.3554 .03287 L
.36005 .05263 L
.36538 .08278 L
.37102 .12197 L
.38112 .20532 L
.40094 .38181 L
.4096 .45043 L
.41903 .51258 L
.42421 .54008 L
.42902 .56108 L
.43361 .57708 L
.43849 .58979 L
.44121 .59499 L
.44264 .5972 L
.44415 .59915 L
.44547 .60054 L
.44692 .60174 L
.44824 .60254 L
.44946 .60303 L
.45075 .6033 L
Mistroke
.45197 .60332 L
.45307 .60315 L
.45426 .60278 L
.45555 .60214 L
.45693 .60122 L
.45939 .59896 L
.46191 .59588 L
.4643 .59228 L
.4688 .58393 L
.47892 .55895 L
.49721 .50129 L
.51724 .43571 L
.53539 .38444 L
.55506 .34216 L
.56585 .3248 L
.57603 .31181 L
.58578 .302 L
.5961 .29401 L
.6049 .28878 L
.61457 .28439 L
.62476 .28098 L
.63407 .27871 L
.63921 .27773 L
.6448 .27684 L
.65005 .27615 L
.65498 .27561 L
.66437 .27481 L
.66936 .27449 L
.67474 .27421 L
.68008 .27398 L
.6857 .27378 L
.69096 .27364 L
.69575 .27353 L
.70529 .27337 L
.71053 .2733 L
.71548 .27326 L
.72429 .27319 L
.72926 .27316 L
.73384 .27315 L
.73851 .27313 L
.74353 .27311 L
.7526 .2731 L
.75813 .27309 L
.76338 .27308 L
.76809 .27308 L
.77323 .27307 L
.77856 .27307 L
.78357 .27307 L
.78807 .27307 L
.79294 .27307 L
Mistroke
.79826 .27307 L
.80387 .27307 L
.80866 .27306 L
.81392 .27306 L
.81917 .27306 L
.82415 .27306 L
.82861 .27306 L
.83346 .27306 L
.83873 .27306 L
.84433 .27306 L
.84911 .27306 L
.85438 .27306 L
.85931 .27306 L
.8645 .27306 L
.86892 .27306 L
.87376 .27306 L
.87899 .27306 L
.88458 .27306 L
.88984 .27306 L
.89463 .27306 L
.89949 .27306 L
.90463 .27306 L
.90902 .27306 L
.91384 .27306 L
.91903 .27306 L
.9246 .27306 L
.92985 .27306 L
.93465 .27306 L
.93944 .27306 L
.94454 .27306 L
.94889 .27306 L
.9537 .27306 L
.95885 .27306 L
.96155 .27306 L
.9644 .27306 L
.96964 .27306 L
.97445 .27306 L
.97619 .27306 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.11"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.2.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Legendre and Related Functions", "Subsubsection",
  CellTags->{"S3.2.11", "11.64"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LegendreP[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Legendre functions of the first kind ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["P",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LegendreP[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "associated Legendre functions of the first kind ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox[
                        StyleBox["P",
                          "TI"], 
                        StyleBox["n",
                          "TI"], 
                        StyleBox["m",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LegendreQ[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Legendre functions of the second kind ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["Q",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LegendreQ[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "associated Legendre functions of the second kind ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox[
                        StyleBox["Q",
                          "TI"], 
                        StyleBox["n",
                          "TI"], 
                        StyleBox["m",
                          "TI"]], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.11"],

Cell["Legendre and related functions. ", "Caption",
  CellTags->"S3.2.11"],

Cell[TextData[{
  "The ",
  StyleBox["Legendre functions", "TB"],
  " and ",
  StyleBox["associated Legendre functions", "TB"],
  " satisfy the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"(", 
            RowBox[{"1", "-", 
              SuperscriptBox[
                StyleBox["z",
                  "TI"], "2"]}], ")"}], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "-", "2", 
          StyleBox["z",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "+", 
          RowBox[{"[", 
            RowBox[{
              StyleBox["n",
                "TI"], 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["n",
                    "TI"], "+", "1"}], ")"}], "-", 
              SuperscriptBox[
                StyleBox["m",
                  "TI"], "2"], "/", 
              RowBox[{"(", 
                RowBox[{"1", "-", 
                  SuperscriptBox[
                    StyleBox["z",
                      "TI"], "2"]}], ")"}]}], "]"}], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". The ",
  StyleBox["Legendre functions of the first kind", "TB"],
  ", ",
  StyleBox["LegendreP[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["LegendreP[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  ", reduce to Legendre polynomials when ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " are integers. The ",
  StyleBox["Legendre functions of the second kind", "TB"],
  " ",
  StyleBox["LegendreQ[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["LegendreQ[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " give the second linearly independent solution to the differential \
equation. For integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " they have logarithmic singularities at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            "TI"], "=", "\[PlusMinus]", "1"}], TraditionalForm]], 
    "InlineFormula"],
  ". The ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["P",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["Q",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " solve the differential equation with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.65"}],

Cell["\<\
Legendre functions arise in studies of quantum\[Hyphen]mechanical \
scattering processes. \
\>", "Text",
  CellTags->{"S3.2.11", "11.66"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LegendreP[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " or ",
              StyleBox["LegendreP[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["1,", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "type 1 function containing ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{"1", "-", 
                          SuperscriptBox[
                            StyleBox["z",
                              "TI"], "2"]}], ")"}], 
                      RowBox[{
                        StyleBox["m",
                          "TI"], "/", "2"}]], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LegendreP[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["2,", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "type 2 function containing ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{"(", 
                            RowBox[{"1", "+", 
                              StyleBox["z",
                                "TI"]}], ")"}], "/", 
                          RowBox[{"(", 
                            RowBox[{"1", "-", 
                              StyleBox["z",
                                "TI"]}], ")"}]}], ")"}], 
                      RowBox[{
                        StyleBox["m",
                          "TI"], "/", "2"}]], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LegendreP[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["3,", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "type 3 function containing ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{"(", 
                            RowBox[{"1", "+", 
                              StyleBox["z",
                                "TI"]}], ")"}], "/", 
                          RowBox[{"(", 
                            RowBox[{\(-1\), "+", 
                              StyleBox["z",
                                "TI"]}], ")"}]}], ")"}], 
                      RowBox[{
                        StyleBox["m",
                          "TI"], "/", "2"}]], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.11"],

Cell[TextData[{
  "Types of Legendre functions. Analogous types exist for ",
  StyleBox["LegendreQ", "MR"],
  ". "
}], "Caption",
  CellTags->"S3.2.11"],

Cell[TextData[{
  StyleBox["Legendre functions of type 1", "TB"],
  " are defined only when ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  " lies inside the unit circle in the complex plane. ",
  StyleBox["Legendre functions of type 2", "TB"],
  " have the same numerical values as type 1 inside the unit circle, but are \
also defined outside. The type 2 functions have branch cuts from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " and from ",
  Cell[BoxData[
      \(TraditionalForm\`\(+1\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+\[Infinity]\)\)], "InlineFormula"],
  ". ",
  StyleBox["Legendre functions of type 3", "TB"],
  ", sometimes denoted ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox["\[ScriptCapitalP]", 
            StyleBox["n",
              "TI"], 
            StyleBox["m",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox["\[ScriptCapitalQ]", 
            StyleBox["n",
              "TI"], 
            StyleBox["m",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", have a single branch cut from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+1\)\)], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.67"}],

Cell[TextData[{
  StyleBox["Toroidal functions", "TB"],
  " or ",
  StyleBox["ring functions", "TB"],
  ", which arise in studying systems with toroidal symmetry, can be expressed \
in terms of the Legendre functions ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["P",
              "TI"], \(\[Nu] - 
              1\/2\), \(\(\ \)\(\[Mu]\)\)], \((cosh  \[Eta])\)}], 
        TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["Q",
              "TI"], \(\[Nu] - 
              1\/2\), \(\(\ \)\(\[Mu]\)\)], \((cosh  \[Eta])\)}], 
        TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.2.11", "11.68"}],

Cell[TextData[{
  StyleBox["Conical functions", "TB"],
  " can be expressed in terms of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["P",
              "TI"], 
            RowBox[{"-", \(1\/2\), "+", 
              StyleBox["i",
                "TI"], 
              StyleBox["p",
                "TI"]}], \(\(\ \)\(\[Mu]\)\)], \((cos  \[Theta])\)}], 
        TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["Q",
              "TI"], 
            RowBox[{"-", \(1\/2\), "+", 
              StyleBox["i",
                "TI"], 
              StyleBox["p",
                "TI"]}], \(\(\ \)\(\[Mu]\)\)], \((cos  \[Theta])\)}], 
        TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.11", "11.69"}],

Cell[TextData[{
  "When you use the function ",
  StyleBox["LegendreP[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " with an integer ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", you get a Legendre polynomial. If you take ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " to be an arbitrary complex number, you get, in general, a Legendre \
function. "
}], "Text",
  CellTags->{"S3.2.11", "11.70"}],

Cell[TextData[{
  "In the same way, you can use the functions ",
  StyleBox["GegenbauerC", "MR"],
  " and so on with arbitrary complex indices to get ",
  StyleBox["Gegenbauer functions", "TB"],
  ", ",
  StyleBox["Chebyshev functions", "TB"],
  ", ",
  StyleBox["Hermite functions", "TB"],
  ", ",
  StyleBox["Jacobi functions", "TB"],
  " and ",
  StyleBox["Laguerre functions", "TB"],
  ". Unlike for associated Legendre functions, however, there is no need to \
distinguish different types in such cases.      "
}], "Text",
  CellTags->{"S3.2.11", "11.71"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Confluent Hypergeometric Functions", "Subsubsection",
  CellTags->{"S3.2.11", "11.72"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Hypergeometric0F1[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "hypergeometric function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\[Null]\_0\), 
                      SubscriptBox[
                        StyleBox["F",
                          "TI"], "1"], 
                      RowBox[{"(", 
                        RowBox[{";", 
                          StyleBox["a",
                            "TI"], ";", 
                          StyleBox["z",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Hypergeometric0F1Regularized[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "regularized hypergeometric function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\[Null]\_0\), 
                      SubscriptBox[
                        StyleBox["F",
                          "TI"], "1"], 
                      RowBox[{"(", 
                        RowBox[{";", 
                          StyleBox["a",
                            "TI"], ";", 
                          StyleBox["z",
                            "TI"]}], ")"}], "/", "\[CapitalGamma]", 
                      RowBox[{"(", 
                        StyleBox["a",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Hypergeometric1F1[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Kummer confluent hypergeometric function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\[Null]\_1\), 
                      SubscriptBox[
                        StyleBox["F",
                          "TI"], "1"], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["a",
                            "TI"], ";", 
                          StyleBox["b",
                            "TI"], ";", 
                          StyleBox["z",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Hypergeometric1F1Regularized[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "regularized confluent hypergeometric function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\[Null]\_1\), 
                      SubscriptBox[
                        StyleBox["F",
                          "TI"], "1"], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["a",
                            "TI"], ";", 
                          StyleBox["b",
                            "TI"], ";", 
                          StyleBox["z",
                            "TI"]}], ")"}], "/", "\[CapitalGamma]", 
                      RowBox[{"(", 
                        StyleBox["b",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"]
            }]]},
          {Cell[TextData[{
              StyleBox["HypergeometricU[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "confluent hypergeometric function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["U",
                        "TI"], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["a",
                            "TI"], ",", 
                          StyleBox["b",
                            "TI"], ",", 
                          StyleBox["z",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.11"],

Cell["Confluent hypergeometric functions. ", "Caption",
  CellTags->"S3.2.11"],

Cell[TextData[{
  "Many of the special functions that we have discussed so far can be viewed \
as special cases of the ",
  StyleBox["confluent hypergeometric function", "TB"],
  " ",
  StyleBox["Hypergeometric1F1[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  ".    "
}], "Text",
  CellTags->{"S3.2.11", "11.73"}],

Cell[TextData[{
  "The confluent hypergeometric function can be obtained from the series \
expansion ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ";", 
              StyleBox["b",
                "TI"], ";", 
              StyleBox["z",
                "TI"]}], ")"}], "=", "1", "+", 
          StyleBox[\(a  z\),
            "TI"], "/", 
          StyleBox["b",
            "TI"], "+", 
          RowBox[{
            StyleBox["a",
              "TI"], 
            RowBox[{"(", 
              RowBox[{
                StyleBox["a",
                  "TI"], "+", "1"}], ")"}]}], "/", 
          RowBox[{
            StyleBox["b",
              "TI"], 
            RowBox[{"(", 
              RowBox[{
                StyleBox["b",
                  "TI"], "+", "1"}], ")"}]}], " ", 
          SuperscriptBox[
            StyleBox["z",
              "TI"], "2"], "/", \(2!\), "+", "\[CenterEllipsis]", "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          SubscriptBox[
            RowBox[{"(", 
              StyleBox["a",
                "TI"], ")"}], 
            StyleBox["k",
              "TI"]], "/", 
          SubscriptBox[
            RowBox[{"(", 
              StyleBox["b",
                "TI"], ")"}], 
            StyleBox["k",
              "TI"]], " ", 
          SuperscriptBox[
            StyleBox["z",
              "TI"], 
            StyleBox["k",
              "TI"]], "/", 
          RowBox[{
            StyleBox["k",
              "TI"], "!"}], " "}], TraditionalForm]], "InlineFormula"],
  ". Some special results are obtained when ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["b",
          "TI"], TraditionalForm]], "InlineFormula"],
  " are both integers. If ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["a",
            "TI"], "<", "0"}], TraditionalForm]], "InlineFormula"],
  ", and either ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["b",
            "TI"], ">", "0"}], TraditionalForm]], "InlineFormula"],
  " or ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["b",
            "TI"], "<", 
          StyleBox["a",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ", the series yields a polynomial with a finite number of terms. "
}], "Text",
  CellTags->{"S3.2.11", "11.74"}],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      FormBox[
        StyleBox["b",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is zero or a negative integer, then ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ";", 
              StyleBox["b",
                "TI"], ";", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " itself is infinite. But the ",
  StyleBox["regularized confluent hypergeometric function", "TB"],
  " ",
  StyleBox["Hypergeometric1F1Regularized[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ";", 
              StyleBox["b",
                "TI"], ";", 
              StyleBox["z",
                "TI"]}], ")"}], "/", "\[CapitalGamma]", 
          RowBox[{"(", 
            StyleBox["b",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " has a finite value in all cases. "
}], "Text",
  CellTags->{"S3.2.11", "11.75"}],

Cell[TextData[{
  "Among the functions that can be obtained from ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"]}], TraditionalForm]], "InlineFormula"],
  " are the Bessel functions, error function, incomplete gamma function, and \
Hermite and Laguerre polynomials. "
}], "Text",
  CellTags->{"S3.2.11", "11.76"}],

Cell[TextData[{
  "The function ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ";", 
              StyleBox["b",
                "TI"], ";", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is sometimes denoted ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalPhi]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ";", 
              StyleBox["b",
                "TI"], ";", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " or ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["M",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"], ",", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". It is often known as the ",
  StyleBox["Kummer function", "TB"],
  ".  "
}], "Text",
  CellTags->{"S3.2.11", "11.77"}],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"]}], TraditionalForm]], "InlineFormula"],
  " function can be written in the integral representation ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ";", 
              StyleBox["b",
                "TI"], ";", 
              StyleBox["z",
                "TI"]}], ")"}], "=", 
          RowBox[{"\[CapitalGamma]", 
            RowBox[{"(", 
              StyleBox["b",
                "TI"], ")"}]}], "/", 
          RowBox[{"[", 
            RowBox[{"\[CapitalGamma]", 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["b",
                    "TI"], "-", 
                  StyleBox["a",
                    "TI"]}], ")"}], "\[CapitalGamma]", 
              RowBox[{"(", 
                StyleBox["a",
                  "TI"], ")"}]}], "]"}], \(\[Integral]\_\(\(\ \)\(0\)\)\%1\), 
          
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            StyleBox[\(z  t\),
              "TI"]], 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            RowBox[{
              StyleBox["a",
                "TI"], "-", "1"}]]}], TraditionalForm]], "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                StyleBox["t",
                  "TI"]}], ")"}], 
            RowBox[{
              StyleBox["b",
                "TI"], "-", 
              StyleBox["a",
                "TI"], "-", "1"}]], " ", 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.78"}],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"]}], TraditionalForm]], "InlineFormula"],
  " confluent hypergeometric function is a solution to Kummer's differential \
equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "+", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["b",
                "TI"], "-", 
              StyleBox["z",
                "TI"]}], ")"}], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "-", 
          StyleBox["a",
            "TI"], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", with the boundary conditions ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ";", 
              StyleBox["b",
                "TI"], ";", "0"}], ")"}], "=", "1"}], TraditionalForm]], 
    "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[PartialD]", 
          RowBox[{"[", 
            RowBox[{
              RowBox[{\(\[Null]\_1\), 
                SubscriptBox[
                  StyleBox["F",
                    "TI"], "1"]}], 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["a",
                    "TI"], ";", 
                  StyleBox["b",
                    "TI"], ";", 
                  StyleBox["z",
                    "TI"]}], ")"}]}], "]"}], "/", 
          RowBox[{"\[PartialD]", 
            StyleBox["z",
              "TI"]}], 
          SubscriptBox["\[VerticalSeparator]", 
            RowBox[{
              StyleBox["z",
                "TI"], "=", "0"}]], "=", 
          StyleBox["a",
            "TI"], "/", 
          StyleBox["b",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.79"}],

Cell[TextData[{
  "The function ",
  StyleBox["HypergeometricU[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives a second linearly independent solution to Kummer's equation. For ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Re", " ", 
          StyleBox["b",
            "TI"], ">", "1"}], TraditionalForm]], "InlineFormula"],
  " this function behaves like ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["z",
            "TI"], 
          RowBox[{"1", "-", 
            StyleBox["b",
              "TI"]}]], TraditionalForm]], "InlineFormula"],
  " for small ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". It has a branch cut along the negative real axis in the complex ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  " plane.   "
}], "Text",
  CellTags->{"S3.2.11", "11.80"}],

Cell[TextData[{
  "The function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["U",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"], ",", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " has the integral representation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["U",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"], ",", 
              StyleBox["z",
                "TI"]}], ")"}], "=", "1", "/", 
          RowBox[{"\[CapitalGamma]", 
            RowBox[{"(", 
              StyleBox["a",
                "TI"], ")"}]}], \(\[Integral]\_0\%\[Infinity]\), 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["z",
                "TI"], 
              StyleBox["t",
                "TI"]}]], 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            RowBox[{
              StyleBox["a",
                "TI"], "-", "1"}]], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "+", 
                StyleBox["t",
                  "TI"]}], ")"}], 
            RowBox[{
              StyleBox["b",
                "TI"], "-", 
              StyleBox["a",
                "TI"], "-", "1"}]], " ", 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.81"}],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["U",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"], ",", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", like ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ";", 
              StyleBox["b",
                "TI"], ";", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", is sometimes known as the ",
  StyleBox["Kummer function", "TB"],
  ". The ",
  Cell[BoxData[
      FormBox[
        StyleBox["U",
          "TI"], TraditionalForm]], "InlineFormula"],
  " function is sometimes denoted by ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPsi]\)], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.82"}],

Cell[TextData[{
  "The ",
  StyleBox["Whittaker functions", "TB"],
  " give an alternative pair of solutions to Kummer's differential equation. \
The Whittaker function ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["M",
            "TI"], \(\[Kappa] \(\(,\)\(\ \)\) \[Mu]\)], TraditionalForm]], 
    "InlineFormula"],
  " is related to ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"]}], TraditionalForm]], "InlineFormula"],
  " by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["M",
              "TI"], \(\[Kappa] \(\(,\)\(\ \)\) \[Mu]\)], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["z",
                "TI"], "/", "2"}]], 
          SuperscriptBox[
            StyleBox["z",
              "TI"], \(1/2 + \[Mu]\)], \(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            
            RowBox[{\(1\/2\), "+", "\[Mu]", "-", "\[Kappa]", ";", "1", "+", 
              "2", "\[Mu]", ";", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". The second Whittaker function ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["W",
            "TI"], \(\[Kappa] \(\(,\)\(\ \)\) \[Mu]\)], TraditionalForm]], 
    "InlineFormula"],
  " obeys the same relation, with ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"]}], TraditionalForm]], "InlineFormula"],
  " replaced by ",
  Cell[BoxData[
      FormBox[
        StyleBox["U",
          "TI"], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.11", "11.83"}],

Cell[TextData[{
  "The ",
  StyleBox["parabolic cylinder functions", "TB"],
  " are related to Whittaker functions by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["D",
              "TI"], "\[Nu]"], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", \(2\^\(1/4 + \[Nu]/2\)\), 
          SuperscriptBox[
            StyleBox["z",
              "TI"], \(\(-1\)/2\)], " ", "\[Cross]"}], TraditionalForm]], 
    "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["W",
              "TI"], \(1\/4 + \[Nu]\/2, \(-1\)\/4\)], 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["z",
                  "TI"], "2"], "/", "2"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". For integer ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\)], "InlineFormula"],
  ", the parabolic cylinder functions reduce to Hermite polynomials.  "
}], "Text",
  CellTags->{"S3.2.11", "11.84"}],

Cell[TextData[{
  "The ",
  StyleBox["Coulomb wave functions", "TB"],
  " are also special cases of the confluent hypergeometric function. Coulomb \
wave functions give solutions to the radial Schr\[ODoubleDot]dinger equation \
in the Coulomb potential of a point nucleus. The regular Coulomb wave \
function is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["F",
              "TI"], 
            StyleBox["L",
              "TI"]], \((\[Eta], \[Rho])\), "=", 
          SubscriptBox[
            StyleBox["C",
              "TI"], 
            StyleBox["L",
              "TI"]], \((\[Eta])\), 
          SuperscriptBox["\[Rho]", 
            RowBox[{
              StyleBox["L",
                "TI"], "+", "1"}]], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["i",
                "TI"], "\[Rho]"}]], 
          RowBox[{\(\[Null]\_1\), 
            SubscriptBox[
              StyleBox["F",
                "TI"], "1"]}], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["L",
                "TI"], "+", "1", "-", 
              StyleBox["i",
                "TI"], "\[Eta]", ";", "2", 
              StyleBox["L",
                "TI"], "+", "2", ";", "2", 
              StyleBox["i",
                "TI"], "\[Rho]"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["C",
              "TI"], 
            StyleBox["L",
              "TI"]], \((\[Eta])\), "=", 
          SuperscriptBox["2", 
            StyleBox["L",
              "TI"]], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], \(\(-\[Pi]\[Eta]\)/
              2\)], \(\(\[VerticalSeparator]\)\(\[CapitalGamma]\)\), 
          RowBox[{"(", 
            RowBox[{
              StyleBox["L",
                "TI"], "+", "1", "+", 
              StyleBox["i",
                "TI"], "\[Eta]"}], ")"}], "\[VerticalSeparator]", "/", 
          "\[CapitalGamma]", 
          RowBox[{"(", 
            RowBox[{"2", 
              StyleBox["L",
                "TI"], "+", "2"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.11", "11.85"}],

Cell[TextData[{
  "Other special cases of the confluent hypergeometric function include the \
",
  StyleBox["Toronto functions", "TB"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["T",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["m",
                "TI"], ",", 
              StyleBox["n",
                "TI"], ",", 
              StyleBox["r",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", ",
  StyleBox["Poisson\[Hyphen]Charlier polynomials", "TB"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Rho]", 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{"\[Nu]", ",", 
              StyleBox["x",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", ",
  StyleBox["Cunningham functions", "TB"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Omega]", 
            RowBox[{
              StyleBox["n",
                "TI"], ",", 
              StyleBox["m",
                "TI"]}]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " and ",
  StyleBox["Bateman functions", "TB"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["k",
              "TI"], "\[Nu]"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.86"}],

Cell[TextData[{
  "A limiting form of the confluent hypergeometric function which often \
appears is ",
  StyleBox["Hypergeometric0F1[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  ". This function is obtained as the limit ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_0\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{";", 
              StyleBox["a",
                "TI"], ";", 
              StyleBox["z",
                "TI"]}], ")"}], "=", 
          UnderscriptBox["lim", 
            RowBox[{
              StyleBox["q",
                "TI"], "\[Rule]", "\[Infinity]"}],
            LimitsPositioning->True], \(\[Null]\_1\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["q",
                "TI"], ";", 
              StyleBox["a",
                "TI"], ";", 
              StyleBox["z",
                "TI"], "/", 
              StyleBox["q",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.87"}],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_0\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"]}], TraditionalForm]], "InlineFormula"],
  " function has the series expansion ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_0\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{";", 
              StyleBox["a",
                "TI"], ";", 
              StyleBox["z",
                "TI"]}], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], "1", "/", 
          SubscriptBox[
            RowBox[{"(", 
              StyleBox["a",
                "TI"], ")"}], 
            StyleBox["k",
              "TI"]], " ", 
          SuperscriptBox[
            StyleBox["z",
              "TI"], 
            StyleBox["k",
              "TI"]], "/", 
          RowBox[{
            StyleBox["k",
              "TI"], "!"}]}], TraditionalForm]], "InlineFormula"],
  " and satisfies the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "+", 
          StyleBox["a",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "-", 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.88"}],

Cell[TextData[{
  "Bessel functions of the first kind can be expressed in terms of the ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_0\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"]}], TraditionalForm]], "InlineFormula"],
  " function. "
}], "Text",
  CellTags->{"S3.2.11", "11.89"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hypergeometric Functions and Generalizations", "Subsubsection",
  CellTags->{"S3.2.11", "11.90"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Hypergeometric2F1[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "hypergeometric function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\[Null]\_2\), 
                      SubscriptBox[
                        StyleBox["F",
                          "TI"], "1"], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["a",
                            "TI"], ",", 
                          StyleBox["b",
                            "TI"], ";", 
                          StyleBox["c",
                            "TI"], ";", 
                          StyleBox["z",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Hypergeometric2F1Regularized[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "regularized hypergeometric function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\[Null]\_2\), 
                      SubscriptBox[
                        StyleBox["F",
                          "TI"], "1"], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["a",
                            "TI"], ",", 
                          StyleBox["b",
                            "TI"], ";", 
                          StyleBox["c",
                            "TI"], ";", 
                          StyleBox["z",
                            "TI"]}], ")"}], "/", "\[CapitalGamma]", 
                      RowBox[{"(", 
                        StyleBox["c",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["HypergeometricPFQ[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], 
                      StyleBox["p",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}, {",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] , ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], 
                      StyleBox["q",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}, ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generalized hypergeometric function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox["\[Null]", 
                        StyleBox["p",
                          "TI"]], 
                      SubscriptBox[
                        StyleBox["F",
                          "TI"], 
                        StyleBox["q",
                          "TI"]], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["a",
                            "TB"], ";", 
                          StyleBox["b",
                            "TB"], ";", 
                          StyleBox["z",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["HypergeometricPFQRegularized[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], 
                      StyleBox["p",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}, {",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] , ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], 
                      StyleBox["q",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}, ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["regularized generalized hypergeometric function "]},
          {Cell[TextData[{
              StyleBox["MeijerG[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}, {",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], 
                      RowBox[{
                        StyleBox["n",
                          "TI"], "+", "1"}]], TraditionalForm]], 
                "InlineFormula"],
              ", \[Ellipsis] , ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], 
                      StyleBox["p",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}}, {{",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] , ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], 
                      StyleBox["m",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}, {",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], 
                      RowBox[{
                        StyleBox["m",
                          "TI"], "+", "1"}]], TraditionalForm]], 
                "InlineFormula"],
              ", \[Ellipsis] , ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], 
                      StyleBox["q",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}}, ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["Meijer G function "]},
          {Cell[TextData[{
              StyleBox["AppellF1[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Appell hypergeometric function of two variables ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["F",
                          "TI"], "1"], 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["a",
                            "TI"], ";", 
                          SubscriptBox[
                            StyleBox["b",
                              "TI"], "1"], ",", 
                          SubscriptBox[
                            StyleBox["b",
                              "TI"], "2"], ";", 
                          StyleBox["c",
                            "TI"], ";", 
                          StyleBox["x",
                            "TI"], ",", 
                          StyleBox["y",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.11"],

Cell["Hypergeometric functions and generalizations. ", "Caption",
  CellTags->"S3.2.11"],

Cell[TextData[{
  "The ",
  StyleBox["hypergeometric function", "TB"],
  " ",
  StyleBox["Hypergeometric2F1[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["c", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has series expansion ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_2\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"], ";", 
              StyleBox["c",
                "TI"], ";", 
              StyleBox["z",
                "TI"]}], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          RowBox[{
            SubscriptBox[
              RowBox[{"(", 
                StyleBox["a",
                  "TI"], ")"}], 
              StyleBox["k",
                "TI"]], 
            SubscriptBox[
              RowBox[{"(", 
                StyleBox["b",
                  "TI"], ")"}], 
              StyleBox["k",
                "TI"]]}], "/", 
          SubscriptBox[
            RowBox[{"(", 
              StyleBox["c",
                "TI"], ")"}], 
            StyleBox["k",
              "TI"]], " ", 
          SuperscriptBox[
            StyleBox["z",
              "TI"], 
            StyleBox["k",
              "TI"]], "/", 
          RowBox[{
            StyleBox["k",
              "TI"], "!"}], " "}], TraditionalForm]], "InlineFormula"],
  ". The function is a solution of the hypergeometric differential equation \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            "TI"], 
          RowBox[{"(", 
            RowBox[{"1", "-", 
              StyleBox["z",
                "TI"]}], ")"}], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "+", 
          RowBox[{"[", 
            RowBox[{
              StyleBox["c",
                "TI"], "-", 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["a",
                    "TI"], "+", 
                  StyleBox["b",
                    "TI"], "+", "1"}], ")"}], 
              StyleBox["z",
                "TI"]}], "]"}], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "-", 
          StyleBox["a",
            "TI"], 
          StyleBox["b",
            "TI"], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.2.11", "11.91"}],

Cell[TextData[{
  "The hypergeometric function can also be written as an integral: ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_2\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"], ";", 
              StyleBox["c",
                "TI"], ";", 
              StyleBox["z",
                "TI"]}], ")"}], "=", 
          RowBox[{"\[CapitalGamma]", 
            RowBox[{"(", 
              StyleBox["c",
                "TI"], ")"}]}], "/", 
          RowBox[{"[", 
            RowBox[{"\[CapitalGamma]", 
              RowBox[{"(", 
                StyleBox["b",
                  "TI"], ")"}], "\[CapitalGamma]", 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["c",
                    "TI"], "-", 
                  StyleBox["b",
                    "TI"]}], ")"}]}], "]"}], " ", "\[Cross]"}], 
        TraditionalForm]], "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%1\), 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            RowBox[{
              StyleBox["b",
                "TI"], "-", "1"}]], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                StyleBox["t",
                  "TI"]}], ")"}], 
            RowBox[{
              StyleBox["c",
                "TI"], "-", 
              StyleBox["b",
                "TI"], "-", "1"}]], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                StyleBox["t",
                  "TI"], 
                StyleBox["z",
                  "TI"]}], ")"}], 
            RowBox[{"-", 
              StyleBox["a",
                "TI"]}]], " ", 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.92"}],

Cell[TextData[{
  "The hypergeometric function is also sometimes denoted by ",
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", and is known as the ",
  StyleBox["Gauss series", "TB"],
  " or the ",
  StyleBox["Kummer series", "TB"],
  ".   "
}], "Text",
  CellTags->{"S3.2.11", "11.93"}],

Cell[TextData[{
  "The Legendre functions, and the functions which give generalizations of \
other orthogonal polynomials, can be expressed in terms of the hypergeometric \
function. Complete elliptic integrals can also be expressed in terms of the \
",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_2\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"]}], TraditionalForm]], "InlineFormula"],
  " function. "
}], "Text",
  CellTags->{"S3.2.11", "11.94"}],

Cell[TextData[{
  "The ",
  StyleBox["Riemann P function", "TB"],
  ", which gives solutions to Riemann's differential equation, is also a ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_2\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"]}], TraditionalForm]], "InlineFormula"],
  " function.  "
}], "Text",
  CellTags->{"S3.2.11", "11.95"}],

Cell[TextData[{
  "The ",
  StyleBox["generalized hypergeometric function", "TB"],
  " or ",
  StyleBox["Barnes extended hypergeometric function", "TB"],
  " ",
  StyleBox["HypergeometricPFQ[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["p",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], 
          StyleBox["q",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has series expansion ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Null]", 
            StyleBox["p",
              "TI"]], 
          SubscriptBox[
            StyleBox["F",
              "TI"], 
            StyleBox["q",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TB"], ";", 
              StyleBox["b",
                "TB"], ";", 
              StyleBox["z",
                "TI"]}], ")"}], "="}], TraditionalForm]], "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          RowBox[{
            SubscriptBox[
              RowBox[{"(", 
                SubscriptBox[
                  StyleBox["a",
                    "TI"], "1"], ")"}], 
              StyleBox["k",
                "TI"]], "...", 
            SubscriptBox[
              RowBox[{"(", 
                SubscriptBox[
                  StyleBox["a",
                    "TI"], 
                  StyleBox["p",
                    "TI"]], ")"}], 
              StyleBox["k",
                "TI"]]}], "/", 
          RowBox[{"[", 
            RowBox[{
              SubscriptBox[
                RowBox[{"(", 
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "1"], ")"}], 
                StyleBox["k",
                  "TI"]], "...", 
              SubscriptBox[
                RowBox[{"(", 
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], 
                    StyleBox["q",
                      "TI"]], ")"}], 
                StyleBox["k",
                  "TI"]]}], "]"}], " ", 
          SuperscriptBox[
            StyleBox["z",
              "TI"], 
            StyleBox["k",
              "TI"]], "/", 
          RowBox[{
            StyleBox["k",
              "TI"], "!"}], " "}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.11", "11.96"}],

Cell[TextData[{
  "The ",
  StyleBox["Meijer G function", "TB"],
  " ",
  StyleBox["MeijerG[{{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  "\[Ellipsis]",
  StyleBox[",", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          RowBox[{
            StyleBox["n",
              "TI"], "+", "1"}]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  "\[Ellipsis]",
  StyleBox[",", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["p",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}},", "MR"],
  " ",
  StyleBox["{{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  "\[Ellipsis]",
  StyleBox[",", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], 
          StyleBox["m",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], 
          RowBox[{
            StyleBox["m",
              "TI"], "+", "1"}]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  "\[Ellipsis]",
  StyleBox[",", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], 
          StyleBox["q",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}},", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is defined by the contour integral representation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["G",
              "TI"], 
            StyleBox[\(p  q\),
              "TI"], 
            StyleBox[\(m  n\),
              "TI"]], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["z",
                "TI"], "\[VerticalSeparator]", 
              FractionBox[
                RowBox[{
                  SubscriptBox[
                    StyleBox["a",
                      "TI"], "1"], ",", "\[Ellipsis]", ",", 
                  SubscriptBox[
                    StyleBox["a",
                      "TI"], 
                    StyleBox["p",
                      "TI"]]}], 
                RowBox[{
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "1"], ",", "\[Ellipsis]", ",", 
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], 
                    StyleBox["q",
                      "TI"]]}],
                FractionLine->None]}], ")"}], "=", 
          FractionBox["1", 
            RowBox[{"2", "\[Pi]", 
              StyleBox["i",
                "TI"]}]], "\[Integral]", 
          RowBox[{"\[CapitalGamma]", 
            RowBox[{"(", 
              RowBox[{"1", "-", 
                SubscriptBox[
                  StyleBox["a",
                    "TI"], "1"], "-", 
                StyleBox["s",
                  "TI"]}], ")"}], "\[Ellipsis]\[CapitalGamma]", 
            RowBox[{"(", 
              RowBox[{"1", "-", 
                SubscriptBox[
                  StyleBox["a",
                    "TI"], 
                  StyleBox["n",
                    "TI"]], "-", 
                StyleBox["s",
                  "TI"]}], ")"}], " ", "\[Cross]"}]}], TraditionalForm]], 
    "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalGamma]", 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox[
                StyleBox["b",
                  "TI"], "1"], "+", 
              StyleBox["s",
                "TI"]}], ")"}], "\[Ellipsis]\[CapitalGamma]", 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox[
                StyleBox["b",
                  "TI"], 
                StyleBox["m",
                  "TI"]], "+", 
              StyleBox["s",
                "TI"]}], ")"}], "/", 
          RowBox[{"(", 
            RowBox[{"\[CapitalGamma]", 
              RowBox[{"(", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["a",
                      "TI"], 
                    RowBox[{
                      StyleBox["n",
                        "TI"], "+", "1"}]], "+", 
                  StyleBox["s",
                    "TI"]}], ")"}], "\[Ellipsis]\[CapitalGamma]", 
              RowBox[{"(", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["a",
                      "TI"], 
                    StyleBox["p",
                      "TI"]], "+", 
                  StyleBox["s",
                    "TI"]}], ")"}], "\[CapitalGamma]", 
              RowBox[{"(", 
                RowBox[{"1", "-", 
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], 
                    RowBox[{
                      StyleBox["m",
                        "TI"], "+", "1"}]], "-", 
                  StyleBox["s",
                    "TI"]}], ")"}], "\[Ellipsis]\[CapitalGamma]", 
              RowBox[{"(", 
                RowBox[{"1", "-", 
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], 
                    StyleBox["q",
                      "TI"]], "-", 
                  StyleBox["s",
                    "TI"]}], ")"}]}], ")"}], " ", 
          SuperscriptBox[
            StyleBox["z",
              "TI"], 
            RowBox[{"-", 
              StyleBox["s",
                "TI"]}]], 
          StyleBox["d",
            "TI"], 
          StyleBox["s",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ", where the contour of integration is set up to lie between the poles of \
",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalGamma]", 
          RowBox[{"(", 
            RowBox[{"1", "-", 
              SubscriptBox[
                StyleBox["a",
                  "TI"], 
                StyleBox["i",
                  "TI"]], "-", 
              StyleBox["s",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " and the poles of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalGamma]", 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox[
                StyleBox["b",
                  "TI"], 
                StyleBox["i",
                  "TI"]], "+", 
              StyleBox["s",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". ",
  StyleBox["MeijerG", "MR"],
  " is a very general function whose special cases cover most of the \
functions discussed in the past few sections. "
}], "Text",
  CellTags->{"S3.2.11", "11.97"}],

Cell[TextData[{
  "The ",
  StyleBox["Appell hypergeometric function of two variables", "TB"],
  " ",
  StyleBox["AppellF1[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["c", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  " has series expansion ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ";", 
              SubscriptBox[
                StyleBox["b",
                  "TI"], "1"], ",", 
              SubscriptBox[
                StyleBox["b",
                  "TI"], "2"], ";", 
              StyleBox["c",
                "TI"], ";", 
              StyleBox["x",
                "TI"], ",", 
              StyleBox["y",
                "TI"]}], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["m",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["n",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          SubscriptBox[
            RowBox[{"(", 
              StyleBox["a",
                "TI"], ")"}], 
            RowBox[{
              StyleBox["m",
                "TI"], "+", 
              StyleBox["n",
                "TI"]}]], 
          SubscriptBox[
            RowBox[{"(", 
              SubscriptBox[
                StyleBox["b",
                  "TI"], "1"], ")"}], 
            StyleBox["m",
              "TI"]], 
          SubscriptBox[
            RowBox[{"(", 
              SubscriptBox[
                StyleBox["b",
                  "TI"], "2"], ")"}], 
            StyleBox["n",
              "TI"]], "/", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["m",
                "TI"], "!", 
              StyleBox["n",
                "TI"], "!", 
              SubscriptBox[
                RowBox[{"(", 
                  StyleBox["c",
                    "TI"], ")"}], 
                RowBox[{
                  StyleBox["m",
                    "TI"], "+", 
                  StyleBox["n",
                    "TI"]}]]}], ")"}], 
          SuperscriptBox[
            StyleBox["x",
              "TI"], 
            StyleBox["m",
              "TI"]], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], 
            StyleBox["n",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". This function appears for example in integrating cubic polynomials to \
arbitrary powers.  "
}], "Text",
  CellTags->{"S3.2.11", "11.98"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Product Log Function", "Subsubsection",
  CellTags->{"S3.2.11", "11.99"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ProductLog[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "product log function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["W",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["z",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.11"],

Cell["The product log function.", "Caption",
  CellTags->"S3.2.11"],

Cell[TextData[{
  "The ",
  StyleBox["product log function", "TB"],
  " gives the solution for ",
  Cell[BoxData[
      FormBox[
        StyleBox["w",
          "TI"], TraditionalForm]], "InlineFormula"],
  " in ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            "TI"], "=", 
          StyleBox["w",
            "TI"], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            StyleBox["w",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". The function can be viewed as a generalization of a logarithm. It can be \
used to represent solutions to a variety of transcendental equations. The ",
  StyleBox["tree generating function", "TB"],
  " for counting distinct oriented trees is related to the product log by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["T",
            "TI"], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], "=", "-", 
          StyleBox["W",
            "TI"], 
          RowBox[{"(", 
            RowBox[{"-", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ".    "
}], "Text",
  CellTags->{"S3.2.11", "11.100"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2.12 Elliptic Integrals and Elliptic Functions", "Subsection",
  CellTags->{"S3.2.12", "12.1"}],

Cell["\<\
Even more so than for other special functions, you need to be very \
careful about the arguments you give to elliptic integrals and elliptic \
functions. There are several incompatible conventions in common use, and \
often these conventions are distinguished only by the specific names given to \
arguments or by the presence of separators other than commas between \
arguments. \
\>", "Text",
  CellTags->{"S3.2.12", "12.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] Amplitude  ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
              " (used by ",
              StyleBox["Mathematica", "TI"],
              ", in radians) "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Argument ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["u",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " (used by ",
              StyleBox["Mathematica", "TI"],
              "): related to amplitude by ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Phi]", "=", "am", 
                      RowBox[{"(", 
                        StyleBox["u",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Delta amplitude ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CapitalDelta](\[Phi])\)], 
                "InlineFormula"],
              ": ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[CapitalDelta]", \((\[Phi])\), "=", 
                      SqrtBox[
                        RowBox[{"1", "-", 
                          StyleBox["m",
                            "TI"], \(sin\^2\), \((\[Phi])\)}]]}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Coordinate ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              ": ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["x",
                        "TI"], "=", "sin", \((\[Phi])\)}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Characteristic ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " (used by ",
              StyleBox["Mathematica", "TI"],
              " in elliptic integrals of the third kind) "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Parameter ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["m",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " (used by ",
              StyleBox["Mathematica", "TI"],
              "): preceded by ",
              Cell[BoxData[
                  \(TraditionalForm\` \[VerticalSeparator] \)], 
                "InlineFormula"],
              ", as in ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["I",
                        "TI"], 
                      RowBox[{"(", 
                        
                        RowBox[{\(\(\[Phi]\)\(\ \)\), \
\(\(\[VerticalSeparator]\)\(\ \)\), 
                          StyleBox["m",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Complementary parameter ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ": ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["m",
                          "TI"], "1"], "=", "1", "-", 
                      StyleBox["m",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Modulus ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["k",
                      "TI"], TraditionalForm]], "InlineFormula"],
              ": preceded by comma, as in ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["I",
                        "TI"], 
                      RowBox[{"(", 
                        RowBox[{"\[Phi]", ",", 
                          StyleBox["k",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              "; ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["m",
                        "TI"], "=", 
                      SuperscriptBox[
                        StyleBox["k",
                          "TI"], "2"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Modular angle ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Alpha]\)], "InlineFormula"],
              ": preceded by ",
              Cell[BoxData[
                  \(TraditionalForm\`\\\)], "InlineFormula"],
              "\[ThinSpace], as in ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["I",
                        "TI"], \((\[Phi]\\\[Alpha])\)}], TraditionalForm]], 
                "InlineFormula"],
              "; ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["m",
                        "TI"], "=", \(sin\^2\), \((\[Alpha])\)}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Nome ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["q",
                      "TI"], TraditionalForm]], "InlineFormula"],
              ": preceded by comma in ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Theta]\)], "InlineFormula"],
              " functions; ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["q",
                        "TI"], "=", "exp", 
                      RowBox[{"[", 
                        RowBox[{"-", "\[Pi]", 
                          StyleBox["K",
                            "TI"], 
                          RowBox[{"(", 
                            RowBox[{"1", "-", 
                              StyleBox["m",
                                "TI"]}], ")"}], "/", 
                          StyleBox["K",
                            "TI"], 
                          RowBox[{"(", 
                            StyleBox["m",
                              "TI"], ")"}]}], "]"}], "=", "exp", 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["i",
                            "TI"], \(\[Pi]\[Omega]\^\[Prime]\), "/", 
                          "\[Omega]"}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Invariants ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " (used by ",
              StyleBox["Mathematica", "TI"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Half\[Hyphen]periods ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\)], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\^\[Prime]\)], "InlineFormula"],
              ": ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["g",
                          "TI"], "2"], "=", "60", 
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["r",
                            "TI"], \(\(,\)\(\ \)\), 
                          StyleBox["s",
                            "TI"]}], "\[Prime]",
                        LimitsPositioning->True], 
                      SuperscriptBox[
                        StyleBox["w",
                          "TI"], \(-4\)]}], TraditionalForm]], 
                "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["g",
                          "TI"], "3"], "=", "140", 
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["r",
                            "TI"], \(\(,\)\(\ \)\), 
                          StyleBox["s",
                            "TI"]}], "\[Prime]",
                        LimitsPositioning->True], 
                      SuperscriptBox[
                        StyleBox["w",
                          "TI"], \(-6\)]}], TraditionalForm]], 
                "InlineFormula"],
              ", where ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["w",
                        "TI"], "=", "2", 
                      StyleBox["r",
                        "TI"], "\[Omega]", "+", "2", 
                      StyleBox["s",
                        "TI"], \(\[Omega]\^\[Prime]\)}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Ratio of periods ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Tau]\)], "InlineFormula"],
              ": ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Tau] = \[Omega]\^\[Prime]/\[Omega]\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Discriminant ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CapitalDelta]\)], "InlineFormula"],
              ": ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[CapitalDelta]", "=", 
                      SubsuperscriptBox[
                        StyleBox["g",
                          "TI"], "2", "3"], "-", "27", 
                      SubsuperscriptBox[
                        StyleBox["g",
                          "TI"], "3", "2"]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Parameters of curve ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["a",
                      "TI"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["b",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " (used by ",
              StyleBox["Mathematica", "TI"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Coordinate ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " (used by ",
              StyleBox["Mathematica", "TI"],
              "): related by ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SuperscriptBox[
                        StyleBox["y",
                          "TI"], "2"], "=", 
                      SuperscriptBox[
                        StyleBox["x",
                          "TI"], "3"], "+", 
                      StyleBox["a",
                        "TI"], 
                      SuperscriptBox[
                        StyleBox["x",
                          "TI"], "2"], "+", 
                      StyleBox["b",
                        "TI"], 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.12"],

Cell["\<\
Common argument conventions for elliptic integrals and elliptic \
functions. \
\>", "Caption",
  CellTags->"S3.2.12"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["JacobiAmplitude[", "MR"],
              StyleBox["u", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the amplitude ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
              " corresponding to argument ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["u",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " and parameter ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["m",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["EllipticNomeQ[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the nome ",
              StyleBox["q", "TI"],
              " corresponding to parameter ",
              StyleBox["m", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InverseEllipticNomeQ[", "MR"],
              StyleBox["q", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the parameter ",
              StyleBox["m", "TI"],
              " corresponding to nome ",
              StyleBox["q", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["WeierstrassInvariants[{", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\^\[Prime]\)], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the invariants ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              "}",
              StyleBox[" corresponding to the half\[Hyphen]periods ", "TR"],
              Cell[BoxData[
                  \(TraditionalForm\`{\[Omega], \[Omega]\^\[Prime]}\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["WeierstrassHalfPeriods[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the half\[Hyphen]periods ",
              Cell[BoxData[
                  \(TraditionalForm\`{\[Omega], \[Omega]\^\[Prime]}\)], 
                "InlineFormula"],
              " corresponding to the invariants ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              "}",
              StyleBox[" ", "TR"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.12"],

Cell["Converting between different argument conventions. ", "Caption",
  CellTags->"S3.2.12"],

Cell[CellGroupData[{

Cell["Elliptic Integrals", "Subsubsection",
  CellTags->{"S3.2.12", "12.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["EllipticK[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "complete elliptic integral of the first kind ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["K",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["m",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["EllipticF[", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "elliptic integral of the first kind ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["F",
                        "TI"], 
                      RowBox[{"(", 
                        
                        RowBox[{\(\(\[Phi]\)\(\ \)\), \
\(\(\[VerticalSeparator]\)\(\ \)\), 
                          StyleBox["m",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["EllipticE[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "complete elliptic integral of the second kind ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["E",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["m",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["EllipticE[", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "elliptic integral of the second kind ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["E",
                        "TI"], 
                      RowBox[{"(", 
                        
                        RowBox[{\(\(\[Phi]\)\(\ \)\), \
\(\(\[VerticalSeparator]\)\(\ \)\), 
                          StyleBox["m",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["EllipticPi[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "complete elliptic integral of the third kind ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[CapitalPi]", 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["n",
                            "TI"], " ", \(\(\[VerticalSeparator]\)\(\ \)\), 
                          StyleBox["m",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["EllipticPi[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "elliptic integral of the third kind ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[CapitalPi]", 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["n",
                            "TI"], 
                          ";", \(\(\[Phi]\)\(\ \)\), \(\(\[VerticalSeparator]\
\)\(\ \)\), 
                          StyleBox["m",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["JacobiZeta[", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Jacobi zeta function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["Z",
                        "TI"], 
                      RowBox[{"(", 
                        
                        RowBox[{\(\(\[Phi]\)\(\ \)\), \
\(\(\[VerticalSeparator]\)\(\ \)\), 
                          StyleBox["m",
                            "TI"]}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.2.12"],

Cell["Elliptic integrals. ", "Caption",
  CellTags->"S3.2.12"],

Cell[TextData[{
  "Integrals of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          StyleBox["R",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], ",", 
              StyleBox["y",
                "TI"]}], ")"}], "\[DifferentialD]", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        StyleBox["R",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is a rational function, and ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["y",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " is a cubic or quartic polynomial in ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", are known as ",
  StyleBox["elliptic integrals", "TB"],
  ". Any elliptic integral can be expressed in terms of the three standard \
kinds of ",
  StyleBox["Legendre\[Hyphen]Jacobi elliptic integrals", "TB"],
  ". "
}], "Text",
  CellTags->{"S3.2.12", "12.4"}],

Cell[TextData[{
  "The ",
  StyleBox["elliptic integral of the first kind", "TB"],
  " ",
  StyleBox["EllipticF[", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " is given for ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\)/2 < \[Phi] < \[Pi]/2\)], 
    "InlineFormula"],
  " by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            "TI"], 
          RowBox[{"(", 
            
            RowBox[{\(\(\[Phi]\)\(\ \)\), \(\(\[VerticalSeparator]\)\(\ \)\), 
              
              StyleBox["m",
                "TI"]}], ")"}], "=", \(\[Integral]\_0\%\[Phi]\), 
          SuperscriptBox[
            RowBox[{"[", 
              RowBox[{"1", "-", 
                StyleBox["m",
                  "TI"], \(sin\^2\), \((\[Theta])\)}], "]"}], \(\(-1\)/2\)], 
          "\[DifferentialD]", "\[Theta]"}], TraditionalForm]], 
    "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{"=", \(\[Integral]\_0\%\(sin(\[Phi])\)\), 
          SuperscriptBox[
            RowBox[{"[", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{"1", "-", 
                    SuperscriptBox[
                      StyleBox["t",
                        "TI"], "2"]}], ")"}], 
                RowBox[{"(", 
                  RowBox[{"1", "-", 
                    StyleBox["m",
                      "TI"], 
                    SuperscriptBox[
                      StyleBox["t",
                        "TI"], "2"]}], ")"}]}], "]"}], \(\(-1\)/2\)], 
          "\[DifferentialD]", 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". This elliptic integral arises in solving the equations of motion for a \
simple pendulum. It is sometimes known as an ",
  StyleBox["incomplete elliptic integral of the first kind", "TB"],
  ".  "
}], "Text",
  CellTags->{"S3.2.12", "12.5"}],

Cell[TextData[{
  "Note that the arguments of the elliptic integrals are sometimes given in \
the opposite order from what is used in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.2.12", "12.6"}],

Cell[TextData[{
  "The ",
  StyleBox["complete elliptic integral of the first kind", "TB"],
  " ",
  StyleBox["EllipticK[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["K",
            "TI"], 
          RowBox[{"(", 
            StyleBox["m",
              "TI"], ")"}], "=", 
          StyleBox["F",
            "TI"], 
          RowBox[{"(", 
            RowBox[{\(\[Pi]\/2\), " ", \(\(\[VerticalSeparator]\)\(\ \)\), 
              StyleBox["m",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". Note that ",
  Cell[BoxData[
      FormBox[
        StyleBox["K",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is used to denote the ",
  StyleBox["complete", "TI"],
  " elliptic integral of the first kind, while ",
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is used for its incomplete form. In many applications, the parameter ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is not given explicitly, and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["K",
            "TI"], 
          RowBox[{"(", 
            StyleBox["m",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is denoted simply by ",
  Cell[BoxData[
      FormBox[
        StyleBox["K",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". The ",
  StyleBox["complementary complete elliptic integral of the first kind", 
    "TB"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["K",
              "TI"], "\[Prime]"], 
          RowBox[{"(", 
            StyleBox["m",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["K",
            "TI"], 
          RowBox[{"(", 
            RowBox[{"1", "-", 
              StyleBox["m",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". It is often denoted ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["K",
            "TI"], "\[Prime]"], TraditionalForm]], "InlineFormula"],
  ". ",
  Cell[BoxData[
      FormBox[
        StyleBox["K",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["i",
            "TI"], 
          SuperscriptBox[
            StyleBox["K",
              "TI"], "\[Prime]"]}], TraditionalForm]], "InlineFormula"],
  " give the \[OpenCurlyDoubleQuote]real\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]imaginary\[CloseCurlyDoubleQuote] \
quarter\[Hyphen]periods of the corresponding Jacobi elliptic functions \
discussed below. "
}], "Text",
  CellTags->{"S3.2.12", "12.7"}],

Cell[TextData[{
  "The ",
  StyleBox["elliptic integral of the second kind", "TB"],
  " ",
  StyleBox["EllipticE[", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " is given for ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\)/2 < \[Phi] < \[Pi]/2\)], 
    "InlineFormula"],
  " by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["E",
            "TI"], 
          RowBox[{"(", 
            
            RowBox[{\(\(\[Phi]\)\(\ \)\), \(\(\[VerticalSeparator]\)\(\ \)\), 
              
              StyleBox["m",
                "TI"]}], ")"}], "=", \(\[Integral]\_0\%\[Phi]\), 
          SuperscriptBox[
            RowBox[{"[", 
              RowBox[{"1", "-", 
                StyleBox["m",
                  "TI"], \(sin\^2\), \((\[Theta])\)}], "]"}], \(1/2\)], 
          "\[DifferentialD]", "\[Theta]"}], TraditionalForm]], 
    "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{"=", \(\[Integral]\_0\%\(sin(\[Phi])\)\), 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                SuperscriptBox[
                  StyleBox["t",
                    "TI"], "2"]}], ")"}], \(\(-1\)/2\)], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                StyleBox["m",
                  "TI"], 
                SuperscriptBox[
                  StyleBox["t",
                    "TI"], "2"]}], ")"}], \(1/2\)], "\[DifferentialD]", 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.12", "12.8"}],

Cell[TextData[{
  "The ",
  StyleBox["complete elliptic integral of the second kind", "TB"],
  " ",
  StyleBox["EllipticE[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["E",
            "TI"], 
          RowBox[{"(", 
            StyleBox["m",
              "TI"], ")"}], "=", 
          StyleBox["E",
            "TI"], 
          RowBox[{"(", 
            RowBox[{\(\[Pi]\/2\), " ", \(\(\[VerticalSeparator]\)\(\ \)\), 
              StyleBox["m",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". It is often denoted ",
  Cell[BoxData[
      FormBox[
        StyleBox["E",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". The complementary form is ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["E",
              "TI"], "\[Prime]"], 
          RowBox[{"(", 
            StyleBox["m",
              "TI"], ")"}], "=", 
          StyleBox["E",
            "TI"], 
          RowBox[{"(", 
            RowBox[{"1", "-", 
              StyleBox["m",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.12", "12.9"}],

Cell[TextData[{
  "The ",
  StyleBox["Jacobi zeta function", "TB"],
  " ",
  StyleBox["JacobiZeta[", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Z",
            "TI"], 
          RowBox[{"(", 
            
            RowBox[{\(\(\[Phi]\)\(\ \)\), \(\(\[VerticalSeparator]\)\(\ \)\), 
              
              StyleBox["m",
                "TI"]}], ")"}], "=", 
          StyleBox["E",
            "TI"], 
          RowBox[{"(", 
            
            RowBox[{\(\(\[Phi]\)\(\ \)\), \(\(\[VerticalSeparator]\)\(\ \)\), 
              
              StyleBox["m",
                "TI"]}], ")"}], "-", 
          StyleBox["E",
            "TI"], 
          RowBox[{"(", 
            StyleBox["m",
              "TI"], ")"}], 
          StyleBox["F",
            "TI"], 
          RowBox[{"(", 
            
            RowBox[{\(\(\[Phi]\)\(\ \)\), \(\(\[VerticalSeparator]\)\(\ \)\), 
              
              StyleBox["m",
                "TI"]}], ")"}], "/", 
          StyleBox["K",
            "TI"], 
          RowBox[{"(", 
            StyleBox["m",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.2.12", "12.10"}],

Cell[TextData[{
  "The ",
  StyleBox["Heuman lambda function", "TB"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[CapitalLambda]\_0\), 
          RowBox[{"(", 
            
            RowBox[{\(\(\[Phi]\)\(\ \)\), \(\(\[VerticalSeparator]\)\(\ \)\), 
              
              StyleBox["m",
                "TI"]}], ")"}], "=", 
          StyleBox["F",
            "TI"], 
          RowBox[{"(", 
            
            RowBox[{\(\(\[Phi]\)\(\ \)\), \(\(\[VerticalSeparator]\)\(\ \)\), 
              "1", "-", 
              StyleBox["m",
                "TI"]}], ")"}], "/", 
          StyleBox["K",
            "TI"], 
          RowBox[{"(", 
            RowBox[{"1", "-", 
              StyleBox["m",
                "TI"]}], ")"}], "+", \(2\/\[Pi]\), 
          StyleBox["K",
            "TI"], 
          RowBox[{"(", 
            StyleBox["m",
              "TI"], ")"}], 
          StyleBox["Z",
            "TI"], 
          RowBox[{"(", 
            
            RowBox[{\(\(\[Phi]\)\(\ \)\), \(\(\[VerticalSeparator]\)\(\ \)\), 
              "1", "-", 
              StyleBox["m",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.12", "12.11"}],

Cell[TextData[{
  "The ",
  StyleBox["elliptic integral of the third kind", "TB"],
  " ",
  StyleBox["EllipticPi[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalPi]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], 
              ";", \(\(\[Phi]\)\(\ \)\), \(\(\[VerticalSeparator]\)\(\ \)\), 
              StyleBox["m",
                "TI"]}], ")"}], "=", \(\[Integral]\_0\%\[Phi]\), 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                StyleBox["n",
                  "TI"], \(sin\^2\), \((\[Theta])\)}], ")"}], \(-1\)], 
          SuperscriptBox[
            RowBox[{"[", 
              RowBox[{"1", "-", 
                StyleBox["m",
                  "TI"], \(sin\^2\), \((\[Theta])\)}], "]"}], \(\(-1\)/2\)], 
          "\[DifferentialD]", "\[Theta]"}], TraditionalForm]], 
    "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.2.12", "12.12"}],

Cell[TextData[{
  "The ",
  StyleBox["complete elliptic integral of the third kind", "TB"],
  " ",
  StyleBox["EllipticPi[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalPi]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], " ", \(\(\[VerticalSeparator]\)\(\ \)\), 
              StyleBox["m",
                "TI"]}], ")"}], "=", "\[CapitalPi]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], ";", \(\[Pi]\/2\), 
              " ", \(\(\[VerticalSeparator]\)\(\ \)\), 
              StyleBox["m",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.2.12", "12.13"}],

Cell[TextData[{
  "Here is a plot of the complete elliptic integral of the second kind ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["E",
            "TI"], 
          RowBox[{"(", 
            StyleBox["m",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.12", "12.14"}],

Cell[CellGroupData[{

Cell["Plot[EllipticE[m], {m, 0, 1}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.2.12"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 -1.01648 1.0312 [
[.21429 .00221 -9 -9 ]
[.21429 .00221 9 0 ]
[.40476 .00221 -9 -9 ]
[.40476 .00221 9 0 ]
[.59524 .00221 -9 -9 ]
[.59524 .00221 9 0 ]
[.78571 .00221 -9 -9 ]
[.78571 .00221 9 0 ]
[.97619 .00221 -3 -9 ]
[.97619 .00221 3 0 ]
[.01131 .11783 -18 -4.5 ]
[.01131 .11783 0 4.5 ]
[.01131 .22095 -18 -4.5 ]
[.01131 .22095 0 4.5 ]
[.01131 .32407 -18 -4.5 ]
[.01131 .32407 0 4.5 ]
[.01131 .42719 -18 -4.5 ]
[.01131 .42719 0 4.5 ]
[.01131 .53031 -18 -4.5 ]
[.01131 .53031 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01471 m
.21429 .02096 L
s
[(0.2)] .21429 .00221 0 1 Mshowa
.40476 .01471 m
.40476 .02096 L
s
[(0.4)] .40476 .00221 0 1 Mshowa
.59524 .01471 m
.59524 .02096 L
s
[(0.6)] .59524 .00221 0 1 Mshowa
.78571 .01471 m
.78571 .02096 L
s
[(0.8)] .78571 .00221 0 1 Mshowa
.97619 .01471 m
.97619 .02096 L
s
[(1)] .97619 .00221 0 1 Mshowa
.125 Mabswid
.07143 .01471 m
.07143 .01846 L
s
.11905 .01471 m
.11905 .01846 L
s
.16667 .01471 m
.16667 .01846 L
s
.2619 .01471 m
.2619 .01846 L
s
.30952 .01471 m
.30952 .01846 L
s
.35714 .01471 m
.35714 .01846 L
s
.45238 .01471 m
.45238 .01846 L
s
.5 .01471 m
.5 .01846 L
s
.54762 .01471 m
.54762 .01846 L
s
.64286 .01471 m
.64286 .01846 L
s
.69048 .01471 m
.69048 .01846 L
s
.7381 .01471 m
.7381 .01846 L
s
.83333 .01471 m
.83333 .01846 L
s
.88095 .01471 m
.88095 .01846 L
s
.92857 .01471 m
.92857 .01846 L
s
.25 Mabswid
0 .01471 m
1 .01471 L
s
.02381 .11783 m
.03006 .11783 L
s
[(1.1)] .01131 .11783 1 0 Mshowa
.02381 .22095 m
.03006 .22095 L
s
[(1.2)] .01131 .22095 1 0 Mshowa
.02381 .32407 m
.03006 .32407 L
s
[(1.3)] .01131 .32407 1 0 Mshowa
.02381 .42719 m
.03006 .42719 L
s
[(1.4)] .01131 .42719 1 0 Mshowa
.02381 .53031 m
.03006 .53031 L
s
[(1.5)] .01131 .53031 1 0 Mshowa
.125 Mabswid
.02381 .03534 m
.02756 .03534 L
s
.02381 .05596 m
.02756 .05596 L
s
.02381 .07659 m
.02756 .07659 L
s
.02381 .09721 m
.02756 .09721 L
s
.02381 .13846 m
.02756 .13846 L
s
.02381 .15908 m
.02756 .15908 L
s
.02381 .17971 m
.02756 .17971 L
s
.02381 .20033 m
.02756 .20033 L
s
.02381 .24158 m
.02756 .24158 L
s
.02381 .2622 m
.02756 .2622 L
s
.02381 .28283 m
.02756 .28283 L
s
.02381 .30345 m
.02756 .30345 L
s
.02381 .3447 m
.02756 .3447 L
s
.02381 .36532 m
.02756 .36532 L
s
.02381 .38595 m
.02756 .38595 L
s
.02381 .40657 m
.02756 .40657 L
s
.02381 .44782 m
.02756 .44782 L
s
.02381 .46844 m
.02756 .46844 L
s
.02381 .48907 m
.02756 .48907 L
s
.02381 .50969 m
.02756 .50969 L
s
.02381 .55094 m
.02756 .55094 L
s
.02381 .57156 m
.02756 .57156 L
s
.02381 .59219 m
.02756 .59219 L
s
.02381 .61281 m
.02756 .61281 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .58676 L
.10458 .56841 L
.14415 .55087 L
.18221 .53371 L
.22272 .51511 L
.26171 .49685 L
.30316 .47705 L
.34309 .45756 L
.3815 .43839 L
.42237 .41751 L
.46172 .39689 L
.49955 .37654 L
.53984 .35426 L
.57861 .33215 L
.61984 .30784 L
.65954 .28354 L
.69774 .25922 L
.73838 .23216 L
.77751 .20472 L
.81909 .17373 L
.85916 .14153 L
.89771 .10754 L
.93871 .0661 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.2.12"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.2.12"]
}, Open  ]],

Cell[TextData[{
  "Here is ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["K",
            "TI"], \((\[Alpha])\)}], TraditionalForm]], "InlineFormula"],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] = 30\^\[EmptySmallCircle]\)], 
    "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.2.12", "12.15"}],

Cell[CellGroupData[{

Cell["EllipticK[Sin[30 Degree]^2] // N", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.2.12"],

Cell[BoxData[
    \(1.685750354812596`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.2.12"]
}, Open  ]],

Cell["\<\
The elliptic integrals have a complicated structure in the complex \
plane. \
\>", "MathCaption",
  CellTags->{"S3.2.12", "12.16"}],

Cell[CellGroupData[{

Cell["\<\
Plot3D[ Im[EllipticF[px + I py, 2]], {px, 0.5, 2.5}, {py, -1, 1}, \
PlotPoints->60 ]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.2.12"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
5.87638e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -18 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -5.89944 -9 ]
[.17646 .18758 .10056 0 ]
[.3345 .12542 -16.7601 -9 ]
[.3345 .12542 1.2399 0 ]
[.50253 .05935 -5.27396 -9 ]
[.50253 .05935 .72604 0 ]
[.68156 -0.01098 -14.8837 -9 ]
[.68156 -0.01098 3.11632 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 24 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 18 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02458 .26216 -12 -2.73983 ]
[.02458 .26216 0 6.26017 ]
[.01158 .34363 -12 -2.80876 ]
[.01158 .34363 0 6.19124 ]
[-0.00212 .42953 -6 -2.88183 ]
[-0.00212 .42953 0 6.11817 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0.5)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(1)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(1.5)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(2)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2.5)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-1)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-0.5)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(0.5)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(1)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.0368 .25738 m
.04291 .25499 L
s
[(-4)] .02458 .26216 1 -0.39115 Mshowa
.02387 .33901 m
.03001 .33671 L
s
[(-2)] .01158 .34363 1 -0.37583 Mshowa
.01023 .42509 m
.0164 .42287 L
s
[(0)] -0.00212 .42953 1 -0.35959 Mshowa
.125 Mabswid
.03363 .27739 m
.0373 .27597 L
s
.03042 .29767 m
.0341 .29626 L
s
.02717 .3182 m
.03085 .31681 L
s
.02053 .3601 m
.02422 .35873 L
s
.01714 .38147 m
.02083 .38012 L
s
.01371 .40313 m
.01741 .40179 L
s
.0067 .44735 m
.01041 .44603 L
s
.00313 .46991 m
.00684 .4686 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.635 .731 .918 r
.39325 .78243 .3987 .78757 .40782 .78549 .40239 .78034 Metetra
.634 .731 .918 r
.40239 .78034 .40782 .78549 .41697 .78342 .41156 .77827 Metetra
.633 .731 .919 r
.41156 .77827 .41697 .78342 .42616 .78137 .42077 .77622 Metetra
.632 .732 .92 r
.42077 .77622 .42616 .78137 .43538 .77933 .43001 .77418 Metetra
.63 .732 .921 r
.43001 .77418 .43538 .77933 .44464 .7773 .43928 .77215 Metetra
.629 .732 .921 r
.43928 .77215 .44464 .7773 .45392 .77529 .44858 .77014 Metetra
.628 .732 .922 r
.44858 .77014 .45392 .77529 .46325 .77329 .45792 .76814 Metetra
.627 .733 .923 r
.45792 .76814 .46325 .77329 .4726 .7713 .4673 .76616 Metetra
.626 .733 .924 r
.4673 .76616 .4726 .7713 .48199 .76932 .47671 .76418 Metetra
.625 .734 .925 r
.47671 .76418 .48199 .76932 .49142 .76736 .48615 .76222 Metetra
.624 .734 .926 r
.48615 .76222 .49142 .76736 .50088 .7654 .49563 .76026 Metetra
.623 .735 .927 r
.49563 .76026 .50088 .7654 .51037 .76345 .50515 .75832 Metetra
.622 .735 .928 r
.50515 .75832 .51037 .76345 .51991 .76151 .5147 .75638 Metetra
.621 .736 .928 r
.5147 .75638 .51991 .76151 .52948 .75958 .52429 .75446 Metetra
.621 .736 .929 r
.52429 .75446 .52948 .75958 .53908 .75765 .53391 .75254 Metetra
.62 .737 .93 r
.53391 .75254 .53908 .75765 .54872 .75573 .54357 .75062 Metetra
.619 .737 .931 r
.54357 .75062 .54872 .75573 .5584 .75381 .55328 .74871 Metetra
.618 .738 .932 r
.55328 .74871 .5584 .75381 .56812 .75189 .56301 .7468 Metetra
.617 .739 .933 r
.56301 .7468 .56812 .75189 .57788 .74998 .57279 .7449 Metetra
.617 .74 .934 r
.57279 .7449 .57788 .74998 .58767 .74807 .58261 .743 Metetra
.616 .74 .935 r
.58261 .743 .58767 .74807 .5975 .74616 .59246 .7411 Metetra
.615 .741 .936 r
.59246 .7411 .5975 .74616 .60737 .74426 .60235 .7392 Metetra
.615 .742 .936 r
.60235 .7392 .60737 .74426 .61728 .74235 .61228 .7373 Metetra
.614 .743 .937 r
.61228 .7373 .61728 .74235 .62723 .74044 .62226 .73539 Metetra
.614 .743 .938 r
.62226 .73539 .62723 .74044 .63722 .73852 .63227 .73349 Metetra
.613 .744 .939 r
.63227 .73349 .63722 .73852 .64725 .73661 .64232 .73158 Metetra
.613 .745 .94 r
.64232 .73158 .64725 .73661 .65732 .73469 .65241 .72967 Metetra
.612 .746 .94 r
.65241 .72967 .65732 .73469 .66743 .73277 .66255 .72775 Metetra
.612 .747 .941 r
.66255 .72775 .66743 .73277 .67758 .73084 .67272 .72583 Metetra
.611 .748 .942 r
.67272 .72583 .67758 .73084 .68777 .7289 .68294 .72391 Metetra
.611 .749 .943 r
.68294 .72391 .68777 .7289 .698 .72696 .69319 .72197 Metetra
.965 .716 .511 r
.69319 .72197 .698 .72696 .70267 .61677 .69802 .61157 Metetra
.684 .76 .909 r
.69802 .61157 .70267 .61677 .71259 .61326 .70796 .60803 Metetra
.683 .759 .909 r
.70796 .60803 .71259 .61326 .72253 .60975 .71792 .60447 Metetra
.683 .758 .908 r
.71792 .60447 .72253 .60975 .7325 .60623 .72792 .60091 Metetra
.683 .757 .907 r
.72792 .60091 .7325 .60623 .74251 .6027 .73795 .59734 Metetra
.683 .756 .907 r
.73795 .59734 .74251 .6027 .75254 .59916 .74801 .59375 Metetra
.683 .755 .906 r
.74801 .59375 .75254 .59916 .76261 .59562 .7581 .59017 Metetra
.683 .754 .906 r
.7581 .59017 .76261 .59562 .77271 .59207 .76822 .58657 Metetra
.683 .753 .905 r
.76822 .58657 .77271 .59207 .78284 .58851 .77838 .58297 Metetra
.682 .752 .904 r
.77838 .58297 .78284 .58851 .793 .58495 .78856 .57936 Metetra
.682 .752 .904 r
.78856 .57936 .793 .58495 .8032 .58138 .79879 .57575 Metetra
.682 .751 .903 r
.79879 .57575 .8032 .58138 .81343 .5778 .80904 .57213 Metetra
.682 .75 .903 r
.80904 .57213 .81343 .5778 .82369 .57423 .81933 .56851 Metetra
.681 .749 .902 r
.81933 .56851 .82369 .57423 .83399 .57065 .82965 .56489 Metetra
.681 .748 .902 r
.82965 .56489 .83399 .57065 .84432 .56707 .84 .56127 Metetra
.681 .747 .901 r
.84 .56127 .84432 .56707 .85468 .56349 .85039 .55764 Metetra
.68 .746 .901 r
.85039 .55764 .85468 .56349 .86508 .5599 .86081 .55402 Metetra
.68 .745 .9 r
.86081 .55402 .86508 .5599 .87551 .55632 .87127 .55039 Metetra
.679 .744 .9 r
.87127 .55039 .87551 .55632 .88598 .55274 .88176 .54677 Metetra
.679 .743 .899 r
.88176 .54677 .88598 .55274 .89649 .54917 .89229 .54315 Metetra
.678 .742 .899 r
.89229 .54315 .89649 .54917 .90703 .54559 .90285 .53954 Metetra
.678 .741 .898 r
.90285 .53954 .90703 .54559 .9176 .54202 .91346 .53593 Metetra
.677 .74 .898 r
.91346 .53593 .9176 .54202 .92822 .53846 .92409 .53232 Metetra
.676 .739 .898 r
.92409 .53232 .92822 .53846 .93887 .5349 .93477 .52872 Metetra
.676 .738 .897 r
.93477 .52872 .93887 .5349 .94956 .53135 .94548 .52513 Metetra
.675 .737 .897 r
.94548 .52513 .94956 .53135 .96028 .5278 .95624 .52154 Metetra
.674 .736 .897 r
.95624 .52154 .96028 .5278 .97105 .52426 .96703 .51796 Metetra
.674 .735 .897 r
.96703 .51796 .97105 .52426 .98185 .52073 .97786 .5144 Metetra
.634 .73 .917 r
.38778 .77724 .39325 .78243 .40239 .78034 .39693 .77515 Metetra
.633 .73 .918 r
.39693 .77515 .40239 .78034 .41156 .77827 .40612 .77307 Metetra
.632 .73 .919 r
.40612 .77307 .41156 .77827 .42077 .77622 .41534 .77102 Metetra
.631 .731 .919 r
.41534 .77102 .42077 .77622 .43001 .77418 .4246 .76898 Metetra
.63 .731 .92 r
.4246 .76898 .43001 .77418 .43928 .77215 .43389 .76695 Metetra
.629 .731 .921 r
.43389 .76695 .43928 .77215 .44858 .77014 .44321 .76494 Metetra
.628 .731 .922 r
.44321 .76494 .44858 .77014 .45792 .76814 .45257 .76294 Metetra
.627 .732 .923 r
.45257 .76294 .45792 .76814 .4673 .76616 .46196 .76096 Metetra
.625 .732 .924 r
.46196 .76096 .4673 .76616 .47671 .76418 .47139 .75899 Metetra
.624 .733 .925 r
.47139 .75899 .47671 .76418 .48615 .76222 .48085 .75703 Metetra
.623 .733 .926 r
.48085 .75703 .48615 .76222 .49563 .76026 .49035 .75508 Metetra
.622 .734 .926 r
.49035 .75508 .49563 .76026 .50515 .75832 .49988 .75314 Metetra
.621 .734 .927 r
.49988 .75314 .50515 .75832 .5147 .75638 .50946 .75121 Metetra
.62 .735 .928 r
.50946 .75121 .5147 .75638 .52429 .75446 .51906 .74929 Metetra
.62 .735 .929 r
.51906 .74929 .52429 .75446 .53391 .75254 .52871 .74738 Metetra
.619 .736 .93 r
.52871 .74738 .53391 .75254 .54357 .75062 .53839 .74547 Metetra
.618 .737 .931 r
.53839 .74547 .54357 .75062 .55328 .74871 .54811 .74357 Metetra
.617 .737 .932 r
.54811 .74357 .55328 .74871 .56301 .7468 .55787 .74167 Metetra
.616 .738 .933 r
.55787 .74167 .56301 .7468 .57279 .7449 .56767 .73977 Metetra
.616 .739 .934 r
.56767 .73977 .57279 .7449 .58261 .743 .57751 .73788 Metetra
.615 .74 .935 r
.57751 .73788 .58261 .743 .59246 .7411 .58738 .73599 Metetra
.614 .74 .936 r
.58738 .73599 .59246 .7411 .60235 .7392 .5973 .7341 Metetra
.614 .741 .936 r
.5973 .7341 .60235 .7392 .61228 .7373 .60725 .73221 Metetra
.613 .742 .937 r
.60725 .73221 .61228 .7373 .62226 .73539 .61725 .73031 Metetra
.613 .743 .938 r
.61725 .73031 .62226 .73539 .63227 .73349 .62728 .72842 Metetra
.612 .744 .939 r
.62728 .72842 .63227 .73349 .64232 .73158 .63736 .72652 Metetra
.612 .745 .94 r
.63736 .72652 .64232 .73158 .65241 .72967 .64748 .72462 Metetra
.611 .745 .941 r
.64748 .72462 .65241 .72967 .66255 .72775 .65763 .72271 Metetra
.611 .746 .941 r
.65763 .72271 .66255 .72775 .67272 .72583 .66783 .7208 Metetra
.61 .747 .942 r
.66783 .7208 .67272 .72583 .68294 .72391 .67807 .71888 Metetra
.61 .748 .943 r
.67807 .71888 .68294 .72391 .69319 .72197 .68835 .71695 Metetra
.965 .716 .511 r
.68835 .71695 .69319 .72197 .69802 .61157 .69334 .60634 Metetra
.684 .76 .909 r
.69334 .60634 .69802 .61157 .70796 .60803 .7033 .60275 Metetra
.684 .759 .908 r
.7033 .60275 .70796 .60803 .71792 .60447 .71329 .59915 Metetra
.684 .758 .908 r
.71329 .59915 .71792 .60447 .72792 .60091 .72331 .59555 Metetra
.684 .757 .907 r
.72331 .59555 .72792 .60091 .73795 .59734 .73336 .59193 Metetra
.684 .756 .906 r
.73336 .59193 .73795 .59734 .74801 .59375 .74344 .58831 Metetra
.684 .755 .906 r
.74344 .58831 .74801 .59375 .7581 .59017 .75356 .58467 Metetra
.684 .754 .905 r
.75356 .58467 .7581 .59017 .76822 .58657 .76371 .58103 Metetra
.684 .754 .904 r
.76371 .58103 .76822 .58657 .77838 .58297 .77389 .57739 Metetra
.683 .753 .904 r
.77389 .57739 .77838 .58297 .78856 .57936 .7841 .57374 Metetra
.683 .752 .903 r
.7841 .57374 .78856 .57936 .79879 .57575 .79434 .57008 Metetra
.683 .751 .903 r
.79434 .57008 .79879 .57575 .80904 .57213 .80462 .56642 Metetra
.682 .75 .902 r
.80462 .56642 .80904 .57213 .81933 .56851 .81493 .56275 Metetra
.682 .749 .902 r
.81493 .56275 .81933 .56851 .82965 .56489 .82527 .55909 Metetra
.682 .748 .901 r
.82527 .55909 .82965 .56489 .84 .56127 .83565 .55542 Metetra
.681 .747 .9 r
.83565 .55542 .84 .56127 .85039 .55764 .84607 .55175 Metetra
.681 .746 .9 r
.84607 .55175 .85039 .55764 .86081 .55402 .85651 .54808 Metetra
.68 .745 .899 r
.85651 .54808 .86081 .55402 .87127 .55039 .86699 .54441 Metetra
.68 .744 .899 r
.86699 .54441 .87127 .55039 .88176 .54677 .87751 .54075 Metetra
.679 .743 .899 r
.87751 .54075 .88176 .54677 .89229 .54315 .88807 .53708 Metetra
.679 .742 .898 r
.88807 .53708 .89229 .54315 .90285 .53954 .89865 .53343 Metetra
.678 .741 .898 r
.89865 .53343 .90285 .53954 .91346 .53593 .90928 .52977 Metetra
.678 .74 .897 r
.90928 .52977 .91346 .53593 .92409 .53232 .91994 .52612 Metetra
.677 .739 .897 r
.91994 .52612 .92409 .53232 .93477 .52872 .93065 .52248 Metetra
.676 .738 .897 r
.93065 .52248 .93477 .52872 .94548 .52513 .94138 .51885 Metetra
.676 .737 .896 r
.94138 .51885 .94548 .52513 .95624 .52154 .95216 .51522 Metetra
.675 .736 .896 r
.95216 .51522 .95624 .52154 .96703 .51796 .96298 .51161 Metetra
.674 .735 .896 r
.96298 .51161 .96703 .51796 .97786 .5144 .97383 .508 Metetra
.634 .729 .917 r
.38227 .77199 .38778 .77724 .39693 .77515 .39144 .76989 Metetra
.633 .729 .917 r
.39144 .76989 .39693 .77515 .40612 .77307 .40065 .76782 Metetra
.632 .729 .918 r
.40065 .76782 .40612 .77307 .41534 .77102 .40989 .76576 Metetra
.63 .73 .919 r
.40989 .76576 .41534 .77102 .4246 .76898 .41916 .76372 Metetra
.629 .73 .92 r
.41916 .76372 .4246 .76898 .43389 .76695 .42847 .7617 Metetra
.628 .73 .921 r
.42847 .7617 .43389 .76695 .44321 .76494 .43781 .75969 Metetra
.627 .73 .922 r
.43781 .75969 .44321 .76494 .45257 .76294 .44718 .75769 Metetra
.626 .731 .922 r
.44718 .75769 .45257 .76294 .46196 .76096 .45659 .75571 Metetra
.625 .731 .923 r
.45659 .75571 .46196 .76096 .47139 .75899 .46604 .75374 Metetra
.624 .732 .924 r
.46604 .75374 .47139 .75899 .48085 .75703 .47552 .75179 Metetra
.623 .732 .925 r
.47552 .75179 .48085 .75703 .49035 .75508 .48504 .74985 Metetra
.621 .733 .926 r
.48504 .74985 .49035 .75508 .49988 .75314 .49459 .74792 Metetra
.62 .733 .927 r
.49459 .74792 .49988 .75314 .50946 .75121 .50418 .74599 Metetra
.619 .734 .928 r
.50418 .74599 .50946 .75121 .51906 .74929 .51381 .74408 Metetra
.619 .734 .929 r
.51381 .74408 .51906 .74929 .52871 .74738 .52347 .74217 Metetra
.618 .735 .93 r
.52347 .74217 .52871 .74738 .53839 .74547 .53318 .74028 Metetra
.617 .736 .931 r
.53318 .74028 .53839 .74547 .54811 .74357 .54292 .73838 Metetra
.616 .737 .932 r
.54292 .73838 .54811 .74357 .55787 .74167 .5527 .73649 Metetra
.615 .737 .933 r
.5527 .73649 .55787 .74167 .56767 .73977 .56252 .73461 Metetra
.614 .738 .934 r
.56252 .73461 .56767 .73977 .57751 .73788 .57238 .73272 Metetra
.614 .739 .935 r
.57238 .73272 .57751 .73788 .58738 .73599 .58227 .73084 Metetra
.613 .74 .936 r
.58227 .73084 .58738 .73599 .5973 .7341 .59221 .72896 Metetra
.613 .74 .937 r
.59221 .72896 .5973 .7341 .60725 .73221 .60219 .72708 Metetra
.612 .741 .938 r
.60219 .72708 .60725 .73221 .61725 .73031 .61221 .72519 Metetra
.611 .742 .938 r
.61221 .72519 .61725 .73031 .62728 .72842 .62227 .72331 Metetra
.611 .743 .939 r
.62227 .72331 .62728 .72842 .63736 .72652 .63236 .72142 Metetra
.61 .744 .94 r
.63236 .72142 .63736 .72652 .64748 .72462 .64251 .71952 Metetra
.61 .745 .941 r
.64251 .71952 .64748 .72462 .65763 .72271 .65269 .71763 Metetra
.609 .746 .942 r
.65269 .71763 .65763 .72271 .66783 .7208 .66291 .71572 Metetra
.609 .747 .943 r
.66291 .71572 .66783 .7208 .67807 .71888 .67318 .71381 Metetra
.609 .748 .943 r
.67318 .71381 .67807 .71888 .68835 .71695 .68348 .7119 Metetra
.965 .716 .511 r
.68348 .7119 .68835 .71695 .69334 .60634 .68863 .60107 Metetra
.685 .76 .909 r
.68863 .60107 .69334 .60634 .7033 .60275 .69861 .59744 Metetra
.685 .759 .908 r
.69861 .59744 .7033 .60275 .71329 .59915 .70862 .5938 Metetra
.685 .758 .907 r
.70862 .5938 .71329 .59915 .72331 .59555 .71867 .59015 Metetra
.685 .758 .907 r
.71867 .59015 .72331 .59555 .73336 .59193 .72874 .58649 Metetra
.685 .757 .906 r
.72874 .58649 .73336 .59193 .74344 .58831 .73885 .58282 Metetra
.685 .756 .905 r
.73885 .58282 .74344 .58831 .75356 .58467 .74899 .57914 Metetra
.685 .755 .905 r
.74899 .57914 .75356 .58467 .76371 .58103 .75916 .57546 Metetra
.684 .754 .904 r
.75916 .57546 .76371 .58103 .77389 .57739 .76936 .57176 Metetra
.684 .753 .903 r
.76936 .57176 .77389 .57739 .7841 .57374 .7796 .56807 Metetra
.684 .752 .903 r
.7796 .56807 .7841 .57374 .79434 .57008 .78987 .56436 Metetra
.684 .751 .902 r
.78987 .56436 .79434 .57008 .80462 .56642 .80017 .56066 Metetra
.683 .75 .902 r
.80017 .56066 .80462 .56642 .81493 .56275 .81051 .55695 Metetra
.683 .749 .901 r
.81051 .55695 .81493 .56275 .82527 .55909 .82087 .55323 Metetra
.683 .747 .9 r
.82087 .55323 .82527 .55909 .83565 .55542 .83128 .54952 Metetra
.682 .746 .9 r
.83128 .54952 .83565 .55542 .84607 .55175 .84171 .54581 Metetra
.682 .745 .899 r
.84171 .54581 .84607 .55175 .85651 .54808 .85219 .54209 Metetra
.681 .744 .899 r
.85219 .54209 .85651 .54808 .86699 .54441 .86269 .53838 Metetra
.681 .743 .898 r
.86269 .53838 .86699 .54441 .87751 .54075 .87323 .53467 Metetra
.68 .742 .898 r
.87323 .53467 .87751 .54075 .88807 .53708 .88381 .53096 Metetra
.68 .741 .897 r
.88381 .53096 .88807 .53708 .89865 .53343 .89443 .52726 Metetra
.679 .74 .897 r
.89443 .52726 .89865 .53343 .90928 .52977 .90508 .52356 Metetra
.678 .739 .897 r
.90508 .52356 .90928 .52977 .91994 .52612 .91577 .51987 Metetra
.678 .738 .896 r
.91577 .51987 .91994 .52612 .93065 .52248 .92649 .51619 Metetra
.677 .737 .896 r
.92649 .51619 .93065 .52248 .94138 .51885 .93726 .51251 Metetra
.676 .736 .896 r
.93726 .51251 .94138 .51885 .95216 .51522 .94806 .50885 Metetra
.675 .735 .895 r
.94806 .50885 .95216 .51522 .96298 .51161 .9589 .50519 Metetra
.675 .734 .895 r
.9589 .50519 .96298 .51161 .97383 .508 .96978 .50154 Metetra
.634 .728 .916 r
.37673 .76668 .38227 .77199 .39144 .76989 .38592 .76459 Metetra
.632 .728 .917 r
.38592 .76459 .39144 .76989 .40065 .76782 .39514 .76251 Metetra
.631 .728 .918 r
.39514 .76251 .40065 .76782 .40989 .76576 .4044 .76045 Metetra
.63 .728 .918 r
.4044 .76045 .40989 .76576 .41916 .76372 .41369 .75841 Metetra
.629 .729 .919 r
.41369 .75841 .41916 .76372 .42847 .7617 .42301 .75638 Metetra
.627 .729 .92 r
.42301 .75638 .42847 .7617 .43781 .75969 .43237 .75438 Metetra
.626 .729 .921 r
.43237 .75438 .43781 .75969 .44718 .75769 .44176 .75239 Metetra
.625 .73 .922 r
.44176 .75239 .44718 .75769 .45659 .75571 .45119 .75041 Metetra
.624 .73 .923 r
.45119 .75041 .45659 .75571 .46604 .75374 .46065 .74845 Metetra
.623 .731 .924 r
.46065 .74845 .46604 .75374 .47552 .75179 .47015 .7465 Metetra
.622 .731 .925 r
.47015 .7465 .47552 .75179 .48504 .74985 .47969 .74456 Metetra
.621 .732 .926 r
.47969 .74456 .48504 .74985 .49459 .74792 .48926 .74264 Metetra
.619 .732 .927 r
.48926 .74264 .49459 .74792 .50418 .74599 .49887 .74073 Metetra
.618 .733 .928 r
.49887 .74073 .50418 .74599 .51381 .74408 .50852 .73882 Metetra
.617 .733 .929 r
.50852 .73882 .51381 .74408 .52347 .74217 .51821 .73692 Metetra
.617 .734 .93 r
.51821 .73692 .52347 .74217 .53318 .74028 .52793 .73504 Metetra
.616 .735 .931 r
.52793 .73504 .53318 .74028 .54292 .73838 .53769 .73315 Metetra
.615 .736 .932 r
.53769 .73315 .54292 .73838 .5527 .73649 .54749 .73127 Metetra
.614 .736 .933 r
.54749 .73127 .5527 .73649 .56252 .73461 .55733 .7294 Metetra
.613 .737 .934 r
.55733 .7294 .56252 .73461 .57238 .73272 .56721 .72752 Metetra
.613 .738 .935 r
.56721 .72752 .57238 .73272 .58227 .73084 .57713 .72565 Metetra
.612 .739 .936 r
.57713 .72565 .58227 .73084 .59221 .72896 .58709 .72378 Metetra
.611 .74 .937 r
.58709 .72378 .59221 .72896 .60219 .72708 .59709 .72191 Metetra
.611 .741 .938 r
.59709 .72191 .60219 .72708 .61221 .72519 .60713 .72003 Metetra
.61 .742 .939 r
.60713 .72003 .61221 .72519 .62227 .72331 .61721 .71816 Metetra
.61 .742 .939 r
.61721 .71816 .62227 .72331 .63236 .72142 .62734 .71628 Metetra
.609 .743 .94 r
.62734 .71628 .63236 .72142 .64251 .71952 .6375 .7144 Metetra
.609 .744 .941 r
.6375 .7144 .64251 .71952 .65269 .71763 .64771 .71251 Metetra
.608 .745 .942 r
.64771 .71251 .65269 .71763 .66291 .71572 .65796 .71061 Metetra
.608 .746 .943 r
.65796 .71061 .66291 .71572 .67318 .71381 .66825 .70871 Metetra
.607 .747 .944 r
.66825 .70871 .67318 .71381 .68348 .7119 .67858 .70681 Metetra
.965 .716 .511 r
.67858 .70681 .68348 .7119 .68863 .60107 .68388 .59577 Metetra
.686 .761 .908 r
.68388 .59577 .68863 .60107 .69861 .59744 .69389 .5921 Metetra
.686 .76 .907 r
.69389 .5921 .69861 .59744 .70862 .5938 .70393 .58841 Metetra
.686 .759 .907 r
.70393 .58841 .70862 .5938 .71867 .59015 .71399 .58471 Metetra
.686 .758 .906 r
.71399 .58471 .71867 .59015 .72874 .58649 .72409 .58101 Metetra
.686 .757 .905 r
.72409 .58101 .72874 .58649 .73885 .58282 .73423 .57729 Metetra
.686 .756 .905 r
.73423 .57729 .73885 .58282 .74899 .57914 .74439 .57357 Metetra
.685 .755 .904 r
.74439 .57357 .74899 .57914 .75916 .57546 .75459 .56984 Metetra
.685 .754 .903 r
.75459 .56984 .75916 .57546 .76936 .57176 .76481 .5661 Metetra
.685 .753 .903 r
.76481 .5661 .76936 .57176 .7796 .56807 .77507 .56235 Metetra
.685 .752 .902 r
.77507 .56235 .7796 .56807 .78987 .56436 .78537 .5586 Metetra
.684 .751 .902 r
.78537 .5586 .78987 .56436 .80017 .56066 .79569 .55485 Metetra
.684 .75 .901 r
.79569 .55485 .80017 .56066 .81051 .55695 .80605 .55109 Metetra
.684 .748 .9 r
.80605 .55109 .81051 .55695 .82087 .55323 .81644 .54733 Metetra
.683 .747 .9 r
.81644 .54733 .82087 .55323 .83128 .54952 .82687 .54357 Metetra
.683 .746 .899 r
.82687 .54357 .83128 .54952 .84171 .54581 .83733 .53981 Metetra
.682 .745 .899 r
.83733 .53981 .84171 .54581 .85219 .54209 .84783 .53605 Metetra
.682 .744 .898 r
.84783 .53605 .85219 .54209 .86269 .53838 .85836 .53229 Metetra
.681 .743 .898 r
.85836 .53229 .86269 .53838 .87323 .53467 .86893 .52853 Metetra
.681 .742 .897 r
.86893 .52853 .87323 .53467 .88381 .53096 .87953 .52478 Metetra
.68 .741 .897 r
.87953 .52478 .88381 .53096 .89443 .52726 .89017 .52103 Metetra
.68 .74 .896 r
.89017 .52103 .89443 .52726 .90508 .52356 .90084 .51729 Metetra
.679 .739 .896 r
.90084 .51729 .90508 .52356 .91577 .51987 .91156 .51356 Metetra
.678 .738 .896 r
.91156 .51356 .91577 .51987 .92649 .51619 .92231 .50983 Metetra
.677 .737 .895 r
.92231 .50983 .92649 .51619 .93726 .51251 .9331 .50611 Metetra
.677 .736 .895 r
.9331 .50611 .93726 .51251 .94806 .50885 .94393 .5024 Metetra
.676 .735 .895 r
.94393 .5024 .94806 .50885 .9589 .50519 .95479 .49871 Metetra
.675 .734 .894 r
.95479 .49871 .9589 .50519 .96978 .50154 .9657 .49502 Metetra
.633 .727 .915 r
.37116 .76132 .37673 .76668 .38592 .76459 .38036 .75922 Metetra
.632 .727 .916 r
.38036 .75922 .38592 .76459 .39514 .76251 .3896 .75714 Metetra
.631 .727 .917 r
.3896 .75714 .39514 .76251 .4044 .76045 .39888 .75508 Metetra
.629 .727 .918 r
.39888 .75508 .4044 .76045 .41369 .75841 .40818 .75304 Metetra
.628 .728 .919 r
.40818 .75304 .41369 .75841 .42301 .75638 .41752 .75102 Metetra
.627 .728 .92 r
.41752 .75102 .42301 .75638 .43237 .75438 .4269 .74901 Metetra
.625 .728 .921 r
.4269 .74901 .43237 .75438 .44176 .75239 .43631 .74702 Metetra
.624 .729 .922 r
.43631 .74702 .44176 .75239 .45119 .75041 .44576 .74505 Metetra
.623 .729 .923 r
.44576 .74505 .45119 .75041 .46065 .74845 .45524 .7431 Metetra
.622 .729 .924 r
.45524 .7431 .46065 .74845 .47015 .7465 .46476 .74116 Metetra
.621 .73 .925 r
.46476 .74116 .47015 .7465 .47969 .74456 .47431 .73923 Metetra
.619 .731 .926 r
.47431 .73923 .47969 .74456 .48926 .74264 .4839 .73731 Metetra
.618 .731 .927 r
.4839 .73731 .48926 .74264 .49887 .74073 .49353 .73541 Metetra
.617 .732 .928 r
.49353 .73541 .49887 .74073 .50852 .73882 .5032 .73351 Metetra
.616 .733 .929 r
.5032 .73351 .50852 .73882 .51821 .73692 .5129 .73163 Metetra
.615 .733 .93 r
.5129 .73163 .51821 .73692 .52793 .73504 .52265 .72975 Metetra
.614 .734 .931 r
.52265 .72975 .52793 .73504 .53769 .73315 .53243 .72788 Metetra
.614 .735 .932 r
.53243 .72788 .53769 .73315 .54749 .73127 .54225 .72601 Metetra
.613 .736 .933 r
.54225 .72601 .54749 .73127 .55733 .7294 .55211 .72414 Metetra
.612 .736 .934 r
.55211 .72414 .55733 .7294 .56721 .72752 .56202 .72228 Metetra
.611 .737 .935 r
.56202 .72228 .56721 .72752 .57713 .72565 .57196 .72042 Metetra
.611 .738 .936 r
.57196 .72042 .57713 .72565 .58709 .72378 .58194 .71856 Metetra
.61 .739 .937 r
.58194 .71856 .58709 .72378 .59709 .72191 .59196 .7167 Metetra
.609 .74 .938 r
.59196 .7167 .59709 .72191 .60713 .72003 .60203 .71484 Metetra
.609 .741 .939 r
.60203 .71484 .60713 .72003 .61721 .71816 .61213 .71297 Metetra
.608 .742 .94 r
.61213 .71297 .61721 .71816 .62734 .71628 .62228 .7111 Metetra
.608 .743 .941 r
.62228 .7111 .62734 .71628 .6375 .7144 .63247 .70923 Metetra
.607 .744 .941 r
.63247 .70923 .6375 .7144 .64771 .71251 .6427 .70735 Metetra
.607 .745 .942 r
.6427 .70735 .64771 .71251 .65796 .71061 .65297 .70547 Metetra
.606 .746 .943 r
.65297 .70547 .65796 .71061 .66825 .70871 .66329 .70358 Metetra
.606 .747 .944 r
.66329 .70358 .66825 .70871 .67858 .70681 .67364 .70168 Metetra
.965 .716 .511 r
.67364 .70168 .67858 .70681 .68388 .59577 .67911 .59044 Metetra
.687 .761 .908 r
.67911 .59044 .68388 .59577 .69389 .5921 .68914 .58672 Metetra
.687 .76 .907 r
.68914 .58672 .69389 .5921 .70393 .58841 .6992 .58298 Metetra
.687 .759 .906 r
.6992 .58298 .70393 .58841 .71399 .58471 .70929 .57924 Metetra
.687 .758 .906 r
.70929 .57924 .71399 .58471 .72409 .58101 .71942 .57549 Metetra
.687 .757 .905 r
.71942 .57549 .72409 .58101 .73423 .57729 .72957 .57172 Metetra
.687 .756 .904 r
.72957 .57172 .73423 .57729 .74439 .57357 .73976 .56795 Metetra
.686 .755 .904 r
.73976 .56795 .74439 .57357 .75459 .56984 .74998 .56417 Metetra
.686 .754 .903 r
.74998 .56417 .75459 .56984 .76481 .5661 .76023 .56039 Metetra
.686 .753 .902 r
.76023 .56039 .76481 .5661 .77507 .56235 .77052 .5566 Metetra
.686 .752 .902 r
.77052 .5566 .77507 .56235 .78537 .5586 .78083 .5528 Metetra
.685 .751 .901 r
.78083 .5528 .78537 .5586 .79569 .55485 .79118 .549 Metetra
.685 .75 .9 r
.79118 .549 .79569 .55485 .80605 .55109 .80157 .54519 Metetra
.685 .748 .9 r
.80157 .54519 .80605 .55109 .81644 .54733 .81199 .54138 Metetra
.684 .747 .899 r
.81199 .54138 .81644 .54733 .82687 .54357 .82244 .53758 Metetra
.684 .746 .899 r
.82244 .53758 .82687 .54357 .83733 .53981 .83292 .53376 Metetra
.683 .745 .898 r
.83292 .53376 .83733 .53981 .84783 .53605 .84344 .52996 Metetra
.683 .744 .897 r
.84344 .52996 .84783 .53605 .85836 .53229 .854 .52615 Metetra
.682 .743 .897 r
.854 .52615 .85836 .53229 .86893 .52853 .86459 .52234 Metetra
.682 .742 .896 r
.86459 .52234 .86893 .52853 .87953 .52478 .87522 .51854 Metetra
.681 .741 .896 r
.87522 .51854 .87953 .52478 .89017 .52103 .88588 .51475 Metetra
.68 .739 .896 r
.88588 .51475 .89017 .52103 .90084 .51729 .89658 .51096 Metetra
.68 .738 .895 r
.89658 .51096 .90084 .51729 .91156 .51356 .90732 .50718 Metetra
.679 .737 .895 r
.90732 .50718 .91156 .51356 .92231 .50983 .9181 .50341 Metetra
.678 .736 .894 r
.9181 .50341 .92231 .50983 .9331 .50611 .92891 .49965 Metetra
.677 .735 .894 r
.92891 .49965 .9331 .50611 .94393 .5024 .93976 .4959 Metetra
.677 .734 .894 r
.93976 .4959 .94393 .5024 .95479 .49871 .95066 .49216 Metetra
.676 .733 .894 r
.95066 .49216 .95479 .49871 .9657 .49502 .96159 .48843 Metetra
.633 .726 .915 r
.36555 .7559 .37116 .76132 .38036 .75922 .37478 .7538 Metetra
.631 .726 .916 r
.37478 .7538 .38036 .75922 .3896 .75714 .38403 .75171 Metetra
.63 .726 .916 r
.38403 .75171 .3896 .75714 .39888 .75508 .39332 .74965 Metetra
.629 .726 .917 r
.39332 .74965 .39888 .75508 .40818 .75304 .40265 .74761 Metetra
.627 .726 .918 r
.40265 .74761 .40818 .75304 .41752 .75102 .41201 .74559 Metetra
.626 .727 .919 r
.41201 .74559 .41752 .75102 .4269 .74901 .4214 .74359 Metetra
.625 .727 .92 r
.4214 .74359 .4269 .74901 .43631 .74702 .43083 .74161 Metetra
.623 .727 .921 r
.43083 .74161 .43631 .74702 .44576 .74505 .44029 .73964 Metetra
.622 .728 .922 r
.44029 .73964 .44576 .74505 .45524 .7431 .44979 .73769 Metetra
.621 .728 .923 r
.44979 .73769 .45524 .7431 .46476 .74116 .45933 .73576 Metetra
.62 .729 .925 r
.45933 .73576 .46476 .74116 .47431 .73923 .4689 .73384 Metetra
.618 .729 .926 r
.4689 .73384 .47431 .73923 .4839 .73731 .47851 .73193 Metetra
.617 .73 .927 r
.47851 .73193 .4839 .73731 .49353 .73541 .48816 .73004 Metetra
.616 .731 .928 r
.48816 .73004 .49353 .73541 .5032 .73351 .49785 .72816 Metetra
.615 .731 .929 r
.49785 .72816 .5032 .73351 .5129 .73163 .50757 .72628 Metetra
.614 .732 .93 r
.50757 .72628 .5129 .73163 .52265 .72975 .51733 .72441 Metetra
.613 .733 .931 r
.51733 .72441 .52265 .72975 .53243 .72788 .52714 .72255 Metetra
.612 .734 .932 r
.52714 .72255 .53243 .72788 .54225 .72601 .53698 .7207 Metetra
.612 .735 .933 r
.53698 .7207 .54225 .72601 .55211 .72414 .54686 .71885 Metetra
.611 .736 .934 r
.54686 .71885 .55211 .72414 .56202 .72228 .55678 .717 Metetra
.61 .736 .935 r
.55678 .717 .56202 .72228 .57196 .72042 .56675 .71515 Metetra
.609 .737 .936 r
.56675 .71515 .57196 .72042 .58194 .71856 .57675 .7133 Metetra
.609 .738 .937 r
.57675 .7133 .58194 .71856 .59196 .7167 .5868 .71145 Metetra
.608 .739 .938 r
.5868 .71145 .59196 .7167 .60203 .71484 .59688 .7096 Metetra
.607 .74 .939 r
.59688 .7096 .60203 .71484 .61213 .71297 .60701 .70775 Metetra
.607 .741 .94 r
.60701 .70775 .61213 .71297 .62228 .7111 .61718 .70589 Metetra
.606 .742 .941 r
.61718 .70589 .62228 .7111 .63247 .70923 .6274 .70403 Metetra
.606 .743 .942 r
.6274 .70403 .63247 .70923 .6427 .70735 .63765 .70216 Metetra
.606 .744 .943 r
.63765 .70216 .6427 .70735 .65297 .70547 .64795 .70029 Metetra
.605 .745 .943 r
.64795 .70029 .65297 .70547 .66329 .70358 .65829 .69841 Metetra
.605 .746 .944 r
.65829 .69841 .66329 .70358 .67364 .70168 .66867 .69652 Metetra
.965 .716 .511 r
.66867 .69652 .67364 .70168 .67911 .59044 .6743 .58507 Metetra
.688 .761 .907 r
.6743 .58507 .67911 .59044 .68914 .58672 .68435 .5813 Metetra
.688 .76 .907 r
.68435 .5813 .68914 .58672 .6992 .58298 .69444 .57752 Metetra
.688 .759 .906 r
.69444 .57752 .6992 .58298 .70929 .57924 .70456 .57373 Metetra
.688 .758 .905 r
.70456 .57373 .70929 .57924 .71942 .57549 .71471 .56993 Metetra
.688 .757 .905 r
.71471 .56993 .71942 .57549 .72957 .57172 .72489 .56612 Metetra
.687 .756 .904 r
.72489 .56612 .72957 .57172 .73976 .56795 .7351 .5623 Metetra
.687 .755 .903 r
.7351 .5623 .73976 .56795 .74998 .56417 .74534 .55847 Metetra
.687 .754 .902 r
.74534 .55847 .74998 .56417 .76023 .56039 .75562 .55464 Metetra
.687 .753 .902 r
.75562 .55464 .76023 .56039 .77052 .5566 .76593 .5508 Metetra
.687 .752 .901 r
.76593 .5508 .77052 .5566 .78083 .5528 .77627 .54695 Metetra
.686 .751 .9 r
.77627 .54695 .78083 .5528 .79118 .549 .78665 .5431 Metetra
.686 .75 .9 r
.78665 .5431 .79118 .549 .80157 .54519 .79705 .53924 Metetra
.686 .748 .899 r
.79705 .53924 .80157 .54519 .81199 .54138 .8075 .53539 Metetra
.685 .747 .899 r
.8075 .53539 .81199 .54138 .82244 .53758 .81797 .53153 Metetra
.685 .746 .898 r
.81797 .53153 .82244 .53758 .83292 .53376 .82848 .52767 Metetra
.684 .745 .897 r
.82848 .52767 .83292 .53376 .84344 .52996 .83903 .52381 Metetra
.684 .744 .897 r
.83903 .52381 .84344 .52996 .854 .52615 .84961 .51995 Metetra
.683 .743 .896 r
.84961 .51995 .854 .52615 .86459 .52234 .86022 .5161 Metetra
.682 .741 .896 r
.86022 .5161 .86459 .52234 .87522 .51854 .87087 .51225 Metetra
.682 .74 .895 r
.87087 .51225 .87522 .51854 .88588 .51475 .88156 .5084 Metetra
.681 .739 .895 r
.88156 .5084 .88588 .51475 .89658 .51096 .89229 .50457 Metetra
.68 .738 .894 r
.89229 .50457 .89658 .51096 .90732 .50718 .90305 .50074 Metetra
.68 .737 .894 r
.90305 .50074 .90732 .50718 .9181 .50341 .91385 .49692 Metetra
.679 .736 .894 r
.91385 .49692 .9181 .50341 .92891 .49965 .92469 .49312 Metetra
.678 .735 .893 r
.92469 .49312 .92891 .49965 .93976 .4959 .93557 .48932 Metetra
.677 .734 .893 r
.93557 .48932 .93976 .4959 .95066 .49216 .94649 .48554 Metetra
.676 .733 .893 r
.94649 .48554 .95066 .49216 .96159 .48843 .95745 .48177 Metetra
.632 .725 .914 r
.35992 .75042 .36555 .7559 .37478 .7538 .36916 .74831 Metetra
.631 .725 .915 r
.36916 .74831 .37478 .7538 .38403 .75171 .37843 .74623 Metetra
.629 .725 .916 r
.37843 .74623 .38403 .75171 .39332 .74965 .38774 .74416 Metetra
.628 .725 .917 r
.38774 .74416 .39332 .74965 .40265 .74761 .39708 .74212 Metetra
.627 .725 .918 r
.39708 .74212 .40265 .74761 .41201 .74559 .40645 .74011 Metetra
.625 .725 .919 r
.40645 .74011 .41201 .74559 .4214 .74359 .41586 .73811 Metetra
.624 .726 .92 r
.41586 .73811 .4214 .74359 .43083 .74161 .42531 .73613 Metetra
.622 .726 .921 r
.42531 .73613 .43083 .74161 .44029 .73964 .43479 .73417 Metetra
.621 .727 .922 r
.43479 .73417 .44029 .73964 .44979 .73769 .44431 .73223 Metetra
.62 .727 .923 r
.44431 .73223 .44979 .73769 .45933 .73576 .45386 .73031 Metetra
.618 .728 .924 r
.45386 .73031 .45933 .73576 .4689 .73384 .46346 .7284 Metetra
.617 .728 .925 r
.46346 .7284 .4689 .73384 .47851 .73193 .47308 .7265 Metetra
.616 .729 .927 r
.47308 .7265 .47851 .73193 .48816 .73004 .48275 .72462 Metetra
.615 .73 .928 r
.48275 .72462 .48816 .73004 .49785 .72816 .49246 .72275 Metetra
.614 .73 .929 r
.49246 .72275 .49785 .72816 .50757 .72628 .5022 .72089 Metetra
.613 .731 .93 r
.5022 .72089 .50757 .72628 .51733 .72441 .51199 .71903 Metetra
.612 .732 .931 r
.51199 .71903 .51733 .72441 .52714 .72255 .52181 .71719 Metetra
.611 .733 .932 r
.52181 .71719 .52714 .72255 .53698 .7207 .53167 .71534 Metetra
.61 .734 .933 r
.53167 .71534 .53698 .7207 .54686 .71885 .54158 .7135 Metetra
.609 .735 .934 r
.54158 .7135 .54686 .71885 .55678 .717 .55152 .71167 Metetra
.609 .736 .935 r
.55152 .71167 .55678 .717 .56675 .71515 .5615 .70983 Metetra
.608 .737 .936 r
.5615 .70983 .56675 .71515 .57675 .7133 .57153 .708 Metetra
.607 .738 .937 r
.57153 .708 .57675 .7133 .5868 .71145 .5816 .70616 Metetra
.607 .739 .938 r
.5816 .70616 .5868 .71145 .59688 .7096 .59171 .70432 Metetra
.606 .739 .939 r
.59171 .70432 .59688 .7096 .60701 .70775 .60186 .70248 Metetra
.606 .74 .94 r
.60186 .70248 .60701 .70775 .61718 .70589 .61205 .70064 Metetra
.605 .741 .941 r
.61205 .70064 .61718 .70589 .6274 .70403 .62229 .69879 Metetra
.605 .742 .942 r
.62229 .69879 .6274 .70403 .63765 .70216 .63257 .69693 Metetra
.604 .743 .943 r
.63257 .69693 .63765 .70216 .64795 .70029 .64289 .69507 Metetra
.604 .744 .944 r
.64289 .69507 .64795 .70029 .65829 .69841 .65326 .6932 Metetra
.603 .745 .945 r
.65326 .6932 .65829 .69841 .66867 .69652 .66367 .69133 Metetra
.965 .716 .511 r
.66367 .69133 .66867 .69652 .6743 .58507 .66946 .57966 Metetra
.689 .761 .907 r
.66946 .57966 .6743 .58507 .68435 .5813 .67954 .57585 Metetra
.689 .76 .906 r
.67954 .57585 .68435 .5813 .69444 .57752 .68965 .57202 Metetra
.689 .759 .906 r
.68965 .57202 .69444 .57752 .70456 .57373 .69979 .56818 Metetra
.689 .758 .905 r
.69979 .56818 .70456 .57373 .71471 .56993 .70997 .56433 Metetra
.689 .757 .904 r
.70997 .56433 .71471 .56993 .72489 .56612 .72017 .56047 Metetra
.688 .756 .903 r
.72017 .56047 .72489 .56612 .7351 .5623 .73041 .5566 Metetra
.688 .755 .903 r
.73041 .5566 .7351 .5623 .74534 .55847 .74068 .55273 Metetra
.688 .754 .902 r
.74068 .55273 .74534 .55847 .75562 .55464 .75098 .54884 Metetra
.688 .753 .901 r
.75098 .54884 .75562 .55464 .76593 .5508 .76131 .54495 Metetra
.688 .752 .901 r
.76131 .54495 .76593 .5508 .77627 .54695 .77168 .54106 Metetra
.687 .751 .9 r
.77168 .54106 .77627 .54695 .78665 .5431 .78208 .53715 Metetra
.687 .75 .899 r
.78208 .53715 .78665 .5431 .79705 .53924 .79251 .53325 Metetra
.687 .748 .899 r
.79251 .53325 .79705 .53924 .8075 .53539 .80298 .52934 Metetra
.686 .747 .898 r
.80298 .52934 .8075 .53539 .81797 .53153 .81348 .52543 Metetra
.686 .746 .897 r
.81348 .52543 .81797 .53153 .82848 .52767 .82401 .52152 Metetra
.685 .745 .897 r
.82401 .52152 .82848 .52767 .83903 .52381 .83458 .51761 Metetra
.685 .744 .896 r
.83458 .51761 .83903 .52381 .84961 .51995 .84519 .5137 Metetra
.684 .742 .895 r
.84519 .5137 .84961 .51995 .86022 .5161 .85583 .50979 Metetra
.683 .741 .895 r
.85583 .50979 .86022 .5161 .87087 .51225 .8665 .50589 Metetra
.683 .74 .894 r
.8665 .50589 .87087 .51225 .88156 .5084 .87722 .502 Metetra
.682 .739 .894 r
.87722 .502 .88156 .5084 .89229 .50457 .88797 .49811 Metetra
.681 .738 .893 r
.88797 .49811 .89229 .50457 .90305 .50074 .89875 .49424 Metetra
.68 .736 .893 r
.89875 .49424 .90305 .50074 .91385 .49692 .90958 .49037 Metetra
.679 .735 .893 r
.90958 .49037 .91385 .49692 .92469 .49312 .92044 .48652 Metetra
.679 .734 .892 r
.92044 .48652 .92469 .49312 .93557 .48932 .93135 .48268 Metetra
.678 .733 .892 r
.93135 .48268 .93557 .48932 .94649 .48554 .94229 .47886 Metetra
.677 .732 .892 r
.94229 .47886 .94649 .48554 .95745 .48177 .95328 .47505 Metetra
.632 .723 .913 r
.35425 .74487 .35992 .75042 .36916 .74831 .36351 .74276 Metetra
.63 .723 .914 r
.36351 .74276 .36916 .74831 .37843 .74623 .3728 .74068 Metetra
.629 .724 .915 r
.3728 .74068 .37843 .74623 .38774 .74416 .38212 .73861 Metetra
.627 .724 .916 r
.38212 .73861 .38774 .74416 .39708 .74212 .39148 .73657 Metetra
.626 .724 .917 r
.39148 .73657 .39708 .74212 .40645 .74011 .40087 .73456 Metetra
.624 .724 .918 r
.40087 .73456 .40645 .74011 .41586 .73811 .4103 .73257 Metetra
.623 .724 .919 r
.4103 .73257 .41586 .73811 .42531 .73613 .41976 .73059 Metetra
.621 .725 .921 r
.41976 .73059 .42531 .73613 .43479 .73417 .42926 .72864 Metetra
.62 .725 .922 r
.42926 .72864 .43479 .73417 .44431 .73223 .43879 .72671 Metetra
.619 .726 .923 r
.43879 .72671 .44431 .73223 .45386 .73031 .44837 .7248 Metetra
.617 .726 .924 r
.44837 .7248 .45386 .73031 .46346 .7284 .45798 .7229 Metetra
.616 .727 .925 r
.45798 .7229 .46346 .7284 .47308 .7265 .46762 .72102 Metetra
.615 .728 .926 r
.46762 .72102 .47308 .7265 .48275 .72462 .47731 .71915 Metetra
.614 .729 .928 r
.47731 .71915 .48275 .72462 .49246 .72275 .48704 .71729 Metetra
.613 .729 .929 r
.48704 .71729 .49246 .72275 .5022 .72089 .4968 .71544 Metetra
.612 .73 .93 r
.4968 .71544 .5022 .72089 .51199 .71903 .5066 .7136 Metetra
.611 .731 .931 r
.5066 .7136 .51199 .71903 .52181 .71719 .51645 .71177 Metetra
.61 .732 .932 r
.51645 .71177 .52181 .71719 .53167 .71534 .52633 .70994 Metetra
.609 .733 .933 r
.52633 .70994 .53167 .71534 .54158 .7135 .53626 .70812 Metetra
.608 .734 .934 r
.53626 .70812 .54158 .7135 .55152 .71167 .54622 .7063 Metetra
.607 .735 .935 r
.54622 .7063 .55152 .71167 .5615 .70983 .55623 .70448 Metetra
.607 .736 .936 r
.55623 .70448 .5615 .70983 .57153 .708 .56628 .70265 Metetra
.606 .737 .937 r
.56628 .70265 .57153 .708 .5816 .70616 .57637 .70083 Metetra
.605 .738 .938 r
.57637 .70083 .5816 .70616 .59171 .70432 .5865 .69901 Metetra
.605 .739 .939 r
.5865 .69901 .59171 .70432 .60186 .70248 .59667 .69718 Metetra
.604 .74 .94 r
.59667 .69718 .60186 .70248 .61205 .70064 .60689 .69535 Metetra
.604 .741 .941 r
.60689 .69535 .61205 .70064 .62229 .69879 .61715 .69351 Metetra
.603 .742 .942 r
.61715 .69351 .62229 .69879 .63257 .69693 .62746 .69167 Metetra
.603 .743 .943 r
.62746 .69167 .63257 .69693 .64289 .69507 .63781 .68982 Metetra
.602 .744 .944 r
.63781 .68982 .64289 .69507 .65326 .6932 .6482 .68796 Metetra
.602 .745 .945 r
.6482 .68796 .65326 .6932 .66367 .69133 .65863 .6861 Metetra
.965 .716 .511 r
.65863 .6861 .66367 .69133 .66946 .57966 .66459 .57422 Metetra
.69 .762 .907 r
.66459 .57422 .66946 .57966 .67954 .57585 .67469 .57036 Metetra
.69 .761 .906 r
.67469 .57036 .67954 .57585 .68965 .57202 .68483 .56648 Metetra
.69 .76 .905 r
.68483 .56648 .68965 .57202 .69979 .56818 .695 .56259 Metetra
.69 .759 .904 r
.695 .56259 .69979 .56818 .70997 .56433 .7052 .55869 Metetra
.69 .758 .904 r
.7052 .55869 .70997 .56433 .72017 .56047 .71543 .55478 Metetra
.689 .756 .903 r
.71543 .55478 .72017 .56047 .73041 .5566 .72569 .55087 Metetra
.689 .755 .902 r
.72569 .55087 .73041 .5566 .74068 .55273 .73598 .54694 Metetra
.689 .754 .901 r
.73598 .54694 .74068 .55273 .75098 .54884 .74631 .54301 Metetra
.689 .753 .901 r
.74631 .54301 .75098 .54884 .76131 .54495 .75666 .53906 Metetra
.688 .752 .9 r
.75666 .53906 .76131 .54495 .77168 .54106 .76706 .53511 Metetra
.688 .751 .899 r
.76706 .53511 .77168 .54106 .78208 .53715 .77748 .53116 Metetra
.688 .75 .899 r
.77748 .53116 .78208 .53715 .79251 .53325 .78794 .5272 Metetra
.687 .748 .898 r
.78794 .5272 .79251 .53325 .80298 .52934 .79843 .52324 Metetra
.687 .747 .897 r
.79843 .52324 .80298 .52934 .81348 .52543 .80895 .51928 Metetra
.687 .746 .897 r
.80895 .51928 .81348 .52543 .82401 .52152 .81951 .51531 Metetra
.686 .745 .896 r
.81951 .51531 .82401 .52152 .83458 .51761 .8301 .51135 Metetra
.686 .744 .895 r
.8301 .51135 .83458 .51761 .84519 .5137 .84073 .50739 Metetra
.685 .742 .895 r
.84073 .50739 .84519 .5137 .85583 .50979 .8514 .50343 Metetra
.684 .741 .894 r
.8514 .50343 .85583 .50979 .8665 .50589 .8621 .49948 Metetra
.684 .74 .893 r
.8621 .49948 .8665 .50589 .87722 .502 .87284 .49553 Metetra
.683 .738 .893 r
.87284 .49553 .87722 .502 .88797 .49811 .88361 .4916 Metetra
.682 .737 .893 r
.88361 .4916 .88797 .49811 .89875 .49424 .89443 .48767 Metetra
.681 .736 .892 r
.89443 .48767 .89875 .49424 .90958 .49037 .90528 .48376 Metetra
.68 .735 .892 r
.90528 .48376 .90958 .49037 .92044 .48652 .91617 .47986 Metetra
.679 .733 .891 r
.91617 .47986 .92044 .48652 .93135 .48268 .9271 .47597 Metetra
.678 .732 .891 r
.9271 .47597 .93135 .48268 .94229 .47886 .93807 .4721 Metetra
.677 .731 .891 r
.93807 .4721 .94229 .47886 .95328 .47505 .94908 .46825 Metetra
.631 .722 .913 r
.34855 .73926 .35425 .74487 .36351 .74276 .35782 .73715 Metetra
.63 .722 .914 r
.35782 .73715 .36351 .74276 .3728 .74068 .36713 .73506 Metetra
.628 .722 .915 r
.36713 .73506 .3728 .74068 .38212 .73861 .37647 .733 Metetra
.627 .722 .916 r
.37647 .733 .38212 .73861 .39148 .73657 .38584 .73096 Metetra
.625 .723 .917 r
.38584 .73096 .39148 .73657 .40087 .73456 .39525 .72895 Metetra
.624 .723 .918 r
.39525 .72895 .40087 .73456 .4103 .73257 .4047 .72696 Metetra
.622 .723 .919 r
.4047 .72696 .4103 .73257 .41976 .73059 .41418 .725 Metetra
.62 .723 .92 r
.41418 .725 .41976 .73059 .42926 .72864 .42369 .72305 Metetra
.619 .724 .921 r
.42369 .72305 .42926 .72864 .43879 .72671 .43325 .72113 Metetra
.618 .725 .922 r
.43325 .72113 .43879 .72671 .44837 .7248 .44284 .71923 Metetra
.616 .725 .924 r
.44284 .71923 .44837 .7248 .45798 .7229 .45246 .71734 Metetra
.615 .726 .925 r
.45246 .71734 .45798 .7229 .46762 .72102 .46213 .71548 Metetra
.613 .727 .926 r
.46213 .71548 .46762 .72102 .47731 .71915 .47184 .71362 Metetra
.612 .727 .927 r
.47184 .71362 .47731 .71915 .48704 .71729 .48158 .71178 Metetra
.611 .728 .929 r
.48158 .71178 .48704 .71729 .4968 .71544 .49136 .70995 Metetra
.61 .729 .93 r
.49136 .70995 .4968 .71544 .5066 .7136 .50119 .70812 Metetra
.609 .73 .931 r
.50119 .70812 .5066 .7136 .51645 .71177 .51105 .70631 Metetra
.608 .731 .932 r
.51105 .70631 .51645 .71177 .52633 .70994 .52096 .7045 Metetra
.607 .732 .933 r
.52096 .7045 .52633 .70994 .53626 .70812 .5309 .70269 Metetra
.606 .733 .935 r
.5309 .70269 .53626 .70812 .54622 .7063 .54089 .70088 Metetra
.606 .734 .936 r
.54089 .70088 .54622 .7063 .55623 .70448 .55092 .69908 Metetra
.605 .735 .937 r
.55092 .69908 .55623 .70448 .56628 .70265 .56099 .69727 Metetra
.604 .736 .938 r
.56099 .69727 .56628 .70265 .57637 .70083 .5711 .69546 Metetra
.604 .737 .939 r
.5711 .69546 .57637 .70083 .5865 .69901 .58125 .69365 Metetra
.603 .738 .94 r
.58125 .69365 .5865 .69901 .59667 .69718 .59145 .69184 Metetra
.603 .739 .941 r
.59145 .69184 .59667 .69718 .60689 .69535 .60169 .69002 Metetra
.602 .74 .942 r
.60169 .69002 .60689 .69535 .61715 .69351 .61198 .68819 Metetra
.602 .741 .943 r
.61198 .68819 .61715 .69351 .62746 .69167 .62231 .68636 Metetra
.601 .742 .943 r
.62231 .68636 .62746 .69167 .63781 .68982 .63268 .68453 Metetra
.601 .743 .944 r
.63268 .68453 .63781 .68982 .6482 .68796 .6431 .68268 Metetra
.6 .744 .945 r
.6431 .68268 .6482 .68796 .65863 .6861 .65356 .68083 Metetra
.965 .716 .511 r
.65356 .68083 .65863 .6861 .66459 .57422 .65969 .56874 Metetra
.691 .762 .906 r
.65969 .56874 .66459 .57422 .67469 .57036 .66982 .56483 Metetra
.691 .761 .905 r
.66982 .56483 .67469 .57036 .68483 .56648 .67998 .5609 Metetra
.691 .76 .905 r
.67998 .5609 .68483 .56648 .695 .56259 .69017 .55696 Metetra
.691 .759 .904 r
.69017 .55696 .695 .56259 .7052 .55869 .70039 .55302 Metetra
.69 .758 .903 r
.70039 .55302 .7052 .55869 .71543 .55478 .71065 .54906 Metetra
.69 .757 .902 r
.71065 .54906 .71543 .55478 .72569 .55087 .72093 .54509 Metetra
.69 .756 .902 r
.72093 .54509 .72569 .55087 .73598 .54694 .73125 .54111 Metetra
.69 .754 .901 r
.73125 .54111 .73598 .54694 .74631 .54301 .7416 .53712 Metetra
.69 .753 .9 r
.7416 .53712 .74631 .54301 .75666 .53906 .75199 .53313 Metetra
.69 .752 .899 r
.75199 .53313 .75666 .53906 .76706 .53511 .7624 .52913 Metetra
.689 .751 .899 r
.7624 .52913 .76706 .53511 .77748 .53116 .77285 .52512 Metetra
.689 .75 .898 r
.77285 .52512 .77748 .53116 .78794 .5272 .78333 .52111 Metetra
.689 .749 .897 r
.78333 .52111 .78794 .5272 .79843 .52324 .79385 .51709 Metetra
.688 .747 .896 r
.79385 .51709 .79843 .52324 .80895 .51928 .8044 .51307 Metetra
.688 .746 .896 r
.8044 .51307 .80895 .51928 .81951 .51531 .81498 .50905 Metetra
.687 .745 .895 r
.81498 .50905 .81951 .51531 .8301 .51135 .8256 .50503 Metetra
.687 .743 .894 r
.8256 .50503 .8301 .51135 .84073 .50739 .83625 .50102 Metetra
.686 .742 .894 r
.83625 .50102 .84073 .50739 .8514 .50343 .84694 .49701 Metetra
.685 .741 .893 r
.84694 .49701 .8514 .50343 .8621 .49948 .85767 .493 Metetra
.684 .739 .893 r
.85767 .493 .8621 .49948 .87284 .49553 .86843 .489 Metetra
.684 .738 .892 r
.86843 .489 .87284 .49553 .88361 .4916 .87923 .48501 Metetra
.683 .737 .892 r
.87923 .48501 .88361 .4916 .89443 .48767 .89007 .48103 Metetra
.682 .735 .891 r
.89007 .48103 .89443 .48767 .90528 .48376 .90094 .47707 Metetra
.681 .734 .891 r
.90094 .47707 .90528 .48376 .91617 .47986 .91186 .47312 Metetra
.68 .733 .89 r
.91186 .47312 .91617 .47986 .9271 .47597 .92281 .46919 Metetra
.679 .732 .89 r
.92281 .46919 .9271 .47597 .93807 .4721 .93381 .46527 Metetra
.678 .73 .89 r
.93381 .46527 .93807 .4721 .94908 .46825 .94484 .46137 Metetra
.631 .721 .912 r
.34282 .73358 .34855 .73926 .35782 .73715 .35211 .73147 Metetra
.629 .721 .913 r
.35211 .73147 .35782 .73715 .36713 .73506 .36143 .72938 Metetra
.628 .721 .914 r
.36143 .72938 .36713 .73506 .37647 .733 .37079 .72731 Metetra
.626 .721 .915 r
.37079 .72731 .37647 .733 .38584 .73096 .38018 .72528 Metetra
.624 .721 .916 r
.38018 .72528 .38584 .73096 .39525 .72895 .3896 .72327 Metetra
.623 .721 .917 r
.3896 .72327 .39525 .72895 .4047 .72696 .39906 .72129 Metetra
.621 .722 .918 r
.39906 .72129 .4047 .72696 .41418 .725 .40856 .71933 Metetra
.619 .722 .92 r
.40856 .71933 .41418 .725 .42369 .72305 .41809 .7174 Metetra
.618 .723 .921 r
.41809 .7174 .42369 .72305 .43325 .72113 .42767 .71549 Metetra
.616 .723 .922 r
.42767 .71549 .43325 .72113 .44284 .71923 .43727 .7136 Metetra
.615 .724 .923 r
.43727 .7136 .44284 .71923 .45246 .71734 .44692 .71173 Metetra
.613 .724 .925 r
.44692 .71173 .45246 .71734 .46213 .71548 .4566 .70988 Metetra
.612 .725 .926 r
.4566 .70988 .46213 .71548 .47184 .71362 .46633 .70804 Metetra
.611 .726 .927 r
.46633 .70804 .47184 .71362 .48158 .71178 .47609 .70622 Metetra
.61 .727 .929 r
.47609 .70622 .48158 .71178 .49136 .70995 .48589 .7044 Metetra
.609 .728 .93 r
.48589 .7044 .49136 .70995 .50119 .70812 .49574 .7026 Metetra
.608 .729 .931 r
.49574 .7026 .50119 .70812 .51105 .70631 .50562 .7008 Metetra
.607 .73 .932 r
.50562 .7008 .51105 .70631 .52096 .7045 .51554 .699 Metetra
.606 .731 .934 r
.51554 .699 .52096 .7045 .5309 .70269 .52551 .69721 Metetra
.605 .732 .935 r
.52551 .69721 .5309 .70269 .54089 .70088 .53552 .69542 Metetra
.604 .733 .936 r
.53552 .69542 .54089 .70088 .55092 .69908 .54557 .69363 Metetra
.603 .734 .937 r
.54557 .69363 .55092 .69908 .56099 .69727 .55566 .69184 Metetra
.603 .735 .938 r
.55566 .69184 .56099 .69727 .5711 .69546 .5658 .69005 Metetra
.602 .736 .939 r
.5658 .69005 .5711 .69546 .58125 .69365 .57598 .68826 Metetra
.602 .737 .94 r
.57598 .68826 .58125 .69365 .59145 .69184 .5862 .68646 Metetra
.601 .738 .941 r
.5862 .68646 .59145 .69184 .60169 .69002 .59646 .68465 Metetra
.601 .74 .942 r
.59646 .68465 .60169 .69002 .61198 .68819 .60677 .68284 Metetra
.6 .741 .943 r
.60677 .68284 .61198 .68819 .62231 .68636 .61713 .68102 Metetra
.6 .742 .944 r
.61713 .68102 .62231 .68636 .63268 .68453 .62752 .6792 Metetra
.599 .743 .945 r
.62752 .6792 .63268 .68453 .6431 .68268 .63797 .67737 Metetra
.599 .744 .946 r
.63797 .67737 .6431 .68268 .65356 .68083 .64845 .67553 Metetra
.965 .716 .511 r
.64845 .67553 .65356 .68083 .65969 .56874 .65475 .56323 Metetra
.692 .762 .906 r
.65475 .56323 .65969 .56874 .66982 .56483 .66491 .55926 Metetra
.692 .761 .905 r
.66491 .55926 .66982 .56483 .67998 .5609 .67509 .55529 Metetra
.692 .76 .904 r
.67509 .55529 .67998 .5609 .69017 .55696 .68531 .5513 Metetra
.692 .759 .903 r
.68531 .5513 .69017 .55696 .70039 .55302 .69556 .5473 Metetra
.691 .758 .903 r
.69556 .5473 .70039 .55302 .71065 .54906 .70584 .54329 Metetra
.691 .757 .902 r
.70584 .54329 .71065 .54906 .72093 .54509 .71615 .53927 Metetra
.691 .756 .901 r
.71615 .53927 .72093 .54509 .73125 .54111 .72649 .53524 Metetra
.691 .755 .9 r
.72649 .53524 .73125 .54111 .7416 .53712 .73687 .5312 Metetra
.691 .753 .9 r
.73687 .5312 .7416 .53712 .75199 .53313 .74728 .52715 Metetra
.691 .752 .899 r
.74728 .52715 .75199 .53313 .7624 .52913 .75772 .5231 Metetra
.69 .751 .898 r
.75772 .5231 .7624 .52913 .77285 .52512 .76819 .51903 Metetra
.69 .75 .897 r
.76819 .51903 .77285 .52512 .78333 .52111 .7787 .51497 Metetra
.69 .749 .897 r
.7787 .51497 .78333 .52111 .79385 .51709 .78924 .51089 Metetra
.689 .747 .896 r
.78924 .51089 .79385 .51709 .8044 .51307 .79981 .50682 Metetra
.689 .746 .895 r
.79981 .50682 .8044 .51307 .81498 .50905 .81042 .50274 Metetra
.688 .745 .894 r
.81042 .50274 .81498 .50905 .8256 .50503 .82106 .49866 Metetra
.688 .743 .894 r
.82106 .49866 .8256 .50503 .83625 .50102 .83174 .49459 Metetra
.687 .742 .893 r
.83174 .49459 .83625 .50102 .84694 .49701 .84245 .49052 Metetra
.686 .74 .892 r
.84245 .49052 .84694 .49701 .85767 .493 .8532 .48646 Metetra
.685 .739 .892 r
.8532 .48646 .85767 .493 .86843 .489 .86399 .4824 Metetra
.685 .738 .891 r
.86399 .4824 .86843 .489 .87923 .48501 .87481 .47836 Metetra
.684 .736 .891 r
.87481 .47836 .87923 .48501 .89007 .48103 .88568 .47433 Metetra
.683 .735 .89 r
.88568 .47433 .89007 .48103 .90094 .47707 .89658 .47031 Metetra
.682 .733 .89 r
.89658 .47031 .90094 .47707 .91186 .47312 .90752 .46631 Metetra
.681 .732 .889 r
.90752 .46631 .91186 .47312 .92281 .46919 .9185 .46233 Metetra
.68 .731 .889 r
.9185 .46233 .92281 .46919 .93381 .46527 .92952 .45837 Metetra
.678 .73 .889 r
.92952 .45837 .93381 .46527 .94484 .46137 .94058 .45442 Metetra
.631 .719 .911 r
.33706 .72784 .34282 .73358 .35211 .73147 .34636 .72572 Metetra
.629 .719 .912 r
.34636 .72572 .35211 .73147 .36143 .72938 .3557 .72362 Metetra
.627 .719 .913 r
.3557 .72362 .36143 .72938 .37079 .72731 .36507 .72156 Metetra
.625 .719 .914 r
.36507 .72156 .37079 .72731 .38018 .72528 .37448 .71953 Metetra
.624 .72 .915 r
.37448 .71953 .38018 .72528 .3896 .72327 .38392 .71753 Metetra
.622 .72 .917 r
.38392 .71753 .3896 .72327 .39906 .72129 .3934 .71555 Metetra
.62 .72 .918 r
.3934 .71555 .39906 .72129 .40856 .71933 .40291 .7136 Metetra
.618 .721 .919 r
.40291 .7136 .40856 .71933 .41809 .7174 .41246 .71168 Metetra
.617 .721 .92 r
.41246 .71168 .41809 .7174 .42767 .71549 .42205 .70979 Metetra
.615 .722 .922 r
.42205 .70979 .42767 .71549 .43727 .7136 .43168 .70791 Metetra
.613 .722 .923 r
.43168 .70791 .43727 .7136 .44692 .71173 .44134 .70606 Metetra
.612 .723 .924 r
.44134 .70606 .44692 .71173 .4566 .70988 .45104 .70422 Metetra
.611 .724 .926 r
.45104 .70422 .4566 .70988 .46633 .70804 .46078 .70241 Metetra
.609 .725 .927 r
.46078 .70241 .46633 .70804 .47609 .70622 .47057 .7006 Metetra
.608 .726 .929 r
.47057 .7006 .47609 .70622 .48589 .7044 .48039 .69881 Metetra
.607 .727 .93 r
.48039 .69881 .48589 .7044 .49574 .7026 .49025 .69702 Metetra
.606 .728 .931 r
.49025 .69702 .49574 .7026 .50562 .7008 .50015 .69524 Metetra
.605 .729 .932 r
.50015 .69524 .50562 .7008 .51554 .699 .5101 .69347 Metetra
.604 .73 .934 r
.5101 .69347 .51554 .699 .52551 .69721 .52009 .69169 Metetra
.603 .731 .935 r
.52009 .69169 .52551 .69721 .53552 .69542 .53012 .68992 Metetra
.603 .732 .936 r
.53012 .68992 .53552 .69542 .54557 .69363 .54019 .68815 Metetra
.602 .733 .937 r
.54019 .68815 .54557 .69363 .55566 .69184 .5503 .68638 Metetra
.601 .734 .938 r
.5503 .68638 .55566 .69184 .5658 .69005 .56046 .6846 Metetra
.601 .736 .939 r
.56046 .6846 .5658 .69005 .57598 .68826 .57066 .68282 Metetra
.6 .737 .94 r
.57066 .68282 .57598 .68826 .5862 .68646 .58091 .68104 Metetra
.6 .738 .941 r
.58091 .68104 .5862 .68646 .59646 .68465 .5912 .67925 Metetra
.599 .739 .942 r
.5912 .67925 .59646 .68465 .60677 .68284 .60153 .67745 Metetra
.599 .74 .943 r
.60153 .67745 .60677 .68284 .61713 .68102 .61191 .67564 Metetra
.598 .741 .944 r
.61191 .67564 .61713 .68102 .62752 .6792 .62233 .67383 Metetra
.598 .742 .945 r
.62233 .67383 .62752 .6792 .63797 .67737 .6328 .67202 Metetra
.597 .743 .946 r
.6328 .67202 .63797 .67737 .64845 .67553 .64331 .67019 Metetra
.965 .716 .511 r
.64331 .67019 .64845 .67553 .65475 .56323 .64978 .55768 Metetra
.693 .763 .905 r
.64978 .55768 .65475 .56323 .66491 .55926 .65996 .55366 Metetra
.693 .762 .904 r
.65996 .55366 .66491 .55926 .67509 .55529 .67017 .54963 Metetra
.693 .76 .904 r
.67017 .54963 .67509 .55529 .68531 .5513 .68042 .5456 Metetra
.693 .759 .903 r
.68042 .5456 .68531 .5513 .69556 .5473 .69069 .54154 Metetra
.692 .758 .902 r
.69069 .54154 .69556 .5473 .70584 .54329 .70099 .53748 Metetra
.692 .757 .901 r
.70099 .53748 .70584 .54329 .71615 .53927 .71133 .53341 Metetra
.692 .756 .901 r
.71133 .53341 .71615 .53927 .72649 .53524 .7217 .52933 Metetra
.692 .755 .9 r
.7217 .52933 .72649 .53524 .73687 .5312 .7321 .52523 Metetra
.692 .754 .899 r
.7321 .52523 .73687 .5312 .74728 .52715 .74253 .52113 Metetra
.692 .752 .898 r
.74253 .52113 .74728 .52715 .75772 .5231 .753 .51702 Metetra
.691 .751 .897 r
.753 .51702 .75772 .5231 .76819 .51903 .7635 .5129 Metetra
.691 .75 .897 r
.7635 .5129 .76819 .51903 .7787 .51497 .77403 .50877 Metetra
.691 .749 .896 r
.77403 .50877 .7787 .51497 .78924 .51089 .78459 .50464 Metetra
.69 .747 .895 r
.78459 .50464 .78924 .51089 .79981 .50682 .79519 .50051 Metetra
.69 .746 .894 r
.79519 .50051 .79981 .50682 .81042 .50274 .80582 .49637 Metetra
.689 .745 .894 r
.80582 .49637 .81042 .50274 .82106 .49866 .81649 .49224 Metetra
.689 .743 .893 r
.81649 .49224 .82106 .49866 .83174 .49459 .82719 .4881 Metetra
.688 .742 .892 r
.82719 .4881 .83174 .49459 .84245 .49052 .83793 .48398 Metetra
.687 .74 .891 r
.83793 .48398 .84245 .49052 .8532 .48646 .84871 .47985 Metetra
.686 .739 .891 r
.84871 .47985 .8532 .48646 .86399 .4824 .85952 .47574 Metetra
.686 .737 .89 r
.85952 .47574 .86399 .4824 .87481 .47836 .87037 .47164 Metetra
.685 .736 .89 r
.87037 .47164 .87481 .47836 .88568 .47433 .88125 .46755 Metetra
.684 .734 .889 r
.88125 .46755 .88568 .47433 .89658 .47031 .89218 .46348 Metetra
.683 .733 .889 r
.89218 .46348 .89658 .47031 .90752 .46631 .90314 .45943 Metetra
.681 .731 .888 r
.90314 .45943 .90752 .46631 .9185 .46233 .91415 .45539 Metetra
.68 .73 .888 r
.91415 .45539 .9185 .46233 .92952 .45837 .9252 .45138 Metetra
.679 .729 .888 r
.9252 .45138 .92952 .45837 .94058 .45442 .93628 .44739 Metetra
.63 .718 .91 r
.33126 .72202 .33706 .72784 .34636 .72572 .34058 .71989 Metetra
.628 .718 .911 r
.34058 .71989 .34636 .72572 .3557 .72362 .34993 .7178 Metetra
.626 .718 .912 r
.34993 .7178 .3557 .72362 .36507 .72156 .35932 .71574 Metetra
.625 .718 .913 r
.35932 .71574 .36507 .72156 .37448 .71953 .36875 .71371 Metetra
.623 .718 .915 r
.36875 .71371 .37448 .71953 .38392 .71753 .3782 .71171 Metetra
.621 .718 .916 r
.3782 .71171 .38392 .71753 .3934 .71555 .3877 .70974 Metetra
.619 .719 .917 r
.3877 .70974 .3934 .71555 .40291 .7136 .39723 .70781 Metetra
.617 .719 .918 r
.39723 .70781 .40291 .7136 .41246 .71168 .4068 .7059 Metetra
.615 .719 .92 r
.4068 .7059 .41246 .71168 .42205 .70979 .4164 .70402 Metetra
.614 .72 .921 r
.4164 .70402 .42205 .70979 .43168 .70791 .42604 .70216 Metetra
.612 .721 .923 r
.42604 .70216 .43168 .70791 .44134 .70606 .43573 .70033 Metetra
.61 .722 .924 r
.43573 .70033 .44134 .70606 .45104 .70422 .44545 .69851 Metetra
.609 .722 .926 r
.44545 .69851 .45104 .70422 .46078 .70241 .45521 .69671 Metetra
.608 .723 .927 r
.45521 .69671 .46078 .70241 .47057 .7006 .46501 .69493 Metetra
.606 .724 .929 r
.46501 .69493 .47057 .7006 .48039 .69881 .47485 .69316 Metetra
.605 .726 .93 r
.47485 .69316 .48039 .69881 .49025 .69702 .48473 .69139 Metetra
.604 .727 .931 r
.48473 .69139 .49025 .69702 .50015 .69524 .49465 .68963 Metetra
.603 .728 .933 r
.49465 .68963 .50015 .69524 .5101 .69347 .50462 .68788 Metetra
.602 .729 .934 r
.50462 .68788 .5101 .69347 .52009 .69169 .51463 .68613 Metetra
.601 .73 .935 r
.51463 .68613 .52009 .69169 .53012 .68992 .52468 .68438 Metetra
.601 .731 .936 r
.52468 .68438 .53012 .68992 .54019 .68815 .53477 .68263 Metetra
.6 .733 .937 r
.53477 .68263 .54019 .68815 .5503 .68638 .54491 .68087 Metetra
.6 .734 .939 r
.54491 .68087 .5503 .68638 .56046 .6846 .55509 .67911 Metetra
.599 .735 .94 r
.55509 .67911 .56046 .6846 .57066 .68282 .56531 .67735 Metetra
.598 .736 .941 r
.56531 .67735 .57066 .68282 .58091 .68104 .57558 .67558 Metetra
.598 .737 .942 r
.57558 .67558 .58091 .68104 .5912 .67925 .58589 .6738 Metetra
.598 .738 .943 r
.58589 .6738 .5912 .67925 .60153 .67745 .59625 .67202 Metetra
.597 .739 .944 r
.59625 .67202 .60153 .67745 .61191 .67564 .60665 .67023 Metetra
.597 .74 .944 r
.60665 .67023 .61191 .67564 .62233 .67383 .6171 .66843 Metetra
.596 .741 .945 r
.6171 .66843 .62233 .67383 .6328 .67202 .62759 .66663 Metetra
.596 .743 .946 r
.62759 .66663 .6328 .67202 .64331 .67019 .63813 .66482 Metetra
.965 .716 .511 r
.63813 .66482 .64331 .67019 .64978 .55768 .64478 .55209 Metetra
.694 .763 .905 r
.64478 .55209 .64978 .55768 .65996 .55366 .65499 .54802 Metetra
.694 .762 .904 r
.65499 .54802 .65996 .55366 .67017 .54963 .66522 .54394 Metetra
.694 .761 .903 r
.66522 .54394 .67017 .54963 .68042 .5456 .67549 .53985 Metetra
.694 .76 .903 r
.67549 .53985 .68042 .5456 .69069 .54154 .68579 .53575 Metetra
.693 .759 .902 r
.68579 .53575 .69069 .54154 .70099 .53748 .69612 .53163 Metetra
.693 .757 .901 r
.69612 .53163 .70099 .53748 .71133 .53341 .70648 .52751 Metetra
.693 .756 .9 r
.70648 .52751 .71133 .53341 .7217 .52933 .71688 .52337 Metetra
.693 .755 .899 r
.71688 .52337 .7217 .52933 .7321 .52523 .7273 .51922 Metetra
.693 .754 .899 r
.7273 .51922 .7321 .52523 .74253 .52113 .73776 .51506 Metetra
.693 .753 .898 r
.73776 .51506 .74253 .52113 .753 .51702 .74825 .51089 Metetra
.692 .751 .897 r
.74825 .51089 .753 .51702 .7635 .5129 .75877 .50672 Metetra
.692 .75 .896 r
.75877 .50672 .7635 .5129 .77403 .50877 .76933 .50253 Metetra
.692 .749 .895 r
.76933 .50253 .77403 .50877 .78459 .50464 .77992 .49834 Metetra
.691 .747 .894 r
.77992 .49834 .78459 .50464 .79519 .50051 .79054 .49415 Metetra
.691 .746 .894 r
.79054 .49415 .79519 .50051 .80582 .49637 .8012 .48995 Metetra
.69 .745 .893 r
.8012 .48995 .80582 .49637 .81649 .49224 .81189 .48575 Metetra
.69 .743 .892 r
.81189 .48575 .81649 .49224 .82719 .4881 .82262 .48156 Metetra
.689 .741 .891 r
.82262 .48156 .82719 .4881 .83793 .48398 .83338 .47737 Metetra
.688 .74 .89 r
.83338 .47737 .83793 .48398 .84871 .47985 .84418 .47318 Metetra
.688 .738 .89 r
.84418 .47318 .84871 .47985 .85952 .47574 .85502 .46901 Metetra
.687 .737 .889 r
.85502 .46901 .85952 .47574 .87037 .47164 .86589 .46485 Metetra
.686 .735 .888 r
.86589 .46485 .87037 .47164 .88125 .46755 .8768 .4607 Metetra
.684 .734 .888 r
.8768 .4607 .88125 .46755 .89218 .46348 .88775 .45658 Metetra
.683 .732 .887 r
.88775 .45658 .89218 .46348 .90314 .45943 .89874 .45247 Metetra
.682 .731 .887 r
.89874 .45247 .90314 .45943 .91415 .45539 .90977 .44838 Metetra
.681 .729 .887 r
.90977 .44838 .91415 .45539 .9252 .45138 .92084 .44432 Metetra
.68 .728 .886 r
.92084 .44432 .9252 .45138 .93628 .44739 .93196 .44028 Metetra
.63 .716 .909 r
.32543 .71613 .33126 .72202 .34058 .71989 .33477 .714 Metetra
.628 .716 .91 r
.33477 .714 .34058 .71989 .34993 .7178 .34414 .7119 Metetra
.626 .716 .911 r
.34414 .7119 .34993 .7178 .35932 .71574 .35354 .70984 Metetra
.624 .716 .913 r
.35354 .70984 .35932 .71574 .36875 .71371 .36298 .70781 Metetra
.622 .716 .914 r
.36298 .70781 .36875 .71371 .3782 .71171 .37246 .70582 Metetra
.62 .716 .915 r
.37246 .70582 .3782 .71171 .3877 .70974 .38197 .70386 Metetra
.618 .717 .916 r
.38197 .70386 .3877 .70974 .39723 .70781 .39151 .70194 Metetra
.616 .717 .918 r
.39151 .70194 .39723 .70781 .4068 .7059 .4011 .70004 Metetra
.614 .718 .919 r
.4011 .70004 .4068 .7059 .4164 .70402 .41072 .69818 Metetra
.612 .718 .921 r
.41072 .69818 .4164 .70402 .42604 .70216 .42038 .69634 Metetra
.61 .719 .922 r
.42038 .69634 .42604 .70216 .43573 .70033 .43008 .69453 Metetra
.609 .72 .924 r
.43008 .69453 .43573 .70033 .44545 .69851 .43982 .69274 Metetra
.607 .721 .926 r
.43982 .69274 .44545 .69851 .45521 .69671 .44959 .69096 Metetra
.606 .722 .927 r
.44959 .69096 .45521 .69671 .46501 .69493 .45941 .6892 Metetra
.604 .723 .929 r
.45941 .6892 .46501 .69493 .47485 .69316 .46927 .68745 Metetra
.603 .724 .93 r
.46927 .68745 .47485 .69316 .48473 .69139 .47917 .68572 Metetra
.602 .725 .931 r
.47917 .68572 .48473 .69139 .49465 .68963 .48912 .68398 Metetra
.601 .727 .933 r
.48912 .68398 .49465 .68963 .50462 .68788 .4991 .68225 Metetra
.6 .728 .934 r
.4991 .68225 .50462 .68788 .51463 .68613 .50913 .68052 Metetra
.6 .729 .935 r
.50913 .68052 .51463 .68613 .52468 .68438 .5192 .67879 Metetra
.599 .73 .937 r
.5192 .67879 .52468 .68438 .53477 .68263 .52932 .67706 Metetra
.598 .732 .938 r
.52932 .67706 .53477 .68263 .54491 .68087 .53948 .67532 Metetra
.598 .733 .939 r
.53948 .67532 .54491 .68087 .55509 .67911 .54968 .67358 Metetra
.597 .734 .94 r
.54968 .67358 .55509 .67911 .56531 .67735 .55993 .67183 Metetra
.597 .735 .941 r
.55993 .67183 .56531 .67735 .57558 .67558 .57022 .67008 Metetra
.596 .736 .942 r
.57022 .67008 .57558 .67558 .58589 .6738 .58055 .66832 Metetra
.596 .738 .943 r
.58055 .66832 .58589 .6738 .59625 .67202 .59094 .66655 Metetra
.596 .739 .944 r
.59094 .66655 .59625 .67202 .60665 .67023 .60136 .66478 Metetra
.595 .74 .945 r
.60136 .66478 .60665 .67023 .6171 .66843 .61184 .66299 Metetra
.595 .741 .946 r
.61184 .66299 .6171 .66843 .62759 .66663 .62236 .6612 Metetra
.594 .742 .947 r
.62236 .6612 .62759 .66663 .63813 .66482 .63292 .6594 Metetra
.965 .716 .511 r
.63292 .6594 .63813 .66482 .64478 .55209 .63974 .54646 Metetra
.695 .763 .904 r
.63974 .54646 .64478 .55209 .65499 .54802 .64998 .54234 Metetra
.695 .762 .904 r
.64998 .54234 .65499 .54802 .66522 .54394 .66024 .53821 Metetra
.695 .761 .903 r
.66024 .53821 .66522 .54394 .67549 .53985 .67053 .53407 Metetra
.695 .76 .902 r
.67053 .53407 .67549 .53985 .68579 .53575 .68086 .52992 Metetra
.694 .759 .901 r
.68086 .52992 .68579 .53575 .69612 .53163 .69121 .52575 Metetra
.694 .758 .9 r
.69121 .52575 .69612 .53163 .70648 .52751 .7016 .52157 Metetra
.694 .757 .9 r
.7016 .52157 .70648 .52751 .71688 .52337 .71202 .51737 Metetra
.694 .755 .899 r
.71202 .51737 .71688 .52337 .7273 .51922 .72247 .51317 Metetra
.694 .754 .898 r
.72247 .51317 .7273 .51922 .73776 .51506 .73295 .50895 Metetra
.694 .753 .897 r
.73295 .50895 .73776 .51506 .74825 .51089 .74347 .50472 Metetra
.694 .752 .896 r
.74347 .50472 .74825 .51089 .75877 .50672 .75402 .50049 Metetra
.693 .75 .895 r
.75402 .50049 .75877 .50672 .76933 .50253 .7646 .49624 Metetra
.693 .749 .895 r
.7646 .49624 .76933 .50253 .77992 .49834 .77521 .49199 Metetra
.693 .748 .894 r
.77521 .49199 .77992 .49834 .79054 .49415 .78586 .48773 Metetra
.692 .746 .893 r
.78586 .48773 .79054 .49415 .8012 .48995 .79654 .48347 Metetra
.692 .745 .892 r
.79654 .48347 .8012 .48995 .81189 .48575 .80726 .47921 Metetra
.691 .743 .891 r
.80726 .47921 .81189 .48575 .82262 .48156 .81801 .47495 Metetra
.69 .741 .89 r
.81801 .47495 .82262 .48156 .83338 .47737 .8288 .4707 Metetra
.69 .74 .889 r
.8288 .4707 .83338 .47737 .84418 .47318 .83962 .46645 Metetra
.689 .738 .889 r
.83962 .46645 .84418 .47318 .85502 .46901 .85048 .46221 Metetra
.688 .736 .888 r
.85048 .46221 .85502 .46901 .86589 .46485 .86138 .45799 Metetra
.687 .735 .887 r
.86138 .45799 .86589 .46485 .8768 .4607 .87231 .45378 Metetra
.685 .733 .887 r
.87231 .45378 .8768 .4607 .88775 .45658 .88329 .44959 Metetra
.684 .731 .886 r
.88329 .44959 .88775 .45658 .89874 .45247 .8943 .44542 Metetra
.683 .73 .886 r
.8943 .44542 .89874 .45247 .90977 .44838 .90536 .44128 Metetra
.682 .728 .886 r
.90536 .44128 .90977 .44838 .92084 .44432 .91645 .43717 Metetra
.68 .727 .885 r
.91645 .43717 .92084 .44432 .93196 .44028 .92759 .43308 Metetra
.629 .715 .908 r
.31957 .71016 .32543 .71613 .33477 .714 .32892 .70802 Metetra
.627 .715 .909 r
.32892 .70802 .33477 .714 .34414 .7119 .33831 .70592 Metetra
.625 .715 .91 r
.33831 .70592 .34414 .7119 .35354 .70984 .34773 .70386 Metetra
.623 .714 .912 r
.34773 .70386 .35354 .70984 .36298 .70781 .35718 .70184 Metetra
.621 .715 .913 r
.35718 .70184 .36298 .70781 .37246 .70582 .36667 .69985 Metetra
.619 .715 .914 r
.36667 .69985 .37246 .70582 .38197 .70386 .3762 .6979 Metetra
.617 .715 .916 r
.3762 .6979 .38197 .70386 .39151 .70194 .38576 .69599 Metetra
.615 .715 .917 r
.38576 .69599 .39151 .70194 .4011 .70004 .39536 .69412 Metetra
.612 .716 .919 r
.39536 .69412 .4011 .70004 .41072 .69818 .405 .69227 Metetra
.61 .717 .92 r
.405 .69227 .41072 .69818 .42038 .69634 .41468 .69046 Metetra
.609 .717 .922 r
.41468 .69046 .42038 .69634 .43008 .69453 .42439 .68867 Metetra
.607 .718 .924 r
.42439 .68867 .43008 .69453 .43982 .69274 .43415 .6869 Metetra
.605 .719 .925 r
.43415 .6869 .43982 .69274 .44959 .69096 .44395 .68515 Metetra
.604 .721 .927 r
.44395 .68515 .44959 .69096 .45941 .6892 .45378 .68342 Metetra
.602 .722 .929 r
.45378 .68342 .45941 .6892 .46927 .68745 .46366 .6817 Metetra
.601 .723 .93 r
.46366 .6817 .46927 .68745 .47917 .68572 .47358 .67999 Metetra
.6 .724 .932 r
.47358 .67999 .47917 .68572 .48912 .68398 .48355 .67828 Metetra
.599 .726 .933 r
.48355 .67828 .48912 .68398 .4991 .68225 .49355 .67658 Metetra
.598 .727 .934 r
.49355 .67658 .4991 .68225 .50913 .68052 .5036 .67487 Metetra
.598 .728 .936 r
.5036 .67487 .50913 .68052 .5192 .67879 .51369 .67316 Metetra
.597 .73 .937 r
.51369 .67316 .5192 .67879 .52932 .67706 .52383 .67145 Metetra
.597 .731 .938 r
.52383 .67145 .52932 .67706 .53948 .67532 .53401 .66974 Metetra
.596 .732 .939 r
.53401 .66974 .53948 .67532 .54968 .67358 .54423 .66801 Metetra
.596 .733 .94 r
.54423 .66801 .54968 .67358 .55993 .67183 .5545 .66628 Metetra
.595 .735 .941 r
.5545 .66628 .55993 .67183 .57022 .67008 .56482 .66455 Metetra
.595 .736 .942 r
.56482 .66455 .57022 .67008 .58055 .66832 .57518 .6628 Metetra
.594 .737 .943 r
.57518 .6628 .58055 .66832 .59094 .66655 .58558 .66105 Metetra
.594 .738 .944 r
.58558 .66105 .59094 .66655 .60136 .66478 .59604 .65929 Metetra
.594 .739 .945 r
.59604 .65929 .60136 .66478 .61184 .66299 .60653 .65752 Metetra
.593 .74 .946 r
.60653 .65752 .61184 .66299 .62236 .6612 .61708 .65574 Metetra
.593 .741 .947 r
.61708 .65574 .62236 .6612 .63292 .6594 .62767 .65395 Metetra
.965 .716 .511 r
.62767 .65395 .63292 .6594 .63974 .54646 .63467 .5408 Metetra
.696 .763 .904 r
.63467 .5408 .63974 .54646 .64998 .54234 .64493 .53663 Metetra
.696 .762 .903 r
.64493 .53663 .64998 .54234 .66024 .53821 .65522 .53245 Metetra
.696 .761 .902 r
.65522 .53245 .66024 .53821 .67053 .53407 .66554 .52825 Metetra
.696 .76 .902 r
.66554 .52825 .67053 .53407 .68086 .52992 .67589 .52404 Metetra
.696 .759 .901 r
.67589 .52404 .68086 .52992 .69121 .52575 .68627 .51982 Metetra
.695 .758 .9 r
.68627 .51982 .69121 .52575 .7016 .52157 .69668 .51558 Metetra
.695 .757 .899 r
.69668 .51558 .7016 .52157 .71202 .51737 .70713 .51133 Metetra
.695 .756 .898 r
.70713 .51133 .71202 .51737 .72247 .51317 .71761 .50707 Metetra
.695 .755 .897 r
.71761 .50707 .72247 .51317 .73295 .50895 .72812 .5028 Metetra
.695 .753 .897 r
.72812 .5028 .73295 .50895 .74347 .50472 .73866 .49851 Metetra
.695 .752 .896 r
.73866 .49851 .74347 .50472 .75402 .50049 .74923 .49421 Metetra
.695 .751 .895 r
.74923 .49421 .75402 .50049 .7646 .49624 .75984 .48991 Metetra
.694 .749 .894 r
.75984 .48991 .7646 .49624 .77521 .49199 .77048 .48559 Metetra
.694 .748 .893 r
.77048 .48559 .77521 .49199 .78586 .48773 .78115 .48127 Metetra
.693 .746 .892 r
.78115 .48127 .78586 .48773 .79654 .48347 .79186 .47694 Metetra
.693 .745 .891 r
.79186 .47694 .79654 .48347 .80726 .47921 .8026 .47261 Metetra
.692 .743 .89 r
.8026 .47261 .80726 .47921 .81801 .47495 .81337 .46828 Metetra
.692 .741 .889 r
.81337 .46828 .81801 .47495 .8288 .4707 .82418 .46396 Metetra
.691 .74 .888 r
.82418 .46396 .8288 .4707 .83962 .46645 .83503 .45964 Metetra
.69 .738 .888 r
.83503 .45964 .83962 .46645 .85048 .46221 .84591 .45534 Metetra
.689 .736 .887 r
.84591 .45534 .85048 .46221 .86138 .45799 .85683 .45105 Metetra
.688 .734 .886 r
.85683 .45105 .86138 .45799 .87231 .45378 .86779 .44677 Metetra
.686 .732 .885 r
.86779 .44677 .87231 .45378 .88329 .44959 .87879 .44252 Metetra
.685 .731 .885 r
.87879 .44252 .88329 .44959 .8943 .44542 .88983 .4383 Metetra
.684 .729 .885 r
.88983 .4383 .8943 .44542 .90536 .44128 .90091 .4341 Metetra
.682 .727 .884 r
.90091 .4341 .90536 .44128 .91645 .43717 .91203 .42993 Metetra
.681 .726 .884 r
.91203 .42993 .91645 .43717 .92759 .43308 .9232 .42579 Metetra
.629 .713 .907 r
.31368 .70411 .31957 .71016 .32892 .70802 .32304 .70197 Metetra
.627 .713 .908 r
.32304 .70197 .32892 .70802 .33831 .70592 .33245 .69986 Metetra
.625 .713 .909 r
.33245 .69986 .33831 .70592 .34773 .70386 .34188 .6978 Metetra
.622 .713 .911 r
.34188 .6978 .34773 .70386 .35718 .70184 .35135 .69578 Metetra
.62 .713 .912 r
.35135 .69578 .35718 .70184 .36667 .69985 .36086 .6938 Metetra
.618 .713 .913 r
.36086 .6938 .36667 .69985 .3762 .6979 .3704 .69187 Metetra
.615 .713 .915 r
.3704 .69187 .3762 .6979 .38576 .69599 .37998 .68997 Metetra
.613 .713 .917 r
.37998 .68997 .38576 .69599 .39536 .69412 .3896 .68811 Metetra
.611 .714 .918 r
.3896 .68811 .39536 .69412 .405 .69227 .39925 .68629 Metetra
.609 .715 .92 r
.39925 .68629 .405 .69227 .41468 .69046 .40894 .6845 Metetra
.607 .716 .922 r
.40894 .6845 .41468 .69046 .42439 .68867 .41868 .68274 Metetra
.605 .717 .924 r
.41868 .68274 .42439 .68867 .43415 .6869 .42845 .681 Metetra
.603 .718 .925 r
.42845 .681 .43415 .6869 .44395 .68515 .43826 .67929 Metetra
.602 .719 .927 r
.43826 .67929 .44395 .68515 .45378 .68342 .44812 .67759 Metetra
.6 .72 .929 r
.44812 .67759 .45378 .68342 .46366 .6817 .45802 .6759 Metetra
.599 .722 .93 r
.45802 .6759 .46366 .6817 .47358 .67999 .46795 .67421 Metetra
.598 .723 .932 r
.46795 .67421 .47358 .67999 .48355 .67828 .47794 .67253 Metetra
.597 .724 .933 r
.47794 .67253 .48355 .67828 .49355 .67658 .48796 .67086 Metetra
.596 .726 .935 r
.48796 .67086 .49355 .67658 .5036 .67487 .49803 .66918 Metetra
.596 .727 .936 r
.49803 .66918 .5036 .67487 .51369 .67316 .50815 .66749 Metetra
.595 .729 .937 r
.50815 .66749 .51369 .67316 .52383 .67145 .5183 .66581 Metetra
.595 .73 .939 r
.5183 .66581 .52383 .67145 .53401 .66974 .52851 .66411 Metetra
.594 .731 .94 r
.52851 .66411 .53401 .66974 .54423 .66801 .53875 .66241 Metetra
.594 .733 .941 r
.53875 .66241 .54423 .66801 .5545 .66628 .54905 .6607 Metetra
.593 .734 .942 r
.54905 .6607 .5545 .66628 .56482 .66455 .55938 .65898 Metetra
.593 .735 .943 r
.55938 .65898 .56482 .66455 .57518 .6628 .56977 .65725 Metetra
.593 .736 .944 r
.56977 .65725 .57518 .6628 .58558 .66105 .5802 .65551 Metetra
.592 .738 .945 r
.5802 .65551 .58558 .66105 .59604 .65929 .59067 .65376 Metetra
.592 .739 .946 r
.59067 .65376 .59604 .65929 .60653 .65752 .6012 .652 Metetra
.592 .74 .946 r
.6012 .652 .60653 .65752 .61708 .65574 .61177 .65024 Metetra
.591 .741 .947 r
.61177 .65024 .61708 .65574 .62767 .65395 .62238 .64846 Metetra
.965 .716 .511 r
.62238 .64846 .62767 .65395 .63467 .5408 .62957 .53509 Metetra
.697 .764 .904 r
.62957 .53509 .63467 .5408 .64493 .53663 .63985 .53087 Metetra
.697 .763 .903 r
.63985 .53087 .64493 .53663 .65522 .53245 .65017 .52664 Metetra
.697 .762 .902 r
.65017 .52664 .65522 .53245 .66554 .52825 .66051 .52239 Metetra
.697 .761 .901 r
.66051 .52239 .66554 .52825 .67589 .52404 .67089 .51813 Metetra
.697 .76 .9 r
.67089 .51813 .67589 .52404 .68627 .51982 .6813 .51385 Metetra
.696 .758 .9 r
.6813 .51385 .68627 .51982 .69668 .51558 .69174 .50956 Metetra
.696 .757 .899 r
.69174 .50956 .69668 .51558 .70713 .51133 .70221 .50526 Metetra
.696 .756 .898 r
.70221 .50526 .70713 .51133 .71761 .50707 .71271 .50094 Metetra
.696 .755 .897 r
.71271 .50094 .71761 .50707 .72812 .5028 .72325 .4966 Metetra
.696 .754 .896 r
.72325 .4966 .72812 .5028 .73866 .49851 .73381 .49225 Metetra
.696 .752 .895 r
.73381 .49225 .73866 .49851 .74923 .49421 .74441 .48789 Metetra
.696 .751 .894 r
.74441 .48789 .74923 .49421 .75984 .48991 .75504 .48352 Metetra
.696 .75 .893 r
.75504 .48352 .75984 .48991 .77048 .48559 .76571 .47914 Metetra
.695 .748 .892 r
.76571 .47914 .77048 .48559 .78115 .48127 .77641 .47475 Metetra
.695 .746 .891 r
.77641 .47475 .78115 .48127 .79186 .47694 .78714 .47035 Metetra
.694 .745 .89 r
.78714 .47035 .79186 .47694 .8026 .47261 .7979 .46595 Metetra
.694 .743 .889 r
.7979 .46595 .8026 .47261 .81337 .46828 .8087 .46155 Metetra
.693 .741 .888 r
.8087 .46155 .81337 .46828 .82418 .46396 .81954 .45716 Metetra
.692 .739 .887 r
.81954 .45716 .82418 .46396 .83503 .45964 .83041 .45277 Metetra
.691 .737 .886 r
.83041 .45277 .83503 .45964 .84591 .45534 .84131 .44839 Metetra
.69 .736 .886 r
.84131 .44839 .84591 .45534 .85683 .45105 .85226 .44403 Metetra
.689 .734 .885 r
.85226 .44403 .85683 .45105 .86779 .44677 .86324 .43969 Metetra
.688 .732 .884 r
.86324 .43969 .86779 .44677 .87879 .44252 .87427 .43537 Metetra
.686 .73 .884 r
.87427 .43537 .87879 .44252 .88983 .4383 .88533 .43108 Metetra
.685 .728 .883 r
.88533 .43108 .88983 .4383 .90091 .4341 .89643 .42683 Metetra
.683 .726 .883 r
.89643 .42683 .90091 .4341 .91203 .42993 .90758 .4226 Metetra
.682 .725 .883 r
.90758 .4226 .91203 .42993 .9232 .42579 .91877 .41842 Metetra
.629 .712 .906 r
.30775 .69798 .31368 .70411 .32304 .70197 .31713 .69583 Metetra
.627 .711 .907 r
.31713 .69583 .32304 .70197 .33245 .69986 .32655 .69372 Metetra
.624 .711 .908 r
.32655 .69372 .33245 .69986 .34188 .6978 .336 .69165 Metetra
.622 .711 .909 r
.336 .69165 .34188 .6978 .35135 .69578 .34549 .68964 Metetra
.619 .711 .911 r
.34549 .68964 .35135 .69578 .36086 .6938 .35501 .68767 Metetra
.617 .711 .912 r
.35501 .68767 .36086 .6938 .3704 .69187 .36457 .68574 Metetra
.614 .711 .914 r
.36457 .68574 .3704 .69187 .37998 .68997 .37416 .68386 Metetra
.612 .711 .916 r
.37416 .68386 .37998 .68997 .3896 .68811 .3838 .68203 Metetra
.609 .712 .918 r
.3838 .68203 .3896 .68811 .39925 .68629 .39347 .68023 Metetra
.607 .713 .919 r
.39347 .68023 .39925 .68629 .40894 .6845 .40318 .67847 Metetra
.605 .714 .921 r
.40318 .67847 .40894 .6845 .41868 .68274 .41292 .67674 Metetra
.603 .715 .923 r
.41292 .67674 .41868 .68274 .42845 .681 .42271 .67504 Metetra
.601 .716 .925 r
.42271 .67504 .42845 .681 .43826 .67929 .43254 .67336 Metetra
.599 .717 .927 r
.43254 .67336 .43826 .67929 .44812 .67759 .44242 .67169 Metetra
.598 .719 .929 r
.44242 .67169 .44812 .67759 .45802 .6759 .45233 .67004 Metetra
.597 .72 .931 r
.45233 .67004 .45802 .6759 .46795 .67421 .46229 .66839 Metetra
.596 .722 .932 r
.46229 .66839 .46795 .67421 .47794 .67253 .47229 .66674 Metetra
.595 .723 .934 r
.47229 .66674 .47794 .67253 .48796 .67086 .48234 .66509 Metetra
.594 .725 .935 r
.48234 .66509 .48796 .67086 .49803 .66918 .49243 .66344 Metetra
.593 .726 .937 r
.49243 .66344 .49803 .66918 .50815 .66749 .50256 .66179 Metetra
.593 .728 .938 r
.50256 .66179 .50815 .66749 .5183 .66581 .51274 .66012 Metetra
.593 .729 .939 r
.51274 .66012 .5183 .66581 .52851 .66411 .52296 .65845 Metetra
.592 .731 .94 r
.52296 .65845 .52851 .66411 .53875 .66241 .53323 .65676 Metetra
.592 .732 .941 r
.53323 .65676 .53875 .66241 .54905 .6607 .54355 .65507 Metetra
.592 .733 .942 r
.54355 .65507 .54905 .6607 .55938 .65898 .55391 .65337 Metetra
.591 .735 .943 r
.55391 .65337 .55938 .65898 .56977 .65725 .56432 .65165 Metetra
.591 .736 .944 r
.56432 .65165 .56977 .65725 .5802 .65551 .57477 .64993 Metetra
.591 .737 .945 r
.57477 .64993 .5802 .65551 .59067 .65376 .58527 .64819 Metetra
.59 .738 .946 r
.58527 .64819 .59067 .65376 .6012 .652 .59582 .64645 Metetra
.59 .739 .947 r
.59582 .64645 .6012 .652 .61177 .65024 .60642 .6447 Metetra
.59 .74 .948 r
.60642 .6447 .61177 .65024 .62238 .64846 .61706 .64293 Metetra
.965 .716 .511 r
.61706 .64293 .62238 .64846 .62957 .53509 .62443 .52935 Metetra
.698 .764 .903 r
.62443 .52935 .62957 .53509 .63985 .53087 .63474 .52508 Metetra
.698 .763 .902 r
.63474 .52508 .63985 .53087 .65017 .52664 .64508 .52079 Metetra
.698 .762 .902 r
.64508 .52079 .65017 .52664 .66051 .52239 .65545 .51649 Metetra
.698 .761 .901 r
.65545 .51649 .66051 .52239 .67089 .51813 .66586 .51218 Metetra
.698 .76 .9 r
.66586 .51218 .67089 .51813 .6813 .51385 .67629 .50785 Metetra
.698 .759 .899 r
.67629 .50785 .6813 .51385 .69174 .50956 .68676 .5035 Metetra
.697 .758 .898 r
.68676 .5035 .69174 .50956 .70221 .50526 .69725 .49914 Metetra
.697 .757 .897 r
.69725 .49914 .70221 .50526 .71271 .50094 .70778 .49476 Metetra
.697 .755 .897 r
.70778 .49476 .71271 .50094 .72325 .4966 .71834 .49037 Metetra
.697 .754 .896 r
.71834 .49037 .72325 .4966 .73381 .49225 .72894 .48596 Metetra
.697 .753 .895 r
.72894 .48596 .73381 .49225 .74441 .48789 .73956 .48153 Metetra
.697 .751 .894 r
.73956 .48153 .74441 .48789 .75504 .48352 .75022 .47709 Metetra
.697 .75 .893 r
.75022 .47709 .75504 .48352 .76571 .47914 .76091 .47264 Metetra
.697 .748 .891 r
.76091 .47264 .76571 .47914 .77641 .47475 .77163 .46818 Metetra
.696 .747 .89 r
.77163 .46818 .77641 .47475 .78714 .47035 .78238 .46371 Metetra
.696 .745 .889 r
.78238 .46371 .78714 .47035 .7979 .46595 .79317 .45924 Metetra
.695 .743 .888 r
.79317 .45924 .7979 .46595 .8087 .46155 .804 .45476 Metetra
.695 .741 .887 r
.804 .45476 .8087 .46155 .81954 .45716 .81486 .45029 Metetra
.694 .739 .886 r
.81486 .45029 .81954 .45716 .83041 .45277 .82575 .44582 Metetra
.693 .737 .885 r
.82575 .44582 .83041 .45277 .84131 .44839 .83668 .44137 Metetra
.691 .735 .884 r
.83668 .44137 .84131 .44839 .85226 .44403 .84765 .43693 Metetra
.69 .733 .883 r
.84765 .43693 .85226 .44403 .86324 .43969 .85866 .43252 Metetra
.689 .731 .883 r
.85866 .43252 .86324 .43969 .87427 .43537 .8697 .42813 Metetra
.687 .729 .882 r
.8697 .42813 .87427 .43537 .88533 .43108 .88079 .42378 Metetra
.686 .727 .882 r
.88079 .42378 .88533 .43108 .89643 .42683 .89192 .41946 Metetra
.684 .725 .881 r
.89192 .41946 .89643 .42683 .90758 .4226 .90309 .41518 Metetra
.682 .724 .881 r
.90309 .41518 .90758 .4226 .91877 .41842 .91431 .41094 Metetra
.629 .71 .905 r
.30179 .69177 .30775 .69798 .31713 .69583 .31119 .6896 Metetra
.626 .709 .906 r
.31119 .6896 .31713 .69583 .32655 .69372 .32063 .68748 Metetra
.624 .709 .907 r
.32063 .68748 .32655 .69372 .336 .69165 .33009 .68542 Metetra
.621 .709 .908 r
.33009 .68542 .336 .69165 .34549 .68964 .3396 .6834 Metetra
.618 .708 .91 r
.3396 .6834 .34549 .68964 .35501 .68767 .34913 .68144 Metetra
.615 .708 .911 r
.34913 .68144 .35501 .68767 .36457 .68574 .35871 .67953 Metetra
.613 .709 .913 r
.35871 .67953 .36457 .68574 .37416 .68386 .36831 .67767 Metetra
.61 .709 .915 r
.36831 .67767 .37416 .68386 .3838 .68203 .37796 .67586 Metetra
.607 .709 .917 r
.37796 .67586 .3838 .68203 .39347 .68023 .38765 .67409 Metetra
.605 .71 .919 r
.38765 .67409 .39347 .68023 .40318 .67847 .39737 .67237 Metetra
.602 .711 .921 r
.39737 .67237 .40318 .67847 .41292 .67674 .40714 .67067 Metetra
.6 .713 .923 r
.40714 .67067 .41292 .67674 .42271 .67504 .41694 .66901 Metetra
.598 .714 .925 r
.41694 .66901 .42271 .67504 .43254 .67336 .42679 .66737 Metetra
.597 .716 .927 r
.42679 .66737 .43254 .67336 .44242 .67169 .43668 .66574 Metetra
.595 .717 .929 r
.43668 .66574 .44242 .67169 .45233 .67004 .44661 .66413 Metetra
.594 .719 .931 r
.44661 .66413 .45233 .67004 .46229 .66839 .45659 .66252 Metetra
.593 .721 .933 r
.45659 .66252 .46229 .66839 .47229 .66674 .46661 .6609 Metetra
.592 .722 .934 r
.46661 .6609 .47229 .66674 .48234 .66509 .47668 .65929 Metetra
.592 .724 .936 r
.47668 .65929 .48234 .66509 .49243 .66344 .48679 .65767 Metetra
.591 .726 .937 r
.48679 .65767 .49243 .66344 .50256 .66179 .49694 .65604 Metetra
.591 .727 .938 r
.49694 .65604 .50256 .66179 .51274 .66012 .50714 .6544 Metetra
.59 .729 .94 r
.50714 .6544 .51274 .66012 .52296 .65845 .51739 .65275 Metetra
.59 .73 .941 r
.51739 .65275 .52296 .65845 .53323 .65676 .52768 .65109 Metetra
.59 .731 .942 r
.52768 .65109 .53323 .65676 .54355 .65507 .53802 .64941 Metetra
.59 .733 .943 r
.53802 .64941 .54355 .65507 .55391 .65337 .5484 .64772 Metetra
.59 .734 .944 r
.5484 .64772 .55391 .65337 .56432 .65165 .55883 .64603 Metetra
.589 .735 .945 r
.55883 .64603 .56432 .65165 .57477 .64993 .56931 .64432 Metetra
.589 .736 .946 r
.56931 .64432 .57477 .64993 .58527 .64819 .57984 .64259 Metetra
.589 .738 .946 r
.57984 .64259 .58527 .64819 .59582 .64645 .59041 .64086 Metetra
.588 .739 .947 r
.59041 .64086 .59582 .64645 .60642 .6447 .60103 .63912 Metetra
.588 .74 .948 r
.60103 .63912 .60642 .6447 .61706 .64293 .6117 .63737 Metetra
.965 .716 .511 r
.6117 .63737 .61706 .64293 .62443 .52935 .61926 .52357 Metetra
.699 .764 .903 r
.61926 .52357 .62443 .52935 .63474 .52508 .62959 .51925 Metetra
.699 .763 .902 r
.62959 .51925 .63474 .52508 .64508 .52079 .63996 .51491 Metetra
.699 .762 .901 r
.63996 .51491 .64508 .52079 .65545 .51649 .65036 .51056 Metetra
.699 .761 .9 r
.65036 .51056 .65545 .51649 .66586 .51218 .66079 .50619 Metetra
.699 .76 .9 r
.66079 .50619 .66586 .51218 .67629 .50785 .67125 .5018 Metetra
.699 .759 .899 r
.67125 .5018 .67629 .50785 .68676 .5035 .68174 .4974 Metetra
.699 .758 .898 r
.68174 .4974 .68676 .5035 .69725 .49914 .69226 .49298 Metetra
.699 .757 .897 r
.69226 .49298 .69725 .49914 .70778 .49476 .70282 .48854 Metetra
.699 .756 .896 r
.70282 .48854 .70778 .49476 .71834 .49037 .71341 .48409 Metetra
.699 .755 .895 r
.71341 .48409 .71834 .49037 .72894 .48596 .72402 .47962 Metetra
.699 .753 .894 r
.72402 .47962 .72894 .48596 .73956 .48153 .73468 .47513 Metetra
.698 .752 .893 r
.73468 .47513 .73956 .48153 .75022 .47709 .74536 .47062 Metetra
.698 .75 .892 r
.74536 .47062 .75022 .47709 .76091 .47264 .75607 .4661 Metetra
.698 .749 .891 r
.75607 .4661 .76091 .47264 .77163 .46818 .76682 .46156 Metetra
.698 .747 .89 r
.76682 .46156 .77163 .46818 .78238 .46371 .7776 .45702 Metetra
.697 .745 .888 r
.7776 .45702 .78238 .46371 .79317 .45924 .78841 .45246 Metetra
.697 .743 .887 r
.78841 .45246 .79317 .45924 .804 .45476 .79926 .44791 Metetra
.696 .741 .886 r
.79926 .44791 .804 .45476 .81486 .45029 .81014 .44335 Metetra
.695 .739 .885 r
.81014 .44335 .81486 .45029 .82575 .44582 .82106 .4388 Metetra
.694 .737 .884 r
.82106 .4388 .82575 .44582 .83668 .44137 .83202 .43427 Metetra
.693 .735 .883 r
.83202 .43427 .83668 .44137 .84765 .43693 .84301 .42975 Metetra
.692 .732 .882 r
.84301 .42975 .84765 .43693 .85866 .43252 .85404 .42526 Metetra
.69 .73 .881 r
.85404 .42526 .85866 .43252 .8697 .42813 .86511 .4208 Metetra
.688 .728 .881 r
.86511 .4208 .8697 .42813 .88079 .42378 .87622 .41638 Metetra
.686 .726 .88 r
.87622 .41638 .88079 .42378 .89192 .41946 .88737 .41199 Metetra
.685 .724 .88 r
.88737 .41199 .89192 .41946 .90309 .41518 .89857 .40765 Metetra
.683 .722 .88 r
.89857 .40765 .90309 .41518 .91431 .41094 .90981 .40336 Metetra
.629 .708 .903 r
.2958 .68546 .30179 .69177 .31119 .6896 .30522 .68328 Metetra
.626 .707 .904 r
.30522 .68328 .31119 .6896 .32063 .68748 .31467 .68115 Metetra
.623 .707 .905 r
.31467 .68115 .32063 .68748 .33009 .68542 .32415 .67908 Metetra
.62 .706 .907 r
.32415 .67908 .33009 .68542 .3396 .6834 .33367 .67707 Metetra
.617 .706 .908 r
.33367 .67707 .3396 .6834 .34913 .68144 .34322 .67511 Metetra
.614 .706 .91 r
.34322 .67511 .34913 .68144 .35871 .67953 .35281 .67321 Metetra
.611 .706 .912 r
.35281 .67321 .35871 .67953 .36831 .67767 .36243 .67138 Metetra
.608 .706 .914 r
.36243 .67138 .36831 .67767 .37796 .67586 .37209 .6696 Metetra
.605 .707 .916 r
.37209 .6696 .37796 .67586 .38765 .67409 .38179 .66787 Metetra
.602 .708 .918 r
.38179 .66787 .38765 .67409 .39737 .67237 .39153 .66618 Metetra
.6 .709 .921 r
.39153 .66618 .39737 .67237 .40714 .67067 .40132 .66453 Metetra
.597 .71 .923 r
.40132 .66453 .40714 .67067 .41694 .66901 .41114 .66292 Metetra
.595 .712 .925 r
.41114 .66292 .41694 .66901 .42679 .66737 .421 .66132 Metetra
.594 .714 .927 r
.421 .66132 .42679 .66737 .43668 .66574 .43091 .65974 Metetra
.592 .715 .929 r
.43091 .65974 .43668 .66574 .44661 .66413 .44086 .65817 Metetra
.591 .717 .931 r
.44086 .65817 .44661 .66413 .45659 .66252 .45085 .6566 Metetra
.59 .719 .933 r
.45085 .6566 .45659 .66252 .46661 .6609 .46089 .65503 Metetra
.59 .721 .935 r
.46089 .65503 .46661 .6609 .47668 .65929 .47098 .65345 Metetra
.589 .723 .936 r
.47098 .65345 .47668 .65929 .48679 .65767 .48111 .65186 Metetra
.589 .725 .938 r
.48111 .65186 .48679 .65767 .49694 .65604 .49128 .65026 Metetra
.589 .726 .939 r
.49128 .65026 .49694 .65604 .50714 .6544 .5015 .64864 Metetra
.588 .728 .94 r
.5015 .64864 .50714 .6544 .51739 .65275 .51177 .64702 Metetra
.588 .729 .941 r
.51177 .64702 .51739 .65275 .52768 .65109 .52209 .64537 Metetra
.588 .731 .942 r
.52209 .64537 .52768 .65109 .53802 .64941 .53245 .64372 Metetra
.588 .732 .943 r
.53245 .64372 .53802 .64941 .5484 .64772 .54285 .64205 Metetra
.588 .734 .944 r
.54285 .64205 .5484 .64772 .55883 .64603 .55331 .64036 Metetra
.588 .735 .945 r
.55331 .64036 .55883 .64603 .56931 .64432 .56381 .63867 Metetra
.587 .736 .946 r
.56381 .63867 .56931 .64432 .57984 .64259 .57436 .63696 Metetra
.587 .737 .947 r
.57436 .63696 .57984 .64259 .59041 .64086 .58496 .63524 Metetra
.587 .738 .948 r
.58496 .63524 .59041 .64086 .60103 .63912 .5956 .6335 Metetra
.587 .739 .948 r
.5956 .6335 .60103 .63912 .6117 .63737 .6063 .63176 Metetra
.965 .716 .511 r
.6063 .63176 .6117 .63737 .61926 .52357 .61405 .51775 Metetra
.7 .765 .902 r
.61405 .51775 .61926 .52357 .62959 .51925 .62441 .51338 Metetra
.699 .764 .902 r
.62441 .51338 .62959 .51925 .63996 .51491 .6348 .50899 Metetra
.699 .763 .901 r
.6348 .50899 .63996 .51491 .65036 .51056 .64523 .50458 Metetra
.699 .762 .9 r
.64523 .50458 .65036 .51056 .66079 .50619 .65569 .50016 Metetra
.7 .761 .899 r
.65569 .50016 .66079 .50619 .67125 .5018 .66617 .49572 Metetra
.7 .76 .898 r
.66617 .49572 .67125 .5018 .68174 .4974 .67669 .49126 Metetra
.7 .759 .898 r
.67669 .49126 .68174 .4974 .69226 .49298 .68724 .48679 Metetra
.7 .757 .897 r
.68724 .48679 .69226 .49298 .70282 .48854 .69782 .48229 Metetra
.7 .756 .896 r
.69782 .48229 .70282 .48854 .71341 .48409 .70844 .47777 Metetra
.7 .755 .895 r
.70844 .47777 .71341 .48409 .72402 .47962 .71908 .47324 Metetra
.7 .754 .894 r
.71908 .47324 .72402 .47962 .73468 .47513 .72976 .46868 Metetra
.7 .752 .892 r
.72976 .46868 .73468 .47513 .74536 .47062 .74047 .4641 Metetra
.7 .751 .891 r
.74047 .4641 .74536 .47062 .75607 .4661 .75121 .45951 Metetra
.7 .749 .89 r
.75121 .45951 .75607 .4661 .76682 .46156 .76198 .4549 Metetra
.699 .748 .889 r
.76198 .4549 .76682 .46156 .7776 .45702 .77278 .45027 Metetra
.699 .746 .888 r
.77278 .45027 .7776 .45702 .78841 .45246 .78362 .44564 Metetra
.699 .744 .886 r
.78362 .44564 .78841 .45246 .79926 .44791 .79449 .44099 Metetra
.698 .741 .885 r
.79449 .44099 .79926 .44791 .81014 .44335 .8054 .43635 Metetra
.697 .739 .884 r
.8054 .43635 .81014 .44335 .82106 .4388 .81634 .43171 Metetra
.696 .737 .882 r
.81634 .43171 .82106 .4388 .83202 .43427 .82732 .42709 Metetra
.695 .734 .881 r
.82732 .42709 .83202 .43427 .84301 .42975 .83833 .42248 Metetra
.693 .732 .88 r
.83833 .42248 .84301 .42975 .85404 .42526 .84938 .41791 Metetra
.691 .729 .879 r
.84938 .41791 .85404 .42526 .86511 .4208 .86048 .41337 Metetra
.689 .727 .879 r
.86048 .41337 .86511 .4208 .87622 .41638 .87161 .40887 Metetra
.687 .725 .878 r
.87161 .40887 .87622 .41638 .88737 .41199 .88279 .40442 Metetra
.685 .723 .878 r
.88279 .40442 .88737 .41199 .89857 .40765 .89401 .40002 Metetra
.683 .721 .878 r
.89401 .40002 .89857 .40765 .90981 .40336 .90527 .39567 Metetra
.629 .706 .902 r
.28978 .67906 .2958 .68546 .30522 .68328 .29921 .67686 Metetra
.626 .706 .903 r
.29921 .67686 .30522 .68328 .31467 .68115 .30868 .67472 Metetra
.623 .705 .904 r
.30868 .67472 .31467 .68115 .32415 .67908 .31818 .67264 Metetra
.62 .704 .905 r
.31818 .67264 .32415 .67908 .33367 .67707 .32771 .67063 Metetra
.617 .704 .907 r
.32771 .67063 .33367 .67707 .34322 .67511 .33728 .66868 Metetra
.613 .703 .909 r
.33728 .66868 .34322 .67511 .35281 .67321 .34688 .6668 Metetra
.61 .703 .911 r
.34688 .6668 .35281 .67321 .36243 .67138 .35652 .66498 Metetra
.606 .703 .913 r
.35652 .66498 .36243 .67138 .37209 .6696 .36619 .66324 Metetra
.603 .704 .915 r
.36619 .66324 .37209 .6696 .38179 .66787 .37591 .66155 Metetra
.599 .705 .918 r
.37591 .66155 .38179 .66787 .39153 .66618 .38566 .65991 Metetra
.596 .706 .92 r
.38566 .65991 .39153 .66618 .40132 .66453 .39546 .65832 Metetra
.594 .708 .923 r
.39546 .65832 .40132 .66453 .41114 .66292 .4053 .65675 Metetra
.592 .71 .925 r
.4053 .65675 .41114 .66292 .421 .66132 .41518 .65521 Metetra
.59 .712 .928 r
.41518 .65521 .421 .66132 .43091 .65974 .4251 .65369 Metetra
.589 .714 .93 r
.4251 .65369 .43091 .65974 .44086 .65817 .43507 .65216 Metetra
.588 .716 .932 r
.43507 .65216 .44086 .65817 .45085 .6566 .44508 .65064 Metetra
.587 .718 .934 r
.44508 .65064 .45085 .6566 .46089 .65503 .45514 .64911 Metetra
.587 .72 .935 r
.45514 .64911 .46089 .65503 .47098 .65345 .46524 .64757 Metetra
.586 .722 .937 r
.46524 .64757 .47098 .65345 .48111 .65186 .47539 .64601 Metetra
.586 .724 .938 r
.47539 .64601 .48111 .65186 .49128 .65026 .48559 .64444 Metetra
.586 .726 .94 r
.48559 .64444 .49128 .65026 .5015 .64864 .49583 .64286 Metetra
.586 .727 .941 r
.49583 .64286 .5015 .64864 .51177 .64702 .50612 .64125 Metetra
.586 .729 .942 r
.50612 .64125 .51177 .64702 .52209 .64537 .51645 .63963 Metetra
.586 .73 .943 r
.51645 .63963 .52209 .64537 .53245 .64372 .52684 .63799 Metetra
.586 .732 .944 r
.52684 .63799 .53245 .64372 .54285 .64205 .53727 .63634 Metetra
.586 .733 .945 r
.53727 .63634 .54285 .64205 .55331 .64036 .54775 .63467 Metetra
.586 .734 .946 r
.54775 .63467 .55331 .64036 .56381 .63867 .55827 .63298 Metetra
.586 .736 .946 r
.55827 .63298 .56381 .63867 .57436 .63696 .56885 .63128 Metetra
.586 .737 .947 r
.56885 .63128 .57436 .63696 .58496 .63524 .57947 .62957 Metetra
.585 .738 .948 r
.57947 .62957 .58496 .63524 .5956 .6335 .59014 .62785 Metetra
.585 .739 .949 r
.59014 .62785 .5956 .6335 .6063 .63176 .60086 .62612 Metetra
.965 .716 .511 r
.60086 .62612 .6063 .63176 .61405 .51775 .6088 .51189 Metetra
.7 .765 .902 r
.6088 .51189 .61405 .51775 .62441 .51338 .61919 .50747 Metetra
.7 .764 .901 r
.61919 .50747 .62441 .51338 .6348 .50899 .62961 .50303 Metetra
.7 .763 .9 r
.62961 .50303 .6348 .50899 .64523 .50458 .64007 .49857 Metetra
.7 .762 .9 r
.64007 .49857 .64523 .50458 .65569 .50016 .65055 .4941 Metetra
.7 .761 .899 r
.65055 .4941 .65569 .50016 .66617 .49572 .66106 .4896 Metetra
.701 .76 .898 r
.66106 .4896 .66617 .49572 .67669 .49126 .67161 .48509 Metetra
.701 .759 .897 r
.67161 .48509 .67669 .49126 .68724 .48679 .68219 .48056 Metetra
.701 .758 .896 r
.68219 .48056 .68724 .48679 .69782 .48229 .69279 .476 Metetra
.701 .757 .895 r
.69279 .476 .69782 .48229 .70844 .47777 .70343 .47142 Metetra
.701 .756 .894 r
.70343 .47142 .70844 .47777 .71908 .47324 .71411 .46682 Metetra
.701 .754 .893 r
.71411 .46682 .71908 .47324 .72976 .46868 .72481 .4622 Metetra
.701 .753 .892 r
.72481 .4622 .72976 .46868 .74047 .4641 .73554 .45755 Metetra
.701 .752 .891 r
.73554 .45755 .74047 .4641 .75121 .45951 .74631 .45288 Metetra
.701 .75 .889 r
.74631 .45288 .75121 .45951 .76198 .4549 .75711 .44819 Metetra
.701 .748 .888 r
.75711 .44819 .76198 .4549 .77278 .45027 .76793 .44348 Metetra
.701 .746 .887 r
.76793 .44348 .77278 .45027 .78362 .44564 .7788 .43875 Metetra
.701 .744 .885 r
.7788 .43875 .78362 .44564 .79449 .44099 .78969 .43402 Metetra
.7 .742 .884 r
.78969 .43402 .79449 .44099 .8054 .43635 .80062 .42928 Metetra
.699 .739 .882 r
.80062 .42928 .8054 .43635 .81634 .43171 .81158 .42455 Metetra
.698 .737 .881 r
.81158 .42455 .81634 .43171 .82732 .42709 .82258 .41983 Metetra
.696 .734 .88 r
.82258 .41983 .82732 .42709 .83833 .42248 .83362 .41513 Metetra
.695 .731 .879 r
.83362 .41513 .83833 .42248 .84938 .41791 .84469 .41046 Metetra
.693 .728 .878 r
.84469 .41046 .84938 .41791 .86048 .41337 .85581 .40583 Metetra
.691 .726 .877 r
.85581 .40583 .86048 .41337 .87161 .40887 .86696 .40125 Metetra
.688 .723 .876 r
.86696 .40125 .87161 .40887 .88279 .40442 .87817 .39673 Metetra
.686 .721 .876 r
.87817 .39673 .88279 .40442 .89401 .40002 .88941 .39227 Metetra
.684 .719 .876 r
.88941 .39227 .89401 .40002 .90527 .39567 .9007 .38787 Metetra
.629 .704 .9 r
.28373 .67257 .28978 .67906 .29921 .67686 .29318 .67035 Metetra
.626 .703 .901 r
.29318 .67035 .29921 .67686 .30868 .67472 .30266 .66819 Metetra
.623 .702 .902 r
.30266 .66819 .30868 .67472 .31818 .67264 .31217 .66609 Metetra
.62 .702 .903 r
.31217 .66609 .31818 .67264 .32771 .67063 .32172 .66407 Metetra
.616 .701 .905 r
.32172 .66407 .32771 .67063 .33728 .66868 .3313 .66213 Metetra
.612 .7 .907 r
.3313 .66213 .33728 .66868 .34688 .6668 .34092 .66027 Metetra
.608 .7 .909 r
.34092 .66027 .34688 .6668 .35652 .66498 .35057 .65848 Metetra
.604 .7 .912 r
.35057 .65848 .35652 .66498 .36619 .66324 .36026 .65677 Metetra
.6 .701 .914 r
.36026 .65677 .36619 .66324 .37591 .66155 .36999 .65513 Metetra
.596 .702 .917 r
.36999 .65513 .37591 .66155 .38566 .65991 .37976 .65355 Metetra
.593 .703 .92 r
.37976 .65355 .38566 .65991 .39546 .65832 .38957 .65202 Metetra
.59 .705 .923 r
.38957 .65202 .39546 .65832 .4053 .65675 .39942 .65052 Metetra
.588 .707 .926 r
.39942 .65052 .4053 .65675 .41518 .65521 .40931 .64905 Metetra
.586 .71 .928 r
.40931 .64905 .41518 .65521 .4251 .65369 .41925 .64758 Metetra
.585 .712 .93 r
.41925 .64758 .4251 .65369 .43507 .65216 .42924 .64611 Metetra
.584 .714 .933 r
.42924 .64611 .43507 .65216 .44508 .65064 .43927 .64464 Metetra
.584 .717 .935 r
.43927 .64464 .44508 .65064 .45514 .64911 .44934 .64316 Metetra
.584 .719 .936 r
.44934 .64316 .45514 .64911 .46524 .64757 .45947 .64166 Metetra
.584 .721 .938 r
.45947 .64166 .46524 .64757 .47539 .64601 .46964 .64014 Metetra
.584 .723 .939 r
.46964 .64014 .47539 .64601 .48559 .64444 .47985 .6386 Metetra
.584 .725 .941 r
.47985 .6386 .48559 .64444 .49583 .64286 .49012 .63704 Metetra
.584 .727 .942 r
.49012 .63704 .49583 .64286 .50612 .64125 .50043 .63546 Metetra
.584 .729 .943 r
.50043 .63546 .50612 .64125 .51645 .63963 .51078 .63386 Metetra
.584 .73 .944 r
.51078 .63386 .51645 .63963 .52684 .63799 .52119 .63224 Metetra
.584 .731 .945 r
.52119 .63224 .52684 .63799 .53727 .63634 .53164 .6306 Metetra
.584 .733 .945 r
.53164 .6306 .53727 .63634 .54775 .63467 .54215 .62894 Metetra
.584 .734 .946 r
.54215 .62894 .54775 .63467 .55827 .63298 .5527 .62726 Metetra
.584 .735 .947 r
.5527 .62726 .55827 .63298 .56885 .63128 .56329 .62558 Metetra
.584 .736 .948 r
.56329 .62558 .56885 .63128 .57947 .62957 .57394 .62387 Metetra
.584 .737 .948 r
.57394 .62387 .57947 .62957 .59014 .62785 .58464 .62216 Metetra
.584 .738 .949 r
.58464 .62216 .59014 .62785 .60086 .62612 .59539 .62044 Metetra
.965 .716 .511 r
.59539 .62044 .60086 .62612 .6088 .51189 .60352 .50599 Metetra
.701 .765 .902 r
.60352 .50599 .6088 .51189 .61919 .50747 .61394 .50152 Metetra
.701 .764 .901 r
.61394 .50152 .61919 .50747 .62961 .50303 .62439 .49703 Metetra
.701 .763 .9 r
.62439 .49703 .62961 .50303 .64007 .49857 .63487 .49252 Metetra
.701 .762 .899 r
.63487 .49252 .64007 .49857 .65055 .4941 .64538 .488 Metetra
.701 .762 .899 r
.64538 .488 .65055 .4941 .66106 .4896 .65592 .48345 Metetra
.702 .761 .898 r
.65592 .48345 .66106 .4896 .67161 .48509 .66649 .47888 Metetra
.702 .76 .897 r
.66649 .47888 .67161 .48509 .68219 .48056 .6771 .47429 Metetra
.702 .759 .896 r
.6771 .47429 .68219 .48056 .69279 .476 .68773 .46968 Metetra
.702 .758 .895 r
.68773 .46968 .69279 .476 .70343 .47142 .6984 .46504 Metetra
.702 .756 .894 r
.6984 .46504 .70343 .47142 .71411 .46682 .7091 .46037 Metetra
.703 .755 .893 r
.7091 .46037 .71411 .46682 .72481 .4622 .71982 .45568 Metetra
.703 .754 .892 r
.71982 .45568 .72481 .4622 .73554 .45755 .73059 .45096 Metetra
.703 .752 .89 r
.73059 .45096 .73554 .45755 .74631 .45288 .74138 .44621 Metetra
.703 .751 .889 r
.74138 .44621 .74631 .45288 .75711 .44819 .7522 .44144 Metetra
.703 .749 .887 r
.7522 .44144 .75711 .44819 .76793 .44348 .76305 .43664 Metetra
.703 .747 .886 r
.76305 .43664 .76793 .44348 .7788 .43875 .77394 .43182 Metetra
.703 .745 .884 r
.77394 .43182 .7788 .43875 .78969 .43402 .78486 .42699 Metetra
.702 .742 .883 r
.78486 .42699 .78969 .43402 .80062 .42928 .79581 .42215 Metetra
.701 .74 .881 r
.79581 .42215 .80062 .42928 .81158 .42455 .80679 .41731 Metetra
.7 .737 .879 r
.80679 .41731 .81158 .42455 .82258 .41983 .81781 .41248 Metetra
.699 .734 .878 r
.81781 .41248 .82258 .41983 .83362 .41513 .82887 .40768 Metetra
.697 .731 .877 r
.82887 .40768 .83362 .41513 .84469 .41046 .83997 .40291 Metetra
.695 .727 .876 r
.83997 .40291 .84469 .41046 .85581 .40583 .8511 .39818 Metetra
.692 .725 .875 r
.8511 .39818 .85581 .40583 .86696 .40125 .86228 .39352 Metetra
.69 .722 .874 r
.86228 .39352 .86696 .40125 .87817 .39673 .87351 .38892 Metetra
.687 .719 .874 r
.87351 .38892 .87817 .39673 .88941 .39227 .88478 .38439 Metetra
.684 .717 .874 r
.88478 .38439 .88941 .39227 .9007 .38787 .89609 .37994 Metetra
.63 .703 .898 r
.27765 .66597 .28373 .67257 .29318 .67035 .28711 .66372 Metetra
.627 .701 .899 r
.28711 .66372 .29318 .67035 .30266 .66819 .29661 .66153 Metetra
.623 .7 .9 r
.29661 .66153 .30266 .66819 .31217 .66609 .30614 .65942 Metetra
.619 .699 .901 r
.30614 .65942 .31217 .66609 .32172 .66407 .3157 .65739 Metetra
.615 .698 .903 r
.3157 .65739 .32172 .66407 .3313 .66213 .32529 .65545 Metetra
.611 .697 .905 r
.32529 .65545 .3313 .66213 .34092 .66027 .33492 .65361 Metetra
.606 .697 .907 r
.33492 .65361 .34092 .66027 .35057 .65848 .34459 .65185 Metetra
.601 .697 .91 r
.34459 .65185 .35057 .65848 .36026 .65677 .35429 .65019 Metetra
.597 .697 .913 r
.35429 .65019 .36026 .65677 .36999 .65513 .36403 .64861 Metetra
.592 .698 .916 r
.36403 .64861 .36999 .65513 .37976 .65355 .37382 .6471 Metetra
.589 .7 .92 r
.37382 .6471 .37976 .65355 .38957 .65202 .38364 .64565 Metetra
.586 .702 .923 r
.38364 .64565 .38957 .65202 .39942 .65052 .3935 .64422 Metetra
.584 .705 .926 r
.3935 .64422 .39942 .65052 .40931 .64905 .40341 .64282 Metetra
.582 .707 .929 r
.40341 .64282 .40931 .64905 .41925 .64758 .41337 .64143 Metetra
.581 .71 .931 r
.41337 .64143 .41925 .64758 .42924 .64611 .42337 .64002 Metetra
.581 .713 .934 r
.42337 .64002 .42924 .64611 .43927 .64464 .43342 .63861 Metetra
.58 .716 .936 r
.43342 .63861 .43927 .64464 .44934 .64316 .44351 .63717 Metetra
.58 .718 .937 r
.44351 .63717 .44934 .64316 .45947 .64166 .45365 .63572 Metetra
.58 .721 .939 r
.45365 .63572 .45947 .64166 .46964 .64014 .46384 .63424 Metetra
.581 .723 .94 r
.46384 .63424 .46964 .64014 .47985 .6386 .47408 .63273 Metetra
.581 .725 .941 r
.47408 .63273 .47985 .6386 .49012 .63704 .48436 .6312 Metetra
.581 .727 .943 r
.48436 .6312 .49012 .63704 .50043 .63546 .4947 .62964 Metetra
.582 .728 .943 r
.4947 .62964 .50043 .63546 .51078 .63386 .50508 .62806 Metetra
.582 .73 .944 r
.50508 .62806 .51078 .63386 .52119 .63224 .5155 .62645 Metetra
.582 .731 .945 r
.5155 .62645 .52119 .63224 .53164 .6306 .52598 .62482 Metetra
.583 .733 .946 r
.52598 .62482 .53164 .6306 .54215 .62894 .53651 .62318 Metetra
.583 .734 .947 r
.53651 .62318 .54215 .62894 .5527 .62726 .54708 .62151 Metetra
.583 .735 .947 r
.54708 .62151 .5527 .62726 .56329 .62558 .5577 .61983 Metetra
.583 .736 .948 r
.5577 .61983 .56329 .62558 .57394 .62387 .56838 .61814 Metetra
.583 .737 .949 r
.56838 .61814 .57394 .62387 .58464 .62216 .5791 .61643 Metetra
.582 .738 .949 r
.5791 .61643 .58464 .62216 .59539 .62044 .58987 .61471 Metetra
.965 .716 .511 r
.58987 .61471 .59539 .62044 .60352 .50599 .5982 .50005 Metetra
.702 .765 .901 r
.5982 .50005 .60352 .50599 .61394 .50152 .60865 .49553 Metetra
.702 .765 .901 r
.60865 .49553 .61394 .50152 .62439 .49703 .61912 .49099 Metetra
.702 .764 .9 r
.61912 .49099 .62439 .49703 .63487 .49252 .62963 .48644 Metetra
.702 .763 .899 r
.62963 .48644 .63487 .49252 .64538 .488 .64017 .48186 Metetra
.702 .762 .898 r
.64017 .48186 .64538 .488 .65592 .48345 .65074 .47726 Metetra
.702 .761 .898 r
.65074 .47726 .65592 .48345 .66649 .47888 .66134 .47264 Metetra
.703 .76 .897 r
.66134 .47264 .66649 .47888 .6771 .47429 .67197 .46799 Metetra
.703 .759 .896 r
.67197 .46799 .6771 .47429 .68773 .46968 .68263 .46332 Metetra
.703 .758 .895 r
.68263 .46332 .68773 .46968 .6984 .46504 .69333 .45862 Metetra
.704 .757 .894 r
.69333 .45862 .6984 .46504 .7091 .46037 .70405 .45389 Metetra
.704 .756 .893 r
.70405 .45389 .7091 .46037 .71982 .45568 .71481 .44913 Metetra
.704 .755 .891 r
.71481 .44913 .71982 .45568 .73059 .45096 .7256 .44433 Metetra
.705 .753 .89 r
.7256 .44433 .73059 .45096 .74138 .44621 .73641 .43951 Metetra
.705 .752 .888 r
.73641 .43951 .74138 .44621 .7522 .44144 .74726 .43465 Metetra
.705 .75 .887 r
.74726 .43465 .7522 .44144 .76305 .43664 .75814 .42976 Metetra
.705 .748 .885 r
.75814 .42976 .76305 .43664 .77394 .43182 .76905 .42485 Metetra
.705 .746 .883 r
.76905 .42485 .77394 .43182 .78486 .42699 .77999 .41991 Metetra
.704 .743 .881 r
.77999 .41991 .78486 .42699 .79581 .42215 .79096 .41496 Metetra
.704 .74 .88 r
.79096 .41496 .79581 .42215 .80679 .41731 .80197 .41 Metetra
.703 .737 .878 r
.80197 .41 .80679 .41731 .81781 .41248 .81301 .40505 Metetra
.701 .734 .876 r
.81301 .40505 .81781 .41248 .82887 .40768 .82409 .40013 Metetra
.699 .73 .874 r
.82409 .40013 .82887 .40768 .83997 .40291 .83521 .39524 Metetra
.696 .726 .873 r
.83521 .39524 .83997 .40291 .8511 .39818 .84636 .39041 Metetra
.694 .723 .872 r
.84636 .39041 .8511 .39818 .86228 .39352 .85756 .38565 Metetra
.691 .72 .872 r
.85756 .38565 .86228 .39352 .87351 .38892 .86881 .38097 Metetra
.688 .717 .872 r
.86881 .38097 .87351 .38892 .88478 .38439 .8801 .37638 Metetra
.685 .715 .872 r
.8801 .37638 .88478 .38439 .89609 .37994 .89144 .37187 Metetra
.63 .701 .896 r
.27153 .65927 .27765 .66597 .28711 .66372 .28101 .65698 Metetra
.627 .699 .897 r
.28101 .65698 .28711 .66372 .29661 .66153 .29053 .65476 Metetra
.624 .698 .898 r
.29053 .65476 .29661 .66153 .30614 .65942 .30007 .65262 Metetra
.619 .696 .899 r
.30007 .65262 .30614 .65942 .3157 .65739 .30965 .65058 Metetra
.615 .695 .901 r
.30965 .65058 .3157 .65739 .32529 .65545 .31926 .64864 Metetra
.61 .693 .903 r
.31926 .64864 .32529 .65545 .33492 .65361 .3289 .64681 Metetra
.604 .692 .905 r
.3289 .64681 .33492 .65361 .34459 .65185 .33858 .64509 Metetra
.598 .692 .908 r
.33858 .64509 .34459 .65185 .35429 .65019 .3483 .64348 Metetra
.593 .693 .912 r
.3483 .64348 .35429 .65019 .36403 .64861 .35805 .64198 Metetra
.588 .694 .916 r
.35805 .64198 .36403 .64861 .37382 .6471 .36784 .64055 Metetra
.584 .696 .919 r
.36784 .64055 .37382 .6471 .38364 .64565 .37768 .63919 Metetra
.581 .699 .923 r
.37768 .63919 .38364 .64565 .3935 .64422 .38755 .63786 Metetra
.579 .702 .926 r
.38755 .63786 .3935 .64422 .40341 .64282 .39748 .63655 Metetra
.577 .705 .93 r
.39748 .63655 .40341 .64282 .41337 .64143 .40745 .63523 Metetra
.576 .708 .932 r
.40745 .63523 .41337 .64143 .42337 .64002 .41746 .6339 Metetra
.576 .712 .935 r
.41746 .6339 .42337 .64002 .43342 .63861 .42753 .63255 Metetra
.576 .715 .937 r
.42753 .63255 .43342 .63861 .44351 .63717 .43764 .63117 Metetra
.577 .717 .939 r
.43764 .63117 .44351 .63717 .45365 .63572 .4478 .62976 Metetra
.577 .72 .94 r
.4478 .62976 .45365 .63572 .46384 .63424 .45801 .62831 Metetra
.578 .722 .941 r
.45801 .62831 .46384 .63424 .47408 .63273 .46827 .62684 Metetra
.579 .724 .942 r
.46827 .62684 .47408 .63273 .48436 .6312 .47857 .62533 Metetra
.579 .726 .943 r
.47857 .62533 .48436 .6312 .4947 .62964 .48892 .62379 Metetra
.58 .728 .944 r
.48892 .62379 .4947 .62964 .50508 .62806 .49933 .62223 Metetra
.58 .73 .945 r
.49933 .62223 .50508 .62806 .5155 .62645 .50978 .62064 Metetra
.581 .731 .946 r
.50978 .62064 .5155 .62645 .52598 .62482 .52028 .61902 Metetra
.581 .732 .947 r
.52028 .61902 .52598 .62482 .53651 .62318 .53083 .61739 Metetra
.581 .734 .947 r
.53083 .61739 .53651 .62318 .54708 .62151 .54143 .61573 Metetra
.581 .735 .948 r
.54143 .61573 .54708 .62151 .5577 .61983 .55207 .61406 Metetra
.581 .736 .949 r
.55207 .61406 .5577 .61983 .56838 .61814 .56277 .61237 Metetra
.581 .737 .949 r
.56277 .61237 .56838 .61814 .5791 .61643 .57352 .61066 Metetra
.581 .737 .95 r
.57352 .61066 .5791 .61643 .58987 .61471 .58432 .60895 Metetra
.965 .716 .511 r
.58432 .60895 .58987 .61471 .5982 .50005 .59285 .49407 Metetra
.703 .766 .901 r
.59285 .49407 .5982 .50005 .60865 .49553 .60332 .4895 Metetra
.703 .765 .9 r
.60332 .4895 .60865 .49553 .61912 .49099 .61382 .48492 Metetra
.703 .764 .9 r
.61382 .48492 .61912 .49099 .62963 .48644 .62436 .48031 Metetra
.703 .763 .899 r
.62436 .48031 .62963 .48644 .64017 .48186 .63493 .47569 Metetra
.703 .763 .898 r
.63493 .47569 .64017 .48186 .65074 .47726 .64552 .47104 Metetra
.703 .762 .897 r
.64552 .47104 .65074 .47726 .66134 .47264 .65615 .46637 Metetra
.704 .761 .897 r
.65615 .46637 .66134 .47264 .67197 .46799 .66681 .46167 Metetra
.704 .76 .896 r
.66681 .46167 .67197 .46799 .68263 .46332 .6775 .45694 Metetra
.704 .759 .895 r
.6775 .45694 .68263 .46332 .69333 .45862 .68822 .45218 Metetra
.705 .758 .894 r
.68822 .45218 .69333 .45862 .70405 .45389 .69898 .44738 Metetra
.705 .757 .892 r
.69898 .44738 .70405 .45389 .71481 .44913 .70976 .44255 Metetra
.706 .756 .891 r
.70976 .44255 .71481 .44913 .7256 .44433 .72057 .43768 Metetra
.706 .755 .89 r
.72057 .43768 .7256 .44433 .73641 .43951 .73142 .43278 Metetra
.707 .753 .888 r
.73142 .43278 .73641 .43951 .74726 .43465 .74229 .42783 Metetra
.707 .751 .886 r
.74229 .42783 .74726 .43465 .75814 .42976 .75319 .42285 Metetra
.707 .749 .884 r
.75319 .42285 .75814 .42976 .76905 .42485 .76413 .41783 Metetra
.707 .747 .882 r
.76413 .41783 .76905 .42485 .77999 .41991 .77509 .41278 Metetra
.707 .744 .88 r
.77509 .41278 .77999 .41991 .79096 .41496 .78609 .40771 Metetra
.707 .741 .878 r
.78609 .40771 .79096 .41496 .80197 .41 .79711 .40262 Metetra
.706 .737 .876 r
.79711 .40262 .80197 .41 .81301 .40505 .80818 .39753 Metetra
.704 .733 .874 r
.80818 .39753 .81301 .40505 .82409 .40013 .81927 .39247 Metetra
.702 .729 .872 r
.81927 .39247 .82409 .40013 .83521 .39524 .83041 .38745 Metetra
.699 .725 .871 r
.83041 .38745 .83521 .39524 .84636 .39041 .84158 .3825 Metetra
.695 .721 .87 r
.84158 .3825 .84636 .39041 .85756 .38565 .8528 .37764 Metetra
.692 .718 .869 r
.8528 .37764 .85756 .38565 .86881 .38097 .86407 .37288 Metetra
.688 .714 .869 r
.86407 .37288 .86881 .38097 .8801 .37638 .87539 .36822 Metetra
.685 .712 .869 r
.87539 .36822 .8801 .37638 .89144 .37187 .88675 .36366 Metetra
.632 .699 .894 r
.26539 .65246 .27153 .65927 .28101 .65698 .27489 .65012 Metetra
.628 .697 .894 r
.27489 .65012 .28101 .65698 .29053 .65476 .28442 .64786 Metetra
.625 .695 .895 r
.28442 .64786 .29053 .65476 .30007 .65262 .29398 .64569 Metetra
.62 .693 .896 r
.29398 .64569 .30007 .65262 .30965 .65058 .30357 .64361 Metetra
.615 .691 .898 r
.30357 .64361 .30965 .65058 .31926 .64864 .3132 .64166 Metetra
.609 .689 .9 r
.3132 .64166 .31926 .64864 .3289 .64681 .32285 .63984 Metetra
.602 .688 .903 r
.32285 .63984 .3289 .64681 .33858 .64509 .33254 .63816 Metetra
.595 .687 .906 r
.33254 .63816 .33858 .64509 .3483 .64348 .34227 .63662 Metetra
.588 .687 .91 r
.34227 .63662 .3483 .64348 .35805 .64198 .35203 .63521 Metetra
.582 .689 .915 r
.35203 .63521 .35805 .64198 .36784 .64055 .36183 .6339 Metetra
.578 .692 .919 r
.36183 .6339 .36784 .64055 .37768 .63919 .37168 .63265 Metetra
.574 .695 .923 r
.37168 .63265 .37768 .63919 .38755 .63786 .38157 .63144 Metetra
.572 .699 .927 r
.38157 .63144 .38755 .63786 .39748 .63655 .3915 .63023 Metetra
.571 .703 .931 r
.3915 .63023 .39748 .63655 .40745 .63523 .40149 .62901 Metetra
.571 .707 .934 r
.40149 .62901 .40745 .63523 .41746 .6339 .41152 .62776 Metetra
.571 .71 .936 r
.41152 .62776 .41746 .6339 .42753 .63255 .4216 .62647 Metetra
.572 .714 .938 r
.4216 .62647 .42753 .63255 .43764 .63117 .43173 .62515 Metetra
.573 .717 .94 r
.43173 .62515 .43764 .63117 .4478 .62976 .44191 .62378 Metetra
.574 .72 .941 r
.44191 .62378 .4478 .62976 .45801 .62831 .45214 .62238 Metetra
.575 .722 .943 r
.45214 .62238 .45801 .62831 .46827 .62684 .46241 .62093 Metetra
.576 .724 .944 r
.46241 .62093 .46827 .62684 .47857 .62533 .47274 .61945 Metetra
.577 .726 .945 r
.47274 .61945 .47857 .62533 .48892 .62379 .48311 .61793 Metetra
.578 .728 .945 r
.48311 .61793 .48892 .62379 .49933 .62223 .49354 .61638 Metetra
.578 .73 .946 r
.49354 .61638 .49933 .62223 .50978 .62064 .50401 .6148 Metetra
.579 .731 .947 r
.50401 .6148 .50978 .62064 .52028 .61902 .51454 .6132 Metetra
.579 .732 .947 r
.51454 .6132 .52028 .61902 .53083 .61739 .52511 .61157 Metetra
.58 .733 .948 r
.52511 .61157 .53083 .61739 .54143 .61573 .53573 .60992 Metetra
.58 .734 .948 r
.53573 .60992 .54143 .61573 .55207 .61406 .5464 .60825 Metetra
.58 .735 .949 r
.5464 .60825 .55207 .61406 .56277 .61237 .55713 .60656 Metetra
.58 .736 .95 r
.55713 .60656 .56277 .61237 .57352 .61066 .5679 .60486 Metetra
.58 .737 .95 r
.5679 .60486 .57352 .61066 .58432 .60895 .57872 .60315 Metetra
.965 .716 .511 r
.57872 .60315 .58432 .60895 .59285 .49407 .58746 .48805 Metetra
.703 .766 .901 r
.58746 .48805 .59285 .49407 .60332 .4895 .59796 .48344 Metetra
.703 .765 .9 r
.59796 .48344 .60332 .4895 .61382 .48492 .60849 .47881 Metetra
.703 .764 .899 r
.60849 .47881 .61382 .48492 .62436 .48031 .61905 .47416 Metetra
.704 .764 .899 r
.61905 .47416 .62436 .48031 .63493 .47569 .62965 .46948 Metetra
.704 .763 .898 r
.62965 .46948 .63493 .47569 .64552 .47104 .64027 .46479 Metetra
.704 .762 .897 r
.64027 .46479 .64552 .47104 .65615 .46637 .65093 .46006 Metetra
.705 .762 .897 r
.65093 .46006 .65615 .46637 .66681 .46167 .66162 .45531 Metetra
.705 .761 .896 r
.66162 .45531 .66681 .46167 .6775 .45694 .67234 .45052 Metetra
.705 .76 .895 r
.67234 .45052 .6775 .45694 .68822 .45218 .68308 .44571 Metetra
.706 .759 .894 r
.68308 .44571 .68822 .45218 .69898 .44738 .69386 .44085 Metetra
.707 .758 .892 r
.69386 .44085 .69898 .44738 .70976 .44255 .70468 .43595 Metetra
.707 .757 .891 r
.70468 .43595 .70976 .44255 .72057 .43768 .71552 .43101 Metetra
.708 .756 .89 r
.71552 .43101 .72057 .43768 .73142 .43278 .72639 .42603 Metetra
.709 .754 .888 r
.72639 .42603 .73142 .43278 .74229 .42783 .73729 .42099 Metetra
.709 .753 .886 r
.73729 .42099 .74229 .42783 .75319 .42285 .74822 .41591 Metetra
.71 .751 .884 r
.74822 .41591 .75319 .42285 .76413 .41783 .75917 .41079 Metetra
.71 .748 .882 r
.75917 .41079 .76413 .41783 .77509 .41278 .77016 .40562 Metetra
.71 .745 .879 r
.77016 .40562 .77509 .41278 .78609 .40771 .78118 .40041 Metetra
.71 .742 .877 r
.78118 .40041 .78609 .40771 .79711 .40262 .79222 .39517 Metetra
.709 .738 .874 r
.79222 .39517 .79711 .40262 .80818 .39753 .8033 .38993 Metetra
.707 .734 .872 r
.8033 .38993 .80818 .39753 .81927 .39247 .81442 .38471 Metetra
.705 .729 .869 r
.81442 .38471 .81927 .39247 .83041 .38745 .82557 .37953 Metetra
.701 .724 .867 r
.82557 .37953 .83041 .38745 .84158 .3825 .83676 .37444 Metetra
.697 .719 .866 r
.83676 .37444 .84158 .3825 .8528 .37764 .848 .36946 Metetra
.693 .715 .866 r
.848 .36946 .8528 .37764 .86407 .37288 .85929 .3646 Metetra
.688 .711 .866 r
.85929 .3646 .86407 .37288 .87539 .36822 .87063 .35988 Metetra
.684 .709 .866 r
.87063 .35988 .87539 .36822 .88675 .36366 .88202 .35528 Metetra
.633 .697 .892 r
.25921 .64554 .26539 .65246 .27489 .65012 .26873 .64314 Metetra
.63 .695 .892 r
.26873 .64314 .27489 .65012 .28442 .64786 .27828 .64082 Metetra
.626 .693 .892 r
.27828 .64082 .28442 .64786 .29398 .64569 .28786 .63859 Metetra
.621 .69 .893 r
.28786 .63859 .29398 .64569 .30357 .64361 .29747 .63648 Metetra
.615 .687 .894 r
.29747 .63648 .30357 .64361 .3132 .64166 .30711 .6345 Metetra
.608 .685 .896 r
.30711 .6345 .3132 .64166 .32285 .63984 .31678 .63268 Metetra
.6 .682 .899 r
.31678 .63268 .32285 .63984 .33254 .63816 .32648 .63104 Metetra
.591 .681 .903 r
.32648 .63104 .33254 .63816 .34227 .63662 .33621 .62959 Metetra
.583 .681 .908 r
.33621 .62959 .34227 .63662 .35203 .63521 .34598 .6283 Metetra
.575 .683 .914 r
.34598 .6283 .35203 .63521 .36183 .6339 .35579 .62713 Metetra
.57 .686 .919 r
.35579 .62713 .36183 .6339 .37168 .63265 .36564 .62603 Metetra
.566 .691 .924 r
.36564 .62603 .37168 .63265 .38157 .63144 .37554 .62496 Metetra
.565 .696 .929 r
.37554 .62496 .38157 .63144 .3915 .63023 .38549 .62388 Metetra
.564 .701 .932 r
.38549 .62388 .3915 .63023 .40149 .62901 .39549 .62277 Metetra
.565 .705 .936 r
.39549 .62277 .40149 .62901 .41152 .62776 .40553 .6216 Metetra
.566 .71 .938 r
.40553 .6216 .41152 .62776 .4216 .62647 .41563 .62039 Metetra
.568 .713 .94 r
.41563 .62039 .4216 .62647 .43173 .62515 .42578 .61912 Metetra
.569 .717 .942 r
.42578 .61912 .43173 .62515 .44191 .62378 .43598 .6178 Metetra
.571 .72 .943 r
.43598 .6178 .44191 .62378 .45214 .62238 .44622 .61643 Metetra
.572 .722 .944 r
.44622 .61643 .45214 .62238 .46241 .62093 .45652 .61501 Metetra
.573 .725 .945 r
.45652 .61501 .46241 .62093 .47274 .61945 .46687 .61355 Metetra
.574 .726 .946 r
.46687 .61355 .47274 .61945 .48311 .61793 .47726 .61205 Metetra
.576 .728 .946 r
.47726 .61205 .48311 .61793 .49354 .61638 .48771 .61052 Metetra
.576 .73 .947 r
.48771 .61052 .49354 .61638 .50401 .6148 .49821 .60895 Metetra
.577 .731 .948 r
.49821 .60895 .50401 .6148 .51454 .6132 .50875 .60735 Metetra
.578 .732 .948 r
.50875 .60735 .51454 .6132 .52511 .61157 .51935 .60572 Metetra
.578 .733 .949 r
.51935 .60572 .52511 .61157 .53573 .60992 .52999 .60408 Metetra
.579 .734 .949 r
.52999 .60408 .53573 .60992 .5464 .60825 .54069 .60241 Metetra
.579 .735 .949 r
.54069 .60241 .5464 .60825 .55713 .60656 .55144 .60072 Metetra
.579 .736 .95 r
.55144 .60072 .55713 .60656 .5679 .60486 .56224 .59902 Metetra
.579 .737 .95 r
.56224 .59902 .5679 .60486 .57872 .60315 .57309 .5973 Metetra
.965 .716 .511 r
.57309 .5973 .57872 .60315 .58746 .48805 .58203 .48199 Metetra
.704 .766 .9 r
.58203 .48199 .58746 .48805 .59796 .48344 .59256 .47733 Metetra
.704 .765 .9 r
.59256 .47733 .59796 .48344 .60849 .47881 .60312 .47266 Metetra
.704 .765 .899 r
.60312 .47266 .60849 .47881 .61905 .47416 .61371 .46796 Metetra
.704 .764 .899 r
.61371 .46796 .61905 .47416 .62965 .46948 .62433 .46325 Metetra
.705 .764 .898 r
.62433 .46325 .62965 .46948 .64027 .46479 .63498 .4585 Metetra
.705 .763 .897 r
.63498 .4585 .64027 .46479 .65093 .46006 .64567 .45373 Metetra
.705 .762 .897 r
.64567 .45373 .65093 .46006 .66162 .45531 .65639 .44893 Metetra
.706 .762 .896 r
.65639 .44893 .66162 .45531 .67234 .45052 .66713 .44409 Metetra
.706 .761 .895 r
.66713 .44409 .67234 .45052 .68308 .44571 .67791 .43921 Metetra
.707 .76 .894 r
.67791 .43921 .68308 .44571 .69386 .44085 .68872 .4343 Metetra
.708 .76 .892 r
.68872 .4343 .69386 .44085 .70468 .43595 .69956 .42933 Metetra
.709 .759 .891 r
.69956 .42933 .70468 .43595 .71552 .43101 .71043 .42432 Metetra
.71 .757 .89 r
.71043 .42432 .71552 .43101 .72639 .42603 .72132 .41926 Metetra
.711 .756 .888 r
.72132 .41926 .72639 .42603 .73729 .42099 .73225 .41414 Metetra
.712 .755 .886 r
.73225 .41414 .73729 .42099 .74822 .41591 .74321 .40896 Metetra
.712 .753 .884 r
.74321 .40896 .74822 .41591 .75917 .41079 .75419 .40372 Metetra
.713 .75 .881 r
.75419 .40372 .75917 .41079 .77016 .40562 .7652 .39843 Metetra
.714 .747 .878 r
.7652 .39843 .77016 .40562 .78118 .40041 .77624 .39307 Metetra
.714 .744 .875 r
.77624 .39307 .78118 .40041 .79222 .39517 .7873 .38767 Metetra
.713 .74 .872 r
.7873 .38767 .79222 .39517 .8033 .38993 .7984 .38224 Metetra
.712 .734 .869 r
.7984 .38224 .8033 .38993 .81442 .38471 .80952 .37683 Metetra
.709 .729 .866 r
.80952 .37683 .81442 .38471 .82557 .37953 .82069 .37146 Metetra
.704 .722 .864 r
.82069 .37146 .82557 .37953 .83676 .37444 .8319 .3662 Metetra
.699 .717 .862 r
.8319 .3662 .83676 .37444 .848 .36946 .84315 .36108 Metetra
.694 .711 .862 r
.84315 .36108 .848 .36946 .85929 .3646 .85446 .35613 Metetra
.688 .707 .862 r
.85446 .35613 .85929 .3646 .87063 .35988 .86583 .35135 Metetra
.684 .704 .863 r
.86583 .35135 .87063 .35988 .88202 .35528 .87725 .34673 Metetra
.635 .696 .889 r
.25301 .63851 .25921 .64554 .26873 .64314 .26254 .63604 Metetra
.632 .693 .889 r
.26254 .63604 .26873 .64314 .27828 .64082 .27211 .63364 Metetra
.628 .69 .889 r
.27211 .63364 .27828 .64082 .28786 .63859 .28171 .63134 Metetra
.623 .687 .889 r
.28171 .63134 .28786 .63859 .29747 .63648 .29133 .62916 Metetra
.617 .683 .89 r
.29133 .62916 .29747 .63648 .30711 .6345 .30099 .62713 Metetra
.609 .68 .892 r
.30099 .62713 .30711 .6345 .31678 .63268 .31068 .62529 Metetra
.598 .676 .895 r
.31068 .62529 .31678 .63268 .32648 .63104 .32039 .62369 Metetra
.587 .673 .9 r
.32039 .62369 .32648 .63104 .33621 .62959 .33013 .62234 Metetra
.575 .673 .906 r
.33013 .62234 .33621 .62959 .34598 .6283 .3399 .62121 Metetra
.566 .675 .912 r
.3399 .62121 .34598 .6283 .35579 .62713 .34972 .62024 Metetra
.559 .679 .919 r
.34972 .62024 .35579 .62713 .36564 .62603 .35957 .61934 Metetra
.556 .686 .926 r
.35957 .61934 .36564 .62603 .37554 .62496 .36948 .61845 Metetra
.556 .692 .931 r
.36948 .61845 .37554 .62496 .38549 .62388 .37944 .61752 Metetra
.557 .699 .935 r
.37944 .61752 .38549 .62388 .39549 .62277 .38945 .61652 Metetra
.558 .704 .938 r
.38945 .61652 .39549 .62277 .40553 .6216 .39951 .61546 Metetra
.561 .709 .94 r
.39951 .61546 .40553 .6216 .41563 .62039 .40962 .61432 Metetra
.563 .713 .942 r
.40962 .61432 .41563 .62039 .42578 .61912 .41978 .6131 Metetra
.565 .717 .944 r
.41978 .6131 .42578 .61912 .43598 .6178 .43 .61182 Metetra
.567 .72 .945 r
.43 .61182 .43598 .6178 .44622 .61643 .44027 .61049 Metetra
.569 .723 .946 r
.44027 .61049 .44622 .61643 .45652 .61501 .45058 .60909 Metetra
.571 .725 .946 r
.45058 .60909 .45652 .61501 .46687 .61355 .46095 .60765 Metetra
.572 .727 .947 r
.46095 .60765 .46687 .61355 .47726 .61205 .47137 .60616 Metetra
.574 .729 .948 r
.47137 .60616 .47726 .61205 .48771 .61052 .48184 .60464 Metetra
.575 .73 .948 r
.48184 .60464 .48771 .61052 .49821 .60895 .49236 .60307 Metetra
.576 .731 .948 r
.49236 .60307 .49821 .60895 .50875 .60735 .50293 .60148 Metetra
.576 .733 .949 r
.50293 .60148 .50875 .60735 .51935 .60572 .51355 .59985 Metetra
.577 .734 .949 r
.51355 .59985 .51935 .60572 .52999 .60408 .52422 .5982 Metetra
.578 .734 .95 r
.52422 .5982 .52999 .60408 .54069 .60241 .53494 .59653 Metetra
.578 .735 .95 r
.53494 .59653 .54069 .60241 .55144 .60072 .54571 .59484 Metetra
.578 .736 .95 r
.54571 .59484 .55144 .60072 .56224 .59902 .55654 .59314 Metetra
.578 .737 .951 r
.55654 .59314 .56224 .59902 .57309 .5973 .56741 .59142 Metetra
.965 .716 .511 r
.56741 .59142 .57309 .5973 .58203 .48199 .57656 .47589 Metetra
.704 .766 .9 r
.57656 .47589 .58203 .48199 .59256 .47733 .58712 .47119 Metetra
.704 .766 .9 r
.58712 .47119 .59256 .47733 .60312 .47266 .5977 .46647 Metetra
.705 .765 .899 r
.5977 .46647 .60312 .47266 .61371 .46796 .60833 .46174 Metetra
.705 .765 .899 r
.60833 .46174 .61371 .46796 .62433 .46325 .61898 .45698 Metetra
.705 .764 .898 r
.61898 .45698 .62433 .46325 .63498 .4585 .62966 .45219 Metetra
.706 .764 .897 r
.62966 .45219 .63498 .4585 .64567 .45373 .64037 .44737 Metetra
.706 .763 .897 r
.64037 .44737 .64567 .45373 .65639 .44893 .65112 .44252 Metetra
.707 .763 .896 r
.65112 .44252 .65639 .44893 .66713 .44409 .6619 .43763 Metetra
.707 .762 .895 r
.6619 .43763 .66713 .44409 .67791 .43921 .6727 .4327 Metetra
.708 .762 .894 r
.6727 .4327 .67791 .43921 .68872 .4343 .68354 .42773 Metetra
.709 .761 .893 r
.68354 .42773 .68872 .4343 .69956 .42933 .69441 .42271 Metetra
.71 .76 .891 r
.69441 .42271 .69956 .42933 .71043 .42432 .7053 .41763 Metetra
.711 .759 .89 r
.7053 .41763 .71043 .42432 .72132 .41926 .71623 .41249 Metetra
.712 .758 .888 r
.71623 .41249 .72132 .41926 .73225 .41414 .72718 .40729 Metetra
.714 .757 .886 r
.72718 .40729 .73225 .41414 .74321 .40896 .73816 .40201 Metetra
.715 .755 .884 r
.73816 .40201 .74321 .40896 .75419 .40372 .74917 .39666 Metetra
.716 .753 .881 r
.74917 .39666 .75419 .40372 .7652 .39843 .7602 .39123 Metetra
.718 .75 .878 r
.7602 .39123 .7652 .39843 .77624 .39307 .77126 .38572 Metetra
.718 .746 .874 r
.77126 .38572 .77624 .39307 .7873 .38767 .78235 .38013 Metetra
.718 .742 .87 r
.78235 .38013 .7873 .38767 .7984 .38224 .79346 .37449 Metetra
.717 .736 .866 r
.79346 .37449 .7984 .38224 .80952 .37683 .80459 .36883 Metetra
.714 .729 .862 r
.80459 .36883 .80952 .37683 .82069 .37146 .81577 .36322 Metetra
.708 .721 .859 r
.81577 .36322 .82069 .37146 .8319 .3662 .82699 .35774 Metetra
.702 .713 .858 r
.82699 .35774 .8319 .3662 .84315 .36108 .83826 .35247 Metetra
.694 .707 .857 r
.83826 .35247 .84315 .36108 .85446 .35613 .84959 .34742 Metetra
.688 .702 .858 r
.84959 .34742 .85446 .35613 .86583 .35135 .86098 .3426 Metetra
.682 .699 .86 r
.86098 .3426 .86583 .35135 .87725 .34673 .87243 .33797 Metetra
.638 .695 .886 r
.24677 .63138 .25301 .63851 .26254 .63604 .25633 .62882 Metetra
.635 .692 .886 r
.25633 .62882 .26254 .63604 .27211 .63364 .26592 .62632 Metetra
.632 .689 .885 r
.26592 .62632 .27211 .63364 .28171 .63134 .27553 .62392 Metetra
.627 .684 .885 r
.27553 .62392 .28171 .63134 .29133 .62916 .28518 .62163 Metetra
.62 .68 .885 r
.28518 .62163 .29133 .62916 .30099 .62713 .29486 .61951 Metetra
.61 .674 .886 r
.29486 .61951 .30099 .62713 .31068 .62529 .30456 .61762 Metetra
.598 .669 .889 r
.30456 .61762 .31068 .62529 .32039 .62369 .31428 .61604 Metetra
.582 .663 .894 r
.31428 .61604 .32039 .62369 .33013 .62234 .32402 .61481 Metetra
.565 .661 .902 r
.32402 .61481 .33013 .62234 .3399 .62121 .3338 .61391 Metetra
.552 .664 .911 r
.3338 .61391 .3399 .62121 .34972 .62024 .34361 .61323 Metetra
.545 .671 .92 r
.34361 .61323 .34972 .62024 .35957 .61934 .35347 .61261 Metetra
.543 .68 .928 r
.35347 .61261 .35957 .61934 .36948 .61845 .36338 .61194 Metetra
.544 .689 .934 r
.36338 .61194 .36948 .61845 .37944 .61752 .37334 .61118 Metetra
.547 .697 .938 r
.37334 .61118 .37944 .61752 .38945 .61652 .38336 .61031 Metetra
.551 .704 .941 r
.38336 .61031 .38945 .61652 .39951 .61546 .39344 .60934 Metetra
.555 .709 .943 r
.39344 .60934 .39951 .61546 .40962 .61432 .40357 .60826 Metetra
.558 .714 .945 r
.40357 .60826 .40962 .61432 .41978 .6131 .41375 .6071 Metetra
.561 .718 .946 r
.41375 .6071 .41978 .6131 .43 .61182 .42398 .60586 Metetra
.564 .721 .947 r
.42398 .60586 .43 .61182 .44027 .61049 .43427 .60455 Metetra
.566 .723 .947 r
.43427 .60455 .44027 .61049 .45058 .60909 .44461 .60317 Metetra
.568 .726 .948 r
.44461 .60317 .45058 .60909 .46095 .60765 .455 .60174 Metetra
.57 .728 .948 r
.455 .60174 .46095 .60765 .47137 .60616 .46544 .60026 Metetra
.572 .729 .949 r
.46544 .60026 .47137 .60616 .48184 .60464 .47593 .59874 Metetra
.573 .731 .949 r
.47593 .59874 .48184 .60464 .49236 .60307 .48647 .59718 Metetra
.574 .732 .949 r
.48647 .59718 .49236 .60307 .50293 .60148 .49706 .59558 Metetra
.575 .733 .95 r
.49706 .59558 .50293 .60148 .51355 .59985 .50771 .59396 Metetra
.576 .734 .95 r
.50771 .59396 .51355 .59985 .52422 .5982 .5184 .5923 Metetra
.577 .735 .95 r
.5184 .5923 .52422 .5982 .53494 .59653 .52915 .59063 Metetra
.577 .735 .95 r
.52915 .59063 .53494 .59653 .54571 .59484 .53994 .58893 Metetra
.577 .736 .951 r
.53994 .58893 .54571 .59484 .55654 .59314 .55079 .58722 Metetra
.577 .736 .951 r
.55079 .58722 .55654 .59314 .56741 .59142 .5617 .58549 Metetra
.965 .716 .511 r
.5617 .58549 .56741 .59142 .57656 .47589 .57105 .46974 Metetra
.705 .766 .9 r
.57105 .46974 .57656 .47589 .58712 .47119 .58164 .46501 Metetra
.705 .766 .9 r
.58164 .46501 .58712 .47119 .5977 .46647 .59226 .46025 Metetra
.705 .766 .899 r
.59226 .46025 .5977 .46647 .60833 .46174 .60291 .45547 Metetra
.705 .765 .899 r
.60291 .45547 .60833 .46174 .61898 .45698 .61359 .45067 Metetra
.706 .765 .898 r
.61359 .45067 .61898 .45698 .62966 .45219 .6243 .44585 Metetra
.706 .764 .898 r
.6243 .44585 .62966 .45219 .64037 .44737 .63504 .44099 Metetra
.707 .764 .897 r
.63504 .44099 .64037 .44737 .65112 .44252 .64582 .43609 Metetra
.707 .764 .896 r
.64582 .43609 .65112 .44252 .6619 .43763 .65662 .43116 Metetra
.708 .763 .895 r
.65662 .43116 .6619 .43763 .6727 .4327 .66746 .42618 Metetra
.709 .763 .894 r
.66746 .42618 .6727 .4327 .68354 .42773 .67833 .42115 Metetra
.71 .762 .893 r
.67833 .42115 .68354 .42773 .69441 .42271 .68922 .41607 Metetra
.711 .762 .892 r
.68922 .41607 .69441 .42271 .7053 .41763 .70015 .41093 Metetra
.713 .761 .89 r
.70015 .41093 .7053 .41763 .71623 .41249 .7111 .40572 Metetra
.714 .76 .889 r
.7111 .40572 .71623 .41249 .72718 .40729 .72208 .40044 Metetra
.716 .759 .886 r
.72208 .40044 .72718 .40729 .73816 .40201 .73309 .39507 Metetra
.718 .758 .884 r
.73309 .39507 .73816 .40201 .74917 .39666 .74413 .38961 Metetra
.72 .756 .881 r
.74413 .38961 .74917 .39666 .7602 .39123 .75518 .38405 Metetra
.722 .753 .878 r
.75518 .38405 .7602 .39123 .77126 .38572 .76626 .37837 Metetra
.723 .75 .873 r
.76626 .37837 .77126 .38572 .78235 .38013 .77736 .37258 Metetra
.724 .745 .868 r
.77736 .37258 .78235 .38013 .79346 .37449 .78848 .36669 Metetra
.724 .739 .863 r
.78848 .36669 .79346 .37449 .80459 .36883 .79963 .36072 Metetra
.721 .73 .858 r
.79963 .36072 .80459 .36883 .81577 .36322 .8108 .35478 Metetra
.714 .719 .853 r
.8108 .35478 .81577 .36322 .82699 .35774 .82203 .34901 Metetra
.704 .709 .851 r
.82203 .34901 .82699 .35774 .83826 .35247 .83331 .34354 Metetra
.694 .7 .851 r
.83331 .34354 .83826 .35247 .84959 .34742 .84466 .33841 Metetra
.686 .695 .853 r
.84466 .33841 .84959 .34742 .86098 .3426 .85607 .33359 Metetra
.679 .693 .856 r
.85607 .33359 .86098 .3426 .87243 .33797 .86756 .32899 Metetra
.641 .694 .884 r
.2405 .62415 .24677 .63138 .25633 .62882 .25008 .62148 Metetra
.639 .691 .882 r
.25008 .62148 .25633 .62882 .26592 .62632 .25969 .61887 Metetra
.636 .687 .881 r
.25969 .61887 .26592 .62632 .27553 .62392 .26933 .61632 Metetra
.631 .683 .88 r
.26933 .61632 .27553 .62392 .28518 .62163 .279 .61388 Metetra
.625 .677 .879 r
.279 .61388 .28518 .62163 .29486 .61951 .2887 .61161 Metetra
.615 .669 .879 r
.2887 .61161 .29486 .61951 .30456 .61762 .29842 .60959 Metetra
.6 .66 .881 r
.29842 .60959 .30456 .61762 .31428 .61604 .30816 .60796 Metetra
.576 .65 .886 r
.30816 .60796 .31428 .61604 .32402 .61481 .31791 .60688 Metetra
.549 .644 .896 r
.31791 .60688 .32402 .61481 .3338 .61391 .32767 .60636 Metetra
.529 .647 .909 r
.32767 .60636 .3338 .61391 .34361 .61323 .33747 .60612 Metetra
.523 .66 .922 r
.33747 .60612 .34361 .61323 .35347 .61261 .34732 .60588 Metetra
.526 .675 .932 r
.34732 .60588 .35347 .61261 .36338 .61194 .35723 .60548 Metetra
.531 .687 .938 r
.35723 .60548 .36338 .61194 .37334 .61118 .3672 .60491 Metetra
.537 .697 .942 r
.3672 .60491 .37334 .61118 .38336 .61031 .37723 .60416 Metetra
.543 .705 .945 r
.37723 .60416 .38336 .61031 .39344 .60934 .38732 .60327 Metetra
.549 .711 .947 r
.38732 .60327 .39344 .60934 .40357 .60826 .39747 .60226 Metetra
.553 .715 .948 r
.39747 .60226 .40357 .60826 .41375 .6071 .40767 .60113 Metetra
.557 .719 .948 r
.40767 .60113 .41375 .6071 .42398 .60586 .41792 .59992 Metetra
.561 .722 .949 r
.41792 .59992 .42398 .60586 .43427 .60455 .42823 .59862 Metetra
.564 .725 .949 r
.42823 .59862 .43427 .60455 .44461 .60317 .43859 .59726 Metetra
.566 .727 .949 r
.43859 .59726 .44461 .60317 .455 .60174 .449 .59584 Metetra
.568 .728 .95 r
.449 .59584 .455 .60174 .46544 .60026 .45946 .59436 Metetra
.57 .73 .95 r
.45946 .59436 .46544 .60026 .47593 .59874 .46997 .59284 Metetra
.572 .731 .95 r
.46997 .59284 .47593 .59874 .48647 .59718 .48054 .59127 Metetra
.573 .732 .95 r
.48054 .59127 .48647 .59718 .49706 .59558 .49115 .58967 Metetra
.574 .733 .95 r
.49115 .58967 .49706 .59558 .50771 .59396 .50182 .58804 Metetra
.575 .734 .95 r
.50182 .58804 .50771 .59396 .5184 .5923 .51254 .58638 Metetra
.576 .735 .951 r
.51254 .58638 .5184 .5923 .52915 .59063 .52331 .58469 Metetra
.576 .735 .951 r
.52331 .58469 .52915 .59063 .53994 .58893 .53413 .58299 Metetra
.577 .736 .951 r
.53413 .58299 .53994 .58893 .55079 .58722 .54501 .58126 Metetra
.577 .736 .951 r
.54501 .58126 .55079 .58722 .5617 .58549 .55594 .57953 Metetra
.965 .716 .511 r
.55594 .57953 .5617 .58549 .57105 .46974 .56551 .46355 Metetra
.705 .766 .9 r
.56551 .46355 .57105 .46974 .58164 .46501 .57612 .45878 Metetra
.705 .766 .9 r
.57612 .45878 .58164 .46501 .59226 .46025 .58677 .45399 Metetra
.705 .766 .899 r
.58677 .45399 .59226 .46025 .60291 .45547 .59745 .44918 Metetra
.706 .766 .899 r
.59745 .44918 .60291 .45547 .61359 .45067 .60816 .44434 Metetra
.706 .765 .898 r
.60816 .44434 .61359 .45067 .6243 .44585 .6189 .43947 Metetra
.707 .765 .898 r
.6189 .43947 .6243 .44585 .63504 .44099 .62967 .43457 Metetra
.707 .765 .897 r
.62967 .43457 .63504 .44099 .64582 .43609 .64048 .42964 Metetra
.708 .765 .897 r
.64048 .42964 .64582 .43609 .65662 .43116 .65131 .42466 Metetra
.709 .764 .896 r
.65131 .42466 .65662 .43116 .66746 .42618 .66218 .41964 Metetra
.71 .764 .895 r
.66218 .41964 .66746 .42618 .67833 .42115 .67308 .41457 Metetra
.711 .764 .894 r
.67308 .41457 .67833 .42115 .68922 .41607 .684 .40943 Metetra
.712 .764 .893 r
.684 .40943 .68922 .41607 .70015 .41093 .69496 .40424 Metetra
.714 .763 .891 r
.69496 .40424 .70015 .41093 .7111 .40572 .70594 .39897 Metetra
.716 .763 .889 r
.70594 .39897 .7111 .40572 .72208 .40044 .71695 .39361 Metetra
.718 .762 .887 r
.71695 .39361 .72208 .40044 .73309 .39507 .72799 .38817 Metetra
.72 .761 .885 r
.72799 .38817 .73309 .39507 .74413 .38961 .73905 .38261 Metetra
.723 .76 .882 r
.73905 .38261 .74413 .38961 .75518 .38405 .75013 .37692 Metetra
.726 .758 .878 r
.75013 .37692 .75518 .38405 .76626 .37837 .76123 .37109 Metetra
.729 .755 .873 r
.76123 .37109 .76626 .37837 .77736 .37258 .77235 .36508 Metetra
.732 .751 .867 r
.77235 .36508 .77736 .37258 .78848 .36669 .78348 .35889 Metetra
.734 .744 .86 r
.78348 .35889 .78848 .36669 .79963 .36072 .79463 .35253 Metetra
.732 .733 .852 r
.79463 .35253 .79963 .36072 .8108 .35478 .80579 .34611 Metetra
.722 .718 .845 r
.80579 .34611 .8108 .35478 .82203 .34901 .817 .3399 Metetra
.707 .702 .843 r
.817 .3399 .82203 .34901 .83331 .34354 .82829 .33419 Metetra
.692 .69 .844 r
.82829 .33419 .83331 .34354 .84466 .33841 .83967 .32903 Metetra
.681 .685 .847 r
.83967 .32903 .84466 .33841 .85607 .33359 .85112 .32427 Metetra
.675 .685 .852 r
.85112 .32427 .85607 .33359 .86756 .32899 .86264 .31978 Metetra
.645 .694 .881 r
.23421 .61683 .2405 .62415 .25008 .62148 .24381 .61404 Metetra
.643 .691 .879 r
.24381 .61404 .25008 .62148 .25969 .61887 .25344 .61128 Metetra
.641 .687 .877 r
.25344 .61128 .25969 .61887 .26933 .61632 .26311 .60857 Metetra
.638 .682 .875 r
.26311 .60857 .26933 .61632 .279 .61388 .27281 .60593 Metetra
.633 .675 .872 r
.27281 .60593 .279 .61388 .2887 .61161 .28253 .60342 Metetra
.625 .666 .87 r
.28253 .60342 .2887 .61161 .29842 .60959 .29228 .60112 Metetra
.608 .653 .869 r
.29228 .60112 .29842 .60959 .30816 .60796 .30205 .59926 Metetra
.574 .634 .873 r
.30205 .59926 .30816 .60796 .31791 .60688 .31179 .59828 Metetra
.519 .612 .886 r
.31179 .59828 .31791 .60688 .32767 .60636 .32152 .59847 Metetra
.488 .62 .907 r
.32152 .59847 .32767 .60636 .33747 .60612 .33129 .59902 Metetra
.491 .648 .927 r
.33129 .59902 .33747 .60612 .34732 .60588 .34112 .59928 Metetra
.504 .671 .939 r
.34112 .59928 .34732 .60588 .35723 .60548 .35103 .59917 Metetra
.516 .688 .945 r
.35103 .59917 .35723 .60548 .3672 .60491 .36101 .59875 Metetra
.527 .699 .948 r
.36101 .59875 .3672 .60491 .37723 .60416 .37106 .59811 Metetra
.536 .707 .95 r
.37106 .59811 .37723 .60416 .38732 .60327 .38116 .59728 Metetra
.543 .713 .951 r
.38116 .59728 .38732 .60327 .39747 .60226 .39133 .59631 Metetra
.549 .717 .951 r
.39133 .59631 .39747 .60226 .40767 .60113 .40154 .59521 Metetra
.554 .721 .951 r
.40154 .59521 .40767 .60113 .41792 .59992 .41182 .59401 Metetra
.558 .724 .951 r
.41182 .59401 .41792 .59992 .42823 .59862 .42214 .59272 Metetra
.562 .726 .951 r
.42214 .59272 .42823 .59862 .43859 .59726 .43252 .59136 Metetra
.565 .728 .951 r
.43252 .59136 .43859 .59726 .449 .59584 .44296 .58994 Metetra
.567 .73 .951 r
.44296 .58994 .449 .59584 .45946 .59436 .45344 .58845 Metetra
.569 .731 .951 r
.45344 .58845 .45946 .59436 .46997 .59284 .46398 .58692 Metetra
.571 .732 .951 r
.46398 .58692 .46997 .59284 .48054 .59127 .47456 .58535 Metetra
.572 .733 .951 r
.47456 .58535 .48054 .59127 .49115 .58967 .4852 .58374 Metetra
.573 .734 .951 r
.4852 .58374 .49115 .58967 .50182 .58804 .4959 .58209 Metetra
.574 .735 .951 r
.4959 .58209 .50182 .58804 .51254 .58638 .50664 .58042 Metetra
.575 .735 .951 r
.50664 .58042 .51254 .58638 .52331 .58469 .51743 .57872 Metetra
.576 .736 .951 r
.51743 .57872 .52331 .58469 .53413 .58299 .52828 .577 Metetra
.576 .736 .951 r
.52828 .577 .53413 .58299 .54501 .58126 .53918 .57527 Metetra
.576 .736 .951 r
.53918 .57527 .54501 .58126 .55594 .57953 .55014 .57352 Metetra
.965 .716 .511 r
.55014 .57352 .55594 .57953 .56551 .46355 .55992 .45732 Metetra
.705 .767 .9 r
.55992 .45732 .56551 .46355 .57612 .45878 .57057 .45252 Metetra
.705 .766 .9 r
.57057 .45252 .57612 .45878 .58677 .45399 .58124 .4477 Metetra
.706 .766 .899 r
.58124 .4477 .58677 .45399 .59745 .44918 .59195 .44285 Metetra
.706 .766 .899 r
.59195 .44285 .59745 .44918 .60816 .44434 .60269 .43798 Metetra
.706 .766 .899 r
.60269 .43798 .60816 .44434 .6189 .43947 .61346 .43308 Metetra
.707 .766 .898 r
.61346 .43308 .6189 .43947 .62967 .43457 .62427 .42814 Metetra
.708 .766 .898 r
.62427 .42814 .62967 .43457 .64048 .42964 .6351 .42317 Metetra
.708 .766 .897 r
.6351 .42317 .64048 .42964 .65131 .42466 .64597 .41815 Metetra
.709 .766 .896 r
.64597 .41815 .65131 .42466 .66218 .41964 .65686 .41309 Metetra
.71 .766 .895 r
.65686 .41309 .66218 .41964 .67308 .41457 .66779 .40798 Metetra
.712 .766 .895 r
.66779 .40798 .67308 .41457 .684 .40943 .67875 .4028 Metetra
.713 .765 .893 r
.67875 .4028 .684 .40943 .69496 .40424 .68973 .39756 Metetra
.715 .765 .892 r
.68973 .39756 .69496 .40424 .70594 .39897 .70075 .39223 Metetra
.717 .765 .891 r
.70075 .39223 .70594 .39897 .71695 .39361 .71179 .38682 Metetra
.719 .765 .889 r
.71179 .38682 .71695 .39361 .72799 .38817 .72286 .3813 Metetra
.722 .765 .886 r
.72286 .3813 .72799 .38817 .73905 .38261 .73395 .37566 Metetra
.726 .764 .883 r
.73395 .37566 .73905 .38261 .75013 .37692 .74506 .36987 Metetra
.73 .763 .88 r
.74506 .36987 .75013 .37692 .76123 .37109 .75618 .3639 Metetra
.734 .761 .874 r
.75618 .3639 .76123 .37109 .77235 .36508 .76732 .3577 Metetra
.74 .758 .868 r
.76732 .3577 .77235 .36508 .78348 .35889 .77846 .35122 Metetra
.746 .753 .858 r
.77846 .35122 .78348 .35889 .79463 .35253 .7896 .34437 Metetra
.749 .741 .845 r
.7896 .34437 .79463 .35253 .80579 .34611 .80073 .33717 Metetra
.738 .719 .833 r
.80073 .33717 .80579 .34611 .817 .3399 .8119 .33015 Metetra
.708 .689 .83 r
.8119 .33015 .817 .3399 .82829 .33419 .82319 .32419 Metetra
.684 .673 .834 r
.82319 .32419 .82829 .33419 .83967 .32903 .8346 .31918 Metetra
.673 .672 .841 r
.8346 .31918 .83967 .32903 .85112 .32427 .84611 .31464 Metetra
.668 .675 .848 r
.84611 .31464 .85112 .32427 .86264 .31978 .85767 .31033 Metetra
.649 .695 .879 r
.22787 .60944 .23421 .61683 .24381 .61404 .2375 .60652 Metetra
.648 .691 .877 r
.2375 .60652 .24381 .61404 .25344 .61128 .24716 .60361 Metetra
.647 .687 .874 r
.24716 .60361 .25344 .61128 .26311 .60857 .25685 .6007 Metetra
.646 .682 .87 r
.25685 .6007 .26311 .60857 .27281 .60593 .26658 .59781 Metetra
.643 .675 .865 r
.26658 .59781 .27281 .60593 .28253 .60342 .27635 .59496 Metetra
.639 .666 .86 r
.27635 .59496 .28253 .60342 .29228 .60112 .28614 .5922 Metetra
.631 .652 .853 r
.28614 .5922 .29228 .60112 .30205 .59926 .29596 .58967 Metetra
.597 .623 .848 r
.29596 .58967 .30205 .59926 .31179 .59828 .30575 .5881 Metetra
.431 .529 .857 r
.30575 .5881 .31179 .59828 .32152 .59847 .31535 .59034 Metetra
.401 .571 .905 r
.31535 .59034 .32152 .59847 .33129 .59902 .32504 .59228 Metetra
.447 .642 .94 r
.32504 .59228 .33129 .59902 .34112 .59928 .33486 .59301 Metetra
.48 .675 .95 r
.33486 .59301 .34112 .59928 .35103 .59917 .34478 .5931 Metetra
.502 .693 .954 r
.34478 .5931 .35103 .59917 .36101 .59875 .35477 .59279 Metetra
.518 .704 .955 r
.35477 .59279 .36101 .59875 .37106 .59811 .36483 .5922 Metetra
.53 .711 .955 r
.36483 .5922 .37106 .59811 .38116 .59728 .37495 .5914 Metetra
.539 .716 .955 r
.37495 .5914 .38116 .59728 .39133 .59631 .38514 .59043 Metetra
.546 .72 .954 r
.38514 .59043 .39133 .59631 .40154 .59521 .39537 .58934 Metetra
.551 .723 .954 r
.39537 .58934 .40154 .59521 .41182 .59401 .40567 .58814 Metetra
.556 .726 .953 r
.40567 .58814 .41182 .59401 .42214 .59272 .41601 .58685 Metetra
.56 .728 .953 r
.41601 .58685 .42214 .59272 .43252 .59136 .42642 .58548 Metetra
.563 .73 .953 r
.42642 .58548 .43252 .59136 .44296 .58994 .43687 .58404 Metetra
.566 .731 .952 r
.43687 .58404 .44296 .58994 .45344 .58845 .44738 .58255 Metetra
.568 .732 .952 r
.44738 .58255 .45344 .58845 .46398 .58692 .45793 .581 Metetra
.57 .733 .952 r
.45793 .581 .46398 .58692 .47456 .58535 .46855 .57942 Metetra
.572 .734 .952 r
.46855 .57942 .47456 .58535 .4852 .58374 .47921 .57779 Metetra
.573 .735 .952 r
.47921 .57779 .4852 .58374 .4959 .58209 .48993 .57613 Metetra
.574 .735 .952 r
.48993 .57613 .4959 .58209 .50664 .58042 .50069 .57444 Metetra
.575 .736 .952 r
.50069 .57444 .50664 .58042 .51743 .57872 .51151 .57272 Metetra
.575 .736 .952 r
.51151 .57272 .51743 .57872 .52828 .577 .52239 .57099 Metetra
.576 .736 .952 r
.52239 .57099 .52828 .577 .53918 .57527 .53331 .56924 Metetra
.576 .737 .952 r
.53331 .56924 .53918 .57527 .55014 .57352 .54429 .56747 Metetra
.965 .716 .511 r
.54429 .56747 .55014 .57352 .55992 .45732 .5543 .45105 Metetra
.705 .767 .9 r
.5543 .45105 .55992 .45732 .57057 .45252 .56497 .44622 Metetra
.706 .767 .9 r
.56497 .44622 .57057 .45252 .58124 .4477 .57568 .44136 Metetra
.706 .766 .899 r
.57568 .44136 .58124 .4477 .59195 .44285 .58642 .43649 Metetra
.706 .766 .899 r
.58642 .43649 .59195 .44285 .60269 .43798 .59719 .43158 Metetra
.707 .766 .899 r
.59719 .43158 .60269 .43798 .61346 .43308 .60799 .42665 Metetra
.707 .767 .899 r
.60799 .42665 .61346 .43308 .62427 .42814 .61882 .42168 Metetra
.708 .767 .898 r
.61882 .42168 .62427 .42814 .6351 .42317 .62969 .41668 Metetra
.709 .767 .898 r
.62969 .41668 .6351 .42317 .64597 .41815 .64058 .41163 Metetra
.71 .767 .897 r
.64058 .41163 .64597 .41815 .65686 .41309 .65151 .40654 Metetra
.711 .767 .896 r
.65151 .40654 .65686 .41309 .66779 .40798 .66247 .40139 Metetra
.712 .767 .895 r
.66247 .40139 .66779 .40798 .67875 .4028 .67346 .39617 Metetra
.714 .767 .894 r
.67346 .39617 .67875 .4028 .68973 .39756 .68448 .39089 Metetra
.716 .768 .893 r
.68448 .39089 .68973 .39756 .70075 .39223 .69552 .38553 Metetra
.718 .768 .892 r
.69552 .38553 .70075 .39223 .71179 .38682 .7066 .38007 Metetra
.721 .768 .89 r
.7066 .38007 .71179 .38682 .72286 .3813 .71769 .3745 Metetra
.724 .769 .888 r
.71769 .3745 .72286 .3813 .73395 .37566 .72881 .3688 Metetra
.728 .769 .886 r
.72881 .3688 .73395 .37566 .74506 .36987 .73995 .36294 Metetra
.732 .769 .882 r
.73995 .36294 .74506 .36987 .75618 .3639 .75111 .35688 Metetra
.739 .769 .878 r
.75111 .35688 .75618 .3639 .76732 .3577 .76228 .35055 Metetra
.747 .769 .871 r
.76228 .35055 .76732 .3577 .77846 .35122 .77344 .34384 Metetra
.759 .767 .86 r
.77344 .34384 .77846 .35122 .7896 .34437 .78458 .33656 Metetra
.777 .761 .839 r
.78458 .33656 .7896 .34437 .80073 .33717 .79564 .3282 Metetra
.782 .735 .81 r
.79564 .3282 .80073 .33717 .8119 .33015 .80664 .31887 Metetra
.69 .651 .807 r
.80664 .31887 .8119 .33015 .82319 .32419 .81797 .3132 Metetra
.663 .644 .821 r
.81797 .3132 .82319 .32419 .8346 .31918 .82947 .30882 Metetra
.659 .656 .836 r
.82947 .30882 .8346 .31918 .84611 .31464 .84104 .30471 Metetra
.658 .665 .846 r
.84104 .30471 .84611 .31464 .85767 .31033 .85267 .3007 Metetra
.653 .695 .877 r
.2215 .602 .22787 .60944 .2375 .60652 .23116 .59895 Metetra
.653 .692 .874 r
.23116 .59895 .2375 .60652 .24716 .60361 .24084 .59587 Metetra
.653 .689 .871 r
.24084 .59587 .24716 .60361 .25685 .6007 .25057 .59275 Metetra
.654 .684 .866 r
.25057 .59275 .25685 .6007 .26658 .59781 .26033 .5896 Metetra
.655 .678 .86 r
.26033 .5896 .26658 .59781 .27635 .59496 .27014 .58638 Metetra
.656 .67 .851 r
.27014 .58638 .27635 .59496 .28614 .5922 .27998 .58305 Metetra
.661 .659 .838 r
.27998 .58305 .28614 .5922 .29596 .58967 .28988 .57947 Metetra
.679 .646 .81 r
.28988 .57947 .29596 .58967 .30575 .5881 .29988 .57491 Metetra
.722 .622 .745 r
.29988 .57491 .30575 .5881 .31535 .59034 .31014 .56655 Metetra
.663 .518 .677 r
.31014 .56655 .31535 .59034 .32504 .59228 .32039 .55848 Metetra
.624 .462 .642 r
.32039 .55848 .32504 .59228 .33486 .59301 .33059 .55161 Metetra
.607 .436 .624 r
.33059 .55161 .33486 .59301 .34478 .5931 .34076 .54536 Metetra
.597 .42 .613 r
.34076 .54536 .34478 .5931 .35477 .59279 .35093 .53949 Metetra
.59 .41 .605 r
.35093 .53949 .35477 .59279 .36483 .5922 .36112 .53388 Metetra
.585 .402 .6 r
.36112 .53388 .36483 .5922 .37495 .5914 .37131 .52845 Metetra
.582 .396 .595 r
.37131 .52845 .37495 .5914 .38514 .59043 .38153 .52316 Metetra
.579 .391 .591 r
.38153 .52316 .38514 .59043 .39537 .58934 .39177 .51798 Metetra
.576 .387 .588 r
.39177 .51798 .39537 .58934 .40567 .58814 .40203 .51289 Metetra
.574 .384 .585 r
.40203 .51289 .40567 .58814 .41601 .58685 .41231 .50786 Metetra
.573 .381 .583 r
.41231 .50786 .41601 .58685 .42642 .58548 .42262 .50289 Metetra
.571 .378 .581 r
.42262 .50289 .42642 .58548 .43687 .58404 .43296 .49796 Metetra
.57 .376 .579 r
.43296 .49796 .43687 .58404 .44738 .58255 .44332 .49306 Metetra
.569 .374 .577 r
.44332 .49306 .44738 .58255 .45793 .581 .45372 .48819 Metetra
.568 .372 .575 r
.45372 .48819 .45793 .581 .46855 .57942 .46414 .48334 Metetra
.567 .37 .574 r
.46414 .48334 .46855 .57942 .47921 .57779 .47459 .47851 Metetra
.566 .369 .573 r
.47459 .47851 .47921 .57779 .48993 .57613 .48508 .47369 Metetra
.566 .368 .571 r
.48508 .47369 .48993 .57613 .50069 .57444 .49559 .46887 Metetra
.565 .366 .57 r
.49559 .46887 .50069 .57444 .51151 .57272 .50614 .46405 Metetra
.564 .365 .569 r
.50614 .46405 .51151 .57272 .52239 .57099 .51671 .45924 Metetra
.564 .364 .568 r
.51671 .45924 .52239 .57099 .53331 .56924 .52732 .45441 Metetra
.563 .363 .567 r
.52732 .45441 .53331 .56924 .54429 .56747 .53796 .44958 Metetra
.766 .518 .56 r
.53796 .44958 .54429 .56747 .5543 .45105 .54787 .33962 Metetra
.555 .357 .567 r
.54787 .33962 .5543 .45105 .56497 .44622 .55825 .33742 Metetra
.555 .357 .568 r
.55825 .33742 .56497 .44622 .57568 .44136 .56869 .33522 Metetra
.556 .358 .569 r
.56869 .33522 .57568 .44136 .58642 .43649 .57917 .33302 Metetra
.556 .359 .57 r
.57917 .33302 .58642 .43649 .59719 .43158 .5897 .33082 Metetra
.556 .36 .571 r
.5897 .33082 .59719 .43158 .60799 .42665 .60028 .32862 Metetra
.556 .361 .572 r
.60028 .32862 .60799 .42665 .61882 .42168 .61091 .32643 Metetra
.557 .362 .573 r
.61091 .32643 .61882 .42168 .62969 .41668 .62159 .32425 Metetra
.557 .363 .574 r
.62159 .32425 .62969 .41668 .64058 .41163 .63233 .32208 Metetra
.557 .365 .576 r
.63233 .32208 .64058 .41163 .65151 .40654 .64311 .31994 Metetra
.558 .366 .577 r
.64311 .31994 .65151 .40654 .66247 .40139 .65395 .31783 Metetra
.558 .367 .579 r
.65395 .31783 .66247 .40139 .67346 .39617 .66484 .31575 Metetra
.558 .369 .581 r
.66484 .31575 .67346 .39617 .68448 .39089 .67579 .31371 Metetra
.559 .371 .583 r
.67579 .31371 .68448 .39089 .69552 .38553 .6868 .31173 Metetra
.559 .373 .585 r
.6868 .31173 .69552 .38553 .7066 .38007 .69786 .30981 Metetra
.559 .375 .588 r
.69786 .30981 .7066 .38007 .71769 .3745 .70898 .30798 Metetra
.559 .377 .591 r
.70898 .30798 .71769 .3745 .72881 .3688 .72017 .30625 Metetra
.56 .38 .595 r
.72017 .30625 .72881 .3688 .73995 .36294 .73143 .30465 Metetra
.56 .384 .6 r
.73143 .30465 .73995 .36294 .75111 .35688 .74276 .30322 Metetra
.559 .388 .605 r
.74276 .30322 .75111 .35688 .76228 .35055 .75416 .30203 Metetra
.558 .393 .613 r
.75416 .30203 .76228 .35055 .77344 .34384 .76566 .30119 Metetra
.555 .399 .624 r
.76566 .30119 .77344 .34384 .78458 .33656 .77727 .3009 Metetra
.547 .407 .642 r
.77727 .3009 .78458 .33656 .79564 .3282 .78904 .30165 Metetra
.532 .426 .679 r
.78904 .30165 .79564 .3282 .80664 .31887 .80098 .30337 Metetra
.594 .541 .765 r
.80098 .30337 .80664 .31887 .81797 .3132 .81267 .30144 Metetra
.632 .615 .816 r
.81267 .30144 .81797 .3132 .82947 .30882 .82429 .29819 Metetra
.643 .643 .835 r
.82429 .29819 .82947 .30882 .84104 .30471 .83594 .29464 Metetra
.648 .658 .846 r
.83594 .29464 .84104 .30471 .85267 .3007 .84762 .29096 Metetra
.656 .697 .876 r
.2151 .59453 .2215 .602 .23116 .59895 .22478 .59134 Metetra
.657 .694 .873 r
.22478 .59134 .23116 .59895 .24084 .59587 .23449 .5881 Metetra
.659 .691 .869 r
.23449 .5881 .24084 .59587 .25057 .59275 .24425 .58479 Metetra
.661 .687 .864 r
.24425 .58479 .25057 .59275 .26033 .5896 .25404 .58139 Metetra
.664 .682 .857 r
.25404 .58139 .26033 .5896 .27014 .58638 .26388 .57784 Metetra
.669 .677 .848 r
.26388 .57784 .27014 .58638 .27998 .58305 .27378 .57404 Metetra
.679 .67 .834 r
.27378 .57404 .27998 .58305 .28988 .57947 .28374 .56979 Metetra
.695 .663 .814 r
.28374 .56979 .28988 .57947 .29988 .57491 .29378 .56465 Metetra
.714 .659 .794 r
.29378 .56465 .29988 .57491 .31014 .56655 .30393 .55832 Metetra
.739 .707 .822 r
.30393 .55832 .31014 .56655 .32039 .55848 .31413 .55162 Metetra
.745 .743 .849 r
.31413 .55162 .32039 .55848 .33059 .55161 .32432 .54521 Metetra
.742 .756 .864 r
.32432 .54521 .33059 .55161 .34076 .54536 .33451 .53915 Metetra
.736 .761 .873 r
.33451 .53915 .34076 .54536 .35093 .53949 .3447 .53336 Metetra
.731 .764 .879 r
.3447 .53336 .35093 .53949 .36112 .53388 .35491 .52779 Metetra
.727 .765 .883 r
.35491 .52779 .36112 .53388 .37131 .52845 .36513 .52238 Metetra
.724 .766 .886 r
.36513 .52238 .37131 .52845 .38153 .52316 .37537 .5171 Metetra
.721 .766 .889 r
.37537 .5171 .38153 .52316 .39177 .51798 .38564 .51192 Metetra
.718 .766 .891 r
.38564 .51192 .39177 .51798 .40203 .51289 .39592 .50681 Metetra
.716 .766 .892 r
.39592 .50681 .40203 .51289 .41231 .50786 .40623 .50177 Metetra
.714 .766 .894 r
.40623 .50177 .41231 .50786 .42262 .50289 .41657 .49678 Metetra
.712 .766 .895 r
.41657 .49678 .42262 .50289 .43296 .49796 .42694 .49184 Metetra
.711 .766 .896 r
.42694 .49184 .43296 .49796 .44332 .49306 .43733 .48692 Metetra
.71 .766 .897 r
.43733 .48692 .44332 .49306 .45372 .48819 .44775 .48203 Metetra
.709 .766 .897 r
.44775 .48203 .45372 .48819 .46414 .48334 .4582 .47716 Metetra
.708 .766 .898 r
.4582 .47716 .46414 .48334 .47459 .47851 .46869 .47231 Metetra
.707 .766 .898 r
.46869 .47231 .47459 .47851 .48508 .47369 .4792 .46746 Metetra
.707 .766 .899 r
.4792 .46746 .48508 .47369 .49559 .46887 .48974 .46262 Metetra
.706 .766 .899 r
.48974 .46262 .49559 .46887 .50614 .46405 .50031 .45779 Metetra
.706 .766 .899 r
.50031 .45779 .50614 .46405 .51671 .45924 .51092 .45295 Metetra
.705 .766 .9 r
.51092 .45295 .51671 .45924 .52732 .45441 .52156 .4481 Metetra
.705 .766 .9 r
.52156 .4481 .52732 .45441 .53796 .44958 .53223 .44324 Metetra
.964 .716 .513 r
.53223 .44324 .53796 .44958 .54787 .33962 .54234 .3331 Metetra
.609 .721 .925 r
.54234 .3331 .54787 .33962 .55825 .33742 .55275 .33088 Metetra
.609 .721 .925 r
.55275 .33088 .55825 .33742 .56869 .33522 .56321 .32865 Metetra
.608 .721 .925 r
.56321 .32865 .56869 .33522 .57917 .33302 .57372 .32642 Metetra
.608 .721 .925 r
.57372 .32642 .57917 .33302 .5897 .33082 .58427 .32419 Metetra
.607 .72 .925 r
.58427 .32419 .5897 .33082 .60028 .32862 .59488 .32196 Metetra
.606 .72 .925 r
.59488 .32196 .60028 .32862 .61091 .32643 .60553 .31974 Metetra
.606 .719 .925 r
.60553 .31974 .61091 .32643 .62159 .32425 .61624 .31754 Metetra
.604 .719 .925 r
.61624 .31754 .62159 .32425 .63233 .32208 .627 .31535 Metetra
.603 .718 .925 r
.627 .31535 .63233 .32208 .64311 .31994 .63781 .31317 Metetra
.601 .717 .926 r
.63781 .31317 .64311 .31994 .65395 .31783 .64867 .31103 Metetra
.6 .716 .926 r
.64867 .31103 .65395 .31783 .66484 .31575 .65959 .30892 Metetra
.597 .715 .926 r
.65959 .30892 .66484 .31575 .67579 .31371 .67056 .30685 Metetra
.595 .713 .926 r
.67056 .30685 .67579 .31371 .6868 .31173 .68159 .30483 Metetra
.592 .711 .927 r
.68159 .30483 .6868 .31173 .69786 .30981 .69268 .30287 Metetra
.588 .709 .927 r
.69268 .30287 .69786 .30981 .70898 .30798 .70383 .30099 Metetra
.583 .707 .927 r
.70383 .30099 .70898 .30798 .72017 .30625 .71504 .29921 Metetra
.578 .703 .928 r
.71504 .29921 .72017 .30625 .73143 .30465 .72632 .29754 Metetra
.571 .698 .928 r
.72632 .29754 .73143 .30465 .74276 .30322 .73767 .29603 Metetra
.562 .692 .928 r
.73767 .29603 .74276 .30322 .75416 .30203 .7491 .29472 Metetra
.551 .683 .927 r
.7491 .29472 .75416 .30203 .76566 .30119 .76061 .29367 Metetra
.537 .67 .923 r
.76061 .29367 .76566 .30119 .77727 .3009 .77221 .29296 Metetra
.527 .652 .914 r
.77221 .29296 .77727 .3009 .78904 .30165 .78391 .29257 Metetra
.546 .63 .886 r
.78391 .29257 .78904 .30165 .80098 .30337 .79567 .29199 Metetra
.589 .601 .831 r
.79567 .29199 .80098 .30337 .81267 .30144 .8074 .29034 Metetra
.616 .621 .833 r
.8074 .29034 .81267 .30144 .82429 .29819 .81911 .28772 Metetra
.631 .642 .843 r
.81911 .28772 .82429 .29819 .83594 .29464 .83082 .2846 Metetra
.639 .656 .851 r
.83082 .2846 .83594 .29464 .84762 .29096 .84256 .28121 Metetra
.66 .699 .875 r
.20865 .58704 .2151 .59453 .22478 .59134 .21836 .58373 Metetra
.662 .697 .872 r
.21836 .58373 .22478 .59134 .23449 .5881 .2281 .58035 Metetra
.664 .694 .868 r
.2281 .58035 .23449 .5881 .24425 .58479 .23788 .57687 Metetra
.667 .691 .863 r
.23788 .57687 .24425 .58479 .25404 .58139 .24771 .57326 Metetra
.671 .688 .857 r
.24771 .57326 .25404 .58139 .26388 .57784 .25758 .56947 Metetra
.678 .685 .849 r
.25758 .56947 .26388 .57784 .27378 .57404 .26751 .5654 Metetra
.687 .682 .84 r
.26751 .5654 .27378 .57404 .28374 .56979 .2775 .56092 Metetra
.699 .681 .829 r
.2775 .56092 .28374 .56979 .29378 .56465 .28756 .55587 Metetra
.712 .688 .825 r
.28756 .55587 .29378 .56465 .30393 .55832 .29768 .55024 Metetra
.724 .708 .834 r
.29768 .55024 .30393 .55832 .31413 .55162 .30785 .54432 Metetra
.731 .729 .849 r
.30785 .54432 .31413 .55162 .32432 .54521 .31803 .53839 Metetra
.731 .743 .861 r
.31803 .53839 .32432 .54521 .33451 .53915 .32823 .5326 Metetra
.729 .751 .87 r
.32823 .5326 .33451 .53915 .3447 .53336 .33844 .52698 Metetra
.727 .756 .876 r
.33844 .52698 .3447 .53336 .35491 .52779 .34867 .52149 Metetra
.724 .759 .881 r
.34867 .52149 .35491 .52779 .36513 .52238 .35891 .51614 Metetra
.721 .761 .884 r
.35891 .51614 .36513 .52238 .37537 .5171 .36918 .51088 Metetra
.719 .762 .887 r
.36918 .51088 .37537 .5171 .38564 .51192 .37947 .50571 Metetra
.716 .763 .889 r
.37947 .50571 .38564 .51192 .39592 .50681 .38978 .50062 Metetra
.715 .764 .891 r
.38978 .50062 .39592 .50681 .40623 .50177 .40012 .49558 Metetra
.713 .764 .893 r
.40012 .49558 .40623 .50177 .41657 .49678 .41048 .49058 Metetra
.711 .764 .894 r
.41048 .49058 .41657 .49678 .42694 .49184 .42088 .48562 Metetra
.71 .765 .895 r
.42088 .48562 .42694 .49184 .43733 .48692 .4313 .4807 Metetra
.709 .765 .896 r
.4313 .4807 .43733 .48692 .44775 .48203 .44175 .4758 Metetra
.708 .765 .897 r
.44175 .4758 .44775 .48203 .4582 .47716 .45223 .47091 Metetra
.707 .765 .897 r
.45223 .47091 .4582 .47716 .46869 .47231 .46273 .46604 Metetra
.707 .765 .898 r
.46273 .46604 .46869 .47231 .4792 .46746 .47328 .46118 Metetra
.706 .766 .898 r
.47328 .46118 .4792 .46746 .48974 .46262 .48385 .45632 Metetra
.706 .766 .899 r
.48385 .45632 .48974 .46262 .50031 .45779 .49445 .45146 Metetra
.705 .766 .899 r
.49445 .45146 .50031 .45779 .51092 .45295 .50508 .4466 Metetra
.705 .766 .899 r
.50508 .4466 .51092 .45295 .52156 .4481 .51575 .44173 Metetra
.705 .766 .9 r
.51575 .44173 .52156 .4481 .53223 .44324 .52645 .43686 Metetra
.964 .716 .513 r
.52645 .43686 .53223 .44324 .54234 .3331 .53678 .32653 Metetra
.609 .721 .925 r
.53678 .32653 .54234 .3331 .55275 .33088 .54721 .32428 Metetra
.609 .721 .925 r
.54721 .32428 .55275 .33088 .56321 .32865 .5577 .32202 Metetra
.609 .721 .925 r
.5577 .32202 .56321 .32865 .57372 .32642 .56823 .31976 Metetra
.608 .72 .924 r
.56823 .31976 .57372 .32642 .58427 .32419 .57881 .3175 Metetra
.608 .72 .924 r
.57881 .3175 .58427 .32419 .59488 .32196 .58944 .31524 Metetra
.607 .719 .924 r
.58944 .31524 .59488 .32196 .60553 .31974 .60011 .31299 Metetra
.606 .719 .924 r
.60011 .31299 .60553 .31974 .61624 .31754 .61085 .31075 Metetra
.605 .718 .924 r
.61085 .31075 .61624 .31754 .627 .31535 .62163 .30853 Metetra
.604 .717 .925 r
.62163 .30853 .627 .31535 .63781 .31317 .63246 .30632 Metetra
.602 .716 .925 r
.63246 .30632 .63781 .31317 .64867 .31103 .64335 .30414 Metetra
.601 .715 .925 r
.64335 .30414 .64867 .31103 .65959 .30892 .65429 .30199 Metetra
.599 .713 .925 r
.65429 .30199 .65959 .30892 .67056 .30685 .66529 .29988 Metetra
.596 .712 .925 r
.66529 .29988 .67056 .30685 .68159 .30483 .67635 .29781 Metetra
.593 .71 .925 r
.67635 .29781 .68159 .30483 .69268 .30287 .68746 .2958 Metetra
.59 .707 .924 r
.68746 .2958 .69268 .30287 .70383 .30099 .69864 .29385 Metetra
.587 .704 .924 r
.69864 .29385 .70383 .30099 .71504 .29921 .70987 .29199 Metetra
.582 .701 .924 r
.70987 .29199 .71504 .29921 .72632 .29754 .72117 .29023 Metetra
.577 .696 .923 r
.72117 .29023 .72632 .29754 .73767 .29603 .73254 .28859 Metetra
.571 .69 .921 r
.73254 .28859 .73767 .29603 .7491 .29472 .74399 .28709 Metetra
.565 .682 .918 r
.74399 .28709 .7491 .29472 .76061 .29367 .7555 .28576 Metetra
.561 .671 .912 r
.7555 .28576 .76061 .29367 .77221 .29296 .76709 .28457 Metetra
.563 .658 .901 r
.76709 .28457 .77221 .29296 .78391 .29257 .77875 .28341 Metetra
.575 .644 .881 r
.77875 .28341 .78391 .29257 .79567 .29199 .79046 .28203 Metetra
.595 .635 .861 r
.79046 .28203 .79567 .29199 .8074 .29034 .80219 .28013 Metetra
.612 .639 .853 r
.80219 .28013 .8074 .29034 .81911 .28772 .81393 .27765 Metetra
.625 .649 .854 r
.81393 .27765 .81911 .28772 .83082 .2846 .82569 .27475 Metetra
.634 .659 .857 r
.82569 .27475 .83082 .2846 .84256 .28121 .83747 .27155 Metetra
.663 .701 .875 r
.20217 .57956 .20865 .58704 .21836 .58373 .21189 .57614 Metetra
.665 .699 .872 r
.21189 .57614 .21836 .58373 .2281 .58035 .22166 .57263 Metetra
.668 .697 .868 r
.22166 .57263 .2281 .58035 .23788 .57687 .23147 .56901 Metetra
.671 .695 .864 r
.23147 .56901 .23788 .57687 .24771 .57326 .24133 .56525 Metetra
.676 .694 .859 r
.24133 .56525 .24771 .57326 .25758 .56947 .25123 .5613 Metetra
.682 .692 .853 r
.25123 .5613 .25758 .56947 .26751 .5654 .26118 .5571 Metetra
.69 .692 .847 r
.26118 .5571 .26751 .5654 .2775 .56092 .27119 .55257 Metetra
.699 .694 .842 r
.27119 .55257 .2775 .56092 .28756 .55587 .28126 .54767 Metetra
.708 .701 .841 r
.28126 .54767 .28756 .55587 .29768 .55024 .29137 .54241 Metetra
.716 .712 .846 r
.29137 .54241 .29768 .55024 .30785 .54432 .30153 .53693 Metetra
.721 .726 .854 r
.30153 .53693 .30785 .54432 .31803 .53839 .31171 .53137 Metetra
.723 .737 .862 r
.31171 .53137 .31803 .53839 .32823 .5326 .32192 .52584 Metetra
.723 .745 .869 r
.32192 .52584 .32823 .5326 .33844 .52698 .33215 .52038 Metetra
.722 .75 .875 r
.33215 .52038 .33844 .52698 .34867 .52149 .34239 .51501 Metetra
.72 .754 .879 r
.34239 .51501 .34867 .52149 .35891 .51614 .35266 .50973 Metetra
.718 .757 .883 r
.35266 .50973 .35891 .51614 .36918 .51088 .36295 .50452 Metetra
.716 .759 .886 r
.36295 .50452 .36918 .51088 .37947 .50571 .37326 .49939 Metetra
.715 .76 .888 r
.37326 .49939 .37947 .50571 .38978 .50062 .3836 .49431 Metetra
.713 .761 .89 r
.3836 .49431 .38978 .50062 .40012 .49558 .39396 .48928 Metetra
.712 .762 .892 r
.39396 .48928 .40012 .49558 .41048 .49058 .40435 .48428 Metetra
.71 .763 .893 r
.40435 .48428 .41048 .49058 .42088 .48562 .41477 .47933 Metetra
.709 .763 .894 r
.41477 .47933 .42088 .48562 .4313 .4807 .42522 .47439 Metetra
.708 .764 .895 r
.42522 .47439 .4313 .4807 .44175 .4758 .4357 .46948 Metetra
.708 .764 .896 r
.4357 .46948 .44175 .4758 .45223 .47091 .44621 .46459 Metetra
.707 .764 .897 r
.44621 .46459 .45223 .47091 .46273 .46604 .45674 .45971 Metetra
.706 .765 .898 r
.45674 .45971 .46273 .46604 .47328 .46118 .46731 .45483 Metetra
.706 .765 .898 r
.46731 .45483 .47328 .46118 .48385 .45632 .47791 .44995 Metetra
.705 .765 .899 r
.47791 .44995 .48385 .45632 .49445 .45146 .48854 .44508 Metetra
.705 .765 .899 r
.48854 .44508 .49445 .45146 .50508 .4466 .49921 .4402 Metetra
.705 .766 .899 r
.49921 .4402 .50508 .4466 .51575 .44173 .5099 .43532 Metetra
.705 .766 .9 r
.5099 .43532 .51575 .44173 .52645 .43686 .52063 .43042 Metetra
.964 .716 .513 r
.52063 .43042 .52645 .43686 .53678 .32653 .53118 .31991 Metetra
.61 .721 .925 r
.53118 .31991 .53678 .32653 .54721 .32428 .54164 .31763 Metetra
.609 .721 .924 r
.54164 .31763 .54721 .32428 .5577 .32202 .55214 .31534 Metetra
.609 .721 .924 r
.55214 .31534 .5577 .32202 .56823 .31976 .5627 .31305 Metetra
.609 .72 .924 r
.5627 .31305 .56823 .31976 .57881 .3175 .5733 .31075 Metetra
.608 .72 .924 r
.5733 .31075 .57881 .3175 .58944 .31524 .58395 .30846 Metetra
.608 .719 .924 r
.58395 .30846 .58944 .31524 .60011 .31299 .59466 .30617 Metetra
.607 .718 .924 r
.59466 .30617 .60011 .31299 .61085 .31075 .60541 .3039 Metetra
.606 .717 .924 r
.60541 .3039 .61085 .31075 .62163 .30853 .61622 .30163 Metetra
.605 .716 .924 r
.61622 .30163 .62163 .30853 .63246 .30632 .62708 .29938 Metetra
.603 .715 .923 r
.62708 .29938 .63246 .30632 .64335 .30414 .63799 .29716 Metetra
.602 .714 .923 r
.63799 .29716 .64335 .30414 .65429 .30199 .64896 .29496 Metetra
.6 .712 .923 r
.64896 .29496 .65429 .30199 .66529 .29988 .65998 .2928 Metetra
.598 .711 .923 r
.65998 .2928 .66529 .29988 .67635 .29781 .67106 .29067 Metetra
.596 .709 .922 r
.67106 .29067 .67635 .29781 .68746 .2958 .6822 .28859 Metetra
.593 .706 .922 r
.6822 .28859 .68746 .2958 .69864 .29385 .6934 .28657 Metetra
.59 .703 .921 r
.6934 .28657 .69864 .29385 .70987 .29199 .70466 .28462 Metetra
.587 .699 .92 r
.70466 .28462 .70987 .29199 .72117 .29023 .71598 .28274 Metetra
.584 .695 .918 r
.71598 .28274 .72117 .29023 .73254 .28859 .72737 .28095 Metetra
.58 .689 .916 r
.72737 .28095 .73254 .28859 .74399 .28709 .73882 .27924 Metetra
.578 .682 .912 r
.73882 .27924 .74399 .28709 .7555 .28576 .75034 .27762 Metetra
.577 .674 .905 r
.75034 .27762 .7555 .28576 .76709 .28457 .76193 .27604 Metetra
.581 .665 .896 r
.76193 .27604 .76709 .28457 .77875 .28341 .77358 .27441 Metetra
.589 .657 .884 r
.77358 .27441 .77875 .28341 .79046 .28203 .78528 .27259 Metetra
.601 .652 .872 r
.78528 .27259 .79046 .28203 .80219 .28013 .79701 .27045 Metetra
.613 .653 .865 r
.79701 .27045 .80219 .28013 .81393 .27765 .80877 .26794 Metetra
.623 .657 .863 r
.80877 .26794 .81393 .27765 .82569 .27475 .82056 .2651 Metetra
.63 .663 .864 r
.82056 .2651 .82569 .27475 .83747 .27155 .83238 .262 Metetra
.665 .703 .875 r
.19564 .57209 .20217 .57956 .21189 .57614 .20539 .56857 Metetra
.668 .702 .872 r
.20539 .56857 .21189 .57614 .22166 .57263 .21518 .56497 Metetra
.671 .701 .869 r
.21518 .56497 .22166 .57263 .23147 .56901 .22501 .56124 Metetra
.674 .7 .866 r
.22501 .56124 .23147 .56901 .24133 .56525 .23489 .55738 Metetra
.679 .699 .862 r
.23489 .55738 .24133 .56525 .25123 .5613 .24482 .55333 Metetra
.684 .699 .858 r
.24482 .55333 .25123 .5613 .26118 .5571 .2548 .54907 Metetra
.691 .7 .854 r
.2548 .54907 .26118 .5571 .27119 .55257 .26482 .54456 Metetra
.698 .703 .851 r
.26482 .54456 .27119 .55257 .28126 .54767 .27489 .53977 Metetra
.704 .708 .851 r
.27489 .53977 .28126 .54767 .29137 .54241 .28501 .53475 Metetra
.71 .716 .854 r
.28501 .53475 .29137 .54241 .30153 .53693 .29517 .52955 Metetra
.714 .726 .859 r
.29517 .52955 .30153 .53693 .31171 .53137 .30536 .52425 Metetra
.717 .734 .865 r
.30536 .52425 .31171 .53137 .32192 .52584 .31558 .51893 Metetra
.718 .741 .87 r
.31558 .51893 .32192 .52584 .33215 .52038 .32582 .51364 Metetra
.717 .746 .875 r
.32582 .51364 .33215 .52038 .34239 .51501 .33608 .50839 Metetra
.716 .75 .879 r
.33608 .50839 .34239 .51501 .35266 .50973 .34637 .50319 Metetra
.715 .753 .882 r
.34637 .50319 .35266 .50973 .36295 .50452 .35668 .49804 Metetra
.714 .756 .885 r
.35668 .49804 .36295 .50452 .37326 .49939 .36701 .49294 Metetra
.713 .757 .887 r
.36701 .49294 .37326 .49939 .3836 .49431 .37738 .48789 Metetra
.712 .759 .889 r
.37738 .48789 .3836 .49431 .39396 .48928 .38777 .48288 Metetra
.71 .76 .891 r
.38777 .48288 .39396 .48928 .40435 .48428 .39818 .4779 Metetra
.709 .761 .893 r
.39818 .4779 .40435 .48428 .41477 .47933 .40863 .47294 Metetra
.708 .762 .894 r
.40863 .47294 .41477 .47933 .42522 .47439 .4191 .46801 Metetra
.708 .762 .895 r
.4191 .46801 .42522 .47439 .4357 .46948 .42961 .4631 Metetra
.707 .763 .896 r
.42961 .4631 .4357 .46948 .44621 .46459 .44014 .45819 Metetra
.706 .763 .897 r
.44014 .45819 .44621 .46459 .45674 .45971 .45071 .4533 Metetra
.706 .764 .897 r
.45071 .4533 .45674 .45971 .46731 .45483 .46131 .44842 Metetra
.705 .764 .898 r
.46131 .44842 .46731 .45483 .47791 .44995 .47193 .44353 Metetra
.705 .765 .899 r
.47193 .44353 .47791 .44995 .48854 .44508 .48259 .43864 Metetra
.705 .765 .899 r
.48259 .43864 .48854 .44508 .49921 .4402 .49329 .43375 Metetra
.704 .765 .899 r
.49329 .43375 .49921 .4402 .5099 .43532 .50401 .42885 Metetra
.704 .766 .9 r
.50401 .42885 .5099 .43532 .52063 .43042 .51477 .42394 Metetra
.964 .716 .513 r
.51477 .42394 .52063 .43042 .53118 .31991 .52554 .31324 Metetra
.61 .722 .924 r
.52554 .31324 .53118 .31991 .54164 .31763 .53602 .31093 Metetra
.61 .721 .924 r
.53602 .31093 .54164 .31763 .55214 .31534 .54655 .3086 Metetra
.61 .721 .924 r
.54655 .3086 .55214 .31534 .5627 .31305 .55713 .30627 Metetra
.609 .72 .924 r
.55713 .30627 .5627 .31305 .5733 .31075 .56775 .30394 Metetra
.609 .719 .923 r
.56775 .30394 .5733 .31075 .58395 .30846 .57843 .30161 Metetra
.608 .719 .923 r
.57843 .30161 .58395 .30846 .59466 .30617 .58916 .29929 Metetra
.608 .718 .923 r
.58916 .29929 .59466 .30617 .60541 .3039 .59994 .29697 Metetra
.607 .717 .923 r
.59994 .29697 .60541 .3039 .61622 .30163 .61077 .29466 Metetra
.606 .716 .923 r
.61077 .29466 .61622 .30163 .62708 .29938 .62166 .29237 Metetra
.605 .715 .922 r
.62166 .29237 .62708 .29938 .63799 .29716 .6326 .29009 Metetra
.603 .713 .922 r
.6326 .29009 .63799 .29716 .64896 .29496 .64359 .28784 Metetra
.602 .712 .922 r
.64359 .28784 .64896 .29496 .65998 .2928 .65464 .28561 Metetra
.6 .71 .921 r
.65464 .28561 .65998 .2928 .67106 .29067 .66574 .28342 Metetra
.598 .708 .92 r
.66574 .28342 .67106 .29067 .6822 .28859 .6769 .28127 Metetra
.596 .705 .92 r
.6769 .28127 .6822 .28859 .6934 .28657 .68812 .27916 Metetra
.594 .702 .919 r
.68812 .27916 .6934 .28657 .70466 .28462 .6994 .2771 Metetra
.592 .699 .917 r
.6994 .2771 .70466 .28462 .71598 .28274 .71074 .2751 Metetra
.59 .694 .915 r
.71074 .2751 .71598 .28274 .72737 .28095 .72215 .27315 Metetra
.588 .689 .912 r
.72215 .27315 .72737 .28095 .73882 .27924 .73362 .27124 Metetra
.587 .684 .908 r
.73362 .27124 .73882 .27924 .75034 .27762 .74515 .26937 Metetra
.588 .678 .902 r
.74515 .26937 .75034 .27762 .76193 .27604 .75674 .26749 Metetra
.592 .671 .895 r
.75674 .26749 .76193 .27604 .77358 .27441 .76839 .26553 Metetra
.598 .666 .887 r
.76839 .26553 .77358 .27441 .78528 .27259 .78009 .26342 Metetra
.606 .663 .879 r
.78009 .26342 .78528 .27259 .79701 .27045 .79183 .26108 Metetra
.614 .663 .873 r
.79183 .26108 .79701 .27045 .80877 .26794 .80361 .25849 Metetra
.622 .665 .871 r
.80361 .25849 .80877 .26794 .82056 .2651 .81542 .25564 Metetra
.629 .669 .87 r
.81542 .25564 .82056 .2651 .83238 .262 .82727 .25257 Metetra
.667 .706 .876 r
.18906 .56464 .19564 .57209 .20539 .56857 .19884 .56105 Metetra
.67 .705 .873 r
.19884 .56105 .20539 .56857 .21518 .56497 .20865 .55736 Metetra
.673 .704 .871 r
.20865 .55736 .21518 .56497 .22501 .56124 .21851 .55356 Metetra
.676 .704 .868 r
.21851 .55356 .22501 .56124 .23489 .55738 .22841 .54962 Metetra
.68 .704 .865 r
.22841 .54962 .23489 .55738 .24482 .55333 .23836 .54552 Metetra
.685 .704 .862 r
.23836 .54552 .24482 .55333 .2548 .54907 .24835 .54124 Metetra
.69 .706 .859 r
.24835 .54124 .2548 .54907 .26482 .54456 .25839 .53676 Metetra
.696 .709 .858 r
.25839 .53676 .26482 .54456 .27489 .53977 .26847 .53207 Metetra
.701 .714 .858 r
.26847 .53207 .27489 .53977 .28501 .53475 .2786 .52721 Metetra
.706 .72 .86 r
.2786 .52721 .28501 .53475 .29517 .52955 .28877 .52219 Metetra
.709 .726 .863 r
.28877 .52219 .29517 .52955 .30536 .52425 .29896 .51709 Metetra
.712 .733 .867 r
.29896 .51709 .30536 .52425 .31558 .51893 .30919 .51194 Metetra
.713 .739 .872 r
.30919 .51194 .31558 .51893 .32582 .51364 .31945 .50679 Metetra
.713 .744 .876 r
.31945 .50679 .32582 .51364 .33608 .50839 .32973 .50165 Metetra
.713 .748 .879 r
.32973 .50165 .33608 .50839 .34637 .50319 .34003 .49653 Metetra
.712 .751 .882 r
.34003 .49653 .34637 .50319 .35668 .49804 .35037 .49145 Metetra
.712 .753 .885 r
.35037 .49145 .35668 .49804 .36701 .49294 .36073 .4864 Metetra
.711 .755 .887 r
.36073 .4864 .36701 .49294 .37738 .48789 .37111 .48138 Metetra
.71 .757 .889 r
.37111 .48138 .37738 .48789 .38777 .48288 .38153 .47639 Metetra
.709 .758 .891 r
.38153 .47639 .38777 .48288 .39818 .4779 .39197 .47142 Metetra
.708 .759 .892 r
.39197 .47142 .39818 .4779 .40863 .47294 .40244 .46648 Metetra
.707 .76 .893 r
.40244 .46648 .40863 .47294 .4191 .46801 .41294 .46155 Metetra
.707 .761 .895 r
.41294 .46155 .4191 .46801 .42961 .4631 .42348 .45664 Metetra
.706 .762 .896 r
.42348 .45664 .42961 .4631 .44014 .45819 .43404 .45173 Metetra
.705 .762 .896 r
.43404 .45173 .44014 .45819 .45071 .4533 .44463 .44683 Metetra
.705 .763 .897 r
.44463 .44683 .45071 .4533 .46131 .44842 .45526 .44194 Metetra
.705 .763 .898 r
.45526 .44194 .46131 .44842 .47193 .44353 .46591 .43705 Metetra
.704 .764 .899 r
.46591 .43705 .47193 .44353 .48259 .43864 .4766 .43215 Metetra
.704 .764 .899 r
.4766 .43215 .48259 .43864 .49329 .43375 .48733 .42725 Metetra
.704 .765 .9 r
.48733 .42725 .49329 .43375 .50401 .42885 .49808 .42234 Metetra
.704 .765 .9 r
.49808 .42234 .50401 .42885 .51477 .42394 .50887 .41741 Metetra
.964 .716 .513 r
.50887 .41741 .51477 .42394 .52554 .31324 .51986 .30653 Metetra
.611 .722 .924 r
.51986 .30653 .52554 .31324 .53602 .31093 .53036 .30418 Metetra
.611 .721 .924 r
.53036 .30418 .53602 .31093 .54655 .3086 .54092 .30181 Metetra
.61 .721 .924 r
.54092 .30181 .54655 .3086 .55713 .30627 .55152 .29944 Metetra
.61 .72 .923 r
.55152 .29944 .55713 .30627 .56775 .30394 .56217 .29707 Metetra
.61 .719 .923 r
.56217 .29707 .56775 .30394 .57843 .30161 .57287 .2947 Metetra
.609 .719 .923 r
.57287 .2947 .57843 .30161 .58916 .29929 .58363 .29233 Metetra
.609 .718 .922 r
.58363 .29233 .58916 .29929 .59994 .29697 .59443 .28997 Metetra
.608 .717 .922 r
.59443 .28997 .59994 .29697 .61077 .29466 .60529 .28761 Metetra
.607 .716 .922 r
.60529 .28761 .61077 .29466 .62166 .29237 .6162 .28527 Metetra
.606 .714 .921 r
.6162 .28527 .62166 .29237 .6326 .29009 .62716 .28294 Metetra
.605 .713 .921 r
.62716 .28294 .6326 .29009 .64359 .28784 .63818 .28063 Metetra
.604 .711 .92 r
.63818 .28063 .64359 .28784 .65464 .28561 .64925 .27834 Metetra
.602 .709 .92 r
.64925 .27834 .65464 .28561 .66574 .28342 .66038 .27608 Metetra
.601 .707 .919 r
.66038 .27608 .66574 .28342 .6769 .28127 .67156 .27384 Metetra
.599 .705 .918 r
.67156 .27384 .6769 .28127 .68812 .27916 .6828 .27164 Metetra
.598 .702 .916 r
.6828 .27164 .68812 .27916 .6994 .2771 .69411 .26947 Metetra
.596 .699 .914 r
.69411 .26947 .6994 .2771 .71074 .2751 .70547 .26734 Metetra
.595 .695 .912 r
.70547 .26734 .71074 .2751 .72215 .27315 .71689 .26523 Metetra
.595 .691 .909 r
.71689 .26523 .72215 .27315 .73362 .27124 .72837 .26315 Metetra
.595 .686 .905 r
.72837 .26315 .73362 .27124 .74515 .26937 .73992 .26106 Metetra
.597 .681 .9 r
.73992 .26106 .74515 .26937 .75674 .26749 .75152 .25894 Metetra
.6 .677 .895 r
.75152 .25894 .75674 .26749 .76839 .26553 .76318 .25674 Metetra
.604 .673 .889 r
.76318 .25674 .76839 .26553 .78009 .26342 .77488 .25441 Metetra
.61 .671 .883 r
.77488 .25441 .78009 .26342 .79183 .26108 .78664 .25192 Metetra
.617 .67 .879 r
.78664 .25192 .79183 .26108 .80361 .25849 .79843 .24922 Metetra
.623 .671 .876 r
.79843 .24922 .80361 .25849 .81542 .25564 .81027 .24633 Metetra
.628 .674 .874 r
.81027 .24633 .81542 .25564 .82727 .25257 .82215 .24326 Metetra
.669 .708 .877 r
.18244 .55721 .18906 .56464 .19884 .56105 .19224 .55356 Metetra
.671 .708 .875 r
.19224 .55356 .19884 .56105 .20865 .55736 .20207 .54981 Metetra
.674 .707 .873 r
.20207 .54981 .20865 .55736 .21851 .55356 .21195 .54595 Metetra
.678 .707 .87 r
.21195 .54595 .21851 .55356 .22841 .54962 .22187 .54196 Metetra
.681 .708 .868 r
.22187 .54196 .22841 .54962 .23836 .54552 .23184 .53784 Metetra
.685 .709 .866 r
.23184 .53784 .23836 .54552 .24835 .54124 .24185 .53355 Metetra
.69 .711 .864 r
.24185 .53355 .24835 .54124 .25839 .53676 .25191 .52911 Metetra
.694 .714 .863 r
.25191 .52911 .25839 .53676 .26847 .53207 .262 .5245 Metetra
.699 .718 .864 r
.262 .5245 .26847 .53207 .2786 .52721 .27214 .51975 Metetra
.702 .722 .865 r
.27214 .51975 .2786 .52721 .28877 .52219 .28232 .51487 Metetra
.705 .727 .867 r
.28232 .51487 .28877 .52219 .29896 .51709 .29253 .50992 Metetra
.708 .733 .87 r
.29253 .50992 .29896 .51709 .30919 .51194 .30277 .5049 Metetra
.709 .738 .874 r
.30277 .5049 .30919 .51194 .31945 .50679 .31304 .49987 Metetra
.71 .742 .877 r
.31304 .49987 .31945 .50679 .32973 .50165 .32334 .49482 Metetra
.71 .746 .88 r
.32334 .49482 .32973 .50165 .34003 .49653 .33366 .48979 Metetra
.71 .749 .882 r
.33366 .48979 .34003 .49653 .35037 .49145 .34402 .48476 Metetra
.709 .751 .885 r
.34402 .48476 .35037 .49145 .36073 .4864 .3544 .47976 Metetra
.709 .753 .887 r
.3544 .47976 .36073 .4864 .37111 .48138 .36481 .47478 Metetra
.708 .755 .889 r
.36481 .47478 .37111 .48138 .38153 .47639 .37525 .46981 Metetra
.707 .757 .891 r
.37525 .46981 .38153 .47639 .39197 .47142 .38572 .46487 Metetra
.707 .758 .892 r
.38572 .46487 .39197 .47142 .40244 .46648 .39621 .45994 Metetra
.706 .759 .893 r
.39621 .45994 .40244 .46648 .41294 .46155 .40674 .45502 Metetra
.705 .76 .894 r
.40674 .45502 .41294 .46155 .42348 .45664 .4173 .45011 Metetra
.705 .761 .895 r
.4173 .45011 .42348 .45664 .43404 .45173 .42789 .4452 Metetra
.705 .761 .896 r
.42789 .4452 .43404 .45173 .44463 .44683 .43851 .4403 Metetra
.704 .762 .897 r
.43851 .4403 .44463 .44683 .45526 .44194 .44916 .4354 Metetra
.704 .763 .898 r
.44916 .4354 .45526 .44194 .46591 .43705 .45985 .4305 Metetra
.704 .763 .899 r
.45985 .4305 .46591 .43705 .4766 .43215 .47057 .4256 Metetra
.703 .764 .899 r
.47057 .4256 .4766 .43215 .48733 .42725 .48132 .42069 Metetra
.703 .765 .9 r
.48132 .42069 .48733 .42725 .49808 .42234 .4921 .41577 Metetra
.703 .765 .9 r
.4921 .41577 .49808 .42234 .50887 .41741 .50292 .41083 Metetra
.964 .716 .513 r
.50292 .41083 .50887 .41741 .51986 .30653 .51414 .29977 Metetra
.611 .722 .924 r
.51414 .29977 .51986 .30653 .53036 .30418 .52467 .29737 Metetra
.611 .722 .924 r
.52467 .29737 .53036 .30418 .54092 .30181 .53524 .29497 Metetra
.611 .721 .923 r
.53524 .29497 .54092 .30181 .55152 .29944 .54587 .29256 Metetra
.611 .72 .923 r
.54587 .29256 .55152 .29944 .56217 .29707 .55655 .29014 Metetra
.611 .719 .922 r
.55655 .29014 .56217 .29707 .57287 .2947 .56727 .28773 Metetra
.61 .719 .922 r
.56727 .28773 .57287 .2947 .58363 .29233 .57805 .28531 Metetra
.61 .718 .922 r
.57805 .28531 .58363 .29233 .59443 .28997 .58888 .2829 Metetra
.609 .717 .921 r
.58888 .2829 .59443 .28997 .60529 .28761 .59976 .28049 Metetra
.608 .715 .921 r
.59976 .28049 .60529 .28761 .6162 .28527 .61069 .27809 Metetra
.608 .714 .92 r
.61069 .27809 .6162 .28527 .62716 .28294 .62168 .27571 Metetra
.607 .713 .92 r
.62168 .27571 .62716 .28294 .63818 .28063 .63272 .27333 Metetra
.606 .711 .919 r
.63272 .27333 .63818 .28063 .64925 .27834 .64382 .27097 Metetra
.605 .709 .918 r
.64382 .27097 .64925 .27834 .66038 .27608 .65497 .26864 Metetra
.603 .707 .917 r
.65497 .26864 .66038 .27608 .67156 .27384 .66618 .26632 Metetra
.602 .705 .916 r
.66618 .26632 .67156 .27384 .6828 .27164 .67745 .26402 Metetra
.601 .702 .914 r
.67745 .26402 .6828 .27164 .69411 .26947 .68877 .26174 Metetra
.601 .699 .912 r
.68877 .26174 .69411 .26947 .70547 .26734 .70015 .25948 Metetra
.6 .696 .91 r
.70015 .25948 .70547 .26734 .71689 .26523 .71159 .25723 Metetra
.6 .692 .907 r
.71159 .25723 .71689 .26523 .72837 .26315 .72309 .25498 Metetra
.601 .688 .904 r
.72309 .25498 .72837 .26315 .73992 .26106 .73465 .25271 Metetra
.603 .685 .9 r
.73465 .25271 .73992 .26106 .75152 .25894 .74627 .2504 Metetra
.605 .681 .895 r
.74627 .2504 .75152 .25894 .76318 .25674 .75794 .24801 Metetra
.609 .679 .891 r
.75794 .24801 .76318 .25674 .77488 .25441 .76966 .24551 Metetra
.614 .677 .886 r
.76966 .24551 .77488 .25441 .78664 .25192 .78143 .24288 Metetra
.619 .676 .883 r
.78143 .24288 .78664 .25192 .79843 .24922 .79325 .24009 Metetra
.624 .677 .88 r
.79325 .24009 .79843 .24922 .81027 .24633 .80511 .23714 Metetra
.628 .678 .878 r
.80511 .23714 .81027 .24633 .82215 .24326 .81701 .23403 Metetra
.67 .71 .878 r
.17577 .54981 .18244 .55721 .19224 .55356 .18559 .54611 Metetra
.673 .71 .876 r
.18559 .54611 .19224 .55356 .20207 .54981 .19545 .54231 Metetra
.675 .71 .874 r
.19545 .54231 .20207 .54981 .21195 .54595 .20535 .53841 Metetra
.678 .711 .873 r
.20535 .53841 .21195 .54595 .22187 .54196 .21529 .53439 Metetra
.682 .711 .871 r
.21529 .53439 .22187 .54196 .23184 .53784 .22527 .53025 Metetra
.685 .713 .869 r
.22527 .53025 .23184 .53784 .24185 .53355 .2353 .52597 Metetra
.689 .715 .868 r
.2353 .52597 .24185 .53355 .25191 .52911 .24537 .52156 Metetra
.693 .717 .868 r
.24537 .52156 .25191 .52911 .262 .5245 .25548 .51702 Metetra
.696 .721 .868 r
.25548 .51702 .262 .5245 .27214 .51975 .26563 .51235 Metetra
.699 .724 .869 r
.26563 .51235 .27214 .51975 .28232 .51487 .27582 .50758 Metetra
.702 .729 .871 r
.27582 .50758 .28232 .51487 .29253 .50992 .28604 .50273 Metetra
.704 .733 .873 r
.28604 .50273 .29253 .50992 .30277 .5049 .2963 .49783 Metetra
.706 .737 .876 r
.2963 .49783 .30277 .5049 .31304 .49987 .30659 .49289 Metetra
.706 .741 .878 r
.30659 .49289 .31304 .49987 .32334 .49482 .3169 .48793 Metetra
.707 .744 .881 r
.3169 .48793 .32334 .49482 .33366 .48979 .32725 .48296 Metetra
.707 .747 .883 r
.32725 .48296 .33366 .48979 .34402 .48476 .33762 .478 Metetra
.707 .75 .885 r
.33762 .478 .34402 .48476 .3544 .47976 .34803 .47304 Metetra
.707 .752 .887 r
.34803 .47304 .3544 .47976 .36481 .47478 .35846 .4681 Metetra
.706 .754 .889 r
.35846 .4681 .36481 .47478 .37525 .46981 .36893 .46316 Metetra
.706 .755 .891 r
.36893 .46316 .37525 .46981 .38572 .46487 .37942 .45824 Metetra
.705 .757 .892 r
.37942 .45824 .38572 .46487 .39621 .45994 .38994 .45332 Metetra
.705 .758 .893 r
.38994 .45332 .39621 .45994 .40674 .45502 .4005 .44841 Metetra
.704 .759 .894 r
.4005 .44841 .40674 .45502 .4173 .45011 .41108 .44351 Metetra
.704 .76 .895 r
.41108 .44351 .4173 .45011 .42789 .4452 .4217 .43861 Metetra
.704 .761 .896 r
.4217 .43861 .42789 .4452 .43851 .4403 .43235 .43371 Metetra
.703 .761 .897 r
.43235 .43371 .43851 .4403 .44916 .4354 .44303 .4288 Metetra
.703 .762 .898 r
.44303 .4288 .44916 .4354 .45985 .4305 .45374 .4239 Metetra
.703 .763 .899 r
.45374 .4239 .45985 .4305 .47057 .4256 .46449 .41899 Metetra
.703 .763 .899 r
.46449 .41899 .47057 .4256 .48132 .42069 .47527 .41407 Metetra
.703 .764 .9 r
.47527 .41407 .48132 .42069 .4921 .41577 .48609 .40915 Metetra
.703 .765 .9 r
.48609 .40915 .4921 .41577 .50292 .41083 .49693 .40421 Metetra
.964 .716 .513 r
.49693 .40421 .50292 .41083 .51414 .29977 .50838 .29296 Metetra
.612 .722 .924 r
.50838 .29296 .51414 .29977 .52467 .29737 .51893 .29052 Metetra
.612 .722 .923 r
.51893 .29052 .52467 .29737 .53524 .29497 .52953 .28807 Metetra
.612 .721 .923 r
.52953 .28807 .53524 .29497 .54587 .29256 .54018 .28561 Metetra
.612 .72 .922 r
.54018 .28561 .54587 .29256 .55655 .29014 .55088 .28315 Metetra
.612 .719 .922 r
.55088 .28315 .55655 .29014 .56727 .28773 .56163 .28069 Metetra
.611 .719 .921 r
.56163 .28069 .56727 .28773 .57805 .28531 .57244 .27822 Metetra
.611 .718 .921 r
.57244 .27822 .57805 .28531 .58888 .2829 .58329 .27576 Metetra
.61 .717 .92 r
.58329 .27576 .58888 .2829 .59976 .28049 .5942 .2733 Metetra
.61 .715 .92 r
.5942 .2733 .59976 .28049 .61069 .27809 .60515 .27085 Metetra
.609 .714 .919 r
.60515 .27085 .61069 .27809 .62168 .27571 .61617 .2684 Metetra
.608 .713 .919 r
.61617 .2684 .62168 .27571 .63272 .27333 .62723 .26596 Metetra
.608 .711 .918 r
.62723 .26596 .63272 .27333 .64382 .27097 .63835 .26353 Metetra
.607 .709 .917 r
.63835 .26353 .64382 .27097 .65497 .26864 .64953 .26111 Metetra
.606 .707 .916 r
.64953 .26111 .65497 .26864 .66618 .26632 .66076 .25871 Metetra
.605 .705 .914 r
.66076 .25871 .66618 .26632 .67745 .26402 .67205 .25631 Metetra
.605 .703 .913 r
.67205 .25631 .67745 .26402 .68877 .26174 .68339 .25393 Metetra
.604 .7 .911 r
.68339 .25393 .68877 .26174 .70015 .25948 .6948 .25155 Metetra
.604 .697 .909 r
.6948 .25155 .70015 .25948 .71159 .25723 .70626 .24916 Metetra
.605 .694 .906 r
.70626 .24916 .71159 .25723 .72309 .25498 .71778 .24677 Metetra
.606 .691 .903 r
.71778 .24677 .72309 .25498 .73465 .25271 .72935 .24434 Metetra
.608 .688 .899 r
.72935 .24434 .73465 .25271 .74627 .2504 .74099 .24187 Metetra
.61 .685 .896 r
.74099 .24187 .74627 .2504 .75794 .24801 .75267 .23932 Metetra
.613 .683 .892 r
.75267 .23932 .75794 .24801 .76966 .24551 .76441 .23668 Metetra
.617 .682 .889 r
.76441 .23668 .76966 .24551 .78143 .24288 .7762 .23393 Metetra
.621 .681 .886 r
.7762 .23393 .78143 .24288 .79325 .24009 .78804 .23104 Metetra
.625 .681 .883 r
.78804 .23104 .79325 .24009 .80511 .23714 .79992 .22802 Metetra
.629 .682 .882 r
.79992 .22802 .80511 .23714 .81701 .23403 .81185 .22487 Metetra
.671 .712 .879 r
.16906 .54244 .17577 .54981 .18559 .54611 .17889 .53869 Metetra
.673 .713 .878 r
.17889 .53869 .18559 .54611 .19545 .54231 .18877 .53485 Metetra
.676 .713 .876 r
.18877 .53485 .19545 .54231 .20535 .53841 .19869 .53092 Metetra
.679 .714 .875 r
.19869 .53092 .20535 .53841 .21529 .53439 .20865 .52688 Metetra
.682 .714 .873 r
.20865 .52688 .21529 .53439 .22527 .53025 .21865 .52273 Metetra
.685 .716 .872 r
.21865 .52273 .22527 .53025 .2353 .52597 .2287 .51847 Metetra
.688 .718 .872 r
.2287 .51847 .2353 .52597 .24537 .52156 .23879 .51409 Metetra
.691 .72 .871 r
.23879 .51409 .24537 .52156 .25548 .51702 .24891 .50959 Metetra
.694 .723 .872 r
.24891 .50959 .25548 .51702 .26563 .51235 .25908 .50499 Metetra
.697 .726 .873 r
.25908 .50499 .26563 .51235 .27582 .50758 .26928 .50031 Metetra
.699 .73 .874 r
.26928 .50031 .27582 .50758 .28604 .50273 .27952 .49554 Metetra
.701 .733 .876 r
.27952 .49554 .28604 .50273 .2963 .49783 .28979 .49072 Metetra
.703 .737 .878 r
.28979 .49072 .2963 .49783 .30659 .49289 .30009 .48586 Metetra
.704 .74 .88 r
.30009 .48586 .30659 .49289 .3169 .48793 .31043 .48098 Metetra
.704 .743 .882 r
.31043 .48098 .3169 .48793 .32725 .48296 .32079 .47608 Metetra
.705 .746 .884 r
.32079 .47608 .32725 .48296 .33762 .478 .33119 .47117 Metetra
.705 .748 .886 r
.33119 .47117 .33762 .478 .34803 .47304 .34162 .46626 Metetra
.705 .751 .888 r
.34162 .46626 .34803 .47304 .35846 .4681 .35207 .46135 Metetra
.704 .752 .889 r
.35207 .46135 .35846 .4681 .36893 .46316 .36256 .45644 Metetra
.704 .754 .891 r
.36256 .45644 .36893 .46316 .37942 .45824 .37308 .45154 Metetra
.704 .755 .892 r
.37308 .45154 .37942 .45824 .38994 .45332 .38363 .44664 Metetra
.703 .757 .893 r
.38363 .44664 .38994 .45332 .4005 .44841 .39421 .44174 Metetra
.703 .758 .895 r
.39421 .44174 .4005 .44841 .41108 .44351 .40482 .43684 Metetra
.703 .759 .896 r
.40482 .43684 .41108 .44351 .4217 .43861 .41546 .43195 Metetra
.703 .76 .896 r
.41546 .43195 .4217 .43861 .43235 .43371 .42614 .42705 Metetra
.702 .761 .897 r
.42614 .42705 .43235 .43371 .44303 .4288 .43685 .42215 Metetra
.702 .762 .898 r
.43685 .42215 .44303 .4288 .45374 .4239 .44759 .41724 Metetra
.702 .762 .899 r
.44759 .41724 .45374 .4239 .46449 .41899 .45837 .41233 Metetra
.702 .763 .899 r
.45837 .41233 .46449 .41899 .47527 .41407 .46918 .40741 Metetra
.702 .764 .9 r
.46918 .40741 .47527 .41407 .48609 .40915 .48002 .40247 Metetra
.702 .765 .901 r
.48002 .40247 .48609 .40915 .49693 .40421 .4909 .39753 Metetra
.964 .716 .513 r
.4909 .39753 .49693 .40421 .50838 .29296 .50258 .2861 Metetra
.613 .723 .924 r
.50258 .2861 .50838 .29296 .51893 .29052 .51315 .28362 Metetra
.613 .722 .923 r
.51315 .28362 .51893 .29052 .52953 .28807 .52378 .28112 Metetra
.613 .721 .922 r
.52378 .28112 .52953 .28807 .54018 .28561 .53445 .27862 Metetra
.613 .72 .922 r
.53445 .27862 .54018 .28561 .55088 .28315 .54518 .27611 Metetra
.613 .72 .921 r
.54518 .27611 .55088 .28315 .56163 .28069 .55595 .27359 Metetra
.612 .719 .921 r
.55595 .27359 .56163 .28069 .57244 .27822 .56678 .27108 Metetra
.612 .718 .92 r
.56678 .27108 .57244 .27822 .58329 .27576 .57766 .26856 Metetra
.612 .717 .92 r
.57766 .26856 .58329 .27576 .5942 .2733 .58859 .26604 Metetra
.611 .715 .919 r
.58859 .26604 .5942 .2733 .60515 .27085 .59957 .26353 Metetra
.611 .714 .918 r
.59957 .26353 .60515 .27085 .61617 .2684 .61061 .26101 Metetra
.61 .713 .918 r
.61061 .26101 .61617 .2684 .62723 .26596 .6217 .25851 Metetra
.61 .711 .917 r
.6217 .25851 .62723 .26596 .63835 .26353 .63284 .25601 Metetra
.609 .709 .916 r
.63284 .25601 .63835 .26353 .64953 .26111 .64404 .25351 Metetra
.609 .708 .915 r
.64404 .25351 .64953 .26111 .66076 .25871 .6553 .25102 Metetra
.608 .705 .913 r
.6553 .25102 .66076 .25871 .67205 .25631 .66661 .24853 Metetra
.608 .703 .912 r
.66661 .24853 .67205 .25631 .68339 .25393 .67798 .24604 Metetra
.608 .701 .91 r
.67798 .24604 .68339 .25393 .6948 .25155 .68941 .24355 Metetra
.608 .698 .908 r
.68941 .24355 .6948 .25155 .70626 .24916 .70089 .24104 Metetra
.609 .696 .905 r
.70089 .24104 .70626 .24916 .71778 .24677 .71243 .23852 Metetra
.61 .693 .902 r
.71243 .23852 .71778 .24677 .72935 .24434 .72402 .23595 Metetra
.611 .691 .9 r
.72402 .23595 .72935 .24434 .74099 .24187 .73567 .23334 Metetra
.614 .689 .896 r
.73567 .23334 .74099 .24187 .75267 .23932 .74738 .23066 Metetra
.616 .687 .893 r
.74738 .23066 .75267 .23932 .76441 .23668 .75914 .22789 Metetra
.619 .686 .89 r
.75914 .22789 .76441 .23668 .7762 .23393 .77094 .22503 Metetra
.623 .685 .888 r
.77094 .22503 .7762 .23393 .78804 .23104 .7828 .22206 Metetra
.626 .685 .886 r
.7828 .22206 .78804 .23104 .79992 .22802 .79471 .21897 Metetra
.629 .686 .884 r
.79471 .21897 .79992 .22802 .81185 .22487 .80666 .21577 Metetra
.672 .715 .881 r
.16229 .53509 .16906 .54244 .17889 .53869 .17215 .5313 Metetra
.674 .715 .879 r
.17215 .5313 .17889 .53869 .18877 .53485 .18205 .52744 Metetra
.676 .715 .878 r
.18205 .52744 .18877 .53485 .19869 .53092 .19198 .52348 Metetra
.679 .716 .877 r
.19198 .52348 .19869 .53092 .20865 .52688 .20196 .51943 Metetra
.682 .717 .876 r
.20196 .51943 .20865 .52688 .21865 .52273 .21198 .51528 Metetra
.684 .719 .875 r
.21198 .51528 .21865 .52273 .2287 .51847 .22205 .51102 Metetra
.687 .72 .875 r
.22205 .51102 .2287 .51847 .23879 .51409 .23215 .50667 Metetra
.69 .722 .875 r
.23215 .50667 .23879 .51409 .24891 .50959 .24229 .50221 Metetra
.693 .725 .875 r
.24229 .50221 .24891 .50959 .25908 .50499 .25247 .49767 Metetra
.695 .728 .876 r
.25247 .49767 .25908 .50499 .26928 .50031 .26269 .49304 Metetra
.697 .731 .877 r
.26269 .49304 .26928 .50031 .27952 .49554 .27295 .48835 Metetra
.699 .734 .878 r
.27295 .48835 .27952 .49554 .28979 .49072 .28323 .4836 Metetra
.7 .737 .88 r
.28323 .4836 .28979 .49072 .30009 .48586 .29356 .47881 Metetra
.701 .74 .881 r
.29356 .47881 .30009 .48586 .31043 .48098 .30391 .47398 Metetra
.702 .743 .883 r
.30391 .47398 .31043 .48098 .32079 .47608 .31429 .46914 Metetra
.702 .745 .885 r
.31429 .46914 .32079 .47608 .33119 .47117 .32471 .46428 Metetra
.703 .748 .887 r
.32471 .46428 .33119 .47117 .34162 .46626 .33516 .45941 Metetra
.703 .75 .888 r
.33516 .45941 .34162 .46626 .35207 .46135 .34564 .45453 Metetra
.703 .751 .89 r
.34564 .45453 .35207 .46135 .36256 .45644 .35615 .44965 Metetra
.702 .753 .891 r
.35615 .44965 .36256 .45644 .37308 .45154 .36669 .44477 Metetra
.702 .755 .892 r
.36669 .44477 .37308 .45154 .38363 .44664 .37727 .43989 Metetra
.702 .756 .894 r
.37727 .43989 .38363 .44664 .39421 .44174 .38787 .435 Metetra
.702 .757 .895 r
.38787 .435 .39421 .44174 .40482 .43684 .39851 .43012 Metetra
.702 .758 .896 r
.39851 .43012 .40482 .43684 .41546 .43195 .40918 .42523 Metetra
.702 .759 .897 r
.40918 .42523 .41546 .43195 .42614 .42705 .41989 .42033 Metetra
.701 .76 .898 r
.41989 .42033 .42614 .42705 .43685 .42215 .43063 .41543 Metetra
.701 .761 .898 r
.43063 .41543 .43685 .42215 .44759 .41724 .4414 .41053 Metetra
.701 .762 .899 r
.4414 .41053 .44759 .41724 .45837 .41233 .4522 .40561 Metetra
.701 .763 .9 r
.4522 .40561 .45837 .41233 .46918 .40741 .46304 .40069 Metetra
.701 .763 .9 r
.46304 .40069 .46918 .40741 .48002 .40247 .47391 .39575 Metetra
.701 .764 .901 r
.47391 .39575 .48002 .40247 .4909 .39753 .48482 .3908 Metetra
.964 .716 .513 r
.48482 .3908 .4909 .39753 .50258 .2861 .49673 .27919 Metetra
.614 .723 .923 r
.49673 .27919 .50258 .2861 .51315 .28362 .50733 .27666 Metetra
.614 .722 .923 r
.50733 .27666 .51315 .28362 .52378 .28112 .51798 .27411 Metetra
.614 .722 .922 r
.51798 .27411 .52378 .28112 .53445 .27862 .52868 .27156 Metetra
.614 .721 .922 r
.52868 .27156 .53445 .27862 .54518 .27611 .53943 .269 Metetra
.614 .72 .921 r
.53943 .269 .54518 .27611 .55595 .27359 .55023 .26644 Metetra
.614 .719 .92 r
.55023 .26644 .55595 .27359 .56678 .27108 .56108 .26387 Metetra
.613 .718 .92 r
.56108 .26387 .56678 .27108 .57766 .26856 .57199 .26129 Metetra
.613 .717 .919 r
.57199 .26129 .57766 .26856 .58859 .26604 .58294 .25872 Metetra
.613 .716 .918 r
.58294 .25872 .58859 .26604 .59957 .26353 .59395 .25614 Metetra
.612 .714 .918 r
.59395 .25614 .59957 .26353 .61061 .26101 .60501 .25356 Metetra
.612 .713 .917 r
.60501 .25356 .61061 .26101 .6217 .25851 .61613 .25099 Metetra
.612 .711 .916 r
.61613 .25099 .6217 .25851 .63284 .25601 .6273 .24841 Metetra
.611 .71 .915 r
.6273 .24841 .63284 .25601 .64404 .25351 .63852 .24584 Metetra
.611 .708 .914 r
.63852 .24584 .64404 .25351 .6553 .25102 .6498 .24326 Metetra
.611 .706 .912 r
.6498 .24326 .6553 .25102 .66661 .24853 .66114 .24068 Metetra
.611 .704 .911 r
.66114 .24068 .66661 .24853 .67798 .24604 .67253 .23809 Metetra
.611 .702 .909 r
.67253 .23809 .67798 .24604 .68941 .24355 .68398 .23549 Metetra
.611 .7 .907 r
.68398 .23549 .68941 .24355 .70089 .24104 .69548 .23287 Metetra
.612 .698 .905 r
.69548 .23287 .70089 .24104 .71243 .23852 .70704 .23023 Metetra
.613 .695 .902 r
.70704 .23023 .71243 .23852 .72402 .23595 .71866 .22754 Metetra
.615 .693 .9 r
.71866 .22754 .72402 .23595 .73567 .23334 .73033 .22481 Metetra
.617 .692 .897 r
.73033 .22481 .73567 .23334 .74738 .23066 .74205 .22201 Metetra
.619 .69 .894 r
.74205 .22201 .74738 .23066 .75914 .22789 .75383 .21913 Metetra
.622 .689 .892 r
.75383 .21913 .75914 .22789 .77094 .22503 .76566 .21617 Metetra
.624 .689 .89 r
.76566 .21617 .77094 .22503 .7828 .22206 .77754 .21312 Metetra
.627 .689 .888 r
.77754 .21312 .7828 .22206 .79471 .21897 .78947 .20996 Metetra
.63 .689 .886 r
.78947 .20996 .79471 .21897 .80666 .21577 .80145 .2067 Metetra
.672 .716 .882 r
.15548 .52775 .16229 .53509 .17215 .5313 .16536 .52394 Metetra
.674 .717 .881 r
.16536 .52394 .17215 .5313 .18205 .52744 .17527 .52005 Metetra
.676 .718 .88 r
.17527 .52005 .18205 .52744 .19198 .52348 .18523 .51608 Metetra
.679 .718 .879 r
.18523 .51608 .19198 .52348 .20196 .51943 .19523 .51201 Metetra
.681 .719 .878 r
.19523 .51201 .20196 .51943 .21198 .51528 .20527 .50786 Metetra
.684 .721 .878 r
.20527 .50786 .21198 .51528 .22205 .51102 .21534 .50362 Metetra
.686 .722 .877 r
.21534 .50362 .22205 .51102 .23215 .50667 .22546 .49929 Metetra
.689 .724 .877 r
.22546 .49929 .23215 .50667 .24229 .50221 .23562 .49487 Metetra
.691 .727 .877 r
.23562 .49487 .24229 .50221 .25247 .49767 .24582 .49036 Metetra
.693 .729 .878 r
.24582 .49036 .25247 .49767 .26269 .49304 .25606 .48579 Metetra
.695 .732 .879 r
.25606 .48579 .26269 .49304 .27295 .48835 .26633 .48115 Metetra
.697 .735 .88 r
.26633 .48115 .27295 .48835 .28323 .4836 .27663 .47646 Metetra
.698 .737 .881 r
.27663 .47646 .28323 .4836 .29356 .47881 .28697 .47172 Metetra
.699 .74 .883 r
.28697 .47172 .29356 .47881 .30391 .47398 .29735 .46695 Metetra
.7 .742 .884 r
.29735 .46695 .30391 .47398 .31429 .46914 .30775 .46215 Metetra
.7 .745 .886 r
.30775 .46215 .31429 .46914 .32471 .46428 .31819 .45733 Metetra
.701 .747 .888 r
.31819 .45733 .32471 .46428 .33516 .45941 .32866 .4525 Metetra
.701 .749 .889 r
.32866 .4525 .33516 .45941 .34564 .45453 .33916 .44765 Metetra
.701 .751 .89 r
.33916 .44765 .34564 .45453 .35615 .44965 .3497 .4428 Metetra
.701 .752 .892 r
.3497 .4428 .35615 .44965 .36669 .44477 .36027 .43794 Metetra
.701 .754 .893 r
.36027 .43794 .36669 .44477 .37727 .43989 .37086 .43308 Metetra
.701 .755 .894 r
.37086 .43308 .37727 .43989 .38787 .435 .3815 .4282 Metetra
.701 .756 .895 r
.3815 .4282 .38787 .435 .39851 .43012 .39216 .42333 Metetra
.701 .757 .896 r
.39216 .42333 .39851 .43012 .40918 .42523 .40286 .41845 Metetra
.7 .759 .897 r
.40286 .41845 .40918 .42523 .41989 .42033 .41359 .41356 Metetra
.7 .759 .898 r
.41359 .41356 .41989 .42033 .43063 .41543 .42436 .40866 Metetra
.7 .76 .899 r
.42436 .40866 .43063 .41543 .4414 .41053 .43516 .40375 Metetra
.7 .761 .899 r
.43516 .40375 .4414 .41053 .4522 .40561 .44599 .39884 Metetra
.7 .762 .9 r
.44599 .39884 .4522 .40561 .46304 .40069 .45686 .39391 Metetra
.7 .763 .901 r
.45686 .39391 .46304 .40069 .47391 .39575 .46776 .38897 Metetra
.7 .764 .901 r
.46776 .38897 .47391 .39575 .48482 .3908 .4787 .38402 Metetra
.964 .716 .513 r
.4787 .38402 .48482 .3908 .49673 .27919 .49085 .27223 Metetra
.615 .724 .923 r
.49085 .27223 .49673 .27919 .50733 .27666 .50147 .26965 Metetra
.615 .723 .922 r
.50147 .26965 .50733 .27666 .51798 .27411 .51215 .26706 Metetra
.615 .722 .922 r
.51215 .26706 .51798 .27411 .52868 .27156 .52287 .26445 Metetra
.615 .721 .921 r
.52287 .26445 .52868 .27156 .53943 .269 .53365 .26184 Metetra
.615 .72 .921 r
.53365 .26184 .53943 .269 .55023 .26644 .54447 .25922 Metetra
.615 .719 .92 r
.54447 .25922 .55023 .26644 .56108 .26387 .55535 .25659 Metetra
.615 .718 .919 r
.55535 .25659 .56108 .26387 .57199 .26129 .56628 .25396 Metetra
.615 .717 .918 r
.56628 .25396 .57199 .26129 .58294 .25872 .57726 .25133 Metetra
.614 .716 .918 r
.57726 .25133 .58294 .25872 .59395 .25614 .58829 .24869 Metetra
.614 .715 .917 r
.58829 .24869 .59395 .25614 .60501 .25356 .59938 .24605 Metetra
.614 .713 .916 r
.59938 .24605 .60501 .25356 .61613 .25099 .61052 .2434 Metetra
.614 .712 .915 r
.61052 .2434 .61613 .25099 .6273 .24841 .62171 .24075 Metetra
.613 .71 .914 r
.62171 .24075 .6273 .24841 .63852 .24584 .63296 .2381 Metetra
.613 .709 .913 r
.63296 .2381 .63852 .24584 .6498 .24326 .64426 .23544 Metetra
.613 .707 .911 r
.64426 .23544 .6498 .24326 .66114 .24068 .65562 .23277 Metetra
.613 .705 .91 r
.65562 .23277 .66114 .24068 .67253 .23809 .66704 .23008 Metetra
.614 .703 .908 r
.66704 .23008 .67253 .23809 .68398 .23549 .67851 .22738 Metetra
.614 .701 .906 r
.67851 .22738 .68398 .23549 .69548 .23287 .69004 .22466 Metetra
.615 .699 .904 r
.69004 .22466 .69548 .23287 .70704 .23023 .70162 .22191 Metetra
.616 .698 .902 r
.70162 .22191 .70704 .23023 .71866 .22754 .71326 .21911 Metetra
.618 .696 .9 r
.71326 .21911 .71866 .22754 .73033 .22481 .72495 .21627 Metetra
.619 .694 .898 r
.72495 .21627 .73033 .22481 .74205 .22201 .7367 .21336 Metetra
.621 .693 .895 r
.7367 .21336 .74205 .22201 .75383 .21913 .7485 .21039 Metetra
.624 .692 .893 r
.7485 .21039 .75383 .21913 .76566 .21617 .76035 .20734 Metetra
.626 .692 .891 r
.76035 .20734 .76566 .21617 .77754 .21312 .77225 .2042 Metetra
.629 .692 .89 r
.77225 .2042 .77754 .21312 .78947 .20996 .78421 .20097 Metetra
.631 .692 .888 r
.78421 .20097 .78947 .20996 .80145 .2067 .79621 .19765 Metetra
.672 .718 .883 r
.14862 .52043 .15548 .52775 .16536 .52394 .15851 .5166 Metetra
.674 .719 .883 r
.15851 .5166 .16536 .52394 .17527 .52005 .16845 .51269 Metetra
.676 .719 .882 r
.16845 .51269 .17527 .52005 .18523 .51608 .17842 .5087 Metetra
.678 .72 .881 r
.17842 .5087 .18523 .51608 .19523 .51201 .18844 .50463 Metetra
.681 .721 .88 r
.18844 .50463 .19523 .51201 .20527 .50786 .1985 .50048 Metetra
.683 .723 .88 r
.1985 .50048 .20527 .50786 .21534 .50362 .20859 .49625 Metetra
.685 .724 .88 r
.20859 .49625 .21534 .50362 .22546 .49929 .21873 .49193 Metetra
.687 .726 .88 r
.21873 .49193 .22546 .49929 .23562 .49487 .22891 .48754 Metetra
.689 .728 .88 r
.22891 .48754 .23562 .49487 .24582 .49036 .23912 .48307 Metetra
.691 .73 .88 r
.23912 .48307 .24582 .49036 .25606 .48579 .24937 .47854 Metetra
.693 .733 .881 r
.24937 .47854 .25606 .48579 .26633 .48115 .25966 .47394 Metetra
.695 .735 .882 r
.25966 .47394 .26633 .48115 .27663 .47646 .26999 .46929 Metetra
.696 .738 .883 r
.26999 .46929 .27663 .47646 .28697 .47172 .28034 .4646 Metetra
.697 .74 .884 r
.28034 .4646 .28697 .47172 .29735 .46695 .29074 .45988 Metetra
.698 .742 .886 r
.29074 .45988 .29735 .46695 .30775 .46215 .30116 .45512 Metetra
.698 .744 .887 r
.30116 .45512 .30775 .46215 .31819 .45733 .31162 .45034 Metetra
.699 .746 .888 r
.31162 .45034 .31819 .45733 .32866 .4525 .32212 .44554 Metetra
.699 .748 .89 r
.32212 .44554 .32866 .4525 .33916 .44765 .33264 .44072 Metetra
.699 .75 .891 r
.33264 .44072 .33916 .44765 .3497 .4428 .3432 .43589 Metetra
.699 .752 .892 r
.3432 .43589 .3497 .4428 .36027 .43794 .35379 .43105 Metetra
.699 .753 .893 r
.35379 .43105 .36027 .43794 .37086 .43308 .36442 .42621 Metetra
.699 .754 .894 r
.36442 .42621 .37086 .43308 .3815 .4282 .37507 .42135 Metetra
.699 .756 .895 r
.37507 .42135 .3815 .4282 .39216 .42333 .38577 .41648 Metetra
.699 .757 .896 r
.38577 .41648 .39216 .42333 .40286 .41845 .39649 .41161 Metetra
.699 .758 .897 r
.39649 .41161 .40286 .41845 .41359 .41356 .40725 .40672 Metetra
.699 .759 .898 r
.40725 .40672 .41359 .41356 .42436 .40866 .41804 .40183 Metetra
.699 .76 .899 r
.41804 .40183 .42436 .40866 .43516 .40375 .42887 .39693 Metetra
.699 .761 .9 r
.42887 .39693 .43516 .40375 .44599 .39884 .43973 .39201 Metetra
.699 .762 .9 r
.43973 .39201 .44599 .39884 .45686 .39391 .45063 .38708 Metetra
.699 .763 .901 r
.45063 .38708 .45686 .39391 .46776 .38897 .46156 .38214 Metetra
.699 .764 .902 r
.46156 .38214 .46776 .38897 .4787 .38402 .47253 .37719 Metetra
.964 .716 .513 r
.47253 .37719 .4787 .38402 .49085 .27223 .48492 .26522 Metetra
.616 .724 .923 r
.48492 .26522 .49085 .27223 .50147 .26965 .49557 .26259 Metetra
.617 .723 .922 r
.49557 .26259 .50147 .26965 .51215 .26706 .50627 .25994 Metetra
.616 .722 .921 r
.50627 .25994 .51215 .26706 .52287 .26445 .51702 .25729 Metetra
.616 .721 .921 r
.51702 .25729 .52287 .26445 .53365 .26184 .52782 .25462 Metetra
.616 .72 .92 r
.52782 .25462 .53365 .26184 .54447 .25922 .53867 .25195 Metetra
.616 .719 .919 r
.53867 .25195 .54447 .25922 .55535 .25659 .54957 .24926 Metetra
.616 .718 .919 r
.54957 .24926 .55535 .25659 .56628 .25396 .56052 .24657 Metetra
.616 .717 .918 r
.56052 .24657 .56628 .25396 .57726 .25133 .57153 .24388 Metetra
.616 .716 .917 r
.57153 .24388 .57726 .25133 .58829 .24869 .58259 .24117 Metetra
.616 .715 .916 r
.58259 .24117 .58829 .24869 .59938 .24605 .5937 .23847 Metetra
.616 .714 .915 r
.5937 .23847 .59938 .24605 .61052 .2434 .60486 .23575 Metetra
.615 .712 .914 r
.60486 .23575 .61052 .2434 .62171 .24075 .61608 .23303 Metetra
.615 .711 .913 r
.61608 .23303 .62171 .24075 .63296 .2381 .62736 .23029 Metetra
.615 .709 .912 r
.62736 .23029 .63296 .2381 .64426 .23544 .63869 .22755 Metetra
.615 .708 .911 r
.63869 .22755 .64426 .23544 .65562 .23277 .65007 .2248 Metetra
.616 .706 .909 r
.65007 .2248 .65562 .23277 .66704 .23008 .66151 .22202 Metetra
.616 .704 .908 r
.66151 .22202 .66704 .23008 .67851 .22738 .673 .21923 Metetra
.617 .703 .906 r
.673 .21923 .67851 .22738 .69004 .22466 .68455 .21641 Metetra
.618 .701 .904 r
.68455 .21641 .69004 .22466 .70162 .22191 .69616 .21355 Metetra
.619 .699 .902 r
.69616 .21355 .70162 .22191 .71326 .21911 .70782 .21066 Metetra
.62 .698 .9 r
.70782 .21066 .71326 .21911 .72495 .21627 .71954 .20772 Metetra
.622 .697 .898 r
.71954 .20772 .72495 .21627 .7367 .21336 .73131 .20471 Metetra
.624 .696 .896 r
.73131 .20471 .7367 .21336 .7485 .21039 .74313 .20165 Metetra
.626 .695 .894 r
.74313 .20165 .7485 .21039 .76035 .20734 .75501 .19851 Metetra
.628 .694 .893 r
.75501 .19851 .76035 .20734 .77225 .2042 .76694 .1953 Metetra
.63 .694 .891 r
.76694 .1953 .77225 .2042 .78421 .20097 .77892 .192 Metetra
.632 .694 .89 r
.77892 .192 .78421 .20097 .79621 .19765 .79095 .18862 Metetra
.672 .72 .885 r
.14171 .51313 .14862 .52043 .15851 .5166 .15162 .50927 Metetra
.674 .72 .884 r
.15162 .50927 .15851 .5166 .16845 .51269 .16157 .50534 Metetra
.676 .721 .883 r
.16157 .50534 .16845 .51269 .17842 .5087 .17157 .50134 Metetra
.678 .722 .883 r
.17157 .50134 .17842 .5087 .18844 .50463 .1816 .49727 Metetra
.68 .723 .882 r
.1816 .49727 .18844 .50463 .1985 .50048 .19168 .49312 Metetra
.682 .725 .882 r
.19168 .49312 .1985 .50048 .20859 .49625 .20179 .48889 Metetra
.684 .726 .882 r
.20179 .48889 .20859 .49625 .21873 .49193 .21195 .48459 Metetra
.686 .728 .882 r
.21195 .48459 .21873 .49193 .22891 .48754 .22214 .48022 Metetra
.688 .73 .882 r
.22214 .48022 .22891 .48754 .23912 .48307 .23237 .47578 Metetra
.69 .732 .882 r
.23237 .47578 .23912 .48307 .24937 .47854 .24264 .47128 Metetra
.691 .734 .883 r
.24264 .47128 .24937 .47854 .25966 .47394 .25295 .46672 Metetra
.693 .736 .884 r
.25295 .46672 .25966 .47394 .26999 .46929 .26329 .46211 Metetra
.694 .738 .885 r
.26329 .46211 .26999 .46929 .28034 .4646 .27367 .45746 Metetra
.695 .74 .886 r
.27367 .45746 .28034 .4646 .29074 .45988 .28408 .45277 Metetra
.696 .742 .887 r
.28408 .45277 .29074 .45988 .30116 .45512 .29453 .44805 Metetra
.697 .744 .888 r
.29453 .44805 .30116 .45512 .31162 .45034 .30501 .4433 Metetra
.697 .746 .889 r
.30501 .4433 .31162 .45034 .32212 .44554 .31553 .43853 Metetra
.697 .748 .891 r
.31553 .43853 .32212 .44554 .33264 .44072 .32607 .43374 Metetra
.698 .75 .892 r
.32607 .43374 .33264 .44072 .3432 .43589 .33666 .42893 Metetra
.698 .751 .893 r
.33666 .42893 .3432 .43589 .35379 .43105 .34727 .42411 Metetra
.698 .753 .894 r
.34727 .42411 .35379 .43105 .36442 .42621 .35792 .41928 Metetra
.698 .754 .895 r
.35792 .41928 .36442 .42621 .37507 .42135 .36861 .41444 Metetra
.698 .755 .896 r
.36861 .41444 .37507 .42135 .38577 .41648 .37932 .40958 Metetra
.698 .756 .897 r
.37932 .40958 .38577 .41648 .39649 .41161 .39008 .40471 Metetra
.698 .757 .898 r
.39008 .40471 .39649 .41161 .40725 .40672 .40086 .39984 Metetra
.698 .759 .898 r
.40086 .39984 .40725 .40672 .41804 .40183 .41168 .39495 Metetra
.698 .76 .899 r
.41168 .39495 .41804 .40183 .42887 .39693 .42254 .39005 Metetra
.698 .76 .9 r
.42254 .39005 .42887 .39693 .43973 .39201 .43343 .38513 Metetra
.698 .761 .901 r
.43343 .38513 .43973 .39201 .45063 .38708 .44436 .3802 Metetra
.698 .762 .901 r
.44436 .3802 .45063 .38708 .46156 .38214 .45532 .37526 Metetra
.698 .763 .902 r
.45532 .37526 .46156 .38214 .47253 .37719 .46632 .37031 Metetra
.964 .716 .513 r
.46632 .37031 .47253 .37719 .48492 .26522 .47895 .25816 Metetra
.618 .724 .922 r
.47895 .25816 .48492 .26522 .49557 .26259 .48962 .25548 Metetra
.618 .724 .922 r
.48962 .25548 .49557 .26259 .50627 .25994 .50035 .25278 Metetra
.618 .723 .921 r
.50035 .25278 .50627 .25994 .51702 .25729 .51112 .25007 Metetra
.618 .722 .92 r
.51112 .25007 .51702 .25729 .52782 .25462 .52195 .24734 Metetra
.618 .721 .92 r
.52195 .24734 .52782 .25462 .53867 .25195 .53282 .24461 Metetra
.618 .72 .919 r
.53282 .24461 .53867 .25195 .54957 .24926 .54375 .24187 Metetra
.617 .719 .918 r
.54375 .24187 .54957 .24926 .56052 .24657 .55473 .23912 Metetra
.617 .718 .917 r
.55473 .23912 .56052 .24657 .57153 .24388 .56576 .23637 Metetra
.617 .717 .917 r
.56576 .23637 .57153 .24388 .58259 .24117 .57684 .2336 Metetra
.617 .715 .916 r
.57684 .2336 .58259 .24117 .5937 .23847 .58798 .23082 Metetra
.617 .714 .915 r
.58798 .23082 .5937 .23847 .60486 .23575 .59917 .22804 Metetra
.617 .713 .914 r
.59917 .22804 .60486 .23575 .61608 .23303 .61042 .22524 Metetra
.617 .712 .913 r
.61042 .22524 .61608 .23303 .62736 .23029 .62172 .22244 Metetra
.617 .71 .912 r
.62172 .22244 .62736 .23029 .63869 .22755 .63307 .21961 Metetra
.618 .709 .91 r
.63307 .21961 .63869 .22755 .65007 .2248 .64448 .21677 Metetra
.618 .707 .909 r
.64448 .21677 .65007 .2248 .66151 .22202 .65594 .21392 Metetra
.618 .706 .907 r
.65594 .21392 .66151 .22202 .673 .21923 .66746 .21103 Metetra
.619 .704 .906 r
.66746 .21103 .673 .21923 .68455 .21641 .67903 .20812 Metetra
.62 .703 .904 r
.67903 .20812 .68455 .21641 .69616 .21355 .69066 .20517 Metetra
.621 .701 .902 r
.69066 .20517 .69616 .21355 .70782 .21066 .70235 .20218 Metetra
.622 .7 .901 r
.70235 .20218 .70782 .21066 .71954 .20772 .71409 .19915 Metetra
.624 .699 .899 r
.71409 .19915 .71954 .20772 .73131 .20471 .72588 .19606 Metetra
.625 .698 .897 r
.72588 .19606 .73131 .20471 .74313 .20165 .73773 .1929 Metetra
.627 .697 .895 r
.73773 .1929 .74313 .20165 .75501 .19851 .74963 .18969 Metetra
.629 .697 .894 r
.74963 .18969 .75501 .19851 .76694 .1953 .76159 .1864 Metetra
.631 .697 .892 r
.76159 .1864 .76694 .1953 .77892 .192 .77359 .18304 Metetra
.633 .697 .891 r
.77359 .18304 .77892 .192 .79095 .18862 .78565 .1796 Metetra
.672 .721 .886 r
.13475 .50582 .14171 .51313 .15162 .50927 .14468 .50195 Metetra
.674 .722 .885 r
.14468 .50195 .15162 .50927 .16157 .50534 .15465 .49801 Metetra
.676 .723 .885 r
.15465 .49801 .16157 .50534 .17157 .50134 .16466 .494 Metetra
.678 .724 .884 r
.16466 .494 .17157 .50134 .1816 .49727 .17471 .48992 Metetra
.68 .725 .884 r
.17471 .48992 .1816 .49727 .19168 .49312 .18481 .48577 Metetra
.681 .726 .884 r
.18481 .48577 .19168 .49312 .20179 .48889 .19494 .48155 Metetra
.683 .727 .884 r
.19494 .48155 .20179 .48889 .21195 .48459 .20511 .47727 Metetra
.685 .729 .884 r
.20511 .47727 .21195 .48459 .22214 .48022 .21532 .47291 Metetra
.687 .731 .884 r
.21532 .47291 .22214 .48022 .23237 .47578 .22557 .4685 Metetra
.688 .733 .884 r
.22557 .4685 .23237 .47578 .24264 .47128 .23586 .46402 Metetra
.69 .734 .885 r
.23586 .46402 .24264 .47128 .25295 .46672 .24619 .45949 Metetra
.691 .736 .886 r
.24619 .45949 .25295 .46672 .26329 .46211 .25655 .45492 Metetra
.692 .738 .886 r
.25655 .45492 .26329 .46211 .27367 .45746 .26695 .45029 Metetra
.693 .74 .887 r
.26695 .45029 .27367 .45746 .28408 .45277 .27738 .44564 Metetra
.694 .742 .888 r
.27738 .44564 .28408 .45277 .29453 .44805 .28785 .44094 Metetra
.695 .744 .889 r
.28785 .44094 .29453 .44805 .30501 .4433 .29835 .43622 Metetra
.695 .746 .89 r
.29835 .43622 .30501 .4433 .31553 .43853 .30889 .43148 Metetra
.696 .748 .891 r
.30889 .43148 .31553 .43853 .32607 .43374 .31946 .42671 Metetra
.696 .749 .892 r
.31946 .42671 .32607 .43374 .33666 .42893 .33007 .42192 Metetra
.697 .751 .893 r
.33007 .42192 .33666 .42893 .34727 .42411 .34071 .41712 Metetra
.697 .752 .894 r
.34071 .41712 .34727 .42411 .35792 .41928 .35138 .4123 Metetra
.697 .753 .895 r
.35138 .4123 .35792 .41928 .36861 .41444 .36209 .40747 Metetra
.697 .755 .896 r
.36209 .40747 .36861 .41444 .37932 .40958 .37284 .40262 Metetra
.697 .756 .897 r
.37284 .40262 .37932 .40958 .39008 .40471 .38361 .39777 Metetra
.697 .757 .898 r
.38361 .39777 .39008 .40471 .40086 .39984 .39443 .39289 Metetra
.697 .758 .899 r
.39443 .39289 .40086 .39984 .41168 .39495 .40528 .38801 Metetra
.697 .759 .9 r
.40528 .38801 .41168 .39495 .42254 .39005 .41616 .38311 Metetra
.697 .76 .9 r
.41616 .38311 .42254 .39005 .43343 .38513 .42708 .3782 Metetra
.697 .761 .901 r
.42708 .3782 .43343 .38513 .44436 .3802 .43804 .37327 Metetra
.697 .762 .902 r
.43804 .37327 .44436 .3802 .45532 .37526 .44903 .36833 Metetra
.698 .763 .902 r
.44903 .36833 .45532 .37526 .46632 .37031 .46006 .36337 Metetra
.964 .716 .513 r
.46006 .36337 .46632 .37031 .47895 .25816 .47294 .25105 Metetra
.619 .725 .922 r
.47294 .25105 .47895 .25816 .48962 .25548 .48364 .24831 Metetra
.619 .724 .921 r
.48364 .24831 .48962 .25548 .50035 .25278 .49438 .24556 Metetra
.619 .723 .921 r
.49438 .24556 .50035 .25278 .51112 .25007 .50518 .24279 Metetra
.619 .722 .92 r
.50518 .24279 .51112 .25007 .52195 .24734 .51603 .24001 Metetra
.619 .721 .919 r
.51603 .24001 .52195 .24734 .53282 .24461 .52693 .23723 Metetra
.619 .72 .918 r
.52693 .23723 .53282 .24461 .54375 .24187 .53789 .23443 Metetra
.619 .719 .918 r
.53789 .23443 .54375 .24187 .55473 .23912 .54889 .23162 Metetra
.619 .718 .917 r
.54889 .23162 .55473 .23912 .56576 .23637 .55995 .2288 Metetra
.619 .717 .916 r
.55995 .2288 .56576 .23637 .57684 .2336 .57106 .22597 Metetra
.619 .716 .915 r
.57106 .22597 .57684 .2336 .58798 .23082 .58222 .22312 Metetra
.619 .715 .914 r
.58222 .22312 .58798 .23082 .59917 .22804 .59344 .22027 Metetra
.619 .713 .913 r
.59344 .22027 .59917 .22804 .61042 .22524 .60471 .2174 Metetra
.619 .712 .912 r
.60471 .2174 .61042 .22524 .62172 .22244 .61603 .21452 Metetra
.619 .711 .911 r
.61603 .21452 .62172 .22244 .63307 .21961 .62741 .21162 Metetra
.62 .71 .91 r
.62741 .21162 .63307 .21961 .64448 .21677 .63885 .2087 Metetra
.62 .708 .909 r
.63885 .2087 .64448 .21677 .65594 .21392 .65033 .20576 Metetra
.621 .707 .907 r
.65033 .20576 .65594 .21392 .66746 .21103 .66188 .20279 Metetra
.621 .706 .906 r
.66188 .20279 .66746 .21103 .67903 .20812 .67348 .19979 Metetra
.622 .704 .904 r
.67348 .19979 .67903 .20812 .69066 .20517 .68513 .19676 Metetra
.623 .703 .902 r
.68513 .19676 .69066 .20517 .70235 .20218 .69684 .19368 Metetra
.624 .702 .901 r
.69684 .19368 .70235 .20218 .71409 .19915 .70861 .19056 Metetra
.626 .701 .899 r
.70861 .19056 .71409 .19915 .72588 .19606 .72043 .18738 Metetra
.627 .7 .898 r
.72043 .18738 .72588 .19606 .73773 .1929 .7323 .18415 Metetra
.629 .699 .896 r
.7323 .18415 .73773 .1929 .74963 .18969 .74422 .18086 Metetra
.63 .699 .895 r
.74422 .18086 .74963 .18969 .76159 .1864 .7562 .1775 Metetra
.632 .699 .893 r
.7562 .1775 .76159 .1864 .77359 .18304 .76824 .17407 Metetra
.634 .699 .892 r
.76824 .17407 .77359 .18304 .78565 .1796 .78032 .17057 Metetra
.672 .723 .887 r
.12773 .49853 .13475 .50582 .14468 .50195 .13768 .49464 Metetra
.674 .723 .887 r
.13768 .49464 .14468 .50195 .15465 .49801 .14767 .49068 Metetra
.675 .724 .886 r
.14767 .49068 .15465 .49801 .16466 .494 .1577 .48667 Metetra
.677 .725 .886 r
.1577 .48667 .16466 .494 .17471 .48992 .16777 .48258 Metetra
.679 .726 .886 r
.16777 .48258 .17471 .48992 .18481 .48577 .17789 .47843 Metetra
.681 .727 .885 r
.17789 .47843 .18481 .48577 .19494 .48155 .18804 .47422 Metetra
.682 .729 .885 r
.18804 .47422 .19494 .48155 .20511 .47727 .19823 .46994 Metetra
.684 .73 .885 r
.19823 .46994 .20511 .47727 .21532 .47291 .20846 .4656 Metetra
.686 .732 .886 r
.20846 .4656 .21532 .47291 .22557 .4685 .21873 .46121 Metetra
.687 .733 .886 r
.21873 .46121 .22557 .4685 .23586 .46402 .22903 .45675 Metetra
.689 .735 .886 r
.22903 .45675 .23586 .46402 .24619 .45949 .23938 .45225 Metetra
.69 .737 .887 r
.23938 .45225 .24619 .45949 .25655 .45492 .24976 .4477 Metetra
.691 .739 .888 r
.24976 .4477 .25655 .45492 .26695 .45029 .26018 .4431 Metetra
.692 .741 .889 r
.26018 .4431 .26695 .45029 .27738 .44564 .27063 .43847 Metetra
.693 .742 .889 r
.27063 .43847 .27738 .44564 .28785 .44094 .28112 .4338 Metetra
.693 .744 .89 r
.28112 .4338 .28785 .44094 .29835 .43622 .29164 .4291 Metetra
.694 .746 .891 r
.29164 .4291 .29835 .43622 .30889 .43148 .3022 .42438 Metetra
.694 .747 .892 r
.3022 .42438 .30889 .43148 .31946 .42671 .3128 .41963 Metetra
.695 .749 .893 r
.3128 .41963 .31946 .42671 .33007 .42192 .32343 .41487 Metetra
.695 .75 .894 r
.32343 .41487 .33007 .42192 .34071 .41712 .33409 .41008 Metetra
.695 .752 .895 r
.33409 .41008 .34071 .41712 .35138 .4123 .34479 .40527 Metetra
.696 .753 .896 r
.34479 .40527 .35138 .4123 .36209 .40747 .35553 .40045 Metetra
.696 .754 .897 r
.35553 .40045 .36209 .40747 .37284 .40262 .3663 .39562 Metetra
.696 .755 .898 r
.3663 .39562 .37284 .40262 .38361 .39777 .37711 .39076 Metetra
.696 .757 .898 r
.37711 .39076 .38361 .39777 .39443 .39289 .38795 .3859 Metetra
.696 .758 .899 r
.38795 .3859 .39443 .39289 .40528 .38801 .39882 .38102 Metetra
.696 .759 .9 r
.39882 .38102 .40528 .38801 .41616 .38311 .40974 .37612 Metetra
.696 .76 .901 r
.40974 .37612 .41616 .38311 .42708 .3782 .42069 .37121 Metetra
.696 .761 .901 r
.42069 .37121 .42708 .3782 .43804 .37327 .43167 .36629 Metetra
.696 .762 .902 r
.43167 .36629 .43804 .37327 .44903 .36833 .44269 .36134 Metetra
.697 .763 .903 r
.44269 .36134 .44903 .36833 .46006 .36337 .45375 .35639 Metetra
.964 .716 .513 r
.45375 .35639 .46006 .36337 .47294 .25105 .46688 .24389 Metetra
.62 .725 .922 r
.46688 .24389 .47294 .25105 .48364 .24831 .4776 .24109 Metetra
.62 .724 .921 r
.4776 .24109 .48364 .24831 .49438 .24556 .48838 .23828 Metetra
.62 .723 .92 r
.48838 .23828 .49438 .24556 .50518 .24279 .4992 .23546 Metetra
.62 .723 .92 r
.4992 .23546 .50518 .24279 .51603 .24001 .51008 .23263 Metetra
.62 .722 .919 r
.51008 .23263 .51603 .24001 .52693 .23723 .521 .22978 Metetra
.62 .721 .918 r
.521 .22978 .52693 .23723 .53789 .23443 .53198 .22692 Metetra
.62 .72 .917 r
.53198 .22692 .53789 .23443 .54889 .23162 .54301 .22405 Metetra
.62 .719 .917 r
.54301 .22405 .54889 .23162 .55995 .2288 .5541 .22117 Metetra
.62 .718 .916 r
.5541 .22117 .55995 .2288 .57106 .22597 .56523 .21828 Metetra
.62 .716 .915 r
.56523 .21828 .57106 .22597 .58222 .22312 .57642 .21537 Metetra
.62 .715 .914 r
.57642 .21537 .58222 .22312 .59344 .22027 .58766 .21244 Metetra
.621 .714 .913 r
.58766 .21244 .59344 .22027 .60471 .2174 .59896 .20951 Metetra
.621 .713 .912 r
.59896 .20951 .60471 .2174 .61603 .21452 .61031 .20655 Metetra
.621 .712 .911 r
.61031 .20655 .61603 .21452 .62741 .21162 .62171 .20357 Metetra
.621 .711 .91 r
.62171 .20357 .62741 .21162 .63885 .2087 .63317 .20058 Metetra
.622 .709 .908 r
.63317 .20058 .63885 .2087 .65033 .20576 .64469 .19756 Metetra
.622 .708 .907 r
.64469 .19756 .65033 .20576 .66188 .20279 .65626 .19451 Metetra
.623 .707 .906 r
.65626 .19451 .66188 .20279 .67348 .19979 .66788 .19142 Metetra
.624 .706 .904 r
.66788 .19142 .67348 .19979 .68513 .19676 .67956 .18831 Metetra
.625 .705 .903 r
.67956 .18831 .68513 .19676 .69684 .19368 .6913 .18515 Metetra
.626 .704 .901 r
.6913 .18515 .69684 .19368 .70861 .19056 .70309 .18194 Metetra
.627 .703 .9 r
.70309 .18194 .70861 .19056 .72043 .18738 .71493 .17869 Metetra
.629 .702 .898 r
.71493 .17869 .72043 .18738 .7323 .18415 .72683 .17538 Metetra
.63 .701 .897 r
.72683 .17538 .7323 .18415 .74422 .18086 .73878 .17201 Metetra
.632 .701 .896 r
.73878 .17201 .74422 .18086 .7562 .1775 .75079 .16859 Metetra
.633 .701 .894 r
.75079 .16859 .7562 .1775 .76824 .17407 .76285 .16509 Metetra
.635 .701 .893 r
.76285 .16509 .76824 .17407 .78032 .17057 .77496 .16153 Metetra
.672 .724 .889 r
.12067 .49123 .12773 .49853 .13768 .49464 .13064 .48733 Metetra
.674 .725 .888 r
.13064 .48733 .13768 .49464 .14767 .49068 .14065 .48336 Metetra
.675 .726 .888 r
.14065 .48336 .14767 .49068 .1577 .48667 .1507 .47934 Metetra
.677 .727 .887 r
.1507 .47934 .1577 .48667 .16777 .48258 .16079 .47525 Metetra
.678 .728 .887 r
.16079 .47525 .16777 .48258 .17789 .47843 .17091 .4711 Metetra
.68 .729 .887 r
.17091 .4711 .17789 .47843 .18804 .47422 .18108 .46689 Metetra
.682 .73 .887 r
.18108 .46689 .18804 .47422 .19823 .46994 .19129 .46262 Metetra
.683 .731 .887 r
.19129 .46262 .19823 .46994 .20846 .4656 .20154 .45829 Metetra
.685 .733 .887 r
.20154 .45829 .20846 .4656 .21873 .46121 .21183 .45391 Metetra
.686 .734 .887 r
.21183 .45391 .21873 .46121 .22903 .45675 .22216 .44947 Metetra
.687 .736 .888 r
.22216 .44947 .22903 .45675 .23938 .45225 .23252 .44498 Metetra
.688 .738 .888 r
.23252 .44498 .23938 .45225 .24976 .4477 .24292 .44045 Metetra
.689 .739 .889 r
.24292 .44045 .24976 .4477 .26018 .4431 .25336 .43588 Metetra
.69 .741 .89 r
.25336 .43588 .26018 .4431 .27063 .43847 .26383 .43127 Metetra
.691 .743 .891 r
.26383 .43127 .27063 .43847 .28112 .4338 .27434 .42662 Metetra
.692 .744 .891 r
.27434 .42662 .28112 .4338 .29164 .4291 .28489 .42195 Metetra
.693 .746 .892 r
.28489 .42195 .29164 .4291 .3022 .42438 .29547 .41724 Metetra
.693 .747 .893 r
.29547 .41724 .3022 .42438 .3128 .41963 .30609 .41251 Metetra
.693 .749 .894 r
.30609 .41251 .3128 .41963 .32343 .41487 .31675 .40776 Metetra
.694 .75 .895 r
.31675 .40776 .32343 .41487 .33409 .41008 .32744 .40299 Metetra
.694 .751 .896 r
.32744 .40299 .33409 .41008 .34479 .40527 .33816 .39819 Metetra
.694 .753 .897 r
.33816 .39819 .34479 .40527 .35553 .40045 .34892 .39338 Metetra
.695 .754 .897 r
.34892 .39338 .35553 .40045 .3663 .39562 .35972 .38855 Metetra
.695 .755 .898 r
.35972 .38855 .3663 .39562 .37711 .39076 .37055 .38371 Metetra
.695 .756 .899 r
.37055 .38371 .37711 .39076 .38795 .3859 .38142 .37885 Metetra
.695 .757 .9 r
.38142 .37885 .38795 .3859 .39882 .38102 .39232 .37397 Metetra
.695 .758 .9 r
.39232 .37397 .39882 .38102 .40974 .37612 .40326 .36908 Metetra
.695 .759 .901 r
.40326 .36908 .40974 .37612 .42069 .37121 .41424 .36417 Metetra
.695 .76 .902 r
.41424 .36417 .42069 .37121 .43167 .36629 .42526 .35925 Metetra
.696 .761 .903 r
.42526 .35925 .43167 .36629 .44269 .36134 .43631 .35431 Metetra
.696 .762 .903 r
.43631 .35431 .44269 .36134 .45375 .35639 .4474 .34935 Metetra
.964 .716 .513 r
.4474 .34935 .45375 .35639 .46688 .24389 .46078 .23667 Metetra
.621 .726 .921 r
.46078 .23667 .46688 .24389 .4776 .24109 .47153 .23382 Metetra
.621 .725 .921 r
.47153 .23382 .4776 .24109 .48838 .23828 .48233 .23096 Metetra
.621 .724 .92 r
.48233 .23096 .48838 .23828 .4992 .23546 .49318 .22808 Metetra
.621 .723 .919 r
.49318 .22808 .4992 .23546 .51008 .23263 .50408 .22519 Metetra
.621 .722 .918 r
.50408 .22519 .51008 .23263 .521 .22978 .51503 .22228 Metetra
.621 .721 .918 r
.51503 .22228 .521 .22978 .53198 .22692 .52604 .21936 Metetra
.622 .72 .917 r
.52604 .21936 .53198 .22692 .54301 .22405 .53709 .21643 Metetra
.622 .719 .916 r
.53709 .21643 .54301 .22405 .5541 .22117 .5482 .21349 Metetra
.622 .718 .915 r
.5482 .21349 .5541 .22117 .56523 .21828 .55936 .21053 Metetra
.622 .717 .914 r
.55936 .21053 .56523 .21828 .57642 .21537 .57058 .20755 Metetra
.622 .716 .913 r
.57058 .20755 .57642 .21537 .58766 .21244 .58185 .20456 Metetra
.622 .715 .913 r
.58185 .20456 .58766 .21244 .59896 .20951 .59317 .20155 Metetra
.622 .714 .911 r
.59317 .20155 .59896 .20951 .61031 .20655 .60454 .19853 Metetra
.623 .713 .91 r
.60454 .19853 .61031 .20655 .62171 .20357 .61597 .19548 Metetra
.623 .711 .909 r
.61597 .19548 .62171 .20357 .63317 .20058 .62746 .19241 Metetra
.624 .71 .908 r
.62746 .19241 .63317 .20058 .64469 .19756 .639 .18931 Metetra
.624 .709 .907 r
.639 .18931 .64469 .19756 .65626 .19451 .6506 .18618 Metetra
.625 .708 .906 r
.6506 .18618 .65626 .19451 .66788 .19142 .66225 .18302 Metetra
.626 .707 .904 r
.66225 .18302 .66788 .19142 .67956 .18831 .67395 .17982 Metetra
.627 .706 .903 r
.67395 .17982 .67956 .18831 .6913 .18515 .68571 .17659 Metetra
.628 .705 .902 r
.68571 .17659 .6913 .18515 .70309 .18194 .69753 .1733 Metetra
.629 .704 .9 r
.69753 .1733 .70309 .18194 .71493 .17869 .7094 .16997 Metetra
.63 .704 .899 r
.7094 .16997 .71493 .17869 .72683 .17538 .72133 .16659 Metetra
.631 .703 .898 r
.72133 .16659 .72683 .17538 .73878 .17201 .73331 .16315 Metetra
.633 .703 .896 r
.73331 .16315 .73878 .17201 .75079 .16859 .74534 .15966 Metetra
.634 .703 .895 r
.74534 .15966 .75079 .16859 .76285 .16509 .75743 .1561 Metetra
.636 .702 .894 r
.75743 .1561 .76285 .16509 .77496 .16153 .76957 .15249 Metetra
.672 .725 .89 r
.11356 .48393 .12067 .49123 .13064 .48733 .12354 .48002 Metetra
.673 .726 .889 r
.12354 .48002 .13064 .48733 .14065 .48336 .13357 .47604 Metetra
.675 .727 .889 r
.13357 .47604 .14065 .48336 .1507 .47934 .14364 .472 Metetra
.676 .728 .889 r
.14364 .472 .1507 .47934 .16079 .47525 .15374 .46791 Metetra
.678 .729 .888 r
.15374 .46791 .16079 .47525 .17091 .4711 .16389 .46376 Metetra
.679 .73 .888 r
.16389 .46376 .17091 .4711 .18108 .46689 .17408 .45955 Metetra
.681 .731 .888 r
.17408 .45955 .18108 .46689 .19129 .46262 .18431 .45529 Metetra
.682 .732 .888 r
.18431 .45529 .19129 .46262 .20154 .45829 .19458 .45097 Metetra
.684 .734 .889 r
.19458 .45097 .20154 .45829 .21183 .45391 .20488 .4466 Metetra
.685 .735 .889 r
.20488 .4466 .21183 .45391 .22216 .44947 .21523 .44217 Metetra
.686 .737 .889 r
.21523 .44217 .22216 .44947 .23252 .44498 .22561 .4377 Metetra
.687 .738 .89 r
.22561 .4377 .23252 .44498 .24292 .44045 .23603 .43319 Metetra
.688 .74 .89 r
.23603 .43319 .24292 .44045 .25336 .43588 .24649 .42863 Metetra
.689 .741 .891 r
.24649 .42863 .25336 .43588 .26383 .43127 .25699 .42404 Metetra
.69 .743 .892 r
.25699 .42404 .26383 .43127 .27434 .42662 .26752 .41941 Metetra
.691 .744 .892 r
.26752 .41941 .27434 .42662 .28489 .42195 .27809 .41475 Metetra
.691 .746 .893 r
.27809 .41475 .28489 .42195 .29547 .41724 .28869 .41006 Metetra
.692 .747 .894 r
.28869 .41006 .29547 .41724 .30609 .41251 .29934 .40535 Metetra
.692 .749 .895 r
.29934 .40535 .30609 .41251 .31675 .40776 .31001 .40061 Metetra
.693 .75 .896 r
.31001 .40061 .31675 .40776 .32744 .40299 .32073 .39585 Metetra
.693 .751 .896 r
.32073 .39585 .32744 .40299 .33816 .39819 .33148 .39107 Metetra
.693 .753 .897 r
.33148 .39107 .33816 .39819 .34892 .39338 .34226 .38626 Metetra
.693 .754 .898 r
.34226 .38626 .34892 .39338 .35972 .38855 .35309 .38144 Metetra
.694 .755 .899 r
.35309 .38144 .35972 .38855 .37055 .38371 .36395 .3766 Metetra
.694 .756 .899 r
.36395 .3766 .37055 .38371 .38142 .37885 .37484 .37175 Metetra
.694 .757 .9 r
.37484 .37175 .38142 .37885 .39232 .37397 .38577 .36687 Metetra
.694 .758 .901 r
.38577 .36687 .39232 .37397 .40326 .36908 .39674 .36198 Metetra
.694 .759 .902 r
.39674 .36198 .40326 .36908 .41424 .36417 .40775 .35708 Metetra
.694 .76 .902 r
.40775 .35708 .41424 .36417 .42526 .35925 .41879 .35215 Metetra
.695 .761 .903 r
.41879 .35215 .42526 .35925 .43631 .35431 .42987 .34721 Metetra
.695 .762 .904 r
.42987 .34721 .43631 .35431 .4474 .34935 .44099 .34226 Metetra
.964 .716 .513 r
.44099 .34226 .4474 .34935 .46078 .23667 .45463 .2294 Metetra
.622 .726 .921 r
.45463 .2294 .46078 .23667 .47153 .23382 .46541 .2265 Metetra
.623 .725 .92 r
.46541 .2265 .47153 .23382 .48233 .23096 .47623 .22357 Metetra
.623 .724 .92 r
.47623 .22357 .48233 .23096 .49318 .22808 .48711 .22064 Metetra
.623 .723 .919 r
.48711 .22064 .49318 .22808 .50408 .22519 .49804 .21769 Metetra
.623 .723 .918 r
.49804 .21769 .50408 .22519 .51503 .22228 .50901 .21472 Metetra
.623 .722 .917 r
.50901 .21472 .51503 .22228 .52604 .21936 .52004 .21175 Metetra
.623 .721 .917 r
.52004 .21175 .52604 .21936 .53709 .21643 .53113 .20876 Metetra
.623 .72 .916 r
.53113 .20876 .53709 .21643 .5482 .21349 .54226 .20575 Metetra
.623 .719 .915 r
.54226 .20575 .5482 .21349 .55936 .21053 .55345 .20272 Metetra
.623 .718 .914 r
.55345 .20272 .55936 .21053 .57058 .20755 .56469 .19969 Metetra
.623 .717 .913 r
.56469 .19969 .57058 .20755 .58185 .20456 .57599 .19663 Metetra
.624 .716 .912 r
.57599 .19663 .58185 .20456 .59317 .20155 .58733 .19355 Metetra
.624 .715 .911 r
.58733 .19355 .59317 .20155 .60454 .19853 .59874 .19045 Metetra
.624 .713 .91 r
.59874 .19045 .60454 .19853 .61597 .19548 .61019 .18733 Metetra
.625 .712 .909 r
.61019 .18733 .61597 .19548 .62746 .19241 .62171 .18419 Metetra
.625 .711 .908 r
.62171 .18419 .62746 .19241 .639 .18931 .63327 .18101 Metetra
.626 .71 .907 r
.63327 .18101 .639 .18931 .6506 .18618 .6449 .17781 Metetra
.626 .709 .906 r
.6449 .17781 .6506 .18618 .66225 .18302 .65657 .17458 Metetra
.627 .708 .904 r
.65657 .17458 .66225 .18302 .67395 .17982 .66831 .1713 Metetra
.628 .708 .903 r
.66831 .1713 .67395 .17982 .68571 .17659 .68009 .16799 Metetra
.629 .707 .902 r
.68009 .16799 .68571 .17659 .69753 .1733 .69194 .16463 Metetra
.63 .706 .901 r
.69194 .16463 .69753 .1733 .7094 .16997 .70383 .16123 Metetra
.631 .705 .899 r
.70383 .16123 .7094 .16997 .72133 .16659 .71578 .15778 Metetra
.633 .705 .898 r
.71578 .15778 .72133 .16659 .73331 .16315 .72779 .15427 Metetra
.634 .705 .897 r
.72779 .15427 .73331 .16315 .74534 .15966 .73985 .15071 Metetra
.635 .704 .896 r
.73985 .15071 .74534 .15966 .75743 .1561 .75197 .14709 Metetra
.637 .704 .895 r
.75197 .14709 .75743 .1561 .76957 .15249 .76414 .14342 Metetra
.671 .726 .891 r
.10639 .47663 .11356 .48393 .12354 .48002 .11639 .4727 Metetra
.673 .727 .891 r
.11639 .4727 .12354 .48002 .13357 .47604 .12644 .46871 Metetra
.674 .728 .89 r
.12644 .46871 .13357 .47604 .14364 .472 .13652 .46467 Metetra
.676 .729 .89 r
.13652 .46467 .14364 .472 .15374 .46791 .14665 .46057 Metetra
.677 .73 .89 r
.14665 .46057 .15374 .46791 .16389 .46376 .15682 .45642 Metetra
.679 .731 .89 r
.15682 .45642 .16389 .46376 .17408 .45955 .16703 .45221 Metetra
.68 .732 .89 r
.16703 .45221 .17408 .45955 .18431 .45529 .17727 .44795 Metetra
.681 .733 .89 r
.17727 .44795 .18431 .45529 .19458 .45097 .18756 .44363 Metetra
.683 .735 .89 r
.18756 .44363 .19458 .45097 .20488 .4466 .19789 .43927 Metetra
.684 .736 .89 r
.19789 .43927 .20488 .4466 .21523 .44217 .20825 .43486 Metetra
.685 .737 .891 r
.20825 .43486 .21523 .44217 .22561 .4377 .21865 .4304 Metetra
.686 .739 .891 r
.21865 .4304 .22561 .4377 .23603 .43319 .2291 .4259 Metetra
.687 .74 .892 r
.2291 .4259 .23603 .43319 .24649 .42863 .23957 .42136 Metetra
.688 .742 .892 r
.23957 .42136 .24649 .42863 .25699 .42404 .25009 .41678 Metetra
.689 .743 .893 r
.25009 .41678 .25699 .42404 .26752 .41941 .26065 .41217 Metetra
.689 .744 .893 r
.26065 .41217 .26752 .41941 .27809 .41475 .27124 .40752 Metetra
.69 .746 .894 r
.27124 .40752 .27809 .41475 .28869 .41006 .28187 .40285 Metetra
.69 .747 .895 r
.28187 .40285 .28869 .41006 .29934 .40535 .29253 .39814 Metetra
.691 .749 .896 r
.29253 .39814 .29934 .40535 .31001 .40061 .30323 .39342 Metetra
.691 .75 .896 r
.30323 .39342 .31001 .40061 .32073 .39585 .31397 .38866 Metetra
.692 .751 .897 r
.31397 .38866 .32073 .39585 .33148 .39107 .32475 .38389 Metetra
.692 .752 .898 r
.32475 .38389 .33148 .39107 .34226 .38626 .33556 .37909 Metetra
.692 .753 .899 r
.33556 .37909 .34226 .38626 .35309 .38144 .34641 .37428 Metetra
.693 .755 .899 r
.34641 .37428 .35309 .38144 .36395 .3766 .35729 .36945 Metetra
.693 .756 .9 r
.35729 .36945 .36395 .3766 .37484 .37175 .36822 .36459 Metetra
.693 .757 .901 r
.36822 .36459 .37484 .37175 .38577 .36687 .37918 .35972 Metetra
.693 .758 .901 r
.37918 .35972 .38577 .36687 .39674 .36198 .39017 .35483 Metetra
.693 .759 .902 r
.39017 .35483 .39674 .36198 .40775 .35708 .40121 .34993 Metetra
.693 .76 .903 r
.40121 .34993 .40775 .35708 .41879 .35215 .41228 .34501 Metetra
.694 .761 .903 r
.41228 .34501 .41879 .35215 .42987 .34721 .42339 .34007 Metetra
.694 .762 .904 r
.42339 .34007 .42987 .34721 .44099 .34226 .43454 .33511 Metetra
.964 .716 .513 r
.43454 .33511 .44099 .34226 .45463 .2294 .44844 .22208 Metetra
.624 .727 .921 r
.44844 .22208 .45463 .2294 .46541 .2265 .45924 .21912 Metetra
.624 .726 .92 r
.45924 .21912 .46541 .2265 .47623 .22357 .47009 .21614 Metetra
.624 .725 .919 r
.47009 .21614 .47623 .22357 .48711 .22064 .481 .21314 Metetra
.624 .724 .918 r
.481 .21314 .48711 .22064 .49804 .21769 .49195 .21014 Metetra
.624 .723 .918 r
.49195 .21014 .49804 .21769 .50901 .21472 .50295 .20711 Metetra
.624 .722 .917 r
.50295 .20711 .50901 .21472 .52004 .21175 .51401 .20408 Metetra
.624 .721 .916 r
.51401 .20408 .52004 .21175 .53113 .20876 .52512 .20102 Metetra
.624 .72 .915 r
.52512 .20102 .53113 .20876 .54226 .20575 .53628 .19795 Metetra
.624 .719 .915 r
.53628 .19795 .54226 .20575 .55345 .20272 .54749 .19487 Metetra
.625 .718 .914 r
.54749 .19487 .55345 .20272 .56469 .19969 .55876 .19176 Metetra
.625 .717 .913 r
.55876 .19176 .56469 .19969 .57599 .19663 .57008 .18864 Metetra
.625 .716 .912 r
.57008 .18864 .57599 .19663 .58733 .19355 .58146 .18549 Metetra
.625 .715 .911 r
.58146 .18549 .58733 .19355 .59874 .19045 .59289 .18233 Metetra
.626 .714 .91 r
.59289 .18233 .59874 .19045 .61019 .18733 .60437 .17914 Metetra
.626 .713 .909 r
.60437 .17914 .61019 .18733 .62171 .18419 .61591 .17592 Metetra
.627 .712 .908 r
.61591 .17592 .62171 .18419 .63327 .18101 .62751 .17268 Metetra
.627 .711 .907 r
.62751 .17268 .63327 .18101 .6449 .17781 .63915 .1694 Metetra
.628 .711 .906 r
.63915 .1694 .6449 .17781 .65657 .17458 .65086 .16609 Metetra
.629 .71 .904 r
.65086 .16609 .65657 .17458 .66831 .1713 .66262 .16275 Metetra
.63 .709 .903 r
.66262 .16275 .66831 .1713 .68009 .16799 .67443 .15936 Metetra
.631 .708 .902 r
.67443 .15936 .68009 .16799 .69194 .16463 .6863 .15593 Metetra
.632 .707 .901 r
.6863 .15593 .69194 .16463 .70383 .16123 .69823 .15246 Metetra
.633 .707 .9 r
.69823 .15246 .70383 .16123 .71578 .15778 .71021 .14894 Metetra
.634 .706 .899 r
.71021 .14894 .71578 .15778 .72779 .15427 .72224 .14537 Metetra
.635 .706 .898 r
.72224 .14537 .72779 .15427 .73985 .15071 .73433 .14174 Metetra
.636 .706 .897 r
.73433 .14174 .73985 .15071 .75197 .14709 .74648 .13806 Metetra
.638 .706 .896 r
.74648 .13806 .75197 .14709 .76414 .14342 .75867 .13433 Metetra
.671 .728 .892 r
.09917 .46932 .10639 .47663 .11639 .4727 .10919 .46538 Metetra
.672 .728 .892 r
.10919 .46538 .11639 .4727 .12644 .46871 .11926 .46138 Metetra
.674 .729 .891 r
.11926 .46138 .12644 .46871 .13652 .46467 .12936 .45733 Metetra
.675 .73 .891 r
.12936 .45733 .13652 .46467 .14665 .46057 .13951 .45322 Metetra
.677 .731 .891 r
.13951 .45322 .14665 .46057 .15682 .45642 .14969 .44907 Metetra
.678 .732 .891 r
.14969 .44907 .15682 .45642 .16703 .45221 .15992 .44486 Metetra
.679 .733 .891 r
.15992 .44486 .16703 .45221 .17727 .44795 .17019 .4406 Metetra
.68 .734 .891 r
.17019 .4406 .17727 .44795 .18756 .44363 .18049 .43629 Metetra
.682 .735 .891 r
.18049 .43629 .18756 .44363 .19789 .43927 .19084 .43193 Metetra
.683 .737 .892 r
.19084 .43193 .19789 .43927 .20825 .43486 .20122 .42752 Metetra
.684 .738 .892 r
.20122 .42752 .20825 .43486 .21865 .4304 .21164 .42308 Metetra
.685 .739 .892 r
.21164 .42308 .21865 .4304 .2291 .4259 .22211 .41858 Metetra
.686 .741 .893 r
.22211 .41858 .2291 .4259 .23957 .42136 .23261 .41405 Metetra
.687 .742 .893 r
.23261 .41405 .23957 .42136 .25009 .41678 .24315 .40949 Metetra
.687 .743 .894 r
.24315 .40949 .25009 .41678 .26065 .41217 .25372 .40489 Metetra
.688 .745 .894 r
.25372 .40489 .26065 .41217 .27124 .40752 .26434 .40025 Metetra
.689 .746 .895 r
.26434 .40025 .27124 .40752 .28187 .40285 .27499 .39559 Metetra
.689 .747 .896 r
.27499 .39559 .28187 .40285 .29253 .39814 .28568 .39089 Metetra
.69 .749 .896 r
.28568 .39089 .29253 .39814 .30323 .39342 .2964 .38618 Metetra
.69 .75 .897 r
.2964 .38618 .30323 .39342 .31397 .38866 .30717 .38143 Metetra
.691 .751 .898 r
.30717 .38143 .31397 .38866 .32475 .38389 .31797 .37667 Metetra
.691 .752 .898 r
.31797 .37667 .32475 .38389 .33556 .37909 .3288 .37188 Metetra
.691 .753 .899 r
.3288 .37188 .33556 .37909 .34641 .37428 .33968 .36707 Metetra
.691 .754 .9 r
.33968 .36707 .34641 .37428 .35729 .36945 .35059 .36224 Metetra
.692 .755 .901 r
.35059 .36224 .35729 .36945 .36822 .36459 .36154 .35739 Metetra
.692 .757 .901 r
.36154 .35739 .36822 .36459 .37918 .35972 .37253 .35252 Metetra
.692 .758 .902 r
.37253 .35252 .37918 .35972 .39017 .35483 .38356 .34763 Metetra
.692 .759 .903 r
.38356 .34763 .39017 .35483 .40121 .34993 .39462 .34273 Metetra
.692 .76 .903 r
.39462 .34273 .40121 .34993 .41228 .34501 .40572 .33781 Metetra
.693 .761 .904 r
.40572 .33781 .41228 .34501 .42339 .34007 .41686 .33287 Metetra
.693 .762 .905 r
.41686 .33287 .42339 .34007 .43454 .33511 .42804 .32791 Metetra
.964 .716 .513 r
.42804 .32791 .43454 .33511 .44844 .22208 .4422 .21471 Metetra
.625 .727 .92 r
.4422 .21471 .44844 .22208 .45924 .21912 .45303 .21168 Metetra
.625 .726 .92 r
.45303 .21168 .45924 .21912 .47009 .21614 .46391 .20865 Metetra
.625 .725 .919 r
.46391 .20865 .47009 .21614 .481 .21314 .47484 .2056 Metetra
.625 .724 .918 r
.47484 .2056 .481 .21314 .49195 .21014 .48582 .20253 Metetra
.625 .724 .917 r
.48582 .20253 .49195 .21014 .50295 .20711 .49685 .19945 Metetra
.625 .723 .917 r
.49685 .19945 .50295 .20711 .51401 .20408 .50793 .19635 Metetra
.625 .722 .916 r
.50793 .19635 .51401 .20408 .52512 .20102 .51907 .19324 Metetra
.626 .721 .915 r
.51907 .19324 .52512 .20102 .53628 .19795 .53025 .1901 Metetra
.626 .72 .914 r
.53025 .1901 .53628 .19795 .54749 .19487 .5415 .18696 Metetra
.626 .719 .913 r
.5415 .18696 .54749 .19487 .55876 .19176 .55279 .18379 Metetra
.626 .718 .913 r
.55279 .18379 .55876 .19176 .57008 .18864 .56414 .1806 Metetra
.626 .717 .912 r
.56414 .1806 .57008 .18864 .58146 .18549 .57554 .17739 Metetra
.627 .716 .911 r
.57554 .17739 .58146 .18549 .59289 .18233 .587 .17415 Metetra
.627 .715 .91 r
.587 .17415 .59289 .18233 .60437 .17914 .59851 .17089 Metetra
.628 .714 .909 r
.59851 .17089 .60437 .17914 .61591 .17592 .61007 .16761 Metetra
.628 .713 .908 r
.61007 .16761 .61591 .17592 .62751 .17268 .6217 .16429 Metetra
.629 .713 .907 r
.6217 .16429 .62751 .17268 .63915 .1694 .63337 .16095 Metetra
.629 .712 .906 r
.63337 .16095 .63915 .1694 .65086 .16609 .6451 .15757 Metetra
.63 .711 .905 r
.6451 .15757 .65086 .16609 .66262 .16275 .65689 .15415 Metetra
.631 .71 .903 r
.65689 .15415 .66262 .16275 .67443 .15936 .66873 .15069 Metetra
.632 .709 .902 r
.66873 .15069 .67443 .15936 .6863 .15593 .68063 .1472 Metetra
.633 .709 .901 r
.68063 .1472 .6863 .15593 .69823 .15246 .69258 .14366 Metetra
.634 .708 .9 r
.69258 .14366 .69823 .15246 .71021 .14894 .70459 .14007 Metetra
.635 .708 .899 r
.70459 .14007 .71021 .14894 .72224 .14537 .71665 .13643 Metetra
.636 .708 .898 r
.71665 .13643 .72224 .14537 .73433 .14174 .72877 .13275 Metetra
.637 .707 .897 r
.72877 .13275 .73433 .14174 .74648 .13806 .74094 .12901 Metetra
.638 .707 .896 r
.74094 .12901 .74648 .13806 .75867 .13433 .75317 .12521 Metetra
.671 .729 .893 r
.0919 .462 .09917 .46932 .10919 .46538 .10194 .45804 Metetra
.672 .729 .893 r
.10194 .45804 .10919 .46538 .11926 .46138 .11202 .45403 Metetra
.673 .73 .893 r
.11202 .45403 .11926 .46138 .12936 .45733 .12214 .44997 Metetra
.675 .731 .892 r
.12214 .44997 .12936 .45733 .13951 .45322 .13231 .44586 Metetra
.676 .732 .892 r
.13231 .44586 .13951 .45322 .14969 .44907 .14251 .4417 Metetra
.677 .733 .892 r
.14251 .4417 .14969 .44907 .15992 .44486 .15276 .43749 Metetra
.678 .734 .892 r
.15276 .43749 .15992 .44486 .17019 .4406 .16304 .43323 Metetra
.68 .735 .892 r
.16304 .43323 .17019 .4406 .18049 .43629 .17337 .42892 Metetra
.681 .736 .892 r
.17337 .42892 .18049 .43629 .19084 .43193 .18374 .42457 Metetra
.682 .737 .893 r
.18374 .42457 .19084 .43193 .20122 .42752 .19414 .42017 Metetra
.683 .738 .893 r
.19414 .42017 .20122 .42752 .21164 .42308 .20458 .41573 Metetra
.684 .74 .893 r
.20458 .41573 .21164 .42308 .22211 .41858 .21507 .41124 Metetra
.685 .741 .894 r
.21507 .41124 .22211 .41858 .23261 .41405 .22559 .40672 Metetra
.686 .742 .894 r
.22559 .40672 .23261 .41405 .24315 .40949 .23615 .40216 Metetra
.686 .744 .895 r
.23615 .40216 .24315 .40949 .25372 .40489 .24675 .39757 Metetra
.687 .745 .895 r
.24675 .39757 .25372 .40489 .26434 .40025 .25738 .39294 Metetra
.688 .746 .896 r
.25738 .39294 .26434 .40025 .27499 .39559 .26806 .38829 Metetra
.688 .747 .896 r
.26806 .38829 .27499 .39559 .28568 .39089 .27877 .3836 Metetra
.689 .749 .897 r
.27877 .3836 .28568 .39089 .2964 .38618 .28952 .37889 Metetra
.689 .75 .898 r
.28952 .37889 .2964 .38618 .30717 .38143 .30031 .37416 Metetra
.689 .751 .898 r
.30031 .37416 .30717 .38143 .31797 .37667 .31114 .36939 Metetra
.69 .752 .899 r
.31114 .36939 .31797 .37667 .3288 .37188 .322 .36461 Metetra
.69 .753 .9 r
.322 .36461 .3288 .37188 .33968 .36707 .3329 .35981 Metetra
.69 .754 .9 r
.3329 .35981 .33968 .36707 .35059 .36224 .34384 .35498 Metetra
.691 .755 .901 r
.34384 .35498 .35059 .36224 .36154 .35739 .35482 .35013 Metetra
.691 .756 .902 r
.35482 .35013 .36154 .35739 .37253 .35252 .36583 .34527 Metetra
.691 .757 .902 r
.36583 .34527 .37253 .35252 .38356 .34763 .37689 .34038 Metetra
.691 .758 .903 r
.37689 .34038 .38356 .34763 .39462 .34273 .38798 .33548 Metetra
.691 .759 .904 r
.38798 .33548 .39462 .34273 .40572 .33781 .39911 .33055 Metetra
.692 .76 .904 r
.39911 .33055 .40572 .33781 .41686 .33287 .41028 .32561 Metetra
.692 .761 .905 r
.41028 .32561 .41686 .33287 .42804 .32791 .42149 .32065 Metetra
.964 .716 .513 r
.42149 .32065 .42804 .32791 .4422 .21471 .43592 .20727 Metetra
.626 .728 .92 r
.43592 .20727 .4422 .21471 .45303 .21168 .44677 .2042 Metetra
.626 .727 .919 r
.44677 .2042 .45303 .21168 .46391 .20865 .45768 .2011 Metetra
.626 .726 .919 r
.45768 .2011 .46391 .20865 .47484 .2056 .46863 .19799 Metetra
.626 .725 .918 r
.46863 .19799 .47484 .2056 .48582 .20253 .47964 .19487 Metetra
.626 .724 .917 r
.47964 .19487 .48582 .20253 .49685 .19945 .4907 .19173 Metetra
.627 .723 .916 r
.4907 .19173 .49685 .19945 .50793 .19635 .50181 .18857 Metetra
.627 .722 .916 r
.50181 .18857 .50793 .19635 .51907 .19324 .51297 .18539 Metetra
.627 .721 .915 r
.51297 .18539 .51907 .19324 .53025 .1901 .52418 .1822 Metetra
.627 .721 .914 r
.52418 .1822 .53025 .1901 .5415 .18696 .53545 .17899 Metetra
.627 .72 .913 r
.53545 .17899 .5415 .18696 .55279 .18379 .54677 .17576 Metetra
.627 .719 .912 r
.54677 .17576 .55279 .18379 .56414 .1806 .55815 .1725 Metetra
.628 .718 .911 r
.55815 .1725 .56414 .1806 .57554 .17739 .56958 .16923 Metetra
.628 .717 .911 r
.56958 .16923 .57554 .17739 .587 .17415 .58106 .16593 Metetra
.629 .716 .91 r
.58106 .16593 .587 .17415 .59851 .17089 .5926 .1626 Metetra
.629 .715 .909 r
.5926 .1626 .59851 .17089 .61007 .16761 .6042 .15925 Metetra
.629 .714 .908 r
.6042 .15925 .61007 .16761 .6217 .16429 .61584 .15586 Metetra
.63 .714 .907 r
.61584 .15586 .6217 .16429 .63337 .16095 .62755 .15245 Metetra
.631 .713 .906 r
.62755 .15245 .63337 .16095 .6451 .15757 .63931 .149 Metetra
.631 .712 .905 r
.63931 .149 .6451 .15757 .65689 .15415 .65112 .14551 Metetra
.632 .711 .904 r
.65112 .14551 .65689 .15415 .66873 .15069 .66299 .14199 Metetra
.633 .711 .903 r
.66299 .14199 .66873 .15069 .68063 .1472 .67492 .13843 Metetra
.634 .71 .902 r
.67492 .13843 .68063 .1472 .69258 .14366 .6869 .13482 Metetra
.635 .71 .901 r
.6869 .13482 .69258 .14366 .70459 .14007 .69893 .13117 Metetra
.636 .709 .9 r
.69893 .13117 .70459 .14007 .71665 .13643 .71103 .12747 Metetra
.637 .709 .899 r
.71103 .12747 .71665 .13643 .72877 .13275 .72317 .12372 Metetra
.638 .709 .898 r
.72317 .12372 .72877 .13275 .74094 .12901 .73538 .11992 Metetra
.639 .708 .897 r
.73538 .11992 .74094 .12901 .75317 .12521 .74763 .11607 Metetra
.67 .73 .894 r
.08457 .45467 .0919 .462 .10194 .45804 .09463 .4507 Metetra
.672 .73 .894 r
.09463 .4507 .10194 .45804 .11202 .45403 .10473 .44668 Metetra
.673 .731 .894 r
.10473 .44668 .11202 .45403 .12214 .44997 .11488 .44261 Metetra
.674 .732 .893 r
.11488 .44261 .12214 .44997 .13231 .44586 .12506 .43849 Metetra
.675 .733 .893 r
.12506 .43849 .13231 .44586 .14251 .4417 .13528 .43432 Metetra
.677 .734 .893 r
.13528 .43432 .14251 .4417 .15276 .43749 .14555 .43011 Metetra
.678 .735 .893 r
.14555 .43011 .15276 .43749 .16304 .43323 .15585 .42585 Metetra
.679 .736 .893 r
.15585 .42585 .16304 .43323 .17337 .42892 .1662 .42154 Metetra
.68 .737 .894 r
.1662 .42154 .17337 .42892 .18374 .42457 .17658 .41718 Metetra
.681 .738 .894 r
.17658 .41718 .18374 .42457 .19414 .42017 .18701 .41279 Metetra
.682 .739 .894 r
.18701 .41279 .19414 .42017 .20458 .41573 .19747 .40835 Metetra
.683 .74 .894 r
.19747 .40835 .20458 .41573 .21507 .41124 .20798 .40387 Metetra
.684 .741 .895 r
.20798 .40387 .21507 .41124 .22559 .40672 .21852 .39936 Metetra
.684 .743 .895 r
.21852 .39936 .22559 .40672 .23615 .40216 .2291 .3948 Metetra
.685 .744 .896 r
.2291 .3948 .23615 .40216 .24675 .39757 .23972 .39022 Metetra
.686 .745 .896 r
.23972 .39022 .24675 .39757 .25738 .39294 .25038 .3856 Metetra
.686 .746 .897 r
.25038 .3856 .25738 .39294 .26806 .38829 .26108 .38095 Metetra
.687 .747 .897 r
.26108 .38095 .26806 .38829 .27877 .3836 .27182 .37627 Metetra
.688 .749 .898 r
.27182 .37627 .27877 .3836 .28952 .37889 .28259 .37157 Metetra
.688 .75 .898 r
.28259 .37157 .28952 .37889 .30031 .37416 .2934 .36683 Metetra
.688 .751 .899 r
.2934 .36683 .30031 .37416 .31114 .36939 .30425 .36208 Metetra
.689 .752 .9 r
.30425 .36208 .31114 .36939 .322 .36461 .31514 .3573 Metetra
.689 .753 .9 r
.31514 .3573 .322 .36461 .3329 .35981 .32607 .35249 Metetra
.689 .754 .901 r
.32607 .35249 .3329 .35981 .34384 .35498 .33704 .34767 Metetra
.69 .755 .902 r
.33704 .34767 .34384 .35498 .35482 .35013 .34804 .34282 Metetra
.69 .756 .902 r
.34804 .34282 .35482 .35013 .36583 .34527 .35909 .33796 Metetra
.69 .757 .903 r
.35909 .33796 .36583 .34527 .37689 .34038 .37017 .33307 Metetra
.69 .758 .904 r
.37017 .33307 .37689 .34038 .38798 .33548 .38129 .32817 Metetra
.69 .759 .904 r
.38129 .32817 .38798 .33548 .39911 .33055 .39245 .32324 Metetra
.691 .76 .905 r
.39245 .32324 .39911 .33055 .41028 .32561 .40365 .3183 Metetra
.691 .761 .905 r
.40365 .3183 .41028 .32561 .42149 .32065 .41489 .31334 Metetra
.964 .716 .513 r
.41489 .31334 .42149 .32065 .43592 .20727 .42959 .19979 Metetra
.627 .728 .92 r
.42959 .19979 .43592 .20727 .44677 .2042 .44047 .19665 Metetra
.627 .727 .919 r
.44047 .19665 .44677 .2042 .45768 .2011 .4514 .1935 Metetra
.627 .726 .918 r
.4514 .1935 .45768 .2011 .46863 .19799 .46238 .19033 Metetra
.627 .725 .918 r
.46238 .19033 .46863 .19799 .47964 .19487 .47342 .18715 Metetra
.628 .725 .917 r
.47342 .18715 .47964 .19487 .4907 .19173 .4845 .18395 Metetra
.628 .724 .916 r
.4845 .18395 .4907 .19173 .50181 .18857 .49564 .18073 Metetra
.628 .723 .915 r
.49564 .18073 .50181 .18857 .51297 .18539 .50683 .1775 Metetra
.628 .722 .915 r
.50683 .1775 .51297 .18539 .52418 .1822 .51807 .17424 Metetra
.628 .721 .914 r
.51807 .17424 .52418 .1822 .53545 .17899 .52936 .17097 Metetra
.628 .72 .913 r
.52936 .17097 .53545 .17899 .54677 .17576 .54071 .16767 Metetra
.629 .719 .912 r
.54071 .16767 .54677 .17576 .55815 .1725 .55212 .16436 Metetra
.629 .719 .911 r
.55212 .16436 .55815 .1725 .56958 .16923 .56357 .16101 Metetra
.629 .718 .91 r
.56357 .16101 .56958 .16923 .58106 .16593 .57509 .15765 Metetra
.63 .717 .91 r
.57509 .15765 .58106 .16593 .5926 .1626 .58665 .15426 Metetra
.63 .716 .909 r
.58665 .15426 .5926 .1626 .6042 .15925 .59827 .15084 Metetra
.631 .715 .908 r
.59827 .15084 .6042 .15925 .61584 .15586 .60995 .14739 Metetra
.631 .715 .907 r
.60995 .14739 .61584 .15586 .62755 .15245 .62168 .1439 Metetra
.632 .714 .906 r
.62168 .1439 .62755 .15245 .63931 .149 .63347 .14039 Metetra
.633 .713 .905 r
.63347 .14039 .63931 .149 .65112 .14551 .64531 .13684 Metetra
.633 .712 .904 r
.64531 .13684 .65112 .14551 .66299 .14199 .65721 .13325 Metetra
.634 .712 .903 r
.65721 .13325 .66299 .14199 .67492 .13843 .66916 .12962 Metetra
.635 .711 .902 r
.66916 .12962 .67492 .13843 .6869 .13482 .68117 .12595 Metetra
.636 .711 .901 r
.68117 .12595 .6869 .13482 .69893 .13117 .69324 .12223 Metetra
.637 .711 .9 r
.69324 .12223 .69893 .13117 .71103 .12747 .70536 .11847 Metetra
.638 .71 .899 r
.70536 .11847 .71103 .12747 .72317 .12372 .71754 .11466 Metetra
.639 .71 .898 r
.71754 .11466 .72317 .12372 .73538 .11992 .72977 .1108 Metetra
.64 .71 .898 r
.72977 .1108 .73538 .11992 .74763 .11607 .74206 .10689 Metetra
.67 .73 .895 r
.07719 .44732 .08457 .45467 .09463 .4507 .08727 .44334 Metetra
.671 .731 .895 r
.08727 .44334 .09463 .4507 .10473 .44668 .09739 .4393 Metetra
.672 .732 .895 r
.09739 .4393 .10473 .44668 .11488 .44261 .10755 .43522 Metetra
.674 .733 .895 r
.10755 .43522 .11488 .44261 .12506 .43849 .11775 .4311 Metetra
.675 .734 .894 r
.11775 .4311 .12506 .43849 .13528 .43432 .128 .42693 Metetra
.676 .734 .894 r
.128 .42693 .13528 .43432 .14555 .43011 .13828 .42271 Metetra
.677 .735 .894 r
.13828 .42271 .14555 .43011 .15585 .42585 .14861 .41844 Metetra
.678 .736 .895 r
.14861 .41844 .15585 .42585 .1662 .42154 .15897 .41413 Metetra
.679 .737 .895 r
.15897 .41413 .1662 .42154 .17658 .41718 .16938 .40978 Metetra
.68 .738 .895 r
.16938 .40978 .17658 .41718 .18701 .41279 .17982 .40538 Metetra
.681 .74 .895 r
.17982 .40538 .18701 .41279 .19747 .40835 .19031 .40095 Metetra
.682 .741 .895 r
.19031 .40095 .19747 .40835 .20798 .40387 .20083 .39647 Metetra
.683 .742 .896 r
.20083 .39647 .20798 .40387 .21852 .39936 .2114 .39196 Metetra
.683 .743 .896 r
.2114 .39196 .21852 .39936 .2291 .3948 .222 .38741 Metetra
.684 .744 .897 r
.222 .38741 .2291 .3948 .23972 .39022 .23265 .38283 Metetra
.685 .745 .897 r
.23265 .38283 .23972 .39022 .25038 .3856 .24333 .37822 Metetra
.685 .746 .898 r
.24333 .37822 .25038 .3856 .26108 .38095 .25405 .37357 Metetra
.686 .747 .898 r
.25405 .37357 .26108 .38095 .27182 .37627 .26481 .3689 Metetra
.687 .749 .899 r
.26481 .3689 .27182 .37627 .28259 .37157 .27561 .36419 Metetra
.687 .75 .899 r
.27561 .36419 .28259 .37157 .2934 .36683 .28645 .35947 Metetra
.687 .751 .9 r
.28645 .35947 .2934 .36683 .30425 .36208 .29732 .35471 Metetra
.688 .752 .9 r
.29732 .35471 .30425 .36208 .31514 .3573 .30824 .34993 Metetra
.688 .753 .901 r
.30824 .34993 .31514 .3573 .32607 .35249 .31919 .34513 Metetra
.688 .754 .902 r
.31919 .34513 .32607 .35249 .33704 .34767 .33018 .34031 Metetra
.689 .755 .902 r
.33018 .34031 .33704 .34767 .34804 .34282 .34122 .33546 Metetra
.689 .756 .903 r
.34122 .33546 .34804 .34282 .35909 .33796 .35229 .3306 Metetra
.689 .757 .903 r
.35229 .3306 .35909 .33796 .37017 .33307 .3634 .32571 Metetra
.689 .758 .904 r
.3634 .32571 .37017 .33307 .38129 .32817 .37455 .32081 Metetra
.689 .759 .905 r
.37455 .32081 .38129 .32817 .39245 .32324 .38574 .31588 Metetra
.69 .76 .905 r
.38574 .31588 .39245 .32324 .40365 .3183 .39697 .31094 Metetra
.69 .761 .906 r
.39697 .31094 .40365 .3183 .41489 .31334 .40824 .30598 Metetra
.964 .716 .513 r
.40824 .30598 .41489 .31334 .42959 .19979 .42322 .19225 Metetra
.628 .728 .919 r
.42322 .19225 .42959 .19979 .44047 .19665 .43412 .18905 Metetra
.628 .728 .919 r
.43412 .18905 .44047 .19665 .4514 .1935 .44508 .18584 Metetra
.629 .727 .918 r
.44508 .18584 .4514 .1935 .46238 .19033 .45609 .18262 Metetra
.629 .726 .917 r
.45609 .18262 .46238 .19033 .47342 .18715 .46715 .17938 Metetra
.629 .725 .917 r
.46715 .17938 .47342 .18715 .4845 .18395 .47826 .17612 Metetra
.629 .724 .916 r
.47826 .17612 .4845 .18395 .49564 .18073 .48942 .17284 Metetra
.629 .723 .915 r
.48942 .17284 .49564 .18073 .50683 .1775 .50064 .16955 Metetra
.629 .723 .914 r
.50064 .16955 .50683 .1775 .51807 .17424 .51191 .16623 Metetra
.629 .722 .914 r
.51191 .16623 .51807 .17424 .52936 .17097 .52323 .16289 Metetra
.63 .721 .913 r
.52323 .16289 .52936 .17097 .54071 .16767 .53461 .15954 Metetra
.63 .72 .912 r
.53461 .15954 .54071 .16767 .55212 .16436 .54604 .15616 Metetra
.63 .719 .911 r
.54604 .15616 .55212 .16436 .56357 .16101 .55752 .15275 Metetra
.631 .718 .91 r
.55752 .15275 .56357 .16101 .57509 .15765 .56906 .14932 Metetra
.631 .718 .909 r
.56906 .14932 .57509 .15765 .58665 .15426 .58066 .14586 Metetra
.631 .717 .909 r
.58066 .14586 .58665 .15426 .59827 .15084 .59231 .14238 Metetra
.632 .716 .908 r
.59231 .14238 .59827 .15084 .60995 .14739 .60401 .13886 Metetra
.633 .715 .907 r
.60401 .13886 .60995 .14739 .62168 .1439 .61577 .13532 Metetra
.633 .715 .906 r
.61577 .13532 .62168 .1439 .63347 .14039 .62759 .13173 Metetra
.634 .714 .905 r
.62759 .13173 .63347 .14039 .64531 .13684 .63946 .12812 Metetra
.635 .714 .904 r
.63946 .12812 .64531 .13684 .65721 .13325 .65139 .12446 Metetra
.635 .713 .903 r
.65139 .12446 .65721 .13325 .66916 .12962 .66337 .12077 Metetra
.636 .713 .902 r
.66337 .12077 .66916 .12962 .68117 .12595 .67541 .11703 Metetra
.637 .712 .901 r
.67541 .11703 .68117 .12595 .69324 .12223 .6875 .11325 Metetra
.638 .712 .901 r
.6875 .11325 .69324 .12223 .70536 .11847 .69965 .10943 Metetra
.639 .711 .9 r
.69965 .10943 .70536 .11847 .71754 .11466 .71186 .10556 Metetra
.64 .711 .899 r
.71186 .10556 .71754 .11466 .72977 .1108 .72412 .10164 Metetra
.641 .711 .898 r
.72412 .10164 .72977 .1108 .74206 .10689 .73644 .09768 Metetra
.67 .731 .896 r
.06976 .43995 .07719 .44732 .08727 .44334 .07986 .43596 Metetra
.671 .732 .896 r
.07986 .43596 .08727 .44334 .09739 .4393 .08999 .43191 Metetra
.672 .733 .896 r
.08999 .43191 .09739 .4393 .10755 .43522 .10017 .42782 Metetra
.673 .733 .896 r
.10017 .42782 .10755 .43522 .11775 .4311 .1104 .42369 Metetra
.674 .734 .895 r
.1104 .42369 .11775 .4311 .128 .42693 .12066 .41951 Metetra
.675 .735 .895 r
.12066 .41951 .128 .42693 .13828 .42271 .13096 .41528 Metetra
.676 .736 .895 r
.13096 .41528 .13828 .42271 .14861 .41844 .14131 .41101 Metetra
.677 .737 .896 r
.14131 .41101 .14861 .41844 .15897 .41413 .15169 .4067 Metetra
.678 .738 .896 r
.15169 .4067 .15897 .41413 .16938 .40978 .16212 .40235 Metetra
.679 .739 .896 r
.16212 .40235 .16938 .40978 .17982 .40538 .17258 .39795 Metetra
.68 .74 .896 r
.17258 .39795 .17982 .40538 .19031 .40095 .18309 .39351 Metetra
.681 .741 .896 r
.18309 .39351 .19031 .40095 .20083 .39647 .19364 .38904 Metetra
.682 .742 .897 r
.19364 .38904 .20083 .39647 .2114 .39196 .20422 .38453 Metetra
.683 .743 .897 r
.20422 .38453 .2114 .39196 .222 .38741 .21485 .37999 Metetra
.683 .744 .897 r
.21485 .37999 .222 .38741 .23265 .38283 .22552 .37541 Metetra
.684 .745 .898 r
.22552 .37541 .23265 .38283 .24333 .37822 .23622 .37079 Metetra
.684 .746 .898 r
.23622 .37079 .24333 .37822 .25405 .37357 .24697 .36615 Metetra
.685 .748 .899 r
.24697 .36615 .25405 .37357 .26481 .3689 .25775 .36148 Metetra
.686 .749 .899 r
.25775 .36148 .26481 .3689 .27561 .36419 .26857 .35678 Metetra
.686 .75 .9 r
.26857 .35678 .27561 .36419 .28645 .35947 .27944 .35205 Metetra
.686 .751 .9 r
.27944 .35205 .28645 .35947 .29732 .35471 .29034 .3473 Metetra
.687 .752 .901 r
.29034 .3473 .29732 .35471 .30824 .34993 .30128 .34252 Metetra
.687 .753 .902 r
.30128 .34252 .30824 .34993 .31919 .34513 .31226 .33772 Metetra
.687 .754 .902 r
.31226 .33772 .31919 .34513 .33018 .34031 .32328 .3329 Metetra
.688 .755 .903 r
.32328 .3329 .33018 .34031 .34122 .33546 .33434 .32805 Metetra
.688 .756 .903 r
.33434 .32805 .34122 .33546 .35229 .3306 .34544 .32319 Metetra
.688 .757 .904 r
.34544 .32319 .35229 .3306 .3634 .32571 .35658 .3183 Metetra
.688 .758 .904 r
.35658 .3183 .3634 .32571 .37455 .32081 .36776 .31339 Metetra
.689 .759 .905 r
.36776 .31339 .37455 .32081 .38574 .31588 .37898 .30846 Metetra
.689 .76 .906 r
.37898 .30846 .38574 .31588 .39697 .31094 .39023 .30352 Metetra
.689 .76 .906 r
.39023 .30352 .39697 .31094 .40824 .30598 .40153 .29855 Metetra
.964 .716 .513 r
.40153 .29855 .40824 .30598 .42322 .19225 .41679 .18465 Metetra
.63 .729 .919 r
.41679 .18465 .42322 .19225 .43412 .18905 .42772 .1814 Metetra
.63 .728 .918 r
.42772 .1814 .43412 .18905 .44508 .18584 .43871 .17813 Metetra
.63 .727 .918 r
.43871 .17813 .44508 .18584 .45609 .18262 .44974 .17485 Metetra
.63 .726 .917 r
.44974 .17485 .45609 .18262 .46715 .17938 .46083 .17155 Metetra
.63 .726 .916 r
.46083 .17155 .46715 .17938 .47826 .17612 .47197 .16823 Metetra
.63 .725 .916 r
.47197 .16823 .47826 .17612 .48942 .17284 .48316 .16489 Metetra
.63 .724 .915 r
.48316 .16489 .48942 .17284 .50064 .16955 .4944 .16154 Metetra
.63 .723 .914 r
.4944 .16154 .50064 .16955 .51191 .16623 .5057 .15816 Metetra
.631 .722 .913 r
.5057 .15816 .51191 .16623 .52323 .16289 .51705 .15476 Metetra
.631 .722 .913 r
.51705 .15476 .52323 .16289 .53461 .15954 .52846 .15135 Metetra
.631 .721 .912 r
.52846 .15135 .53461 .15954 .54604 .15616 .53992 .1479 Metetra
.631 .72 .911 r
.53992 .1479 .54604 .15616 .55752 .15275 .55143 .14443 Metetra
.632 .719 .91 r
.55143 .14443 .55752 .15275 .56906 .14932 .563 .14094 Metetra
.632 .718 .909 r
.563 .14094 .56906 .14932 .58066 .14586 .57462 .13742 Metetra
.633 .718 .909 r
.57462 .13742 .58066 .14586 .59231 .14238 .5863 .13387 Metetra
.633 .717 .908 r
.5863 .13387 .59231 .14238 .60401 .13886 .59803 .13029 Metetra
.634 .716 .907 r
.59803 .13029 .60401 .13886 .61577 .13532 .60982 .12668 Metetra
.634 .716 .906 r
.60982 .12668 .61577 .13532 .62759 .13173 .62166 .12303 Metetra
.635 .715 .905 r
.62166 .12303 .62759 .13173 .63946 .12812 .63356 .11935 Metetra
.636 .715 .904 r
.63356 .11935 .63946 .12812 .65139 .12446 .64552 .11563 Metetra
.636 .714 .903 r
.64552 .11563 .65139 .12446 .66337 .12077 .65753 .11188 Metetra
.637 .714 .903 r
.65753 .11188 .66337 .12077 .67541 .11703 .6696 .10808 Metetra
.638 .713 .902 r
.6696 .10808 .67541 .11703 .6875 .11325 .68173 .10424 Metetra
.639 .713 .901 r
.68173 .10424 .6875 .11325 .69965 .10943 .69391 .10035 Metetra
.64 .713 .9 r
.69391 .10035 .69965 .10943 .71186 .10556 .70615 .09643 Metetra
.641 .712 .899 r
.70615 .09643 .71186 .10556 .72412 .10164 .71844 .09245 Metetra
.641 .712 .899 r
.71844 .09245 .72412 .10164 .73644 .09768 .73079 .08843 Metetra
.669 .732 .897 r
.06227 .43257 .06976 .43995 .07986 .43596 .07238 .42856 Metetra
.67 .733 .897 r
.07238 .42856 .07986 .43596 .08999 .43191 .08254 .4245 Metetra
.671 .733 .897 r
.08254 .4245 .08999 .43191 .10017 .42782 .09274 .4204 Metetra
.673 .734 .896 r
.09274 .4204 .10017 .42782 .1104 .42369 .10298 .41626 Metetra
.674 .735 .896 r
.10298 .41626 .1104 .42369 .12066 .41951 .11326 .41207 Metetra
.675 .736 .896 r
.11326 .41207 .12066 .41951 .13096 .41528 .12359 .40784 Metetra
.676 .737 .896 r
.12359 .40784 .13096 .41528 .14131 .41101 .13395 .40356 Metetra
.677 .738 .896 r
.13395 .40356 .14131 .41101 .15169 .4067 .14436 .39925 Metetra
.678 .739 .897 r
.14436 .39925 .15169 .4067 .16212 .40235 .1548 .39489 Metetra
.678 .739 .897 r
.1548 .39489 .16212 .40235 .17258 .39795 .16529 .39049 Metetra
.679 .74 .897 r
.16529 .39049 .17258 .39795 .18309 .39351 .17582 .38605 Metetra
.68 .741 .897 r
.17582 .38605 .18309 .39351 .19364 .38904 .18639 .38158 Metetra
.681 .742 .898 r
.18639 .38158 .19364 .38904 .20422 .38453 .197 .37707 Metetra
.682 .744 .898 r
.197 .37707 .20422 .38453 .21485 .37999 .20764 .37252 Metetra
.682 .745 .898 r
.20764 .37252 .21485 .37999 .22552 .37541 .21833 .36794 Metetra
.683 .746 .899 r
.21833 .36794 .22552 .37541 .23622 .37079 .22906 .36333 Metetra
.684 .747 .899 r
.22906 .36333 .23622 .37079 .24697 .36615 .23983 .35869 Metetra
.684 .748 .9 r
.23983 .35869 .24697 .36615 .25775 .36148 .25064 .35402 Metetra
.685 .749 .9 r
.25064 .35402 .25775 .36148 .26857 .35678 .26149 .34932 Metetra
.685 .75 .901 r
.26149 .34932 .26857 .35678 .27944 .35205 .27237 .34459 Metetra
.685 .751 .901 r
.27237 .34459 .27944 .35205 .29034 .3473 .2833 .33984 Metetra
.686 .752 .902 r
.2833 .33984 .29034 .3473 .30128 .34252 .29427 .33506 Metetra
.686 .753 .902 r
.29427 .33506 .30128 .34252 .31226 .33772 .30527 .33026 Metetra
.686 .754 .903 r
.30527 .33026 .31226 .33772 .32328 .3329 .31632 .32544 Metetra
.687 .755 .903 r
.31632 .32544 .32328 .3329 .33434 .32805 .32741 .32059 Metetra
.687 .756 .904 r
.32741 .32059 .33434 .32805 .34544 .32319 .33854 .31572 Metetra
.687 .757 .904 r
.33854 .31572 .34544 .32319 .35658 .3183 .3497 .31083 Metetra
.687 .757 .905 r
.3497 .31083 .35658 .3183 .36776 .31339 .36091 .30592 Metetra
.688 .758 .906 r
.36091 .30592 .36776 .31339 .37898 .30846 .37216 .30099 Metetra
.688 .759 .906 r
.37216 .30099 .37898 .30846 .39023 .30352 .38345 .29604 Metetra
.688 .76 .907 r
.38345 .29604 .39023 .30352 .40153 .29855 .39478 .29107 Metetra
.964 .716 .513 r
.39478 .29107 .40153 .29855 .41679 .18465 .41032 .17699 Metetra
.631 .729 .919 r
.41032 .17699 .41679 .18465 .42772 .1814 .42128 .17369 Metetra
.631 .728 .918 r
.42128 .17369 .42772 .1814 .43871 .17813 .43229 .17036 Metetra
.631 .728 .917 r
.43229 .17036 .43871 .17813 .44974 .17485 .44335 .16702 Metetra
.631 .727 .917 r
.44335 .16702 .44974 .17485 .46083 .17155 .45446 .16366 Metetra
.631 .726 .916 r
.45446 .16366 .46083 .17155 .47197 .16823 .46563 .16029 Metetra
.631 .725 .915 r
.46563 .16029 .47197 .16823 .48316 .16489 .47685 .15689 Metetra
.631 .724 .915 r
.47685 .15689 .48316 .16489 .4944 .16154 .48812 .15348 Metetra
.631 .724 .914 r
.48812 .15348 .4944 .16154 .5057 .15816 .49945 .15004 Metetra
.632 .723 .913 r
.49945 .15004 .5057 .15816 .51705 .15476 .51083 .14658 Metetra
.632 .722 .912 r
.51083 .14658 .51705 .15476 .52846 .15135 .52226 .1431 Metetra
.632 .721 .912 r
.52226 .1431 .52846 .15135 .53992 .1479 .53375 .1396 Metetra
.633 .721 .911 r
.53375 .1396 .53992 .1479 .55143 .14443 .54529 .13607 Metetra
.633 .72 .91 r
.54529 .13607 .55143 .14443 .563 .14094 .55688 .13251 Metetra
.633 .719 .909 r
.55688 .13251 .563 .14094 .57462 .13742 .56854 .12893 Metetra
.634 .719 .909 r
.56854 .12893 .57462 .13742 .5863 .13387 .58024 .12531 Metetra
.634 .718 .908 r
.58024 .12531 .5863 .13387 .59803 .13029 .592 .12167 Metetra
.635 .717 .907 r
.592 .12167 .59803 .13029 .60982 .12668 .60382 .11799 Metetra
.635 .717 .906 r
.60382 .11799 .60982 .12668 .62166 .12303 .6157 .11428 Metetra
.636 .716 .905 r
.6157 .11428 .62166 .12303 .63356 .11935 .62763 .11054 Metetra
.637 .716 .904 r
.62763 .11054 .63356 .11935 .64552 .11563 .63961 .10676 Metetra
.637 .715 .904 r
.63961 .10676 .64552 .11563 .65753 .11188 .65165 .10294 Metetra
.638 .715 .903 r
.65165 .10294 .65753 .11188 .6696 .10808 .66375 .09908 Metetra
.639 .714 .902 r
.66375 .09908 .6696 .10808 .68173 .10424 .67591 .09518 Metetra
.64 .714 .901 r
.67591 .09518 .68173 .10424 .69391 .10035 .68812 .09124 Metetra
.64 .714 .901 r
.68812 .09124 .69391 .10035 .70615 .09643 .70039 .08725 Metetra
.641 .713 .9 r
.70039 .08725 .70615 .09643 .71844 .09245 .71271 .08322 Metetra
.642 .713 .899 r
.71271 .08322 .71844 .09245 .73079 .08843 .72509 .07914 Metetra
.669 .733 .898 r
.05472 .42517 .06227 .43257 .07238 .42856 .06486 .42114 Metetra
.67 .734 .898 r
.06486 .42114 .07238 .42856 .08254 .4245 .07503 .41707 Metetra
.671 .734 .897 r
.07503 .41707 .08254 .4245 .09274 .4204 .08525 .41296 Metetra
.672 .735 .897 r
.08525 .41296 .09274 .4204 .10298 .41626 .09551 .40881 Metetra
.673 .736 .897 r
.09551 .40881 .10298 .41626 .11326 .41207 .10582 .40461 Metetra
.674 .736 .897 r
.10582 .40461 .11326 .41207 .12359 .40784 .11616 .40037 Metetra
.675 .737 .897 r
.11616 .40037 .12359 .40784 .13395 .40356 .12654 .39609 Metetra
.676 .738 .897 r
.12654 .39609 .13395 .40356 .14436 .39925 .13697 .39176 Metetra
.677 .739 .898 r
.13697 .39176 .14436 .39925 .1548 .39489 .14744 .3874 Metetra
.678 .74 .898 r
.14744 .3874 .1548 .39489 .16529 .39049 .15794 .383 Metetra
.678 .741 .898 r
.15794 .383 .16529 .39049 .17582 .38605 .16849 .37856 Metetra
.679 .742 .898 r
.16849 .37856 .17582 .38605 .18639 .38158 .17908 .37408 Metetra
.68 .743 .898 r
.17908 .37408 .18639 .38158 .197 .37707 .18971 .36957 Metetra
.681 .744 .899 r
.18971 .36957 .197 .37707 .20764 .37252 .20039 .36502 Metetra
.681 .745 .899 r
.20039 .36502 .20764 .37252 .21833 .36794 .2111 .36044 Metetra
.682 .746 .899 r
.2111 .36044 .21833 .36794 .22906 .36333 .22185 .35583 Metetra
.683 .747 .9 r
.22185 .35583 .22906 .36333 .23983 .35869 .23264 .35119 Metetra
.683 .748 .9 r
.23264 .35119 .23983 .35869 .25064 .35402 .24347 .34652 Metetra
.684 .749 .901 r
.24347 .34652 .25064 .35402 .26149 .34932 .25434 .34182 Metetra
.684 .75 .901 r
.25434 .34182 .26149 .34932 .27237 .34459 .26526 .33709 Metetra
.684 .751 .902 r
.26526 .33709 .27237 .34459 .2833 .33984 .27621 .33233 Metetra
.685 .752 .902 r
.27621 .33233 .2833 .33984 .29427 .33506 .2872 .32755 Metetra
.685 .753 .903 r
.2872 .32755 .29427 .33506 .30527 .33026 .29824 .32275 Metetra
.686 .754 .903 r
.29824 .32275 .30527 .33026 .31632 .32544 .30931 .31792 Metetra
.686 .755 .904 r
.30931 .31792 .31632 .32544 .32741 .32059 .32043 .31307 Metetra
.686 .755 .904 r
.32043 .31307 .32741 .32059 .33854 .31572 .33158 .3082 Metetra
.686 .756 .905 r
.33158 .3082 .33854 .31572 .3497 .31083 .34278 .30331 Metetra
.686 .757 .905 r
.34278 .30331 .3497 .31083 .36091 .30592 .35401 .29839 Metetra
.687 .758 .906 r
.35401 .29839 .36091 .30592 .37216 .30099 .36529 .29346 Metetra
.687 .759 .907 r
.36529 .29346 .37216 .30099 .38345 .29604 .37661 .2885 Metetra
.687 .76 .907 r
.37661 .2885 .38345 .29604 .39478 .29107 .38797 .28353 Metetra
.964 .716 .513 r
.38797 .28353 .39478 .29107 .41032 .17699 .4038 .16928 Metetra
.632 .73 .918 r
.4038 .16928 .41032 .17699 .42128 .17369 .41478 .16592 Metetra
.632 .729 .918 r
.41478 .16592 .42128 .17369 .43229 .17036 .42582 .16254 Metetra
.632 .728 .917 r
.42582 .16254 .43229 .17036 .44335 .16702 .43691 .15914 Metetra
.632 .727 .916 r
.43691 .15914 .44335 .16702 .45446 .16366 .44805 .15572 Metetra
.632 .727 .916 r
.44805 .15572 .45446 .16366 .46563 .16029 .45925 .15229 Metetra
.632 .726 .915 r
.45925 .15229 .46563 .16029 .47685 .15689 .47049 .14883 Metetra
.632 .725 .914 r
.47049 .14883 .47685 .15689 .48812 .15348 .48179 .14536 Metetra
.633 .724 .914 r
.48179 .14536 .48812 .15348 .49945 .15004 .49315 .14186 Metetra
.633 .724 .913 r
.49315 .14186 .49945 .15004 .51083 .14658 .50455 .13834 Metetra
.633 .723 .912 r
.50455 .13834 .51083 .14658 .52226 .1431 .51602 .1348 Metetra
.633 .722 .912 r
.51602 .1348 .52226 .1431 .53375 .1396 .52753 .13123 Metetra
.634 .721 .911 r
.52753 .13123 .53375 .1396 .54529 .13607 .5391 .12764 Metetra
.634 .721 .91 r
.5391 .1276