(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    169588,       6407]*)
(*NotebookOutlinePosition[    240949,       8458]*)
(*  CellTagsIndexPosition[    235048,       8227]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["3.3 ", "HeadingNumber"],
  "Algebraic Manipulation"
}], "Section",
  CellTags->{"S3.3.0", "0.1"}],

Cell[CellGroupData[{

Cell["3.3.1 Structural Operations on Polynomials", "Subsection",
  CellTags->{"S3.3.1", "1.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Expand[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["expand out products and powers "]},
          {Cell[TextData[{
              StyleBox["Factor[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["factor completely "]},
          {Cell[TextData[{
              StyleBox["FactorTerms[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["pull out any overall numerical factor "]},
          {Cell[TextData[{
              StyleBox["FactorTerms[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "pull out any overall factor that does not depend on ",
              StyleBox["x", "TI"],
              ", ",
              StyleBox["y", "TI"],
              ",\[NonBreakingSpace]\[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Collect[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "arrange a polynomial as a sum of powers of ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Collect[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "arrange a polynomial as a sum of powers of ",
              StyleBox["x", "TI"],
              ", ",
              StyleBox["y", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.1"],

Cell["Structural operations on polynomials. ", "Caption",
  CellTags->"S3.3.1"],

Cell["Here is a polynomial in one variable. ", "MathCaption",
  CellTags->{"S3.3.1", "1.2"}],

Cell[CellGroupData[{

Cell["(2 + 4 x^2)^2 (x - 1)^3", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(\((\(-1\) + x)\)\^3\ \((2 + 4\ x\^2)\)\^2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Expand", "MR"],
  " expands out products and powers, writing the polynomial as a simple sum \
of terms. "
}], "MathCaption",
  CellTags->{"S3.3.1", "1.3"}],

Cell[CellGroupData[{

Cell["t = Expand[ % ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(\(-4\) + 12\ x - 28\ x\^2 + 52\ x\^3 - 64\ x\^4 + 64\ x\^5 - 48\ x\^6 + 
      16\ x\^7\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Factor", "MR"],
  " performs complete factoring of the polynomial. "
}], "MathCaption",
  CellTags->{"S3.3.1", "1.4"}],

Cell[CellGroupData[{

Cell["Factor[ t ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(4\ \((\(-1\) + x)\)\^3\ \((1 + 2\ x\^2)\)\^2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FactorTerms", "MR"],
  " pulls out the overall numerical factor from ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.1", "1.5"}],

Cell[CellGroupData[{

Cell["FactorTerms[ t ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(4\ \((\(-1\) + 3\ x - 7\ x\^2 + 13\ x\^3 - 16\ x\^4 + 16\ x\^5 - 
          12\ x\^6 + 4\ x\^7)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[TextData[{
  "There are several ways to write any polynomial. The functions ",
  StyleBox["Expand", "MR"],
  ", ",
  StyleBox["FactorTerms", "MR"],
  " and ",
  StyleBox["Factor", "MR"],
  " give three common ways. ",
  StyleBox["Expand", "MR"],
  " writes a polynomial as a simple sum of terms, with all products expanded \
out. ",
  StyleBox["FactorTerms", "MR"],
  " pulls out common factors from each term. ",
  StyleBox["Factor", "MR"],
  " does complete factoring, writing the polynomial as a product of terms, \
each of as low degree as possible. "
}], "Text",
  CellTags->{"S3.3.1", "1.6"}],

Cell[TextData[{
  "When you have a polynomial in more than one variable, you can put the \
polynomial in different forms by essentially choosing different variables to \
be \[OpenCurlyDoubleQuote]dominant\[CloseCurlyDoubleQuote]. ",
  StyleBox["Collect[", "MR"],
  StyleBox["poly", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " takes a polynomial in several variables and rewrites it as a sum of terms \
containing different powers of the \[OpenCurlyDoubleQuote]dominant variable\
\[CloseCurlyDoubleQuote] ",
  StyleBox["x", "TI"],
  ".  "
}], "Text",
  CellTags->{"S3.3.1", "1.7"}],

Cell["Here is a polynomial in two variables. ", "MathCaption",
  CellTags->{"S3.3.1", "1.8"}],

Cell[CellGroupData[{

Cell["Expand[ (1 + 2x + y)^3 ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(1 + 6\ x + 12\ x\^2 + 8\ x\^3 + 3\ y + 12\ x\ y + 12\ x\^2\ y + 
      3\ y\^2 + 6\ x\ y\^2 + y\^3\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Collect", "MR"],
  " reorganizes the polynomial so that ",
  StyleBox["x", "MR"],
  " is the \[OpenCurlyDoubleQuote]dominant variable\[CloseCurlyDoubleQuote]. \
"
}], "MathCaption",
  CellTags->{"S3.3.1", "1.9"}],

Cell[CellGroupData[{

Cell["Collect[ %, x ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(1 + 8\ x\^3 + 3\ y + 3\ y\^2 + y\^3 + x\^2\ \((12 + 12\ y)\) + 
      x\ \((6 + 12\ y + 6\ y\^2)\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[TextData[{
  "If you specify a list of variables, ",
  StyleBox["Collect", "MR"],
  " will effectively write the expression as a polynomial in these variables. \
"
}], "MathCaption",
  CellTags->{"S3.3.1", "1.10"}],

Cell[CellGroupData[{

Cell["Collect[ Expand[ (1 + x + 2y + 3z)^3 ], {x, y} ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(1 + x\^3 + 8\ y\^3 + 9\ z + 27\ z\^2 + 27\ z\^3 + 
      x\^2\ \((3 + 6\ y + 9\ z)\) + y\^2\ \((12 + 36\ z)\) + 
      y\ \((6 + 36\ z + 54\ z\^2)\) + 
      x\ \((3 + 12\ y\^2 + 18\ z + 27\ z\^2 + 
            y\ \((12 + 36\ z)\))\)\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Expand[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["patt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "expand out ",
              StyleBox["poly", "TI"],
              " avoiding those parts which do not contain terms matching ",
              StyleBox["patt", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.1"],

Cell["Controlling polynomial expansion. ", "Caption",
  CellTags->"S3.3.1"],

Cell[TextData[{
  "This avoids expanding parts which do not contain ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.1", "1.11"}],

Cell[CellGroupData[{

Cell["Expand[(x + 1)^2 (y + 1)^2, x]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(\((1 + y)\)\^2 + 2\ x\ \((1 + y)\)\^2 + 
      x\^2\ \((1 + y)\)\^2\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[TextData[{
  "This avoids expanding parts which do not contain objects matching ",
  StyleBox["b[_]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.1", "1.12"}],

Cell[CellGroupData[{

Cell["Expand[(a[1] + a[2] + 1)^2 (1 + b[1])^2, b[_]]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(\((1 + a[1] + a[2])\)\^2 + 
      2\ \((1 + a[1] + a[2])\)\^2\ b[
          1] + \((1 + a[1] + a[2])\)\^2\ b[1]\^2\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PowerExpand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "expand out ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      RowBox[{"(", 
                        StyleBox[\(a  b\),
                          "TI"], ")"}], 
                      StyleBox["c",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      RowBox[{"(", 
                        SuperscriptBox[
                          StyleBox["a",
                            "TI"], 
                          StyleBox["b",
                            "TI"]], ")"}], 
                      StyleBox["c",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " in ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.1"],

Cell["Expanding powers. ", "Caption",
  CellTags->"S3.3.1"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " does not automatically expand out expressions of the form ",
  StyleBox["(", "MR"],
  StyleBox["a", "TI"],
  " ",
  StyleBox["b", "TI"],
  StyleBox[")^", "MR"],
  StyleBox["c", "TI"],
  " except when ",
  StyleBox["c", "TI"],
  " is an integer. In general it is only correct to do this expansion if ",
  StyleBox["a", "TI"],
  " and ",
  StyleBox["b", "TI"],
  " are positive reals. Nevertheless, the function ",
  StyleBox["PowerExpand", "MR"],
  " does the expansion, effectively assuming that ",
  StyleBox["a", "TI"],
  " and ",
  StyleBox["b", "TI"],
  " are indeed positive reals. "
}], "Text",
  CellTags->{"S3.3.1", "1.13"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " does not automatically expand out this expression. "
}], "MathCaption",
  CellTags->{"S3.3.1", "1.14"}],

Cell[CellGroupData[{

Cell["(x y)^n", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(\((x\ y)\)\^n\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["PowerExpand", "MR"],
  " does the expansion, effectively assuming that ",
  StyleBox["x", "TI"],
  " and ",
  StyleBox["y", "TI"],
  " are positive reals. "
}], "MathCaption",
  CellTags->{"S3.3.1", "1.15"}],

Cell[CellGroupData[{

Cell["PowerExpand[%]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(x\^n\ y\^n\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Log", "MR"],
  " is not automatically expanded out. "
}], "MathCaption",
  CellTags->{"S3.3.1", "1.16"}],

Cell[CellGroupData[{

Cell["Log[%]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(Log[x\^n\ y\^n]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["PowerExpand", "MR"],
  " does the expansion. "
}], "MathCaption",
  CellTags->{"S3.3.1", "1.17"}],

Cell[CellGroupData[{

Cell["PowerExpand[%]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(n\ Log[x] + n\ Log[y]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Collect[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["patt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "collect separately terms involving each object that matches ",
              StyleBox["patt", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Collect[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["patt", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["h", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["h", "TI"],
              " to each final coefficient obtained "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.1"],

Cell["Ways of collecting terms. ", "Caption",
  CellTags->"S3.3.1"],

Cell[TextData[{
  "Here is an expression involving various functions ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.1", "1.18"}],

Cell[CellGroupData[{

Cell["t = 3 + x f[1] + x^2 f[1] + y f[2]^2 + z f[2]^2", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(3 + x\ f[1] + x\^2\ f[1] + y\ f[2]\^2 + z\ f[2]\^2\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[TextData[{
  "This collects terms that match ",
  StyleBox["f[_]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.1", "1.19"}],

Cell[CellGroupData[{

Cell["Collect[t, f[_]]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(3 + \((x + x\^2)\)\ f[1] + \((y + z)\)\ f[2]\^2\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.3.1"]
}, Open  ]],

Cell[TextData[{
  "This applies ",
  StyleBox["Factor", "MR"],
  " to each coefficient obtained. "
}], "MathCaption",
  CellTags->{"S3.3.1", "1.20"}],

Cell[CellGroupData[{

Cell["Collect[t, f[_], Factor]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.3.1"],

Cell[BoxData[
    \(3 + x\ \((1 + x)\)\ f[1] + \((y + z)\)\ f[2]\^2\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.3.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3.2 Finding the Structure of a Polynomial", "Subsection",
  CellTags->{"S3.3.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PolynomialQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["expr", "TI"],
              " is a polynomial in ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PolynomialQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["expr", "TI"],
              " is a polynomial in the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Variables[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a list of the variables in ",
              StyleBox["poly", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Exponent[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the maximum exponent with which ",
              StyleBox["x", "TI"],
              " appears in ",
              StyleBox["poly", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Coefficient[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the coefficient of ",
              StyleBox["expr", "TI"],
              " in ",
              StyleBox["poly", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Coefficient[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the coefficient of ",
              StyleBox["expr", "TI"],
              StyleBox["^", "MR"],
              StyleBox["n", "TI"],
              " in ",
              StyleBox["poly", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Coefficient[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["0]", "MR"],
              " "
            }]], Cell[TextData[{
              "the term in ",
              StyleBox["poly", "TI"],
              " independent of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["CoefficientList[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate an array of the coefficients of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " in ",
              StyleBox["poly", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.2"],

Cell["\<\
Finding the structure of polynomials written in expanded form. \
\
\>", "Caption",
  CellTags->"S3.3.2"],

Cell["Here is a polynomial in two variables. ", "MathCaption",
  CellTags->{"S3.3.2", "2.2"}],

Cell[CellGroupData[{

Cell["t = (1 + x)^3 (1 - y - x)^2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.3.2"],

Cell[BoxData[
    \(\((1 + x)\)\^3\ \((1 - x - y)\)\^2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.3.2"]
}, Open  ]],

Cell["This is the polynomial in expanded form. ", "MathCaption",
  CellTags->{"S3.3.2", "2.3"}],

Cell[CellGroupData[{

Cell["Expand[t]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.3.2"],

Cell[BoxData[
    \(1 + x - 2\ x\^2 - 2\ x\^3 + x\^4 + x\^5 - 2\ y - 4\ x\ y + 4\ x\^3\ y + 
      2\ x\^4\ y + y\^2 + 3\ x\ y\^2 + 3\ x\^2\ y\^2 + x\^3\ y\^2\)], "Output",\

  CellLabel->"Out[2]= ",
  CellTags->"S3.3.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["PolynomialQ", "MR"],
  " reports that ",
  StyleBox["t", "MR"],
  " is a polynomial in ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.2", "2.4"}],

Cell[CellGroupData[{

Cell["PolynomialQ[t, x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.3.2"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.3.2"]
}, Open  ]],

Cell[TextData[{
  "This expression, however, is not a polynomial in ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.2", "2.5"}],

Cell[CellGroupData[{

Cell["PolynomialQ[x + Sin[x], x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.3.2"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.3.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Variables", "MR"],
  " gives a list of the variables in the polynomial ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.2", "2.6"}],

Cell[CellGroupData[{

Cell["Variables[t]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.3.2"],

Cell[BoxData[
    \({x, y}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.3.2"]
}, Open  ]],

Cell[TextData[{
  "This gives the maximum exponent with which ",
  StyleBox["x", "MR"],
  " appears in the polynomial ",
  StyleBox["t", "MR"],
  ". For a polynomial in one variable, ",
  StyleBox["Exponent", "MR"],
  " gives the degree of the polynomial. "
}], "MathCaption",
  CellTags->{"S3.3.2", "2.7"}],

Cell[CellGroupData[{

Cell["Exponent[t, x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.3.2"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.3.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Coefficient[", "MR"],
  StyleBox["poly", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " gives the total coefficient with which ",
  StyleBox["expr", "TI"],
  " appears in ",
  StyleBox["poly", "TI"],
  ". In this case, the result is a sum of two terms. "
}], "MathCaption",
  CellTags->{"S3.3.2", "2.8"}],

Cell[CellGroupData[{

Cell["Coefficient[t, x^2]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.3.2"],

Cell[BoxData[
    \(\(-2\) + 3\ y\^2\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.3.2"]
}, Open  ]],

Cell[TextData[{
  "This is equivalent to ",
  StyleBox["Coefficient[t,", "MR"],
  " ",
  StyleBox["x^2]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.2", "2.9"}],

Cell[CellGroupData[{

Cell["Coefficient[t, x, 2]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.3.2"],

Cell[BoxData[
    \(\(-2\) + 3\ y\^2\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.3.2"]
}, Open  ]],

Cell[TextData[{
  "This picks out the coefficient of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  " in\[NonBreakingSpace]",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.2", "2.10"}],

Cell[CellGroupData[{

Cell["Coefficient[t, x, 0]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.3.2"],

Cell[BoxData[
    \(1 - 2\ y + y\^2\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.3.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["CoefficientList", "MR"],
  " gives a list of the coefficients of each power of ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", starting with ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.2", "2.11"}],

Cell[CellGroupData[{

Cell["CoefficientList[1 + 3x^2 + 4x^4, x]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.3.2"],

Cell[BoxData[
    \({1, 0, 3, 0, 4}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.3.2"]
}, Open  ]],

Cell[TextData[{
  "For multivariate polynomials, ",
  StyleBox["CoefficientList", "MR"],
  " gives an array of the coefficients for each power of each variable. "
}], "MathCaption",
  CellTags->{"S3.3.2", "2.12"}],

Cell[CellGroupData[{

Cell["CoefficientList[t, {x, y}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.3.2"],

Cell[BoxData[
    \({{1, \(-2\), 1}, {1, \(-4\), 3}, {\(-2\), 0, 3}, {\(-2\), 4, 1}, {1, 2, 
        0}, {1, 0, 0}}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.3.2"]
}, Open  ]],

Cell["\<\
It is important to notice that the functions in this section will \
work even on polynomials that are not explicitly given in expanded form. \
\
\>", "Text",
  CellTags->{"S3.3.2", "2.13"}],

Cell["\<\
Many of the functions also work on expressions that are not \
strictly polynomials. \
\>", "Text",
  CellTags->{"S3.3.2", "2.14"}],

Cell[TextData[{
  "Without giving specific integer values to ",
  StyleBox["a", "MR"],
  ", ",
  StyleBox["b", "MR"],
  " and ",
  StyleBox["c", "MR"],
  ", this expression cannot strictly be considered a polynomial. "
}], "MathCaption",
  CellTags->{"S3.3.2", "2.15"}],

Cell[CellGroupData[{

Cell["x^a + x^b + y^c", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.3.2"],

Cell[BoxData[
    \(x\^a + x\^b + y\^c\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.3.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Exponent[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x]", "MR"],
  " still gives the maximum exponent of ",
  StyleBox["x", "MR"],
  " in ",
  StyleBox["expr", "TI"],
  ", but here has to write the result in symbolic form. "
}], "MathCaption",
  CellTags->{"S3.3.2", "2.16"}],

Cell[CellGroupData[{

Cell["Exponent[%, x]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.3.2"],

Cell[BoxData[
    \(Max[0, a, b]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.3.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3.3 Structural Operations on Rational Expressions", "Subsection",
  CellTags->{"S3.3.3", "3.1"}],

Cell[TextData[{
  "For ordinary polynomials, ",
  StyleBox["Factor", "MR"],
  " and ",
  StyleBox["Expand", "MR"],
  " give the most important forms. For rational expressions, there are many \
different forms that can be useful. "
}], "Text",
  CellTags->{"S3.3.3", "3.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ExpandNumerator[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["expand numerators only "]},
          {Cell[TextData[{
              StyleBox["ExpandDenominator[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["expand denominators only "]},
          {Cell[TextData[{
              StyleBox["Expand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "expand numerators, dividing the denominator into each term "]},
          {Cell[TextData[{
              StyleBox["ExpandAll[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["expand numerators and denominators completely "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.3"],

Cell["Different kinds of expansion for rational expressions. ", "Caption",
  CellTags->"S3.3.3"],

Cell["Here is a rational expression. ", "MathCaption",
  CellTags->{"S3.3.3", "3.3"}],

Cell[CellGroupData[{

Cell["t = (1 + x)^2 / (1 - x) + 3 x^2 / (1 + x)^2 + (2 - x)^2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(\((2 - x)\)\^2 + \(3\ x\^2\)\/\((1 + x)\)\^2 + \((1 + x)\)\^2\/\(1 - \
x\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ExpandNumerator", "MR"],
  " writes the numerator of each term in expanded form. "
}], "MathCaption",
  CellTags->{"S3.3.3", "3.4"}],

Cell[CellGroupData[{

Cell["ExpandNumerator[t]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(4 - 4\ x + 
      x\^2 + \(3\ x\^2\)\/\((1 + x)\)\^2 + \(1 + 2\ x + x\^2\)\/\(1 - x\)\)], \
"Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Expand", "MR"],
  " expands the numerator of each term, and divides all the terms by the \
appropriate denominators. "
}], "MathCaption",
  CellTags->{"S3.3.3", "3.5"}],

Cell[CellGroupData[{

Cell["Expand[t]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(4 + 1\/\(1 - x\) - 4\ x + \(2\ x\)\/\(1 - x\) + x\^2 + 
      x\^2\/\(1 - x\) + \(3\ x\^2\)\/\((1 + x)\)\^2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ExpandDenominator", "MR"],
  " expands out the denominator of each term. "
}], "MathCaption",
  CellTags->{"S3.3.3", "3.6"}],

Cell[CellGroupData[{

Cell["ExpandDenominator[t]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(\((2 - x)\)\^2 + \((1 + x)\)\^2\/\(1 - x\) + \(3\ x\^2\)\/\(1 + 2\ x + \
x\^2\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ExpandAll", "MR"],
  " does all possible expansions in the numerator and denominator of each \
term. "
}], "MathCaption",
  CellTags->{"S3.3.3", "3.7"}],

Cell[CellGroupData[{

Cell["ExpandAll[t]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(4 + 1\/\(1 - x\) - 4\ x + \(2\ x\)\/\(1 - x\) + x\^2 + 
      x\^2\/\(1 - x\) + \(3\ x\^2\)\/\(1 + 2\ x + x\^2\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ExpandAll[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["patt", "TI"],
              StyleBox["]", "MR"],
              ",  etc. "
            }]], Cell[TextData[{
              "avoid expanding parts which contain no terms matching ",
              StyleBox["patt", "TI"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.3"],

Cell["Controlling expansion. ", "Caption",
  CellTags->"S3.3.3"],

Cell[TextData[{
  "This avoids expanding the term which does not contain ",
  StyleBox["z", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.3", "3.8"}],

Cell[CellGroupData[{

Cell["ExpandAll[(x + 1)^2/y^2 + (z + 1)^2/z^2, z]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(1 + \((1 + x)\)\^2\/y\^2 + 1\/z\^2 + 2\/z\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Together[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["combine all terms over a common denominator "]},
          {Cell[TextData[{
              StyleBox["Apart[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
write an expression as a sum of terms with simple \
denominators \
\>"]},
          {Cell[TextData[{
              StyleBox["Cancel[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "cancel common factors between numerators and denominators "]},
          {Cell[TextData[{
              StyleBox["Factor[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["perform a complete factoring "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.3"],

Cell["Structural operations on rational expressions. ", "Caption",
  CellTags->"S3.3.3"],

Cell["Here is a rational expression. ", "MathCaption",
  CellTags->{"S3.3.3", "3.9"}],

Cell[CellGroupData[{

Cell["u = (-4x + x^2)/(-x + x^2) + (-4 + 3x + x^2)/(-1 + x^2)", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(\(\(-4\)\ x + x\^2\)\/\(\(-x\) + x\^2\) + \(\(-4\) + 3\ x + \
x\^2\)\/\(\(-1\) + x\^2\)\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Together", "MR"],
  " puts all terms over a common denominator. "
}], "MathCaption",
  CellTags->{"S3.3.3", "3.10"}],

Cell[CellGroupData[{

Cell["Together[u]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(\(2\ \((\(-4\) + x\^2)\)\)\/\(\((\(-1\) + x)\)\ \((1 + x)\)\)\)], \
"Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Factor", "MR"],
  " to factor the numerator and denominator of the resulting expression. "
}], "MathCaption",
  CellTags->{"S3.3.3", "3.11"}],

Cell[CellGroupData[{

Cell["Factor[%]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(\(2\ \((\(-2\) + x)\)\ \((2 + x)\)\)\/\(\((\(-1\) + x)\)\ \((1 + x)\)\)\
\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Apart", "MR"],
  " writes the expression as a sum of terms, with each term having as simple \
a denominator as possible. "
}], "MathCaption",
  CellTags->{"S3.3.3", "3.12"}],

Cell[CellGroupData[{

Cell["Apart[u]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(2 - 3\/\(\(-1\) + x\) + 3\/\(1 + x\)\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Cancel", "MR"],
  " cancels any common factors between numerators and denominators. "
}], "MathCaption",
  CellTags->{"S3.3.3", "3.13"}],

Cell[CellGroupData[{

Cell["Cancel[u]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(\(\(-4\) + x\)\/\(\(-1\) + x\) + \(4 + x\)\/\(1 + x\)\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Factor", "MR"],
  " first puts all terms over a common denominator, then factors the result. \
"
}], "MathCaption",
  CellTags->{"S3.3.3", "3.14"}],

Cell[CellGroupData[{

Cell["Factor[%]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(\(2\ \((\(-2\) + x)\)\ \((2 + x)\)\)\/\(\((\(-1\) + x)\)\ \((1 + x)\)\)\
\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[TextData[{
  "In mathematical terms, ",
  StyleBox["Apart", "MR"],
  " decomposes a rational expression into \[OpenCurlyDoubleQuote]partial \
fractions\[CloseCurlyDoubleQuote]. "
}], "Text",
  CellTags->{"S3.3.3", "3.15"}],

Cell[TextData[{
  "In expressions with several variables, you can use ",
  StyleBox["Apart[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["var", "TI"],
  StyleBox["]", "MR"],
  " to do partial fraction decompositions with respect to different \
variables. "
}], "Text",
  CellTags->{"S3.3.3", "3.16"}],

Cell["Here is a rational expression in two variables. ", "MathCaption",
  CellTags->{"S3.3.3", "3.17"}],

Cell[CellGroupData[{

Cell["v = (x^2+y^2)/(x + x y)", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(\(x\^2 + y\^2\)\/\(x + x\ y\)\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[TextData[{
  "This gives the partial fraction decomposition with respect to ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.3", "3.18"}],

Cell[CellGroupData[{

Cell["Apart[v, x]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(x\/\(1 + y\) + y\^2\/\(x\ \((1 + y)\)\)\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.3.3"]
}, Open  ]],

Cell[TextData[{
  "Here is the partial fraction decomposition with respect to ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.3", "3.19"}],

Cell[CellGroupData[{

Cell["Apart[v, y]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.3.3"],

Cell[BoxData[
    \(\(-\(1\/x\)\) + y\/x + \(1 + x\^2\)\/\(x\ \((1 + y)\)\)\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.3.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3.4 Algebraic Operations on Polynomials", "Subsection",
  CellTags->{"S3.3.4", "4.1"}],

Cell["\<\
For many kinds of practical calculations, the only operations you \
will need to perform on polynomials are essentially the structural ones \
discussed in the preceding sections. \
\>", "Text",
  CellTags->{"S3.3.4", "4.2"}],

Cell["\<\
If you do more advanced algebra with polynomials, however, you will \
have to use the algebraic operations discussed in this section.  \
\>", "Text",\

  CellTags->{"S3.3.4", "4.3"}],

Cell["\<\
You should realize that most of the operations discussed in this \
section work only on ordinary polynomials, with integer exponents and \
rational\[Hyphen]number coefficients for each term.  \
\>", "Text",
  CellTags->{"S3.3.4", "4.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PolynomialQuotient[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the result of dividing the polynomial ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " in ",
              StyleBox["x", "TI"],
              " by ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", dropping any remainder term "
            }]]},
          {Cell[TextData[{
              StyleBox["PolynomialRemainder[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the remainder from dividing the polynomial ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " in ",
              StyleBox["x", "TI"],
              " by ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PolynomialGCD[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "find the greatest common divisor of two polynomials "]},
          {Cell[TextData[{
              StyleBox["PolynomialLCM[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["find the least common multiple of two polynomials "]},
          {Cell[TextData[{
              StyleBox["PolynomialMod[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "reduce the polynomial ",
              StyleBox["poly", "TI"],
              " modulo ",
              StyleBox["m", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Resultant[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["find the resultant of two polynomials "]},
          {Cell[TextData[{
              StyleBox["Subresultants[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
find the principal subresultant coefficients of two \
polynomials \
\>"]},
          {Cell[TextData[{
              StyleBox["GroebnerBasis[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "find the Gr\[ODoubleDot]bner basis for the polynomials ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["GroebnerBasis[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, {",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "find the Gr\[ODoubleDot]bner basis eliminating the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PolynomialReduce[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "find a minimal representation of ",
              StyleBox["poly", "TI"],
              " in terms of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.4"],

Cell["Reduction of polynomials. ", "Caption",
  CellTags->"S3.3.4"],

Cell[TextData[{
  "Given two polynomials ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["p",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["q",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", one can always uniquely write ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox[
            RowBox[{
              StyleBox["p",
                "TI"], 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}], 
            RowBox[{
              StyleBox["q",
                "TI"], 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}]], "=", 
          StyleBox["a",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "+", 
          FractionBox[
            RowBox[{
              StyleBox["b",
                "TI"], 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}], 
            RowBox[{
              StyleBox["q",
                "TI"], 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}]]}], TraditionalForm]], "InlineFormula"],
  ", where the degree of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["b",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is less than the degree of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["q",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". ",
  StyleBox["PolynomialQuotient", "MR"],
  " gives the quotient ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["a",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", and ",
  StyleBox["PolynomialRemainder", "MR"],
  " gives the remainder ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["b",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.3.4", "4.5"}],

Cell[TextData[{
  "This gives the remainder from dividing ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "+", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.6"}],

Cell[CellGroupData[{

Cell["PolynomialRemainder[x^2, x+1, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  "Here is the quotient of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "+", "1"}], TraditionalForm]], "InlineFormula"],
  ", with the remainder dropped. "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.7"}],

Cell[CellGroupData[{

Cell["PolynomialQuotient[x^2, x+1, x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(\(-1\) + x\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell["This gives back the original expression. ", "MathCaption",
  CellTags->{"S3.3.4", "4.8"}],

Cell[CellGroupData[{

Cell["Simplify[ (x+1) % + %% ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(x\^2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  "Here the result depends on whether the polynomials are considered to be in \
",
  StyleBox["x", "MR"],
  " or ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.9"}],

Cell[CellGroupData[{

Cell["\<\
{PolynomialRemainder[x+y, x-y, x], PolynomialRemainder[x+y, x-y, \
y]}\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \({2\ y, 2\ x}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["PolynomialGCD[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["poly",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["poly",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["]", "MR"],
  " finds the highest degree polynomial that divides the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["poly",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " exactly. It gives the analog for polynomials of the integer function ",
  StyleBox["GCD", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.3.4", "4.10"}],

Cell[TextData[{
  StyleBox["PolynomialGCD", "MR"],
  " gives the greatest common divisor of the two polynomials. "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.11"}],

Cell[CellGroupData[{

Cell["PolynomialGCD[ (1-x)^2 (1+x) (2+x), (1-x) (2+x) (3+x) ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(\((\(-1\) + x)\)\ \((2 + x)\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["PolynomialMod", "MR"],
  " is essentially the analog for polynomials of the function ",
  StyleBox["Mod", "MR"],
  " for integers. When the modulus ",
  StyleBox["m", "TI"],
  " is an integer, ",
  StyleBox["PolynomialMod[", "MR"],
  StyleBox["poly", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " simply reduces each coefficient in ",
  StyleBox["poly", "TI"],
  " modulo the integer ",
  StyleBox["m", "TI"],
  ". If ",
  StyleBox["m", "TI"],
  " is a polynomial, then ",
  StyleBox["PolynomialMod[", "MR"],
  StyleBox["poly", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " effectively tries to get as low degree a polynomial as possible by \
subtracting from ",
  StyleBox["poly", "TI"],
  " appropriate multiples ",
  StyleBox["q", "TI"],
  " ",
  StyleBox["m", "TI"],
  " of ",
  StyleBox["m", "TI"],
  ". The multiplier ",
  StyleBox["q", "TI"],
  " can itself be a polynomial, but its degree is always less than the degree \
of ",
  StyleBox["poly", "TI"],
  ". ",
  StyleBox["PolynomialMod", "MR"],
  " yields a final polynomial whose degree and leading coefficient are both \
as small as possible. "
}], "Text",
  CellTags->{"S3.3.4", "4.12"}],

Cell[TextData[{
  "This reduces ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " modulo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "+", "1"}], TraditionalForm]], "InlineFormula"],
  ". The result is simply the remainder from dividing the polynomials. "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.13"}],

Cell[CellGroupData[{

Cell["PolynomialMod[x^2, x+1]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  "In this case, ",
  StyleBox["PolynomialMod", "MR"],
  " and ",
  StyleBox["PolynomialRemainder", "MR"],
  " do not give the same result. "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.14"}],

Cell[CellGroupData[{

Cell["\<\
{PolynomialMod[x^2, a x + 1], PolynomialRemainder[x^2, a x + 1, x]}\
\
\>", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \({x\^2, 1\/a\^2}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  "The main difference between ",
  StyleBox["PolynomialMod", "MR"],
  " and ",
  StyleBox["PolynomialRemainder", "MR"],
  " is that while the former works simply by multiplying and subtracting \
polynomials, the latter uses division in getting its results. In addition, ",
  StyleBox["PolynomialMod", "MR"],
  " allows reduction by several moduli at the same time. A typical case is \
reduction modulo both a polynomial and an integer. "
}], "Text",
  CellTags->{"S3.3.4", "4.15"}],

Cell[TextData[{
  "This reduces the polynomial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"], "+", "1"}], TraditionalForm]], "InlineFormula"],
  " modulo both ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "+", "1"}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.16"}],

Cell[CellGroupData[{

Cell["PolynomialMod[x^2 + 1, {x + 1, 2}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["Resultant[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["poly",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["poly",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " is used in a number of classical algebraic algorithms. The resultant of \
two polynomials ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["b",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", both with leading coefficient one, is given by the product of all the \
differences ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["a",
              "TI"], 
            StyleBox["i",
              "TI"]], "-", 
          SubscriptBox[
            StyleBox["b",
              "TI"], 
            StyleBox["j",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  " between the roots of the polynomials. It turns out that for any pair of \
polynomials, the resultant is always a polynomial in their coefficients. By \
looking at when the resultant is zero, one can tell for what values of their \
parameters two polynomials have a common root. Two polynomials with leading \
coefficient one have ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " common roots if exactly the first ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " elements in the list ",
  StyleBox["Subresultants[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["poly",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["poly",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " are zero.   "
}], "Text",
  CellTags->{"S3.3.4", "4.17"}],

Cell[TextData[{
  "Here is the resultant with respect to ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " of two polynomials in ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". The original polynomials have a common root in ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " only for values of ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " at which the resultant vanishes. "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.18"}],

Cell[CellGroupData[{

Cell["Resultant[(x-y)^2-2, y^2-3, y]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(1 - 10\ x\^2 + x\^4\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  "Gr\[ODoubleDot]bner bases appear in many modern algebraic algorithms and \
applications. The function ",
  StyleBox["GroebnerBasis[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["poly",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["poly",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " takes a set of polynomials, and reduces this set to a canonical form from \
which many properties can conveniently be deduced. An important feature is \
that the set of polynomials obtained from ",
  StyleBox["GroebnerBasis", "MR"],
  " always has exactly the same collection of common roots as the original \
set.               "
}], "Text",
  CellTags->{"S3.3.4", "4.19"}],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], "+", 
              StyleBox["y",
                "TI"]}], ")"}], "2"], TraditionalForm]], "InlineFormula"],
  " is effectively redundant, and so does not appear in the \
Gr\[ODoubleDot]bner basis. "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.20"}],

Cell[CellGroupData[{

Cell["GroebnerBasis[{(x+y), (x+y)^2}, {x, y}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \({x + y}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  "The polynomial ",
  StyleBox["1", "MR"],
  " has no roots, showing that the original polynomials have no common roots. \
"
}], "MathCaption",
  CellTags->{"S3.3.4", "4.21"}],

Cell[CellGroupData[{

Cell["GroebnerBasis[{x+y,x^2-1,y^2-2x}, {x, y}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \({1}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell["\<\
The polynomials are effectively unwound here, and can now be seen \
to have exactly five common roots. \
\>", "MathCaption",
  CellTags->{"S3.3.4", "4.22"}],

Cell[CellGroupData[{

Cell["GroebnerBasis[{x y^2+2 x y+x^2+1, x y+y^2+1}, {x, y}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \({\(-1\) - y\^2 + y\^3 + y\^4 + y\^5, 
      x + y\^2 + y\^3 + y\^4}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["PolynomialReduce[", "MR"],
  StyleBox["poly", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["p",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["p",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " yields a list ",
  StyleBox["{{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["}", "MR"],
  " of polynomials with the property that ",
  StyleBox["b", "TI"],
  " is minimal and ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["p",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["+", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["p",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["+", "MR"],
  " ",
  "\[Ellipsis]",
  "  ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "TI"],
  " is exactly ",
  StyleBox["poly", "TI"],
  ".  "
}], "Text",
  CellTags->{"S3.3.4", "4.23"}],

Cell[TextData[{
  "This writes ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"], "+", 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "2"]}], TraditionalForm]], "InlineFormula"],
  " in terms of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "-", 
          StyleBox["y",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            "TI"], "+", 
          StyleBox["a",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ", leaving a remainder that depends only on ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.24"}],

Cell[CellGroupData[{

Cell["PolynomialReduce[x^2 + y^2, {x - y, y + a}, {x, y}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \({{x + y, \(-2\)\ a + 2\ y}, 2\ a\^2}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Factor[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["factor a polynomial "]},
          {Cell[TextData[{
              StyleBox["FactorSquareFree[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
write a polynomial as a product of powers of square\
\[Hyphen]free factors \
\>"]},
          {Cell[TextData[{
              StyleBox["FactorTerms[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "factor out terms that do not depend on ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FactorList[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["FactorSquareFreeList[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["FactorTermsList[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["give results as lists of factors "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.4"],

Cell["Functions for factoring polynomials. ", "Caption",
  CellTags->"S3.3.4"],

Cell[TextData[{
  StyleBox["Factor", "MR"],
  ", ",
  StyleBox["FactorTerms", "MR"],
  " and ",
  StyleBox["FactorSquareFree", "MR"],
  " perform various degrees of factoring on polynomials. ",
  StyleBox["Factor", "MR"],
  " does full factoring over the integers. ",
  StyleBox["FactorTerms", "MR"],
  " extracts the \[OpenCurlyDoubleQuote]content\[CloseCurlyDoubleQuote] of \
the polynomial. ",
  StyleBox["FactorSquareFree", "MR"],
  " pulls out any multiple factors that appear. "
}], "Text",
  CellTags->{"S3.3.4", "4.25"}],

Cell["Here is a polynomial, in expanded form. ", "MathCaption",
  CellTags->{"S3.3.4", "4.26"}],

Cell[CellGroupData[{

Cell["t = Expand[ 2 (1 + x)^2 (2 + x) (3 + x) ]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(12 + 34\ x + 34\ x\^2 + 14\ x\^3 + 2\ x\^4\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FactorTerms", "MR"],
  " pulls out only the factor of ",
  StyleBox["2", "MR"],
  " that does not depend on ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.27"}],

Cell[CellGroupData[{

Cell["FactorTerms[t, x]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(2\ \((6 + 17\ x + 17\ x\^2 + 7\ x\^3 + x\^4)\)\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FactorSquareFree", "MR"],
  " factors out the ",
  StyleBox["2", "MR"],
  " and the term ",
  StyleBox["(1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x)^2", "MR"],
  ", but leaves the rest unfactored. "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.28"}],

Cell[CellGroupData[{

Cell["FactorSquareFree[t]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(2\ \((1 + x)\)\^2\ \((6 + 5\ x + x\^2)\)\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Factor", "MR"],
  " does full factoring, recovering the original form. "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.29"}],

Cell[CellGroupData[{

Cell["Factor[t]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(2\ \((1 + x)\)\^2\ \((2 + x)\)\ \((3 + x)\)\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  "Particularly when you write programs that work with polynomials, you will \
often find it convenient to pick out pieces of polynomials in a standard \
form. The function ",
  StyleBox["FactorList", "MR"],
  " gives a list of all the factors of a polynomial, together with their \
exponents. The first element of the list is always the overall numerical \
factor for the polynomial.  "
}], "Text",
  CellTags->{"S3.3.4", "4.30"}],

Cell[TextData[{
  "The form that ",
  StyleBox["FactorList", "MR"],
  " returns is the analog for polynomials of the form produced by ",
  StyleBox["FactorInteger", "MR"],
  " for integers. "
}], "Text",
  CellTags->{"S3.3.4", "4.31"}],

Cell["\<\
Here is a list of the factors of the polynomial in the previous set \
of examples. Each element of the list gives the factor, together with its \
exponent. \
\>", "MathCaption",
  CellTags->{"S3.3.4", "4.32"}],

Cell[CellGroupData[{

Cell["FactorList[t]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \({{2, 1}, {1 + x, 2}, {2 + x, 1}, {3 + x, 1}}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Factor[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["GaussianIntegers", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True]", "MR"],
              " "
            }]], 
            Cell["\<\
factor a polynomial, allowing coefficients that are \
Gaussian integers \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.4"],

Cell["Factoring polynomials with complex coefficients. ", "Caption",
  CellTags->"S3.3.4"],

Cell[TextData[{
  StyleBox["Factor", "MR"],
  " and related functions usually handle only polynomials with ordinary \
integer or rational\[Hyphen]number coefficients. If you set the option ",
  StyleBox["GaussianIntegers", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ", however, then ",
  StyleBox["Factor", "MR"],
  " will allow polynomials with coefficients that are complex numbers with \
rational real and imaginary parts. This often allows more extensive \
factorization to be performed. "
}], "Text",
  CellTags->{"S3.3.4", "4.33"}],

Cell["\<\
This polynomial is irreducible when only ordinary integers are \
allowed. \
\>", "MathCaption",
  CellTags->{"S3.3.4", "4.34"}],

Cell[CellGroupData[{

Cell["Factor[1 + x^2]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(1 + x\^2\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell["\<\
When Gaussian integer coefficients are allowed, the polynomial \
factors. \
\>", "MathCaption",
  CellTags->{"S3.3.4", "4.35"}],

Cell[CellGroupData[{

Cell["Factor[1 + x^2, GaussianIntegers -> True]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(\((\(-\[ImaginaryI]\) + x)\)\ \((\[ImaginaryI] + x)\)\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Cyclotomic[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the cyclotomic polynomial of order ",
              StyleBox["n", "TI"],
              " in ",
              StyleBox["x", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.4"],

Cell["Cyclotomic polynomials. ", "Caption",
  CellTags->"S3.3.4"],

Cell[TextData[{
  "Cyclotomic polynomials arise as \[OpenCurlyDoubleQuote]elementary \
polynomials\[CloseCurlyDoubleQuote] in various algebraic algorithms. The \
cyclotomic polynomials are defined by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["C",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          UnderscriptBox["\[Product]", 
            StyleBox["k",
              "TI"],
            LimitsPositioning->True], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], "-", 
              SuperscriptBox[
                StyleBox["e",
                  "TI"], 
                RowBox[{"2", "\[Pi]", 
                  StyleBox["i",
                    "TI"], 
                  StyleBox["k",
                    "TI"], "/", 
                  StyleBox["n",
                    "TI"]}]]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " runs over all positive integers less than ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " that are relatively prime to ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.3.4", "4.36"}],

Cell[TextData[{
  "This is the cyclotomic polynomial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["C",
              "TI"], "6"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.37"}],

Cell[CellGroupData[{

Cell["Cyclotomic[6, x]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(1 - x + x\^2\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["C",
              "TI"], "6"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " appears in the factors of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "6"], "-", "1"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.38"}],

Cell[CellGroupData[{

Cell["Factor[x^6 - 1]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(\((\(-1\) + x)\)\ \((1 + x)\)\ \((1 - x + x\^2)\)\ \((1 + x + 
          x\^2)\)\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Decompose[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "decompose ",
              StyleBox["poly", "TI"],
              
              ", if possible, into a composition of a list of simpler \
polynomials "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.4"],

Cell["Decomposing polynomials. ", "Caption",
  CellTags->"S3.3.4"],

Cell[TextData[{
  "Factorization is one important way of breaking down polynomials into \
simpler parts. Another, quite different, way is ",
  StyleBox["decomposition", "TI"],
  ". When one factors a polynomial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["P",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", one writes it as a product ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["p",
              "TI"], "1"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SubscriptBox[
            StyleBox["p",
              "TI"], "2"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "..."}], TraditionalForm]], "InlineFormula"],
  " of polynomials ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["p",
              "TI"], 
            StyleBox["i",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". Decomposing a polynomial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Q",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " consists of writing it as a ",
  StyleBox["composition", "TI"],
  " of polynomials of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["q",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox[
                StyleBox["q",
                  "TI"], "2"], 
              RowBox[{"(", 
                RowBox[{"...", 
                  RowBox[{"(", 
                    StyleBox["x",
                      "TI"], ")"}], "..."}], ")"}]}], ")"}]}], 
        TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.3.4", "4.39"}],

Cell[TextData[{
  "Here is a simple example of ",
  StyleBox["Decompose", "MR"],
  ". The original polynomial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "4"], "+", 
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"], "+", "1"}], TraditionalForm]], "InlineFormula"],
  " can be written as the polynomial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            OverscriptBox[
              StyleBox["x",
                "TI"], "_"], "2"], "+", 
          OverscriptBox[
            StyleBox["x",
              "TI"], "_"], "+", "1"}], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        OverscriptBox[
          StyleBox["x",
            "TI"], "_"], TraditionalForm]], "InlineFormula"],
  " is the polynomial ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.40"}],

Cell[CellGroupData[{

Cell["Decompose[x^4 + x^2 + 1, x]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \({1 + x + x\^2, x\^2}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell["Here are two polynomial functions. ", "MathCaption",
  CellTags->{"S3.3.4", "4.41"}],

Cell["( q1[x_] = 1 - 2x + x^4 ; q2[x_] = 5x + x^3 ; )", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.3.4"],

Cell["This gives the composition of the two functions. ", "MathCaption",
  CellTags->{"S3.3.4", "4.42"}],

Cell[CellGroupData[{

Cell["Expand[ q1[ q2[ x ] ] ]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(1 - 10\ x - 2\ x\^3 + 625\ x\^4 + 500\ x\^6 + 150\ x\^8 + 20\ x\^10 + 
      x\^12\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Decompose", "MR"],
  " recovers the original functions. "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.43"}],

Cell[CellGroupData[{

Cell["Decompose[%, x]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \({1 - 2\ x + x\^4, 5\ x + x\^3}\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Decompose[", "MR"],
  StyleBox["poly", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " is set up to give a list of polynomials in ",
  StyleBox["x", "TI"],
  ", which, if composed, reproduce the original polynomial. The original \
polynomial can contain variables other than ",
  StyleBox["x", "TI"],
  ", but the sequence of polynomials that ",
  StyleBox["Decompose", "MR"],
  " produces are all intended to be considered as functions of ",
  StyleBox["x", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.3.4", "4.44"}],

Cell[TextData[{
  "Unlike factoring, the decomposition of polynomials is not completely \
unique. For example, the two sets of polynomials ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["p",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["q",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", related by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["q",
              "TI"], "1"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          SubscriptBox[
            StyleBox["p",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], "-", 
              StyleBox["a",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["q",
              "TI"], "2"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          SubscriptBox[
            StyleBox["p",
              "TI"], "2"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "+", 
          StyleBox["a",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " give the same result on composition, so that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["p",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox[
                StyleBox["p",
                  "TI"], "2"], 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}], ")"}], "=", 
          SubscriptBox[
            StyleBox["q",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox[
                StyleBox["q",
                  "TI"], "2"], 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " follows the convention of absorbing any constant terms into the first \
polynomial in the list produced by ",
  StyleBox["Decompose", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.3.4", "4.45"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["InterpolatingPolynomial[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a polynomial in ",
              StyleBox["x", "TI"],
              " which is equal to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " when ",
              StyleBox["x", "TI"],
              " is the integer ",
              StyleBox["i", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InterpolatingPolynomial[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a polynomial in ",
              StyleBox["x", "TI"],
              " which is equal to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " when ",
              StyleBox["x", "TI"],
              " is ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.4"],

Cell["Generating interpolating polynomials. ", "Caption",
  CellTags->"S3.3.4"],

Cell["\<\
This yields a quadratic polynomial which goes through the specified \
three points. \
\>", "MathCaption",
  CellTags->{"S3.3.4", "4.46"}],

Cell[CellGroupData[{

Cell["InterpolatingPolynomial[{{-1, 4}, {0, 2}, {1, 6}}, x]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(4 + \((1 + x)\)\ \((\(-2\) + 3\ x)\)\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S3.3.4"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["x", "MR"],
  " is ",
  StyleBox["0", "MR"],
  ", the polynomial has value\[NonBreakingSpace]",
  StyleBox["2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.4", "4.47"}],

Cell[CellGroupData[{

Cell["% /. x -> 0", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S3.3.4"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S3.3.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3.5 Polynomials Modulo Primes", "Subsection",
  CellTags->{"S3.3.5", "5.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can work with polynomials whose coefficients are in the finite field ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["Z",
            "TI"], 
          StyleBox["p",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " of integers modulo a prime ",
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          "TI"], TraditionalForm]], "InlineFormula"],
  ".     "
}], "Text",
  CellTags->{"S3.3.5", "5.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PolynomialMod[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["p", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "reduce the coefficients in a polynomial modulo ",
              StyleBox["p", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Expand[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Modulus", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["p", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "expand ",
              StyleBox["poly", "TI"],
              " modulo ",
              StyleBox["p", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Factor[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Modulus", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["p", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "factor ",
              StyleBox["poly", "TI"],
              " modulo ",
              StyleBox["p", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PolynomialGCD[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Modulus", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["p", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the GCD of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["poly",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " modulo ",
              StyleBox["p", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["GroebnerBasis[", "MR"],
              StyleBox["polys", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["vars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Modulus", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["p", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the Gr\[ODoubleDot]bner basis modulo ",
              StyleBox["p", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.5"],

Cell["Functions for manipulating polynomials over finite fields. ", "Caption",
  CellTags->"S3.3.5"],

Cell["Here is an ordinary polynomial. ", "MathCaption",
  CellTags->{"S3.3.5", "5.3"}],

Cell[CellGroupData[{

Cell["Expand[ (1 + x)^6 ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.3.5"],

Cell[BoxData[
    \(1 + 6\ x + 15\ x\^2 + 20\ x\^3 + 15\ x\^4 + 6\ x\^5 + x\^6\)], "Output",\

  CellLabel->"Out[1]= ",
  CellTags->"S3.3.5"]
}, Open  ]],

Cell["This reduces the coefficients modulo 2. ", "MathCaption",
  CellTags->{"S3.3.5", "5.4"}],

Cell[CellGroupData[{

Cell["PolynomialMod[%, 2]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.3.5"],

Cell[BoxData[
    \(1 + x\^2 + x\^4 + x\^6\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.3.5"]
}, Open  ]],

Cell["\<\
Here are the factors of the resulting polynomial over the integers. \
\
\>", "MathCaption",
  CellTags->{"S3.3.5", "5.5"}],

Cell[CellGroupData[{

Cell["Factor[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.3.5"],

Cell[BoxData[
    \(\((1 + x\^2)\)\ \((1 + x\^4)\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.3.5"]
}, Open  ]],

Cell["If you work modulo 2, further factoring becomes possible. ", \
"MathCaption",
  CellTags->{"S3.3.5", "5.6"}],

Cell[CellGroupData[{

Cell["Factor[%, Modulus->2]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.3.5"],

Cell[BoxData[
    \(\((1 + x)\)\^6\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.3.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
3.3.6 Advanced Topic: Polynomials over Algebraic Number \
Fields\
\>", "Subsection",
  CellTags->{"S3.3.6", "6.1"}],

Cell[TextData[{
  "Functions like ",
  StyleBox["Factor", "MR"],
  " usually assume that all coefficients in the polynomials they produce must \
involve only rational numbers. But by setting the option ",
  StyleBox["Extension", "MR"],
  " you can extend the domain of coefficients that will be allowed. "
}], "Text",
  CellTags->{"S3.3.6", "6.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Factor[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Extension->{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "factor ",
              StyleBox["poly", "TI"],
              " allowing coefficients that are rational combinations of the ",
              
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.6"],

Cell["Factoring polynomials over algebraic number fields. ", "Caption",
  CellTags->"S3.3.6"],

Cell["\<\
Allowing only rational number coefficients, this polynomial cannot \
be factored. \
\>", "MathCaption",
  CellTags->{"S3.3.6", "6.3"}],

Cell[CellGroupData[{

Cell["Factor[1 + x^4]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.3.6"],

Cell[BoxData[
    \(1 + x\^4\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.3.6"]
}, Open  ]],

Cell[TextData[{
  "With coefficients that can involve ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)], "InlineFormula"],
  ", the polynomial can now be factored. "
}], "MathCaption",
  CellTags->{"S3.3.6", "6.4"}],

Cell[CellGroupData[{

Cell["Factor[1 + x^4, Extension -> {Sqrt[2]}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.3.6"],

Cell[BoxData[
    \(\(-\((\(-1\) + \@2\ x - x\^2)\)\)\ \((1 + \@2\ x + x\^2)\)\)], "Output",\

  CellLabel->"Out[2]= ",
  CellTags->"S3.3.6"]
}, Open  ]],

Cell[TextData[{
  "The polynomial can also be factored if one allows coefficients involving \
",
  Cell[BoxData[
      \(TraditionalForm\`\@\(-1\)\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.6", "6.5"}],

Cell[CellGroupData[{

Cell["Factor[1 + x^4, Extension -> {Sqrt[-1]}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.3.6"],

Cell[BoxData[
    \(\((\(-\[ImaginaryI]\) + x\^2)\)\ \((\[ImaginaryI] + x\^2)\)\)], "Output",\

  CellLabel->"Out[3]= ",
  CellTags->"S3.3.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["GaussianIntegers->True", "MR"],
  " is equivalent to ",
  StyleBox["Extension->Sqrt[-1]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.6", "6.6"}],

Cell[CellGroupData[{

Cell["Factor[1 + x^4, GaussianIntegers -> True]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.3.6"],

Cell[BoxData[
    \(\((\(-\[ImaginaryI]\) + x\^2)\)\ \((\[ImaginaryI] + x\^2)\)\)], "Output",\

  CellLabel->"Out[4]= ",
  CellTags->"S3.3.6"]
}, Open  ]],

Cell[TextData[{
  "If one allows coefficients that involve both ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(-1\)\)], "InlineFormula"],
  " the polynomial can be factored completely. "
}], "MathCaption",
  CellTags->{"S3.3.6", "6.7"}],

Cell[CellGroupData[{

Cell["Factor[1 + x^4, Extension -> {Sqrt[2], Sqrt[-1]}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.3.6"],

Cell[BoxData[
    \(1\/4\ \((\@2 - \((1 + \[ImaginaryI])\)\ x)\)\ \((\@2 - \((1 - \
\[ImaginaryI])\)\ x)\)\ \((\@2 + \((1 - \[ImaginaryI])\)\ x)\)\ \((\@2 + \((1 \
+ \[ImaginaryI])\)\ x)\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.3.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Expand", "MR"],
  " gives the original polynomial back again. "
}], "MathCaption",
  CellTags->{"S3.3.6", "6.8"}],

Cell[CellGroupData[{

Cell["Expand[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.3.6"],

Cell[BoxData[
    \(1 + x\^4\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.3.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Factor[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Extension->Automatic]", "MR"],
              " "
            }]], Cell[TextData[{
              "factor ",
              StyleBox["poly", "TI"],
              " allowing algebraic numbers in ",
              StyleBox["poly", "TI"],
              " to appear in coefficients "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.6"],

Cell["Factoring polynomials with algebraic number coefficients. ", "Caption",
  CellTags->"S3.3.6"],

Cell[TextData[{
  "Here is a polynomial with a coefficient involving ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.6", "6.9"}],

Cell[CellGroupData[{

Cell["t = Expand[(Sqrt[2] + x)^2]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.3.6"],

Cell[BoxData[
    \(2 + 2\ \@2\ x + x\^2\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.3.6"]
}, Open  ]],

Cell[TextData[{
  "By default, ",
  StyleBox["Factor", "MR"],
  " will not factor this polynomial. "
}], "MathCaption",
  CellTags->{"S3.3.6", "6.10"}],

Cell[CellGroupData[{

Cell["Factor[t]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.3.6"],

Cell[BoxData[
    \(2 + 2\ \@2\ x + x\^2\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.3.6"]
}, Open  ]],

Cell[TextData[{
  "But now the field of coefficients is extended by including ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)], "InlineFormula"],
  ", and the polynomial is factored. "
}], "MathCaption",
  CellTags->{"S3.3.6", "6.11"}],

Cell[CellGroupData[{

Cell["Factor[t, Extension -> Automatic]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.3.6"],

Cell[BoxData[
    \(\((\@2 + x)\)\^2\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.3.6"]
}, Open  ]],

Cell[TextData[{
  "Other polynomial functions work much like ",
  StyleBox["Factor", "MR"],
  ". By default, they treat algebraic number coefficients just like \
independent symbolic variables. But with the option ",
  StyleBox["Extension->Automatic", "MR"],
  " they perform operations on these coefficients. "
}], "Text",
  CellTags->{"S3.3.6", "6.12"}],

Cell[TextData[{
  "By default, ",
  StyleBox["Cancel", "MR"],
  " does not reduce these polynomials.   "
}], "MathCaption",
  CellTags->{"S3.3.6", "6.13"}],

Cell[CellGroupData[{

Cell["Cancel[t / (x^2 - 2)]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.3.6"],

Cell[BoxData[
    \(\(2 + 2\ \@2\ x + x\^2\)\/\(\(-2\) + x\^2\)\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.3.6"]
}, Open  ]],

Cell["But now it does. ", "MathCaption",
  CellTags->{"S3.3.6", "6.14"}],

Cell[CellGroupData[{

Cell["Cancel[t / (x^2 - 2), Extension->Automatic]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.3.6"],

Cell[BoxData[
    \(\(\(-\@2\) - x\)\/\(\@2 - x\)\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.3.6"]
}, Open  ]],

Cell[TextData[{
  "By default, ",
  StyleBox["PolynomialLCM", "MR"],
  " pulls out no common factors.  "
}], "MathCaption",
  CellTags->{"S3.3.6", "6.15"}],

Cell[CellGroupData[{

Cell["PolynomialLCM[t, x^2 - 2]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.3.6"],

Cell[BoxData[
    \(\((\(-2\) + x\^2)\)\ \((2 + 2\ \@2\ x + x\^2)\)\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.3.6"]
}, Open  ]],

Cell["But now it does. ", "MathCaption",
  CellTags->{"S3.3.6", "6.16"}],

Cell[CellGroupData[{

Cell["PolynomialLCM[t, x^2 - 2, Extension->Automatic]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.3.6"],

Cell[BoxData[
    \(\(-2\)\ \@2 - 2\ x + \@2\ x\^2 + x\^3\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.3.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3.7 Trigonometric Expressions", "Subsection",
  CellTags->{"S3.3.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["TrigExpand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "expand trigonometric expressions out into a sum of terms "]},
          {Cell[TextData[{
              StyleBox["TrigFactor[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "factor trigonometric expressions into products of terms "]},
          {Cell[TextData[{
              StyleBox["TrigFactorList[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["give terms and their exponents in a list "]},
          {Cell[TextData[{
              StyleBox["TrigReduce[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "reduce trigonometric expressions using multiple angles "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.7"],

Cell["Functions for manipulating trigonometric expressions. ", "Caption",
  CellTags->"S3.3.7"],

Cell["This expands out a trigonometric expression. ", "MathCaption",
  CellTags->{"S3.3.7", "7.2"}],

Cell[CellGroupData[{

Cell["TrigExpand[Sin[2 x] Cos[2 y]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.3.7"],

Cell[BoxData[
    \(2\ Cos[x]\ Cos[y]\^2\ Sin[x] - 2\ Cos[x]\ Sin[x]\ Sin[y]\^2\)], "Output",\

  CellLabel->"Out[1]= ",
  CellTags->"S3.3.7"]
}, Open  ]],

Cell["This factors the expression. ", "MathCaption",
  CellTags->{"S3.3.7", "7.3"}],

Cell[CellGroupData[{

Cell["TrigFactor[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.3.7"],

Cell[BoxData[
    \(2\ Cos[x]\ Sin[
        x]\ \((Cos[y] - Sin[y])\)\ \((Cos[y] + Sin[y])\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.3.7"]
}, Open  ]],

Cell["\<\
And this reduces the expression to a form linear in the \
trigonometric functions. \
\>", "MathCaption",
  CellTags->{"S3.3.7", "7.4"}],

Cell[CellGroupData[{

Cell["TrigReduce[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.3.7"],

Cell[BoxData[
    \(1\/2\ \((Sin[2\ x - 2\ y] + Sin[2\ x + 2\ y])\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.3.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["TrigExpand", "MR"],
  " works on hyperbolic as well as circular functions. "
}], "MathCaption",
  CellTags->{"S3.3.7", "7.5"}],

Cell[CellGroupData[{

Cell["TrigExpand[Tanh[x + y]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.3.7"],

Cell[BoxData[
    \(\(Cosh[y]\ Sinh[x]\)\/\(Cosh[x]\ Cosh[y] + Sinh[x]\ Sinh[y]\) + \
\(Cosh[x]\ Sinh[y]\)\/\(Cosh[x]\ Cosh[y] + Sinh[x]\ Sinh[y]\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.3.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["TrigReduce", "MR"],
  " reproduces the original form again. "
}], "MathCaption",
  CellTags->{"S3.3.7", "7.6"}],

Cell[CellGroupData[{

Cell["TrigReduce[%]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.3.7"],

Cell[BoxData[
    \(Tanh[x + y]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.3.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " automatically uses functions like ",
  StyleBox["Tan", "MR"],
  " whenever it can. "
}], "MathCaption",
  CellTags->{"S3.3.7", "7.7"}],

Cell[CellGroupData[{

Cell["Sin[x]^2/Cos[x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.3.7"],

Cell[BoxData[
    \(Sin[x]\ Tan[x]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.3.7"]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["TrigFactorList", "MR"],
  ", however, you can see the parts of functions like ",
  StyleBox["Tan", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.7", "7.8"}],

Cell[CellGroupData[{

Cell["TrigFactorList[%]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.3.7"],

Cell[BoxData[
    \({{1, 1}, {Sin[x], 2}, {Cos[x], \(-1\)}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.3.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["TrigToExp[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "write trigonometric functions in terms of exponentials "]},
          {Cell[TextData[{
              StyleBox["ExpToTrig[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "write exponentials in terms of trigonometric functions "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.7"],

Cell["Converting to and from exponentials. ", "Caption",
  CellTags->"S3.3.7"],

Cell[TextData[{
  StyleBox["TrigToExp", "MR"],
  " writes trigonometric functions in terms of exponentials. "
}], "MathCaption",
  CellTags->{"S3.3.7", "7.9"}],

Cell[CellGroupData[{

Cell["TrigToExp[Tan[x]]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.3.7"],

Cell[BoxData[
    \(\(\[ImaginaryI]\ \((\[ExponentialE]\^\(\(-\[ImaginaryI]\)\ x\) - \
\[ExponentialE]\^\(\[ImaginaryI]\ x\))\)\)\/\(\[ExponentialE]\^\(\(-\
\[ImaginaryI]\)\ x\) + \[ExponentialE]\^\(\[ImaginaryI]\ x\)\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.3.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ExpToTrig", "MR"],
  " does the reverse, getting rid of explicit complex numbers whenever \
possible. "
}], "MathCaption",
  CellTags->{"S3.3.7", "7.10"}],

Cell[CellGroupData[{

Cell["ExpToTrig[%]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.3.7"],

Cell[BoxData[
    \(Tan[x]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.3.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ExpToTrig", "MR"],
  " deals with hyperbolic as well as circular functions. "
}], "MathCaption",
  CellTags->{"S3.3.7", "7.11"}],

Cell[CellGroupData[{

Cell["ExpToTrig[Exp[x] - Exp[-x]]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.3.7"],

Cell[BoxData[
    \(2\ Sinh[x]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.3.7"]
}, Open  ]],

Cell[TextData[{
  "You can also use ",
  StyleBox["ExpToTrig", "MR"],
  " on purely numerical expressions. "
}], "MathCaption",
  CellTags->{"S3.3.7", "7.12"}],

Cell[CellGroupData[{

Cell["ExpToTrig[(-1)^(1/17)]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.3.7"],

Cell[BoxData[
    \(Cos[\[Pi]\/17] + \[ImaginaryI]\ Sin[\[Pi]\/17]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.3.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3.8 Expressions Involving Complex Variables", "Subsection",
  CellTags->{"S3.3.8", "8.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " usually pays no attention to whether variables like ",
  StyleBox["x", "MR"],
  " stand for real or complex numbers. Sometimes, however, you may want to \
make transformations which are appropriate only if particular variables are \
assumed to be either real or complex. "
}], "Text",
  CellTags->{"S3.3.8", "8.2"}],

Cell[TextData[{
  "The function ",
  StyleBox["ComplexExpand", "MR"],
  " expands out algebraic and trigonometric expressions, making definite \
assumptions about the variables that appear. "
}], "Text",
  CellTags->{"S3.3.8", "8.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ComplexExpand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "expand ",
              StyleBox["expr", "TI"],
              " assuming that all variables are real "
            }]]},
          {Cell[TextData[{
              StyleBox["ComplexExpand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "expand ",
              StyleBox["expr", "TI"],
              " assuming that the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " are complex "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.8"],

Cell["Expanding complex expressions. ", "Caption",
  CellTags->"S3.3.8"],

Cell[TextData[{
  "This expands the expression, assuming that ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  " are both real. "
}], "MathCaption",
  CellTags->{"S3.3.8", "8.4"}],

Cell[CellGroupData[{

Cell["ComplexExpand[Tan[x + I y]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.3.8"],

Cell[BoxData[
    \(Sin[2\ x]\/\(Cos[2\ x] + Cosh[2\ y]\) + \(\[ImaginaryI]\ Sinh[2\ y]\)\/\
\(Cos[2\ x] + Cosh[2\ y]\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.3.8"]
}, Open  ]],

Cell[TextData[{
  "In this case, ",
  StyleBox["a", "MR"],
  " is assumed to be real, but ",
  StyleBox["x", "MR"],
  " is assumed to be complex, and is broken into explicit real and imaginary \
parts. "
}], "MathCaption",
  CellTags->{"S3.3.8", "8.5"}],

Cell[CellGroupData[{

Cell["ComplexExpand[a + x^2, {x}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.3.8"],

Cell[BoxData[
    \(a - Im[x]\^2 + 2\ \[ImaginaryI]\ Im[x]\ Re[x] + Re[x]\^2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.3.8"]
}, Open  ]],

Cell["\<\
With several complex variables, you quickly get quite complicated \
results. \
\>", "MathCaption",
  CellTags->{"S3.3.8", "8.6"}],

Cell[CellGroupData[{

Cell["ComplexExpand[Sin[x] Exp[y], {x, y}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.3.8"],

Cell[BoxData[
    \(\[ExponentialE]\^Re[y]\ Cos[Im[y]]\ Cosh[Im[x]]\ Sin[
          Re[x]] - \[ExponentialE]\^Re[y]\ Cos[Re[x]]\ Sin[Im[y]]\ Sinh[
          Im[x]] + \[ImaginaryI]\ \((\[ExponentialE]\^Re[y]\ Cosh[Im[x]]\ Sin[
                Im[y]]\ Sin[Re[x]] + \[ExponentialE]\^Re[y]\ Cos[Im[y]]\ Cos[
                Re[x]]\ Sinh[Im[x]])\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.3.8"]
}, Open  ]],

Cell[TextData[{
  "There are several ways to write a complex variable ",
  StyleBox["z", "TI"],
  " in terms of real parameters. As above, for example, ",
  StyleBox["z", "TI"],
  " can be written in the \[OpenCurlyDoubleQuote]Cartesian form\
\[CloseCurlyDoubleQuote] ",
  StyleBox["Re[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["I", "MR"],
  " ",
  StyleBox["Im[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  ". But it can equally well be written in the \[OpenCurlyDoubleQuote]polar \
form\[CloseCurlyDoubleQuote] ",
  StyleBox["Abs[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " ",
  StyleBox["Exp[I", "MR"],
  " ",
  StyleBox["Arg[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.3.8", "8.7"}],

Cell[TextData[{
  "The option ",
  StyleBox["TargetFunctions", "MR"],
  " in ",
  StyleBox["ComplexExpand", "MR"],
  " allows you to specify how complex variables should be written. ",
  StyleBox["TargetFunctions", "MR"],
  " can be set to a list of functions from the set ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["Re,", "MR"],
  " ",
  StyleBox["Im,", "MR"],
  " ",
  StyleBox["Abs,", "MR"],
  " ",
  StyleBox["Arg,", "MR"],
  " ",
  StyleBox["Conjugate,", "MR"],
  " ",
  StyleBox["Sign", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  ". ",
  StyleBox["ComplexExpand", "MR"],
  " will try to give results in terms of whichever of these functions you \
request. The default is typically to give results in terms of ",
  StyleBox["Re", "MR"],
  " and ",
  StyleBox["Im", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.3.8", "8.8"}],

Cell["This gives an expansion in Cartesian form. ", "MathCaption",
  CellTags->{"S3.3.8", "8.9"}],

Cell[CellGroupData[{

Cell["ComplexExpand[Re[z^2], {z}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.3.8"],

Cell[BoxData[
    \(\(-Im[z]\^2\) + Re[z]\^2\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.3.8"]
}, Open  ]],

Cell["Here is an expansion in polar form. ", "MathCaption",
  CellTags->{"S3.3.8", "8.10"}],

Cell[CellGroupData[{

Cell["ComplexExpand[Re[z^2], {z}, TargetFunctions -> {Abs, Arg}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.3.8"],

Cell[BoxData[
    \(Abs[z]\^2\ Cos[Arg[z]]\^2 - Abs[z]\^2\ Sin[Arg[z]]\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.3.8"]
}, Open  ]],

Cell["Here is another form of expansion. ", "MathCaption",
  CellTags->{"S3.3.8", "8.11"}],

Cell[CellGroupData[{

Cell["ComplexExpand[Re[z^2], {z}, TargetFunctions -> Conjugate]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.3.8"],

Cell[BoxData[
    \(z\^2\/2 + Conjugate[z]\^2\/2\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.3.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3.9 Advanced Topic: Logical and Piecewise Functions", "Subsection",
  CellTags->{"S3.3.9", "9.1"}],

Cell[TextData[{
  "Nested logical and piecewise functions can be expanded out much like \
nested arithmetic functions. You can do this using ",
  StyleBox["LogicalExpand", "MR"],
  " and ",
  StyleBox["PiecewiseExpand", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.3.9", "9.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LogicalExpand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "expand out logical functions in ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PiecewiseExpand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "expand out piecewise functions in ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PiecewiseExpand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["assum", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["expand out with the specified assumptions "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.9"],

Cell["Expanding out logical and piecewise functions. ", "Caption",
  CellTags->"S3.3.9"],

Cell[TextData[{
  StyleBox["LogicalExpand", "MR"],
  " puts logical expressions into a standard ",
  StyleBox["disjunctive normal form", "TI"],
  " (DNF), consisting of an OR of ANDs.    "
}], "Text",
  CellTags->{"S3.3.9", "9.3"}],

Cell[TextData[{
  "By default, ",
  StyleBox["Mathematica", "TI"],
  " leaves this expression unchanged. "
}], "MathCaption",
  CellTags->{"S3.3.9", "9.4"}],

Cell[CellGroupData[{

Cell["(a || b) && c", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.3.9"],

Cell[BoxData[
    \(\((a || b)\) && c\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.3.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["LogicalExpand", "MR"],
  " expands this into an OR of ANDs. "
}], "MathCaption",
  CellTags->{"S3.3.9", "9.5"}],

Cell[CellGroupData[{

Cell["LogicalExpand[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.3.9"],

Cell[BoxData[
    \(\((a && c)\) || \((b && c)\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.3.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["LogicalExpand", "MR"],
  " works on all logical functions, always converting them into a standard OR \
of ANDs form. Sometimes the results are inevitably quite large. "
}], "Text",
  CellTags->{"S3.3.9", "9.6"}],

Cell[TextData[{
  StyleBox["Xor", "MR"],
  " can be expressed as an OR of ANDs. "
}], "MathCaption",
  CellTags->{"S3.3.9", "9.7"}],

Cell[CellGroupData[{

Cell["LogicalExpand[Xor[a, b, c]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.3.9"],

Cell[BoxData[
    \(\((a && b && 
          c)\) || \((a && \(! b\) && \(! c\))\) || \((b && \(! a\) && \(! \
c\))\) || \((c && \(! a\) && \(! b\))\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.3.9"]
}, Open  ]],

Cell[TextData[{
  "Any collection of nested conditionals can always in effect be flattened \
into a ",
  StyleBox["piecewise normal form", "TI"],
  " consisting of a single ",
  StyleBox["Piecewise", "MR"],
  " object. You can do this in ",
  StyleBox["Mathematica", "TI"],
  " using ",
  StyleBox["PiecewiseExpand", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.3.9", "9.8"}],

Cell[TextData[{
  "By default, ",
  StyleBox["Mathematica", "TI"],
  " leaves this expression unchanged. "
}], "MathCaption",
  CellTags->{"S3.3.9", "9.9"}],

Cell[CellGroupData[{

Cell["If[x > 0, If[x < 1, a, b], c]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.3.9"],

Cell[BoxData[
    \(If[x > 0, If[x < 1, a, b], c]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.3.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["PiecewiseExpand", "MR"],
  " flattens it into a single ",
  StyleBox["Piecewise", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S3.3.9", "9.10"}],

Cell[CellGroupData[{

Cell["PiecewiseExpand[%]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.3.9"],

Cell[BoxData[
    RowBox[{"\[Piecewise]", GridBox[{
          {"a", \(0 < x < 1\)},
          {"b", \(x \[GreaterEqual] 1\)},
          {"c", 
            TagBox["True",
              "PiecewiseDefault",
              AutoDelete->False,
              DeletionWarning->True]}
          },
        ColumnSpacings->1.2,
        ColumnAlignments->{Left}]}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.3.9"]
}, Open  ]],

Cell[TextData[{
  "Functions like ",
  StyleBox["Max", "MR"],
  " and ",
  StyleBox["Abs", "MR"],
  ", as well as ",
  StyleBox["Clip", "MR"],
  " and ",
  StyleBox["UnitStep", "MR"],
  ", implicitly involve conditionals, and combinations of them can again be \
reduced to a single ",
  StyleBox["Piecewise", "MR"],
  " object using ",
  StyleBox["PiecewiseExpand", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.3.9", "9.11"}],

Cell[TextData[{
  "This gives a result as a single ",
  StyleBox["Piecewise", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S3.3.9", "9.12"}],

Cell[CellGroupData[{

Cell["PiecewiseExpand[Max[Min[a, b], c]]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.3.9"],

Cell[BoxData[
    RowBox[{"\[Piecewise]", GridBox[{
          {"a", \(a - c > 0 && a - b \[LessEqual] 0\)},
          {"b", \(a - b > 0 && b - c > 0\)},
          {"c", 
            TagBox["True",
              "PiecewiseDefault",
              AutoDelete->False,
              DeletionWarning->True]}
          },
        ColumnSpacings->1.2,
        ColumnAlignments->{Left}]}]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.3.9"]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["x", "MR"],
  " assumed real, this can also be written as a ",
  StyleBox["Piecewise", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S3.3.9", "9.13"}],

Cell[CellGroupData[{

Cell["PiecewiseExpand[Abs[x], x \\[Element] Reals]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.3.9"],

Cell[BoxData[
    RowBox[{"\[Piecewise]", GridBox[{
          {\(-x\), \(x < 0\)},
          {"x", 
            TagBox["True",
              "PiecewiseDefault",
              AutoDelete->False,
              DeletionWarning->True]}
          },
        ColumnSpacings->1.2,
        ColumnAlignments->{Left}]}]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.3.9"]
}, Open  ]],

Cell[TextData[{
  "Functions like ",
  StyleBox["Floor", "MR"],
  ", ",
  StyleBox["Mod", "MR"],
  " and ",
  StyleBox["FractionalPart", "MR"],
  " can also be expressed in terms of ",
  StyleBox["Piecewise", "MR"],
  " objects, though in principle they can involve an infinite number of \
cases. "
}], "Text",
  CellTags->{"S3.3.9", "9.14"}],

Cell[TextData[{
  "Without a bound on ",
  StyleBox["x", "MR"],
  ", this would yield an infinite number of cases. "
}], "MathCaption",
  CellTags->{"S3.3.9", "9.15"}],

Cell[CellGroupData[{

Cell["PiecewiseExpand[Floor[x^2], 0 < x < 2]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.3.9"],

Cell[BoxData[
    RowBox[{"\[Piecewise]", GridBox[{
          {"1", \(1 \[LessEqual] x < \@2\)},
          {"2", \(\@2 \[LessEqual] x < \@3\)},
          {"3", \(x \[GreaterEqual] \@3\)}
          },
        ColumnSpacings->1.2,
        ColumnAlignments->{Left}]}]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.3.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " by default limits the number of cases that ",
  StyleBox["Mathematica", "TI"],
  " will explicitly generate in the expansion of any single piecewise \
function such as ",
  StyleBox["Floor", "MR"],
  " at any stage in a computation. You can change this limit by resetting the \
value of ",
  StyleBox["$MaxPiecewiseCases", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.3.9", "9.16"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3.10 Simplification", "Subsection",
  CellTags->{"S3.3.10", "10.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Simplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
try various algebraic and trigonometric transformations \
to simplify an expression \
\>"]},
          {Cell[TextData[{
              StyleBox["FullSimplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["try a much wider range of transformations "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.10"],

Cell["Simplifying expressions. ", "Caption",
  CellTags->"S3.3.10"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " does not automatically simplify an algebraic expression like this. "
}], "MathCaption",
  CellTags->{"S3.3.10", "10.2"}],

Cell[CellGroupData[{

Cell["(1 - x)/(1 - x^2)", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.3.10"],

Cell[BoxData[
    \(\(1 - x\)\/\(1 - x\^2\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.3.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Simplify", "MR"],
  " performs the simplification. "
}], "MathCaption",
  CellTags->{"S3.3.10", "10.3"}],

Cell[CellGroupData[{

Cell["Simplify[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.3.10"],

Cell[BoxData[
    \(1\/\(1 + x\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.3.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Simplify", "MR"],
  " performs standard algebraic and trigonometric simplifications. "
}], "MathCaption",
  CellTags->{"S3.3.10", "10.4"}],

Cell[CellGroupData[{

Cell["Simplify[Sin[x]^2 + Cos[x]^2]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.3.10"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.3.10"]
}, Open  ]],

Cell["\<\
It does not, however, do more sophisticated transformations that \
involve, for example, special functions. \
\>", "MathCaption",
  CellTags->{"S3.3.10", "10.5"}],

Cell[CellGroupData[{

Cell["Simplify[Gamma[1+n]/n]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.3.10"],

Cell[BoxData[
    \(Gamma[1 + n]\/n\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.3.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FullSimplify", "MR"],
  " does perform such transformations. "
}], "MathCaption",
  CellTags->{"S3.3.10", "10.6"}],

Cell[CellGroupData[{

Cell["FullSimplify[%]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.3.10"],

Cell[BoxData[
    \(Gamma[n]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.3.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FullSimplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ExcludedForms", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["pattern", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to simplify ",
              StyleBox["expr", "TI"],
              ", without touching subexpressions that match ",
              StyleBox["pattern", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.10"],

Cell["Controlling simplification. ", "Caption",
  CellTags->"S3.3.10"],

Cell["\<\
Here is an expression involving trigonometric functions and square \
roots. \
\>", "MathCaption",
  CellTags->{"S3.3.10", "10.7"}],

Cell[CellGroupData[{

Cell["t = (1 - Sin[x]^2) Sqrt[Expand[(1 + Sqrt[2])^20]]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.3.10"],

Cell[BoxData[
    \(\@\(22619537 + 15994428\ \@2\)\ \((1 - Sin[x]\^2)\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.3.10"]
}, Open  ]],

Cell[TextData[{
  "By default, ",
  StyleBox["FullSimplify", "MR"],
  " will try to simplify everything. "
}], "MathCaption",
  CellTags->{"S3.3.10", "10.8"}],

Cell[CellGroupData[{

Cell["FullSimplify[t]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.3.10"],

Cell[BoxData[
    \(\((3363 + 2378\ \@2)\)\ Cos[x]\^2\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.3.10"]
}, Open  ]],

Cell[TextData[{
  "This makes ",
  StyleBox["FullSimplify", "MR"],
  " avoid simplifying the square roots. "
}], "MathCaption",
  CellTags->{"S3.3.10", "10.9"}],

Cell[CellGroupData[{

Cell["FullSimplify[t, ExcludedForms->Sqrt[_]]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.3.10"],

Cell[BoxData[
    \(\@\(22619537 + 15994428\ \@2\)\ Cos[x]\^2\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.3.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FullSimplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["TimeConstraint->", "MR"],
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to simplify ",
              StyleBox["expr", "TI"],
              ", working for at most ",
              StyleBox["t", "TI"],
              " seconds on each transformation "
            }]]},
          {Cell[TextData[{
              StyleBox["FullSimplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["TransformationFunctions", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "use only the functions ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " in trying to transform parts of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FullSimplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["TransformationFunctions", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{Automatic,", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "use built\[Hyphen]in transformations as well as the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Simplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ComplexityFunction->", "MR"],
              StyleBox["c", "TI"],
              StyleBox["]", "MR"],
              " and ",
              StyleBox["FullSimplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ComplexityFunction->", "MR"],
              StyleBox["c", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "simplify using ",
              StyleBox["c", "TI"],
              " to determine what form is considered simplest "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.10"],

Cell["Further control of simplification. ", "Caption",
  CellTags->"S3.3.10"],

Cell[TextData[{
  "In both ",
  StyleBox["Simplify", "MR"],
  " and ",
  StyleBox["FullSimplify", "MR"],
  " there is always an issue of what counts as the \
\[OpenCurlyDoubleQuote]simplest\[CloseCurlyDoubleQuote] form of an \
expression. You can use the option ",
  StyleBox["ComplexityFunction", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["c", "TI"],
  " to provide a function to determine this. The function will be applied to \
each candidate form of the expression, and the one that gives the smallest \
numerical value will be considered simplest.      "
}], "Text",
  CellTags->{"S3.3.10", "10.10"}],

Cell[TextData[{
  "With its default definition of simplicity, ",
  StyleBox["Simplify", "MR"],
  " leaves this unchanged. "
}], "MathCaption",
  CellTags->{"S3.3.10", "10.11"}],

Cell[CellGroupData[{

Cell["Simplify[4 Log[10]]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.3.10"],

Cell[BoxData[
    \(4\ Log[10]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.3.10"]
}, Open  ]],

Cell["\<\
This now tries to minimize the number of elements in the \
expression. \
\>", "MathCaption",
  CellTags->{"S3.3.10", "10.12"}],

Cell[CellGroupData[{

Cell["Simplify[4 Log[10], ComplexityFunction -> LeafCount]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.3.10"],

Cell[BoxData[
    \(Log[10000]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.3.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3.11 Using Assumptions", "Subsection",
  CellTags->{"S3.3.11", "11.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " normally makes as few assumptions as possible about the objects you ask \
it to manipulate. This means that the results it gives are as general as \
possible. But sometimes these results are considerably more complicated than \
they would be if more assumptions were made. "
}], "Text",
  CellTags->{"S3.3.11", "11.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Refine[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["assum", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "refine ",
              StyleBox["expr", "TI"],
              " using assumptions "
            }]]},
          {Cell[TextData[{
              StyleBox["Simplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["assum", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["simplify with assumptions "]},
          {Cell[TextData[{
              StyleBox["FullSimplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["assum", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["full simplify with assumptions "]},
          {Cell[TextData[{
              StyleBox["FunctionExpand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["assum", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["function expand with assumptions "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.11"],

Cell["Doing operations with assumptions. ", "Caption",
  CellTags->"S3.3.11"],

Cell[TextData[{
  StyleBox["Simplify", "MR"],
  " by default does essentially nothing with this expression. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.3"}],

Cell[CellGroupData[{

Cell["Simplify[1/Sqrt[x] - Sqrt[1/x]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(\(-\@\(1\/x\)\) + 1\/\@x\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "The reason is that its value is quite different for different choices of \
",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.4"}],

Cell[CellGroupData[{

Cell["% /. x -> {-3, -2, -1, 1, 2, 3}", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \({\(-\(\(2\ \[ImaginaryI]\)\/\@3\)\), \(-\[ImaginaryI]\)\ \@2, \(-2\)\ \
\[ImaginaryI], 0, 0, 0}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "With the assumption ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], ">", "0"}], TraditionalForm]], "InlineFormula"],
  ", ",
  StyleBox["Simplify", "MR"],
  " can immediately reduce the expression to 0. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.5"}],

Cell[CellGroupData[{

Cell["Simplify[1/Sqrt[x] - Sqrt[1/x], x > 0]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "Without making assumptions about ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", nothing can be done. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.6"}],

Cell[CellGroupData[{

Cell["FunctionExpand[Log[x y]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(Log[x\ y]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " are both assumed positive, the log can be expanded. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.7"}],

Cell[CellGroupData[{

Cell["FunctionExpand[Log[x y], x > 0 && y > 0]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(Log[x] + Log[y]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "By applying ",
  StyleBox["Simplify", "MR"],
  " and ",
  StyleBox["FullSimplify", "MR"],
  " with appropriate assumptions to equations and inequalities you can in \
effect establish a vast range of theorems.  "
}], "Text",
  CellTags->{"S3.3.11", "11.8"}],

Cell[TextData[{
  "Without making assumptions about ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " the truth or falsity of this equation cannot be determined. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.9"}],

Cell[CellGroupData[{

Cell["Simplify[Abs[x] == x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(x \[Equal] Abs[x]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["Simplify", "MR"],
  " can prove that the equation is true. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.10"}],

Cell[CellGroupData[{

Cell["Simplify[Abs[x] == x, x > 0]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell["\<\
This establishes the standard result that the arithmetic mean is \
larger than the geometric one. \
\>", "MathCaption",
  CellTags->{"S3.3.11", "11.11"}],

Cell[CellGroupData[{

Cell["Simplify[(x + y)/2 >= Sqrt[x y], x >= 0 && y >= 0]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "This proves that ",
  Cell[BoxData[
      FormBox[
        RowBox[{"erf", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " lies in the range ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, 1)\)\)], "InlineFormula"],
  " for all positive arguments. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.12"}],

Cell[CellGroupData[{

Cell["FullSimplify[0 < Erf[x] < 1, x > 0]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Simplify", "MR"],
  " and ",
  StyleBox["FullSimplify", "MR"],
  " always try to find the simplest forms of expressions. Sometimes, however, \
you may just want ",
  StyleBox["Mathematica", "TI"],
  " to follow its ordinary evaluation process, but with certain assumptions \
made. You can do this using ",
  StyleBox["Refine", "MR"],
  ". The way it works is that ",
  StyleBox["Refine[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["assum", "TI"],
  StyleBox["]", "MR"],
  " performs the same transformations as ",
  StyleBox["Mathematica", "TI"],
  " would perform automatically if the variables in ",
  StyleBox["expr", "TI"],
  " were replaced by numerical expressions satisfying the assumptions ",
  StyleBox["assum", "TI"],
  ".  "
}], "Text",
  CellTags->{"S3.3.11", "11.13"}],

Cell[TextData[{
  "There is no simpler form that ",
  StyleBox["Simplify", "MR"],
  " can find. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.14"}],

Cell[CellGroupData[{

Cell["Simplify[Log[x], x < 0]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(Log[x]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Refine", "MR"],
  " just evaluates ",
  StyleBox["Log[x]", "MR"],
  " as it would for any explicit negative number\[NonBreakingSpace]",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.15"}],

Cell[CellGroupData[{

Cell["Refine[Log[x], x < 0]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(\[ImaginaryI]\ \[Pi] + Log[\(-x\)]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "An important class of assumptions are those which assert that some object \
is an element of a particular domain. You can set up such assumptions using \
",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " ",
  StyleBox["dom", "TI"],
  ", where the ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " character can be entered as \[AliasIndicator]",
  StyleBox["el\[AliasIndicator]", "MR"],
  " or \[Backslash]",
  StyleBox["[Element]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.3.11", "11.16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Element] \)], "InlineFormula"],
              " ",
              StyleBox["dom", "TI"],
              "  or  ",
              StyleBox["Element[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dom", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "assert that ",
              StyleBox["x", "TI"],
              " is an element of the domain ",
              StyleBox["dom", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Element] \)], "InlineFormula"],
              " ",
              StyleBox["dom", "TI"],
              " "
            }]], Cell[TextData[{
              "assert that all the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " are elements of the domain ",
              StyleBox["dom", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["patt", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Element] \)], "InlineFormula"],
              " ",
              StyleBox["dom", "TI"],
              " "
            }]], Cell[TextData[{
              "assert that any expression which matches ",
              StyleBox["patt", "TI"],
              " is an element of the domain ",
              StyleBox["dom", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.11"],

Cell["Asserting that objects are elements of domains. ", "Caption",
  CellTags->"S3.3.11"],

Cell[TextData[{
  "This confirms that ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " is an element of the domain of real numbers. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.17"}],

Cell[CellGroupData[{

Cell["Pi \[Element] Reals", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell["\<\
These numbers are all elements of the domain of algebraic numbers. \
\
\>", "MathCaption",
  CellTags->{"S3.3.11", "11.18"}],

Cell[CellGroupData[{

Cell["\<\
{1, Sqrt[2], 3 + Sqrt[5]} \[Element] Algebraics\
\>", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " knows that ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " is not an algebraic number. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.19"}],

Cell[CellGroupData[{

Cell["Pi \[Element] Algebraics", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "Current mathematics has not established whether ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["e",
            "TI"], "+", "\[Pi]"}], TraditionalForm]], "InlineFormula"],
  " is an algebraic number or not. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.20"}],

Cell[CellGroupData[{

Cell["E + Pi \[Element] Algebraics", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(\[ExponentialE] + \[Pi] \[Element] Algebraics\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "This represents the assertion that the symbol ",
  StyleBox["x", "MR"],
  " is an element of the domain of real numbers. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.21"}],

Cell[CellGroupData[{

Cell["x \[Element] Reals", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(x \[Element] Reals\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Complexes", "MR"],
              " "
            }]], Cell[TextData[{
              "the domain of complex numbers ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalC]\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Reals", "MR"],
              " "
            }]], Cell[TextData[{
              "the domain of real numbers ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalR]\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Algebraics", "MR"],
              " "
            }]], Cell[TextData[{
              "the domain of algebraic numbers ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalA]\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Rationals", "MR"],
              " "
            }]], Cell[TextData[{
              "the domain of rational numbers ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalQ]\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Integers", "MR"],
              " "
            }]], Cell[TextData[{
              "the domain of integers ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalZ]\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Primes", "MR"],
              " "
            }]], Cell[TextData[{
              "the domain of primes ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalP]\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Booleans", "MR"],
              " "
            }]], Cell[TextData[{
              "the domain of booleans (",
              StyleBox["True", "MR"],
              " and ",
              StyleBox["False", "MR"],
              ") ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalB]\)], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.11"],

Cell[TextData[{
  "Domains supported by ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S3.3.11"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is assumed to be an integer, ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], "\[Pi]"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  " is zero. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.22"}],

Cell[CellGroupData[{

Cell["\<\
Simplify[Sin[n Pi], n \[Element] Integers]\
\>", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "This establishes the theorem ",
  Cell[BoxData[
      FormBox[
        RowBox[{"cosh", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "\[GreaterEqual]", "1"}], TraditionalForm]], 
    "InlineFormula"],
  " if ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is assumed to be a real number. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.23"}],

Cell[CellGroupData[{

Cell["\<\
Simplify[Cosh[x] >= 1, x \[Element] Reals]\
\>", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "If you say that a variable satisfies an inequality, ",
  StyleBox["Mathematica", "TI"],
  " will automatically assume that it is real. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.24"}],

Cell[CellGroupData[{

Cell["Simplify[x \[Element] Reals, x > 0]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "By using ",
  StyleBox["Simplify", "MR"],
  ", ",
  StyleBox["FullSimplify", "MR"],
  " and ",
  StyleBox["FunctionExpand", "MR"],
  " with assumptions you can access many of ",
  StyleBox["Mathematica", "TI"],
  "'s vast collection of mathematical facts. "
}], "Text",
  CellTags->{"S3.3.11", "11.25"}],

Cell["This uses the periodicity of the tangent function. ", "MathCaption",
  CellTags->{"S3.3.11", "11.26"}],

Cell[CellGroupData[{

Cell["\<\
Simplify[Tan[x + Pi k], k \[Element] Integers]\
\>", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(Tan[x]\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "The assumption ",
  StyleBox["k/2", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " ",
  StyleBox["Integers", "MR"],
  " implies that ",
  StyleBox["k", "MR"],
  " must be even. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.27"}],

Cell[CellGroupData[{

Cell["\<\
Simplify[Tan[x + Pi k/2], k/2 \[Element] Integers]\
\>", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(Tan[x]\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " knows that ",
  Cell[BoxData[
      FormBox[
        RowBox[{"log", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "<", "exp", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " for positive ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.28"}],

Cell[CellGroupData[{

Cell["Simplify[Log[x] < Exp[x], x > 0]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FullSimplify", "MR"],
  " accesses knowledge about special functions. "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.29"}],

Cell[CellGroupData[{

Cell["\<\
FullSimplify[Im[BesselJ[0, x]], x \[Element] Reals]\
\>", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " knows about discrete mathematics and number theory as well as continuous \
mathematics. "
}], "Text",
  CellTags->{"S3.3.11", "11.30"}],

Cell["This uses Wilson's Theorem to simplify the result. ", "MathCaption",
  CellTags->{"S3.3.11", "11.31"}],

Cell[CellGroupData[{

Cell["\<\
FunctionExpand[Mod[(p - 1)!, p], p \[Element] Primes]\
\>", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(\(-1\) + p\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell["\<\
This uses the multiplicative property of the Euler phi function. \
\
\>", "MathCaption",
  CellTags->{"S3.3.11", "11.32"}],

Cell[CellGroupData[{

Cell["\<\
FunctionExpand[EulerPhi[m n], {m, n} \[Element] Integers && GCD[m, \
n] == 1]\
\>", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(EulerPhi[m]\ EulerPhi[n]\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "In something like ",
  StyleBox["Simplify[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["assum", "TI"],
  StyleBox["]", "MR"],
  " or ",
  StyleBox["Refine[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["assum", "TI"],
  StyleBox["]", "MR"],
  " you explicitly give the assumptions you want to use. But sometimes you \
may want to specify one set of assumptions to use in a whole collection of \
operations. You can do this by using ",
  StyleBox["Assuming", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.3.11", "11.33"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Assuming[", "MR"],
              StyleBox["assum", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "use assumptions ",
              StyleBox["assum", "TI"],
              " in the evaluation of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["$Assumptions", "MR"],
              " "
            }]], Cell["the default assumptions to use "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.3.11"],

Cell["Specifying assumptions with larger scopes. ", "Caption",
  CellTags->"S3.3.11"],

Cell[TextData[{
  "This tells ",
  StyleBox["Simplify", "MR"],
  " to use the default assumption ",
  StyleBox["x", "MR"],
  " ",
  StyleBox[">", "MR"],
  " ",
  StyleBox["0", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.34"}],

Cell[CellGroupData[{

Cell["Assuming[x > 0, Simplify[Sqrt[x^2]]]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell["This combines the two assumptions given. ", "MathCaption",
  CellTags->{"S3.3.11", "11.35"}],

Cell[CellGroupData[{

Cell["\<\
Assuming[x > 0, Assuming[x \[Element] Integers, \
Refine[Floor[Sqrt[x^2]]]]]\
\>", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S3.3.11"]
}, Open  ]],

Cell[TextData[{
  "Functions like ",
  StyleBox["Simplify", "MR"],
  " and ",
  StyleBox["Refine", "MR"],
  " take the option ",
  StyleBox["Assumptions", "MR"],
  ", which specifies what default assumptions they should use. By default, \
the setting for this option is ",
  StyleBox["Assumptions", "MR"],
  " ",
  StyleBox[":>", "MR"],
  " ",
  StyleBox["$Assumptions", "MR"],
  ". The way ",
  StyleBox["Assuming", "MR"],
  " then works is to assign a local value to ",
  StyleBox["$Assumptions", "MR"],
  ", much as in ",
  StyleBox["Block", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.3.11", "11.36"}],

Cell[TextData[{
  "In addition to ",
  StyleBox["Simplify", "MR"],
  " and ",
  StyleBox["Refine", "MR"],
  ", a number of other functions take ",
  StyleBox["Assumptions", "MR"],
  " options, and thus can have assumptions specified for them by ",
  StyleBox["Assuming", "MR"],
  ". Examples are ",
  StyleBox["FunctionExpand", "MR"],
  ", ",
  StyleBox["Integrate", "MR"],
  ", ",
  StyleBox["Limit", "MR"],
  ", ",
  StyleBox["LaplaceTransform", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.3.11", "11.37"}],

Cell[TextData[{
  "The assumption is automatically used in ",
  StyleBox["Integrate", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.3.11", "11.38"}],

Cell[CellGroupData[{

Cell["Assuming[n > 0, 1 + Integrate[x^n, {x, 0, 1}]^2]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S3.3.11"],

Cell[BoxData[
    \(1 + 1\/\((1 + n)\)\^2\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S3.3.11"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S3.3.0"->{
    Cell[1776, 53, 125, 4, 65, "Section",
      CellTags->{"S3.3.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 125, 4, 65, "Section",
      CellTags->{"S3.3.0", "0.1"}]},
  "S3.3.1"->{
    Cell[1926, 61, 95, 1, 70, "Subsection",
      CellTags->{"S3.3.1", "1.1"}],
    Cell[2024, 64, 2794, 87, 70, "DefinitionBox",
      CellTags->"S3.3.1"],
    Cell[4821, 153, 79, 1, 70, "Caption",
      CellTags->"S3.3.1"],
    Cell[4903, 156, 92, 1, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.2"}],
    Cell[5020, 161, 87, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[5110, 165, 122, 3, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[5247, 171, 183, 5, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.3"}],
    Cell[5455, 180, 79, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[5537, 184, 168, 4, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[5720, 191, 146, 4, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.4"}],
    Cell[5891, 199, 75, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[5969, 203, 125, 3, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[6109, 209, 179, 6, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.5"}],
    Cell[6313, 219, 80, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[6396, 223, 178, 4, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[6589, 230, 603, 17, 70, "Text",
      CellTags->{"S3.3.1", "1.6"}],
    Cell[7195, 249, 623, 16, 70, "Text",
      CellTags->{"S3.3.1", "1.7"}],
    Cell[7821, 267, 93, 1, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.8"}],
    Cell[7939, 272, 88, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[8030, 276, 179, 4, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[8224, 283, 240, 7, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.9"}],
    Cell[8489, 294, 79, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[8571, 298, 179, 4, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[8765, 305, 219, 6, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.10"}],
    Cell[9009, 315, 112, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[9124, 319, 314, 7, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[9453, 329, 705, 21, 70, "DefinitionBox",
      CellTags->"S3.3.1"],
    Cell[10161, 352, 75, 1, 70, "Caption",
      CellTags->"S3.3.1"],
    Cell[10239, 355, 151, 5, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.11"}],
    Cell[10415, 364, 94, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[10512, 368, 148, 4, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[10675, 375, 171, 5, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.12"}],
    Cell[10871, 384, 110, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[10984, 388, 195, 5, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[11194, 396, 1297, 37, 70, "DefinitionBox",
      CellTags->"S3.3.1"],
    Cell[12494, 435, 59, 1, 70, "Caption",
      CellTags->"S3.3.1"],
    Cell[12556, 438, 685, 23, 70, "Text",
      CellTags->{"S3.3.1", "1.13"}],
    Cell[13244, 463, 156, 4, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.14"}],
    Cell[13425, 471, 72, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[13500, 475, 95, 3, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[13610, 481, 235, 8, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.15"}],
    Cell[13870, 493, 79, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[13952, 497, 92, 3, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[14059, 503, 132, 4, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.16"}],
    Cell[14216, 511, 71, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[14290, 515, 97, 3, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[14402, 521, 125, 4, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.17"}],
    Cell[14552, 529, 79, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[14634, 533, 103, 3, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[14752, 539, 1145, 35, 70, "DefinitionBox",
      CellTags->"S3.3.1"],
    Cell[15900, 576, 67, 1, 70, "Caption",
      CellTags->"S3.3.1"],
    Cell[15970, 579, 152, 5, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.18"}],
    Cell[16147, 588, 112, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[16262, 592, 132, 3, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[16409, 598, 136, 5, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.19"}],
    Cell[16570, 607, 81, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[16654, 611, 129, 3, 70, "Output",
      CellTags->"S3.3.1"],
    Cell[16798, 617, 149, 5, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.20"}],
    Cell[16972, 626, 89, 2, 70, "Input",
      CellTags->"S3.3.1"],
    Cell[17064, 630, 129, 3, 70, "Output",
      CellTags->"S3.3.1"]},
  "1.1"->{
    Cell[1926, 61, 95, 1, 70, "Subsection",
      CellTags->{"S3.3.1", "1.1"}]},
  "1.2"->{
    Cell[4903, 156, 92, 1, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.2"}]},
  "1.3"->{
    Cell[5247, 171, 183, 5, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.3"}]},
  "1.4"->{
    Cell[5720, 191, 146, 4, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.4"}]},
  "1.5"->{
    Cell[6109, 209, 179, 6, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.5"}]},
  "1.6"->{
    Cell[6589, 230, 603, 17, 70, "Text",
      CellTags->{"S3.3.1", "1.6"}]},
  "1.7"->{
    Cell[7195, 249, 623, 16, 70, "Text",
      CellTags->{"S3.3.1", "1.7"}]},
  "1.8"->{
    Cell[7821, 267, 93, 1, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.8"}]},
  "1.9"->{
    Cell[8224, 283, 240, 7, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.9"}]},
  "1.10"->{
    Cell[8765, 305, 219, 6, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.10"}]},
  "1.11"->{
    Cell[10239, 355, 151, 5, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.11"}]},
  "1.12"->{
    Cell[10675, 375, 171, 5, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.12"}]},
  "1.13"->{
    Cell[12556, 438, 685, 23, 70, "Text",
      CellTags->{"S3.3.1", "1.13"}]},
  "1.14"->{
    Cell[13244, 463, 156, 4, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.14"}]},
  "1.15"->{
    Cell[13610, 481, 235, 8, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.15"}]},
  "1.16"->{
    Cell[14059, 503, 132, 4, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.16"}]},
  "1.17"->{
    Cell[14402, 521, 125, 4, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.17"}]},
  "1.18"->{
    Cell[15970, 579, 152, 5, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.18"}]},
  "1.19"->{
    Cell[16409, 598, 136, 5, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.19"}]},
  "1.20"->{
    Cell[16798, 617, 149, 5, 70, "MathCaption",
      CellTags->{"S3.3.1", "1.20"}]},
  "S3.3.2"->{
    Cell[17242, 639, 96, 1, 70, "Subsection",
      CellTags->{"S3.3.2", "2.1"}],
    Cell[17341, 642, 5569, 172, 70, "DefinitionBox",
      CellTags->"S3.3.2"],
    Cell[22913, 816, 114, 4, 70, "Caption",
      CellTags->"S3.3.2"],
    Cell[23030, 822, 93, 1, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.2"}],
    Cell[23148, 827, 91, 2, 70, "Input",
      CellTags->"S3.3.2"],
    Cell[23242, 831, 115, 3, 70, "Output",
      CellTags->"S3.3.2"],
    Cell[23372, 837, 95, 1, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.3"}],
    Cell[23492, 842, 73, 2, 70, "Input",
      CellTags->"S3.3.2"],
    Cell[23568, 846, 221, 5, 70, "Output",
      CellTags->"S3.3.2"],
    Cell[23804, 854, 197, 8, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.4"}],
    Cell[24026, 866, 81, 2, 70, "Input",
      CellTags->"S3.3.2"],
    Cell[24110, 870, 85, 3, 70, "Output",
      CellTags->"S3.3.2"],
    Cell[24210, 876, 150, 5, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.5"}],
    Cell[24385, 885, 90, 2, 70, "Input",
      CellTags->"S3.3.2"],
    Cell[24478, 889, 86, 3, 70, "Output",
      CellTags->"S3.3.2"],
    Cell[24579, 895, 181, 6, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.6"}],
    Cell[24785, 905, 76, 2, 70, "Input",
      CellTags->"S3.3.2"],
    Cell[24864, 909, 87, 3, 70, "Output",
      CellTags->"S3.3.2"],
    Cell[24966, 915, 307, 9, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.7"}],
    Cell[25298, 928, 78, 2, 70, "Input",
      CellTags->"S3.3.2"],
    Cell[25379, 932, 82, 3, 70, "Output",
      CellTags->"S3.3.2"],
    Cell[25476, 938, 375, 13, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.8"}],
    Cell[25876, 955, 83, 2, 70, "Input",
      CellTags->"S3.3.2"],
    Cell[25962, 959, 97, 3, 70, "Output",
      CellTags->"S3.3.2"],
    Cell[26074, 965, 169, 7, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.9"}],
    Cell[26268, 976, 84, 2, 70, "Input",
      CellTags->"S3.3.2"],
    Cell[26355, 980, 97, 3, 70, "Output",
      CellTags->"S3.3.2"],
    Cell[26467, 986, 305, 11, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.10"}],
    Cell[26797, 1001, 84, 2, 70, "Input",
      CellTags->"S3.3.2"],
    Cell[26884, 1005, 96, 3, 70, "Output",
      CellTags->"S3.3.2"],
    Cell[26995, 1011, 437, 15, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.11"}],
    Cell[27457, 1030, 100, 2, 70, "Input",
      CellTags->"S3.3.2"],
    Cell[27560, 1034, 97, 3, 70, "Output",
      CellTags->"S3.3.2"],
    Cell[27672, 1040, 213, 5, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.12"}],
    Cell[27910, 1049, 91, 2, 70, "Input",
      CellTags->"S3.3.2"],
    Cell[28004, 1053, 177, 4, 70, "Output",
      CellTags->"S3.3.2"],
    Cell[28196, 1060, 199, 5, 70, "Text",
      CellTags->{"S3.3.2", "2.13"}],
    Cell[28398, 1067, 140, 4, 70, "Text",
      CellTags->{"S3.3.2", "2.14"}],
    Cell[28541, 1073, 269, 9, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.15"}],
    Cell[28835, 1086, 80, 2, 70, "Input",
      CellTags->"S3.3.2"],
    Cell[28918, 1090, 100, 3, 70, "Output",
      CellTags->"S3.3.2"],
    Cell[29033, 1096, 337, 12, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.16"}],
    Cell[29395, 1112, 79, 2, 70, "Input",
      CellTags->"S3.3.2"],
    Cell[29477, 1116, 94, 3, 70, "Output",
      CellTags->"S3.3.2"]},
  "2.1"->{
    Cell[17242, 639, 96, 1, 70, "Subsection",
      CellTags->{"S3.3.2", "2.1"}]},
  "2.2"->{
    Cell[23030, 822, 93, 1, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.2"}]},
  "2.3"->{
    Cell[23372, 837, 95, 1, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.3"}]},
  "2.4"->{
    Cell[23804, 854, 197, 8, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.4"}]},
  "2.5"->{
    Cell[24210, 876, 150, 5, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.5"}]},
  "2.6"->{
    Cell[24579, 895, 181, 6, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.6"}]},
  "2.7"->{
    Cell[24966, 915, 307, 9, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.7"}]},
  "2.8"->{
    Cell[25476, 938, 375, 13, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.8"}]},
  "2.9"->{
    Cell[26074, 965, 169, 7, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.9"}]},
  "2.10"->{
    Cell[26467, 986, 305, 11, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.10"}]},
  "2.11"->{
    Cell[26995, 1011, 437, 15, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.11"}]},
  "2.12"->{
    Cell[27672, 1040, 213, 5, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.12"}]},
  "2.13"->{
    Cell[28196, 1060, 199, 5, 70, "Text",
      CellTags->{"S3.3.2", "2.13"}]},
  "2.14"->{
    Cell[28398, 1067, 140, 4, 70, "Text",
      CellTags->{"S3.3.2", "2.14"}]},
  "2.15"->{
    Cell[28541, 1073, 269, 9, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.15"}]},
  "2.16"->{
    Cell[29033, 1096, 337, 12, 70, "MathCaption",
      CellTags->{"S3.3.2", "2.16"}]},
  "S3.3.3"->{
    Cell[29620, 1125, 104, 1, 70, "Subsection",
      CellTags->{"S3.3.3", "3.1"}],
    Cell[29727, 1128, 273, 8, 70, "Text",
      CellTags->{"S3.3.3", "3.2"}],
    Cell[30003, 1138, 1141, 31, 70, "DefinitionBox",
      CellTags->"S3.3.3"],
    Cell[31147, 1171, 96, 1, 70, "Caption",
      CellTags->"S3.3.3"],
    Cell[31246, 1174, 85, 1, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.3"}],
    Cell[31356, 1179, 119, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[31478, 1183, 155, 4, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[31648, 1190, 160, 4, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.4"}],
    Cell[31833, 1198, 82, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[31918, 1202, 168, 5, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[32101, 1210, 196, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.5"}],
    Cell[32322, 1219, 73, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[32398, 1223, 188, 4, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[32601, 1230, 152, 4, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.6"}],
    Cell[32778, 1238, 84, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[32865, 1242, 160, 4, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[33040, 1249, 180, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.7"}],
    Cell[33245, 1258, 76, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[33324, 1262, 193, 4, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[33532, 1269, 625, 18, 70, "DefinitionBox",
      CellTags->"S3.3.3"],
    Cell[34160, 1289, 64, 1, 70, "Caption",
      CellTags->"S3.3.3"],
    Cell[34227, 1292, 155, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.8"}],
    Cell[34407, 1301, 107, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[34517, 1305, 122, 3, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[34654, 1311, 1183, 35, 70, "DefinitionBox",
      CellTags->"S3.3.3"],
    Cell[35840, 1348, 88, 1, 70, "Caption",
      CellTags->"S3.3.3"],
    Cell[35931, 1351, 85, 1, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.9"}],
    Cell[36041, 1356, 119, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[36163, 1360, 168, 4, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[36346, 1367, 144, 4, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.10"}],
    Cell[36515, 1375, 75, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[36593, 1379, 144, 4, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[36752, 1386, 187, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.11"}],
    Cell[36964, 1395, 73, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[37040, 1399, 154, 4, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[37209, 1406, 201, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.12"}],
    Cell[37435, 1415, 73, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[37511, 1419, 118, 3, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[37644, 1425, 164, 4, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.13"}],
    Cell[37833, 1433, 74, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[37910, 1437, 135, 3, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[38060, 1443, 175, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.14"}],
    Cell[38260, 1452, 74, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[38337, 1456, 155, 4, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[38507, 1463, 227, 6, 70, "Text",
      CellTags->{"S3.3.3", "3.15"}],
    Cell[38737, 1471, 331, 11, 70, "Text",
      CellTags->{"S3.3.3", "3.16"}],
    Cell[39071, 1484, 103, 1, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.17"}],
    Cell[39199, 1489, 88, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[39290, 1493, 111, 3, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[39416, 1499, 164, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.18"}],
    Cell[39605, 1508, 76, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[39684, 1512, 121, 3, 70, "Output",
      CellTags->"S3.3.3"],
    Cell[39820, 1518, 161, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.19"}],
    Cell[40006, 1527, 76, 2, 70, "Input",
      CellTags->"S3.3.3"],
    Cell[40085, 1531, 137, 3, 70, "Output",
      CellTags->"S3.3.3"]},
  "3.1"->{
    Cell[29620, 1125, 104, 1, 70, "Subsection",
      CellTags->{"S3.3.3", "3.1"}]},
  "3.2"->{
    Cell[29727, 1128, 273, 8, 70, "Text",
      CellTags->{"S3.3.3", "3.2"}]},
  "3.3"->{
    Cell[31246, 1174, 85, 1, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.3"}]},
  "3.4"->{
    Cell[31648, 1190, 160, 4, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.4"}]},
  "3.5"->{
    Cell[32101, 1210, 196, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.5"}]},
  "3.6"->{
    Cell[32601, 1230, 152, 4, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.6"}]},
  "3.7"->{
    Cell[33040, 1249, 180, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.7"}]},
  "3.8"->{
    Cell[34227, 1292, 155, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.8"}]},
  "3.9"->{
    Cell[35931, 1351, 85, 1, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.9"}]},
  "3.10"->{
    Cell[36346, 1367, 144, 4, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.10"}]},
  "3.11"->{
    Cell[36752, 1386, 187, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.11"}]},
  "3.12"->{
    Cell[37209, 1406, 201, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.12"}]},
  "3.13"->{
    Cell[37644, 1425, 164, 4, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.13"}]},
  "3.14"->{
    Cell[38060, 1443, 175, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.14"}]},
  "3.15"->{
    Cell[38507, 1463, 227, 6, 70, "Text",
      CellTags->{"S3.3.3", "3.15"}]},
  "3.16"->{
    Cell[38737, 1471, 331, 11, 70, "Text",
      CellTags->{"S3.3.3", "3.16"}]},
  "3.17"->{
    Cell[39071, 1484, 103, 1, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.17"}]},
  "3.18"->{
    Cell[39416, 1499, 164, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.18"}]},
  "3.19"->{
    Cell[39820, 1518, 161, 5, 70, "MathCaption",
      CellTags->{"S3.3.3", "3.19"}]},
  "S3.3.4"->{
    Cell[40271, 1540, 94, 1, 70, "Subsection",
      CellTags->{"S3.3.4", "4.1"}],
    Cell[40368, 1543, 234, 5, 70, "Text",
      CellTags->{"S3.3.4", "4.2"}],
    Cell[40605, 1550, 192, 5, 70, "Text",
      CellTags->{"S3.3.4", "4.3"}],
    Cell[40800, 1557, 247, 5, 70, "Text",
      CellTags->{"S3.3.4", "4.4"}],
    Cell[41050, 1564, 11642, 325, 70, "DefinitionBox",
      CellTags->"S3.3.4"],
    Cell[52695, 1891, 67, 1, 70, "Caption",
      CellTags->"S3.3.4"],
    Cell[52765, 1894, 2543, 96, 70, "Text",
      CellTags->{"S3.3.4", "4.5"}],
    Cell[55311, 1992, 408, 15, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.6"}],
    Cell[55744, 2011, 96, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[55843, 2015, 82, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[55940, 2021, 422, 15, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.7"}],
    Cell[56387, 2040, 95, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[56485, 2044, 91, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[56591, 2050, 95, 1, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.8"}],
    Cell[56711, 2055, 88, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[56802, 2059, 85, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[56902, 2065, 211, 8, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.9"}],
    Cell[57138, 2077, 142, 5, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[57283, 2084, 93, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[57391, 2090, 782, 27, 70, "Text",
      CellTags->{"S3.3.4", "4.10"}],
    Cell[58176, 2119, 165, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.11"}],
    Cell[58366, 2127, 119, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[58488, 2131, 110, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[58613, 2137, 1260, 45, 70, "Text",
      CellTags->{"S3.3.4", "4.12"}],
    Cell[59876, 2184, 453, 15, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.13"}],
    Cell[60354, 2203, 87, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[60444, 2207, 82, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[60541, 2213, 208, 7, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.14"}],
    Cell[60774, 2224, 141, 5, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[60918, 2231, 96, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[61029, 2237, 498, 11, 70, "Text",
      CellTags->{"S3.3.4", "4.15"}],
    Cell[61530, 2250, 518, 19, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.16"}],
    Cell[62073, 2273, 98, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[62174, 2277, 82, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[62271, 2283, 2311, 79, 70, "Text",
      CellTags->{"S3.3.4", "4.17"}],
    Cell[64585, 2364, 805, 28, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.18"}],
    Cell[65415, 2396, 94, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[65512, 2400, 100, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[65627, 2406, 1347, 47, 70, "Text",
      CellTags->{"S3.3.4", "4.19"}],
    Cell[66977, 2455, 427, 14, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.20"}],
    Cell[67429, 2473, 104, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[67536, 2477, 89, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[67640, 2483, 192, 6, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.21"}],
    Cell[67857, 2493, 106, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[67966, 2497, 85, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[68066, 2503, 166, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.22"}],
    Cell[68257, 2511, 118, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[68378, 2515, 149, 4, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[68542, 2522, 2327, 104, 70, "Text",
      CellTags->{"S3.3.4", "4.23"}],
    Cell[70872, 2628, 886, 34, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.24"}],
    Cell[71783, 2666, 116, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[71902, 2670, 118, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[72035, 2676, 1635, 49, 70, "DefinitionBox",
      CellTags->"S3.3.4"],
    Cell[73673, 2727, 78, 1, 70, "Caption",
      CellTags->"S3.3.4"],
    Cell[73754, 2730, 528, 15, 70, "Text",
      CellTags->{"S3.3.4", "4.25"}],
    Cell[74285, 2747, 95, 1, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.26"}],
    Cell[74405, 2752, 106, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[74514, 2756, 124, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[74653, 2762, 219, 8, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.27"}],
    Cell[74897, 2774, 82, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[74982, 2778, 128, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[75125, 2784, 296, 12, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.28"}],
    Cell[75446, 2800, 84, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[75533, 2804, 122, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[75670, 2810, 151, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.29"}],
    Cell[75846, 2818, 74, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[75923, 2822, 125, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[76063, 2828, 447, 9, 70, "Text",
      CellTags->{"S3.3.4", "4.30"}],
    Cell[76513, 2839, 235, 7, 70, "Text",
      CellTags->{"S3.3.4", "4.31"}],
    Cell[76751, 2848, 219, 5, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.32"}],
    Cell[76995, 2857, 78, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[77076, 2861, 126, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[77217, 2867, 666, 22, 70, "DefinitionBox",
      CellTags->"S3.3.4"],
    Cell[77886, 2891, 90, 1, 70, "Caption",
      CellTags->"S3.3.4"],
    Cell[77979, 2894, 567, 15, 70, "Text",
      CellTags->{"S3.3.4", "4.33"}],
    Cell[78549, 2911, 137, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.34"}],
    Cell[78711, 2919, 80, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[78794, 2923, 90, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[78899, 2929, 137, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.35"}],
    Cell[79061, 2937, 106, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[79170, 2941, 135, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[79320, 2947, 672, 21, 70, "DefinitionBox",
      CellTags->"S3.3.4"],
    Cell[79995, 2970, 65, 1, 70, "Caption",
      CellTags->"S3.3.4"],
    Cell[80063, 2973, 1515, 50, 70, "Text",
      CellTags->{"S3.3.4", "4.36"}],
    Cell[81581, 3025, 356, 13, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.37"}],
    Cell[81962, 3042, 81, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[82046, 3046, 94, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[82155, 3052, 525, 19, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.38"}],
    Cell[82705, 3075, 80, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[82788, 3079, 162, 4, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[82965, 3086, 673, 21, 70, "DefinitionBox",
      CellTags->"S3.3.4"],
    Cell[83641, 3109, 66, 1, 70, "Caption",
      CellTags->"S3.3.4"],
    Cell[83710, 3112, 2065, 72, 70, "Text",
      CellTags->{"S3.3.4", "4.39"}],
    Cell[85778, 3186, 1088, 38, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.40"}],
    Cell[86891, 3228, 92, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[86986, 3232, 102, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[87103, 3238, 90, 1, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.41"}],
    Cell[87196, 3241, 112, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[87311, 3245, 104, 1, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.42"}],
    Cell[87440, 3250, 88, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[87531, 3254, 164, 4, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[87710, 3261, 136, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.43"}],
    Cell[87871, 3269, 80, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[87954, 3273, 112, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[88081, 3279, 583, 18, 70, "Text",
      CellTags->{"S3.3.4", "4.44"}],
    Cell[88667, 3299, 2492, 89, 70, "Text",
      CellTags->{"S3.3.4", "4.45"}],
    Cell[91162, 3390, 3669, 107, 70, "DefinitionBox",
      CellTags->"S3.3.4"],
    Cell[94834, 3499, 79, 1, 70, "Caption",
      CellTags->"S3.3.4"],
    Cell[94916, 3502, 147, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.46"}],
    Cell[95088, 3510, 118, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[95209, 3514, 118, 3, 70, "Output",
      CellTags->"S3.3.4"],
    Cell[95342, 3520, 214, 9, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.47"}],
    Cell[95581, 3533, 76, 2, 70, "Input",
      CellTags->"S3.3.4"],
    Cell[95660, 3537, 83, 3, 70, "Output",
      CellTags->"S3.3.4"]},
  "4.1"->{
    Cell[40271, 1540, 94, 1, 70, "Subsection",
      CellTags->{"S3.3.4", "4.1"}]},
  "4.2"->{
    Cell[40368, 1543, 234, 5, 70, "Text",
      CellTags->{"S3.3.4", "4.2"}]},
  "4.3"->{
    Cell[40605, 1550, 192, 5, 70, "Text",
      CellTags->{"S3.3.4", "4.3"}]},
  "4.4"->{
    Cell[40800, 1557, 247, 5, 70, "Text",
      CellTags->{"S3.3.4", "4.4"}]},
  "4.5"->{
    Cell[52765, 1894, 2543, 96, 70, "Text",
      CellTags->{"S3.3.4", "4.5"}]},
  "4.6"->{
    Cell[55311, 1992, 408, 15, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.6"}]},
  "4.7"->{
    Cell[55940, 2021, 422, 15, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.7"}]},
  "4.8"->{
    Cell[56591, 2050, 95, 1, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.8"}]},
  "4.9"->{
    Cell[56902, 2065, 211, 8, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.9"}]},
  "4.10"->{
    Cell[57391, 2090, 782, 27, 70, "Text",
      CellTags->{"S3.3.4", "4.10"}]},
  "4.11"->{
    Cell[58176, 2119, 165, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.11"}]},
  "4.12"->{
    Cell[58613, 2137, 1260, 45, 70, "Text",
      CellTags->{"S3.3.4", "4.12"}]},
  "4.13"->{
    Cell[59876, 2184, 453, 15, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.13"}]},
  "4.14"->{
    Cell[60541, 2213, 208, 7, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.14"}]},
  "4.15"->{
    Cell[61029, 2237, 498, 11, 70, "Text",
      CellTags->{"S3.3.4", "4.15"}]},
  "4.16"->{
    Cell[61530, 2250, 518, 19, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.16"}]},
  "4.17"->{
    Cell[62271, 2283, 2311, 79, 70, "Text",
      CellTags->{"S3.3.4", "4.17"}]},
  "4.18"->{
    Cell[64585, 2364, 805, 28, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.18"}]},
  "4.19"->{
    Cell[65627, 2406, 1347, 47, 70, "Text",
      CellTags->{"S3.3.4", "4.19"}]},
  "4.20"->{
    Cell[66977, 2455, 427, 14, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.20"}]},
  "4.21"->{
    Cell[67640, 2483, 192, 6, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.21"}]},
  "4.22"->{
    Cell[68066, 2503, 166, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.22"}]},
  "4.23"->{
    Cell[68542, 2522, 2327, 104, 70, "Text",
      CellTags->{"S3.3.4", "4.23"}]},
  "4.24"->{
    Cell[70872, 2628, 886, 34, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.24"}]},
  "4.25"->{
    Cell[73754, 2730, 528, 15, 70, "Text",
      CellTags->{"S3.3.4", "4.25"}]},
  "4.26"->{
    Cell[74285, 2747, 95, 1, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.26"}]},
  "4.27"->{
    Cell[74653, 2762, 219, 8, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.27"}]},
  "4.28"->{
    Cell[75125, 2784, 296, 12, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.28"}]},
  "4.29"->{
    Cell[75670, 2810, 151, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.29"}]},
  "4.30"->{
    Cell[76063, 2828, 447, 9, 70, "Text",
      CellTags->{"S3.3.4", "4.30"}]},
  "4.31"->{
    Cell[76513, 2839, 235, 7, 70, "Text",
      CellTags->{"S3.3.4", "4.31"}]},
  "4.32"->{
    Cell[76751, 2848, 219, 5, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.32"}]},
  "4.33"->{
    Cell[77979, 2894, 567, 15, 70, "Text",
      CellTags->{"S3.3.4", "4.33"}]},
  "4.34"->{
    Cell[78549, 2911, 137, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.34"}]},
  "4.35"->{
    Cell[78899, 2929, 137, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.35"}]},
  "4.36"->{
    Cell[80063, 2973, 1515, 50, 70, "Text",
      CellTags->{"S3.3.4", "4.36"}]},
  "4.37"->{
    Cell[81581, 3025, 356, 13, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.37"}]},
  "4.38"->{
    Cell[82155, 3052, 525, 19, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.38"}]},
  "4.39"->{
    Cell[83710, 3112, 2065, 72, 70, "Text",
      CellTags->{"S3.3.4", "4.39"}]},
  "4.40"->{
    Cell[85778, 3186, 1088, 38, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.40"}]},
  "4.41"->{
    Cell[87103, 3238, 90, 1, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.41"}]},
  "4.42"->{
    Cell[87311, 3245, 104, 1, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.42"}]},
  "4.43"->{
    Cell[87710, 3261, 136, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.43"}]},
  "4.44"->{
    Cell[88081, 3279, 583, 18, 70, "Text",
      CellTags->{"S3.3.4", "4.44"}]},
  "4.45"->{
    Cell[88667, 3299, 2492, 89, 70, "Text",
      CellTags->{"S3.3.4", "4.45"}]},
  "4.46"->{
    Cell[94916, 3502, 147, 4, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.46"}]},
  "4.47"->{
    Cell[95342, 3520, 214, 9, 70, "MathCaption",
      CellTags->{"S3.3.4", "4.47"}]},
  "S3.3.5"->{
    Cell[95792, 3546, 84, 1, 70, "Subsection",
      CellTags->{"S3.3.5", "5.1"}],
    Cell[95879, 3549, 497, 17, 70, "Text",
      CellTags->{"S3.3.5", "5.2"}],
    Cell[96379, 3568, 3590, 113, 70, "DefinitionBox",
      CellTags->"S3.3.5"],
    Cell[99972, 3683, 100, 1, 70, "Caption",
      CellTags->"S3.3.5"],
    Cell[100075, 3686, 86, 1, 70, "MathCaption",
      CellTags->{"S3.3.5", "5.3"}],
    Cell[100186, 3691, 83, 2, 70, "Input",
      CellTags->"S3.3.5"],
    Cell[100272, 3695, 141, 4, 70, "Output",
      CellTags->"S3.3.5"],
    Cell[100428, 3702, 94, 1, 70, "MathCaption",
      CellTags->{"S3.3.5", "5.4"}],
    Cell[100547, 3707, 83, 2, 70, "Input",
      CellTags->"S3.3.5"],
    Cell[100633, 3711, 103, 3, 70, "Output",
      CellTags->"S3.3.5"],
    Cell[100751, 3717, 132, 4, 70, "MathCaption",
      CellTags->{"S3.3.5", "5.5"}],
    Cell[100908, 3725, 73, 2, 70, "Input",
      CellTags->"S3.3.5"],
    Cell[100984, 3729, 111, 3, 70, "Output",
      CellTags->"S3.3.5"],
    Cell[101110, 3735, 114, 2, 70, "MathCaption",
      CellTags->{"S3.3.5", "5.6"}],
    Cell[101249, 3741, 85, 2, 70, "Input",
      CellTags->"S3.3.5"],
    Cell[101337, 3745, 95, 3, 70, "Output",
      CellTags->"S3.3.5"]},
  "5.1"->{
    Cell[95792, 3546, 84, 1, 70, "Subsection",
      CellTags->{"S3.3.5", "5.1"}]},
  "5.2"->{
    Cell[95879, 3549, 497, 17, 70, "Text",
      CellTags->{"S3.3.5", "5.2"}]},
  "5.3"->{
    Cell[100075, 3686, 86, 1, 70, "MathCaption",
      CellTags->{"S3.3.5", "5.3"}]},
  "5.4"->{
    Cell[100428, 3702, 94, 1, 70, "MathCaption",
      CellTags->{"S3.3.5", "5.4"}]},
  "5.5"->{
    Cell[100751, 3717, 132, 4, 70, "MathCaption",
      CellTags->{"S3.3.5", "5.5"}]},
  "5.6"->{
    Cell[101110, 3735, 114, 2, 70, "MathCaption",
      CellTags->{"S3.3.5", "5.6"}]},
  "S3.3.6"->{
    Cell[101481, 3754, 125, 4, 70, "Subsection",
      CellTags->{"S3.3.6", "6.1"}],
    Cell[101609, 3760, 348, 8, 70, "Text",
      CellTags->{"S3.3.6", "6.2"}],
    Cell[101960, 3770, 1506, 44, 70, "DefinitionBox",
      CellTags->"S3.3.6"],
    Cell[103469, 3816, 93, 1, 70, "Caption",
      CellTags->"S3.3.6"],
    Cell[103565, 3819, 144, 4, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.3"}],
    Cell[103734, 3827, 79, 2, 70, "Input",
      CellTags->"S3.3.6"],
    Cell[103816, 3831, 89, 3, 70, "Output",
      CellTags->"S3.3.6"],
    Cell[103920, 3837, 216, 6, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.4"}],
    Cell[104161, 3847, 103, 2, 70, "Input",
      CellTags->"S3.3.6"],
    Cell[104267, 3851, 141, 4, 70, "Output",
      CellTags->"S3.3.6"],
    Cell[104423, 3858, 225, 7, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.5"}],
    Cell[104673, 3869, 104, 2, 70, "Input",
      CellTags->"S3.3.6"],
    Cell[104780, 3873, 142, 4, 70, "Output",
      CellTags->"S3.3.6"],
    Cell[104937, 3880, 181, 6, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.6"}],
    Cell[105143, 3890, 105, 2, 70, "Input",
      CellTags->"S3.3.6"],
    Cell[105251, 3894, 142, 4, 70, "Output",
      CellTags->"S3.3.6"],
    Cell[105408, 3901, 315, 9, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.7"}],
    Cell[105748, 3914, 113, 2, 70, "Input",
      CellTags->"S3.3.6"],
    Cell[105864, 3918, 249, 5, 70, "Output",
      CellTags->"S3.3.6"],
    Cell[106128, 3926, 141, 4, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.8"}],
    Cell[106294, 3934, 73, 2, 70, "Input",
      CellTags->"S3.3.6"],
    Cell[106370, 3938, 89, 3, 70, "Output",
      CellTags->"S3.3.6"],
    Cell[106474, 3944, 682, 20, 70, "DefinitionBox",
      CellTags->"S3.3.6"],
    Cell[107159, 3966, 99, 1, 70, "Caption",
      CellTags->"S3.3.6"],
    Cell[107261, 3969, 195, 6, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.9"}],
    Cell[107481, 3979, 91, 2, 70, "Input",
      CellTags->"S3.3.6"],
    Cell[107575, 3983, 101, 3, 70, "Output",
      CellTags->"S3.3.6"],
    Cell[107691, 3989, 151, 5, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.10"}],
    Cell[107867, 3998, 73, 2, 70, "Input",
      CellTags->"S3.3.6"],
    Cell[107943, 4002, 101, 3, 70, "Output",
      CellTags->"S3.3.6"],
    Cell[108059, 4008, 237, 6, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.11"}],
    Cell[108321, 4018, 97, 2, 70, "Input",
      CellTags->"S3.3.6"],
    Cell[108421, 4022, 97, 3, 70, "Output",
      CellTags->"S3.3.6"],
    Cell[108533, 4028, 355, 8, 70, "Text",
      CellTags->{"S3.3.6", "6.12"}],
    Cell[108891, 4038, 155, 5, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.13"}],
    Cell[109071, 4047, 86, 2, 70, "Input",
      CellTags->"S3.3.6"],
    Cell[109160, 4051, 125, 3, 70, "Output",
      CellTags->"S3.3.6"],
    Cell[109300, 4057, 72, 1, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.14"}],
    Cell[109397, 4062, 108, 2, 70, "Input",
      CellTags->"S3.3.6"],
    Cell[109508, 4066, 111, 3, 70, "Output",
      CellTags->"S3.3.6"],
    Cell[109634, 4072, 155, 5, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.15"}],
    Cell[109814, 4081, 90, 2, 70, "Input",
      CellTags->"S3.3.6"],
    Cell[109907, 4085, 129, 3, 70, "Output",
      CellTags->"S3.3.6"],
    Cell[110051, 4091, 72, 1, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.16"}],
    Cell[110148, 4096, 112, 2, 70, "Input",
      CellTags->"S3.3.6"],
    Cell[110263, 4100, 119, 3, 70, "Output",
      CellTags->"S3.3.6"]},
  "6.1"->{
    Cell[101481, 3754, 125, 4, 70, "Subsection",
      CellTags->{"S3.3.6", "6.1"}]},
  "6.2"->{
    Cell[101609, 3760, 348, 8, 70, "Text",
      CellTags->{"S3.3.6", "6.2"}]},
  "6.3"->{
    Cell[103565, 3819, 144, 4, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.3"}]},
  "6.4"->{
    Cell[103920, 3837, 216, 6, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.4"}]},
  "6.5"->{
    Cell[104423, 3858, 225, 7, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.5"}]},
  "6.6"->{
    Cell[104937, 3880, 181, 6, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.6"}]},
  "6.7"->{
    Cell[105408, 3901, 315, 9, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.7"}]},
  "6.8"->{
    Cell[106128, 3926, 141, 4, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.8"}]},
  "6.9"->{
    Cell[107261, 3969, 195, 6, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.9"}]},
  "6.10"->{
    Cell[107691, 3989, 151, 5, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.10"}]},
  "6.11"->{
    Cell[108059, 4008, 237, 6, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.11"}]},
  "6.12"->{
    Cell[108533, 4028, 355, 8, 70, "Text",
      CellTags->{"S3.3.6", "6.12"}]},
  "6.13"->{
    Cell[108891, 4038, 155, 5, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.13"}]},
  "6.14"->{
    Cell[109300, 4057, 72, 1, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.14"}]},
  "6.15"->{
    Cell[109634, 4072, 155, 5, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.15"}]},
  "6.16"->{
    Cell[110051, 4091, 72, 1, 70, "MathCaption",
      CellTags->{"S3.3.6", "6.16"}]},
  "S3.3.7"->{
    Cell[110431, 4109, 84, 1, 70, "Subsection",
      CellTags->{"S3.3.7", "7.1"}],
    Cell[110518, 4112, 1220, 33, 70, "DefinitionBox",
      CellTags->"S3.3.7"],
    Cell[111741, 4147, 95, 1, 70, "Caption",
      CellTags->"S3.3.7"],
    Cell[111839, 4150, 99, 1, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.2"}],
    Cell[111963, 4155, 93, 2, 70, "Input",
      CellTags->"S3.3.7"],
    Cell[112059, 4159, 142, 4, 70, "Output",
      CellTags->"S3.3.7"],
    Cell[112216, 4166, 83, 1, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.3"}],
    Cell[112324, 4171, 77, 2, 70, "Input",
      CellTags->"S3.3.7"],
    Cell[112404, 4175, 153, 4, 70, "Output",
      CellTags->"S3.3.7"],
    Cell[112572, 4182, 145, 4, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.4"}],
    Cell[112742, 4190, 77, 2, 70, "Input",
      CellTags->"S3.3.7"],
    Cell[112822, 4194, 128, 3, 70, "Output",
      CellTags->"S3.3.7"],
    Cell[112965, 4200, 154, 4, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.5"}],
    Cell[113144, 4208, 87, 2, 70, "Input",
      CellTags->"S3.3.7"],
    Cell[113234, 4212, 208, 4, 70, "Output",
      CellTags->"S3.3.7"],
    Cell[113457, 4219, 139, 4, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.6"}],
    Cell[113621, 4227, 77, 2, 70, "Input",
      CellTags->"S3.3.7"],
    Cell[113701, 4231, 92, 3, 70, "Output",
      CellTags->"S3.3.7"],
    Cell[113808, 4237, 187, 6, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.7"}],
    Cell[114020, 4247, 79, 2, 70, "Input",
      CellTags->"S3.3.7"],
    Cell[114102, 4251, 95, 3, 70, "Output",
      CellTags->"S3.3.7"],
    Cell[114212, 4257, 201, 7, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.8"}],
    Cell[114438, 4268, 81, 2, 70, "Input",
      CellTags->"S3.3.7"],
    Cell[114522, 4272, 120, 3, 70, "Output",
      CellTags->"S3.3.7"],
    Cell[114657, 4278, 720, 20, 70, "DefinitionBox",
      CellTags->"S3.3.7"],
    Cell[115380, 4300, 78, 1, 70, "Caption",
      CellTags->"S3.3.7"],
    Cell[115461, 4303, 159, 4, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.9"}],
    Cell[115645, 4311, 81, 2, 70, "Input",
      CellTags->"S3.3.7"],
    Cell[115729, 4315, 280, 5, 70, "Output",
      CellTags->"S3.3.7"],
    Cell[116024, 4323, 182, 5, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.10"}],
    Cell[116231, 4332, 76, 2, 70, "Input",
      CellTags->"S3.3.7"],
    Cell[116310, 4336, 87, 3, 70, "Output",
      CellTags->"S3.3.7"],
    Cell[116412, 4342, 156, 4, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.11"}],
    Cell[116593, 4350, 92, 2, 70, "Input",
      CellTags->"S3.3.7"],
    Cell[116688, 4354, 92, 3, 70, "Output",
      CellTags->"S3.3.7"],
    Cell[116795, 4360, 159, 5, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.12"}],
    Cell[116979, 4369, 87, 2, 70, "Input",
      CellTags->"S3.3.7"],
    Cell[117069, 4373, 128, 3, 70, "Output",
      CellTags->"S3.3.7"]},
  "7.1"->{
    Cell[110431, 4109, 84, 1, 70, "Subsection",
      CellTags->{"S3.3.7", "7.1"}]},
  "7.2"->{
    Cell[111839, 4150, 99, 1, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.2"}]},
  "7.3"->{
    Cell[112216, 4166, 83, 1, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.3"}]},
  "7.4"->{
    Cell[112572, 4182, 145, 4, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.4"}]},
  "7.5"->{
    Cell[112965, 4200, 154, 4, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.5"}]},
  "7.6"->{
    Cell[113457, 4219, 139, 4, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.6"}]},
  "7.7"->{
    Cell[113808, 4237, 187, 6, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.7"}]},
  "7.8"->{
    Cell[114212, 4257, 201, 7, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.8"}]},
  "7.9"->{
    Cell[115461, 4303, 159, 4, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.9"}]},
  "7.10"->{
    Cell[116024, 4323, 182, 5, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.10"}]},
  "7.11"->{
    Cell[116412, 4342, 156, 4, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.11"}]},
  "7.12"->{
    Cell[116795, 4360, 159, 5, 70, "MathCaption",
      CellTags->{"S3.3.7", "7.12"}]},
  "S3.3.8"->{
    Cell[117246, 4382, 98, 1, 70, "Subsection",
      CellTags->{"S3.3.8", "8.1"}],
    Cell[117347, 4385, 368, 8, 70, "Text",
      CellTags->{"S3.3.8", "8.2"}],
    Cell[117718, 4395, 234, 6, 70, "Text",
      CellTags->{"S3.3.8", "8.3"}],
    Cell[117955, 4403, 1792, 53, 70, "DefinitionBox",
      CellTags->"S3.3.8"],
    Cell[119750, 4458, 72, 1, 70, "Caption",
      CellTags->"S3.3.8"],
    Cell[119825, 4461, 192, 7, 70, "MathCaption",
      CellTags->{"S3.3.8", "8.4"}],
    Cell[120042, 4472, 91, 2, 70, "Input",
      CellTags->"S3.3.8"],
    Cell[120136, 4476, 180, 4, 70, "Output",
      CellTags->"S3.3.8"],
    Cell[120331, 4483, 253, 8, 70, "MathCaption",
      CellTags->{"S3.3.8", "8.5"}],
    Cell[120609, 4495, 91, 2, 70, "Input",
      CellTags->"S3.3.8"],
    Cell[120703, 4499, 137, 3, 70, "Output",
      CellTags->"S3.3.8"],
    Cell[120855, 4505, 139, 4, 70, "MathCaption",
      CellTags->{"S3.3.8", "8.6"}],
    Cell[121019, 4513, 100, 2, 70, "Input",
      CellTags->"S3.3.8"],
    Cell[121122, 4517, 403, 7, 70, "Output",
      CellTags->"S3.3.8"],
    Cell[121540, 4527, 825, 31, 70, "Text",
      CellTags->{"S3.3.8", "8.7"}],
    Cell[122368, 4560, 893, 32, 70, "Text",
      CellTags->{"S3.3.8", "8.8"}],
    Cell[123264, 4594, 97, 1, 70, "MathCaption",
      CellTags->{"S3.3.8", "8.9"}],
    Cell[123386, 4599, 91, 2, 70, "Input",
      CellTags->"S3.3.8"],
    Cell[123480, 4603, 105, 3, 70, "Output",
      CellTags->"S3.3.8"],
    Cell[123600, 4609, 91, 1, 70, "MathCaption",
      CellTags->{"S3.3.8", "8.10"}],
    Cell[123716, 4614, 122, 2, 70, "Input",
      CellTags->"S3.3.8"],
    Cell[123841, 4618, 134, 3, 70, "Output",
      CellTags->"S3.3.8"],
    Cell[123990, 4624, 90, 1, 70, "MathCaption",
      CellTags->{"S3.3.8", "8.11"}],
    Cell[124105, 4629, 121, 2, 70, "Input",
      CellTags->"S3.3.8"],
    Cell[124229, 4633, 109, 3, 70, "Output",
      CellTags->"S3.3.8"]},
  "8.1"->{
    Cell[117246, 4382, 98, 1, 70, "Subsection",
      CellTags->{"S3.3.8", "8.1"}]},
  "8.2"->{
    Cell[117347, 4385, 368, 8, 70, "Text",
      CellTags->{"S3.3.8", "8.2"}]},
  "8.3"->{
    Cell[117718, 4395, 234, 6, 70, "Text",
      CellTags->{"S3.3.8", "8.3"}]},
  "8.4"->{
    Cell[119825, 4461, 192, 7, 70, "MathCaption",
      CellTags->{"S3.3.8", "8.4"}]},
  "8.5"->{
    Cell[120331, 4483, 253, 8, 70, "MathCaption",
      CellTags->{"S3.3.8", "8.5"}]},
  "8.6"->{
    Cell[120855, 4505, 139, 4, 70, "MathCaption",
      CellTags->{"S3.3.8", "8.6"}]},
  "8.7"->{
    Cell[121540, 4527, 825, 31, 70, "Text",
      CellTags->{"S3.3.8", "8.7"}]},
  "8.8"->{
    Cell[122368, 4560, 893, 32, 70, "Text",
      CellTags->{"S3.3.8", "8.8"}]},
  "8.9"->{
    Cell[123264, 4594, 97, 1, 70, "MathCaption",
      CellTags->{"S3.3.8", "8.9"}]},
  "8.10"->{
    Cell[123600, 4609, 91, 1, 70, "MathCaption",
      CellTags->{"S3.3.8", "8.10"}]},
  "8.11"->{
    Cell[123990, 4624, 90, 1, 70, "MathCaption",
      CellTags->{"S3.3.8", "8.11"}]},
  "S3.3.9"->{
    Cell[124387, 4642, 106, 1, 70, "Subsection",
      CellTags->{"S3.3.9", "9.1"}],
    Cell[124496, 4645, 276, 8, 70, "Text",
      CellTags->{"S3.3.9", "9.2"}],
    Cell[124775, 4655, 1185, 35, 70, "DefinitionBox",
      CellTags->"S3.3.9"],
    Cell[125963, 4692, 88, 1, 70, "Caption",
      CellTags->"S3.3.9"],
    Cell[126054, 4695, 231, 6, 70, "Text",
      CellTags->{"S3.3.9", "9.3"}],
    Cell[126288, 4703, 156, 5, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.4"}],
    Cell[126469, 4712, 77, 2, 70, "Input",
      CellTags->"S3.3.9"],
    Cell[126549, 4716, 98, 3, 70, "Output",
      CellTags->"S3.3.9"],
    Cell[126662, 4722, 139, 4, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.5"}],
    Cell[126826, 4730, 80, 2, 70, "Input",
      CellTags->"S3.3.9"],
    Cell[126909, 4734, 109, 3, 70, "Output",
      CellTags->"S3.3.9"],
    Cell[127033, 4740, 239, 5, 70, "Text",
      CellTags->{"S3.3.9", "9.6"}],
    Cell[127275, 4747, 131, 4, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.7"}],
    Cell[127431, 4755, 91, 2, 70, "Input",
      CellTags->"S3.3.9"],
    Cell[127525, 4759, 210, 5, 70, "Output",
      CellTags->"S3.3.9"],
    Cell[127750, 4767, 373, 12, 70, "Text",
      CellTags->{"S3.3.9", "9.8"}],
    Cell[128126, 4781, 156, 5, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.9"}],
    Cell[128307, 4790, 93, 2, 70, "Input",
      CellTags->"S3.3.9"],
    Cell[128403, 4794, 110, 3, 70, "Output",
      CellTags->"S3.3.9"],
    Cell[128528, 4800, 181, 6, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.10"}],
    Cell[128734, 4810, 82, 2, 70, "Input",
      CellTags->"S3.3.9"],
    Cell[128819, 4814, 411, 13, 70, "Output",
      CellTags->"S3.3.9"],
    Cell[129245, 4830, 423, 16, 70, "Text",
      CellTags->{"S3.3.9", "9.11"}],
    Cell[129671, 4848, 149, 5, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.12"}],
    Cell[129845, 4857, 98, 2, 70, "Input",
      CellTags->"S3.3.9"],
    Cell[129946, 4861, 438, 13, 70, "Output",
      CellTags->"S3.3.9"],
    Cell[130399, 4877, 196, 7, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.13"}],
    Cell[130620, 4888, 108, 2, 70, "Input",
      CellTags->"S3.3.9"],
    Cell[130731, 4892, 368, 12, 70, "Output",
      CellTags->"S3.3.9"],
    Cell[131114, 4907, 342, 12, 70, "Text",
      CellTags->{"S3.3.9", "9.14"}],
    Cell[131459, 4921, 167, 5, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.15"}],
    Cell[131651, 4930, 102, 2, 70, "Input",
      CellTags->"S3.3.9"],
    Cell[131756, 4934, 323, 9, 70, "Output",
      CellTags->"S3.3.9"],
    Cell[132094, 4946, 433, 12, 70, "Text",
      CellTags->{"S3.3.9", "9.16"}]},
  "9.1"->{
    Cell[124387, 4642, 106, 1, 70, "Subsection",
      CellTags->{"S3.3.9", "9.1"}]},
  "9.2"->{
    Cell[124496, 4645, 276, 8, 70, "Text",
      CellTags->{"S3.3.9", "9.2"}]},
  "9.3"->{
    Cell[126054, 4695, 231, 6, 70, "Text",
      CellTags->{"S3.3.9", "9.3"}]},
  "9.4"->{
    Cell[126288, 4703, 156, 5, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.4"}]},
  "9.5"->{
    Cell[126662, 4722, 139, 4, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.5"}]},
  "9.6"->{
    Cell[127033, 4740, 239, 5, 70, "Text",
      CellTags->{"S3.3.9", "9.6"}]},
  "9.7"->{
    Cell[127275, 4747, 131, 4, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.7"}]},
  "9.8"->{
    Cell[127750, 4767, 373, 12, 70, "Text",
      CellTags->{"S3.3.9", "9.8"}]},
  "9.9"->{
    Cell[128126, 4781, 156, 5, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.9"}]},
  "9.10"->{
    Cell[128528, 4800, 181, 6, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.10"}]},
  "9.11"->{
    Cell[129245, 4830, 423, 16, 70, "Text",
      CellTags->{"S3.3.9", "9.11"}]},
  "9.12"->{
    Cell[129671, 4848, 149, 5, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.12"}]},
  "9.13"->{
    Cell[130399, 4877, 196, 7, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.13"}]},
  "9.14"->{
    Cell[131114, 4907, 342, 12, 70, "Text",
      CellTags->{"S3.3.9", "9.14"}]},
  "9.15"->{
    Cell[131459, 4921, 167, 5, 70, "MathCaption",
      CellTags->{"S3.3.9", "9.15"}]},
  "9.16"->{
    Cell[132094, 4946, 433, 12, 70, "Text",
      CellTags->{"S3.3.9", "9.16"}]},
  "S3.3.10"->{
    Cell[132564, 4963, 76, 1, 70, "Subsection",
      CellTags->{"S3.3.10", "10.1"}],
    Cell[132643, 4966, 734, 22, 70, "DefinitionBox",
      CellTags->"S3.3.10"],
    Cell[133380, 4990, 67, 1, 70, "Caption",
      CellTags->"S3.3.10"],
    Cell[133450, 4993, 173, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.2"}],
    Cell[133648, 5001, 82, 2, 70, "Input",
      CellTags->"S3.3.10"],
    Cell[133733, 5005, 105, 3, 70, "Output",
      CellTags->"S3.3.10"],
    Cell[133853, 5011, 132, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.3"}],
    Cell[134010, 5019, 76, 2, 70, "Input",
      CellTags->"S3.3.10"],
    Cell[134089, 5023, 94, 3, 70, "Output",
      CellTags->"S3.3.10"],
    Cell[134198, 5029, 166, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.4"}],
    Cell[134389, 5037, 94, 2, 70, "Input",
      CellTags->"S3.3.10"],
    Cell[134486, 5041, 83, 3, 70, "Output",
      CellTags->"S3.3.10"],
    Cell[134584, 5047, 172, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.5"}],
    Cell[134781, 5055, 87, 2, 70, "Input",
      CellTags->"S3.3.10"],
    Cell[134871, 5059, 97, 3, 70, "Output",
      CellTags->"S3.3.10"],
    Cell[134983, 5065, 142, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.6"}],
    Cell[135150, 5073, 80, 2, 70, "Input",
      CellTags->"S3.3.10"],
    Cell[135233, 5077, 90, 3, 70, "Output",
      CellTags->"S3.3.10"],
    Cell[135338, 5083, 831, 25, 70, "DefinitionBox",
      CellTags->"S3.3.10"],
    Cell[136172, 5110, 70, 1, 70, "Caption",
      CellTags->"S3.3.10"],
    Cell[136245, 5113, 140, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.7"}],
    Cell[136410, 5121, 114, 2, 70, "Input",
      CellTags->"S3.3.10"],
    Cell[136527, 5125, 133, 3, 70, "Output",
      CellTags->"S3.3.10"],
    Cell[136675, 5131, 158, 5, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.8"}],
    Cell[136858, 5140, 80, 2, 70, "Input",
      CellTags->"S3.3.10"],
    Cell[136941, 5144, 115, 3, 70, "Output",
      CellTags->"S3.3.10"],
    Cell[137071, 5150, 160, 5, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.9"}],
    Cell[137256, 5159, 104, 2, 70, "Input",
      CellTags->"S3.3.10"],
    Cell[137363, 5163, 123, 3, 70, "Output",
      CellTags->"S3.3.10"],
    Cell[137501, 5169, 4300, 125, 70, "DefinitionBox",
      CellTags->"S3.3.10"],
    Cell[141804, 5296, 77, 1, 70, "Caption",
      CellTags->"S3.3.10"],
    Cell[141884, 5299, 619, 17, 70, "Text",
      CellTags->{"S3.3.10", "10.10"}],
    Cell[142506, 5318, 176, 5, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.11"}],
    Cell[142707, 5327, 84, 2, 70, "Input",
      CellTags->"S3.3.10"],
    Cell[142794, 5331, 92, 3, 70, "Output",
      CellTags->"S3.3.10"],
    Cell[142901, 5337, 136, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.12"}],
    Cell[143062, 5345, 118, 2, 70, "Input",
      CellTags->"S3.3.10"],
    Cell[143183, 5349, 93, 3, 70, "Output",
      CellTags->"S3.3.10"]},
  "10.1"->{
    Cell[132564, 4963, 76, 1, 70, "Subsection",
      CellTags->{"S3.3.10", "10.1"}]},
  "10.2"->{
    Cell[133450, 4993, 173, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.2"}]},
  "10.3"->{
    Cell[133853, 5011, 132, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.3"}]},
  "10.4"->{
    Cell[134198, 5029, 166, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.4"}]},
  "10.5"->{
    Cell[134584, 5047, 172, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.5"}]},
  "10.6"->{
    Cell[134983, 5065, 142, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.6"}]},
  "10.7"->{
    Cell[136245, 5113, 140, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.7"}]},
  "10.8"->{
    Cell[136675, 5131, 158, 5, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.8"}]},
  "10.9"->{
    Cell[137071, 5150, 160, 5, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.9"}]},
  "10.10"->{
    Cell[141884, 5299, 619, 17, 70, "Text",
      CellTags->{"S3.3.10", "10.10"}]},
  "10.11"->{
    Cell[142506, 5318, 176, 5, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.11"}]},
  "10.12"->{
    Cell[142901, 5337, 136, 4, 70, "MathCaption",
      CellTags->{"S3.3.10", "10.12"}]},
  "S3.3.11"->{
    Cell[143325, 5358, 79, 1, 70, "Subsection",
      CellTags->{"S3.3.11", "11.1"}],
    Cell[143407, 5361, 372, 7, 70, "Text",
      CellTags->{"S3.3.11", "11.2"}],
    Cell[143782, 5370, 1553, 46, 70, "DefinitionBox",
      CellTags->"S3.3.11"],
    Cell[145338, 5418, 77, 1, 70, "Caption",
      CellTags->"S3.3.11"],
    Cell[145418, 5421, 161, 4, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.3"}],
    Cell[145604, 5429, 96, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[145703, 5433, 106, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[145824, 5439, 262, 9, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.4"}],
    Cell[146111, 5452, 96, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[146210, 5456, 177, 4, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[146402, 5463, 321, 11, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.5"}],
    Cell[146748, 5478, 103, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[146854, 5482, 83, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[146952, 5488, 359, 13, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.6"}],
    Cell[147336, 5505, 89, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[147428, 5509, 91, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[147534, 5515, 359, 13, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.7"}],
    Cell[147918, 5532, 105, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[148026, 5536, 97, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[148138, 5542, 275, 8, 70, "Text",
      CellTags->{"S3.3.11", "11.8"}],
    Cell[148416, 5552, 279, 8, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.9"}],
    Cell[148720, 5564, 86, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[148809, 5568, 99, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[148923, 5574, 151, 5, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.10"}],
    Cell[149099, 5583, 93, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[149195, 5587, 86, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[149296, 5593, 163, 4, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.11"}],
    Cell[149484, 5601, 115, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[149602, 5605, 86, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[149703, 5611, 396, 13, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.12"}],
    Cell[150124, 5628, 100, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[150227, 5632, 86, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[150328, 5638, 841, 25, 70, "Text",
      CellTags->{"S3.3.11", "11.13"}],
    Cell[151172, 5665, 150, 5, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.14"}],
    Cell[151347, 5674, 89, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[151439, 5678, 89, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[151543, 5684, 246, 8, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.15"}],
    Cell[151814, 5696, 87, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[151904, 5700, 117, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[152036, 5706, 606, 19, 70, "Text",
      CellTags->{"S3.3.11", "11.16"}],
    Cell[152645, 5727, 2709, 81, 70, "DefinitionBox",
      CellTags->"S3.3.11"],
    Cell[155357, 5810, 90, 1, 70, "Caption",
      CellTags->"S3.3.11"],
    Cell[155450, 5813, 213, 6, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.17"}],
    Cell[155688, 5823, 85, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[155776, 5827, 87, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[155878, 5833, 134, 4, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.18"}],
    Cell[156037, 5841, 121, 4, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[156161, 5847, 87, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[156263, 5853, 222, 7, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.19"}],
    Cell[156510, 5864, 90, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[156603, 5868, 88, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[156706, 5874, 303, 9, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.20"}],
    Cell[157034, 5887, 94, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[157131, 5891, 128, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[157274, 5897, 194, 5, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.21"}],
    Cell[157493, 5906, 84, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[157580, 5910, 101, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[157696, 5916, 2626, 80, 70, "DefinitionBox",
      CellTags->"S3.3.11"],
    Cell[160325, 5998, 120, 5, 70, "Caption",
      CellTags->"S3.3.11"],
    Cell[160448, 6005, 448, 17, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.22"}],
    Cell[160921, 6026, 116, 4, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[161040, 6032, 84, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[161139, 6038, 460, 16, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.23"}],
    Cell[161624, 6058, 116, 4, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[161743, 6064, 87, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[161845, 6070, 208, 5, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.24"}],
    Cell[162078, 6079, 101, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[162182, 6083, 87, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[162284, 6089, 322, 11, 70, "Text",
      CellTags->{"S3.3.11", "11.25"}],
    Cell[162609, 6102, 108, 1, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.26"}],
    Cell[162742, 6107, 120, 4, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[162865, 6113, 89, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[162969, 6119, 297, 12, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.27"}],
    Cell[163291, 6135, 124, 4, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[163418, 6141, 89, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[163522, 6147, 516, 19, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.28"}],
    Cell[164063, 6170, 98, 2, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[164164, 6174, 87, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[164266, 6180, 152, 4, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.29"}],
    Cell[164443, 6188, 125, 4, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[164571, 6194, 84, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[164670, 6200, 188, 5, 70, "Text",
      CellTags->{"S3.3.11", "11.30"}],
    Cell[164861, 6207, 108, 1, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.31"}],
    Cell[164994, 6212, 127, 4, 70, "Input",
      CellTags->"S3.3.11"],
    Cell[165124, 6218, 93, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[165232, 6224, 132, 4, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.32"}],
    Cell[165389, 6232, 151, 5, 45, "Input",
      CellTags->"S3.3.11"],
    Cell[165543, 6239, 107, 3, 70, "Output",
      CellTags->"S3.3.11"],
    Cell[165665, 6245, 598, 21, 72, "Text",
      CellTags->{"S3.3.11", "11.33"}],
    Cell[166266, 6268, 829, 25, 66, "DefinitionBox",
      CellTags->"S3.3.11"],
    Cell[167098, 6295, 85, 1, 16, "Caption",
      CellTags->"S3.3.11"],
    Cell[167186, 6298, 242, 11, 40, "MathCaption",
      CellTags->{"S3.3.11", "11.34"}],
    Cell[167453, 6313, 102, 2, 28, "Input",
      CellTags->"S3.3.11"],
    Cell[167558, 6317, 84, 3, 25, "Output",
      CellTags->"S3.3.11"],
    Cell[167657, 6323, 98, 1, 40, "MathCaption",
      CellTags->{"S3.3.11", "11.35"}],
    Cell[167780, 6328, 150, 5, 45, "Input",
      CellTags->"S3.3.11"],
    Cell[167933, 6335, 84, 3, 25, "Output",
      CellTags->"S3.3.11"],
    Cell[168032, 6341, 605, 22, 72, "Text",
      CellTags->{"S3.3.11", "11.36"}],
    Cell[168640, 6365, 507, 19, 56, "Text",
      CellTags->{"S3.3.11", "11.37"}],
    Cell[169150, 6386, 152, 5, 40, "MathCaption",
      CellTags->{"S3.3.11", "11.38"}],
    Cell[169327, 6395, 114, 2, 28, "Input",
      CellTags->"S3.3.11"],
    Cell[169444, 6399, 104, 3, 45, "Output",
      CellTags->"S3.3.11"]},
  "11.1"->{
    Cell[143325, 5358, 79, 1, 70, "Subsection",
      CellTags->{"S3.3.11", "11.1"}]},
  "11.2"->{
    Cell[143407, 5361, 372, 7, 70, "Text",
      CellTags->{"S3.3.11", "11.2"}]},
  "11.3"->{
    Cell[145418, 5421, 161, 4, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.3"}]},
  "11.4"->{
    Cell[145824, 5439, 262, 9, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.4"}]},
  "11.5"->{
    Cell[146402, 5463, 321, 11, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.5"}]},
  "11.6"->{
    Cell[146952, 5488, 359, 13, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.6"}]},
  "11.7"->{
    Cell[147534, 5515, 359, 13, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.7"}]},
  "11.8"->{
    Cell[148138, 5542, 275, 8, 70, "Text",
      CellTags->{"S3.3.11", "11.8"}]},
  "11.9"->{
    Cell[148416, 5552, 279, 8, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.9"}]},
  "11.10"->{
    Cell[148923, 5574, 151, 5, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.10"}]},
  "11.11"->{
    Cell[149296, 5593, 163, 4, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.11"}]},
  "11.12"->{
    Cell[149703, 5611, 396, 13, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.12"}]},
  "11.13"->{
    Cell[150328, 5638, 841, 25, 70, "Text",
      CellTags->{"S3.3.11", "11.13"}]},
  "11.14"->{
    Cell[151172, 5665, 150, 5, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.14"}]},
  "11.15"->{
    Cell[151543, 5684, 246, 8, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.15"}]},
  "11.16"->{
    Cell[152036, 5706, 606, 19, 70, "Text",
      CellTags->{"S3.3.11", "11.16"}]},
  "11.17"->{
    Cell[155450, 5813, 213, 6, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.17"}]},
  "11.18"->{
    Cell[155878, 5833, 134, 4, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.18"}]},
  "11.19"->{
    Cell[156263, 5853, 222, 7, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.19"}]},
  "11.20"->{
    Cell[156706, 5874, 303, 9, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.20"}]},
  "11.21"->{
    Cell[157274, 5897, 194, 5, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.21"}]},
  "11.22"->{
    Cell[160448, 6005, 448, 17, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.22"}]},
  "11.23"->{
    Cell[161139, 6038, 460, 16, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.23"}]},
  "11.24"->{
    Cell[161845, 6070, 208, 5, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.24"}]},
  "11.25"->{
    Cell[162284, 6089, 322, 11, 70, "Text",
      CellTags->{"S3.3.11", "11.25"}]},
  "11.26"->{
    Cell[162609, 6102, 108, 1, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.26"}]},
  "11.27"->{
    Cell[162969, 6119, 297, 12, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.27"}]},
  "11.28"->{
    Cell[163522, 6147, 516, 19, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.28"}]},
  "11.29"->{
    Cell[164266, 6180, 152, 4, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.29"}]},
  "11.30"->{
    Cell[164670, 6200, 188, 5, 70, "Text",
      CellTags->{"S3.3.11", "11.30"}]},
  "11.31"->{
    Cell[164861, 6207, 108, 1, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.31"}]},
  "11.32"->{
    Cell[165232, 6224, 132, 4, 70, "MathCaption",
      CellTags->{"S3.3.11", "11.32"}]},
  "11.33"->{
    Cell[165665, 6245, 598, 21, 72, "Text",
      CellTags->{"S3.3.11", "11.33"}]},
  "11.34"->{
    Cell[167186, 6298, 242, 11, 40, "MathCaption",
      CellTags->{"S3.3.11", "11.34"}]},
  "11.35"->{
    Cell[167657, 6323, 98, 1, 40, "MathCaption",
      CellTags->{"S3.3.11", "11.35"}]},
  "11.36"->{
    Cell[168032, 6341, 605, 22, 72, "Text",
      CellTags->{"S3.3.11", "11.36"}]},
  "11.37"->{
    Cell[168640, 6365, 507, 19, 56, "Text",
      CellTags->{"S3.3.11", "11.37"}]},
  "11.38"->{
    Cell[169150, 6386, 152, 5, 40, "MathCaption",
      CellTags->{"S3.3.11", "11.38"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S3.3.0", 170203, 6423},
  {"0.1", 170293, 6426},
  {"S3.3.1", 170386, 6429},
  {"1.1", 174841, 6550},
  {"1.2", 174933, 6553},
  {"1.3", 175027, 6556},
  {"1.4", 175122, 6559},
  {"1.5", 175217, 6562},
  {"1.6", 175312, 6565},
  {"1.7", 175401, 6568},
  {"1.8", 175490, 6571},
  {"1.9", 175584, 6574},
  {"1.10", 175680, 6577},
  {"1.11", 175777, 6580},
  {"1.12", 175875, 6583},
  {"1.13", 175973, 6586},
  {"1.14", 176065, 6589},
  {"1.15", 176163, 6592},
  {"1.16", 176261, 6595},
  {"1.17", 176359, 6598},
  {"1.18", 176457, 6601},
  {"1.19", 176555, 6604},
  {"1.20", 176653, 6607},
  {"S3.3.2", 176753, 6610},
  {"2.1", 180055, 6699},
  {"2.2", 180149, 6702},
  {"2.3", 180244, 6705},
  {"2.4", 180339, 6708},
  {"2.5", 180435, 6711},
  {"2.6", 180531, 6714},
  {"2.7", 180627, 6717},
  {"2.8", 180723, 6720},
  {"2.9", 180820, 6723},
  {"2.10", 180917, 6726},
  {"2.11", 181016, 6729},
  {"2.12", 181116, 6732},
  {"2.13", 181215, 6735},
  {"2.14", 181307, 6738},
  {"2.15", 181399, 6741},
  {"2.16", 181498, 6744},
  {"S3.3.3", 181600, 6747},
  {"3.1", 185769, 6858},
  {"3.2", 185865, 6861},
  {"3.3", 185955, 6864},
  {"3.4", 186051, 6867},
  {"3.5", 186148, 6870},
  {"3.6", 186245, 6873},
  {"3.7", 186342, 6876},
  {"3.8", 186439, 6879},
  {"3.9", 186536, 6882},
  {"3.10", 186633, 6885},
  {"3.11", 186732, 6888},
  {"3.12", 186831, 6891},
  {"3.13", 186930, 6894},
  {"3.14", 187029, 6897},
  {"3.15", 187128, 6900},
  {"3.16", 187220, 6903},
  {"3.17", 187313, 6906},
  {"3.18", 187412, 6909},
  {"3.19", 187511, 6912},
  {"S3.3.4", 187612, 6915},
  {"4.1", 196314, 7144},
  {"4.2", 196409, 7147},
  {"4.3", 196499, 7150},
  {"4.4", 196589, 7153},
  {"4.5", 196679, 7156},
  {"4.6", 196771, 7159},
  {"4.7", 196869, 7162},
  {"4.8", 196967, 7165},
  {"4.9", 197063, 7168},
  {"4.10", 197161, 7171},
  {"4.11", 197254, 7174},
  {"4.12", 197353, 7177},
  {"4.13", 197447, 7180},
  {"4.14", 197547, 7183},
  {"4.15", 197646, 7186},
  {"4.16", 197739, 7189},
  {"4.17", 197839, 7192},
  {"4.18", 197933, 7195},
  {"4.19", 198033, 7198},
  {"4.20", 198127, 7201},
  {"4.21", 198227, 7204},
  {"4.22", 198326, 7207},
  {"4.23", 198425, 7210},
  {"4.24", 198520, 7213},
  {"4.25", 198620, 7216},
  {"4.26", 198713, 7219},
  {"4.27", 198811, 7222},
  {"4.28", 198910, 7225},
  {"4.29", 199010, 7228},
  {"4.30", 199109, 7231},
  {"4.31", 199201, 7234},
  {"4.32", 199293, 7237},
  {"4.33", 199392, 7240},
  {"4.34", 199485, 7243},
  {"4.35", 199584, 7246},
  {"4.36", 199683, 7249},
  {"4.37", 199777, 7252},
  {"4.38", 199877, 7255},
  {"4.39", 199977, 7258},
  {"4.40", 200071, 7261},
  {"4.41", 200172, 7264},
  {"4.42", 200270, 7267},
  {"4.43", 200369, 7270},
  {"4.44", 200468, 7273},
  {"4.45", 200561, 7276},
  {"4.46", 200655, 7279},
  {"4.47", 200754, 7282},
  {"S3.3.5", 200855, 7285},
  {"5.1", 202091, 7318},
  {"5.2", 202186, 7321},
  {"5.3", 202277, 7324},
  {"5.4", 202374, 7327},
  {"5.5", 202471, 7330},
  {"5.6", 202569, 7333},
  {"S3.3.6", 202670, 7336},
  {"6.1", 206202, 7429},
  {"6.2", 206299, 7432},
  {"6.3", 206390, 7435},
  {"6.4", 206488, 7438},
  {"6.5", 206586, 7441},
  {"6.6", 206684, 7444},
  {"6.7", 206782, 7447},
  {"6.8", 206880, 7450},
  {"6.9", 206978, 7453},
  {"6.10", 207077, 7456},
  {"6.11", 207177, 7459},
  {"6.12", 207277, 7462},
  {"6.13", 207370, 7465},
  {"6.14", 207470, 7468},
  {"6.15", 207569, 7471},
  {"6.16", 207669, 7474},
  {"S3.3.7", 207770, 7477},
  {"7.1", 210676, 7554},
  {"7.2", 210772, 7557},
  {"7.3", 210869, 7560},
  {"7.4", 210966, 7563},
  {"7.5", 211064, 7566},
  {"7.6", 211162, 7569},
  {"7.7", 211260, 7572},
  {"7.8", 211358, 7575},
  {"7.9", 211456, 7578},
  {"7.10", 211555, 7581},
  {"7.11", 211655, 7584},
  {"7.12", 211755, 7587},
  {"S3.3.8", 211857, 7590},
  {"8.1", 213794, 7641},
  {"8.2", 213890, 7644},
  {"8.3", 213981, 7647},
  {"8.4", 214072, 7650},
  {"8.5", 214170, 7653},
  {"8.6", 214268, 7656},
  {"8.7", 214366, 7659},
  {"8.8", 214458, 7662},
  {"8.9", 214550, 7665},
  {"8.10", 214648, 7668},
  {"8.11", 214747, 7671},
  {"S3.3.9", 214848, 7674},
  {"9.1", 217490, 7743},
  {"9.2", 217587, 7746},
  {"9.3", 217678, 7749},
  {"9.4", 217769, 7752},
  {"9.5", 217867, 7755},
  {"9.6", 217965, 7758},
  {"9.7", 218056, 7761},
  {"9.8", 218154, 7764},
  {"9.9", 218246, 7767},
  {"9.10", 218345, 7770},
  {"9.11", 218445, 7773},
  {"9.12", 218539, 7776},
  {"9.13", 218639, 7779},
  {"9.14", 218739, 7782},
  {"9.15", 218833, 7785},
  {"9.16", 218933, 7788},
  {"S3.3.10", 219030, 7791},
  {"10.1", 221995, 7868},
  {"10.2", 222094, 7871},
  {"10.3", 222195, 7874},
  {"10.4", 222296, 7877},
  {"10.5", 222397, 7880},
  {"10.6", 222498, 7883},
  {"10.7", 222599, 7886},
  {"10.8", 222700, 7889},
  {"10.9", 222801, 7892},
  {"10.10", 222903, 7895},
  {"10.11", 223000, 7898},
  {"10.12", 223103, 7901},
  {"S3.3.11", 223208, 7904},
  {"11.1", 231190, 8109},
  {"11.2", 231289, 8112},
  {"11.3", 231383, 8115},
  {"11.4", 231484, 8118},
  {"11.5", 231585, 8121},
  {"11.6", 231687, 8124},
  {"11.7", 231789, 8127},
  {"11.8", 231891, 8130},
  {"11.9", 231985, 8133},
  {"11.10", 232087, 8136},
  {"11.11", 232190, 8139},
  {"11.12", 232293, 8142},
  {"11.13", 232397, 8145},
  {"11.14", 232494, 8148},
  {"11.15", 232597, 8151},
  {"11.16", 232700, 8154},
  {"11.17", 232797, 8157},
  {"11.18", 232900, 8160},
  {"11.19", 233003, 8163},
  {"11.20", 233106, 8166},
  {"11.21", 233209, 8169},
  {"11.22", 233312, 8172},
  {"11.23", 233416, 8175},
  {"11.24", 233520, 8178},
  {"11.25", 233623, 8181},
  {"11.26", 233720, 8184},
  {"11.27", 233823, 8187},
  {"11.28", 233927, 8190},
  {"11.29", 234031, 8193},
  {"11.30", 234134, 8196},
  {"11.31", 234230, 8199},
  {"11.32", 234333, 8202},
  {"11.33", 234436, 8205},
  {"11.34", 234533, 8208},
  {"11.35", 234637, 8211},
  {"11.36", 234739, 8214},
  {"11.37", 234836, 8217},
  {"11.38", 234933, 8220}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 125, 4, 65, "Section",
  CellTags->{"S3.3.0", "0.1"}],

Cell[CellGroupData[{
Cell[1926, 61, 95, 1, 70, "Subsection",
  CellTags->{"S3.3.1", "1.1"}],
Cell[2024, 64, 2794, 87, 70, "DefinitionBox",
  CellTags->"S3.3.1"],
Cell[4821, 153, 79, 1, 70, "Caption",
  CellTags->"S3.3.1"],
Cell[4903, 156, 92, 1, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.2"}],

Cell[CellGroupData[{
Cell[5020, 161, 87, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[5110, 165, 122, 3, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[5247, 171, 183, 5, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.3"}],

Cell[CellGroupData[{
Cell[5455, 180, 79, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[5537, 184, 168, 4, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[5720, 191, 146, 4, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.4"}],

Cell[CellGroupData[{
Cell[5891, 199, 75, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[5969, 203, 125, 3, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[6109, 209, 179, 6, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.5"}],

Cell[CellGroupData[{
Cell[6313, 219, 80, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[6396, 223, 178, 4, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[6589, 230, 603, 17, 70, "Text",
  CellTags->{"S3.3.1", "1.6"}],
Cell[7195, 249, 623, 16, 70, "Text",
  CellTags->{"S3.3.1", "1.7"}],
Cell[7821, 267, 93, 1, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.8"}],

Cell[CellGroupData[{
Cell[7939, 272, 88, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[8030, 276, 179, 4, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[8224, 283, 240, 7, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.9"}],

Cell[CellGroupData[{
Cell[8489, 294, 79, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[8571, 298, 179, 4, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[8765, 305, 219, 6, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.10"}],

Cell[CellGroupData[{
Cell[9009, 315, 112, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[9124, 319, 314, 7, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[9453, 329, 705, 21, 70, "DefinitionBox",
  CellTags->"S3.3.1"],
Cell[10161, 352, 75, 1, 70, "Caption",
  CellTags->"S3.3.1"],
Cell[10239, 355, 151, 5, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.11"}],

Cell[CellGroupData[{
Cell[10415, 364, 94, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[10512, 368, 148, 4, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[10675, 375, 171, 5, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.12"}],

Cell[CellGroupData[{
Cell[10871, 384, 110, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[10984, 388, 195, 5, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[11194, 396, 1297, 37, 70, "DefinitionBox",
  CellTags->"S3.3.1"],
Cell[12494, 435, 59, 1, 70, "Caption",
  CellTags->"S3.3.1"],
Cell[12556, 438, 685, 23, 70, "Text",
  CellTags->{"S3.3.1", "1.13"}],
Cell[13244, 463, 156, 4, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.14"}],

Cell[CellGroupData[{
Cell[13425, 471, 72, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[13500, 475, 95, 3, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[13610, 481, 235, 8, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.15"}],

Cell[CellGroupData[{
Cell[13870, 493, 79, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[13952, 497, 92, 3, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[14059, 503, 132, 4, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.16"}],

Cell[CellGroupData[{
Cell[14216, 511, 71, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[14290, 515, 97, 3, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[14402, 521, 125, 4, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.17"}],

Cell[CellGroupData[{
Cell[14552, 529, 79, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[14634, 533, 103, 3, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[14752, 539, 1145, 35, 70, "DefinitionBox",
  CellTags->"S3.3.1"],
Cell[15900, 576, 67, 1, 70, "Caption",
  CellTags->"S3.3.1"],
Cell[15970, 579, 152, 5, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.18"}],

Cell[CellGroupData[{
Cell[16147, 588, 112, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[16262, 592, 132, 3, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[16409, 598, 136, 5, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.19"}],

Cell[CellGroupData[{
Cell[16570, 607, 81, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[16654, 611, 129, 3, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]],
Cell[16798, 617, 149, 5, 70, "MathCaption",
  CellTags->{"S3.3.1", "1.20"}],

Cell[CellGroupData[{
Cell[16972, 626, 89, 2, 70, "Input",
  CellTags->"S3.3.1"],
Cell[17064, 630, 129, 3, 70, "Output",
  CellTags->"S3.3.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17242, 639, 96, 1, 70, "Subsection",
  CellTags->{"S3.3.2", "2.1"}],
Cell[17341, 642, 5569, 172, 70, "DefinitionBox",
  CellTags->"S3.3.2"],
Cell[22913, 816, 114, 4, 70, "Caption",
  CellTags->"S3.3.2"],
Cell[23030, 822, 93, 1, 70, "MathCaption",
  CellTags->{"S3.3.2", "2.2"}],

Cell[CellGroupData[{
Cell[23148, 827, 91, 2, 70, "Input",
  CellTags->"S3.3.2"],
Cell[23242, 831, 115, 3, 70, "Output",
  CellTags->"S3.3.2"]
}, Open  ]],
Cell[23372, 837, 95, 1, 70, "MathCaption",
  CellTags->{"S3.3.2", "2.3"}],

Cell[CellGroupData[{
Cell[23492, 842, 73, 2, 70, "Input",
  CellTags->"S3.3.2"],
Cell[23568, 846, 221, 5, 70, "Output",
  CellTags->"S3.3.2"]
}, Open  ]],
Cell[23804, 854, 197, 8, 70, "MathCaption",
  CellTags->{"S3.3.2", "2.4"}],

Cell[CellGroupData[{
Cell[24026, 866, 81, 2, 70, "Input",
  CellTags->"S3.3.2"],
Cell[24110, 870, 85, 3, 70, "Output",
  CellTags->"S3.3.2"]
}, Open  ]],
Cell[24210, 876, 150, 5, 70, "MathCaption",
  CellTags->{"S3.3.2", "2.5"}],

Cell[CellGroupData[{
Cell[24385, 885, 90, 2, 70, "Input",
  CellTags->"S3.3.2"],
Cell[24478, 889, 86, 3, 70, "Output",
  CellTags->"S3.3.2"]
}, Open  ]],
Cell[24579, 895, 181, 6, 70, "MathCaption",
  CellTags->{"S3.3.2", "2.6"}],

Cell[CellGroupData[{
Cell[24785, 905, 76, 2, 70, "Input",
  CellTags->"S3.3.2"],
Cell[24864, 909, 87, 3, 70, "Output",
  CellTags->"S3.3.2"]
}, Open  ]],
Cell[24966, 915, 307, 9, 70, "MathCaption",
  CellTags->{"S3.3.2", "2.7"}],

Cell[CellGroupData[{
Cell[25298, 928, 78, 2, 70, "Input",
  CellTags->"S3.3.2"],
Cell[25379, 932, 82, 3, 70, "Output",
  CellTags->"S3.3.2"]
}, Open  ]],
Cell[25476, 938, 375, 13, 70, "MathCaption",
  CellTags->{"S3.3.2", "2.8"}],

Cell[CellGroupData[{
Cell[25876, 955, 83, 2, 70, "Input",
  CellTags->"S3.3.2"],
Cell[25962, 959, 97, 3, 70, "Output",
  CellTags->"S3.3.2"]
}, Open  ]],
Cell[26074, 965, 169, 7, 70, "MathCaption",
  CellTags->{"S3.3.2", "2.9"}],

Cell[CellGroupData[{
Cell[26268, 976, 84, 2, 70, "Input",
  CellTags->"S3.3.2"],
Cell[26355, 980, 97, 3, 70, "Output",
  CellTags->"S3.3.2"]
}, Open  ]],
Cell[26467, 986, 305, 11, 70, "MathCaption",
  CellTags->{"S3.3.2", "2.10"}],

Cell[CellGroupData[{
Cell[26797, 1001, 84, 2, 70, "Input",
  CellTags->"S3.3.2"],
Cell[26884, 1005, 96, 3, 70, "Output",
  CellTags->"S3.3.2"]
}, Open  ]],
Cell[26995, 1011, 437, 15, 70, "MathCaption",
  CellTags->{"S3.3.2", "2.11"}],

Cell[CellGroupData[{
Cell[27457, 1030, 100, 2, 70, "Input",
  CellTags->"S3.3.2"],
Cell[27560, 1034, 97, 3, 70, "Output",
  CellTags->"S3.3.2"]
}, Open  ]],
Cell[27672, 1040, 213, 5, 70, "MathCaption",
  CellTags->{"S3.3.2", "2.12"}],

Cell[CellGroupData[{
Cell[27910, 1049, 91, 2, 70, "Input",
  CellTags->"S3.3.2"],
Cell[28004, 1053, 177, 4, 70, "Output",
  CellTags->"S3.3.2"]
}, Open  ]],
Cell[28196, 1060, 199, 5, 70, "Text",
  CellTags->{"S3.3.2", "2.13"}],
Cell[28398, 1067, 140, 4, 70, "Text",
  CellTags->{"S3.3.2", "2.14"}],
Cell[28541, 1073, 269, 9, 70, "MathCaption",
  CellTags->{"S3.3.2", "2.15"}],

Cell[CellGroupData[{
Cell[28835, 1086, 80, 2, 70, "Input",
  CellTags->"S3.3.2"],
Cell[28918, 1090, 100, 3, 70, "Output",
  CellTags->"S3.3.2"]
}, Open  ]],
Cell[29033, 1096, 337, 12, 70, "MathCaption",
  CellTags->{"S3.3.2", "2.16"}],

Cell[CellGroupData[{
Cell[29395, 1112, 79, 2, 70, "Input",
  CellTags->"S3.3.2"],
Cell[29477, 1116, 94, 3, 70, "Output",
  CellTags->"S3.3.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[29620, 1125, 104, 1, 70, "Subsection",
  CellTags->{"S3.3.3", "3.1"}],
Cell[29727, 1128, 273, 8, 70, "Text",
  CellTags->{"S3.3.3", "3.2"}],
Cell[30003, 1138, 1141, 31, 70, "DefinitionBox",
  CellTags->"S3.3.3"],
Cell[31147, 1171, 96, 1, 70, "Caption",
  CellTags->"S3.3.3"],
Cell[31246, 1174, 85, 1, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.3"}],

Cell[CellGroupData[{
Cell[31356, 1179, 119, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[31478, 1183, 155, 4, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[31648, 1190, 160, 4, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.4"}],

Cell[CellGroupData[{
Cell[31833, 1198, 82, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[31918, 1202, 168, 5, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[32101, 1210, 196, 5, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.5"}],

Cell[CellGroupData[{
Cell[32322, 1219, 73, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[32398, 1223, 188, 4, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[32601, 1230, 152, 4, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.6"}],

Cell[CellGroupData[{
Cell[32778, 1238, 84, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[32865, 1242, 160, 4, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[33040, 1249, 180, 5, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.7"}],

Cell[CellGroupData[{
Cell[33245, 1258, 76, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[33324, 1262, 193, 4, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[33532, 1269, 625, 18, 70, "DefinitionBox",
  CellTags->"S3.3.3"],
Cell[34160, 1289, 64, 1, 70, "Caption",
  CellTags->"S3.3.3"],
Cell[34227, 1292, 155, 5, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.8"}],

Cell[CellGroupData[{
Cell[34407, 1301, 107, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[34517, 1305, 122, 3, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[34654, 1311, 1183, 35, 70, "DefinitionBox",
  CellTags->"S3.3.3"],
Cell[35840, 1348, 88, 1, 70, "Caption",
  CellTags->"S3.3.3"],
Cell[35931, 1351, 85, 1, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.9"}],

Cell[CellGroupData[{
Cell[36041, 1356, 119, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[36163, 1360, 168, 4, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[36346, 1367, 144, 4, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.10"}],

Cell[CellGroupData[{
Cell[36515, 1375, 75, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[36593, 1379, 144, 4, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[36752, 1386, 187, 5, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.11"}],

Cell[CellGroupData[{
Cell[36964, 1395, 73, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[37040, 1399, 154, 4, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[37209, 1406, 201, 5, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.12"}],

Cell[CellGroupData[{
Cell[37435, 1415, 73, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[37511, 1419, 118, 3, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[37644, 1425, 164, 4, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.13"}],

Cell[CellGroupData[{
Cell[37833, 1433, 74, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[37910, 1437, 135, 3, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[38060, 1443, 175, 5, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.14"}],

Cell[CellGroupData[{
Cell[38260, 1452, 74, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[38337, 1456, 155, 4, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[38507, 1463, 227, 6, 70, "Text",
  CellTags->{"S3.3.3", "3.15"}],
Cell[38737, 1471, 331, 11, 70, "Text",
  CellTags->{"S3.3.3", "3.16"}],
Cell[39071, 1484, 103, 1, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.17"}],

Cell[CellGroupData[{
Cell[39199, 1489, 88, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[39290, 1493, 111, 3, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[39416, 1499, 164, 5, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.18"}],

Cell[CellGroupData[{
Cell[39605, 1508, 76, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[39684, 1512, 121, 3, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]],
Cell[39820, 1518, 161, 5, 70, "MathCaption",
  CellTags->{"S3.3.3", "3.19"}],

Cell[CellGroupData[{
Cell[40006, 1527, 76, 2, 70, "Input",
  CellTags->"S3.3.3"],
Cell[40085, 1531, 137, 3, 70, "Output",
  CellTags->"S3.3.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40271, 1540, 94, 1, 70, "Subsection",
  CellTags->{"S3.3.4", "4.1"}],
Cell[40368, 1543, 234, 5, 70, "Text",
  CellTags->{"S3.3.4", "4.2"}],
Cell[40605, 1550, 192, 5, 70, "Text",
  CellTags->{"S3.3.4", "4.3"}],
Cell[40800, 1557, 247, 5, 70, "Text",
  CellTags->{"S3.3.4", "4.4"}],
Cell[41050, 1564, 11642, 325, 70, "DefinitionBox",
  CellTags->"S3.3.4"],
Cell[52695, 1891, 67, 1, 70, "Caption",
  CellTags->"S3.3.4"],
Cell[52765, 1894, 2543, 96, 70, "Text",
  CellTags->{"S3.3.4", "4.5"}],
Cell[55311, 1992, 408, 15, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.6"}],

Cell[CellGroupData[{
Cell[55744, 2011, 96, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[55843, 2015, 82, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[55940, 2021, 422, 15, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.7"}],

Cell[CellGroupData[{
Cell[56387, 2040, 95, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[56485, 2044, 91, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[56591, 2050, 95, 1, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.8"}],

Cell[CellGroupData[{
Cell[56711, 2055, 88, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[56802, 2059, 85, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[56902, 2065, 211, 8, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.9"}],

Cell[CellGroupData[{
Cell[57138, 2077, 142, 5, 70, "Input",
  CellTags->"S3.3.4"],
Cell[57283, 2084, 93, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[57391, 2090, 782, 27, 70, "Text",
  CellTags->{"S3.3.4", "4.10"}],
Cell[58176, 2119, 165, 4, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.11"}],

Cell[CellGroupData[{
Cell[58366, 2127, 119, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[58488, 2131, 110, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[58613, 2137, 1260, 45, 70, "Text",
  CellTags->{"S3.3.4", "4.12"}],
Cell[59876, 2184, 453, 15, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.13"}],

Cell[CellGroupData[{
Cell[60354, 2203, 87, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[60444, 2207, 82, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[60541, 2213, 208, 7, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.14"}],

Cell[CellGroupData[{
Cell[60774, 2224, 141, 5, 70, "Input",
  CellTags->"S3.3.4"],
Cell[60918, 2231, 96, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[61029, 2237, 498, 11, 70, "Text",
  CellTags->{"S3.3.4", "4.15"}],
Cell[61530, 2250, 518, 19, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.16"}],

Cell[CellGroupData[{
Cell[62073, 2273, 98, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[62174, 2277, 82, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[62271, 2283, 2311, 79, 70, "Text",
  CellTags->{"S3.3.4", "4.17"}],
Cell[64585, 2364, 805, 28, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.18"}],

Cell[CellGroupData[{
Cell[65415, 2396, 94, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[65512, 2400, 100, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[65627, 2406, 1347, 47, 70, "Text",
  CellTags->{"S3.3.4", "4.19"}],
Cell[66977, 2455, 427, 14, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.20"}],

Cell[CellGroupData[{
Cell[67429, 2473, 104, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[67536, 2477, 89, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[67640, 2483, 192, 6, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.21"}],

Cell[CellGroupData[{
Cell[67857, 2493, 106, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[67966, 2497, 85, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[68066, 2503, 166, 4, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.22"}],

Cell[CellGroupData[{
Cell[68257, 2511, 118, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[68378, 2515, 149, 4, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[68542, 2522, 2327, 104, 70, "Text",
  CellTags->{"S3.3.4", "4.23"}],
Cell[70872, 2628, 886, 34, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.24"}],

Cell[CellGroupData[{
Cell[71783, 2666, 116, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[71902, 2670, 118, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[72035, 2676, 1635, 49, 70, "DefinitionBox",
  CellTags->"S3.3.4"],
Cell[73673, 2727, 78, 1, 70, "Caption",
  CellTags->"S3.3.4"],
Cell[73754, 2730, 528, 15, 70, "Text",
  CellTags->{"S3.3.4", "4.25"}],
Cell[74285, 2747, 95, 1, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.26"}],

Cell[CellGroupData[{
Cell[74405, 2752, 106, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[74514, 2756, 124, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[74653, 2762, 219, 8, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.27"}],

Cell[CellGroupData[{
Cell[74897, 2774, 82, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[74982, 2778, 128, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[75125, 2784, 296, 12, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.28"}],

Cell[CellGroupData[{
Cell[75446, 2800, 84, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[75533, 2804, 122, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[75670, 2810, 151, 4, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.29"}],

Cell[CellGroupData[{
Cell[75846, 2818, 74, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[75923, 2822, 125, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[76063, 2828, 447, 9, 70, "Text",
  CellTags->{"S3.3.4", "4.30"}],
Cell[76513, 2839, 235, 7, 70, "Text",
  CellTags->{"S3.3.4", "4.31"}],
Cell[76751, 2848, 219, 5, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.32"}],

Cell[CellGroupData[{
Cell[76995, 2857, 78, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[77076, 2861, 126, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[77217, 2867, 666, 22, 70, "DefinitionBox",
  CellTags->"S3.3.4"],
Cell[77886, 2891, 90, 1, 70, "Caption",
  CellTags->"S3.3.4"],
Cell[77979, 2894, 567, 15, 70, "Text",
  CellTags->{"S3.3.4", "4.33"}],
Cell[78549, 2911, 137, 4, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.34"}],

Cell[CellGroupData[{
Cell[78711, 2919, 80, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[78794, 2923, 90, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[78899, 2929, 137, 4, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.35"}],

Cell[CellGroupData[{
Cell[79061, 2937, 106, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[79170, 2941, 135, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[79320, 2947, 672, 21, 70, "DefinitionBox",
  CellTags->"S3.3.4"],
Cell[79995, 2970, 65, 1, 70, "Caption",
  CellTags->"S3.3.4"],
Cell[80063, 2973, 1515, 50, 70, "Text",
  CellTags->{"S3.3.4", "4.36"}],
Cell[81581, 3025, 356, 13, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.37"}],

Cell[CellGroupData[{
Cell[81962, 3042, 81, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[82046, 3046, 94, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[82155, 3052, 525, 19, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.38"}],

Cell[CellGroupData[{
Cell[82705, 3075, 80, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[82788, 3079, 162, 4, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[82965, 3086, 673, 21, 70, "DefinitionBox",
  CellTags->"S3.3.4"],
Cell[83641, 3109, 66, 1, 70, "Caption",
  CellTags->"S3.3.4"],
Cell[83710, 3112, 2065, 72, 70, "Text",
  CellTags->{"S3.3.4", "4.39"}],
Cell[85778, 3186, 1088, 38, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.40"}],

Cell[CellGroupData[{
Cell[86891, 3228, 92, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[86986, 3232, 102, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[87103, 3238, 90, 1, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.41"}],
Cell[87196, 3241, 112, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[87311, 3245, 104, 1, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.42"}],

Cell[CellGroupData[{
Cell[87440, 3250, 88, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[87531, 3254, 164, 4, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[87710, 3261, 136, 4, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.43"}],

Cell[CellGroupData[{
Cell[87871, 3269, 80, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[87954, 3273, 112, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[88081, 3279, 583, 18, 70, "Text",
  CellTags->{"S3.3.4", "4.44"}],
Cell[88667, 3299, 2492, 89, 70, "Text",
  CellTags->{"S3.3.4", "4.45"}],
Cell[91162, 3390, 3669, 107, 70, "DefinitionBox",
  CellTags->"S3.3.4"],
Cell[94834, 3499, 79, 1, 70, "Caption",
  CellTags->"S3.3.4"],
Cell[94916, 3502, 147, 4, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.46"}],

Cell[CellGroupData[{
Cell[95088, 3510, 118, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[95209, 3514, 118, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]],
Cell[95342, 3520, 214, 9, 70, "MathCaption",
  CellTags->{"S3.3.4", "4.47"}],

Cell[CellGroupData[{
Cell[95581, 3533, 76, 2, 70, "Input",
  CellTags->"S3.3.4"],
Cell[95660, 3537, 83, 3, 70, "Output",
  CellTags->"S3.3.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[95792, 3546, 84, 1, 70, "Subsection",
  CellTags->{"S3.3.5", "5.1"}],
Cell[95879, 3549, 497, 17, 70, "Text",
  CellTags->{"S3.3.5", "5.2"}],
Cell[96379, 3568, 3590, 113, 70, "DefinitionBox",
  CellTags->"S3.3.5"],
Cell[99972, 3683, 100, 1, 70, "Caption",
  CellTags->"S3.3.5"],
Cell[100075, 3686, 86, 1, 70, "MathCaption",
  CellTags->{"S3.3.5", "5.3"}],

Cell[CellGroupData[{
Cell[100186, 3691, 83, 2, 70, "Input",
  CellTags->"S3.3.5"],
Cell[100272, 3695, 141, 4, 70, "Output",
  CellTags->"S3.3.5"]
}, Open  ]],
Cell[100428, 3702, 94, 1, 70, "MathCaption",
  CellTags->{"S3.3.5", "5.4"}],

Cell[CellGroupData[{
Cell[100547, 3707, 83, 2, 70, "Input",
  CellTags->"S3.3.5"],
Cell[100633, 3711, 103, 3, 70, "Output",
  CellTags->"S3.3.5"]
}, Open  ]],
Cell[100751, 3717, 132, 4, 70, "MathCaption",
  CellTags->{"S3.3.5", "5.5"}],

Cell[CellGroupData[{
Cell[100908, 3725, 73, 2, 70, "Input",
  CellTags->"S3.3.5"],
Cell[100984, 3729, 111, 3, 70, "Output",
  CellTags->"S3.3.5"]
}, Open  ]],
Cell[101110, 3735, 114, 2, 70, "MathCaption",
  CellTags->{"S3.3.5", "5.6"}],

Cell[CellGroupData[{
Cell[101249, 3741, 85, 2, 70, "Input",
  CellTags->"S3.3.5"],
Cell[101337, 3745, 95, 3, 70, "Output",
  CellTags->"S3.3.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[101481, 3754, 125, 4, 70, "Subsection",
  CellTags->{"S3.3.6", "6.1"}],
Cell[101609, 3760, 348, 8, 70, "Text",
  CellTags->{"S3.3.6", "6.2"}],
Cell[101960, 3770, 1506, 44, 70, "DefinitionBox",
  CellTags->"S3.3.6"],
Cell[103469, 3816, 93, 1, 70, "Caption",
  CellTags->"S3.3.6"],
Cell[103565, 3819, 144, 4, 70, "MathCaption",
  CellTags->{"S3.3.6", "6.3"}],

Cell[CellGroupData[{
Cell[103734, 3827, 79, 2, 70, "Input",
  CellTags->"S3.3.6"],
Cell[103816, 3831, 89, 3, 70, "Output",
  CellTags->"S3.3.6"]
}, Open  ]],
Cell[103920, 3837, 216, 6, 70, "MathCaption",
  CellTags->{"S3.3.6", "6.4"}],

Cell[CellGroupData[{
Cell[104161, 3847, 103, 2, 70, "Input",
  CellTags->"S3.3.6"],
Cell[104267, 3851, 141, 4, 70, "Output",
  CellTags->"S3.3.6"]
}, Open  ]],
Cell[104423, 3858, 225, 7, 70, "MathCaption",
  CellTags->{"S3.3.6", "6.5"}],

Cell[CellGroupData[{
Cell[104673, 3869, 104, 2, 70, "Input",
  CellTags->"S3.3.6"],
Cell[104780, 3873, 142, 4, 70, "Output",
  CellTags->"S3.3.6"]
}, Open  ]],
Cell[104937, 3880, 181, 6, 70, "MathCaption",
  CellTags->{"S3.3.6", "6.6"}],

Cell[CellGroupData[{
Cell[105143, 3890, 105, 2, 70, "Input",
  CellTags->"S3.3.6"],
Cell[105251, 3894, 142, 4, 70, "Output",
  CellTags->"S3.3.6"]
}, Open  ]],
Cell[105408, 3901, 315, 9, 70, "MathCaption",
  CellTags->{"S3.3.6", "6.7"}],

Cell[CellGroupData[{
Cell[105748, 3914, 113, 2, 70, "Input",
  CellTags->"S3.3.6"],
Cell[105864, 3918, 249, 5, 70, "Output",
  CellTags->"S3.3.6"]
}, Open  ]],
Cell[106128, 3926, 141, 4, 70, "MathCaption",
  CellTags->{"S3.3.6", "6.8"}],

Cell[CellGroupData[{
Cell[106294, 3934, 73, 2, 70, "Input",
  CellTags->"S3.3.6"],
Cell[106370, 3938, 89, 3, 70, "Output",
  CellTags->"S3.3.6"]
}, Open  ]],
Cell[106474, 3944, 682, 20, 70, "DefinitionBox",
  CellTags->"S3.3.6"],
Cell[107159, 3966, 99, 1, 70, "Caption",
  CellTags->"S3.3.6"],
Cell[107261, 3969, 195, 6, 70, "MathCaption",
  CellTags->{"S3.3.6", "6.9"}],

Cell[CellGroupData[{
Cell[107481, 3979, 91, 2, 70, "Input",
  CellTags->"S3.3.6"],
Cell[107575, 3983, 101, 3, 70, "Output",
  CellTags->"S3.3.6"]
}, Open  ]],
Cell[107691, 3989, 151, 5, 70, "MathCaption",
  CellTags->{"S3.3.6", "6.10"}],

Cell[CellGroupData[{
Cell[107867, 3998, 73, 2, 70, "Input",
  CellTags->"S3.3.6"],
Cell[107943, 4002, 101, 3, 70, "Output",
  CellTags->"S3.3.6"]
}, Open  ]],
Cell[108059, 4008, 237, 6, 70, "MathCaption",
  CellTags->{"S3.3.6", "6.11"}],

Cell[CellGroupData[{
Cell[108321, 4018, 97, 2, 70, "Input",
  CellTags->"S3.3.6"],
Cell[108421, 4022, 97, 3, 70, "Output",
  CellTags->"S3.3.6"]
}, Open  ]],
Cell[108533, 4028, 355, 8, 70, "Text",
  CellTags->{"S3.3.6", "6.12"}],
Cell[108891, 4038, 155, 5, 70, "MathCaption",
  CellTags->{"S3.3.6", "6.13"}],

Cell[CellGroupData[{
Cell[109071, 4047, 86, 2, 70, "Input",
  CellTags->"S3.3.6"],
Cell[109160, 4051, 125, 3, 70, "Output",
  CellTags->"S3.3.6"]
}, Open  ]],
Cell[109300, 4057, 72, 1, 70, "MathCaption",
  CellTags->{"S3.3.6", "6.14"}],

Cell[CellGroupData[{
Cell[109397, 4062, 108, 2, 70, "Input",
  CellTags->"S3.3.6"],
Cell[109508, 4066, 111, 3, 70, "Output",
  CellTags->"S3.3.6"]
}, Open  ]],
Cell[109634, 4072, 155, 5, 70, "MathCaption",
  CellTags->{"S3.3.6", "6.15"}],

Cell[CellGroupData[{
Cell[109814, 4081, 90, 2, 70, "Input",
  CellTags->"S3.3.6"],
Cell[109907, 4085, 129, 3, 70, "Output",
  CellTags->"S3.3.6"]
}, Open  ]],
Cell[110051, 4091, 72, 1, 70, "MathCaption",
  CellTags->{"S3.3.6", "6.16"}],

Cell[CellGroupData[{
Cell[110148, 4096, 112, 2, 70, "Input",
  CellTags->"S3.3.6"],
Cell[110263, 4100, 119, 3, 70, "Output",
  CellTags->"S3.3.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[110431, 4109, 84, 1, 70, "Subsection",
  CellTags->{"S3.3.7", "7.1"}],
Cell[110518, 4112, 1220, 33, 70, "DefinitionBox",
  CellTags->"S3.3.7"],
Cell[111741, 4147, 95, 1, 70, "Caption",
  CellTags->"S3.3.7"],
Cell[111839, 4150, 99, 1, 70, "MathCaption",
  CellTags->{"S3.3.7", "7.2"}],

Cell[CellGroupData[{
Cell[111963, 4155, 93, 2, 70, "Input",
  CellTags->"S3.3.7"],
Cell[112059, 4159, 142, 4, 70, "Output",
  CellTags->"S3.3.7"]
}, Open  ]],
Cell[112216, 4166, 83, 1, 70, "MathCaption",
  CellTags->{"S3.3.7", "7.3"}],

Cell[CellGroupData[{
Cell[112324, 4171, 77, 2, 70, "Input",
  CellTags->"S3.3.7"],
Cell[112404, 4175, 153, 4, 70, "Output",
  CellTags->"S3.3.7"]
}, Open  ]],
Cell[112572, 4182, 145, 4, 70, "MathCaption",
  CellTags->{"S3.3.7", "7.4"}],

Cell[CellGroupData[{
Cell[112742, 4190, 77, 2, 70, "Input",
  CellTags->"S3.3.7"],
Cell[112822, 4194, 128, 3, 70, "Output",
  CellTags->"S3.3.7"]
}, Open  ]],
Cell[112965, 4200, 154, 4, 70, "MathCaption",
  CellTags->{"S3.3.7", "7.5"}],

Cell[CellGroupData[{
Cell[113144, 4208, 87, 2, 70, "Input",
  CellTags->"S3.3.7"],
Cell[113234, 4212, 208, 4, 70, "Output",
  CellTags->"S3.3.7"]
}, Open  ]],
Cell[113457, 4219, 139, 4, 70, "MathCaption",
  CellTags->{"S3.3.7", "7.6"}],

Cell[CellGroupData[{
Cell[113621, 4227, 77, 2, 70, "Input",
  CellTags->"S3.3.7"],
Cell[113701, 4231, 92, 3, 70, "Output",
  CellTags->"S3.3.7"]
}, Open  ]],
Cell[113808, 4237, 187, 6, 70, "MathCaption",
  CellTags->{"S3.3.7", "7.7"}],

Cell[CellGroupData[{
Cell[114020, 4247, 79, 2, 70, "Input",
  CellTags->"S3.3.7"],
Cell[114102, 4251, 95, 3, 70, "Output",
  CellTags->"S3.3.7"]
}, Open  ]],
Cell[114212, 4257, 201, 7, 70, "MathCaption",
  CellTags->{"S3.3.7", "7.8"}],

Cell[CellGroupData[{
Cell[114438, 4268, 81, 2, 70, "Input",
  CellTags->"S3.3.7"],
Cell[114522, 4272, 120, 3, 70, "Output",
  CellTags->"S3.3.7"]
}, Open  ]],
Cell[114657, 4278, 720, 20, 70, "DefinitionBox",
  CellTags->"S3.3.7"],
Cell[115380, 4300, 78, 1, 70, "Caption",
  CellTags->"S3.3.7"],
Cell[115461, 4303, 159, 4, 70, "MathCaption",
  CellTags->{"S3.3.7", "7.9"}],

Cell[CellGroupData[{
Cell[115645, 4311, 81, 2, 70, "Input",
  CellTags->"S3.3.7"],
Cell[115729, 4315, 280, 5, 70, "Output",
  CellTags->"S3.3.7"]
}, Open  ]],
Cell[116024, 4323, 182, 5, 70, "MathCaption",
  CellTags->{"S3.3.7", "7.10"}],

Cell[CellGroupData[{
Cell[116231, 4332, 76, 2, 70, "Input",
  CellTags->"S3.3.7"],
Cell[116310, 4336, 87, 3, 70, "Output",
  CellTags->"S3.3.7"]
}, Open  ]],
Cell[116412, 4342, 156, 4, 70, "MathCaption",
  CellTags->{"S3.3.7", "7.11"}],

Cell[CellGroupData[{
Cell[116593, 4350, 92, 2, 70, "Input",
  CellTags->"S3.3.7"],
Cell[116688, 4354, 92, 3, 70, "Output",
  CellTags->"S3.3.7"]
}, Open  ]],
Cell[116795, 4360, 159, 5, 70, "MathCaption",
  CellTags->{"S3.3.7", "7.12"}],

Cell[CellGroupData[{
Cell[116979, 4369, 87, 2, 70, "Input",
  CellTags->"S3.3.7"],
Cell[117069, 4373, 128, 3, 70, "Output",
  CellTags->"S3.3.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[117246, 4382, 98, 1, 70, "Subsection",
  CellTags->{"S3.3.8", "8.1"}],
Cell[117347, 4385, 368, 8, 70, "Text",
  CellTags->{"S3.3.8", "8.2"}],
Cell[117718, 4395, 234, 6, 70, "Text",
  CellTags->{"S3.3.8", "8.3"}],
Cell[117955, 4403, 1792, 53, 70, "DefinitionBox",
  CellTags->"S3.3.8"],
Cell[119750, 4458, 72, 1, 70, "Caption",
  CellTags->"S3.3.8"],
Cell[119825, 4461, 192, 7, 70, "MathCaption",
  CellTags->{"S3.3.8", "8.4"}],

Cell[CellGroupData[{
Cell[120042, 4472, 91, 2, 70, "Input",
  CellTags->"S3.3.8"],
Cell[120136, 4476, 180, 4, 70, "Output",
  CellTags->"S3.3.8"]
}, Open  ]],
Cell[120331, 4483, 253, 8, 70, "MathCaption",
  CellTags->{"S3.3.8", "8.5"}],

Cell[CellGroupData[{
Cell[120609, 4495, 91, 2, 70, "Input",
  CellTags->"S3.3.8"],
Cell[120703, 4499, 137, 3, 70, "Output",
  CellTags->"S3.3.8"]
}, Open  ]],
Cell[120855, 4505, 139, 4, 70, "MathCaption",
  CellTags->{"S3.3.8", "8.6"}],

Cell[CellGroupData[{
Cell[121019, 4513, 100, 2, 70, "Input",
  CellTags->"S3.3.8"],
Cell[121122, 4517, 403, 7, 70, "Output",
  CellTags->"S3.3.8"]
}, Open  ]],
Cell[121540, 4527, 825, 31, 70, "Text",
  CellTags->{"S3.3.8", "8.7"}],
Cell[122368, 4560, 893, 32, 70, "Text",
  CellTags->{"S3.3.8", "8.8"}],
Cell[123264, 4594, 97, 1, 70, "MathCaption",
  CellTags->{"S3.3.8", "8.9"}],

Cell[CellGroupData[{
Cell[123386, 4599, 91, 2, 70, "Input",
  CellTags->"S3.3.8"],
Cell[123480, 4603, 105, 3, 70, "Output",
  CellTags->"S3.3.8"]
}, Open  ]],
Cell[123600, 4609, 91, 1, 70, "MathCaption",
  CellTags->{"S3.3.8", "8.10"}],

Cell[CellGroupData[{
Cell[123716, 4614, 122, 2, 70, "Input",
  CellTags->"S3.3.8"],
Cell[123841, 4618, 134, 3, 70, "Output",
  CellTags->"S3.3.8"]
}, Open  ]],
Cell[123990, 4624, 90, 1, 70, "MathCaption",
  CellTags->{"S3.3.8", "8.11"}],

Cell[CellGroupData[{
Cell[124105, 4629, 121, 2, 70, "Input",
  CellTags->"S3.3.8"],
Cell[124229, 4633, 109, 3, 70, "Output",
  CellTags->"S3.3.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[124387, 4642, 106, 1, 70, "Subsection",
  CellTags->{"S3.3.9", "9.1"}],
Cell[124496, 4645, 276, 8, 70, "Text",
  CellTags->{"S3.3.9", "9.2"}],
Cell[124775, 4655, 1185, 35, 70, "DefinitionBox",
  CellTags->"S3.3.9"],
Cell[125963, 4692, 88, 1, 70, "Caption",
  CellTags->"S3.3.9"],
Cell[126054, 4695, 231, 6, 70, "Text",
  CellTags->{"S3.3.9", "9.3"}],
Cell[126288, 4703, 156, 5, 70, "MathCaption",
  CellTags->{"S3.3.9", "9.4"}],

Cell[CellGroupData[{
Cell[126469, 4712, 77, 2, 70, "Input",
  CellTags->"S3.3.9"],
Cell[126549, 4716, 98, 3, 70, "Output",
  CellTags->"S3.3.9"]
}, Open  ]],
Cell[126662, 4722, 139, 4, 70, "MathCaption",
  CellTags->{"S3.3.9", "9.5"}],

Cell[CellGroupData[{
Cell[126826, 4730, 80, 2, 70, "Input",
  CellTags->"S3.3.9"],
Cell[126909, 4734, 109, 3, 70, "Output",
  CellTags->"S3.3.9"]
}, Open  ]],
Cell[127033, 4740, 239, 5, 70, "Text",
  CellTags->{"S3.3.9", "9.6"}],
Cell[127275, 4747, 131, 4, 70, "MathCaption",
  CellTags->{"S3.3.9", "9.7"}],

Cell[CellGroupData[{
Cell[127431, 4755, 91, 2, 70, "Input",
  CellTags->"S3.3.9"],
Cell[127525, 4759, 210, 5, 70, "Output",
  CellTags->"S3.3.9"]
}, Open  ]],
Cell[127750, 4767, 373, 12, 70, "Text",
  CellTags->{"S3.3.9", "9.8"}],
Cell[128126, 4781, 156, 5, 70, "MathCaption",
  CellTags->{"S3.3.9", "9.9"}],

Cell[CellGroupData[{
Cell[128307, 4790, 93, 2, 70, "Input",
  CellTags->"S3.3.9"],
Cell[128403, 4794, 110, 3, 70, "Output",
  CellTags->"S3.3.9"]
}, Open  ]],
Cell[128528, 4800, 181, 6, 70, "MathCaption",
  CellTags->{"S3.3.9", "9.10"}],

Cell[CellGroupData[{
Cell[128734, 4810, 82, 2, 70, "Input",
  CellTags->"S3.3.9"],
Cell[128819, 4814, 411, 13, 70, "Output",
  CellTags->"S3.3.9"]
}, Open  ]],
Cell[129245, 4830, 423, 16, 70, "Text",
  CellTags->{"S3.3.9", "9.11"}],
Cell[129671, 4848, 149, 5, 70, "MathCaption",
  CellTags->{"S3.3.9", "9.12"}],

Cell[CellGroupData[{
Cell[129845, 4857, 98, 2, 70, "Input",
  CellTags->"S3.3.9"],
Cell[129946, 4861, 438, 13, 70, "Output",
  CellTags->"S3.3.9"]
}, Open  ]],
Cell[130399, 4877, 196, 7, 70, "MathCaption",
  CellTags->{"S3.3.9", "9.13"}],

Cell[CellGroupData[{
Cell[130620, 4888, 108, 2, 70, "Input",
  CellTags->"S3.3.9"],
Cell[130731, 4892, 368, 12, 70, "Output",
  CellTags->"S3.3.9"]
}, Open  ]],
Cell[131114, 4907, 342, 12, 70, "Text",
  CellTags->{"S3.3.9", "9.14"}],
Cell[131459, 4921, 167, 5, 70, "MathCaption",
  CellTags->{"S3.3.9", "9.15"}],

Cell[CellGroupData[{
Cell[131651, 4930, 102, 2, 70, "Input",
  CellTags->"S3.3.9"],
Cell[131756, 4934, 323, 9, 70, "Output",
  CellTags->"S3.3.9"]
}, Open  ]],
Cell[132094, 4946, 433, 12, 70, "Text",
  CellTags->{"S3.3.9", "9.16"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[132564, 4963, 76, 1, 70, "Subsection",
  CellTags->{"S3.3.10", "10.1"}],
Cell[132643, 4966, 734, 22, 70, "DefinitionBox",
  CellTags->"S3.3.10"],
Cell[133380, 4990, 67, 1, 70, "Caption",
  CellTags->"S3.3.10"],
Cell[133450, 4993, 173, 4, 70, "MathCaption",
  CellTags->{"S3.3.10", "10.2"}],

Cell[CellGroupData[{
Cell[133648, 5001, 82, 2, 70, "Input",
  CellTags->"S3.3.10"],
Cell[133733, 5005, 105, 3, 70, "Output",
  CellTags->"S3.3.10"]
}, Open  ]],
Cell[133853, 5011, 132, 4, 70, "MathCaption",
  CellTags->{"S3.3.10", "10.3"}],

Cell[CellGroupData[{
Cell[134010, 5019, 76, 2, 70, "Input",
  CellTags->"S3.3.10"],
Cell[134089, 5023, 94, 3, 70, "Output",
  CellTags->"S3.3.10"]
}, Open  ]],
Cell[134198, 5029, 166, 4, 70, "MathCaption",
  CellTags->{"S3.3.10", "10.4"}],

Cell[CellGroupData[{
Cell[134389, 5037, 94, 2, 70, "Input",
  CellTags->"S3.3.10"],
Cell[134486, 5041, 83, 3, 70, "Output",
  CellTags->"S3.3.10"]
}, Open  ]],
Cell[134584, 5047, 172, 4, 70, "MathCaption",
  CellTags->{"S3.3.10", "10.5"}],

Cell[CellGroupData[{
Cell[134781, 5055, 87, 2, 70, "Input",
  CellTags->"S3.3.10"],
Cell[134871, 5059, 97, 3, 70, "Output",
  CellTags->"S3.3.10"]
}, Open  ]],
Cell[134983, 5065, 142, 4, 70, "MathCaption",
  CellTags->{"S3.3.10", "10.6"}],

Cell[CellGroupData[{
Cell[135150, 5073, 80, 2, 70, "Input",
  CellTags->"S3.3.10"],
Cell[135233, 5077, 90, 3, 70, "Output",
  CellTags->"S3.3.10"]
}, Open  ]],
Cell[135338, 5083, 831, 25, 70, "DefinitionBox",
  CellTags->"S3.3.10"],
Cell[136172, 5110, 70, 1, 70, "Caption",
  CellTags->"S3.3.10"],
Cell[136245, 5113, 140, 4, 70, "MathCaption",
  CellTags->{"S3.3.10", "10.7"}],

Cell[CellGroupData[{
Cell[136410, 5121, 114, 2, 70, "Input",
  CellTags->"S3.3.10"],
Cell[136527, 5125, 133, 3, 70, "Output",
  CellTags->"S3.3.10"]
}, Open  ]],
Cell[136675, 5131, 158, 5, 70, "MathCaption",
  CellTags->{"S3.3.10", "10.8"}],

Cell[CellGroupData[{
Cell[136858, 5140, 80, 2, 70, "Input",
  CellTags->"S3.3.10"],
Cell[136941, 5144, 115, 3, 70, "Output",
  CellTags->"S3.3.10"]
}, Open  ]],
Cell[137071, 5150, 160, 5, 70, "MathCaption",
  CellTags->{"S3.3.10", "10.9"}],

Cell[CellGroupData[{
Cell[137256, 5159, 104, 2, 70, "Input",
  CellTags->"S3.3.10"],
Cell[137363, 5163, 123, 3, 70, "Output",
  CellTags->"S3.3.10"]
}, Open  ]],
Cell[137501, 5169, 4300, 125, 70, "DefinitionBox",
  CellTags->"S3.3.10"],
Cell[141804, 5296, 77, 1, 70, "Caption",
  CellTags->"S3.3.10"],
Cell[141884, 5299, 619, 17, 70, "Text",
  CellTags->{"S3.3.10", "10.10"}],
Cell[142506, 5318, 176, 5, 70, "MathCaption",
  CellTags->{"S3.3.10", "10.11"}],

Cell[CellGroupData[{
Cell[142707, 5327, 84, 2, 70, "Input",
  CellTags->"S3.3.10"],
Cell[142794, 5331, 92, 3, 70, "Output",
  CellTags->"S3.3.10"]
}, Open  ]],
Cell[142901, 5337, 136, 4, 70, "MathCaption",
  CellTags->{"S3.3.10", "10.12"}],

Cell[CellGroupData[{
Cell[143062, 5345, 118, 2, 70, "Input",
  CellTags->"S3.3.10"],
Cell[143183, 5349, 93, 3, 70, "Output",
  CellTags->"S3.3.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[143325, 5358, 79, 1, 70, "Subsection",
  CellTags->{"S3.3.11", "11.1"}],
Cell[143407, 5361, 372, 7, 70, "Text",
  CellTags->{"S3.3.11", "11.2"}],
Cell[143782, 5370, 1553, 46, 70, "DefinitionBox",
  CellTags->"S3.3.11"],
Cell[145338, 5418, 77, 1, 70, "Caption",
  CellTags->"S3.3.11"],
Cell[145418, 5421, 161, 4, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.3"}],

Cell[CellGroupData[{
Cell[145604, 5429, 96, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[145703, 5433, 106, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[145824, 5439, 262, 9, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.4"}],

Cell[CellGroupData[{
Cell[146111, 5452, 96, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[146210, 5456, 177, 4, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[146402, 5463, 321, 11, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.5"}],

Cell[CellGroupData[{
Cell[146748, 5478, 103, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[146854, 5482, 83, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[146952, 5488, 359, 13, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.6"}],

Cell[CellGroupData[{
Cell[147336, 5505, 89, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[147428, 5509, 91, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[147534, 5515, 359, 13, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.7"}],

Cell[CellGroupData[{
Cell[147918, 5532, 105, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[148026, 5536, 97, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[148138, 5542, 275, 8, 70, "Text",
  CellTags->{"S3.3.11", "11.8"}],
Cell[148416, 5552, 279, 8, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.9"}],

Cell[CellGroupData[{
Cell[148720, 5564, 86, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[148809, 5568, 99, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[148923, 5574, 151, 5, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.10"}],

Cell[CellGroupData[{
Cell[149099, 5583, 93, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[149195, 5587, 86, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[149296, 5593, 163, 4, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.11"}],

Cell[CellGroupData[{
Cell[149484, 5601, 115, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[149602, 5605, 86, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[149703, 5611, 396, 13, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.12"}],

Cell[CellGroupData[{
Cell[150124, 5628, 100, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[150227, 5632, 86, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[150328, 5638, 841, 25, 70, "Text",
  CellTags->{"S3.3.11", "11.13"}],
Cell[151172, 5665, 150, 5, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.14"}],

Cell[CellGroupData[{
Cell[151347, 5674, 89, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[151439, 5678, 89, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[151543, 5684, 246, 8, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.15"}],

Cell[CellGroupData[{
Cell[151814, 5696, 87, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[151904, 5700, 117, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[152036, 5706, 606, 19, 70, "Text",
  CellTags->{"S3.3.11", "11.16"}],
Cell[152645, 5727, 2709, 81, 70, "DefinitionBox",
  CellTags->"S3.3.11"],
Cell[155357, 5810, 90, 1, 70, "Caption",
  CellTags->"S3.3.11"],
Cell[155450, 5813, 213, 6, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.17"}],

Cell[CellGroupData[{
Cell[155688, 5823, 85, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[155776, 5827, 87, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[155878, 5833, 134, 4, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.18"}],

Cell[CellGroupData[{
Cell[156037, 5841, 121, 4, 70, "Input",
  CellTags->"S3.3.11"],
Cell[156161, 5847, 87, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[156263, 5853, 222, 7, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.19"}],

Cell[CellGroupData[{
Cell[156510, 5864, 90, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[156603, 5868, 88, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[156706, 5874, 303, 9, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.20"}],

Cell[CellGroupData[{
Cell[157034, 5887, 94, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[157131, 5891, 128, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[157274, 5897, 194, 5, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.21"}],

Cell[CellGroupData[{
Cell[157493, 5906, 84, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[157580, 5910, 101, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[157696, 5916, 2626, 80, 70, "DefinitionBox",
  CellTags->"S3.3.11"],
Cell[160325, 5998, 120, 5, 70, "Caption",
  CellTags->"S3.3.11"],
Cell[160448, 6005, 448, 17, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.22"}],

Cell[CellGroupData[{
Cell[160921, 6026, 116, 4, 70, "Input",
  CellTags->"S3.3.11"],
Cell[161040, 6032, 84, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[161139, 6038, 460, 16, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.23"}],

Cell[CellGroupData[{
Cell[161624, 6058, 116, 4, 70, "Input",
  CellTags->"S3.3.11"],
Cell[161743, 6064, 87, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[161845, 6070, 208, 5, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.24"}],

Cell[CellGroupData[{
Cell[162078, 6079, 101, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[162182, 6083, 87, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[162284, 6089, 322, 11, 70, "Text",
  CellTags->{"S3.3.11", "11.25"}],
Cell[162609, 6102, 108, 1, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.26"}],

Cell[CellGroupData[{
Cell[162742, 6107, 120, 4, 70, "Input",
  CellTags->"S3.3.11"],
Cell[162865, 6113, 89, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[162969, 6119, 297, 12, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.27"}],

Cell[CellGroupData[{
Cell[163291, 6135, 124, 4, 70, "Input",
  CellTags->"S3.3.11"],
Cell[163418, 6141, 89, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[163522, 6147, 516, 19, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.28"}],

Cell[CellGroupData[{
Cell[164063, 6170, 98, 2, 70, "Input",
  CellTags->"S3.3.11"],
Cell[164164, 6174, 87, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[164266, 6180, 152, 4, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.29"}],

Cell[CellGroupData[{
Cell[164443, 6188, 125, 4, 70, "Input",
  CellTags->"S3.3.11"],
Cell[164571, 6194, 84, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[164670, 6200, 188, 5, 70, "Text",
  CellTags->{"S3.3.11", "11.30"}],
Cell[164861, 6207, 108, 1, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.31"}],

Cell[CellGroupData[{
Cell[164994, 6212, 127, 4, 70, "Input",
  CellTags->"S3.3.11"],
Cell[165124, 6218, 93, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[165232, 6224, 132, 4, 70, "MathCaption",
  CellTags->{"S3.3.11", "11.32"}],

Cell[CellGroupData[{
Cell[165389, 6232, 151, 5, 45, "Input",
  CellTags->"S3.3.11"],
Cell[165543, 6239, 107, 3, 70, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[165665, 6245, 598, 21, 72, "Text",
  CellTags->{"S3.3.11", "11.33"}],
Cell[166266, 6268, 829, 25, 66, "DefinitionBox",
  CellTags->"S3.3.11"],
Cell[167098, 6295, 85, 1, 16, "Caption",
  CellTags->"S3.3.11"],
Cell[167186, 6298, 242, 11, 40, "MathCaption",
  CellTags->{"S3.3.11", "11.34"}],

Cell[CellGroupData[{
Cell[167453, 6313, 102, 2, 28, "Input",
  CellTags->"S3.3.11"],
Cell[167558, 6317, 84, 3, 25, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[167657, 6323, 98, 1, 40, "MathCaption",
  CellTags->{"S3.3.11", "11.35"}],

Cell[CellGroupData[{
Cell[167780, 6328, 150, 5, 45, "Input",
  CellTags->"S3.3.11"],
Cell[167933, 6335, 84, 3, 25, "Output",
  CellTags->"S3.3.11"]
}, Open  ]],
Cell[168032, 6341, 605, 22, 72, "Text",
  CellTags->{"S3.3.11", "11.36"}],
Cell[168640, 6365, 507, 19, 56, "Text",
  CellTags->{"S3.3.11", "11.37"}],
Cell[169150, 6386, 152, 5, 40, "MathCaption",
  CellTags->{"S3.3.11", "11.38"}],

Cell[CellGroupData[{
Cell[169327, 6395, 114, 2, 28, "Input",
  CellTags->"S3.3.11"],
Cell[169444, 6399, 104, 3, 45, "Output",
  CellTags->"S3.3.11"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

