(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    230733,       9055]*)
(*NotebookOutlinePosition[    330084,      11910]*)
(*  CellTagsIndexPosition[    321359,      11579]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["3.4 ", "HeadingNumber"],
  "Manipulating Equations and Inequalities"
}], "Section",
  CellTags->{"S3.4.0", "0.1"}],

Cell[CellGroupData[{

Cell["3.4.1 The Representation of Equations and Solutions", "Subsection",
  CellTags->{"S3.4.1", "1.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " treats equations as logical statements. If you type in an equation like \
",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["3x", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["2", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " interprets this as a logical statement which asserts that ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["3x", "MR"],
  " is equal to ",
  StyleBox["2", "MR"],
  ". If you have assigned an explicit value to ",
  StyleBox["x", "MR"],
  ", say ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["4", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " can explicitly determine that the logical statement ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["3x", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["2", "MR"],
  " is ",
  StyleBox["False", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.4.1", "1.2"}],

Cell[TextData[{
  "If you have not assigned any explicit value to ",
  StyleBox["x", "MR"],
  ", however, ",
  StyleBox["Mathematica", "TI"],
  " cannot work out whether ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["3x", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["2", "MR"],
  " is ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  ". As a result, it leaves the equation in the symbolic form ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["3x", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["2", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.4.1", "1.3"}],

Cell[TextData[{
  "You can manipulate symbolic equations in ",
  StyleBox["Mathematica", "TI"],
  " in many ways. One common goal is to rearrange the equations so as to \
\[OpenCurlyDoubleQuote]solve\[CloseCurlyDoubleQuote] for a particular set of \
variables. "
}], "Text",
  CellTags->{"S3.4.1", "1.4"}],

Cell["Here is a symbolic equation. ", "MathCaption",
  CellTags->{"S3.4.1", "1.5"}],

Cell[CellGroupData[{

Cell["x^2 + 3x == 2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.4.1"],

Cell[BoxData[
    \(3\ x + x\^2 \[Equal] 2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.4.1"]
}, Open  ]],

Cell[TextData[{
  "You can use the function ",
  StyleBox["Reduce", "MR"],
  " to reduce the equation so as to give \[OpenCurlyDoubleQuote]solutions\
\[CloseCurlyDoubleQuote] for ",
  StyleBox["x", "MR"],
  ". The result, like the original equation, can be viewed as a logical \
statement. "
}], "MathCaption",
  CellTags->{"S3.4.1", "1.6"}],

Cell[CellGroupData[{

Cell["Reduce[%, x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.4.1"],

Cell[BoxData[
    \(x \[Equal] 1\/2\ \((\(-3\) - \@17)\) || 
      x \[Equal] 1\/2\ \((\(-3\) + \@17)\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.4.1"]
}, Open  ]],

Cell[TextData[{
  "The quadratic equation ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["3x", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["2", "MR"],
  " can be thought of as an implicit statement about the value of ",
  StyleBox["x", "MR"],
  ". As shown in the example above, you can use the function ",
  StyleBox["Reduce", "MR"],
  " to get a more explicit statement about the value of ",
  StyleBox["x", "MR"],
  ". The expression produced by ",
  StyleBox["Reduce", "MR"],
  " has the form ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["||", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  ". This expression is again a logical statement, which asserts that either \
",
  StyleBox["x", "MR"],
  " is equal to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  ", or ",
  StyleBox["x", "MR"],
  " is equal to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  ". The values of ",
  StyleBox["x", "MR"],
  " that are consistent with this statement are exactly the same as the ones \
that are consistent with the original quadratic equation. For many purposes, \
however, the form that ",
  StyleBox["Reduce", "MR"],
  " gives is much more useful than the original equation. "
}], "Text",
  CellTags->{"S3.4.1", "1.7"}],

Cell[TextData[{
  "You can combine and manipulate equations just like other logical \
statements. You can use logical connectives such as ",
  StyleBox["||", "MR"],
  " and ",
  StyleBox["&&", "MR"],
  " to specify alternative or simultaneous conditions. You can use functions \
like ",
  StyleBox["LogicalExpand", "MR"],
  ", as well as ",
  StyleBox["FullSimplify", "MR"],
  ", to simplify collections of equations. "
}], "Text",
  CellTags->{"S3.4.1", "1.8"}],

Cell[TextData[{
  "For many purposes, you will find it convenient to manipulate equations \
simply as logical statements. Sometimes, however, you will actually want to \
use explicit solutions to equations in other calculations. In such cases, it \
is convenient to convert equations that are stated in the form ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  " into transformation rules of the form ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  ". Once you have the solutions to an equation in the form of explicit \
transformation rules, you can substitute the solutions into expressions by \
using the ",
  StyleBox["/.", "MR"],
  " operator.  "
}], "Text",
  CellTags->{"S3.4.1", "1.9"}],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " produces a logical statement about the values of ",
  StyleBox["x", "MR"],
  " corresponding to the roots of the quadratic equation. "
}], "MathCaption",
  CellTags->{"S3.4.1", "1.10"}],

Cell[CellGroupData[{

Cell["Reduce[ x^2 + 3x == 2, x ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.4.1"],

Cell[BoxData[
    \(x \[Equal] 1\/2\ \((\(-3\) - \@17)\) || 
      x \[Equal] 1\/2\ \((\(-3\) + \@17)\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.4.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ToRules", "MR"],
  " converts the logical statement into an explicit list of transformation \
rules. "
}], "MathCaption",
  CellTags->{"S3.4.1", "1.11"}],

Cell[CellGroupData[{

Cell["{ToRules[ % ]}", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.4.1"],

Cell[BoxData[
    \({{x \[Rule] 1\/2\ \((\(-3\) - \@17)\)}, {x \[Rule] 
          1\/2\ \((\(-3\) + \@17)\)}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.4.1"]
}, Open  ]],

Cell[TextData[{
  "You can now use the transformation rules to substitute the solutions for \
",
  StyleBox["x", "MR"],
  " into expressions involving ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.1", "1.12"}],

Cell[CellGroupData[{

Cell["x^2 + a x /. %", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.4.1"],

Cell[BoxData[
    \({1\/4\ \((\(-3\) - \@17)\)\^2 + 1\/2\ \((\(-3\) - \@17)\)\ a, 
      1\/4\ \((\(-3\) + \@17)\)\^2 + 
        1\/2\ \((\(-3\) + \@17)\)\ a}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.4.1"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["Solve", "MR"],
  " produces transformation rules for solutions directly. "
}], "MathCaption",
  CellTags->{"S3.4.1", "1.13"}],

Cell[CellGroupData[{

Cell["Solve[ x^2 + 3x == 2, x ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.4.1"],

Cell[BoxData[
    \({{x \[Rule] 1\/2\ \((\(-3\) - \@17)\)}, {x \[Rule] 
          1\/2\ \((\(-3\) + \@17)\)}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.4.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.4.2 Equations in One Variable", "Subsection",
  CellTags->{"S3.4.2", "2.1"}],

Cell[TextData[{
  "The main equations that ",
  StyleBox["Solve", "MR"],
  " and related ",
  StyleBox["Mathematica", "TI"],
  " functions deal with are ",
  StyleBox["polynomial equations", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.4.2", "2.2"}],

Cell[TextData[{
  "It is easy to solve a linear equation in\[NonBreakingSpace]",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.3"}],

Cell[CellGroupData[{

Cell["Solve[ a x + b == c , x ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] \(\(-b\) + c\)\/a}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell["\<\
One can also solve quadratic equations just by applying a simple \
formula. \
\>", "MathCaption",
  CellTags->{"S3.4.2", "2.4"}],

Cell[CellGroupData[{

Cell["Solve[ x^2 + a x + 2 == 0 , x ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] 1\/2\ \((\(-a\) - \@\(\(-8\) + a\^2\))\)}, {x \[Rule] 
          1\/2\ \((\(-a\) + \@\(\(-8\) + a\^2\))\)}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can also find exact solutions to cubic equations. Here is the first \
solution to a comparatively simple cubic equation. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.5"}],

Cell[CellGroupData[{

Cell["Solve[ x^3 + 34 x + 1 == 0 , x ] [[1]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({x \[Rule] \(-34\)\ \((2\/\(3\ \((\(-9\) + \@471729)\)\))\)\^\(1/3\) + \
\((1\/2\ \((\(-9\) + \@471729)\))\)\^\(1/3\)\/3\^\(2/3\)}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "For cubic and quartic equations the results are often complicated, but for \
all equations with degrees up to four ",
  StyleBox["Mathematica", "TI"],
  " is always able to give explicit formulas for the solutions. "
}], "Text",
  CellTags->{"S3.4.2", "2.6"}],

Cell[TextData[{
  "An important feature of these formulas is that they involve only ",
  StyleBox["radicals", "TI"],
  ": arithmetic combinations of square roots, cube roots and higher roots. "
}], "Text",
  CellTags->{"S3.4.2", "2.7"}],

Cell["\<\
It is a fundamental mathematical fact, however, that for equations \
of degree five or higher, it is no longer possible in general to give \
explicit formulas for solutions in terms of radicals.   \
\>", "Text",
  CellTags->{"S3.4.2", "2.8"}],

Cell["\<\
There are some specific equations for which this is still possible, \
but in the vast majority of cases it is not. \
\>", "Text",
  CellTags->{"S3.4.2", "2.9"}],

Cell["This constructs a degree six polynomial. ", "MathCaption",
  CellTags->{"S3.4.2", "2.10"}],

Cell[CellGroupData[{

Cell["Expand[ Product[x^2 - 2 i, {i, 3}] ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(\(-48\) + 44\ x\^2 - 12\ x\^4 + x\^6\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "For a polynomial that factors in the way this one does, it is \
straightforward for ",
  StyleBox["Solve", "MR"],
  " to find the roots. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.11"}],

Cell[CellGroupData[{

Cell["Solve[% == 0, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] \(-2\)}, {x \[Rule] 
          2}, {x \[Rule] \(-\@2\)}, {x \[Rule] \@2}, {x \[Rule] \(-\@6\)}, {x \
\[Rule] \@6}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell["This constructs a polynomial of degree eight. ", "MathCaption",
  CellTags->{"S3.4.2", "2.12"}],

Cell[CellGroupData[{

Cell["Expand[x^2 - 2 /. x -> x^2 - 3 /. x -> x^2 - 5]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(482 - 440\ x\^2 + 144\ x\^4 - 20\ x\^6 + x\^8\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "The polynomial does not factor, but it can be decomposed into nested \
polynomials, so ",
  StyleBox["Solve", "MR"],
  " can again find explicit formulas for the roots. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.13"}],

Cell[CellGroupData[{

Cell["Solve[% == 0, x]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] \(-\@\(5 - \@\(3 - \@2\)\)\)}, {x \[Rule] \@\(5 - \@\(3 - \
\@2\)\)}, {x \[Rule] \(-\@\(5 + \@\(3 - \@2\)\)\)}, {x \[Rule] \@\(5 + \@\(3 \
- \@2\)\)}, {x \[Rule] \(-\@\(5 - \@\(3 + \@2\)\)\)}, {x \[Rule] \@\(5 - \
\@\(3 + \@2\)\)}, {x \[Rule] \(-\@\(5 + \@\(3 + \@2\)\)\)}, {x \[Rule] \@\(5 \
+ \@\(3 + \@2\)\)}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Root[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["k", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " root of the equation ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["0", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.2"],

Cell["Implicit representation for roots. ", "Caption",
  CellTags->"S3.4.2"],

Cell[TextData[{
  "No explicit formulas for the solution to this equation can be given in \
terms of radicals, so ",
  StyleBox["Mathematica", "TI"],
  " uses an implicit symbolic representation.  "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.14"}],

Cell[CellGroupData[{

Cell["Solve[x^5 - x + 11 == 0, x]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] Root[11 - #1 + #1\^5 &, 1]}, {x \[Rule] 
          Root[11 - #1 + #1\^5 &, 2]}, {x \[Rule] 
          Root[11 - #1 + #1\^5 &, 3]}, {x \[Rule] 
          Root[11 - #1 + #1\^5 &, 4]}, {x \[Rule] 
          Root[11 - #1 + #1\^5 &, 5]}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell["This finds a numerical approximation to each root. ", "MathCaption",
  CellTags->{"S3.4.2", "2.15"}],

Cell[CellGroupData[{

Cell["N[%]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] \(-1.6614869808014447`\)}, {x \[Rule] \
\(-0.4619400851906823`\) - 
            1.5649989957979031`\ \[ImaginaryI]}, {x \[Rule] \
\(-0.4619400851906823`\) + 
            1.5649989957979031`\ \[ImaginaryI]}, {x \[Rule] \
\(\(1.2926835755914046`\)\(\[InvisibleSpace]\)\) - 
            0.9030321731520191`\ \[ImaginaryI]}, {x \[Rule] \
\(\(1.2926835755914046`\)\(\[InvisibleSpace]\)\) + 
            0.9030321731520191`\ \[ImaginaryI]}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "If what you want in the end is a numerical solution, it is usually much \
faster to use ",
  StyleBox["NSolve", "MR"],
  " from the outset. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.16"}],

Cell[CellGroupData[{

Cell["NSolve[x^5 - x + 11 == 0, x]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] \(-1.6614869808014447`\)}, {x \[Rule] \
\(-0.4619400851906823`\) - 
            1.5649989957979031`\ \[ImaginaryI]}, {x \[Rule] \
\(-0.4619400851906823`\) + 
            1.5649989957979031`\ \[ImaginaryI]}, {x \[Rule] \
\(\(1.2926835755914046`\)\(\[InvisibleSpace]\)\) - 
            0.9030321731520191`\ \[ImaginaryI]}, {x \[Rule] \
\(\(1.2926835755914046`\)\(\[InvisibleSpace]\)\) + 
            0.9030321731520191`\ \[ImaginaryI]}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Root", "MR"],
  " objects provide an exact, though implicit, representation for the roots \
of a polynomial. You can work with them much as you would work with ",
  StyleBox["Sqrt[2]", "MR"],
  " or any other expression that represents an exact numerical quantity. "
}], "Text",
  CellTags->{"S3.4.2", "2.17"}],

Cell[TextData[{
  "Here is the ",
  StyleBox["Root", "MR"],
  " object representing the first root of the polynomial discussed above. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.18"}],

Cell[CellGroupData[{

Cell["r = Root[#^5 - # + 11 &, 1]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(Root[11 - #1 + #1\^5 &, 1]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell["This is a numerical approximation to its value. ", "MathCaption",
  CellTags->{"S3.4.2", "2.19"}],

Cell[CellGroupData[{

Cell["N[r]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(\(-1.6614869808014447`\)\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Round", "MR"],
  " does an exact computation to find the closest integer to the root. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.20"}],

Cell[CellGroupData[{

Cell["Round[r]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(\(-2\)\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell["\<\
If you substitute the root into the original polynomial, and then \
simplify the result, you get zero. \
\>", "MathCaption",
  CellTags->{"S3.4.2", "2.21"}],

Cell[CellGroupData[{

Cell["FullSimplify[ x^5 - x + 11 /. x -> r ]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell["\<\
This finds the product of all the roots of the original polynomial. \
\
\>", "MathCaption",
  CellTags->{"S3.4.2", "2.22"}],

Cell[CellGroupData[{

Cell["FullSimplify[ Product[Root[11 - # + #^5 &, k], {k, 5}] ]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(\(-11\)\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell["The complex conjugate of the third root is the second root. ", \
"MathCaption",
  CellTags->{"S3.4.2", "2.23"}],

Cell[CellGroupData[{

Cell["Conjugate[ Root[11 - # + #^5 &, 3] ]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(Root[11 - #1 + #1\^5 &, 2]\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell["\<\
If the only symbolic parameter that exists in an equation is the \
variable that you are solving for, then all the solutions to the equation \
will just be numbers. But if there are other symbolic parameters in the \
equation, then the solutions will typically be functions of these parameters. \
  \
\>", "Text",
  CellTags->{"S3.4.2", "2.24"}],

Cell[TextData[{
  "The solution to this equation can again be represented by ",
  StyleBox["Root", "MR"],
  " objects, but now each ",
  StyleBox["Root", "MR"],
  " object involves the parameter ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.25"}],

Cell[CellGroupData[{

Cell["Solve[x^5 + x + a == 0, x]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] Root[a + #1 + #1\^5 &, 1]}, {x \[Rule] 
          Root[a + #1 + #1\^5 &, 2]}, {x \[Rule] 
          Root[a + #1 + #1\^5 &, 3]}, {x \[Rule] 
          Root[a + #1 + #1\^5 &, 4]}, {x \[Rule] 
          Root[a + #1 + #1\^5 &, 5]}}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["a", "MR"],
  " is replaced with ",
  StyleBox["1", "MR"],
  ", the ",
  StyleBox["Root", "MR"],
  " objects can be simplified, and some are given as explicit radicals. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.26"}],

Cell[CellGroupData[{

Cell["Simplify[ % /. a -> 1 ]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] 
          Root[1 - #1\^2 + #1\^3 &, 
            1]}, {x \[Rule] \(-\(1\/2\)\)\ \[ImaginaryI]\ \((\(-\[ImaginaryI]\
\) + \@3)\)}, {x \[Rule] 
          1\/2\ \[ImaginaryI]\ \((\[ImaginaryI] + \@3)\)}, {x \[Rule] 
          Root[1 - #1\^2 + #1\^3 &, 2]}, {x \[Rule] 
          Root[1 - #1\^2 + #1\^3 &, 3]}}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "This shows the behavior of the first root as a function of ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.27"}],

Cell[CellGroupData[{

Cell["Plot[Root[#^5 + # + a &, 1], {a, -2, 2}]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.4.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.309017 0.294302 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 .01472 -12 -4.5 ]
[.4875 .01472 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-1)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(1)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01472 m
.50625 .01472 L
s
[(-1)] .4875 .01472 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .59498 L
.10458 .58487 L
.14415 .57417 L
.18221 .56245 L
.22272 .54795 L
.26171 .53127 L
.30316 .50933 L
.34309 .48221 L
.3815 .44846 L
.42237 .40395 L
.46172 .35631 L
.49955 .30957 L
.53984 .25981 L
.57861 .21294 L
.61984 .16826 L
.65954 .13381 L
.69774 .10817 L
.73838 .08672 L
.77751 .06999 L
.81909 .05515 L
.85916 .04292 L
.89771 .03258 L
.93871 .0228 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.4.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "This finds the derivative of the first root with respect to ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.28"}],

Cell[CellGroupData[{

Cell["D[Root[#^5 + # + a &, 1], a]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(\(-\(1\/\(1 + 5\ Root[a + #1 + #1\^5 &, 1]\^4\)\)\)\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "If you give ",
  StyleBox["Solve", "MR"],
  " any ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  "\[Hyphen]degree polynomial equation, then it will always return exactly ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " solutions, although some of these may be represented by ",
  StyleBox["Root", "MR"],
  " objects. If there are degenerate solutions, then the number of times that \
each particular solution appears will be equal to its multiplicity.   "
}], "Text",
  CellTags->{"S3.4.2", "2.29"}],

Cell[TextData[{
  StyleBox["Solve", "MR"],
  " gives two identical solutions to this equation. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.30"}],

Cell[CellGroupData[{

Cell["Solve[(x - 1)^2 == 0, x]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] 1}, {x \[Rule] 1}}\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell["\<\
Here are the first four solutions to a tenth degree equation. The \
solutions come in pairs. \
\>", "MathCaption",
  CellTags->{"S3.4.2", "2.31"}],

Cell[CellGroupData[{

Cell["Take[Solve[(x^5 - x + 11)^2 == 0, x], 4]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] Root[11 - #1 + #1\^5 &, 1]}, {x \[Rule] 
          Root[11 - #1 + #1\^5 &, 1]}, {x \[Rule] 
          Root[11 - #1 + #1\^5 &, 2]}, {x \[Rule] 
          Root[11 - #1 + #1\^5 &, 2]}}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " also knows how to solve equations which are not explicitly in the form of \
polynomials. "
}], "Text",
  CellTags->{"S3.4.2", "2.32"}],

Cell["Here is an equation involving square roots. ", "MathCaption",
  CellTags->{"S3.4.2", "2.33"}],

Cell[CellGroupData[{

Cell["Solve[ Sqrt[x] + Sqrt[1 + x] == a, x]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] \(1 - 2\ a\^2 + a\^4\)\/\(4\ a\^2\)}}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell["And here is one involving logarithms. ", "MathCaption",
  CellTags->{"S3.4.2", "2.34"}],

Cell[CellGroupData[{

Cell["Solve[ Log[x] + Log[1 - x] == a, x ]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] 
          1\/2\ \((1 - \@\(1 - 4\ \[ExponentialE]\^a\))\)}, {x \[Rule] 
          1\/2\ \((1 + \@\(1 - 4\ \[ExponentialE]\^a\))\)}}\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "So long as it can reduce an equation to some kind of polynomial form, ",
  StyleBox["Mathematica", "TI"],
  " will always be able to represent its solution in terms of ",
  StyleBox["Root", "MR"],
  " objects. However, with more general equations, involving say \
transcendental functions, there is no systematic way to use ",
  StyleBox["Root", "MR"],
  " objects, or even necessarily to find numerical approximations.  "
}], "Text",
  CellTags->{"S3.4.2", "2.35"}],

Cell[TextData[{
  "Here is a simple transcendental equation for ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.36"}],

Cell[CellGroupData[{

Cell["Solve[ArcSin[x] == a, x]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] Sin[a]}}\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell["\<\
There is no solution to this equation in terms of standard \
functions. \
\>", "MathCaption",
  CellTags->{"S3.4.2", "2.37"}],

Cell[CellGroupData[{

Cell["Solve[Cos[x] == x, x]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(Solve::"tdep" \(\(:\)\(\ \)\) 
      "The equations appear to involve the variables to be solved for in an \
essentially non-algebraic way."\)], "Message",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(Solve[Cos[x] \[Equal] x, x]\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can nevertheless find a numerical solution even in this case. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.38"}],

Cell[CellGroupData[{

Cell["FindRoot[Cos[x] == x, {x, 0}]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({x \[Rule] 0.7390851332151607`}\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "Polynomial equations in one variable only ever have a finite number of \
solutions. But transcendental equations often have an infinite number. \
Typically the reason for this is that functions like ",
  StyleBox["Sin", "MR"],
  " in effect have infinitely many possible inverses. With the default option \
setting ",
  StyleBox["InverseFunctions->True", "MR"],
  ", ",
  StyleBox["Solve", "MR"],
  " will nevertheless assume that there is a definite inverse for any such \
function. ",
  StyleBox["Solve", "MR"],
  " may then be able to return particular solutions in terms of this inverse \
function. "
}], "Text",
  CellTags->{"S3.4.2", "2.39"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " returns a particular solution in terms of ",
  StyleBox["ArcSin", "MR"],
  ", but prints a warning indicating that other solutions are lost. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.40"}],

Cell[CellGroupData[{

Cell["Solve[Sin[x] == a, x]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(Solve::"ifun" \(\(:\)\(\ \)\) 
      "Inverse functions are being used by \!\(Solve\), so some solutions may \
not be found; use Reduce for complete solution information."\)], "Message",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] ArcSin[a]}}\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "Here the answer comes out in terms of ",
  StyleBox["ProductLog", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.41"}],

Cell[CellGroupData[{

Cell["Solve[Exp[x] + x + 1 == 0, x]", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(InverseFunction::"ifun" \(\(:\)\(\ \)\) 
      "Inverse functions are being used. Values may be lost for multivalued \
inverses."\)], "Message",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(Solve::"ifun" \(\(:\)\(\ \)\) 
      "Inverse functions are being used by \!\(Solve\), so some solutions may \
not be found; use Reduce for complete solution information."\)], "Message",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \({{x \[Rule] \(-1\) - ProductLog[1\/\[ExponentialE]]}}\)], "Output",
  CellLabel->"Out[29]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "If you ask ",
  StyleBox["Solve", "MR"],
  " to solve an equation involving an arbitrary function like ",
  StyleBox["f", "MR"],
  ", it will by default try to construct a formal solution in terms of \
inverse functions. "
}], "Text",
  CellTags->{"S3.4.2", "2.42"}],

Cell[TextData[{
  StyleBox["Solve", "MR"],
  " by default uses a formal inverse for the function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.43"}],

Cell[CellGroupData[{

Cell["Solve[f[x] == a, x]", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(InverseFunction::"ifun" \(\(:\)\(\ \)\) 
      "Inverse functions are being used. Values may be lost for multivalued \
inverses."\)], "Message",
  CellTags->"S3.4.2"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          RowBox[{
            TagBox[\(f\^\((\(-1\))\)\),
              {InverseFunction, 1, 1},
              Editable->False], "[", "a", "]"}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[30]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell["This is the structure of the inverse function. ", "MathCaption",
  CellTags->{"S3.4.2", "2.44"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S3.4.2"],

Cell["{{x -> InverseFunction[f, 1, 1][a]}}", "Output",
  CellLabel->"Out[31]//InputForm= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["InverseFunction[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the inverse function of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InverseFunction[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the inverse function of the ",
              StyleBox["n", "TI"],
              "\[Hyphen]argument function ",
              StyleBox["f", "TI"],
              " with respect to its ",
              StyleBox["k", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " argument "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.2"],

Cell["Inverse functions. ", "Caption",
  CellTags->"S3.4.2"],

Cell["This returns an explicit inverse function. ", "MathCaption",
  CellTags->{"S3.4.2", "2.45"}],

Cell[CellGroupData[{

Cell["InverseFunction[Tan]", "Input",
  CellLabel->"In[32]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(ArcTan\)], "Output",
  CellLabel->"Out[32]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can do formal operations on inverse functions. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.46"}],

Cell[CellGroupData[{

Cell["D[InverseFunction[f][x^2], x]", "Input",
  CellLabel->"In[33]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    FractionBox[\(2\ x\), 
      RowBox[{
        SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", 
        RowBox[{
          TagBox[\(f\^\((\(-1\))\)\),
            InverseFunction,
            Editable->False], "[", \(x\^2\), "]"}], "]"}]]], "Output",
  CellLabel->"Out[33]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "While ",
  StyleBox["Solve", "MR"],
  " can only give specific solutions to an equation, ",
  StyleBox["Reduce", "MR"],
  " can give a representation of a whole solution set. For transcendental \
equations, it often ends up introducing new parameters, say with values \
ranging over all possible integers. "
}], "Text",
  CellTags->{"S3.4.2", "2.47"}],

Cell["This is a complete representation of the solution set. ", "MathCaption",
  CellTags->{"S3.4.2", "2.48"}],

Cell[CellGroupData[{

Cell["Reduce[Sin[x] == a, x]", "Input",
  CellLabel->"In[34]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(C[1] \[Element] 
        Integers && \((x \[Equal] \[Pi] - ArcSin[a] + 2\ \[Pi]\ C[1] || 
          x \[Equal] ArcSin[a] + 2\ \[Pi]\ C[1])\)\)], "Output",
  CellLabel->"Out[34]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell["Here again is a representation of the general solution. ", "MathCaption",
  CellTags->{"S3.4.2", "2.49"}],

Cell[CellGroupData[{

Cell["Reduce[Exp[x] + x + 1 == 0, x]", "Input",
  CellLabel->"In[35]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(C[1] \[Element] Integers && 
      x \[Equal] \(-1\) - ProductLog[C[1], 1\/\[ExponentialE]]\)], "Output",
  CellLabel->"Out[35]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "As discussed at more length in Section ",
  ButtonBox["3.4.9",
    ButtonData:>{"3.4.9", "9.1"},
    ButtonStyle->"MainBookLink"],
  ", ",
  StyleBox["Reduce", "MR"],
  " allows you to restrict the domains of variables. Sometimes this will let \
you generate definite solutions to transcendental equations\[LongDash]or show \
that they do not exist. "
}], "Text",
  CellTags->{"S3.4.2", "2.50"}],

Cell[TextData[{
  "With the domain of ",
  StyleBox["x", "MR"],
  " restricted, this yields definite solutions. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.51"}],

Cell[CellGroupData[{

Cell["Reduce[{Sin[x] == 1/2, Abs[x] < 4}, x]", "Input",
  CellLabel->"In[36]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(x \[Equal] \(-\(\(7\ \[Pi]\)\/6\)\) || x \[Equal] \[Pi]\/6 || 
      x \[Equal] \(5\ \[Pi]\)\/6\)], "Output",
  CellLabel->"Out[36]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["x", "MR"],
  " constrained to be real, only one solution is possible. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.52"}],

Cell[CellGroupData[{

Cell["Reduce[Exp[x] + x + 1 == 0, x, Reals]", "Input",
  CellLabel->"In[37]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(x \[Equal] \(-1\) - ProductLog[1\/\[ExponentialE]]\)], "Output",
  CellLabel->"Out[37]= ",
  CellTags->"S3.4.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " knows there can be no solution here. "
}], "MathCaption",
  CellTags->{"S3.4.2", "2.53"}],

Cell[CellGroupData[{

Cell["Reduce[{Sin[x] == x, x > 1}, x]", "Input",
  CellLabel->"In[38]:= ",
  CellTags->"S3.4.2"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[38]= ",
  CellTags->"S3.4.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.4.3 Advanced Topic: Algebraic Numbers", "Subsection",
  CellTags->{"S3.4.3", "3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Root[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["k", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " root of the polynomial equation ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["0", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.3"],

Cell["The representation of algebraic numbers. ", "Caption",
  CellTags->"S3.4.3"],

Cell[TextData[{
  "When you enter a ",
  StyleBox["Root", "MR"],
  " object, the polynomial that appears in it is automatically reduced to a \
minimal form. "
}], "MathCaption",
  CellTags->{"S3.4.3", "3.2"}],

Cell[CellGroupData[{

Cell["Root[24 - 2 # + 4 #^5 &, 1]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(Root[12 - #1 + 2\ #1\^5 &, 1]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.4.3"]
}, Open  ]],

Cell[TextData[{
  "This extracts the pure function which represents the polynomial, and \
applies it to ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.3", "3.3"}],

Cell[CellGroupData[{

Cell["First[%][x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(12 - x + 2\ x\^5\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.4.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Root", "MR"],
  " objects are the way that ",
  StyleBox["Mathematica", "TI"],
  " represents ",
  StyleBox["algebraic numbers", "TI"],
  ". Algebraic numbers have the property that when you perform algebraic \
operations on them, you always get a single algebraic number as the result. "
}], "Text",
  CellTags->{"S3.4.3", "3.4"}],

Cell["Here is the square root of an algebraic number. ", "MathCaption",
  CellTags->{"S3.4.3", "3.5"}],

Cell[CellGroupData[{

Cell["Sqrt[Root[2 - # + #^5 &, 1]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(\@Root[2 - #1 + #1\^5 &, 1]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.4.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["RootReduce", "MR"],
  " reduces this to a single ",
  StyleBox["Root", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S3.4.3", "3.6"}],

Cell[CellGroupData[{

Cell["RootReduce[%]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(Root[2 - #1\^2 + #1\^10 &, 6]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.4.3"]
}, Open  ]],

Cell["\<\
Here is a more complicated expression involving an algebraic \
number. \
\>", "MathCaption",
  CellTags->{"S3.4.3", "3.7"}],

Cell[CellGroupData[{

Cell["Sqrt[2] + Root[2 - # + #^5 &, 1]^2", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(\@2 + Root[2 - #1 + #1\^5 &, 1]\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.4.3"]
}, Open  ]],

Cell[TextData[{
  "Again this can be reduced to a single ",
  StyleBox["Root", "MR"],
  " object, albeit a fairly complicated one. "
}], "MathCaption",
  CellTags->{"S3.4.3", "3.8"}],

Cell[CellGroupData[{

Cell["RootReduce[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(Root[
      14 - 72\ #1 + 25\ #1\^2 - 144\ #1\^3 - 88\ #1\^4 - 8\ #1\^5 + 
          62\ #1\^6 - 14\ #1\^8 + #1\^10 &, 2]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.4.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["RootReduce[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "attempt to reduce ",
              StyleBox["expr", "TI"],
              " to a single ",
              StyleBox["Root", "MR"],
              " object "
            }]]},
          {Cell[TextData[{
              StyleBox["ToRadicals[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "attempt to transform ",
              StyleBox["Root", "MR"],
              " objects to explicit radicals "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.3"],

Cell["Operations on algebraic numbers. ", "Caption",
  CellTags->"S3.4.3"],

Cell[TextData[{
  "In this simple case the ",
  StyleBox["Root", "MR"],
  " object is automatically expressed in terms of radicals. "
}], "MathCaption",
  CellTags->{"S3.4.3", "3.9"}],

Cell[CellGroupData[{

Cell["Root[#^2 - # - 1 &, 1]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(1\/2\ \((1 - \@5)\)\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.4.3"]
}, Open  ]],

Cell[TextData[{
  "When cubic polynomials are involved, ",
  StyleBox["Root", "MR"],
  " objects are not automatically expressed in terms of radicals. "
}], "MathCaption",
  CellTags->{"S3.4.3", "3.10"}],

Cell[CellGroupData[{

Cell["Root[#^3 - 2 &, 1]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(Root[\(-2\) + #1\^3 &, 1]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.4.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ToRadicals", "MR"],
  " attempts to express all ",
  StyleBox["Root", "MR"],
  " objects in terms of radicals. "
}], "MathCaption",
  CellTags->{"S3.4.3", "3.11"}],

Cell[CellGroupData[{

Cell["ToRadicals[%]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(2\^\(1/3\)\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.4.3"]
}, Open  ]],

Cell[TextData[{
  "If ",
  StyleBox["Solve", "MR"],
  " and ",
  StyleBox["ToRadicals", "MR"],
  " do not succeed in expressing the solution to a particular polynomial \
equation in terms of radicals, then it is a good guess that this \
fundamentally cannot be done. However, you should realize that there are some \
special cases in which a reduction to radicals is in principle possible, but \
",
  StyleBox["Mathematica", "TI"],
  " cannot find it. The simplest example is the equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "5"], "+", "20", 
          StyleBox["x",
            "TI"], "+", "32", "=", "0"}], TraditionalForm]], 
    "InlineFormula"],
  ", but here the solution in terms of radicals is very complicated. The \
equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "6"], "-", "9", 
          SuperscriptBox[
            StyleBox["x",
              "TI"], "4"], "-", "4", 
          SuperscriptBox[
            StyleBox["x",
              "TI"], "3"], "+", "27", 
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"], "-", "36", 
          StyleBox["x",
            "TI"], "-", "23"}], TraditionalForm]], "InlineFormula"],
  " is another example, where now ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", \(2\^\(1\/3\)\), "+", \(3\^\(1\/2\)\)}], 
        TraditionalForm]], "InlineFormula"],
  " is a solution. "
}], "Text",
  CellTags->{"S3.4.3", "3.12"}],

Cell[TextData[{
  "This gives a ",
  StyleBox["Root", "MR"],
  " object involving a degree six polynomial. "
}], "MathCaption",
  CellTags->{"S3.4.3", "3.13"}],

Cell[CellGroupData[{

Cell["RootReduce[2^(1/3) + Sqrt[3]]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(Root[\(-23\) - 36\ #1 + 27\ #1\^2 - 4\ #1\^3 - 9\ #1\^4 + #1\^6 &, 
      2]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.4.3"]
}, Open  ]],

Cell[TextData[{
  "Even though a simple form in terms of radicals does exist, ",
  StyleBox["ToRadicals", "MR"],
  " does not find it. "
}], "MathCaption",
  CellTags->{"S3.4.3", "3.14"}],

Cell[CellGroupData[{

Cell["ToRadicals[%]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(Root[\(-23\) - 36\ #1 + 27\ #1\^2 - 4\ #1\^3 - 9\ #1\^4 + #1\^6 &, 
      2]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.4.3"]
}, Open  ]],

Cell["\<\
Beyond degree four, most polynomials do not have roots that can be \
expressed at all in terms of radicals. However, for degree five it turns out \
that the roots can always be expressed in terms of elliptic or hypergeometric \
functions. The results, however, are typically much too complicated to be \
useful in practice.   \
\>", "Text",
  CellTags->{"S3.4.3", "3.15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["RootSum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the sum of ",
              StyleBox["form", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " for all ",
              StyleBox["x", "TI"],
              " satisfying the polynomial equation ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["0", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Normal[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the form of ",
              StyleBox["expr", "TI"],
              " with ",
              StyleBox["RootSum", "MR"],
              " replaced by explicit sums of ",
              StyleBox["Root", "MR"],
              " objects "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.3"],

Cell["Sums of roots. ", "Caption",
  CellTags->"S3.4.3"],

Cell[TextData[{
  "This computes the sum of the reciprocals of the roots of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "+", "2", 
          StyleBox["x",
            "TI"], "+", 
          SuperscriptBox[
            StyleBox["x",
              "TI"], "5"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.3", "3.16"}],

Cell[CellGroupData[{

Cell["RootSum[(1 + 2 # + #^5)&, (1/#)&]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(\(-2\)\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.4.3"]
}, Open  ]],

Cell["Now no explicit result can be given in terms of radicals. ", \
"MathCaption",
  CellTags->{"S3.4.3", "3.17"}],

Cell[CellGroupData[{

Cell["RootSum[(1 + 2 # + #^5)&, (# Log[1 + #])&]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(RootSum[1 + 2\ #1 + #1\^5 &, Log[1 + #1]\ #1 &]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.4.3"]
}, Open  ]],

Cell[TextData[{
  "This expands the ",
  StyleBox["RootSum", "MR"],
  " into a explicit sum involving ",
  StyleBox["Root", "MR"],
  " objects. "
}], "MathCaption",
  CellTags->{"S3.4.3", "3.18"}],

Cell[CellGroupData[{

Cell["Normal[%]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.4.3"],

Cell[BoxData[
    \(Log[1 + Root[1 + 2\ #1 + #1\^5 &, 1]]\ Root[1 + 2\ #1 + #1\^5 &, 1] + 
      Log[1 + Root[1 + 2\ #1 + #1\^5 &, 2]]\ Root[1 + 2\ #1 + #1\^5 &, 2] + 
      Log[1 + Root[1 + 2\ #1 + #1\^5 &, 3]]\ Root[1 + 2\ #1 + #1\^5 &, 3] + 
      Log[1 + Root[1 + 2\ #1 + #1\^5 &, 4]]\ Root[1 + 2\ #1 + #1\^5 &, 4] + 
      Log[1 + Root[1 + 2\ #1 + #1\^5 &, 5]]\ Root[1 + 2\ #1 + #1\^5 &, 
          5]\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.4.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.4.4 Simultaneous Equations", "Subsection",
  CellTags->{"S3.4.4", "4.1"}],

Cell[TextData[{
  "You can give ",
  StyleBox["Solve", "MR"],
  " a list of simultaneous equations to solve. ",
  StyleBox["Solve", "MR"],
  " can find explicit solutions for a large class of simultaneous polynomial \
equations. "
}], "Text",
  CellTags->{"S3.4.4", "4.2"}],

Cell["Here is a simple linear equation with two unknowns. ", "MathCaption",
  CellTags->{"S3.4.4", "4.3"}],

Cell[CellGroupData[{

Cell["Solve[ { a x + b y == 1, x - y == 2 } , {x, y} ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.4.4"],

Cell[BoxData[
    \({{x \[Rule] \(-\(\(\(-1\) - 2\ b\)\/\(a + b\)\)\), 
        y \[Rule] \(-\(\(\(-1\) + 2\ a\)\/\(a + b\)\)\)}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.4.4"]
}, Open  ]],

Cell["\<\
Here is a more complicated example. The result is a list of \
solutions, with each solution consisting of a list of transformation rules \
for the variables. \
\>", "MathCaption",
  CellTags->{"S3.4.4", "4.4"}],

Cell[CellGroupData[{

Cell["Solve[{x^2 + y^2 == 1, x + y == a}, {x, y}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.4.4"],

Cell[BoxData[
    \({{x \[Rule] 1\/2\ \((a - \@\(2 - a\^2\))\), 
        y \[Rule] 1\/2\ \((a + \@\(2 - a\^2\))\)}, {x \[Rule] 
          a\/2 + \@\(2 - a\^2\)\/2, 
        y \[Rule] 1\/2\ \((a - \@\(2 - a\^2\))\)}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.4.4"]
}, Open  ]],

Cell[TextData[{
  "You can use the list of solutions with the ",
  StyleBox["/.", "MR"],
  " operator. "
}], "MathCaption",
  CellTags->{"S3.4.4", "4.5"}],

Cell[CellGroupData[{

Cell["x^3 + y^4 /. % /. a -> 0.7", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.4.4"],

Cell[BoxData[
    \({0.8465765371132498`, 0.9018734628867501`}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.4.4"]
}, Open  ]],

Cell[TextData[{
  "Even when ",
  StyleBox["Solve", "MR"],
  " cannot find explicit solutions, it often can \
\[OpenCurlyDoubleQuote]unwind\[CloseCurlyDoubleQuote] simultaneous equations \
to produce a symbolic result in terms of ",
  StyleBox["Root", "MR"],
  " objects. "
}], "MathCaption",
  CellTags->{"S3.4.4", "4.6"}],

Cell[CellGroupData[{

Cell["First[ Solve[{x^2 + y^3 == x y, x + y + x y == 1}, {x, y}] ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.4.4"],

Cell[BoxData[
    \({x \[Rule] 
        1\/2\ \((1 - 
              Root[1 - 3\ #1 + #1\^2 + 2\ #1\^3 + 2\ #1\^4 + #1\^5 &, 1]\^2 - 
              Root[1 - 3\ #1 + #1\^2 + 2\ #1\^3 + 2\ #1\^4 + #1\^5 &, 1]\^3 - 
              Root[1 - 3\ #1 + #1\^2 + 2\ #1\^3 + 2\ #1\^4 + #1\^5 &, \
1]\^4)\), 
      y \[Rule] 
        Root[1 - 3\ #1 + #1\^2 + 2\ #1\^3 + 2\ #1\^4 + #1\^5 &, 
          1]}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.4.4"]
}, Open  ]],

Cell[TextData[{
  "You can then use ",
  StyleBox["N", "MR"],
  " to get a numerical result. "
}], "MathCaption",
  CellTags->{"S3.4.4", "4.7"}],

Cell[CellGroupData[{

Cell["N[ % ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.4.4"],

Cell[BoxData[
    \({x \[Rule] \(-3.4875028096946927`\), 
      y \[Rule] \(-1.8040191923423288`\)}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.4.4"]
}, Open  ]],

Cell[TextData[{
  "The variables that you use in ",
  StyleBox["Solve", "MR"],
  " do not need to be single symbols. Often when you set up large collections \
of simultaneous equations, you will want to use expressions like ",
  StyleBox["a", "TI"],
  StyleBox["[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  " as variables.  "
}], "Text",
  CellTags->{"S3.4.4", "4.8"}],

Cell[TextData[{
  "Here is a list of three equations for the ",
  StyleBox["a[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.4", "4.9"}],

Cell[CellGroupData[{

Cell["Table[ 2 a[i] + a[i-1] == a[i+1], {i, 3} ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.4.4"],

Cell[BoxData[
    \({a[0] + 2\ a[1] \[Equal] a[2], a[1] + 2\ a[2] \[Equal] a[3], 
      a[2] + 2\ a[3] \[Equal] a[4]}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.4.4"]
}, Open  ]],

Cell[TextData[{
  "This solves for some of the ",
  StyleBox["a[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.4", "4.10"}],

Cell[CellGroupData[{

Cell["Solve[ % , {a[1], a[2], a[3]} ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.4.4"],

Cell[BoxData[
    \({{a[1] \[Rule] 1\/12\ \((\(-5\)\ a[0] + a[4])\), 
        a[2] \[Rule] 1\/6\ \((a[0] + a[4])\), 
        a[3] \[Rule] 1\/12\ \((\(-a[0]\) + 5\ a[4])\)}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.4.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Solve[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve ",
              StyleBox["eqns", "TI"],
              " for the specific objects ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Solve[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to solve ",
              StyleBox["eqns", "TI"],
              " for all the objects that appear in them "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.4"],

Cell["Solving simultaneous equations. ", "Caption",
  CellTags->"S3.4.4"],

Cell[TextData[{
  "If you do not explicitly specify objects to solve for, ",
  StyleBox["Solve", "MR"],
  " will try to solve for all the variables. "
}], "MathCaption",
  CellTags->{"S3.4.4", "4.11"}],

Cell[CellGroupData[{

Cell["Solve[ { x + y == 1, x - 3 y == 2 } ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.4.4"],

Cell[BoxData[
    \({{x \[Rule] 5\/4, y \[Rule] \(-\(1\/4\)\)}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.4.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["Solve[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "==",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "==",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, ",
              StyleBox["vars", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["Solve[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "==",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " && ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "==",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " && \[Ellipsis] , ",
              StyleBox["vars", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["Solve[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] } == {",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, ",
              StyleBox["vars", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.4"],

Cell[TextData[{
  "Ways to present simultaneous equations to ",
  StyleBox["Solve", "MR"],
  ". "
}], "Caption",
  CellTags->"S3.4.4"],

Cell["\<\
If you construct simultaneous equations from matrices, you \
typically get equations between lists of expressions. \
\>", "MathCaption",
  CellTags->{"S3.4.4", "4.12"}],

Cell[CellGroupData[{

Cell["{{3,1},{2,-5}}.{x,y}=={7,8}", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.4.4"],

Cell[BoxData[
    \({3\ x + y, 2\ x - 5\ y} \[Equal] {7, 8}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.4.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Solve", "MR"],
  " converts equations involving lists to lists of equations. "
}], "MathCaption",
  CellTags->{"S3.4.4", "4.13"}],

Cell[CellGroupData[{

Cell["Solve[%, {x, y}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.4.4"],

Cell[BoxData[
    \({{x \[Rule] 43\/17, y \[Rule] \(-\(10\/17\)\)}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.4.4"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["LogicalExpand", "MR"],
  " to do the conversion explicitly.  "
}], "MathCaption",
  CellTags->{"S3.4.4", "4.14"}],

Cell[CellGroupData[{

Cell["LogicalExpand[%%]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.4.4"],

Cell[BoxData[
    \(2\ x - 5\ y \[Equal] 8 && 3\ x + y \[Equal] 7\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.4.4"]
}, Open  ]],

Cell[TextData[{
  "In some kinds of computations, it is convenient to work with arrays of \
coefficients instead of explicit equations. You can construct such arrays \
from equations by using ",
  StyleBox["CoefficientArrays", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.4.4", "4.15"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
3.4.5 Generic and Non\[Hyphen]Generic Solutions\
\>", "Subsection",
  CellTags->{"S3.4.5", "5.1"}],

Cell[TextData[{
  "If you have an equation like ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["0", "MR"],
  ", it is perfectly clear that the only possible solution is ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["0", "MR"],
  ". However, if you have an equation like ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["0", "MR"],
  ", things are not so clear. If ",
  StyleBox["a", "MR"],
  " is not equal to zero, then ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["0", "MR"],
  " is again the only solution. However, if ",
  StyleBox["a", "MR"],
  " is in fact equal to zero, then ",
  StyleBox["any", "TI"],
  " value of ",
  StyleBox["x", "MR"],
  " is a solution. You can see this by using ",
  StyleBox["Reduce", "MR"],
  ".   "
}], "Text",
  CellTags->{"S3.4.5", "5.2"}],

Cell[TextData[{
  StyleBox["Solve", "MR"],
  " implicitly assumes that the parameter ",
  StyleBox["a", "MR"],
  " does not have the special value ",
  StyleBox["0", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.3"}],

Cell[CellGroupData[{

Cell["Solve[ a x == 0 , x ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \({{x \[Rule] 0}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  ", on the other hand, gives you all the possibilities, without assuming \
anything about the value of ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.4"}],

Cell[CellGroupData[{

Cell["Reduce[ a x == 0 , x ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \(a \[Equal] 0 || x \[Equal] 0\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  "A basic difference between ",
  StyleBox["Reduce", "MR"],
  " and ",
  StyleBox["Solve", "MR"],
  " is that ",
  StyleBox["Reduce", "MR"],
  " gives ",
  StyleBox["all", "TI"],
  " the possible solutions to a set of equations, while ",
  StyleBox["Solve", "MR"],
  " gives only the ",
  StyleBox["generic", "TI"],
  " ones. Solutions are considered \[OpenCurlyDoubleQuote]generic\
\[CloseCurlyDoubleQuote] if they involve conditions only on the variables \
that you explicitly solve for, and not on other parameters in the equations. \
",
  StyleBox["Reduce", "MR"],
  " and ",
  StyleBox["Solve", "MR"],
  " also differ in that ",
  StyleBox["Reduce", "MR"],
  " always returns combinations of equations, while ",
  StyleBox["Solve", "MR"],
  " gives results in the form of transformation rules. "
}], "Text",
  CellTags->{"S3.4.5", "5.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Solve[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["vars", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["find generic solutions to equations "]},
          {Cell[TextData[{
              StyleBox["Reduce[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["vars", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["reduce equations, maintaining all solutions "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.5"],

Cell["Solving equations. ", "Caption",
  CellTags->"S3.4.5"],

Cell[TextData[{
  "This is the solution to an arbitrary linear equation given by ",
  StyleBox["Solve", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.6"}],

Cell[CellGroupData[{

Cell["Solve[a x + b == 0, x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \({{x \[Rule] \(-\(b\/a\)\)}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " gives the full version, which includes the possibility ",
  StyleBox["a==b==0", "MR"],
  ". In reading the output, note that ",
  StyleBox["&&", "MR"],
  " has higher precedence than ",
  StyleBox["||", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.7"}],

Cell[CellGroupData[{

Cell["Reduce[a x + b == 0, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \(\((b \[Equal] 0 && a \[Equal] 0)\) || \((a \[NotEqual] 0 && 
          x \[Equal] \(-\(b\/a\)\))\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  "Here is the full solution to a general quadratic equation. There are three \
alternatives. If ",
  StyleBox["a", "MR"],
  " is non\[Hyphen]zero, then there are two solutions for ",
  StyleBox["x", "MR"],
  ", given by the standard quadratic formula. If ",
  StyleBox["a", "MR"],
  " is zero, however, the equation reduces to a linear one. Finally, if ",
  StyleBox["a", "MR"],
  ", ",
  StyleBox["b", "MR"],
  " and ",
  StyleBox["c", "MR"],
  " are all zero, there is no restriction on ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.8"}],

Cell[CellGroupData[{

Cell["Reduce[a x^2 + b x + c == 0, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \(\((a \[NotEqual] 
            0 && \((x \[Equal] \(\(-b\) - \@\(b\^2 - 4\ a\ c\)\)\/\(2\ a\) || 
              x \[Equal] \(\(-b\) + \@\(b\^2 - 4\ a\ c\)\)\/\(2\ a\))\))\) || \
\((a \[Equal] 0 && b \[NotEqual] 0 && 
          x \[Equal] \(-\(c\/b\)\))\) || \((c \[Equal] 0 && b \[Equal] 0 && 
          a \[Equal] 0)\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  "When you have several simultaneous equations, ",
  StyleBox["Reduce", "MR"],
  " can show you under what conditions the equations have solutions. ",
  StyleBox["Solve", "MR"],
  " shows you whether there are any generic solutions.    "
}], "Text",
  CellTags->{"S3.4.5", "5.9"}],

Cell["\<\
This shows there can never be any solution to these equations. \
\
\>", "MathCaption",
  CellTags->{"S3.4.5", "5.10"}],

Cell[CellGroupData[{

Cell["Reduce[ {x == 1, x == 2}, x ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  "There is a solution to these equations, but only when ",
  StyleBox["a", "MR"],
  " has the special value\[NonBreakingSpace]",
  StyleBox["1", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.11"}],

Cell[CellGroupData[{

Cell["Reduce[ {x == 1, x == a}, x ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \(a \[Equal] 1 && x \[Equal] 1\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  "The solution is not generic, and is rejected by ",
  StyleBox["Solve", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.12"}],

Cell[CellGroupData[{

Cell["Solve[ {x == 1, x == a}, x ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  "But if ",
  StyleBox["a", "MR"],
  " is constrained to have value ",
  StyleBox["1", "MR"],
  ", then ",
  StyleBox["Solve", "MR"],
  " again returns a solution. "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.13"}],

Cell[CellGroupData[{

Cell["Solve[ {x == 1, x == a, a == 1}, x ]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \({{x \[Rule] 1}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  "This equation is true for any value of\[NonBreakingSpace]",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.14"}],

Cell[CellGroupData[{

Cell["Reduce[ x == x , x ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  "This is the kind of result ",
  StyleBox["Solve", "MR"],
  " returns when you give an equation that is always true. "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.15"}],

Cell[CellGroupData[{

Cell["Solve[ x == x , x ]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \({{}}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  "When you work with systems of linear equations, you can use ",
  StyleBox["Solve", "MR"],
  " to get generic solutions, and ",
  StyleBox["Reduce", "MR"],
  " to find out for what values of parameters solutions exist. "
}], "Text",
  CellTags->{"S3.4.5", "5.16"}],

Cell[TextData[{
  "Here is a matrix whose ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["i",
            "TI"], ",", 
          StyleBox["j",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " element is ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["i",
            "TI"], "+", 
          StyleBox["j",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.17"}],

Cell[CellGroupData[{

Cell["m = Table[i + j, {i, 3}, {j, 3}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \({{2, 3, 4}, {3, 4, 5}, {4, 5, 6}}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell["The matrix has determinant zero. ", "MathCaption",
  CellTags->{"S3.4.5", "5.18"}],

Cell[CellGroupData[{

Cell["Det[ m ]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell["This makes a set of three simultaneous equations. ", "MathCaption",
  CellTags->{"S3.4.5", "5.19"}],

Cell[CellGroupData[{

Cell["eqn = m . {x, y, z} == {a, b, c}", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \({2\ x + 3\ y + 4\ z, 3\ x + 4\ y + 5\ z, 
        4\ x + 5\ y + 6\ z} \[Equal] {a, b, c}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Solve", "MR"],
  " reports that there are no generic solutions. "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.20"}],

Cell[CellGroupData[{

Cell["Solve[eqn, {x, y, z}]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  ", however, shows that there ",
  StyleBox["would", "TI"],
  " be a solution if the parameters satisfied the special condition ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["2b", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["c", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.21"}],

Cell[CellGroupData[{

Cell["Reduce[eqn, {x, y, z}]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \(a \[Equal] 2\ b - c && y \[Equal] \(-6\)\ b + 5\ c - 2\ x && 
      z \[Equal] 5\ b - 4\ c + x\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell["\<\
For nonlinear equations, the conditions for the existence of \
solutions can be much more complicated. \
\>", "Text",
  CellTags->{"S3.4.5", "5.22"}],

Cell["Here is a very simple pair of nonlinear equations. ", "MathCaption",
  CellTags->{"S3.4.5", "5.23"}],

Cell[CellGroupData[{

Cell["eqn = {x y == a, x^2 y^2 == b}", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \({x\ y \[Equal] a, x\^2\ y\^2 \[Equal] b}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Solve", "MR"],
  " shows that the equations have no generic solutions. "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.24"}],

Cell[CellGroupData[{

Cell["Solve[eqn, {x, y}]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " gives the complete conditions for a solution to exist. "
}], "MathCaption",
  CellTags->{"S3.4.5", "5.25"}],

Cell[CellGroupData[{

Cell["Reduce[eqn, {x, y}]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.4.5"],

Cell[BoxData[
    \(\((b \[Equal] 0 && a \[Equal] 0 && 
          x \[Equal] 0)\) || \((\((a \[Equal] \(-\@b\) || a \[Equal] \@b)\) && 
          x \[NotEqual] 0 && y \[Equal] a\/x)\)\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.4.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.4.6 Eliminating Variables", "Subsection",
  CellTags->{"S3.4.6", "6.1"}],

Cell[TextData[{
  "When you write down a set of simultaneous equations in ",
  StyleBox["Mathematica", "TI"],
  ", you are specifying a collection of constraints between variables. When \
you use ",
  StyleBox["Solve", "MR"],
  ", you are finding values for some of the variables in terms of others, \
subject to the constraints represented by the equations.   "
}], "Text",
  CellTags->{"S3.4.6", "6.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Solve[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["vars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["elims", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find solutions for ",
              StyleBox["vars", "TI"],
              ", eliminating the variables ",
              StyleBox["elims", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Eliminate[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["elims", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "rearrange equations to eliminate the variables ",
              StyleBox["elims", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.6"],

Cell["Eliminating variables. ", "Caption",
  CellTags->"S3.4.6"],

Cell[TextData[{
  "Here are two equations involving ",
  StyleBox["x", "MR"],
  ", ",
  StyleBox["y", "MR"],
  " and the \[OpenCurlyDoubleQuote]parameters\[CloseCurlyDoubleQuote] ",
  StyleBox["a", "MR"],
  " and ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.6", "6.3"}],

Cell[CellGroupData[{

Cell["eqn = {x + y == 6a + 3b, y == 9a + 2 x}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.4.6"],

Cell[BoxData[
    \({x + y \[Equal] 6\ a + 3\ b, y \[Equal] 9\ a + 2\ x}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.4.6"]
}, Open  ]],

Cell[TextData[{
  "If you solve for both ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ", you get results in terms of ",
  StyleBox["a", "MR"],
  " and ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.6", "6.4"}],

Cell[CellGroupData[{

Cell["Solve[eqn, {x, y}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.4.6"],

Cell[BoxData[
    \({{x \[Rule] \(-a\) + b, y \[Rule] 7\ a + 2\ b}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.4.6"]
}, Open  ]],

Cell[TextData[{
  "Similarly, if you solve for ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["a", "MR"],
  ", you get results in terms of ",
  StyleBox["y", "MR"],
  " and ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.6", "6.5"}],

Cell[CellGroupData[{

Cell["Solve[eqn, {x, a}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.4.6"],

Cell[BoxData[
    \({{x \[Rule] 1\/7\ \((9\ b - y)\), 
        a \[Rule] 1\/7\ \((\(-2\)\ b + y)\)}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.4.6"]
}, Open  ]],

Cell[TextData[{
  "If you only want to solve for ",
  StyleBox["x", "MR"],
  ", however, you have to specify whether you want to eliminate ",
  StyleBox["y", "MR"],
  " or ",
  StyleBox["a", "MR"],
  " or ",
  StyleBox["b", "MR"],
  ". This eliminates ",
  StyleBox["y", "MR"],
  ", and so gives the result in terms of ",
  StyleBox["a", "MR"],
  " and ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.6", "6.6"}],

Cell[CellGroupData[{

Cell["Solve[eqn, x, y]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.4.6"],

Cell[BoxData[
    \({{x \[Rule] \(-a\) + b}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.4.6"]
}, Open  ]],

Cell[TextData[{
  "If you eliminate ",
  StyleBox["a", "MR"],
  ", then you get a result in terms of ",
  StyleBox["y", "MR"],
  " and ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.6", "6.7"}],

Cell[CellGroupData[{

Cell["Solve[eqn, x, a]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.4.6"],

Cell[BoxData[
    \({{x \[Rule] 1\/7\ \((9\ b - y)\)}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.4.6"]
}, Open  ]],

Cell[TextData[{
  "In some cases, you may want to construct explicitly equations in which \
variables have been eliminated. You can do this using ",
  StyleBox["Eliminate", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.4.6", "6.8"}],

Cell[TextData[{
  "This combines the two equations in the list ",
  StyleBox["eqn", "MR"],
  ", by eliminating the variable ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.6", "6.9"}],

Cell[CellGroupData[{

Cell["Eliminate[eqn, a]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.4.6"],

Cell[BoxData[
    \(9\ b - y \[Equal] 7\ x\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.4.6"]
}, Open  ]],

Cell[TextData[{
  "This is what you get if you eliminate ",
  StyleBox["y", "MR"],
  " instead of ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.6", "6.10"}],

Cell[CellGroupData[{

Cell["Eliminate[eqn, y]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.4.6"],

Cell[BoxData[
    \(b - x \[Equal] a\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.4.6"]
}, Open  ]],

Cell[TextData[{
  "As a more sophisticated example of ",
  StyleBox["Eliminate", "MR"],
  ", consider the problem of writing ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "5"], "+", 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "5"]}], TraditionalForm]], "InlineFormula"],
  " in terms of the \[OpenCurlyDoubleQuote]symmetric polynomials\
\[CloseCurlyDoubleQuote] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "+", 
          StyleBox["y",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x  y\),
          "TI"], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.4.6", "6.11"}],

Cell[TextData[{
  "To solve the problem, we simply have to write ",
  StyleBox["f", "MR"],
  " in terms of ",
  StyleBox["a", "MR"],
  " and ",
  StyleBox["b", "MR"],
  ", eliminating the original variables ",
  StyleBox["x", "MR"],
  " and\[NonBreakingSpace]",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.6", "6.12"}],

Cell[CellGroupData[{

Cell["Eliminate[ {f == x^5 + y^5, a == x + y, b == x y}, {x, y} ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.4.6"],

Cell[BoxData[
    \(f \[Equal] a\^5 - 5\ a\^3\ b + 5\ a\ b\^2\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.4.6"]
}, Open  ]],

Cell[TextData[{
  "In dealing with sets of equations, it is common to consider some of the \
objects that appear as true \[OpenCurlyDoubleQuote]variables\
\[CloseCurlyDoubleQuote], and others as \[OpenCurlyDoubleQuote]parameters\
\[CloseCurlyDoubleQuote]. In some cases, you may need to know for what values \
of parameters a particular relation between the variables is ",
  StyleBox["always", "TI"],
  " satisfied. "
}], "Text",
  CellTags->{"S3.4.6", "6.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SolveAlways[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["vars", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve for the values of parameters for which the ",
              StyleBox["eqns", "TI"],
              " are satisfied for all values of the ",
              StyleBox["vars", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.6"],

Cell["Solving for parameters that make relations always true. ", "Caption",
  CellTags->"S3.4.6"],

Cell[TextData[{
  "This finds the values of parameters that make the equation hold for all ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.6", "6.14"}],

Cell[CellGroupData[{

Cell["SolveAlways[a + b x + c x^2 == (1 + x)^2, x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.4.6"],

Cell[BoxData[
    \({{a \[Rule] 1, b \[Rule] 2, c \[Rule] 1}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.4.6"]
}, Open  ]],

Cell["This equates two series. ", "MathCaption",
  CellTags->{"S3.4.6", "6.15"}],

Cell[CellGroupData[{

Cell["\<\
Series[a Cos[x] + b Cos[2x] + Cos[3x], {x, 0, 3}] == \
Series[Cosh[x], {x, 0, 3}]\
\>", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.4.6"],

Cell[BoxData[
    RowBox[{
      InterpretationBox[
        RowBox[{\((1 + a + b)\), 
          "+", \(\((\(-\(9\/2\)\) - a\/2 - 2\ b)\)\ x\^2\), "+", 
          InterpretationBox[\(O[x]\^4\),
            SeriesData[ x, 0, {}, 0, 4, 1],
            Editable->False]}],
        SeriesData[ x, 0, {
          Plus[ 1, a, b], 0, 
          Plus[ 
            Rational[ -9, 2], 
            Times[ 
              Rational[ -1, 2], a], 
            Times[ -2, b]]}, 0, 4, 1],
        Editable->False], "\[Equal]", 
      InterpretationBox[
        RowBox[{"1", "+", \(x\^2\/2\), "+", 
          InterpretationBox[\(O[x]\^4\),
            SeriesData[ x, 0, {}, 0, 4, 1],
            Editable->False]}],
        SeriesData[ x, 0, {1, 0, 
          Rational[ 1, 2]}, 0, 4, 1],
        Editable->False]}]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.4.6"]
}, Open  ]],

Cell["This finds values of the undetermined coefficients. ", "MathCaption",
  CellTags->{"S3.4.6", "6.16"}],

Cell[CellGroupData[{

Cell["SolveAlways[%, x]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.4.6"],

Cell[BoxData[
    \({{a \[Rule] 10\/3, b \[Rule] \(-\(10\/3\)\)}}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.4.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.4.7 Solving Logical Combinations of Equations", "Subsection",
  CellTags->{"S3.4.7", "7.1"}],

Cell[TextData[{
  "When you give a list of equations to ",
  StyleBox["Solve", "MR"],
  ", it assumes that you want all the equations to be satisfied \
simultaneously. It is also possible to give ",
  StyleBox["Solve", "MR"],
  " more complicated logical combinations of equations. "
}], "Text",
  CellTags->{"S3.4.7", "7.2"}],

Cell[TextData[{
  StyleBox["Solve", "MR"],
  " assumes that the equations ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["1", "MR"],
  " and ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["y", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["2", "MR"],
  " are simultaneously valid. "
}], "MathCaption",
  CellTags->{"S3.4.7", "7.3"}],

Cell[CellGroupData[{

Cell["Solve[{x + y == 1, x - y == 2}, {x, y}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.4.7"],

Cell[BoxData[
    \({{x \[Rule] 3\/2, y \[Rule] \(-\(1\/2\)\)}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.4.7"]
}, Open  ]],

Cell[TextData[{
  "Here is an alternative form, using the logical connective ",
  StyleBox["&&", "MR"],
  " explicitly. "
}], "MathCaption",
  CellTags->{"S3.4.7", "7.4"}],

Cell[CellGroupData[{

Cell["Solve[ x + y == 1 && x - y == 2, {x, y}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.4.7"],

Cell[BoxData[
    \({{x \[Rule] 3\/2, y \[Rule] \(-\(1\/2\)\)}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.4.7"]
}, Open  ]],

Cell[TextData[{
  "This specifies that ",
  StyleBox["either", "TI"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["or", "TI"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["y", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["2", "MR"],
  ". ",
  StyleBox["Solve", "MR"],
  " gives two solutions for ",
  StyleBox["x", "MR"],
  ", corresponding to these two possibilities. "
}], "MathCaption",
  CellTags->{"S3.4.7", "7.5"}],

Cell[CellGroupData[{

Cell["Solve[ x + y == 1 || x - y == 2, x ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.4.7"],

Cell[BoxData[
    \({{x \[Rule] 1 - y}, {x \[Rule] 2 + y}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.4.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Solve", "MR"],
  " gives three solutions to this equation. "
}], "MathCaption",
  CellTags->{"S3.4.7", "7.6"}],

Cell[CellGroupData[{

Cell["Solve[x^3 == x, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.4.7"],

Cell[BoxData[
    \({{x \[Rule] \(-1\)}, {x \[Rule] 0}, {x \[Rule] 1}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.4.7"]
}, Open  ]],

Cell[TextData[{
  "If you explicitly include the assertion that ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["!=", "MR"],
  " ",
  StyleBox["0", "MR"],
  ", one of the previous solutions is suppressed. "
}], "MathCaption",
  CellTags->{"S3.4.7", "7.7"}],

Cell[CellGroupData[{

Cell["Solve[x^3 == x && x != 0, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.4.7"],

Cell[BoxData[
    \({{x \[Rule] \(-1\)}, {x \[Rule] 1}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.4.7"]
}, Open  ]],

Cell[TextData[{
  "Here is a slightly more complicated example. Note that the precedence of \
",
  StyleBox["||", "MR"],
  " is lower than the precedence of ",
  StyleBox["&&", "MR"],
  ", so the equation is interpreted as ",
  StyleBox["(x^3", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["!=", "MR"],
  " ",
  StyleBox["1)", "MR"],
  " ",
  StyleBox["||", "MR"],
  " ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["2", "MR"],
  ", not ",
  StyleBox["x^3", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  StyleBox["(x", "MR"],
  " ",
  StyleBox["!=", "MR"],
  " ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["||", "MR"],
  " ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["2)", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.7", "7.8"}],

Cell[CellGroupData[{

Cell["Solve[x^3 == x && x != 1 || x^2 == 2 , x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.4.7"],

Cell[BoxData[
    \({{x \[Rule] \(-1\)}, {x \[Rule] 
          0}, {x \[Rule] \(-\@2\)}, {x \[Rule] \@2}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.4.7"]
}, Open  ]],

Cell[TextData[{
  "When you use ",
  StyleBox["Solve", "MR"],
  ", the final results you get are in the form of transformation rules. If \
you use ",
  StyleBox["Reduce", "MR"],
  " or ",
  StyleBox["Eliminate", "MR"],
  ", on the other hand, then your results are logical statements, which you \
can manipulate further. "
}], "Text",
  CellTags->{"S3.4.7", "7.9"}],

Cell[TextData[{
  "This gives a logical statement representing the solutions of the equation \
",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.7", "7.10"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 == x, x]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.4.7"],

Cell[BoxData[
    \(x \[Equal] 0 || x \[Equal] 1\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.4.7"]
}, Open  ]],

Cell[TextData[{
  "This finds values of ",
  StyleBox["x", "MR"],
  " which satisfy ",
  StyleBox["x^5", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["x", "MR"],
  " but do not satisfy the statement representing the solutions of ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.7", "7.11"}],

Cell[CellGroupData[{

Cell["Reduce[x^5 == x && !%, x]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.4.7"],

Cell[BoxData[
    \(x \[Equal] \(-1\) || x \[Equal] \(-\[ImaginaryI]\) || 
      x \[Equal] \[ImaginaryI]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.4.7"]
}, Open  ]],

Cell[TextData[{
  "The logical statements produced by ",
  StyleBox["Reduce", "MR"],
  " can be thought of as representations of the solution set for your \
equations. The logical connectives ",
  StyleBox["&&", "MR"],
  ", ",
  StyleBox["||", "MR"],
  " and so on then correspond to operations on these sets. "
}], "Text",
  CellTags->{"S3.4.7", "7.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqns",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["||", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqns",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell["union of solution sets "]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqns",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["&&", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqns",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell["intersection of solution sets "]},
          {Cell[TextData[{
              StyleBox["!", "MR"],
              StyleBox["eqns", "TI"],
              " "
            }]], Cell["complement of a solution set "]},
          {Cell[TextData[{
              StyleBox["Implies[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqns",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqns",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the part of ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqns",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " that contains ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqns",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.7"],

Cell["Operations on solution sets. ", "Caption",
  CellTags->"S3.4.7"],

Cell[TextData[{
  "You may often find it convenient to use special notations for logical \
connectives, as discussed in Section\[NonBreakingSpace]",
  ButtonBox["3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S3.4.7", "7.13"}],

Cell[TextData[{
  "The input uses special notations for ",
  StyleBox["Implies", "MR"],
  " and ",
  StyleBox["Or", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.7", "7.14"}],

Cell[CellGroupData[{

Cell["\<\
Reduce[x^2 == 1 \[Implies] (x == 1 \[Or] x == -1), x]\
\>", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.4.7"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.4.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.4.8 Inequalities", "Subsection",
  CellTags->{"S3.4.8", "8.1"}],

Cell[TextData[{
  "Just as the ",
  StyleBox["equation", "TI"],
  " ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["3x", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["2", "MR"],
  " asserts that ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["3x", "MR"],
  " is equal to ",
  StyleBox["2", "MR"],
  ", so also the ",
  StyleBox["inequality", "TI"],
  " ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["3x", "MR"],
  " ",
  StyleBox[">", "MR"],
  " ",
  StyleBox["2", "MR"],
  " asserts that ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["3x", "MR"],
  " is greater than ",
  StyleBox["2", "MR"],
  ". In ",
  StyleBox["Mathematica", "TI"],
  ", ",
  StyleBox["Reduce", "MR"],
  " works not only on equations, but also on inequalities.  "
}], "Text",
  CellTags->{"S3.4.8", "8.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Reduce[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["ineq",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["ineq",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "reduce a collection of inequalities in ",
              StyleBox["x", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.8"],

Cell["Manipulating univariate inequalities. ", "Caption",
  CellTags->"S3.4.8"],

Cell["This pair of inequalities reduces to a single inequality. ", \
"MathCaption",
  CellTags->{"S3.4.8", "8.3"}],

Cell[CellGroupData[{

Cell["Reduce[{0 < x < 2, 1 < x < 4}, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(1 < x < 2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell["These inequalities can never simultaneously be satisfied. ", \
"MathCaption",
  CellTags->{"S3.4.8", "8.4"}],

Cell[CellGroupData[{

Cell["Reduce[{x < 1, x > 3}, x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell[TextData[{
  "When applied to an equation, ",
  StyleBox["Reduce[", "MR"],
  StyleBox["eqn", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " tries to get a result consisting of simple equations for ",
  StyleBox["x", "TI"],
  " of the form ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["==", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  ", \[Ellipsis]",
  " ",
  ". When applied to an inequality, ",
  StyleBox["Reduce[", "MR"],
  StyleBox["ineq", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " does the exactly analogous thing, and tries to get a result consisting of \
simple inequalities for ",
  StyleBox["x", "TI"],
  " of the form ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["l",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["<", "MR"],
  " ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["<", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  ", \[Ellipsis]",
  " ",
  ". "
}], "Text",
  CellTags->{"S3.4.8", "8.5"}],

Cell[TextData[{
  "This reduces a quadratic equation to two simple equations for ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.8", "8.6"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 + 3x == 2, x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(x \[Equal] 1\/2\ \((\(-3\) - \@17)\) || 
      x \[Equal] 1\/2\ \((\(-3\) + \@17)\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell[TextData[{
  "This reduces a quadratic inequality to two simple inequalities for ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.8", "8.7"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 + 3x > 2, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(x < 1\/2\ \((\(-3\) - \@17)\) || 
      x > 1\/2\ \((\(-3\) + \@17)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell[TextData[{
  "You can think of the result generated by ",
  StyleBox["Reduce[", "MR"],
  StyleBox["ineq", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " as representing a series of intervals, described by inequalities. Since \
the graph of a polynomial of degree ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " can go up and down as many as ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " times, a polynomial inequality of degree ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " can give rise to as many as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "/", "2", "+", "1"}], TraditionalForm]], "InlineFormula"],
  " distinct intervals. "
}], "Text",
  CellTags->{"S3.4.8", "8.8"}],

Cell["This inequality yields three distinct intervals. ", "MathCaption",
  CellTags->{"S3.4.8", "8.9"}],

Cell[CellGroupData[{

Cell["Reduce[(x - 1)(x - 2)(x - 3)(x - 4) > 0, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(x < 1 || 2 < x < 3 || x > 4\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell["The ends of the intervals are at roots and poles. ", "MathCaption",
  CellTags->{"S3.4.8", "8.10"}],

Cell[CellGroupData[{

Cell["Reduce[1 < (x^2 + 3x)/(x + 1) < 2, x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(\(-1\) - \@2 < x < \(-2\) || \(-1\) + \@2 < x < 1\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell[TextData[{
  "Solving this inequality requires introducing ",
  StyleBox["ProductLog", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.8", "8.11"}],

Cell[CellGroupData[{

Cell["Reduce[x - 2 < Log[x] < x, x]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(Reduce::"ztest" \(\(:\)\(\ \)\) 
      "-- Message text not found -- (\!\({\(\(\(\(-2\)\) - \
\(\(Log[\(\(-\(\(ProductLog[\(\(\(\(-1\)\), \
\(\(-\(\(Power[\(\(\[LeftSkeleton] 2 \[RightSkeleton]\)\)]\)\)\)\)\)\)]\)\)\)\
\)]\)\) - \(\(ProductLog[\(\(\(\(-1\)\), \(\(-\(\(1\/\[ExponentialE]\^2\)\)\)\
\)\)\)]\)\)\)\), \(\(\[LeftSkeleton] 1 \[RightSkeleton]\)\)}\))"\)], "Message",\

  CellTags->"S3.4.8"],

Cell[BoxData[
    \(\(-ProductLog[\(-\(1\/\[ExponentialE]\^2\)\)]\) < 
      x < \(-ProductLog[\(-1\), \(-\(1\/\[ExponentialE]\^2\)\)]\)\)], "Output",\

  CellLabel->"Out[7]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell[TextData[{
  "Transcendental functions like ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " have graphs that go up and down infinitely many times, so that infinitely \
many intervals can be generated. "
}], "Text",
  CellTags->{"S3.4.8", "8.12"}],

Cell["The second inequality allows only finitely many intervals. ", \
"MathCaption",
  CellTags->{"S3.4.8", "8.13"}],

Cell[CellGroupData[{

Cell["Reduce[{Sin[x] > 0, 0 < x < 20}, x]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(0 < x < \[Pi] || 2\ \[Pi] < x < 3\ \[Pi] || 4\ \[Pi] < x < 5\ \[Pi] || 
      6\ \[Pi] < x < 20\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell[TextData[{
  "This is how ",
  StyleBox["Reduce", "MR"],
  " represents infinitely many intervals. "
}], "MathCaption",
  CellTags->{"S3.4.8", "8.14"}],

Cell[CellGroupData[{

Cell["Reduce[{Sin[x] > 0, 0 < x}, x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(C[1] \[Element] 
        Integers && \((0 < 
            x < \[Pi] || \((C[1] \[GreaterEqual] 1 && 
              2\ \[Pi]\ C[1] < x < \[Pi] + 2\ \[Pi]\ C[1])\))\)\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell["Fairly simple inputs can give fairly complicated results. ", \
"MathCaption",
  CellTags->{"S3.4.8", "8.15"}],

Cell[CellGroupData[{

Cell["Reduce[{Sin[x]^2 + Sin[3x] > 0, x^2 + 2 < 20}, x]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(\(-3\)\ \@2 < x < \(-\[Pi]\) || 
      2\ ArcTan[1\/3\ \((\(-4\) - \@7)\)] < x < 
        2\ ArcTan[1\/3\ \((\(-4\) + \@7)\)] || 
      0 < x < \[Pi]\/2 || \[Pi]\/2 < x < \[Pi] || 
      2\ \[Pi] + 2\ ArcTan[1\/3\ \((\(-4\) - \@7)\)] < x < 3\ \@2\)], "Output",\

  CellLabel->"Out[10]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell[TextData[{
  "If you have inequalities that involve ",
  StyleBox["<=", "MR"],
  " as well as ",
  StyleBox["<", "MR"],
  ", there may be isolated points where the inequalities can be satisfied. ",
  StyleBox["Reduce", "MR"],
  " represents such points by giving equations. "
}], "Text",
  CellTags->{"S3.4.8", "8.16"}],

Cell["\<\
This inequality can be satisfied at just two isolated points. \
\
\>", "MathCaption",
  CellTags->{"S3.4.8", "8.17"}],

Cell[CellGroupData[{

Cell["Reduce[(x^2 - 3x + 1)^2 <= 0, x]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(x \[Equal] 1\/2\ \((3 - \@5)\) || 
      x \[Equal] 1\/2\ \((3 + \@5)\)\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell["This yields both intervals and isolated points. ", "MathCaption",
  CellTags->{"S3.4.8", "8.18"}],

Cell[CellGroupData[{

Cell["Reduce[{Max[Sin[2x], Cos[3x]] <= 0, 0 < x < 10}, x]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(x \[Equal] \[Pi]\/2 || \(5\ \[Pi]\)\/6 \[LessEqual] 
        x \[LessEqual] \[Pi] || \(3\ \[Pi]\)\/2 \[LessEqual] 
        x \[LessEqual] \(11\ \[Pi]\)\/6 || 
      x \[Equal] \(5\ \[Pi]\)\/2 || \(17\ \[Pi]\)\/6 \[LessEqual] 
        x \[LessEqual] 3\ \[Pi]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Reduce[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["ineq",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["ineq",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[
            "reduce a collection of inequalities in several variables "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.8"],

Cell["Multivariate inequalities. ", "Caption",
  CellTags->"S3.4.8"],

Cell[TextData[{
  "For inequalities involving several variables, ",
  StyleBox["Reduce", "MR"],
  " in effect yields nested collections of interval specifications, in which \
later variables have bounds that depend on earlier variables. "
}], "Text",
  CellTags->{"S3.4.8", "8.19"}],

Cell[TextData[{
  "This represents the unit disk as nested inequalities for ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.8", "8.20"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 + y^2 < 1, {x, y}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(\(-1\) < x < 1 && \(-\@\(1 - x\^2\)\) < y < \@\(1 - x\^2\)\)], "Output",\

  CellLabel->"Out[13]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell[TextData[{
  "In geometrical terms, any linear inequality divides space into two halves. \
Lists of linear inequalities thus define polyhedra, sometimes bounded, \
sometimes not. ",
  StyleBox["Reduce", "MR"],
  " represents such polyhedra in terms of nested inequalities. The corners of \
the polyhedra always appear among the endpoints of these inequalities. "
}], "Text",
  CellTags->{"S3.4.8", "8.21"}],

Cell["This defines a triangular region in the plane. ", "MathCaption",
  CellTags->{"S3.4.8", "8.22"}],

Cell[CellGroupData[{

Cell["Reduce[{x > 0, y > 0, x + y < 1}, {x, y}]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(0 < x < 1 && 0 < y < 1 - x\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell["\<\
Even a single triangle may need to be described as two components. \
\
\>", "MathCaption",
  CellTags->{"S3.4.8", "8.23"}],

Cell[CellGroupData[{

Cell["Reduce[{x > y - 1, y > 0, x + y < 1}, {x, y}]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(\((\(-1\) < x \[LessEqual] 0 && 0 < y < 1 + x)\) || \((0 < x < 1 && 
          0 < y < 1 - x)\)\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell["\<\
Lists of inequalities in general represent regions of overlap \
between geometrical objects. Often the description of these can be quite \
complicated. \
\>", "Text",
  CellTags->{"S3.4.8", "8.24"}],

Cell["\<\
This represents the part of the unit disk on one side of a line. \
\
\>", "MathCaption",
  CellTags->{"S3.4.8", "8.25"}],

Cell[CellGroupData[{

Cell["Reduce[{x^2 + y^2 < 1, x + 3y > 2}, {x, y}]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(1\/10\ \((2 - 3\ \@6)\) < x < 1\/10\ \((2 + 3\ \@6)\) && \(2 - x\)\/3 < 
        y < \@\(1 - x\^2\)\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell["Here is the intersection between two disks. ", "MathCaption",
  CellTags->{"S3.4.8", "8.26"}],

Cell[CellGroupData[{

Cell["Reduce[{(x - 1)^2 + y^2 < 2, x^2 + y^2 < 2}, {x, y}]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(\((1 - \@2 < x \[LessEqual] 1\/2 && \(-\@\(1 + 2\ x - x\^2\)\) < 
            y < \@\(1 + 2\ x - x\^2\))\) || \((1\/2 < 
            x < \@2 && \(-\@\(2 - x\^2\)\) < 
            y < \@\(2 - x\^2\))\)\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell["If the disks are too far apart, there is no intersection. ", \
"MathCaption",
  CellTags->{"S3.4.8", "8.27"}],

Cell[CellGroupData[{

Cell["Reduce[{(x - 4)^2 + y^2 < 2, x^2 + y^2 < 2}, {x, y}]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell["Here is an example involving a transcendental inequality. ", \
"MathCaption",
  CellTags->{"S3.4.8", "8.28"}],

Cell[CellGroupData[{

Cell["Reduce[{Sin[x y] > 1/2, x^2 + y^2 < 3/2}, {x, y}]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(\((\(-\@\(3\/4 + 1\/12\ \@\(81 - 4\ \[Pi]\^2\)\)\) < 
            x < \(-\(1\/2\)\)\ \@\(1\/3\ \((9 - \@\(81 - 4\ \[Pi]\^2\))\)\) && \
\(-\(\@\(3 - 2\ x\^2\)\/\@2\)\) < 
            y < \[Pi]\/\(6\ x\))\) || \((1\/2\ \@\(1\/3\ \((9 - \@\(81 - 4\ \
\[Pi]\^2\))\)\) < 
            x < \@\(3\/4 + 1\/12\ \@\(81 - 4\ \[Pi]\^2\)\) && \[Pi]\/\(6\ x\) \
< y < \@\(3 - 2\ x\^2\)\/\@2)\)\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell[TextData[{
  "If you have inequalities that involve parameters, ",
  StyleBox["Reduce", "MR"],
  " automatically handles the different cases that can occur, just as it does \
for equations. "
}], "Text",
  CellTags->{"S3.4.8", "8.29"}],

Cell[TextData[{
  "The form of the intervals depends on the value of ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.8", "8.30"}],

Cell[CellGroupData[{

Cell["Reduce[(x - 1)(x - a) > 0, x]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(\((a \[LessEqual] 1 && \((x < a || x > 1)\))\) || \((a > 
            1 && \((x < 1 || x > a)\))\)\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell[TextData[{
  "One gets a hyperbolic or an elliptical region, depending on the value of \
",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.8", "8.31"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 + a y^2 < 1, {x, y}]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \(y \[Element] 
        Reals && \((\((a < 
                0 && \((\((x \[LessEqual] \(-1\) && \((y < \(-\@\(\(1 - \
x\^2\)\/a\)\) || y > \@\(\(1 - x\^2\)\/a\))\))\) || \(-1\) < x < 
                    1 || \((x \[GreaterEqual] 
                        1 && \((y < \(-\@\(\(1 - x\^2\)\/a\)\) || 
                          y > \@\(\(1 - x\^2\)\/a\))\))\))\))\) || \((a \
\[Equal] 0 && \(-1\) < x < 1)\) || \((a > 0 && \(-1\) < x < 
                1 && \(-\@\(\(1 - x\^2\)\/a\)\) < 
                y < \@\(\(1 - x\^2\)\/a\))\))\)\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " tries to give you a complete description of the region defined by a set \
of inequalities. Sometimes, however, you may just want to find individual \
instances of values of variables that satisfy the inequalities. You can do \
this using ",
  StyleBox["FindInstance", "MR"],
  ".    "
}], "Text",
  CellTags->{"S3.4.8", "8.32"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FindInstance[", "MR"],
              StyleBox["ineqs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to find an instance of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " satisfying ",
              StyleBox["ineqs", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FindInstance[", "MR"],
              StyleBox["ineqs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["vars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to find ",
              StyleBox["n", "TI"],
              " instances "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.8"],

Cell["Finding individual points that satisfy inequalities. ", "Caption",
  CellTags->"S3.4.8"],

Cell["\<\
This finds a specific instance that satisfies the inequalities. \
\
\>", "MathCaption",
  CellTags->{"S3.4.8", "8.33"}],

Cell[CellGroupData[{

Cell["FindInstance[{Sin[x y] > 1/2, x^2 + y^2 < 3/2}, {x, y}]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \({{x \[Rule] \(-\(118\/151\)\), 
        y \[Rule] \(-\(149\/185\)\)}}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell["\<\
This shows that there is no way to satisfy the inequalities. \
\>", \
"MathCaption",
  CellTags->{"S3.4.8", "8.34"}],

Cell[CellGroupData[{

Cell["FindInstance[{Sin[x y] > 1/2, x^2 + y^2 < 1/4}, {x, y}]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FindInstance", "MR"],
  " is in some ways an analog for inequalities of ",
  StyleBox["Solve", "MR"],
  " for equations. For like ",
  StyleBox["Solve", "MR"],
  ", it returns a list of rules giving specific values for variables. But \
while for equations these values can generically give an accurate \
representation of all solutions, for inequalities they can only correspond to \
isolated sample points within the regions described by the inequalities. "
}], "Text",
  CellTags->{"S3.4.8", "8.35"}],

Cell[TextData[{
  "Every time you call ",
  StyleBox["FindInstance", "MR"],
  " with specific input, it will give the same output. And when there are \
instances that correspond to special, limiting, points of some kind, it will \
preferentially return these. But in general, the distribution of instances \
returned by ",
  StyleBox["FindInstance", "MR"],
  " will typically seem somewhat random. Each instance is, however, in effect \
a constructive proof that the inequalities you have given can in fact be \
satisfied. "
}], "Text",
  CellTags->{"S3.4.8", "8.36"}],

Cell[TextData[{
  "If you ask for one point in the unit disk, ",
  StyleBox["FindInstance", "MR"],
  " gives the origin. "
}], "MathCaption",
  CellTags->{"S3.4.8", "8.37"}],

Cell[CellGroupData[{

Cell["FindInstance[x^2 + y^2 <= 1, {x, y}]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.4.8"],

Cell[BoxData[
    \({{x \[Rule] 0, y \[Rule] 0}}\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.4.8"]
}, Open  ]],

Cell["This finds 500 points in the unit disk. ", "MathCaption",
  CellTags->{"S3.4.8", "8.38"}],

Cell["FindInstance[x^2 + y^2 <= 1, {x, y}, 500];", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.4.8"],

Cell["Their distribution seems somewhat random. ", "MathCaption",
  CellTags->{"S3.4.8", "8.39"}],

Cell[CellGroupData[{

Cell["ListPlot[{x, y} /. %, AspectRatio->Automatic]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.4.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00904 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.495925 0.480515 0.504539 0.480515 [
[.01541 .49204 -6 -9 ]
[.01541 .49204 6 0 ]
[.25567 .49204 -12 -9 ]
[.25567 .49204 12 0 ]
[.73618 .49204 -9 -9 ]
[.73618 .49204 9 0 ]
[.97644 .49204 -3 -9 ]
[.97644 .49204 3 0 ]
[.48343 .02402 -12 -4.5 ]
[.48343 .02402 0 4.5 ]
[.48343 .26428 -24 -4.5 ]
[.48343 .26428 0 4.5 ]
[.48343 .7448 -18 -4.5 ]
[.48343 .7448 0 4.5 ]
[.48343 .98505 -6 -4.5 ]
[.48343 .98505 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.00904 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01541 .50454 m
.01541 .51079 L
s
[(-1)] .01541 .49204 0 1 Mshowa
.25567 .50454 m
.25567 .51079 L
s
[(-0.5)] .25567 .49204 0 1 Mshowa
.73618 .50454 m
.73618 .51079 L
s
[(0.5)] .73618 .49204 0 1 Mshowa
.97644 .50454 m
.97644 .51079 L
s
[(1)] .97644 .49204 0 1 Mshowa
.125 Mabswid
.06346 .50454 m
.06346 .50829 L
s
.11151 .50454 m
.11151 .50829 L
s
.15956 .50454 m
.15956 .50829 L
s
.20762 .50454 m
.20762 .50829 L
s
.30372 .50454 m
.30372 .50829 L
s
.35177 .50454 m
.35177 .50829 L
s
.39982 .50454 m
.39982 .50829 L
s
.44787 .50454 m
.44787 .50829 L
s
.54398 .50454 m
.54398 .50829 L
s
.59203 .50454 m
.59203 .50829 L
s
.64008 .50454 m
.64008 .50829 L
s
.68813 .50454 m
.68813 .50829 L
s
.78423 .50454 m
.78423 .50829 L
s
.83229 .50454 m
.83229 .50829 L
s
.88034 .50454 m
.88034 .50829 L
s
.92839 .50454 m
.92839 .50829 L
s
.25 Mabswid
0 .50454 m
1 .50454 L
s
.49593 .02402 m
.50218 .02402 L
s
[(-1)] .48343 .02402 1 0 Mshowa
.49593 .26428 m
.50218 .26428 L
s
[(-0.5)] .48343 .26428 1 0 Mshowa
.49593 .7448 m
.50218 .7448 L
s
[(0.5)] .48343 .7448 1 0 Mshowa
.49593 .98505 m
.50218 .98505 L
s
[(1)] .48343 .98505 1 0 Mshowa
.125 Mabswid
.49593 .07208 m
.49968 .07208 L
s
.49593 .12013 m
.49968 .12013 L
s
.49593 .16818 m
.49968 .16818 L
s
.49593 .21623 m
.49968 .21623 L
s
.49593 .31233 m
.49968 .31233 L
s
.49593 .36038 m
.49968 .36038 L
s
.49593 .40844 m
.49968 .40844 L
s
.49593 .45649 m
.49968 .45649 L
s
.49593 .55259 m
.49968 .55259 L
s
.49593 .60064 m
.49968 .60064 L
s
.49593 .64869 m
.49968 .64869 L
s
.49593 .69675 m
.49968 .69675 L
s
.49593 .79285 m
.49968 .79285 L
s
.49593 .8409 m
.49968 .8409 L
s
.49593 .88895 m
.49968 .88895 L
s
.49593 .937 m
.49968 .937 L
s
.25 Mabswid
.49593 0 m
.49593 1.00904 L
s
0 0 m
1 0 L
1 1.00904 L
0 1.00904 L
closepath
clip
newpath
.008 w
.02381 .55577 Mdot
.02381 .41509 Mdot
.02381 .59399 Mdot
.02642 .49646 Mdot
.02642 .60683 Mdot
.0271 .52534 Mdot
.0271 .60987 Mdot
.02863 .46911 Mdot
.02863 .61649 Mdot
.03008 .42523 Mdot
.03008 .62235 Mdot
.03711 .44518 Mdot
.03711 .36177 Mdot
.03947 .63802 Mdot
.03947 .35438 Mdot
.03947 .65469 Mdot
.0413 .34894 Mdot
.04609 .67347 Mdot
.04651 .33448 Mdot
.05162 .43589 Mdot
.05162 .68754 Mdot
.05354 .31694 Mdot
.05354 .69213 Mdot
.05685 .40075 Mdot
.05685 .69975 Mdot
.05714 .48904 Mdot
.05714 .30868 Mdot
.0576 .70142 Mdot
.0599 .55616 Mdot
.06014 .70698 Mdot
.06242 .58191 Mdot
.06242 .29725 Mdot
.06242 .71183 Mdot
.06309 .29585 Mdot
.06694 .72102 Mdot
.07023 .72742 Mdot
.07244 .29347 Mdot
.07309 .53597 Mdot
.08103 .42842 Mdot
.08103 .74693 Mdot
.08808 .25046 Mdot
.08808 .75862 Mdot
.09025 .41349 Mdot
.09025 .247 Mdot
.09025 .76207 Mdot
.09319 .24243 Mdot
.09554 .34785 Mdot
.09563 .64556 Mdot
.09563 .77036 Mdot
.09619 .66823 Mdot
.09844 .25894 Mdot
.10276 .2752 Mdot
.10276 .7808 Mdot
.10317 .53184 Mdot
.10317 .78137 Mdot
.10795 .78804 Mdot
.1157 .21073 Mdot
.1157 .79835 Mdot
.11862 .80209 Mdot
.11926 .66276 Mdot
.11926 .20619 Mdot
.12006 .5104 Mdot
.12006 .20517 Mdot
.12208 .37403 Mdot
.12214 .47488 Mdot
.12214 .8065 Mdot
.12377 .80851 Mdot
.12566 .19828 Mdot
.12583 .48652 Mdot
.12583 .19807 Mdot
.12583 .81101 Mdot
.12965 .47413 Mdot
.12965 .19351 Mdot
.12965 .81557 Mdot
.133 .81946 Mdot
.13386 .45462 Mdot
.13563 .18661 Mdot
.13578 .82265 Mdot
.1365 .60439 Mdot
.13678 .205 Mdot
.13678 .82378 Mdot
.13684 .82384 Mdot
.13701 .72583 Mdot
.14094 .82839 Mdot
.14584 .6409 Mdot
.14866 .52402 Mdot
.14981 .32023 Mdot
.14981 .83786 Mdot
.15037 .83844 Mdot
.15108 .6691 Mdot
.15108 .16991 Mdot
.15108 .83917 Mdot
.15243 .16853 Mdot
.15243 .84055 Mdot
.15391 .84206 Mdot
.16563 .15554 Mdot
.1678 .85558 Mdot
.16844 .1529 Mdot
.17678 .86376 Mdot
.18466 .38979 Mdot
.18693 .13655 Mdot
.18693 .87253 Mdot
.19473 .68196 Mdot
.196 .51193 Mdot
.19848 .12715 Mdot
.20065 .88363 Mdot
.20651 .12163 Mdot
.20982 .11849 Mdot
.21038 .89101 Mdot
.21874 .89705 Mdot
.22127 .70605 Mdot
.22127 .11025 Mdot
.22443 .27978 Mdot
.22443 .901 Mdot
.23156 .71723 Mdot
.23156 .10329 Mdot
.23156 .90579 Mdot
.23555 .10068 Mdot
.23821 .9101 Mdot
.24234 .1842 Mdot
.24655 .0938 Mdot
.24849 .25207 Mdot
.24987 .67557 Mdot
.25074 .74072 Mdot
.25074 .09129 Mdot
.25547 .65114 Mdot
.25547 .92056 Mdot
.26019 .09859 Mdot
.26019 .08582 Mdot
.26019 .92326 Mdot
.26608 .08256 Mdot
.26707 .45483 Mdot
.26707 .08202 Mdot
.26857 .08121 Mdot
.26857 .92787 Mdot
.26865 .62881 Mdot
.26865 .08117 Mdot
.26865 .92791 Mdot
.27134 .92934 Mdot
.27309 .32751 Mdot
.27309 .07882 Mdot
.27309 .93026 Mdot
.27611 .12519 Mdot
.27647 .07706 Mdot
.27711 .20106 Mdot
.27711 .07674 Mdot
.27726 .07666 Mdot
.27726 .93242 Mdot
.28159 .52983 Mdot
.28159 .07448 Mdot
.28159 .9346 Mdot
.28497 .47925 Mdot
.28608 .93681 Mdot
.28624 .61413 Mdot
.28624 .07219 Mdot
.28689 .9372 Mdot
.28791 .14205 Mdot
.28879 .27286 Mdot
.291 .93917 Mdot
.29302 .88209 Mdot
.29302 .06897 Mdot
.29302 .94011 Mdot
.29437 .06834 Mdot
.29437 .94074 Mdot
.29491 .06809 Mdot
.2994 .5217 Mdot
.30432 .9452 Mdot
.30628 .06303 Mdot
.30815 .94684 Mdot
.30861 .22497 Mdot
.31712 .84527 Mdot
.31712 .05853 Mdot
.31885 .95124 Mdot
.31905 .64433 Mdot
.32081 .95201 Mdot
.32339 .05607 Mdot
.32339 .95301 Mdot
.33031 .1397 Mdot
.33177 .95614 Mdot
.33711 .24649 Mdot
.33711 .05103 Mdot
.33711 .95805 Mdot
.33744 .05091 Mdot
.33744 .95817 Mdot
.33955 .05018 Mdot
.33955 .9589 Mdot
.34169 .95963 Mdot
.34492 .83378 Mdot
.34492 .04837 Mdot
.34518 .57573 Mdot
.34518 .9608 Mdot
.34964 .96225 Mdot
.35977 .6496 Mdot
.35977 .96536 Mdot
.3641 .04246 Mdot
.36415 .18722 Mdot
.36421 .25975 Mdot
.36731 .51361 Mdot
.36773 .04144 Mdot
.37198 .04029 Mdot
.37449 .76746 Mdot
.37449 .03962 Mdot
.37449 .96946 Mdot
.3764 .03913 Mdot
.37761 .25068 Mdot
.37761 .03882 Mdot
.38253 .07947 Mdot
.3861 .03674 Mdot
.39018 .91113 Mdot
.39123 .97351 Mdot
.3925 .4491 Mdot
.39854 .97508 Mdot
.40398 .17188 Mdot
.4088 .1996 Mdot
.41957 .97895 Mdot
.42881 .56107 Mdot
.42881 .98034 Mdot
.4324 .58934 Mdot
.43325 .98095 Mdot
.44234 .02702 Mdot
.4473 .66471 Mdot
.45012 .98287 Mdot
.45016 .74009 Mdot
.45016 .02621 Mdot
.45718 .02559 Mdot
.45914 .33495 Mdot
.46108 .68355 Mdot
.46442 .98402 Mdot
.46631 .98414 Mdot
.46638 .02493 Mdot
.46719 .64587 Mdot
.47636 .98466 Mdot
.47849 .02434 Mdot
.48063 .98481 Mdot
.48099 .02426 Mdot
.48099 .98482 Mdot
.4818 .71182 Mdot
.48337 .98489 Mdot
.48374 .0994 Mdot
.48497 .30668 Mdot
.48497 .02415 Mdot
.48953 .11824 Mdot
.48953 .02407 Mdot
.48953 .98501 Mdot
.4942 .69298 Mdot
.49491 .97563 Mdot
.49498 .02403 Mdot
.49643 .02402 Mdot
.50484 .98497 Mdot
.50519 .77777 Mdot
.50519 .98496 Mdot
.50778 .02417 Mdot
.50863 .98489 Mdot
.51192 .02429 Mdot
.51192 .98479 Mdot
.51405 .98471 Mdot
.51478 .02439 Mdot
.51478 .98468 Mdot
.51513 .57049 Mdot
.51513 .98467 Mdot
.51918 .41032 Mdot
.51918 .02459 Mdot
.52072 .08056 Mdot
.52072 .02466 Mdot
.52262 .02477 Mdot
.52262 .98431 Mdot
.52495 .08056 Mdot
.52589 .02496 Mdot
.52631 .98409 Mdot
.53029 .36321 Mdot
.53029 .02525 Mdot
.53606 .0257 Mdot
.53802 .02587 Mdot
.53871 .86257 Mdot
.53871 .02593 Mdot
.54134 .9829 Mdot
.54436 .02647 Mdot
.54446 .49512 Mdot
.54446 .9826 Mdot
.54636 .34437 Mdot
.54636 .9824 Mdot
.54868 .02693 Mdot
.5502 .98198 Mdot
.55826 .41974 Mdot
.55826 .02808 Mdot
.55876 .37263 Mdot
.56085 .02843 Mdot
.56385 .84644 Mdot
.56385 .02885 Mdot
.56385 .98023 Mdot
.56441 .02893 Mdot
.57202 .03009 Mdot
.57359 .03034 Mdot
.57405 .03042 Mdot
.57701 .78176 Mdot
.58687 .03271 Mdot
.58687 .97637 Mdot
.58795 .1996 Mdot
.58795 .03292 Mdot
.59681 .55998 Mdot
.5986 .8372 Mdot
.59902 .292 Mdot
.60088 .97345 Mdot
.60129 .03572 Mdot
.60431 .19036 Mdot
.60431 .03641 Mdot
.6069 .03701 Mdot
.60767 .0372 Mdot
.60815 .97177 Mdot
.60888 .75404 Mdot
.60888 .97159 Mdot
.61151 .90346 Mdot
.61255 .03839 Mdot
.61695 .03952 Mdot
.62082 .04054 Mdot
.62735 .65867 Mdot
.62735 .04235 Mdot
.62735 .96673 Mdot
.62983 .58614 Mdot
.63083 .82186 Mdot
.63083 .04335 Mdot
.63319 .05122 Mdot
.63406 .04431 Mdot
.63408 .39574 Mdot
.63746 .96374 Mdot
.64107 .04647 Mdot
.64107 .96261 Mdot
.64213 .78039 Mdot
.64213 .96227 Mdot
.64326 .96191 Mdot
.64753 .04857 Mdot
.64753 .96051 Mdot
.64924 .95994 Mdot
.64988 .28208 Mdot
.64988 .04935 Mdot
.65214 .07741 Mdot
.65214 .95895 Mdot
.65428 .95821 Mdot
.65574 .9577 Mdot
.65872 .07741 Mdot
.65983 .95624 Mdot
.66343 .95491 Mdot
.66371 .05427 Mdot
.66371 .95481 Mdot
.66581 .95402 Mdot
.66583 .20199 Mdot
.6738 .95092 Mdot
.68276 .94724 Mdot
.68292 .0619 Mdot
.68655 .59035 Mdot
.70863 .07367 Mdot
.70915 .63942 Mdot
.71067 .11676 Mdot
.71067 .07468 Mdot
.71199 .38652 Mdot
.71199 .93373 Mdot
.71701 .07791 Mdot
.71701 .93117 Mdot
.71818 .07852 Mdot
.71978 .54596 Mdot
.71978 .07935 Mdot
.71995 .07944 Mdot
.71995 .92964 Mdot
.72233 .72823 Mdot
.72874 .92489 Mdot
.73033 .67023 Mdot
.73035 .12344 Mdot
.73035 .08509 Mdot
.73062 .08524 Mdot
.73062 .92384 Mdot
.7311 .08551 Mdot
.73123 .9235 Mdot
.73206 .92303 Mdot
.73389 .90361 Mdot
.73389 .08708 Mdot
.73608 .15433 Mdot
.73608 .08834 Mdot
.73919 .91893 Mdot
.74255 .09215 Mdot
.74919 .09618 Mdot
.75026 .15216 Mdot
.75026 .09685 Mdot
.7523 .91095 Mdot
.75439 .84891 Mdot
.75718 .70935 Mdot
.76377 .90348 Mdot
.77052 .89887 Mdot
.77062 .11028 Mdot
.77175 .69055 Mdot
.77175 .89801 Mdot
.77552 .53505 Mdot
.77611 .34437 Mdot
.77611 .89491 Mdot
.77634 .51217 Mdot
.77634 .11433 Mdot
.7765 .89463 Mdot
.78311 .88979 Mdot
.78497 .63218 Mdot
.79047 .21923 Mdot
.79047 .12488 Mdot
.79112 .88369 Mdot
.7947 .26798 Mdot
.7947 .1282 Mdot
.80016 .24244 Mdot
.80016 .1326 Mdot
.80016 .87648 Mdot
.80373 .257 Mdot
.81228 .14286 Mdot
.81228 .86622 Mdot
.81232 .38441 Mdot
.81232 .86619 Mdot
.82118 .85824 Mdot
.82364 .15312 Mdot
.82618 .1555 Mdot
.82618 .85358 Mdot
.82735 .85246 Mdot
.82904 .85084 Mdot
.83998 .79416 Mdot
.83998 .83998 Mdot
.84027 .3334 Mdot
.84027 .16939 Mdot
.84031 .83965 Mdot
.84261 .17182 Mdot
.84261 .83726 Mdot
.84924 .20342 Mdot
.85574 .42965 Mdot
.85574 .18606 Mdot
.85682 .58567 Mdot
.85682 .18728 Mdot
.86016 .78176 Mdot
.86016 .19113 Mdot
.86133 .19249 Mdot
.86335 .81421 Mdot
.86462 .19638 Mdot
.8651 .81212 Mdot
.86721 .19952 Mdot
.86752 .19989 Mdot
.87627 .7982 Mdot
.8783 .59607 Mdot
.8783 .79554 Mdot
.88023 .793 Mdot
.88053 .4367 Mdot
.8842 .78762 Mdot
.88451 .22188 Mdot
.88488 .52111 Mdot
.88538 .38303 Mdot
.88547 .22321 Mdot
.88553 .27257 Mdot
.88553 .78579 Mdot
.88565 .36646 Mdot
.88716 .69233 Mdot
.89093 .40196 Mdot
.89093 .23092 Mdot
.89093 .77815 Mdot
.89891 .51487 Mdot
.89891 .76626 Mdot
.89895 .25136 Mdot
.89895 .24287 Mdot
.90029 .3563 Mdot
.90029 .24496 Mdot
.90229 .2481 Mdot
.90229 .76098 Mdot
.90425 .75785 Mdot
.90621 .25442 Mdot
.91167 .2636 Mdot
.91217 .26447 Mdot
.91323 .26631 Mdot
.91328 .74267 Mdot
.91611 .73765 Mdot
.91651 .54115 Mdot
.91651 .73692 Mdot
.91813 .39574 Mdot
.91961 .73123 Mdot
.92082 .28013 Mdot
.92128 .281 Mdot
.92224 .28284 Mdot
.92537 .28897 Mdot
.92537 .72011 Mdot
.92785 .59153 Mdot
.92785 .71509 Mdot
.92993 .66743 Mdot
.92993 .71078 Mdot
.93337 .3057 Mdot
.93337 .70338 Mdot
.93464 .42316 Mdot
.93464 .30851 Mdot
.93666 .69599 Mdot
.942 .53634 Mdot
.942 .3259 Mdot
.94588 .38441 Mdot
.9598 .37917 Mdot
.96179 .38681 Mdot
.96179 .62227 Mdot
.96429 .4114 Mdot
.96429 .39718 Mdot
.96818 .56943 Mdot
.9711 .43308 Mdot
.97563 .51721 Mdot
.97563 .4767 Mdot
.97619 .51037 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.4.8"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S3.4.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.4.9 Equations and Inequalities over Domains", "Subsection",
  CellTags->{"S3.4.9", "9.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " normally assumes that variables which appear in equations can stand for \
arbitrary complex numbers. But when you use ",
  StyleBox["Reduce", "MR"],
  ", you can explicitly tell ",
  StyleBox["Mathematica", "TI"],
  " that the variables stand for objects in more restricted domains. "
}], "Text",
  CellTags->{"S3.4.9", "9.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Reduce[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["vars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dom", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "reduce ",
              StyleBox["eqns", "TI"],
              " over the domain ",
              StyleBox["dom", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Complexes", "MR"],
              " "
            }]], Cell[TextData[{
              "complex numbers ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalC]\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Reals", "MR"],
              " "
            }]], Cell[TextData[{
              "real numbers ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalR]\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Integers", "MR"],
              " "
            }]], Cell[TextData[{
              "integers ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalZ]\)], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S3.4.9"],

Cell["Solving over domains. ", "Caption",
  CellTags->"S3.4.9"],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " by default assumes that ",
  StyleBox["x", "MR"],
  " can be complex, and gives all five complex solutions. "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.3"}],

Cell[CellGroupData[{

Cell["Reduce[x^6 - x^4 - 4x^2 + 4 == 0, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(x \[Equal] \(-1\) || x \[Equal] 1 || x \[Equal] \(-\@2\) || 
      x \[Equal] \(-\[ImaginaryI]\)\ \@2 || x \[Equal] \[ImaginaryI]\ \@2 || 
      x \[Equal] \@2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "But here it assumes that ",
  StyleBox["x", "MR"],
  " is real, and gives only the real solutions. "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.4"}],

Cell[CellGroupData[{

Cell["Reduce[x^6 - x^4 - 4x^2 + 4 == 0, x, Reals]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(x \[Equal] \(-1\) || x \[Equal] 1 || x \[Equal] \(-\@2\) || 
      x \[Equal] \@2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "And here it assumes that ",
  StyleBox["x", "MR"],
  " is an integer, and gives only the integer solutions. "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.5"}],

Cell[CellGroupData[{

Cell["Reduce[x^6 - x^4 - 4x^2 + 4 == 0, x, Integers]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(x \[Equal] \(-1\) || x \[Equal] 1\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "A single polynomial equation in one variable will always have a finite set \
of discrete solutions. And in such a case one can think of ",
  StyleBox["Reduce[", "MR"],
  StyleBox["eqns", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["vars", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["dom", "TI"],
  StyleBox["]", "MR"],
  " as just filtering the solutions by selecting the ones that happen to lie \
in the domain ",
  StyleBox["dom", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.4.9", "9.6"}],

Cell["\<\
But as soon as there are more variables, things can become more \
complicated, with solutions to equations corresponding to parametric curves \
or surfaces in which the values of some variables can depend on the values of \
others. Often this dependence can be described by some collection of \
equations or inequalities, but the form of these can change significantly \
when one goes from one domain to another. \
\>", "Text",
  CellTags->{"S3.4.9", "9.7"}],

Cell["\<\
This gives solutions over the complex numbers as simple formulas. \
\
\>", "MathCaption",
  CellTags->{"S3.4.9", "9.8"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 + y^2 == 1, {x, y}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(y \[Equal] \(-\@\(1 - x\^2\)\) || y \[Equal] \@\(1 - x\^2\)\)], "Output",\

  CellLabel->"Out[4]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell["\<\
To represent solutions over the reals requires introducing an \
inequality. \
\>", "MathCaption",
  CellTags->{"S3.4.9", "9.9"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 + y^2 == 1, {x, y}, Reals]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\(-1\) \[LessEqual] x \[LessEqual] 
        1 && \((y \[Equal] \(-\@\(1 - x\^2\)\) || 
          y \[Equal] \@\(1 - x\^2\))\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell["\<\
Over the integers, the solution can be represented as equations for \
discrete points. \
\>", "MathCaption",
  CellTags->{"S3.4.9", "9.10"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 + y^2 == 1, {x, y}, Integers]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((x \[Equal] \(-1\) && y \[Equal] 0)\) || \((x \[Equal] 0 && 
          y \[Equal] \(-1\))\) || \((x \[Equal] 0 && 
          y \[Equal] 1)\) || \((x \[Equal] 1 && y \[Equal] 0)\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "If your input involves only equations, then ",
  StyleBox["Reduce", "MR"],
  " will by default assume that all variables are complex. But if your input \
involves inequalities, then ",
  StyleBox["Reduce", "MR"],
  " will assume that any algebraic variables appearing in them are real, \
since inequalities can only compare real quantities. "
}], "Text",
  CellTags->{"S3.4.9", "9.11"}],

Cell["\<\
Since the variables appear in an inequality, they are assumed to be \
real. \
\>", "MathCaption",
  CellTags->{"S3.4.9", "9.12"}],

Cell[CellGroupData[{

Cell["Reduce[{x + y + z == 1, x^2 + y^2 + z^2 < 1}, {x, y, z}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\(-\(1\/3\)\) < x < 
        1 && \(1 - x\)\/2 - 1\/2\ \@\(1 + 2\ x - 3\ x\^2\) < 
        y < \(1 - x\)\/2 + 1\/2\ \@\(1 + 2\ x - 3\ x\^2\) && 
      z \[Equal] 1 - x - y\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Complexes", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["polynomial", "TI"],
              " ",
              StyleBox["!=", "MR"],
              " ",
              StyleBox["0", "MR"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["Root[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Reals", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Root[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " ",
              StyleBox["<", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " < Root[ \[Ellipsis] ]",
              StyleBox[", ", "TR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["Root[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Integers", "MR"],
              " "
            }]], Cell["arbitrarily complicated "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.9"],

Cell["\<\
Schematic building blocks for solutions to polynomial equations and \
inequalities. \
\>", "Caption",
  CellTags->"S3.4.9"],

Cell["\<\
For systems of polynomials over real and complex domains, the \
solutions always consist of a finite number of components, within which the \
values of variables are given by algebraic numbers or functions. \
\>", "Text",\

  CellTags->{"S3.4.9", "9.13"}],

Cell[TextData[{
  "Here the components are distinguished by equations and inequations on ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.14"}],

Cell[CellGroupData[{

Cell["Reduce[x y^3 + y == 1, {x, y}, Complexes]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((x \[Equal] 0 && 
          y \[Equal] 1)\) || \((x \[NotEqual] 
            0 && \((y \[Equal] Root[\(-1\) + #1 + x\ #1\^3 &, 1] || 
              y \[Equal] Root[\(-1\) + #1 + x\ #1\^3 &, 2] || 
              y \[Equal] Root[\(-1\) + #1 + x\ #1\^3 &, 3])\))\)\)], "Output",\

  CellLabel->"Out[8]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "And here the components are distinguished by inequalities on ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.15"}],

Cell[CellGroupData[{

Cell["Reduce[x y^3 + y == 1, {x, y}, Reals]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((x < \(-\(4\/27\)\) && 
          y \[Equal] 
            Root[\(-1\) + #1 + x\ #1\^3 &, 
              1])\) || \((x \[Equal] \(-\(4\/27\)\) && \((y \[Equal] \(-3\) || 
              y \[Equal] 3\/2)\))\) || \((\(-\(4\/27\)\) < x < 
            0 && \((y \[Equal] Root[\(-1\) + #1 + x\ #1\^3 &, 1] || 
              y \[Equal] Root[\(-1\) + #1 + x\ #1\^3 &, 2] || 
              y \[Equal] 
                Root[\(-1\) + #1 + x\ #1\^3 &, 
                  3])\))\) || \((x \[GreaterEqual] 0 && 
          y \[Equal] Root[\(-1\) + #1 + x\ #1\^3 &, 1])\)\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "While in principle ",
  StyleBox["Reduce", "MR"],
  " can always find the complete solution to any collection of polynomial \
equations and inequalities with real or complex variables, the results are \
often very complicated, with the number of components typically growing \
exponentially as the number of variables increases. "
}], "Text",
  CellTags->{"S3.4.9", "9.16"}],

Cell["\<\
With 3 variables, the solution here already involves 8 components. \
\
\>", "MathCaption",
  CellTags->{"S3.4.9", "9.17"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 == y^2 == z^2 == 1, {x, y, z}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((z \[Equal] \(-1\) && y \[Equal] \(-1\) && 
          x \[Equal] \(-1\))\) || \((z \[Equal] \(-1\) && y \[Equal] \(-1\) && 
          x \[Equal] 1)\) || \((z \[Equal] \(-1\) && y \[Equal] 1 && 
          x \[Equal] \(-1\))\) || \((z \[Equal] \(-1\) && y \[Equal] 1 && 
          x \[Equal] 1)\) || \((z \[Equal] 1 && y \[Equal] \(-1\) && 
          x \[Equal] \(-1\))\) || \((z \[Equal] 1 && y \[Equal] \(-1\) && 
          x \[Equal] 1)\) || \((z \[Equal] 1 && y \[Equal] 1 && 
          x \[Equal] \(-1\))\) || \((z \[Equal] 1 && y \[Equal] 1 && 
          x \[Equal] 1)\)\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "As soon as one introduces functions like ",
  StyleBox["Sin", "MR"],
  " or ",
  StyleBox["Exp", "MR"],
  ", even equations in single real or complex variables can have solutions \
with an infinite number of components. ",
  StyleBox["Reduce", "MR"],
  " labels these components by introducing additional parameters. By default, \
the ",
  StyleBox["n", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " parameter in a given solution will be named ",
  StyleBox["C[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ". In general you can specify that it should be named ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " by giving the option setting ",
  StyleBox["GeneratedParameters", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["f", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.4.9", "9.18"}],

Cell[TextData[{
  "The components here are labeled by the integer parameter ",
  Cell[BoxData[
      \(c\_1\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.19"}],

Cell[CellGroupData[{

Cell["\<\
Reduce[Exp[x] == 2, x, GeneratedParameters -> (Subscript[c, #]&)]\
\
\>", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(c\_1 \[Element] Integers && 
      x \[Equal] Log[2] + 2\ \[ImaginaryI]\ \[Pi]\ c\_1\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " can handle equations not only over real and complex variables, but also \
over integers. Solving such ",
  StyleBox["Diophantine equations", "TI"],
  " can often be a very difficult problem. "
}], "Text",
  CellTags->{"S3.4.9", "9.20"}],

Cell["\<\
Describing the solution to this equation over the reals is \
straightforward. \
\>", "MathCaption",
  CellTags->{"S3.4.9", "9.21"}],

Cell[CellGroupData[{

Cell["Reduce[x y == 8, {x, y}, Reals]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((x < 0 || x > 0)\) && y \[Equal] 8\/x\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell["The solution over the integers involves the divisors of 8. ", \
"MathCaption",
  CellTags->{"S3.4.9", "9.22"}],

Cell[CellGroupData[{

Cell["Reduce[x y == 8, {x, y}, Integers]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((x \[Equal] \(-8\) && y \[Equal] \(-1\))\) || \((x \[Equal] \(-4\) && 
          y \[Equal] \(-2\))\) || \((x \[Equal] \(-2\) && 
          y \[Equal] \(-4\))\) || \((x \[Equal] \(-1\) && 
          y \[Equal] \(-8\))\) || \((x \[Equal] 1 && 
          y \[Equal] 8)\) || \((x \[Equal] 2 && 
          y \[Equal] 4)\) || \((x \[Equal] 4 && 
          y \[Equal] 2)\) || \((x \[Equal] 8 && y \[Equal] 1)\)\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell["\<\
Solving an equation like this effectively requires factoring a \
large number. \
\>", "MathCaption",
  CellTags->{"S3.4.9", "9.23"}],

Cell[CellGroupData[{

Cell["Reduce[{x y == 7777777, x > y > 0}, {x, y}, Integers]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((x \[Equal] 4649 && y \[Equal] 1673)\) || \((x \[Equal] 32543 && 
          y \[Equal] 239)\) || \((x \[Equal] 1111111 && 
          y \[Equal] 7)\) || \((x \[Equal] 7777777 && 
          y \[Equal] 1)\)\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " can solve any system of linear equations or inequalities over the \
integers. With ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " linear equations in ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " variables, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "-", 
          StyleBox["m",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " parameters typically need to be introduced. But with inequalities, a much \
larger number of parameters may be needed. "
}], "Text",
  CellTags->{"S3.4.9", "9.24"}],

Cell["\<\
Three parameters are needed here, even though there are only two \
variables. \
\>", "MathCaption",
  CellTags->{"S3.4.9", "9.25"}],

Cell[CellGroupData[{

Cell["Reduce[{3x - 2y > 1, x > 0, y > 0}, {x, y}, Integers]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((C[1] | C[2] | C[3])\) \[Element] Integers && C[1] \[GreaterEqual] 0 && 
      C[2] \[GreaterEqual] 0 && 
      C[3] \[GreaterEqual] 
        0 && \((\((x \[Equal] 2 + 2\ C[1] + C[2] + C[3] && 
              y \[Equal] 2 + 3\ C[1] + C[2])\) || \((x \[Equal] 
                2 + 2\ C[1] + C[2] + C[3] && 
              y \[Equal] 1 + 3\ C[1] + C[2])\))\)\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "With two variables, ",
  StyleBox["Reduce", "MR"],
  " can solve any quadratic equation over the integers. The result can be a \
Fibonacci\[Hyphen]like sequence, represented in terms of powers of quadratic \
irrationals. "
}], "Text",
  CellTags->{"S3.4.9", "9.26"}],

Cell["Here is the solution to a Pell equation. ", "MathCaption",
  CellTags->{"S3.4.9", "9.27"}],

Cell[CellGroupData[{

Cell["Reduce[{x^2 == 13 y^2 + 1, x > 0, y > 0}, {x, y}, Integers]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(C[1] \[Element] Integers && C[1] \[GreaterEqual] 1 && 
      x \[Equal] 
        1\/2\ \((\((649 - 180\ \@13)\)\^C[1] + \((649 + 180\ \@13)\)\^C[1])\) \
&& y \[Equal] \(-\(\(\((649 - 180\ \@13)\)\^C[1] - \((649 + 180\ \
\@13)\)\^C[1]\)\/\(2\ \@13\)\)\)\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "The actual values for specific ",
  StyleBox["C[1]", "MR"],
  " as integers, as they should be. "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.28"}],

Cell[CellGroupData[{

Cell["FullSimplify[% /. Table[{C[1] -> i}, {i, 4}]]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \({x \[Equal] 649 && y \[Equal] 180, 
      x \[Equal] 842401 && y \[Equal] 233640, 
      x \[Equal] 1093435849 && y \[Equal] 303264540, 
      x \[Equal] 1419278889601 && y \[Equal] 393637139280}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " can handle many specific classes of equations over the integers. "
}], "Text",
  CellTags->{"S3.4.9", "9.29"}],

Cell[TextData[{
  "Here ",
  StyleBox["Reduce", "MR"],
  " finds the solution to a Thue equation. "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.30"}],

Cell[CellGroupData[{

Cell["Reduce[x^3 - 4 x y^2 + y^3 == 1, {x, y}, Integers]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((x \[Equal] \(-2\) && y \[Equal] 1)\) || \((x \[Equal] 0 && 
          y \[Equal] 1)\) || \((x \[Equal] 1 && 
          y \[Equal] 0)\) || \((x \[Equal] 1 && 
          y \[Equal] 4)\) || \((x \[Equal] 2 && 
          y \[Equal] 1)\) || \((x \[Equal] 508 && 
          y \[Equal] 273)\)\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "Changing the right\[Hyphen]hand side to ",
  StyleBox["3", "MR"],
  ", the equation now has no solution. "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.31"}],

Cell[CellGroupData[{

Cell["Reduce[x^3 - 4 x y^2 + y^3 == 3, {x, y}, Integers]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell["\<\
Equations over the integers sometimes have seemingly quite random \
collections of solutions. And even small changes in equations can often lead \
them to have no solutions at all. \
\>", "Text",
  CellTags->{"S3.4.9", "9.32"}],

Cell[TextData[{
  "For polynomial equations over real and complex numbers, there is a \
definite ",
  StyleBox["decision procedure", "TI"],
  " for determining whether or not any solution exists. But for polynomial \
equations over the integers, the unsolvability of Hilbert's Tenth Problem \
demonstrates that there can never be any such general procedure. "
}], "Text",
  CellTags->{"S3.4.9", "9.33"}],

Cell[TextData[{
  "For specific classes of equations, however, procedures can be found, and \
indeed many are implemented in ",
  StyleBox["Reduce", "MR"],
  ". But handling different classes of equations can often seem to require \
whole different branches of number theory, and quite different kinds of \
computations. And in fact it is known that there are ",
  StyleBox["universal", "TI"],
  " integer polynomial equations, for which filling in some variables can \
make solutions for other variables correspond to the output of absolutely any \
possible program. This then means that for such equations there can never in \
general be any closed\[Hyphen]form solution built from fixed elements like \
algebraic functions. "
}], "Text",
  CellTags->{"S3.4.9", "9.34"}],

Cell[TextData[{
  "If one includes functions like ",
  StyleBox["Sin", "MR"],
  ", then even for equations involving real and complex numbers the same \
issues can arise. "
}], "Text",
  CellTags->{"S3.4.9", "9.35"}],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " here effectively has to solve an equation over the integers. "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.36"}],

Cell[CellGroupData[{

Cell["\<\
Reduce[Sin[Pi x]^2 + Sin[Pi y]^2 + (x^2 + y^2 - 25)^2 == 0, {x, y}, \
Reals]\
\>", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((x \[Equal] \(-5\) && 
          y \[Equal] 
            0)\) || \((x \[Equal] \(-4\) && \((y \[Equal] \(-3\) || 
              y \[Equal] 
                3)\))\) || \((x \[Equal] \(-3\) && \((y \[Equal] \(-4\) || 
              y \[Equal] 4)\))\) || \((x \[Equal] 
            0 && \((y \[Equal] \(-5\) || y \[Equal] 5)\))\) || \((x \[Equal] 
            3 && \((y \[Equal] \(-4\) || y \[Equal] 4)\))\) || \((x \[Equal] 
            4 && \((y \[Equal] \(-3\) || y \[Equal] 3)\))\) || \((x \[Equal] 
            5 && y \[Equal] 0)\)\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Reduce[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["vars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Modulus->", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find solutions modulo ",
              StyleBox["n", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.9"],

Cell[TextData[{
  "Handling equations involving integers modulo ",
  StyleBox["n", "TI"],
  ". "
}], "Caption",
  CellTags->"S3.4.9"],

Cell[TextData[{
  "Since there are only ever a finite number of possible solutions for \
integer equations modulo ",
  StyleBox["n", "TI"],
  ", ",
  StyleBox["Reduce", "MR"],
  " can systematically find them. "
}], "Text",
  CellTags->{"S3.4.9", "9.37"}],

Cell["This finds all solutions modulo 4. ", "MathCaption",
  CellTags->{"S3.4.9", "9.38"}],

Cell[CellGroupData[{

Cell["Reduce[x^5 == y^4 + x y + 1, {x, y}, Modulus -> 4]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((x \[Equal] 1 && y \[Equal] 0)\) || \((x \[Equal] 1 && 
          y \[Equal] 3)\) || \((x \[Equal] 2 && 
          y \[Equal] 1)\) || \((x \[Equal] 2 && 
          y \[Equal] 3)\) || \((x \[Equal] 3 && 
          y \[Equal] 2)\) || \((x \[Equal] 3 && y \[Equal] 3)\)\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " can also handle equations that involve several different moduli. "
}], "Text",
  CellTags->{"S3.4.9", "9.39"}],

Cell["Here is an equation involving two different moduli. ", "MathCaption",
  CellTags->{"S3.4.9", "9.40"}],

Cell[CellGroupData[{

Cell["Reduce[Mod[2x + 1, 5] == Mod[x, 7] && 0 < x < 50, x]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(x \[Equal] 4 || x \[Equal] 7 || x \[Equal] 15 || x \[Equal] 23 || 
      x \[Equal] 31 || x \[Equal] 39 || x \[Equal] 42\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Reduce[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["vars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dom", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["specify a default domain for all variables "]},
          {Cell[TextData[{
              StyleBox["Reduce[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\` \[Element] \)], "InlineFormula"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["dom",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, ",
              StyleBox["vars", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "explicitly specify individual domains for variables "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.9"],

Cell["Different ways to specify domains for variables. ", "Caption",
  CellTags->"S3.4.9"],

Cell[TextData[{
  "This assumes that ",
  StyleBox["x", "MR"],
  " is an integer, but ",
  StyleBox["y", "MR"],
  " is a real. "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.41"}],

Cell[CellGroupData[{

Cell["\<\
Reduce[{x^2 + 2y^2 == 1, x \[Element] Integers, y \[Element] \
Reals}, {x, y}]\
\>", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((x \[Equal] \(-1\) && 
          y \[Equal] 0)\) || \((x \[Equal] 
            0 && \((y \[Equal] \(-\(1\/\@2\)\) || 
              y \[Equal] 1\/\@2)\))\) || \((x \[Equal] 1 && 
          y \[Equal] 0)\)\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " normally treats complex variables as single objects. But in dealing with \
functions that are not analytic or have branch cuts, it sometimes has to \
break them into pairs of real variables ",
  StyleBox["Re[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["Im[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.4.9", "9.42"}],

Cell["The result involves separate real and imaginary parts. ", "MathCaption",
  CellTags->{"S3.4.9", "9.43"}],

Cell[CellGroupData[{

Cell["Reduce[Abs[z] == 1, z]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\(-1\) \[LessEqual] Re[z] \[LessEqual] 
        1 && \((Im[z] \[Equal] \(-\@\(1 - Re[z]\^2\)\) || 
          Im[z] \[Equal] \@\(1 - Re[z]\^2\))\)\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell["\<\
Here again there is a separate condition on the imaginary part. \
\
\>", "MathCaption",
  CellTags->{"S3.4.9", "9.44"}],

Cell[CellGroupData[{

Cell["Reduce[Log[z] == a, {a, z}]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\(-\[Pi]\) < Im[a] \[LessEqual] \[Pi] && 
      z \[Equal] \[ExponentialE]\^a\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " by default assumes that variables that appear algebraically in \
inequalities are real. But you can override this by explicitly specifying ",
  StyleBox["Complexes", "MR"],
  " as the default domain. It is often useful in such cases to be able to \
specify that certain variables are still real. "
}], "Text",
  CellTags->{"S3.4.9", "9.45"}],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " by default assumes that ",
  StyleBox["x", "MR"],
  " is a real. "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.46"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 < 1, x]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\(-1\) < x < 1\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "This forces ",
  StyleBox["Reduce", "MR"],
  " to consider the case where ",
  StyleBox["x", "MR"],
  " can be complex. "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.47"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 < 1, x, Complexes]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((\(-1\) < Re[x] < 0 && Im[x] \[Equal] 0)\) || 
      Re[x] \[Equal] 0 || \((0 < Re[x] < 1 && Im[x] \[Equal] 0)\)\)], "Output",\

  CellLabel->"Out[27]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "Since ",
  StyleBox["x", "MR"],
  " does not appear algebraically, ",
  StyleBox["Reduce", "MR"],
  " immediately assumes that it can be complex. "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.48"}],

Cell[CellGroupData[{

Cell["Reduce[Abs[x] < 1, x]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\(-1\) < Re[x] < 1 && \(-\@\(1 - Re[x]\^2\)\) < 
        Im[x] < \@\(1 - Re[x]\^2\)\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["x", "MR"],
  " is a real, but ",
  StyleBox["y", "MR"],
  " can be complex. "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.49"}],

Cell[CellGroupData[{

Cell["\<\
Reduce[{Abs[y] < Abs[x], x \[Element] Reals}, {x, y}]\
\>", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \(\((x < 0 && \(-\@x\^2\) < 
            Re[y] < \@x\^2 && \(-\@\(x\^2 - Re[y]\^2\)\) < 
            Im[y] < \@\(x\^2 - Re[y]\^2\))\) || \((x > 0 && \(-\@x\^2\) < 
            Re[y] < \@x\^2 && \(-\@\(x\^2 - Re[y]\^2\)\) < 
            Im[y] < \@\(x\^2 - Re[y]\^2\))\)\)], "Output",
  CellLabel->"Out[29]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FindInstance[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["dom", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to find an instance of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " in ",
              StyleBox["dom", "TI"],
              " satisfying ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FindInstance[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["vars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dom", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to find ",
              StyleBox["n", "TI"],
              " instances "
            }]]},
          {Cell[TextData[{
              StyleBox["Complexes", "MR"],
              " "
            }]], Cell[TextData[{
              "the domain of complex numbers ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalC]\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Reals", "MR"],
              " "
            }]], Cell[TextData[{
              "the domain of real numbers ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalR]\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Integers", "MR"],
              " "
            }]], Cell[TextData[{
              "the domain of integers ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalZ]\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Booleans", "MR"],
              " "
            }]], Cell[TextData[{
              "the domain of booleans (",
              StyleBox["True", "MR"],
              " and ",
              StyleBox["False", "MR"],
              ") ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DoubleStruckCapitalB]\)], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S3.4.9"],

Cell["Finding particular solutions in domains. ", "Caption",
  CellTags->"S3.4.9"],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " always returns a complete representation of the solution to a system of \
equations or inequalities. Sometimes, however, you may just want to find \
particular sample solutions. You can do this using ",
  StyleBox["FindInstance", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.4.9", "9.50"}],

Cell[TextData[{
  "If ",
  StyleBox["FindInstance[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["vars", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["dom", "TI"],
  StyleBox["]", "MR"],
  " returns ",
  StyleBox["{}", "MR"],
  " then this means that ",
  StyleBox["Mathematica", "TI"],
  " has effectively proved that ",
  StyleBox["expr", "TI"],
  " cannot be satisfied for any values of variables in the specified domain. \
When ",
  StyleBox["expr", "TI"],
  " can be satisfied, ",
  StyleBox["FindInstance", "MR"],
  " will normally pick quite arbitrarily among values that do this, as \
discussed for inequalities in Section\[NonBreakingSpace]",
  ButtonBox["3.4.8",
    ButtonData:>{"3.4.8", "8.35"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S3.4.9", "9.51"}],

Cell[TextData[{
  "Particularly for integer equations, ",
  StyleBox["FindInstance", "MR"],
  " can often find particular solutions to equations even when ",
  StyleBox["Reduce", "MR"],
  " cannot find a complete solution. In such cases it usually returns one of \
the smallest solutions to the equations. "
}], "Text",
  CellTags->{"S3.4.9", "9.52"}],

Cell["This finds the smallest integer point on an elliptic curve. ", \
"MathCaption",
  CellTags->{"S3.4.9", "9.53"}],

Cell[CellGroupData[{

Cell["\<\
FindInstance[{x^2 == y^3 + 12, x > 0, y > 0}, {x, y}, \
Integers]\
\>", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \({{x \[Rule] 47, y \[Rule] 13}}\)], "Output",
  CellLabel->"Out[30]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell[TextData[{
  "One feature of ",
  StyleBox["FindInstance", "MR"],
  " is that it also works with Boolean expressions whose variables can have \
values ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  ". You can use ",
  StyleBox["FindInstance", "MR"],
  " to determine whether a particular expression is ",
  StyleBox["satisfiable", "TI"],
  ", so that there is some choice of truth values for its variables that \
makes the expression ",
  StyleBox["True", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.4.9", "9.54"}],

Cell[TextData[{
  "This expression cannot be satisfied for any choice of ",
  StyleBox["p", "MR"],
  " and ",
  StyleBox["q", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.9", "9.55"}],

Cell[CellGroupData[{

Cell["FindInstance[p && ! (p || ! q), {p, q}, Booleans]", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[31]= ",
  CellTags->"S3.4.9"]
}, Open  ]],

Cell["But this can. ", "MathCaption",
  CellTags->{"S3.4.9", "9.56"}],

Cell[CellGroupData[{

Cell["FindInstance[p && ! (! p || ! q), {p, q}, Booleans]", "Input",
  CellLabel->"In[32]:= ",
  CellTags->"S3.4.9"],

Cell[BoxData[
    \({{p \[Rule] True, q \[Rule] True}}\)], "Output",
  CellLabel->"Out[32]= ",
  CellTags->"S3.4.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.4.10 Advanced Topic: The Representation of Solution Sets", \
"Subsection",
  CellTags->{"S3.4.10", "10.1"}],

Cell[TextData[{
  "One can think of any combination of equations or inequalities as \
implicitly defining a region in some kind of space. The fundamental function \
of ",
  StyleBox["Reduce", "MR"],
  " is to turn this type of implicit description into an explicit one. "
}], "Text",
  CellTags->{"S3.4.10", "10.2"}],

Cell[TextData[{
  "An implicit description in terms of equations or inequalities is \
sufficient if one just wants to test whether a point specified by values of \
variables is in the region. But to understand the structure of the region, or \
to generate points in it, one typically needs a more explicit description, of \
the kind obtained from ",
  StyleBox["Reduce", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.4.10", "10.3"}],

Cell["\<\
Here are inequalities that implicitly define a semicircular region. \
\
\>", "MathCaption",
  CellTags->{"S3.4.10", "10.4"}],

Cell[CellGroupData[{

Cell["semi = x > 0 && x^2 + y^2 < 1", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.4.10"],

Cell[BoxData[
    \(x > 0 && x\^2 + y\^2 < 1\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.4.10"]
}, Open  ]],

Cell[TextData[{
  "This shows that the point ",
  Cell[BoxData[
      \(TraditionalForm\`\((1/2, 1/2)\)\)], "InlineFormula"],
  " lies in the region. "
}], "MathCaption",
  CellTags->{"S3.4.10", "10.5"}],

Cell[CellGroupData[{

Cell["semi /. { x -> 1/2, y -> 1/2 }", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.4.10"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.4.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " gives a more explicit representation of the region. "
}], "MathCaption",
  CellTags->{"S3.4.10", "10.6"}],

Cell[CellGroupData[{

Cell["Reduce[semi, {x, y}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.4.10"],

Cell[BoxData[
    \(0 < x < 1 && \(-\@\(1 - x\^2\)\) < y < \@\(1 - x\^2\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.4.10"]
}, Open  ]],

Cell[TextData[{
  "If we pick a value for ",
  StyleBox["x", "MR"],
  " consistent with the first inequality, we then immediately get an explicit \
inequality for ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.10", "10.7"}],

Cell[CellGroupData[{

Cell["% /. x -> 1/2", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.4.10"],

Cell[BoxData[
    \(\(-\(\@3\/2\)\) < y < \@3\/2\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.4.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " is set up to describe regions by first giving fixed conditions for ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  ", then giving conditions for ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " that depend on ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  ", then conditions for ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "3"], TraditionalForm]], "InlineFormula"],
  " that depend on ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  ", and so on. This structure has the feature that it allows one to pick \
points by successively choosing values for each of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " in turn\[LongDash]in much the same way as when one uses iterators in \
functions like ",
  StyleBox["Table", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.4.10", "10.8"}],

Cell[TextData[{
  "This gives a representation for the region in which one first picks a \
value for ",
  StyleBox["y", "MR"],
  ", then ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.10", "10.9"}],

Cell[CellGroupData[{

Cell["Reduce[semi, {y, x}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.4.10"],

Cell[BoxData[
    \(\(-1\) < y < 1 && 0 < x < \@\(1 - y\^2\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.4.10"]
}, Open  ]],

Cell[TextData[{
  "In some simple cases the region defined by a system of equations or \
inequalities will end up having only one component. In such cases, the output \
from ",
  StyleBox["Reduce", "MR"],
  " will be of the form ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  " where each of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " is an equation or inequality involving variables up to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.4.10", "10.10"}],

Cell[TextData[{
  "In most cases, however, there will be several components, represented by \
output containing forms such as ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["||", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["||", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  ". ",
  StyleBox["Reduce", "MR"],
  " typically tries to minimize the number of components used in describing a \
region. But in some cases multiple parametrizations may be needed to cover a \
single connected component, and each one of these will appear as a separate \
component in the output from ",
  StyleBox["Reduce", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.4.10", "10.11"}],

Cell[TextData[{
  "In representing solution sets, it is common to find that several \
components can be described together by using forms such as \[Ellipsis]",
  "  ",
  StyleBox["&&", "MR"],
  " ",
  StyleBox["(", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["||", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[")", "MR"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  ". ",
  StyleBox["Reduce", "MR"],
  " by default does this so as to return its results as compactly as \
possible. You can use ",
  StyleBox["LogicalExpand", "MR"],
  " to generate an expanded form in which each component appears separately. \
"
}], "Text",
  CellTags->{"S3.4.10", "10.12"}],

Cell[TextData[{
  "In generating the most compact results, ",
  StyleBox["Reduce", "MR"],
  " sometimes ends up making conditions on later variables ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " depend on more of the earlier ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " than is strictly necessary. You can force ",
  StyleBox["Reduce", "MR"],
  " to generate results in which a particular ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " only has minimal dependence on earlier ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " by giving the option ",
  StyleBox["Backsubstitution->True", "MR"],
  ". Usually this will lead to much larger output, although sometimes it may \
be easier to interpret.  "
}], "Text",
  CellTags->{"S3.4.10", "10.13"}],

Cell[TextData[{
  "By default, ",
  StyleBox["Reduce", "MR"],
  " expresses the condition on ",
  StyleBox["y", "MR"],
  " in terms of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.10", "10.14"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 + y == 4 && x^3 - 4y == 8, {x, y}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.4.10"],

Cell[BoxData[
    \(\((x \[Equal] 2 || x \[Equal] \(-3\) - \[ImaginaryI]\ \@3 || 
          x \[Equal] \(-3\) + \[ImaginaryI]\ \@3)\) && 
      y \[Equal] 4 - x\^2\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.4.10"]
}, Open  ]],

Cell[TextData[{
  "Backsubstituting allows conditions for ",
  StyleBox["y", "MR"],
  " to be given without involving ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.10", "10.15"}],

Cell[CellGroupData[{

Cell["\<\
Reduce[x^2 + y == 4 && x^3 - 4y == 8, {x, y}, Backsubstitution -> \
True]\
\>", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.4.10"],

Cell[BoxData[
    \(\((x \[Equal] 2 && 
          y \[Equal] 
            0)\) || \((x \[Equal] \(-\[ImaginaryI]\)\ \((\(-3\)\ \
\[ImaginaryI] + \@3)\) && 
          y \[Equal] \(-2\)\ \[ImaginaryI]\ \((\(-\[ImaginaryI]\) + 
                  3\ \@3)\))\) || \((x \[Equal] \[ImaginaryI]\ \((3\ \
\[ImaginaryI] + \@3)\) && 
          y \[Equal] 
            2\ \[ImaginaryI]\ \((\[ImaginaryI] + 3\ \@3)\))\)\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.4.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CylindricalDecomposition[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate the cylindrical algebraic decomposition of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.10"],

Cell["Cylindrical algebraic decomposition. ", "Caption",
  CellTags->"S3.4.10"],

Cell[TextData[{
  "For polynomial equations or inequalities over the reals, the structure of \
the result returned by ",
  StyleBox["Reduce", "MR"],
  " is typically a ",
  StyleBox["cylindrical algebraic decomposition", "TI"],
  " or ",
  StyleBox["CAD", "TI"],
  ". Sometimes ",
  StyleBox["Reduce", "MR"],
  " can yield a simpler form. But in all cases you can get the complete CAD \
by using ",
  StyleBox["CylindricalDecomposition", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.4.10", "10.16"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.4.11 Advanced Topic: Quantifiers", "Subsection",
  CellTags->{"S3.4.11", "11.1"}],

Cell[TextData[{
  "In a statement like ",
  StyleBox["x^4", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox[">", "MR"],
  " ",
  StyleBox["0", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " treats the variable ",
  StyleBox["x", "MR"],
  " as having a definite, though unspecified, value. Sometimes, however, it \
is useful to be able to make statements about whole collections of possible \
values for ",
  StyleBox["x", "MR"],
  ". You can do this using ",
  StyleBox["quantifiers", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.4.11", "11.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ForAll[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["expr", "TI"],
              " holds for all values of ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ForAll[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["expr", "TI"],
              " holds for all values of all the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ForAll[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["cond", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["expr", "TI"],
              " holds for all ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " satisfying ",
              StyleBox["cond", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Exists[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "there exists a value of ",
              StyleBox["x", "TI"],
              " for which ",
              StyleBox["expr", "TI"],
              " holds "
            }]]},
          {Cell[TextData[{
              StyleBox["Exists[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "there exist values of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " for which ",
              StyleBox["expr", "TI"],
              " holds "
            }]]},
          {Cell[TextData[{
              StyleBox["Exists[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["cond", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "there exist values of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " satisfying ",
              StyleBox["cond", "TI"],
              " for which ",
              StyleBox["expr", "TI"],
              " holds "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False}},
  CellTags->"S3.4.11"],

Cell["The structure of quantifiers. ", "Caption",
  CellTags->"S3.4.11"],

Cell[TextData[{
  "You can work with quantifiers in ",
  StyleBox["Mathematica", "TI"],
  " much as you work with equations, inequalities or logical connectives. In \
most cases, the quantifiers will not immediately be changed by evaluation. \
But they can be simplified or reduced by functions like ",
  StyleBox["FullSimplify", "MR"],
  " and ",
  StyleBox["Reduce", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.4.11", "11.3"}],

Cell[TextData[{
  "This asserts that an ",
  StyleBox["x", "MR"],
  " exists that makes the inequality true. The output here is just a \
formatted version of the input. "
}], "MathCaption",
  CellTags->{"S3.4.11", "11.4"}],

Cell[CellGroupData[{

Cell["Exists[x, x^4 + x^2 > 0]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(\[Exists] \_x x\^2 + x\^4 > 0\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.4.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FullSimplify", "MR"],
  " establishes that the assertion is true. "
}], "MathCaption",
  CellTags->{"S3.4.11", "11.5"}],

Cell[CellGroupData[{

Cell["FullSimplify[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.4.11"]
}, Open  ]],

Cell[TextData[{
  "This gives ",
  StyleBox["False", "MR"],
  ", since the inequality fails when ",
  StyleBox["x", "MR"],
  " is zero. "
}], "MathCaption",
  CellTags->{"S3.4.11", "11.6"}],

Cell[CellGroupData[{

Cell["FullSimplify[ForAll[x, x^4 + x^2 > 0]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.4.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " supports a version of the standard notation for quantifiers used in \
predicate logic and pure mathematics. You can input ",
  Cell[BoxData[
      \(TraditionalForm\`\[ForAll] \)], "InlineFormula"],
  " as \[Backslash]",
  StyleBox["[ForAll]", "MR"],
  " or \[AliasIndicator]",
  StyleBox["fa\[AliasIndicator]", "MR"],
  ", and you can input ",
  Cell[BoxData[
      \(TraditionalForm\`\[Exists] \)], "InlineFormula"],
  " as \[Backslash]",
  StyleBox["[Exists]", "MR"],
  " or \[AliasIndicator]",
  StyleBox["ex\[AliasIndicator]", "MR"],
  ". To make the notation precise, however, ",
  StyleBox["Mathematica", "TI"],
  " makes the quantified variable a subscript. The conditions on the variable \
can also be given in the subscript, separated by a comma. "
}], "Text",
  CellTags->{"S3.4.11", "11.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[ForAll]", 
                      StyleBox["x",
                        "TI"]], 
                    StyleBox["expr",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["ForAll[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[ForAll]", 
                      RowBox[{"{", 
                        RowBox[{
                          StyleBox[\(x\_1\),
                            "TI"], ",", 
                          StyleBox[\(x\_2\),
                            "TI"], ",", "\[Ellipsis]"}], "}"}]], 
                    StyleBox["expr",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["ForAll[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[ForAll]", 
                      RowBox[{
                        StyleBox["x",
                          "TI"], ",", 
                        StyleBox["cond",
                          "TI"]}]], 
                    StyleBox["expr",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["ForAll[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["cond", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[Exists]", 
                      StyleBox["x",
                        "TI"]], 
                    StyleBox["expr",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Exists[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[Exists]", 
                      RowBox[{"{", 
                        RowBox[{
                          StyleBox[\(x\_1\),
                            "TI"], ",", 
                          StyleBox[\(x\_2\),
                            "TI"], ",", "\[Ellipsis]"}], "}"}]], 
                    StyleBox["expr",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Exists[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[Exists]", 
                      RowBox[{
                        StyleBox["x",
                          "TI"], ",", 
                        StyleBox["cond",
                          "TI"]}]], 
                    StyleBox["expr",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Exists[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["cond", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False}},
  CellTags->"S3.4.11"],

Cell["Notation for quantifiers. ", "Caption",
  CellTags->"S3.4.11"],

Cell[TextData[{
  "Given a statement that involves quantifiers, there are certain important \
cases where it is possible to resolve it into an equivalent statement in \
which the quantifiers have been eliminated. Somewhat like solving an \
equation, such quantifier elimination turns an implicit statement about what \
is true for all ",
  StyleBox["x", "TI"],
  " or for some ",
  StyleBox["x", "TI"],
  " into an explicit statement about the conditions under which this holds. "
}], "Text",
  CellTags->{"S3.4.11", "11.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Resolve[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "attempt to eliminate quantifiers from ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Resolve[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dom", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "attempt to eliminate quantifiers with all variables assumed to \
be in domain ",
              StyleBox["dom", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.11"],

Cell["Quantifier elimination. ", "Caption",
  CellTags->"S3.4.11"],

Cell[TextData[{
  "This shows that an ",
  StyleBox["x", "MR"],
  " exists that makes the equation true. "
}], "MathCaption",
  CellTags->{"S3.4.11", "11.9"}],

Cell[CellGroupData[{

Cell["Resolve[Exists[x, x^2 == x^3]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.4.11"]
}, Open  ]],

Cell[TextData[{
  "This shows that the equations can only be satisfied if ",
  StyleBox["c", "MR"],
  " obeys a certain condition. "
}], "MathCaption",
  CellTags->{"S3.4.11", "11.10"}],

Cell[CellGroupData[{

Cell["Resolve[Exists[x, x^2 == c && x^3 == c + 1]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(\(-1\) - 2\ c - c\^2 + c\^3 \[Equal] 0\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.4.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Resolve", "MR"],
  " can always eliminate quantifiers from any collection of polynomial \
equations and inequations over complex numbers, and from any collection of \
polynomial equations and inequalities over real numbers. It can also \
eliminate quantifiers from Boolean expressions. "
}], "Text",
  CellTags->{"S3.4.11", "11.11"}],

Cell["\<\
This finds the conditions for a quadratic form over the reals to be \
positive. \
\>", "MathCaption",
  CellTags->{"S3.4.11", "11.12"}],

Cell[CellGroupData[{

Cell["Resolve[ForAll[x, a x^2 + b x + c > 0], Reals]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(\((a > 0 && \(-a\)\ b\^2 + 4\ a\^2\ c > 0)\) || \((a \[Equal] 0 && 
          b \[Equal] 0 && c > 0)\) || \((a \[GreaterEqual] 0 && b \[Equal] 0 && 
          c > 0 && \(-a\)\ b\^2 + 4\ a\^2\ c > 0)\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.4.11"]
}, Open  ]],

Cell[TextData[{
  "This shows that there is a way of assigning truth values to ",
  StyleBox["p", "MR"],
  " and ",
  StyleBox["q", "MR"],
  " that makes the expression true. "
}], "MathCaption",
  CellTags->{"S3.4.11", "11.13"}],

Cell[CellGroupData[{

Cell["Resolve[Exists[{p, q}, p || q && ! q], Booleans]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.4.11"]
}, Open  ]],

Cell[TextData[{
  "You can also use quantifiers with ",
  StyleBox["Reduce", "MR"],
  ". If you give ",
  StyleBox["Reduce", "MR"],
  " a collection of equations or inequalities, then it will try to produce a \
detailed representation of the complete solution set. But sometimes you may \
want to address a more global question, such as whether the solution set \
covers all values of ",
  StyleBox["x", "TI"],
  ", or whether it covers none of these values. Quantifiers provide a \
convenient way to specify such questions. "
}], "Text",
  CellTags->{"S3.4.11", "11.14"}],

Cell["This gives the complete structure of the solution set. ", "MathCaption",
  CellTags->{"S3.4.11", "11.15"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 + x + c == 0, {c, x}, Reals]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(\((c < 
            1\/4 && \((x \[Equal] \(-\(1\/2\)\) - 1\/2\ \@\(1 - 4\ c\) || 
              x \[Equal] \(-\(1\/2\)\) + 
                  1\/2\ \@\(1 - 4\ c\))\))\) || \((c \[Equal] 1\/4 && 
          x \[Equal] \(-\(1\/2\)\))\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.4.11"]
}, Open  ]],

Cell["\<\
This instead just gives the condition for a solution to exist. \
\
\>", "MathCaption",
  CellTags->{"S3.4.11", "11.16"}],

Cell[CellGroupData[{

Cell["Reduce[Exists[x, x^2 + x + c == 0], {c}, Reals]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(c \[LessEqual] 1\/4\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.4.11"]
}, Open  ]],

Cell["\<\
It is possible to formulate a great many mathematical questions in \
terms of quantifiers. \
\>", "Text",
  CellTags->{"S3.4.11", "11.17"}],

Cell["\<\
This finds the conditions for a circle to be contained within an \
arbitrary conic section. \
\>", "MathCaption",
  CellTags->{"S3.4.11", "11.18"}],

Cell[CellGroupData[{

Cell["\<\
Reduce[ForAll[{x, y}, x^2 + y^2 < 1, a x^2 + b y^2 < c], {a, b, c}, \
Reals]\
\>", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(\((a \[LessEqual] 
            0 && \((\((b \[LessEqual] 0 && c > 0)\) || \((b > 0 && 
                  c \[GreaterEqual] b)\))\))\) || \((a > 
            0 && \((\((b < a && 
                  c \[GreaterEqual] a)\) || \((b \[GreaterEqual] a && 
                  c \[GreaterEqual] b)\))\))\)\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.4.11"]
}, Open  ]],

Cell["This finds the conditions for a line to intersect a circle. ", \
"MathCaption",
  CellTags->{"S3.4.11", "11.19"}],

Cell[CellGroupData[{

Cell["\<\
Reduce[Exists[{x, y}, x^2 + y^2 < 1, r x + s y == 1], {r, s}, \
Reals]\
\>", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(r < \(-1\) || \((\(-1\) \[LessEqual] r \[LessEqual] 
            1 && \((s < \(-\@\(1 - r\^2\)\) || s > \@\(1 - r\^2\))\))\) || 
      r > 1\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.4.11"]
}, Open  ]],

Cell[TextData[{
  "This defines ",
  StyleBox["q", "MR"],
  " to be a general monic quartic. "
}], "MathCaption",
  CellTags->{"S3.4.11", "11.20"}],

Cell["q[x_] := x^4 + b x^3 + c x^2 + d x + e", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.4.11"],

Cell["\<\
This finds the condition for all pairs of roots to the quartic to \
be equal. \
\>", "MathCaption",
  CellTags->{"S3.4.11", "11.21"}],

Cell[CellGroupData[{

Cell["\<\
Reduce[ForAll[{x, y}, q[x] == 0 && q[y] == 0, x == y], {b, c, d, \
e}]\
\>", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(\((c \[Equal] \(3\ b\^2\)\/8 && d \[Equal] b\^3\/16 && 
          e \[Equal] b\^4\/256)\) || \((b \[Equal] 0 && c \[Equal] 0 && 
          d \[Equal] 0 && e \[Equal] 0)\)\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.4.11"]
}, Open  ]],

Cell[TextData[{
  "Although quantifier elimination over the integers is in general a \
computationally impossible problem, ",
  StyleBox["Mathematica", "TI"],
  " can do it in specific cases. "
}], "Text",
  CellTags->{"S3.4.11", "11.22"}],

Cell[TextData[{
  "This shows that ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)], "InlineFormula"],
  " cannot be a rational number. "
}], "MathCaption",
  CellTags->{"S3.4.11", "11.23"}],

Cell[CellGroupData[{

Cell["Resolve[Exists[{x, y}, x^2 == 2 y^2 && y > 0], Integers]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.4.11"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\@\(9/4\)\)], "InlineFormula"],
  " is, though. "
}], "MathCaption",
  CellTags->{"S3.4.11", "11.24"}],

Cell[CellGroupData[{

Cell["Resolve[Exists[{x, y}, 4 x^2 == 9 y^2 && y > 0], Integers]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.4.11"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.4.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.4.12 Minimization and Maximization", "Subsection",
  CellTags->{"S3.4.12", "12.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Minimize[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "minimize ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Minimize[{", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["cons", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "minimize ",
              StyleBox["expr", "TI"],
              " subject to the constraints ",
              StyleBox["cons", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Maximize[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "maximize ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Maximize[{", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["cons", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "maximize ",
              StyleBox["expr", "TI"],
              " subject to the constraints ",
              StyleBox["cons", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.4.12"],

Cell["Minimization and maximization. ", "Caption",
  CellTags->"S3.4.12"],

Cell[TextData[{
  StyleBox["Minimize", "MR"],
  " and ",
  StyleBox["Maximize", "MR"],
  " yield lists giving the value attained at the minimum or maximum, together \
with rules specifying where the minimum or maximum occurs. "
}], "Text",
  CellTags->{"S3.4.12", "12.2"}],

Cell["This finds the minimum of a quadratic function. ", "MathCaption",
  CellTags->{"S3.4.12", "12.3"}],

Cell[CellGroupData[{

Cell["Minimize[x^2 - 3x + 6, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \({15\/4, {x \[Rule] 3\/2}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.4.12"]
}, Open  ]],

Cell[TextData[{
  "Applying the rule for ",
  StyleBox["x", "MR"],
  " gives the value at the minimum. "
}], "MathCaption",
  CellTags->{"S3.4.12", "12.4"}],

Cell[CellGroupData[{

Cell["x^2 - 3x + 6 /. Last[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \(15\/4\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.4.12"]
}, Open  ]],

Cell[TextData[{
  "This maximizes with respect to ",
  StyleBox["x", "MR"],
  " and\[NonBreakingSpace]",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.12", "12.5"}],

Cell[CellGroupData[{

Cell["Maximize[5 x y - x^4 - y^4, {x, y}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \({25\/8, {x \[Rule] \(-\(\@5\/2\)\), 
        y \[Rule] \(-\(\@5\/2\)\)}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.4.12"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Minimize[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " minimizes ",
  StyleBox["expr", "TI"],
  " allowing ",
  StyleBox["x", "TI"],
  " to range over all possible values from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+\[Infinity]\)\)], "InlineFormula"],
  ". ",
  StyleBox["Minimize[{", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["cons", "TI"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " minimizes ",
  StyleBox["expr", "TI"],
  " subject to the constraints ",
  StyleBox["cons", "TI"],
  " being satisfied. The constraints can consist of any combination of \
equations and inequalities. "
}], "Text",
  CellTags->{"S3.4.12", "12.6"}],

Cell[TextData[{
  "This finds the minimum subject to the constraint ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "\[GreaterEqual]", "3"}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.12", "12.7"}],

Cell[CellGroupData[{

Cell["Minimize[{x^2 - 3x + 6, x >= 3}, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \({6, {x \[Rule] 3}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.4.12"]
}, Open  ]],

Cell["This finds the maximum within the unit circle. ", "MathCaption",
  CellTags->{"S3.4.12", "12.8"}],

Cell[CellGroupData[{

Cell["Maximize[{5 x y - x^4 - y^4, x^2 + y^2 <= 1}, {x, y}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \({2, {x \[Rule] \(-\(1\/\@2\)\), y \[Rule] \(-\(1\/\@2\)\)}}\)], "Output",\

  CellLabel->"Out[5]= ",
  CellTags->"S3.4.12"]
}, Open  ]],

Cell["\<\
This finds the maximum within an ellipse. The result is fairly \
complicated. \
\>", "MathCaption",
  CellTags->{"S3.4.12", "12.9"}],

Cell[CellGroupData[{

Cell["Maximize[{5 x y - x^4 - y^4, x^2 + 2y^2 <= 1}, {x, y}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \({\(-Root[\(-811219\) + 320160\ #1 + 274624\ #1\^2 - 170240\ #1\^3 + 
              25600\ #1\^4 &, 1]\), {x \[Rule] 
          Root[25 - 102\ #1\^2 + 122\ #1\^4 - 70\ #1\^6 + 50\ #1\^8 &, 2], 
        y \[Rule] 
          Root[25 - 264\ #1\^2 + 848\ #1\^4 - 1040\ #1\^6 + 800\ #1\^8 &, 
            1]}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.4.12"]
}, Open  ]],

Cell["This finds the maximum along a line. ", "MathCaption",
  CellTags->{"S3.4.12", "12.10"}],

Cell[CellGroupData[{

Cell["Maximize[{5 x y - x^4 - y^4, x + y == 1}, {x, y}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \({9\/8, {x \[Rule] 1\/2, y \[Rule] 1\/2}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.4.12"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Minimize", "MR"],
  " and ",
  StyleBox["Maximize", "MR"],
  " can solve any ",
  StyleBox["linear programming", "TI"],
  " problem in which both the objective function ",
  StyleBox["expr", "TI"],
  " and the constraints ",
  StyleBox["cons", "TI"],
  " involve the variables ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " only linearly.  "
}], "Text",
  CellTags->{"S3.4.12", "12.11"}],

Cell["Here is a typical linear programming problem. ", "MathCaption",
  CellTags->{"S3.4.12", "12.12"}],

Cell[CellGroupData[{

Cell["Minimize[{x + 3 y, x - 3 y <= 7 && x + 2y >= 10}, {x, y}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \({53\/5, {x \[Rule] 44\/5, y \[Rule] 3\/5}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.4.12"]
}, Open  ]],

Cell[TextData[{
  "They can also in principle solve any ",
  StyleBox["polynomial programming", "TI"],
  " problem in which the objective function and the constraints involve \
arbitrary polynomial functions of the variables. There are many important \
geometrical and other problems that can be formulated in this way. "
}], "Text",
  CellTags->{"S3.4.12", "12.13"}],

Cell["\<\
This solves the simple geometrical problem of maximizing the area \
of a rectangle with fixed perimeter. \
\>", "MathCaption",
  CellTags->{"S3.4.12", "12.14"}],

Cell[CellGroupData[{

Cell["Maximize[{x y, x + y == 1}, {x, y}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \({1\/4, {x \[Rule] 1\/2, y \[Rule] 1\/2}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.4.12"]
}, Open  ]],

Cell["\<\
This finds the maximal volume of a cuboid that fits inside the unit \
sphere. \
\>", "MathCaption",
  CellTags->{"S3.4.12", "12.15"}],

Cell[CellGroupData[{

Cell["Maximize[{8 x y z, x^2 + y^2 + z^2 <= 1}, {x, y, z}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \({8\/\(3\ \@3\), {x \[Rule] 1\/\@3, y \[Rule] \(-\(1\/\@3\)\), 
        z \[Rule] \(-\(1\/\@3\)\)}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.4.12"]
}, Open  ]],

Cell[TextData[{
  "An important feature of ",
  StyleBox["Minimize", "MR"],
  " and ",
  StyleBox["Maximize", "MR"],
  " is that they always find ",
  StyleBox["global", "TI"],
  " minima and maxima. Often functions will have various local minima and \
maxima at which derivatives vanish. But ",
  StyleBox["Minimize", "MR"],
  " and ",
  StyleBox["Maximize", "MR"],
  " use global methods to find absolute minima or maxima, not just local \
extrema. "
}], "Text",
  CellTags->{"S3.4.12", "12.16"}],

Cell["Here is a function with many local maxima and minima. ", "MathCaption",
  CellTags->{"S3.4.12", "12.17"}],

Cell[CellGroupData[{

Cell["Plot[x + 2 Sin[x], {x, -10, 10}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.4.12"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0476191 0.309017 0.0291111 [
[.02381 .29652 -9 -9 ]
[.02381 .29652 9 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -6 -9 ]
[.97619 .29652 6 0 ]
[.4875 .01791 -18 -4.5 ]
[.4875 .01791 0 4.5 ]
[.4875 .16346 -12 -4.5 ]
[.4875 .16346 0 4.5 ]
[.4875 .45457 -6 -4.5 ]
[.4875 .45457 0 4.5 ]
[.4875 .60013 -12 -4.5 ]
[.4875 .60013 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-10)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-5)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(5)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(10)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01791 m
.50625 .01791 L
s
[(-10)] .4875 .01791 1 0 Mshowa
.5 .16346 m
.50625 .16346 L
s
[(-5)] .4875 .16346 1 0 Mshowa
.5 .45457 m
.50625 .45457 L
s
[(5)] .4875 .45457 1 0 Mshowa
.5 .60013 m
.50625 .60013 L
s
[(10)] .4875 .60013 1 0 Mshowa
.125 Mabswid
.5 .04702 m
.50375 .04702 L
s
.5 .07613 m
.50375 .07613 L
s
.5 .10524 m
.50375 .10524 L
s
.5 .13435 m
.50375 .13435 L
s
.5 .19257 m
.50375 .19257 L
s
.5 .22168 m
.50375 .22168 L
s
.5 .25079 m
.50375 .25079 L
s
.5 .27991 m
.50375 .27991 L
s
.5 .33813 m
.50375 .33813 L
s
.5 .36724 m
.50375 .36724 L
s
.5 .39635 m
.50375 .39635 L
s
.5 .42546 m
.50375 .42546 L
s
.5 .48368 m
.50375 .48368 L
s
.5 .51279 m
.50375 .51279 L
s
.5 .54191 m
.50375 .54191 L
s
.5 .57102 m
.50375 .57102 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04958 m
.04262 .03984 L
.06244 .02791 L
.07216 .02266 L
.08255 .01819 L
.08562 .01718 L
.08852 .01637 L
.09135 .01572 L
.09396 .01526 L
.09523 .01508 L
.09643 .01495 L
.09768 .01484 L
.09834 .0148 L
.09905 .01476 L
.09976 .01473 L
.10053 .01472 L
.10126 .01472 L
.10194 .01472 L
.10322 .01477 L
.10393 .01481 L
.10458 .01485 L
.10578 .01497 L
.1069 .0151 L
.10945 .01552 L
.11194 .01608 L
.1146 .01685 L
.11943 .01869 L
.12383 .02089 L
.13452 .02829 L
.14465 .03796 L
.16456 .06379 L
.18298 .09392 L
.22224 .16455 L
.24194 .19552 L
.25999 .21742 L
.26942 .22579 L
.27421 .22918 L
.27934 .23216 L
.2845 .23448 L
.2893 .23604 L
.29071 .23639 L
.29224 .23671 L
.29358 .23695 L
.29501 .23715 L
.29629 .2373 L
.29698 .23736 L
.29771 .23741 L
.29899 .23747 L
.3002 .2375 L
.30088 .2375 L
Mistroke
.30153 .23749 L
.30274 .23744 L
.30405 .23736 L
.30478 .2373 L
.30545 .23724 L
.30782 .23693 L
.31033 .23648 L
.3156 .23515 L
.32137 .23315 L
.33177 .22837 L
.34147 .22296 L
.36015 .21169 L
.36999 .20626 L
.38043 .20159 L
.38569 .19983 L
.38849 .19909 L
.39149 .19845 L
.39284 .19822 L
.39425 .19802 L
.39555 .19787 L
.39677 .19776 L
.39791 .19769 L
.39913 .19764 L
.39983 .19763 L
.40049 .19763 L
.40171 .19765 L
.40288 .1977 L
.40416 .1978 L
.4055 .19794 L
.40675 .1981 L
.40898 .1985 L
.41138 .19905 L
.41685 .20086 L
.42185 .20316 L
.43174 .20962 L
.44091 .21781 L
.46166 .2436 L
.50089 .31066 L
.53861 .37483 L
.55794 .39904 L
.56881 .40884 L
.57363 .41223 L
.57878 .4152 L
.58391 .41747 L
.58857 .41897 L
.59082 .4195 L
.592 .41972 L
.59326 .41993 L
.59435 .42008 L
.59556 .42021 L
Mistroke
.59666 .4203 L
.59768 .42036 L
.59896 .4204 L
.59968 .42041 L
.60035 .4204 L
.60158 .42037 L
.60289 .4203 L
.60418 .42019 L
.60539 .42006 L
.60765 .41974 L
.61034 .41922 L
.61281 .41862 L
.61837 .41688 L
.62812 .41272 L
.63721 .40787 L
.65788 .39546 L
.66834 .3896 L
.67825 .38503 L
.68256 .38346 L
.68714 .38213 L
.68953 .38158 L
.69217 .38111 L
.69332 .38094 L
.69456 .3808 L
.69574 .38069 L
.69681 .38061 L
.69809 .38056 L
.6993 .38054 L
.70038 .38054 L
.70156 .38058 L
.70284 .38066 L
.70348 .38072 L
.70419 .38079 L
.70662 .38112 L
.7089 .38156 L
.71134 .38217 L
.71575 .38365 L
.7213 .38621 L
.72657 .38937 L
.73645 .3972 L
.74608 .40716 L
.75632 .42008 L
.77472 .44833 L
.81637 .52297 L
.8373 .55699 L
.84647 .56958 L
.85651 .58131 L
.86624 .59037 L
.87531 .59666 L
.88033 .59923 L
Mistroke
.88489 .60102 L
.88741 .60178 L
.89016 .60243 L
.89141 .60267 L
.89274 .60288 L
.89398 .60304 L
.89514 .60316 L
.89634 .60324 L
.89765 .6033 L
.89881 .60332 L
.90005 .60331 L
.90126 .60326 L
.9024 .60319 L
.90343 .6031 L
.90454 .60298 L
.9071 .6026 L
.90981 .60207 L
.91466 .60077 L
.92338 .59747 L
.93296 .59271 L
.97337 .56968 L
.97619 .56845 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.4.12"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.4.12"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Maximize", "MR"],
  " finds the global maximum. "
}], "MathCaption",
  CellTags->{"S3.4.12", "12.18"}],

Cell[CellGroupData[{

Cell["Maximize[{x + 2 Sin[x], -10 <= x <= 10}, x]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \({\@3 + \(8\ \[Pi]\)\/3, {x \[Rule] \(8\ \[Pi]\)\/3}}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.4.12"]
}, Open  ]],

Cell[TextData[{
  "If you give functions that are unbounded, ",
  StyleBox["Minimize", "MR"],
  " and ",
  StyleBox["Maximize", "MR"],
  " will return ",
  StyleBox["-", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  " and ",
  StyleBox["+", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  " as the minima and maxima. And if you give constraints that can never be \
satisfied, they will return ",
  StyleBox["+", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  " and ",
  StyleBox["-", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  " as the minima and maxima, and ",
  StyleBox["Indeterminate", "MR"],
  " as the values of variables.  "
}], "Text",
  CellTags->{"S3.4.12", "12.19"}],

Cell[TextData[{
  "One subtle issue is that ",
  StyleBox["Minimize", "MR"],
  " and ",
  StyleBox["Maximize", "MR"],
  " allow both ",
  StyleBox["non\[Hyphen]strict", "TI"],
  " inequalities of the form ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["<=", "MR"],
  " ",
  StyleBox["v", "TI"],
  ", and ",
  StyleBox["strict", "TI"],
  " ones of the form ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["<", "MR"],
  " ",
  StyleBox["v", "TI"],
  ". With non\[Hyphen]strict inequalities there is no problem with a minimum \
or maximum lying exactly on the boundary ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["v", "TI"],
  ". But with strict inequalities, a minimum or maximum must in principle be \
at least infinitesimally inside the boundary. "
}], "Text",
  CellTags->{"S3.4.12", "12.20"}],

Cell[TextData[{
  "With a strict inequality, ",
  StyleBox["Mathematica", "TI"],
  " prints a warning, then returns the point on the boundary. "
}], "MathCaption",
  CellTags->{"S3.4.12", "12.21"}],

Cell[CellGroupData[{

Cell["Minimize[{x^2 - 3x + 6, x > 3}, x]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \(Minimize::"wksol" \(\(:\)\(\ \)\) 
      "Warning: There is no minimum in the region described by the \
contraints; returning a result on the boundary."\)], "Message",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \({6, {x \[Rule] 3}}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.4.12"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Minimize", "MR"],
  " and ",
  StyleBox["Maximize", "MR"],
  " normally assume that all variables you give are real. But by giving a \
constraint such as ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " ",
  StyleBox["Integers", "MR"],
  " you can specify that a variable must in fact be an integer. "
}], "Text",
  CellTags->{"S3.4.12", "12.22"}],

Cell[TextData[{
  "This does maximization only over integer values of ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.4.12", "12.23"}],

Cell[CellGroupData[{

Cell["\<\
Maximize[{x y, x^2 + y^2 < 120 && (x | y) \[Element] Integers}, {x, \
y}]\
\>", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.4.12"],

Cell[BoxData[
    \({56, {x \[Rule] \(-8\), y \[Rule] \(-7\)}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.4.12"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S3.4.0"->{
    Cell[1776, 53, 142, 4, 65, "Section",
      CellTags->{"S3.4.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 142, 4, 65, "Section",
      CellTags->{"S3.4.0", "0.1"}]},
  "S3.4.1"->{
    Cell[1943, 61, 104, 1, 70, "Subsection",
      CellTags->{"S3.4.1", "1.1"}],
    Cell[2050, 64, 1017, 47, 70, "Text",
      CellTags->{"S3.4.1", "1.2"}],
    Cell[3070, 113, 654, 31, 70, "Text",
      CellTags->{"S3.4.1", "1.3"}],
    Cell[3727, 146, 305, 7, 70, "Text",
      CellTags->{"S3.4.1", "1.4"}],
    Cell[4035, 155, 83, 1, 70, "MathCaption",
      CellTags->{"S3.4.1", "1.5"}],
    Cell[4143, 160, 77, 2, 70, "Input",
      CellTags->"S3.4.1"],
    Cell[4223, 164, 103, 3, 70, "Output",
      CellTags->"S3.4.1"],
    Cell[4341, 170, 341, 9, 70, "MathCaption",
      CellTags->{"S3.4.1", "1.6"}],
    Cell[4707, 183, 76, 2, 70, "Input",
      CellTags->"S3.4.1"],
    Cell[4786, 187, 164, 4, 70, "Output",
      CellTags->"S3.4.1"],
    Cell[4965, 194, 1793, 66, 70, "Text",
      CellTags->{"S3.4.1", "1.7"}],
    Cell[6761, 262, 462, 13, 70, "Text",
      CellTags->{"S3.4.1", "1.8"}],
    Cell[7226, 277, 783, 22, 70, "Text",
      CellTags->{"S3.4.1", "1.9"}],
    Cell[8012, 301, 233, 6, 70, "MathCaption",
      CellTags->{"S3.4.1", "1.10"}],
    Cell[8270, 311, 90, 2, 70, "Input",
      CellTags->"S3.4.1"],
    Cell[8363, 315, 164, 4, 70, "Output",
      CellTags->"S3.4.1"],
    Cell[8542, 322, 181, 5, 70, "MathCaption",
      CellTags->{"S3.4.1", "1.11"}],
    Cell[8748, 331, 78, 2, 70, "Input",
      CellTags->"S3.4.1"],
    Cell[8829, 335, 170, 4, 70, "Output",
      CellTags->"S3.4.1"],
    Cell[9014, 342, 234, 8, 70, "MathCaption",
      CellTags->{"S3.4.1", "1.12"}],
    Cell[9273, 354, 78, 2, 70, "Input",
      CellTags->"S3.4.1"],
    Cell[9354, 358, 219, 5, 70, "Output",
      CellTags->"S3.4.1"],
    Cell[9588, 366, 172, 5, 70, "MathCaption",
      CellTags->{"S3.4.1", "1.13"}],
    Cell[9785, 375, 89, 2, 70, "Input",
      CellTags->"S3.4.1"],
    Cell[9877, 379, 170, 4, 70, "Output",
      CellTags->"S3.4.1"]},
  "1.1"->{
    Cell[1943, 61, 104, 1, 70, "Subsection",
      CellTags->{"S3.4.1", "1.1"}]},
  "1.2"->{
    Cell[2050, 64, 1017, 47, 70, "Text",
      CellTags->{"S3.4.1", "1.2"}]},
  "1.3"->{
    Cell[3070, 113, 654, 31, 70, "Text",
      CellTags->{"S3.4.1", "1.3"}]},
  "1.4"->{
    Cell[3727, 146, 305, 7, 70, "Text",
      CellTags->{"S3.4.1", "1.4"}]},
  "1.5"->{
    Cell[4035, 155, 83, 1, 70, "MathCaption",
      CellTags->{"S3.4.1", "1.5"}]},
  "1.6"->{
    Cell[4341, 170, 341, 9, 70, "MathCaption",
      CellTags->{"S3.4.1", "1.6"}]},
  "1.7"->{
    Cell[4965, 194, 1793, 66, 70, "Text",
      CellTags->{"S3.4.1", "1.7"}]},
  "1.8"->{
    Cell[6761, 262, 462, 13, 70, "Text",
      CellTags->{"S3.4.1", "1.8"}]},
  "1.9"->{
    Cell[7226, 277, 783, 22, 70, "Text",
      CellTags->{"S3.4.1", "1.9"}]},
  "1.10"->{
    Cell[8012, 301, 233, 6, 70, "MathCaption",
      CellTags->{"S3.4.1", "1.10"}]},
  "1.11"->{
    Cell[8542, 322, 181, 5, 70, "MathCaption",
      CellTags->{"S3.4.1", "1.11"}]},
  "1.12"->{
    Cell[9014, 342, 234, 8, 70, "MathCaption",
      CellTags->{"S3.4.1", "1.12"}]},
  "1.13"->{
    Cell[9588, 366, 172, 5, 70, "MathCaption",
      CellTags->{"S3.4.1", "1.13"}]},
  "S3.4.2"->{
    Cell[10096, 389, 84, 1, 70, "Subsection",
      CellTags->{"S3.4.2", "2.1"}],
    Cell[10183, 392, 247, 9, 70, "Text",
      CellTags->{"S3.4.2", "2.2"}],
    Cell[10433, 403, 160, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.3"}],
    Cell[10618, 412, 89, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[10710, 416, 112, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[10837, 422, 138, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.4"}],
    Cell[11000, 430, 95, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[11098, 434, 200, 4, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[11313, 441, 225, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.5"}],
    Cell[11563, 450, 102, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[11668, 454, 211, 4, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[11894, 461, 278, 6, 70, "Text",
      CellTags->{"S3.4.2", "2.6"}],
    Cell[12175, 469, 236, 5, 70, "Text",
      CellTags->{"S3.4.2", "2.7"}],
    Cell[12414, 476, 252, 5, 70, "Text",
      CellTags->{"S3.4.2", "2.8"}],
    Cell[12669, 483, 170, 4, 70, "Text",
      CellTags->{"S3.4.2", "2.9"}],
    Cell[12842, 489, 96, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.10"}],
    Cell[12963, 494, 100, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[13066, 498, 117, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[13198, 504, 208, 6, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.11"}],
    Cell[13431, 514, 80, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[13514, 518, 207, 5, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[13736, 526, 101, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.12"}],
    Cell[13862, 531, 111, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[13976, 535, 126, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[14117, 541, 240, 6, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.13"}],
    Cell[14382, 551, 80, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[14465, 555, 405, 7, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[14885, 565, 961, 30, 70, "DefinitionBox",
      CellTags->"S3.4.2"],
    Cell[15849, 597, 76, 1, 70, "Caption",
      CellTags->"S3.4.2"],
    Cell[15928, 600, 249, 6, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.14"}],
    Cell[16202, 610, 91, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[16296, 614, 325, 7, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[16636, 624, 106, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.15"}],
    Cell[16767, 629, 68, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[16838, 633, 527, 11, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[17380, 647, 211, 6, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.16"}],
    Cell[17616, 657, 93, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[17712, 661, 528, 11, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[18255, 675, 338, 7, 70, "Text",
      CellTags->{"S3.4.2", "2.17"}],
    Cell[18596, 684, 186, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.18"}],
    Cell[18807, 693, 92, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[18902, 697, 108, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[19025, 703, 103, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.19"}],
    Cell[19153, 708, 69, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[19225, 712, 106, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[19346, 718, 166, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.20"}],
    Cell[19537, 726, 73, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[19613, 730, 88, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[19716, 736, 166, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.21"}],
    Cell[19907, 744, 103, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[20013, 748, 83, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[20111, 754, 133, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.22"}],
    Cell[20269, 762, 121, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[20393, 766, 89, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[20497, 772, 117, 2, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.23"}],
    Cell[20639, 778, 101, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[20743, 782, 108, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[20866, 788, 355, 7, 70, "Text",
      CellTags->{"S3.4.2", "2.24"}],
    Cell[21224, 797, 278, 9, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.25"}],
    Cell[21527, 810, 91, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[21621, 814, 321, 7, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[21957, 824, 259, 9, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.26"}],
    Cell[22241, 837, 88, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[22332, 841, 401, 9, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[22748, 853, 161, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.27"}],
    Cell[22934, 862, 105, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[23042, 866, 3081, 223, 70, 3008, 220, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.4.2"],
    Cell[26126, 1091, 178, 5, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[26319, 1099, 162, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.28"}],
    Cell[26506, 1108, 93, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[26602, 1112, 133, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[26750, 1118, 723, 20, 70, "Text",
      CellTags->{"S3.4.2", "2.29"}],
    Cell[27476, 1140, 147, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.30"}],
    Cell[27648, 1148, 89, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[27740, 1152, 112, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[27867, 1158, 156, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.31"}],
    Cell[28048, 1166, 105, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[28156, 1170, 275, 6, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[28446, 1179, 187, 5, 70, "Text",
      CellTags->{"S3.4.2", "2.32"}],
    Cell[28636, 1186, 99, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.33"}],
    Cell[28760, 1191, 102, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[28865, 1195, 131, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[29011, 1201, 93, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.34"}],
    Cell[29129, 1206, 101, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[29233, 1210, 226, 5, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[29474, 1218, 485, 10, 70, "Text",
      CellTags->{"S3.4.2", "2.35"}],
    Cell[29962, 1230, 147, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.36"}],
    Cell[30134, 1239, 89, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[30226, 1243, 102, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[30343, 1249, 135, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.37"}],
    Cell[30503, 1257, 86, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[30592, 1261, 197, 4, 70, "Message",
      CellTags->"S3.4.2"],
    Cell[30792, 1267, 109, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[30916, 1273, 167, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.38"}],
    Cell[31108, 1281, 94, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[31205, 1285, 113, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[31333, 1291, 667, 16, 70, "Text",
      CellTags->{"S3.4.2", "2.39"}],
    Cell[32003, 1309, 246, 6, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.40"}],
    Cell[32274, 1319, 86, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[32363, 1323, 228, 4, 70, "Message",
      CellTags->"S3.4.2"],
    Cell[32594, 1329, 105, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[32714, 1335, 149, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.41"}],
    Cell[32888, 1344, 94, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[32985, 1348, 186, 4, 70, "Message",
      CellTags->"S3.4.2"],
    Cell[33174, 1354, 228, 4, 70, "Message",
      CellTags->"S3.4.2"],
    Cell[33405, 1360, 135, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[33555, 1366, 285, 8, 70, "Text",
      CellTags->{"S3.4.2", "2.42"}],
    Cell[33843, 1376, 180, 6, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.43"}],
    Cell[34048, 1386, 84, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[34135, 1390, 186, 4, 70, "Message",
      CellTags->"S3.4.2"],
    Cell[34324, 1396, 306, 9, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[34645, 1408, 102, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.44"}],
    Cell[34772, 1413, 77, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[34852, 1417, 113, 2, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[34980, 1422, 1270, 38, 70, "DefinitionBox",
      CellTags->"S3.4.2"],
    Cell[36253, 1462, 60, 1, 70, "Caption",
      CellTags->"S3.4.2"],
    Cell[36316, 1465, 98, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.45"}],
    Cell[36439, 1470, 85, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[36527, 1474, 88, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[36630, 1480, 152, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.46"}],
    Cell[36807, 1488, 94, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[36904, 1492, 340, 10, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[37259, 1505, 370, 9, 70, "Text",
      CellTags->{"S3.4.2", "2.47"}],
    Cell[37632, 1516, 110, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.48"}],
    Cell[37767, 1521, 87, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[37857, 1525, 222, 5, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[38094, 1533, 111, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.49"}],
    Cell[38230, 1538, 95, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[38328, 1542, 173, 4, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[38516, 1549, 414, 11, 70, "Text",
      CellTags->{"S3.4.2", "2.50"}],
    Cell[38933, 1562, 164, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.51"}],
    Cell[39122, 1571, 103, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[39228, 1575, 177, 4, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[39420, 1582, 161, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.52"}],
    Cell[39606, 1591, 102, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[39711, 1595, 132, 3, 70, "Output",
      CellTags->"S3.4.2"],
    Cell[39858, 1601, 137, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.53"}],
    Cell[40020, 1609, 96, 2, 70, "Input",
      CellTags->"S3.4.2"],
    Cell[40119, 1613, 87, 3, 70, "Output",
      CellTags->"S3.4.2"]},
  "2.1"->{
    Cell[10096, 389, 84, 1, 70, "Subsection",
      CellTags->{"S3.4.2", "2.1"}]},
  "2.2"->{
    Cell[10183, 392, 247, 9, 70, "Text",
      CellTags->{"S3.4.2", "2.2"}]},
  "2.3"->{
    Cell[10433, 403, 160, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.3"}]},
  "2.4"->{
    Cell[10837, 422, 138, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.4"}]},
  "2.5"->{
    Cell[11313, 441, 225, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.5"}]},
  "2.6"->{
    Cell[11894, 461, 278, 6, 70, "Text",
      CellTags->{"S3.4.2", "2.6"}]},
  "2.7"->{
    Cell[12175, 469, 236, 5, 70, "Text",
      CellTags->{"S3.4.2", "2.7"}]},
  "2.8"->{
    Cell[12414, 476, 252, 5, 70, "Text",
      CellTags->{"S3.4.2", "2.8"}]},
  "2.9"->{
    Cell[12669, 483, 170, 4, 70, "Text",
      CellTags->{"S3.4.2", "2.9"}]},
  "2.10"->{
    Cell[12842, 489, 96, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.10"}]},
  "2.11"->{
    Cell[13198, 504, 208, 6, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.11"}]},
  "2.12"->{
    Cell[13736, 526, 101, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.12"}]},
  "2.13"->{
    Cell[14117, 541, 240, 6, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.13"}]},
  "2.14"->{
    Cell[15928, 600, 249, 6, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.14"}]},
  "2.15"->{
    Cell[16636, 624, 106, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.15"}]},
  "2.16"->{
    Cell[17380, 647, 211, 6, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.16"}]},
  "2.17"->{
    Cell[18255, 675, 338, 7, 70, "Text",
      CellTags->{"S3.4.2", "2.17"}]},
  "2.18"->{
    Cell[18596, 684, 186, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.18"}]},
  "2.19"->{
    Cell[19025, 703, 103, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.19"}]},
  "2.20"->{
    Cell[19346, 718, 166, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.20"}]},
  "2.21"->{
    Cell[19716, 736, 166, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.21"}]},
  "2.22"->{
    Cell[20111, 754, 133, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.22"}]},
  "2.23"->{
    Cell[20497, 772, 117, 2, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.23"}]},
  "2.24"->{
    Cell[20866, 788, 355, 7, 70, "Text",
      CellTags->{"S3.4.2", "2.24"}]},
  "2.25"->{
    Cell[21224, 797, 278, 9, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.25"}]},
  "2.26"->{
    Cell[21957, 824, 259, 9, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.26"}]},
  "2.27"->{
    Cell[22748, 853, 161, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.27"}]},
  "2.28"->{
    Cell[26319, 1099, 162, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.28"}]},
  "2.29"->{
    Cell[26750, 1118, 723, 20, 70, "Text",
      CellTags->{"S3.4.2", "2.29"}]},
  "2.30"->{
    Cell[27476, 1140, 147, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.30"}]},
  "2.31"->{
    Cell[27867, 1158, 156, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.31"}]},
  "2.32"->{
    Cell[28446, 1179, 187, 5, 70, "Text",
      CellTags->{"S3.4.2", "2.32"}]},
  "2.33"->{
    Cell[28636, 1186, 99, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.33"}]},
  "2.34"->{
    Cell[29011, 1201, 93, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.34"}]},
  "2.35"->{
    Cell[29474, 1218, 485, 10, 70, "Text",
      CellTags->{"S3.4.2", "2.35"}]},
  "2.36"->{
    Cell[29962, 1230, 147, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.36"}]},
  "2.37"->{
    Cell[30343, 1249, 135, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.37"}]},
  "2.38"->{
    Cell[30916, 1273, 167, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.38"}]},
  "2.39"->{
    Cell[31333, 1291, 667, 16, 70, "Text",
      CellTags->{"S3.4.2", "2.39"}]},
  "2.40"->{
    Cell[32003, 1309, 246, 6, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.40"}]},
  "2.41"->{
    Cell[32714, 1335, 149, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.41"}]},
  "2.42"->{
    Cell[33555, 1366, 285, 8, 70, "Text",
      CellTags->{"S3.4.2", "2.42"}]},
  "2.43"->{
    Cell[33843, 1376, 180, 6, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.43"}]},
  "2.44"->{
    Cell[34645, 1408, 102, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.44"}]},
  "2.45"->{
    Cell[36316, 1465, 98, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.45"}]},
  "2.46"->{
    Cell[36630, 1480, 152, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.46"}]},
  "2.47"->{
    Cell[37259, 1505, 370, 9, 70, "Text",
      CellTags->{"S3.4.2", "2.47"}]},
  "2.48"->{
    Cell[37632, 1516, 110, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.48"}]},
  "2.49"->{
    Cell[38094, 1533, 111, 1, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.49"}]},
  "2.50"->{
    Cell[38516, 1549, 414, 11, 70, "Text",
      CellTags->{"S3.4.2", "2.50"}]},
  "2.51"->{
    Cell[38933, 1562, 164, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.51"}]},
  "2.52"->{
    Cell[39420, 1582, 161, 5, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.52"}]},
  "2.53"->{
    Cell[39858, 1601, 137, 4, 70, "MathCaption",
      CellTags->{"S3.4.2", "2.53"}]},
  "S3.4.3"->{
    Cell[40255, 1622, 92, 1, 70, "Subsection",
      CellTags->{"S3.4.3", "3.1"}],
    Cell[40350, 1625, 972, 30, 70, "DefinitionBox",
      CellTags->"S3.4.3"],
    Cell[41325, 1657, 82, 1, 70, "Caption",
      CellTags->"S3.4.3"],
    Cell[41410, 1660, 208, 6, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.2"}],
    Cell[41643, 1670, 91, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[41737, 1674, 110, 3, 70, "Output",
      CellTags->"S3.4.3"],
    Cell[41862, 1680, 186, 6, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.3"}],
    Cell[42073, 1690, 75, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[42151, 1694, 97, 3, 70, "Output",
      CellTags->"S3.4.3"],
    Cell[42263, 1700, 359, 9, 70, "Text",
      CellTags->{"S3.4.3", "3.4"}],
    Cell[42625, 1711, 102, 1, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.5"}],
    Cell[42752, 1716, 92, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[42847, 1720, 108, 3, 70, "Output",
      CellTags->"S3.4.3"],
    Cell[42970, 1726, 169, 6, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.6"}],
    Cell[43164, 1736, 77, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[43244, 1740, 110, 3, 70, "Output",
      CellTags->"S3.4.3"],
    Cell[43369, 1746, 133, 4, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.7"}],
    Cell[43527, 1754, 98, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[43628, 1758, 115, 3, 70, "Output",
      CellTags->"S3.4.3"],
    Cell[43758, 1764, 182, 5, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.8"}],
    Cell[43965, 1773, 77, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[44045, 1777, 202, 5, 70, "Output",
      CellTags->"S3.4.3"],
    Cell[44262, 1785, 924, 28, 70, "DefinitionBox",
      CellTags->"S3.4.3"],
    Cell[45189, 1815, 74, 1, 70, "Caption",
      CellTags->"S3.4.3"],
    Cell[45266, 1818, 183, 5, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.9"}],
    Cell[45474, 1827, 86, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[45563, 1831, 100, 3, 70, "Output",
      CellTags->"S3.4.3"],
    Cell[45678, 1837, 203, 5, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.10"}],
    Cell[45906, 1846, 82, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[45991, 1850, 106, 3, 70, "Output",
      CellTags->"S3.4.3"],
    Cell[46112, 1856, 191, 6, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.11"}],
    Cell[46328, 1866, 77, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[46408, 1870, 91, 3, 70, "Output",
      CellTags->"S3.4.3"],
    Cell[46514, 1876, 1613, 49, 70, "Text",
      CellTags->{"S3.4.3", "3.12"}],
    Cell[48130, 1927, 159, 5, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.13"}],
    Cell[48314, 1936, 94, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[48411, 1940, 158, 4, 70, "Output",
      CellTags->"S3.4.3"],
    Cell[48584, 1947, 187, 5, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.14"}],
    Cell[48796, 1956, 78, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[48877, 1960, 158, 4, 70, "Output",
      CellTags->"S3.4.3"],
    Cell[49050, 1967, 382, 7, 70, "Text",
      CellTags->{"S3.4.3", "3.15"}],
    Cell[49435, 1976, 1514, 47, 70, "DefinitionBox",
      CellTags->"S3.4.3"],
    Cell[50952, 2025, 56, 1, 70, "Caption",
      CellTags->"S3.4.3"],
    Cell[51011, 2028, 366, 12, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.16"}],
    Cell[51402, 2044, 98, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[51503, 2048, 88, 3, 70, "Output",
      CellTags->"S3.4.3"],
    Cell[51606, 2054, 115, 2, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.17"}],
    Cell[51746, 2060, 107, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[51856, 2064, 129, 3, 70, "Output",
      CellTags->"S3.4.3"],
    Cell[52000, 2070, 196, 7, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.18"}],
    Cell[52221, 2081, 74, 2, 70, "Input",
      CellTags->"S3.4.3"],
    Cell[52298, 2085, 468, 8, 70, "Output",
      CellTags->"S3.4.3"]},
  "3.1"->{
    Cell[40255, 1622, 92, 1, 70, "Subsection",
      CellTags->{"S3.4.3", "3.1"}]},
  "3.2"->{
    Cell[41410, 1660, 208, 6, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.2"}]},
  "3.3"->{
    Cell[41862, 1680, 186, 6, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.3"}]},
  "3.4"->{
    Cell[42263, 1700, 359, 9, 70, "Text",
      CellTags->{"S3.4.3", "3.4"}]},
  "3.5"->{
    Cell[42625, 1711, 102, 1, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.5"}]},
  "3.6"->{
    Cell[42970, 1726, 169, 6, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.6"}]},
  "3.7"->{
    Cell[43369, 1746, 133, 4, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.7"}]},
  "3.8"->{
    Cell[43758, 1764, 182, 5, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.8"}]},
  "3.9"->{
    Cell[45266, 1818, 183, 5, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.9"}]},
  "3.10"->{
    Cell[45678, 1837, 203, 5, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.10"}]},
  "3.11"->{
    Cell[46112, 1856, 191, 6, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.11"}]},
  "3.12"->{
    Cell[46514, 1876, 1613, 49, 70, "Text",
      CellTags->{"S3.4.3", "3.12"}]},
  "3.13"->{
    Cell[48130, 1927, 159, 5, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.13"}]},
  "3.14"->{
    Cell[48584, 1947, 187, 5, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.14"}]},
  "3.15"->{
    Cell[49050, 1967, 382, 7, 70, "Text",
      CellTags->{"S3.4.3", "3.15"}]},
  "3.16"->{
    Cell[51011, 2028, 366, 12, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.16"}]},
  "3.17"->{
    Cell[51606, 2054, 115, 2, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.17"}]},
  "3.18"->{
    Cell[52000, 2070, 196, 7, 70, "MathCaption",
      CellTags->{"S3.4.3", "3.18"}]},
  "S3.4.4"->{
    Cell[52815, 2099, 81, 1, 70, "Subsection",
      CellTags->{"S3.4.4", "4.1"}],
    Cell[52899, 2102, 273, 8, 70, "Text",
      CellTags->{"S3.4.4", "4.2"}],
    Cell[53175, 2112, 106, 1, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.3"}],
    Cell[53306, 2117, 112, 2, 70, "Input",
      CellTags->"S3.4.4"],
    Cell[53421, 2121, 190, 4, 70, "Output",
      CellTags->"S3.4.4"],
    Cell[53626, 2128, 220, 5, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.4"}],
    Cell[53871, 2137, 107, 2, 70, "Input",
      CellTags->"S3.4.4"],
    Cell[53981, 2141, 276, 6, 70, "Output",
      CellTags->"S3.4.4"],
    Cell[54272, 2150, 154, 5, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.5"}],
    Cell[54451, 2159, 90, 2, 70, "Input",
      CellTags->"S3.4.4"],
    Cell[54544, 2163, 123, 3, 70, "Output",
      CellTags->"S3.4.4"],
    Cell[54682, 2169, 323, 9, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.6"}],
    Cell[55030, 2182, 124, 2, 70, "Input",
      CellTags->"S3.4.4"],
    Cell[55157, 2186, 451, 11, 70, "Output",
      CellTags->"S3.4.4"],
    Cell[55623, 2200, 144, 5, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.7"}],
    Cell[55792, 2209, 70, 2, 70, "Input",
      CellTags->"S3.4.4"],
    Cell[55865, 2213, 160, 4, 70, "Output",
      CellTags->"S3.4.4"],
    Cell[56040, 2220, 382, 11, 70, "Text",
      CellTags->{"S3.4.4", "4.8"}],
    Cell[56425, 2233, 190, 7, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.9"}],
    Cell[56640, 2244, 106, 2, 70, "Input",
      CellTags->"S3.4.4"],
    Cell[56749, 2248, 178, 4, 70, "Output",
      CellTags->"S3.4.4"],
    Cell[56942, 2255, 177, 7, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.10"}],
    Cell[57144, 2266, 95, 2, 70, "Input",
      CellTags->"S3.4.4"],
    Cell[57242, 2270, 233, 5, 70, "Output",
      CellTags->"S3.4.4"],
    Cell[57490, 2278, 1779, 53, 70, "DefinitionBox",
      CellTags->"S3.4.4"],
    Cell[59272, 2333, 73, 1, 70, "Caption",
      CellTags->"S3.4.4"],
    Cell[59348, 2336, 201, 5, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.11"}],
    Cell[59574, 2345, 101, 2, 70, "Input",
      CellTags->"S3.4.4"],
    Cell[59678, 2349, 124, 3, 70, "Output",
      CellTags->"S3.4.4"],
    Cell[59817, 2355, 3558, 99, 70, "FramedBox",
      CellTags->"S3.4.4"],
    Cell[63378, 2456, 134, 5, 70, "Caption",
      CellTags->"S3.4.4"],
    Cell[63515, 2463, 178, 4, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.12"}],
    Cell[63718, 2471, 91, 2, 70, "Input",
      CellTags->"S3.4.4"],
    Cell[63812, 2475, 120, 3, 70, "Output",
      CellTags->"S3.4.4"],
    Cell[63947, 2481, 157, 4, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.13"}],
    Cell[64129, 2489, 81, 2, 70, "Input",
      CellTags->"S3.4.4"],
    Cell[64213, 2493, 129, 3, 70, "Output",
      CellTags->"S3.4.4"],
    Cell[64357, 2499, 159, 5, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.14"}],
    Cell[64541, 2508, 82, 2, 70, "Input",
      CellTags->"S3.4.4"],
    Cell[64626, 2512, 127, 3, 70, "Output",
      CellTags->"S3.4.4"],
    Cell[64768, 2518, 284, 7, 70, "Text",
      CellTags->{"S3.4.4", "4.15"}]},
  "4.1"->{
    Cell[52815, 2099, 81, 1, 70, "Subsection",
      CellTags->{"S3.4.4", "4.1"}]},
  "4.2"->{
    Cell[52899, 2102, 273, 8, 70, "Text",
      CellTags->{"S3.4.4", "4.2"}]},
  "4.3"->{
    Cell[53175, 2112, 106, 1, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.3"}]},
  "4.4"->{
    Cell[53626, 2128, 220, 5, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.4"}]},
  "4.5"->{
    Cell[54272, 2150, 154, 5, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.5"}]},
  "4.6"->{
    Cell[54682, 2169, 323, 9, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.6"}]},
  "4.7"->{
    Cell[55623, 2200, 144, 5, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.7"}]},
  "4.8"->{
    Cell[56040, 2220, 382, 11, 70, "Text",
      CellTags->{"S3.4.4", "4.8"}]},
  "4.9"->{
    Cell[56425, 2233, 190, 7, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.9"}]},
  "4.10"->{
    Cell[56942, 2255, 177, 7, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.10"}]},
  "4.11"->{
    Cell[59348, 2336, 201, 5, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.11"}]},
  "4.12"->{
    Cell[63515, 2463, 178, 4, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.12"}]},
  "4.13"->{
    Cell[63947, 2481, 157, 4, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.13"}]},
  "4.14"->{
    Cell[64357, 2499, 159, 5, 70, "MathCaption",
      CellTags->{"S3.4.4", "4.14"}]},
  "4.15"->{
    Cell[64768, 2518, 284, 7, 70, "Text",
      CellTags->{"S3.4.4", "4.15"}]},
  "S3.4.5"->{
    Cell[65089, 2530, 108, 3, 70, "Subsection",
      CellTags->{"S3.4.5", "5.1"}],
    Cell[65200, 2535, 950, 41, 70, "Text",
      CellTags->{"S3.4.5", "5.2"}],
    Cell[66153, 2578, 229, 8, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.3"}],
    Cell[66407, 2590, 85, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[66495, 2594, 96, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[66606, 2600, 230, 7, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.4"}],
    Cell[66861, 2611, 86, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[66950, 2615, 109, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[67074, 2621, 860, 26, 70, "Text",
      CellTags->{"S3.4.5", "5.5"}],
    Cell[67937, 2649, 841, 24, 70, "DefinitionBox",
      CellTags->"S3.4.5"],
    Cell[68781, 2675, 60, 1, 70, "Caption",
      CellTags->"S3.4.5"],
    Cell[68844, 2678, 167, 5, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.6"}],
    Cell[69036, 2687, 86, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[69125, 2691, 108, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[69248, 2697, 314, 10, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.7"}],
    Cell[69587, 2711, 87, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[69677, 2715, 179, 4, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[69871, 2722, 588, 18, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.8"}],
    Cell[70484, 2744, 95, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[70582, 2748, 399, 8, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[70996, 2759, 297, 7, 70, "Text",
      CellTags->{"S3.4.5", "5.9"}],
    Cell[71296, 2768, 128, 4, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.10"}],
    Cell[71449, 2776, 93, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[71545, 2780, 86, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[71646, 2786, 226, 7, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.11"}],
    Cell[71897, 2797, 93, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[71993, 2801, 109, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[72117, 2807, 154, 5, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.12"}],
    Cell[72296, 2816, 92, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[72391, 2820, 83, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[72489, 2826, 233, 9, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.13"}],
    Cell[72747, 2839, 100, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[72850, 2843, 96, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[72961, 2849, 159, 5, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.14"}],
    Cell[73145, 2858, 85, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[73233, 2862, 86, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[73334, 2868, 187, 5, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.15"}],
    Cell[73546, 2877, 84, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[73633, 2881, 86, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[73734, 2887, 282, 7, 70, "Text",
      CellTags->{"S3.4.5", "5.16"}],
    Cell[74019, 2896, 553, 21, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.17"}],
    Cell[74597, 2921, 97, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[74697, 2925, 115, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[74827, 2931, 88, 1, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.18"}],
    Cell[74940, 2936, 73, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[75016, 2940, 83, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[75114, 2946, 105, 1, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.19"}],
    Cell[75244, 2951, 97, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[75344, 2955, 170, 4, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[75529, 2962, 144, 4, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.20"}],
    Cell[75698, 2970, 86, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[75787, 2974, 84, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[75886, 2980, 378, 16, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.21"}],
    Cell[76289, 3000, 87, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[76379, 3004, 176, 4, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[76570, 3011, 159, 4, 70, "Text",
      CellTags->{"S3.4.5", "5.22"}],
    Cell[76732, 3017, 106, 1, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.23"}],
    Cell[76863, 3022, 95, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[76961, 3026, 122, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[77098, 3032, 151, 4, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.24"}],
    Cell[77274, 3040, 83, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[77360, 3044, 84, 3, 70, "Output",
      CellTags->"S3.4.5"],
    Cell[77459, 3050, 155, 4, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.25"}],
    Cell[77639, 3058, 84, 2, 70, "Input",
      CellTags->"S3.4.5"],
    Cell[77726, 3062, 245, 5, 70, "Output",
      CellTags->"S3.4.5"]},
  "5.1"->{
    Cell[65089, 2530, 108, 3, 70, "Subsection",
      CellTags->{"S3.4.5", "5.1"}]},
  "5.2"->{
    Cell[65200, 2535, 950, 41, 70, "Text",
      CellTags->{"S3.4.5", "5.2"}]},
  "5.3"->{
    Cell[66153, 2578, 229, 8, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.3"}]},
  "5.4"->{
    Cell[66606, 2600, 230, 7, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.4"}]},
  "5.5"->{
    Cell[67074, 2621, 860, 26, 70, "Text",
      CellTags->{"S3.4.5", "5.5"}]},
  "5.6"->{
    Cell[68844, 2678, 167, 5, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.6"}]},
  "5.7"->{
    Cell[69248, 2697, 314, 10, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.7"}]},
  "5.8"->{
    Cell[69871, 2722, 588, 18, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.8"}]},
  "5.9"->{
    Cell[70996, 2759, 297, 7, 70, "Text",
      CellTags->{"S3.4.5", "5.9"}]},
  "5.10"->{
    Cell[71296, 2768, 128, 4, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.10"}]},
  "5.11"->{
    Cell[71646, 2786, 226, 7, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.11"}]},
  "5.12"->{
    Cell[72117, 2807, 154, 5, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.12"}]},
  "5.13"->{
    Cell[72489, 2826, 233, 9, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.13"}]},
  "5.14"->{
    Cell[72961, 2849, 159, 5, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.14"}]},
  "5.15"->{
    Cell[73334, 2868, 187, 5, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.15"}]},
  "5.16"->{
    Cell[73734, 2887, 282, 7, 70, "Text",
      CellTags->{"S3.4.5", "5.16"}]},
  "5.17"->{
    Cell[74019, 2896, 553, 21, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.17"}]},
  "5.18"->{
    Cell[74827, 2931, 88, 1, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.18"}]},
  "5.19"->{
    Cell[75114, 2946, 105, 1, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.19"}]},
  "5.20"->{
    Cell[75529, 2962, 144, 4, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.20"}]},
  "5.21"->{
    Cell[75886, 2980, 378, 16, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.21"}]},
  "5.22"->{
    Cell[76570, 3011, 159, 4, 70, "Text",
      CellTags->{"S3.4.5", "5.22"}]},
  "5.23"->{
    Cell[76732, 3017, 106, 1, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.23"}]},
  "5.24"->{
    Cell[77098, 3032, 151, 4, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.24"}]},
  "5.25"->{
    Cell[77459, 3050, 155, 4, 70, "MathCaption",
      CellTags->{"S3.4.5", "5.25"}]},
  "S3.4.6"->{
    Cell[78020, 3073, 80, 1, 70, "Subsection",
      CellTags->{"S3.4.6", "6.1"}],
    Cell[78103, 3076, 405, 9, 70, "Text",
      CellTags->{"S3.4.6", "6.2"}],
    Cell[78511, 3087, 1204, 37, 70, "DefinitionBox",
      CellTags->"S3.4.6"],
    Cell[79718, 3126, 64, 1, 70, "Caption",
      CellTags->"S3.4.6"],
    Cell[79785, 3129, 295, 11, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.3"}],
    Cell[80105, 3144, 103, 2, 70, "Input",
      CellTags->"S3.4.6"],
    Cell[80211, 3148, 133, 3, 70, "Output",
      CellTags->"S3.4.6"],
    Cell[80359, 3154, 250, 11, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.4"}],
    Cell[80634, 3169, 82, 2, 70, "Input",
      CellTags->"S3.4.6"],
    Cell[80719, 3173, 128, 3, 70, "Output",
      CellTags->"S3.4.6"],
    Cell[80862, 3179, 256, 11, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.5"}],
    Cell[81143, 3194, 82, 2, 70, "Input",
      CellTags->"S3.4.6"],
    Cell[81228, 3198, 161, 4, 70, "Output",
      CellTags->"S3.4.6"],
    Cell[81404, 3205, 435, 17, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.6"}],
    Cell[81864, 3226, 80, 2, 70, "Input",
      CellTags->"S3.4.6"],
    Cell[81947, 3230, 105, 3, 70, "Output",
      CellTags->"S3.4.6"],
    Cell[82067, 3236, 217, 9, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.7"}],
    Cell[82309, 3249, 80, 2, 70, "Input",
      CellTags->"S3.4.6"],
    Cell[82392, 3253, 115, 3, 70, "Output",
      CellTags->"S3.4.6"],
    Cell[82522, 3259, 229, 6, 70, "Text",
      CellTags->{"S3.4.6", "6.8"}],
    Cell[82754, 3267, 206, 7, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.9"}],
    Cell[82985, 3278, 81, 2, 70, "Input",
      CellTags->"S3.4.6"],
    Cell[83069, 3282, 103, 3, 70, "Output",
      CellTags->"S3.4.6"],
    Cell[83187, 3288, 181, 7, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.10"}],
    Cell[83393, 3299, 81, 2, 70, "Input",
      CellTags->"S3.4.6"],
    Cell[83477, 3303, 97, 3, 70, "Output",
      CellTags->"S3.4.6"],
    Cell[83589, 3309, 826, 29, 70, "Text",
      CellTags->{"S3.4.6", "6.11"}],
    Cell[84418, 3340, 342, 13, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.12"}],
    Cell[84785, 3357, 123, 2, 70, "Input",
      CellTags->"S3.4.6"],
    Cell[84911, 3361, 122, 3, 70, "Output",
      CellTags->"S3.4.6"],
    Cell[85048, 3367, 462, 9, 70, "Text",
      CellTags->{"S3.4.6", "6.13"}],
    Cell[85513, 3378, 727, 21, 70, "DefinitionBox",
      CellTags->"S3.4.6"],
    Cell[86243, 3401, 97, 1, 70, "Caption",
      CellTags->"S3.4.6"],
    Cell[86343, 3404, 174, 5, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.14"}],
    Cell[86542, 3413, 108, 2, 70, "Input",
      CellTags->"S3.4.6"],
    Cell[86653, 3417, 122, 3, 70, "Output",
      CellTags->"S3.4.6"],
    Cell[86790, 3423, 80, 1, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.15"}],
    Cell[86895, 3428, 154, 5, 70, "Input",
      CellTags->"S3.4.6"],
    Cell[87052, 3435, 855, 25, 70, "Output",
      CellTags->"S3.4.6"],
    Cell[87922, 3463, 107, 1, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.16"}],
    Cell[88054, 3468, 82, 2, 70, "Input",
      CellTags->"S3.4.6"],
    Cell[88139, 3472, 127, 3, 70, "Output",
      CellTags->"S3.4.6"]},
  "6.1"->{
    Cell[78020, 3073, 80, 1, 70, "Subsection",
      CellTags->{"S3.4.6", "6.1"}]},
  "6.2"->{
    Cell[78103, 3076, 405, 9, 70, "Text",
      CellTags->{"S3.4.6", "6.2"}]},
  "6.3"->{
    Cell[79785, 3129, 295, 11, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.3"}]},
  "6.4"->{
    Cell[80359, 3154, 250, 11, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.4"}]},
  "6.5"->{
    Cell[80862, 3179, 256, 11, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.5"}]},
  "6.6"->{
    Cell[81404, 3205, 435, 17, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.6"}]},
  "6.7"->{
    Cell[82067, 3236, 217, 9, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.7"}]},
  "6.8"->{
    Cell[82522, 3259, 229, 6, 70, "Text",
      CellTags->{"S3.4.6", "6.8"}]},
  "6.9"->{
    Cell[82754, 3267, 206, 7, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.9"}]},
  "6.10"->{
    Cell[83187, 3288, 181, 7, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.10"}]},
  "6.11"->{
    Cell[83589, 3309, 826, 29, 70, "Text",
      CellTags->{"S3.4.6", "6.11"}]},
  "6.12"->{
    Cell[84418, 3340, 342, 13, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.12"}]},
  "6.13"->{
    Cell[85048, 3367, 462, 9, 70, "Text",
      CellTags->{"S3.4.6", "6.13"}]},
  "6.14"->{
    Cell[86343, 3404, 174, 5, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.14"}]},
  "6.15"->{
    Cell[86790, 3423, 80, 1, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.15"}]},
  "6.16"->{
    Cell[87922, 3463, 107, 1, 70, "MathCaption",
      CellTags->{"S3.4.6", "6.16"}]},
  "S3.4.7"->{
    Cell[88315, 3481, 100, 1, 70, "Subsection",
      CellTags->{"S3.4.7", "7.1"}],
    Cell[88418, 3484, 326, 8, 70, "Text",
      CellTags->{"S3.4.7", "7.2"}],
    Cell[88747, 3494, 457, 24, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.3"}],
    Cell[89229, 3522, 103, 2, 70, "Input",
      CellTags->"S3.4.7"],
    Cell[89335, 3526, 124, 3, 70, "Output",
      CellTags->"S3.4.7"],
    Cell[89474, 3532, 171, 5, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.4"}],
    Cell[89670, 3541, 104, 2, 70, "Input",
      CellTags->"S3.4.7"],
    Cell[89777, 3545, 124, 3, 70, "Output",
      CellTags->"S3.4.7"],
    Cell[89916, 3551, 590, 31, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.5"}],
    Cell[90531, 3586, 100, 2, 70, "Input",
      CellTags->"S3.4.7"],
    Cell[90634, 3590, 119, 3, 70, "Output",
      CellTags->"S3.4.7"],
    Cell[90768, 3596, 138, 4, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.6"}],
    Cell[90931, 3604, 82, 2, 70, "Input",
      CellTags->"S3.4.7"],
    Cell[91016, 3608, 131, 3, 70, "Output",
      CellTags->"S3.4.7"],
    Cell[91162, 3614, 252, 9, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.7"}],
    Cell[91439, 3627, 92, 2, 70, "Input",
      CellTags->"S3.4.7"],
    Cell[91534, 3631, 116, 3, 70, "Output",
      CellTags->"S3.4.7"],
    Cell[91665, 3637, 962, 52, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.8"}],
    Cell[92652, 3693, 105, 2, 70, "Input",
      CellTags->"S3.4.7"],
    Cell[92760, 3697, 166, 4, 70, "Output",
      CellTags->"S3.4.7"],
    Cell[92941, 3704, 365, 11, 70, "Text",
      CellTags->{"S3.4.7", "7.9"}],
    Cell[93309, 3717, 241, 10, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.10"}],
    Cell[93575, 3731, 83, 2, 70, "Input",
      CellTags->"S3.4.7"],
    Cell[93661, 3735, 109, 3, 70, "Output",
      CellTags->"S3.4.7"],
    Cell[93785, 3741, 386, 17, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.11"}],
    Cell[94196, 3762, 89, 2, 70, "Input",
      CellTags->"S3.4.7"],
    Cell[94288, 3766, 166, 4, 70, "Output",
      CellTags->"S3.4.7"],
    Cell[94469, 3773, 355, 10, 70, "Text",
      CellTags->{"S3.4.7", "7.12"}],
    Cell[94827, 3785, 2650, 74, 70, "DefinitionBox",
      CellTags->"S3.4.7"],
    Cell[97480, 3861, 70, 1, 70, "Caption",
      CellTags->"S3.4.7"],
    Cell[97553, 3864, 290, 8, 70, "Text",
      CellTags->{"S3.4.7", "7.13"}],
    Cell[97846, 3874, 180, 7, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.14"}],
    Cell[98051, 3885, 125, 4, 70, "Input",
      CellTags->"S3.4.7"],
    Cell[98179, 3891, 85, 3, 70, "Output",
      CellTags->"S3.4.7"]},
  "7.1"->{
    Cell[88315, 3481, 100, 1, 70, "Subsection",
      CellTags->{"S3.4.7", "7.1"}]},
  "7.2"->{
    Cell[88418, 3484, 326, 8, 70, "Text",
      CellTags->{"S3.4.7", "7.2"}]},
  "7.3"->{
    Cell[88747, 3494, 457, 24, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.3"}]},
  "7.4"->{
    Cell[89474, 3532, 171, 5, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.4"}]},
  "7.5"->{
    Cell[89916, 3551, 590, 31, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.5"}]},
  "7.6"->{
    Cell[90768, 3596, 138, 4, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.6"}]},
  "7.7"->{
    Cell[91162, 3614, 252, 9, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.7"}]},
  "7.8"->{
    Cell[91665, 3637, 962, 52, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.8"}]},
  "7.9"->{
    Cell[92941, 3704, 365, 11, 70, "Text",
      CellTags->{"S3.4.7", "7.9"}]},
  "7.10"->{
    Cell[93309, 3717, 241, 10, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.10"}]},
  "7.11"->{
    Cell[93785, 3741, 386, 17, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.11"}]},
  "7.12"->{
    Cell[94469, 3773, 355, 10, 70, "Text",
      CellTags->{"S3.4.7", "7.12"}]},
  "7.13"->{
    Cell[97553, 3864, 290, 8, 70, "Text",
      CellTags->{"S3.4.7", "7.13"}]},
  "7.14"->{
    Cell[97846, 3874, 180, 7, 70, "MathCaption",
      CellTags->{"S3.4.7", "7.14"}]},
  "S3.4.8"->{
    Cell[98313, 3900, 71, 1, 70, "Subsection",
      CellTags->{"S3.4.8", "8.1"}],
    Cell[98387, 3903, 907, 47, 70, "Text",
      CellTags->{"S3.4.8", "8.2"}],
    Cell[99297, 3952, 1137, 34, 70, "DefinitionBox",
      CellTags->"S3.4.8"],
    Cell[100437, 3988, 79, 1, 70, "Caption",
      CellTags->"S3.4.8"],
    Cell[100519, 3991, 114, 2, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.3"}],
    Cell[100658, 3997, 97, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[100758, 4001, 90, 3, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[100863, 4007, 114, 2, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.4"}],
    Cell[101002, 4013, 89, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[101094, 4017, 86, 3, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[101195, 4023, 1282, 54, 70, "Text",
      CellTags->{"S3.4.8", "8.5"}],
    Cell[102480, 4079, 163, 5, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.6"}],
    Cell[102668, 4088, 88, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[102759, 4092, 164, 4, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[102938, 4099, 168, 5, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.7"}],
    Cell[103131, 4108, 87, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[103221, 4112, 150, 4, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[103386, 4119, 970, 32, 70, "Text",
      CellTags->{"S3.4.8", "8.8"}],
    Cell[104359, 4153, 103, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.9"}],
    Cell[104487, 4158, 107, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[104597, 4162, 108, 3, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[104720, 4168, 105, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.10"}],
    Cell[104850, 4173, 101, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[104954, 4177, 130, 3, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[105099, 4183, 156, 5, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.11"}],
    Cell[105280, 4192, 93, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[105376, 4196, 421, 8, 70, "Message",
      CellTags->"S3.4.8"],
    Cell[105800, 4206, 199, 5, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[106014, 4214, 382, 11, 70, "Text",
      CellTags->{"S3.4.8", "8.12"}],
    Cell[106399, 4227, 116, 2, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.13"}],
    Cell[106540, 4233, 99, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[106642, 4237, 176, 4, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[106833, 4244, 156, 5, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.14"}],
    Cell[107014, 4253, 94, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[107111, 4257, 244, 6, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[107370, 4266, 115, 2, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.15"}],
    Cell[107510, 4272, 114, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[107627, 4276, 330, 8, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[107972, 4287, 324, 9, 70, "Text",
      CellTags->{"S3.4.8", "8.16"}],
    Cell[108299, 4298, 127, 4, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.17"}],
    Cell[108451, 4306, 97, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[108551, 4310, 153, 4, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[108719, 4317, 103, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.18"}],
    Cell[108847, 4322, 116, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[108966, 4326, 339, 7, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[109320, 4336, 1472, 41, 70, "DefinitionBox",
      CellTags->"S3.4.8"],
    Cell[110795, 4379, 68, 1, 70, "Caption",
      CellTags->"S3.4.8"],
    Cell[110866, 4382, 282, 6, 70, "Text",
      CellTags->{"S3.4.8", "8.19"}],
    Cell[111151, 4390, 193, 7, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.20"}],
    Cell[111369, 4401, 94, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[111466, 4405, 142, 4, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[111623, 4412, 411, 8, 70, "Text",
      CellTags->{"S3.4.8", "8.21"}],
    Cell[112037, 4422, 102, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.22"}],
    Cell[112164, 4427, 106, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[112273, 4431, 108, 3, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[112396, 4437, 132, 4, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.23"}],
    Cell[112553, 4445, 110, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[112666, 4449, 177, 4, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[112858, 4456, 208, 5, 70, "Text",
      CellTags->{"S3.4.8", "8.24"}],
    Cell[113069, 4463, 130, 4, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.25"}],
    Cell[113224, 4471, 108, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[113335, 4475, 181, 4, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[113531, 4482, 99, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.26"}],
    Cell[113655, 4487, 117, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[113775, 4491, 282, 6, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[114072, 4500, 115, 2, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.27"}],
    Cell[114212, 4506, 117, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[114332, 4510, 87, 3, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[114434, 4516, 115, 2, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.28"}],
    Cell[114574, 4522, 114, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[114691, 4526, 460, 9, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[115166, 4538, 240, 6, 70, "Text",
      CellTags->{"S3.4.8", "8.29"}],
    Cell[115409, 4546, 152, 5, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.30"}],
    Cell[115586, 4555, 94, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[115683, 4559, 180, 4, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[115878, 4566, 177, 6, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.31"}],
    Cell[116080, 4576, 96, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[116179, 4580, 611, 12, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[116805, 4595, 376, 9, 70, "Text",
      CellTags->{"S3.4.8", "8.32"}],
    Cell[117184, 4606, 1954, 59, 70, "DefinitionBox",
      CellTags->"S3.4.8"],
    Cell[119141, 4667, 94, 1, 70, "Caption",
      CellTags->"S3.4.8"],
    Cell[119238, 4670, 129, 4, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.33"}],
    Cell[119392, 4678, 120, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[119515, 4682, 151, 4, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[119681, 4689, 126, 4, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.34"}],
    Cell[119832, 4697, 120, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[119955, 4701, 84, 3, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[120054, 4707, 530, 11, 70, "Text",
      CellTags->{"S3.4.8", "8.35"}],
    Cell[120587, 4720, 568, 12, 70, "Text",
      CellTags->{"S3.4.8", "8.36"}],
    Cell[121158, 4734, 173, 5, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.37"}],
    Cell[121356, 4743, 101, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[121460, 4747, 110, 3, 70, "Output",
      CellTags->"S3.4.8"],
    Cell[121585, 4753, 95, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.38"}],
    Cell[121683, 4756, 107, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[121793, 4760, 97, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.39"}],
    Cell[121915, 4765, 110, 2, 70, "Input",
      CellTags->"S3.4.8"],
    Cell[122028, 4769, 12194, 697, 70, 12121, 694, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.4.8"],
    Cell[134225, 5468, 178, 5, 70, "Output",
      CellTags->"S3.4.8"]},
  "8.1"->{
    Cell[98313, 3900, 71, 1, 70, "Subsection",
      CellTags->{"S3.4.8", "8.1"}]},
  "8.2"->{
    Cell[98387, 3903, 907, 47, 70, "Text",
      CellTags->{"S3.4.8", "8.2"}]},
  "8.3"->{
    Cell[100519, 3991, 114, 2, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.3"}]},
  "8.4"->{
    Cell[100863, 4007, 114, 2, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.4"}]},
  "8.5"->{
    Cell[101195, 4023, 1282, 54, 70, "Text",
      CellTags->{"S3.4.8", "8.5"}]},
  "8.6"->{
    Cell[102480, 4079, 163, 5, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.6"}]},
  "8.7"->{
    Cell[102938, 4099, 168, 5, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.7"}]},
  "8.8"->{
    Cell[103386, 4119, 970, 32, 70, "Text",
      CellTags->{"S3.4.8", "8.8"}]},
  "8.9"->{
    Cell[104359, 4153, 103, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.9"}]},
  "8.10"->{
    Cell[104720, 4168, 105, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.10"}]},
  "8.11"->{
    Cell[105099, 4183, 156, 5, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.11"}]},
  "8.12"->{
    Cell[106014, 4214, 382, 11, 70, "Text",
      CellTags->{"S3.4.8", "8.12"}]},
  "8.13"->{
    Cell[106399, 4227, 116, 2, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.13"}]},
  "8.14"->{
    Cell[106833, 4244, 156, 5, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.14"}]},
  "8.15"->{
    Cell[107370, 4266, 115, 2, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.15"}]},
  "8.16"->{
    Cell[107972, 4287, 324, 9, 70, "Text",
      CellTags->{"S3.4.8", "8.16"}]},
  "8.17"->{
    Cell[108299, 4298, 127, 4, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.17"}]},
  "8.18"->{
    Cell[108719, 4317, 103, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.18"}]},
  "8.19"->{
    Cell[110866, 4382, 282, 6, 70, "Text",
      CellTags->{"S3.4.8", "8.19"}]},
  "8.20"->{
    Cell[111151, 4390, 193, 7, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.20"}]},
  "8.21"->{
    Cell[111623, 4412, 411, 8, 70, "Text",
      CellTags->{"S3.4.8", "8.21"}]},
  "8.22"->{
    Cell[112037, 4422, 102, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.22"}]},
  "8.23"->{
    Cell[112396, 4437, 132, 4, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.23"}]},
  "8.24"->{
    Cell[112858, 4456, 208, 5, 70, "Text",
      CellTags->{"S3.4.8", "8.24"}]},
  "8.25"->{
    Cell[113069, 4463, 130, 4, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.25"}]},
  "8.26"->{
    Cell[113531, 4482, 99, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.26"}]},
  "8.27"->{
    Cell[114072, 4500, 115, 2, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.27"}]},
  "8.28"->{
    Cell[114434, 4516, 115, 2, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.28"}]},
  "8.29"->{
    Cell[115166, 4538, 240, 6, 70, "Text",
      CellTags->{"S3.4.8", "8.29"}]},
  "8.30"->{
    Cell[115409, 4546, 152, 5, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.30"}]},
  "8.31"->{
    Cell[115878, 4566, 177, 6, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.31"}]},
  "8.32"->{
    Cell[116805, 4595, 376, 9, 70, "Text",
      CellTags->{"S3.4.8", "8.32"}]},
  "8.33"->{
    Cell[119238, 4670, 129, 4, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.33"}]},
  "8.34"->{
    Cell[119681, 4689, 126, 4, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.34"}]},
  "8.35"->{
    Cell[120054, 4707, 530, 11, 70, "Text",
      CellTags->{"S3.4.8", "8.35"}]},
  "8.36"->{
    Cell[120587, 4720, 568, 12, 70, "Text",
      CellTags->{"S3.4.8", "8.36"}]},
  "8.37"->{
    Cell[121158, 4734, 173, 5, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.37"}]},
  "8.38"->{
    Cell[121585, 4753, 95, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.38"}]},
  "8.39"->{
    Cell[121793, 4760, 97, 1, 70, "MathCaption",
      CellTags->{"S3.4.8", "8.39"}]},
  "S3.4.9"->{
    Cell[134452, 5479, 98, 1, 70, "Subsection",
      CellTags->{"S3.4.9", "9.1"}],
    Cell[134553, 5482, 380, 9, 70, "Text",
      CellTags->{"S3.4.9", "9.2"}],
    Cell[134936, 5493, 1700, 54, 70, "DefinitionBox",
      CellTags->"S3.4.9"],
    Cell[136639, 5549, 63, 1, 70, "Caption",
      CellTags->"S3.4.9"],
    Cell[136705, 5552, 207, 6, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.3"}],
    Cell[136937, 5562, 100, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[137040, 5566, 240, 5, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[137295, 5574, 169, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.4"}],
    Cell[137489, 5583, 107, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[137599, 5587, 162, 4, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[137776, 5594, 178, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.5"}],
    Cell[137979, 5603, 110, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[138092, 5607, 114, 3, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[138221, 5613, 517, 17, 70, "Text",
      CellTags->{"S3.4.9", "9.6"}],
    Cell[138741, 5632, 468, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.7"}],
    Cell[139212, 5642, 130, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.8"}],
    Cell[139367, 5650, 94, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[139464, 5654, 142, 4, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[139621, 5661, 138, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.9"}],
    Cell[139784, 5669, 101, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[139888, 5673, 206, 5, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[140109, 5681, 150, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.10"}],
    Cell[140284, 5689, 104, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[140391, 5693, 261, 5, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[140667, 5701, 405, 9, 70, "Text",
      CellTags->{"S3.4.9", "9.11"}],
    Cell[141075, 5712, 139, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.12"}],
    Cell[141239, 5720, 120, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[141362, 5724, 252, 6, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[141629, 5733, 2332, 75, 70, "DefinitionBox",
      CellTags->"S3.4.9"],
    Cell[143964, 5810, 133, 4, 70, "Caption",
      CellTags->"S3.4.9"],
    Cell[144100, 5816, 265, 6, 70, "Text",
      CellTags->{"S3.4.9", "9.13"}],
    Cell[144368, 5824, 172, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.14"}],
    Cell[144565, 5833, 105, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[144673, 5837, 346, 8, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[145034, 5848, 163, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.15"}],
    Cell[145222, 5857, 101, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[145326, 5861, 637, 13, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[145978, 5877, 393, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.16"}],
    Cell[146374, 5887, 132, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.17"}],
    Cell[146531, 5895, 106, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[146640, 5899, 658, 11, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[147313, 5913, 915, 30, 70, "Text",
      CellTags->{"S3.4.9", "9.18"}],
    Cell[148231, 5945, 187, 6, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.19"}],
    Cell[148443, 5955, 140, 5, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[148586, 5962, 166, 4, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[148767, 5969, 284, 7, 70, "Text",
      CellTags->{"S3.4.9", "9.20"}],
    Cell[149054, 5978, 141, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.21"}],
    Cell[149220, 5986, 96, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[149319, 5990, 121, 3, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[149455, 5996, 116, 2, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.22"}],
    Cell[149596, 6002, 99, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[149698, 6006, 488, 9, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[150201, 6018, 142, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.23"}],
    Cell[150368, 6026, 118, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[150489, 6030, 287, 6, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[150791, 6039, 740, 24, 70, "Text",
      CellTags->{"S3.4.9", "9.24"}],
    Cell[151534, 6065, 141, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.25"}],
    Cell[151700, 6073, 118, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[151821, 6077, 438, 9, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[152274, 6089, 285, 7, 70, "Text",
      CellTags->{"S3.4.9", "9.26"}],
    Cell[152562, 6098, 96, 1, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.27"}],
    Cell[152683, 6103, 124, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[152810, 6107, 334, 7, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[153159, 6117, 167, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.28"}],
    Cell[153351, 6126, 110, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[153464, 6130, 277, 6, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[153756, 6139, 158, 4, 70, "Text",
      CellTags->{"S3.4.9", "9.29"}],
    Cell[153917, 6145, 150, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.30"}],
    Cell[154092, 6154, 115, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[154210, 6158, 370, 8, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[154595, 6169, 176, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.31"}],
    Cell[154796, 6178, 115, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[154914, 6182, 87, 3, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[155016, 6188, 237, 5, 70, "Text",
      CellTags->{"S3.4.9", "9.32"}],
    Cell[155256, 6195, 403, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.33"}],
    Cell[155662, 6205, 772, 14, 70, "Text",
      CellTags->{"S3.4.9", "9.34"}],
    Cell[156437, 6221, 216, 6, 70, "Text",
      CellTags->{"S3.4.9", "9.35"}],
    Cell[156656, 6229, 161, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.36"}],
    Cell[156842, 6237, 149, 5, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[156994, 6244, 617, 12, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[157626, 6259, 731, 23, 70, "DefinitionBox",
      CellTags->"S3.4.9"],
    Cell[158360, 6284, 133, 5, 70, "Caption",
      CellTags->"S3.4.9"],
    Cell[158496, 6291, 255, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.37"}],
    Cell[158754, 6301, 90, 1, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.38"}],
    Cell[158869, 6306, 115, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[158987, 6310, 350, 7, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[159352, 6320, 158, 4, 70, "Text",
      CellTags->{"S3.4.9", "9.39"}],
    Cell[159513, 6326, 107, 1, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.40"}],
    Cell[159645, 6331, 117, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[159765, 6335, 202, 4, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[159982, 6342, 1763, 49, 70, "DefinitionBox",
      CellTags->"S3.4.9"],
    Cell[161748, 6393, 90, 1, 70, "Caption",
      CellTags->"S3.4.9"],
    Cell[161841, 6396, 179, 7, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.41"}],
    Cell[162045, 6407, 151, 5, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[162199, 6414, 288, 7, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[162502, 6424, 445, 14, 70, "Text",
      CellTags->{"S3.4.9", "9.42"}],
    Cell[162950, 6440, 110, 1, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.43"}],
    Cell[163085, 6445, 87, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[163175, 6449, 227, 5, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[163417, 6457, 129, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.44"}],
    Cell[163571, 6465, 92, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[163666, 6469, 159, 4, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[163840, 6476, 389, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.45"}],
    Cell[164232, 6486, 165, 6, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.46"}],
    Cell[164422, 6496, 83, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[164508, 6500, 96, 3, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[164619, 6506, 191, 7, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.47"}],
    Cell[164835, 6517, 94, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[164932, 6521, 198, 5, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[165145, 6529, 217, 7, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.48"}],
    Cell[165387, 6540, 86, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[165476, 6544, 165, 4, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[165656, 6551, 167, 7, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.49"}],
    Cell[165848, 6562, 126, 4, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[165977, 6568, 348, 7, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[166340, 6578, 3637, 111, 70, "DefinitionBox",
      CellTags->"S3.4.9"],
    Cell[169980, 6691, 82, 1, 70, "Caption",
      CellTags->"S3.4.9"],
    Cell[170065, 6694, 335, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.50"}],
    Cell[170403, 6704, 825, 29, 70, "Text",
      CellTags->{"S3.4.9", "9.51"}],
    Cell[171231, 6735, 351, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.52"}],
    Cell[171585, 6745, 117, 2, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.53"}],
    Cell[171727, 6751, 138, 5, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[171868, 6758, 112, 3, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[171995, 6764, 540, 17, 70, "Text",
      CellTags->{"S3.4.9", "9.54"}],
    Cell[172538, 6783, 190, 7, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.55"}],
    Cell[172753, 6794, 114, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[172870, 6798, 84, 3, 70, "Output",
      CellTags->"S3.4.9"],
    Cell[172969, 6804, 69, 1, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.56"}],
    Cell[173063, 6809, 116, 2, 70, "Input",
      CellTags->"S3.4.9"],
    Cell[173182, 6813, 116, 3, 70, "Output",
      CellTags->"S3.4.9"]},
  "9.1"->{
    Cell[134452, 5479, 98, 1, 70, "Subsection",
      CellTags->{"S3.4.9", "9.1"}]},
  "9.2"->{
    Cell[134553, 5482, 380, 9, 70, "Text",
      CellTags->{"S3.4.9", "9.2"}]},
  "9.3"->{
    Cell[136705, 5552, 207, 6, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.3"}]},
  "9.4"->{
    Cell[137295, 5574, 169, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.4"}]},
  "9.5"->{
    Cell[137776, 5594, 178, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.5"}]},
  "9.6"->{
    Cell[138221, 5613, 517, 17, 70, "Text",
      CellTags->{"S3.4.9", "9.6"}]},
  "9.7"->{
    Cell[138741, 5632, 468, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.7"}]},
  "9.8"->{
    Cell[139212, 5642, 130, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.8"}]},
  "9.9"->{
    Cell[139621, 5661, 138, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.9"}]},
  "9.10"->{
    Cell[140109, 5681, 150, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.10"}]},
  "9.11"->{
    Cell[140667, 5701, 405, 9, 70, "Text",
      CellTags->{"S3.4.9", "9.11"}]},
  "9.12"->{
    Cell[141075, 5712, 139, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.12"}]},
  "9.13"->{
    Cell[144100, 5816, 265, 6, 70, "Text",
      CellTags->{"S3.4.9", "9.13"}]},
  "9.14"->{
    Cell[144368, 5824, 172, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.14"}]},
  "9.15"->{
    Cell[145034, 5848, 163, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.15"}]},
  "9.16"->{
    Cell[145978, 5877, 393, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.16"}]},
  "9.17"->{
    Cell[146374, 5887, 132, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.17"}]},
  "9.18"->{
    Cell[147313, 5913, 915, 30, 70, "Text",
      CellTags->{"S3.4.9", "9.18"}]},
  "9.19"->{
    Cell[148231, 5945, 187, 6, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.19"}]},
  "9.20"->{
    Cell[148767, 5969, 284, 7, 70, "Text",
      CellTags->{"S3.4.9", "9.20"}]},
  "9.21"->{
    Cell[149054, 5978, 141, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.21"}]},
  "9.22"->{
    Cell[149455, 5996, 116, 2, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.22"}]},
  "9.23"->{
    Cell[150201, 6018, 142, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.23"}]},
  "9.24"->{
    Cell[150791, 6039, 740, 24, 70, "Text",
      CellTags->{"S3.4.9", "9.24"}]},
  "9.25"->{
    Cell[151534, 6065, 141, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.25"}]},
  "9.26"->{
    Cell[152274, 6089, 285, 7, 70, "Text",
      CellTags->{"S3.4.9", "9.26"}]},
  "9.27"->{
    Cell[152562, 6098, 96, 1, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.27"}]},
  "9.28"->{
    Cell[153159, 6117, 167, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.28"}]},
  "9.29"->{
    Cell[153756, 6139, 158, 4, 70, "Text",
      CellTags->{"S3.4.9", "9.29"}]},
  "9.30"->{
    Cell[153917, 6145, 150, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.30"}]},
  "9.31"->{
    Cell[154595, 6169, 176, 5, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.31"}]},
  "9.32"->{
    Cell[155016, 6188, 237, 5, 70, "Text",
      CellTags->{"S3.4.9", "9.32"}]},
  "9.33"->{
    Cell[155256, 6195, 403, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.33"}]},
  "9.34"->{
    Cell[155662, 6205, 772, 14, 70, "Text",
      CellTags->{"S3.4.9", "9.34"}]},
  "9.35"->{
    Cell[156437, 6221, 216, 6, 70, "Text",
      CellTags->{"S3.4.9", "9.35"}]},
  "9.36"->{
    Cell[156656, 6229, 161, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.36"}]},
  "9.37"->{
    Cell[158496, 6291, 255, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.37"}]},
  "9.38"->{
    Cell[158754, 6301, 90, 1, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.38"}]},
  "9.39"->{
    Cell[159352, 6320, 158, 4, 70, "Text",
      CellTags->{"S3.4.9", "9.39"}]},
  "9.40"->{
    Cell[159513, 6326, 107, 1, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.40"}]},
  "9.41"->{
    Cell[161841, 6396, 179, 7, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.41"}]},
  "9.42"->{
    Cell[162502, 6424, 445, 14, 70, "Text",
      CellTags->{"S3.4.9", "9.42"}]},
  "9.43"->{
    Cell[162950, 6440, 110, 1, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.43"}]},
  "9.44"->{
    Cell[163417, 6457, 129, 4, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.44"}]},
  "9.45"->{
    Cell[163840, 6476, 389, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.45"}]},
  "9.46"->{
    Cell[164232, 6486, 165, 6, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.46"}]},
  "9.47"->{
    Cell[164619, 6506, 191, 7, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.47"}]},
  "9.48"->{
    Cell[165145, 6529, 217, 7, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.48"}]},
  "9.49"->{
    Cell[165656, 6551, 167, 7, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.49"}]},
  "9.50"->{
    Cell[170065, 6694, 335, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.50"}]},
  "9.51"->{
    Cell[170403, 6704, 825, 29, 70, "Text",
      CellTags->{"S3.4.9", "9.51"}]},
  "9.52"->{
    Cell[171231, 6735, 351, 8, 70, "Text",
      CellTags->{"S3.4.9", "9.52"}]},
  "9.53"->{
    Cell[171585, 6745, 117, 2, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.53"}]},
  "9.54"->{
    Cell[171995, 6764, 540, 17, 70, "Text",
      CellTags->{"S3.4.9", "9.54"}]},
  "9.55"->{
    Cell[172538, 6783, 190, 7, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.55"}]},
  "9.56"->{
    Cell[172969, 6804, 69, 1, 70, "MathCaption",
      CellTags->{"S3.4.9", "9.56"}]},
  "S3.4.10"->{
    Cell[173347, 6822, 115, 2, 70, "Subsection",
      CellTags->{"S3.4.10", "10.1"}],
    Cell[173465, 6826, 316, 7, 70, "Text",
      CellTags->{"S3.4.10", "10.2"}],
    Cell[173784, 6835, 429, 9, 70, "Text",
      CellTags->{"S3.4.10", "10.3"}],
    Cell[174216, 6846, 134, 4, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.4"}],
    Cell[174375, 6854, 94, 2, 70, "Input",
      CellTags->"S3.4.10"],
    Cell[174472, 6858, 106, 3, 70, "Output",
      CellTags->"S3.4.10"],
    Cell[174593, 6864, 203, 6, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.5"}],
    Cell[174821, 6874, 95, 2, 70, "Input",
      CellTags->"S3.4.10"],
    Cell[174919, 6878, 86, 3, 70, "Output",
      CellTags->"S3.4.10"],
    Cell[175020, 6884, 153, 4, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.6"}],
    Cell[175198, 6892, 85, 2, 70, "Input",
      CellTags->"S3.4.10"],
    Cell[175286, 6896, 135, 3, 70, "Output",
      CellTags->"S3.4.10"],
    Cell[175436, 6902, 247, 8, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.7"}],
    Cell[175708, 6914, 78, 2, 70, "Input",
      CellTags->"S3.4.10"],
    Cell[175789, 6918, 110, 3, 70, "Output",
      CellTags->"S3.4.10"],
    Cell[175914, 6924, 2019, 73, 70, "Text",
      CellTags->{"S3.4.10", "10.8"}],
    Cell[177936, 6999, 221, 8, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.9"}],
    Cell[178182, 7011, 85, 2, 70, "Input",
      CellTags->"S3.4.10"],
    Cell[178270, 7015, 122, 3, 70, "Output",
      CellTags->"S3.4.10"],
    Cell[178407, 7021, 1105, 42, 70, "Text",
      CellTags->{"S3.4.10", "10.10"}],
    Cell[179515, 7065, 892, 30, 70, "Text",
      CellTags->{"S3.4.10", "10.11"}],
    Cell[180410, 7097, 916, 34, 70, "Text",
      CellTags->{"S3.4.10", "10.12"}],
    Cell[181329, 7133, 1296, 42, 70, "Text",
      CellTags->{"S3.4.10", "10.13"}],
    Cell[182628, 7177, 220, 9, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.14"}],
    Cell[182873, 7190, 110, 2, 70, "Input",
      CellTags->"S3.4.10"],
    Cell[182986, 7194, 225, 5, 70, "Output",
      CellTags->"S3.4.10"],
    Cell[183226, 7202, 203, 7, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.15"}],
    Cell[183454, 7213, 146, 5, 70, "Input",
      CellTags->"S3.4.10"],
    Cell[183603, 7220, 468, 11, 70, "Output",
      CellTags->"S3.4.10"],
    Cell[184086, 7234, 1203, 35, 70, "DefinitionBox",
      CellTags->"S3.4.10"],
    Cell[185292, 7271, 79, 1, 70, "Caption",
      CellTags->"S3.4.10"],
    Cell[185374, 7274, 497, 15, 70, "Text",
      CellTags->{"S3.4.10", "10.16"}]},
  "10.1"->{
    Cell[173347, 6822, 115, 2, 70, "Subsection",
      CellTags->{"S3.4.10", "10.1"}]},
  "10.2"->{
    Cell[173465, 6826, 316, 7, 70, "Text",
      CellTags->{"S3.4.10", "10.2"}]},
  "10.3"->{
    Cell[173784, 6835, 429, 9, 70, "Text",
      CellTags->{"S3.4.10", "10.3"}]},
  "10.4"->{
    Cell[174216, 6846, 134, 4, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.4"}]},
  "10.5"->{
    Cell[174593, 6864, 203, 6, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.5"}]},
  "10.6"->{
    Cell[175020, 6884, 153, 4, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.6"}]},
  "10.7"->{
    Cell[175436, 6902, 247, 8, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.7"}]},
  "10.8"->{
    Cell[175914, 6924, 2019, 73, 70, "Text",
      CellTags->{"S3.4.10", "10.8"}]},
  "10.9"->{
    Cell[177936, 6999, 221, 8, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.9"}]},
  "10.10"->{
    Cell[178407, 7021, 1105, 42, 70, "Text",
      CellTags->{"S3.4.10", "10.10"}]},
  "10.11"->{
    Cell[179515, 7065, 892, 30, 70, "Text",
      CellTags->{"S3.4.10", "10.11"}]},
  "10.12"->{
    Cell[180410, 7097, 916, 34, 70, "Text",
      CellTags->{"S3.4.10", "10.12"}]},
  "10.13"->{
    Cell[181329, 7133, 1296, 42, 70, "Text",
      CellTags->{"S3.4.10", "10.13"}]},
  "10.14"->{
    Cell[182628, 7177, 220, 9, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.14"}]},
  "10.15"->{
    Cell[183226, 7202, 203, 7, 70, "MathCaption",
      CellTags->{"S3.4.10", "10.15"}]},
  "10.16"->{
    Cell[185374, 7274, 497, 15, 70, "Text",
      CellTags->{"S3.4.10", "10.16"}]},
  "S3.4.11"->{
    Cell[185908, 7294, 89, 1, 70, "Subsection",
      CellTags->{"S3.4.11", "11.1"}],
    Cell[186000, 7297, 587, 23, 70, "Text",
      CellTags->{"S3.4.11", "11.2"}],
    Cell[186590, 7322, 5988, 180, 70, "DefinitionBox",
      CellTags->"S3.4.11"],
    Cell[192581, 7504, 72, 1, 70, "Caption",
      CellTags->"S3.4.11"],
    Cell[192656, 7507, 427, 11, 70, "Text",
      CellTags->{"S3.4.11", "11.3"}],
    Cell[193086, 7520, 222, 6, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.4"}],
    Cell[193333, 7530, 89, 2, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[193425, 7534, 111, 3, 70, "Output",
      CellTags->"S3.4.11"],
    Cell[193551, 7540, 147, 4, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.5"}],
    Cell[193723, 7548, 80, 2, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[193806, 7552, 86, 3, 70, "Output",
      CellTags->"S3.4.11"],
    Cell[193907, 7558, 189, 7, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.6"}],
    Cell[194121, 7569, 103, 2, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[194227, 7573, 87, 3, 70, "Output",
      CellTags->"S3.4.11"],
    Cell[194329, 7579, 856, 22, 70, "Text",
      CellTags->{"S3.4.11", "11.7"}],
    Cell[195188, 7603, 5531, 164, 70, "DefinitionBox",
      CellTags->"S3.4.11"],
    Cell[200722, 7769, 68, 1, 70, "Caption",
      CellTags->"S3.4.11"],
    Cell[200793, 7772, 525, 11, 70, "Text",
      CellTags->{"S3.4.11", "11.8"}],
    Cell[201321, 7785, 996, 31, 70, "DefinitionBox",
      CellTags->"S3.4.11"],
    Cell[202320, 7818, 66, 1, 70, "Caption",
      CellTags->"S3.4.11"],
    Cell[202389, 7821, 158, 5, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.9"}],
    Cell[202572, 7830, 95, 2, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[202670, 7834, 86, 3, 70, "Output",
      CellTags->"S3.4.11"],
    Cell[202771, 7840, 185, 5, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.10"}],
    Cell[202981, 7849, 109, 2, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[203093, 7853, 120, 3, 70, "Output",
      CellTags->"S3.4.11"],
    Cell[203228, 7859, 361, 7, 70, "Text",
      CellTags->{"S3.4.11", "11.11"}],
    Cell[203592, 7868, 145, 4, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.12"}],
    Cell[203762, 7876, 111, 2, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[203876, 7880, 282, 5, 70, "Output",
      CellTags->"S3.4.11"],
    Cell[204173, 7888, 229, 7, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.13"}],
    Cell[204427, 7899, 113, 2, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[204543, 7903, 86, 3, 70, "Output",
      CellTags->"S3.4.11"],
    Cell[204644, 7909, 572, 13, 70, "Text",
      CellTags->{"S3.4.11", "11.14"}],
    Cell[205219, 7924, 112, 1, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.15"}],
    Cell[205356, 7929, 104, 2, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[205463, 7933, 315, 7, 70, "Output",
      CellTags->"S3.4.11"],
    Cell[205793, 7943, 130, 4, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.16"}],
    Cell[205948, 7951, 112, 2, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[206063, 7955, 101, 3, 70, "Output",
      CellTags->"S3.4.11"],
    Cell[206179, 7961, 149, 4, 70, "Text",
      CellTags->{"S3.4.11", "11.17"}],
    Cell[206331, 7967, 157, 4, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.18"}],
    Cell[206513, 7975, 150, 5, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[206666, 7982, 378, 8, 70, "Output",
      CellTags->"S3.4.11"],
    Cell[207059, 7993, 119, 2, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.19"}],
    Cell[207203, 7999, 144, 5, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[207350, 8006, 223, 5, 70, "Output",
      CellTags->"S3.4.11"],
    Cell[207588, 8014, 147, 5, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.20"}],
    Cell[207738, 8021, 104, 2, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[207845, 8025, 143, 4, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.21"}],
    Cell[208013, 8033, 144, 5, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[208160, 8040, 253, 5, 70, "Output",
      CellTags->"S3.4.11"],
    Cell[208428, 8048, 239, 6, 70, "Text",
      CellTags->{"S3.4.11", "11.22"}],
    Cell[208670, 8056, 192, 6, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.23"}],
    Cell[208887, 8066, 122, 2, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[209012, 8070, 88, 3, 70, "Output",
      CellTags->"S3.4.11"],
    Cell[209115, 8076, 159, 5, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.24"}],
    Cell[209299, 8085, 124, 2, 70, "Input",
      CellTags->"S3.4.11"],
    Cell[209426, 8089, 87, 3, 70, "Output",
      CellTags->"S3.4.11"]},
  "11.1"->{
    Cell[185908, 7294, 89, 1, 70, "Subsection",
      CellTags->{"S3.4.11", "11.1"}]},
  "11.2"->{
    Cell[186000, 7297, 587, 23, 70, "Text",
      CellTags->{"S3.4.11", "11.2"}]},
  "11.3"->{
    Cell[192656, 7507, 427, 11, 70, "Text",
      CellTags->{"S3.4.11", "11.3"}]},
  "11.4"->{
    Cell[193086, 7520, 222, 6, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.4"}]},
  "11.5"->{
    Cell[193551, 7540, 147, 4, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.5"}]},
  "11.6"->{
    Cell[193907, 7558, 189, 7, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.6"}]},
  "11.7"->{
    Cell[194329, 7579, 856, 22, 70, "Text",
      CellTags->{"S3.4.11", "11.7"}]},
  "11.8"->{
    Cell[200793, 7772, 525, 11, 70, "Text",
      CellTags->{"S3.4.11", "11.8"}]},
  "11.9"->{
    Cell[202389, 7821, 158, 5, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.9"}]},
  "11.10"->{
    Cell[202771, 7840, 185, 5, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.10"}]},
  "11.11"->{
    Cell[203228, 7859, 361, 7, 70, "Text",
      CellTags->{"S3.4.11", "11.11"}]},
  "11.12"->{
    Cell[203592, 7868, 145, 4, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.12"}]},
  "11.13"->{
    Cell[204173, 7888, 229, 7, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.13"}]},
  "11.14"->{
    Cell[204644, 7909, 572, 13, 70, "Text",
      CellTags->{"S3.4.11", "11.14"}]},
  "11.15"->{
    Cell[205219, 7924, 112, 1, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.15"}]},
  "11.16"->{
    Cell[205793, 7943, 130, 4, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.16"}]},
  "11.17"->{
    Cell[206179, 7961, 149, 4, 70, "Text",
      CellTags->{"S3.4.11", "11.17"}]},
  "11.18"->{
    Cell[206331, 7967, 157, 4, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.18"}]},
  "11.19"->{
    Cell[207059, 7993, 119, 2, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.19"}]},
  "11.20"->{
    Cell[207588, 8014, 147, 5, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.20"}]},
  "11.21"->{
    Cell[207845, 8025, 143, 4, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.21"}]},
  "11.22"->{
    Cell[208428, 8048, 239, 6, 70, "Text",
      CellTags->{"S3.4.11", "11.22"}]},
  "11.23"->{
    Cell[208670, 8056, 192, 6, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.23"}]},
  "11.24"->{
    Cell[209115, 8076, 159, 5, 70, "MathCaption",
      CellTags->{"S3.4.11", "11.24"}]},
  "S3.4.12"->{
    Cell[209562, 8098, 91, 1, 70, "Subsection",
      CellTags->{"S3.4.12", "12.1"}],
    Cell[209656, 8101, 4317, 132, 70, "DefinitionBox",
      CellTags->"S3.4.12"],
    Cell[213976, 8235, 73, 1, 70, "Caption",
      CellTags->"S3.4.12"],
    Cell[214052, 8238, 272, 7, 70, "Text",
      CellTags->{"S3.4.12", "12.2"}],
    Cell[214327, 8247, 104, 1, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.3"}],
    Cell[214456, 8252, 90, 2, 70, "Input",
      CellTags->"S3.4.12"],
    Cell[214549, 8256, 107, 3, 70, "Output",
      CellTags->"S3.4.12"],
    Cell[214671, 8262, 156, 5, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.4"}],
    Cell[214852, 8271, 88, 2, 70, "Input",
      CellTags->"S3.4.12"],
    Cell[214943, 8275, 87, 3, 70, "Output",
      CellTags->"S3.4.12"],
    Cell[215045, 8281, 186, 7, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.5"}],
    Cell[215256, 8292, 100, 2, 70, "Input",
      CellTags->"S3.4.12"],
    Cell[215359, 8296, 154, 4, 70, "Output",
      CellTags->"S3.4.12"],
    Cell[215528, 8303, 896, 34, 70, "Text",
      CellTags->{"S3.4.12", "12.6"}],
    Cell[216427, 8339, 288, 10, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.7"}],
    Cell[216740, 8353, 100, 2, 70, "Input",
      CellTags->"S3.4.12"],
    Cell[216843, 8357, 100, 3, 70, "Output",
      CellTags->"S3.4.12"],
    Cell[216958, 8363, 103, 1, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.8"}],
    Cell[217086, 8368, 118, 2, 70, "Input",
      CellTags->"S3.4.12"],
    Cell[217207, 8372, 143, 4, 70, "Output",
      CellTags->"S3.4.12"],
    Cell[217365, 8379, 142, 4, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.9"}],
    Cell[217532, 8387, 119, 2, 70, "Input",
      CellTags->"S3.4.12"],
    Cell[217654, 8391, 385, 8, 70, "Output",
      CellTags->"S3.4.12"],
    Cell[218054, 8402, 94, 1, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.10"}],
    Cell[218173, 8407, 114, 2, 70, "Input",
      CellTags->"S3.4.12"],
    Cell[218290, 8411, 122, 3, 70, "Output",
      CellTags->"S3.4.12"],
    Cell[218427, 8417, 553, 20, 70, "Text",
      CellTags->{"S3.4.12", "12.11"}],
    Cell[218983, 8439, 103, 1, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.12"}],
    Cell[219111, 8444, 122, 2, 70, "Input",
      CellTags->"S3.4.12"],
    Cell[219236, 8448, 124, 3, 70, "Output",
      CellTags->"S3.4.12"],
    Cell[219375, 8454, 367, 7, 70, "Text",
      CellTags->{"S3.4.12", "12.13"}],
    Cell[219745, 8463, 170, 4, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.14"}],
    Cell[219940, 8471, 100, 2, 70, "Input",
      CellTags->"S3.4.12"],
    Cell[220043, 8475, 122, 3, 70, "Output",
      CellTags->"S3.4.12"],
    Cell[220180, 8481, 143, 4, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.15"}],
    Cell[220348, 8489, 118, 2, 70, "Input",
      CellTags->"S3.4.12"],
    Cell[220469, 8493, 181, 4, 70, "Output",
      CellTags->"S3.4.12"],
    Cell[220665, 8500, 498, 15, 70, "Text",
      CellTags->{"S3.4.12", "12.16"}],
    Cell[221166, 8517, 111, 1, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.17"}],
    Cell[221302, 8522, 98, 2, 70, "Input",
      CellTags->"S3.4.12"],
    Cell[221403, 8526, 5438, 373, 186, 5364, 370, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.4.12"],
    Cell[226844, 8901, 179, 5, 70, "Output",
      CellTags->"S3.4.12"],
    Cell[227038, 8909, 130, 4, 40, "MathCaption",
      CellTags->{"S3.4.12", "12.18"}],
    Cell[227193, 8917, 109, 2, 28, "Input",
      CellTags->"S3.4.12"],
    Cell[227305, 8921, 135, 3, 42, "Output",
      CellTags->"S3.4.12"],
    Cell[227455, 8927, 829, 26, 72, "Text",
      CellTags->{"S3.4.12", "12.19"}],
    Cell[228287, 8955, 818, 31, 88, "Text",
      CellTags->{"S3.4.12", "12.20"}],
    Cell[229108, 8988, 197, 5, 56, "MathCaption",
      CellTags->{"S3.4.12", "12.21"}],
    Cell[229330, 8997, 100, 2, 28, "Input",
      CellTags->"S3.4.12"],
    Cell[229433, 9001, 210, 4, 44, "Message",
      CellTags->"S3.4.12"],
    Cell[229646, 9007, 101, 3, 25, "Output",
      CellTags->"S3.4.12"],
    Cell[229762, 9013, 439, 14, 56, "Text",
      CellTags->{"S3.4.12", "12.22"}],
    Cell[230204, 9029, 189, 7, 40, "MathCaption",
      CellTags->{"S3.4.12", "12.23"}],
    Cell[230418, 9040, 147, 5, 45, "Input",
      CellTags->"S3.4.12"],
    Cell[230568, 9047, 125, 3, 25, "Output",
      CellTags->"S3.4.12"]},
  "12.1"->{
    Cell[209562, 8098, 91, 1, 70, "Subsection",
      CellTags->{"S3.4.12", "12.1"}]},
  "12.2"->{
    Cell[214052, 8238, 272, 7, 70, "Text",
      CellTags->{"S3.4.12", "12.2"}]},
  "12.3"->{
    Cell[214327, 8247, 104, 1, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.3"}]},
  "12.4"->{
    Cell[214671, 8262, 156, 5, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.4"}]},
  "12.5"->{
    Cell[215045, 8281, 186, 7, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.5"}]},
  "12.6"->{
    Cell[215528, 8303, 896, 34, 70, "Text",
      CellTags->{"S3.4.12", "12.6"}]},
  "12.7"->{
    Cell[216427, 8339, 288, 10, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.7"}]},
  "12.8"->{
    Cell[216958, 8363, 103, 1, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.8"}]},
  "12.9"->{
    Cell[217365, 8379, 142, 4, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.9"}]},
  "12.10"->{
    Cell[218054, 8402, 94, 1, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.10"}]},
  "12.11"->{
    Cell[218427, 8417, 553, 20, 70, "Text",
      CellTags->{"S3.4.12", "12.11"}]},
  "12.12"->{
    Cell[218983, 8439, 103, 1, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.12"}]},
  "12.13"->{
    Cell[219375, 8454, 367, 7, 70, "Text",
      CellTags->{"S3.4.12", "12.13"}]},
  "12.14"->{
    Cell[219745, 8463, 170, 4, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.14"}]},
  "12.15"->{
    Cell[220180, 8481, 143, 4, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.15"}]},
  "12.16"->{
    Cell[220665, 8500, 498, 15, 70, "Text",
      CellTags->{"S3.4.12", "12.16"}]},
  "12.17"->{
    Cell[221166, 8517, 111, 1, 70, "MathCaption",
      CellTags->{"S3.4.12", "12.17"}]},
  "12.18"->{
    Cell[227038, 8909, 130, 4, 40, "MathCaption",
      CellTags->{"S3.4.12", "12.18"}]},
  "12.19"->{
    Cell[227455, 8927, 829, 26, 72, "Text",
      CellTags->{"S3.4.12", "12.19"}]},
  "12.20"->{
    Cell[228287, 8955, 818, 31, 88, "Text",
      CellTags->{"S3.4.12", "12.20"}]},
  "12.21"->{
    Cell[229108, 8988, 197, 5, 56, "MathCaption",
      CellTags->{"S3.4.12", "12.21"}]},
  "12.22"->{
    Cell[229762, 9013, 439, 14, 56, "Text",
      CellTags->{"S3.4.12", "12.22"}]},
  "12.23"->{
    Cell[230204, 9029, 189, 7, 40, "MathCaption",
      CellTags->{"S3.4.12", "12.23"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S3.4.0", 231348, 9071},
  {"0.1", 231438, 9074},
  {"S3.4.1", 231531, 9077},
  {"1.1", 233403, 9128},
  {"1.2", 233496, 9131},
  {"1.3", 233585, 9134},
  {"1.4", 233674, 9137},
  {"1.5", 233762, 9140},
  {"1.6", 233856, 9143},
  {"1.7", 233951, 9146},
  {"1.8", 234041, 9149},
  {"1.9", 234130, 9152},
  {"1.10", 234220, 9155},
  {"1.11", 234317, 9158},
  {"1.12", 234414, 9161},
  {"1.13", 234511, 9164},
  {"S3.4.2", 234610, 9167},
  {"2.1", 245147, 9448},
  {"2.2", 245241, 9451},
  {"2.3", 245330, 9454},
  {"2.4", 245426, 9457},
  {"2.5", 245522, 9460},
  {"2.6", 245618, 9463},
  {"2.7", 245707, 9466},
  {"2.8", 245796, 9469},
  {"2.9", 245885, 9472},
  {"2.10", 245975, 9475},
  {"2.11", 246072, 9478},
  {"2.12", 246170, 9481},
  {"2.13", 246268, 9484},
  {"2.14", 246366, 9487},
  {"2.15", 246464, 9490},
  {"2.16", 246562, 9493},
  {"2.17", 246660, 9496},
  {"2.18", 246751, 9499},
  {"2.19", 246849, 9502},
  {"2.20", 246947, 9505},
  {"2.21", 247045, 9508},
  {"2.22", 247143, 9511},
  {"2.23", 247241, 9514},
  {"2.24", 247339, 9517},
  {"2.25", 247430, 9520},
  {"2.26", 247528, 9523},
  {"2.27", 247626, 9526},
  {"2.28", 247724, 9529},
  {"2.29", 247823, 9532},
  {"2.30", 247916, 9535},
  {"2.31", 248015, 9538},
  {"2.32", 248114, 9541},
  {"2.33", 248206, 9544},
  {"2.34", 248304, 9547},
  {"2.35", 248402, 9550},
  {"2.36", 248495, 9553},
  {"2.37", 248594, 9556},
  {"2.38", 248693, 9559},
  {"2.39", 248792, 9562},
  {"2.40", 248885, 9565},
  {"2.41", 248984, 9568},
  {"2.42", 249083, 9571},
  {"2.43", 249175, 9574},
  {"2.44", 249274, 9577},
  {"2.45", 249373, 9580},
  {"2.46", 249471, 9583},
  {"2.47", 249570, 9586},
  {"2.48", 249662, 9589},
  {"2.49", 249761, 9592},
  {"2.50", 249860, 9595},
  {"2.51", 249953, 9598},
  {"2.52", 250052, 9601},
  {"2.53", 250151, 9604},
  {"S3.4.3", 250252, 9607},
  {"3.1", 254192, 9712},
  {"3.2", 254287, 9715},
  {"3.3", 254384, 9718},
  {"3.4", 254481, 9721},
  {"3.5", 254571, 9724},
  {"3.6", 254668, 9727},
  {"3.7", 254765, 9730},
  {"3.8", 254862, 9733},
  {"3.9", 254959, 9736},
  {"3.10", 255057, 9739},
  {"3.11", 255156, 9742},
  {"3.12", 255255, 9745},
  {"3.13", 255349, 9748},
  {"3.14", 255448, 9751},
  {"3.15", 255547, 9754},
  {"3.16", 255639, 9757},
  {"3.17", 255739, 9760},
  {"3.18", 255838, 9763},
  {"S3.4.4", 255939, 9766},
  {"4.1", 259055, 9849},
  {"4.2", 259150, 9852},
  {"4.3", 259240, 9855},
  {"4.4", 259337, 9858},
  {"4.5", 259434, 9861},
  {"4.6", 259531, 9864},
  {"4.7", 259628, 9867},
  {"4.8", 259725, 9870},
  {"4.9", 259816, 9873},
  {"4.10", 259914, 9876},
  {"4.11", 260013, 9879},
  {"4.12", 260112, 9882},
  {"4.13", 260211, 9885},
  {"4.14", 260310, 9888},
  {"4.15", 260409, 9891},
  {"S3.4.5", 260503, 9894},
  {"5.1", 265427, 10025},
  {"5.2", 265523, 10028},
  {"5.3", 265614, 10031},
  {"5.4", 265711, 10034},
  {"5.5", 265808, 10037},
  {"5.6", 265899, 10040},
  {"5.7", 265996, 10043},
  {"5.8", 266094, 10046},
  {"5.9", 266192, 10049},
  {"5.10", 266283, 10052},
  {"5.11", 266382, 10055},
  {"5.12", 266481, 10058},
  {"5.13", 266580, 10061},
  {"5.14", 266679, 10064},
  {"5.15", 266778, 10067},
  {"5.16", 266877, 10070},
  {"5.17", 266969, 10073},
  {"5.18", 267069, 10076},
  {"5.19", 267167, 10079},
  {"5.20", 267266, 10082},
  {"5.21", 267365, 10085},
  {"5.22", 267465, 10088},
  {"5.23", 267557, 10091},
  {"5.24", 267656, 10094},
  {"5.25", 267755, 10097},
  {"S3.4.6", 267856, 10100},
  {"6.1", 271055, 10185},
  {"6.2", 271150, 10188},
  {"6.3", 271240, 10191},
  {"6.4", 271338, 10194},
  {"6.5", 271436, 10197},
  {"6.6", 271534, 10200},
  {"6.7", 271632, 10203},
  {"6.8", 271729, 10206},
  {"6.9", 271819, 10209},
  {"6.10", 271917, 10212},
  {"6.11", 272016, 10215},
  {"6.12", 272109, 10218},
  {"6.13", 272209, 10221},
  {"6.14", 272301, 10224},
  {"6.15", 272400, 10227},
  {"6.16", 272498, 10230},
  {"S3.4.7", 272599, 10233},
  {"7.1", 275199, 10302},
  {"7.2", 275295, 10305},
  {"7.3", 275385, 10308},
  {"7.4", 275483, 10311},
  {"7.5", 275580, 10314},
  {"7.6", 275678, 10317},
  {"7.7", 275775, 10320},
  {"7.8", 275872, 10323},
  {"7.9", 275970, 10326},
  {"7.10", 276062, 10329},
  {"7.11", 276162, 10332},
  {"7.12", 276262, 10335},
  {"7.13", 276355, 10338},
  {"7.14", 276447, 10341},
  {"S3.4.8", 276548, 10344},
  {"8.1", 284178, 10543},
  {"8.2", 284273, 10546},
  {"8.3", 284364, 10549},
  {"8.4", 284462, 10552},
  {"8.5", 284560, 10555},
  {"8.6", 284653, 10558},
  {"8.7", 284751, 10561},
  {"8.8", 284849, 10564},
  {"8.9", 284941, 10567},
  {"8.10", 285040, 10570},
  {"8.11", 285140, 10573},
  {"8.12", 285240, 10576},
  {"8.13", 285334, 10579},
  {"8.14", 285434, 10582},
  {"8.15", 285534, 10585},
  {"8.16", 285634, 10588},
  {"8.17", 285727, 10591},
  {"8.18", 285827, 10594},
  {"8.19", 285927, 10597},
  {"8.20", 286020, 10600},
  {"8.21", 286120, 10603},
  {"8.22", 286213, 10606},
  {"8.23", 286313, 10609},
  {"8.24", 286413, 10612},
  {"8.25", 286506, 10615},
  {"8.26", 286606, 10618},
  {"8.27", 286705, 10621},
  {"8.28", 286805, 10624},
  {"8.29", 286905, 10627},
  {"8.30", 286998, 10630},
  {"8.31", 287098, 10633},
  {"8.32", 287198, 10636},
  {"8.33", 287291, 10639},
  {"8.34", 287391, 10642},
  {"8.35", 287491, 10645},
  {"8.36", 287585, 10648},
  {"8.37", 287679, 10651},
  {"8.38", 287779, 10654},
  {"8.39", 287878, 10657},
  {"S3.4.9", 287979, 10660},
  {"9.1", 298030, 10921},
  {"9.2", 298126, 10924},
  {"9.3", 298217, 10927},
  {"9.4", 298315, 10930},
  {"9.5", 298413, 10933},
  {"9.6", 298511, 10936},
  {"9.7", 298603, 10939},
  {"9.8", 298694, 10942},
  {"9.9", 298792, 10945},
  {"9.10", 298891, 10948},
  {"9.11", 298991, 10951},
  {"9.12", 299084, 10954},
  {"9.13", 299184, 10957},
  {"9.14", 299277, 10960},
  {"9.15", 299377, 10963},
  {"9.16", 299477, 10966},
  {"9.17", 299570, 10969},
  {"9.18", 299670, 10972},
  {"9.19", 299764, 10975},
  {"9.20", 299864, 10978},
  {"9.21", 299957, 10981},
  {"9.22", 300057, 10984},
  {"9.23", 300157, 10987},
  {"9.24", 300257, 10990},
  {"9.25", 300351, 10993},
  {"9.26", 300451, 10996},
  {"9.27", 300544, 10999},
  {"9.28", 300643, 11002},
  {"9.29", 300743, 11005},
  {"9.30", 300836, 11008},
  {"9.31", 300936, 11011},
  {"9.32", 301036, 11014},
  {"9.33", 301129, 11017},
  {"9.34", 301222, 11020},
  {"9.35", 301316, 11023},
  {"9.36", 301409, 11026},
  {"9.37", 301509, 11029},
  {"9.38", 301602, 11032},
  {"9.39", 301701, 11035},
  {"9.40", 301794, 11038},
  {"9.41", 301894, 11041},
  {"9.42", 301994, 11044},
  {"9.43", 302088, 11047},
  {"9.44", 302188, 11050},
  {"9.45", 302288, 11053},
  {"9.46", 302381, 11056},
  {"9.47", 302481, 11059},
  {"9.48", 302581, 11062},
  {"9.49", 302681, 11065},
  {"9.50", 302781, 11068},
  {"9.51", 302874, 11071},
  {"9.52", 302968, 11074},
  {"9.53", 303061, 11077},
  {"9.54", 303161, 11080},
  {"9.55", 303255, 11083},
  {"9.56", 303355, 11086},
  {"S3.4.10", 303457, 11089},
  {"10.1", 306002, 11154},
  {"10.2", 306102, 11157},
  {"10.3", 306196, 11160},
  {"10.4", 306290, 11163},
  {"10.5", 306391, 11166},
  {"10.6", 306492, 11169},
  {"10.7", 306593, 11172},
  {"10.8", 306694, 11175},
  {"10.9", 306790, 11178},
  {"10.10", 306892, 11181},
  {"10.11", 306990, 11184},
  {"10.12", 307087, 11187},
  {"10.13", 307184, 11190},
  {"10.14", 307282, 11193},
  {"10.15", 307385, 11196},
  {"10.16", 307488, 11199},
  {"S3.4.11", 307587, 11202},
  {"11.1", 312233, 11321},
  {"11.2", 312332, 11324},
  {"11.3", 312427, 11327},
  {"11.4", 312522, 11330},
  {"11.5", 312623, 11333},
  {"11.6", 312724, 11336},
  {"11.7", 312825, 11339},
  {"11.8", 312920, 11342},
  {"11.9", 313015, 11345},
  {"11.10", 313117, 11348},
  {"11.11", 313220, 11351},
  {"11.12", 313316, 11354},
  {"11.13", 313419, 11357},
  {"11.14", 313522, 11360},
  {"11.15", 313619, 11363},
  {"11.16", 313722, 11366},
  {"11.17", 313825, 11369},
  {"11.18", 313921, 11372},
  {"11.19", 314024, 11375},
  {"11.20", 314127, 11378},
  {"11.21", 314230, 11381},
  {"11.22", 314333, 11384},
  {"11.23", 314429, 11387},
  {"11.24", 314532, 11390},
  {"S3.4.12", 314637, 11393},
  {"12.1", 319047, 11506},
  {"12.2", 319146, 11509},
  {"12.3", 319240, 11512},
  {"12.4", 319341, 11515},
  {"12.5", 319442, 11518},
  {"12.6", 319543, 11521},
  {"12.7", 319638, 11524},
  {"12.8", 319740, 11527},
  {"12.9", 319841, 11530},
  {"12.10", 319943, 11533},
  {"12.11", 320045, 11536},
  {"12.12", 320142, 11539},
  {"12.13", 320245, 11542},
  {"12.14", 320341, 11545},
  {"12.15", 320444, 11548},
  {"12.16", 320547, 11551},
  {"12.17", 320644, 11554},
  {"12.18", 320747, 11557},
  {"12.19", 320850, 11560},
  {"12.20", 320947, 11563},
  {"12.21", 321044, 11566},
  {"12.22", 321147, 11569},
  {"12.23", 321244, 11572}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 142, 4, 65, "Section",
  CellTags->{"S3.4.0", "0.1"}],

Cell[CellGroupData[{
Cell[1943, 61, 104, 1, 70, "Subsection",
  CellTags->{"S3.4.1", "1.1"}],
Cell[2050, 64, 1017, 47, 70, "Text",
  CellTags->{"S3.4.1", "1.2"}],
Cell[3070, 113, 654, 31, 70, "Text",
  CellTags->{"S3.4.1", "1.3"}],
Cell[3727, 146, 305, 7, 70, "Text",
  CellTags->{"S3.4.1", "1.4"}],
Cell[4035, 155, 83, 1, 70, "MathCaption",
  CellTags->{"S3.4.1", "1.5"}],

Cell[CellGroupData[{
Cell[4143, 160, 77, 2, 70, "Input",
  CellTags->"S3.4.1"],
Cell[4223, 164, 103, 3, 70, "Output",
  CellTags->"S3.4.1"]
}, Open  ]],
Cell[4341, 170, 341, 9, 70, "MathCaption",
  CellTags->{"S3.4.1", "1.6"}],

Cell[CellGroupData[{
Cell[4707, 183, 76, 2, 70, "Input",
  CellTags->"S3.4.1"],
Cell[4786, 187, 164, 4, 70, "Output",
  CellTags->"S3.4.1"]
}, Open  ]],
Cell[4965, 194, 1793, 66, 70, "Text",
  CellTags->{"S3.4.1", "1.7"}],
Cell[6761, 262, 462, 13, 70, "Text",
  CellTags->{"S3.4.1", "1.8"}],
Cell[7226, 277, 783, 22, 70, "Text",
  CellTags->{"S3.4.1", "1.9"}],
Cell[8012, 301, 233, 6, 70, "MathCaption",
  CellTags->{"S3.4.1", "1.10"}],

Cell[CellGroupData[{
Cell[8270, 311, 90, 2, 70, "Input",
  CellTags->"S3.4.1"],
Cell[8363, 315, 164, 4, 70, "Output",
  CellTags->"S3.4.1"]
}, Open  ]],
Cell[8542, 322, 181, 5, 70, "MathCaption",
  CellTags->{"S3.4.1", "1.11"}],

Cell[CellGroupData[{
Cell[8748, 331, 78, 2, 70, "Input",
  CellTags->"S3.4.1"],
Cell[8829, 335, 170, 4, 70, "Output",
  CellTags->"S3.4.1"]
}, Open  ]],
Cell[9014, 342, 234, 8, 70, "MathCaption",
  CellTags->{"S3.4.1", "1.12"}],

Cell[CellGroupData[{
Cell[9273, 354, 78, 2, 70, "Input",
  CellTags->"S3.4.1"],
Cell[9354, 358, 219, 5, 70, "Output",
  CellTags->"S3.4.1"]
}, Open  ]],
Cell[9588, 366, 172, 5, 70, "MathCaption",
  CellTags->{"S3.4.1", "1.13"}],

Cell[CellGroupData[{
Cell[9785, 375, 89, 2, 70, "Input",
  CellTags->"S3.4.1"],
Cell[9877, 379, 170, 4, 70, "Output",
  CellTags->"S3.4.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10096, 389, 84, 1, 70, "Subsection",
  CellTags->{"S3.4.2", "2.1"}],
Cell[10183, 392, 247, 9, 70, "Text",
  CellTags->{"S3.4.2", "2.2"}],
Cell[10433, 403, 160, 5, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.3"}],

Cell[CellGroupData[{
Cell[10618, 412, 89, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[10710, 416, 112, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[10837, 422, 138, 4, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.4"}],

Cell[CellGroupData[{
Cell[11000, 430, 95, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[11098, 434, 200, 4, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[11313, 441, 225, 5, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.5"}],

Cell[CellGroupData[{
Cell[11563, 450, 102, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[11668, 454, 211, 4, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[11894, 461, 278, 6, 70, "Text",
  CellTags->{"S3.4.2", "2.6"}],
Cell[12175, 469, 236, 5, 70, "Text",
  CellTags->{"S3.4.2", "2.7"}],
Cell[12414, 476, 252, 5, 70, "Text",
  CellTags->{"S3.4.2", "2.8"}],
Cell[12669, 483, 170, 4, 70, "Text",
  CellTags->{"S3.4.2", "2.9"}],
Cell[12842, 489, 96, 1, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.10"}],

Cell[CellGroupData[{
Cell[12963, 494, 100, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[13066, 498, 117, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[13198, 504, 208, 6, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.11"}],

Cell[CellGroupData[{
Cell[13431, 514, 80, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[13514, 518, 207, 5, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[13736, 526, 101, 1, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.12"}],

Cell[CellGroupData[{
Cell[13862, 531, 111, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[13976, 535, 126, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[14117, 541, 240, 6, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.13"}],

Cell[CellGroupData[{
Cell[14382, 551, 80, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[14465, 555, 405, 7, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[14885, 565, 961, 30, 70, "DefinitionBox",
  CellTags->"S3.4.2"],
Cell[15849, 597, 76, 1, 70, "Caption",
  CellTags->"S3.4.2"],
Cell[15928, 600, 249, 6, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.14"}],

Cell[CellGroupData[{
Cell[16202, 610, 91, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[16296, 614, 325, 7, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[16636, 624, 106, 1, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.15"}],

Cell[CellGroupData[{
Cell[16767, 629, 68, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[16838, 633, 527, 11, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[17380, 647, 211, 6, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.16"}],

Cell[CellGroupData[{
Cell[17616, 657, 93, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[17712, 661, 528, 11, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[18255, 675, 338, 7, 70, "Text",
  CellTags->{"S3.4.2", "2.17"}],
Cell[18596, 684, 186, 5, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.18"}],

Cell[CellGroupData[{
Cell[18807, 693, 92, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[18902, 697, 108, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[19025, 703, 103, 1, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.19"}],

Cell[CellGroupData[{
Cell[19153, 708, 69, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[19225, 712, 106, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[19346, 718, 166, 4, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.20"}],

Cell[CellGroupData[{
Cell[19537, 726, 73, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[19613, 730, 88, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[19716, 736, 166, 4, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.21"}],

Cell[CellGroupData[{
Cell[19907, 744, 103, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[20013, 748, 83, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[20111, 754, 133, 4, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.22"}],

Cell[CellGroupData[{
Cell[20269, 762, 121, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[20393, 766, 89, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[20497, 772, 117, 2, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.23"}],

Cell[CellGroupData[{
Cell[20639, 778, 101, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[20743, 782, 108, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[20866, 788, 355, 7, 70, "Text",
  CellTags->{"S3.4.2", "2.24"}],
Cell[21224, 797, 278, 9, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.25"}],

Cell[CellGroupData[{
Cell[21527, 810, 91, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[21621, 814, 321, 7, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[21957, 824, 259, 9, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.26"}],

Cell[CellGroupData[{
Cell[22241, 837, 88, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[22332, 841, 401, 9, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[22748, 853, 161, 5, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.27"}],

Cell[CellGroupData[{
Cell[22934, 862, 105, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[23042, 866, 3081, 223, 70, 3008, 220, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S3.4.2"],
Cell[26126, 1091, 178, 5, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[26319, 1099, 162, 5, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.28"}],

Cell[CellGroupData[{
Cell[26506, 1108, 93, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[26602, 1112, 133, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[26750, 1118, 723, 20, 70, "Text",
  CellTags->{"S3.4.2", "2.29"}],
Cell[27476, 1140, 147, 4, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.30"}],

Cell[CellGroupData[{
Cell[27648, 1148, 89, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[27740, 1152, 112, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[27867, 1158, 156, 4, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.31"}],

Cell[CellGroupData[{
Cell[28048, 1166, 105, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[28156, 1170, 275, 6, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[28446, 1179, 187, 5, 70, "Text",
  CellTags->{"S3.4.2", "2.32"}],
Cell[28636, 1186, 99, 1, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.33"}],

Cell[CellGroupData[{
Cell[28760, 1191, 102, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[28865, 1195, 131, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[29011, 1201, 93, 1, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.34"}],

Cell[CellGroupData[{
Cell[29129, 1206, 101, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[29233, 1210, 226, 5, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[29474, 1218, 485, 10, 70, "Text",
  CellTags->{"S3.4.2", "2.35"}],
Cell[29962, 1230, 147, 5, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.36"}],

Cell[CellGroupData[{
Cell[30134, 1239, 89, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[30226, 1243, 102, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[30343, 1249, 135, 4, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.37"}],

Cell[CellGroupData[{
Cell[30503, 1257, 86, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[30592, 1261, 197, 4, 70, "Message",
  CellTags->"S3.4.2"],
Cell[30792, 1267, 109, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[30916, 1273, 167, 4, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.38"}],

Cell[CellGroupData[{
Cell[31108, 1281, 94, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[31205, 1285, 113, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[31333, 1291, 667, 16, 70, "Text",
  CellTags->{"S3.4.2", "2.39"}],
Cell[32003, 1309, 246, 6, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.40"}],

Cell[CellGroupData[{
Cell[32274, 1319, 86, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[32363, 1323, 228, 4, 70, "Message",
  CellTags->"S3.4.2"],
Cell[32594, 1329, 105, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[32714, 1335, 149, 5, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.41"}],

Cell[CellGroupData[{
Cell[32888, 1344, 94, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[32985, 1348, 186, 4, 70, "Message",
  CellTags->"S3.4.2"],
Cell[33174, 1354, 228, 4, 70, "Message",
  CellTags->"S3.4.2"],
Cell[33405, 1360, 135, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[33555, 1366, 285, 8, 70, "Text",
  CellTags->{"S3.4.2", "2.42"}],
Cell[33843, 1376, 180, 6, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.43"}],

Cell[CellGroupData[{
Cell[34048, 1386, 84, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[34135, 1390, 186, 4, 70, "Message",
  CellTags->"S3.4.2"],
Cell[34324, 1396, 306, 9, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[34645, 1408, 102, 1, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.44"}],

Cell[CellGroupData[{
Cell[34772, 1413, 77, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[34852, 1417, 113, 2, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[34980, 1422, 1270, 38, 70, "DefinitionBox",
  CellTags->"S3.4.2"],
Cell[36253, 1462, 60, 1, 70, "Caption",
  CellTags->"S3.4.2"],
Cell[36316, 1465, 98, 1, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.45"}],

Cell[CellGroupData[{
Cell[36439, 1470, 85, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[36527, 1474, 88, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[36630, 1480, 152, 4, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.46"}],

Cell[CellGroupData[{
Cell[36807, 1488, 94, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[36904, 1492, 340, 10, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[37259, 1505, 370, 9, 70, "Text",
  CellTags->{"S3.4.2", "2.47"}],
Cell[37632, 1516, 110, 1, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.48"}],

Cell[CellGroupData[{
Cell[37767, 1521, 87, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[37857, 1525, 222, 5, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[38094, 1533, 111, 1, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.49"}],

Cell[CellGroupData[{
Cell[38230, 1538, 95, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[38328, 1542, 173, 4, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[38516, 1549, 414, 11, 70, "Text",
  CellTags->{"S3.4.2", "2.50"}],
Cell[38933, 1562, 164, 5, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.51"}],

Cell[CellGroupData[{
Cell[39122, 1571, 103, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[39228, 1575, 177, 4, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[39420, 1582, 161, 5, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.52"}],

Cell[CellGroupData[{
Cell[39606, 1591, 102, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[39711, 1595, 132, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]],
Cell[39858, 1601, 137, 4, 70, "MathCaption",
  CellTags->{"S3.4.2", "2.53"}],

Cell[CellGroupData[{
Cell[40020, 1609, 96, 2, 70, "Input",
  CellTags->"S3.4.2"],
Cell[40119, 1613, 87, 3, 70, "Output",
  CellTags->"S3.4.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40255, 1622, 92, 1, 70, "Subsection",
  CellTags->{"S3.4.3", "3.1"}],
Cell[40350, 1625, 972, 30, 70, "DefinitionBox",
  CellTags->"S3.4.3"],
Cell[41325, 1657, 82, 1, 70, "Caption",
  CellTags->"S3.4.3"],
Cell[41410, 1660, 208, 6, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.2"}],

Cell[CellGroupData[{
Cell[41643, 1670, 91, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[41737, 1674, 110, 3, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]],
Cell[41862, 1680, 186, 6, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.3"}],

Cell[CellGroupData[{
Cell[42073, 1690, 75, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[42151, 1694, 97, 3, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]],
Cell[42263, 1700, 359, 9, 70, "Text",
  CellTags->{"S3.4.3", "3.4"}],
Cell[42625, 1711, 102, 1, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.5"}],

Cell[CellGroupData[{
Cell[42752, 1716, 92, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[42847, 1720, 108, 3, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]],
Cell[42970, 1726, 169, 6, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.6"}],

Cell[CellGroupData[{
Cell[43164, 1736, 77, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[43244, 1740, 110, 3, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]],
Cell[43369, 1746, 133, 4, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.7"}],

Cell[CellGroupData[{
Cell[43527, 1754, 98, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[43628, 1758, 115, 3, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]],
Cell[43758, 1764, 182, 5, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.8"}],

Cell[CellGroupData[{
Cell[43965, 1773, 77, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[44045, 1777, 202, 5, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]],
Cell[44262, 1785, 924, 28, 70, "DefinitionBox",
  CellTags->"S3.4.3"],
Cell[45189, 1815, 74, 1, 70, "Caption",
  CellTags->"S3.4.3"],
Cell[45266, 1818, 183, 5, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.9"}],

Cell[CellGroupData[{
Cell[45474, 1827, 86, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[45563, 1831, 100, 3, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]],
Cell[45678, 1837, 203, 5, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.10"}],

Cell[CellGroupData[{
Cell[45906, 1846, 82, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[45991, 1850, 106, 3, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]],
Cell[46112, 1856, 191, 6, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.11"}],

Cell[CellGroupData[{
Cell[46328, 1866, 77, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[46408, 1870, 91, 3, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]],
Cell[46514, 1876, 1613, 49, 70, "Text",
  CellTags->{"S3.4.3", "3.12"}],
Cell[48130, 1927, 159, 5, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.13"}],

Cell[CellGroupData[{
Cell[48314, 1936, 94, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[48411, 1940, 158, 4, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]],
Cell[48584, 1947, 187, 5, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.14"}],

Cell[CellGroupData[{
Cell[48796, 1956, 78, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[48877, 1960, 158, 4, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]],
Cell[49050, 1967, 382, 7, 70, "Text",
  CellTags->{"S3.4.3", "3.15"}],
Cell[49435, 1976, 1514, 47, 70, "DefinitionBox",
  CellTags->"S3.4.3"],
Cell[50952, 2025, 56, 1, 70, "Caption",
  CellTags->"S3.4.3"],
Cell[51011, 2028, 366, 12, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.16"}],

Cell[CellGroupData[{
Cell[51402, 2044, 98, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[51503, 2048, 88, 3, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]],
Cell[51606, 2054, 115, 2, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.17"}],

Cell[CellGroupData[{
Cell[51746, 2060, 107, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[51856, 2064, 129, 3, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]],
Cell[52000, 2070, 196, 7, 70, "MathCaption",
  CellTags->{"S3.4.3", "3.18"}],

Cell[CellGroupData[{
Cell[52221, 2081, 74, 2, 70, "Input",
  CellTags->"S3.4.3"],
Cell[52298, 2085, 468, 8, 70, "Output",
  CellTags->"S3.4.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52815, 2099, 81, 1, 70, "Subsection",
  CellTags->{"S3.4.4", "4.1"}],
Cell[52899, 2102, 273, 8, 70, "Text",
  CellTags->{"S3.4.4", "4.2"}],
Cell[53175, 2112, 106, 1, 70, "MathCaption",
  CellTags->{"S3.4.4", "4.3"}],

Cell[CellGroupData[{
Cell[53306, 2117, 112, 2, 70, "Input",
  CellTags->"S3.4.4"],
Cell[53421, 2121, 190, 4, 70, "Output",
  CellTags->"S3.4.4"]
}, Open  ]],
Cell[53626, 2128, 220, 5, 70, "MathCaption",
  CellTags->{"S3.4.4", "4.4"}],

Cell[CellGroupData[{
Cell[53871, 2137, 107, 2, 70, "Input",
  CellTags->"S3.4.4"],
Cell[53981, 2141, 276, 6, 70, "Output",
  CellTags->"S3.4.4"]
}, Open  ]],
Cell[54272, 2150, 154, 5, 70, "MathCaption",
  CellTags->{"S3.4.4", "4.5"}],

Cell[CellGroupData[{
Cell[54451, 2159, 90, 2, 70, "Input",
  CellTags->"S3.4.4"],
Cell[54544, 2163, 123, 3, 70, "Output",
  CellTags->"S3.4.4"]
}, Open  ]],
Cell[54682, 2169, 323, 9, 70, "MathCaption",
  CellTags->{"S3.4.4", "4.6"}],

Cell[CellGroupData[{
Cell[55030, 2182, 124, 2, 70, "Input",
  CellTags->"S3.4.4"],
Cell[55157, 2186, 451, 11, 70, "Output",
  CellTags->"S3.4.4"]
}, Open  ]],
Cell[55623, 2200, 144, 5, 70, "MathCaption",
  CellTags->{"S3.4.4", "4.7"}],

Cell[CellGroupData[{
Cell[55792, 2209, 70, 2, 70, "Input",
  CellTags->"S3.4.4"],
Cell[55865, 2213, 160, 4, 70, "Output",
  CellTags->"S3.4.4"]
}, Open  ]],
Cell[56040, 2220, 382, 11, 70, "Text",
  CellTags->{"S3.4.4", "4.8"}],
Cell[56425, 2233, 190, 7, 70, "MathCaption",
  CellTags->{"S3.4.4", "4.9"}],

Cell[CellGroupData[{
Cell[56640, 2244, 106, 2, 70, "Input",
  CellTags->"S3.4.4"],
Cell[56749, 2248, 178, 4, 70, "Output",
  CellTags->"S3.4.4"]
}, Open  ]],
Cell[56942, 2255, 177, 7, 70, "MathCaption",
  CellTags->{"S3.4.4", "4.10"}],

Cell[CellGroupData[{
Cell[57144, 2266, 95, 2, 70, "Input",
  CellTags->"S3.4.4"],
Cell[57242, 2270, 233, 5, 70, "Output",
  CellTags->"S3.4.4"]
}, Open  ]],
Cell[57490, 2278, 1779, 53, 70, "DefinitionBox",
  CellTags->"S3.4.4"],
Cell[59272, 2333, 73, 1, 70, "Caption",
  CellTags->"S3.4.4"],
Cell[59348, 2336, 201, 5, 70, "MathCaption",
  CellTags->{"S3.4.4", "4.11"}],

Cell[CellGroupData[{
Cell[59574, 2345, 101, 2, 70, "Input",
  CellTags->"S3.4.4"],
Cell[59678, 2349, 124, 3, 70, "Output",
  CellTags->"S3.4.4"]
}, Open  ]],
Cell[59817, 2355, 3558, 99, 70, "FramedBox",
  CellTags->"S3.4.4"],
Cell[63378, 2456, 134, 5, 70, "Caption",
  CellTags->"S3.4.4"],
Cell[63515, 2463, 178, 4, 70, "MathCaption",
  CellTags->{"S3.4.4", "4.12"}],

Cell[CellGroupData[{
Cell[63718, 2471, 91, 2, 70, "Input",
  CellTags->"S3.4.4"],
Cell[63812, 2475, 120, 3, 70, "Output",
  CellTags->"S3.4.4"]
}, Open  ]],
Cell[63947, 2481, 157, 4, 70, "MathCaption",
  CellTags->{"S3.4.4", "4.13"}],

Cell[CellGroupData[{
Cell[64129, 2489, 81, 2, 70, "Input",
  CellTags->"S3.4.4"],
Cell[64213, 2493, 129, 3, 70, "Output",
  CellTags->"S3.4.4"]
}, Open  ]],
Cell[64357, 2499, 159, 5, 70, "MathCaption",
  CellTags->{"S3.4.4", "4.14"}],

Cell[CellGroupData[{
Cell[64541, 2508, 82, 2, 70, "Input",
  CellTags->"S3.4.4"],
Cell[64626, 2512, 127, 3, 70, "Output",
  CellTags->"S3.4.4"]
}, Open  ]],
Cell[64768, 2518, 284, 7, 70, "Text",
  CellTags->{"S3.4.4", "4.15"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[65089, 2530, 108, 3, 70, "Subsection",
  CellTags->{"S3.4.5", "5.1"}],
Cell[65200, 2535, 950, 41, 70, "Text",
  CellTags->{"S3.4.5", "5.2"}],
Cell[66153, 2578, 229, 8, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.3"}],

Cell[CellGroupData[{
Cell[66407, 2590, 85, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[66495, 2594, 96, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[66606, 2600, 230, 7, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.4"}],

Cell[CellGroupData[{
Cell[66861, 2611, 86, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[66950, 2615, 109, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[67074, 2621, 860, 26, 70, "Text",
  CellTags->{"S3.4.5", "5.5"}],
Cell[67937, 2649, 841, 24, 70, "DefinitionBox",
  CellTags->"S3.4.5"],
Cell[68781, 2675, 60, 1, 70, "Caption",
  CellTags->"S3.4.5"],
Cell[68844, 2678, 167, 5, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.6"}],

Cell[CellGroupData[{
Cell[69036, 2687, 86, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[69125, 2691, 108, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[69248, 2697, 314, 10, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.7"}],

Cell[CellGroupData[{
Cell[69587, 2711, 87, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[69677, 2715, 179, 4, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[69871, 2722, 588, 18, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.8"}],

Cell[CellGroupData[{
Cell[70484, 2744, 95, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[70582, 2748, 399, 8, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[70996, 2759, 297, 7, 70, "Text",
  CellTags->{"S3.4.5", "5.9"}],
Cell[71296, 2768, 128, 4, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.10"}],

Cell[CellGroupData[{
Cell[71449, 2776, 93, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[71545, 2780, 86, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[71646, 2786, 226, 7, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.11"}],

Cell[CellGroupData[{
Cell[71897, 2797, 93, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[71993, 2801, 109, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[72117, 2807, 154, 5, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.12"}],

Cell[CellGroupData[{
Cell[72296, 2816, 92, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[72391, 2820, 83, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[72489, 2826, 233, 9, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.13"}],

Cell[CellGroupData[{
Cell[72747, 2839, 100, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[72850, 2843, 96, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[72961, 2849, 159, 5, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.14"}],

Cell[CellGroupData[{
Cell[73145, 2858, 85, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[73233, 2862, 86, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[73334, 2868, 187, 5, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.15"}],

Cell[CellGroupData[{
Cell[73546, 2877, 84, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[73633, 2881, 86, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[73734, 2887, 282, 7, 70, "Text",
  CellTags->{"S3.4.5", "5.16"}],
Cell[74019, 2896, 553, 21, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.17"}],

Cell[CellGroupData[{
Cell[74597, 2921, 97, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[74697, 2925, 115, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[74827, 2931, 88, 1, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.18"}],

Cell[CellGroupData[{
Cell[74940, 2936, 73, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[75016, 2940, 83, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[75114, 2946, 105, 1, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.19"}],

Cell[CellGroupData[{
Cell[75244, 2951, 97, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[75344, 2955, 170, 4, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[75529, 2962, 144, 4, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.20"}],

Cell[CellGroupData[{
Cell[75698, 2970, 86, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[75787, 2974, 84, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[75886, 2980, 378, 16, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.21"}],

Cell[CellGroupData[{
Cell[76289, 3000, 87, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[76379, 3004, 176, 4, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[76570, 3011, 159, 4, 70, "Text",
  CellTags->{"S3.4.5", "5.22"}],
Cell[76732, 3017, 106, 1, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.23"}],

Cell[CellGroupData[{
Cell[76863, 3022, 95, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[76961, 3026, 122, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[77098, 3032, 151, 4, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.24"}],

Cell[CellGroupData[{
Cell[77274, 3040, 83, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[77360, 3044, 84, 3, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]],
Cell[77459, 3050, 155, 4, 70, "MathCaption",
  CellTags->{"S3.4.5", "5.25"}],

Cell[CellGroupData[{
Cell[77639, 3058, 84, 2, 70, "Input",
  CellTags->"S3.4.5"],
Cell[77726, 3062, 245, 5, 70, "Output",
  CellTags->"S3.4.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[78020, 3073, 80, 1, 70, "Subsection",
  CellTags->{"S3.4.6", "6.1"}],
Cell[78103, 3076, 405, 9, 70, "Text",
  CellTags->{"S3.4.6", "6.2"}],
Cell[78511, 3087, 1204, 37, 70, "DefinitionBox",
  CellTags->"S3.4.6"],
Cell[79718, 3126, 64, 1, 70, "Caption",
  CellTags->"S3.4.6"],
Cell[79785, 3129, 295, 11, 70, "MathCaption",
  CellTags->{"S3.4.6", "6.3"}],

Cell[CellGroupData[{
Cell[80105, 3144, 103, 2, 70, "Input",
  CellTags->"S3.4.6"],
Cell[80211, 3148, 133, 3, 70, "Output",
  CellTags->"S3.4.6"]
}, Open  ]],
Cell[80359, 3154, 250, 11, 70, "MathCaption",
  CellTags->{"S3.4.6", "6.4"}],

Cell[CellGroupData[{
Cell[80634, 3169, 82, 2, 70, "Input",
  CellTags->"S3.4.6"],
Cell[80719, 3173, 128, 3, 70, "Output",
  CellTags->"S3.4.6"]
}, Open  ]],
Cell[80862, 3179, 256, 11, 70, "MathCaption",
  CellTags->{"S3.4.6", "6.5"}],

Cell[CellGroupData[{
Cell[81143, 3194, 82, 2, 70, "Input",
  CellTags->"S3.4.6"],
Cell[81228, 3198, 161, 4, 70, "Output",
  CellTags->"S3.4.6"]
}, Open  ]],
Cell[81404, 3205, 435, 17, 70, "MathCaption",
  CellTags->{"S3.4.6", "6.6"}],

Cell[CellGroupData[{
Cell[81864, 3226, 80, 2, 70, "Input",
  CellTags->"S3.4.6"],
Cell[81947, 3230, 105, 3, 70, "Output",
  CellTags->"S3.4.6"]
}, Open  ]],
Cell[82067, 3236, 217, 9, 70, "MathCaption",
  CellTags->{"S3.4.6", "6.7"}],

Cell[CellGroupData[{
Cell[82309, 3249, 80, 2, 70, "Input",
  CellTags->"S3.4.6"],
Cell[82392, 3253, 115, 3, 70, "Output",
  CellTags->"S3.4.6"]
}, Open  ]],
Cell[82522, 3259, 229, 6, 70, "Text",
  CellTags->{"S3.4.6", "6.8"}],
Cell[82754, 3267, 206, 7, 70, "MathCaption",
  CellTags->{"S3.4.6", "6.9"}],

Cell[CellGroupData[{
Cell[82985, 3278, 81, 2, 70, "Input",
  CellTags->"S3.4.6"],
Cell[83069, 3282, 103, 3, 70, "Output",
  CellTags->"S3.4.6"]
}, Open  ]],
Cell[83187, 3288, 181, 7, 70, "MathCaption",
  CellTags->{"S3.4.6", "6.10"}],

Cell[CellGroupData[{
Cell[83393, 3299, 81, 2, 70, "Input",
  CellTags->"S3.4.6"],
Cell[83477, 3303, 97, 3, 70, "Output",
  CellTags->"S3.4.6"]
}, Open  ]],
Cell[83589, 3309, 826, 29, 70, "Text",
  CellTags->{"S3.4.6", "6.11"}],
Cell[84418, 3340, 342, 13, 70, "MathCaption",
  CellTags->{"S3.4.6", "6.12"}],

Cell[CellGroupData[{
Cell[84785, 3357, 123, 2, 70, "Input",
  CellTags->"S3.4.6"],
Cell[84911, 3361, 122, 3, 70, "Output",
  CellTags->"S3.4.6"]
}, Open  ]],
Cell[85048, 3367, 462, 9, 70, "Text",
  CellTags->{"S3.4.6", "6.13"}],
Cell[85513, 3378, 727, 21, 70, "DefinitionBox",
  CellTags->"S3.4.6"],
Cell[86243, 3401, 97, 1, 70, "Caption",
  CellTags->"S3.4.6"],
Cell[86343, 3404, 174, 5, 70, "MathCaption",
  CellTags->{"S3.4.6", "6.14"}],

Cell[CellGroupData[{
Cell[86542, 3413, 108, 2, 70, "Input",
  CellTags->"S3.4.6"],
Cell[86653, 3417, 122, 3, 70, "Output",
  CellTags->"S3.4.6"]
}, Open  ]],
Cell[86790, 3423, 80, 1, 70, "MathCaption",
  CellTags->{"S3.4.6", "6.15"}],

Cell[CellGroupData[{
Cell[86895, 3428, 154, 5, 70, "Input",
  CellTags->"S3.4.6"],
Cell[87052, 3435, 855, 25, 70, "Output",
  CellTags->"S3.4.6"]
}, Open  ]],
Cell[87922, 3463, 107, 1, 70, "MathCaption",
  CellTags->{"S3.4.6", "6.16"}],

Cell[CellGroupData[{
Cell[88054, 3468, 82, 2, 70, "Input",
  CellTags->"S3.4.6"],
Cell[88139, 3472, 127, 3, 70, "Output",
  CellTags->"S3.4.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[88315, 3481, 100, 1, 70, "Subsection",
  CellTags->{"S3.4.7", "7.1"}],
Cell[88418, 3484, 326, 8, 70, "Text",
  CellTags->{"S3.4.7", "7.2"}],
Cell[88747, 3494, 457, 24, 70, "MathCaption",
  CellTags->{"S3.4.7", "7.3"}],

Cell[CellGroupData[{
Cell[89229, 3522, 103, 2, 70, "Input",
  CellTags->"S3.4.7"],
Cell[89335, 3526, 124, 3, 70, "Output",
  CellTags->"S3.4.7"]
}, Open  ]],
Cell[89474, 3532, 171, 5, 70, "MathCaption",
  CellTags->{"S3.4.7", "7.4"}],

Cell[CellGroupData[{
Cell[89670, 3541, 104, 2, 70, "Input",
  CellTags->"S3.4.7"],
Cell[89777, 3545, 124, 3, 70, "Output",
  CellTags->"S3.4.7"]
}, Open  ]],
Cell[89916, 3551, 590, 31, 70, "MathCaption",
  CellTags->{"S3.4.7", "7.5"}],

Cell[CellGroupData[{
Cell[90531, 3586, 100, 2, 70, "Input",
  CellTags->"S3.4.7"],
Cell[90634, 3590, 119, 3, 70, "Output",
  CellTags->"S3.4.7"]
}, Open  ]],
Cell[90768, 3596, 138, 4, 70, "MathCaption",
  CellTags->{"S3.4.7", "7.6"}],

Cell[CellGroupData[{
Cell[90931, 3604, 82, 2, 70, "Input",
  CellTags->"S3.4.7"],
Cell[91016, 3608, 131, 3, 70, "Output",
  CellTags->"S3.4.7"]
}, Open  ]],
Cell[91162, 3614, 252, 9, 70, "MathCaption",
  CellTags->{"S3.4.7", "7.7"}],

Cell[CellGroupData[{
Cell[91439, 3627, 92, 2, 70, "Input",
  CellTags->"S3.4.7"],
Cell[91534, 3631, 116, 3, 70, "Output",
  CellTags->"S3.4.7"]
}, Open  ]],
Cell[91665, 3637, 962, 52, 70, "MathCaption",
  CellTags->{"S3.4.7", "7.8"}],

Cell[CellGroupData[{
Cell[92652, 3693, 105, 2, 70, "Input",
  CellTags->"S3.4.7"],
Cell[92760, 3697, 166, 4, 70, "Output",
  CellTags->"S3.4.7"]
}, Open  ]],
Cell[92941, 3704, 365, 11, 70, "Text",
  CellTags->{"S3.4.7", "7.9"}],
Cell[93309, 3717, 241, 10, 70, "MathCaption",
  CellTags->{"S3.4.7", "7.10"}],

Cell[CellGroupData[{
Cell[93575, 3731, 83, 2, 70, "Input",
  CellTags->"S3.4.7"],
Cell[93661, 3735, 109, 3, 70, "Output",
  CellTags->"S3.4.7"]
}, Open  ]],
Cell[93785, 3741, 386, 17, 70, "MathCaption",
  CellTags->{"S3.4.7", "7.11"}],

Cell[CellGroupData[{
Cell[94196, 3762, 89, 2, 70, "Input",
  CellTags->"S3.4.7"],
Cell[94288, 3766, 166, 4, 70, "Output",
  CellTags->"S3.4.7"]
}, Open  ]],
Cell[94469, 3773, 355, 10, 70, "Text",
  CellTags->{"S3.4.7", "7.12"}],
Cell[94827, 3785, 2650, 74, 70, "DefinitionBox",
  CellTags->"S3.4.7"],
Cell[97480, 3861, 70, 1, 70, "Caption",
  CellTags->"S3.4.7"],
Cell[97553, 3864, 290, 8, 70, "Text",
  CellTags->{"S3.4.7", "7.13"}],
Cell[97846, 3874, 180, 7, 70, "MathCaption",
  CellTags->{"S3.4.7", "7.14"}],

Cell[CellGroupData[{
Cell[98051, 3885, 125, 4, 70, "Input",
  CellTags->"S3.4.7"],
Cell[98179, 3891, 85, 3, 70, "Output",
  CellTags->"S3.4.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[98313, 3900, 71, 1, 70, "Subsection",
  CellTags->{"S3.4.8", "8.1"}],
Cell[98387, 3903, 907, 47, 70, "Text",
  CellTags->{"S3.4.8", "8.2"}],
Cell[99297, 3952, 1137, 34, 70, "DefinitionBox",
  CellTags->"S3.4.8"],
Cell[100437, 3988, 79, 1, 70, "Caption",
  CellTags->"S3.4.8"],
Cell[100519, 3991, 114, 2, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.3"}],

Cell[CellGroupData[{
Cell[100658, 3997, 97, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[100758, 4001, 90, 3, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[100863, 4007, 114, 2, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.4"}],

Cell[CellGroupData[{
Cell[101002, 4013, 89, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[101094, 4017, 86, 3, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[101195, 4023, 1282, 54, 70, "Text",
  CellTags->{"S3.4.8", "8.5"}],
Cell[102480, 4079, 163, 5, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.6"}],

Cell[CellGroupData[{
Cell[102668, 4088, 88, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[102759, 4092, 164, 4, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[102938, 4099, 168, 5, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.7"}],

Cell[CellGroupData[{
Cell[103131, 4108, 87, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[103221, 4112, 150, 4, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[103386, 4119, 970, 32, 70, "Text",
  CellTags->{"S3.4.8", "8.8"}],
Cell[104359, 4153, 103, 1, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.9"}],

Cell[CellGroupData[{
Cell[104487, 4158, 107, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[104597, 4162, 108, 3, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[104720, 4168, 105, 1, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.10"}],

Cell[CellGroupData[{
Cell[104850, 4173, 101, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[104954, 4177, 130, 3, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[105099, 4183, 156, 5, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.11"}],

Cell[CellGroupData[{
Cell[105280, 4192, 93, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[105376, 4196, 421, 8, 70, "Message",
  CellTags->"S3.4.8"],
Cell[105800, 4206, 199, 5, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[106014, 4214, 382, 11, 70, "Text",
  CellTags->{"S3.4.8", "8.12"}],
Cell[106399, 4227, 116, 2, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.13"}],

Cell[CellGroupData[{
Cell[106540, 4233, 99, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[106642, 4237, 176, 4, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[106833, 4244, 156, 5, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.14"}],

Cell[CellGroupData[{
Cell[107014, 4253, 94, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[107111, 4257, 244, 6, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[107370, 4266, 115, 2, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.15"}],

Cell[CellGroupData[{
Cell[107510, 4272, 114, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[107627, 4276, 330, 8, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[107972, 4287, 324, 9, 70, "Text",
  CellTags->{"S3.4.8", "8.16"}],
Cell[108299, 4298, 127, 4, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.17"}],

Cell[CellGroupData[{
Cell[108451, 4306, 97, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[108551, 4310, 153, 4, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[108719, 4317, 103, 1, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.18"}],

Cell[CellGroupData[{
Cell[108847, 4322, 116, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[108966, 4326, 339, 7, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[109320, 4336, 1472, 41, 70, "DefinitionBox",
  CellTags->"S3.4.8"],
Cell[110795, 4379, 68, 1, 70, "Caption",
  CellTags->"S3.4.8"],
Cell[110866, 4382, 282, 6, 70, "Text",
  CellTags->{"S3.4.8", "8.19"}],
Cell[111151, 4390, 193, 7, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.20"}],

Cell[CellGroupData[{
Cell[111369, 4401, 94, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[111466, 4405, 142, 4, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[111623, 4412, 411, 8, 70, "Text",
  CellTags->{"S3.4.8", "8.21"}],
Cell[112037, 4422, 102, 1, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.22"}],

Cell[CellGroupData[{
Cell[112164, 4427, 106, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[112273, 4431, 108, 3, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[112396, 4437, 132, 4, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.23"}],

Cell[CellGroupData[{
Cell[112553, 4445, 110, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[112666, 4449, 177, 4, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[112858, 4456, 208, 5, 70, "Text",
  CellTags->{"S3.4.8", "8.24"}],
Cell[113069, 4463, 130, 4, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.25"}],

Cell[CellGroupData[{
Cell[113224, 4471, 108, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[113335, 4475, 181, 4, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[113531, 4482, 99, 1, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.26"}],

Cell[CellGroupData[{
Cell[113655, 4487, 117, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[113775, 4491, 282, 6, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[114072, 4500, 115, 2, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.27"}],

Cell[CellGroupData[{
Cell[114212, 4506, 117, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[114332, 4510, 87, 3, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[114434, 4516, 115, 2, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.28"}],

Cell[CellGroupData[{
Cell[114574, 4522, 114, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[114691, 4526, 460, 9, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[115166, 4538, 240, 6, 70, "Text",
  CellTags->{"S3.4.8", "8.29"}],
Cell[115409, 4546, 152, 5, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.30"}],

Cell[CellGroupData[{
Cell[115586, 4555, 94, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[115683, 4559, 180, 4, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[115878, 4566, 177, 6, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.31"}],

Cell[CellGroupData[{
Cell[116080, 4576, 96, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[116179, 4580, 611, 12, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[116805, 4595, 376, 9, 70, "Text",
  CellTags->{"S3.4.8", "8.32"}],
Cell[117184, 4606, 1954, 59, 70, "DefinitionBox",
  CellTags->"S3.4.8"],
Cell[119141, 4667, 94, 1, 70, "Caption",
  CellTags->"S3.4.8"],
Cell[119238, 4670, 129, 4, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.33"}],

Cell[CellGroupData[{
Cell[119392, 4678, 120, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[119515, 4682, 151, 4, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[119681, 4689, 126, 4, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.34"}],

Cell[CellGroupData[{
Cell[119832, 4697, 120, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[119955, 4701, 84, 3, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[120054, 4707, 530, 11, 70, "Text",
  CellTags->{"S3.4.8", "8.35"}],
Cell[120587, 4720, 568, 12, 70, "Text",
  CellTags->{"S3.4.8", "8.36"}],
Cell[121158, 4734, 173, 5, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.37"}],

Cell[CellGroupData[{
Cell[121356, 4743, 101, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[121460, 4747, 110, 3, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]],
Cell[121585, 4753, 95, 1, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.38"}],
Cell[121683, 4756, 107, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[121793, 4760, 97, 1, 70, "MathCaption",
  CellTags->{"S3.4.8", "8.39"}],

Cell[CellGroupData[{
Cell[121915, 4765, 110, 2, 70, "Input",
  CellTags->"S3.4.8"],
Cell[122028, 4769, 12194, 697, 70, 12121, 694, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S3.4.8"],
Cell[134225, 5468, 178, 5, 70, "Output",
  CellTags->"S3.4.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[134452, 5479, 98, 1, 70, "Subsection",
  CellTags->{"S3.4.9", "9.1"}],
Cell[134553, 5482, 380, 9, 70, "Text",
  CellTags->{"S3.4.9", "9.2"}],
Cell[134936, 5493, 1700, 54, 70, "DefinitionBox",
  CellTags->"S3.4.9"],
Cell[136639, 5549, 63, 1, 70, "Caption",
  CellTags->"S3.4.9"],
Cell[136705, 5552, 207, 6, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.3"}],

Cell[CellGroupData[{
Cell[136937, 5562, 100, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[137040, 5566, 240, 5, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[137295, 5574, 169, 5, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.4"}],

Cell[CellGroupData[{
Cell[137489, 5583, 107, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[137599, 5587, 162, 4, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[137776, 5594, 178, 5, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.5"}],

Cell[CellGroupData[{
Cell[137979, 5603, 110, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[138092, 5607, 114, 3, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[138221, 5613, 517, 17, 70, "Text",
  CellTags->{"S3.4.9", "9.6"}],
Cell[138741, 5632, 468, 8, 70, "Text",
  CellTags->{"S3.4.9", "9.7"}],
Cell[139212, 5642, 130, 4, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.8"}],

Cell[CellGroupData[{
Cell[139367, 5650, 94, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[139464, 5654, 142, 4, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[139621, 5661, 138, 4, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.9"}],

Cell[CellGroupData[{
Cell[139784, 5669, 101, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[139888, 5673, 206, 5, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[140109, 5681, 150, 4, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.10"}],

Cell[CellGroupData[{
Cell[140284, 5689, 104, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[140391, 5693, 261, 5, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[140667, 5701, 405, 9, 70, "Text",
  CellTags->{"S3.4.9", "9.11"}],
Cell[141075, 5712, 139, 4, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.12"}],

Cell[CellGroupData[{
Cell[141239, 5720, 120, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[141362, 5724, 252, 6, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[141629, 5733, 2332, 75, 70, "DefinitionBox",
  CellTags->"S3.4.9"],
Cell[143964, 5810, 133, 4, 70, "Caption",
  CellTags->"S3.4.9"],
Cell[144100, 5816, 265, 6, 70, "Text",
  CellTags->{"S3.4.9", "9.13"}],
Cell[144368, 5824, 172, 5, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.14"}],

Cell[CellGroupData[{
Cell[144565, 5833, 105, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[144673, 5837, 346, 8, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[145034, 5848, 163, 5, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.15"}],

Cell[CellGroupData[{
Cell[145222, 5857, 101, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[145326, 5861, 637, 13, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[145978, 5877, 393, 8, 70, "Text",
  CellTags->{"S3.4.9", "9.16"}],
Cell[146374, 5887, 132, 4, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.17"}],

Cell[CellGroupData[{
Cell[146531, 5895, 106, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[146640, 5899, 658, 11, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[147313, 5913, 915, 30, 70, "Text",
  CellTags->{"S3.4.9", "9.18"}],
Cell[148231, 5945, 187, 6, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.19"}],

Cell[CellGroupData[{
Cell[148443, 5955, 140, 5, 70, "Input",
  CellTags->"S3.4.9"],
Cell[148586, 5962, 166, 4, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[148767, 5969, 284, 7, 70, "Text",
  CellTags->{"S3.4.9", "9.20"}],
Cell[149054, 5978, 141, 4, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.21"}],

Cell[CellGroupData[{
Cell[149220, 5986, 96, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[149319, 5990, 121, 3, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[149455, 5996, 116, 2, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.22"}],

Cell[CellGroupData[{
Cell[149596, 6002, 99, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[149698, 6006, 488, 9, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[150201, 6018, 142, 4, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.23"}],

Cell[CellGroupData[{
Cell[150368, 6026, 118, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[150489, 6030, 287, 6, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[150791, 6039, 740, 24, 70, "Text",
  CellTags->{"S3.4.9", "9.24"}],
Cell[151534, 6065, 141, 4, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.25"}],

Cell[CellGroupData[{
Cell[151700, 6073, 118, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[151821, 6077, 438, 9, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[152274, 6089, 285, 7, 70, "Text",
  CellTags->{"S3.4.9", "9.26"}],
Cell[152562, 6098, 96, 1, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.27"}],

Cell[CellGroupData[{
Cell[152683, 6103, 124, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[152810, 6107, 334, 7, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[153159, 6117, 167, 5, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.28"}],

Cell[CellGroupData[{
Cell[153351, 6126, 110, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[153464, 6130, 277, 6, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[153756, 6139, 158, 4, 70, "Text",
  CellTags->{"S3.4.9", "9.29"}],
Cell[153917, 6145, 150, 5, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.30"}],

Cell[CellGroupData[{
Cell[154092, 6154, 115, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[154210, 6158, 370, 8, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[154595, 6169, 176, 5, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.31"}],

Cell[CellGroupData[{
Cell[154796, 6178, 115, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[154914, 6182, 87, 3, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[155016, 6188, 237, 5, 70, "Text",
  CellTags->{"S3.4.9", "9.32"}],
Cell[155256, 6195, 403, 8, 70, "Text",
  CellTags->{"S3.4.9", "9.33"}],
Cell[155662, 6205, 772, 14, 70, "Text",
  CellTags->{"S3.4.9", "9.34"}],
Cell[156437, 6221, 216, 6, 70, "Text",
  CellTags->{"S3.4.9", "9.35"}],
Cell[156656, 6229, 161, 4, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.36"}],

Cell[CellGroupData[{
Cell[156842, 6237, 149, 5, 70, "Input",
  CellTags->"S3.4.9"],
Cell[156994, 6244, 617, 12, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[157626, 6259, 731, 23, 70, "DefinitionBox",
  CellTags->"S3.4.9"],
Cell[158360, 6284, 133, 5, 70, "Caption",
  CellTags->"S3.4.9"],
Cell[158496, 6291, 255, 8, 70, "Text",
  CellTags->{"S3.4.9", "9.37"}],
Cell[158754, 6301, 90, 1, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.38"}],

Cell[CellGroupData[{
Cell[158869, 6306, 115, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[158987, 6310, 350, 7, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[159352, 6320, 158, 4, 70, "Text",
  CellTags->{"S3.4.9", "9.39"}],
Cell[159513, 6326, 107, 1, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.40"}],

Cell[CellGroupData[{
Cell[159645, 6331, 117, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[159765, 6335, 202, 4, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[159982, 6342, 1763, 49, 70, "DefinitionBox",
  CellTags->"S3.4.9"],
Cell[161748, 6393, 90, 1, 70, "Caption",
  CellTags->"S3.4.9"],
Cell[161841, 6396, 179, 7, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.41"}],

Cell[CellGroupData[{
Cell[162045, 6407, 151, 5, 70, "Input",
  CellTags->"S3.4.9"],
Cell[162199, 6414, 288, 7, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[162502, 6424, 445, 14, 70, "Text",
  CellTags->{"S3.4.9", "9.42"}],
Cell[162950, 6440, 110, 1, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.43"}],

Cell[CellGroupData[{
Cell[163085, 6445, 87, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[163175, 6449, 227, 5, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[163417, 6457, 129, 4, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.44"}],

Cell[CellGroupData[{
Cell[163571, 6465, 92, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[163666, 6469, 159, 4, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[163840, 6476, 389, 8, 70, "Text",
  CellTags->{"S3.4.9", "9.45"}],
Cell[164232, 6486, 165, 6, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.46"}],

Cell[CellGroupData[{
Cell[164422, 6496, 83, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[164508, 6500, 96, 3, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[164619, 6506, 191, 7, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.47"}],

Cell[CellGroupData[{
Cell[164835, 6517, 94, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[164932, 6521, 198, 5, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[165145, 6529, 217, 7, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.48"}],

Cell[CellGroupData[{
Cell[165387, 6540, 86, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[165476, 6544, 165, 4, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[165656, 6551, 167, 7, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.49"}],

Cell[CellGroupData[{
Cell[165848, 6562, 126, 4, 70, "Input",
  CellTags->"S3.4.9"],
Cell[165977, 6568, 348, 7, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[166340, 6578, 3637, 111, 70, "DefinitionBox",
  CellTags->"S3.4.9"],
Cell[169980, 6691, 82, 1, 70, "Caption",
  CellTags->"S3.4.9"],
Cell[170065, 6694, 335, 8, 70, "Text",
  CellTags->{"S3.4.9", "9.50"}],
Cell[170403, 6704, 825, 29, 70, "Text",
  CellTags->{"S3.4.9", "9.51"}],
Cell[171231, 6735, 351, 8, 70, "Text",
  CellTags->{"S3.4.9", "9.52"}],
Cell[171585, 6745, 117, 2, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.53"}],

Cell[CellGroupData[{
Cell[171727, 6751, 138, 5, 70, "Input",
  CellTags->"S3.4.9"],
Cell[171868, 6758, 112, 3, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[171995, 6764, 540, 17, 70, "Text",
  CellTags->{"S3.4.9", "9.54"}],
Cell[172538, 6783, 190, 7, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.55"}],

Cell[CellGroupData[{
Cell[172753, 6794, 114, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[172870, 6798, 84, 3, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]],
Cell[172969, 6804, 69, 1, 70, "MathCaption",
  CellTags->{"S3.4.9", "9.56"}],

Cell[CellGroupData[{
Cell[173063, 6809, 116, 2, 70, "Input",
  CellTags->"S3.4.9"],
Cell[173182, 6813, 116, 3, 70, "Output",
  CellTags->"S3.4.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[173347, 6822, 115, 2, 70, "Subsection",
  CellTags->{"S3.4.10", "10.1"}],
Cell[173465, 6826, 316, 7, 70, "Text",
  CellTags->{"S3.4.10", "10.2"}],
Cell[173784, 6835, 429, 9, 70, "Text",
  CellTags->{"S3.4.10", "10.3"}],
Cell[174216, 6846, 134, 4, 70, "MathCaption",
  CellTags->{"S3.4.10", "10.4"}],

Cell[CellGroupData[{
Cell[174375, 6854, 94, 2, 70, "Input",
  CellTags->"S3.4.10"],
Cell[174472, 6858, 106, 3, 70, "Output",
  CellTags->"S3.4.10"]
}, Open  ]],
Cell[174593, 6864, 203, 6, 70, "MathCaption",
  CellTags->{"S3.4.10", "10.5"}],

Cell[CellGroupData[{
Cell[174821, 6874, 95, 2, 70, "Input",
  CellTags->"S3.4.10"],
Cell[174919, 6878, 86, 3, 70, "Output",
  CellTags->"S3.4.10"]
}, Open  ]],
Cell[175020, 6884, 153, 4, 70, "MathCaption",
  CellTags->{"S3.4.10", "10.6"}],

Cell[CellGroupData[{
Cell[175198, 6892, 85, 2, 70, "Input",
  CellTags->"S3.4.10"],
Cell[175286, 6896, 135, 3, 70, "Output",
  CellTags->"S3.4.10"]
}, Open  ]],
Cell[175436, 6902, 247, 8, 70, "MathCaption",
  CellTags->{"S3.4.10", "10.7"}],

Cell[CellGroupData[{
Cell[175708, 6914, 78, 2, 70, "Input",
  CellTags->"S3.4.10"],
Cell[175789, 6918, 110, 3, 70, "Output",
  CellTags->"S3.4.10"]
}, Open  ]],
Cell[175914, 6924, 2019, 73, 70, "Text",
  CellTags->{"S3.4.10", "10.8"}],
Cell[177936, 6999, 221, 8, 70, "MathCaption",
  CellTags->{"S3.4.10", "10.9"}],

Cell[CellGroupData[{
Cell[178182, 7011, 85, 2, 70, "Input",
  CellTags->"S3.4.10"],
Cell[178270, 7015, 122, 3, 70, "Output",
  CellTags->"S3.4.10"]
}, Open  ]],
Cell[178407, 7021, 1105, 42, 70, "Text",
  CellTags->{"S3.4.10", "10.10"}],
Cell[179515, 7065, 892, 30, 70, "Text",
  CellTags->{"S3.4.10", "10.11"}],
Cell[180410, 7097, 916, 34, 70, "Text",
  CellTags->{"S3.4.10", "10.12"}],
Cell[181329, 7133, 1296, 42, 70, "Text",
  CellTags->{"S3.4.10", "10.13"}],
Cell[182628, 7177, 220, 9, 70, "MathCaption",
  CellTags->{"S3.4.10", "10.14"}],

Cell[CellGroupData[{
Cell[182873, 7190, 110, 2, 70, "Input",
  CellTags->"S3.4.10"],
Cell[182986, 7194, 225, 5, 70, "Output",
  CellTags->"S3.4.10"]
}, Open  ]],
Cell[183226, 7202, 203, 7, 70, "MathCaption",
  CellTags->{"S3.4.10", "10.15"}],

Cell[CellGroupData[{
Cell[183454, 7213, 146, 5, 70, "Input",
  CellTags->"S3.4.10"],
Cell[183603, 7220, 468, 11, 70, "Output",
  CellTags->"S3.4.10"]
}, Open  ]],
Cell[184086, 7234, 1203, 35, 70, "DefinitionBox",
  CellTags->"S3.4.10"],
Cell[185292, 7271, 79, 1, 70, "Caption",
  CellTags->"S3.4.10"],
Cell[185374, 7274, 497, 15, 70, "Text",
  CellTags->{"S3.4.10", "10.16"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[185908, 7294, 89, 1, 70, "Subsection",
  CellTags->{"S3.4.11", "11.1"}],
Cell[186000, 7297, 587, 23, 70, "Text",
  CellTags->{"S3.4.11", "11.2"}],
Cell[186590, 7322, 5988, 180, 70, "DefinitionBox",
  CellTags->"S3.4.11"],
Cell[192581, 7504, 72, 1, 70, "Caption",
  CellTags->"S3.4.11"],
Cell[192656, 7507, 427, 11, 70, "Text",
  CellTags->{"S3.4.11", "11.3"}],
Cell[193086, 7520, 222, 6, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.4"}],

Cell[CellGroupData[{
Cell[193333, 7530, 89, 2, 70, "Input",
  CellTags->"S3.4.11"],
Cell[193425, 7534, 111, 3, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]],
Cell[193551, 7540, 147, 4, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.5"}],

Cell[CellGroupData[{
Cell[193723, 7548, 80, 2, 70, "Input",
  CellTags->"S3.4.11"],
Cell[193806, 7552, 86, 3, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]],
Cell[193907, 7558, 189, 7, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.6"}],

Cell[CellGroupData[{
Cell[194121, 7569, 103, 2, 70, "Input",
  CellTags->"S3.4.11"],
Cell[194227, 7573, 87, 3, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]],
Cell[194329, 7579, 856, 22, 70, "Text",
  CellTags->{"S3.4.11", "11.7"}],
Cell[195188, 7603, 5531, 164, 70, "DefinitionBox",
  CellTags->"S3.4.11"],
Cell[200722, 7769, 68, 1, 70, "Caption",
  CellTags->"S3.4.11"],
Cell[200793, 7772, 525, 11, 70, "Text",
  CellTags->{"S3.4.11", "11.8"}],
Cell[201321, 7785, 996, 31, 70, "DefinitionBox",
  CellTags->"S3.4.11"],
Cell[202320, 7818, 66, 1, 70, "Caption",
  CellTags->"S3.4.11"],
Cell[202389, 7821, 158, 5, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.9"}],

Cell[CellGroupData[{
Cell[202572, 7830, 95, 2, 70, "Input",
  CellTags->"S3.4.11"],
Cell[202670, 7834, 86, 3, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]],
Cell[202771, 7840, 185, 5, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.10"}],

Cell[CellGroupData[{
Cell[202981, 7849, 109, 2, 70, "Input",
  CellTags->"S3.4.11"],
Cell[203093, 7853, 120, 3, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]],
Cell[203228, 7859, 361, 7, 70, "Text",
  CellTags->{"S3.4.11", "11.11"}],
Cell[203592, 7868, 145, 4, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.12"}],

Cell[CellGroupData[{
Cell[203762, 7876, 111, 2, 70, "Input",
  CellTags->"S3.4.11"],
Cell[203876, 7880, 282, 5, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]],
Cell[204173, 7888, 229, 7, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.13"}],

Cell[CellGroupData[{
Cell[204427, 7899, 113, 2, 70, "Input",
  CellTags->"S3.4.11"],
Cell[204543, 7903, 86, 3, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]],
Cell[204644, 7909, 572, 13, 70, "Text",
  CellTags->{"S3.4.11", "11.14"}],
Cell[205219, 7924, 112, 1, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.15"}],

Cell[CellGroupData[{
Cell[205356, 7929, 104, 2, 70, "Input",
  CellTags->"S3.4.11"],
Cell[205463, 7933, 315, 7, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]],
Cell[205793, 7943, 130, 4, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.16"}],

Cell[CellGroupData[{
Cell[205948, 7951, 112, 2, 70, "Input",
  CellTags->"S3.4.11"],
Cell[206063, 7955, 101, 3, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]],
Cell[206179, 7961, 149, 4, 70, "Text",
  CellTags->{"S3.4.11", "11.17"}],
Cell[206331, 7967, 157, 4, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.18"}],

Cell[CellGroupData[{
Cell[206513, 7975, 150, 5, 70, "Input",
  CellTags->"S3.4.11"],
Cell[206666, 7982, 378, 8, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]],
Cell[207059, 7993, 119, 2, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.19"}],

Cell[CellGroupData[{
Cell[207203, 7999, 144, 5, 70, "Input",
  CellTags->"S3.4.11"],
Cell[207350, 8006, 223, 5, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]],
Cell[207588, 8014, 147, 5, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.20"}],
Cell[207738, 8021, 104, 2, 70, "Input",
  CellTags->"S3.4.11"],
Cell[207845, 8025, 143, 4, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.21"}],

Cell[CellGroupData[{
Cell[208013, 8033, 144, 5, 70, "Input",
  CellTags->"S3.4.11"],
Cell[208160, 8040, 253, 5, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]],
Cell[208428, 8048, 239, 6, 70, "Text",
  CellTags->{"S3.4.11", "11.22"}],
Cell[208670, 8056, 192, 6, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.23"}],

Cell[CellGroupData[{
Cell[208887, 8066, 122, 2, 70, "Input",
  CellTags->"S3.4.11"],
Cell[209012, 8070, 88, 3, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]],
Cell[209115, 8076, 159, 5, 70, "MathCaption",
  CellTags->{"S3.4.11", "11.24"}],

Cell[CellGroupData[{
Cell[209299, 8085, 124, 2, 70, "Input",
  CellTags->"S3.4.11"],
Cell[209426, 8089, 87, 3, 70, "Output",
  CellTags->"S3.4.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[209562, 8098, 91, 1, 70, "Subsection",
  CellTags->{"S3.4.12", "12.1"}],
Cell[209656, 8101, 4317, 132, 70, "DefinitionBox",
  CellTags->"S3.4.12"],
Cell[213976, 8235, 73, 1, 70, "Caption",
  CellTags->"S3.4.12"],
Cell[214052, 8238, 272, 7, 70, "Text",
  CellTags->{"S3.4.12", "12.2"}],
Cell[214327, 8247, 104, 1, 70, "MathCaption",
  CellTags->{"S3.4.12", "12.3"}],

Cell[CellGroupData[{
Cell[214456, 8252, 90, 2, 70, "Input",
  CellTags->"S3.4.12"],
Cell[214549, 8256, 107, 3, 70, "Output",
  CellTags->"S3.4.12"]
}, Open  ]],
Cell[214671, 8262, 156, 5, 70, "MathCaption",
  CellTags->{"S3.4.12", "12.4"}],

Cell[CellGroupData[{
Cell[214852, 8271, 88, 2, 70, "Input",
  CellTags->"S3.4.12"],
Cell[214943, 8275, 87, 3, 70, "Output",
  CellTags->"S3.4.12"]
}, Open  ]],
Cell[215045, 8281, 186, 7, 70, "MathCaption",
  CellTags->{"S3.4.12", "12.5"}],

Cell[CellGroupData[{
Cell[215256, 8292, 100, 2, 70, "Input",
  CellTags->"S3.4.12"],
Cell[215359, 8296, 154, 4, 70, "Output",
  CellTags->"S3.4.12"]
}, Open  ]],
Cell[215528, 8303, 896, 34, 70, "Text",
  CellTags->{"S3.4.12", "12.6"}],
Cell[216427, 8339, 288, 10, 70, "MathCaption",
  CellTags->{"S3.4.12", "12.7"}],

Cell[CellGroupData[{
Cell[216740, 8353, 100, 2, 70, "Input",
  CellTags->"S3.4.12"],
Cell[216843, 8357, 100, 3, 70, "Output",
  CellTags->"S3.4.12"]
}, Open  ]],
Cell[216958, 8363, 103, 1, 70, "MathCaption",
  CellTags->{"S3.4.12", "12.8"}],

Cell[CellGroupData[{
Cell[217086, 8368, 118, 2, 70, "Input",
  CellTags->"S3.4.12"],
Cell[217207, 8372, 143, 4, 70, "Output",
  CellTags->"S3.4.12"]
}, Open  ]],
Cell[217365, 8379, 142, 4, 70, "MathCaption",
  CellTags->{"S3.4.12", "12.9"}],

Cell[CellGroupData[{
Cell[217532, 8387, 119, 2, 70, "Input",
  CellTags->"S3.4.12"],
Cell[217654, 8391, 385, 8, 70, "Output",
  CellTags->"S3.4.12"]
}, Open  ]],
Cell[218054, 8402, 94, 1, 70, "MathCaption",
  CellTags->{"S3.4.12", "12.10"}],

Cell[CellGroupData[{
Cell[218173, 8407, 114, 2, 70, "Input",
  CellTags->"S3.4.12"],
Cell[218290, 8411, 122, 3, 70, "Output",
  CellTags->"S3.4.12"]
}, Open  ]],
Cell[218427, 8417, 553, 20, 70, "Text",
  CellTags->{"S3.4.12", "12.11"}],
Cell[218983, 8439, 103, 1, 70, "MathCaption",
  CellTags->{"S3.4.12", "12.12"}],

Cell[CellGroupData[{
Cell[219111, 8444, 122, 2, 70, "Input",
  CellTags->"S3.4.12"],
Cell[219236, 8448, 124, 3, 70, "Output",
  CellTags->"S3.4.12"]
}, Open  ]],
Cell[219375, 8454, 367, 7, 70, "Text",
  CellTags->{"S3.4.12", "12.13"}],
Cell[219745, 8463, 170, 4, 70, "MathCaption",
  CellTags->{"S3.4.12", "12.14"}],

Cell[CellGroupData[{
Cell[219940, 8471, 100, 2, 70, "Input",
  CellTags->"S3.4.12"],
Cell[220043, 8475, 122, 3, 70, "Output",
  CellTags->"S3.4.12"]
}, Open  ]],
Cell[220180, 8481, 143, 4, 70, "MathCaption",
  CellTags->{"S3.4.12", "12.15"}],

Cell[CellGroupData[{
Cell[220348, 8489, 118, 2, 70, "Input",
  CellTags->"S3.4.12"],
Cell[220469, 8493, 181, 4, 70, "Output",
  CellTags->"S3.4.12"]
}, Open  ]],
Cell[220665, 8500, 498, 15, 70, "Text",
  CellTags->{"S3.4.12", "12.16"}],
Cell[221166, 8517, 111, 1, 70, "MathCaption",
  CellTags->{"S3.4.12", "12.17"}],

Cell[CellGroupData[{
Cell[221302, 8522, 98, 2, 70, "Input",
  CellTags->"S3.4.12"],
Cell[221403, 8526, 5438, 373, 186, 5364, 370, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S3.4.12"],
Cell[226844, 8901, 179, 5, 70, "Output",
  CellTags->"S3.4.12"]
}, Open  ]],
Cell[227038, 8909, 130, 4, 40, "MathCaption",
  CellTags->{"S3.4.12", "12.18"}],

Cell[CellGroupData[{
Cell[227193, 8917, 109, 2, 28, "Input",
  CellTags->"S3.4.12"],
Cell[227305, 8921, 135, 3, 42, "Output",
  CellTags->"S3.4.12"]
}, Open  ]],
Cell[227455, 8927, 829, 26, 72, "Text",
  CellTags->{"S3.4.12", "12.19"}],
Cell[228287, 8955, 818, 31, 88, "Text",
  CellTags->{"S3.4.12", "12.20"}],
Cell[229108, 8988, 197, 5, 56, "MathCaption",
  CellTags->{"S3.4.12", "12.21"}],

Cell[CellGroupData[{
Cell[229330, 8997, 100, 2, 28, "Input",
  CellTags->"S3.4.12"],
Cell[229433, 9001, 210, 4, 44, "Message",
  CellTags->"S3.4.12"],
Cell[229646, 9007, 101, 3, 25, "Output",
  CellTags->"S3.4.12"]
}, Open  ]],
Cell[229762, 9013, 439, 14, 56, "Text",
  CellTags->{"S3.4.12", "12.22"}],
Cell[230204, 9029, 189, 7, 40, "MathCaption",
  CellTags->{"S3.4.12", "12.23"}],

Cell[CellGroupData[{
Cell[230418, 9040, 147, 5, 45, "Input",
  CellTags->"S3.4.12"],
Cell[230568, 9047, 125, 3, 25, "Output",
  CellTags->"S3.4.12"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

