(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    292627,      12273]*)
(*NotebookOutlinePosition[    389009,      15014]*)
(*  CellTagsIndexPosition[    380646,      14702]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["3.5 ", "HeadingNumber"],
  "Calculus"
}], "Section",
  CellTags->{"S3.5.0", "0.1"}],

Cell[CellGroupData[{

Cell["3.5.1 Differentiation", "Subsection",
  CellTags->{"S3.5.1", "1.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "partial derivative ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox["\[PartialD]", 
                        RowBox[{"\[PartialD]", 
                          StyleBox["x",
                            "TI"]}]], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "multiple derivative ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox["\[PartialD]", 
                        RowBox[{"\[PartialD]", 
                          StyleBox["x",
                            "TI"]}]], 
                      FractionBox["\[PartialD]", 
                        RowBox[{"\[PartialD]", 
                          StyleBox["y",
                            "TI"]}]], " ", \(\(...\)\(\ \)\), 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " derivative ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox[
                        SuperscriptBox["\[PartialD]", 
                          StyleBox["n",
                            "TI"]], 
                        RowBox[{"\[PartialD]", 
                          SuperscriptBox[
                            StyleBox["x",
                              "TI"], 
                            StyleBox["n",
                              "TI"]]}]], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["NonConstants", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox["\[PartialD]", 
                        RowBox[{"\[PartialD]", 
                          StyleBox["x",
                            "TI"]}]], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " with the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " taken to depend on ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.1"],

Cell["Partial differentiation operations. ", "Caption",
  CellTags->"S3.5.1"],

Cell[TextData[{
  "This gives ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox["\[PartialD]", 
            RowBox[{"\[PartialD]", 
              StyleBox["x",
                "TI"]}]], 
          SuperscriptBox[
            StyleBox["x",
              "TI"], 
            StyleBox["n",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.1", "1.2"}],

Cell[CellGroupData[{

Cell["D[x^n, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.1"],

Cell[BoxData[
    \(n\ x\^\(\(-1\) + n\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.5.1"]
}, Open  ]],

Cell["This gives the third derivative. ", "MathCaption",
  CellTags->{"S3.5.1", "1.3"}],

Cell[CellGroupData[{

Cell["D[x^n, {x, 3}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.1"],

Cell[BoxData[
    \(\((\(-2\) + n)\)\ \((\(-1\) + n)\)\ n\ x\^\(\(-3\) + n\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.5.1"]
}, Open  ]],

Cell["\<\
You can differentiate with respect to any expression that does not \
involve explicit mathematical operations.  \
\>", "MathCaption",
  CellTags->{"S3.5.1", "1.4"}],

Cell[CellGroupData[{

Cell["D[ x[1]^2 + x[2]^2, x[1] ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.1"],

Cell[BoxData[
    \(2\ x[1]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["D", "MR"],
  " does ",
  StyleBox["partial differentiation", "TI"],
  ". It assumes here that ",
  StyleBox["y", "MR"],
  " is independent of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.1", "1.5"}],

Cell[CellGroupData[{

Cell["D[x^2 + y^2, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.1"],

Cell[BoxData[
    \(2\ x\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.1"]
}, Open  ]],

Cell[TextData[{
  "If ",
  StyleBox["y", "MR"],
  " does in fact depend on ",
  StyleBox["x", "MR"],
  ", you can use the explicit functional form ",
  StyleBox["y[x]", "MR"],
  ". Section ",
  ButtonBox["3.5.4",
    ButtonData:>{"3.5.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  " describes how objects like ",
  StyleBox["y'[x]", "MR"],
  " work. "
}], "MathCaption",
  CellTags->{"S3.5.1", "1.6"}],

Cell[CellGroupData[{

Cell["D[x^2 + y[x]^2, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.1"],

Cell[BoxData[
    RowBox[{\(2\ x\), "+", 
      RowBox[{"2", " ", \(y[x]\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.5.1"]
}, Open  ]],

Cell[TextData[{
  "Instead of giving an explicit function ",
  StyleBox["y[x]", "MR"],
  ", you can tell ",
  StyleBox["D", "MR"],
  " that ",
  StyleBox["y", "MR"],
  " ",
  StyleBox["implicitly", "TI"],
  " depends on ",
  StyleBox["x", "MR"],
  ". ",
  StyleBox["D[y,", "MR"],
  " ",
  StyleBox["x,", "MR"],
  " ",
  StyleBox["NonConstants->{y}]", "MR"],
  " then represents ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          RowBox[{"\[PartialD]", 
            StyleBox["y",
              "TI"]}], 
          RowBox[{"\[PartialD]", 
            StyleBox["x",
              "TI"]}]], TraditionalForm]], "InlineFormula"],
  ", with ",
  StyleBox["y", "MR"],
  " implicitly depending on ",
  StyleBox["x", "MR"],
  ".  "
}], "MathCaption",
  CellTags->{"S3.5.1", "1.7"}],

Cell[CellGroupData[{

Cell["D[x^2 + y^2, x, NonConstants -> {y}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.1"],

Cell[BoxData[
    \(2\ x + 2\ y\ D[y, x, NonConstants \[Rule] {y}]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.5.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the gradient of a scalar function ",
              StyleBox["f", "TI"],
              " ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"(", 
                      RowBox[{"\[PartialD]", 
                        StyleBox["f",
                          "TI"], "/", "\[PartialD]", 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], "1"], ",", "\[PartialD]", 
                        StyleBox["f",
                          "TI"], "/", "\[PartialD]", 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], "2"], ",", \(\(\[Ellipsis]\)\(\ \)\)}], 
                      ")"}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["2}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the Hessian matrix for ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " order Taylor series coefficient "
            }]]},
          {Cell[TextData[{
              StyleBox["D[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }}]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "the Jacobian for a vector function ",
              StyleBox["f", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.1"],

Cell["Vector derivatives. ", "Caption",
  CellTags->"S3.5.1"],

Cell[TextData[{
  "This gives the gradient of the function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"], "+", 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "2"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.1", "1.8"}],

Cell[CellGroupData[{

Cell["D[x^2 + y^2, {{x, y}}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.5.1"],

Cell[BoxData[
    \({2\ x, 2\ y}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.5.1"]
}, Open  ]],

Cell["This gives the Hessian. ", "MathCaption",
  CellTags->{"S3.5.1", "1.9"}],

Cell[CellGroupData[{

Cell["D[x^2 + y^2, {{x, y}, 2}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.5.1"],

Cell[BoxData[
    \({{2, 0}, {0, 2}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.5.1"]
}, Open  ]],

Cell["This gives the Jacobian for a vector function. ", "MathCaption",
  CellTags->{"S3.5.1", "1.10"}],

Cell[CellGroupData[{

Cell["D[{x^2 + y^2, x y}, {{x, y}}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.5.1"],

Cell[BoxData[
    \({{2\ x, 2\ y}, {y, x}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.5.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5.2 Total Derivatives", "Subsection",
  CellTags->{"S3.5.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Dt[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "total differential ",
              Cell[BoxData[
                  FormBox[
                    StyleBox[\(d  f\),
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Dt[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "total derivative ",
              Cell[BoxData[
                  FormBox[
                    FractionBox[
                      StyleBox[\(d  f\),
                        "TI"], 
                      StyleBox[\(d  x\),
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Dt[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "multiple total derivative ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox[
                        StyleBox["d",
                          "TI"], 
                        StyleBox[\(d  x\),
                          "TI"]], 
                      FractionBox[
                        StyleBox["d",
                          "TI"], 
                        StyleBox[\(d  y\),
                          "TI"]], " ", \(\(...\)\(\ \)\), 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Dt[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Constants", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "total derivative with ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " constant (i.e., ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["d",
                        "TI"], 
                      SubscriptBox[
                        StyleBox["c",
                          "TI"], 
                        StyleBox["i",
                          "TI"]], "=", "0"}], TraditionalForm]], 
                "InlineFormula"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["y", "TI"],
              StyleBox["/:", "MR"],
              " ",
              StyleBox["Dt[", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["0", "MR"],
              " "
            }]], Cell[TextData[{
              "set ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox[
                        StyleBox[\(d  y\),
                          "TI"], 
                        StyleBox[\(d  x\),
                          "TI"]], "=", "0"}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SetAttributes[", "MR"],
              StyleBox["c", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Constant]", "MR"],
              " "
            }]], Cell[TextData[{
              "define ",
              StyleBox["c", "TI"],
              " to be a constant in all cases"
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.2"],

Cell["Total differentiation operations. ", "Caption",
  CellTags->"S3.5.2"],

Cell[TextData[{
  "When you find the derivative of some expression ",
  Cell[BoxData[
      FormBox[
        StyleBox["f",
          "TI"], TraditionalForm]], "InlineFormula"],
  " with respect to ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", you are effectively finding out how fast ",
  Cell[BoxData[
      FormBox[
        StyleBox["f",
          "TI"], TraditionalForm]], "InlineFormula"],
  " changes as you vary ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". Often ",
  Cell[BoxData[
      FormBox[
        StyleBox["f",
          "TI"], TraditionalForm]], "InlineFormula"],
  " will depend not only on ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", but also on other variables, say ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". The results that you get then depend on how you assume that ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  " vary as you change ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.5.2", "2.2"}],

Cell[TextData[{
  "There are two common cases. Either ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  " are assumed to stay fixed when ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " changes, or they are allowed to vary with ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". In a standard ",
  StyleBox["partial derivative", "TI"],
  " ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          RowBox[{"\[PartialD]", 
            StyleBox["f",
              "TI"]}], 
          RowBox[{"\[PartialD]", 
            StyleBox["x",
              "TI"]}]], TraditionalForm]], "InlineFormula"],
  ", all variables other than ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " are assumed fixed. On the other hand, in the ",
  StyleBox["total derivative", "TI"],
  " ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          StyleBox[\(d  f\),
            "TI"], 
          StyleBox[\(d  x\),
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", all variables are allowed to change with ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.5.2", "2.3"}],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica", "TI"],
  ", ",
  StyleBox["D[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " gives a partial derivative, with all other variables assumed independent \
of ",
  StyleBox["x", "TI"],
  ". ",
  StyleBox["Dt[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " gives a total derivative, in which all variables are assumed to depend on \
",
  StyleBox["x", "TI"],
  ". In both cases, you can add an argument to give more information on \
dependencies.  "
}], "Text",
  CellTags->{"S3.5.2", "2.4"}],

Cell[TextData[{
  "This gives the ",
  StyleBox["partial derivative", "TI"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox["\[PartialD]", 
            RowBox[{"\[PartialD]", 
              StyleBox["x",
                "TI"]}]], 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "2"], "+", 
              SuperscriptBox[
                StyleBox["y",
                  "TI"], "2"]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". ",
  StyleBox["y", "MR"],
  " is assumed to be independent of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.2", "2.5"}],

Cell[CellGroupData[{

Cell["D[x^2 + y^2, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.2"],

Cell[BoxData[
    \(2\ x\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.5.2"]
}, Open  ]],

Cell[TextData[{
  "This gives the ",
  StyleBox["total derivative", "TI"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox[
            StyleBox["d",
              "TI"], 
            StyleBox[\(d  x\),
              "TI"]], 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "2"], "+", 
              SuperscriptBox[
                StyleBox["y",
                  "TI"], "2"]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". Now ",
  StyleBox["y", "MR"],
  " is assumed to depend on ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.2", "2.6"}],

Cell[CellGroupData[{

Cell["Dt[x^2 + y^2, x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.2"],

Cell[BoxData[
    \(2\ x + 2\ y\ Dt[y, x]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.5.2"]
}, Open  ]],

Cell[TextData[{
  "You can make a replacement for ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          StyleBox[\(d  y\),
            "TI"], 
          StyleBox[\(d  x\),
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.2", "2.7"}],

Cell[CellGroupData[{

Cell["% /. Dt[y, x] -> yp", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.2"],

Cell[BoxData[
    \(2\ x + 2\ y\ yp\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.2"]
}, Open  ]],

Cell[TextData[{
  "You can also make an explicit definition for ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          StyleBox[\(d  y\),
            "TI"], 
          StyleBox[\(d  x\),
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". You need to use ",
  StyleBox["y/:", "MR"],
  " to make sure that the definition is associated with ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.2", "2.8"}],

Cell[CellGroupData[{

Cell["y/: Dt[y, x] = 0", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.2"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.2"]
}, Open  ]],

Cell[TextData[{
  "With this definition made, ",
  StyleBox["Dt", "MR"],
  " treats ",
  StyleBox["y", "MR"],
  " as independent of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.2", "2.9"}],

Cell[CellGroupData[{

Cell["Dt[x^2 + y^2 + z^2, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.2"],

Cell[BoxData[
    \(2\ x + 2\ z\ Dt[z, x]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.5.2"]
}, Open  ]],

Cell[TextData[{
  "This removes your definition for the derivative of ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.2", "2.10"}],

Cell["Clear[y]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.2"],

Cell[TextData[{
  "This takes the total derivative, with ",
  StyleBox["z", "MR"],
  " held fixed. "
}], "MathCaption",
  CellTags->{"S3.5.2", "2.11"}],

Cell[CellGroupData[{

Cell["Dt[x^2 + y^2 + z^2, x, Constants->{z}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.5.2"],

Cell[BoxData[
    \(2\ x + 2\ y\ Dt[y, x, Constants \[Rule] {z}]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.5.2"]
}, Open  ]],

Cell[TextData[{
  "This specifies that ",
  StyleBox["c", "MR"],
  " is a constant under differentiation. "
}], "MathCaption",
  CellTags->{"S3.5.2", "2.12"}],

Cell["SetAttributes[c, Constant]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.5.2"],

Cell[TextData[{
  "The variable ",
  StyleBox["c", "MR"],
  " is taken as a constant. "
}], "MathCaption",
  CellTags->{"S3.5.2", "2.13"}],

Cell[CellGroupData[{

Cell["Dt[a^2 + c x^2, x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.5.2"],

Cell[BoxData[
    \(2\ c\ x + 2\ a\ Dt[a, x]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.5.2"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["function", "TI"],
  " ",
  StyleBox["c", "MR"],
  " is also assumed to be a constant.   "
}], "MathCaption",
  CellTags->{"S3.5.2", "2.14"}],

Cell[CellGroupData[{

Cell["Dt[a^2 + c[x] x^2, x]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.5.2"],

Cell[BoxData[
    \(2\ x\ c[x] + 2\ a\ Dt[a, x]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.5.2"]
}, Open  ]],

Cell[TextData[{
  "This gives the total differential ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["d",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "2"], "+", 
              StyleBox["c",
                "TI"], 
              SuperscriptBox[
                StyleBox["y",
                  "TI"], "2"]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ".  "
}], "MathCaption",
  CellTags->{"S3.5.2", "2.15"}],

Cell[CellGroupData[{

Cell["Dt[x^2 + c y^2]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.5.2"],

Cell[BoxData[
    \(2\ x\ Dt[x] + 2\ c\ y\ Dt[y]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.5.2"]
}, Open  ]],

Cell["\<\
You can make replacements and assignments for total differentials. \
\
\>", "MathCaption",
  CellTags->{"S3.5.2", "2.16"}],

Cell[CellGroupData[{

Cell["% /. Dt[y] -> dy", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.5.2"],

Cell[BoxData[
    \(2\ c\ dy\ y + 2\ x\ Dt[x]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.5.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5.3 Derivatives of Unknown Functions", "Subsection",
  CellTags->{"S3.5.3", "3.1"}],

Cell["Differentiating a known function gives an explicit result. ", \
"MathCaption",
  CellTags->{"S3.5.3", "3.2"}],

Cell[CellGroupData[{

Cell["D[Log[x]^2, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.3"],

Cell[BoxData[
    \(\(2\ Log[x]\)\/x\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.5.3"]
}, Open  ]],

Cell[TextData[{
  "Differentiating an unknown function ",
  StyleBox["f", "MR"],
  " gives a result in terms of ",
  StyleBox["f'", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.3", "3.3"}],

Cell[CellGroupData[{

Cell["D[f[x]^2, x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.3"],

Cell[BoxData[
    RowBox[{"2", " ", \(f[x]\), " ", 
      RowBox[{
        SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.5.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " applies the chain rule for differentiation, and leaves the result in \
terms of ",
  StyleBox["f'", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.3", "3.4"}],

Cell[CellGroupData[{

Cell["D[x f[x^2], x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.3"],

Cell[BoxData[
    RowBox[{\(f[x\^2]\), "+", 
      RowBox[{"2", " ", \(x\^2\), " ", 
        RowBox[{
          SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", \(x\^2\), "]"}]}]}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.3"]
}, Open  ]],

Cell[TextData[{
  "Differentiating again gives a result in terms of ",
  StyleBox["f", "MR"],
  ", ",
  StyleBox["f'", "MR"],
  " and ",
  StyleBox["f''", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.3", "3.5"}],

Cell[CellGroupData[{

Cell["D[%, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.3"],

Cell[BoxData[
    RowBox[{
      RowBox[{"6", " ", "x", " ", 
        RowBox[{
          SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", \(x\^2\), "]"}]}], "+", 
      RowBox[{"4", " ", \(x\^3\), " ", 
        RowBox[{
          SuperscriptBox["f", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", \(x\^2\), "]"}]}]}]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.3"]
}, Open  ]],

Cell["\<\
When a function has more than one argument, superscripts are used \
to indicate how many times each argument is being differentiated. \
\>", \
"MathCaption",
  CellTags->{"S3.5.3", "3.6"}],

Cell[CellGroupData[{

Cell["D[g[x^2, y^2], x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.3"],

Cell[BoxData[
    RowBox[{"2", " ", "x", " ", 
      RowBox[{
        SuperscriptBox["g", 
          TagBox[\((1, 0)\),
            Derivative],
          MultilineFunction->None], "[", \(x\^2, y\^2\), "]"}]}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.5.3"]
}, Open  ]],

Cell[TextData[{
  "This represents ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox["\[PartialD]", 
            RowBox[{"\[PartialD]", 
              StyleBox["x",
                "TI"]}]], 
          FractionBox["\[PartialD]", 
            RowBox[{"\[PartialD]", 
              StyleBox["x",
                "TI"]}]], 
          FractionBox["\[PartialD]", 
            RowBox[{"\[PartialD]", 
              StyleBox["y",
                "TI"]}]], 
          StyleBox["g",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], ",", 
              StyleBox["y",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " assumes that the order in which derivatives are taken with respect to \
different variables is irrelevant. "
}], "MathCaption",
  CellTags->{"S3.5.3", "3.7"}],

Cell[CellGroupData[{

Cell["D[g[x, y], x, x, y]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.3"],

Cell[BoxData[
    RowBox[{
      SuperscriptBox["g", 
        TagBox[\((2, 1)\),
          Derivative],
        MultilineFunction->None], "[", \(x, y\), "]"}]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.5.3"]
}, Open  ]],

Cell[TextData[{
  "You can find the value of the derivative when ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  " by replacing ",
  StyleBox["x", "MR"],
  " with ",
  StyleBox["0", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.3", "3.8"}],

Cell[CellGroupData[{

Cell["% /. x->0", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.5.3"],

Cell[BoxData[
    RowBox[{
      SuperscriptBox["g", 
        TagBox[\((2, 1)\),
          Derivative],
        MultilineFunction->None], "[", \(0, y\), "]"}]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.5.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["'[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["first derivative of a function of one variable "]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["f",
                        "TI"], 
                      RowBox[{
                        StyleBox["(",
                          "MR"], Cell[BoxData[
                            StyleBox["n",
                              "TI"]], "InlineFormula"], 
                        StyleBox[")",
                          "MR"]}]], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " derivative of a function of one variable "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["f",
                        "TI"], 
                      RowBox[{
                        StyleBox["(",
                          "MR"], Cell[BoxData[
                            SubscriptBox[
                              StyleBox["n",
                                "TI"], "1"]], "InlineFormula"], 
                        StyleBox[",",
                          "MR"], Cell[BoxData[
                            SubscriptBox[
                              StyleBox["n",
                                "TI"], "2"]], "InlineFormula"], 
                        StyleBox[",",
                          "MR"], Cell[BoxData[
                            \(\(\(\[Ellipsis]\)\(\ \)\)\)], "InlineFormula"], 
                        
                        StyleBox[")",
                          "MR"]}]], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "derivative of a function of several variables, ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " times with respect to variable ",
              StyleBox["i", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.3"],

Cell["Output forms for derivatives of unknown functions. ", "Caption",
  CellTags->"S3.5.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5.4 Advanced Topic: The Representation of Derivatives", "Subsection",
  CellTags->{"S3.5.4", "4.1"}],

Cell[TextData[{
  "Derivatives in ",
  StyleBox["Mathematica", "TI"],
  " work essentially the same as in standard mathematics. The usual \
mathematical notation, however, often hides many details. To understand how \
derivatives are represented in ",
  StyleBox["Mathematica", "TI"],
  ", we must look at these details. "
}], "Text",
  CellTags->{"S3.5.4", "4.2"}],

Cell[TextData[{
  "The standard mathematical notation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["f",
              "TI"], "\[Prime]"], \((0)\)}], TraditionalForm]], 
    "InlineFormula"],
  " is really a shorthand for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox[
            StyleBox["d",
              "TI"], 
            StyleBox[\(d  t\),
              "TI"]], 
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["t",
              "TI"], ")"}], 
          SubscriptBox["\[VerticalSeparator]", 
            RowBox[{
              StyleBox["t",
                "TI"], "=", "0"}]]}], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        StyleBox["t",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is a \[OpenCurlyDoubleQuote]dummy variable\[CloseCurlyDoubleQuote]. \
Similarly, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["f",
              "TI"], "\[Prime]"], 
          RowBox[{"(", 
            SuperscriptBox[
              StyleBox["x",
                "TI"], "2"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is a shorthand for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox[
            StyleBox["d",
              "TI"], 
            StyleBox[\(d  t\),
              "TI"]], 
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["t",
              "TI"], ")"}], 
          SubscriptBox["\[VerticalSeparator]", 
            RowBox[{
              StyleBox["t",
                "TI"], "=", 
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "2"]}]]}], TraditionalForm]], "InlineFormula"],
  ". As suggested by the notation ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["f",
            "TI"], "\[Prime]"], TraditionalForm]], "InlineFormula"],
  ", the object ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox[
            StyleBox["d",
              "TI"], 
            StyleBox[\(d  t\),
              "TI"]], 
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["t",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " can in fact be viewed as a \[OpenCurlyDoubleQuote]pure function\
\[CloseCurlyDoubleQuote], to be evaluated with a particular choice of its \
parameter ",
  Cell[BoxData[
      FormBox[
        StyleBox["t",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". You can think of the operation of differentiation as acting on a ",
  StyleBox["function", "TI"],
  " ",
  Cell[BoxData[
      FormBox[
        StyleBox["f",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", to give a new ",
  StyleBox["function", "TI"],
  ", usually called ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["f",
            "TI"], "\[Prime]"], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.5.4", "4.3"}],

Cell[TextData[{
  "With functions of more than one argument, the simple notation based on \
primes breaks down. You cannot tell for example whether ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["g",
              "TI"], "\[Prime]"], \((0, 1)\)}], TraditionalForm]], 
    "InlineFormula"],
  " stands for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox[
            StyleBox["d",
              "TI"], 
            StyleBox[\(d  t\),
              "TI"]], 
          StyleBox["g",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["t",
                "TI"], ",", "1"}], ")"}], 
          SubscriptBox["\[VerticalSeparator]", 
            RowBox[{
              StyleBox["t",
                "TI"], "=", "0"}]]}], TraditionalForm]], "InlineFormula"],
  " or ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox[
            StyleBox["d",
              "TI"], 
            StyleBox[\(d  t\),
              "TI"]], 
          StyleBox["g",
            "TI"], 
          RowBox[{"(", 
            RowBox[{"0", ",", 
              StyleBox["t",
                "TI"]}], ")"}], 
          SubscriptBox["\[VerticalSeparator]", 
            RowBox[{
              StyleBox["t",
                "TI"], "=", "1"}]]}], TraditionalForm]], "InlineFormula"],
  ", and for almost any ",
  Cell[BoxData[
      FormBox[
        StyleBox["g",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", these will have totally different values. Once again, however, ",
  Cell[BoxData[
      FormBox[
        StyleBox["t",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is just a dummy variable, whose sole  purpose is to show with respect to \
which \[OpenCurlyDoubleQuote]slot\[CloseCurlyDoubleQuote] ",
  Cell[BoxData[
      FormBox[
        StyleBox["g",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is to be differentiated. "
}], "Text",
  CellTags->{"S3.5.4", "4.4"}],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica", "TI"],
  ", as in some branches of mathematics, it is convenient to think about a \
kind of differentiation that acts on ",
  StyleBox["functions", "TI"],
  ", rather than expressions. We need an operation that takes the function ",
  Cell[BoxData[
      FormBox[
        StyleBox["f",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", and gives us the ",
  StyleBox["derivative function", "TI"],
  " ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["f",
            "TI"], "\[Prime]"], TraditionalForm]], "InlineFormula"],
  ". Operations such as this that act on ",
  StyleBox["functions", "TI"],
  ", rather than variables, are known in mathematics as ",
  StyleBox["functionals", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.5.4", "4.5"}],

Cell[TextData[{
  "The object ",
  StyleBox["f'", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " is the result of applying the differentiation functional to the function \
",
  StyleBox["f", "MR"],
  ". The full form of ",
  StyleBox["f'", "MR"],
  " is in fact ",
  StyleBox["Derivative[1][f]", "MR"],
  ". ",
  StyleBox["Derivative[1]", "MR"],
  " is the ",
  StyleBox["Mathematica", "TI"],
  " differentiation functional. "
}], "Text",
  CellTags->{"S3.5.4", "4.6"}],

Cell[TextData[{
  "The arguments in the functional ",
  StyleBox["Derivative[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " specify how many times to differentiate with respect to each \
\[OpenCurlyDoubleQuote]slot\[CloseCurlyDoubleQuote] of the function on which \
it acts. By using functionals to represent differentiation, ",
  StyleBox["Mathematica", "TI"],
  " avoids any need to introduce explicit \[OpenCurlyDoubleQuote]dummy \
variables\[CloseCurlyDoubleQuote]. "
}], "Text",
  CellTags->{"S3.5.4", "4.7"}],

Cell[TextData[{
  "This is the full form of the derivative of the function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.8"}],

Cell[CellGroupData[{

Cell["f' // FullForm", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(\(Derivative[1]\)[f]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[1]//FullForm= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell[TextData[{
  "Here an argument ",
  StyleBox["x", "MR"],
  " is supplied. "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.9"}],

Cell[CellGroupData[{

Cell["f'[x] // FullForm", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(\(\(Derivative[1]\)[f]\)[x]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[2]//FullForm= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell["This is the second derivative. ", "MathCaption",
  CellTags->{"S3.5.4", "4.10"}],

Cell[CellGroupData[{

Cell["f''[x] // FullForm", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(\(\(Derivative[2]\)[f]\)[x]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[3]//FullForm= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell[TextData[{
  "This gives a derivative of the function ",
  StyleBox["g", "MR"],
  " with respect to its second \[OpenCurlyDoubleQuote]slot\
\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.11"}],

Cell[CellGroupData[{

Cell["D[g[x, y], y]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    RowBox[{
      SuperscriptBox["g", 
        TagBox[\((0, 1)\),
          Derivative],
        MultilineFunction->None], "[", \(x, y\), "]"}]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell["Here is the full form. ", "MathCaption",
  CellTags->{"S3.5.4", "4.12"}],

Cell[CellGroupData[{

Cell["% // FullForm", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(\(\(Derivative[0, 1]\)[g]\)[x, y]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[5]//FullForm= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell[TextData[{
  "Here is the second derivative with respect to the variable ",
  StyleBox["y", "MR"],
  ", which appears in the second slot of ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.13"}],

Cell[CellGroupData[{

Cell["D[g[x, y], {y, 2}] // FullForm", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(\(\(Derivative[0, 2]\)[g]\)[x, y]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[6]//FullForm= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell["This is a mixed derivative. ", "MathCaption",
  CellTags->{"S3.5.4", "4.14"}],

Cell[CellGroupData[{

Cell["D[g[x, y], x, y, y] // FullForm", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(\(\(Derivative[1, 2]\)[g]\)[x, y]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[7]//FullForm= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell[TextData[{
  "Since ",
  StyleBox["Derivative", "MR"],
  " only specifies how many times to differentiate with respect to each slot, \
the order of the derivatives is irrelevant. "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.15"}],

Cell[CellGroupData[{

Cell["D[g[x, y], y, y, x] // FullForm", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(\(\(Derivative[1, 2]\)[g]\)[x, y]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[8]//FullForm= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell[TextData[{
  "Here is a more complicated case, in which both arguments of ",
  StyleBox["g", "MR"],
  " depend on the differentiation variable. "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.16"}],

Cell[CellGroupData[{

Cell["D[g[x, x], x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["g", 
          TagBox[\((0, 1)\),
            Derivative],
          MultilineFunction->None], "[", \(x, x\), "]"}], "+", 
      RowBox[{
        SuperscriptBox["g", 
          TagBox[\((1, 0)\),
            Derivative],
          MultilineFunction->None], "[", \(x, x\), "]"}]}]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell["This is the full form of the result. ", "MathCaption",
  CellTags->{"S3.5.4", "4.17"}],

Cell[CellGroupData[{

Cell["% // FullForm", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[\(\(Derivative[0, 1]\)[g]\)[x, 
            x], \(\(Derivative[1, 0]\)[g]\)[x, x]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[10]//FullForm= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell[TextData[{
  "The object ",
  StyleBox["f'", "MR"],
  " behaves essentially like any other function in ",
  StyleBox["Mathematica", "TI"],
  ". You can evaluate the function with any argument, and you can use \
standard ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["/.", "MR"],
  " operations to change the argument. (This would not be possible if \
explicit dummy variables had been introduced in the course of the \
differentiation.) "
}], "Text",
  CellTags->{"S3.5.4", "4.18"}],

Cell[TextData[{
  "This is the ",
  StyleBox["Mathematica", "TI"],
  " representation of the derivative of a function ",
  StyleBox["f", "MR"],
  ", evaluated at the origin. "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.19"}],

Cell[CellGroupData[{

Cell["f'[0] // FullForm", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(\(\(Derivative[1]\)[f]\)[0]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[11]//FullForm= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell[TextData[{
  "The result of this derivative involves ",
  StyleBox["f'", "MR"],
  " evaluated with the argument ",
  StyleBox["x^2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.20"}],

Cell[CellGroupData[{

Cell["D[f[x^2], x]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    RowBox[{"2", " ", "x", " ", 
      RowBox[{
        SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", \(x\^2\), "]"}]}]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell[TextData[{
  "You can evaluate the result at the point ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "2"}], TraditionalForm]], "InlineFormula"],
  " by using the standard ",
  StyleBox["Mathematica", "TI"],
  " replacement operation. "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.21"}],

Cell[CellGroupData[{

Cell["% /. x->2", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    RowBox[{"4", " ", 
      RowBox[{
        SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "4", "]"}]}]], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell[TextData[{
  "There is some slight subtlety when you need to deduce the value of ",
  StyleBox["f'", "MR"],
  " based on definitions for objects like ",
  StyleBox["f[x_]", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.5.4", "4.22"}],

Cell[TextData[{
  "Here is a definition for a function ",
  StyleBox["h", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.23"}],

Cell["h[x_] := x^4", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.5.4"],

Cell[TextData[{
  "When you take the derivative of ",
  StyleBox["h[x]", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " first evaluates ",
  StyleBox["h[x]", "MR"],
  ", then differentiates the result. "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.24"}],

Cell[CellGroupData[{

Cell["D[h[x], x]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    \(4\ x\^3\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell[TextData[{
  "You can get the same result by applying the function ",
  StyleBox["h'", "MR"],
  " to the argument ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.25"}],

Cell[CellGroupData[{

Cell["h'[x]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    \(4\ x\^3\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell[TextData[{
  "Here is the function ",
  StyleBox["h'", "MR"],
  " on its own. "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.26"}],

Cell[CellGroupData[{

Cell["h'", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    \(4\ #1\^3 &\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["f'", "MR"],
  " is completely determined by the form of the function ",
  StyleBox["f", "MR"],
  ". Definitions for objects like ",
  StyleBox["f[x_]", "MR"],
  " do not immediately apply however to expressions like ",
  StyleBox["f'[x]", "MR"],
  ". The problem is that ",
  StyleBox["f'[x]", "MR"],
  " has the full form ",
  StyleBox["Derivative[1][f][x]", "MR"],
  ", which nowhere contains anything that explicitly matches the pattern ",
  StyleBox["f[x_]", "MR"],
  ". In addition, for many purposes it is convenient to have a representation \
of the function ",
  StyleBox["f'", "MR"],
  " itself, without necessarily applying it to any arguments. "
}], "Text",
  CellTags->{"S3.5.4", "4.27"}],

Cell[TextData[{
  "What ",
  StyleBox["Mathematica", "TI"],
  " does is to try and find the explicit form of a ",
  StyleBox["pure function", "TI"],
  " which represents the object ",
  StyleBox["f'", "MR"],
  ". When ",
  StyleBox["Mathematica", "TI"],
  " gets an expression like ",
  StyleBox["Derivative[1][f]", "MR"],
  ", it effectively converts it to the explicit form ",
  StyleBox["D[f[#],", "MR"],
  " ",
  StyleBox["#]&", "MR"],
  " and then tries to evaluate the derivative. In the explicit form, ",
  StyleBox["Mathematica", "TI"],
  " can immediately use values that have been defined for objects like ",
  StyleBox["f[x_]", "MR"],
  ". If ",
  StyleBox["Mathematica", "TI"],
  " succeeds in doing the derivative, it returns the explicit \
pure\[Hyphen]function result. If it does not succeed, it leaves the \
derivative in the original ",
  StyleBox["f'", "MR"],
  " form. "
}], "Text",
  CellTags->{"S3.5.4", "4.28"}],

Cell[TextData[{
  "This gives the derivative of ",
  StyleBox["Tan", "MR"],
  " in pure\[Hyphen]function form. "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.29"}],

Cell[CellGroupData[{

Cell["Tan'", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    \(Sec[#1]\^2 &\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.5.4"]
}, Open  ]],

Cell[TextData[{
  "Here is the result of applying the pure function to the specific argument \
",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.4", "4.30"}],

Cell[CellGroupData[{

Cell["%[y]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.5.4"],

Cell[BoxData[
    \(Sec[y]\^2\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.5.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5.5 Defining Derivatives", "Subsection",
  CellTags->{"S3.5.5", "5.1"}],

Cell[TextData[{
  "You can define the derivative in ",
  StyleBox["Mathematica", "TI"],
  " of a function ",
  StyleBox["f", "MR"],
  " of one argument simply by an assignment like ",
  StyleBox["f'[x_]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["fp[x]", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.5.5", "5.2"}],

Cell[TextData[{
  "This defines the derivative of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " to be ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], 
          StyleBox["p",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". In this case, you could have used ",
  StyleBox["=", "MR"],
  " instead of ",
  StyleBox[":=", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.5", "5.3"}],

Cell["f'[x_] := fp[x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.5"],

Cell[TextData[{
  "The rule for ",
  StyleBox["f'[x_]", "MR"],
  " is used to evaluate this derivative. "
}], "MathCaption",
  CellTags->{"S3.5.5", "5.4"}],

Cell[CellGroupData[{

Cell["D[f[x^2], x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.5"],

Cell[BoxData[
    \(2\ x\ fp[x\^2]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.5.5"]
}, Open  ]],

Cell[TextData[{
  "Differentiating again gives derivatives of ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f  p\),
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.5", "5.5"}],

Cell[CellGroupData[{

Cell["D[%, x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.5"],

Cell[BoxData[
    RowBox[{\(2\ fp[x\^2]\), "+", 
      RowBox[{"4", " ", \(x\^2\), " ", 
        RowBox[{
          SuperscriptBox["fp", "\[Prime]",
            MultilineFunction->None], "[", \(x\^2\), "]"}]}]}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.5"]
}, Open  ]],

Cell[TextData[{
  "This defines a value for the derivative of ",
  Cell[BoxData[
      FormBox[
        StyleBox["g",
          "TI"], TraditionalForm]], "InlineFormula"],
  " at the origin. "
}], "MathCaption",
  CellTags->{"S3.5.5", "5.6"}],

Cell[CellGroupData[{

Cell["g'[0] = g0", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.5"],

Cell[BoxData[
    \(g0\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.5"]
}, Open  ]],

Cell[TextData[{
  "The value for ",
  StyleBox["g'[0]", "MR"],
  " is used. "
}], "MathCaption",
  CellTags->{"S3.5.5", "5.7"}],

Cell[CellGroupData[{

Cell["D[g[x]^2, x] /. x->0", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.5"],

Cell[BoxData[
    \(2\ g0\ g[0]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.5.5"]
}, Open  ]],

Cell[TextData[{
  "This defines the second derivative of ",
  StyleBox["g", "MR"],
  ", with any argument. "
}], "MathCaption",
  CellTags->{"S3.5.5", "5.8"}],

Cell[CellGroupData[{

Cell["g''[x_] = gpp[x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.5"],

Cell[BoxData[
    \(gpp[x]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.5.5"]
}, Open  ]],

Cell["The value defined for the second derivative is used. ", "MathCaption",
  CellTags->{"S3.5.5", "5.9"}],

Cell[CellGroupData[{

Cell["D[g[x]^2, {x, 2}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.5.5"],

Cell[BoxData[
    RowBox[{\(2\ g[x]\ gpp[x]\), "+", 
      RowBox[{"2", " ", 
        SuperscriptBox[
          RowBox[{
            SuperscriptBox["g", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], "2"]}]}]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.5.5"]
}, Open  ]],

Cell[TextData[{
  "To define derivatives of functions with several arguments, you have to use \
the general representation of derivatives in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.5.5", "5.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["'[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["_]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "define the first derivative of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Derivative[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["][", "MR"],
              StyleBox["f", "TI"],
              StyleBox["][", "MR"],
              StyleBox["x", "TI"],
              StyleBox["_]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "define the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " derivative of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Derivative[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["][", "MR"],
              StyleBox["g", "TI"],
              StyleBox["][", "MR"],
              StyleBox["x", "TI"],
              StyleBox["_,", "MR"],
              " ",
              StyleBox["_,", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "define derivatives of ",
              StyleBox["g", "TI"],
              " with respect to various arguments "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.5"],

Cell["Defining derivatives. ", "Caption",
  CellTags->"S3.5.5"],

Cell[TextData[{
  "This defines the second derivative of ",
  StyleBox["g", "MR"],
  " with respect to its second argument. "
}], "MathCaption",
  CellTags->{"S3.5.5", "5.11"}],

Cell["Derivative[0, 2][g][x_, y_] := g2p[x, y]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.5.5"],

Cell["This uses the definition just given. ", "MathCaption",
  CellTags->{"S3.5.5", "5.12"}],

Cell[CellGroupData[{

Cell["D[g[a^2, x^2], x, x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.5.5"],

Cell[BoxData[
    RowBox[{\(4\ x\^2\ g2p[a\^2, x\^2]\), "+", 
      RowBox[{"2", " ", 
        RowBox[{
          SuperscriptBox["g", 
            TagBox[\((0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(a\^2, x\^2\), 
          "]"}]}]}]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.5.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5.6 Indefinite Integrals", "Subsection",
  CellTags->{"S3.5.6", "6.1"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["Integrate[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " gives you the ",
  StyleBox["indefinite integral", "TI"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          StyleBox["f",
            "TI"], " ", 
          StyleBox["d",
            "TI"], 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". You can think of the operation of indefinite integration as being an \
inverse of differentiation. If you take the result from ",
  StyleBox["Integrate[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ", and then differentiate it, you always get a result that is \
mathematically equal to the original expression ",
  StyleBox["f", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.5.6", "6.2"}],

Cell[TextData[{
  "In general, however, there is a whole family of results which have the \
property that their derivative is ",
  StyleBox["f", "TI"],
  ". ",
  StyleBox["Integrate[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " gives you ",
  StyleBox["an", "TI"],
  " expression whose derivative is ",
  StyleBox["f", "TI"],
  ". You can get other expressions by adding an arbitrary constant of \
integration, or indeed by adding any function that is constant except at \
discrete points.  "
}], "Text",
  CellTags->{"S3.5.6", "6.3"}],

Cell["\<\
If you fill in explicit limits for your integral, any such \
constants of integration must cancel out. But even though the indefinite \
integral can have arbitrary constants added, it is still often very \
convenient to manipulate it without filling in the limits. \
\>", "Text",
  CellTags->{"S3.5.6", "6.4"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " applies standard rules to find indefinite integrals. "
}], "MathCaption",
  CellTags->{"S3.5.6", "6.5"}],

Cell[CellGroupData[{

Cell["Integrate[x^2, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(x\^3\/3\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell[TextData[{
  "You can add an arbitrary constant to the indefinite integral, and still \
get the same derivative. ",
  StyleBox["Integrate", "MR"],
  " simply gives you ",
  StyleBox["an", "TI"],
  " expression with the required derivative. "
}], "MathCaption",
  CellTags->{"S3.5.6", "6.6"}],

Cell[CellGroupData[{

Cell["D[ % + c, x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(x\^2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell[TextData[{
  "This gives the indefinite integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          FractionBox[
            StyleBox[\(d  x\),
              "TI"], 
            RowBox[{
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "2"], "-", "1"}]]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.6", "6.7"}],

Cell[CellGroupData[{

Cell["Integrate[1/(x^2 - 1), x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(1\/2\ Log[\(-1\) + x] - 1\/2\ Log[1 + x]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell["\<\
Differentiating should give the original function back again. \
\
\>", "MathCaption",
  CellTags->{"S3.5.6", "6.8"}],

Cell[CellGroupData[{

Cell["D[%, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(1\/\(2\ \((\(-1\) + x)\)\) - 1\/\(2\ \((1 + x)\)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell["\<\
You need to manipulate it to get it back into the original form. \
\
\>", "MathCaption",
  CellTags->{"S3.5.6", "6.9"}],

Cell[CellGroupData[{

Cell["Simplify[%]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(1\/\(\(-1\) + x\^2\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Integrate", "MR"],
  " function assumes that any object that does not explicitly contain the \
integration variable is independent of it, and can be treated as a constant. \
As a result, ",
  StyleBox["Integrate", "MR"],
  " is like an inverse of the ",
  StyleBox["partial differentiation", "TI"],
  " function ",
  StyleBox["D", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.5.6", "6.10"}],

Cell[TextData[{
  "The variable ",
  StyleBox["a", "MR"],
  " is assumed to be independent of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.6", "6.11"}],

Cell[CellGroupData[{

Cell["Integrate[a x^2, x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(\(a\ x\^3\)\/3\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell["\<\
The integration variable can be any expression that does not \
involve explicit mathematical operations.  \
\>", "MathCaption",
  CellTags->{"S3.5.6", "6.12"}],

Cell[CellGroupData[{

Cell["Integrate[x b[x]^2, b[x]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(1\/3\ x\ b[x]\^3\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell[TextData[{
  "Another assumption that ",
  StyleBox["Integrate", "MR"],
  " implicitly makes is that all the symbolic quantities in your integrand \
have \[OpenCurlyDoubleQuote]generic\[CloseCurlyDoubleQuote] values. Thus, for \
example, ",
  StyleBox["Mathematica", "TI"],
  " will tell you that ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          SuperscriptBox[
            StyleBox["x",
              "TI"], 
            StyleBox["n",
              "TI"]], "\[DifferentialD]", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " is ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          SuperscriptBox[
            StyleBox["x",
              "TI"], 
            RowBox[{
              StyleBox["n",
                "TI"], "+", "1"}]], 
          RowBox[{
            StyleBox["n",
              "TI"], "+", "1"}]], TraditionalForm]], "InlineFormula"],
  " even though this is not true in the special case ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "=", \(-1\)}], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.5.6", "6.13"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " gives the standard result for this integral, implicitly assuming that ",
  StyleBox["n", "MR"],
  " is not equal to ",
  StyleBox["-1", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.6", "6.14"}],

Cell[CellGroupData[{

Cell["Integrate[x^n, x]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(x\^\(1 + n\)\/\(1 + n\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell[TextData[{
  "If you specifically give an exponent of ",
  StyleBox["-1", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " produces a different result. "
}], "MathCaption",
  CellTags->{"S3.5.6", "6.15"}],

Cell[CellGroupData[{

Cell["Integrate[x^-1, x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(Log[x]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell[TextData[{
  "You should realize that the result for any particular integral can often \
be written in many different forms. ",
  StyleBox["Mathematica", "TI"],
  " tries to give you the most convenient form, following principles such as \
avoiding explicit complex numbers unless your input already contains them. "
}], "Text",
  CellTags->{"S3.5.6", "6.16"}],

Cell[TextData[{
  "This integral is given in terms of ",
  StyleBox["ArcTan", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.6", "6.17"}],

Cell[CellGroupData[{

Cell["Integrate[1/(1 + a x^2), x]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(ArcTan[\@a\ x]\/\@a\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell[TextData[{
  "This integral is given in terms of ",
  StyleBox["ArcTanh", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.6", "6.18"}],

Cell[CellGroupData[{

Cell["Integrate[1/(1 - b x^2), x]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(ArcTanh[\@b\ x]\/\@b\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell["\<\
This is mathematically equal to the first integral, but is given in \
a somewhat different form. \
\>", "MathCaption",
  CellTags->{"S3.5.6", "6.19"}],

Cell[CellGroupData[{

Cell["% /. b -> -a", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(ArcTanh[\@\(-a\)\ x]\/\@\(-a\)\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell["The derivative is still correct. ", "MathCaption",
  CellTags->{"S3.5.6", "6.20"}],

Cell[CellGroupData[{

Cell["D[%, x]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(1\/\(1 + a\ x\^2\)\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell[TextData[{
  "Even though they look quite different, both ",
  StyleBox["ArcTan[x]", "MR"],
  " and ",
  StyleBox["-ArcTan[1/x]", "MR"],
  " are indefinite integrals of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{"1", "+", 
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "2"]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.6", "6.21"}],

Cell[CellGroupData[{

Cell["Simplify[D[{ArcTan[x], -ArcTan[1/x]}, x]]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \({1\/\(1 + x\^2\), 1\/\(1 + x\^2\)}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.5.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Integrate", "MR"],
  " chooses to use the simpler of the two forms. "
}], "MathCaption",
  CellTags->{"S3.5.6", "6.22"}],

Cell[CellGroupData[{

Cell["Integrate[1/(1 + x^2), x]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.5.6"],

Cell[BoxData[
    \(ArcTan[x]\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.5.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5.7 Integrals That Can and Cannot Be Done", "Subsection",
  CellTags->{"S3.5.7", "7.1"}],

Cell["\<\
Evaluating integrals is much more difficult than evaluating \
derivatives. For derivatives, there is a systematic procedure based on the \
chain rule that effectively allows any derivative to be worked out. But for \
integrals, there is no such systematic procedure. \
\>", "Text",
  CellTags->{"S3.5.7", "7.2"}],

Cell["\<\
One of the main problems is that it is difficult to know what kinds \
of functions will be needed to evaluate a particular integral. When you work \
out a derivative, you always end up with functions that are of the same kind \
or simpler than the ones you started with. But when you work out integrals, \
you often end up needing to use functions that are much more complicated than \
the ones you started with. \
\>", "Text",
  CellTags->{"S3.5.7", "7.3"}],

Cell["\<\
This integral can be evaluated using the same kind of functions \
that appeared in the input. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.4"}],

Cell[CellGroupData[{

Cell["Integrate[Log[x]^2, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(2\ x - 2\ x\ Log[x] + x\ Log[x]\^2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell[TextData[{
  "But for this integral the special function ",
  StyleBox["LogIntegral", "MR"],
  " is needed. "
}], "MathCaption",
  CellTags->{"S3.5.7", "7.5"}],

Cell[CellGroupData[{

Cell["Integrate[Log[Log[x]], x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(x\ Log[Log[x]] - LogIntegral[x]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
It is not difficult to find integrals that require all sorts of \
functions. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.6"}],

Cell[CellGroupData[{

Cell["Integrate[Sin[x^2], x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(\@\(\[Pi]\/2\)\ FresnelS[\@\(2\/\[Pi]\)\ x]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell[TextData[{
  "Simple\[Hyphen]looking integrals can give remarkably complicated results. \
Often it is convenient to apply ",
  StyleBox["Simplify", "MR"],
  " to your answers. "
}], "MathCaption",
  CellTags->{"S3.5.7", "7.7"}],

Cell[CellGroupData[{

Cell["Simplify[ Integrate[Log[x] Exp[-x^2], x] ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(\(-x\)\ HypergeometricPFQ[{1\/2, 1\/2}, {3\/2, 3\/2}, \(-x\^2\)] + 
      1\/2\ \@\[Pi]\ Erf[x]\ Log[x]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell[TextData[{
  "This integral involves an incomplete gamma function. Note that the power \
is carefully set up to allow any complex value of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.7", "7.8"}],

Cell[CellGroupData[{

Cell["Integrate[Exp[-x^a], x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(\(-\(\(x\ \((x\^a)\)\^\(\(-1\)/a\)\ Gamma[1\/a, 
              x\^a]\)\/a\)\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " includes a very wide range of mathematical functions, and by using these \
functions a great many integrals can be done. But it is still possible to \
find even fairly simple\[Hyphen]looking integrals that just cannot be done in \
terms of any standard mathematical functions. "
}], "Text",
  CellTags->{"S3.5.7", "7.9"}],

Cell["\<\
Here is a fairly simple\[Hyphen]looking integral that cannot be \
done in terms of any standard mathematical functions. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.10"}],

Cell[CellGroupData[{

Cell["Integrate[Sin[x]/Log[x], x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(\[Integral]\(Sin[x]\/Log[x]\) \[DifferentialD]x\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
The main point of being able to do an integral in terms of standard \
mathematical functions is that it lets one use the known properties of these \
functions to evaluate or manipulate the result one gets. \
\>", "Text",
  CellTags->{"S3.5.7", "7.11"}],

Cell[TextData[{
  "In the most convenient cases, integrals can be done purely in terms of \
elementary functions such as exponentials, logarithms and trigonometric \
functions. In fact, if you give an integrand that involves only such \
elementary functions, then one of the important capabilities of ",
  StyleBox["Integrate", "MR"],
  " is that if the corresponding integral can be expressed in terms of \
elementary functions, then ",
  StyleBox["Integrate", "MR"],
  " will essentially always succeed in finding it.   "
}], "Text",
  CellTags->{"S3.5.7", "7.12"}],

Cell["\<\
Integrals of rational functions are straightforward to evaluate, \
and always come out in terms of rational functions, logarithms and inverse \
trigonometric functions. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.13"}],

Cell[CellGroupData[{

Cell["Integrate[x/((x - 1)(x + 2)), x]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(1\/3\ Log[\(-1\) + x] + 2\/3\ Log[2 + x]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
The integral here is still of the same form, but now involves an \
implicit sum over the roots of a polynomial. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.14"}],

Cell[CellGroupData[{

Cell["Integrate[1/(1 + 2 x + x^3), x]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(RootSum[1 + 2\ #1 + #1\^3 &, 
      Log[x - #1]\/\(2 + 3\ #1\^2\) &]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
This finds numerical approximations to all the root objects. \
\>", \
"MathCaption",
  CellTags->{"S3.5.7", "7.15"}],

Cell[CellGroupData[{

Cell["N[%]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(\((\(-0.19107976295300613`\) - 
            0.08854101973827559`\ \[ImaginaryI])\)\ \
Log[\((\(-0.22669882575820188`\) - 1.4677115087102242`\ \[ImaginaryI])\) + 
            x] - \((\(\(0.19107976295300613`\)\(\[InvisibleSpace]\)\) - 
            0.08854101973827559`\ \[ImaginaryI])\)\ \
Log[\((\(-0.22669882575820188`\) + 1.4677115087102242`\ \[ImaginaryI])\) + 
            x] + 0.38215952590601215`\ Log[\(\(0.45339765151640377`\)\(\
\[InvisibleSpace]\)\) + x]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
Integrals of trigonometric functions usually come out in terms of \
other trigonometric functions. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.16"}],

Cell[CellGroupData[{

Cell["Integrate[Sin[x]^3 Cos[x]^2, x]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(\(-\(Cos[x]\/8\)\) - 1\/48\ Cos[3\ x] + 1\/80\ Cos[5\ x]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
This is a fairly simple integral involving algebraic functions. \
\
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.17"}],

Cell[CellGroupData[{

Cell["Integrate[Sqrt[x] Sqrt[1 + x], x]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(1\/4\ \((\@x\ \@\(1 + x\)\ \((1 + 2\ x)\) - ArcSinh[\@x])\)\)], "Output",\

  CellLabel->"Out[11]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["Here is an integral involving nested square roots. ", "MathCaption",
  CellTags->{"S3.5.7", "7.18"}],

Cell[CellGroupData[{

Cell["Integrate[Sqrt[x + Sqrt[x]], x]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(\(\@\(\@x + x\)\ \((\@\(1 + \@x\)\ x\^\(1/4\)\ \((\(-3\) + 2\ \@x + 8\ \
x)\) + 3\ ArcSinh[x\^\(1/4\)])\)\)\/\(12\ \@\(1 + \@x\)\ x\^\(1/4\)\)\)], \
"Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
By nesting elementary functions you sometimes get integrals that \
can be done in terms of elementary functions. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.19"}],

Cell[CellGroupData[{

Cell["Integrate[Cos[Log[x]], x]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(1\/2\ x\ Cos[Log[x]] + 1\/2\ x\ Sin[Log[x]]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["But more often other kinds of functions are needed. ", "MathCaption",
  CellTags->{"S3.5.7", "7.20"}],

Cell[CellGroupData[{

Cell["Integrate[Log[Cos[x]], x]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(\(\[ImaginaryI]\ x\^2\)\/2 - 
      x\ Log[1 + \[ExponentialE]\^\(2\ \[ImaginaryI]\ x\)] + x\ Log[Cos[x]] + 
      1\/2\ \[ImaginaryI]\ PolyLog[
          2, \(-\[ExponentialE]\^\(2\ \[ImaginaryI]\ x\)\)]\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
Integrals like this typically come out in terms of elliptic \
functions. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.21"}],

Cell[CellGroupData[{

Cell["Integrate[Sqrt[Cos[x]], x]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(2\ EllipticE[x\/2, 2]\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
But occasionally one can get results in terms of elementary \
functions alone. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.22"}],

Cell[CellGroupData[{

Cell["Integrate[Sqrt[Tan[x]], x]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(\(1\/\(2\ \@2\)\) \((\(-2\)\ ArcTan[1 - \@2\ \@Tan[x]] + 
          2\ ArcTan[1 + \@2\ \@Tan[x]] + 
          Log[\(-1\) + \@2\ \@Tan[x] - Tan[x]] - 
          Log[1 + \@2\ \@Tan[x] + Tan[x]])\)\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell[TextData[{
  "Integrals like this can systematically be done using ",
  StyleBox["Piecewise", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.7", "7.23"}],

Cell[CellGroupData[{

Cell["Integrate[2^Max[x, 1 - x], x]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    RowBox[{"\[Piecewise]", GridBox[{
          {\(-\(2\^\(1 - x\)\/Log[2]\)\), \(x \[LessEqual] 1\/2\)},
          {\(\(-\(\(2\ \@2\)\/Log[2]\)\) + 2\^x\/Log[2]\), 
            TagBox["True",
              "PiecewiseDefault",
              AutoDelete->False,
              DeletionWarning->True]}
          },
        ColumnSpacings->1.2,
        ColumnAlignments->{Left}]}]], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell[TextData[{
  "Beyond working with elementary functions, ",
  StyleBox["Integrate", "MR"],
  " includes a large number of algorithms for dealing with special functions. \
Sometimes it uses a direct generalization of the procedure for elementary \
functions. But more often its strategy is first to try to write the integrand \
in a form that can be integrated in terms of certain sophisticated special \
functions, and then having done this to try to find reductions of these \
sophisticated functions to more familiar functions. "
}], "Text",
  CellTags->{"S3.5.7", "7.24"}],

Cell["\<\
To integrate this Bessel function requires a generalized \
hypergeometric function. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.25"}],

Cell[CellGroupData[{

Cell["Integrate[BesselJ[0, x], x]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(x\ HypergeometricPFQ[{1\/2}, {1, 3\/2}, \(-\(x\^2\/4\)\)]\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
To integrate an elliptic integral also requires a generalized \
hypergeometric function. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.26"}],

Cell[CellGroupData[{

Cell["Integrate[EllipticK[x], x]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(1\/2\ \[Pi]\ x\ HypergeometricPFQ[{1\/2, 1\/2}, {2}, x]\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
Sometimes the integrals can be reduced to more familiar forms. \
\
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.27"}],

Cell[CellGroupData[{

Cell["Integrate[x^3 BesselJ[0, x], x]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(\(-x\^2\)\ \((\(-2\)\ BesselJ[2, x] + x\ BesselJ[3, x])\)\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell[TextData[{
  "A large book of integral tables will list perhaps a few thousand \
indefinite integrals. ",
  StyleBox["Mathematica", "TI"],
  " can do essentially all of these integrals. And because it contains \
general algorithms rather than just specific cases, ",
  StyleBox["Mathematica", "TI"],
  " can actually do a vastly wider range of integrals.    "
}], "Text",
  CellTags->{"S3.5.7", "7.28"}],

Cell["\<\
You could expect to find this integral in any large book of \
integral tables. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.29"}],

Cell[CellGroupData[{

Cell["Integrate[Log[1 - x]/x, x]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(\(-PolyLog[2, x]\)\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
To do this integral, however, requires a more general algorithm, \
rather than just a direct table lookup. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.30"}],

Cell[CellGroupData[{

Cell["Integrate[Log[1 + 3 x + x^2]/x, x]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(Log[
          x]\ \((Log[1\/2\ \((3 - \@5)\) + x] - 
            Log[1 + \(2\ x\)\/\(3 - \@5\)])\) + 
      Log[x]\ \((Log[1\/2\ \((3 + \@5)\) + x] - 
            Log[1 + \(2\ x\)\/\(3 + \@5\)])\) + 
      Log[x]\ \((\(-Log[1\/2\ \((3 - \@5)\) + x]\) - 
            Log[1\/2\ \((3 + \@5)\) + x] + Log[1 + 3\ x + x\^2])\) - 
      PolyLog[2, \(-\(\(2\ x\)\/\(3 - \@5\)\)\)] - 
      PolyLog[2, \(-\(\(2\ x\)\/\(3 + \@5\)\)\)]\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell[TextData[{
  "Particularly if you introduce new mathematical functions of your own, you \
may want to teach ",
  StyleBox["Mathematica", "TI"],
  " new kinds of integrals. You can do this by making appropriate definitions \
for ",
  StyleBox["Integrate", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.5.7", "7.31"}],

Cell[TextData[{
  "In the case of differentiation, the chain rule allows one to reduce all \
derivatives to a standard form, represented in ",
  StyleBox["Mathematica", "TI"],
  " using ",
  StyleBox["Derivative", "MR"],
  ". But for integration, no such similar standard form exists, and as a \
result you often have to make definitions for several different versions of \
the same integral. Changes of variables and other transformations can rarely \
be done automatically by ",
  StyleBox["Integrate", "MR"],
  ".   "
}], "Text",
  CellTags->{"S3.5.7", "7.32"}],

Cell[TextData[{
  "This integral cannot be done in terms of any of the standard mathematical \
functions built into ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.7", "7.33"}],

Cell[CellGroupData[{

Cell["Integrate[Sin[Sin[x]], x]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(\[Integral]Sin[Sin[x]] \[DifferentialD]x\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
Before you add your own rules for integration, you have to remove \
write protection. \
\>", "MathCaption",
  CellTags->{"S3.5.7", "7.34"}],

Cell[CellGroupData[{

Cell["Unprotect[Integrate]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \({"Integrate"}\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell["\<\
You can set up your own rule to define the integral to be, say, a \
\[OpenCurlyDoubleQuote]Jones\[CloseCurlyDoubleQuote] function. \
\>", \
"MathCaption",
  CellTags->{"S3.5.7", "7.35"}],

Cell["Integrate[Sin[Sin[a_. + b_. x_]], x_] := Jones[a, x]/b", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.5.7"],

Cell[TextData[{
  "Now ",
  StyleBox["Mathematica", "TI"],
  " can do integrals that give Jones functions. "
}], "MathCaption",
  CellTags->{"S3.5.7", "7.36"}],

Cell[CellGroupData[{

Cell["Integrate[Sin[Sin[3x]], x]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.5.7"],

Cell[BoxData[
    \(1\/3\ Jones[0, x]\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S3.5.7"]
}, Open  ]],

Cell[TextData[{
  "As it turns out, the integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", "sin", 
          RowBox[{"(", 
            RowBox[{"sin", 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}], ")"}], "\[DifferentialD]", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " can in principle be represented as an infinite sum of ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_2\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"]}], TraditionalForm]], "InlineFormula"],
  " hypergeometric functions, or as a suitably generalized Kamp\[EAcute] de F\
\[EAcute]riet hypergeometric function of two variables.   "
}], "Text",
  CellTags->{"S3.5.7", "7.37"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5.8 Definite Integrals", "Subsection",
  CellTags->{"S3.5.8", "8.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the indefinite integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Integral]", 
                      StyleBox["f",
                        "TI"], " ", 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the definite integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox["\[Integral]", 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["max",
                            "TI"]]], 
                      StyleBox["f",
                        "TI"], " ", 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the multiple integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox["\[Integral]", 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["max",
                            "TI"]]], 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["x",
                        "TI"], " ", 
                      SubsuperscriptBox["\[Integral]", 
                        SubscriptBox[
                          StyleBox["y",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], 
                        SubscriptBox[
                          StyleBox["y",
                            "TI"], 
                          StyleBox["max",
                            "TI"]]], 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["y",
                        "TI"], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.8"],

Cell["Integration functions. ", "Caption",
  CellTags->"S3.5.8"],

Cell[TextData[{
  "Here is the integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox["\[Integral]", 
            StyleBox["a",
              "TI"], 
            StyleBox["b",
              "TI"]], 
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"], " ", 
          StyleBox["d",
            "TI"], 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.2"}],

Cell[CellGroupData[{

Cell["Integrate[x^2, {x, a, b}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(\(-\(a\^3\/3\)\) + b\^3\/3\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[TextData[{
  "This gives the multiple integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox["\[Integral]", "0", 
            StyleBox["a",
              "TI"]], 
          StyleBox["d",
            "TI"], 
          StyleBox["x",
            "TI"], " ", 
          SubsuperscriptBox["\[Integral]", "0", 
            StyleBox["b",
              "TI"]], 
          StyleBox["d",
            "TI"], 
          StyleBox["y",
            "TI"], " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "2"], "+", 
              SuperscriptBox[
                StyleBox["y",
                  "TI"], "2"]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.3"}],

Cell[CellGroupData[{

Cell["Integrate[x^2 + y^2, {x, 0, a}, {y, 0, b}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(1\/3\ a\ b\ \((a\^2 + b\^2)\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["y", "MR"],
  " integral is done first. Its limits can depend on the value of ",
  StyleBox["x", "MR"],
  ". This ordering is the same as is used in functions like ",
  StyleBox["Sum", "MR"],
  " and ",
  StyleBox["Table", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.4"}],

Cell[CellGroupData[{

Cell["Integrate[x^2 + y^2, {x, 0, a}, {y, 0, x}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(a\^4\/3\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell["\<\
In simple cases, definite integrals can be done by finding \
indefinite forms and then computing appropriate limits. But there is a vast \
range of integrals for which the indefinite form cannot be expressed in terms \
of standard mathematical functions, but the definite form still can be. \
\
\>", "Text",
  CellTags->{"S3.5.8", "8.5"}],

Cell["\<\
This indefinite integral cannot be done in terms of standard \
mathematical functions. \
\>", "MathCaption",
  CellTags->{"S3.5.8", "8.6"}],

Cell[CellGroupData[{

Cell["Integrate[Cos[Sin[x]], x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(\[Integral]Cos[Sin[x]] \[DifferentialD]x\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell["\<\
This definite integral, however, can be done in terms of a Bessel \
function. \
\>", "MathCaption",
  CellTags->{"S3.5.8", "8.7"}],

Cell[CellGroupData[{

Cell["Integrate[Cos[Sin[x]], {x, 0, 2Pi}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(2\ \[Pi]\ BesselJ[0, 1]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell["\<\
Here is an integral where the indefinite form can be found, but it \
is much more efficient to work out the definite form directly. \
\>", \
"MathCaption",
  CellTags->{"S3.5.8", "8.8"}],

Cell[CellGroupData[{

Cell["Integrate[Log[x] Exp[-x^2], {x, 0, Infinity}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(\(-\(1\/4\)\)\ \@\[Pi]\ \((EulerGamma + Log[4])\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell["\<\
Just because an integrand may contain special functions, it does \
not mean that the definite integral will necessarily be complicated. \
\>", \
"MathCaption",
  CellTags->{"S3.5.8", "8.9"}],

Cell[CellGroupData[{

Cell["Integrate[BesselK[0, x]^2, {x, 0, Infinity}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(\[Pi]\^2\/4\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell["Special functions nevertheless occur in this result. ", "MathCaption",
  CellTags->{"S3.5.8", "8.10"}],

Cell[CellGroupData[{

Cell["Integrate[BesselK[0, x] BesselJ[0, x], {x, 0, Infinity}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(Gamma[1\/4]\^2\/\(4\ \@\(2\ \[Pi]\)\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell["\<\
The integrand here is simple, but the definite integral is not. \
\
\>", "MathCaption",
  CellTags->{"S3.5.8", "8.11"}],

Cell[CellGroupData[{

Cell["Integrate[Sin[x^2] Exp[-x], {x, 0, Infinity}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(\(1\/\(2\ \@2\)\) \((\(-\@2\)\ HypergeometricPFQ[{1}, {3\/4, 
                5\/4}, \(-\(1\/64\)\)] + \@\[Pi]\ \((Cos[1\/4] + 
                Sin[1\/4])\))\)\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell["\<\
Even when you can find the indefinite form of an integral, you will \
often not get the correct answer for the definite integral if you just \
subtract the values of the limits at each end point. The problem is that \
within the domain of integration there may be singularities whose effects are \
ignored if you follow this procedure.   \
\>", "Text",
  CellTags->{"S3.5.8", "8.12"}],

Cell[TextData[{
  "Here is the indefinite integral of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.13"}],

Cell[CellGroupData[{

Cell["Integrate[1/x^2, x]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(\(-\(1\/x\)\)\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell["This subtracts the limits at each end point. ", "MathCaption",
  CellTags->{"S3.5.8", "8.14"}],

Cell[CellGroupData[{

Cell["Limit[%, x->2] - Limit[%, x->-2]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(\(-1\)\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[TextData[{
  "The true definite integral is divergent because of the double pole at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.15"}],

Cell[CellGroupData[{

Cell["Integrate[1/x^2, {x, -2, 2}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(\[Infinity]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell["\<\
Here is a more subtle example, involving branch cuts rather than \
poles. \
\>", "MathCaption",
  CellTags->{"S3.5.8", "8.16"}],

Cell[CellGroupData[{

Cell["Integrate[1/(1 + a Sin[x]), x]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(\(2\ ArcTan[\(a + Tan[x\/2]\)\/\@\(1 - a\^2\)]\)\/\@\(1 - a\^2\)\)], \
"Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell["Taking limits in the indefinite integral gives 0. ", "MathCaption",
  CellTags->{"S3.5.8", "8.17"}],

Cell[CellGroupData[{

Cell["Limit[%, x -> 2Pi] - Limit[%, x -> 0]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[TextData[{
  "The definite integral, however, gives the correct result which depends on \
",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.18"}],

Cell[CellGroupData[{

Cell["Integrate[1/(1 + a Sin[x]), {x, 0, 2Pi}]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(\(4\ \[Pi]\)\/\@\(4 - 4\ a\^2\)\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["PrincipalValue", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True]", "MR"],
              " "
            }]], Cell["the Cauchy principal value of a definite integral "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.8"],

Cell["Principal value integrals. ", "Caption",
  CellTags->"S3.5.8"],

Cell[TextData[{
  "Here is the indefinite integral of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.19"}],

Cell[CellGroupData[{

Cell["Integrate[1/x, x]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(Log[x]\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[TextData[{
  "Substituting in the limits ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(+2\)\)], "InlineFormula"],
  " yields a strange result involving ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["i",
            "TI"], "\[Pi]"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.20"}],

Cell[CellGroupData[{

Cell["Limit[%, x -> 2] - Limit[%, x -> -1]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(\(-\[ImaginaryI]\)\ \[Pi] + Log[2]\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell["The ordinary Riemann definite integral is divergent. ", "MathCaption",
  CellTags->{"S3.5.8", "8.21"}],

Cell[CellGroupData[{

Cell["Integrate[1/x, {x, -1, 2}]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(Integrate::"idiv" \(\(:\)\(\ \)\) 
      "Integral of \!\(1\/x\) does not converge on \!\({\(\(-1\)\), \
2}\)."\)], "Message",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(\[Integral]\_\(-1\)\%2\( 1\/x\) \[DifferentialD]x\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell["The Cauchy principal value, however, is finite. ", "MathCaption",
  CellTags->{"S3.5.8", "8.22"}],

Cell[CellGroupData[{

Cell["Integrate[1/x, {x, -1, 2}, PrincipalValue->True]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(Log[2]\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell["\<\
When parameters appear in an indefinite integral, it is essentially \
always possible to get results that are correct for almost all values of \
these parameters. But for definite integrals this is no longer the case. The \
most common problem is that a definite integral may converge only when the \
parameters that appear in it satisfy certain specific conditions. \
\>", \
"Text",
  CellTags->{"S3.5.8", "8.23"}],

Cell[TextData[{
  "This indefinite integral is correct for all ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "\[NotEqual]", "-", "1"}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.24"}],

Cell[CellGroupData[{

Cell["Integrate[x^n, x]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(x\^\(1 + n\)\/\(1 + n\)\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[TextData[{
  "For the definite integral, however, ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " must satisfy a condition in order for the integral to be convergent. "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.25"}],

Cell[CellGroupData[{

Cell["Integrate[x^n, {x, 0, 1}]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(If[Re[n] > \(-1\), 1\/\(1 + n\), 
      Integrate[x\^n, {x, 0, 1}, 
        Assumptions \[Rule] Re[n] \[LessEqual] \(-1\)]]\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is replaced by 2, the condition is satisfied. "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.26"}],

Cell[CellGroupData[{

Cell["% /. n -> 2", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(1\/3\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["GenerateConditions", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["whether to generate explicit conditions "]},
          {Cell[TextData[{
              StyleBox["Assumptions", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["$Assumptions", "MR"],
              " "
            }]], Cell["what relations about parameters to assume "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S3.5.8"],

Cell[TextData[{
  "Options for ",
  StyleBox["Integrate", "MR"],
  ". "
}], "Caption",
  CellTags->"S3.5.8"],

Cell[TextData[{
  "With the assumption ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], ">", "2"}], TraditionalForm]], "InlineFormula"],
  ", the result is always ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{"1", "+", 
              StyleBox["n",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.27"}],

Cell[CellGroupData[{

Cell["Integrate[x^n, {x, 0, 1}, Assumptions -> (n > 2)]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(1\/\(1 + n\)\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[TextData[{
  "Even when a definite integral is convergent, the presence of singularities \
on the integration path can lead to discontinuous changes when the parameters \
vary. Sometimes a single formula containing functions like ",
  StyleBox["Sign", "MR"],
  " can be used to summarize the result. In other cases, however, an explicit \
",
  StyleBox["If", "MR"],
  " is more convenient. "
}], "Text",
  CellTags->{"S3.5.8", "8.28"}],

Cell[TextData[{
  "The ",
  StyleBox["If", "MR"],
  " here gives the condition for the integral to be convergent. "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.29"}],

Cell[CellGroupData[{

Cell["Integrate[Sin[a x]/x, {x, 0, Infinity}]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(If[a \[Element] Reals, 1\/2\ \[Pi]\ Sign[a], 
      Integrate[Sin[a\ x]\/x, {x, 0, \[Infinity]}, 
        Assumptions \[Rule] a \[NotElement] Reals]]\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[TextData[{
  "Here is the result assuming that ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is real. "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.30"}],

Cell[CellGroupData[{

Cell["\<\
Integrate[Sin[a x]/x, {x, 0, Infinity}, Assumptions -> Im[a] == \
0]\
\>", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(1\/2\ \[Pi]\ Sign[a]\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[TextData[{
  "The result is discontinuous as a function of ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". The discontinuity can be traced to the essential singularity of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "\[Infinity]"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.31"}],

Cell[CellGroupData[{

Cell["Plot[%, {a, -5, 5}]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.5.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 0.309017 0.187358 [
[.11905 .29652 -6 -9 ]
[.11905 .29652 6 0 ]
[.30952 .29652 -6 -9 ]
[.30952 .29652 6 0 ]
[.69048 .29652 -3 -9 ]
[.69048 .29652 3 0 ]
[.88095 .29652 -3 -9 ]
[.88095 .29652 3 0 ]
[.4875 .02798 -24 -4.5 ]
[.4875 .02798 0 4.5 ]
[.4875 .12166 -12 -4.5 ]
[.4875 .12166 0 4.5 ]
[.4875 .21534 -24 -4.5 ]
[.4875 .21534 0 4.5 ]
[.4875 .4027 -18 -4.5 ]
[.4875 .4027 0 4.5 ]
[.4875 .49638 -6 -4.5 ]
[.4875 .49638 0 4.5 ]
[.4875 .59005 -18 -4.5 ]
[.4875 .59005 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .30902 m
.11905 .31527 L
s
[(-4)] .11905 .29652 0 1 Mshowa
.30952 .30902 m
.30952 .31527 L
s
[(-2)] .30952 .29652 0 1 Mshowa
.69048 .30902 m
.69048 .31527 L
s
[(2)] .69048 .29652 0 1 Mshowa
.88095 .30902 m
.88095 .31527 L
s
[(4)] .88095 .29652 0 1 Mshowa
.125 Mabswid
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.07143 .30902 m
.07143 .31277 L
s
.02381 .30902 m
.02381 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.97619 .30902 m
.97619 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .02798 m
.50625 .02798 L
s
[(-1.5)] .4875 .02798 1 0 Mshowa
.5 .12166 m
.50625 .12166 L
s
[(-1)] .4875 .12166 1 0 Mshowa
.5 .21534 m
.50625 .21534 L
s
[(-0.5)] .4875 .21534 1 0 Mshowa
.5 .4027 m
.50625 .4027 L
s
[(0.5)] .4875 .4027 1 0 Mshowa
.5 .49638 m
.50625 .49638 L
s
[(1)] .4875 .49638 1 0 Mshowa
.5 .59005 m
.50625 .59005 L
s
[(1.5)] .4875 .59005 1 0 Mshowa
.125 Mabswid
.5 .04672 m
.50375 .04672 L
s
.5 .06545 m
.50375 .06545 L
s
.5 .08419 m
.50375 .08419 L
s
.5 .10292 m
.50375 .10292 L
s
.5 .14039 m
.50375 .14039 L
s
.5 .15913 m
.50375 .15913 L
s
.5 .17787 m
.50375 .17787 L
s
.5 .1966 m
.50375 .1966 L
s
.5 .23407 m
.50375 .23407 L
s
.5 .25281 m
.50375 .25281 L
s
.5 .27155 m
.50375 .27155 L
s
.5 .29028 m
.50375 .29028 L
s
.5 .32775 m
.50375 .32775 L
s
.5 .34649 m
.50375 .34649 L
s
.5 .36522 m
.50375 .36522 L
s
.5 .38396 m
.50375 .38396 L
s
.5 .42143 m
.50375 .42143 L
s
.5 .44017 m
.50375 .44017 L
s
.5 .4589 m
.50375 .4589 L
s
.5 .47764 m
.50375 .47764 L
s
.5 .51511 m
.50375 .51511 L
s
.5 .53385 m
.50375 .53385 L
s
.5 .55258 m
.50375 .55258 L
s
.5 .57132 m
.50375 .57132 L
s
.5 .00924 m
.50375 .00924 L
s
.5 .60879 m
.50375 .60879 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .01472 L
.10458 .01472 L
.14415 .01472 L
.18221 .01472 L
.22272 .01472 L
.26171 .01472 L
.30316 .01472 L
.34309 .01472 L
.3815 .01472 L
.42237 .01472 L
.46172 .01472 L
.48147 .01472 L
.49012 .01472 L
.49468 .01472 L
.49719 .01472 L
.49842 .01472 L
.49955 .01472 L
.50085 .60332 L
.50154 .60332 L
.50226 .60332 L
.50471 .60332 L
.5095 .60332 L
.51896 .60332 L
.53984 .60332 L
.57781 .60332 L
.61824 .60332 L
.65714 .60332 L
.6985 .60332 L
.73835 .60332 L
.77668 .60332 L
.81746 .60332 L
.85673 .60332 L
.89448 .60332 L
.93468 .60332 L
.97337 .60332 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.5.8"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[TextData[{
  "There is no convenient way to represent this answer in terms of ",
  StyleBox["Sign", "MR"],
  ", so ",
  StyleBox["Mathematica", "TI"],
  " generates an explicit ",
  StyleBox["If", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.32"}],

Cell[CellGroupData[{

Cell["\<\
Integrate[Sin[x] BesselJ[0, a x]/x, {x, 0, Infinity}, Assumptions \
-> Im[a] == 0]\
\>", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S3.5.8"],

Cell[BoxData[
    \(If[a < \(-1\) || 
        a > 1, \(a\ ArcSin[1\/a]\)\/Abs[a], \[Pi]\/2]\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S3.5.8"]
}, Open  ]],

Cell[TextData[{
  "Here is a plot of the resulting function of ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.8", "8.33"}],

Cell[CellGroupData[{

Cell["Plot[Evaluate[%], {a, -5, 5}]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S3.5.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 0.0147151 0.374717 [
[.11905 .00222 -6 -9 ]
[.11905 .00222 6 0 ]
[.30952 .00222 -6 -9 ]
[.30952 .00222 6 0 ]
[.69048 .00222 -3 -9 ]
[.69048 .00222 3 0 ]
[.88095 .00222 -3 -9 ]
[.88095 .00222 3 0 ]
[.4875 .10839 -24 -4.5 ]
[.4875 .10839 0 4.5 ]
[.4875 .20207 -18 -4.5 ]
[.4875 .20207 0 4.5 ]
[.4875 .29575 -24 -4.5 ]
[.4875 .29575 0 4.5 ]
[.4875 .38943 -6 -4.5 ]
[.4875 .38943 0 4.5 ]
[.4875 .48311 -24 -4.5 ]
[.4875 .48311 0 4.5 ]
[.4875 .57679 -18 -4.5 ]
[.4875 .57679 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .01472 m
.11905 .02097 L
s
[(-4)] .11905 .00222 0 1 Mshowa
.30952 .01472 m
.30952 .02097 L
s
[(-2)] .30952 .00222 0 1 Mshowa
.69048 .01472 m
.69048 .02097 L
s
[(2)] .69048 .00222 0 1 Mshowa
.88095 .01472 m
.88095 .02097 L
s
[(4)] .88095 .00222 0 1 Mshowa
.125 Mabswid
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.07143 .01472 m
.07143 .01847 L
s
.02381 .01472 m
.02381 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.97619 .01472 m
.97619 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .10839 m
.50625 .10839 L
s
[(0.25)] .4875 .10839 1 0 Mshowa
.5 .20207 m
.50625 .20207 L
s
[(0.5)] .4875 .20207 1 0 Mshowa
.5 .29575 m
.50625 .29575 L
s
[(0.75)] .4875 .29575 1 0 Mshowa
.5 .38943 m
.50625 .38943 L
s
[(1)] .4875 .38943 1 0 Mshowa
.5 .48311 m
.50625 .48311 L
s
[(1.25)] .4875 .48311 1 0 Mshowa
.5 .57679 m
.50625 .57679 L
s
[(1.5)] .4875 .57679 1 0 Mshowa
.125 Mabswid
.5 .03345 m
.50375 .03345 L
s
.5 .05219 m
.50375 .05219 L
s
.5 .07092 m
.50375 .07092 L
s
.5 .08966 m
.50375 .08966 L
s
.5 .12713 m
.50375 .12713 L
s
.5 .14587 m
.50375 .14587 L
s
.5 .1646 m
.50375 .1646 L
s
.5 .18334 m
.50375 .18334 L
s
.5 .22081 m
.50375 .22081 L
s
.5 .23955 m
.50375 .23955 L
s
.5 .25828 m
.50375 .25828 L
s
.5 .27702 m
.50375 .27702 L
s
.5 .31449 m
.50375 .31449 L
s
.5 .33322 m
.50375 .33322 L
s
.5 .35196 m
.50375 .35196 L
s
.5 .3707 m
.50375 .3707 L
s
.5 .40817 m
.50375 .40817 L
s
.5 .4269 m
.50375 .4269 L
s
.5 .44564 m
.50375 .44564 L
s
.5 .46438 m
.50375 .46438 L
s
.5 .50185 m
.50375 .50185 L
s
.5 .52058 m
.50375 .52058 L
s
.5 .53932 m
.50375 .53932 L
s
.5 .55805 m
.50375 .55805 L
s
.5 .59553 m
.50375 .59553 L
s
.5 .61426 m
.50375 .61426 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .09017 m
.06244 .09693 L
.10458 .10586 L
.14415 .11624 L
.18221 .12877 L
.22272 .14609 L
.26171 .16878 L
.28302 .18498 L
.30316 .20395 L
.32313 .22778 L
.34157 .25638 L
.36029 .29579 L
.37094 .32575 L
.38092 .36205 L
.38588 .38469 L
.3913 .41485 L
.39378 .4314 L
.39642 .45188 L
.40117 .50195 L
.40357 .54435 L
.40483 .60332 L
.40547 .60332 L
.40617 .60332 L
.40862 .60332 L
.41088 .60332 L
.41969 .60332 L
.46012 .60332 L
.49902 .60332 L
.54039 .60332 L
.56108 .60332 L
.57018 .60332 L
.58023 .60332 L
.58484 .60332 L
.58982 .60332 L
.5921 .60332 L
.59335 .60332 L
.59451 .60332 L
.59551 .57526 L
.59657 .54107 L
.59775 .51826 L
.59882 .50217 L
.60135 .4725 L
.60369 .45098 L
.60897 .41315 L
.61856 .36425 L
.62825 .32832 L
.63732 .30189 L
.65796 .25721 L
.67825 .22593 L
.69679 .20401 L
Mistroke
.71742 .18462 L
.73655 .16999 L
.77479 .14734 L
.81398 .1302 L
.85561 .11631 L
.89573 .10579 L
.93433 .09755 L
.97539 .0903 L
.97619 .09017 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.5.8"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S3.5.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5.9 Integrals over Regions", "Subsection",
  CellTags->{"S3.5.9", "9.1"}],

Cell["This does an integral over the unit circle. ", "MathCaption",
  CellTags->{"S3.5.9", "9.2"}],

Cell[CellGroupData[{

Cell["Integrate[If[x^2 + y^2 < 1, 1, 0], {x, -1, 1}, {y, -1, 1}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.9"],

Cell[BoxData[
    \(\[Pi]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.5.9"]
}, Open  ]],

Cell["Here is an equivalent form. ", "MathCaption",
  CellTags->{"S3.5.9", "9.3"}],

Cell[CellGroupData[{

Cell["Integrate[Boole[x^2 + y^2 < 1], {x, -1, 1}, {y, -1, 1}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.9"],

Cell[BoxData[
    \(\[Pi]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.5.9"]
}, Open  ]],

Cell["\<\
Even though an integral may be straightforward over a simple \
rectangular region, it can be significantly more complicated even over a \
circular region. \
\>", "Text",
  CellTags->{"S3.5.9", "9.4"}],

Cell["This gives a Bessel function. ", "MathCaption",
  CellTags->{"S3.5.9", "9.5"}],

Cell[CellGroupData[{

Cell["\<\
Integrate[Exp[x] Boole[x^2 + y^2 < 1], {x, -1, 1}, {y, -1, \
1}]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.9"],

Cell[BoxData[
    \(2\ \[Pi]\ BesselI[1, 1]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              " ",
              StyleBox["Boole[", "MR"],
              StyleBox["cond", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "integrate ",
              StyleBox["f", "TI"],
              " over the region where ",
              StyleBox["cond", "TI"],
              " is ",
              StyleBox["True", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.9"],

Cell["Integrals over regions. ", "Caption",
  CellTags->"S3.5.9"],

Cell["\<\
Particularly if there are parameters inside the conditions that \
define regions, the results for integrals over regions may break into several \
cases. \
\>", "Text",
  CellTags->{"S3.5.9", "9.6"}],

Cell[TextData[{
  "This gives a piecewise function of ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.9", "9.7"}],

Cell[CellGroupData[{

Cell["Integrate[Boole[a x < y], {x, 0, 1}, {y, 0, 1}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.9"],

Cell[BoxData[
    RowBox[{"\[Piecewise]", GridBox[{
          {"1", \(a \[LessEqual] 0\)},
          {\(\(2 - a\)\/2\), \(0 < a \[LessEqual] 1\)},
          {\(1\/\(2\ a\)\), 
            TagBox["True",
              "PiecewiseDefault",
              AutoDelete->False,
              DeletionWarning->True]}
          },
        ColumnSpacings->1.2,
        ColumnAlignments->{Left}]}]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.9"]
}, Open  ]],

Cell["\<\
With two parameters even this breaks into quite a few cases. \
\>", \
"MathCaption",
  CellTags->{"S3.5.9", "9.8"}],

Cell[CellGroupData[{

Cell["Integrate[Boole[a x < b], {x, 0, 1}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.9"],

Cell[BoxData[
    RowBox[{"\[Piecewise]", GridBox[{
          {
            "1", \(\((a > 0 && 
                  a - b \[LessEqual] 0)\) || \((a \[LessEqual] 0 && 
                  b > 0)\)\)},
          {\(\(a - b\)\/a\), \(a \[LessEqual] 0 && a - b < 0 && 
              b \[LessEqual] 0\)},
          {\(b\/a\), \(a > 0 && b > 0 && a - b > 0\)}
          },
        ColumnSpacings->1.2,
        ColumnAlignments->{Left}]}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.5.9"]
}, Open  ]],

Cell["This involves intersecting a circle with a square. ", "MathCaption",
  CellTags->{"S3.5.9", "9.9"}],

Cell[CellGroupData[{

Cell["Integrate[Boole[x^2 + y^2 < a], {x, 0, 1}, {y, 0, 1}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.9"],

Cell[BoxData[
    RowBox[{"\[Piecewise]", GridBox[{
          {"1", \(a \[GreaterEqual] 2\)},
          {\(\(a\ \[Pi]\)\/4\), \(0 < a \[LessEqual] 1\)},
          {\(1\/2\ \((2\ \@\(\(-1\) + a\) + a\ ArcCot[\@\(\(-1\) + a\)] - 
                  a\ ArcTan[\@\(\(-1\) + a\)])\)\), \(1 < a < 2\)}
          },
        ColumnSpacings->1.2,
        ColumnAlignments->{Left}]}]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.5.9"]
}, Open  ]],

Cell["The region can have an infinite number of components. ", "MathCaption",
  CellTags->{"S3.5.9", "9.10"}],

Cell[CellGroupData[{

Cell["Integrate[Boole[Sin[x] > 1/2] Exp[-x], {x, 0, Infinity}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.5.9"],

Cell[BoxData[
    \(\[ExponentialE]\^\(\(7\ \[Pi]\)/6\)\/\(1 + \[ExponentialE]\^\(\(2\ \
\[Pi]\)/3\) + \[ExponentialE]\^\(\(4\ \[Pi]\)/3\)\)\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.5.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Integrate", "MR"],
  " effectively does Lebesgue integration. "
}], "MathCaption",
  CellTags->{"S3.5.9", "9.11"}],

Cell[CellGroupData[{

Cell["Integrate[Boole[Element[x, Rationals]], {x, 0, 1}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.5.9"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.5.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5.10 Manipulating Integrals in Symbolic Form", "Subsection",
  CellTags->{"S3.5.10", "10.1"}],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " cannot give you an explicit result for an integral, it leaves the \
integral in a symbolic form. It is often useful to manipulate this symbolic \
form.  "
}], "Text",
  CellTags->{"S3.5.10", "10.2"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " cannot give an explicit result for this integral, so it leaves the \
integral in symbolic form. "
}], "MathCaption",
  CellTags->{"S3.5.10", "10.3"}],

Cell[CellGroupData[{

Cell["Integrate[x^2 f[x], x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.10"],

Cell[BoxData[
    \(\[Integral]\(x\^2\ f[x]\) \[DifferentialD]x\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.5.10"]
}, Open  ]],

Cell["\<\
Differentiating the symbolic form gives the integrand back again. \
\
\>", "MathCaption",
  CellTags->{"S3.5.10", "10.4"}],

Cell[CellGroupData[{

Cell["D[%, x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.10"],

Cell[BoxData[
    \(x\^2\ f[x]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.5.10"]
}, Open  ]],

Cell["\<\
Here is a definite integral which cannot be done explicitly. \
\>", \
"MathCaption",
  CellTags->{"S3.5.10", "10.5"}],

Cell[CellGroupData[{

Cell["Integrate[f[x], {x, a[x], b[x]}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.10"],

Cell[BoxData[
    \(\[Integral]\_\(a[x]\)\%\(b[x]\)f[x] \[DifferentialD]x\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.10"]
}, Open  ]],

Cell["This gives the derivative of the definite integral. ", "MathCaption",
  CellTags->{"S3.5.10", "10.6"}],

Cell[CellGroupData[{

Cell["D[%, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.10"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(-f[a[x]]\), " ", 
        RowBox[{
          SuperscriptBox["a", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{\(f[b[x]]\), " ", 
        RowBox[{
          SuperscriptBox["b", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.10"]
}, Open  ]],

Cell[TextData[{
  "Here is a definite integral with end points that do not explicitly depend \
on\[NonBreakingSpace]",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.10", "10.7"}],

Cell[CellGroupData[{

Cell["defint = Integrate[f[x], {x, a, b}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.10"],

Cell[BoxData[
    \(\[Integral]\_a\%b f[x] \[DifferentialD]x\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.5.10"]
}, Open  ]],

Cell[TextData[{
  "The partial derivative of this with respect to ",
  StyleBox["u", "MR"],
  " is zero. "
}], "MathCaption",
  CellTags->{"S3.5.10", "10.8"}],

Cell[CellGroupData[{

Cell["D[defint, u]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.10"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.5.10"]
}, Open  ]],

Cell["\<\
There is a non\[Hyphen]trivial total derivative, however. \
\>", \
"MathCaption",
  CellTags->{"S3.5.10", "10.9"}],

Cell[CellGroupData[{

Cell["Dt[defint, u]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.5.10"],

Cell[BoxData[
    \(\(-Dt[a, u]\)\ f[a] + Dt[b, u]\ f[b]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.5.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5.11 Differential Equations", "Subsection",
  CellTags->{"S3.5.11", "11.1"}],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["1.5.9",
    ButtonData:>{"1.5.9", "9.1"},
    ButtonStyle->"MainBookLink"],
  ", you can use the ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["DSolve", "MR"],
  " to find symbolic solutions to ordinary and partial differential \
equations. "
}], "Text",
  CellTags->{"S3.5.11", "11.2"}],

Cell[TextData[{
  "Solving a differential equation consists essentially in finding the form \
of an unknown function. In ",
  StyleBox["Mathematica", "TI"],
  ", unknown functions are represented by expressions like ",
  StyleBox["y[x]", "MR"],
  ". The derivatives of such functions are represented by ",
  StyleBox["y'[x]", "MR"],
  ", ",
  StyleBox["y''[x]", "MR"],
  " and so on. "
}], "Text",
  CellTags->{"S3.5.11", "11.3"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["DSolve", "MR"],
  " returns as its result a list of rules for functions. There is a question \
of how these functions are represented. If you ask ",
  StyleBox["DSolve", "MR"],
  " to solve for ",
  StyleBox["y[x]", "MR"],
  ", then ",
  StyleBox["DSolve", "MR"],
  " will indeed return a rule for ",
  StyleBox["y[x]", "MR"],
  ". In some cases, this rule may be all you need. But this rule, on its own, \
does not give values for ",
  StyleBox["y'[x]", "MR"],
  " or even ",
  StyleBox["y[0]", "MR"],
  ". In many cases, therefore, it is better to ask ",
  StyleBox["DSolve", "MR"],
  " to solve not for ",
  StyleBox["y[x]", "MR"],
  ", but instead for ",
  StyleBox["y", "MR"],
  " itself. In this case, what ",
  StyleBox["DSolve", "MR"],
  " will return is a rule which gives ",
  StyleBox["y", "MR"],
  " as a pure function, in the sense discussed in Section ",
  ButtonBox["2.2.5",
    ButtonData:>{"2.2.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S3.5.11", "11.4"}],

Cell[TextData[{
  "If you ask ",
  StyleBox["DSolve", "MR"],
  " to solve for ",
  StyleBox["y[x]", "MR"],
  ", it will give a rule specifically for ",
  StyleBox["y[x]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.11", "11.5"}],

Cell[CellGroupData[{

Cell["DSolve[y'[x] + y[x] == 1, y[x], x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x] \[Rule] 1 + \[ExponentialE]\^\(-x\)\ C[1]}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[TextData[{
  "The rule applies only to ",
  StyleBox["y[x]", "MR"],
  " itself, and not, for example, to objects like ",
  StyleBox["y[0]", "MR"],
  " or ",
  StyleBox["y'[x]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.11", "11.6"}],

Cell[CellGroupData[{

Cell["y[x] + 2y'[x] + y[0] /. %", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
      "1", "+", \(\[ExponentialE]\^\(-x\)\ C[1]\), "+", \(y[0]\), "+", 
        RowBox[{"2", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}]}], "}"}]], "Output",\

  CellLabel->"Out[2]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[TextData[{
  "If you ask ",
  StyleBox["DSolve", "MR"],
  " to solve for ",
  StyleBox["y", "MR"],
  ", it gives a rule for the object ",
  StyleBox["y", "MR"],
  " on its own as a pure function. "
}], "MathCaption",
  CellTags->{"S3.5.11", "11.7"}],

Cell[CellGroupData[{

Cell["DSolve[y'[x] + y[x] == 1, y, x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 1 + \[ExponentialE]\^\(-x\)\ C[1]]}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[TextData[{
  "Now the rule applies to all occurrences of ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.11", "11.8"}],

Cell[CellGroupData[{

Cell["y[x] + 2y'[x] + y[0] /. %", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({2 + C[1] - \[ExponentialE]\^\(-x\)\ C[1]}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[TextData[{
  "Substituting the solution into the original equation yields ",
  StyleBox["True", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.11", "11.9"}],

Cell[CellGroupData[{

Cell["y'[x] + y[x] == 1 /. %%", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({True}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DSolve[", "MR"],
              StyleBox["eqn", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve a differential equation for ",
              StyleBox["y", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["DSolve[", "MR"],
              StyleBox["eqn", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve a differential equation for the function ",
              StyleBox["y", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.11"],

Cell["\<\
Getting solutions to differential equations in different forms. \
\
\>", "Caption",
  CellTags->"S3.5.11"],

Cell[TextData[{
  "In standard mathematical notation, one typically represents solutions to \
differential equations by explicitly introducing \[OpenCurlyDoubleQuote]dummy \
variables\[CloseCurlyDoubleQuote] to represent the arguments of the functions \
that appear. If all you need is a symbolic form for the solution, then \
introducing such dummy variables may be convenient. However, if you actually \
intend to use the solution in a variety of other computations, then you will \
usually find it better to get the solution in pure\[Hyphen]function form, \
without dummy variables. Notice that this form, while easy to represent in ",
  StyleBox["Mathematica", "TI"],
  ", has no direct analog in standard mathematical notation. "
}], "Text",
  CellTags->{"S3.5.11", "11.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DSolve[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["solve a list of differential equations "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.11"],

Cell["Solving simultaneous differential equations. ", "Caption",
  CellTags->"S3.5.11"],

Cell["This solves two simultaneous differential equations. ", "MathCaption",
  CellTags->{"S3.5.11", "11.11"}],

Cell[CellGroupData[{

Cell["DSolve[{y[x] == -z'[x], z[x] == -y'[x]}, {y, z}, x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{z \[Rule] 
          Function[{x}, 
            1\/2\ \[ExponentialE]\^\(-x\)\ \((1 + \[ExponentialE]\^\(2\ \
x\))\)\ C[1] - 
              1\/2\ \[ExponentialE]\^\(-x\)\ \((\(-1\) + \[ExponentialE]\^\(2\
\ x\))\)\ C[2]], 
        y \[Rule] 
          Function[{x}, \(-\(1\/2\)\)\ \[ExponentialE]\^\(-x\)\ \((\(-1\) + \
\[ExponentialE]\^\(2\ x\))\)\ C[1] + 
              1\/2\ \[ExponentialE]\^\(-x\)\ \((1 + \[ExponentialE]\^\(2\ \
x\))\)\ C[2]]}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " returns two distinct solutions for ",
  StyleBox["y", "MR"],
  " in this case. "
}], "MathCaption",
  CellTags->{"S3.5.11", "11.12"}],

Cell[CellGroupData[{

Cell["DSolve[y[x] y'[x] == 1, y, x]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y \[Rule] Function[{x}, \(-\@2\)\ \@\(x + C[1]\)]}, {y \[Rule] 
          Function[{x}, \@2\ \@\(x + C[1]\)]}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[TextData[{
  "You can add constraints and boundary conditions for differential equations \
by explicitly giving additional equations such as ",
  StyleBox["y[0]", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["0", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.5.11", "11.13"}],

Cell[TextData[{
  "This asks for a solution which satisfies the condition ",
  StyleBox["y[0]", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["1", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.11", "11.14"}],

Cell[CellGroupData[{

Cell["DSolve[{y'[x] == a y[x], y[0] == 1}, y[x], x]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x] \[Rule] \[ExponentialE]\^\(a\ x\)}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[TextData[{
  "If you ask ",
  StyleBox["Mathematica", "TI"],
  " to solve a set of differential equations and you do not give any \
constraints or boundary conditions, then ",
  StyleBox["Mathematica", "TI"],
  " will try to find a ",
  StyleBox["general solution", "TI"],
  " to your equations. This general solution will involve various \
undetermined constants. One new constant is introduced for each order of \
derivative in each equation you give. "
}], "Text",
  CellTags->{"S3.5.11", "11.15"}],

Cell[TextData[{
  "The default is that these constants are named ",
  StyleBox["C[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ", where the index ",
  StyleBox["n", "TI"],
  " starts at ",
  StyleBox["1", "MR"],
  " for each invocation of ",
  StyleBox["DSolve", "MR"],
  ". You can override this choice, by explicitly giving a setting for the \
option ",
  StyleBox["GeneratedParameters", "MR"],
  ". Any function you give is applied to each successive index value ",
  StyleBox["n", "TI"],
  " to get the constants to use for each invocation of ",
  StyleBox["DSolve", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.5.11", "11.16"}],

Cell["\<\
The general solution to this fourth\[Hyphen]order equation involves \
four undetermined constants. \
\>", "MathCaption",
  CellTags->{"S3.5.11", "11.17"}],

Cell[CellGroupData[{

Cell["DSolve[y''''[x] == y[x], y[x], x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^x\ C[1] + \[ExponentialE]\^\(-x\)\ C[
                3] + C[2]\ Cos[x] + C[4]\ Sin[x]}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["\<\
Each independent initial or boundary condition you give reduces the \
number of undetermined constants by one. \
\>", "MathCaption",
  CellTags->{"S3.5.11", "11.18"}],

Cell[CellGroupData[{

Cell["DSolve[{y''''[x] == y[x], y[0] == y'[0] == 0}, y[x], x]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^\(-x\)\ \((C[
                  3] + \[ExponentialE]\^\(2\ x\)\ C[
                    3] - \[ExponentialE]\^\(2\ x\)\ C[4] - 
                2\ \[ExponentialE]\^x\ C[3]\ Cos[x] + \[ExponentialE]\^x\ C[
                    4]\ Cos[x] + \[ExponentialE]\^x\ C[4]\ Sin[
                    x])\)}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["\<\
You should realize that finding exact formulas for the solutions to \
differential equations is a difficult matter. In fact, there are only fairly \
few kinds of equations for which such formulas can be found, at least in \
terms of standard mathematical functions. \
\>", "Text",
  CellTags->{"S3.5.11", "11.19"}],

Cell["\<\
The most widely investigated differential equations are linear \
ones, in which the functions you are solving for, as well as their \
derivatives, appear only linearly. \
\>", "Text",
  CellTags->{"S3.5.11", "11.20"}],

Cell["\<\
This is a homogeneous first\[Hyphen]order linear differential \
equation, and its solution is quite simple. \
\>", "MathCaption",
  CellTags->{"S3.5.11", "11.21"}],

Cell[CellGroupData[{

Cell["DSolve[y'[x] - x y[x] == 0, y[x], x]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x] \[Rule] \[ExponentialE]\^\(x\^2\/2\)\ C[1]}}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["\<\
Making the equation inhomogeneous leads to a significantly more \
complicated solution. \
\>", "MathCaption",
  CellTags->{"S3.5.11", "11.22"}],

Cell[CellGroupData[{

Cell["DSolve[y'[x] - x y[x] == 1, y[x], x]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^\(x\^2\/2\)\ C[
                1] + \[ExponentialE]\^\(x\^2\/2\)\ \@\(\[Pi]\/2\)\ Erf[
                x\/\@2]}}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["\<\
If you have only a single linear differential equation, and it \
involves only a first derivative of the function you are solving for, then it \
turns out that the solution can always be found just by doing integrals.   \
\
\>", "Text",
  CellTags->{"S3.5.11", "11.23"}],

Cell[TextData[{
  "But as soon as you have more than one differential equation, or more than \
a first\[Hyphen]order derivative, this is no longer true. However, some \
simple second\[Hyphen]order linear differential equations can nevertheless be \
solved using various special functions from Section ",
  ButtonBox["3.2.11",
    ButtonData:>{"3.2.11", "11.1"},
    ButtonStyle->"MainBookLink"],
  ". Indeed, historically many of these special functions were first \
introduced specifically in order to represent the solutions to such \
equations.  "
}], "Text",
  CellTags->{"S3.5.11", "11.24"}],

Cell["\<\
This is Airy's equation, which is solved in terms of Airy \
functions.  \
\>", "MathCaption",
  CellTags->{"S3.5.11", "11.25"}],

Cell[CellGroupData[{

Cell["DSolve[y''[x] - x y[x] == 0, y[x], x]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x] \[Rule] AiryAi[x]\ C[1] + AiryBi[x]\ C[2]}}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["This equation comes out in terms of Bessel functions. ", "MathCaption",
  CellTags->{"S3.5.11", "11.26"}],

Cell[CellGroupData[{

Cell["DSolve[y''[x] - Exp[x] y[x] == 0, y[x], x]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x] \[Rule] 
          BesselI[0, 2\ \@\[ExponentialE]\^x]\ C[1] + 
            2\ BesselK[0, 2\ \@\[ExponentialE]\^x]\ C[2]}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["This requires Mathieu functions. ", "MathCaption",
  CellTags->{"S3.5.11", "11.27"}],

Cell[CellGroupData[{

Cell["DSolve[y''[x] + Cos[x] y[x] == 0, y, x]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 
            C[1]\ MathieuC[0, \(-2\), x\/2] + 
              C[2]\ MathieuS[0, \(-2\), x\/2]]}}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["And this Legendre functions. ", "MathCaption",
  CellTags->{"S3.5.11", "11.28"}],

Cell[CellGroupData[{

Cell["DSolve[y''[x] - Cot[x]^2 y[x] == 0, y[x], x]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x] \[Rule] 
          C[1]\ \((\(-1\) + Cos[x]\^2)\)\^\(1/4\)\ LegendreP[1\/2, \@5\/2, 
                Cos[x]] + 
            C[2]\ \((\(-1\) + Cos[x]\^2)\)\^\(1/4\)\ LegendreQ[1\/2, \@5\/2, 
                Cos[x]]}}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["\<\
Occasionally second\[Hyphen]order linear equations can be solved \
using only elementary functions. \
\>", "MathCaption",
  CellTags->{"S3.5.11", "11.29"}],

Cell[CellGroupData[{

Cell["DSolve[x^2 y''[x] + y[x] == 0, y[x], x]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \@x\ C[1]\ Cos[1\/2\ \@3\ Log[x]] + \@x\ C[2]\ Sin[
                1\/2\ \@3\ Log[x]]}}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[TextData[{
  "Beyond second order, the kinds of functions needed to solve even fairly \
simple linear differential equations become extremely complicated. At third \
order, the generalized Meijer G function ",
  StyleBox["MeijerG", "MR"],
  " can sometimes be used, but at fourth order and beyond absolutely no \
standard mathematical functions are typically adequate, except in very \
special cases. "
}], "Text",
  CellTags->{"S3.5.11", "11.30"}],

Cell["\<\
Here is a third\[Hyphen]order linear differential equation which \
can be solved in terms of generalized hypergeometric functions. \
\>", \
"MathCaption",
  CellTags->{"S3.5.11", "11.31"}],

Cell[CellGroupData[{

Cell["DSolve[y'''[x] + x y[x] == 0, y[x], x]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x] \[Rule] 
          C[1]\ HypergeometricPFQ[{}, {1\/2, 
                  3\/4}, \(-\(x\^4\/64\)\)] + \(x\ C[2]\ \
HypergeometricPFQ[{}, {3\/4, 5\/4}, \(-\(x\^4\/64\)\)]\)\/\(2\ \@2\) + 
            1\/8\ x\^2\ C[
                3]\ HypergeometricPFQ[{}, {5\/4, 
                  3\/2}, \(-\(x\^4\/64\)\)]}}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["This requires more general Meijer G functions. ", "MathCaption",
  CellTags->{"S3.5.11", "11.32"}],

Cell[CellGroupData[{

Cell["DSolve[y'''[x] + Exp[x] y[x] == 0, y[x], x]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x] \[Rule] 
          C[1]\ HypergeometricPFQ[{}, {1, 1}, \(-\[ExponentialE]\^x\)] + 
            C[2]\ MeijerG[{{}, {}}, {{0, 0}, {0}}, \(-\[ExponentialE]\^x\)] + 
            C[3]\ MeijerG[{{}, {}}, {{0, 0, 
                    0}, {}}, \[ExponentialE]\^x]}}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[TextData[{
  "For nonlinear differential equations, only rather special cases can \
usually ever be solved in terms of standard mathematical functions. \
Nevertheless, ",
  StyleBox["DSolve", "MR"],
  " includes fairly general procedures which allow it to handle almost all \
nonlinear differential equations whose solutions are found in standard \
reference books. "
}], "Text",
  CellTags->{"S3.5.11", "11.33"}],

Cell[TextData[{
  "First\[Hyphen]order nonlinear differential equations in which ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " does not appear on its own are fairly easy to solve. "
}], "MathCaption",
  CellTags->{"S3.5.11", "11.34"}],

Cell[CellGroupData[{

Cell["DSolve[y'[x] - y[x]^2 == 0, y[x], x]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x] \[Rule] 1\/\(\(-x\) - C[1]\)}}\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["\<\
This Riccati equation already gives a significantly more \
complicated solution.  \
\>", "MathCaption",
  CellTags->{"S3.5.11", "11.35"}],

Cell[CellGroupData[{

Cell["DSolve[y'[x] - y[x]^2 == x, y[x], x] // FullSimplify", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \(\@x\ \((\(-BesselJ[\(-\(2\/3\)\), \(2\ \
x\^\(3/2\)\)\/3]\) + BesselJ[2\/3, \(2\ x\^\(3/2\)\)\/3]\ \
C[1])\)\)\/\(BesselJ[1\/3, \(2\ x\^\(3/2\)\)\/3] + BesselJ[\(-\(1\/3\)\), \(2\
\ x\^\(3/2\)\)\/3]\ C[1]\)}}\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["\<\
This Bernoulli equation, however, has a fairly simple solution.  \
\
\>", "MathCaption",
  CellTags->{"S3.5.11", "11.36"}],

Cell[CellGroupData[{

Cell["DSolve[y'[x] - x y[x]^2 - y[x] == 0, y[x], x]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \(-\(\[ExponentialE]\^x\/\(\(-\[ExponentialE]\^x\) + \
\[ExponentialE]\^x\ x - C[1]\)\)\)}}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[TextData[{
  "An ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " order Bernoulli equation typically has ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "-", "1"}], TraditionalForm]], "InlineFormula"],
  " distinct solutions. "
}], "MathCaption",
  CellTags->{"S3.5.11", "11.37"}],

Cell[CellGroupData[{

Cell["DSolve[y'[x] - x y[x]^3 + y[x] == 0, y[x], x]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \(-\(\@2\/\@\(1 + 2\ x + 2\ \[ExponentialE]\^\(2\ x\)\ \
C[1]\)\)\)}, {y[
            x] \[Rule] \@2\/\@\(1 + 2\ x + 2\ \[ExponentialE]\^\(2\ x\)\ C[1]\
\)}}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["This Abel equation can be solved, but only implicitly.  ", "MathCaption",
  CellTags->{"S3.5.11", "11.38"}],

Cell[CellGroupData[{

Cell["DSolve[y'[x] + x y[x]^3 + y[x]^2 == 0, y[x], x]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \(Solve::"tdep" \(\(:\)\(\ \)\) 
      "The equations appear to involve the variables to be solved for in an \
essentially non-algebraic way."\)], "Message",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \(Solve[
      1\/2\ \((\(2\ ArcTanh[\(\(-1\) - 2\ x\ y[x]\)\/\@5]\)\/\@5 + 
              Log[\(\(-1\) - x\ y[x]\ \((\(-1\) - x\ y[x])\)\)\/\(x\^2\ \
y[x]\^2\)])\) \[Equal] C[1] - Log[x], y[x]]\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[TextData[{
  "In practical applications, it is quite often convenient to set up \
differential equations that involve piecewise functions. You can use ",
  StyleBox["DSolve", "MR"],
  " to find symbolic solutions to such equations. "
}], "Text",
  CellTags->{"S3.5.11", "11.39"}],

Cell["This equation involves a piecewise forcing function. ", "MathCaption",
  CellTags->{"S3.5.11", "11.40"}],

Cell[CellGroupData[{

Cell["DSolve[y'[x] - y[x] == UnitStep[x], y[x], x]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^x\ C[
                1] + \[ExponentialE]\^x\ \((1 - \[ExponentialE]\^\(-x\))\)\ \
UnitStep[x]}}\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["Here the solution is explicitly broken into three cases. ", \
"MathCaption",
  CellTags->{"S3.5.11", "11.41"}],

Cell[CellGroupData[{

Cell["DSolve[y'[x] + Clip[x] y[x] == 0, y[x], x]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{\(y[x]\), "\[Rule]", 
          RowBox[{
            SuperscriptBox["\[ExponentialE]", 
              RowBox[{"\[Piecewise]", GridBox[{
                    {"x", \(x \[LessEqual] \(-1\)\)},
                    {\(\(-\(1\/2\)\) - x\^2\/2\), \(\(-1\) < x \[LessEqual] 
                        1\)},
                    {\(-x\), 
                      TagBox["True",
                        "PiecewiseDefault",
                        AutoDelete->False,
                        DeletionWarning->True]}
                    },
                  ColumnSpacings->1.2,
                  ColumnAlignments->{Left}]}]], " ", \(C[1]\)}]}], "}"}], 
      "}"}]], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[TextData[{
  "Beyond ordinary differential equations, one can consider ",
  StyleBox["differential\[Hyphen]algebraic equations", "TI"],
  " that involve a mixture of differential and algebraic equations.   "
}], "Text",
  CellTags->{"S3.5.11", "11.42"}],

Cell["\<\
This solves a differential\[Hyphen]algebraic equation. \
\>", \
"MathCaption",
  CellTags->{"S3.5.11", "11.43"}],

Cell[CellGroupData[{

Cell["\<\
DSolve[{y'[x] + 3z'[x] == 4 y[x] + 1/x, y[x] + z[x] == 1}, {y[x], \
z[x]}, x]\
\>", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x] \[Rule] 
          3\/2 + 1\/18\ \((\(-\[ExponentialE]\^\(\(-2\)\ x\)\)\ C[1] - 
                  9\ \[ExponentialE]\^\(\(-2\)\ x\)\ \((3\ \
\[ExponentialE]\^\(2\ x\) + ExpIntegralEi[2\ x])\))\), 
        z[x] \[Rule] \(-\(1\/2\)\) + 
            1\/18\ \((\[ExponentialE]\^\(\(-2\)\ x\)\ C[1] + 
                  9\ \[ExponentialE]\^\(\(-2\)\ x\)\ \((3\ \
\[ExponentialE]\^\(2\ x\) + ExpIntegralEi[2\ x])\))\)}}\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DSolve[", "MR"],
              StyleBox["eqn", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["],", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "solve a partial differential equation for ",
              StyleBox["y", "TI"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["DSolve[", "MR"],
              StyleBox["eqn", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve a partial differential equation for the function ",
              StyleBox["y", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.11"],

Cell["Solving partial differential equations. ", "Caption",
  CellTags->"S3.5.11"],

Cell[TextData[{
  StyleBox["DSolve", "MR"],
  " is set up to handle not only ",
  StyleBox["ordinary differential equations", "TI"],
  " in which just a single independent variable appears, but also ",
  StyleBox["partial differential equations", "TI"],
  " in which two or more independent variables appear. "
}], "Text",
  CellTags->{"S3.5.11", "11.44"}],

Cell["\<\
This finds the general solution to a simple partial differential \
equation with two independent variables. \
\>", "MathCaption",
  CellTags->{"S3.5.11", "11.45"}],

Cell[CellGroupData[{

Cell["\<\
DSolve[D[y[x1, x2], x1] + D[y[x1, x2], x2] == 1/(x1 x2), y[x1, x2], \
{x1, x2}]\
\>", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x1, 
            x2] \[Rule] \(\(-Log[x1]\) + Log[x2] + x1\ \(C[1]\)[\(-x1\) + x2] \
- x2\ \(C[1]\)[\(-x1\) + x2]\)\/\(x1 - x2\)}}\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["Here is the result represented as a pure function. ", "MathCaption",
  CellTags->{"S3.5.11", "11.46"}],

Cell[CellGroupData[{

Cell["\<\
DSolve[D[y[x1, x2], x1] + D[y[x1, x2], x2] == 1/(x1 x2), y, {x1, \
x2}]\
\>", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x1, 
              x2}, \(\(-Log[x1]\) + Log[x2] + x1\ \(C[1]\)[\(-x1\) + x2] - x2\
\ \(C[1]\)[\(-x1\) + x2]\)\/\(x1 - x2\)]}}\)], "Output",
  CellLabel->"Out[29]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell[TextData[{
  "The basic mathematics of partial differential equations is considerably \
more complicated than that of ordinary differential equations. One feature is \
that whereas the general solution to an ordinary differential equation \
involves only arbitrary ",
  StyleBox["constants", "TI"],
  ", the general solution to a partial differential equation, if it can be \
found at all, must involve arbitrary ",
  StyleBox["functions", "TI"],
  ". Indeed, with ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  " independent variables, arbitrary functions of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "-", "1"}], TraditionalForm]], "InlineFormula"],
  " arguments appear. ",
  StyleBox["DSolve", "MR"],
  " by default names these functions ",
  StyleBox["C[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.5.11", "11.47"}],

Cell["Here is a simple PDE involving three independent variables. ", \
"MathCaption",
  CellTags->{"S3.5.11", "11.48"}],

Cell[CellGroupData[{

Cell["(D[#, x1] + D[#, x2] + D[#, x3])& [y[x1, x2, x3]] == 0", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          SuperscriptBox["y", 
            TagBox[\((0, 0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(x1, x2, x3\), "]"}], "+", 
        RowBox[{
          SuperscriptBox["y", 
            TagBox[\((0, 1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(x1, x2, x3\), "]"}], "+", 
        RowBox[{
          SuperscriptBox["y", 
            TagBox[\((1, 0, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(x1, x2, x3\), "]"}]}], 
      "\[Equal]", "0"}]], "Output",
  CellLabel->"Out[30]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["\<\
The solution involves an arbitrary function of two variables. \
\
\>", "MathCaption",
  CellTags->{"S3.5.11", "11.49"}],

Cell[CellGroupData[{

Cell["DSolve[%, y[x1, x2, x3], {x1, x2, x3}]", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x1, x2, 
            x3] \[Rule] \(C[1]\)[\(-x1\) + x2, \(-x1\) + x3]}}\)], "Output",
  CellLabel->"Out[31]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["\<\
Here is the one\[Hyphen]dimensional wave equation. \
\>", \
"MathCaption",
  CellTags->{"S3.5.11", "11.50"}],

Cell[CellGroupData[{

Cell["(c^2 D[#, x, x] - D[#, t, t])& [y[x, t]] == 0", "Input",
  CellLabel->"In[32]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"-", 
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((0, 2)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}]}], "+", 
        RowBox[{\(c\^2\), " ", 
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((2, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}]}]}], "\[Equal]", 
      "0"}]], "Output",
  CellLabel->"Out[32]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["\<\
The solution to this second\[Hyphen]order equation involves two \
arbitrary functions. \
\>", "MathCaption",
  CellTags->{"S3.5.11", "11.51"}],

Cell[CellGroupData[{

Cell["DSolve[%, y[x, t], {x, t}]", "Input",
  CellLabel->"In[33]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x, 
            t] \[Rule] \(C[1]\)[t - \(\@c\^2\ x\)\/c\^2] + \(C[2]\)[
              t + \(\@c\^2\ x\)\/c\^2]}}\)], "Output",
  CellLabel->"Out[33]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["\<\
For an ordinary differential equation, it is guaranteed that a \
general solution must exist, with the property that adding initial or \
boundary conditions simply corresponds to forcing specific choices for \
arbitrary constants in the solution. But for partial differential equations \
this is no longer true. Indeed, it is only for linear partial differential \
and a few other special types that such general solutions exist.  \
\>", \
"Text",
  CellTags->{"S3.5.11", "11.52"}],

Cell["\<\
Other partial differential equations can be solved only when \
specific initial or boundary values are given, and in the vast majority of \
cases no solutions can be found as exact formulas in terms of standard \
mathematical functions. \
\>", "Text",
  CellTags->{"S3.5.11", "11.53"}],

Cell[TextData[{
  "Since ",
  StyleBox["y", "MR"],
  " and its derivatives appear only linearly here, a general solution exists. \
"
}], "MathCaption",
  CellTags->{"S3.5.11", "11.54"}],

Cell[CellGroupData[{

Cell["\<\
DSolve[x1 D[y[x1, x2], x1] + x2 D[y[x1, x2], x2] == Exp[x1 x2], \
y[x1, x2], {x1, x2}]\
\>", "Input",
  CellLabel->"In[34]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x1, x2] \[Rule] 
          1\/2\ \((ExpIntegralEi[x1\ x2] + 
                2\ \(C[1]\)[x2\/x1])\)}}\)], "Output",
  CellLabel->"Out[34]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["\<\
This weakly nonlinear PDE turns out to have a general solution. \
\
\>", "MathCaption",
  CellTags->{"S3.5.11", "11.55"}],

Cell[CellGroupData[{

Cell["\<\
DSolve[D[y[x1, x2], x1] + D[y[x1, x2], x2] == Exp[y[x1, x2]], y[x1, \
x2], {x1, x2}]\
\>", "Input",
  CellLabel->"In[35]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x1, 
            x2] \[Rule] \(-Log[\(-x1\) - \(C[1]\)[\(-x1\) + 
                    x2]]\)}}\)], "Output",
  CellLabel->"Out[35]= ",
  CellTags->"S3.5.11"]
}, Open  ]],

Cell["Here is a nonlinear PDE which has no general solution. ", "MathCaption",
  CellTags->{"S3.5.11", "11.56"}],

Cell[CellGroupData[{

Cell["\<\
DSolve[D[y[x1, x2], x1] D[y[x1, x2], x2] == a, y[x1, x2], {x1, x2}]\
\
\>", "Input",
  CellLabel->"In[36]:= ",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \(DSolve::"nlpde" \(\(:\)\(\ \)\) 
      "Solution requested to nonlinear partial differential equation. Trying \
to build a complete integral."\)], "Message",
  CellTags->"S3.5.11"],

Cell[BoxData[
    \({{y[x1, x2] \[Rule] C[1] + \(a\ x1\)\/C[2] + x2\ C[2]}}\)], "Output",
  CellLabel->"Out[36]= ",
  CellTags->"S3.5.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5.12 Integral Transforms and Related Operations", "Subsection",
  CellTags->{"S3.5.12", "12.1"}],

Cell[CellGroupData[{

Cell["Laplace Transforms", "Subsubsection",
  CellTags->{"S3.5.12", "12.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LaplaceTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the Laplace transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InverseLaplaceTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the inverse Laplace transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.12"],

Cell["\<\
One\[Hyphen]dimensional Laplace transforms. \
\>", "Caption",
  CellTags->"S3.5.12"],

Cell[TextData[{
  "The Laplace transform of a function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["t",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%\[Infinity]\), 
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["t",
              "TI"], ")"}], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["s",
                "TI"], 
              StyleBox["t",
                "TI"]}]], "\[DifferentialD]", 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". The inverse Laplace transform of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            "TI"], 
          RowBox[{"(", 
            StyleBox["s",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is given for suitable ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)], "InlineFormula"],
  " by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox["1", 
            RowBox[{"2", "\[Pi]", 
              StyleBox["i",
                "TI"]}]], 
          SubsuperscriptBox["\[Integral]", 
            RowBox[{"\[Gamma]", "-", 
              StyleBox["i",
                "TI"], "\[Infinity]"}], 
            RowBox[{"\[Gamma]", "+", 
              StyleBox["i",
                "TI"], "\[Infinity]"}]], 
          StyleBox["F",
            "TI"], 
          RowBox[{"(", 
            StyleBox["s",
              "TI"], ")"}], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            StyleBox[\(s  t\),
              "TI"]], "\[DifferentialD]", 
          StyleBox["s",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.5.12", "12.3"}],

Cell["Here is a simple Laplace transform. ", "MathCaption",
  CellTags->{"S3.5.12", "12.4"}],

Cell[CellGroupData[{

Cell["LaplaceTransform[t^4 Sin[t], t, s]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(\(24\ \((1 + 5\ s\^2\ \((\(-2\) + s\^2)\))\)\)\/\((1 + s\^2)\)\^5\)], \
"Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell["Here is the inverse. ", "MathCaption",
  CellTags->{"S3.5.12", "12.5"}],

Cell[CellGroupData[{

Cell["InverseLaplaceTransform[%, s, t]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(t\^4\ Sin[t]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell["Even simple transforms often involve special functions. ", "MathCaption",
  CellTags->{"S3.5.12", "12.6"}],

Cell[CellGroupData[{

Cell["LaplaceTransform[1/(1 + t^2), t, s]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(CosIntegral[s]\ Sin[s] + 
      1\/2\ Cos[s]\ \((\[Pi] - 2\ SinIntegral[s])\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell["Here the result involves a Meijer G function. ", "MathCaption",
  CellTags->{"S3.5.12", "12.7"}],

Cell[CellGroupData[{

Cell["LaplaceTransform[1/(1 + t^3), t, s]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(MeijerG[{{2\/3}, {}}, {{0, 1\/3, 2\/3, 2\/3}, {}}, s\^3\/27]\/\(2\ \@3\ \
\[Pi]\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell["\<\
The Laplace transform of this Bessel function just involves \
elementary functions. \
\>", "MathCaption",
  CellTags->{"S3.5.12", "12.8"}],

Cell[CellGroupData[{

Cell["LaplaceTransform[BesselJ[n, t], t, s]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(\((s + \@\(1 + s\^2\))\)\^\(-n\)\/\@\(1 + s\^2\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell["\<\
Laplace transforms have the property that they turn integration and \
differentiation into essentially algebraic operations. They are therefore \
commonly used in studying systems governed by differential equations. \
\>", \
"Text",
  CellTags->{"S3.5.12", "12.9"}],

Cell[TextData[{
  "Integration becomes multiplication by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          StyleBox["s",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " when one does a Laplace transform. "
}], "MathCaption",
  CellTags->{"S3.5.12", "12.10"}],

Cell[CellGroupData[{

Cell["LaplaceTransform[Integrate[f[u], {u, 0, t}], t, s]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(LaplaceTransform[f[t], t, s]\/s\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LaplaceTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "the multidimensional Laplace transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InverseLaplaceTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "the multidimensional inverse Laplace transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.12"],

Cell["Multidimensional Laplace transforms. ", "Caption",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fourier Transforms", "Subsubsection",
  CellTags->{"S3.5.12", "12.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FourierTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\)], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the Fourier transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InverseFourierTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the inverse Fourier transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.12"],

Cell["\<\
One\[Hyphen]dimensional Fourier transforms. \
\>", "Caption",
  CellTags->"S3.5.12"],

Cell["Here is a Fourier transform. ", "MathCaption",
  CellTags->{"S3.5.12", "12.12"}],

Cell[CellGroupData[{

Cell["\<\
FourierTransform[1/(1 + t^4), t, \[Omega]]\
\>", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(\((1\/4 + \[ImaginaryI]\/4)\)\ \[ExponentialE]\^\(-\(\(\((1 + \
\[ImaginaryI])\)\ \[Omega]\)\/\@2\)\)\ \@\[Pi]\ \((\[ExponentialE]\^\(\@2\ \
\[Omega]\)\ \((\(-\[ImaginaryI]\) + \[ExponentialE]\^\(\[ImaginaryI]\ \@2\ \
\[Omega]\))\)\ UnitStep[\(-\[Omega]\)] + \((1 - \[ImaginaryI]\ \
\[ExponentialE]\^\(\[ImaginaryI]\ \@2\ \[Omega]\))\)\ \
UnitStep[\[Omega]])\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell["This finds the inverse. ", "MathCaption",
  CellTags->{"S3.5.12", "12.13"}],

Cell[CellGroupData[{

Cell["\<\
InverseFourierTransform[%, \[Omega], t]\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(1\/\(1 + t\^4\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica", "TI"],
  " the Fourier transform of a function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["t",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is by default defined to be ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(1\/\@\(2  \[Pi]\)\), \(\[Integral]\_\(-\[Infinity]\)\%\
\[Infinity]\), 
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["t",
              "TI"], ")"}], " ", 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{
              StyleBox["i",
                "TI"], "\[Omega]", 
              StyleBox["t",
                "TI"]}]], "\[DifferentialD]", 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". The inverse Fourier transform of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            "TI"], \((\[Omega])\)}], TraditionalForm]], "InlineFormula"],
  " is similarly defined as ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(1\/\@\(2  \[Pi]\)\), \(\[Integral]\_\(-\[Infinity]\)\%\
\[Infinity]\), 
          StyleBox["F",
            "TI"], \((\[Omega])\), " ", 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["i",
                "TI"], "\[Omega]", 
              StyleBox["t",
                "TI"]}]], "\[DifferentialD]", "\[Omega]"}], TraditionalForm]],
     "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.5.12", "12.14"}],

Cell[TextData[{
  "In different scientific and technical fields different conventions are \
often used for defining Fourier transforms. The option ",
  StyleBox["FourierParameters", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " allows you to choose any of these conventions you want. "
}], "Text",
  CellTags->{"S3.5.12", "12.15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["common convention", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["setting", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["Fourier transform", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["inverse Fourier transform", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " default "
            }]], Cell[TextData[{
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["1}", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    
                    RowBox[{\(1\/\@\(2  \[Pi]\)\), \(\[Integral]\_\(-\
\[Infinity]\)\%\[Infinity]\), 
                      StyleBox["f",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["t",
                          "TI"], ")"}], " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{
                          StyleBox["i",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", 
                      StyleBox["t",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    
                    RowBox[{\(1\/\@\(2  \[Pi]\)\), \(\[Integral]\_\(-\
\[Infinity]\)\%\[Infinity]\), 
                      StyleBox["F",
                        "TI"], \((\[Omega])\), " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{"-", 
                          StyleBox["i",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", "\[Omega]"}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell["pure mathematics "], Cell[TextData[{
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["-1}", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\), 
                      StyleBox["f",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["t",
                          "TI"], ")"}], " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{"-", 
                          StyleBox["i",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", 
                      StyleBox["t",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    
                    RowBox[{\(1\/\(2  \[Pi]\)\), \
\(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\), 
                      StyleBox["F",
                        "TI"], \((\[Omega])\), " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{
                          StyleBox["i",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", "\[Omega]"}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell["classical physics "], Cell[TextData[{
              StyleBox["{-1,", "MR"],
              " ",
              StyleBox["1}", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    
                    RowBox[{\(1\/\(2  \[Pi]\)\), \
\(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\), 
                      StyleBox["f",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["t",
                          "TI"], ")"}], " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{
                          StyleBox["i",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", 
                      StyleBox["t",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\), 
                      StyleBox["F",
                        "TI"], \((\[Omega])\), " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{"-", 
                          StyleBox["i",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", "\[Omega]"}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell["modern physics "], Cell[TextData[{
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["1}", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    
                    RowBox[{\(1\/\@\(2  \[Pi]\)\), \(\[Integral]\_\(-\
\[Infinity]\)\%\[Infinity]\), 
                      StyleBox["f",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["t",
                          "TI"], ")"}], " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{
                          StyleBox["i",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", 
                      StyleBox["t",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    
                    RowBox[{\(1\/\@\(2  \[Pi]\)\), \(\[Integral]\_\(-\
\[Infinity]\)\%\[Infinity]\), 
                      StyleBox["F",
                        "TI"], \((\[Omega])\), " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{"-", 
                          StyleBox["i",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", "\[Omega]"}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell["systems engineering "], Cell[TextData[{
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["-1}", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\), 
                      StyleBox["f",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["t",
                          "TI"], ")"}], " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{"-", 
                          StyleBox["i",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", 
                      StyleBox["t",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    
                    RowBox[{\(1\/\(2  \[Pi]\)\), \
\(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\), 
                      StyleBox["F",
                        "TI"], \((\[Omega])\), " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{
                          StyleBox["i",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", "\[Omega]"}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell["signal processing "], Cell[TextData[{
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["-2", "MR"],
              " ",
              StyleBox["Pi}", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\), 
                      StyleBox["f",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["t",
                          "TI"], ")"}], " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{\(-2\), "\[Pi]", 
                          StyleBox["i",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", 
                      StyleBox["t",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\), 
                      StyleBox["F",
                        "TI"], \((\[Omega])\), " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{"2", "\[Pi]", 
                          StyleBox["i",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", "\[Omega]"}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell["general case "], Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SqrtBox[
                        FractionBox[
                          RowBox[{"\[VerticalSeparator]", 
                            StyleBox["b",
                              "TI"], "\[VerticalSeparator]"}], 
                          SuperscriptBox[\((2  \[Pi])\), 
                            RowBox[{"1", "-", 
                              StyleBox["a",
                                
                                "TI"]}]]]], \(\[Integral]\_\(-\[Infinity]\)\%\
\[Infinity]\), 
                      StyleBox["f",
                        "TI"], 
                      RowBox[{"(", 
                        StyleBox["t",
                          "TI"], ")"}], " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{
                          StyleBox["i",
                            "TI"], 
                          StyleBox["b",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", 
                      StyleBox["t",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SqrtBox[
                        FractionBox[
                          RowBox[{"\[VerticalSeparator]", 
                            StyleBox["b",
                              "TI"], "\[VerticalSeparator]"}], 
                          SuperscriptBox[\((2  \[Pi])\), 
                            RowBox[{"1", "+", 
                              StyleBox["a",
                                
                                "TI"]}]]]], \(\[Integral]\_\(-\[Infinity]\)\%\
\[Infinity]\), 
                      StyleBox["F",
                        "TI"], \((\[Omega])\), " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{"-", 
                          StyleBox["i",
                            "TI"], 
                          StyleBox["b",
                            "TI"], "\[Omega]", 
                          StyleBox["t",
                            "TI"]}]], "\[DifferentialD]", "\[Omega]"}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox4Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S3.5.12"],

Cell[TextData[{
  "Typical settings for ",
  StyleBox["FourierParameters", "MR"],
  " with various conventions. "
}], "Caption",
  CellTags->"S3.5.12"],

Cell["\<\
Here is a Fourier transform with the default choice of parameters. \
\
\>", "MathCaption",
  CellTags->{"S3.5.12", "12.16"}],

Cell[CellGroupData[{

Cell["\<\
FourierTransform[Exp[-t^2], t, \[Omega]]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(\[ExponentialE]\^\(-\(\[Omega]\^2\/4\)\)\/\@2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell["\<\
Here is the same Fourier transform with the choice of parameters \
typically used in signal processing. \
\>", "MathCaption",
  CellTags->{"S3.5.12", "12.17"}],

Cell[CellGroupData[{

Cell["\<\
FourierTransform[Exp[-t^2], t, \[Omega], FourierParameters->{0, -2 \
Pi}]\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(\[ExponentialE]\^\(\(-\[Pi]\^2\)\ \[Omega]\^2\)\ \@\[Pi]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FourierSinTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\)], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["Fourier sine transform "]},
          {Cell[TextData[{
              StyleBox["FourierCosTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\)], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["Fourier cosine transform "]},
          {Cell[TextData[{
              StyleBox["InverseFourierSinTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["inverse Fourier sine transform "]},
          {Cell[TextData[{
              StyleBox["InverseFourierCosTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["inverse Fourier cosine transform "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.12"],

Cell["Fourier sine and cosine transforms. ", "Caption",
  CellTags->"S3.5.12"],

Cell[TextData[{
  "In some applications of Fourier transforms, it is convenient to avoid ever \
introducing complex exponentials. Fourier sine and cosine transforms \
correspond to integrating respectively with ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            RowBox[{"\[Omega]", 
              StyleBox["t",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"cos", 
          RowBox[{"(", 
            RowBox[{"\[Omega]", 
              StyleBox["t",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " instead of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"exp", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["i",
                "TI"], "\[Omega]", 
              StyleBox["t",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", and using limits 0 and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  " rather than ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.5.12", "12.18"}],

Cell[TextData[{
  "Here are the Fourier sine and cosine transforms of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["e",
            "TI"], 
          RowBox[{"-", 
            StyleBox["t",
              "TI"]}]], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.12", "12.19"}],

Cell[CellGroupData[{

Cell["\<\
{FourierSinTransform[Exp[-t], t, \[Omega]], \
FourierCosTransform[Exp[-t], t, \[Omega]]}\
\>", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \({\(\@\(2\/\[Pi]\)\ \[Omega]\)\/\(1 + \[Omega]\^2\), \@\(2\/\[Pi]\)\/\(1 \
+ \[Omega]\^2\)}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FourierTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\_1\)], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\_2\)], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "the multidimensional Fourier transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InverseFourierTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\_1\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\_2\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "the multidimensional inverse Fourier transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FourierSinTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\_1\)], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\_2\)], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[",  ", "TR"],
              StyleBox["FourierCosTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\_1\)], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\_2\)], "InlineFormula"],
              ", \[Ellipsis] }]"
            }]], Cell[TextData[{
              "  the multidimensional sine and cosine Fourier transforms of ",
              
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InverseFourierSinTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\_1\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\_2\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[",  ", "TR"],
              StyleBox["InverseFourierCosTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\_1\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Omega]\_2\)], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              
              "  the multidimensional inverse Fourier sine and cosine \
transforms of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.12"],

Cell["Multidimensional Fourier transforms. ", "Caption",
  CellTags->"S3.5.12"],

Cell["\<\
This evaluates a two\[Hyphen]dimensional Fourier transform. \
\>", \
"MathCaption",
  CellTags->{"S3.5.12", "12.20"}],

Cell[CellGroupData[{

Cell["FourierTransform[(u v)^2 Exp[-u^2-v^2], {u, v}, {a, b}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(1\/32\ \((\(-2\) + a\^2)\)\ \((\(-2\) + 
          b\^2)\)\ \[ExponentialE]\^\(\(-\(a\^2\/4\)\) - b\^2\/4\)\)], \
"Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell["This inverts the transform. ", "MathCaption",
  CellTags->{"S3.5.12", "12.21"}],

Cell[CellGroupData[{

Cell["InverseFourierTransform[%, {a, b}, {u, v}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(\[ExponentialE]\^\(\(-u\^2\) - v\^2\)\ u\^2\ v\^2\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.5.12"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Z Transforms", "Subsubsection",
  CellTags->{"S3.5.12", "12.22"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ZTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Z transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InverseZTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "inverse Z transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.12"],

Cell["Z transforms. ", "Caption",
  CellTags->"S3.5.12"],

Cell[TextData[{
  "The Z transform of a function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["n",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["n",
              "TI"], ")"}], 
          SuperscriptBox[
            StyleBox["z",
              "TI"], 
            RowBox[{"-", 
              StyleBox["n",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  ". The inverse Z transform of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            "TI"], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is given by the contour integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox["1", 
            RowBox[{"2", "\[Pi]", 
              StyleBox["i",
                "TI"]}]], "\[ContourIntegral]", 
          StyleBox["F",
            "TI"], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}], 
          SuperscriptBox[
            StyleBox["z",
              "TI"], 
            RowBox[{
              StyleBox["n",
                "TI"], "-", "1"}]], "\[DifferentialD]", 
          StyleBox["z",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". Z transforms are effectively discrete analogs of Laplace transforms. \
They are widely used for solving difference equations, especially in digital \
signal processing and control theory. They can be thought of as producing \
generating functions, of the kind commonly used in combinatorics and number \
theory. "
}], "Text",
  CellTags->{"S3.5.12", "12.23"}],

Cell[TextData[{
  "This computes the Z transform of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["2", 
          RowBox[{"-", 
            StyleBox["n",
              "TI"]}]], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.12", "12.24"}],

Cell[CellGroupData[{

Cell["ZTransform[2^-n, n, z]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(\(2\ z\)\/\(\(-1\) + 2\ z\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell["Here is the inverse Z transform. ", "MathCaption",
  CellTags->{"S3.5.12", "12.25"}],

Cell[CellGroupData[{

Cell["InverseZTransform[%, z, n]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(2\^\(-n\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell[TextData[{
  "The generating function for ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          StyleBox["n",
            "TI"], "!"}], TraditionalForm]], "InlineFormula"],
  " is an exponential function. "
}], "MathCaption",
  CellTags->{"S3.5.12", "12.26"}],

Cell[CellGroupData[{

Cell["ZTransform[1/n!, n, z]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.12"],

Cell[BoxData[
    \(\[ExponentialE]\^\(1\/z\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.12"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5.13 Generalized Functions and Related Objects", "Subsection",
  CellTags->{"S3.5.13", "13.1"}],

Cell[TextData[{
  "In many practical situations it is convenient to consider limits in which \
a fixed amount of something is concentrated into an infinitesimal region. \
Ordinary mathematical functions of the kind normally encountered in calculus \
cannot readily represent such limits. However, it is possible to introduce ",
  StyleBox["generalized functions", "TI"],
  " or ",
  StyleBox["distributions", "TI"],
  " which can represent these limits in integrals and other types of \
calculations. "
}], "Text",
  CellTags->{"S3.5.13", "13.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DiracDelta[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Dirac delta function ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Delta]", 
                      RowBox[{"(", 
                        StyleBox["x",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["UnitStep[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "unit step function, equal to 0 for ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["x",
                        "TI"], "<", "0"}], TraditionalForm]], 
                "InlineFormula"],
              " and 1 for ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["x",
                        "TI"], ">", "0"}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.13"],

Cell["Dirac delta and unit step functions. ", "Caption",
  CellTags->"S3.5.13"],

Cell[TextData[{
  "Here is a function concentrated around ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.13", "13.3"}],

Cell[CellGroupData[{

Cell["Plot[Sqrt[50/Pi] Exp[-50 x^2], {x, -2, 2}, PlotRange->All]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.5.13"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.0147151 0.147555 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.7381 .00222 -3 -9 ]
[.7381 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.4875 .16227 -6 -4.5 ]
[.4875 .16227 0 4.5 ]
[.4875 .30983 -6 -4.5 ]
[.4875 .30983 0 4.5 ]
[.4875 .45738 -6 -4.5 ]
[.4875 .45738 0 4.5 ]
[.4875 .60494 -6 -4.5 ]
[.4875 .60494 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-2)] .02381 .00222 0 1 Mshowa
.2619 .01472 m
.2619 .02097 L
s
[(-1)] .2619 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(1)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .16227 m
.50625 .16227 L
s
[(1)] .4875 .16227 1 0 Mshowa
.5 .30983 m
.50625 .30983 L
s
[(2)] .4875 .30983 1 0 Mshowa
.5 .45738 m
.50625 .45738 L
s
[(3)] .4875 .45738 1 0 Mshowa
.5 .60494 m
.50625 .60494 L
s
[(4)] .4875 .60494 1 0 Mshowa
.125 Mabswid
.5 .04423 m
.50375 .04423 L
s
.5 .07374 m
.50375 .07374 L
s
.5 .10325 m
.50375 .10325 L
s
.5 .13276 m
.50375 .13276 L
s
.5 .19178 m
.50375 .19178 L
s
.5 .22129 m
.50375 .22129 L
s
.5 .2508 m
.50375 .2508 L
s
.5 .28031 m
.50375 .28031 L
s
.5 .33934 m
.50375 .33934 L
s
.5 .36885 m
.50375 .36885 L
s
.5 .39836 m
.50375 .39836 L
s
.5 .42787 m
.50375 .42787 L
s
.5 .48689 m
.50375 .48689 L
s
.5 .5164 m
.50375 .5164 L
s
.5 .54591 m
.50375 .54591 L
s
.5 .57543 m
.50375 .57543 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
.5 Mabswid
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01472 L
.02954 .01472 L
.03053 .01472 L
.03163 .01472 L
.03279 .01472 L
.03395 .01472 L
.0352 .01472 L
.03638 .01472 L
.03746 .01472 L
.03873 .01472 L
.03944 .01472 L
.04011 .01472 L
.04132 .01472 L
.04262 .01472 L
.04327 .01472 L
.04396 .01472 L
.04519 .01472 L
.04588 .01472 L
.04652 .01472 L
.04722 .01472 L
.04797 .01472 L
.04862 .01472 L
.04933 .01472 L
.05061 .01472 L
.05186 .01472 L
.05302 .01472 L
.05414 .01472 L
.05519 .01472 L
.05634 .01472 L
.05759 .01472 L
.05882 .01472 L
.06012 .01472 L
.06123 .01472 L
.06244 .01472 L
.06315 .01472 L
.06381 .01472 L
.06453 .01472 L
.06529 .01472 L
.06657 .01472 L
.06729 .01472 L
.06797 .01472 L
.06924 .01472 L
.0704 .01472 L
.07103 .01472 L
.07173 .01472 L
.073 .01472 L
Mistroke
.07376 .01472 L
.07448 .01472 L
.07513 .01472 L
.07583 .01472 L
.0766 .01472 L
.0774 .01472 L
.07809 .01472 L
.07885 .01472 L
.07956 .01472 L
.0802 .01472 L
.08095 .01472 L
.08166 .01472 L
.08291 .01472 L
.08362 .01472 L
.08427 .01472 L
.08544 .01472 L
.08669 .01472 L
.08787 .01472 L
.08896 .01472 L
.09016 .01472 L
.09148 .01472 L
.09214 .01472 L
.09285 .01472 L
.09413 .01472 L
.09483 .01472 L
.09548 .01472 L
.09619 .01472 L
.09695 .01472 L
.09821 .01472 L
.09893 .01472 L
.09961 .01472 L
.10086 .01472 L
.10201 .01472 L
.10333 .01472 L
.10458 .01472 L
.10572 .01472 L
.10694 .01472 L
.1081 .01472 L
.10916 .01472 L
.11033 .01472 L
.11162 .01472 L
.11227 .01472 L
.11297 .01472 L
.11422 .01472 L
.11491 .01472 L
.11554 .01472 L
.11624 .01472 L
.11698 .01472 L
.11822 .01472 L
.11892 .01472 L
Mistroke
.11958 .01472 L
.12081 .01472 L
.12194 .01472 L
.12323 .01472 L
.12446 .01472 L
.12562 .01472 L
.12668 .01472 L
.12789 .01472 L
.12903 .01472 L
.13009 .01472 L
.13107 .01472 L
.13214 .01472 L
.13327 .01472 L
.13441 .01472 L
.13564 .01472 L
.1368 .01472 L
.13785 .01472 L
.13909 .01472 L
.13979 .01472 L
.14043 .01472 L
.14162 .01472 L
.14288 .01472 L
.14402 .01472 L
.14526 .01472 L
.14656 .01472 L
.14777 .01472 L
.14891 .01472 L
.14994 .01472 L
.15113 .01472 L
.15226 .01472 L
.15348 .01472 L
.15478 .01472 L
.15589 .01472 L
.15711 .01472 L
.15842 .01472 L
.15915 .01472 L
.15982 .01472 L
.16113 .01472 L
.16236 .01472 L
.16352 .01472 L
.16456 .01472 L
.16577 .01472 L
.1669 .01472 L
.16796 .01472 L
.16893 .01472 L
.16999 .01472 L
.17111 .01472 L
.17225 .01472 L
.17347 .01472 L
.17462 .01472 L
Mistroke
.17566 .01472 L
.17689 .01472 L
.17758 .01472 L
.17823 .01472 L
.1794 .01472 L
.18065 .01472 L
.18185 .01472 L
.18316 .01472 L
.18441 .01472 L
.18556 .01472 L
.1867 .01472 L
.18773 .01472 L
.18893 .01472 L
.19005 .01472 L
.19128 .01472 L
.19258 .01472 L
.19369 .01472 L
.19491 .01472 L
.19623 .01472 L
.19696 .01472 L
.19763 .01472 L
.19894 .01472 L
.20017 .01472 L
.20122 .01472 L
.20238 .01472 L
.20359 .01472 L
.20472 .01472 L
.20578 .01472 L
.20675 .01472 L
.20781 .01472 L
.20894 .01472 L
.21008 .01472 L
.21129 .01472 L
.21244 .01472 L
.21349 .01472 L
.21472 .01472 L
.21541 .01472 L
.21605 .01472 L
.21723 .01472 L
.21847 .01472 L
.21968 .01472 L
.221 .01472 L
.22224 .01472 L
.2234 .01472 L
.22454 .01472 L
.22558 .01472 L
.22677 .01472 L
.2279 .01472 L
.22914 .01472 L
.23044 .01472 L
Mistroke
.23155 .01472 L
.23277 .01472 L
.23409 .01472 L
.23482 .01472 L
.2355 .01472 L
.2368 .01472 L
.23804 .01472 L
.23909 .01472 L
.24025 .01472 L
.24146 .01472 L
.2426 .01472 L
.24365 .01472 L
.24462 .01472 L
.24569 .01472 L
.24681 .01472 L
.24795 .01472 L
.24917 .01472 L
.25032 .01472 L
.25137 .01472 L
.2526 .01472 L
.25329 .01472 L
.25393 .01472 L
.2551 .01472 L
.25635 .01472 L
.25756 .01472 L
.25888 .01472 L
.26013 .01472 L
.26129 .01472 L
.26233 .01472 L
.26348 .01472 L
.26467 .01472 L
.2658 .01472 L
.26704 .01472 L
.26835 .01472 L
.26946 .01472 L
.27068 .01472 L
.272 .01472 L
.27274 .01472 L
.27341 .01472 L
.27472 .01472 L
.27595 .01472 L
.27701 .01472 L
.27817 .01472 L
.27938 .01472 L
.28052 .01472 L
.28158 .01472 L
.28255 .01472 L
.28367 .01472 L
.28474 .01472 L
.28588 .01472 L
Mistroke
.2871 .01472 L
.28825 .01472 L
.2893 .01472 L
.29053 .01472 L
.29122 .01472 L
.29186 .01472 L
.29303 .01472 L
.29427 .01472 L
.29549 .01472 L
.29618 .01472 L
.29682 .01472 L
.29799 .01472 L
.29923 .01472 L
.30034 .01472 L
.30138 .01472 L
.30252 .01472 L
.30375 .01472 L
.30499 .01472 L
.30569 .01472 L
.30634 .01472 L
.30765 .01472 L
.30839 .01472 L
.30906 .01472 L
.31026 .01472 L
.31156 .01472 L
.31278 .01472 L
.31392 .01472 L
.31497 .01472 L
.31611 .01472 L
.31718 .01472 L
.31816 .01472 L
.3193 .01472 L
.32055 .01472 L
.32173 .01472 L
.32282 .01472 L
.32406 .01472 L
.32522 .01472 L
.32626 .01472 L
.32739 .01472 L
.32862 .01472 L
.32992 .01472 L
.33103 .01472 L
.33225 .01472 L
.33356 .01472 L
.33477 .01472 L
.33541 .01472 L
.3361 .01472 L
.33684 .01472 L
.33751 .01472 L
.33875 .01472 L
Mistroke
.33943 .01472 L
.34008 .01472 L
.34123 .01472 L
.34249 .01472 L
.34371 .01472 L
.34482 .01472 L
.34611 .01472 L
.34732 .01472 L
.34844 .01472 L
.34947 .01472 L
.35061 .01472 L
.35181 .01472 L
.35311 .01472 L
.35429 .01472 L
.35566 .01472 L
.35696 .01472 L
.35816 .01472 L
.35927 .01472 L
.36049 .01472 L
.36178 .01472 L
.36307 .01472 L
.36446 .01472 L
.36578 .01472 L
.36699 .01472 L
.36832 .01472 L
.36979 .01472 L
.37131 .01472 L
.37274 .01472 L
.37401 .01472 L
.37536 .01472 L
.37651 .01472 L
.37778 .01472 L
.37914 .01472 L
.3806 .01472 L
.38198 .01472 L
.38325 .01472 L
.38451 .01472 L
.38568 .01472 L
.38697 .01472 L
.38834 .01472 L
.38964 .01473 L
.39088 .01473 L
.39197 .01474 L
.39317 .01474 L
.39544 .01475 L
.39667 .01476 L
.39783 .01477 L
.39989 .0148 L
.40105 .01482 L
.4021 .01484 L
Mistroke
.40448 .0149 L
.40582 .01495 L
.40706 .015 L
.40934 .01513 L
.41176 .01533 L
.41414 .0156 L
.41665 .016 L
.4188 .01647 L
.42114 .01716 L
.42367 .01817 L
.42638 .01965 L
.42893 .02156 L
.43125 .02382 L
.4336 .02676 L
.43577 .03018 L
.4381 .03476 L
.44066 .04108 L
.44497 .05545 L
.44953 .07699 L
.45476 .1115 L
.45971 .15535 L
.469 .26696 L
.47913 .41559 L
.48468 .49333 L
.4874 .5265 L
.4899 .55275 L
.4923 .57335 L
.49356 .58225 L
.49492 .59011 L
.49628 .59624 L
.49755 .60027 L
.4983 .60188 L
.49901 .60286 L
.49964 .60331 L
.50033 .60332 L
.50146 .60226 L
.50271 .59957 L
.50402 .59506 L
.50524 .5893 L
.50742 .57547 L
.50977 .55586 L
.5147 .50128 L
.51938 .43738 L
.52817 .30699 L
.53776 .18211 L
.54312 .12893 L
.54798 .09201 L
.55252 .06637 L
.55492 .05589 L
.55744 .04677 L
Mistroke
.55966 .04022 L
.56209 .03436 L
.56636 .02682 L
.56887 .02369 L
.5716 .02111 L
.57418 .01931 L
.57657 .01806 L
.57871 .01721 L
.58108 .0165 L
.58355 .01596 L
.58587 .0156 L
.58843 .01531 L
.58971 .0152 L
.59112 .0151 L
.59232 .01503 L
.59361 .01497 L
.59593 .01489 L
.59734 .01485 L
.59886 .01482 L
.6002 .0148 L
.60162 .01478 L
.6029 .01477 L
.6043 .01476 L
.60678 .01474 L
.60808 .01473 L
.60928 .01473 L
.61059 .01473 L
.61199 .01472 L
.61333 .01472 L
.61459 .01472 L
.61574 .01472 L
.61694 .01472 L
.61805 .01472 L
.61927 .01472 L
.62141 .01472 L
.62261 .01472 L
.6239 .01472 L
.62512 .01472 L
.62623 .01472 L
.62752 .01472 L
.6289 .01472 L
.63008 .01472 L
.63137 .01472 L
.63276 .01472 L
.63426 .01472 L
.63567 .01472 L
.63696 .01472 L
.63819 .01472 L
.63933 .01472 L
.64058 .01472 L
Mistroke
.64191 .01472 L
.64332 .01472 L
.64464 .01472 L
.64583 .01472 L
.64712 .01472 L
.64835 .01472 L
.64948 .01472 L
.65079 .01472 L
.65202 .01472 L
.65316 .01472 L
.65422 .01472 L
.65537 .01472 L
.65661 .01472 L
.65783 .01472 L
.65848 .01472 L
.65916 .01472 L
.66041 .01472 L
.66156 .01472 L
.66221 .01472 L
.66291 .01472 L
.66417 .01472 L
.66494 .01472 L
.66567 .01472 L
.66637 .01472 L
.66703 .01472 L
.66824 .01472 L
.66889 .01472 L
.66958 .01472 L
.6703 .01472 L
.67099 .01472 L
.67228 .01472 L
.67348 .01472 L
.6746 .01472 L
.67582 .01472 L
.67713 .01472 L
.67787 .01472 L
.67855 .01472 L
.67928 .01472 L
.68009 .01472 L
.68144 .01472 L
.68218 .01472 L
.68287 .01472 L
.68419 .01472 L
.68539 .01472 L
.68605 .01472 L
.68677 .01472 L
.68808 .01472 L
.6893 .01472 L
.69042 .01472 L
.69165 .01472 L
Mistroke
.69294 .01472 L
.69406 .01472 L
.69511 .01472 L
.69626 .01472 L
.69749 .01472 L
.69819 .01472 L
.69883 .01472 L
.69954 .01472 L
.70029 .01472 L
.70155 .01472 L
.70226 .01472 L
.70293 .01472 L
.70417 .01472 L
.70531 .01472 L
.70662 .01472 L
.70787 .01472 L
.70855 .01472 L
.7092 .01472 L
.7104 .01472 L
.71169 .01472 L
.71242 .01472 L
.71309 .01472 L
.71421 .01472 L
.71544 .01472 L
.71673 .01472 L
.71792 .01472 L
.71861 .01472 L
.71935 .01472 L
.72005 .01472 L
.7207 .01472 L
.72192 .01472 L
.72322 .01472 L
.72389 .01472 L
.72461 .01472 L
.72591 .01472 L
.72671 .01472 L
.72746 .01472 L
.72814 .01472 L
.72888 .01472 L
.72953 .01472 L
.73021 .01472 L
.73143 .01472 L
.73274 .01472 L
.73349 .01472 L
.73419 .01472 L
.73545 .01472 L
.7366 .01472 L
.73724 .01472 L
.73793 .01472 L
.73919 .01472 L
Mistroke
.74031 .01472 L
.74154 .01472 L
.74283 .01472 L
.74405 .01472 L
.74517 .01472 L
.74621 .01472 L
.74735 .01472 L
.74854 .01472 L
.74985 .01472 L
.75105 .01472 L
.75171 .01472 L
.75243 .01472 L
.75373 .01472 L
.75495 .01472 L
.75624 .01472 L
.75734 .01472 L
.75855 .01472 L
.75928 .01472 L
.75998 .01472 L
.76128 .01472 L
.76201 .01472 L
.76268 .01472 L
.76342 .01472 L
.76421 .01472 L
.7649 .01472 L
.76564 .01472 L
.76635 .01472 L
.76699 .01472 L
.76822 .01472 L
.76951 .01472 L
.77073 .01472 L
.77142 .01472 L
.77206 .01472 L
.77323 .01472 L
.77448 .01472 L
.77559 .01472 L
.77663 .01472 L
.77777 .01472 L
.779 .01472 L
.78024 .01472 L
.78094 .01472 L
.78159 .01472 L
.78291 .01472 L
.78364 .01472 L
.78431 .01472 L
.78551 .01472 L
.78681 .01472 L
.78804 .01472 L
.78917 .01472 L
.79023 .01472 L
Mistroke
.79137 .01472 L
.79244 .01472 L
.79342 .01472 L
.79457 .01472 L
.79582 .01472 L
.797 .01472 L
.79809 .01472 L
.79921 .01472 L
.80026 .01472 L
.80141 .01472 L
.80266 .01472 L
.80389 .01472 L
.80519 .01472 L
.8063 .01472 L
.80752 .01472 L
.80883 .01472 L
.81004 .01472 L
.81068 .01472 L
.81137 .01472 L
.8121 .01472 L
.81279 .01472 L
.81404 .01472 L
.81519 .01472 L
.81582 .01472 L
.81651 .01472 L
.81777 .01472 L
.81899 .01472 L
.82011 .01472 L
.82139 .01472 L
.8226 .01472 L
.82372 .01472 L
.82476 .01472 L
.82589 .01472 L
.82709 .01472 L
.82839 .01472 L
.82958 .01472 L
.83024 .01472 L
.83095 .01472 L
.83225 .01472 L
.83347 .01472 L
.83476 .01472 L
.83586 .01472 L
.83707 .01472 L
.83776 .01472 L
.83849 .01472 L
.83979 .01472 L
.84052 .01472 L
.84119 .01472 L
.84193 .01472 L
.84272 .01472 L
Mistroke
.84341 .01472 L
.84415 .01472 L
.84486 .01472 L
.8455 .01472 L
.84673 .01472 L
.84803 .01472 L
.84924 .01472 L
.85056 .01472 L
.8518 .01472 L
.85296 .01472 L
.85411 .01472 L
.85514 .01472 L
.85634 .01472 L
.85747 .01472 L
.8587 .01472 L
.86001 .01472 L
.86112 .01472 L
.86234 .01472 L
.86366 .01472 L
.86439 .01472 L
.86506 .01472 L
.86637 .01472 L
.8676 .01472 L
.86866 .01472 L
.86982 .01472 L
.87103 .01472 L
.87217 .01472 L
.87323 .01472 L
.8742 .01472 L
.87526 .01472 L
.87638 .01472 L
.87753 .01472 L
.87875 .01472 L
.8799 .01472 L
.88094 .01472 L
.88217 .01472 L
.88286 .01472 L
.8835 .01472 L
.88468 .01472 L
.88592 .01472 L
.88713 .01472 L
.88782 .01472 L
.88846 .01472 L
.88963 .01472 L
.89087 .01472 L
.89197 .01472 L
.89301 .01472 L
.89415 .01472 L
.89538 .01472 L
.89661 .01472 L
Mistroke
.89731 .01472 L
.89796 .01472 L
.89927 .01472 L
.90001 .01472 L
.90068 .01472 L
.90187 .01472 L
.90317 .01472 L
.9044 .01472 L
.90553 .01472 L
.90659 .01472 L
.90772 .01472 L
.90879 .01472 L
.90977 .01472 L
.91091 .01472 L
.91216 .01472 L
.91334 .01472 L
.91443 .01472 L
.91567 .01472 L
.91683 .01472 L
.91787 .01472 L
.919 .01472 L
.92023 .01472 L
.92153 .01472 L
.92264 .01472 L
.92386 .01472 L
.92517 .01472 L
.92638 .01472 L
.92701 .01472 L
.9277 .01472 L
.92843 .01472 L
.92911 .01472 L
.93036 .01472 L
.9315 .01472 L
.93276 .01472 L
.93408 .01472 L
.93519 .01472 L
.93638 .01472 L
.93751 .01472 L
.93853 .01472 L
.93973 .01472 L
.94103 .01472 L
.94226 .01472 L
.94339 .01472 L
.94459 .01472 L
.94589 .01472 L
.94711 .01472 L
.94823 .01472 L
.94954 .01472 L
.95028 .01472 L
.95096 .01472 L
Mistroke
.95222 .01472 L
.95292 .01472 L
.95355 .01472 L
.95423 .01472 L
.95494 .01472 L
.95622 .01472 L
.95693 .01472 L
.95759 .01472 L
.95832 .01472 L
.9591 .01472 L
.95977 .01472 L
.9605 .01472 L
.96119 .01472 L
.96182 .01472 L
.96303 .01472 L
.96431 .01472 L
.9651 .01472 L
.96585 .01472 L
.96653 .01472 L
.96726 .01472 L
.96806 .01472 L
.96891 .01472 L
.96971 .01472 L
.97044 .01472 L
.97118 .01472 L
.97186 .01472 L
.97261 .01472 L
.9734 .01472 L
.97409 .01472 L
.97473 .01472 L
.97544 .01472 L
.97619 .01472 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.5.13"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell[TextData[{
  "As ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " gets larger, the functions become progressively more concentrated. "
}], "MathCaption",
  CellTags->{"S3.5.13", "13.4"}],

Cell[CellGroupData[{

Cell["\<\
Plot[Evaluate[Sqrt[n/Pi] Exp[-n x^2] /. n -> {1, 10, 100}], {x, -2, \
2}, PlotRange->All]\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.5.13"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.0147151 0.104327 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.7381 .00222 -3 -9 ]
[.7381 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.4875 .11904 -6 -4.5 ]
[.4875 .11904 0 4.5 ]
[.4875 .22337 -6 -4.5 ]
[.4875 .22337 0 4.5 ]
[.4875 .3277 -6 -4.5 ]
[.4875 .3277 0 4.5 ]
[.4875 .43202 -6 -4.5 ]
[.4875 .43202 0 4.5 ]
[.4875 .53635 -6 -4.5 ]
[.4875 .53635 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-2)] .02381 .00222 0 1 Mshowa
.2619 .01472 m
.2619 .02097 L
s
[(-1)] .2619 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(1)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .11904 m
.50625 .11904 L
s
[(1)] .4875 .11904 1 0 Mshowa
.5 .22337 m
.50625 .22337 L
s
[(2)] .4875 .22337 1 0 Mshowa
.5 .3277 m
.50625 .3277 L
s
[(3)] .4875 .3277 1 0 Mshowa
.5 .43202 m
.50625 .43202 L
s
[(4)] .4875 .43202 1 0 Mshowa
.5 .53635 m
.50625 .53635 L
s
[(5)] .4875 .53635 1 0 Mshowa
.125 Mabswid
.5 .03558 m
.50375 .03558 L
s
.5 .05645 m
.50375 .05645 L
s
.5 .07731 m
.50375 .07731 L
s
.5 .09818 m
.50375 .09818 L
s
.5 .13991 m
.50375 .13991 L
s
.5 .16077 m
.50375 .16077 L
s
.5 .18164 m
.50375 .18164 L
s
.5 .2025 m
.50375 .2025 L
s
.5 .24424 m
.50375 .24424 L
s
.5 .2651 m
.50375 .2651 L
s
.5 .28597 m
.50375 .28597 L
s
.5 .30683 m
.50375 .30683 L
s
.5 .34856 m
.50375 .34856 L
s
.5 .36943 m
.50375 .36943 L
s
.5 .39029 m
.50375 .39029 L
s
.5 .41116 m
.50375 .41116 L
s
.5 .45289 m
.50375 .45289 L
s
.5 .47376 m
.50375 .47376 L
s
.5 .49462 m
.50375 .49462 L
s
.5 .51549 m
.50375 .51549 L
s
.5 .55722 m
.50375 .55722 L
s
.5 .57808 m
.50375 .57808 L
s
.5 .59895 m
.50375 .59895 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
.5 Mabswid
.02381 .01579 m
.04262 .01618 L
.06244 .01672 L
.08255 .01744 L
.10458 .01845 L
.12415 .01959 L
.14509 .0211 L
.18653 .02512 L
.22646 .03044 L
.26488 .03691 L
.30574 .04497 L
.3451 .05326 L
.38293 .06093 L
.40397 .06474 L
.42322 .06776 L
.44332 .07033 L
.46199 .07209 L
.47118 .07272 L
.47588 .07297 L
.48098 .0732 L
.48389 .07331 L
.48657 .07339 L
.48909 .07345 L
.49184 .07351 L
.49304 .07353 L
.49432 .07354 L
.49543 .07355 L
.49664 .07356 L
.49734 .07357 L
.498 .07357 L
.49928 .07357 L
.50045 .07358 L
.5017 .07357 L
.50284 .07357 L
.50408 .07356 L
.50538 .07355 L
.50659 .07353 L
.50875 .0735 L
.51107 .07345 L
.51636 .0733 L
.52117 .07311 L
.53057 .07261 L
.53945 .07198 L
.55946 .07002 L
.57792 .0676 L
.61732 .06089 L
.65521 .0532 L
.69555 .0447 L
.73437 .03705 L
.77565 .03012 L
Mistroke
.81541 .02489 L
.85365 .0212 L
.87336 .01975 L
.89435 .0185 L
.9158 .0175 L
.93598 .01677 L
.9561 .01622 L
.97459 .01582 L
.97619 .01579 L
Mfstroke
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02721 .01472 L
.02846 .01472 L
.02961 .01472 L
.03068 .01472 L
.03279 .01472 L
.03396 .01472 L
.03506 .01472 L
.03636 .01472 L
.03756 .01472 L
.04 .01472 L
.04134 .01472 L
.04262 .01472 L
.045 .01472 L
.04633 .01472 L
.04753 .01472 L
.04866 .01472 L
.04988 .01472 L
.0521 .01472 L
.05335 .01472 L
.05472 .01472 L
.05605 .01472 L
.05749 .01472 L
.05883 .01472 L
.06005 .01472 L
.06244 .01472 L
.06369 .01472 L
.06505 .01472 L
.06639 .01472 L
.06783 .01472 L
.06917 .01472 L
.0704 .01472 L
.07281 .01472 L
.07417 .01472 L
.07543 .01472 L
.07693 .01472 L
.0783 .01472 L
.0811 .01472 L
.08263 .01472 L
.08408 .01472 L
.08657 .01472 L
.08782 .01472 L
.0892 .01472 L
.09164 .01472 L
.09392 .01472 L
.0953 .01472 L
.0966 .01472 L
.09906 .01472 L
Mistroke
.10043 .01472 L
.1017 .01472 L
.1031 .01472 L
.10458 .01472 L
.10723 .01472 L
.10967 .01472 L
.1123 .01472 L
.11379 .01472 L
.11517 .01472 L
.11769 .01472 L
.11999 .01472 L
.12264 .01472 L
.12514 .01472 L
.12739 .01472 L
.12978 .01472 L
.13182 .01472 L
.13407 .01472 L
.13648 .01472 L
.13907 .01472 L
.14152 .01472 L
.14376 .01472 L
.14625 .01472 L
.14852 .01472 L
.15113 .01472 L
.15359 .01472 L
.15587 .01472 L
.15798 .01472 L
.16028 .01472 L
.16272 .01472 L
.16519 .01472 L
.16783 .01472 L
.17032 .01472 L
.17259 .01472 L
.17526 .01472 L
.17816 .01472 L
.1809 .01472 L
.18344 .01472 L
.18585 .01472 L
.18806 .01472 L
.19049 .01472 L
.19305 .01472 L
.19528 .01472 L
.19736 .01472 L
.19964 .01472 L
.20208 .01472 L
.20474 .01472 L
.20762 .01472 L
.21035 .01472 L
.21286 .01472 L
.21513 .01472 L
Mistroke
.21763 .01472 L
.22023 .01472 L
.22267 .01472 L
.22525 .01472 L
.22764 .01472 L
.23027 .01472 L
.23306 .01472 L
.23573 .01472 L
.23824 .01472 L
.24052 .01472 L
.24293 .01472 L
.24515 .01472 L
.24757 .01472 L
.25184 .01472 L
.25424 .01472 L
.25682 .01472 L
.26146 .01472 L
.26403 .01473 L
.26675 .01473 L
.27165 .01473 L
.27436 .01474 L
.27691 .01474 L
.27974 .01475 L
.28272 .01476 L
.28777 .01478 L
.29241 .01481 L
.29739 .01485 L
.30284 .01491 L
.30814 .015 L
.31313 .01511 L
.31761 .01524 L
.32247 .01543 L
.32777 .01571 L
.33338 .0161 L
.33816 .01655 L
.34343 .01718 L
.34865 .01799 L
.3536 .01896 L
.36289 .02147 L
.36808 .02336 L
.37289 .02548 L
.38379 .0319 L
.39439 .04074 L
.40436 .05179 L
.42299 .0801 L
.46161 .15824 L
.47196 .17674 L
.4816 .19006 L
.48646 .19493 L
.48919 .19705 L
Mistroke
.49166 .19858 L
.49298 .19924 L
.49438 .19981 L
.49511 .20006 L
.49591 .2003 L
.49665 .20048 L
.49733 .20061 L
.49801 .20072 L
.49866 .20079 L
.49935 .20083 L
.50009 .20085 L
.50074 .20083 L
.50144 .20078 L
.50269 .20061 L
.50393 .20034 L
.50529 .19993 L
.50671 .19938 L
.50804 .19874 L
.51296 .19541 L
.51577 .19286 L
.51833 .19013 L
.52409 .18274 L
.54426 .14647 L
.56494 .10317 L
.58409 .06819 L
.59367 .05431 L
.60266 .04371 L
.61205 .03504 L
.61699 .03136 L
.62241 .02796 L
.63223 .02323 L
.63759 .02131 L
.64258 .01987 L
.65152 .01796 L
.65653 .01719 L
.66108 .01663 L
.66593 .01616 L
.67106 .01578 L
.67544 .01553 L
.68026 .01532 L
.68543 .01515 L
.691 .01501 L
.69625 .01492 L
.70105 .01486 L
.70583 .01482 L
.71092 .01479 L
.71572 .01477 L
.72006 .01475 L
.7252 .01474 L
.72809 .01473 L
Mistroke
.73075 .01473 L
.73564 .01473 L
.7381 .01472 L
.7408 .01472 L
.74332 .01472 L
.74605 .01472 L
.74846 .01472 L
.75102 .01472 L
.75333 .01472 L
.75586 .01472 L
.76034 .01472 L
.76305 .01472 L
.76554 .01472 L
.76827 .01472 L
.77114 .01472 L
.77348 .01472 L
.77598 .01472 L
.77872 .01472 L
.78126 .01472 L
.78386 .01472 L
.78661 .01472 L
.78895 .01472 L
.79153 .01472 L
.7943 .01472 L
.79727 .01472 L
.80008 .01472 L
.80264 .01472 L
.80521 .01472 L
.80759 .01472 L
.81021 .01472 L
.81299 .01472 L
.81539 .01472 L
.81765 .01472 L
.82013 .01472 L
.8228 .01472 L
.82519 .01472 L
.82775 .01472 L
.83016 .01472 L
.83235 .01472 L
.83493 .01472 L
.83773 .01472 L
.84037 .01472 L
.84281 .01472 L
.84532 .01472 L
.84768 .01472 L
.85027 .01472 L
.85305 .01472 L
.85595 .01472 L
.85871 .01472 L
.86119 .01472 L
Mistroke
.8639 .01472 L
.86645 .01472 L
.86921 .01472 L
.87182 .01472 L
.87422 .01472 L
.87639 .01472 L
.87877 .01472 L
.88125 .01472 L
.88357 .01472 L
.88488 .01472 L
.88629 .01472 L
.88887 .01472 L
.89138 .01472 L
.8937 .01472 L
.8962 .01472 L
.89762 .01472 L
.89896 .01472 L
.90165 .01472 L
.90316 .01472 L
.90455 .01472 L
.90703 .01472 L
.90929 .01472 L
.91054 .01472 L
.9119 .01472 L
.91436 .01472 L
.91666 .01472 L
.9191 .01472 L
.92119 .01472 L
.92348 .01472 L
.92486 .01472 L
.92617 .01472 L
.92864 .01472 L
.93001 .01472 L
.93129 .01472 L
.93278 .01472 L
.93418 .01472 L
.9354 .01472 L
.93672 .01472 L
.93902 .01472 L
.94033 .01472 L
.94171 .01472 L
.94289 .01472 L
.94418 .01472 L
.94633 .01472 L
.94837 .01472 L
.95035 .01472 L
.95218 .01472 L
.95416 .01472 L
.95634 .01472 L
.95743 .01472 L
Mistroke
.95861 .01472 L
.96075 .01472 L
.96272 .01472 L
.96488 .01472 L
.96692 .01472 L
.96881 .01472 L
.97068 .01472 L
.97238 .01472 L
.97434 .01472 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01472 L
.02954 .01472 L
.03053 .01472 L
.03163 .01472 L
.03279 .01472 L
.03395 .01472 L
.0352 .01472 L
.03638 .01472 L
.03746 .01472 L
.03873 .01472 L
.03944 .01472 L
.04011 .01472 L
.04132 .01472 L
.04262 .01472 L
.04327 .01472 L
.04396 .01472 L
.04519 .01472 L
.04588 .01472 L
.04652 .01472 L
.04722 .01472 L
.04797 .01472 L
.04862 .01472 L
.04933 .01472 L
.05061 .01472 L
.05186 .01472 L
.05302 .01472 L
.05414 .01472 L
.05519 .01472 L
.05634 .01472 L
.05759 .01472 L
.05882 .01472 L
.06012 .01472 L
.06123 .01472 L
.06244 .01472 L
.06315 .01472 L
.06381 .01472 L
.06453 .01472 L
.06529 .01472 L
.06657 .01472 L
.06729 .01472 L
.06797 .01472 L
.06924 .01472 L
.0704 .01472 L
.07103 .01472 L
.07173 .01472 L
.073 .01472 L
Mistroke
.07376 .01472 L
.07448 .01472 L
.07513 .01472 L
.07583 .01472 L
.0766 .01472 L
.0774 .01472 L
.07809 .01472 L
.07885 .01472 L
.07956 .01472 L
.0802 .01472 L
.08095 .01472 L
.08166 .01472 L
.08291 .01472 L
.08362 .01472 L
.08427 .01472 L
.08544 .01472 L
.08669 .01472 L
.08787 .01472 L
.08896 .01472 L
.09016 .01472 L
.09148 .01472 L
.09214 .01472 L
.09285 .01472 L
.09413 .01472 L
.09483 .01472 L
.09548 .01472 L
.09619 .01472 L
.09695 .01472 L
.09821 .01472 L
.09893 .01472 L
.09961 .01472 L
.10086 .01472 L
.10201 .01472 L
.10333 .01472 L
.10458 .01472 L
.10572 .01472 L
.10694 .01472 L
.1081 .01472 L
.10916 .01472 L
.11033 .01472 L
.11162 .01472 L
.11227 .01472 L
.11297 .01472 L
.11422 .01472 L
.11491 .01472 L
.11554 .01472 L
.11624 .01472 L
.11698 .01472 L
.11822 .01472 L
.11892 .01472 L
Mistroke
.11958 .01472 L
.12081 .01472 L
.12194 .01472 L
.12323 .01472 L
.12446 .01472 L
.12562 .01472 L
.12668 .01472 L
.12789 .01472 L
.12903 .01472 L
.13009 .01472 L
.13107 .01472 L
.13214 .01472 L
.13327 .01472 L
.13441 .01472 L
.13564 .01472 L
.1368 .01472 L
.13785 .01472 L
.13909 .01472 L
.13979 .01472 L
.14043 .01472 L
.14162 .01472 L
.14288 .01472 L
.14402 .01472 L
.14526 .01472 L
.14656 .01472 L
.14777 .01472 L
.14891 .01472 L
.14994 .01472 L
.15113 .01472 L
.15226 .01472 L
.15348 .01472 L
.15478 .01472 L
.15589 .01472 L
.15711 .01472 L
.15842 .01472 L
.15915 .01472 L
.15982 .01472 L
.16113 .01472 L
.16236 .01472 L
.16352 .01472 L
.16456 .01472 L
.16577 .01472 L
.1669 .01472 L
.16796 .01472 L
.16893 .01472 L
.16999 .01472 L
.17111 .01472 L
.17225 .01472 L
.17347 .01472 L
.17462 .01472 L
Mistroke
.17566 .01472 L
.17689 .01472 L
.17758 .01472 L
.17823 .01472 L
.1794 .01472 L
.18065 .01472 L
.18185 .01472 L
.18316 .01472 L
.18441 .01472 L
.18556 .01472 L
.1867 .01472 L
.18773 .01472 L
.18893 .01472 L
.19005 .01472 L
.19128 .01472 L
.19258 .01472 L
.19369 .01472 L
.19491 .01472 L
.19623 .01472 L
.19696 .01472 L
.19763 .01472 L
.19894 .01472 L
.20017 .01472 L
.20122 .01472 L
.20238 .01472 L
.20359 .01472 L
.20472 .01472 L
.20578 .01472 L
.20675 .01472 L
.20781 .01472 L
.20894 .01472 L
.21008 .01472 L
.21129 .01472 L
.21244 .01472 L
.21349 .01472 L
.21472 .01472 L
.21541 .01472 L
.21605 .01472 L
.21723 .01472 L
.21847 .01472 L
.21968 .01472 L
.221 .01472 L
.22224 .01472 L
.2234 .01472 L
.22454 .01472 L
.22558 .01472 L
.22677 .01472 L
.2279 .01472 L
.22914 .01472 L
.23044 .01472 L
Mistroke
.23155 .01472 L
.23277 .01472 L
.23409 .01472 L
.23482 .01472 L
.2355 .01472 L
.2368 .01472 L
.23804 .01472 L
.23909 .01472 L
.24025 .01472 L
.24146 .01472 L
.2426 .01472 L
.24365 .01472 L
.24462 .01472 L
.24569 .01472 L
.24681 .01472 L
.24795 .01472 L
.24917 .01472 L
.25032 .01472 L
.25137 .01472 L
.2526 .01472 L
.25329 .01472 L
.25393 .01472 L
.2551 .01472 L
.25635 .01472 L
.25756 .01472 L
.25888 .01472 L
.26013 .01472 L
.26129 .01472 L
.26233 .01472 L
.26348 .01472 L
.26467 .01472 L
.2658 .01472 L
.26704 .01472 L
.26835 .01472 L
.26946 .01472 L
.27068 .01472 L
.272 .01472 L
.27274 .01472 L
.27341 .01472 L
.27472 .01472 L
.27595 .01472 L
.27701 .01472 L
.27817 .01472 L
.27938 .01472 L
.28052 .01472 L
.28158 .01472 L
.28255 .01472 L
.28367 .01472 L
.28474 .01472 L
.28588 .01472 L
Mistroke
.2871 .01472 L
.28825 .01472 L
.2893 .01472 L
.29053 .01472 L
.29122 .01472 L
.29186 .01472 L
.29303 .01472 L
.29427 .01472 L
.29549 .01472 L
.29618 .01472 L
.29682 .01472 L
.29799 .01472 L
.29923 .01472 L
.30034 .01472 L
.30138 .01472 L
.30252 .01472 L
.30375 .01472 L
.30499 .01472 L
.30569 .01472 L
.30634 .01472 L
.30765 .01472 L
.30839 .01472 L
.30906 .01472 L
.31026 .01472 L
.31156 .01472 L
.31278 .01472 L
.31392 .01472 L
.31497 .01472 L
.31611 .01472 L
.31718 .01472 L
.31816 .01472 L
.3193 .01472 L
.32055 .01472 L
.32173 .01472 L
.32282 .01472 L
.32406 .01472 L
.32522 .01472 L
.32626 .01472 L
.32739 .01472 L
.32862 .01472 L
.32992 .01472 L
.33103 .01472 L
.33225 .01472 L
.33356 .01472 L
.33477 .01472 L
.33541 .01472 L
.3361 .01472 L
.33683 .01472 L
.33751 .01472 L
.33876 .01472 L
Mistroke
.33991 .01472 L
.34123 .01472 L
.34249 .01472 L
.3436 .01472 L
.3448 .01472 L
.34592 .01472 L
.34694 .01472 L
.34814 .01472 L
.34945 .01472 L
.35067 .01472 L
.35181 .01472 L
.35302 .01472 L
.35431 .01472 L
.35554 .01472 L
.35665 .01472 L
.35796 .01472 L
.3587 .01472 L
.35939 .01472 L
.36064 .01472 L
.36128 .01472 L
.36198 .01472 L
.36266 .01472 L
.36337 .01472 L
.36465 .01472 L
.36536 .01472 L
.36602 .01472 L
.36675 .01472 L
.36753 .01472 L
.3682 .01472 L
.36893 .01472 L
.36962 .01472 L
.37026 .01472 L
.37146 .01472 L
.37274 .01472 L
.37394 .01472 L
.37526 .01472 L
.37651 .01472 L
.37766 .01472 L
.3788 .01472 L
.37984 .01472 L
.38103 .01472 L
.38216 .01472 L
.38339 .01472 L
.3847 .01472 L
.38581 .01472 L
.38703 .01472 L
.38834 .01472 L
.38908 .01472 L
.38975 .01472 L
.39106 .01472 L
Mistroke
.39229 .01472 L
.39334 .01472 L
.3945 .01472 L
.39571 .01472 L
.39685 .01472 L
.39791 .01472 L
.39888 .01472 L
.39994 .01472 L
.40106 .01472 L
.40221 .01472 L
.40342 .01472 L
.40457 .01472 L
.40562 .01472 L
.40685 .01472 L
.40754 .01472 L
.40818 .01472 L
.40936 .01472 L
.4106 .01472 L
.41181 .01472 L
.41313 .01472 L
.41438 .01472 L
.41554 .01472 L
.41669 .01472 L
.41772 .01472 L
.41892 .01472 L
.42005 .01472 L
.42129 .01473 L
.42259 .01473 L
.42371 .01474 L
.42493 .01474 L
.42624 .01476 L
.42765 .01477 L
.42898 .0148 L
.43019 .01482 L
.43133 .01486 L
.43254 .01491 L
.43357 .01496 L
.43471 .01503 L
.43593 .01514 L
.43724 .01528 L
.43848 .01546 L
.43961 .01566 L
.44179 .01621 L
.44303 .01663 L
.44417 .01713 L
.44627 .01833 L
.44745 .01922 L
.44851 .0202 L
.45084 .023 L
.45216 .02509 L
Mistroke
.45339 .02746 L
.45587 .03368 L
.45854 .04307 L
.46101 .05502 L
.46336 .06983 L
.46776 .10877 L
.47027 .13848 L
.47294 .1764 L
.47773 .26007 L
.48339 .37643 L
.48858 .48227 L
.49094 .52396 L
.49314 .55641 L
.49543 .58206 L
.49665 .59176 L
.49794 .59894 L
.49925 .60273 L
.49999 .60332 L
.50066 .60286 L
.50191 .59953 L
.50323 .59256 L
.50442 .58341 L
.50552 .57247 L
.50804 .53985 L
.51265 .45862 L
.51685 .37133 L
.52632 .18812 L
.5311 .12157 L
.53377 .09343 L
.53619 .07312 L
.53846 .05805 L
.5409 .04548 L
.54322 .03654 L
.54534 .03038 L
.54654 .0276 L
.54783 .02512 L
.55015 .02168 L
.55157 .02011 L
.55292 .01893 L
.55543 .01732 L
.55672 .01674 L
.55808 .01625 L
.55925 .01592 L
.56053 .01563 L
.56191 .0154 L
.56339 .01521 L
.56479 .01507 L
.56608 .01498 L
.56736 .01491 L
.56857 .01486 L
Mistroke
.56966 .01483 L
.57083 .0148 L
.57211 .01478 L
.57347 .01476 L
.57463 .01475 L
.5759 .01474 L
.57709 .01473 L
.57818 .01473 L
.57944 .01472 L
.58062 .01472 L
.58172 .01472 L
.58274 .01472 L
.58385 .01472 L
.58504 .01472 L
.58631 .01472 L
.58748 .01472 L
.58876 .01472 L
.5894 .01472 L
.59011 .01472 L
.5913 .01472 L
.59258 .01472 L
.59378 .01472 L
.59488 .01472 L
.59555 .01472 L
.59627 .01472 L
.59756 .01472 L
.59827 .01472 L
.59894 .01472 L
.59968 .01472 L
.60047 .01472 L
.60114 .01472 L
.60188 .01472 L
.60258 .01472 L
.60323 .01472 L
.60445 .01472 L
.60575 .01472 L
.60699 .01472 L
.6077 .01472 L
.60836 .01472 L
.60905 .01472 L
.60969 .01472 L
.61042 .01472 L
.61111 .01472 L
.61234 .01472 L
.61347 .01472 L
.61472 .01472 L
.61535 .01472 L
.61604 .01472 L
.61674 .01472 L
.61748 .01472 L
Mistroke
.61881 .01472 L
.61954 .01472 L
.62023 .01472 L
.62098 .01472 L
.62178 .01472 L
.62248 .01472 L
.62324 .01472 L
.62395 .01472 L
.62461 .01472 L
.62585 .01472 L
.62717 .01472 L
.62842 .01472 L
.62957 .01472 L
.63089 .01472 L
.63214 .01472 L
.63329 .01472 L
.63436 .01472 L
.63553 .01472 L
.63678 .01472 L
.6375 .01472 L
.63816 .01472 L
.63888 .01472 L
.63964 .01472 L
.64092 .01472 L
.64165 .01472 L
.64233 .01472 L
.6436 .01472 L
.64475 .01472 L
.64539 .01472 L
.64609 .01472 L
.64735 .01472 L
.64857 .01472 L
.64969 .01472 L
.65098 .01472 L
.65222 .01472 L
.65335 .01472 L
.6544 .01472 L
.65555 .01472 L
.65678 .01472 L
.65748 .01472 L
.65813 .01472 L
.65883 .01472 L
.65958 .01472 L
.66084 .01472 L
.66156 .01472 L
.66223 .01472 L
.66347 .01472 L
.66461 .01472 L
.66593 .01472 L
.66717 .01472 L
Mistroke
.66838 .01472 L
.66906 .01472 L
.66971 .01472 L
.671 .01472 L
.67173 .01472 L
.6724 .01472 L
.67352 .01472 L
.67476 .01472 L
.67604 .01472 L
.67724 .01472 L
.67792 .01472 L
.67867 .01472 L
.67937 .01472 L
.68001 .01472 L
.68124 .01472 L
.68254 .01472 L
.68321 .01472 L
.68393 .01472 L
.68523 .01472 L
.68602 .01472 L
.68678 .01472 L
.68746 .01472 L
.6882 .01472 L
.68884 .01472 L
.68953 .01472 L
.69075 .01472 L
.69207 .01472 L
.69282 .01472 L
.69352 .01472 L
.69479 .01472 L
.69594 .01472 L
.69658 .01472 L
.69727 .01472 L
.69853 .01472 L
.69965 .01472 L
.70089 .01472 L
.70218 .01472 L
.7034 .01472 L
.70453 .01472 L
.70556 .01472 L
.7067 .01472 L
.7079 .01472 L
.70921 .01472 L
.71041 .01472 L
.71107 .01472 L
.71179 .01472 L
.71309 .01472 L
.71431 .01472 L
.7156 .01472 L
.71671 .01472 L
Mistroke
.71792 .01472 L
.71865 .01472 L
.71935 .01472 L
.72065 .01472 L
.72138 .01472 L
.72205 .01472 L
.7228 .01472 L
.72358 .01472 L
.72488 .01472 L
.7261 .01472 L
.72679 .01472 L
.72743 .01472 L
.72814 .01472 L
.72888 .01472 L
.73011 .01472 L
.7308 .01472 L
.73144 .01472 L
.73262 .01472 L
.73386 .01472 L
.73498 .01472 L
.73602 .01472 L
.73717 .01472 L
.7384 .01472 L
.7397 .01472 L
.74044 .01472 L
.74112 .01472 L
.74238 .01472 L
.74308 .01472 L
.74372 .01472 L
.74492 .01472 L
.74622 .01472 L
.74745 .01472 L
.74858 .01472 L
.74964 .01472 L
.75078 .01472 L
.75186 .01472 L
.75284 .01472 L
.75398 .01472 L
.75523 .01472 L
.75641 .01472 L
.75751 .01472 L
.75863 .01472 L
.75968 .01472 L
.76083 .01472 L
.76208 .01472 L
.76331 .01472 L
.76461 .01472 L
.76572 .01472 L
.76694 .01472 L
.76826 .01472 L
Mistroke
.76947 .01472 L
.77011 .01472 L
.77081 .01472 L
.77154 .01472 L
.77222 .01472 L
.77348 .01472 L
.77463 .01472 L
.77526 .01472 L
.77595 .01472 L
.77721 .01472 L
.77844 .01472 L
.77956 .01472 L
.78085 .01472 L
.78206 .01472 L
.78318 .01472 L
.78422 .01472 L
.78535 .01472 L
.78655 .01472 L
.78786 .01472 L
.78905 .01472 L
.78971 .01472 L
.79042 .01472 L
.79172 .01472 L
.79294 .01472 L
.79423 .01472 L
.79533 .01472 L
.79654 .01472 L
.79724 .01472 L
.79797 .01472 L
.79927 .01472 L
.79999 .01472 L
.80067 .01472 L
.80141 .01472 L
.8022 .01472 L
.80289 .01472 L
.80363 .01472 L
.80433 .01472 L
.80498 .01472 L
.8062 .01472 L
.8075 .01472 L
.80872 .01472 L
.8094 .01472 L
.81004 .01472 L
.81121 .01472 L
.81245 .01472 L
.81355 .01472 L
.81459 .01472 L
.81573 .01472 L
.81696 .01472 L
.81819 .01472 L
Mistroke
.81889 .01472 L
.81954 .01472 L
.82085 .01472 L
.82159 .01472 L
.82226 .01472 L
.82346 .01472 L
.82476 .01472 L
.82598 .01472 L
.82712 .01472 L
.82817 .01472 L
.8293 .01472 L
.83037 .01472 L
.83135 .01472 L
.83249 .01472 L
.83374 .01472 L
.83492 .01472 L
.83601 .01472 L
.83725 .01472 L
.83841 .01472 L
.83945 .01472 L
.84058 .01472 L
.84181 .01472 L
.84311 .01472 L
.84422 .01472 L
.84544 .01472 L
.84675 .01472 L
.84796 .01472 L
.84859 .01472 L
.84928 .01472 L
.85001 .01472 L
.85069 .01472 L
.85194 .01472 L
.85308 .01472 L
.85434 .01472 L
.85566 .01472 L
.85677 .01472 L
.85796 .01472 L
.85909 .01472 L
.86011 .01472 L
.86131 .01472 L
.86261 .01472 L
.86384 .01472 L
.86497 .01472 L
.86618 .01472 L
.86747 .01472 L
.86869 .01472 L
.86981 .01472 L
.87112 .01472 L
.87186 .01472 L
.87254 .01472 L
Mistroke
.8738 .01472 L
.8745 .01472 L
.87513 .01472 L
.87581 .01472 L
.87652 .01472 L
.8778 .01472 L
.87851 .01472 L
.87917 .01472 L
.8799 .01472 L
.88068 .01472 L
.88135 .01472 L
.88208 .01472 L
.88277 .01472 L
.88341 .01472 L
.88461 .01472 L
.88589 .01472 L
.88709 .01472 L
.88841 .01472 L
.88965 .01472 L
.8908 .01472 L
.89194 .01472 L
.89298 .01472 L
.89417 .01472 L
.8953 .01472 L
.89653 .01472 L
.89783 .01472 L
.89894 .01472 L
.90016 .01472 L
.90147 .01472 L
.90221 .01472 L
.90288 .01472 L
.90418 .01472 L
.90542 .01472 L
.90647 .01472 L
.90762 .01472 L
.90883 .01472 L
.90997 .01472 L
.91103 .01472 L
.91199 .01472 L
.91306 .01472 L
.91418 .01472 L
.91532 .01472 L
.91654 .01472 L
.91769 .01472 L
.91873 .01472 L
.91996 .01472 L
.92066 .01472 L
.9213 .01472 L
.92247 .01472 L
.92371 .01472 L
Mistroke
.92492 .01472 L
.92624 .01472 L
.92749 .01472 L
.92864 .01472 L
.92979 .01472 L
.93082 .01472 L
.93202 .01472 L
.93315 .01472 L
.93438 .01472 L
.93569 .01472 L
.9368 .01472 L
.93802 .01472 L
.93933 .01472 L
.94007 .01472 L
.94074 .01472 L
.94205 .01472 L
.94328 .01472 L
.94433 .01472 L
.94549 .01472 L
.94671 .01472 L
.94784 .01472 L
.9489 .01472 L
.94987 .01472 L
.95094 .01472 L
.95206 .01472 L
.9532 .01472 L
.95442 .01472 L
.95557 .01472 L
.95661 .01472 L
.95784 .01472 L
.95854 .01472 L
.95918 .01472 L
.96035 .01472 L
.96159 .01472 L
.96257 .01472 L
.9635 .01472 L
.96433 .01472 L
.96523 .01472 L
.96622 .01472 L
.96726 .01472 L
.96815 .01472 L
.96914 .01472 L
.97005 .01472 L
.97089 .01472 L
.97181 .01472 L
.97277 .01472 L
.97362 .01472 L
.9744 .01472 L
.97527 .01472 L
.97619 .01472 L
Mistroke
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.5.13"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell[TextData[{
  "For any ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], ">", "0"}], TraditionalForm]], "InlineFormula"],
  ", their integrals are nevertheless always equal to 1. "
}], "MathCaption",
  CellTags->{"S3.5.13", "13.5"}],

Cell[CellGroupData[{

Cell["\<\
Integrate[Sqrt[n/Pi] Exp[-n x^2], {x, -Infinity, Infinity}, \
Assumptions -> n > 0]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.5.13"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell[TextData[{
  "The limit of the functions for infinite ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is effectively a Dirac delta function, whose integral is again 1. "
}], "MathCaption",
  CellTags->{"S3.5.13", "13.6"}],

Cell[CellGroupData[{

Cell["Integrate[DiracDelta[x], {x, -Infinity, Infinity}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.5.13"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell[TextData[{
  StyleBox["DiracDelta", "MR"],
  " evaluates to 0 at all real points except ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.13", "13.7"}],

Cell[CellGroupData[{

Cell["Table[DiracDelta[x], {x, -3, 3}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.5.13"],

Cell[BoxData[
    \({0, 0, 0, DiracDelta[0], 0, 0, 0}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell["\<\
Inserting a delta function in an integral effectively causes the \
integrand to be sampled at discrete points where the argument of the delta \
function vanishes. \
\>", "Text",
  CellTags->{"S3.5.13", "13.8"}],

Cell[TextData[{
  "This samples the function ",
  StyleBox["f", "MR"],
  " with argument ",
  StyleBox["2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.13", "13.9"}],

Cell[CellGroupData[{

Cell["Integrate[DiracDelta[x - 2] f[x], {x, -4, 4}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.5.13"],

Cell[BoxData[
    \(f[2]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell["Here is a slightly more complicated example. ", "MathCaption",
  CellTags->{"S3.5.13", "13.10"}],

Cell[CellGroupData[{

Cell["Integrate[DiracDelta[x^2 - x - 1], {x, 0, 2}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.5.13"],

Cell[BoxData[
    \(1\/\@5\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell[TextData[{
  "This effectively counts the number of zeros of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"cos", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " in the region of integration. "
}], "MathCaption",
  CellTags->{"S3.5.13", "13.11"}],

Cell[CellGroupData[{

Cell["Integrate[DiracDelta[Cos[x]], {x, -30, 30}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.5.13"],

Cell[BoxData[
    \(20\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["unit step function", "TB"],
  " ",
  StyleBox["UnitStep[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " is effectively the indefinite integral of the delta function. It is \
sometimes known as the ",
  StyleBox["Heaviside function", "TB"],
  ", and is variously denoted ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["H",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Theta]", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Mu]", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["U",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". It does not need to be considered as a generalized function, though it \
has a discontinuity at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". The unit step function is often used in setting up piecewise continuous \
functions, and in representing signals and other quantities that become non\
\[Hyphen]zero only beyond some point. "
}], "Text",
  CellTags->{"S3.5.13", "13.12"}],

Cell["\<\
The indefinite integral of the delta function is the unit step \
function. \
\>", "MathCaption",
  CellTags->{"S3.5.13", "13.13"}],

Cell[CellGroupData[{

Cell["Integrate[DiracDelta[x], x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.5.13"],

Cell[BoxData[
    \(UnitStep[x]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell["This generates a square wave. ", "MathCaption",
  CellTags->{"S3.5.13", "13.14"}],

Cell[CellGroupData[{

Cell["Plot[UnitStep[Sin[x]], {x, 0, 30}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.5.13"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.031746 0.0147151 0.588604 [
[.18254 .00222 -3 -9 ]
[.18254 .00222 3 0 ]
[.34127 .00222 -6 -9 ]
[.34127 .00222 6 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.65873 .00222 -6 -9 ]
[.65873 .00222 6 0 ]
[.81746 .00222 -6 -9 ]
[.81746 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .13244 -18 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -18 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -18 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -18 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .01472 m
.18254 .02097 L
s
[(5)] .18254 .00222 0 1 Mshowa
.34127 .01472 m
.34127 .02097 L
s
[(10)] .34127 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(15)] .5 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(20)] .65873 .00222 0 1 Mshowa
.81746 .01472 m
.81746 .02097 L
s
[(25)] .81746 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(30)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.15079 .01472 m
.15079 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.27778 .01472 m
.27778 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.53175 .01472 m
.53175 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.9127 .01472 m
.9127 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13244 m
.03006 .13244 L
s
[(0.2)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(0.4)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(0.6)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(0.8)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .16187 m
.02756 .16187 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .60332 L
.08255 .60332 L
.0932 .60332 L
.10458 .60332 L
.11009 .60332 L
.11531 .60332 L
.11999 .60332 L
.12127 .60332 L
.12197 .60332 L
.12263 .60332 L
.12379 .01472 L
.12507 .01472 L
.12624 .01472 L
.12753 .01472 L
.12874 .01472 L
.12987 .01472 L
.13098 .01472 L
.13199 .01472 L
.13316 .01472 L
.13426 .01472 L
.13546 .01472 L
.13674 .01472 L
.13782 .01472 L
.13901 .01472 L
.1403 .01472 L
.14101 .01472 L
.14167 .01472 L
.14294 .01472 L
.14415 .01472 L
.14529 .01472 L
.14652 .01472 L
.14768 .01472 L
.14874 .01472 L
.14992 .01472 L
.15121 .01472 L
.15186 .01472 L
.15255 .01472 L
.15381 .01472 L
.1545 .01472 L
.15513 .01472 L
.15583 .01472 L
.15657 .01472 L
.15781 .01472 L
.15852 .01472 L
.15918 .01472 L
.16041 .01472 L
.16153 .01472 L
.16283 .01472 L
.16406 .01472 L
Mistroke
.16522 .01472 L
.16628 .01472 L
.16749 .01472 L
.16863 .01472 L
.1697 .01472 L
.17067 .01472 L
.17174 .01472 L
.17287 .01472 L
.17402 .01472 L
.17525 .01472 L
.1764 .01472 L
.17746 .01472 L
.17869 .01472 L
.17939 .01472 L
.18004 .01472 L
.18122 .01472 L
.18248 .01472 L
.18362 .01472 L
.18487 .01472 L
.18618 .01472 L
.18739 .01472 L
.18852 .01472 L
.18956 .01472 L
.19075 .01472 L
.19188 .01472 L
.19311 .01472 L
.19441 .01472 L
.19551 .01472 L
.19673 .01472 L
.19804 .01472 L
.19878 .01472 L
.19945 .01472 L
.20076 .01472 L
.20199 .01472 L
.20304 .01472 L
.2042 .01472 L
.2054 .01472 L
.20654 .01472 L
.2076 .01472 L
.20856 .01472 L
.20963 .01472 L
.21075 .01472 L
.21189 .01472 L
.21311 .01472 L
.21426 .01472 L
.2153 .01472 L
.21653 .01472 L
.21722 .01472 L
.21786 .01472 L
.21904 .01472 L
Mistroke
.22028 .01472 L
.22149 .01472 L
.22281 .01472 L
.22405 .60332 L
.22521 .60332 L
.2297 .60332 L
.23983 .60332 L
.25814 .60332 L
.29729 .60332 L
.30758 .60332 L
.313 .60332 L
.31596 .60332 L
.31872 .60332 L
.32114 .60332 L
.32183 .60332 L
.32249 .60332 L
.32373 .01472 L
.32439 .01472 L
.3251 .01472 L
.32636 .01472 L
.32706 .01472 L
.32772 .01472 L
.32845 .01472 L
.32923 .01472 L
.3304 .01472 L
.33168 .01472 L
.33233 .01472 L
.33302 .01472 L
.33427 .01472 L
.33552 .01472 L
.33669 .01472 L
.33775 .01472 L
.33889 .01472 L
.34012 .01472 L
.34125 .01472 L
.34255 .01472 L
.34379 .01472 L
.34492 .01472 L
.34598 .01472 L
.34713 .01472 L
.34837 .01472 L
.34907 .01472 L
.34972 .01472 L
.35043 .01472 L
.35118 .01472 L
.35245 .01472 L
.35316 .01472 L
.35383 .01472 L
.35508 .01472 L
.35622 .01472 L
Mistroke
.35754 .01472 L
.35878 .01472 L
.35999 .01472 L
.36068 .01472 L
.36133 .01472 L
.36263 .01472 L
.36336 .01472 L
.36403 .01472 L
.36521 .01472 L
.36651 .01472 L
.36774 .01472 L
.36887 .01472 L
.36956 .01472 L
.3703 .01472 L
.37101 .01472 L
.37165 .01472 L
.37288 .01472 L
.37418 .01472 L
.37485 .01472 L
.37557 .01472 L
.37687 .01472 L
.37767 .01472 L
.37842 .01472 L
.37909 .01472 L
.37983 .01472 L
.38105 .01472 L
.38216 .01472 L
.38338 .01472 L
.38467 .01472 L
.3858 .01472 L
.38685 .01472 L
.388 .01472 L
.38922 .01472 L
.38992 .01472 L
.39056 .01472 L
.39127 .01472 L
.39202 .01472 L
.39327 .01472 L
.39399 .01472 L
.39466 .01472 L
.3959 .01472 L
.39704 .01472 L
.39835 .01472 L
.39959 .01472 L
.40028 .01472 L
.40092 .01472 L
.40212 .01472 L
.40341 .01472 L
.40414 .01472 L
.40481 .01472 L
Mistroke
.40593 .01472 L
.40716 .01472 L
.40844 .01472 L
.40964 .01472 L
.41032 .01472 L
.41107 .01472 L
.41176 .01472 L
.41241 .01472 L
.41364 .01472 L
.41493 .01472 L
.4156 .01472 L
.41632 .01472 L
.41763 .01472 L
.41838 .01472 L
.41918 .01472 L
.41986 .01472 L
.4206 .01472 L
.42124 .01472 L
.42192 .01472 L
.42314 .60332 L
.42446 .60332 L
.4259 .60332 L
.43089 .60332 L
.44024 .60332 L
.4612 .60332 L
.48231 .60332 L
.50158 .60332 L
.51113 .60332 L
.51617 .60332 L
.51893 .60332 L
.52028 .60332 L
.52153 .60332 L
.52262 .01472 L
.52377 .01472 L
.52493 .01472 L
.52619 .01472 L
.52748 .01472 L
.5282 .01472 L
.52886 .01472 L
.53014 .01472 L
.53135 .01472 L
.53245 .01472 L
.53362 .01472 L
.53461 .01472 L
.53571 .01472 L
.53689 .01472 L
.53815 .01472 L
.53935 .01472 L
.54044 .01472 L
.54173 .01472 L
Mistroke
.54294 .01472 L
.54403 .01472 L
.54521 .01472 L
.5465 .01472 L
.54715 .01472 L
.54786 .01472 L
.54912 .01472 L
.55029 .01472 L
.55148 .01472 L
.5526 .01472 L
.55361 .01472 L
.55471 .01472 L
.5559 .01472 L
.55716 .01472 L
.55824 .01472 L
.55943 .01472 L
.56074 .01472 L
.5614 .01472 L
.56212 .01472 L
.56339 .01472 L
.56458 .01472 L
.5653 .01472 L
.56599 .01472 L
.56726 .01472 L
.56798 .01472 L
.56864 .01472 L
.56936 .01472 L
.57013 .01472 L
.57132 .01472 L
.57259 .01472 L
.5738 .01472 L
.5749 .01472 L
.57619 .01472 L
.57692 .01472 L
.5776 .01472 L
.57884 .01472 L
.58016 .01472 L
.58141 .01472 L
.58212 .01472 L
.58278 .01472 L
.58347 .01472 L
.58411 .01472 L
.58484 .01472 L
.58554 .01472 L
.58677 .01472 L
.5879 .01472 L
.58915 .01472 L
.58978 .01472 L
.59048 .01472 L
.59122 .01472 L
Mistroke
.59192 .01472 L
.59255 .01472 L
.59325 .01472 L
.59399 .01472 L
.59479 .01472 L
.59554 .01472 L
.59623 .01472 L
.59692 .01472 L
.59756 .01472 L
.59826 .01472 L
.599 .01472 L
.60025 .01472 L
.60096 .01472 L
.60162 .01472 L
.60287 .01472 L
.60358 .01472 L
.60423 .01472 L
.60543 .01472 L
.60671 .01472 L
.60785 .01472 L
.60892 .01472 L
.61009 .01472 L
.61136 .01472 L
.61262 .01472 L
.61334 .01472 L
.61401 .01472 L
.61472 .01472 L
.61536 .01472 L
.6161 .01472 L
.6168 .01472 L
.61805 .01472 L
.6192 .01472 L
.62046 .01472 L
.6211 .01472 L
.6218 .01472 L
.62309 .60332 L
.62429 .60332 L
.62701 .60332 L
.63195 .60332 L
.64123 .60332 L
.66212 .60332 L
.68093 .60332 L
.70127 .60332 L
.70671 .60332 L
.71244 .60332 L
.71734 .60332 L
.71868 .60332 L
.72012 .60332 L
.72081 .60332 L
.72147 .60332 L
Mistroke
.72271 .01472 L
.72387 .01472 L
.72514 .01472 L
.72579 .01472 L
.72648 .01472 L
.72773 .01472 L
.72891 .01472 L
.73015 .01472 L
.73122 .01472 L
.73238 .01472 L
.73309 .01472 L
.73376 .01472 L
.73501 .01472 L
.73571 .01472 L
.73636 .01472 L
.73707 .01472 L
.73782 .01472 L
.73907 .01472 L
.74023 .01472 L
.74151 .01472 L
.74223 .01472 L
.74288 .01472 L
.74418 .01472 L
.7454 .01472 L
.74649 .01472 L
.74767 .01472 L
.74897 .01472 L
.74962 .01472 L
.75033 .01472 L
.75159 .01472 L
.75277 .01472 L
.75396 .01472 L
.75509 .01472 L
.7561 .01472 L
.75719 .01472 L
.75839 .01472 L
.75966 .01472 L
.76074 .01472 L
.76193 .01472 L
.76259 .01472 L
.76331 .01472 L
.76462 .01472 L
.7659 .01472 L
.76709 .01472 L
.76781 .01472 L
.7685 .01472 L
.76977 .01472 L
.77049 .01472 L
.77115 .01472 L
.77187 .01472 L
Mistroke
.77264 .01472 L
.77383 .01472 L
.77511 .01472 L
.77632 .01472 L
.77742 .01472 L
.77871 .01472 L
.77944 .01472 L
.78012 .01472 L
.78136 .01472 L
.78267 .01472 L
.78381 .01472 L
.78505 .01472 L
.78635 .01472 L
.78756 .01472 L
.78869 .01472 L
.78973 .01472 L
.79092 .01472 L
.79204 .01472 L
.79327 .01472 L
.79456 .01472 L
.79567 .01472 L
.79689 .01472 L
.79819 .01472 L
.79893 .01472 L
.7996 .01472 L
.8009 .01472 L
.80214 .01472 L
.80329 .01472 L
.80434 .01472 L
.80554 .01472 L
.80668 .01472 L
.80773 .01472 L
.8087 .01472 L
.80976 .01472 L
.81088 .01472 L
.81202 .01472 L
.81324 .01472 L
.81439 .01472 L
.81543 .01472 L
.81666 .01472 L
.81735 .01472 L
.81799 .01472 L
.81917 .01472 L
.82042 .01472 L
.82156 .01472 L
.82281 .60332 L
.82411 .60332 L
.82532 .60332 L
.82981 .60332 L
.83993 .60332 L
Mistroke
.85822 .60332 L
.89731 .60332 L
.90758 .60332 L
.91298 .60332 L
.91593 .60332 L
.91869 .60332 L
.91993 .60332 L
.9211 .60332 L
.92175 .01472 L
.92246 .01472 L
.92369 .01472 L
.92435 .01472 L
.92508 .01472 L
.92583 .01472 L
.92655 .01472 L
.92782 .01472 L
.92853 .01472 L
.92919 .01472 L
.93035 .01472 L
.93144 .01472 L
.93262 .01472 L
.9339 .01472 L
.93454 .01472 L
.93523 .01472 L
.93649 .01472 L
.93772 .01472 L
.93885 .01472 L
.94004 .01472 L
.94116 .01472 L
.94217 .01472 L
.94328 .01472 L
.94447 .01472 L
.94574 .01472 L
.94694 .01472 L
.94803 .01472 L
.94914 .01472 L
.95016 .01472 L
.95128 .01472 L
.95246 .01472 L
.95349 .01472 L
.95444 .01472 L
.9555 .01472 L
.95662 .01472 L
.95793 .01472 L
.95914 .01472 L
.95978 .01472 L
.96047 .01472 L
.9612 .01472 L
.96188 .01472 L
.96313 .01472 L
Mistroke
.96428 .01472 L
.96554 .01472 L
.96617 .01472 L
.96686 .01472 L
.96809 .01472 L
.9692 .01472 L
.97048 .01472 L
.97169 .01472 L
.97282 .01472 L
.97385 .01472 L
.97499 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.5.13"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell["Here is the integral of the square wave. ", "MathCaption",
  CellTags->{"S3.5.13", "13.15"}],

Cell[CellGroupData[{

Cell["Integrate[UnitStep[Sin[x]], {x, 0, 30}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.5.13"],

Cell[BoxData[
    \(5\ \[Pi]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell[TextData[{
  "The value of the integral depends on whether ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  " lies in the interval ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-2\), 2)\)\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.13", "13.16"}],

Cell[CellGroupData[{

Cell["Integrate[f[x] DiracDelta[x - a], {x, -2, 2}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.5.13"],

Cell[BoxData[
    \(f[a]\ UnitStep[2 - a]\ UnitStep[2 + a]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell[TextData[{
  StyleBox["DiracDelta", "MR"],
  " and ",
  StyleBox["UnitStep", "MR"],
  " often arise in doing integral transforms. "
}], "Text",
  CellTags->{"S3.5.13", "13.17"}],

Cell["\<\
The Fourier transform of a constant function is a delta function. \
\
\>", "MathCaption",
  CellTags->{"S3.5.13", "13.18"}],

Cell[CellGroupData[{

Cell["FourierTransform[1, t, \[Omega]]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.5.13"],

Cell[BoxData[
    \(\@\(2\ \[Pi]\)\ DiracDelta[\[Omega]]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell[TextData[{
  "The Fourier transform of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"cos", 
          RowBox[{"(", 
            StyleBox["t",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " involves the sum of two delta functions. "
}], "MathCaption",
  CellTags->{"S3.5.13", "13.19"}],

Cell[CellGroupData[{

Cell["FourierTransform[Cos[t], t, \[Omega]]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.5.13"],

Cell[BoxData[
    \(\@\(\[Pi]\/2\)\ DiracDelta[\(-1\) + \[Omega]] + \@\(\[Pi]\/2\)\ \
DiracDelta[1 + \[Omega]]\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell[TextData[{
  "Dirac delta functions can be used in ",
  StyleBox["DSolve", "MR"],
  " to find the impulse response or Green's function of systems represented \
by linear and certain other differential equations. "
}], "Text",
  CellTags->{"S3.5.13", "13.20"}],

Cell[TextData[{
  "This finds the behavior of a harmonic oscillator subjected to an impulse \
at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["t",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.5.13", "13.21"}],

Cell[CellGroupData[{

Cell["\<\
DSolve[{x''[t] + r x[t] == DiracDelta[t], x[0]==0, x'[0]==1}, x[t], \
t]\
\>", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.5.13"],

Cell[BoxData[
    \({{x[t] \[Rule] \(Sin[\@r\ t]\ UnitStep[t]\)\/\@r}}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.5.13"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DiracDelta[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "multidimensional Dirac delta function equal to 0 unless all \
the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " are zero "
            }]]},
          {Cell[TextData[{
              StyleBox["UnitStep[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "multidimensional unit step function, equal to 0 if any of the \
",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " are negative "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.13"],

Cell["Multidimensional Dirac delta and unit step functions. ", "Caption",
  CellTags->"S3.5.13"],

Cell[TextData[{
  "Related to the multidimensional Dirac delta function are two integer \
functions: discrete delta and Kronecker delta. Discrete delta ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Delta]", 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox[
                StyleBox["n",
                  "TI"], "1"], ",", 
              SubscriptBox[
                StyleBox["n",
                  "TI"], "2"], ",", "\[Ellipsis]"}], ")"}]}], 
        TraditionalForm]], "InlineFormula"],
  " is 1 if all the ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["n",
              "TI"], 
            StyleBox["i",
              "TI"]], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", and is zero otherwise. Kronecker delta ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Delta]", 
          RowBox[{
            SubscriptBox[
              StyleBox["n",
                "TI"], "1"], 
            SubscriptBox[
              StyleBox["n",
                "TI"], "2"], \(\(\[Ellipsis]\)\(\ \)\)}]], TraditionalForm]], 
    "InlineFormula"],
  " is 1 if all the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " are equal, and is zero otherwise. "
}], "Text",
  CellTags->{"S3.5.13", "13.22"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DiscreteDelta[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "discrete delta ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Delta]", 
                      RowBox[{"(", 
                        RowBox[{
                          SubscriptBox[
                            StyleBox["n",
                              "TI"], "1"], ",", 
                          SubscriptBox[
                            StyleBox["n",
                              "TI"], "2"], ",", "\[Ellipsis]"}], ")"}]}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["KroneckerDelta[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "Kronecker delta ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox["\[Delta]", 
                      RowBox[{
                        SubscriptBox[
                          StyleBox["n",
                            "TI"], "1"], 
                        SubscriptBox[
                          StyleBox["n",
                            "TI"], "2"], \(\(\[Ellipsis]\)\(\ \)\)}]], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.5.13"],

Cell["Integer delta functions. ", "Caption",
  CellTags->"S3.5.13"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S3.5.0"->{
    Cell[1776, 53, 111, 4, 65, "Section",
      CellTags->{"S3.5.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 111, 4, 65, "Section",
      CellTags->{"S3.5.0", "0.1"}]},
  "S3.5.1"->{
    Cell[1912, 61, 74, 1, 70, "Subsection",
      CellTags->{"S3.5.1", "1.1"}],
    Cell[1989, 64, 5170, 149, 70, "DefinitionBox",
      CellTags->"S3.5.1"],
    Cell[7162, 215, 77, 1, 70, "Caption",
      CellTags->"S3.5.1"],
    Cell[7242, 218, 427, 16, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.2"}],
    Cell[7694, 238, 73, 2, 70, "Input",
      CellTags->"S3.5.1"],
    Cell[7770, 242, 101, 3, 70, "Output",
      CellTags->"S3.5.1"],
    Cell[7886, 248, 87, 1, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.3"}],
    Cell[7998, 253, 78, 2, 70, "Input",
      CellTags->"S3.5.1"],
    Cell[8079, 257, 137, 3, 70, "Output",
      CellTags->"S3.5.1"],
    Cell[8231, 263, 174, 4, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.4"}],
    Cell[8430, 271, 90, 2, 70, "Input",
      CellTags->"S3.5.1"],
    Cell[8523, 275, 88, 3, 70, "Output",
      CellTags->"S3.5.1"],
    Cell[8626, 281, 252, 10, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.5"}],
    Cell[8903, 295, 79, 2, 70, "Input",
      CellTags->"S3.5.1"],
    Cell[8985, 299, 85, 3, 70, "Output",
      CellTags->"S3.5.1"],
    Cell[9085, 305, 403, 15, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.6"}],
    Cell[9513, 324, 82, 2, 70, "Input",
      CellTags->"S3.5.1"],
    Cell[9598, 328, 257, 7, 70, "Output",
      CellTags->"S3.5.1"],
    Cell[9870, 338, 785, 33, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.7"}],
    Cell[10680, 375, 100, 2, 70, "Input",
      CellTags->"S3.5.1"],
    Cell[10783, 379, 127, 3, 70, "Output",
      CellTags->"S3.5.1"],
    Cell[10925, 385, 5468, 158, 70, "DefinitionBox",
      CellTags->"S3.5.1"],
    Cell[16396, 545, 61, 1, 70, "Caption",
      CellTags->"S3.5.1"],
    Cell[16460, 548, 369, 13, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.8"}],
    Cell[16854, 565, 86, 2, 70, "Input",
      CellTags->"S3.5.1"],
    Cell[16943, 569, 93, 3, 70, "Output",
      CellTags->"S3.5.1"],
    Cell[17051, 575, 78, 1, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.9"}],
    Cell[17154, 580, 89, 2, 70, "Input",
      CellTags->"S3.5.1"],
    Cell[17246, 584, 97, 3, 70, "Output",
      CellTags->"S3.5.1"],
    Cell[17358, 590, 102, 1, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.10"}],
    Cell[17485, 595, 93, 2, 70, "Input",
      CellTags->"S3.5.1"],
    Cell[17581, 599, 103, 3, 70, "Output",
      CellTags->"S3.5.1"]},
  "1.1"->{
    Cell[1912, 61, 74, 1, 70, "Subsection",
      CellTags->{"S3.5.1", "1.1"}]},
  "1.2"->{
    Cell[7242, 218, 427, 16, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.2"}]},
  "1.3"->{
    Cell[7886, 248, 87, 1, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.3"}]},
  "1.4"->{
    Cell[8231, 263, 174, 4, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.4"}]},
  "1.5"->{
    Cell[8626, 281, 252, 10, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.5"}]},
  "1.6"->{
    Cell[9085, 305, 403, 15, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.6"}]},
  "1.7"->{
    Cell[9870, 338, 785, 33, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.7"}]},
  "1.8"->{
    Cell[16460, 548, 369, 13, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.8"}]},
  "1.9"->{
    Cell[17051, 575, 78, 1, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.9"}]},
  "1.10"->{
    Cell[17358, 590, 102, 1, 70, "MathCaption",
      CellTags->{"S3.5.1", "1.10"}]},
  "S3.5.2"->{
    Cell[17733, 608, 76, 1, 70, "Subsection",
      CellTags->{"S3.5.2", "2.1"}],
    Cell[17812, 611, 5426, 166, 70, "DefinitionBox",
      CellTags->"S3.5.2"],
    Cell[23241, 779, 75, 1, 70, "Caption",
      CellTags->"S3.5.2"],
    Cell[23319, 782, 1597, 58, 70, "Text",
      CellTags->{"S3.5.2", "2.2"}],
    Cell[24919, 842, 1538, 55, 70, "Text",
      CellTags->{"S3.5.2", "2.3"}],
    Cell[26460, 899, 668, 26, 70, "Text",
      CellTags->{"S3.5.2", "2.4"}],
    Cell[27131, 927, 696, 26, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.5"}],
    Cell[27852, 957, 79, 2, 70, "Input",
      CellTags->"S3.5.2"],
    Cell[27934, 961, 85, 3, 70, "Output",
      CellTags->"S3.5.2"],
    Cell[28034, 967, 686, 27, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.6"}],
    Cell[28745, 998, 80, 2, 70, "Input",
      CellTags->"S3.5.2"],
    Cell[28828, 1002, 102, 3, 70, "Output",
      CellTags->"S3.5.2"],
    Cell[28945, 1008, 296, 11, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.7"}],
    Cell[29266, 1023, 83, 2, 70, "Input",
      CellTags->"S3.5.2"],
    Cell[29352, 1027, 96, 3, 70, "Output",
      CellTags->"S3.5.2"],
    Cell[29463, 1033, 441, 15, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.8"}],
    Cell[29929, 1052, 80, 2, 70, "Input",
      CellTags->"S3.5.2"],
    Cell[30012, 1056, 82, 3, 70, "Output",
      CellTags->"S3.5.2"],
    Cell[30109, 1062, 214, 9, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.9"}],
    Cell[30348, 1075, 86, 2, 70, "Input",
      CellTags->"S3.5.2"],
    Cell[30437, 1079, 102, 3, 70, "Output",
      CellTags->"S3.5.2"],
    Cell[30554, 1085, 153, 5, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.10"}],
    Cell[30710, 1092, 72, 2, 70, "Input",
      CellTags->"S3.5.2"],
    Cell[30785, 1096, 151, 5, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.11"}],
    Cell[30961, 1105, 102, 2, 70, "Input",
      CellTags->"S3.5.2"],
    Cell[31066, 1109, 125, 3, 70, "Output",
      CellTags->"S3.5.2"],
    Cell[31206, 1115, 158, 5, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.12"}],
    Cell[31367, 1122, 90, 2, 70, "Input",
      CellTags->"S3.5.2"],
    Cell[31460, 1126, 138, 5, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.13"}],
    Cell[31623, 1135, 82, 2, 70, "Input",
      CellTags->"S3.5.2"],
    Cell[31708, 1139, 105, 3, 70, "Output",
      CellTags->"S3.5.2"],
    Cell[31828, 1145, 178, 7, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.14"}],
    Cell[32031, 1156, 86, 2, 70, "Input",
      CellTags->"S3.5.2"],
    Cell[32120, 1160, 109, 3, 70, "Output",
      CellTags->"S3.5.2"],
    Cell[32244, 1166, 544, 20, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.15"}],
    Cell[32813, 1190, 80, 2, 70, "Input",
      CellTags->"S3.5.2"],
    Cell[32896, 1194, 110, 3, 70, "Output",
      CellTags->"S3.5.2"],
    Cell[33021, 1200, 132, 4, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.16"}],
    Cell[33178, 1208, 81, 2, 70, "Input",
      CellTags->"S3.5.2"],
    Cell[33262, 1212, 107, 3, 70, "Output",
      CellTags->"S3.5.2"]},
  "2.1"->{
    Cell[17733, 608, 76, 1, 70, "Subsection",
      CellTags->{"S3.5.2", "2.1"}]},
  "2.2"->{
    Cell[23319, 782, 1597, 58, 70, "Text",
      CellTags->{"S3.5.2", "2.2"}]},
  "2.3"->{
    Cell[24919, 842, 1538, 55, 70, "Text",
      CellTags->{"S3.5.2", "2.3"}]},
  "2.4"->{
    Cell[26460, 899, 668, 26, 70, "Text",
      CellTags->{"S3.5.2", "2.4"}]},
  "2.5"->{
    Cell[27131, 927, 696, 26, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.5"}]},
  "2.6"->{
    Cell[28034, 967, 686, 27, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.6"}]},
  "2.7"->{
    Cell[28945, 1008, 296, 11, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.7"}]},
  "2.8"->{
    Cell[29463, 1033, 441, 15, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.8"}]},
  "2.9"->{
    Cell[30109, 1062, 214, 9, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.9"}]},
  "2.10"->{
    Cell[30554, 1085, 153, 5, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.10"}]},
  "2.11"->{
    Cell[30785, 1096, 151, 5, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.11"}]},
  "2.12"->{
    Cell[31206, 1115, 158, 5, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.12"}]},
  "2.13"->{
    Cell[31460, 1126, 138, 5, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.13"}]},
  "2.14"->{
    Cell[31828, 1145, 178, 7, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.14"}]},
  "2.15"->{
    Cell[32244, 1166, 544, 20, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.15"}]},
  "2.16"->{
    Cell[33021, 1200, 132, 4, 70, "MathCaption",
      CellTags->{"S3.5.2", "2.16"}]},
  "S3.5.3"->{
    Cell[33418, 1221, 91, 1, 70, "Subsection",
      CellTags->{"S3.5.3", "3.1"}],
    Cell[33512, 1224, 115, 2, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.2"}],
    Cell[33652, 1230, 78, 2, 70, "Input",
      CellTags->"S3.5.3"],
    Cell[33733, 1234, 97, 3, 70, "Output",
      CellTags->"S3.5.3"],
    Cell[33845, 1240, 195, 7, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.3"}],
    Cell[34065, 1251, 76, 2, 70, "Input",
      CellTags->"S3.5.3"],
    Cell[34144, 1255, 219, 6, 70, "Output",
      CellTags->"S3.5.3"],
    Cell[34378, 1264, 216, 7, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.4"}],
    Cell[34619, 1275, 78, 2, 70, "Input",
      CellTags->"S3.5.3"],
    Cell[34700, 1279, 265, 7, 70, "Output",
      CellTags->"S3.5.3"],
    Cell[34980, 1289, 218, 9, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.5"}],
    Cell[35223, 1302, 71, 2, 70, "Input",
      CellTags->"S3.5.3"],
    Cell[35297, 1306, 417, 11, 70, "Output",
      CellTags->"S3.5.3"],
    Cell[35729, 1320, 198, 5, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.6"}],
    Cell[35952, 1329, 81, 2, 70, "Input",
      CellTags->"S3.5.3"],
    Cell[36036, 1333, 268, 8, 70, "Output",
      CellTags->"S3.5.3"],
    Cell[36319, 1344, 921, 30, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.7"}],
    Cell[37265, 1378, 83, 2, 70, "Input",
      CellTags->"S3.5.3"],
    Cell[37351, 1382, 217, 7, 70, "Output",
      CellTags->"S3.5.3"],
    Cell[37583, 1392, 342, 13, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.8"}],
    Cell[37950, 1409, 73, 2, 70, "Input",
      CellTags->"S3.5.3"],
    Cell[38026, 1413, 217, 7, 70, "Output",
      CellTags->"S3.5.3"],
    Cell[38258, 1423, 2937, 76, 70, "DefinitionBox",
      CellTags->"S3.5.3"],
    Cell[41198, 1501, 92, 1, 70, "Caption",
      CellTags->"S3.5.3"]},
  "3.1"->{
    Cell[33418, 1221, 91, 1, 70, "Subsection",
      CellTags->{"S3.5.3", "3.1"}]},
  "3.2"->{
    Cell[33512, 1224, 115, 2, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.2"}]},
  "3.3"->{
    Cell[33845, 1240, 195, 7, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.3"}]},
  "3.4"->{
    Cell[34378, 1264, 216, 7, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.4"}]},
  "3.5"->{
    Cell[34980, 1289, 218, 9, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.5"}]},
  "3.6"->{
    Cell[35729, 1320, 198, 5, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.6"}]},
  "3.7"->{
    Cell[36319, 1344, 921, 30, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.7"}]},
  "3.8"->{
    Cell[37583, 1392, 342, 13, 70, "MathCaption",
      CellTags->{"S3.5.3", "3.8"}]},
  "S3.5.4"->{
    Cell[41327, 1507, 108, 1, 70, "Subsection",
      CellTags->{"S3.5.4", "4.1"}],
    Cell[41438, 1510, 365, 9, 70, "Text",
      CellTags->{"S3.5.4", "4.2"}],
    Cell[41806, 1521, 3118, 109, 70, "Text",
      CellTags->{"S3.5.4", "4.3"}],
    Cell[44927, 1632, 2011, 66, 70, "Text",
      CellTags->{"S3.5.4", "4.4"}],
    Cell[46941, 1700, 828, 25, 70, "Text",
      CellTags->{"S3.5.4", "4.5"}],
    Cell[47772, 1727, 476, 18, 70, "Text",
      CellTags->{"S3.5.4", "4.6"}],
    Cell[48251, 1747, 866, 27, 70, "Text",
      CellTags->{"S3.5.4", "4.7"}],
    Cell[49120, 1776, 157, 5, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.8"}],
    Cell[49302, 1785, 78, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[49383, 1789, 253, 8, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[49651, 1800, 130, 5, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.9"}],
    Cell[49806, 1809, 81, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[49890, 1813, 260, 8, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[50165, 1824, 86, 1, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.10"}],
    Cell[50276, 1829, 82, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[50361, 1833, 260, 8, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[50636, 1844, 223, 6, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.11"}],
    Cell[50884, 1854, 77, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[50964, 1858, 217, 7, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[51196, 1868, 78, 1, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.12"}],
    Cell[51299, 1873, 77, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[51379, 1877, 266, 8, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[51660, 1888, 228, 7, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.13"}],
    Cell[51913, 1899, 94, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[52010, 1903, 266, 8, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[52291, 1914, 83, 1, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.14"}],
    Cell[52399, 1919, 95, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[52497, 1923, 266, 8, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[52778, 1934, 236, 6, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.15"}],
    Cell[53039, 1944, 95, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[53137, 1948, 266, 8, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[53418, 1959, 201, 5, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.16"}],
    Cell[53644, 1968, 77, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[53724, 1972, 404, 13, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[54143, 1988, 92, 1, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.17"}],
    Cell[54260, 1993, 78, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[54341, 1997, 321, 9, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[54677, 2009, 495, 14, 70, "Text",
      CellTags->{"S3.5.4", "4.18"}],
    Cell[55175, 2025, 226, 7, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.19"}],
    Cell[55426, 2036, 82, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[55511, 2040, 261, 8, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[55787, 2051, 202, 7, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.20"}],
    Cell[56014, 2062, 77, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[56094, 2066, 220, 6, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[56329, 2075, 344, 11, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.21"}],
    Cell[56698, 2090, 74, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[56775, 2094, 205, 6, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[56995, 2103, 236, 7, 70, "Text",
      CellTags->{"S3.5.4", "4.22"}],
    Cell[57234, 2112, 138, 5, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.23"}],
    Cell[57375, 2119, 77, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[57455, 2123, 259, 9, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.24"}],
    Cell[57739, 2136, 75, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[57817, 2140, 89, 3, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[57921, 2146, 202, 7, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.25"}],
    Cell[58148, 2157, 70, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[58221, 2161, 89, 3, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[58325, 2167, 135, 5, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.26"}],
    Cell[58485, 2176, 67, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[58555, 2180, 92, 3, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[58662, 2186, 747, 20, 70, "Text",
      CellTags->{"S3.5.4", "4.27"}],
    Cell[59412, 2208, 933, 27, 70, "Text",
      CellTags->{"S3.5.4", "4.28"}],
    Cell[60348, 2237, 163, 5, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.29"}],
    Cell[60536, 2246, 69, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[60608, 2250, 94, 3, 70, "Output",
      CellTags->"S3.5.4"],
    Cell[60717, 2256, 178, 6, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.30"}],
    Cell[60920, 2266, 69, 2, 70, "Input",
      CellTags->"S3.5.4"],
    Cell[60992, 2270, 91, 3, 70, "Output",
      CellTags->"S3.5.4"]},
  "4.1"->{
    Cell[41327, 1507, 108, 1, 70, "Subsection",
      CellTags->{"S3.5.4", "4.1"}]},
  "4.2"->{
    Cell[41438, 1510, 365, 9, 70, "Text",
      CellTags->{"S3.5.4", "4.2"}]},
  "4.3"->{
    Cell[41806, 1521, 3118, 109, 70, "Text",
      CellTags->{"S3.5.4", "4.3"}]},
  "4.4"->{
    Cell[44927, 1632, 2011, 66, 70, "Text",
      CellTags->{"S3.5.4", "4.4"}]},
  "4.5"->{
    Cell[46941, 1700, 828, 25, 70, "Text",
      CellTags->{"S3.5.4", "4.5"}]},
  "4.6"->{
    Cell[47772, 1727, 476, 18, 70, "Text",
      CellTags->{"S3.5.4", "4.6"}]},
  "4.7"->{
    Cell[48251, 1747, 866, 27, 70, "Text",
      CellTags->{"S3.5.4", "4.7"}]},
  "4.8"->{
    Cell[49120, 1776, 157, 5, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.8"}]},
  "4.9"->{
    Cell[49651, 1800, 130, 5, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.9"}]},
  "4.10"->{
    Cell[50165, 1824, 86, 1, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.10"}]},
  "4.11"->{
    Cell[50636, 1844, 223, 6, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.11"}]},
  "4.12"->{
    Cell[51196, 1868, 78, 1, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.12"}]},
  "4.13"->{
    Cell[51660, 1888, 228, 7, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.13"}]},
  "4.14"->{
    Cell[52291, 1914, 83, 1, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.14"}]},
  "4.15"->{
    Cell[52778, 1934, 236, 6, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.15"}]},
  "4.16"->{
    Cell[53418, 1959, 201, 5, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.16"}]},
  "4.17"->{
    Cell[54143, 1988, 92, 1, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.17"}]},
  "4.18"->{
    Cell[54677, 2009, 495, 14, 70, "Text",
      CellTags->{"S3.5.4", "4.18"}]},
  "4.19"->{
    Cell[55175, 2025, 226, 7, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.19"}]},
  "4.20"->{
    Cell[55787, 2051, 202, 7, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.20"}]},
  "4.21"->{
    Cell[56329, 2075, 344, 11, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.21"}]},
  "4.22"->{
    Cell[56995, 2103, 236, 7, 70, "Text",
      CellTags->{"S3.5.4", "4.22"}]},
  "4.23"->{
    Cell[57234, 2112, 138, 5, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.23"}]},
  "4.24"->{
    Cell[57455, 2123, 259, 9, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.24"}]},
  "4.25"->{
    Cell[57921, 2146, 202, 7, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.25"}]},
  "4.26"->{
    Cell[58325, 2167, 135, 5, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.26"}]},
  "4.27"->{
    Cell[58662, 2186, 747, 20, 70, "Text",
      CellTags->{"S3.5.4", "4.27"}]},
  "4.28"->{
    Cell[59412, 2208, 933, 27, 70, "Text",
      CellTags->{"S3.5.4", "4.28"}]},
  "4.29"->{
    Cell[60348, 2237, 163, 5, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.29"}]},
  "4.30"->{
    Cell[60717, 2256, 178, 6, 70, "MathCaption",
      CellTags->{"S3.5.4", "4.30"}]},
  "S3.5.5"->{
    Cell[61132, 2279, 79, 1, 70, "Subsection",
      CellTags->{"S3.5.5", "5.1"}],
    Cell[61214, 2282, 326, 13, 70, "Text",
      CellTags->{"S3.5.5", "5.2"}],
    Cell[61543, 2297, 691, 27, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.3"}],
    Cell[62237, 2326, 79, 2, 70, "Input",
      CellTags->"S3.5.5"],
    Cell[62319, 2330, 155, 5, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.4"}],
    Cell[62499, 2339, 76, 2, 70, "Input",
      CellTags->"S3.5.5"],
    Cell[62578, 2343, 95, 3, 70, "Output",
      CellTags->"S3.5.5"],
    Cell[62688, 2349, 233, 8, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.5"}],
    Cell[62946, 2361, 71, 2, 70, "Input",
      CellTags->"S3.5.5"],
    Cell[63020, 2365, 270, 7, 70, "Output",
      CellTags->"S3.5.5"],
    Cell[63305, 2375, 242, 8, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.6"}],
    Cell[63572, 2387, 74, 2, 70, "Input",
      CellTags->"S3.5.5"],
    Cell[63649, 2391, 83, 3, 70, "Output",
      CellTags->"S3.5.5"],
    Cell[63747, 2397, 127, 5, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.7"}],
    Cell[63899, 2406, 84, 2, 70, "Input",
      CellTags->"S3.5.5"],
    Cell[63986, 2410, 92, 3, 70, "Output",
      CellTags->"S3.5.5"],
    Cell[64093, 2416, 158, 5, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.8"}],
    Cell[64276, 2425, 80, 2, 70, "Input",
      CellTags->"S3.5.5"],
    Cell[64359, 2429, 87, 3, 70, "Output",
      CellTags->"S3.5.5"],
    Cell[64461, 2435, 107, 1, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.9"}],
    Cell[64593, 2440, 81, 2, 70, "Input",
      CellTags->"S3.5.5"],
    Cell[64677, 2444, 289, 8, 70, "Output",
      CellTags->"S3.5.5"],
    Cell[64981, 2455, 227, 6, 70, "Text",
      CellTags->{"S3.5.5", "5.10"}],
    Cell[65211, 2463, 2309, 74, 70, "DefinitionBox",
      CellTags->"S3.5.5"],
    Cell[67523, 2539, 63, 1, 70, "Caption",
      CellTags->"S3.5.5"],
    Cell[67589, 2542, 176, 5, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.11"}],
    Cell[67768, 2549, 104, 2, 70, "Input",
      CellTags->"S3.5.5"],
    Cell[67875, 2553, 92, 1, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.12"}],
    Cell[67992, 2558, 84, 2, 70, "Input",
      CellTags->"S3.5.5"],
    Cell[68079, 2562, 331, 10, 70, "Output",
      CellTags->"S3.5.5"]},
  "5.1"->{
    Cell[61132, 2279, 79, 1, 70, "Subsection",
      CellTags->{"S3.5.5", "5.1"}]},
  "5.2"->{
    Cell[61214, 2282, 326, 13, 70, "Text",
      CellTags->{"S3.5.5", "5.2"}]},
  "5.3"->{
    Cell[61543, 2297, 691, 27, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.3"}]},
  "5.4"->{
    Cell[62319, 2330, 155, 5, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.4"}]},
  "5.5"->{
    Cell[62688, 2349, 233, 8, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.5"}]},
  "5.6"->{
    Cell[63305, 2375, 242, 8, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.6"}]},
  "5.7"->{
    Cell[63747, 2397, 127, 5, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.7"}]},
  "5.8"->{
    Cell[64093, 2416, 158, 5, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.8"}]},
  "5.9"->{
    Cell[64461, 2435, 107, 1, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.9"}]},
  "5.10"->{
    Cell[64981, 2455, 227, 6, 70, "Text",
      CellTags->{"S3.5.5", "5.10"}]},
  "5.11"->{
    Cell[67589, 2542, 176, 5, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.11"}]},
  "5.12"->{
    Cell[67875, 2553, 92, 1, 70, "MathCaption",
      CellTags->{"S3.5.5", "5.12"}]},
  "S3.5.6"->{
    Cell[68459, 2578, 79, 1, 70, "Subsection",
      CellTags->{"S3.5.6", "6.1"}],
    Cell[68541, 2581, 968, 35, 70, "Text",
      CellTags->{"S3.5.6", "6.2"}],
    Cell[69512, 2618, 602, 19, 70, "Text",
      CellTags->{"S3.5.6", "6.3"}],
    Cell[70117, 2639, 320, 6, 70, "Text",
      CellTags->{"S3.5.6", "6.4"}],
    Cell[70440, 2647, 157, 4, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.5"}],
    Cell[70622, 2655, 81, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[70706, 2659, 88, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[70809, 2665, 296, 8, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.6"}],
    Cell[71130, 2677, 76, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[71209, 2681, 85, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[71309, 2687, 421, 15, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.7"}],
    Cell[71755, 2706, 89, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[71847, 2710, 121, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[71983, 2716, 126, 4, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.8"}],
    Cell[72134, 2724, 71, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[72208, 2728, 131, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[72354, 2734, 129, 4, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.9"}],
    Cell[72508, 2742, 75, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[72586, 2746, 101, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[72702, 2752, 427, 13, 70, "Text",
      CellTags->{"S3.5.6", "6.10"}],
    Cell[73132, 2767, 177, 7, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.11"}],
    Cell[73334, 2778, 83, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[73420, 2782, 95, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[73530, 2788, 169, 4, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.12"}],
    Cell[73724, 2796, 89, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[73816, 2800, 97, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[73928, 2806, 1181, 39, 70, "Text",
      CellTags->{"S3.5.6", "6.13"}],
    Cell[75112, 2847, 253, 8, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.14"}],
    Cell[75390, 2859, 81, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[75474, 2863, 104, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[75593, 2869, 212, 7, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.15"}],
    Cell[75830, 2880, 82, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[75915, 2884, 87, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[76017, 2890, 365, 7, 70, "Text",
      CellTags->{"S3.5.6", "6.16"}],
    Cell[76385, 2899, 142, 5, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.17"}],
    Cell[76552, 2908, 92, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[76647, 2912, 101, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[76763, 2918, 143, 5, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.18"}],
    Cell[76931, 2927, 92, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[77026, 2931, 102, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[77143, 2937, 160, 4, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.19"}],
    Cell[77328, 2945, 77, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[77408, 2949, 112, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[77535, 2955, 88, 1, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.20"}],
    Cell[77648, 2960, 72, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[77723, 2964, 100, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[77838, 2970, 491, 17, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.21"}],
    Cell[78354, 2991, 106, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[78463, 2995, 116, 3, 70, "Output",
      CellTags->"S3.5.6"],
    Cell[78594, 3001, 148, 4, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.22"}],
    Cell[78767, 3009, 90, 2, 70, "Input",
      CellTags->"S3.5.6"],
    Cell[78860, 3013, 91, 3, 70, "Output",
      CellTags->"S3.5.6"]},
  "6.1"->{
    Cell[68459, 2578, 79, 1, 70, "Subsection",
      CellTags->{"S3.5.6", "6.1"}]},
  "6.2"->{
    Cell[68541, 2581, 968, 35, 70, "Text",
      CellTags->{"S3.5.6", "6.2"}]},
  "6.3"->{
    Cell[69512, 2618, 602, 19, 70, "Text",
      CellTags->{"S3.5.6", "6.3"}]},
  "6.4"->{
    Cell[70117, 2639, 320, 6, 70, "Text",
      CellTags->{"S3.5.6", "6.4"}]},
  "6.5"->{
    Cell[70440, 2647, 157, 4, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.5"}]},
  "6.6"->{
    Cell[70809, 2665, 296, 8, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.6"}]},
  "6.7"->{
    Cell[71309, 2687, 421, 15, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.7"}]},
  "6.8"->{
    Cell[71983, 2716, 126, 4, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.8"}]},
  "6.9"->{
    Cell[72354, 2734, 129, 4, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.9"}]},
  "6.10"->{
    Cell[72702, 2752, 427, 13, 70, "Text",
      CellTags->{"S3.5.6", "6.10"}]},
  "6.11"->{
    Cell[73132, 2767, 177, 7, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.11"}]},
  "6.12"->{
    Cell[73530, 2788, 169, 4, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.12"}]},
  "6.13"->{
    Cell[73928, 2806, 1181, 39, 70, "Text",
      CellTags->{"S3.5.6", "6.13"}]},
  "6.14"->{
    Cell[75112, 2847, 253, 8, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.14"}]},
  "6.15"->{
    Cell[75593, 2869, 212, 7, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.15"}]},
  "6.16"->{
    Cell[76017, 2890, 365, 7, 70, "Text",
      CellTags->{"S3.5.6", "6.16"}]},
  "6.17"->{
    Cell[76385, 2899, 142, 5, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.17"}]},
  "6.18"->{
    Cell[76763, 2918, 143, 5, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.18"}]},
  "6.19"->{
    Cell[77143, 2937, 160, 4, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.19"}]},
  "6.20"->{
    Cell[77535, 2955, 88, 1, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.20"}]},
  "6.21"->{
    Cell[77838, 2970, 491, 17, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.21"}]},
  "6.22"->{
    Cell[78594, 3001, 148, 4, 70, "MathCaption",
      CellTags->{"S3.5.6", "6.22"}]},
  "S3.5.7"->{
    Cell[79000, 3022, 96, 1, 70, "Subsection",
      CellTags->{"S3.5.7", "7.1"}],
    Cell[79099, 3025, 322, 6, 70, "Text",
      CellTags->{"S3.5.7", "7.2"}],
    Cell[79424, 3033, 468, 8, 70, "Text",
      CellTags->{"S3.5.7", "7.3"}],
    Cell[79895, 3043, 156, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.4"}],
    Cell[80076, 3051, 86, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[80165, 3055, 115, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[80295, 3061, 164, 5, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.5"}],
    Cell[80484, 3070, 89, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[80576, 3074, 112, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[80703, 3080, 139, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.6"}],
    Cell[80867, 3088, 86, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[80956, 3092, 124, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[81095, 3098, 232, 6, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.7"}],
    Cell[81352, 3108, 106, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[81461, 3112, 184, 4, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[81660, 3119, 226, 6, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.8"}],
    Cell[81911, 3129, 87, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[82001, 3133, 158, 4, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[82174, 3140, 374, 7, 70, "Text",
      CellTags->{"S3.5.7", "7.9"}],
    Cell[82551, 3149, 183, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.10"}],
    Cell[82759, 3157, 91, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[82853, 3161, 128, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[82996, 3167, 262, 5, 70, "Text",
      CellTags->{"S3.5.7", "7.11"}],
    Cell[83261, 3174, 567, 11, 70, "Text",
      CellTags->{"S3.5.7", "7.12"}],
    Cell[83831, 3187, 232, 5, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.13"}],
    Cell[84088, 3196, 96, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[84187, 3200, 121, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[84323, 3206, 175, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.14"}],
    Cell[84523, 3214, 95, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[84621, 3218, 149, 4, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[84785, 3225, 126, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.15"}],
    Cell[84936, 3233, 68, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[85007, 3237, 545, 10, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[85567, 3250, 162, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.16"}],
    Cell[85754, 3258, 96, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[85853, 3262, 138, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[86006, 3268, 129, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.17"}],
    Cell[86160, 3276, 98, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[86261, 3280, 143, 4, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[86419, 3287, 106, 1, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.18"}],
    Cell[86550, 3292, 96, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[86649, 3296, 226, 5, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[86890, 3304, 176, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.19"}],
    Cell[87091, 3312, 90, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[87184, 3316, 125, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[87324, 3322, 107, 1, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.20"}],
    Cell[87456, 3327, 90, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[87549, 3331, 286, 6, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[87850, 3340, 136, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.21"}],
    Cell[88011, 3348, 91, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[88105, 3352, 103, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[88223, 3358, 142, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.22"}],
    Cell[88390, 3366, 91, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[88484, 3370, 276, 6, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[88775, 3379, 163, 5, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.23"}],
    Cell[88963, 3388, 94, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[89060, 3392, 449, 12, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[89524, 3407, 579, 10, 70, "Text",
      CellTags->{"S3.5.7", "7.24"}],
    Cell[90106, 3419, 147, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.25"}],
    Cell[90278, 3427, 92, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[90373, 3431, 139, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[90527, 3437, 152, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.26"}],
    Cell[90704, 3445, 91, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[90798, 3449, 137, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[90950, 3455, 128, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.27"}],
    Cell[91103, 3463, 96, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[91202, 3467, 139, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[91356, 3473, 408, 9, 70, "Text",
      CellTags->{"S3.5.7", "7.28"}],
    Cell[91767, 3484, 142, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.29"}],
    Cell[91934, 3492, 91, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[92028, 3496, 100, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[92143, 3502, 170, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.30"}],
    Cell[92338, 3510, 99, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[92440, 3514, 507, 11, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[92962, 3528, 317, 9, 70, "Text",
      CellTags->{"S3.5.7", "7.31"}],
    Cell[93282, 3539, 564, 13, 70, "Text",
      CellTags->{"S3.5.7", "7.32"}],
    Cell[93849, 3554, 209, 6, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.33"}],
    Cell[94083, 3564, 90, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[94176, 3568, 122, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[94313, 3574, 149, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.34"}],
    Cell[94487, 3582, 85, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[94575, 3586, 95, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[94685, 3592, 196, 5, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.35"}],
    Cell[94884, 3599, 119, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[95006, 3603, 159, 5, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.36"}],
    Cell[95190, 3612, 91, 2, 70, "Input",
      CellTags->"S3.5.7"],
    Cell[95284, 3616, 99, 3, 70, "Output",
      CellTags->"S3.5.7"],
    Cell[95398, 3622, 799, 22, 70, "Text",
      CellTags->{"S3.5.7", "7.37"}]},
  "7.1"->{
    Cell[79000, 3022, 96, 1, 70, "Subsection",
      CellTags->{"S3.5.7", "7.1"}]},
  "7.2"->{
    Cell[79099, 3025, 322, 6, 70, "Text",
      CellTags->{"S3.5.7", "7.2"}]},
  "7.3"->{
    Cell[79424, 3033, 468, 8, 70, "Text",
      CellTags->{"S3.5.7", "7.3"}]},
  "7.4"->{
    Cell[79895, 3043, 156, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.4"}]},
  "7.5"->{
    Cell[80295, 3061, 164, 5, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.5"}]},
  "7.6"->{
    Cell[80703, 3080, 139, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.6"}]},
  "7.7"->{
    Cell[81095, 3098, 232, 6, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.7"}]},
  "7.8"->{
    Cell[81660, 3119, 226, 6, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.8"}]},
  "7.9"->{
    Cell[82174, 3140, 374, 7, 70, "Text",
      CellTags->{"S3.5.7", "7.9"}]},
  "7.10"->{
    Cell[82551, 3149, 183, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.10"}]},
  "7.11"->{
    Cell[82996, 3167, 262, 5, 70, "Text",
      CellTags->{"S3.5.7", "7.11"}]},
  "7.12"->{
    Cell[83261, 3174, 567, 11, 70, "Text",
      CellTags->{"S3.5.7", "7.12"}]},
  "7.13"->{
    Cell[83831, 3187, 232, 5, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.13"}]},
  "7.14"->{
    Cell[84323, 3206, 175, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.14"}]},
  "7.15"->{
    Cell[84785, 3225, 126, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.15"}]},
  "7.16"->{
    Cell[85567, 3250, 162, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.16"}]},
  "7.17"->{
    Cell[86006, 3268, 129, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.17"}]},
  "7.18"->{
    Cell[86419, 3287, 106, 1, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.18"}]},
  "7.19"->{
    Cell[86890, 3304, 176, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.19"}]},
  "7.20"->{
    Cell[87324, 3322, 107, 1, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.20"}]},
  "7.21"->{
    Cell[87850, 3340, 136, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.21"}]},
  "7.22"->{
    Cell[88223, 3358, 142, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.22"}]},
  "7.23"->{
    Cell[88775, 3379, 163, 5, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.23"}]},
  "7.24"->{
    Cell[89524, 3407, 579, 10, 70, "Text",
      CellTags->{"S3.5.7", "7.24"}]},
  "7.25"->{
    Cell[90106, 3419, 147, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.25"}]},
  "7.26"->{
    Cell[90527, 3437, 152, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.26"}]},
  "7.27"->{
    Cell[90950, 3455, 128, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.27"}]},
  "7.28"->{
    Cell[91356, 3473, 408, 9, 70, "Text",
      CellTags->{"S3.5.7", "7.28"}]},
  "7.29"->{
    Cell[91767, 3484, 142, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.29"}]},
  "7.30"->{
    Cell[92143, 3502, 170, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.30"}]},
  "7.31"->{
    Cell[92962, 3528, 317, 9, 70, "Text",
      CellTags->{"S3.5.7", "7.31"}]},
  "7.32"->{
    Cell[93282, 3539, 564, 13, 70, "Text",
      CellTags->{"S3.5.7", "7.32"}]},
  "7.33"->{
    Cell[93849, 3554, 209, 6, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.33"}]},
  "7.34"->{
    Cell[94313, 3574, 149, 4, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.34"}]},
  "7.35"->{
    Cell[94685, 3592, 196, 5, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.35"}]},
  "7.36"->{
    Cell[95006, 3603, 159, 5, 70, "MathCaption",
      CellTags->{"S3.5.7", "7.36"}]},
  "7.37"->{
    Cell[95398, 3622, 799, 22, 70, "Text",
      CellTags->{"S3.5.7", "7.37"}]},
  "S3.5.8"->{
    Cell[96234, 3649, 77, 1, 70, "Subsection",
      CellTags->{"S3.5.8", "8.1"}],
    Cell[96314, 3652, 5860, 166, 70, "DefinitionBox",
      CellTags->"S3.5.8"],
    Cell[102177, 3820, 64, 1, 70, "Caption",
      CellTags->"S3.5.8"],
    Cell[102244, 3823, 499, 19, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.2"}],
    Cell[102768, 3846, 89, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[102860, 3850, 107, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[102982, 3856, 827, 30, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.3"}],
    Cell[103834, 3890, 106, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[103943, 3894, 110, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[104068, 3900, 323, 11, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.4"}],
    Cell[104416, 3915, 106, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[104525, 3919, 88, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[104628, 3925, 348, 7, 70, "Text",
      CellTags->{"S3.5.8", "8.5"}],
    Cell[104979, 3934, 149, 4, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.6"}],
    Cell[105153, 3942, 89, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[105245, 3946, 121, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[105381, 3952, 140, 4, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.7"}],
    Cell[105546, 3960, 99, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[105648, 3964, 104, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[105767, 3970, 196, 5, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.8"}],
    Cell[105988, 3979, 109, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[106100, 3983, 130, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[106245, 3989, 200, 5, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.9"}],
    Cell[106470, 3998, 108, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[106581, 4002, 92, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[106688, 4008, 108, 1, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.10"}],
    Cell[106821, 4013, 120, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[106944, 4017, 118, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[107077, 4023, 129, 4, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.11"}],
    Cell[107231, 4031, 109, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[107343, 4035, 240, 5, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[107598, 4043, 394, 7, 70, "Text",
      CellTags->{"S3.5.8", "8.12"}],
    Cell[107995, 4052, 290, 10, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.13"}],
    Cell[108310, 4066, 84, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[108397, 4070, 95, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[108507, 4076, 100, 1, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.14"}],
    Cell[108632, 4081, 97, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[108732, 4085, 88, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[108835, 4091, 289, 9, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.15"}],
    Cell[109149, 4104, 93, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[109245, 4108, 93, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[109353, 4114, 137, 4, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.16"}],
    Cell[109515, 4122, 95, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[109613, 4126, 148, 4, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[109776, 4133, 105, 1, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.17"}],
    Cell[109906, 4138, 102, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[110011, 4142, 83, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[110109, 4148, 262, 9, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.18"}],
    Cell[110396, 4161, 105, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[110504, 4165, 113, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[110632, 4171, 1382, 40, 70, "DefinitionBox",
      CellTags->"S3.5.8"],
    Cell[112017, 4213, 68, 1, 70, "Caption",
      CellTags->"S3.5.8"],
    Cell[112088, 4216, 254, 9, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.19"}],
    Cell[112367, 4229, 82, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[112452, 4233, 88, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[112555, 4239, 437, 15, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.20"}],
    Cell[113017, 4258, 101, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[113121, 4262, 116, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[113252, 4268, 108, 1, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.21"}],
    Cell[113385, 4273, 91, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[113479, 4277, 168, 4, 70, "Message",
      CellTags->"S3.5.8"],
    Cell[113650, 4283, 131, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[113796, 4289, 103, 1, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.22"}],
    Cell[113924, 4294, 113, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[114040, 4298, 88, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[114143, 4304, 425, 8, 70, "Text",
      CellTags->{"S3.5.8", "8.23"}],
    Cell[114571, 4314, 283, 10, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.24"}],
    Cell[114879, 4328, 82, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[114964, 4332, 105, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[115084, 4338, 290, 8, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.25"}],
    Cell[115399, 4350, 90, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[115492, 4354, 205, 5, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[115712, 4362, 234, 8, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.26"}],
    Cell[115971, 4374, 76, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[116050, 4378, 86, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[116151, 4384, 945, 27, 70, "DefinitionBox3Col",
      CellTags->"S3.5.8"],
    Cell[117099, 4413, 108, 5, 70, "Caption",
      CellTags->"S3.5.8"],
    Cell[117210, 4420, 480, 17, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.27"}],
    Cell[117715, 4441, 114, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[117832, 4445, 94, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[117941, 4451, 440, 10, 70, "Text",
      CellTags->{"S3.5.8", "8.28"}],
    Cell[118384, 4463, 166, 5, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.29"}],
    Cell[118575, 4472, 104, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[118682, 4476, 231, 5, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[118928, 4484, 227, 8, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.30"}],
    Cell[119180, 4496, 141, 5, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[119324, 4503, 102, 3, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[119441, 4509, 635, 21, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.31"}],
    Cell[120101, 4534, 84, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[120188, 4538, 3793, 277, 70, 3720, 274, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.5.8"],
    Cell[123984, 4817, 178, 5, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[124177, 4825, 266, 9, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.32"}],
    Cell[124468, 4838, 155, 5, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[124626, 4845, 153, 4, 70, "Output",
      CellTags->"S3.5.8"],
    Cell[124794, 4852, 230, 8, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.33"}],
    Cell[125049, 4864, 94, 2, 70, "Input",
      CellTags->"S3.5.8"],
    Cell[125146, 4868, 4164, 300, 70, 4091, 297, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.5.8"],
    Cell[129313, 5170, 178, 5, 70, "Output",
      CellTags->"S3.5.8"]},
  "8.1"->{
    Cell[96234, 3649, 77, 1, 70, "Subsection",
      CellTags->{"S3.5.8", "8.1"}]},
  "8.2"->{
    Cell[102244, 3823, 499, 19, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.2"}]},
  "8.3"->{
    Cell[102982, 3856, 827, 30, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.3"}]},
  "8.4"->{
    Cell[104068, 3900, 323, 11, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.4"}]},
  "8.5"->{
    Cell[104628, 3925, 348, 7, 70, "Text",
      CellTags->{"S3.5.8", "8.5"}]},
  "8.6"->{
    Cell[104979, 3934, 149, 4, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.6"}]},
  "8.7"->{
    Cell[105381, 3952, 140, 4, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.7"}]},
  "8.8"->{
    Cell[105767, 3970, 196, 5, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.8"}]},
  "8.9"->{
    Cell[106245, 3989, 200, 5, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.9"}]},
  "8.10"->{
    Cell[106688, 4008, 108, 1, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.10"}]},
  "8.11"->{
    Cell[107077, 4023, 129, 4, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.11"}]},
  "8.12"->{
    Cell[107598, 4043, 394, 7, 70, "Text",
      CellTags->{"S3.5.8", "8.12"}]},
  "8.13"->{
    Cell[107995, 4052, 290, 10, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.13"}]},
  "8.14"->{
    Cell[108507, 4076, 100, 1, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.14"}]},
  "8.15"->{
    Cell[108835, 4091, 289, 9, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.15"}]},
  "8.16"->{
    Cell[109353, 4114, 137, 4, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.16"}]},
  "8.17"->{
    Cell[109776, 4133, 105, 1, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.17"}]},
  "8.18"->{
    Cell[110109, 4148, 262, 9, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.18"}]},
  "8.19"->{
    Cell[112088, 4216, 254, 9, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.19"}]},
  "8.20"->{
    Cell[112555, 4239, 437, 15, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.20"}]},
  "8.21"->{
    Cell[113252, 4268, 108, 1, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.21"}]},
  "8.22"->{
    Cell[113796, 4289, 103, 1, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.22"}]},
  "8.23"->{
    Cell[114143, 4304, 425, 8, 70, "Text",
      CellTags->{"S3.5.8", "8.23"}]},
  "8.24"->{
    Cell[114571, 4314, 283, 10, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.24"}]},
  "8.25"->{
    Cell[115084, 4338, 290, 8, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.25"}]},
  "8.26"->{
    Cell[115712, 4362, 234, 8, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.26"}]},
  "8.27"->{
    Cell[117210, 4420, 480, 17, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.27"}]},
  "8.28"->{
    Cell[117941, 4451, 440, 10, 70, "Text",
      CellTags->{"S3.5.8", "8.28"}]},
  "8.29"->{
    Cell[118384, 4463, 166, 5, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.29"}]},
  "8.30"->{
    Cell[118928, 4484, 227, 8, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.30"}]},
  "8.31"->{
    Cell[119441, 4509, 635, 21, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.31"}]},
  "8.32"->{
    Cell[124177, 4825, 266, 9, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.32"}]},
  "8.33"->{
    Cell[124794, 4852, 230, 8, 70, "MathCaption",
      CellTags->{"S3.5.8", "8.33"}]},
  "S3.5.9"->{
    Cell[129540, 5181, 81, 1, 70, "Subsection",
      CellTags->{"S3.5.9", "9.1"}],
    Cell[129624, 5184, 98, 1, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.2"}],
    Cell[129747, 5189, 122, 2, 70, "Input",
      CellTags->"S3.5.9"],
    Cell[129872, 5193, 86, 3, 70, "Output",
      CellTags->"S3.5.9"],
    Cell[129973, 5199, 82, 1, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.3"}],
    Cell[130080, 5204, 119, 2, 70, "Input",
      CellTags->"S3.5.9"],
    Cell[130202, 5208, 86, 3, 70, "Output",
      CellTags->"S3.5.9"],
    Cell[130303, 5214, 210, 5, 70, "Text",
      CellTags->{"S3.5.9", "9.4"}],
    Cell[130516, 5221, 84, 1, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.5"}],
    Cell[130625, 5226, 136, 5, 70, "Input",
      CellTags->"S3.5.9"],
    Cell[130764, 5233, 104, 3, 70, "Output",
      CellTags->"S3.5.9"],
    Cell[130883, 5239, 2254, 67, 70, "DefinitionBox",
      CellTags->"S3.5.9"],
    Cell[133140, 5308, 65, 1, 70, "Caption",
      CellTags->"S3.5.9"],
    Cell[133208, 5311, 208, 5, 70, "Text",
      CellTags->{"S3.5.9", "9.6"}],
    Cell[133419, 5318, 220, 8, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.7"}],
    Cell[133664, 5330, 111, 2, 70, "Input",
      CellTags->"S3.5.9"],
    Cell[133778, 5334, 444, 13, 70, "Output",
      CellTags->"S3.5.9"],
    Cell[134237, 5350, 125, 4, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.8"}],
    Cell[134387, 5358, 100, 2, 70, "Input",
      CellTags->"S3.5.9"],
    Cell[134490, 5362, 486, 13, 70, "Output",
      CellTags->"S3.5.9"],
    Cell[134991, 5378, 105, 1, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.9"}],
    Cell[135121, 5383, 117, 2, 70, "Input",
      CellTags->"S3.5.9"],
    Cell[135241, 5387, 431, 10, 70, "Output",
      CellTags->"S3.5.9"],
    Cell[135687, 5400, 109, 1, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.10"}],
    Cell[135821, 5405, 120, 2, 70, "Input",
      CellTags->"S3.5.9"],
    Cell[135944, 5409, 201, 4, 70, "Output",
      CellTags->"S3.5.9"],
    Cell[136160, 5416, 142, 4, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.11"}],
    Cell[136327, 5424, 114, 2, 70, "Input",
      CellTags->"S3.5.9"],
    Cell[136444, 5428, 82, 3, 70, "Output",
      CellTags->"S3.5.9"]},
  "9.1"->{
    Cell[129540, 5181, 81, 1, 70, "Subsection",
      CellTags->{"S3.5.9", "9.1"}]},
  "9.2"->{
    Cell[129624, 5184, 98, 1, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.2"}]},
  "9.3"->{
    Cell[129973, 5199, 82, 1, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.3"}]},
  "9.4"->{
    Cell[130303, 5214, 210, 5, 70, "Text",
      CellTags->{"S3.5.9", "9.4"}]},
  "9.5"->{
    Cell[130516, 5221, 84, 1, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.5"}]},
  "9.6"->{
    Cell[133208, 5311, 208, 5, 70, "Text",
      CellTags->{"S3.5.9", "9.6"}]},
  "9.7"->{
    Cell[133419, 5318, 220, 8, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.7"}]},
  "9.8"->{
    Cell[134237, 5350, 125, 4, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.8"}]},
  "9.9"->{
    Cell[134991, 5378, 105, 1, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.9"}]},
  "9.10"->{
    Cell[135687, 5400, 109, 1, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.10"}]},
  "9.11"->{
    Cell[136160, 5416, 142, 4, 70, "MathCaption",
      CellTags->{"S3.5.9", "9.11"}]},
  "S3.5.10"->{
    Cell[136575, 5437, 101, 1, 70, "Subsection",
      CellTags->{"S3.5.10", "10.1"}],
    Cell[136679, 5440, 263, 7, 70, "Text",
      CellTags->{"S3.5.10", "10.2"}],
    Cell[136945, 5449, 202, 5, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.3"}],
    Cell[137172, 5458, 87, 2, 70, "Input",
      CellTags->"S3.5.10"],
    Cell[137262, 5462, 125, 3, 70, "Output",
      CellTags->"S3.5.10"],
    Cell[137402, 5468, 132, 4, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.4"}],
    Cell[137559, 5476, 72, 2, 70, "Input",
      CellTags->"S3.5.10"],
    Cell[137634, 5480, 92, 3, 70, "Output",
      CellTags->"S3.5.10"],
    Cell[137741, 5486, 127, 4, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.5"}],
    Cell[137893, 5494, 97, 2, 70, "Input",
      CellTags->"S3.5.10"],
    Cell[137993, 5498, 135, 3, 70, "Output",
      CellTags->"S3.5.10"],
    Cell[138143, 5504, 108, 1, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.6"}],
    Cell[138276, 5509, 72, 2, 70, "Input",
      CellTags->"S3.5.10"],
    Cell[138351, 5513, 392, 11, 70, "Output",
      CellTags->"S3.5.10"],
    Cell[138758, 5527, 200, 6, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.7"}],
    Cell[138983, 5537, 100, 2, 70, "Input",
      CellTags->"S3.5.10"],
    Cell[139086, 5541, 122, 3, 70, "Output",
      CellTags->"S3.5.10"],
    Cell[139223, 5547, 158, 5, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.8"}],
    Cell[139406, 5556, 77, 2, 70, "Input",
      CellTags->"S3.5.10"],
    Cell[139486, 5560, 83, 3, 70, "Output",
      CellTags->"S3.5.10"],
    Cell[139584, 5566, 124, 4, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.9"}],
    Cell[139733, 5574, 78, 2, 70, "Input",
      CellTags->"S3.5.10"],
    Cell[139814, 5578, 118, 3, 70, "Output",
      CellTags->"S3.5.10"]},
  "10.1"->{
    Cell[136575, 5437, 101, 1, 70, "Subsection",
      CellTags->{"S3.5.10", "10.1"}]},
  "10.2"->{
    Cell[136679, 5440, 263, 7, 70, "Text",
      CellTags->{"S3.5.10", "10.2"}]},
  "10.3"->{
    Cell[136945, 5449, 202, 5, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.3"}]},
  "10.4"->{
    Cell[137402, 5468, 132, 4, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.4"}]},
  "10.5"->{
    Cell[137741, 5486, 127, 4, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.5"}]},
  "10.6"->{
    Cell[138143, 5504, 108, 1, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.6"}]},
  "10.7"->{
    Cell[138758, 5527, 200, 6, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.7"}]},
  "10.8"->{
    Cell[139223, 5547, 158, 5, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.8"}]},
  "10.9"->{
    Cell[139584, 5566, 124, 4, 70, "MathCaption",
      CellTags->{"S3.5.10", "10.9"}]},
  "S3.5.11"->{
    Cell[139981, 5587, 84, 1, 70, "Subsection",
      CellTags->{"S3.5.11", "11.1"}],
    Cell[140068, 5590, 363, 12, 70, "Text",
      CellTags->{"S3.5.11", "11.2"}],
    Cell[140434, 5604, 430, 12, 70, "Text",
      CellTags->{"S3.5.11", "11.3"}],
    Cell[140867, 5618, 1096, 35, 70, "Text",
      CellTags->{"S3.5.11", "11.4"}],
    Cell[141966, 5655, 236, 9, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.5"}],
    Cell[142227, 5668, 99, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[142329, 5672, 132, 3, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[142476, 5678, 247, 9, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.6"}],
    Cell[142748, 5691, 90, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[142841, 5695, 337, 10, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[143193, 5708, 254, 9, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.7"}],
    Cell[143472, 5721, 96, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[143571, 5725, 155, 4, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[143741, 5732, 146, 5, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.8"}],
    Cell[143912, 5741, 90, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[144005, 5745, 124, 3, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[144144, 5751, 166, 5, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.9"}],
    Cell[144335, 5760, 88, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[144426, 5764, 88, 3, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[144529, 5770, 1378, 43, 70, "DefinitionBox",
      CellTags->"S3.5.11"],
    Cell[145910, 5815, 116, 4, 70, "Caption",
      CellTags->"S3.5.11"],
    Cell[146029, 5821, 780, 12, 70, "Text",
      CellTags->{"S3.5.11", "11.10"}],
    Cell[146812, 5835, 1530, 43, 70, "DefinitionBox",
      CellTags->"S3.5.11"],
    Cell[148345, 5880, 87, 1, 70, "Caption",
      CellTags->"S3.5.11"],
    Cell[148435, 5883, 110, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.11"}],
    Cell[148570, 5888, 116, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[148689, 5892, 533, 13, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[149237, 5908, 186, 6, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.12"}],
    Cell[149448, 5918, 94, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[149545, 5922, 194, 4, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[149754, 5929, 288, 10, 70, "Text",
      CellTags->{"S3.5.11", "11.13"}],
    Cell[150045, 5941, 223, 9, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.14"}],
    Cell[150293, 5954, 110, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[150406, 5958, 124, 3, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[150545, 5964, 506, 12, 70, "Text",
      CellTags->{"S3.5.11", "11.15"}],
    Cell[151054, 5978, 643, 20, 70, "Text",
      CellTags->{"S3.5.11", "11.16"}],
    Cell[151700, 6000, 164, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.17"}],
    Cell[151889, 6008, 98, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[151990, 6012, 215, 5, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[152220, 6020, 176, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.18"}],
    Cell[152421, 6028, 121, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[152545, 6032, 423, 9, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[152983, 6044, 324, 6, 70, "Text",
      CellTags->{"S3.5.11", "11.19"}],
    Cell[153310, 6052, 227, 5, 70, "Text",
      CellTags->{"S3.5.11", "11.20"}],
    Cell[153540, 6059, 173, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.21"}],
    Cell[153738, 6067, 102, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[153843, 6071, 134, 3, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[153992, 6077, 153, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.22"}],
    Cell[154170, 6085, 102, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[154275, 6089, 241, 6, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[154531, 6098, 280, 6, 70, "Text",
      CellTags->{"S3.5.11", "11.23"}],
    Cell[154814, 6106, 596, 12, 70, "Text",
      CellTags->{"S3.5.11", "11.24"}],
    Cell[155413, 6120, 137, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.25"}],
    Cell[155575, 6128, 103, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[155681, 6132, 133, 3, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[155829, 6138, 111, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.26"}],
    Cell[155965, 6143, 108, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[156076, 6147, 212, 5, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[156303, 6155, 90, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.27"}],
    Cell[156418, 6160, 105, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[156526, 6164, 216, 6, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[156757, 6173, 86, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.28"}],
    Cell[156868, 6178, 110, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[156981, 6182, 305, 7, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[157301, 6192, 165, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.29"}],
    Cell[157491, 6200, 105, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[157599, 6204, 199, 5, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[157813, 6212, 453, 9, 70, "Text",
      CellTags->{"S3.5.11", "11.30"}],
    Cell[158269, 6223, 198, 5, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.31"}],
    Cell[158492, 6232, 104, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[158599, 6236, 398, 9, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[159012, 6248, 104, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.32"}],
    Cell[159141, 6253, 109, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[159253, 6257, 347, 7, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[159615, 6267, 418, 9, 70, "Text",
      CellTags->{"S3.5.11", "11.33"}],
    Cell[160036, 6278, 302, 8, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.34"}],
    Cell[160363, 6290, 102, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[160468, 6294, 120, 3, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[160603, 6300, 147, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.35"}],
    Cell[160775, 6308, 118, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[160896, 6312, 321, 7, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[161232, 6322, 132, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.36"}],
    Cell[161389, 6330, 111, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[161503, 6334, 202, 5, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[161720, 6342, 471, 16, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.37"}],
    Cell[162216, 6362, 111, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[162330, 6366, 268, 7, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[162613, 6376, 113, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.38"}],
    Cell[162751, 6381, 113, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[162867, 6385, 198, 4, 70, "Message",
      CellTags->"S3.5.11"],
    Cell[163068, 6391, 275, 6, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[163358, 6400, 284, 6, 70, "Text",
      CellTags->{"S3.5.11", "11.39"}],
    Cell[163645, 6408, 110, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.40"}],
    Cell[163780, 6413, 110, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[163893, 6417, 225, 6, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[164133, 6426, 116, 2, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.41"}],
    Cell[164274, 6432, 108, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[164385, 6436, 776, 20, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[165176, 6459, 258, 5, 70, "Text",
      CellTags->{"S3.5.11", "11.42"}],
    Cell[165437, 6466, 122, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.43"}],
    Cell[165584, 6474, 151, 5, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[165738, 6481, 504, 10, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[166257, 6494, 3420, 100, 70, "DefinitionBox",
      CellTags->"S3.5.11"],
    Cell[169680, 6596, 82, 1, 70, "Caption",
      CellTags->"S3.5.11"],
    Cell[169765, 6599, 356, 8, 70, "Text",
      CellTags->{"S3.5.11", "11.44"}],
    Cell[170124, 6609, 173, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.45"}],
    Cell[170322, 6617, 153, 5, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[170478, 6624, 217, 5, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[170710, 6632, 108, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.46"}],
    Cell[170843, 6637, 145, 5, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[170991, 6644, 242, 6, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[171248, 6653, 988, 28, 70, "Text",
      CellTags->{"S3.5.11", "11.47"}],
    Cell[172239, 6683, 119, 2, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.48"}],
    Cell[172383, 6689, 120, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[172506, 6693, 666, 20, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[173187, 6716, 129, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.49"}],
    Cell[173341, 6724, 104, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[173448, 6728, 158, 4, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[173621, 6735, 118, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.50"}],
    Cell[173764, 6743, 111, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[173878, 6747, 545, 17, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[174438, 6767, 152, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.51"}],
    Cell[174615, 6775, 92, 2, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[174710, 6779, 200, 5, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[174925, 6787, 491, 9, 70, "Text",
      CellTags->{"S3.5.11", "11.52"}],
    Cell[175419, 6798, 295, 6, 70, "Text",
      CellTags->{"S3.5.11", "11.53"}],
    Cell[175717, 6806, 185, 6, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.54"}],
    Cell[175927, 6816, 160, 5, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[176090, 6823, 188, 5, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[176293, 6831, 131, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.55"}],
    Cell[176449, 6839, 158, 5, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[176610, 6846, 181, 5, 70, "Output",
      CellTags->"S3.5.11"],
    Cell[176806, 6854, 112, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.56"}],
    Cell[176943, 6859, 143, 5, 70, "Input",
      CellTags->"S3.5.11"],
    Cell[177089, 6866, 200, 4, 70, "Message",
      CellTags->"S3.5.11"],
    Cell[177292, 6872, 138, 3, 70, "Output",
      CellTags->"S3.5.11"]},
  "11.1"->{
    Cell[139981, 5587, 84, 1, 70, "Subsection",
      CellTags->{"S3.5.11", "11.1"}]},
  "11.2"->{
    Cell[140068, 5590, 363, 12, 70, "Text",
      CellTags->{"S3.5.11", "11.2"}]},
  "11.3"->{
    Cell[140434, 5604, 430, 12, 70, "Text",
      CellTags->{"S3.5.11", "11.3"}]},
  "11.4"->{
    Cell[140867, 5618, 1096, 35, 70, "Text",
      CellTags->{"S3.5.11", "11.4"}]},
  "11.5"->{
    Cell[141966, 5655, 236, 9, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.5"}]},
  "11.6"->{
    Cell[142476, 5678, 247, 9, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.6"}]},
  "11.7"->{
    Cell[143193, 5708, 254, 9, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.7"}]},
  "11.8"->{
    Cell[143741, 5732, 146, 5, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.8"}]},
  "11.9"->{
    Cell[144144, 5751, 166, 5, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.9"}]},
  "11.10"->{
    Cell[146029, 5821, 780, 12, 70, "Text",
      CellTags->{"S3.5.11", "11.10"}]},
  "11.11"->{
    Cell[148435, 5883, 110, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.11"}]},
  "11.12"->{
    Cell[149237, 5908, 186, 6, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.12"}]},
  "11.13"->{
    Cell[149754, 5929, 288, 10, 70, "Text",
      CellTags->{"S3.5.11", "11.13"}]},
  "11.14"->{
    Cell[150045, 5941, 223, 9, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.14"}]},
  "11.15"->{
    Cell[150545, 5964, 506, 12, 70, "Text",
      CellTags->{"S3.5.11", "11.15"}]},
  "11.16"->{
    Cell[151054, 5978, 643, 20, 70, "Text",
      CellTags->{"S3.5.11", "11.16"}]},
  "11.17"->{
    Cell[151700, 6000, 164, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.17"}]},
  "11.18"->{
    Cell[152220, 6020, 176, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.18"}]},
  "11.19"->{
    Cell[152983, 6044, 324, 6, 70, "Text",
      CellTags->{"S3.5.11", "11.19"}]},
  "11.20"->{
    Cell[153310, 6052, 227, 5, 70, "Text",
      CellTags->{"S3.5.11", "11.20"}]},
  "11.21"->{
    Cell[153540, 6059, 173, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.21"}]},
  "11.22"->{
    Cell[153992, 6077, 153, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.22"}]},
  "11.23"->{
    Cell[154531, 6098, 280, 6, 70, "Text",
      CellTags->{"S3.5.11", "11.23"}]},
  "11.24"->{
    Cell[154814, 6106, 596, 12, 70, "Text",
      CellTags->{"S3.5.11", "11.24"}]},
  "11.25"->{
    Cell[155413, 6120, 137, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.25"}]},
  "11.26"->{
    Cell[155829, 6138, 111, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.26"}]},
  "11.27"->{
    Cell[156303, 6155, 90, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.27"}]},
  "11.28"->{
    Cell[156757, 6173, 86, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.28"}]},
  "11.29"->{
    Cell[157301, 6192, 165, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.29"}]},
  "11.30"->{
    Cell[157813, 6212, 453, 9, 70, "Text",
      CellTags->{"S3.5.11", "11.30"}]},
  "11.31"->{
    Cell[158269, 6223, 198, 5, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.31"}]},
  "11.32"->{
    Cell[159012, 6248, 104, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.32"}]},
  "11.33"->{
    Cell[159615, 6267, 418, 9, 70, "Text",
      CellTags->{"S3.5.11", "11.33"}]},
  "11.34"->{
    Cell[160036, 6278, 302, 8, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.34"}]},
  "11.35"->{
    Cell[160603, 6300, 147, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.35"}]},
  "11.36"->{
    Cell[161232, 6322, 132, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.36"}]},
  "11.37"->{
    Cell[161720, 6342, 471, 16, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.37"}]},
  "11.38"->{
    Cell[162613, 6376, 113, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.38"}]},
  "11.39"->{
    Cell[163358, 6400, 284, 6, 70, "Text",
      CellTags->{"S3.5.11", "11.39"}]},
  "11.40"->{
    Cell[163645, 6408, 110, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.40"}]},
  "11.41"->{
    Cell[164133, 6426, 116, 2, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.41"}]},
  "11.42"->{
    Cell[165176, 6459, 258, 5, 70, "Text",
      CellTags->{"S3.5.11", "11.42"}]},
  "11.43"->{
    Cell[165437, 6466, 122, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.43"}]},
  "11.44"->{
    Cell[169765, 6599, 356, 8, 70, "Text",
      CellTags->{"S3.5.11", "11.44"}]},
  "11.45"->{
    Cell[170124, 6609, 173, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.45"}]},
  "11.46"->{
    Cell[170710, 6632, 108, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.46"}]},
  "11.47"->{
    Cell[171248, 6653, 988, 28, 70, "Text",
      CellTags->{"S3.5.11", "11.47"}]},
  "11.48"->{
    Cell[172239, 6683, 119, 2, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.48"}]},
  "11.49"->{
    Cell[173187, 6716, 129, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.49"}]},
  "11.50"->{
    Cell[173621, 6735, 118, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.50"}]},
  "11.51"->{
    Cell[174438, 6767, 152, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.51"}]},
  "11.52"->{
    Cell[174925, 6787, 491, 9, 70, "Text",
      CellTags->{"S3.5.11", "11.52"}]},
  "11.53"->{
    Cell[175419, 6798, 295, 6, 70, "Text",
      CellTags->{"S3.5.11", "11.53"}]},
  "11.54"->{
    Cell[175717, 6806, 185, 6, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.54"}]},
  "11.55"->{
    Cell[176293, 6831, 131, 4, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.55"}]},
  "11.56"->{
    Cell[176806, 6854, 112, 1, 70, "MathCaption",
      CellTags->{"S3.5.11", "11.56"}]},
  "S3.5.12"->{
    Cell[177479, 6881, 104, 1, 70, "Subsection",
      CellTags->{"S3.5.12", "12.1"}],
    Cell[177608, 6886, 76, 1, 70, "Subsubsection",
      CellTags->{"S3.5.12", "12.2"}],
    Cell[177687, 6889, 1214, 38, 70, "DefinitionBox",
      CellTags->"S3.5.12"],
    Cell[178904, 6929, 94, 3, 70, "Caption",
      CellTags->"S3.5.12"],
    Cell[179001, 6934, 1991, 70, 70, "Text",
      CellTags->{"S3.5.12", "12.3"}],
    Cell[180995, 7006, 92, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.4"}],
    Cell[181112, 7011, 99, 2, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[181214, 7015, 149, 4, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[181378, 7022, 77, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.5"}],
    Cell[181480, 7027, 97, 2, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[181580, 7031, 94, 3, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[181689, 7037, 112, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.6"}],
    Cell[181826, 7042, 100, 2, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[181929, 7046, 159, 4, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[182103, 7053, 102, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.7"}],
    Cell[182230, 7058, 100, 2, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[182333, 7062, 163, 4, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[182511, 7069, 148, 4, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.8"}],
    Cell[182684, 7077, 102, 2, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[182789, 7081, 130, 3, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[182934, 7087, 275, 6, 70, "Text",
      CellTags->{"S3.5.12", "12.9"}],
    Cell[183212, 7095, 293, 9, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.10"}],
    Cell[183530, 7108, 115, 2, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[183648, 7112, 113, 3, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[183776, 7118, 3224, 92, 70, "DefinitionBox",
      CellTags->"S3.5.12"],
    Cell[187003, 7212, 79, 1, 70, "Caption",
      CellTags->"S3.5.12"],
    Cell[187119, 7218, 77, 1, 70, "Subsubsection",
      CellTags->{"S3.5.12", "12.11"}],
    Cell[187199, 7221, 1336, 40, 70, "DefinitionBox",
      CellTags->"S3.5.12"],
    Cell[188538, 7263, 94, 3, 70, "Caption",
      CellTags->"S3.5.12"],
    Cell[188635, 7268, 86, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.12"}],
    Cell[188746, 7273, 115, 4, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[188864, 7279, 442, 8, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[189321, 7290, 81, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.13"}],
    Cell[189427, 7295, 112, 4, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[189542, 7301, 97, 3, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[189654, 7307, 1660, 56, 70, "Text",
      CellTags->{"S3.5.12", "12.14"}],
    Cell[191317, 7365, 339, 8, 70, "Text",
      CellTags->{"S3.5.12", "12.15"}],
    Cell[191659, 7375, 13960, 361, 70, "DefinitionBox4Col",
      CellTags->"S3.5.12"],
    Cell[205622, 7738, 151, 5, 70, "Caption",
      CellTags->"S3.5.12"],
    Cell[205776, 7745, 134, 4, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.16"}],
    Cell[205935, 7753, 113, 4, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[206051, 7759, 127, 3, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[206193, 7765, 169, 4, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.17"}],
    Cell[206387, 7773, 146, 5, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[206536, 7780, 138, 3, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[206689, 7786, 2087, 58, 70, "DefinitionBox",
      CellTags->"S3.5.12"],
    Cell[208779, 7846, 78, 1, 70, "Caption",
      CellTags->"S3.5.12"],
    Cell[208860, 7849, 1271, 40, 70, "Text",
      CellTags->{"S3.5.12", "12.18"}],
    Cell[210134, 7891, 342, 12, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.19"}],
    Cell[210501, 7907, 161, 5, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[210665, 7914, 172, 4, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[210852, 7921, 7719, 218, 70, "DefinitionBox",
      CellTags->"S3.5.12"],
    Cell[218574, 8141, 79, 1, 70, "Caption",
      CellTags->"S3.5.12"],
    Cell[218656, 8144, 127, 4, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.20"}],
    Cell[218808, 8152, 120, 2, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[218931, 8156, 191, 5, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[219137, 8164, 85, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.21"}],
    Cell[219247, 8169, 107, 2, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[219357, 8173, 131, 3, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[219537, 8182, 71, 1, 70, "Subsubsection",
      CellTags->{"S3.5.12", "12.22"}],
    Cell[219611, 8185, 1182, 38, 70, "DefinitionBox",
      CellTags->"S3.5.12"],
    Cell[220796, 8225, 56, 1, 70, "Caption",
      CellTags->"S3.5.12"],
    Cell[220855, 8228, 2043, 66, 70, "Text",
      CellTags->{"S3.5.12", "12.23"}],
    Cell[222901, 8296, 285, 10, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.24"}],
    Cell[223211, 8310, 87, 2, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[223301, 8314, 109, 3, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[223425, 8320, 90, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.25"}],
    Cell[223540, 8325, 91, 2, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[223634, 8329, 91, 3, 70, "Output",
      CellTags->"S3.5.12"],
    Cell[223740, 8335, 281, 9, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.26"}],
    Cell[224046, 8348, 87, 2, 70, "Input",
      CellTags->"S3.5.12"],
    Cell[224136, 8352, 107, 3, 70, "Output",
      CellTags->"S3.5.12"]},
  "12.1"->{
    Cell[177479, 6881, 104, 1, 70, "Subsection",
      CellTags->{"S3.5.12", "12.1"}]},
  "12.2"->{
    Cell[177608, 6886, 76, 1, 70, "Subsubsection",
      CellTags->{"S3.5.12", "12.2"}]},
  "12.3"->{
    Cell[179001, 6934, 1991, 70, 70, "Text",
      CellTags->{"S3.5.12", "12.3"}]},
  "12.4"->{
    Cell[180995, 7006, 92, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.4"}]},
  "12.5"->{
    Cell[181378, 7022, 77, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.5"}]},
  "12.6"->{
    Cell[181689, 7037, 112, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.6"}]},
  "12.7"->{
    Cell[182103, 7053, 102, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.7"}]},
  "12.8"->{
    Cell[182511, 7069, 148, 4, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.8"}]},
  "12.9"->{
    Cell[182934, 7087, 275, 6, 70, "Text",
      CellTags->{"S3.5.12", "12.9"}]},
  "12.10"->{
    Cell[183212, 7095, 293, 9, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.10"}]},
  "12.11"->{
    Cell[187119, 7218, 77, 1, 70, "Subsubsection",
      CellTags->{"S3.5.12", "12.11"}]},
  "12.12"->{
    Cell[188635, 7268, 86, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.12"}]},
  "12.13"->{
    Cell[189321, 7290, 81, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.13"}]},
  "12.14"->{
    Cell[189654, 7307, 1660, 56, 70, "Text",
      CellTags->{"S3.5.12", "12.14"}]},
  "12.15"->{
    Cell[191317, 7365, 339, 8, 70, "Text",
      CellTags->{"S3.5.12", "12.15"}]},
  "12.16"->{
    Cell[205776, 7745, 134, 4, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.16"}]},
  "12.17"->{
    Cell[206193, 7765, 169, 4, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.17"}]},
  "12.18"->{
    Cell[208860, 7849, 1271, 40, 70, "Text",
      CellTags->{"S3.5.12", "12.18"}]},
  "12.19"->{
    Cell[210134, 7891, 342, 12, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.19"}]},
  "12.20"->{
    Cell[218656, 8144, 127, 4, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.20"}]},
  "12.21"->{
    Cell[219137, 8164, 85, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.21"}]},
  "12.22"->{
    Cell[219537, 8182, 71, 1, 70, "Subsubsection",
      CellTags->{"S3.5.12", "12.22"}]},
  "12.23"->{
    Cell[220855, 8228, 2043, 66, 70, "Text",
      CellTags->{"S3.5.12", "12.23"}]},
  "12.24"->{
    Cell[222901, 8296, 285, 10, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.24"}]},
  "12.25"->{
    Cell[223425, 8320, 90, 1, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.25"}]},
  "12.26"->{
    Cell[223740, 8335, 281, 9, 70, "MathCaption",
      CellTags->{"S3.5.12", "12.26"}]},
  "S3.5.13"->{
    Cell[224304, 8362, 103, 1, 70, "Subsection",
      CellTags->{"S3.5.13", "13.1"}],
    Cell[224410, 8365, 547, 11, 70, "Text",
      CellTags->{"S3.5.13", "13.2"}],
    Cell[224960, 8378, 1480, 44, 70, "DefinitionBox",
      CellTags->"S3.5.13"],
    Cell[226443, 8424, 79, 1, 70, "Caption",
      CellTags->"S3.5.13"],
    Cell[226525, 8427, 259, 9, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.3"}],
    Cell[226809, 8440, 123, 2, 70, "Input",
      CellTags->"S3.5.13"],
    Cell[226935, 8444, 15238, 995, 70, 15164, 992, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.5.13"],
    Cell[242176, 9441, 178, 5, 70, "Output",
      CellTags->"S3.5.13"],
    Cell[242369, 9449, 256, 8, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.4"}],
    Cell[242650, 9461, 162, 5, 70, "Input",
      CellTags->"S3.5.13"],
    Cell[242815, 9468, 22596, 1470, 70, 22522, 1467, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.5.13"],
    Cell[265414, 10940, 178, 5, 70, "Output",
      CellTags->"S3.5.13"],
    Cell[265607, 10948, 280, 9, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.5"}],
    Cell[265912, 10961, 156, 5, 70, "Input",
      CellTags->"S3.5.13"],
    Cell[266071, 10968, 83, 3, 70, "Output",
      CellTags->"S3.5.13"],
    Cell[266169, 10974, 292, 8, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.6"}],
    Cell[266486, 10986, 115, 2, 70, "Input",
      CellTags->"S3.5.13"],
    Cell[266604, 10990, 83, 3, 70, "Output",
      CellTags->"S3.5.13"],
    Cell[266702, 10996, 294, 10, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.7"}],
    Cell[267021, 11010, 97, 2, 70, "Input",
      CellTags->"S3.5.13"],
    Cell[267121, 11014, 115, 3, 70, "Output",
      CellTags->"S3.5.13"],
    Cell[267251, 11020, 220, 5, 70, "Text",
      CellTags->{"S3.5.13", "13.8"}],
    Cell[267474, 11027, 173, 7, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.9"}],
    Cell[267672, 11038, 110, 2, 70, "Input",
      CellTags->"S3.5.13"],
    Cell[267785, 11042, 86, 3, 70, "Output",
      CellTags->"S3.5.13"],
    Cell[267886, 11048, 102, 1, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.10"}],
    Cell[268013, 11053, 110, 2, 70, "Input",
      CellTags->"S3.5.13"],
    Cell[268126, 11057, 88, 3, 70, "Output",
      CellTags->"S3.5.13"],
    Cell[268229, 11063, 329, 10, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.11"}],
    Cell[268583, 11077, 108, 2, 70, "Input",
      CellTags->"S3.5.13"],
    Cell[268694, 11081, 84, 3, 70, "Output",
      CellTags->"S3.5.13"],
    Cell[268793, 11087, 1605, 53, 70, "Text",
      CellTags->{"S3.5.13", "13.12"}],
    Cell[270401, 11142, 140, 4, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.13"}],
    Cell[270566, 11150, 92, 2, 70, "Input",
      CellTags->"S3.5.13"],
    Cell[270661, 11154, 93, 3, 70, "Output",
      CellTags->"S3.5.13"],
    Cell[270769, 11160, 87, 1, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.14"}],
    Cell[270881, 11165, 100, 2, 70, "Input",
      CellTags->"S3.5.13"],
    Cell[270984, 11169, 11586, 759, 70, 11512, 756, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.5.13"],
    Cell[282573, 11930, 179, 5, 70, "Output",
      CellTags->"S3.5.13"],
    Cell[282767, 11938, 98, 1, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.15"}],
    Cell[282890, 11943, 105, 2, 70, "Input",
      CellTags->"S3.5.13"],
    Cell[282998, 11947, 91, 3, 70, "Output",
      CellTags->"S3.5.13"],
    Cell[283104, 11953, 340, 11, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.16"}],
    Cell[283469, 11968, 111, 2, 70, "Input",
      CellTags->"S3.5.13"],
    Cell[283583, 11972, 121, 3, 70, "Output",
      CellTags->"S3.5.13"],
    Cell[283719, 11978, 182, 6, 70, "Text",
      CellTags->{"S3.5.13", "13.17"}],
    Cell[283904, 11986, 133, 4, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.18"}],
    Cell[284062, 11994, 98, 2, 28, "Input",
      CellTags->"S3.5.13"],
    Cell[284163, 11998, 119, 3, 70, "Output",
      CellTags->"S3.5.13"],
    Cell[284297, 12004, 318, 10, 40, "MathCaption",
      CellTags->{"S3.5.13", "13.19"}],
    Cell[284640, 12018, 103, 2, 28, "Input",
      CellTags->"S3.5.13"],
    Cell[284746, 12022, 173, 4, 49, "Output",
      CellTags->"S3.5.13"],
    Cell[284934, 12029, 264, 6, 40, "Text",
      CellTags->{"S3.5.13", "13.20"}],
    Cell[285201, 12037, 299, 10, 40, "MathCaption",
      CellTags->{"S3.5.13", "13.21"}],
    Cell[285525, 12051, 146, 5, 45, "Input",
      CellTags->"S3.5.13"],
    Cell[285674, 12058, 133, 3, 51, "Output",
      CellTags->"S3.5.13"],
    Cell[285822, 12064, 2441, 72, 102, "DefinitionBox",
      CellTags->"S3.5.13"],
    Cell[288266, 12138, 96, 1, 16, "Caption",
      CellTags->"S3.5.13"],
    Cell[288365, 12141, 1417, 46, 57, "Text",
      CellTags->{"S3.5.13", "13.22"}],
    Cell[289785, 12189, 2744, 77, 84, "DefinitionBox",
      CellTags->"S3.5.13"],
    Cell[292532, 12268, 67, 1, 16, "Caption",
      CellTags->"S3.5.13"]},
  "13.1"->{
    Cell[224304, 8362, 103, 1, 70, "Subsection",
      CellTags->{"S3.5.13", "13.1"}]},
  "13.2"->{
    Cell[224410, 8365, 547, 11, 70, "Text",
      CellTags->{"S3.5.13", "13.2"}]},
  "13.3"->{
    Cell[226525, 8427, 259, 9, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.3"}]},
  "13.4"->{
    Cell[242369, 9449, 256, 8, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.4"}]},
  "13.5"->{
    Cell[265607, 10948, 280, 9, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.5"}]},
  "13.6"->{
    Cell[266169, 10974, 292, 8, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.6"}]},
  "13.7"->{
    Cell[266702, 10996, 294, 10, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.7"}]},
  "13.8"->{
    Cell[267251, 11020, 220, 5, 70, "Text",
      CellTags->{"S3.5.13", "13.8"}]},
  "13.9"->{
    Cell[267474, 11027, 173, 7, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.9"}]},
  "13.10"->{
    Cell[267886, 11048, 102, 1, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.10"}]},
  "13.11"->{
    Cell[268229, 11063, 329, 10, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.11"}]},
  "13.12"->{
    Cell[268793, 11087, 1605, 53, 70, "Text",
      CellTags->{"S3.5.13", "13.12"}]},
  "13.13"->{
    Cell[270401, 11142, 140, 4, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.13"}]},
  "13.14"->{
    Cell[270769, 11160, 87, 1, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.14"}]},
  "13.15"->{
    Cell[282767, 11938, 98, 1, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.15"}]},
  "13.16"->{
    Cell[283104, 11953, 340, 11, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.16"}]},
  "13.17"->{
    Cell[283719, 11978, 182, 6, 70, "Text",
      CellTags->{"S3.5.13", "13.17"}]},
  "13.18"->{
    Cell[283904, 11986, 133, 4, 70, "MathCaption",
      CellTags->{"S3.5.13", "13.18"}]},
  "13.19"->{
    Cell[284297, 12004, 318, 10, 40, "MathCaption",
      CellTags->{"S3.5.13", "13.19"}]},
  "13.20"->{
    Cell[284934, 12029, 264, 6, 40, "Text",
      CellTags->{"S3.5.13", "13.20"}]},
  "13.21"->{
    Cell[285201, 12037, 299, 10, 40, "MathCaption",
      CellTags->{"S3.5.13", "13.21"}]},
  "13.22"->{
    Cell[288365, 12141, 1417, 46, 57, "Text",
      CellTags->{"S3.5.13", "13.22"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S3.5.0", 293242, 12289},
  {"0.1", 293332, 12292},
  {"S3.5.1", 293425, 12295},
  {"1.1", 295797, 12360},
  {"1.2", 295889, 12363},
  {"1.3", 295985, 12366},
  {"1.4", 296079, 12369},
  {"1.5", 296174, 12372},
  {"1.6", 296270, 12375},
  {"1.7", 296366, 12378},
  {"1.8", 296462, 12381},
  {"1.9", 296559, 12384},
  {"1.10", 296655, 12387},
  {"S3.5.2", 296755, 12390},
  {"2.1", 299798, 12471},
  {"2.2", 299892, 12474},
  {"2.3", 299983, 12477},
  {"2.4", 300074, 12480},
  {"2.5", 300164, 12483},
  {"2.6", 300261, 12486},
  {"2.7", 300358, 12489},
  {"2.8", 300456, 12492},
  {"2.9", 300554, 12495},
  {"2.10", 300652, 12498},
  {"2.11", 300751, 12501},
  {"2.12", 300850, 12504},
  {"2.13", 300949, 12507},
  {"2.14", 301048, 12510},
  {"2.15", 301147, 12513},
  {"2.16", 301247, 12516},
  {"S3.5.3", 301348, 12519},
  {"3.1", 303171, 12568},
  {"3.2", 303266, 12571},
  {"3.3", 303363, 12574},
  {"3.4", 303460, 12577},
  {"3.5", 303557, 12580},
  {"3.6", 303654, 12583},
  {"3.7", 303751, 12586},
  {"3.8", 303849, 12589},
  {"S3.5.4", 303950, 12592},
  {"4.1", 309055, 12727},
  {"4.2", 309151, 12730},
  {"4.3", 309241, 12733},
  {"4.4", 309334, 12736},
  {"4.5", 309426, 12739},
  {"4.6", 309517, 12742},
  {"4.7", 309608, 12745},
  {"4.8", 309699, 12748},
  {"4.9", 309796, 12751},
  {"4.10", 309894, 12754},
  {"4.11", 309992, 12757},
  {"4.12", 310091, 12760},
  {"4.13", 310189, 12763},
  {"4.14", 310288, 12766},
  {"4.15", 310386, 12769},
  {"4.16", 310485, 12772},
  {"4.17", 310584, 12775},
  {"4.18", 310682, 12778},
  {"4.19", 310775, 12781},
  {"4.20", 310874, 12784},
  {"4.21", 310973, 12787},
  {"4.22", 311073, 12790},
  {"4.23", 311165, 12793},
  {"4.24", 311264, 12796},
  {"4.25", 311363, 12799},
  {"4.26", 311462, 12802},
  {"4.27", 311561, 12805},
  {"4.28", 311654, 12808},
  {"4.29", 311747, 12811},
  {"4.30", 311846, 12814},
  {"S3.5.5", 311947, 12817},
  {"5.1", 314234, 12878},
  {"5.2", 314329, 12881},
  {"5.3", 314420, 12884},
  {"5.4", 314518, 12887},
  {"5.5", 314615, 12890},
  {"5.6", 314712, 12893},
  {"5.7", 314809, 12896},
  {"5.8", 314906, 12899},
  {"5.9", 315003, 12902},
  {"5.10", 315101, 12905},
  {"5.11", 315193, 12908},
  {"5.12", 315292, 12911},
  {"S3.5.6", 315392, 12914},
  {"6.1", 319344, 13019},
  {"6.2", 319439, 13022},
  {"6.3", 319530, 13025},
  {"6.4", 319621, 13028},
  {"6.5", 319711, 13031},
  {"6.6", 319808, 13034},
  {"6.7", 319905, 13037},
  {"6.8", 320003, 13040},
  {"6.9", 320100, 13043},
  {"6.10", 320198, 13046},
  {"6.11", 320291, 13049},
  {"6.12", 320390, 13052},
  {"6.13", 320489, 13055},
  {"6.14", 320583, 13058},
  {"6.15", 320682, 13061},
  {"6.16", 320781, 13064},
  {"6.17", 320873, 13067},
  {"6.18", 320972, 13070},
  {"6.19", 321071, 13073},
  {"6.20", 321170, 13076},
  {"6.21", 321268, 13079},
  {"6.22", 321368, 13082},
  {"S3.5.7", 321469, 13085},
  {"7.1", 328158, 13262},
  {"7.2", 328253, 13265},
  {"7.3", 328343, 13268},
  {"7.4", 328433, 13271},
  {"7.5", 328530, 13274},
  {"7.6", 328627, 13277},
  {"7.7", 328724, 13280},
  {"7.8", 328821, 13283},
  {"7.9", 328918, 13286},
  {"7.10", 329009, 13289},
  {"7.11", 329108, 13292},
  {"7.12", 329200, 13295},
  {"7.13", 329293, 13298},
  {"7.14", 329392, 13301},
  {"7.15", 329491, 13304},
  {"7.16", 329590, 13307},
  {"7.17", 329689, 13310},
  {"7.18", 329788, 13313},
  {"7.19", 329887, 13316},
  {"7.20", 329986, 13319},
  {"7.21", 330085, 13322},
  {"7.22", 330184, 13325},
  {"7.23", 330283, 13328},
  {"7.24", 330382, 13331},
  {"7.25", 330475, 13334},
  {"7.26", 330574, 13337},
  {"7.27", 330673, 13340},
  {"7.28", 330772, 13343},
  {"7.29", 330864, 13346},
  {"7.30", 330963, 13349},
  {"7.31", 331062, 13352},
  {"7.32", 331154, 13355},
  {"7.33", 331247, 13358},
  {"7.34", 331346, 13361},
  {"7.35", 331445, 13364},
  {"7.36", 331544, 13367},
  {"7.37", 331643, 13370},
  {"S3.5.8", 331738, 13373},
  {"8.1", 339412, 13574},
  {"8.2", 339507, 13577},
  {"8.3", 339606, 13580},
  {"8.4", 339705, 13583},
  {"8.5", 339804, 13586},
  {"8.6", 339895, 13589},
  {"8.7", 339993, 13592},
  {"8.8", 340091, 13595},
  {"8.9", 340189, 13598},
  {"8.10", 340288, 13601},
  {"8.11", 340388, 13604},
  {"8.12", 340488, 13607},
  {"8.13", 340581, 13610},
  {"8.14", 340682, 13613},
  {"8.15", 340782, 13616},
  {"8.16", 340882, 13619},
  {"8.17", 340982, 13622},
  {"8.18", 341082, 13625},
  {"8.19", 341182, 13628},
  {"8.20", 341282, 13631},
  {"8.21", 341383, 13634},
  {"8.22", 341483, 13637},
  {"8.23", 341583, 13640},
  {"8.24", 341676, 13643},
  {"8.25", 341777, 13646},
  {"8.26", 341877, 13649},
  {"8.27", 341977, 13652},
  {"8.28", 342078, 13655},
  {"8.29", 342172, 13658},
  {"8.30", 342272, 13661},
  {"8.31", 342372, 13664},
  {"8.32", 342473, 13667},
  {"8.33", 342573, 13670},
  {"S3.5.9", 342675, 13673},
  {"9.1", 344913, 13732},
  {"9.2", 345009, 13735},
  {"9.3", 345106, 13738},
  {"9.4", 345203, 13741},
  {"9.5", 345294, 13744},
  {"9.6", 345391, 13747},
  {"9.7", 345482, 13750},
  {"9.8", 345580, 13753},
  {"9.9", 345678, 13756},
  {"9.10", 345777, 13759},
  {"9.11", 345877, 13762},
  {"S3.5.10", 345980, 13765},
  {"10.1", 347785, 13812},
  {"10.2", 347885, 13815},
  {"10.3", 347979, 13818},
  {"10.4", 348080, 13821},
  {"10.5", 348181, 13824},
  {"10.6", 348282, 13827},
  {"10.7", 348383, 13830},
  {"10.8", 348484, 13833},
  {"10.9", 348585, 13836},
  {"S3.5.11", 348689, 13839},
  {"11.1", 359383, 14112},
  {"11.2", 359482, 14115},
  {"11.3", 359577, 14118},
  {"11.4", 359672, 14121},
  {"11.5", 359768, 14124},
  {"11.6", 359869, 14127},
  {"11.7", 359970, 14130},
  {"11.8", 360071, 14133},
  {"11.9", 360172, 14136},
  {"11.10", 360274, 14139},
  {"11.11", 360371, 14142},
  {"11.12", 360474, 14145},
  {"11.13", 360577, 14148},
  {"11.14", 360674, 14151},
  {"11.15", 360777, 14154},
  {"11.16", 360874, 14157},
  {"11.17", 360971, 14160},
  {"11.18", 361074, 14163},
  {"11.19", 361177, 14166},
  {"11.20", 361273, 14169},
  {"11.21", 361369, 14172},
  {"11.22", 361472, 14175},
  {"11.23", 361575, 14178},
  {"11.24", 361671, 14181},
  {"11.25", 361768, 14184},
  {"11.26", 361871, 14187},
  {"11.27", 361974, 14190},
  {"11.28", 362076, 14193},
  {"11.29", 362178, 14196},
  {"11.30", 362281, 14199},
  {"11.31", 362377, 14202},
  {"11.32", 362480, 14205},
  {"11.33", 362583, 14208},
  {"11.34", 362679, 14211},
  {"11.35", 362782, 14214},
  {"11.36", 362885, 14217},
  {"11.37", 362988, 14220},
  {"11.38", 363092, 14223},
  {"11.39", 363195, 14226},
  {"11.40", 363291, 14229},
  {"11.41", 363394, 14232},
  {"11.42", 363497, 14235},
  {"11.43", 363593, 14238},
  {"11.44", 363696, 14241},
  {"11.45", 363792, 14244},
  {"11.46", 363895, 14247},
  {"11.47", 363998, 14250},
  {"11.48", 364095, 14253},
  {"11.49", 364198, 14256},
  {"11.50", 364301, 14259},
  {"11.51", 364404, 14262},
  {"11.52", 364507, 14265},
  {"11.53", 364603, 14268},
  {"11.54", 364699, 14271},
  {"11.55", 364802, 14274},
  {"11.56", 364905, 14277},
  {"S3.5.12", 365010, 14280},
  {"12.1", 370697, 14425},
  {"12.2", 370797, 14428},
  {"12.3", 370899, 14431},
  {"12.4", 370995, 14434},
  {"12.5", 371095, 14437},
  {"12.6", 371195, 14440},
  {"12.7", 371296, 14443},
  {"12.8", 371397, 14446},
  {"12.9", 371498, 14449},
  {"12.10", 371593, 14452},
  {"12.11", 371696, 14455},
  {"12.12", 371800, 14458},
  {"12.13", 371902, 14461},
  {"12.14", 372004, 14464},
  {"12.15", 372102, 14467},
  {"12.16", 372198, 14470},
  {"12.17", 372301, 14473},
  {"12.18", 372404, 14476},
  {"12.19", 372502, 14479},
  {"12.20", 372606, 14482},
  {"12.21", 372709, 14485},
  {"12.22", 372811, 14488},
  {"12.23", 372915, 14491},
  {"12.24", 373013, 14494},
  {"12.25", 373117, 14497},
  {"12.26", 373219, 14500},
  {"S3.5.13", 373324, 14503},
  {"13.1", 378402, 14632},
  {"13.2", 378502, 14635},
  {"13.3", 378597, 14638},
  {"13.4", 378698, 14641},
  {"13.5", 378799, 14644},
  {"13.6", 378901, 14647},
  {"13.7", 379003, 14650},
  {"13.8", 379106, 14653},
  {"13.9", 379201, 14656},
  {"13.10", 379304, 14659},
  {"13.11", 379408, 14662},
  {"13.12", 379513, 14665},
  {"13.13", 379612, 14668},
  {"13.14", 379716, 14671},
  {"13.15", 379819, 14674},
  {"13.16", 379922, 14677},
  {"13.17", 380027, 14680},
  {"13.18", 380124, 14683},
  {"13.19", 380228, 14686},
  {"13.20", 380333, 14689},
  {"13.21", 380430, 14692},
  {"13.22", 380535, 14695}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 111, 4, 65, "Section",
  CellTags->{"S3.5.0", "0.1"}],

Cell[CellGroupData[{
Cell[1912, 61, 74, 1, 70, "Subsection",
  CellTags->{"S3.5.1", "1.1"}],
Cell[1989, 64, 5170, 149, 70, "DefinitionBox",
  CellTags->"S3.5.1"],
Cell[7162, 215, 77, 1, 70, "Caption",
  CellTags->"S3.5.1"],
Cell[7242, 218, 427, 16, 70, "MathCaption",
  CellTags->{"S3.5.1", "1.2"}],

Cell[CellGroupData[{
Cell[7694, 238, 73, 2, 70, "Input",
  CellTags->"S3.5.1"],
Cell[7770, 242, 101, 3, 70, "Output",
  CellTags->"S3.5.1"]
}, Open  ]],
Cell[7886, 248, 87, 1, 70, "MathCaption",
  CellTags->{"S3.5.1", "1.3"}],

Cell[CellGroupData[{
Cell[7998, 253, 78, 2, 70, "Input",
  CellTags->"S3.5.1"],
Cell[8079, 257, 137, 3, 70, "Output",
  CellTags->"S3.5.1"]
}, Open  ]],
Cell[8231, 263, 174, 4, 70, "MathCaption",
  CellTags->{"S3.5.1", "1.4"}],

Cell[CellGroupData[{
Cell[8430, 271, 90, 2, 70, "Input",
  CellTags->"S3.5.1"],
Cell[8523, 275, 88, 3, 70, "Output",
  CellTags->"S3.5.1"]
}, Open  ]],
Cell[8626, 281, 252, 10, 70, "MathCaption",
  CellTags->{"S3.5.1", "1.5"}],

Cell[CellGroupData[{
Cell[8903, 295, 79, 2, 70, "Input",
  CellTags->"S3.5.1"],
Cell[8985, 299, 85, 3, 70, "Output",
  CellTags->"S3.5.1"]
}, Open  ]],
Cell[9085, 305, 403, 15, 70, "MathCaption",
  CellTags->{"S3.5.1", "1.6"}],

Cell[CellGroupData[{
Cell[9513, 324, 82, 2, 70, "Input",
  CellTags->"S3.5.1"],
Cell[9598, 328, 257, 7, 70, "Output",
  CellTags->"S3.5.1"]
}, Open  ]],
Cell[9870, 338, 785, 33, 70, "MathCaption",
  CellTags->{"S3.5.1", "1.7"}],

Cell[CellGroupData[{
Cell[10680, 375, 100, 2, 70, "Input",
  CellTags->"S3.5.1"],
Cell[10783, 379, 127, 3, 70, "Output",
  CellTags->"S3.5.1"]
}, Open  ]],
Cell[10925, 385, 5468, 158, 70, "DefinitionBox",
  CellTags->"S3.5.1"],
Cell[16396, 545, 61, 1, 70, "Caption",
  CellTags->"S3.5.1"],
Cell[16460, 548, 369, 13, 70, "MathCaption",
  CellTags->{"S3.5.1", "1.8"}],

Cell[CellGroupData[{
Cell[16854, 565, 86, 2, 70, "Input",
  CellTags->"S3.5.1"],
Cell[16943, 569, 93, 3, 70, "Output",
  CellTags->"S3.5.1"]
}, Open  ]],
Cell[17051, 575, 78, 1, 70, "MathCaption",
  CellTags->{"S3.5.1", "1.9"}],

Cell[CellGroupData[{
Cell[17154, 580, 89, 2, 70, "Input",
  CellTags->"S3.5.1"],
Cell[17246, 584, 97, 3, 70, "Output",
  CellTags->"S3.5.1"]
}, Open  ]],
Cell[17358, 590, 102, 1, 70, "MathCaption",
  CellTags->{"S3.5.1", "1.10"}],

Cell[CellGroupData[{
Cell[17485, 595, 93, 2, 70, "Input",
  CellTags->"S3.5.1"],
Cell[17581, 599, 103, 3, 70, "Output",
  CellTags->"S3.5.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17733, 608, 76, 1, 70, "Subsection",
  CellTags->{"S3.5.2", "2.1"}],
Cell[17812, 611, 5426, 166, 70, "DefinitionBox",
  CellTags->"S3.5.2"],
Cell[23241, 779, 75, 1, 70, "Caption",
  CellTags->"S3.5.2"],
Cell[23319, 782, 1597, 58, 70, "Text",
  CellTags->{"S3.5.2", "2.2"}],
Cell[24919, 842, 1538, 55, 70, "Text",
  CellTags->{"S3.5.2", "2.3"}],
Cell[26460, 899, 668, 26, 70, "Text",
  CellTags->{"S3.5.2", "2.4"}],
Cell[27131, 927, 696, 26, 70, "MathCaption",
  CellTags->{"S3.5.2", "2.5"}],

Cell[CellGroupData[{
Cell[27852, 957, 79, 2, 70, "Input",
  CellTags->"S3.5.2"],
Cell[27934, 961, 85, 3, 70, "Output",
  CellTags->"S3.5.2"]
}, Open  ]],
Cell[28034, 967, 686, 27, 70, "MathCaption",
  CellTags->{"S3.5.2", "2.6"}],

Cell[CellGroupData[{
Cell[28745, 998, 80, 2, 70, "Input",
  CellTags->"S3.5.2"],
Cell[28828, 1002, 102, 3, 70, "Output",
  CellTags->"S3.5.2"]
}, Open  ]],
Cell[28945, 1008, 296, 11, 70, "MathCaption",
  CellTags->{"S3.5.2", "2.7"}],

Cell[CellGroupData[{
Cell[29266, 1023, 83, 2, 70, "Input",
  CellTags->"S3.5.2"],
Cell[29352, 1027, 96, 3, 70, "Output",
  CellTags->"S3.5.2"]
}, Open  ]],
Cell[29463, 1033, 441, 15, 70, "MathCaption",
  CellTags->{"S3.5.2", "2.8"}],

Cell[CellGroupData[{
Cell[29929, 1052, 80, 2, 70, "Input",
  CellTags->"S3.5.2"],
Cell[30012, 1056, 82, 3, 70, "Output",
  CellTags->"S3.5.2"]
}, Open  ]],
Cell[30109, 1062, 214, 9, 70, "MathCaption",
  CellTags->{"S3.5.2", "2.9"}],

Cell[CellGroupData[{
Cell[30348, 1075, 86, 2, 70, "Input",
  CellTags->"S3.5.2"],
Cell[30437, 1079, 102, 3, 70, "Output",
  CellTags->"S3.5.2"]
}, Open  ]],
Cell[30554, 1085, 153, 5, 70, "MathCaption",
  CellTags->{"S3.5.2", "2.10"}],
Cell[30710, 1092, 72, 2, 70, "Input",
  CellTags->"S3.5.2"],
Cell[30785, 1096, 151, 5, 70, "MathCaption",
  CellTags->{"S3.5.2", "2.11"}],

Cell[CellGroupData[{
Cell[30961, 1105, 102, 2, 70, "Input",
  CellTags->"S3.5.2"],
Cell[31066, 1109, 125, 3, 70, "Output",
  CellTags->"S3.5.2"]
}, Open  ]],
Cell[31206, 1115, 158, 5, 70, "MathCaption",
  CellTags->{"S3.5.2", "2.12"}],
Cell[31367, 1122, 90, 2, 70, "Input",
  CellTags->"S3.5.2"],
Cell[31460, 1126, 138, 5, 70, "MathCaption",
  CellTags->{"S3.5.2", "2.13"}],

Cell[CellGroupData[{
Cell[31623, 1135, 82, 2, 70, "Input",
  CellTags->"S3.5.2"],
Cell[31708, 1139, 105, 3, 70, "Output",
  CellTags->"S3.5.2"]
}, Open  ]],
Cell[31828, 1145, 178, 7, 70, "MathCaption",
  CellTags->{"S3.5.2", "2.14"}],

Cell[CellGroupData[{
Cell[32031, 1156, 86, 2, 70, "Input",
  CellTags->"S3.5.2"],
Cell[32120, 1160, 109, 3, 70, "Output",
  CellTags->"S3.5.2"]
}, Open  ]],
Cell[32244, 1166, 544, 20, 70, "MathCaption",
  CellTags->{"S3.5.2", "2.15"}],

Cell[CellGroupData[{
Cell[32813, 1190, 80, 2, 70, "Input",
  CellTags->"S3.5.2"],
Cell[32896, 1194, 110, 3, 70, "Output",
  CellTags->"S3.5.2"]
}, Open  ]],
Cell[33021, 1200, 132, 4, 70, "MathCaption",
  CellTags->{"S3.5.2", "2.16"}],

Cell[CellGroupData[{
Cell[33178, 1208, 81, 2, 70, "Input",
  CellTags->"S3.5.2"],
Cell[33262, 1212, 107, 3, 70, "Output",
  CellTags->"S3.5.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[33418, 1221, 91, 1, 70, "Subsection",
  CellTags->{"S3.5.3", "3.1"}],
Cell[33512, 1224, 115, 2, 70, "MathCaption",
  CellTags->{"S3.5.3", "3.2"}],

Cell[CellGroupData[{
Cell[33652, 1230, 78, 2, 70, "Input",
  CellTags->"S3.5.3"],
Cell[33733, 1234, 97, 3, 70, "Output",
  CellTags->"S3.5.3"]
}, Open  ]],
Cell[33845, 1240, 195, 7, 70, "MathCaption",
  CellTags->{"S3.5.3", "3.3"}],

Cell[CellGroupData[{
Cell[34065, 1251, 76, 2, 70, "Input",
  CellTags->"S3.5.3"],
Cell[34144, 1255, 219, 6, 70, "Output",
  CellTags->"S3.5.3"]
}, Open  ]],
Cell[34378, 1264, 216, 7, 70, "MathCaption",
  CellTags->{"S3.5.3", "3.4"}],

Cell[CellGroupData[{
Cell[34619, 1275, 78, 2, 70, "Input",
  CellTags->"S3.5.3"],
Cell[34700, 1279, 265, 7, 70, "Output",
  CellTags->"S3.5.3"]
}, Open  ]],
Cell[34980, 1289, 218, 9, 70, "MathCaption",
  CellTags->{"S3.5.3", "3.5"}],

Cell[CellGroupData[{
Cell[35223, 1302, 71, 2, 70, "Input",
  CellTags->"S3.5.3"],
Cell[35297, 1306, 417, 11, 70, "Output",
  CellTags->"S3.5.3"]
}, Open  ]],
Cell[35729, 1320, 198, 5, 70, "MathCaption",
  CellTags->{"S3.5.3", "3.6"}],

Cell[CellGroupData[{
Cell[35952, 1329, 81, 2, 70, "Input",
  CellTags->"S3.5.3"],
Cell[36036, 1333, 268, 8, 70, "Output",
  CellTags->"S3.5.3"]
}, Open  ]],
Cell[36319, 1344, 921, 30, 70, "MathCaption",
  CellTags->{"S3.5.3", "3.7"}],

Cell[CellGroupData[{
Cell[37265, 1378, 83, 2, 70, "Input",
  CellTags->"S3.5.3"],
Cell[37351, 1382, 217, 7, 70, "Output",
  CellTags->"S3.5.3"]
}, Open  ]],
Cell[37583, 1392, 342, 13, 70, "MathCaption",
  CellTags->{"S3.5.3", "3.8"}],

Cell[CellGroupData[{
Cell[37950, 1409, 73, 2, 70, "Input",
  CellTags->"S3.5.3"],
Cell[38026, 1413, 217, 7, 70, "Output",
  CellTags->"S3.5.3"]
}, Open  ]],
Cell[38258, 1423, 2937, 76, 70, "DefinitionBox",
  CellTags->"S3.5.3"],
Cell[41198, 1501, 92, 1, 70, "Caption",
  CellTags->"S3.5.3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41327, 1507, 108, 1, 70, "Subsection",
  CellTags->{"S3.5.4", "4.1"}],
Cell[41438, 1510, 365, 9, 70, "Text",
  CellTags->{"S3.5.4", "4.2"}],
Cell[41806, 1521, 3118, 109, 70, "Text",
  CellTags->{"S3.5.4", "4.3"}],
Cell[44927, 1632, 2011, 66, 70, "Text",
  CellTags->{"S3.5.4", "4.4"}],
Cell[46941, 1700, 828, 25, 70, "Text",
  CellTags->{"S3.5.4", "4.5"}],
Cell[47772, 1727, 476, 18, 70, "Text",
  CellTags->{"S3.5.4", "4.6"}],
Cell[48251, 1747, 866, 27, 70, "Text",
  CellTags->{"S3.5.4", "4.7"}],
Cell[49120, 1776, 157, 5, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.8"}],

Cell[CellGroupData[{
Cell[49302, 1785, 78, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[49383, 1789, 253, 8, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[49651, 1800, 130, 5, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.9"}],

Cell[CellGroupData[{
Cell[49806, 1809, 81, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[49890, 1813, 260, 8, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[50165, 1824, 86, 1, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.10"}],

Cell[CellGroupData[{
Cell[50276, 1829, 82, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[50361, 1833, 260, 8, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[50636, 1844, 223, 6, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.11"}],

Cell[CellGroupData[{
Cell[50884, 1854, 77, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[50964, 1858, 217, 7, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[51196, 1868, 78, 1, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.12"}],

Cell[CellGroupData[{
Cell[51299, 1873, 77, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[51379, 1877, 266, 8, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[51660, 1888, 228, 7, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.13"}],

Cell[CellGroupData[{
Cell[51913, 1899, 94, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[52010, 1903, 266, 8, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[52291, 1914, 83, 1, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.14"}],

Cell[CellGroupData[{
Cell[52399, 1919, 95, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[52497, 1923, 266, 8, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[52778, 1934, 236, 6, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.15"}],

Cell[CellGroupData[{
Cell[53039, 1944, 95, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[53137, 1948, 266, 8, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[53418, 1959, 201, 5, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.16"}],

Cell[CellGroupData[{
Cell[53644, 1968, 77, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[53724, 1972, 404, 13, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[54143, 1988, 92, 1, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.17"}],

Cell[CellGroupData[{
Cell[54260, 1993, 78, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[54341, 1997, 321, 9, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[54677, 2009, 495, 14, 70, "Text",
  CellTags->{"S3.5.4", "4.18"}],
Cell[55175, 2025, 226, 7, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.19"}],

Cell[CellGroupData[{
Cell[55426, 2036, 82, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[55511, 2040, 261, 8, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[55787, 2051, 202, 7, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.20"}],

Cell[CellGroupData[{
Cell[56014, 2062, 77, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[56094, 2066, 220, 6, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[56329, 2075, 344, 11, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.21"}],

Cell[CellGroupData[{
Cell[56698, 2090, 74, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[56775, 2094, 205, 6, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[56995, 2103, 236, 7, 70, "Text",
  CellTags->{"S3.5.4", "4.22"}],
Cell[57234, 2112, 138, 5, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.23"}],
Cell[57375, 2119, 77, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[57455, 2123, 259, 9, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.24"}],

Cell[CellGroupData[{
Cell[57739, 2136, 75, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[57817, 2140, 89, 3, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[57921, 2146, 202, 7, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.25"}],

Cell[CellGroupData[{
Cell[58148, 2157, 70, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[58221, 2161, 89, 3, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[58325, 2167, 135, 5, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.26"}],

Cell[CellGroupData[{
Cell[58485, 2176, 67, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[58555, 2180, 92, 3, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[58662, 2186, 747, 20, 70, "Text",
  CellTags->{"S3.5.4", "4.27"}],
Cell[59412, 2208, 933, 27, 70, "Text",
  CellTags->{"S3.5.4", "4.28"}],
Cell[60348, 2237, 163, 5, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.29"}],

Cell[CellGroupData[{
Cell[60536, 2246, 69, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[60608, 2250, 94, 3, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]],
Cell[60717, 2256, 178, 6, 70, "MathCaption",
  CellTags->{"S3.5.4", "4.30"}],

Cell[CellGroupData[{
Cell[60920, 2266, 69, 2, 70, "Input",
  CellTags->"S3.5.4"],
Cell[60992, 2270, 91, 3, 70, "Output",
  CellTags->"S3.5.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[61132, 2279, 79, 1, 70, "Subsection",
  CellTags->{"S3.5.5", "5.1"}],
Cell[61214, 2282, 326, 13, 70, "Text",
  CellTags->{"S3.5.5", "5.2"}],
Cell[61543, 2297, 691, 27, 70, "MathCaption",
  CellTags->{"S3.5.5", "5.3"}],
Cell[62237, 2326, 79, 2, 70, "Input",
  CellTags->"S3.5.5"],
Cell[62319, 2330, 155, 5, 70, "MathCaption",
  CellTags->{"S3.5.5", "5.4"}],

Cell[CellGroupData[{
Cell[62499, 2339, 76, 2, 70, "Input",
  CellTags->"S3.5.5"],
Cell[62578, 2343, 95, 3, 70, "Output",
  CellTags->"S3.5.5"]
}, Open  ]],
Cell[62688, 2349, 233, 8, 70, "MathCaption",
  CellTags->{"S3.5.5", "5.5"}],

Cell[CellGroupData[{
Cell[62946, 2361, 71, 2, 70, "Input",
  CellTags->"S3.5.5"],
Cell[63020, 2365, 270, 7, 70, "Output",
  CellTags->"S3.5.5"]
}, Open  ]],
Cell[63305, 2375, 242, 8, 70, "MathCaption",
  CellTags->{"S3.5.5", "5.6"}],

Cell[CellGroupData[{
Cell[63572, 2387, 74, 2, 70, "Input",
  CellTags->"S3.5.5"],
Cell[63649, 2391, 83, 3, 70, "Output",
  CellTags->"S3.5.5"]
}, Open  ]],
Cell[63747, 2397, 127, 5, 70, "MathCaption",
  CellTags->{"S3.5.5", "5.7"}],

Cell[CellGroupData[{
Cell[63899, 2406, 84, 2, 70, "Input",
  CellTags->"S3.5.5"],
Cell[63986, 2410, 92, 3, 70, "Output",
  CellTags->"S3.5.5"]
}, Open  ]],
Cell[64093, 2416, 158, 5, 70, "MathCaption",
  CellTags->{"S3.5.5", "5.8"}],

Cell[CellGroupData[{
Cell[64276, 2425, 80, 2, 70, "Input",
  CellTags->"S3.5.5"],
Cell[64359, 2429, 87, 3, 70, "Output",
  CellTags->"S3.5.5"]
}, Open  ]],
Cell[64461, 2435, 107, 1, 70, "MathCaption",
  CellTags->{"S3.5.5", "5.9"}],

Cell[CellGroupData[{
Cell[64593, 2440, 81, 2, 70, "Input",
  CellTags->"S3.5.5"],
Cell[64677, 2444, 289, 8, 70, "Output",
  CellTags->"S3.5.5"]
}, Open  ]],
Cell[64981, 2455, 227, 6, 70, "Text",
  CellTags->{"S3.5.5", "5.10"}],
Cell[65211, 2463, 2309, 74, 70, "DefinitionBox",
  CellTags->"S3.5.5"],
Cell[67523, 2539, 63, 1, 70, "Caption",
  CellTags->"S3.5.5"],
Cell[67589, 2542, 176, 5, 70, "MathCaption",
  CellTags->{"S3.5.5", "5.11"}],
Cell[67768, 2549, 104, 2, 70, "Input",
  CellTags->"S3.5.5"],
Cell[67875, 2553, 92, 1, 70, "MathCaption",
  CellTags->{"S3.5.5", "5.12"}],

Cell[CellGroupData[{
Cell[67992, 2558, 84, 2, 70, "Input",
  CellTags->"S3.5.5"],
Cell[68079, 2562, 331, 10, 70, "Output",
  CellTags->"S3.5.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[68459, 2578, 79, 1, 70, "Subsection",
  CellTags->{"S3.5.6", "6.1"}],
Cell[68541, 2581, 968, 35, 70, "Text",
  CellTags->{"S3.5.6", "6.2"}],
Cell[69512, 2618, 602, 19, 70, "Text",
  CellTags->{"S3.5.6", "6.3"}],
Cell[70117, 2639, 320, 6, 70, "Text",
  CellTags->{"S3.5.6", "6.4"}],
Cell[70440, 2647, 157, 4, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.5"}],

Cell[CellGroupData[{
Cell[70622, 2655, 81, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[70706, 2659, 88, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[70809, 2665, 296, 8, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.6"}],

Cell[CellGroupData[{
Cell[71130, 2677, 76, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[71209, 2681, 85, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[71309, 2687, 421, 15, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.7"}],

Cell[CellGroupData[{
Cell[71755, 2706, 89, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[71847, 2710, 121, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[71983, 2716, 126, 4, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.8"}],

Cell[CellGroupData[{
Cell[72134, 2724, 71, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[72208, 2728, 131, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[72354, 2734, 129, 4, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.9"}],

Cell[CellGroupData[{
Cell[72508, 2742, 75, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[72586, 2746, 101, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[72702, 2752, 427, 13, 70, "Text",
  CellTags->{"S3.5.6", "6.10"}],
Cell[73132, 2767, 177, 7, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.11"}],

Cell[CellGroupData[{
Cell[73334, 2778, 83, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[73420, 2782, 95, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[73530, 2788, 169, 4, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.12"}],

Cell[CellGroupData[{
Cell[73724, 2796, 89, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[73816, 2800, 97, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[73928, 2806, 1181, 39, 70, "Text",
  CellTags->{"S3.5.6", "6.13"}],
Cell[75112, 2847, 253, 8, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.14"}],

Cell[CellGroupData[{
Cell[75390, 2859, 81, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[75474, 2863, 104, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[75593, 2869, 212, 7, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.15"}],

Cell[CellGroupData[{
Cell[75830, 2880, 82, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[75915, 2884, 87, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[76017, 2890, 365, 7, 70, "Text",
  CellTags->{"S3.5.6", "6.16"}],
Cell[76385, 2899, 142, 5, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.17"}],

Cell[CellGroupData[{
Cell[76552, 2908, 92, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[76647, 2912, 101, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[76763, 2918, 143, 5, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.18"}],

Cell[CellGroupData[{
Cell[76931, 2927, 92, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[77026, 2931, 102, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[77143, 2937, 160, 4, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.19"}],

Cell[CellGroupData[{
Cell[77328, 2945, 77, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[77408, 2949, 112, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[77535, 2955, 88, 1, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.20"}],

Cell[CellGroupData[{
Cell[77648, 2960, 72, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[77723, 2964, 100, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[77838, 2970, 491, 17, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.21"}],

Cell[CellGroupData[{
Cell[78354, 2991, 106, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[78463, 2995, 116, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]],
Cell[78594, 3001, 148, 4, 70, "MathCaption",
  CellTags->{"S3.5.6", "6.22"}],

Cell[CellGroupData[{
Cell[78767, 3009, 90, 2, 70, "Input",
  CellTags->"S3.5.6"],
Cell[78860, 3013, 91, 3, 70, "Output",
  CellTags->"S3.5.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[79000, 3022, 96, 1, 70, "Subsection",
  CellTags->{"S3.5.7", "7.1"}],
Cell[79099, 3025, 322, 6, 70, "Text",
  CellTags->{"S3.5.7", "7.2"}],
Cell[79424, 3033, 468, 8, 70, "Text",
  CellTags->{"S3.5.7", "7.3"}],
Cell[79895, 3043, 156, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.4"}],

Cell[CellGroupData[{
Cell[80076, 3051, 86, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[80165, 3055, 115, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[80295, 3061, 164, 5, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.5"}],

Cell[CellGroupData[{
Cell[80484, 3070, 89, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[80576, 3074, 112, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[80703, 3080, 139, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.6"}],

Cell[CellGroupData[{
Cell[80867, 3088, 86, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[80956, 3092, 124, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[81095, 3098, 232, 6, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.7"}],

Cell[CellGroupData[{
Cell[81352, 3108, 106, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[81461, 3112, 184, 4, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[81660, 3119, 226, 6, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.8"}],

Cell[CellGroupData[{
Cell[81911, 3129, 87, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[82001, 3133, 158, 4, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[82174, 3140, 374, 7, 70, "Text",
  CellTags->{"S3.5.7", "7.9"}],
Cell[82551, 3149, 183, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.10"}],

Cell[CellGroupData[{
Cell[82759, 3157, 91, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[82853, 3161, 128, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[82996, 3167, 262, 5, 70, "Text",
  CellTags->{"S3.5.7", "7.11"}],
Cell[83261, 3174, 567, 11, 70, "Text",
  CellTags->{"S3.5.7", "7.12"}],
Cell[83831, 3187, 232, 5, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.13"}],

Cell[CellGroupData[{
Cell[84088, 3196, 96, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[84187, 3200, 121, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[84323, 3206, 175, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.14"}],

Cell[CellGroupData[{
Cell[84523, 3214, 95, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[84621, 3218, 149, 4, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[84785, 3225, 126, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.15"}],

Cell[CellGroupData[{
Cell[84936, 3233, 68, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[85007, 3237, 545, 10, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[85567, 3250, 162, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.16"}],

Cell[CellGroupData[{
Cell[85754, 3258, 96, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[85853, 3262, 138, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[86006, 3268, 129, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.17"}],

Cell[CellGroupData[{
Cell[86160, 3276, 98, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[86261, 3280, 143, 4, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[86419, 3287, 106, 1, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.18"}],

Cell[CellGroupData[{
Cell[86550, 3292, 96, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[86649, 3296, 226, 5, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[86890, 3304, 176, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.19"}],

Cell[CellGroupData[{
Cell[87091, 3312, 90, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[87184, 3316, 125, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[87324, 3322, 107, 1, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.20"}],

Cell[CellGroupData[{
Cell[87456, 3327, 90, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[87549, 3331, 286, 6, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[87850, 3340, 136, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.21"}],

Cell[CellGroupData[{
Cell[88011, 3348, 91, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[88105, 3352, 103, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[88223, 3358, 142, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.22"}],

Cell[CellGroupData[{
Cell[88390, 3366, 91, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[88484, 3370, 276, 6, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[88775, 3379, 163, 5, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.23"}],

Cell[CellGroupData[{
Cell[88963, 3388, 94, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[89060, 3392, 449, 12, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[89524, 3407, 579, 10, 70, "Text",
  CellTags->{"S3.5.7", "7.24"}],
Cell[90106, 3419, 147, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.25"}],

Cell[CellGroupData[{
Cell[90278, 3427, 92, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[90373, 3431, 139, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[90527, 3437, 152, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.26"}],

Cell[CellGroupData[{
Cell[90704, 3445, 91, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[90798, 3449, 137, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[90950, 3455, 128, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.27"}],

Cell[CellGroupData[{
Cell[91103, 3463, 96, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[91202, 3467, 139, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[91356, 3473, 408, 9, 70, "Text",
  CellTags->{"S3.5.7", "7.28"}],
Cell[91767, 3484, 142, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.29"}],

Cell[CellGroupData[{
Cell[91934, 3492, 91, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[92028, 3496, 100, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[92143, 3502, 170, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.30"}],

Cell[CellGroupData[{
Cell[92338, 3510, 99, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[92440, 3514, 507, 11, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[92962, 3528, 317, 9, 70, "Text",
  CellTags->{"S3.5.7", "7.31"}],
Cell[93282, 3539, 564, 13, 70, "Text",
  CellTags->{"S3.5.7", "7.32"}],
Cell[93849, 3554, 209, 6, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.33"}],

Cell[CellGroupData[{
Cell[94083, 3564, 90, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[94176, 3568, 122, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[94313, 3574, 149, 4, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.34"}],

Cell[CellGroupData[{
Cell[94487, 3582, 85, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[94575, 3586, 95, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[94685, 3592, 196, 5, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.35"}],
Cell[94884, 3599, 119, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[95006, 3603, 159, 5, 70, "MathCaption",
  CellTags->{"S3.5.7", "7.36"}],

Cell[CellGroupData[{
Cell[95190, 3612, 91, 2, 70, "Input",
  CellTags->"S3.5.7"],
Cell[95284, 3616, 99, 3, 70, "Output",
  CellTags->"S3.5.7"]
}, Open  ]],
Cell[95398, 3622, 799, 22, 70, "Text",
  CellTags->{"S3.5.7", "7.37"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[96234, 3649, 77, 1, 70, "Subsection",
  CellTags->{"S3.5.8", "8.1"}],
Cell[96314, 3652, 5860, 166, 70, "DefinitionBox",
  CellTags->"S3.5.8"],
Cell[102177, 3820, 64, 1, 70, "Caption",
  CellTags->"S3.5.8"],
Cell[102244, 3823, 499, 19, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.2"}],

Cell[CellGroupData[{
Cell[102768, 3846, 89, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[102860, 3850, 107, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[102982, 3856, 827, 30, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.3"}],

Cell[CellGroupData[{
Cell[103834, 3890, 106, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[103943, 3894, 110, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[104068, 3900, 323, 11, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.4"}],

Cell[CellGroupData[{
Cell[104416, 3915, 106, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[104525, 3919, 88, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[104628, 3925, 348, 7, 70, "Text",
  CellTags->{"S3.5.8", "8.5"}],
Cell[104979, 3934, 149, 4, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.6"}],

Cell[CellGroupData[{
Cell[105153, 3942, 89, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[105245, 3946, 121, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[105381, 3952, 140, 4, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.7"}],

Cell[CellGroupData[{
Cell[105546, 3960, 99, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[105648, 3964, 104, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[105767, 3970, 196, 5, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.8"}],

Cell[CellGroupData[{
Cell[105988, 3979, 109, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[106100, 3983, 130, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[106245, 3989, 200, 5, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.9"}],

Cell[CellGroupData[{
Cell[106470, 3998, 108, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[106581, 4002, 92, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[106688, 4008, 108, 1, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.10"}],

Cell[CellGroupData[{
Cell[106821, 4013, 120, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[106944, 4017, 118, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[107077, 4023, 129, 4, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.11"}],

Cell[CellGroupData[{
Cell[107231, 4031, 109, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[107343, 4035, 240, 5, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[107598, 4043, 394, 7, 70, "Text",
  CellTags->{"S3.5.8", "8.12"}],
Cell[107995, 4052, 290, 10, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.13"}],

Cell[CellGroupData[{
Cell[108310, 4066, 84, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[108397, 4070, 95, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[108507, 4076, 100, 1, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.14"}],

Cell[CellGroupData[{
Cell[108632, 4081, 97, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[108732, 4085, 88, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[108835, 4091, 289, 9, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.15"}],

Cell[CellGroupData[{
Cell[109149, 4104, 93, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[109245, 4108, 93, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[109353, 4114, 137, 4, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.16"}],

Cell[CellGroupData[{
Cell[109515, 4122, 95, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[109613, 4126, 148, 4, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[109776, 4133, 105, 1, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.17"}],

Cell[CellGroupData[{
Cell[109906, 4138, 102, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[110011, 4142, 83, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[110109, 4148, 262, 9, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.18"}],

Cell[CellGroupData[{
Cell[110396, 4161, 105, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[110504, 4165, 113, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[110632, 4171, 1382, 40, 70, "DefinitionBox",
  CellTags->"S3.5.8"],
Cell[112017, 4213, 68, 1, 70, "Caption",
  CellTags->"S3.5.8"],
Cell[112088, 4216, 254, 9, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.19"}],

Cell[CellGroupData[{
Cell[112367, 4229, 82, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[112452, 4233, 88, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[112555, 4239, 437, 15, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.20"}],

Cell[CellGroupData[{
Cell[113017, 4258, 101, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[113121, 4262, 116, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[113252, 4268, 108, 1, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.21"}],

Cell[CellGroupData[{
Cell[113385, 4273, 91, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[113479, 4277, 168, 4, 70, "Message",
  CellTags->"S3.5.8"],
Cell[113650, 4283, 131, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[113796, 4289, 103, 1, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.22"}],

Cell[CellGroupData[{
Cell[113924, 4294, 113, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[114040, 4298, 88, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[114143, 4304, 425, 8, 70, "Text",
  CellTags->{"S3.5.8", "8.23"}],
Cell[114571, 4314, 283, 10, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.24"}],

Cell[CellGroupData[{
Cell[114879, 4328, 82, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[114964, 4332, 105, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[115084, 4338, 290, 8, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.25"}],

Cell[CellGroupData[{
Cell[115399, 4350, 90, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[115492, 4354, 205, 5, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[115712, 4362, 234, 8, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.26"}],

Cell[CellGroupData[{
Cell[115971, 4374, 76, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[116050, 4378, 86, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[116151, 4384, 945, 27, 70, "DefinitionBox3Col",
  CellTags->"S3.5.8"],
Cell[117099, 4413, 108, 5, 70, "Caption",
  CellTags->"S3.5.8"],
Cell[117210, 4420, 480, 17, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.27"}],

Cell[CellGroupData[{
Cell[117715, 4441, 114, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[117832, 4445, 94, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[117941, 4451, 440, 10, 70, "Text",
  CellTags->{"S3.5.8", "8.28"}],
Cell[118384, 4463, 166, 5, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.29"}],

Cell[CellGroupData[{
Cell[118575, 4472, 104, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[118682, 4476, 231, 5, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[118928, 4484, 227, 8, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.30"}],

Cell[CellGroupData[{
Cell[119180, 4496, 141, 5, 70, "Input",
  CellTags->"S3.5.8"],
Cell[119324, 4503, 102, 3, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[119441, 4509, 635, 21, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.31"}],

Cell[CellGroupData[{
Cell[120101, 4534, 84, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[120188, 4538, 3793, 277, 70, 3720, 274, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S3.5.8"],
Cell[123984, 4817, 178, 5, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[124177, 4825, 266, 9, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.32"}],

Cell[CellGroupData[{
Cell[124468, 4838, 155, 5, 70, "Input",
  CellTags->"S3.5.8"],
Cell[124626, 4845, 153, 4, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]],
Cell[124794, 4852, 230, 8, 70, "MathCaption",
  CellTags->{"S3.5.8", "8.33"}],

Cell[CellGroupData[{
Cell[125049, 4864, 94, 2, 70, "Input",
  CellTags->"S3.5.8"],
Cell[125146, 4868, 4164, 300, 70, 4091, 297, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S3.5.8"],
Cell[129313, 5170, 178, 5, 70, "Output",
  CellTags->"S3.5.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[129540, 5181, 81, 1, 70, "Subsection",
  CellTags->{"S3.5.9", "9.1"}],
Cell[129624, 5184, 98, 1, 70, "MathCaption",
  CellTags->{"S3.5.9", "9.2"}],

Cell[CellGroupData[{
Cell[129747, 5189, 122, 2, 70, "Input",
  CellTags->"S3.5.9"],
Cell[129872, 5193, 86, 3, 70, "Output",
  CellTags->"S3.5.9"]
}, Open  ]],
Cell[129973, 5199, 82, 1, 70, "MathCaption",
  CellTags->{"S3.5.9", "9.3"}],

Cell[CellGroupData[{
Cell[130080, 5204, 119, 2, 70, "Input",
  CellTags->"S3.5.9"],
Cell[130202, 5208, 86, 3, 70, "Output",
  CellTags->"S3.5.9"]
}, Open  ]],
Cell[130303, 5214, 210, 5, 70, "Text",
  CellTags->{"S3.5.9", "9.4"}],
Cell[130516, 5221, 84, 1, 70, "MathCaption",
  CellTags->{"S3.5.9", "9.5"}],

Cell[CellGroupData[{
Cell[130625, 5226, 136, 5, 70, "Input",
  CellTags->"S3.5.9"],
Cell[130764, 5233, 104, 3, 70, "Output",
  CellTags->"S3.5.9"]
}, Open  ]],
Cell[130883, 5239, 2254, 67, 70, "DefinitionBox",
  CellTags->"S3.5.9"],
Cell[133140, 5308, 65, 1, 70, "Caption",
  CellTags->"S3.5.9"],
Cell[133208, 5311, 208, 5, 70, "Text",
  CellTags->{"S3.5.9", "9.6"}],
Cell[133419, 5318, 220, 8, 70, "MathCaption",
  CellTags->{"S3.5.9", "9.7"}],

Cell[CellGroupData[{
Cell[133664, 5330, 111, 2, 70, "Input",
  CellTags->"S3.5.9"],
Cell[133778, 5334, 444, 13, 70, "Output",
  CellTags->"S3.5.9"]
}, Open  ]],
Cell[134237, 5350, 125, 4, 70, "MathCaption",
  CellTags->{"S3.5.9", "9.8"}],

Cell[CellGroupData[{
Cell[134387, 5358, 100, 2, 70, "Input",
  CellTags->"S3.5.9"],
Cell[134490, 5362, 486, 13, 70, "Output",
  CellTags->"S3.5.9"]
}, Open  ]],
Cell[134991, 5378, 105, 1, 70, "MathCaption",
  CellTags->{"S3.5.9", "9.9"}],

Cell[CellGroupData[{
Cell[135121, 5383, 117, 2, 70, "Input",
  CellTags->"S3.5.9"],
Cell[135241, 5387, 431, 10, 70, "Output",
  CellTags->"S3.5.9"]
}, Open  ]],
Cell[135687, 5400, 109, 1, 70, "MathCaption",
  CellTags->{"S3.5.9", "9.10"}],

Cell[CellGroupData[{
Cell[135821, 5405, 120, 2, 70, "Input",
  CellTags->"S3.5.9"],
Cell[135944, 5409, 201, 4, 70, "Output",
  CellTags->"S3.5.9"]
}, Open  ]],
Cell[136160, 5416, 142, 4, 70, "MathCaption",
  CellTags->{"S3.5.9", "9.11"}],

Cell[CellGroupData[{
Cell[136327, 5424, 114, 2, 70, "Input",
  CellTags->"S3.5.9"],
Cell[136444, 5428, 82, 3, 70, "Output",
  CellTags->"S3.5.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[136575, 5437, 101, 1, 70, "Subsection",
  CellTags->{"S3.5.10", "10.1"}],
Cell[136679, 5440, 263, 7, 70, "Text",
  CellTags->{"S3.5.10", "10.2"}],
Cell[136945, 5449, 202, 5, 70, "MathCaption",
  CellTags->{"S3.5.10", "10.3"}],

Cell[CellGroupData[{
Cell[137172, 5458, 87, 2, 70, "Input",
  CellTags->"S3.5.10"],
Cell[137262, 5462, 125, 3, 70, "Output",
  CellTags->"S3.5.10"]
}, Open  ]],
Cell[137402, 5468, 132, 4, 70, "MathCaption",
  CellTags->{"S3.5.10", "10.4"}],

Cell[CellGroupData[{
Cell[137559, 5476, 72, 2, 70, "Input",
  CellTags->"S3.5.10"],
Cell[137634, 5480, 92, 3, 70, "Output",
  CellTags->"S3.5.10"]
}, Open  ]],
Cell[137741, 5486, 127, 4, 70, "MathCaption",
  CellTags->{"S3.5.10", "10.5"}],

Cell[CellGroupData[{
Cell[137893, 5494, 97, 2, 70, "Input",
  CellTags->"S3.5.10"],
Cell[137993, 5498, 135, 3, 70, "Output",
  CellTags->"S3.5.10"]
}, Open  ]],
Cell[138143, 5504, 108, 1, 70, "MathCaption",
  CellTags->{"S3.5.10", "10.6"}],

Cell[CellGroupData[{
Cell[138276, 5509, 72, 2, 70, "Input",
  CellTags->"S3.5.10"],
Cell[138351, 5513, 392, 11, 70, "Output",
  CellTags->"S3.5.10"]
}, Open  ]],
Cell[138758, 5527, 200, 6, 70, "MathCaption",
  CellTags->{"S3.5.10", "10.7"}],

Cell[CellGroupData[{
Cell[138983, 5537, 100, 2, 70, "Input",
  CellTags->"S3.5.10"],
Cell[139086, 5541, 122, 3, 70, "Output",
  CellTags->"S3.5.10"]
}, Open  ]],
Cell[139223, 5547, 158, 5, 70, "MathCaption",
  CellTags->{"S3.5.10", "10.8"}],

Cell[CellGroupData[{
Cell[139406, 5556, 77, 2, 70, "Input",
  CellTags->"S3.5.10"],
Cell[139486, 5560, 83, 3, 70, "Output",
  CellTags->"S3.5.10"]
}, Open  ]],
Cell[139584, 5566, 124, 4, 70, "MathCaption",
  CellTags->{"S3.5.10", "10.9"}],

Cell[CellGroupData[{
Cell[139733, 5574, 78, 2, 70, "Input",
  CellTags->"S3.5.10"],
Cell[139814, 5578, 118, 3, 70, "Output",
  CellTags->"S3.5.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[139981, 5587, 84, 1, 70, "Subsection",
  CellTags->{"S3.5.11", "11.1"}],
Cell[140068, 5590, 363, 12, 70, "Text",
  CellTags->{"S3.5.11", "11.2"}],
Cell[140434, 5604, 430, 12, 70, "Text",
  CellTags->{"S3.5.11", "11.3"}],
Cell[140867, 5618, 1096, 35, 70, "Text",
  CellTags->{"S3.5.11", "11.4"}],
Cell[141966, 5655, 236, 9, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.5"}],

Cell[CellGroupData[{
Cell[142227, 5668, 99, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[142329, 5672, 132, 3, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[142476, 5678, 247, 9, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.6"}],

Cell[CellGroupData[{
Cell[142748, 5691, 90, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[142841, 5695, 337, 10, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[143193, 5708, 254, 9, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.7"}],

Cell[CellGroupData[{
Cell[143472, 5721, 96, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[143571, 5725, 155, 4, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[143741, 5732, 146, 5, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.8"}],

Cell[CellGroupData[{
Cell[143912, 5741, 90, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[144005, 5745, 124, 3, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[144144, 5751, 166, 5, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.9"}],

Cell[CellGroupData[{
Cell[144335, 5760, 88, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[144426, 5764, 88, 3, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[144529, 5770, 1378, 43, 70, "DefinitionBox",
  CellTags->"S3.5.11"],
Cell[145910, 5815, 116, 4, 70, "Caption",
  CellTags->"S3.5.11"],
Cell[146029, 5821, 780, 12, 70, "Text",
  CellTags->{"S3.5.11", "11.10"}],
Cell[146812, 5835, 1530, 43, 70, "DefinitionBox",
  CellTags->"S3.5.11"],
Cell[148345, 5880, 87, 1, 70, "Caption",
  CellTags->"S3.5.11"],
Cell[148435, 5883, 110, 1, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.11"}],

Cell[CellGroupData[{
Cell[148570, 5888, 116, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[148689, 5892, 533, 13, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[149237, 5908, 186, 6, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.12"}],

Cell[CellGroupData[{
Cell[149448, 5918, 94, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[149545, 5922, 194, 4, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[149754, 5929, 288, 10, 70, "Text",
  CellTags->{"S3.5.11", "11.13"}],
Cell[150045, 5941, 223, 9, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.14"}],

Cell[CellGroupData[{
Cell[150293, 5954, 110, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[150406, 5958, 124, 3, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[150545, 5964, 506, 12, 70, "Text",
  CellTags->{"S3.5.11", "11.15"}],
Cell[151054, 5978, 643, 20, 70, "Text",
  CellTags->{"S3.5.11", "11.16"}],
Cell[151700, 6000, 164, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.17"}],

Cell[CellGroupData[{
Cell[151889, 6008, 98, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[151990, 6012, 215, 5, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[152220, 6020, 176, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.18"}],

Cell[CellGroupData[{
Cell[152421, 6028, 121, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[152545, 6032, 423, 9, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[152983, 6044, 324, 6, 70, "Text",
  CellTags->{"S3.5.11", "11.19"}],
Cell[153310, 6052, 227, 5, 70, "Text",
  CellTags->{"S3.5.11", "11.20"}],
Cell[153540, 6059, 173, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.21"}],

Cell[CellGroupData[{
Cell[153738, 6067, 102, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[153843, 6071, 134, 3, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[153992, 6077, 153, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.22"}],

Cell[CellGroupData[{
Cell[154170, 6085, 102, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[154275, 6089, 241, 6, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[154531, 6098, 280, 6, 70, "Text",
  CellTags->{"S3.5.11", "11.23"}],
Cell[154814, 6106, 596, 12, 70, "Text",
  CellTags->{"S3.5.11", "11.24"}],
Cell[155413, 6120, 137, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.25"}],

Cell[CellGroupData[{
Cell[155575, 6128, 103, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[155681, 6132, 133, 3, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[155829, 6138, 111, 1, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.26"}],

Cell[CellGroupData[{
Cell[155965, 6143, 108, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[156076, 6147, 212, 5, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[156303, 6155, 90, 1, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.27"}],

Cell[CellGroupData[{
Cell[156418, 6160, 105, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[156526, 6164, 216, 6, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[156757, 6173, 86, 1, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.28"}],

Cell[CellGroupData[{
Cell[156868, 6178, 110, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[156981, 6182, 305, 7, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[157301, 6192, 165, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.29"}],

Cell[CellGroupData[{
Cell[157491, 6200, 105, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[157599, 6204, 199, 5, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[157813, 6212, 453, 9, 70, "Text",
  CellTags->{"S3.5.11", "11.30"}],
Cell[158269, 6223, 198, 5, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.31"}],

Cell[CellGroupData[{
Cell[158492, 6232, 104, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[158599, 6236, 398, 9, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[159012, 6248, 104, 1, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.32"}],

Cell[CellGroupData[{
Cell[159141, 6253, 109, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[159253, 6257, 347, 7, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[159615, 6267, 418, 9, 70, "Text",
  CellTags->{"S3.5.11", "11.33"}],
Cell[160036, 6278, 302, 8, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.34"}],

Cell[CellGroupData[{
Cell[160363, 6290, 102, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[160468, 6294, 120, 3, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[160603, 6300, 147, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.35"}],

Cell[CellGroupData[{
Cell[160775, 6308, 118, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[160896, 6312, 321, 7, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[161232, 6322, 132, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.36"}],

Cell[CellGroupData[{
Cell[161389, 6330, 111, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[161503, 6334, 202, 5, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[161720, 6342, 471, 16, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.37"}],

Cell[CellGroupData[{
Cell[162216, 6362, 111, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[162330, 6366, 268, 7, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[162613, 6376, 113, 1, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.38"}],

Cell[CellGroupData[{
Cell[162751, 6381, 113, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[162867, 6385, 198, 4, 70, "Message",
  CellTags->"S3.5.11"],
Cell[163068, 6391, 275, 6, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[163358, 6400, 284, 6, 70, "Text",
  CellTags->{"S3.5.11", "11.39"}],
Cell[163645, 6408, 110, 1, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.40"}],

Cell[CellGroupData[{
Cell[163780, 6413, 110, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[163893, 6417, 225, 6, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[164133, 6426, 116, 2, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.41"}],

Cell[CellGroupData[{
Cell[164274, 6432, 108, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[164385, 6436, 776, 20, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[165176, 6459, 258, 5, 70, "Text",
  CellTags->{"S3.5.11", "11.42"}],
Cell[165437, 6466, 122, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.43"}],

Cell[CellGroupData[{
Cell[165584, 6474, 151, 5, 70, "Input",
  CellTags->"S3.5.11"],
Cell[165738, 6481, 504, 10, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[166257, 6494, 3420, 100, 70, "DefinitionBox",
  CellTags->"S3.5.11"],
Cell[169680, 6596, 82, 1, 70, "Caption",
  CellTags->"S3.5.11"],
Cell[169765, 6599, 356, 8, 70, "Text",
  CellTags->{"S3.5.11", "11.44"}],
Cell[170124, 6609, 173, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.45"}],

Cell[CellGroupData[{
Cell[170322, 6617, 153, 5, 70, "Input",
  CellTags->"S3.5.11"],
Cell[170478, 6624, 217, 5, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[170710, 6632, 108, 1, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.46"}],

Cell[CellGroupData[{
Cell[170843, 6637, 145, 5, 70, "Input",
  CellTags->"S3.5.11"],
Cell[170991, 6644, 242, 6, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[171248, 6653, 988, 28, 70, "Text",
  CellTags->{"S3.5.11", "11.47"}],
Cell[172239, 6683, 119, 2, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.48"}],

Cell[CellGroupData[{
Cell[172383, 6689, 120, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[172506, 6693, 666, 20, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[173187, 6716, 129, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.49"}],

Cell[CellGroupData[{
Cell[173341, 6724, 104, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[173448, 6728, 158, 4, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[173621, 6735, 118, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.50"}],

Cell[CellGroupData[{
Cell[173764, 6743, 111, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[173878, 6747, 545, 17, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[174438, 6767, 152, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.51"}],

Cell[CellGroupData[{
Cell[174615, 6775, 92, 2, 70, "Input",
  CellTags->"S3.5.11"],
Cell[174710, 6779, 200, 5, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[174925, 6787, 491, 9, 70, "Text",
  CellTags->{"S3.5.11", "11.52"}],
Cell[175419, 6798, 295, 6, 70, "Text",
  CellTags->{"S3.5.11", "11.53"}],
Cell[175717, 6806, 185, 6, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.54"}],

Cell[CellGroupData[{
Cell[175927, 6816, 160, 5, 70, "Input",
  CellTags->"S3.5.11"],
Cell[176090, 6823, 188, 5, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[176293, 6831, 131, 4, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.55"}],

Cell[CellGroupData[{
Cell[176449, 6839, 158, 5, 70, "Input",
  CellTags->"S3.5.11"],
Cell[176610, 6846, 181, 5, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]],
Cell[176806, 6854, 112, 1, 70, "MathCaption",
  CellTags->{"S3.5.11", "11.56"}],

Cell[CellGroupData[{
Cell[176943, 6859, 143, 5, 70, "Input",
  CellTags->"S3.5.11"],
Cell[177089, 6866, 200, 4, 70, "Message",
  CellTags->"S3.5.11"],
Cell[177292, 6872, 138, 3, 70, "Output",
  CellTags->"S3.5.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[177479, 6881, 104, 1, 70, "Subsection",
  CellTags->{"S3.5.12", "12.1"}],

Cell[CellGroupData[{
Cell[177608, 6886, 76, 1, 70, "Subsubsection",
  CellTags->{"S3.5.12", "12.2"}],
Cell[177687, 6889, 1214, 38, 70, "DefinitionBox",
  CellTags->"S3.5.12"],
Cell[178904, 6929, 94, 3, 70, "Caption",
  CellTags->"S3.5.12"],
Cell[179001, 6934, 1991, 70, 70, "Text",
  CellTags->{"S3.5.12", "12.3"}],
Cell[180995, 7006, 92, 1, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.4"}],

Cell[CellGroupData[{
Cell[181112, 7011, 99, 2, 70, "Input",
  CellTags->"S3.5.12"],
Cell[181214, 7015, 149, 4, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[181378, 7022, 77, 1, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.5"}],

Cell[CellGroupData[{
Cell[181480, 7027, 97, 2, 70, "Input",
  CellTags->"S3.5.12"],
Cell[181580, 7031, 94, 3, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[181689, 7037, 112, 1, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.6"}],

Cell[CellGroupData[{
Cell[181826, 7042, 100, 2, 70, "Input",
  CellTags->"S3.5.12"],
Cell[181929, 7046, 159, 4, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[182103, 7053, 102, 1, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.7"}],

Cell[CellGroupData[{
Cell[182230, 7058, 100, 2, 70, "Input",
  CellTags->"S3.5.12"],
Cell[182333, 7062, 163, 4, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[182511, 7069, 148, 4, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.8"}],

Cell[CellGroupData[{
Cell[182684, 7077, 102, 2, 70, "Input",
  CellTags->"S3.5.12"],
Cell[182789, 7081, 130, 3, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[182934, 7087, 275, 6, 70, "Text",
  CellTags->{"S3.5.12", "12.9"}],
Cell[183212, 7095, 293, 9, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.10"}],

Cell[CellGroupData[{
Cell[183530, 7108, 115, 2, 70, "Input",
  CellTags->"S3.5.12"],
Cell[183648, 7112, 113, 3, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[183776, 7118, 3224, 92, 70, "DefinitionBox",
  CellTags->"S3.5.12"],
Cell[187003, 7212, 79, 1, 70, "Caption",
  CellTags->"S3.5.12"]
}, Open  ]],

Cell[CellGroupData[{
Cell[187119, 7218, 77, 1, 70, "Subsubsection",
  CellTags->{"S3.5.12", "12.11"}],
Cell[187199, 7221, 1336, 40, 70, "DefinitionBox",
  CellTags->"S3.5.12"],
Cell[188538, 7263, 94, 3, 70, "Caption",
  CellTags->"S3.5.12"],
Cell[188635, 7268, 86, 1, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.12"}],

Cell[CellGroupData[{
Cell[188746, 7273, 115, 4, 70, "Input",
  CellTags->"S3.5.12"],
Cell[188864, 7279, 442, 8, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[189321, 7290, 81, 1, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.13"}],

Cell[CellGroupData[{
Cell[189427, 7295, 112, 4, 70, "Input",
  CellTags->"S3.5.12"],
Cell[189542, 7301, 97, 3, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[189654, 7307, 1660, 56, 70, "Text",
  CellTags->{"S3.5.12", "12.14"}],
Cell[191317, 7365, 339, 8, 70, "Text",
  CellTags->{"S3.5.12", "12.15"}],
Cell[191659, 7375, 13960, 361, 70, "DefinitionBox4Col",
  CellTags->"S3.5.12"],
Cell[205622, 7738, 151, 5, 70, "Caption",
  CellTags->"S3.5.12"],
Cell[205776, 7745, 134, 4, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.16"}],

Cell[CellGroupData[{
Cell[205935, 7753, 113, 4, 70, "Input",
  CellTags->"S3.5.12"],
Cell[206051, 7759, 127, 3, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[206193, 7765, 169, 4, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.17"}],

Cell[CellGroupData[{
Cell[206387, 7773, 146, 5, 70, "Input",
  CellTags->"S3.5.12"],
Cell[206536, 7780, 138, 3, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[206689, 7786, 2087, 58, 70, "DefinitionBox",
  CellTags->"S3.5.12"],
Cell[208779, 7846, 78, 1, 70, "Caption",
  CellTags->"S3.5.12"],
Cell[208860, 7849, 1271, 40, 70, "Text",
  CellTags->{"S3.5.12", "12.18"}],
Cell[210134, 7891, 342, 12, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.19"}],

Cell[CellGroupData[{
Cell[210501, 7907, 161, 5, 70, "Input",
  CellTags->"S3.5.12"],
Cell[210665, 7914, 172, 4, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[210852, 7921, 7719, 218, 70, "DefinitionBox",
  CellTags->"S3.5.12"],
Cell[218574, 8141, 79, 1, 70, "Caption",
  CellTags->"S3.5.12"],
Cell[218656, 8144, 127, 4, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.20"}],

Cell[CellGroupData[{
Cell[218808, 8152, 120, 2, 70, "Input",
  CellTags->"S3.5.12"],
Cell[218931, 8156, 191, 5, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[219137, 8164, 85, 1, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.21"}],

Cell[CellGroupData[{
Cell[219247, 8169, 107, 2, 70, "Input",
  CellTags->"S3.5.12"],
Cell[219357, 8173, 131, 3, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[219537, 8182, 71, 1, 70, "Subsubsection",
  CellTags->{"S3.5.12", "12.22"}],
Cell[219611, 8185, 1182, 38, 70, "DefinitionBox",
  CellTags->"S3.5.12"],
Cell[220796, 8225, 56, 1, 70, "Caption",
  CellTags->"S3.5.12"],
Cell[220855, 8228, 2043, 66, 70, "Text",
  CellTags->{"S3.5.12", "12.23"}],
Cell[222901, 8296, 285, 10, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.24"}],

Cell[CellGroupData[{
Cell[223211, 8310, 87, 2, 70, "Input",
  CellTags->"S3.5.12"],
Cell[223301, 8314, 109, 3, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[223425, 8320, 90, 1, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.25"}],

Cell[CellGroupData[{
Cell[223540, 8325, 91, 2, 70, "Input",
  CellTags->"S3.5.12"],
Cell[223634, 8329, 91, 3, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]],
Cell[223740, 8335, 281, 9, 70, "MathCaption",
  CellTags->{"S3.5.12", "12.26"}],

Cell[CellGroupData[{
Cell[224046, 8348, 87, 2, 70, "Input",
  CellTags->"S3.5.12"],
Cell[224136, 8352, 107, 3, 70, "Output",
  CellTags->"S3.5.12"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[224304, 8362, 103, 1, 70, "Subsection",
  CellTags->{"S3.5.13", "13.1"}],
Cell[224410, 8365, 547, 11, 70, "Text",
  CellTags->{"S3.5.13", "13.2"}],
Cell[224960, 8378, 1480, 44, 70, "DefinitionBox",
  CellTags->"S3.5.13"],
Cell[226443, 8424, 79, 1, 70, "Caption",
  CellTags->"S3.5.13"],
Cell[226525, 8427, 259, 9, 70, "MathCaption",
  CellTags->{"S3.5.13", "13.3"}],

Cell[CellGroupData[{
Cell[226809, 8440, 123, 2, 70, "Input",
  CellTags->"S3.5.13"],
Cell[226935, 8444, 15238, 995, 70, 15164, 992, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S3.5.13"],
Cell[242176, 9441, 178, 5, 70, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[242369, 9449, 256, 8, 70, "MathCaption",
  CellTags->{"S3.5.13", "13.4"}],

Cell[CellGroupData[{
Cell[242650, 9461, 162, 5, 70, "Input",
  CellTags->"S3.5.13"],
Cell[242815, 9468, 22596, 1470, 70, 22522, 1467, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S3.5.13"],
Cell[265414, 10940, 178, 5, 70, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[265607, 10948, 280, 9, 70, "MathCaption",
  CellTags->{"S3.5.13", "13.5"}],

Cell[CellGroupData[{
Cell[265912, 10961, 156, 5, 70, "Input",
  CellTags->"S3.5.13"],
Cell[266071, 10968, 83, 3, 70, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[266169, 10974, 292, 8, 70, "MathCaption",
  CellTags->{"S3.5.13", "13.6"}],

Cell[CellGroupData[{
Cell[266486, 10986, 115, 2, 70, "Input",
  CellTags->"S3.5.13"],
Cell[266604, 10990, 83, 3, 70, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[266702, 10996, 294, 10, 70, "MathCaption",
  CellTags->{"S3.5.13", "13.7"}],

Cell[CellGroupData[{
Cell[267021, 11010, 97, 2, 70, "Input",
  CellTags->"S3.5.13"],
Cell[267121, 11014, 115, 3, 70, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[267251, 11020, 220, 5, 70, "Text",
  CellTags->{"S3.5.13", "13.8"}],
Cell[267474, 11027, 173, 7, 70, "MathCaption",
  CellTags->{"S3.5.13", "13.9"}],

Cell[CellGroupData[{
Cell[267672, 11038, 110, 2, 70, "Input",
  CellTags->"S3.5.13"],
Cell[267785, 11042, 86, 3, 70, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[267886, 11048, 102, 1, 70, "MathCaption",
  CellTags->{"S3.5.13", "13.10"}],

Cell[CellGroupData[{
Cell[268013, 11053, 110, 2, 70, "Input",
  CellTags->"S3.5.13"],
Cell[268126, 11057, 88, 3, 70, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[268229, 11063, 329, 10, 70, "MathCaption",
  CellTags->{"S3.5.13", "13.11"}],

Cell[CellGroupData[{
Cell[268583, 11077, 108, 2, 70, "Input",
  CellTags->"S3.5.13"],
Cell[268694, 11081, 84, 3, 70, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[268793, 11087, 1605, 53, 70, "Text",
  CellTags->{"S3.5.13", "13.12"}],
Cell[270401, 11142, 140, 4, 70, "MathCaption",
  CellTags->{"S3.5.13", "13.13"}],

Cell[CellGroupData[{
Cell[270566, 11150, 92, 2, 70, "Input",
  CellTags->"S3.5.13"],
Cell[270661, 11154, 93, 3, 70, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[270769, 11160, 87, 1, 70, "MathCaption",
  CellTags->{"S3.5.13", "13.14"}],

Cell[CellGroupData[{
Cell[270881, 11165, 100, 2, 70, "Input",
  CellTags->"S3.5.13"],
Cell[270984, 11169, 11586, 759, 70, 11512, 756, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S3.5.13"],
Cell[282573, 11930, 179, 5, 70, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[282767, 11938, 98, 1, 70, "MathCaption",
  CellTags->{"S3.5.13", "13.15"}],

Cell[CellGroupData[{
Cell[282890, 11943, 105, 2, 70, "Input",
  CellTags->"S3.5.13"],
Cell[282998, 11947, 91, 3, 70, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[283104, 11953, 340, 11, 70, "MathCaption",
  CellTags->{"S3.5.13", "13.16"}],

Cell[CellGroupData[{
Cell[283469, 11968, 111, 2, 70, "Input",
  CellTags->"S3.5.13"],
Cell[283583, 11972, 121, 3, 70, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[283719, 11978, 182, 6, 70, "Text",
  CellTags->{"S3.5.13", "13.17"}],
Cell[283904, 11986, 133, 4, 70, "MathCaption",
  CellTags->{"S3.5.13", "13.18"}],

Cell[CellGroupData[{
Cell[284062, 11994, 98, 2, 28, "Input",
  CellTags->"S3.5.13"],
Cell[284163, 11998, 119, 3, 70, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[284297, 12004, 318, 10, 40, "MathCaption",
  CellTags->{"S3.5.13", "13.19"}],

Cell[CellGroupData[{
Cell[284640, 12018, 103, 2, 28, "Input",
  CellTags->"S3.5.13"],
Cell[284746, 12022, 173, 4, 49, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[284934, 12029, 264, 6, 40, "Text",
  CellTags->{"S3.5.13", "13.20"}],
Cell[285201, 12037, 299, 10, 40, "MathCaption",
  CellTags->{"S3.5.13", "13.21"}],

Cell[CellGroupData[{
Cell[285525, 12051, 146, 5, 45, "Input",
  CellTags->"S3.5.13"],
Cell[285674, 12058, 133, 3, 51, "Output",
  CellTags->"S3.5.13"]
}, Open  ]],
Cell[285822, 12064, 2441, 72, 102, "DefinitionBox",
  CellTags->"S3.5.13"],
Cell[288266, 12138, 96, 1, 16, "Caption",
  CellTags->"S3.5.13"],
Cell[288365, 12141, 1417, 46, 57, "Text",
  CellTags->{"S3.5.13", "13.22"}],
Cell[289785, 12189, 2744, 77, 84, "DefinitionBox",
  CellTags->"S3.5.13"],
Cell[292532, 12268, 67, 1, 16, "Caption",
  CellTags->"S3.5.13"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

