(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    108195,       4120]*)
(*NotebookOutlinePosition[    150540,       5361]*)
(*  CellTagsIndexPosition[    146778,       5211]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["3.6 ", "HeadingNumber"],
  "Series, Limits and Residues"
}], "Section",
  CellTags->{"S3.6.0", "0.1"}],

Cell[CellGroupData[{

Cell["3.6.1 Making Power Series Expansions", "Subsection",
  CellTags->{"S3.6.1", "1.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Series[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the power series expansion of ",
              StyleBox["expr", "TI"],
              " about the point ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["x",
                        "TI"], "=", 
                      SubscriptBox[
                        StyleBox["x",
                          "TI"], "0"]}], TraditionalForm]], "InlineFormula"],
              " to order at most ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["x",
                            "TI"], "-", 
                          SubscriptBox[
                            StyleBox["x",
                              "TI"], "0"]}], ")"}], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Series[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["x",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["y",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "find series expansions with respect to ",
              StyleBox["y", "TI"],
              " then ",
              StyleBox["x", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.6.1"],

Cell["Functions for creating power series. ", "Caption",
  CellTags->"S3.6.1"],

Cell[TextData[{
  "Here is the power series expansion for ",
  Cell[BoxData[
      FormBox[
        RowBox[{"exp", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " about the point ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  " to order\[NonBreakingSpace]",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "4"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.1", "1.2"}],

Cell[CellGroupData[{

Cell["Series[ Exp[x], {x, 0, 4} ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.6.1"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", "x", "+", \(x\^2\/2\), "+", \(x\^3\/6\), "+", \(x\^4\/24\), 
        "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 1, 
        Rational[ 1, 2], 
        Rational[ 1, 6], 
        Rational[ 1, 24]}, 0, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.6.1"]
}, Open  ]],

Cell[TextData[{
  "Here is the series expansion of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"exp", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " about the point ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.1", "1.3"}],

Cell[CellGroupData[{

Cell["Series[ Exp[x], {x, 1, 4} ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.6.1"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\[ExponentialE]", "+", \(\[ExponentialE]\ \((x - 1)\)\), 
        "+", \(1\/2\ \[ExponentialE]\ \((x - 1)\)\^2\), 
        "+", \(1\/6\ \[ExponentialE]\ \((x - 1)\)\^3\), 
        "+", \(1\/24\ \[ExponentialE]\ \((x - 1)\)\^4\), "+", 
        InterpretationBox[\(O[x - 1]\^5\),
          SeriesData[ x, 1, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ x, 1, {E, E, 
        Times[ 
          Rational[ 1, 2], E], 
        Times[ 
          Rational[ 1, 6], E], 
        Times[ 
          Rational[ 1, 24], E]}, 0, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.6.1"]
}, Open  ]],

Cell[TextData[{
  "If ",
  StyleBox["Mathematica", "TI"],
  " does not know the series expansion of a particular function, it writes \
the result symbolically in terms of derivatives. "
}], "MathCaption",
  CellTags->{"S3.6.1", "1.4"}],

Cell[CellGroupData[{

Cell["Series[ f[x], {x, 0, 3} ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.6.1"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(f[0]\), "+", 
        RowBox[{
          RowBox[{
            SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], " ", "x"}], "+", 
        RowBox[{\(1\/2\), " ", 
          RowBox[{
            SuperscriptBox["f", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], " ", \(x\^2\)}], "+",
         
        RowBox[{\(1\/6\), " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "0", "]"}], " ", \(x\^3\)}], "+",
         
        InterpretationBox[\(O[x]\^4\),
          SeriesData[ x, 0, {}, 0, 4, 1],
          Editable->False]}],
      SeriesData[ x, 0, {
        f[ 0], 
        Derivative[ 1][ f][ 0], 
        Times[ 
          Rational[ 1, 2], 
          Derivative[ 2][ f][ 0]], 
        Times[ 
          Rational[ 1, 6], 
          Derivative[ 3][ f][ 0]]}, 0, 4, 1],
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.6.1"]
}, Open  ]],

Cell[TextData[{
  "In mathematical terms, ",
  StyleBox["Series", "MR"],
  " can be viewed as a way of constructing Taylor series for functions. "
}], "Text",
  CellTags->{"S3.6.1", "1.5"}],

Cell[TextData[{
  "The standard formula for the Taylor series expansion about the point ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", 
          SubscriptBox[
            StyleBox["x",
              "TI"], "0"]}], TraditionalForm]], "InlineFormula"],
  " of a function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["g",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " with ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " derivative ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["g",
              "TI"], 
            RowBox[{"(", 
              StyleBox["k",
                "TI"], ")"}]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["g",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["k",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          SuperscriptBox[
            StyleBox["g",
              "TI"], 
            RowBox[{"(", 
              StyleBox["k",
                "TI"], ")"}]], 
          RowBox[{"(", 
            SubscriptBox[
              StyleBox["x",
                "TI"], "0"], ")"}], 
          FractionBox[
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{
                  StyleBox["x",
                    "TI"], "-", 
                  SubscriptBox[
                    StyleBox["x",
                      "TI"], "0"]}], ")"}], 
              StyleBox["k",
                "TI"]], 
            RowBox[{
              StyleBox["k",
                "TI"], "!"}]]}], TraditionalForm]], "InlineFormula"],
  ". Whenever this formula applies, it gives the same results as ",
  StyleBox["Series", "MR"],
  ". (For common functions, ",
  StyleBox["Series", "MR"],
  " nevertheless internally uses somewhat more efficient algorithms.) "
}], "Text",
  CellTags->{"S3.6.1", "1.6"}],

Cell[TextData[{
  StyleBox["Series", "MR"],
  " can also generate some power series that involve fractional and negative \
powers, not directly covered by the standard Taylor series formula. "
}], "Text",
  CellTags->{"S3.6.1", "1.7"}],

Cell[TextData[{
  "Here is a power series that contains negative powers of ",
  StyleBox["x", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.1", "1.8"}],

Cell[CellGroupData[{

Cell["Series[ Exp[x]/x^2, {x, 0, 4} ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.6.1"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(1\/x\^2\), "+", \(1\/x\), "+", \(1\/2\), "+", \(x\/6\), 
        "+", \(x\^2\/24\), "+", \(x\^3\/120\), "+", \(x\^4\/720\), "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, -2, 5, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 1, 
        Rational[ 1, 2], 
        Rational[ 1, 6], 
        Rational[ 1, 24], 
        Rational[ 1, 120], 
        Rational[ 1, 720]}, -2, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.6.1"]
}, Open  ]],

Cell[TextData[{
  "Here is a power series involving fractional powers of ",
  StyleBox["x", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.1", "1.9"}],

Cell[CellGroupData[{

Cell["Series[ Exp[Sqrt[x]], {x, 0, 2} ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.6.1"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", \(\@x\), "+", \(x\/2\), "+", \(x\^\(3/2\)\/6\), 
        "+", \(x\^2\/24\), "+", 
        InterpretationBox[\(O[x]\^\(5/2\)\),
          SeriesData[ x, 0, {}, 0, 5, 2],
          Editable->False]}],
      SeriesData[ x, 0, {1, 1, 
        Rational[ 1, 2], 
        Rational[ 1, 6], 
        Rational[ 1, 24]}, 0, 5, 2],
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.6.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Series", "MR"],
  " can also handle series that involve logarithmic terms.  "
}], "MathCaption",
  CellTags->{"S3.6.1", "1.10"}],

Cell[CellGroupData[{

Cell["Series[ Exp[2x] Log[x], {x, 0, 2} ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.6.1"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(Log[x]\), "+", \(2\ Log[x]\ x\), "+", \(2\ Log[x]\ x\^2\), 
        "+", 
        InterpretationBox[\(O[x]\^3\),
          SeriesData[ x, 0, {}, 0, 3, 1],
          Editable->False]}],
      SeriesData[ x, 0, {
        Log[ x], 
        Times[ 2, 
          Log[ x]], 
        Times[ 2, 
          Log[ x]]}, 0, 3, 1],
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.6.1"]
}, Open  ]],

Cell[TextData[{
  "There are, of course, mathematical functions for which no standard power \
series exist. ",
  StyleBox["Mathematica", "TI"],
  " recognizes many such cases. "
}], "Text",
  CellTags->{"S3.6.1", "1.11"}],

Cell[TextData[{
  StyleBox["Series", "MR"],
  " sees that ",
  Cell[BoxData[
      FormBox[
        RowBox[{"exp", 
          RowBox[{"(", 
            FractionBox["1", 
              StyleBox["x",
                "TI"]], ")"}]}], TraditionalForm]], "InlineFormula"],
  " has an essential singularity at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", and does not produce a power series.  "
}], "MathCaption",
  CellTags->{"S3.6.1", "1.12"}],

Cell[CellGroupData[{

Cell["Series[ Exp[1/x], {x, 0, 2} ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.6.1"],

Cell[BoxData[
    RowBox[{\(Series::"esss"\), \(\(:\)\(\ \)\), "\<\"Essential singularity \
encountered in \\!\\(\[ExponentialE]\\^\\*InterpretationBox[\\(1\\/x + \
\\*InterpretationBox[\\(\\(O[x]\\)\\^3\\), SeriesData[x, 0, List[], -1, 3, \
1], Rule[Editable, False]]\\), SeriesData[x, 0, List[1], -1, 3, 1], \
Rule[Editable, False]]\\).\"\>"}]], "Message",
  CellTags->"S3.6.1"],

Cell[BoxData[
    \(\[ExponentialE]\^\(1\/x\)\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.6.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Series", "MR"],
  " can nevertheless give you the power series for ",
  Cell[BoxData[
      FormBox[
        RowBox[{"exp", 
          RowBox[{"(", 
            FractionBox["1", 
              StyleBox["x",
                "TI"]], ")"}]}], TraditionalForm]], "InlineFormula"],
  " about the point ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "\[Infinity]"}], TraditionalForm]], "InlineFormula"],
  ".   "
}], "MathCaption",
  CellTags->{"S3.6.1", "1.13"}],

Cell[CellGroupData[{

Cell["Series[ Exp[1/x], {x, Infinity, 3} ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.6.1"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", \(1\/x\), "+", \(1\/2\ \((1\/x)\)\^2\), 
        "+", \(1\/6\ \((1\/x)\)\^3\), "+", 
        InterpretationBox[\(O[1\/x]\^4\),
          SeriesData[ x, 
            DirectedInfinity[ 1], {}, 0, 4, 1],
          Editable->False]}],
      SeriesData[ x, 
        DirectedInfinity[ 1], {1, 1, 
        Rational[ 1, 2], 
        Rational[ 1, 6]}, 0, 4, 1],
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.6.1"]
}, Open  ]],

Cell[TextData[{
  "Especially when negative powers occur, there is some subtlety in exactly \
how many terms of a particular power series the function ",
  StyleBox["Series", "MR"],
  " will generate. "
}], "Text",
  CellTags->{"S3.6.1", "1.14"}],

Cell["\<\
One way to understand what happens is to think of the analogy \
between power series taken to a certain order, and real numbers taken to a \
certain precision. Power series are \[OpenCurlyDoubleQuote]approximate \
formulas\[CloseCurlyDoubleQuote] in much the same sense as \
finite\[Hyphen]precision real numbers are approximate numbers.   \
\>", "Text",\

  CellTags->{"S3.6.1", "1.15"}],

Cell[TextData[{
  "The procedure that ",
  StyleBox["Series", "MR"],
  " follows in constructing a power series is largely analogous to the \
procedure that ",
  StyleBox["N", "MR"],
  " follows in constructing a real\[Hyphen]number approximation. Both \
functions effectively start by replacing the smallest pieces of your \
expression by finite\[Hyphen]order, or finite\[Hyphen]precision, \
approximations, and then evaluating the resulting expression. If there are, \
for example, cancellations, this procedure may give a final result whose \
order or precision is less than the order or precision that you originally \
asked for. Like ",
  StyleBox["N", "MR"],
  ", however, ",
  StyleBox["Series", "MR"],
  " has some ability to retry its computations so as to get results to the \
order you ask for. In cases where it does not succeed, you can usually still \
get results to a particular order by asking for a higher order than you need. \
"
}], "Text",
  CellTags->{"S3.6.1", "1.16"}],

Cell[TextData[{
  StyleBox["Series", "MR"],
  " compensates for cancellations in this computation, and succeeds in giving \
you a result to order ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "3"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.1", "1.17"}],

Cell[CellGroupData[{

Cell["Series[ Sin[x]/x^2, {x, 0, 3} ]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.6.1"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(1\/x\), "-", \(x\/6\), "+", \(x\^3\/120\), "+", 
        InterpretationBox[\(O[x]\^4\),
          SeriesData[ x, 0, {}, -1, 4, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 
        Rational[ -1, 6], 0, 
        Rational[ 1, 120]}, -1, 4, 1],
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.6.1"]
}, Open  ]],

Cell[TextData[{
  "When you make a power series expansion in a variable ",
  StyleBox["x", "TI"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " assumes that all objects that do not explicitly contain ",
  StyleBox["x", "TI"],
  " are in fact independent of ",
  StyleBox["x", "TI"],
  ". ",
  StyleBox["Series", "MR"],
  " thus does partial derivatives (effectively using ",
  StyleBox["D", "MR"],
  ") to build up Taylor series. "
}], "Text",
  CellTags->{"S3.6.1", "1.18"}],

Cell[TextData[{
  "Both ",
  StyleBox["a", "MR"],
  " and ",
  StyleBox["n", "MR"],
  " are assumed to be independent of ",
  StyleBox["x", "MR"],
  ".   "
}], "MathCaption",
  CellTags->{"S3.6.1", "1.19"}],

Cell[CellGroupData[{

Cell["Series[ (a + x)^n , {x, 0, 2} ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.6.1"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(a\^n\), "+", \(a\^\(\(-1\) + n\)\ n\ x\), 
        "+", \(\((\(-\(1\/2\)\)\ a\^\(\(-2\) + n\)\ n + 
              1\/2\ a\^\(\(-2\) + n\)\ n\^2)\)\ x\^2\), "+", 
        InterpretationBox[\(O[x]\^3\),
          SeriesData[ x, 0, {}, 0, 3, 1],
          Editable->False]}],
      SeriesData[ x, 0, {
        Power[ a, n], 
        Times[ 
          Power[ a, 
            Plus[ -1, n]], n], 
        Plus[ 
          Times[ 
            Rational[ -1, 2], 
            Power[ a, 
              Plus[ -2, n]], n], 
          Times[ 
            Rational[ 1, 2], 
            Power[ a, 
              Plus[ -2, n]], 
            Power[ n, 2]]]}, 0, 3, 1],
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.6.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["a[x]", "MR"],
  " is now given as an explicit function of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.1", "1.20"}],

Cell[CellGroupData[{

Cell["Series[ (a[x] + x)^n, {x, 0, 2} ]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.6.1"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(a[0]\^n\), "+", 
        RowBox[{"n", " ", \(a[0]\^\(\(-1\) + n\)\), " ", 
          RowBox[{"(", 
            RowBox[{"1", "+", 
              RowBox[{
                SuperscriptBox["a", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}]}], ")"}], " ", 
          "x"}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              
              RowBox[{\(1\/2\), " ", \((\(-1\) + n)\), " ", "n", 
                " ", \(a[0]\^\(\(-2\) + n\)\), " ", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"1", "+", 
                      RowBox[{
                        SuperscriptBox["a", "\[Prime]",
                          MultilineFunction->None], "[", "0", "]"}]}], ")"}], 
                  "2"]}], "+", 
              
              RowBox[{\(1\/2\), " ", "n", " ", \(a[0]\^\(\(-1\) + n\)\), " ", 
                
                RowBox[{
                  SuperscriptBox["a", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "0", "]"}]}]}], ")"}], 
          " ", \(x\^2\)}], "+", 
        InterpretationBox[\(O[x]\^3\),
          SeriesData[ x, 0, {}, 0, 3, 1],
          Editable->False]}],
      SeriesData[ x, 0, {
        Power[ 
          a[ 0], n], 
        Times[ n, 
          Power[ 
            a[ 0], 
            Plus[ -1, n]], 
          Plus[ 1, 
            Derivative[ 1][ a][ 0]]], 
        Plus[ 
          Times[ 
            Rational[ 1, 2], 
            Plus[ -1, n], n, 
            Power[ 
              a[ 0], 
              Plus[ -2, n]], 
            Power[ 
              Plus[ 1, 
                Derivative[ 1][ a][ 0]], 2]], 
          Times[ 
            Rational[ 1, 2], n, 
            Power[ 
              a[ 0], 
              Plus[ -1, n]], 
            Derivative[ 2][ a][ 0]]]}, 0, 3, 1],
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.6.1"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Series", "MR"],
  " to generate power series in a sequence of different variables. ",
  StyleBox["Series", "MR"],
  " works like ",
  StyleBox["Integrate", "MR"],
  ", ",
  StyleBox["Sum", "MR"],
  " and so on, and expands first with respect to the last variable you \
specify.  "
}], "Text",
  CellTags->{"S3.6.1", "1.21"}],

Cell[TextData[{
  StyleBox["Series", "MR"],
  " performs a series expansion successively with respect to each variable. \
The result in this case is a series in ",
  StyleBox["x", "MR"],
  ", whose coefficients are series in ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.1", "1.22"}],

Cell[CellGroupData[{

Cell["Series[Exp[x y], {x, 0, 3}, {y, 0, 3}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.6.1"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"1", "+", 
        RowBox[{
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{"y", "+", 
                InterpretationBox[\(O[y]\^4\),
                  SeriesData[ y, 0, {}, 1, 4, 1],
                  Editable->False]}],
              SeriesData[ y, 0, {1}, 1, 4, 1],
              Editable->False], ")"}], " ", "x"}], "+", 
        RowBox[{
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{\(y\^2\/2\), "+", 
                InterpretationBox[\(O[y]\^4\),
                  SeriesData[ y, 0, {}, 2, 4, 1],
                  Editable->False]}],
              SeriesData[ y, 0, {
                Rational[ 1, 2]}, 2, 4, 1],
              Editable->False], ")"}], " ", \(x\^2\)}], "+", 
        RowBox[{
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{\(y\^3\/6\), "+", 
                InterpretationBox[\(O[y]\^4\),
                  SeriesData[ y, 0, {}, 3, 4, 1],
                  Editable->False]}],
              SeriesData[ y, 0, {
                Rational[ 1, 6]}, 3, 4, 1],
              Editable->False], ")"}], " ", \(x\^3\)}], "+", 
        InterpretationBox[\(O[x]\^4\),
          SeriesData[ x, 0, {}, 0, 4, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 
        SeriesData[ y, 0, {1}, 1, 4, 1], 
        SeriesData[ y, 0, {
          Rational[ 1, 2]}, 2, 4, 1], 
        SeriesData[ y, 0, {
          Rational[ 1, 6]}, 3, 4, 1]}, 0, 4, 1],
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.6.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.6.2 Advanced Topic: The Representation of Power Series", "Subsection",
  CellTags->{"S3.6.2", "2.1"}],

Cell[TextData[{
  "Power series are represented in ",
  StyleBox["Mathematica", "TI"],
  " as ",
  StyleBox["SeriesData", "MR"],
  " objects.  "
}], "Text",
  CellTags->{"S3.6.2", "2.2"}],

Cell[TextData[{
  "The power series is printed out as a sum of terms, ending with ",
  StyleBox["O[x]", "MR"],
  " raised to a power. "
}], "MathCaption",
  CellTags->{"S3.6.2", "2.3"}],

Cell[CellGroupData[{

Cell["Series[Cos[x], {x, 0, 4}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.6.2"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"1", "-", \(x\^2\/2\), "+", \(x\^4\/24\), "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 
        Rational[ -1, 2], 0, 
        Rational[ 1, 24]}, 0, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.6.2"]
}, Open  ]],

Cell[TextData[{
  "Internally, however, the series is stored as a ",
  StyleBox["SeriesData", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S3.6.2", "2.4"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.6.2"],

Cell["SeriesData[x, 0, {1, 0, -1/2, 0, 1/24}, 0, 5, 1]", "Output",
  CellLabel->"Out[2]//InputForm= ",
  CellTags->"S3.6.2"]
}, Open  ]],

Cell[TextData[{
  "By using ",
  StyleBox["SeriesData", "MR"],
  " objects, rather than ordinary expressions, to represent power series, ",
  StyleBox["Mathematica", "TI"],
  " can keep track of the order and expansion point, and do operations on the \
power series appropriately. You should not normally need to know the internal \
structure of ",
  StyleBox["SeriesData", "MR"],
  " objects. "
}], "Text",
  CellTags->{"S3.6.2", "2.5"}],

Cell[TextData[{
  "You can recognize a power series that is printed out in standard output \
form by the presence of an ",
  StyleBox["O[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " term. This term mimics the standard mathematical notation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["O",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", and represents omitted terms of order ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". For various reasons of consistency, ",
  StyleBox["Mathematica", "TI"],
  " uses the notation ",
  StyleBox["O[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]^", "MR"],
  StyleBox["n", "TI"],
  " for omitted terms of order ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", corresponding to the mathematical notation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["O",
            "TI"], 
          SuperscriptBox[
            RowBox[{"(", 
              StyleBox["x",
                "TI"], ")"}], 
            StyleBox["n",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ", rather than the slightly more familiar, though equivalent, form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["O",
            "TI"], 
          RowBox[{"(", 
            SuperscriptBox[
              StyleBox["x",
                "TI"], 
              StyleBox["n",
                "TI"]], ")"}]}], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.6.2", "2.6"}],

Cell[TextData[{
  "Any time that an object like ",
  StyleBox["O[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " appears in a sum of terms, ",
  StyleBox["Mathematica", "TI"],
  " will in fact convert the whole sum into a power series. "
}], "Text",
  CellTags->{"S3.6.2", "2.7"}],

Cell[TextData[{
  "The presence of ",
  StyleBox["O[x]", "MR"],
  " makes ",
  StyleBox["Mathematica", "TI"],
  " convert the whole sum to a power series. "
}], "MathCaption",
  CellTags->{"S3.6.2", "2.8"}],

Cell[CellGroupData[{

Cell["a x + Exp[x] + O[x]^3", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.6.2"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"1", "+", \(\((1 + a)\)\ x\), "+", \(x\^2\/2\), "+", 
        InterpretationBox[\(O[x]\^3\),
          SeriesData[ x, 0, {}, 0, 3, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 
        Plus[ 1, a], 
        Rational[ 1, 2]}, 0, 3, 1],
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.6.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.6.3 Operations on Power Series", "Subsection",
  CellTags->{"S3.6.3", "3.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to perform many operations on power series. In all cases, ",
  StyleBox["Mathematica", "TI"],
  " gives results only to as many terms as can be justified from the accuracy \
of your input. "
}], "Text",
  CellTags->{"S3.6.3", "3.2"}],

Cell[TextData[{
  "Here is a power series accurate to fourth order in ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.3", "3.3"}],

Cell[CellGroupData[{

Cell["Series[ Exp[x], {x, 0, 4} ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.6.3"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", "x", "+", \(x\^2\/2\), "+", \(x\^3\/6\), "+", \(x\^4\/24\), 
        "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 1, 
        Rational[ 1, 2], 
        Rational[ 1, 6], 
        Rational[ 1, 24]}, 0, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.6.3"]
}, Open  ]],

Cell["\<\
When you square the power series, you get another power series, \
also accurate to fourth order. \
\>", "MathCaption",
  CellTags->{"S3.6.3", "3.4"}],

Cell[CellGroupData[{

Cell["%^2", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.6.3"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", \(2\ x\), "+", \(2\ x\^2\), "+", \(\(4\ x\^3\)\/3\), 
        "+", \(\(2\ x\^4\)\/3\), "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 2, 2, 
        Rational[ 4, 3], 
        Rational[ 2, 3]}, 0, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.6.3"]
}, Open  ]],

Cell[TextData[{
  "Taking the logarithm gives you the result ",
  StyleBox["2x", "MR"],
  ", but only to order ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "4"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.3", "3.5"}],

Cell[CellGroupData[{

Cell["Log[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.6.3"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(2\ x\), "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, 1, 5, 1],
          Editable->False]}],
      SeriesData[ x, 0, {2}, 1, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.6.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " keeps track of the orders of power series in much the same way as it \
keeps track of the precision of approximate real numbers. Just as with \
numerical calculations, there are operations on power series which can \
increase, or decrease, the precision (or order) of your results. "
}], "Text",
  CellTags->{"S3.6.3", "3.6"}],

Cell[TextData[{
  "Here is a power series accurate to order ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "10"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.3", "3.7"}],

Cell[CellGroupData[{

Cell["Series[ Cos[x], {x, 0, 10} ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.6.3"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "-", \(x\^2\/2\), "+", \(x\^4\/24\), "-", \(x\^6\/720\), 
        "+", \(x\^8\/40320\), "-", \(x\^10\/3628800\), "+", 
        InterpretationBox[\(O[x]\^11\),
          SeriesData[ x, 0, {}, 0, 11, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 
        Rational[ -1, 2], 0, 
        Rational[ 1, 24], 0, 
        Rational[ -1, 720], 0, 
        Rational[ 1, 40320], 0, 
        Rational[ -1, 3628800]}, 0, 11, 1],
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.6.3"]
}, Open  ]],

Cell[TextData[{
  "This gives a power series that is accurate only to order ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "6"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.3", "3.8"}],

Cell[CellGroupData[{

Cell["1 / (1 - %)", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.6.3"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(2\/x\^2\), "+", \(1\/6\), "+", \(x\^2\/120\), 
        "+", \(x\^4\/3024\), "+", \(x\^6\/86400\), "+", 
        InterpretationBox[\(O[x]\^7\),
          SeriesData[ x, 0, {}, -2, 7, 1],
          Editable->False]}],
      SeriesData[ x, 0, {2, 0, 
        Rational[ 1, 6], 0, 
        Rational[ 1, 120], 0, 
        Rational[ 1, 3024], 0, 
        Rational[ 1, 86400]}, -2, 7, 1],
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.6.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " also allows you to do calculus with power series.    "
}], "Text",
  CellTags->{"S3.6.3", "3.9"}],

Cell[TextData[{
  "Here is a power series for ",
  Cell[BoxData[
      FormBox[
        RowBox[{"tan", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.3", "3.10"}],

Cell[CellGroupData[{

Cell["Series[Tan[x], {x, 0, 10}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.6.3"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "x", "+", \(x\^3\/3\), "+", \(\(2\ x\^5\)\/15\), 
        "+", \(\(17\ x\^7\)\/315\), "+", \(\(62\ x\^9\)\/2835\), "+", 
        InterpretationBox[\(O[x]\^11\),
          SeriesData[ x, 0, {}, 1, 11, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 
        Rational[ 1, 3], 0, 
        Rational[ 2, 15], 0, 
        Rational[ 17, 315], 0, 
        Rational[ 62, 2835]}, 1, 11, 1],
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.6.3"]
}, Open  ]],

Cell[TextData[{
  "Here is its derivative with respect to ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.3", "3.11"}],

Cell[CellGroupData[{

Cell["D[%, x]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.6.3"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", \(x\^2\), "+", \(\(2\ x\^4\)\/3\), "+", \(\(17\ x\^6\)\/45\), 
        "+", \(\(62\ x\^8\)\/315\), "+", 
        InterpretationBox[\(O[x]\^10\),
          SeriesData[ x, 0, {}, 0, 10, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 1, 0, 
        Rational[ 2, 3], 0, 
        Rational[ 17, 45], 0, 
        Rational[ 62, 315]}, 0, 10, 1],
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.6.3"]
}, Open  ]],

Cell[TextData[{
  "Integrating with respect to ",
  StyleBox["x", "MR"],
  " gives back the original power series. "
}], "MathCaption",
  CellTags->{"S3.6.3", "3.12"}],

Cell[CellGroupData[{

Cell["Integrate[%, x]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.6.3"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "x", "+", \(x\^3\/3\), "+", \(\(2\ x\^5\)\/15\), 
        "+", \(\(17\ x\^7\)\/315\), "+", \(\(62\ x\^9\)\/2835\), "+", 
        InterpretationBox[\(O[x]\^11\),
          SeriesData[ x, 0, {}, 1, 11, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 
        Rational[ 1, 3], 0, 
        Rational[ 2, 15], 0, 
        Rational[ 17, 315], 0, 
        Rational[ 62, 2835]}, 1, 11, 1],
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.6.3"]
}, Open  ]],

Cell[TextData[{
  "When you perform an operation that involves both a normal expression and a \
power series, ",
  StyleBox["Mathematica", "TI"],
  " \[OpenCurlyDoubleQuote]absorbs\[CloseCurlyDoubleQuote] the normal \
expression into the power series whenever possible. "
}], "Text",
  CellTags->{"S3.6.3", "3.13"}],

Cell[TextData[{
  "The ",
  StyleBox["1", "MR"],
  " is automatically absorbed into the power series. "
}], "MathCaption",
  CellTags->{"S3.6.3", "3.14"}],

Cell[CellGroupData[{

Cell["1 + Series[Exp[x], {x, 0, 4}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.6.3"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "2", "+", "x", "+", \(x\^2\/2\), "+", \(x\^3\/6\), "+", \(x\^4\/24\), 
        "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ x, 0, {2, 1, 
        Rational[ 1, 2], 
        Rational[ 1, 6], 
        Rational[ 1, 24]}, 0, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.6.3"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["x^2", "MR"],
  " is also absorbed into the power series. "
}], "MathCaption",
  CellTags->{"S3.6.3", "3.15"}],

Cell[CellGroupData[{

Cell["% + x^2", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.6.3"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "2", "+", "x", "+", \(\(3\ x\^2\)\/2\), "+", \(x\^3\/6\), 
        "+", \(x\^4\/24\), "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ x, 0, {2, 1, 
        Rational[ 3, 2], 
        Rational[ 1, 6], 
        Rational[ 1, 24]}, 0, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.6.3"]
}, Open  ]],

Cell[TextData[{
  "If you add ",
  StyleBox["Sin[x]", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " generates the appropriate power series for ",
  StyleBox["Sin[x]", "MR"],
  ", and combines it with the power series you have. "
}], "MathCaption",
  CellTags->{"S3.6.3", "3.16"}],

Cell[CellGroupData[{

Cell["% + Sin[x]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.6.3"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "2", "+", \(2\ x\), "+", \(\(3\ x\^2\)\/2\), "+", \(x\^4\/24\), "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ x, 0, {2, 2, 
        Rational[ 3, 2], 0, 
        Rational[ 1, 24]}, 0, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.6.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " also absorbs expressions that multiply power series. The symbol ",
  StyleBox["a", "MR"],
  " is assumed to be independent of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.3", "3.17"}],

Cell[CellGroupData[{

Cell["(a + x) %^2", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.6.3"],

Cell[BoxData[
    TagBox[\(4\ a + \((4 + 8\ a)\)\ x + \((8 + 10\ a)\)\ x\^2 + \((10 + 
              6\ a)\)\ x\^3 + \((6 + \(29\ a\)\/12)\)\ x\^4 + O[x]\^5\),
      HoldForm]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.6.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " knows how to apply a wide variety of functions to power series. However, \
if you apply an arbitrary function to a power series, it is impossible for ",
  StyleBox["Mathematica", "TI"],
  " to give you anything but a symbolic result.  "
}], "Text",
  CellTags->{"S3.6.3", "3.18"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " does not know how to apply the function ",
  StyleBox["f", "MR"],
  " to a power series, so it just leaves the symbolic result. "
}], "MathCaption",
  CellTags->{"S3.6.3", "3.19"}],

Cell[CellGroupData[{

Cell["f[ Series[ Exp[x], {x, 0, 3} ] ]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.6.3"],

Cell[BoxData[
    RowBox[{"f", "[", 
      InterpretationBox[
        RowBox[{"1", "+", "x", "+", \(x\^2\/2\), "+", \(x\^3\/6\), "+", 
          InterpretationBox[\(O[x]\^4\),
            SeriesData[ x, 0, {}, 0, 4, 1],
            Editable->False]}],
        SeriesData[ x, 0, {1, 1, 
          Rational[ 1, 2], 
          Rational[ 1, 6]}, 0, 4, 1],
        Editable->False], "]"}]], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.6.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
3.6.4 Advanced Topic: Composition and Inversion of Power \
Series\
\>", "Subsection",
  CellTags->{"S3.6.4", "4.1"}],

Cell[TextData[{
  "When you manipulate power series, it is sometimes convenient to think of \
the series as representing ",
  StyleBox["functions", "TI"],
  ", which you can, for example, compose or invert. "
}], "Text",
  CellTags->{"S3.6.4", "4.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ComposeSeries[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["series",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["series",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["compose power series "]},
          {Cell[TextData[{
              StyleBox["InverseSeries[", "MR"],
              StyleBox["series", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["invert a power series "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.6.4"],

Cell["Composition and inversion of power series. ", "Caption",
  CellTags->"S3.6.4"],

Cell[TextData[{
  "Here is the power series for ",
  Cell[BoxData[
      FormBox[
        RowBox[{"exp", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "5"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.4", "4.3"}],

Cell[CellGroupData[{

Cell["Series[Exp[x], {x, 0, 5}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.6.4"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", "x", "+", \(x\^2\/2\), "+", \(x\^3\/6\), "+", \(x\^4\/24\), 
        "+", \(x\^5\/120\), "+", 
        InterpretationBox[\(O[x]\^6\),
          SeriesData[ x, 0, {}, 0, 6, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 1, 
        Rational[ 1, 2], 
        Rational[ 1, 6], 
        Rational[ 1, 24], 
        Rational[ 1, 120]}, 0, 6, 1],
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.6.4"]
}, Open  ]],

Cell[TextData[{
  "This replaces the variable ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " in the power series for ",
  Cell[BoxData[
      FormBox[
        RowBox[{"exp", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " by a power series for ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.4", "4.4"}],

Cell[CellGroupData[{

Cell["ComposeSeries[%, Series[Sin[x], {x, 0, 5}]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.6.4"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", "x", "+", \(x\^2\/2\), "-", \(x\^4\/8\), "-", \(x\^5\/15\), 
        "+", 
        InterpretationBox[\(O[x]\^6\),
          SeriesData[ x, 0, {}, 0, 6, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 1, 
        Rational[ 1, 2], 0, 
        Rational[ -1, 8], 
        Rational[ -1, 15]}, 0, 6, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.6.4"]
}, Open  ]],

Cell[TextData[{
  "The result is the power series for ",
  Cell[BoxData[
      FormBox[
        RowBox[{"exp", 
          RowBox[{"(", 
            RowBox[{"sin", 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.4", "4.5"}],

Cell[CellGroupData[{

Cell["Series[Exp[Sin[x]], {x, 0, 5}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.6.4"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", "x", "+", \(x\^2\/2\), "-", \(x\^4\/8\), "-", \(x\^5\/15\), 
        "+", 
        InterpretationBox[\(O[x]\^6\),
          SeriesData[ x, 0, {}, 0, 6, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 1, 
        Rational[ 1, 2], 0, 
        Rational[ -1, 8], 
        Rational[ -1, 15]}, 0, 6, 1],
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.6.4"]
}, Open  ]],

Cell[TextData[{
  "If you have a power series for a function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["y",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", then it is often possible to get a power series approximation to the \
solution for ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " in the equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["y",
              "TI"], ")"}], "=", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". This power series effectively gives the inverse function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["f",
              "TI"], \(-1\)], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " such that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["f",
                  "TI"], \(-1\)], 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}], ")"}], "=", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". The operation of finding the power series for an inverse function is \
sometimes known as ",
  StyleBox["reversion", "TI"],
  " of power series.  "
}], "Text",
  CellTags->{"S3.6.4", "4.6"}],

Cell[TextData[{
  "Here is the series for ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox["y",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.4", "4.7"}],

Cell[CellGroupData[{

Cell["Series[Sin[y], {y, 0, 5}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.6.4"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"y", "-", \(y\^3\/6\), "+", \(y\^5\/120\), "+", 
        InterpretationBox[\(O[y]\^6\),
          SeriesData[ y, 0, {}, 1, 6, 1],
          Editable->False]}],
      SeriesData[ y, 0, {1, 0, 
        Rational[ -1, 6], 0, 
        Rational[ 1, 120]}, 1, 6, 1],
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.6.4"]
}, Open  ]],

Cell[TextData[{
  "Inverting the series gives the series for ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(sin\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.4", "4.8"}],

Cell[CellGroupData[{

Cell["InverseSeries[%, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.6.4"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"x", "+", \(x\^3\/6\), "+", \(\(3\ x\^5\)\/40\), "+", 
        InterpretationBox[\(O[x]\^6\),
          SeriesData[ x, 0, {}, 1, 6, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 
        Rational[ 1, 6], 0, 
        Rational[ 3, 40]}, 1, 6, 1],
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.6.4"]
}, Open  ]],

Cell["Composing the two series gives the identity function. ", "MathCaption",
  CellTags->{"S3.6.4", "4.9"}],

Cell[CellGroupData[{

Cell["ComposeSeries[%, %%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.6.4"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"y", "+", 
        InterpretationBox[\(O[y]\^6\),
          SeriesData[ y, 0, {}, 1, 6, 1],
          Editable->False]}],
      SeriesData[ y, 0, {1}, 1, 6, 1],
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.6.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.6.5 Converting Power Series to Normal Expressions", "Subsection",
  CellTags->{"S3.6.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Normal[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["convert a power series to a normal expression "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.6.5"],

Cell["Converting power series to normal expressions. ", "Caption",
  CellTags->"S3.6.5"],

Cell[TextData[{
  "As discussed above, power series in ",
  StyleBox["Mathematica", "TI"],
  " are represented in a special internal form, which keeps track of such \
attributes as their expansion order. "
}], "Text",
  CellTags->{"S3.6.5", "5.2"}],

Cell["\<\
For some purposes, you may want to convert power series to normal \
expressions. From a mathematical point of view, this corresponds to \
truncating the power series, and assuming that all higher\[Hyphen]order terms \
are zero. \
\>", "Text",
  CellTags->{"S3.6.5", "5.3"}],

Cell["This generates a power series, with four terms. ", "MathCaption",
  CellTags->{"S3.6.5", "5.4"}],

Cell[CellGroupData[{

Cell["t = Series[ ArcTan[x], {x, 0, 8} ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.6.5"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "x", "-", \(x\^3\/3\), "+", \(x\^5\/5\), "-", \(x\^7\/7\), "+", 
        InterpretationBox[\(O[x]\^9\),
          SeriesData[ x, 0, {}, 1, 9, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 
        Rational[ -1, 3], 0, 
        Rational[ 1, 5], 0, 
        Rational[ -1, 7]}, 1, 9, 1],
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.6.5"]
}, Open  ]],

Cell["\<\
Squaring the power series gives you another power series, with the \
appropriate number of terms. \
\>", "MathCaption",
  CellTags->{"S3.6.5", "5.5"}],

Cell[CellGroupData[{

Cell["t^2", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.6.5"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(x\^2\), "-", \(\(2\ x\^4\)\/3\), "+", \(\(23\ x\^6\)\/45\), 
        "-", \(\(44\ x\^8\)\/105\), "+", 
        InterpretationBox[\(O[x]\^10\),
          SeriesData[ x, 0, {}, 2, 10, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 
        Rational[ -2, 3], 0, 
        Rational[ 23, 45], 0, 
        Rational[ -44, 105]}, 2, 10, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.6.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Normal", "MR"],
  " truncates the power series, giving a normal expression. "
}], "MathCaption",
  CellTags->{"S3.6.5", "5.6"}],

Cell[CellGroupData[{

Cell["Normal[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.6.5"],

Cell[BoxData[
    \(x\^2 - \(2\ x\^4\)\/3 + \(23\ x\^6\)\/45 - \(44\ x\^8\)\/105\)], \
"Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.6.5"]
}, Open  ]],

Cell["You can now apply standard algebraic operations. ", "MathCaption",
  CellTags->{"S3.6.5", "5.7"}],

Cell[CellGroupData[{

Cell["Factor[%]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.6.5"],

Cell[BoxData[
    \(\(-\(1\/315\)\)\ x\^2\ \((\(-315\) + 210\ x\^2 - 161\ x\^4 + 
          132\ x\^6)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.6.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SeriesCoefficient[", "MR"],
              StyleBox["series", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the coefficient of the ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " order term in a power series "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.6.5"],

Cell["Extracting coefficients of terms in power series. ", "Caption",
  CellTags->"S3.6.5"],

Cell[TextData[{
  "This gives the coefficient of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "7"], TraditionalForm]], "InlineFormula"],
  " in the original power series. "
}], "MathCaption",
  CellTags->{"S3.6.5", "5.8"}],

Cell[CellGroupData[{

Cell["SeriesCoefficient[t, 7]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.6.5"],

Cell[BoxData[
    \(\(-\(1\/7\)\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.6.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.6.6 Solving Equations Involving Power Series", "Subsection",
  CellTags->{"S3.6.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LogicalExpand[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["series",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["==", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["series",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
give the equations obtained by equating corresponding \
coefficients in the power series \
\>"]},
          {Cell[TextData[{
              StyleBox["Solve[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["series",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["==", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["series",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["solve for coefficients in power series "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.6.6"],

Cell["Solving equations involving power series. ", "Caption",
  CellTags->"S3.6.6"],

Cell["Here is a power series. ", "MathCaption",
  CellTags->{"S3.6.6", "6.2"}],

Cell[CellGroupData[{

Cell["y = 1 + Sum[a[i] x^i, {i, 3}] + O[x]^4", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.6.6"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", \(a[1]\ x\), "+", \(a[2]\ x\^2\), "+", \(a[3]\ x\^3\), "+", 
        InterpretationBox[\(O[x]\^4\),
          SeriesData[ x, 0, {}, 0, 4, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 
        a[ 1], 
        a[ 2], 
        a[ 3]}, 0, 4, 1],
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.6.6"]
}, Open  ]],

Cell["This gives an equation involving the power series. ", "MathCaption",
  CellTags->{"S3.6.6", "6.3"}],

Cell[CellGroupData[{

Cell["D[y, x]^2 - y == x", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.6.6"],

Cell[BoxData[
    RowBox[{
      InterpretationBox[
        RowBox[{\((\(-1\) + a[1]\^2)\), 
          "+", \(\((\(-a[1]\) + 4\ a[1]\ a[2])\)\ x\), 
          "+", \(\((\(-a[2]\) + 4\ a[2]\^2 + 6\ a[1]\ a[3])\)\ x\^2\), "+", 
          InterpretationBox[\(O[x]\^3\),
            SeriesData[ x, 0, {}, 0, 3, 1],
            Editable->False]}],
        SeriesData[ x, 0, {
          Plus[ -1, 
            Power[ 
              a[ 1], 2]], 
          Plus[ 
            Times[ -1, 
              a[ 1]], 
            Times[ 4, 
              a[ 1], 
              a[ 2]]], 
          Plus[ 
            Times[ -1, 
              a[ 2]], 
            Times[ 4, 
              Power[ 
                a[ 2], 2]], 
            Times[ 6, 
              a[ 1], 
              a[ 3]]]}, 0, 3, 1],
        Editable->False], "\[Equal]", "x"}]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.6.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["LogicalExpand", "MR"],
  " generates a sequence of equations for each power of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.6", "6.4"}],

Cell[CellGroupData[{

Cell["LogicalExpand[ % ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.6.6"],

Cell[BoxData[
    \(\(-1\) + a[1]\^2 \[Equal] 0 && \(-1\) - a[1] + 4\ a[1]\ a[2] \[Equal] 
        0 && \(-a[2]\) + 4\ a[2]\^2 + 6\ a[1]\ a[3] \[Equal] 0\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.6.6"]
}, Open  ]],

Cell[TextData[{
  "This solves the equations for the coefficients ",
  StyleBox["a[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  ". You can also feed equations involving power series directly to ",
  StyleBox["Solve", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.6", "6.5"}],

Cell[CellGroupData[{

Cell["Solve[ % ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.6.6"],

Cell[BoxData[
    \({{a[3] \[Rule] \(-\(1\/12\)\), a[1] \[Rule] 1, 
        a[2] \[Rule] 1\/2}, {a[3] \[Rule] 0, a[1] \[Rule] \(-1\), 
        a[2] \[Rule] 0}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.6.6"]
}, Open  ]],

Cell[TextData[{
  "Some equations involving power series can also be solved using the ",
  StyleBox["InverseSeries", "MR"],
  " function discussed in Section\[NonBreakingSpace]",
  ButtonBox["3.6.4",
    ButtonData:>{"3.6.4", "4.6"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S3.6.6", "6.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.6.7 Summation of Series", "Subsection",
  CellTags->{"S3.6.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Sum[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the sum of ",
              StyleBox["expr", "TI"],
              " as ",
              StyleBox["n", "TI"],
              " goes from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.6.7"],

Cell["Evaluating sums. ", "Caption",
  CellTags->"S3.6.7"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " recognizes this as the power series expansion of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["x",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ".  "
}], "MathCaption",
  CellTags->{"S3.6.7", "7.2"}],

Cell[CellGroupData[{

Cell["Sum[x^n/n!, {n, 0, Infinity}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.6.7"],

Cell[BoxData[
    \(\[ExponentialE]\^x\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.6.7"]
}, Open  ]],

Cell["This sum comes out in terms of a Bessel function.  ", "MathCaption",
  CellTags->{"S3.6.7", "7.3"}],

Cell[CellGroupData[{

Cell["Sum[x^n/(n!^2), {n, 0, Infinity}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.6.7"],

Cell[BoxData[
    \(BesselI[0, 2\ \@x]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.6.7"]
}, Open  ]],

Cell["\<\
Here is another sum that can be done in terms of common special \
functions. \
\>", "MathCaption",
  CellTags->{"S3.6.7", "7.4"}],

Cell[CellGroupData[{

Cell["Sum[n! x^n/(2n)!, {n, 1, Infinity}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.6.7"],

Cell[BoxData[
    \(1\/2\ \[ExponentialE]\^\(x/4\)\ \@\[Pi]\ \@x\ Erf[\@x\/2]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.6.7"]
}, Open  ]],

Cell["\<\
Generalized hypergeometric functions are not uncommon in sums.  \
\
\>", "MathCaption",
  CellTags->{"S3.6.7", "7.5"}],

Cell[CellGroupData[{

Cell["Sum[x^n/(n!^4), {n, 0, Infinity}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.6.7"],

Cell[BoxData[
    \(HypergeometricPFQ[{}, {1, 1, 1}, x]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.6.7"]
}, Open  ]],

Cell["\<\
There are many analogies between sums and integrals. And just as it \
is possible to have indefinite integrals, so indefinite sums can be set up by \
using symbolic variables as upper limits.  \
\>", "Text",
  CellTags->{"S3.6.7", "7.6"}],

Cell["This is effectively an indefinite sum. ", "MathCaption",
  CellTags->{"S3.6.7", "7.7"}],

Cell[CellGroupData[{

Cell["Sum[k, {k, 0, n}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.6.7"],

Cell[BoxData[
    \(1\/2\ n\ \((1 + n)\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.6.7"]
}, Open  ]],

Cell["This sum comes out in terms of incomplete gamma functions.  ", \
"MathCaption",
  CellTags->{"S3.6.7", "7.8"}],

Cell[CellGroupData[{

Cell["Sum[x^k/k!, {k, 0, n}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.6.7"],

Cell[BoxData[
    \(\(\[ExponentialE]\^x\ \((1 + n)\)\ Gamma[1 + n, x]\)\/Gamma[2 + n]\)], \
"Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.6.7"]
}, Open  ]],

Cell["This sum involves polygamma functions.  ", "MathCaption",
  CellTags->{"S3.6.7", "7.9"}],

Cell[CellGroupData[{

Cell["Sum[1/(k+1)^4, {k, 0, n}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.6.7"],

Cell[BoxData[
    \(\[Pi]\^4\/90 - 1\/6\ PolyGamma[3, 2 + n]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.6.7"]
}, Open  ]],

Cell[TextData[{
  "Taking the difference between results for successive values of ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " gives back the original summand. "
}], "MathCaption",
  CellTags->{"S3.6.7", "7.10"}],

Cell[CellGroupData[{

Cell["FullSimplify[ % - (% /. n->n-1) ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.6.7"],

Cell[BoxData[
    \(1\/\((1 + n)\)\^4\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.6.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can do essentially all sums that are found in books of tables. Just as \
with indefinite integrals, indefinite sums of expressions involving simple \
functions tend to give answers that involve more complicated functions. \
Definite sums, like definite integrals, often, however, come out in terms of \
simpler functions. "
}], "Text",
  CellTags->{"S3.6.7", "7.11"}],

Cell["This indefinite sum gives a quite complicated result. ", "MathCaption",
  CellTags->{"S3.6.7", "7.12"}],

Cell[CellGroupData[{

Cell["Sum[Binomial[2k, k]/3^(2k), {k, 0, n}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.6.7"],

Cell[BoxData[
    \(3\/\@5 - \((\((9\/4)\)\^\(\(-1\) - n\)\ Gamma[
              3\/2 + n]\ Hypergeometric2F1[1, 3\/2 + n, 2 + n, 
              4\/9])\)/\((\@\[Pi]\ Gamma[2 + n])\)\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.6.7"]
}, Open  ]],

Cell["The definite form is much simpler. ", "MathCaption",
  CellTags->{"S3.6.7", "7.13"}],

Cell[CellGroupData[{

Cell["Sum[Binomial[2k, k]/3^(2k), {k, 0, Infinity}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.6.7"],

Cell[BoxData[
    \(3\/\@5\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.6.7"]
}, Open  ]],

Cell["Here is a slightly more complicated definite sum. ", "MathCaption",
  CellTags->{"S3.6.7", "7.14"}],

Cell[CellGroupData[{

Cell["Sum[PolyGamma[k]/k^2, {k, 1, Infinity}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.6.7"],

Cell[BoxData[
    \(1\/6\ \((\(-EulerGamma\)\ \[Pi]\^2 + 6\ Zeta[3])\)\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.6.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.6.8 Solving Recurrence Equations", "Subsection",
  CellTags->{"S3.6.8", "8.1"}],

Cell[TextData[{
  "If you represent the ",
  StyleBox["n", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " term in a sequence as ",
  StyleBox["a", "TI"],
  StyleBox["[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ", you can use a ",
  StyleBox["recurrence equation", "TI"],
  " to specify how it is related to other terms in the sequence.      "
}], "Text",
  CellTags->{"S3.6.8", "8.2"}],

Cell[TextData[{
  StyleBox["RSolve", "MR"],
  " takes recurrence equations and solves them to get explicit formulas for \
",
  StyleBox["a", "TI"],
  StyleBox["[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.6.8", "8.3"}],

Cell["This solves a simple recurrence equation. ", "MathCaption",
  CellTags->{"S3.6.8", "8.4"}],

Cell[CellGroupData[{

Cell["RSolve[{a[n] == 2 a[n-1], a[1] == 1}, a[n], n]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({{a[n] \[Rule] 2\^\(\(-1\) + n\)}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.6.8"]
}, Open  ]],

Cell[TextData[{
  "This takes the solution and makes an explicit table of the first ten ",
  StyleBox["a[n]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.8", "8.5"}],

Cell[CellGroupData[{

Cell["Table[a[n] /. First[%], {n, 10}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({1, 2, 4, 8, 16, 32, 64, 128, 256, 512}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.6.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["RSolve[", "MR"],
              StyleBox["eqn", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["solve a recurrence equation "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.6.8"],

Cell["Solving a recurrence equation. ", "Caption",
  CellTags->"S3.6.8"],

Cell["This solves a recurrence equation for a geometric series. ", \
"MathCaption",
  CellTags->{"S3.6.8", "8.6"}],

Cell[CellGroupData[{

Cell["RSolve[{a[n] == r a[n-1] + 1, a[1] == 1}, a[n], n]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({{a[n] \[Rule] \(\(-1\) + r\^n\)\/\(\(-1\) + r\)}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.6.8"]
}, Open  ]],

Cell["This gives the same result. ", "MathCaption",
  CellTags->{"S3.6.8", "8.7"}],

Cell[CellGroupData[{

Cell["RSolve[{a[n+1] == r a[n] + 1, a[1] == 1}, a[n], n]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({{a[n] \[Rule] \(\(-1\) + r\^n\)\/\(\(-1\) + r\)}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.6.8"]
}, Open  ]],

Cell["\<\
This gives an algebraic solution to the Fibonacci recurrence \
equation. \
\>", "MathCaption",
  CellTags->{"S3.6.8", "8.8"}],

Cell[CellGroupData[{

Cell["\<\
RSolve[{a[n] == a[n-1] + a[n-2], a[1] == a[2] == 1}, a[n], n]\
\>", \
"Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({{a[
            n] \[Rule] \(-\(\(\((\(-5\) + \@5)\)\ \((\(-\((1\/2 - \
\@5\/2)\)\^n\) + \((1\/2 + \@5\/2)\)\^n)\)\)\/\(5\ \((\(-1\) + \@5)\)\)\)\)}}\
\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.6.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["RSolve", "MR"],
  " can be thought of as a discrete analog of ",
  StyleBox["DSolve", "MR"],
  ". Many of the same functions generated in solving differential equations \
also appear in finding symbolic solutions to recurrence equations. "
}], "Text",
  CellTags->{"S3.6.8", "8.9"}],

Cell["\<\
This generates a gamma function, which generalizes the factorial. \
\
\>", "MathCaption",
  CellTags->{"S3.6.8", "8.10"}],

Cell[CellGroupData[{

Cell["RSolve[{a[n] == n a[n-1], a[1] == 1}, a[n], n]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({{a[n] \[Rule] Gamma[1 + n]}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.6.8"]
}, Open  ]],

Cell["\<\
This second\[Hyphen]order recurrence equation comes out in terms of \
Bessel functions. \
\>", "MathCaption",
  CellTags->{"S3.6.8", "8.11"}],

Cell[CellGroupData[{

Cell["\<\
RSolve[{a[n + 1] == n a[n] + a[n - 1], a[1] == 0, a[2] == 1}, a[n], \
n]\
\>", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({{a[
            n] \[Rule] \((BesselI[n, \(-2\)]\ BesselK[1, 2] + 
                BesselI[1, 2]\ BesselK[n, 2])\)/\((BesselI[2, 2]\ BesselK[1, 
                    2] + BesselI[1, 2]\ BesselK[2, 2])\)}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.6.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["RSolve", "MR"],
  " does not require you to specify explicit values for terms such as ",
  StyleBox["a[1]", "MR"],
  ". Like ",
  StyleBox["DSolve", "MR"],
  ", it automatically introduces undetermined constants ",
  StyleBox["C[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  " to give a general solution. "
}], "Text",
  CellTags->{"S3.6.8", "8.12"}],

Cell["\<\
This gives a general solution with one undetermined constant. \
\
\>", "MathCaption",
  CellTags->{"S3.6.8", "8.13"}],

Cell[CellGroupData[{

Cell["RSolve[a[n] == n a[n-1], a[n], n]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({{a[n] \[Rule] C[1]\ Gamma[1 + n]}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.6.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["RSolve", "MR"],
  " can solve equations that do not depend only linearly on ",
  StyleBox["a", "TI"],
  StyleBox["[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ". For nonlinear equations, however, there are sometimes several distinct \
solutions that must be given. Just as for differential equations, it is a \
difficult matter to find symbolic solutions to recurrence equations, and \
standard mathematical functions only cover a limited set of cases. "
}], "Text",
  CellTags->{"S3.6.8", "8.14"}],

Cell["\<\
Here is the general solution to a nonlinear recurrence equation. \
\
\>", "MathCaption",
  CellTags->{"S3.6.8", "8.15"}],

Cell[CellGroupData[{

Cell["RSolve[{a[n] == a[n + 1] a[n - 1]}, a[n], n]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({{a[
            n] \[Rule] \[ExponentialE]\^\(C[1]\ Cos[\(n\ \[Pi]\)\/3] + C[2]\ \
Sin[\(n\ \[Pi]\)\/3]\)}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.6.8"]
}, Open  ]],

Cell["This gives two distinct solutions. ", "MathCaption",
  CellTags->{"S3.6.8", "8.16"}],

Cell[CellGroupData[{

Cell["RSolve[a[n] == (a[n + 1] a[n - 1])^2, a[n], n]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({{a[
            n] \[Rule] \[ExponentialE]\^\(C[2]\ Cos[n\ ArcTan[\@15]] + C[1]\ \
Sin[n\ ArcTan[\@15]]\)}, {a[
            n] \[Rule] \[ExponentialE]\^\(\(2\ \[ImaginaryI]\ \[Pi]\)\/3 + \
C[2]\ Cos[n\ ArcTan[\@15]] + C[1]\ Sin[n\ ArcTan[\@15]]\)}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.6.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["RSolve", "MR"],
  " can solve not only ordinary ",
  StyleBox["difference equations", "TI"],
  " in which the arguments of ",
  StyleBox["a", "TI"],
  " differ by integers, but also ",
  StyleBox["q\[Hyphen]difference equations", "TI"],
  " in which the arguments of ",
  StyleBox["a", "TI"],
  " are related by multiplicative factors.    "
}], "Text",
  CellTags->{"S3.6.8", "8.17"}],

Cell[TextData[{
  "This solves the ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]difference analog of the factorial equation. "
}], "MathCaption",
  CellTags->{"S3.6.8", "8.18"}],

Cell[CellGroupData[{

Cell["RSolve[a[q n] == n a[n], a[n], n]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({{a[n] \[Rule] 
          n\^\(1\/2\ \((\(-1\) + Log[n]\/Log[q])\)\)\ C[1]}}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.6.8"]
}, Open  ]],

Cell[TextData[{
  "Here is a second\[Hyphen]order ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]difference equation. "
}], "MathCaption",
  CellTags->{"S3.6.8", "8.19"}],

Cell[CellGroupData[{

Cell["RSolve[a[n] == a[q n] + a[n/q], a[n], n]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({{a[n] \[Rule] 
          C[1]\ Cos[\(\[Pi]\ Log[n]\)\/\(3\ Log[q]\)] + 
            C[2]\ Sin[\(\[Pi]\ Log[n]\)\/\(3\ Log[q]\)]}}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.6.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["RSolve[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "[",
              StyleBox["n", "TI"],
              StyleBox["],", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["solve a coupled system of recurrence equations "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.6.8"],

Cell["Solving systems of recurrence equations. ", "Caption",
  CellTags->"S3.6.8"],

Cell["This solves a system of two coupled recurrence equations. ", \
"MathCaption",
  CellTags->{"S3.6.8", "8.20"}],

Cell[CellGroupData[{

Cell["\<\
RSolve[{a[n] == b[n - 1] + n, b[n] == a[n - 1] - n, a[1] == b[1] == \
1}, {a[n], b[n]}, n]\
\>", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({{a[n] \[Rule] 
          1\/4\ \((4 + 3\ \((\(-1\))\)\^n + \((\(-1\))\)\^\(2\ n\) + 
                2\ \((\(-1\))\)\^\(2\ n\)\ n)\), 
        b[n] \[Rule] 
          1\/4\ \((4 - 3\ \((\(-1\))\)\^n - \((\(-1\))\)\^\(2\ n\) - 
                2\ \((\(-1\))\)\^\(2\ n\)\ n)\)}}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.6.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["RSolve[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["],", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell["solve partial recurrence equations "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.6.8"],

Cell["Solving partial recurrence equations. ", "Caption",
  CellTags->"S3.6.8"],

Cell["\<\
Just as one can set up partial differential equations that involve \
functions of several variables, so one can also set up partial recurrence \
equations that involve multidimensional sequences. Just as in the \
differential equations case, general solutions to partial recurrence \
equations can involve undetermined functions.   \
\>", "Text",
  CellTags->{"S3.6.8", "8.21"}],

Cell["\<\
This gives the general solution to a simple partial recurrence \
equation. \
\>", "MathCaption",
  CellTags->{"S3.6.8", "8.22"}],

Cell[CellGroupData[{

Cell["RSolve[a[i + 1, j + 1] == i j a[i, j], a[i, j], {i, j}]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.6.8"],

Cell[BoxData[
    \({{a[i, 
            j] \[Rule] \(Gamma[i]\ Gamma[j]\ \(C[1]\)[i - j]\)\/Gamma[1 - i + \
j]}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.6.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.6.9 Finding Limits", "Subsection",
  CellTags->{"S3.6.9", "9.1"}],

Cell[TextData[{
  "In doing many kinds of calculations, you need to evaluate expressions when \
variables take on particular values. In many cases, you can do this simply by \
applying transformation rules for the variables using the ",
  StyleBox["/.", "MR"],
  " operator. "
}], "Text",
  CellTags->{"S3.6.9", "9.2"}],

Cell[TextData[{
  "You can get the value of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"cos", 
          RowBox[{"(", 
            SuperscriptBox[
              StyleBox["x",
                "TI"], "2"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " at 0 just by explicitly replacing ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " with 0, and then evaluating the result. "
}], "MathCaption",
  CellTags->{"S3.6.9", "9.3"}],

Cell[CellGroupData[{

Cell["Cos[x^2] /. x -> 0", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.6.9"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.6.9"]
}, Open  ]],

Cell["In some cases, however, you have to be more careful. ", "Text",
  CellTags->{"S3.6.9", "9.4"}],

Cell[TextData[{
  "Consider, for example, finding the value of the expression ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          RowBox[{"sin", 
            RowBox[{"(", 
              StyleBox["x",
                "TI"], ")"}]}], 
          StyleBox["x",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " when ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". If you simply replace ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " in this expression, you get the indeterminate result ",
  Cell[BoxData[
      \(TraditionalForm\`0\/0\)], "InlineFormula"],
  ". To find the correct value of ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          RowBox[{"sin", 
            RowBox[{"(", 
              StyleBox["x",
                "TI"], ")"}]}], 
          StyleBox["x",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " when ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", you need to take the ",
  StyleBox["limit", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.6.9", "9.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Limit[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the limit of ",
              StyleBox["expr", "TI"],
              " when ",
              StyleBox["x", "TI"],
              " approaches ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.6.9"],

Cell["Finding limits. ", "Caption",
  CellTags->"S3.6.9"],

Cell[TextData[{
  "This gives the correct value for the limit of ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          RowBox[{"sin", 
            RowBox[{"(", 
              StyleBox["x",
                "TI"], ")"}]}], 
          StyleBox["x",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "\[Rule]", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.9", "9.6"}],

Cell[CellGroupData[{

Cell["Limit[ Sin[x]/x, x -> 0 ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.6.9"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.6.9"]
}, Open  ]],

Cell["No finite limit exists in this case. ", "MathCaption",
  CellTags->{"S3.6.9", "9.7"}],

Cell[CellGroupData[{

Cell["Limit[ Sin[x]/x^2, x -> 0 ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.6.9"],

Cell[BoxData[
    \(\[Infinity]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.6.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Limit", "MR"],
  " can find this limit, even though you cannot get an ordinary power series \
for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "log", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.9", "9.8"}],

Cell[CellGroupData[{

Cell["Limit[ x Log[x], x -> 0 ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.6.9"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.6.9"]
}, Open  ]],

Cell["The same is true here. ", "MathCaption",
  CellTags->{"S3.6.9", "9.9"}],

Cell[CellGroupData[{

Cell["Limit[ ( 1 + 2 x ) ^ (1/x), x -> 0 ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.6.9"],

Cell[BoxData[
    \(\[ExponentialE]\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.6.9"]
}, Open  ]],

Cell[TextData[{
  "The value of ",
  StyleBox["Sign[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " at ",
  StyleBox["x", "TI"],
  StyleBox["=0", "MR"],
  " is ",
  StyleBox["0", "MR"],
  ".  "
}], "MathCaption",
  CellTags->{"S3.6.9", "9.10"}],

Cell[CellGroupData[{

Cell["Sign[0]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.6.9"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.6.9"]
}, Open  ]],

Cell[TextData[{
  "Its ",
  StyleBox["limit", "TI"],
  ", however, is ",
  StyleBox["1", "MR"],
  ". The limit is by default taken from above. "
}], "MathCaption",
  CellTags->{"S3.6.9", "9.11"}],

Cell[CellGroupData[{

Cell["Limit[Sign[x], x -> 0]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.6.9"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.6.9"]
}, Open  ]],

Cell[TextData[{
  "Not all functions have definite limits at particular points. For example, \
the function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            RowBox[{"1", "/", 
              StyleBox["x",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " oscillates infinitely often near ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", so it has no definite limit there. Nevertheless, at least so long as ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " remains real, the values of the function near ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  " always lie between ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " and 1. ",
  StyleBox["Limit", "MR"],
  " represents values with bounded variation using ",
  StyleBox["Interval", "MR"],
  " objects. In general, ",
  StyleBox["Interval[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  " represents an uncertain value which lies somewhere in the interval ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.6.9", "9.12"}],

Cell[TextData[{
  StyleBox["Limit", "MR"],
  " returns an ",
  StyleBox["Interval", "MR"],
  " object, representing the range of possible values of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            RowBox[{"1", "/", 
              StyleBox["x",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " near its essential singularity at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.9", "9.13"}],

Cell[CellGroupData[{

Cell["Limit[ Sin[1/x], x -> 0 ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.6.9"],

Cell[BoxData[
    \(Interval[{\(-1\), 1}]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.6.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can do arithmetic with ",
  StyleBox["Interval", "MR"],
  " objects. "
}], "MathCaption",
  CellTags->{"S3.6.9", "9.14"}],

Cell[CellGroupData[{

Cell["(1 + %)^3", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.6.9"],

Cell[BoxData[
    \(Interval[{0, 8}]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.6.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " represents this limit symbolically in terms of an ",
  StyleBox["Interval", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S3.6.9", "9.15"}],

Cell[CellGroupData[{

Cell["Limit[ Exp[Sin[x]], x -> Infinity ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.6.9"],

Cell[BoxData[
    \(Interval[{1\/\[ExponentialE], \[ExponentialE]}]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.6.9"]
}, Open  ]],

Cell[TextData[{
  "Some functions may have different limits at particular points, depending \
on the direction from which you approach those points. You can use the ",
  StyleBox["Direction", "MR"],
  " option for ",
  StyleBox["Limit", "MR"],
  " to specify the direction you want. "
}], "Text",
  CellTags->{"S3.6.9", "9.16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Limit[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Direction", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["1]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the limit as ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " approaches ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              " from below "
            }]]},
          {Cell[TextData[{
              StyleBox["Limit[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Direction", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["-1]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the limit as ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " approaches ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              " from above "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.6.9"],

Cell["Directional limits. ", "Caption",
  CellTags->"S3.6.9"],

Cell[TextData[{
  "The function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " has a different limiting value at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", depending on whether you approach from above or below. "
}], "MathCaption",
  CellTags->{"S3.6.9", "9.17"}],

Cell[CellGroupData[{

Cell["Plot[1/x, {x, -1, 1}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.6.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.312295 0.00311523 [
[.02381 .29979 -6 -9 ]
[.02381 .29979 6 0 ]
[.2619 .29979 -12 -9 ]
[.2619 .29979 12 0 ]
[.7381 .29979 -9 -9 ]
[.7381 .29979 9 0 ]
[.97619 .29979 -3 -9 ]
[.97619 .29979 3 0 ]
[.4875 .00077 -24 -4.5 ]
[.4875 .00077 0 4.5 ]
[.4875 .07865 -18 -4.5 ]
[.4875 .07865 0 4.5 ]
[.4875 .15653 -18 -4.5 ]
[.4875 .15653 0 4.5 ]
[.4875 .23441 -18 -4.5 ]
[.4875 .23441 0 4.5 ]
[.4875 .39018 -12 -4.5 ]
[.4875 .39018 0 4.5 ]
[.4875 .46806 -12 -4.5 ]
[.4875 .46806 0 4.5 ]
[.4875 .54594 -12 -4.5 ]
[.4875 .54594 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .31229 m
.02381 .31854 L
s
[(-1)] .02381 .29979 0 1 Mshowa
.2619 .31229 m
.2619 .31854 L
s
[(-0.5)] .2619 .29979 0 1 Mshowa
.7381 .31229 m
.7381 .31854 L
s
[(0.5)] .7381 .29979 0 1 Mshowa
.97619 .31229 m
.97619 .31854 L
s
[(1)] .97619 .29979 0 1 Mshowa
.125 Mabswid
.07143 .31229 m
.07143 .31604 L
s
.11905 .31229 m
.11905 .31604 L
s
.16667 .31229 m
.16667 .31604 L
s
.21429 .31229 m
.21429 .31604 L
s
.30952 .31229 m
.30952 .31604 L
s
.35714 .31229 m
.35714 .31604 L
s
.40476 .31229 m
.40476 .31604 L
s
.45238 .31229 m
.45238 .31604 L
s
.54762 .31229 m
.54762 .31604 L
s
.59524 .31229 m
.59524 .31604 L
s
.64286 .31229 m
.64286 .31604 L
s
.69048 .31229 m
.69048 .31604 L
s
.78571 .31229 m
.78571 .31604 L
s
.83333 .31229 m
.83333 .31604 L
s
.88095 .31229 m
.88095 .31604 L
s
.92857 .31229 m
.92857 .31604 L
s
.25 Mabswid
0 .31229 m
1 .31229 L
s
.5 .00077 m
.50625 .00077 L
s
[(-100)] .4875 .00077 1 0 Mshowa
.5 .07865 m
.50625 .07865 L
s
[(-75)] .4875 .07865 1 0 Mshowa
.5 .15653 m
.50625 .15653 L
s
[(-50)] .4875 .15653 1 0 Mshowa
.5 .23441 m
.50625 .23441 L
s
[(-25)] .4875 .23441 1 0 Mshowa
.5 .39018 m
.50625 .39018 L
s
[(25)] .4875 .39018 1 0 Mshowa
.5 .46806 m
.50625 .46806 L
s
[(50)] .4875 .46806 1 0 Mshowa
.5 .54594 m
.50625 .54594 L
s
[(75)] .4875 .54594 1 0 Mshowa
.125 Mabswid
.5 .01635 m
.50375 .01635 L
s
.5 .03192 m
.50375 .03192 L
s
.5 .0475 m
.50375 .0475 L
s
.5 .06308 m
.50375 .06308 L
s
.5 .09423 m
.50375 .09423 L
s
.5 .1098 m
.50375 .1098 L
s
.5 .12538 m
.50375 .12538 L
s
.5 .14096 m
.50375 .14096 L
s
.5 .17211 m
.50375 .17211 L
s
.5 .18769 m
.50375 .18769 L
s
.5 .20326 m
.50375 .20326 L
s
.5 .21884 m
.50375 .21884 L
s
.5 .24999 m
.50375 .24999 L
s
.5 .26557 m
.50375 .26557 L
s
.5 .28114 m
.50375 .28114 L
s
.5 .29672 m
.50375 .29672 L
s
.5 .32787 m
.50375 .32787 L
s
.5 .34345 m
.50375 .34345 L
s
.5 .35902 m
.50375 .35902 L
s
.5 .3746 m
.50375 .3746 L
s
.5 .40575 m
.50375 .40575 L
s
.5 .42133 m
.50375 .42133 L
s
.5 .4369 m
.50375 .4369 L
s
.5 .45248 m
.50375 .45248 L
s
.5 .48363 m
.50375 .48363 L
s
.5 .49921 m
.50375 .49921 L
s
.5 .51478 m
.50375 .51478 L
s
.5 .53036 m
.50375 .53036 L
s
.5 .56151 m
.50375 .56151 L
s
.5 .57709 m
.50375 .57709 L
s
.5 .59267 m
.50375 .59267 L
s
.5 .60824 m
.50375 .60824 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30918 m
.06244 .3089 L
.10458 .30854 L
.14415 .30813 L
.18221 .30763 L
.22272 .30694 L
.26171 .30607 L
.28158 .3055 L
.30316 .30476 L
.32216 .30395 L
.34309 .30284 L
.36292 .30147 L
.38395 .29951 L
.40336 .29694 L
.41426 .29499 L
.42424 .29271 L
.43408 .28979 L
.44322 .28617 L
.45325 .28056 L
.45886 .27623 L
.46395 .27115 L
.46882 .26471 L
.47149 .26027 L
.47397 .2553 L
.47837 .24372 L
.4807 .23544 L
.48319 .22402 L
.48587 .20729 L
.48739 .19469 L
.48879 .18 L
.49001 .16383 L
.49136 .14068 L
.49203 .12609 L
.49276 .1073 L
.49408 .06151 L
s
.49408 .06151 m
.49524 0 L
s
.49973 0 m
.49989 .61803 L
s
.50492 .61803 m
.50525 .59506 L
.50637 .54511 L
.50767 .50568 L
.5089 .4789 L
.51004 .46005 L
.51109 .44602 L
.51348 .42235 L
.51484 .41224 L
.51613 .40429 L
.51852 .39239 L
.5211 .38259 L
.52389 .37439 L
.52923 .36305 L
.53191 .35878 L
.53486 .35485 L
.53969 .34967 L
.54493 .34531 L
.55019 .34185 L
.55516 .33919 L
.56448 .3353 L
.57536 .33198 L
.58541 .32966 L
.60411 .32654 L
.61475 .32522 L
.62473 .32419 L
.64495 .32253 L
.66347 .32137 L
.68403 .32036 L
.70314 .3196 L
.7413 .31844 L
.7804 .31759 L
.82195 .3169 L
.86199 .31639 L
.9005 .316 L
.94148 .31565 L
.97619 .31541 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.6.9"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.6.9"]
}, Open  ]],

Cell[TextData[{
  "Approaching from below gives a limiting value of ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.9", "9.18"}],

Cell[CellGroupData[{

Cell["Limit[ 1/x, x -> 0, Direction -> 1 ]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.6.9"],

Cell[BoxData[
    \(\(-\[Infinity]\)\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.6.9"]
}, Open  ]],

Cell[TextData[{
  "Approaching from above gives a limiting value of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.6.9", "9.19"}],

Cell[CellGroupData[{

Cell["Limit[ 1/x, x -> 0, Direction -> -1 ]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.6.9"],

Cell[BoxData[
    \(\[Infinity]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.6.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Limit", "MR"],
  " makes no assumptions about functions like ",
  StyleBox["f[x]", "MR"],
  " about which it does not have definite knowledge. As a result, ",
  StyleBox["Limit", "MR"],
  " remains unevaluated in most cases involving symbolic functions. "
}], "Text",
  CellTags->{"S3.6.9", "9.20"}],

Cell[TextData[{
  StyleBox["Limit", "MR"],
  " has no definite knowledge about ",
  StyleBox["f", "MR"],
  ", so it leaves this limit unevaluated. "
}], "MathCaption",
  CellTags->{"S3.6.9", "9.21"}],

Cell[CellGroupData[{

Cell["Limit[ x f[x], x -> 0 ]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.6.9"],

Cell[TextData[{
  "Limit[x\[ThinSpace]f[x], x\[ThinSpace]",
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
  "\[ThinSpace]0]"
}], "Output",
  CellLabel->"Out[14]=",
  CellTags->"S3.6.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.6.10 Residues", "Subsection",
  CellTags->{"S3.6.10", "10.1"}],

Cell[TextData[{
  StyleBox["Limit[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["->", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  StyleBox["]", "MR"],
  " tells you what the value of ",
  StyleBox["expr", "TI"],
  " is when ",
  StyleBox["x", "TI"],
  " tends to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  ". When this value is infinite, it is often useful instead to know the ",
  StyleBox["residue", "TI"],
  " of ",
  StyleBox["expr", "TI"],
  " when ",
  StyleBox["x", "TI"],
  " equals ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  ". The residue is given by the coefficient of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], "-", 
              SubscriptBox[
                StyleBox["x",
                  "TI"], "0"]}], ")"}], \(-1\)], TraditionalForm]], 
    "InlineFormula"],
  " in the power series expansion of ",
  StyleBox["expr", "TI"],
  " about the point ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.6.10", "10.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Residue[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the residue of ",
              StyleBox["expr", "TI"],
              " when ",
              StyleBox["x", "TI"],
              " equals ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.6.10"],

Cell["Computing residues. ", "Caption",
  CellTags->"S3.6.10"],

Cell["The residue here is equal to 1. ", "MathCaption",
  CellTags->{"S3.6.10", "10.3"}],

Cell[CellGroupData[{

Cell["Residue[1/x, {x, 0}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.6.10"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.6.10"]
}, Open  ]],

Cell["The residue here is zero. ", "MathCaption",
  CellTags->{"S3.6.10", "10.4"}],

Cell[CellGroupData[{

Cell["Residue[1/x^2, {x, 0}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.6.10"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.6.10"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S3.6.0"->{
    Cell[1776, 53, 130, 4, 65, "Section",
      CellTags->{"S3.6.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 130, 4, 65, "Section",
      CellTags->{"S3.6.0", "0.1"}]},
  "S3.6.1"->{
    Cell[1931, 61, 89, 1, 70, "Subsection",
      CellTags->{"S3.6.1", "1.1"}],
    Cell[2023, 64, 3618, 104, 70, "DefinitionBox",
      CellTags->"S3.6.1"],
    Cell[5644, 170, 78, 1, 70, "Caption",
      CellTags->"S3.6.1"],
    Cell[5725, 173, 627, 22, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.2"}],
    Cell[6377, 199, 91, 2, 70, "Input",
      CellTags->"S3.6.1"],
    Cell[6471, 203, 456, 14, 70, "Output",
      CellTags->"S3.6.1"],
    Cell[6942, 220, 445, 16, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.3"}],
    Cell[7412, 240, 91, 2, 70, "Input",
      CellTags->"S3.6.1"],
    Cell[7506, 244, 677, 19, 70, "Output",
      CellTags->"S3.6.1"],
    Cell[8198, 266, 235, 6, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.4"}],
    Cell[8458, 276, 89, 2, 70, "Input",
      CellTags->"S3.6.1"],
    Cell[8550, 280, 1083, 33, 70, "Output",
      CellTags->"S3.6.1"],
    Cell[9648, 316, 189, 5, 70, "Text",
      CellTags->{"S3.6.1", "1.5"}],
    Cell[9840, 323, 2431, 83, 70, "Text",
      CellTags->{"S3.6.1", "1.6"}],
    Cell[12274, 408, 235, 5, 70, "Text",
      CellTags->{"S3.6.1", "1.7"}],
    Cell[12512, 415, 157, 5, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.8"}],
    Cell[12694, 424, 95, 2, 70, "Input",
      CellTags->"S3.6.1"],
    Cell[12792, 428, 554, 15, 70, "Output",
      CellTags->"S3.6.1"],
    Cell[13361, 446, 155, 5, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.9"}],
    Cell[13541, 455, 97, 2, 70, "Input",
      CellTags->"S3.6.1"],
    Cell[13641, 459, 469, 14, 70, "Output",
      CellTags->"S3.6.1"],
    Cell[14125, 476, 156, 4, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.10"}],
    Cell[14306, 484, 99, 2, 70, "Input",
      CellTags->"S3.6.1"],
    Cell[14408, 488, 453, 15, 70, "Output",
      CellTags->"S3.6.1"],
    Cell[14876, 506, 221, 6, 70, "Text",
      CellTags->{"S3.6.1", "1.11"}],
    Cell[15100, 514, 542, 18, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.12"}],
    Cell[15667, 536, 93, 2, 70, "Input",
      CellTags->"S3.6.1"],
    Cell[15763, 540, 380, 6, 70, "Message",
      CellTags->"S3.6.1"],
    Cell[16146, 548, 106, 3, 70, "Output",
      CellTags->"S3.6.1"],
    Cell[16267, 554, 537, 18, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.13"}],
    Cell[16829, 576, 100, 2, 70, "Input",
      CellTags->"S3.6.1"],
    Cell[16932, 580, 502, 15, 70, "Output",
      CellTags->"S3.6.1"],
    Cell[17449, 598, 246, 6, 70, "Text",
      CellTags->{"S3.6.1", "1.14"}],
    Cell[17698, 606, 398, 8, 70, "Text",
      CellTags->{"S3.6.1", "1.15"}],
    Cell[18099, 616, 991, 21, 70, "Text",
      CellTags->{"S3.6.1", "1.16"}],
    Cell[19093, 639, 347, 11, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.17"}],
    Cell[19465, 654, 95, 2, 70, "Input",
      CellTags->"S3.6.1"],
    Cell[19563, 658, 396, 11, 70, "Output",
      CellTags->"S3.6.1"],
    Cell[19974, 672, 474, 15, 70, "Text",
      CellTags->{"S3.6.1", "1.18"}],
    Cell[20451, 689, 206, 9, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.19"}],
    Cell[20682, 702, 96, 2, 70, "Input",
      CellTags->"S3.6.1"],
    Cell[20781, 706, 787, 25, 70, "Output",
      CellTags->"S3.6.1"],
    Cell[21583, 734, 169, 6, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.20"}],
    Cell[21777, 744, 98, 2, 70, "Input",
      CellTags->"S3.6.1"],
    Cell[21878, 748, 1981, 60, 70, "Output",
      CellTags->"S3.6.1"],
    Cell[23874, 811, 370, 12, 70, "Text",
      CellTags->{"S3.6.1", "1.21"}],
    Cell[24247, 825, 308, 9, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.22"}],
    Cell[24580, 838, 103, 2, 70, "Input",
      CellTags->"S3.6.1"],
    Cell[24686, 842, 1590, 43, 70, "Output",
      CellTags->"S3.6.1"]},
  "1.1"->{
    Cell[1931, 61, 89, 1, 70, "Subsection",
      CellTags->{"S3.6.1", "1.1"}]},
  "1.2"->{
    Cell[5725, 173, 627, 22, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.2"}]},
  "1.3"->{
    Cell[6942, 220, 445, 16, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.3"}]},
  "1.4"->{
    Cell[8198, 266, 235, 6, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.4"}]},
  "1.5"->{
    Cell[9648, 316, 189, 5, 70, "Text",
      CellTags->{"S3.6.1", "1.5"}]},
  "1.6"->{
    Cell[9840, 323, 2431, 83, 70, "Text",
      CellTags->{"S3.6.1", "1.6"}]},
  "1.7"->{
    Cell[12274, 408, 235, 5, 70, "Text",
      CellTags->{"S3.6.1", "1.7"}]},
  "1.8"->{
    Cell[12512, 415, 157, 5, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.8"}]},
  "1.9"->{
    Cell[13361, 446, 155, 5, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.9"}]},
  "1.10"->{
    Cell[14125, 476, 156, 4, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.10"}]},
  "1.11"->{
    Cell[14876, 506, 221, 6, 70, "Text",
      CellTags->{"S3.6.1", "1.11"}]},
  "1.12"->{
    Cell[15100, 514, 542, 18, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.12"}]},
  "1.13"->{
    Cell[16267, 554, 537, 18, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.13"}]},
  "1.14"->{
    Cell[17449, 598, 246, 6, 70, "Text",
      CellTags->{"S3.6.1", "1.14"}]},
  "1.15"->{
    Cell[17698, 606, 398, 8, 70, "Text",
      CellTags->{"S3.6.1", "1.15"}]},
  "1.16"->{
    Cell[18099, 616, 991, 21, 70, "Text",
      CellTags->{"S3.6.1", "1.16"}]},
  "1.17"->{
    Cell[19093, 639, 347, 11, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.17"}]},
  "1.18"->{
    Cell[19974, 672, 474, 15, 70, "Text",
      CellTags->{"S3.6.1", "1.18"}]},
  "1.19"->{
    Cell[20451, 689, 206, 9, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.19"}]},
  "1.20"->{
    Cell[21583, 734, 169, 6, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.20"}]},
  "1.21"->{
    Cell[23874, 811, 370, 12, 70, "Text",
      CellTags->{"S3.6.1", "1.21"}]},
  "1.22"->{
    Cell[24247, 825, 308, 9, 70, "MathCaption",
      CellTags->{"S3.6.1", "1.22"}]},
  "S3.6.2"->{
    Cell[26325, 891, 109, 1, 70, "Subsection",
      CellTags->{"S3.6.2", "2.1"}],
    Cell[26437, 894, 187, 7, 70, "Text",
      CellTags->{"S3.6.2", "2.2"}],
    Cell[26627, 903, 185, 5, 70, "MathCaption",
      CellTags->{"S3.6.2", "2.3"}],
    Cell[26837, 912, 89, 2, 70, "Input",
      CellTags->"S3.6.2"],
    Cell[26929, 916, 390, 11, 70, "Output",
      CellTags->"S3.6.2"],
    Cell[27334, 930, 164, 5, 70, "MathCaption",
      CellTags->{"S3.6.2", "2.4"}],
    Cell[27523, 939, 76, 2, 70, "Input",
      CellTags->"S3.6.2"],
    Cell[27602, 943, 124, 2, 70, "Output",
      CellTags->"S3.6.2"],
    Cell[27741, 948, 438, 11, 70, "Text",
      CellTags->{"S3.6.2", "2.5"}],
    Cell[28182, 961, 1787, 61, 70, "Text",
      CellTags->{"S3.6.2", "2.6"}],
    Cell[29972, 1024, 292, 9, 70, "Text",
      CellTags->{"S3.6.2", "2.7"}],
    Cell[30267, 1035, 206, 7, 70, "MathCaption",
      CellTags->{"S3.6.2", "2.8"}],
    Cell[30498, 1046, 85, 2, 70, "Input",
      CellTags->"S3.6.2"],
    Cell[30586, 1050, 384, 11, 70, "Output",
      CellTags->"S3.6.2"]},
  "2.1"->{
    Cell[26325, 891, 109, 1, 70, "Subsection",
      CellTags->{"S3.6.2", "2.1"}]},
  "2.2"->{
    Cell[26437, 894, 187, 7, 70, "Text",
      CellTags->{"S3.6.2", "2.2"}]},
  "2.3"->{
    Cell[26627, 903, 185, 5, 70, "MathCaption",
      CellTags->{"S3.6.2", "2.3"}]},
  "2.4"->{
    Cell[27334, 930, 164, 5, 70, "MathCaption",
      CellTags->{"S3.6.2", "2.4"}]},
  "2.5"->{
    Cell[27741, 948, 438, 11, 70, "Text",
      CellTags->{"S3.6.2", "2.5"}]},
  "2.6"->{
    Cell[28182, 961, 1787, 61, 70, "Text",
      CellTags->{"S3.6.2", "2.6"}]},
  "2.7"->{
    Cell[29972, 1024, 292, 9, 70, "Text",
      CellTags->{"S3.6.2", "2.7"}]},
  "2.8"->{
    Cell[30267, 1035, 206, 7, 70, "MathCaption",
      CellTags->{"S3.6.2", "2.8"}]},
  "S3.6.3"->{
    Cell[31019, 1067, 85, 1, 70, "Subsection",
      CellTags->{"S3.6.3", "3.1"}],
    Cell[31107, 1070, 297, 7, 70, "Text",
      CellTags->{"S3.6.3", "3.2"}],
    Cell[31407, 1079, 236, 8, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.3"}],
    Cell[31668, 1091, 91, 2, 70, "Input",
      CellTags->"S3.6.3"],
    Cell[31762, 1095, 456, 14, 70, "Output",
      CellTags->"S3.6.3"],
    Cell[32233, 1112, 159, 4, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.4"}],
    Cell[32417, 1120, 67, 2, 70, "Input",
      CellTags->"S3.6.3"],
    Cell[32487, 1124, 450, 13, 70, "Output",
      CellTags->"S3.6.3"],
    Cell[32952, 1140, 311, 11, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.5"}],
    Cell[33288, 1155, 70, 2, 70, "Input",
      CellTags->"S3.6.3"],
    Cell[33361, 1159, 298, 9, 70, "Output",
      CellTags->"S3.6.3"],
    Cell[33674, 1171, 379, 7, 70, "Text",
      CellTags->{"S3.6.3", "3.6"}],
    Cell[34056, 1180, 261, 9, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.7"}],
    Cell[34342, 1193, 92, 2, 70, "Input",
      CellTags->"S3.6.3"],
    Cell[34437, 1197, 577, 16, 70, "Output",
      CellTags->"S3.6.3"],
    Cell[35029, 1216, 276, 9, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.8"}],
    Cell[35330, 1229, 75, 2, 70, "Input",
      CellTags->"S3.6.3"],
    Cell[35408, 1233, 515, 14, 70, "Output",
      CellTags->"S3.6.3"],
    Cell[35938, 1250, 150, 4, 70, "Text",
      CellTags->{"S3.6.3", "3.9"}],
    Cell[36091, 1256, 278, 10, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.10"}],
    Cell[36394, 1270, 90, 2, 70, "Input",
      CellTags->"S3.6.3"],
    Cell[36487, 1274, 537, 15, 70, "Output",
      CellTags->"S3.6.3"],
    Cell[37039, 1292, 141, 5, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.11"}],
    Cell[37205, 1301, 71, 2, 70, "Input",
      CellTags->"S3.6.3"],
    Cell[37279, 1305, 505, 14, 70, "Output",
      CellTags->"S3.6.3"],
    Cell[37799, 1322, 167, 5, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.12"}],
    Cell[37991, 1331, 79, 2, 70, "Input",
      CellTags->"S3.6.3"],
    Cell[38073, 1335, 537, 15, 70, "Output",
      CellTags->"S3.6.3"],
    Cell[38625, 1353, 315, 7, 70, "Text",
      CellTags->{"S3.6.3", "3.13"}],
    Cell[38943, 1362, 154, 5, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.14"}],
    Cell[39122, 1371, 93, 2, 70, "Input",
      CellTags->"S3.6.3"],
    Cell[39218, 1375, 456, 14, 70, "Output",
      CellTags->"S3.6.3"],
    Cell[39689, 1392, 147, 5, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.15"}],
    Cell[39861, 1401, 72, 2, 70, "Input",
      CellTags->"S3.6.3"],
    Cell[39936, 1405, 464, 14, 70, "Output",
      CellTags->"S3.6.3"],
    Cell[40415, 1422, 285, 9, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.16"}],
    Cell[40725, 1435, 75, 2, 70, "Input",
      CellTags->"S3.6.3"],
    Cell[40803, 1439, 419, 12, 70, "Output",
      CellTags->"S3.6.3"],
    Cell[41237, 1454, 262, 8, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.17"}],
    Cell[41524, 1466, 76, 2, 70, "Input",
      CellTags->"S3.6.3"],
    Cell[41603, 1470, 235, 5, 70, "Output",
      CellTags->"S3.6.3"],
    Cell[41853, 1478, 333, 7, 70, "Text",
      CellTags->{"S3.6.3", "3.18"}],
    Cell[42189, 1487, 233, 6, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.19"}],
    Cell[42447, 1497, 97, 2, 70, "Input",
      CellTags->"S3.6.3"],
    Cell[42547, 1501, 443, 12, 70, "Output",
      CellTags->"S3.6.3"]},
  "3.1"->{
    Cell[31019, 1067, 85, 1, 70, "Subsection",
      CellTags->{"S3.6.3", "3.1"}]},
  "3.2"->{
    Cell[31107, 1070, 297, 7, 70, "Text",
      CellTags->{"S3.6.3", "3.2"}]},
  "3.3"->{
    Cell[31407, 1079, 236, 8, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.3"}]},
  "3.4"->{
    Cell[32233, 1112, 159, 4, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.4"}]},
  "3.5"->{
    Cell[32952, 1140, 311, 11, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.5"}]},
  "3.6"->{
    Cell[33674, 1171, 379, 7, 70, "Text",
      CellTags->{"S3.6.3", "3.6"}]},
  "3.7"->{
    Cell[34056, 1180, 261, 9, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.7"}]},
  "3.8"->{
    Cell[35029, 1216, 276, 9, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.8"}]},
  "3.9"->{
    Cell[35938, 1250, 150, 4, 70, "Text",
      CellTags->{"S3.6.3", "3.9"}]},
  "3.10"->{
    Cell[36091, 1256, 278, 10, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.10"}]},
  "3.11"->{
    Cell[37039, 1292, 141, 5, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.11"}]},
  "3.12"->{
    Cell[37799, 1322, 167, 5, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.12"}]},
  "3.13"->{
    Cell[38625, 1353, 315, 7, 70, "Text",
      CellTags->{"S3.6.3", "3.13"}]},
  "3.14"->{
    Cell[38943, 1362, 154, 5, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.14"}]},
  "3.15"->{
    Cell[39689, 1392, 147, 5, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.15"}]},
  "3.16"->{
    Cell[40415, 1422, 285, 9, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.16"}]},
  "3.17"->{
    Cell[41237, 1454, 262, 8, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.17"}]},
  "3.18"->{
    Cell[41853, 1478, 333, 7, 70, "Text",
      CellTags->{"S3.6.3", "3.18"}]},
  "3.19"->{
    Cell[42189, 1487, 233, 6, 70, "MathCaption",
      CellTags->{"S3.6.3", "3.19"}]},
  "S3.6.4"->{
    Cell[43039, 1519, 126, 4, 70, "Subsection",
      CellTags->{"S3.6.4", "4.1"}],
    Cell[43168, 1525, 251, 6, 70, "Text",
      CellTags->{"S3.6.4", "4.2"}],
    Cell[43422, 1533, 1252, 36, 70, "DefinitionBox",
      CellTags->"S3.6.4"],
    Cell[44677, 1571, 84, 1, 70, "Caption",
      CellTags->"S3.6.4"],
    Cell[44764, 1574, 436, 16, 70, "MathCaption",
      CellTags->{"S3.6.4", "4.3"}],
    Cell[45225, 1594, 89, 2, 70, "Input",
      CellTags->"S3.6.4"],
    Cell[45317, 1598, 504, 15, 70, "Output",
      CellTags->"S3.6.4"],
    Cell[45836, 1616, 616, 22, 70, "MathCaption",
      CellTags->{"S3.6.4", "4.4"}],
    Cell[46477, 1642, 107, 2, 70, "Input",
      CellTags->"S3.6.4"],
    Cell[46587, 1646, 461, 14, 70, "Output",
      CellTags->"S3.6.4"],
    Cell[47063, 1663, 363, 13, 70, "MathCaption",
      CellTags->{"S3.6.4", "4.5"}],
    Cell[47451, 1680, 94, 2, 70, "Input",
      CellTags->"S3.6.4"],
    Cell[47548, 1684, 461, 14, 70, "Output",
      CellTags->"S3.6.4"],
    Cell[48024, 1701, 1697, 58, 70, "Text",
      CellTags->{"S3.6.4", "4.6"}],
    Cell[49724, 1761, 273, 10, 70, "MathCaption",
      CellTags->{"S3.6.4", "4.7"}],
    Cell[50022, 1775, 89, 2, 70, "Input",
      CellTags->"S3.6.4"],
    Cell[50114, 1779, 392, 11, 70, "Output",
      CellTags->"S3.6.4"],
    Cell[50521, 1793, 302, 10, 70, "MathCaption",
      CellTags->{"S3.6.4", "4.8"}],
    Cell[50848, 1807, 83, 2, 70, "Input",
      CellTags->"S3.6.4"],
    Cell[50934, 1811, 396, 11, 70, "Output",
      CellTags->"S3.6.4"],
    Cell[51345, 1825, 108, 1, 70, "MathCaption",
      CellTags->{"S3.6.4", "4.9"}],
    Cell[51478, 1830, 84, 2, 70, "Input",
      CellTags->"S3.6.4"],
    Cell[51565, 1834, 293, 9, 70, "Output",
      CellTags->"S3.6.4"]},
  "4.1"->{
    Cell[43039, 1519, 126, 4, 70, "Subsection",
      CellTags->{"S3.6.4", "4.1"}]},
  "4.2"->{
    Cell[43168, 1525, 251, 6, 70, "Text",
      CellTags->{"S3.6.4", "4.2"}]},
  "4.3"->{
    Cell[44764, 1574, 436, 16, 70, "MathCaption",
      CellTags->{"S3.6.4", "4.3"}]},
  "4.4"->{
    Cell[45836, 1616, 616, 22, 70, "MathCaption",
      CellTags->{"S3.6.4", "4.4"}]},
  "4.5"->{
    Cell[47063, 1663, 363, 13, 70, "MathCaption",
      CellTags->{"S3.6.4", "4.5"}]},
  "4.6"->{
    Cell[48024, 1701, 1697, 58, 70, "Text",
      CellTags->{"S3.6.4", "4.6"}]},
  "4.7"->{
    Cell[49724, 1761, 273, 10, 70, "MathCaption",
      CellTags->{"S3.6.4", "4.7"}]},
  "4.8"->{
    Cell[50521, 1793, 302, 10, 70, "MathCaption",
      CellTags->{"S3.6.4", "4.8"}]},
  "4.9"->{
    Cell[51345, 1825, 108, 1, 70, "MathCaption",
      CellTags->{"S3.6.4", "4.9"}]},
  "S3.6.5"->{
    Cell[51907, 1849, 104, 1, 70, "Subsection",
      CellTags->{"S3.6.5", "5.1"}],
    Cell[52014, 1852, 437, 12, 70, "DefinitionBox",
      CellTags->"S3.6.5"],
    Cell[52454, 1866, 88, 1, 70, "Caption",
      CellTags->"S3.6.5"],
    Cell[52545, 1869, 248, 6, 70, "Text",
      CellTags->{"S3.6.5", "5.2"}],
    Cell[52796, 1877, 283, 6, 70, "Text",
      CellTags->{"S3.6.5", "5.3"}],
    Cell[53082, 1885, 102, 1, 70, "MathCaption",
      CellTags->{"S3.6.5", "5.4"}],
    Cell[53209, 1890, 98, 2, 70, "Input",
      CellTags->"S3.6.5"],
    Cell[53310, 1894, 443, 13, 70, "Output",
      CellTags->"S3.6.5"],
    Cell[53768, 1910, 160, 4, 70, "MathCaption",
      CellTags->{"S3.6.5", "5.5"}],
    Cell[53953, 1918, 67, 2, 70, "Input",
      CellTags->"S3.6.5"],
    Cell[54023, 1922, 484, 13, 70, "Output",
      CellTags->"S3.6.5"],
    Cell[54522, 1938, 155, 4, 70, "MathCaption",
      CellTags->{"S3.6.5", "5.6"}],
    Cell[54702, 1946, 73, 2, 70, "Input",
      CellTags->"S3.6.5"],
    Cell[54778, 1950, 143, 4, 70, "Output",
      CellTags->"S3.6.5"],
    Cell[54936, 1957, 103, 1, 70, "MathCaption",
      CellTags->{"S3.6.5", "5.7"}],
    Cell[55064, 1962, 73, 2, 70, "Input",
      CellTags->"S3.6.5"],
    Cell[55140, 1966, 165, 4, 70, "Output",
      CellTags->"S3.6.5"],
    Cell[55320, 1973, 863, 24, 70, "DefinitionBox",
      CellTags->"S3.6.5"],
    Cell[56186, 1999, 91, 1, 70, "Caption",
      CellTags->"S3.6.5"],
    Cell[56280, 2002, 278, 9, 70, "MathCaption",
      CellTags->{"S3.6.5", "5.8"}],
    Cell[56583, 2015, 87, 2, 70, "Input",
      CellTags->"S3.6.5"],
    Cell[56673, 2019, 94, 3, 70, "Output",
      CellTags->"S3.6.5"]},
  "5.1"->{
    Cell[51907, 1849, 104, 1, 70, "Subsection",
      CellTags->{"S3.6.5", "5.1"}]},
  "5.2"->{
    Cell[52545, 1869, 248, 6, 70, "Text",
      CellTags->{"S3.6.5", "5.2"}]},
  "5.3"->{
    Cell[52796, 1877, 283, 6, 70, "Text",
      CellTags->{"S3.6.5", "5.3"}]},
  "5.4"->{
    Cell[53082, 1885, 102, 1, 70, "MathCaption",
      CellTags->{"S3.6.5", "5.4"}]},
  "5.5"->{
    Cell[53768, 1910, 160, 4, 70, "MathCaption",
      CellTags->{"S3.6.5", "5.5"}]},
  "5.6"->{
    Cell[54522, 1938, 155, 4, 70, "MathCaption",
      CellTags->{"S3.6.5", "5.6"}]},
  "5.7"->{
    Cell[54936, 1957, 103, 1, 70, "MathCaption",
      CellTags->{"S3.6.5", "5.7"}]},
  "5.8"->{
    Cell[56280, 2002, 278, 9, 70, "MathCaption",
      CellTags->{"S3.6.5", "5.8"}]},
  "S3.6.6"->{
    Cell[56816, 2028, 99, 1, 70, "Subsection",
      CellTags->{"S3.6.6", "6.1"}],
    Cell[56918, 2031, 2265, 65, 70, "DefinitionBox",
      CellTags->"S3.6.6"],
    Cell[59186, 2098, 83, 1, 70, "Caption",
      CellTags->"S3.6.6"],
    Cell[59272, 2101, 78, 1, 70, "MathCaption",
      CellTags->{"S3.6.6", "6.2"}],
    Cell[59375, 2106, 102, 2, 70, "Input",
      CellTags->"S3.6.6"],
    Cell[59480, 2110, 408, 13, 70, "Output",
      CellTags->"S3.6.6"],
    Cell[59903, 2126, 105, 1, 70, "MathCaption",
      CellTags->{"S3.6.6", "6.3"}],
    Cell[60033, 2131, 82, 2, 70, "Input",
      CellTags->"S3.6.6"],
    Cell[60118, 2135, 891, 30, 70, "Output",
      CellTags->"S3.6.6"],
    Cell[61024, 2168, 189, 6, 70, "MathCaption",
      CellTags->{"S3.6.6", "6.4"}],
    Cell[61238, 2178, 82, 2, 70, "Input",
      CellTags->"S3.6.6"],
    Cell[61323, 2182, 214, 4, 70, "Output",
      CellTags->"S3.6.6"],
    Cell[61552, 2189, 293, 9, 70, "MathCaption",
      CellTags->{"S3.6.6", "6.5"}],
    Cell[61870, 2202, 74, 2, 70, "Input",
      CellTags->"S3.6.6"],
    Cell[61947, 2206, 220, 5, 70, "Output",
      CellTags->"S3.6.6"],
    Cell[62182, 2214, 317, 9, 70, "Text",
      CellTags->{"S3.6.6", "6.6"}]},
  "6.1"->{
    Cell[56816, 2028, 99, 1, 70, "Subsection",
      CellTags->{"S3.6.6", "6.1"}]},
  "6.2"->{
    Cell[59272, 2101, 78, 1, 70, "MathCaption",
      CellTags->{"S3.6.6", "6.2"}]},
  "6.3"->{
    Cell[59903, 2126, 105, 1, 70, "MathCaption",
      CellTags->{"S3.6.6", "6.3"}]},
  "6.4"->{
    Cell[61024, 2168, 189, 6, 70, "MathCaption",
      CellTags->{"S3.6.6", "6.4"}]},
  "6.5"->{
    Cell[61552, 2189, 293, 9, 70, "MathCaption",
      CellTags->{"S3.6.6", "6.5"}]},
  "6.6"->{
    Cell[62182, 2214, 317, 9, 70, "Text",
      CellTags->{"S3.6.6", "6.6"}]},
  "S3.6.7"->{
    Cell[62536, 2228, 78, 1, 70, "Subsection",
      CellTags->{"S3.6.7", "7.1"}],
    Cell[62617, 2231, 1898, 56, 70, "DefinitionBox",
      CellTags->"S3.6.7"],
    Cell[64518, 2289, 58, 1, 70, "Caption",
      CellTags->"S3.6.7"],
    Cell[64579, 2292, 342, 12, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.2"}],
    Cell[64946, 2308, 93, 2, 70, "Input",
      CellTags->"S3.6.7"],
    Cell[65042, 2312, 99, 3, 70, "Output",
      CellTags->"S3.6.7"],
    Cell[65156, 2318, 105, 1, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.3"}],
    Cell[65286, 2323, 97, 2, 70, "Input",
      CellTags->"S3.6.7"],
    Cell[65386, 2327, 99, 3, 70, "Output",
      CellTags->"S3.6.7"],
    Cell[65500, 2333, 139, 4, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.4"}],
    Cell[65664, 2341, 99, 2, 70, "Input",
      CellTags->"S3.6.7"],
    Cell[65766, 2345, 138, 3, 70, "Output",
      CellTags->"S3.6.7"],
    Cell[65919, 2351, 128, 4, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.5"}],
    Cell[66072, 2359, 97, 2, 70, "Input",
      CellTags->"S3.6.7"],
    Cell[66172, 2363, 116, 3, 70, "Output",
      CellTags->"S3.6.7"],
    Cell[66303, 2369, 248, 5, 70, "Text",
      CellTags->{"S3.6.7", "7.6"}],
    Cell[66554, 2376, 93, 1, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.7"}],
    Cell[66672, 2381, 81, 2, 70, "Input",
      CellTags->"S3.6.7"],
    Cell[66756, 2385, 101, 3, 70, "Output",
      CellTags->"S3.6.7"],
    Cell[66872, 2391, 116, 2, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.8"}],
    Cell[67013, 2397, 86, 2, 70, "Input",
      CellTags->"S3.6.7"],
    Cell[67102, 2401, 149, 4, 70, "Output",
      CellTags->"S3.6.7"],
    Cell[67266, 2408, 94, 1, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.9"}],
    Cell[67385, 2413, 89, 2, 70, "Input",
      CellTags->"S3.6.7"],
    Cell[67477, 2417, 121, 3, 70, "Output",
      CellTags->"S3.6.7"],
    Cell[67613, 2423, 281, 8, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.10"}],
    Cell[67919, 2435, 97, 2, 70, "Input",
      CellTags->"S3.6.7"],
    Cell[68019, 2439, 98, 3, 70, "Output",
      CellTags->"S3.6.7"],
    Cell[68132, 2445, 420, 8, 70, "Text",
      CellTags->{"S3.6.7", "7.11"}],
    Cell[68555, 2455, 109, 1, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.12"}],
    Cell[68689, 2460, 102, 2, 70, "Input",
      CellTags->"S3.6.7"],
    Cell[68794, 2464, 242, 5, 70, "Output",
      CellTags->"S3.6.7"],
    Cell[69051, 2472, 90, 1, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.13"}],
    Cell[69166, 2477, 110, 2, 70, "Input",
      CellTags->"S3.6.7"],
    Cell[69279, 2481, 88, 3, 70, "Output",
      CellTags->"S3.6.7"],
    Cell[69382, 2487, 105, 1, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.14"}],
    Cell[69512, 2492, 104, 2, 70, "Input",
      CellTags->"S3.6.7"],
    Cell[69619, 2496, 132, 3, 70, "Output",
      CellTags->"S3.6.7"]},
  "7.1"->{
    Cell[62536, 2228, 78, 1, 70, "Subsection",
      CellTags->{"S3.6.7", "7.1"}]},
  "7.2"->{
    Cell[64579, 2292, 342, 12, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.2"}]},
  "7.3"->{
    Cell[65156, 2318, 105, 1, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.3"}]},
  "7.4"->{
    Cell[65500, 2333, 139, 4, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.4"}]},
  "7.5"->{
    Cell[65919, 2351, 128, 4, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.5"}]},
  "7.6"->{
    Cell[66303, 2369, 248, 5, 70, "Text",
      CellTags->{"S3.6.7", "7.6"}]},
  "7.7"->{
    Cell[66554, 2376, 93, 1, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.7"}]},
  "7.8"->{
    Cell[66872, 2391, 116, 2, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.8"}]},
  "7.9"->{
    Cell[67266, 2408, 94, 1, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.9"}]},
  "7.10"->{
    Cell[67613, 2423, 281, 8, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.10"}]},
  "7.11"->{
    Cell[68132, 2445, 420, 8, 70, "Text",
      CellTags->{"S3.6.7", "7.11"}]},
  "7.12"->{
    Cell[68555, 2455, 109, 1, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.12"}]},
  "7.13"->{
    Cell[69051, 2472, 90, 1, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.13"}]},
  "7.14"->{
    Cell[69382, 2487, 105, 1, 70, "MathCaption",
      CellTags->{"S3.6.7", "7.14"}]},
  "S3.6.8"->{
    Cell[69800, 2505, 87, 1, 70, "Subsection",
      CellTags->{"S3.6.8", "8.1"}],
    Cell[69890, 2508, 439, 14, 70, "Text",
      CellTags->{"S3.6.8", "8.2"}],
    Cell[70332, 2524, 266, 10, 70, "Text",
      CellTags->{"S3.6.8", "8.3"}],
    Cell[70601, 2536, 96, 1, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.4"}],
    Cell[70722, 2541, 110, 2, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[70835, 2545, 115, 3, 70, "Output",
      CellTags->"S3.6.8"],
    Cell[70965, 2551, 173, 5, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.5"}],
    Cell[71163, 2560, 96, 2, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[71262, 2564, 120, 3, 70, "Output",
      CellTags->"S3.6.8"],
    Cell[71397, 2570, 667, 20, 70, "DefinitionBox",
      CellTags->"S3.6.8"],
    Cell[72067, 2592, 72, 1, 70, "Caption",
      CellTags->"S3.6.8"],
    Cell[72142, 2595, 114, 2, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.6"}],
    Cell[72281, 2601, 114, 2, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[72398, 2605, 131, 3, 70, "Output",
      CellTags->"S3.6.8"],
    Cell[72544, 2611, 82, 1, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.7"}],
    Cell[72651, 2616, 114, 2, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[72768, 2620, 131, 3, 70, "Output",
      CellTags->"S3.6.8"],
    Cell[72914, 2626, 135, 4, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.8"}],
    Cell[73074, 2634, 135, 5, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[73212, 2641, 233, 6, 70, "Output",
      CellTags->"S3.6.8"],
    Cell[73460, 2650, 310, 7, 70, "Text",
      CellTags->{"S3.6.8", "8.9"}],
    Cell[73773, 2659, 131, 4, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.10"}],
    Cell[73929, 2667, 110, 2, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[74042, 2671, 110, 3, 70, "Output",
      CellTags->"S3.6.8"],
    Cell[74167, 2677, 151, 4, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.11"}],
    Cell[74343, 2685, 144, 5, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[74490, 2692, 285, 6, 70, "Output",
      CellTags->"S3.6.8"],
    Cell[74790, 2701, 390, 12, 70, "Text",
      CellTags->{"S3.6.8", "8.12"}],
    Cell[75183, 2715, 127, 4, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.13"}],
    Cell[75335, 2723, 97, 2, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[75435, 2727, 116, 3, 70, "Output",
      CellTags->"S3.6.8"],
    Cell[75566, 2733, 540, 12, 70, "Text",
      CellTags->{"S3.6.8", "8.14"}],
    Cell[76109, 2747, 130, 4, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.15"}],
    Cell[76264, 2755, 108, 2, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[76375, 2759, 189, 5, 70, "Output",
      CellTags->"S3.6.8"],
    Cell[76579, 2767, 90, 1, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.16"}],
    Cell[76694, 2772, 111, 2, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[76808, 2776, 331, 7, 70, "Output",
      CellTags->"S3.6.8"],
    Cell[77154, 2786, 412, 12, 70, "Text",
      CellTags->{"S3.6.8", "8.17"}],
    Cell[77569, 2800, 254, 8, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.18"}],
    Cell[77848, 2812, 98, 2, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[77949, 2816, 158, 4, 70, "Output",
      CellTags->"S3.6.8"],
    Cell[78122, 2823, 245, 8, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.19"}],
    Cell[78392, 2835, 105, 2, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[78500, 2839, 212, 5, 70, "Output",
      CellTags->"S3.6.8"],
    Cell[78727, 2847, 1819, 53, 70, "DefinitionBox",
      CellTags->"S3.6.8"],
    Cell[80549, 2902, 82, 1, 70, "Caption",
      CellTags->"S3.6.8"],
    Cell[80634, 2905, 115, 2, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.20"}],
    Cell[80774, 2911, 163, 5, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[80940, 2918, 359, 8, 70, "Output",
      CellTags->"S3.6.8"],
    Cell[81314, 2929, 1627, 46, 70, "DefinitionBox",
      CellTags->"S3.6.8"],
    Cell[82944, 2977, 79, 1, 70, "Caption",
      CellTags->"S3.6.8"],
    Cell[83026, 2980, 388, 7, 70, "Text",
      CellTags->{"S3.6.8", "8.21"}],
    Cell[83417, 2989, 138, 4, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.22"}],
    Cell[83580, 2997, 120, 2, 70, "Input",
      CellTags->"S3.6.8"],
    Cell[83703, 3001, 174, 5, 70, "Output",
      CellTags->"S3.6.8"]},
  "8.1"->{
    Cell[69800, 2505, 87, 1, 70, "Subsection",
      CellTags->{"S3.6.8", "8.1"}]},
  "8.2"->{
    Cell[69890, 2508, 439, 14, 70, "Text",
      CellTags->{"S3.6.8", "8.2"}]},
  "8.3"->{
    Cell[70332, 2524, 266, 10, 70, "Text",
      CellTags->{"S3.6.8", "8.3"}]},
  "8.4"->{
    Cell[70601, 2536, 96, 1, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.4"}]},
  "8.5"->{
    Cell[70965, 2551, 173, 5, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.5"}]},
  "8.6"->{
    Cell[72142, 2595, 114, 2, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.6"}]},
  "8.7"->{
    Cell[72544, 2611, 82, 1, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.7"}]},
  "8.8"->{
    Cell[72914, 2626, 135, 4, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.8"}]},
  "8.9"->{
    Cell[73460, 2650, 310, 7, 70, "Text",
      CellTags->{"S3.6.8", "8.9"}]},
  "8.10"->{
    Cell[73773, 2659, 131, 4, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.10"}]},
  "8.11"->{
    Cell[74167, 2677, 151, 4, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.11"}]},
  "8.12"->{
    Cell[74790, 2701, 390, 12, 70, "Text",
      CellTags->{"S3.6.8", "8.12"}]},
  "8.13"->{
    Cell[75183, 2715, 127, 4, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.13"}]},
  "8.14"->{
    Cell[75566, 2733, 540, 12, 70, "Text",
      CellTags->{"S3.6.8", "8.14"}]},
  "8.15"->{
    Cell[76109, 2747, 130, 4, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.15"}]},
  "8.16"->{
    Cell[76579, 2767, 90, 1, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.16"}]},
  "8.17"->{
    Cell[77154, 2786, 412, 12, 70, "Text",
      CellTags->{"S3.6.8", "8.17"}]},
  "8.18"->{
    Cell[77569, 2800, 254, 8, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.18"}]},
  "8.19"->{
    Cell[78122, 2823, 245, 8, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.19"}]},
  "8.20"->{
    Cell[80634, 2905, 115, 2, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.20"}]},
  "8.21"->{
    Cell[83026, 2980, 388, 7, 70, "Text",
      CellTags->{"S3.6.8", "8.21"}]},
  "8.22"->{
    Cell[83417, 2989, 138, 4, 70, "MathCaption",
      CellTags->{"S3.6.8", "8.22"}]},
  "S3.6.9"->{
    Cell[83926, 3012, 73, 1, 70, "Subsection",
      CellTags->{"S3.6.9", "9.1"}],
    Cell[84002, 3015, 319, 7, 70, "Text",
      CellTags->{"S3.6.9", "9.2"}],
    Cell[84324, 3024, 500, 16, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.3"}],
    Cell[84849, 3044, 82, 2, 70, "Input",
      CellTags->"S3.6.9"],
    Cell[84934, 3048, 82, 3, 70, "Output",
      CellTags->"S3.6.9"],
    Cell[85031, 3054, 100, 1, 70, "Text",
      CellTags->{"S3.6.9", "9.4"}],
    Cell[85134, 3057, 1359, 48, 70, "Text",
      CellTags->{"S3.6.9", "9.5"}],
    Cell[86496, 3107, 1155, 35, 70, "DefinitionBox",
      CellTags->"S3.6.9"],
    Cell[87654, 3144, 57, 1, 70, "Caption",
      CellTags->"S3.6.9"],
    Cell[87714, 3147, 526, 19, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.6"}],
    Cell[88265, 3170, 89, 2, 70, "Input",
      CellTags->"S3.6.9"],
    Cell[88357, 3174, 82, 3, 70, "Output",
      CellTags->"S3.6.9"],
    Cell[88454, 3180, 91, 1, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.7"}],
    Cell[88570, 3185, 91, 2, 70, "Input",
      CellTags->"S3.6.9"],
    Cell[88664, 3189, 92, 3, 70, "Output",
      CellTags->"S3.6.9"],
    Cell[88771, 3195, 551, 20, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.8"}],
    Cell[89347, 3219, 89, 2, 70, "Input",
      CellTags->"S3.6.9"],
    Cell[89439, 3223, 82, 3, 70, "Output",
      CellTags->"S3.6.9"],
    Cell[89536, 3229, 77, 1, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.9"}],
    Cell[89638, 3234, 100, 2, 70, "Input",
      CellTags->"S3.6.9"],
    Cell[89741, 3238, 99, 3, 70, "Output",
      CellTags->"S3.6.9"],
    Cell[89855, 3244, 256, 12, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.10"}],
    Cell[90136, 3260, 71, 2, 70, "Input",
      CellTags->"S3.6.9"],
    Cell[90210, 3264, 82, 3, 70, "Output",
      CellTags->"S3.6.9"],
    Cell[90307, 3270, 195, 7, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.11"}],
    Cell[90527, 3281, 86, 2, 70, "Input",
      CellTags->"S3.6.9"],
    Cell[90616, 3285, 82, 3, 70, "Output",
      CellTags->"S3.6.9"],
    Cell[90713, 3291, 2066, 71, 70, "Text",
      CellTags->{"S3.6.9", "9.12"}],
    Cell[92782, 3364, 598, 20, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.13"}],
    Cell[93405, 3388, 89, 2, 70, "Input",
      CellTags->"S3.6.9"],
    Cell[93497, 3392, 102, 3, 70, "Output",
      CellTags->"S3.6.9"],
    Cell[93614, 3398, 174, 6, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.14"}],
    Cell[93813, 3408, 73, 2, 70, "Input",
      CellTags->"S3.6.9"],
    Cell[93889, 3412, 97, 3, 70, "Output",
      CellTags->"S3.6.9"],
    Cell[94001, 3418, 200, 6, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.15"}],
    Cell[94226, 3428, 100, 2, 70, "Input",
      CellTags->"S3.6.9"],
    Cell[94329, 3432, 129, 3, 70, "Output",
      CellTags->"S3.6.9"],
    Cell[94473, 3438, 328, 8, 70, "Text",
      CellTags->{"S3.6.9", "9.16"}],
    Cell[94804, 3448, 2589, 78, 70, "DefinitionBox",
      CellTags->"S3.6.9"],
    Cell[97396, 3528, 61, 1, 70, "Caption",
      CellTags->"S3.6.9"],
    Cell[97460, 3531, 468, 15, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.17"}],
    Cell[97953, 3550, 86, 2, 70, "Input",
      CellTags->"S3.6.9"],
    Cell[98042, 3554, 4688, 343, 70, 4615, 340, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.6.9"],
    Cell[102733, 3899, 178, 5, 70, "Output",
      CellTags->"S3.6.9"],
    Cell[102926, 3907, 208, 6, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.18"}],
    Cell[103159, 3917, 101, 2, 70, "Input",
      CellTags->"S3.6.9"],
    Cell[103263, 3921, 98, 3, 25, "Output",
      CellTags->"S3.6.9"],
    Cell[103376, 3927, 203, 6, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.19"}],
    Cell[103604, 3937, 102, 2, 28, "Input",
      CellTags->"S3.6.9"],
    Cell[103709, 3941, 93, 3, 25, "Output",
      CellTags->"S3.6.9"],
    Cell[103817, 3947, 327, 8, 56, "Text",
      CellTags->{"S3.6.9", "9.20"}],
    Cell[104147, 3957, 199, 6, 40, "MathCaption",
      CellTags->{"S3.6.9", "9.21"}],
    Cell[104371, 3967, 88, 2, 28, "Input",
      CellTags->"S3.6.9"],
    Cell[104462, 3971, 212, 7, 27, "Output",
      CellTags->"S3.6.9"]},
  "9.1"->{
    Cell[83926, 3012, 73, 1, 70, "Subsection",
      CellTags->{"S3.6.9", "9.1"}]},
  "9.2"->{
    Cell[84002, 3015, 319, 7, 70, "Text",
      CellTags->{"S3.6.9", "9.2"}]},
  "9.3"->{
    Cell[84324, 3024, 500, 16, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.3"}]},
  "9.4"->{
    Cell[85031, 3054, 100, 1, 70, "Text",
      CellTags->{"S3.6.9", "9.4"}]},
  "9.5"->{
    Cell[85134, 3057, 1359, 48, 70, "Text",
      CellTags->{"S3.6.9", "9.5"}]},
  "9.6"->{
    Cell[87714, 3147, 526, 19, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.6"}]},
  "9.7"->{
    Cell[88454, 3180, 91, 1, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.7"}]},
  "9.8"->{
    Cell[88771, 3195, 551, 20, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.8"}]},
  "9.9"->{
    Cell[89536, 3229, 77, 1, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.9"}]},
  "9.10"->{
    Cell[89855, 3244, 256, 12, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.10"}]},
  "9.11"->{
    Cell[90307, 3270, 195, 7, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.11"}]},
  "9.12"->{
    Cell[90713, 3291, 2066, 71, 70, "Text",
      CellTags->{"S3.6.9", "9.12"}]},
  "9.13"->{
    Cell[92782, 3364, 598, 20, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.13"}]},
  "9.14"->{
    Cell[93614, 3398, 174, 6, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.14"}]},
  "9.15"->{
    Cell[94001, 3418, 200, 6, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.15"}]},
  "9.16"->{
    Cell[94473, 3438, 328, 8, 70, "Text",
      CellTags->{"S3.6.9", "9.16"}]},
  "9.17"->{
    Cell[97460, 3531, 468, 15, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.17"}]},
  "9.18"->{
    Cell[102926, 3907, 208, 6, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.18"}]},
  "9.19"->{
    Cell[103376, 3927, 203, 6, 70, "MathCaption",
      CellTags->{"S3.6.9", "9.19"}]},
  "9.20"->{
    Cell[103817, 3947, 327, 8, 56, "Text",
      CellTags->{"S3.6.9", "9.20"}]},
  "9.21"->{
    Cell[104147, 3957, 199, 6, 40, "MathCaption",
      CellTags->{"S3.6.9", "9.21"}]},
  "S3.6.10"->{
    Cell[104723, 3984, 70, 1, 38, "Subsection",
      CellTags->{"S3.6.10", "10.1"}],
    Cell[104796, 3987, 1542, 59, 72, "Text",
      CellTags->{"S3.6.10", "10.2"}],
    Cell[106341, 4048, 1167, 35, 46, "DefinitionBox",
      CellTags->"S3.6.10"],
    Cell[107511, 4085, 62, 1, 16, "Caption",
      CellTags->"S3.6.10"],
    Cell[107576, 4088, 88, 1, 40, "MathCaption",
      CellTags->{"S3.6.10", "10.3"}],
    Cell[107689, 4093, 85, 2, 28, "Input",
      CellTags->"S3.6.10"],
    Cell[107777, 4097, 83, 3, 25, "Output",
      CellTags->"S3.6.10"],
    Cell[107875, 4103, 82, 1, 40, "MathCaption",
      CellTags->{"S3.6.10", "10.4"}],
    Cell[107982, 4108, 87, 2, 28, "Input",
      CellTags->"S3.6.10"],
    Cell[108072, 4112, 83, 3, 25, "Output",
      CellTags->"S3.6.10"]},
  "10.1"->{
    Cell[104723, 3984, 70, 1, 38, "Subsection",
      CellTags->{"S3.6.10", "10.1"}]},
  "10.2"->{
    Cell[104796, 3987, 1542, 59, 72, "Text",
      CellTags->{"S3.6.10", "10.2"}]},
  "10.3"->{
    Cell[107576, 4088, 88, 1, 40, "MathCaption",
      CellTags->{"S3.6.10", "10.3"}]},
  "10.4"->{
    Cell[107875, 4103, 82, 1, 40, "MathCaption",
      CellTags->{"S3.6.10", "10.4"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S3.6.0", 108810, 4136},
  {"0.1", 108900, 4139},
  {"S3.6.1", 108993, 4142},
  {"1.1", 112688, 4241},
  {"1.2", 112780, 4244},
  {"1.3", 112876, 4247},
  {"1.4", 112972, 4250},
  {"1.5", 113067, 4253},
  {"1.6", 113155, 4256},
  {"1.7", 113245, 4259},
  {"1.8", 113334, 4262},
  {"1.9", 113430, 4265},
  {"1.10", 113527, 4268},
  {"1.11", 113625, 4271},
  {"1.12", 113716, 4274},
  {"1.13", 113815, 4277},
  {"1.14", 113914, 4280},
  {"1.15", 114005, 4283},
  {"1.16", 114096, 4286},
  {"1.17", 114188, 4289},
  {"1.18", 114287, 4292},
  {"1.19", 114379, 4295},
  {"1.20", 114477, 4298},
  {"1.21", 114575, 4301},
  {"1.22", 114667, 4304},
  {"S3.6.2", 114767, 4307},
  {"2.1", 115845, 4336},
  {"2.2", 115940, 4339},
  {"2.3", 116029, 4342},
  {"2.4", 116125, 4345},
  {"2.5", 116221, 4348},
  {"2.6", 116311, 4351},
  {"2.7", 116402, 4354},
  {"2.8", 116492, 4357},
  {"S3.6.3", 116592, 4360},
  {"3.1", 120025, 4451},
  {"3.2", 120120, 4454},
  {"3.3", 120210, 4457},
  {"3.4", 120307, 4460},
  {"3.5", 120404, 4463},
  {"3.6", 120502, 4466},
  {"3.7", 120592, 4469},
  {"3.8", 120689, 4472},
  {"3.9", 120786, 4475},
  {"3.10", 120877, 4478},
  {"3.11", 120977, 4481},
  {"3.12", 121076, 4484},
  {"3.13", 121175, 4487},
  {"3.14", 121267, 4490},
  {"3.15", 121366, 4493},
  {"3.16", 121465, 4496},
  {"3.17", 121564, 4499},
  {"3.18", 121663, 4502},
  {"3.19", 121755, 4505},
  {"S3.6.4", 121856, 4508},
  {"4.1", 123622, 4555},
  {"4.2", 123718, 4558},
  {"4.3", 123808, 4561},
  {"4.4", 123906, 4564},
  {"4.5", 124004, 4567},
  {"4.6", 124102, 4570},
  {"4.7", 124194, 4573},
  {"4.8", 124292, 4576},
  {"4.9", 124390, 4579},
  {"S3.6.5", 124490, 4582},
  {"5.1", 126168, 4627},
  {"5.2", 126264, 4630},
  {"5.3", 126354, 4633},
  {"5.4", 126444, 4636},
  {"5.5", 126541, 4639},
  {"5.6", 126638, 4642},
  {"5.7", 126735, 4645},
  {"5.8", 126832, 4648},
  {"S3.6.6", 126932, 4651},
  {"6.1", 128158, 4684},
  {"6.2", 128253, 4687},
  {"6.3", 128349, 4690},
  {"6.4", 128446, 4693},
  {"6.5", 128543, 4696},
  {"6.6", 128640, 4699},
  {"S3.6.7", 128733, 4702},
  {"7.1", 131612, 4779},
  {"7.2", 131707, 4782},
  {"7.3", 131805, 4785},
  {"7.4", 131902, 4788},
  {"7.5", 131999, 4791},
  {"7.6", 132096, 4794},
  {"7.7", 132186, 4797},
  {"7.8", 132282, 4800},
  {"7.9", 132379, 4803},
  {"7.10", 132476, 4806},
  {"7.11", 132575, 4809},
  {"7.12", 132667, 4812},
  {"7.13", 132766, 4815},
  {"7.14", 132864, 4818},
  {"S3.6.8", 132965, 4821},
  {"8.1", 137234, 4934},
  {"8.2", 137329, 4937},
  {"8.3", 137420, 4940},
  {"8.4", 137511, 4943},
  {"8.5", 137607, 4946},
  {"8.6", 137704, 4949},
  {"8.7", 137801, 4952},
  {"8.8", 137897, 4955},
  {"8.9", 137994, 4958},
  {"8.10", 138085, 4961},
  {"8.11", 138184, 4964},
  {"8.12", 138283, 4967},
  {"8.13", 138376, 4970},
  {"8.14", 138475, 4973},
  {"8.15", 138568, 4976},
  {"8.16", 138667, 4979},
  {"8.17", 138765, 4982},
  {"8.18", 138858, 4985},
  {"8.19", 138957, 4988},
  {"8.20", 139056, 4991},
  {"8.21", 139155, 4994},
  {"8.22", 139247, 4997},
  {"S3.6.9", 139348, 5000},
  {"9.1", 143540, 5111},
  {"9.2", 143635, 5114},
  {"9.3", 143725, 5117},
  {"9.4", 143823, 5120},
  {"9.5", 143913, 5123},
  {"9.6", 144005, 5126},
  {"9.7", 144103, 5129},
  {"9.8", 144199, 5132},
  {"9.9", 144297, 5135},
  {"9.10", 144394, 5138},
  {"9.11", 144494, 5141},
  {"9.12", 144593, 5144},
  {"9.13", 144687, 5147},
  {"9.14", 144787, 5150},
  {"9.15", 144886, 5153},
  {"9.16", 144985, 5156},
  {"9.17", 145077, 5159},
  {"9.18", 145177, 5162},
  {"9.19", 145277, 5165},
  {"9.20", 145377, 5168},
  {"9.21", 145470, 5171},
  {"S3.6.10", 145573, 5174},
  {"10.1", 146370, 5195},
  {"10.2", 146469, 5198},
  {"10.3", 146565, 5201},
  {"10.4", 146665, 5204}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 130, 4, 65, "Section",
  CellTags->{"S3.6.0", "0.1"}],

Cell[CellGroupData[{
Cell[1931, 61, 89, 1, 70, "Subsection",
  CellTags->{"S3.6.1", "1.1"}],
Cell[2023, 64, 3618, 104, 70, "DefinitionBox",
  CellTags->"S3.6.1"],
Cell[5644, 170, 78, 1, 70, "Caption",
  CellTags->"S3.6.1"],
Cell[5725, 173, 627, 22, 70, "MathCaption",
  CellTags->{"S3.6.1", "1.2"}],

Cell[CellGroupData[{
Cell[6377, 199, 91, 2, 70, "Input",
  CellTags->"S3.6.1"],
Cell[6471, 203, 456, 14, 70, "Output",
  CellTags->"S3.6.1"]
}, Open  ]],
Cell[6942, 220, 445, 16, 70, "MathCaption",
  CellTags->{"S3.6.1", "1.3"}],

Cell[CellGroupData[{
Cell[7412, 240, 91, 2, 70, "Input",
  CellTags->"S3.6.1"],
Cell[7506, 244, 677, 19, 70, "Output",
  CellTags->"S3.6.1"]
}, Open  ]],
Cell[8198, 266, 235, 6, 70, "MathCaption",
  CellTags->{"S3.6.1", "1.4"}],

Cell[CellGroupData[{
Cell[8458, 276, 89, 2, 70, "Input",
  CellTags->"S3.6.1"],
Cell[8550, 280, 1083, 33, 70, "Output",
  CellTags->"S3.6.1"]
}, Open  ]],
Cell[9648, 316, 189, 5, 70, "Text",
  CellTags->{"S3.6.1", "1.5"}],
Cell[9840, 323, 2431, 83, 70, "Text",
  CellTags->{"S3.6.1", "1.6"}],
Cell[12274, 408, 235, 5, 70, "Text",
  CellTags->{"S3.6.1", "1.7"}],
Cell[12512, 415, 157, 5, 70, "MathCaption",
  CellTags->{"S3.6.1", "1.8"}],

Cell[CellGroupData[{
Cell[12694, 424, 95, 2, 70, "Input",
  CellTags->"S3.6.1"],
Cell[12792, 428, 554, 15, 70, "Output",
  CellTags->"S3.6.1"]
}, Open  ]],
Cell[13361, 446, 155, 5, 70, "MathCaption",
  CellTags->{"S3.6.1", "1.9"}],

Cell[CellGroupData[{
Cell[13541, 455, 97, 2, 70, "Input",
  CellTags->"S3.6.1"],
Cell[13641, 459, 469, 14, 70, "Output",
  CellTags->"S3.6.1"]
}, Open  ]],
Cell[14125, 476, 156, 4, 70, "MathCaption",
  CellTags->{"S3.6.1", "1.10"}],

Cell[CellGroupData[{
Cell[14306, 484, 99, 2, 70, "Input",
  CellTags->"S3.6.1"],
Cell[14408, 488, 453, 15, 70, "Output",
  CellTags->"S3.6.1"]
}, Open  ]],
Cell[14876, 506, 221, 6, 70, "Text",
  CellTags->{"S3.6.1", "1.11"}],
Cell[15100, 514, 542, 18, 70, "MathCaption",
  CellTags->{"S3.6.1", "1.12"}],

Cell[CellGroupData[{
Cell[15667, 536, 93, 2, 70, "Input",
  CellTags->"S3.6.1"],
Cell[15763, 540, 380, 6, 70, "Message",
  CellTags->"S3.6.1"],
Cell[16146, 548, 106, 3, 70, "Output",
  CellTags->"S3.6.1"]
}, Open  ]],
Cell[16267, 554, 537, 18, 70, "MathCaption",
  CellTags->{"S3.6.1", "1.13"}],

Cell[CellGroupData[{
Cell[16829, 576, 100, 2, 70, "Input",
  CellTags->"S3.6.1"],
Cell[16932, 580, 502, 15, 70, "Output",
  CellTags->"S3.6.1"]
}, Open  ]],
Cell[17449, 598, 246, 6, 70, "Text",
  CellTags->{"S3.6.1", "1.14"}],
Cell[17698, 606, 398, 8, 70, "Text",
  CellTags->{"S3.6.1", "1.15"}],
Cell[18099, 616, 991, 21, 70, "Text",
  CellTags->{"S3.6.1", "1.16"}],
Cell[19093, 639, 347, 11, 70, "MathCaption",
  CellTags->{"S3.6.1", "1.17"}],

Cell[CellGroupData[{
Cell[19465, 654, 95, 2, 70, "Input",
  CellTags->"S3.6.1"],
Cell[19563, 658, 396, 11, 70, "Output",
  CellTags->"S3.6.1"]
}, Open  ]],
Cell[19974, 672, 474, 15, 70, "Text",
  CellTags->{"S3.6.1", "1.18"}],
Cell[20451, 689, 206, 9, 70, "MathCaption",
  CellTags->{"S3.6.1", "1.19"}],

Cell[CellGroupData[{
Cell[20682, 702, 96, 2, 70, "Input",
  CellTags->"S3.6.1"],
Cell[20781, 706, 787, 25, 70, "Output",
  CellTags->"S3.6.1"]
}, Open  ]],
Cell[21583, 734, 169, 6, 70, "MathCaption",
  CellTags->{"S3.6.1", "1.20"}],

Cell[CellGroupData[{
Cell[21777, 744, 98, 2, 70, "Input",
  CellTags->"S3.6.1"],
Cell[21878, 748, 1981, 60, 70, "Output",
  CellTags->"S3.6.1"]
}, Open  ]],
Cell[23874, 811, 370, 12, 70, "Text",
  CellTags->{"S3.6.1", "1.21"}],
Cell[24247, 825, 308, 9, 70, "MathCaption",
  CellTags->{"S3.6.1", "1.22"}],

Cell[CellGroupData[{
Cell[24580, 838, 103, 2, 70, "Input",
  CellTags->"S3.6.1"],
Cell[24686, 842, 1590, 43, 70, "Output",
  CellTags->"S3.6.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26325, 891, 109, 1, 70, "Subsection",
  CellTags->{"S3.6.2", "2.1"}],
Cell[26437, 894, 187, 7, 70, "Text",
  CellTags->{"S3.6.2", "2.2"}],
Cell[26627, 903, 185, 5, 70, "MathCaption",
  CellTags->{"S3.6.2", "2.3"}],

Cell[CellGroupData[{
Cell[26837, 912, 89, 2, 70, "Input",
  CellTags->"S3.6.2"],
Cell[26929, 916, 390, 11, 70, "Output",
  CellTags->"S3.6.2"]
}, Open  ]],
Cell[27334, 930, 164, 5, 70, "MathCaption",
  CellTags->{"S3.6.2", "2.4"}],

Cell[CellGroupData[{
Cell[27523, 939, 76, 2, 70, "Input",
  CellTags->"S3.6.2"],
Cell[27602, 943, 124, 2, 70, "Output",
  CellTags->"S3.6.2"]
}, Open  ]],
Cell[27741, 948, 438, 11, 70, "Text",
  CellTags->{"S3.6.2", "2.5"}],
Cell[28182, 961, 1787, 61, 70, "Text",
  CellTags->{"S3.6.2", "2.6"}],
Cell[29972, 1024, 292, 9, 70, "Text",
  CellTags->{"S3.6.2", "2.7"}],
Cell[30267, 1035, 206, 7, 70, "MathCaption",
  CellTags->{"S3.6.2", "2.8"}],

Cell[CellGroupData[{
Cell[30498, 1046, 85, 2, 70, "Input",
  CellTags->"S3.6.2"],
Cell[30586, 1050, 384, 11, 70, "Output",
  CellTags->"S3.6.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[31019, 1067, 85, 1, 70, "Subsection",
  CellTags->{"S3.6.3", "3.1"}],
Cell[31107, 1070, 297, 7, 70, "Text",
  CellTags->{"S3.6.3", "3.2"}],
Cell[31407, 1079, 236, 8, 70, "MathCaption",
  CellTags->{"S3.6.3", "3.3"}],

Cell[CellGroupData[{
Cell[31668, 1091, 91, 2, 70, "Input",
  CellTags->"S3.6.3"],
Cell[31762, 1095, 456, 14, 70, "Output",
  CellTags->"S3.6.3"]
}, Open  ]],
Cell[32233, 1112, 159, 4, 70, "MathCaption",
  CellTags->{"S3.6.3", "3.4"}],

Cell[CellGroupData[{
Cell[32417, 1120, 67, 2, 70, "Input",
  CellTags->"S3.6.3"],
Cell[32487, 1124, 450, 13, 70, "Output",
  CellTags->"S3.6.3"]
}, Open  ]],
Cell[32952, 1140, 311, 11, 70, "MathCaption",
  CellTags->{"S3.6.3", "3.5"}],

Cell[CellGroupData[{
Cell[33288, 1155, 70, 2, 70, "Input",
  CellTags->"S3.6.3"],
Cell[33361, 1159, 298, 9, 70, "Output",
  CellTags->"S3.6.3"]
}, Open  ]],
Cell[33674, 1171, 379, 7, 70, "Text",
  CellTags->{"S3.6.3", "3.6"}],
Cell[34056, 1180, 261, 9, 70, "MathCaption",
  CellTags->{"S3.6.3", "3.7"}],

Cell[CellGroupData[{
Cell[34342, 1193, 92, 2, 70, "Input",
  CellTags->"S3.6.3"],
Cell[34437, 1197, 577, 16, 70, "Output",
  CellTags->"S3.6.3"]
}, Open  ]],
Cell[35029, 1216, 276, 9, 70, "MathCaption",
  CellTags->{"S3.6.3", "3.8"}],

Cell[CellGroupData[{
Cell[35330, 1229, 75, 2, 70, "Input",
  CellTags->"S3.6.3"],
Cell[35408, 1233, 515, 14, 70, "Output",
  CellTags->"S3.6.3"]
}, Open  ]],
Cell[35938, 1250, 150, 4, 70, "Text",
  CellTags->{"S3.6.3", "3.9"}],
Cell[36091, 1256, 278, 10, 70, "MathCaption",
  CellTags->{"S3.6.3", "3.10"}],

Cell[CellGroupData[{
Cell[36394, 1270, 90, 2, 70, "Input",
  CellTags->"S3.6.3"],
Cell[36487, 1274, 537, 15, 70, "Output",
  CellTags->"S3.6.3"]
}, Open  ]],
Cell[37039, 1292, 141, 5, 70, "MathCaption",
  CellTags->{"S3.6.3", "3.11"}],

Cell[CellGroupData[{
Cell[37205, 1301, 71, 2, 70, "Input",
  CellTags->"S3.6.3"],
Cell[37279, 1305, 505, 14, 70, "Output",
  CellTags->"S3.6.3"]
}, Open  ]],
Cell[37799, 1322, 167, 5, 70, "MathCaption",
  CellTags->{"S3.6.3", "3.12"}],

Cell[CellGroupData[{
Cell[37991, 1331, 79, 2, 70, "Input",
  CellTags->"S3.6.3"],
Cell[38073, 1335, 537, 15, 70, "Output",
  CellTags->"S3.6.3"]
}, Open  ]],
Cell[38625, 1353, 315, 7, 70, "Text",
  CellTags->{"S3.6.3", "3.13"}],
Cell[38943, 1362, 154, 5, 70, "MathCaption",
  CellTags->{"S3.6.3", "3.14"}],

Cell[CellGroupData[{
Cell[39122, 1371, 93, 2, 70, "Input",
  CellTags->"S3.6.3"],
Cell[39218, 1375, 456, 14, 70, "Output",
  CellTags->"S3.6.3"]
}, Open  ]],
Cell[39689, 1392, 147, 5, 70, "MathCaption",
  CellTags->{"S3.6.3", "3.15"}],

Cell[CellGroupData[{
Cell[39861, 1401, 72, 2, 70, "Input",
  CellTags->"S3.6.3"],
Cell[39936, 1405, 464, 14, 70, "Output",
  CellTags->"S3.6.3"]
}, Open  ]],
Cell[40415, 1422, 285, 9, 70, "MathCaption",
  CellTags->{"S3.6.3", "3.16"}],

Cell[CellGroupData[{
Cell[40725, 1435, 75, 2, 70, "Input",
  CellTags->"S3.6.3"],
Cell[40803, 1439, 419, 12, 70, "Output",
  CellTags->"S3.6.3"]
}, Open  ]],
Cell[41237, 1454, 262, 8, 70, "MathCaption",
  CellTags->{"S3.6.3", "3.17"}],

Cell[CellGroupData[{
Cell[41524, 1466, 76, 2, 70, "Input",
  CellTags->"S3.6.3"],
Cell[41603, 1470, 235, 5, 70, "Output",
  CellTags->"S3.6.3"]
}, Open  ]],
Cell[41853, 1478, 333, 7, 70, "Text",
  CellTags->{"S3.6.3", "3.18"}],
Cell[42189, 1487, 233, 6, 70, "MathCaption",
  CellTags->{"S3.6.3", "3.19"}],

Cell[CellGroupData[{
Cell[42447, 1497, 97, 2, 70, "Input",
  CellTags->"S3.6.3"],
Cell[42547, 1501, 443, 12, 70, "Output",
  CellTags->"S3.6.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[43039, 1519, 126, 4, 70, "Subsection",
  CellTags->{"S3.6.4", "4.1"}],
Cell[43168, 1525, 251, 6, 70, "Text",
  CellTags->{"S3.6.4", "4.2"}],
Cell[43422, 1533, 1252, 36, 70, "DefinitionBox",
  CellTags->"S3.6.4"],
Cell[44677, 1571, 84, 1, 70, "Caption",
  CellTags->"S3.6.4"],
Cell[44764, 1574, 436, 16, 70, "MathCaption",
  CellTags->{"S3.6.4", "4.3"}],

Cell[CellGroupData[{
Cell[45225, 1594, 89, 2, 70, "Input",
  CellTags->"S3.6.4"],
Cell[45317, 1598, 504, 15, 70, "Output",
  CellTags->"S3.6.4"]
}, Open  ]],
Cell[45836, 1616, 616, 22, 70, "MathCaption",
  CellTags->{"S3.6.4", "4.4"}],

Cell[CellGroupData[{
Cell[46477, 1642, 107, 2, 70, "Input",
  CellTags->"S3.6.4"],
Cell[46587, 1646, 461, 14, 70, "Output",
  CellTags->"S3.6.4"]
}, Open  ]],
Cell[47063, 1663, 363, 13, 70, "MathCaption",
  CellTags->{"S3.6.4", "4.5"}],

Cell[CellGroupData[{
Cell[47451, 1680, 94, 2, 70, "Input",
  CellTags->"S3.6.4"],
Cell[47548, 1684, 461, 14, 70, "Output",
  CellTags->"S3.6.4"]
}, Open  ]],
Cell[48024, 1701, 1697, 58, 70, "Text",
  CellTags->{"S3.6.4", "4.6"}],
Cell[49724, 1761, 273, 10, 70, "MathCaption",
  CellTags->{"S3.6.4", "4.7"}],

Cell[CellGroupData[{
Cell[50022, 1775, 89, 2, 70, "Input",
  CellTags->"S3.6.4"],
Cell[50114, 1779, 392, 11, 70, "Output",
  CellTags->"S3.6.4"]
}, Open  ]],
Cell[50521, 1793, 302, 10, 70, "MathCaption",
  CellTags->{"S3.6.4", "4.8"}],

Cell[CellGroupData[{
Cell[50848, 1807, 83, 2, 70, "Input",
  CellTags->"S3.6.4"],
Cell[50934, 1811, 396, 11, 70, "Output",
  CellTags->"S3.6.4"]
}, Open  ]],
Cell[51345, 1825, 108, 1, 70, "MathCaption",
  CellTags->{"S3.6.4", "4.9"}],

Cell[CellGroupData[{
Cell[51478, 1830, 84, 2, 70, "Input",
  CellTags->"S3.6.4"],
Cell[51565, 1834, 293, 9, 70, "Output",
  CellTags->"S3.6.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[51907, 1849, 104, 1, 70, "Subsection",
  CellTags->{"S3.6.5", "5.1"}],
Cell[52014, 1852, 437, 12, 70, "DefinitionBox",
  CellTags->"S3.6.5"],
Cell[52454, 1866, 88, 1, 70, "Caption",
  CellTags->"S3.6.5"],
Cell[52545, 1869, 248, 6, 70, "Text",
  CellTags->{"S3.6.5", "5.2"}],
Cell[52796, 1877, 283, 6, 70, "Text",
  CellTags->{"S3.6.5", "5.3"}],
Cell[53082, 1885, 102, 1, 70, "MathCaption",
  CellTags->{"S3.6.5", "5.4"}],

Cell[CellGroupData[{
Cell[53209, 1890, 98, 2, 70, "Input",
  CellTags->"S3.6.5"],
Cell[53310, 1894, 443, 13, 70, "Output",
  CellTags->"S3.6.5"]
}, Open  ]],
Cell[53768, 1910, 160, 4, 70, "MathCaption",
  CellTags->{"S3.6.5", "5.5"}],

Cell[CellGroupData[{
Cell[53953, 1918, 67, 2, 70, "Input",
  CellTags->"S3.6.5"],
Cell[54023, 1922, 484, 13, 70, "Output",
  CellTags->"S3.6.5"]
}, Open  ]],
Cell[54522, 1938, 155, 4, 70, "MathCaption",
  CellTags->{"S3.6.5", "5.6"}],

Cell[CellGroupData[{
Cell[54702, 1946, 73, 2, 70, "Input",
  CellTags->"S3.6.5"],
Cell[54778, 1950, 143, 4, 70, "Output",
  CellTags->"S3.6.5"]
}, Open  ]],
Cell[54936, 1957, 103, 1, 70, "MathCaption",
  CellTags->{"S3.6.5", "5.7"}],

Cell[CellGroupData[{
Cell[55064, 1962, 73, 2, 70, "Input",
  CellTags->"S3.6.5"],
Cell[55140, 1966, 165, 4, 70, "Output",
  CellTags->"S3.6.5"]
}, Open  ]],
Cell[55320, 1973, 863, 24, 70, "DefinitionBox",
  CellTags->"S3.6.5"],
Cell[56186, 1999, 91, 1, 70, "Caption",
  CellTags->"S3.6.5"],
Cell[56280, 2002, 278, 9, 70, "MathCaption",
  CellTags->{"S3.6.5", "5.8"}],

Cell[CellGroupData[{
Cell[56583, 2015, 87, 2, 70, "Input",
  CellTags->"S3.6.5"],
Cell[56673, 2019, 94, 3, 70, "Output",
  CellTags->"S3.6.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[56816, 2028, 99, 1, 70, "Subsection",
  CellTags->{"S3.6.6", "6.1"}],
Cell[56918, 2031, 2265, 65, 70, "DefinitionBox",
  CellTags->"S3.6.6"],
Cell[59186, 2098, 83, 1, 70, "Caption",
  CellTags->"S3.6.6"],
Cell[59272, 2101, 78, 1, 70, "MathCaption",
  CellTags->{"S3.6.6", "6.2"}],

Cell[CellGroupData[{
Cell[59375, 2106, 102, 2, 70, "Input",
  CellTags->"S3.6.6"],
Cell[59480, 2110, 408, 13, 70, "Output",
  CellTags->"S3.6.6"]
}, Open  ]],
Cell[59903, 2126, 105, 1, 70, "MathCaption",
  CellTags->{"S3.6.6", "6.3"}],

Cell[CellGroupData[{
Cell[60033, 2131, 82, 2, 70, "Input",
  CellTags->"S3.6.6"],
Cell[60118, 2135, 891, 30, 70, "Output",
  CellTags->"S3.6.6"]
}, Open  ]],
Cell[61024, 2168, 189, 6, 70, "MathCaption",
  CellTags->{"S3.6.6", "6.4"}],

Cell[CellGroupData[{
Cell[61238, 2178, 82, 2, 70, "Input",
  CellTags->"S3.6.6"],
Cell[61323, 2182, 214, 4, 70, "Output",
  CellTags->"S3.6.6"]
}, Open  ]],
Cell[61552, 2189, 293, 9, 70, "MathCaption",
  CellTags->{"S3.6.6", "6.5"}],

Cell[CellGroupData[{
Cell[61870, 2202, 74, 2, 70, "Input",
  CellTags->"S3.6.6"],
Cell[61947, 2206, 220, 5, 70, "Output",
  CellTags->"S3.6.6"]
}, Open  ]],
Cell[62182, 2214, 317, 9, 70, "Text",
  CellTags->{"S3.6.6", "6.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[62536, 2228, 78, 1, 70, "Subsection",
  CellTags->{"S3.6.7", "7.1"}],
Cell[62617, 2231, 1898, 56, 70, "DefinitionBox",
  CellTags->"S3.6.7"],
Cell[64518, 2289, 58, 1, 70, "Caption",
  CellTags->"S3.6.7"],
Cell[64579, 2292, 342, 12, 70, "MathCaption",
  CellTags->{"S3.6.7", "7.2"}],

Cell[CellGroupData[{
Cell[64946, 2308, 93, 2, 70, "Input",
  CellTags->"S3.6.7"],
Cell[65042, 2312, 99, 3, 70, "Output",
  CellTags->"S3.6.7"]
}, Open  ]],
Cell[65156, 2318, 105, 1, 70, "MathCaption",
  CellTags->{"S3.6.7", "7.3"}],

Cell[CellGroupData[{
Cell[65286, 2323, 97, 2, 70, "Input",
  CellTags->"S3.6.7"],
Cell[65386, 2327, 99, 3, 70, "Output",
  CellTags->"S3.6.7"]
}, Open  ]],
Cell[65500, 2333, 139, 4, 70, "MathCaption",
  CellTags->{"S3.6.7", "7.4"}],

Cell[CellGroupData[{
Cell[65664, 2341, 99, 2, 70, "Input",
  CellTags->"S3.6.7"],
Cell[65766, 2345, 138, 3, 70, "Output",
  CellTags->"S3.6.7"]
}, Open  ]],
Cell[65919, 2351, 128, 4, 70, "MathCaption",
  CellTags->{"S3.6.7", "7.5"}],

Cell[CellGroupData[{
Cell[66072, 2359, 97, 2, 70, "Input",
  CellTags->"S3.6.7"],
Cell[66172, 2363, 116, 3, 70, "Output",
  CellTags->"S3.6.7"]
}, Open  ]],
Cell[66303, 2369, 248, 5, 70, "Text",
  CellTags->{"S3.6.7", "7.6"}],
Cell[66554, 2376, 93, 1, 70, "MathCaption",
  CellTags->{"S3.6.7", "7.7"}],

Cell[CellGroupData[{
Cell[66672, 2381, 81, 2, 70, "Input",
  CellTags->"S3.6.7"],
Cell[66756, 2385, 101, 3, 70, "Output",
  CellTags->"S3.6.7"]
}, Open  ]],
Cell[66872, 2391, 116, 2, 70, "MathCaption",
  CellTags->{"S3.6.7", "7.8"}],

Cell[CellGroupData[{
Cell[67013, 2397, 86, 2, 70, "Input",
  CellTags->"S3.6.7"],
Cell[67102, 2401, 149, 4, 70, "Output",
  CellTags->"S3.6.7"]
}, Open  ]],
Cell[67266, 2408, 94, 1, 70, "MathCaption",
  CellTags->{"S3.6.7", "7.9"}],

Cell[CellGroupData[{
Cell[67385, 2413, 89, 2, 70, "Input",
  CellTags->"S3.6.7"],
Cell[67477, 2417, 121, 3, 70, "Output",
  CellTags->"S3.6.7"]
}, Open  ]],
Cell[67613, 2423, 281, 8, 70, "MathCaption",
  CellTags->{"S3.6.7", "7.10"}],

Cell[CellGroupData[{
Cell[67919, 2435, 97, 2, 70, "Input",
  CellTags->"S3.6.7"],
Cell[68019, 2439, 98, 3, 70, "Output",
  CellTags->"S3.6.7"]
}, Open  ]],
Cell[68132, 2445, 420, 8, 70, "Text",
  CellTags->{"S3.6.7", "7.11"}],
Cell[68555, 2455, 109, 1, 70, "MathCaption",
  CellTags->{"S3.6.7", "7.12"}],

Cell[CellGroupData[{
Cell[68689, 2460, 102, 2, 70, "Input",
  CellTags->"S3.6.7"],
Cell[68794, 2464, 242, 5, 70, "Output",
  CellTags->"S3.6.7"]
}, Open  ]],
Cell[69051, 2472, 90, 1, 70, "MathCaption",
  CellTags->{"S3.6.7", "7.13"}],

Cell[CellGroupData[{
Cell[69166, 2477, 110, 2, 70, "Input",
  CellTags->"S3.6.7"],
Cell[69279, 2481, 88, 3, 70, "Output",
  CellTags->"S3.6.7"]
}, Open  ]],
Cell[69382, 2487, 105, 1, 70, "MathCaption",
  CellTags->{"S3.6.7", "7.14"}],

Cell[CellGroupData[{
Cell[69512, 2492, 104, 2, 70, "Input",
  CellTags->"S3.6.7"],
Cell[69619, 2496, 132, 3, 70, "Output",
  CellTags->"S3.6.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[69800, 2505, 87, 1, 70, "Subsection",
  CellTags->{"S3.6.8", "8.1"}],
Cell[69890, 2508, 439, 14, 70, "Text",
  CellTags->{"S3.6.8", "8.2"}],
Cell[70332, 2524, 266, 10, 70, "Text",
  CellTags->{"S3.6.8", "8.3"}],
Cell[70601, 2536, 96, 1, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.4"}],

Cell[CellGroupData[{
Cell[70722, 2541, 110, 2, 70, "Input",
  CellTags->"S3.6.8"],
Cell[70835, 2545, 115, 3, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]],
Cell[70965, 2551, 173, 5, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.5"}],

Cell[CellGroupData[{
Cell[71163, 2560, 96, 2, 70, "Input",
  CellTags->"S3.6.8"],
Cell[71262, 2564, 120, 3, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]],
Cell[71397, 2570, 667, 20, 70, "DefinitionBox",
  CellTags->"S3.6.8"],
Cell[72067, 2592, 72, 1, 70, "Caption",
  CellTags->"S3.6.8"],
Cell[72142, 2595, 114, 2, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.6"}],

Cell[CellGroupData[{
Cell[72281, 2601, 114, 2, 70, "Input",
  CellTags->"S3.6.8"],
Cell[72398, 2605, 131, 3, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]],
Cell[72544, 2611, 82, 1, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.7"}],

Cell[CellGroupData[{
Cell[72651, 2616, 114, 2, 70, "Input",
  CellTags->"S3.6.8"],
Cell[72768, 2620, 131, 3, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]],
Cell[72914, 2626, 135, 4, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.8"}],

Cell[CellGroupData[{
Cell[73074, 2634, 135, 5, 70, "Input",
  CellTags->"S3.6.8"],
Cell[73212, 2641, 233, 6, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]],
Cell[73460, 2650, 310, 7, 70, "Text",
  CellTags->{"S3.6.8", "8.9"}],
Cell[73773, 2659, 131, 4, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.10"}],

Cell[CellGroupData[{
Cell[73929, 2667, 110, 2, 70, "Input",
  CellTags->"S3.6.8"],
Cell[74042, 2671, 110, 3, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]],
Cell[74167, 2677, 151, 4, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.11"}],

Cell[CellGroupData[{
Cell[74343, 2685, 144, 5, 70, "Input",
  CellTags->"S3.6.8"],
Cell[74490, 2692, 285, 6, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]],
Cell[74790, 2701, 390, 12, 70, "Text",
  CellTags->{"S3.6.8", "8.12"}],
Cell[75183, 2715, 127, 4, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.13"}],

Cell[CellGroupData[{
Cell[75335, 2723, 97, 2, 70, "Input",
  CellTags->"S3.6.8"],
Cell[75435, 2727, 116, 3, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]],
Cell[75566, 2733, 540, 12, 70, "Text",
  CellTags->{"S3.6.8", "8.14"}],
Cell[76109, 2747, 130, 4, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.15"}],

Cell[CellGroupData[{
Cell[76264, 2755, 108, 2, 70, "Input",
  CellTags->"S3.6.8"],
Cell[76375, 2759, 189, 5, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]],
Cell[76579, 2767, 90, 1, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.16"}],

Cell[CellGroupData[{
Cell[76694, 2772, 111, 2, 70, "Input",
  CellTags->"S3.6.8"],
Cell[76808, 2776, 331, 7, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]],
Cell[77154, 2786, 412, 12, 70, "Text",
  CellTags->{"S3.6.8", "8.17"}],
Cell[77569, 2800, 254, 8, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.18"}],

Cell[CellGroupData[{
Cell[77848, 2812, 98, 2, 70, "Input",
  CellTags->"S3.6.8"],
Cell[77949, 2816, 158, 4, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]],
Cell[78122, 2823, 245, 8, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.19"}],

Cell[CellGroupData[{
Cell[78392, 2835, 105, 2, 70, "Input",
  CellTags->"S3.6.8"],
Cell[78500, 2839, 212, 5, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]],
Cell[78727, 2847, 1819, 53, 70, "DefinitionBox",
  CellTags->"S3.6.8"],
Cell[80549, 2902, 82, 1, 70, "Caption",
  CellTags->"S3.6.8"],
Cell[80634, 2905, 115, 2, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.20"}],

Cell[CellGroupData[{
Cell[80774, 2911, 163, 5, 70, "Input",
  CellTags->"S3.6.8"],
Cell[80940, 2918, 359, 8, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]],
Cell[81314, 2929, 1627, 46, 70, "DefinitionBox",
  CellTags->"S3.6.8"],
Cell[82944, 2977, 79, 1, 70, "Caption",
  CellTags->"S3.6.8"],
Cell[83026, 2980, 388, 7, 70, "Text",
  CellTags->{"S3.6.8", "8.21"}],
Cell[83417, 2989, 138, 4, 70, "MathCaption",
  CellTags->{"S3.6.8", "8.22"}],

Cell[CellGroupData[{
Cell[83580, 2997, 120, 2, 70, "Input",
  CellTags->"S3.6.8"],
Cell[83703, 3001, 174, 5, 70, "Output",
  CellTags->"S3.6.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[83926, 3012, 73, 1, 70, "Subsection",
  CellTags->{"S3.6.9", "9.1"}],
Cell[84002, 3015, 319, 7, 70, "Text",
  CellTags->{"S3.6.9", "9.2"}],
Cell[84324, 3024, 500, 16, 70, "MathCaption",
  CellTags->{"S3.6.9", "9.3"}],

Cell[CellGroupData[{
Cell[84849, 3044, 82, 2, 70, "Input",
  CellTags->"S3.6.9"],
Cell[84934, 3048, 82, 3, 70, "Output",
  CellTags->"S3.6.9"]
}, Open  ]],
Cell[85031, 3054, 100, 1, 70, "Text",
  CellTags->{"S3.6.9", "9.4"}],
Cell[85134, 3057, 1359, 48, 70, "Text",
  CellTags->{"S3.6.9", "9.5"}],
Cell[86496, 3107, 1155, 35, 70, "DefinitionBox",
  CellTags->"S3.6.9"],
Cell[87654, 3144, 57, 1, 70, "Caption",
  CellTags->"S3.6.9"],
Cell[87714, 3147, 526, 19, 70, "MathCaption",
  CellTags->{"S3.6.9", "9.6"}],

Cell[CellGroupData[{
Cell[88265, 3170, 89, 2, 70, "Input",
  CellTags->"S3.6.9"],
Cell[88357, 3174, 82, 3, 70, "Output",
  CellTags->"S3.6.9"]
}, Open  ]],
Cell[88454, 3180, 91, 1, 70, "MathCaption",
  CellTags->{"S3.6.9", "9.7"}],

Cell[CellGroupData[{
Cell[88570, 3185, 91, 2, 70, "Input",
  CellTags->"S3.6.9"],
Cell[88664, 3189, 92, 3, 70, "Output",
  CellTags->"S3.6.9"]
}, Open  ]],
Cell[88771, 3195, 551, 20, 70, "MathCaption",
  CellTags->{"S3.6.9", "9.8"}],

Cell[CellGroupData[{
Cell[89347, 3219, 89, 2, 70, "Input",
  CellTags->"S3.6.9"],
Cell[89439, 3223, 82, 3, 70, "Output",
  CellTags->"S3.6.9"]
}, Open  ]],
Cell[89536, 3229, 77, 1, 70, "MathCaption",
  CellTags->{"S3.6.9", "9.9"}],

Cell[CellGroupData[{
Cell[89638, 3234, 100, 2, 70, "Input",
  CellTags->"S3.6.9"],
Cell[89741, 3238, 99, 3, 70, "Output",
  CellTags->"S3.6.9"]
}, Open  ]],
Cell[89855, 3244, 256, 12, 70, "MathCaption",
  CellTags->{"S3.6.9", "9.10"}],

Cell[CellGroupData[{
Cell[90136, 3260, 71, 2, 70, "Input",
  CellTags->"S3.6.9"],
Cell[90210, 3264, 82, 3, 70, "Output",
  CellTags->"S3.6.9"]
}, Open  ]],
Cell[90307, 3270, 195, 7, 70, "MathCaption",
  CellTags->{"S3.6.9", "9.11"}],

Cell[CellGroupData[{
Cell[90527, 3281, 86, 2, 70, "Input",
  CellTags->"S3.6.9"],
Cell[90616, 3285, 82, 3, 70, "Output",
  CellTags->"S3.6.9"]
}, Open  ]],
Cell[90713, 3291, 2066, 71, 70, "Text",
  CellTags->{"S3.6.9", "9.12"}],
Cell[92782, 3364, 598, 20, 70, "MathCaption",
  CellTags->{"S3.6.9", "9.13"}],

Cell[CellGroupData[{
Cell[93405, 3388, 89, 2, 70, "Input",
  CellTags->"S3.6.9"],
Cell[93497, 3392, 102, 3, 70, "Output",
  CellTags->"S3.6.9"]
}, Open  ]],
Cell[93614, 3398, 174, 6, 70, "MathCaption",
  CellTags->{"S3.6.9", "9.14"}],

Cell[CellGroupData[{
Cell[93813, 3408, 73, 2, 70, "Input",
  CellTags->"S3.6.9"],
Cell[93889, 3412, 97, 3, 70, "Output",
  CellTags->"S3.6.9"]
}, Open  ]],
Cell[94001, 3418, 200, 6, 70, "MathCaption",
  CellTags->{"S3.6.9", "9.15"}],

Cell[CellGroupData[{
Cell[94226, 3428, 100, 2, 70, "Input",
  CellTags->"S3.6.9"],
Cell[94329, 3432, 129, 3, 70, "Output",
  CellTags->"S3.6.9"]
}, Open  ]],
Cell[94473, 3438, 328, 8, 70, "Text",
  CellTags->{"S3.6.9", "9.16"}],
Cell[94804, 3448, 2589, 78, 70, "DefinitionBox",
  CellTags->"S3.6.9"],
Cell[97396, 3528, 61, 1, 70, "Caption",
  CellTags->"S3.6.9"],
Cell[97460, 3531, 468, 15, 70, "MathCaption",
  CellTags->{"S3.6.9", "9.17"}],

Cell[CellGroupData[{
Cell[97953, 3550, 86, 2, 70, "Input",
  CellTags->"S3.6.9"],
Cell[98042, 3554, 4688, 343, 70, 4615, 340, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S3.6.9"],
Cell[102733, 3899, 178, 5, 70, "Output",
  CellTags->"S3.6.9"]
}, Open  ]],
Cell[102926, 3907, 208, 6, 70, "MathCaption",
  CellTags->{"S3.6.9", "9.18"}],

Cell[CellGroupData[{
Cell[103159, 3917, 101, 2, 70, "Input",
  CellTags->"S3.6.9"],
Cell[103263, 3921, 98, 3, 25, "Output",
  CellTags->"S3.6.9"]
}, Open  ]],
Cell[103376, 3927, 203, 6, 70, "MathCaption",
  CellTags->{"S3.6.9", "9.19"}],

Cell[CellGroupData[{
Cell[103604, 3937, 102, 2, 28, "Input",
  CellTags->"S3.6.9"],
Cell[103709, 3941, 93, 3, 25, "Output",
  CellTags->"S3.6.9"]
}, Open  ]],
Cell[103817, 3947, 327, 8, 56, "Text",
  CellTags->{"S3.6.9", "9.20"}],
Cell[104147, 3957, 199, 6, 40, "MathCaption",
  CellTags->{"S3.6.9", "9.21"}],

Cell[CellGroupData[{
Cell[104371, 3967, 88, 2, 28, "Input",
  CellTags->"S3.6.9"],
Cell[104462, 3971, 212, 7, 27, "Output",
  CellTags->"S3.6.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[104723, 3984, 70, 1, 38, "Subsection",
  CellTags->{"S3.6.10", "10.1"}],
Cell[104796, 3987, 1542, 59, 72, "Text",
  CellTags->{"S3.6.10", "10.2"}],
Cell[106341, 4048, 1167, 35, 46, "DefinitionBox",
  CellTags->"S3.6.10"],
Cell[107511, 4085, 62, 1, 16, "Caption",
  CellTags->"S3.6.10"],
Cell[107576, 4088, 88, 1, 40, "MathCaption",
  CellTags->{"S3.6.10", "10.3"}],

Cell[CellGroupData[{
Cell[107689, 4093, 85, 2, 28, "Input",
  CellTags->"S3.6.10"],
Cell[107777, 4097, 83, 3, 25, "Output",
  CellTags->"S3.6.10"]
}, Open  ]],
Cell[107875, 4103, 82, 1, 40, "MathCaption",
  CellTags->{"S3.6.10", "10.4"}],

Cell[CellGroupData[{
Cell[107982, 4108, 87, 2, 28, "Input",
  CellTags->"S3.6.10"],
Cell[108072, 4112, 83, 3, 25, "Output",
  CellTags->"S3.6.10"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

