(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    235733,       9420]*)
(*NotebookOutlinePosition[    315114,      11695]*)
(*  CellTagsIndexPosition[    308167,      11432]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["3.7 ", "HeadingNumber"],
  "Linear Algebra"
}], "Section",
  CellTags->{"S3.7.0", "0.1"}],

Cell[CellGroupData[{

Cell["3.7.1 Constructing Matrices", "Subsection",
  CellTags->{"S3.7.1", "1.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "build an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["m",
                        "TI"], "\[Cross]", 
                      StyleBox["n",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " matrix where ",
              StyleBox["f", "TI"],
              " is a function of ",
              StyleBox["i", "TI"],
              " and ",
              StyleBox["j", "TI"],
              " that gives the value of the ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["i",
                        "TI"], ",", 
                      StyleBox["j",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " entry "
            }]]},
          {Cell[TextData[{
              StyleBox["Array[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "build an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["m",
                        "TI"], "\[Cross]", 
                      StyleBox["n",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " matrix whose ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["i",
                        "TI"], ",", 
                      StyleBox["j",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " entry is ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["DiagonalMatrix[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate a diagonal matrix with the elements of ",
              StyleBox["list", "TI"],
              " on the diagonal "
            }]]},
          {Cell[TextData[{
              StyleBox["IdentityMatrix[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["n",
                        "TI"], "\[Cross]", 
                      StyleBox["n",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " identity matrix "
            }]]},
          {Cell[TextData[{
              StyleBox["Normal[SparseArray[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["}->", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}->", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]]", "MR"],
              " "
            }]], Cell[TextData[{
              "make a matrix with non\[Hyphen]zero values ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " at positions ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}",
              StyleBox[" ", "TR"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.1"],

Cell["Functions for constructing matrices. ", "Caption",
  CellTags->"S3.7.1"],

Cell[TextData[{
  "This generates a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " matrix whose ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["i",
            "TI"], ",", 
          StyleBox["j",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " entry is ",
  StyleBox["a[", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["j", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.1", "1.2"}],

Cell[CellGroupData[{

Cell["Table[a[i, j], {i, 2}, {j, 2}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.7.1"],

Cell[BoxData[
    \({{a[1, 1], a[1, 2]}, {a[2, 1], a[2, 2]}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.7.1"]
}, Open  ]],

Cell["Here is another way to produce the same matrix. ", "MathCaption",
  CellTags->{"S3.7.1", "1.3"}],

Cell[CellGroupData[{

Cell["Array[a, {2, 2}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.7.1"],

Cell[BoxData[
    \({{a[1, 1], a[1, 2]}, {a[2, 1], a[2, 2]}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.7.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["DiagonalMatrix", "MR"],
  " makes a matrix with zeros everywhere except on the leading diagonal. "
}], "MathCaption",
  CellTags->{"S3.7.1", "1.4"}],

Cell[CellGroupData[{

Cell["DiagonalMatrix[{a, b, c}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.7.1"],

Cell[BoxData[
    \({{a, 0, 0}, {0, b, 0}, {0, 0, c}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.7.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["IdentityMatrix[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " produces an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "\[Cross]", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " identity matrix. "
}], "MathCaption",
  CellTags->{"S3.7.1", "1.5"}],

Cell[CellGroupData[{

Cell["IdentityMatrix[3]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.7.1"],

Cell[BoxData[
    \({{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.7.1"]
}, Open  ]],

Cell[TextData[{
  "This makes a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]4\)], "InlineFormula"],
  " matrix with two non\[Hyphen]zero values filled in. "
}], "MathCaption",
  CellTags->{"S3.7.1", "1.6"}],

Cell[CellGroupData[{

Cell["Normal[SparseArray[{{2, 3}->a, {3, 2}->b}, {3, 4}]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.7.1"],

Cell[BoxData[
    \({{0, 0, 0, 0}, {0, 0, a, 0}, {0, b, 0, 0}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.7.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["MatrixForm", "MR"],
  " prints the matrix in a two\[Hyphen]dimensional form. "
}], "MathCaption",
  CellTags->{"S3.7.1", "1.7"}],

Cell[CellGroupData[{

Cell["MatrixForm[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.7.1"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", "0", "0", "0"},
            {"0", "0", "a", "0"},
            {"0", "b", "0", "0"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[6]//MatrixForm= ",
  CellTags->"S3.7.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Table[0,", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["a zero matrix "]},
          {Cell[TextData[{
              StyleBox["Table[Random[", "MR"],
              " ",
              StyleBox["],", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["a matrix with random numerical entries "]},
          {Cell[TextData[{
              StyleBox["Table[If[", "MR"],
              StyleBox["i", "TI"],
              " ",
              StyleBox[">=", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["1,", "MR"],
              " ",
              StyleBox["0],", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["a lower\[Hyphen]triangular matrix "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.1"],

Cell[TextData[{
  "Constructing special types of matrices with ",
  StyleBox["Table", "MR"],
  ". "
}], "Caption",
  CellTags->"S3.7.1"],

Cell[TextData[{
  StyleBox["Table", "MR"],
  " evaluates ",
  StyleBox["Random[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " separately for each element, to give a different pseudorandom number in \
each case. "
}], "MathCaption",
  CellTags->{"S3.7.1", "1.8"}],

Cell[CellGroupData[{

Cell["Table[Random[ ], {2}, {2}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.7.1"],

Cell[BoxData[
    \({{0.056070794834861534`, 0.630299795779359`}, {0.3598942942214413`, 
        0.8713770771750458`}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.7.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SparseArray[{},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["a zero matrix "]},
          {Cell[TextData[{
              StyleBox["SparseArray[{", "MR"],
              StyleBox["i", "TI"],
              StyleBox["_,", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["_}", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["1,", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["n",
                        "TI"], "\[Cross]", 
                      StyleBox["n",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " identity matrix "
            }]]},
          {Cell[TextData[{
              StyleBox["SparseArray[{", "MR"],
              StyleBox["i", "TI"],
              StyleBox["_,", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["_}", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[ThinSpace]\)], "InlineFormula"],
              StyleBox["/;", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[ThinSpace]\)], "InlineFormula"],
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[ThinSpace]\)], "InlineFormula"],
              StyleBox[">=", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[ThinSpace]\)], "InlineFormula"],
              StyleBox["j", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["1,", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["a lower\[Hyphen]triangular matrix "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.1"],

Cell[TextData[{
  "Constructing special types of matrices with ",
  StyleBox["SparseArray", "MR"],
  ". "
}], "Caption",
  CellTags->"S3.7.1"],

Cell["\<\
This sets up a general lower\[Hyphen]triangular matrix. \
\>", \
"MathCaption",
  CellTags->{"S3.7.1", "1.9"}],

Cell[CellGroupData[{

Cell["SparseArray[{i_, j_}/;i>=j -> f[i, j], {3, 3}] // MatrixForm", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.7.1"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(f[1, 1]\), "0", "0"},
            {\(f[2, 1]\), \(f[2, 2]\), "0"},
            {\(f[3, 1]\), \(f[3, 2]\), \(f[3, 3]\)}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ 
          SparseArray[ 
          Automatic, {3, 3}, 0, {1, {{0, 1, 3, 6}, {{1}, {1}, {2}, {1}, {3}, {
            2}}}, {
            f[ 1, 1], 
            f[ 2, 1], 
            f[ 2, 2], 
            f[ 3, 1], 
            f[ 3, 3], 
            f[ 3, 2]}}]]]]], "Output",
  CellLabel->"Out[8]//MatrixForm= ",
  CellTags->"S3.7.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.7.2 Getting and Setting Pieces of Matrices", "Subsection",
  CellTags->{"S3.7.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["i",
                        "TI"], ",", 
                      StyleBox["j",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " entry "
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["i",
                      "TI"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " row "
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[All,", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["i",
                      "TI"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " column "
            }]]},
          {Cell[TextData[{
              StyleBox["Take[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the submatrix with rows ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              " through ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " and columns ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              " through ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["r",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}, {",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] , ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["s",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}]]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "the ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["r",
                        "TI"], "\[Cross]", 
                      StyleBox["s",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " submatrix with elements having row indices ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " and column indices ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Tr[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["List]", "MR"],
              " "
            }]], Cell["elements on the diagonal "]},
          {Cell[TextData[{
              StyleBox["ArrayRules[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["\<\
positions of non\[Hyphen]zero elements \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.2"],

Cell["Ways to get pieces of matrices. ", "Caption",
  CellTags->"S3.7.2"],

Cell[TextData[{
  "Matrices in ",
  StyleBox["Mathematica", "TI"],
  " are represented as lists of lists. You can use all the standard ",
  StyleBox["Mathematica", "TI"],
  " list\[Hyphen]manipulation operations on matrices. "
}], "Text",
  CellTags->{"S3.7.2", "2.2"}],

Cell[TextData[{
  "Here is a sample ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]3\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S3.7.2", "2.3"}],

Cell[CellGroupData[{

Cell["t = Array[a, {3, 3}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.7.2"],

Cell[BoxData[
    \({{a[1, 1], a[1, 2], a[1, 3]}, {a[2, 1], a[2, 2], a[2, 3]}, {a[3, 1], 
        a[3, 2], a[3, 3]}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.7.2"]
}, Open  ]],

Cell["This picks out the second row of the matrix. ", "MathCaption",
  CellTags->{"S3.7.2", "2.4"}],

Cell[CellGroupData[{

Cell["t[[2]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.7.2"],

Cell[BoxData[
    \({a[2, 1], a[2, 2], a[2, 3]}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.7.2"]
}, Open  ]],

Cell["Here is the second column of the matrix. ", "MathCaption",
  CellTags->{"S3.7.2", "2.5"}],

Cell[CellGroupData[{

Cell["t[[All, 2]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.7.2"],

Cell[BoxData[
    \({a[1, 2], a[2, 2], a[3, 2]}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.7.2"]
}, Open  ]],

Cell["This picks out a submatrix. ", "MathCaption",
  CellTags->{"S3.7.2", "2.6"}],

Cell[CellGroupData[{

Cell["Take[t, {1, 2}, {2, 3}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.7.2"],

Cell[BoxData[
    \({{a[1, 2], a[1, 3]}, {a[2, 2], a[2, 3]}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.7.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["m", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "11"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "12"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "21"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "22"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] }",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "assign ",
              StyleBox["m", "TI"],
              " to be a matrix "
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["v", "TI"],
              " "
            }]], Cell[TextData[{
              "reset element ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["}", "MR"],
              " to be ",
              StyleBox["v", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["v", "TI"],
              " "
            }]], Cell[TextData[{
              "reset all elements in row ",
              StyleBox["i", "TI"],
              " to be ",
              StyleBox["v", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "reset elements in row ",
              StyleBox["i", "TI"],
              " to be ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }",
              StyleBox[" ", "TR"]
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[All,", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["v", "TI"],
              " "
            }]], Cell[TextData[{
              "reset all elements in column ",
              StyleBox["j", "TI"],
              " to be ",
              StyleBox["v", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[All,", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "reset elements in column ",
              StyleBox["j", "TI"],
              " to be ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }",
              StyleBox[" ", "TR"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.2"],

Cell["Resetting parts of matrices. ", "Caption",
  CellTags->"S3.7.2"],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S3.7.2", "2.7"}],

Cell[CellGroupData[{

Cell["m = {{a, b}, {c, d}}", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.7.2"],

Cell[BoxData[
    \({{a, b}, {c, d}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.7.2"]
}, Open  ]],

Cell[TextData[{
  "This resets the 2, 2 element to be ",
  StyleBox["x", "MR"],
  ", then shows the whole matrix. "
}], "MathCaption",
  CellTags->{"S3.7.2", "2.8"}],

Cell[CellGroupData[{

Cell["m[[2, 2]] = x; m", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.7.2"],

Cell[BoxData[
    \({{a, b}, {c, x}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.7.2"]
}, Open  ]],

Cell[TextData[{
  "This resets all elements in the second column to be ",
  StyleBox["z", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.2", "2.9"}],

Cell[CellGroupData[{

Cell["m[[All, 2]] = z; m", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.7.2"],

Cell[BoxData[
    \({{a, z}, {c, z}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.7.2"]
}, Open  ]],

Cell["\<\
This separately resets the two elements in the second column. \
\
\>", "MathCaption",
  CellTags->{"S3.7.2", "2.10"}],

Cell[CellGroupData[{

Cell["m[[All, 2]] = {i, j}; m", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.7.2"],

Cell[BoxData[
    \({{a, i}, {c, j}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.7.2"]
}, Open  ]],

Cell["This increments all the values in the second column. ", "MathCaption",
  CellTags->{"S3.7.2", "2.11"}],

Cell[CellGroupData[{

Cell["m[[All, 2]]++; m", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.7.2"],

Cell[BoxData[
    \({{a, 1 + i}, {c, 1 + j}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.7.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.7.3 Scalars, Vectors and Matrices", "Subsection",
  CellTags->{"S3.7.3", "3.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " represents matrices and vectors using lists. Anything that is not a list \
",
  StyleBox["Mathematica", "TI"],
  " considers as a scalar. "
}], "Text",
  CellTags->{"S3.7.3", "3.2"}],

Cell[TextData[{
  "A vector in ",
  StyleBox["Mathematica", "TI"],
  " consists of a list of scalars. A matrix consists of a list of vectors, \
representing each of its rows. In order to be a valid matrix, all the rows \
must be the same length, so that the elements of the matrix effectively form \
a rectangular array.  "
}], "Text",
  CellTags->{"S3.7.3", "3.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["VectorQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["True", "MR"],
              " if ",
              StyleBox["expr", "TI"],
              " has the form of a vector, and ",
              StyleBox["False", "MR"],
              " otherwise "
            }]]},
          {Cell[TextData[{
              StyleBox["MatrixQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["True", "MR"],
              " if ",
              StyleBox["expr", "TI"],
              " has the form of a matrix, and ",
              StyleBox["False", "MR"],
              " otherwise "
            }]]},
          {Cell[TextData[{
              StyleBox["Dimensions[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["a list of the dimensions of a vector or matrix "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.3"],

Cell["\<\
Functions for testing the structure of vectors and matrices. \
\>", \
"Caption",
  CellTags->"S3.7.3"],

Cell[TextData[{
  "The list ",
  StyleBox["{a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c}", "MR"],
  " has the form of a vector. "
}], "MathCaption",
  CellTags->{"S3.7.3", "3.4"}],

Cell[CellGroupData[{

Cell["VectorQ[ {a, b, c} ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.7.3"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.7.3"]
}, Open  ]],

Cell[TextData[{
  "Anything that is not manifestly a list is treated as a scalar, so applying \
",
  StyleBox["VectorQ", "MR"],
  " gives ",
  StyleBox["False", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.3", "3.5"}],

Cell[CellGroupData[{

Cell["VectorQ[ x + y ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.7.3"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.7.3"]
}, Open  ]],

Cell[TextData[{
  "This is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S3.7.3", "3.6"}],

Cell[CellGroupData[{

Cell["Dimensions[ {{a, b, c}, {ap, bp, cp}} ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.7.3"],

Cell[BoxData[
    \({2, 3}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.7.3"]
}, Open  ]],

Cell[TextData[{
  "For a vector, ",
  StyleBox["Dimensions", "MR"],
  " gives a list with a single element equal to the result from ",
  StyleBox["Length", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.3", "3.7"}],

Cell[CellGroupData[{

Cell["Dimensions[ {a, b, c} ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.7.3"],

Cell[BoxData[
    \({3}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.7.3"]
}, Open  ]],

Cell["\<\
This object does not count as a matrix because its rows are of \
different lengths. \
\>", "MathCaption",
  CellTags->{"S3.7.3", "3.8"}],

Cell[CellGroupData[{

Cell["MatrixQ[ {{a, b, c}, {ap, bp}} ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.7.3"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.7.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.7.4 Operations on Scalars, Vectors and Matrices", "Subsection",
  CellTags->{"S3.7.4", "4.1"}],

Cell[TextData[{
  "Most mathematical functions in ",
  StyleBox["Mathematica", "TI"],
  " are set up to apply themselves separately to each element in a list. This \
is true in particular of all functions that carry the attribute ",
  StyleBox["Listable", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.7.4", "4.2"}],

Cell["\<\
A consequence is that most mathematical functions are applied \
element by element to matrices and vectors. \
\>", "Text",
  CellTags->{"S3.7.4", "4.3"}],

Cell[TextData[{
  "The ",
  StyleBox["Log", "MR"],
  " applies itself separately to each element in the vector. "
}], "MathCaption",
  CellTags->{"S3.7.4", "4.4"}],

Cell[CellGroupData[{

Cell["Log[ {a, b, c} ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.7.4"],

Cell[BoxData[
    \({Log[a], Log[b], Log[c]}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.7.4"]
}, Open  ]],

Cell["\<\
The same is true for a matrix, or, for that matter, for any nested \
list. \
\>", "MathCaption",
  CellTags->{"S3.7.4", "4.5"}],

Cell[CellGroupData[{

Cell["Log[ {{a, b}, {c, d}} ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.7.4"],

Cell[BoxData[
    \({{Log[a], Log[b]}, {Log[c], Log[d]}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.7.4"]
}, Open  ]],

Cell[TextData[{
  "The differentiation function ",
  StyleBox["D", "MR"],
  " also applies separately to each element in a list. "
}], "MathCaption",
  CellTags->{"S3.7.4", "4.6"}],

Cell[CellGroupData[{

Cell["D[ {x, x^2, x^3}, x ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.7.4"],

Cell[BoxData[
    \({1, 2\ x, 3\ x\^2}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.7.4"]
}, Open  ]],

Cell["The sum of two vectors is carried out element by element. ", \
"MathCaption",
  CellTags->{"S3.7.4", "4.7"}],

Cell[CellGroupData[{

Cell["{a, b} + {ap, bp}", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.7.4"],

Cell[BoxData[
    \({a + ap, b + bp}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.7.4"]
}, Open  ]],

Cell["\<\
If you try to add two vectors with different lengths, you get an \
error. \
\>", "MathCaption",
  CellTags->{"S3.7.4", "4.8"}],

Cell[CellGroupData[{

Cell["{a, b, c} + {ap, bp}", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.7.4"],

Cell[BoxData[
    \(Thread::"tdlen" \(\(:\)\(\ \)\) 
      "Objects of unequal length in \!\(\(\({a, b, c}\)\) + \(\({ap, \
bp}\)\)\) cannot be combined."\)], "Message",
  CellTags->"S3.7.4"],

Cell[BoxData[
    \({ap, bp} + {a, b, c}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.7.4"]
}, Open  ]],

Cell[TextData[{
  "This adds the scalar ",
  StyleBox["1", "MR"],
  " to each element of the vector. "
}], "MathCaption",
  CellTags->{"S3.7.4", "4.9"}],

Cell[CellGroupData[{

Cell["1 + {a, b}", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.7.4"],

Cell[BoxData[
    \({1 + a, 1 + b}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.7.4"]
}, Open  ]],

Cell[TextData[{
  "Any object that is not manifestly a list is treated as a scalar. Here ",
  StyleBox["c", "MR"],
  " is treated as a scalar, and added separately to each element in the \
vector. "
}], "MathCaption",
  CellTags->{"S3.7.4", "4.10"}],

Cell[CellGroupData[{

Cell["{a, b} + c", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.7.4"],

Cell[BoxData[
    \({a + c, b + c}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.7.4"]
}, Open  ]],

Cell[TextData[{
  "This multiplies each element in the vector by the scalar ",
  StyleBox["k", "MR"],
  ".  "
}], "MathCaption",
  CellTags->{"S3.7.4", "4.11"}],

Cell[CellGroupData[{

Cell["k {a, b}", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.7.4"],

Cell[BoxData[
    \({a\ k, b\ k}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.7.4"]
}, Open  ]],

Cell[TextData[{
  "It is important to realize that ",
  StyleBox["Mathematica", "TI"],
  " treats an object as a vector in a particular operation only if the object \
is explicitly a list at the time when the operation is done. If the object is \
not explicitly a list, ",
  StyleBox["Mathematica", "TI"],
  " always treats it as a scalar. This means that you can get different \
results, depending on whether you assign a particular object to be a list \
before or after you do a particular operation. "
}], "Text",
  CellTags->{"S3.7.4", "4.12"}],

Cell[TextData[{
  "The object ",
  StyleBox["p", "MR"],
  " is treated as a scalar, and added separately to each element in the \
vector. "
}], "MathCaption",
  CellTags->{"S3.7.4", "4.13"}],

Cell[CellGroupData[{

Cell["{a, b} + p", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.7.4"],

Cell[BoxData[
    \({a + p, b + p}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.7.4"]
}, Open  ]],

Cell[TextData[{
  "This is what happens if you now replace ",
  StyleBox["p", "MR"],
  " by the list ",
  StyleBox["{c,", "MR"],
  " ",
  StyleBox["d}", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.4", "4.14"}],

Cell[CellGroupData[{

Cell["% /. p -> {c, d}", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.7.4"],

Cell[BoxData[
    \({{a + c, a + d}, {b + c, b + d}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.7.4"]
}, Open  ]],

Cell[TextData[{
  "You would have got a different result if you had replaced ",
  StyleBox["p", "MR"],
  " by ",
  StyleBox["{c,", "MR"],
  " ",
  StyleBox["d}", "MR"],
  " before you did the first operation. "
}], "MathCaption",
  CellTags->{"S3.7.4", "4.15"}],

Cell[CellGroupData[{

Cell["{a, b} + {c, d}", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.7.4"],

Cell[BoxData[
    \({a + c, b + d}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.7.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.7.5 Multiplying Vectors and Matrices", "Subsection",
  CellTags->{"S3.7.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["c", "TI"],
              " ",
              StyleBox["v", "TI"],
              ",  ",
              StyleBox["c", "TI"],
              " ",
              StyleBox["m", "TI"],
              ",  etc. "
            }]], Cell["multiply each element by a scalar "]},
          {Cell[TextData[{
              StyleBox["v", "TI"],
              StyleBox[".", "MR"],
              StyleBox["v", "TI"],
              ",  ",
              StyleBox["v", "TI"],
              StyleBox[".", "MR"],
              StyleBox["m", "TI"],
              ",  ",
              StyleBox["m", "TI"],
              StyleBox[".", "MR"],
              StyleBox["v", "TI"],
              ",  ",
              StyleBox["m", "TI"],
              StyleBox[".", "MR"],
              StyleBox["m", "TI"],
              ",  etc. "
            }]], Cell["vector and matrix multiplication "]},
          {Cell[TextData[{
              StyleBox["Cross[", "MR"],
              StyleBox["v", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["v", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "vector cross product (also input as ",
              StyleBox["v", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cross]\)], "InlineFormula"],
              " ",
              StyleBox["v", "TI"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["Outer[Times,", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["u", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["outer product "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.5"],

Cell["Different kinds of vector and matrix multiplication. ", "Caption",
  CellTags->"S3.7.5"],

Cell[TextData[{
  "This multiplies each element of the vector by the scalar ",
  StyleBox["k", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.5", "5.2"}],

Cell[CellGroupData[{

Cell["k {a, b, c}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \({a\ k, b\ k, c\ k}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell["\<\
The \[OpenCurlyDoubleQuote]dot\[CloseCurlyDoubleQuote] operator \
gives the scalar product of two vectors. \
\>", "MathCaption",
  CellTags->{"S3.7.5", "5.3"}],

Cell[CellGroupData[{

Cell["{a, b, c} . {ap, bp, cp}", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \(a\ ap + b\ bp + c\ cp\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell["You can also use dot to multiply a matrix by a vector. ", "MathCaption",
  CellTags->{"S3.7.5", "5.4"}],

Cell[CellGroupData[{

Cell["{{a, b}, {c, d}} . {x, y}", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \({a\ x + b\ y, c\ x + d\ y}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell[TextData[{
  "Dot is also the notation for matrix multiplication in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.5", "5.5"}],

Cell[CellGroupData[{

Cell["{{a, b}, {c, d}} . {{1, 2}, {3, 4}}", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \({{a + 3\ b, 2\ a + 4\ b}, {c + 3\ d, 2\ c + 4\ d}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell[TextData[{
  "It is important to realize that you can use \[OpenCurlyDoubleQuote]dot\
\[CloseCurlyDoubleQuote] for both left\[Hyphen] and \
right\[Hyphen]multiplication of vectors by matrices. ",
  StyleBox["Mathematica", "TI"],
  " makes no distinction between \[OpenCurlyDoubleQuote]row\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]column\
\[CloseCurlyDoubleQuote] vectors. Dot carries out whatever operation is \
possible. (In formal terms, ",
  StyleBox["a", "TI"],
  StyleBox[".", "MR"],
  StyleBox["b", "TI"],
  " contracts the last index of the tensor ",
  StyleBox["a", "TI"],
  " with the first index of ",
  StyleBox["b", "TI"],
  ".)  "
}], "Text",
  CellTags->{"S3.7.5", "5.6"}],

Cell[TextData[{
  "Here are definitions for a matrix ",
  StyleBox["m", "MR"],
  " and a vector ",
  StyleBox["v", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.5", "5.7"}],

Cell[CellGroupData[{

Cell["m = {{a, b}, {c, d}} ; v = {x, y}", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \({x, y}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell[TextData[{
  "This left\[Hyphen]multiplies the vector ",
  StyleBox["v", "MR"],
  " by ",
  StyleBox["m", "MR"],
  ". The object ",
  StyleBox["v", "MR"],
  " is effectively treated as a column vector in this case. "
}], "MathCaption",
  CellTags->{"S3.7.5", "5.8"}],

Cell[CellGroupData[{

Cell["m . v", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \({a\ x + b\ y, c\ x + d\ y}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell[TextData[{
  "You can also use dot to right\[Hyphen]multiply ",
  StyleBox["v", "MR"],
  " by ",
  StyleBox["m", "MR"],
  ". Now ",
  StyleBox["v", "MR"],
  " is effectively treated as a row vector. "
}], "MathCaption",
  CellTags->{"S3.7.5", "5.9"}],

Cell[CellGroupData[{

Cell["v . m", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \({a\ x + c\ y, b\ x + d\ y}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell[TextData[{
  "You can multiply ",
  StyleBox["m", "MR"],
  " by ",
  StyleBox["v", "MR"],
  " on both sides, to get a scalar. "
}], "MathCaption",
  CellTags->{"S3.7.5", "5.10"}],

Cell[CellGroupData[{

Cell["v . m . v", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \(x\ \((a\ x + c\ y)\) + y\ \((b\ x + d\ y)\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell["\<\
For some purposes, you may need to represent vectors and matrices \
symbolically, without explicitly giving their elements. You can use dot to \
represent multiplication of such symbolic objects.  \
\>", "Text",
  CellTags->{"S3.7.5", "5.11"}],

Cell["\<\
Dot effectively acts here as a non\[Hyphen]commutative form of \
multiplication. \
\>", "MathCaption",
  CellTags->{"S3.7.5", "5.12"}],

Cell[CellGroupData[{

Cell["a . b . a", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \(a . b . a\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell["It is, nevertheless, associative. ", "MathCaption",
  CellTags->{"S3.7.5", "5.13"}],

Cell[CellGroupData[{

Cell["(a . b) . (a . b)", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \(a . b . a . b\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell["Dot products of sums are not automatically expanded out. ", \
"MathCaption",
  CellTags->{"S3.7.5", "5.14"}],

Cell[CellGroupData[{

Cell["(a + b) . c . (d + e)", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \(\((a + b)\) . c . \((d + e)\)\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell[TextData[{
  "You can apply the distributive law in this case using the function ",
  StyleBox["Distribute", "MR"],
  ", as discussed in Section\[NonBreakingSpace]",
  ButtonBox["2.2.10",
    ButtonData:>{"2.2.10", "10.10"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.5", "5.15"}],

Cell[CellGroupData[{

Cell["Distribute[ % ]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \(a . c . d + a . c . e + b . c . d + b . c . e\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell[TextData[{
  "The \[OpenCurlyDoubleQuote]dot\[CloseCurlyDoubleQuote] operator gives \
\[OpenCurlyDoubleQuote]inner products\[CloseCurlyDoubleQuote] of vectors, \
matrices, and so on. In more advanced calculations, you may also need to \
construct outer or Kronecker products of vectors and matrices. You can use \
the general function ",
  StyleBox["Outer", "MR"],
  " to do this."
}], "Text",
  CellTags->{"S3.7.5", "5.16"}],

Cell["The outer product of two vectors is a matrix. ", "MathCaption",
  CellTags->{"S3.7.5", "5.17"}],

Cell[CellGroupData[{

Cell["Outer[Times, {a, b}, {c, d}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \({{a\ c, a\ d}, {b\ c, b\ d}}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell["\<\
The outer product of a matrix and a vector is a rank three tensor.  \
\
\>", "MathCaption",
  CellTags->{"S3.7.5", "5.18"}],

Cell[CellGroupData[{

Cell["Outer[Times, {{1, 2}, {3, 4}}, {x, y, z}]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.7.5"],

Cell[BoxData[
    \({{{x, y, z}, {2\ x, 2\ y, 2\ z}}, {{3\ x, 3\ y, 3\ z}, {4\ x, 4\ y, 
          4\ z}}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.7.5"]
}, Open  ]],

Cell[TextData[{
  "Outer products will be discussed in more detail in Section ",
  ButtonBox["3.7.11",
    ButtonData:>{"3.7.11", "11.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S3.7.5", "5.19"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.7.6 Matrix Inversion", "Subsection",
  CellTags->{"S3.7.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Inverse[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["find the inverse of a square matrix "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.6"],

Cell["Matrix inversion. ", "Caption",
  CellTags->"S3.7.6"],

Cell[TextData[{
  "Here is a simple ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S3.7.6", "6.2"}],

Cell[CellGroupData[{

Cell["m = {{a, b}, {c, d}}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \({{a, b}, {c, d}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell[TextData[{
  "This gives the inverse of ",
  StyleBox["m", "MR"],
  ". In producing this formula, ",
  StyleBox["Mathematica", "TI"],
  " implicitly assumes that the determinant ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["d", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["b", "MR"],
  " ",
  StyleBox["c", "MR"],
  " is non\[Hyphen]zero.  "
}], "MathCaption",
  CellTags->{"S3.7.6", "6.3"}],

Cell[CellGroupData[{

Cell["Inverse[ m ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \({{d\/\(\(-b\)\ c + a\ d\), \(-\(b\/\(\(-b\)\ c + 
                a\ d\)\)\)}, {\(-\(c\/\(\(-b\)\ c + a\ d\)\)\), 
        a\/\(\(-b\)\ c + a\ d\)}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell["\<\
Multiplying the inverse by the original matrix should give the \
identity matrix. \
\>", "MathCaption",
  CellTags->{"S3.7.6", "6.4"}],

Cell[CellGroupData[{

Cell["% . m", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \({{\(-\(\(b\ c\)\/\(\(-b\)\ c + 
                  a\ d\)\)\) + \(a\ d\)\/\(\(-b\)\ c + a\ d\), 
        0}, {0, \(-\(\(b\ c\)\/\(\(-b\)\ c + 
                  a\ d\)\)\) + \(a\ d\)\/\(\(-b\)\ c + a\ d\)}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell[TextData[{
  "You have to use ",
  StyleBox["Together", "MR"],
  " to clear the denominators, and get back a standard identity matrix. "
}], "MathCaption",
  CellTags->{"S3.7.6", "6.5"}],

Cell[CellGroupData[{

Cell["Together[ % ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \({{1, 0}, {0, 1}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell["Here is a matrix of rational numbers. ", "MathCaption",
  CellTags->{"S3.7.6", "6.6"}],

Cell[CellGroupData[{

Cell["hb = Table[1/(i + j), {i, 4}, {j, 4}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \({{1\/2, 1\/3, 1\/4, 1\/5}, {1\/3, 1\/4, 1\/5, 1\/6}, {1\/4, 1\/5, 1\/6, 
        1\/7}, {1\/5, 1\/6, 1\/7, 1\/8}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " finds the exact inverse of the matrix. "
}], "MathCaption",
  CellTags->{"S3.7.6", "6.7"}],

Cell[CellGroupData[{

Cell["Inverse[hb]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \({{200, \(-1200\), 2100, \(-1120\)}, {\(-1200\), 8100, \(-15120\), 
        8400}, {2100, \(-15120\), 29400, \(-16800\)}, {\(-1120\), 
        8400, \(-16800\), 9800}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell["\<\
Multiplying by the original matrix gives the identity matrix. \
\
\>", "MathCaption",
  CellTags->{"S3.7.6", "6.8"}],

Cell[CellGroupData[{

Cell["% . hb", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \({{1, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell[TextData[{
  "If you try to invert a singular matrix, ",
  StyleBox["Mathematica", "TI"],
  " prints a warning message, and returns the inverse undone.  "
}], "MathCaption",
  CellTags->{"S3.7.6", "6.9"}],

Cell[CellGroupData[{

Cell["Inverse[ {{1, 2}, {1, 2}} ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \(Inverse::"sing" \(\(:\)\(\ \)\) 
      "Matrix \!\({\(\({1, 2}\)\), \(\({1, 2}\)\)}\) is singular."\)], \
"Message",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \(Inverse[{{1, 2}, {1, 2}}]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell[TextData[{
  "If you give a matrix with exact symbolic or numerical entries, ",
  StyleBox["Mathematica", "TI"],
  " gives the exact inverse. If, on the other hand, some of the entries in \
your matrix are approximate real numbers, then ",
  StyleBox["Mathematica", "TI"],
  " finds an approximate numerical result. "
}], "Text",
  CellTags->{"S3.7.6", "6.10"}],

Cell["Here is a matrix containing approximate real numbers. ", "MathCaption",
  CellTags->{"S3.7.6", "6.11"}],

Cell[CellGroupData[{

Cell["m = {{1.2, 5.7}, {4.2, 5.6}}", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \({{1.2`, 5.7`}, {4.2`, 5.6`}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell["This finds the numerical inverse. ", "MathCaption",
  CellTags->{"S3.7.6", "6.12"}],

Cell[CellGroupData[{

Cell["Inverse[ % ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \({{\(-0.32520325203252026`\), 
        0.3310104529616724`}, {0.2439024390243902`, \
\(-0.06968641114982577`\)}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell["\<\
Multiplying by the original matrix gives you an identity matrix \
with small numerical errors. \
\>", "MathCaption",
  CellTags->{"S3.7.6", "6.13"}],

Cell[CellGroupData[{

Cell["% . m", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \({{1.`, 0.`}, {0.`, 1.`}}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell[TextData[{
  "You can get rid of the small off\[Hyphen]diagonal terms using ",
  StyleBox["Chop", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.6", "6.14"}],

Cell[CellGroupData[{

Cell["Chop[ % ]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \({{1.`, 0}, {0, 1.`}}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell[TextData[{
  "When you try to invert a matrix with exact numerical entries, ",
  StyleBox["Mathematica", "TI"],
  " can always tell whether or not the matrix is singular. When you invert an \
approximate numerical matrix, ",
  StyleBox["Mathematica", "TI"],
  " can usually not tell for certain whether or not the matrix is singular: \
all it can tell is for example that the determinant is small compared to the \
entries of the matrix. When ",
  StyleBox["Mathematica", "TI"],
  " suspects that you are trying to invert a singular numerical matrix, it \
prints a warning.  "
}], "Text",
  CellTags->{"S3.7.6", "6.15"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " prints a warning if you invert a numerical matrix that it suspects is \
singular. "
}], "MathCaption",
  CellTags->{"S3.7.6", "6.16"}],

Cell[CellGroupData[{

Cell["Inverse[ {{1., 2.}, {1., 2.}} ]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \(Inverse::"sing" \(\(:\)\(\ \)\) 
      "Matrix \!\({\(\({1.`, 2.`}\)\), \(\({1.`, 2.`}\)\)}\) is \
singular."\)], "Message",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \(Inverse[{{1.`, 2.`}, {1.`, 2.`}}]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell[TextData[{
  "If you work with high\[Hyphen]precision approximate numbers, ",
  StyleBox["Mathematica", "TI"],
  " will keep track of the precision of matrix inverses that you generate.  "
}], "Text",
  CellTags->{"S3.7.6", "6.17"}],

Cell[TextData[{
  "This generates a ",
  Cell[BoxData[
      \(TraditionalForm\`6\[Cross]6\)], "InlineFormula"],
  " numerical matrix with entries of 20\[Hyphen]digit precision. "
}], "MathCaption",
  CellTags->{"S3.7.6", "6.18"}],

Cell["m = N [ Table[ GCD[i, j] + 1, {i, 6}, {j, 6} ], 20 ] ;", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.7.6"],

Cell["\<\
This takes the matrix, multiplies it by its inverse, and shows the \
first row of the result. \
\>", "MathCaption",
  CellTags->{"S3.7.6", "6.19"}],

Cell[CellGroupData[{

Cell["(m . Inverse[m]) [[1]]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \({1.`18.619788758288397, 0``18.69897000433602, 0``18.92081875395238, 
      0``19.397940008672037, 0``19.69897000433602, 
      0``19.096910013008056}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell[TextData[{
  "This generates a 20\[Hyphen]digit numerical approximation to a ",
  Cell[BoxData[
      \(TraditionalForm\`6\[Cross]6\)], "InlineFormula"],
  " Hilbert matrix. Hilbert matrices are notoriously hard to invert \
numerically. "
}], "MathCaption",
  CellTags->{"S3.7.6", "6.20"}],

Cell["m = N[Table[1/(i + j - 1), {i, 6}, {j, 6}], 20] ;", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.7.6"],

Cell["\<\
The result is still correct, but the zeros now have lower accuracy. \
\
\>", "MathCaption",
  CellTags->{"S3.7.6", "6.21"}],

Cell[CellGroupData[{

Cell["(m . Inverse[m]) [[1]]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.7.6"],

Cell[BoxData[
    \({1.0000000000000000000000000001`15.971835580575531, 
      0``14.527946008550298, 0``13.704283396534018, 0``13.293534847446104, 
      0``13.253814336585796, 0``13.660680556570677}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.7.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Inverse", "MR"],
  " works only on square matrices. Section ",
  ButtonBox["3.7.10",
    ButtonData:>{"3.7.10", "10.7"},
    ButtonStyle->"MainBookLink"],
  " discusses the function ",
  StyleBox["PseudoInverse", "MR"],
  ", which can also be used with non\[Hyphen]square matrices. "
}], "Text",
  CellTags->{"S3.7.6", "6.22"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.7.7 Basic Matrix Operations", "Subsection",
  CellTags->{"S3.7.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Transpose[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "transpose ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["m",
                        "TI"], "\[Transpose]"], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ConjugateTranspose[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "conjugate transpose ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["m",
                        "TI"], "\[ConjugateTranspose]"], TraditionalForm]], 
                "InlineFormula"],
              " (Hermitian conjugate) "
            }]]},
          {Cell[TextData[{
              StyleBox["Inverse[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["matrix inverse "]},
          {Cell[TextData[{
              StyleBox["Det[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["determinant "]},
          {Cell[TextData[{
              StyleBox["Minors[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["matrix of minors "]},
          {Cell[TextData[{
              StyleBox["Minors[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    StyleBox["k",
                      "TI"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " minors "
            }]]},
          {Cell[TextData[{
              StyleBox["Tr[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["trace "]},
          {Cell[TextData[{
              StyleBox["CharacteristicPolynomial[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["characteristic polynomial "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.7"],

Cell["Some basic matrix operations. ", "Caption",
  CellTags->"S3.7.7"],

Cell[TextData[{
  "Transposing a matrix interchanges the rows and columns in the matrix. If \
you transpose an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "\[Cross]", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " matrix, you get an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "\[Cross]", 
          StyleBox["m",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " matrix as the result. "
}], "Text",
  CellTags->{"S3.7.7", "7.2"}],

Cell[TextData[{
  "Transposing a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\)], "InlineFormula"],
  " matrix gives a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]2\)], "InlineFormula"],
  " result. "
}], "MathCaption",
  CellTags->{"S3.7.7", "7.3"}],

Cell[CellGroupData[{

Cell["Transpose[ {{a, b, c}, {ap, bp, cp}} ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.7.7"],

Cell[BoxData[
    \({{a, ap}, {b, bp}, {c, cp}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.7.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Det[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " gives the determinant of a square matrix ",
  StyleBox["m", "TI"],
  ". ",
  StyleBox["Minors[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " is the matrix whose ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            StyleBox["i",
              "TI"], ",", 
            StyleBox["j",
              "TI"]}], ")"}], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " element gives the determinant of the submatrix obtained by deleting the \
",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            StyleBox["n",
              "TI"], "-", 
            StyleBox["i",
              "TI"], "+", "1"}], ")"}], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " row and the ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            StyleBox["n",
              "TI"], "-", 
            StyleBox["j",
              "TI"], "+", "1"}], ")"}], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " column of ",
  StyleBox["m", "TI"],
  ". The ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            StyleBox["i",
              "TI"], ",", 
            StyleBox["j",
              "TI"]}], ")"}], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " cofactor of ",
  StyleBox["m", "TI"],
  " is ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[\((\(-1\))\), 
          RowBox[{
            StyleBox["i",
              "TI"], "+", 
            StyleBox["j",
              "TI"]}]], TraditionalForm]], "InlineFormula"],
  " times the ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            StyleBox["n",
              "TI"], "-", 
            StyleBox["i",
              "TI"], "+", "1", ",", 
            StyleBox["n",
              "TI"], "-", 
            StyleBox["j",
              "TI"], "+", "1"}], ")"}], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " element of the matrix of minors. "
}], "Text",
  CellTags->{"S3.7.7", "7.4"}],

Cell[TextData[{
  StyleBox["Minors[", "MR"],
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["k", "TI"],
  StyleBox["]", "MR"],
  " gives the determinants of the ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k",
            "TI"], "\[Cross]", 
          StyleBox["k",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " submatrices obtained by picking each possible set of ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " rows and ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " columns from ",
  StyleBox["m", "TI"],
  ". Note that you can apply ",
  StyleBox["Minors", "MR"],
  " to rectangular, as well as square, matrices. "
}], "Text",
  CellTags->{"S3.7.7", "7.5"}],

Cell[TextData[{
  "Here is the determinant of a simple ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S3.7.7", "7.6"}],

Cell[CellGroupData[{

Cell["Det[ {{a, b}, {c, d}} ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.7.7"],

Cell[BoxData[
    \(\(-b\)\ c + a\ d\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.7.7"]
}, Open  ]],

Cell[TextData[{
  "This generates a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]3\)], "InlineFormula"],
  " matrix, whose ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["i",
            "TI"], ",", 
          StyleBox["j",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " entry is ",
  StyleBox["a[", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["j", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.7", "7.7"}],

Cell[CellGroupData[{

Cell["m = Array[a, {3, 3}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.7.7"],

Cell[BoxData[
    \({{a[1, 1], a[1, 2], a[1, 3]}, {a[2, 1], a[2, 2], a[2, 3]}, {a[3, 1], 
        a[3, 2], a[3, 3]}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.7.7"]
}, Open  ]],

Cell[TextData[{
  "Here is the determinant of ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.7", "7.8"}],

Cell[CellGroupData[{

Cell["Det[ m ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.7.7"],

Cell[BoxData[
    \(\(-a[1, 3]\)\ a[2, 2]\ a[3, 1] + a[1, 2]\ a[2, 3]\ a[3, 1] + 
      a[1, 3]\ a[2, 1]\ a[3, 2] - a[1, 1]\ a[2, 3]\ a[3, 2] - 
      a[1, 2]\ a[2, 1]\ a[3, 3] + a[1, 1]\ a[2, 2]\ a[3, 3]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.7.7"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["trace", "TI"],
  " or ",
  StyleBox["spur", "TI"],
  " of a matrix ",
  StyleBox["Tr[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " is the sum of the terms on the leading diagonal.   "
}], "Text",
  CellTags->{"S3.7.7", "7.9"}],

Cell[TextData[{
  "This finds the trace of a simple ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S3.7.7", "7.10"}],

Cell[CellGroupData[{

Cell["Tr[{{a, b}, {c, d}}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.7.7"],

Cell[BoxData[
    \(a + d\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.7.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MatrixPower[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " matrix power "
            }]]},
          {Cell[TextData[{
              StyleBox["MatrixExp[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["matrix exponential "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.7"],

Cell["Powers and exponentials of matrices. ", "Caption",
  CellTags->"S3.7.7"],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S3.7.7", "7.11"}],

Cell[CellGroupData[{

Cell["m = {{0.4, 0.6}, {0.525, 0.475}}", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.7.7"],

Cell[BoxData[
    \({{0.4`, 0.6`}, {0.525`, 0.475`}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.7.7"]
}, Open  ]],

Cell[TextData[{
  "This gives the third matrix power of ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.7", "7.12"}],

Cell[CellGroupData[{

Cell["MatrixPower[m, 3]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.7.7"],

Cell[BoxData[
    \({{0.46562499999999996`, 0.534375`}, {0.467578125`, 
        0.5324218749999999`}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.7.7"]
}, Open  ]],

Cell["It is equivalent to multiplying three copies of the matrix. ", \
"MathCaption",
  CellTags->{"S3.7.7", "7.13"}],

Cell[CellGroupData[{

Cell["m . m . m", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.7.7"],

Cell[BoxData[
    \({{0.46562499999999996`, 0.534375`}, {0.46757812500000007`, 
        0.5324218749999999`}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.7.7"]
}, Open  ]],

Cell["Here is the millionth matrix power. ", "MathCaption",
  CellTags->{"S3.7.7", "7.14"}],

Cell[CellGroupData[{

Cell["MatrixPower[m, 10^6]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.7.7"],

Cell[BoxData[
    \({{0.466666666663054`, 0.5333333333292046`}, {0.466666666663054`, 
        0.5333333333292046`}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.7.7"]
}, Open  ]],

Cell[TextData[{
  "This gives the matrix exponential of ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.7", "7.15"}],

Cell[CellGroupData[{

Cell["MatrixExp[m]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.7.7"],

Cell[BoxData[
    \({{1.7391965346593388`, 0.9790852937997064`}, {0.8566996320747433`, 
        1.861582196384302`}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.7.7"]
}, Open  ]],

Cell[TextData[{
  "Here is an approximation to the exponential of ",
  StyleBox["m", "MR"],
  ", based on a power series approximation. "
}], "MathCaption",
  CellTags->{"S3.7.7", "7.16"}],

Cell[CellGroupData[{

Cell["Sum[MatrixPower[m, i]/i!, {i, 0, 5}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.7.7"],

Cell[BoxData[
    \({{1.7384427897135417`, 0.978223876953125`}, {0.8559458923339844`, 
        1.8607207743326821`}}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.7.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.7.8 Solving Linear Systems", "Subsection",
  CellTags->{"S3.7.8", "8.1"}],

Cell[TextData[{
  "Many calculations involve solving systems of linear equations. In many \
cases, you will find it convenient to write down the equations explicitly, \
and then solve them using ",
  StyleBox["Solve", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.7.8", "8.2"}],

Cell["\<\
In some cases, however, you may prefer to convert the system of \
linear equations into a matrix equation, and then apply matrix manipulation \
operations to solve it. This approach is often useful when the system of \
equations arises as part of a general algorithm, and you do not know in \
advance how many variables will be involved. \
\>", "Text",
  CellTags->{"S3.7.8", "8.3"}],

Cell[TextData[{
  "A system of linear equations can be stated in matrix form as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          StyleBox["x",
            "TB"], "=", 
          StyleBox["b",
            "TB"]}], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TB"], TraditionalForm]], "InlineFormula"],
  " is the vector of variables. "
}], "Text",
  CellTags->{"S3.7.8", "8.4"}],

Cell[TextData[{
  "Note that if your system of equations is sparse, so that most of the \
entries in the matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " are zero, then it is best to represent the matrix as a ",
  StyleBox["SparseArray", "MR"],
  " object. As discussed in Section\[NonBreakingSpace]",
  ButtonBox["3.7.12",
    ButtonData:>{"3.7.12", "12.13"},
    ButtonStyle->"MainBookLink"],
  ", you can convert from symbolic equations to ",
  StyleBox["SparseArray", "MR"],
  " objects using ",
  StyleBox["CoefficientArrays", "MR"],
  ". All the functions described in this section work on ",
  StyleBox["SparseArray", "MR"],
  " objects as well as ordinary matrices. "
}], "Text",
  CellTags->{"S3.7.8", "8.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LinearSolve[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a vector ",
              StyleBox["x", "TI"],
              " which solves the matrix equation ",
              StyleBox["m", "TI"],
              StyleBox[".", "MR"],
              StyleBox["x", "TI"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["b", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NullSpace[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "a list of basis vectors whose linear combinations satisfy the \
matrix equation ",
              StyleBox["m", "TI"],
              StyleBox[".", "MR"],
              StyleBox["x", "TI"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["0", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MatrixRank[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the number of linearly independent rows of ",
              StyleBox["m", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["RowReduce[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a simplified form of ",
              StyleBox["m", "TI"],
              " obtained by making linear combinations of rows "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.8"],

Cell["Solving and analyzing linear systems. ", "Caption",
  CellTags->"S3.7.8"],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.6"}],

Cell[CellGroupData[{

Cell["m = {{1, 5}, {2, 1}}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({{1, 5}, {2, 1}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell["This gives two linear equations. ", "MathCaption",
  CellTags->{"S3.7.8", "8.7"}],

Cell[CellGroupData[{

Cell["m . {x, y} == {a, b}", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({x + 5\ y, 2\ x + y} \[Equal] {a, b}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Solve", "MR"],
  " directly to solve these equations. "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.8"}],

Cell[CellGroupData[{

Cell["Solve[ %, {x, y} ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({{x \[Rule] 1\/9\ \((\(-a\) + 5\ b)\), 
        y \[Rule] 1\/9\ \((2\ a - b)\)}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "You can also get the vector of solutions by calling ",
  StyleBox["LinearSolve", "MR"],
  ". The result is equivalent to the one you get from ",
  StyleBox["Solve", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.9"}],

Cell[CellGroupData[{

Cell["LinearSolve[m, {a, b}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({1\/9\ \((\(-a\) + 5\ b)\), 1\/9\ \((2\ a - b)\)}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "Another way to solve the equations is to invert the matrix ",
  StyleBox["m", "MR"],
  ", and then multiply ",
  StyleBox["{a,", "MR"],
  " ",
  StyleBox["b}", "MR"],
  " by the inverse. This is not as efficient as using ",
  StyleBox["LinearSolve", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.10"}],

Cell[CellGroupData[{

Cell["Inverse[m] . {a, b}", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({\(-\(a\/9\)\) + \(5\ b\)\/9, \(2\ a\)\/9 - b\/9}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["RowReduce", "MR"],
  " performs a version of Gaussian elimination and can also be used to solve \
the equations. "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.11"}],

Cell[CellGroupData[{

Cell["RowReduce[{{1, 5, a}, {2, 1, b}}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({{1, 0, 1\/9\ \((\(-a\) + 5\ b)\)}, {0, 1, 
        1\/9\ \((2\ a - b)\)}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "If you have a square matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " with a non\[Hyphen]zero determinant, then you can always find a unique \
solution to the matrix equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          StyleBox["x",
            "TB"], "=", 
          StyleBox["b",
            "TB"]}], TraditionalForm]], "InlineFormula"],
  " for any ",
  Cell[BoxData[
      FormBox[
        StyleBox["b",
          "TB"], TraditionalForm]], "InlineFormula"],
  ". If, however, the matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " has determinant zero, then there may be either no vector, or an infinite \
number of vectors ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TB"], TraditionalForm]], "InlineFormula"],
  " which satisfy ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          StyleBox["x",
            "TB"], "=", 
          StyleBox["b",
            "TB"]}], TraditionalForm]], "InlineFormula"],
  " for a particular ",
  Cell[BoxData[
      FormBox[
        StyleBox["b",
          "TB"], TraditionalForm]], "InlineFormula"],
  ". This occurs when the linear equations embodied in ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " are not independent.  "
}], "Text",
  CellTags->{"S3.7.8", "8.12"}],

Cell[TextData[{
  "When ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " has determinant zero, it is nevertheless always possible to find non\
\[Hyphen]zero vectors ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TB"], TraditionalForm]], "InlineFormula"],
  " that satisfy ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          StyleBox["x",
            "TB"], "=", 
          StyleBox["0",
            "TB"]}], TraditionalForm]], "InlineFormula"],
  ". The set of vectors ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TB"], TraditionalForm]], "InlineFormula"],
  " satisfying this equation form the ",
  StyleBox["null space", "TI"],
  " or ",
  StyleBox["kernel", "TI"],
  " of the matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  ". Any of these vectors can be expressed as a linear combination of a \
particular set of basis vectors, which can be obtained using ",
  StyleBox["NullSpace[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.7.8", "8.13"}],

Cell["\<\
Here is a simple matrix, corresponding to two identical linear \
equations. \
\>", "MathCaption",
  CellTags->{"S3.7.8", "8.14"}],

Cell[CellGroupData[{

Cell["m = {{1, 2}, {1, 2}}", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({{1, 2}, {1, 2}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell["The matrix has determinant zero. ", "MathCaption",
  CellTags->{"S3.7.8", "8.15"}],

Cell[CellGroupData[{

Cell["Det[ m ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["LinearSolve", "MR"],
  " cannot find a solution to the equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          StyleBox["x",
            "TB"], "=", 
          StyleBox["b",
            "TB"]}], TraditionalForm]], "InlineFormula"],
  " in this case. "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.16"}],

Cell[CellGroupData[{

Cell["LinearSolve[m, {a, b}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \(LinearSolve::"nosol" \(\(:\)\(\ \)\) 
      "Linear equation encountered which has no solution."\)], "Message",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \(LinearSolve[{{1, 2}, {1, 2}}, {a, b}]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "There is a single basis vector for the null space of ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.17"}],

Cell[CellGroupData[{

Cell["NullSpace[ m ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({{\(-2\), 1}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "Multiplying the basis vector for the null space by ",
  StyleBox["m", "MR"],
  " gives the zero vector. "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.18"}],

Cell[CellGroupData[{

Cell["m . %[[1]]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({0, 0}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "There is only ",
  StyleBox["1", "MR"],
  " linearly independent row in ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.19"}],

Cell[CellGroupData[{

Cell["MatrixRank[ m ]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NullSpace", "MR"],
  " and ",
  StyleBox["MatrixRank", "MR"],
  " have to determine whether particular combinations of matrix elements are \
zero. For approximate numerical matrices, the ",
  StyleBox["Tolerance", "MR"],
  " option can be used to specify how close to zero is considered good \
enough. For exact symbolic matrices, you may sometimes need to specify \
something like ",
  StyleBox["ZeroTest->(FullSimplify[#]==0&)", "MR"],
  " to force more to be done to test whether symbolic expressions are zero.  \
"
}], "Text",
  CellTags->{"S3.7.8", "8.20"}],

Cell["Here is a simple symbolic matrix with determinant zero. ", "MathCaption",
  CellTags->{"S3.7.8", "8.21"}],

Cell[CellGroupData[{

Cell["m = {{a, b, c}, {2 a, 2 b, 2 c}, {3 a, 3 b, 3 c}}", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({{a, b, c}, {2\ a, 2\ b, 2\ c}, {3\ a, 3\ b, 3\ c}}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "The basis for the null space of ",
  StyleBox["m", "MR"],
  " contains two vectors. "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.22"}],

Cell[CellGroupData[{

Cell["NullSpace[m]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({{\(-\(c\/a\)\), 0, 1}, {\(-\(b\/a\)\), 1, 0}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "Multiplying ",
  StyleBox["m", "MR"],
  " by any linear combination of these vectors gives zero. "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.23"}],

Cell[CellGroupData[{

Cell["Simplify[m . (x %[[1]] + y %[[2]])]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({0, 0, 0}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "An important feature of functions like ",
  StyleBox["LinearSolve", "MR"],
  " and ",
  StyleBox["NullSpace", "MR"],
  " is that they work with ",
  StyleBox["rectangular", "TI"],
  ", as well as ",
  StyleBox["square", "TI"],
  ", matrices.  "
}], "Text",
  CellTags->{"S3.7.8", "8.24"}],

Cell[TextData[{
  "When you represent a system of linear equations by a matrix equation of \
the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          StyleBox["x",
            "TB"], "=", 
          StyleBox["b",
            "TB"]}], TraditionalForm]], "InlineFormula"],
  ", the number of columns in ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " gives the number of variables, and the number of rows gives the number of \
equations. There are a number of cases. "
}], "Text",
  CellTags->{"S3.7.8", "8.25"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Underdetermined", "TI"],
              " "
            }]], 
            Cell["\<\
number of equations less than the number of variables; \
no solutions or many solutions may exist \
\>"]},
          {Cell[TextData[{
              StyleBox["Overdetermined", "TI"],
              " "
            }]], 
            Cell["\<\
number of equations more than the number of variables; \
solutions may or may not exist \
\>"]},
          {Cell[TextData[{
              StyleBox["Nonsingular", "TI"],
              " "
            }]], 
            Cell["\<\
number of independent equations equal to the number of \
variables, and determinant non\[Hyphen]zero; a unique solution exists\
\>"]},
          {Cell[TextData[{
              StyleBox["Consistent", "TI"],
              " "
            }]], Cell["at least one solution exists "]},
          {Cell[TextData[{
              StyleBox["Inconsistent", "TI"],
              " "
            }]], Cell["no solutions exist "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S3.7.8"],

Cell["\<\
Classes of linear systems represented by rectangular matrices. \
\
\>", "Caption",
  CellTags->"S3.7.8"],

Cell[TextData[{
  "This asks for the solution to the inconsistent set of equations ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.26"}],

Cell[CellGroupData[{

Cell["LinearSolve[{{1}, {1}}, {1, 0}]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \(LinearSolve::"nosol" \(\(:\)\(\ \)\) 
      "Linear equation encountered which has no solution."\)], "Message",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \(LinearSolve[{{1}, {1}}, {1, 0}]\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell["This matrix represents two equations, for three variables. ", \
"MathCaption",
  CellTags->{"S3.7.8", "8.27"}],

Cell[CellGroupData[{

Cell["m = {{1, 3, 4}, {2, 1, 3}}", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({{1, 3, 4}, {2, 1, 3}}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["LinearSolve", "MR"],
  " gives one of the possible solutions to this underdetermined set of \
equations. "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.28"}],

Cell[CellGroupData[{

Cell["v = LinearSolve[m, {1, 1}]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({2\/5, 1\/5, 0}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell["\<\
When a matrix represents an underdetermined system of equations, \
the matrix has a non\[Hyphen]trivial null space. In this case, the null space \
is spanned by a single vector. \
\>", "MathCaption",
  CellTags->{"S3.7.8", "8.29"}],

Cell[CellGroupData[{

Cell["NullSpace[m]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({{\(-1\), \(-1\), 1}}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "If you take the solution you get from ",
  StyleBox["LinearSolve", "MR"],
  ", and add any linear combination of the basis vectors for the null space, \
you still get a solution. "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.30"}],

Cell[CellGroupData[{

Cell["m . (v + 4 %[[1]])", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({1, 1}\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "The number of independent equations is the ",
  StyleBox["rank", "TI"],
  " of the matrix ",
  StyleBox["MatrixRank[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  ". The number of redundant equations is ",
  StyleBox["Length[NullSpace[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]]", "MR"],
  ". Note that the sum of these quantities is always equal to the number of \
columns in ",
  StyleBox["m", "TI"],
  ".   "
}], "Text",
  CellTags->{"S3.7.8", "8.31"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LinearSolve[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate a function for solving equations of the form ",
              StyleBox["m", "TI"],
              " ",
              StyleBox[".", "MR"],
              " ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["b", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.8"],

Cell[TextData[{
  "Generating ",
  StyleBox["LinearSolveFunction", "MR"],
  " objects. "
}], "Caption",
  CellTags->"S3.7.8"],

Cell[TextData[{
  "In some applications, you will want to solve equations of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          StyleBox["x",
            "TB"], "=", 
          StyleBox["b",
            "TB"]}], TraditionalForm]], "InlineFormula"],
  " many times with the same ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  ", but different ",
  Cell[BoxData[
      FormBox[
        StyleBox["b",
          "TB"], TraditionalForm]], "InlineFormula"],
  ". You can do this efficiently in ",
  StyleBox["Mathematica", "TI"],
  " by using ",
  StyleBox["LinearSolve[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " to create a single ",
  StyleBox["LinearSolveFunction", "MR"],
  " that you can apply to as many vectors as you want. "
}], "Text",
  CellTags->{"S3.7.8", "8.32"}],

Cell[TextData[{
  "This creates a ",
  StyleBox["LinearSolveFunction", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.33"}],

Cell[CellGroupData[{

Cell["f = LinearSolve[{{1, 4}, {2, 3}}]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    TagBox[\(LinearSolveFunction[{2, 2}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell["You can apply this to a vector. ", "MathCaption",
  CellTags->{"S3.7.8", "8.34"}],

Cell[CellGroupData[{

Cell["f[{5, 7}]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({13\/5, 3\/5}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "You get the same result by giving the vector as an explicit argument to ",
  StyleBox["LinearSolve", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.35"}],

Cell[CellGroupData[{

Cell["LinearSolve[{{1, 4}, {2, 3}}, {5, 7}]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({13\/5, 3\/5}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.7.8"]
}, Open  ]],

Cell[TextData[{
  "But you can apply ",
  StyleBox["f", "MR"],
  " to any vector you want. "
}], "MathCaption",
  CellTags->{"S3.7.8", "8.36"}],

Cell[CellGroupData[{

Cell["f[{-5, 9}]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.7.8"],

Cell[BoxData[
    \({51\/5, \(-\(19\/5\)\)}\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.7.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.7.9 Eigenvalues and Eigenvectors", "Subsection",
  CellTags->{"S3.7.9", "9.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Eigenvalues[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a list of the eigenvalues of ",
              StyleBox["m", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Eigenvectors[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a list of the eigenvectors of ",
              StyleBox["m", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Eigensystem[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a list of the form ",
              StyleBox["{", "MR"],
              StyleBox["eigenvalues", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["eigenvectors", "TI"],
              StyleBox["}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Eigenvalues[", "MR"],
              " ",
              StyleBox["N[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["]", "MR"],
              ",  etc. "
            }]], Cell["numerical eigenvalues "]},
          {Cell[TextData[{
              StyleBox["Eigenvalues[", "MR"],
              " ",
              StyleBox["N[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["p", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["]", "MR"],
              ",  etc. "
            }]], Cell[TextData[{
              "numerical eigenvalues, starting with ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["p",
                      "TI"], TraditionalForm]], "InlineFormula"],
              "\[Hyphen]digit precision "
            }]]},
          {Cell[TextData[{
              StyleBox["CharacteristicPolynomial[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the characteristic polynomial of ",
              StyleBox["m", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.9"],

Cell["Eigenvalues and eigenvectors. ", "Caption",
  CellTags->"S3.7.9"],

Cell[TextData[{
  "The eigenvalues of a matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " are the values ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Lambda]", 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " for which one can find non\[Hyphen]zero vectors ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["v",
            "TB"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " such that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          SubscriptBox[
            StyleBox["v",
              "TB"], 
            StyleBox["i",
              "TI"]], "=", 
          SubscriptBox["\[Lambda]", 
            StyleBox["i",
              "TI"]], 
          SubscriptBox[
            StyleBox["v",
              "TB"], 
            StyleBox["i",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". The eigenvectors are the vectors ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["v",
            "TB"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.7.9", "9.2"}],

Cell[TextData[{
  "The ",
  StyleBox["characteristic polynomial", "TI"],
  " ",
  StyleBox["CharacteristicPolynomial[", "MR"],
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " for an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "\[Cross]", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " matrix is given by ",
  StyleBox["Det[", "MR"],
  StyleBox["m", "TI"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["IdentityMatrix[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]]", "MR"],
  ". The eigenvalues are the roots of this polynomial. "
}], "Text",
  CellTags->{"S3.7.9", "9.3"}],

Cell[TextData[{
  "Finding the eigenvalues of an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "\[Cross]", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " matrix in general involves solving an ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  "\[Hyphen]degree polynomial equation. For ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "\[GreaterEqual]", "5"}], TraditionalForm]], 
    "InlineFormula"],
  ", therefore, the results cannot in general be expressed purely in terms of \
explicit radicals. ",
  StyleBox["Root", "MR"],
  " objects can nevertheless always be used, although except for fairly \
sparse or otherwise simple matrices the expressions obtained are often \
unmanageably complex.  "
}], "Text",
  CellTags->{"S3.7.9", "9.4"}],

Cell["\<\
Even for a matrix as simple as this, the explicit form of the \
eigenvalues is quite complicated. \
\>", "MathCaption",
  CellTags->{"S3.7.9", "9.5"}],

Cell[CellGroupData[{

Cell["Eigenvalues[ {{a, b}, {-b, 2a}} ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \({1\/2\ \((3\ a - \@\(a\^2 - 4\ b\^2\))\), 
      1\/2\ \((3\ a + \@\(a\^2 - 4\ b\^2\))\)}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.7.9"]
}, Open  ]],

Cell[TextData[{
  "If you give a matrix of approximate real numbers, ",
  StyleBox["Mathematica", "TI"],
  " will find the approximate numerical eigenvalues and eigenvectors. "
}], "Text",
  CellTags->{"S3.7.9", "9.6"}],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " numerical matrix. "
}], "MathCaption",
  CellTags->{"S3.7.9", "9.7"}],

Cell[CellGroupData[{

Cell["m = {{2.3, 4.5}, {6.7, -1.2}}", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \({{2.3`, 4.5`}, {6.7`, \(-1.2`\)}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.7.9"]
}, Open  ]],

Cell["The matrix has two eigenvalues, in this case both real. ", "MathCaption",
  CellTags->{"S3.7.9", "9.8"}],

Cell[CellGroupData[{

Cell["Eigenvalues[ m ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \({6.313028717610211`, \(-5.213028717610212`\)}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.7.9"]
}, Open  ]],

Cell[TextData[{
  "Here are the two eigenvectors of ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.9", "9.9"}],

Cell[CellGroupData[{

Cell["Eigenvectors[ m ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \({{0.7463353736931401`, 0.665570063910871`}, {\(-0.5138392648448873`\), 
        0.8578864784478573`}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.7.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Eigensystem", "MR"],
  " computes the eigenvalues and eigenvectors at the same time. The \
assignment sets ",
  StyleBox["vals", "MR"],
  " to the list of eigenvalues, and ",
  StyleBox["vecs", "MR"],
  " to the list of eigenvectors. "
}], "MathCaption",
  CellTags->{"S3.7.9", "9.10"}],

Cell[CellGroupData[{

Cell["{vals, vecs} = Eigensystem[m]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \({{6.313028717610211`, \(-5.213028717610212`\)}, {{0.7463353736931401`, 
          0.665570063910871`}, {\(-0.5138392648448873`\), 
          0.8578864784478573`}}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.7.9"]
}, Open  ]],

Cell["\<\
This verifies that the first eigenvalue and eigenvector satisfy the \
appropriate condition. \
\>", "MathCaption",
  CellTags->{"S3.7.9", "9.11"}],

Cell[CellGroupData[{

Cell["m . vecs[[1]] == vals[[1]] vecs[[1]]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.7.9"]
}, Open  ]],

Cell[TextData[{
  "This finds the eigenvalues of a random ",
  Cell[BoxData[
      \(TraditionalForm\`4\[Cross]4\)], "InlineFormula"],
  " matrix. For non\[Hyphen]symmetric matrices, the eigenvalues can have \
imaginary parts.  "
}], "MathCaption",
  CellTags->{"S3.7.9", "9.12"}],

Cell[CellGroupData[{

Cell["Eigenvalues[ Table[Random[ ], {4}, {4}] ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \({2.30021506699942`, \(\(0.3197643687884096`\)\(\[InvisibleSpace]\)\) + 
        0.5471987005585399`\ \[ImaginaryI], \(\(0.3197643687884096`\)\(\
\[InvisibleSpace]\)\) - 0.5471987005585399`\ \[ImaginaryI], 
      0.44929072781246243`}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.7.9"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["Eigenvalues", "MR"],
  " always gives you a list of ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " eigenvalues for an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "\[Cross]", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " matrix. The eigenvalues correspond to the roots of the characteristic \
polynomial for the matrix, and may not necessarily be distinct. ",
  StyleBox["Eigenvectors", "MR"],
  ", on the other hand, gives a list of eigenvectors which are guaranteed to \
be independent. If the number of such eigenvectors is less than ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", then ",
  StyleBox["Eigenvectors", "MR"],
  " appends zero vectors to the list it returns, so that the total length of \
the list is always ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.7.9", "9.13"}],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]3\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S3.7.9", "9.14"}],

Cell[CellGroupData[{

Cell["mz = {{0, 1, 0}, {0, 0, 1}, {0, 0, 0}}", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \({{0, 1, 0}, {0, 0, 1}, {0, 0, 0}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.7.9"]
}, Open  ]],

Cell["The matrix has three eigenvalues, all equal to zero. ", "MathCaption",
  CellTags->{"S3.7.9", "9.15"}],

Cell[CellGroupData[{

Cell["Eigenvalues[mz]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \({0, 0, 0}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.7.9"]
}, Open  ]],

Cell[TextData[{
  "There is, however, only one independent eigenvector for the matrix. ",
  StyleBox["Eigenvectors", "MR"],
  " appends two zero vectors to give a total of three vectors in this case. "
}], "MathCaption",
  CellTags->{"S3.7.9", "9.16"}],

Cell[CellGroupData[{

Cell["Eigenvectors[mz]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \({{1, 0, 0}, {0, 0, 0}, {0, 0, 0}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.7.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Eigenvalues[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the largest ",
              StyleBox["k", "TI"],
              " eigenvalues of ",
              StyleBox["m", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Eigenvectors[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the corresponding eigenvectors of ",
              StyleBox["m", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Eigenvalues[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["-", "MR"],
              StyleBox["k", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the smallest ",
              StyleBox["k", "TI"],
              " eigenvalues of ",
              StyleBox["m", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Eigenvectors[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["-", "MR"],
              StyleBox["k", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the corresponding eigenvectors of ",
              StyleBox["m", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.9"],

Cell["Finding largest and smallest eigenvalues. ", "Caption",
  CellTags->"S3.7.9"],

Cell[TextData[{
  StyleBox["Eigenvalues", "MR"],
  " sorts numeric eigenvalues so that the ones with large absolute value come \
first. In many situations, you may be interested only in the largest or \
smallest eigenvalues of a matrix. You can get these efficiently using ",
  StyleBox["Eigenvalues[", "MR"],
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["k", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["Eigenvalues[", "MR"],
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["-", "MR"],
  StyleBox["k", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.7.9", "9.17"}],

Cell["This computes the exact eigenvalues of an integer matrix. ", \
"MathCaption",
  CellTags->{"S3.7.9", "9.18"}],

Cell[CellGroupData[{

Cell["Eigenvalues[{{1, 2}, {3, 4}}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \({1\/2\ \((5 + \@33)\), 1\/2\ \((5 - \@33)\)}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.7.9"]
}, Open  ]],

Cell["The eigenvalues are sorted in decreasing order of size. ", "MathCaption",
  CellTags->{"S3.7.9", "9.19"}],

Cell[CellGroupData[{

Cell["N[%]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \({5.372281323269014`, \(-0.3722813232690143`\)}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.7.9"]
}, Open  ]],

Cell["\<\
This gives the three eigenvalues with largest absolute value. \
\
\>", "MathCaption",
  CellTags->{"S3.7.9", "9.20"}],

Cell[CellGroupData[{

Cell["Eigenvalues[Table[N[Tan[i/j]], {i, 10}, {j, 10}], 3]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \({10.04400345111886`, \(\(2.9439646789164504`\)\(\[InvisibleSpace]\)\) + 
        6.037276203776882`\ \[ImaginaryI], \(\(2.9439646789164504`\)\(\
\[InvisibleSpace]\)\) - 6.037276203776882`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.7.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Eigenvalues[{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the generalized eigenvalues of ",
              StyleBox["m", "TI"],
              " with respect to ",
              StyleBox["a", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Eigenvectors[{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the generalized eigenvectors of ",
              StyleBox["m", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["CharacteristicPolynomial[{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the generalized characteristic polynomial of ",
              StyleBox["m", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.9"],

Cell["Generalized eigenvalues and eigenvectors. ", "Caption",
  CellTags->"S3.7.9"],

Cell[TextData[{
  "The generalized eigenvalues for a matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " with respect to a matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TB"], TraditionalForm]], "InlineFormula"],
  " are defined to be those ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Lambda]", 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " for which ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          SubscriptBox[
            StyleBox["v",
              "TB"], 
            StyleBox["i",
              "TI"]], "=", 
          SubscriptBox["\[Lambda]", 
            StyleBox["i",
              "TI"]], 
          StyleBox["a",
            "TB"], ".", 
          SubscriptBox[
            StyleBox["v",
              "TB"], 
            StyleBox["i",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.7.9", "9.21"}],

Cell[TextData[{
  "The generalized eigenvalues correspond to zeros of the generalized \
characteristic polynomial ",
  StyleBox["Det[", "MR"],
  StyleBox["m", "TI"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["a", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.7.9", "9.22"}],

Cell[TextData[{
  "Note that while ordinary matrix eigenvalues always have definite values, \
some generalized eigenvalues will always be ",
  StyleBox["Indeterminate", "MR"],
  " if the generalized characteristic polynomial vanishes, which happens if \
",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TB"], TraditionalForm]], "InlineFormula"],
  " share a null space. Note also that generalized eigenvalues can be \
infinite.   "
}], "Text",
  CellTags->{"S3.7.9", "9.23"}],

Cell[TextData[{
  "These two matrices share a one\[Hyphen]dimensional null space, so one \
generalized eigenvalue is ",
  StyleBox["Indeterminate", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.9", "9.24"}],

Cell[CellGroupData[{

Cell["Eigenvalues[{{{1.5, 0}, {0, 0}}, {{2, 0}, {1, 0}}}]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.7.9"],

Cell[BoxData[
    \({0.`, Indeterminate}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.7.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.7.10 Advanced Matrix Operations", "Subsection",
  CellTags->{"S3.7.10", "10.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SingularValueList[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the list of non\[Hyphen]zero singular values of ",
              StyleBox["m", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SingularValueList[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["k", "TI"],
              " largest singular values of ",
              StyleBox["m", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SingularValueList[{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the generalized singular values of ",
              StyleBox["m", "TI"],
              " with respect to ",
              StyleBox["a", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Norm[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["p", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["p", "TI"],
              "\[Hyphen]norm of ",
              StyleBox["m", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.10"],

Cell["Finding singular values and norms of matrices. ", "Caption",
  CellTags->"S3.7.10"],

Cell[TextData[{
  "The ",
  StyleBox["singular values", "TI"],
  " of a matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " are the square roots of the eigenvalues of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          SuperscriptBox[
            StyleBox["m",
              "TB"], "*"]}], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`*\)], "InlineFormula"],
  " denotes Hermitian transpose. The number of such singular values is the \
smaller dimension of the matrix. ",
  StyleBox["SingularValueList", "MR"],
  " sorts the singular values from largest to smallest. Very small singular \
values are usually numerically meaningless. With the option setting ",
  StyleBox["Tolerance", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["t", "TI"],
  ", ",
  StyleBox["SingularValueList", "MR"],
  " drops singular values that are less than a fraction ",
  StyleBox["t", "TI"],
  " of the largest singular value. For approximate numerical matrices, the \
tolerance is by default slightly greater than zero."
}], "Text",
  CellTags->{"S3.7.10", "10.2"}],

Cell[TextData[{
  "If you multiply the vector for each point in a unit sphere in ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]dimensional space by an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "\[Cross]", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  ", then you get an ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]dimensional ellipsoid, whose principal axes have lengths given by \
the singular values of ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.7.10", "10.3"}],

Cell[TextData[{
  "The ",
  StyleBox["2\[Hyphen]norm", "TI"],
  " of a matrix ",
  StyleBox["Norm[", "MR"],
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["2]", "MR"],
  " is the largest principal axis of the ellipsoid, equal to the largest \
singular value of the matrix. This is also the maximum 2\[Hyphen]norm length \
of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          StyleBox["v",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " for any possible unit vector ",
  Cell[BoxData[
      FormBox[
        StyleBox["v",
          "TI"], TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.7.10", "10.4"}],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          "TI"], TraditionalForm]], "InlineFormula"],
  StyleBox["\[Hyphen]norm", "TI"],
  " of a matrix ",
  StyleBox["Norm[", "MR"],
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["p", "TI"],
  StyleBox["]", "MR"],
  " is in general the maximum ",
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]norm length of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          StyleBox["v",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " that can be attained. The cases most often considered are ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["p",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["p",
            "TI"], "=", "2"}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["p",
            "TI"], "=", "\[Infinity]"}], TraditionalForm]], "InlineFormula"],
  ". Also sometimes considered is the Frobenius norm, whose square is the \
trace of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          SuperscriptBox[
            StyleBox["m",
              "TB"], "*"]}], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.7.10", "10.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LUDecomposition[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the LU decomposition "]},
          {Cell[TextData[{
              StyleBox["CholeskyDecomposition[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the Cholesky decomposition "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.10"],

Cell["Decomposing matrices into triangular forms. ", "Caption",
  CellTags->"S3.7.10"],

Cell[TextData[{
  "When you create a ",
  StyleBox["LinearSolveFunction", "MR"],
  " using ",
  StyleBox["LinearSolve[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  ", this often works by decomposing the matrix ",
  StyleBox["m", "TI"],
  " into triangular forms, and sometimes it is useful to be able to get such \
forms explicitly. "
}], "Text",
  CellTags->{"S3.7.10", "10.6"}],

Cell[TextData[{
  StyleBox["LU decomposition", "TI"],
  " effectively factors any square matrix into a product of lower\[Hyphen] \
and upper\[Hyphen]triangular matrices. ",
  StyleBox["Cholesky decomposition", "TI"],
  " effectively factors any Hermitian positive\[Hyphen]definite matrix into a \
product of a lower\[Hyphen]triangular matrix and its Hermitian conjugate, \
which can be viewed as the analog of finding a square root of a matrix. "
}], "Text",
  CellTags->{"S3.7.10", "10.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PseudoInverse[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the pseudoinverse "]},
          {Cell[TextData[{
              StyleBox["QRDecomposition[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the QR decomposition "]},
          {Cell[TextData[{
              StyleBox["SingularValueDecomposition[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the singular value decomposition "]},
          {Cell[TextData[{
              StyleBox["SingularValueDecomposition[{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["the generalized singular value decomposition "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.10"],

Cell["Orthogonal decompositions of matrices. ", "Caption",
  CellTags->"S3.7.10"],

Cell[TextData[{
  "The standard definition for the inverse of a matrix fails if the matrix is \
not square or is singular. The ",
  StyleBox["pseudoinverse", "TI"],
  " ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["m",
            "TB"], \((\(-1\))\)], TraditionalForm]], "InlineFormula"],
  " of a matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " can however still be defined. It is set up to minimize the sum of the \
squares of all entries in ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TB"], ".", 
          SuperscriptBox[
            StyleBox["m",
              "TB"], \((\(-1\))\)], "-", 
          StyleBox["I",
            "TB"]}], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        StyleBox["I",
          "TB"], TraditionalForm]], "InlineFormula"],
  " is the identity matrix. The pseudoinverse is sometimes known as the \
generalized inverse, or the Moore\[Hyphen]Penrose inverse. It is particularly \
used in doing problems related to least\[Hyphen]squares fitting.  "
}], "Text",
  CellTags->{"S3.7.10", "10.8"}],

Cell[TextData[{
  StyleBox["QR decomposition", "TI"],
  " writes any matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " as a product ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["q",
              "TB"], "*"], 
          StyleBox["r",
            "TB"]}], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TB"], TraditionalForm]], "InlineFormula"],
  " is an orthonormal matrix, ",
  Cell[BoxData[
      \(TraditionalForm\`*\)], "InlineFormula"],
  " denotes Hermitian transpose, and ",
  Cell[BoxData[
      FormBox[
        StyleBox["r",
          "TB"], TraditionalForm]], "InlineFormula"],
  " is a triangular matrix, in which all entries below the leading diagonal \
are zero. "
}], "Text",
  CellTags->{"S3.7.10", "10.9"}],

Cell[TextData[{
  StyleBox["Singular value decomposition", "TI"],
  ", or ",
  StyleBox["SVD", "TI"],
  ", is an underlying element in many numerical matrix algorithms. The basic \
idea is to write any matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " in the form ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["usv",
            "TB"], "*"], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        StyleBox["s",
          "TB"], TraditionalForm]], "InlineFormula"],
  " is a matrix with the singular values of ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " on its diagonal, ",
  Cell[BoxData[
      FormBox[
        StyleBox["u",
          "TB"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["v",
          "TB"], TraditionalForm]], "InlineFormula"],
  " are orthonormal matrices, and ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["v",
            "TB"], "*"], TraditionalForm]], "InlineFormula"],
  " is the Hermitian transpose of ",
  StyleBox["v", "TB"],
  ". "
}], "Text",
  CellTags->{"S3.7.10", "10.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["JordanDecomposition[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the Jordan decomposition "]},
          {Cell[TextData[{
              StyleBox["SchurDecomposition[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the Schur decomposition "]},
          {Cell[TextData[{
              StyleBox["SchurDecomposition[{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["the generalized Schur decomposition "]},
          {Cell[TextData[{
              StyleBox["HessenbergDecomposition[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the Hessenberg decomposition "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.10"],

Cell["Functions related to eigenvalue problems. ", "Caption",
  CellTags->"S3.7.10"],

Cell[TextData[{
  "Most matrices can be reduced to a diagonal matrix of eigenvalues by \
applying a matrix of their eigenvectors as a similarity transformation. But \
even when there are not enough eigenvectors to do this, one can still reduce \
a matrix to a ",
  StyleBox["Jordan form", "TI"],
  " in which there are both eigenvalues and Jordan blocks on the diagonal. ",
  StyleBox["Jordan decomposition", "TI"],
  " in general writes any matrix in the form as ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["sjs",
            "TB"], \(-1\)], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.7.10", "10.11"}],

Cell[TextData[{
  "Numerically more stable is the ",
  StyleBox["Schur decomposition", "TI"],
  ", which writes any matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " in the form ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["qtq",
            "TB"], "*"], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TB"], TraditionalForm]], "InlineFormula"],
  " is an orthonormal matrix, and ",
  Cell[BoxData[
      FormBox[
        StyleBox["t",
          "TB"], TraditionalForm]], "InlineFormula"],
  " is block upper\[Hyphen]triangular. Also related is the ",
  StyleBox["Hessenberg decomposition", "TI"],
  ", which writes a matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TB"], TraditionalForm]], "InlineFormula"],
  " in the form ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["php",
            "TB"], "*"], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          "TB"], TraditionalForm]], "InlineFormula"],
  " is an orthonormal matrix, and ",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          "TB"], TraditionalForm]], "InlineFormula"],
  " can have nonzero elements down to one element below the leading diagonal. \
"
}], "Text",
  CellTags->{"S3.7.10", "10.12"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.7.11 Advanced Topic: Tensors", "Subsection",
  CellTags->{"S3.7.11", "11.1"}],

Cell[TextData[{
  StyleBox["Tensors", "TI"],
  " are mathematical objects that give generalizations of vectors and \
matrices. In ",
  StyleBox["Mathematica", "TI"],
  ", a tensor is represented as a set of lists, nested to a certain number of \
levels. The nesting level is the ",
  StyleBox["rank", "TI"],
  " of the tensor. "
}], "Text",
  CellTags->{"S3.7.11", "11.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "rank ",
              StyleBox["0", "MR"],
              " "
            }]], Cell["scalar "]},
          {Cell[TextData[{
              "rank ",
              StyleBox["1", "MR"],
              " "
            }]], Cell["vector "]},
          {Cell[TextData[{
              "rank ",
              StyleBox["2", "MR"],
              " "
            }]], Cell["matrix "]},
          {Cell[TextData[{
              "rank ",
              StyleBox["k", "TI"],
              " "
            }]], Cell[TextData[{
              "rank ",
              StyleBox["k", "TI"],
              " tensor "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.11"],

Cell["Interpretations of nested lists. ", "Caption",
  CellTags->"S3.7.11"],

Cell[TextData[{
  "A tensor of rank ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is essentially a ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]dimensional table of values. To be a true rank ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " tensor, it must be possible to arrange the elements in the table in a ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]dimensional cuboidal array. There can be no holes or protrusions \
in the cuboid. "
}], "Text",
  CellTags->{"S3.7.11", "11.3"}],

Cell[TextData[{
  "The ",
  StyleBox["indices", "TI"],
  " that specify a particular element in the tensor correspond to the \
coordinates in the cuboid. The ",
  StyleBox["dimensions", "TI"],
  " of the tensor correspond to the side lengths of the cuboid. "
}], "Text",
  CellTags->{"S3.7.11", "11.4"}],

Cell[TextData[{
  "One simple way that a rank ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " tensor can arise is in giving a table of values for a function of ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " variables. In physics, the tensors that occur typically have indices \
which run over the possible directions in space or spacetime. Notice, \
however, that there is no built\[Hyphen]in notion of covariant and \
contravariant tensor indices in ",
  StyleBox["Mathematica", "TI"],
  ": you have to set these up explicitly using metric tensors.  "
}], "Text",
  CellTags->{"S3.7.11", "11.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "create an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "1"], "\[Cross]", 
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "2"], "\[Cross]", "...", "\[Cross]", 
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], 
                        StyleBox["k",
                          "TI"]]}], TraditionalForm]], "InlineFormula"],
              " tensor whose elements are the values of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Array[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "create an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "1"], "\[Cross]", 
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "2"], "\[Cross]", "...", "\[Cross]", 
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], 
                        StyleBox["k",
                          "TI"]]}], TraditionalForm]], "InlineFormula"],
              " tensor with elements given by applying ",
              StyleBox["a", "TI"],
              " to each set of indices "
            }]]},
          {Cell[TextData[{
              StyleBox["ArrayQ[", "MR"],
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["t", "TI"],
              " is a tensor of rank ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Dimensions[", "MR"],
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["give a list of the dimensions of a tensor "]},
          {Cell[TextData[{
              StyleBox["ArrayDepth[", "MR"],
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["find the rank of a tensor "]},
          {Cell[TextData[{
              StyleBox["MatrixForm[", "MR"],
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "print with the elements of ",
              StyleBox["t", "TI"],
              " arranged in a two\[Hyphen]dimensional array "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.11"],

Cell["\<\
Functions for creating and testing the structure of tensors. \
\>", \
"Caption",
  CellTags->"S3.7.11"],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\[Cross]2\)], "InlineFormula"],
  " tensor. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.6"}],

Cell[CellGroupData[{

Cell["t = Table[i1+i2 i3, {i1, 2}, {i2, 3}, {i3, 2}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{{2, 3}, {3, 5}, {4, 7}}, {{3, 4}, {4, 6}, {5, 8}}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell["This is another way to produce the same tensor. ", "MathCaption",
  CellTags->{"S3.7.11", "11.7"}],

Cell[CellGroupData[{

Cell["Array[(#1 + #2 #3)&, {2, 3, 2}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{{2, 3}, {3, 5}, {4, 7}}, {{3, 4}, {4, 6}, {5, 8}}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["MatrixForm", "MR"],
  " displays the elements of the tensor in a two\[Hyphen]dimensional array. \
You can think of the array as being a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\)], "InlineFormula"],
  " matrix of column vectors. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.8"}],

Cell[CellGroupData[{

Cell["MatrixForm[ t ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"(", "\[NoBreak]", 
                TagBox[GridBox[{
                      {"2"},
                      {"3"}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", 
                TagBox[GridBox[{
                      {"3"},
                      {"5"}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", 
                TagBox[GridBox[{
                      {"4"},
                      {"7"}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column], "\[NoBreak]", ")"}]},
            {
              RowBox[{"(", "\[NoBreak]", 
                TagBox[GridBox[{
                      {"3"},
                      {"4"}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", 
                TagBox[GridBox[{
                      {"4"},
                      {"6"}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", 
                TagBox[GridBox[{
                      {"5"},
                      {"8"}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column], "\[NoBreak]", ")"}]}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Dimensions", "MR"],
  " gives the dimensions of the tensor. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.9"}],

Cell[CellGroupData[{

Cell["Dimensions[ t ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({2, 3, 2}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "Here is the ",
  Cell[BoxData[
      \(TraditionalForm\`111\)], "InlineFormula"],
  " element of the tensor. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.10"}],

Cell[CellGroupData[{

Cell["t[[1, 1, 1]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ArrayDepth", "MR"],
  " gives the rank of the tensor. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.11"}],

Cell[CellGroupData[{

Cell["ArrayDepth[ t ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell["\<\
The rank of a tensor is equal to the number of indices needed to \
specify each element. You can pick out subtensors by using a smaller number \
of indices. \
\>", "Text",
  CellTags->{"S3.7.11", "11.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Transpose[", "MR"],
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["transpose the first two indices in a tensor "]},
          {Cell[TextData[{
              StyleBox["Transpose[", "MR"],
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "transpose the indices in a tensor so that the ",
              StyleBox["k", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " becomes the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"]
            }]]},
          {Cell[TextData[{
              StyleBox["Tr[", "MR"],
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "form the generalized trace of the tensor ",
              StyleBox["t", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Outer[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "form the generalized outer product of the tensors ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              
              " with \[OpenCurlyDoubleQuote]multiplication operator\
\[CloseCurlyDoubleQuote] ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox[".", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "form the dot product of ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " (last index of ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " contracted with first index of ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["Inner[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "form the generalized inner product, with \
\[OpenCurlyDoubleQuote]multiplication operator\[CloseCurlyDoubleQuote] ",
              StyleBox["f", "TI"],
              
              " and \[OpenCurlyDoubleQuote]addition operator\
\[CloseCurlyDoubleQuote] ",
              StyleBox["g", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.11"],

Cell["Tensor manipulation operations. ", "Caption",
  CellTags->"S3.7.11"],

Cell[TextData[{
  "You can think of a rank ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " tensor as having ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " \[OpenCurlyDoubleQuote]slots\[CloseCurlyDoubleQuote] into which you \
insert indices. Applying ",
  StyleBox["Transpose", "MR"],
  " is effectively a way of reordering these slots. If you think of the \
elements of a tensor as forming a ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]dimensional cuboid, you can view ",
  StyleBox["Transpose", "MR"],
  " as effectively rotating (and possibly reflecting) the cuboid. "
}], "Text",
  CellTags->{"S3.7.11", "11.13"}],

Cell[TextData[{
  "In the most general case, ",
  StyleBox["Transpose", "MR"],
  " allows you to specify an arbitrary reordering to apply to the indices of \
a tensor. The function ",
  StyleBox["Transpose[", "MR"],
  StyleBox["T", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["p",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["p",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["p",
            "TI"], 
          StyleBox["k",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  ", gives you a new tensor ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["T",
            "TI"], "\[Prime]"], TraditionalForm]], "InlineFormula"],
  " such that the value of ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          SuperscriptBox[
            StyleBox["T",
              "TI"], "\[Prime]"], 
          RowBox[{
            SubscriptBox[
              StyleBox["i",
                "TI"], "1"], 
            SubscriptBox[
              StyleBox["i",
                "TI"], "2"], "...", 
            SubscriptBox[
              StyleBox["i",
                "TI"], 
              StyleBox["k",
                "TI"]]}]], TraditionalForm]], "InlineFormula"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["T",
            "TI"], 
          RowBox[{
            SubscriptBox[
              StyleBox["i",
                "TI"], 
              SubscriptBox[
                StyleBox["p",
                  "TI"], "1"]], 
            SubscriptBox[
              StyleBox["i",
                "TI"], 
              SubscriptBox[
                StyleBox["p",
                  "TI"], "2"]], "...", 
            SubscriptBox[
              StyleBox["i",
                "TI"], 
              SubscriptBox[
                StyleBox["p",
                  "TI"], 
                StyleBox["k",
                  "TI"]]]}]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.7.11", "11.14"}],

Cell[TextData[{
  "If you originally had an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["n",
              "TI"], 
            SubscriptBox[
              StyleBox["p",
                "TI"], "1"]], "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], 
            SubscriptBox[
              StyleBox["p",
                "TI"], "2"]], "\[Cross]", "...", "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], 
            SubscriptBox[
              StyleBox["p",
                "TI"], 
              StyleBox["k",
                "TI"]]]}], TraditionalForm]], "InlineFormula"],
  " tensor, then by applying ",
  StyleBox["Transpose", "MR"],
  ", you will get an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["n",
              "TI"], "1"], "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], "2"], "\[Cross]", "...", "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], 
            StyleBox["k",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  " tensor. "
}], "Text",
  CellTags->{"S3.7.11", "11.15"}],

Cell[TextData[{
  "Here is a matrix that you can also think of as a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\)], "InlineFormula"],
  " tensor. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.16"}],

Cell[CellGroupData[{

Cell["m = {{a, b, c}, {ap, bp, cp}}", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{a, b, c}, {ap, bp, cp}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "Applying ",
  StyleBox["Transpose", "MR"],
  " gives you a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]2\)], "InlineFormula"],
  " tensor. ",
  StyleBox["Transpose", "MR"],
  " effectively interchanges the two \[OpenCurlyDoubleQuote]slots\
\[CloseCurlyDoubleQuote] for tensor indices. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.17"}],

Cell[CellGroupData[{

Cell["mt = Transpose[m]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{a, ap}, {b, bp}, {c, cp}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "The element ",
  StyleBox["m[[2,", "MR"],
  " ",
  StyleBox["3]]", "MR"],
  " in the original tensor becomes the element ",
  StyleBox["m[[3,", "MR"],
  " ",
  StyleBox["2]]", "MR"],
  " in the transposed tensor. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.18"}],

Cell[CellGroupData[{

Cell["{ m[[2, 3]], mt[[3, 2]] }", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({cp, cp}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "This produces a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\[Cross]1\[Cross]2\)], "InlineFormula"],
  " tensor. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.19"}],

Cell[CellGroupData[{

Cell["t = Array[a, {2, 3, 1, 2}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{{{a[1, 1, 1, 1], a[1, 1, 1, 2]}}, {{a[1, 2, 1, 1], 
            a[1, 2, 1, 2]}}, {{a[1, 3, 1, 1], 
            a[1, 3, 1, 2]}}}, {{{a[2, 1, 1, 1], 
            a[2, 1, 1, 2]}}, {{a[2, 2, 1, 1], 
            a[2, 2, 1, 2]}}, {{a[2, 3, 1, 1], a[2, 3, 1, 2]}}}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "This transposes the first two levels of\[NonBreakingSpace]",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.20"}],

Cell[CellGroupData[{

Cell["tt1 = Transpose[t]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{{{a[1, 1, 1, 1], a[1, 1, 1, 2]}}, {{a[2, 1, 1, 1], 
            a[2, 1, 1, 2]}}}, {{{a[1, 2, 1, 1], 
            a[1, 2, 1, 2]}}, {{a[2, 2, 1, 1], 
            a[2, 2, 1, 2]}}}, {{{a[1, 3, 1, 1], 
            a[1, 3, 1, 2]}}, {{a[2, 3, 1, 1], a[2, 3, 1, 2]}}}}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "The result is a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]2\[Cross]1\[Cross]2\)], "InlineFormula"],
  " tensor. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.21"}],

Cell[CellGroupData[{

Cell["Dimensions[ tt1 ]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({3, 2, 1, 2}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "If you have a tensor that contains lists of the same length at different \
levels, then you can use ",
  StyleBox["Transpose", "MR"],
  " to effectively collapse different levels.   "
}], "Text",
  CellTags->{"S3.7.11", "11.22"}],

Cell["\<\
This collapses all three levels, giving a list of the elements on \
the \[OpenCurlyDoubleQuote]main diagonal\[CloseCurlyDoubleQuote]. \
\>", \
"MathCaption",
  CellTags->{"S3.7.11", "11.23"}],

Cell[CellGroupData[{

Cell["Transpose[Array[a, {3, 3, 3}], {1, 1, 1}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({a[1, 1, 1], a[2, 2, 2], a[3, 3, 3]}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell["This collapses only the first two levels. ", "MathCaption",
  CellTags->{"S3.7.11", "11.24"}],

Cell[CellGroupData[{

Cell["Transpose[Array[a, {2, 2, 2}], {1, 1}]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{a[1, 1, 1], a[1, 1, 2]}, {a[2, 2, 1], a[2, 2, 2]}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "You can also use ",
  StyleBox["Tr", "MR"],
  " to extract diagonal elements of a tensor. "
}], "Text",
  CellTags->{"S3.7.11", "11.25"}],

Cell["This forms the ordinary trace of a rank 3 tensor. ", "MathCaption",
  CellTags->{"S3.7.11", "11.26"}],

Cell[CellGroupData[{

Cell["Tr[Array[a, {3, 3, 3}]]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \(a[1, 1, 1] + a[2, 2, 2] + a[3, 3, 3]\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell["\<\
Here is a generalized trace, with elements combined into a list. \
\
\>", "MathCaption",
  CellTags->{"S3.7.11", "11.27"}],

Cell[CellGroupData[{

Cell["Tr[Array[a, {3, 3, 3}], List]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({a[1, 1, 1], a[2, 2, 2], a[3, 3, 3]}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell["This combines diagonal elements only down to level 2. ", "MathCaption",
  CellTags->{"S3.7.11", "11.28"}],

Cell[CellGroupData[{

Cell["Tr[Array[a, {3, 3, 3}], List, 2]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{a[1, 1, 1], a[1, 1, 2], a[1, 1, 3]}, {a[2, 2, 1], a[2, 2, 2], 
        a[2, 2, 3]}, {a[3, 3, 1], a[3, 3, 2], a[3, 3, 3]}}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell["\<\
Outer products, and their generalizations, are a way of building \
higher\[Hyphen]rank tensors from lower\[Hyphen]rank ones. Outer products are \
also sometimes known as direct, tensor or Kronecker products.\
\>", "Text",
  CellTags->{"S3.7.11", "11.29"}],

Cell[TextData[{
  "From a structural point of view, the tensor you get from ",
  StyleBox["Outer[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["t", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["u", "TI"],
  StyleBox["]", "MR"],
  " has a copy of the structure of ",
  StyleBox["u", "TI"],
  " inserted at the \[OpenCurlyDoubleQuote]position\[CloseCurlyDoubleQuote] \
of each element in ",
  StyleBox["t", "TI"],
  ". The elements in the resulting structure are obtained by combining \
elements of ",
  StyleBox["t", "TI"],
  " and ",
  StyleBox["u", "TI"],
  " using the function ",
  StyleBox["f", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.7.11", "11.30"}],

Cell[TextData[{
  "This gives the \[OpenCurlyDoubleQuote]outer ",
  StyleBox["f", "MR"],
  "\[CloseCurlyDoubleQuote] of two vectors. The result is a matrix. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.31"}],

Cell[CellGroupData[{

Cell["Outer[ f, {a, b}, {ap, bp} ]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{f[a, ap], f[a, bp]}, {f[b, ap], f[b, bp]}}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "If you take the \[OpenCurlyDoubleQuote]outer ",
  StyleBox["f", "MR"],
  "\[CloseCurlyDoubleQuote] of a length 3 vector with a length 2 vector, you \
get a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]2\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.32"}],

Cell[CellGroupData[{

Cell["Outer[ f, {a, b, c}, {ap, bp} ]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{f[a, ap], f[a, bp]}, {f[b, ap], f[b, bp]}, {f[c, ap], 
        f[c, bp]}}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "The result of taking the \[OpenCurlyDoubleQuote]outer ",
  StyleBox["f", "MR"],
  "\[CloseCurlyDoubleQuote] of a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " matrix and a length ",
  Cell[BoxData[
      \(TraditionalForm\`3\)], "InlineFormula"],
  " vector is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\[Cross]3\)], "InlineFormula"],
  " tensor. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.33"}],

Cell[CellGroupData[{

Cell["Outer[ f, {{m11, m12}, {m21, m22}}, {a, b, c} ]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{{f[m11, a], f[m11, b], f[m11, c]}, {f[m12, a], f[m12, b], 
          f[m12, c]}}, {{f[m21, a], f[m21, b], f[m21, c]}, {f[m22, a], 
          f[m22, b], f[m22, c]}}}\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell["Here are the dimensions of the tensor. ", "MathCaption",
  CellTags->{"S3.7.11", "11.34"}],

Cell[CellGroupData[{

Cell["Dimensions[ % ]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({2, 2, 3}\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "If you take the generalized outer product of an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["m",
              "TI"], "1"], "\[Cross]", 
          SubscriptBox[
            StyleBox["m",
              "TI"], "2"], "\[Cross]", "...", "\[Cross]", 
          SubscriptBox[
            StyleBox["m",
              "TI"], 
            StyleBox["r",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  " tensor and an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["n",
              "TI"], "1"], "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], "2"], "\[Cross]", "...", "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], 
            StyleBox["s",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  " tensor, you get an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["m",
              "TI"], "1"], "\[Cross]", "...", "\[Cross]", 
          SubscriptBox[
            StyleBox["m",
              "TI"], 
            StyleBox["r",
              "TI"]], "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], "1"], "\[Cross]", "...", "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], 
            StyleBox["s",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  " tensor. If the original tensors have ranks ",
  Cell[BoxData[
      FormBox[
        StyleBox["r",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["s",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", your result will be a rank ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            "TI"], "+", 
          StyleBox["s",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " tensor. "
}], "Text",
  CellTags->{"S3.7.11", "11.35"}],

Cell[TextData[{
  "In terms of indices, the result of applying ",
  StyleBox["Outer", "MR"],
  " to two tensors ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["T",
            "TI"], 
          RowBox[{
            SubscriptBox[
              StyleBox["i",
                "TI"], "1"], 
            SubscriptBox[
              StyleBox["i",
                "TI"], "2"], "...", 
            SubscriptBox[
              StyleBox["i",
                "TI"], 
              StyleBox["r",
                "TI"]]}]], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["U",
            "TI"], 
          RowBox[{
            SubscriptBox[
              StyleBox["j",
                "TI"], "1"], 
            SubscriptBox[
              StyleBox["j",
                "TI"], "2"], "...", 
            SubscriptBox[
              StyleBox["j",
                "TI"], 
              StyleBox["s",
                "TI"]]}]], TraditionalForm]], "InlineFormula"],
  " is the tensor ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["V",
            "TI"], 
          RowBox[{
            SubscriptBox[
              StyleBox["i",
                "TI"], "1"], 
            SubscriptBox[
              StyleBox["i",
                "TI"], "2"], "...", 
            SubscriptBox[
              StyleBox["i",
                "TI"], 
              StyleBox["r",
                "TI"]], 
            SubscriptBox[
              StyleBox["j",
                "TI"], "1"], 
            SubscriptBox[
              StyleBox["j",
                "TI"], "2"], "...", 
            SubscriptBox[
              StyleBox["j",
                "TI"], 
              StyleBox["s",
                "TI"]]}]], TraditionalForm]], "InlineFormula"],
  " with elements ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["T",
            "TI"], 
          RowBox[{
            SubscriptBox[
              StyleBox["i",
                "TI"], "1"], 
            SubscriptBox[
              StyleBox["i",
                "TI"], "2"], "...", 
            SubscriptBox[
              StyleBox["i",
                "TI"], 
              StyleBox["r",
                "TI"]]}]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["U",
            "TI"], 
          RowBox[{
            SubscriptBox[
              StyleBox["j",
                "TI"], "1"], 
            SubscriptBox[
              StyleBox["j",
                "TI"], "2"], "...", 
            SubscriptBox[
              StyleBox["j",
                "TI"], 
              StyleBox["s",
                "TI"]]}]], TraditionalForm]], "InlineFormula"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.7.11", "11.36"}],

Cell[TextData[{
  "In doing standard tensor calculations, the most common function ",
  StyleBox["f", "TI"],
  " to use in ",
  StyleBox["Outer", "MR"],
  " is ",
  StyleBox["Times", "MR"],
  ", corresponding to the standard outer product. "
}], "Text",
  CellTags->{"S3.7.11", "11.37"}],

Cell[TextData[{
  "Particularly in doing combinatorial calculations, however, it is often \
convenient to take ",
  StyleBox["f", "TI"],
  " to be ",
  StyleBox["List", "MR"],
  ". Using ",
  StyleBox["Outer", "MR"],
  ", you can then get combinations of all possible elements in one tensor, \
with all possible elements in the other.  "
}], "Text",
  CellTags->{"S3.7.11", "11.38"}],

Cell[TextData[{
  "In constructing ",
  StyleBox["Outer[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["t", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["u", "TI"],
  StyleBox["]", "MR"],
  " you effectively insert a copy of ",
  StyleBox["u", "TI"],
  " at every point in ",
  StyleBox["t", "TI"],
  ". To form ",
  StyleBox["Inner[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["t", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["u", "TI"],
  StyleBox["]", "MR"],
  ", you effectively combine and collapse the last dimension of ",
  StyleBox["t", "TI"],
  " and the first dimension of ",
  StyleBox["u", "TI"],
  ". The idea is to take an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["m",
              "TI"], "1"], "\[Cross]", 
          SubscriptBox[
            StyleBox["m",
              "TI"], "2"], "\[Cross]", "...", "\[Cross]", 
          SubscriptBox[
            StyleBox["m",
              "TI"], 
            StyleBox["r",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  " tensor and an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["n",
              "TI"], "1"], "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], "2"], "\[Cross]", "...", "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], 
            StyleBox["s",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  " tensor, with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["m",
              "TI"], 
            StyleBox["r",
              "TI"]], "=", 
          SubscriptBox[
            StyleBox["n",
              "TI"], "1"]}], TraditionalForm]], "InlineFormula"],
  ", and get an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["m",
              "TI"], "1"], "\[Cross]", 
          SubscriptBox[
            StyleBox["m",
              "TI"], "2"], "\[Cross]", "...", "\[Cross]", 
          SubscriptBox[
            StyleBox["m",
              "TI"], 
            RowBox[{
              StyleBox["r",
                "TI"], "-", "1"}]], "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], "2"], "\[Cross]", "...", "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], 
            StyleBox["s",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  " tensor as the result. "
}], "Text",
  CellTags->{"S3.7.11", "11.39"}],

Cell[TextData[{
  "The simplest examples are with vectors. If you apply ",
  StyleBox["Inner", "MR"],
  " to two vectors of equal length, you get a scalar. ",
  StyleBox["Inner[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["v",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["v",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["g", "TI"],
  StyleBox["]", "MR"],
  " gives a generalization of the usual scalar product, with ",
  StyleBox["f", "TI"],
  " playing the role of multiplication, and ",
  StyleBox["g", "TI"],
  " playing the role of addition.  "
}], "Text",
  CellTags->{"S3.7.11", "11.40"}],

Cell["\<\
This gives a generalization of the standard scalar product of two \
vectors.\
\>", "MathCaption",
  CellTags->{"S3.7.11", "11.41"}],

Cell[CellGroupData[{

Cell["Inner[f, {a, b, c}, {ap, bp, cp}, g]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \(g[f[a, ap], f[b, bp], f[c, cp]]\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell["This gives a generalization of a matrix product. ", "MathCaption",
  CellTags->{"S3.7.11", "11.42"}],

Cell[CellGroupData[{

Cell["Inner[f, {{1, 2}, {3, 4}}, {{a, b}, {c, d}}, g]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{g[f[1, a], f[2, c]], g[f[1, b], f[2, d]]}, {g[f[3, a], f[4, c]], 
        g[f[3, b], f[4, d]]}}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]2\[Cross]2\)], "InlineFormula"],
  " tensor. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.43"}],

Cell[CellGroupData[{

Cell["a = Array[1&, {3, 2, 2}]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{{1, 1}, {1, 1}}, {{1, 1}, {1, 1}}, {{1, 1}, {1, 1}}}\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\[Cross]1\)], "InlineFormula"],
  " tensor. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.44"}],

Cell[CellGroupData[{

Cell["b = Array[2&, {2, 3, 1}]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{{2}, {2}, {2}}, {{2}, {2}, {2}}}\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "This gives a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]2\[Cross]3\[Cross]1\)], "InlineFormula"],
  " tensor. "
}], "MathCaption",
  CellTags->{"S3.7.11", "11.45"}],

Cell[CellGroupData[{

Cell["a . b", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{{{4}, {4}, {4}}, {{4}, {4}, {4}}}, {{{4}, {4}, {4}}, {{4}, {4}, \
{4}}}, {{{4}, {4}, {4}}, {{4}, {4}, {4}}}}\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell["Here are the dimensions of the result. ", "MathCaption",
  CellTags->{"S3.7.11", "11.46"}],

Cell[CellGroupData[{

Cell["Dimensions[ % ]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({3, 2, 3, 1}\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell[TextData[{
  "You can think of ",
  StyleBox["Inner", "MR"],
  " as performing a \
\[OpenCurlyDoubleQuote]contraction\[CloseCurlyDoubleQuote] of the last index \
of one tensor with the first index of another. If you want to perform \
contractions across other pairs of indices, you can do so by first \
transposing the appropriate indices into the first or last position, then \
applying ",
  StyleBox["Inner", "MR"],
  ", and then transposing the result back. "
}], "Text",
  CellTags->{"S3.7.11", "11.47"}],

Cell[TextData[{
  "In many applications of tensors, you need to insert signs to implement \
antisymmetry. The function ",
  StyleBox["Signature[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  ",  which gives the signature of a permutation, is often useful for this \
purpose. "
}], "Text",
  CellTags->{"S3.7.11", "11.48"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Outer[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "form a generalized outer product by combining the lowest\
\[Hyphen]level elements of ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Outer[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "treat only sublists at level ",
              StyleBox["n", "TI"],
              " as separate elements "
            }]]},
          {Cell[TextData[{
              StyleBox["Outer[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] ]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "treat only sublists at level ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " in ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " as separate elements "
            }]]},
          {Cell[TextData[{
              StyleBox["Inner[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "form a generalized inner product using the \
lowest\[Hyphen]level elements of ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Inner[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "treat only sublists at level ",
              StyleBox["n", "TI"],
              " in ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " as separate elements "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.11"],

Cell["\<\
Treating only certain sublists in tensors as separate elements. \
\
\>", "Caption",
  CellTags->"S3.7.11"],

Cell["Here every single symbol is treated as a separate element. ", \
"MathCaption",
  CellTags->{"S3.7.11", "11.49"}],

Cell[CellGroupData[{

Cell["Outer[f, {{i, j}, {k, l}}, {x, y}]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{{f[i, x], f[i, y]}, {f[j, x], f[j, y]}}, {{f[k, x], 
          f[k, y]}, {f[l, x], f[l, y]}}}\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S3.7.11"]
}, Open  ]],

Cell["\<\
But here only sublists at level 1 are treated as separate elements. \
\
\>", "MathCaption",
  CellTags->{"S3.7.11", "11.50"}],

Cell[CellGroupData[{

Cell["Outer[f, {{i, j}, {k, l}}, {x, y}, 1]", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S3.7.11"],

Cell[BoxData[
    \({{f[{i, j}, x], f[{i, j}, y]}, {f[{k, l}, x], 
        f[{k, l}, y]}}\)], "Output",
  CellLabel->"Out[29]= ",
  CellTags->"S3.7.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.7.12 Sparse Arrays", "Subsection",
  CellTags->{"S3.7.12", "12.1"}],

Cell[TextData[{
  "Many large\[Hyphen]scale applications of linear algebra involve matrices \
that have many elements, but comparatively few that are non\[Hyphen]zero. You \
can represent such sparse matrices efficiently in ",
  StyleBox["Mathematica", "TI"],
  " using ",
  StyleBox["SparseArray", "MR"],
  " objects, as discussed in Section ",
  ButtonBox["2.4.5",
    ButtonData:>{"2.4.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  ". ",
  StyleBox["SparseArray", "MR"],
  " objects work by having lists of rules that specify where non\[Hyphen]zero \
values appear.   "
}], "Text",
  CellTags->{"S3.7.12", "12.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SparseArray[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a ",
              StyleBox["SparseArray", "MR"],
              " version of an ordinary list "
            }]]},
          {Cell[TextData[{
              StyleBox["SparseArray[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["m",
                        "TI"], "\[Cross]", 
                      StyleBox["n",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " sparse array with element ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}",
              StyleBox[" having value ", "TR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SparseArray[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, {",
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["the same sparse array "]},
          {Cell[TextData[{
              StyleBox["Normal[", "MR"],
              StyleBox["array", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ordinary list corresponding to a ",
              StyleBox["SparseArray", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True}},
  CellTags->"S3.7.12"],

Cell["Specifying sparse arrays. ", "Caption",
  CellTags->"S3.7.12"],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["2.4.5",
    ButtonData:>{"2.4.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  ", you can use patterns to specify collections of elements in sparse \
arrays. You can also have sparse arrays that correspond to tensors of any \
rank. "
}], "Text",
  CellTags->{"S3.7.12", "12.3"}],

Cell[TextData[{
  "This makes a ",
  Cell[BoxData[
      \(TraditionalForm\`50\[Cross]50\)], "InlineFormula"],
  " sparse numerical matrix, with 148 non\[Hyphen]zero elements. "
}], "MathCaption",
  CellTags->{"S3.7.12", "12.4"}],

Cell[CellGroupData[{

Cell["\<\
m = SparseArray[{{30, _} -> 11.5, {_, 30} -> 21.5, {i_, i_} -> i}, \
{50, 50}]\
\>", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]148\[InvisibleSpace]">"\),
            SequenceForm[ "<", 148, ">"],
            Editable->False], ",", \({50, 50}\)}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell["This shows a visual representation of the matrix elements. ", \
"MathCaption",
  CellTags->{"S3.7.12", "12.5"}],

Cell[CellGroupData[{

Cell["ListDensityPlot[-m]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.7.12"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.0192308 0.0192308 0.0192308 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.21154 -0.0125 -6 -9 ]
[.21154 -0.0125 6 0 ]
[.40385 -0.0125 -6 -9 ]
[.40385 -0.0125 6 0 ]
[.59615 -0.0125 -6 -9 ]
[.59615 -0.0125 6 0 ]
[.78846 -0.0125 -6 -9 ]
[.78846 -0.0125 6 0 ]
[.98077 -0.0125 -6 -9 ]
[.98077 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .21154 -12 -4.5 ]
[-0.0125 .21154 0 4.5 ]
[-0.0125 .40385 -12 -4.5 ]
[-0.0125 .40385 0 4.5 ]
[-0.0125 .59615 -12 -4.5 ]
[-0.0125 .59615 0 4.5 ]
[-0.0125 .78846 -12 -4.5 ]
[-0.0125 .78846 0 4.5 ]
[-0.0125 .98077 -12 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.21154 0 m
.21154 .00625 L
s
[(10)] .21154 -0.0125 0 1 Mshowa
.40385 0 m
.40385 .00625 L
s
[(20)] .40385 -0.0125 0 1 Mshowa
.59615 0 m
.59615 .00625 L
s
[(30)] .59615 -0.0125 0 1 Mshowa
.78846 0 m
.78846 .00625 L
s
[(40)] .78846 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(50)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.05769 0 m
.05769 .00375 L
s
.09615 0 m
.09615 .00375 L
s
.13462 0 m
.13462 .00375 L
s
.17308 0 m
.17308 .00375 L
s
.25 0 m
.25 .00375 L
s
.28846 0 m
.28846 .00375 L
s
.32692 0 m
.32692 .00375 L
s
.36538 0 m
.36538 .00375 L
s
.44231 0 m
.44231 .00375 L
s
.48077 0 m
.48077 .00375 L
s
.51923 0 m
.51923 .00375 L
s
.55769 0 m
.55769 .00375 L
s
.63462 0 m
.63462 .00375 L
s
.67308 0 m
.67308 .00375 L
s
.71154 0 m
.71154 .00375 L
s
.75 0 m
.75 .00375 L
s
.82692 0 m
.82692 .00375 L
s
.86538 0 m
.86538 .00375 L
s
.90385 0 m
.90385 .00375 L
s
.94231 0 m
.94231 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .21154 m
.00625 .21154 L
s
[(10)] -0.0125 .21154 1 0 Mshowa
0 .40385 m
.00625 .40385 L
s
[(20)] -0.0125 .40385 1 0 Mshowa
0 .59615 m
.00625 .59615 L
s
[(30)] -0.0125 .59615 1 0 Mshowa
0 .78846 m
.00625 .78846 L
s
[(40)] -0.0125 .78846 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(50)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .05769 m
.00375 .05769 L
s
0 .09615 m
.00375 .09615 L
s
0 .13462 m
.00375 .13462 L
s
0 .17308 m
.00375 .17308 L
s
0 .25 m
.00375 .25 L
s
0 .28846 m
.00375 .28846 L
s
0 .32692 m
.00375 .32692 L
s
0 .36538 m
.00375 .36538 L
s
0 .44231 m
.00375 .44231 L
s
0 .48077 m
.00375 .48077 L
s
0 .51923 m
.00375 .51923 L
s
0 .55769 m
.00375 .55769 L
s
0 .63462 m
.00375 .63462 L
s
0 .67308 m
.00375 .67308 L
s
0 .71154 m
.00375 .71154 L
s
0 .75 m
.00375 .75 L
s
0 .82692 m
.00375 .82692 L
s
0 .86538 m
.00375 .86538 L
s
0 .90385 m
.00375 .90385 L
s
0 .94231 m
.00375 .94231 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.21154 .99375 m
.21154 1 L
s
.40385 .99375 m
.40385 1 L
s
.59615 .99375 m
.59615 1 L
s
.78846 .99375 m
.78846 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.05769 .99625 m
.05769 1 L
s
.09615 .99625 m
.09615 1 L
s
.13462 .99625 m
.13462 1 L
s
.17308 .99625 m
.17308 1 L
s
.25 .99625 m
.25 1 L
s
.28846 .99625 m
.28846 1 L
s
.32692 .99625 m
.32692 1 L
s
.36538 .99625 m
.36538 1 L
s
.44231 .99625 m
.44231 1 L
s
.48077 .99625 m
.48077 1 L
s
.51923 .99625 m
.51923 1 L
s
.55769 .99625 m
.55769 1 L
s
.63462 .99625 m
.63462 1 L
s
.67308 .99625 m
.67308 1 L
s
.71154 .99625 m
.71154 1 L
s
.75 .99625 m
.75 1 L
s
.82692 .99625 m
.82692 1 L
s
.86538 .99625 m
.86538 1 L
s
.90385 .99625 m
.90385 1 L
s
.94231 .99625 m
.94231 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .21154 m
1 .21154 L
s
.99375 .40385 m
1 .40385 L
s
.99375 .59615 m
1 .59615 L
s
.99375 .78846 m
1 .78846 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .05769 m
1 .05769 L
s
.99625 .09615 m
1 .09615 L
s
.99625 .13462 m
1 .13462 L
s
.99625 .17308 m
1 .17308 L
s
.99625 .25 m
1 .25 L
s
.99625 .28846 m
1 .28846 L
s
.99625 .32692 m
1 .32692 L
s
.99625 .36538 m
1 .36538 L
s
.99625 .44231 m
1 .44231 L
s
.99625 .48077 m
1 .48077 L
s
.99625 .51923 m
1 .51923 L
s
.99625 .55769 m
1 .55769 L
s
.99625 .63462 m
1 .63462 L
s
.99625 .67308 m
1 .67308 L
s
.99625 .71154 m
1 .71154 L
s
.99625 .75 m
1 .75 L
s
.99625 .82692 m
1 .82692 L
s
.99625 .86538 m
1 .86538 L
s
.99625 .90385 m
1 .90385 L
s
.99625 .94231 m
1 .94231 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 g
.01923 .01923 m
.01923 .98077 L
.98077 .98077 L
.98077 .01923 L
F
.57 g
.57692 .01923 m
.57692 .03846 L
.59615 .03846 L
.59615 .01923 L
F
.98 g
.01923 .01923 m
.01923 .03846 L
.03846 .03846 L
.03846 .01923 L
F
.96 g
.03846 .03846 m
.03846 .05769 L
.05769 .05769 L
.05769 .03846 L
F
.57 g
.57692 .03846 m
.57692 .05769 L
.59615 .05769 L
.59615 .03846 L
F
.94 g
.05769 .05769 m
.05769 .07692 L
.07692 .07692 L
.07692 .05769 L
F
.57 g
.57692 .05769 m
.57692 .07692 L
.59615 .07692 L
.59615 .05769 L
F
.92 g
.07692 .07692 m
.07692 .09615 L
.09615 .09615 L
.09615 .07692 L
F
.57 g
.57692 .07692 m
.57692 .09615 L
.59615 .09615 L
.59615 .07692 L
F
.57692 .09615 m
.57692 .11538 L
.59615 .11538 L
.59615 .09615 L
F
.9 g
.09615 .09615 m
.09615 .11538 L
.11538 .11538 L
.11538 .09615 L
F
.88 g
.11538 .11538 m
.11538 .13462 L
.13462 .13462 L
.13462 .11538 L
F
.57 g
.57692 .11538 m
.57692 .13462 L
.59615 .13462 L
.59615 .11538 L
F
.86 g
.13462 .13462 m
.13462 .15385 L
.15385 .15385 L
.15385 .13462 L
F
.57 g
.57692 .13462 m
.57692 .15385 L
.59615 .15385 L
.59615 .13462 L
F
.57692 .15385 m
.57692 .17308 L
.59615 .17308 L
.59615 .15385 L
F
.84 g
.15385 .15385 m
.15385 .17308 L
.17308 .17308 L
.17308 .15385 L
F
.57 g
.57692 .17308 m
.57692 .19231 L
.59615 .19231 L
.59615 .17308 L
F
.82 g
.17308 .17308 m
.17308 .19231 L
.19231 .19231 L
.19231 .17308 L
F
.8 g
.19231 .19231 m
.19231 .21154 L
.21154 .21154 L
.21154 .19231 L
F
.57 g
.57692 .19231 m
.57692 .21154 L
.59615 .21154 L
.59615 .19231 L
F
.78 g
.21154 .21154 m
.21154 .23077 L
.23077 .23077 L
.23077 .21154 L
F
.57 g
.57692 .21154 m
.57692 .23077 L
.59615 .23077 L
.59615 .21154 L
F
.57692 .23077 m
.57692 .25 L
.59615 .25 L
.59615 .23077 L
F
.76 g
.23077 .23077 m
.23077 .25 L
.25 .25 L
.25 .23077 L
F
.57 g
.57692 .25 m
.57692 .26923 L
.59615 .26923 L
.59615 .25 L
F
.74 g
.25 .25 m
.25 .26923 L
.26923 .26923 L
.26923 .25 L
F
.72 g
.26923 .26923 m
.26923 .28846 L
.28846 .28846 L
.28846 .26923 L
F
.57 g
.57692 .26923 m
.57692 .28846 L
.59615 .28846 L
.59615 .26923 L
F
.57692 .28846 m
.57692 .30769 L
.59615 .30769 L
.59615 .28846 L
F
.7 g
.28846 .28846 m
.28846 .30769 L
.30769 .30769 L
.30769 .28846 L
F
.57 g
.57692 .30769 m
.57692 .32692 L
.59615 .32692 L
.59615 .30769 L
F
.68 g
.30769 .30769 m
.30769 .32692 L
.32692 .32692 L
.32692 .30769 L
F
.57 g
.57692 .32692 m
.57692 .34615 L
.59615 .34615 L
.59615 .32692 L
F
.66 g
.32692 .32692 m
.32692 .34615 L
.34615 .34615 L
.34615 .32692 L
F
.64 g
.34615 .34615 m
.34615 .36538 L
.36538 .36538 L
.36538 .34615 L
F
.57 g
.57692 .34615 m
.57692 .36538 L
.59615 .36538 L
.59615 .34615 L
F
.57692 .36538 m
.57692 .38462 L
.59615 .38462 L
.59615 .36538 L
F
.62 g
.36538 .36538 m
.36538 .38462 L
.38462 .38462 L
.38462 .36538 L
F
.57 g
.57692 .38462 m
.57692 .40385 L
.59615 .40385 L
.59615 .38462 L
F
.6 g
.38462 .38462 m
.38462 .40385 L
.40385 .40385 L
.40385 .38462 L
F
.57 g
.57692 .40385 m
.57692 .42308 L
.59615 .42308 L
.59615 .40385 L
F
.58 g
.40385 .40385 m
.40385 .42308 L
.42308 .42308 L
.42308 .40385 L
F
.57 g
.57692 .42308 m
.57692 .44231 L
.59615 .44231 L
.59615 .42308 L
F
.56 g
.42308 .42308 m
.42308 .44231 L
.44231 .44231 L
.44231 .42308 L
F
.57 g
.57692 .44231 m
.57692 .46154 L
.59615 .46154 L
.59615 .44231 L
F
.54 g
.44231 .44231 m
.44231 .46154 L
.46154 .46154 L
.46154 .44231 L
F
.57 g
.57692 .46154 m
.57692 .48077 L
.59615 .48077 L
.59615 .46154 L
F
.52 g
.46154 .46154 m
.46154 .48077 L
.48077 .48077 L
.48077 .46154 L
F
.57 g
.57692 .48077 m
.57692 .5 L
.59615 .5 L
.59615 .48077 L
F
.5 g
.48077 .48077 m
.48077 .5 L
.5 .5 L
.5 .48077 L
F
.57 g
.57692 .5 m
.57692 .51923 L
.59615 .51923 L
.59615 .5 L
F
.48 g
.5 .5 m
.5 .51923 L
.51923 .51923 L
.51923 .5 L
F
.57 g
.57692 .51923 m
.57692 .53846 L
.59615 .53846 L
.59615 .51923 L
F
.46 g
.51923 .51923 m
.51923 .53846 L
.53846 .53846 L
.53846 .51923 L
F
.57 g
.57692 .53846 m
.57692 .55769 L
.59615 .55769 L
.59615 .53846 L
F
.44 g
.53846 .53846 m
.53846 .55769 L
.55769 .55769 L
.55769 .53846 L
F
.57 g
.57692 .55769 m
.57692 .57692 L
.59615 .57692 L
.59615 .55769 L
F
.42 g
.55769 .55769 m
.55769 .57692 L
.57692 .57692 L
.57692 .55769 L
F
.77 g
.76923 .57692 m
.76923 .59615 L
.78846 .59615 L
.78846 .57692 L
F
.78846 .57692 m
.78846 .59615 L
.80769 .59615 L
.80769 .57692 L
F
.71154 .57692 m
.71154 .59615 L
.73077 .59615 L
.73077 .57692 L
F
.73077 .57692 m
.73077 .59615 L
.75 .59615 L
.75 .57692 L
F
.67308 .57692 m
.67308 .59615 L
.69231 .59615 L
.69231 .57692 L
F
.69231 .57692 m
.69231 .59615 L
.71154 .59615 L
.71154 .57692 L
F
.61538 .57692 m
.61538 .59615 L
.63462 .59615 L
.63462 .57692 L
F
.63462 .57692 m
.63462 .59615 L
.65385 .59615 L
.65385 .57692 L
F
.65385 .57692 m
.65385 .59615 L
.67308 .59615 L
.67308 .57692 L
F
.57692 .57692 m
.57692 .59615 L
.59615 .59615 L
.59615 .57692 L
F
.59615 .57692 m
.59615 .59615 L
.61538 .59615 L
.61538 .57692 L
F
.53846 .57692 m
.53846 .59615 L
.55769 .59615 L
.55769 .57692 L
F
.55769 .57692 m
.55769 .59615 L
.57692 .59615 L
.57692 .57692 L
F
.5 .57692 m
.5 .59615 L
.51923 .59615 L
.51923 .57692 L
F
.51923 .57692 m
.51923 .59615 L
.53846 .59615 L
.53846 .57692 L
F
.44231 .57692 m
.44231 .59615 L
.46154 .59615 L
.46154 .57692 L
F
.46154 .57692 m
.46154 .59615 L
.48077 .59615 L
.48077 .57692 L
F
.48077 .57692 m
.48077 .59615 L
.5 .59615 L
.5 .57692 L
F
.40385 .57692 m
.40385 .59615 L
.42308 .59615 L
.42308 .57692 L
F
.42308 .57692 m
.42308 .59615 L
.44231 .59615 L
.44231 .57692 L
F
.36538 .57692 m
.36538 .59615 L
.38462 .59615 L
.38462 .57692 L
F
.38462 .57692 m
.38462 .59615 L
.40385 .59615 L
.40385 .57692 L
F
.32692 .57692 m
.32692 .59615 L
.34615 .59615 L
.34615 .57692 L
F
.34615 .57692 m
.34615 .59615 L
.36538 .59615 L
.36538 .57692 L
F
.26923 .57692 m
.26923 .59615 L
.28846 .59615 L
.28846 .57692 L
F
.28846 .57692 m
.28846 .59615 L
.30769 .59615 L
.30769 .57692 L
F
.30769 .57692 m
.30769 .59615 L
.32692 .59615 L
.32692 .57692 L
F
.23077 .57692 m
.23077 .59615 L
.25 .59615 L
.25 .57692 L
F
.25 .57692 m
.25 .59615 L
.26923 .59615 L
.26923 .57692 L
F
.19231 .57692 m
.19231 .59615 L
.21154 .59615 L
.21154 .57692 L
F
.21154 .57692 m
.21154 .59615 L
.23077 .59615 L
.23077 .57692 L
F
.92308 .57692 m
.92308 .59615 L
.94231 .59615 L
.94231 .57692 L
F
.15385 .57692 m
.15385 .59615 L
.17308 .59615 L
.17308 .57692 L
F
.94231 .57692 m
.94231 .59615 L
.96154 .59615 L
.96154 .57692 L
F
.17308 .57692 m
.17308 .59615 L
.19231 .59615 L
.19231 .57692 L
F
.09615 .57692 m
.09615 .59615 L
.11538 .59615 L
.11538 .57692 L
F
.96154 .57692 m
.96154 .59615 L
.98077 .59615 L
.98077 .57692 L
F
.88462 .57692 m
.88462 .59615 L
.90385 .59615 L
.90385 .57692 L
F
.11538 .57692 m
.11538 .59615 L
.13462 .59615 L
.13462 .57692 L
F
.90385 .57692 m
.90385 .59615 L
.92308 .59615 L
.92308 .57692 L
F
.05769 .57692 m
.05769 .59615 L
.07692 .59615 L
.07692 .57692 L
F
.13462 .57692 m
.13462 .59615 L
.15385 .59615 L
.15385 .57692 L
F
.84615 .57692 m
.84615 .59615 L
.86538 .59615 L
.86538 .57692 L
F
.07692 .57692 m
.07692 .59615 L
.09615 .59615 L
.09615 .57692 L
F
.86538 .57692 m
.86538 .59615 L
.88462 .59615 L
.88462 .57692 L
F
.01923 .57692 m
.01923 .59615 L
.03846 .59615 L
.03846 .57692 L
F
.80769 .57692 m
.80769 .59615 L
.82692 .59615 L
.82692 .57692 L
F
.03846 .57692 m
.03846 .59615 L
.05769 .59615 L
.05769 .57692 L
F
.82692 .57692 m
.82692 .59615 L
.84615 .59615 L
.84615 .57692 L
F
.75 .57692 m
.75 .59615 L
.76923 .59615 L
.76923 .57692 L
F
.57 g
.57692 .59615 m
.57692 .61538 L
.59615 .61538 L
.59615 .59615 L
F
.38 g
.59615 .59615 m
.59615 .61538 L
.61538 .61538 L
.61538 .59615 L
F
.36 g
.61538 .61538 m
.61538 .63462 L
.63462 .63462 L
.63462 .61538 L
F
.57 g
.57692 .61538 m
.57692 .63462 L
.59615 .63462 L
.59615 .61538 L
F
.34 g
.63462 .63462 m
.63462 .65385 L
.65385 .65385 L
.65385 .63462 L
F
.57 g
.57692 .63462 m
.57692 .65385 L
.59615 .65385 L
.59615 .63462 L
F
.32 g
.65385 .65385 m
.65385 .67308 L
.67308 .67308 L
.67308 .65385 L
F
.57 g
.57692 .65385 m
.57692 .67308 L
.59615 .67308 L
.59615 .65385 L
F
.3 g
.67308 .67308 m
.67308 .69231 L
.69231 .69231 L
.69231 .67308 L
F
.57 g
.57692 .67308 m
.57692 .69231 L
.59615 .69231 L
.59615 .67308 L
F
.28 g
.69231 .69231 m
.69231 .71154 L
.71154 .71154 L
.71154 .69231 L
F
.57 g
.57692 .69231 m
.57692 .71154 L
.59615 .71154 L
.59615 .69231 L
F
.26 g
.71154 .71154 m
.71154 .73077 L
.73077 .73077 L
.73077 .71154 L
F
.57 g
.57692 .71154 m
.57692 .73077 L
.59615 .73077 L
.59615 .71154 L
F
.24 g
.73077 .73077 m
.73077 .75 L
.75 .75 L
.75 .73077 L
F
.57 g
.57692 .73077 m
.57692 .75 L
.59615 .75 L
.59615 .73077 L
F
.22 g
.75 .75 m
.75 .76923 L
.76923 .76923 L
.76923 .75 L
F
.57 g
.57692 .75 m
.57692 .76923 L
.59615 .76923 L
.59615 .75 L
F
.57692 .76923 m
.57692 .78846 L
.59615 .78846 L
.59615 .76923 L
F
.2 g
.76923 .76923 m
.76923 .78846 L
.78846 .78846 L
.78846 .76923 L
F
.18 g
.78846 .78846 m
.78846 .80769 L
.80769 .80769 L
.80769 .78846 L
F
.57 g
.57692 .78846 m
.57692 .80769 L
.59615 .80769 L
.59615 .78846 L
F
.16 g
.80769 .80769 m
.80769 .82692 L
.82692 .82692 L
.82692 .80769 L
F
.57 g
.57692 .80769 m
.57692 .82692 L
.59615 .82692 L
.59615 .80769 L
F
.14 g
.82692 .82692 m
.82692 .84615 L
.84615 .84615 L
.84615 .82692 L
F
.57 g
.57692 .82692 m
.57692 .84615 L
.59615 .84615 L
.59615 .82692 L
F
.57692 .84615 m
.57692 .86538 L
.59615 .86538 L
.59615 .84615 L
F
.12 g
.84615 .84615 m
.84615 .86538 L
.86538 .86538 L
.86538 .84615 L
F
.1 g
.86538 .86538 m
.86538 .88462 L
.88462 .88462 L
.88462 .86538 L
F
.57 g
.57692 .86538 m
.57692 .88462 L
.59615 .88462 L
.59615 .86538 L
F
.08 g
.88462 .88462 m
.88462 .90385 L
.90385 .90385 L
.90385 .88462 L
F
.57 g
.57692 .88462 m
.57692 .90385 L
.59615 .90385 L
.59615 .88462 L
F
.57692 .90385 m
.57692 .92308 L
.59615 .92308 L
.59615 .90385 L
F
.06 g
.90385 .90385 m
.90385 .92308 L
.92308 .92308 L
.92308 .90385 L
F
.57 g
.57692 .92308 m
.57692 .94231 L
.59615 .94231 L
.59615 .92308 L
F
.04 g
.92308 .92308 m
.92308 .94231 L
.94231 .94231 L
.94231 .92308 L
F
.02 g
.94231 .94231 m
.94231 .96154 L
.96154 .96154 L
.96154 .94231 L
F
.57 g
.57692 .94231 m
.57692 .96154 L
.59615 .96154 L
.59615 .94231 L
F
0 g
.96154 .96154 m
.96154 .98077 L
.98077 .98077 L
.98077 .96154 L
F
.57 g
.57692 .96154 m
.57692 .98077 L
.59615 .98077 L
.59615 .96154 L
F
0 g
.01923 .01923 m
.01923 .98077 L
s
.03846 .01923 m
.03846 .98077 L
s
.05769 .01923 m
.05769 .98077 L
s
.07692 .01923 m
.07692 .98077 L
s
.09615 .01923 m
.09615 .98077 L
s
.11538 .01923 m
.11538 .98077 L
s
.13462 .01923 m
.13462 .98077 L
s
.15385 .01923 m
.15385 .98077 L
s
.17308 .01923 m
.17308 .98077 L
s
.19231 .01923 m
.19231 .98077 L
s
.21154 .01923 m
.21154 .98077 L
s
.23077 .01923 m
.23077 .98077 L
s
.25 .01923 m
.25 .98077 L
s
.26923 .01923 m
.26923 .98077 L
s
.28846 .01923 m
.28846 .98077 L
s
.30769 .01923 m
.30769 .98077 L
s
.32692 .01923 m
.32692 .98077 L
s
.34615 .01923 m
.34615 .98077 L
s
.36538 .01923 m
.36538 .98077 L
s
.38462 .01923 m
.38462 .98077 L
s
.40385 .01923 m
.40385 .98077 L
s
.42308 .01923 m
.42308 .98077 L
s
.44231 .01923 m
.44231 .98077 L
s
.46154 .01923 m
.46154 .98077 L
s
.48077 .01923 m
.48077 .98077 L
s
.5 .01923 m
.5 .98077 L
s
.51923 .01923 m
.51923 .98077 L
s
.53846 .01923 m
.53846 .98077 L
s
.55769 .01923 m
.55769 .98077 L
s
.57692 .01923 m
.57692 .98077 L
s
.59615 .01923 m
.59615 .98077 L
s
.61538 .01923 m
.61538 .98077 L
s
.63462 .01923 m
.63462 .98077 L
s
.65385 .01923 m
.65385 .98077 L
s
.67308 .01923 m
.67308 .98077 L
s
.69231 .01923 m
.69231 .98077 L
s
.71154 .01923 m
.71154 .98077 L
s
.73077 .01923 m
.73077 .98077 L
s
.75 .01923 m
.75 .98077 L
s
.76923 .01923 m
.76923 .98077 L
s
.78846 .01923 m
.78846 .98077 L
s
.80769 .01923 m
.80769 .98077 L
s
.82692 .01923 m
.82692 .98077 L
s
.84615 .01923 m
.84615 .98077 L
s
.86538 .01923 m
.86538 .98077 L
s
.88462 .01923 m
.88462 .98077 L
s
.90385 .01923 m
.90385 .98077 L
s
.92308 .01923 m
.92308 .98077 L
s
.94231 .01923 m
.94231 .98077 L
s
.96154 .01923 m
.96154 .98077 L
s
.98077 .01923 m
.98077 .98077 L
s
.01923 .01923 m
.98077 .01923 L
s
.01923 .03846 m
.98077 .03846 L
s
.01923 .05769 m
.98077 .05769 L
s
.01923 .07692 m
.98077 .07692 L
s
.01923 .09615 m
.98077 .09615 L
s
.01923 .11538 m
.98077 .11538 L
s
.01923 .13462 m
.98077 .13462 L
s
.01923 .15385 m
.98077 .15385 L
s
.01923 .17308 m
.98077 .17308 L
s
.01923 .19231 m
.98077 .19231 L
s
.01923 .21154 m
.98077 .21154 L
s
.01923 .23077 m
.98077 .23077 L
s
.01923 .25 m
.98077 .25 L
s
.01923 .26923 m
.98077 .26923 L
s
.01923 .28846 m
.98077 .28846 L
s
.01923 .30769 m
.98077 .30769 L
s
.01923 .32692 m
.98077 .32692 L
s
.01923 .34615 m
.98077 .34615 L
s
.01923 .36538 m
.98077 .36538 L
s
.01923 .38462 m
.98077 .38462 L
s
.01923 .40385 m
.98077 .40385 L
s
.01923 .42308 m
.98077 .42308 L
s
.01923 .44231 m
.98077 .44231 L
s
.01923 .46154 m
.98077 .46154 L
s
.01923 .48077 m
.98077 .48077 L
s
.01923 .5 m
.98077 .5 L
s
.01923 .51923 m
.98077 .51923 L
s
.01923 .53846 m
.98077 .53846 L
s
.01923 .55769 m
.98077 .55769 L
s
.01923 .57692 m
.98077 .57692 L
s
.01923 .59615 m
.98077 .59615 L
s
.01923 .61538 m
.98077 .61538 L
s
.01923 .63462 m
.98077 .63462 L
s
.01923 .65385 m
.98077 .65385 L
s
.01923 .67308 m
.98077 .67308 L
s
.01923 .69231 m
.98077 .69231 L
s
.01923 .71154 m
.98077 .71154 L
s
.01923 .73077 m
.98077 .73077 L
s
.01923 .75 m
.98077 .75 L
s
.01923 .76923 m
.98077 .76923 L
s
.01923 .78846 m
.98077 .78846 L
s
.01923 .80769 m
.98077 .80769 L
s
.01923 .82692 m
.98077 .82692 L
s
.01923 .84615 m
.98077 .84615 L
s
.01923 .86538 m
.98077 .86538 L
s
.01923 .88462 m
.98077 .88462 L
s
.01923 .90385 m
.98077 .90385 L
s
.01923 .92308 m
.98077 .92308 L
s
.01923 .94231 m
.98077 .94231 L
s
.01923 .96154 m
.98077 .96154 L
s
.01923 .98077 m
.98077 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.7.12"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell["Here are the four largest eigenvalues of the matrix. ", "MathCaption",
  CellTags->{"S3.7.12", "12.6"}],

Cell[CellGroupData[{

Cell["Eigenvalues[m, 4]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    \({129.8464828045342`, \(-92.68783328158473`\), 49.78670161397882`, 
      48.747807650779436`}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Dot", "MR"],
  " gives a ",
  StyleBox["SparseArray", "MR"],
  " result. "
}], "MathCaption",
  CellTags->{"S3.7.12", "12.7"}],

Cell[CellGroupData[{

Cell["m . m", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]2500\[InvisibleSpace]">"\),
            SequenceForm[ "<", 2500, ">"],
            Editable->False], ",", \({50, 50}\)}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell["You can extract parts just like in an ordinary array. ", "MathCaption",
  CellTags->{"S3.7.12", "12.8"}],

Cell[CellGroupData[{

Cell["%[[20, 20]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    \(647.25`\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell[TextData[{
  "You can apply most standard structural operations directly to ",
  StyleBox["SparseArray", "MR"],
  " objects, just as you would to ordinary lists. When the results are \
sparse, they typically return ",
  StyleBox["SparseArray", "MR"],
  " objects. "
}], "Text",
  CellTags->{"S3.7.12", "12.9"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Dimensions[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the dimensions of an array "]},
          {Cell[TextData[{
              StyleBox["ArrayRules[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
the rules for non\[Hyphen]zero elements in an array \
\
\>"]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "element ",
              StyleBox["i", "TI"],
              ", ",
              StyleBox["j", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " row "
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[All,", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " column "
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["v", "TI"],
              " "
            }]], Cell[TextData[{
              "reset element ",
              StyleBox["i", "TI"],
              ", ",
              StyleBox["j", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.12"],

Cell[TextData[{
  "A few structural operations that can be done directly on ",
  StyleBox["SparseArray", "MR"],
  " objects. "
}], "Caption",
  CellTags->"S3.7.12"],

Cell[TextData[{
  "This gives the first column of ",
  StyleBox["m", "MR"],
  ". It has only 2 non\[Hyphen]zero elements. "
}], "MathCaption",
  CellTags->{"S3.7.12", "12.10"}],

Cell[CellGroupData[{

Cell["m[[All, 1]]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]2\[InvisibleSpace]">"\),
            SequenceForm[ "<", 2, ">"],
            Editable->False], ",", \({50}\)}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell[TextData[{
  "This adds 3 to each element in the first column of ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.7.12", "12.11"}],

Cell[CellGroupData[{

Cell["m[[All, 1]] = 3 + m[[All, 1]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]2\[InvisibleSpace]">"\),
            SequenceForm[ "<", 2, ">"],
            Editable->False], ",", \({50}\), ",", "3"}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell["\<\
Now all the elements in the first column are non\[Hyphen]zero. \
\
\>", "MathCaption",
  CellTags->{"S3.7.12", "12.12"}],

Cell[CellGroupData[{

Cell["m[[All, 1]]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]50\[InvisibleSpace]">"\),
            SequenceForm[ "<", 50, ">"],
            Editable->False], ",", \({50}\)}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell["\<\
This gives the rules for the non\[Hyphen]zero elements on the \
second row. \
\>", "MathCaption",
  CellTags->{"S3.7.12", "12.13"}],

Cell[CellGroupData[{

Cell["ArrayRules[m[[2]]]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    \({{1} \[Rule] 3, {2} \[Rule] 2, {30} \[Rule] 21.5`, {_} \[Rule] 
        0}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SparseArray[", "MR"],
              StyleBox["rules", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["generate a sparse array from rules "]},
          {Cell[TextData[{
              StyleBox["CoefficientArrays[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqns",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqns",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell["get arrays of coefficients from equations "]},
          {Cell[TextData[{
              StyleBox["Import[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox[".mtx\"]", "MR"],
              " "
            }]], Cell["import a sparse array from a file "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.12"],

Cell["Typical ways to get sparse arrays. ", "Caption",
  CellTags->"S3.7.12"],

Cell["This generates a tridiagonal random matrix. ", "MathCaption",
  CellTags->{"S3.7.12", "12.14"}],

Cell[CellGroupData[{

Cell["\<\
SparseArray[{i_, j_} /; Abs[i-j] <= 1 :> Random[], {100, \
100}]\
\>", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]298\[InvisibleSpace]">"\),
            SequenceForm[ "<", 298, ">"],
            Editable->False], ",", \({100, 100}\)}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell["Even the tenth power of the matrix is still fairly sparse. ", \
"MathCaption",
  CellTags->{"S3.7.12", "12.15"}],

Cell[CellGroupData[{

Cell["MatrixPower[%, 10]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]1990\[InvisibleSpace]">"\),
            SequenceForm[ "<", 1990, ">"],
            Editable->False], ",", \({100, 100}\)}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell["This extracts the coefficients as sparse arrays. ", "MathCaption",
  CellTags->{"S3.7.12", "12.16"}],

Cell[CellGroupData[{

Cell["\<\
s = CoefficientArrays[{c + x - z == 0, x + 2 y + z == 0}, {x, y, \
z}]\
\>", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"SparseArray", "[", 
            RowBox[{
              
              InterpretationBox[\("<"\[InvisibleSpace]1\[InvisibleSpace]">"\),
                
                SequenceForm[ "<", 1, ">"],
                Editable->False], ",", \({2}\)}], "]"}],
          False,
          Editable->False], ",", 
        TagBox[
          RowBox[{"SparseArray", "[", 
            RowBox[{
              
              InterpretationBox[\("<"\[InvisibleSpace]5\[InvisibleSpace]">"\),
                
                SequenceForm[ "<", 5, ">"],
                Editable->False], ",", \({2, 3}\)}], "]"}],
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell["Here are the corresponding ordinary arrays. ", "MathCaption",
  CellTags->{"S3.7.12", "12.17"}],

Cell[CellGroupData[{

Cell["Normal[%]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    \({{c, 0}, {{1, 0, \(-1\)}, {1, 2, 1}}}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell["This reproduces the original forms. ", "MathCaption",
  CellTags->{"S3.7.12", "12.18"}],

Cell[CellGroupData[{

Cell["s[[1]] + s[[2]] . {x, y, z}", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    \({c + x - z, x + 2\ y + z}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell[TextData[{
  StyleBox["CoefficientArrays", "MR"],
  " can handle general polynomial equations. "
}], "MathCaption",
  CellTags->{"S3.7.12", "12.19"}],

Cell[CellGroupData[{

Cell["\<\
s = CoefficientArrays[ {c + x^2 - z == 0, x^2 + 2 y + z^2 == 0}, \
{x, y, z}]\
\>", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"SparseArray", "[", 
            RowBox[{
              
              InterpretationBox[\("<"\[InvisibleSpace]1\[InvisibleSpace]">"\),
                
                SequenceForm[ "<", 1, ">"],
                Editable->False], ",", \({2}\)}], "]"}],
          False,
          Editable->False], ",", 
        TagBox[
          RowBox[{"SparseArray", "[", 
            RowBox[{
              
              InterpretationBox[\("<"\[InvisibleSpace]2\[InvisibleSpace]">"\),
                
                SequenceForm[ "<", 2, ">"],
                Editable->False], ",", \({2, 3}\)}], "]"}],
          False,
          Editable->False], ",", 
        TagBox[
          RowBox[{"SparseArray", "[", 
            RowBox[{
              
              InterpretationBox[\("<"\[InvisibleSpace]3\[InvisibleSpace]">"\),
                
                SequenceForm[ "<", 3, ">"],
                Editable->False], ",", \({2, 3, 3}\)}], "]"}],
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell["\<\
The coefficients of the quadratic part are given in a rank 3 \
tensor. \
\>", "MathCaption",
  CellTags->{"S3.7.12", "12.20"}],

Cell[CellGroupData[{

Cell["Normal[%]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    \({{c, 
        0}, {{0, 0, \(-1\)}, {0, 2, 
          0}}, {{{1, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{1, 0, 0}, {0, 0, 0}, {0, 
            0, 1}}}}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell["This reproduces the original forms. ", "MathCaption",
  CellTags->{"S3.7.12", "12.21"}],

Cell[CellGroupData[{

Cell["s[[1]] + s[[2]] . {x, y, z} + s[[3]] . {x, y, z} . {x, y, z}", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.7.12"],

Cell[BoxData[
    \({c + x\^2 - z, x\^2 + 2\ y + z\^2}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.7.12"]
}, Open  ]],

Cell[TextData[{
  "For machine\[Hyphen]precision numerical sparse matrices, ",
  StyleBox["Mathematica", "TI"],
  " supports standard file formats such as Matrix Market (",
  StyleBox[".mtx", "MR"],
  ") and Harwell\[Hyphen]Boeing. You can import and export matrices in these \
formats using ",
  StyleBox["Import", "MR"],
  " and ",
  StyleBox["Export", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.7.12", "12.22"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S3.7.0"->{
    Cell[1776, 53, 117, 4, 65, "Section",
      CellTags->{"S3.7.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 117, 4, 65, "Section",
      CellTags->{"S3.7.0", "0.1"}]},
  "S3.7.1"->{
    Cell[1918, 61, 80, 1, 70, "Subsection",
      CellTags->{"S3.7.1", "1.1"}],
    Cell[2001, 64, 7011, 202, 70, "DefinitionBox",
      CellTags->"S3.7.1"],
    Cell[9015, 268, 78, 1, 70, "Caption",
      CellTags->"S3.7.1"],
    Cell[9096, 271, 582, 23, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.2"}],
    Cell[9703, 298, 94, 2, 70, "Input",
      CellTags->"S3.7.1"],
    Cell[9800, 302, 121, 3, 70, "Output",
      CellTags->"S3.7.1"],
    Cell[9936, 308, 102, 1, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.3"}],
    Cell[10063, 313, 80, 2, 70, "Input",
      CellTags->"S3.7.1"],
    Cell[10146, 317, 121, 3, 70, "Output",
      CellTags->"S3.7.1"],
    Cell[10282, 323, 176, 4, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.4"}],
    Cell[10483, 331, 89, 2, 70, "Input",
      CellTags->"S3.7.1"],
    Cell[10575, 335, 114, 3, 70, "Output",
      CellTags->"S3.7.1"],
    Cell[10704, 341, 376, 14, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.5"}],
    Cell[11105, 359, 81, 2, 70, "Input",
      CellTags->"S3.7.1"],
    Cell[11189, 363, 114, 3, 70, "Output",
      CellTags->"S3.7.1"],
    Cell[11318, 369, 215, 6, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.6"}],
    Cell[11558, 379, 115, 2, 70, "Input",
      CellTags->"S3.7.1"],
    Cell[11676, 383, 123, 3, 70, "Output",
      CellTags->"S3.7.1"],
    Cell[11814, 389, 156, 4, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.7"}],
    Cell[11995, 397, 77, 2, 70, "Input",
      CellTags->"S3.7.1"],
    Cell[12075, 401, 431, 13, 70, "Output",
      CellTags->"S3.7.1"],
    Cell[12521, 417, 1915, 60, 70, "DefinitionBox",
      CellTags->"S3.7.1"],
    Cell[14439, 479, 136, 5, 70, "Caption",
      CellTags->"S3.7.1"],
    Cell[14578, 486, 259, 9, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.8"}],
    Cell[14862, 499, 90, 2, 70, "Input",
      CellTags->"S3.7.1"],
    Cell[14955, 503, 179, 4, 70, "Output",
      CellTags->"S3.7.1"],
    Cell[15149, 510, 2688, 79, 70, "DefinitionBox",
      CellTags->"S3.7.1"],
    Cell[17840, 591, 142, 5, 70, "Caption",
      CellTags->"S3.7.1"],
    Cell[17985, 598, 120, 4, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.9"}],
    Cell[18130, 606, 124, 2, 70, "Input",
      CellTags->"S3.7.1"],
    Cell[18257, 610, 716, 22, 70, "Output",
      CellTags->"S3.7.1"]},
  "1.1"->{
    Cell[1918, 61, 80, 1, 70, "Subsection",
      CellTags->{"S3.7.1", "1.1"}]},
  "1.2"->{
    Cell[9096, 271, 582, 23, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.2"}]},
  "1.3"->{
    Cell[9936, 308, 102, 1, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.3"}]},
  "1.4"->{
    Cell[10282, 323, 176, 4, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.4"}]},
  "1.5"->{
    Cell[10704, 341, 376, 14, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.5"}]},
  "1.6"->{
    Cell[11318, 369, 215, 6, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.6"}]},
  "1.7"->{
    Cell[11814, 389, 156, 4, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.7"}]},
  "1.8"->{
    Cell[14578, 486, 259, 9, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.8"}]},
  "1.9"->{
    Cell[17985, 598, 120, 4, 70, "MathCaption",
      CellTags->{"S3.7.1", "1.9"}]},
  "S3.7.2"->{
    Cell[19022, 638, 97, 1, 70, "Subsection",
      CellTags->{"S3.7.2", "2.1"}],
    Cell[19122, 641, 7038, 203, 70, "DefinitionBox",
      CellTags->"S3.7.2"],
    Cell[26163, 846, 73, 1, 70, "Caption",
      CellTags->"S3.7.2"],
    Cell[26239, 849, 269, 7, 70, "Text",
      CellTags->{"S3.7.2", "2.2"}],
    Cell[26511, 858, 176, 6, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.3"}],
    Cell[26712, 868, 84, 2, 70, "Input",
      CellTags->"S3.7.2"],
    Cell[26799, 872, 177, 4, 70, "Output",
      CellTags->"S3.7.2"],
    Cell[26991, 879, 99, 1, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.4"}],
    Cell[27115, 884, 70, 2, 70, "Input",
      CellTags->"S3.7.2"],
    Cell[27188, 888, 108, 3, 70, "Output",
      CellTags->"S3.7.2"],
    Cell[27311, 894, 95, 1, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.5"}],
    Cell[27431, 899, 75, 2, 70, "Input",
      CellTags->"S3.7.2"],
    Cell[27509, 903, 108, 3, 70, "Output",
      CellTags->"S3.7.2"],
    Cell[27632, 909, 82, 1, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.6"}],
    Cell[27739, 914, 87, 2, 70, "Input",
      CellTags->"S3.7.2"],
    Cell[27829, 918, 121, 3, 70, "Output",
      CellTags->"S3.7.2"],
    Cell[27965, 924, 6574, 202, 70, "DefinitionBox",
      CellTags->"S3.7.2"],
    Cell[34542, 1128, 70, 1, 70, "Caption",
      CellTags->"S3.7.2"],
    Cell[34615, 1131, 169, 6, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.7"}],
    Cell[34809, 1141, 84, 2, 70, "Input",
      CellTags->"S3.7.2"],
    Cell[34896, 1145, 97, 3, 70, "Output",
      CellTags->"S3.7.2"],
    Cell[35008, 1151, 165, 5, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.8"}],
    Cell[35198, 1160, 80, 2, 70, "Input",
      CellTags->"S3.7.2"],
    Cell[35281, 1164, 97, 3, 70, "Output",
      CellTags->"S3.7.2"],
    Cell[35393, 1170, 153, 5, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.9"}],
    Cell[35571, 1179, 82, 2, 70, "Input",
      CellTags->"S3.7.2"],
    Cell[35656, 1183, 97, 3, 70, "Output",
      CellTags->"S3.7.2"],
    Cell[35768, 1189, 127, 4, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.10"}],
    Cell[35920, 1197, 87, 2, 70, "Input",
      CellTags->"S3.7.2"],
    Cell[36010, 1201, 97, 3, 70, "Output",
      CellTags->"S3.7.2"],
    Cell[36122, 1207, 108, 1, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.11"}],
    Cell[36255, 1212, 80, 2, 70, "Input",
      CellTags->"S3.7.2"],
    Cell[36338, 1216, 105, 3, 70, "Output",
      CellTags->"S3.7.2"]},
  "2.1"->{
    Cell[19022, 638, 97, 1, 70, "Subsection",
      CellTags->{"S3.7.2", "2.1"}]},
  "2.2"->{
    Cell[26239, 849, 269, 7, 70, "Text",
      CellTags->{"S3.7.2", "2.2"}]},
  "2.3"->{
    Cell[26511, 858, 176, 6, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.3"}]},
  "2.4"->{
    Cell[26991, 879, 99, 1, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.4"}]},
  "2.5"->{
    Cell[27311, 894, 95, 1, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.5"}]},
  "2.6"->{
    Cell[27632, 909, 82, 1, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.6"}]},
  "2.7"->{
    Cell[34615, 1131, 169, 6, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.7"}]},
  "2.8"->{
    Cell[35008, 1151, 165, 5, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.8"}]},
  "2.9"->{
    Cell[35393, 1170, 153, 5, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.9"}]},
  "2.10"->{
    Cell[35768, 1189, 127, 4, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.10"}]},
  "2.11"->{
    Cell[36122, 1207, 108, 1, 70, "MathCaption",
      CellTags->{"S3.7.2", "2.11"}]},
  "S3.7.3"->{
    Cell[36492, 1225, 88, 1, 70, "Subsection",
      CellTags->{"S3.7.3", "3.1"}],
    Cell[36583, 1228, 235, 7, 70, "Text",
      CellTags->{"S3.7.3", "3.2"}],
    Cell[36821, 1237, 366, 8, 70, "Text",
      CellTags->{"S3.7.3", "3.3"}],
    Cell[37190, 1247, 1338, 40, 70, "DefinitionBox",
      CellTags->"S3.7.3"],
    Cell[38531, 1289, 112, 4, 70, "Caption",
      CellTags->"S3.7.3"],
    Cell[38646, 1295, 199, 9, 70, "MathCaption",
      CellTags->{"S3.7.3", "3.4"}],
    Cell[38870, 1308, 84, 2, 70, "Input",
      CellTags->"S3.7.3"],
    Cell[38957, 1312, 85, 3, 70, "Output",
      CellTags->"S3.7.3"],
    Cell[39057, 1318, 224, 8, 70, "MathCaption",
      CellTags->{"S3.7.3", "3.5"}],
    Cell[39306, 1330, 80, 2, 70, "Input",
      CellTags->"S3.7.3"],
    Cell[39389, 1334, 86, 3, 70, "Output",
      CellTags->"S3.7.3"],
    Cell[39490, 1340, 169, 6, 70, "MathCaption",
      CellTags->{"S3.7.3", "3.6"}],
    Cell[39684, 1350, 103, 2, 70, "Input",
      CellTags->"S3.7.3"],
    Cell[39790, 1354, 87, 3, 70, "Output",
      CellTags->"S3.7.3"],
    Cell[39892, 1360, 219, 7, 70, "MathCaption",
      CellTags->{"S3.7.3", "3.7"}],
    Cell[40136, 1371, 87, 2, 70, "Input",
      CellTags->"S3.7.3"],
    Cell[40226, 1375, 84, 3, 70, "Output",
      CellTags->"S3.7.3"],
    Cell[40325, 1381, 146, 4, 70, "MathCaption",
      CellTags->{"S3.7.3", "3.8"}],
    Cell[40496, 1389, 96, 2, 70, "Input",
      CellTags->"S3.7.3"],
    Cell[40595, 1393, 86, 3, 70, "Output",
      CellTags->"S3.7.3"]},
  "3.1"->{
    Cell[36492, 1225, 88, 1, 70, "Subsection",
      CellTags->{"S3.7.3", "3.1"}]},
  "3.2"->{
    Cell[36583, 1228, 235, 7, 70, "Text",
      CellTags->{"S3.7.3", "3.2"}]},
  "3.3"->{
    Cell[36821, 1237, 366, 8, 70, "Text",
      CellTags->{"S3.7.3", "3.3"}]},
  "3.4"->{
    Cell[38646, 1295, 199, 9, 70, "MathCaption",
      CellTags->{"S3.7.3", "3.4"}]},
  "3.5"->{
    Cell[39057, 1318, 224, 8, 70, "MathCaption",
      CellTags->{"S3.7.3", "3.5"}]},
  "3.6"->{
    Cell[39490, 1340, 169, 6, 70, "MathCaption",
      CellTags->{"S3.7.3", "3.6"}]},
  "3.7"->{
    Cell[39892, 1360, 219, 7, 70, "MathCaption",
      CellTags->{"S3.7.3", "3.7"}]},
  "3.8"->{
    Cell[40325, 1381, 146, 4, 70, "MathCaption",
      CellTags->{"S3.7.3", "3.8"}]},
  "S3.7.4"->{
    Cell[40730, 1402, 102, 1, 70, "Subsection",
      CellTags->{"S3.7.4", "4.1"}],
    Cell[40835, 1405, 312, 8, 70, "Text",
      CellTags->{"S3.7.4", "4.2"}],
    Cell[41150, 1415, 163, 4, 70, "Text",
      CellTags->{"S3.7.4", "4.3"}],
    Cell[41316, 1421, 163, 5, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.4"}],
    Cell[41504, 1430, 80, 2, 70, "Input",
      CellTags->"S3.7.4"],
    Cell[41587, 1434, 105, 3, 70, "Output",
      CellTags->"S3.7.4"],
    Cell[41707, 1440, 137, 4, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.5"}],
    Cell[41869, 1448, 87, 2, 70, "Input",
      CellTags->"S3.7.4"],
    Cell[41959, 1452, 117, 3, 70, "Output",
      CellTags->"S3.7.4"],
    Cell[42091, 1458, 180, 5, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.6"}],
    Cell[42296, 1467, 85, 2, 70, "Input",
      CellTags->"S3.7.4"],
    Cell[42384, 1471, 99, 3, 70, "Output",
      CellTags->"S3.7.4"],
    Cell[42498, 1477, 114, 2, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.7"}],
    Cell[42637, 1483, 81, 2, 70, "Input",
      CellTags->"S3.7.4"],
    Cell[42721, 1487, 97, 3, 70, "Output",
      CellTags->"S3.7.4"],
    Cell[42833, 1493, 136, 4, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.8"}],
    Cell[42994, 1501, 84, 2, 70, "Input",
      CellTags->"S3.7.4"],
    Cell[43081, 1505, 191, 4, 70, "Message",
      CellTags->"S3.7.4"],
    Cell[43275, 1511, 101, 3, 70, "Output",
      CellTags->"S3.7.4"],
    Cell[43391, 1517, 152, 5, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.9"}],
    Cell[43568, 1526, 74, 2, 70, "Input",
      CellTags->"S3.7.4"],
    Cell[43645, 1530, 95, 3, 70, "Output",
      CellTags->"S3.7.4"],
    Cell[43755, 1536, 249, 6, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.10"}],
    Cell[44029, 1546, 74, 2, 70, "Input",
      CellTags->"S3.7.4"],
    Cell[44106, 1550, 95, 3, 70, "Output",
      CellTags->"S3.7.4"],
    Cell[44216, 1556, 160, 5, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.11"}],
    Cell[44401, 1565, 72, 2, 70, "Input",
      CellTags->"S3.7.4"],
    Cell[44476, 1569, 93, 3, 70, "Output",
      CellTags->"S3.7.4"],
    Cell[44584, 1575, 548, 11, 70, "Text",
      CellTags->{"S3.7.4", "4.12"}],
    Cell[45135, 1588, 190, 6, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.13"}],
    Cell[45350, 1598, 74, 2, 70, "Input",
      CellTags->"S3.7.4"],
    Cell[45427, 1602, 95, 3, 70, "Output",
      CellTags->"S3.7.4"],
    Cell[45537, 1608, 217, 9, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.14"}],
    Cell[45779, 1621, 81, 2, 70, "Input",
      CellTags->"S3.7.4"],
    Cell[45863, 1625, 114, 3, 70, "Output",
      CellTags->"S3.7.4"],
    Cell[45992, 1631, 261, 9, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.15"}],
    Cell[46278, 1644, 80, 2, 70, "Input",
      CellTags->"S3.7.4"],
    Cell[46361, 1648, 96, 3, 70, "Output",
      CellTags->"S3.7.4"]},
  "4.1"->{
    Cell[40730, 1402, 102, 1, 70, "Subsection",
      CellTags->{"S3.7.4", "4.1"}]},
  "4.2"->{
    Cell[40835, 1405, 312, 8, 70, "Text",
      CellTags->{"S3.7.4", "4.2"}]},
  "4.3"->{
    Cell[41150, 1415, 163, 4, 70, "Text",
      CellTags->{"S3.7.4", "4.3"}]},
  "4.4"->{
    Cell[41316, 1421, 163, 5, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.4"}]},
  "4.5"->{
    Cell[41707, 1440, 137, 4, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.5"}]},
  "4.6"->{
    Cell[42091, 1458, 180, 5, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.6"}]},
  "4.7"->{
    Cell[42498, 1477, 114, 2, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.7"}]},
  "4.8"->{
    Cell[42833, 1493, 136, 4, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.8"}]},
  "4.9"->{
    Cell[43391, 1517, 152, 5, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.9"}]},
  "4.10"->{
    Cell[43755, 1536, 249, 6, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.10"}]},
  "4.11"->{
    Cell[44216, 1556, 160, 5, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.11"}]},
  "4.12"->{
    Cell[44584, 1575, 548, 11, 70, "Text",
      CellTags->{"S3.7.4", "4.12"}]},
  "4.13"->{
    Cell[45135, 1588, 190, 6, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.13"}]},
  "4.14"->{
    Cell[45537, 1608, 217, 9, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.14"}]},
  "4.15"->{
    Cell[45992, 1631, 261, 9, 70, "MathCaption",
      CellTags->{"S3.7.4", "4.15"}]},
  "S3.7.5"->{
    Cell[46506, 1657, 91, 1, 70, "Subsection",
      CellTags->{"S3.7.5", "5.1"}],
    Cell[46600, 1660, 1996, 62, 70, "DefinitionBox",
      CellTags->"S3.7.5"],
    Cell[48599, 1724, 94, 1, 70, "Caption",
      CellTags->"S3.7.5"],
    Cell[48696, 1727, 158, 5, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.2"}],
    Cell[48879, 1736, 75, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[48957, 1740, 99, 3, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[49071, 1746, 169, 4, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.3"}],
    Cell[49265, 1754, 88, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[49356, 1758, 102, 3, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[49473, 1764, 109, 1, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.4"}],
    Cell[49607, 1769, 89, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[49699, 1773, 107, 3, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[49821, 1779, 165, 5, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.5"}],
    Cell[50011, 1788, 99, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[50113, 1792, 131, 3, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[50259, 1798, 703, 18, 70, "Text",
      CellTags->{"S3.7.5", "5.6"}],
    Cell[50965, 1818, 178, 7, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.7"}],
    Cell[51168, 1829, 97, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[51268, 1833, 87, 3, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[51370, 1839, 271, 9, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.8"}],
    Cell[51666, 1852, 69, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[51738, 1856, 107, 3, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[51860, 1862, 255, 9, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.9"}],
    Cell[52140, 1875, 69, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[52212, 1879, 107, 3, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[52334, 1885, 183, 7, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.10"}],
    Cell[52542, 1896, 73, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[52618, 1900, 124, 3, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[52757, 1906, 253, 5, 70, "Text",
      CellTags->{"S3.7.5", "5.11"}],
    Cell[53013, 1913, 144, 4, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.12"}],
    Cell[53182, 1921, 73, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[53258, 1925, 90, 3, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[53363, 1931, 89, 1, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.13"}],
    Cell[53477, 1936, 82, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[53562, 1940, 95, 3, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[53672, 1946, 114, 2, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.14"}],
    Cell[53811, 1952, 86, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[53900, 1956, 111, 3, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[54026, 1962, 321, 9, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.15"}],
    Cell[54372, 1975, 80, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[54455, 1979, 127, 3, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[54597, 1985, 430, 9, 70, "Text",
      CellTags->{"S3.7.5", "5.16"}],
    Cell[55030, 1996, 101, 1, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.17"}],
    Cell[55156, 2001, 93, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[55252, 2005, 110, 3, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[55377, 2011, 133, 4, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.18"}],
    Cell[55535, 2019, 106, 2, 70, "Input",
      CellTags->"S3.7.5"],
    Cell[55644, 2023, 168, 4, 70, "Output",
      CellTags->"S3.7.5"],
    Cell[55827, 2030, 223, 7, 70, "Text",
      CellTags->{"S3.7.5", "5.19"}]},
  "5.1"->{
    Cell[46506, 1657, 91, 1, 70, "Subsection",
      CellTags->{"S3.7.5", "5.1"}]},
  "5.2"->{
    Cell[48696, 1727, 158, 5, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.2"}]},
  "5.3"->{
    Cell[49071, 1746, 169, 4, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.3"}]},
  "5.4"->{
    Cell[49473, 1764, 109, 1, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.4"}]},
  "5.5"->{
    Cell[49821, 1779, 165, 5, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.5"}]},
  "5.6"->{
    Cell[50259, 1798, 703, 18, 70, "Text",
      CellTags->{"S3.7.5", "5.6"}]},
  "5.7"->{
    Cell[50965, 1818, 178, 7, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.7"}]},
  "5.8"->{
    Cell[51370, 1839, 271, 9, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.8"}]},
  "5.9"->{
    Cell[51860, 1862, 255, 9, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.9"}]},
  "5.10"->{
    Cell[52334, 1885, 183, 7, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.10"}]},
  "5.11"->{
    Cell[52757, 1906, 253, 5, 70, "Text",
      CellTags->{"S3.7.5", "5.11"}]},
  "5.12"->{
    Cell[53013, 1913, 144, 4, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.12"}]},
  "5.13"->{
    Cell[53363, 1931, 89, 1, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.13"}]},
  "5.14"->{
    Cell[53672, 1946, 114, 2, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.14"}]},
  "5.15"->{
    Cell[54026, 1962, 321, 9, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.15"}]},
  "5.16"->{
    Cell[54597, 1985, 430, 9, 70, "Text",
      CellTags->{"S3.7.5", "5.16"}]},
  "5.17"->{
    Cell[55030, 1996, 101, 1, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.17"}]},
  "5.18"->{
    Cell[55377, 2011, 133, 4, 70, "MathCaption",
      CellTags->{"S3.7.5", "5.18"}]},
  "5.19"->{
    Cell[55827, 2030, 223, 7, 70, "Text",
      CellTags->{"S3.7.5", "5.19"}]},
  "S3.7.6"->{
    Cell[56087, 2042, 75, 1, 70, "Subsection",
      CellTags->{"S3.7.6", "6.1"}],
    Cell[56165, 2045, 425, 12, 70, "DefinitionBox",
      CellTags->"S3.7.6"],
    Cell[56593, 2059, 59, 1, 70, "Caption",
      CellTags->"S3.7.6"],
    Cell[56655, 2062, 176, 6, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.2"}],
    Cell[56856, 2072, 84, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[56943, 2076, 97, 3, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[57055, 2082, 406, 17, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.3"}],
    Cell[57486, 2103, 76, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[57565, 2107, 229, 5, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[57809, 2115, 144, 4, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.4"}],
    Cell[57978, 2123, 69, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[58050, 2127, 286, 6, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[58351, 2136, 191, 5, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.5"}],
    Cell[58567, 2145, 77, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[58647, 2149, 97, 3, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[58759, 2155, 92, 1, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.6"}],
    Cell[58876, 2160, 101, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[58980, 2164, 194, 4, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[59189, 2171, 143, 4, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.7"}],
    Cell[59357, 2179, 75, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[59435, 2183, 247, 5, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[59697, 2191, 126, 4, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.8"}],
    Cell[59848, 2199, 70, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[59921, 2203, 137, 3, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[60073, 2209, 209, 5, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.9"}],
    Cell[60307, 2218, 91, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[60401, 2222, 158, 4, 70, "Message",
      CellTags->"S3.7.6"],
    Cell[60562, 2228, 106, 3, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[60683, 2234, 366, 8, 70, "Text",
      CellTags->{"S3.7.6", "6.10"}],
    Cell[61052, 2244, 109, 1, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.11"}],
    Cell[61186, 2249, 92, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[61281, 2253, 109, 3, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[61405, 2259, 89, 1, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.12"}],
    Cell[61519, 2264, 77, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[61599, 2268, 193, 5, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[61807, 2276, 158, 4, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.13"}],
    Cell[61990, 2284, 70, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[62063, 2288, 106, 3, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[62184, 2294, 167, 5, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.14"}],
    Cell[62376, 2303, 74, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[62453, 2307, 102, 3, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[62570, 2313, 625, 13, 70, "Text",
      CellTags->{"S3.7.6", "6.15"}],
    Cell[63198, 2328, 187, 5, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.16"}],
    Cell[63410, 2337, 96, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[63509, 2341, 166, 4, 70, "Message",
      CellTags->"S3.7.6"],
    Cell[63678, 2347, 115, 3, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[63808, 2353, 237, 5, 70, "Text",
      CellTags->{"S3.7.6", "6.17"}],
    Cell[64048, 2360, 230, 6, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.18"}],
    Cell[64281, 2368, 119, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[64403, 2372, 157, 4, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.19"}],
    Cell[64585, 2380, 87, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[64675, 2384, 231, 5, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[64921, 2392, 294, 7, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.20"}],
    Cell[65218, 2401, 114, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[65335, 2405, 133, 4, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.21"}],
    Cell[65493, 2413, 87, 2, 70, "Input",
      CellTags->"S3.7.6"],
    Cell[65583, 2417, 262, 5, 70, "Output",
      CellTags->"S3.7.6"],
    Cell[65860, 2425, 355, 10, 70, "Text",
      CellTags->{"S3.7.6", "6.22"}]},
  "6.1"->{
    Cell[56087, 2042, 75, 1, 70, "Subsection",
      CellTags->{"S3.7.6", "6.1"}]},
  "6.2"->{
    Cell[56655, 2062, 176, 6, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.2"}]},
  "6.3"->{
    Cell[57055, 2082, 406, 17, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.3"}]},
  "6.4"->{
    Cell[57809, 2115, 144, 4, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.4"}]},
  "6.5"->{
    Cell[58351, 2136, 191, 5, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.5"}]},
  "6.6"->{
    Cell[58759, 2155, 92, 1, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.6"}]},
  "6.7"->{
    Cell[59189, 2171, 143, 4, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.7"}]},
  "6.8"->{
    Cell[59697, 2191, 126, 4, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.8"}]},
  "6.9"->{
    Cell[60073, 2209, 209, 5, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.9"}]},
  "6.10"->{
    Cell[60683, 2234, 366, 8, 70, "Text",
      CellTags->{"S3.7.6", "6.10"}]},
  "6.11"->{
    Cell[61052, 2244, 109, 1, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.11"}]},
  "6.12"->{
    Cell[61405, 2259, 89, 1, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.12"}]},
  "6.13"->{
    Cell[61807, 2276, 158, 4, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.13"}]},
  "6.14"->{
    Cell[62184, 2294, 167, 5, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.14"}]},
  "6.15"->{
    Cell[62570, 2313, 625, 13, 70, "Text",
      CellTags->{"S3.7.6", "6.15"}]},
  "6.16"->{
    Cell[63198, 2328, 187, 5, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.16"}]},
  "6.17"->{
    Cell[63808, 2353, 237, 5, 70, "Text",
      CellTags->{"S3.7.6", "6.17"}]},
  "6.18"->{
    Cell[64048, 2360, 230, 6, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.18"}]},
  "6.19"->{
    Cell[64403, 2372, 157, 4, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.19"}]},
  "6.20"->{
    Cell[64921, 2392, 294, 7, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.20"}]},
  "6.21"->{
    Cell[65335, 2405, 133, 4, 70, "MathCaption",
      CellTags->{"S3.7.6", "6.21"}]},
  "6.22"->{
    Cell[65860, 2425, 355, 10, 70, "Text",
      CellTags->{"S3.7.6", "6.22"}]},
  "S3.7.7"->{
    Cell[66252, 2440, 82, 1, 70, "Subsection",
      CellTags->{"S3.7.7", "7.1"}],
    Cell[66337, 2443, 2896, 86, 70, "DefinitionBox",
      CellTags->"S3.7.7"],
    Cell[69236, 2531, 71, 1, 70, "Caption",
      CellTags->"S3.7.7"],
    Cell[69310, 2534, 582, 20, 70, "Text",
      CellTags->{"S3.7.7", "7.2"}],
    Cell[69895, 2556, 269, 9, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.3"}],
    Cell[70189, 2569, 102, 2, 70, "Input",
      CellTags->"S3.7.7"],
    Cell[70294, 2573, 108, 3, 70, "Output",
      CellTags->"S3.7.7"],
    Cell[70417, 2579, 2410, 85, 70, "Text",
      CellTags->{"S3.7.7", "7.4"}],
    Cell[72830, 2666, 853, 31, 70, "Text",
      CellTags->{"S3.7.7", "7.5"}],
    Cell[73686, 2699, 195, 6, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.6"}],
    Cell[73906, 2709, 87, 2, 70, "Input",
      CellTags->"S3.7.7"],
    Cell[73996, 2713, 97, 3, 70, "Output",
      CellTags->"S3.7.7"],
    Cell[74108, 2719, 583, 23, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.7"}],
    Cell[74716, 2746, 84, 2, 70, "Input",
      CellTags->"S3.7.7"],
    Cell[74803, 2750, 177, 4, 70, "Output",
      CellTags->"S3.7.7"],
    Cell[74995, 2757, 128, 5, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.8"}],
    Cell[75148, 2766, 72, 2, 70, "Input",
      CellTags->"S3.7.7"],
    Cell[75223, 2770, 265, 5, 70, "Output",
      CellTags->"S3.7.7"],
    Cell[75503, 2778, 278, 11, 70, "Text",
      CellTags->{"S3.7.7", "7.9"}],
    Cell[75784, 2791, 193, 6, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.10"}],
    Cell[76002, 2801, 84, 2, 70, "Input",
      CellTags->"S3.7.7"],
    Cell[76089, 2805, 86, 3, 70, "Output",
      CellTags->"S3.7.7"],
    Cell[76190, 2811, 876, 26, 70, "DefinitionBox",
      CellTags->"S3.7.7"],
    Cell[77069, 2839, 78, 1, 70, "Caption",
      CellTags->"S3.7.7"],
    Cell[77150, 2842, 170, 6, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.11"}],
    Cell[77345, 2852, 96, 2, 70, "Input",
      CellTags->"S3.7.7"],
    Cell[77444, 2856, 113, 3, 70, "Output",
      CellTags->"S3.7.7"],
    Cell[77572, 2862, 139, 5, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.12"}],
    Cell[77736, 2871, 81, 2, 70, "Input",
      CellTags->"S3.7.7"],
    Cell[77820, 2875, 162, 4, 70, "Output",
      CellTags->"S3.7.7"],
    Cell[77997, 2882, 117, 2, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.13"}],
    Cell[78139, 2888, 73, 2, 70, "Input",
      CellTags->"S3.7.7"],
    Cell[78215, 2892, 170, 4, 70, "Output",
      CellTags->"S3.7.7"],
    Cell[78400, 2899, 91, 1, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.14"}],
    Cell[78516, 2904, 84, 2, 70, "Input",
      CellTags->"S3.7.7"],
    Cell[78603, 2908, 176, 4, 70, "Output",
      CellTags->"S3.7.7"],
    Cell[78794, 2915, 139, 5, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.15"}],
    Cell[78958, 2924, 77, 2, 70, "Input",
      CellTags->"S3.7.7"],
    Cell[79038, 2928, 178, 4, 70, "Output",
      CellTags->"S3.7.7"],
    Cell[79231, 2935, 188, 5, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.16"}],
    Cell[79444, 2944, 101, 2, 70, "Input",
      CellTags->"S3.7.7"],
    Cell[79548, 2948, 178, 4, 70, "Output",
      CellTags->"S3.7.7"]},
  "7.1"->{
    Cell[66252, 2440, 82, 1, 70, "Subsection",
      CellTags->{"S3.7.7", "7.1"}]},
  "7.2"->{
    Cell[69310, 2534, 582, 20, 70, "Text",
      CellTags->{"S3.7.7", "7.2"}]},
  "7.3"->{
    Cell[69895, 2556, 269, 9, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.3"}]},
  "7.4"->{
    Cell[70417, 2579, 2410, 85, 70, "Text",
      CellTags->{"S3.7.7", "7.4"}]},
  "7.5"->{
    Cell[72830, 2666, 853, 31, 70, "Text",
      CellTags->{"S3.7.7", "7.5"}]},
  "7.6"->{
    Cell[73686, 2699, 195, 6, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.6"}]},
  "7.7"->{
    Cell[74108, 2719, 583, 23, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.7"}]},
  "7.8"->{
    Cell[74995, 2757, 128, 5, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.8"}]},
  "7.9"->{
    Cell[75503, 2778, 278, 11, 70, "Text",
      CellTags->{"S3.7.7", "7.9"}]},
  "7.10"->{
    Cell[75784, 2791, 193, 6, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.10"}]},
  "7.11"->{
    Cell[77150, 2842, 170, 6, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.11"}]},
  "7.12"->{
    Cell[77572, 2862, 139, 5, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.12"}]},
  "7.13"->{
    Cell[77997, 2882, 117, 2, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.13"}]},
  "7.14"->{
    Cell[78400, 2899, 91, 1, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.14"}]},
  "7.15"->{
    Cell[78794, 2915, 139, 5, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.15"}]},
  "7.16"->{
    Cell[79231, 2935, 188, 5, 70, "MathCaption",
      CellTags->{"S3.7.7", "7.16"}]},
  "S3.7.8"->{
    Cell[79775, 2958, 81, 1, 70, "Subsection",
      CellTags->{"S3.7.8", "8.1"}],
    Cell[79859, 2961, 274, 7, 70, "Text",
      CellTags->{"S3.7.8", "8.2"}],
    Cell[80136, 2970, 393, 7, 70, "Text",
      CellTags->{"S3.7.8", "8.3"}],
    Cell[80532, 2979, 508, 18, 70, "Text",
      CellTags->{"S3.7.8", "8.4"}],
    Cell[81043, 2999, 790, 21, 70, "Text",
      CellTags->{"S3.7.8", "8.5"}],
    Cell[81836, 3022, 2080, 65, 70, "DefinitionBox",
      CellTags->"S3.7.8"],
    Cell[83919, 3089, 79, 1, 70, "Caption",
      CellTags->"S3.7.8"],
    Cell[84001, 3092, 169, 6, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.6"}],
    Cell[84195, 3102, 84, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[84282, 3106, 97, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[84394, 3112, 87, 1, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.7"}],
    Cell[84506, 3117, 84, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[84593, 3121, 117, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[84725, 3127, 151, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.8"}],
    Cell[84901, 3136, 82, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[84986, 3140, 161, 4, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[85162, 3147, 247, 7, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.9"}],
    Cell[85434, 3158, 86, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[85523, 3162, 130, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[85668, 3168, 333, 11, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.10"}],
    Cell[86026, 3183, 83, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[86112, 3187, 130, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[86257, 3193, 193, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.11"}],
    Cell[86475, 3202, 97, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[86575, 3206, 155, 4, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[86745, 3213, 1581, 55, 70, "Text",
      CellTags->{"S3.7.8", "8.12"}],
    Cell[88329, 3270, 1227, 43, 70, "Text",
      CellTags->{"S3.7.8", "8.13"}],
    Cell[89559, 3315, 139, 4, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.14"}],
    Cell[89723, 3323, 84, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[89810, 3327, 97, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[89922, 3333, 88, 1, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.15"}],
    Cell[90035, 3338, 72, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[90110, 3342, 82, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[90207, 3348, 393, 14, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.16"}],
    Cell[90625, 3366, 86, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[90714, 3370, 153, 3, 70, "Message",
      CellTags->"S3.7.8"],
    Cell[90870, 3375, 118, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[91003, 3381, 155, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.17"}],
    Cell[91183, 3390, 79, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[91265, 3394, 95, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[91375, 3400, 175, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.18"}],
    Cell[91575, 3409, 75, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[91653, 3413, 88, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[91756, 3419, 174, 7, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.19"}],
    Cell[91955, 3430, 80, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[92038, 3434, 83, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[92136, 3440, 590, 14, 70, "Text",
      CellTags->{"S3.7.8", "8.20"}],
    Cell[92729, 3456, 111, 1, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.21"}],
    Cell[92865, 3461, 114, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[92982, 3465, 133, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[93130, 3471, 155, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.22"}],
    Cell[93310, 3480, 77, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[93390, 3484, 128, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[93533, 3490, 168, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.23"}],
    Cell[93726, 3499, 100, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[93829, 3503, 91, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[93935, 3509, 307, 11, 70, "Text",
      CellTags->{"S3.7.8", "8.24"}],
    Cell[94245, 3522, 638, 20, 70, "Text",
      CellTags->{"S3.7.8", "8.25"}],
    Cell[94886, 3544, 1239, 38, 70, "DefinitionBox",
      CellTags->"S3.7.8"],
    Cell[96128, 3584, 114, 4, 70, "Caption",
      CellTags->"S3.7.8"],
    Cell[96245, 3590, 434, 15, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.26"}],
    Cell[96704, 3609, 96, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[96803, 3613, 153, 3, 70, "Message",
      CellTags->"S3.7.8"],
    Cell[96959, 3618, 113, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[97087, 3624, 116, 2, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.27"}],
    Cell[97228, 3630, 91, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[97322, 3634, 104, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[97441, 3640, 185, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.28"}],
    Cell[97651, 3649, 91, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[97745, 3653, 97, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[97857, 3659, 241, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.29"}],
    Cell[98123, 3668, 77, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[98203, 3672, 103, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[98321, 3678, 250, 6, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.30"}],
    Cell[98596, 3688, 83, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[98682, 3692, 88, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[98785, 3698, 489, 16, 70, "Text",
      CellTags->{"S3.7.8", "8.31"}],
    Cell[99277, 3716, 758, 24, 70, "DefinitionBox",
      CellTags->"S3.7.8"],
    Cell[100038, 3742, 125, 5, 70, "Caption",
      CellTags->"S3.7.8"],
    Cell[100166, 3749, 920, 31, 70, "Text",
      CellTags->{"S3.7.8", "8.32"}],
    Cell[101089, 3782, 135, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.33"}],
    Cell[101249, 3791, 98, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[101350, 3795, 159, 5, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[101524, 3803, 87, 1, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.34"}],
    Cell[101636, 3808, 74, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[101713, 3812, 95, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[101823, 3818, 184, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.35"}],
    Cell[102032, 3827, 102, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[102137, 3831, 95, 3, 70, "Output",
      CellTags->"S3.7.8"],
    Cell[102247, 3837, 143, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.36"}],
    Cell[102415, 3846, 75, 2, 70, "Input",
      CellTags->"S3.7.8"],
    Cell[102493, 3850, 105, 3, 70, "Output",
      CellTags->"S3.7.8"]},
  "8.1"->{
    Cell[79775, 2958, 81, 1, 70, "Subsection",
      CellTags->{"S3.7.8", "8.1"}]},
  "8.2"->{
    Cell[79859, 2961, 274, 7, 70, "Text",
      CellTags->{"S3.7.8", "8.2"}]},
  "8.3"->{
    Cell[80136, 2970, 393, 7, 70, "Text",
      CellTags->{"S3.7.8", "8.3"}]},
  "8.4"->{
    Cell[80532, 2979, 508, 18, 70, "Text",
      CellTags->{"S3.7.8", "8.4"}]},
  "8.5"->{
    Cell[81043, 2999, 790, 21, 70, "Text",
      CellTags->{"S3.7.8", "8.5"}]},
  "8.6"->{
    Cell[84001, 3092, 169, 6, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.6"}]},
  "8.7"->{
    Cell[84394, 3112, 87, 1, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.7"}]},
  "8.8"->{
    Cell[84725, 3127, 151, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.8"}]},
  "8.9"->{
    Cell[85162, 3147, 247, 7, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.9"}]},
  "8.10"->{
    Cell[85668, 3168, 333, 11, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.10"}]},
  "8.11"->{
    Cell[86257, 3193, 193, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.11"}]},
  "8.12"->{
    Cell[86745, 3213, 1581, 55, 70, "Text",
      CellTags->{"S3.7.8", "8.12"}]},
  "8.13"->{
    Cell[88329, 3270, 1227, 43, 70, "Text",
      CellTags->{"S3.7.8", "8.13"}]},
  "8.14"->{
    Cell[89559, 3315, 139, 4, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.14"}]},
  "8.15"->{
    Cell[89922, 3333, 88, 1, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.15"}]},
  "8.16"->{
    Cell[90207, 3348, 393, 14, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.16"}]},
  "8.17"->{
    Cell[91003, 3381, 155, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.17"}]},
  "8.18"->{
    Cell[91375, 3400, 175, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.18"}]},
  "8.19"->{
    Cell[91756, 3419, 174, 7, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.19"}]},
  "8.20"->{
    Cell[92136, 3440, 590, 14, 70, "Text",
      CellTags->{"S3.7.8", "8.20"}]},
  "8.21"->{
    Cell[92729, 3456, 111, 1, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.21"}]},
  "8.22"->{
    Cell[93130, 3471, 155, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.22"}]},
  "8.23"->{
    Cell[93533, 3490, 168, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.23"}]},
  "8.24"->{
    Cell[93935, 3509, 307, 11, 70, "Text",
      CellTags->{"S3.7.8", "8.24"}]},
  "8.25"->{
    Cell[94245, 3522, 638, 20, 70, "Text",
      CellTags->{"S3.7.8", "8.25"}]},
  "8.26"->{
    Cell[96245, 3590, 434, 15, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.26"}]},
  "8.27"->{
    Cell[97087, 3624, 116, 2, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.27"}]},
  "8.28"->{
    Cell[97441, 3640, 185, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.28"}]},
  "8.29"->{
    Cell[97857, 3659, 241, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.29"}]},
  "8.30"->{
    Cell[98321, 3678, 250, 6, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.30"}]},
  "8.31"->{
    Cell[98785, 3698, 489, 16, 70, "Text",
      CellTags->{"S3.7.8", "8.31"}]},
  "8.32"->{
    Cell[100166, 3749, 920, 31, 70, "Text",
      CellTags->{"S3.7.8", "8.32"}]},
  "8.33"->{
    Cell[101089, 3782, 135, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.33"}]},
  "8.34"->{
    Cell[101524, 3803, 87, 1, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.34"}]},
  "8.35"->{
    Cell[101823, 3818, 184, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.35"}]},
  "8.36"->{
    Cell[102247, 3837, 143, 5, 70, "MathCaption",
      CellTags->{"S3.7.8", "8.36"}]},
  "S3.7.9"->{
    Cell[102647, 3859, 87, 1, 70, "Subsection",
      CellTags->{"S3.7.9", "9.1"}],
    Cell[102737, 3862, 2726, 84, 70, "DefinitionBox",
      CellTags->"S3.7.9"],
    Cell[105466, 3948, 71, 1, 70, "Caption",
      CellTags->"S3.7.9"],
    Cell[105540, 3951, 1312, 49, 70, "Text",
      CellTags->{"S3.7.9", "9.2"}],
    Cell[106855, 4002, 751, 31, 70, "Text",
      CellTags->{"S3.7.9", "9.3"}],
    Cell[107609, 4035, 1013, 30, 70, "Text",
      CellTags->{"S3.7.9", "9.4"}],
    Cell[108625, 4067, 160, 4, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.5"}],
    Cell[108810, 4075, 97, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[108910, 4079, 170, 4, 70, "Output",
      CellTags->"S3.7.9"],
    Cell[109095, 4086, 219, 5, 70, "Text",
      CellTags->{"S3.7.9", "9.6"}],
    Cell[109317, 4093, 179, 6, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.7"}],
    Cell[109521, 4103, 93, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[109617, 4107, 114, 3, 70, "Output",
      CellTags->"S3.7.9"],
    Cell[109746, 4113, 110, 1, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.8"}],
    Cell[109881, 4118, 80, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[109964, 4122, 126, 3, 70, "Output",
      CellTags->"S3.7.9"],
    Cell[110105, 4128, 134, 5, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.9"}],
    Cell[110264, 4137, 81, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[110348, 4141, 182, 4, 70, "Output",
      CellTags->"S3.7.9"],
    Cell[110545, 4148, 314, 9, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.10"}],
    Cell[110884, 4161, 93, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[110980, 4165, 244, 5, 70, "Output",
      CellTags->"S3.7.9"],
    Cell[111239, 4173, 156, 4, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.11"}],
    Cell[111420, 4181, 100, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[111523, 4185, 85, 3, 70, "Output",
      CellTags->"S3.7.9"],
    Cell[111623, 4191, 280, 7, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.12"}],
    Cell[111928, 4202, 105, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[112036, 4206, 314, 6, 70, "Output",
      CellTags->"S3.7.9"],
    Cell[112365, 4215, 1158, 35, 70, "Text",
      CellTags->{"S3.7.9", "9.13"}],
    Cell[113526, 4252, 170, 6, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.14"}],
    Cell[113721, 4262, 102, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[113826, 4266, 114, 3, 70, "Output",
      CellTags->"S3.7.9"],
    Cell[113955, 4272, 108, 1, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.15"}],
    Cell[114088, 4277, 79, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[114170, 4281, 90, 3, 70, "Output",
      CellTags->"S3.7.9"],
    Cell[114275, 4287, 252, 5, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.16"}],
    Cell[114552, 4296, 81, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[114636, 4300, 115, 3, 70, "Output",
      CellTags->"S3.7.9"],
    Cell[114766, 4306, 1995, 64, 70, "DefinitionBox",
      CellTags->"S3.7.9"],
    Cell[116764, 4372, 83, 1, 70, "Caption",
      CellTags->"S3.7.9"],
    Cell[116850, 4375, 626, 21, 70, "Text",
      CellTags->{"S3.7.9", "9.17"}],
    Cell[117479, 4398, 115, 2, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.18"}],
    Cell[117619, 4404, 94, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[117716, 4408, 126, 3, 70, "Output",
      CellTags->"S3.7.9"],
    Cell[117857, 4414, 111, 1, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.19"}],
    Cell[117993, 4419, 69, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[118065, 4423, 128, 3, 70, "Output",
      CellTags->"S3.7.9"],
    Cell[118208, 4429, 127, 4, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.20"}],
    Cell[118360, 4437, 117, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[118480, 4441, 285, 5, 70, "Output",
      CellTags->"S3.7.9"],
    Cell[118780, 4449, 1607, 50, 70, "DefinitionBox",
      CellTags->"S3.7.9"],
    Cell[120390, 4501, 83, 1, 70, "Caption",
      CellTags->"S3.7.9"],
    Cell[120476, 4504, 1071, 40, 70, "Text",
      CellTags->{"S3.7.9", "9.21"}],
    Cell[121550, 4546, 329, 14, 70, "Text",
      CellTags->{"S3.7.9", "9.22"}],
    Cell[121882, 4562, 611, 18, 70, "Text",
      CellTags->{"S3.7.9", "9.23"}],
    Cell[122496, 4582, 212, 6, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.24"}],
    Cell[122733, 4592, 116, 2, 70, "Input",
      CellTags->"S3.7.9"],
    Cell[122852, 4596, 102, 3, 70, "Output",
      CellTags->"S3.7.9"]},
  "9.1"->{
    Cell[102647, 3859, 87, 1, 70, "Subsection",
      CellTags->{"S3.7.9", "9.1"}]},
  "9.2"->{
    Cell[105540, 3951, 1312, 49, 70, "Text",
      CellTags->{"S3.7.9", "9.2"}]},
  "9.3"->{
    Cell[106855, 4002, 751, 31, 70, "Text",
      CellTags->{"S3.7.9", "9.3"}]},
  "9.4"->{
    Cell[107609, 4035, 1013, 30, 70, "Text",
      CellTags->{"S3.7.9", "9.4"}]},
  "9.5"->{
    Cell[108625, 4067, 160, 4, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.5"}]},
  "9.6"->{
    Cell[109095, 4086, 219, 5, 70, "Text",
      CellTags->{"S3.7.9", "9.6"}]},
  "9.7"->{
    Cell[109317, 4093, 179, 6, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.7"}]},
  "9.8"->{
    Cell[109746, 4113, 110, 1, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.8"}]},
  "9.9"->{
    Cell[110105, 4128, 134, 5, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.9"}]},
  "9.10"->{
    Cell[110545, 4148, 314, 9, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.10"}]},
  "9.11"->{
    Cell[111239, 4173, 156, 4, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.11"}]},
  "9.12"->{
    Cell[111623, 4191, 280, 7, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.12"}]},
  "9.13"->{
    Cell[112365, 4215, 1158, 35, 70, "Text",
      CellTags->{"S3.7.9", "9.13"}]},
  "9.14"->{
    Cell[113526, 4252, 170, 6, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.14"}]},
  "9.15"->{
    Cell[113955, 4272, 108, 1, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.15"}]},
  "9.16"->{
    Cell[114275, 4287, 252, 5, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.16"}]},
  "9.17"->{
    Cell[116850, 4375, 626, 21, 70, "Text",
      CellTags->{"S3.7.9", "9.17"}]},
  "9.18"->{
    Cell[117479, 4398, 115, 2, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.18"}]},
  "9.19"->{
    Cell[117857, 4414, 111, 1, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.19"}]},
  "9.20"->{
    Cell[118208, 4429, 127, 4, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.20"}]},
  "9.21"->{
    Cell[120476, 4504, 1071, 40, 70, "Text",
      CellTags->{"S3.7.9", "9.21"}]},
  "9.22"->{
    Cell[121550, 4546, 329, 14, 70, "Text",
      CellTags->{"S3.7.9", "9.22"}]},
  "9.23"->{
    Cell[121882, 4562, 611, 18, 70, "Text",
      CellTags->{"S3.7.9", "9.23"}]},
  "9.24"->{
    Cell[122496, 4582, 212, 6, 70, "MathCaption",
      CellTags->{"S3.7.9", "9.24"}]},
  "S3.7.10"->{
    Cell[123003, 4605, 88, 1, 70, "Subsection",
      CellTags->{"S3.7.10", "10.1"}],
    Cell[123094, 4608, 1929, 61, 70, "DefinitionBox",
      CellTags->"S3.7.10"],
    Cell[125026, 4671, 89, 1, 70, "Caption",
      CellTags->"S3.7.10"],
    Cell[125118, 4674, 1229, 37, 70, "Text",
      CellTags->{"S3.7.10", "10.2"}],
    Cell[126350, 4713, 932, 32, 70, "Text",
      CellTags->{"S3.7.10", "10.3"}],
    Cell[127285, 4747, 720, 26, 70, "Text",
      CellTags->{"S3.7.10", "10.4"}],
    Cell[128008, 4775, 1531, 57, 70, "Text",
      CellTags->{"S3.7.10", "10.5"}],
    Cell[129542, 4834, 645, 18, 70, "DefinitionBox",
      CellTags->"S3.7.10"],
    Cell[130190, 4854, 86, 1, 70, "Caption",
      CellTags->"S3.7.10"],
    Cell[130279, 4857, 391, 12, 70, "Text",
      CellTags->{"S3.7.10", "10.6"}],
    Cell[130673, 4871, 491, 9, 70, "Text",
      CellTags->{"S3.7.10", "10.7"}],
    Cell[131167, 4882, 1205, 33, 70, "DefinitionBox",
      CellTags->"S3.7.10"],
    Cell[132375, 4917, 81, 1, 70, "Caption",
      CellTags->"S3.7.10"],
    Cell[132459, 4920, 1213, 36, 70, "Text",
      CellTags->{"S3.7.10", "10.8"}],
    Cell[133675, 4958, 916, 32, 70, "Text",
      CellTags->{"S3.7.10", "10.9"}],
    Cell[134594, 4992, 1295, 46, 70, "Text",
      CellTags->{"S3.7.10", "10.10"}],
    Cell[135892, 5040, 1200, 33, 70, "DefinitionBox",
      CellTags->"S3.7.10"],
    Cell[137095, 5075, 84, 1, 70, "Caption",
      CellTags->"S3.7.10"],
    Cell[137182, 5078, 665, 16, 70, "Text",
      CellTags->{"S3.7.10", "10.11"}],
    Cell[137850, 5096, 1459, 50, 70, "Text",
      CellTags->{"S3.7.10", "10.12"}]},
  "10.1"->{
    Cell[123003, 4605, 88, 1, 70, "Subsection",
      CellTags->{"S3.7.10", "10.1"}]},
  "10.2"->{
    Cell[125118, 4674, 1229, 37, 70, "Text",
      CellTags->{"S3.7.10", "10.2"}]},
  "10.3"->{
    Cell[126350, 4713, 932, 32, 70, "Text",
      CellTags->{"S3.7.10", "10.3"}]},
  "10.4"->{
    Cell[127285, 4747, 720, 26, 70, "Text",
      CellTags->{"S3.7.10", "10.4"}]},
  "10.5"->{
    Cell[128008, 4775, 1531, 57, 70, "Text",
      CellTags->{"S3.7.10", "10.5"}]},
  "10.6"->{
    Cell[130279, 4857, 391, 12, 70, "Text",
      CellTags->{"S3.7.10", "10.6"}]},
  "10.7"->{
    Cell[130673, 4871, 491, 9, 70, "Text",
      CellTags->{"S3.7.10", "10.7"}]},
  "10.8"->{
    Cell[132459, 4920, 1213, 36, 70, "Text",
      CellTags->{"S3.7.10", "10.8"}]},
  "10.9"->{
    Cell[133675, 4958, 916, 32, 70, "Text",
      CellTags->{"S3.7.10", "10.9"}]},
  "10.10"->{
    Cell[134594, 4992, 1295, 46, 70, "Text",
      CellTags->{"S3.7.10", "10.10"}]},
  "10.11"->{
    Cell[137182, 5078, 665, 16, 70, "Text",
      CellTags->{"S3.7.10", "10.11"}]},
  "10.12"->{
    Cell[137850, 5096, 1459, 50, 70, "Text",
      CellTags->{"S3.7.10", "10.12"}]},
  "S3.7.11"->{
    Cell[139346, 5151, 85, 1, 70, "Subsection",
      CellTags->{"S3.7.11", "11.1"}],
    Cell[139434, 5154, 373, 10, 70, "Text",
      CellTags->{"S3.7.11", "11.2"}],
    Cell[139810, 5166, 856, 30, 70, "DefinitionBox",
      CellTags->"S3.7.11"],
    Cell[140669, 5198, 75, 1, 70, "Caption",
      CellTags->"S3.7.11"],
    Cell[140747, 5201, 770, 24, 70, "Text",
      CellTags->{"S3.7.11", "11.3"}],
    Cell[141520, 5227, 303, 8, 70, "Text",
      CellTags->{"S3.7.11", "11.4"}],
    Cell[141826, 5237, 730, 18, 70, "Text",
      CellTags->{"S3.7.11", "11.5"}],
    Cell[142559, 5257, 6098, 173, 70, "DefinitionBox",
      CellTags->"S3.7.11"],
    Cell[148660, 5432, 113, 4, 70, "Caption",
      CellTags->"S3.7.11"],
    Cell[148776, 5438, 180, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.6"}],
    Cell[148981, 5448, 111, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[149095, 5452, 134, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[149244, 5458, 104, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.7"}],
    Cell[149373, 5463, 96, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[149472, 5467, 134, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[149621, 5473, 324, 8, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.8"}],
    Cell[149970, 5485, 80, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[150053, 5489, 2092, 60, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[152160, 5552, 141, 4, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.9"}],
    Cell[152326, 5560, 80, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[152409, 5564, 91, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[152515, 5570, 182, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.10"}],
    Cell[152722, 5580, 77, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[152802, 5584, 83, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[152900, 5590, 136, 4, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.11"}],
    Cell[153061, 5598, 80, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[153144, 5602, 83, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[153242, 5608, 215, 5, 70, "Text",
      CellTags->{"S3.7.11", "11.12"}],
    Cell[153460, 5615, 6321, 178, 70, "DefinitionBox",
      CellTags->"S3.7.11"],
    Cell[159784, 5795, 74, 1, 70, "Caption",
      CellTags->"S3.7.11"],
    Cell[159861, 5798, 827, 24, 70, "Text",
      CellTags->{"S3.7.11", "11.13"}],
    Cell[160691, 5824, 2390, 90, 70, "Text",
      CellTags->{"S3.7.11", "11.14"}],
    Cell[163084, 5916, 1246, 44, 70, "Text",
      CellTags->{"S3.7.11", "11.15"}],
    Cell[164333, 5962, 211, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.16"}],
    Cell[164569, 5972, 94, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[164666, 5976, 107, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[164788, 5982, 367, 11, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.17"}],
    Cell[165180, 5997, 82, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[165265, 6001, 109, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[165389, 6007, 286, 11, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.18"}],
    Cell[165700, 6022, 90, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[165793, 6026, 90, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[165898, 6032, 196, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.19"}],
    Cell[166119, 6042, 92, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[166214, 6046, 343, 7, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[166572, 6056, 162, 5, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.20"}],
    Cell[166759, 6065, 84, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[166846, 6069, 345, 7, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[167206, 6079, 196, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.21"}],
    Cell[167427, 6089, 83, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[167513, 6093, 95, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[167623, 6099, 248, 6, 70, "Text",
      CellTags->{"S3.7.11", "11.22"}],
    Cell[167874, 6107, 201, 5, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.23"}],
    Cell[168100, 6116, 107, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[168210, 6120, 119, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[168344, 6126, 99, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.24"}],
    Cell[168468, 6131, 104, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[168575, 6135, 135, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[168725, 6141, 156, 5, 70, "Text",
      CellTags->{"S3.7.11", "11.25"}],
    Cell[168884, 6148, 107, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.26"}],
    Cell[169016, 6153, 89, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[169108, 6157, 119, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[169242, 6163, 132, 4, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.27"}],
    Cell[169399, 6171, 95, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[169497, 6175, 119, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[169631, 6181, 111, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.28"}],
    Cell[169767, 6186, 98, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[169868, 6190, 206, 4, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[170089, 6197, 265, 5, 70, "Text",
      CellTags->{"S3.7.11", "11.29"}],
    Cell[170357, 6204, 689, 25, 70, "Text",
      CellTags->{"S3.7.11", "11.30"}],
    Cell[171049, 6231, 211, 5, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.31"}],
    Cell[171285, 6240, 94, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[171382, 6244, 127, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[171524, 6250, 318, 9, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.32"}],
    Cell[171867, 6263, 97, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[171967, 6267, 158, 4, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[172140, 6274, 469, 14, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.33"}],
    Cell[172634, 6292, 113, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[172750, 6296, 249, 5, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[173014, 6304, 96, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.34"}],
    Cell[173135, 6309, 81, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[173219, 6313, 92, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[173326, 6319, 2035, 71, 70, "Text",
      CellTags->{"S3.7.11", "11.35"}],
    Cell[175364, 6392, 2923, 109, 70, "Text",
      CellTags->{"S3.7.11", "11.36"}],
    Cell[178290, 6503, 287, 9, 70, "Text",
      CellTags->{"S3.7.11", "11.37"}],
    Cell[178580, 6514, 383, 11, 70, "Text",
      CellTags->{"S3.7.11", "11.38"}],
    Cell[178966, 6527, 2623, 97, 70, "Text",
      CellTags->{"S3.7.11", "11.39"}],
    Cell[181592, 6626, 863, 30, 70, "Text",
      CellTags->{"S3.7.11", "11.40"}],
    Cell[182458, 6658, 141, 4, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.41"}],
    Cell[182624, 6666, 102, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[182729, 6670, 114, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[182858, 6676, 106, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.42"}],
    Cell[182989, 6681, 113, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[183105, 6685, 180, 4, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[183300, 6692, 181, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.43"}],
    Cell[183506, 6702, 90, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[183599, 6706, 137, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[183751, 6712, 181, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.44"}],
    Cell[183957, 6722, 90, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[184050, 6726, 117, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[184182, 6732, 193, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.45"}],
    Cell[184400, 6742, 71, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[184474, 6746, 193, 4, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[184682, 6753, 96, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.46"}],
    Cell[184803, 6758, 81, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[184887, 6762, 95, 3, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[184997, 6768, 513, 12, 70, "Text",
      CellTags->{"S3.7.11", "11.47"}],
    Cell[185513, 6782, 674, 24, 70, "Text",
      CellTags->{"S3.7.11", "11.48"}],
    Cell[186190, 6808, 6940, 203, 70, "DefinitionBox",
      CellTags->"S3.7.11"],
    Cell[193133, 7013, 116, 4, 70, "Caption",
      CellTags->"S3.7.11"],
    Cell[193252, 7019, 118, 2, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.49"}],
    Cell[193395, 7025, 100, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[193498, 7029, 178, 4, 70, "Output",
      CellTags->"S3.7.11"],
    Cell[193691, 7036, 135, 4, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.50"}],
    Cell[193851, 7044, 103, 2, 70, "Input",
      CellTags->"S3.7.11"],
    Cell[193957, 7048, 152, 4, 70, "Output",
      CellTags->"S3.7.11"]},
  "11.1"->{
    Cell[139346, 5151, 85, 1, 70, "Subsection",
      CellTags->{"S3.7.11", "11.1"}]},
  "11.2"->{
    Cell[139434, 5154, 373, 10, 70, "Text",
      CellTags->{"S3.7.11", "11.2"}]},
  "11.3"->{
    Cell[140747, 5201, 770, 24, 70, "Text",
      CellTags->{"S3.7.11", "11.3"}]},
  "11.4"->{
    Cell[141520, 5227, 303, 8, 70, "Text",
      CellTags->{"S3.7.11", "11.4"}]},
  "11.5"->{
    Cell[141826, 5237, 730, 18, 70, "Text",
      CellTags->{"S3.7.11", "11.5"}]},
  "11.6"->{
    Cell[148776, 5438, 180, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.6"}]},
  "11.7"->{
    Cell[149244, 5458, 104, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.7"}]},
  "11.8"->{
    Cell[149621, 5473, 324, 8, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.8"}]},
  "11.9"->{
    Cell[152160, 5552, 141, 4, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.9"}]},
  "11.10"->{
    Cell[152515, 5570, 182, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.10"}]},
  "11.11"->{
    Cell[152900, 5590, 136, 4, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.11"}]},
  "11.12"->{
    Cell[153242, 5608, 215, 5, 70, "Text",
      CellTags->{"S3.7.11", "11.12"}]},
  "11.13"->{
    Cell[159861, 5798, 827, 24, 70, "Text",
      CellTags->{"S3.7.11", "11.13"}]},
  "11.14"->{
    Cell[160691, 5824, 2390, 90, 70, "Text",
      CellTags->{"S3.7.11", "11.14"}]},
  "11.15"->{
    Cell[163084, 5916, 1246, 44, 70, "Text",
      CellTags->{"S3.7.11", "11.15"}]},
  "11.16"->{
    Cell[164333, 5962, 211, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.16"}]},
  "11.17"->{
    Cell[164788, 5982, 367, 11, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.17"}]},
  "11.18"->{
    Cell[165389, 6007, 286, 11, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.18"}]},
  "11.19"->{
    Cell[165898, 6032, 196, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.19"}]},
  "11.20"->{
    Cell[166572, 6056, 162, 5, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.20"}]},
  "11.21"->{
    Cell[167206, 6079, 196, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.21"}]},
  "11.22"->{
    Cell[167623, 6099, 248, 6, 70, "Text",
      CellTags->{"S3.7.11", "11.22"}]},
  "11.23"->{
    Cell[167874, 6107, 201, 5, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.23"}]},
  "11.24"->{
    Cell[168344, 6126, 99, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.24"}]},
  "11.25"->{
    Cell[168725, 6141, 156, 5, 70, "Text",
      CellTags->{"S3.7.11", "11.25"}]},
  "11.26"->{
    Cell[168884, 6148, 107, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.26"}]},
  "11.27"->{
    Cell[169242, 6163, 132, 4, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.27"}]},
  "11.28"->{
    Cell[169631, 6181, 111, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.28"}]},
  "11.29"->{
    Cell[170089, 6197, 265, 5, 70, "Text",
      CellTags->{"S3.7.11", "11.29"}]},
  "11.30"->{
    Cell[170357, 6204, 689, 25, 70, "Text",
      CellTags->{"S3.7.11", "11.30"}]},
  "11.31"->{
    Cell[171049, 6231, 211, 5, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.31"}]},
  "11.32"->{
    Cell[171524, 6250, 318, 9, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.32"}]},
  "11.33"->{
    Cell[172140, 6274, 469, 14, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.33"}]},
  "11.34"->{
    Cell[173014, 6304, 96, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.34"}]},
  "11.35"->{
    Cell[173326, 6319, 2035, 71, 70, "Text",
      CellTags->{"S3.7.11", "11.35"}]},
  "11.36"->{
    Cell[175364, 6392, 2923, 109, 70, "Text",
      CellTags->{"S3.7.11", "11.36"}]},
  "11.37"->{
    Cell[178290, 6503, 287, 9, 70, "Text",
      CellTags->{"S3.7.11", "11.37"}]},
  "11.38"->{
    Cell[178580, 6514, 383, 11, 70, "Text",
      CellTags->{"S3.7.11", "11.38"}]},
  "11.39"->{
    Cell[178966, 6527, 2623, 97, 70, "Text",
      CellTags->{"S3.7.11", "11.39"}]},
  "11.40"->{
    Cell[181592, 6626, 863, 30, 70, "Text",
      CellTags->{"S3.7.11", "11.40"}]},
  "11.41"->{
    Cell[182458, 6658, 141, 4, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.41"}]},
  "11.42"->{
    Cell[182858, 6676, 106, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.42"}]},
  "11.43"->{
    Cell[183300, 6692, 181, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.43"}]},
  "11.44"->{
    Cell[183751, 6712, 181, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.44"}]},
  "11.45"->{
    Cell[184182, 6732, 193, 6, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.45"}]},
  "11.46"->{
    Cell[184682, 6753, 96, 1, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.46"}]},
  "11.47"->{
    Cell[184997, 6768, 513, 12, 70, "Text",
      CellTags->{"S3.7.11", "11.47"}]},
  "11.48"->{
    Cell[185513, 6782, 674, 24, 70, "Text",
      CellTags->{"S3.7.11", "11.48"}]},
  "11.49"->{
    Cell[193252, 7019, 118, 2, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.49"}]},
  "11.50"->{
    Cell[193691, 7036, 135, 4, 70, "MathCaption",
      CellTags->{"S3.7.11", "11.50"}]},
  "S3.7.12"->{
    Cell[194158, 7058, 75, 1, 70, "Subsection",
      CellTags->{"S3.7.12", "12.1"}],
    Cell[194236, 7061, 619, 16, 70, "Text",
      CellTags->{"S3.7.12", "12.2"}],
    Cell[194858, 7079, 6240, 180, 70, "DefinitionBox",
      CellTags->"S3.7.12"],
    Cell[201101, 7261, 68, 1, 70, "Caption",
      CellTags->"S3.7.12"],
    Cell[201172, 7264, 336, 9, 70, "Text",
      CellTags->{"S3.7.12", "12.3"}],
    Cell[201511, 7275, 229, 6, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.4"}],
    Cell[201765, 7285, 151, 5, 70, "Input",
      CellTags->"S3.7.12"],
    Cell[201919, 7292, 350, 10, 70, "Output",
      CellTags->"S3.7.12"],
    Cell[202284, 7305, 117, 2, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.5"}],
    Cell[202426, 7311, 84, 2, 70, "Input",
      CellTags->"S3.7.12"],
    Cell[202513, 7315, 18500, 1558, 70, 18426, 1555, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.7.12"],
    Cell[221016, 8875, 185, 5, 70, "Output",
      CellTags->"S3.7.12"],
    Cell[221216, 8883, 109, 1, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.6"}],
    Cell[221350, 8888, 82, 2, 70, "Input",
      CellTags->"S3.7.12"],
    Cell[221435, 8892, 175, 4, 70, "Output",
      CellTags->"S3.7.12"],
    Cell[221625, 8899, 154, 6, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.7"}],
    Cell[221804, 8909, 70, 2, 70, "Input",
      CellTags->"S3.7.12"],
    Cell[221877, 8913, 352, 10, 70, "Output",
      CellTags->"S3.7.12"],
    Cell[222244, 8926, 110, 1, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.8"}],
    Cell[222379, 8931, 76, 2, 70, "Input",
      CellTags->"S3.7.12"],
    Cell[222458, 8935, 89, 3, 70, "Output",
      CellTags->"S3.7.12"],
    Cell[222562, 8941, 315, 8, 70, "Text",
      CellTags->{"S3.7.12", "12.9"}],
    Cell[222880, 8951, 2577, 85, 70, "DefinitionBox",
      CellTags->"S3.7.12"],
    Cell[225460, 9038, 164, 5, 70, "Caption",
      CellTags->"S3.7.12"],
    Cell[225627, 9045, 176, 5, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.10"}],
    Cell[225828, 9054, 76, 2, 70, "Input",
      CellTags->"S3.7.12"],
    Cell[225907, 9058, 342, 10, 70, "Output",
      CellTags->"S3.7.12"],
    Cell[226264, 9071, 155, 5, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.11"}],
    Cell[226444, 9080, 94, 2, 70, "Input",
      CellTags->"S3.7.12"],
    Cell[226541, 9084, 352, 10, 70, "Output",
      CellTags->"S3.7.12"],
    Cell[226908, 9097, 130, 4, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.12"}],
    Cell[227063, 9105, 76, 2, 70, "Input",
      CellTags->"S3.7.12"],
    Cell[227142, 9109, 344, 10, 70, "Output",
      CellTags->"S3.7.12"],
    Cell[227501, 9122, 141, 4, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.13"}],
    Cell[227667, 9130, 83, 2, 70, "Input",
      CellTags->"S3.7.12"],
    Cell[227753, 9134, 156, 4, 70, "Output",
      CellTags->"S3.7.12"],
    Cell[227924, 9141, 1948, 53, 70, "DefinitionBox",
      CellTags->"S3.7.12"],
    Cell[229875, 9196, 77, 1, 70, "Caption",
      CellTags->"S3.7.12"],
    Cell[229955, 9199, 101, 1, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.14"}],
    Cell[230081, 9204, 138, 5, 70, "Input",
      CellTags->"S3.7.12"],
    Cell[230222, 9211, 353, 10, 70, "Output",
      CellTags->"S3.7.12"],
    Cell[230590, 9224, 118, 2, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.15"}],
    Cell[230733, 9230, 84, 2, 70, "Input",
      CellTags->"S3.7.12"],
    Cell[230820, 9234, 355, 10, 70, "Output",
      CellTags->"S3.7.12"],
    Cell[231190, 9247, 106, 1, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.16"}],
    Cell[231321, 9252, 144, 5, 45, "Input",
      CellTags->"S3.7.12"],
    Cell[231468, 9259, 790, 24, 70, "Output",
      CellTags->"S3.7.12"],
    Cell[232273, 9286, 101, 1, 40, "MathCaption",
      CellTags->{"S3.7.12", "12.17"}],
    Cell[232399, 9291, 75, 2, 28, "Input",
      CellTags->"S3.7.12"],
    Cell[232477, 9295, 120, 3, 25, "Output",
      CellTags->"S3.7.12"],
    Cell[232612, 9301, 93, 1, 40, "MathCaption",
      CellTags->{"S3.7.12", "12.18"}],
    Cell[232730, 9306, 93, 2, 28, "Input",
      CellTags->"S3.7.12"],
    Cell[232826, 9310, 108, 3, 25, "Output",
      CellTags->"S3.7.12"],
    Cell[232949, 9316, 154, 4, 40, "MathCaption",
      CellTags->{"S3.7.12", "12.19"}],
    Cell[233128, 9324, 151, 5, 45, "Input",
      CellTags->"S3.7.12"],
    Cell[233282, 9331, 1135, 34, 41, "Output",
      CellTags->"S3.7.12"],
    Cell[234432, 9368, 136, 4, 40, "MathCaption",
      CellTags->{"S3.7.12", "12.20"}],
    Cell[234593, 9376, 75, 2, 28, "Input",
      CellTags->"S3.7.12"],
    Cell[234671, 9380, 225, 6, 57, "Output",
      CellTags->"S3.7.12"],
    Cell[234911, 9389, 93, 1, 40, "MathCaption",
      CellTags->{"S3.7.12", "12.21"}],
    Cell[235029, 9394, 126, 2, 45, "Input",
      CellTags->"S3.7.12"],
    Cell[235158, 9398, 117, 3, 27, "Output",
      CellTags->"S3.7.12"],
    Cell[235290, 9404, 415, 12, 56, "Text",
      CellTags->{"S3.7.12", "12.22"}]},
  "12.1"->{
    Cell[194158, 7058, 75, 1, 70, "Subsection",
      CellTags->{"S3.7.12", "12.1"}]},
  "12.2"->{
    Cell[194236, 7061, 619, 16, 70, "Text",
      CellTags->{"S3.7.12", "12.2"}]},
  "12.3"->{
    Cell[201172, 7264, 336, 9, 70, "Text",
      CellTags->{"S3.7.12", "12.3"}]},
  "12.4"->{
    Cell[201511, 7275, 229, 6, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.4"}]},
  "12.5"->{
    Cell[202284, 7305, 117, 2, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.5"}]},
  "12.6"->{
    Cell[221216, 8883, 109, 1, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.6"}]},
  "12.7"->{
    Cell[221625, 8899, 154, 6, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.7"}]},
  "12.8"->{
    Cell[222244, 8926, 110, 1, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.8"}]},
  "12.9"->{
    Cell[222562, 8941, 315, 8, 70, "Text",
      CellTags->{"S3.7.12", "12.9"}]},
  "12.10"->{
    Cell[225627, 9045, 176, 5, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.10"}]},
  "12.11"->{
    Cell[226264, 9071, 155, 5, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.11"}]},
  "12.12"->{
    Cell[226908, 9097, 130, 4, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.12"}]},
  "12.13"->{
    Cell[227501, 9122, 141, 4, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.13"}]},
  "12.14"->{
    Cell[229955, 9199, 101, 1, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.14"}]},
  "12.15"->{
    Cell[230590, 9224, 118, 2, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.15"}]},
  "12.16"->{
    Cell[231190, 9247, 106, 1, 70, "MathCaption",
      CellTags->{"S3.7.12", "12.16"}]},
  "12.17"->{
    Cell[232273, 9286, 101, 1, 40, "MathCaption",
      CellTags->{"S3.7.12", "12.17"}]},
  "12.18"->{
    Cell[232612, 9301, 93, 1, 40, "MathCaption",
      CellTags->{"S3.7.12", "12.18"}]},
  "12.19"->{
    Cell[232949, 9316, 154, 4, 40, "MathCaption",
      CellTags->{"S3.7.12", "12.19"}]},
  "12.20"->{
    Cell[234432, 9368, 136, 4, 40, "MathCaption",
      CellTags->{"S3.7.12", "12.20"}]},
  "12.21"->{
    Cell[234911, 9389, 93, 1, 40, "MathCaption",
      CellTags->{"S3.7.12", "12.21"}]},
  "12.22"->{
    Cell[235290, 9404, 415, 12, 56, "Text",
      CellTags->{"S3.7.12", "12.22"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S3.7.0", 236348, 9436},
  {"0.1", 236438, 9439},
  {"S3.7.1", 236531, 9442},
  {"1.1", 238848, 9505},
  {"1.2", 238940, 9508},
  {"1.3", 239036, 9511},
  {"1.4", 239131, 9514},
  {"1.5", 239227, 9517},
  {"1.6", 239324, 9520},
  {"1.7", 239420, 9523},
  {"1.8", 239516, 9526},
  {"1.9", 239612, 9529},
  {"S3.7.2", 239711, 9532},
  {"2.1", 242191, 9599},
  {"2.2", 242285, 9602},
  {"2.3", 242374, 9605},
  {"2.4", 242470, 9608},
  {"2.5", 242565, 9611},
  {"2.6", 242660, 9614},
  {"2.7", 242755, 9617},
  {"2.8", 242852, 9620},
  {"2.9", 242949, 9623},
  {"2.10", 243047, 9626},
  {"2.11", 243146, 9629},
  {"S3.7.3", 243247, 9632},
  {"3.1", 244771, 9673},
  {"3.2", 244866, 9676},
  {"3.3", 244956, 9679},
  {"3.4", 245046, 9682},
  {"3.5", 245143, 9685},
  {"3.6", 245240, 9688},
  {"3.7", 245337, 9691},
  {"3.8", 245434, 9694},
  {"S3.7.4", 245534, 9697},
  {"4.1", 248411, 9774},
  {"4.2", 248507, 9777},
  {"4.3", 248597, 9780},
  {"4.4", 248687, 9783},
  {"4.5", 248784, 9786},
  {"4.6", 248881, 9789},
  {"4.7", 248978, 9792},
  {"4.8", 249075, 9795},
  {"4.9", 249172, 9798},
  {"4.10", 249270, 9801},
  {"4.11", 249369, 9804},
  {"4.12", 249468, 9807},
  {"4.13", 249561, 9810},
  {"4.14", 249660, 9813},
  {"4.15", 249759, 9816},
  {"S3.7.5", 249860, 9819},
  {"5.1", 253575, 9918},
  {"5.2", 253670, 9921},
  {"5.3", 253767, 9924},
  {"5.4", 253864, 9927},
  {"5.5", 253961, 9930},
  {"5.6", 254058, 9933},
  {"5.7", 254149, 9936},
  {"5.8", 254246, 9939},
  {"5.9", 254343, 9942},
  {"5.10", 254441, 9945},
  {"5.11", 254540, 9948},
  {"5.12", 254632, 9951},
  {"5.13", 254731, 9954},
  {"5.14", 254829, 9957},
  {"5.15", 254928, 9960},
  {"5.16", 255027, 9963},
  {"5.17", 255119, 9966},
  {"5.18", 255218, 9969},
  {"5.19", 255317, 9972},
  {"S3.7.6", 255411, 9975},
  {"6.1", 259810, 10092},
  {"6.2", 259905, 10095},
  {"6.3", 260002, 10098},
  {"6.4", 260100, 10101},
  {"6.5", 260197, 10104},
  {"6.6", 260294, 10107},
  {"6.7", 260390, 10110},
  {"6.8", 260487, 10113},
  {"6.9", 260584, 10116},
  {"6.10", 260682, 10119},
  {"6.11", 260774, 10122},
  {"6.12", 260873, 10125},
  {"6.13", 260971, 10128},
  {"6.14", 261070, 10131},
  {"6.15", 261169, 10134},
  {"6.16", 261262, 10137},
  {"6.17", 261361, 10140},
  {"6.18", 261453, 10143},
  {"6.19", 261552, 10146},
  {"6.20", 261651, 10149},
  {"6.21", 261750, 10152},
  {"6.22", 261849, 10155},
  {"S3.7.7", 261944, 10158},
  {"7.1", 265139, 10243},
  {"7.2", 265234, 10246},
  {"7.3", 265325, 10249},
  {"7.4", 265422, 10252},
  {"7.5", 265514, 10255},
  {"7.6", 265605, 10258},
  {"7.7", 265702, 10261},
  {"7.8", 265800, 10264},
  {"7.9", 265897, 10267},
  {"7.10", 265989, 10270},
  {"7.11", 266088, 10273},
  {"7.12", 266187, 10276},
  {"7.13", 266286, 10279},
  {"7.14", 266385, 10282},
  {"7.15", 266483, 10285},
  {"7.16", 266582, 10288},
  {"S3.7.8", 266683, 10291},
  {"8.1", 273678, 10476},
  {"8.2", 273773, 10479},
  {"8.3", 273863, 10482},
  {"8.4", 273953, 10485},
  {"8.5", 274044, 10488},
  {"8.6", 274135, 10491},
  {"8.7", 274232, 10494},
  {"8.8", 274328, 10497},
  {"8.9", 274425, 10500},
  {"8.10", 274523, 10503},
  {"8.11", 274623, 10506},
  {"8.12", 274722, 10509},
  {"8.13", 274816, 10512},
  {"8.14", 274910, 10515},
  {"8.15", 275009, 10518},
  {"8.16", 275107, 10521},
  {"8.17", 275207, 10524},
  {"8.18", 275306, 10527},
  {"8.19", 275405, 10530},
  {"8.20", 275504, 10533},
  {"8.21", 275597, 10536},
  {"8.22", 275696, 10539},
  {"8.23", 275795, 10542},
  {"8.24", 275894, 10545},
  {"8.25", 275987, 10548},
  {"8.26", 276080, 10551},
  {"8.27", 276180, 10554},
  {"8.28", 276279, 10557},
  {"8.29", 276378, 10560},
  {"8.30", 276477, 10563},
  {"8.31", 276576, 10566},
  {"8.32", 276669, 10569},
  {"8.33", 276763, 10572},
  {"8.34", 276863, 10575},
  {"8.35", 276962, 10578},
  {"8.36", 277062, 10581},
  {"S3.7.9", 277164, 10584},
  {"9.1", 281652, 10701},
  {"9.2", 281748, 10704},
  {"9.3", 281841, 10707},
  {"9.4", 281933, 10710},
  {"9.5", 282026, 10713},
  {"9.6", 282124, 10716},
  {"9.7", 282215, 10719},
  {"9.8", 282313, 10722},
  {"9.9", 282411, 10725},
  {"9.10", 282510, 10728},
  {"9.11", 282610, 10731},
  {"9.12", 282710, 10734},
  {"9.13", 282810, 10737},
  {"9.14", 282905, 10740},
  {"9.15", 283005, 10743},
  {"9.16", 283105, 10746},
  {"9.17", 283205, 10749},
  {"9.18", 283299, 10752},
  {"9.19", 283399, 10755},
  {"9.20", 283499, 10758},
  {"9.21", 283599, 10761},
  {"9.22", 283694, 10764},
  {"9.23", 283788, 10767},
  {"9.24", 283882, 10770},
  {"S3.7.10", 283985, 10773},
  {"10.1", 285612, 10814},
  {"10.2", 285711, 10817},
  {"10.3", 285807, 10820},
  {"10.4", 285902, 10823},
  {"10.5", 285997, 10826},
  {"10.6", 286093, 10829},
  {"10.7", 286188, 10832},
  {"10.8", 286282, 10835},
  {"10.9", 286378, 10838},
  {"10.10", 286474, 10841},
  {"10.11", 286572, 10844},
  {"10.12", 286669, 10847},
  {"S3.7.11", 286769, 10850},
  {"11.1", 295904, 11083},
  {"11.2", 296003, 11086},
  {"11.3", 296098, 11089},
  {"11.4", 296193, 11092},
  {"11.5", 296287, 11095},
  {"11.6", 296382, 11098},
  {"11.7", 296483, 11101},
  {"11.8", 296584, 11104},
  {"11.9", 296685, 11107},
  {"11.10", 296787, 11110},
  {"11.11", 296890, 11113},
  {"11.12", 296993, 11116},
  {"11.13", 297089, 11119},
  {"11.14", 297186, 11122},
  {"11.15", 297284, 11125},
  {"11.16", 297382, 11128},
  {"11.17", 297485, 11131},
  {"11.18", 297589, 11134},
  {"11.19", 297693, 11137},
  {"11.20", 297796, 11140},
  {"11.21", 297899, 11143},
  {"11.22", 298002, 11146},
  {"11.23", 298098, 11149},
  {"11.24", 298201, 11152},
  {"11.25", 298303, 11155},
  {"11.26", 298399, 11158},
  {"11.27", 298502, 11161},
  {"11.28", 298605, 11164},
  {"11.29", 298708, 11167},
  {"11.30", 298804, 11170},
  {"11.31", 298901, 11173},
  {"11.32", 299004, 11176},
  {"11.33", 299107, 11179},
  {"11.34", 299211, 11182},
  {"11.35", 299313, 11185},
  {"11.36", 299411, 11188},
  {"11.37", 299510, 11191},
  {"11.38", 299606, 11194},
  {"11.39", 299703, 11197},
  {"11.40", 299801, 11200},
  {"11.41", 299898, 11203},
  {"11.42", 300001, 11206},
  {"11.43", 300104, 11209},
  {"11.44", 300207, 11212},
  {"11.45", 300310, 11215},
  {"11.46", 300413, 11218},
  {"11.47", 300515, 11221},
  {"11.48", 300612, 11224},
  {"11.49", 300709, 11227},
  {"11.50", 300812, 11230},
  {"S3.7.12", 300917, 11233},
  {"12.1", 305936, 11362},
  {"12.2", 306035, 11365},
  {"12.3", 306130, 11368},
  {"12.4", 306224, 11371},
  {"12.5", 306325, 11374},
  {"12.6", 306426, 11377},
  {"12.7", 306527, 11380},
  {"12.8", 306628, 11383},
  {"12.9", 306729, 11386},
  {"12.10", 306824, 11389},
  {"12.11", 306927, 11392},
  {"12.12", 307030, 11395},
  {"12.13", 307133, 11398},
  {"12.14", 307236, 11401},
  {"12.15", 307339, 11404},
  {"12.16", 307442, 11407},
  {"12.17", 307545, 11410},
  {"12.18", 307648, 11413},
  {"12.19", 307750, 11416},
  {"12.20", 307853, 11419},
  {"12.21", 307956, 11422},
  {"12.22", 308058, 11425}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 117, 4, 65, "Section",
  CellTags->{"S3.7.0", "0.1"}],

Cell[CellGroupData[{
Cell[1918, 61, 80, 1, 70, "Subsection",
  CellTags->{"S3.7.1", "1.1"}],
Cell[2001, 64, 7011, 202, 70, "DefinitionBox",
  CellTags->"S3.7.1"],
Cell[9015, 268, 78, 1, 70, "Caption",
  CellTags->"S3.7.1"],
Cell[9096, 271, 582, 23, 70, "MathCaption",
  CellTags->{"S3.7.1", "1.2"}],

Cell[CellGroupData[{
Cell[9703, 298, 94, 2, 70, "Input",
  CellTags->"S3.7.1"],
Cell[9800, 302, 121, 3, 70, "Output",
  CellTags->"S3.7.1"]
}, Open  ]],
Cell[9936, 308, 102, 1, 70, "MathCaption",
  CellTags->{"S3.7.1", "1.3"}],

Cell[CellGroupData[{
Cell[10063, 313, 80, 2, 70, "Input",
  CellTags->"S3.7.1"],
Cell[10146, 317, 121, 3, 70, "Output",
  CellTags->"S3.7.1"]
}, Open  ]],
Cell[10282, 323, 176, 4, 70, "MathCaption",
  CellTags->{"S3.7.1", "1.4"}],

Cell[CellGroupData[{
Cell[10483, 331, 89, 2, 70, "Input",
  CellTags->"S3.7.1"],
Cell[10575, 335, 114, 3, 70, "Output",
  CellTags->"S3.7.1"]
}, Open  ]],
Cell[10704, 341, 376, 14, 70, "MathCaption",
  CellTags->{"S3.7.1", "1.5"}],

Cell[CellGroupData[{
Cell[11105, 359, 81, 2, 70, "Input",
  CellTags->"S3.7.1"],
Cell[11189, 363, 114, 3, 70, "Output",
  CellTags->"S3.7.1"]
}, Open  ]],
Cell[11318, 369, 215, 6, 70, "MathCaption",
  CellTags->{"S3.7.1", "1.6"}],

Cell[CellGroupData[{
Cell[11558, 379, 115, 2, 70, "Input",
  CellTags->"S3.7.1"],
Cell[11676, 383, 123, 3, 70, "Output",
  CellTags->"S3.7.1"]
}, Open  ]],
Cell[11814, 389, 156, 4, 70, "MathCaption",
  CellTags->{"S3.7.1", "1.7"}],

Cell[CellGroupData[{
Cell[11995, 397, 77, 2, 70, "Input",
  CellTags->"S3.7.1"],
Cell[12075, 401, 431, 13, 70, "Output",
  CellTags->"S3.7.1"]
}, Open  ]],
Cell[12521, 417, 1915, 60, 70, "DefinitionBox",
  CellTags->"S3.7.1"],
Cell[14439, 479, 136, 5, 70, "Caption",
  CellTags->"S3.7.1"],
Cell[14578, 486, 259, 9, 70, "MathCaption",
  CellTags->{"S3.7.1", "1.8"}],

Cell[CellGroupData[{
Cell[14862, 499, 90, 2, 70, "Input",
  CellTags->"S3.7.1"],
Cell[14955, 503, 179, 4, 70, "Output",
  CellTags->"S3.7.1"]
}, Open  ]],
Cell[15149, 510, 2688, 79, 70, "DefinitionBox",
  CellTags->"S3.7.1"],
Cell[17840, 591, 142, 5, 70, "Caption",
  CellTags->"S3.7.1"],
Cell[17985, 598, 120, 4, 70, "MathCaption",
  CellTags->{"S3.7.1", "1.9"}],

Cell[CellGroupData[{
Cell[18130, 606, 124, 2, 70, "Input",
  CellTags->"S3.7.1"],
Cell[18257, 610, 716, 22, 70, "Output",
  CellTags->"S3.7.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[19022, 638, 97, 1, 70, "Subsection",
  CellTags->{"S3.7.2", "2.1"}],
Cell[19122, 641, 7038, 203, 70, "DefinitionBox",
  CellTags->"S3.7.2"],
Cell[26163, 846, 73, 1, 70, "Caption",
  CellTags->"S3.7.2"],
Cell[26239, 849, 269, 7, 70, "Text",
  CellTags->{"S3.7.2", "2.2"}],
Cell[26511, 858, 176, 6, 70, "MathCaption",
  CellTags->{"S3.7.2", "2.3"}],

Cell[CellGroupData[{
Cell[26712, 868, 84, 2, 70, "Input",
  CellTags->"S3.7.2"],
Cell[26799, 872, 177, 4, 70, "Output",
  CellTags->"S3.7.2"]
}, Open  ]],
Cell[26991, 879, 99, 1, 70, "MathCaption",
  CellTags->{"S3.7.2", "2.4"}],

Cell[CellGroupData[{
Cell[27115, 884, 70, 2, 70, "Input",
  CellTags->"S3.7.2"],
Cell[27188, 888, 108, 3, 70, "Output",
  CellTags->"S3.7.2"]
}, Open  ]],
Cell[27311, 894, 95, 1, 70, "MathCaption",
  CellTags->{"S3.7.2", "2.5"}],

Cell[CellGroupData[{
Cell[27431, 899, 75, 2, 70, "Input",
  CellTags->"S3.7.2"],
Cell[27509, 903, 108, 3, 70, "Output",
  CellTags->"S3.7.2"]
}, Open  ]],
Cell[27632, 909, 82, 1, 70, "MathCaption",
  CellTags->{"S3.7.2", "2.6"}],

Cell[CellGroupData[{
Cell[27739, 914, 87, 2, 70, "Input",
  CellTags->"S3.7.2"],
Cell[27829, 918, 121, 3, 70, "Output",
  CellTags->"S3.7.2"]
}, Open  ]],
Cell[27965, 924, 6574, 202, 70, "DefinitionBox",
  CellTags->"S3.7.2"],
Cell[34542, 1128, 70, 1, 70, "Caption",
  CellTags->"S3.7.2"],
Cell[34615, 1131, 169, 6, 70, "MathCaption",
  CellTags->{"S3.7.2", "2.7"}],

Cell[CellGroupData[{
Cell[34809, 1141, 84, 2, 70, "Input",
  CellTags->"S3.7.2"],
Cell[34896, 1145, 97, 3, 70, "Output",
  CellTags->"S3.7.2"]
}, Open  ]],
Cell[35008, 1151, 165, 5, 70, "MathCaption",
  CellTags->{"S3.7.2", "2.8"}],

Cell[CellGroupData[{
Cell[35198, 1160, 80, 2, 70, "Input",
  CellTags->"S3.7.2"],
Cell[35281, 1164, 97, 3, 70, "Output",
  CellTags->"S3.7.2"]
}, Open  ]],
Cell[35393, 1170, 153, 5, 70, "MathCaption",
  CellTags->{"S3.7.2", "2.9"}],

Cell[CellGroupData[{
Cell[35571, 1179, 82, 2, 70, "Input",
  CellTags->"S3.7.2"],
Cell[35656, 1183, 97, 3, 70, "Output",
  CellTags->"S3.7.2"]
}, Open  ]],
Cell[35768, 1189, 127, 4, 70, "MathCaption",
  CellTags->{"S3.7.2", "2.10"}],

Cell[CellGroupData[{
Cell[35920, 1197, 87, 2, 70, "Input",
  CellTags->"S3.7.2"],
Cell[36010, 1201, 97, 3, 70, "Output",
  CellTags->"S3.7.2"]
}, Open  ]],
Cell[36122, 1207, 108, 1, 70, "MathCaption",
  CellTags->{"S3.7.2", "2.11"}],

Cell[CellGroupData[{
Cell[36255, 1212, 80, 2, 70, "Input",
  CellTags->"S3.7.2"],
Cell[36338, 1216, 105, 3, 70, "Output",
  CellTags->"S3.7.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36492, 1225, 88, 1, 70, "Subsection",
  CellTags->{"S3.7.3", "3.1"}],
Cell[36583, 1228, 235, 7, 70, "Text",
  CellTags->{"S3.7.3", "3.2"}],
Cell[36821, 1237, 366, 8, 70, "Text",
  CellTags->{"S3.7.3", "3.3"}],
Cell[37190, 1247, 1338, 40, 70, "DefinitionBox",
  CellTags->"S3.7.3"],
Cell[38531, 1289, 112, 4, 70, "Caption",
  CellTags->"S3.7.3"],
Cell[38646, 1295, 199, 9, 70, "MathCaption",
  CellTags->{"S3.7.3", "3.4"}],

Cell[CellGroupData[{
Cell[38870, 1308, 84, 2, 70, "Input",
  CellTags->"S3.7.3"],
Cell[38957, 1312, 85, 3, 70, "Output",
  CellTags->"S3.7.3"]
}, Open  ]],
Cell[39057, 1318, 224, 8, 70, "MathCaption",
  CellTags->{"S3.7.3", "3.5"}],

Cell[CellGroupData[{
Cell[39306, 1330, 80, 2, 70, "Input",
  CellTags->"S3.7.3"],
Cell[39389, 1334, 86, 3, 70, "Output",
  CellTags->"S3.7.3"]
}, Open  ]],
Cell[39490, 1340, 169, 6, 70, "MathCaption",
  CellTags->{"S3.7.3", "3.6"}],

Cell[CellGroupData[{
Cell[39684, 1350, 103, 2, 70, "Input",
  CellTags->"S3.7.3"],
Cell[39790, 1354, 87, 3, 70, "Output",
  CellTags->"S3.7.3"]
}, Open  ]],
Cell[39892, 1360, 219, 7, 70, "MathCaption",
  CellTags->{"S3.7.3", "3.7"}],

Cell[CellGroupData[{
Cell[40136, 1371, 87, 2, 70, "Input",
  CellTags->"S3.7.3"],
Cell[40226, 1375, 84, 3, 70, "Output",
  CellTags->"S3.7.3"]
}, Open  ]],
Cell[40325, 1381, 146, 4, 70, "MathCaption",
  CellTags->{"S3.7.3", "3.8"}],

Cell[CellGroupData[{
Cell[40496, 1389, 96, 2, 70, "Input",
  CellTags->"S3.7.3"],
Cell[40595, 1393, 86, 3, 70, "Output",
  CellTags->"S3.7.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40730, 1402, 102, 1, 70, "Subsection",
  CellTags->{"S3.7.4", "4.1"}],
Cell[40835, 1405, 312, 8, 70, "Text",
  CellTags->{"S3.7.4", "4.2"}],
Cell[41150, 1415, 163, 4, 70, "Text",
  CellTags->{"S3.7.4", "4.3"}],
Cell[41316, 1421, 163, 5, 70, "MathCaption",
  CellTags->{"S3.7.4", "4.4"}],

Cell[CellGroupData[{
Cell[41504, 1430, 80, 2, 70, "Input",
  CellTags->"S3.7.4"],
Cell[41587, 1434, 105, 3, 70, "Output",
  CellTags->"S3.7.4"]
}, Open  ]],
Cell[41707, 1440, 137, 4, 70, "MathCaption",
  CellTags->{"S3.7.4", "4.5"}],

Cell[CellGroupData[{
Cell[41869, 1448, 87, 2, 70, "Input",
  CellTags->"S3.7.4"],
Cell[41959, 1452, 117, 3, 70, "Output",
  CellTags->"S3.7.4"]
}, Open  ]],
Cell[42091, 1458, 180, 5, 70, "MathCaption",
  CellTags->{"S3.7.4", "4.6"}],

Cell[CellGroupData[{
Cell[42296, 1467, 85, 2, 70, "Input",
  CellTags->"S3.7.4"],
Cell[42384, 1471, 99, 3, 70, "Output",
  CellTags->"S3.7.4"]
}, Open  ]],
Cell[42498, 1477, 114, 2, 70, "MathCaption",
  CellTags->{"S3.7.4", "4.7"}],

Cell[CellGroupData[{
Cell[42637, 1483, 81, 2, 70, "Input",
  CellTags->"S3.7.4"],
Cell[42721, 1487, 97, 3, 70, "Output",
  CellTags->"S3.7.4"]
}, Open  ]],
Cell[42833, 1493, 136, 4, 70, "MathCaption",
  CellTags->{"S3.7.4", "4.8"}],

Cell[CellGroupData[{
Cell[42994, 1501, 84, 2, 70, "Input",
  CellTags->"S3.7.4"],
Cell[43081, 1505, 191, 4, 70, "Message",
  CellTags->"S3.7.4"],
Cell[43275, 1511, 101, 3, 70, "Output",
  CellTags->"S3.7.4"]
}, Open  ]],
Cell[43391, 1517, 152, 5, 70, "MathCaption",
  CellTags->{"S3.7.4", "4.9"}],

Cell[CellGroupData[{
Cell[43568, 1526, 74, 2, 70, "Input",
  CellTags->"S3.7.4"],
Cell[43645, 1530, 95, 3, 70, "Output",
  CellTags->"S3.7.4"]
}, Open  ]],
Cell[43755, 1536, 249, 6, 70, "MathCaption",
  CellTags->{"S3.7.4", "4.10"}],

Cell[CellGroupData[{
Cell[44029, 1546, 74, 2, 70, "Input",
  CellTags->"S3.7.4"],
Cell[44106, 1550, 95, 3, 70, "Output",
  CellTags->"S3.7.4"]
}, Open  ]],
Cell[44216, 1556, 160, 5, 70, "MathCaption",
  CellTags->{"S3.7.4", "4.11"}],

Cell[CellGroupData[{
Cell[44401, 1565, 72, 2, 70, "Input",
  CellTags->"S3.7.4"],
Cell[44476, 1569, 93, 3, 70, "Output",
  CellTags->"S3.7.4"]
}, Open  ]],
Cell[44584, 1575, 548, 11, 70, "Text",
  CellTags->{"S3.7.4", "4.12"}],
Cell[45135, 1588, 190, 6, 70, "MathCaption",
  CellTags->{"S3.7.4", "4.13"}],

Cell[CellGroupData[{
Cell[45350, 1598, 74, 2, 70, "Input",
  CellTags->"S3.7.4"],
Cell[45427, 1602, 95, 3, 70, "Output",
  CellTags->"S3.7.4"]
}, Open  ]],
Cell[45537, 1608, 217, 9, 70, "MathCaption",
  CellTags->{"S3.7.4", "4.14"}],

Cell[CellGroupData[{
Cell[45779, 1621, 81, 2, 70, "Input",
  CellTags->"S3.7.4"],
Cell[45863, 1625, 114, 3, 70, "Output",
  CellTags->"S3.7.4"]
}, Open  ]],
Cell[45992, 1631, 261, 9, 70, "MathCaption",
  CellTags->{"S3.7.4", "4.15"}],

Cell[CellGroupData[{
Cell[46278, 1644, 80, 2, 70, "Input",
  CellTags->"S3.7.4"],
Cell[46361, 1648, 96, 3, 70, "Output",
  CellTags->"S3.7.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[46506, 1657, 91, 1, 70, "Subsection",
  CellTags->{"S3.7.5", "5.1"}],
Cell[46600, 1660, 1996, 62, 70, "DefinitionBox",
  CellTags->"S3.7.5"],
Cell[48599, 1724, 94, 1, 70, "Caption",
  CellTags->"S3.7.5"],
Cell[48696, 1727, 158, 5, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.2"}],

Cell[CellGroupData[{
Cell[48879, 1736, 75, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[48957, 1740, 99, 3, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[49071, 1746, 169, 4, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.3"}],

Cell[CellGroupData[{
Cell[49265, 1754, 88, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[49356, 1758, 102, 3, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[49473, 1764, 109, 1, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.4"}],

Cell[CellGroupData[{
Cell[49607, 1769, 89, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[49699, 1773, 107, 3, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[49821, 1779, 165, 5, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.5"}],

Cell[CellGroupData[{
Cell[50011, 1788, 99, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[50113, 1792, 131, 3, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[50259, 1798, 703, 18, 70, "Text",
  CellTags->{"S3.7.5", "5.6"}],
Cell[50965, 1818, 178, 7, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.7"}],

Cell[CellGroupData[{
Cell[51168, 1829, 97, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[51268, 1833, 87, 3, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[51370, 1839, 271, 9, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.8"}],

Cell[CellGroupData[{
Cell[51666, 1852, 69, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[51738, 1856, 107, 3, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[51860, 1862, 255, 9, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.9"}],

Cell[CellGroupData[{
Cell[52140, 1875, 69, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[52212, 1879, 107, 3, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[52334, 1885, 183, 7, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.10"}],

Cell[CellGroupData[{
Cell[52542, 1896, 73, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[52618, 1900, 124, 3, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[52757, 1906, 253, 5, 70, "Text",
  CellTags->{"S3.7.5", "5.11"}],
Cell[53013, 1913, 144, 4, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.12"}],

Cell[CellGroupData[{
Cell[53182, 1921, 73, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[53258, 1925, 90, 3, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[53363, 1931, 89, 1, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.13"}],

Cell[CellGroupData[{
Cell[53477, 1936, 82, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[53562, 1940, 95, 3, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[53672, 1946, 114, 2, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.14"}],

Cell[CellGroupData[{
Cell[53811, 1952, 86, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[53900, 1956, 111, 3, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[54026, 1962, 321, 9, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.15"}],

Cell[CellGroupData[{
Cell[54372, 1975, 80, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[54455, 1979, 127, 3, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[54597, 1985, 430, 9, 70, "Text",
  CellTags->{"S3.7.5", "5.16"}],
Cell[55030, 1996, 101, 1, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.17"}],

Cell[CellGroupData[{
Cell[55156, 2001, 93, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[55252, 2005, 110, 3, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[55377, 2011, 133, 4, 70, "MathCaption",
  CellTags->{"S3.7.5", "5.18"}],

Cell[CellGroupData[{
Cell[55535, 2019, 106, 2, 70, "Input",
  CellTags->"S3.7.5"],
Cell[55644, 2023, 168, 4, 70, "Output",
  CellTags->"S3.7.5"]
}, Open  ]],
Cell[55827, 2030, 223, 7, 70, "Text",
  CellTags->{"S3.7.5", "5.19"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[56087, 2042, 75, 1, 70, "Subsection",
  CellTags->{"S3.7.6", "6.1"}],
Cell[56165, 2045, 425, 12, 70, "DefinitionBox",
  CellTags->"S3.7.6"],
Cell[56593, 2059, 59, 1, 70, "Caption",
  CellTags->"S3.7.6"],
Cell[56655, 2062, 176, 6, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.2"}],

Cell[CellGroupData[{
Cell[56856, 2072, 84, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[56943, 2076, 97, 3, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[57055, 2082, 406, 17, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.3"}],

Cell[CellGroupData[{
Cell[57486, 2103, 76, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[57565, 2107, 229, 5, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[57809, 2115, 144, 4, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.4"}],

Cell[CellGroupData[{
Cell[57978, 2123, 69, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[58050, 2127, 286, 6, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[58351, 2136, 191, 5, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.5"}],

Cell[CellGroupData[{
Cell[58567, 2145, 77, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[58647, 2149, 97, 3, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[58759, 2155, 92, 1, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.6"}],

Cell[CellGroupData[{
Cell[58876, 2160, 101, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[58980, 2164, 194, 4, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[59189, 2171, 143, 4, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.7"}],

Cell[CellGroupData[{
Cell[59357, 2179, 75, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[59435, 2183, 247, 5, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[59697, 2191, 126, 4, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.8"}],

Cell[CellGroupData[{
Cell[59848, 2199, 70, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[59921, 2203, 137, 3, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[60073, 2209, 209, 5, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.9"}],

Cell[CellGroupData[{
Cell[60307, 2218, 91, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[60401, 2222, 158, 4, 70, "Message",
  CellTags->"S3.7.6"],
Cell[60562, 2228, 106, 3, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[60683, 2234, 366, 8, 70, "Text",
  CellTags->{"S3.7.6", "6.10"}],
Cell[61052, 2244, 109, 1, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.11"}],

Cell[CellGroupData[{
Cell[61186, 2249, 92, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[61281, 2253, 109, 3, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[61405, 2259, 89, 1, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.12"}],

Cell[CellGroupData[{
Cell[61519, 2264, 77, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[61599, 2268, 193, 5, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[61807, 2276, 158, 4, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.13"}],

Cell[CellGroupData[{
Cell[61990, 2284, 70, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[62063, 2288, 106, 3, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[62184, 2294, 167, 5, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.14"}],

Cell[CellGroupData[{
Cell[62376, 2303, 74, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[62453, 2307, 102, 3, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[62570, 2313, 625, 13, 70, "Text",
  CellTags->{"S3.7.6", "6.15"}],
Cell[63198, 2328, 187, 5, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.16"}],

Cell[CellGroupData[{
Cell[63410, 2337, 96, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[63509, 2341, 166, 4, 70, "Message",
  CellTags->"S3.7.6"],
Cell[63678, 2347, 115, 3, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[63808, 2353, 237, 5, 70, "Text",
  CellTags->{"S3.7.6", "6.17"}],
Cell[64048, 2360, 230, 6, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.18"}],
Cell[64281, 2368, 119, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[64403, 2372, 157, 4, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.19"}],

Cell[CellGroupData[{
Cell[64585, 2380, 87, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[64675, 2384, 231, 5, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[64921, 2392, 294, 7, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.20"}],
Cell[65218, 2401, 114, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[65335, 2405, 133, 4, 70, "MathCaption",
  CellTags->{"S3.7.6", "6.21"}],

Cell[CellGroupData[{
Cell[65493, 2413, 87, 2, 70, "Input",
  CellTags->"S3.7.6"],
Cell[65583, 2417, 262, 5, 70, "Output",
  CellTags->"S3.7.6"]
}, Open  ]],
Cell[65860, 2425, 355, 10, 70, "Text",
  CellTags->{"S3.7.6", "6.22"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[66252, 2440, 82, 1, 70, "Subsection",
  CellTags->{"S3.7.7", "7.1"}],
Cell[66337, 2443, 2896, 86, 70, "DefinitionBox",
  CellTags->"S3.7.7"],
Cell[69236, 2531, 71, 1, 70, "Caption",
  CellTags->"S3.7.7"],
Cell[69310, 2534, 582, 20, 70, "Text",
  CellTags->{"S3.7.7", "7.2"}],
Cell[69895, 2556, 269, 9, 70, "MathCaption",
  CellTags->{"S3.7.7", "7.3"}],

Cell[CellGroupData[{
Cell[70189, 2569, 102, 2, 70, "Input",
  CellTags->"S3.7.7"],
Cell[70294, 2573, 108, 3, 70, "Output",
  CellTags->"S3.7.7"]
}, Open  ]],
Cell[70417, 2579, 2410, 85, 70, "Text",
  CellTags->{"S3.7.7", "7.4"}],
Cell[72830, 2666, 853, 31, 70, "Text",
  CellTags->{"S3.7.7", "7.5"}],
Cell[73686, 2699, 195, 6, 70, "MathCaption",
  CellTags->{"S3.7.7", "7.6"}],

Cell[CellGroupData[{
Cell[73906, 2709, 87, 2, 70, "Input",
  CellTags->"S3.7.7"],
Cell[73996, 2713, 97, 3, 70, "Output",
  CellTags->"S3.7.7"]
}, Open  ]],
Cell[74108, 2719, 583, 23, 70, "MathCaption",
  CellTags->{"S3.7.7", "7.7"}],

Cell[CellGroupData[{
Cell[74716, 2746, 84, 2, 70, "Input",
  CellTags->"S3.7.7"],
Cell[74803, 2750, 177, 4, 70, "Output",
  CellTags->"S3.7.7"]
}, Open  ]],
Cell[74995, 2757, 128, 5, 70, "MathCaption",
  CellTags->{"S3.7.7", "7.8"}],

Cell[CellGroupData[{
Cell[75148, 2766, 72, 2, 70, "Input",
  CellTags->"S3.7.7"],
Cell[75223, 2770, 265, 5, 70, "Output",
  CellTags->"S3.7.7"]
}, Open  ]],
Cell[75503, 2778, 278, 11, 70, "Text",
  CellTags->{"S3.7.7", "7.9"}],
Cell[75784, 2791, 193, 6, 70, "MathCaption",
  CellTags->{"S3.7.7", "7.10"}],

Cell[CellGroupData[{
Cell[76002, 2801, 84, 2, 70, "Input",
  CellTags->"S3.7.7"],
Cell[76089, 2805, 86, 3, 70, "Output",
  CellTags->"S3.7.7"]
}, Open  ]],
Cell[76190, 2811, 876, 26, 70, "DefinitionBox",
  CellTags->"S3.7.7"],
Cell[77069, 2839, 78, 1, 70, "Caption",
  CellTags->"S3.7.7"],
Cell[77150, 2842, 170, 6, 70, "MathCaption",
  CellTags->{"S3.7.7", "7.11"}],

Cell[CellGroupData[{
Cell[77345, 2852, 96, 2, 70, "Input",
  CellTags->"S3.7.7"],
Cell[77444, 2856, 113, 3, 70, "Output",
  CellTags->"S3.7.7"]
}, Open  ]],
Cell[77572, 2862, 139, 5, 70, "MathCaption",
  CellTags->{"S3.7.7", "7.12"}],

Cell[CellGroupData[{
Cell[77736, 2871, 81, 2, 70, "Input",
  CellTags->"S3.7.7"],
Cell[77820, 2875, 162, 4, 70, "Output",
  CellTags->"S3.7.7"]
}, Open  ]],
Cell[77997, 2882, 117, 2, 70, "MathCaption",
  CellTags->{"S3.7.7", "7.13"}],

Cell[CellGroupData[{
Cell[78139, 2888, 73, 2, 70, "Input",
  CellTags->"S3.7.7"],
Cell[78215, 2892, 170, 4, 70, "Output",
  CellTags->"S3.7.7"]
}, Open  ]],
Cell[78400, 2899, 91, 1, 70, "MathCaption",
  CellTags->{"S3.7.7", "7.14"}],

Cell[CellGroupData[{
Cell[78516, 2904, 84, 2, 70, "Input",
  CellTags->"S3.7.7"],
Cell[78603, 2908, 176, 4, 70, "Output",
  CellTags->"S3.7.7"]
}, Open  ]],
Cell[78794, 2915, 139, 5, 70, "MathCaption",
  CellTags->{"S3.7.7", "7.15"}],

Cell[CellGroupData[{
Cell[78958, 2924, 77, 2, 70, "Input",
  CellTags->"S3.7.7"],
Cell[79038, 2928, 178, 4, 70, "Output",
  CellTags->"S3.7.7"]
}, Open  ]],
Cell[79231, 2935, 188, 5, 70, "MathCaption",
  CellTags->{"S3.7.7", "7.16"}],

Cell[CellGroupData[{
Cell[79444, 2944, 101, 2, 70, "Input",
  CellTags->"S3.7.7"],
Cell[79548, 2948, 178, 4, 70, "Output",
  CellTags->"S3.7.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[79775, 2958, 81, 1, 70, "Subsection",
  CellTags->{"S3.7.8", "8.1"}],
Cell[79859, 2961, 274, 7, 70, "Text",
  CellTags->{"S3.7.8", "8.2"}],
Cell[80136, 2970, 393, 7, 70, "Text",
  CellTags->{"S3.7.8", "8.3"}],
Cell[80532, 2979, 508, 18, 70, "Text",
  CellTags->{"S3.7.8", "8.4"}],
Cell[81043, 2999, 790, 21, 70, "Text",
  CellTags->{"S3.7.8", "8.5"}],
Cell[81836, 3022, 2080, 65, 70, "DefinitionBox",
  CellTags->"S3.7.8"],
Cell[83919, 3089, 79, 1, 70, "Caption",
  CellTags->"S3.7.8"],
Cell[84001, 3092, 169, 6, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.6"}],

Cell[CellGroupData[{
Cell[84195, 3102, 84, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[84282, 3106, 97, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[84394, 3112, 87, 1, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.7"}],

Cell[CellGroupData[{
Cell[84506, 3117, 84, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[84593, 3121, 117, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[84725, 3127, 151, 5, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.8"}],

Cell[CellGroupData[{
Cell[84901, 3136, 82, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[84986, 3140, 161, 4, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[85162, 3147, 247, 7, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.9"}],

Cell[CellGroupData[{
Cell[85434, 3158, 86, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[85523, 3162, 130, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[85668, 3168, 333, 11, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.10"}],

Cell[CellGroupData[{
Cell[86026, 3183, 83, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[86112, 3187, 130, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[86257, 3193, 193, 5, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.11"}],

Cell[CellGroupData[{
Cell[86475, 3202, 97, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[86575, 3206, 155, 4, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[86745, 3213, 1581, 55, 70, "Text",
  CellTags->{"S3.7.8", "8.12"}],
Cell[88329, 3270, 1227, 43, 70, "Text",
  CellTags->{"S3.7.8", "8.13"}],
Cell[89559, 3315, 139, 4, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.14"}],

Cell[CellGroupData[{
Cell[89723, 3323, 84, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[89810, 3327, 97, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[89922, 3333, 88, 1, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.15"}],

Cell[CellGroupData[{
Cell[90035, 3338, 72, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[90110, 3342, 82, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[90207, 3348, 393, 14, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.16"}],

Cell[CellGroupData[{
Cell[90625, 3366, 86, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[90714, 3370, 153, 3, 70, "Message",
  CellTags->"S3.7.8"],
Cell[90870, 3375, 118, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[91003, 3381, 155, 5, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.17"}],

Cell[CellGroupData[{
Cell[91183, 3390, 79, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[91265, 3394, 95, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[91375, 3400, 175, 5, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.18"}],

Cell[CellGroupData[{
Cell[91575, 3409, 75, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[91653, 3413, 88, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[91756, 3419, 174, 7, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.19"}],

Cell[CellGroupData[{
Cell[91955, 3430, 80, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[92038, 3434, 83, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[92136, 3440, 590, 14, 70, "Text",
  CellTags->{"S3.7.8", "8.20"}],
Cell[92729, 3456, 111, 1, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.21"}],

Cell[CellGroupData[{
Cell[92865, 3461, 114, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[92982, 3465, 133, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[93130, 3471, 155, 5, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.22"}],

Cell[CellGroupData[{
Cell[93310, 3480, 77, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[93390, 3484, 128, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[93533, 3490, 168, 5, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.23"}],

Cell[CellGroupData[{
Cell[93726, 3499, 100, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[93829, 3503, 91, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[93935, 3509, 307, 11, 70, "Text",
  CellTags->{"S3.7.8", "8.24"}],
Cell[94245, 3522, 638, 20, 70, "Text",
  CellTags->{"S3.7.8", "8.25"}],
Cell[94886, 3544, 1239, 38, 70, "DefinitionBox",
  CellTags->"S3.7.8"],
Cell[96128, 3584, 114, 4, 70, "Caption",
  CellTags->"S3.7.8"],
Cell[96245, 3590, 434, 15, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.26"}],

Cell[CellGroupData[{
Cell[96704, 3609, 96, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[96803, 3613, 153, 3, 70, "Message",
  CellTags->"S3.7.8"],
Cell[96959, 3618, 113, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[97087, 3624, 116, 2, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.27"}],

Cell[CellGroupData[{
Cell[97228, 3630, 91, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[97322, 3634, 104, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[97441, 3640, 185, 5, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.28"}],

Cell[CellGroupData[{
Cell[97651, 3649, 91, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[97745, 3653, 97, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[97857, 3659, 241, 5, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.29"}],

Cell[CellGroupData[{
Cell[98123, 3668, 77, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[98203, 3672, 103, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[98321, 3678, 250, 6, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.30"}],

Cell[CellGroupData[{
Cell[98596, 3688, 83, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[98682, 3692, 88, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[98785, 3698, 489, 16, 70, "Text",
  CellTags->{"S3.7.8", "8.31"}],
Cell[99277, 3716, 758, 24, 70, "DefinitionBox",
  CellTags->"S3.7.8"],
Cell[100038, 3742, 125, 5, 70, "Caption",
  CellTags->"S3.7.8"],
Cell[100166, 3749, 920, 31, 70, "Text",
  CellTags->{"S3.7.8", "8.32"}],
Cell[101089, 3782, 135, 5, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.33"}],

Cell[CellGroupData[{
Cell[101249, 3791, 98, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[101350, 3795, 159, 5, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[101524, 3803, 87, 1, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.34"}],

Cell[CellGroupData[{
Cell[101636, 3808, 74, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[101713, 3812, 95, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[101823, 3818, 184, 5, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.35"}],

Cell[CellGroupData[{
Cell[102032, 3827, 102, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[102137, 3831, 95, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]],
Cell[102247, 3837, 143, 5, 70, "MathCaption",
  CellTags->{"S3.7.8", "8.36"}],

Cell[CellGroupData[{
Cell[102415, 3846, 75, 2, 70, "Input",
  CellTags->"S3.7.8"],
Cell[102493, 3850, 105, 3, 70, "Output",
  CellTags->"S3.7.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[102647, 3859, 87, 1, 70, "Subsection",
  CellTags->{"S3.7.9", "9.1"}],
Cell[102737, 3862, 2726, 84, 70, "DefinitionBox",
  CellTags->"S3.7.9"],
Cell[105466, 3948, 71, 1, 70, "Caption",
  CellTags->"S3.7.9"],
Cell[105540, 3951, 1312, 49, 70, "Text",
  CellTags->{"S3.7.9", "9.2"}],
Cell[106855, 4002, 751, 31, 70, "Text",
  CellTags->{"S3.7.9", "9.3"}],
Cell[107609, 4035, 1013, 30, 70, "Text",
  CellTags->{"S3.7.9", "9.4"}],
Cell[108625, 4067, 160, 4, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.5"}],

Cell[CellGroupData[{
Cell[108810, 4075, 97, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[108910, 4079, 170, 4, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]],
Cell[109095, 4086, 219, 5, 70, "Text",
  CellTags->{"S3.7.9", "9.6"}],
Cell[109317, 4093, 179, 6, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.7"}],

Cell[CellGroupData[{
Cell[109521, 4103, 93, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[109617, 4107, 114, 3, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]],
Cell[109746, 4113, 110, 1, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.8"}],

Cell[CellGroupData[{
Cell[109881, 4118, 80, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[109964, 4122, 126, 3, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]],
Cell[110105, 4128, 134, 5, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.9"}],

Cell[CellGroupData[{
Cell[110264, 4137, 81, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[110348, 4141, 182, 4, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]],
Cell[110545, 4148, 314, 9, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.10"}],

Cell[CellGroupData[{
Cell[110884, 4161, 93, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[110980, 4165, 244, 5, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]],
Cell[111239, 4173, 156, 4, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.11"}],

Cell[CellGroupData[{
Cell[111420, 4181, 100, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[111523, 4185, 85, 3, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]],
Cell[111623, 4191, 280, 7, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.12"}],

Cell[CellGroupData[{
Cell[111928, 4202, 105, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[112036, 4206, 314, 6, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]],
Cell[112365, 4215, 1158, 35, 70, "Text",
  CellTags->{"S3.7.9", "9.13"}],
Cell[113526, 4252, 170, 6, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.14"}],

Cell[CellGroupData[{
Cell[113721, 4262, 102, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[113826, 4266, 114, 3, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]],
Cell[113955, 4272, 108, 1, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.15"}],

Cell[CellGroupData[{
Cell[114088, 4277, 79, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[114170, 4281, 90, 3, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]],
Cell[114275, 4287, 252, 5, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.16"}],

Cell[CellGroupData[{
Cell[114552, 4296, 81, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[114636, 4300, 115, 3, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]],
Cell[114766, 4306, 1995, 64, 70, "DefinitionBox",
  CellTags->"S3.7.9"],
Cell[116764, 4372, 83, 1, 70, "Caption",
  CellTags->"S3.7.9"],
Cell[116850, 4375, 626, 21, 70, "Text",
  CellTags->{"S3.7.9", "9.17"}],
Cell[117479, 4398, 115, 2, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.18"}],

Cell[CellGroupData[{
Cell[117619, 4404, 94, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[117716, 4408, 126, 3, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]],
Cell[117857, 4414, 111, 1, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.19"}],

Cell[CellGroupData[{
Cell[117993, 4419, 69, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[118065, 4423, 128, 3, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]],
Cell[118208, 4429, 127, 4, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.20"}],

Cell[CellGroupData[{
Cell[118360, 4437, 117, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[118480, 4441, 285, 5, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]],
Cell[118780, 4449, 1607, 50, 70, "DefinitionBox",
  CellTags->"S3.7.9"],
Cell[120390, 4501, 83, 1, 70, "Caption",
  CellTags->"S3.7.9"],
Cell[120476, 4504, 1071, 40, 70, "Text",
  CellTags->{"S3.7.9", "9.21"}],
Cell[121550, 4546, 329, 14, 70, "Text",
  CellTags->{"S3.7.9", "9.22"}],
Cell[121882, 4562, 611, 18, 70, "Text",
  CellTags->{"S3.7.9", "9.23"}],
Cell[122496, 4582, 212, 6, 70, "MathCaption",
  CellTags->{"S3.7.9", "9.24"}],

Cell[CellGroupData[{
Cell[122733, 4592, 116, 2, 70, "Input",
  CellTags->"S3.7.9"],
Cell[122852, 4596, 102, 3, 70, "Output",
  CellTags->"S3.7.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[123003, 4605, 88, 1, 70, "Subsection",
  CellTags->{"S3.7.10", "10.1"}],
Cell[123094, 4608, 1929, 61, 70, "DefinitionBox",
  CellTags->"S3.7.10"],
Cell[125026, 4671, 89, 1, 70, "Caption",
  CellTags->"S3.7.10"],
Cell[125118, 4674, 1229, 37, 70, "Text",
  CellTags->{"S3.7.10", "10.2"}],
Cell[126350, 4713, 932, 32, 70, "Text",
  CellTags->{"S3.7.10", "10.3"}],
Cell[127285, 4747, 720, 26, 70, "Text",
  CellTags->{"S3.7.10", "10.4"}],
Cell[128008, 4775, 1531, 57, 70, "Text",
  CellTags->{"S3.7.10", "10.5"}],
Cell[129542, 4834, 645, 18, 70, "DefinitionBox",
  CellTags->"S3.7.10"],
Cell[130190, 4854, 86, 1, 70, "Caption",
  CellTags->"S3.7.10"],
Cell[130279, 4857, 391, 12, 70, "Text",
  CellTags->{"S3.7.10", "10.6"}],
Cell[130673, 4871, 491, 9, 70, "Text",
  CellTags->{"S3.7.10", "10.7"}],
Cell[131167, 4882, 1205, 33, 70, "DefinitionBox",
  CellTags->"S3.7.10"],
Cell[132375, 4917, 81, 1, 70, "Caption",
  CellTags->"S3.7.10"],
Cell[132459, 4920, 1213, 36, 70, "Text",
  CellTags->{"S3.7.10", "10.8"}],
Cell[133675, 4958, 916, 32, 70, "Text",
  CellTags->{"S3.7.10", "10.9"}],
Cell[134594, 4992, 1295, 46, 70, "Text",
  CellTags->{"S3.7.10", "10.10"}],
Cell[135892, 5040, 1200, 33, 70, "DefinitionBox",
  CellTags->"S3.7.10"],
Cell[137095, 5075, 84, 1, 70, "Caption",
  CellTags->"S3.7.10"],
Cell[137182, 5078, 665, 16, 70, "Text",
  CellTags->{"S3.7.10", "10.11"}],
Cell[137850, 5096, 1459, 50, 70, "Text",
  CellTags->{"S3.7.10", "10.12"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[139346, 5151, 85, 1, 70, "Subsection",
  CellTags->{"S3.7.11", "11.1"}],
Cell[139434, 5154, 373, 10, 70, "Text",
  CellTags->{"S3.7.11", "11.2"}],
Cell[139810, 5166, 856, 30, 70, "DefinitionBox",
  CellTags->"S3.7.11"],
Cell[140669, 5198, 75, 1, 70, "Caption",
  CellTags->"S3.7.11"],
Cell[140747, 5201, 770, 24, 70, "Text",
  CellTags->{"S3.7.11", "11.3"}],
Cell[141520, 5227, 303, 8, 70, "Text",
  CellTags->{"S3.7.11", "11.4"}],
Cell[141826, 5237, 730, 18, 70, "Text",
  CellTags->{"S3.7.11", "11.5"}],
Cell[142559, 5257, 6098, 173, 70, "DefinitionBox",
  CellTags->"S3.7.11"],
Cell[148660, 5432, 113, 4, 70, "Caption",
  CellTags->"S3.7.11"],
Cell[148776, 5438, 180, 6, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.6"}],

Cell[CellGroupData[{
Cell[148981, 5448, 111, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[149095, 5452, 134, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[149244, 5458, 104, 1, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.7"}],

Cell[CellGroupData[{
Cell[149373, 5463, 96, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[149472, 5467, 134, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[149621, 5473, 324, 8, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.8"}],

Cell[CellGroupData[{
Cell[149970, 5485, 80, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[150053, 5489, 2092, 60, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[152160, 5552, 141, 4, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.9"}],

Cell[CellGroupData[{
Cell[152326, 5560, 80, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[152409, 5564, 91, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[152515, 5570, 182, 6, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.10"}],

Cell[CellGroupData[{
Cell[152722, 5580, 77, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[152802, 5584, 83, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[152900, 5590, 136, 4, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.11"}],

Cell[CellGroupData[{
Cell[153061, 5598, 80, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[153144, 5602, 83, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[153242, 5608, 215, 5, 70, "Text",
  CellTags->{"S3.7.11", "11.12"}],
Cell[153460, 5615, 6321, 178, 70, "DefinitionBox",
  CellTags->"S3.7.11"],
Cell[159784, 5795, 74, 1, 70, "Caption",
  CellTags->"S3.7.11"],
Cell[159861, 5798, 827, 24, 70, "Text",
  CellTags->{"S3.7.11", "11.13"}],
Cell[160691, 5824, 2390, 90, 70, "Text",
  CellTags->{"S3.7.11", "11.14"}],
Cell[163084, 5916, 1246, 44, 70, "Text",
  CellTags->{"S3.7.11", "11.15"}],
Cell[164333, 5962, 211, 6, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.16"}],

Cell[CellGroupData[{
Cell[164569, 5972, 94, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[164666, 5976, 107, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[164788, 5982, 367, 11, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.17"}],

Cell[CellGroupData[{
Cell[165180, 5997, 82, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[165265, 6001, 109, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[165389, 6007, 286, 11, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.18"}],

Cell[CellGroupData[{
Cell[165700, 6022, 90, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[165793, 6026, 90, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[165898, 6032, 196, 6, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.19"}],

Cell[CellGroupData[{
Cell[166119, 6042, 92, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[166214, 6046, 343, 7, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[166572, 6056, 162, 5, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.20"}],

Cell[CellGroupData[{
Cell[166759, 6065, 84, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[166846, 6069, 345, 7, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[167206, 6079, 196, 6, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.21"}],

Cell[CellGroupData[{
Cell[167427, 6089, 83, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[167513, 6093, 95, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[167623, 6099, 248, 6, 70, "Text",
  CellTags->{"S3.7.11", "11.22"}],
Cell[167874, 6107, 201, 5, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.23"}],

Cell[CellGroupData[{
Cell[168100, 6116, 107, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[168210, 6120, 119, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[168344, 6126, 99, 1, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.24"}],

Cell[CellGroupData[{
Cell[168468, 6131, 104, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[168575, 6135, 135, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[168725, 6141, 156, 5, 70, "Text",
  CellTags->{"S3.7.11", "11.25"}],
Cell[168884, 6148, 107, 1, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.26"}],

Cell[CellGroupData[{
Cell[169016, 6153, 89, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[169108, 6157, 119, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[169242, 6163, 132, 4, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.27"}],

Cell[CellGroupData[{
Cell[169399, 6171, 95, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[169497, 6175, 119, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[169631, 6181, 111, 1, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.28"}],

Cell[CellGroupData[{
Cell[169767, 6186, 98, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[169868, 6190, 206, 4, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[170089, 6197, 265, 5, 70, "Text",
  CellTags->{"S3.7.11", "11.29"}],
Cell[170357, 6204, 689, 25, 70, "Text",
  CellTags->{"S3.7.11", "11.30"}],
Cell[171049, 6231, 211, 5, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.31"}],

Cell[CellGroupData[{
Cell[171285, 6240, 94, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[171382, 6244, 127, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[171524, 6250, 318, 9, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.32"}],

Cell[CellGroupData[{
Cell[171867, 6263, 97, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[171967, 6267, 158, 4, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[172140, 6274, 469, 14, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.33"}],

Cell[CellGroupData[{
Cell[172634, 6292, 113, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[172750, 6296, 249, 5, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[173014, 6304, 96, 1, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.34"}],

Cell[CellGroupData[{
Cell[173135, 6309, 81, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[173219, 6313, 92, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[173326, 6319, 2035, 71, 70, "Text",
  CellTags->{"S3.7.11", "11.35"}],
Cell[175364, 6392, 2923, 109, 70, "Text",
  CellTags->{"S3.7.11", "11.36"}],
Cell[178290, 6503, 287, 9, 70, "Text",
  CellTags->{"S3.7.11", "11.37"}],
Cell[178580, 6514, 383, 11, 70, "Text",
  CellTags->{"S3.7.11", "11.38"}],
Cell[178966, 6527, 2623, 97, 70, "Text",
  CellTags->{"S3.7.11", "11.39"}],
Cell[181592, 6626, 863, 30, 70, "Text",
  CellTags->{"S3.7.11", "11.40"}],
Cell[182458, 6658, 141, 4, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.41"}],

Cell[CellGroupData[{
Cell[182624, 6666, 102, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[182729, 6670, 114, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[182858, 6676, 106, 1, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.42"}],

Cell[CellGroupData[{
Cell[182989, 6681, 113, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[183105, 6685, 180, 4, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[183300, 6692, 181, 6, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.43"}],

Cell[CellGroupData[{
Cell[183506, 6702, 90, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[183599, 6706, 137, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[183751, 6712, 181, 6, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.44"}],

Cell[CellGroupData[{
Cell[183957, 6722, 90, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[184050, 6726, 117, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[184182, 6732, 193, 6, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.45"}],

Cell[CellGroupData[{
Cell[184400, 6742, 71, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[184474, 6746, 193, 4, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[184682, 6753, 96, 1, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.46"}],

Cell[CellGroupData[{
Cell[184803, 6758, 81, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[184887, 6762, 95, 3, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[184997, 6768, 513, 12, 70, "Text",
  CellTags->{"S3.7.11", "11.47"}],
Cell[185513, 6782, 674, 24, 70, "Text",
  CellTags->{"S3.7.11", "11.48"}],
Cell[186190, 6808, 6940, 203, 70, "DefinitionBox",
  CellTags->"S3.7.11"],
Cell[193133, 7013, 116, 4, 70, "Caption",
  CellTags->"S3.7.11"],
Cell[193252, 7019, 118, 2, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.49"}],

Cell[CellGroupData[{
Cell[193395, 7025, 100, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[193498, 7029, 178, 4, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]],
Cell[193691, 7036, 135, 4, 70, "MathCaption",
  CellTags->{"S3.7.11", "11.50"}],

Cell[CellGroupData[{
Cell[193851, 7044, 103, 2, 70, "Input",
  CellTags->"S3.7.11"],
Cell[193957, 7048, 152, 4, 70, "Output",
  CellTags->"S3.7.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[194158, 7058, 75, 1, 70, "Subsection",
  CellTags->{"S3.7.12", "12.1"}],
Cell[194236, 7061, 619, 16, 70, "Text",
  CellTags->{"S3.7.12", "12.2"}],
Cell[194858, 7079, 6240, 180, 70, "DefinitionBox",
  CellTags->"S3.7.12"],
Cell[201101, 7261, 68, 1, 70, "Caption",
  CellTags->"S3.7.12"],
Cell[201172, 7264, 336, 9, 70, "Text",
  CellTags->{"S3.7.12", "12.3"}],
Cell[201511, 7275, 229, 6, 70, "MathCaption",
  CellTags->{"S3.7.12", "12.4"}],

Cell[CellGroupData[{
Cell[201765, 7285, 151, 5, 70, "Input",
  CellTags->"S3.7.12"],
Cell[201919, 7292, 350, 10, 70, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[202284, 7305, 117, 2, 70, "MathCaption",
  CellTags->{"S3.7.12", "12.5"}],

Cell[CellGroupData[{
Cell[202426, 7311, 84, 2, 70, "Input",
  CellTags->"S3.7.12"],
Cell[202513, 7315, 18500, 1558, 70, 18426, 1555, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S3.7.12"],
Cell[221016, 8875, 185, 5, 70, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[221216, 8883, 109, 1, 70, "MathCaption",
  CellTags->{"S3.7.12", "12.6"}],

Cell[CellGroupData[{
Cell[221350, 8888, 82, 2, 70, "Input",
  CellTags->"S3.7.12"],
Cell[221435, 8892, 175, 4, 70, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[221625, 8899, 154, 6, 70, "MathCaption",
  CellTags->{"S3.7.12", "12.7"}],

Cell[CellGroupData[{
Cell[221804, 8909, 70, 2, 70, "Input",
  CellTags->"S3.7.12"],
Cell[221877, 8913, 352, 10, 70, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[222244, 8926, 110, 1, 70, "MathCaption",
  CellTags->{"S3.7.12", "12.8"}],

Cell[CellGroupData[{
Cell[222379, 8931, 76, 2, 70, "Input",
  CellTags->"S3.7.12"],
Cell[222458, 8935, 89, 3, 70, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[222562, 8941, 315, 8, 70, "Text",
  CellTags->{"S3.7.12", "12.9"}],
Cell[222880, 8951, 2577, 85, 70, "DefinitionBox",
  CellTags->"S3.7.12"],
Cell[225460, 9038, 164, 5, 70, "Caption",
  CellTags->"S3.7.12"],
Cell[225627, 9045, 176, 5, 70, "MathCaption",
  CellTags->{"S3.7.12", "12.10"}],

Cell[CellGroupData[{
Cell[225828, 9054, 76, 2, 70, "Input",
  CellTags->"S3.7.12"],
Cell[225907, 9058, 342, 10, 70, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[226264, 9071, 155, 5, 70, "MathCaption",
  CellTags->{"S3.7.12", "12.11"}],

Cell[CellGroupData[{
Cell[226444, 9080, 94, 2, 70, "Input",
  CellTags->"S3.7.12"],
Cell[226541, 9084, 352, 10, 70, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[226908, 9097, 130, 4, 70, "MathCaption",
  CellTags->{"S3.7.12", "12.12"}],

Cell[CellGroupData[{
Cell[227063, 9105, 76, 2, 70, "Input",
  CellTags->"S3.7.12"],
Cell[227142, 9109, 344, 10, 70, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[227501, 9122, 141, 4, 70, "MathCaption",
  CellTags->{"S3.7.12", "12.13"}],

Cell[CellGroupData[{
Cell[227667, 9130, 83, 2, 70, "Input",
  CellTags->"S3.7.12"],
Cell[227753, 9134, 156, 4, 70, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[227924, 9141, 1948, 53, 70, "DefinitionBox",
  CellTags->"S3.7.12"],
Cell[229875, 9196, 77, 1, 70, "Caption",
  CellTags->"S3.7.12"],
Cell[229955, 9199, 101, 1, 70, "MathCaption",
  CellTags->{"S3.7.12", "12.14"}],

Cell[CellGroupData[{
Cell[230081, 9204, 138, 5, 70, "Input",
  CellTags->"S3.7.12"],
Cell[230222, 9211, 353, 10, 70, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[230590, 9224, 118, 2, 70, "MathCaption",
  CellTags->{"S3.7.12", "12.15"}],

Cell[CellGroupData[{
Cell[230733, 9230, 84, 2, 70, "Input",
  CellTags->"S3.7.12"],
Cell[230820, 9234, 355, 10, 70, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[231190, 9247, 106, 1, 70, "MathCaption",
  CellTags->{"S3.7.12", "12.16"}],

Cell[CellGroupData[{
Cell[231321, 9252, 144, 5, 45, "Input",
  CellTags->"S3.7.12"],
Cell[231468, 9259, 790, 24, 70, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[232273, 9286, 101, 1, 40, "MathCaption",
  CellTags->{"S3.7.12", "12.17"}],

Cell[CellGroupData[{
Cell[232399, 9291, 75, 2, 28, "Input",
  CellTags->"S3.7.12"],
Cell[232477, 9295, 120, 3, 25, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[232612, 9301, 93, 1, 40, "MathCaption",
  CellTags->{"S3.7.12", "12.18"}],

Cell[CellGroupData[{
Cell[232730, 9306, 93, 2, 28, "Input",
  CellTags->"S3.7.12"],
Cell[232826, 9310, 108, 3, 25, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[232949, 9316, 154, 4, 40, "MathCaption",
  CellTags->{"S3.7.12", "12.19"}],

Cell[CellGroupData[{
Cell[233128, 9324, 151, 5, 45, "Input",
  CellTags->"S3.7.12"],
Cell[233282, 9331, 1135, 34, 41, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[234432, 9368, 136, 4, 40, "MathCaption",
  CellTags->{"S3.7.12", "12.20"}],

Cell[CellGroupData[{
Cell[234593, 9376, 75, 2, 28, "Input",
  CellTags->"S3.7.12"],
Cell[234671, 9380, 225, 6, 57, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[234911, 9389, 93, 1, 40, "MathCaption",
  CellTags->{"S3.7.12", "12.21"}],

Cell[CellGroupData[{
Cell[235029, 9394, 126, 2, 45, "Input",
  CellTags->"S3.7.12"],
Cell[235158, 9398, 117, 3, 27, "Output",
  CellTags->"S3.7.12"]
}, Open  ]],
Cell[235290, 9404, 415, 12, 56, "Text",
  CellTags->{"S3.7.12", "12.22"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

