(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    968585,      21909]*)
(*NotebookOutlinePosition[   1027746,      23592]*)
(*  CellTagsIndexPosition[   1022855,      23409]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["3.8 ", "HeadingNumber"],
  "Numerical Operations on Data"
}], "Section",
  CellTags->{"S3.8.0", "0.1"}],

Cell[CellGroupData[{

Cell["3.8.1 Basic Statistics", "Subsection",
  CellTags->{"S3.8.1", "1.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Mean[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["mean (average) "]},
          {Cell[TextData[{
              StyleBox["Median[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["median (central value) "]},
          {Cell[TextData[{
              StyleBox["Max[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["maximum value "]},
          {Cell[TextData[{
              StyleBox["Variance[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["variance "]},
          {Cell[TextData[{
              StyleBox["StandardDeviation[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["standard deviation "]},
          {Cell[TextData[{
              StyleBox["Quantile[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["q", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["q", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " quantile "
            }]]},
          {Cell[TextData[{
              StyleBox["Total[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["total "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False, False, True}},
  CellTags->"S3.8.1"],

Cell["Basic descriptive statistics operations. ", "Caption",
  CellTags->"S3.8.1"],

Cell[TextData[{
  "Given a list with ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " elements ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", the ",
  StyleBox["mean", "TB"],
  " ",
  StyleBox["Mean[", "MR"],
  StyleBox["list", "TI"],
  StyleBox["]", "MR"],
  " is defined to be ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Mu]", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          OverscriptBox[
            StyleBox["x",
              "TI"], "_"], "=", "\[Sum]", 
          SubscriptBox[
            StyleBox["x",
              "TI"], 
            StyleBox["i",
              "TI"]], "/", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.8.1", "1.2"}],

Cell[TextData[{
  "The ",
  StyleBox["variance", "TB"],
  " ",
  StyleBox["Variance[", "MR"],
  StyleBox["list", "TI"],
  StyleBox["]", "MR"],
  " is defined to be ",
  Cell[BoxData[
      FormBox[
        RowBox[{"var", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", \(\[Sigma]\^2\), 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", "\[Sum]", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SubscriptBox[
                  StyleBox["x",
                    "TI"], 
                  StyleBox["i",
                    "TI"]], "-", "\[Mu]", 
                RowBox[{"(", 
                  StyleBox["x",
                    "TI"], ")"}]}], ")"}], "2"], "/", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], "-", "1"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.8.1", "1.3"}],

Cell[TextData[{
  "The ",
  StyleBox["standard deviation", "TB"],
  " ",
  StyleBox["StandardDeviation[", "MR"],
  StyleBox["list", "TI"],
  StyleBox["]", "MR"],
  " is defined to be ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Sigma]", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          SqrtBox[
            RowBox[{"var", 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.8.1", "1.4"}],

Cell[TextData[{
  "If the elements in ",
  StyleBox["list", "TI"],
  " are thought of as being selected at random according to some probability \
distribution, then the mean gives an estimate of where the center of the \
distribution is located, while the standard deviation gives an estimate of \
how wide the dispersion in the distribution is. "
}], "Text",
  CellTags->{"S3.8.1", "1.5"}],

Cell[TextData[{
  "The ",
  StyleBox["median", "TB"],
  " ",
  StyleBox["Median[", "MR"],
  StyleBox["list", "TI"],
  StyleBox["]", "MR"],
  " effectively gives the value at the halfway point in the sorted version of \
",
  StyleBox["list", "TI"],
  ". It is often considered a more robust measure of the center of a \
distribution than the mean, since it depends less on outlying values.  "
}], "Text",
  CellTags->{"S3.8.1", "1.6"}],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " ",
  StyleBox["quantile", "TB"],
  " ",
  StyleBox["Quantile[", "MR"],
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["q", "TI"],
  StyleBox["]", "MR"],
  " effectively gives the value that is ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula"],
  " of the way through the sorted version of ",
  StyleBox["list", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.8.1", "1.7"}],

Cell[TextData[{
  "For a list of length ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " defines ",
  StyleBox["Quantile[", "MR"],
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["q", "TI"],
  StyleBox["]", "MR"],
  " to be ",
  StyleBox["s", "TI"],
  StyleBox["[[Ceiling[", "MR"],
  StyleBox["n", "TI"],
  " ",
  StyleBox["q", "TI"],
  StyleBox["]]]", "MR"],
  ", where ",
  StyleBox["s", "TI"],
  " is ",
  StyleBox["Sort[", "MR"],
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["Less]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.8.1", "1.8"}],

Cell[TextData[{
  "There are, however, about ten other definitions of quantile in use, all \
potentially giving slightly different results. ",
  StyleBox["Mathematica", "TI"],
  " covers the common cases by introducing four ",
  StyleBox["quantile parameters", "TI"],
  " in the form ",
  StyleBox["Quantile[", "MR"],
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["q", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{{", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["c", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["d", "TI"],
  StyleBox["}}]", "MR"],
  ". The parameters ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["b",
          "TI"], TraditionalForm]], "InlineFormula"],
  " in effect define where in the list should be considered a fraction ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula"],
  " of the way through. If this corresponds to an integer position, then the \
element at that position is taken to be the ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " quantile. If it is not an integer position, then a linear combination of \
the elements on either side is used, as specified by ",
  Cell[BoxData[
      FormBox[
        StyleBox["c",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["d",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.8.1", "1.9"}],

Cell[TextData[{
  "The position in a sorted list ",
  Cell[BoxData[
      FormBox[
        StyleBox["s",
          "TI"], TraditionalForm]], "InlineFormula"],
  " for the ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " quantile is taken to be ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k",
            "TI"], "=", 
          StyleBox["a",
            "TI"], "+", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], "+", 
              StyleBox["b",
                "TI"]}], ")"}], " ", 
          StyleBox["q",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". If ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is an integer, then the quantile is ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            "TI"], 
          StyleBox["k",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". Otherwise, it is ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["s",
              "TI"], 
            RowBox[{"\[LeftFloor]", 
              StyleBox["k",
                "TI"], "\[RightFloor]"}]], "+", 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox[
                StyleBox["s",
                  "TI"], 
                RowBox[{"\[LeftCeiling]", 
                  StyleBox["k",
                    "TI"], "\[RightCeiling]"}]], "-", 
              SubscriptBox[
                StyleBox["s",
                  "TI"], 
                RowBox[{"\[LeftFloor]", 
                  StyleBox["k",
                    "TI"], "\[RightFloor]"}]]}], ")"}], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["c",
                "TI"], "+", 
              StyleBox["d",
                "TI"], 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["k",
                    "TI"], "-", "\[LeftFloor]", 
                  StyleBox["k",
                    "TI"], "\[RightFloor]"}], ")"}]}], ")"}]}], 
        TraditionalForm]], "InlineFormula"],
  ", with the indices taken to be ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  " or ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " if they are out of range. "
}], "Text",
  CellTags->{"S3.8.1", "1.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{{0,", "MR"],
              " ",
              StyleBox["0},", "MR"],
              " ",
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["0}}", "MR"],
              " "
            }]], Cell["inverse empirical CDF (default) "]},
          {Cell[TextData[{
              StyleBox["{{0,", "MR"],
              " ",
              StyleBox["0},", "MR"],
              " ",
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["1}}", "MR"],
              " "
            }]], Cell["linear interpolation (California method) "]},
          {Cell[TextData[{
              StyleBox["{{1/2,", "MR"],
              " ",
              StyleBox["0},", "MR"],
              " ",
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["0}}", "MR"],
              " "
            }]], Cell[TextData[{
              "element numbered closest to ",
              Cell[BoxData[
                  FormBox[
                    StyleBox[\(q  n\),
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{{1/2,", "MR"],
              " ",
              StyleBox["0},", "MR"],
              " ",
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["1}}", "MR"],
              " "
            }]], Cell["linear interpolation (hydrologist method) "]},
          {Cell[TextData[{
              StyleBox["{{0,", "MR"],
              " ",
              StyleBox["1},", "MR"],
              " ",
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["1}}", "MR"],
              " "
            }]], 
            Cell["\<\
mean\[Hyphen]based estimate (Weibull method) \
\>"]},
          {Cell[TextData[{
              StyleBox["{{1,", "MR"],
              " ",
              StyleBox["-1},", "MR"],
              " ",
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["1}}", "MR"],
              " "
            }]], Cell["mode\[Hyphen]based estimate "]},
          {Cell[TextData[{
              StyleBox["{{1/3,", "MR"],
              " ",
              StyleBox["1/3},", "MR"],
              " ",
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["1}}", "MR"],
              " "
            }]], Cell["median\[Hyphen]based estimate "]},
          {Cell[TextData[{
              StyleBox["{{3/8,", "MR"],
              " ",
              StyleBox["1/4},", "MR"],
              " ",
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["1}}", "MR"],
              " "
            }]], Cell["normal distribution estimate "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False, True, False}},
  CellTags->"S3.8.1"],

Cell["Common choices for quantile parameters. ", "Caption",
  CellTags->"S3.8.1"],

Cell[TextData[{
  "Whenever ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["d",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", the value of the ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " quantile is always equal to some actual element in ",
  StyleBox["list", "TI"],
  ", so that the result changes discontinuously as ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula"],
  " varies. For ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["d",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  ", the ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " quantile interpolates linearly between successive elements in ",
  StyleBox["list", "TI"],
  ". ",
  StyleBox["Median", "MR"],
  " is defined to use such an interpolation. "
}], "Text",
  CellTags->{"S3.8.1", "1.11"}],

Cell[TextData[{
  "Note that ",
  StyleBox["Quantile[", "MR"],
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["q", "TI"],
  StyleBox["]", "MR"],
  " yields ",
  StyleBox["quartiles", "TB"],
  " when ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["q",
            "TI"], "=", 
          StyleBox["m",
            "TI"], "/", "4"}], TraditionalForm]], "InlineFormula"],
  " and ",
  StyleBox["percentiles", "TB"],
  " when ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["q",
            "TI"], "=", 
          StyleBox["m",
            "TI"], "/", "100"}], TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.8.1", "1.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Mean[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the mean of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Mean[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "a list of the means of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.1"],

Cell["Handling multidimensional data. ", "Caption",
  CellTags->"S3.8.1"],

Cell[TextData[{
  "Sometimes each item in your data may involve a list of values. The basic \
statistics functions in ",
  StyleBox["Mathematica", "TI"],
  " automatically apply to all corresponding elements in these lists. "
}], "Text",
  CellTags->{"S3.8.1", "1.13"}],

Cell["\<\
This separately finds the mean of each \
\[OpenCurlyDoubleQuote]column\[CloseCurlyDoubleQuote] of data. \
\>", \
"MathCaption",
  CellTags->{"S3.8.1", "1.14"}],

Cell[CellGroupData[{

Cell["Mean[{{x1, y1}, {x2, y2}, {x3, y3}}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.8.1"],

Cell[BoxData[
    \({1\/3\ \((x1 + x2 + x3)\), 1\/3\ \((y1 + y2 + y3)\)}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.8.1"]
}, Open  ]],

Cell[TextData[{
  "Note that you can extract the elements in the ",
  StyleBox["i", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " \[OpenCurlyDoubleQuote]column\[CloseCurlyDoubleQuote] of a \
multidimensional list using ",
  StyleBox["list", "TI"],
  StyleBox["[[All,", "MR"],
  " ",
  StyleBox["i", "TI"],
  StyleBox["]]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.8.1", "1.15"}],

Cell[TextData[{
  "The standard set of packages distributed with ",
  StyleBox["Mathematica", "TI"],
  " includes several for doing more sophisticated statistical analyses, as \
mentioned in Section\[NonBreakingSpace]",
  ButtonBox["1.6.7",
    ButtonData:>{"1.6.7", "7.5"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S3.8.1", "1.16"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.8.2 Curve Fitting", "Subsection",
  CellTags->{"S3.8.2", "2.1"}],

Cell[TextData[{
  "There are many situations where one wants to find a formula that best fits \
a given set of data. One way to do this in ",
  StyleBox["Mathematica", "TI"],
  " is to use ",
  StyleBox["Fit", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.8.2", "2.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Fit[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["fun",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["fun",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find a linear combination of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["fun",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " that best fits the values ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.2"],

Cell["Basic linear fits. ", "Caption",
  CellTags->"S3.8.2"],

Cell["Here is a table of the first 20 primes. ", "MathCaption",
  CellTags->{"S3.8.2", "2.3"}],

Cell[CellGroupData[{

Cell["fp = Table[Prime[x], {x, 20}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.8.2"],

Cell[BoxData[
    \({2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 
      67, 71}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell["\<\
Here is a plot of this \[OpenCurlyDoubleQuote]data\
\[CloseCurlyDoubleQuote]. \
\>", "MathCaption",
  CellTags->{"S3.8.2", "2.4"}],

Cell[CellGroupData[{

Cell["gp = ListPlot[ fp ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.8.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0.0147151 0.00829019 [
[.2619 .00222 -3 -9 ]
[.2619 .00222 3 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.7381 .00222 -6 -9 ]
[.7381 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .09762 -12 -4.5 ]
[.01131 .09762 0 4.5 ]
[.01131 .18052 -12 -4.5 ]
[.01131 .18052 0 4.5 ]
[.01131 .26342 -12 -4.5 ]
[.01131 .26342 0 4.5 ]
[.01131 .34632 -12 -4.5 ]
[.01131 .34632 0 4.5 ]
[.01131 .42922 -12 -4.5 ]
[.01131 .42922 0 4.5 ]
[.01131 .51213 -12 -4.5 ]
[.01131 .51213 0 4.5 ]
[.01131 .59503 -12 -4.5 ]
[.01131 .59503 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(10)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(15)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(20)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .09762 m
.03006 .09762 L
s
[(10)] .01131 .09762 1 0 Mshowa
.02381 .18052 m
.03006 .18052 L
s
[(20)] .01131 .18052 1 0 Mshowa
.02381 .26342 m
.03006 .26342 L
s
[(30)] .01131 .26342 1 0 Mshowa
.02381 .34632 m
.03006 .34632 L
s
[(40)] .01131 .34632 1 0 Mshowa
.02381 .42922 m
.03006 .42922 L
s
[(50)] .01131 .42922 1 0 Mshowa
.02381 .51213 m
.03006 .51213 L
s
[(60)] .01131 .51213 1 0 Mshowa
.02381 .59503 m
.03006 .59503 L
s
[(70)] .01131 .59503 1 0 Mshowa
.125 Mabswid
.02381 .0313 m
.02756 .0313 L
s
.02381 .04788 m
.02756 .04788 L
s
.02381 .06446 m
.02756 .06446 L
s
.02381 .08104 m
.02756 .08104 L
s
.02381 .1142 m
.02756 .1142 L
s
.02381 .13078 m
.02756 .13078 L
s
.02381 .14736 m
.02756 .14736 L
s
.02381 .16394 m
.02756 .16394 L
s
.02381 .1971 m
.02756 .1971 L
s
.02381 .21368 m
.02756 .21368 L
s
.02381 .23026 m
.02756 .23026 L
s
.02381 .24684 m
.02756 .24684 L
s
.02381 .28 m
.02756 .28 L
s
.02381 .29658 m
.02756 .29658 L
s
.02381 .31316 m
.02756 .31316 L
s
.02381 .32974 m
.02756 .32974 L
s
.02381 .3629 m
.02756 .3629 L
s
.02381 .37948 m
.02756 .37948 L
s
.02381 .39606 m
.02756 .39606 L
s
.02381 .41264 m
.02756 .41264 L
s
.02381 .44581 m
.02756 .44581 L
s
.02381 .46239 m
.02756 .46239 L
s
.02381 .47897 m
.02756 .47897 L
s
.02381 .49555 m
.02756 .49555 L
s
.02381 .52871 m
.02756 .52871 L
s
.02381 .54529 m
.02756 .54529 L
s
.02381 .56187 m
.02756 .56187 L
s
.02381 .57845 m
.02756 .57845 L
s
.02381 .61161 m
.02756 .61161 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.07143 .0313 Mdot
.11905 .03959 Mdot
.16667 .05617 Mdot
.21429 .07275 Mdot
.2619 .10591 Mdot
.30952 .12249 Mdot
.35714 .15565 Mdot
.40476 .17223 Mdot
.45238 .20539 Mdot
.5 .25513 Mdot
.54762 .27171 Mdot
.59524 .32145 Mdot
.64286 .35461 Mdot
.69048 .37119 Mdot
.7381 .40435 Mdot
.78571 .4541 Mdot
.83333 .50384 Mdot
.88095 .52042 Mdot
.92857 .57016 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell[TextData[{
  "This gives a linear fit to the list of primes. The result is the best \
linear combination of the functions ",
  StyleBox["1", "MR"],
  " and ",
  StyleBox["x", "MR"],
  ".  "
}], "MathCaption",
  CellTags->{"S3.8.2", "2.5"}],

Cell[CellGroupData[{

Cell["Fit[fp, {1, x}, x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.8.2"],

Cell[BoxData[
    \(\(-7.6736842105263126`\) + 3.773684210526316`\ x\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell["Here is a plot of the fit. ", "MathCaption",
  CellTags->{"S3.8.2", "2.6"}],

Cell[CellGroupData[{

Cell["Plot[%, {x, 0, 20}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.8.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0.0745606 0.0077988 [
[.2619 .06206 -3 -9 ]
[.2619 .06206 3 0 ]
[.5 .06206 -6 -9 ]
[.5 .06206 6 0 ]
[.7381 .06206 -6 -9 ]
[.7381 .06206 6 0 ]
[.97619 .06206 -6 -9 ]
[.97619 .06206 6 0 ]
[.01131 .15255 -12 -4.5 ]
[.01131 .15255 0 4.5 ]
[.01131 .23054 -12 -4.5 ]
[.01131 .23054 0 4.5 ]
[.01131 .30852 -12 -4.5 ]
[.01131 .30852 0 4.5 ]
[.01131 .38651 -12 -4.5 ]
[.01131 .38651 0 4.5 ]
[.01131 .4645 -12 -4.5 ]
[.01131 .4645 0 4.5 ]
[.01131 .54249 -12 -4.5 ]
[.01131 .54249 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .07456 m
.2619 .08081 L
s
[(5)] .2619 .06206 0 1 Mshowa
.5 .07456 m
.5 .08081 L
s
[(10)] .5 .06206 0 1 Mshowa
.7381 .07456 m
.7381 .08081 L
s
[(15)] .7381 .06206 0 1 Mshowa
.97619 .07456 m
.97619 .08081 L
s
[(20)] .97619 .06206 0 1 Mshowa
.125 Mabswid
.07143 .07456 m
.07143 .07831 L
s
.11905 .07456 m
.11905 .07831 L
s
.16667 .07456 m
.16667 .07831 L
s
.21429 .07456 m
.21429 .07831 L
s
.30952 .07456 m
.30952 .07831 L
s
.35714 .07456 m
.35714 .07831 L
s
.40476 .07456 m
.40476 .07831 L
s
.45238 .07456 m
.45238 .07831 L
s
.54762 .07456 m
.54762 .07831 L
s
.59524 .07456 m
.59524 .07831 L
s
.64286 .07456 m
.64286 .07831 L
s
.69048 .07456 m
.69048 .07831 L
s
.78571 .07456 m
.78571 .07831 L
s
.83333 .07456 m
.83333 .07831 L
s
.88095 .07456 m
.88095 .07831 L
s
.92857 .07456 m
.92857 .07831 L
s
.25 Mabswid
0 .07456 m
1 .07456 L
s
.02381 .15255 m
.03006 .15255 L
s
[(10)] .01131 .15255 1 0 Mshowa
.02381 .23054 m
.03006 .23054 L
s
[(20)] .01131 .23054 1 0 Mshowa
.02381 .30852 m
.03006 .30852 L
s
[(30)] .01131 .30852 1 0 Mshowa
.02381 .38651 m
.03006 .38651 L
s
[(40)] .01131 .38651 1 0 Mshowa
.02381 .4645 m
.03006 .4645 L
s
[(50)] .01131 .4645 1 0 Mshowa
.02381 .54249 m
.03006 .54249 L
s
[(60)] .01131 .54249 1 0 Mshowa
.125 Mabswid
.02381 .01217 m
.02756 .01217 L
s
.02381 .02777 m
.02756 .02777 L
s
.02381 .04337 m
.02756 .04337 L
s
.02381 .05896 m
.02756 .05896 L
s
.02381 .09016 m
.02756 .09016 L
s
.02381 .10576 m
.02756 .10576 L
s
.02381 .12135 m
.02756 .12135 L
s
.02381 .13695 m
.02756 .13695 L
s
.02381 .16815 m
.02756 .16815 L
s
.02381 .18374 m
.02756 .18374 L
s
.02381 .19934 m
.02756 .19934 L
s
.02381 .21494 m
.02756 .21494 L
s
.02381 .24613 m
.02756 .24613 L
s
.02381 .26173 m
.02756 .26173 L
s
.02381 .27733 m
.02756 .27733 L
s
.02381 .29293 m
.02756 .29293 L
s
.02381 .32412 m
.02756 .32412 L
s
.02381 .33972 m
.02756 .33972 L
s
.02381 .35532 m
.02756 .35532 L
s
.02381 .37091 m
.02756 .37091 L
s
.02381 .40211 m
.02756 .40211 L
s
.02381 .41771 m
.02756 .41771 L
s
.02381 .43331 m
.02756 .43331 L
s
.02381 .4489 m
.02756 .4489 L
s
.02381 .4801 m
.02756 .4801 L
s
.02381 .4957 m
.02756 .4957 L
s
.02381 .51129 m
.02756 .51129 L
s
.02381 .52689 m
.02756 .52689 L
s
.02381 .55809 m
.02756 .55809 L
s
.02381 .57368 m
.02756 .57368 L
s
.02381 .58928 m
.02756 .58928 L
s
.02381 .60488 m
.02756 .60488 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .03859 L
.10458 .06463 L
.14415 .08909 L
.18221 .11261 L
.22272 .13765 L
.26171 .16175 L
.30316 .18736 L
.34309 .21204 L
.3815 .23578 L
.42237 .26104 L
.46172 .28536 L
.49955 .30874 L
.53984 .33364 L
.57861 .3576 L
.61984 .38308 L
.65954 .40762 L
.69774 .43123 L
.73838 .45635 L
.77751 .48053 L
.81909 .50623 L
.85916 .53099 L
.89771 .55482 L
.93871 .58016 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell["Here is the fit superimposed on the original data. ", "MathCaption",
  CellTags->{"S3.8.2", "2.7"}],

Cell[CellGroupData[{

Cell["Show[%, gp]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.8.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0.0721264 0.00748158 [
[.2619 .05963 -3 -9 ]
[.2619 .05963 3 0 ]
[.5 .05963 -6 -9 ]
[.5 .05963 6 0 ]
[.7381 .05963 -6 -9 ]
[.7381 .05963 6 0 ]
[.97619 .05963 -6 -9 ]
[.97619 .05963 6 0 ]
[.01131 .22176 -12 -4.5 ]
[.01131 .22176 0 4.5 ]
[.01131 .37139 -12 -4.5 ]
[.01131 .37139 0 4.5 ]
[.01131 .52102 -12 -4.5 ]
[.01131 .52102 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .07213 m
.2619 .07838 L
s
[(5)] .2619 .05963 0 1 Mshowa
.5 .07213 m
.5 .07838 L
s
[(10)] .5 .05963 0 1 Mshowa
.7381 .07213 m
.7381 .07838 L
s
[(15)] .7381 .05963 0 1 Mshowa
.97619 .07213 m
.97619 .07838 L
s
[(20)] .97619 .05963 0 1 Mshowa
.125 Mabswid
.07143 .07213 m
.07143 .07588 L
s
.11905 .07213 m
.11905 .07588 L
s
.16667 .07213 m
.16667 .07588 L
s
.21429 .07213 m
.21429 .07588 L
s
.30952 .07213 m
.30952 .07588 L
s
.35714 .07213 m
.35714 .07588 L
s
.40476 .07213 m
.40476 .07588 L
s
.45238 .07213 m
.45238 .07588 L
s
.54762 .07213 m
.54762 .07588 L
s
.59524 .07213 m
.59524 .07588 L
s
.64286 .07213 m
.64286 .07588 L
s
.69048 .07213 m
.69048 .07588 L
s
.78571 .07213 m
.78571 .07588 L
s
.83333 .07213 m
.83333 .07588 L
s
.88095 .07213 m
.88095 .07588 L
s
.92857 .07213 m
.92857 .07588 L
s
.25 Mabswid
0 .07213 m
1 .07213 L
s
.02381 .22176 m
.03006 .22176 L
s
[(20)] .01131 .22176 1 0 Mshowa
.02381 .37139 m
.03006 .37139 L
s
[(40)] .01131 .37139 1 0 Mshowa
.02381 .52102 m
.03006 .52102 L
s
[(60)] .01131 .52102 1 0 Mshowa
.125 Mabswid
.02381 .10953 m
.02756 .10953 L
s
.02381 .14694 m
.02756 .14694 L
s
.02381 .18435 m
.02756 .18435 L
s
.02381 .25917 m
.02756 .25917 L
s
.02381 .29657 m
.02756 .29657 L
s
.02381 .33398 m
.02756 .33398 L
s
.02381 .4088 m
.02756 .4088 L
s
.02381 .44621 m
.02756 .44621 L
s
.02381 .48361 m
.02756 .48361 L
s
.02381 .03472 m
.02756 .03472 L
s
.02381 .55843 m
.02756 .55843 L
s
.02381 .59584 m
.02756 .59584 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .03762 L
.10458 .0626 L
.14415 .08607 L
.18221 .10863 L
.22272 .13265 L
.26171 .15577 L
.30316 .18034 L
.34309 .20401 L
.3815 .22679 L
.42237 .25102 L
.46172 .27435 L
.49955 .29678 L
.53984 .32067 L
.57861 .34365 L
.61984 .3681 L
.65954 .39164 L
.69774 .41428 L
.73838 .43838 L
.77751 .46158 L
.81909 .48624 L
.85916 .50999 L
.89771 .53285 L
.93871 .55716 L
.97619 .57938 L
s
.008 w
.07143 .08709 Mdot
.11905 .09457 Mdot
.16667 .10953 Mdot
.21429 .1245 Mdot
.2619 .15442 Mdot
.30952 .16939 Mdot
.35714 .19931 Mdot
.40476 .21428 Mdot
.45238 .2442 Mdot
.5 .28909 Mdot
.54762 .30406 Mdot
.59524 .34895 Mdot
.64286 .37887 Mdot
.69048 .39383 Mdot
.7381 .42376 Mdot
.78571 .46865 Mdot
.83333 .51354 Mdot
.88095 .5285 Mdot
.92857 .57339 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell["This gives a quadratic fit to the data. ", "MathCaption",
  CellTags->{"S3.8.2", "2.8"}],

Cell[CellGroupData[{

Cell["Fit[fp, {1, x, x^2}, x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.8.2"],

Cell[BoxData[
    \(\(-1.9236842105262915`\) + 2.2055023923444956`\ x + 
      0.07467532467532469`\ x\^2\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell["Here is a plot of the quadratic fit. ", "MathCaption",
  CellTags->{"S3.8.2", "2.9"}],

Cell[CellGroupData[{

Cell["Plot[%, {x, 0, 20}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.8.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0.0300204 0.00795624 [
[.2619 .01752 -3 -9 ]
[.2619 .01752 3 0 ]
[.5 .01752 -6 -9 ]
[.5 .01752 6 0 ]
[.7381 .01752 -6 -9 ]
[.7381 .01752 6 0 ]
[.97619 .01752 -6 -9 ]
[.97619 .01752 6 0 ]
[.01131 .10958 -12 -4.5 ]
[.01131 .10958 0 4.5 ]
[.01131 .18915 -12 -4.5 ]
[.01131 .18915 0 4.5 ]
[.01131 .26871 -12 -4.5 ]
[.01131 .26871 0 4.5 ]
[.01131 .34827 -12 -4.5 ]
[.01131 .34827 0 4.5 ]
[.01131 .42783 -12 -4.5 ]
[.01131 .42783 0 4.5 ]
[.01131 .50739 -12 -4.5 ]
[.01131 .50739 0 4.5 ]
[.01131 .58696 -12 -4.5 ]
[.01131 .58696 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .03002 m
.2619 .03627 L
s
[(5)] .2619 .01752 0 1 Mshowa
.5 .03002 m
.5 .03627 L
s
[(10)] .5 .01752 0 1 Mshowa
.7381 .03002 m
.7381 .03627 L
s
[(15)] .7381 .01752 0 1 Mshowa
.97619 .03002 m
.97619 .03627 L
s
[(20)] .97619 .01752 0 1 Mshowa
.125 Mabswid
.07143 .03002 m
.07143 .03377 L
s
.11905 .03002 m
.11905 .03377 L
s
.16667 .03002 m
.16667 .03377 L
s
.21429 .03002 m
.21429 .03377 L
s
.30952 .03002 m
.30952 .03377 L
s
.35714 .03002 m
.35714 .03377 L
s
.40476 .03002 m
.40476 .03377 L
s
.45238 .03002 m
.45238 .03377 L
s
.54762 .03002 m
.54762 .03377 L
s
.59524 .03002 m
.59524 .03377 L
s
.64286 .03002 m
.64286 .03377 L
s
.69048 .03002 m
.69048 .03377 L
s
.78571 .03002 m
.78571 .03377 L
s
.83333 .03002 m
.83333 .03377 L
s
.88095 .03002 m
.88095 .03377 L
s
.92857 .03002 m
.92857 .03377 L
s
.25 Mabswid
0 .03002 m
1 .03002 L
s
.02381 .10958 m
.03006 .10958 L
s
[(10)] .01131 .10958 1 0 Mshowa
.02381 .18915 m
.03006 .18915 L
s
[(20)] .01131 .18915 1 0 Mshowa
.02381 .26871 m
.03006 .26871 L
s
[(30)] .01131 .26871 1 0 Mshowa
.02381 .34827 m
.03006 .34827 L
s
[(40)] .01131 .34827 1 0 Mshowa
.02381 .42783 m
.03006 .42783 L
s
[(50)] .01131 .42783 1 0 Mshowa
.02381 .50739 m
.03006 .50739 L
s
[(60)] .01131 .50739 1 0 Mshowa
.02381 .58696 m
.03006 .58696 L
s
[(70)] .01131 .58696 1 0 Mshowa
.125 Mabswid
.02381 .04593 m
.02756 .04593 L
s
.02381 .06185 m
.02756 .06185 L
s
.02381 .07776 m
.02756 .07776 L
s
.02381 .09367 m
.02756 .09367 L
s
.02381 .1255 m
.02756 .1255 L
s
.02381 .14141 m
.02756 .14141 L
s
.02381 .15732 m
.02756 .15732 L
s
.02381 .17323 m
.02756 .17323 L
s
.02381 .20506 m
.02756 .20506 L
s
.02381 .22097 m
.02756 .22097 L
s
.02381 .23688 m
.02756 .23688 L
s
.02381 .2528 m
.02756 .2528 L
s
.02381 .28462 m
.02756 .28462 L
s
.02381 .30053 m
.02756 .30053 L
s
.02381 .31644 m
.02756 .31644 L
s
.02381 .33236 m
.02756 .33236 L
s
.02381 .36418 m
.02756 .36418 L
s
.02381 .38009 m
.02756 .38009 L
s
.02381 .39601 m
.02756 .39601 L
s
.02381 .41192 m
.02756 .41192 L
s
.02381 .44374 m
.02756 .44374 L
s
.02381 .45966 m
.02756 .45966 L
s
.02381 .47557 m
.02756 .47557 L
s
.02381 .49148 m
.02756 .49148 L
s
.02381 .52331 m
.02756 .52331 L
s
.02381 .53922 m
.02756 .53922 L
s
.02381 .55513 m
.02756 .55513 L
s
.02381 .57104 m
.02756 .57104 L
s
.02381 .01411 m
.02756 .01411 L
s
.02381 .60287 m
.02756 .60287 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .02934 L
.10458 .04619 L
.14415 .06286 L
.18221 .07966 L
.22272 .09838 L
.26171 .11721 L
.30316 .1381 L
.34309 .15908 L
.3815 .18005 L
.42237 .2032 L
.46172 .22633 L
.49955 .24933 L
.53984 .27464 L
.57861 .29981 L
.61984 .32743 L
.65954 .35488 L
.69774 .38206 L
.73838 .41182 L
.77751 .44129 L
.81909 .47349 L
.85916 .50538 L
.89771 .53685 L
.93871 .57117 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell["\<\
This shows the fit superimposed on the original data. The quadratic \
fit is better than the linear one. \
\>", "MathCaption",
  CellTags->{"S3.8.2", "2.10"}],

Cell[CellGroupData[{

Cell["Show[%, gp]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.8.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0.0300204 0.00795624 [
[.2619 .01752 -3 -9 ]
[.2619 .01752 3 0 ]
[.5 .01752 -6 -9 ]
[.5 .01752 6 0 ]
[.7381 .01752 -6 -9 ]
[.7381 .01752 6 0 ]
[.97619 .01752 -6 -9 ]
[.97619 .01752 6 0 ]
[.01131 .10958 -12 -4.5 ]
[.01131 .10958 0 4.5 ]
[.01131 .18915 -12 -4.5 ]
[.01131 .18915 0 4.5 ]
[.01131 .26871 -12 -4.5 ]
[.01131 .26871 0 4.5 ]
[.01131 .34827 -12 -4.5 ]
[.01131 .34827 0 4.5 ]
[.01131 .42783 -12 -4.5 ]
[.01131 .42783 0 4.5 ]
[.01131 .50739 -12 -4.5 ]
[.01131 .50739 0 4.5 ]
[.01131 .58696 -12 -4.5 ]
[.01131 .58696 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .03002 m
.2619 .03627 L
s
[(5)] .2619 .01752 0 1 Mshowa
.5 .03002 m
.5 .03627 L
s
[(10)] .5 .01752 0 1 Mshowa
.7381 .03002 m
.7381 .03627 L
s
[(15)] .7381 .01752 0 1 Mshowa
.97619 .03002 m
.97619 .03627 L
s
[(20)] .97619 .01752 0 1 Mshowa
.125 Mabswid
.07143 .03002 m
.07143 .03377 L
s
.11905 .03002 m
.11905 .03377 L
s
.16667 .03002 m
.16667 .03377 L
s
.21429 .03002 m
.21429 .03377 L
s
.30952 .03002 m
.30952 .03377 L
s
.35714 .03002 m
.35714 .03377 L
s
.40476 .03002 m
.40476 .03377 L
s
.45238 .03002 m
.45238 .03377 L
s
.54762 .03002 m
.54762 .03377 L
s
.59524 .03002 m
.59524 .03377 L
s
.64286 .03002 m
.64286 .03377 L
s
.69048 .03002 m
.69048 .03377 L
s
.78571 .03002 m
.78571 .03377 L
s
.83333 .03002 m
.83333 .03377 L
s
.88095 .03002 m
.88095 .03377 L
s
.92857 .03002 m
.92857 .03377 L
s
.25 Mabswid
0 .03002 m
1 .03002 L
s
.02381 .10958 m
.03006 .10958 L
s
[(10)] .01131 .10958 1 0 Mshowa
.02381 .18915 m
.03006 .18915 L
s
[(20)] .01131 .18915 1 0 Mshowa
.02381 .26871 m
.03006 .26871 L
s
[(30)] .01131 .26871 1 0 Mshowa
.02381 .34827 m
.03006 .34827 L
s
[(40)] .01131 .34827 1 0 Mshowa
.02381 .42783 m
.03006 .42783 L
s
[(50)] .01131 .42783 1 0 Mshowa
.02381 .50739 m
.03006 .50739 L
s
[(60)] .01131 .50739 1 0 Mshowa
.02381 .58696 m
.03006 .58696 L
s
[(70)] .01131 .58696 1 0 Mshowa
.125 Mabswid
.02381 .04593 m
.02756 .04593 L
s
.02381 .06185 m
.02756 .06185 L
s
.02381 .07776 m
.02756 .07776 L
s
.02381 .09367 m
.02756 .09367 L
s
.02381 .1255 m
.02756 .1255 L
s
.02381 .14141 m
.02756 .14141 L
s
.02381 .15732 m
.02756 .15732 L
s
.02381 .17323 m
.02756 .17323 L
s
.02381 .20506 m
.02756 .20506 L
s
.02381 .22097 m
.02756 .22097 L
s
.02381 .23688 m
.02756 .23688 L
s
.02381 .2528 m
.02756 .2528 L
s
.02381 .28462 m
.02756 .28462 L
s
.02381 .30053 m
.02756 .30053 L
s
.02381 .31644 m
.02756 .31644 L
s
.02381 .33236 m
.02756 .33236 L
s
.02381 .36418 m
.02756 .36418 L
s
.02381 .38009 m
.02756 .38009 L
s
.02381 .39601 m
.02756 .39601 L
s
.02381 .41192 m
.02756 .41192 L
s
.02381 .44374 m
.02756 .44374 L
s
.02381 .45966 m
.02756 .45966 L
s
.02381 .47557 m
.02756 .47557 L
s
.02381 .49148 m
.02756 .49148 L
s
.02381 .52331 m
.02756 .52331 L
s
.02381 .53922 m
.02756 .53922 L
s
.02381 .55513 m
.02756 .55513 L
s
.02381 .57104 m
.02756 .57104 L
s
.02381 .01411 m
.02756 .01411 L
s
.02381 .60287 m
.02756 .60287 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .02934 L
.10458 .04619 L
.14415 .06286 L
.18221 .07966 L
.22272 .09838 L
.26171 .11721 L
.30316 .1381 L
.34309 .15908 L
.3815 .18005 L
.42237 .2032 L
.46172 .22633 L
.49955 .24933 L
.53984 .27464 L
.57861 .29981 L
.61984 .32743 L
.65954 .35488 L
.69774 .38206 L
.73838 .41182 L
.77751 .44129 L
.81909 .47349 L
.85916 .50538 L
.89771 .53685 L
.93871 .57117 L
.97619 .60332 L
s
.008 w
.07143 .04593 Mdot
.11905 .05389 Mdot
.16667 .0698 Mdot
.21429 .08571 Mdot
.2619 .11754 Mdot
.30952 .13345 Mdot
.35714 .16528 Mdot
.40476 .18119 Mdot
.45238 .21301 Mdot
.5 .26075 Mdot
.54762 .27666 Mdot
.59524 .3244 Mdot
.64286 .35623 Mdot
.69048 .37214 Mdot
.7381 .40396 Mdot
.78571 .4517 Mdot
.83333 .49944 Mdot
.88095 .51535 Mdot
.92857 .56309 Mdot
.97619 .59491 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              
              "data points obtained when a single coordinate takes on values \
",
              StyleBox["1", "MR"],
              ", ",
              StyleBox["2", "MR"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              
              "data points obtained when a single coordinate takes on values \
",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "}, {",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] , ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "}, \[Ellipsis] }",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "data points obtained with values ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " of a sequence of coordinates "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.2"],

Cell["Ways of specifying data. ", "Caption",
  CellTags->"S3.8.2"],

Cell[TextData[{
  "If you give data in the form ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  " then ",
  StyleBox["Fit", "MR"],
  " will assume that the successive ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " correspond to values of a function at successive integer points ",
  StyleBox["1", "MR"],
  ", ",
  StyleBox["2", "MR"],
  ", \[Ellipsis]",
  " ",
  ". But you can also give ",
  StyleBox["Fit", "MR"],
  " data that corresponds to the values of a function at arbitrary points, in \
one or more dimensions. "
}], "Text",
  CellTags->{"S3.8.2", "2.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Fit[", "MR"],
              StyleBox["data", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["fun",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["fun",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["fit to a function of several variables "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.2"],

Cell["Multivariate fits. ", "Caption",
  CellTags->"S3.8.2"],

Cell[TextData[{
  "This gives a table of the values of ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "+", "5", 
          StyleBox["x",
            "TI"], "-", 
          StyleBox["x",
            "TI"], 
          StyleBox["y",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". You need to use ",
  StyleBox["Flatten", "MR"],
  " to get it in the right form for ",
  StyleBox["Fit", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.8.2", "2.12"}],

Cell[CellGroupData[{

Cell["\<\
Flatten[ Table[ {x, y, 1 + 5x - x y}, {x, 0, 1, 0.4}, {y, 0, 1, \
0.4} ], 1]\
\>", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.8.2"],

Cell[BoxData[
    \({{0, 0, 1}, {0, 0.4`, 1}, {0, 0.8`, 1}, {0.4`, 0, 3.`}, {0.4`, 0.4`, 
        2.84`}, {0.4`, 0.8`, 2.6799999999999997`}, {0.8`, 0, 5.`}, {0.8`, 
        0.4`, 4.68`}, {0.8`, 0.8`, 4.359999999999999`}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell["This produces a fit to a function of two variables. ", "MathCaption",
  CellTags->{"S3.8.2", "2.13"}],

Cell[CellGroupData[{

Cell["Fit[ % , {1, x, y, x y}, {x, y} ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.8.2"],

Cell[BoxData[
    \(\(\(0.9999999999999982`\)\(\[InvisibleSpace]\)\) + 
      5.000000000000001`\ x + 2.824662538669222`*^-15\ y - 
      0.9999999999999993`\ x\ y\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Fit", "MR"],
  " takes a list of functions, and uses a definite and efficient procedure to \
find what linear combination of these functions gives the best \
least\[Hyphen]squares fit to your data. Sometimes, however, you may want to \
find a ",
  StyleBox["nonlinear fit", "TI"],
  " that does not just consist of a linear combination of specified \
functions. You can do this using ",
  StyleBox["FindFit", "MR"],
  ", which takes a function of any form, and then searches for values of \
parameters that yield the best fit to your data. "
}], "Text",
  CellTags->{"S3.8.2", "2.14"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FindFit[", "MR"],
              StyleBox["data", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["par",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["par",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "search for values of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["par",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " that make ",
              StyleBox["form", "TI"],
              " best fit ",
              StyleBox["data", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FindFit[", "MR"],
              StyleBox["data", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["pars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["fit multivariate data "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.2"],

Cell["Searching for general fits to data. ", "Caption",
  CellTags->"S3.8.2"],

Cell["\<\
This fits the list of primes to a simple linear combination of \
terms. \
\>", "MathCaption",
  CellTags->{"S3.8.2", "2.15"}],

Cell[CellGroupData[{

Cell["FindFit[fp, a + b x + c Exp[x], {a, b, c}, x]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.8.2"],

Cell[BoxData[
    \({a \[Rule] \(-6.7893206840832505`\), b \[Rule] 3.6430852178833164`, 
      c \[Rule] 1.2688291461510159`*^-8}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell[TextData[{
  "The result is the same as from ",
  StyleBox["Fit", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.8.2", "2.16"}],

Cell[CellGroupData[{

Cell["Fit[fp, {1, x, Exp[x]}, x]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.8.2"],

Cell[BoxData[
    \(\(-6.7893206840832505`\) + 
      1.2688291461510159`*^-8\ \[ExponentialE]\^x + 
      3.6430852178833164`\ x\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell[TextData[{
  "This fits to a nonlinear form, which cannot be handled by ",
  StyleBox["Fit", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.8.2", "2.17"}],

Cell[CellGroupData[{

Cell["FindFit[fp, a x Log[b + c x], {a, b, c}, x]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.8.2"],

Cell[BoxData[
    \({a \[Rule] 1.4207557265820911`, b \[Rule] 1.655581383688411`, 
      c \[Rule] 0.5346453091971497`}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell[TextData[{
  "By default, both ",
  StyleBox["Fit", "MR"],
  " and ",
  StyleBox["FindFit", "MR"],
  " produce ",
  StyleBox["least\[Hyphen]squares", "TI"],
  " fits, which are defined to minimize the quantity ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Chi]\^2\), "=", 
          UnderscriptBox["\[Sum]", 
            StyleBox["i",
              "TI"],
            LimitsPositioning->True], "\[VerticalSeparator]", 
          SubscriptBox[
            StyleBox["r",
              "TI"], 
            StyleBox["i",
              "TI"]], \( \[VerticalSeparator] \^2\)}], TraditionalForm]], 
    "InlineFormula"],
  ", where the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " are residuals giving the difference between each original data point and \
its fitted value. One can, however, also consider fits based on other norms. \
If you set the option ",
  StyleBox["NormFunction", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["u", "TI"],
  ", then ",
  StyleBox["FindFit", "MR"],
  " will attempt to find the fit that minimizes the quantity ",
  StyleBox["u", "TI"],
  StyleBox["[", "MR"],
  StyleBox["r", "TI"],
  StyleBox["]", "MR"],
  ", where ",
  StyleBox["r", "TI"],
  " is the list of residuals. The default is ",
  StyleBox["NormFunction", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Norm", "MR"],
  ", corresponding to a least\[Hyphen]squares fit.  "
}], "Text",
  CellTags->{"S3.8.2", "2.18"}],

Cell[TextData[{
  "This uses the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  "\[Hyphen]norm, which minimizes the maximum distance between the fit and \
the data. The result is slightly different from least\[Hyphen]squares. "
}], "MathCaption",
  CellTags->{"S3.8.2", "2.19"}],

Cell[CellGroupData[{

Cell["\<\
FindFit[fp, a x Log[b + c x], {a, b, c}, x, NormFunction -> \
(Norm[#, Infinity] &)]\
\>", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.8.2"],

Cell[BoxData[
    \({a \[Rule] 1.1507695890710887`, b \[Rule] 1.0022987426644`, 
      c \[Rule] 1.0468558066626197`}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FindFit", "MR"],
  " works by searching for values of parameters that yield the best fit. \
Sometimes you may have to tell it where to start in doing this search. You \
can do this by giving parameters in the form ",
  StyleBox["{{", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["b", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  ". ",
  StyleBox["FindFit", "MR"],
  " also has various options that you can set to control how it does its \
search. "
}], "Text",
  CellTags->{"S3.8.2", "2.20"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["NormFunction", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Norm", "MR"],
              " "
            }]], Cell["the norm to use "]},
          {Cell[TextData[{
              StyleBox["AccuracyGoal", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["number of digits of accuracy to try to get "]},
          {Cell[TextData[{
              StyleBox["PrecisionGoal", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["number of digits of precision to try to get "]},
          {Cell[TextData[{
              StyleBox["WorkingPrecision", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["precision to use in internal computations "]},
          {Cell[TextData[{
              StyleBox["MaxIterations", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["100", "MR"],
              " "
            }]], Cell["maximum number of iterations to use "]},
          {Cell[TextData[{
              StyleBox["StepMonitor", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell["expression to evaluate whenever a step is taken "]},
          {Cell[TextData[{
              StyleBox["EvaluationMonitor", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell[TextData[{
              "expression to evaluate whenever ",
              StyleBox["form", "TI"],
              " is evaluated "
            }]]},
          {Cell[TextData[{
              StyleBox["Method", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["method to use "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S3.8.2"],

Cell[TextData[{
  "Options for ",
  StyleBox["FindFit", "MR"],
  ". "
}], "Caption",
  CellTags->"S3.8.2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.8.3 Approximate Functions and Interpolation", "Subsection",
  CellTags->{"S3.8.3", "3.1"}],

Cell[TextData[{
  "In many kinds of numerical computations, it is convenient to introduce ",
  StyleBox["approximate functions", "TI"],
  ". Approximate functions can be thought of as generalizations of ordinary \
approximate real numbers. While an approximate real number gives the value to \
a certain precision of a single numerical quantity, an approximate function \
gives the value to a certain precision of a quantity which depends on one or \
more parameters. ",
  StyleBox["Mathematica", "TI"],
  " uses approximate functions, for example, to represent numerical solutions \
to differential equations obtained with ",
  StyleBox["NDSolve", "MR"],
  ", as discussed in Section ",
  ButtonBox["1.6.4",
    ButtonData:>{"1.6.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S3.8.3", "3.2"}],

Cell[TextData[{
  "Approximate functions in ",
  StyleBox["Mathematica", "TI"],
  " are represented by ",
  StyleBox["InterpolatingFunction", "MR"],
  " objects. These objects work like the pure functions discussed in Section \
",
  ButtonBox["2.2.5",
    ButtonData:>{"2.2.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  ". The basic idea is that when given a particular argument, an ",
  StyleBox["InterpolatingFunction", "MR"],
  " object finds the approximate function value that corresponds to that \
argument. "
}], "Text",
  CellTags->{"S3.8.3", "3.3"}],

Cell[TextData[{
  "The ",
  StyleBox["InterpolatingFunction", "MR"],
  " object contains a representation of the approximate function based on \
interpolation. Typically it contains values and possibly derivatives at a \
sequence of points. It effectively assumes that the function varies smoothly \
between these points. As a result, when you ask for the value of the function \
with a particular argument, the ",
  StyleBox["InterpolatingFunction", "MR"],
  " object can interpolate to find an approximation to the value you want. "
}], "Text",
  CellTags->{"S3.8.3", "3.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Interpolation[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "construct an approximate function with values ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " at successive integers "
            }]]},
          {Cell[TextData[{
              StyleBox["Interpolation[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "construct an approximate function with values ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " at points ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.3"],

Cell["Constructing approximate functions. ", "Caption",
  CellTags->"S3.8.3"],

Cell["Here is a table of the values of the sine function. ", "MathCaption",
  CellTags->{"S3.8.3", "3.5"}],

Cell[CellGroupData[{

Cell["Table[{x, Sin[x]}, {x, 0, 2, 0.25}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \({{0, 0}, {0.25`, 0.24740395925452294`}, {0.5`, 
        0.479425538604203`}, {0.75`, 0.6816387600233341`}, {1.`, 
        0.8414709848078965`}, {1.25`, 0.9489846193555862`}, {1.5`, 
        0.9974949866040544`}, {1.75`, 0.9839859468739369`}, {2.`, 
        0.9092974268256817`}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell["\<\
This constructs an approximate function which represents these \
values. \
\>", "MathCaption",
  CellTags->{"S3.8.3", "3.6"}],

Cell[CellGroupData[{

Cell["sin = Interpolation[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{0.`, 2.`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell["\<\
The approximate function reproduces each of the values in the \
original table. \
\>", "MathCaption",
  CellTags->{"S3.8.3", "3.7"}],

Cell[CellGroupData[{

Cell["sin[0.25]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \(0.24740395925452294`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell["\<\
It also allows you to get approximate values at other points. \
\
\>", "MathCaption",
  CellTags->{"S3.8.3", "3.8"}],

Cell[CellGroupData[{

Cell["sin[0.3]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \(0.29550049681366897`\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell["\<\
In this case the interpolation is a fairly good approximation to \
the true sine function. \
\>", "MathCaption",
  CellTags->{"S3.8.3", "3.9"}],

Cell[CellGroupData[{

Cell["Sin[0.3]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \(0.29552020666133955`\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[TextData[{
  "You can work with approximate functions much as you would with any other \
",
  StyleBox["Mathematica", "TI"],
  " functions. You can plot approximate functions, or perform numerical \
operations such as integration or root finding. "
}], "Text",
  CellTags->{"S3.8.3", "3.10"}],

Cell["\<\
If you give a non\[Hyphen]numerical argument, the approximate \
function is left in symbolic form. \
\>", "MathCaption",
  CellTags->{"S3.8.3", "3.11"}],

Cell[CellGroupData[{

Cell["sin[x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    RowBox[{
      TagBox[\(InterpolatingFunction[{{0.`, 2.`}}, "<>"]\),
        False,
        Editable->False], "[", "x", "]"}]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell["Here is a numerical integral of the approximate function. ", \
"MathCaption",
  CellTags->{"S3.8.3", "3.12"}],

Cell[CellGroupData[{

Cell["NIntegrate[sin[x]^2, {x, 0, Pi/2}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \(0.7853098690742231`\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell["\<\
Here is the same numerical integral for the true sine function. \
\
\>", "MathCaption",
  CellTags->{"S3.8.3", "3.13"}],

Cell[CellGroupData[{

Cell["NIntegrate[Sin[x]^2, {x, 0, Pi/2}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \(0.7853981633974483`\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell["\<\
A plot of the approximate function is essentially indistinguishable \
from the true sine function. \
\>", "MathCaption",
  CellTags->{"S3.8.3", "3.14"}],

Cell[CellGroupData[{

Cell["Plot[sin[x], {x, 0, 2}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.8.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.588646 [
[.2619 .00222 -9 -9 ]
[.2619 .00222 9 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.7381 .00222 -9 -9 ]
[.7381 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .13244 -18 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25017 -18 -4.5 ]
[.01131 .25017 0 4.5 ]
[.01131 .3679 -18 -4.5 ]
[.01131 .3679 0 4.5 ]
[.01131 .48563 -18 -4.5 ]
[.01131 .48563 0 4.5 ]
[.01131 .60336 -6 -4.5 ]
[.01131 .60336 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(0.5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(1.5)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13244 m
.03006 .13244 L
s
[(0.2)] .01131 .13244 1 0 Mshowa
.02381 .25017 m
.03006 .25017 L
s
[(0.4)] .01131 .25017 1 0 Mshowa
.02381 .3679 m
.03006 .3679 L
s
[(0.6)] .01131 .3679 1 0 Mshowa
.02381 .48563 m
.03006 .48563 L
s
[(0.8)] .01131 .48563 1 0 Mshowa
.02381 .60336 m
.03006 .60336 L
s
[(1)] .01131 .60336 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .16188 m
.02756 .16188 L
s
.02381 .19131 m
.02756 .19131 L
s
.02381 .22074 m
.02756 .22074 L
s
.02381 .27961 m
.02756 .27961 L
s
.02381 .30904 m
.02756 .30904 L
s
.02381 .33847 m
.02756 .33847 L
s
.02381 .39734 m
.02756 .39734 L
s
.02381 .42677 m
.02756 .42677 L
s
.02381 .4562 m
.02756 .4562 L
s
.02381 .51506 m
.02756 .51506 L
s
.02381 .5445 m
.02756 .5445 L
s
.02381 .57393 m
.02756 .57393 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .06245 L
.10458 .1141 L
.14415 .1619 L
.18221 .20691 L
.22272 .25349 L
.26171 .29672 L
.30316 .34054 L
.34309 .38045 L
.3815 .41645 L
.42237 .45182 L
.46172 .48287 L
.49955 .50974 L
.53984 .53485 L
.57861 .55553 L
.61984 .57364 L
.65954 .58703 L
.67958 .5923 L
.69774 .59621 L
.71741 .5995 L
.72821 .60088 L
.73838 .60191 L
.74815 .60262 L
.75306 .60288 L
.75589 .60301 L
.75846 .6031 L
.76067 .60317 L
.76307 .60323 L
.76439 .60325 L
.76561 .60327 L
.76685 .60329 L
.76801 .6033 L
.769 .60331 L
.77007 .60332 L
.77125 .60332 L
.77234 .60332 L
.77341 .60331 L
.77458 .60331 L
.7758 .6033 L
.77693 .60328 L
.77956 .60324 L
.78198 .60318 L
.78464 .6031 L
.78746 .60299 L
.79219 .60277 L
.79739 .60246 L
.80699 .6017 L
.81598 .60078 L
.83627 .59795 L
.8548 .59444 L
Mistroke
.89456 .58397 L
.93281 .57013 L
.97351 .55135 L
.97619 .54997 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[TextData[{
  "If you differentiate an approximate function, ",
  StyleBox["Mathematica", "TI"],
  " will return another approximate function that represents the derivative. \
"
}], "Text",
  CellTags->{"S3.8.3", "3.15"}],

Cell[TextData[{
  "This finds the derivative of the approximate sine function, and evaluates \
it at ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]/6\)], "InlineFormula"],
  ".  "
}], "MathCaption",
  CellTags->{"S3.8.3", "3.16"}],

Cell[CellGroupData[{

Cell["sin'[Pi/6]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \(0.8653722533086783`\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell["The result is close to the exact one. ", "MathCaption",
  CellTags->{"S3.8.3", "3.17"}],

Cell[CellGroupData[{

Cell["N[Cos[Pi/6]]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \(0.8660254037844386`\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["InterpolatingFunction", "MR"],
  " objects contain all the information ",
  StyleBox["Mathematica", "TI"],
  " needs about approximate functions. In standard ",
  StyleBox["Mathematica", "TI"],
  " output format, however, only the part that gives the domain of the ",
  StyleBox["InterpolatingFunction", "MR"],
  " object is printed explicitly. The lists of actual parameters used in the \
",
  StyleBox["InterpolatingFunction", "MR"],
  " object are shown only in iconic form. "
}], "Text",
  CellTags->{"S3.8.3", "3.18"}],

Cell[TextData[{
  "In standard output format, the only part of an ",
  StyleBox["InterpolatingFunction", "MR"],
  " object printed explicitly is its domain. "
}], "MathCaption",
  CellTags->{"S3.8.3", "3.19"}],

Cell[CellGroupData[{

Cell["sin", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{0.`, 2.`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[TextData[{
  "If you ask for a value outside of the domain, ",
  StyleBox["Mathematica", "TI"],
  " prints a warning, then uses extrapolation to find a result.  "
}], "MathCaption",
  CellTags->{"S3.8.3", "3.20"}],

Cell[CellGroupData[{

Cell["sin[3]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \(InterpolatingFunction::"dmval" \(\(:\)\(\ \)\) 
      "Input value \!\({3}\) lies outside the range of data in the \
interpolating function. Extrapolation will be used."\)], "Message",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \(0.015547076660245462`\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[TextData[{
  "The more information you give about the function you are trying to \
approximate, the better the approximation ",
  StyleBox["Mathematica", "TI"],
  " constructs can be. You can, for example, specify not only values of the \
function at a sequence of points, but also derivatives. "
}], "Text",
  CellTags->{"S3.8.3", "3.21"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Interpolation[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["df",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["ddf",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "construct an approximate function with specified derivatives \
at points ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.3"],

Cell["\<\
Constructing approximate functions with specified derivatives. \
\
\>", "Caption",
  CellTags->"S3.8.3"],

Cell[TextData[{
  StyleBox["Interpolation", "MR"],
  " works by fitting polynomial curves between the points you specify. You \
can use the option ",
  StyleBox["InterpolationOrder", "MR"],
  " to specify the degree of these polynomial curves. The default setting is \
",
  StyleBox["InterpolationOrder", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["3", "MR"],
  ", yielding cubic curves. "
}], "Text",
  CellTags->{"S3.8.3", "3.22"}],

Cell["This makes a table of values of the cosine function. ", "MathCaption",
  CellTags->{"S3.8.3", "3.23"}],

Cell["tab = Table[{x, Cos[x]}, {x, 0, 6}] ;", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.8.3"],

Cell["\<\
This creates an approximate function using linear interpolation \
between the values in the table. \
\>", "MathCaption",
  CellTags->{"S3.8.3", "3.24"}],

Cell[CellGroupData[{

Cell["Interpolation[tab, InterpolationOrder -> 1]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{0, 6}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell["\<\
The approximate function consists of a collection of straight\
\[Hyphen]line segments. \
\>", "MathCaption",
  CellTags->{"S3.8.3", "3.25"}],

Cell[CellGroupData[{

Cell["Plot[%[x], {x, 0, 6}]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.8.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.15873 0.307496 0.295823 [
[.18254 .295 -3 -9 ]
[.18254 .295 3 0 ]
[.34127 .295 -3 -9 ]
[.34127 .295 3 0 ]
[.5 .295 -3 -9 ]
[.5 .295 3 0 ]
[.65873 .295 -3 -9 ]
[.65873 .295 3 0 ]
[.81746 .295 -3 -9 ]
[.81746 .295 3 0 ]
[.97619 .295 -3 -9 ]
[.97619 .295 3 0 ]
[.01131 .01167 -12 -4.5 ]
[.01131 .01167 0 4.5 ]
[.01131 .15958 -24 -4.5 ]
[.01131 .15958 0 4.5 ]
[.01131 .45541 -18 -4.5 ]
[.01131 .45541 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .3075 m
.18254 .31375 L
s
[(1)] .18254 .295 0 1 Mshowa
.34127 .3075 m
.34127 .31375 L
s
[(2)] .34127 .295 0 1 Mshowa
.5 .3075 m
.5 .31375 L
s
[(3)] .5 .295 0 1 Mshowa
.65873 .3075 m
.65873 .31375 L
s
[(4)] .65873 .295 0 1 Mshowa
.81746 .3075 m
.81746 .31375 L
s
[(5)] .81746 .295 0 1 Mshowa
.97619 .3075 m
.97619 .31375 L
s
[(6)] .97619 .295 0 1 Mshowa
.125 Mabswid
.05556 .3075 m
.05556 .31125 L
s
.0873 .3075 m
.0873 .31125 L
s
.11905 .3075 m
.11905 .31125 L
s
.15079 .3075 m
.15079 .31125 L
s
.21429 .3075 m
.21429 .31125 L
s
.24603 .3075 m
.24603 .31125 L
s
.27778 .3075 m
.27778 .31125 L
s
.30952 .3075 m
.30952 .31125 L
s
.37302 .3075 m
.37302 .31125 L
s
.40476 .3075 m
.40476 .31125 L
s
.43651 .3075 m
.43651 .31125 L
s
.46825 .3075 m
.46825 .31125 L
s
.53175 .3075 m
.53175 .31125 L
s
.56349 .3075 m
.56349 .31125 L
s
.59524 .3075 m
.59524 .31125 L
s
.62698 .3075 m
.62698 .31125 L
s
.69048 .3075 m
.69048 .31125 L
s
.72222 .3075 m
.72222 .31125 L
s
.75397 .3075 m
.75397 .31125 L
s
.78571 .3075 m
.78571 .31125 L
s
.84921 .3075 m
.84921 .31125 L
s
.88095 .3075 m
.88095 .31125 L
s
.9127 .3075 m
.9127 .31125 L
s
.94444 .3075 m
.94444 .31125 L
s
.25 Mabswid
0 .3075 m
1 .3075 L
s
.02381 .01167 m
.03006 .01167 L
s
[(-1)] .01131 .01167 1 0 Mshowa
.02381 .15958 m
.03006 .15958 L
s
[(-0.5)] .01131 .15958 1 0 Mshowa
.02381 .45541 m
.03006 .45541 L
s
[(0.5)] .01131 .45541 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04126 m
.02756 .04126 L
s
.02381 .07084 m
.02756 .07084 L
s
.02381 .10042 m
.02756 .10042 L
s
.02381 .13 m
.02756 .13 L
s
.02381 .18917 m
.02756 .18917 L
s
.02381 .21875 m
.02756 .21875 L
s
.02381 .24833 m
.02756 .24833 L
s
.02381 .27791 m
.02756 .27791 L
s
.02381 .33708 m
.02756 .33708 L
s
.02381 .36666 m
.02756 .36666 L
s
.02381 .39624 m
.02756 .39624 L
s
.02381 .42583 m
.02756 .42583 L
s
.02381 .48499 m
.02756 .48499 L
s
.02381 .51457 m
.02756 .51457 L
s
.02381 .54415 m
.02756 .54415 L
s
.02381 .57374 m
.02756 .57374 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .57022 L
.10458 .53412 L
.14415 .50022 L
.16408 .48315 L
.17277 .4757 L
.17735 .47177 L
.17986 .46963 L
.18109 .46858 L
.18221 .46761 L
.18341 .46578 L
.1847 .46348 L
.18744 .4586 L
.19227 .44999 L
.20178 .43303 L
.22272 .39571 L
.26243 .32493 L
.30062 .25685 L
.32194 .21885 L
.332 .20091 L
.33642 .19304 L
.33892 .18857 L
.34015 .18639 L
.34126 .1844 L
.34243 .18315 L
.34354 .18197 L
.34597 .17936 L
.35094 .17405 L
.36141 .16285 L
.38039 .14255 L
.41872 .10156 L
.45951 .05794 L
.47976 .03628 L
.48968 .02567 L
.49402 .02103 L
.49632 .01857 L
.49758 .01722 L
.49877 .01595 L
.49992 .01472 L
.50117 .01537 L
.50336 .01674 L
.50762 .01941 L
.51694 .02525 L
.53652 .03753 L
.57744 .06318 L
.61684 .08788 L
.63664 .10029 L
.6453 .10571 L
.65473 .11163 L
.65724 .1132 L
Mistroke
.65796 .11365 L
.65864 .11408 L
.65991 .11619 L
.66471 .12458 L
.67418 .14112 L
.69507 .17762 L
.73367 .24505 L
.77473 .31677 L
.81427 .38584 L
.85229 .43533 L
.89277 .48636 L
.93173 .53548 L
.97314 .58769 L
.97619 .59154 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[TextData[{
  "With the default setting ",
  StyleBox["InterpolationOrder", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["3", "MR"],
  ", cubic curves are used, and the function looks smooth. "
}], "MathCaption",
  CellTags->{"S3.8.3", "3.26"}],

Cell[CellGroupData[{

Cell["Plot[Evaluate[Interpolation[tab]][x], {x, 0, 6}]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.8.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.15873 0.307547 0.295047 [
[.18254 .29505 -3 -9 ]
[.18254 .29505 3 0 ]
[.34127 .29505 -3 -9 ]
[.34127 .29505 3 0 ]
[.5 .29505 -3 -9 ]
[.5 .29505 3 0 ]
[.65873 .29505 -3 -9 ]
[.65873 .29505 3 0 ]
[.81746 .29505 -3 -9 ]
[.81746 .29505 3 0 ]
[.97619 .29505 -3 -9 ]
[.97619 .29505 3 0 ]
[.01131 .0125 -12 -4.5 ]
[.01131 .0125 0 4.5 ]
[.01131 .16002 -24 -4.5 ]
[.01131 .16002 0 4.5 ]
[.01131 .45507 -18 -4.5 ]
[.01131 .45507 0 4.5 ]
[.01131 .60259 -6 -4.5 ]
[.01131 .60259 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .30755 m
.18254 .3138 L
s
[(1)] .18254 .29505 0 1 Mshowa
.34127 .30755 m
.34127 .3138 L
s
[(2)] .34127 .29505 0 1 Mshowa
.5 .30755 m
.5 .3138 L
s
[(3)] .5 .29505 0 1 Mshowa
.65873 .30755 m
.65873 .3138 L
s
[(4)] .65873 .29505 0 1 Mshowa
.81746 .30755 m
.81746 .3138 L
s
[(5)] .81746 .29505 0 1 Mshowa
.97619 .30755 m
.97619 .3138 L
s
[(6)] .97619 .29505 0 1 Mshowa
.125 Mabswid
.05556 .30755 m
.05556 .3113 L
s
.0873 .30755 m
.0873 .3113 L
s
.11905 .30755 m
.11905 .3113 L
s
.15079 .30755 m
.15079 .3113 L
s
.21429 .30755 m
.21429 .3113 L
s
.24603 .30755 m
.24603 .3113 L
s
.27778 .30755 m
.27778 .3113 L
s
.30952 .30755 m
.30952 .3113 L
s
.37302 .30755 m
.37302 .3113 L
s
.40476 .30755 m
.40476 .3113 L
s
.43651 .30755 m
.43651 .3113 L
s
.46825 .30755 m
.46825 .3113 L
s
.53175 .30755 m
.53175 .3113 L
s
.56349 .30755 m
.56349 .3113 L
s
.59524 .30755 m
.59524 .3113 L
s
.62698 .30755 m
.62698 .3113 L
s
.69048 .30755 m
.69048 .3113 L
s
.72222 .30755 m
.72222 .3113 L
s
.75397 .30755 m
.75397 .3113 L
s
.78571 .30755 m
.78571 .3113 L
s
.84921 .30755 m
.84921 .3113 L
s
.88095 .30755 m
.88095 .3113 L
s
.9127 .30755 m
.9127 .3113 L
s
.94444 .30755 m
.94444 .3113 L
s
.25 Mabswid
0 .30755 m
1 .30755 L
s
.02381 .0125 m
.03006 .0125 L
s
[(-1)] .01131 .0125 1 0 Mshowa
.02381 .16002 m
.03006 .16002 L
s
[(-0.5)] .01131 .16002 1 0 Mshowa
.02381 .45507 m
.03006 .45507 L
s
[(0.5)] .01131 .45507 1 0 Mshowa
.02381 .60259 m
.03006 .60259 L
s
[(1)] .01131 .60259 1 0 Mshowa
.125 Mabswid
.02381 .042 m
.02756 .042 L
s
.02381 .07151 m
.02756 .07151 L
s
.02381 .10101 m
.02756 .10101 L
s
.02381 .13052 m
.02756 .13052 L
s
.02381 .18953 m
.02756 .18953 L
s
.02381 .21903 m
.02756 .21903 L
s
.02381 .24854 m
.02756 .24854 L
s
.02381 .27804 m
.02756 .27804 L
s
.02381 .33705 m
.02756 .33705 L
s
.02381 .36656 m
.02756 .36656 L
s
.02381 .39606 m
.02756 .39606 L
s
.02381 .42557 m
.02756 .42557 L
s
.02381 .48458 m
.02756 .48458 L
s
.02381 .51408 m
.02756 .51408 L
s
.02381 .54359 m
.02756 .54359 L
s
.02381 .57309 m
.02756 .57309 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60259 m
.02605 .6029 L
.02729 .60303 L
.02846 .60313 L
.02954 .6032 L
.03072 .60326 L
.0318 .6033 L
.03279 .60332 L
.03396 .60332 L
.03506 .6033 L
.03626 .60326 L
.03756 .60319 L
.03891 .60309 L
.0402 .60297 L
.04262 .60268 L
.045 .6023 L
.04753 .60181 L
.0521 .60069 L
.05752 .59898 L
.06244 .59707 L
.07287 .59194 L
.08414 .58481 L
.10458 .56801 L
.14558 .52115 L
.18507 .46292 L
.22304 .39857 L
.26347 .32508 L
.30238 .25343 L
.34374 .18087 L
.38358 .12217 L
.42191 .07486 L
.4413 .05506 L
.46269 .03687 L
.47244 .02995 L
.48295 .02352 L
.48771 .02097 L
.4928 .01849 L
.49506 .01748 L
.49751 .01644 L
.49863 .01599 L
.49982 .01552 L
.50084 .01535 L
.50196 .01523 L
.50455 .01499 L
.50582 .01491 L
.50697 .01484 L
.5081 .01479 L
.50917 .01475 L
.5103 .01473 L
.51153 .01472 L
Mistroke
.51224 .01472 L
.51291 .01472 L
.51416 .01474 L
.51486 .01476 L
.51551 .01478 L
.51696 .01485 L
.51813 .01492 L
.51941 .01501 L
.522 .01524 L
.52476 .01557 L
.52727 .01593 L
.53292 .01698 L
.5431 .01966 L
.55304 .02325 L
.56222 .0274 L
.583 .03962 L
.6017 .05387 L
.62232 .07295 L
.66257 .12031 L
.70131 .18202 L
.7425 .25468 L
.78218 .32747 L
.82034 .39632 L
.86095 .46433 L
.90005 .52078 L
.92 .54493 L
.9416 .56677 L
.95961 .58111 L
.97619 .59084 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[TextData[{
  "Increasing the setting for ",
  StyleBox["InterpolationOrder", "MR"],
  " typically leads to smoother approximate functions. However, if you \
increase the setting too much, spurious wiggles may develop. "
}], "Text",
  CellTags->{"S3.8.3", "3.27"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ListInterpolation[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "11"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "12"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "21"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], 
            Cell["\<\
construct an approximate function from a \
two\[Hyphen]dimensional grid of values at integer points \
\>"]},
          {Cell[TextData[{
              StyleBox["ListInterpolation[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}}]", "MR"],
              " "
            }]], 
            Cell["\<\
assume the values are from an evenly spaced grid with \
the specified domain \
\>"]},
          {Cell[TextData[{
              StyleBox["ListInterpolation[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }}]",
              StyleBox[" ", "TR"]
            }]], 
            Cell["\<\
assume the values are from a grid with the specified \
grid lines \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.3"],

Cell["Interpolating multidimensional arrays of data. ", "Caption",
  CellTags->"S3.8.3"],

Cell["\<\
This interpolates an array of values from integer grid points. \
\
\>", "MathCaption",
  CellTags->{"S3.8.3", "3.28"}],

Cell[CellGroupData[{

Cell["ListInterpolation[ Table[1.5/(x^2 + y^3), {x, 10}, {y, 15}]]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1.`, 10.`}, {1.`, 15.`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell["Here is the value at a particular position. ", "MathCaption",
  CellTags->{"S3.8.3", "3.29"}],

Cell[CellGroupData[{

Cell["%[6.5, 7.2]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \(0.0036075869356459443`\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell["Here is another array of values. ", "MathCaption",
  CellTags->{"S3.8.3", "3.30"}],

Cell["\<\
tab = Table[1.5/(x^2 + y^3), {x, 5.5, 7.2, .2}, {y, 2.3, 8.9, .1}] \
;\
\>", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.8.3"],

Cell[TextData[{
  "To interpolate this array you explicitly have to tell ",
  StyleBox["Mathematica", "TI"],
  " the domain it covers. "
}], "MathCaption",
  CellTags->{"S3.8.3", "3.31"}],

Cell[CellGroupData[{

Cell["ListInterpolation[tab, {{5.5, 7.2}, {2.3, 8.9}}]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{5.5`, 7.2`}, {2.3`, 8.9`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ListInterpolation", "MR"],
  " works for arrays of any dimension, and in each case it produces an ",
  StyleBox["InterpolatingFunction", "MR"],
  " object which takes the appropriate number of arguments.  "
}], "Text",
  CellTags->{"S3.8.3", "3.32"}],

Cell["\<\
This interpolates a three\[Hyphen]dimensional array. \
\>", \
"MathCaption",
  CellTags->{"S3.8.3", "3.33"}],

Cell["\<\
ListInterpolation[ Array[#1^2 + #2^2 - #3^2 &, {10, 10, 10}]] \
;\
\>", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.8.3"],

Cell[TextData[{
  "The resulting ",
  StyleBox["InterpolatingFunction", "MR"],
  " object takes three arguments. "
}], "MathCaption",
  CellTags->{"S3.8.3", "3.34"}],

Cell[CellGroupData[{

Cell["%[3.4, 7.8, 2.6]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \(65.63999999999999`\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can handle not only purely numerical approximate functions, but also ones \
which involve symbolic parameters. "
}], "Text",
  CellTags->{"S3.8.3", "3.35"}],

Cell[TextData[{
  "This generates an ",
  StyleBox["InterpolatingFunction", "MR"],
  " that depends on the parameters ",
  StyleBox["a", "MR"],
  " and ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.8.3", "3.36"}],

Cell[CellGroupData[{

Cell["sfun = ListInterpolation[{1 + a, 2, 3, 4 + b, 5}]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 5}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell["\<\
This shows how the interpolated value at 2.2 depends on the \
parameters. \
\>", "MathCaption",
  CellTags->{"S3.8.3", "3.37"}],

Cell[CellGroupData[{

Cell["sfun[2.2] // Simplify", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \(\(\(2.2`\)\(\[InvisibleSpace]\)\) - 0.04800000000000002`\ a - 
      0.032000000000000035`\ b\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[TextData[{
  "With the default setting for ",
  StyleBox["InterpolationOrder", "MR"],
  " used, the value at this point no longer depends on ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.8.3", "3.38"}],

Cell[CellGroupData[{

Cell["sfun[3.8] // Simplify", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    \(\(\(3.8`\)\(\[InvisibleSpace]\)\) + 0.8639999999999999`\ b\)], "Output",\

  CellLabel->"Out[26]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[TextData[{
  "In working with approximate functions, you can quite often end up with \
complicated combinations of ",
  StyleBox["InterpolatingFunction", "MR"],
  " objects. You can always tell ",
  StyleBox["Mathematica", "TI"],
  " to produce a single ",
  StyleBox["InterpolatingFunction", "MR"],
  " object valid over a particular domain by using ",
  StyleBox["FunctionInterpolation", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.8.3", "3.39"}],

Cell[TextData[{
  "This generates a new ",
  StyleBox["InterpolatingFunction", "MR"],
  " object valid in the domain 0 to 1. "
}], "MathCaption",
  CellTags->{"S3.8.3", "3.40"}],

Cell[CellGroupData[{

Cell["FunctionInterpolation[x + sin[x^2], {x, 0, 1}]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[TextData[{
  "This generates a nested ",
  StyleBox["InterpolatingFunction", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S3.8.3", "3.41"}],

Cell[CellGroupData[{

Cell["ListInterpolation[{3, 4, 5, sin[a], 6}]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 5}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[TextData[{
  "This produces a pure two\[Hyphen]dimensional ",
  StyleBox["InterpolatingFunction", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S3.8.3", "3.42"}],

Cell[CellGroupData[{

Cell["FunctionInterpolation[a^2 + %[x], {x, 1, 3}, {a, 0, 1.5}]", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S3.8.3"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1.`, 3.`}, {0.`, 1.5000000000000002`}}, 
        "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[29]= ",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FunctionInterpolation[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "construct an approximate function by evaluating ",
              StyleBox["expr", "TI"],
              " with ",
              StyleBox["x", "TI"],
              " ranging from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FunctionInterpolation[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
construct a higher\[Hyphen]dimensional approximate \
function \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.3"],

Cell["\<\
Constructing approximate functions by evaluating expressions. \
\
\>", "Caption",
  CellTags->"S3.8.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.8.4 Fourier Transforms", "Subsection",
  CellTags->{"S3.8.4", "4.1"}],

Cell["\<\
A common operation in analyzing various kinds of data is to find \
the Fourier transform, or spectrum, of a list of values. The idea is \
typically to pick out components of the data with particular frequencies, or \
ranges of frequencies.    \
\>", "Text",
  CellTags->{"S3.8.4", "4.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Fourier[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}]",
              StyleBox[" ", "TR"]
            }]], Cell["Fourier transform "]},
          {Cell[TextData[{
              StyleBox["InverseFourier[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}]",
              StyleBox[" ", "TR"]
            }]], Cell["inverse Fourier transform "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.4"],

Cell["Fourier transforms. ", "Caption",
  CellTags->"S3.8.4"],

Cell["Here is some data, corresponding to a square pulse.  ", "MathCaption",
  CellTags->{"S3.8.4", "4.3"}],

Cell[CellGroupData[{

Cell["{-1, -1, -1, -1, 1, 1, 1, 1}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.8.4"],

Cell[BoxData[
    \({\(-1\), \(-1\), \(-1\), \(-1\), 1, 1, 1, 1}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.8.4"]
}, Open  ]],

Cell["\<\
Here is the Fourier transform of the data. It involves complex \
numbers. \
\>", "MathCaption",
  CellTags->{"S3.8.4", "4.4"}],

Cell[CellGroupData[{

Cell["Fourier[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.8.4"],

Cell[BoxData[
    \({\(\(0.`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(-0.7071067811865476`\) - 
        1.7071067811865475`\ \[ImaginaryI], \(\(0.`\)\(\[InvisibleSpace]\)\) \
+ 0.`\ \[ImaginaryI], \(-0.7071067811865476`\) - 
        0.29289321881345254`\ \[ImaginaryI], \(\(0.`\)\(\[InvisibleSpace]\)\) \
+ 0.`\ \[ImaginaryI], \(-0.7071067811865476`\) + 
        0.29289321881345254`\ \[ImaginaryI], \(\(0.`\)\(\[InvisibleSpace]\)\) \
+ 0.`\ \[ImaginaryI], \(-0.7071067811865476`\) + 
        1.7071067811865475`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.8.4"]
}, Open  ]],

Cell["Here is the inverse Fourier transform. ", "MathCaption",
  CellTags->{"S3.8.4", "4.5"}],

Cell[CellGroupData[{

Cell["InverseFourier[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.8.4"],

Cell[BoxData[
    \({\(-1.0000000000000002`\), \(-1.0000000000000002`\), \(-1.`\), \
\(-1.0000000000000002`\), 1.0000000000000002`, 1.0000000000000002`, 1.`, 
      1.0000000000000002`}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.8.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Fourier", "MR"],
  " works whether or not your list of data has a length which is a power of \
two. "
}], "MathCaption",
  CellTags->{"S3.8.4", "4.6"}],

Cell[CellGroupData[{

Cell["Fourier[{1, -1, 1}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.8.4"],

Cell[BoxData[
    \({\(\(0.5773502691896257`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(\(0.5773502691896257`\)\(\[InvisibleSpace]\)\) \
- 0.9999999999999999`\ \[ImaginaryI], \(\(0.5773502691896257`\)\(\
\[InvisibleSpace]\)\) + 0.9999999999999999`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.8.4"]
}, Open  ]],

Cell["\<\
This generates a length\[Hyphen]200 list containing a periodic \
signal with random noise added. \
\>", "MathCaption",
  CellTags->{"S3.8.4", "4.7"}],

Cell["\<\
data = Table[ N[Sin[30 2 Pi n/200] + (Random[ ] - 1/2)], {n, 200} ] \
;\
\>", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.8.4"],

Cell["The data looks fairly random if you plot it directly. ", "MathCaption",
  CellTags->{"S3.8.4", "4.8"}],

Cell[CellGroupData[{

Cell["ListPlot[ data, PlotJoined -> True ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.8.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0047619 0.305625 0.206692 [
[.2619 .29312 -6 -9 ]
[.2619 .29312 6 0 ]
[.5 .29312 -9 -9 ]
[.5 .29312 9 0 ]
[.7381 .29312 -9 -9 ]
[.7381 .29312 9 0 ]
[.97619 .29312 -9 -9 ]
[.97619 .29312 9 0 ]
[.01131 .09893 -12 -4.5 ]
[.01131 .09893 0 4.5 ]
[.01131 .20228 -24 -4.5 ]
[.01131 .20228 0 4.5 ]
[.01131 .40897 -18 -4.5 ]
[.01131 .40897 0 4.5 ]
[.01131 .51232 -6 -4.5 ]
[.01131 .51232 0 4.5 ]
[.01131 .61566 -18 -4.5 ]
[.01131 .61566 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .30562 m
.2619 .31187 L
s
[(50)] .2619 .29312 0 1 Mshowa
.5 .30562 m
.5 .31187 L
s
[(100)] .5 .29312 0 1 Mshowa
.7381 .30562 m
.7381 .31187 L
s
[(150)] .7381 .29312 0 1 Mshowa
.97619 .30562 m
.97619 .31187 L
s
[(200)] .97619 .29312 0 1 Mshowa
.125 Mabswid
.07143 .30562 m
.07143 .30937 L
s
.11905 .30562 m
.11905 .30937 L
s
.16667 .30562 m
.16667 .30937 L
s
.21429 .30562 m
.21429 .30937 L
s
.30952 .30562 m
.30952 .30937 L
s
.35714 .30562 m
.35714 .30937 L
s
.40476 .30562 m
.40476 .30937 L
s
.45238 .30562 m
.45238 .30937 L
s
.54762 .30562 m
.54762 .30937 L
s
.59524 .30562 m
.59524 .30937 L
s
.64286 .30562 m
.64286 .30937 L
s
.69048 .30562 m
.69048 .30937 L
s
.78571 .30562 m
.78571 .30937 L
s
.83333 .30562 m
.83333 .30937 L
s
.88095 .30562 m
.88095 .30937 L
s
.92857 .30562 m
.92857 .30937 L
s
.25 Mabswid
0 .30562 m
1 .30562 L
s
.02381 .09893 m
.03006 .09893 L
s
[(-1)] .01131 .09893 1 0 Mshowa
.02381 .20228 m
.03006 .20228 L
s
[(-0.5)] .01131 .20228 1 0 Mshowa
.02381 .40897 m
.03006 .40897 L
s
[(0.5)] .01131 .40897 1 0 Mshowa
.02381 .51232 m
.03006 .51232 L
s
[(1)] .01131 .51232 1 0 Mshowa
.02381 .61566 m
.03006 .61566 L
s
[(1.5)] .01131 .61566 1 0 Mshowa
.125 Mabswid
.02381 .01626 m
.02756 .01626 L
s
.02381 .03693 m
.02756 .03693 L
s
.02381 .05759 m
.02756 .05759 L
s
.02381 .07826 m
.02756 .07826 L
s
.02381 .1196 m
.02756 .1196 L
s
.02381 .14027 m
.02756 .14027 L
s
.02381 .16094 m
.02756 .16094 L
s
.02381 .18161 m
.02756 .18161 L
s
.02381 .22295 m
.02756 .22295 L
s
.02381 .24362 m
.02756 .24362 L
s
.02381 .26429 m
.02756 .26429 L
s
.02381 .28496 m
.02756 .28496 L
s
.02381 .32629 m
.02756 .32629 L
s
.02381 .34696 m
.02756 .34696 L
s
.02381 .36763 m
.02756 .36763 L
s
.02381 .3883 m
.02756 .3883 L
s
.02381 .42964 m
.02756 .42964 L
s
.02381 .45031 m
.02756 .45031 L
s
.02381 .47098 m
.02756 .47098 L
s
.02381 .49165 m
.02756 .49165 L
s
.02381 .53299 m
.02756 .53299 L
s
.02381 .55365 m
.02756 .55365 L
s
.02381 .57432 m
.02756 .57432 L
s
.02381 .59499 m
.02756 .59499 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02857 .38109 m
.03333 .52913 L
.0381 .34054 L
.04286 .26089 L
.04762 .17306 L
.05238 .20162 L
.05714 .4197 L
.0619 .47977 L
.06667 .44333 L
.07143 .28093 L
.07619 .22706 L
.08095 .04193 L
.08571 .31584 L
.09048 .50859 L
.09524 .46641 L
.1 .45812 L
.10476 .1798 L
.10952 .04271 L
.11429 .21157 L
.11905 .38888 L
.12381 .54645 L
.12857 .56794 L
.13333 .35266 L
.1381 .22612 L
.14286 .16095 L
.14762 .1196 L
.15238 .27828 L
.15714 .57077 L
.1619 .56407 L
.16667 .32695 L
.17143 .10033 L
.17619 .0967 L
.18095 .25915 L
.18571 .36979 L
.19048 .48893 L
.19524 .37855 L
.2 .28841 L
.20476 .0736 L
.20952 .05758 L
.21429 .3294 L
.21905 .47811 L
.22381 .42974 L
.22857 .31885 L
.23333 .228 L
.2381 .13395 L
.24286 .14928 L
.24762 .43903 L
.25238 .40074 L
.25714 .54919 L
.2619 .23196 L
Mistroke
.26667 .19582 L
.27143 .04236 L
.27619 .33021 L
.28095 .43547 L
.28571 .50446 L
.29048 .47612 L
.29524 .20947 L
.3 .07137 L
.30476 .0506 L
.30952 .29985 L
.31429 .49724 L
.31905 .60332 L
.32381 .46586 L
.32857 .25793 L
.33333 .01472 L
.3381 .25437 L
.34286 .41316 L
.34762 .42879 L
.35238 .45696 L
.35714 .30737 L
.3619 .21588 L
.36667 .03375 L
.37143 .25287 L
.37619 .39918 L
.38095 .42903 L
.38571 .52185 L
.39048 .26776 L
.39524 .1761 L
.4 .16632 L
.40476 .24801 L
.40952 .42779 L
.41429 .50359 L
.41905 .38187 L
.42381 .23564 L
.42857 .13282 L
.43333 .18775 L
.4381 .38885 L
.44286 .58326 L
.44762 .4876 L
.45238 .34235 L
.45714 .21744 L
.4619 .16017 L
.46667 .16905 L
.47143 .35876 L
.47619 .41054 L
.48095 .45019 L
.48571 .26128 L
.49048 .17197 L
.49524 .22327 L
.5 .33731 L
Mistroke
.50476 .56971 L
.50952 .60142 L
.51429 .3231 L
.51905 .17009 L
.52381 .13751 L
.52857 .17862 L
.53333 .41407 L
.5381 .53999 L
.54286 .37419 L
.54762 .39984 L
.55238 .06029 L
.55714 .16913 L
.5619 .23168 L
.56667 .38126 L
.57143 .4585 L
.57619 .33272 L
.58095 .20104 L
.58571 .02821 L
.59048 .08303 L
.59524 .2915 L
.6 .51594 L
.60476 .46178 L
.60952 .3326 L
.61429 .24168 L
.61905 .14851 L
.62381 .14784 L
.62857 .27565 L
.63333 .47044 L
.6381 .38049 L
.64286 .3782 L
.64762 .10333 L
.65238 .14285 L
.65714 .14471 L
.6619 .50882 L
.66667 .45202 L
.67143 .50418 L
.67619 .25812 L
.68095 .13326 L
.68571 .23527 L
.69048 .37374 L
.69524 .42658 L
.7 .5039 L
.70476 .41839 L
.70952 .16302 L
.71429 .11292 L
.71905 .12291 L
.72381 .35194 L
.72857 .52689 L
.73333 .5406 L
.7381 .38404 L
Mistroke
.74286 .11135 L
.74762 .06215 L
.75238 .29851 L
.75714 .32961 L
.7619 .41699 L
.76667 .44976 L
.77143 .29221 L
.77619 .03319 L
.78095 .20672 L
.78571 .35455 L
.79048 .40358 L
.79524 .50548 L
.8 .4443 L
.80476 .26829 L
.80952 .17928 L
.81429 .08236 L
.81905 .29205 L
.82381 .50413 L
.82857 .43585 L
.83333 .36842 L
.8381 .18186 L
.84286 .18964 L
.84762 .24036 L
.85238 .51484 L
.85714 .47948 L
.8619 .45126 L
.86667 .28695 L
.87143 .19093 L
.87619 .09756 L
.88095 .20378 L
.88571 .57093 L
.89048 .5566 L
.89524 .36368 L
.9 .13671 L
.90476 .16293 L
.90952 .13191 L
.91429 .39222 L
.91905 .47396 L
.92381 .55985 L
.92857 .25182 L
.93333 .13523 L
.9381 .18223 L
.94286 .2624 L
.94762 .41387 L
.95238 .56903 L
.95714 .52305 L
.9619 .16045 L
.96667 .11142 L
.97143 .1246 L
.97619 .27407 L
Mistroke
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.8.4"]
}, Open  ]],

Cell[TextData[{
  "The Fourier transform, however, shows a strong peak at ",
  Cell[BoxData[
      \(TraditionalForm\`30 + 1\)], "InlineFormula"],
  ", and a symmetric peak at ",
  Cell[BoxData[
      \(TraditionalForm\`201 - 30\)], "InlineFormula"],
  ", reflecting the frequency component of the original signal near ",
  Cell[BoxData[
      \(TraditionalForm\`30/200\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.8.4", "4.9"}],

Cell[CellGroupData[{

Cell["\<\
ListPlot[ Abs[Fourier[data]], PlotJoined -> True, PlotRange -> All \
]\
\>", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.8.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0190237 0.00478583 0.0122406 0.0859991 [
[.25832 -0.00026 -6 -9 ]
[.25832 -0.00026 6 0 ]
[.49761 -0.00026 -9 -9 ]
[.49761 -0.00026 9 0 ]
[.7369 -0.00026 -9 -9 ]
[.7369 -0.00026 9 0 ]
[.97619 -0.00026 -9 -9 ]
[.97619 -0.00026 9 0 ]
[.00652 .09824 -6 -4.5 ]
[.00652 .09824 0 4.5 ]
[.00652 .18424 -6 -4.5 ]
[.00652 .18424 0 4.5 ]
[.00652 .27024 -6 -4.5 ]
[.00652 .27024 0 4.5 ]
[.00652 .35624 -6 -4.5 ]
[.00652 .35624 0 4.5 ]
[.00652 .44224 -6 -4.5 ]
[.00652 .44224 0 4.5 ]
[.00652 .52824 -6 -4.5 ]
[.00652 .52824 0 4.5 ]
[.00652 .61423 -6 -4.5 ]
[.00652 .61423 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.25832 .01224 m
.25832 .01849 L
s
[(50)] .25832 -0.00026 0 1 Mshowa
.49761 .01224 m
.49761 .01849 L
s
[(100)] .49761 -0.00026 0 1 Mshowa
.7369 .01224 m
.7369 .01849 L
s
[(150)] .7369 -0.00026 0 1 Mshowa
.97619 .01224 m
.97619 .01849 L
s
[(200)] .97619 -0.00026 0 1 Mshowa
.125 Mabswid
.06688 .01224 m
.06688 .01599 L
s
.11474 .01224 m
.11474 .01599 L
s
.1626 .01224 m
.1626 .01599 L
s
.21046 .01224 m
.21046 .01599 L
s
.30617 .01224 m
.30617 .01599 L
s
.35403 .01224 m
.35403 .01599 L
s
.40189 .01224 m
.40189 .01599 L
s
.44975 .01224 m
.44975 .01599 L
s
.54547 .01224 m
.54547 .01599 L
s
.59332 .01224 m
.59332 .01599 L
s
.64118 .01224 m
.64118 .01599 L
s
.68904 .01224 m
.68904 .01599 L
s
.78476 .01224 m
.78476 .01599 L
s
.83262 .01224 m
.83262 .01599 L
s
.88047 .01224 m
.88047 .01599 L
s
.92833 .01224 m
.92833 .01599 L
s
.25 Mabswid
0 .01224 m
1 .01224 L
s
.01902 .09824 m
.02527 .09824 L
s
[(1)] .00652 .09824 1 0 Mshowa
.01902 .18424 m
.02527 .18424 L
s
[(2)] .00652 .18424 1 0 Mshowa
.01902 .27024 m
.02527 .27024 L
s
[(3)] .00652 .27024 1 0 Mshowa
.01902 .35624 m
.02527 .35624 L
s
[(4)] .00652 .35624 1 0 Mshowa
.01902 .44224 m
.02527 .44224 L
s
[(5)] .00652 .44224 1 0 Mshowa
.01902 .52824 m
.02527 .52824 L
s
[(6)] .00652 .52824 1 0 Mshowa
.01902 .61423 m
.02527 .61423 L
s
[(7)] .00652 .61423 1 0 Mshowa
.125 Mabswid
.01902 .02944 m
.02277 .02944 L
s
.01902 .04664 m
.02277 .04664 L
s
.01902 .06384 m
.02277 .06384 L
s
.01902 .08104 m
.02277 .08104 L
s
.01902 .11544 m
.02277 .11544 L
s
.01902 .13264 m
.02277 .13264 L
s
.01902 .14984 m
.02277 .14984 L
s
.01902 .16704 m
.02277 .16704 L
s
.01902 .20144 m
.02277 .20144 L
s
.01902 .21864 m
.02277 .21864 L
s
.01902 .23584 m
.02277 .23584 L
s
.01902 .25304 m
.02277 .25304 L
s
.01902 .28744 m
.02277 .28744 L
s
.01902 .30464 m
.02277 .30464 L
s
.01902 .32184 m
.02277 .32184 L
s
.01902 .33904 m
.02277 .33904 L
s
.01902 .37344 m
.02277 .37344 L
s
.01902 .39064 m
.02277 .39064 L
s
.01902 .40784 m
.02277 .40784 L
s
.01902 .42504 m
.02277 .42504 L
s
.01902 .45944 m
.02277 .45944 L
s
.01902 .47664 m
.02277 .47664 L
s
.01902 .49384 m
.02277 .49384 L
s
.01902 .51104 m
.02277 .51104 L
s
.01902 .54543 m
.02277 .54543 L
s
.01902 .56263 m
.02277 .56263 L
s
.01902 .57983 m
.02277 .57983 L
s
.01902 .59703 m
.02277 .59703 L
s
.25 Mabswid
.01902 0 m
.01902 .61803 L
s
.5 Mabswid
.02381 .04571 m
.0286 .02301 L
.03338 .03897 L
.03817 .03668 L
.04295 .01763 L
.04774 .05499 L
.05252 .02336 L
.05731 .03092 L
.0621 .01472 L
.06688 .02035 L
.07167 .03478 L
.07645 .04164 L
.08124 .02545 L
.08603 .01951 L
.09081 .03787 L
.0956 .02816 L
.10038 .04637 L
.10517 .06332 L
.10995 .02555 L
.11474 .04212 L
.11953 .03795 L
.12431 .02973 L
.1291 .01895 L
.13388 .03731 L
.13867 .05234 L
.14346 .05543 L
.14824 .02949 L
.15303 .0304 L
.15781 .04866 L
.1626 .02874 L
.16738 .60332 L
.17217 .03361 L
.17696 .03356 L
.18174 .02349 L
.18653 .02862 L
.19131 .03949 L
.1961 .01484 L
.20089 .02713 L
.20567 .0326 L
.21046 .03507 L
.21524 .01778 L
.22003 .03172 L
.22481 .05653 L
.2296 .03729 L
.23439 .02215 L
.23917 .02309 L
.24396 .01822 L
.24874 .0571 L
.25353 .03131 L
.25832 .02689 L
Mistroke
.2631 .0409 L
.26789 .02042 L
.27267 .03111 L
.27746 .02779 L
.28224 .03653 L
.28703 .04924 L
.29182 .05862 L
.2966 .03573 L
.30139 .04111 L
.30617 .0258 L
.31096 .01986 L
.31575 .02916 L
.32053 .05084 L
.32532 .03885 L
.3301 .02069 L
.33489 .02954 L
.33967 .03798 L
.34446 .04868 L
.34925 .0312 L
.35403 .02806 L
.35882 .05764 L
.3636 .02057 L
.36839 .02242 L
.37318 .04505 L
.37796 .02231 L
.38275 .03192 L
.38753 .02476 L
.39232 .03125 L
.3971 .03087 L
.40189 .0329 L
.40668 .02446 L
.41146 .03785 L
.41625 .02692 L
.42103 .04128 L
.42582 .01658 L
.43061 .03819 L
.43539 .0214 L
.44018 .0251 L
.44496 .03922 L
.44975 .04506 L
.45453 .0365 L
.45932 .06823 L
.46411 .02226 L
.46889 .04249 L
.47368 .05875 L
.47846 .02699 L
.48325 .03365 L
.48804 .02558 L
.49282 .03399 L
.49761 .04414 L
Mistroke
.50239 .0221 L
.50718 .04414 L
.51196 .03399 L
.51675 .02558 L
.52154 .03365 L
.52632 .02699 L
.53111 .05875 L
.53589 .04249 L
.54068 .02226 L
.54547 .06823 L
.55025 .0365 L
.55504 .04506 L
.55982 .03922 L
.56461 .0251 L
.56939 .0214 L
.57418 .03819 L
.57897 .01658 L
.58375 .04128 L
.58854 .02692 L
.59332 .03785 L
.59811 .02446 L
.6029 .0329 L
.60768 .03087 L
.61247 .03125 L
.61725 .02476 L
.62204 .03192 L
.62682 .02231 L
.63161 .04505 L
.6364 .02242 L
.64118 .02057 L
.64597 .05764 L
.65075 .02806 L
.65554 .0312 L
.66033 .04868 L
.66511 .03798 L
.6699 .02954 L
.67468 .02069 L
.67947 .03885 L
.68425 .05084 L
.68904 .02916 L
.69383 .01986 L
.69861 .0258 L
.7034 .04111 L
.70818 .03573 L
.71297 .05862 L
.71776 .04924 L
.72254 .03653 L
.72733 .02779 L
.73211 .03111 L
.7369 .02042 L
Mistroke
.74168 .0409 L
.74647 .02689 L
.75126 .03131 L
.75604 .0571 L
.76083 .01822 L
.76561 .02309 L
.7704 .02215 L
.77519 .03729 L
.77997 .05653 L
.78476 .03172 L
.78954 .01778 L
.79433 .03507 L
.79911 .0326 L
.8039 .02713 L
.80869 .01484 L
.81347 .03949 L
.81826 .02862 L
.82304 .02349 L
.82783 .03356 L
.83262 .03361 L
.8374 .60332 L
.84219 .02874 L
.84697 .04866 L
.85176 .0304 L
.85654 .02949 L
.86133 .05543 L
.86612 .05234 L
.8709 .03731 L
.87569 .01895 L
.88047 .02973 L
.88526 .03795 L
.89005 .04212 L
.89483 .02555 L
.89962 .06332 L
.9044 .04637 L
.90919 .02816 L
.91397 .03787 L
.91876 .01951 L
.92355 .02545 L
.92833 .04164 L
.93312 .03478 L
.9379 .02035 L
.94269 .01472 L
.94748 .03092 L
.95226 .02336 L
.95705 .05499 L
.96183 .01763 L
.96662 .03668 L
.9714 .03897 L
.97619 .02301 L
Mistroke
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.8.4"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica", "TI"],
  ", the discrete Fourier transform ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["v",
            "TI"], 
          StyleBox["s",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " of a list ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            "TI"], 
          StyleBox["r",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " of length ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is by default defined to be ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox["1", 
            SqrtBox[
              StyleBox["n",
                "TI"]]], 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["r",
                "TI"], "=", "1"}], 
            StyleBox["n",
              "TI"],
            LimitsPositioning->True], 
          SubscriptBox[
            StyleBox["u",
              "TI"], 
            StyleBox["r",
              "TI"]], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"2", "\[Pi]", 
              StyleBox["i",
                "TI"], 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["r",
                    "TI"], "-", "1"}], ")"}], 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["s",
                    "TI"], "-", "1"}], ")"}], "/", 
              StyleBox["n",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  ". Notice that the zero frequency term appears at position 1 in the \
resulting list. "
}], "Text",
  CellTags->{"S3.8.4", "4.10"}],

Cell[TextData[{
  "The inverse discrete Fourier transform ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            "TI"], 
          StyleBox["r",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " of a list ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["v",
            "TI"], 
          StyleBox["s",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " of length ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is by default defined to be ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox["1", 
            SqrtBox[
              StyleBox["n",
                "TI"]]], 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["s",
                "TI"], "=", "1"}], 
            StyleBox["n",
              "TI"],
            LimitsPositioning->True], 
          SubscriptBox[
            StyleBox["v",
              "TI"], 
            StyleBox["s",
              "TI"]], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{\(-2\), "\[Pi]", 
              StyleBox["i",
                "TI"], 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["r",
                    "TI"], "-", "1"}], ")"}], 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["s",
                    "TI"], "-", "1"}], ")"}], "/", 
              StyleBox["n",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.8.4", "4.11"}],

Cell[TextData[{
  "In different scientific and technical fields different conventions are \
often used for defining discrete Fourier transforms. The option ",
  StyleBox["FourierParameters", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " allows you to choose any of these conventions you want.    "
}], "Text",
  CellTags->{"S3.8.4", "4.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["common convention", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["setting", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["discrete Fourier transform", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["inverse discrete Fourier transform", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " default "
            }]], Cell[TextData[{
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["1}", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox["1", 
                        SuperscriptBox[
                          StyleBox["n",
                            "TI"], \(1/2\)]], 
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["r",
                            "TI"], "=", "1"}], 
                        StyleBox["n",
                          "TI"],
                        LimitsPositioning->True], 
                      SubscriptBox[
                        StyleBox["u",
                          "TI"], 
                        StyleBox["r",
                          "TI"]], 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{"2", "\[Pi]", 
                          StyleBox["i",
                            "TI"], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["r",
                                "TI"], "-", "1"}], ")"}], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["s",
                                "TI"], "-", "1"}], ")"}], "/", 
                          StyleBox["n",
                            "TI"]}]]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox["1", 
                        SuperscriptBox[
                          StyleBox["n",
                            "TI"], \(1/2\)]], 
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["s",
                            "TI"], "=", "1"}], 
                        StyleBox["n",
                          "TI"],
                        LimitsPositioning->True], 
                      SubscriptBox[
                        StyleBox["v",
                          "TI"], 
                        StyleBox["s",
                          "TI"]], 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{\(-2\), "\[Pi]", 
                          StyleBox["i",
                            "TI"], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["r",
                                "TI"], "-", "1"}], ")"}], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["s",
                                "TI"], "-", "1"}], ")"}], "/", 
                          StyleBox["n",
                            "TI"]}]]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell["data analysis "], Cell[TextData[{
              StyleBox["{-1,", "MR"],
              " ",
              StyleBox["1}", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox["1", 
                        StyleBox["n",
                          "TI"]], 
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["r",
                            "TI"], "=", "1"}], 
                        StyleBox["n",
                          "TI"],
                        LimitsPositioning->True], 
                      SubscriptBox[
                        StyleBox["u",
                          "TI"], 
                        StyleBox["r",
                          "TI"]], 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{"2", "\[Pi]", 
                          StyleBox["i",
                            "TI"], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["r",
                                "TI"], "-", "1"}], ")"}], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["s",
                                "TI"], "-", "1"}], ")"}], "/", 
                          StyleBox["n",
                            "TI"]}]]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["s",
                            "TI"], "=", "1"}], 
                        StyleBox["n",
                          "TI"],
                        LimitsPositioning->True], 
                      SubscriptBox[
                        StyleBox["v",
                          "TI"], 
                        StyleBox["s",
                          "TI"]], 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{\(-2\), "\[Pi]", 
                          StyleBox["i",
                            "TI"], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["r",
                                "TI"], "-", "1"}], ")"}], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["s",
                                "TI"], "-", "1"}], ")"}], "/", 
                          StyleBox["n",
                            "TI"]}]]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell["signal processing "], Cell[TextData[{
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["-1}", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["r",
                            "TI"], "=", "1"}], 
                        StyleBox["n",
                          "TI"],
                        LimitsPositioning->True], 
                      SubscriptBox[
                        StyleBox["u",
                          "TI"], 
                        StyleBox["r",
                          "TI"]], 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{\(-2\), "\[Pi]", 
                          StyleBox["i",
                            "TI"], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["r",
                                "TI"], "-", "1"}], ")"}], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["s",
                                "TI"], "-", "1"}], ")"}], "/", 
                          StyleBox["n",
                            "TI"]}]]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox["1", 
                        StyleBox["n",
                          "TI"]], 
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["s",
                            "TI"], "=", "1"}], 
                        StyleBox["n",
                          "TI"],
                        LimitsPositioning->True], 
                      SubscriptBox[
                        StyleBox["v",
                          "TI"], 
                        StyleBox["s",
                          "TI"]], 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{"2", "\[Pi]", 
                          StyleBox["i",
                            "TI"], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["r",
                                "TI"], "-", "1"}], ")"}], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["s",
                                "TI"], "-", "1"}], ")"}], "/", 
                          StyleBox["n",
                            "TI"]}]]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell["general case "], Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox["1", 
                        SuperscriptBox[
                          StyleBox["n",
                            "TI"], 
                          RowBox[{
                            RowBox[{"(", 
                              RowBox[{"1", "-", 
                                StyleBox["a",
                                  "TI"]}], ")"}], "/", "2"}]]], 
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["r",
                            "TI"], "=", "1"}], 
                        StyleBox["n",
                          "TI"],
                        LimitsPositioning->True], 
                      SubscriptBox[
                        StyleBox["u",
                          "TI"], 
                        StyleBox["r",
                          "TI"]], 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{"2", "\[Pi]", 
                          StyleBox["i",
                            "TI"], 
                          StyleBox["b",
                            "TI"], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["r",
                                "TI"], "-", "1"}], ")"}], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["s",
                                "TI"], "-", "1"}], ")"}], "/", 
                          StyleBox["n",
                            "TI"]}]]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox["1", 
                        SuperscriptBox[
                          StyleBox["n",
                            "TI"], 
                          RowBox[{
                            RowBox[{"(", 
                              RowBox[{"1", "+", 
                                StyleBox["a",
                                  "TI"]}], ")"}], "/", "2"}]]], 
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["s",
                            "TI"], "=", "1"}], 
                        StyleBox["n",
                          "TI"],
                        LimitsPositioning->True], 
                      SubscriptBox[
                        StyleBox["v",
                          "TI"], 
                        StyleBox["s",
                          "TI"]], 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{\(-2\), "\[Pi]", 
                          StyleBox["i",
                            "TI"], 
                          StyleBox["b",
                            "TI"], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["r",
                                "TI"], "-", "1"}], ")"}], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["s",
                                "TI"], "-", "1"}], ")"}], "/", 
                          StyleBox["n",
                            "TI"]}]]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox4Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S3.8.4"],

Cell[TextData[{
  "Typical settings for ",
  StyleBox["FourierParameters", "MR"],
  " with various conventions. "
}], "Caption",
  CellTags->"S3.8.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Fourier[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "11"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "12"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "21"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "22"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell["\<\
two\[Hyphen]dimensional Fourier transform \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.4"],

Cell["\<\
Two\[Hyphen]dimensional Fourier transform. \
\>", "Caption",
  CellTags->"S3.8.4"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can find Fourier transforms for data in any number of dimensions. In ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " dimensions, the data is specified by a list nested ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " levels deep. Two\[Hyphen]dimensional Fourier transforms are often used in \
image processing. "
}], "Text",
  CellTags->{"S3.8.4", "4.13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.8.5 Convolutions and Correlations", "Subsection",
  CellTags->{"S3.8.5", "5.1"}],

Cell["\<\
Convolution and correlation are central to many kinds of operations \
on lists of data. They are used in such areas as signal and image processing, \
statistical data analysis, approximations to partial differential equations, \
as well as operations on digit sequences and power series.    \
\>", "Text",
  CellTags->{"S3.8.5", "5.2"}],

Cell[TextData[{
  "In both convolution and correlation the basic idea is to combine a kernel \
list with successive sublists of a list of data. The ",
  StyleBox["convolution", "TI"],
  " of a kernel ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["K",
            "TI"], 
          StyleBox["r",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " with a list ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            "TI"], 
          StyleBox["s",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " has the general form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderscriptBox["\[Sum]", 
            StyleBox["r",
              "TI"],
            LimitsPositioning->True], 
          SubscriptBox[
            StyleBox["K",
              "TI"], 
            StyleBox["r",
              "TI"]], 
          SubscriptBox[
            StyleBox["u",
              "TI"], 
            RowBox[{
              StyleBox["s",
                "TI"], "-", 
              StyleBox["r",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  ", while the ",
  StyleBox["correlation", "TI"],
  " has the general form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderscriptBox["\[Sum]", 
            StyleBox["r",
              "TI"],
            LimitsPositioning->True], 
          SubscriptBox[
            StyleBox["K",
              "TI"], 
            StyleBox["r",
              "TI"]], 
          SubscriptBox[
            StyleBox["u",
              "TI"], 
            RowBox[{
              StyleBox["s",
                "TI"], "+", 
              StyleBox["r",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.8.5", "5.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ListConvolve[", "MR"],
              StyleBox["kernel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "form the convolution of ",
              StyleBox["kernel", "TI"],
              " with ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ListCorrelate[", "MR"],
              StyleBox["kernel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "form the correlation of ",
              StyleBox["kernel", "TI"],
              " with ",
              StyleBox["list", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.5"],

Cell["Convolution and correlation of lists. ", "Caption",
  CellTags->"S3.8.5"],

Cell[TextData[{
  "This forms the convolution of the kernel ",
  StyleBox["{x,", "MR"],
  " ",
  StyleBox["y}", "MR"],
  " with a list of data. "
}], "MathCaption",
  CellTags->{"S3.8.5", "5.4"}],

Cell[CellGroupData[{

Cell["ListConvolve[{x,y}, {a,b,c,d,e}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({b\ x + a\ y, c\ x + b\ y, d\ x + c\ y, e\ x + d\ y}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell["This forms the correlation. ", "MathCaption",
  CellTags->{"S3.8.5", "5.5"}],

Cell[CellGroupData[{

Cell["ListCorrelate[{x,y}, {a,b,c,d,e}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({a\ x + b\ y, b\ x + c\ y, c\ x + d\ y, d\ x + e\ y}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell[TextData[{
  "In this case reversing the kernel gives exactly the same result as ",
  StyleBox["ListConvolve", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.8.5", "5.6"}],

Cell[CellGroupData[{

Cell["ListCorrelate[{y, x}, {a,b,c,d,e}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({b\ x + a\ y, c\ x + b\ y, d\ x + c\ y, e\ x + d\ y}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell["This forms successive differences of the data. ", "MathCaption",
  CellTags->{"S3.8.5", "5.7"}],

Cell[CellGroupData[{

Cell["ListCorrelate[{-1,1}, {a,b,c,d,e}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({\(-a\) + b, \(-b\) + c, \(-c\) + d, \(-d\) + e}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell[TextData[{
  "In forming sublists to combine with a kernel, there is always an issue of \
what to do at the ends of the list of data. By default, ",
  StyleBox["ListConvolve", "MR"],
  " and ",
  StyleBox["ListCorrelate", "MR"],
  " never form sublists which would \[OpenCurlyDoubleQuote]overhang\
\[CloseCurlyDoubleQuote] the ends of the list of data. This means that the \
output you get is normally shorter than the original list of data. "
}], "Text",
  CellTags->{"S3.8.5", "5.8"}],

Cell["\<\
With an input list of length 6, the output is in this case of \
length 4. \
\>", "MathCaption",
  CellTags->{"S3.8.5", "5.9"}],

Cell[CellGroupData[{

Cell["ListCorrelate[{1,1,1}, Range[6]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({6, 9, 12, 15}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell[TextData[{
  "In practice one often wants to get output that is as long as the original \
list of data. To do this requires including sublists that overhang one or \
both ends of the list of data. The additional elements needed to form these \
sublists must be filled in with some kind of \[OpenCurlyDoubleQuote]padding\
\[CloseCurlyDoubleQuote]. By default, ",
  StyleBox["Mathematica", "TI"],
  " takes copies of the original list to provide the padding, thus \
effectively treating the list as being cyclic. "
}], "Text",
  CellTags->{"S3.8.5", "5.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ListCorrelate[", "MR"],
              StyleBox["kernel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "do not allow overhangs on either side (result shorter than\
\[NonBreakingSpace]",
              StyleBox["list", "TI"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["ListCorrelate[", "MR"],
              StyleBox["kernel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["1]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "allow an overhang on the right (result same length as\
\[NonBreakingSpace]",
              StyleBox["list", "TI"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["ListCorrelate[", "MR"],
              StyleBox["kernel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["-1]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "allow an overhang on the left (result same length as\
\[NonBreakingSpace]",
              StyleBox["list", "TI"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["ListCorrelate[", "MR"],
              StyleBox["kernel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{-1,", "MR"],
              " ",
              StyleBox["1}]", "MR"],
              " "
            }]], Cell[TextData[{
              "allow overhangs on both sides (result longer than ",
              StyleBox["list", "TI"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["ListCorrelate[", "MR"],
              StyleBox["kernel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["k",
                        "TI"], 
                      StyleBox["L",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["k",
                        "TI"], 
                      StyleBox["R",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["allow particular overhangs on left and right "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.5"],

Cell["Controlling how the ends of the list of data are treated. ", "Caption",
  CellTags->"S3.8.5"],

Cell["The default involves no overhangs. ", "MathCaption",
  CellTags->{"S3.8.5", "5.11"}],

Cell[CellGroupData[{

Cell["ListCorrelate[{x, y}, {a, b, c, d}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({a\ x + b\ y, b\ x + c\ y, c\ x + d\ y}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell["\<\
The last term in the last element now comes from the beginning of \
the list. \
\>", "MathCaption",
  CellTags->{"S3.8.5", "5.12"}],

Cell[CellGroupData[{

Cell["ListCorrelate[{x, y}, {a, b, c, d}, 1]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({a\ x + b\ y, b\ x + c\ y, c\ x + d\ y, d\ x + a\ y}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell["\<\
Now the first term of the first element and the last term of the \
last element both involve wraparound. \
\>", "MathCaption",
  CellTags->{"S3.8.5", "5.13"}],

Cell[CellGroupData[{

Cell["ListCorrelate[{x, y}, {a, b, c, d}, {-1, 1}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({d\ x + a\ y, a\ x + b\ y, b\ x + c\ y, c\ x + d\ y, 
      d\ x + a\ y}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell[TextData[{
  "In the general case ",
  StyleBox["ListCorrelate[", "MR"],
  StyleBox["kernel", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["k",
            "TI"], 
          StyleBox["L",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["k",
            "TI"], 
          StyleBox["R",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  " is set up so that in the first element of the result, the first element \
of ",
  StyleBox["list", "TI"],
  " appears multiplied by the element at position ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["k",
            "TI"], 
          StyleBox["L",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " in ",
  StyleBox["kernel", "TI"],
  ", and in the last element of the result, the last element of ",
  StyleBox["list", "TI"],
  " appears multiplied by the element at position ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["k",
            "TI"], 
          StyleBox["R",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " in ",
  StyleBox["kernel", "TI"],
  ". The default case in which no overhang is allowed on either side thus \
corresponds to ",
  StyleBox["ListCorrelate[", "MR"],
  StyleBox["kernel", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{1,", "MR"],
  " ",
  StyleBox["-1}]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.8.5", "5.14"}],

Cell[TextData[{
  "With a kernel of length 3, alignments ",
  StyleBox["{-1,", "MR"],
  " ",
  StyleBox["2}", "MR"],
  " always make the first and last elements of the result the same. "
}], "MathCaption",
  CellTags->{"S3.8.5", "5.15"}],

Cell[CellGroupData[{

Cell["ListCorrelate[{x, y, z}, {a, b, c, d}, {-1, 2}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({c\ x + d\ y + a\ z, d\ x + a\ y + b\ z, a\ x + b\ y + c\ z, 
      b\ x + c\ y + d\ z, c\ x + d\ y + a\ z}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell["\<\
For many kinds of data, it is convenient to assume not that the \
data is cyclic, but rather that it is padded at either end by some fixed \
element, often 0, or by some sequence of elements. \
\>", "Text",
  CellTags->{"S3.8.5", "5.16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ListCorrelate[", "MR"],
              StyleBox["kernel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["klist", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["p", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad with element ",
              StyleBox["p", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ListCorrelate[", "MR"],
              StyleBox["kernel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["klist", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad with cyclic repetitions of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ListCorrelate[", "MR"],
              StyleBox["kernel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["klist", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["pad with cyclic repetitions of the original data "]},
          {Cell[TextData[{
              StyleBox["ListCorrelate[", "MR"],
              StyleBox["kernel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["klist", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{}]", "MR"],
              " "
            }]], Cell["include no padding "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.5"],

Cell["Controlling the padding for a list of data. ", "Caption",
  CellTags->"S3.8.5"],

Cell[TextData[{
  "This pads with element ",
  StyleBox["p", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.8.5", "5.17"}],

Cell[CellGroupData[{

Cell["ListCorrelate[{x, y}, {a, b, c, d}, {-1, 1}, p]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({p\ x + a\ y, a\ x + b\ y, b\ x + c\ y, c\ x + d\ y, 
      d\ x + p\ y}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell["A common case is to pad with zero. ", "MathCaption",
  CellTags->{"S3.8.5", "5.18"}],

Cell[CellGroupData[{

Cell["ListCorrelate[{x, y}, {a, b, c, d}, {-1, 1}, 0]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({a\ y, a\ x + b\ y, b\ x + c\ y, c\ x + d\ y, d\ x}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell[TextData[{
  "In this case ",
  StyleBox["q", "MR"],
  " appears at one end, and ",
  StyleBox["p", "MR"],
  " at the other. "
}], "MathCaption",
  CellTags->{"S3.8.5", "5.19"}],

Cell[CellGroupData[{

Cell["ListCorrelate[{x, y}, {a, b, c, d}, {-1, 1}, {p, q}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({q\ x + a\ y, a\ x + b\ y, b\ x + c\ y, c\ x + d\ y, 
      d\ x + p\ y}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell[TextData[{
  "Different choices of kernel allow ",
  StyleBox["ListConvolve", "MR"],
  " and ",
  StyleBox["ListCorrelate", "MR"],
  " to be used for different kinds of computations. "
}], "Text",
  CellTags->{"S3.8.5", "5.20"}],

Cell["This finds a moving average of data. ", "MathCaption",
  CellTags->{"S3.8.5", "5.21"}],

Cell[CellGroupData[{

Cell["ListCorrelate[{1,1,1}/3, {a,b,c,d,e}, {-1,1}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({a\/3 + d\/3 + e\/3, a\/3 + b\/3 + e\/3, a\/3 + b\/3 + c\/3, 
      b\/3 + c\/3 + d\/3, c\/3 + d\/3 + e\/3, a\/3 + d\/3 + e\/3, 
      a\/3 + b\/3 + e\/3}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell["Here is a Gaussian kernel. ", "MathCaption",
  CellTags->{"S3.8.5", "5.22"}],

Cell["kern = Table[Exp[-n^2/100]/Sqrt[2. Pi], {n, -10, 10}] ;", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.8.5"],

Cell["This generates some \
\[OpenCurlyDoubleQuote]data\[CloseCurlyDoubleQuote]. ", "MathCaption",
  CellTags->{"S3.8.5", "5.23"}],

Cell["\<\
data = Table[BesselJ[1, x] + 0.2 Random[ ], {x, 0, 10, .1}] ;\
\>", \
"Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.8.5"],

Cell["Here is a plot of the data. ", "MathCaption",
  CellTags->{"S3.8.5", "5.24"}],

Cell[CellGroupData[{

Cell["ListPlot[data]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.8.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00942951 0.181676 0.55354 [
[.2124 .16918 -6 -9 ]
[.2124 .16918 6 0 ]
[.40099 .16918 -6 -9 ]
[.40099 .16918 6 0 ]
[.58958 .16918 -6 -9 ]
[.58958 .16918 6 0 ]
[.77817 .16918 -6 -9 ]
[.77817 .16918 6 0 ]
[.96676 .16918 -9 -9 ]
[.96676 .16918 9 0 ]
[.01131 .07097 -24 -4.5 ]
[.01131 .07097 0 4.5 ]
[.01131 .29238 -18 -4.5 ]
[.01131 .29238 0 4.5 ]
[.01131 .40309 -18 -4.5 ]
[.01131 .40309 0 4.5 ]
[.01131 .5138 -18 -4.5 ]
[.01131 .5138 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2124 .18168 m
.2124 .18793 L
s
[(20)] .2124 .16918 0 1 Mshowa
.40099 .18168 m
.40099 .18793 L
s
[(40)] .40099 .16918 0 1 Mshowa
.58958 .18168 m
.58958 .18793 L
s
[(60)] .58958 .16918 0 1 Mshowa
.77817 .18168 m
.77817 .18793 L
s
[(80)] .77817 .16918 0 1 Mshowa
.96676 .18168 m
.96676 .18793 L
s
[(100)] .96676 .16918 0 1 Mshowa
.125 Mabswid
.07096 .18168 m
.07096 .18543 L
s
.1181 .18168 m
.1181 .18543 L
s
.16525 .18168 m
.16525 .18543 L
s
.25955 .18168 m
.25955 .18543 L
s
.30669 .18168 m
.30669 .18543 L
s
.35384 .18168 m
.35384 .18543 L
s
.44814 .18168 m
.44814 .18543 L
s
.49529 .18168 m
.49529 .18543 L
s
.54243 .18168 m
.54243 .18543 L
s
.63673 .18168 m
.63673 .18543 L
s
.68388 .18168 m
.68388 .18543 L
s
.73102 .18168 m
.73102 .18543 L
s
.82532 .18168 m
.82532 .18543 L
s
.87247 .18168 m
.87247 .18543 L
s
.91961 .18168 m
.91961 .18543 L
s
.25 Mabswid
0 .18168 m
1 .18168 L
s
.02381 .07097 m
.03006 .07097 L
s
[(-0.2)] .01131 .07097 1 0 Mshowa
.02381 .29238 m
.03006 .29238 L
s
[(0.2)] .01131 .29238 1 0 Mshowa
.02381 .40309 m
.03006 .40309 L
s
[(0.4)] .01131 .40309 1 0 Mshowa
.02381 .5138 m
.03006 .5138 L
s
[(0.6)] .01131 .5138 1 0 Mshowa
.125 Mabswid
.02381 .09865 m
.02756 .09865 L
s
.02381 .12632 m
.02756 .12632 L
s
.02381 .154 m
.02756 .154 L
s
.02381 .20935 m
.02756 .20935 L
s
.02381 .23703 m
.02756 .23703 L
s
.02381 .26471 m
.02756 .26471 L
s
.02381 .32006 m
.02756 .32006 L
s
.02381 .34774 m
.02756 .34774 L
s
.02381 .37542 m
.02756 .37542 L
s
.02381 .43077 m
.02756 .43077 L
s
.02381 .45845 m
.02756 .45845 L
s
.02381 .48612 m
.02756 .48612 L
s
.02381 .04329 m
.02756 .04329 L
s
.02381 .01561 m
.02756 .01561 L
s
.02381 .54148 m
.02756 .54148 L
s
.02381 .56915 m
.02756 .56915 L
s
.02381 .59683 m
.02756 .59683 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.03324 .18788 Mdot
.04267 .2791 Mdot
.0521 .2766 Mdot
.06153 .36025 Mdot
.07096 .38524 Mdot
.08039 .3805 Mdot
.08982 .42262 Mdot
.09925 .40713 Mdot
.10868 .42539 Mdot
.1181 .44851 Mdot
.12753 .5281 Mdot
.13696 .46174 Mdot
.14639 .55253 Mdot
.15582 .56963 Mdot
.16525 .51243 Mdot
.17468 .56248 Mdot
.18411 .51931 Mdot
.19354 .52132 Mdot
.20297 .59811 Mdot
.2124 .60332 Mdot
.22183 .59569 Mdot
.23126 .58682 Mdot
.24069 .53576 Mdot
.25012 .55836 Mdot
.25955 .55819 Mdot
.26898 .47763 Mdot
.27841 .44879 Mdot
.28784 .5182 Mdot
.29727 .51269 Mdot
.30669 .45627 Mdot
.31612 .40432 Mdot
.32555 .39699 Mdot
.33498 .39101 Mdot
.34441 .32847 Mdot
.35384 .32371 Mdot
.36327 .28706 Mdot
.3727 .31487 Mdot
.38213 .24784 Mdot
.39156 .20083 Mdot
.40099 .23468 Mdot
.41042 .2033 Mdot
.41985 .14105 Mdot
.42928 .13316 Mdot
.43871 .16537 Mdot
.44814 .14354 Mdot
.45757 .09046 Mdot
.467 .13226 Mdot
.47643 .0282 Mdot
.48586 .11269 Mdot
.49529 .02338 Mdot
.50471 .08645 Mdot
.51414 .01472 Mdot
.52357 .09442 Mdot
.533 .05 Mdot
.54243 .04166 Mdot
.55186 .07428 Mdot
.56129 .03467 Mdot
.57072 .03742 Mdot
.58015 .01783 Mdot
.58958 .07056 Mdot
.59901 .09694 Mdot
.60844 .14956 Mdot
.61787 .15972 Mdot
.6273 .16137 Mdot
.63673 .09138 Mdot
.64616 .18949 Mdot
.65559 .19123 Mdot
.66502 .14493 Mdot
.67445 .19242 Mdot
.68388 .21864 Mdot
.69331 .27593 Mdot
.70273 .21062 Mdot
.71216 .27306 Mdot
.72159 .26777 Mdot
.73102 .2531 Mdot
.74045 .36264 Mdot
.74988 .33909 Mdot
.75931 .37331 Mdot
.76874 .36344 Mdot
.77817 .3275 Mdot
.7876 .34278 Mdot
.79703 .37483 Mdot
.80646 .38647 Mdot
.81589 .41172 Mdot
.82532 .40507 Mdot
.83475 .39015 Mdot
.84418 .39838 Mdot
.85361 .42975 Mdot
.86304 .39111 Mdot
.87247 .39835 Mdot
.8819 .41515 Mdot
.89132 .39307 Mdot
.90075 .31844 Mdot
.91018 .31135 Mdot
.91961 .28306 Mdot
.92904 .33866 Mdot
.93847 .32472 Mdot
.9479 .3353 Mdot
.95733 .33387 Mdot
.96676 .29185 Mdot
.97619 .31298 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell["This convolves the kernel with the data. ", "MathCaption",
  CellTags->{"S3.8.5", "5.25"}],

Cell["ListConvolve[kern, data, {-1, 1}] ;", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.8.5"],

Cell["The result is a smoothed version of the data. ", "MathCaption",
  CellTags->{"S3.8.5", "5.26"}],

Cell[CellGroupData[{

Cell["ListPlot[%]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.8.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0117578 0.152304 0.114164 [
[.25897 .1398 -6 -9 ]
[.25897 .1398 6 0 ]
[.49412 .1398 -6 -9 ]
[.49412 .1398 6 0 ]
[.72928 .1398 -6 -9 ]
[.72928 .1398 6 0 ]
[.96443 .1398 -6 -9 ]
[.96443 .1398 6 0 ]
[.01131 .03814 -12 -4.5 ]
[.01131 .03814 0 4.5 ]
[.01131 .26647 -6 -4.5 ]
[.01131 .26647 0 4.5 ]
[.01131 .38063 -6 -4.5 ]
[.01131 .38063 0 4.5 ]
[.01131 .49479 -6 -4.5 ]
[.01131 .49479 0 4.5 ]
[.01131 .60896 -6 -4.5 ]
[.01131 .60896 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.25897 .1523 m
.25897 .15855 L
s
[(20)] .25897 .1398 0 1 Mshowa
.49412 .1523 m
.49412 .15855 L
s
[(40)] .49412 .1398 0 1 Mshowa
.72928 .1523 m
.72928 .15855 L
s
[(60)] .72928 .1398 0 1 Mshowa
.96443 .1523 m
.96443 .15855 L
s
[(80)] .96443 .1398 0 1 Mshowa
.125 Mabswid
.0826 .1523 m
.0826 .15605 L
s
.14139 .1523 m
.14139 .15605 L
s
.20018 .1523 m
.20018 .15605 L
s
.31775 .1523 m
.31775 .15605 L
s
.37654 .1523 m
.37654 .15605 L
s
.43533 .1523 m
.43533 .15605 L
s
.55291 .1523 m
.55291 .15605 L
s
.6117 .1523 m
.6117 .15605 L
s
.67049 .1523 m
.67049 .15605 L
s
.78807 .1523 m
.78807 .15605 L
s
.84685 .1523 m
.84685 .15605 L
s
.90564 .1523 m
.90564 .15605 L
s
.25 Mabswid
0 .1523 m
1 .1523 L
s
.02381 .03814 m
.03006 .03814 L
s
[(-1)] .01131 .03814 1 0 Mshowa
.02381 .26647 m
.03006 .26647 L
s
[(1)] .01131 .26647 1 0 Mshowa
.02381 .38063 m
.03006 .38063 L
s
[(2)] .01131 .38063 1 0 Mshowa
.02381 .49479 m
.03006 .49479 L
s
[(3)] .01131 .49479 1 0 Mshowa
.02381 .60896 m
.03006 .60896 L
s
[(4)] .01131 .60896 1 0 Mshowa
.125 Mabswid
.02381 .06097 m
.02756 .06097 L
s
.02381 .08381 m
.02756 .08381 L
s
.02381 .10664 m
.02756 .10664 L
s
.02381 .12947 m
.02756 .12947 L
s
.02381 .17514 m
.02756 .17514 L
s
.02381 .19797 m
.02756 .19797 L
s
.02381 .2208 m
.02756 .2208 L
s
.02381 .24364 m
.02756 .24364 L
s
.02381 .2893 m
.02756 .2893 L
s
.02381 .31213 m
.02756 .31213 L
s
.02381 .33497 m
.02756 .33497 L
s
.02381 .3578 m
.02756 .3578 L
s
.02381 .40346 m
.02756 .40346 L
s
.02381 .4263 m
.02756 .4263 L
s
.02381 .44913 m
.02756 .44913 L
s
.02381 .47196 m
.02756 .47196 L
s
.02381 .51763 m
.02756 .51763 L
s
.02381 .54046 m
.02756 .54046 L
s
.02381 .56329 m
.02756 .56329 L
s
.02381 .58613 m
.02756 .58613 L
s
.02381 .01531 m
.02756 .01531 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.03557 .50839 Mdot
.04733 .53036 Mdot
.05908 .5472 Mdot
.07084 .56346 Mdot
.0826 .57633 Mdot
.09436 .58514 Mdot
.10611 .59168 Mdot
.11787 .59744 Mdot
.12963 .60215 Mdot
.14139 .60332 Mdot
.15315 .60075 Mdot
.1649 .59426 Mdot
.17666 .5879 Mdot
.18842 .57582 Mdot
.20018 .56182 Mdot
.21193 .54692 Mdot
.22369 .53011 Mdot
.23545 .51146 Mdot
.24721 .4901 Mdot
.25897 .46662 Mdot
.27072 .44172 Mdot
.28248 .41489 Mdot
.29424 .38762 Mdot
.306 .36235 Mdot
.31775 .33584 Mdot
.32951 .30802 Mdot
.34127 .28368 Mdot
.35303 .25726 Mdot
.36479 .23158 Mdot
.37654 .20436 Mdot
.3883 .18111 Mdot
.40006 .15792 Mdot
.41182 .13779 Mdot
.42357 .11757 Mdot
.43533 .09965 Mdot
.44709 .08362 Mdot
.45885 .06842 Mdot
.47061 .05347 Mdot
.48236 .04067 Mdot
.49412 .03131 Mdot
.50588 .02277 Mdot
.51764 .01788 Mdot
.52939 .01632 Mdot
.54115 .01631 Mdot
.55291 .01472 Mdot
.56467 .01767 Mdot
.57643 .02344 Mdot
.58818 .02789 Mdot
.59994 .03728 Mdot
.6117 .04592 Mdot
.62346 .0595 Mdot
.63521 .07028 Mdot
.64697 .08521 Mdot
.65873 .09836 Mdot
.67049 .11268 Mdot
.68225 .13054 Mdot
.694 .14733 Mdot
.70576 .16648 Mdot
.71752 .18545 Mdot
.72928 .20382 Mdot
.74103 .22088 Mdot
.75279 .238 Mdot
.76455 .25405 Mdot
.77631 .27065 Mdot
.78807 .28704 Mdot
.79982 .30448 Mdot
.81158 .31891 Mdot
.82334 .33383 Mdot
.8351 .34831 Mdot
.84685 .36085 Mdot
.85861 .37244 Mdot
.87037 .38129 Mdot
.88213 .3889 Mdot
.89389 .39327 Mdot
.90564 .39563 Mdot
.9174 .39847 Mdot
.92916 .39691 Mdot
.94092 .39547 Mdot
.95267 .39235 Mdot
.96443 .38764 Mdot
.97619 .38369 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["ListConvolve", "MR"],
  " and ",
  StyleBox["ListCorrelate", "MR"],
  " to handle symbolic as well as numerical data. "
}], "Text",
  CellTags->{"S3.8.5", "5.27"}],

Cell["This forms the convolution of two symbolic lists. ", "MathCaption",
  CellTags->{"S3.8.5", "5.28"}],

Cell[CellGroupData[{

Cell["ListConvolve[{a,b,c}, {u,v,w}, {1, -1}, 0]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \({a\ u, b\ u + a\ v, c\ u + b\ v + a\ w, c\ v + b\ w, c\ w}\)], "Output",\

  CellLabel->"Out[19]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell["\<\
The result corresponds exactly with the coefficients in the \
expanded form of this product of polynomials. \
\>", "MathCaption",
  CellTags->{"S3.8.5", "5.29"}],

Cell[CellGroupData[{

Cell["Expand[(a + b x + c x^2)(u + v x + w x^2)]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.8.5"],

Cell[BoxData[
    \(a\ u + b\ u\ x + a\ v\ x + c\ u\ x\^2 + b\ v\ x\^2 + a\ w\ x\^2 + 
      c\ v\ x\^3 + b\ w\ x\^3 + c\ w\ x\^4\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ListConvolve", "MR"],
  " and ",
  StyleBox["ListCorrelate", "MR"],
  " work on data in any number of dimensions. "
}], "Text",
  CellTags->{"S3.8.5", "5.30"}],

Cell["This imports image data from a file. ", "MathCaption",
  CellTags->{"S3.8.5", "5.31"}],

Cell["g = ReadList[\"fish.data\", Number, RecordLists->True];", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.8.5"],

Cell["Here is the image. ", "MathCaption",
  CellTags->{"S3.8.5", "5.32"}],

Cell[CellGroupData[{

Cell["Show[Graphics[Raster[g], AspectRatio->Automatic]]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.8.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0047619 0.0238095 0.0047619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.02381 .02381 translate
.95238 .95238 scale
200 string
200 200 8 [200 0 0 200 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
9193989D9F9C9997958F8C8481807B7B7C7E7D7C7E7C787778777D7A787E7F817F848482
8282807D777776777A7A7D83868D908F929799999E9B9D9F9D9B999895979692908F8C89
838585899092908F939394969898999A999E9D9EA3A6A8ACAFB0B0ADAAADB1B2B3B5B7B7
B7BFC5C4C2C2C0BCB7B5B2B1B1B3B4B5B1ACACABA29E9D9D99938B82818080807E7A7673
72737576757577798383828283817F8185828283898C8A8B8E8B8A8E949898969FA2ACB3
B1B2B5B4B8BCBAB3AFAFAFADAFADADACABACAFB0
9194989C9C9A9A9B9694928982807B7B7C7E8080817F7A7774787D7A74757A7F82868582
83827C77797471747878797E828B90919294999EA19F9E9D9C9D9D9B9B9A9A9A97929092
8D898991958F8D949294979A9A979697969796999FA0A1A7A5A7AAA8A6ABB2B5B3B5B7B6
B7BBBCBAB9C0C4BFB9B7B4B0AFADADB4B6AEA8A4A7A1A0A29D928A8785878683807E7A76
74767878787A7E8085888A8B8D8B8A8B88888886878889908D8F919395989DA0A5A9ACAF
B2B5B7B6BCBEBCB8B7B7B5B1B2B1B0ADA9A9ACAE
8F91959899989A9D9696938B858582817F81848583807B7775797878767375797E838584
85837D797A746F737775757A82898F9192949AA1A1A09F9D9CA0A29F9F9E9D9D98949496
9292908D8D8E8F92929396999895979B9A98929196999B9F9C9FA2A2A2A8B0B3B0B3B5B5
B9BAB6B2B3BABDBBBABCB8B1B1AFACB1B2A8A2A1A5A3A2A39F948C8B8787868582807F7E
7B7C7C7C7F848889888E92939594918F8F8E8A848587878E8D91959695979FA6ACAFACAA
B2B9BABCBEBDBDBDBFBFBAB5B5B4B3ADA8A9ACAC
90909295979797989593918D8C8B898686868787827F7C77787A7578797476787D858988
85807B787A7674757673747980868B9094979A9E9C9D9E9E9EA1A4A3A2A3A19B96969694
90959187868E908B929395979594989E9D9C958E9096989897989A9B9FA6ACADADB1B3B5
BAB9B3AFB1B6B9B8BBBFBBB4B4B2ABAAA9A19D9E9EA1A09D9C97908C8A86858683808185
827F7E81868B8E8F8E9396969898959097948C84878A898F94979A9B9B9EA3A8AFAFABAB
B3BABDC1BCBDC0C4C5C4BFBAB7B6B4AEAAABADAB
919193959694939293929091918E8B888C8A8A87807D7A75747774787A767A7F7F868B89
857F787579787777787676797B82878C9297999A99999DA0A1A2A6A8A8A7A5A09B9A9893
8F8E8D8D8C8C8A898F9196999795979B9999959192939393919294979AA2A8A8AAAEAFB2
B7B5AFADAFB5BABCBCBCBBB9B0AEA7A5A5A09B989A9D9B9797958F8B8F8C898683818386
858282878B8D9195959898989A9D9B9495928C8585878992999B9EA0A2A4A6A8AEADADB1
B5B8BCBFBCBFC6CAC9C7C5C1BBB9B5AFACACABA7
8E90949695939394949490908F8D8F8F8E8C8A86807C787471717075797A7E817F858889
87827A777778767678787777798084868B92989D9A989B9FA2A5AAADACA7A8A9A49E9995
918C8C90908D8B8B8C9095999897989998939091908B8A8E8B8E9193949AA0A2A5A7AAAD
B0AFADADAEB0B3B7B9B9BABBAFAEA8A49F9C9B989896949494928F8E8D8E8B8381858785
87878A8E9091969C9B9A99999CA1A29C9B948F8B8D8F929A9A9DA2A4A5A6A9ABADADB2B7
B8B6B8BBBDC1C9CCC9C8C8C5BFBBB5AFABAAA7A2
8D8E9194959595979696908C8D9094928E8D8883807C787674707073787D7F8283888B8B
89837C7878787777777574767A7F8486898E959D9C99999DA2A8ACACABA7A9ABA6A19E9B
959494939193928E9193969797979897958F8B8B8A878687878A8E8E8F949B9DA3A4A7AA
A9A9ABADABAAABAFB2B4B6B8B1AEA8A299959998959391908F8F91918889868282868887
898C909294989DA0A09D9C9B9CA2A5A3A0948F8E8E90949A9EA3A8AAA9AAADB0AFB3B5B6
B8B6B6BBC0C3C8CAC7C9CAC6C0BAB3ADA8A6A4A1
908E8E90939595949698918D8F95958C8E8D86807E7C797975727877757A7F85858B8F8E
8A837E7D797A7A7975707076797F868D908F91969D99989BA1AAACA9A8A9ABA9A4A5A5A0
9B9B9C9C9999979397999A98979694918D8D8A87888B88818486898B8E959C9DA6A6A9AA
A6A5A9ACA8ABAFB0AEADB0B2B2A8A19F979396929495948D898D918E898381858685878B
8A8D8F90959CA09FA4A2A09E9DA2A6A69F9493918B8A919BA0A4A9AAA9AAADB1B2B8B5B2
B7B7B7BFC4C4C7C7C7CBCCC6BDB7B0ABA5A4A4A4
94918C8B929897949395928E8F91908E8A8582827F7A787A7977757778767A848D8D8D8B
898A87807D7A7B79736D6D75767E85888A8F9294969D9B9BA6ACA8A6A3A4A8A7A5A9ABA6
A5A19FA09F9D9B9C9C9D9C989593918D8A898585878482848680868A898D949BA2A3A5A6
A6A7A8A9A0A7ADADACADACA9A6A39E9B97918F91938E8E8F8E8C8A898883848686858482
889190929C9E9EA5A4A3A5A3A3A7A6A39D9A98979391959CA2A4A6ACAEABAEADAEB1B7BA
B8B9BFC2C0C2C4C5C4C6C4BDB8B4B2ADA39E9E9F
90918D8B8F94959492908D8C8E908E8986827F7E7D7A78777A78767779797C83898B8E8C
8988847E7A79797472727173797C80858C929596959B9FA0A3A8A9A8A7A6A7A6A4A9ACA8
A9A7A4A09E9E9F9FA1A2A099938F8E8C878784817D7A7B80828083878B8E8F949D9EA1A4
A5A5A3A1A6AAABA9AAACA9A4A49F9E9D9894918D8C898A8D8C8A89888783818384868785
888D93999FA2A3A5A5A5A8A6A4A7A6A4A49F9B9A9998999B9FA3A7ADAFACADACAEB0B6BA
B9BBC0C4BCBDC0C1C1C1C0BBB5B1ADAAA4A1A0A0
8D8E8C8B8E9293948D89898A8A898680817D7A7A79777471727475767A7E828786898B8A
8887827C797776737375747578787A80888F93948F95A0A39EA1A6A4AAA7A7A6A4A7AAA8
AAABA8A29FA0A19FA1A19D968F8B888682807D7A787474787B7E81848B8E8B90979A9EA2
A4A4A2A2AAACAAA7A6A8A6A1A6A1A1A19B9692898683878C8C8988888785848383868989
8E8E969E9FA2A8A8A6A7ACA9A5A6A5A4A5A29F9FA1A2A2A0A0A5A9AEAFADAEADB0B0B5B9
B9B9BCC0BBBBBDBDBBB9B7B4B3B0ABA8A7A39E9C
8E8E8C8B8E909090878384878381807C7C79777777747170707376787A7D818586868685
8686827C7A7576767574747975777A7C81888E909095A0A39E9FA5A4A7A6A6A6A4A5A7A8
A8AAA9A5A3A39F9BA09E9B95928E88837D7B797875716F70777E8384888A8A8F92999EA0
A1A2A4A8ABACACA7A3A2A1A19F9D9E9D999690888481848B8C8A88878083858382858B8E
94939BA19EA0A7ABA9AAAEABA7A6A4A3A2A3A4A3A3A4A2A0A5A8AAADAEAEAEADAEAEB1B6
B6B5B7BAB8B8BABAB7B4B3B3B1AFABA9A8A39A96
91908F8E8E8D8B8C878181837F7F807E79767678777371736E6E72787C80848787878584
8586837F7D7877777674737674797C7C7F868C8D94999D9E9EA0A3A5A4A2A2A5A6A7A9A9
A7A7A8A9A9A59F999E9D9A95928E88827B7B7B79726C6C6E777D85858487898C91989B9B
9C9EA2A7A7A8A8A7A3A0A0A29B9C9A9797928B88868283888A8985827E8283807F83898E
95989EA29F9EA3A9ABABAEADA9A8A4A2A2A6AAAAA9A9A7A5A9AAABABADB0AEACAAAAADB2
B5B6B7BAB9BABAB9B6B3B2B3ABABA8A6A6A19995
8D8F90908D89888C8A84828483817F7A79777676736F6E70716E6F767C81848486888786
86858383807D7A747477737174787B7C81878B8A93999C9DA1A29F9FA09D9DA1A7ABACAB
A9A6A6AAABA7A09D9E9E9B948E8A87837E7A7977726F6F70767A82838488898993989997
989A9CA0A4A3A3A3A2A09E9F9C9D9894958F8888888483858685827C81827F7E80858A8F
959A9E9F9E9CA0A8A9A8ADAEACACA7A5A4A8ACAEAFAFAEACACADAFAEB0B3AFACA8AAACB0
B4B7B8BBBCBDBCBAB8B5B2B2A9A9A5A2A19E9996
8A8C8E8F8C8785898885838383807B777A7A7772706F6E6C6D6C6E727880858584868684
8586868885827D76747773717475797E8386888A92999D9FA2A39E9A9A9A9C9FA5AAAAAA
A8A5A4A7A8A5A19F9E9E9B948E8B8885837B767675757675777B7F7F8589888A93989692
9496989CA4A29F9E9E9E9A9797949090928F8B8B898785838384837E81807E7F84898E93
96999D9E9D9D9FA3A1A2AAAEAEAEABA8A7A9ABABACACACACB0B1B4B1B1B3AEABA9ABACAD
B1B4B6B9BABDBCBABBB9B5B3ABA8A4A19E9D9A95
8C8C8D8E8C85818285837F7D7D7D7B7B7B7C78727174736E6D7072707178808082838180
8487898B8A83807A7674727675757A818484868B91979B9A9A9D9D9893999EA1A3A5A6A7
A5A3A3A4A4A29F9E9A9995908D8B8782857F7B797675787A7D81807D8486848B8E95938D
8E91969E9C9D9B999B9F9D9899928F919392908D8989878483868783848481828485888E
94969DA19F9F9E9A999CA7ADAEAFACABA7A9ABACABACAFB2B1B3B6B0ADAEAAA9A7AAA9A9
ADB2B5B7BCBFBEBBBCBAB5B1ABA7A4A2A09F9D96
8C8A8B8A878481807C7D7977777B807A757A787376797775727172737576797C7C808385
84888D898E8B86807976777A767B7E8383838B8F92959695989B9A9795989FA4A4A2A3A8
A6A1A4A5A3A39F9D9B9590928D84898B84817F7B75767A7B82878581828485848D8F9493
8C8D959A9C99979B9E9E9E9D9D97908F92928F8E8B8B89868483838484868784807E8186
8B949DA3A39D99999A9C9EA6ACAEB0AFADADABABACACAFB4B0ADADAEA9A6A8A9A7A9A8A8
ACACB1BBBBB9BABBBAB9B5AEACAAA6A6A29FA19D
8888868482817E7A7777747474797E7A737172767978797D747170747A7D7C7B7B828384
86898C8B8C8B87807C7B7C7B7A7E7F8182848B8D929291929598969296989B9FA2A4A4A3
9FA3A7A5A3A39F9C989A8D8D8A888B89868382807B7877788386837F80838484898E9190
8E8C8C8E949A9A9A999B9F9F999B948F91908C8D8E8C8A89878583808586868380808387
89949C9D9D9D9A999B9C9BA1A7ACB1B1B0AFB2B2AEACAEADAEAAA9A8A5A3A6A8A6A7A7AA
ADAEAFB4B6B5B6B6B4B4B3B0ACABA5A09DA0A49F
8586837F7E7E7A747575727171767B79706E707477797B7C7B746F71777A79777C848383
8787898A88898783828383807D81818283878C8C908F8F909292908E8F93999FA1A0A1A2
A3A7A6A5A5A4A09C9A8C87858B89878287858383827E7D808383817C7E838687848A8B8A
8C8A888A909495999B9D9F9E999C9A9491908E8C8E8A89898685837F8587888583848788
8B939999979594949697979CA4ABB1B1B6B3B6B4ADADB0ADACA9A6A6A3A3A4A5A7A6A7AB
ADACABACAFB2B6B7B4B2B1ADAAA4A0A2A19EA09F
8383807B7B7A75717473716E6E717473706C6D7275797A7878736E6E73787B7C80858382
84838586868889888788868382838484848587878B8C8E908F8C8B8C8B8C949D9F9C9EA4
A8A7A4A4A29FA19E8E85A78D82857E808283828486858385817F7C787A80848784888885
85878A8D8D8D8F9AA09D9E9E9E9C9D9B9393938C898585848181838281858787888B8C8A
8F909295938B898E909395979EA7AEAFB5B4B3B0ABADB0AEADAAA9A9A8A6A4A4A5A5A7AA
A9A8A9A9ACB0B6B8B5B1ACA7A19A999FA29E9A98
81807C7978757170706F6D6B6B6C6D6E71666671767576787574727274797D7F83838283
8181858386888B8C8B88868587858584827F7E818586898B8A8887898D8C8F969B9EA1A3
A3A3A5A39C9C9F9C91B8B1BD7D7F7F817C8183848786817F7E7A7975767C7F8488878785
82868B8C888C939C9D9A9FA4A39E9B9A9794908B847F7E7F7E7F83837E8285878B90918F
8F8D8C8E8C8583898C909291959FA8ADB0B2B0ADAEAEABAAADACACACACA9A5A49FA2A6A7
A3A2A4A6A9ADB2B5B2AEA7A197979593989D988E
7F7E7A78797570716C6B6B6A6B6B696A6C67666D727474747978767475777A7B81808183
8181868484868A8C8C8A898A8C868483807D7B7F7D7D7F8385848484888E9393979EA1A0
A2A1A5A29FA29E95A4A76EB6997A84807F8384848585817C7A767978797F818588858687
86888C8A8A939798989BA2A4A3A1989599938888817D7A7D81838282858688898D919292
8F8E8A858482818283878D8E919BA3AAAEB2B0AEB1AFAAACAFAEACACACAAA6A49DA0A3A1
9D9A9B9EA3A7AEB2B0ACA39B9694928F9397918C
7E7D78767A7973716B696B6A6C6A6466666A6A686D737470767778767576797A7C7D7E82
83828686858687898A8C8E8E8D8683817F7D78787575777A7D808181828B9395969A9D9D
A39FA3A1A5A69B9CB15B5286AF818181858586868585837F78757C7D7E82828685848689
8A8B8C8E94989796989DA2A0A2A0999595918986817E7B7F878884858D8C8B8C8D8F8F8F
8C8A858181807E7C7C7F878B90999EA5ACAEAEAEAFAEAEB2B3B3AFACACA9A4A3A0A19E9A
999696999CA0A8ADACA79E9597918F8E8F8C878C
7A7B7572797B746F6A696A696A675E5F6568686A6E70717470777D7C79777778777C7B80
8583838689898785888D8F8E8D86837F7D7B716C6F717476787C7F8284848A939797999D
9E9BA1A2A5A098AF8D415B82928A8283868587898784827E78767F807F817E818587888A
8C8A8C949A9B98999A9B9F9FA29B9C9A9091918581817E828B8B878B8C8B8A8C8D8D8C8C
87827F80827E7B7B7E7E84878D959BA2A4A6ABAEACACB0B4B8B7B3AFADA9A3A1A2A19994
9697979A999CA2A5A39F999294928F8683838287
76727276787674726A68656764626460636A696870716E71757B7E7B77787A7C7A808180
8282848987898B87858E928D8C8481817C7A756C6B6C6C6E747C8181828389919290939A
959C98A19C9CA1BB5343524C6E89888783838687847E7A7B7A7E7F838480808287898C8C
86868E94989C9C9A9B9A9BA19E9B9B9A948F8C8881807C808586898887888888888A8C8C
86827D7D7E7A787C7B7D80888C90999FA1A6A8A8ADB3B3B0B1AEACA8A7A59E9D9D9D9893
929193989D9D9C9C9C9A95908D8684817F7E7C82
73717174757372726B676263615E6262666E717175747071767A7C7C7B7C7C7A7B828380
8182848A87868889888C8F8C87827F7E7A77746F6A6A6B6D737A808285878B8F90909294
969298979C8EC28F413E352A51858D8683838383817D7C7D80807F838784828287878889
888A8E91989E9E9C9B98979C9F9C9A98948E8A8682807B7B7C7D8182838281848687898A
8885817E7C787A7F8586878C90949DA1A3A4A5A9AEB2B2B0ACAAA8A3A19E9899999B9893
929295999F9F9B969494908C8582807C7B7D7A79
6E6D6E6F706F707270696464625F6366666F7577777573727477797A7A7C7C7A8082807E
828585868D88888B8987868583817F7F7C766F6B696A6C6F74797E83888B8E8D8C8D8E8D
93929492898DB041373B292139748D8681828281807F7F808183848A8D89858284858588
8C8E92969AA0A29F9B9694979D9C9A97938C868483837F7B77767D82827E7D7F81808183
8585817C79787D848D8E8D9093979DA0A1A0A2A9AFAFADACAAA8A59F9C99929192979A99
999898999A99938B898B8C897E7C7C7A7A7B7673
6969696A6C6D6E70716C68686665686A6C727777747475747275787776787C7F7E817F7D
808484838984848888858584817E7C7E7F79716D6B6C6F7477787B81878D908C88868788
898C8D8C7FB77B2E30302C292F648C848385858381807F7F81868A90908B89888386888A
8E91969E9EA3A3A09C979596999B9997938B848484817D7976767B7F7E7B797B7C7B7C7F
7D7E7D79787B82878C8F8F9296999C9C9F9EA2A9ABAAA7A3A8A4A09C9C99908C8B919799
9B9B989697948E86818183827D78787C7B777474
676665666A6C6C6F6D6C6A68686B6D7077797A77747476747275787776787D81787F8380
7D7E8286837F7E8081838484847F7B7D7E7A7473717273767776787E86898C8C87838385
89868D7B98B93F2E27242F293064928888898885817E7D7D82888C908E8B8E90898C8D8E
92959AA2A3A5A39E9B98959598989594928D8786867F79787B7D7B797C7B7A787677787A
797878787C8287898B8F9094999B9D9DA0A1A5A6A4A3A09CA19E9B979898908C8C8F9397
9A9C9A97948E8A857E7A7B7C7A77787B78747575
65656263696B6B6C696A6A676A7073777B7C7C797677777673747576787A7C7D787D817F
7C7C8084817F7D79797C7E7E837D7C7E7C777577787774737574767C8484868988838181
8A868073B0722C2C2723312C355F8C8F888887847F7D7E8084888B8F8F8E929190909093
979BA0A4A5A6A39D999694939A96929193908B8884807E7C7D7D7A7A7C7C7A7573737475
7875757980888C8C919595979B9A9C9DA2A4A6A39D9D9E9B9D9B989292938E8E90909499
9B9C9A968E878380787374767678797873737774
626361616668666868686A696D72747A7B7E7E7B7978787876747376797B7B797C7B7A7A
7A7A7C7E7E7F7B76767A7D7E7C76777C7B787879797873717576787D8281828484807C7A
7B8179A0A43C2D24282731312E57858D86868684807D8085878A8D929291949293919397
9CA0A3A3A5A6A59F999694929995949494928E8A8281827F7B7A787C7A77747372737475
777373787F878D8E9398979A9C99999DA0A0A2A09A9C9F9D9D9B989292949090908F9297
979593918E857F79706D70727778797974737874
5F615F5F636462646766696A6E7171777E82827E7B79797A7A7775777A7C7B7A7C797878
7675787C7E7F7C7776797D7F7E7372777776787877767271777A7B7F808081817E7A7675
787673BE662B2831262B2F30225D908A86868786817D80868C8E9092919297969493969B
9DA0A2A1A2A6A7A29A9795949695989A95918F8B888483817F807D7E7B75717272717173
747071767B838C8F8E9495999D98999E9A9A9D9E9B9DA09F9C9B9995999C979494919396
939191918C847D756D6E75787A78787D78737877
5F5D5F636263676061686B6B6D7074778184827E7D7A79797778797B7A797A7C7A787775
7172777B7878797A797B7D7C797872707475757973737575777B7F7E7D7A7E7C7A74777A
71679B9E352734292B283831295D9088888B8A87838083888C93939391939A999B98989B
A0A2A4A6A5A3A3A29D999898979A9B9C9B938F958F8785878683817F7875716D70726F72
76707076787D878D909092979A9C9C9D97989694989FA19E9F97979A9B9E9E9896959391
8F8F8E8C8A827B756F70767C7C77787B79787874
5F6460606462616467686A6F7374767C81868885827D7A7A7D7B797B7C7D7C7C7A74706E
6D6F747778797D7F7C797977767672737B7D797878727073797E7F7B7976797876747870
6F69AD5D2A362D33272A3B2C325F958B868888868685878A91969596999797989B9A9BA0
A5A8A7A6A9A7A5A29D9999999DA2A3A19F999596938E898784827F7B7873706E70716C6A
6E6E6F73787E858C949596979897959493919296999DA0A39E9794969A9C9D9F9C98928F
90919190837D78757272777A7B7B7B77767D8079
5D635E5F646162696B6A6B7278797B808082838385827C787E7D7C7E7F7E7D7C7C746E6D
70767B7D7A7C80817D7876757177797A7E7E797779757376787A7B79706F767275767173
63AB9C30233B2A2C29352D332C58AC82888988898C8E8D8E939597999E9993989EA0A2A6
A9ABAAA8A7A8A9A59E9C9C9CA1A7A7A3A19F9A989A98928A8785817D7C74716E6E6F6A66
676D7071787D848D9496969594949290908F9297999BA0A19D9996989B9A9A9FA19B9491
9395928E857C7675767879787674777B7C7F8180
5C5D5D61636266696B6D6E70767B7D7E807F7E8082817D787A7D81827F7C7A7A79736F6F
72787E807E7E81827E78737271797D7E7F7E7B7A78797A79767677766B6E72717274726D
6CBB532829312C2A32403132365DB7828A8A898A8E9090908F91979A9C9994999EA3A7A7
A6A7A9A9A6AAACA79F9D9FA1A1A5A4A1A1A29E9B9A9A938B8885817E7C7675716D6D6965
646A6F72767B838C909393919195959390919596969B9F9C9C9A9A9B9C9A9C9FA39F9893
93948F88857C7676797B7A767270747B7F808283
5C5E5E63666466656A6C6D6F7376797C818284827F7C7C7C777C81827F7B787877757575
74767B7D808081817E77716F76797A7B7F82807D7C7B7A777677767170746F736F6F745F
A9822F262D313127394346333E47C38586878585888B8B8C8E8D9699989B9B9C9BA0A3A4
A4A6A7A7A9AAABA6A09FA1A0A0A1A1A0A2A3A09E9896908B89837E7E777578746C696766
66666B73777C83878E90908E909698979292939394999B979A999B9D9B9EA4A3A2A09991
8F8F8B847F7A7777787978757576767477808481
59615F636A6865676B6A6B707271747D828283837E7B7B7A797B7D7E7E7D7A7776777A7B
78777A7C81817E7B7A7876767879797A7C7F807F7F7D7B777576777478757674766E6179
BC4C2C272D2F352B3D40304F3655C17C81838280828687898E8C9295969DA09D999B9EA2
A7AAA9A7A6A5A6A7A6A5A29D9D9C9C9DA0A19F9D98938E8C89827B7B747475706866676A
6C666A747A8185848B8D8D8D91989A99979290919291929496969D9F9DA2A6A29D9C9993
8E8B86827E7C7976737377797978757171767A7C
555E5F626869696A6C6A6B707271757D807D7D7E7C7A79767878787A7D7F7C7774757A7C
7A797B7C8183807A797A7C7F7A7B7D7E7E7F8181807E7E7C767376797A767B73786C5EA4
812C242F2C25323D3A2D384C3A4AAC8080838280828587888A8A8C9092979C9A99989AA0
A7A9A7A4A1A0A3A8AAA8A39D9C9997979B9E9F9D98928E8E8A827A767473736D6A69696D
6E6B6B7179818586888B8D8F94999A9799958F8E8F8C8D9494969CA0A1A2A19D9B989795
8F878283807E7B7773747879747372716E6D7179
555A606462666D686B6C6D6E7275787D7F7D7E7D78757575757676797D7F7C7776777A7E
7D7D7D7D818786807D7C7C7D807E7E8387898885837F7F807A737478797A75746D6679B2
3A1D2D2F2A3948576D3A344A3A48B68181848382848787868488878B8D8D94969996979C
A1A2A09FA3A1A2A6A7A5A4A19D9A9592969EA2A19C9694938E877F777273747272706A6B
6B6E6C6B727B838A898B8F92979996929597918A8C8E90969496999DA1A09D9E9F979494
8E8380867C79797A7A7A78746D73746E6A6D7479
5A5B5D5F63686C6E6B6D6C6C7277797D7D7D7D7A7774747674717274797D7A787A7D7D7D
7F8181818585848485817C7C7F8381828A8D8886837F82807976767C7B7D7E75775EB57A
26212A324D73767B9873173D2D3CA58782838588888786848485868989898C909294979B
9D9C9B9CA0A1A1A1A5A8A59E989C9892969C9C9B9D9B97908B88837E75706E717373706C
67686B7276787E868B8C8F929393949594948F8A8C909396969A9C9A99999A9B9D9A9995
8D8785847C797C7F807A716F6B6A696D6B6B7376
58595B5E63686B6C6D6C6B6C70767C7D7B7A79797979787674717375797C7A797C7E7E7E
8284848484888A8C8B857F7E8186888A8E8E89868481827D7A7D7D7E7D797F7C6D88BC3C
222430388595899193A23C24473AA38382838486888886848785838283878B8D8F919494
95979999999D9FA0A4A7A49E9A9A98979697999D9C9B96908B86807B75706F727475726D
6A6A6C7175787D838C8F929292949798929392908E8D8E92979697979695969996969490
8C8C89827C7B8084837C706B6666666866697276
5657595D63696C6C6B6A6E716F737674787878797B7B7A7877757677797B78787A7D7E81
86888888878A8C8D8C888585878A8D8F8F8D8B8A85817E7C7D838381828178816ABE6E1E
1C33446E9B7C8199A5AF91073E4397847B8082858A8B8A8B8A88868382878C8B8D8F9290
8E929694979DA2A3A4A6A39EA2979296999A9A9C9E9C98928C857D77797472747675706B
686A6D70747A8083878D9292929596969C96928F89888E95938F8F94949292958F8E8C8B
8A8A86807F7E8284827C736F6D6E6D6B696B7375
56575A5E656B6E6F6B6B6D6D6A6D72737376797A797A7C7D7C7A7B7979797575797D8185
8A8C8C8D8C8C8C8C8D8D8D8D8E8C8F918F8C8C8B867E7B7E828383838180806D9BAB2B1C
315A6D88818E95A5B6A9B32A1D439588778085878B8A8B8F8F8D8B8782858B8C898B8F8E
8A8C908E9299A0A2A4A6A4A0A29B999D9D9EA1A29F9D99938D857D787A76747576746E68
686C7071747B8284858B9194969797979D9592908C8B8F928E8B8B9093908E908A868589
88858486848284827F7D77757375736F6C6D706F
5A5B5D60666C6F706D6F6C696A6A6B6E6D737778787B8084817F7F7C797875767C808487
8A8C8E928E8F91929393939293909295918E8B8886817D81858483847F837F7EBF63201F
5A8E8B8995B0928E8D88A76731448A92778187898D8D8D91928E8A857F81878985868A8B
878687888D93999D9FA1A19F9D9C9E9F9FA3A49F9E9C98938D86807B7675747576746F6A
6D6E7173767D828185888B9196969598969392918D8E908F8E8B898B8D8D8B8987838286
8888898D88878985807E79757374736F6E706F6D
5F5F6062676B6E6E6D6F6B696E6E6A6A6E727576777C82858381817E7B7B7A7B81838485
87898D9290929696949496979793939593928F8C8688858587878785838479A6A82B1354
AD857C97B08E72737771787D795475947C83878B90929090908D88848180808183848586
848283858A8E9398999A9B9C9F9F9D9B9EA5A49D9F9E9A928B86817D7676757374726F6D
706E70757A8083818285888E93918E929595938D898B8E8E8F8B8684868A898786858281
868B8D8C8B8A8D8883837F797575736F70726F6E
5F60616366696B6B6B6A68676B6F727371737574767C81838381817F7E7F7F8185858383
86888B919395989794969B9C9B979595959493918A8D8A898A898A89868683B960231CA4
997C9F9B8B8482818B988A6A6F6E5C8C86898C8D9092908C8B8E8A8584807C7A7E828281
8382808284878E949595999F9EA4A49F9DA0A4A6A0A19C928A87837F797A7773716F6E6F
716D70777B7F848482878B8F928D898B9093938F8E8E8D8C8E8983808185868584868381
858B8C8B8E8D908B8688857E7776767171716B6B
5D5F6162656869696A6A6D6D6A6C706F70737574757B81848381817F7F82828587868486
898B8D9195969899999CA0A09D9C9A989794908D8E8E8A8D8E898A8E8F83B39C3A135EBD
6A9D958093A2879CA09E7858716D6A85898C8F8F9092918D888F8C83817E7A7A777E7F7D
81817E7D82858C92918F949E9C9F9F9FA1A09FA19EA09C928B8A88847B7D79726F6E6F71
726F747A7A7B828682898C8B8B8784878D8F8E8E929391918E89827F7F81818183858585
88898C91909195908A8B877E77787A7675726A6A
606062646463666B6A6D6F6F6D6E70716C707273777D838585807C7F7F81858488868588
8E908F9198999A9B9C9F9F9C9A9A9A9C9B948E8C908A90908A8A8C928B96B2592423C4A1
717E8B98A7ABA3B1A995665B6A547C8E87898E93969493938F8C8A857E7F807D7B7C7C7E
81807B797E82868D8D8C939697999CA0A4A5A09B9C9A99958D8A8883827B797B76717377
7675797D7C7A7F85878B8B898783807F86888B90959997928E8A85817F7F7F7E7D7E8285
878C9292939594908D8A8785817C7A7975726F69
5B5A5C6063666A6D6F717373706E6C6C6B6E73787A7C7E7F7F7E7E807F7E828286898B8C
8E8F919393979C9D9B9A9A9A9C9C9D999292938F8D918E8B8A8B90938CB7823C1677DD5E
6B85C1A7A99DA2969382584D4E599189878C91939596928D918C8A888280817F797D7F7F
7D7A797A7B7F818789888E9197999B9C9FA2A09C989793908F8D878382807F7E7C7C7B78
7B7C7C7D7C7A7D858A8B8782807F7E7F7E828A90949796908C888381807F7E7E807E838B
8E9092939192918E8C8D8A8585817C797875706D
5A59595D63686B6D6F72757573706F6F716F737878787B7C7C7E7F8281818484888C908F
8E909394939698989795959899979899979290908D8E8A90908B8F8CA3B8522833B98552
67959E90938983717064473C41779086888C91949290909191908D87808184827F817F7B
7A7A7979797C7C818686898D9196999B9D9E9D9B9696918E918E8785848685807E81827C
7C817F7C7D7B7B83888985807E7C7B7C7B7E878E9094948E8C87838282807E7C82828890
93939392908F8E8A8789898384857F7A7B797372
5D5C5B5C62686C6F6D727675727376787873737574757A7B7C7E808486878A898D8D8F8F
8F91939292939496989592928F98989595928D908E92928F918E8B8FC5772D208085405B
8771594B6D78616A6444352D758F88919090909392919093908D8C8A888785808584807B
7C7C7A797A7C7A7E8688888D91959A9D9E9E9E9E99999592928F8B898A8A89868487857E
7B7E7D7B7C7D7E8084858381807D7A7A7F7F858A8B8F928D8C8A88878785817E80868E92
93949594928E8D8982838684838583807F7E7A78
5D5E5C5C61676D726F7476737377797878757474737678777A7E818588898C8B8F8D8D90
919190908F8D8D9092918E8D908D8C91959392958F8B92898B8B90C191461963A24D626A
5275653A4553525C4E4535278295909BA1A3A09D928F8B8C928E9094908885868284827E
7C7B79797A7A797C8588888C9293969B9C9B9DA09C9897969493928F918C8C90928F8880
7D7B7B7A7A7F827F8182807E7E7C7B7C8281858785898E8D8C8E8E8C8C8C898382878F95
97959596948D8B8781828889858587868281817E
5C5E5D5C6064697070747574767978737675737374767675777F838789888B8C8C8C8E91
92908E908D8C8E908E8E90908B838993959CA19B96ACA9ABA29DA88B462769A26C498D5A
4E54222F475C4A524F39212971946F605C637699A8ACA19E8E8D8B8A8D8F8B8584827D7A
7A7A78797978787A8186868A9090949A9C99999C9A95959796979793918E9095938E8A89
847F7D7C7A80847E7D7E7D7C7C7B7A7C7E8186878485898C8A8F92918F8F8E8B8B8A8E97
9A939093958D8885838589898885878681818381
5C5E5D5D6060636A6E717476777674727473707276757375767E818486868A8C8A8E8D8D
91908E929290928F87878B8990A0ABA49EA49D888B635A60789D86452C299FB16555594B
2C2332324567260F1822352834422E2728324159667D97B1C2B197837F878C8C87817B79
7C7B797A7A787A7A7E8484878F91959A9D9B989696949496979796958F9092938E8A8C8D
8A8682807E80817D7B7C7C7C7B7877797C8185878887878A898E93938F8C8E9191908F93
94908D8F928E8986878B8D8B8A86858585838281
5A5C5C5E626060676D7075787670707270706F747A767074757A797C8184898A8B908B88
8F929195948E8C898694A7ADA28F6E5A59534B4C3E393D3C3C484834355B9483543C3F32
212019202A230E17222D2D332C2E303D404D4B484A646B6A889DBCCAB38C7C8283828181
807A797C7C7A7D7C7E8384868C8F9193959794909296969697949295919091908F8F8D88
8B8A878382807E7C7C7D7C7A797676797E8283878C8B87878A8D92938D888B928E93918B
8B8F908F8D908E898C9294928C8985878C888283
57585E6260606264676F707374706F7071717072767572737572797982818889878C8D89
928F9392948A8AA2A899796B5A564A4B4850515455554648524A3D39526B8C714533251E
211E1818151E2729292E353E404445474B525453555054606368717EABC1B19174798581
7F7B78787B7B7D80828384868E8D919392949696948F92979C969595999191928F8F908C
8B8E8781848580807D797B7C7A78777C7E81868988898A88878A90928E898D949394918B
88888B9090939395969695908B8886888A898684
595A5F615F5F626465686B70727173716F7374747574716F6D78777F7F7E7E8180878F8D
8C8F8B8B8598AB9066584C4D534F4959514D4F4D4A484E4945494E626D7F72604C442727
20262525232931362F3F3D44444E474D505D594D404D534A55566358617393BACA966C81
7D787A797B7D80818182868A8C8C8D909293959492959194989C989999959496928B8B8E
8C8A8786858381817C7A7C7C7C7C7C7F848484888B87848688878A8E8F8E90949997918B
8886878A91989C9E9D999590908A868A8D8C8783
5A5B5F61606061626262666B6C6F74727378787371717170736C7375837B818482868587
84868E99A8A0755053585650514F54524C554C4C4C4F4748534F536790BDB4644C2D2924
242E2D2F3135373A3D4142433A4445414F4F5350514E574D51485157635E5D679CC3A66B
7B7A7C7C7E808282818386898989898B9092939391919098959C9A9B99999795928B8A8F
8D898B8D8A8786847F7E7E7D7E807F8085878485898682878987878A8F9194959895918E
8B898A8E959DA2A3A09B9A97908C8A8C8E8B8887
5A5B5D606262626161636669696D7275787B79726F707273736D767A7D847875747D98B3
C1A5B5A28A6948505A464E51494649484C4F3F4D41534A44463C5681A6AC84482C31302B
2C312F3234353536413944413E3F4D434944404F4E4C424B4A5150575E565B535673BCB9
667D7F8181807F7F81858685868786868C90919393908E91939B9C9C9999969190908F8D
8C8B8B8C8B8A89867F7D7D7E80827F81838A898383848486878A8E919291919296969593
908B8D939AA1A3A29F9D9E9D918F8D8D8E8E8D8B
5C5B5B5E63666664656969696E70727879787673707172737175747A7B777994A9D6BAA0
89826B4D4646525147363D4544483B4046414046474247454C505F7B7F442F2A3A313330
313130353132373A3639433E44434D4C524A4C465D645A504C534E525656615951565FB2
AE6F7E82827E7A7A7E83858586888684878B8E918D8E958F8F979E9E999695928F93938C
8B8E8B86888B88837A797B8084837E80858A8B85818384828A8E92928E8D909497979695
9491949A9FA4A4A3A09E9F9C97938E8D9398948D
5F5E5B5C62676868696B686871747176787573706F7173737279796E6B8CCACFB5856E5E
51403F34383D3F454738363842433D3C3E444947524B4847555A657269433E3E3D333235
33302F3532363E403E46484B434C50534D4E555C5D69564C544C4D4F50515254645E5B68
BF7C7580837F7B797A7C81858789878484888A8C8C8981808F96929D98929496908F918E
8D928F8A8B8C86807A797D828581797C85848789868383828D8F91908D8C909696959394
999B9FA4A4A6A4A2A1A0A09D99989492969B9992
5F605C5B5F6466686A69686870736E71757473706E72747274706490B9C89C6B644C4F41
373A3E3B363C373E3B3D4A423C313E41464C4A564C5652525E5A666A5C554A423D413A2D
2E302C3031383E3F3F3E3F4E444D4E515A5B5F5C5A525C6760504C4C4B4E4C4F5A5A5B4C
8EB87882817E7D7C7A7A7E8487878684848789888385A7B5838B9695959191928E8B8D8F
8E8D8C8A878583807F7F7F7F817D777A8283858888858487898C919694908F9199999799
9EA2A5A8A9A9A4A09F9FA19F9697989897969594
5D605E5C5E6062656B696B6B6E716E6F717476737175756F6074B4CFA8765049413E3B33
343A3531424139393C3F39453E3F433F485154615A5867626364655D55504A534B39312C
25302E2D2C31363B332E2E44524A404C5B695D5F6B6D6E6C585855555051575152615F4C
52B7A4717B7A7C7F7F7C7F848484858585898A8581A9C2BF7F8F8C9092928D89898B8C8E
8D83807F78777F828484807B7C7C797D808787858684848A8B8D919694909094989C9EA0
A3A6A8AAACACA6A29F9D9E9B959495989894908F
5D605E5E60606166696E696C6D686F74736F77767476606DBCC8AB785D4A423C3B322730
352F252C2F3A3E313B4044363A38475458575761686770757474606055574F3B362F2B34
37232C30403A3C281F2B4B4D493E414858555C605D67636464646F645D51564E464B6353
5160AE7C6F7C7D82817D838286857F8B8B8484869F7C92917E8A8E9393928C889087827B
807886B3B99E79858982847A78807B7B7B7E8286878686868D8F919092979A98959DA0A1
A7ABAAAAAEADA8A3A09D99989795919394928F8A
60626463626366666B6A676C726D69737674707B73598FCFAC87604C402928352F2F2C2D
29292B332E3044422B3145452F30414F4E5259575F6D6B7276736657474B3C32372D3424
2C303255553A2E2C57A0A1593C38363C455054615A68727172676C6D6D584B4E4C444D56
584F75A096887E8187848186838680CFA97D8097714EA38186858D9193868F8C817A94A0
ADD2CEBDC2BE966A8384807F7A777E7F777D83868788898A8E93959390929494969DA1A4
AAADAEB1ACAAA9A7A39E9D9D9C97949593939690
5F62686865686B6767656F706F716C6E737472675BB9CD82583D2E282728343C30353632
292927222C2E3E7370262A433B3A3B453D3B4F4D4F544E5C6252403534342F3F3B2A3850
462E3B3725324D686A6A1D2C3E2C2435443E505A636F5F6E927E6860655F5257524E4B4D
585B4D678BA39784828589828C7C9CA48488906E437FA27C7F8589858A938A8384B5BEAB
E0C59B948484B0827F7F7B817E767B7A787F868888898C8D8E939593908F8F8E949BA0A7
ADAEB0B5B1ABA9A8A4A1A2A39D97959690929994
5D62686968696A676A666A6A6C72707072736677C4B06F4934242423262F34313339392F
25272B2C3222223266812F2B3F3A393C46453D41433F48514E3925333332495B66AA8B5B
44636447382C3C302B1A3A4A4E6A7374464D5A5B5F6B71787D796A6D7376675B5C666856
5B5F5C5C5D638A978581878D8588B26A6F8F724164999D797D8B828C8E837BA2CE9688E0
D39CB6A57A7F8392857B7B7B7C7A797B787F858686898C8D8E91919091908D8A90979DA5
AEAFAFB3B6AEACAAA5A4A5A39A97969791919693
5C6266696A686768696D6B6E74726F74736289E1A1583C222B2731363C3C352C2C333635
322C272532282C2A2363752C32493B3445433D4346434D4640382B3A4653636F8F953B62
CAB767303646575A626C888157543624272F3C5D586E6D695861688483807B6A56636F60
65575B605D5D4A6A9E9784878A8B9F634E79414D9D97BB727C8488837785B7D38D7EFBC9
A5C6BAC494AB6B84867F827C7D7C7C7D7B808485878C8F8F8F91908F91918C898E9499A0
ABB0B0B1B2B0B0ADA6A5A49E9997949596959590
5A5F63676C6A696D6B6D6F6F6D72766F63B7D07A43282A3831373D363535322C2D2C2C2E
36332E2B26282F2E221F6E68143D4337414A4A4C414345403F455156516A72603B3B6885
58324FA8CA9974684D372F1D1E2529384F4A424C57475D656E72717F727385816E666A61
67645C5A5C5150475DA8BB8280AC90612637649E9B81C08F65767B80A4C3BD8387F9C7AB
CBD3CDC5CBCA956F80807F7A7D7B827B7F818385888C8E8E9194928F908F8C8C9195969C
A8AFB0B1AEAFB0ABA3A2A29E9B968E919797948D
595D62666A6C6D6E6E6C737471726B649EB764413A373A2B363738393C3737352C2C302E
2E2D3233251F344637162076402B4436395C50534A4D49423A4059565D544B49655E473C
60767F854910272A2B474D5D62757188958864554B5F4F636B7071716C7283857C727A74
6D6A676558554F51465FA6C0C9A9703F2C64A9968087B0DF917B9FC2C2AA6D95FC9E5DC7
DEE1C2C0D3CFC75F78797E75787B83808080818386898A8A8F93918E8E8C8C909496969B
A5AAABAFAEAEACA7A3A2A1A09B948D8F92939189
5C5E6365666B6E6A6A6E6F6C756D70A794594E55463B342B363A373234373F3A2D2C312D
2B2D332E3B211933585A1624853A383F36505F57554E443B3B4C5D46504D595D5B687259
4F4440355BE1CBA179716A7447494538282A30383A48595B62677479807E797B7C818071
72696A60585F494C564B638F8D6F422E4FB5C3767C888DABD2B6B0AC8173C7B43F89EBBD
C7C0CBF2CC82508F686E8A7D7B7E7C8381818386898B8D8E8C908E8A8C8C8E939596969C
A3A4A4A9B0ADA9A7A8A5A09E9B9491928D8D9087
5C636466676568696C706F6E646BA797525053513F363730302F333730343D3B352D342C
32292A2C3136201F437D330C686823483951655C5B4E4843425055474A5263686553514B
5B66716E8DAA603729291419181C26232C2C2D383E2D31465466797C82837589897B646F
74776B6C695F55514F525C5C4F5B46469BDCA4968376697378AA9B8270DFA347AEE7E0CF
BBDAFFDC3E3A84E05662927D80817D85848888878A8E8F8F908D8C8B8B8E9395969A9D9E
9FA0A2A6A9ABA8A8A6A2A29E999693908B8A8986
60616865676865636F5C5E698CB3915A584F4E5B453F39333B2A232E332F3331303A3331
2B25322E243233221E4571290F62634A555171645558534C45454D4F485C5C4E5A5C6976
6C594A4431173E5E7C807D79697E687E6459A1988478686050485D718275867774897B77
767D7064644E53554E5656534456477FE2DCD096856E6E7AB6B4637CF0815BCFFBEFDF90
F4EEA34878AFAABA615E9188837E7F828B8E8D8B8C8E8F91908B8A8C8D8F9498989C9D9C
9B9B9CA2A4A8A7A7A6A4A3A09995918E8A878582
5F6566666C646B786597BD8892775A584B4D54574D332E325C4229232A28333933312D31
292A26262A27363B2714696914487B3C5E5A706C5D605B5B574B4A4E534A515B605B553C
464750B9B283D2CABFB0A59C948D76834F6C76646F6C645F554536627F7E7D757C8A867B
88787E77725D5A584D565658504E65BB4895B390858477949C707EB9685DD7F5F4CB9EEC
A36A5F8CB7A7B5A76A5E8C8C867E83868B8E8E8C8C8C8F938D87868B8D8F9499979D9D9C
9B98989DA1A6A5A4A4A3A2A19A938E8C89878584
62656364606A8F708CB18F7B5F4E5651525552414133404E4E4A3C201F26343934312931
2C2A3030281C283C40272C6F521873564D57646D656B6B625A555050494F545963606C7D
8C78686C5F4E2613192017221F191616393A1E20302A31343F4E3660746D7C7680798080
957F847F646253585C6057545544918C1953717F8F947D7D7C8E915B89FFFDDD6E98FFA8
93A3A5B0B8D7EECF4C62938A87868884898C8D8C8C8C8D928A8584898E92979894999998
9A98969AA0A5A39FA09F9E9E9F968D8986838182
646666645C678F5F585C5E5B4D4D514E4B4B474D45434E60525C572916212F313935352C
2E31342F2C28373B4748203E8A16536F335E5D7E78746B595D64544B575B6A6E65646655
3B493E2B2C36497676827E747F786E64635A61645A4856474B54483E3F768D6F7C798286
848A7F7157676568665B515857597746535C70879D977F8285877CA8FDFFAF4BA8FE9F99
9795D3D4939469856B78988A8A898A8B8A8C8D8E8E8C8A8B8986868A8F96999895979493
969695999DA09E9A9A9B9A9B9C958D8884807D7E
65656862625D7763445347484E4F414D543E37535748537A60655F3C1B21353A372D372C
32372C2D2E2F3B35434946287B46218C3D55596D76706E696A64575F5A6066645F65695C
9BA8A3B3B9ABAFDFC2DADAB2C3B4B1ABA78F8BAAA4989D8B99927D6D55556F86827C8784
7A817C79796D6C6A6B675C63545D5C3B333C6C90968D888E816AA6FDFF7F50DDFFE6A185
A4F4D98E646594876F6E908F8F8C8A88878A8B8C8E8B87868686888A8D93969498989695
96969595969698969597969795928D8A86807C7D
6B65685F5E5D7C644A53534F54523F444D4356736751596A545B5E5E2F1D32373B3D383A
37302F3235373A2A35455A3A367417747E48587F8775717A756A645F5A64656666646364
684B454040442519282A1B28352B283C444E3A4850655667686E8F84875E517E817B8884
8B81828C8878786B6763626662534F54434243668F7D8080A2F3C1C89F89FFFFFC7D7CE5
FFAF9BB6A5C0A877606B968D858C8B85818688898A8985838385898A888A8E8F96979A9B
98969492918E9394929391919192908B857F7B7B
6B6C6662614F79705860706865545B54526FA1A24A5472615C666A7F4018333A3E453E42
4045343031323F2C1F3A4C63384B4035954D57788E7D787B69708162646C686B716C625F
5782987D826C84927076654F45515554513E3A443348493D4449594D4B616276838F8E88
96948D918684806E6A626A615D525D5E59483B42566B84A3CADBFFDDDCF0FDFA4377F8FD
D6A6AFA0BAA5756E7871928F8B888187808688878888858283868B8C8784898D92939899
959394928F8A9194908F8D8B8B8E8D87837E7C7E
6E6B6765634E6E8E6C767A746C6F8DA1AAB4A352467C70536A788B845D2F3149404A555B
56514F4234342729182839596134381655694E567D7C837D7078797971757A6E797B7B83
949D9A868E99B09E8B9FA0A9A4B0AEA5A6AFA392AFAEAEC1B6958C907D76776F8B92908D
8C958D81849E767576737265695A56554E4D554C424273B6B1A3E7FFFAEFAD3FB9FFFFDD
83948FA2A0848C757B82928E888B8481828183848888828086878A8D8C89898B8E8F9192
918F8E8C8F8889868C84848386858784807E7C7F
6D6D68635C5A538E9697AC908B93B0BAB4A263334F9A724F617C85806A34305E47575E65
645E5A4D4C40342C291A28414F3B281F3167606D7D837E7C7E817D81727D7D72796B6062
4A373F3838251B122A2F3D4D4654504C52565E4762708994AB9A9BA7A5A698A3758B9199
9C948C8F8A817D7C78786C7678676760575150524A364E5F80B3FFFFF4F293D6FDFFD86D
7EBCEACFCFA2765D868A8B8A898985817C7B7E808687828088888A8D8E8C8987888A8A8D
90918F908B8A84867E82807C7F83847D7C828283
706764635A5B4C9AD2CBCDD7B8B89A85715A3A3672826967687A6F6892413C545F5B6867
646963605C473B2F33232B3538475E4B3A5B5E728F897474797C808278797D7C807F8C8D
9CB8E2CED6BDA7949275734D473B323E544F4940383728333D444A6D6D70987F8BA89890
9A959196857C87867C7A797D6C6C716C655E5E5D544B463751A0CABEFDF5F5F99C9E7FAD
F7FC9E798E6A5E659A968B8C8D87867F7A797B7D84878484868B8F8F8C89878680828387
8F9291928A7F82877D7F777A797D8281807E7D82
6E6B6D6665605264684E406C7682BD9F5C4C334895846A706C7A6A8B9C3C505D6563646D
6F69686A5F534B423B5251495A788B7E675F656B7D968079878886897D7881827D75736B
65687D719CB4E9FEECD0E2D8CD96827D6A7893B795937280899BB79E969DBCA69FA5969B
9A8E9089828A8C89857B7D6E736D636F6C576364625C535459476580FCFDECA091DAFDFF
E2A7968C848F8B6A9E8F85888A8588817E7B7B7C82868485858C908E8A8786857F7F8288
8D8F8F8C837C7F7E7E7A7C7D807F808183827E80
6C6D6E66666163525152574D4C4943C791563D68A87A6D81727C7EA96F3E5C6969686E67
72766C8575654C3A448B816B868F7A775C65707B7F877A868E86827F7B80878083838193
82623F2C2D1D1B344D696F94BBC1DBEBA4A68A73738B83A2BAB7DCBCA3B8D09BA2A08E94
9C9191859492877A88847D7B7A7A6B6D6E6B78676C6369595C473850608570D2F1F2FFA1
6E737EADB6A17856A6858182828386827E7D7C7C80848283878B8C8A898885818382888D
8C8C8B8584837B7E807475737E84877F7C807D79
686C6F706861605C595A5C5A5D594579A4385BA2A469707D7E77A2A4644C5E6D696F7371
6C6D747A7B68584B4C675E727C7B7F716360747E7A6871908B8990847C7C857D80827987
8E9CC1BAC9B493825A4532333C3D5978ADC6DF99996B6865556B728487908E63919B9D9C
9A959992868B837888857A7A747272706F6C6F655F716C6B6157575A4D3290E8B3CEA471
9CB6BFD69868566EAB7E7F7E7E8589887F7F807F81838284888B8C898887858284838A8F
8D8D8B8484807B72728C84947E7D83827E807F7C
6A6F696963685E595C575A535C604D5FC23470B5836C78838FAEABDF5A48606E746C7774
6A747E857A766A544A4C42567A7F8A797F5B7F8560728A938D949285807982848485766F
3B3E4C7285CBC7BEC9AEA46E63472D32365C65749DBABFE5C6AD8289929E949BAA9198A0
99969685848D87818384847C6E7272696A6D6E67686A6B60645A5F594D5B5755B4C1B3F1
B78C622E2A3C4D87A4787D7D7C808383848484818284858A8A8D8E8B888686858283868A
8D8C88847F6F849AB4D6B0B69E847B8184837E7B
6D6B666B67635F60605B5A57575A5257AB56AF975F6D8B8BB2A1DCCD3B59697271716F74
7A7475837B7064644E372539717A7C7C78646E93808899998F938A807A82857C76788092
A9AD784F241A1B446D84B0AEB8B18E6C6A77645F5551497197A6ABE8CCA4C2BE9C9EA196
999385878C858689848B8D848079696F7A70716E6E6E6F686968595E56573B537D7EB177
31273B454536489E92707A7E7F7E8184888785808083868E8F8D8C8B8B8A878484868284
8B89818179C1F4D8C0C69C689C837E828181817D
6C696867646565605F60585A5659525C7B70B46C6B798AA1A1E1EF6546546F7475717B72
7E817879847E70604F48292F50697B7E7F635E9F7F789F9B948C827975837F7E6F787677
6D919F9EA49664582D28464F6EA0CECFC1A180AE94908A7C5A5C7F797D9DA07C93AAA69A
A49886878F889086888F8783848F82817F7E777A77726E6665675B635C5A5851475D6869
7F938771606A59B57D7274787A7E7F85898C8A838081868C8C8E88918D8B8A858085818B
827E94CA96D8EBC9A57C4052778F7A80857E847C
6B686969646567626361615657575B617283815E758CAFA5C8F985404D5F6F7874787B7D
777F887578827D5B5959502D37657F7E8577519E8A829F988D84817A7F797E7A867C7188
A694716271B2BEEFDA7F4C33303D628CB0B2BC89717B98C5BFBEAC8C7A817A98A7A79DA0
A399998F8A93918B8F9C918A89848E9189898C7B787C666F6B6D6A64615350494142515F
5A5B715B5A676FA66D6C7378797A7E858A8E8E8987878A8D8B8C8B8C8B8C857F7F80877B
8AA4B5B2DADEB3925D61A8A67990808783828084
6B666768646769636662625B5E60526C848F6C6D879DE1C8FFBB3C3B586A7A7D77818181
77808678707C7D645A57956252757D8586855A7F9E879B9F7E7578777F7C7574708E9583
68A7C98E5C152559BFC2D7B1633D3C5046678DB29792916A9191B8D1BFD4D3BAA09599A4
9E91978F8F948B928E959095918A95918F89897C757C816E6273625F6560574445383435
21657A6D735E7D726E70707477797F848A8D8D8C8D8E8D8C87848B888988818381807B9A
A8AFB7DECFC07574A0B6B975588F868179898685
69656263656767646263615F5A5B5A849EA07872A7BEC2CC83644C42647A878885848186
807C847F7B7E7D664D5AC9C96D7E77857B867A738DA1ACA29389705E716F6E6C806779BC
A7675A7AD7D3A2752A2F699BB7BE836C6B6557505EA6AECBD09A6E7A7875929C9796A59F
989B9C999489889794918D9099999A9299938C918F808776756E615C615854515141342E
30617D6B766F6766707471757B7C828384898B8B8C8C8B8B8C88898187887F787682AA9C
BCC5C4BEB08F9DBBB69F755B749D868182858386
64656261666562646362636060557190B6926C8DCAAA7A7C684B4B5876788F99BC898983
7E7C798181838365556B88977784797C808B8159B79CA4A6A8FFA87552666C6B73756958
82C1AE714163A6D9F7A359383794C39CA499A47E78514F7BA3BAB4A6CF87ACA9A1A6AD99
98A5A09199959F9A98918F8E97939499989B9499998A868588766E5E5D4E4D564A4B4A40
3D486D71676B6B6C6E74727376777D807D858A8A8A8A88898A868A8D86767783A9A2A8D4
C7C9D4B7B6B9AD98898C7C877F908A878983868E
6064636366625F625D59605F645D6EA0A96B6CC7B9615479674D74828184A9B6A5818073
6E6E6D888E867D63586B4740618685807E818E638782919FBFD6B0CBAC714973856B6975
4F4585EEBD814F1479E3F4C2693040768A988F8FBD9C9E85587799858F93A6A9ACA9A3A2
A19B98898F96A0919A928F969592909A989D959696918F877D837571736C5C5A51544C47
463D64776867706A6E727273757678787B7E81868C8E8985868C8578748FACB98DB5CCCF
D4C8DAA9A9CD98919F969F9E6379958983888A89
6161626262605E5E585A6362626E80B67E5DBAB5875DA39F837E8F7F8E93816F5D797475
71797D93837E7C66595E473A6F8B877F7E7E8E6D6C717090A08978B5B2AC7C5D6C986F50
9189433E62B5C7964A1E54BFD5B47E685B789081748196B5ADD1CDA6878797A4ADA59BA7
AA96999C989A9897A69B8F93929995979C9D999894958F9B908C7B7472705F5C61584E53
52424868766E686168686C6F71757473797B7C7F868985817D747A96A8B5977C97D3CEE0
CFB5B1A2A3B3ABB9B37F85826D828D8A888C8C8E
665E5D5F5D5E5F5A5A5A5F5F6276A5977083B39E98A2CAA88B89737E7F8584666D797B6E
70A57D7D85858D6A6558392872848E84878674726D716D98798A88715A84B7754B558278
586E98713F2B55BFEBA7381E57A7C8B8906E436A8169807E7E93BBC5B8B098A9A2A59F9F
AA9D95A09AA1999D9D949195979FA49EA19FA69D9CA09696938F897C737673615C5A6152
4F544847536B6475655F6059565F6872767D817D79787B7F919EC0C9957C79A1C6D9DFC8
A4A5AD9EB1899A8A9C9785737B9F898A8B858891
625F5A56575E5F595E5B5E656C9AA9817BA5AFA9A6A69883725E7F9969636B7D837D7373
90DA926D908D886B5F65595E75858A8796897A734E9675A17E7D8763687698C595625369
815456998C6B2F267EF2FDB85D3D4C97A59480897E9083A5AB97727287A2A8A198A4AA9E
9AA2A696919AA6A6999A9792999B9B94989FA19B9DA09C9B8D898A8E94817D766F686954
586259494D464C627B8B9EA19A94836C69677174869DA9AFB2A6977F778894ADD2DEB1A7
C1DDB3B1A5899FAEA799885A587D90838585868B
645F5A5756585958575F575C8BBC90618A9FA2AAABAB9176657EA98A4A384A67828A797E
91A88C7B92948D71605D8F9878868A868E8583795DAB6A9D917F7E6573808097F8B27A60
5C5E4E3C6CA38B5E3D3890E9E2A47A57638A8F8B85A4AD8A84A2B6B19795A69CA2ADA29C
A69EA0AB91A7A59E9EA7A19194959F999B9F9A99A7A19C9B8D929A95938A84867C74726D
70645E56504645435A6C8BA8B6B5B7C2A8929AAAAB9B8F8C8B837D7A87959CA3E3A49FDE
D5B38B8BA4C7B8AAA6916A5E5C808C8381818388
67605B58545254575B595C69BBAB7E69938A87B8A698917E89AF9A7E634C373559877D79
8B6F6A7A809195726169A571818B8C8A8F8380745F72738E9080646A798A8F8D9CD5BA97
815D6C73585381B09A5C292B708EA59D807A6B767D918DA99693A29B9AA6AAAAA19C98A2
A6969CA8A2A9A0A4A29C9DA09C9E9C9B9B979F9F9D9A9292939B9D979C968C84787B7381
716F6B625E5D5C565353586165646D7C8D9B8A70706569878F8C837A858BB5C88DCBE2B5
83717CC9F4DDAF9B87787094618585827D7E7E81
66605C59534F52565C5A4D8AB88E767863787A96A4969699C1916F729297885D31748A74
837B7882878892786787A25A8A8F8D8E998C7E7A67959C738E937379868B8E968D8BAEB9
9E907B7E815F496C8C9BA25E2E345FA29B9C73789D93959EADA1B6B29B9F9CA09BA1A2A2
AAA4A1A3A2A3A3AFB0AAA59EA59EA49D9D9E9BA19B9AA3A69899A6A49F908C7E8291767C
7C7C787071716E69696262645F60645F645E626C6F6C78818C8F8A878FA8B0AEE49E7E68
8BD9D2B3A556616C6F95846E6B90807D7C7F7F82
625F5C5852505355565B4FA6A97F797E9D92968E8FB39CB38E73645B5F80C0BD4C456A79
767D7E80949592776194997A9293928A8F897A7C7181777C978B7C7B838997949C927BA4
ACACA1726F806F6C485191C08A5D59515C7CA7ADB9B6AA9FA9BCA99E99A6A3A19FAAAC9E
A5ADA5A0A8A4A4A5A6AAA4A5A4A6A0A2A49DA29A9FA7A5A4A19497A88586978E8E897A7A
81797E867F7877788179798079757C7A7E83807B838B908A8590979DA093A299796194C9
C99861585590A09EA0947A646A94807E7E807B7D
605D5B57535254545B534AA9988E8DB3CDC298A9BEBA9BA963545F644F2C3285713B4476
797F83848CA8997A679A8C88999B9F91878785847358778C958C877880959B99898B968A
939A9CA38072767976615E788A8285979161678FAAB7B1B0B8AC959C989CA0A6ACA7AAA9
ADA69EA5A8A5A5A9ADA89EB3A9A3A5A0A4A5A19FA59B979B9C919293969291929487918D
8385848785807E888586858C8B8585848C85898A8D929791929D978E9DA9B28D9BCACBA6
836778A4B2B99B96898170616A958482807D7879
625D5A5855555555565957596AA2B3B2C1C0B5DBC388B9826B8C7944372E332F72584075
9081819A88968D787694848B91979A978C8A8E8D6D74867B938C8C8C818DA69387969B8F
848FA2ADAAB87A5D666D7B756680AAA0C1B3915D779FB09F929AA39DA3A5A5AAA8A6A0AA
B59C97ABA6AAA5A5ADAB9DA4A8A9A5A7A9A3A8A1A2A29D9DA2968F918C9296A29C8E9898
8F96867F8B92898D868B888A8D8F938A8D899496938F939C9AA0A59B84AA999C9B917C7F
8A99A79DA1AA8787826F6C6F7C9786817C7A7D7D
655E5A5A585756565659585063B1BBB7B5AAB4CCC2B1997D907B42433E364537456F5062
8980819B958A8D74778E8990979E939A9787898A7B6F647E978985828CA2A49B83939B90
90969D98A1BEB7927C6769727974628585ACB19EAEB4978E8C90A8A8AB9EB2ABA5A5A2A8
A59CACAA9FA8A8AAABABA6A4ABA9A8A7A7A2A6A7A6A4A39F9E948E828E9399A1999B999F
9A9B9392929996928D8E91969197A2989197A0A0A9A1959FA0A1A8ABA5A69D8F9290959B
989C92867F7D898A786E7D57839183817B777A75
66605E5D595B5B565855545578B2B2B6B7BBB0C7DC9A6E767F3A48535D49424922797B56
847E65ADA37A8E6C85908B949996999A89908F8573856164808B8F9290A8A3938C878A89
9799928D8D81859A9D95736A78858B554E6B7A86A9A29697999CA5A6A4A5ACAAA1ABA9A6
B0AAAFB0AEA8A5A5ACA8AEADACB3B5A7A1AEA6A9A8A5A8A99A8F898D9895A5A49BA4A6A1
AAAC9EA1A298919A989A93A5A198969E9C9299B6B1A29C99979BAC9FF1FFB7BAC9A9AEAF
A1A18786A8B9A798987D632D8F897F817C747670
6765646059585A58555A5B5156B09CA7AFBEB1B9BB8D5E9E4D404F5E575C46493F428B6D
65785D554D708A778692938E9496949390908D8E7A84745278849C9399A3A29D948F928D
94A1969B9091928D8F938C928AA1B28D8F9C9E92989B999995A3A8A5A5A8B0A7A2AAABAB
9EA5A9A4B0A8A8A7ABAEAFB2B3BDAFB5A5ADB0AAAEAFA59C989A90848D9BA59A9FAEA0A5
A7A8AEB1A289A3ABA796999DA0A4A4A195A58CB1B2A7A0A09DA0A3A0856CB7BCB2C8AAA8
A7C895A69F92888F7456636E8F897F7F7B747471
6966625E5C5B59565A54595A4956B1A5B9AAADC4AA6F8287434F63551D2F854451418776
637E71545A8785818C9698908F999E9C988A858A7D775932647B918E9FA7A49B8D8C99A0
94A299A5919895988F8E9189908B958C94A8B293A19B999F94A6A3A8A4AEAEA3AAA3A6AB
A1ACAAA3B5B7AAACADACAEAEB1B9B6ADAFB4B8ABAAB39B929F9D8A8498999BA7ABABACAB
B0B0B1ADA68F9FB4A3ACACA4A09E9CAFA99DA7ACAAC0A39EAC9C96A4C4C19B768F95946E
6E6E747C686E7B7B7B646C628F89807C79747375
6965605E60615C5858565C5B5D4281CEB49C96D8876F965C4B6467313A116873584A7280
5C798A70849381838B8F90938E919D9B93848683816C626350659F929FADA6968F92949A
9C9B979F9AA4939F97988F8999978C969E909C9F9BA2A3A696A3A9AAA2A6ADADAA9EA7A9
B0ABA6ABA8A2A7A5A1B1ADB0B3B3ABAEB0B0A2A9AFB69C99AAA89B9C95959E99A6A7A7A4
A6ACAEABA5B0A3AFA09EAB9A939899A7A4A19B7F9594858192D2BC84B0C3BDA28F84898C
867E7B797A7B92938B69744A8E88817A7875747A
666663616263615F5D5E5E605B5242AED4A191BA887D8C5349794D2D302D2A7D4B4A657F
6670808F8A93858494959599948F949591888B8086ABD0A362798F9E98A7A399979D9798
A5A0988E95A49FA29A989A8C929D979293A5B6A2A9A4A3AAA19CA8A7ADAAACA29E9FAEA7
ACA59FADA5BAA7A2ADADA4AFA7B1A8AAADAFAAAFB0B4A8ACB0AEA79C9E9E9DA2AE99ACA4
9DA59CB6A2848E93907F83A0A2A090908F999C9A7DA4C9BFBFF8EE8267C3E1CADAAE8E9D
9E9C88786E696E765B5F853C8B87817B7978787F
66656463646563615F615A5B5B615A3F93A59C99739A8D3F686F2F3238371851553E608A
746A7C8A8694807F9A969699928F8C9094919491A2DBA7746D95849DACA59C9A9AA49D99
9B9E9C959D9FA7989F97A38E95969D95959599ADA4A9A7ACA1A8ACAE9BA0A0A2A6AAACA3
9EAA9FA4A9A3AEAAA5B1AEB0B2A7B0AFAFA4ACBABDBCB1B3AFA6A5ADA49AACADB2A69E94
9B83808495DBAB98FBC1F1FCADB9DEB8FEDDD7C5C7EAC7BDD2BFACB3A26F7A828295927D
A1A0A09B837A8979747B764F8584807E7C7B7E83
686666666566666365615E5B5F5B5E584AADB38C7CAB786A6F5E323A3936336B7F384D85
696D8888868F7C819898959A9492878B8E8C9198A6A4858579988697A3A6A9A5969A9CAB
A1A09899A7A3AA9A9F9B9A9B9F9A98A09FA19BA89EA3ABA5AAB49FA7939D9DA3A5A29F9E
A2AFA6ABABA4ABAEAAA8ADAEB1ACB1AFA3ACACB9BAB2B1BAB2A6A2ABAFA5AAADA29C8996
9FA4DDB9FEF4C0F8D1A8D6A891A6B69B97A299889392CC95B0C5A39DA2948173787D807B
58484C53627C7C747A65725C7F817F82807E8484
686A6F6E66666A6A656763615D605E615271BDA184CA736C765A2E384334426F973A62A5
687A908B9287777E94A89C9A918C8392929091938E829A8F74808B96A6A7A19E9EA499A4
A6ACA59DAAA9A6A69E9CA3A1AC9A9C9DABC396989CA7A2ACA5AE9FA4AB9BA49FA09AA1A3
AC9D98ADAEA6ACAAB0A6A2B1B0B2ACAEB2A9B5BABDA3AFBDAAADAB90A195A6987DC8DEFF
90FFDCFEFF69D1B1958891AFA0A3ABA79BA29EA99D97999A9FA59189849EB98D836F7882
7B84836054464452465776597A7E7E8583808784
6B6D696C6D68686968686460606363606052AF9A87A26B839958243338353A4B9B4F6DBD
5493AC89938A898AA099959C9C9586909894919788849994867A829EA2A78B84969E9FA1
A6AAA09BA1A99BA79AAFA6A8A6A69EA6CD9FA09DAB98C3A5AD9A9CA0A998A5A5A7A4A4AA
A79B96A6AAB3ADAEABA5AFB5A8ADA6B2AF9EABA5AEC5AEADACB4A28A95899DB3DEFCFEB7
B8FB9AEE8DAAD3D7B3A2E6F4DCC9A8C0C2B2B1BBA0A29D9F8F8C898E7890AC8F90878283
7D868F979987767C61646C487A807F8186858786
6A6C68696A68696A6868666261626362675D5B8C86A2946D9B523C35393C4931B46A6193
59B89C8A918B86929D909391909A918D888B9093969F9C9C897790A0A09AA19895989A9B
A59598A0A4AD9AA39AA09CA09BA3A2AEA6939EAAC0B19D9E99A7A5A5A3979B9EA3A69DAB
A4A0A7A4ADA499ADB3B0ACABA8A9A7AB9EA7A2B1B3A7AE98928F91B5D4F9EFFDB5A3BB93
D9A1B38CB2FFC4BED2FFA5948C88BDF7E8EED0A0A5B1B1A28C848A7778707885809B8D85
7D85726C6E868F95828181527B7E7E8186888886
6B6D69696A6A6C6C686867656362636465665395A792A26198695F4347453B33C9886582
6A858A8B97958D9C9E9A9F878D9A958B848C928C9AA1969F96808A9693909F9A95989BA3
9F919AA39CA19FAE9FA49B9F9BA0A1AC9A8BA7A8ABABA59C98ACA7A19F9EA6A9A5A9A1B2
A0A1A7A4AEAE98BDB89DA8AEABA3B692A2A4AAA5B5A08E8BD5DCEEFDFECCC6E9AABCB8D2
D2D0BEEFFFECD4CFF5D08FB3BBB694C0D9E1D2C1ECBB9BA4908086807C76757D6A6F7877
7578848B726F6B5A65766B5182817F8085898685
6D6F6E6C6C6D6E6D686767686663636467686358B7A28E529B91B79A755D385AF9945692
687F8E93979599A0959CA38E92948B86868E9388918E98A5A08B778891959596989C9DA0
9E9F9CA29DA0A8A9A3AFA8AEA19DA6ABA19CA6BBB1AFAC9AA8A9ABA0A2A5B3B0A5AAB6AB
AAA8A3A6AFAC9FB9B4BFBEC0B1B0A8A199BBA6819CAEBEEFFFE9E2F8ABB8BDACB899E0F5
EDF3EFF4F5F5FFF7FFE7E1EBEDC6C6B8AAF1EEF7FFE6D0A7958689807A7C657588706770
6B7887A099796D65686F6F3A8684818082888586
6F7071706F706E6C6A68696A69656363666D6D5C76AF7F5594C29CE2A6C49372FF8C9FA1
5D8B8C939C8D9EA3969B928C938F858285888D877F8C9598A08E6F80969AA19DA5A5AA9F
9CA3A5A9A5A7A899A3A5ACB7ABA8ABAF9FABB7B4A7A7ACAFA3A1ADA6A0A09E96AFABABA7
ADA994B5ADA7A8AAABBDB6B3A6B99EAC928FBDE1DCF4FFB6ABCEAAC6B7C8DCB7CDDDCDD0
D8D9F7ECFBF0EDE0E8F2DBD2C8AED2D9DDCCD0C8D3E3F9D38C958D878185866774836E6B
6D6A66607373746E726F753F868A868280837F81
6F6F727271706D6B6D6C6C6C6B686564656C6F686099985E75CC7B7BBBCAB0A8FF89F971
6085909EA491A09C9CA4908F90928A878C8B8C858380768EAC917A7F999DAD99A8A2A8A5
9D9CAFAFA1A6A297A0A8B0A6A0A0A2CBA9AACDA69CA6A4AEAAADA8A49EAFA7ADACADA8A9
B2A396BAB2A8A4BFB7B0A2AEA88FE1E7C7EBFFFDA6FFBDA2B7A2B9A4F7D2ADD9EFF2EADE
FCECF7EBD2D3B2C8B786879AA6A5928A7493A8A39E99F2E393948F95897A72706D6B7F6B
677572655C5A6A655E6471397B8A86837F807B7D
6E6C717270706D6C6E6F6F6F6D6B69696B6A6D6B597FC872659DC161A3C5B5C1A89AB175
6A93929A9297A9A3ACA894928E95908E98928E8995A67963A7A88689A8AAACA1A6A1A5A9
A69CA9A69EA6A29BA3AFA79BABAF9DB0A598A29CA8C2A1B3A8B1A5A9A8B2A9B0A8B7CCA9
BAA2A9A1AC9EC9C1A6ABCBADA1A0FCFEF6EEEBAEBCBA9FF4D9E58FE2CBCDD2D3DFFAE6EF
FDEAD3978CBAB48B6F9B7B7A7371616661585D6075A7BEF0DFCAA5968981827074696678
6873826A66665B5753556E386B847F7F7D7E7D7F
6F6B70716F706D6E6E7071706E6D6E6F6F6C706A675EB97C6876B0CCABCDECF2A5B09366
8FA2989FA3A6A6A0B0A1959A8A938E8E9A918F928D87917DAAB9968EA5A096B19FA5ADA3
A5A6A4A0A1A4A39EA7B5A99FA2ADAD9BA8ABAAA3AAB5A4AAAAB3ACB3B4ACB0B6AAADC1B0
AEACB3AACFDFA1BCB5A994B2E1FFC6C1E1B0D28EC7D0F5B7C6C9C0FEE2D8EEEAF5FED4E7
BCB59F8E93876E6B6C6D6263676A6F6C6C67675E575974C491ACAE7C92837B75696A6961
6D6C63645E5A665A4657754167857C7B797A7A7C
6B6B6E6F6F7173717072747071747275736F6A6D6D5C78CA897382AAC4DDF5DFC5964D89
B99C9595ADB0B8A797A19B959999968B9C968C83939A8C6285C8A691A199A4B09EA8AAA9
A7AC9E99A3A6A4A8A9AAB1A4A9A2BDADA8B9A7A6B6AFC5B0B0AEB5AFBBB3A7B8B6C1B8BC
97CFCCDBCDC7AEB4AFB3CEEBE7FF9EACCFB8ADE5D6FFA4D698C1F7F4F8D4FCFDEDDDDE9C
7FA281696A71726E6F6B6D72727071727171696669615A604C95E59F9C84797E706D6769
64676A605B5C5B544E4B68405F7B737376707277
6A696C716F6E70737173747274757271736E73646C69598BBE7C7385A2AEACC4A7823EBE
9A9596A1B0B0C7C7CBA29FA0A59E94958B879AA0A6D19FA7A2ABB78E9B97A7AD9DACB1AA
A3A5A4ACAAA5AAA8B2A9A6A8AEAFB0AAA6AD9DD2AAB0C4B1B3A4BAB3BCB8C8A8ADB6C4C8
CDC2B2B4959193AEFCEDEDC7FF9BD8DAA5E4E8D1E6809ECAEAFCFFE5F1E2E2C477A8968A
97895E6D928378757472717070727677716F6966696A66636557A5DBB48D8174666F6B61
5F6160685C414748545C64495778716D73727372
6A696B6E6D6D7073717574757776736F6D706B6B6C676258AABD8B727972698E98467D9B
839CACE0C5ABD4CFB68E8BABA1969E99A0DACEC3DAAE87BAD0A3CE8D9A959CA6A8AAA8A7
AFA9AAAFA9A4ADB3A7A4ACAFABA9A5B5A6A5A5BAAABBB2B3B2B2BABCAFDBD4B7BAC3E6AC
BEB5B2AFC9B5ACDEFFFAC0FDB886F2BFC6CAD5E8A7A7EDFFF6E9EDE8EDE5CFA7ABD995A8
966747754E7288747676767472767876716C6A6A6C706F6770675F65A78D898171636168
5961616C73564438353E59384C77716A6E71736E
6A6C6B696B71736F7076747678757570706E6E6F67686A5B5FD3B78A7D7C7498704F9592
C8D3D9E4CCD2D8BE89A499AE9C94A5B8E2F7ECD7BB839CA0A4B3B88C929A9A9FACB0B4A7
A5AEB1A0A5B1ADAF9D9BA9AAB3B1A8ADB4B1C4ADBABFB5D7ACDDAED7B7B1B5F9FFDCD2BC
BAAA9A8EF6FFE1A2EEFFFDE3B0FFFECEECF0EAF7FAFEFFFDE6EBF4F3FBE3BFD0C2B6C3A3
853D302B200765877677787777787773726C6D706F6E6E6D6D716E69617190827F5A5966
5C5D636167867C7167526C4F4776716A6A6C706E
696D6D6B6D71716E7177757676737471707072686567646C5858BFB3AE9BA1985682B0DF
ECDDE2DED9D6BF93B0ADAAADAAADADBAFEDDDD967888A5B1ACAE9A919BB4A1A3BAABA9AF
A9AFA797A4ADAFB897A4B5B3B2B1AEADAAA6BCABCBAECDBBD5E4BDD3D1B9DCDCD6D0A4B2
CBB8C9CAFEEEC1C7E2AAE2E7F5FBFCF4FBFFF7E8FFF6FFBC98EBEFE4EFBDA7BFCAD0D76C
59323932584136847A76757778797875747372716F6D6D7172726E706B6064797F6A5D53
60555D58565960696868806045736C6A69686C70
686C7073726E6D71737877757472716F6D746C6A666068676B5C688EA9AAA1828AAABCCE
C6C6E5E7E4F290B2CCB2AD9A989EBE948A7A7E8798A8A8ABBAA0929EACA2A3BDB6A6B1A9
A2A9A4A7B2AAB2B1A6B0AEB0ADB5ACA6ADB4B1B1CEA6C8A0CD9DD9B3BBEFA8A798B0AA88
FFFEFAE6FEE3E7FAEAD1DFAFDAD9F7F0FBECF7FEC3B3B196C4D6DCC798A4A8E3A3828344
43453E423F4E40577B7574787B7A7978787C766E6E6F6F71716A67676C685C6877745950
585D646F595659595453624B446F646869676A6F
686C7175736E6D737477777473726E6D716E6D6A62626661666D69645C9ACABDAC9FB4B8
CAD1C9F3E7C7B07F8BA59A9CA09F888A818993979CC0B59D9C9DA59BA8A2A7B4ACB1B3A6
A9B5B6ABB2B0AE9FB6B7B1B3B6B6ACB2AABEB0D2BBC4C6E7BCD1CCABCDC4A8ADB8B1DCE4
EAFFE0EAF8F1F6DDFFFDFFDFF4EEF5F4FFCDFDE0B8D8EAFDF7CDFCA897EC8775693F4355
4B3C39504C5165467672747A7C7B7B7A7A7E786F6D6E6D6E6F676B63636568606E735D4F
414D556665615B54474D674B436E616668676A6F
696E7171717070727474777373746D6C6E6D68626363626868676F6765689DB1B6AEB5AE
A6BFB6C0E0D7CCD3A798969C908A81908E8D95B49E919DA0ACA69EABA8AEA9A7A9B5AAB7
BCB5BAADBABBAEB5B2AEB5B3C1AEA8BAB9BBBEE1A8E0C4EAC0D0BAD6AD989895F5EAF8F5
FFD4BFFFF5FAEEF3EBF4F3F1F9FFFBF5FF968AD1F0F6FFBDE5CEFE8F80F45A3251674F40
51523945464E7F55737173787A7B7D7D7B7B79756E69686B6C7067656562676B62787D4D
433F4E58636E6453494557504170636667676A6E
6C6E7070717373736D71737271716F6B6A6B676263646465656567686E646AA2B9B6B2AA
B3B5BDBEDFDCD1D9BBB4A69C999A94A1A48FADBD89959EB0A4ABA2A2B4B1AAAEB7ADA9C9
BBB1ADBAC5AEBFB9B5B9BFB6B8C4DBC3AEB7CABCB3CAC7ACB7AAB085DAFBEBE5FFFAF6FE
F5C1F3FCF8F8EEF1F6F4EAFEEBECE2DDBC8ABEFCE2EBDBDBF66F86F0873E505A4C52583F
3843594F3849735B6E7870737C7C807D7D7A76726F6A686A6A6B67626467696C7168786A
48434548545E5E64503D46583F6C62606365696C
6B6D6E70717373726C6E6F6E6D6D6C6A6869676464646464626063636E73605390B3ABB2
C3BDD0E2DED6D6D9BD8DE6C29F9F70CFE3EED37783979DBBCB9EAB9EA2ADB9D2AEB8B7B9
B7BEA9AEB1BCB2B8C2DAAEC7B7D7E0CDC4C8DBB1D6B7B9BAD5ABB9CCEDF8FDFBFBDFE4D7
DFF5F1F6FCF4E9E4F2F6FFF2F2D4BBA9A3E2FFFFCFD9FF8B9EBA9F775046575F543F4044
3F33454E534446666D767373777C7B7F7C79746F6C6866686565656565676C6E73716082
7335383B48444B594E42494D436A61665D5E6968
6C6E6F70727372706C6C6C6C6C6C6B6B6968676563636463645B5F66686D6A6263B4AFA9
BFC8CEE0DBE2D5DBC4D5EFE3E2EDA0CEF1FAE19B909CABA0B5AAB1A9B3B0B4B1CEC6BDC0
C4AFC0BAABD1C5C3C8C5DDD1C9D0AFB5B9B5B4C1BBB29B95A6D2FAF0F2FFF2E9F8E2F4D4
E9FEFBF5F1F1F3FDEEF4F4FAE2BEDECDEFFDE8F2FAD8A64796FF67446156465160514143
463A38434B4B54435B7D6E70747D837B7C79746F6C6867686966696B67676A6A6C6D6959
68663E4041414D4D434838450C6C686361636467
6E7072727272716F6E6C6B6C6C6B6B6C6B696A69646362605A5E6266656568695476C2A1
B6D2D7DECED3E6F4EBE3DFECF7F9C0D4F8BE8E9E8D99AAADA6AFB1C0ABBAACB3D7C8BBE0
B0C7B3C8BEB6D8C6C7BFE1CED2CFC2C1A699A782BEDEFCE9DDFDF0EEF7E6DEEBFFF4FFF1
F7F7EDECEBEFF8F8F3FFC4E7D1F5EAFAF0CCB9FFDC3E86F4905A6F545156564C4A54483A
40443B343845543A3D86706F767376797978736F6D6B69696A686B6D6C6B6C6B69676060
57666E3840453F45383C3945026B656161616267
6D7072727170706F6D6B6B6C6C6B6A6B6D6C6E6D6763605B5A62626163656765654D8BD0
A6B7C4CADBE9EEF8EBDFEBF2E5F5ECADF7EA5D6E819B9FB1A4B1B0BAB7B5B3ADBAB7BCBC
AFAAADBABAE7C0AAC8C3BFBEB8C6B6B1CACBCEE1D1E8FDD1F2EADEFAE4E1FDFDF4F5EFF1
F0EFEBEEEFEDDDDBF6E5CDEFF9FBE8E4D6D29AA5868ACEDE5D4F6864525459503F474B45
3540393E46404742617D6E726C7376727475726F6D6C6968696C6C6B6E6E6A696865585D
5D5A67643D2E4548423B3D3E126B636161605F65
696C6F706F6F6F6E6C6B6B6D6D6C6B6C706E6E6C66625F5D5D5B6068645F6163675F5FC5
B2B7AAB6DCDDE3EFE5DFDFFDFBE8C67D7AA39C92809A9BAAA0A5A6C59D97A9B4B9A3B997
A5BEC190B0BCCFA5A8AAC3A6A7A19DAFFFF9F6DED5FEF0BBDDA0EBF9F8F4F7F4F3FCF1F0
F0F3E6E1E4E0E1DBFCDDD3F8FFE7C9FEC4898A58C4F878447F60646C5C4D414D4E3A3D49
443F3A45494544354F7A6F71726D6D74707473706F6E6B696B6F6E6B6C6A64636163635D
5D5C5B66755D333836423F2E306A636364636266
67696B6D6E6F6E6C696A6B6C6C6C6C6C6F6E6C6965615F605F5B5F60606467686663537E
D2A6AFB8B1BCCEDDCDDFE2E38A8D87745F7F9AE2D4AD77C2CCC18890FFC8DAD894EDF9DF
D069D7EDCA9DBBD0D1B387DEF1F0D3D8F3F5EFE9EEE9F6FCE2E4F4FBF2F9FCE9F2F6EFE7
D9E0D7F2DFD8EAF5F6F8FFD9B2F0F9B473A0B09BADA05366736C53545F4E37354A443F3C
43393D373B4B433959796D6E6F6B6F686B717370706F6C6A6B6E706E6B6764636060615F
5B5B5D5C5E6B714A4A33414E675F59635F5F6865
68686A6B6E6F6D6A65676869696A6A6B6A6C6B6A68625D5E5E5D5E5E5F5E5D6665656255
9CBEB8B7B4B8BFACD2ECD469A5BEAFB6AC86B3B7E6E2AEFAD3EA999BFFECE1E5BDE9ECFF
EE8AFEFEFCC5E0F6FFECC2FAFDFFF7EEC1FDF9FAF6DCF4F1F7EDFFEEFAFAF5F7FBE1C7D6
FFE2F1F2E0F6FDF8F6E7D1A4C5F15C86B3B2D4F85A576E65676E565A56535439393C3C3D
323E413D384D5123676B6E6B6A6A6868666D706E6E6F6D6A6E6E73746C666564625D6060
5F5C575F5C5E626473625F665C5957595E5F615E
666E6F6C6E6F6C6C6664676A686768676868696865625F5C5C5B5B5D5F60606063636560
559DC1B1ACB4B5B7E3E7EBD1FFB48C939FB3BAB4B3D8E4CBF0D3E3E7F5FBE9FDF1DBFEF8
FBFCECF8F4FFF7FAEAF3EEFBF3FFF8C1FFEED5F3F4FFF3F6EFF6EBE0FEF1E5FBECDADADE
D4E4F0D1DCBDD4EDDDBEA6CEFEF6B4E8FE9E82886666796B58526C75463B595035383641
393E38453C3D393D746464696B6B666667666B6F6D6B6C6C707272706D6A66636161625F
5A595C5E5D5E5E5C5A5D605F5F5957595B5B5C5F
666B6C6B6E6F6C6A67646363636364646161636563615E59595B5D60605F5F6060676464
60578EAFB3AAD5CDDBE5E4E5F7E1B2959B94B0A4A6979FE4FFE3E9EFF8FBDCF4D1EAFCF2
DEF9FECFF4F1E0FBFFF6FFF7D6F8F7EEFCDDEDF9EBF6F6F5F4F1EAF4F5F1E2D9CEC6DDD8
C2D2C4D9C8DFFAC9B69FA8C6FFEEFFD1C77B666E6767737B6E555E6869453742443C3A39
3D404241413E2B5371656265666666666866696D6E6E6E6E7171706D6A6867676462605C
595A5D5F605C5D5F5E5D5F615B5A5B5C5A595A5C
6769696A6B6B68666764605F606060615E5D5F6262625F5A5A5C5D5E5E5D60626364636F
675F5283AFDDC8E3D5DEE5E7EEEBE0F6E2C6ADC6C1BDDFE3ADF4C9CEEAC2D7F9FADFBDBD
CEF1F197D4DDE7C2F6F3FAF7F9FEF6FCFEF8F9FEF0F3F0E9EDECEEF2E0D6EAD8E2EDE1DE
E8E6DCD1E4FEC4ACA8B0BCD7F1F3CB6F686E61586F6B5E5A737558525459443D45403E3A
37403E404141346F67626266666668666765676C6E6F707071706E6C6968686A6764605C
5A5C5F5E5E5B5B5E5D5C5D5E59595A5956575A5A
666566676665646363635F5D5E5D5B5D605E5E5F6060605E5E5D5C5C5D5E6163616A6B69
6464586BBEB8D0D0D0DBDCDDE9E9E8D2DEFAC6A1C6E1E9A5E0F0E9FAE2D9E0D4FCEBC3EC
FFEEDFF7FFF6EEC3D1FDF0F2F4F6EFFAF8F3F7F5FCE9E5F3F7EDE9E2DFDAE6D6D4E0D2CC
F1ECD4D2F2CBACB49CB7ECE8A87C72856B5C6A66626B605D5761614B434D4C403C3D3B3C
3D3B3C3C4C2751725F626266656469666465696C6D6C6D6F6F6D6C6C6B6867676764615E
5E61615D5C5B5B5A595C5C575653545656595A57
62626363615F60615F615E5C5C5A585A5E5C5D5C5B5C5F5F5D5D5D5E5E5F60636B6A6866
6E6765516F99AEC0C0BBD6D2EAE0EBECF5D8E8F2B1C0D3FDBDF7F7D1F9E5EEF3EDFCFFF8
FCE1CBFEEDFCF7FDF6FEFBF6FFF4F6F9F5FBEAF3DDE3EFE9D0D8E6E7E0E2C9CCE7D3CBE2
DDCDC5CA988596B3C4FFAE89A36A767A64635B685E5762604346505F4C3B4444393D3D34
443D35434818616D646662615F5F666564666A6D6E6C6B6B6A6A6B6C6A66646567646261
6062615C5D5C5B59595B5A55514E51575A595754
6161615F5C5B5C5E60615F5C5A5A5A5B58585A5A595A5D5D5D5D5E5D5C5C606569656767
626A6060456FB8BABDC2C7D3D3E2DDF1F9E1F8F1E7FFF0F4EEFDEBE9E5F6FFFBF9F7F8F6
F8FDF4F7EEF6F3FAF2F9F6F9F3F8F8F4E8DCEEE7D2DBE2E1CDD5D7E1E4DAC6C2B6C8D0F1
F2C7B7B291ACDDF4FF8F709E8A80606765625A534F4D444F4D464445454344433C3C3D35
3E3B403841237167676864605F61666766686A6D706E6A6866686A696562636667646261
5F5F5F5D5F5A5A5B5A5756555251535657555354
5E605E5B5B5A5A5C615F5D5B595A5A595554565757595B5B5D5D5C5B5A5B606465676564
6765626061428ABFB6BEBFB9C3C9D2DCE2DAECEFFBF3F1F2EBF7F5F7F9F1F2F5EFF8F2F7
F1FFF3FBF7FCF9F6FCF6F0F0F7E7EDE6DBEFF1E4D8D5CFC8E0E0CDCFD2BEC7C7D3D3EBD7
C7B4B0AEC9E9B8915B528D4B607D765C61594E4A4643433C3A433E363E423B3B3E39383E
3A41403E2A46716264646461626667676567696C6F6F6B69666767656364666868646362
5E5C5E5F5E5A5B5C5A56555454565451504F4F54
595D5A585C5D5C5F5F5C5A585658585353515152535658585C5B5A5B5C5D5E6062656163
69636460605849B3C3B3BFC1ACADD6E1DADEE1EEEEF2EEF8ECD5F4ECECECF0F6F5F7F4E5
EAE7E0E9F4F5F6F2F7F5F7F3EFE7E0D0EEEFD5C4E5D7CDC4C4C6C4CECBC7C1D6DEC8B6C5
B1AECEB3C9877C7F76753B3E2A3558788161493F3A43423D3E3A3A3E39383F3D3A403E39
423E3B4823586D62605F615E616664666266696A6D6D6B6C6867646365696A6869656564
5F5B5D5F5D5E5F5D5A5A59545358544D4E4D4C4F
58585555595D5D5D5E5B5B59565859545150505053565655555859595A5D5F5E5E5D5E61
6362605F5E5F543DA9D6B2B4ADABB6C9CCD1DFE0E9D9F3E0DDDAE8E6E7F1EEEDF0EDEDF2
ECE5DFEFFBF1EFF7F9EFE2EBEAD9D7DEDDC5D5C1C0D0C7C8DBC2C3DBCFC7C1CCB8B4C1B6
B1D4C0886056696E6B6563536456275D887F70544B493F3C463F3B3B3F433842403E3C3F
3D44443C1A6F6764605F5E5F62656462646567696D6E6C68696865646665666A68686765
6362605D5C605D58595A57545656524F51524F4D
53535354595D5D5D5D5B5B5A5758585451504E4C4D4F5150545759595A5D5E5D595A5B5D
5E5D5C5C5B5E5A5545A3D5AEADB2AFB2B8ACC4DECBDBD0C4D2E1D7D7DEE2E7E7E6E1D6D4
EAF0EFEAEDE7E0EFE6DBE8E6D4DAC8CECECBC6CAC7BDC6C6C8C3C3BFB5BDC8BDBFBFC0B9
B4BE88837B6050504B3E4D6AAAA75A615760606A6F5D59493E3D3C3B413D3C423A424040
3F3E43373D71625E5F5D5C5E5F6061626265696C6E6E6B686A6966656766666967676665
6666646260605D59585756565658575352515153
4C4F5053585B5B5C5B5A5A5A5656565251504E4C4B4D4F50515457585A5D5D5D59595959
58585A5D5B555D5D56389FCDABAFB5ADB4AAB2C2B9CBC0BCCACDC9CBDCE5EFECD4D5EBE4
D9E4F0E5DBD7D3E1C8D6E1D9D1C7CBCEC3CCC8CCC7BFC3C4BBC3B2BAC0C5BCB2BCD4BD88
5E58636A6E94604E383732294E6756605F5F5D5F6175715E48313A463F3C403E413D413E
433E451E5B6E5F5E605C5B5C5C5B5E636566696C6D6C6C6C6D6C69686867666767676767
696A6866625E5C5B565454565456575553505054
494D4F5256585858585657565353545251504F4E4E4F50504E515456595B5D5D5B5A5956
5556595C5C595C60595934ACD6ADAEB4A7AAB0B1B8B7BAC0C6BCC2C0D4DCDECAD9F7E5CF
D5D6D4D6CFD4DCC2BECEC0CAC7C9CACDC5C5C8C4BCC2B8B9B9B9C6BCB7B3C1D6CC938B8C
684F615E7162736B7B9463405F5C5E58615B635C5F5C5E6D7C56323B434041423C413D3C
44483B4A6C606060615E5C5C5C5D60646666686C6D6D6E6F6F6D6B6A6968666568686869
6A6A6765605C5C5B5552535453535253534F4D50
484C4E50535554555452525150515252504F4F5052514F4D4E50525456595A5B5B595754
535456575B5A5C605C54523A9ADDADA5ADADA7B0B0B3B8BCBDBCBBBFCCC9C4C4D6DED3D3
DEBFD6DAC7C4BABBD8C9D3C5C7CFC6C5C0C0C3C7B6B4B7BBB9BEBBB3BFFFDB8470748AA4
8A6F6C6D704F4D5D76876B5F6058585B5B5C5C5B586162596B7A633C3A3D3C434442344B
403A4A6A5F5C5F60615F5E5D5E6062636363666C70706E6E6E6D6B6A6A6A686668686869
6865625F5D5B5B585352555454524F50514E4B4D
474B4D4E50515152504E4C4B4C4E51534F4E50535555524F515253545556575859585655
555554535C5C5A5A585D58543981E5C3A8A8AFB0B1ACB7B3B9BABDC2C1CABFC8C6C1CDBA
BEC7D0D1C1BCC6C0C3C9C7C4BDC9BEBEBFBCBCC5C4C1B9AFB2CFD1BDBFBC8E777A6C7078
8681757C6C573F4933565C5B5B5F5A5C595C565B5F605F5E57576B6C544D3B3956424B3E
5E5A60625956625B60605F5E5F6263626263666B6F70706F6E6B6A6A6A6B6B6865666767
65615D5C5D5D5B565254565554514D4C4C4A494D
464A4B4B4D4E4D4D4C494646484B4E525150515456565656555555555555565758585655
5455555454595C5B545C545A564055B5C5AEAEACB4A1A8A9B5B7BCBABCC3C0BDC2C0B8BB
BABCB1B5BDBDC0B9BBCABAB9C6C3C4B9B4BEC5C2C8BDABACCCFF966E6260728D8C6C6768
7B8595705B443F4851625D59585D595559595B5E5E5C61585B5E595B927039755C625E51
6B635E5C5B5F556461616161606060616466696C6F717272706D6B6A6A6C6C6863656766
635E5C5D5E5F5C575657565552514E4D4C4A494B
474A4A4A4B4B49494945424245484B4F5453525354545557575757575756575756565552
515456575A575956565258565750483C77CBBDAF9FA29AA4A3B1AEB8B7BFC6BCBABCB3B7
B8BEBCBEBCB2B2B5BEB8BAB6B7C5BBBDBABBB1B8D5C0A7AEC6BA644F546D6D799E85867A
77736B7C7A5658403B605C595659575D59595E5B585F5E5859575A56515D5E5C5858565A
525658585D5A626062626363615D5E62656A6E7172737372736F6C6B696B6B6664666867
635E5D5F5F605E5B5B59555453525151514F4B4B
45464849494A4A46424042424346484C515454515156575557595A595755565757525052
555656585A5855515051545651555751446A9D8E949A979BA0A3AAACB6B7B6B1B7B4B5B9
BAB4B7BDB3AAA9B7B6AEAEB1B6B7BCBCC2B6AAC7DC8C67544F69828A6D72716A93A48681
7B76645C70709858405C58575855595D5A585C5F615F5B58565454585253525153565556
535455575A5D5F5F5E606162615D5C61686D71706E7376727170726C696A676867676563
635F5E605C5D5E5C5957575754535354524D4B4B
43434547484A4A4742404141424445494E51535353565756555759595755545452504F52
5454545457565453525254555354555856535A5F88969F8691A2A1AD9DA7A7ADA4B2B8B7
AFB1B5B6B3ACB1B3B2C2C2B0C0BBBEBCB9A19F978D684E49525E7C9B8A7968717FA98682
686B67474453614D545855545956555757585B5C5A5C5A56535253565254545354545252
535456585B5D5E5F5D5E5F5F5F5E5F646B6D6E6E6E6F717472706F6D6C6C686567636262
605F5F5C5A5A59595959585756545455534F4B4B
4342424446484845403D3F40414344494D50535353535555535556565553525250505151
52515151535353535353545453545254605A52657CB3A87C95ABA8AAA9B2A5A9A09CA6B0
B9AAA5B2B6B1AFA0C5D4B7B4A79A92B68E5A615F6982625B504F71A0A08769777E8A9F77
665E4E4E3054524E5B535351575754535557575856595854545453535155555453525152
5657595A5B5B5C5D5D5F5F5E5E5F6166676B6B6B6E6D6E75706F6B6C6D6C6A6568605E5C
595D5F5A5A5857575959575557555454524F4D4D
4341404245474643403C3E40424343484D4F515150515356555453525050505152535351
504F4F4F4F50515252525253555658555B5F5A5F66907F607FA5ADCFA5A8A0AAC89A9AAB
AEB8B1A6B2A4B3C6AC94C19C6E646F8D995A4B4C638D6B6C6F6A72889F997173797A8E7F
8D6949443E56575152565756535554525352515355555454565652515255555351515356
5B5B5C5C5A595A5B5C5F605F5F616466606668676B70717170706A6C6D6C6E6A655F5B59
575B5C57585656575857555356545352504F4F52
403F3E41454745444340414242434246494B4D4F50505357555452504E4E4E4F50525352
504E4E4D4D4E4E4E4E4F515254535A5F5B5C5A4B6E6B59577295727283828B92AC6D7789
C9BA837F8FBAB59B68659FA866787770947F605C6B7F69727B796E6C95AF928179877D78
B49095605A5251514F56505250515152524F4E5154525053565350505355555352525459
5C5B5B5B5A595A5C5A5B5D5E6063666861626466696E716E72716B6E6F6D6F6B5D5E5C5A
5B5B585553535456575553535354545351515457
41403F41454544434442444444464548484A4C4F50515354545352504F4E4D4D4C4E5151
504E4C4C4D4D4C4C4B4C4F525557585C5A5B5B46696D6B676E907272787D7C98625B5C70
99A05E616FA7A5847D72839A758D7571889B7965697378828679746F7EA2AA8E848B7C6E
64545E5B59504D5151514F51514F4F51535251535150515455514F535456575757555557
5A58585959595A5C59595A5C5E6165666861626868696D6F726F6B6D706E6B665D5E5B5A
5B5A58575353545655525151525456565656595B
4343414144434243434446464649494B494B4C4E5052535354535150504F4E4D4B4B4D4F
4F4D4C4D4D4D4C4B4A4C4F5251565454575A5A4D514A6A68637F6F736F69849A69697575
8191696B7787AB807B797392807E827786A4987D6D6E848794807C7C788BAEA5847E7F5B
4B5552494C51514F4D494D4C4F4E4F50505152514F505053545151555658595B5C585555
58555456575757585957595D5F6063636864646869686B71706B6B6C6E6D686565605B59
58595A5A565555575652515155565657595B5D5E
434341414443434645464947474A4A4B494A4B4C4F535656545351504F4F4F4E4E4B4B4D
4D4B4C4E4C4D4C4B4B4C50535655545757565759593E57696787995D605D7E9362667384
84AB6F7F828BAC8D827E7D9697787F897C8C9D8C78758D8A9A937F838E8094A68F7A7D60
50584E544F4C4F4C4E4C504B484B4E4D4A4C4E4C4C4D4D4E5152525357585A5C5E5A5655
59555355555452525754585F62626362636768676A6A6D726F6B6E6D6D6E696A6B615C5B
57585A57575555575755545559575555595D5F60
43434342404548444446474647494A494A4C4D4D5054575656525151504D4E53524F4D4D
4D4C4B4B4C4B4B4B4D4F50515455555455565554535767787F7EA765616C859270657987
94A887868491938D828593949B807C7A7D7592998A7682909FB4848A7D828096AB805041
5B52534E4D4F4F4F504E4B4B4646484C4C49494A4C49484A4D51524F53595D5A57585857
5A545355535151515456595F63605F626163666A6D706F6D6F6E6D6C6D6D6C6B67636060
5C565558575656585C5D595455575856565E615D
4343414044494A4947474748494B4C4E4C4D4F515354555758555454524F4F5252504D4C
4C4D4C4C494B4D4E4E4F5153535352515253535252495B7967567C864B7B7C95896D7C87
98B1957693917D8C8083968C9A826C7D6F6384A4948B868B8EBC9674837F757198C27929
52584B544E504F4F504E4B4B424446474848474646494A4A4B4D4F5153595C5957575757
595553545251525156585A5E606060636265686B6E706F6D706F6E6E6D6C6B6A6A666260
5D5957575557595B5E5F5D5B565557585A5D5E5B
474844434849484B4B4948494A4B4E514F4F525556545558595856555452515152524F4C
4B4D4D4C4A4C4F505151535451504F4D4D4E4F4E544857634C5353785757788D956C8287
989AA27F8E867F7F788185868C7C8378827D83A5B6938E8880A1BF75657A75687FB09951
4E57534B4D4F4E4E4D4A48474446454343454441414749494A4B4D5254585A5855545556
555352504E4F505055595C5E6161616365686C6E6F70706E6E6D6C6E6D6C6B6D6D6A6560
5D5A575554585C5D5E61615F5A57575B5E5D5D5C
4B4C4A494846474C4E4C4A4B4B4C4E5053525356575758595A585655545454525253514D
4C4E4E4C4C4C4D4F52535251504F4D4C4C4C4D4D5453425A5559515C644C5B67987D6E80
999EA97F867E8893817977857F79997D7E887E7DBBCA86828580C5B05E536B66624F5955
54554F4D4C4C4C4B4A4846454648484544434240414646464A4C4D515557585652515254
5151504D4B4E5051565A5D5E60626465676B6E70717171706C69686B6C6B6C6F6F6C6762
5D59565457595B5B5D616260615D5B5E5F5F6061
4D4B4C4D49484A4C4E4E4E4D4D4F504F53545556595B5B5958585756575756545152504D
4D4F4F4C4B4B4B4D5051504F51504F4E4D4D4E4F4D513E53555151526B6D405B9383677D
90959B846F8C848390876E7D806B888A777C8F7997FA887A797D8FB0AA6F3B563D4B5653
55554E4E4C4B4B4B4B4A49484446494946434141424644444A4C4D5154555553504F4F4F
4F504E4C4C4F5354595D5D5B5E6266696A6C6F70717271716D68656769696B6D706D6965
5F585556595B5B5A5C6062616362606060616366
4D494B4D4A4B4C4A4D50515152545351525456585A5D5C595859595A5A5956544E4F4F4D
4E4F4E4C4A4C4D4F5050525352504F4E4C4C4D4E4E4F514F4F5450534F7A3D5B81866C6E
7A6F697F6B65887F8394736B7D68719F857190826FC1CE816D717876A9715C35425A5657
56505654504D4C4C4B4B4B49494948474442424443464544484B4C4F5152514F4E4E4D4B
4C4D4C4B4E5153555A5D5E5E606466696B6D6E6F7071716F6B68656667686A6D6F6B6865
605B595B5B5D5E5E5D5F62646163636161626466
4B4A4A4B4B4C4C4B4D4F53555756555352555758595A5B5C5B5A5A5A5A5754534F4E4D4D
4D4C4B494A4B4E505153555653514E4D4B4A4B4D4D4B4A505250515250545F437286A57E
89868676755662776E758564595C5183C37B76898984F8D357405360554D5A5E45595052
51505553534F4D4D4D4E4E4C504E4945444647464545454446494A4B4D4D4C4B4D4F4D49
4A4B4B4C50535354565B5E62656766686B6C6C6D6F706E6C696969686767696C6B686462
61605F5F5E5F6162616061625F61616163636365
464A49484B4B4C4F4D4E5358595654545556575856555A5F5E5C5A5957545252504E4C4C
4C4A474648484A4D525555545653504E4C4A4C4E4B494F4D4C544F53524B62515A696F84
5A6357BB8B734D585F528C80444B555E765A5E60795F6F9252624E50565753575A545152
4E54515555504E4F5154565350504C484A4E4D474745434446484946494A49494C504E48
4A4B4C4E5455545555595D626768696A6B6B6B6C6E6F6C686A6D6E6B676567686765615E
606363616361616465625F5E5F605F6163636265
474A4A48484D515153525354565654535456575757595C5E5E5C5A585553535450504E4D
4D49464847494C4E4F5154565555534F4D4E4E4C4A4A4C4D4D4F51504F524A5644494554
4E494567675D6F556761536569404C61444C6F625855594B5259514A5456525653535150
51515255555351515254555656544E4C4F514F4E4A49484544444647434646474B4D4B4A
494B4F5153545658595C5E60656969676D686869686A6B6A6B6C6E6F6C68666765635E5B
5F646667635F5F6364605E5F6163636262636261
48494A4B4B4D5052545453535455565655555657595B5D5D5A595857555251505051504E
4D4947494B4948494C5054565654525151514F4D4C4C4D4D4B4D4E4D4F4E4F5857555154
54555345444B577777775346645A4F505149524D534F5356545653515454525451525150
5050515251525354545454545658565455545354514F4B474544444543424145494A494B
484B4F5152545657595F626161636466656464666667696A6E6E70706D69656461615E5D
606362626061616061626261636464646464625F
49494B4E4F4F50545455555555565759565554575B5E5E5C595857565452504F5052524F
4C4A494B4B494646494E52555452505153514E4C4B4B4C4C4B4C4E4C534B4D4B56525755
5755544D5253484C5B45544E487382404A4A49484F4F4E4F514E5052504D4F5154545454
525151504E51555655545455565A5B585655555756534E4A4644434245413F4347454448
4A4C4D4D4F54585A5A5D5F5F61646465606161626364676B6D6E6E6D6B68635F5E5F5D5E
616261605F61616060636464646463646564605D
4A4A4C50525152555354565858585858555454575C5E5E5C5C5B5957545251525152504D
4B4B4B4B48494949494B4E51514E4E50514F4B4947484A4C4B4C4D4C4F4A4E49534F5654
545551534D4C544D4D4E53505248454F474D4948464B4E484D494B4F4D4B4E5055555758
565452504F51545555565759595B5A565454565856534E4A47454241413D3C4145444448
484B4D4D50555A5C5B5D5C5E636666656363615F6162656B6E6F6E6C6A6864615E5E5D5E
6264646562606163626163676261606163635F5C
4A4C4E5152545556535456595B5C5A58555555585B5D5D5C5D5D5C5A5552525451504D4A
4A4C4D4B484A4C4C4C4B4B4C4E4D4E4F4F4C49484646484B4B4B4B49494B4E4F51525556
5756514E4F504F5154524E4A4F504E4B4C493F4544444647464546484B4B4C4D51535657
565553515051535456585A5C5D5B58555355565653504D4A4845423F3C3C3C3F43444446
454A4F52555859595D5F5F606264656667666260636465696C6D6C68656463625E5F5E5F
6365666967656363626062665F5E5D5E60615F5D
4A4D4F5153565756555556595C5D5C5A5758595A5B5B5C5C5C5C5D5B57535253514D4A49
4A4D4E4B4B4B4C4D4D4C4B494D4D4D4D4C4A4949444345494A4B4B4A4A4C4C504F545558
5557575352504E5550554F4B4D4C4B494A4A4043453F3C403E4141444A4B494A52555657
5754505051515255585A5C5C5C59575554555551504F4C4A4744413E3A3D3D3D40424242
474A4F53555757575D5E5D5F646665666866636264656668696A6965615F5F5F5E5F5F61
646667696A6B6862606263625E5C5C5D5E5E5E5D
4A4D4F5154565756555556585B5C5D5D5C5D5D5D5C5B5B5C5B5B5A5A57545251514C4A4A
4B4D4E4D4D4D4D4D4D4C4B4A4A4948484849494844414245484A4C4C4B4D505354565657
5D5A545553525651554E4B4D4C4C4C4B494A463F3E3B3B3B3B3D40454A4C4C4D54585756
58544F5051525355575A5B5C5A58585755555451504E4C4A4844413E3A3D3C3C3E414244
49494C51535455585A5A595D6467666666636161616366686A6A6A6864605F605E5F6062
6566686B6C6D6B656363625E5D5C5C5C5B5A5B5C
4A4C4F5255565757545557595B5C5D5E6060605F5D5B5B5B5C5A575757555351504B4A4C
4C4D4F4F4C4E4F4E4C4B4B4B46454342444848454843414345484B4B4A4A4F4F54525759
5659575354545354504C4F4C494B494B4A3F423E3B3A3E3638373B4246494D4F52575554
58544F535253545556585B5D5A5A5B59555556544F4E4D4A484542403F403F3D3E3F4044
47474A505353545755595C5E6162646866615F5E5C6066686968686865615F605E5F5F62
66686A6E6D6B6B6B69645E5B5D5C5C5C59575759
4A4C4F53555756555658575658595A5B5E6061605E5D5C5B5A5958595A5A55514D4D4D4E
4D4C4D4F4F4D4D4E4E4C4A4843444142474643474443424345484A4C4C4F4F4F54565555
58595752515252504F4B4A4B4C4B48474544423E3A3B3B363A3A3C4044484E5353505256
5350515152515155585959585A5B5A58575756534F504B484A4A454144433F3F42414042
47484C4F5253535352565D5E5E61646364615B595D5F6063676767686764605E5D5D5F62
65686A6B6968696B68605C5D5F5D5B5A5857585B
4B4C4E5154565657575757575857575B5E5E5F5F605F5D5A59595A59595855514F4E4E4E
4C4B4B4D4F4E4E4E4E4B49484344444344444444424343444547494A4B4E505154555556
555758555352504D4F4E4D4D4B4947464443413E3A3B3A37383A3D4145494D5152525354
525151505151525456565757575959575556555351504D4C4C4A464244423F3F41424245
4446494C5052545551555A5C5C606464625F5C5B5A5B5F62666665646362605E5D5D5E61
6466686969686969656260605B5C5C5C59565658
4B4B4D5053555658565656585855565A5D5D5E5E60605D5A585A5B5A5958555350504F4E
4C4A4A4B4F4E4E4E4C494746454647454143444242434343444749494A4D515354545558
575655535150505051514F4D4A48464442403F3D3A3A3A3A37393D4245484A4D4F504E4E
505251504E4E4F5254545657575959575758575655514F4F4D4B48464142414243424142
4345484B4E5154565456595B5C616565625D5C5B575A60616161605F5E5D5E5E5D5D5D5F
61636565656565625F6163615E5D5D5B59575657
4B4A4C5053545658545555565756575A5A5C5E5E5D5D5C5B595A5B5A5A5A585652504F4E
4C4A4B4C4D4D4D4C4A48474748484845434343434444424043484A494A4C4F5253525356
575552504E4E505251504E4B4A4945403F3D3C3C3B393A3C393C40434647494A4D4C4848
4E5150514F4E4E505253555658595857585B5B59565352514E4C4B474040424343424141
4446494C4E4F51535557595A5C606262615C5959585B5F605E5E5D5C5B5B5D5F5E5D5D5E
5F606263615F5F5C5A5E636163605D5D5D5C5957
4B4C4E52535353545355545356585858585A5B5B5B5C5D5D5B5A59595B5C5B585452504E
4C4B4B4C4C4C4C4B4A4949494B4A4644464442454544424044494B494C4B4D5050505153
54535251504D4D4E4E4E4D4A484744403E3C3B3B3B393A3D3F4143454648494A4D4B4747
4B4C4D51525151515050525558575555585D5D5A555555534F4E4C474341414242424445
44464A4C4D4E4E4F525456585B5D5D5C5D5C585657595B605F5F5F5E5C5C5E5F5F5F5F5F
5F6061615F5C5B5A585A5E5F6261616262605B57
4D4E515353525150525553525558575557575757595C5E5D5D5B58585B5D5B5756545250
4E4C4B4C4C4D4C4B4A4B4C4C4C4B45444846424743434243464A4A484D4B4B4D4D4E504F
52515152514E4B4B4B4D4D4B474442423F3E3B3B3B3A3A3D414344444446474847464546
46464951505254534F4E525757565454585C5D5A585856514E4F4E4A4845444443434343
4245494C4D4D4C4C4E515356595A5959585B58555554575E5E5F5F5E5D5C5C5D60606160
605F5F5F5D5A57575756585C60626363615F5D5B
4D5052525252514F4E5253525455555555565555575A5C5D5D5B5958595A585556545352
504E4C4C4D4E4C4A4A4B4D4D4B4A474547464445424243454648494A4B4A4B4B4B4D4F4D
50505051514F4D4C4A4C4E4C474342433F3E3C3B3C3C3C3F424344444345464643434546
44454A4E4D4E50514F4F52555455545456595A585B5A55514F4F4E4D4C4746464443423F
4345484A4C4C4C4B4B4E505357575657555757565453575C5B5C5D5D5C5B5A5A5F606060
5E5C5B5A5A5955545756565B5F616261605F5E5D
4C505251515353504B4F5254555354565456575655575A5C5D5C59575857555254535354
524F4D4D4E4D4B49484A4C4C4A49494745464643414244454546494C4A4A4C4B494C4E4D
4C4D4F515353504D4D4C4D4C494442423E3E3C3A3D3F3F41434547464647474747464747
47494C4A4C4B4B4D4F504F4E50525352525455555959565555504B4B4C46434342434341
4647484A4B4C4C4C494B4C4F535353545452555754565A5A585A5C5D5D5D5C5C5D5E5F5E
5C595756585956545959595F5D5F616262615E5B
4F4F50504F4D4D4F4B4E515252535456585656575757595C595A5A585655545152545554
514E4D4E514F4C4848494A494847474643414245484848474647494B4A4A4B4B4B4C4C4D
4E4F4F4E4D4E5052504F4E4C4B48443F3E3E40414041414045464747474746464645454A
4E4B4849494747494D4E4D4B4D4C4F5351505355575A5753524E494A4844424244444547
4445474848494A4C4A4A4C4E4E4C4D515351535555565856575B5B5B5A595D5D595B5B5A
5B58535255585758595B5F5D5B5A5A5C5D5C5C5E
4D4F514F4B484A4D4F4F4F4F505153545455565858575859565758575451515151525353
52514F4E504F4C49494A4A4948474544413F414445454646464748494B4B4B4B4B4C4D4E
4E4E4F4F4E4F51524F4F4E4D4C4B4744414144454343454445454547494A484645444449
4E4C4848454445484B4C494648474B4F50515355565B5954524E48454644444445454545
46474747474748494748494C4C4B4C4F4F4F5253535456565657575B5D5B5D5D5C5C5A59
585553535658585C5C5B5C5B5956555658595B5C
4E4D4C4C4C4B4B4C4F4D4B4B4D505254535456575756565656565858544F4E5150505253
5554525051504D4B49494948484644413E3E3F4243434243454647484C4B4A4A4A4B4D4D
4D4C4E504F50525050504F4E4D4C49464344474746464747444445474949474546464649
4D4D494645454648494846434746484C4E4F5152555B5953524F48444445454443434343
4848484645444343434446484A4C4D4F4F4F5152525456555654535A5D5C5D5C5D5B5A59
5653545557585A60605A595958555355585B5C5D
4D4B4A4B4C4C4C4C4F4D4A494A4D5153535455565555545453545555524F4F5150505153
5555545354524F4C4A4948484746433F3D3D3E4042413F40434648494A4A4949494A4B4B
4B494D504F504F4C4F504F4E4D4C49474747494A494A4A49454749494847464648494A4B
4D4E4B484B4A4948474645454847484A4B4C4E5055585753514F4A474445454140414344
474848474442403F3E404345494C4E4F5150505052545453555451565B5C5D5C5D5A5A5A
56545658595A5C6160595756545454575A5D5F5F
494B4D4D4A484A4D4F4E4C4A494A4D4F51525454545453534F5051505051525151515252
5353535455524F4C4A484848464543403E3E3F4041403F404347494A494948484848494A
49484B50504F4D494B4D4F4F4E4D4C4A4C4B4C4D4E4E4E4C484A4B4B4A494849484B4C4C
4C4D4E4D4E4D4B484646474847474748494B4E5253545353514D49484546464241424445
46494A494744403D3C3E4042464A4C4D4F51504F4E50515252545254585B5D5A5A595A5A
575556575A5D5D5F5D59585550515255585B5D5F
4546484949494A4C4C4D4E4D4B4A4C4E4C4F5254545453515052514F4F52525153525251
5051525354514D4B49474747444443413F3F404141414243454748494949484747484849
49484A4E504E4B4A4C4F5151504F4E4D4F4D4D4F4F504F4C4A4A494A4B4B4B4A4C4E504E
4C4C4E4E4E4D4C4A4847484848484747484A4D50504F5052504B46454647484746464747
474A4C4B4946423F3D3D3E40424547484D51524F4D4E515450535355585B5C5857595A59
58555355595D5C5B5A595954514F4F5255585B5F
43414044494B4B4A494C4E4F4E4C4D4D4B4E505152525150525353525151525356555351
5151525253504C4A48454444424444424040424342434445464747484948474646464748
484847494D4B494C4E51535351504F4E4F4E4F504F4F4F4D4C4B4A4A4B4D4E4E50515352
4E4E505050504F4D4B4949494C4C49474A4B4B4D4F4E4F4F4D4A47454848494A4A49494A
494B4C4A484743403F3E3D3F404143454B4F504E4F5153555254535558595955545A5957
58575354585B595959595955554F4D5155575A5E
424141434749494A4A4C4F51504D4C4B4D4E4F4F4F50504F4F4F51535250525659575453
5353535353504C4A47434140414344424041434445464645454547484847454444454647
484844444A49484E4E5153535151515150505252504F504F4F504F4E4D4E515350505254
53535555555453504D4B4B4B4F4E4A494D4E4C4C504F4E4C4B4B4B484948494B4B4A4A4C
4A4C4B4846454340403E3E3F403F4245484B4B4B505454535856535557565754525A5955
59595556565857585A595A56574F4C515656585B
41414344454546484B4C504E4D4F4B4B4B484A4D4B4A4B4B4E4E5054575757585B5A5755
5552505254514C4947444242403F3F414446444343454747464647484544454442444544
4444434244484B4D505356565555565657565452504E4E4F515252515152514F50515353
53575B59595653514E4A4A4B4C4E4E4C4B4C4C4C4E53514A484B4C4C4A49494A4B4C4C4D
4E4A48494743404243413F3D3E40414145494B4E5354555758555456575555575A535458
5655595857595A5C5D5C5A585653515051545759
41424445454446494B4B4E4D4D4E49484B48494C4C4A49484B4D515658585A5C5B5A5756
57575454514F4C4A474442433D3C3C3E4144454645474848464342424442434443424342
4241414243464B4F52535557575656595655545352505051525455565756545252525455
56595C5B5A595653504F4E4E5050504E4C4A4D5152534F4A494B4B4A4B4B4A48484B4D4E
4D4A45424140403F413F3E3E3F41434544474A4F55575858585858575655555657545557
56585B5A5B5A5C5E5B5A5A575454545352535557
41434546444346494B4B4E4D4D4E4A484C48474A4B4A4947494C525658585B5D5C5C5A58
585755544F4E4C4A4744424240403F3F4143464747484847464544444541414544414141
413F3F4244464A4F535253575856575B58575656545150515355595B5C5C595556545558
595C5E5E5A5B585452535250515050524F4C4C4F4F4F4D4A4A4A4848494C4B48484B4E4D
4D4B46413F42413E403F3F40404042444444494F55595957585755555657555254565756
575B5D5B5C5A5E615C5C5D585556555453535659
41424344434345484A4B4C4B4B4C4A494C484647494949484A4D51545556595B595C5D5A
57545353504E4C4B48454241444343434445454547474645454647484642424444424241
433F3E4246494A4C515052555758595B595958585552505054575B5E605F5C595B57575A
5C5D5E5F5B5B5A5857565553504D4D4F504E4B4A494A4A4948464548474A4D4C4B4C4D4B
4B4B47434244423E3E3D3F42424040434545494F53565754535352525354535353575755
585B5B5B5A5A5E605E5C5C585756565656575859
404040414141434546484847464749494A494747484848494C4D4F5053565859575A5C5A
56545352514E4B4A49474443434342434546464547464544444545464643424242434340
42414043484C4C4B4E505254575A5B5B585858585753515156595C5F6161605E5F5B595C
5E5C5C5D5B5A5B5C5C5957564F4D4A4A4B4C4B49474746464644444745484C4F4E4C4C4C
4947454443423F3D3B3A3C3F403F414446464B4F505254524F505253514F515655575756
5959585A5B5E5E5C5C595656555455585D5D5955
403E3E3E3F3F4142434645454445494947494948494746474C4C4D4F5357595A5A5A5B59
5655524D4F4C4A4A4A49474646454443444546474747474747474646464341403F41413E
3F404345494C4D4C4E505254575A5B5B5958595857545252595B5E606263636263605D5E
5F5C5A5B59585A5D5D5956564E4D4C4A494A4A48474645474945414144464B4E4E4C4C4D
49464443413E3D3D3B3A3A3B3C3D414545474A4D4E505152524F50535451515455575758
5A59585B5F625E5B5C595659565454585D5E5A56
403F3E3E3D3D3E4041434243444548464749494849474445484A4C4F53585A5A5C5B5957
5453504A4D4C4B4A4A4948484A4A48464444464848494B4B4B4A4949474341403E3E3E3C
3D3F42474B4C4D4D4E4F51535557585A5B5A5958565454555B5D60616364656565646160
605C595957585B5D5D5A57564F4E4C4B4A4847464747464849453E3C4245494B4C4D4D4D
4B4845423F3B3A3A3B3A3938393C41444346484A4C4D4E4F53505053565553515456575A
5C5B5C5E61625F5C5D5C5A5C585756585A5C5C5B
4140403E3C3B3D3F3F413E4144444542484948464746434344484C4F53575A5A59595855
5151514C4C4C4C4B49474748484A4B48444346494B4C4C4C4B4A49494A4441413E3C3B3C
3F3D40474D4D4B4B4F4D4E52535355595A585756565657595B5E61626364656567666361
615D5959585C5F5F5E5D5B58564F4948494745464949464443403E3F3F44494A4B4E4D4B
494845403C393736373838383A3E4245424546474B4B4A4B4D525656545354555355585B
5C5E6060605F5E5E5C5B5A58595A5B5B5B5B5C5D
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell["\<\
This convolves the data with a two\[Hyphen]dimensional kernel. \
\
\>", "MathCaption",
  CellTags->{"S3.8.5", "5.33"}],

Cell["ListConvolve[{{1,1,1},{1,-8,1},{1,1,1}}, g] ;", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.8.5"],

Cell["This shows the image corresponding to the data. ", "MathCaption",
  CellTags->{"S3.8.5", "5.34"}],

Cell[CellGroupData[{

Cell["Show[Graphics[Raster[%], AspectRatio->Automatic]]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.8.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00481 0.0238095 0.00481 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.02381 .02381 translate
.95238 .95238 scale
198 string
198 198 8 [198 0 0 198 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000000005000003000000130521130F070004000003041A030000201903000000000E00
001121000B1A0900030C0214000000040D0200000000030A000006000100000002060000
0F140000061B00040000000005100C1C0C140400000C000B03000013020000020000060E
00000B19000000070104110B1821000000001000060300000D1403020000000000041119
0900071112040F00000000000000000700000000020D0007000000000100000000000000
000018000000080300000E000000000F1003
0B0000000800000800000717000600110800000000010814000700031914110D03020A00
000008000B270A000A160D00000000071000000000000410000005000100000007000000
0000020301010000070000000F060000001E2106070E0018050000130600000E00000C00
00081B1D000007080000170000150000070F0B0000000000071500090000000000000008
0000080400000014000000000000010000001B0D0620001D0C0003192203000000022401
000000000205080000000F00000005180C00
0C0C05000000000302000A0000000000010000020000060000160000170C171300000000
01050B00030701001715070000000000000000090100020B010004090000111F09000013
00002F3200001F000004000E140000000000261A0000000805030C080000000C00000000
0003120D0203180400000D00000A04001A1500070000010000000101171100000C040000
040F0700000000130000020000001F0000001C00000F0000000000090500000000122100
0000000F0D07000000010B0B0000060E0000
00000000090E150804080000000318000000000E03000E0B000C00001800000C00000000
081A1E0000000000020500120001000000000511120000000B0000000000071400000814
0B08000102112000080000000E0A0007000003000000000B0808020A0000000000000000
000E110B0000000000000019001C0D00000B190800000F00000A1600000000010F060000
0E1602000A0500060000040100002504060927201E2E04000000000000000F0008110400
010000110A00000000000008000004020000
030000000C09010200090000110000000000000503060E170C1C02000500001F05060000
000C0B05000A090000000614000417120100000312040000030000000B000000000A0A0D
241F00000B121216110100000100000006080000111600120200001106000A050C080400
00060100000000000000001F0004000201000600070D0100000800000000101400000C00
070000001005000002070A020000090000000500000000080F0002050A02060516000000
0D0B050C0A00000000000000000000030000
0C00000000000000000C1911050000000000040000080000151A12000000000C00000000
000C100601080200000704030101151B13000000080C030100000000130000000502000F
04020A19000016030A03040300000000071407081815050B0200071917031C00150D000C
0C010009192515070000000200000017200000040D0F06040400001D0000131100000800
000000000000000008040910000000001310030000000000000000000000000B00000000
0917080006000011000000000000020B0506
0B09040000050B000004100100001F000000120600030007160000160000001300000000
1218000E0000000012140005000000000012080009161511000000000000001500000413
0100000000001A00000000000000051100000B000000240908000301000006000000000E
1902000900000008170300000113000D130013000000102905000000181E000004000000
0006180E0000100000000B1E060000002407032A371D00000000000E0D00000000022800
0A1F00000000000300000000000F07100000
00111E000000040900000502000000000C090000090B0000000C00001E20000000000805
0000000001000004222600190000031607060C1300061F00000A10211B00000D00000000
0207000000000000000006030000060B00100000000100002400001D1C07000000000000
000000401200000400000F0F081007061B1700000D030000000C0A000C00000005102C0F
00081B000018000009000000000004150900000110070000000E00000C000B1310000001
08000008000000070000130C01000016231A
000112070000000000050700000000000002000000000000000100000F17070000000003
0000090A03000E0A000A0B00000000000000000800000000000000000500001500000700
0000090B04000000000000000400000300000009150C00000B020000000F0F0007020000
000E200300000A0000001500190B0006030009000D070001060202000F17070600001512
0E030000000200030A00010E00000000000A05071011150D080A00000D000F050F000003
0000001B0D000000000000040609000B0300
00070E04000000050B02000000001C00060D02000006181108080D000000000800000000
00010F0708011107000103000D160A000000002C1B00001F120018000000000F00000800
00000A110000030000000A191713030B020A0D041311020509091000001A0D000A060000
000D1D0000000C0A00001600000000000000160B1D070000090500000000010800001000
1E0400010000000C0D00001000000100000700000000000F010100000700060006000000
0300000A030000060A0B1100000B09000003
010B1200000000191B0B000E12091A00080D0800070F0A09000000070D0C000609090F03
000012011A010000020800100A0614140A0001171600001011000C000000000E0E070406
0000070800031E0000000800000202160E110300060F1E0900000900000E000E00000000
00000000000000100B0C02070E00000000000E0B1B0F0000000000200000000602000000
1400000F0E0000010400000B0006040B06000B0D030D1E00000100000100030005030003
1513001512040009100B0000000000000015
00000000000E00091E14001D0E0000071108000000000013170A00000000000000090E04
0000060010030000040E001100000A1305000E000000060E05000000030400000500000C
0700000000072A00000003000000031B0000000B23181E000000001106080A0A00000605
03000000000000000903001B00040E00000F0500110E00000000011D0000091811050900
02000000110500000000000B000F0F1100000001000515000306120D0003040D120F0000
0108000A020201080D09001D00040200000E
000000000B0E00000508000000000B0107040000110F00000510000000000A0000000000
000C00030200190D0008140600000D0300001F0000000C00000C05000D14090000000000
0608000000060A00000007100E0502080C00000D130D18031200000800001F0000000702
020B08000B0400000000000000000700052108000B0D010002062A00000A121108080A00
00000002170D0000070000020008050F0000000000000000060008000000001505070000
00000000000000000610002200090D010007
09010000090D000000000000000C2000000011100E0D180A18130A000000000200000300
000400000000131000071403100A0300000114000000000000000E040A0C100000000000
040C0000000000000000000300000000111E0700000009100E00160000020D0000001000
000D0C00000204040016200E121F16000610000000020C0C030021000A150E0000000000
0000020B0A030005150000000000000500000A060A0E1400000000000000000600000400
0005000C00020A000000000A000608100401
000000000919090000000401000700000000131100001513000015281200010000132007
0000000015030C0E0C1C0008180E00000C140F05000006130000082B0500000603070008
0C090605060C000F00050E0300052400000200040B000000000427000019000500002816
0C05000C0008191100001600171500000000000D0000080900000000000C010000020000
0900000300001623210000000008011D0A0000060500000000000008000A031300081405
00000900000002000000000A0A0C05040000
020000000000000F000A0D120000011C0000120000000003000000051A1609190500000B
00001400000000090F060018000000001500000000000D000000000B070000000F0F0000
16000005000500000A19000032000004050003200C000500000002000000200007000016
14000000071B00000000000000161100000000070000050B0E070000000000102521191E
0800000004150A04061A0000000000000013130609000000100700071401000900051101
1B0E00000700000000001102000000000800
00030405000005100110030E00000013120E0000030200110F0F00000000001400000200
0000000000000E120E0305120007030A14000900000A0A0000000F000005050000000229
0900000900060405000E00010A00000003000009141E310000000E060004140000000000
06121D050000001511000016000A1D00001602000000000000001A00000009111007001E
0000000000000000000F0100020000030E0000000D0210000C07010C1400000A010A0000
0005000009080A1506000000000013200200
00000B04000018010007040D000000140F0600000000000000110B00000C261400020800
0000000900000C040000001400040205000000000106060000030F0C0400000005030409
00000000000000003A4644000000180000000000070A000000000F030000001F00000800
00181A01000900030000001D00000A0D05070B000000000000001E000000020E0C000A10
000000000000000000120800000003000100000D050008000B1609180F07040003070000
000B110A0800000502000000000800000C00
000010000005150000000609000000000805000300000700071D200F0200060000010A00
0F04040A0000000000000205000000000000060000000000070800122205000019150000
000800000B00005AB400435400260C00000A0000000000000000150C0000001700001411
08000000142C00000302080206000010000003000800000D0A00000D0000000000001400
00010000181F000700000A00000008000000001C04000000060400000008010000000000
0000060201000000000000031B1600000006
00070D040913080000040D0C0A080400292C00000604000C07070404000000000004000A
1200120000000000050B0F0003000000101A0B000000000004080000101B070000000004
0B0000271C00005D000000B12009002904010300000C07000C011F230C18040000000621
0D000026180800001C000000010200000000000A151006151400002A130B0C0000000000
0B0F0000151D00000000151E070000010006130100101800020000000007001D06000004
030000000000000000050027040923080000
00060800051900100A020A0000080100111D000000020A00000006030500110001000008
1100090C090000000207000007010002060F00020908000000020D020000100D00000700
0F00011300004E0000FF00007900061400000802000613051D000D13000500000B02000A
06001327000000110F00000000171800002A00100E1E0F02000B11010600080000000000
000013080807020D0800081A0000000000000700001C0E00050C03000000002506000008
16110C000500000000000A0B020019000000
00050D000006000C0D0004000012000900001C0E0000200001000E100B000100020A0000
0C00000A09080001000000000C0400000004000A11110D08000210200000000800000F00
10000E0000261700FFFF00005D070C00000000050000000C220000000000000112080000
00010A000004110C00000D00000C120000190209041A0D00001110000000000000000000
000112040105141E2200030700080000000001000005000000060E00000D000900000B01
151A101013000000000020000F0300000020
000A2600000305110200000000302202000906000203002908000000050E0D2504220600
030E01000007180B00000000070009060027310A00000007060600001C17000000000000
1500000000640000FF0000000018090001000000000000132700000D001E110100050000
030B0000000B0000080007001500002300000F0C0007000000060000000200000008000F
16160000000906000C000F0C0003000D1600000D1A0400000000000000020000000E1D00
000000151500000000021900000012180815
1710000000000010000F00050800131400143000001C07000000021A0B00000E00000700
0807000900000524000002000B0400010000190F0A171D0E0000070C1C0E00011E150020
001C0005261500F16A007F030000000C0C00000015230D12000000000F0A06000000001D
2600000000000700040700000F0000000600000F0017000000000001000000090000000A
091C0F000F1B052225270711230B04110000160200000E000D040E00000E03030004120C
1A190700010C0700000002001D0C0A07051C
0001000000020010091F050B21000E0800000200000F0B000000000000000D1600000703
090B000C1705000A000000000A0D010D0200000A070A1309000002000701000000000000
200000008D0000C90926C53800000607000300010F0B0300001C0F0008080D000103000D
0C091A0700000600071300000001000002000009001C110B13030D050810000000000000
00000000140E0400000A000009000000000602000000000706000C010013000000001B15
16080000000000000000000C02000F0E0006
040000000903000005150208210601230000000000010905000000000000160000021200
00000700000000000C110D0600000000091A16140A0A0D05010000000000000300000D00
0000005A6E00FF6000368E890000071809090A0501000000000F00000007180808150A00
0302050C00000000111A0F0000000000071107000000001225000000070B01000B0B0100
0000030A1909000000000000040000000E1400000000000000000D0B021E0D0D00000000
0000000000041E140000001F0E000C07000D
0506070103050000000300000A0007170700000D06000011050008140F00000400081701
000018000A0400000300000A0E120000000F0F150F080000020700000000000E13090F12
0B0000BF0000F70A00001EA000002513000000000000040800000000030400260B090C02
0906000B0000000006080800000000000A1F0800000008171E0300000D1502000707000D
00000F171500000000070200020013011A0E00000000170000000600001518260B000000
00070F000000131B0F00000214100000030D
030A0C00000800000000030700040700000003100B0003110000000C0B0000300000000E
0F0000011714020000000000001300000007000700000000080E070000000005130A0800
1800880000FF4E1E3D002D890000100000000000080C1807000000021700001600000901
0B0B00000000060000040A0000080000011100000B201700000017000200020C03030006
0B071007000008140814070000000700080000040009290008020F0000080F110E0C0802
00000000000000020D0100000E0700001000
000E10000000000E0000160A000000000000010B0000000F040304000000002200000004
09000000000014170C0A1400000000001010000000010A0013170D000A05000000000500
0021F50000F100033A001E56000000090000000E0E070A05030C00030F00000000050200
0000000000000D0A08071700031514000004000005000300000604000000060D0D0D0F00
0B0C03000000060000000200060006000000001B0F001900070220140019060003000000
0000000A170900061409040C0000001A1200
00050E00000C000005000B000000000500000503020000040B14050000001100010B0600
0101010A0004191402000202220D00000000000000081600080D02000B0A000000041617
00790000F84633031C0000872A00001806000005100000030506000007000B000B070000
000000000000020C06051D000A0905000000001E0D00001713220003090D050600000000
090D020000000200000000000C1000000000001F0900050000001D17011A0B06160D0000
080D05000A06012127171E00010000121400
000C1602051807000E010A00001B0C000000000005000000000F07000000070006040003
1009000000000D1409000000241D00000800000000101B000004000000000000091A1900
23D60033D32D001B080000EA000000140C0000061C100000000200080D00020B14040003
040316130000000F08081102140000070D050C070B02080D0007000007100000050B0400
1812040A0000001900070000161200110E0000040000000300001200000007000E000001
070000000200092514000000050900002000
180B00020100212400000D120E061600000719060C08061607000005120B00000000000C
0B0000141811030700000000000F2614171A001B09000004000000001400000021000004
BA0000FF77001D002F0000B206001E02000000041609030C0000031914000000000C0E02
07000000140A000002000011070B0000141F0000150C00000000000800031C0300080000
060D00101C000003181B040000000007000A251500000C001703000000000B0900010712
0C100A000000001610000000170C00000704
0003090008140600050C0000060F00000000000007090200001104010000000011151520
2418100E0C00000009000507001D1C000000000014201300000000000C0000030F001034
F1004CCB0016002B28002B691500191104040F08120B0D00000203000001090011150400
000008000000000A12070E0000000000030F00010B140A0F0A0B11070F070B00000D1800
070D06020201020000000000010E0A081311000100000000131C13020000000000101508
0000001C110B020E15000000000013260000
00110F001012000005100000000000020000000000011A00000A00000000000003141106
0000000D050000000A03002300000100000E1000091400000000002121001700001000E2
0000FF9200340239003400AD88008D000005010000000100000000000025060000000000
000000070100000C04000D00000000000006050000000300000002000F07100700071714
0000110003030000000000060511160B160B000007000000041106000A160000000F0E00
000000000A13080000000004140300000000
07150000100000000000080000000000121F10000000180700000000050800000F181209
0000000006000000020C061E00000000000D050C0000000B0D00003915000A03000039D3
0099AD2300151E07003B1A4E7D00B50000000000000000060E0000000028050000000006
06000014000000100C00000300000B030000020000000A00000000000600000A00000F1B
00000309100300000000090F0000000E0500000C000005000000000014110A0000000400
000007000211060000000518281100000000
000F00000E0019000003090101020800000000050F00001D01000000091103000600000E
1000060000000000081F290000040A00000000000000080500001915001F00190800FF00
00FF50000000570000003A29FF00A20000060A00000506001F00000B0000000F00000211
0B0806000000001A11000000000002000000000B00060A00030D000E0B00000603090C0B
1A1000090E000C00000010110000000F040003070000100006000012060000000000180E
00000C0B100C0000000010050000120E0000
000A010000120C000A0F0000181C00000000000007000002000000000001060200000000
0D010B00000B1306050A0901040F12100300020000000F0E00000F0004000300008F5400
B369220000005400007C007CC700DC0C02091A15050D0B00110000070000001208060100
0000000006020000000014040702000000010003040E0100041600160700001F170D0000
2115000000001B000007140D000000000B0D00000C0D0902170000120000000B00000308
0007070C000207171A000000000010160200
00090900000000000B0E0000151200001613000000000E00020D0A000000081414000007
0D010E0000041F120200000C050002151A0C07010600000E170000001000110007F90000
FD53000972392D409230006CFF00A2090001110A0200000005070004000000000B0C0000
000000111B0B0000000015040C0E10010001020A151A00000E1D100805001A180C0A0000
020D00000000070B05050C0000000200001008001B23000A0C0000000000130C0E000000
091600000000051D1400000A0807000B2324
0900001710001C0200000600000200000600000B130907040000000000000D0D0F070000
010515070000030B0A070000030D0000000000000A0000001A150307001A1213824B00FF
C100078A63482F00925C0038EE00890C0003100700000217001502041C00000008120800
00080E00030500000A0000000011241400000000070000000001131A0000000000190402
00052E2108000003060000000001220300001E07030A00100F0D00000004000015170000
27250019170F0300000000230000001A0B00
00020A040000000700031200000500000000020B171000021713180800060C0000000702
0000050005140D000014120700142300000600001500000F1419000000000B00FF0000F6
42085A210000000000FF0082FF004F080000000000010C0B04020000100F080603000000
000A08000000100000000B2400002008000512000000080900000002101B060000000021
170E00000E0E00000A050007120C0004000D2209000000000000000B0A03000000000001
0C03001115030000001E000C0A1800001200
0303060100000000000E130A000000000308040000000306180709000000040000000E00
000306100000000000161810000000000009080006000615000200072500008F0900FB7E
363EEB000000000E00F4BA00FF00510100000200020D1A00091419180900040306000807
00000213080A130200000C110000000B120F0001000309040003000A1613010000000000
000700000C0C0A0000000007000000200700000002130A00000000020805000300000004
0000001314000000001F182F22240E232000
0A0D0D05000003081000000200001A0000060200000008030E03050000050403000B0A00
0001000F00000000070E0A03000000000000000001040F0E00000000002300FF0000FF9A
365C0000838400000000FF00D6002E33020E0D000000000006040C140000080000000416
0000080100000000000017001E37130405140C0000000000010F1D000308000000000712
090608080000060A0000051001030E000001012126060000121500000809001000070403
00001A0B12000000001308090000000D0E00
100A0B000000000F0B00001A0B0000030000000608030000080006020014170B07010000
00000001030D140A04000000100200040C000000191E0700000000050000D20000FFBD62
00010061150000000000FFE9B1000059000006000C0C00000000000D0100000A03000012
04000F070000000000000600050800000100000000000000030F15000003000000091F16
030007100100000C0000000000000700060200070D00000C14140000000A000B14170003
171900010F00090C00040000000000080800
04030900000000060000140C1414021F03000009040000000000000B05191A0000000000
0000000A03000000000002000B000001070E0F020D230600050C001F00199D001EFFFF0A
000011000000000D660008F7D200006D00000500040C0000000002211100000F0E000009
0D0A1609040000000000020A0C00000000000C0302020000000001110707000000001600
0000030F00001000000C0000000000001100000000000000030900000006080613150000
000000010500000F010F1011000009080000
000004000000000100000A00001F24110300020B000000000000000A00080F0000000404
0903000C04000003080000000E0800010000001B000404000000010C00A40000FFFF1200
289400001AC88C73D05000008600005C0509050000000000000B0A0A0808040000020006
1008070000000005080C0D0001121F0D00002603000005090305001B04030B0000000B00
0A09000000000F110E180900021700000000142713000100000A110900000100000B1903
000000000B00000F0000070D000013010000
00000000000003040B1821060000000000000B0D000000000600000200010000000C140A
0F1200000000001912000000080D060000000011000002000200000B1E9C003EF5FF0000
A2000051592D24000000580000D30012000004000000111300000300000D190300000900
000A030A18070000080000060000001508000000000006130408001600000602080A0500
1C140000000000140000000000130E0000000001030E1600021014100000000600061B0C
000013000E0005160000000C030016080019
08030A00000007050A00001411000B0600000514080000000200000400000000000A0400
0408010008010004000000000000010000070E00001500000D0B00008C0000BBFF4B00FF
0000B71E008C00000018B700005600020000070D00000D2F00001504081A0D2E00001900
00061000050000001C0F0004000208000A13000900000A130000001B00001D1D160E0700
2008000917000023000006000911020000051000000500000014120D0106050000000000
0D0C00020400000B0000152B0B000000001D
000000001B15001205000009000000180208140A00000000011C00050000050008160B00
0005090000000000000006110C060000001518002200000E0C0B004617006BFFFF0000A9
595D2B000000000000552C00C600001515060000000000000300042002000005000F0500
000A1C03020900001300001110060000000016000100000A0500050015130001200D0000
0F00000015060003000000000210210005070000000000000000000704030D191D0E0F18
060000000000000003030000060300060200
150F020100000000000000030917131E0F00000000000505070800091C03190500000100
050100110300000000000100000000280B000009000014150C000084000094FF0000FF69
1800000000000000004C2D439900001500000000000022000E0300020500002A02000000
0F0C0108000C00001800040000000B050000000B000C0D0000070E020600000000001000
00000000110E00000002150E050300131100000000000703020D0703030304001C100000
00000008000000000000040000070800000A
10170C000000000200000000070E1100160300000A00040B000600091301160400000007
020000060000050A120C00000D07000002050013052B0000160060000089E6FF0000FF50
0000000000006512003572D00000321F0D000008120A00000000072B130000090000130E
0507051000180900140F0E0F050509070509041C00161D0000150D0D00000F1800000A03
000005000A1D00000000100B0D0D04191F00000100000D000C160F050A0B1B000F040000
0000040B0700081000001600000519000015
00050F000000001C0200000D050000000707000F12000000000500000000050001000107
000000000000000000050224000000000526000C000000000047780000FFFF0000FF4B00
1ECBFF00005800005C51E400002D001A2934100800000000120D0C0500001C0000001400
0000030000120D00000D0000000000000000000A00000800040E0F0000000E1D00000F15
0000080000060A0000000000000D14001401000800000B0002050400010D1B1002000005
020000000800002014000F10000005000004
00040F010000001000000D0F000000000000000D00000D050006000000000600030B0000
00050105141C0D00031514000A220C00151F003566377D5454440000B9FF0000FF00009E
00008367325A001D0000FF00000000000000003F4D623D00010000001011000E00000000
00060200000C0F0000070000040800000900000000000000000004000908000000001A16
160B0C1300000C0000000700010204000700001C09000003000002000000161E10000000
000000000E00001C15000008030000000000
000010010100000200000800000019000002020300000C14000000000700000308000000
01110014180700000000001E806725260000000000000000000000B4FF000048FF000009
00FF7E0300000000007AB90000001443390000000000008B6B3C150000001307000D1309
020E02020A0D1500000B0600140E0000110E000010070000000000000B00000000010000
0E0B061D00000C0A000608000002000206000017170500130000000000000000110E0000
041200000A0E0C140E0001000D0000150A00
00000A00121600030501000000000B0000130D00010D0011000000000A00001300010900
011800000000002D474E742500000000000000006CA57D000000B4CAFF0000482700007D
640000000086F8B16200708550F7F6FFE6D57389230000000041D9C135000000031F2200
000700001000120C000E110000000000000003000C0D0000000000150200001120000000
0002000B0000090F04020000080F0C0E01000000070C0013000000000900000000090000
081B0B00000D130D00000B000D0A08030A06
000A0800071A0000000000001A0D000D0814000000210009001519040B000002000A2D00
000300000C1E466D000000000053C1AED4FFD3FFEB8DABFDB8649C772E00007363000441
124D311C4CD43E00001805615952000000025190083FC416000000007ED0440000000000
0B07000008000C1000051200060B100D00102A0F00000300141B00100E01050200002200
00000000080F10030000090512120900000E0200000D0C000000000A2517002200001E14
000000190001261400000000000E00000014
1900000104000810000200000F0F0500001110000006000022001E000B00000A00002100
050000004452000000155DBE7E994E580000000000000000005895260800007F58685614
0E3F3D6C240000191511000000000005000000002233063483928100000035FF83000000
010D12000B040000000814000800000B02000000241200000A0B0800160B000A00000003
0002210000040000170200010A18010D0B00000A0000000D09000000200C000700000C11
1205000200090000000007110B0F05000000
0900000B0C000004000500000000031B0000000000071428000000001721153004000000
0023408C00000096ADC06C0F124000000E040F2A2A000D3819040023318C640A00230020
00000016030000350002000000000000000021811A0064092E00A9C59700000000FF0000
1A000E06060000060A000000000200000000000700120B0200060000090400001A100002
040F0A090E1200121400020100050000000C000003170700120900000706000000000F0E
181C200D0000000000081600051C00000004
050000040704020A1A12000C0600090D0000080A050209003814300020000000005085AE
A3500000001CDB4E000000000000002100050000001F0A00002A45000000000051272227
00000000000000000000004B020E490000000000000009005B201D0046A1DC000000FF1F
000009000000000604000000020808000000000D0212001300070001000000001B1A0000
0F00000000000003000003010001060000120B00001C000010211E0200000000030C0806
0A090B04000000000700000A070B0000070E
0502000004060F14100A041B1201000000000D13070000002D000000003D81F1EA320000
0000000025C72400330000101D0008000058004E00002A1BAC4000000000678B14000904
000B0000000C1B002F0000162A003E064261002141871F21000B0000340384DC850000FF
090000000000000000000C0A030C170000000000031C0912000000070000120700000302
040000000000000200000502000B010E0000170C00020009060000000006130000000000
1C160901000000060700001D040405080B04
090E06000000080600000800000700000000000500000011000C000076D9310000000000
0026D5A157000003771E000A0043150023360615410A230017170000FFFFCA0014000500
000C00171C0805373B003000220008000B026400000000150015050009000059A2FF0000
C60000000919150100000104000314090000000E00000012000000010400051300001213
000929130000002116110000000B00000000091C040021000000000C1307000000000000
1B140402000000020A00000200171D000000
000D0F000000000000071900000E000006050C0D0100000B00008AFF5D000000337F7973
B56984371624000039414600000A212A0A001C00061A3F00030000007C0F00002D140000
000F000C0100000000000023000000272E000000002863002A0E00030C0E16000056CE00
AD750000000912101302000000000A11020600002494A216002C00001700000404000207
000000000000071D1A04000000241400100000000A06240000000B1B1B0300000E1C1900
00000001000000000000000000000F000000
000A140600000000050B1D00001D080003010D1B0000000044FF1A000000D068B5123D53
180000240036001B0600001274000000002C004300133000340000000000182000001C06
001F000700000000000D00350000000000000E37882B00001E261D28122D32001400FF00
00B700000000000F190F00000000080E030000458400009A120000000D00000013050000
000000000000070400000300002719000D0A00000006000B10000000000F180000100E00
000000000009110803000018000000000200
00000E080A0E0D0009000300000D110B00000110000040FFEB0000004ED66D431F002A13
00001E00000C0700003F000000004B26000D0011340015150E00132C151500000013214D
00001B41370F0000429012000049150000070000000000472024101D0800000400008DFF
0000AB000B0B0000110600070701050F00002057000000B200201205000D231600000000
1A568FD69E2500000000190600150000000009010E100000070000001A1D080000000000
00000000000303050A0000170C040000000D
00110F000C140300000E0001310000002700000000F3FF0000005F7C4E0B0300165E0000
025A28330000500000004304210000000008000000000000002A000000003A2736260000
5C354F00000070FFFF5A2600200000001600003902452E0E0000000033000B4B4000147D
C80078A41912000022000A00007B393F2D160B009F19328400000000000317000945B2B0
FFDA0000009100000C001C1D00090818120D000003091D00050616060000001C00000F00
0009110000000A06091B140905210E040B10
0000000909000A0000250900032E000000180017FF00000000513D0B8C7E083612220A26
0E00000431002AD06700005D5904000000000B00000000000000001300204C003000A446
131400000D7BC7000000001B08101910000A00490000000055000000124B0C0858190000
B400000001521A000014000B01A000007028002EFF005F000E0000004A000059D51C0700
000000000000FF000000000D220000290A00000200000700000000100500020800000700
000000110D0000000D070000000700010100
0400000A00000C0624000000001A1300000094FF00000BA2AD936E45350000210000000D
0018580112000000FFAF00000016004E7500060F00620A000D485B4A3F8A2192FFCF0000
AA5267D03F00000000FFFF37D7FFA42B7A1F060000843C00002E5D1F1F4F0010344E4F00
00D56000000025220000280090000069000002FF00007E160200380F00077DA500006200
00D5A1D3A6003C0C041C00002700031E0000000000000007000000080B06180100000000
00000000110900040A0000000809001C0D00
0200000200000D00200A21200002050000D3B100003F8B587E48524712000C0000001445
1600000062A1920000CB91000E201000003829245A24000042A8143D7F0C000C00002CFF
270000008B5AFFFFFFBC1F06000000000000001D00000000002911000006210000003700
000030869800001A4D0800134F00E55B0000FF6B0000980E002900004BFC0000A3FF0000
FF0000F36749000028161400090D0023010001100902060B00040A000004210900030000
000E00000901000B0000000F050000181A00
000000000B120C09000800000017001CFF4C0000958CD632450000000000242100000000
07233900110038FD0000CA42000B5600074103000E00081A2C9724060000000000FF6400
0000FFFFD400000000000000009FFFF3B386001A000013BD695700000000138F15001F00
4510000006E3320000782C0A4C00779200FFFF001600EE01000022D4B60000F2FF0000FF
001600C700FF00000A00070002000012000004070000000700070C0000082210070C0E00
000201000000000500000A10000500000000
01040200010D000800000924000024FF00002DFFFF6200000000121D1611240816221B00
0000041913000B80FF0000FF000033000008003D24091C0700000012000007FFFF0000EC
FFFF000000000000D9FFFFFFFFFFC729548F2E00A8190000000800383E00000D38095800
00262400241EAD9C0000EFFC000000FFFF5F0000F90076FF6389C4000000FFFF0000A500
000000000020B00000001200120020000000000000000000000007000009100000151800
0000000E000000190A00040000270A000000
0C020000000000000F0000000059DC0000D5FF630600400002000000010000190B000707
1A00002D53000000FFFF003DB70035510015001A000000384C0000002B84860000BDFF00
000000FFFFFFFFFF470E00000000000000000000004F0000000F245E4000000021000000
00000018000A00B9B800000000007AFF3D0000516500006FE600000000FF420063FF0000
00737B000000FF000D00461812000000090E110F0B111D02000004000B10000000101200
0002000100000D150800000007270D000000
0A00040E00000E1501021D00417E0000C88E00000000440000002210060000281C001212
08000F004B9A0C0000FFF8008F31007C00000500001A394000006F003C00001900000043
F6FFFFC10000000000000006002CB0FFFFB45152000000001D000000002C281C00000C00
28002645005D1A00A991000029CCFFF70000FF4A00330000000000FFFF0000FFFF00362F
A772000071FF00A53B0017090022000D110A000000000016000019020C0D0000081E0900
0219050000080500000800000A0700100900
000000001A010500000006AFD50000EC55000044380023121A0000180C00000028001E00
21181B00004982000064FF0000FF0086120015001A15101B00003E1F130000007284B900
0000000000E1FFFFFFFFFFFFFFFFFFB4D9FFFFC3FFFF832800000000004800000AB72B00
000F000000000011190A37B7006CFF00008217002EB7F1FF0000A7FF0000FF0000000087
000000FFFF6E00FF88004800001A000D00001004000000000301060B0400000900000000
0000000000060000120000070000000D0400
0D00100000204100F1FEBA000000A6120F26000F00002F00676700001408272500000009
3300004A00005BCC0000C5FF00002100550000420000123B3D0000390000821000000000
00E2FFFFFFFFE50000000000000000000000000000000021700900005400376800010919
001C5B0C8D1F00280007078500F2000000002A0465594F0000FF9F00D1FF00000000FF00
0028FF75000000FFA000010017121400000000000001000005030000050000060000060B
0B1200080001000000000008000100060A0A
00000000441D00C200000000079221462500000054617D00003E3A002B00000B0323001B
072F2C001D00003FFF0000FF0000FF001D000032001200001F1F0000401F00002B73FFFF
D9B3000000000000000000000000003B00000000000000001BF100000000340200003300
410000000200005300080000505E00FF0000221700440000FF4600FFFF00000008FF008E
FFFF2600824D00AB970000002E0000000000030109000000131500031004000F00000000
0D1603080000000000000005110F00000000
0012012B2C002900000000579304070000005C186D050006060067230E000006093F000A
18000006824A000087C20000FF001A390F13004300000000030B003F2F3138000E000000
0000003DC7FFFFFFFFFFFFFFFFFFFFE7D6FFFFFFFFEAD06900B50000440032003B052A00
2C0000360065210000040A00F00000FFA175640000503E590000FFFF000000FFFF004E71
00000000000000FF9E001405030024080000080404050008151C07010300002200000400
0013070000000A0000030000000E07040508
0000003A420098A28064194D170007180010000F21090051000056772700270000001E09
000000002700000000FF9000FF0000FF003700000000681D001E4C00000000000700CEFF
FFFFFFFFFFFF000F00000400000019104600003CD42ECEBA5EB2E0FF00007A0034000003
000023C400000000205C00003D009A00000000000052010000D650000057FFAE00EA7271
FF00006636FF3F86000024040600000000000000000A0000060A00000000001000171E04
040F000000000D0500050000000A0A0A0D15
0D0005007A0013AA006D5111005500005EC40000512F000600001B8F2C00000059004100
0029170D220028000000FF0020FF00FF0052181228011100003B00090000133800004900
000000000000000000000000000000000000000000000000000000769402000024000459
09230A0018060400001900430000ADADA600000000000093FF5E0000FFFF00000077FFB1
0000FDFFFF0000276B0000000000010700000000000B0601040000000000070000070E03
000305020B00080D00030001030B0000020D
1A002300510005890B244907007E4F13B68000003A2F00872A18005275000600000C000E
3423000000005C0D000090CD00FF0000BA3E0000271E000008161D3E000B080A15072346
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF98FFD4D21BAA1115150000000FD7000056002400
332500001C00200C150C0000323000272D8D07001732AA2400777AFFFF000000FFFF0000
BEDD00000000359D86000D3D0000052903050600000B0D0D0C0000151000160000000000
00010A042200000C00070000000000000713
00010B00B8000081140000006D42B5FF620000E55F000A3510330051EE00001100401D2A
004840221500007B000000C00001D900AE390000071400610E00552A002313000F5F82F4
0000000026000000000097FD9C8FA7D2FFFFFFFFFFFFFFFFFFFFFFFF4550000000002400
00000014000025134B00290E470000000C8B9C3F0500000000000000000000FFFF000000
4400300000CF7800720000000033001D0000020000000B08060000162E0D080007000000
01000000220000000000000300000300080A
000400009300008737254A52630000000000CBFA00009300000000006F37004C02000000
000000421D620A85212500006E00FF00009FC200210000440000000800002F0000000000
00000000000000000000000000000000000000000000000000000009354795000000263D
000F5234004F0D0000003500413A2E390F000053B8000000FF00000000FFFF00000000FF
C1FFB065C700130013000017000B08000000060000101C00060000000402000000000008
13141C001B0922001C0C100011000005091C
0000000B00DB001C50006D61150000000030FF930000C04100000000C68C005E00000000
00002200000102007B580000498CE7B2000C00000000000000020040000040007BDEE1FF
FFFFFFFFFFFFFFFFFFFFFFFFACCEFFEDE469FF450D00000000000000000000C4261B0000
002200001F27000E0048000009000018302A0004C4587E440000000000FF00000000FFFF
000000000001ED000B0B100C0000001216040F0000102000090C00000000080100050000
00070000000F003100001605000026200000
2420053200E60000000000000048B9AE6FBFF100005A0123005AC100BC6000001700001C
000000001C1E47008F6F67A26D0028D1004000000069452B2A1400290F00050000000000
0000000000000000916DFFFFFFFFED40A0FFFFFFFFFFFFFFFFFFFFFFFF0FDC5C00034300
000000194C0000150000002C06000000000000002138FFD50000AA00000000FFFFFFAF00
00C3FF52FFD8BC00000500000900111A160914000003020500000000050500240F1B1800
000000002B03001A0032142918000000101F
05000000008B589EFFFFA267050000FF58C1B700005E004200A90000FF00000012170000
132600271600004A000D6D2500000000001D532400072E00000000062E0000105A77CBFF
FB26AF000000000000000000003532BB0000000000000000000000000A00000000220000
380020450000000022005407165F00008906000000050000FF96CE000000FFFF00000000
303440700000AA00122400000F0003000605110000030013000000040A00001A1B1A0900
000000172F060C0006000000090A00000005
00002300010057451D0070AAF7FF000030D256004547003500610026FF0000000E003800
00310000002A7772000000000022007406000000003500001929212100000C0000000000
E6FFFFFFFFFFFFFFE3B900000000000000C9FFE2000000000000000000001D00006E2800
2500490000005C000000000000220000000008000A00350070FFF7FF9CFF00000000F4FF
FFFF00000000FF005916050D13000B0F04091507000F0D0300000A01000115000C000006
07001800000F00004B566A1200001225000C
00000000130000000000000000FF2A00FF560000C2350033BC0000A76D00001C0000001F
2825020013121E450044000035002944610000008786000F1C0000181E00311200420000
00000000000000FFFFFFFFFFFFFF450000000000FFFFFFFFFFFFB1AC8473FF2900000000
0E00002E00135F00002F00170700000014002E4D000000000000005AFF00009D00FFFF00
0000000030A57D007F000813000000170A00080100130F0500000C0400000F000E000000
00000E000023A8FF3998006E3F0000150000
0017032700102600220039000071CD00FF3A001B6F082209003C00FF8501000027000044
0000000000001937005E270000000400A70000F24E00001E0000000038000000005082FF
FFFF70000000000000004E60FFFFFFFFFFFF8B000000000000C0A88A0D3E04005E1A0000
00003B2D0000180A0A000B5B0A00372A15001E100A0047002C0000300087FF0000000000
009CFFFFB0A300008500031909040C000000030000060008000000090E00000F0D050000
0000003EFFE3530000000000143200000008
001F00000514000006000A110034DC00FF0000FF57003B00DF0000FF0000000310220900
2238000B2B36000C53CC880000000E005F4600080000002300000B210000113612000000
0006FFFFFFFFFF420000000000008B8800BAF9FFFFFFFF00000000000000000B03003F06
0D4814002911001900000000087F320024071408010000000035001F00DC70007200D5FF
FFFF6A22B3FF000088000000060200000001190E000700000005060000010700001E1800
007671FF000000000000FF001F1E00060600
0606021300000F09001E000F003B6F00D500B84F342D07BE0000FFD62D00000020003500
00221C0000000626009A8405050000005CDD0064AA00000000112D4200000064063E85FF
0000000000A6FFFFFFFFFF360000000000800000000071FFFFFFFFFF0000FF6C00002A00
004F270024002623002D280600000003001F000000002325004C000000000090471E0200
0000000000EF005E2909090C000B00000000151E1F12000800260000000000160016003A
9E3E00FF000000008DFFFF5F00590A002100
090000110500100000002B170B05301A0000F1233700C3030078FF330900001F0900002D
00003B16000058000000FFEB0600140000FF000A6F00000100000E001C00000007870000
00FFFF630000000021FFFFFFFFBF000000007DFF99000000000083FFFFFF3D00001B0000
000000220000110100000E0C3C00000000000E07006C000000000000431A19393F000020
8C05A56B025A009E310000000D0D0000000000030800000000000002000920150800844B
00005700000D62FFFF000022003600000218
0E000010000010000300100000882000008870085700000000FFC0000200003B0000003E
0000295B00001805A9008AC40000000000FF00008600008B6C02000000021D51000060FF
000000FFFFFFFF0000000086FFFFFAFFE0000000006BFFEAC2000000000000004E2F0000
5100290D00250029000F00003D0009032600495F0600257100281C0000004C03536249FF
000009007C001A3B00150C0C18030000000000000000001B3100070000120000248C0000
0F27000000FFFF00000074FF001B0A560000
06150B010000040B00000118128300000045B200000000C9A366880000001E372D1A0000
1400000E00001292D400009A003B004A000077000000007275E7CE00000D3100A5370000
FFFF74000000D7FFFFFF00000000634FB5FFFFFF0000000059FFFFFFFFBE6C594E000023
000000004F5F00000421100000001D00001A00003100300209383100090000000D45458F
00003A00002C4900000E00000000000900000300000100000500410000045D9C7F008600
00002960F509000000C5FF4A00251A0C001E
000A1600000E0000000000006701000000E74B0000D04767B6806A0058051B002D000000
001700100000185B0000003E003D130C0000FF00000000570000B8FF42002200006AFF00
0000FFFFFF00000000FFFFFF0000000000000C4BFFFFDE00000000008A00000E00003F2E
00002A00000000000C0C2600160D0001000C00001B03000000005229825B003300000029
5F00003A0500000400080B041700001E0000000708110000180000008AB46700004E0000
0E00300000004CB24375000500020500160A
000000000213000C3200160060870000FFFF0000FFFF165DFF0000002900000035003A4D
458D00000000355000DCFF84000000131A00F5004C000000000000006BFF00005A2500FF
FF0000002CFFFFA0000000F5FFFF5E0000000000000033FFFF8CFF504400000000060000
1705763416005800211B000013310013002106000000215C000900000002002600091400
9000002D290004000000000001000D07080B00000000050000008EE30F0000BA00000000
0700724C00B39400000000FF4500092A0000
030000000108001E140000171E410061FF000093FF00000000000C00004CC1FF10240038
0126001C37003949000BA1000000291D2A005D3A39A90000A0FF00000006B80D0008FF00
00FFFFEA000000FFFFFF00000039E9FF1D00059E63000000000009C9AE46020000450000
43000000000F24000027002400251E0100170D23032B000000251E0900401700002F0000
5C65000000144E0C0A000000000010000B1A140000001952DDEA01000003FFD200130000
440A6C3400000000CC3B00A3000004040000
120900040000130615001F62560000CC6F004F0E0000000000711F100000793900004BCF
009C3C000C002F0000B3FF00000020000047001C00BE00AF00008BFF410091FFE20000CE
080000FFFFFF000000FFFFFF000000007FFF8000D56BD9FFA000000000460011001F1F00
123E000000250800282100000000000000000000001C0000000029530900453D34002823
0051784200000045ADC5FFFFD17006000000005294A3A10E0000000EB5E60000000000F6
AF246D00D130F11A00001600000A00001B12
020F211B00001000040000790000436200000000002F5B66FF2A004210000000003B4C07
0005D2000000492D0038500000001F00001900FF00B700763600804058000000FFFF1400
9D9C000000FFFF4C000000FFFFFF000000000031005F00000DFFFFE60000006000002036
0000326618000029080723000005492400001F0D0000002E331C0000060000001100722C
00004418665A000000000000004FFDECEAA4BD3F00000000000EB2BF0D000000009ED700
00000000F31500000000A7DE0B002B00000A
0308060800000C1C003FB1000000FF000000000000016BD53F0000FFF152000000201100
0000390000001F399300003300003400140000D800FF00000D00620000906A000086E591
2FA9FF2D000076FFFF000000001BFFFF00000022000080C50000000450003E0000002A00
1001007E00001E100000482630000B0000182D000000003602000100170A000000000000
0C0A18155B64B543270000000000000000000000000043607D5A430000298400FDFF0000
00DDFFAB00000000009675A7000011060504
0105000A1309030000259C00004D9500007D00002E05862900000059B7FFFF69000B4900
B8BD343D000035679A00C30000001D00300000E54CBE000016AB550E0000837100000000
B60000AFFF000000B1FFFF680000003441C35F7B1D7300288030653A00000005284E0000
652F000C002C051C441A0000000510052C0000081B573A2600002C0000000046003A001D
0600160D0000214E91BBC3D3F7C962000000A68CD9BF000000085631810000FF000000FF
FFFF00000000002C606C00B4000000150A1B
010000081C0A020000EA0000435E27FF86BD06003728040000840A0000005FFF00004700
000B00063A000B6F0000FF0000050600000C008A0000AD0000440000000B0079B7000000
003100005CFF630000007FFFFFB5000000A7BB004E4F1000340000310B430F3A00000B00
000B001508140000000020001900110300150019220000180D0000000B00591B00490000
00001700000004002C3431646357BABCFFCD592E63271A0000133711000000001AFFFFBC
00000000FFFFFFF500002C82002B14150000
0000000F1200080E00FF0000997F84001F0068BA004900013137705D000000D5AD000026
00082600000026E400008E0005023C000049003A00446300003018032100010000FB0000
0000B96D000000FFFF0000004DB9FFFF260000000000541300001E380000032800004F0F
00001E0006111F260015020B000F00001E002D00000000002E1D009460000000005B3A00
33030000090603000000000005000000000008000000044E07000000890A6FFFFF490000
02FFFFFF0000000000015C71003A0D050013
0900030D0B000D0013FF00001556000000B11400005000FFF73B0000FFFF0000E2C6001F
0702242D000015CA000C2A000000062F0A070020FA15000005005A2E0000004E2800522A
0D000085A025000044E8590000000000FFFF0B0000000000007D103A2720000001000000
002B00000A070000004A00001600240000011400304A2100391D000000111C004000002B
02040000172700000000000001000F00180001000000091300175C0000006900000000C1
FF79000000000019001E718A002700000022
0906000A0000080500418FDE0000180000200000FF00619E00006550605AFF0000E30000
0E3500620000355000541A1B0E0000180400005C000052000C00004E4100144F0000156B
3A00000000ADFF5F000000A8000000000000FFFF3A001467220022000004000001390000
4A6A000800142200005514040008000012001A03000A050000090021050600003D00001F
00356002001E00280021190B070030003B0000204322000C00000BEF0038000076FFCA27
0000000000731600531202000018000D0A00
0C12000404080506000076CD000000147158000000004A0000CC542B5300535B00A86300
033F000028005E4D00280000003100003412000C278C000019334B280000006C00000301
0000230000000015A060000053FF002B0000000000475A555D0000004F00001602270517
6200005B00000000000E21001514090026020000000010000501660E15140023011B001E
001B0612000000220C0B00290000001300000600002D000000000081809CC1836F15000A
001D7BDAFA6F185D5A00BE00002100081600
1108000A00000C001511310200000000005400002CF02C00FF3A0000091F00FF0000E700
00C900005400B200002600000800004D00000072007C78000000003900002C2B442C4700
00334E59D3AA0000005A974B0700FFFFFFE8B800002F00000200060E2000003500000C00
00000000021620001E00001A00001D44001D0106170000072D2600001C00002C00000600
002400000242030900280000294000003339000015171C3934006500000000000A00002E
00A67000000000000000FF00002E00002100
0000001612000111000046C9003D411D003C120030FF00BE920200000041044DE9003D6C
00B8D6FF680069000000260006251A140000003D0000900000000C0C000000000000351D
002400150000312900000000000000000000350D0F0E00390000030E0A000C2700000058
1F034800290E140000000000002500400000120000001416000051260000453000401717
1A0000009C00000050391A010000005F00C70000161F0009000062FFFF00000000000000
00000000003D004CEA000000001E00001500
0000090905081600270000B9FF0037001A380000E60000F4200000FFD600B700F000007B
0000A8A400001F0000000D1B0000000017240015005CFF00090058000000003630000035
0022004E000E002B1C00320A66085710000059000E2A0055001C001A00003D001E0C0041
00003D00000000000207131700000F0000000C2300486200005E6F00000E000000000000
000000009324001D00000000002E00000E00000000000000628500000060FF7E3B16FFFF
F5BF44EFB35A59005C009700000F0500100D
0113120000061A0C24000000FF00000080CB00ABD100759600009800FF0000008D0000C5
000046000037230A1B2300282000000044030C16D1DF5ED7A100310000002431101D0108
0728000800550008000F4200003F0000963926270000005900000038220000003F000200
001000285B1F194F000100000028000000681F0200574E0000080016300056000A002111
00000000000000000000235E182000000007E83C71FFFFFF0000FF000000619AC6380000
23190000000000004100FF00000213040D1A
00000600000000000000000043FF000017B7006B5200AEA5000A80002CE600686705007C
1F000000001921000000000019000000320062790000009A0300005100000D0D00171700
000E5B38000200060B00430B0000212200000F00001D001240000700000026383F000F00
0B430024000D2E0000590047002D1C0100130024002B000000002700001723007C000009
0007001EFFC7B6D3FFFF97573AD7FFFFF5875BFF4C0000000000FFFF0000000000180000
00216277A18B3FECB500FF0000000F070716
050407000000050D00220E060023FF00003600FF0000FF0000E6260000FF001BC3000004
54100037003B5400030900140A1B000000000E000000CCB5006D000000361D1000022C28
00002400180044002A00540B19001D2C4F5B000E000100360000004B0B17070000001244
004715053F00002F00000000380000003C170000000C0000230F00005700000000004400
FFFFFFFF006CFF000000000E000000000000000000000900437F0000FFFFDDC100006700
00000000000000000000FF00000702050D03
0E0F090A00000F00040D1600160025FF000059EC0064200000980000008E0000FFBE0099
5500072F003F2E000B2D0000003114102B06000000A2004E00560500000000471820000B
0536310015004100170E170011150013003D00300A0014000056007F0D1800000B1F2E14
0000000030000006130001001900004E0027000014130000202100000000001B64FFB282
6500850000000000C200A1FF4900F6FCADC4FFD5FF00FC0600270000004EA848230525FF
FFFFFF51000000003C00A400000E00001300
000000160E00000B00000011000800A3920000C100BB6100009B00002E210000FF5200DE
19002800087663000000002B185500000B0C062A8C000099180D030000000000003F0000
00001B000000001624000F0033134700006B3B2800360021002A00002A00221346060900
2B6100002E001500205300000011000012000000922500390000890058008AFF000000FF
00000000FF00C4FFFFFF7ECA6D1A2079203C00024E3A440B004E3E7000000B0091350000
000097EEFFFFB7FF8600A300001500001E00
001500000606000100030E0600000000FF0000A700FF000024EE1701414BF300FF4300FF
00005B0000001700051F0000004E0000000500467C00000047500000008CAC1700000000
0000311D00570043000000000022150050083500A1000F00503C20004D00000000000000
315E00000000000B39000031003600006100631F000000000000DDB3FFFF3F000000928D
00FF00FFBE00003EAD000000007A0013642C0030012700432716006800000A0000100029
000000000000005F4400FF00000708000500
001608001005000700000A090200090059FA008F0000E900BC6145181000FF00D2DD00FF
000051001E480D0055131B260004032F1F0400000000001483000000070000070A172A00
4F28000000590054033B0039001800008403000000533449000000004F2C33130057000A
0B001300249A00000000091A060C0039002900002D0075E0FFFF6700000000D4FF55FF00
FF95FFFA00809B0000F9FFFFFF0000000000FF8E0000003430005B2F8B68001C0000000C
0094C0A5000000000000D800040F06000000
00140C030800000A000000050800020000CA00005C00FF00BB59FE662245FF0050BC00D4
003E3800003A000001006B28000000310000310000320000520000164800001908090000
5C0E003403320032004C0C3100250036A3002C3112001F510000180D24000010004C003F
1F00250000990000B84F11164A009A0B0D00000053FFFF0000000000408B00A7002D0000
0C85000000879A0041FF300000FF31000046AF006BE8001854000000000E00A9711A0621
1700007C6766E07C0000E200000B0C000007
000006050000000E090600000A030200002CFF000000FF001C00006A89FFFF008FFF00CB
000000000800003C000029000012110E00002F002A0200000078000011242E2011180000
0020002F1500001200030027390700093417000000005B00000027000000001900000000
00141100006900000000000000000039002CFFFA9C0F0000000000FF9352CE35FF000000
000000000000000000000000000065FF000000000000542D32001A2B00A3020025620036
0000000000002B180000FF00000E0F0B0000
00000000000000040E040000080B0D080000AC6D001DFF00006800000000FF00FF0000FF
00111A006C00003B0027370000312E1A1C00144A0000020000AA270005000F000000131D
00000000000050001900000000000068010000260D0000284300001E2C51A50008032E00
00A20009152029610000004200C541FFFF5100000000BCFE00FF0A9E00008700006DAB84
B5001E0000000000000000008000000000003000000000D40000061200007300001A1607
3B85CC08000000000000FF00000001110017
0400000000060D0000000000020C131C000000C50000FFA100FFFF0000009100FF00FEF1
000C000055002B2B003A0D0400122000120026434D990200107457002D00630020000022
3B00002C00004E0D00001B453759001306003174154C000A00040F4C000300001C3F4000
1F8B00002568000013970200FF000049000000FF00AFFF6DD012F30000FF000000003D00
0000000000C10000FFFF3A00003066FF13000046FF0000FF7E5F0000433F261E3C001A3D
0000315B770000271B00FF000000000A0022
19000005000709000000000000070600130000B23800A5E00000FF5200AB2F92F200C5A5
0029005C47000B00002D001F00000B0000001D00005AFF000068410000001E0026060000
4600003700002E0B000D5A000079002CA439700800680030003D021F002F003A00006000
4B007B4BD200007C140023BCFF0000000000FF4F79FF000000FF007C53185B6C002C0000
0000FFFF000041F70016116C69D56986E7DAD747000000000000000008001E00253A002C
00000000002829325E00FF00001A00050000
1600000A0014060A010000090C0400000D000009FF00ABECA9000055000000B70000FF00
000600000008440000320059001E2B001700002553004900004D5A001785003C00002808
00000C0800002F0300003E20000081010000251900791F27001700001C0000515D002913
38209C0000E400004DFF9E000073A800FF00FF040000813100C9000042000000006B004F
0F2B0C0010CC7F55329A6A471E000000000038ABFFED00C20000FF001A0E093F09074800
0248181B2D00006D1A00EC00000300000000
0A0001060000000600000E020000000004170000B1460014AE7300000000000000FF0000
002E5B00000066B51C0F290000004400002C95420A48FFD6000068003100005300000000
00345807000A0007100020005F000011003B3D00240015000F003400166D0000001D00FF
0000000000190CA0AD00000000FFCC0090E2000000FF00FFBB000000B10000000000ABFF
0039C0B4691F170016000000000000000000000018B59DFF00007900472F0000000D000B
00000E050000001E8400E808002812002D1E
100400000C06000A00000D00000906000A00450000EB0000C1C25300002C000000FF001B
3D7466135000000000000000001A0B94F3674D3C0000001E3500AF003300005F00000032
12160000130018000B1F18000000183500A1005C2F002B007E00220037008F5953000000
007245FFFFFFB9000000C900FF0000FF00001200FFFF2C0000006D002C0040FF8EEFA900
00B500000000050000040E1209000005000D1A0000000011FF000000230B296300001820
07280015BA2E09000000571E001021000000
0D0500061104000C0003000000001317001306000029FF00005FCC74BBFF2400FF0000FF
88780000DE000000A3AD00003B0069AB0000000000FF00009900B6002D1900010A231D00
010000003200000915000013214500393C750077004E2C3D241100850000A0895C00E500
07001C005C87000000FF00B6FF00CF66827800FFFF000000451B5100000EB05300BD0000
1590004B0000210900000012000000020F0D0A0000001D0044F3FF00000000002C170041
000F000054B1F0F0D700EB73000025000000
0004191300000F14000C0000020009000800001100007DFF00007A774FB10043FF00E300
00000033000000FF005200487A05030000000000F310536B0000A5321738360000002033
00003A0D0010005355082C00002D000000005100004400DF00E00073A8D9000000001D00
75C9FF000000FF00000000FF0000DC00000000000000000000000000003900005F000000
D5A8C5FFFF00002200000000000011001F0A00000100090900003BA655000000833E000D
04000D00000000005F003DA00000130A0900
0000160C0000150E000900000B00000000001715000F00BFFF000000000000FF3A000000
0000042B000DFF0000000000000000000000C0FF9F00000000365F1100243E00281D0004
0001861D00070092110000000000001C71008A0092003700005A00005400000000AE5800
C900730000F3A700FF00000000000000000049000000A4FF000000002FE500000000C507
BA003B0000ED0000080C020300000905030000000B0E00000000000061680000020B4100
4A164A6D5F3D0000000000B5000900021502
000000000C1500050000020005000718000D0000280000009EAE00000019DD540000005F
8A00000000FF000000004C573100A0E7FFFF8F00000300001E640000203C000055000E4D
113313002400003000170F32001B3609002A6600F100FF00FF00A16300E0A3FF517FFF00
00001B0059000000AA00FF50CC0045004C0000E6FFFFFF4C220039FF7D5200007200FF44
00000550009C5800080F00000000010200001A04000000001B1E1500005A250000352E00
0000003032190C2D690068AE00350000110A
050000000E17000000000703000E0B00000000140E00300300187FFF0000000071001700
004300004870FFFF003400000074344E0000002100005F51350042002F1E00230000452F
00002E00110A8A0000060300001F00550080004C0017005C0000C50000340101D5000000
005919000B00A4000000400016002500910000FF00000000B2009BE200D8535EFFBB0000
465900000900FF00150900000000030700001B0C00000000270021170100450000393468
17200000000A084A34002BA0004000000C05
00000403060900000000060000100B0000082004021100000C00023BBE0000001B0030A2
008C93000000002A5C5500504F92001538450023803E2900002D00050013303700450000
00004B000023000642022500689E0000002900FF0058003B0000009CFFFFFF0000000000
90FF0010001800430D04090000000000FFFF23000000FF001E00FFFF00FFFF2600005200
007F0C204B00A700100C0000090000060000000317190200000602002000005900006F46
4C00000000001D29460000B7002100000300
000003010000002200000000000006080000160200020000070004006392000000003E0C
332F920000280000001F68240014005BFF00007E0212005100132200004523001D6C0000
29340000560000330B001C3100000091590046950000D4529A3FFF000000000000000000
FF00000800150000006100330000003FFF67003500030000FFFF0006FF94002800003B5B
0C000096530069000023160000000000000100000006000000001B060000000044000066
25001D00000000006C2900C7002619020000
04080104000000190000060B0504070F000006000000000514002300006FFF10002B0400
250000002217003AFF0004EA4DFF00000000FF98003400008700624E19000071031B1427
00653B450063310000D20082000000000000920023000000B94A310000000000A42EA543
0001050000486E040000040044B9FFFF000000ED2600FF71000040ED8900000084410000
7800000057730000000703030017000000060E050E13001B16100A0A05000000006C0000
DF644800524000001D00005F002D002B2F00
010506000000001106060503000400060605080C040000002A150007000025C700005F00
002E0000004700750000000000FF000000001F0C00008000300023000012690000290000
5400008A000006002E00001D00E35A0012000000A4FFFFFF1300000000005D008C00BE14
0000000A070000370000000DFF00400000130000000AFF5700F8FF00006B140000250000
2436000000007B2E003E140B00000500000006010E0B00000E00000F1404130400007500
006A20002100001F005F00FF000000020003
000000000000010000060000030100000C00000E0200002708000007130000CF69008820
0000006C60000000003A000000B60700A0FF00200100003100060054003738000042006F
0031001F880000006400000000000093FF87FF380000000000000F004A96460004000000
003121240000000000FF00D1000000005FEB0000FFFD0034FF004A2700001F2800004700
000C56561B009DFF002D0C001D12000000010500000000000E0000000000000300100049
0000B50E0028005E0E3400FF000A0F03030A
000000000300000007050000040B0800050000000001171A0000160900000000FF2100AE
24000E00000000002E00007B0000C40000FFD57100230033001B0000000051002D00003F
5A4D00090015B900000A182100066C00140000100000B1000053006B770000130D2F0F12
070F0000005B960000BE000000260007009632FFD80000FFE90000380000005E00000067
0027000030002B00003E002D0000130900050807000B0D0A00000B0000000000004C0102
3300009FDB0000000B0000FF00150D060D22
0200000402000000000300000004040000000004040507011C020000271E160027FF000F
006F5700000000000F4400000000FFFF000528FF003D00A4382E00F1FF922206FF66FF5A
0000FF7B2200DD987000C5FFFFFFF3000000218E0000FF00FF00000000000F0F00050000
001532141F0F88007CAE000007FF0000FF8DFF0000FFFF00290000001849000059310000
001800000000AA620024000015160007000003000001090000001000001C0F1700000500
0923000000DE7D56000082E7000000000009
080602020000000900000000000001000000060A0A0400001700060A0000000000E85E00
762A007E66000071000000FFFFFFFFFF9F5200000EFF000000FFFF00420000FF00000000
FF000000FF60000082FF00000001000000232700250000000100002B00006B0500000089
4B99003F81040000000000FF000000FF3300510000FF0B00007644000D867B0000001700
26023E3F00007700001D01000E0021140000010000010B0902000304080A000D07000013
0600232800004516DE4F00000033000A1600
100D0F000001031E0406050800000007000000000015000000000304162F00000006FF00
000000050300F8120000FF7D00000000B300520000D9002900FFFF00002400FF001E0000
FF000000C000000000CA0000000000FF00000000BD000F00180033000000000031DD5100
18000000000000000005FFAA00FFFF00000000FFF5001500005E09000000592D0507005B
000000450000FF000000020C070B031C00000803000014000E000001140300001F000000
002A001B210000000000000A191E13000000
000005000006000B0F00000000000000000000000000040009110A0000000A02070035FF
000000341E329A000000040087FF860000001754000079005C000000002D000060000000
000000000000006E0012001D0000FF0000EC0000000000230027A3000C5600000A000045
00006C00FF9700003EC5000000CF000071E309A30F000F7580000099A9000050162D001A
004200240D2F8F00301D0000000D07031C04000615070E000000000000020C0C00000012
1000000800062B3C200003000A1409010A07
000009000000000006070606060000100F0500030202190F030000000106071600090042
FF000000A100170000002800007AFFD4FF128B8EFFFF000000000000008200F100000066
0000AE0000620000000000FF00002B00B213005E000000000022000000235897CB0012DC
48C3009500001E44BB9A6D0000000000AA8800231F0000007A1F0000438D0F00040C0E00
0000000000D000001215060C0C0706000C03000000000800000004090704000303000A12
0A0000000A0000000200000A010000000506
0000000000020600000C0B000001000F160B00000000150C000000011000000307280000
26FF5A00002400210000000000000000006D0000240000FF00FFD800FF5B000020FFFFE0
0000FF747B00FF000A00000000060000000000250000431E1700003D8100250000000000
0000350000578141203F00000000FFFC32397D0000527100002F3A00000D26000000092C
0006070000B60000140E0000020006000F0F0000000000000000010A0400000000010C14
090003000C09000005000005000000140E00
040000000001040000060A00000F0200000000000000000000080B06060000260000001D
0060670000000000000029000000BA330056FF000000FF00000000004905D40000FF0000
001000000000FFD400422E1F094B0008200000001B3B00000000251520002A4300489400
000D0000005B00FF55000075FFF8000F4E000010000400310000456500000F1905070000
0C0A2700DC00004B080B00000600010C0C0000000C040000010400000000000000010804
00000A040701071200000E000E0B050F0000
090000020B0100120008090008180B000100020C0A000004010000000005060000010E00
0000D26707220D2F8B003F00210000008D0000FFEA7700FF0000E6003400002D00000000
74FF0059000000000000020011000000002E005C0D00009B3C000003005E1E000064001A
5B3100FFFFFF8E1B0040FF00C9000037002E000015000085530100006002002D00004500
003E0000FF00001C000D09172500080F080000000707000605000000020C080002000000
000013000000090700000913251400000000
0000000D0F09030000000006000000090800000607000000000000040E0200001600002C
000E00FF680000020000000000190000460000000000000600302E470000000000010D00
000000520033003C00070010000000298B00007607000067171F0000002F49CD5C4E0000
0B2F06FF2B000000A2FF000000901400000010180E57000000170E000000000B00003800
17002900FF00090000000C111000000100000000000B0A150300000B1911000005050007
01000B00100600000B0500080B0000000007
00000B040D130F0000000003000000070A000000000003000000060F1100000000000900
00060000FF00002F000E530C0E292C0A690000000018002900000000051807420014000F
0000000000000300002D220045000A620000000D172B5400002C2000800D150000000021
74414D000000CCFFFF00D00D00007435332B020810093A46000A4B0400231A001B1C0016
000000932800330000000100000000090003000000040011000006120B0200000B03000B
1000000016070000130B060100000B0A0D0F
00000D00000300000A0A0B15020019030C0C0B10050007000004000000060400000C0400
0800040027FF00004E00005F860000000009000000000000AE001A171E06000000005B26
25703A07090027000000000000008E00002A9D00000052574550000D02350000129D0078
7F0000009685000000FFC7FFFF160000418C786D03001201231400212D00001F00002000
0D3100FB00001F0E1200180B000B001A0000070000060002000E0F00000001000C00000D
210A00050000000000000A120000210C121C
000E1405000104000900001000000508050000000000040F0302080A000001020A090000
00000000005DFF0000531B1E483B00000000000058000802340000000000050000000000
1D5500000003000000520000250600009B00625F00110B002A220000002B007773001B51
0000B0FFFF000000000033003DFF2A0000001637264E420000080B000034000000160011
000000FF00000000000301000000090004090F0000001100000609000F0F000000000000
0002131900001A0300000F00001016000004
00030A00000000000300000700000004000613100C041500000000050000001708060000
0109060B000041FF00003C2B0027380FA818004900127800000922132B1D0F0012759300
00000500003800003F00003F005614060A20000045000A00030019842D000E0001000000
004200004C9F43317C000000002F008B492800000000272E050019000A16003000000005
1D00206C00241900070A0000000103100700000000041700000C0D000308000701050A00
000000010000080000000000000002000000
020A0700000000000000000500000B0200030B140C04030600000000000000100605030A
0D05000034000034FF000060270023003F35006900275000001D2F000000006969000028
0000001B2948007500000006340D0040000400001200002B006D120000238F16000087FF
FF81371D00226CFFFAFCFFD6308B0000001A1D1900000052B51E00011D00080010001000
1F00FF0000250F000E0D04091B1200000200000008030200000201000006000202010400
00000000030200090906000A000000000605
000301000000000006000009040002000000030400000011060002000000000000000608
050000000E00000000FF00004F31003018001401191500003C034C000000740600006E0E
19341A2E0000537B018921270800000C000000290027161E19000067BA1200007A820076
CF1266004200000000009500000022001A000E093F39000000CB35000000002800122200
004928000E06000002070407090200000002000206000000000000000009100000000000
000000000B00000710070109030900000511
0000030000060000050000030000000404050400020B150E090807060000000000010E10
0B020D000A0000000140FF0000528B02003700100D0000000C1A250020424800000C0000
9000002D23635F0002000B00000900150C0000574113000C0E3168180000FFFF9A000000
120001008D63000000000000251A010401000A2D00006000000098742E24000005720043
993D00001B0000000100040100000005100D0000000705000000010000010B0000000000
000409090D0000100E000200000C0000000F
0000010000010000000307040100000D0F04000000031604030303040506050000040000
00071D00000C051200001BFF250000523900000020000F0002000011002B00104C006C32
0000001926000A0B00000042003109001530000000004197000000000080AA0057413800
00270000006C22FF573A170700010009002C03000000004C640000291588960067009200
0000002B3400240100030904000002090F0E0300000004020E0902030000000C03000000
06120F0200000C1B05000000001210080E13
00010A0000040000040D0A05010100000805000000000000000003050905020000000000
0000132004000024001F0000FFFF000001281D0043001900000005180012230000290113
12895E0400002122002F270000001D4200000000054F4C000087DCFFFF71000092758700
00002E67A461000000000A13000C26060700000012001F0000263F0000F5000000002A00
00000103004A000000000001000508000507090500000000040403040000001806000001
100F03000000110900000009000C0A0A0F12
00000200010E020002101206020400000004000009070000000100000000000400000C19
060000000B000000170000000793FF760000001600340030001F0011000000030030080D
000000001E17120009000F2300190007005762000000000000FFFFB5002A3C001800000F
3457000078019BB700000014001400040A001131000014000B003F85000000210814003C
220B10001400000000000000110A00050000000000000300020A030D00000C1200000000
0D09000000000000000C0704000100000003
0300000400000A16170002060006030000000F1600000B00000000000900000009120200
0000000000041B171402001C000011FF93000D00001800000806080000001900030C0000
180D00103C4200075A4B35152A0503000028000062BCFFFF9900004200009000002B0000
0025470000000088000905001300000010000000000003000C0E001B12262A160004000D
050B0D030000030D000000000D1C0F00000000140000060402000312000F000000000600
0503000B000000050B000004030000000D0A
0A0100000000000103000204000F0A01020000020000000700000000000200060B100000
000008000000000005000008000000086F88DC0513008B3A003D008A2F3A00400000002A
0900000020000039000029000000000000000010B7C76F1D280000000A5E2B420046005A
00006F885B00780000061000060E00050300000E0000060E0F0A001000000200000C0C0A
0B0605000000000B06040500060A0000000000040706000000000000000514000A000000
0000060B030804000000000004000000000E
040803030000000A14010407000C00000000000004000013020000000003000E0A010400
05030800000000000000000A041C1D000053060A0000710000260D2100200754701C0000
3A5F00000006AF000000000000550036FF798F6100300968C0400000008500100000576F
3D4B00D8001139001610240000070D000000001000000D030003001400000000030E1200
06000000020000040000080807090001000005000E18000B0015030000001B001106061D
000009000206080000000900000000000209
00090500000007081E0B0500000E00000000000A090600000105040C0403000000000404
0702030602000000000201000000250000000E770000D927000000000000000004000012
000000005900000089000EFFE5BA0000D0A39E51003A00000315000000AD3C255B004800
79E4828800000D0900000005000008000611060000030300000406070000040C0A030000
000000030B070404000000040200002F0000120200000006001C030009000000050E0E1E
00000F000100000000020F000406050B0B0E
0A1307000000000008000008031A0807090802010B0100000002060D0606000000000000
0600050701040406030005011D0000030000990025A8B14500FFE25F5C3F2F00D0445000
008F5134000010FFFF0000FA00038E0000452C00007A1A0000359D0000001C4300135900
000000000007011B001C011204050000141C080004170600010F0E0200010D0D0C060000
000000000502000B060000000000001D0E08090700001300001400000600003000000200
000710120D090000000300030000040F1002
040C06000000040009000006000E000B0505000003000001010002010308040F05000000
000907000007020C0D0500000000000200009F000000002F004C1200005B00FABDABA900
00FFA1C100006000431E0095002C6F00002C632E00080000241359500000212100003E59
ED341500111E0000000400000609000000000002070400000B1600040000000005050200
05010000000000060608080A060000001915000711010400001000000000012C00080300
00060012090700010E0A0B0B040000000600
00010800060E060907000005000000060000000000040A00000402000000020E0F050000
010500000001030C0602001C00151B0B0000561B9A00008B006B00005700006B00002E5A
00AC263D5E00872115930051170042100000053D4F0011002F0D05673A00004F24006D86
0115592D000000092D0510000000000000000002000000000708000000000000000B0F00
0F11020000000000090600030D000E00090D0000130F0000170C090000121100000C090B
00000000000200000F0D1400000000000000
00090800050A0000000000040000000B07090E0800000001000303040000060012100201
0D010004000003070C0000000008000009000000D64109770000CF37A40A00BC3A0A0059
00CC000027000E03105600006D000042000000323E002700005800005200001038000021
001F0000170018000A0004160000001B09000B0800010400000001000100000000081200
060D0000010F17001B0E00000000060600000C010F04000015000000000E000009130317
03000700070900040E080000000C10000000
0000001C0100141204000D0B0406100A00000E0700000100100C0301130C000000000000
0109060005080B0000020C000000010000000800000000000000832F0300005D6E000012
004B001D0000001E030000002D050500620000007B1E00000079002B0637000054FCC400
09000E1600000000000C00100B090000080600000B18100600001C0F0000041502000500
0F0A00030C0611030808000009140013100B00000000100001030B000000000609030000
17160000030A070000001E0E00000A1E0000
081219040000000503040000000000090602010002050000040000000B0B0000000A0603
00010013050000060802000000000300000002006922000EC90000FF000F00006E001100
0000B800006A001B16002900188C004BE12C00161B17036300179D000037A2000000FF00
003C000500000000000000270B03010000000207000000050402010B0000000200000100
0002000000000B00000700000509000E0505040000000E00000000000206080002080000
0101000C0100000000000010110305050000
000E1400000900000409020205000004090000000D0C000000000000010506000000090D
0000000C000000000100000504030E0D090218004A0000943F91006F64000000AC000400
280084000A40245C0000180048003100001800005C1900850000DC9E0000650200005509
00001D090000000006080011000716130000131C00000002090C00040000000404000000
0200010C0402150100000000000A03040000000100000700000200000008000000000700
00010714000000000000000A141400000607
0000000113140000000A0006080401000205000005000000000505080300050100000508
000003000001000000000205050C0C080B06140000810006003F05009D3F83001E691C00
0000740030000016334400004E003509003ECE0000C10C00AF0000FFD900001AE96A3B00
00100605040308080D110C000000070504020D1000030E00000900000000000A08010009
0000091706041303000000000000050700000000000000080D0F00000100000000000306
050611000100080600000300010E00000300
03000006090000000000070D03001200000006000000030601050A000000000600000905
0000040506100D01010B130000000000000000170092000010182F0000E86E0000930000
0000006A00002200007B0000970000663000956F00FF7A154009000000FF00A137001800
001E0C0F0C0602000000001C0D0000000009070B000B1500000500000000000605030101
0000070B0200050000001A0F040000000000000000000000071607000803030000000000
14180E000005130D00000700000000010000
130100080000110100000200000009050200000000000A0C000000000000001A02000600
00000008000000010C010000030000040100000000000016000E087500EB280000A4963C
C0DC004C7700000000374500272C0026C30016FF0000D064000062000000C15900000000
1A0000000503000705000B060304000A110E000B00000E00000200000000030602030E04
00040F02000002000000090B000300000000000000000003051409050502000000000000
0D0F00060000000E07000007000001030200
0001000000000C03040000000000020E0000000000000001030000000005000A02040000
000006000000000000000001030C04090D0A0000101F0000050700321400DF0000000000
00003B2CCA41001B1200695704CD000015000000A60000FFFF673392BD0000650029050B
1500050004060309070614000007161808000003000009060001030001060D0200001305
03080E000006090E00000000000D0900000505000000000E070202030400000000060100
000000060200000006000010000104000006
00050E00080C001217000000000500000000000F2208000000010000090E0004040D0700
030F120411110C000000080000040104110200041400051C001200004A002C080000008F
0ADD000000B35E29DE0000D23C1E6300B7618800FBC100C400291B0000190000000D001B
001100000B0D02000000000D00021101000015050C150900000014000002090000001600
01060A00000605180C080000000000000000000000001904000000111706000300051002
00000A000000000000080E0B061406000009
00000E16000000000001070000080E080000010601000000000000050500000500020200
0511000C01000000070000000000060C0000050D0E02000600000004004B009770CB396B
5BEA00191F007700309C0000A63800A56D00001E4530A35A001541000017000D00050400
00030000000204050000000000161A020004000E0400080B0E0000180001060000030008
030000000200000000060D0000000B000301000F020005030A00000000050000000E1F08
00000000111200000D130900000004080003
020200090701010000070B0804000004030002010100000B060300000705070600000200
070F0000010A0A040000000000000000000000000000000E030012000403000000010000
0000758D631200000025920015541D0037004600200000000000000000030013050A0D09
090400080100000000040A01000000000000000000000704040300070815030000000012
0500000000030A0C0000000E0D0F00040807000102000600000000000004000800040A00
0009020C0000090400000700000000000000
07030000040A00000000020703000000000D04000000010F0B09030303090D0700000000
030700000014170E00000000000600000000000000000008030013001B04330012000000
00000B0000657606B6001E6F000097070C102100000707000F0000001709050000000007
0802041605000000070B090E00000000000100000000000404030800000E00000C1B0000
000110120200000A00000907000700200D0C05030803000002020201000E1611000A0600
010E0F130000090C00000000000000000004
070700000508000B040000000304000A070D060000000300000201060405000200000105
000000100101030C0A0300000E0B00000008060F07000004000006001A00350028000F0D
000B00161C001C1618000000818D05180000001600001C00100300001100010000000000
0000040A03000004010200050000070A0800000000000202000502000E180000040B0006
000114110300000700140F000000000900061509100D0000000000000000000A000A0B00
0000000A1308000008030007000602000005
000000020000000E060300000000010F070F050000000400000000060A03000200010C09
000000120000000005090A0008000000020B000603000000020113110800000006000000
00161D0700090000000C29000000000000410009090000000506070003000D030D000000
0000000403000603000000000000070E00000000020201000000030F060C030000000016
0400000000000A00000000040504000000040F00000A0000000004070000000A00060A00
00010000020900000F080012050B08000000
0000000100000000000400000000001205030201060000000000000007050000080D0C08
000009020401000000001400000000000302000D0C050000000005070014001B00040018
00000000091E001500000F0009091201002900000B210016001213000016220000010000
001005000508000000000000050507080000110800040003040301170000090000091700
02000000000112000003040000060100000000000000010805041119170E050A00050200
000400000000131400000008090600000000
000004000000000303060700010000010000000004030004000100000406050008070404
0000010000010100000002000002000200000009160E0300000000000000000000000300
0013000004000D000F1900000000000000000F04140704040000000000000B0000000400
0016050401030001000000060D02000500000B00010200000404051F000C0E0600000100
0507000205070000051C1000000001000605000100000000000000000705000800000000
0607000000000F0C00000802040100030700
040100000000000F0800000000000000000000010904020000120C0608050200100F0002
0000000F000000070700000C040F191200000B00010E070A050002101B0014001A000016
000009000000000011000016000B000038000A0B0D00220A231900020700080500000D00
0014000000000009070000020000000D0500000B000000010808040500000B090A0D0000
121000000304000F00000000090500000701001808000000040200000A0A000400080200
0000000000000000000B1800050000050F13
0300000000030A020000100504040B000000000201000001030600000000031002000000
04010000080800000001001900130C000016000302070403000000000000120000050B00
000016110300040016150700000704040000000F00001A0000060608090000001A0F0005
130101000811000000000A000000000000000010000E190000000E0000060200000F0D00
00000000000707190900000801000C0000161A00000C0D00000000000002050808030000
0000000B0F060000161C0400000705080400
010301000002000000000200050D00000400020000000605030004010001070503010004
050701000100000000000014010007000001000C00000001010002070000060000040010
000000000003190001000000010300000000000D00001005020100000000000000000000
02000500000000000500050C00000611040608090006010000051300000F0E0200000006
080507000000001D0B00001105000000010300070E020100000000000000010303050000
000000000000000000000019060000000C0C
060402000002000400030000100F0000020005000000050E000000020009020900000001
09090C00000000000609060A0000001602000A0900000005000006080100000000000000
000000010200000000000004030000000100000A01000015100A00010006010000030500
0000010E0C0B0000070000060000040300030000050700000001000F0001000000090509
09060603000000060200000A00000000090000190D000004030606070C02000502080302
010002000000000F000000090600060B0E0E
0F0E02000000000D0003000007050004000000030205010B000000000000000706030001
09000000010000050908060000000007020203000003150B000008050500000004050000
00090C1009000000000005000000120509070000090300170900000005030C0001191B00
000000070C100700000000000000010200000000040000040200001B0B000000020B1000
01000000030000000000000200000000060B00060000000F0A0E0E0F0F04000107090607
0A0200050D000C1800000000000E08000001
060600000104000900020E00000000050000000301000002020506000000000301030507
05030003040102020503060000070D00011100000002160700000B000903000004030000
000000000B0700020000070500000907090802000A060000000000000000000000070900
00070000000000060B0A0500000A0C0400000013030000020000090E0F0D060605000000
0100000100050700000002000001090000080B0100040000000000030200000000000103
000000000700000C06000300000000000002
0200000002060B0000020E0000000D0003060A0300000000000B0A000000030000000001
050800040000000300000000001110000017000900060400000015000408000605000E00
0402000003110A0C000000060809000200080200070E06000000010900020004060B0309
16160000000000091302000000080C00000000030000080F00000300020000020000000E
0700000000070B06000200000005010C00000B0415140000000000000001030000000000
00000000020C030212100700000000000000
000000010002081200000C0201030306000B0D0500000000000205000000090000000000
00060400000003000000000100040C000009000A04020000000102000901030800000F00
0002000006070211030000060D06000600010400020B0100050406120605041A16060014
170200080500000406000000000001000000070000061110000000000000000000021F04
080203000100060C000100000004000C00000008170A000702000106090F170000000000
03010500001014000D1C0600000006080400
000000000000001E0200000008050010000001100B02000000030B000002130007050000
000304000405070B01000000000000010000091B1408040A0B0000040500001401000511
0F03000000000A040B0000000E09000B000C1D060001000000000000000000000000020A
000007000106000000020F020000060D0404120000020000000E0100060C050D03001500
0000000000000013060F0900000000001300000A0000000F050000000000000000000000
0605080000061700000E0003000000000000
020100000809001A050000010000000000030000050000090000000000000C0200000005
0E0B030000000E0805010707070000050F09000000000001000000040600000100070200
00000B171102000000000200000518110C0000030004170000000003040A0400040C0000
000F0000080C0B00000006000B0000031304030400011000031100000D0E0B000000000C
0C0301070301000000000002171500000900000000000D080000020E1A00001C08070A00
0013190A0007030400000004060900000604
0000000E2010000000000000030002080301000002000011070000060D02000301000103
00060E0000030A0100000000000200020B02000003000000000004000000000000000000
000000060300000A0102010000000005070000050500020001080000000001040B160300
000C000D110E040000011601180600000000000800000500000F11000600000000000100
0000000000000003000200000A0C00080F00000708000204000C00000800000000030300
06090B00000D0000060000010D11100C0F07
0108040000020700050D0B03000000070400000002010000000000001012000609000000
00000B0000040107020003000000030C060700000007030002050A000002000301000000
0700000300000000000000000000000D070000050500000E0D0D050000010C01040E0800
000811110F09000001061E00100C00000000070800000D00000E14080000000001051100
000005040408030402010201000200030900000600000200071A00000300060002010006
12050601060B00000C03000003120B050003
0710060000000700010D0E0B020000000000000300050004000000000D0A000507050000
00000000000000000003000000000C0D0909040001100E06000001000003000200000100
13000006000011000000020300090C040900000800000015000000070A0C090000000000
000213000000000306090B000201000309090E00000005000000000C000012110B010700
0001010C0B0C081008000400000000000002040000000700001D04000000010006000006
0B0000000206000010090206000000000000
00000003140800000000080E0F06030000000204000400190F080C070000010103000100
0001000000000000040000010000030603010200060E0E07000000030005010206030003
1006000000001B0E0C02010301000900000000000000000B000000000005000F01010405
000000000000070C0600000304060305030000000002000000030008000012110C030509
0000000000090F1105030700000000000002060F05080409000E0C040000080007000001
050000000000000009000018050500000000
0200000106040002000000050E040015060000000000030A00020F0E00000C000701060D
070301000007010003000008000001060402000304000000000000000000020100010000
0601000000050B0500000000000003000305000000000308010B030000000C030000030D
0D000503070304060800040705090909070000020E07000003140E04000000000000010B
00000000000002080707040701010F00000001101006001A000601000000060900000000
07120A000000020404000A0A0C0E06070605
12210E000000031303000000050000120200010000010500000000000201070000010905
07020700000902000602000B000000040400000803000000000301000000000003010001
00090600021100000000000000030A000903000603000606090F0D080000030000000010
0F0309070200000006020A0000021100030D07000A000000060B14000000000000000007
0000000000000300000B02050A0811000000030000000011000A020000000D1700000B00
00140D000007040303000B000B1403000300
0409090000000004030000000203070000000000000000020C0400091D12000000090500
00000000000600000E101006000000100B000000000006070B0000000005070500000000
000D14000217000A040204100A08080F0F000000010000000000000A080000020A010000
010000000000000000000100000B0E00000109000405070200000A00070200000407000B
0000070900000A010B0400000D000000000D1C0200001200000E03000900112500001400
000B020D03140F010A000C00162100000004
070001020B0C08000400050B000500001B0E000F14070B00060900000000040000000200
101C060000050500010300010407000000000B1107000000000000030700000E00000504
00020F0C000003010000000000000000000001060F0C0800000007070007150905000610
000000000108020518110F0F010003080106121000001015000000000504000000000000
03030000000C000000000D090308190A00000200040500000D100000080500001B130009
1700010C000000000000000000020E110600
03000000080200000C000605001313000C040000030411000701000002000000000C0900
00000003000300000307001A161710080000000600000000121717000C02000207000500
0504020A09000000000000000208000B08070400030000000000000000040A0309000108
020001000000000400010200000002081300000000000C080000010000000B0F01000000
0011140F0D050D000808060200000007000400000000000000000000060200000E05000A
040002000500000E0D00080F020000050708
000000010C0000000600000000041100090C00000000110A0C0000000100000000000400
0000000F010200030507000600060D09070000000000000000050600110F00000D060700
0C0C00040B040000030700000A0A000300020000050502000500000000000F000C070003
0000000C00000C0E00000700000000000706000000000400000505050000111102000000
0002111700000F0000000002070000051508000000000000000200000000140600000406
000001000D00000A0000020A0000030A1003
00000000020000000000000000000800070F090000000903020000010A00000E00000001
0B08000300000000030C0C000000000000030A0000020502000000000A04000004000500
0B15040000070C000B07000001030001000000000509100003000000000110000C0A0000
0000000700000200000000030C0700000007091002000000070F000B0000000400000900
000003020000060004000000040D02000E08000000000706020B0B030003051000001100
000000091300000000000000000002090500
02040000060000050001060E0A000300000707000100000000000B060203011904000007
040000000005010000080907060B040000000A0005090E0E070B02000401000000000900
000B070000001002030104000000000C0402000004061000020100000000070009120000
06040000010000000000000C021310080000010A040C0C060C05000B0400000004010008
060500000003050A10060000050100000A000004030006170A00000B1A0D000200000D00
0210050B00000B000B170B0A0B0600000000
0B080800050001070002000A0C00000C0000020003070800000408010000000002000000
00001600070A01000000010006080C040100000104040403010906000506050C00000C01
0300030000000800000000000000000508000000020817000200000000000200000B0000
040A00050D060000050C00180100050A00000001040D0000000C09000800000006040007
0A08000006000000040503030B00000100000001000000000E0A00000C0C000000020400
0714070000021000081900070D1203000002
0305000406060005000600000300070300000100000C0700010404010000000000000005
000024000101030000000000000000050600000603000000000000000905000902000F08
05020000000000000100000000020000000000010A070F00000001000000000000010000
050D001210060000060D001A0000000003040B0200040000001522000400020300000000
000000000903000000010D100E00000F0000010001000000091305000000150400060000
050300000000090000000001020F0A080000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["RotateLeft[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              ",  ",
              StyleBox["RotateRight[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "rotate elements cyclically by ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " positions at level ",
              StyleBox["i", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PadLeft[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              ",  ",
              StyleBox["PadRight[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad with zeros to create an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "1"], "\[Cross]", 
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "2"], "\[Cross]", "\[Ellipsis]"}], 
                    TraditionalForm]], "InlineFormula"],
              " array "
            }]]},
          {Cell[TextData[{
              StyleBox["Take[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Drop[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "take or drop ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " elements at level ",
              StyleBox["i", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.5"],

Cell["Other functions for manipulating multidimensional data. ", "Caption",
  CellTags->"S3.8.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.8.6 Cellular Automata", "Subsection",
  CellTags->{"S3.8.6", "6.1"}],

Cell["\<\
Cellular automata provide a convenient way to represent many kinds \
of systems in which the values of cells in an array are updated in discrete \
steps according to a local rule. \
\>", "Text",
  CellTags->{"S3.8.6", "6.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CellularAutomaton[", "MR"],
              StyleBox["rnum", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["init", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evolve rule ",
              StyleBox["rnum", "TI"],
              " from ",
              StyleBox["init", "TI"],
              " for ",
              StyleBox["t", "TI"],
              " steps "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.6"],

Cell["Generating a cellular automaton evolution. ", "Caption",
  CellTags->"S3.8.6"],

Cell["\<\
This starts with the list given, then evolves rule 30 for four \
steps. \
\>", "MathCaption",
  CellTags->{"S3.8.6", "6.3"}],

Cell[CellGroupData[{

Cell["CellularAutomaton[30, {0, 0, 0, 1, 0, 0, 0}, 4]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.8.6"],

Cell[BoxData[
    \({{0, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 0, 1, 
        0}, {1, 1, 0, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0, 0}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell["\<\
This shows 100 steps of rule 30 evolution from random initial \
conditions. \
\>", "MathCaption",
  CellTags->{"S3.8.6", "6.4"}],

Cell[CellGroupData[{

Cell["\<\
ArrayPlot[CellularAutomaton[30, Table[Random[Integer], {250}], \
100]]\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .404 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00380952 0.00961905 0.00380952 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .404 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .404 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .404 L
s
0 .404 m
1 .404 L
s
1 0 m
1 .404 L
s
0 0 m
1 0 L
1 .404 L
0 .404 L
closepath
clip
newpath
% Start of gray image
p
.02381 .00962 translate
.95238 .38476 scale
250 string
250 101 8 [250 0 0 101 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage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P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "explicit list of values ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "values ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " superimposed on a ",
              StyleBox["b", "TI"],
              " background "
            }]]},
          {Cell[TextData[{
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["blist", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "values ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " superimposed on a background of repetitions of ",
              StyleBox["blist", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{{{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "11"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "12"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "}}, \[Ellipsis] }, ",
              StyleBox["blist", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "values ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], 
                      StyleBox["ij",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " at offsets ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.6"],

Cell["\<\
Ways of specifying initial conditions for one\[Hyphen]dimensional \
cellular automata. \
\>", "Caption",
  CellTags->"S3.8.6"],

Cell[TextData[{
  "If you give an explicit list of initial values, ",
  StyleBox["CellularAutomaton", "MR"],
  " will take the elements in this list to correspond to all the cells in the \
system, arranged cyclically. "
}], "Text",
  CellTags->{"S3.8.6", "6.5"}],

Cell["\<\
The right neighbor of the cell at the end is the cell at the \
beginning. \
\>", "MathCaption",
  CellTags->{"S3.8.6", "6.6"}],

Cell[CellGroupData[{

Cell["CellularAutomaton[30, {1, 0, 0, 0, 0}, 1]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.8.6"],

Cell[BoxData[
    \({{1, 0, 0, 0, 0}, {1, 1, 0, 0, 1}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[TextData[{
  "It is often convenient to set up initial conditions in which there is a \
small \[OpenCurlyDoubleQuote]seed\[CloseCurlyDoubleQuote] region, \
superimposed on a constant \[OpenCurlyDoubleQuote]background\
\[CloseCurlyDoubleQuote]. By default, ",
  StyleBox["CellularAutomaton", "MR"],
  " automatically fills in enough background to cover the size of the pattern \
that can be produced in the number of steps of evolution you specify. "
}], "Text",
  CellTags->{"S3.8.6", "6.7"}],

Cell["\<\
This shows rule 30 evolving from an initial condition containing a \
single black cell. \
\>", "MathCaption",
  CellTags->{"S3.8.6", "6.8"}],

Cell[CellGroupData[{

Cell["ArrayPlot[CellularAutomaton[30, {{1}, 0}, 100]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .50249 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00473821 0.011964 0.00473821 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .50249 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .50249 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .50249 L
s
0 .50249 m
1 .50249 L
s
1 0 m
1 .50249 L
s
0 0 m
1 0 L
1 .50249 L
0 .50249 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01196 translate
.95238 .47856 scale
201 string
201 101 8 [201 0 0 101 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFFFF00FFFFFF00FF
000000FF00000000FF0000FFFF00FFFF00FFFFFF00FF00FFFFFFFFFF000000FF00FFFFFF
00FF00FFFFFF00FF00FF000000FFFF00FF0000000000FF00FF00FFFFFF00FF0000000000
00FF00FF00FF0000FFFFFF00FF00FFFFFFFF0000FF00FF00FFFFFF00FF00FFFFFF0000FF
FF0000FFFFFFFF00000000FF00000000FFFFFF00FF0000FF00000000FF0000FF0000FF00
000000FFFF00FF00FF00FF000000FFFF00FFFFFF00
FF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FF000000FF0000
FFFF0000FFFF00FFFFFF0000FF0000FF000000FF00FF000000000000FFFF00FF000000FF
00FF000000FF00FF0000FFFF000000FFFFFF00FFFF00FF00FF000000FF0000FFFF00FFFF
00FF0000FFFFFF000000FF0000FFFFFFFFFFFF00FF00FF000000FF00FF000000FF00FFFF
FFFF00000000FF00FFFF00FF00FFFF00000000FFFFFF00FF00FFFF00FF00FFFFFF00FF00
FFFF0000FF00FF00FF0000FFFF0000FF00000000FF
FFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FFFF00FF00FF
FFFFFF0000FF000000FF00FFFFFF0000FFFF00FF0000FFFF00FFFF0000FF0000FFFF00FF
0000FFFF0000FFFFFF000000FFFF000000FF0000FF0000FFFFFF00FFFFFF0000FF0000FF
00FF00FFFFFFFFFF00FFFFFF000000000000FF00FF0000FFFF00FF0000FFFF00FF000000
00FF00FFFF00FF0000FF00FF0000FF00FFFF000000FF00FF0000FF00FF000000FF0000FF
FFFFFF00FF00FF00FF00FFFFFFFF0000FFFF00FFFF
FFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF0000FFFF
FFFFFFFF0000FFFF0000FFFFFFFFFF000000FFFFFF0000FF0000FF00FFFFFF0000FF00FF
00FFFFFFFF00000000FFFF000000FFFF00FF00FFFFFF000000FF000000FF00FFFFFF00FF
00FF0000000000FF00000000FFFF00FFFF0000FFFFFF000000FFFFFF0000FF00FF00FFFF
00FF000000FFFFFF0000FFFFFF00FF000000FFFF0000FFFFFF0000FFFFFF00FFFFFF0000
0000FF00FF00FF0000FFFFFFFFFFFF000000FFFFFF
FFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFF000000
000000FF00FFFFFFFF000000000000FFFF000000FF00FFFFFF0000FFFFFFFFFF00FF00FF
00000000FF00FFFF000000FFFF0000FF00FF00000000FFFF0000FFFF00FF000000FF0000
FFFFFF00FFFF00FF00FFFF0000FF0000FF00FFFFFFFFFF00FFFFFFFFFF00FF00FF000000
FFFFFF00FFFFFFFFFF000000FF0000FFFF0000FF00FFFFFFFFFF000000FF000000FF00FF
FF00FF00FF00FF00FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FFFF00
FFFF00FF0000000000FFFF00FFFF000000FFFF0000FFFFFFFFFF0000000000FF00FF00FF
00FFFF0000FFFFFFFF00FFFFFFFF00FF0000FFFF00FFFFFFFF000000FFFFFF00FFFFFF00
0000FF0000FF00FF0000FF00FFFFFF00FF0000000000FF0000000000FF00FF0000FFFF00
0000FF000000000000FFFF00FF00FFFFFFFF00FF000000000000FFFF0000FFFF00FF0000
FF00FF00FF00FF000000000000000000FFFFFFFFFF
FFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FF00
0000FFFFFF00FFFF0000FF000000FFFF0000FF00FFFFFFFFFFFFFF00FFFF00FF00FF0000
FFFFFFFF00000000FF0000000000FFFFFF0000FF0000000000FFFF00000000FFFFFFFFFF
00FFFFFF0000FFFFFF00FF000000FF00FF00FFFF00FFFFFF00FFFF0000FFFFFF000000FF
FF0000FFFF00FFFF0000FF00FF0000000000FFFFFF00FFFF00FFFFFFFF000000FFFFFF00
FF00FF0000FFFFFF00FFFF00FFFF00FFFFFFFFFFFF
FFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF
FF000000FF0000FF00FFFFFF00FFFFFFFF00FF00000000000000FF0000FF0000FFFFFF00
00000000FFFF00FFFFFF00FFFF000000FF00FFFFFF00FFFF0000FF00FFFF000000000000
FFFFFFFFFF000000FF0000FFFF00FF00FF0000FF000000FF0000FF00FFFFFFFFFF00FFFF
FFFF000000FFFFFFFF0000FFFFFF00FFFF000000FF0000FF0000000000FFFF000000FF00
00FFFFFF000000FF0000FF000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFF
FFFF00FFFFFF00FF000000FF00000000FF0000FFFF00FFFF00FFFFFF00FF00FFFFFFFFFF
00FFFF0000FF000000FF000000FFFF00FF00000000FFFFFFFF0000FFFFFFFF00FFFF00FF
FFFFFFFFFFFF00FFFFFF0000FF00FF00FF00FFFFFF00FFFFFF00FF000000000000FFFFFF
FFFFFF00FFFFFFFFFFFF00000000FFFFFFFF00FFFFFF00FF00FFFF00FFFFFFFF00FFFFFF
00000000FFFF00FF00FFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF000000
00FF000000FF0000FFFF0000FFFF00FFFFFF0000FF0000FF000000FF00FF000000000000
FFFFFFFF0000FFFF0000FFFF0000FF0000FFFF00FFFFFFFFFFFF00000000FF0000FF0000
000000000000FFFFFFFFFF00FF00FF00FF000000FF000000FF0000FFFF00FFFF00000000
0000FF000000000000FF00FFFF00000000FF000000FF00FF0000FF00000000FF000000FF
00FFFF0000FF00FF00000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF
0000FFFF00FF00FFFFFFFF0000FF000000FF00FFFFFF0000FFFF00FF0000FFFF00FFFF00
000000FF00FFFFFFFF0000FF00FFFFFF0000FF000000000000FF00FFFF00FF00FFFFFF00
FFFF00FFFF0000000000FF00FF0000FFFFFF00FFFFFF00FFFFFF0000FF000000FFFF00FF
FF0000FFFF00FFFF00FF0000FF00FFFF0000FFFF0000FFFFFF00FF00FFFF0000FFFF0000
FFFFFFFF00FF0000FFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFF
FF0000FF0000FFFFFFFFFFFF0000FFFF0000FFFFFFFFFF000000FFFFFF0000FF0000FF00
FFFF0000FFFFFFFFFFFF0000FFFFFFFFFF0000FFFF00FFFF00FF0000FF00FF000000FF00
0000FFFFFFFF00FFFF0000FFFFFF000000FF00000000FFFFFFFFFF0000FFFF000000FFFF
FFFF0000FF000000FFFFFF00FF0000FF00FFFFFFFF000000FF00FF0000FF00FFFFFFFF00
00000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000
FF00FFFFFF000000000000FF00FFFFFFFF000000000000FFFF000000FF00FFFFFF0000FF
FFFFFF000000000000FF00FFFFFFFFFFFFFF0000FF000000FFFFFF00FF0000FFFF0000FF
FF0000000000FFFFFFFF00000000FFFF00FF00FFFF0000000000FF00FFFFFFFF00FFFFFF
FFFFFF0000FFFF00000000FFFFFF00FF0000000000FFFF0000FFFFFF00FF00000000FF00
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00
FF00000000FFFF00FFFF00FF0000000000FFFF00FFFF000000FFFF0000FFFFFFFFFF0000
000000FFFF00FFFF0000FFFFFFFFFFFFFFFFFF0000FFFF00000000FFFFFF0000FF00FFFF
FFFF00FFFF00000000FF00FFFF0000FF0000FFFFFFFF00FFFF00FF0000000000FFFFFFFF
FFFFFFFF0000FF00FFFF000000FF00FF00FFFF00FFFFFFFF000000FF00FF00FFFF00FF00
00FF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00
FF00FFFF0000FF000000FFFFFF00FFFF0000FF000000FFFF0000FF00FFFFFFFFFFFFFF00
FFFF0000FF0000FF00FFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFFFFFFFF00FF000000
00FF0000FF00FFFF00FF0000FF00FFFFFF00000000FF0000FF00FF00FFFF00FFFFFFFFFF
FFFFFFFFFF00FF000000FFFF00FF00FF0000FF0000000000FFFF00FF00FF0000FF00FF00
FFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF00
00FFFFFFFF0000FFFF000000FF0000FF00FFFFFF00FFFFFFFF00FF00000000000000FF00
00FF00FFFFFF00FF000000000000000000000000FFFF0000FF0000000000FF0000FFFF00
FFFFFF00FF000000FFFFFF00FF00000000FFFF00FFFFFF00FF00FF0000FF000000000000
00000000FF0000FFFF0000FF00FF00FF00FFFFFF00FFFF0000FF0000FFFFFF00FF00FF00
0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF
00000000FF00FFFFFFFF00FFFFFF00FF000000FF00000000FF0000FFFF00FFFF00FFFFFF
00FF00000000FFFFFF00FFFF00FFFF00FFFF00FFFFFFFF00FF00FFFF00FFFFFF0000FF00
0000FF0000FFFF000000FF00FF00FFFF0000FF000000FF0000FFFFFF00FF00FFFF00FFFF
00FFFF00FF00FFFFFFFF00FF00FF00FF000000FF0000FF00FFFFFF000000FF0000FFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF
00FFFF00FF00000000FF000000FF0000FFFF0000FFFF00FFFFFF0000FF0000FF000000FF
00FF00FFFF000000FF0000FF0000FF0000FF00000000FF00FF0000FF000000FF00FFFFFF
00FFFFFF000000FFFF00FF00FF0000FF00FFFFFF00FFFFFF000000FF00FF0000FF0000FF
0000FF00FF00000000FF00FF0000FFFFFF00FFFFFF0000FFFFFFFFFF00FFFFFF000000FF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF
0000FF00FF00FFFF0000FFFF00FF00FFFFFFFF0000FF000000FF00FFFFFF0000FFFF00FF
0000FFFFFFFF00FFFFFF00FF00FFFFFF00FF00FFFF0000FFFFFF0000FFFF00FF000000FF
00000000FFFF0000FF0000FFFFFF00FF000000FF00000000FFFF0000FFFFFF00FF00FFFF
FF00FF00FF00FFFF0000FFFFFF00000000FFFFFFFFFF0000000000FF00000000FFFF0000
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFF
FF00FF0000FFFFFFFF0000FF0000FFFFFFFFFFFF0000FFFF0000FFFFFFFFFF000000FFFF
FF00000000FF000000FF00FF000000FF00FF0000FF00FFFFFFFFFF0000FF0000FFFF00FF
00FFFF0000FF00FFFFFF000000FF0000FFFF0000FFFF00FFFFFFFF000000FF00FF000000
FF00FF0000FFFFFFFF00000000FFFF00FFFFFFFFFFFFFF00FFFF0000FFFF00FFFFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF000000
00FFFFFF00000000FF00FFFFFF000000000000FF00FFFFFFFF000000000000FFFF000000
FF00FFFF0000FFFF00FF0000FFFF0000FFFFFF00FF0000000000FF00FFFFFF0000FF0000
FFFFFFFF00FF00000000FFFF00FF00FFFFFFFF0000FF0000000000FFFF00FF0000FFFF00
00FFFFFF00000000FF00FFFF0000FF0000000000000000FFFFFFFF000000FFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF
000000FF00FFFF00FF00000000FFFF00FFFF00FF0000000000FFFF00FFFF000000FFFF00
00FFFFFFFF0000FF00FF00FFFFFFFF00000000FFFFFF00FFFF00FF000000FF00FFFFFF00
000000FF00FF00FFFF0000FF00FF00000000FF00FFFFFF00FFFF0000FF00FF00FFFFFFFF
000000FF00FFFF00FF0000FF00FFFFFF00FFFF00FFFF0000000000FFFF00000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000
FFFF00FF0000FF00FF00FFFF0000FF000000FFFFFF00FFFF0000FF000000FFFF0000FF00
FFFFFFFFFFFF00FF00FF00000000FF00FFFF000000FF0000FF0000FFFF00FF000000FF00
FFFF00FF0000FFFFFFFF00FF00FF00FFFF00FF00000000FFFFFFFF00FF00FF0000000000
FFFF00FF000000FFFFFF00FF000000FF000000FFFFFFFF00FFFF000000FFFF00FFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF00
0000FFFFFF00FF0000FFFFFFFF0000FFFF000000FF0000FF00FFFFFF00FFFFFFFF00FF00
0000000000FF00FF00FF00FFFF00FF000000FFFF00FF00FFFFFF0000FF0000FFFF00FF00
0000FFFFFF00000000FF00FF00FF0000FF00FF00FFFF00000000FF0000FFFFFF00FFFF00
00FF0000FFFF000000FF0000FFFF0000FFFF00000000FF000000FFFF0000FF000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FF
FF00000000FFFFFF00000000FF00FFFFFFFF00FFFFFF00FF000000FF00000000FF0000FF
FF00FFFF00FF00FF00FF0000FF0000FFFF0000FF00FF000000FF00FFFFFF0000FF0000FF
FF000000FF00FFFF00FF0000FFFFFF00FF00FF000000FFFF00FFFFFF000000FF0000FF00
FFFFFF000000FFFF00FF00FFFFFFFF0000FF00FFFF0000FFFF0000FF00FFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000
FF00FFFF000000FF00FFFF00FF00000000FF000000FF0000FFFF0000FFFF00FFFFFF0000
FF0000FF00FF0000FFFFFF00FF00FFFFFFFF00FF0000FFFF00FF000000FF00FFFFFF0000
00FFFF00FF000000FFFFFF000000FF00FF0000FFFF000000FFFFFFFFFF00FFFFFF00FF00
000000FFFF0000FF0000FFFFFFFFFFFF00FF0000FF00FFFFFFFF00FF00000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00
FF000000FFFF00FF0000FF00FF00FFFF0000FFFF00FF00FFFFFFFF0000FF000000FF00FF
FFFF0000FFFFFF000000FF00FF0000000000FFFFFF0000FF0000FFFF00FF00000000FFFF
0000FF0000FFFF00000000FFFF0000FFFFFF000000FFFF0000000000FF000000FF00FF00
FFFF0000FF00FFFFFF00000000000000FFFFFF00FF00000000FF0000FFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF00
00FFFF000000FFFFFF00FF0000FFFFFFFF0000FF0000FFFFFFFFFFFF0000FFFF0000FFFF
FFFFFF00000000FFFF0000FFFFFF00FFFF000000FF00FFFFFF0000FF00FF00FFFF0000FF
00FFFFFF0000FF00FFFF0000FF00FFFFFFFFFF00FFFFFFFF00FFFF0000FFFF00FF0000FF
FFFFFF00FF000000FF00FFFF00FFFF000000FF0000FFFF00FFFFFF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF
000000FFFF00000000FFFFFF00000000FF00FFFFFF000000000000FF00FFFFFFFF000000
000000FFFF00FFFFFFFF000000FF000000FFFF0000FFFFFFFFFF00FF0000FFFFFFFF0000
FFFFFFFFFF0000FFFFFFFF00FF0000000000FF0000000000FFFFFFFF000000FFFFFF0000
0000FF0000FFFF00FF000000FFFFFFFF00FFFFFF000000FFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000
FFFF0000FF00FFFF000000FF00FFFF00FF00000000FFFF00FFFF00FF0000000000FFFF00
FFFF000000FFFFFFFFFFFF00FFFFFF00FFFFFFFF000000000000FFFFFF00000000FF00FF
FFFFFFFFFFFF00000000FF00FF00FFFF00FFFFFF00FFFF0000000000FFFF00000000FFFF
00FFFFFF0000FF0000FFFF00000000FF00000000FFFF000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FF
FFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FF000000FFFFFF00FFFF0000FF00
0000FFFF000000000000FF000000FF0000000000FFFF00FFFF000000FF00FFFF00FF0000
0000000000FF00FFFF00FF00FF0000FF00000000FFFFFFFF00FFFF0000FF00FFFF0000FF
000000FF00FFFFFF0000FF00FFFF0000FFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF0000
0000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FFFF000000FF0000FF00FFFFFF
00FFFFFFFF00FFFF00FFFFFF00FFFFFF00FFFF0000FF000000FFFF00FF0000FF00FF00FF
FF00FFFF00FF0000FF0000FFFFFF00FF00FFFF0000000000FFFFFFFF0000FFFFFFFF0000
FFFF0000FFFFFFFFFF0000FFFFFFFF0000FF00000000FF000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFFFF00FFFFFF00FF000000FF
00000000FF0000FF000000FF00000000FFFFFFFF0000FFFF000000FFFFFF00FF00FF0000
FF0000FF00FF00FFFFFF000000FF00FF0000FF00FFFF00FFFFFFFFFFFF00000000FF00FF
FFFFFF0000000000FF00FFFFFFFFFFFF0000FFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FF000000FF0000FFFF0000
FFFF00FFFFFF0000FFFF0000FFFF00FFFFFFFFFFFF000000FFFF000000FF00FF00FF00FF
FFFF00FF00FF00000000FFFF0000FFFFFF00FF0000FF000000000000FF00FFFF0000FFFF
FFFFFFFF00FFFF0000FFFFFFFFFFFFFFFF0000FF00000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FFFF00FF00FFFFFFFF00
00FF000000FF00FFFFFFFF0000FF00000000000000FFFF000000FFFF00FF00FF00FF0000
00FF00FF0000FFFF00FFFFFFFF00000000FFFFFF0000FFFF00FFFF0000FFFFFFFF000000
000000FF0000FF00FFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
00FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF0000FFFFFFFFFFFF
0000FFFF0000FFFFFFFFFFFF00FF00FFFF00FFFF000000FFFF0000FF00FF00FF0000FFFF
0000FFFFFF0000FF0000000000FFFF00FFFFFFFFFF0000FF0000FF00FFFFFFFFFFFF00FF
FF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFF000000000000FF
00FFFFFFFF000000000000FF00FF000000FFFFFFFF00FFFFFFFF00FF00FF00FF00FFFFFF
FF000000FF00FFFFFF00FFFF0000FF0000000000FF00FFFFFF00FF000000000000FF0000
FF000000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FFFF00FFFF00FF
0000000000FFFF00FFFF00FF0000FFFF00000000FF00000000FF00FF00FF00FF00000000
00FFFF00FF000000FF0000FF00FFFFFF00FFFF00FF00000000FFFFFF00FFFF00FFFFFF00
00FFFF00FF000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FF000000FFFF
FF00FFFF0000FF000000FFFFFF0000FF00FFFF00FF00FFFF00FF00FF0000FFFFFF00FFFF
000000FFFFFF00FFFFFF00FF000000FF0000FF00FF00FFFF000000FF000000FFFFFFFFFF
000000FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FFFF000000
FF0000FF00FFFFFF00FFFFFFFFFF00FF0000FF00FF0000FF0000FFFFFF000000FF000000
FFFF000000FF00000000FFFFFF00FFFFFF00FF00FF000000FFFF0000FFFF000000000000
FFFF000000FF0000FF0000FF0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFFFF00FF
FFFF00FF000000FF000000000000FFFFFF00FF00FF00FFFFFF00000000FFFF0000FFFF00
0000FFFF00FF00FFFF000000FF000000FF0000FFFFFF00FFFFFFFF000000FFFF00FFFF00
0000FFFF00FF00FFFFFF00FF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FF0000
00FF0000FFFF0000FFFF00FFFF000000FF00FF00FF00000000FFFF00FFFFFFFF000000FF
FF0000FF0000FFFFFFFF00FFFFFF00FFFFFF000000FF0000000000FFFF0000FF000000FF
FF0000FF00FF000000FF00FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FFFF
00FF00FFFFFFFF0000FF000000FFFF00FF00FF00FF00FFFF0000FF0000000000FFFF0000
FF00FFFFFF00000000FF00000000FFFFFFFFFF00FFFFFF00FFFF0000FF00FFFFFF00FFFF
FFFF00FF0000FFFF00FF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF
0000FFFFFFFFFFFF0000FFFF0000FF00FF00FF0000FFFFFFFF00FF00FFFF00FFFFFFFF00
FF000000FF00FFFF00FF00FFFF0000000000FF00000000FFFFFFFF00FF000000FF000000
0000FFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFF
FF000000000000FF00FFFFFFFF00FF0000FFFFFF00000000FF00FF0000FF00000000FF00
00FFFF00FF0000FF0000FFFFFFFF00FFFF00FF00FFFF00000000FF0000FFFF00FF00FFFF
00FFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF000000
00FFFF00FFFF00FF0000000000FFFFFF000000FF00FFFF0000FFFFFF0000FFFF00FFFFFF
0000FF00FF00FFFFFF00000000FF0000FF00FF000000FFFF00FFFFFF0000FF00FF0000FF
0000000000FF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF
0000FF000000FFFFFF00FFFF00000000FFFF00FF0000FF00FFFFFFFFFF000000FFFFFFFF
FF00FF00FF00000000FFFF00FFFFFF00FF0000FFFF000000FFFFFFFFFF0000FFFFFF00FF
00FFFF00FFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFF
FF0000FFFF000000FF0000FF00FFFF000000FFFFFF00FF000000000000FFFF0000000000
FF00FF00FF00FFFF0000FF000000FF00FF00FFFFFFFF00FFFFFFFFFFFFFF000000FF00FF
0000FF000000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000
FF00FFFFFFFF00FFFFFF00FF000000FFFF00000000FFFFFF00FFFF00FFFFFFFF00FFFF00
FF00FF0000FFFFFFFF0000FFFF00FF00FF00000000FF0000000000000000FFFF00FF00FF
00FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00
FF00000000FF000000FF0000FFFF0000FF00FFFF000000FF0000FF00000000FF0000FF00
FF00FF00FFFFFFFFFFFF0000FF00FF0000FFFF00FFFFFF00FFFF00FFFF0000FF00FF00FF
000000FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00
FF00FFFF0000FFFF00FF00FFFFFFFF0000FFFFFFFF00FFFFFF0000FFFF00FFFFFF00FF00
FF0000FFFFFFFFFFFFFFFF0000FFFFFF0000FF000000FF000000FFFFFFFF00FF00FF0000
FFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF00
00FFFFFFFF0000FF0000FFFFFFFFFFFF0000000000FFFFFFFFFF0000FF000000FF0000FF
FFFF0000000000000000FF00FFFFFFFFFF0000FFFF0000FFFF00000000FF00FF00FF00FF
FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF
00000000FF00FFFFFF000000000000FF00FFFF00FFFFFFFFFFFFFF0000FFFF00FF00FFFF
FFFFFF00FFFF00FFFF00FF0000000000FF00FFFFFFFF0000FF00FFFF00FF00FF0000FFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF
00FFFF00FF00000000FFFF00FFFF00FF000000FFFFFFFFFFFFFFFFFF0000FF00FF000000
0000FF0000FF000000FFFFFF00FFFF0000FFFFFFFFFFFF00FF0000FF0000FFFFFF000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF
0000FF00FF00FFFF0000FF000000FFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FF00FFFF
00FFFFFF0000FFFF00000000FFFFFFFF000000000000FF00FF00FFFFFF00000000FFFF00
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFF
FF00FF0000FFFFFFFF0000FFFF000000FF0000000000000000000000FF00FF00FF000000
FFFFFFFFFF0000FF00FFFF0000000000FFFF00FFFF00FF00FF000000FF00FFFF0000FF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF000000
00FFFFFF00000000FF00FFFFFFFF00FFFFFF00FFFF00FFFF00FFFF00FF0000FFFFFF00FF
FFFFFFFFFFFF0000FFFFFFFF00FFFF0000FF0000FF00FF0000FFFF00FF0000FF00FFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF
000000FF00FFFF00FF00000000FF000000FF0000FF0000FF000000FFFFFF00000000FFFF
FFFFFFFFFFFFFF00000000FF0000FF00FFFFFF0000FFFFFF000000FFFFFF00FF00000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000
FFFF00FF0000FF00FF00FFFF0000FFFF00FF00FFFFFF0000FFFF000000FF00FFFF000000
00000000000000FFFF00FFFFFF0000FFFFFFFFFF00000000FFFF000000FF0000FFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF00
0000FFFFFF00FF0000FFFFFFFF0000FF0000FFFFFFFFFF000000FFFF00FF0000FF00FFFF
00FFFF00FFFF000000FFFFFFFFFF000000000000FFFF00FFFFFFFF00FFFFFF000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FF
FF00000000FFFFFF00000000FF00FFFFFF000000000000FFFF000000FFFFFF00FF0000FF
0000FF000000FFFF000000000000FFFF00FFFF0000FF0000000000FFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000
FF00FFFF000000FF00FFFF00FF00000000FFFF00FFFF000000FFFF000000FF00FF00FFFF
FF0000FFFF000000FFFF00FFFF0000FF0000FF00FFFFFF00FFFF000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00
FF000000FFFF00FF0000FF00FF00FFFF0000FF000000FFFF000000FFFF00FF0000FFFFFF
FFFF000000FFFF0000FF0000FF00FFFFFF00FF00000000FFFFFFFF00FFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF00
00FFFF000000FFFFFF00FF0000FFFFFFFF0000FFFF000000FFFF000000FFFFFF00000000
0000FFFF0000FF00FFFFFF00FF000000FF00FF00FFFF00000000FF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF
000000FFFF00000000FFFFFF00000000FF00FFFFFFFF00FFFFFFFF00FFFFFFFFFF00FFFF
00FFFFFFFF00FF000000FF0000FFFF00FF00FF000000FFFF00FFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000
FFFF0000FF00FFFF000000FF00FFFF00FF00000000FF00000000FF0000000000FF0000FF
0000000000FFFFFF00FFFFFF0000FF00FF0000FFFF0000FF00000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FF
FFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FFFF00FFFFFF00FFFF00FF00FFFF
FF00FFFF00000000FFFFFFFFFF00FF00FF00FFFFFFFF0000FFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF0000
0000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF000000FF0000FF00FF000000
FF0000FF00FFFF0000000000FF00FF0000FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFF00FFFFFF0000FFFFFF00FF
FFFF0000FFFFFFFF00FFFF00FF00FF00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FFFFFFFFFF00000000FFFF
FFFFFF00000000FF0000FF00FF00FF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000000000FF00FFFF000000
000000FFFF00FFFFFF00FF0000FFFFFF00FFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
00FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF00FFFF00FF000000FFFF00
FFFF0000FF00000000FFFFFF000000FF0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF0000FF0000FFFF000000FF
FFFFFF00FF00FFFF00000000FFFF00FF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00FFFFFF000000FFFF0000
0000FF00FF0000FF00FFFF0000FF00FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00000000FFFF0000FF00FF
FF0000FFFFFF0000FFFFFFFF00FF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFF00FFFFFFFF00FF0000
FF00FFFFFFFFFF0000000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF0000FF0000000000FFFFFF00
FF0000000000FF00FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFFFF00FFFF00000000FF
FFFF00FFFF00FF0000FF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF000000FF0000FF00FFFF0000
00FF0000FF00FF00FFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FFFFFF0000FFFFFFFF00
FFFFFF00FF00FF000000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFFFFFF00000000FF00
0000FF0000FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000000000FFFF00FFFFFF
00FFFFFF000000FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FFFF0000FF000000FF
00000000FFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFFFF0000FFFF0000
FFFF00FFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FF00FFFFFFFF00
0000FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF00FF0000000000FF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFFFF00FFFF0000
00FFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FF000000FFFF
0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF0000FFFF0000FF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFFFFFF00FF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF00000000FF0000
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF00FFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[TextData[{
  "This shows rule 30 evolving from an initial condition consisting of a ",
  StyleBox["{1,1}", "MR"],
  " seed on a background of repeated ",
  StyleBox["{1,0,1,1}", "MR"],
  " blocks. "
}], "MathCaption",
  CellTags->{"S3.8.6", "6.9"}],

Cell[CellGroupData[{

Cell["\<\
ArrayPlot[CellularAutomaton[30, {{1, 1}, {1, 0, 1, 1}}, 100]]\
\>", \
"Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .66887 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00630716 0.0159256 0.00630716 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .66887 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .66887 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .66887 L
s
0 .66887 m
1 .66887 L
s
1 0 m
1 .66887 L
s
0 0 m
1 0 L
1 .66887 L
0 .66887 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01593 translate
.95238 .63702 scale
151 string
151 101 8 [151 0 0 101 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FF00FFFF00000000FFFFFF00FFFFFFFF00FFFFFFFFFFFF000000FFFF0000FF00FFFF
000000000000FFFFFFFF0000FF000000FFFFFFFF0000FFFFFF00FF00FF0000FFFF000000
FFFFFF000000FF0000FF00FF0000FFFFFFFF00FFFFFFFFFFFFFF00FFFF000000FFFF00FF
00FF00FFFF000000FFFF00FF000000FF00FFFFFFFFFF00000000FF00FFFFFFFF000000FF
000000FF0000FF
FF00FF0000FF00FFFF000000FF0000000000FFFFFFFFFFFFFFFF00FFFFFFFF00FF000000
FFFF00FFFF00000000FF00FFFFFF00FFFFFFFFFFFF000000FF00FF00FF00FFFFFFFF00FF
FFFFFFFF00FFFFFF0000FFFFFF00000000FF00000000000000FF000000FFFF0000FF00FF
00FF000000FFFF0000FF0000FFFF00FF0000000000FF00FFFF0000FFFFFFFFFFFF00FFFF
FF00FFFFFF0000
00FFFFFF0000FFFFFFFF00FFFFFF00FFFF0000000000000000FF00000000FF0000FFFF00
00FF0000FF00FFFF00FF000000FF00000000000000FFFF00FF00FF00FF00000000FF0000
00000000FFFFFFFFFF000000FF00FFFF0000FFFF00FFFF00FFFFFF00FFFFFFFF00FF00FF
0000FFFF0000FF00FFFFFF000000FFFFFF00FFFF0000FFFFFFFF000000000000FF000000
00FFFFFFFFFF00
FFFFFFFFFF00000000FF00000000FFFFFFFF00FFFF00FFFF0000FFFF00FFFFFF0000FF00
FFFFFF00FF0000FF0000FFFF00FF00FFFF00FFFF0000FF00FF00FF00FF00FFFF0000FFFF
00FFFF000000000000FFFF0000FFFFFFFF0000FF0000FF000000FF00000000FF00FF00FF
00FFFFFFFF00FF00000000FFFF00000000FFFFFFFF0000000000FFFF00FFFF0000FFFF00
FFFFFFFFFFFFFF
00000000FF00FFFF00FF00FFFF00000000FF000000FFFFFFFF000000FFFFFFFFFF00FF00
0000FF00FF00FFFFFF0000FF00FF000000FFFFFFFF00FF00FF00FF0000FFFFFFFF000000
FFFFFFFF00FFFF00FFFFFFFF00000000FF00FFFFFF0000FFFF00FF00FFFF00FF00FF00FF
00000000FF00FF00FFFF000000FFFF00FFFFFFFFFFFF00FFFF000000FFFFFFFF0000FF00
000000000000FF
00FFFF00FF0000FF00FF0000FF00FFFF0000FFFF0000000000FFFF0000000000FF0000FF
FF00FF0000FFFFFFFFFF00FF0000FFFF00000000FF00FF0000FFFFFF0000000000FFFF00
000000FF0000FF00000000FF00FFFF0000FFFFFFFFFF0000FF00FF0000FF00FF00FF00FF
00FFFF00FF00FF000000FFFF0000FF00000000000000FFFFFFFF00FFFFFFFFFFFF0000FF
FF00FFFF00FFFF
000000FFFFFF0000FFFFFF00FF0000FF00FFFFFFFF00FFFF0000FF00FFFF00FFFFFF0000
00FFFFFF000000000000FFFFFF0000FF00FFFF00FF00FF00FFFFFFFFFF00FFFF000000FF
FF00FFFFFF00FF00FFFF00FF0000FF00FFFFFFFFFFFFFF0000FFFFFF00FF00FF00FF00FF
0000FF0000FFFFFF00FFFFFFFF00FF00FFFF00FFFF0000000000FFFFFFFFFFFFFFFF0000
FF0000FF000000
FF00FFFFFFFFFF00000000FFFFFF00FF0000000000FFFFFFFF00FF000000FFFFFFFFFF00
FFFFFFFFFF00FFFF00FFFFFFFFFF00FF0000FF00FF00FF0000000000FF000000FFFF0000
FF000000FF00FF000000FFFFFF0000FFFFFFFFFFFFFFFFFF000000FF00FF00FF00FF00FF
00FFFFFF000000FF00000000FF00FF0000FF0000FF00FFFF00FFFFFFFFFFFFFFFFFFFF00
FF00FFFFFF00FF
FF0000000000FF00FFFF00000000FFFFFF00FFFF00000000FF0000FFFF0000000000FF00
00000000FF0000FF000000000000FFFFFF00FF00FF00FF00FFFF00FFFFFF00FFFFFFFF00
00FFFF0000FFFFFF00FFFFFFFFFF00000000000000000000FFFF00FF00FF00FF00FF00FF
00000000FFFF00FF00FFFF00FF00FF00FFFFFF00FF0000FF00000000000000000000FF00
FF000000FF0000
FFFF00FFFF00FF0000FF00FFFF000000FF0000FF00FFFF00FF00FFFFFFFF00FFFF00FF00
FFFF00FFFFFF0000FFFF00FFFF000000FF00FF00FF00FF0000FF000000FF00000000FF00
FFFFFFFF000000FF0000000000FF00FFFF00FFFF00FFFF0000FF00FF00FF00FF00FF00FF
00FFFF0000FF00FF0000FF00FF00FF00000000FFFFFF00FF00FFFF00FFFF00FFFF0000FF
FFFF00FFFFFF00
00FF000000FFFFFF0000FFFFFFFF00FFFFFF00FF0000FF00FF00000000FF0000FF00FF00
0000FFFFFFFFFF0000FF000000FFFF00FF00FF0000FFFFFF0000FFFF00FF00FFFF0000FF
FFFFFFFFFF00FFFFFF00FFFF00FF0000FF000000FFFFFFFF00FF00FF00FF00FF00FF0000
FFFFFFFF0000FFFFFF00FF00FF00FF00FFFF000000FF00FF0000FF000000FFFFFFFF0000
00FF000000FF00
FFFFFF00FFFFFFFFFF00000000FF00000000FFFFFF00FF0000FFFF00FFFFFF0000FFFFFF
00FFFFFFFFFFFFFF0000FFFF0000FF00FF00FF00FFFFFFFFFF0000FF0000FFFFFFFF0000
00000000FF000000FF000000FFFFFF0000FFFF00000000FF00FF00FF00FF00FF00FF00FF
FFFFFFFFFF000000FF00FF00FF00FF000000FFFF00FF00FF00FFFFFF00FFFFFFFFFFFF00
FFFFFF00FFFFFF
0000FF0000000000FF00FFFF00FF00FFFF00000000FFFFFF000000FFFFFFFFFF000000FF
00000000000000FF00FFFFFFFF00FF00FF0000FFFFFFFFFFFFFF00FF00FFFFFFFFFFFF00
FFFF00FFFFFF00FFFFFF00FFFFFFFFFF0000FF00FFFF00FF00FF00FF00FF00FF00FF0000
0000000000FFFF00FF00FF00FF0000FFFF0000FF00FF00FF000000FF000000000000FF00
0000FF000000FF
00FFFFFF00FFFF00FF0000FF00FF0000FF00FFFF00000000FFFF000000000000FFFF00FF
00FFFF00FFFF00FF00000000FF0000FFFFFF00000000000000FF00FF000000000000FF00
00FF000000FF00000000FFFFFFFFFFFFFF00FF0000FF00FF00FF00FF00FF00FF00FF00FF
FF00FFFF0000FF00FF00FF00FF00FFFFFFFF00FF0000FFFFFF00FFFFFF00FFFF00FFFFFF
00FFFFFF00FFFF
000000FF000000FFFFFF0000FFFFFF00FF0000FF00FFFF000000FFFF00FFFF0000FF00FF
0000FF0000FF0000FFFF00FFFFFF000000FF00FFFF00FFFF0000FFFFFF00FFFF00FFFFFF
0000FFFF00FF00FFFF0000000000000000FFFFFF00FF00FF00FF00FF00FF00FF00FF0000
00FFFFFFFF00FF00FF00FF00FF0000000000FFFFFF000000FF000000FF0000FF000000FF
000000FF000000
FF00FFFFFF00FFFFFFFFFF00000000FFFFFF00FF000000FFFF000000FFFFFFFF0000FFFF
FF00FF00FFFFFF0000FF00000000FFFF00FF000000FFFFFFFF000000FF000000FFFFFFFF
FF0000FF0000FFFFFFFF00FFFF00FFFF000000FF00FF00FF00FF00FF00FF00FF0000FFFF
00000000FF00FF00FF0000FFFFFF00FFFF00000000FFFF0000FFFF00FF00FFFFFF00FFFF
FF00FFFFFF00FF
FF000000FF0000000000FF00FFFF00000000FFFFFF00FFFFFFFF00FFFFFFFFFFFF000000
FF0000FFFFFFFFFF00FF00FFFF0000FF0000FFFF0000000000FFFF0000FFFF0000000000
FF00FFFFFF00000000FF0000FF000000FFFF00FF00FF00FF00FF00FF0000FFFFFF0000FF
00FFFF00FF0000FFFFFF000000FF000000FFFF00FFFFFFFF0000FF00FF000000FF000000
FF000000FF0000
FFFF00FFFFFF00FFFF00FF0000FF00FFFF000000FF0000000000FFFFFFFFFFFFFFFF00FF
FFFF0000000000FF0000FFFFFFFF00FF00FFFFFFFF00FFFF0000FF00FFFFFFFF00FFFF00
FF00000000FFFF00FFFFFF0000FFFF0000FF00FF00FF00FF00FF00FF00FFFFFFFFFF00FF
000000FFFFFF00000000FFFF0000FFFF000000FFFFFFFFFFFF0000FFFFFF00FFFFFF00FF
FFFF00FFFFFF00
00FF000000FF000000FFFFFF0000FFFFFFFF00FFFFFF00FFFF0000000000000000FF0000
00FF00FFFF00FFFFFF00000000FF00FF0000000000FFFFFFFF00FF00000000FF0000FF00
FF00FFFF0000FF000000FF00FFFFFFFF00FF00FF00FF00FF00FF00FF0000000000FF0000
FFFF000000FF00FFFF0000FF00FFFFFFFF00FFFFFFFFFFFFFFFF000000FF000000FF0000
00FF000000FF00
FFFFFF00FFFFFF00FFFFFFFFFF00000000FF00000000FFFFFFFF00FFFF00FFFF0000FFFF
00FF0000FF000000FF00FFFF0000FFFFFF00FFFF00000000FF0000FFFF00FFFFFF00FF00
00FFFFFFFF0000FFFF00FF00000000FF00FF00FF00FF00FF00FF00FF00FFFF00FFFFFF00
0000FFFF0000FFFFFFFF00FF0000000000FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF
0000FF000000FF0000000000FF00FFFF00FF00FFFF00000000FF000000FFFFFFFF000000
FFFFFF0000FFFF0000FFFFFFFF000000FF000000FFFF00FFFFFF0000FF000000FF00FF00
FFFFFFFFFFFF0000FF00FF00FFFF00FF00FF00FF00FF00FF00FF00FF000000FFFFFFFFFF
00FFFFFFFF0000000000FFFFFF00FFFF00000000000000000000FF000000FF000000FF00
0000FF000000FF
00FFFFFF00FFFFFF00FFFF00FF0000FF00FF0000FF00FFFF0000FFFF0000000000FFFF00
0000FF00FFFFFFFF0000000000FFFF0000FFFF000000FFFFFFFFFF0000FFFF00FF0000FF
FFFFFFFFFFFFFF00FF00FF0000FF00FF00FF00FF00FF00FF00FF0000FFFF000000000000
FFFFFFFFFFFF00FFFF000000FF000000FFFF00FFFF00FFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFF
000000FF000000FF000000FFFFFF0000FFFFFF00FF0000FF00FFFFFFFF00FFFF000000FF
FF0000FFFFFFFFFFFF00FFFF0000FF00FFFFFFFF00FFFFFFFFFFFFFF000000FFFFFF0000
000000000000FF0000FFFFFF00FF00FF00FF00FF00FF0000FFFFFF000000FFFF00FFFF00
0000000000FF000000FFFF0000FFFF0000FF0000FF0000FF000000FF000000FF000000FF
000000FF000000
FF00FFFFFF00FFFFFF00FFFFFFFFFF00000000FFFFFF00FF0000000000FFFFFFFF00FFFF
FFFF00000000000000FFFFFFFF00FF00000000FF0000000000000000FFFF000000FF00FF
FF00FFFF00FFFFFF000000FF00FF00FF00FF0000FFFFFF00000000FFFF000000FFFFFFFF
00FFFF00FFFFFF00FFFFFFFF0000FF00FFFFFF00FF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FF
FF000000FF000000FF0000000000FF00FFFF00000000FFFFFF00FFFF00000000FF000000
00FF00FFFF00FFFF00000000FF0000FFFF00FFFFFF00FFFF00FFFF000000FFFF00FF0000
FF0000FF00000000FFFF00FF00FF0000FFFFFF000000FF00FFFF000000FFFF00000000FF
0000FF00000000FFFFFFFFFFFF00FF000000FF00FF000000FF000000FF000000FF000000
FF000000FF0000
FFFF00FFFFFF00FFFFFF00FFFF00FF0000FF00FFFF000000FF0000FF00FFFF00FF00FFFF
00FF0000FF000000FFFF00FFFFFF0000FF000000FF0000FF000000FFFF0000FF00FF00FF
FFFF00FF00FFFF0000FF0000FFFFFF00000000FFFF00FF000000FFFF000000FFFF00FFFF
FF00FF00FFFF000000000000FF0000FFFF0000FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00
00FF000000FF000000FF000000FFFFFF0000FFFFFFFF00FFFFFF00FF0000FF00FF000000
FFFFFF0000FFFF000000FFFFFFFFFF0000FFFF00FF00FFFFFF00FFFFFFFF00FF00FF0000
00FF00FF0000FF00FFFFFF000000FF00FFFF0000FF0000FFFF000000FFFF0000FF000000
FF00FF000000FFFF00FFFF00FF00FFFFFFFF000000FF000000FF000000FF000000FF0000
00FF000000FF00
FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFF00000000FF00000000FFFFFF00FF0000FFFF00
0000FF00FFFFFFFF00FFFFFFFFFFFFFF0000FF00FF000000FF00000000FF00FF0000FFFF
0000FFFFFF00FF00000000FFFF0000FFFFFFFF00FF00FFFFFFFF00FFFFFFFF0000FFFF00
FF0000FFFF0000FF0000FF0000FFFFFFFFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF
0000FF000000FF000000FF0000000000FF00FFFF00FF00FFFF00000000FFFFFF000000FF
FF00FF0000000000FFFFFFFFFFFFFFFFFF00FF0000FFFF00FF00FFFF00FF00FF00FFFFFF
FF000000FF0000FFFF00FFFFFFFF00000000FF00FF0000000000FFFFFFFFFFFF0000FF00
FF00FFFFFFFF00FF00FFFFFF000000000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF
00FFFFFF00FFFFFF00FFFFFF00FFFF00FF0000FF00FF0000FF00FFFF00000000FFFF0000
00FFFFFF00FFFF00000000000000000000FFFFFF0000FF00FF0000FF00FF0000FFFFFFFF
FFFF00FFFFFF0000FF00000000FF00FFFF00FF00FF00FFFF00FFFFFFFFFFFFFFFF00FF00
FF00000000FF0000FFFFFFFFFF00FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFF
000000FF000000FF000000FF000000FFFFFF0000FFFFFF00FF0000FF00FFFF000000FFFF
000000FF000000FFFF00FFFF00FFFF00FFFFFFFFFF0000FFFFFF0000FFFFFF0000000000
0000FFFFFFFFFF00FF00FFFF00FF0000FF00FF00FF0000FF0000000000000000FF00FF00
00FFFF00FFFFFF0000000000FF0000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFF00000000FFFFFF00FF000000FFFF000000
FFFF0000FFFF0000FF0000FF0000FF0000000000FF00FFFFFFFFFF000000FF00FFFF00FF
FF0000000000FF00FF000000FFFFFF00FF00FF00FF00FFFFFF00FFFF00FFFF0000FFFFFF
000000FFFFFFFFFF00FFFF00FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FF
FF000000FF000000FF000000FF0000000000FF00FFFF00000000FFFFFF00FFFFFFFF00FF
FFFFFF0000FF00FFFFFF00FF00FFFFFF00FFFF00FF000000000000FFFF00FF000000FFFF
FFFF00FFFF00FF0000FFFF000000FF00FF00FF00FF000000FF000000FFFFFFFF00000000
FFFF0000000000FF0000FF00FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF0000
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFF00FF0000FF00FFFF000000FF0000000000FFFF
FFFFFFFF00FF000000FF00FF000000FF0000FF0000FFFF00FFFF0000FF0000FFFF000000
00FF000000FFFFFF000000FFFF00FF00FF00FF0000FFFF0000FFFF00000000FF00FFFF00
00FF00FFFF00FFFFFF0000FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00
00FF000000FF000000FF000000FF000000FFFFFF0000FFFFFFFF00FFFFFF00FFFF000000
000000FF0000FFFF00FF0000FFFF00FF00FFFFFF0000FF0000FF00FFFFFF0000FF00FFFF
0000FFFF00000000FFFF0000FF00FF00FF00FF00FFFFFFFF0000FF00FFFF0000FFFFFFFF
00FF000000FFFFFFFFFF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFF00000000FF00000000FFFFFFFF00FF
FF00FFFFFF000000FFFFFF0000FF00FF000000FF00FFFFFF0000FFFFFFFFFF0000FFFFFF
FF000000FFFF00FFFFFFFF00FF00FF00FF0000FFFFFFFFFFFF0000FFFFFFFF0000000000
FFFFFF00FFFFFFFFFFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF
0000FF000000FF000000FF000000FF0000000000FF00FFFF00FF00FFFF00000000FF0000
00FFFFFFFFFF00FFFFFFFFFF00FF0000FFFF00FF000000FF00FFFFFFFFFFFFFF00000000
00FFFF0000FF00000000FF00FF0000FFFFFF000000000000FF00FFFFFFFFFFFF00FFFF00
0000FF00000000000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF00FF0000FF00FF0000FF00FFFF0000FFFF
0000000000FF000000000000FFFFFF0000FF0000FFFF00FF00000000000000FF00FFFF00
FFFFFFFF00FF00FFFF0000FFFFFF00000000FFFF00FFFF00FF000000000000FF000000FF
FF0000FFFF00FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFF
000000FF000000FF000000FF000000FF000000FFFFFF0000FFFFFF00FF0000FF00FFFFFF
FF00FFFF0000FFFF00FFFF000000FF00FFFFFF0000FF00FF00FFFF00FFFF00FF0000FF00
000000FF0000FFFFFFFF000000FF00FFFF0000FF000000FFFFFF00FFFF00FFFFFF00FFFF
FFFF0000FF0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFF00000000FFFFFF00FF00000000
00FFFFFFFF0000FF000000FFFF0000FFFFFFFFFF00FF00FF0000FF000000FFFFFF0000FF
FF00FFFFFF0000000000FFFF0000FFFFFFFF0000FFFF000000FF0000FF00000000FFFFFF
FFFFFF00FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FF
FF000000FF000000FF000000FF000000FF0000000000FF00FFFF00000000FFFFFF00FFFF
00000000FF00FFFFFF00FFFFFFFF0000000000FF00FF00FF00FFFFFF00FFFFFFFFFF0000
FF000000FF00FFFF00FFFFFFFF00000000FF00FFFFFFFF00FFFFFF00FF00FFFF00000000
0000FF00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF0000
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF00FF0000FF00FFFF000000FF0000FF
00FFFF00FF00000000FFFFFFFFFFFF00FFFF00FF00FF00FF00000000FFFFFFFFFFFFFF00
00FFFF00FF0000FF00000000FF00FFFF00FF00000000FF000000FF00FF000000FFFF00FF
FF0000FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00
00FF000000FF000000FF000000FF000000FF000000FFFFFF0000FFFFFFFF00FFFFFF00FF
0000FF00FF00FFFF000000000000FF0000FF00FF00FF0000FFFF00FFFFFFFFFFFFFFFFFF
000000FFFFFF00FF00FFFF00FF0000FF00FF00FFFF0000FFFF00FF0000FFFF000000FFFF
FFFF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFF00000000FF00000000FFFF
FF00FF0000FFFFFFFF00FFFF00FFFFFF00FF0000FFFFFF0000FF00000000000000000000
FFFF000000FF00FF000000FFFFFF00FF0000FFFFFFFF0000FF00FF00FFFFFFFF00FFFFFF
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF
0000FF000000FF000000FF000000FF000000FF0000000000FF00FFFF00FF00FFFF000000
00FFFFFF00000000FF0000FF000000FF00FF00FFFFFFFFFF00FF00FFFF00FFFF00FFFF00
0000FFFF00FF0000FFFF000000FF00FF00FFFFFFFFFFFF00FF00FF00000000FF00000000
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF00FF0000FF00FF0000FF00FFFF
00000000FFFF00FFFFFF0000FFFF00FF00FF0000000000FF00FF0000FF0000FF000000FF
FF000000FFFFFF000000FFFF00FF00FF000000000000FF00FF0000FFFF00FFFFFF00FFFF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFF
000000FF000000FF000000FF000000FF000000FF000000FFFFFF0000FFFFFF00FF0000FF
00FFFF000000FFFFFFFFFF0000FF0000FFFFFF00FFFF00FF00FF00FFFFFF0000FFFF0000
00FFFF00000000FFFF0000FF00FF0000FFFF00FFFF0000FFFFFF0000FF000000FF0000FF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFF00000000FFFFFF00FF
000000FFFF0000000000FF00FFFFFF000000FF0000FF00FF0000FFFFFFFFFF000000FFFF
000000FFFF00FFFFFFFF0000FFFFFF0000FF0000FF00FFFFFFFFFF0000FFFF00FF00FFFF
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FF
FF000000FF000000FF000000FF000000FF000000FF0000000000FF00FFFF00000000FFFF
FF00FFFFFFFF00FFFF0000FFFFFFFFFF00FFFFFF0000FFFFFF000000000000FFFF000000
FFFF000000FFFFFFFFFFFF000000FF00FFFFFF0000FFFFFFFFFFFFFF0000FF00FF000000
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF0000
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF00FF0000FF00FFFF000000
FF0000000000FFFFFFFF000000000000FFFFFFFFFF00000000FFFF00FFFF000000FFFF00
0000FFFF00000000000000FFFF00FF000000FF00FFFFFFFFFFFFFFFFFF0000FFFFFF00FF
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00
00FF000000FF000000FF000000FF000000FF000000FF000000FFFFFF0000FFFFFFFF00FF
FFFF00FFFF0000000000FFFF00FFFF0000000000FF00FFFF0000FF000000FFFF000000FF
FF0000FF00FFFF00FFFF0000FF0000FFFF0000FFFFFFFFFFFFFFFFFFFFFF000000FF0000
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFF00000000FF0000
0000FFFFFFFF00FFFF000000FFFFFFFF00FFFF00FF0000FF00FFFFFF00FFFFFFFF00FFFF
FFFF00FF0000FF0000FF00FFFFFF0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF
0000FF000000FF000000FF000000FF000000FF000000FF0000000000FF00FFFF00FF00FF
FF00000000FF000000FFFF00000000FF000000FFFFFF00FF000000FF00000000FF000000
00FF00FF00FFFFFF0000FFFFFFFFFF00FF00000000000000000000000000FF000000FF00
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF00FF0000FF00FF0000
FF00FFFF0000FFFF0000FF00FFFF0000FFFF000000FF0000FFFF00FF00FFFF00FF00FFFF
00FF0000FFFFFFFFFF0000000000FF0000FFFF00FFFF00FFFF00FFFF00FFFFFF00FFFFFF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFF
000000FF000000FF000000FF000000FF000000FF000000FF000000FFFFFF0000FFFFFF00
FF0000FF00FFFFFFFF00FF0000FF00FFFFFFFF00FFFFFF0000FF00FF0000FF00FF000000
FFFFFF0000000000FF00FFFF00FFFFFF0000FF0000FF0000FF0000FF000000FF000000FF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFF00000000FF
FFFF00FF0000000000FFFFFF00FF0000000000FFFFFFFFFF0000FFFFFF0000FFFFFF00FF
FFFFFFFF00FFFF00FF000000FFFFFFFFFF00FF00FFFFFF00FF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FF
FF000000FF000000FF000000FF000000FF000000FF000000FF0000000000FF00FFFF0000
0000FFFFFF00FFFF00000000FFFFFF00FFFF0000000000FF00FFFFFFFFFF000000FF0000
000000FF0000FF0000FFFF0000000000FF00FF000000FF00FF000000FF000000FF000000
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF0000
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF00FF0000FF00FF
FF000000FF0000FF00FFFF00000000FFFFFFFF00FFFF00FF000000000000FFFF00FF00FF
FF00FFFFFF00FF00FFFFFFFF00FFFF00FF0000FFFF0000FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FFFFFF0000FFFF
FFFF00FFFFFF00FF0000FF00FFFF00000000FF0000FF0000FFFF00FFFF0000FF00FF0000
FF000000FF00FF00000000FF0000FF00FF00FFFFFFFF000000FF000000FF000000FF0000
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFF000000
00FF00000000FFFFFF00FF0000FF00FFFF00FF00FFFFFF000000FFFFFFFF0000FFFFFF00
00FFFF00FF0000FFFF00FFFFFF00FF0000FFFFFFFFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF
0000FF000000FF000000FF000000FF000000FF000000FF000000FF0000000000FF00FFFF
00FF00FFFF00000000FFFFFF00FF0000FF00FF00000000FFFF00000000FF00FFFFFFFFFF
000000FFFFFF0000FF00000000FFFFFF000000000000FF000000FF000000FF000000FF00
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF00FF0000FF
00FF0000FF00FFFF00000000FFFFFF00FF00FF00FFFF0000FF00FFFF0000FFFFFFFFFFFF
FF00FFFFFFFFFF0000FFFF00FFFFFFFFFF00FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FFFFFF0000
FFFFFF00FF0000FF00FFFF000000FF00FF0000FFFFFFFF0000FFFFFFFF00000000000000
00FFFFFFFFFFFFFF0000FF0000000000FF0000FF000000FF000000FF000000FF000000FF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFF00
000000FFFFFF00FF000000FFFF0000FFFFFF00000000FF00FFFFFFFFFFFF00FFFF00FFFF
00000000000000FF00FFFFFF00FFFF00FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FF
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000000000FF00
FFFF00000000FFFFFF00FFFFFFFF000000FF00FFFF00FF000000000000FF0000FF0000FF
00FFFF00FFFF00FF000000FF0000FF00FF000000FF000000FF000000FF000000FF000000
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF0000
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF00FF00
00FF00FFFF000000FF0000000000FFFF00FF0000FF0000FFFF00FFFF00FF00FFFFFF00FF
0000FF000000FFFFFF00FFFFFF0000FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FFFFFF
0000FFFFFFFF00FFFFFF00FFFF0000FF00FF00FFFFFF0000FF0000FF00FF00000000FFFF
FF0000FFFF00000000FFFFFFFFFF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFF
FF00000000FF00000000FFFFFFFF00FF00FF000000FF00FFFFFF00FF0000FFFF00FFFFFF
FFFF000000FFFF00FFFFFFFFFFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000000000
FF00FFFF00FF00FFFF00000000FF00FF0000FFFF00FF00000000FFFFFF0000FF00000000
0000FFFF0000FF00000000000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF00
FF0000FF00FF0000FF00FFFF0000FFFFFF0000FF00FF00FFFF000000FF00FFFFFF00FFFF
00FFFFFFFF0000FFFF00FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
FFFF0000FFFFFF00FF0000FF00FFFFFFFFFF00FF00FF000000FFFF00FF000000FF000000
FFFFFFFFFFFF0000FF0000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FFFFFF00000000FFFFFF00FF0000000000FF00FF0000FFFF000000FFFFFF00FFFFFF00FF
FFFFFFFFFFFFFF00FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FF
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
0000FF00FFFF00000000FFFFFF00FFFF0000FFFFFF000000FFFF000000FF000000FF0000
000000000000FF00FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF0000
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FF00FF0000FF00FFFF000000FF0000FF00FFFFFFFFFF00FFFFFFFF00FFFFFF00FFFFFF00
FFFF00FFFF0000FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FFFFFF0000FFFFFFFF00FFFFFF00FF0000000000FF00000000FF000000FF000000FF00
0000FFFFFFFF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFFFFFF00000000FF00000000FFFFFF00FFFF0000FFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFFFFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
00000000FF00FFFF00FF00FFFF00000000FFFFFFFF0000FF000000FF000000FF000000FF
000000000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFF00FF0000FF00FF0000FF00FFFF00000000FF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FFFFFF0000FFFFFF00FF0000FF00FFFF00FF000000FF000000FF000000FF000000
FF0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFFFFFF00000000FFFFFF00FF0000FF0000FFFF0000FFFF0000FFFF0000FFFF00
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FF
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF0000000000FF00FFFF00000000FFFFFF00FF00FFFFFFFF0000FF00FFFFFFFF0000FF00
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF0000
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFF00FF0000FF00FFFF000000FF0000FFFFFFFFFFFF0000FFFFFFFFFFFF0000FF
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FFFFFF0000FFFFFFFF00FFFFFF000000000000FF00FFFFFFFFFFFFFFFF0000
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFFFFFF00000000FF00000000FFFF00FFFF0000FFFFFFFFFFFFFFFFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF0000000000FF00FFFF00FF00FFFF000000FFFFFFFF00000000000000000000FF00
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFF00FF0000FF00FF000000FFFF0000000000FFFF00FFFF00FFFF00FFFFFF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000FFFFFF0000FFFFFF00FFFFFFFF00FFFF0000FF0000FF0000FF000000FF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FFFFFFFFFF000000FF00000000FF0000FF00FFFFFF00FF00FFFFFF00FFFF
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FF
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF000000000000FFFF0000FFFF00FFFFFF00FF000000FF00FF000000FF000000
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF0000
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00FFFF00FFFFFFFF0000FF000000FF0000FFFF0000FFFFFF00FFFFFF00FF
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF000000FFFFFFFFFFFF0000FFFF00FF00FFFFFFFF000000FF000000FF0000
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFFFFFFFFFFFF0000FF0000FFFFFFFFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF0000000000000000FF00FFFFFF000000000000FF000000FF000000FF00
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFFFF00FFFF00FFFF0000FFFFFFFFFF00FFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
00FFFFFF00FFFF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000FF000000FFFFFFFF0000000000FF0000FF000000FF000000FF000000FF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF
000000FF000000
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FFFFFF00FFFFFFFFFFFF00FFFF00FF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFF
FF00FFFFFF00FF
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF000000FF000000000000FF0000FF00FF000000FF000000FF000000FF000000
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
FF000000FF0000
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00FFFFFF00FFFF00FFFFFF0000FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FF
FFFF00FFFFFF00
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF000000FF000000FFFFFFFFFF000000FF000000FF000000FF000000FF0000
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF0000
00FF000000FF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF000000FF00000000000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF00
0000FF000000FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell["\<\
Particularly in studying interactions between structures, you may \
sometimes want to specify initial conditions for cellular automata in which \
certain blocks are placed at particular offsets. \
\>", "Text",
  CellTags->{"S3.8.6", "6.10"}],

Cell[TextData[{
  "This sets up an initial condition with black cells at offsets ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[PlusMinus]40\)\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.8.6", "6.11"}],

Cell[CellGroupData[{

Cell["\<\
ArrayPlot[CellularAutomaton[30, {{{ {1}, {-40} }, {{1}, {40}}}, 0}, \
100]]\
\>", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .35943 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00338926 0.00855787 0.00338926 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .35943 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .35943 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .35943 L
s
0 .35943 m
1 .35943 L
s
1 0 m
1 .35943 L
s
0 0 m
1 0 L
1 .35943 L
0 .35943 L
closepath
clip
newpath
% Start of gray image
p
.02381 .00856 translate
.95238 .34231 scale
281 string
281 101 8 [281 0 0 101 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFFFF00FFFFFF00FF
000000FF00000000FF0000FFFF00FFFF00FFFFFF00FF00FFFFFFFFFF000000FF00FFFFFF
00FF00FFFFFF00FF00FF000000FFFF00FF0000000000FF00FF00FFFFFF00FF0000000000
00FF00FF00FF0000FFFFFF00FF00FFFFFFFF0000000000000000FFFF00FFFFFF00000000
00FF000000FF00FF00FFFFFF00000000FFFFFFFF00FFFF00FF00FF00FF00FF0000FF00FF
00FFFF0000000000FFFFFF0000FF00FF00FFFF000000FFFFFFFF0000FF00FF00FFFFFF00
FF00FFFFFF0000FFFF0000FFFFFFFF00000000FF00000000FFFFFF00FF0000FF00000000
FF0000FF0000FF00000000FFFF00FF00FF00FF000000FFFF00FFFFFF00
FF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FF000000FF0000
FFFF0000FFFF00FFFFFF0000FF0000FF000000FF00FF000000000000FFFF00FF000000FF
00FF000000FF00FF0000FFFF000000FFFFFF00FFFF00FF00FF000000FF0000FFFF00FFFF
00FF0000FFFFFF000000FF0000FFFFFFFFFFFF00FFFF00FFFF000000FFFFFFFFFF00FFFF
0000FFFF00FF00FF000000FF00FFFF00000000FF0000FF00FF00FF0000FFFFFF00FF00FF
0000FF00FFFF00FFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFF00FF00FF000000FF00
FF000000FF00FFFFFFFF00000000FF00FFFF00FF00FFFF00000000FFFFFF00FF00FFFF00
FF00FFFFFF00FF00FFFF0000FF00FF00FF0000FFFF0000FF00000000FF
FFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FFFF00FF00FF
FFFFFF0000FF000000FF00FFFFFF0000FFFF00FF0000FFFF00FFFF0000FF0000FFFF00FF
0000FFFF0000FFFFFF000000FFFF000000FF0000FF0000FFFFFF00FFFFFF0000FF0000FF
00FF00FFFFFFFFFF00FFFFFF000000000000FF0000FF000000FFFF000000000000FFFFFF
FF0000FF00FF0000FFFF00FF000000FFFF00FFFFFF00FF0000FFFFFF000000FF0000FFFF
FF00FF0000FF000000000000FFFFFF00000000FF000000000000FF00FF0000FFFF00FF00
00FFFF00FF00000000FF00FFFF00FF0000FF00FF0000FF00FFFF000000FF00FF0000FF00
FF000000FF0000FFFFFFFF00FF00FF00FF00FFFFFFFF0000FFFF00FFFF
FFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF0000FFFF
FFFFFFFF0000FFFF0000FFFFFFFFFF000000FFFFFF0000FF0000FF00FFFFFF0000FF00FF
00FFFFFFFF00000000FFFF000000FFFF00FF00FFFFFF000000FF000000FF00FFFFFF00FF
00FF0000000000FF00000000FFFF00FFFF00FF00FFFFFF00FFFFFFFF00FFFF00FFFFFFFF
FFFF0000FFFFFF0000FF0000FFFF0000FF000000FF00FF00FFFFFFFFFF00FFFFFF000000
00FFFFFF0000FFFF00FFFF000000FF00FFFF0000FFFF00FFFF0000FFFFFF000000FFFFFF
0000FF00FF00FFFF00FF000000FFFFFF0000FFFFFF00FF000000FFFF0000FFFFFF0000FF
FFFF00FFFFFF00000000FF00FF00FF0000FFFFFFFFFFFF000000FFFFFF
FFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFF000000
000000FF00FFFFFFFF000000000000FFFF000000FF00FFFFFF0000FFFFFFFFFF00FF00FF
00000000FF00FFFF000000FFFF0000FF00FF00000000FFFF0000FFFF00FF000000FF0000
FFFFFF00FFFF00FF00FFFF0000FF0000FF00FF000000FF00000000FF0000FF0000000000
00FF00FFFFFFFFFF00FF00FFFFFFFF0000FFFF00FF00FF0000000000FF00000000FFFF00
FFFFFFFFFF0000FF000000FFFF0000FFFFFFFF0000FF0000FF00FFFFFFFFFF00FFFFFFFF
FF00FF00FF000000FFFFFF00FFFFFFFFFF000000FF0000FFFF0000FF00FFFFFFFFFF0000
00FF000000FF00FFFF00FF00FF00FF00FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FFFF00
FFFF00FF0000000000FFFF00FFFF000000FFFF0000FFFFFFFFFF0000000000FF00FF00FF
00FFFF0000FFFFFFFF00FFFFFFFF00FF0000FFFF00FFFFFFFF000000FFFFFF00FFFFFF00
0000FF0000FF00FF0000FF00FFFFFF00FF0000FFFF0000FFFF00FFFFFF0000FFFF00FFFF
00FF0000000000FF0000FFFFFFFFFFFF0000FF0000FFFFFF00FFFF00FF00FFFF0000FF00
00000000FF00FFFFFF00FFFFFFFF00000000FF00FFFFFF00FF0000000000FF0000000000
FF00FF0000FFFF000000FF000000000000FFFF00FF00FFFFFFFF00FF000000000000FFFF
0000FFFF00FF0000FF00FF00FF00FF000000000000000000FFFFFFFFFF
FFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FF00
0000FFFFFF00FFFF0000FF000000FFFF0000FF00FFFFFFFFFFFFFF00FFFF00FF00FF0000
FFFFFFFF00000000FF0000000000FFFFFF0000FF0000000000FFFF00000000FFFFFFFFFF
00FFFFFF0000FFFFFF00FF000000FF00FF00FFFFFFFF000000FFFFFFFFFF0000FF0000FF
00FF00FFFF00FFFFFF000000000000FF00FFFFFF000000FF0000FF00FF0000FF00FFFFFF
00FFFF00FF000000FF00000000FF00FFFF00FF000000FF00FF00FFFF00FFFFFF00FFFF00
00FFFFFF000000FFFF0000FFFF00FFFF0000FF00FF0000000000FFFFFF00FFFF00FFFFFF
FF000000FFFFFF00FF00FF0000FFFFFF00FFFF00FFFF00FFFFFFFFFFFF
FFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF
FF000000FF0000FF00FFFFFF00FFFFFFFF00FF00000000000000FF0000FF0000FFFFFF00
00000000FFFF00FFFFFF00FFFF000000FF00FFFFFF00FFFF0000FF00FFFF000000000000
FFFFFFFFFF000000FF0000FFFF00FF00FF0000000000FFFF0000000000FF00FFFFFF00FF
00FF0000FF00000000FFFF00FFFF0000FFFFFFFFFF00FFFFFF0000FFFFFF00FF000000FF
0000FF0000FFFF00FF00FFFF00FF0000FF0000FFFF00FF00FF0000FF000000FF0000FF00
FFFFFFFFFF00FFFFFFFF000000FFFFFFFF0000FFFFFF00FFFF000000FF0000FF00000000
00FFFF000000FF0000FFFFFF000000FF0000FF000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFF
FFFF00FFFFFF00FF000000FF00000000FF0000FFFF00FFFF00FFFFFF00FF00FFFFFFFFFF
00FFFF0000FF000000FF000000FFFF00FF00000000FFFFFFFF0000FFFFFFFF00FFFF00FF
FFFFFFFFFFFF00FFFFFF0000FF00FF00FF00FFFF00FFFFFFFF00FFFF00FF000000FF0000
FFFFFF00FF00FFFF000000FFFFFFFF000000000000FFFFFFFFFF000000FF0000FFFF00FF
00FFFFFF0000FF00FF0000FF00FF00FFFFFF0000FF00FF00FF00FFFFFF00FFFFFF00FF00
0000000000FFFFFFFFFFFF00FFFFFFFFFFFF00000000FFFFFFFF00FFFFFF00FF00FFFF00
FFFFFFFF00FFFFFF00000000FFFF00FF00FFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF000000
00FF000000FF0000FFFF0000FFFF00FFFFFF0000FF0000FF000000FF00FF000000000000
FFFFFFFF0000FFFF0000FFFF0000FF0000FFFF00FFFFFFFFFFFF00000000FF0000FF0000
000000000000FFFFFFFFFF00FF00FF00FF0000FF00000000FF000000FFFFFF00FFFFFF00
0000FF0000FFFFFFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFFFF00FFFFFF0000FF0000
FFFFFFFFFF0000FFFFFF00FF0000FFFFFFFFFF00FF00FF00FF000000FF000000FF0000FF
FF00FFFF000000000000FF000000000000FF00FFFF00000000FF000000FF00FF0000FF00
000000FF000000FF00FFFF0000FF00FF00000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF
0000FFFF00FF00FFFFFFFF0000FF000000FF00FFFFFF0000FFFF00FF0000FFFF00FFFF00
000000FF00FFFFFFFF0000FF00FFFFFF0000FF000000000000FF00FFFF00FF00FFFFFF00
FFFF00FFFF0000000000FF00FF0000FFFFFF00FF00FFFF0000FFFF00000000FFFFFFFFFF
00FFFFFF00000000FF000000000000FF0000FF0000000000000000FFFFFFFFFF00FF00FF
FFFFFFFFFFFF00000000FFFFFF0000000000FF00FF0000FFFFFF00FFFFFF00FFFFFF0000
FF000000FFFF00FFFF0000FFFF00FFFF00FF0000FF00FFFF0000FFFF0000FFFFFF00FF00
FFFF0000FFFF0000FFFFFFFF00FF0000FFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFF
FF0000FF0000FFFFFFFFFFFF0000FFFF0000FFFFFFFFFF000000FFFFFF0000FF0000FF00
FFFF0000FFFFFFFFFFFF0000FFFFFFFFFF0000FFFF00FFFF00FF0000FF00FF000000FF00
0000FFFFFFFF00FFFF0000FFFFFF000000FF0000FFFFFFFF0000FF00FFFF0000000000FF
000000FF00FFFF0000FFFF00FFFF00FF00FFFFFF00FFFF00FFFF0000000000FF00FF0000
000000000000FFFF00FFFFFFFFFF00FFFF0000FFFFFF000000FF00000000FFFFFFFFFF00
00FFFF000000FFFFFFFF0000FF000000FFFFFF00FF0000FF00FFFFFFFF000000FF00FF00
00FF00FFFFFFFF0000000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000
FF00FFFFFF000000000000FF00FFFFFFFF000000000000FFFF000000FF00FFFFFF0000FF
FFFFFF000000000000FF00FFFFFFFFFFFFFF0000FF000000FFFFFF00FF0000FFFF0000FF
FF0000000000FFFFFFFF00000000FFFF00FF00FFFFFFFFFFFF0000FFFFFFFF00FFFF0000
FFFF0000FFFFFFFF0000FF0000FF00FF000000FF000000FFFFFFFF00FFFF0000FFFFFF00
FFFF00FFFF0000FF000000000000FFFFFFFF00000000FFFF00FF00FFFF0000000000FF00
FFFFFFFF00FFFFFFFFFFFF0000FFFF00000000FFFFFF00FF0000000000FFFF0000FFFFFF
00FF00000000FF00FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00
FF00000000FFFF00FFFF00FF0000000000FFFF00FFFF000000FFFF0000FFFFFFFFFF0000
000000FFFF00FFFF0000FFFFFFFFFFFFFFFFFF0000FFFF00000000FFFFFF0000FF00FFFF
FFFF00FFFF00000000FF00FFFF0000FF0000FFFFFFFFFFFFFFFF00000000FF0000FF00FF
FFFFFF00000000FF00FFFFFF00FF0000FFFF0000FFFF0000000000FFFFFFFF000000FF00
0000FFFFFFFF0000FFFF00FFFF00000000FF00FFFF0000FF0000FFFFFFFF00FFFF00FF00
00000000FFFFFFFFFFFFFFFF0000FF00FFFF000000FF00FF00FFFF00FFFFFFFF000000FF
00FF00FFFF00FF0000FF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00
FF00FFFF0000FF000000FFFFFF00FFFF0000FF000000FFFF0000FF00FFFFFFFFFFFFFF00
FFFF0000FF0000FF00FFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFFFFFFFF00FF000000
00FF0000FF00FFFF00FF0000FF00FFFFFF000000000000000000FFFF00FFFFFF00FF0000
0000FF00FFFF00FF000000FF00FF00FFFFFFFF0000FF00FFFF00FFFFFFFFFFFF00FFFFFF
00FFFFFFFFFFFF0000FF0000FF00FFFF00FF0000FF00FFFFFF00000000FF0000FF00FF00
FFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FFFF00FF00FF0000FF0000000000FFFF00FF
00FF0000FF00FF00FFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF00
00FFFFFFFF0000FFFF000000FF0000FF00FFFFFF00FFFFFFFF00FF00000000000000FF00
00FF00FFFFFF00FF000000000000000000000000FFFF0000FF0000000000FF0000FFFF00
FFFFFF00FF000000FFFFFF00FF00000000FFFF00FFFF00FFFF0000FF000000FF00FF00FF
FF00FF0000FF0000FFFF00FF0000FFFFFFFFFFFF00FF0000FF000000000000FF000000FF
000000000000FF00FFFFFF00FF000000FFFFFF00FF00000000FFFF00FFFFFF00FF00FF00
00FF00000000000000000000FF0000FFFF0000FF00FF00FF00FFFFFF00FFFF0000FF0000
FFFFFF00FF00FF000000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF
00000000FF00FFFFFFFF00FFFFFF00FF000000FF00000000FF0000FFFF00FFFF00FFFFFF
00FF00000000FFFFFF00FFFF00FFFF00FFFF00FFFFFFFF00FF00FFFF00FFFFFF0000FF00
0000FF0000FFFF000000FF00FF00FFFF0000FF000000FFFFFFFF0000FFFF00FF00FF0000
FF00FF00FFFFFF000000FFFFFF00000000000000FFFFFF0000FFFF00FFFF0000FFFF0000
FFFF00FFFF00FF000000FF0000FFFF000000FF00FF00FFFF0000FF000000FF0000FFFFFF
00FF00FFFF00FFFF00FFFF00FF00FFFFFFFF00FF00FF00FF000000FF0000FF00FFFFFF00
0000FF0000FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF
00FFFF00FF00000000FF000000FF0000FFFF0000FFFF00FFFFFF0000FF0000FF000000FF
00FF00FFFF000000FF0000FF0000FF0000FF00000000FF00FF0000FF000000FF00FFFFFF
00FFFFFF000000FFFF00FF00FF0000FF00FFFFFF00FFFFFFFFFFFF0000FF0000FFFFFF00
FF00FF00000000FFFF00000000FFFF00FFFF00FFFFFFFFFF0000FF0000FF00FFFFFFFF00
00FF000000FFFFFF00FFFFFF000000FFFF00FF00FF0000FF00FFFFFF00FFFFFF000000FF
00FF0000FF0000FF0000FF00FF00000000FF00FF0000FFFFFF00FFFFFF0000FFFFFFFFFF
00FFFFFF000000FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF
0000FF00FF00FFFF0000FFFF00FF00FFFFFFFF0000FF000000FF00FFFFFF0000FFFF00FF
0000FFFFFFFF00FFFFFF00FF00FFFFFF00FF00FFFF0000FFFFFF0000FFFF00FF000000FF
00000000FFFF0000FF0000FFFFFF00FF000000FF000000000000FF00FFFFFF000000FF00
FF00FF00FFFF0000FF00FFFF0000FF0000FF0000000000FF00FFFFFF0000FFFFFFFFFFFF
0000FFFF000000FF00000000FFFF0000FF0000FFFFFF00FF000000FF00000000FFFF0000
FFFFFF00FF00FFFFFF00FF00FF00FFFF0000FFFFFF00000000FFFFFFFFFF0000000000FF
00000000FFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFF
FF00FF0000FFFFFFFF0000FF0000FFFFFFFFFFFF0000FFFF0000FFFFFFFFFF000000FFFF
FF00000000FF000000FF00FF000000FF00FF0000FF00FFFFFFFFFF0000FF0000FFFF00FF
00FFFF0000FF00FFFFFF000000FF0000FFFF0000FFFF00FFFF00FF00000000FFFF00FF00
FF0000FFFFFFFF0000FFFFFFFF00FF00FFFFFF00FFFF00FF000000FF00FFFFFFFFFFFFFF
FF000000FFFF00FF00FFFF0000FF00FFFFFF000000FF0000FFFF0000FFFF00FFFFFFFF00
0000FF00FF000000FF00FF0000FFFFFFFF00000000FFFF00FFFFFFFFFFFFFF00FFFF0000
FFFF00FFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF000000
00FFFFFF00000000FF00FFFFFF000000000000FF00FFFFFFFF000000000000FFFF000000
FF00FFFF0000FFFF00FF0000FFFF0000FFFFFF00FF0000000000FF00FFFFFF0000FF0000
FFFFFFFF00FF00000000FFFF00FF00FFFFFFFF0000FF0000FF00FF00FFFF0000FF00FF00
FF00FFFFFFFFFFFF00000000FF00FF000000FF0000FF0000FFFF00FF0000000000000000
00FFFF0000FF0000FFFFFFFF00FF00000000FFFF00FF00FFFFFFFF0000FF0000000000FF
FF00FF0000FFFF0000FFFFFF00000000FF00FFFF0000FF0000000000000000FFFFFFFF00
0000FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF
000000FF00FFFF00FF00000000FFFF00FFFF00FF0000000000FFFF00FFFF000000FFFF00
00FFFFFFFF0000FF00FF00FFFFFFFF00000000FFFFFF00FFFF00FF000000FF00FFFFFF00
000000FF00FF00FFFF0000FF00FF00000000FF00FFFFFF00FF0000FFFFFFFF00FF00FF00
FF000000000000FF00FFFF00FF0000FFFF00FF00FFFFFF0000FF0000FFFF00FFFF00FFFF
0000FF00FFFFFF00000000FF00FF00FFFF0000FF00FF00000000FF00FFFFFF00FFFF0000
FF00FF00FFFFFFFF000000FF00FFFF00FF0000FF00FFFFFF00FFFF00FFFF0000000000FF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000
FFFF00FF0000FF00FF00FFFF0000FF000000FFFFFF00FFFF0000FF000000FFFF0000FF00
FFFFFFFFFFFF00FF00FF00000000FF00FFFF000000FF0000FF0000FFFF00FF000000FF00
FFFF00FF0000FFFFFFFF00FF00FF00FFFF00FF00000000FFFFFF00000000FF00FF00FF00
00FFFF00FFFF00FF000000FFFFFF0000FF00FF000000FF00FFFFFF0000FF000000FFFFFF
FF00FF000000FF00FFFF00FF0000FFFFFFFF00FF00FF00FFFF00FF00000000FFFFFFFF00
FF00FF0000000000FFFF00FF000000FFFFFF00FF000000FF000000FFFFFFFF00FFFF0000
00FFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF00
0000FFFFFF00FF0000FFFFFFFF0000FFFF000000FF0000FF00FFFFFF00FFFFFFFF00FF00
0000000000FF00FF00FF00FFFF00FF000000FFFF00FF00FFFFFF0000FF0000FFFF00FF00
0000FFFFFF00000000FF00FF00FF0000FF00FF00FFFF000000FF00FFFF00FF0000FFFFFF
0000FF000000FFFFFF00FFFFFFFFFF00FF0000FFFF0000FFFFFFFFFF0000FFFF00000000
FF0000FFFF00FF000000FFFFFF00000000FF00FF00FF0000FF00FF00FFFF00000000FF00
00FFFFFF00FFFF0000FF0000FFFF000000FF0000FFFF0000FFFF00000000FF000000FFFF
0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FF
FF00000000FFFFFF00000000FF00FFFFFFFF00FFFFFF00FF000000FF00000000FF0000FF
FF00FFFF00FF00FF00FF0000FF0000FFFF0000FF00FF000000FF00FFFFFF0000FF0000FF
FF000000FF00FFFF00FF0000FFFFFF00FF00FF000000FFFF00FF0000FF00FF00FFFFFFFF
FF0000FFFF000000FF000000000000FFFFFF0000FF00FFFFFFFFFFFFFF000000FFFF00FF
FFFF0000FF0000FFFF000000FF00FFFF00FF0000FFFFFF00FF00FF000000FFFF00FFFFFF
000000FF0000FF00FFFFFF000000FFFF00FF00FFFFFFFF0000FF00FFFF0000FFFF0000FF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000
FF00FFFF000000FF00FFFF00FF00000000FF000000FF0000FFFF0000FFFF00FFFFFF0000
FF0000FF00FF0000FFFFFF00FF00FFFFFFFF00FF0000FFFF00FF000000FF00FFFFFF0000
00FFFF00FF000000FFFFFF000000FF00FF0000FFFF000000FFFFFF00FF00FF0000000000
FF00FFFFFFFF00FFFFFF00FFFF00FFFFFFFFFF00FF0000000000000000FFFF0000FF0000
00FF00FFFFFF000000FFFF00FF000000FFFFFF000000FF00FF0000FFFF000000FFFFFFFF
FF00FFFFFF00FF00000000FFFF0000FF0000FFFFFFFFFFFF00FF0000FF00FFFFFFFF00FF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00
FF000000FFFF00FF0000FF00FF00FFFF0000FFFF00FF00FFFFFFFF0000FF000000FF00FF
FFFF0000FFFFFF000000FF00FF0000000000FFFFFF0000FF0000FFFF00FF00000000FFFF
0000FF0000FFFF00000000FFFF0000FFFFFF000000FFFF000000FF0000FFFFFF00FFFF00
FF00000000FF000000FF0000FF0000000000FF00FF00FFFF00FFFF00FFFFFFFF0000FFFF
00FF00000000FFFF0000FF0000FFFF00000000FFFF0000FFFFFF000000FFFF0000000000
FF000000FF00FF00FFFF0000FF00FFFFFF00000000000000FFFFFF00FF00000000FF0000
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF00
00FFFF000000FFFFFF00FF0000FFFFFFFF0000FF0000FFFFFFFFFFFF0000FFFF0000FFFF
FFFFFF00000000FFFF0000FFFFFF00FFFF000000FF00FFFFFF0000FF00FF00FFFF0000FF
00FFFFFF0000FF00FFFF0000FF00FFFFFFFFFF00FFFFFFFF00FFFFFF000000FF0000FF00
FF00FFFF0000FFFF00FF00FFFFFF00FFFF00FF00FF0000FF000000FFFFFFFFFFFF0000FF
00FF00FFFF0000FF00FFFFFF0000FF00FFFF0000FF00FFFFFFFFFF00FFFFFFFF00FFFF00
00FFFF00FF0000FFFFFFFF00FF000000FF00FFFF00FFFF000000FF0000FFFF00FFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF
000000FFFF00000000FFFFFF00000000FF00FFFFFF000000000000FF00FFFFFFFF000000
000000FFFF00FFFFFFFF000000FF000000FFFF0000FFFFFFFFFF00FF0000FFFFFFFF0000
FFFFFFFFFF0000FFFFFFFF00FF0000000000FF0000000000FFFFFFFFFF00FFFFFF00FF00
00FFFFFFFF0000FF00FF000000FF0000FF00FF00FF00FFFFFF00FFFFFFFFFFFFFFFF00FF
0000FFFFFFFF0000FFFFFFFFFF0000FFFFFFFF00FF0000000000FF0000000000FFFFFFFF
000000FFFFFF00000000FF0000FFFF00FF000000FFFFFFFF00FFFFFF000000FFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000
FFFF0000FF00FFFF000000FF00FFFF00FF00000000FFFF00FFFF00FF0000000000FFFF00
FFFF000000FFFFFFFFFFFF00FFFFFF00FFFFFFFF000000000000FFFFFF00000000FF00FF
FFFFFFFFFFFF00000000FF00FF00FFFF00FFFFFF00FFFF0000000000FF000000FF00FF00
FFFFFFFFFFFF0000FFFFFF00FFFFFF00FF00FF00FF000000FF000000000000000000FFFF
FF00000000FF00FFFFFFFFFFFFFF00000000FF00FF00FFFF00FFFFFF00FFFF0000000000
FFFF00000000FFFF00FFFFFF0000FF0000FFFF00000000FF00000000FFFF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FF
FFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FF000000FFFFFF00FFFF0000FF00
0000FFFF000000000000FF000000FF0000000000FFFF00FFFF000000FF00FFFF00FF0000
0000000000FF00FFFF00FF00FF0000FF00000000FFFFFFFF00FFFF0000FFFF00FF0000FF
FFFFFFFFFFFFFF000000FF000000FF00FF00FF0000FFFF0000FFFF00FFFF00FFFF000000
FF00FFFF00FF00000000000000FF00FFFF00FF00FF0000FF00000000FFFFFFFF00FFFF00
00FF00FFFF0000FF000000FF00FFFFFF0000FF00FFFF0000FFFF00FFFFFFFF00FFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF0000
0000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FFFF000000FF0000FF00FFFFFF
00FFFFFFFF00FFFF00FFFFFF00FFFFFF00FFFF0000FF000000FFFF00FF0000FF00FF00FF
FF00FFFF00FF0000FF0000FFFFFF00FF00FFFF0000000000FFFFFFFF000000FFFFFF0000
00000000000000FFFF0000FFFF00FF00FF00FF00FFFFFFFF0000FF0000FF000000FFFF00
FF0000FF00FF00FFFF00FFFF00FF0000FF0000FFFFFF00FF00FFFF0000000000FFFFFFFF
0000FFFFFFFF0000FFFF0000FFFFFFFFFF0000FFFFFFFF0000FF00000000FF000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFFFF00FFFFFF00FF000000FF
00000000FF0000FF000000FF00000000FFFFFFFF0000FFFF000000FFFFFF00FF00FF0000
FF0000FF00FF00FFFFFF000000FF00FF0000FF00FFFF00FFFFFFFFFFFF00FFFFFFFFFF00
FFFF00FFFF00FFFFFFFF0000FF00FF00FF00FF00000000FF00FFFFFF0000FFFF000000FF
FFFF00FF00FF0000FF0000FF00FF00FFFFFF000000FF00FF0000FF00FFFF00FFFFFFFFFF
FF00000000FF00FFFFFFFF0000000000FF00FFFFFFFFFFFF0000FFFF00FFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FF000000FF0000FFFF0000
FFFF00FFFFFF0000FFFF0000FFFF00FFFFFFFFFFFF000000FFFF000000FF00FF00FF00FF
FFFF00FF00FF00000000FFFF0000FFFFFF00FF0000FF000000000000FF0000000000FF00
00FF000000FFFFFFFFFFFF00FF00FF00FF00FF00FFFF0000FFFFFFFFFF000000FFFF0000
00FF00FF00FF00FFFFFF00FF00FF00000000FFFF0000FFFFFF00FF0000FF000000000000
FF00FFFF0000FFFFFFFFFFFF00FFFF0000FFFFFFFFFFFFFFFF0000FF00000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FFFF00FF00FFFFFFFF00
00FF000000FF00FFFFFFFF0000FF00000000000000FFFF000000FFFF00FF00FF00FF0000
00FF00FF0000FFFF00FFFFFFFF00000000FFFFFF0000FFFF00FFFF00FF00FFFF00FFFFFF
0000FFFF000000000000FF00FF00FF00FF0000FFFFFFFF000000000000FFFF000000FFFF
00FF00FF00FF000000FF00FF0000FFFF00FFFFFFFF00000000FFFFFF0000FFFF00FFFF00
00FFFFFFFF000000000000FF0000FF00FFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
00FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF0000FFFFFFFFFFFF
0000FFFF0000FFFFFFFFFFFF00FF00FFFF00FFFF000000FFFF0000FF00FF00FF0000FFFF
0000FFFFFF0000FF0000000000FFFF00FFFFFFFFFF0000FF0000FF00FF000000FFFFFFFF
FF000000FFFF00FFFF00FF00FF0000FFFFFF0000000000FFFF00FFFF000000FFFF0000FF
00FF00FF0000FFFF0000FFFFFF0000FF0000000000FFFF00FFFFFFFFFF0000FF0000FF00
FFFFFFFFFFFF00FFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFF000000000000FF
00FFFFFFFF000000000000FF00FF000000FFFFFFFF00FFFFFFFF00FF00FF00FF00FFFFFF
FF000000FF00FFFFFF00FFFF0000FF0000000000FF00FFFFFF00FF0000FFFF0000000000
00FFFF0000FF0000FF00FF00FF00FFFFFFFFFF00FFFF000000FFFFFFFF00FFFFFFFF00FF
00FF00FF00FFFFFFFF000000FF00FFFFFF00FFFF0000FF0000000000FF00FFFFFF00FF00
0000000000FF0000FF000000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FFFF00FFFF00FF
0000000000FFFF00FFFF00FF0000FFFF00000000FF00000000FF00FF00FF00FF00000000
00FFFF00FF000000FF0000FF00FFFFFF00FFFF00FF00000000FFFFFF000000FFFF00FFFF
0000FF00FFFFFF00FF00FF00FF0000000000FF000000FFFF00000000FF00000000FF00FF
00FF00FF0000000000FFFF00FF000000FF0000FF00FFFFFF00FFFF00FF00000000FFFFFF
00FFFF00FFFFFF0000FFFF00FF000000000000000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FF000000FFFF
FF00FFFF0000FF000000FFFFFF0000FF00FFFF00FF00FFFF00FF00FF0000FFFFFF00FFFF
000000FFFFFF00FFFFFF00FF000000FF0000FF00FF00FFFF00000000FFFF000000FFFFFF
FF00FF000000FF00FF0000FFFFFF00FFFF0000FFFF0000FF00FFFF00FF00FFFF00FF00FF
0000FFFFFF00FFFF000000FFFFFF00FFFFFF00FF000000FF0000FF00FF00FFFF000000FF
000000FFFFFFFFFF000000FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FFFF000000
FF0000FF00FFFFFF00FFFFFFFFFF00FF0000FF00FF0000FF0000FFFFFF000000FF000000
FFFF000000FF00000000FFFFFF00FFFFFF00FF00FF0000FF00FFFF000000FFFF00000000
FF0000FFFF0000FFFFFF000000FF0000FF00FFFFFFFF00FF0000FF00FF0000FF0000FFFF
FF000000FF000000FFFF000000FF00000000FFFFFF00FFFFFF00FF00FF000000FFFF0000
FFFF000000000000FFFF000000FF0000FF0000FF0000FF000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFFFF00FF
FFFF00FF000000FF000000000000FFFFFF00FF00FF00FFFFFF00000000FFFF0000FFFF00
0000FFFF00FF00FFFF000000FF000000FF0000FFFFFF00FF000000FFFF000000FFFF00FF
FFFF0000FF00FFFFFFFFFF00FFFFFF00FF0000000000FFFFFF00FF00FF00FFFFFF000000
00FFFF0000FFFF000000FFFF00FF00FFFF000000FF000000FF0000FFFFFF00FFFFFFFF00
0000FFFF00FFFF000000FFFF00FF00FFFFFF00FF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FF0000
00FF0000FFFF0000FFFF00FFFF000000FF00FF00FF00000000FFFF00FFFFFFFF000000FF
FF0000FF0000FFFFFFFF00FFFFFF00FFFFFF000000FF0000FFFF000000FFFF000000FFFF
FFFFFF00FF0000000000FF00000000FFFFFF00FFFF000000FF00FF00FF00000000FFFF00
FFFFFFFF000000FFFF0000FF0000FFFFFFFF00FFFFFF00FFFFFF000000FF0000000000FF
FF0000FF000000FFFF0000FF00FF000000FF00FF00000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FFFF
00FF00FFFFFFFF0000FF000000FFFF00FF00FF00FF00FFFF0000FF0000000000FFFF0000
FF00FFFFFF00000000FF00000000FFFFFFFFFF00FFFFFF000000FFFF000000FFFF000000
000000FFFFFF00FFFF00FF00FFFF000000FF000000FFFF00FF00FF00FF00FFFF0000FF00
00000000FFFF0000FF00FFFFFF00000000FF00000000FFFFFFFFFF00FFFFFF00FFFF0000
FF00FFFFFF00FFFFFFFF00FF0000FFFF00FF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF
0000FFFFFFFFFFFF0000FFFF0000FF00FF00FF0000FFFFFFFF00FF00FFFF00FFFFFFFF00
FF000000FF00FFFF00FF00FFFF0000000000FF00000000FFFF000000FFFF000000FFFF00
FFFF000000FF0000FF00FF000000FFFF0000FFFF0000FF00FF00FF0000FFFFFFFF00FF00
FFFF00FFFFFFFF00FF000000FF00FFFF00FF00FFFF0000000000FF00000000FFFFFFFF00
FF000000FF0000000000FFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFF
FF000000000000FF00FFFFFFFF00FF0000FFFFFF00000000FF00FF0000FF00000000FF00
00FFFF00FF0000FF0000FFFFFFFF00FFFF00FF00FFFF000000FFFF000000FFFF000000FF
FFFFFF00FFFFFF00FF0000FFFF0000FF00FFFFFFFF00FF0000FFFFFF00000000FF00FF00
00FF00000000FF0000FFFF00FF0000FF0000FFFFFFFF00FFFF00FF00FFFF00000000FF00
00FFFF00FF00FFFF00FFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF000000
00FFFF00FFFF00FF0000000000FFFFFF000000FF00FFFF0000FFFFFF0000FFFF00FFFFFF
0000FF00FF00FFFFFF00000000FF0000FF00FF000000FFFF000000FFFF000000FFFF0000
0000FF000000FF00FF00FFFFFFFF00FF0000000000FFFFFF000000FF00FFFF0000FFFFFF
0000FFFF00FFFFFF0000FF00FF00FFFFFF00000000FF0000FF00FF000000FFFF00FFFFFF
0000FF00FF0000FF0000000000FF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF
0000FF000000FFFFFF00FFFF00000000FFFF00FF0000FF00FFFFFFFFFF000000FFFFFFFF
FF00FF00FF00000000FFFF00FFFFFF00FF0000FFFF000000FFFF000000FFFF0000FF00FF
FF0000FFFF00FF00FF0000000000FFFFFF00FFFF00000000FFFF00FF0000FF00FFFFFFFF
FF000000FFFFFFFFFF00FF00FF00000000FFFF00FFFFFF00FF0000FFFF000000FFFFFFFF
FF0000FFFFFF00FF00FFFF00FFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFF
FF0000FFFF000000FF0000FF00FFFF000000FFFFFF00FF000000000000FFFF0000000000
FF00FF00FF00FFFF0000FF000000FF00FF00FFFFFFFF00FFFFFFFF00FFFFFFFF0000FFFF
FFFF0000FF0000FFFFFF00FFFF000000FF0000FF00FFFF000000FFFFFF00FF0000000000
00FFFF0000000000FF00FF00FF00FFFF0000FF000000FF00FF00FFFFFFFF00FFFFFFFFFF
FFFF000000FF00FF0000FF000000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000
FF00FFFFFFFF00FFFFFF00FF000000FFFF00000000FFFFFF00FFFF00FFFFFFFF00FFFF00
FF00FF0000FFFFFFFF0000FFFF00FF00FF00000000FF0000000000FFFFFFFFFFFF000000
00FF00FFFFFF00000000FFFFFFFF00FFFFFF00FF000000FFFF00000000FFFFFF00FFFF00
FFFFFFFF00FFFF00FF00FF0000FFFFFFFF0000FFFF00FF00FF00000000FF000000000000
0000FFFF00FF00FF00FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00
FF00000000FF000000FF0000FFFF0000FF00FFFF000000FF0000FF00000000FF0000FF00
FF00FF00FFFFFFFFFFFF0000FF00FF0000FFFF00FFFFFF00FFFF000000000000FF00FFFF
00FF000000FF00FFFF00000000FF000000FF0000FFFF0000FF00FFFF000000FF0000FF00
000000FF0000FF00FF00FF00FFFFFFFFFFFF0000FF00FF0000FFFF00FFFFFF00FFFF00FF
FF0000FF00FF00FF000000FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00
FF00FFFF0000FFFF00FF00FFFFFFFF0000FFFFFFFF00FFFFFF0000FFFF00FFFFFF00FF00
FF0000FFFFFFFFFFFFFFFF0000FFFFFF0000FF000000FF000000FFFF00FFFF00FF0000FF
0000FFFF00FF0000FF00FFFF0000FFFF00FF00FFFFFFFF0000FFFFFFFF00FFFFFF0000FF
FF00FFFFFF00FF00FF0000FFFFFFFFFFFFFFFF0000FFFFFF0000FF000000FF000000FFFF
FFFF00FF00FF0000FFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF00
00FFFFFFFF0000FF0000FFFFFFFFFFFF0000000000FFFFFFFFFF0000FF000000FF0000FF
FFFF0000000000000000FF00FFFFFFFFFF0000FFFF0000FFFF0000FF0000FF00FF00FFFF
FF000000FFFFFF0000FFFFFFFF0000FF0000FFFFFFFFFFFF0000000000FFFFFFFFFF0000
FF000000FF0000FFFFFF0000000000000000FF00FFFFFFFFFF0000FFFF0000FFFF000000
00FF00FF00FF00FFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF
00000000FF00FFFFFF000000000000FF00FFFF00FFFFFFFFFFFFFF0000FFFF00FF00FFFF
FFFFFF00FFFF00FFFF00FF0000000000FF00FFFFFFFF0000FF00FFFFFF00FF0000FFFFFF
FFFF00FFFFFFFFFF00000000FF00FFFFFF000000000000FF00FFFF00FFFFFFFFFFFFFF00
00FFFF00FF00FFFFFFFFFF00FFFF00FFFF00FF0000000000FF00FFFFFFFF0000FF00FFFF
00FF00FF0000FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF
00FFFF00FF00000000FFFF00FFFF00FF000000FFFFFFFFFFFFFFFFFF0000FF00FF000000
0000FF0000FF000000FFFFFF00FFFF0000FFFFFFFFFFFF00FF00000000FFFFFF00000000
00FF0000000000FF00FFFF00FF00000000FFFF00FFFF00FF000000FFFFFFFFFFFFFFFFFF
0000FF00FF0000000000FF0000FF000000FFFFFF00FFFF0000FFFFFFFFFFFF00FF0000FF
0000FFFFFF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF
0000FF00FF00FFFF0000FF000000FFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FF00FFFF
00FFFFFF0000FFFF00000000FFFFFFFF000000000000FF00FF00FFFF000000FF00FFFF00
FFFFFF00FFFF00FF0000FF00FF00FFFF0000FF000000FFFFFF00FFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FFFF00FFFFFF0000FFFF00000000FFFFFFFF000000000000FF00FF00FFFF
FF00000000FFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFF
FF00FF0000FFFFFFFF0000FFFF000000FF0000000000000000000000FF00FF00FF000000
FFFFFFFFFF0000FF00FFFF0000000000FFFF00FFFF00FF00FF000000FFFF00FF0000FF00
0000FF000000FFFFFF00FF0000FFFFFFFF0000FFFF000000FF0000000000000000000000
FF00FF00FF000000FFFFFFFFFF0000FF00FFFF0000000000FFFF00FFFF00FF00FF000000
FF00FFFF0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF000000
00FFFFFF00000000FF00FFFFFFFF00FFFFFF00FFFF00FFFF00FFFF00FF0000FFFFFF00FF
FFFFFFFFFFFF0000FFFFFFFF00FFFF0000FF0000FF00FF0000FFFF000000FFFFFF0000FF
FF0000FFFF00000000FFFFFF00000000FF00FFFFFFFF00FFFFFF00FFFF00FFFF00FFFF00
FF0000FFFFFF00FFFFFFFFFFFFFF0000FFFFFFFF00FFFF0000FF0000FF00FF0000FFFF00
FF0000FF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF
000000FF00FFFF00FF00000000FF000000FF0000FF0000FF000000FFFFFF00000000FFFF
FFFFFFFFFFFFFF00000000FF0000FF00FFFFFF0000FFFFFF000000FFFF000000FF00FFFF
FFFF0000FF00FFFF000000FF00FFFF00FF00000000FF000000FF0000FF0000FF000000FF
FFFF00000000FFFFFFFFFFFFFFFFFF00000000FF0000FF00FFFFFF0000FFFFFF000000FF
FFFF00FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000
FFFF00FF0000FF00FF00FFFF0000FFFF00FF00FFFFFF0000FFFF000000FF00FFFF000000
00000000000000FFFF00FFFFFF0000FFFFFFFFFF00000000FFFF000000FFFF0000FFFFFF
FFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FFFF00FF00FFFFFF0000FFFF0000
00FF00FFFF00000000000000000000FFFF00FFFFFF0000FFFFFFFFFF00000000FFFF0000
00FF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF00
0000FFFFFF00FF0000FFFFFFFF0000FF0000FFFFFFFFFF000000FFFF00FF0000FF00FFFF
00FFFF00FFFF000000FFFFFFFFFF000000000000FFFF00FFFFFFFF00FFFFFFFF00000000
0000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF0000FFFFFFFFFF000000FFFF
00FF0000FF00FFFF00FFFF00FFFF000000FFFFFFFFFF000000000000FFFF00FFFFFFFF00
FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FF
FF00000000FFFFFF00000000FF00FFFFFF000000000000FFFF000000FFFFFF00FF0000FF
0000FF000000FFFF000000000000FFFF00FFFF0000FF0000000000FFFFFFFFFFFF00FFFF
00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFF000000000000FFFF000000
FFFFFF00FF0000FF0000FF000000FFFF000000000000FFFF00FFFF0000FF0000000000FF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000
FF00FFFF000000FF00FFFF00FF00000000FFFF00FFFF000000FFFF000000FF00FF00FFFF
FF0000FFFF000000FFFF00FFFF0000FF0000FF00FFFFFF00FFFF000000000000FF0000FF
00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FFFF00FFFF000000FFFF00
0000FF00FF00FFFFFF0000FFFF000000FFFF00FFFF0000FF0000FF00FFFFFF00FFFF0000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00
FF000000FFFF00FF0000FF00FF00FFFF0000FF000000FFFF000000FFFF00FF0000FFFFFF
FFFF000000FFFF0000FF0000FF00FFFFFF00FF00000000FFFFFFFF00FFFF00FFFFFF0000
FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FF000000FFFF000000FF
FF00FF0000FFFFFFFFFF000000FFFF0000FF0000FF00FFFFFF00FF00000000FFFFFFFF00
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF00
00FFFF000000FFFFFF00FF0000FFFFFFFF0000FFFF000000FFFF000000FFFFFF00000000
0000FFFF0000FF00FFFFFF00FF000000FF00FF00FFFF00000000FF000000FFFFFFFFFF00
00FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FFFF000000FFFF0000
00FFFFFF000000000000FFFF0000FF00FFFFFF00FF000000FF00FF00FFFF00000000FF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF
000000FFFF00000000FFFFFF00000000FF00FFFFFFFF00FFFFFFFF00FFFFFFFFFF00FFFF
00FFFFFFFF00FF000000FF0000FFFF00FF00FF000000FFFF00FFFFFF00FFFFFFFFFFFFFF
0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFFFF00FFFFFFFF00
FFFFFFFFFF00FFFF00FFFFFFFF00FF000000FF0000FFFF00FF00FF000000FFFF00FFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000
FFFF0000FF00FFFF000000FF00FFFF00FF00000000FF00000000FF0000000000FF0000FF
0000000000FFFFFF00FFFFFF0000FF00FF0000FFFF0000FF00000000FFFFFFFFFFFFFFFF
FF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FF00000000FF00
00000000FF0000FF0000000000FFFFFF00FFFFFF0000FF00FF0000FFFF0000FF00000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FF
FFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FFFF00FFFFFF00FFFF00FF00FFFF
FF00FFFF00000000FFFFFFFFFF00FF00FF00FFFFFFFF0000FFFF00FFFFFFFFFFFFFFFFFF
FFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000FFFF00FFFFFF
00FFFF00FF00FFFFFF00FFFF00000000FFFFFFFFFF00FF00FF00FFFFFFFF0000FFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF0000
0000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF000000FF0000FF00FF000000
FF0000FF00FFFF0000000000FF00FF0000FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFF
FFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF000000FF
0000FF00FF000000FF0000FF00FFFF0000000000FF00FF0000FFFFFFFFFFFF000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFF00FFFFFF0000FFFFFF00FF
FFFF0000FFFFFFFF00FFFF00FF00FF00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF00FFFFFF00FFFF
FF0000FFFFFF00FFFFFF0000FFFFFFFF00FFFF00FF00FF00FFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FFFFFFFFFF00000000FFFF
FFFFFF00000000FF0000FF00FF00FF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FFFFFF
FFFF00000000FFFFFFFFFF00000000FF0000FF00FF00FF000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF0000000000FF00FFFF000000
000000FFFF00FFFFFF00FF0000FFFFFF00FFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00FFFF00000000
00FF00FFFF000000000000FFFF00FFFFFF00FF0000FFFFFF00FFFF00FFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
00FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF00FFFF00FF000000FFFF00
FFFF0000FF00000000FFFFFF000000FF0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF00FFFF
00FF000000FFFF00FFFF0000FF00000000FFFFFF000000FF0000FF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF0000FF0000FFFF000000FF
FFFFFF00FF00FFFF00000000FFFF00FF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF00000000FF0000FF
0000FFFF000000FFFFFFFF00FF00FFFF00000000FFFF00FF00FFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00FFFFFF000000FFFF0000
0000FF00FF0000FF00FFFF0000FF00FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00FFFF
FF000000FFFF00000000FF00FF0000FF00FFFF0000FF00FF00000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF00000000FFFF0000FF00FF
FF0000FFFFFF0000FFFFFFFF00FF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF0000FF00FF000000
00FFFF0000FF00FFFF0000FFFFFF0000FFFFFFFF00FF0000FFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFF00FFFFFFFF00FF0000
FF00FFFFFFFFFF0000000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFF00
FFFFFFFF00FF0000FF00FFFFFFFFFF0000000000FFFFFF000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF0000FF0000000000FFFFFF00
FF0000000000FF00FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF0000FF00
00000000FFFFFF00FF0000000000FF00FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFFFF00FFFF00000000FF
FFFF00FFFF00FF0000FF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFFFF
00FFFF00000000FFFFFF00FFFF00FF0000FF000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF000000FF0000FF00FFFF0000
00FF0000FF00FF00FFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF000000FF
0000FF00FFFF000000FF0000FF00FF00FFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FFFFFF0000FFFFFFFF00
FFFFFF00FF00FF000000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FFFF
FF0000FFFFFFFF00FFFFFF00FF00FF000000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFFFFFF00000000FF00
0000FF0000FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FFFFFF
FFFF00000000FF000000FF0000FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000000000FFFF00FFFFFF
00FFFFFF000000FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF00000000
0000FFFF00FFFFFF00FFFFFF000000FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FFFF0000FF000000FF
00000000FFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFF00FF
FF0000FF000000FF00000000FFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFFFF0000FFFF0000
FFFF00FFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFF
FFFF0000FFFF0000FFFF00FFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FF00FFFFFFFF00
0000FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF000000
00FF00FFFFFFFF000000FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF00FF0000000000FF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF
00FF0000000000FFFF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFFFF00FFFF0000
00FFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000
FFFFFF00FFFF000000FFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FF000000FFFF
0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF00
0000FF000000FFFF0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF0000FFFF0000FF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FF
FF0000FFFF0000FF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFFFFFF00FF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000
FF00FFFFFFFF00FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF00000000FF0000
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00
FF00000000FF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF00FFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF00
00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF
000000FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000
FFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FF
FFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF0000
0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["k", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["2", "MR"],
              ", ",
              StyleBox["r", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["1", "MR"],
              ", elementary rule "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "general nearest\[Hyphen]neighbor rule with ",
              StyleBox["k", "TI"],
              " colors "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["r", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "general rule with ",
              StyleBox["k", "TI"],
              " colors and range ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["r",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["1}}", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["k", "TI"],
              "\[Hyphen]color nearest\[Hyphen]neighbor totalistic rule "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["1},", "MR"],
              " ",
              StyleBox["r", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["k", "TI"],
              "\[Hyphen]color range ",
              StyleBox["r", "TI"],
              " totalistic rule "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["wt",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["wt",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}},", "MR"],
              " ",
              StyleBox["r", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "rule in which neighbor ",
              StyleBox["i", "TI"],
              " is assigned weight ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["wt",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["kspec", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["off",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["off",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["off",
                        "TI"], 
                      StyleBox["s",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}}}",
              StyleBox[" ", "TR"]
            }]], Cell["rule with neighbors at specified offsets "]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["fun", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{},", "MR"],
              " ",
              StyleBox["rspec", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "rule obtained by applying function ",
              StyleBox["fun", "TI"],
              " to each neighbor list "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.6"],

Cell["\<\
Specifying rules for one\[Hyphen]dimensional cellular automata. \
\
\>", "Caption",
  CellTags->"S3.8.6"],

Cell[TextData[{
  "In the simplest cases, a cellular automaton allows ",
  StyleBox["k", "TI"],
  " possible values or \[OpenCurlyDoubleQuote]colors\[CloseCurlyDoubleQuote] \
for each cell, and has rules that involve up to ",
  StyleBox["r", "TI"],
  " neighbors on each side. The digits of the \[OpenCurlyDoubleQuote]rule \
number\[CloseCurlyDoubleQuote] ",
  StyleBox["n", "TI"],
  " then specify what the color of a new cell should be for each possible \
configuration of the neighborhood.  "
}], "Text",
  CellTags->{"S3.8.6", "6.12"}],

Cell["This evolves a single neighborhood for 1 step. ", "MathCaption",
  CellTags->{"S3.8.6", "6.13"}],

Cell[CellGroupData[{

Cell["CellularAutomaton[30, {1,1,0}, 1]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.8.6"],

Cell[BoxData[
    \({{1, 1, 0}, {1, 0, 0}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[TextData[{
  "Here are the 8 possible neighborhoods for a ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k",
            "TI"], "=", "2"}], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  " cellular automaton. "
}], "MathCaption",
  CellTags->{"S3.8.6", "6.14"}],

Cell[CellGroupData[{

Cell["Table[IntegerDigits[i,2,3],{i,7,0,-1}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.8.6"],

Cell[BoxData[
    \({{1, 1, 1}, {1, 1, 0}, {1, 0, 1}, {1, 0, 0}, {0, 1, 1}, {0, 1, 0}, {0, 
        0, 1}, {0, 0, 0}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell["\<\
This shows the new color of the center cell for each of the 8 \
neighborhoods. \
\>", "MathCaption",
  CellTags->{"S3.8.6", "6.15"}],

Cell[CellGroupData[{

Cell["Map[CellularAutomaton[30, #, 1][[2,2]]&, %]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.8.6"],

Cell[BoxData[
    \({0, 0, 0, 1, 1, 1, 1, 0}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell["\<\
For rule 30, this sequence corresponds to the base\[Hyphen]2 digits \
of the number 30. \
\>", "MathCaption",
  CellTags->{"S3.8.6", "6.16"}],

Cell[CellGroupData[{

Cell["FromDigits[%, 2]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.8.6"],

Cell[BoxData[
    \(30\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[TextData[{
  "This runs the general ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k",
            "TI"], "=", "3"}], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  " rule with rule number 921408. "
}], "MathCaption",
  CellTags->{"S3.8.6", "6.17"}],

Cell[CellGroupData[{

Cell["ArrayPlot[CellularAutomaton[{921408, 3, 1}, {{1}, 0}, 100]]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .66887 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00630716 0.0159256 0.00630716 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .66887 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .66887 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .66887 L
s
0 .66887 m
1 .66887 L
s
1 0 m
1 .66887 L
s
0 0 m
1 0 L
1 .66887 L
0 .66887 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01593 translate
.95238 .63702 scale
151 string
151 101 8 [151 0 0 101 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
80FF0080FF8080FFFFFF008080FF0080FF80FF008080FFFF80FFFFFFFFFFFFFFFFFFFFFF
80FF0080FF8080FFFFFF008080FF0080FF80FF00FFFFFF00FFFF0000FFFFFFFFFFFFFFFF
00008080FFFFFFFFFFFF008080FF0080FF80FF008080FFFF80FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
80FF0080FF8080
0080FF008080FFFFFFFFFF80FFFFFF80FF80FF8080FFFFFF008000FFFFFF00FFFFFFFFFF
0080FF008080FFFFFFFFFF80FFFFFF80FF80FF80800080FF00FFFF800000FFFFFF00FFFF
FF8080FFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFFFF008000FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00008080008000FFFFFF00FFFFFFFFFF
0080FF008080FF
FF80FF8080FFFFFFFFFFFF00800080FFFF008080FFFFFFFFFF80FF00FFFF0000FFFFFFFF
FF80FF8080FFFFFFFFFFFF00800080FFFF008080FFFF80FF800080FFFF800080FF808000
8080FFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFFFFFF80FF00FFFF0000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF8080FFFF80FF00FFFF0000FFFFFFFF
FF80FF8080FFFF
FF008080FFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFFFF0080FF00FFFF800000FFFF
FF008080FFFFFFFFFFFFFFFF80FF0080FF8080FFFFFF008080FF0080FF80FF008080FFFF
80FFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFFFF0080FF00FFFF800000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00008080FFFFFF0080FF00FFFF800000FFFF
FF008080FFFFFF
FFFF80FFFFFFFFFFFFFFFFFF0080FF008080FFFFFFFFFFFFFFFF80FF800080FFFF800080
FF8080FFFFFFFFFFFFFFFFFF0080FF008080FFFFFFFFFF80FFFFFF80FF80FF8080FFFFFF
008000FFFFFF00FFFFFFFFFF0080FF008080FFFFFFFFFFFFFFFF80FF800080FFFF8000FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF8080FFFFFFFFFF80FF800080FFFF800080
FF8080FFFFFFFF
FFFF008000FFFFFF00FFFFFFFF80FF8080FFFFFFFFFFFFFFFFFF008080FF0080FF80FF00
8080FFFFFFFFFFFFFFFFFFFFFF80FF8080FFFFFFFFFFFF00800080FFFF008080FFFFFFFF
FF80FF00FFFF0000FFFFFFFFFF80FF8080FFFFFFFFFFFFFFFFFF008080FF0080FF80FF00
FFFFFF00FFFF0000FFFFFFFFFFFFFFFF00008080FFFFFFFFFFFF008080FF0080FF80FF00
8080FFFFFFFFFF
FFFFFF80FF00FFFF0000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFF80FFFFFF80FF80FF80
80FFFFFFFFFFFFFFFFFFFFFFFF008080FFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFF
FF0080FF00FFFF800000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFF80FFFFFF80FF80FF80
800080FF00FFFF800000FFFFFF00FFFFFF8080FFFFFFFFFFFFFFFF80FFFFFF80FF80FF80
80FFFFFFFFFFFF
FFFFFF0080FF00FFFF800000FFFF80FFFFFFFFFFFFFFFFFFFFFFFF00800080FFFF008080
FFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFFFFFFFFFFFFFF0080FF008080FFFFFFFFFFFF
FFFF80FF800080FFFF800080FF8080FFFFFFFFFFFFFFFFFFFFFFFF00800080FFFF008080
FFFF80FF800080FFFF800080FF8080008080FFFFFFFFFFFFFFFFFF00800080FFFF008080
FFFFFFFFFFFFFF
FFFFFFFF80FF800080FFFF800080FFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF008000FFFFFF00FFFFFFFF80FF8080FFFFFFFFFFFFFF
FFFF008080FF0080FF80FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FF
FFFF008080FF0080FF80FF008080FFFF80FFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FF
FFFFFFFFFFFFFF
FFFFFFFF008080FF0080FF80FF008080008000FFFFFF00FFFFFFFFFF0080FF008080FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FFFF0000FFFFFF008080FFFFFFFFFFFFFFFF
FFFFFF80FFFFFF80FF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080FF008080FFFF
FFFFFF80FFFFFF80FF80FF8080FFFFFF008000FFFFFF00FFFFFFFFFF0080FF008080FFFF
FFFFFFFFFFFFFF
FFFFFFFFFF80FFFFFF80FF80FF8080FFFF80FF00FFFF0000FFFFFFFFFF80FF8080FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080FF00FFFF800000FFFF80FFFFFFFFFFFFFFFFFF
FFFFFF00800080FFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF8080FFFFFF
FFFFFF00800080FFFF008080FFFFFFFFFF80FF00FFFF0000FFFFFFFFFF80FF8080FFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFF00800080FFFF008080FFFFFF0080FF00FFFF800000FFFFFF008080FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF800080FFFF800080FFFFFFFFFFFFFFFFFFFF
FFFFFFFF80FF0080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008080FFFFFFFF
FFFFFFFF80FF0080FF8080FFFFFFFFFFFF0080FF00FFFF800000FFFFFF008080FFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFF80FF0080FF8080FFFFFFFFFF80FF800080FFFF800080FF8080FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008080FF0080FF80FF008080008000FFFFFF00FF
FFFFFFFF0080FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFFFFFF
FFFFFFFF0080FF008080FFFFFFFFFFFFFFFF80FF800080FFFF800080FF8080FFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFF0080FF008080FFFFFFFFFFFF008080FF0080FF80FF008080FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFF80FF00FFFF0000
FFFFFFFFFF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008000FFFFFF
00FFFFFFFF80FF8080FFFFFFFFFFFFFFFFFF008080FF0080FF80FF008080FFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFF80FF8080FFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFF0080FF00FFFF80
0000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FFFF
0000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFF008080FFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFF80FF800080FF
FF800080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080FF00FF
FF800000FFFF80FFFFFFFFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF80FFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080FF008080FFFFFFFFFFFF008080FF0080
FF80FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF8000
80FFFF800080FFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF008000FFFFFF00FFFFFFFFFF0080FF008080FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF8080FFFFFFFFFFFFFFFF80FFFFFF80
FF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008080FF
0080FF80FF008080008000FFFFFF00FFFFFFFFFF0080FF008080FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF80FF00FFFF0000FFFFFFFFFF80FF8080FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008080FFFFFFFFFFFFFFFFFF00800080FF
FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFF
FF80FF80FF8080FFFF80FF00FFFF0000FFFFFFFFFF80FF8080FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0080FF00FFFF800000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFFFFFFFFFFFFFFFFFF80FF0080
FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008000
80FFFF008080FFFFFF0080FF00FFFF800000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF80FF800080FFFF800080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008000FFFFFF00FFFFFFFFFF0080FF00
8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF
0080FF8080FFFFFFFFFF80FF800080FFFF800080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF008080FF0080FF80FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FFFF0000FFFFFFFFFF80FF80
80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080
FF008080FFFFFFFFFFFF008080FF0080FF80FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080FF00FFFF800000FFFFFF008080
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80
FF8080FFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF800080FFFF800080FF8080FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
8080FFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008080FF0080FF80FF008080FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
80FFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0080FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
008000FFFFFF00FFFFFFFFFF0080FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF80FF00FFFF0000FFFFFFFFFF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0080FF00FFFF800000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF0080FF008080FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF80FF800080FFFF800080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF008000FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00008080008000FFFFFF00FFFFFFFF80FF8080FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF008080FF0080FF80FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FFFF8080FFFF80FF00FFFF0000FFFFFF008080FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF80FFFFFF80FF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080FF00FFFF800000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00008080FFFFFF0080FF00FFFF800000FFFF80FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00800080FFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF800080FFFF8000FFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FFFF8080FFFFFFFFFF80FF800080FFFF800080FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF80FF0080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008080FF0080FF80FF00FFFFFF00FFFF0000FFFF
FFFFFFFFFFFF00008080FFFFFFFFFFFF008080FF0080FF80FF008080008000FFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00008080008000FFFFFF00FF
FFFFFFFF0080FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFF80FF80FF80800080FF00FFFF800000
FFFFFF00FFFFFF8080FFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFF80FF00FFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF8080FFFF80FF00FFFF0000
FFFFFFFFFF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00800080FFFF008080FFFF80FF800080FFFF80
0080FF8080008080FFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFF0080FF00FFFF80
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00008080FFFFFF0080FF00FFFF80
0000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFF008080FF0080FF80
FF008080FFFF80FFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFF80FF800080FF
FF8000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF8080FFFFFFFFFF80FF800080FF
FF800080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080FF008080FFFFFFFFFF80FFFFFF80FF80
FF8080FFFFFF008000FFFFFF00FFFFFFFFFF0080FF008080FFFFFFFFFFFF008080FF0080
FF80FF00FFFFFF00FFFF0000FFFFFFFFFFFFFFFF00008080FFFFFFFFFFFF008080FF0080
FF80FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF8080FFFFFFFFFFFF00800080FFFF00
8080FFFFFFFFFF80FF00FFFF0000FFFFFFFFFF80FF8080FFFFFFFFFFFFFFFF80FFFFFF80
FF80FF80800080FF00FFFF800000FFFFFF00FFFFFF8080FFFFFFFFFFFFFFFF80FFFFFF80
FF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008080FFFFFFFFFFFFFFFF80FF0080FF80
80FFFFFFFFFFFF0080FF00FFFF800000FFFFFF008080FFFFFFFFFFFFFFFFFF00800080FF
FF008080FFFF80FF800080FFFF800080FF8080008080FFFFFFFFFFFFFFFFFF00800080FF
FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFFFFFFFFFFFFFF0080FF008080
FFFFFFFFFFFFFFFF80FF800080FFFF800080FF8080FFFFFFFFFFFFFFFFFFFFFF80FF0080
FF8080FFFFFF008080FF0080FF80FF008080FFFF80FFFFFFFFFFFFFFFFFFFFFF80FF0080
FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008000FFFFFF00FFFFFFFF80FF8080FF
FFFFFFFFFFFFFFFF008080FF0080FF80FF008080FFFFFFFFFFFFFFFFFFFFFFFF0080FF00
8080FFFFFFFFFF80FFFFFF80FF80FF8080FFFFFF008000FFFFFF00FFFFFFFFFF0080FF00
8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FFFF0000FFFFFF008080FFFF
FFFFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF80
80FFFFFFFFFFFF00800080FFFF008080FFFFFFFFFF80FF00FFFF0000FFFFFFFFFF80FF80
80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080FF00FFFF800000FFFF80FFFFFF
FFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008080
FFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFFFF0080FF00FFFF800000FFFFFF008080
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF800080FFFF800080FFFFFFFF
FFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF
FFFFFFFFFFFFFFFF0080FF008080FFFFFFFFFFFFFFFF80FF800080FFFF800080FF8080FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008080FF0080FF80FF0080800080
00FFFFFF00FFFFFFFFFF0080FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080
00FFFFFF00FFFFFFFF80FF8080FFFFFFFFFFFFFFFFFF008080FF0080FF80FF008080FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFF80
FF00FFFF0000FFFFFFFFFF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80
FF00FFFF0000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFF00
80FF00FFFF800000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
80FF00FFFF800000FFFF80FFFFFFFFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFF
80FF800080FFFF800080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
80FF800080FFFF800080FFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080FF008080FFFFFFFFFFFF
008080FF0080FF80FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
008080FF0080FF80FF008080008000FFFFFF00FFFFFFFFFF0080FF008080FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF8080FFFFFFFFFFFFFF
FF80FFFFFF80FF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF80FFFFFF80FF80FF8080FFFF80FF00FFFF0000FFFFFFFFFF80FF8080FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008080FFFFFFFFFFFFFFFF
FF00800080FFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00800080FFFF008080FFFFFF0080FF00FFFF800000FFFFFF008080FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFFFFFFFFFFFFFF
FFFF80FF0080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF80FF0080FF8080FFFFFFFFFF80FF800080FFFF800080FF8080FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008000FFFFFF00FFFFFF
FFFF0080FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0080FF008080FFFFFFFFFFFF008080FF0080FF80FF008080FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FFFF0000FFFF
FFFFFF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF80FF8080FFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080FF00FFFF800000
FFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF008080FFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF800080FFFF80
0080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF80FFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008080FF0080FF80
FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF008000FFFFFF00FFFFFFFFFF0080FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFF80FF80
FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF80FF00FFFF0000FFFFFFFFFF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00800080FFFF00
8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0080FF00FFFF800000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF0080FF80
80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF80FF800080FFFF800080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080FF008080
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF008080FF0080FF80FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF8080FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008080FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00800080FFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF008000FF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00008080008000FF
FFFF00FFFFFFFFFF0080FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00
FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF8080FFFF80FF00
FFFF0000FFFFFFFFFF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080FF
00FFFF800000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00008080FFFFFF0080FF
00FFFF800000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF
800080FFFF8000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF8080FFFFFFFFFF80FF
800080FFFF800080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0080
80FF0080FF80FF00FFFFFF00FFFF0000FFFFFFFFFFFFFFFF00008080FFFFFFFFFFFF0080
80FF0080FF80FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80
FFFFFF80FF80FF80800080FF00FFFF800000FFFFFF00FFFFFF8080FFFFFFFFFFFFFFFF80
FFFFFF80FF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
800080FFFF008080FFFF80FF800080FFFF800080FF8080008080FFFFFFFFFFFFFFFFFF00
800080FFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
80FF0080FF8080FFFFFF008080FF0080FF80FF008080FFFF80FFFFFFFFFFFFFFFFFFFFFF
80FF0080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0080FF008080FFFFFFFFFF80FFFFFF80FF80FF8080FFFFFF008000FFFFFF00FFFFFFFFFF
0080FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF80FF8080FFFFFFFFFFFF00800080FFFF008080FFFFFFFFFF80FF00FFFF0000FFFFFFFF
FF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF008080FFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFFFF0080FF00FFFF800000FFFF
FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF80FFFFFFFFFFFFFFFFFF0080FF008080FFFFFFFFFFFFFFFF80FF800080FFFF800080
FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF008000FFFFFF00FFFFFFFF80FF8080FFFFFFFFFFFFFFFFFF008080FF0080FF80FF00
8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF80FF00FFFF0000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFF80FFFFFF80FF80FF80
80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0080FF00FFFF800000FFFF80FFFFFFFFFFFFFFFFFFFFFFFF00800080FFFF008080
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF80FF800080FFFF800080FFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF008080FF0080FF80FF008080008000FFFFFF00FFFFFFFFFF0080FF008080FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF80FFFFFF80FF80FF8080FFFF80FF00FFFF0000FFFFFFFFFF80FF8080FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00800080FFFF008080FFFFFF0080FF00FFFF800000FFFFFF008080FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF80FF0080FF8080FFFFFFFFFF80FF800080FFFF800080FF8080FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0080FF008080FFFFFFFFFFFF008080FF0080FF80FF008080FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF80FF8080FFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF008080FFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF80FFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF008000FFFFFF00FFFFFFFFFF0080FF008080FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF80FF00FFFF0000FFFFFFFFFF80FF8080FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0080FF00FFFF800000FFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF80FF800080FFFF800080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF008080FF0080FF80FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF80FFFFFF80FF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00800080FFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF80FF0080FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0080FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF80FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[TextData[{
  "For a general cellular automaton rule, each digit of the rule number \
specifies what color a different possible neighborhood of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"2", 
          StyleBox["r",
            "TI"], "+", "1"}], TraditionalForm]], "InlineFormula"],
  " cells should yield. To find out which digit corresponds to which \
neighborhood, one effectively treats the cells in a neighborhood as digits in \
a number. For an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  " cellular automaton, the number is obtained from the list of elements ",
  StyleBox["neig", "TI"],
  " in the neighborhood by ",
  StyleBox["neig", "TI"],
  " ",
  StyleBox[".", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["k", "TI"],
  StyleBox["^2,", "MR"],
  " ",
  StyleBox["k", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["1}", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.8.6", "6.18"}],

Cell[TextData[{
  "It is sometimes convenient to consider ",
  StyleBox["totalistic", "TI"],
  " cellular automata, in which the new value of a cell depends only on the \
total of the values in its neighborhood. One can specify totalistic cellular \
automata by rule numbers or \[OpenCurlyDoubleQuote]codes\
\[CloseCurlyDoubleQuote] in which each digit refers to neighborhoods with a \
given total value, obtained for example from ",
  StyleBox["neig", "TI"],
  " ",
  StyleBox[".", "MR"],
  " ",
  StyleBox["{1,", "MR"],
  " ",
  StyleBox["1,", "MR"],
  " ",
  StyleBox["1}", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.8.6", "6.19"}],

Cell[TextData[{
  "In general, ",
  StyleBox["CellularAutomaton", "MR"],
  " allows one to specify rules using any sequence of weights. Another choice \
sometimes convenient is ",
  StyleBox["{", "MR"],
  StyleBox["k", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["1,", "MR"],
  " ",
  StyleBox["k", "TI"],
  StyleBox["}", "MR"],
  ", which yields outer totalistic rules. "
}], "Text",
  CellTags->{"S3.8.6", "6.20"}],

Cell[TextData[{
  "This runs the ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k",
            "TI"], "=", "3"}], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  " totalistic rule with code number 867. "
}], "MathCaption",
  CellTags->{"S3.8.6", "6.21"}],

Cell[CellGroupData[{

Cell["\<\
ArrayPlot[CellularAutomaton[{867, {3, 1}, 1}, {{1}, 0}, 100]]\
\>", \
"Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .50249 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00473821 0.011964 0.00473821 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .50249 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .50249 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .50249 L
s
0 .50249 m
1 .50249 L
s
1 0 m
1 .50249 L
s
0 0 m
1 0 L
1 .50249 L
0 .50249 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01196 translate
.95238 .47856 scale
201 string
201 101 8 [201 0 0 101 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
80FF8000FFFFFFFFFFFF80000080FF8080FF00000000FF80FF0080808080808080FFFF80
FF0080FF8080FF808080FFFF0080FF00FF00FF8000FFFF80FFFFFFFF80FF00FF80FF80FF
0000000000FF80FF8080FF8080FF0000FFFFFF80FF80800000000080FF80000000008080
FF80FFFFFF0000FF8080FF8080FF80FF0000000000FF80FF80FF00FF80FFFFFFFF80FFFF
0080FF00FF00FF8000FFFF808080FF8080FF8000FF80FFFF8080808080808000FF80FF00
000000FF8080FF80000080FFFFFFFFFFFF0080FF80
FF808000FFFFFFFFFF00FF0080FFFFFF80FF8000FF8000000080FFFF80FFFF80FFFFFF00
0080FFFFFF80FF80FFFF8080FF000080FF800000FF8080FFFFFFFFFFFF808080FFFFFF80
808080808080FFFF0000FFFF80FF8000FFFFFFFF80800080FF0080FFFFFF8000FF800080
80FFFFFFFF0080FF80FFFF0000FFFF80808080808080FFFFFF808080FFFFFFFFFFFF8080
FF000080FF800000FF8080FFFF80FF80FFFFFF800000FFFFFF80FFFF80FFFF8000000080
FF0080FF80FFFFFF8000FF00FFFFFFFFFF008080FF
FFFF80FF00FFFFFF00FF80808000008000800080FF80FF0080FFFFFFFF8080FFFFFFFF00
80FFFFFF00FF00FF00FFFF80FF8000FF00FF0080FF80FFFF00FFFFFF00FF000000800000
FF0000000000FFFF0080FF80800000FF8080FF80800080FFFF008080FF808000FFFF8000
8080FF8080FF00008080FF8000FFFF0000000000FF000080000000FF00FFFFFF00FFFF80
FF8000FF00FF0080FF80FFFF00FF00FF00FFFFFF8000FFFFFFFF8080FFFFFFFF8000FF80
FF80008000800000808080FF00FFFFFF00FF80FFFF
FFFFFF808080FF808080FFFF80FF0080808000FF00FF00FF80FF8080FF80FFFFFFFF00FF
80FF8080FF00FF808080FF80FF80FF00FF8080800000008000FFFF00FF808080808000FF
80808080808080FF8000800080808080FFFF80800080FFFF00FF80FFFFFF80FF00FFFF80
008080FFFF8080808000800080FF80808080808080FF008080808080FF00FFFF00800000
00808080FF00FF80FF80FF808080FF00FF8080FF80FF00FFFFFFFF80FF8080FF80FF00FF
00FF0080808000FF80FFFF808080FF808080FFFFFF
FFFFFFFF80FFFF0000FF00FFFF80808000808080FF00FF8080000000FFFF8080FF808080
FFFFFF80FF8000000000008080FFFF008000808000FF800080FF808080FFFF80FFFF8000
00FF000000FF000080808000FF000000FFFF0000FF80FF808080FFFFFFFFFF808080FF80
FF0000FFFF000000FF008080800000FF000000FF000080FFFF80FFFF808080FF800080FF
008080008000FFFF8080000000000080FF80FFFFFF808080FF8080FFFF0000008080FF00
FF80808000808080FFFF00FF0000FFFF80FFFFFFFF
FFFFFFFFFF8080FF008000FFFF000000FF80FFFF808080FFFF8000FF8080FFFF80800080
80FF80800000FF8000FF80008080FF800080FFFF800000FF80FF80FFFF8080FFFF00FF00
80FF8000FF8080808000808080FF0080FF80808080FFFF0000FF00FFFFFF00FF0000FFFF
80808080FF8000FF8080800080808080FF0080FF8000FF00FFFF8080FFFF80FF80FF0000
80FFFF800080FF80800080FF0080FF00008080FF8080008080FFFF8080FF0080FFFF8080
80FFFF80FF000000FFFF008000FF8080FFFFFFFFFF
FFFFFFFFFFFF80FF800080FF8080808080FFFFFFFF80FFFFFFFF800000FF00FFFF80FF00
00FFFF80FF00800080FF80FF0000FFFF8000800000FF800000FFFF8080FFFF8080FF00FF
80FF80FF00FF000000FF80FFFF8080800000000000008000FF808080FF808080FF008000
0000000000808080FFFF80FF000000FF00FF80FF80FF00FF8080FFFF8080FFFF000080FF
0000800080FFFF0000FF80FF80008000FF80FFFF0000FF80FFFF00FF000080FFFFFFFF80
FFFFFFFF8080808080FF800080FF80FFFFFFFFFFFF
FFFFFFFFFFFFFF808000FF00FF000000FF00FFFFFFFF8080FF808000FF808080FF80FF80
00FFFFFF80808000FF00FF00FF80000080808000FF808000FF8080FFFF8080FFFF808080
FFFFFF808080FF0080FF80FF808000808080808080808000FFFF80FFFFFF80FFFF008080
808080808080008080FF80FF8000FF808080FFFFFF808080FFFF8080FFFF8080FF008080
FF00808080000080FF00FF00FF00808080FFFFFF0080FF80FF808080FF008080FF8080FF
FFFFFF00FF000000FF00FF008080FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF80FF00FF8080808080FF00FFFFFF000000808000FFFF80FFFF000080
8080FF808000808080FF00FF808000FF80FFFF800000FF0080008080FF80FFFFFF000000
FFFFFFFF80FFFF008080FFFFFF80FF00000000FF000000FF8080FFFFFFFFFF8080FF0000
00FF00000000FF80FFFFFF808000FFFF80FFFFFFFF000000FFFFFF80FF8080008000FF00
0080FFFF80FF008080FF00FF808080008080FF8080800000FFFF80FFFF008080000000FF
FFFF00FF8080808080FF00FF80FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF808080FFFF80FFFF808080FF80808080800080FF8080000080FF00
0000FFFF80FF0000FF00FF80800080FF80FF808000FF80808000FF00008080FF80808080
80FF8080FFFF00FF80FFFFFFFFFF808080808080FF0080FF80FFFFFFFFFFFFFF80FF8000
FF808080808080FFFFFFFFFF80FF00FFFF8080FF8080808080FF80800000FF00808080FF
008080FF80FF80008080FF00FF0000FF80FFFF000000FF8000008080FF80008080808080
FF808080FFFF80FFFF808080FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF80FFFF00FF00FFFF80FFFFFF80FFFF80FF0000808000FF80FF80
00FF8080FFFF0080FF800000FF008080FFFF0000FF808000808080FF0080800000000000
00FFFF80FF808080FFFFFFFFFFFFFF80FFFF80FFFF008080FFFFFFFFFFFFFFFFFF808000
FFFF80FFFF80FFFFFFFFFFFFFF808080FF80FFFF000000000000808000FF808080008080
FF0000FFFF808000FF000080FF8000FFFF8080FF0080FF80FF0080800000FF80FFFF80FF
FFFF80FFFF00FF00FFFF80FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF8080FF00FF8080FFFFFF00FF00FFFF808080800080FF80FF80
FF00FF00008000FF00FF0080FF80008080FF8000FFFF80FF0000000080FFFF8000FF8000
FF8080FFFFFF80FFFFFFFFFFFFFFFFFF8080FFFF00FF80FFFFFFFFFFFFFFFFFFFFFF80FF
00FFFF8080FFFFFFFFFFFFFFFFFF80FFFFFF8080FF0080FF0080FFFF8000000000FF80FF
FF0080FF80800080FF8000FF00FF00800000FF00FF80FF80FF800080808080FFFF00FF00
FFFFFF8080FF00FF8080FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF80FF800000FF00FFFF008000FFFF000000FF008080FFFFFF
808080FF00808080FF00FF80FF80FF000000808080FF80FF8000FF8000800000FF808000
FFFF80FF8080FFFFFFFFFF00FFFFFFFFFF80FF808080FFFFFFFFFFFFFFFFFFFFFFFFFF80
8080FF80FFFFFFFFFF00FFFFFFFFFF8080FF80FFFF008080FF0000800080FF0080FF80FF
808080000000FF80FF80FF00FF80808000FF808080FFFFFF808000FF000000FFFF008000
FFFF00FF000080FF80FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF808000FF808080FF800080FF8080808080FF0000FFFFFF
0000FF00FF80FFFF808080FFFFFF8080808080008080FFFFFF800000FF80FF0080008080
80FF80FF80FFFFFFFFFFFF00800000800000FFFF80FFFFFFFF00FFFFFFFFFF00FFFFFFFF
80FFFF00008000008000FFFFFFFFFFFF80FF80FF808080008000FF80FF000080FFFFFF80
80008080808080FFFFFF808080FFFF80FF00FF0000FFFFFF0000FF8080808080FF800080
FF808080FF008080FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FF000000808080000000FF00000080FF00FFFF
0080FF800000FFFFFF80FFFFFFFF0000000000FF80FFFFFFFFFF8000FFFF80808000FF00
00008080FFFFFFFFFFFFFF008080808000FF8080FFFFFFFF00FF8080FF8080FF00FFFFFF
FF8080FF008080808000FFFFFFFFFFFFFF8080000000FF00808080FFFF0080FFFFFFFFFF
80FF0000000000FFFFFFFF80FFFFFF000080FF8000FFFF00FF80000000FF000000808080
000000FF00FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808080FF0080FFFF80FF0080FF8000FF80FF800000
80FFFFFF8000FFFFFFFF8080FF80808080808080FFFF00FFFFFFFF80000080800080FF80
00FF80FFFFFFFFFFFFFF00FF80FFFF80FF00FF000080000080FF80FFFFFF80FF80000080
0000FF00FF80FFFF80FF00FFFFFFFFFFFFFF80FF0080FF80008080000080FFFFFFFF00FF
FF80808080808080FF8080FFFFFFFF0080FFFFFF80000080FF80FF0080FF8000FF80FFFF
8000FF808080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFF008080FF80FF8000800080FF80FF80FF00
8080FF808000FFFFFFFF0000FFFF80FFFF80FFFF8080FF00FFFF00FF0080FFFF80008000
80FF80FF8080FF8080FF800000FFFFFF808080FF00808080800000FFFFFF000080808080
00FF808080FFFFFF000080FF8080FF8080FF80FF8000800080FFFF8000FF00FFFF00FF80
80FFFF80FFFF80FFFF0000FFFFFFFF008080FF808000FF80FF80FF8000800080FF80FF80
8000FFFF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8080FF0000FFFF808000FF008080FFFF000080
FFFF80800080FF8080FF8000FFFF00008000800000FF00FF8080FF00FF80FF808000FF00
8080FFFFFF80FF80FFFFFF8000FFFFFFFF80FFFF0080800080808080FF80808080008080
00FFFF80FFFFFFFF0080FFFFFF80FF80FFFFFF808000FF008080FF80FF00FF8080FF00FF
00008000800000FFFF0080FF8080FF80008080FFFF800000FFFF808000FF008080FFFF00
00FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF8000FFFFFF80FF00FF80FFFFFF0080FF
FFFFFF80FF000080800000FF8080FF0080808000FF808080FFFF808080FFFFFF80FF00FF
80FFFFFFFF00008080FF808000FFFFFFFFFF8080FF0000FF80FFFF80FF80FFFF80FF0000
FF8080FFFFFFFFFF008080FF80800000FFFFFFFF80FF00FF80FFFFFF808080FFFF808080
FF0080808000FF8080FF000080800000FF80FFFFFFFF8000FFFFFF80FF00FF80FFFFFF00
80FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808000FFFFFFFF808080FFFFFFFF008080
FF8080FFFF0080FFFF8000FFFF80FF8000808000FFFF80FFFF00FF0000008000000080FF
80FF8080FF8000FF0000808000FFFFFFFFFFFF80FF8000FFFF8080FFFFFF8080FFFF0080
FF80FFFFFFFFFFFF0080800000FF0080FF8080FF80FF8000000080000000FF00FFFF80FF
FF0080800080FF80FFFF0080FFFF8000FFFF8080FF808000FFFFFFFF808080FFFFFFFF00
8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FFFFFF000000FFFFFF00FF80FF
FFFF80FF8080800000808080FF80FF80FF0000FF8080FFFFFF008000FF800080FF008080
FFFF000000808080FF00808000FFFFFF00FFFFFF808000FFFF0000FFFFFF0000FFFF0080
80FFFFFF00FFFFFF00808000FF808080000000FFFF808000FF800080FF008000FFFFFF80
80FF0000FF80FF80FF8080800000808080FF80FFFFFF80FF00FFFFFF000000FFFFFF00FF
80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808080FF8080808080FF808080FFFF
FFFFFF80800080808080008080FFFFFF80808080FFFF8080FF800080FF80FF000080FFFF
8080FF0080FFFF80FF8000808080FF808080FF80800080FF80808080FF80808080FF8000
8080FF808080FF8080800080FF80FFFF8000FF8080FFFF800000FF80FF800080FF8080FF
FF80808080FFFFFF80800080808080008080FFFFFFFFFF808080FF8080808080FF808080
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFF0000FF0000FFFF80FFFFFF
FFFFFFFF80FF00000000FF80FFFFFFFF000000FF00FFFF80FF80FF00008080FF008080FF
80FFFF008080FF80FF80FF000000FFFF80FFFF0000FF80FF80FFFF80FF80FFFF80FF80FF
0000FFFF80FFFF000000FF80FF80FF808000FFFF80FF808000FF80800000FF80FF80FFFF
00FF000000FFFFFFFF80FF00000000FF80FFFFFFFFFFFFFF80FFFF0000FF0000FFFF80FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8080FF008000FF8080FFFFFFFF
FFFFFFFFFF808080808080FFFF00FFFF0080FF00FF8080FFFFFF80808080008000FF0000
8080FF80008080FFFFFF8080808080FF80FF80808080FFFFFF8080FFFFFF8080FFFFFF80
808080FF80FF8080808080FFFFFF80800080FF80800000FF00800080808080FFFFFF8080
FF00FF8000FFFF00FFFF808080808080FFFFFFFFFFFFFFFFFF8080FF008000FF8080FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF800080FF80FFFFFFFFFF
FFFF00FFFFFF80FFFF80FFFF00FF8080FF000080FF80FFFFFFFF000000FF00808080FF00
80800000FF80FFFFFFFF0000FF0000008080FFFF80FFFFFF00FF0000800000FF00FFFFFF
80FFFF8080000000FF0000FFFFFFFF80FF0000808000FF80808000FF000000FFFFFFFF80
FF800000FF8080FF00FFFF80FFFF80FFFFFF00FFFFFFFFFFFFFF80FF800080FF80FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808000FF00FF00FFFF00FF
FF00FF8080FF80FF8080000080FF80FFFF0080FFFFFF8080FF8080808080FF0000000080
FFFF8000FFFF8080FF80808080FF0080FFFF8080FFFFFFFF008000FF80FF008000FFFFFF
FF8080FFFF8000FF80808080FF8080FFFF0080FFFF8000000000FF8080808080FF8080FF
FFFF8000FFFF80FF8000008080FF80FF8080FF00FFFF00FFFF00FF00FF008080FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FF808080FF8000
0080FF80FFFF0000808000FF80FF80FF808080000080008080FFFF80FFFF808080808080
0000808080FF80FFFF0000FF000080FFFFFFFF80FF8080FF800080FF80FF800080FF8080
FF80FFFFFFFF800000FF0000FFFF80FF8080800000808080808080FFFF80FFFF80800080
0000808080FF80FF80FF0080800000FFFF80FF80000080FF808080FF00FF80FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808080FFFF80FF80FF
008080FFFF00FF8000808080FFFFFF8080008080808000FF00008000800000FF000000FF
0080FFFF80FF80FF80808080FF008080FF8080FFFF000000808080000000808080000000
FFFF8080FF808000FF80808080FF80FF80FFFF8000FF000000FF00008000800000FF0080
808080008080FFFFFF8080800080FF00FFFF808000FF80FF80FFFF808080FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFF00FF00FF00
FF80FFFF00FF808000FF0000FFFFFFFF80FF00000000FF8080808000FF0080FF8000FF80
808000008080FFFF000000FF00FF80FFFFFF80FF80808080800080808080800080808080
80FF80FFFFFF80FF00FF000000FFFF80800000808080FF0080FF8000FF0080808080FF00
000000FF80FFFFFFFF0000FF008080FF00FFFF80FF00FF00FF00FFFF80FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8080FF00FF8080
80FFFF00FF80800080FF8000FFFFFFFF000080FF0080FF80FFFF80FF00FF80FF80FF00FF
0000FF80008080FF8000FF808080FFFFFF00FF00FF000000FF00808000808000FF000000
FF00FF00FFFFFF808080FF0080FF80800080FF0000FF00FF80FF80FF00FF80FFFF80FF80
00FF800000FFFFFFFF0080FF80008080FF00FFFF808080FF00FF8080FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF800000FF
00008000FFFF80FF0000808080FF8080FF008080FF00008080FF80FF800000FFFF808080
FF00800080FFFF808000FFFF80FFFFFF00FF808080FF0080FF80008080800080FF8000FF
808080FF00FFFFFF80FFFF008080FFFF80008000FF808080FFFF000080FF80FF80800000
FF808000FF8080FF8080800000FF80FFFF00800000FF000080FF80FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808000FF80
80808000FFFFFF80808080008080FFFF808080008000FF80FFFFFF808000FF8080FFFF80
FF800080FFFFFFFF80FF00FFFF8080FF80000000FF00FF80FF80FF000000FF80FF80FF00
FF00000080FF8080FFFF00FF80FFFFFFFF800080FF80FFFF8080FF008080FFFFFF80FF00
8000808080FFFF80800080808080FFFFFF0080808080FF008080FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FF
000000FF8080FF80FFFF80FF0000FFFF000000FF80FF00FF00FFFFFF80FF00FF00008000
800080FFFFFF00FFFF808080FF80FFFFFF8000FF808080FFFFFF8080808080FFFFFF8080
80FF0080FFFFFF80FF808080FFFF00FFFFFF80008000800000FF00FF80FFFFFF00FF00FF
80FF000000FFFF0000FF80FFFF80FF8080FF000000FF00FF80FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808080
FF0080FF80FFFFFF8080FFFF0080FF8080808080FFFF008000FFFFFF000080FF8000FF00
80808000008000FFFFFF80FFFFFF8080FF80FF00FF00000080000000FF00000080000000
FF00FF80FF8080FFFFFF80FFFFFF0080000080808000FF0080FF800000FFFFFF008000FF
FF8080808080FF8000FFFF8080FFFFFF80FF8000FF808080FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF
FF008080FFFFFFFFFF80FF808080000000000000FFFF00808080FF808080800000FF8080
80008080808000FFFFFFFF8080FF80FFFF000080FF8000FF80FF0080FF8000FF80FF0080
FF800000FFFF80FF8080FFFFFFFF008080808000808080FF000080808080FF80808000FF
FF000000000000808080FF80FFFFFFFFFF808000FFFF80FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80
80FF0000FFFFFFFFFFFF8080008080808080808080FF8000808000000000FF0080FF80FF
FF800080800080FF8080FF80FFFF00008000FF80FF80FF00FF00FF80FF80FF00FF00FF80
FF80FF00800000FFFF80FF8080FF800080800080FFFF80FF8000FF0000000080800080FF
8080808080808080008080FFFFFFFFFFFF0000FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
80FF8000FFFFFFFFFFFFFF80FF0000000000000000FFFF8000808080808080FF00008080
FF80FF0000FF80FF80FFFF00008000FF80FF00FF00FF00FF808080FFFFFF808080FF00FF
00FF00FF80FF00800000FFFF80FF80FF0000FF80FF80800000FF8080808080800080FFFF
0000000000000000FF80FFFFFFFFFFFFFF0080FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF808000FFFFFFFFFF00FFFF80808080808080808080FF80FF0000000000FF00FF800080
80FFFF0080FF80FF80FF8080808000FFFF808080FF00FF8080008080FF8080008080FF00
FF808080FFFF0080808080FF80FF80FF8000FFFF80800080FF00FF0000000000FF80FF80
808080808080808080FFFF00FFFFFFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF80FF00FFFFFF00FF8080FFFF80FFFF80FFFF80FFFFFF80808080808080FF00FF0080
80000080FFFFFF80800000000000FF8080FFFF80FF80000000FF80FFFFFF80FF00000080
FF80FFFF8080FF00000000008080FFFFFF800000808000FF00FF80808080808080FFFFFF
80FFFF80FFFF80FFFF8080FF00FFFFFF00FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF808080FF808080FFFF8080FFFFFFFF8080FFFFFFFFFF80FFFF80FFFF808080FF00
00FF8000800000808000FF8000FF808000800000008080808080FFFFFFFFFF8080808080
00000080008080FF0080FF0080800000800080FF0000FF808080FFFF80FFFF80FFFFFFFF
FF8080FFFFFFFF8080FFFF808080FF808080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF80FFFF0000FF00FFFF80FF8080FF80FFFF00FFFFFFFF8080FFFFFF0000FF00FF
800000FF80FF00808000FFFF80000000FF80FF0080FFFF80FFFF8080FF8080FFFF80FFFF
8000FF80FF00000080FFFF00808000FF80FF000080FF00FF0000FFFFFF8080FFFFFFFF00
FFFF80FF8080FF80FFFF00FF0000FFFF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF8080FF008000FFFF000080800000008000FFFFFFFF0000FFFFFF0080FF8000
00FF8000000080FFFF8000008080808080FFFF008080FF80FF80800080008080FF80FF80
8000FFFF8080808080000080FFFF8000000080FF000080FF8000FFFFFF0000FFFFFFFF00
8000000080800000FFFF008000FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF80FF800080FF808080800080FF00808080FF8080FF0080000080FFFFFF80
00FFFF8000FF80FF808000FF80FFFF80FFFFFF008080000000808000FF00808000000080
8000FFFFFF80FFFF80FF008080FF80FF0080FFFF0080FFFFFF8000008000FF8080FF8080
8000FF800080808080FF800080FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF808000FF00FF000000FF80FF800080800000FF00FF80FF008080FF8080
00FFFFFF800000FFFF80FF00FF00FFFF8080FF800080808080800080FF80008080808080
0080FF8080FFFF00FF00FF80FFFF000080FFFFFF008080FF808000FF80FF00FF00008080
0080FF80FF000000FF00FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF80FF00FF8080808080FFFFFF800080808080FF00FF00FF80FFFFFF80
FF00FFFFFF8000FFFFFF808080FF00FFFF80FF80FF0000000000FF80FF80FF0000000000
FF80FF80FFFF00FF808080FFFFFF0080FFFFFF00FF80FFFFFF80FF00FF00FF8080808000
80FFFFFF8080808080FF00FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF808080FFFF80FFFF8080FF80FF000000FF00FF808080FFFF00FFFF
808080FF808000FFFFFFFF80FFFF00800000FFFF80808080808080FFFFFF808080808080
80FFFF00008000FFFF80FFFFFFFF008080FF808080FFFF00FFFF808080FF00FF000000FF
80FF8080FFFF80FFFF808080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF80FFFF00FF00FFFF80FF80FF8000FF808080FFFF80FF808080FF
80FFFF80800080FF8080FF80FF80808000FF8080FFFF80FFFF80FFFFFFFFFF80FFFF80FF
FF8080FF00808080FF80FF8080FF80008080FFFF80FF808080FF80FFFF808080FF0080FF
80FF80FFFF00FF00FFFF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF8080FF00FF8080FFFFFF808000FFFF80FFFFFFFF8080008080
FFFFFFFF80FF0000808000000080800080FF80FFFFFFFF8080FFFFFFFFFFFFFF8080FFFF
FFFF80FF8000808000000080800000FF80FFFFFFFF8080008080FFFFFFFF80FFFF008080
FFFFFF8080FF00FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF80FF800000FF00FFFF0000FF8080FFFFFFFFFF0000FF80FF
FFFF00FFFF808080800080FF00808000FF00FF00FFFFFF0000FFFFFFFFFFFFFF0000FFFF
FF00FF00FF00808000FF800080808080FFFF00FFFFFF80FF0000FFFFFFFFFF8080FF0000
FFFF00FF000080FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF808000FF808080FF8000FFFF80FF8080FF80808080FFFF
FFFF00800000FF0000FF80FF8000808080FF00FF8080FF8000FFFFFFFFFFFFFF0080FF80
80FF00FF8080800080FF80FF0000FF00008000FFFFFFFF80808080FF8080FF80FFFF0080
FF808080FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FF000000808080FF80FF80FFFF00000000FFFF
FF00FF80FF008000FF80800000FF80FFFF808080FFFF808000FFFFFFFFFFFFFF008080FF
FF808080FFFF80FF00008080FF008000FF80FF00FFFFFF00000000FFFF80FF80FF808080
000000FF00FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808080FF0080FFFF80FF80FF80FF808080808080FF
808080FFFF00808080FFFF8000FFFF8080FFFF80FF80800080FF8080FF8080FF80008080
FF80FFFF8080FFFF0080FFFF80808000FFFF808080FF808080808080FF80FF80FF80FFFF
8000FF808080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFF008080FF80FF80FF80FF80FFFF80FFFF80
80008080FF800080800000808080FF80FFFFFFFF80800080FFFFFF80FF80FFFFFF800080
80FFFFFFFF80FF808080000080800080FF8080008080FFFF80FFFF80FF80FF80FF80FF80
8000FFFF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8080FF0000FFFF80800000FFFF8080FFFFFFFF
80FF0000FFFF800080808080008080FFFFFFFFFF0000FF80FF8080FFFFFF8080FF80FF00
00FFFFFFFFFF808000808080800080FFFF0000FF80FFFFFFFF8080FFFF00008080FFFF00
00FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF8000FFFFFF80FF00800000FF00FFFFFF
FF80808080FF80FF00000000FF80FFFFFFFFFFFF0080FF80FF80FFFFFFFFFF80FF80FF80
00FFFFFFFFFFFF80FF00000000FF80FF80808080FFFFFFFF00FF00008000FF80FFFFFF00
80FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808000FFFFFFFF80808000FF808080FF80
80FFFF80FFFFFF808080808080FFFFFFFFFFFFFF008080FFFFFF8080FF8080FFFFFF8080
00FFFFFFFFFFFFFF808080808080FFFFFF80FFFF8080FF808080FF00808080FFFFFFFF00
8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FFFFFF000000FF8080008080FF
FF8080FFFFFFFFFF80FFFF80FFFF00FFFFFFFF00FF80FFFF00FFFF80FF80FFFF00FFFF80
FF00FFFFFFFF00FFFF80FFFF80FFFFFFFFFF8080FFFF8080008080FF000000FFFFFF00FF
80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808080FF8080808080FFFF80008080
FF80FFFFFFFFFFFFFF8080FFFF00FF8080FF808080FFFF00FF8080FFFFFF8080FF00FFFF
808080FF8080FF00FFFF8080FFFFFFFFFFFFFF80FF80800080FFFF8080808080FF808080
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFF0000FF0000FFFFFF800080
80FFFFFF00FFFFFFFFFF80FF808080FFFF8080008080FF80000000FFFFFF00000080FF80
80008080FFFF808080FF80FFFFFFFFFF00FFFFFF80800080FFFFFF0000FF0000FFFF80FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8080FF008000FF8080FF80FF00
00FFFF00FF8080FF8080FFFFFF80FFFFFFFF80FF0000008080808080FF80808080800000
00FF80FFFFFFFF80FFFFFF8080FF8080FF00FFFF0000FF80FF8080FF008000FF8080FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF800080FF80FFFFFF8080
8080FF80000000FFFF80FF8080FFFFFFFFFFFF8080808080008080008000808000808080
8080FFFFFFFFFFFF8080FF80FFFF00000080FF80808080FFFFFF80FF800080FF80FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808000FF00FF00FFFF0000
0000008080808080FF80FF80FFFFFFFFFFFFFFFF80FFFF80FF0000FF80FF0000FF80FFFF
80FFFFFFFFFFFFFFFF80FF80FF80808080800000000000FFFF00FF00FF008080FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FF808080FF8000
FF8000FF00000000008080FFFFFFFFFFFFFFFFFFFF8080FFFF0080FF80FF8000FFFF8080
FFFFFFFFFFFFFFFFFFFF80800000000000FF0080FF0080FF808080FF00FF80FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808080FFFF80FF80FF
00FF008000FF8000FF80FFFFFFFFFFFFFFFFFFFFFFFF80FF808080000000808080FF80FF
FFFFFFFFFFFFFFFFFFFFFF80FF0080FF008000FF00FF80FF80FFFF808080FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFF00FF00FF00
FF80808000FFFF800000FFFFFFFFFFFFFFFFFFFFFFFFFF8080008080808080008080FFFF
FFFFFFFFFFFFFFFFFFFFFF000080FFFF00808080FF00FF00FF00FFFF80FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8080FF00FF8080
80FFFF80FF00FFFF8000FFFFFF00FFFFFFFFFFFFFFFFFFFF80FF0000000000FF80FFFFFF
FFFFFFFFFFFFFF00FFFFFF0080FFFF00FF80FFFF808080FF00FF8080FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF800000FF
000080008000FFFFFF8000008000FFFFFFFFFFFFFFFF00FFFF80808080808080FFFF00FF
FFFFFFFFFFFFFF0080000080FFFFFF008000800000FF000080FF80FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808000FF80
80808000FF008000008080808000FFFFFFFF00FFFFFF008000000000FF000000008000FF
FFFF00FFFFFFFF008080808000008000FF0080808080FF008080FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FF
000000FF80808000FF80FFFF80FF00FFFF00FF8080FF800080FF0080FF8000FF800080FF
8080FF00FFFF00FF80FFFF80FF00808080FF000000FF00FF80FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808080
FF0080FF80FFFF800000FFFF000080FF808080FFFF808000FF00FF80FF80FF00FF008080
FFFF808080FF800000FFFF000080FFFF80FF8000FF808080FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF
FF008080FFFFFFFF8000FFFF0080FFFFFF80FFFFFF0000FF808080FFFFFF808080FF0000
FFFFFF80FFFFFF8000FFFF0080FFFFFFFF808000FFFF80FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80
80FF0000FFFFFFFFFF80000080FFFFFFFFFF8080FF8000FFFF80FFFFFFFFFF80FFFF0080
FF8080FFFFFFFFFF80000080FFFFFFFFFF0000FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
80FF8000FFFFFFFFFFFF8000FF00FFFFFFFFFF80FF80FF00FFFF8080FF8080FFFF00FF80
FF80FFFFFFFFFF00FF0080FFFFFFFFFFFF0080FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF808000FFFFFFFFFF00FF008000FFFFFFFFFF00008080FF00FFFF80FF80FFFF00FF8080
0000FFFFFFFFFF008000FF00FFFFFFFFFF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF80FF00FFFFFF00FF80808000FFFFFFFFFF0080FFFF808080FF80FF80FF808080FFFF
8000FFFFFFFFFF00808080FF00FFFFFF00FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF808080FF808080FFFF80FF00FFFFFF00FF80FF8080008080FFFFFF8080008080FF
80FF00FFFFFF00FF80FFFF808080FF808080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF80FFFF0000FF00FFFF808080FF808080FFFFFF80FF0000FFFFFF0000FF80FFFF
FF808080FF808080FFFF00FF0000FFFF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF8080FF008000FFFF000000FFFF80FFFF00FFFF80808080FF80808080FFFF00
FFFF80FFFF000000FFFF008000FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF80FF800080FF8080808080FF80FF808080FF80FFFF80FF80FFFF80FF8080
80FF80FF8080808080FF800080FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF808000FF00FF000000FF00FF00FF0000FFFF8080FFFFFF8080FFFF0000
FF00FF00FF000000FF00FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF80FF00FF8080808080FF00FF80808080FF80FFFFFFFFFF80FF808080
80FF00FF8080808080FF00FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF808080FFFF80FFFF808080FFFF80FFFFFF8080FF8080FFFFFF80FF
FF808080FFFF80FFFF808080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF80FFFF00FF00FFFF80FFFFFFFF8080FF80FFFFFF80FF8080FFFF
FFFF80FFFF00FF00FFFF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF8080FF00FF8080FFFFFFFF00FF00008080FF80800000FF00FF
FFFFFF8080FF00FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF80FF800000FF00FFFF00FF8080808000800080808080FF00
FFFF00FF000080FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF808000FF808080FF800000FF0000FF80FF0000FF000080
FF808080FF008080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FF00000080808080FF0080008000FF80808080
000000FF00FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808080FF0080FFFF80FFFF0080808000FFFF80FFFF
8000FF808080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFF008080FF80FF80808000808080FF80FF80
8000FFFF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8080FF0000FFFF808000808080008080FFFF00
00FF8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF8000FFFFFF80FF000000FF80FFFFFF00
80FF80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808000FFFFFFFF8080808080FFFFFFFF00
8080FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FFFFFF0000000000FFFFFF00FF
80FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808080FF80808080808080FF808080
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFF000000FF000000FFFF80FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8080FF0080FF8000FF8080FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF8000800080FF80FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808000FF008080FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FF00FF80FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808080FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[TextData[{
  "Rules with range ",
  Cell[BoxData[
      FormBox[
        StyleBox["r",
          "TI"], TraditionalForm]], "InlineFormula"],
  " involve all cells with offsets ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          StyleBox["r",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " through ",
  Cell[BoxData[
      FormBox[
        RowBox[{"+", 
          StyleBox["r",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". Sometimes it is convenient to think about rules that involve only cells \
with specific offsets. You can do this by replacing a single ",
  StyleBox["r", "TI"],
  " with a list of offsets. "
}], "Text",
  CellTags->{"S3.8.6", "6.22"}],

Cell[TextData[{
  "Any ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k",
            "TI"], "=", "2"}], TraditionalForm]], "InlineFormula"],
  " cellular automaton rule can be thought of as corresponding to a Boolean \
function. In the simplest case, basic Boolean functions like ",
  StyleBox["And", "MR"],
  " or ",
  StyleBox["Nor", "MR"],
  " take two arguments. These are conveniently specified in a cellular \
automaton rule as being at offsets ",
  StyleBox["{{0},", "MR"],
  " ",
  StyleBox["{1}}", "MR"],
  ". Note that for compatibility with handling higher\[Hyphen]dimensional \
cellular automata, offsets must always be given in lists, even for one\
\[Hyphen]dimensional cellular automata. "
}], "Text",
  CellTags->{"S3.8.6", "6.23"}],

Cell["\<\
This generates the truth table for \
2\[Hyphen]cell\[Hyphen]neighborhood rule number 7, which turns out to be the \
Boolean function Nand. \
\>", "MathCaption",
  CellTags->{"S3.8.6", "6.24"}],

Cell[CellGroupData[{

Cell["\<\
Map[CellularAutomaton[{7, 2, {{0}, {1}}}, #, 1][[2, 2]] &, {{1, 1}, \
{1, 0}, {0, 1}, {0, 0}}]\
\>", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.8.6"],

Cell[BoxData[
    \({0, 1, 1, 1}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell["\<\
Rule numbers provide a highly compact way to specify cellular \
automaton rules. But sometimes it is more convenient to specify rules by \
giving an explicit function that should be applied to each possible \
neighborhood. \
\>", "Text",
  CellTags->{"S3.8.6", "6.25"}],

Cell["\<\
This runs an additive cellular automaton whose rule adds all values \
in each neighborhood modulo 4. \
\>", "MathCaption",
  CellTags->{"S3.8.6", "6.26"}],

Cell[CellGroupData[{

Cell["\<\
ArrayPlot[CellularAutomaton[ {Mod[Apply[Plus, #], 4]&, {}, 1}, \
{{1}, 0}, 100]]\
\>", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .50249 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00473821 0.011964 0.00473821 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .50249 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .50249 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .50249 L
s
0 .50249 m
1 .50249 L
s
1 0 m
1 .50249 L
s
0 0 m
1 0 L
1 .50249 L
0 .50249 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01196 translate
.95238 .47856 scale
201 string
201 101 8 [201 0 0 101 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
AAFF55FF00FF55FFAAFFFFFFFFFFFFFF55FFFFFF55FFFFFF55FFFFFFFFFFFFFFAAFF55FF
00FF55FFAAFFFFFFFFFFFFFF55FFFFFF55FFFFFF55FFFFFFFFFFFFFF55FFFFFF55FFFFFF
55FFFFFFFFFFFFFF55FFFFFF55FFFFFF55FFFFFFFFFFFFFFAAFF55FF00FF55FFAAFFFFFF
FFFFFFFF55FFFFFF55FFFFFF55FFFFFFFFFFFFFF55FFFFFF55FFFFFF55FFFFFFFFFFFFFF
55FFFFFF55FFFFFF55FFFFFFFFFFFFFFAAFF55FF00FF55FFAAFFFFFFFFFFFFFF55FFFFFF
55FFFFFF55FFFFFFFFFFFFFFAAFF55FF00FF55FFAA
FFAA0055005500AAFFFFFFFFFFFFFFFFFF5555FF55FF5555FFFFFFFFFFFFFFFFFFAA0055
005500AAFFFFFFFFFFFFFFFFFF5555FF55FF5555FFFFFFFFFFFFFFFFFF5555FF55FF5555
FFFFFFFFFFFFFFFFFF5555FF55FF5555FFFFFFFFFFFFFFFFFFAA0055005500AAFFFFFFFF
FFFFFFFFFF5555FF55FF5555FFFFFFFFFFFFFFFFFF5555FF55FF5555FFFFFFFFFFFFFFFF
FF5555FF55FF5555FFFFFFFFFFFFFFFFFFAA0055005500AAFFFFFFFFFFFFFFFFFF5555FF
55FF5555FFFFFFFFFFFFFFFFFFAA0055005500AAFF
FFFFAA550055AAFFFFFFFFFFFFFFFFFFFFFF55FF55FF55FFFFFFFFFFFFFFFFFFFFFFAA55
0055AAFFFFFFFFFFFFFFFFFFFFFF55FF55FF55FFFFFFFFFFFFFFFFFFFFFF55FF55FF55FF
FFFFFFFFFFFFFFFFFFFF55FF55FF55FFFFFFFFFFFFFFFFFFFFFFAA550055AAFFFFFFFFFF
FFFFFFFFFFFF55FF55FF55FFFFFFFFFFFFFFFFFFFFFF55FF55FF55FFFFFFFFFFFFFFFFFF
FFFF55FF55FF55FFFFFFFFFFFFFFFFFFFFFFAA550055AAFFFFFFFFFFFFFFFFFFFFFF55FF
55FF55FFFFFFFFFFFFFFFFFFFFFFAA550055AAFFFF
FFFFFFAAAAAAFFFFFFFFFFFFFFFFFFFFFFFFFF555555FFFFFFFFFFFFFFFFFFFFFFFFFFAA
AAAAFFFFFFFFFFFFFFFFFFFFFFFFFF555555FFFFFFFFFFFFFFFFFFFFFFFFFF555555FFFF
FFFFFFFFFFFFFFFFFFFFFF555555FFFFFFFFFFFFFFFFFFFFFFFFFFAAAAAAFFFFFFFFFFFF
FFFFFFFFFFFFFF555555FFFFFFFFFFFFFFFFFFFFFFFFFF555555FFFFFFFFFFFFFFFFFFFF
FFFFFF555555FFFFFFFFFFFFFFFFFFFFFFFFFFAAAAAAFFFFFFFFFFFFFFFFFFFFFFFFFF55
5555FFFFFFFFFFFFFFFFFFFFFFFFFFAAAAAAFFFFFF
FFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFF
FFFFFFFFFFAA00FFAA00FFAA00FFAA00FFAA00FFAAAA55AAAA55AAAA55AAAA55AAAA55AA
AA00FFAA00FFAA00FFAA00FFAA00FFAA0055000055000055000055000055000055AAAA55
AAAA55AAAA55AAAA55AAAA55AA00FFAA00FFAA00FFAA00FFAA00FFAA00AAFF00AAFF00AA
FF00AAFF00AAFF00AA55AAAA55AAAA55AAAA55AAAA55AAAA550000550000550000550000
5500005500AAFF00AAFF00AAFF00AAFF00AAFF00AAAA55AAAA55AAAA55AAAA55AAAA55AA
AAFF00AAFF00AAFF00AAFF00AAFF00AAFFFFFFFFFF
FFFFFFFFFFFFAA55AA55FF55005500FFFFFFAA55AA555555AA5500FF55FF0055AA555555
AA55FF55005500FFFFFFAA55AA55FF550055AAFF55FFAA55005555550055AAFF55FF0055
AA555555AA5500FF55FF0055AA55FF55005500FFFFFFAA55AA55FF550055FF55AA55AAFF
FFFF00550055FF55AA5500FF55FF0055AA555555AA5500FF55FFAA55005555550055AAFF
55FFAA550055FF55AA55AAFFFFFF00550055FF55AA555555AA5500FF55FF0055AA555555
AA55AAFFFFFF00550055FF55AA55AAFFFFFFFFFFFF
FFFFFFFFFFFFFFAAAA005500AA005555FF5555AA00AA5500AAAAFF555555FFAAAA0055AA
00AA55AA0000FFFFFFFFFFAAAA005500AA0055FF55FF5500AA0055AA0000FF555555FFAA
AA0055AA00AA55FF55FF55AA00AA55AA0000FFFFFFFFFFAAAA005500AA005500AAAAFFFF
FFFFFF0000AA55AA00AA55FF55FF55AA00AA5500AAAAFF555555FF0000AA5500AA0055FF
55FF5500AA005500AAAAFFFFFFFFFF0000AA55AA00AA5500AAAAFF555555FFAAAA0055AA
00AA5555FF555500AA005500AAAAFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFAAFF55FFAAFF55FFFFFF55FF00FF55FFAAFFFFFF55FFFFFFAAFF55FF
00FF55FF00FFFFFFFFFFFFFFAAFF55FFAAFF55FF55FF55FFAAFF55FF00FFFFFF55FFFFFF
AAFF55FF00FF55FF55FF55FF00FF55FF00FFFFFFFFFFFFFFAAFF55FFAAFF55FFAAFFFFFF
FFFFFFFF00FF55FF00FF55FF55FF55FF00FF55FFAAFFFFFF55FFFFFF00FF55FFAAFF55FF
55FF55FFAAFF55FFAAFFFFFFFFFFFFFF00FF55FF00FF55FFAAFFFFFF55FFFFFFAAFF55FF
00FF55FFFFFF55FFAAFF55FFAAFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFAA005500FFAAAA55AAAAFF00FFAAAA5555FF555555FF5555AAAAFF
00FFAAAA55FF5555FF5555FF550000FFAAFF000055AAAAFF005500AAFF5555FF55FF5555
FF00AA55AAFF000055AAAAFF00FFAAAA55FF5555FF5555FF550000FFAAFF000055FF5555
FF5555FF55AAAAFF00FFAAAA550000FFAA55AA00FF5555FF55FF5555FFAA005500FFAAAA
550000FFAAFF000055FF5555FF5555FF55AAAAFF00FFAAAA5555FF555555FF5555AAAAFF
00FFAAAA55AAAAFF005500AAFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFAA55005500FF55FF0055005500FF55FFFFFF55FFFFFF55FF0055
005500FF55FF55FFFFFF55FF55FFAA55AA55AAFF55FF00550055AAFFFFFF55FF55FF55FF
FFFF0055AA55AAFF55FF0055005500FF55FF55FFFFFF55FF55FFAA55AA55AAFF55FF55FF
FFFF55FF55FF0055005500FF55FFAA55AA5500FFFFFF55FF55FF55FFFFFFAA55005500FF
55FFAA55AA55AAFF55FF55FFFFFF55FF55FF0055005500FF55FFFFFF55FFFFFF55FF0055
005500FF55FF00550055AAFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFAAAAAAFF555555FFAAAAAAFF555555FF555555FF555555FFAA
AAAAFF555555FFFFFFFFFF555555FF000000FF555555FFAAAAAAFFFFFFFFFF555555FFFF
FFFFFF000000FF555555FFAAAAAAFF555555FFFFFFFFFF555555FF000000FF555555FFFF
FFFFFF555555FFAAAAAAFF555555FF000000FFFFFFFFFF555555FFFFFFFFFFAAAAAAFF55
5555FF000000FF555555FFFFFFFFFF555555FFAAAAAAFF555555FF555555FF555555FFAA
AAAAFF555555FFAAAAAAFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFF55FFFFFFAAFFFFFF55FFFFFF55FFFFFF55FFFFFF
AAFFFFFF55FFFFFFFFFFFFFF55FFFFFF00FFFFFF55FFFFFFAAFFFFFFFFFFFFFF55FFFFFF
FFFFFFFF00FFFFFF55FFFFFFAAFFFFFF55FFFFFFFFFFFFFF55FFFFFF00FFFFFF55FFFFFF
FFFFFFFF55FFFFFFAAFFFFFF55FFFFFF00FFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFF
55FFFFFF00FFFFFF55FFFFFFFFFFFFFF55FFFFFFAAFFFFFF55FFFFFF55FFFFFF55FFFFFF
AAFFFFFF55FFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAAAA55AAAA00FFAA0055000055AAAA55AA00FFAA
00AAFF00AA55AAAA55AAAA55AA00FFAA0000550000FFAA00FF5555FF5555FF555555FF55
55FF5555FFAA00FFAAAA55AAAA00FFAA005500005500005500AAFF00AA00FFAA00550000
5500005500AAFF00AAAA55AAAAFF00AAFF5555FF5555FF555555FF5555FF5555FF00AAFF
0000550000AAFF00AA55AAAA55AAAA55AA00FFAA00AAFF00AA55AAAA5500005500AAFF00
AAAA55AAAAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFAA55AA555555AA55FF550055AAFF55FF0055AA55FF55
0055FF55AA5500FF55FF0055AA55FF5500555555005500FFFFFF55FF55FFFFFF55FFFFFF
55FF55FFFFFFAA55AA555555AA55FF550055AAFF55FFAA550055FF55AA55FF550055AAFF
55FFAA550055FF55AA555555AA55AAFFFFFF55FF55FFFFFF55FFFFFF55FF55FFFFFF0055
005555550055FF55AA5500FF55FF0055AA55FF550055FF55AA5500FF55FFAA550055FF55
AA555555AA55AAFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAA0055AA00AA55AA0000FF555555FFAAAA005500
AA005500AAAAFF555555FFAAAA005500AA0055AA0000FFFFFFFFFF555555FF555555FF55
5555FFFFFFFFFFAAAA0055AA00AA55AA0000FF555555FF0000AA55AA00AA55AA0000FF55
5555FF0000AA55AA00AA5500AAAAFFFFFFFFFF555555FF555555FF555555FFFFFFFFFF00
00AA5500AA005500AAAAFF555555FFAAAA005500AA005500AAAAFF555555FF0000AA55AA
00AA5500AAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFF55FF00FF55FF00FFFFFF55FFFFFFAAFF55FF
AAFF55FFAAFFFFFF55FFFFFFAAFF55FFAAFF55FF00FFFFFFFFFFFFFF55FFFFFF55FFFFFF
55FFFFFFFFFFFFFFAAFF55FF00FF55FF00FFFFFF55FFFFFF00FF55FF00FF55FF00FFFFFF
55FFFFFF00FF55FF00FF55FFAAFFFFFFFFFFFFFF55FFFFFF55FFFFFF55FFFFFFFFFFFFFF
00FF55FFAAFF55FFAAFFFFFF55FFFFFFAAFF55FFAAFF55FFAAFFFFFF55FFFFFF00FF55FF
00FF55FFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA0055005500AAFF5555FF55FF5555FF00AA55
AA55AA00FF5555FF55FF5555FF00AA55AA55AA00FFFFFFFFFFFFFFFFFF5555FF55FF5555
FFFFFFFFFFFFFFFFFFAA0055005500AAFF5555FF55FF5555FFAA0055005500AAFF5555FF
55FF5555FFAA0055005500AAFFFFFFFFFFFFFFFFFF5555FF55FF5555FFFFFFFFFFFFFFFF
FF00AA55AA55AA00FF5555FF55FF5555FF00AA55AA55AA00FF5555FF55FF5555FFAA0055
005500AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA550055AAFFFFFF55FF55FF55FFFFFF0055
AA5500FFFFFF55FF55FF55FFFFFF0055AA5500FFFFFFFFFFFFFFFFFFFFFF55FF55FF55FF
FFFFFFFFFFFFFFFFFFFFAA550055AAFFFFFF55FF55FF55FFFFFFAA550055AAFFFFFF55FF
55FF55FFFFFFAA550055AAFFFFFFFFFFFFFFFFFFFFFF55FF55FF55FFFFFFFFFFFFFFFFFF
FFFF0055AA5500FFFFFF55FF55FF55FFFFFF0055AA5500FFFFFF55FF55FF55FFFFFFAA55
0055AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAAAAFFFFFFFFFF555555FFFFFFFFFF00
0000FFFFFFFFFF555555FFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFF555555FFFF
FFFFFFFFFFFFFFFFFFFFFFAAAAAAFFFFFFFFFF555555FFFFFFFFFFAAAAAAFFFFFFFFFF55
5555FFFFFFFFFFAAAAAAFFFFFFFFFFFFFFFFFFFFFFFFFF555555FFFFFFFFFFFFFFFFFFFF
FFFFFF000000FFFFFFFFFF555555FFFFFFFFFF000000FFFFFFFFFF555555FFFFFFFFFFAA
AAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFF55FFFFFFFFFFFFFF
00FFFFFFFFFFFFFF55FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFFFFFFFFFF
55FFFFFFFFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF55FFFFFFFFFFFFFF00FFFFFFFFFFFFFF55FFFFFFFFFFFFFF
AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAA00FFAA0055000055000055
005500005500005500AAFF00AAFF00AAFF5555FF5555FF5555FF5555FF5555FF55FF5555
FF5555FF5555FF5555FF5555FF00AAFF00AAFF00AA55AAAA55AAAA55AA55AAAA55AAAA55
AA00FFAA00FFAA00FF5555FF5555FF5555FF5555FF5555FF55FF5555FF5555FF5555FF55
55FF5555FFAA00FFAA00FFAA0055000055000055005500005500005500AAFF00AAFF00AA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA55AA55FF550055AAFF55FFAA55
0055AAFF55FFAA550055FF55AA55AAFFFFFF55FF55FFFFFF55FF55FFFFFF55FF55FF55FF
FFFF55FF55FFFFFF55FF55FFFFFF00550055FF55AA5500FF55FF0055AA5500FF55FF0055
AA55FF55005500FFFFFF55FF55FFFFFF55FF55FFFFFF55FF55FF55FFFFFF55FF55FFFFFF
55FF55FFFFFFAA55AA55FF550055AAFF55FFAA550055AAFF55FFAA550055FF55AA55AAFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAA005500AA0055FF55FF5500
AA0055FF55FF5500AA005500AAAAFFFFFFFFFF555555FF555555FFFFFFFFFF555555FFFF
FFFFFF555555FF555555FFFFFFFFFF0000AA55AA00AA55FF55FF55AA00AA55FF55FF55AA
00AA55AA0000FFFFFFFFFF555555FF555555FFFFFFFFFF555555FFFFFFFFFF555555FF55
5555FFFFFFFFFFAAAA005500AA0055FF55FF5500AA0055FF55FF5500AA005500AAAAFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFF55FFAAFF55FF55FF55FF
AAFF55FF55FF55FFAAFF55FFAAFFFFFFFFFFFFFF55FFFFFF55FFFFFFFFFFFFFF55FFFFFF
FFFFFFFF55FFFFFF55FFFFFFFFFFFFFF00FF55FF00FF55FF55FF55FF00FF55FF55FF55FF
00FF55FF00FFFFFFFFFFFFFF55FFFFFF55FFFFFFFFFFFFFF55FFFFFFFFFFFFFF55FFFFFF
55FFFFFFFFFFFFFFAAFF55FFAAFF55FF55FF55FFAAFF55FF55FF55FFAAFF55FFAAFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA005500FFAAAA550000FF
AAFF000055AAAAFF005500AAFFFFFFFFFFFFFFFFFF5555FF55FF5555FF5555FF55FF5555
FF5555FF55FF5555FFFFFFFFFFFFFFFFFF00AA55AAFF000055AAAAFF00FFAAAA550000FF
AA55AA00FFFFFFFFFFFFFFFFFF5555FF55FF5555FF5555FF55FF5555FF5555FF55FF5555
FFFFFFFFFFFFFFFFFFAA005500FFAAAA550000FFAAFF000055AAAAFF005500AAFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA55005500FF55FFAA55
AA55AAFF55FF00550055AAFFFFFFFFFFFFFFFFFFFFFF55FF55FF55FFFFFF55FF55FF55FF
FFFF55FF55FF55FFFFFFFFFFFFFFFFFFFFFF0055AA55AAFF55FF0055005500FF55FFAA55
AA5500FFFFFFFFFFFFFFFFFFFFFF55FF55FF55FFFFFF55FF55FF55FFFFFF55FF55FF55FF
FFFFFFFFFFFFFFFFFFFFAA55005500FF55FFAA55AA55AAFF55FF00550055AAFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAAAAFF555555FF00
0000FF555555FFAAAAAAFFFFFFFFFFFFFFFFFFFFFFFFFF555555FFFFFFFFFF555555FFFF
FFFFFF555555FFFFFFFFFFFFFFFFFFFFFFFFFF000000FF555555FFAAAAAAFF555555FF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFF555555FFFFFFFFFF555555FFFFFFFFFF555555FFFF
FFFFFFFFFFFFFFFFFFFFFFAAAAAAFF555555FF000000FF555555FFAAAAAAFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFF55FFFFFF
00FFFFFF55FFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFF55FFFFFF
FFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF55FFFFFFAAFFFFFF55FFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFF55FFFFFFFFFFFFFF55FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFF55FFFFFF00FFFFFF55FFFFFFAAFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAAAA55AA
AAAA55AAAAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF5555FF5555FF555555FF55
55FF5555FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00AAFF000055000000550000FFAA00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF5555FF5555FF555555FF5555FF5555FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAAAA55AAAAAA55AAAAFF00AAFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA55AA555555
AA555555AA55AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FF55FFFFFF55FFFFFF
55FF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00550055555500555555005500FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FF55FFFFFF55FFFFFF55FF55FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFAA55AA555555AA555555AA55AAFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAA0055AA
00AA5500AAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF555555FF555555FF55
5555FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000AA5500AA0055AA0000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF555555FF555555FF555555FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAA0055AA00AA5500AAAAFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFF55FF
00FF55FFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFF55FFFFFF
55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF55FFAAFF55FF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFF55FFFFFF55FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFF55FF00FF55FFAAFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA0055
005500AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF5555FF55FF5555
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00AA55AA55AA00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF5555FF55FF5555FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA0055005500AAFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA55
0055AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FF55FF55FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0055AA5500FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FF55FF55FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA550055AAFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA
AAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF555555FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF555555FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFAA00FFAA00FFAA00FFAA00FFAA00FFAA00FFAA00FFAA00FFAA00FFAA00FFAA00550000
550000550000550000550000550000550000550000550000550000550055000055000055
00005500005500005500005500005500005500005500005500AAFF00AAFF00AAFF00AAFF
00AAFF00AAFF00AAFF00AAFF00AAFF00AAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFAA55AA55FF55005500FFFFFFAA55AA55FF55005500FFFFFFAA55AA55FF550055AAFF
55FFAA55005555550055AAFF55FFAA55005555550055AAFF55FFAA550055AAFF55FFAA55
005555550055AAFF55FFAA55005555550055AAFF55FFAA550055FF55AA55AAFFFFFF0055
0055FF55AA55AAFFFFFF00550055FF55AA55AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFAAAA005500AA005555FF5555AA00AA55AA0000FFFFFFFFFFAAAA005500AA0055FF
55FF5500AA0055AA0000FF555555FF0000AA5500AA0055FF55FF5500AA0055FF55FF5500
AA0055AA0000FF555555FF0000AA5500AA0055FF55FF5500AA005500AAAAFFFFFFFFFF00
00AA55AA00AA5555FF555500AA005500AAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFAAFF55FFAAFF55FFFFFF55FF00FF55FF00FFFFFFFFFFFFFFAAFF55FFAAFF55FF
55FF55FFAAFF55FF00FFFFFF55FFFFFF00FF55FFAAFF55FF55FF55FFAAFF55FF55FF55FF
AAFF55FF00FFFFFF55FFFFFF00FF55FFAAFF55FF55FF55FFAAFF55FFAAFFFFFFFFFFFFFF
00FF55FF00FF55FFFFFF55FFAAFF55FFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFAA005500FFAAAA55AAAAFF00FFAAAA55FF5555FF5555FF550000FFAAFF0000
55AAAAFF005500AAFF5555FF55FF5555FFAA005500FFAAAA550000FFAAFF000055AAAAFF
005500AAFF5555FF55FF5555FFAA005500FFAAAA550000FFAAFF000055FF5555FF5555FF
55AAAAFF00FFAAAA55AAAAFF005500AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFAA55005500FF55FF0055005500FF55FF55FFFFFF55FF55FFAA55AA55AAFF
55FF00550055AAFFFFFF55FF55FF55FFFFFFAA55005500FF55FFAA55AA55AAFF55FF0055
0055AAFFFFFF55FF55FF55FFFFFFAA55005500FF55FFAA55AA55AAFF55FF55FFFFFF55FF
55FF0055005500FF55FF00550055AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFAAAAAAFF555555FFAAAAAAFF555555FFFFFFFFFF555555FF000000FF55
5555FFAAAAAAFFFFFFFFFF555555FFFFFFFFFFAAAAAAFF555555FF000000FF555555FFAA
AAAAFFFFFFFFFF555555FFFFFFFFFFAAAAAAFF555555FF000000FF555555FFFFFFFFFF55
5555FFAAAAAAFF555555FFAAAAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFAAFFFFFF55FFFFFFAAFFFFFF55FFFFFFFFFFFFFF55FFFFFF00FFFFFF
55FFFFFFAAFFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFF55FFFFFF00FFFFFF55FFFFFF
AAFFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFF55FFFFFF00FFFFFF55FFFFFFFFFFFFFF
55FFFFFFAAFFFFFF55FFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFAA00FFAAAA55AAAA00FFAA005500005500005500AAFF00AA00FFAA
0055000055FF5555FF5555FF55FF5555FF5555FF5500005500AAFF00AA00FFAA00550000
55FF5555FF5555FF55FF5555FF5555FF5500005500AAFF00AA00FFAA0055000055000055
00AAFF00AAAA55AAAAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFAA55AA555555AA55FF550055AAFF55FFAA550055FF55AA55FF55
0055AAFF55FF55FFFFFF55FF55FF55FFFFFF55FF55FFAA550055FF55AA55FF550055AAFF
55FF55FFFFFF55FF55FF55FFFFFF55FF55FFAA550055FF55AA55FF550055AAFF55FFAA55
0055FF55AA555555AA55AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFAAAA0055AA00AA55AA0000FF555555FF0000AA55AA00AA55AA
0000FF555555FFFFFFFFFF555555FFFFFFFFFF555555FF0000AA55AA00AA55AA0000FF55
5555FFFFFFFFFF555555FFFFFFFFFF555555FF0000AA55AA00AA55AA0000FF555555FF00
00AA55AA00AA5500AAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFAAFF55FF00FF55FF00FFFFFF55FFFFFF00FF55FF00FF55FF
00FFFFFF55FFFFFFFFFFFFFF55FFFFFFFFFFFFFF55FFFFFF00FF55FF00FF55FF00FFFFFF
55FFFFFFFFFFFFFF55FFFFFFFFFFFFFF55FFFFFF00FF55FF00FF55FF00FFFFFF55FFFFFF
00FF55FF00FF55FFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFAA0055005500AAFF5555FF55FF5555FFAA0055005500AA
FF5555FF55FF5555FF5555FF55FF5555FF5555FF55FF5555FFAA0055005500AAFF5555FF
55FF5555FF5555FF55FF5555FF5555FF55FF5555FFAA0055005500AAFF5555FF55FF5555
FFAA0055005500AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFAA550055AAFFFFFF55FF55FF55FFFFFFAA550055AAFF
FFFF55FF55FF55FFFFFF55FF55FF55FFFFFF55FF55FF55FFFFFFAA550055AAFFFFFF55FF
55FF55FFFFFF55FF55FF55FFFFFF55FF55FF55FFFFFFAA550055AAFFFFFF55FF55FF55FF
FFFFAA550055AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAAAAFFFFFFFFFF555555FFFFFFFFFFAAAAAAFFFF
FFFFFF555555FFFFFFFFFF555555FFFFFFFFFF555555FFFFFFFFFFAAAAAAFFFFFFFFFF55
5555FFFFFFFFFF555555FFFFFFFFFF555555FFFFFFFFFFAAAAAAFFFFFFFFFF555555FFFF
FFFFFFAAAAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFF
FFFFFFFF55FFFFFFFFFFFFFF55FFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFFFFFFFFFF
55FFFFFFFFFFFFFF55FFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFFFFFFFFFF55FFFFFF
FFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAA00FFAA005500005500005500FFAA00
FFAA00FFAAAA55AAAA55AAAA550000550000550000FFAA00FFAA00FFAAFF00AAFF00AAFF
000055000055000055AAAA55AAAA55AAAAFF00AAFF00AAFF005500005500005500AAFF00
AAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA55AA55FF550055AAFF55FFAA55005500FF
FFFFAA55AA555555AA5500FF55FFAA5500555555005500FFFFFFAA55AA55AAFFFFFF0055
005555550055AAFF55FF0055AA555555AA55AAFFFFFF00550055AAFF55FFAA550055FF55
AA55AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAA005500AA0055FF55FF5500AA005555
FF5555AA00AA5500AAAAFF555555FF0000AA5500AA005555FF5555AA00AA5555FF555500
AA0055AA0000FF555555FFAAAA0055AA00AA5555FF555500AA0055FF55FF5500AA005500
AAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFF55FFAAFF55FF55FF55FFAAFF55FF
FFFF55FF00FF55FFAAFFFFFF55FFFFFF00FF55FFAAFF55FFFFFF55FF00FF55FFFFFF55FF
AAFF55FF00FFFFFF55FFFFFFAAFF55FF00FF55FFFFFF55FFAAFF55FF55FF55FFAAFF55FF
AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA005500FFAAAA550000FFAAFF0000
550000FFAA55AA00FF5555FF55FF5555FFAA005500FFAAAA55AAAAFF00FFAAAA55AAAAFF
005500AAFF5555FF55FF5555FF00AA55AAFF0000550000FFAAFF000055AAAAFF005500AA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA55005500FF55FFAA55AA55AAFF
55FFAA55AA5500FFFFFF55FF55FF55FFFFFFAA55005500FF55FF0055005500FF55FF0055
0055AAFFFFFF55FF55FF55FFFFFF0055AA55AAFF55FFAA55AA55AAFF55FF00550055AAFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAAAAFF555555FF000000FF55
5555FF000000FFFFFFFFFF555555FFFFFFFFFFAAAAAAFF555555FFAAAAAAFF555555FFAA
AAAAFFFFFFFFFF555555FFFFFFFFFF000000FF555555FF000000FF555555FFAAAAAAFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFF55FFFFFF00FFFFFF
55FFFFFF00FFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFF55FFFFFFAAFFFFFF55FFFFFF
AAFFFFFFFFFFFFFF55FFFFFFFFFFFFFF00FFFFFF55FFFFFF00FFFFFF55FFFFFFAAFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAAAA55AAAAAA55AA
AAFF00AAFF5555FF5555FF555555FF5555FF5555FF00AAFF000055000000550000FFAA00
FF5555FF5555FF555555FF5555FF5555FFAA00FFAAAA55AAAAAA55AAAAFF00AAFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA55AA555555AA555555
AA55AAFFFFFF55FF55FFFFFF55FFFFFF55FF55FFFFFF00550055555500555555005500FF
FFFF55FF55FFFFFF55FFFFFF55FF55FFFFFFAA55AA555555AA555555AA55AAFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAA0055AA00AA5500
AAAAFFFFFFFFFF555555FF555555FF555555FFFFFFFFFF0000AA5500AA0055AA0000FFFF
FFFFFF555555FF555555FF555555FFFFFFFFFFAAAA0055AA00AA5500AAAAFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFF55FF00FF55FF
AAFFFFFFFFFFFFFF55FFFFFF55FFFFFF55FFFFFFFFFFFFFF00FF55FFAAFF55FF00FFFFFF
FFFFFFFF55FFFFFF55FFFFFF55FFFFFFFFFFFFFFAAFF55FF00FF55FFAAFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA0055005500AA
FFFFFFFFFFFFFFFFFF5555FF55FF5555FFFFFFFFFFFFFFFFFF00AA55AA55AA00FFFFFFFF
FFFFFFFFFF5555FF55FF5555FFFFFFFFFFFFFFFFFFAA0055005500AAFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA550055AAFF
FFFFFFFFFFFFFFFFFFFF55FF55FF55FFFFFFFFFFFFFFFFFFFFFF0055AA5500FFFFFFFFFF
FFFFFFFFFFFF55FF55FF55FFFFFFFFFFFFFFFFFFFFFFAA550055AAFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAAAAFFFF
FFFFFFFFFFFFFFFFFFFFFF555555FFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF
FFFFFFFFFFFFFF555555FFFFFFFFFFFFFFFFFFFFFFFFFFAAAAAAFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA00FF
AA00FFAA00FFAA00FFAA00FFAAAA55AAAA55AAAA55AAAA55AAAA55AAAAAA55AAAA55AAAA
55AAAA55AAAA55AAAAFF00AAFF00AAFF00AAFF00AAFF00AAFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA55
AA55FF55005500FFFFFFAA55AA555555AA5500FF55FF0055AA555555AA555555AA5500FF
55FF0055AA555555AA55AAFFFFFF00550055FF55AA55AAFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA
AA005500AA005555FF5555AA00AA5500AAAAFF555555FFAAAA0055AA00AA5500AAAAFF55
5555FFAAAA0055AA00AA5555FF555500AA005500AAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
AAFF55FFAAFF55FFFFFF55FF00FF55FFAAFFFFFF55FFFFFFAAFF55FF00FF55FFAAFFFFFF
55FFFFFFAAFF55FF00FF55FFFFFF55FFAAFF55FFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFAA005500FFAAAA55AAAAFF00FFAAAA5555FF555555FF5555AAAAFF00FFAAAA5555FF55
5555FF5555AAAAFF00FFAAAA55AAAAFF005500AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFAA55005500FF55FF0055005500FF55FFFFFF55FFFFFF55FF0055005500FF55FFFFFF
55FFFFFF55FF0055005500FF55FF00550055AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFAAAAAAFF555555FFAAAAAAFF555555FF555555FF555555FFAAAAAAFF555555FF55
5555FF555555FFAAAAAAFF555555FFAAAAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFAAFFFFFF55FFFFFFAAFFFFFF55FFFFFF55FFFFFF55FFFFFFAAFFFFFF55FFFFFF
55FFFFFF55FFFFFFAAFFFFFF55FFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFAA00FFAAAA55AAAA00FFAA0055000055AAAA55AA00FFAA00AAFF00AA55AAAA
5500005500AAFF00AAAA55AAAAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFAA55AA555555AA55FF550055AAFF55FF0055AA55FF550055FF55AA5500FF
55FFAA550055FF55AA555555AA55AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFAAAA0055AA00AA55AA0000FF555555FFAAAA005500AA005500AAAAFF55
5555FF0000AA55AA00AA5500AAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFAAFF55FF00FF55FF00FFFFFF55FFFFFFAAFF55FFAAFF55FFAAFFFFFF
55FFFFFF00FF55FF00FF55FFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFAA0055005500AAFF5555FF55FF5555FF00AA55AA55AA00FF5555FF
55FF5555FFAA0055005500AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFAA550055AAFFFFFF55FF55FF55FFFFFF0055AA5500FFFFFF55FF
55FF55FFFFFFAA550055AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFAAAAAAFFFFFFFFFF555555FFFFFFFFFF000000FFFFFFFFFF55
5555FFFFFFFFFFAAAAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFF55FFFFFFFFFFFFFF00FFFFFFFFFFFFFF
55FFFFFFFFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAA00FFAA00550000550000550055000055000055
00AAFF00AAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFAA55AA55FF550055AAFF55FFAA550055AAFF55FFAA55
0055FF55AA55AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAA005500AA0055FF55FF5500AA0055FF55FF5500
AA005500AAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFF55FFAAFF55FF55FF55FFAAFF55FF55FF55FF
AAFF55FFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA005500FFAAAA550000FFAAFF000055AAAAFF
005500AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA55005500FF55FFAA55AA55AAFF55FF0055
0055AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAAAAFF555555FF000000FF555555FFAA
AAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFF55FFFFFF00FFFFFF55FFFFFF
AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAAAA55AAAAAA55AAAAFF00AA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA55AA555555AA555555AA55AAFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAA0055AA00AA5500AAAAFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFF55FF00FF55FFAAFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA0055005500AAFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA550055AAFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAAAAAFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell["\<\
The function is given a second argument, equal to the step number. \
\
\>", "MathCaption",
  CellTags->{"S3.8.6", "6.27"}],

Cell[CellGroupData[{

Cell["\<\
ArrayPlot[CellularAutomaton[ {Mod[Apply[Plus, #] + #2, 4]&, {}, 1}, \
{{1}, 0}, 100]]\
\>", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .50249 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00473821 0.011964 0.00473821 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .50249 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .50249 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .50249 L
s
0 .50249 m
1 .50249 L
s
1 0 m
1 .50249 L
s
0 0 m
1 0 L
1 .50249 L
0 .50249 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01196 translate
.95238 .47856 scale
201 string
201 101 8 [201 0 0 101 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0055FF55AA55FF550055555555555555FF555555FF555555FF555555555555550055FF55
AA55FF550055555555555555FF555555FF555555FF55555555555555FF555555FF555555
FF55555555555555FF555555FF555555FF555555555555550055FF55AA55FF5500555555
55555555FF555555FF555555FF55555555555555FF555555FF555555FF55555555555555
FF555555FF555555FF555555555555550055FF55AA55FF550055555555555555FF555555
FF555555FF555555555555550055FF55AA55FF5500
5500AAFFAAFFAA00555555555555555555FFFF55FF55FFFF55555555555555555500AAFF
AAFFAA00555555555555555555FFFF55FF55FFFF555555555555555555FFFF55FF55FFFF
555555555555555555FFFF55FF55FFFF55555555555555555500AAFFAAFFAA0055555555
5555555555FFFF55FF55FFFF555555555555555555FFFF55FF55FFFF5555555555555555
55FFFF55FF55FFFF55555555555555555500AAFFAAFFAA00555555555555555555FFFF55
FF55FFFF55555555555555555500AAFFAAFFAA0055
AAAA5500FF0055AAAAAAAAAAAAAAAAAAAAAA00AA00AA00AAAAAAAAAAAAAAAAAAAAAA5500
FF0055AAAAAAAAAAAAAAAAAAAAAA00AA00AA00AAAAAAAAAAAAAAAAAAAAAA00AA00AA00AA
AAAAAAAAAAAAAAAAAAAA00AA00AA00AAAAAAAAAAAAAAAAAAAAAA5500FF0055AAAAAAAAAA
AAAAAAAAAAAA00AA00AA00AAAAAAAAAAAAAAAAAAAAAA00AA00AA00AAAAAAAAAAAAAAAAAA
AAAA00AA00AA00AAAAAAAAAAAAAAAAAAAAAA5500FF0055AAAAAAAAAAAAAAAAAAAAAA00AA
00AA00AAAAAAAAAAAAAAAAAAAAAA5500FF0055AAAA
AAAAAA555555AAAAAAAAAAAAAAAAAAAAAAAAAA000000AAAAAAAAAAAAAAAAAAAAAAAAAA55
5555AAAAAAAAAAAAAAAAAAAAAAAAAA000000AAAAAAAAAAAAAAAAAAAAAAAAAA000000AAAA
AAAAAAAAAAAAAAAAAAAAAA000000AAAAAAAAAAAAAAAAAAAAAAAAAA555555AAAAAAAAAAAA
AAAAAAAAAAAAAA000000AAAAAAAAAAAAAAAAAAAAAAAAAA000000AAAAAAAAAAAAAAAAAAAA
AAAAAA000000AAAAAAAAAAAAAAAAAAAAAAAAAA555555AAAAAAAAAAAAAAAAAAAAAAAAAA00
0000AAAAAAAAAAAAAAAAAAAAAAAAAA555555AAAAAA
FFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFF
FFFFFFFFFFAA00FFAA00FFAA00FFAA00FFAA00FFAAAA55AAAA55AAAA55AAAA55AAAA55AA
AA00FFAA00FFAA00FFAA00FFAA00FFAA0055000055000055000055000055000055AAAA55
AAAA55AAAA55AAAA55AAAA55AA00FFAA00FFAA00FFAA00FFAA00FFAA00AAFF00AAFF00AA
FF00AAFF00AAFF00AA55AAAA55AAAA55AAAA55AAAA55AAAA550000550000550000550000
5500005500AAFF00AAFF00AAFF00AAFF00AAFF00AAAA55AAAA55AAAA55AAAA55AAAA55AA
AAFF00AAFF00AAFF00AAFF00AAFF00AAFFFFFFFFFF
000000000000FFAAFFAA00AA55AA55000000FFAAFFAAAAAAFFAA5500AA0055AAFFAAAAAA
FFAA00AA55AA55000000FFAAFFAA00AA55AAFF00AA00FFAA55AAAAAA55AAFF00AA0055AA
FFAAAAAAFFAA5500AA0055AAFFAA00AA55AA55000000FFAAFFAA00AA55AA00AAFFAAFF00
000055AA55AA00AAFFAA5500AA0055AAFFAAAAAAFFAA5500AA00FFAA55AAAAAA55AAFF00
AA00FFAA55AA00AAFFAAFF00000055AA55AA00AAFFAAAAAAFFAA5500AA0055AAFFAAAAAA
FFAAFF00000055AA55AA00AAFFAAFF000000000000
00000000000000FFFF55AA55FF55AAAA00AAAAFF55FFAA55FFFF00AAAAAA00FFFF55AAFF
55FFAAFF55550000000000FFFF55AA55FF55AA00AA00AA55FF55AAFF555500AAAAAA00FF
FF55AAFF55FFAA00AA00AAFF55FFAAFF55550000000000FFFF55AA55FF55AA55FFFF0000
0000005555FFAAFF55FFAA00AA00AAFF55FFAA55FFFF00AAAAAA005555FFAA55FF55AA00
AA00AA55FF55AA55FFFF00000000005555FFAAFF55FFAA55FFFF00AAAAAA00FFFF55AAFF
55FFAAAA00AAAA55FF55AA55FFFF00000000000000
55555555555555550055FF550055FF555555FF55AA55FF5500555555FF5555550055FF55
AA55FF55AA555555555555550055FF550055FF55FF55FF550055FF55AA555555FF555555
0055FF55AA55FF55FF55FF55AA55FF55AA555555555555550055FF550055FF5500555555
55555555AA55FF55AA55FF55FF55FF55AA55FF5500555555FF555555AA55FF550055FF55
FF55FF550055FF550055555555555555AA55FF55AA55FF5500555555FF5555550055FF55
AA55FF555555FF550055FF55005555555555555555
55555555555555555500AAFFAA550000FF000055AA550000FFFF55FFFFFF55FFFF000055
AA550000FF55FFFF55FFFF55FFAAAA550055AAAAFF000055AAFFAA0055FFFF55FF55FFFF
55AA00FF0055AAAAFF000055AA550000FF55FFFF55FFFF55FFAAAA550055AAAAFF55FFFF
55FFFF55FF000055AA550000FFAAAA5500FF00AA55FFFF55FF55FFFF5500AAFFAA550000
FFAAAA550055AAAAFF55FFFF55FFFF55FF000055AA550000FFFF55FFFFFF55FFFF000055
AA550000FF000055AAFFAA00555555555555555555
AAAAAAAAAAAAAAAAAAAA5500FF00FFAA00AAFF00FF00FFAA00AAAAAA00AAAAAA00AAFF00
FF00FFAA00AA00AAAAAA00AA00AA5500550055AA00AAFF00FF0055AAAAAA00AA00AA00AA
AAAAFF00550055AA00AAFF00FF00FFAA00AA00AAAAAA00AA00AA5500550055AA00AA00AA
AAAA00AA00AAFF00FF00FFAA00AA55005500FFAAAAAA00AA00AA00AAAAAA5500FF00FFAA
00AA5500550055AA00AA00AAAAAA00AA00AAFF00FF00FFAA00AAAAAA00AAAAAA00AAFF00
FF00FFAA00AAFF00FF0055AAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA555555AA000000AA555555AA000000AA000000AA000000AA55
5555AA000000AAAAAAAAAA000000AAFFFFFFAA000000AA555555AAAAAAAAAA000000AAAA
AAAAAAFFFFFFAA000000AA555555AA000000AAAAAAAAAA000000AAFFFFFFAA000000AAAA
AAAAAA000000AA555555AA000000AAFFFFFFAAAAAAAAAA000000AAAAAAAAAA555555AA00
0000AAFFFFFFAA000000AAAAAAAAAA000000AA555555AA000000AA000000AA000000AA55
5555AA000000AA555555AAAAAAAAAAAAAAAAAAAAAA
FFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFF55FFFFFFAAFFFFFF55FFFFFF55FFFFFF55FFFFFF
AAFFFFFF55FFFFFFFFFFFFFF55FFFFFF00FFFFFF55FFFFFFAAFFFFFFFFFFFFFF55FFFFFF
FFFFFFFF00FFFFFF55FFFFFFAAFFFFFF55FFFFFFFFFFFFFF55FFFFFF00FFFFFF55FFFFFF
FFFFFFFF55FFFFFFAAFFFFFF55FFFFFF00FFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFF
55FFFFFF00FFFFFF55FFFFFFFFFFFFFF55FFFFFFAAFFFFFF55FFFFFF55FFFFFF55FFFFFF
AAFFFFFF55FFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAAAA55AAAA00FFAA0055000055AAAA55AA00FFAA
00AAFF00AA55AAAA55AAAA55AA00FFAA0000550000FFAA00FF5555FF5555FF555555FF55
55FF5555FFAA00FFAAAA55AAAA00FFAA005500005500005500AAFF00AA00FFAA00550000
5500005500AAFF00AAAA55AAAAFF00AAFF5555FF5555FF555555FF5555FF5555FF00AAFF
0000550000AAFF00AA55AAAA55AAAA55AA00FFAA00AAFF00AA55AAAA5500005500AAFF00
AAAA55AAAAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFF
0000000000000000000000000000FFAAFFAAAAAAFFAA00AA55AAFF00AA0055AAFFAA00AA
55AA00AAFFAA5500AA0055AAFFAA00AA55AAAAAA55AA55000000AA00AA000000AA000000
AA00AA000000FFAAFFAAAAAAFFAA00AA55AAFF00AA00FFAA55AA00AAFFAA00AA55AAFF00
AA00FFAA55AA00AAFFAAAAAAFFAAFF000000AA00AA000000AA000000AA00AA00000055AA
55AAAAAA55AA00AAFFAA5500AA0055AAFFAA00AA55AA00AAFFAA5500AA00FFAA55AA00AA
FFAAAAAAFFAAFF0000000000000000000000000000
000000000000000000000000000000FFFF55AAFF55FFAAFF555500AAAAAA00FFFF55AA55
FF55AA55FFFF00AAAAAA00FFFF55AA55FF55AAFF55550000000000AAAAAA00AAAAAA00AA
AAAA0000000000FFFF55AAFF55FFAAFF555500AAAAAA005555FFAAFF55FFAAFF555500AA
AAAA005555FFAAFF55FFAA55FFFF0000000000AAAAAA00AAAAAA00AAAAAA000000000055
55FFAA55FF55AA55FFFF00AAAAAA00FFFF55AA55FF55AA55FFFF00AAAAAA005555FFAAFF
55FFAA55FFFF000000000000000000000000000000
555555555555555555555555555555550055FF55AA55FF55AA555555FF5555550055FF55
0055FF5500555555FF5555550055FF550055FF55AA55555555555555FF555555FF555555
FF555555555555550055FF55AA55FF55AA555555FF555555AA55FF55AA55FF55AA555555
FF555555AA55FF55AA55FF550055555555555555FF555555FF555555FF55555555555555
AA55FF550055FF5500555555FF5555550055FF550055FF5500555555FF555555AA55FF55
AA55FF550055555555555555555555555555555555
555555555555555555555555555555555500AAFFAAFFAA0055FFFF55FF55FFFF55AA00FF
00FF00AA55FFFF55FF55FFFF55AA00FF00FF00AA555555555555555555FFFF55FF55FFFF
55555555555555555500AAFFAAFFAA0055FFFF55FF55FFFF5500AAFFAAFFAA0055FFFF55
FF55FFFF5500AAFFAAFFAA00555555555555555555FFFF55FF55FFFF5555555555555555
55AA00FF00FF00AA55FFFF55FF55FFFF55AA00FF00FF00AA55FFFF55FF55FFFF5500AAFF
AAFFAA005555555555555555555555555555555555
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA5500FF0055AAAAAA00AA00AA00AAAAAAFF00
5500FFAAAAAA00AA00AA00AAAAAAFF005500FFAAAAAAAAAAAAAAAAAAAAAA00AA00AA00AA
AAAAAAAAAAAAAAAAAAAA5500FF0055AAAAAA00AA00AA00AAAAAA5500FF0055AAAAAA00AA
00AA00AAAAAA5500FF0055AAAAAAAAAAAAAAAAAAAAAA00AA00AA00AAAAAAAAAAAAAAAAAA
AAAAFF005500FFAAAAAA00AA00AA00AAAAAAFF005500FFAAAAAA00AA00AA00AAAAAA5500
FF0055AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA555555AAAAAAAAAA000000AAAAAAAAAAFF
FFFFAAAAAAAAAA000000AAAAAAAAAAFFFFFFAAAAAAAAAAAAAAAAAAAAAAAAAA000000AAAA
AAAAAAAAAAAAAAAAAAAAAA555555AAAAAAAAAA000000AAAAAAAAAA555555AAAAAAAAAA00
0000AAAAAAAAAA555555AAAAAAAAAAAAAAAAAAAAAAAAAA000000AAAAAAAAAAAAAAAAAAAA
AAAAAAFFFFFFAAAAAAAAAA000000AAAAAAAAAAFFFFFFAAAAAAAAAA000000AAAAAAAAAA55
5555AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFF55FFFFFFFFFFFFFF
00FFFFFFFFFFFFFF55FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFFFFFFFFFF
55FFFFFFFFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF55FFFFFFFFFFFFFF00FFFFFFFFFFFFFF55FFFFFFFFFFFFFF
AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAA00FFAA0055000055000055
005500005500005500AAFF00AAFF00AAFF5555FF5555FF5555FF5555FF5555FF55FF5555
FF5555FF5555FF5555FF5555FF00AAFF00AAFF00AA55AAAA55AAAA55AA55AAAA55AAAA55
AA00FFAA00FFAA00FF5555FF5555FF5555FF5555FF5555FF55FF5555FF5555FF5555FF55
55FF5555FFAA00FFAA00FFAA0055000055000055005500005500005500AAFF00AAFF00AA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000000000000000000000000000000000000000FFAAFFAA00AA55AAFF00AA00FFAA
55AAFF00AA00FFAA55AA00AAFFAAFF000000AA00AA000000AA00AA000000AA00AA00AA00
0000AA00AA000000AA00AA00000055AA55AA00AAFFAA5500AA0055AAFFAA5500AA0055AA
FFAA00AA55AA55000000AA00AA000000AA00AA000000AA00AA00AA000000AA00AA000000
AA00AA000000FFAAFFAA00AA55AAFF00AA00FFAA55AAFF00AA00FFAA55AA00AAFFAAFF00
000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000FFFF55AA55FF55AA00AA00AA55
FF55AA00AA00AA55FF55AA55FFFF0000000000AAAAAA00AAAAAA0000000000AAAAAA0000
000000AAAAAA00AAAAAA00000000005555FFAAFF55FFAA00AA00AAFF55FFAA00AA00AAFF
55FFAAFF55550000000000AAAAAA00AAAAAA0000000000AAAAAA0000000000AAAAAA00AA
AAAA0000000000FFFF55AA55FF55AA00AA00AA55FF55AA00AA00AA55FF55AA55FFFF0000
000000000000000000000000000000000000000000
5555555555555555555555555555555555555555555555550055FF550055FF55FF55FF55
0055FF55FF55FF550055FF550055555555555555FF555555FF55555555555555FF555555
55555555FF555555FF55555555555555AA55FF55AA55FF55FF55FF55AA55FF55FF55FF55
AA55FF55AA55555555555555FF555555FF55555555555555FF55555555555555FF555555
FF555555555555550055FF550055FF55FF55FF550055FF55FF55FF550055FF5500555555
555555555555555555555555555555555555555555
5555555555555555555555555555555555555555555555555500AAFFAA550000FFAAAA55
0055AAAAFF000055AAFFAA00555555555555555555FFFF55FF55FFFF55FFFF55FF55FFFF
55FFFF55FF55FFFF555555555555555555AA00FF0055AAAAFF000055AA550000FFAAAA55
00FF00AA555555555555555555FFFF55FF55FFFF55FFFF55FF55FFFF55FFFF55FF55FFFF
55555555555555555500AAFFAA550000FFAAAA550055AAAAFF000055AAFFAA0055555555
555555555555555555555555555555555555555555
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA5500FF00FFAA00AA5500
550055AA00AAFF00FF0055AAAAAAAAAAAAAAAAAAAAAA00AA00AA00AAAAAA00AA00AA00AA
AAAA00AA00AA00AAAAAAAAAAAAAAAAAAAAAAFF00550055AA00AAFF00FF00FFAA00AA5500
5500FFAAAAAAAAAAAAAAAAAAAAAA00AA00AA00AAAAAA00AA00AA00AAAAAA00AA00AA00AA
AAAAAAAAAAAAAAAAAAAA5500FF00FFAA00AA5500550055AA00AAFF00FF0055AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA555555AA000000AAFF
FFFFAA000000AA555555AAAAAAAAAAAAAAAAAAAAAAAAAA000000AAAAAAAAAA000000AAAA
AAAAAA000000AAAAAAAAAAAAAAAAAAAAAAAAAAFFFFFFAA000000AA555555AA000000AAFF
FFFFAAAAAAAAAAAAAAAAAAAAAAAAAA000000AAAAAAAAAA000000AAAAAAAAAA000000AAAA
AAAAAAAAAAAAAAAAAAAAAA555555AA000000AAFFFFFFAA000000AA555555AAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFF55FFFFFF
00FFFFFF55FFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFF55FFFFFF
FFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF55FFFFFFAAFFFFFF55FFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFF55FFFFFFFFFFFFFF55FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFF55FFFFFF00FFFFFF55FFFFFFAAFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAAAA55AA
AAAA55AAAAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF5555FF5555FF555555FF55
55FF5555FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00AAFF000055000000550000FFAA00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF5555FF5555FF555555FF5555FF5555FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAAAA55AAAAAA55AAAAFF00AAFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000000000000000FFAAFFAAAAAA
FFAAAAAAFFAAFF00000000000000000000000000000000000000AA00AA000000AA000000
AA00AA0000000000000000000000000000000000000055AA55AAAAAA55AAAAAA55AA5500
000000000000000000000000000000000000AA00AA000000AA000000AA00AA0000000000
0000000000000000000000000000FFAAFFAAAAAAFFAAAAAAFFAAFF000000000000000000
000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000FFFF55AAFF
55FFAA55FFFF000000000000000000000000000000000000000000AAAAAA00AAAAAA00AA
AAAA0000000000000000000000000000000000000000005555FFAA55FF55AAFF55550000
00000000000000000000000000000000000000AAAAAA00AAAAAA00AAAAAA000000000000
000000000000000000000000000000FFFF55AAFF55FFAA55FFFF00000000000000000000
000000000000000000000000000000000000000000
55555555555555555555555555555555555555555555555555555555555555550055FF55
AA55FF55005555555555555555555555555555555555555555555555FF555555FF555555
FF5555555555555555555555555555555555555555555555AA55FF550055FF55AA555555
5555555555555555555555555555555555555555FF555555FF555555FF55555555555555
555555555555555555555555555555550055FF55AA55FF55005555555555555555555555
555555555555555555555555555555555555555555
55555555555555555555555555555555555555555555555555555555555555555500AAFF
AAFFAA0055555555555555555555555555555555555555555555555555FFFF55FF55FFFF
55555555555555555555555555555555555555555555555555AA00FF00FF00AA55555555
555555555555555555555555555555555555555555FFFF55FF55FFFF5555555555555555
555555555555555555555555555555555500AAFFAAFFAA00555555555555555555555555
555555555555555555555555555555555555555555
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA5500
FF0055AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA00AA00AA00AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFF005500FFAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA00AA00AA00AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA5500FF0055AAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA55
5555AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA000000AAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFFFFFFAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA000000AAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA555555AAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFAA00FFAA00FFAA00FFAA00FFAA00FFAA00FFAA00FFAA00FFAA00FFAA00FFAA00550000
550000550000550000550000550000550000550000550000550000550055000055000055
00005500005500005500005500005500005500005500005500AAFF00AAFF00AAFF00AAFF
00AAFF00AAFF00AAFF00AAFF00AAFF00AAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
0000FFAAFFAA00AA55AA55000000FFAAFFAA00AA55AA55000000FFAAFFAA00AA55AAFF00
AA00FFAA55AAAAAA55AAFF00AA00FFAA55AAAAAA55AAFF00AA00FFAA55AAFF00AA00FFAA
55AAAAAA55AAFF00AA00FFAA55AAAAAA55AAFF00AA00FFAA55AA00AAFFAAFF00000055AA
55AA00AAFFAAFF00000055AA55AA00AAFFAAFF0000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000FFFF55AA55FF55AAAA00AAAAFF55FFAAFF55550000000000FFFF55AA55FF55AA00
AA00AA55FF55AAFF555500AAAAAA005555FFAA55FF55AA00AA00AA55FF55AA00AA00AA55
FF55AAFF555500AAAAAA005555FFAA55FF55AA00AA00AA55FF55AA55FFFF000000000055
55FFAAFF55FFAAAA00AAAA55FF55AA55FFFF000000000000000000000000000000000000
000000000000000000000000000000000000000000
555555555555555555555555555555555555555555555555555555555555555555555555
555555550055FF550055FF555555FF55AA55FF55AA555555555555550055FF550055FF55
FF55FF550055FF55AA555555FF555555AA55FF550055FF55FF55FF550055FF55FF55FF55
0055FF55AA555555FF555555AA55FF550055FF55FF55FF550055FF550055555555555555
AA55FF55AA55FF555555FF550055FF550055555555555555555555555555555555555555
555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555500AAFFAA550000FF000055AA550000FF55FFFF55FFFF55FFAAAA550055AAAA
FF000055AAFFAA0055FFFF55FF55FFFF5500AAFFAA550000FFAAAA550055AAAAFF000055
AAFFAA0055FFFF55FF55FFFF5500AAFFAA550000FFAAAA550055AAAAFF55FFFF55FFFF55
FF000055AA550000FF000055AAFFAA005555555555555555555555555555555555555555
555555555555555555555555555555555555555555
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAA5500FF00FFAA00AAFF00FF00FFAA00AA00AAAAAA00AA00AA5500550055AA
00AAFF00FF0055AAAAAA00AA00AA00AAAAAA5500FF00FFAA00AA5500550055AA00AAFF00
FF0055AAAAAA00AA00AA00AAAAAA5500FF00FFAA00AA5500550055AA00AA00AAAAAA00AA
00AAFF00FF00FFAA00AAFF00FF0055AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAA555555AA000000AA555555AA000000AAAAAAAAAA000000AAFFFFFFAA00
0000AA555555AAAAAAAAAA000000AAAAAAAAAA555555AA000000AAFFFFFFAA000000AA55
5555AAAAAAAAAA000000AAAAAAAAAA555555AA000000AAFFFFFFAA000000AAAAAAAAAA00
0000AA555555AA000000AA555555AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFAAFFFFFF55FFFFFFAAFFFFFF55FFFFFFFFFFFFFF55FFFFFF00FFFFFF
55FFFFFFAAFFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFF55FFFFFF00FFFFFF55FFFFFF
AAFFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFF55FFFFFF00FFFFFF55FFFFFFFFFFFFFF
55FFFFFFAAFFFFFF55FFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFAA00FFAAAA55AAAA00FFAA005500005500005500AAFF00AA00FFAA
0055000055FF5555FF5555FF55FF5555FF5555FF5500005500AAFF00AA00FFAA00550000
55FF5555FF5555FF55FF5555FF5555FF5500005500AAFF00AA00FFAA0055000055000055
00AAFF00AAAA55AAAAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000FFAAFFAAAAAAFFAA00AA55AAFF00AA00FFAA55AA00AAFFAA00AA
55AAFF00AA00AA000000AA00AA00AA000000AA00AA00FFAA55AA00AAFFAA00AA55AAFF00
AA00AA000000AA00AA00AA000000AA00AA00FFAA55AA00AAFFAA00AA55AAFF00AA00FFAA
55AA00AAFFAAAAAAFFAAFF00000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000FFFF55AAFF55FFAAFF555500AAAAAA005555FFAAFF55FFAAFF
555500AAAAAA0000000000AAAAAA0000000000AAAAAA005555FFAAFF55FFAAFF555500AA
AAAA0000000000AAAAAA0000000000AAAAAA005555FFAAFF55FFAAFF555500AAAAAA0055
55FFAAFF55FFAA55FFFF0000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
555555555555555555555555555555555555555555555555555555555555555555555555
5555555555555555555555550055FF55AA55FF55AA555555FF555555AA55FF55AA55FF55
AA555555FF55555555555555FF55555555555555FF555555AA55FF55AA55FF55AA555555
FF55555555555555FF55555555555555FF555555AA55FF55AA55FF55AA555555FF555555
AA55FF55AA55FF5500555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
5555555555555555555555555500AAFFAAFFAA0055FFFF55FF55FFFF5500AAFFAAFFAA00
55FFFF55FF55FFFF55FFFF55FF55FFFF55FFFF55FF55FFFF5500AAFFAAFFAA0055FFFF55
FF55FFFF55FFFF55FF55FFFF55FFFF55FF55FFFF5500AAFFAAFFAA0055FFFF55FF55FFFF
5500AAFFAAFFAA0055555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAA5500FF0055AAAAAA00AA00AA00AAAAAA5500FF0055AA
AAAA00AA00AA00AAAAAA00AA00AA00AAAAAA00AA00AA00AAAAAA5500FF0055AAAAAA00AA
00AA00AAAAAA00AA00AA00AAAAAA00AA00AA00AAAAAA5500FF0055AAAAAA00AA00AA00AA
AAAA5500FF0055AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA555555AAAAAAAAAA000000AAAAAAAAAA555555AAAA
AAAAAA000000AAAAAAAAAA000000AAAAAAAAAA000000AAAAAAAAAA555555AAAAAAAAAA00
0000AAAAAAAAAA000000AAAAAAAAAA000000AAAAAAAAAA555555AAAAAAAAAA000000AAAA
AAAAAA555555AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFF
FFFFFFFF55FFFFFFFFFFFFFF55FFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFFFFFFFFFF
55FFFFFFFFFFFFFF55FFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFFFFFFFFFF55FFFFFF
FFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAA00FFAA005500005500005500FFAA00
FFAA00FFAAAA55AAAA55AAAA550000550000550000FFAA00FFAA00FFAAFF00AAFF00AAFF
000055000055000055AAAA55AAAA55AAAAFF00AAFF00AAFF005500005500005500AAFF00
AAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000FFAAFFAA00AA55AAFF00AA00FFAA55AA5500
0000FFAAFFAAAAAAFFAA5500AA00FFAA55AAAAAA55AA55000000FFAAFFAAFF00000055AA
55AAAAAA55AAFF00AA0055AAFFAAAAAAFFAAFF00000055AA55AAFF00AA00FFAA55AA00AA
FFAAFF000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000FFFF55AA55FF55AA00AA00AA55FF55AAAA
00AAAAFF55FFAA55FFFF00AAAAAA005555FFAA55FF55AAAA00AAAAFF55FFAAAA00AAAA55
FF55AAFF555500AAAAAA00FFFF55AAFF55FFAAAA00AAAA55FF55AA00AA00AA55FF55AA55
FFFF00000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
555555555555555555555555555555555555555555555555555555555555555555555555
55555555555555555555555555555555555555550055FF550055FF55FF55FF550055FF55
5555FF55AA55FF5500555555FF555555AA55FF550055FF555555FF55AA55FF555555FF55
0055FF55AA555555FF5555550055FF55AA55FF555555FF550055FF55FF55FF550055FF55
005555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
55555555555555555555555555555555555555555500AAFFAA550000FFAAAA550055AAAA
FFAAAA5500FF00AA55FFFF55FF55FFFF5500AAFFAA550000FF000055AA550000FF000055
AAFFAA0055FFFF55FF55FFFF55AA00FF0055AAAAFFAAAA550055AAAAFF000055AAFFAA00
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA5500FF00FFAA00AA5500550055AA
00AA55005500FFAAAAAA00AA00AA00AAAAAA5500FF00FFAA00AAFF00FF00FFAA00AAFF00
FF0055AAAAAA00AA00AA00AAAAAAFF00550055AA00AA5500550055AA00AAFF00FF0055AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA555555AA000000AAFFFFFFAA00
0000AAFFFFFFAAAAAAAAAA000000AAAAAAAAAA555555AA000000AA555555AA000000AA55
5555AAAAAAAAAA000000AAAAAAAAAAFFFFFFAA000000AAFFFFFFAA000000AA555555AAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFF55FFFFFF00FFFFFF
55FFFFFF00FFFFFFFFFFFFFF55FFFFFFFFFFFFFFAAFFFFFF55FFFFFFAAFFFFFF55FFFFFF
AAFFFFFFFFFFFFFF55FFFFFFFFFFFFFF00FFFFFF55FFFFFF00FFFFFF55FFFFFFAAFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAAAA55AAAAAA55AA
AAFF00AAFF5555FF5555FF555555FF5555FF5555FF00AAFF000055000000550000FFAA00
FF5555FF5555FF555555FF5555FF5555FFAA00FFAAAA55AAAAAA55AAAAFF00AAFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000FFAAFFAAAAAAFFAAAAAA
FFAAFF000000AA00AA000000AA000000AA00AA00000055AA55AAAAAA55AAAAAA55AA5500
0000AA00AA000000AA000000AA00AA000000FFAAFFAAAAAAFFAAAAAAFFAAFF0000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FFFF55AAFF55FFAA55
FFFF0000000000AAAAAA00AAAAAA00AAAAAA00000000005555FFAA55FF55AAFF55550000
000000AAAAAA00AAAAAA00AAAAAA0000000000FFFF55AAFF55FFAA55FFFF000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555550055FF55AA55FF55
0055555555555555FF555555FF555555FF55555555555555AA55FF550055FF55AA555555
55555555FF555555FF555555FF555555555555550055FF55AA55FF550055555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555500AAFFAAFFAA00
555555555555555555FFFF55FF55FFFF555555555555555555AA00FF00FF00AA55555555
5555555555FFFF55FF55FFFF55555555555555555500AAFFAAFFAA005555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA5500FF0055AA
AAAAAAAAAAAAAAAAAAAA00AA00AA00AAAAAAAAAAAAAAAAAAAAAAFF005500FFAAAAAAAAAA
AAAAAAAAAAAA00AA00AA00AAAAAAAAAAAAAAAAAAAAAA5500FF0055AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA555555AAAA
AAAAAAAAAAAAAAAAAAAAAA000000AAAAAAAAAAAAAAAAAAAAAAAAAAFFFFFFAAAAAAAAAAAA
AAAAAAAAAAAAAA000000AAAAAAAAAAAAAAAAAAAAAAAAAA555555AAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF55FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA00FF
AA00FFAA00FFAA00FFAA00FFAAAA55AAAA55AAAA55AAAA55AAAA55AAAAAA55AAAA55AAAA
55AAAA55AAAA55AAAAFF00AAFF00AAFF00AAFF00AAFF00AAFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000FFAA
FFAA00AA55AA55000000FFAAFFAAAAAAFFAA5500AA0055AAFFAAAAAAFFAAAAAAFFAA5500
AA0055AAFFAAAAAAFFAAFF00000055AA55AA00AAFFAAFF00000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000FF
FF55AA55FF55AAAA00AAAAFF55FFAA55FFFF00AAAAAA00FFFF55AAFF55FFAA55FFFF00AA
AAAA00FFFF55AAFF55FFAAAA00AAAA55FF55AA55FFFF0000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
0055FF550055FF555555FF55AA55FF5500555555FF5555550055FF55AA55FF5500555555
FF5555550055FF55AA55FF555555FF550055FF5500555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
5500AAFFAA550000FF000055AA550000FFFF55FFFFFF55FFFF000055AA550000FFFF55FF
FFFF55FFFF000055AA550000FF000055AAFFAA0055555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAA5500FF00FFAA00AAFF00FF00FFAA00AAAAAA00AAAAAA00AAFF00FF00FFAA00AAAAAA
00AAAAAA00AAFF00FF00FFAA00AAFF00FF0055AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAA555555AA000000AA555555AA000000AA000000AA000000AA555555AA000000AA00
0000AA000000AA555555AA000000AA555555AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFAAFFFFFF55FFFFFFAAFFFFFF55FFFFFF55FFFFFF55FFFFFFAAFFFFFF55FFFFFF
55FFFFFF55FFFFFFAAFFFFFF55FFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFAA00FFAAAA55AAAA00FFAA0055000055AAAA55AA00FFAA00AAFF00AA55AAAA
5500005500AAFF00AAAA55AAAAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000FFAAFFAAAAAAFFAA00AA55AAFF00AA0055AAFFAA00AA55AA00AAFFAA5500
AA00FFAA55AA00AAFFAAAAAAFFAAFF000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000FFFF55AAFF55FFAAFF555500AAAAAA00FFFF55AA55FF55AA55FFFF00AA
AAAA005555FFAAFF55FFAA55FFFF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
55555555555555550055FF55AA55FF55AA555555FF5555550055FF550055FF5500555555
FF555555AA55FF55AA55FF55005555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
55555555555555555500AAFFAAFFAA0055FFFF55FF55FFFF55AA00FF00FF00AA55FFFF55
FF55FFFF5500AAFFAAFFAA00555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAA5500FF0055AAAAAA00AA00AA00AAAAAAFF005500FFAAAAAA00AA
00AA00AAAAAA5500FF0055AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA555555AAAAAAAAAA000000AAAAAAAAAAFFFFFFAAAAAAAAAA00
0000AAAAAAAAAA555555AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFF55FFFFFFFFFFFFFF00FFFFFFFFFFFFFF
55FFFFFFFFFFFFFFAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAA00FFAA00550000550000550055000055000055
00AAFF00AAFF00AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000FFAAFFAA00AA55AAFF00AA00FFAA55AAFF00AA00FFAA
55AA00AAFFAAFF0000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFF55AA55FF55AA00AA00AA55FF55AA00AA00AA55
FF55AA55FFFF000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555550055FF550055FF55FF55FF550055FF55FF55FF55
0055FF550055555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555500AAFFAA550000FFAAAA550055AAAAFF000055
AAFFAA005555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA5500FF00FFAA00AA5500550055AA00AAFF00
FF0055AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA555555AA000000AAFFFFFFAA000000AA55
5555AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFF55FFFFFF00FFFFFF55FFFFFF
AAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAA00FFAAAA55AAAAAA55AAAAFF00AA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FFAAFFAAAAAAFFAAAAAAFFAAFF00
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000FFFF55AAFF55FFAA55FFFF0000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
5555555555555555555555555555555555555555555555550055FF55AA55FF5500555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
5555555555555555555555555555555555555555555555555500AAFFAAFFAA0055555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA5500FF0055AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA555555AAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAAFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell["\<\
When you specify rules by functions, the values of cells need not \
be integers.  \
\>", "MathCaption",
  CellTags->{"S3.8.6", "6.28"}],

Cell[CellGroupData[{

Cell["\<\
ArrayPlot[CellularAutomaton[ {Mod[1/2 Apply[Plus, #], 1] &, {}, 1}, \
{{1}, 0}, 100]]\
\>", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .50249 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00473821 0.011964 0.00473821 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .50249 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .50249 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .50249 L
s
0 .50249 m
1 .50249 L
s
1 0 m
1 .50249 L
s
0 0 m
1 0 L
1 .50249 L
0 .50249 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01196 translate
.95238 .47856 scale
201 string
201 101 8 [201 0 0 101 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFAEDCA7A3508
27434327EBC3A0B3EC1B2F282426242F4D584068A2F79944D7D6BEB8FE696502AAE65BB0
DFA540D1AEABBD2595D2B0490AD1364C5D22290DDB1A7A6F24FB5EA3B8A35EFB246F7A1A
DB0D29225D4C36D10A49B0D29525BDABAED140A5DFB05BE6AA026569FEB8BED6D74499F7
A26840584D2F242624282F1BECB3A0C3EB2743432708357ACAEDFAFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF7E5B7575B
5E94935D5E1B0D17427F746A716D6D6D83AB8253FBF5FE3F4B243C1B19C8F211014289EA
ECE7762209311B2EFFFCA8BC2D2B49F7576A8166321DE4F3074DA2CCD7CCA24D07F3E41D
3266816A57F7492B2DBCA8FCFF2E1B31092276E7ECEA89420111F2C8191B3C244B3FFEF5
FB5382AB836D6D6D716A747F42170D1B5E5D93945E5B57B7E5F7FDFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFCF3DB9F34
E2A4A1E039A25B1DB5B2979F9EA3979FA2C3F05165404576C25E26F31D225071602FF4ED
F3F7E4104FB35F24DA011C322AFE2D665BEE8C88B8245D474185D4EBD8EBD48541475D24
B8888CEE5B662DFE2A321C01DA245FB34F10E4F7F3EDF42F607150221DF3265EC2764540
6551F0C3A29F97A39E9F97B2B51D5BA239E0A1A4E2349FDBF3FCFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFAEECD82
172A0611A9B7E41A3C14130525110F0E2114517AD67932DEDCC9176D626B76BFAE535E36
46693F20C0BCEA174656647C835523E2C70C08030567DC773AD1FFD8FFD8FFD13A77DC67
0503080CC7E22355837C64564617EABCC0203F6946365E53AEBF766B626D17C9DCDE3279
D67A5114210E0F11250513143C1AE4B7A911062A1782CDEEFAFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF8E7BC
6211E11A271134817F78317C5D7155586F7C3CE9CEF330404D2B1AE7D705FBEB97D836AD
8955F43418342C738E8B93ABBB9F50561C1BE11312E4D7FD1A5D2A7610762A5D1AFDD7E4
1213E11B1C56509FBBAB938B8E732C341834F45589AD36D897EBFB05D7E71A2B4D4030F3
CEE93C7C6F5855715D7C31787F813411271AE11162BCE7F8FDFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCF4DD
A5403D45B1571AF7F016E964ACA98D74AFBA8E30135A798C7A9249592C28B419090B9DC4
F9545B38D52270C6B0A7BFC0D7DE8939EB14357977331E5D7F57E418F018E4577F5D1E33
77793514EB3989DED7C0BFA7B0C67022D5385B54F9C49D0B0919B4282C5949927A8C795A
13308EBAAF748DA9AC64E916F0F71A57B1453D40A5DDF4FCFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFAEF
D08A26C999FF151FBA076B60FDFA5BC4C8D1DB7014A1FE53C6DB8333FB2A2B13F4091817
5884CD663C08FFD8B4D3C7E3D5F6F12A56557D98DC7911B1F7566110C0106156F7B11179
DC987D55562AF1F6D5E3C7D3B4D8FF083C66CD8458171809F4132B2AFB3383DBC653FEA1
1470DBD1C8C45BFAFD606B07BA1F15FF99C9268AD0EFFAFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF8
E9BF6A22050BEE311F23CBE70D06E0CED9E8E1EC132707CCD3EDF4254D83844E54467872
43FAC9D62B776D19292557115C3C5254ADAB53FBE3DA36121AC2D02F202FD0C21A1236DA
E3FB53ABAD54523C5C11572529196D772BD6C9FA43727846544E84834D25F4EDD3CC0727
13ECE1E8D9CEE0060DE7CB231F31EE0B05226ABFE9F8FDFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC
F5E0AA4B4F6F5716F5341D456C693721444D3E36658B5E24156C5923CDA98FCF3C9BB5A0
8D580E2C72B9C45E11E3557657EC3583F0E7803F374F2DEF073D4022FC22403D07EF2D4F
373F80E7F08335EC577655E3115EC4B9722C0E588DA0B59B3CCF8FA9CD23596C15245E8B
65363E4D442137696C451D34F516576F4F4BAAE0F5FCFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FBF0D39032DCCF02598D812CDCCF2678A36D8A835EE8D00474B0B34E4508051288DED0BB
B5AA5120E6DCAFFC1015A0F5566120E8FDF9D62F77C85E334D8D9F5352539F8D4D335EC8
772FD6F9FDE8206156F5A01510FCAFDCE62051AAB5BBD0DE88120508454EB3B07404D0E8
5E838A6DA37826CFDC2C818D5902CFDC3290D3F0FBFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEF9EAC3722F175796C4BF7E1A2064C8C4B95EFDAB13117B7BF2F48127E10720FCF3CDDF
C9C1C9175F560204F12B0E07D4D11D516247481DF9D7BF2681F3A7A45BA4A7F38126BFD7
F91D484762511DD1D4070E2BF10402565F17C9C1C9DFCDF3FC2007E12781F4F27B7B1113
ABFD5EB9C4C864201A7EBFC49657172F72C3EAF9FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFDF6E1AE535C7DD5DAD9CA5911D5E2D9CDCB230C27F209FBF2F7FE0B447357772A442C
4D181D5DB2AF4B0BB2247F79151A73AC82977584412D410FFBF7F462F162F4F7FB0F412D
4184759782AC731A15797F24B20B4BAFB25D1D184D2C442A775773440BFEF7F2FB09F227
0C23CBCDD9E2D51159CAD9DAD57D5C53AEE1F6FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFBF1D6953BE7D8EAF2D5CD1143552B323C29E00F5E763E4064494F7EBBAD46FA137B
CA5510D5D6B9CF0D391EF0EF1328F7C79AA3F056C2692EEA0605E200E200E20506EA2E69
C256F0A39AC7F72813EFF01E390DCFB9D6D51055CA7B13FA46ADBB7E4F4964403E765E0F
E0293C322B554311CDD5F2EAD8E73B95D6F1FBFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEF9ECC678381E595D2D1F4DB584706192843B01E3D83174DC773FE6D6B9CA091FFD
D9BE134E48151573926B3F3667886106260818C0D4EE105D67465C2281225C46675D10EE
D4C018082606618867363F6B92731515484E13BED9FD1F09CAB9D6E63F77DC7431D8E301
3B8492617084B54D1F2D5D591E3878C6ECF9FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFDF6E3B25A637ED16B1DB5C7EF529ED2B382403F462AF1CCFA295C4708226A864E
253F17D0B6096AB6C7A8666F97C8AF4A12EF0E323F376781D27B3FFD06FD3F7BD2816737
3F320EEF124AAFC8976F66A8C7B66A09B6D0173F254E866A2208475C29FACCF12A463F40
82B3D29E52EFC7B51D6BD17E635AB2E3F6FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFCF2D89A41EBCFE72033164582DDDDE99F7B659D892D2C3E898AA55F0BD9F142
699F76171144BDD3DBDF9558F0E6B9BE1D48785C8F924CEFC8ED4051695140EDC8EF4C92
8F5C78481DBEB9E6F05895DFDBD3BD441117769F6942F1D90B5FA58A893E2C2D899D657B
9FE9DDDD8245163320E7CFEB419AD8F2FCFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFAEDC97D3C1C466B8F6B31EDE6E6EEFE53A4D4C37A1DC09FB3C2D429196F59
BCBDC56A00B8D0F1E4E0FA4F662B3B0C35F96096C1C69B360C4D82B26FB2824D0C369BC6
C19660F9350C3B2B664FFAE0E4F1D0B8006AC5BDBC596F1929D4C2B39FC01D7AC3D4A453
FEEEE6E6ED316B8F6B461C3C7DC9EDFAFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFDF7E5B65E6474B3AEBB6D38355E3A437FE3E6DEC1552307134C2438F505E4
C8CBE7D715124845552E3E88D96B12F90C6582DAD1D7E47B0D8FFD77EF77FD8F0D7BE4D7
D1DA82650CF9126BD9883E2E5545481215D7E7CBC8E405F538244C13072355C1DEE6E37F
433A5E35386DBBAEB374645EB6E5F7FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFCF3DB9D44E6BEC2DCD82672D1782BE3EFF3EADEB91379802CEB3055654F
142D544B0FD1447CCA632DEBF7CF0F479C35F9D5E5E7E2FE150701F1FCF1010715FEE2E7
E5D5F9359C470FCFF7EB2D63CA7C44D10F4B542D144F655530EB2C807913B9DEEAF3EFE3
2B78D17226D8DCC2BEE6449DDBF3FCFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFAEECD7F3C112D464426E1DDE32E4552464D412D04F4FA124C779C9796
7021C9BE0E5042F4C0E025555B3E04DBAEAE0D37672C3B5D6369415749574169635D3B2C
67370DAEAEDB043E5B5525E0C0F442500EBEC9217096979C774C12FAF4042D414D465245
2EE3DDE12644462D113C7FCDEEFAFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFDF8E7BA5C626395925F5A0759659D87808595685C44486775BBBEBDB2
BD70140E5AB4923E162B7FA08B8B6617370D18F461797E7EBD8B8A6EB66E8A8BBD7E7E79
61F4180D3717668B8BA07F2B163E92B45A0E1470BDB2BDBEBB756748445C68958580879D
6559075A5F929563625CBAE7F8FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFCF4DDA339E8A69DE240923BE4ABABB79DB5D8449DA74CDBC2DAE0C0
C2F7260BEBBFBDA8166ED2BDB0A7BD6808FE121FB6EB50C1ECCE5BEA97EA5BCEECC150EB
B61F12FE0868BDA7B0BDD26E16A8BDBFEB0B26F7C2C0E0DAC2DB4CA79D44D8B59DB7ABAB
E43B9240E29DA6E839A3DDF4FCFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFAEFD0861B2E020AB7BEAF09103D082A093670E1E8842C05535C11
13607B71293B192610F6D5D8CDBBC7F81008E4382312A1EDF3F7B20C150CB2F7F3EDA112
2338E40810F8C7BBCDD8D5F61026193B29717B6013115C53052C84E8E17036092A083D10
09AFBEB70A022E1B86D0EFFAFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFDF8E8BF6414E40C243F1906F22760886B1EE3DEFFF2174EA4B360
0EB7FA44A46A6760853C2B4442141F5A774E4C2DF6210C15B8181C2FCC2F1C18B8150C21
F62D4C4E775A1F1442442B3C8560676AA444FAB70E60B3A44E17F2FFDEE31E6B886027F2
06193F240CE41464BFE8F8FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFCF5DFA93F3F498F6F7F424A57ACBCA67321326A6317B4D1C2D2
2B1F24B0B3E53BAED7841CB5B6185ACC8D947989580BDF2D1E26ED264B26ED261E2DDF0B
588979948DCC5A18B6B51C84D7AE3BE5B3B0241F2BD2C2D1B417636A322173A6BCAC574A
427F6F8F493F3FA9DFF5FCFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFBF0D38E1CD2A3A893C32EA3DDD7C4B17120D3E0133A1B4C1D
3BFE0446150AABC0F0FD19212F1BE4B4FF67C2C9875F2F2FFB113E8A838A3E11FB2F2F5F
87C9C267FFB4E41B2F2119FDF0C0AB0A154604FE3B1D4C1B3A13E0D32071B1C4D7DDA32E
C393A8A3D21C8ED3F0FBFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEF9EAC270062E110F0570E7EEE5DBC8C0592625748C7436EE
16717621F6130B393C6B52757B6E4E0C0DE5DBC3F3577493560EBFB0A4B0BF0E56937457
F3C3DBE50D0C4E6E7B75526B3C390B13F621767116EE36748C74252659C0C8DBE5EEE770
050F112E0670C2EAF9FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFDF6E1AD510CFF1709EBECF7F9DAE2D4C9156FC7B29E9736
0FE6ED183B97522CF2598BBF9E97A65E14A80D02786CCAB2A950220B330B2250A9B2CA6C
78020DA8145EA6979EBF8B59F22C52973B18EDE60F36979EB2C76F15C9D4E2DAF9F7ECEB
0917FF0C51ADE1F6FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFBF1D594394C7869303C6B46402D562417EFD7C7C6B0B7
05606514B7ACCC2D6057FBC4C0B8B6DF272305F10CF1D9C9C1C71766996617C7C1C9D9F1
0CF1052327DFB6B8C0C4FB57602DCCACB714656005B7B0C6C7D7EF1724562D40466B3C30
69784C3994D5F1FBFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEF9EBC67635ECCF167AE6762FDA508275363245163018
26CBCF3028161968D87F5720114E110CA0A10465793B2F491B1E55BABCBA551E1B492F3B
796504A1A00C114E1120577FD86819162830CFCB26183016453236758250DA2F76E67A16
CFEC3576C6EBF9FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF6E3B3565F231BEEEBF30E5E48FAC32D7BBB531DEF
24383A2BFA2A08FFC8E94C797B2EF301231B03EADD2B6DC55F11CBCEDBCECB115FC56D2B
DDEA031B2301F32E7B794CE9C8FF082AFA2B3A3824EF1D53BB7B2DC3FA485E0EF3EBEE1B
235F56B3E3F6FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFBF2D79D37EA2427901E38C6BE0C2950E2C4D11257
757C7E7A5E1CD91B0B695ECFC363354E7E7A3E4D4725E8CCD61B304A224A301BD6CCE825
474D3E7A7E4E3563C3CF5E690B1BD91C5E7A7E7C755712D1C4E250290CBEC6381E902724
EA379DD7F2FBFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFAECC885202EFA26FF16591B06F754541B186E9D
A3AAAAA7A274211CF800D9E2E3C12186F5817E7D9F713926384CB2628062B24C38263971
9F7D7E81F58621C1E3E2D900F81C2174A2A7AAAAA39D6E181B5454F7061B5916FF26FA2E
2085C8ECFAFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF7E4B5721AD108738337F8070DD8C20E65BDB9
C4C8C8C4C1BE681CB4202C66303022EFFBFE08F4FE4C988D27BCB6F21CF2B6BC278D984C
FEF408FEFBEF223030662C20B41C68BEC1C4C8C8C4B9BD650EC2D80D07F837837308D11A
72B5E4F7FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFCF3D99D6D290BDCFE2A45804952151DE9C5CC
E0DCD5E0D3CFDA263809FF507C944F60306667423F79DED8641102578957021164D8DE79
3F42676630604F947C50FF093826DACFD3E0D5DCE0CCC5E91D15524980452AFEDC0B296D
9DD9F3FCFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFAEDCA828D43452F889D64FE2F76853E0E3E
4C35363E4C1C3661B55A03A0FD5AD1727C71E07C28D9F0F2CE074DB0B1B04D07CEF2F0D9
287CE0717C72D15AFDA0035AB561361C4C3E36354C3E0E3E85762FFE649D882F45438D82
CAEDFAFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF7E6B866FD2469D2D5935F08F7EC27688D
85855F87957A27CACFD014210BCDDBFA0FEEE4ED273C4F553F07C9CACECAC9073F554F3C
27EDE4EE0FFADBCD0B2114D0CFCA277A95875F85858D6827ECF7085F93D5D26924FD66B8
E6F7FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCF4DBA0500AEEDADCF4577446345EBAB7
A9ABB75CFAD327541A3055A34A2928656752225366957C8DA1501D2552251D50A18D7C95
66532252676528294AA355301A5427D3FA5CB7ABA9B7BA5E34467457F4DCDAEE0A50A0DB
F4FCFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFAEECD854D404D25457EEA7F23C7D3DB
C0B6DFD8021A8BA87516D4C0B1217FAE9D81863CE3AD9BB1CEC20E68D2680EC2CEB19BAD
E33C86819DAE7F21B1C0D41675A88B1A02D8DFB6C0DBD3C7237FEA7E45254D404D85CDEE
FAFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF8E7BA6879A08128DFF5FF093C4722
4D110E9E0461CEE69C6927174208F7FE67D4C7704014041D403F05D8F3D8053F401D0414
4070C7D467FEF708421727699CE6CE61049E0E114D22473C09FFF5DF2881A07968BAE7F8
FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCF4DDA250FFF1124E5E3C6373A377
29F8012118CFDBF3FE468C7B27E10905EDDCDED42D7F7C0CB0C3093E6A3E09C3B00C7C7F
2DD4DEDCED0509E1277B8C46FEF3DBCF182101F82977A373633C5E4E12F1FF50A2DDF4FC
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFBEFCF854A2E688DA78848F5A9A7
9E0C46B04D331C656333F6F0104D646045353F4822F1EA1D1131449C9B9C4431111DEAF1
22483F354560644D10F0F63363651C334DB0460C9EA7A9F54888A78D682E4A85CFEFFBFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF8E8BD647386D6BDBB993C1402
3703DEAAD71876AAAA734830678AA8968270769683293476901BB7B5CBB5B71B90763429
839676708296A88A67304873AAAA7618D7AADE033702143C99BBBDD6867364BDE8F8FDFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCF5DFA742FCCCE3CAC8A01078
7C7A0F311369B4CFD0B4627A83D0C0C1AB989DB6D97603EFFA36063231320636FAEF0376
D9B69D98ABC1C0D0837A62B4D0CFB46913310F7A7C7810A0C8CAE3CCFC42A7DFF5FCFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFBF0D28B27462B55132805F3
F70EEF2053B3CCE8EACDB046FEC3DFDDC4B4B8CDE7FD0801D41F78757775781FD40108FD
E7CDB8B4C4DDDFC3FE46B0CDEAE8CCB35320EF0EF7F3052813552B46278BD2F0FBFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF9EAC16B22FF36757A602F
56695D17CBC4D7FCFDDAC2C405314E3E2E1C1F344752615D4309F1F602F6F109435D6152
47341F1C2E3E4E3105C4C2DAFDFCD7C4CB175D69562F607A7536FF226BC1EAF9FEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF6E0AB4B4D65B8CB7183
6ABEA954321145575C48102C4C938386746162798D888EAB805B37506450375B80AB8E88
8D796261748683934C2C10485C5745113254A9BE6A8371CBB8654D4BABE0F6FDFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFBF1D49032D8C0D7FF0C
FACFB3CF256F8D8E92976721CEA7AFB0AC8B8BAEB8B3A5C4ED4E7BA481A47B4EEDC4A5B3
B8AE8B8BACB0AFA7CE216797928E8D6F25CFB3CFFA0CFFD7C0D83290D4F1FBFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF9EBC3712E11415B62
59370C226FB7B7ABBABEB55B320F0D42100502104917052E5456F2ADA8ADF256542E0517
4910020510420D0F325BB5BEBAABB7B76F220C3759625B41112E71C3EBF9FEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF6E2AE525B75B191
829F4D2CCBE7BCCACFDBD1BE277F7821EA140BE4307F7F0BD0CD0F0743070FCDD00B7F7F
30E40B14EA21787F27BED1DBCFCABCE7CB2C4D9F8291B1755B52AEE2F6FDFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFCF2D69439E9C7B1
A9AAEC04682A3C1245452B311EFEE1115073643F24FBDD2613681E9857981E681326DDFB
243F64735011E1FE1E312B4545123C2A6804ECAAA9B1C7E93994D6F2FCFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFAECC676362432
0B14348F45FC126AA8786A748444334BA3B29085695A332DEB0DD857FF57D80DEB2D335A
698590B2A34B334484746A78A86A12FC458F34140B32243676C6ECFAFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF7E3B157648D
7315A0B2CB0D1FF8BD9B97A2AFB7228CE8D1AAA5BA73876B6901AF00FE00AF01696B8773
BAA5AAD1E88C22B7AFA2979BBDF81F0DCBB2A015738D6457B1E3F7FDFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCF3D8983FF0
EB0B33022E65865317100E0F27261FFFF9D8D1A9CEFC1CF6C3192520BC202519C3F61CFC
CEA9D1D8F9FF1F26270F0E10175386652E02330BEBF03F98D8F3FCFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFAEDC87A3C
29707D770FD6E550706E416D6F736B60325F1F240F697F501C1AFC340F34FC1A1C507F69
0F241F5F32606B736F6D416E7050E5D60F777D70293C7AC8EDFAFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF7E4B45C
688EEB80841A0DA2F14C9F98A2A49F928F42ED0E4DC2C279645C7328CC28735C6479C2C2
4D0EED428F929FA4A2989F4CF1A20D1A8480EB8E685CB4E4F7FDFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCF3D99B
43F2E6FC1DED290416C7BABCB9CEC0B0B4B91709FB96F3FB03C8EB333233EBC803FBF396
FB0917B9B4B0C0CEB9BCBAC7160429ED1DFCE6F2439BD9F3FCFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFAEECA
7D3F27676B6906E31E2B4503303F2C161D341FDB190211D213215B5AB05A5B2113D21102
19DB1F341D162C3F3003452B1EE306696B67273F7DCAEEFAFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF8E6
B65E6986DE7182182DF73162728D7E4C618D7A3704F60A22778E3EEA8BEA3E8E77220AF6
04377A8D614C7E8D726231F72D188271DE86695EB6E6F8FDFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCF4
DB9D45EFD8F416FA1E408F93A1AFC9844AF3DC236E750797A5B1C5060806C5B1A5970775
6E23DCF34A84C9AFA1938F401EFA16F4D8EF459DDBF4FCFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFB
EECB7F3F2050766617BFAAB5C7C6D0FC3B5D4E0CECE41A100237272BBA2B273702101AE4
EC0C4E5D3BFCD0C6C7B5AABF17667650203F7FCBEEFBFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
F8E7B860667BBEB35A21023038252E4D7DAB925F27514F943D33FE1D3B1DFE333D944F51
275F92AB7D4D2E25383002215AB3BE7B6660B8E7F8FEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FCF4DC9E44E8CACAD119579375676E85A6CFE0746A6FC866F91B528F598F521BF966C86F
6A74E0CFA6856E6775935719D1CACAE8449EDCF4FCFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFBEFCE7F3C15423C23D2B89B969CAAC3DEFDE408E7F0B92217FC909190FC1722B9F0E7
08E4FDDEC3AA9C969BB8D2233C42153C7FCEEFFBFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEF8E8BA5B616DB6553B152101092D1D3C635A0BA9191C3DEB0607130706EB3D1C19A9
0B5A633C1D2D090121153B55B66D615BBAE8F8FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFDF5DDA237EAB8CA27837E40448F8724CBD5142D12F4335250695469505233F4122D
14D5CB24878F44407E8327CAB8EA37A2DDF5FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFBF0CF841A36213DF0D93373E2C8641B17799749435BC78157F85781C75B434997
79171B64C8E27333D9F03D21361A84CFF0FBFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEF9E9BD6214F4384D5B0BFFDBE9CB1456C3D79326CCC3FE407040FEC3CC2693D7
C35614CBE9DBFF0B5B4D38F41462BDE9F9FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFDF5DEA5414365C96B812955384519CAC9F3F341183E308FC28F303E1841F3F3
C9CA1945385529816BC9654341A5DEF5FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFBF1D08828D4CDEF19FA3E72C1561A24546D23F21B6FD5D8D56F1BF2236D54
241A56C1723EFA19EFCDD42888D0F1FBFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEF9E9BD6929165B6C6A1CF5D1BB2059CE818A3B1EDDE3EBE3DD1E3B8A81CE
5920BBD1F51C6A6C5B162969BDE9F9FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFDF6E0A54E5F7FD8807C3C32340FFCA7F962B85C27376837275CB862F9A7
FC0F34323C7C80D87F5F4EA5E0F6FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFCF1D28643F4C8F445BE7332C3280C1ACBDFC61275E67512C6DFCB1A0C
28C33273BE45F4C8F44386D2F1FCFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEF9EABF6265200ABDC2FD27401EF10939543008EBF5EB0830543909F1
1E4027FDC2BD0A206562BFEAF9FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFDF6E1A73CE61E104B29869F5A43448AA57842553E554278A58A4443
5A9F86294B101EE63CA7E1F6FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFCF2D3891B27F9009DB4BACF2B8BD1B7C1794AE84A79C1B7D18B2B
CFBAB49D00F9271B89D3F2FCFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFAEBC1650FD90B1C123A263EF2E7C9BDFC376137FCBDC9E7F23E
263A121C0BD90F65C1EBFAFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFDF7E1AB3F343EA3552CF32D5B5A181F43969596431F185A5B2D
F32C55A33E343FABE1F7FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFCF2D48F1ABEA4E422517297AD7013BBB8B8B8BB1370AD9772
5122E4A4BE1A8FD4F2FCFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFAEBC36F020A3A848599C5CFC54C14144714144CC5CFC599
85843A0A026FC3EBFAFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEF7E1AE4F07BEB099C1D6F3D5C10167C16701C1D5F3D6C1
99B0BE074FAEE1F7FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFCF2D3963542031A1554434F181BCFE4CF1B184F435415
1A03423596D3F2FCFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFAEBC08129DA0356D08036E7123C4F3C12E73680D056
03DA2981C0EBFAFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF7E1A8793109CBD8FC2C445E8397835E442CFCD8CB
093179A8E1F7FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCF2D28B94433A195E80798DB4C4B48D79805E193A
43948BD2F2FCFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAEBBE6CFE1D58BCA69DAFCEEBCEAF9DA6BC581D
FE6CBEEBFAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF7E0A55105E2C9CDB6B6F1F4F1B6B6CDC9E205
51A5E0F7FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF2D1874B384119401319B61913401941384B
87D1F2FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFBEBBC6673977822E51E2F1EE52278977366
BCEBFBFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF7DFA24BF9E90D4E6F7F6F4E0DE9F94BA2
DFF7FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF2CF82452B638CACA5AC8C632B4582CF
F2FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFBE9BA616F87D0C2C6C2D0876F61BAE9
FBFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8DCA046F8D0D8DDD8D0F846A0DCF8
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF2C8863E2C364E362C3E86C8F2FE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCE8AC7858888C885878ACE8FCFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8D8889098E8989088D8F8FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0C060FFD0FF60C0F0FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0A0402040A0E0FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0804080C0FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF808080FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell["They can even be symbolic. ", "MathCaption",
  CellTags->{"S3.8.6", "6.29"}],

Cell[CellGroupData[{

Cell["\<\
Simplify[CellularAutomaton[{Mod[Apply[Plus, #], 2] &, {}, 1}, {{a}, \
0}, 2], a \[Element] Integers]\
\>", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.8.6"],

Cell[BoxData[
    \({{0, 0, a, 0, 0}, {0, Mod[a, 2], Mod[a, 2], Mod[a, 2], 0}, {Mod[a, 2], 
        0, Mod[3\ Mod[a, 2], 2], 0, Mod[a, 2]}}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CellularAutomaton[", "MR"],
              StyleBox["rnum", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["init", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evolve for ",
              StyleBox["t", "TI"],
              " steps, keeping all steps "
            }]]},
          {Cell[TextData[{
              StyleBox["CellularAutomaton[", "MR"],
              StyleBox["rnum", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["init", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["-1]", "MR"],
              " "
            }]], Cell[TextData[{
              "evolve for ",
              StyleBox["t", "TI"],
              " steps, keeping only the last step "
            }]]},
          {Cell[TextData[{
              StyleBox["CellularAutomaton[", "MR"],
              StyleBox["rnum", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["init", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], 
                      StyleBox["t",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "keep only steps specified by ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], 
                      StyleBox["t",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.6"],

Cell["Selecting which steps to keep. ", "Caption",
  CellTags->"S3.8.6"],

Cell["This runs rule 30 for 5 steps, keeping only the last step. ", \
"MathCaption",
  CellTags->{"S3.8.6", "6.30"}],

Cell[CellGroupData[{

Cell["CellularAutomaton[30, {{1}, 0}, 5, -1]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.8.6"],

Cell[BoxData[
    \({{1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1}}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell["This keeps the last 2 steps. ", "MathCaption",
  CellTags->{"S3.8.6", "6.31"}],

Cell[CellGroupData[{

Cell["CellularAutomaton[30, {{1}, 0}, 5, -2]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.8.6"],

Cell[BoxData[
    \({{0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0}, {1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 
        1}}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[TextData[{
  "The step specification ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["spec",
            "TI"], 
          StyleBox["t",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " works very much like taking elements from a list with ",
  StyleBox["Take", "MR"],
  ". One difference, though, is that the initial condition for the cellular \
automaton is considered to be step ",
  StyleBox["0", "MR"],
  ". Note that any step specification of the form ",
  StyleBox["{", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  " must be enclosed in an additional list. "
}], "Text",
  CellTags->{"S3.8.6", "6.32"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["All", "MR"],
              " "
            }]], Cell[TextData[{
              "all steps ",
              StyleBox["0", "MR"],
              " through ",
              StyleBox["t", "TI"],
              " (default) "
            }]]},
          {Cell[TextData[{
              StyleBox["u", "TI"],
              " "
            }]], Cell[TextData[{
              "steps ",
              StyleBox["0", "MR"],
              " through ",
              StyleBox["u", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["-", "MR"],
              StyleBox["u", "TI"],
              " "
            }]], Cell[TextData[{
              "the last ",
              StyleBox["u", "TI"],
              " steps "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["u", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "step ",
              StyleBox["u", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "steps ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " through ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["du", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "steps ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["du", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.6"],

Cell["Cellular automaton step specifications. ", "Caption",
  CellTags->"S3.8.6"],

Cell["\<\
This evolves for 100 steps, but keeps only every other step. \
\>", \
"MathCaption",
  CellTags->{"S3.8.6", "6.33"}],

Cell[CellGroupData[{

Cell["\<\
ArrayPlot[CellularAutomaton[30, {{1}, 0}, 100, {{1, -1, 2}}]]\
\>", \
"Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .25126 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00478583 0.00598229 0.00478583 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .25126 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .25126 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .25126 L
s
0 .25126 m
1 .25126 L
s
1 0 m
1 .25126 L
s
0 0 m
1 0 L
1 .25126 L
0 .25126 L
closepath
clip
newpath
% Start of gray image
p
.02381 .00598 translate
.95238 .23929 scale
199 string
199 50 8 [199 0 0 50 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FF000000FF0000FF
FF0000FFFF00FFFFFF0000FF0000FF000000FF00FF000000000000FFFF00FF000000FF00
FF000000FF00FF0000FFFF000000FFFFFF00FFFF00FF00FF000000FF0000FFFF00FFFF00
FF0000FFFFFF000000FF0000FFFFFFFFFFFF00FF00FF000000FF00FF000000FF00FFFFFF
FF00000000FF00FFFF00FF00FFFF00000000FFFFFF00FF00FFFF00FF00FFFFFF00FF00FF
FF0000FF00FF00FF0000FFFF0000FF00000000
FFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF0000FFFFFF
FFFFFF0000FFFF0000FFFFFFFFFF000000FFFFFF0000FF0000FF00FFFFFF0000FF00FF00
FFFFFFFF00000000FFFF000000FFFF00FF00FFFFFF000000FF000000FF00FFFFFF00FF00
FF0000000000FF00000000FFFF00FFFF0000FFFFFF000000FFFFFF0000FF00FF00FFFF00
FF000000FFFFFF0000FFFFFF00FF000000FFFF0000FFFFFF0000FFFFFF00FFFFFF000000
00FF00FF00FF0000FFFFFFFFFFFF000000FFFF
FFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FFFF00FF
FF00FF0000000000FFFF00FFFF000000FFFF0000FFFFFFFFFF0000000000FF00FF00FF00
FFFF0000FFFFFFFF00FFFFFFFF00FF0000FFFF00FFFFFFFF000000FFFFFF00FFFFFF0000
00FF0000FF00FF0000FF00FFFFFF00FF0000000000FF0000000000FF00FF0000FFFF0000
00FF000000000000FFFF00FF00FFFFFFFF00FF000000000000FFFF0000FFFF00FF0000FF
00FF00FF00FF000000000000000000FFFFFFFF
FFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FFFF
000000FF0000FF00FFFFFF00FFFFFFFF00FF00000000000000FF0000FF0000FFFFFF0000
000000FFFF00FFFFFF00FFFF000000FF00FFFFFF00FFFF0000FF00FFFF000000000000FF
FFFFFFFF000000FF0000FFFF00FF00FF0000FF000000FF0000FF00FFFFFFFFFF00FFFFFF
FF000000FFFFFFFF0000FFFFFF00FFFF000000FF0000FF0000000000FFFF000000FF0000
FFFFFF000000FF0000FF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000
FF000000FF0000FFFF0000FFFF00FFFFFF0000FF0000FF000000FF00FF000000000000FF
FFFFFF0000FFFF0000FFFF0000FF0000FFFF00FFFFFFFFFFFF00000000FF0000FF000000
0000000000FFFFFFFFFF00FF00FF00FF000000FF000000FF0000FFFF00FFFF0000000000
00FF000000000000FF00FFFF00000000FF000000FF00FF0000FF00000000FF000000FF00
FFFF0000FF00FF00000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF
0000FF0000FFFFFFFFFFFF0000FFFF0000FFFFFFFFFF000000FFFFFF0000FF0000FF00FF
FF0000FFFFFFFFFFFF0000FFFFFFFFFF0000FFFF00FFFF00FF0000FF00FF000000FF0000
00FFFFFFFF00FFFF0000FFFFFF000000FF00000000FFFFFFFFFF0000FFFF000000FFFFFF
FF0000FF000000FFFFFF00FF0000FF00FFFFFFFF000000FF00FF0000FF00FFFFFFFF0000
000000FFFFFF000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF
00000000FFFF00FFFF00FF0000000000FFFF00FFFF000000FFFF0000FFFFFFFFFF000000
0000FFFF00FFFF0000FFFFFFFFFFFFFFFFFF0000FFFF00000000FFFFFF0000FF00FFFFFF
FF00FFFF00000000FF00FFFF0000FF0000FFFFFFFF00FFFF00FF0000000000FFFFFFFFFF
FFFFFF0000FF00FFFF000000FF00FF00FFFF00FFFFFFFF000000FF00FF00FFFF00FF0000
FF000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000
FFFFFFFF0000FFFF000000FF0000FF00FFFFFF00FFFFFFFF00FF00000000000000FF0000
FF00FFFFFF00FF000000000000000000000000FFFF0000FF0000000000FF0000FFFF00FF
FFFF00FF000000FFFFFF00FF00000000FFFF00FFFFFF00FF00FF0000FF00000000000000
000000FF0000FFFF0000FF00FF00FF00FFFFFF00FFFF0000FF0000FFFFFF00FF00FF0000
00FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00
FFFF00FF00000000FF000000FF0000FFFF0000FFFF00FFFFFF0000FF0000FF000000FF00
FF00FFFF000000FF0000FF0000FF0000FF00000000FF00FF0000FF000000FF00FFFFFF00
FFFFFF000000FFFF00FF00FF0000FF00FFFFFF00FFFFFF000000FF00FF0000FF0000FF00
00FF00FF00000000FF00FF0000FFFFFF00FFFFFF0000FFFFFFFFFF00FFFFFF000000FF00
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF
00FF0000FFFFFFFF0000FF0000FFFFFFFFFFFF0000FFFF0000FFFFFFFFFF000000FFFFFF
00000000FF000000FF00FF000000FF00FF0000FF00FFFFFFFFFF0000FF0000FFFF00FF00
FFFF0000FF00FFFFFF000000FF0000FFFF0000FFFF00FFFFFFFF000000FF00FF000000FF
00FF0000FFFFFFFF00000000FFFF00FFFFFFFFFFFFFF00FFFF0000FFFF00FFFFFFFF0000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF00
0000FF00FFFF00FF00000000FFFF00FFFF00FF0000000000FFFF00FFFF000000FFFF0000
FFFFFFFF0000FF00FF00FFFFFFFF00000000FFFFFF00FFFF00FF000000FF00FFFFFF0000
0000FF00FF00FFFF0000FF00FF00000000FF00FFFFFF00FFFF0000FF00FF00FFFFFFFF00
0000FF00FFFF00FF0000FF00FFFFFF00FFFF00FFFF0000000000FFFF00000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF0000
00FFFFFF00FF0000FFFFFFFF0000FFFF000000FF0000FF00FFFFFF00FFFFFFFF00FF0000
00000000FF00FF00FF00FFFF00FF000000FFFF00FF00FFFFFF0000FF0000FFFF00FF0000
00FFFFFF00000000FF00FF00FF0000FF00FF00FFFF00000000FF0000FFFFFF00FFFF0000
FF0000FFFF000000FF0000FFFF0000FFFF00000000FF000000FFFF0000FF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF
00FFFF000000FF00FFFF00FF00000000FF000000FF0000FFFF0000FFFF00FFFFFF0000FF
0000FF00FF0000FFFFFF00FF00FFFFFFFF00FF0000FFFF00FF000000FF00FFFFFF000000
FFFF00FF000000FFFFFF000000FF00FF0000FFFF000000FFFFFFFFFF00FFFFFF00FF0000
0000FFFF0000FF0000FFFFFFFFFFFF00FF0000FF00FFFFFFFF00FF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000
FFFF000000FFFFFF00FF0000FFFFFFFF0000FF0000FFFFFFFFFFFF0000FFFF0000FFFFFF
FFFF00000000FFFF0000FFFFFF00FFFF000000FF00FFFFFF0000FF00FF00FFFF0000FF00
FFFFFF0000FF00FFFF0000FF00FFFFFFFFFF00FFFFFFFF00FFFF0000FFFF00FF0000FFFF
FFFF00FF000000FF00FFFF00FFFF000000FF0000FFFF00FFFFFF000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF
FF0000FF00FFFF000000FF00FFFF00FF00000000FFFF00FFFF00FF0000000000FFFF00FF
FF000000FFFFFFFFFFFF00FFFFFF00FFFFFFFF000000000000FFFFFF00000000FF00FFFF
FFFFFFFFFF00000000FF00FF00FFFF00FFFFFF00FFFF0000000000FFFF00000000FFFF00
FFFFFF0000FF0000FFFF00000000FF00000000FFFF000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF000000
00FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FFFF000000FF0000FF00FFFFFF00
FFFFFFFF00FFFF00FFFFFF00FFFFFF00FFFF0000FF000000FFFF00FF0000FF00FF00FFFF
00FFFF00FF0000FF0000FFFFFF00FF00FFFF0000000000FFFFFFFF0000FFFFFFFF0000FF
FF0000FFFFFFFFFF0000FFFFFFFF0000FF00000000FF000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00
000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FF000000FF0000FFFF0000FF
FF00FFFFFF0000FFFF0000FFFF00FFFFFFFFFFFF000000FFFF000000FF00FF00FF00FFFF
FF00FF00FF00000000FFFF0000FFFFFF00FF0000FF000000000000FF00FFFF0000FFFFFF
FFFFFF00FFFF0000FFFFFFFFFFFFFFFF0000FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF0000FFFFFFFFFFFF00
00FFFF0000FFFFFFFFFFFF00FF00FFFF00FFFF000000FFFF0000FF00FF00FF0000FFFF00
00FFFFFF0000FF0000000000FFFF00FFFFFFFFFF0000FF0000FF00FFFFFFFFFFFF00FFFF
00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FFFF00FFFF00FF00
00000000FFFF00FFFF00FF0000FFFF00000000FF00000000FF00FF00FF00FF0000000000
FFFF00FF000000FF0000FF00FFFFFF00FFFF00FF00000000FFFFFF00FFFF00FFFFFF0000
FFFF00FF000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FFFF000000FF
0000FF00FFFFFF00FFFFFFFFFF00FF0000FF00FF0000FF0000FFFFFF000000FF000000FF
FF000000FF00000000FFFFFF00FFFFFF00FF00FF000000FFFF0000FFFF000000000000FF
FF000000FF0000FF0000FF0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FF000000
FF0000FFFF0000FFFF00FFFF000000FF00FF00FF00000000FFFF00FFFFFFFF000000FFFF
0000FF0000FFFFFFFF00FFFFFF00FFFFFF000000FF0000000000FFFF0000FF000000FFFF
0000FF00FF000000FF00FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF00
00FFFFFFFFFFFF0000FFFF0000FF00FF00FF0000FFFFFFFF00FF00FFFF00FFFFFFFF00FF
000000FF00FFFF00FF00FFFF0000000000FF00000000FFFFFFFF00FF000000FF00000000
00FFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000
FFFF00FFFF00FF0000000000FFFFFF000000FF00FFFF0000FFFFFF0000FFFF00FFFFFF00
00FF00FF00FFFFFF00000000FF0000FF00FF000000FFFF00FFFFFF0000FF00FF0000FF00
00000000FF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF
0000FFFF000000FF0000FF00FFFF000000FFFFFF00FF000000000000FFFF0000000000FF
00FF00FF00FFFF0000FF000000FF00FF00FFFFFFFF00FFFFFFFFFFFFFF000000FF00FF00
00FF000000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF
00000000FF000000FF0000FFFF0000FF00FFFF000000FF0000FF00000000FF0000FF00FF
00FF00FFFFFFFFFFFF0000FF00FF0000FFFF00FFFFFF00FFFF00FFFF0000FF00FF00FF00
0000FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000
FFFFFFFF0000FF0000FFFFFFFFFFFF0000000000FFFFFFFFFF0000FF000000FF0000FFFF
FF0000000000000000FF00FFFFFFFFFF0000FFFF0000FFFF00000000FF00FF00FF00FFFF
FFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00
FFFF00FF00000000FFFF00FFFF00FF000000FFFFFFFFFFFFFFFFFF0000FF00FF00000000
00FF0000FF000000FFFFFF00FFFF0000FFFFFFFFFFFF00FF0000FF0000FFFFFF00000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF
00FF0000FFFFFFFF0000FFFF000000FF0000000000000000000000FF00FF00FF000000FF
FFFFFFFF0000FF00FFFF0000000000FFFF00FFFF00FF00FF000000FF00FFFF0000FF0000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF00
0000FF00FFFF00FF00000000FF000000FF0000FF0000FF000000FFFFFF00000000FFFFFF
FFFFFFFFFFFF00000000FF0000FF00FFFFFF0000FFFFFF000000FFFFFF00FF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF0000
00FFFFFF00FF0000FFFFFFFF0000FF0000FFFFFFFFFF000000FFFF00FF0000FF00FFFF00
FFFF00FFFF000000FFFFFFFFFF000000000000FFFF00FFFFFFFF00FFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF
00FFFF000000FF00FFFF00FF00000000FFFF00FFFF000000FFFF000000FF00FF00FFFFFF
0000FFFF000000FFFF00FFFF0000FF0000FF00FFFFFF00FFFF000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000
FFFF000000FFFFFF00FF0000FFFFFFFF0000FFFF000000FFFF000000FFFFFF0000000000
00FFFF0000FF00FFFFFF00FF000000FF00FF00FFFF00000000FF000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF
FF0000FF00FFFF000000FF00FFFF00FF00000000FF00000000FF0000000000FF0000FF00
00000000FFFFFF00FFFFFF0000FF00FF0000FFFF0000FF00000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF000000
00FF0000FFFF000000FFFFFF00FF0000FFFFFFFF0000FF000000FF0000FF00FF000000FF
0000FF00FFFF0000000000FF00FF0000FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00
000000FFFF0000FF00FFFF000000FF00FFFF00FF00000000FFFFFFFFFF00000000FFFFFF
FFFF00000000FF0000FF00FF00FF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FF00000000FF0000FFFF000000FFFFFF00FF0000FFFFFFFF00FFFF00FF000000FFFF00FF
FF0000FF00000000FFFFFF000000FF0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00000000FFFF0000FF00FFFF000000FF00FFFF00FF00FFFFFF000000FFFF000000
00FF00FF0000FF00FFFF0000FF00FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FF00000000FF0000FFFF000000FFFFFF00FF0000FFFF00FFFFFFFF00FF0000FF
00FFFFFFFFFF0000000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000FF00000000FFFF0000FF00FFFF000000FF00FFFFFF00FFFF00000000FFFF
FF00FFFF00FF0000FF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFF00FFFFFF0000FFFFFFFF00FF
FFFF00FF00FF000000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF000000000000FFFF00FFFFFF00
FFFFFF000000FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FFFFFFFF0000FFFF0000FF
FF00FFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFF00FF0000000000FFFF
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FF000000FFFF00
00FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFFFFFF00FF00
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF00FFFFFF0000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CellularAutomaton[", "MR"],
              StyleBox["rnum", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["init", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["keep all steps, and all relevant cells "]},
          {Cell[TextData[{
              StyleBox["CellularAutomaton[", "MR"],
              StyleBox["rnum", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["init", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], 
                      StyleBox["t",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], 
                      StyleBox["x",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["keep only specified steps and cells "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.6"],

Cell["Selecting steps and cells to keep. ", "Caption",
  CellTags->"S3.8.6"],

Cell[TextData[{
  "Much as you can specify which steps to keep in a cellular automaton \
evolution, so also you can specify which cells to keep. If you give an \
initial condition such as ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["blist", "TI"],
  ", then ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " is taken to have offset 0 for the purpose of specifying which cells to \
keep. "
}], "Text",
  CellTags->{"S3.8.6", "6.34"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["All", "MR"],
              " "
            }]], 
            Cell["\<\
all cells that can be affected by the specified initial \
condition \
\>"]},
          {Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], 
            Cell["\<\
all cells in the region that differs from the \
background (default) \
\>"]},
          {Cell[TextData[{
              StyleBox["0", "MR"],
              " "
            }]], Cell[TextData[{
              "cell aligned with beginning of ",
              StyleBox["aspec", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              "cells at offsets up to ",
              StyleBox["x", "TI"],
              " on the right "
            }]]},
          {Cell[TextData[{
              StyleBox["-", "MR"],
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              "cells at offsets up to ",
              StyleBox["x", "TI"],
              " on the left "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "cell at offset ",
              StyleBox["x", "TI"],
              " to the right "
            }]]},
          {Cell[TextData[{
              StyleBox["{-", "MR"],
              StyleBox["x", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "cell at offset ",
              StyleBox["x", "TI"],
              " to the left "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "cells at offsets ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " through ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dx", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "cells ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["dx", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.6"],

Cell["Cellular automaton cell specifications. ", "Caption",
  CellTags->"S3.8.6"],

Cell["\<\
This keeps all steps, but drops cells at offsets more than 20 on \
the left. \
\>", "MathCaption",
  CellTags->{"S3.8.6", "6.35"}],

Cell[CellGroupData[{

Cell["\<\
ArrayPlot[CellularAutomaton[30, {{1}, 0}, 100, {All, {-20, \
100}}]]\
\>", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .83471 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00787092 0.0198741 0.00787092 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .83471 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .83471 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .83471 L
s
0 .83471 m
1 .83471 L
s
1 0 m
1 .83471 L
s
0 0 m
1 0 L
1 .83471 L
0 .83471 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01987 translate
.95238 .79497 scale
121 string
121 101 8 [121 0 0 101 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
00FF000000FFFF00FF0000000000FF00FF00FFFFFF00FF000000000000FF00FF00FF0000
FFFFFF00FF00FFFFFFFF0000FF00FF00FFFFFF00FF00FFFFFF0000FFFF0000FFFFFFFF00
000000FF00000000FFFFFF00FF0000FF00000000FF0000FF0000FF00000000FFFF00FF00
FF00FF000000FFFF00FFFFFF00
0000FFFF000000FFFFFF00FFFF00FF00FF000000FF0000FFFF00FFFF00FF0000FFFFFF00
0000FF0000FFFFFFFFFFFF00FF00FF000000FF00FF000000FF00FFFFFFFF00000000FF00
FFFF00FF00FFFF00000000FFFFFF00FF00FFFF00FF00FFFFFF00FF00FFFF0000FF00FF00
FF0000FFFF0000FF00000000FF
FF000000FFFF000000FF0000FF0000FFFFFF00FFFFFF0000FF0000FF00FF00FFFFFFFFFF
00FFFFFF000000000000FF00FF0000FFFF00FF0000FFFF00FF00000000FF00FFFF00FF00
00FF00FF0000FF00FFFF000000FF00FF0000FF00FF000000FF0000FFFFFFFF00FF00FF00
FF00FFFFFFFF0000FFFF00FFFF
00FFFF000000FFFF00FF00FFFFFF000000FF000000FF00FFFFFF00FF00FF0000000000FF
00000000FFFF00FFFF0000FFFFFF000000FFFFFF0000FF00FF00FFFF00FF000000FFFFFF
0000FFFFFF00FF000000FFFF0000FFFFFF0000FFFFFF00FFFFFF00000000FF00FF00FF00
00FFFFFFFFFFFF000000FFFFFF
000000FFFF0000FF00FF00000000FFFF0000FFFF00FF000000FF0000FFFFFF00FFFF00FF
00FFFF0000FF0000FF00FFFFFFFFFF00FFFFFFFFFF00FF00FF000000FFFFFF00FFFFFFFF
FF000000FF0000FFFF0000FF00FFFFFFFFFF000000FF000000FF00FFFF00FF00FF00FF00
FFFFFFFFFFFFFFFF00FFFFFFFF
FF00FFFFFFFF00FF0000FFFF00FFFFFFFF000000FFFFFF00FFFFFF000000FF0000FF00FF
0000FF00FFFFFF00FF0000000000FF0000000000FF00FF0000FFFF000000FF0000000000
00FFFF00FF00FFFFFFFF00FF000000000000FFFF0000FFFF00FF0000FF00FF00FF00FF00
0000000000000000FFFFFFFFFF
FF0000000000FFFFFF0000FF0000000000FFFF00000000FFFFFFFFFF00FFFFFF0000FFFF
FF00FF000000FF00FF00FFFF00FFFFFF00FFFF0000FFFFFF000000FFFF0000FFFF00FFFF
0000FF00FF0000000000FFFFFF00FFFF00FFFFFFFF000000FFFFFF00FF00FF0000FFFFFF
00FFFF00FFFF00FFFFFFFFFFFF
FFFF00FFFF000000FF00FFFFFF00FFFF0000FF00FFFF000000000000FFFFFFFFFF000000
FF0000FFFF00FF00FF0000FF000000FF0000FF00FFFFFFFFFF00FFFFFFFF000000FFFFFF
FF0000FFFFFF00FFFF000000FF0000FF0000000000FFFF000000FF0000FFFFFF000000FF
0000FF000000FFFFFFFFFFFFFF
00FF000000FFFF00FF00000000FFFFFFFF0000FFFFFFFF00FFFF00FFFFFFFFFFFFFF00FF
FFFF0000FF00FF00FF00FFFFFF00FFFFFF00FF000000000000FFFFFFFFFFFF00FFFFFFFF
FFFF00000000FFFFFFFF00FFFFFF00FF00FFFF00FFFFFFFF00FFFFFF00000000FFFF00FF
00FFFFFF00FFFFFFFFFFFFFFFF
0000FFFF0000FF0000FFFF00FFFFFFFFFFFF00000000FF0000FF0000000000000000FFFF
FFFFFF00FF00FF00FF000000FF000000FF0000FFFF00FFFF000000000000FF0000000000
00FF00FFFF00000000FF000000FF00FF0000FF00000000FF000000FF00FFFF0000FF00FF
00000000FFFFFFFFFFFFFFFFFF
FF0000FF00FFFFFF0000FF000000000000FF00FFFF00FF00FFFFFF00FFFF00FFFF000000
0000FF00FF0000FFFFFF00FFFFFF00FFFFFF0000FF000000FFFF00FFFF0000FFFF00FFFF
00FF0000FF00FFFF0000FFFF0000FFFFFF00FF00FFFF0000FFFF0000FFFFFFFF00FF0000
FFFF00FFFFFFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFF0000FFFF00FFFF00FF0000FF00FF000000FF000000FFFFFFFF00FF
FF0000FFFFFF000000FF00000000FFFFFFFFFF0000FFFF000000FFFFFFFF0000FF000000
FFFFFF00FF0000FF00FFFFFFFF000000FF00FF0000FF00FFFFFFFF0000000000FFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFF
00FF00FFFFFFFFFFFFFF0000FF000000FFFFFF00FF0000FFFF0000FFFF0000000000FFFF
FFFF00000000FFFF00FF00FFFF0000000000FF00FFFFFFFF00FFFFFFFFFFFF0000FFFF00
000000FFFFFF00FF0000000000FFFF0000FFFFFF00FF00000000FF00FFFF00FFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFF0000FFFF00000000FFFFFF0000FF00FFFFFFFF00FFFF000000
00FF00FFFF0000FF0000FFFFFFFF00FFFF00FF0000000000FFFFFFFFFFFFFFFF0000FF00
FFFF000000FF00FF00FFFF00FFFFFFFF000000FF00FF00FFFF00FF0000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFFFFFFFF00FF00000000FF0000FF00FFFF
00FF0000FF00FFFFFF00000000FF0000FF00FF00FFFF00FFFFFFFFFFFFFFFFFFFF00FF00
0000FFFF00FF00FF0000FF0000000000FFFF00FF00FF0000FF00FF00FFFFFF00FFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000FFFF0000FF0000000000FF0000FFFF00FFFFFF00FF000000
FFFFFF00FF00000000FFFF00FFFFFF00FF00FF0000FF00000000000000000000FF0000FF
FF0000FF00FF00FF00FFFFFF00FFFF0000FF0000FFFFFF00FF00FF000000FF000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFF00FFFF00FFFF00FFFFFFFF00FF00FFFF00FFFFFF0000FF000000FF0000FFFF00
0000FF00FF00FFFF0000FF000000FF0000FFFFFF00FF00FFFF00FFFF00FFFF00FF00FFFF
FFFF00FF00FF00FF000000FF0000FF00FFFFFF000000FF0000FFFFFF00FFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000FF0000FF0000FF00000000FF00FF0000FF000000FF00FFFFFF00FFFFFF000000FF
FF00FF00FF0000FF00FFFFFF00FFFFFF000000FF00FF0000FF0000FF0000FF00FF000000
00FF00FF0000FFFFFF00FFFFFF0000FFFFFFFFFF00FFFFFF000000FF00000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00FFFFFF00FF00FFFF0000FFFFFF0000FFFF00FF000000FF00000000FFFF0000
FF0000FFFFFF00FF000000FF00000000FFFF0000FFFFFF00FF00FFFFFF00FF00FF00FFFF
0000FFFFFF00000000FFFFFFFFFF0000000000FF00000000FFFF0000FFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FF00FF000000FF00FF0000FF00FFFFFFFFFF0000FF0000FFFF00FF00FFFF0000FF00FF
FFFF000000FF0000FFFF0000FFFF00FFFFFFFF000000FF00FF000000FF00FF0000FFFFFF
FF00000000FFFF00FFFFFFFFFFFFFF00FFFF0000FFFF00FFFFFFFF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FF0000FFFF0000FFFFFF00FF0000000000FF00FFFFFF0000FF0000FFFFFFFF00FF0000
0000FFFF00FF00FFFFFFFF0000FF0000000000FFFF00FF0000FFFF0000FFFFFF00000000
FF00FFFF0000FF0000000000000000FFFFFFFF000000FFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FF00FFFFFFFF00000000FFFFFF00FFFF00FF000000FF00FFFFFF00000000FF00FF00FF
FF0000FF00FF00000000FF00FFFFFF00FFFF0000FF00FF00FFFFFFFF000000FF00FFFF00
FF0000FF00FFFFFF00FFFF00FFFF0000000000FFFF00000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FF00000000FF00FFFF000000FF0000FF0000FFFF00FF000000FF00FFFF00FF0000FFFF
FFFF00FF00FF00FFFF00FF00000000FFFFFFFF00FF00FF0000000000FFFF00FF000000FF
FFFF00FF000000FF000000FFFFFFFF00FFFF000000FFFF00FFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FF00FFFF00FF000000FFFF00FF00FFFFFF0000FF0000FFFF00FF000000FFFFFF000000
00FF00FF00FF0000FF00FF00FFFF00000000FF0000FFFFFF00FFFF0000FF0000FFFF0000
00FF0000FFFF0000FFFF00000000FF000000FFFF0000FF000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FF0000FF0000FFFF0000FF00FF000000FF00FFFFFF0000FF0000FFFF000000FF00FFFF
00FF0000FFFFFF00FF00FF000000FFFF00FFFFFF000000FF0000FF00FFFFFF000000FFFF
00FF00FFFFFFFF0000FF00FFFF0000FFFF0000FF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FF00FFFFFFFF00FF0000FFFF00FF000000FF00FFFFFF000000FFFF00FF000000
FFFFFF000000FF00FF0000FFFF000000FFFFFFFFFF00FFFFFF00FF00000000FFFF0000FF
0000FFFFFFFFFFFF00FF0000FF00FFFFFFFF00FF00000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FF0000000000FFFFFF0000FF0000FFFF00FF00000000FFFF0000FF0000FFFF00
000000FFFF0000FFFFFF000000FFFF0000000000FF000000FF00FF00FFFF0000FF00FFFF
FF00000000000000FFFFFF00FF00000000FF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000FFFFFF00FFFF000000FF00FFFFFF0000FF00FF00FFFF0000FF00FFFFFF0000FF00
FFFF0000FF00FFFFFFFFFF00FFFFFFFF00FFFF0000FFFF00FF0000FFFFFFFF00FF000000
FF00FFFF00FFFF000000FF0000FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF000000FF000000FFFF0000FFFFFFFFFF00FF0000FFFFFFFF0000FFFFFFFFFF0000FF
FFFFFF00FF0000000000FF0000000000FFFFFFFF000000FFFFFF00000000FF0000FFFF00
FF000000FFFFFFFF00FFFFFF000000FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFF00FFFFFFFF000000000000FFFFFF00000000FF00FFFFFFFFFFFFFF0000
0000FF00FF00FFFF00FFFFFF00FFFF0000000000FFFF00000000FFFF00FFFFFF0000FF00
00FFFF00000000FF00000000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF000000FF0000000000FFFF00FFFF000000FF00FFFF00FF00000000000000FF00FF
FF00FF00FF0000FF00000000FFFFFFFF00FFFF0000FF00FFFF0000FF000000FF00FFFFFF
0000FF00FFFF0000FFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFF00FFFFFF00FFFF0000FF000000FFFF00FF0000FF00FF00FFFF00FFFF00FF0000
FF0000FFFFFF00FF00FFFF0000000000FFFFFFFF0000FFFFFFFF0000FFFF0000FFFFFFFF
FF0000FFFFFFFF0000FF00000000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
000000FF00000000FFFFFFFF0000FFFF000000FFFFFF00FF00FF0000FF0000FF00FF00FF
FFFF000000FF00FF0000FF00FFFF00FFFFFFFFFFFF00000000FF00FFFFFFFF0000000000
FF00FFFFFFFFFFFF0000FFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FFFF00FFFFFFFFFFFF000000FFFF000000FF00FF00FF00FFFFFF00FF00FF0000
0000FFFF0000FFFFFF00FF0000FF000000000000FF00FFFF0000FFFFFFFFFFFF00FFFF00
00FFFFFFFFFFFFFFFF0000FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FF00000000000000FFFF000000FFFF00FF00FF00FF000000FF00FF0000FFFF
00FFFFFFFF00000000FFFFFF0000FFFF00FFFF0000FFFFFFFF000000000000FF0000FF00
FFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF00FFFF00FFFF000000FFFF0000FF00FF00FF0000FFFF0000FFFFFF0000FF
0000000000FFFF00FFFFFFFFFF0000FF0000FF00FFFFFFFFFFFF00FFFF00FFFFFF0000FF
FFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
000000FF00FF000000FFFFFFFF00FFFFFFFF00FF00FF00FF00FFFFFFFF000000FF00FFFF
FF00FFFF0000FF0000000000FF00FFFFFF00FF000000000000FF0000FF000000FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF0000FFFF00000000FF00000000FF00FF00FF00FF0000000000FFFF00FF000000
FF0000FF00FFFFFF00FFFF00FF00000000FFFFFF00FFFF00FFFFFF0000FFFF00FF000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFF0000FF00FFFF00FF00FFFF00FF00FF0000FFFFFF00FFFF000000FFFFFF00FF
FFFF00FF000000FF0000FF00FF00FFFF000000FF000000FFFFFFFFFF000000FFFFFF00FF
FF00FFFF00FFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFF00FF0000FF00FF0000FF0000FFFFFF000000FF000000FFFF000000FF0000
0000FFFFFF00FFFFFF00FF00FF000000FFFF0000FFFF000000000000FFFF000000FF0000
FF0000FF0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000FFFFFF00FF00FF00FFFFFF00000000FFFF0000FFFF000000FFFF00FF00FF
FF000000FF000000FF0000FFFFFF00FFFFFFFF000000FFFF00FFFF000000FFFF00FF00FF
FFFF00FF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFF000000FF00FF00FF00000000FFFF00FFFFFFFF000000FFFF0000FF0000FFFF
FFFF00FFFFFF00FFFFFF000000FF0000000000FFFF0000FF000000FFFF0000FF00FF0000
00FF00FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FF000000FFFF00FF00FF00FF00FFFF0000FF0000000000FFFF0000FF00FFFFFF000000
00FF00000000FFFFFFFFFF00FFFFFF00FFFF0000FF00FFFFFF00FFFFFFFF00FF0000FFFF
00FF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF0000FF00FF00FF0000FFFFFFFF00FF00FFFF00FFFFFFFF00FF000000FF00FFFF
00FF00FFFF0000000000FF00000000FFFFFFFF00FF000000FF0000000000FFFFFF000000
FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FF0000FFFFFF00000000FF00FF0000FF00000000FF0000FFFF00FF0000FF
0000FFFFFFFF00FFFF00FF00FFFF00000000FF0000FFFF00FF00FFFF00FFFFFFFFFF00FF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
0000000000FFFFFF000000FF00FFFF0000FFFFFF0000FFFF00FFFFFF0000FF00FF00FFFF
FF00000000FF0000FF00FF000000FFFF00FFFFFF0000FF00FF0000FF0000000000FF0000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFF00000000FFFF00FF0000FF00FFFFFFFFFF000000FFFFFFFFFF00FF00FF000000
00FFFF00FFFFFF00FF0000FFFF000000FFFFFFFFFF0000FFFFFF00FF00FFFF00FFFFFF00
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000FF00FFFF000000FFFFFF00FF000000000000FFFF0000000000FF00FF00FF00FFFF
0000FF000000FF00FF00FFFFFFFF00FFFFFFFFFFFFFF000000FF00FF0000FF000000FF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF000000FFFF00000000FFFFFF00FFFF00FFFFFFFF00FFFF00FF00FF0000FFFFFF
FF0000FFFF00FF00FF00000000FF0000000000000000FFFF00FF00FF00FFFFFF00FFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FF0000FFFF0000FF00FFFF000000FF0000FF00000000FF0000FF00FF00FF00FFFFFFFF
FFFF0000FF00FF0000FFFF00FFFFFF00FFFF00FFFF0000FF00FF00FF000000FF00000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FF00FFFFFFFF0000FFFFFFFF00FFFFFF0000FFFF00FFFFFF00FF00FF0000FFFFFFFFFF
FFFFFF0000FFFFFF0000FF000000FF000000FFFFFFFF00FF00FF0000FFFF0000FFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFF0000000000FFFFFFFFFF0000FF000000FF0000FFFFFF000000000000
0000FF00FFFFFFFFFF0000FFFF0000FFFF00000000FF00FF00FF00FFFFFFFF000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF000000000000FF00FFFF00FFFFFFFFFFFFFF0000FFFF00FF00FFFFFFFFFF00FFFF00FF
FF00FF0000000000FF00FFFFFFFF0000FF00FFFF00FF00FF0000FFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF00FFFF00FF000000FFFFFFFFFFFFFFFFFF0000FF00FF0000000000FF0000FF0000
00FFFFFF00FFFF0000FFFFFFFFFFFF00FF0000FF0000FFFFFF00000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF000000FFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FF00FFFF00FFFFFF0000FFFF
00000000FFFFFFFF000000000000FF00FF00FFFFFF00000000FFFF00FFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000FFFF000000FF0000000000000000000000FF00FF00FF000000FFFFFFFFFF0000FF
00FFFF0000000000FFFF00FFFF00FF00FF000000FF00FFFF0000FF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFF00FFFFFF00FFFF00FFFF00FFFF00FF0000FFFFFF00FFFFFFFFFFFFFF0000
FFFFFFFF00FFFF0000FF0000FF00FF0000FFFF00FF0000FF00FFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000FF000000FF0000FF0000FF000000FFFFFF00000000FFFFFFFFFFFFFFFFFF00
000000FF0000FF00FFFFFF0000FFFFFF000000FFFFFF00FF00000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFF0000FFFF00FF00FFFFFF0000FFFF000000FF00FFFF00000000000000000000FF
FF00FFFFFF0000FFFFFFFFFF00000000FFFF000000FF0000FFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF0000FF0000FFFFFFFFFF000000FFFF00FF0000FF00FFFF00FFFF00FFFF0000
00FFFFFFFFFF000000000000FFFF00FFFFFFFF00FFFFFF000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00000000FF00FFFFFF000000000000FFFF000000FFFFFF00FF0000FF0000FF000000FFFF
000000000000FFFF00FFFF0000FF0000000000FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF00FF00000000FFFF00FFFF000000FFFF000000FF00FF00FFFFFF0000FFFF000000
FFFF00FFFF0000FF0000FF00FFFFFF00FFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FF00FFFF0000FF000000FFFF000000FFFF00FF0000FFFFFFFFFF000000FFFF00
00FF0000FF00FFFFFF00FF00000000FFFFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF0000FFFFFFFF0000FFFF000000FFFF000000FFFFFF000000000000FFFF0000FF00
FFFFFF00FF000000FF00FF00FFFF00000000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFF00000000FF00FFFFFFFF00FFFFFFFF00FFFFFFFFFF00FFFF00FFFFFFFF00FF00
0000FF0000FFFF00FF00FF000000FFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
000000FF00FFFF00FF00000000FF00000000FF0000000000FF0000FF0000000000FFFFFF
00FFFFFF0000FF00FF0000FFFF0000FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF0000FF00FF00FFFF0000FFFF00FFFFFF00FFFF00FF00FFFFFF00FFFF00000000
FFFFFFFFFF00FF00FF00FFFFFFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFF00FF0000FFFFFFFF0000FF000000FF0000FF00FF000000FF0000FF00FFFF00
00000000FF00FF0000FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000FFFFFF00000000FF00FFFFFF00FFFFFF0000FFFFFF00FFFFFF0000FFFFFFFF
00FFFF00FF00FF00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFF000000FF00FFFF00FF00000000FFFFFFFFFF00000000FFFFFFFFFF00000000FF
0000FF00FF00FF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF000000FFFF00FF0000FF00FF00FFFF0000000000FF00FFFF000000000000FFFF00FFFF
FF00FF0000FFFFFF00FFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF000000FFFFFF00FF0000FFFFFFFF00FFFF00FF000000FFFF00FFFF0000FF000000
00FFFFFF000000FF0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFF00000000FFFFFF00000000FF0000FF0000FFFF000000FFFFFFFF00FF00FFFF
00000000FFFF00FF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FF00FFFF000000FF00FFFF00FF00FFFFFF000000FFFF00000000FF00FF0000FF
00FFFF0000FF00FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FF000000FFFF00FF0000FF00FF00000000FFFF0000FF00FFFF0000FFFFFF0000
FFFFFFFF00FF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF0000FFFF000000FFFFFF00FF0000FFFF00FFFFFFFF00FF0000FF00FFFFFFFFFF00
00000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFF000000FFFF00000000FFFFFF0000FF0000000000FFFFFF00FF0000000000FF00
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00000000FFFF0000FF00FFFF000000FF00FFFFFF00FFFF00000000FFFFFF00FFFF00FF00
00FF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFF00FF000000FFFF00FF000000FF0000FF00FFFF000000FF0000FF00FF00
FFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
00FF00000000FF0000FFFF000000FFFFFF00FFFFFF0000FFFFFFFF00FFFFFF00FF00FF00
0000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF00FFFFFF000000FFFF00000000FFFFFFFFFF00000000FF000000FF0000FFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000FF00000000FFFF0000FF00FFFF000000000000FFFF00FFFFFF00FFFFFF000000FF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FFFF00FFFFFFFF00FF000000FFFF00FFFF0000FF000000FF00000000FFFF0000
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FF00000000FF0000FFFF000000FFFFFFFF0000FFFF0000FFFF00FFFFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FF00FFFFFFFF000000FFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000FF00000000FFFF0000FF00FFFF00FF0000000000FFFF00000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFFFF00FFFF000000FFFF00FFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FF000000FFFF0000FF000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF0000FFFF0000FF00FFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFFFFFF00FF00000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF00000000FF0000FFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF00FFFFFF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell["This keeps just the center column of cells. ", "MathCaption",
  CellTags->{"S3.8.6", "6.36"}],

Cell[CellGroupData[{

Cell["CellularAutomaton[30, {{1}, 0}, 20, {All, {0}}]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.8.6"],

Cell[BoxData[
    \({{1}, {1}, {0}, {1}, {1}, {1}, {0}, {0}, {1}, {1}, {0}, {0}, {0}, {1}, \
{0}, {1}, {1}, {0}, {0}, {1}, {0}}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[TextData[{
  "If you give an initial condition such as ",
  StyleBox["{{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["blist", "TI"],
  StyleBox["}", "MR"],
  ", then ",
  StyleBox["CellularAutomaton", "MR"],
  " will always effectively do the cellular automaton as if there were an \
infinite number of cells. By using a ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["spec",
            "TI"], 
          StyleBox["x",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " such as ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["}", "MR"],
  " you can tell ",
  StyleBox["CellularAutomaton", "MR"],
  " to include only cells at specific offsets ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " through ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " in its output. ",
  StyleBox["CellularAutomaton", "MR"],
  " by default includes cells out just far enough that their values never \
simply stay the same as in the background ",
  StyleBox["blist", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.8.6", "6.37"}],

Cell[TextData[{
  "In general, given a cellular automaton rule with range ",
  StyleBox["r", "TI"],
  ", cells out to distance ",
  StyleBox["r", "TI"],
  " ",
  StyleBox["t", "TI"],
  " on each side could in principle be affected in the evolution of the \
system. With ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["spec",
            "TI"], 
          StyleBox["x",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " being ",
  StyleBox["All", "MR"],
  ", all these cells are included; with the default setting of ",
  StyleBox["Automatic", "MR"],
  ", cells whose values effectively stay the same as in ",
  StyleBox["blist", "TI"],
  " are trimmed off. "
}], "Text",
  CellTags->{"S3.8.6", "6.38"}],

Cell["\<\
By default, only the parts that are not constant black are kept. \
\
\>", "MathCaption",
  CellTags->{"S3.8.6", "6.39"}],

Cell[CellGroupData[{

Cell["ArrayPlot[CellularAutomaton[225, {{1}, 0}, 100]]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .9902 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00933707 0.0235761 0.00933707 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .9902 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .9902 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .9902 L
s
0 .9902 m
1 .9902 L
s
1 0 m
1 .9902 L
s
0 0 m
1 0 L
1 .9902 L
0 .9902 L
closepath
clip
newpath
% Start of gray image
p
.02381 .02358 translate
.95238 .94304 scale
102 string
102 101 8 [102 0 0 101 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000FF0000FFFF00000000000000FF0000FFFF
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000FFFFFFFF0000000000000000FFFFFFFF00
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000FF00FFFF0000000000000000FF00FFFF0000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFF000000000000000000FFFFFF000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000FFFF00000000000000000000FFFF00000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000FF0000FFFF00FFFF00FFFF00FFFF000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000FF0000FF00FFFFFF00FF00FFFFFF00000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000FF0000FF0000FFFF00FF0000FFFF0000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000FF000000FFFFFFFF0000FFFFFFFF000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000FF000000FF00FFFF0000FF00FFFF00000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000FF00000000FFFFFF000000FFFFFF0000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000FF0000000000FFFF00000000FFFF000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000FF0000000000FF00FFFFFFFFFFFF00000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000FF0000000000FF0000FFFF00FFFF0000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00FF0000000000FF0000FF00FFFFFF000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
FF0000000000FF0000FF0000FFFF00000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000FF
0000000000FF000000FFFFFFFF0000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000FF00
00000000FF000000FF00FFFF000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000FF0000
000000FF00000000FFFFFF00000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000FF000000
0000FF0000000000FFFF0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000FF00000000
0000FFFFFFFFFFFFFF000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000FF0000000000
00FF00FFFF00FFFF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000FF000000000000
FF00FF00FFFFFF0000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000FF000000000000FF
00FF0000FFFF000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FF000000000000FF00
00FFFFFFFF00000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000FF000000000000FF0000
FF00FFFF0000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000FF000000000000FF000000
FFFFFF000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000FF000000000000FF00000000
FFFF00000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000FF00000000000000FFFFFFFFFF
FF0000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FF0000000000000000FFFF00FFFF
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FF0000000000000000FF00FFFFFF00
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000FF0000000000000000FF0000FFFF0000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000FF000000000000000000FFFFFFFF000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000FF000000000000000000FF00FFFF00000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000FF00000000000000000000FFFFFF0000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000FF0000000000000000000000FFFF000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000FF00FFFF00FFFF00FFFF00FFFF0000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000FF00FF00FFFFFF00FF00FFFFFF000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000FF00FF0000FFFF00FF0000FFFF00000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000FF0000FFFFFFFF0000FFFFFFFF0000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000FF0000FF00FFFF0000FF00FFFF000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000FF000000FFFFFF000000FFFFFF00000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000FF00000000FFFF00000000FFFF0000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000FF00000000FF00FFFFFFFFFFFF000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000FF00000000FF0000FFFF00FFFF00000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000FF00000000FF0000FF00FFFFFF0000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000FF00000000FF0000FF0000FFFF000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000FF00000000FF000000FFFFFFFF00000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000FF00000000FF000000FF00FFFF0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000FF00000000FF00000000FFFFFF000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00FF00000000FF0000000000FFFF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
FF0000000000FFFFFFFFFFFFFF0000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000FF
0000000000FF00FFFF00FFFF000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000FF00
00000000FF00FF00FFFFFF00000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000FF0000
000000FF00FF0000FFFF0000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000FF000000
0000FF0000FFFFFFFF000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000FF00000000
00FF0000FF00FFFF00000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000FF0000000000
FF000000FFFFFF0000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000FF0000000000FF
00000000FFFF000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000FF000000000000FF
FFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FF00000000000000FF
FF00FFFF0000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000FF00000000000000FF00
FFFFFF000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000FF00000000000000FF0000
FFFF00000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000FF0000000000000000FFFFFF
FF0000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000FF0000000000000000FF00FFFF
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FF000000000000000000FFFFFF00
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FF00000000000000000000FFFF0000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FFFF00FFFF00FFFF00FFFF00000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000FF00FFFFFF00FF00FFFFFF0000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000FF0000FFFF00FF0000FFFF000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000FFFFFFFF0000FFFFFFFF00000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000FF00FFFF0000FF00FFFF0000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000FFFFFF000000FFFFFF000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000FFFF00000000FFFF00000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000FF00FFFFFFFFFFFF0000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000FF0000FFFF00FFFF000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000FF0000FF00FFFFFF00000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000FF0000FF0000FFFF0000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000FF000000FFFFFFFF000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000000000FF000000FF00FFFF00000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
0000000000000000000000FF00000000FFFFFF0000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00000000000000000000FF0000000000FFFF000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00000000000000000000FFFFFFFFFFFFFF00000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000000000FF00FFFF00FFFF0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
0000000000000000FF00FF00FFFFFF000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00000000000000FF00FF0000FFFF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000000000FF0000FFFFFFFF0000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
0000000000FF0000FF00FFFF000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00000000FF000000FFFFFF00000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000FF00000000FFFF0000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000FFFFFFFFFFFF000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
000000FFFF00FFFF00000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
0000FF00FFFFFF0000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00FF0000FFFF000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
00FFFFFFFF00000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
FF00FFFF0000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
FFFFFF000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[TextData[{
  "Using ",
  StyleBox["All", "MR"],
  " for ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["spec",
            "TI"], 
          StyleBox["x",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " includes all cells that could be affected by a cellular automaton with \
this range. "
}], "MathCaption",
  CellTags->{"S3.8.6", "6.40"}],

Cell[CellGroupData[{

Cell["ArrayPlot[CellularAutomaton[225, {{1}, 0}, 100, {All, All}]]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .50249 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00473821 0.011964 0.00473821 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .50249 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .50249 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .50249 L
s
0 .50249 m
1 .50249 L
s
1 0 m
1 .50249 L
s
0 0 m
1 0 L
1 .50249 L
0 .50249 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01196 translate
.95238 .47856 scale
201 string
201 101 8 [201 0 0 101 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000FF0000FFFF00000000000000FF0000FFFF
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000FFFFFFFF0000000000000000FFFFFFFF00
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000FF00FFFF0000000000000000FF00FFFF0000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000FFFFFF000000000000000000FFFFFF000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000FFFF00000000000000000000FFFF00000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00FF0000FFFF00FFFF00FFFF00FFFF000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
FF0000FF00FFFFFF00FF00FFFFFF00000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000FF
0000FF0000FFFF00FF0000FFFF0000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000FF00
0000FFFFFFFF0000FFFFFFFF000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000FF0000
00FF00FFFF0000FF00FFFF00000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000FF000000
00FFFFFF000000FFFFFF0000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000FF00000000
00FFFF00000000FFFF000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000FF0000000000
FF00FFFFFFFFFFFF00000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000FF0000000000FF
0000FFFF00FFFF0000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000FF0000000000FF00
00FF00FFFFFF000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FF0000000000FF0000
FF0000FFFF00000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000FF0000000000FF000000
FFFFFFFF0000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000FF0000000000FF000000FF
00FFFF000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000FF0000000000FF00000000FF
FFFF00000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000FF0000000000FF0000000000FF
FF0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FF000000000000FFFFFFFFFFFFFF
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FF000000000000FF00FFFF00FFFF00
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000FF000000000000FF00FF00FFFFFF0000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000FF000000000000FF00FF0000FFFF000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000FF000000000000FF0000FFFFFFFF00000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000FF000000000000FF0000FF00FFFF0000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000FF000000000000FF000000FFFFFF000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000FF000000000000FF00000000FFFF00000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000FF00000000000000FFFFFFFFFFFF0000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000FF0000000000000000FFFF00FFFF000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000FF0000000000000000FF00FFFFFF00000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000FF0000000000000000FF0000FFFF0000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000FF000000000000000000FFFFFFFF000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000FF000000000000000000FF00FFFF00000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000FF00000000000000000000FFFFFF0000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000FF0000000000000000000000FFFF000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000FF00FFFF00FFFF00FFFF00FFFF0000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000FF00FF00FFFFFF00FF00FFFFFF000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000FF00FF0000FFFF00FF0000FFFF00000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000FF0000FFFFFFFF0000FFFFFFFF0000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000FF0000FF00FFFF0000FF00FFFF000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00FF000000FFFFFF000000FFFFFF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
FF00000000FFFF00000000FFFF0000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000FF
00000000FF00FFFFFFFFFFFF000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000FF00
000000FF0000FFFF00FFFF00000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000FF0000
0000FF0000FF00FFFFFF0000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000FF000000
00FF0000FF0000FFFF000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000FF00000000
FF000000FFFFFFFF00000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000FF00000000FF
000000FF00FFFF0000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000FF00000000FF00
000000FFFFFF000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000FF00000000FF0000
000000FFFF00000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FF0000000000FFFFFF
FFFFFFFF0000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000FF0000000000FF00FFFF
00FFFF000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000FF0000000000FF00FF00FF
FFFF00000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000FF0000000000FF00FF0000FF
FF0000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000FF0000000000FF0000FFFFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FF0000000000FF0000FF00FFFF00
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FF0000000000FF000000FFFFFF0000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000FF0000000000FF00000000FFFF000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000FF000000000000FFFFFFFFFFFF00000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000FF00000000000000FFFF00FFFF0000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000FF00000000000000FF00FFFFFF000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000FF00000000000000FF0000FFFF00000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000FF0000000000000000FFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000FF0000000000000000FF00FFFF000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000FF000000000000000000FFFFFF00000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000FF00000000000000000000FFFF0000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000FFFF00FFFF00FFFF00FFFF00000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000FF00FFFFFF00FF00FFFFFF0000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000FF0000FFFF00FF0000FFFF000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000FFFFFFFF0000FFFFFFFF00000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000FF00FFFF0000FF00FFFF0000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000FFFFFF000000FFFFFF000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000FFFF00000000FFFF00000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000FF00FFFFFFFFFFFF0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000FF0000FFFF00FFFF000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000FF0000FF00FFFFFF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000FF0000FF0000FFFF0000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000FF000000FFFFFFFF000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000FF000000FF00FFFF00000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000FF00000000FFFFFF0000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00FF0000000000FFFF000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
FF00FFFF00FFFF0000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000FF
00FF00FFFFFF000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000FF00
FF0000FFFF00000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000FF0000
FFFFFFFF0000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000FF0000FF
00FFFF000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000FF000000FF
FFFF00000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000FF00000000FF
FF0000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000FFFF00FFFF00
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000FF00FFFFFF0000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000FF0000FFFF000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000FFFFFFFF00000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FF00FFFF0000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FFFFFF000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["CellularAutomaton", "MR"],
  " generalizes quite directly to any number of dimensions. Above two \
dimensions, however, totalistic and other special types of rules tend to be \
more useful, since the number of entries in the rule table for a general rule \
rapidly becomes astronomical. "
}], "Text",
  CellTags->{"S3.8.6", "6.41"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], 
                      StyleBox["d",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}}",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              StyleBox["d", "TI"],
              "\[Hyphen]dimensional rule with ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      RowBox[{"(", 
                        RowBox[{"2", 
                          SubscriptBox[
                            StyleBox["r",
                              "TI"], "1"], "+", "1"}], ")"}], "\[Cross]", 
                      RowBox[{"(", 
                        RowBox[{"2", 
                          SubscriptBox[
                            StyleBox["r",
                              "TI"], "2"], "+", "1"}], ")"}], "\[Cross]", 
                      "\[Ellipsis]", "\[Cross]", 
                      RowBox[{"(", 
                        RowBox[{"2", 
                          SubscriptBox[
                            StyleBox["r",
                              "TI"], 
                            StyleBox["d",
                              "TI"]], "+", "1"}], ")"}]}], TraditionalForm]], 
                "InlineFormula"],
              " neighborhood "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["1},", "MR"],
              " ",
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["1}}", "MR"],
              " "
            }]], 
            Cell["\<\
two\[Hyphen]dimensional 9\[Hyphen]neighbor totalistic \
rule \
\>"]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{0,", "MR"],
              " ",
              StyleBox["1,", "MR"],
              " ",
              StyleBox["0},", "MR"],
              " ",
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["1,", "MR"],
              " ",
              StyleBox["1},", "MR"],
              " ",
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["1,", "MR"],
              " ",
              StyleBox["0}}},", "MR"],
              " ",
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["1}}", "MR"],
              " "
            }]], 
            Cell["\<\
two\[Hyphen]dimensional 5\[Hyphen]neighbor totalistic \
rule \
\>"]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{0,", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["0},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["1,", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["0}}},", "MR"],
              " ",
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["1}}", "MR"],
              " "
            }]], 
            Cell["\<\
two\[Hyphen]dimensional 5\[Hyphen]neighbor outer \
totalistic rule \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.8.6"],

Cell["\<\
Higher\[Hyphen]dimensional rule specifications. \
\>", "Caption",
  CellTags->"S3.8.6"],

Cell["\<\
This is the rule specification for the two\[Hyphen]dimensional 9\
\[Hyphen]neighbor totalistic cellular automaton with code 797. \
\>", \
"MathCaption",
  CellTags->{"S3.8.6", "6.42"}],

Cell["code797 = {797, {2, 1}, {1, 1}};", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.8.6"],

Cell["This gives steps 0 and 1 in its evolution. ", "MathCaption",
  CellTags->{"S3.8.6", "6.43"}],

Cell[CellGroupData[{

Cell["CellularAutomaton[code797, {{{1}}, 0}, 1]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.8.6"],

Cell[BoxData[
    \({{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 0, 
          0}}}\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell["This shows step 70 in the evolution. ", "MathCaption",
  CellTags->{"S3.8.6", "6.44"}],

Cell[CellGroupData[{

Cell["\<\
ArrayPlot[First[CellularAutomaton[code797, {{{1}}, 0}, 70, \
-1]]]\
\>", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00675447 0.0238095 0.00675447 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 1 L
s
0 1 m
1 1 L
s
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.02381 .02381 translate
.95238 .95238 scale
141 string
141 141 8 [141 0 0 141 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000FFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000FFFF00FF
FF0000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000FF00000000
00FF00000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000FF00FF000000
FF00FF000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000FF0000FF000000
FF0000FF0000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000FF00000000000000
00000000FF00000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FF00FF000000000000
000000FF00FF000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000FF00FF00FF000000FF00
0000FF00FF00FF0000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000FF00FFFF00000000000000
00000000FFFF00FF00000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000FF00FFFF00FFFFFFFFFFFFFF
FFFFFFFF00FFFF00FF000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000FF00FF00FF00FFFFFFFFFFFFFF
FFFFFFFF00FF00FF00FF0000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FF00FF0000FF000000000000FF00
0000000000FF0000FF00FF00000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FF0000FFFF0000000000000000FF00
00000000000000FFFF0000FF000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000FF00FFFFFFFF00000000FFFF0000FF00
00FFFF00000000FFFFFFFF00FF0000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000FF00FF00FFFFFF00000000000000000000
00000000000000FFFFFF00FF00FF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000FF00FF00000000FF000000FF000000000000
000000FF000000FF00000000FF00FF000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000FF0000FFFF0000FF00FFFF0000000000FFFFFF
0000000000FFFF00FF0000FFFF0000FF0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000FF00FF000000FFFF00FFFFFFFFFF0000FFFF00FF
FF0000FFFFFFFFFF00FFFF000000FF00FF00000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000FF00FF00000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000FF00FF000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000FF00FF0000FF0000FF000000FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF000000FF0000FF0000FF00FF0000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000FF00FF00000000FF00FF000000FF00FF000000FFFF00FF
FF000000FF00FF000000FF00FF00000000FF00FF00000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000FF0000FF000000000000FFFFFF00FFFFFF00000000000000
00000000FFFFFF00FFFFFF000000000000FF0000FF000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000FF000000000000000000FF00FFFFFF0000000000FF00FFFFFF
00FF0000000000FFFFFF00FF000000000000000000FF0000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000FF00FFFF0000000000000000FFFFFFFF00000000FF00FFFFFFFF
FF00FF00000000FFFFFFFF0000000000000000FFFF00FF00000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000FF00FF00FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00FF00FF000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000FF00FF00FFFFFF000000FFFFFFFFFF0000FFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFF0000FFFFFFFFFF000000FFFFFF00FF00FF0000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000FF00FF00FF000000000000FFFFFFFF0000FFFFFF00FFFFFFFFFF000000
FFFFFFFFFF00FFFFFF0000FFFFFFFF000000000000FF00FF00FF00000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000FF000000FF00000000FF000000FFFF00000000FFFF00FFFFFFFFFFFF00FF
FFFFFFFFFF00FFFF00000000FFFF000000FF00000000FF000000FF000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000FF000000FF00000000FF000000000000FF000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF000000FF000000000000FF00000000FF000000FF0000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000FF00FF00FF00FF000000000000FF00FFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FFFFFFFFFF00FF000000000000FF00FF00FF00FF00000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000FF00FF000000FFFF00FF00FF00FFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF000000FFFFFFFF00FF00FF00FFFF000000FF00FF000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000FF000000000000FF0000000000FFFF000000000000FFFFFF000000FF000000FFFFFF
000000FF000000FFFFFF000000000000FFFF0000000000FF000000000000FF0000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00FF00FFFF0000FF000000FF00FF00FFFF00FFFFFFFFFFFFFF00000000FFFF0000FFFFFF
0000FFFF00000000FFFFFFFFFFFFFF00FFFF00FF00FF000000FF0000FFFF00FF00000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
FF00000000000000000000FFFFFF00FFFF00FFFF00000000FF0000FF00FFFFFFFFFF00FF
FFFFFFFF00FF0000FF00000000FFFF00FFFF00FFFFFF00000000000000000000FF000000
000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000FF
000000FFFF00000000FFFFFFFF000000FF00FF00FFFF000000FFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFF000000FFFF00FF00FF000000FFFFFFFF00000000FFFF000000FF0000
000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000FF00
FF00FF0000FFFFFFFFFFFF00FFFFFF0000FF0000FFFF00FF0000FFFFFFFF00FFFFFFFFFF
FFFF00FFFFFFFF0000FF00FFFF0000FF0000FFFFFF00FFFFFFFFFFFF0000FF00FF00FF00
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000FF00FF
000000FF00000000FFFFFFFFFFFFFF00FF000000000000000000FF00FF0000FFFFFFFFFF
FFFF0000FF00FF000000000000000000FF00FFFFFFFFFFFFFF00000000FF000000FF00FF
000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000FF000000
000000FFFFFFFFFFFFFF00FFFF00FF00FFFFFF00000000FFFF00FF00FF0000FF00FFFFFF
00FF0000FF00FF00FFFF00000000FFFFFF00FF00FFFF00FFFFFFFFFFFFFF000000000000
FF0000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000FF000000FF
0000FF00FFFF00FFFFFFFFFFFFFF0000FFFFFF00000000000000FF00FFFFFF0000000000
0000FFFFFF00FF00000000000000FFFFFF0000FFFFFFFFFFFFFF00FFFF00FF0000FF0000
00FF00000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000FF00FF00FF00
FFFF00FFFF0000FFFFFFFFFFFFFF0000000000000000000000FFFF00FFFFFF00FFFFFFFF
FF00FFFFFF00FFFF0000000000000000000000FFFFFFFFFFFFFF0000FFFF00FFFF00FF00
FF00FF000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000FF0000FF00FF00
00FFFFFF0000FFFFFFFFFFFFFF0000000000000000FF000000FFFF00FF00FFFFFFFFFFFF
FFFFFF00FF00FFFF000000FF0000000000000000FFFFFFFFFFFFFF0000FFFFFF0000FF00
FF0000FF0000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000FF00FF00000000FF
00FFFF0000FFFFFFFFFFFFFFFF000000FF00FF00000000000000FF0000FFFF0000000000
0000FFFF0000FF00000000000000FF00FF000000FFFFFFFFFFFFFFFF0000FFFF00FF0000
0000FF00FF00000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FF00FF0000000000FF
00FF0000FFFFFF00000000000000FF00FFFF00FFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FFFFFFFFFF00FFFF00FF00000000000000FFFFFF0000FF00FF0000
000000FF00FF000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000FF0000000000FF0000FF
00FFFFFFFFFF000000FF000000FFFFFFFFFFFFFFFF0000FF000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000FF0000FFFFFFFFFFFFFFFF000000FF000000FFFFFFFFFF00FF0000
FF0000000000FF0000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000FF000000FF0000000000FF
FFFFFFFFFFFF0000FFFFFFFFFF0000FFFFFFFF00000000FF000000FFFF00FFFFFFFF00FF
FFFFFF00FFFF000000FF00000000FFFFFFFF0000FFFFFFFFFF0000FFFFFFFFFFFFFF0000
000000FF000000FF00000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000FF00FF00FF00FFFF0000FFFF
FFFFFFFFFFFF00FFFFFF000000FFFFFFFFFFFF00000000FF0000FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF0000FF00000000FFFFFFFFFFFF000000FFFFFF00FFFFFFFFFFFFFFFF00
00FFFF00FF00FF00FF000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000FF00FF00FF00FFFF000000FFFF
FF00FFFFFFFF0000FF00000000000000FF0000000000FF000000FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF000000FF0000000000FF00000000000000FF0000FFFFFFFF00FFFFFF00
0000FFFF00FF00FF00FF0000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FF00FF00FF0000000000FFFFFF00
FFFFFFFFFFFF0000FF00000000FFFF0000FFFFFFFFFFFF00FFFF00FFFF00FFFFFF000000
FFFFFF00FFFF00FFFF00FFFFFFFFFFFF0000FFFF00000000FF0000FFFFFFFFFFFF00FFFF
FF0000000000FF00FF00FF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FF00FF00FF00000000FF0000FFFFFF
FFFFFFFFFFFF0000FF000000FFFFFFFF0000000000FFFF000000FFFF0000FFFFFFFFFFFF
FFFFFF0000FFFF000000FFFF0000000000FFFFFFFF000000FF0000FFFFFFFFFFFFFFFFFF
0000FF00000000FF00FF00FF000000000000000000000000000000000000000000
0000000000000000000000000000000000000000FF0000FFFFFF000000000000FFFF00FF
FF00FFFF000000FF00FF00FFFFFFFF00FFFFFF0000FFFFFFFFFFFFFF000000FFFFFF00FF
FFFF000000FFFFFFFFFFFFFF0000FFFFFF00FFFFFFFF00FF00FF000000FFFF00FFFF00FF
FF000000000000FFFFFF0000FF0000000000000000000000000000000000000000
00000000000000000000000000000000000000FF0000000000FF0000FF00FF00000000FF
FFFF00000000FFFF00FF00FFFFFF0000000000FF0000FFFFFFFFFF0000FFFFFF0000FF00
00FFFFFF0000FFFFFFFFFF0000FF0000000000FFFFFF00FF00FFFF00000000FFFFFF0000
0000FF00FF0000FF0000000000FF00000000000000000000000000000000000000
000000000000000000000000000000000000FF00FFFF0000000000FF000000FFFFFF0000
00000000000000FFFFFF0000FF000000FF0000FFFF0000FFFFFFFFFFFFFFFF0000000000
0000FFFFFFFFFFFFFFFF0000FFFF0000FF000000FF0000FFFFFF000000000000000000FF
FFFF000000FF0000000000FFFF00FF000000000000000000000000000000000000
0000000000000000000000000000000000FF00FF00000000000000000000FFFFFFFFFF00
FFFFFF0000FFFFFFFFFFFF0000FF00FFFFFF00FF00000000FFFFFFFFFFFFFF0000000000
0000FFFFFFFFFFFFFF00000000FF00FFFFFF00FF0000FFFFFFFFFFFF0000FFFFFF00FFFF
FFFFFF00000000000000000000FF00FF0000000000000000000000000000000000
00000000000000000000000000000000FF00FF00000000000000000000FFFF00000000FF
00FFFF000000FFFFFFFF00FF00FF0000FF00FFFF000000000000FFFFFFFFFF0000FFFFFF
0000FFFFFFFFFF000000000000FFFF00FF0000FF00FF00FFFFFFFF000000FFFF00FF0000
0000FFFF00000000000000000000FF00FF00000000000000000000000000000000
000000000000000000000000000000FF00FF00000000000000FFFF000000FF00FFFFFF00
00FFFF0000FF00FFFFFF00FF00FF000000FFFF00FF000000FFFF0000FF00000000FFFFFF
00000000FF0000FFFF000000FF00FFFF000000FF00FF00FFFFFF00FF0000FFFF0000FFFF
FF00FF000000FFFF00000000000000FF00FF000000000000000000000000000000
0000000000000000000000000000FF00000000FF0000000000FFFFFF00FFFF00FFFF0000
000000000000FFFF000000FF0000FFFFFFFF00FF00FFFF000000000000000000FF00FF00
FF000000000000000000FFFF00FF00FFFFFFFF0000FF000000FFFF0000000000000000FF
FF00FFFF00FFFFFF0000000000FF00000000FF0000000000000000000000000000
00000000000000000000000000FF00FFFF000000FF00000000FFFFFF00FF0000FF00FFFF
000000000000FFFF000000FF000000FF0000FF0000FFFF00FFFFFFFF00FF00FFFFFFFFFF
FFFF00FF00FFFFFFFF00FFFF0000FF0000FF000000FF000000FFFF000000000000FFFF00
FF0000FF00FFFFFF00000000FF000000FFFF00FF00000000000000000000000000
000000000000000000000000FF00FF00FF0000000000FF00FFFFFF00FFFF0000FF00FFFF
00000000FF00FF00000000FFFFFF0000000000FFFF00FF000000FFFF000000FF0000FF00
00FF000000FFFF000000FF00FFFF0000000000FFFFFF00000000FF00FF00000000FFFF00
FF0000FFFF00FFFFFF00FF0000000000FF00FF00FF000000000000000000000000
0000000000000000000000FF00FF000000FF00FFFFFF00FFFFFF000000FF0000FF000000
000000000000FF000000FFFFFFFFFF00000000FFFFFFFF00000000000000FFFF00FFFFFF
00FFFF00000000000000FFFFFFFF00000000FFFFFFFFFF000000FF000000000000000000
FF0000FF000000FFFFFF00FFFFFF00FF000000FF00FF0000000000000000000000
00000000000000000000FF0000FFFF0000FF000000FFFFFFFF00000000FFFFFFFF0000FF
00FF00000000FFFFFFFF000000FFFFFF0000000000000000FFFF000000FFFFFF00000000
00FFFFFF000000FFFF0000000000000000FFFFFF000000FFFFFFFF00000000FF00FF0000
FFFFFFFF00000000FFFFFFFF000000FF0000FFFF0000FF00000000000000000000
000000000000000000FF00FFFFFFFF00FF00000000FFFFFFFF00FF000000FFFFFFFF0000
00FF000000000000000000FF00FFFFFFFF00FF00FF0000FF00FFFF0000FFFFFFFFFFFFFF
FFFFFFFF0000FFFF00FF0000FF00FF00FFFFFFFF00FF000000000000000000FF000000FF
FFFFFF000000FF00FFFFFFFF00000000FF00FFFFFFFF00FF000000000000000000
0000000000000000FF00FF00FFFFFFFF00FFFF000000FFFFFFFFFFFFFF00FFFF0000FF00
000000FFFF000000000000FF00FFFFFFFF00FF00FF0000FFFF00FF0000FF00FFFFFF00FF
FFFF00FF0000FF00FFFF0000FF00FF00FFFFFFFF00FF000000000000FFFF00000000FF00
00FFFF00FFFFFFFFFFFFFF000000FFFF00FFFFFFFF00FF00FF0000000000000000
00000000000000FF00FF000000000000FFFFFFFFFFFF0000FFFFFFFFFFFFFF000000FFFF
FFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF0000FFFF0000FFFFFFFF00FFFFFF00000000
00FFFFFF00FFFFFFFF0000FFFF0000FFFFFFFFFFFF00FFFF0000FFFFFFFFFFFFFFFFFF00
0000FFFFFFFFFFFFFF0000FFFFFFFFFFFF000000000000FF00FF00000000000000
000000000000FF00FFFFFFFF00000000FFFFFFFF00FF0000FF000000FFFFFF0000FFFFFF
000000000000FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00000000FFFF00FFFFFF00FFFFFF
00FFFFFF00FFFF00000000FFFF0000FFFFFF00FFFFFFFFFFFFFFFF000000000000FFFFFF
0000FFFFFF000000FF0000FF00FFFFFFFF00000000FFFFFFFF00FF000000000000
0000000000FF00FFFF0000000000000000FFFFFFFFFF0000FFFFFFFFFFFFFF000000FFFF
FFFFFFFFFF00FFFFFFFFFFFF000000FFFFFFFF000000000000000000000000FFFF000000
FFFF000000000000000000000000FFFFFFFF000000FFFFFFFFFFFF00FFFFFFFFFFFFFF00
0000FFFFFFFFFFFFFF0000FFFFFFFFFF0000000000000000FFFF00FF0000000000
00000000FF00FF0000FFFF00000000FF00FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF00FFFFFF00FFFF000000FFFFFFFF0000FF0000FFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFF0000FF0000FFFFFFFF000000FFFF00FFFFFF00FFFF0000FFFFFF
FFFFFFFFFFFFFFFFFF00000000FFFFFF00FF00000000FFFF0000FF00FF00000000
000000FF000000FF00FFFF0000FF00000000FFFF000000FFFFFFFFFFFFFFFF00FFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00000000FFFFFF00FFFF00FFFFFFFF000000
FFFFFFFF00FFFF00FFFFFF00000000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF000000FFFF
FF00FFFFFFFFFFFFFFFF000000FFFF00000000FF0000FFFF00FF000000FF000000
0000FF000000000000FFFF0000FF00000000FFFF0000FF00FFFFFFFFFFFFFF0000FFFFFF
FFFF0000FF00FFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFFFFFFFFFFFFFF0000000000
0000FFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF
0000FFFFFFFFFFFFFF00FF0000FFFF00000000FF0000FFFF000000000000FF0000
00FF00FFFF00000000FFFF000000000000FFFFFFFF0000FFFFFFFFFFFFFFFF0000FFFFFF
FF0000FFFF00FFFFFFFFFFFFFFFF0000000000FFFF000000FFFF0000FFFFFF0000FFFFFF
0000FFFFFF0000FFFF000000FFFF0000000000FFFFFFFFFFFFFFFF00FFFF0000FFFFFFFF
0000FFFFFFFFFFFFFFFF0000FFFFFFFF000000000000FFFF00000000FFFF00FF00
FFFF00000000000000FFFF0000000000FFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFF00FFFF00FFFFFFFFFF00FFFF000000FFFF00FF00FF00FFFF00FF00FF0000FFFF00FF
FF0000FF00FF00FFFF00FF00FF00FFFF000000FFFF00FFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF0000000000FFFF00000000000000FFFF
FF000000000000FF00FFFFFFFFFF0000FF00FF000000FFFFFFFF0000FFFFFFFFFF0000FF
FFFF00FFFF00FFFF00000000FF00FF0000FFFFFFFFFFFF00FF0000FF00FF0000FF000000
FF0000FF00FF0000FF00FFFFFFFFFFFF0000FF00FF00000000FFFF00FFFF00FFFFFF0000
FFFFFFFFFF0000FFFFFFFF000000FF00FF0000FFFFFFFFFF00FF000000000000FF
FFFF00000000000000FFFF0000000000FFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFF00FFFF00FFFFFFFFFF00FFFF000000FFFF00FF00FF00FFFF00FF00FF0000FFFF00FF
FF0000FF00FF00FFFF00FF00FF00FFFF000000FFFF00FFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF0000000000FFFF00000000000000FFFF
00FF00FFFF00000000FFFF000000000000FFFFFFFF0000FFFFFFFFFFFFFFFF0000FFFFFF
FF0000FFFF00FFFFFFFFFFFFFFFF0000000000FFFF000000FFFF0000FFFFFF0000FFFFFF
0000FFFFFF0000FFFF000000FFFF0000000000FFFFFFFFFFFFFFFF00FFFF0000FFFFFFFF
0000FFFFFFFFFFFFFFFF0000FFFFFFFF000000000000FFFF00000000FFFF00FF00
0000FF000000000000FFFF0000FF00000000FFFF0000FF00FFFFFFFFFFFFFF0000FFFFFF
FFFF0000FF00FFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFFFFFFFFFFFFFF0000000000
0000FFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF
0000FFFFFFFFFFFFFF00FF0000FFFF00000000FF0000FFFF000000000000FF0000
000000FF000000FF00FFFF0000FF00000000FFFF000000FFFFFFFFFFFFFFFF00FFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00000000FFFFFF00FFFF00FFFFFFFF000000
FFFFFFFF00FFFF00FFFFFF00000000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF000000FFFF
FF00FFFFFFFFFFFFFFFF000000FFFF00000000FF0000FFFF00FF000000FF000000
00000000FF00FF0000FFFF00000000FF00FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF00FFFFFF00FFFF000000FFFFFFFF0000FF0000FFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFF0000FF0000FFFFFFFF000000FFFF00FFFFFF00FFFF0000FFFFFF
FFFFFFFFFFFFFFFFFF00000000FFFFFF00FF00000000FFFF0000FF00FF00000000
0000000000FF00FFFF0000000000000000FFFFFFFFFF0000FFFFFFFFFFFFFF000000FFFF
FFFFFFFFFF00FFFFFFFFFFFF000000FFFFFFFF000000000000000000000000FFFF000000
FFFF000000000000000000000000FFFFFFFF000000FFFFFFFFFFFF00FFFFFFFFFFFFFF00
0000FFFFFFFFFFFFFF0000FFFFFFFFFF0000000000000000FFFF00FF0000000000
000000000000FF00FFFFFFFF00000000FFFFFFFF00FF0000FF000000FFFFFF0000FFFFFF
000000000000FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00000000FFFF00FFFFFF00FFFFFF
00FFFFFF00FFFF00000000FFFF0000FFFFFF00FFFFFFFFFFFFFFFF000000000000FFFFFF
0000FFFFFF000000FF0000FF00FFFFFFFF00000000FFFFFFFF00FF000000000000
00000000000000FF00FF000000000000FFFFFFFFFFFF0000FFFFFFFFFFFFFF000000FFFF
FFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF0000FFFF0000FFFFFFFF00FFFFFF00000000
00FFFFFF00FFFFFFFF0000FFFF0000FFFFFFFFFFFF00FFFF0000FFFFFFFFFFFFFFFFFF00
0000FFFFFFFFFFFFFF0000FFFFFFFFFFFF000000000000FF00FF00000000000000
0000000000000000FF00FF00FFFFFFFF00FFFF000000FFFFFFFFFFFFFF00FFFF0000FF00
000000FFFF000000000000FF00FFFFFFFF00FF00FF0000FFFF00FF0000FF00FFFFFF00FF
FFFF00FF0000FF00FFFF0000FF00FF00FFFFFFFF00FF000000000000FFFF00000000FF00
00FFFF00FFFFFFFFFFFFFF000000FFFF00FFFFFFFF00FF00FF0000000000000000
000000000000000000FF00FFFFFFFF00FF00000000FFFFFFFF00FF000000FFFFFFFF0000
00FF000000000000000000FF00FFFFFFFF00FF00FF0000FF00FFFF0000FFFFFFFFFFFFFF
FFFFFFFF0000FFFF00FF0000FF00FF00FFFFFFFF00FF000000000000000000FF000000FF
FFFFFF000000FF00FFFFFFFF00000000FF00FFFFFFFF00FF000000000000000000
00000000000000000000FF0000FFFF0000FF000000FFFFFFFF00000000FFFFFFFF0000FF
00FF00000000FFFFFFFF000000FFFFFF0000000000000000FFFF000000FFFFFF00000000
00FFFFFF000000FFFF0000000000000000FFFFFF000000FFFFFFFF00000000FF00FF0000
FFFFFFFF00000000FFFFFFFF000000FF0000FFFF0000FF00000000000000000000
0000000000000000000000FF00FF000000FF00FFFFFF00FFFFFF000000FF0000FF000000
000000000000FF000000FFFFFFFFFF00000000FFFFFFFF00000000000000FFFF00FFFFFF
00FFFF00000000000000FFFFFFFF00000000FFFFFFFFFF000000FF000000000000000000
FF0000FF000000FFFFFF00FFFFFF00FF000000FF00FF0000000000000000000000
000000000000000000000000FF00FF00FF0000000000FF00FFFFFF00FFFF0000FF00FFFF
00000000FF00FF00000000FFFFFF0000000000FFFF00FF000000FFFF000000FF0000FF00
00FF000000FFFF000000FF00FFFF0000000000FFFFFF00000000FF00FF00000000FFFF00
FF0000FFFF00FFFFFF00FF0000000000FF00FF00FF000000000000000000000000
00000000000000000000000000FF00FFFF000000FF00000000FFFFFF00FF0000FF00FFFF
000000000000FFFF000000FF000000FF0000FF0000FFFF00FFFFFFFF00FF00FFFFFFFFFF
FFFF00FF00FFFFFFFF00FFFF0000FF0000FF000000FF000000FFFF000000000000FFFF00
FF0000FF00FFFFFF00000000FF000000FFFF00FF00000000000000000000000000
0000000000000000000000000000FF00000000FF0000000000FFFFFF00FFFF00FFFF0000
000000000000FFFF000000FF0000FFFFFFFF00FF00FFFF000000000000000000FF00FF00
FF000000000000000000FFFF00FF00FFFFFFFF0000FF000000FFFF0000000000000000FF
FF00FFFF00FFFFFF0000000000FF00000000FF0000000000000000000000000000
000000000000000000000000000000FF00FF00000000000000FFFF000000FF00FFFFFF00
00FFFF0000FF00FFFFFF00FF00FF000000FFFF00FF000000FFFF0000FF00000000FFFFFF
00000000FF0000FFFF000000FF00FFFF000000FF00FF00FFFFFF00FF0000FFFF0000FFFF
FF00FF000000FFFF00000000000000FF00FF000000000000000000000000000000
00000000000000000000000000000000FF00FF00000000000000000000FFFF00000000FF
00FFFF000000FFFFFFFF00FF00FF0000FF00FFFF000000000000FFFFFFFFFF0000FFFFFF
0000FFFFFFFFFF000000000000FFFF00FF0000FF00FF00FFFFFFFF000000FFFF00FF0000
0000FFFF00000000000000000000FF00FF00000000000000000000000000000000
0000000000000000000000000000000000FF00FF00000000000000000000FFFFFFFFFF00
FFFFFF0000FFFFFFFFFFFF0000FF00FFFFFF00FF00000000FFFFFFFFFFFFFF0000000000
0000FFFFFFFFFFFFFF00000000FF00FFFFFF00FF0000FFFFFFFFFFFF0000FFFFFF00FFFF
FFFFFF00000000000000000000FF00FF0000000000000000000000000000000000
000000000000000000000000000000000000FF00FFFF0000000000FF000000FFFFFF0000
00000000000000FFFFFF0000FF000000FF0000FFFF0000FFFFFFFFFFFFFFFF0000000000
0000FFFFFFFFFFFFFFFF0000FFFF0000FF000000FF0000FFFFFF000000000000000000FF
FFFF000000FF0000000000FFFF00FF000000000000000000000000000000000000
00000000000000000000000000000000000000FF0000000000FF0000FF00FF00000000FF
FFFF00000000FFFF00FF00FFFFFF0000000000FF0000FFFFFFFFFF0000FFFFFF0000FF00
00FFFFFF0000FFFFFFFFFF0000FF0000000000FFFFFF00FF00FFFF00000000FFFFFF0000
0000FF00FF0000FF0000000000FF00000000000000000000000000000000000000
0000000000000000000000000000000000000000FF0000FFFFFF000000000000FFFF00FF
FF00FFFF000000FF00FF00FFFFFFFF00FFFFFF0000FFFFFFFFFFFFFF000000FFFFFF00FF
FFFF000000FFFFFFFFFFFFFF0000FFFFFF00FFFFFFFF00FF00FF000000FFFF00FFFF00FF
FF000000000000FFFFFF0000FF0000000000000000000000000000000000000000
000000000000000000000000000000000000000000FF00FF00FF00000000FF0000FFFFFF
FFFFFFFFFFFF0000FF000000FFFFFFFF0000000000FFFF000000FFFF0000FFFFFFFFFFFF
FFFFFF0000FFFF000000FFFF0000000000FFFFFFFF000000FF0000FFFFFFFFFFFFFFFFFF
0000FF00000000FF00FF00FF000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FF00FF00FF0000000000FFFFFF00
FFFFFFFFFFFF0000FF00000000FFFF0000FFFFFFFFFFFF00FFFF00FFFF00FFFFFF000000
FFFFFF00FFFF00FFFF00FFFFFFFFFFFF0000FFFF00000000FF0000FFFFFFFFFFFF00FFFF
FF0000000000FF00FF00FF00000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000FF00FF00FF00FFFF000000FFFF
FF00FFFFFFFF0000FF00000000000000FF0000000000FF000000FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF000000FF0000000000FF00000000000000FF0000FFFFFFFF00FFFFFF00
0000FFFF00FF00FF00FF0000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000FF00FF00FF00FFFF0000FFFF
FFFFFFFFFFFF00FFFFFF000000FFFFFFFFFFFF00000000FF0000FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF0000FF00000000FFFFFFFFFFFF000000FFFFFF00FFFFFFFFFFFFFFFF00
00FFFF00FF00FF00FF000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000FF000000FF0000000000FF
FFFFFFFFFFFF0000FFFFFFFFFF0000FFFFFFFF00000000FF000000FFFF00FFFFFFFF00FF
FFFFFF00FFFF000000FF00000000FFFFFFFF0000FFFFFFFFFF0000FFFFFFFFFFFFFF0000
000000FF000000FF00000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000FF0000000000FF0000FF
00FFFFFFFFFF000000FF000000FFFFFFFFFFFFFFFF0000FF000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000FF0000FFFFFFFFFFFFFFFF000000FF000000FFFFFFFFFF00FF0000
FF0000000000FF0000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FF00FF0000000000FF
00FF0000FFFFFF00000000000000FF00FFFF00FFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FFFFFFFFFF00FFFF00FF00000000000000FFFFFF0000FF00FF0000
000000FF00FF000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000FF00FF00000000FF
00FFFF0000FFFFFFFFFFFFFFFF000000FF00FF00000000000000FF0000FFFF0000000000
0000FFFF0000FF00000000000000FF00FF000000FFFFFFFFFFFFFFFF0000FFFF00FF0000
0000FF00FF00000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000FF0000FF00FF00
00FFFFFF0000FFFFFFFFFFFFFF0000000000000000FF000000FFFF00FF00FFFFFFFFFFFF
FFFFFF00FF00FFFF000000FF0000000000000000FFFFFFFFFFFFFF0000FFFFFF0000FF00
FF0000FF0000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000FF00FF00FF00
FFFF00FFFF0000FFFFFFFFFFFFFF0000000000000000000000FFFF00FFFFFF00FFFFFFFF
FF00FFFFFF00FFFF0000000000000000000000FFFFFFFFFFFFFF0000FFFF00FFFF00FF00
FF00FF000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000FF000000FF
0000FF00FFFF00FFFFFFFFFFFFFF0000FFFFFF00000000000000FF00FFFFFF0000000000
0000FFFFFF00FF00000000000000FFFFFF0000FFFFFFFFFFFFFF00FFFF00FF0000FF0000
00FF00000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000FF000000
000000FFFFFFFFFFFFFF00FFFF00FF00FFFFFF00000000FFFF00FF00FF0000FF00FFFFFF
00FF0000FF00FF00FFFF00000000FFFFFF00FF00FFFF00FFFFFFFFFFFFFF000000000000
FF0000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000FF00FF
000000FF00000000FFFFFFFFFFFFFF00FF000000000000000000FF00FF0000FFFFFFFFFF
FFFF0000FF00FF000000000000000000FF00FFFFFFFFFFFFFF00000000FF000000FF00FF
000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000FF00
FF00FF0000FFFFFFFFFFFF00FFFFFF0000FF0000FFFF00FF0000FFFFFFFF00FFFFFFFFFF
FFFF00FFFFFFFF0000FF00FFFF0000FF0000FFFFFF00FFFFFFFFFFFF0000FF00FF00FF00
000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000FF
000000FFFF00000000FFFFFFFF000000FF00FF00FFFF000000FFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFF000000FFFF00FF00FF000000FFFFFFFF00000000FFFF000000FF0000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
FF00000000000000000000FFFFFF00FFFF00FFFF00000000FF0000FF00FFFFFFFFFF00FF
FFFFFFFF00FF0000FF00000000FFFF00FFFF00FFFFFF00000000000000000000FF000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00FF00FFFF0000FF000000FF00FF00FFFF00FFFFFFFFFFFFFF00000000FFFF0000FFFFFF
0000FFFF00000000FFFFFFFFFFFFFF00FFFF00FF00FF000000FF0000FFFF00FF00000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000FF000000000000FF0000000000FFFF000000000000FFFFFF000000FF000000FFFFFF
000000FF000000FFFFFF000000000000FFFF0000000000FF000000000000FF0000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000FF00FF000000FFFF00FF00FF00FFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF000000FFFFFFFF00FF00FF00FFFF000000FF00FF000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000FF00FF00FF00FF000000000000FF00FFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FFFFFFFFFF00FF000000000000FF00FF00FF00FF00000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000FF000000FF00000000FF000000000000FF000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF000000FF000000000000FF00000000FF000000FF0000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000FF000000FF00000000FF000000FFFF00000000FFFF00FFFFFFFFFFFF00FF
FFFFFFFFFF00FFFF00000000FFFF000000FF00000000FF000000FF000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000FF00FF00FF000000000000FFFFFFFF0000FFFFFF00FFFFFFFFFF000000
FFFFFFFFFF00FFFFFF0000FFFFFFFF000000000000FF00FF00FF00000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000FF00FF00FFFFFF000000FFFFFFFFFF0000FFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFF0000FFFFFFFFFF000000FFFFFF00FF00FF0000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000FF00FF00FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00FF00FF000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000FF00FFFF0000000000000000FFFFFFFF00000000FF00FFFFFFFF
FF00FF00000000FFFFFFFF0000000000000000FFFF00FF00000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000FF000000000000000000FF00FFFFFF0000000000FF00FFFFFF
00FF0000000000FFFFFF00FF000000000000000000FF0000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000FF0000FF000000000000FFFFFF00FFFFFF00000000000000
00000000FFFFFF00FFFFFF000000000000FF0000FF000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000FF00FF00000000FF00FF000000FF00FF000000FFFF00FF
FF000000FF00FF000000FF00FF00000000FF00FF00000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000FF00FF0000FF0000FF000000FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF000000FF0000FF0000FF00FF0000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000FF00FF00000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000FF00FF000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000FF00FF000000FFFF00FFFFFFFFFF0000FFFF00FF
FF0000FFFFFFFFFF00FFFF000000FF00FF00000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000FF0000FFFF0000FF00FFFF0000000000FFFFFF
0000000000FFFF00FF0000FFFF0000FF0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000FF00FF00000000FF000000FF000000000000
000000FF000000FF00000000FF00FF000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000FF00FF00FFFFFF00000000000000000000
00000000000000FFFFFF00FF00FF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000FF00FFFFFFFF00000000FFFF0000FF00
00FFFF00000000FFFFFFFF00FF0000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FF0000FFFF0000000000000000FF00
00000000000000FFFF0000FF000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FF00FF0000FF000000000000FF00
0000000000FF0000FF00FF00000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000FF00FF00FF00FFFFFFFFFFFFFF
FFFFFFFF00FF00FF00FF0000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000FF00FFFF00FFFFFFFFFFFFFF
FFFFFFFF00FFFF00FF000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000FF00FFFF00000000000000
00000000FFFF00FF00000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000FF00FF00FF000000FF00
0000FF00FF00FF0000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FF00FF000000000000
000000FF00FF000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000FF00000000000000
00000000FF00000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000FF0000FF000000
FF0000FF0000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000FF00FF000000
FF00FF000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000FF00000000
00FF00000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000FFFF00FF
FF0000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000FFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S3.8.6"]
}, Open  ]],

Cell[TextData[{
  "This shows all steps in a slice along the ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " axis. "
}], "MathCaption",
  CellTags->{"S3.8.6", "6.45"}],

Cell[CellGroupData[{

Cell["\<\
ArrayPlot[Map[First, CellularAutomaton[code797, {{{1}}, 0}, 70, \
{All, {0}, All}]]]\
\>", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S3.8.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .50355 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00675447 0.0119892 0.00675447 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .50355 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .50355 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .50355 L
s
0 .50355 m
1 .50355 L
s
1 0 m
1 .50355 L
s
0 0 m
1 0 L
1 .50355 L
0 .50355 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01199 translate
.95238 .47957 scale
141 string
141 71 8 [141 0 0 71 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF000000000000FF00FFFFFFFFFF0000FF00FF000000FFFFFFFF0000FFFFFFFFFF0000FF
FFFF00FFFF00FFFF00000000FF00FF0000FFFFFFFFFFFF00FF0000FF00FF0000FF000000
FF0000FF00FF0000FF00FFFFFFFFFFFF0000FF00FF00000000FFFF00FFFF00FFFFFF0000
FFFFFFFFFF0000FFFFFFFF000000FF00FF0000FFFFFFFFFF00FF000000000000FF
00FF0000FF0000FFFF00FF00FF00FFFF0000FF00FF00000000FFFF00000000FF000000FF
FF00FF00FF00FF000000000000FF00FF00000000000000FF00FF00000000FFFF0000FF00
00FFFF00000000FF00FF00000000000000FF00FF000000000000FF00FF00FF00FFFF0000
00FF00000000FFFF00000000FF00FF0000FFFF00FF00FF00FFFF0000FF0000FF00
0000FF00000000FFFF000000FFFF0000FFFFFF0000FFFF00FF00FFFFFFFF00000000FF00
00FFFF00FF0000FF0000FF00000000FF00FFFFFFFFFFFFFF00000000000000FFFFFF00FF
FFFF00000000000000FFFFFFFFFFFFFF00FF00000000FF0000FF0000FF00FFFF0000FF00
000000FFFFFFFF00FF00FFFF0000FFFFFF0000FFFF000000FFFF00000000FF0000
000000FF0000FF0000FFFFFF0000FF00000000000000FF00FF000000000000000000FFFF
FF0000FFFF0000FF0000FF000000FFFF00FF0000FF00FFFFFFFFFFFFFFFF00FF00FFFFFF
00FF00FFFFFFFFFFFFFFFF00FF0000FF00FFFF000000FF0000FF0000FFFF0000FFFFFF00
0000000000000000FF00FF00000000000000FF0000FFFFFF0000FF0000FF000000
00000000FF0000000000FF00000000FFFFFFFF00FFFF000000FFFFFF00FFFF0000FFFF00
FF0000000000FF0000FFFF00000000FF000000FF00FF0000FFFF000000000000FFFF00FF
FF000000000000FFFF0000FF00FF000000FF00000000FFFF0000FF0000000000FF00FFFF
0000FFFF00FFFFFF000000FFFF00FFFFFFFF00000000FF0000000000FF00000000
0000000000FF0000FF000000FFFFFF0000FF000000FF0000FF0000FF00FF000000FFFF00
FFFF00FFFFFFFF000000000000000000FFFFFF00FF00FFFF0000FF0000FF0000FF00FF00
FF0000FF0000FF0000FFFF00FF00FFFFFF000000000000000000FFFFFFFF00FFFF00FFFF
000000FF00FF0000FF0000FF000000FF0000FFFFFF000000FF0000FF0000000000
000000000000FF000000000000FF00000000FFFFFF000000FFFFFF000000FF0000FFFF00
000000FFFF00FFFFFFFFFF00FFFFFFFF0000FFFFFF000000000000FF00FF0000FFFF00FF
FF0000FF00FF000000000000FFFFFF0000FFFFFFFF00FFFFFFFFFF00FFFF00000000FFFF
0000FF000000FFFFFF000000FFFFFF00000000FF000000000000FF000000000000
00000000000000FF0000FF0000FFFFFFFFFF000000000000FFFFFF000000FF0000FFFF00
00FF00000000FF0000FF00FF0000000000FF0000000000FF00000000FF00FF000000FF00
0000FF00FF00000000FF0000000000FF0000000000FF00FF0000FF00000000FF0000FFFF
0000FF000000FFFFFF000000000000FFFFFFFFFF0000FF0000FF00000000000000
0000000000000000FF00000000FFFFFFFF0000FFFFFFFFFFFF00FFFF00FFFF00FFFF0000
0000FFFFFFFF00000000FFFF0000000000FFFFFFFFFFFFFF000000000000FF00FF000000
FF00FF000000000000FFFFFFFFFFFFFF0000000000FFFF00000000FFFFFFFF00000000FF
FF00FFFF00FFFF00FFFFFFFFFFFF0000FFFFFFFF00000000FF0000000000000000
000000000000000000FF0000FF0000FF00000000FF0000000000FF0000FF000000FF00FF
FF00FF0000FF00FFFF0000000000000000FFFF00FFFF0000000000FF0000FFFF0000FF00
00FFFF0000FF0000000000FFFF00FFFF0000000000000000FFFF00FF0000FF00FFFF00FF
000000FF0000FF0000000000FF00000000FF0000FF0000FF000000000000000000
00000000000000000000FF0000000000FFFF00FFFF00FFFFFFFF00000000FFFF00FF00FF
000000FFFFFF000000FFFFFFFF0000FF0000FF000000000000000000FFFFFF00FF000000
FF00FFFFFF000000000000000000FF0000FF0000FFFFFFFF000000FFFFFF000000FF00FF
00FFFF00000000FFFFFFFF00FFFF00FFFF0000000000FF00000000000000000000
0000000000000000000000FF0000FF0000000000FF00000000FF00FF0000FF0000FFFFFF
00FFFF0000FF00FFFF0000FF000000FF00FFFF0000FF00000000000000FF000000FFFFFF
000000FF00000000000000FF0000FFFF00FF000000FF0000FFFF00FF0000FFFF00FFFFFF
0000FF0000FF00FF00000000FF0000000000FF0000FF0000000000000000000000
000000000000000000000000FF000000000000FF00FFFFFFFFFF0000FFFF000000000000
0000FF00FFFF000000000000FFFFFF0000000000000000FFFFFF00FF0000000000FF00FF
0000000000FF00FFFFFF0000000000000000FFFFFF000000000000FFFF00FF0000000000
000000FFFF0000FFFFFFFFFF00FF000000000000FF000000000000000000000000
00000000000000000000000000FF0000FF0000FFFF00FF000000FFFF0000FFFF00FFFFFF
FF00FF00FF0000000000000000FF0000000000000000FF00FF000000FF00FF00FF00FF00
FF00FF00FF000000FF00FF0000000000000000FF0000000000000000FF00FF00FFFFFFFF
00FFFF0000FFFF000000FF00FFFF0000FF0000FF00000000000000000000000000
0000000000000000000000000000FF00000000FFFF000000FFFF00FF0000FFFF00FF00FF
FFFFFF0000000000FF00000000FFFFFF0000FFFFFFFFFF0000000000FF00FFFFFF000000
FFFFFF00FF0000000000FFFFFFFFFF0000FFFFFF00000000FF0000000000FFFFFFFF00FF
00FFFF0000FF00FFFF000000FFFF00000000FF0000000000000000000000000000
000000000000000000000000000000FF0000FF0000FFFFFF000000FFFFFFFF000000FFFF
00FFFF00000000FFFF0000000000FF000000FF00FFFF00FFFF00FFFF00000000FF000000
FF00000000FFFF00FFFF00FFFF00FF000000FF0000000000FFFF00000000FFFF00FFFF00
0000FFFFFFFF000000FFFFFF0000FF0000FF000000000000000000000000000000
00000000000000000000000000000000FF0000000000FF00000000FFFF00FF00FF00FFFF
FFFF0000000000000000FF000000FFFFFFFF000000FF00FF000000FFFFFFFFFFFF00FF00
FFFFFFFFFFFF000000FF00FF000000FFFFFFFF000000FF0000000000000000FFFFFFFF00
FF00FF00FFFF00000000FF0000000000FF00000000000000000000000000000000
0000000000000000000000000000000000FF0000FF000000FFFFFF0000FFFF00000000FF
000000FF00FFFFFFFF00FF00FFFF0000FF000000FF00FF00FF0000FF00FF000000FF00FF
000000FF00FF0000FF00FF00FF000000FF0000FFFF00FF00FFFFFFFF00FF000000FF0000
0000FFFF0000FFFFFF000000FF0000FF0000000000000000000000000000000000
000000000000000000000000000000000000FF000000000000FF0000000000FFFFFFFFFF
000000FF00FFFF00FFFFFF00000000FF00FF0000FFFFFF0000FFFF00000000FF0000FF00
00FF00000000FFFF0000FFFFFF0000FF00FF00000000FFFFFF00FFFF00FF000000FFFFFF
FFFF0000000000FF000000000000FF000000000000000000000000000000000000
00000000000000000000000000000000000000FF0000FF0000FFFFFFFFFFFFFF0000FF00
FFFFFF000000FF0000FF00FFFFFF00FFFFFF0000000000000000FF00FFFF0000FFFF00FF
FF0000FFFF00FF0000000000000000FFFFFF00FFFFFF00FF0000FF000000FFFFFF00FF00
00FFFFFFFFFFFFFF0000FF0000FF00000000000000000000000000000000000000
0000000000000000000000000000000000000000FF00000000FFFFFFFF0000FFFF000000
FFFF00000000FFFFFFFF00000000FFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF00
FFFFFF00FF00FFFFFFFFFFFFFFFFFFFF00FFFF00000000FFFFFFFF00000000FFFF000000
FFFF0000FFFFFFFF00000000FF0000000000000000000000000000000000000000
000000000000000000000000000000000000000000FF0000FF0000FF00000000000000FF
00FF00000000000000FF0000FF00FF000000000000FF0000FFFF0000FFFF0000FFFF00FF
FF0000FFFF0000FFFF0000FF000000000000FF00FF0000FF00000000000000FF00FF0000
0000000000FF0000FF0000FF000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FF0000000000FFFF00FFFFFFFFFF
0000FF00000000FF0000FFFFFF000000000000000000FF000000FF0000FFFFFF00FFFFFF
00FFFFFF0000FF000000FF000000000000000000FFFFFF0000FF00000000FF0000FFFFFF
FFFF00FFFF0000000000FF00000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000FF0000FF0000000000FF000000
FF00FFFFFFFF00000000000000FF0000FF000000FF000000FFFFFF000000000000FF00FF
000000000000FFFFFF000000FF000000FF0000FF00000000000000FFFFFFFF00FF000000
FF0000000000FF0000FF0000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000FF000000000000FF00FFFFFF
FF000000FF00FF00000000000000FFFFFF00000000FFFFFFFF00FFFFFFFFFFFFFF000000
FFFFFFFFFFFFFF00FFFFFFFF00000000FFFFFF00000000000000FF00FF000000FFFFFFFF
00FF000000000000FF000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000FF0000FF0000FFFF00FF00
0000FF000000FFFFFFFF00FFFF00FF0000FFFFFFFF0000FF00FF00FFFF0000FF00000000
00FF0000FFFF00FF00FF0000FFFFFFFF0000FF00FFFF00FFFFFFFF000000FF000000FF00
FFFF0000FF0000FF00000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000FF00000000FFFF000000
FFFF00FF00FF0000FF000000FF00FFFFFFFF00FF000000FF00FFFF00FF00FF0000000000
0000FF00FF00FFFF00FF000000FF00FFFFFFFF00FF000000FF0000FF00FF00FFFF000000
FFFF00000000FF0000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FF0000FF0000FFFFFF
000000FFFF00000000FFFF00FF00FF00000000FFFFFFFF00FF00FFFFFF00000000000000
00000000FFFFFF00FF00FFFFFFFF00000000FF00FF00FFFF00000000FFFF000000FFFFFF
0000FF0000FF000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000FF0000000000FF00
000000FFFF0000000000FF00FF00FF00FFFF0000000000FFFF0000000000000000000000
0000000000000000FFFF0000000000FFFF00FF00FF00FF0000000000FFFF00000000FF00
00000000FF00000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000FF0000FF000000
FFFFFF0000FFFFFFFFFF000000FFFF000000FFFFFFFFFF00FF0000FF00FFFF00FF00FF00
FF00FFFF00FF0000FF00FFFFFFFFFF000000FFFF000000FFFFFFFFFF0000FFFFFF000000
FF0000FF0000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000FF0000000000
00FF00000000FF00000000FF00000000FFFF00FFFF000000FFFFFFFF0000000000FF00FF
0000000000FFFFFFFF000000FFFF00FFFF00000000FF00000000FF00000000FF00000000
0000FF000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000FF0000FF00
00FFFFFFFFFFFF00FF0000FFFFFFFFFF00FF00FFFF00FF000000000000FF00FF00000000
00FF00FF000000000000FF00FFFF00FF00FFFFFFFFFF0000FF00FFFFFFFFFFFF0000FF00
00FF00000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000FF000000
00FFFFFFFF000000FFFFFFFF00FF0000FF00FF000000FFFFFFFF00FFFFFF00FF00000000
00FF00FFFFFF00FFFFFFFF000000FF00FF0000FF00FFFFFFFF000000FFFFFFFF00000000
FF0000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000FF0000
FF0000FF00000000000000000000FFFF00FF0000FFFFFFFF000000000000FFFF00FFFFFF
00FFFF000000000000FFFFFFFF0000FF00FFFF00000000000000000000FF0000FF0000FF
000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000FF00
00000000FFFF00FFFFFFFFFFFFFF000000FFFFFF00000000000000000000FFFF00000000
00FFFF00000000000000000000FFFFFF000000FFFFFFFFFFFFFF00FFFF0000000000FF00
000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000FF
0000FF0000000000FF0000FF0000FFFFFF00000000FFFFFF00FFFF00FFFF0000FFFFFFFF
FF0000FFFF00FFFF00FFFFFF00000000FFFFFF0000FF0000FF0000000000FF0000FF0000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
FF000000000000FF00FFFF00000000FF0000FF000000FF000000FF00FF000000FFFF00FF
FF000000FF00FF000000FF000000FF0000FF00000000FFFF00FF000000000000FF000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00FF0000FF0000FFFF00FFFF000000FFFF000000FF000000FFFF000000FFFF00FF000000
FF00FFFF000000FFFF000000FF000000FFFF000000FFFF00FFFF0000FF0000FF00000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000FF00000000FFFF00000000FF00FF00000000FFFFFFFF0000FFFF00FF000000FFFFFF
000000FF00FFFF0000FFFFFFFF00000000FF00FF00000000FFFF00000000FF0000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000FF0000FF0000FFFFFF0000000000FFFFFF0000FF000000000000FF00FFFFFF00FF
FFFF00FF000000000000FF0000FFFFFF0000000000FFFFFF0000FF0000FF000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000FF0000000000FF00000000000000FF00000000FFFFFF00FFFF000000FF000000
FF000000FFFF00FFFFFF00000000FF00000000000000FF0000000000FF00000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000FF0000FF000000FFFFFFFFFFFF000000000000FF000000FF00FFFF00000000
00FFFF00FF000000FF000000000000FFFFFFFFFFFF000000FF0000FF0000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000FF000000000000FF0000FF0000FF000000FF00FF00000000FF0000000000
0000FF00000000FF00FF000000FF0000FF0000FF000000000000FF000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000FF0000FF0000FFFFFFFF0000FFFFFFFFFF00FF0000FF0000FFFFFFFFFF
FFFF0000FF0000FF00FFFFFFFFFF0000FFFFFFFF0000FF0000FF00000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000FF00000000FFFFFF00FF00FFFF00FFFF00FFFF00FF00FF00FFFF00FF
FF00FF00FF00FFFF00FFFF00FFFF00FF00FFFFFF00000000FF0000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000FF0000FF0000FF000000FFFFFFFF000000FF00FF00FF00FF000000
FF00FF00FF00FF000000FFFFFFFF000000FF0000FF0000FF000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000FF0000000000FFFFFFFF00FF00000000FF00FFFFFF0000000000
0000FFFFFF00FF00000000FF00FFFFFFFF0000000000FF00000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000FF0000FF00000000FFFFFFFFFFFFFF00FF00FF000000000000
000000FF00FF00FFFFFFFFFFFFFF00000000FF0000FF0000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000FF000000000000FFFFFF00000000FFFF0000000000000000
0000000000FFFF00000000FFFFFF000000000000FF000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000FF0000FF0000FFFF00FFFFFFFF00000000000000000000
00000000000000FFFFFFFF00FFFF0000FF0000FF00000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000FF00000000FFFF000000000000FFFF0000FFFFFFFFFF
FFFF0000FFFF000000000000FFFF00000000FF0000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000FF0000FF0000FF0000FFFFFF000000FF0000000000
0000FF000000FFFFFF0000FF0000FF0000FF000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000FF0000000000FF0000000000000000FFFFFFFFFF
FFFF0000000000000000FF0000000000FF00000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000FF0000FF000000FFFFFFFFFFFF000000000000
000000FFFFFFFFFFFF000000FF0000FF0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000FF000000000000FF00000000FF000000FF00
0000FF00000000FF000000000000FF000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000FF0000FF0000FFFFFFFFFFFF00FF000000
FF00FFFFFFFFFFFF0000FF0000FF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000FF00000000FFFFFF00FFFF0000FFFFFF
0000FFFF00FFFFFF00000000FF0000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FF0000FF0000FF0000000000FF00FF
0000000000FF0000FF0000FF000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FF0000000000FFFFFF0000FFFFFF
0000FFFFFF0000000000FF00000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000FF0000FF00000000FFFFFF00FF
FFFF00000000FF0000FF0000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000FF000000000000FFFF000000
FFFF000000000000FF000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000FF0000FF00000000000000
00000000FF0000FF00000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000FF000000000000000000
000000000000FF0000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FF0000FF00FFFFFFFF
FF00FF0000FF000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000FF00000000000000
00000000FF00000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000FF00000000FF00
000000FF0000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000FF0000FF00FF
0000FF000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000FF0000FF00
00FF00000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000FF000000
FF0000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000FFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.8.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S3.8.6"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S3.8.0"->{
    Cell[1776, 53, 131, 4, 65, "Section",
      CellTags->{"S3.8.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 131, 4, 65, "Section",
      CellTags->{"S3.8.0", "0.1"}]},
  "S3.8.1"->{
    Cell[1932, 61, 75, 1, 70, "Subsection",
      CellTags->{"S3.8.1", "1.1"}],
    Cell[2010, 64, 1916, 56, 70, "DefinitionBox",
      CellTags->"S3.8.1"],
    Cell[3929, 122, 82, 1, 70, "Caption",
      CellTags->"S3.8.1"],
    Cell[4014, 125, 978, 39, 70, "Text",
      CellTags->{"S3.8.1", "1.2"}],
    Cell[4995, 166, 982, 35, 70, "Text",
      CellTags->{"S3.8.1", "1.3"}],
    Cell[5980, 203, 558, 21, 70, "Text",
      CellTags->{"S3.8.1", "1.4"}],
    Cell[6541, 226, 390, 8, 70, "Text",
      CellTags->{"S3.8.1", "1.5"}],
    Cell[6934, 236, 434, 13, 70, "Text",
      CellTags->{"S3.8.1", "1.6"}],
    Cell[7371, 251, 658, 26, 70, "Text",
      CellTags->{"S3.8.1", "1.7"}],
    Cell[8032, 279, 691, 32, 70, "Text",
      CellTags->{"S3.8.1", "1.8"}],
    Cell[8726, 313, 1828, 63, 70, "Text",
      CellTags->{"S3.8.1", "1.9"}],
    Cell[10557, 378, 2578, 89, 70, "Text",
      CellTags->{"S3.8.1", "1.10"}],
    Cell[13138, 469, 2992, 96, 70, "DefinitionBox",
      CellTags->"S3.8.1"],
    Cell[16133, 567, 81, 1, 70, "Caption",
      CellTags->"S3.8.1"],
    Cell[16217, 570, 1197, 40, 70, "Text",
      CellTags->{"S3.8.1", "1.11"}],
    Cell[17417, 612, 710, 30, 70, "Text",
      CellTags->{"S3.8.1", "1.12"}],
    Cell[18130, 644, 3165, 92, 70, "DefinitionBox",
      CellTags->"S3.8.1"],
    Cell[21298, 738, 73, 1, 70, "Caption",
      CellTags->"S3.8.1"],
    Cell[21374, 741, 269, 6, 70, "Text",
      CellTags->{"S3.8.1", "1.13"}],
    Cell[21646, 749, 169, 5, 70, "MathCaption",
      CellTags->{"S3.8.1", "1.14"}],
    Cell[21840, 758, 100, 2, 70, "Input",
      CellTags->"S3.8.1"],
    Cell[21943, 762, 133, 3, 70, "Output",
      CellTags->"S3.8.1"],
    Cell[22091, 768, 420, 14, 70, "Text",
      CellTags->{"S3.8.1", "1.15"}],
    Cell[22514, 784, 359, 10, 70, "Text",
      CellTags->{"S3.8.1", "1.16"}]},
  "1.1"->{
    Cell[1932, 61, 75, 1, 70, "Subsection",
      CellTags->{"S3.8.1", "1.1"}]},
  "1.2"->{
    Cell[4014, 125, 978, 39, 70, "Text",
      CellTags->{"S3.8.1", "1.2"}]},
  "1.3"->{
    Cell[4995, 166, 982, 35, 70, "Text",
      CellTags->{"S3.8.1", "1.3"}]},
  "1.4"->{
    Cell[5980, 203, 558, 21, 70, "Text",
      CellTags->{"S3.8.1", "1.4"}]},
  "1.5"->{
    Cell[6541, 226, 390, 8, 70, "Text",
      CellTags->{"S3.8.1", "1.5"}]},
  "1.6"->{
    Cell[6934, 236, 434, 13, 70, "Text",
      CellTags->{"S3.8.1", "1.6"}]},
  "1.7"->{
    Cell[7371, 251, 658, 26, 70, "Text",
      CellTags->{"S3.8.1", "1.7"}]},
  "1.8"->{
    Cell[8032, 279, 691, 32, 70, "Text",
      CellTags->{"S3.8.1", "1.8"}]},
  "1.9"->{
    Cell[8726, 313, 1828, 63, 70, "Text",
      CellTags->{"S3.8.1", "1.9"}]},
  "1.10"->{
    Cell[10557, 378, 2578, 89, 70, "Text",
      CellTags->{"S3.8.1", "1.10"}]},
  "1.11"->{
    Cell[16217, 570, 1197, 40, 70, "Text",
      CellTags->{"S3.8.1", "1.11"}]},
  "1.12"->{
    Cell[17417, 612, 710, 30, 70, "Text",
      CellTags->{"S3.8.1", "1.12"}]},
  "1.13"->{
    Cell[21374, 741, 269, 6, 70, "Text",
      CellTags->{"S3.8.1", "1.13"}]},
  "1.14"->{
    Cell[21646, 749, 169, 5, 70, "MathCaption",
      CellTags->{"S3.8.1", "1.14"}]},
  "1.15"->{
    Cell[22091, 768, 420, 14, 70, "Text",
      CellTags->{"S3.8.1", "1.15"}]},
  "1.16"->{
    Cell[22514, 784, 359, 10, 70, "Text",
      CellTags->{"S3.8.1", "1.16"}]},
  "S3.8.2"->{
    Cell[22910, 799, 72, 1, 70, "Subsection",
      CellTags->{"S3.8.2", "2.1"}],
    Cell[22985, 802, 266, 8, 70, "Text",
      CellTags->{"S3.8.2", "2.2"}],
    Cell[23254, 812, 2150, 61, 70, "DefinitionBox",
      CellTags->"S3.8.2"],
    Cell[25407, 875, 60, 1, 70, "Caption",
      CellTags->"S3.8.2"],
    Cell[25470, 878, 94, 1, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.3"}],
    Cell[25589, 883, 93, 2, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[25685, 887, 164, 4, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[25864, 894, 140, 4, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.4"}],
    Cell[26029, 902, 83, 2, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[26115, 906, 3915, 274, 70, 3842, 271, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.8.2"],
    Cell[30033, 1182, 177, 5, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[30225, 1190, 244, 8, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.5"}],
    Cell[30494, 1202, 82, 2, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[30579, 1206, 129, 3, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[30723, 1212, 81, 1, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.6"}],
    Cell[30829, 1217, 83, 2, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[30915, 1221, 3936, 283, 70, 3863, 280, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.8.2"],
    Cell[34854, 1506, 177, 5, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[35046, 1514, 105, 1, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.7"}],
    Cell[35176, 1519, 75, 2, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[35254, 1523, 3298, 226, 70, 3225, 223, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.8.2"],
    Cell[38555, 1751, 177, 5, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[38747, 1759, 94, 1, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.8"}],
    Cell[38866, 1764, 87, 2, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[38956, 1768, 166, 4, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[39137, 1775, 91, 1, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.9"}],
    Cell[39253, 1780, 83, 2, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[39339, 1784, 3990, 283, 70, 3917, 280, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.8.2"],
    Cell[43332, 2069, 177, 5, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[43524, 2077, 168, 4, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.10"}],
    Cell[43717, 2085, 75, 2, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[43795, 2089, 4368, 304, 70, 4295, 301, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.8.2"],
    Cell[48166, 2395, 177, 5, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[48358, 2403, 5380, 157, 70, "DefinitionBox",
      CellTags->"S3.8.2"],
    Cell[53741, 2562, 66, 1, 70, "Caption",
      CellTags->"S3.8.2"],
    Cell[53810, 2565, 1068, 41, 70, "Text",
      CellTags->{"S3.8.2", "2.11"}],
    Cell[54881, 2608, 1391, 42, 70, "DefinitionBox",
      CellTags->"S3.8.2"],
    Cell[56275, 2652, 60, 1, 70, "Caption",
      CellTags->"S3.8.2"],
    Cell[56338, 2655, 703, 27, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.12"}],
    Cell[57066, 2686, 148, 5, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[57217, 2693, 281, 5, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[57513, 2701, 107, 1, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.13"}],
    Cell[57645, 2706, 98, 2, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[57746, 2710, 225, 5, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[57986, 2718, 613, 13, 70, "Text",
      CellTags->{"S3.8.2", "2.14"}],
    Cell[58602, 2733, 2412, 74, 70, "DefinitionBox",
      CellTags->"S3.8.2"],
    Cell[61017, 2809, 77, 1, 70, "Caption",
      CellTags->"S3.8.2"],
    Cell[61097, 2812, 135, 4, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.15"}],
    Cell[61257, 2820, 110, 2, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[61370, 2824, 191, 4, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[61576, 2831, 135, 5, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.16"}],
    Cell[61736, 2840, 91, 2, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[61830, 2844, 191, 5, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[62036, 2852, 162, 5, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.17"}],
    Cell[62223, 2861, 108, 2, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[62334, 2865, 181, 4, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[62530, 2872, 1579, 54, 70, "Text",
      CellTags->{"S3.8.2", "2.18"}],
    Cell[64112, 2928, 311, 7, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.19"}],
    Cell[64448, 2939, 157, 5, 70, "Input",
      CellTags->"S3.8.2"],
    Cell[64608, 2946, 179, 4, 70, "Output",
      CellTags->"S3.8.2"],
    Cell[64802, 2953, 950, 35, 70, "Text",
      CellTags->{"S3.8.2", "2.20"}],
    Cell[65755, 2990, 2501, 73, 70, "DefinitionBox3Col",
      CellTags->"S3.8.2"],
    Cell[68259, 3065, 106, 5, 70, "Caption",
      CellTags->"S3.8.2"]},
  "2.1"->{
    Cell[22910, 799, 72, 1, 70, "Subsection",
      CellTags->{"S3.8.2", "2.1"}]},
  "2.2"->{
    Cell[22985, 802, 266, 8, 70, "Text",
      CellTags->{"S3.8.2", "2.2"}]},
  "2.3"->{
    Cell[25470, 878, 94, 1, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.3"}]},
  "2.4"->{
    Cell[25864, 894, 140, 4, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.4"}]},
  "2.5"->{
    Cell[30225, 1190, 244, 8, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.5"}]},
  "2.6"->{
    Cell[30723, 1212, 81, 1, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.6"}]},
  "2.7"->{
    Cell[35046, 1514, 105, 1, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.7"}]},
  "2.8"->{
    Cell[38747, 1759, 94, 1, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.8"}]},
  "2.9"->{
    Cell[39137, 1775, 91, 1, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.9"}]},
  "2.10"->{
    Cell[43524, 2077, 168, 4, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.10"}]},
  "2.11"->{
    Cell[53810, 2565, 1068, 41, 70, "Text",
      CellTags->{"S3.8.2", "2.11"}]},
  "2.12"->{
    Cell[56338, 2655, 703, 27, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.12"}]},
  "2.13"->{
    Cell[57513, 2701, 107, 1, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.13"}]},
  "2.14"->{
    Cell[57986, 2718, 613, 13, 70, "Text",
      CellTags->{"S3.8.2", "2.14"}]},
  "2.15"->{
    Cell[61097, 2812, 135, 4, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.15"}]},
  "2.16"->{
    Cell[61576, 2831, 135, 5, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.16"}]},
  "2.17"->{
    Cell[62036, 2852, 162, 5, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.17"}]},
  "2.18"->{
    Cell[62530, 2872, 1579, 54, 70, "Text",
      CellTags->{"S3.8.2", "2.18"}]},
  "2.19"->{
    Cell[64112, 2928, 311, 7, 70, "MathCaption",
      CellTags->{"S3.8.2", "2.19"}]},
  "2.20"->{
    Cell[64802, 2953, 950, 35, 70, "Text",
      CellTags->{"S3.8.2", "2.20"}]},
  "S3.8.3"->{
    Cell[68402, 3075, 98, 1, 70, "Subsection",
      CellTags->{"S3.8.3", "3.1"}],
    Cell[68503, 3078, 826, 18, 70, "Text",
      CellTags->{"S3.8.3", "3.2"}],
    Cell[69332, 3098, 560, 15, 70, "Text",
      CellTags->{"S3.8.3", "3.3"}],
    Cell[69895, 3115, 577, 11, 70, "Text",
      CellTags->{"S3.8.3", "3.4"}],
    Cell[70475, 3128, 3220, 91, 70, "DefinitionBox",
      CellTags->"S3.8.3"],
    Cell[73698, 3221, 77, 1, 70, "Caption",
      CellTags->"S3.8.3"],
    Cell[73778, 3224, 106, 1, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.5"}],
    Cell[73909, 3229, 99, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[74011, 3233, 359, 7, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[74385, 3243, 135, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.6"}],
    Cell[74545, 3251, 86, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[74634, 3255, 166, 5, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[74815, 3263, 142, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.7"}],
    Cell[74982, 3271, 73, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[75058, 3275, 101, 3, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[75174, 3281, 126, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.8"}],
    Cell[75325, 3289, 72, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[75400, 3293, 101, 3, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[75516, 3299, 153, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.9"}],
    Cell[75694, 3307, 72, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[75769, 3311, 101, 3, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[75885, 3317, 297, 7, 70, "Text",
      CellTags->{"S3.8.3", "3.10"}],
    Cell[76185, 3326, 162, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.11"}],
    Cell[76372, 3334, 70, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[76445, 3338, 202, 6, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[76662, 3347, 115, 2, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.12"}],
    Cell[76802, 3353, 98, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[76903, 3357, 100, 3, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[77018, 3363, 129, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.13"}],
    Cell[77172, 3371, 98, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[77273, 3375, 100, 3, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[77388, 3381, 162, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.14"}],
    Cell[77575, 3389, 87, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[77665, 3393, 3714, 256, 70, 3641, 253, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.8.3"],
    Cell[81382, 3651, 177, 5, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[81574, 3659, 225, 6, 70, "Text",
      CellTags->{"S3.8.3", "3.15"}],
    Cell[81802, 3667, 233, 7, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.16"}],
    Cell[82060, 3678, 75, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[82138, 3682, 101, 3, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[82254, 3688, 93, 1, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.17"}],
    Cell[82372, 3693, 77, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[82452, 3697, 101, 3, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[82568, 3703, 551, 13, 70, "Text",
      CellTags->{"S3.8.3", "3.18"}],
    Cell[83122, 3718, 209, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.19"}],
    Cell[83356, 3727, 68, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[83427, 3731, 167, 5, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[83609, 3739, 218, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.20"}],
    Cell[83852, 3748, 71, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[83926, 3752, 226, 4, 70, "Message",
      CellTags->"S3.8.3"],
    Cell[84155, 3758, 103, 3, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[84273, 3764, 345, 7, 70, "Text",
      CellTags->{"S3.8.3", "3.21"}],
    Cell[84621, 3773, 1974, 58, 70, "DefinitionBox",
      CellTags->"S3.8.3"],
    Cell[86598, 3833, 114, 4, 70, "Caption",
      CellTags->"S3.8.3"],
    Cell[86715, 3839, 446, 14, 70, "Text",
      CellTags->{"S3.8.3", "3.22"}],
    Cell[87164, 3855, 108, 1, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.23"}],
    Cell[87275, 3858, 102, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[87380, 3862, 162, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.24"}],
    Cell[87567, 3870, 108, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[87678, 3874, 163, 5, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[87856, 3882, 150, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.25"}],
    Cell[88031, 3890, 86, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[88120, 3894, 4224, 299, 70, 4151, 296, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.8.3"],
    Cell[92347, 4195, 178, 5, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[92540, 4203, 259, 9, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.26"}],
    Cell[92824, 4216, 113, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[92940, 4220, 4481, 314, 70, 4408, 311, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.8.3"],
    Cell[97424, 4536, 178, 5, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[97617, 4544, 268, 6, 70, "Text",
      CellTags->{"S3.8.3", "3.27"}],
    Cell[97888, 4552, 4458, 130, 70, "DefinitionBox",
      CellTags->"S3.8.3"],
    Cell[102349, 4684, 88, 1, 70, "Caption",
      CellTags->"S3.8.3"],
    Cell[102440, 4687, 128, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.28"}],
    Cell[102593, 4695, 125, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[102721, 4699, 181, 5, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[102917, 4707, 99, 1, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.29"}],
    Cell[103041, 4712, 76, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[103120, 4716, 104, 3, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[103239, 4722, 88, 1, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.30"}],
    Cell[103330, 4725, 143, 5, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[103476, 4732, 187, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.31"}],
    Cell[103688, 4741, 113, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[103804, 4745, 183, 5, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[104002, 4753, 278, 6, 70, "Text",
      CellTags->{"S3.8.3", "3.32"}],
    Cell[104283, 4761, 118, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.33"}],
    Cell[104404, 4767, 138, 5, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[104545, 4774, 165, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.34"}],
    Cell[104735, 4783, 81, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[104819, 4787, 100, 3, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[104934, 4793, 209, 5, 70, "Text",
      CellTags->{"S3.8.3", "3.35"}],
    Cell[105146, 4800, 235, 9, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.36"}],
    Cell[105406, 4813, 114, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[105523, 4817, 163, 5, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[105701, 4825, 137, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.37"}],
    Cell[105863, 4833, 86, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[105952, 4837, 175, 4, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[106142, 4844, 229, 7, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.38"}],
    Cell[106396, 4855, 86, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[106485, 4859, 142, 4, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[106642, 4866, 452, 12, 70, "Text",
      CellTags->{"S3.8.3", "3.39"}],
    Cell[107097, 4880, 177, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.40"}],
    Cell[107299, 4889, 111, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[107413, 4893, 167, 5, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[107595, 4901, 153, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.41"}],
    Cell[107773, 4910, 104, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[107880, 4914, 163, 5, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[108058, 4922, 174, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.42"}],
    Cell[108257, 4931, 122, 2, 70, "Input",
      CellTags->"S3.8.3"],
    Cell[108382, 4935, 204, 6, 70, "Output",
      CellTags->"S3.8.3"],
    Cell[108601, 4944, 3862, 114, 70, "DefinitionBox",
      CellTags->"S3.8.3"],
    Cell[112466, 5060, 113, 4, 70, "Caption",
      CellTags->"S3.8.3"]},
  "3.1"->{
    Cell[68402, 3075, 98, 1, 70, "Subsection",
      CellTags->{"S3.8.3", "3.1"}]},
  "3.2"->{
    Cell[68503, 3078, 826, 18, 70, "Text",
      CellTags->{"S3.8.3", "3.2"}]},
  "3.3"->{
    Cell[69332, 3098, 560, 15, 70, "Text",
      CellTags->{"S3.8.3", "3.3"}]},
  "3.4"->{
    Cell[69895, 3115, 577, 11, 70, "Text",
      CellTags->{"S3.8.3", "3.4"}]},
  "3.5"->{
    Cell[73778, 3224, 106, 1, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.5"}]},
  "3.6"->{
    Cell[74385, 3243, 135, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.6"}]},
  "3.7"->{
    Cell[74815, 3263, 142, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.7"}]},
  "3.8"->{
    Cell[75174, 3281, 126, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.8"}]},
  "3.9"->{
    Cell[75516, 3299, 153, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.9"}]},
  "3.10"->{
    Cell[75885, 3317, 297, 7, 70, "Text",
      CellTags->{"S3.8.3", "3.10"}]},
  "3.11"->{
    Cell[76185, 3326, 162, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.11"}]},
  "3.12"->{
    Cell[76662, 3347, 115, 2, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.12"}]},
  "3.13"->{
    Cell[77018, 3363, 129, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.13"}]},
  "3.14"->{
    Cell[77388, 3381, 162, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.14"}]},
  "3.15"->{
    Cell[81574, 3659, 225, 6, 70, "Text",
      CellTags->{"S3.8.3", "3.15"}]},
  "3.16"->{
    Cell[81802, 3667, 233, 7, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.16"}]},
  "3.17"->{
    Cell[82254, 3688, 93, 1, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.17"}]},
  "3.18"->{
    Cell[82568, 3703, 551, 13, 70, "Text",
      CellTags->{"S3.8.3", "3.18"}]},
  "3.19"->{
    Cell[83122, 3718, 209, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.19"}]},
  "3.20"->{
    Cell[83609, 3739, 218, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.20"}]},
  "3.21"->{
    Cell[84273, 3764, 345, 7, 70, "Text",
      CellTags->{"S3.8.3", "3.21"}]},
  "3.22"->{
    Cell[86715, 3839, 446, 14, 70, "Text",
      CellTags->{"S3.8.3", "3.22"}]},
  "3.23"->{
    Cell[87164, 3855, 108, 1, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.23"}]},
  "3.24"->{
    Cell[87380, 3862, 162, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.24"}]},
  "3.25"->{
    Cell[87856, 3882, 150, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.25"}]},
  "3.26"->{
    Cell[92540, 4203, 259, 9, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.26"}]},
  "3.27"->{
    Cell[97617, 4544, 268, 6, 70, "Text",
      CellTags->{"S3.8.3", "3.27"}]},
  "3.28"->{
    Cell[102440, 4687, 128, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.28"}]},
  "3.29"->{
    Cell[102917, 4707, 99, 1, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.29"}]},
  "3.30"->{
    Cell[103239, 4722, 88, 1, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.30"}]},
  "3.31"->{
    Cell[103476, 4732, 187, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.31"}]},
  "3.32"->{
    Cell[104002, 4753, 278, 6, 70, "Text",
      CellTags->{"S3.8.3", "3.32"}]},
  "3.33"->{
    Cell[104283, 4761, 118, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.33"}]},
  "3.34"->{
    Cell[104545, 4774, 165, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.34"}]},
  "3.35"->{
    Cell[104934, 4793, 209, 5, 70, "Text",
      CellTags->{"S3.8.3", "3.35"}]},
  "3.36"->{
    Cell[105146, 4800, 235, 9, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.36"}]},
  "3.37"->{
    Cell[105701, 4825, 137, 4, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.37"}]},
  "3.38"->{
    Cell[106142, 4844, 229, 7, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.38"}]},
  "3.39"->{
    Cell[106642, 4866, 452, 12, 70, "Text",
      CellTags->{"S3.8.3", "3.39"}]},
  "3.40"->{
    Cell[107097, 4880, 177, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.40"}]},
  "3.41"->{
    Cell[107595, 4901, 153, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.41"}]},
  "3.42"->{
    Cell[108058, 4922, 174, 5, 70, "MathCaption",
      CellTags->{"S3.8.3", "3.42"}]},
  "S3.8.4"->{
    Cell[112616, 5069, 77, 1, 70, "Subsection",
      CellTags->{"S3.8.4", "4.1"}],
    Cell[112696, 5072, 298, 6, 70, "Text",
      CellTags->{"S3.8.4", "4.2"}],
    Cell[112997, 5080, 2299, 66, 70, "DefinitionBox",
      CellTags->"S3.8.4"],
    Cell[115299, 5148, 61, 1, 70, "Caption",
      CellTags->"S3.8.4"],
    Cell[115363, 5151, 107, 1, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.3"}],
    Cell[115495, 5156, 92, 2, 70, "Input",
      CellTags->"S3.8.4"],
    Cell[115590, 5160, 125, 3, 70, "Output",
      CellTags->"S3.8.4"],
    Cell[115730, 5166, 136, 4, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.4"}],
    Cell[115891, 5174, 74, 2, 70, "Input",
      CellTags->"S3.8.4"],
    Cell[115968, 5178, 606, 11, 70, "Output",
      CellTags->"S3.8.4"],
    Cell[116589, 5192, 93, 1, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.5"}],
    Cell[116707, 5197, 81, 2, 70, "Input",
      CellTags->"S3.8.4"],
    Cell[116791, 5201, 246, 5, 70, "Output",
      CellTags->"S3.8.4"],
    Cell[117052, 5209, 179, 5, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.6"}],
    Cell[117256, 5218, 83, 2, 70, "Input",
      CellTags->"S3.8.4"],
    Cell[117342, 5222, 339, 6, 70, "Output",
      CellTags->"S3.8.4"],
    Cell[117696, 5231, 159, 4, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.7"}],
    Cell[117858, 5237, 143, 5, 70, "Input",
      CellTags->"S3.8.4"],
    Cell[118004, 5244, 108, 1, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.8"}],
    Cell[118137, 5249, 100, 2, 70, "Input",
      CellTags->"S3.8.4"],
    Cell[118240, 5253, 6328, 432, 70, 6255, 429, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.8.4"],
    Cell[124571, 5687, 177, 5, 70, "Output",
      CellTags->"S3.8.4"],
    Cell[124763, 5695, 448, 12, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.9"}],
    Cell[125236, 5711, 142, 5, 70, "Input",
      CellTags->"S3.8.4"],
    Cell[125381, 5718, 6765, 456, 70, 6692, 453, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S3.8.4"],
    Cell[132149, 6176, 177, 5, 70, "Output",
      CellTags->"S3.8.4"],
    Cell[132341, 6184, 1768, 63, 70, "Text",
      CellTags->{"S3.8.4", "4.10"}],
    Cell[134112, 6249, 1652, 60, 70, "Text",
      CellTags->{"S3.8.4", "4.11"}],
    Cell[135767, 6311, 349, 8, 70, "Text",
      CellTags->{"S3.8.4", "4.12"}],
    Cell[136119, 6321, 13674, 349, 70, "DefinitionBox4Col",
      CellTags->"S3.8.4"],
    Cell[149796, 6672, 150, 5, 70, "Caption",
      CellTags->"S3.8.4"],
    Cell[149949, 6679, 1502, 43, 70, "DefinitionBox",
      CellTags->"S3.8.4"],
    Cell[151454, 6724, 92, 3, 70, "Caption",
      CellTags->"S3.8.4"],
    Cell[151549, 6729, 540, 15, 70, "Text",
      CellTags->{"S3.8.4", "4.13"}]},
  "4.1"->{
    Cell[112616, 5069, 77, 1, 70, "Subsection",
      CellTags->{"S3.8.4", "4.1"}]},
  "4.2"->{
    Cell[112696, 5072, 298, 6, 70, "Text",
      CellTags->{"S3.8.4", "4.2"}]},
  "4.3"->{
    Cell[115363, 5151, 107, 1, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.3"}]},
  "4.4"->{
    Cell[115730, 5166, 136, 4, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.4"}]},
  "4.5"->{
    Cell[116589, 5192, 93, 1, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.5"}]},
  "4.6"->{
    Cell[117052, 5209, 179, 5, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.6"}]},
  "4.7"->{
    Cell[117696, 5231, 159, 4, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.7"}]},
  "4.8"->{
    Cell[118004, 5244, 108, 1, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.8"}]},
  "4.9"->{
    Cell[124763, 5695, 448, 12, 70, "MathCaption",
      CellTags->{"S3.8.4", "4.9"}]},
  "4.10"->{
    Cell[132341, 6184, 1768, 63, 70, "Text",
      CellTags->{"S3.8.4", "4.10"}]},
  "4.11"->{
    Cell[134112, 6249, 1652, 60, 70, "Text",
      CellTags->{"S3.8.4", "4.11"}]},
  "4.12"->{
    Cell[135767, 6311, 349, 8, 70, "Text",
      CellTags->{"S3.8.4", "4.12"}]},
  "4.13"->{
    Cell[151549, 6729, 540, 15, 70, "Text",
      CellTags->{"S3.8.4", "4.13"}]},
  "S3.8.5"->{
    Cell[152126, 6749, 88, 1, 70, "Subsection",
      CellTags->{"S3.8.5", "5.1"}],
    Cell[152217, 6752, 346, 6, 70, "Text",
      CellTags->{"S3.8.5", "5.2"}],
    Cell[152566, 6760, 1802, 66, 70, "Text",
      CellTags->{"S3.8.5", "5.3"}],
    Cell[154371, 6828, 1149, 36, 70, "DefinitionBox",
      CellTags->"S3.8.5"],
    Cell[155523, 6866, 79, 1, 70, "Caption",
      CellTags->"S3.8.5"],
    Cell[155605, 6869, 195, 7, 70, "MathCaption",
      CellTags->{"S3.8.5", "5.4"}],
    Cell[155825, 6880, 96, 2, 70, "Input",
      CellTags->"S3.8.5"],
    Cell[155924, 6884, 133, 3, 70, "Output",
      CellTags->"S3.8.5"],
    Cell[156072, 6890, 82, 1, 70, "MathCaption",
      CellTags->{"S3.8.5", "5.5"}],
    Cell[156179, 6895, 97, 2, 70, "Input",
      CellTags->"S3.8.5"],
    Cell[156279, 6899, 133, 3, 70, "Output",
      CellTags->"S3.8.5"],
    Cell[156427, 6905, 179, 5, 70, "MathCaption",
      CellTags->{"S3.8.5", "5.6"}],
    Cell[156631, 6914, 98, 2, 70, "Input",
      CellTags->"S3.8.5"],
    Cell[156732, 6918, 133, 3, 70, "Output",
      CellTags->"S3.8.5"],
    Cell[156880, 6924, 101, 1, 70, "MathCaption",
      CellTags->{"S3.8.5", "5.7"}],
    Cell[157006, 6929, 98, 2, 70, "Input",
      CellTags->"S3.8.5"],
    Cell[157107, 6933, 129, 3, 70, "Output",
      CellTags->"S3.8.5"],
    Cell[157251, 6939, 491, 10, 70, "Text",
      CellTags->{"S3.8.5", "5.8"}],
    Cell[157745, 6951, 136, 4, 70, "MathCaption",
      CellTags->{"S3.8.5", "5.9"}],
    Cell[157906, 6959, 96, 2, 70, "Input",
      CellTags->"S3.8.5"],
    Cell[158005, 6963, 95, 3, 70, "Output",
      CellTags->"S3.8.5"],
    Cell[158115, 6969, 561, 10, 70, "Text",
      CellTags->{"S3.8.5", "5.10"}],
    Cell[158679, 6981, 3294, 100, 70, "DefinitionBox",
      CellTags->"S3.8.5"],
    Cell[161976, 7083, 99, 1, 70, "Caption",
      CellTags->"S3.8.5"],
    Cell[162078, 7086, 90, 1, 70, "MathCaption",
      CellTags->{"S3.8.5", "5.11"}],
    Cell[162193, 7091, 99, 2, 70, "Input",
      CellTags->"S3.8.5"],
    Cell[162295, 7095, 120, 3, 70, "Output",
      CellTags->"S3.8.5"],
    Cell[162430, 7101, 141, 4, 70, "MathCaption",
      CellTags->{"S3.8.5", "5.12"}],
    Cell[162596, 7109, 102, 2, 70, "Input",
      CellTags->"S3.8.5"],
    Cell[162701, 7113, 133, 3, 70, "Output",
      CellTags->"S3.8.5"],
    Cell[162849, 7119, 168, 4, 70, "MathCaption",
      CellTags->{"S3.8.5", "5.13"}],
    Cell[163042, 7127, 108, 2, 70, "Input",
      CellTags->"S3.8.5"],
    Cell[163153, 7131, 153, 4, 70, "Output",
      CellTags->"S3.8.5"],
    Cell[163321, 7138, 1718, 66, 70, "Text",
      CellTags->{"S3.8.5", "5.14"}],
    Cell[165042, 7206, 237, 7, 70, "MathCaption",
      CellTags->{"S3.8.5", "5.15"}],
    Cell[165304, 7217, 111, 2, 70, "Input",
      CellTags->"S3.8.5"],
    Cell[165418, 7221, 188, 4, 70, "Output",
      CellTags->"S3.8.5"],
    Cell[165621, 7228, 248, 5, 70, "Text",
      CellTags->{"S3.8.5", "5.16"}],
    Cell[165872, 7235, 3144, 95, 70, "DefinitionBox",
      CellTags->"S3.8.5"],
    Cell[169019, 7332, 85, 1, 70, "Caption",
      CellTags->"S3.8.5"],
    Cell[169107, 7335, 125, 5, 70, "MathCaption",
      CellTags->{"S3.8.5", "5.17"}],
    Cell[169257, 7344, 112, 2, 70, "Input",
      CellTags->"S3.8.5"],
    Cell[169372, 7348, 154, 4, 70, "Output",
      CellTags->"S3.8.5"],
    Cell[169541, 7355, 90, 1, 70, "MathCaption",
      CellTags->{"S3.8.5", "5.18"}],
    Cell[169656, 7360, 112, 2, 70, "Input",
      CellTags->"S3.8.5"],
    Cell[169771, 7364, 133, 3, 70, "Output",
      