(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   4295006,     130574]*)
(*NotebookOutlinePosition[   4363423,     132497]*)
(*  CellTagsIndexPosition[   4357206,     132278]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["3.9 ", "HeadingNumber"],
  "Numerical Operations on Functions"
}], "Section",
  CellTags->{"S3.9.0", "0.1"}],

Cell[CellGroupData[{

Cell[TextData[{
  "3.9.1 Numerical Mathematics in ",
  StyleBox["Mathematica", "SBO"]
}], "Subsection",
  CellTags->{"S3.9.1", "1.1"}],

Cell[TextData[{
  "One of the important features of ",
  StyleBox["Mathematica", "TI"],
  " is its ability to give you exact, symbolic, results for computations. \
There are, however, computations where it is just mathematically impossible \
to get exact \[OpenCurlyDoubleQuote]closed form\[CloseCurlyDoubleQuote] \
results. In such cases, you can still often get approximate numerical \
results. "
}], "Text",
  CellTags->{"S3.9.1", "1.2"}],

Cell[TextData[{
  "There is no \[OpenCurlyDoubleQuote]closed form\[CloseCurlyDoubleQuote] \
result for ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%1\), "sin", 
          RowBox[{"(", 
            RowBox[{"sin", 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}], ")"}], "\[DifferentialD]", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " returns the integral in symbolic form. "
}], "MathCaption",
  CellTags->{"S3.9.1", "1.3"}],

Cell[CellGroupData[{

Cell["Integrate[Sin[Sin[x]], {x, 0, 1}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.9.1"],

Cell[BoxData[
    \(\[Integral]\_0\%1 Sin[Sin[x]] \[DifferentialD]x\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.9.1"]
}, Open  ]],

Cell["\<\
You can now take the symbolic form of the integral, and ask for its \
approximate numerical value. \
\>", "MathCaption",
  CellTags->{"S3.9.1", "1.4"}],

Cell[CellGroupData[{

Cell["N[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.9.1"],

Cell[BoxData[
    \(0.4306061031206906`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.9.1"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " cannot find an explicit result for something like a definite integral, it \
returns a symbolic form. You can take this symbolic form, and try to get an \
approximate numerical value by applying ",
  StyleBox["N", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.9.1", "1.5"}],

Cell[TextData[{
  "By giving a second argument to ",
  StyleBox["N", "MR"],
  ", you can specify the numerical precision to use. "
}], "MathCaption",
  CellTags->{"S3.9.1", "1.6"}],

Cell[CellGroupData[{

Cell["N[ Integrate[Sin[Sin[x]], {x, 0, 1}], 40 ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.9.1"],

Cell[BoxData[
    \(0.430606103120690604912377355248465786433608041821997469505`40. \)], \
"Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.9.1"]
}, Open  ]],

Cell[TextData[{
  "If you want to evaluate an integral numerically in ",
  StyleBox["Mathematica", "TI"],
  ", then using ",
  StyleBox["Integrate", "MR"],
  " and applying ",
  StyleBox["N", "MR"],
  " to the result is not the most efficient way to do it. It is better \
instead to use the function ",
  StyleBox["NIntegrate", "MR"],
  ", which immediately gives a numerical answer, without first trying to get \
an exact, symbolic, result. You should realize that even when ",
  StyleBox["Integrate", "MR"],
  " does not in the end manage to give you an exact result, it may spend a \
lot of time trying to do so. "
}], "Text",
  CellTags->{"S3.9.1", "1.7"}],

Cell[TextData[{
  StyleBox["NIntegrate", "MR"],
  " evaluates numerical integrals directly, without first trying to get a \
symbolic result. "
}], "MathCaption",
  CellTags->{"S3.9.1", "1.8"}],

Cell[CellGroupData[{

Cell["NIntegrate[ Sin[Sin[x]], {x, 0, 1} ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.9.1"],

Cell[BoxData[
    \(0.4306061031206906`\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.9.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Integrate", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["NIntegrate", "MR"],
              " "
            }]], Cell["definite integrals "]},
          {Cell[TextData[{
              StyleBox["Sum", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["NSum", "MR"],
              " "
            }]], Cell["sums "]},
          {Cell[TextData[{
              StyleBox["Product", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["NProduct", "MR"],
              " "
            }]], Cell["products "]},
          {Cell[TextData[{
              StyleBox["Solve", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["NSolve", "MR"],
              " "
            }]], Cell["solutions of algebraic equations "]},
          {Cell[TextData[{
              StyleBox["DSolve", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["NDSolve", "MR"],
              " "
            }]], Cell["solutions of differential equations "]},
          {Cell[TextData[{
              StyleBox["Maximize", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["NMaximize", "MR"],
              " "
            }]], Cell["maximization "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.9.1"],

Cell[TextData[{
  "Symbolic and numerical versions of some ",
  StyleBox["Mathematica", "SO"],
  " functions."
}], "Caption",
  CellTags->"S3.9.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.9.2 The Uncertainties of Numerical Mathematics", "Subsection",
  CellTags->{"S3.9.2", "2.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " does operations like numerical integration very differently from the way \
it does their symbolic counterparts.   "
}], "Text",
  CellTags->{"S3.9.2", "2.2"}],

Cell[TextData[{
  "When you do a symbolic integral, ",
  StyleBox["Mathematica", "TI"],
  " takes the functional form of the integrand you have given, and applies a \
sequence of exact symbolic transformation rules to it, to try and evaluate \
the integral.  "
}], "Text",
  CellTags->{"S3.9.2", "2.3"}],

Cell[TextData[{
  "When you do a numerical integral, however, ",
  StyleBox["Mathematica", "TI"],
  " does not look directly at the functional form of the integrand you have \
given. Instead, it simply finds a sequence of numerical values of the \
integrand at particular points, then takes these values and tries to deduce \
from them a good approximation to the integral.  "
}], "Text",
  CellTags->{"S3.9.2", "2.4"}],

Cell[TextData[{
  "An important point to realize is that when ",
  StyleBox["Mathematica", "TI"],
  " does a numerical integral, the ",
  StyleBox["only", "TI"],
  " information it has about your integrand is a sequence of numerical values \
for it. To get a definite result for the integral, ",
  StyleBox["Mathematica", "TI"],
  " then effectively has to make certain assumptions about the smoothness and \
other properties of your integrand. If you give a sufficiently pathological \
integrand, these assumptions may not be valid, and as a result, ",
  StyleBox["Mathematica", "TI"],
  " may simply give you the wrong answer for the integral. "
}], "Text",
  CellTags->{"S3.9.2", "2.5"}],

Cell[TextData[{
  "This problem may occur, for example, if you try to integrate numerically a \
function which has a very thin spike at a particular position. ",
  StyleBox["Mathematica", "TI"],
  " samples your function at a number of points, and then assumes that the \
function varies smoothly between these points. As a result, if none of the \
sample points come close to the spike, then the spike will go undetected, and \
its contribution to the numerical integral will not be correctly included. "
}], "Text",
  CellTags->{"S3.9.2", "2.6"}],

Cell[TextData[{
  "Here is a plot of the function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"exp", 
          RowBox[{"(", 
            RowBox[{"-", 
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "2"]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.2", "2.7"}],

Cell[CellGroupData[{

Cell["Plot[Exp[-x^2], {x, -10, 10}, PlotRange->All]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.9.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0476191 0.0147151 0.588605 [
[.02381 .00222 -9 -9 ]
[.02381 .00222 9 0 ]
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.7381 .00222 -3 -9 ]
[.7381 .00222 3 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.4875 .13244 -18 -4.5 ]
[.4875 .13244 0 4.5 ]
[.4875 .25016 -18 -4.5 ]
[.4875 .25016 0 4.5 ]
[.4875 .36788 -18 -4.5 ]
[.4875 .36788 0 4.5 ]
[.4875 .4856 -18 -4.5 ]
[.4875 .4856 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-10)] .02381 .00222 0 1 Mshowa
.2619 .01472 m
.2619 .02097 L
s
[(-5)] .2619 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(5)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(10)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .13244 m
.50625 .13244 L
s
[(0.2)] .4875 .13244 1 0 Mshowa
.5 .25016 m
.50625 .25016 L
s
[(0.4)] .4875 .25016 1 0 Mshowa
.5 .36788 m
.50625 .36788 L
s
[(0.6)] .4875 .36788 1 0 Mshowa
.5 .4856 m
.50625 .4856 L
s
[(0.8)] .4875 .4856 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .16187 m
.50375 .16187 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .45617 m
.50375 .45617 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
.5 Mabswid
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01472 L
.02954 .01472 L
.03053 .01472 L
.03163 .01472 L
.03279 .01472 L
.03395 .01472 L
.0352 .01472 L
.03638 .01472 L
.03746 .01472 L
.03873 .01472 L
.03944 .01472 L
.04011 .01472 L
.04132 .01472 L
.04262 .01472 L
.04327 .01472 L
.04396 .01472 L
.04519 .01472 L
.04588 .01472 L
.04652 .01472 L
.04722 .01472 L
.04797 .01472 L
.04862 .01472 L
.04933 .01472 L
.05061 .01472 L
.05186 .01472 L
.05302 .01472 L
.05414 .01472 L
.05519 .01472 L
.05634 .01472 L
.05759 .01472 L
.05882 .01472 L
.06012 .01472 L
.06123 .01472 L
.06244 .01472 L
.06315 .01472 L
.06381 .01472 L
.06453 .01472 L
.06529 .01472 L
.06657 .01472 L
.06729 .01472 L
.06797 .01472 L
.06924 .01472 L
.0704 .01472 L
.07103 .01472 L
.07173 .01472 L
.073 .01472 L
Mistroke
.07376 .01472 L
.07448 .01472 L
.07513 .01472 L
.07583 .01472 L
.0766 .01472 L
.0774 .01472 L
.07809 .01472 L
.07885 .01472 L
.07956 .01472 L
.0802 .01472 L
.08095 .01472 L
.08166 .01472 L
.08291 .01472 L
.08362 .01472 L
.08427 .01472 L
.08544 .01472 L
.08669 .01472 L
.08787 .01472 L
.08896 .01472 L
.09016 .01472 L
.09148 .01472 L
.09214 .01472 L
.09285 .01472 L
.09413 .01472 L
.09483 .01472 L
.09548 .01472 L
.09619 .01472 L
.09695 .01472 L
.09821 .01472 L
.09893 .01472 L
.09961 .01472 L
.10086 .01472 L
.10201 .01472 L
.10333 .01472 L
.10458 .01472 L
.10572 .01472 L
.10694 .01472 L
.1081 .01472 L
.10916 .01472 L
.11033 .01472 L
.11162 .01472 L
.11227 .01472 L
.11297 .01472 L
.11422 .01472 L
.11491 .01472 L
.11554 .01472 L
.11624 .01472 L
.11698 .01472 L
.11822 .01472 L
.11892 .01472 L
Mistroke
.11958 .01472 L
.12081 .01472 L
.12194 .01472 L
.12323 .01472 L
.12446 .01472 L
.12562 .01472 L
.12668 .01472 L
.12789 .01472 L
.12903 .01472 L
.13009 .01472 L
.13107 .01472 L
.13214 .01472 L
.13327 .01472 L
.13441 .01472 L
.13564 .01472 L
.1368 .01472 L
.13785 .01472 L
.13909 .01472 L
.13979 .01472 L
.14043 .01472 L
.14162 .01472 L
.14288 .01472 L
.14402 .01472 L
.14526 .01472 L
.14656 .01472 L
.14777 .01472 L
.14891 .01472 L
.14994 .01472 L
.15113 .01472 L
.15226 .01472 L
.15348 .01472 L
.15478 .01472 L
.15589 .01472 L
.15711 .01472 L
.15842 .01472 L
.15915 .01472 L
.15982 .01472 L
.16113 .01472 L
.16236 .01472 L
.16352 .01472 L
.16456 .01472 L
.16577 .01472 L
.1669 .01472 L
.16796 .01472 L
.16893 .01472 L
.16999 .01472 L
.17111 .01472 L
.17225 .01472 L
.17347 .01472 L
.17462 .01472 L
Mistroke
.17566 .01472 L
.17689 .01472 L
.17758 .01472 L
.17823 .01472 L
.1794 .01472 L
.18065 .01472 L
.18185 .01472 L
.18316 .01472 L
.18441 .01472 L
.18556 .01472 L
.1867 .01472 L
.18773 .01472 L
.18893 .01472 L
.19005 .01472 L
.19128 .01472 L
.19258 .01472 L
.19369 .01472 L
.19491 .01472 L
.19623 .01472 L
.19696 .01472 L
.19763 .01472 L
.19894 .01472 L
.20017 .01472 L
.20122 .01472 L
.20238 .01472 L
.20359 .01472 L
.20472 .01472 L
.20578 .01472 L
.20675 .01472 L
.20781 .01472 L
.20894 .01472 L
.21008 .01472 L
.21129 .01472 L
.21244 .01472 L
.21349 .01472 L
.21472 .01472 L
.21605 .01472 L
.21731 .01472 L
.21847 .01472 L
.21972 .01472 L
.22091 .01472 L
.22198 .01472 L
.22314 .01472 L
.2244 .01472 L
.22574 .01472 L
.22701 .01472 L
.22816 .01472 L
.22933 .01472 L
.2304 .01472 L
.23158 .01472 L
Mistroke
.23283 .01472 L
.23391 .01472 L
.23493 .01472 L
.23604 .01472 L
.23722 .01472 L
.23861 .01472 L
.23988 .01472 L
.24129 .01472 L
.24277 .01472 L
.24406 .01472 L
.24527 .01472 L
.2466 .01472 L
.24802 .01472 L
.24922 .01472 L
.25053 .01472 L
.25189 .01472 L
.25316 .01472 L
.25435 .01472 L
.25543 .01472 L
.25668 .01472 L
.25786 .01472 L
.25902 .01472 L
.26026 .01472 L
.26143 .01472 L
.2625 .01472 L
.26376 .01472 L
.26512 .01472 L
.26641 .01472 L
.2676 .01472 L
.26882 .01472 L
.26997 .01472 L
.27123 .01472 L
.2726 .01472 L
.27394 .01472 L
.27536 .01472 L
.27658 .01472 L
.27791 .01472 L
.27915 .01472 L
.28032 .01472 L
.28252 .01472 L
.28376 .01472 L
.28489 .01472 L
.28622 .01472 L
.28746 .01472 L
.28952 .01472 L
.29061 .01472 L
.29179 .01472 L
.29301 .01472 L
.29418 .01472 L
.29637 .01472 L
Mistroke
.29761 .01472 L
.29896 .01472 L
.30014 .01472 L
.3014 .01472 L
.30253 .01472 L
.30377 .01472 L
.30596 .01472 L
.30729 .01472 L
.30851 .01472 L
.30982 .01472 L
.31124 .01472 L
.31256 .01472 L
.31378 .01472 L
.31493 .01472 L
.31618 .01472 L
.31837 .01472 L
.32042 .01472 L
.32161 .01472 L
.32286 .01472 L
.3251 .01472 L
.32744 .01472 L
.32962 .01472 L
.33201 .01472 L
.33335 .01472 L
.33457 .01472 L
.33688 .01472 L
.33942 .01472 L
.3407 .01472 L
.34207 .01472 L
.34455 .01473 L
.34702 .01473 L
.34936 .01474 L
.35147 .01475 L
.35376 .01476 L
.3565 .01478 L
.35899 .01481 L
.36185 .01485 L
.36455 .0149 L
.36706 .01496 L
.36936 .01503 L
.37189 .01514 L
.37456 .01529 L
.37711 .01547 L
.37953 .01569 L
.38406 .01628 L
.3866 .01674 L
.38894 .01727 L
.39168 .01805 L
.39424 .01896 L
.39848 .02096 L
Mistroke
.40072 .02234 L
.40314 .02412 L
.40807 .02889 L
.41259 .03497 L
.41735 .04365 L
.42242 .05613 L
.42721 .07161 L
.43156 .0893 L
.44222 .14974 L
.45227 .23027 L
.47063 .41711 L
.47566 .46802 L
.48106 .51719 L
.48572 .55272 L
.48818 .56817 L
.4908 .58175 L
.49212 .58741 L
.49358 .5927 L
.49492 .59665 L
.49615 .59948 L
.4974 .60157 L
.49806 .60235 L
.49876 .60292 L
.49993 .60332 L
.50122 .60294 L
.50246 .60175 L
.50359 .59998 L
.5049 .59711 L
.50614 .59362 L
.50834 .58556 L
.51072 .57424 L
.51604 .5402 L
.52167 .4932 L
.53178 .39178 L
.54192 .28589 L
.55156 .19699 L
.56021 .13373 L
.56964 .08405 L
.57452 .06556 L
.57972 .05041 L
.58462 .03973 L
.58907 .03251 L
.59424 .02643 L
.59715 .02388 L
.59983 .02198 L
.60475 .01937 L
.60723 .01841 L
.60996 .01756 L
.61247 .01694 L
.6152 .01641 L
Mistroke
.61779 .01601 L
.62017 .01572 L
.62469 .01533 L
.62697 .0152 L
.62949 .01508 L
.6322 .01498 L
.63468 .01491 L
.63741 .01486 L
.64028 .01482 L
.64279 .01479 L
.64512 .01477 L
.64768 .01475 L
.65041 .01474 L
.653 .01473 L
.65575 .01473 L
.65809 .01472 L
.66066 .01472 L
.66211 .01472 L
.66343 .01472 L
.66486 .01472 L
.66641 .01472 L
.66784 .01472 L
.66916 .01472 L
.67177 .01472 L
.67305 .01472 L
.67442 .01472 L
.67563 .01472 L
.6769 .01472 L
.67806 .01472 L
.67932 .01472 L
.68154 .01472 L
.6829 .01472 L
.68414 .01472 L
.68547 .01472 L
.68692 .01472 L
.68826 .01472 L
.6895 .01472 L
.69075 .01472 L
.69193 .01472 L
.6931 .01472 L
.69436 .01472 L
.69659 .01472 L
.69785 .01472 L
.69919 .01472 L
.7016 .01472 L
.70277 .01472 L
.70404 .01472 L
.70516 .01472 L
.70635 .01472 L
.70742 .01472 L
Mistroke
.70859 .01472 L
.71065 .01472 L
.71204 .01472 L
.71335 .01472 L
.71454 .01472 L
.7158 .01472 L
.71717 .01472 L
.71844 .01472 L
.71981 .01472 L
.72132 .01472 L
.72261 .01472 L
.72379 .01472 L
.72509 .01472 L
.72646 .01472 L
.72765 .01472 L
.72876 .01472 L
.72996 .01472 L
.73128 .01472 L
.73255 .01472 L
.7339 .01472 L
.73516 .01472 L
.73633 .01472 L
.7377 .01472 L
.73896 .01472 L
.74042 .01472 L
.7418 .01472 L
.74299 .01472 L
.74426 .01472 L
.74546 .01472 L
.74655 .01472 L
.74783 .01472 L
.74922 .01472 L
.75053 .01472 L
.75173 .01472 L
.75281 .01472 L
.75396 .01472 L
.75496 .01472 L
.75605 .01472 L
.75732 .01472 L
.75852 .01472 L
.75969 .01472 L
.76078 .01472 L
.76191 .01472 L
.76298 .01472 L
.76415 .01472 L
.76541 .01472 L
.76666 .01472 L
.76797 .01472 L
.76909 .01472 L
.77032 .01472 L
Mistroke
.77164 .01472 L
.77286 .01472 L
.7742 .01472 L
.77562 .01472 L
.77685 .01472 L
.778 .01472 L
.77926 .01472 L
.78062 .01472 L
.78182 .01472 L
.78313 .01472 L
.78436 .01472 L
.78551 .01472 L
.78653 .01472 L
.78767 .01472 L
.78885 .01472 L
.78996 .01472 L
.79119 .01472 L
.79252 .01472 L
.79392 .01472 L
.79522 .01472 L
.79644 .01472 L
.79755 .01472 L
.79884 .01472 L
.80005 .01472 L
.80137 .01472 L
.80203 .01472 L
.80276 .01472 L
.80405 .01472 L
.80527 .01472 L
.806 .01472 L
.80669 .01472 L
.80799 .01472 L
.80872 .01472 L
.8094 .01472 L
.81013 .01472 L
.81093 .01472 L
.81221 .01472 L
.81292 .01472 L
.81357 .01472 L
.81475 .01472 L
.81601 .01472 L
.81672 .01472 L
.81749 .01472 L
.81816 .01472 L
.81888 .01472 L
.81953 .01472 L
.82024 .01472 L
.8215 .01472 L
.82279 .01472 L
.82398 .01472 L
Mistroke
.82527 .01472 L
.82593 .01472 L
.82664 .01472 L
.82785 .01472 L
.82914 .01472 L
.83036 .01472 L
.83146 .01472 L
.83262 .01472 L
.83385 .01472 L
.8349 .01472 L
.83606 .01472 L
.8373 .01472 L
.83799 .01472 L
.83863 .01472 L
.83986 .01472 L
.84104 .01472 L
.84212 .01472 L
.84328 .01472 L
.84437 .01472 L
.84536 .01472 L
.84653 .01472 L
.84779 .01472 L
.84898 .01472 L
.85007 .01472 L
.85134 .01472 L
.85254 .01472 L
.85362 .01472 L
.85479 .01472 L
.85607 .01472 L
.85671 .01472 L
.85742 .01472 L
.85867 .01472 L
.85984 .01472 L
.86102 .01472 L
.86213 .01472 L
.86313 .01472 L
.86423 .01472 L
.86541 .01472 L
.86667 .01472 L
.86787 .01472 L
.86895 .01472 L
.87024 .01472 L
.87089 .01472 L
.87161 .01472 L
.87288 .01472 L
.87406 .01472 L
.87478 .01472 L
.87546 .01472 L
.87673 .01472 L
.87744 .01472 L
Mistroke
.8781 .01472 L
.87882 .01472 L
.87959 .01472 L
.88079 .01472 L
.8819 .01472 L
.88255 .01472 L
.88324 .01472 L
.88446 .01472 L
.88574 .01472 L
.88693 .01472 L
.88823 .01472 L
.88896 .01472 L
.88963 .01472 L
.89082 .01472 L
.89193 .01472 L
.89316 .01472 L
.89447 .01472 L
.89513 .01472 L
.89585 .01472 L
.89715 .01472 L
.89842 .01472 L
.8996 .01472 L
.9008 .01472 L
.90194 .01472 L
.90296 .01472 L
.90406 .01472 L
.90526 .01472 L
.90653 .01472 L
.90761 .01472 L
.9088 .01472 L
.90947 .01472 L
.9102 .01472 L
.91152 .01472 L
.9128 .01472 L
.91399 .01472 L
.91528 .01472 L
.91601 .01472 L
.91669 .01472 L
.91741 .01472 L
.91807 .01472 L
.9188 .01472 L
.91956 .01472 L
.92076 .01472 L
.92204 .01472 L
.92325 .01472 L
.92435 .01472 L
.92565 .01472 L
.92638 .01472 L
.92705 .01472 L
.92829 .01472 L
Mistroke
.92959 .01472 L
.93081 .01472 L
.93213 .01472 L
.93338 .01472 L
.93453 .01472 L
.93557 .01472 L
.93672 .01472 L
.93792 .01472 L
.93905 .01472 L
.94028 .01472 L
.94159 .01472 L
.94271 .01472 L
.94393 .01472 L
.94524 .01472 L
.94598 .01472 L
.94665 .01472 L
.94796 .01472 L
.94919 .01472 L
.95025 .01472 L
.95141 .01472 L
.95262 .01472 L
.95376 .01472 L
.95482 .01472 L
.95579 .01472 L
.95691 .01472 L
.95798 .01472 L
.95912 .01472 L
.96034 .01472 L
.96149 .01472 L
.96254 .01472 L
.96377 .01472 L
.96446 .01472 L
.9651 .01472 L
.96627 .01472 L
.96751 .01472 L
.96865 .01472 L
.96968 .01472 L
.97087 .01472 L
.972 .01472 L
.97304 .01472 L
.97401 .01472 L
.97507 .01472 L
.97619 .01472 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.9.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NIntegrate", "MR"],
  " gives the correct answer for the numerical integral of this function from \
",
  Cell[BoxData[
      \(TraditionalForm\`\(-10\)\)], "InlineFormula"],
  " to +10. "
}], "MathCaption",
  CellTags->{"S3.9.2", "2.8"}],

Cell[CellGroupData[{

Cell["NIntegrate[Exp[-x^2], {x, -10, 10}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.9.2"],

Cell[BoxData[
    \(1.7724538509055054`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.9.2"]
}, Open  ]],

Cell[TextData[{
  "If, however, you ask for the integral from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-10000\)\)], "InlineFormula"],
  " to 10000, ",
  StyleBox["NIntegrate", "MR"],
  " will miss the peak near ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", and give the wrong answer. "
}], "MathCaption",
  CellTags->{"S3.9.2", "2.9"}],

Cell[CellGroupData[{

Cell["NIntegrate[Exp[-x^2], {x, -10000, 10000}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.9.2"],

Cell[BoxData[
    \(NIntegrate::"ploss" \(\(:\)\(\ \)\) 
      "Numerical integration stopping due to loss of precision. Achieved \
neither the requested PrecisionGoal nor AccuracyGoal; suspect one of the \
following: highly oscillatory integrand or the true value of the integral is \
0. If your integrand is oscillatory on a (semi-)infinite interval try using \
the option Method->Oscillatory in NIntegrate."\)], "Message",
  CellTags->"S3.9.2"],

Cell[BoxData[
    \(0.`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.9.2"]
}, Open  ]],

Cell[TextData[{
  "Although ",
  StyleBox["NIntegrate", "MR"],
  " follows the principle of looking only at the numerical values of your \
integrand, it nevertheless tries to make the best possible use of the \
information that it can get. Thus, for example, if ",
  StyleBox["NIntegrate", "MR"],
  " notices that the estimated error in the integral in a particular region \
is large, it will take more samples in that region. In this way, ",
  StyleBox["NIntegrate", "MR"],
  " tries to \[OpenCurlyDoubleQuote]adapt\[CloseCurlyDoubleQuote] its \
operation to the particular integrand you have given.  "
}], "Text",
  CellTags->{"S3.9.2", "2.10"}],

Cell[TextData[{
  "The kind of adaptive procedure that ",
  StyleBox["NIntegrate", "MR"],
  " uses is similar, at least in spirit, to what ",
  StyleBox["Plot", "MR"],
  " does in trying to draw smooth curves for functions. In both cases, ",
  StyleBox["Mathematica", "TI"],
  " tries to go on taking more samples in a particular region until it has \
effectively found a smooth approximation to the function in that region. "
}], "Text",
  CellTags->{"S3.9.2", "2.11"}],

Cell["\<\
The kinds of problems that can appear in numerical integration can \
also arise in doing other numerical operations on functions. \
\>", "Text",
  CellTags->{"S3.9.2", "2.12"}],

Cell[TextData[{
  "For example, if you ask for a numerical approximation to the sum of an \
infinite series, ",
  StyleBox["Mathematica", "TI"],
  " samples a certain number of terms in the series, and then does an \
extrapolation to estimate the contributions of other terms. If you insert \
large terms far out in the series, they may not be detected when the \
extrapolation is done, and the result you get for the sum may be incorrect. "
}], "Text",
  CellTags->{"S3.9.2", "2.13"}],

Cell[TextData[{
  "A similar problem arises when you try to find a numerical approximation to \
the minimum of a function. ",
  StyleBox["Mathematica", "TI"],
  " samples only a finite number of values, then effectively assumes that the \
actual function interpolates smoothly between these values. If in fact the \
function has a sharp dip in a particular region, then ",
  StyleBox["Mathematica", "TI"],
  " may miss this dip, and you may get the wrong answer for the minimum. "
}], "Text",
  CellTags->{"S3.9.2", "2.14"}],

Cell["\<\
If you work only with numerical values of functions, there is \
simply no way to avoid the kinds of problems we have been discussing. Exact \
symbolic computation, of course, allows you to get around these problems. \
\
\>", "Text",
  CellTags->{"S3.9.2", "2.15"}],

Cell["\<\
In many calculations, it is therefore worthwhile to go as far as \
you can symbolically, and then resort to numerical methods only at the very \
end. This gives you the best chance of avoiding the problems that can arise \
in purely numerical computations. \
\>", "Text",
  CellTags->{"S3.9.2", "2.16"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.9.3 Numerical Integration", "Subsection",
  CellTags->{"S3.9.3", "3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["N[Integrate[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]]", "MR"],
              " "
            }]], 
            Cell["\<\
try to perform an integral exactly, then find numerical \
approximations to the parts that remain\
\>"]},
          {Cell[TextData[{
              StyleBox["NIntegrate[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["find a numerical approximation to an integral"]},
          {Cell[TextData[{
              StyleBox["NIntegrate[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "multidimensional numerical integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox["\[Integral]", 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["max",
                            "TI"]]], 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["x",
                        "TI"], " ", 
                      SubsuperscriptBox["\[Integral]", 
                        SubscriptBox[
                          StyleBox["y",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], 
                        SubscriptBox[
                          StyleBox["y",
                            "TI"], 
                          StyleBox["max",
                            "TI"]]], 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["y",
                        "TI"], " ", \(\(...\)\(\ \)\), 
                      StyleBox["expr",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NIntegrate[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "do a numerical integral along a line, starting at ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", going through the points ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", and ending at ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.9.3"],

Cell["Numerical integration functions. ", "Caption",
  CellTags->"S3.9.3"],

Cell[TextData[{
  "This finds a numerical approximation to the integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%\[Infinity]\), 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "3"]}]], "\[DifferentialD]", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.3", "3.2"}],

Cell[CellGroupData[{

Cell["NIntegrate[Exp[-x^3], {x, 0, Infinity}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(0.8929795115694814`\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell[TextData[{
  "Here is the numerical value of the double integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\(-1\)\%1\), 
          StyleBox["d",
            "TI"], 
          StyleBox["x",
            "TI"], " ", \(\[Integral]\_\(-1\)\%1\), 
          StyleBox["d",
            "TI"], 
          StyleBox["y",
            "TI"], " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "2"], "+", 
              SuperscriptBox[
                StyleBox["y",
                  "TI"], "2"]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.3", "3.3"}],

Cell[CellGroupData[{

Cell["NIntegrate[x^2 + y^2, {x, -1, 1}, {y, -1, 1}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(2.6666666666666665`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell[TextData[{
  "An important feature of ",
  StyleBox["NIntegrate", "MR"],
  " is its ability to deal with functions that \[OpenCurlyDoubleQuote]blow up\
\[CloseCurlyDoubleQuote] at known points. ",
  StyleBox["NIntegrate", "MR"],
  " automatically checks for such problems at the end points of the \
integration region. "
}], "Text",
  CellTags->{"S3.9.3", "3.4"}],

Cell[TextData[{
  "The function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          SqrtBox[
            StyleBox["x",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  " blows up at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", but ",
  StyleBox["NIntegrate", "MR"],
  " still succeeds in getting the correct value for the integral. "
}], "MathCaption",
  CellTags->{"S3.9.3", "3.5"}],

Cell[CellGroupData[{

Cell["NIntegrate[1/Sqrt[x], {x, 0, 1}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(2.0000000000161635`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can find the integral of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          SqrtBox[
            StyleBox["x",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  " exactly. "
}], "MathCaption",
  CellTags->{"S3.9.3", "3.6"}],

Cell[CellGroupData[{

Cell["Integrate[1/Sqrt[x], {x, 0, 1}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NIntegrate", "MR"],
  " detects that the singularity in ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  " is not integrable. "
}], "MathCaption",
  CellTags->{"S3.9.3", "3.7"}],

Cell[CellGroupData[{

Cell["NIntegrate[1/x, {x, 0, 1}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(NIntegrate::"slwcon" \(\(:\)\(\ \)\) 
      "Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration being 0, oscillatory \
integrand, or insufficient WorkingPrecision. If your integrand is oscillatory \
try using the option Method->Oscillatory in NIntegrate."\)], "Message",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(NIntegrate::"ncvb" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(7\) \
recursive bisections in \!\(x\) near \!\(x\) = \
\!\(4.369993747903698`*^-57\)."\)], "Message",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(23953.08729244626`\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NIntegrate", "MR"],
  " does not automatically look for singularities except at the end points of \
your integration region. When other singularities are present, ",
  StyleBox["NIntegrate", "MR"],
  " may not give you the right answer for the integral. Nevertheless, in \
following its adaptive procedure, ",
  StyleBox["NIntegrate", "MR"],
  " will often detect the presence of potentially singular behavior, and will \
warn you about it. "
}], "Text",
  CellTags->{"S3.9.3", "3.8"}],

Cell[TextData[{
  StyleBox["NIntegrate", "MR"],
  " does not handle the singularity in the middle of the integration region. \
However, it warns you of a possible problem. In this case, the final result \
is numerically quite close to the correct answer. "
}], "MathCaption",
  CellTags->{"S3.9.3", "3.9"}],

Cell[CellGroupData[{

Cell["NIntegrate[x^2 Sin[1/x], {x, -1, 2}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(NIntegrate::"ncvb" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(7\) \
recursive bisections in \!\(x\) near \!\(x\) = \!\(-0.02734375`\)."\)], \
"Message",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(1.3875589873568963`\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell[TextData[{
  "If you know that your integrand has singularities at particular points, \
you can explicitly tell ",
  StyleBox["NIntegrate", "MR"],
  " to deal with them. ",
  StyleBox["NIntegrate[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  " integrates ",
  StyleBox["expr", "TI"],
  " from ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", looking for possible singularities at each of the intermediate points ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ".   "
}], "Text",
  CellTags->{"S3.9.3", "3.10"}],

Cell[TextData[{
  "This gives the same integral, but now explicitly deals with the \
singularity at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.3", "3.11"}],

Cell[CellGroupData[{

Cell["NIntegrate[x^2 Sin[1/x], {x, -1, 0, 2}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(1.3875544426506408`\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell[TextData[{
  "You can also use the list of intermediate points ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " in ",
  StyleBox["NIntegrate", "MR"],
  " to specify an integration contour to follow in the complex plane. The \
contour is taken to consist of a sequence of line segments, starting at ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", going through each of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", and ending at ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.9.3", "3.12"}],

Cell[TextData[{
  "This integrates ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " around a closed contour in the complex plane, going from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  ", through the points ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ", 1 and ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", then back to ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.3", "3.13"}],

Cell[CellGroupData[{

Cell["NIntegrate[1/x, {x, -1, -I, 1, I, -1}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(1.1102230246251565`*^-16 + 6.28318530717957`\ \[ImaginaryI]\)], "Output",\

  CellLabel->"Out[8]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell[TextData[{
  "The integral gives ",
  Cell[BoxData[
      FormBox[
        RowBox[{"2", "\[Pi]", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ", as expected from Cauchy's Theorem.  "
}], "MathCaption",
  CellTags->{"S3.9.3", "3.14"}],

Cell[CellGroupData[{

Cell["N[ 2 Pi I ]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(\(\(0.`\)\(\[InvisibleSpace]\)\) + 
      6.283185307179586`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["MinRecursion", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["0", "MR"],
              " "
            }]], 
            Cell["\<\
minimum number of recursive subdivisions of the \
integration region \
\>"]},
          {Cell[TextData[{
              StyleBox["MaxRecursion", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["6", "MR"],
              " "
            }]], 
            Cell["\<\
maximum number of recursive subdivisions of the \
integration region \
\>"]},
          {Cell[TextData[{
              StyleBox["SingularityDepth", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["4", "MR"],
              " "
            }]], 
            Cell["\<\
number of recursive subdivisions to use before doing a \
change of variables at the end points \
\>"]},
          {Cell[TextData[{
              StyleBox["MaxPoints", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[
            "maximum total number of times to sample the integrand "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S3.9.3"],

Cell[TextData[{
  "Special options for ",
  StyleBox["NIntegrate", "MR"],
  ". "
}], "Caption",
  CellTags->"S3.9.3"],

Cell[TextData[{
  "When ",
  StyleBox["NIntegrate", "MR"],
  " tries to evaluate a numerical integral, it samples the integrand at a \
sequence of points. If it finds that the integrand changes rapidly in a \
particular region, then it recursively takes more sample points in that \
region. The parameters ",
  StyleBox["MinRecursion", "MR"],
  " and ",
  StyleBox["MaxRecursion", "MR"],
  " specify the minimum and maximum number of levels of recursive subdivision \
to use. Increasing the value of ",
  StyleBox["MinRecursion", "MR"],
  " guarantees that ",
  StyleBox["NIntegrate", "MR"],
  " will use a larger number of sample points. ",
  StyleBox["MaxRecursion", "MR"],
  " limits the number of sample points which ",
  StyleBox["NIntegrate", "MR"],
  " will ever try to use. Increasing ",
  StyleBox["MinRecursion", "MR"],
  " or ",
  StyleBox["MaxRecursion", "MR"],
  " will make ",
  StyleBox["NIntegrate", "MR"],
  " work more slowly. ",
  StyleBox["SingularityDepth", "MR"],
  " specifies how many levels of recursive subdivision ",
  StyleBox["NIntegrate", "MR"],
  " should try before it concludes that the integrand is \
\[OpenCurlyDoubleQuote]blowing up\[CloseCurlyDoubleQuote] at one of the \
endpoints, and does a change of variables. "
}], "Text",
  CellTags->{"S3.9.3", "3.15"}],

Cell[TextData[{
  "With the default settings for all options, ",
  StyleBox["NIntegrate", "MR"],
  " misses the peak in ",
  Cell[BoxData[
      FormBox[
        RowBox[{"exp", 
          RowBox[{"(", 
            RowBox[{"-", 
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["x",
                      "TI"], "-", "1"}], ")"}], "2"]}], ")"}]}], 
        TraditionalForm]], "InlineFormula"],
  " near ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  ", and gives the wrong answer for the integral. "
}], "MathCaption",
  CellTags->{"S3.9.3", "3.16"}],

Cell[CellGroupData[{

Cell["NIntegrate[Exp[-(x-1)^2], {x, -1000, 1000}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(NIntegrate::"ploss" \(\(:\)\(\ \)\) 
      "Numerical integration stopping due to loss of precision. Achieved \
neither the requested PrecisionGoal nor AccuracyGoal; suspect one of the \
following: highly oscillatory integrand or the true value of the integral is \
0. If your integrand is oscillatory on a (semi-)infinite interval try using \
the option Method->Oscillatory in NIntegrate."\)], "Message",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(2.0252360235522967`*^-20\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell[TextData[{
  "With the option ",
  StyleBox["MinRecursion->3", "MR"],
  ", ",
  StyleBox["NIntegrate", "MR"],
  " samples enough points that it notices the peak around ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  ". With the default setting of ",
  StyleBox["MaxRecursion", "MR"],
  ", however, ",
  StyleBox["NIntegrate", "MR"],
  " cannot use enough sample points to be able to expect an accurate answer. \
"
}], "MathCaption",
  CellTags->{"S3.9.3", "3.17"}],

Cell[CellGroupData[{

Cell["NIntegrate[Exp[-(x-1)^2], {x, -1000, 1000}, MinRecursion->3]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(NIntegrate::"ncvb" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(7\) \
recursive bisections in \!\(x\) near \!\(x\) = \!\(7.8125`\)."\)], "Message",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(1.6209997666231974`\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell[TextData[{
  "With this setting of ",
  StyleBox["MaxRecursion", "MR"],
  ", ",
  StyleBox["NIntegrate", "MR"],
  " can get an accurate answer for the integral. "
}], "MathCaption",
  CellTags->{"S3.9.3", "3.18"}],

Cell[CellGroupData[{

Cell["\<\
NIntegrate[Exp[-(x-1)^2], {x, -1000, 1000}, MinRecursion->3, \
MaxRecursion->10]\
\>", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(1.77245385090549`\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell[TextData[{
  "Another way to solve the problem is to make ",
  StyleBox["NIntegrate", "MR"],
  " break the integration region into several pieces, with a small piece that \
explicitly covers the neighborhood of the peak. "
}], "MathCaption",
  CellTags->{"S3.9.3", "3.19"}],

Cell[CellGroupData[{

Cell["NIntegrate[Exp[-(x-1)^2], {x, -1000, -10, 10, 1000}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(1.772453850909346`\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell[TextData[{
  "For integrals in many dimensions, it can take a long time for ",
  StyleBox["NIntegrate", "MR"],
  " to get a precise answer. However, by setting the option ",
  StyleBox["MaxPoints", "MR"],
  ", you can tell ",
  StyleBox["NIntegrate", "MR"],
  " to give you just a rough estimate, sampling the integrand only a limited \
number of times. "
}], "Text",
  CellTags->{"S3.9.3", "3.20"}],

Cell["\<\
This gives an estimate of the volume of the unit sphere in three \
dimensions. \
\>", "MathCaption",
  CellTags->{"S3.9.3", "3.21"}],

Cell[CellGroupData[{

Cell["\<\
NIntegrate[If[x^2 + y^2 + z^2 < 1, 1, 0], {x, -1, 1}, {y, -1, 1}, \
{z, -1, 1}, MaxPoints->10000]\
\>", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(4.181059657905715`\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.9.3"]
}, Open  ]],

Cell["Here is the precise result. ", "MathCaption",
  CellTags->{"S3.9.3", "3.22"}],

Cell[CellGroupData[{

Cell["N[4/3 Pi]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.9.3"],

Cell[BoxData[
    \(4.1887902047863905`\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.9.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.9.4 Numerical Evaluation of Sums and Products", "Subsection",
  CellTags->{"S3.9.4", "4.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NSum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "find a numerical approximation to the sum ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["i",
                            "TI"], "=", 
                          SubscriptBox[
                            StyleBox["i",
                              "TI"], 
                            StyleBox["min",
                              "TI"]]}], 
                        SubscriptBox[
                          StyleBox["i",
                            "TI"], 
                          StyleBox["max",
                            "TI"]],
                        LimitsPositioning->True], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NSum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["di", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "use step ",
              StyleBox["di", "TI"],
              " in the sum "
            }]]},
          {Cell[TextData[{
              StyleBox["NProduct[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "find a numerical approximation to the product ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      UnderoverscriptBox["\[Product]", 
                        RowBox[{
                          StyleBox["i",
                            "TI"], "=", 
                          SubscriptBox[
                            StyleBox["i",
                              "TI"], 
                            StyleBox["min",
                              "TI"]]}], 
                        SubscriptBox[
                          StyleBox["i",
                            "TI"], 
                          StyleBox["max",
                            "TI"]],
                        LimitsPositioning->True], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.9.4"],

Cell["Numerical sums and products. ", "Caption",
  CellTags->"S3.9.4"],

Cell[TextData[{
  "This gives a numerical approximation to ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["i",
                "TI"], "=", "1"}], "\[Infinity]",
            LimitsPositioning->True], 
          FractionBox["1", 
            RowBox[{
              SuperscriptBox[
                StyleBox["i",
                  "TI"], "3"], "+", 
              StyleBox["i",
                "TI"], "!"}]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.4", "4.2"}],

Cell[CellGroupData[{

Cell["NSum[1/(i^3 + i!), {i, 1, Infinity}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.9.4"],

Cell[BoxData[
    \(0.647029989016478`\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.9.4"]
}, Open  ]],

Cell[TextData[{
  "There is no exact result for this sum, so ",
  StyleBox["Mathematica", "TI"],
  " leaves it in a symbolic form. "
}], "MathCaption",
  CellTags->{"S3.9.4", "4.3"}],

Cell[CellGroupData[{

Cell["Sum[1/(i^3 + i!), {i, 1, Infinity}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.9.4"],

Cell[BoxData[
    \(\[Sum]\+\(i = 1\)\%\[Infinity] 1\/\(i\^3 + \(i!\)\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.9.4"]
}, Open  ]],

Cell[TextData[{
  "You can apply ",
  StyleBox["N", "MR"],
  " explicitly to get a numerical result. "
}], "MathCaption",
  CellTags->{"S3.9.4", "4.4"}],

Cell[CellGroupData[{

Cell["N[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.9.4"],

Cell[BoxData[
    \(0.647029989016478`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.9.4"]
}, Open  ]],

Cell[TextData[{
  "The way ",
  StyleBox["NSum", "MR"],
  " works is to include a certain number of terms explicitly, and then to try \
and estimate the contribution of the remaining ones. There are two approaches \
to estimating this contribution. The first uses the Euler\[Hyphen]Maclaurin \
method, and is based on approximating the sum by an integral. The second \
method, known as the Wynn epsilon method, samples a number of additional \
terms in the sum, and then tries to fit them to a polynomial multiplied by a \
decaying exponential. "
}], "Text",
  CellTags->{"S3.9.4", "4.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["Method", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Integrate", "MR"],
              " (Euler\[Hyphen]Maclaurin method) or ",
              StyleBox["Fit", "MR"],
              " (Wynn epsilon method) "
            }]]},
          {Cell[TextData[{
              StyleBox["NSumTerms", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["15", "MR"],
              " "
            }]], Cell["number of terms to include explicitly "]},
          {Cell[TextData[{
              StyleBox["NSumExtraTerms", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["12", "MR"],
              " "
            }]], 
            Cell["\<\
number of terms to use for extrapolation in the Wynn \
epsilon method \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S3.9.4"],

Cell[TextData[{
  "Special options for ",
  StyleBox["NSum", "MR"],
  ". "
}], "Caption",
  CellTags->"S3.9.4"],

Cell[TextData[{
  "If you do not explicitly specify the method to use, ",
  StyleBox["NSum", "MR"],
  " will try to choose between the methods it knows. In any case, some \
implicit assumptions about the functions you are summing have to be made. If \
these assumptions are not correct, you may get inaccurate answers. "
}], "Text",
  CellTags->{"S3.9.4", "4.6"}],

Cell[TextData[{
  "The most common place to use ",
  StyleBox["NSum", "MR"],
  " is in evaluating sums with infinite limits. You can, however, also use it \
for sums with finite limits. By making implicit assumptions about the objects \
you are evaluating, ",
  StyleBox["NSum", "MR"],
  " can often avoid doing as many function evaluations as an explicit ",
  StyleBox["Sum", "MR"],
  " computation would require. "
}], "Text",
  CellTags->{"S3.9.4", "4.7"}],

Cell[TextData[{
  "This finds the numerical value of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["n",
                "TI"], "=", "0"}], "100",
            LimitsPositioning->True], 
          SuperscriptBox[
            StyleBox["e",
              "TI"], 
            RowBox[{"-", 
              StyleBox["n",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  " by extrapolation techniques. "
}], "MathCaption",
  CellTags->{"S3.9.4", "4.8"}],

Cell[CellGroupData[{

Cell["NSum[Exp[-n], {n, 0, 100}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.9.4"],

Cell[BoxData[
    \(1.5819767068693265`\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.9.4"]
}, Open  ]],

Cell["\<\
You can also get the result, albeit much less efficiently, by \
constructing the symbolic form of the sum, then evaluating it numerically. \
\
\>", "MathCaption",
  CellTags->{"S3.9.4", "4.9"}],

Cell[CellGroupData[{

Cell["Sum[Exp[-n], {n, 0, 100}] //N", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.9.4"],

Cell[BoxData[
    \(1.5819767068693267`\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.9.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NProduct", "MR"],
  " works in essentially the same way as ",
  StyleBox["NSum", "MR"],
  ", with analogous options. "
}], "Text",
  CellTags->{"S3.9.4", "4.10"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.9.5 Numerical Solution of Polynomial Equations", "Subsection",
  CellTags->{"S3.9.5", "5.1"}],

Cell[TextData[{
  "When ",
  StyleBox["Solve", "MR"],
  " cannot find explicit solutions to polynomial equations, it returns a \
symbolic form of the result in terms of ",
  StyleBox["Root", "MR"],
  " objects. "
}], "MathCaption",
  CellTags->{"S3.9.5", "5.2"}],

Cell[CellGroupData[{

Cell["Solve[x^5 + 7x + 1 == 0, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.9.5"],

Cell[BoxData[
    \({{x \[Rule] Root[1 + 7\ #1 + #1\^5 &, 1]}, {x \[Rule] 
          Root[1 + 7\ #1 + #1\^5 &, 2]}, {x \[Rule] 
          Root[1 + 7\ #1 + #1\^5 &, 3]}, {x \[Rule] 
          Root[1 + 7\ #1 + #1\^5 &, 4]}, {x \[Rule] 
          Root[1 + 7\ #1 + #1\^5 &, 5]}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.9.5"]
}, Open  ]],

Cell[TextData[{
  "You can get numerical solutions by applying ",
  StyleBox["N", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.5", "5.3"}],

Cell[CellGroupData[{

Cell["N[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.9.5"],

Cell[BoxData[
    \({{x \[Rule] \(-0.14284864552500443`\)}, {x \[Rule] \
\(-1.1130779765477108`\) - 
            1.1517343621516742`\ \[ImaginaryI]}, {x \[Rule] \
\(-1.1130779765477108`\) + 
            1.1517343621516742`\ \[ImaginaryI]}, {x \[Rule] \
\(\(1.184502299310213`\)\(\[InvisibleSpace]\)\) - 
            1.1513900754088373`\ \[ImaginaryI]}, {x \[Rule] \
\(\(1.184502299310213`\)\(\[InvisibleSpace]\)\) + 
            1.1513900754088373`\ \[ImaginaryI]}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.9.5"]
}, Open  ]],

Cell["\<\
This gives the numerical solutions to 25\[Hyphen]digit precision. \
\
\>", "MathCaption",
  CellTags->{"S3.9.5", "5.4"}],

Cell[CellGroupData[{

Cell["N[%%, 25]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.9.5"],

Cell[BoxData[
    \({{x \[Rule] \(-0.14284864552500443411341155094667154925`25. \)}, {x \
\[Rule] \(-1.11307797654771073560039789931908355606`24.99246011186423\) - 
            1.15173436215167430504677021966075575906`25.007286846279968\ \
\[ImaginaryI]}, {x \[Rule] \
\(-1.11307797654771073560039789931908355606`24.99246011186423\) + 
            1.15173436215167430504677021966075575906`25.007286846279968\ \
\[ImaginaryI]}, {x \[Rule] 
          1.18450229931021295265710367479241933069`25.006069445147862 - 
            1.15139007540883707469914666565451123998`24.993756018716955\ \
\[ImaginaryI]}, {x \[Rule] 
          1.18450229931021295265710367479241933069`25.006069445147862 + 
            1.15139007540883707469914666565451123998`24.993756018716955\ \
\[ImaginaryI]}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.9.5"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["NSolve", "MR"],
  " to get numerical solutions to polynomial equations directly, without \
first trying to find exact results. "
}], "MathCaption",
  CellTags->{"S3.9.5", "5.5"}],

Cell[CellGroupData[{

Cell["NSolve[x^7 + x + 1 == 0, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.9.5"],

Cell[BoxData[
    \({{x \[Rule] \(-0.7965443541284568`\)}, {x \[Rule] \
\(-0.7052980879371502`\) - 
            0.6376237698062315`\ \[ImaginaryI]}, {x \[Rule] \
\(-0.7052980879371502`\) + 
            0.6376237698062315`\ \[ImaginaryI]}, {x \[Rule] \
\(\(0.12376188051147742`\)\(\[InvisibleSpace]\)\) - 
            1.0566500111970736`\ \[ImaginaryI]}, {x \[Rule] \
\(\(0.12376188051147742`\)\(\[InvisibleSpace]\)\) + 
            1.0566500111970736`\ \[ImaginaryI]}, {x \[Rule] \
\(\(0.9798083844899013`\)\(\[InvisibleSpace]\)\) - 
            0.516676883839912`\ \[ImaginaryI]}, {x \[Rule] \
\(\(0.9798083844899013`\)\(\[InvisibleSpace]\)\) + 
            0.516676883839912`\ \[ImaginaryI]}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.9.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NSolve[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox["==0,", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
get approximate numerical solutions to a polynomial \
equation \
\>"]},
          {Cell[TextData[{
              StyleBox["NSolve[", "MR"],
              StyleBox["poly", "TI"],
              StyleBox["==0,", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "get solutions to ",
              StyleBox["n", "TI"],
              "\[Hyphen]digit precision "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.9.5"],

Cell["Numerical solution of polynomial equations. ", "Caption",
  CellTags->"S3.9.5"],

Cell[TextData[{
  StyleBox["NSolve", "MR"],
  " will always give you the complete set of numerical solutions to any \
polynomial equation in one variable. "
}], "Text",
  CellTags->{"S3.9.5", "5.6"}],

Cell[TextData[{
  "You can also get numerical solutions to sets of simultaneous polynomial \
equations. You can use ",
  StyleBox["Solve", "MR"],
  " to \[OpenCurlyDoubleQuote]unwind\[CloseCurlyDoubleQuote] the simultaneous \
equations, and then apply ",
  StyleBox["N", "MR"],
  " to get numerical results. "
}], "Text",
  CellTags->{"S3.9.5", "5.7"}],

Cell[TextData[{
  StyleBox["Solve", "MR"],
  " writes the solution in terms of roots of a polynomial in one variable. "
}], "MathCaption",
  CellTags->{"S3.9.5", "5.8"}],

Cell[CellGroupData[{

Cell["First[ Solve[{x^2 + y^2 == 1, x^3 + y^3 == 2}, {x, y}]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.9.5"],

Cell[BoxData[
    \({x \[Rule] 
        1\/3\ Root[3 + 3\ #1\^2 - 4\ #1\^3 - 3\ #1\^4 + 2\ #1\^6 &, 
            1]\ \((\(-3\) - 
              6\ Root[3 + 3\ #1\^2 - 4\ #1\^3 - 3\ #1\^4 + 2\ #1\^6 &, 1] - 
              Root[3 + 3\ #1\^2 - 4\ #1\^3 - 3\ #1\^4 + 2\ #1\^6 &, 1]\^2 + 
              4\ Root[3 + 3\ #1\^2 - 4\ #1\^3 - 3\ #1\^4 + 2\ #1\^6 &, 1]\^3 \
+ 2\ Root[3 + 3\ #1\^2 - 4\ #1\^3 - 3\ #1\^4 + 2\ #1\^6 &, 1]\^4)\), 
      y \[Rule] 
        Root[3 + 3\ #1\^2 - 4\ #1\^3 - 3\ #1\^4 + 2\ #1\^6 &, 1]}\)], "Output",\

  CellLabel->"Out[5]= ",
  CellTags->"S3.9.5"]
}, Open  ]],

Cell[TextData[{
  "You can apply ",
  StyleBox["N", "MR"],
  " to get a numerical result. "
}], "MathCaption",
  CellTags->{"S3.9.5", "5.9"}],

Cell[CellGroupData[{

Cell["N[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.9.5"],

Cell[BoxData[
    \({x \[Rule] \(-1.0979116727228242`\) + 
          0.8398869216156594`\ \[ImaginaryI], 
      y \[Rule] \(-1.0979116727228235`\) - 
          0.8398869216156593`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.9.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.9.6 Numerical Root Finding", "Subsection",
  CellTags->{"S3.9.6", "6.1"}],

Cell[TextData[{
  StyleBox["NSolve", "MR"],
  " gives you a general way to find numerical approximations to the solutions \
of polynomial equations. Finding numerical solutions to more general \
equations, however, can be much more difficult, as discussed in Section ",
  ButtonBox["3.4.2",
    ButtonData:>{"3.4.2", "2.35"},
    ButtonStyle->"MainBookLink"],
  ". ",
  StyleBox["FindRoot", "MR"],
  " gives you a way to search for a numerical solution to an arbitrary \
equation, or set of equations.        "
}], "Text",
  CellTags->{"S3.9.6", "6.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FindRoot[", "MR"],
              StyleBox["lhs", "TI"],
              StyleBox["==", "MR"],
              StyleBox["rhs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "search for a numerical solution to the equation ",
              StyleBox["lhs", "TI"],
              StyleBox["==", "MR"],
              StyleBox["rhs", "TI"],
              ", starting with ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FindRoot[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "search for a numerical solution to the simultaneous equations \
",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.9.6"],

Cell["Numerical root finding. ", "Caption",
  CellTags->"S3.9.6"],

Cell[TextData[{
  "The curves for ",
  Cell[BoxData[
      FormBox[
        RowBox[{"cos", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " intersect at one point. "
}], "MathCaption",
  CellTags->{"S3.9.6", "6.3"}],

Cell[CellGroupData[{

Cell["Plot[{Cos[x], x}, {x, -1, 1}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.9.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.309017 0.294302 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -12 -9 ]
[.2619 .29652 12 0 ]
[.7381 .29652 -9 -9 ]
[.7381 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 .01472 -12 -4.5 ]
[.4875 .01472 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-0.5)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(0.5)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01472 m
.50625 .01472 L
s
[(-1)] .4875 .01472 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .46803 m
.06244 .48758 L
.10458 .50755 L
.14415 .5249 L
.18221 .54018 L
.22272 .55482 L
.26171 .56723 L
.30316 .57853 L
.34309 .58748 L
.3815 .59425 L
.40095 .59697 L
.42237 .59942 L
.44268 .60119 L
.45178 .60181 L
.46172 .60237 L
.4671 .60262 L
.4721 .60281 L
.47727 .60298 L
.48196 .60311 L
.48658 .6032 L
.4887 .60324 L
.49093 .60327 L
.49332 .60329 L
.49438 .6033 L
.49552 .60331 L
.49675 .60331 L
.49789 .60332 L
.49859 .60332 L
.49925 .60332 L
.50049 .60332 L
.50163 .60332 L
.50286 .60331 L
.50401 .60331 L
.50508 .6033 L
.50754 .60328 L
.51014 .60325 L
.51268 .60321 L
.51504 .60317 L
.5204 .60305 L
.5293 .60276 L
.53882 .60234 L
.54906 .60176 L
.56016 .60097 L
.58032 .59914 L
.60019 .59683 L
.62123 .59383 L
.65912 .58704 L
.69946 .57788 L
.73829 .56723 L
.77956 .55404 L
Mistroke
.81932 .53959 L
.85757 .52418 L
.89827 .50625 L
.93745 .48763 L
.97619 .46803 L
Mfstroke
.02381 .01472 m
.06244 .03859 L
.10458 .06463 L
.14415 .08909 L
.18221 .11261 L
.22272 .13765 L
.26171 .16175 L
.30316 .18736 L
.34309 .21204 L
.3815 .23578 L
.42237 .26104 L
.46172 .28536 L
.49955 .30874 L
.53984 .33364 L
.57861 .3576 L
.61984 .38308 L
.65954 .40762 L
.69774 .43123 L
.73838 .45635 L
.77751 .48053 L
.81909 .50623 L
.85916 .53099 L
.89771 .55482 L
.93871 .58016 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.9.6"]
}, Open  ]],

Cell[TextData[{
  "This finds a numerical approximation to the value of ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " at which the intersection occurs. The ",
  StyleBox["0", "MR"],
  " tells ",
  StyleBox["FindRoot", "MR"],
  " what value of ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " to try first. "
}], "MathCaption",
  CellTags->{"S3.9.6", "6.4"}],

Cell[CellGroupData[{

Cell["FindRoot[Cos[x] == x, {x, 0}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.9.6"],

Cell[BoxData[
    \({x \[Rule] 0.7390851332151607`}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.9.6"]
}, Open  ]],

Cell[TextData[{
  "In trying to find a solution to your equation, ",
  StyleBox["FindRoot", "MR"],
  " starts at the point you specify, and then progressively tries to get \
closer and closer to a solution. Even if your equations have several \
solutions, ",
  StyleBox["FindRoot", "MR"],
  " always returns the first solution it finds. Which solution this is will \
depend on what starting point you chose. If you start sufficiently close to a \
particular solution, ",
  StyleBox["FindRoot", "MR"],
  " will usually return that solution. "
}], "Text",
  CellTags->{"S3.9.6", "6.5"}],

Cell[TextData[{
  "The equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", "0"}], TraditionalForm]], "InlineFormula"],
  " has an infinite number of solutions of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", 
          StyleBox["n",
            "TI"], "\[Pi]"}], TraditionalForm]], "InlineFormula"],
  ". If you start sufficiently close to a particular solution, ",
  StyleBox["FindRoot", "MR"],
  " will give you that solution. "
}], "MathCaption",
  CellTags->{"S3.9.6", "6.6"}],

Cell[CellGroupData[{

Cell["FindRoot[Sin[x] == 0, {x, 3}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.9.6"],

Cell[BoxData[
    \({x \[Rule] 3.141592653589793`}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.9.6"]
}, Open  ]],

Cell[TextData[{
  "If you start with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "6"}], TraditionalForm]], "InlineFormula"],
  ", you get a numerical approximation to the solution ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "2", "\[Pi]"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.6", "6.7"}],

Cell[CellGroupData[{

Cell["FindRoot[Sin[x] == 0, {x, 6}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.9.6"],

Cell[BoxData[
    \({x \[Rule] 6.283185307179586`}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.9.6"]
}, Open  ]],

Cell[TextData[{
  "If you want ",
  StyleBox["FindRoot", "MR"],
  " to search for complex solutions, then you have to give a complex starting \
value. "
}], "MathCaption",
  CellTags->{"S3.9.6", "6.8"}],

Cell[CellGroupData[{

Cell["FindRoot[Sin[x] == 2, {x, I}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.9.6"],

Cell[BoxData[
    \({x \[Rule] \(\(1.5707963267948966`\)\(\[InvisibleSpace]\)\) + 
          1.3169578969248168`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.9.6"]
}, Open  ]],

Cell["This finds a zero of the Riemann zeta function. ", "MathCaption",
  CellTags->{"S3.9.6", "6.9"}],

Cell[CellGroupData[{

Cell["FindRoot[Zeta[1/2 + I t] == 0, {t, 12}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.9.6"],

Cell[BoxData[
    \({t \[Rule] \(\(14.134725141734696`\)\(\[InvisibleSpace]\)\) - 
          5.22332025027859`*^-15\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.9.6"]
}, Open  ]],

Cell["This finds a solution to a set of simultaneous equations. ", \
"MathCaption",
  CellTags->{"S3.9.6", "6.10"}],

Cell[CellGroupData[{

Cell["FindRoot[{Sin[x] == Cos[y], x + y == 1}, {{x, 1}, {y, 1}}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.9.6"],

Cell[BoxData[
    \({x \[Rule] \(-1.856194490192345`\), 
      y \[Rule] 2.856194490192345`}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.9.6"]
}, Open  ]],

Cell[TextData[{
  "The variables used by ",
  StyleBox["FindRoot", "MR"],
  " can have values that are lists. This allows you to find roots of \
functions that take vectors as arguments. "
}], "Text",
  CellTags->{"S3.9.6", "6.11"}],

Cell[TextData[{
  "This is a way to solve a linear equation for the variable ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.6", "6.12"}],

Cell[CellGroupData[{

Cell["FindRoot[{{1, 2}, {3, 4}} . x == {5, 6}, {x, {1, 1}}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.9.6"],

Cell[BoxData[
    \({x \[Rule] {\(-4.`\), 4.5`}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.9.6"]
}, Open  ]],

Cell[TextData[{
  "This finds a normalized eigenvector ",
  StyleBox["x", "MR"],
  " and eigenvalue ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.6", "6.13"}],

Cell[CellGroupData[{

Cell["\<\
FindRoot[{{{1, 2}, {3, 4}} . x == a x, x.x == 1}, {{x, {1, 1}}, {a, \
1}}]\
\>", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.9.6"],

Cell[BoxData[
    \({x \[Rule] {0.4159735579192843`, 0.9093767091321241`}, 
      a \[Rule] 5.372281323269015`}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.9.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.9.7 Numerical Solution of Differential Equations", "Subsection",
  CellTags->{"S3.9.7", "7.1"}],

Cell[TextData[{
  "The function ",
  StyleBox["NDSolve", "MR"],
  " discussed in Section ",
  ButtonBox["1.6.4",
    ButtonData:>{"1.6.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  " allows you to find numerical solutions to differential equations. ",
  StyleBox["NDSolve", "MR"],
  " handles both single differential equations, and sets of simultaneous \
differential equations. It can handle a wide range of ",
  StyleBox["ordinary differential equations", "TI"],
  " as well as some ",
  StyleBox["partial differential equations", "TI"],
  ". In a system of ordinary differential equations there can be any number \
of unknown functions ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["y",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", but all of these functions must depend on a single \
\[OpenCurlyDoubleQuote]independent variable\[CloseCurlyDoubleQuote] ",
  StyleBox["x", "TI"],
  ", which is the same for each function. Partial differential equations \
involve two or more independent variables. ",
  StyleBox["NDSolve", "MR"],
  " can also handle ",
  StyleBox["differential\[Hyphen]algebraic equations", "TI"],
  " that mix differential equations with algebraic ones. "
}], "Text",
  CellTags->{"S3.9.7", "7.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NDSolve[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "find a numerical solution for the function ",
              StyleBox["y", "TI"],
              " with ",
              StyleBox["x", "TI"],
              " in the range ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NDSolve[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, {",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "find numerical solutions for several functions ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.9.7"],

Cell["\<\
Finding numerical solutions to ordinary differential equations. \
\
\>", "Caption",
  CellTags->"S3.9.7"],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " represents solutions for the functions ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["y",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " as ",
  StyleBox["InterpolatingFunction", "MR"],
  " objects. The",
  StyleBox["InterpolatingFunction", "MR"],
  " objects provide approximations to the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["y",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " over the range of values ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " for the independent variable ",
  StyleBox["x", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.9.7", "7.3"}],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " finds solutions iteratively. It starts at a particular value of ",
  StyleBox["x", "TI"],
  ", then takes a sequence of steps, trying eventually to cover the whole \
range ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.9.7", "7.4"}],

Cell[TextData[{
  "In order to get started, ",
  StyleBox["NDSolve", "MR"],
  " has to be given appropriate initial or boundary conditions for the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["y",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " and their derivatives. These conditions specify values for ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["y",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ", and perhaps derivatives ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["y",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["'[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ", at particular points ",
  StyleBox["x", "TI"],
  ". In general, at least for ordinary differential equations, the conditions \
you give can be at any ",
  StyleBox["x", "TI"],
  ": ",
  StyleBox["NDSolve", "MR"],
  " will automatically cover the range ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S3.9.7", "7.5"}],

Cell[TextData[{
  "This finds a solution for ",
  StyleBox["y", "MR"],
  " with ",
  StyleBox["x", "MR"],
  " in the range ",
  StyleBox["0", "MR"],
  " to ",
  StyleBox["2", "MR"],
  ", using an initial condition for ",
  StyleBox["y[0]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.6"}],

Cell[CellGroupData[{

Cell["NDSolve[{y'[x] == y[x], y[0] == 1}, y, {x, 0, 2}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  "This still finds a solution with ",
  StyleBox["x", "MR"],
  " in the range ",
  StyleBox["0", "MR"],
  " to ",
  StyleBox["2", "MR"],
  ", but now the initial condition is for ",
  StyleBox["y[3]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.7"}],

Cell[CellGroupData[{

Cell["NDSolve[{y'[x] == y[x], y[3] == 1}, y, {x, 0, 2}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell["Here is a simple boundary value problem. ", "MathCaption",
  CellTags->{"S3.9.7", "7.8"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[{y''[x] + x y[x] == 0, y[0] == 1, y[1] == -1}, y, {x, 0, \
1}]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  "When you use ",
  StyleBox["NDSolve", "MR"],
  ", the initial or boundary conditions you give must be sufficient to \
determine the solutions for the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["y",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " completely. When you use ",
  StyleBox["DSolve", "MR"],
  " to find symbolic solutions to differential equations, you can get away \
with specifying fewer initial conditions. The reason is that ",
  StyleBox["DSolve", "MR"],
  " automatically inserts arbitrary constants ",
  StyleBox["C[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  " to represent degrees of freedom associated with initial conditions that \
you have not specified explicitly. Since ",
  StyleBox["NDSolve", "MR"],
  " must give a numerical solution, it cannot represent these kinds of \
additional degrees of freedom. As a result, you must explicitly give all the \
initial or boundary conditions that are needed to determine the solution. "
}], "Text",
  CellTags->{"S3.9.7", "7.9"}],

Cell[TextData[{
  "In a typical case, if you have differential equations with up to ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " derivatives, then you need to give initial conditions for up to ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            StyleBox["n",
              "TI"], "-", "1"}], ")"}], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " derivatives, or give boundary conditions at ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " points. "
}], "Text",
  CellTags->{"S3.9.7", "7.10"}],

Cell["\<\
With a third\[Hyphen]order equation, you need to give initial \
conditions for up to second derivatives. \
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.11"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[ { y'''[x] + 8 y''[x] + 17 y'[x] + 10 y[x] == 0, y[0] == 6, \
y'[0] == -20, y''[0] == 84}, y, {x, 0, 1} ]\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell["This plots the solution obtained.", "MathCaption",
  CellTags->{"S3.9.7", "7.12"}],

Cell[CellGroupData[{

Cell["Plot[Evaluate[ y[x] /. % ], {x, 0, 1}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.9.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.0981006 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .11282 -6 -4.5 ]
[.01131 .11282 0 4.5 ]
[.01131 .21092 -6 -4.5 ]
[.01131 .21092 0 4.5 ]
[.01131 .30902 -6 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .40712 -6 -4.5 ]
[.01131 .40712 0 4.5 ]
[.01131 .50522 -6 -4.5 ]
[.01131 .50522 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .11282 m
.03006 .11282 L
s
[(1)] .01131 .11282 1 0 Mshowa
.02381 .21092 m
.03006 .21092 L
s
[(2)] .01131 .21092 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(3)] .01131 .30902 1 0 Mshowa
.02381 .40712 m
.03006 .40712 L
s
[(4)] .01131 .40712 1 0 Mshowa
.02381 .50522 m
.03006 .50522 L
s
[(5)] .01131 .50522 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(6)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03434 m
.02756 .03434 L
s
.02381 .05396 m
.02756 .05396 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .0932 m
.02756 .0932 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .15206 m
.02756 .15206 L
s
.02381 .17168 m
.02756 .17168 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .23054 m
.02756 .23054 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .26978 m
.02756 .26978 L
s
.02381 .2894 m
.02756 .2894 L
s
.02381 .32864 m
.02756 .32864 L
s
.02381 .34826 m
.02756 .34826 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .3875 m
.02756 .3875 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .44636 m
.02756 .44636 L
s
.02381 .46598 m
.02756 .46598 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .52484 m
.02756 .52484 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .56408 m
.02756 .56408 L
s
.02381 .5837 m
.02756 .5837 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .5301 L
.10458 .46302 L
.14415 .41002 L
.18221 .36659 L
.22272 .32711 L
.26171 .29459 L
.30316 .26491 L
.34309 .24028 L
.3815 .21968 L
.42237 .20054 L
.46172 .18441 L
.49955 .17071 L
.53984 .15776 L
.57861 .14669 L
.61984 .13618 L
.65954 .12712 L
.69774 .11927 L
.73838 .1117 L
.77751 .1051 L
.81909 .09873 L
.85916 .09314 L
.89771 .08821 L
.93871 .08339 L
.97619 .07934 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell["\<\
With a third\[Hyphen]order equation, you can also give boundary \
conditions at three points. \
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.13"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[ { y'''[x] + Sin[x] == 0, y[0] == 4, y[1] == 7, y[2] == 0 \
}, y, {x, 0, 2}]\
\>", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to use any appropriate linear combination of function values \
and derivatives as boundary conditions. "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.14"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[{ y''[x] + y[x] == 12 x, 2 y[0] - y'[0] == -1, 2 y[1] + \
y'[1] == 9}, y, {x, 0, 1}]\
\>", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  "In most cases, all the initial conditions you give must involve the same \
value of ",
  StyleBox["x", "TI"],
  ", say ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  ". As a result, you can avoid giving both ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " explicitly. If you specify your range of ",
  StyleBox["x", "TI"],
  " as ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox["}", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " will automatically generate a solution over the range ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.9.7", "7.15"}],

Cell["This generates a solution over the range 0 to 2. ", "MathCaption",
  CellTags->{"S3.9.7", "7.16"}],

Cell[CellGroupData[{

Cell["NDSolve[{y'[x] == y[x], y[0] == 1}, y, {x, 2}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  "You can give initial conditions as equations of any kind. In some cases, \
these equations may have multiple solutions. In such cases, ",
  StyleBox["NDSolve", "MR"],
  " will correspondingly generate multiple solutions. "
}], "Text",
  CellTags->{"S3.9.7", "7.17"}],

Cell["\<\
The initial conditions in this case lead to multiple solutions. \
\
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.18"}],

Cell[CellGroupData[{

Cell["NDSolve[{y'[x]^2 - y[x]^2 == 0, y[0]^2 == 4}, y[x], {x, 1}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{\(y[x]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
                False,
                Editable->False], "[", "x", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\(y[x]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
                False,
                Editable->False], "[", "x", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\(y[x]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
                False,
                Editable->False], "[", "x", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\(y[x]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
                False,
                Editable->False], "[", "x", "]"}]}], "}"}]}], "}"}]], "Output",\

  CellLabel->"Out[9]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell["Here is a plot of all the solutions. ", "MathCaption",
  CellTags->{"S3.9.7", "7.19"}],

Cell[CellGroupData[{

Cell["Plot[Evaluate[ y[x] /. % ], {x, 0, 1}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.9.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.0541338 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .09248 -12 -4.5 ]
[.01131 .09248 0 4.5 ]
[.01131 .20075 -12 -4.5 ]
[.01131 .20075 0 4.5 ]
[.01131 .41728 -6 -4.5 ]
[.01131 .41728 0 4.5 ]
[.01131 .52555 -6 -4.5 ]
[.01131 .52555 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .09248 m
.03006 .09248 L
s
[(-4)] .01131 .09248 1 0 Mshowa
.02381 .20075 m
.03006 .20075 L
s
[(-2)] .01131 .20075 1 0 Mshowa
.02381 .41728 m
.03006 .41728 L
s
[(2)] .01131 .41728 1 0 Mshowa
.02381 .52555 m
.03006 .52555 L
s
[(4)] .01131 .52555 1 0 Mshowa
.125 Mabswid
.02381 .11955 m
.02756 .11955 L
s
.02381 .14662 m
.02756 .14662 L
s
.02381 .17368 m
.02756 .17368 L
s
.02381 .22782 m
.02756 .22782 L
s
.02381 .25488 m
.02756 .25488 L
s
.02381 .28195 m
.02756 .28195 L
s
.02381 .33608 m
.02756 .33608 L
s
.02381 .36315 m
.02756 .36315 L
s
.02381 .39022 m
.02756 .39022 L
s
.02381 .44435 m
.02756 .44435 L
s
.02381 .47142 m
.02756 .47142 L
s
.02381 .49849 m
.02756 .49849 L
s
.02381 .06541 m
.02756 .06541 L
s
.02381 .03835 m
.02756 .03835 L
s
.02381 .01128 m
.02756 .01128 L
s
.02381 .55262 m
.02756 .55262 L
s
.02381 .57969 m
.02756 .57969 L
s
.02381 .60675 m
.02756 .60675 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .20075 m
.06244 .20505 L
.10458 .20955 L
.14415 .2136 L
.18221 .21734 L
.22272 .22116 L
.26171 .22468 L
.30316 .22827 L
.34309 .23159 L
.3815 .23465 L
.42237 .23777 L
.46172 .24066 L
.49955 .24332 L
.53984 .24604 L
.57861 .24855 L
.61984 .25111 L
.65954 .25348 L
.69774 .25566 L
.73838 .25789 L
.77751 .25995 L
.81909 .26204 L
.85916 .26398 L
.89771 .26577 L
.93871 .26759 L
.97619 .26919 L
s
.02381 .41728 m
.06244 .41298 L
.10458 .40848 L
.14415 .40443 L
.18221 .4007 L
.22272 .39688 L
.26171 .39335 L
.30316 .38976 L
.34309 .38645 L
.3815 .38339 L
.42237 .38026 L
.46172 .37738 L
.49955 .37472 L
.53984 .37199 L
.57861 .36948 L
.61984 .36692 L
.65954 .36456 L
.69774 .36237 L
.73838 .36014 L
.77751 .35809 L
.81909 .35599 L
.85916 .35405 L
.89771 .35227 L
.93871 .35044 L
.97619 .34885 L
s
.02381 .20075 m
.06244 .19627 L
.10458 .19117 L
.14415 .18617 L
.18221 .18116 L
.22272 .1756 L
.26171 .17003 L
.30316 .16385 L
.34309 .15763 L
.3815 .1514 L
.42237 .14449 L
.46172 .13755 L
.49955 .1306 L
.53984 .12289 L
.57861 .11515 L
.61984 .10658 L
.65954 .09796 L
.69774 .08932 L
.73838 .07975 L
.77751 .07013 L
.81909 .05947 L
.85916 .04875 L
.89771 .03799 L
.93871 .02607 L
.97619 .01472 L
s
.02381 .41728 m
.06244 .42177 L
.10458 .42687 L
.14415 .43187 L
.18221 .43688 L
.22272 .44243 L
.26171 .44801 L
.30316 .45419 L
.34309 .4604 L
.3815 .46664 L
.42237 .47355 L
.46172 .48049 L
.49955 .48744 L
.53984 .49515 L
.57861 .50288 L
.61984 .51145 L
.65954 .52007 L
.69774 .52871 L
.73838 .53829 L
.77751 .5479 L
.81909 .55857 L
.85916 .56929 L
.89771 .58004 L
.93871 .59196 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["NDSolve", "MR"],
  " to solve systems of coupled differential equations. "
}], "Text",
  CellTags->{"S3.9.7", "7.20"}],

Cell["\<\
This finds a numerical solution to a pair of coupled equations. \
\
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.21"}],

Cell[CellGroupData[{

Cell["\<\
sol = NDSolve[ {x'[t] == -y[t] - x[t]^2, y'[t] == 2 x[t] - y[t], \
x[0] == y[0] == 1}, {x, y}, {t, 10}]\
\>", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"x", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 10.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"y", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 10.`}}, "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  "This plots the solution for ",
  StyleBox["y", "MR"],
  " from these equations. "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.22"}],

Cell[CellGroupData[{

Cell["Plot[Evaluate[y[t] /. sol], {t, 0, 10}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.9.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.209133 0.352384 [
[.21429 .19663 -3 -9 ]
[.21429 .19663 3 0 ]
[.40476 .19663 -3 -9 ]
[.40476 .19663 3 0 ]
[.59524 .19663 -3 -9 ]
[.59524 .19663 3 0 ]
[.78571 .19663 -3 -9 ]
[.78571 .19663 3 0 ]
[.97619 .19663 -6 -9 ]
[.97619 .19663 6 0 ]
[.01131 .03294 -24 -4.5 ]
[.01131 .03294 0 4.5 ]
[.01131 .12104 -30 -4.5 ]
[.01131 .12104 0 4.5 ]
[.01131 .29723 -24 -4.5 ]
[.01131 .29723 0 4.5 ]
[.01131 .38532 -18 -4.5 ]
[.01131 .38532 0 4.5 ]
[.01131 .47342 -24 -4.5 ]
[.01131 .47342 0 4.5 ]
[.01131 .56152 -6 -4.5 ]
[.01131 .56152 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .20913 m
.21429 .21538 L
s
[(2)] .21429 .19663 0 1 Mshowa
.40476 .20913 m
.40476 .21538 L
s
[(4)] .40476 .19663 0 1 Mshowa
.59524 .20913 m
.59524 .21538 L
s
[(6)] .59524 .19663 0 1 Mshowa
.78571 .20913 m
.78571 .21538 L
s
[(8)] .78571 .19663 0 1 Mshowa
.97619 .20913 m
.97619 .21538 L
s
[(10)] .97619 .19663 0 1 Mshowa
.125 Mabswid
.07143 .20913 m
.07143 .21288 L
s
.11905 .20913 m
.11905 .21288 L
s
.16667 .20913 m
.16667 .21288 L
s
.2619 .20913 m
.2619 .21288 L
s
.30952 .20913 m
.30952 .21288 L
s
.35714 .20913 m
.35714 .21288 L
s
.45238 .20913 m
.45238 .21288 L
s
.5 .20913 m
.5 .21288 L
s
.54762 .20913 m
.54762 .21288 L
s
.64286 .20913 m
.64286 .21288 L
s
.69048 .20913 m
.69048 .21288 L
s
.7381 .20913 m
.7381 .21288 L
s
.83333 .20913 m
.83333 .21288 L
s
.88095 .20913 m
.88095 .21288 L
s
.92857 .20913 m
.92857 .21288 L
s
.25 Mabswid
0 .20913 m
1 .20913 L
s
.02381 .03294 m
.03006 .03294 L
s
[(-0.5)] .01131 .03294 1 0 Mshowa
.02381 .12104 m
.03006 .12104 L
s
[(-0.25)] .01131 .12104 1 0 Mshowa
.02381 .29723 m
.03006 .29723 L
s
[(0.25)] .01131 .29723 1 0 Mshowa
.02381 .38532 m
.03006 .38532 L
s
[(0.5)] .01131 .38532 1 0 Mshowa
.02381 .47342 m
.03006 .47342 L
s
[(0.75)] .01131 .47342 1 0 Mshowa
.02381 .56152 m
.03006 .56152 L
s
[(1)] .01131 .56152 1 0 Mshowa
.125 Mabswid
.02381 .05056 m
.02756 .05056 L
s
.02381 .06818 m
.02756 .06818 L
s
.02381 .0858 m
.02756 .0858 L
s
.02381 .10342 m
.02756 .10342 L
s
.02381 .13866 m
.02756 .13866 L
s
.02381 .15627 m
.02756 .15627 L
s
.02381 .17389 m
.02756 .17389 L
s
.02381 .19151 m
.02756 .19151 L
s
.02381 .22675 m
.02756 .22675 L
s
.02381 .24437 m
.02756 .24437 L
s
.02381 .26199 m
.02756 .26199 L
s
.02381 .27961 m
.02756 .27961 L
s
.02381 .31485 m
.02756 .31485 L
s
.02381 .33247 m
.02756 .33247 L
s
.02381 .35009 m
.02756 .35009 L
s
.02381 .36771 m
.02756 .36771 L
s
.02381 .40294 m
.02756 .40294 L
s
.02381 .42056 m
.02756 .42056 L
s
.02381 .43818 m
.02756 .43818 L
s
.02381 .4558 m
.02756 .4558 L
s
.02381 .49104 m
.02756 .49104 L
s
.02381 .50866 m
.02756 .50866 L
s
.02381 .52628 m
.02756 .52628 L
s
.02381 .5439 m
.02756 .5439 L
s
.02381 .01532 m
.02756 .01532 L
s
.02381 .57914 m
.02756 .57914 L
s
.02381 .59676 m
.02756 .59676 L
s
.02381 .61437 m
.02756 .61437 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .56152 m
.02846 .57669 L
.03279 .58741 L
.03523 .59213 L
.03754 .59577 L
.0402 .59903 L
.04135 .60014 L
.04262 .60116 L
.04377 .60192 L
.04502 .60254 L
.04633 .603 L
.04756 .60325 L
.04878 .60332 L
.04994 .60323 L
.05099 .60303 L
.05212 .60268 L
.05348 .60209 L
.05472 .6014 L
.05748 .5993 L
.06003 .59674 L
.06244 .59382 L
.07299 .57577 L
.08269 .55287 L
.10458 .48565 L
.14407 .33882 L
.18204 .20035 L
.20318 .1344 L
.22246 .08492 L
.23203 .06481 L
.24244 .0466 L
.25228 .03308 L
.26137 .02386 L
.266 .02039 L
.26844 .0189 L
.271 .01758 L
.27325 .01663 L
.27571 .0158 L
.2768 .01552 L
.27795 .01526 L
.27896 .01507 L
.28004 .01492 L
.2807 .01485 L
.28142 .01478 L
.2827 .01472 L
.28342 .01472 L
.28419 .01473 L
.28492 .01476 L
.28559 .01481 L
.28688 .01494 L
.2876 .01505 L
Mistroke
.28828 .01516 L
.29083 .01574 L
.29332 .01652 L
.29558 .01742 L
.30064 .02006 L
.30553 .0234 L
.31069 .02773 L
.31992 .03737 L
.34076 .06637 L
.37878 .1327 L
.39997 .16927 L
.41926 .19861 L
.43951 .22362 L
.45822 .24075 L
.4675 .24708 L
.47734 .25228 L
.4821 .25426 L
.48722 .256 L
.49284 .25748 L
.49539 .25801 L
.49812 .25848 L
.50072 .25883 L
.50309 .25908 L
.50423 .25917 L
.50547 .25926 L
.50664 .25932 L
.50771 .25936 L
.50897 .25939 L
.51014 .25941 L
.51143 .2594 L
.51215 .25939 L
.51281 .25938 L
.5135 .25936 L
.51413 .25934 L
.51557 .25927 L
.51684 .25919 L
.5182 .25908 L
.52068 .25884 L
.52337 .25852 L
.52823 .25775 L
.53401 .25655 L
.53931 .25522 L
.55821 .24893 L
.5789 .24014 L
.61943 .22119 L
.65844 .20566 L
.66867 .20251 L
.67976 .19959 L
.68935 .19751 L
.69991 .19569 L
Mistroke
.70485 .19501 L
.71016 .19439 L
.71475 .19396 L
.71976 .19358 L
.72268 .19341 L
.72539 .19328 L
.72798 .19319 L
.72931 .19315 L
.73075 .19311 L
.73216 .19309 L
.73346 .19307 L
.7347 .19306 L
.73602 .19305 L
.73719 .19305 L
.73829 .19305 L
.7395 .19306 L
.74079 .19307 L
.74201 .19309 L
.74336 .19312 L
.74608 .19319 L
.74861 .19328 L
.75098 .19338 L
.75631 .19367 L
.76205 .19406 L
.77255 .195 L
.78217 .19605 L
.82182 .20159 L
.85995 .20711 L
.88121 .20968 L
.90053 .21152 L
.91017 .21224 L
.92063 .21288 L
.9305 .21334 L
.93488 .21351 L
.93959 .21365 L
.9443 .21377 L
.9486 .21385 L
.95067 .21388 L
.95292 .21391 L
.95504 .21393 L
.95702 .21395 L
.95824 .21395 L
.95955 .21396 L
.96075 .21396 L
.96184 .21397 L
.96304 .21397 L
.96434 .21397 L
.965 .21396 L
.9657 .21396 L
.96697 .21396 L
Mistroke
.96816 .21395 L
.96945 .21394 L
.9718 .21393 L
.97619 .21388 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  "This generates a parametric plot using both ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.23"}],

Cell[CellGroupData[{

Cell["\<\
ParametricPlot[Evaluate[{x[t], y[t]} /. sol], {t, 0, 10}, PlotRange \
-> All]\
\>", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.9.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.337836 0.638355 0.209132 0.352385 [
[.08249 .19663 -12 -9 ]
[.08249 .19663 12 0 ]
[.21017 .19663 -12 -9 ]
[.21017 .19663 12 0 ]
[.46551 .19663 -9 -9 ]
[.46551 .19663 9 0 ]
[.59318 .19663 -9 -9 ]
[.59318 .19663 9 0 ]
[.72085 .19663 -9 -9 ]
[.72085 .19663 9 0 ]
[.84852 .19663 -9 -9 ]
[.84852 .19663 9 0 ]
[.97619 .19663 -3 -9 ]
[.97619 .19663 3 0 ]
[.32534 .03294 -24 -4.5 ]
[.32534 .03294 0 4.5 ]
[.32534 .12104 -30 -4.5 ]
[.32534 .12104 0 4.5 ]
[.32534 .29723 -24 -4.5 ]
[.32534 .29723 0 4.5 ]
[.32534 .38532 -18 -4.5 ]
[.32534 .38532 0 4.5 ]
[.32534 .47342 -24 -4.5 ]
[.32534 .47342 0 4.5 ]
[.32534 .56152 -6 -4.5 ]
[.32534 .56152 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08249 .20913 m
.08249 .21538 L
s
[(-0.4)] .08249 .19663 0 1 Mshowa
.21017 .20913 m
.21017 .21538 L
s
[(-0.2)] .21017 .19663 0 1 Mshowa
.46551 .20913 m
.46551 .21538 L
s
[(0.2)] .46551 .19663 0 1 Mshowa
.59318 .20913 m
.59318 .21538 L
s
[(0.4)] .59318 .19663 0 1 Mshowa
.72085 .20913 m
.72085 .21538 L
s
[(0.6)] .72085 .19663 0 1 Mshowa
.84852 .20913 m
.84852 .21538 L
s
[(0.8)] .84852 .19663 0 1 Mshowa
.97619 .20913 m
.97619 .21538 L
s
[(1)] .97619 .19663 0 1 Mshowa
.125 Mabswid
.11441 .20913 m
.11441 .21288 L
s
.14633 .20913 m
.14633 .21288 L
s
.17825 .20913 m
.17825 .21288 L
s
.24208 .20913 m
.24208 .21288 L
s
.274 .20913 m
.274 .21288 L
s
.30592 .20913 m
.30592 .21288 L
s
.36975 .20913 m
.36975 .21288 L
s
.40167 .20913 m
.40167 .21288 L
s
.43359 .20913 m
.43359 .21288 L
s
.49742 .20913 m
.49742 .21288 L
s
.52934 .20913 m
.52934 .21288 L
s
.56126 .20913 m
.56126 .21288 L
s
.6251 .20913 m
.6251 .21288 L
s
.65701 .20913 m
.65701 .21288 L
s
.68893 .20913 m
.68893 .21288 L
s
.75277 .20913 m
.75277 .21288 L
s
.78468 .20913 m
.78468 .21288 L
s
.8166 .20913 m
.8166 .21288 L
s
.88044 .20913 m
.88044 .21288 L
s
.91236 .20913 m
.91236 .21288 L
s
.94427 .20913 m
.94427 .21288 L
s
.05058 .20913 m
.05058 .21288 L
s
.01866 .20913 m
.01866 .21288 L
s
.25 Mabswid
0 .20913 m
1 .20913 L
s
.33784 .03294 m
.34409 .03294 L
s
[(-0.5)] .32534 .03294 1 0 Mshowa
.33784 .12104 m
.34409 .12104 L
s
[(-0.25)] .32534 .12104 1 0 Mshowa
.33784 .29723 m
.34409 .29723 L
s
[(0.25)] .32534 .29723 1 0 Mshowa
.33784 .38532 m
.34409 .38532 L
s
[(0.5)] .32534 .38532 1 0 Mshowa
.33784 .47342 m
.34409 .47342 L
s
[(0.75)] .32534 .47342 1 0 Mshowa
.33784 .56152 m
.34409 .56152 L
s
[(1)] .32534 .56152 1 0 Mshowa
.125 Mabswid
.33784 .05056 m
.34159 .05056 L
s
.33784 .06818 m
.34159 .06818 L
s
.33784 .0858 m
.34159 .0858 L
s
.33784 .10342 m
.34159 .10342 L
s
.33784 .13866 m
.34159 .13866 L
s
.33784 .15627 m
.34159 .15627 L
s
.33784 .17389 m
.34159 .17389 L
s
.33784 .19151 m
.34159 .19151 L
s
.33784 .22675 m
.34159 .22675 L
s
.33784 .24437 m
.34159 .24437 L
s
.33784 .26199 m
.34159 .26199 L
s
.33784 .27961 m
.34159 .27961 L
s
.33784 .31485 m
.34159 .31485 L
s
.33784 .33247 m
.34159 .33247 L
s
.33784 .35009 m
.34159 .35009 L
s
.33784 .36771 m
.34159 .36771 L
s
.33784 .40294 m
.34159 .40294 L
s
.33784 .42056 m
.34159 .42056 L
s
.33784 .43818 m
.34159 .43818 L
s
.33784 .4558 m
.34159 .4558 L
s
.33784 .49104 m
.34159 .49104 L
s
.33784 .50866 m
.34159 .50866 L
s
.33784 .52628 m
.34159 .52628 L
s
.33784 .5439 m
.34159 .5439 L
s
.33784 .01532 m
.34159 .01532 L
s
.33784 .57914 m
.34159 .57914 L
s
.33784 .59676 m
.34159 .59676 L
s
.33784 .61437 m
.34159 .61437 L
s
.25 Mabswid
.33784 0 m
.33784 .61803 L
s
.5 Mabswid
.97619 .56152 m
.91607 .57669 L
.86365 .58741 L
.80963 .59577 L
.78082 .59903 L
.75544 .60116 L
.7428 .60196 L
.72961 .6026 L
.71851 .60299 L
.70645 .60324 L
.69371 .60332 L
.68664 .60328 L
.68022 .60319 L
.66792 .60288 L
.6564 .60241 L
.64589 .60184 L
.63483 .60108 L
.61532 .59936 L
.59274 .59672 L
.57281 .59382 L
.52944 .58553 L
.49166 .57602 L
.41326 .549 L
.35131 .52007 L
.2925 .48565 L
.19922 .41451 L
.13046 .34461 L
.09887 .30484 L
.07401 .26792 L
.05601 .23603 L
.04072 .2023 L
.03513 .18686 L
.03035 .17073 L
.02827 .1621 L
.02671 .15435 L
.02547 .14664 L
.02499 .14294 L
.02462 .13962 L
.02436 .13675 L
.02413 .13367 L
.02396 .13045 L
.02385 .12744 L
.02381 .12416 L
.02384 .12074 L
.02394 .11785 L
.02411 .11471 L
.02437 .11148 L
.02467 .10857 L
.02559 .10216 L
.02675 .0964 L
Mistroke
.0281 .09109 L
.03212 .07965 L
.03688 .07003 L
.04366 .05982 L
.05128 .05113 L
.06772 .03787 L
.0785 .0317 L
.0893 .02687 L
.10127 .02274 L
.10819 .02084 L
.11495 .01927 L
.12141 .01802 L
.12861 .0169 L
.1353 .01608 L
.1416 .01549 L
.14523 .01523 L
.14918 .01501 L
.15294 .01486 L
.15641 .01477 L
.1603 .01472 L
.16251 .01472 L
.16457 .01473 L
.16876 .0148 L
.17112 .01487 L
.17327 .01495 L
.17773 .01516 L
.18186 .01542 L
.19126 .01621 L
.19962 .01714 L
.2085 .01835 L
.22513 .02125 L
.2403 .02458 L
.27395 .03427 L
.30387 .04568 L
.33048 .05829 L
.35675 .07347 L
.38134 .09088 L
.41583 .12377 L
.42842 .1405 L
.43373 .14914 L
.43838 .15806 L
.44168 .1657 L
.4445 .17384 L
.44548 .17733 L
.44636 .181 L
.44699 .18409 L
.44753 .18743 L
.44778 .18929 L
.44799 .19126 L
.44809 .19234 L
Mistroke
.44816 .19332 L
.44822 .19431 L
.44827 .19522 L
.44833 .19692 L
.44835 .19876 L
.44832 .20036 L
.44826 .20204 L
.44821 .20305 L
.44814 .20398 L
.44795 .20604 L
.44774 .20782 L
.44746 .20967 L
.44687 .2128 L
.44605 .21612 L
.44415 .22186 L
.44157 .22754 L
.43867 .23246 L
.43568 .23656 L
.43226 .24044 L
.42831 .24414 L
.42056 .2497 L
.41596 .25221 L
.4115 .25421 L
.40647 .256 L
.40095 .25749 L
.39858 .25799 L
.39604 .25843 L
.39383 .25875 L
.39144 .25902 L
.38998 .25915 L
.38863 .25924 L
.38734 .25932 L
.38668 .25934 L
.38598 .25937 L
.38476 .2594 L
.38362 .25941 L
.38293 .25941 L
.38227 .2594 L
.38104 .25938 L
.38036 .25936 L
.37973 .25933 L
.37854 .25927 L
.37727 .25919 L
.3759 .25909 L
.37344 .25884 L
.37121 .25856 L
.36613 .25772 L
.3609 .25655 L
.35249 .25401 L
.3441 .25062 L
Mistroke
.33087 .24319 L
.32468 .23859 L
.31896 .23339 L
.31489 .22885 L
.31132 .2239 L
.30877 .21926 L
.30785 .21711 L
.30716 .21512 L
.30686 .21407 L
.30658 .21295 L
.30638 .21194 L
.30624 .21104 L
.30618 .21054 L
.30613 .21 L
.3061 .20971 L
.30608 .20944 L
.30607 .20917 L
.30606 .20892 L
.30605 .20847 L
.30605 .20824 L
.30605 .20799 L
.30606 .20774 L
.30606 .20749 L
.30609 .20705 L
.30612 .20665 L
.30616 .20624 L
.30626 .2055 L
.30642 .20465 L
.30661 .20389 L
.3071 .20241 L
.30776 .20097 L
.30845 .19982 L
.30919 .19883 L
.31114 .19688 L
.3123 .19603 L
.31365 .19522 L
.31491 .19463 L
.3163 .1941 L
.3176 .19372 L
.31831 .19356 L
.31907 .19341 L
.31978 .19329 L
.32043 .19321 L
.32109 .19314 L
.32172 .19309 L
.3221 .19307 L
.3223 .19307 L
.32251 .19306 L
.32289 .19305 L
.32325 .19305 L
Mistroke
.32359 .19305 L
.3239 .19305 L
.32425 .19307 L
.32463 .19308 L
.32503 .19311 L
.32546 .19314 L
.32624 .19321 L
.3277 .19341 L
.32907 .19366 L
.3305 .19399 L
.33298 .19474 L
.33546 .19572 L
.33793 .19695 L
.34173 .19949 L
.34336 .20091 L
.34483 .20249 L
.34603 .20413 L
.34684 .2056 L
.34714 .20631 L
.34739 .20705 L
.34748 .20738 L
.34755 .20772 L
.3476 .20801 L
.34763 .20817 L
.34765 .20832 L
.34766 .20846 L
.34767 .20861 L
.34768 .20874 L
.34769 .20886 L
.34769 .20898 L
.34769 .2091 L
.34769 .20923 L
.34768 .20935 L
.34767 .20949 L
.34766 .20962 L
.34763 .20986 L
.34759 .21012 L
.34753 .21038 L
.34737 .21089 L
.34717 .21133 L
.34696 .2117 L
.3467 .21206 L
.34638 .21242 L
.34601 .21276 L
.34563 .21304 L
.34526 .21326 L
.34489 .21344 L
.34448 .2136 L
.34402 .21374 L
.34379 .2138 L
Mistroke
.34358 .21384 L
.34338 .21388 L
.34317 .21391 L
.34294 .21393 L
.34283 .21394 L
.34272 .21395 L
.34262 .21396 L
.34251 .21396 L
.3424 .21396 L
.34229 .21397 L
.34219 .21397 L
.34209 .21397 L
.342 .21396 L
.34191 .21396 L
.3418 .21396 L
.3417 .21395 L
.34147 .21393 L
.34124 .21391 L
.34101 .21388 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  "Unknown functions in differential equations do not necessarily have to be \
represented by single symbols. If you have a large number of unknown \
functions, you will often find it more convenient, for example, to give the \
functions names like ",
  StyleBox["y", "TI"],
  StyleBox["[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.9.7", "7.24"}],

Cell["\<\
This constructs a set of five coupled differential equations and \
initial conditions. \
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.25"}],

Cell[CellGroupData[{

Cell["\<\
eqns = Join[ Table[ y[i]'[x] == y[i-1][x] - y[i][x], {i, 2, 4} ], \
{y[1]'[x] == -y[1][x], y[5]'[x] == y[4][x], y[1][0] == 1}, Table[ y[i][0] == \
0, {i, 2, 5}] ]\
\>", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox[\(y[2]\), "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "\[Equal]", \(\(y[1]\)[x] - \(y[2]\)[x]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox[\(y[3]\), "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "\[Equal]", \(\(y[2]\)[x] - \(y[3]\)[x]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox[\(y[4]\), "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "\[Equal]", \(\(y[3]\)[x] - \(y[4]\)[x]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox[\(y[1]\), "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "\[Equal]", \(-\(y[1]\)[x]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox[\(y[5]\), "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "\[Equal]", \(\(y[4]\)[x]\)}], ",", \(\(y[1]\)[0] \[Equal] 1\), 
        ",", \(\(y[2]\)[0] \[Equal] 0\), ",", \(\(y[3]\)[0] \[Equal] 0\), 
        ",", \(\(y[4]\)[0] \[Equal] 0\), ",", \(\(y[5]\)[0] \[Equal] 0\)}], 
      "}"}]], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell["This solves the equations. ", "MathCaption",
  CellTags->{"S3.9.7", "7.26"}],

Cell[CellGroupData[{

Cell["NDSolve[eqns, Table[y[i], {i, 5}], {x, 10}]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(y[1]\), "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 10.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{\(y[2]\), "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 10.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{\(y[3]\), "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 10.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{\(y[4]\), "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 10.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{\(y[5]\), "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 10.`}}, "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell["Here is a plot of the solutions. ", "MathCaption",
  CellTags->{"S3.9.7", "7.27"}],

Cell[CellGroupData[{

Cell["Plot[ Evaluate[Table[y[i][x], {i, 5}] /. %], {x, 0, 10} ]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.9.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0147151 0.588604 [
[.21429 .00222 -3 -9 ]
[.21429 .00222 3 0 ]
[.40476 .00222 -3 -9 ]
[.40476 .00222 3 0 ]
[.59524 .00222 -3 -9 ]
[.59524 .00222 3 0 ]
[.78571 .00222 -3 -9 ]
[.78571 .00222 3 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .13244 -18 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -18 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -18 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -18 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(10)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13244 m
.03006 .13244 L
s
[(0.2)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(0.4)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(0.6)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(0.8)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .16187 m
.02756 .16187 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.04262 .49784 L
.06244 .40704 L
.08426 .32673 L
.10458 .26677 L
.14264 .18374 L
.16305 .15113 L
.18163 .12696 L
.20239 .10497 L
.22156 .08852 L
.25997 .06402 L
.2787 .05522 L
.29932 .04733 L
.32036 .04087 L
.33961 .03608 L
.37838 .02894 L
.39737 .02637 L
.41809 .02409 L
.43941 .02221 L
.45874 .02083 L
.49787 .01877 L
.51711 .01803 L
.53793 .01738 L
.55748 .01688 L
.57894 .01645 L
.61842 .01586 L
.63793 .01565 L
.65885 .01546 L
.67866 .01532 L
.70021 .0152 L
.74005 .01503 L
.75983 .01497 L
.78084 .01492 L
.81859 .01485 L
.83793 .01483 L
.85879 .01481 L
.87844 .01479 L
.89993 .01477 L
.91909 .01476 L
.93955 .01475 L
.97619 .01474 L
s
.02381 .01472 m
.03279 .0652 L
.04262 .11012 L
.05288 .14713 L
.06244 .17387 L
.0731 .19628 L
.0828 .21096 L
.08817 .21708 L
.094 .22231 L
.0995 .22601 L
.10215 .22741 L
.10458 .22848 L
.10681 .2293 L
.10924 .23002 L
.11057 .23034 L
.11181 .23059 L
.11306 .2308 L
.11425 .23097 L
.11535 .23108 L
.11655 .23117 L
.11763 .23123 L
.11863 .23125 L
.11972 .23125 L
.1209 .23121 L
.12215 .23114 L
.12331 .23104 L
.12459 .2309 L
.12598 .2307 L
.12851 .23025 L
.13326 .22907 L
.1388 .22719 L
.14393 .22503 L
.1626 .21446 L
.1832 .19949 L
.2234 .16642 L
.26209 .13536 L
.30323 .10657 L
.34285 .0839 L
.38096 .06662 L
.42152 .05247 L
.46057 .04223 L
.50206 .0342 L
.54205 .02859 L
.58051 .02467 L
.62143 .02167 L
.66083 .01962 L
.69872 .0182 L
.7198 .0176 L
.73906 .01714 L
.77789 .01641 L
Mistroke
.79691 .01614 L
.81765 .01589 L
.839 .01568 L
.85834 .01552 L
.89753 .01528 L
.91681 .01518 L
.93764 .0151 L
.97619 .01498 L
Mfstroke
.02381 .01472 m
.02499 .01476 L
.02605 .01487 L
.02729 .01509 L
.02846 .01538 L
.03053 .01608 L
.03279 .01709 L
.0379 .02027 L
.04262 .02414 L
.06244 .047 L
.10458 .10536 L
.1249 .12942 L
.14393 .14735 L
.16216 .16001 L
.1724 .16522 L
.18177 .16887 L
.18653 .17032 L
.19161 .1716 L
.1964 .17254 L
.20075 .17319 L
.20342 .17349 L
.20588 .17371 L
.20857 .17389 L
.20993 .17395 L
.2107 .17398 L
.21142 .174 L
.21273 .17402 L
.21393 .17403 L
.21522 .17403 L
.21595 .17402 L
.21662 .17401 L
.21774 .17398 L
.21897 .17394 L
.22026 .17388 L
.22147 .17381 L
.22391 .17364 L
.22617 .17344 L
.23131 .17284 L
.23631 .17207 L
.24166 .17106 L
.26016 .16625 L
.28151 .15868 L
.30166 .15016 L
.34013 .13193 L
.38104 .112 L
.42045 .09401 L
.45833 .07865 L
.49867 .06471 L
.5375 .05363 L
.57878 .04416 L
Mistroke
.61854 .03699 L
.65678 .0316 L
.69748 .02719 L
.73666 .02397 L
.7783 .02141 L
.81841 .01959 L
.85702 .01829 L
.89807 .01727 L
.93761 .01656 L
.97564 .01606 L
.97619 .01605 L
Mfstroke
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01473 L
.02954 .01474 L
.03053 .01475 L
.03163 .01477 L
.03279 .01479 L
.03395 .01482 L
.0352 .01486 L
.03746 .01497 L
.04016 .01513 L
.04262 .01534 L
.04748 .01589 L
.05023 .0163 L
.05278 .01675 L
.06244 .01908 L
.06795 .02086 L
.07314 .02284 L
.08284 .02728 L
.10458 .04034 L
.14313 .06983 L
.18413 .10164 L
.20456 .11523 L
.22362 .12587 L
.24195 .13403 L
.26159 .14045 L
.27177 .14285 L
.27713 .14386 L
.28283 .14476 L
.2878 .14539 L
.29328 .14592 L
.29568 .14611 L
.29827 .14627 L
.30071 .1464 L
.30295 .14648 L
.30423 .14652 L
.30544 .14655 L
.30652 .14656 L
.30769 .14658 L
.30897 .14659 L
.30962 .14659 L
.31033 .14659 L
.31158 .14658 L
.31276 .14656 L
.31394 .14654 L
.31505 .14651 L
.31715 .14645 L
.31941 .14636 L
Mistroke
.32188 .14623 L
.32708 .14587 L
.33262 .14537 L
.34258 .14415 L
.35289 .14251 L
.36403 .14034 L
.38421 .13553 L
.42527 .12323 L
.46481 .10968 L
.50283 .09636 L
.54331 .0828 L
.58227 .0709 L
.62368 .05979 L
.66358 .05068 L
.70196 .04334 L
.7428 .03694 L
.78211 .03197 L
.81992 .02814 L
.86017 .02491 L
.89891 .02249 L
.9401 .02051 L
.97619 .01917 L
Mfstroke
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01472 L
.02954 .01472 L
.03053 .01472 L
.03163 .01472 L
.03279 .01472 L
.03395 .01472 L
.0352 .01472 L
.03638 .01472 L
.03746 .01472 L
.03873 .01473 L
.04011 .01473 L
.04262 .01475 L
.04396 .01476 L
.04523 .01477 L
.04759 .01479 L
.05014 .01483 L
.0529 .01488 L
.05532 .01494 L
.05787 .01502 L
.06244 .0152 L
.06746 .01547 L
.07283 .01586 L
.07791 .01634 L
.08253 .01689 L
.08795 .01768 L
.09385 .01873 L
.10458 .02122 L
.11398 .02407 L
.12435 .02802 L
.14536 .03871 L
.16471 .05185 L
.18557 .06943 L
.2267 .11309 L
.26633 .16328 L
.30444 .21531 L
.345 .27112 L
.38404 .32251 L
.42554 .37256 L
.46552 .41523 L
.50399 .45076 L
.54491 .48269 L
.58431 .50812 L
.6222 .52817 L
.66254 .5454 L
.70136 .55859 L
.74264 .56958 L
Mistroke
.7824 .57778 L
.82065 .58389 L
.86134 .58888 L
.90052 .59252 L
.94216 .59543 L
.97619 .59724 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " can handle functions whose values are lists or arrays. If you give \
initial conditions like ",
  StyleBox["y", "TI"],
  StyleBox["[0]", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["v",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["v",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["v",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}", "MR"],
  ", then ",
  StyleBox["NDSolve", "MR"],
  " will assume that ",
  StyleBox["y", "TI"],
  " is a function whose values are lists of length ",
  StyleBox["n", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.9.7", "7.28"}],

Cell["\<\
This solves a system of four coupled differential equations. \
\>", \
"MathCaption",
  CellTags->{"S3.9.7", "7.29"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[{y''[x] == -Table[Random[], {4}, {4}] . y[x], y[0] == y'[0] \
== Table[1, {4}]}, y, {x, 0, 8}]\
\>", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 8.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell["Here are the solutions. ", "MathCaption",
  CellTags->{"S3.9.7", "7.30"}],

Cell[CellGroupData[{

Cell["\<\
With[{s = y[x] /. First[%]}, Plot[{s[[1]], s[[2]], s[[3]], s[[4]]}, \
{x, 0, 8}, PlotRange -> All]]\
\>", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.9.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.119048 0.308316 0.0392867 [
[.2619 .29582 -3 -9 ]
[.2619 .29582 3 0 ]
[.5 .29582 -3 -9 ]
[.5 .29582 3 0 ]
[.7381 .29582 -3 -9 ]
[.7381 .29582 3 0 ]
[.97619 .29582 -3 -9 ]
[.97619 .29582 3 0 ]
[.01131 .0726 -12 -4.5 ]
[.01131 .0726 0 4.5 ]
[.01131 .15117 -12 -4.5 ]
[.01131 .15117 0 4.5 ]
[.01131 .22974 -12 -4.5 ]
[.01131 .22974 0 4.5 ]
[.01131 .38689 -6 -4.5 ]
[.01131 .38689 0 4.5 ]
[.01131 .46546 -6 -4.5 ]
[.01131 .46546 0 4.5 ]
[.01131 .54404 -6 -4.5 ]
[.01131 .54404 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .30832 m
.2619 .31457 L
s
[(2)] .2619 .29582 0 1 Mshowa
.5 .30832 m
.5 .31457 L
s
[(4)] .5 .29582 0 1 Mshowa
.7381 .30832 m
.7381 .31457 L
s
[(6)] .7381 .29582 0 1 Mshowa
.97619 .30832 m
.97619 .31457 L
s
[(8)] .97619 .29582 0 1 Mshowa
.125 Mabswid
.08333 .30832 m
.08333 .31207 L
s
.14286 .30832 m
.14286 .31207 L
s
.20238 .30832 m
.20238 .31207 L
s
.32143 .30832 m
.32143 .31207 L
s
.38095 .30832 m
.38095 .31207 L
s
.44048 .30832 m
.44048 .31207 L
s
.55952 .30832 m
.55952 .31207 L
s
.61905 .30832 m
.61905 .31207 L
s
.67857 .30832 m
.67857 .31207 L
s
.79762 .30832 m
.79762 .31207 L
s
.85714 .30832 m
.85714 .31207 L
s
.91667 .30832 m
.91667 .31207 L
s
.25 Mabswid
0 .30832 m
1 .30832 L
s
.02381 .0726 m
.03006 .0726 L
s
[(-6)] .01131 .0726 1 0 Mshowa
.02381 .15117 m
.03006 .15117 L
s
[(-4)] .01131 .15117 1 0 Mshowa
.02381 .22974 m
.03006 .22974 L
s
[(-2)] .01131 .22974 1 0 Mshowa
.02381 .38689 m
.03006 .38689 L
s
[(2)] .01131 .38689 1 0 Mshowa
.02381 .46546 m
.03006 .46546 L
s
[(4)] .01131 .46546 1 0 Mshowa
.02381 .54404 m
.03006 .54404 L
s
[(6)] .01131 .54404 1 0 Mshowa
.125 Mabswid
.02381 .09224 m
.02756 .09224 L
s
.02381 .11188 m
.02756 .11188 L
s
.02381 .13153 m
.02756 .13153 L
s
.02381 .17081 m
.02756 .17081 L
s
.02381 .19046 m
.02756 .19046 L
s
.02381 .2101 m
.02756 .2101 L
s
.02381 .24939 m
.02756 .24939 L
s
.02381 .26903 m
.02756 .26903 L
s
.02381 .28867 m
.02756 .28867 L
s
.02381 .32796 m
.02756 .32796 L
s
.02381 .3476 m
.02756 .3476 L
s
.02381 .36725 m
.02756 .36725 L
s
.02381 .40653 m
.02756 .40653 L
s
.02381 .42618 m
.02756 .42618 L
s
.02381 .44582 m
.02756 .44582 L
s
.02381 .48511 m
.02756 .48511 L
s
.02381 .50475 m
.02756 .50475 L
s
.02381 .52439 m
.02756 .52439 L
s
.02381 .05295 m
.02756 .05295 L
s
.02381 .03331 m
.02756 .03331 L
s
.02381 .01367 m
.02756 .01367 L
s
.02381 .56368 m
.02756 .56368 L
s
.02381 .58332 m
.02756 .58332 L
s
.02381 .60297 m
.02756 .60297 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
.5 Mabswid
.02381 .3476 m
.03279 .35029 L
.04262 .3526 L
.04758 .35349 L
.05288 .35424 L
.05546 .35452 L
.05789 .35474 L
.06007 .3549 L
.06244 .35504 L
.0637 .35509 L
.0644 .35511 L
.06506 .35513 L
.06634 .35516 L
.06751 .35517 L
.06817 .35518 L
.06889 .35517 L
.07017 .35516 L
.07096 .35515 L
.0717 .35513 L
.07308 .35509 L
.07445 .35503 L
.0759 .35495 L
.07849 .35477 L
.08129 .35452 L
.08435 .35418 L
.0894 .35345 L
.09481 .35245 L
.10458 .3501 L
.11475 .34694 L
.12582 .34271 L
.14594 .33323 L
.18672 .30917 L
.22599 .2847 L
.26374 .26528 L
.28309 .25828 L
.29397 .25543 L
.29879 .25443 L
.30394 .25355 L
.30908 .25286 L
.31375 .25241 L
.316 .25224 L
.31718 .25217 L
.31844 .25211 L
.31954 .25206 L
.32074 .25202 L
.32184 .25199 L
.32287 .25197 L
.32415 .25196 L
.32487 .25196 L
.32554 .25196 L
Mistroke
.32677 .25198 L
.32808 .252 L
.32937 .25204 L
.33058 .25208 L
.33285 .2522 L
.33553 .25238 L
.338 .25259 L
.34357 .25322 L
.34828 .25393 L
.35333 .25484 L
.36243 .2569 L
.38311 .26333 L
.42452 .28132 L
.46442 .30018 L
.48267 .30761 L
.49306 .31121 L
.5028 .31406 L
.51234 .31629 L
.51725 .31722 L
.52261 .31803 L
.52796 .31865 L
.53088 .31889 L
.53227 .31899 L
.53359 .31907 L
.53481 .31913 L
.53613 .31918 L
.53734 .31921 L
.53845 .31924 L
.53965 .31925 L
.54097 .31926 L
.54163 .31925 L
.54235 .31924 L
.54363 .31922 L
.54485 .31919 L
.54619 .31914 L
.54891 .31899 L
.55143 .3188 L
.55379 .31858 L
.55911 .31792 L
.56485 .31696 L
.57534 .31454 L
.58496 .31157 L
.60386 .30376 L
.62455 .29255 L
.66508 .26485 L
.7041 .23587 L
.72398 .22224 L
.74556 .20954 L
.75565 .2046 L
.76634 .20018 L
Mistroke
.77546 .19713 L
.78551 .19461 L
.79071 .19367 L
.79328 .19329 L
.79566 .193 L
.79798 .19277 L
.80009 .1926 L
.80122 .19253 L
.80244 .19246 L
.80372 .19241 L
.80494 .19238 L
.80624 .19235 L
.80746 .19235 L
.80816 .19235 L
.80879 .19236 L
.80953 .19237 L
.81023 .19239 L
.81162 .19244 L
.8129 .19251 L
.81581 .19271 L
.81812 .19293 L
.82067 .19323 L
.82582 .19405 L
.83074 .19507 L
.83592 .1964 L
.84518 .19944 L
.85515 .20364 L
.86604 .2093 L
.88567 .22215 L
.90662 .23931 L
.94814 .2818 L
.97619 .31528 L
Mfstroke
.02381 .3476 m
.03279 .35033 L
.04262 .35277 L
.04758 .35377 L
.05288 .35466 L
.05785 .35533 L
.06244 .35581 L
.06508 .35602 L
.06788 .35619 L
.06933 .35625 L
.07069 .3563 L
.07218 .35634 L
.07302 .35636 L
.07379 .35637 L
.07445 .35638 L
.07515 .35638 L
.07641 .35638 L
.07719 .35637 L
.07792 .35636 L
.07857 .35635 L
.07928 .35634 L
.08061 .3563 L
.082 .35624 L
.08451 .35612 L
.0869 .35596 L
.08946 .35574 L
.09408 .35525 L
.09957 .35449 L
.10458 .35363 L
.12366 .34902 L
.14443 .3419 L
.18521 .3238 L
.22447 .30545 L
.24417 .29754 L
.26222 .29171 L
.27165 .28934 L
.28157 .2874 L
.28673 .28664 L
.29153 .28608 L
.29424 .28583 L
.2968 .28564 L
.29821 .28555 L
.29975 .28547 L
.30115 .28541 L
.30243 .28537 L
.30364 .28535 L
.30478 .28533 L
.306 .28532 L
.30732 .28532 L
.30847 .28533 L
Mistroke
.30969 .28535 L
.31085 .28538 L
.31189 .28542 L
.31447 .28554 L
.31726 .28572 L
.3223 .28618 L
.32764 .28686 L
.33327 .28779 L
.34335 .28999 L
.35285 .29267 L
.36302 .29617 L
.38137 .30395 L
.42278 .32681 L
.46268 .35175 L
.50106 .37368 L
.52049 .38272 L
.5308 .38678 L
.5419 .3905 L
.55249 .39342 L
.56219 .39552 L
.57146 .39703 L
.57612 .3976 L
.58122 .39809 L
.58376 .39828 L
.58652 .39845 L
.58912 .39857 L
.59036 .39861 L
.59152 .39865 L
.59265 .39868 L
.59368 .3987 L
.59483 .39871 L
.59606 .39872 L
.59724 .39872 L
.59853 .39871 L
.59974 .3987 L
.60086 .39868 L
.60206 .39865 L
.60335 .39862 L
.60569 .39853 L
.60847 .39839 L
.61103 .39824 L
.61629 .39784 L
.62183 .39729 L
.63136 .39609 L
.64155 .3945 L
.6599 .39108 L
.67979 .38706 L
.70137 .38305 L
.71146 .38153 L
.71698 .38084 L
Mistroke
.72215 .38029 L
.72691 .37989 L
.73127 .37961 L
.73376 .37949 L
.73611 .3794 L
.73741 .37937 L
.7386 .37934 L
.73992 .37932 L
.74065 .37932 L
.74132 .37931 L
.74252 .37931 L
.74365 .37932 L
.74488 .37934 L
.7462 .37936 L
.74759 .3794 L
.7489 .37945 L
.75135 .37956 L
.75365 .3797 L
.75577 .37986 L
.76058 .38032 L
.76538 .38092 L
.77068 .38176 L
.78141 .38405 L
.79151 .38693 L
.80077 .3902 L
.82163 .39978 L
.86127 .42566 L
.8994 .4572 L
.93998 .49218 L
.97619 .51848 L
Mfstroke
.02381 .3476 m
.03279 .35032 L
.04262 .35272 L
.04758 .35369 L
.05288 .35454 L
.05789 .35517 L
.06244 .35559 L
.06507 .35577 L
.0665 .35584 L
.06785 .3559 L
.06899 .35594 L
.07022 .35597 L
.07092 .35599 L
.07158 .356 L
.07283 .35601 L
.07354 .35601 L
.07418 .35601 L
.07493 .356 L
.07563 .35599 L
.07687 .35597 L
.07757 .35595 L
.07822 .35593 L
.08108 .3558 L
.08252 .35571 L
.0841 .3556 L
.08922 .35513 L
.09469 .35443 L
.10458 .35266 L
.11475 .35021 L
.12582 .34685 L
.14594 .33918 L
.18672 .31958 L
.22599 .30009 L
.24568 .29177 L
.26374 .2857 L
.27316 .28324 L
.28309 .28126 L
.28825 .28048 L
.29305 .27991 L
.29576 .27967 L
.29832 .27948 L
.29973 .27939 L
.30126 .27932 L
.30266 .27927 L
.30394 .27923 L
.3052 .2792 L
.30639 .27919 L
.30745 .27918 L
.30862 .27919 L
.30988 .27921 L
Mistroke
.31058 .27922 L
.31122 .27924 L
.31247 .27928 L
.31364 .27932 L
.31591 .27944 L
.318 .27958 L
.32271 .28002 L
.3275 .28062 L
.33275 .28147 L
.34335 .28375 L
.35358 .28666 L
.36289 .28988 L
.38382 .29885 L
.42372 .32065 L
.4621 .34318 L
.48153 .35346 L
.50294 .3629 L
.51271 .36635 L
.52323 .36936 L
.52807 .37049 L
.53316 .37149 L
.53784 .37223 L
.54225 .37278 L
.54466 .37302 L
.54727 .37322 L
.54842 .37329 L
.54964 .37336 L
.55078 .3734 L
.55183 .37344 L
.55304 .37347 L
.55434 .37349 L
.55555 .3735 L
.55669 .37349 L
.55733 .37349 L
.55802 .37347 L
.55925 .37344 L
.56057 .3734 L
.56204 .37333 L
.56441 .37318 L
.56659 .373 L
.57151 .37245 L
.57585 .37181 L
.58042 .37096 L
.58994 .36864 L
.60013 .36535 L
.61849 .35742 L
.63981 .34526 L
.65996 .33132 L
.69839 .30014 L
.73928 .26406 L
Mistroke
.77865 .22995 L
.8165 .19903 L
.85681 .1666 L
.8956 .13144 L
.91533 .10996 L
.93685 .08214 L
.97619 .01472 L
Mfstroke
.02381 .3476 m
.03279 .35026 L
.04262 .35245 L
.04758 .35325 L
.0503 .3536 L
.05288 .35387 L
.05528 .35408 L
.05655 .35417 L
.05789 .35424 L
.05902 .3543 L
.06026 .35434 L
.06139 .35437 L
.06244 .35439 L
.0631 .3544 L
.06379 .3544 L
.06504 .35439 L
.06581 .35438 L
.06653 .35437 L
.06718 .35435 L
.06788 .35433 L
.06919 .35428 L
.07057 .3542 L
.07305 .35403 L
.07544 .35381 L
.07767 .35356 L
.08274 .35284 L
.08826 .3518 L
.09328 .35062 L
.10458 .34722 L
.12366 .33924 L
.14443 .32783 L
.18521 .30013 L
.22447 .27248 L
.24417 .2604 L
.26222 .25126 L
.27146 .24745 L
.28157 .24406 L
.29173 .24151 L
.29727 .2405 L
.29995 .24011 L
.30243 .23981 L
.30483 .23957 L
.30748 .23936 L
.30885 .23928 L
.31014 .23922 L
.31149 .23917 L
.31225 .23915 L
.31295 .23914 L
.31422 .23913 L
.31539 .23913 L
Mistroke
.31668 .23915 L
.3174 .23916 L
.31805 .23918 L
.31924 .23923 L
.32054 .23929 L
.32288 .23944 L
.32513 .23964 L
.3276 .2399 L
.33257 .24061 L
.33718 .24146 L
.34147 .24242 L
.35195 .24543 L
.36186 .24912 L
.38043 .258 L
.41882 .28257 L
.45965 .31264 L
.47994 .32685 L
.49897 .33871 L
.5174 .34827 L
.53677 .35581 L
.54644 .35852 L
.55154 .35965 L
.55699 .36063 L
.56203 .36133 L
.56659 .36178 L
.5688 .36194 L
.56996 .36201 L
.57118 .36207 L
.57226 .36212 L
.57344 .36216 L
.57451 .36218 L
.57551 .3622 L
.57677 .36221 L
.5774 .36221 L
.5781 .3622 L
.57934 .36219 L
.58051 .36216 L
.58117 .36215 L
.58187 .36212 L
.58312 .36207 L
.58594 .36191 L
.58839 .36173 L
.59067 .36152 L
.59584 .3609 L
.6048 .35941 L
.61439 .35725 L
.63571 .35074 L
.65585 .34307 L
.69429 .32771 L
.71414 .32126 L
Mistroke
.72415 .3188 L
.72984 .31771 L
.73517 .31691 L
.73758 .31662 L
.74014 .31637 L
.74162 .31625 L
.74295 .31616 L
.74431 .31608 L
.74556 .31602 L
.74675 .31598 L
.74801 .31595 L
.74927 .31594 L
.74998 .31594 L
.75065 .31594 L
.75186 .31596 L
.75296 .31599 L
.75423 .31603 L
.75544 .31609 L
.75767 .31624 L
.76005 .31646 L
.76431 .31699 L
.7689 .31778 L
.77396 .31892 L
.78407 .32209 L
.79333 .32606 L
.80349 .33165 L
.81419 .33894 L
.83394 .35628 L
.85232 .37687 L
.89138 .43395 L
.9329 .51102 L
.9729 .59602 L
.97619 .60332 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["MaxSteps", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              "maximum number of steps in ",
              StyleBox["x", "TI"],
              " to take"
            }]]},
          {Cell[TextData[{
              StyleBox["StartingStepSize", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              "starting size of step in ",
              StyleBox["x", "TI"],
              " to use "
            }]]},
          {Cell[TextData[{
              StyleBox["MaxStepSize", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Infinity", "MR"],
              " "
            }]], Cell[TextData[{
              "maximum size of step in ",
              StyleBox["x", "TI"],
              " to use "
            }]]},
          {Cell[TextData[{
              StyleBox["NormFunction", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["the norm to use for error estimation "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S3.9.7"],

Cell[TextData[{
  "Special options for ",
  StyleBox["NDSolve", "MR"],
  ". "
}], "Caption",
  CellTags->"S3.9.7"],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " has many methods for solving equations, but essentially all of them at \
some level work by taking a sequence of steps in the independent variable ",
  StyleBox["x", "TI"],
  ", and using an adaptive procedure to determine the size of these steps. In \
general, if the solution appears to be varying rapidly in a particular \
region, then ",
  StyleBox["NDSolve", "MR"],
  " will reduce the step size or change the method so as to be able to track \
the solution better. "
}], "Text",
  CellTags->{"S3.9.7", "7.31"}],

Cell["\<\
This solves a differential equation in which the derivative has a \
discontinuity. \
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.32"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[ {y'[x] == If[x < 0, 1/(x-1), 1/(x+1)], y[-5] == 5}, y, {x, \
-5, 5}]\
\>", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{\(-5.`\), 5.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " reduced the step size around ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  " so as to reproduce the kink accurately. "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.33"}],

Cell[CellGroupData[{

Cell["Plot[Evaluate[y[x] /. %], {x, -5, 5}]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S3.9.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 -1.04353 0.329369 [
[.11905 .26145 -6 -9 ]
[.11905 .26145 6 0 ]
[.30952 .26145 -6 -9 ]
[.30952 .26145 6 0 ]
[.69048 .26145 -3 -9 ]
[.69048 .26145 3 0 ]
[.88095 .26145 -3 -9 ]
[.88095 .26145 3 0 ]
[.4875 .02692 -24 -4.5 ]
[.4875 .02692 0 4.5 ]
[.4875 .10926 -18 -4.5 ]
[.4875 .10926 0 4.5 ]
[.4875 .19161 -24 -4.5 ]
[.4875 .19161 0 4.5 ]
[.4875 .35629 -24 -4.5 ]
[.4875 .35629 0 4.5 ]
[.4875 .43863 -18 -4.5 ]
[.4875 .43863 0 4.5 ]
[.4875 .52098 -24 -4.5 ]
[.4875 .52098 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .27395 m
.11905 .2802 L
s
[(-4)] .11905 .26145 0 1 Mshowa
.30952 .27395 m
.30952 .2802 L
s
[(-2)] .30952 .26145 0 1 Mshowa
.69048 .27395 m
.69048 .2802 L
s
[(2)] .69048 .26145 0 1 Mshowa
.88095 .27395 m
.88095 .2802 L
s
[(4)] .88095 .26145 0 1 Mshowa
.125 Mabswid
.16667 .27395 m
.16667 .2777 L
s
.21429 .27395 m
.21429 .2777 L
s
.2619 .27395 m
.2619 .2777 L
s
.35714 .27395 m
.35714 .2777 L
s
.40476 .27395 m
.40476 .2777 L
s
.45238 .27395 m
.45238 .2777 L
s
.54762 .27395 m
.54762 .2777 L
s
.59524 .27395 m
.59524 .2777 L
s
.64286 .27395 m
.64286 .2777 L
s
.7381 .27395 m
.7381 .2777 L
s
.78571 .27395 m
.78571 .2777 L
s
.83333 .27395 m
.83333 .2777 L
s
.07143 .27395 m
.07143 .2777 L
s
.02381 .27395 m
.02381 .2777 L
s
.92857 .27395 m
.92857 .2777 L
s
.97619 .27395 m
.97619 .2777 L
s
.25 Mabswid
0 .27395 m
1 .27395 L
s
.5 .02692 m
.50625 .02692 L
s
[(3.25)] .4875 .02692 1 0 Mshowa
.5 .10926 m
.50625 .10926 L
s
[(3.5)] .4875 .10926 1 0 Mshowa
.5 .19161 m
.50625 .19161 L
s
[(3.75)] .4875 .19161 1 0 Mshowa
.5 .35629 m
.50625 .35629 L
s
[(4.25)] .4875 .35629 1 0 Mshowa
.5 .43863 m
.50625 .43863 L
s
[(4.5)] .4875 .43863 1 0 Mshowa
.5 .52098 m
.50625 .52098 L
s
[(4.75)] .4875 .52098 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(5)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04339 m
.50375 .04339 L
s
.5 .05986 m
.50375 .05986 L
s
.5 .07633 m
.50375 .07633 L
s
.5 .0928 m
.50375 .0928 L
s
.5 .12573 m
.50375 .12573 L
s
.5 .1422 m
.50375 .1422 L
s
.5 .15867 m
.50375 .15867 L
s
.5 .17514 m
.50375 .17514 L
s
.5 .20808 m
.50375 .20808 L
s
.5 .22454 m
.50375 .22454 L
s
.5 .24101 m
.50375 .24101 L
s
.5 .25748 m
.50375 .25748 L
s
.5 .29042 m
.50375 .29042 L
s
.5 .30689 m
.50375 .30689 L
s
.5 .32335 m
.50375 .32335 L
s
.5 .33982 m
.50375 .33982 L
s
.5 .37276 m
.50375 .37276 L
s
.5 .38923 m
.50375 .38923 L
s
.5 .4057 m
.50375 .4057 L
s
.5 .42217 m
.50375 .42217 L
s
.5 .4551 m
.50375 .4551 L
s
.5 .47157 m
.50375 .47157 L
s
.5 .48804 m
.50375 .48804 L
s
.5 .50451 m
.50375 .50451 L
s
.5 .53745 m
.50375 .53745 L
s
.5 .55391 m
.50375 .55391 L
s
.5 .57038 m
.50375 .57038 L
s
.5 .58685 m
.50375 .58685 L
s
.5 .01045 m
.50375 .01045 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .58026 L
.10458 .55313 L
.14415 .52543 L
.18221 .4964 L
.22272 .4624 L
.26171 .42598 L
.30316 .38228 L
.34309 .33386 L
.3815 .27942 L
.42237 .20953 L
.46172 .12446 L
.48147 .07171 L
.49012 .04569 L
.49468 .03106 L
.49719 .02274 L
.49842 .01859 L
.49955 .01472 L
.50085 .0161 L
.50154 .01844 L
.50226 .02089 L
.50471 .02907 L
.5095 .04449 L
.51896 .07297 L
.53984 .12827 L
.57781 .20987 L
.61824 .27901 L
.65714 .33416 L
.6985 .38414 L
.73835 .42604 L
.77668 .46187 L
.81746 .49614 L
.85673 .52607 L
.89448 .55249 L
.93468 .57848 L
.97337 .60169 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  "Through its adaptive procedure, ",
  StyleBox["NDSolve", "MR"],
  " is able to solve \[OpenCurlyDoubleQuote]stiff\[CloseCurlyDoubleQuote] \
differential equations in which there are several components which vary with \
",
  StyleBox["x", "TI"],
  " at very different rates. "
}], "Text",
  CellTags->{"S3.9.7", "7.34"}],

Cell[TextData[{
  "In these equations, ",
  StyleBox["y", "MR"],
  " varies much more rapidly than ",
  StyleBox["z", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.35"}],

Cell[CellGroupData[{

Cell["\<\
sol = NDSolve[ {y'[x] == -40 y[x], z'[x] == -z[x]/10, y[0] == z[0] \
== 1}, {y, z}, {x, 0, 1}]\
\>", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"y", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"z", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " nevertheless tracks both components successfully. "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.36"}],

Cell[CellGroupData[{

Cell["\<\
Plot[Evaluate[{y[x], z[x]} /. sol], {x, 0, 1}, PlotRange -> \
All]\
\>", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S3.9.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.588604 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .13244 -18 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -18 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -18 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -18 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13244 m
.03006 .13244 L
s
[(0.2)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(0.4)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(0.6)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(0.8)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .16187 m
.02756 .16187 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
.5 Mabswid
.02381 .60332 m
.02846 .49895 L
.03279 .41845 L
.03793 .33995 L
.04262 .28187 L
.0522 .19337 L
.05746 .15791 L
.06244 .13089 L
.06754 .10849 L
.07295 .08944 L
.08265 .06444 L
.08804 .05437 L
.09308 .04679 L
.09858 .04018 L
.10458 .03451 L
.10996 .0305 L
.11496 .02752 L
.12013 .02501 L
.12483 .02317 L
.13379 .02052 L
.13872 .01943 L
.14335 .0186 L
.15311 .01729 L
.15803 .01681 L
.16343 .01639 L
.16804 .01609 L
.17298 .01583 L
.1819 .01548 L
.18719 .01533 L
.19208 .01522 L
.19734 .01512 L
.20314 .01503 L
.2129 .01492 L
.21824 .01488 L
.22326 .01485 L
.23309 .0148 L
.23804 .01479 L
.24345 .01477 L
.24808 .01476 L
.25303 .01475 L
.26195 .01474 L
.26728 .01474 L
.27219 .01473 L
.27748 .01473 L
.2833 .01473 L
.29309 .01472 L
.29844 .01472 L
.30345 .01472 L
.30843 .01472 L
.31386 .01472 L
Mistroke
.31864 .01472 L
.32374 .01472 L
.32878 .01472 L
.33335 .01472 L
.34227 .01472 L
.34716 .01472 L
.35232 .01472 L
.36156 .01472 L
.3667 .01472 L
.3715 .01472 L
.37672 .01472 L
.38239 .01472 L
.38784 .01472 L
.39287 .01472 L
.39759 .01472 L
.40278 .01472 L
.41179 .01472 L
.41673 .01472 L
.42135 .01472 L
.43121 .01472 L
.43616 .01472 L
.44157 .01472 L
.44622 .01472 L
.45117 .01472 L
.46009 .01472 L
.46544 .01472 L
.47036 .01472 L
.47576 .01472 L
.48148 .01472 L
.49109 .01472 L
.49654 .01472 L
.50164 .01472 L
.50664 .01472 L
.51208 .01472 L
.51687 .01472 L
.52197 .01472 L
.52654 .01472 L
.5316 .01472 L
.54052 .01472 L
.54542 .01472 L
.5481 .01472 L
.55059 .01472 L
.55273 .01472 L
.55501 .01472 L
.55631 .01472 L
.55754 .01472 L
.55864 .01472 L
.55984 .01472 L
.56114 .01472 L
.56235 .01472 L
Mistroke
.56511 .01472 L
.56779 .01472 L
.57068 .01472 L
.57591 .01472 L
.58069 .01472 L
.58989 .01472 L
.59231 .01472 L
.59494 .01472 L
.59741 .01472 L
.59969 .01472 L
.601 .01472 L
.60243 .01472 L
.60316 .01472 L
.60393 .01472 L
.60466 .01472 L
.60533 .01472 L
.60659 .01472 L
.6073 .01472 L
.60795 .01472 L
.60916 .01472 L
.61044 .01472 L
.61289 .01472 L
.61518 .01472 L
.6177 .01472 L
.62042 .01472 L
.63 .01472 L
.63543 .01472 L
.64047 .01472 L
.65133 .01472 L
.65666 .01472 L
.66158 .01472 L
.66635 .01472 L
.66876 .01472 L
.6714 .01472 L
.67406 .01472 L
.67555 .01472 L
.6769 .01472 L
.67817 .01472 L
.67888 .01472 L
.67954 .01472 L
.68076 .01472 L
.68205 .01472 L
.68331 .01472 L
.68447 .01472 L
.68574 .01472 L
.68708 .01472 L
.68934 .01472 L
.69181 .01472 L
.69402 .01472 L
.69638 .01472 L
Mistroke
.69753 .01472 L
.69861 .01472 L
.69967 .01472 L
.70064 .01472 L
.70179 .01472 L
.70302 .01472 L
.70417 .01472 L
.70525 .01472 L
.70651 .01472 L
.70768 .01472 L
.70896 .01472 L
.71033 .01472 L
.71311 .01472 L
.71572 .01472 L
.72061 .01472 L
.72491 .01472 L
.72726 .01472 L
.72946 .01472 L
.73061 .01472 L
.73184 .01472 L
.73254 .01472 L
.73321 .01472 L
.73445 .01472 L
.73559 .01472 L
.73665 .01472 L
.73781 .01472 L
.73904 .01472 L
.74863 .01472 L
.75873 .01472 L
.7629 .01472 L
.76735 .01472 L
.76991 .01472 L
.77224 .01472 L
.77336 .01472 L
.77457 .01472 L
.77572 .01472 L
.77678 .01472 L
.7779 .01472 L
.77909 .01472 L
.78022 .01472 L
.78125 .01472 L
.78246 .01472 L
.78378 .01472 L
.78502 .01472 L
.78617 .01472 L
.78748 .01472 L
.7887 .01472 L
.7898 .01472 L
.79099 .01472 L
.79229 .01472 L
Mistroke
.79295 .01472 L
.79366 .01472 L
.79493 .01472 L
.79612 .01472 L
.79742 .01472 L
.79883 .01472 L
.80139 .01472 L
.80619 .01472 L
.81175 .01472 L
.81448 .01472 L
.81697 .01472 L
.81918 .01472 L
.82029 .01472 L
.82151 .01472 L
.82273 .01472 L
.82404 .01472 L
.82527 .01472 L
.82639 .01472 L
.82704 .01472 L
.82773 .01472 L
.82896 .01472 L
.83028 .01472 L
.83174 .01472 L
.83678 .01472 L
.84202 .01472 L
.84496 .01472 L
.84764 .01472 L
.85014 .01472 L
.85285 .01472 L
.85542 .01472 L
.8578 .01472 L
.86676 .01472 L
.86921 .01472 L
.8718 .01472 L
.87643 .01472 L
.87905 .01472 L
.88149 .01472 L
.88704 .01472 L
.89702 .01472 L
.90205 .01472 L
.90752 .01472 L
.91268 .01472 L
.91514 .01472 L
.91744 .01472 L
.91951 .01472 L
.92067 .01472 L
.92173 .01472 L
.92289 .01472 L
.92416 .01472 L
.92535 .01472 L
Mistroke
.92646 .01472 L
.92771 .01472 L
.92889 .01472 L
.92996 .01472 L
.93109 .01472 L
.93232 .01472 L
.93346 .01472 L
.93468 .01472 L
.93537 .01472 L
.93602 .01472 L
.93728 .01472 L
.93862 .01472 L
.94103 .01472 L
.94647 .01472 L
.95158 .01472 L
.95638 .01472 L
.96062 .01472 L
.96178 .01472 L
.96301 .01472 L
.96405 .01472 L
.9652 .01472 L
.96648 .01472 L
.96764 .01472 L
.96828 .01472 L
.96898 .01472 L
.97024 .01472 L
.97143 .01472 L
.97268 .01472 L
.97375 .01472 L
.97493 .01472 L
.97619 .01472 L
Mfstroke
.02381 .60332 m
.06244 .60094 L
.10458 .59835 L
.14415 .59593 L
.18221 .59361 L
.22272 .59115 L
.26171 .5888 L
.30316 .58631 L
.34309 .58391 L
.3815 .58162 L
.42237 .5792 L
.46172 .57687 L
.49955 .57464 L
.53984 .57228 L
.57861 .57001 L
.61984 .56761 L
.65954 .56531 L
.69774 .56311 L
.73838 .56077 L
.77751 .55853 L
.81909 .55616 L
.85916 .55389 L
.89771 .55171 L
.93871 .54941 L
.97619 .54731 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " follows the general procedure of reducing step size until it tracks \
solutions accurately. There is a problem, however, when the true solution has \
a singularity. In this case, ",
  StyleBox["NDSolve", "MR"],
  " might go on reducing the step size forever, and never terminate. To avoid \
this problem, the option ",
  StyleBox["MaxSteps", "MR"],
  " specifies the maximum number of steps that ",
  StyleBox["NDSolve", "MR"],
  " will ever take in attempting to find a solution. For ordinary \
differential equations the default setting is ",
  StyleBox["MaxSteps", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["10000", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.9.7", "7.37"}],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " stops after taking 10000 steps. "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.38"}],

Cell[CellGroupData[{

Cell["NDSolve[{y'[x] == -1/x^2, y[-1] == -1}, y[x], {x, -1, 0}]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    \(NDSolve::"mxst" \(\(:\)\(\ \)\) 
      "Maximum number of \!\(10000\) steps reached at the point \!\(x\) == \!\
\(-1.0041321640972122`*^-172\)."\)], "Message",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{\(y[x]\), "\[Rule]", 
          RowBox[{
            
            TagBox[\(InterpolatingFunction[{{\(-1.`\), \
\(-1.0041321640972122`*^-172\)}}, "<>"]\),
              False,
              Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  "There is in fact a singularity in the solution at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.39"}],

Cell[CellGroupData[{

Cell["Plot[Evaluate[y[x] /. %], {x, -1, 0}]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S3.9.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.97619 0.952381 0.603319 0.00224264 [
[.02381 .59082 -6 -9 ]
[.02381 .59082 6 0 ]
[.21429 .59082 -12 -9 ]
[.21429 .59082 12 0 ]
[.40476 .59082 -12 -9 ]
[.40476 .59082 12 0 ]
[.59524 .59082 -12 -9 ]
[.59524 .59082 12 0 ]
[.78571 .59082 -12 -9 ]
[.78571 .59082 12 0 ]
[.96369 .04266 -24 -4.5 ]
[.96369 .04266 0 4.5 ]
[.96369 .15479 -24 -4.5 ]
[.96369 .15479 0 4.5 ]
[.96369 .26692 -24 -4.5 ]
[.96369 .26692 0 4.5 ]
[.96369 .37906 -24 -4.5 ]
[.96369 .37906 0 4.5 ]
[.96369 .49119 -18 -4.5 ]
[.96369 .49119 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .60332 m
.02381 .60957 L
s
[(-1)] .02381 .59082 0 1 Mshowa
.21429 .60332 m
.21429 .60957 L
s
[(-0.8)] .21429 .59082 0 1 Mshowa
.40476 .60332 m
.40476 .60957 L
s
[(-0.6)] .40476 .59082 0 1 Mshowa
.59524 .60332 m
.59524 .60957 L
s
[(-0.4)] .59524 .59082 0 1 Mshowa
.78571 .60332 m
.78571 .60957 L
s
[(-0.2)] .78571 .59082 0 1 Mshowa
.125 Mabswid
.07143 .60332 m
.07143 .60707 L
s
.11905 .60332 m
.11905 .60707 L
s
.16667 .60332 m
.16667 .60707 L
s
.2619 .60332 m
.2619 .60707 L
s
.30952 .60332 m
.30952 .60707 L
s
.35714 .60332 m
.35714 .60707 L
s
.45238 .60332 m
.45238 .60707 L
s
.5 .60332 m
.5 .60707 L
s
.54762 .60332 m
.54762 .60707 L
s
.64286 .60332 m
.64286 .60707 L
s
.69048 .60332 m
.69048 .60707 L
s
.7381 .60332 m
.7381 .60707 L
s
.83333 .60332 m
.83333 .60707 L
s
.88095 .60332 m
.88095 .60707 L
s
.92857 .60332 m
.92857 .60707 L
s
.25 Mabswid
0 .60332 m
1 .60332 L
s
.97619 .04266 m
.98244 .04266 L
s
[(-250)] .96369 .04266 1 0 Mshowa
.97619 .15479 m
.98244 .15479 L
s
[(-200)] .96369 .15479 1 0 Mshowa
.97619 .26692 m
.98244 .26692 L
s
[(-150)] .96369 .26692 1 0 Mshowa
.97619 .37906 m
.98244 .37906 L
s
[(-100)] .96369 .37906 1 0 Mshowa
.97619 .49119 m
.98244 .49119 L
s
[(-50)] .96369 .49119 1 0 Mshowa
.125 Mabswid
.97619 .06509 m
.97994 .06509 L
s
.97619 .08751 m
.97994 .08751 L
s
.97619 .10994 m
.97994 .10994 L
s
.97619 .13237 m
.97994 .13237 L
s
.97619 .17722 m
.97994 .17722 L
s
.97619 .19964 m
.97994 .19964 L
s
.97619 .22207 m
.97994 .22207 L
s
.97619 .2445 m
.97994 .2445 L
s
.97619 .28935 m
.97994 .28935 L
s
.97619 .31178 m
.97994 .31178 L
s
.97619 .3342 m
.97994 .3342 L
s
.97619 .35663 m
.97994 .35663 L
s
.97619 .40148 m
.97994 .40148 L
s
.97619 .42391 m
.97994 .42391 L
s
.97619 .44633 m
.97994 .44633 L
s
.97619 .46876 m
.97994 .46876 L
s
.97619 .51361 m
.97994 .51361 L
s
.97619 .53604 m
.97994 .53604 L
s
.97619 .55847 m
.97994 .55847 L
s
.97619 .58089 m
.97994 .58089 L
s
.97619 .02023 m
.97994 .02023 L
s
.25 Mabswid
.97619 0 m
.97619 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60108 m
.06244 .60098 L
.10458 .60087 L
.14415 .60075 L
.18221 .60063 L
.22272 .60048 L
.26171 .60033 L
.30316 .60015 L
.34309 .59995 L
.3815 .59973 L
.42237 .59946 L
.46172 .59917 L
.49955 .59884 L
.53984 .59842 L
.57861 .59795 L
.61984 .59733 L
.65954 .59657 L
.69774 .59565 L
.73838 .59434 L
.77751 .59257 L
.79892 .59127 L
.81909 .58972 L
.83917 .58773 L
.85764 .5853 L
.87647 .5819 L
.88716 .57933 L
.89713 .5763 L
.90758 .57219 L
.91748 .56694 L
.92637 .56045 L
.93139 .55564 L
.93604 .55012 L
.94067 .54318 L
.94567 .53334 L
.94796 .52765 L
.95038 .52056 L
.95471 .50391 L
.95717 .49103 L
.9598 .47299 L
.96229 .4497 L
.96454 .41992 L
.96593 .39522 L
.9672 .36572 L
.9686 .32194 L
.96931 .29312 L
.97008 .25373 L
.97138 .15908 L
.97211 .07946 L
s
.97211 .07946 m
.97263 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  "The default setting for ",
  StyleBox["MaxSteps", "MR"],
  " should be sufficient for most equations with smooth solutions. When \
solutions have a complicated structure, however, you may occasionally have to \
choose larger settings for ",
  StyleBox["MaxSteps", "MR"],
  ". With the setting ",
  StyleBox["MaxSteps", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Infinity", "MR"],
  " there is no upper limit on the number of steps used. "
}], "Text",
  CellTags->{"S3.9.7", "7.40"}],

Cell[TextData[{
  "To take the solution to the Lorenz equations this far, you need to remove \
the default bound on ",
  StyleBox["MaxSteps", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.41"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[ {x'[t] == -3 (x[t] - y[t]), y'[t] == -x[t] z[t] + 26.5 \
x[t] - y[t], z'[t] == x[t] y[t] - z[t], x[0] == z[0] == 0, y[0] == 1}, {x, y, \
z}, {t, 0, 200}, MaxSteps->Infinity ]\
\>", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"x", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 200.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"y", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 200.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"z", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 200.`}}, "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell["\<\
Here is a parametric plot of the solution in three dimensions. \
\
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.42"}],

Cell[CellGroupData[{

Cell["\<\
ParametricPlot3D[Evaluate[{x[t], y[t], z[t]} /. %], {t, 0, 200}, \
PlotPoints -> 10000]\
\>", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S3.9.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.46125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.221695 1.51952 -1.1807e-16 1.51952 [
[.10106 .16269 -16.9295 -9 ]
[.10106 .16269 1.07049 0 ]
[.18874 .12601 -11.0578 -9 ]
[.18874 .12601 .94222 0 ]
[.27852 .08845 -5.41461 -9 ]
[.27852 .08845 .58539 0 ]
[.37047 .05 -5.30033 -9 ]
[.37047 .05 .69967 0 ]
[.46466 .01061 -10.3721 -9 ]
[.46466 .01061 1.6279 0 ]
[.13264 1.16236 -9.71693 0 ]
[.13264 1.16236 8.28307 9 ]
[.26016 1.26237 -3.16065 0 ]
[.26016 1.26237 2.83935 9 ]
[.37626 1.35341 -6.18386 0 ]
[.37626 1.35341 5.81614 9 ]
[.48239 1.43663 -6.06228 0 ]
[.48239 1.43663 5.93772 9 ]
[.07296 .20996 -6 -2.63414 ]
[.07296 .20996 0 6.36586 ]
[.05624 .3629 -12 -2.72318 ]
[.05624 .3629 0 6.27682 ]
[.03822 .52761 -12 -2.81953 ]
[.03822 .52761 0 6.18047 ]
[.01877 .70551 -12 -2.92414 ]
[.01877 .70551 0 6.07586 ]
[-0.0023 .89826 -12 -3.0381 ]
[-0.0023 .89826 0 5.9619 ]
[ 0 0 0 0 ]
[ 1 1.46125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.09234 .18581 m
.53814 0 L
s
.11362 .17694 m
.1199 .18407 L
s
[(-10)] .10106 .16269 .88106 1 Mshowa
.20098 .14053 m
.20711 .14779 L
s
[(-5)] .18874 .12601 .84296 1 Mshowa
.29043 .10325 m
.29638 .11065 L
s
[(0)] .27852 .08845 .80487 1 Mshowa
.38202 .06507 m
.3878 .07261 L
s
[(5)] .37047 .05 .76678 1 Mshowa
.47585 .02596 m
.48144 .03364 L
s
[(10)] .46466 .01061 .72868 1 Mshowa
.125 Mabswid
.13093 .16973 m
.13468 .17402 L
s
.14832 .16248 m
.15205 .16679 L
s
.16579 .1552 m
.1695 .15952 L
s
.18335 .14788 m
.18704 .15222 L
s
.2187 .13314 m
.22236 .13752 L
s
.23651 .12572 m
.24014 .13011 L
s
.2544 .11827 m
.25801 .12267 L
s
.27237 .11077 m
.27596 .1152 L
s
.30857 .09568 m
.31212 .10014 L
s
.3268 .08809 m
.33033 .09256 L
s
.34512 .08045 m
.34863 .08494 L
s
.36353 .07278 m
.36702 .07728 L
s
.40061 .05732 m
.40405 .06186 L
s
.41928 .04954 m
.42271 .05409 L
s
.43805 .04172 m
.44145 .04629 L
s
.4569 .03386 m
.46028 .03845 L
s
.09639 .18412 m
.10017 .18838 L
s
.49489 .01802 m
.49822 .02265 L
s
.51402 .01005 m
.51733 .01469 L
s
.53325 .00204 m
.53654 .00669 L
s
.25 Mabswid
0 1.03786 m
.538 1.46125 L
s
.13415 1.14343 m
.1349 1.13396 L
s
[(-10)] .13264 1.16236 .07966 -1 Mshowa
.26118 1.2434 m
.26169 1.23392 L
s
[(0)] .26016 1.26237 .05355 -1 Mshowa
.37684 1.33442 m
.37713 1.32493 L
s
[(10)] .37626 1.35341 .03064 -1 Mshowa
.48258 1.41764 m
.48268 1.40814 L
s
[(20)] .48239 1.43663 .01038 -1 Mshowa
.125 Mabswid
.02315 1.05608 m
.02374 1.05041 L
s
.05174 1.07858 m
.0523 1.07291 L
s
.07976 1.10063 m
.08028 1.09495 L
s
.10722 1.12224 m
.10771 1.11656 L
s
.16054 1.1642 m
.16096 1.15852 L
s
.18643 1.18457 m
.18682 1.17889 L
s
.21182 1.20456 m
.21218 1.19887 L
s
.23673 1.22416 m
.23707 1.21847 L
s
.28517 1.26228 m
.28545 1.25659 L
s
.30872 1.28081 m
.30897 1.27512 L
s
.33184 1.29901 m
.33206 1.29331 L
s
.35454 1.31687 m
.35474 1.31118 L
s
.39874 1.35166 m
.39889 1.34596 L
s
.42025 1.36859 m
.42038 1.36289 L
s
.44139 1.38522 m
.4415 1.37953 L
s
.46217 1.40157 m
.46225 1.39587 L
s
.50265 1.43343 m
.50269 1.42774 L
s
.52239 1.44896 m
.5224 1.44327 L
s
.25 Mabswid
.09234 .18581 m
0 1.03786 L
s
.09051 .20269 m
.09928 .19905 L
s
[(0)] .07296 .20996 1 -0.41464 Mshowa
.0739 .35592 m
.08274 .35243 L
s
[(10)] .05624 .3629 1 -0.39485 Mshowa
.05602 .52096 m
.06491 .51764 L
s
[(20)] .03822 .52761 1 -0.37344 Mshowa
.0367 .69924 m
.04566 .6961 L
s
[(30)] .01877 .70551 1 -0.35019 Mshowa
.01576 .89239 m
.0248 .88946 L
s
[(40)] -0.0023 .89826 1 -0.32487 Mshowa
.125 Mabswid
.08728 .23245 m
.09255 .23029 L
s
.08401 .26265 m
.08929 .2605 L
s
.08069 .29328 m
.08598 .29115 L
s
.07732 .32437 m
.08261 .32226 L
s
.07043 .38794 m
.07574 .38587 L
s
.06691 .42045 m
.07222 .41839 L
s
.06333 .45344 m
.06866 .45141 L
s
.0597 .48695 m
.06503 .48493 L
s
.05227 .55551 m
.05762 .55354 L
s
.04847 .5906 m
.05382 .58865 L
s
.04461 .62624 m
.04997 .62431 L
s
.04068 .66245 m
.04605 .66054 L
s
.03265 .73662 m
.03803 .73476 L
s
.02853 .77461 m
.03392 .77277 L
s
.02434 .81323 m
.02975 .81141 L
s
.02009 .85248 m
.0255 .8507 L
s
.01137 .93298 m
.01679 .93124 L
s
.00689 .97425 m
.01233 .97254 L
s
.00234 1.01623 m
.00779 1.01455 L
s
.25 Mabswid
.09234 .18581 m
0 1.03786 L
s
0 1.03786 m
.538 1.46125 L
s
.538 1.46125 m
.53801 .68631 L
s
.53801 .68631 m
.09234 .18581 L
s
.53814 0 m
.93025 .55706 L
s
.93025 .55706 m
1 1.35457 L
s
1 1.35457 m
.53815 .87334 L
s
.53815 .87334 m
.53814 0 L
s
.09234 .18581 m
0 1.03786 L
s
0 1.03786 m
.53815 .87334 L
s
.53815 .87334 m
.53814 0 L
s
.53814 0 m
.09234 .18581 L
s
.53801 .68631 m
.93025 .55706 L
s
.93025 .55706 m
1 1.35457 L
s
1 1.35457 m
.538 1.46125 L
s
.538 1.46125 m
.53801 .68631 L
s
0 0 m
1 0 L
1 1.46125 L
0 1.46125 L
closepath
clip
newpath
.5 Mabswid
.72934 .61157 m
.75763 .65324 L
s
.70299 .57577 m
.72934 .61157 L
s
.75763 .65324 m
.78739 .70125 L
s
.67881 .54521 m
.70299 .57577 L
s
.78739 .70125 m
.81786 .75583 L
s
.65686 .51924 m
.67881 .54521 L
s
.63712 .49723 m
.65686 .51924 L
s
.81786 .75583 m
.8479 .81669 L
s
.61948 .4786 m
.63712 .49723 L
s
.6038 .46284 m
.61948 .4786 L
s
.58993 .44951 m
.6038 .46284 L
s
.8479 .81669 m
.87586 .88282 L
s
.57769 .43823 m
.58993 .44951 L
s
.56693 .42866 m
.57769 .43823 L
s
.55749 .42055 m
.56693 .42866 L
s
.54921 .41366 m
.55749 .42055 L
s
.54197 .40781 m
.54921 .41366 L
s
.53565 .40284 m
.54197 .40781 L
s
.87586 .88282 m
.8996 .95208 L
s
.53013 .39862 m
.53565 .40284 L
s
.52532 .39504 m
.53013 .39862 L
s
.52114 .39203 m
.52532 .39504 L
s
.5175 .38951 m
.52114 .39203 L
s
.51435 .38742 m
.5175 .38951 L
s
.51163 .38572 m
.51435 .38742 L
s
.50928 .38439 m
.51163 .38572 L
s
.70214 .66414 m
.72259 .69254 L
s
.68273 .63933 m
.70214 .66414 L
s
.50727 .3834 m
.50928 .38439 L
s
.72259 .69254 m
.74376 .7247 L
s
.66455 .61786 m
.68273 .63933 L
s
.50556 .38274 m
.50727 .3834 L
s
.50199 .38285 m
.50294 .38244 L
s
.50413 .38241 m
.50556 .38274 L
s
.50294 .38244 m
.50413 .38241 L
s
.70825 .67636 m
.72866 .70554 L
s
.68874 .65075 m
.70825 .67636 L
s
.64769 .5994 m
.66455 .61786 L
s
.67036 .6285 m
.68874 .65075 L
s
.74376 .7247 m
.7652 .76064 L
s
.72866 .70554 m
.74962 .73842 L
s
.65325 .60931 m
.67036 .6285 L
s
.63218 .58365 m
.64769 .5994 L
s
.63745 .59289 m
.65325 .60931 L
s
.74962 .73842 m
.77062 .77492 L
s
.70364 .67829 m
.72328 .70595 L
s
.68487 .65402 m
.70364 .67829 L
s
.66718 .63291 m
.68487 .65402 L
s
.618 .57028 m
.63218 .58365 L
s
.72328 .70595 m
.74346 .73709 L
s
.7652 .76064 m
.78625 .80013 L
s
.65068 .61471 m
.66718 .63291 L
s
.62296 .57892 m
.63745 .59289 L
s
.69855 .67786 m
.71753 .70407 L
s
.68043 .65486 m
.69855 .67786 L
s
.63542 .59913 m
.65068 .61471 L
s
.66335 .63487 m
.68043 .65486 L
s
.74346 .73709 m
.7637 .77166 L
s
.60511 .55899 m
.618 .57028 L
s
.71753 .70407 m
.73707 .73361 L
s
.60975 .56712 m
.62296 .57892 L
s
.64742 .61764 m
.66335 .63487 L
s
.77062 .77492 m
.79095 .81469 L
s
.62141 .58589 m
.63542 .59913 L
s
.73707 .73361 m
.75674 .76645 L
s
.59344 .54953 m
.60511 .55899 L
s
.63268 .60291 m
.64742 .61764 L
s
.59775 .5572 m
.60975 .56712 L
s
.78625 .80013 m
.80606 .84257 L
s
.7637 .77166 m
.78337 .80935 L
s
.60861 .5747 m
.62141 .58589 L
s
.61914 .59039 m
.63268 .60291 L
s
.8996 .95208 m
.91648 1.02094 L
s
.5829 .54166 m
.59344 .54953 L
s
.5869 .54892 m
.59775 .5572 L
s
.75674 .76645 m
.77597 .80233 L
s
.69477 .68864 m
.71247 .71289 L
s
.67779 .66728 m
.69477 .68864 L
s
.59697 .56533 m
.60861 .5747 L
s
.6617 .64867 m
.67779 .66728 L
s
.60676 .57984 m
.61914 .59039 L
s
.71247 .71289 m
.73061 .74011 L
s
.64663 .63259 m
.6617 .64867 L
s
.57341 .53515 m
.5829 .54166 L
s
.79095 .81469 m
.80971 .85703 L
s
.57711 .54208 m
.5869 .54892 L
s
.58642 .55753 m
.59697 .56533 L
s
.63262 .61881 m
.64663 .63259 L
s
.73061 .74011 m
.7488 .77024 L
s
.59548 .57102 m
.60676 .57984 L
s
.56488 .52984 m
.57341 .53515 L
s
.78337 .80935 m
.80164 .84954 L
s
.56829 .53648 m
.57711 .54208 L
s
.68083 .68073 m
.6973 .70185 L
s
.66512 .66222 m
.68083 .68073 L
s
.6973 .70185 m
.71434 .72569 L
s
.61969 .6071 m
.63262 .61881 L
s
.65032 .64616 m
.66512 .66222 L
s
.57688 .55111 m
.58642 .55753 L
s
.77597 .80233 m
.79398 .84069 L
s
.58524 .56371 m
.59548 .57102 L
s
.71434 .72569 m
.73166 .75229 L
s
.68036 .6831 m
.69661 .70392 L
s
.66485 .66485 m
.68036 .6831 L
s
.69661 .70392 m
.71341 .7274 L
s
.55723 .52556 m
.56488 .52984 L
s
.80606 .84257 m
.82355 .88693 L
s
.7488 .77024 m
.76652 .80302 L
s
.63648 .63235 m
.65032 .64616 L
s
.65021 .64901 m
.66485 .66485 L
s
.6078 .59725 m
.61969 .6071 L
s
.56037 .53196 m
.56829 .53648 L
s
.71341 .7274 m
.73046 .75356 L
s
.63652 .63538 m
.65021 .64901 L
s
.56827 .54589 m
.57688 .55111 L
s
.57598 .55772 m
.58524 .56371 L
s
.73166 .75229 m
.74884 .7815 L
s
.62364 .62058 m
.63648 .63235 L
s
.68685 .69675 m
.70296 .71818 L
s
.67136 .67784 m
.68685 .69675 L
s
.65663 .66133 m
.67136 .67784 L
s
.55037 .52217 m
.55723 .52556 L
s
.68821 .69949 m
.70429 .72106 L
s
.67272 .68044 m
.68821 .69949 L
s
.70296 .71818 m
.71944 .74218 L
s
.65798 .66378 m
.67272 .68044 L
s
.59693 .58903 m
.6078 .59725 L
s
.55325 .52837 m
.56037 .53196 L
s
.6238 .62375 m
.63652 .63538 L
s
.64278 .64706 m
.65663 .66133 L
s
.70429 .72106 m
.7207 .74518 L
s
.73046 .75356 m
.74736 .78227 L
s
.64409 .64936 m
.65798 .66378 L
s
.67931 .69127 m
.69487 .71117 L
s
.66441 .67377 m
.67931 .69127 L
s
.61179 .61065 m
.62364 .62058 L
s
.56052 .54172 m
.56827 .54589 L
s
.69487 .71117 m
.71089 .73356 L
s
.56761 .55289 m
.57598 .55772 L
s
.71944 .74218 m
.73597 .7687 L
s
.65029 .65854 m
.66441 .67377 L
s
.62984 .63483 m
.64278 .64706 L
s
.54422 .51956 m
.55037 .52217 L
s
.63111 .637 m
.64409 .64936 L
s
.67446 .68765 m
.68968 .7066 L
s
.65992 .67105 m
.67446 .68765 L
s
.68968 .7066 m
.70542 .72797 L
s
.7207 .74518 m
.73712 .77178 L
s
.61205 .61394 m
.6238 .62375 L
s
.58701 .58225 m
.59693 .58903 L
s
.71089 .73356 m
.72708 .75841 L
s
.54687 .5256 m
.55325 .52837 L
s
.80971 .85703 m
.82578 .90072 L
s
.63703 .64541 m
.65029 .65854 L
s
.64617 .65663 m
.65992 .67105 L
s
.76652 .80302 m
.78309 .83795 L
s
.70542 .72797 m
.7214 .75178 L
s
.74884 .7815 m
.76537 .81303 L
s
.6009 .60234 m
.61179 .61065 L
s
.61784 .62447 m
.62984 .63483 L
s
.55354 .53845 m
.56052 .54172 L
s
.61906 .62651 m
.63111 .637 L
s
.63329 .64425 m
.64617 .65663 L
s
.56005 .54906 m
.56761 .55289 L
s
.53872 .51762 m
.54422 .51956 L
s
.80164 .84954 m
.81749 .89114 L
s
.62468 .6342 m
.63703 .64541 L
s
.67774 .69659 m
.69273 .71568 L
s
.66334 .67978 m
.67774 .69659 L
s
.74736 .78227 m
.7636 .81322 L
s
.60124 .60574 m
.61205 .61394 L
s
.68647 .70794 m
.7017 .72835 L
s
.67172 .68985 m
.68647 .70794 L
s
.65762 .67399 m
.67172 .68985 L
s
.79398 .84069 m
.80986 .88062 L
s
.73597 .7687 m
.75211 .79753 L
s
.69273 .71568 m
.70813 .7371 L
s
.54115 .52354 m
.54687 .5256 L
s
.64967 .66513 m
.66334 .67978 L
s
.6758 .69535 m
.69065 .71405 L
s
.66156 .6789 m
.6758 .69535 L
s
.57799 .57675 m
.58701 .58225 L
s
.72708 .75841 m
.74307 .78559 L
s
.7214 .75178 m
.7373 .77793 L
s
.69065 .71405 m
.70592 .73505 L
s
.64429 .66023 m
.65762 .67399 L
s
.7017 .72835 m
.7172 .75109 L
s
.64804 .66458 m
.66156 .6789 L
s
.73712 .77178 m
.7531 .80063 L
s
.60677 .61578 m
.61784 .62447 L
s
.62129 .63372 m
.63329 .64425 L
s
.59094 .59549 m
.6009 .60234 L
s
.60792 .61771 m
.61906 .62651 L
s
.6368 .65249 m
.64967 .66513 L
s
.54727 .53598 m
.55354 .53845 L
s
.70813 .7371 m
.72367 .76083 L
s
.53379 .51628 m
.53872 .51762 L
s
.61323 .62474 m
.62468 .6342 L
s
.70592 .73505 m
.72136 .75836 L
s
.55325 .54612 m
.56005 .54906 L
s
.63178 .64842 m
.64429 .66023 L
s
.63533 .65224 m
.64804 .66458 L
s
.6753 .69878 m
.68985 .71709 L
s
.66132 .68266 m
.6753 .69878 L
s
.59134 .59898 m
.60124 .60574 L
s
.53603 .5221 m
.54115 .52354 L
s
.68985 .71709 m
.70479 .73762 L
s
.64804 .66861 m
.66132 .68266 L
s
.7172 .75109 m
.73262 .77607 L
s
.62478 .6417 m
.6368 .65249 L
s
.56981 .57237 m
.57799 .57675 L
s
.61018 .62487 m
.62129 .63372 L
s
.59659 .60858 m
.60677 .61578 L
s
.59768 .6104 m
.60792 .61771 L
s
.62346 .64171 m
.63533 .65224 L
s
.52939 .51546 m
.53379 .51628 L
s
.58184 .58991 m
.59094 .59549 L
s
.62013 .6384 m
.63178 .64842 L
s
.54164 .53421 m
.54727 .53598 L
s
.60267 .61684 m
.61323 .62474 L
s
.70479 .73762 m
.71986 .76038 L
s
.63553 .65648 m
.64804 .66861 L
s
.72367 .76083 m
.73898 .78674 L
s
.72136 .75836 m
.73661 .78383 L
s
.7373 .77793 m
.75266 .80617 L
s
.54712 .54395 m
.55325 .54612 L
s
.53144 .5212 m
.53603 .5221 L
s
.74307 .78559 m
.75837 .81479 L
s
.76537 .81303 m
.78058 .8463 L
s
.61361 .63258 m
.62478 .6417 L
s
.5823 .59349 m
.59134 .59898 L
s
.75211 .79753 m
.76731 .82825 L
s
.59994 .61752 m
.61018 .62487 L
s
.82355 .88693 m
.83745 .9316 L
s
.62382 .64614 m
.63553 .65648 L
s
.61244 .63282 m
.62346 .64171 L
s
.5624 .56896 m
.56981 .57237 L
s
.52545 .51509 m
.52939 .51546 L
s
.60932 .62998 m
.62013 .6384 L
s
.58726 .60271 m
.59659 .60858 L
s
.5883 .60444 m
.59768 .6104 L
s
.53659 .53305 m
.54164 .53421 L
s
.7636 .81322 m
.77854 .84587 L
s
.7531 .80063 m
.76808 .83131 L
s
.59296 .61033 m
.60267 .61684 L
s
.71986 .76038 m
.73473 .78521 L
s
.57356 .58547 m
.58184 .58991 L
s
.73262 .77607 m
.74757 .80307 L
s
.67357 .70535 m
.68747 .7227 L
s
.66018 .69005 m
.67357 .70535 L
s
.78309 .83795 m
.7977 .8742 L
s
.52733 .52079 m
.53144 .5212 L
s
.68747 .7227 m
.70171 .74213 L
s
.54161 .54245 m
.54712 .54395 L
s
.64741 .6767 m
.66018 .69005 L
s
.67263 .70523 m
.68644 .72235 L
s
.65934 .69012 m
.67263 .70523 L
s
.60329 .62497 m
.61361 .63258 L
s
.68644 .72235 m
.70057 .74155 L
s
.64667 .67696 m
.65934 .69012 L
s
.61294 .6374 m
.62382 .64614 L
s
.57406 .58912 m
.5823 .59349 L
s
.52192 .51513 m
.52545 .51509 L
s
.59053 .61152 m
.59994 .61752 L
s
.60225 .62543 m
.61244 .63282 L
s
.63535 .66519 m
.64741 .6767 L
s
.67324 .70781 m
.68693 .72488 L
s
.66004 .69274 m
.67324 .70781 L
s
.67087 .70513 m
.68448 .72184 L
s
.65777 .69041 m
.67087 .70513 L
s
.59934 .62302 m
.60932 .62998 L
s
.70171 .74213 m
.71603 .76361 L
s
.73661 .78383 m
.75125 .8112 L
s
.73898 .78674 m
.75361 .81451 L
s
.68448 .72184 m
.69842 .74057 L
s
.64744 .67958 m
.66004 .69274 L
s
.68693 .72488 m
.70093 .74399 L
s
.55569 .56643 m
.5624 .56896 L
s
.53205 .53242 m
.53659 .53305 L
s
.66833 .70287 m
.68181 .71914 L
s
.65539 .68857 m
.66833 .70287 L
s
.6347 .66561 m
.64667 .67696 L
s
.64529 .67759 m
.65777 .69041 L
s
.68181 .71914 m
.69565 .73743 L
s
.57874 .59802 m
.58726 .60271 L
s
.70057 .74155 m
.71481 .76277 L
s
.57971 .59967 m
.5883 .60444 L
s
.52365 .52079 m
.52733 .52079 L
s
.58406 .60506 m
.59296 .61033 L
s
.64307 .67613 m
.65539 .68857 L
s
.56603 .58202 m
.57356 .58547 L
s
.53665 .54155 m
.54161 .54245 L
s
.63552 .66823 m
.64744 .67958 L
s
.62404 .65538 m
.63535 .66519 L
s
.69842 .74057 m
.71249 .76131 L
s
.69565 .73743 m
.70965 .75771 L
s
.59378 .61872 m
.60329 .62497 L
s
.6335 .66655 m
.64529 .67759 L
s
.51877 .51553 m
.52192 .51513 L
s
.70093 .74399 m
.71499 .76509 L
s
.60286 .63013 m
.61294 .6374 L
s
.75266 .80617 m
.76694 .83603 L
s
.62348 .65594 m
.6347 .66561 L
s
.63145 .66544 m
.64307 .67613 L
s
.67578 .71533 m
.68921 .73242 L
s
.66275 .70017 m
.67578 .71533 L
s
.56656 .58574 m
.57406 .58912 L
s
.73473 .78521 m
.74897 .81183 L
s
.59286 .61936 m
.60225 .62543 L
s
.65027 .6869 m
.66275 .70017 L
s
.66918 .70708 m
.68242 .72325 L
s
.65642 .69282 m
.66918 .70708 L
s
.58191 .60672 m
.59053 .61152 L
s
.59016 .61736 m
.59934 .62302 L
s
.52797 .53227 m
.53205 .53242 L
s
.68242 .72325 m
.69599 .74136 L
s
.71603 .76361 m
.73012 .787 L
s
.62432 .65856 m
.63552 .66823 L
s
.52035 .52118 m
.52365 .52079 L
s
.66939 .70803 m
.68258 .72417 L
s
.65666 .69377 m
.66939 .70803 L
s
.68921 .73242 m
.70287 .75146 L
s
.54962 .56465 m
.55569 .56643 L
s
.64425 .68037 m
.65642 .69282 L
s
.75837 .81479 m
.7724 .84546 L
s
.71481 .76277 m
.72883 .7859 L
s
.68258 .72417 m
.6961 .74224 L
s
.62244 .65716 m
.6335 .66655 L
s
.67171 .71231 m
.6849 .72866 L
s
.65895 .69786 m
.67171 .71231 L
s
.63842 .6754 m
.65027 .6869 L
s
.57097 .59438 m
.57874 .59802 L
s
.61349 .64713 m
.62404 .65538 L
s
.64452 .68133 m
.65666 .69377 L
s
.67027 .71094 m
.6834 .72705 L
s
.65759 .69672 m
.67027 .71094 L
s
.57188 .59596 m
.57971 .59967 L
s
.51594 .51624 m
.51877 .51553 L
s
.64676 .68525 m
.65895 .69786 L
s
.53219 .54118 m
.53665 .54155 L
s
.57593 .60089 m
.58406 .60506 L
s
.70965 .75771 m
.72353 .77989 L
s
.6849 .72866 m
.69836 .74692 L
s
.6834 .72705 m
.69682 .74507 L
s
.71249 .76131 m
.72637 .78393 L
s
.74757 .80307 m
.76152 .83165 L
s
.69599 .74136 m
.70966 .76138 L
s
.62055 .65638 m
.63145 .66544 L
s
.64548 .68432 m
.65759 .69672 L
s
.5592 .57945 m
.56603 .58202 L
s
.61301 .64782 m
.62348 .65594 L
s
.67168 .71297 m
.68479 .72927 L
s
.65901 .69852 m
.67168 .71297 L
s
.63275 .66963 m
.64425 .68037 L
s
.58505 .61367 m
.59378 .61872 L
s
.59357 .62417 m
.60286 .63013 L
s
.6961 .74224 m
.70971 .76221 L
s
.71499 .76509 m
.72882 .78803 L
s
.64688 .68588 m
.65901 .69852 L
s
.63304 .67059 m
.64452 .68133 L
s
.68479 .72927 m
.69815 .74747 L
s
.63519 .67435 m
.64676 .68525 L
s
.62725 .66557 m
.63842 .6754 L
s
.80986 .88062 m
.8225 .92071 L
s
.82578 .90072 m
.83788 .94402 L
s
.76731 .82825 m
.78091 .86021 L
s
.70287 .75146 m
.71651 .77238 L
s
.61387 .65042 m
.62432 .65856 L
s
.5174 .5219 m
.52035 .52118 L
s
.52431 .53254 m
.52797 .53227 L
s
.63401 .67362 m
.64548 .68432 L
s
.67331 .71714 m
.68634 .73349 L
s
.66068 .70265 m
.67331 .71714 L
s
.64857 .68996 m
.66068 .70265 L
s
.58424 .61448 m
.59286 .61936 L
s
.69682 .74507 m
.71031 .76497 L
s
.61213 .64929 m
.62244 .65716 L
s
.69836 .74692 m
.71187 .76705 L
s
.55974 .58324 m
.56656 .58574 L
s
.66971 .71257 m
.68261 .72844 L
s
.65723 .69853 m
.66971 .71257 L
s
.81749 .89114 m
.82975 .93261 L
s
.57403 .60298 m
.58191 .60672 L
s
.58174 .61287 m
.59016 .61736 L
s
.63538 .67494 m
.64688 .68588 L
s
.51341 .51725 m
.51594 .51624 L
s
.68634 .73349 m
.69958 .7517 L
s
.68261 .72844 m
.69579 .74616 L
s
.60369 .6403 m
.61349 .64713 L
s
.91648 1.02094 m
.92355 1.08432 L
s
.6453 .68625 m
.65723 .69853 L
s
.54414 .56355 m
.54962 .56465 L
s
.67426 .71982 m
.6872 .73618 L
s
.6617 .70529 m
.67426 .71982 L
s
.62194 .66047 m
.63275 .66963 L
s
.64962 .69255 m
.6617 .70529 L
s
.6104 .64879 m
.62055 .65638 L
s
.63706 .67899 m
.64857 .68996 L
s
.78058 .8463 m
.7937 .88046 L
s
.69815 .74747 m
.71154 .7675 L
s
.52818 .54127 m
.53219 .54118 L
s
.62431 .66507 m
.63519 .67435 L
s
.76808 .83131 m
.78139 .86313 L
s
.62224 .66143 m
.63304 .67059 L
s
.56389 .59167 m
.57097 .59438 L
s
.70966 .76138 m
.72316 .7832 L
s
.60328 .64111 m
.61301 .64782 L
s
.56474 .59319 m
.57188 .59596 L
s
.75125 .8112 m
.76473 .83997 L
s
.62322 .66453 m
.63401 .67362 L
s
.61679 .65728 m
.62725 .66557 L
s
.6872 .73618 m
.70032 .75437 L
s
.56851 .5977 m
.57593 .60089 L
s
.75361 .81451 m
.76702 .84365 L
s
.63814 .68152 m
.64962 .69255 L
s
.70971 .76221 m
.72313 .78397 L
s
.63399 .67563 m
.6453 .68625 L
s
.553 .57766 m
.5592 .57945 L
s
.51475 .52292 m
.5174 .5219 L
s
.73012 .787 m
.7436 .81203 L
s
.69579 .74616 m
.70901 .76569 L
s
.60416 .64369 m
.61387 .65042 L
s
.62455 .66557 m
.63538 .67494 L
s
.58502 .61939 m
.59357 .62417 L
s
.52103 .53319 m
.52431 .53254 L
s
.57705 .60971 m
.58505 .61367 L
s
.72883 .7859 m
.74226 .81067 L
s
.69958 .7517 m
.7128 .77171 L
s
.72353 .77989 m
.73693 .80375 L
s
.51115 .51851 m
.51341 .51725 L
s
.6262 .66962 m
.63706 .67899 L
s
.77854 .84587 m
.79142 .87935 L
s
.60255 .64279 m
.61213 .64929 L
s
.71031 .76497 m
.72358 .78661 L
s
.72637 .78393 m
.7397 .80818 L
s
.71651 .77238 m
.72981 .79501 L
s
.71187 .76705 m
.72513 .78892 L
s
.61185 .65277 m
.62194 .66047 L
s
.61413 .65728 m
.62431 .66507 L
s
.62729 .67208 m
.63814 .68152 L
s
.57634 .61066 m
.58424 .61448 L
s
.55356 .58151 m
.55974 .58324 L
s
.59463 .63475 m
.60369 .6403 L
s
.57403 .60942 m
.58174 .61287 L
s
.61216 .65372 m
.62224 .66143 L
s
.56684 .6002 m
.57403 .60298 L
s
.60097 .64256 m
.6104 .64879 L
s
.62334 .66656 m
.63399 .67563 L
s
.70032 .75437 m
.71339 .77433 L
s
.66944 .71864 m
.68192 .73394 L
s
.65733 .7051 m
.66944 .71864 L
s
.61312 .6569 m
.62322 .66453 L
s
.52458 .54178 m
.52818 .54127 L
s
.53918 .56305 m
.54414 .56355 L
s
.66811 .71614 m
.68058 .73136 L
s
.65605 .70267 m
.66811 .71614 L
s
.72882 .78803 m
.74202 .81256 L
s
.64572 .69326 m
.65733 .7051 L
s
.60705 .65039 m
.61679 .65728 L
s
.74897 .81183 m
.76207 .83979 L
s
.71154 .7675 m
.72468 .78923 L
s
.59429 .63566 m
.60328 .64111 L
s
.51237 .52422 m
.51475 .52292 L
s
.68058 .73136 m
.69328 .74832 L
s
.68192 .73394 m
.69463 .751 L
s
.64449 .69087 m
.65605 .70267 L
s
.61441 .65767 m
.62455 .66557 L
s
.55745 .58978 m
.56389 .59167 L
s
.61602 .66173 m
.6262 .66962 L
s
.50912 .52 m
.51115 .51851 L
s
.55825 .59125 m
.56474 .59319 L
s
.51808 .53417 m
.52103 .53319 L
s
.70901 .76569 m
.72202 .7869 L
s
.59517 .63823 m
.60416 .64369 L
s
.63467 .68304 m
.64572 .69326 L
s
.56175 .59537 m
.56851 .5977 L
s
.54738 .57656 m
.553 .57766 L
s
.61711 .66413 m
.62729 .67208 L
s
.63351 .68066 m
.64449 .69087 L
s
.57718 .61565 m
.58502 .61939 L
s
.59368 .63754 m
.60255 .64279 L
s
.72316 .7832 m
.73613 .80659 L
s
.56973 .60669 m
.57705 .60971 L
s
.7128 .77171 m
.72572 .79336 L
s
.69328 .74832 m
.70602 .767 L
s
.60465 .65085 m
.61413 .65728 L
s
.60246 .64638 m
.61185 .65277 L
s
.61337 .65891 m
.62334 .66656 L
s
.69463 .751 m
.70734 .76977 L
s
.76694 .83603 m
.77947 .86681 L
s
.72313 .78397 m
.73602 .80726 L
s
.60279 .64733 m
.61216 .65372 L
s
.60373 .65061 m
.61312 .6569 L
s
.51025 .52576 m
.51237 .52422 L
s
.52134 .54267 m
.52458 .54178 L
s
.58628 .63036 m
.59463 .63475 L
s
.59225 .63755 m
.60097 .64256 L
s
.7977 .8742 m
.80941 .91054 L
s
.62425 .67434 m
.63467 .68304 L
s
.5073 .52171 m
.50912 .52 L
s
.56912 .60778 m
.57634 .61066 L
s
.54795 .58047 m
.55356 .58151 L
s
.59801 .64479 m
.60705 .65039 L
s
.53471 .56308 m
.53918 .56305 L
s
.56699 .60689 m
.57403 .60942 L
s
.56029 .59826 m
.56684 .6002 L
s
.60497 .65109 m
.61441 .65767 L
s
.60653 .6552 m
.61602 .66173 L
s
.51543 .53546 m
.51808 .53417 L
s
.71339 .77433 m
.72612 .79587 L
s
.586 .63136 m
.59429 .63566 L
s
.62316 .67193 m
.63351 .68066 L
s
.72358 .78661 m
.73627 .80974 L
s
.6076 .65754 m
.61711 .66413 L
s
.76152 .83165 m
.77387 .86119 L
s
.5516 .58863 m
.55745 .58978 L
s
.72513 .78892 m
.73777 .81225 L
s
.66625 .71992 m
.67822 .73441 L
s
.65465 .70708 m
.66625 .71992 L
s
.58687 .63391 m
.59517 .63823 L
s
.55235 .59006 m
.55825 .59125 L
s
.54229 .57607 m
.54738 .57656 L
s
.66788 .72239 m
.67984 .73706 L
s
.65625 .70936 m
.66788 .72239 L
s
.7724 .84546 m
.78444 .87682 L
s
.67822 .73441 m
.69041 .75054 L
s
.72981 .79501 m
.74237 .81904 L
s
.6435 .69582 m
.65465 .70708 L
s
.5556 .59382 m
.56175 .59537 L
s
.66664 .72267 m
.67854 .737 L
s
.65509 .70999 m
.66664 .72267 L
s
.50833 .52753 m
.51025 .52576 L
s
.60408 .65256 m
.61337 .65891 L
s
.70602 .767 m
.71853 .78726 L
s
.59586 .64565 m
.60465 .65085 L
s
.5855 .63343 m
.59368 .63754 L
s
.50566 .52361 m
.5073 .52171 L
s
.64507 .69792 m
.65625 .70936 L
s
.61447 .66705 m
.62425 .67434 L
s
.73693 .80375 m
.74941 .82891 L
s
.64399 .69891 m
.65509 .70999 L
s
.59377 .64119 m
.60246 .64638 L
s
.67032 .7259 m
.68229 .74086 L
s
.65865 .71258 m
.67032 .7259 L
s
.72468 .78923 m
.7372 .8124 L
s
.57 .61284 m
.57718 .61565 L
s
.51842 .54389 m
.52134 .54267 L
s
.67984 .73706 m
.69199 .75336 L
s
.70734 .76977 m
.7198 .79011 L
s
.64741 .70084 m
.65865 .71258 L
s
.67854 .737 m
.69063 .75296 L
s
.7436 .81203 m
.75597 .83826 L
s
.56305 .60453 m
.56973 .60669 L
s
.59501 .64556 m
.60373 .65061 L
s
.5941 .64213 m
.60279 .64733 L
s
.74226 .81067 m
.75463 .83665 L
s
.61345 .66458 m
.62316 .67193 L
s
.51305 .53702 m
.51543 .53546 L
s
.72202 .7869 m
.73445 .80955 L
s
.6329 .68607 m
.6435 .69582 L
s
.58421 .63365 m
.59225 .63755 L
s
.66485 .72235 m
.67658 .73628 L
s
.65347 .71003 m
.66485 .72235 L
s
.7397 .80818 m
.75202 .83366 L
s
.68229 .74086 m
.6944 .75743 L
s
.57859 .62701 m
.58628 .63036 L
s
.58965 .64035 m
.59801 .64479 L
s
.53067 .56358 m
.53471 .56308 L
s
.63442 .68799 m
.64507 .69792 L
s
.63342 .68935 m
.64399 .69891 L
s
.5977 .64992 m
.60653 .6552 L
s
.69041 .75054 m
.70261 .76828 L
s
.5962 .64572 m
.60497 .65109 L
s
.63668 .69063 m
.64741 .70084 L
s
.64254 .69928 m
.65347 .71003 L
s
.54286 .58003 m
.54795 .58047 L
s
.67658 .73628 m
.68851 .75184 L
s
.56252 .60574 m
.56912 .60778 L
s
.56056 .6052 m
.56699 .60689 L
s
.55432 .59708 m
.56029 .59826 L
s
.59876 .6522 m
.6076 .65754 L
s
.57837 .6281 m
.586 .63136 L
s
.50662 .5295 m
.50833 .52753 L
s
.69199 .75336 m
.70413 .77124 L
s
.69063 .75296 m
.70272 .77052 L
s
.5042 .52569 m
.50566 .52361 L
s
.72572 .79336 m
.73795 .81637 L
s
.74202 .81256 m
.75413 .83823 L
s
.63213 .69002 m
.64254 .69928 L
s
.54629 .58814 m
.5516 .58863 L
s
.60533 .66106 m
.61447 .66705 L
s
.57923 .63064 m
.58687 .63391 L
s
.62288 .67773 m
.6329 .68607 L
s
.54699 .58953 m
.55235 .59006 L
s
.62342 .68124 m
.63342 .68935 L
s
.62435 .67948 m
.63442 .68799 L
s
.62651 .68186 m
.63668 .69063 L
s
.5158 .54541 m
.51842 .54389 L
s
.59546 .64739 m
.60408 .65256 L
s
.76473 .83997 m
.77642 .86945 L
s
.68851 .75184 m
.70046 .76896 L
s
.53768 .57611 m
.54229 .57607 L
s
.6944 .75743 m
.70644 .77554 L
s
.58772 .64158 m
.59586 .64565 L
s
.51091 .53884 m
.51305 .53702 L
s
.55001 .59294 m
.5556 .59382 L
s
.57798 .63033 m
.5855 .63343 L
s
.73613 .80659 m
.74816 .83116 L
s
.58575 .63707 m
.59377 .64119 L
s
.78091 .86021 m
.79213 .89245 L
s
.60439 .65848 m
.61345 .66458 L
s
.58695 .64161 m
.59501 .64556 L
s
.76702 .84365 m
.77854 .87339 L
s
.56344 .61087 m
.57 .61284 L
s
.58607 .63801 m
.5941 .64213 L
s
.72612 .79587 m
.73812 .81871 L
s
.55696 .60313 m
.56305 .60453 L
s
.50288 .52794 m
.5042 .52569 L
s
.50507 .53167 m
.50662 .5295 L
s
.70261 .76828 m
.71459 .78749 L
s
.73602 .80726 m
.74795 .83172 L
s
.62229 .68218 m
.63213 .69002 L
s
.52702 .56452 m
.53067 .56358 L
s
.58953 .64577 m
.5977 .64992 L
s
.57681 .63075 m
.58421 .63365 L
s
.58193 .63696 m
.58965 .64035 L
s
.57154 .6246 m
.57859 .62701 L
s
.66094 .72299 m
.67221 .73599 L
s
.65001 .71153 m
.66094 .72299 L
s
.71853 .78726 m
.73049 .80887 L
s
.5881 .64144 m
.5962 .64572 L
s
.66073 .72059 m
.67204 .73377 L
s
.64978 .70892 m
.66073 .72059 L
s
.67204 .73377 m
.68358 .74848 L
s
.53825 .58014 m
.54286 .58003 L
s
.83745 .9316 m
.84635 .97438 L
s
.67221 .73599 m
.6837 .75053 L
s
.59057 .648 m
.59876 .6522 L
s
.61401 .67447 m
.62342 .68124 L
s
.61693 .67442 m
.62651 .68186 L
s
.63952 .70157 m
.65001 .71153 L
s
.70272 .77052 m
.71456 .78954 L
s
.61347 .67071 m
.62288 .67773 L
s
.54889 .59657 m
.55432 .59708 L
s
.5547 .60425 m
.56056 .6052 L
s
.61487 .67229 m
.62435 .67948 L
s
.70413 .77124 m
.71599 .79056 L
s
.55651 .60444 m
.56252 .60574 L
s
.7198 .79011 m
.73166 .81177 L
s
.63927 .69872 m
.64978 .70892 L
s
.57136 .62577 m
.57837 .6281 L
s
.59683 .65626 m
.60533 .66106 L
s
.51343 .54721 m
.5158 .54541 L
s
.76207 .83979 m
.77341 .8684 L
s
.78139 .86313 m
.79227 .8951 L
s
.50898 .54089 m
.51091 .53884 L
s
.73627 .80974 m
.74797 .83398 L
s
.70046 .76896 m
.7122 .78754 L
s
.68358 .74848 m
.69518 .7647 L
s
.54147 .58823 m
.54629 .58814 L
s
.66158 .72586 m
.67272 .73878 L
s
.65076 .71446 m
.66158 .72586 L
s
.57221 .62831 m
.57923 .63064 L
s
.6837 .75053 m
.69524 .76658 L
s
.50169 .53034 m
.50288 .52794 L
s
.54212 .58959 m
.54699 .58953 L
s
.58748 .64329 m
.59546 .64739 L
s
.62952 .69302 m
.63952 .70157 L
s
.50369 .53402 m
.50507 .53167 L
s
.61303 .67566 m
.62229 .68218 L
s
.53351 .57664 m
.53768 .57611 L
s
.73777 .81225 m
.74936 .83665 L
s
.58022 .63854 m
.58772 .64158 L
s
.67272 .73878 m
.68405 .75321 L
s
.64036 .70452 m
.65076 .71446 L
s
.70644 .77554 m
.71815 .79504 L
s
.62928 .68991 m
.63927 .69872 L
s
.59597 .65352 m
.60439 .65848 L
s
.57107 .62815 m
.57798 .63033 L
s
.54492 .59267 m
.55001 .59294 L
s
.57952 .63868 m
.58695 .64161 L
s
.57836 .63393 m
.58575 .63707 L
s
.52373 .56583 m
.52702 .56452 L
s
.57868 .63485 m
.58607 .63801 L
s
.7372 .8124 m
.74867 .83659 L
s
.60521 .66895 m
.61401 .67447 L
s
.66014 .72628 m
.6711 .73884 L
s
.64949 .7152 m
.66014 .72628 L
s
.55745 .60964 m
.56344 .61087 L
s
.58199 .64265 m
.58953 .64577 L
s
.63044 .69599 m
.64036 .70452 L
s
.60796 .66822 m
.61693 .67442 L
s
.74237 .81904 m
.75374 .84401 L
s
.55141 .6024 m
.55696 .60313 L
s
.73445 .80955 m
.74591 .83325 L
s
.57483 .63453 m
.58193 .63696 L
s
.60601 .66633 m
.61487 .67229 L
s
.60467 .66489 m
.61347 .67071 L
s
.57001 .62875 m
.57681 .63075 L
s
.66634 .73357 m
.6774 .74695 L
s
.65552 .72167 m
.66634 .73357 L
s
.64506 .71124 m
.65552 .72167 L
s
.6711 .73884 m
.68226 .75288 L
s
.7937 .88046 m
.80384 .91428 L
s
.68405 .75321 m
.6954 .76909 L
s
.63926 .70556 m
.64949 .7152 L
s
.62007 .68583 m
.62952 .69302 L
s
.50725 .54315 m
.50898 .54089 L
s
.58062 .63814 m
.5881 .64144 L
s
.5113 .54927 m
.51343 .54721 L
s
.56508 .62304 m
.57154 .6246 L
s
.58299 .64484 m
.59057 .648 L
s
.53408 .58073 m
.53825 .58014 L
s
.50063 .53289 m
.50169 .53034 L
s
.69518 .7647 m
.70662 .78231 L
s
.50244 .53653 m
.50369 .53402 L
s
.58894 .65255 m
.59683 .65626 L
s
.61983 .68241 m
.62928 .68991 L
s
.54395 .59668 m
.54889 .59657 L
s
.63504 .70222 m
.64506 .71124 L
s
.69524 .76658 m
.70662 .78402 L
s
.54936 .60398 m
.5547 .60425 L
s
.71459 .78749 m
.72603 .80796 L
s
.6774 .74695 m
.68857 .76178 L
s
.55103 .6038 m
.55651 .60444 L
s
.56494 .62429 m
.57136 .62577 L
s
.60436 .67037 m
.61303 .67566 L
s
.62949 .6973 m
.63926 .70556 L
s
.74941 .82891 m
.76047 .85483 L
s
.68226 .75288 m
.69344 .76836 L
s
.66528 .73171 m
.67623 .74504 L
s
.65458 .71982 m
.66528 .73171 L
s
.62103 .6888 m
.63044 .69599 L
s
.53709 .58886 m
.54147 .58823 L
s
.64425 .70933 m
.65458 .71982 L
s
.79142 .87935 m
.80139 .91249 L
s
.53771 .59019 m
.54212 .58959 L
s
.56577 .62682 m
.57221 .62831 L
s
.52973 .5776 m
.53351 .57664 L
s
.71456 .78954 m
.72586 .80978 L
s
.58012 .64014 m
.58748 .64329 L
s
.73795 .81637 m
.74907 .8403 L
s
.57332 .63641 m
.58022 .63854 L
s
.71599 .79056 m
.72728 .81108 L
s
.67623 .74504 m
.68729 .75978 L
s
.58816 .6496 m
.59597 .65352 L
s
.62551 .69455 m
.63504 .70222 L
s
.52075 .5675 m
.52373 .56583 L
s
.61117 .6799 m
.62007 .68583 L
s
.597 .66457 m
.60521 .66895 L
s
.49966 .53558 m
.50063 .53289 L
s
.7122 .78754 m
.72343 .80735 L
s
.56473 .6268 m
.57107 .62815 L
s
.50569 .54561 m
.50725 .54315 L
s
.63435 .7002 m
.64425 .70933 L
s
.57268 .63666 m
.57952 .63868 L
s
.54031 .59294 m
.54492 .59267 L
s
.50131 .5392 m
.50244 .53653 L
s
.59959 .66315 m
.60796 .66822 L
s
.6954 .76909 m
.70655 .78634 L
s
.50938 .55156 m
.5113 .54927 L
s
.75463 .83665 m
.76538 .86322 L
s
.75597 .83826 m
.7667 .86505 L
s
.75202 .83366 m
.76282 .85979 L
s
.57156 .63164 m
.57836 .63393 L
s
.68857 .76178 m
.69965 .778 L
s
.62024 .69036 m
.62949 .6973 L
s
.59774 .66147 m
.60601 .66633 L
s
.59648 .66017 m
.60467 .66489 L
s
.57503 .64047 m
.58199 .64265 L
s
.61094 .67612 m
.61983 .68241 L
s
.57188 .63256 m
.57868 .63485 L
s
.77947 .86681 m
.78953 .89753 L
s
.73049 .80887 m
.74151 .83146 L
s
.55198 .60906 m
.55745 .60964 L
s
.5683 .63296 m
.57483 .63453 L
s
.54636 .60227 m
.55141 .6024 L
s
.61217 .68287 m
.62103 .6888 L
s
.56378 .62756 m
.57001 .62875 L
s
.57601 .64262 m
.58299 .64484 L
s
.53029 .58175 m
.53408 .58073 L
s
.55916 .62225 m
.56508 .62304 L
s
.71815 .79504 m
.7292 .81567 L
s
.57374 .63572 m
.58062 .63814 L
s
.59628 .6662 m
.60436 .67037 L
s
.69344 .76836 m
.70445 .78517 L
s
.73812 .81871 m
.74898 .84241 L
s
.68729 .75978 m
.69829 .77587 L
s
.58165 .64985 m
.58894 .65255 L
s
.61649 .68816 m
.62551 .69455 L
s
.62494 .69235 m
.63435 .7002 L
s
.53947 .59733 m
.54395 .59668 L
s
.70662 .78231 m
.71765 .80115 L
s
.73166 .81177 m
.74253 .83438 L
s
.54449 .6043 m
.54936 .60398 L
s
.77387 .86119 m
.78394 .89077 L
s
.49879 .5384 m
.49966 .53558 L
s
.8225 .92071 m
.83074 .95909 L
s
.55906 .62356 m
.56494 .62429 L
s
.54603 .60376 m
.55103 .6038 L
s
.75413 .83823 m
.76461 .86442 L
s
.70662 .78402 m
.71756 .80269 L
s
.5003 .54202 m
.50131 .5392 L
s
.50428 .54826 m
.50569 .54561 L
s
.53312 .58996 m
.53709 .58886 L
s
.74816 .83116 m
.75873 .85637 L
s
.60283 .67513 m
.61117 .6799 L
s
.61152 .68464 m
.62024 .69036 L
s
.52631 .57895 m
.52973 .5776 L
s
.5337 .59128 m
.53771 .59019 L
s
.50765 .55407 m
.50938 .55156 L
s
.51806 .56949 m
.52075 .5675 L
s
.55987 .62609 m
.56577 .62682 L
s
.66188 .73609 m
.67232 .74826 L
s
.65168 .72529 m
.66188 .73609 L
s
.58937 .66125 m
.597 .66457 L
s
.56697 .63513 m
.57332 .63641 L
s
.64182 .71586 m
.65168 .72529 L
s
.57335 .63786 m
.58012 .64014 L
s
.74795 .83172 m
.75842 .85679 L
s
.58095 .64661 m
.58816 .6496 L
s
.66337 .73502 m
.67384 .74765 L
s
.65312 .72374 m
.66337 .73502 L
s
.59181 .65911 m
.59959 .66315 L
s
.60263 .67095 m
.61094 .67612 L
s
.60386 .6781 m
.61217 .68287 L
s
.6432 .71377 m
.65312 .72374 L
s
.55892 .62621 m
.56473 .6268 L
s
.5664 .63547 m
.57268 .63666 L
s
.65874 .73365 m
.66905 .74532 L
s
.6487 .72334 m
.65874 .73365 L
s
.53611 .59369 m
.54031 .59294 L
s
.67232 .74826 m
.68285 .76178 L
s
.69965 .778 m
.71042 .79545 L
s
.59007 .65762 m
.59774 .66147 L
s
.61606 .68571 m
.62494 .69235 L
s
.60801 .68296 m
.61649 .68816 L
s
.58887 .65645 m
.59648 .66017 L
s
.63235 .70775 m
.64182 .71586 L
s
.639 .71437 m
.6487 .72334 L
s
.49801 .54134 m
.49879 .5384 L
s
.67384 .74765 m
.68441 .76161 L
s
.66905 .74532 m
.67949 .75835 L
s
.56533 .63014 m
.57156 .63164 L
s
.56863 .63914 m
.57503 .64047 L
s
.70655 .78634 m
.71726 .80474 L
s
.58876 .66308 m
.59628 .6662 L
s
.49938 .54499 m
.5003 .54202 L
s
.56564 .63105 m
.57188 .63256 L
s
.69829 .77587 m
.70899 .79318 L
s
.63369 .70509 m
.6432 .71377 L
s
.56231 .63218 m
.5683 .63296 L
s
.52686 .58315 m
.53029 .58175 L
s
.55807 .62712 m
.56378 .62756 L
s
.56958 .64125 m
.57601 .64262 L
s
.547 .60907 m
.55198 .60906 L
s
.50301 .55108 m
.50428 .54826 L
s
.54176 .60268 m
.54636 .60227 L
s
.78444 .87682 m
.79374 .90778 L
s
.72603 .80796 m
.7366 .82935 L
s
.82975 .93261 m
.83714 .97185 L
s
.57491 .64805 m
.58165 .64985 L
s
.55375 .62215 m
.55916 .62225 L
s
.62972 .7067 m
.639 .71437 L
s
.74797 .83398 m
.75819 .85877 L
s
.66321 .73688 m
.67352 .74933 L
s
.65312 .72574 m
.66321 .73688 L
s
.60333 .68008 m
.61152 .68464 L
s
.56742 .63409 m
.57374 .63572 L
s
.53539 .59849 m
.53947 .59733 L
s
.50608 .55678 m
.50765 .55407 L
s
.64333 .7159 m
.65312 .72574 L
s
.59505 .67146 m
.60283 .67513 L
s
.62333 .7009 m
.63235 .70775 L
s
.70445 .78517 m
.71503 .80314 L
s
.54006 .60518 m
.54449 .6043 L
s
.68285 .76178 m
.69333 .77659 L
s
.67949 .75835 m
.68992 .77266 L
s
.51563 .57178 m
.51806 .56949 L
s
.55368 .62353 m
.55906 .62356 L
s
.52951 .5915 m
.53312 .58996 L
s
.67352 .74933 m
.68391 .76306 L
s
.68441 .76161 m
.6949 .77682 L
s
.54149 .60424 m
.54603 .60376 L
s
.52321 .58065 m
.52631 .57895 L
s
.74936 .83665 m
.75941 .86151 L
s
.72586 .80978 m
.73625 .83092 L
s
.53005 .59281 m
.5337 .59128 L
s
.83788 .94402 m
.84464 .9846 L
s
.62463 .69763 m
.63369 .70509 L
s
.4973 .54439 m
.49801 .54134 L
s
.63394 .70732 m
.64333 .7159 L
s
.58229 .65891 m
.58937 .66125 L
s
.72343 .80735 m
.73381 .82807 L
s
.59609 .67442 m
.60386 .6781 L
s
.72728 .81108 m
.73762 .83246 L
s
.6077 .68019 m
.61606 .68571 L
s
.60006 .67888 m
.60801 .68296 L
s
.62088 .70027 m
.62972 .7067 L
s
.55447 .62607 m
.55987 .62609 L
s
.49855 .5481 m
.49938 .54499 L
s
.56114 .63462 m
.56697 .63513 L
s
.59488 .6668 m
.60263 .67095 L
s
.74591 .83325 m
.7559 .85747 L
s
.5743 .64446 m
.58095 .64661 L
s
.56712 .63636 m
.57335 .63786 L
s
.5846 .656 m
.59181 .65911 L
s
.74867 .83659 m
.7586 .86123 L
s
.77642 .86945 m
.78564 .89868 L
s
.50186 .55408 m
.50301 .55108 L
s
.66075 .73651 m
.67083 .74844 L
s
.6509 .72584 m
.66075 .73651 L
s
.61479 .69526 m
.62333 .7009 L
s
.56062 .63504 m
.5664 .63547 L
s
.5536 .62631 m
.55892 .62621 L
s
.5323 .59487 m
.53611 .59369 L
s
.58296 .65469 m
.59007 .65762 L
s
.64136 .71643 m
.6509 .72584 L
s
.71765 .80115 m
.72795 .82094 L
s
.58184 .65363 m
.58887 .65645 L
s
.68391 .76306 m
.6942 .77801 L
s
.58179 .66091 m
.58876 .66308 L
s
.67083 .74844 m
.68099 .76163 L
s
.50467 .55969 m
.50608 .55678 L
s
.62498 .69993 m
.63394 .70732 L
s
.56275 .63859 m
.56863 .63914 L
s
.59568 .67659 m
.60333 .68008 L
s
.52375 .58491 m
.52686 .58315 L
s
.55961 .62933 m
.56533 .63014 L
s
.71756 .80269 m
.72777 .8223 L
s
.80941 .91054 m
.81721 .94539 L
s
.75374 .84401 m
.76339 .86927 L
s
.55682 .63212 m
.56231 .63218 L
s
.68992 .77266 m
.70015 .78817 L
s
.56366 .64068 m
.56958 .64125 L
s
.61605 .69131 m
.62463 .69763 L
s
.49666 .54757 m
.4973 .54439 L
s
.55284 .62735 m
.55807 .62712 L
s
.5878 .66879 m
.59505 .67146 L
s
.55992 .63023 m
.56564 .63105 L
s
.77854 .87339 m
.78747 .90276 L
s
.69333 .77659 m
.70355 .79257 L
s
.56871 .64708 m
.57491 .64805 L
s
.63221 .70824 m
.64136 .71643 L
s
.61253 .69501 m
.62088 .70027 L
s
.53758 .60356 m
.54176 .60268 L
s
.54246 .60961 m
.547 .60907 L
s
.5488 .62269 m
.55375 .62215 L
s
.51342 .57434 m
.51563 .57178 L
s
.7292 .81567 m
.73924 .83705 L
s
.53168 .60009 m
.53539 .59849 L
s
.71042 .79545 m
.7206 .81391 L
s
.4978 .55134 m
.49855 .5481 L
s
.6949 .77682 m
.70511 .79315 L
s
.53603 .60655 m
.54006 .60518 L
s
.65795 .7399 m
.66773 .7509 L
s
.64838 .73017 m
.65795 .7399 L
s
.52624 .59344 m
.52951 .5915 L
s
.56162 .63316 m
.56742 .63409 L
s
.63911 .7217 m
.64838 .73017 L
s
.5204 .58266 m
.52321 .58065 L
s
.65884 .7412 m
.66861 .75229 L
s
.64927 .73138 m
.65884 .7412 L
s
.70899 .79318 m
.71913 .81148 L
s
.63998 .72282 m
.64927 .73138 L
s
.68099 .76163 m
.69109 .77601 L
s
.52675 .59474 m
.53005 .59281 L
s
.59264 .67583 m
.60006 .67888 L
s
.54876 .62413 m
.55368 .62353 L
s
.58886 .67175 m
.59609 .67442 L
s
.50082 .55723 m
.50186 .55408 L
s
.59989 .6757 m
.6077 .68019 L
s
.60674 .69074 m
.61479 .69526 L
s
.77341 .8684 m
.78234 .89672 L
s
.66773 .7509 m
.67761 .76315 L
s
.57574 .65745 m
.58229 .65891 L
s
.65779 .73605 m
.66757 .74737 L
s
.64822 .72594 m
.65779 .73605 L
s
.53736 .6052 m
.54149 .60424 L
s
.74907 .8403 m
.7586 .86458 L
s
.6165 .69367 m
.62498 .69993 L
s
.46461 .49992 m
.46173 .49561 L
s
.46717 .50416 m
.46461 .49992 L
s
.46173 .49561 m
.45851 .49123 L
s
.63019 .71446 m
.63911 .7217 L
s
.66861 .75229 m
.67846 .76462 L
s
.66757 .74737 m
.67747 .75992 L
s
.46947 .50834 m
.46717 .50416 L
s
.63105 .71549 m
.63998 .72282 L
s
.63897 .71705 m
.64822 .72594 L
s
.62348 .7012 m
.63221 .70824 L
s
.74151 .83146 m
.75116 .85454 L
s
.58769 .66358 m
.59488 .6668 L
s
.45851 .49123 m
.4549 .48675 L
s
.54952 .62668 m
.55447 .62607 L
s
.50339 .56279 m
.50467 .55969 L
s
.71726 .80474 m
.7272 .82403 L
s
.55579 .6348 m
.56114 .63462 L
s
.47151 .51248 m
.46947 .50834 L
s
.49607 .55085 m
.49666 .54757 L
s
.57793 .65373 m
.5846 .656 L
s
.4549 .48675 m
.45085 .48218 L
s
.6942 .77801 m
.7042 .79404 L
s
.56818 .64307 m
.5743 .64446 L
s
.60466 .69086 m
.61253 .69501 L
s
.52884 .59644 m
.5323 .59487 L
s
.56141 .63554 m
.56712 .63636 L
s
.55533 .6353 m
.56062 .63504 L
s
.60798 .68606 m
.61605 .69131 L
s
.58854 .67409 m
.59568 .67659 L
s
.54873 .62703 m
.5536 .62631 L
s
.49713 .55471 m
.4978 .55134 L
s
.47334 .51659 m
.47151 .51248 L
s
.71503 .80314 m
.7249 .82199 L
s
.57533 .65962 m
.58179 .66091 L
s
.5764 .65259 m
.58296 .65469 L
s
.76047 .85483 m
.76954 .88076 L
s
.79213 .89245 m
.80016 .92372 L
s
.67761 .76315 m
.68744 .77659 L
s
.6301 .70932 m
.63897 .71705 L
s
.57534 .65163 m
.58184 .65363 L
s
.62169 .70841 m
.63019 .71446 L
s
.46272 .50001 m
.45964 .49561 L
s
.46546 .50433 m
.46272 .50001 L
s
.52094 .58698 m
.52375 .58491 L
s
.67747 .75992 m
.68734 .77362 L
s
.74253 .83438 m
.75198 .8574 L
s
.62252 .70935 m
.63105 .71549 L
s
.55735 .63875 m
.56275 .63859 L
s
.46791 .5086 m
.46546 .50433 L
s
.45964 .49561 m
.4562 .49113 L
s
.51143 .57716 m
.51342 .57434 L
s
.45085 .48218 m
.44631 .47751 L
s
.58107 .66705 m
.5878 .66879 L
s
.47497 .52066 m
.47334 .51659 L
s
.67846 .76462 m
.68825 .77812 L
s
.4701 .51282 m
.46791 .5086 L
s
.49988 .56054 m
.50082 .55723 L
s
.4562 .49113 m
.45234 .48657 L
s
.55179 .63271 m
.55682 .63212 L
s
.55822 .64081 m
.56366 .64068 L
s
.54805 .6282 m
.55284 .62735 L
s
.74898 .84241 m
.75821 .86636 L
s
.59919 .6873 m
.60674 .69074 L
s
.55438 .62914 m
.55961 .62933 L
s
.5283 .60212 m
.53168 .60009 L
s
.56299 .64688 m
.56871 .64708 L
s
.69109 .77601 m
.70093 .79146 L
s
.47206 .517 m
.4701 .51282 L
s
.70015 .78817 m
.70994 .8047 L
s
.54427 .6238 m
.5488 .62269 L
s
.53378 .60487 m
.53758 .60356 L
s
.61522 .69526 m
.62348 .7012 L
s
.52327 .59575 m
.52624 .59344 L
s
.53833 .61062 m
.54246 .60961 L
s
.55469 .63004 m
.55992 .63023 L
s
.53236 .60838 m
.53603 .60655 L
s
.60851 .68847 m
.6165 .69367 L
s
.58573 .67375 m
.59264 .67583 L
s
.51786 .58495 m
.5204 .58266 L
s
.47643 .52473 m
.47497 .52066 L
s
.45234 .48657 m
.44802 .4819 L
s
.58213 .67 m
.58886 .67175 L
s
.49554 .55423 m
.49607 .55085 L
s
.52374 .59705 m
.52675 .59474 L
s
.50223 .56606 m
.50339 .56279 L
s
.5926 .67215 m
.59989 .6757 L
s
.44631 .47751 m
.44122 .47273 L
s
.47381 .52114 m
.47206 .517 L
s
.70355 .79257 m
.71326 .80951 L
s
.66023 .7424 m
.66975 .75374 L
s
.65087 .73223 m
.66023 .7424 L
s
.62165 .7027 m
.6301 .70932 L
s
.54426 .6253 m
.54876 .62413 L
s
.64178 .72323 m
.65087 .73223 L
s
.55631 .63287 m
.56162 .63316 L
s
.61361 .7035 m
.62169 .70841 L
s
.56969 .65682 m
.57574 .65745 L
s
.49651 .55822 m
.49713 .55471 L
s
.61442 .70434 m
.62252 .70935 L
s
.76282 .85979 m
.77151 .88577 L
s
.70511 .79315 m
.71478 .81041 L
s
.59727 .68775 m
.60466 .69086 L
s
.5336 .60657 m
.53736 .6052 L
s
.47774 .52878 m
.47643 .52473 L
s
.44802 .4819 m
.44317 .47713 L
s
.66975 .75374 m
.67933 .76622 L
s
.47537 .52527 m
.47381 .52114 L
s
.7366 .82935 m
.74586 .85119 L
s
.79227 .8951 m
.79989 .92597 L
s
.76538 .86322 m
.77394 .88956 L
s
.58102 .6612 m
.58769 .66358 L
s
.68734 .77362 m
.69699 .78838 L
s
.545 .62787 m
.54952 .62668 L
s
.60041 .68179 m
.60798 .68606 L
s
.68744 .77659 m
.69704 .7911 L
s
.63302 .71535 m
.64178 .72323 L
s
.55089 .63562 m
.55579 .6348 L
s
.7667 .86505 m
.77517 .89156 L
s
.49902 .564 m
.49988 .56054 L
s
.5819 .67252 m
.58854 .67409 L
s
.44122 .47273 m
.43551 .46784 L
s
.50962 .58022 m
.51143 .57716 L
s
.5257 .59836 m
.52884 .59644 L
s
.68825 .77812 m
.69778 .79268 L
s
.55047 .6362 m
.55533 .6353 L
s
.56937 .65915 m
.57533 .65962 L
s
.47677 .52939 m
.47537 .52527 L
s
.54428 .62832 m
.54873 .62703 L
s
.57179 .65223 m
.57793 .65373 L
s
.47891 .53284 m
.47774 .52878 L
s
.51838 .58933 m
.52094 .58698 L
s
.56256 .64236 m
.56818 .64307 L
s
.59211 .68484 m
.59919 .6873 L
s
.49506 .55772 m
.49554 .55423 L
s
.73381 .82807 m
.74295 .84927 L
s
.60743 .69033 m
.61522 .69526 L
s
.44317 .47713 m
.43773 .47226 L
s
.55618 .63535 m
.56141 .63554 L
s
.75873 .85637 m
.76731 .88149 L
s
.57484 .66616 m
.58107 .66705 L
s
.73625 .83092 m
.74533 .85248 L
s
.57035 .65123 m
.5764 .65259 L
s
.55239 .63956 m
.55735 .63875 L
s
.72795 .82094 m
.73717 .84129 L
s
.56935 .65037 m
.57534 .65163 L
s
.50118 .5695 m
.50223 .56606 L
s
.61365 .69712 m
.62165 .7027 L
s
.7042 .79404 m
.71367 .81096 L
s
.60676 .70042 m
.61442 .70434 L
s
.60598 .69966 m
.61361 .7035 L
s
.67933 .76622 m
.6888 .77977 L
s
.49595 .56185 m
.49651 .55822 L
s
.60101 .68423 m
.60851 .68847 L
s
.52523 .60454 m
.5283 .60212 L
s
.62465 .70857 m
.63302 .71535 L
s
.7206 .81391 m
.72987 .83305 L
s
.54717 .6339 m
.55179 .63271 L
s
.55323 .64162 m
.55822 .64081 L
s
.73762 .83246 m
.74662 .8542 L
s
.52057 .59841 m
.52327 .59575 L
s
.54367 .62962 m
.54805 .6282 L
s
.47803 .53351 m
.47677 .52939 L
s
.55773 .64738 m
.56299 .64688 L
s
.5793 .67256 m
.58573 .67375 L
s
.75842 .85679 m
.7669 .88174 L
s
.71913 .81148 m
.7284 .83046 L
s
.51555 .5875 m
.51786 .58495 L
s
.47995 .5369 m
.47891 .53284 L
s
.54013 .62545 m
.54427 .6238 L
s
.65473 .73963 m
.66389 .75003 L
s
.64576 .73036 m
.65473 .73963 L
s
.72777 .8223 m
.73689 .84245 L
s
.52901 .61064 m
.53236 .60838 L
s
.57588 .66913 m
.58213 .67 L
s
.76461 .86442 m
.77287 .89031 L
s
.52101 .5997 m
.52374 .59705 L
s
.53032 .60657 m
.53378 .60487 L
s
.5496 .62951 m
.55438 .62914 L
s
.66389 .75003 m
.67316 .76152 L
s
.53457 .61205 m
.53833 .61062 L
s
.58583 .66946 m
.5926 .67215 L
s
.59036 .68562 m
.59727 .68775 L
s
.43551 .46784 m
.4291 .46285 L
s
.70093 .79146 m
.71029 .80781 L
s
.63707 .72219 m
.64576 .73036 L
s
.49825 .56762 m
.49902 .564 L
s
.5499 .6304 m
.55469 .63004 L
s
.54015 .62701 m
.54426 .6253 L
s
.56411 .65695 m
.56969 .65682 L
s
.43773 .47226 m
.43164 .46729 L
s
.47914 .53763 m
.47803 .53351 L
s
.55145 .63315 m
.55631 .63287 L
s
.59335 .67843 m
.60041 .68179 L
s
.50798 .58351 m
.50962 .58022 L
s
.49462 .56131 m
.49506 .55772 L
s
.48088 .54098 m
.47995 .5369 L
s
.53018 .60833 m
.5336 .60657 L
s
.67316 .76152 m
.68239 .77407 L
s
.57574 .6718 m
.5819 .67252 L
s
.45962 .50771 m
.4563 .50308 L
s
.46258 .51227 m
.45962 .50771 L
s
.54086 .62961 m
.545 .62787 L
s
.6167 .70281 m
.62465 .70857 L
s
.46524 .51678 m
.46258 .51227 L
s
.49544 .56562 m
.49595 .56185 L
s
.62873 .7151 m
.63707 .72219 L
s
.54639 .63704 m
.55089 .63562 L
s
.4563 .50308 m
.45259 .49838 L
s
.69699 .78838 m
.70622 .80404 L
s
.50023 .57311 m
.50118 .5695 L
s
.57486 .65958 m
.58102 .6612 L
s
.59954 .69752 m
.60676 .70042 L
s
.59879 .69684 m
.60598 .69966 L
s
.70994 .8047 m
.71904 .82198 L
s
.75819 .85877 m
.76638 .88336 L
s
.46761 .52124 m
.46524 .51678 L
s
.5855 .68332 m
.59211 .68484 L
s
.69704 .7911 m
.7062 .80652 L
s
.60013 .68634 m
.60743 .69033 L
s
.60612 .69253 m
.61365 .69712 L
s
.51606 .59195 m
.51838 .58933 L
s
.52285 .60059 m
.5257 .59836 L
s
.56386 .65943 m
.56937 .65915 L
s
.45259 .49838 m
.44844 .4936 L
s
.48015 .54176 m
.47914 .53763 L
s
.5402 .63015 m
.54428 .62832 L
s
.6888 .77977 m
.69799 .79427 L
s
.54602 .63769 m
.55047 .6362 L
s
.7272 .82403 m
.73603 .84379 L
s
.46974 .52566 m
.46761 .52124 L
s
.73924 .83705 m
.74784 .85867 L
s
.56906 .66608 m
.57484 .66616 L
s
.56613 .65141 m
.57179 .65223 L
s
.69778 .79268 m
.70686 .80812 L
s
.59401 .68089 m
.60101 .68423 L
s
.48172 .54508 m
.48088 .54098 L
s
.54784 .64098 m
.55239 .63956 L
s
.7249 .82199 m
.7337 .84135 L
s
.52244 .60732 m
.52523 .60454 L
s
.49754 .57138 m
.49825 .56762 L
s
.51811 .60139 m
.52057 .59841 L
s
.4291 .46285 m
.42191 .45777 L
s
.65437 .7425 m
.66326 .75259 L
s
.64566 .73349 m
.65437 .7425 L
s
.44844 .4936 m
.4438 .48873 L
s
.55741 .64225 m
.56256 .64236 L
s
.71326 .80951 m
.72218 .82713 L
s
.47165 .53006 m
.46974 .52566 L
s
.43164 .46729 m
.4248 .46223 L
s
.57334 .67221 m
.5793 .67256 L
s
.55139 .63571 m
.55618 .63535 L
s
.56479 .65054 m
.57035 .65123 L
s
.51346 .59029 m
.51555 .5875 L
s
.80384 .91428 m
.8101 .94624 L
s
.75941 .86151 m
.76738 .8861 L
s
.54295 .63565 m
.54717 .6339 L
s
.51852 .60269 m
.52101 .5997 L
s
.54865 .64303 m
.55323 .64162 L
s
.66326 .75259 m
.67223 .76373 L
s
.53966 .63157 m
.54367 .62962 L
s
.56385 .64976 m
.56935 .65037 L
s
.57009 .66906 m
.57588 .66913 L
s
.5839 .68439 m
.59036 .68562 L
s
.55289 .64853 m
.55773 .64738 L
s
.52596 .6133 m
.52901 .61064 L
s
.62077 .70902 m
.62873 .7151 L
s
.63721 .72553 m
.64566 .73349 L
s
.53635 .62759 m
.54013 .62545 L
s
.7559 .85747 m
.76393 .88148 L
s
.49422 .565 m
.49462 .56131 L
s
.68239 .77407 m
.69143 .78759 L
s
.78394 .89077 m
.79098 .91927 L
s
.48104 .54591 m
.48015 .54176 L
s
.71478 .81041 m
.72363 .8283 L
s
.78953 .89753 m
.79634 .92695 L
s
.52718 .60861 m
.53032 .60657 L
s
.47335 .53443 m
.47165 .53006 L
s
.49497 .56951 m
.49544 .56562 L
s
.50648 .58703 m
.50798 .58351 L
s
.60918 .69803 m
.6167 .70281 L
s
.4438 .48873 m
.4386 .48378 L
s
.57956 .66755 m
.58583 .66946 L
s
.53114 .61386 m
.53457 .61205 L
s
.65162 .7408 m
.66036 .75045 L
s
.64307 .7322 m
.65162 .7408 L
s
.7586 .86123 m
.76645 .88557 L
s
.49936 .57688 m
.50023 .57311 L
s
.54523 .63037 m
.5496 .62951 L
s
.66036 .75045 m
.6692 .76114 L
s
.55895 .65779 m
.56411 .65695 L
s
.48246 .54921 m
.48172 .54508 L
s
.53638 .62921 m
.54015 .62701 L
s
.59276 .69559 m
.59954 .69752 L
s
.80139 .91249 m
.80755 .94381 L
s
.59205 .69498 m
.59879 .69684 L
s
.67223 .76373 m
.68115 .77586 L
s
.62908 .7186 m
.63721 .72553 L
s
.54552 .63126 m
.5499 .6304 L
s
.58678 .6759 m
.59335 .67843 L
s
.6348 .72464 m
.64307 .7322 L
s
.57002 .67189 m
.57574 .6718 L
s
.47488 .5388 m
.47335 .53443 L
s
.57934 .68267 m
.5855 .68332 L
s
.59905 .68883 m
.60612 .69253 L
s
.52707 .61043 m
.53018 .60833 L
s
.53707 .63184 m
.54086 .62961 L
s
.6692 .76114 m
.67803 .77283 L
s
.48184 .55009 m
.48104 .54591 L
s
.4969 .57528 m
.49754 .57138 L
s
.59331 .68322 m
.60013 .68634 L
s
.54227 .63901 m
.54639 .63704 L
s
.54701 .63393 m
.55145 .63315 L
s
.51396 .5948 m
.51606 .59195 L
s
.71367 .81096 m
.72231 .82848 L
s
.65509 .74605 m
.66375 .75599 L
s
.64658 .73713 m
.65509 .74605 L
s
.4386 .48378 m
.43279 .47874 L
s
.61322 .70392 m
.62077 .70902 L
s
.55877 .66042 m
.56386 .65943 L
s
.52026 .60311 m
.52285 .60059 L
s
.56918 .65866 m
.57486 .65958 L
s
.53647 .63248 m
.5402 .63015 L
s
.63829 .72923 m
.64658 .73713 L
s
.54193 .63973 m
.54602 .63769 L
s
.56371 .66675 m
.56906 .66608 L
s
.4248 .46223 m
.41714 .4571 L
s
.49386 .56878 m
.49422 .565 L
s
.48313 .55336 m
.48246 .54921 L
s
.66375 .75599 m
.67246 .76694 L
s
.47626 .54316 m
.47488 .5388 L
s
.42191 .45777 m
.41384 .45264 L
s
.51587 .60467 m
.51811 .60139 L
s
.62685 .71808 m
.6348 .72464 L
s
.51989 .61044 m
.52244 .60732 L
s
.49455 .57353 m
.49497 .56951 L
s
.71029 .80781 m
.7189 .82477 L
s
.62131 .71266 m
.62908 .7186 L
s
.75116 .85454 m
.75894 .87743 L
s
.58749 .67838 m
.59401 .68089 L
s
.54366 .64296 m
.54784 .64098 L
s
.51626 .60598 m
.51852 .60269 L
s
.51156 .5933 m
.51346 .59029 L
s
.5678 .67263 m
.57334 .67221 L
s
.69799 .79427 m
.70668 .80954 L
s
.57788 .68403 m
.5839 .68439 L
s
.76339 .86927 m
.77076 .894 L
s
.49857 .58081 m
.49936 .57688 L
s
.52318 .61633 m
.52596 .6133 L
s
.68115 .77586 m
.68986 .7889 L
s
.56473 .66974 m
.57009 .66906 L
s
.45956 .51817 m
.45635 .51342 L
s
.46243 .52288 m
.45956 .51817 L
s
.53907 .63792 m
.54295 .63565 L
s
.45635 .51342 m
.45276 .5086 L
s
.56094 .6512 m
.56613 .65141 L
s
.50513 .59076 m
.50648 .58703 L
s
.63031 .72234 m
.63829 .72923 L
s
.54443 .64501 m
.54865 .64303 L
s
.53599 .634 m
.53966 .63157 L
s
.48256 .5543 m
.48184 .55009 L
s
.54844 .65029 m
.55289 .64853 L
s
.60212 .69415 m
.60918 .69803 L
s
.70622 .80404 m
.71477 .82035 L
s
.53289 .63019 m
.53635 .62759 L
s
.46501 .52754 m
.46243 .52288 L
s
.69143 .78759 m
.70009 .80192 L
s
.45276 .5086 m
.44876 .50371 L
s
.67803 .77283 m
.6867 .78544 L
s
.55269 .6427 m
.55741 .64225 L
s
.5864 .69457 m
.59276 .69559 L
s
.54701 .63658 m
.55139 .63571 L
s
.55968 .65045 m
.56479 .65054 L
s
.58572 .69404 m
.59205 .69498 L
s
.47748 .54753 m
.47626 .54316 L
s
.6575 .75058 m
.66603 .76065 L
s
.64909 .74149 m
.6575 .75058 L
s
.67246 .76694 m
.68109 .77882 L
s
.7586 .86458 m
.76599 .88843 L
s
.64087 .73341 m
.64909 .74149 L
s
.7062 .80652 m
.71467 .8226 L
s
.5588 .64976 m
.56385 .64976 L
s
.46732 .53216 m
.46501 .52754 L
s
.52432 .61097 m
.52718 .60861 L
s
.43279 .47874 m
.42629 .47364 L
s
.49631 .57934 m
.4969 .57528 L
s
.44876 .50371 m
.44429 .49876 L
s
.48373 .55756 m
.48313 .55336 L
s
.53293 .63188 m
.53638 .62921 L
s
.5542 .65928 m
.55895 .65779 L
s
.75198 .8574 m
.75952 .88016 L
s
.61927 .71248 m
.62685 .71808 L
s
.52803 .61601 m
.53114 .61386 L
s
.57376 .66635 m
.57956 .66755 L
s
.66603 .76065 m
.67455 .77167 L
s
.4694 .53676 m
.46732 .53216 L
s
.57361 .68285 m
.57934 .68267 L
s
.63291 .72632 m
.64087 .73341 L
s
.56472 .67273 m
.57002 .67189 L
s
.70686 .80812 m
.71522 .82419 L
s
.6061 .69972 m
.61322 .70392 L
s
.49352 .57265 m
.49386 .56878 L
s
.54125 .63168 m
.54523 .63037 L
s
.72987 .83305 m
.73787 .85242 L
s
.59245 .68597 m
.59905 .68883 L
s
.7284 .83046 m
.73644 .8497 L
s
.49415 .57769 m
.49455 .57353 L
s
.61393 .70767 m
.62131 .71266 L
s
.62266 .71641 m
.63031 .72234 L
s
.58069 .67412 m
.58678 .6759 L
s
.44429 .49876 m
.4393 .49373 L
s
.4832 .55853 m
.48256 .5543 L
s
.5336 .63455 m
.53707 .63184 L
s
.47859 .55191 m
.47748 .54753 L
s
.54153 .63257 m
.54552 .63126 L
s
.51205 .59786 m
.51396 .5948 L
s
.58696 .68089 m
.59331 .68322 L
s
.53849 .64149 m
.54227 .63901 L
s
.52424 .61283 m
.52707 .61043 L
s
.47126 .54133 m
.4694 .53676 L
s
.71904 .82198 m
.72714 .83968 L
s
.74586 .85119 m
.7534 .87289 L
s
.51383 .60825 m
.51587 .60467 L
s
.55407 .66206 m
.55877 .66042 L
s
.49785 .58491 m
.49857 .58081 L
s
.73717 .84129 m
.74491 .86168 L
s
.51757 .61389 m
.51989 .61044 L
s
.51791 .60589 m
.52026 .60311 L
s
.53305 .63527 m
.53647 .63248 L
s
.55877 .66811 m
.56371 .66675 L
s
.79374 .90778 m
.79948 .93698 L
s
.41714 .4571 m
.40856 .45195 L
s
.53818 .64228 m
.54193 .63973 L
s
.54295 .63517 m
.54701 .63393 L
s
.64635 .75115 m
.65441 .75885 L
s
.63844 .74448 m
.64635 .75115 L
s
.51419 .60957 m
.51626 .60598 L
s
.62527 .72018 m
.63291 .72632 L
s
.48426 .56179 m
.48373 .55756 L
s
.50389 .5947 m
.50513 .59076 L
s
.6554 .75062 m
.66369 .76024 L
s
.64722 .74195 m
.6554 .75062 L
s
.57228 .68448 m
.57788 .68403 L
s
.50984 .59651 m
.51156 .5933 L
s
.75821 .86636 m
.76529 .88981 L
s
.68109 .77882 m
.68949 .79155 L
s
.63075 .73886 m
.63844 .74448 L
s
.63923 .73424 m
.64722 .74195 L
s
.67455 .77167 m
.68295 .78358 L
s
.56267 .67379 m
.5678 .67263 L
s
.41384 .45264 m
.40481 .44749 L
s
.65441 .75885 m
.66255 .76756 L
s
.4393 .49373 m
.43372 .48864 L
s
.56396 .65835 m
.56918 .65866 L
s
.53982 .64548 m
.54366 .64296 L
s
.58145 .6766 m
.58749 .67838 L
s
.78564 .89868 m
.79164 .92644 L
s
.52064 .61971 m
.52318 .61633 L
s
.47293 .5459 m
.47126 .54133 L
s
.49578 .58354 m
.49631 .57934 L
s
.73689 .84245 m
.74453 .86264 L
s
.74295 .84927 m
.75043 .87035 L
s
.58045 .69443 m
.5864 .69457 L
s
.42629 .47364 m
.41901 .46848 L
s
.68986 .7889 m
.69819 .8027 L
s
.55976 .67113 m
.56473 .66974 L
s
.6867 .78544 m
.69504 .79883 L
s
.59551 .6911 m
.60212 .69415 L
s
.57981 .69396 m
.58572 .69404 L
s
.66369 .76024 m
.672 .7708 L
s
.61208 .70779 m
.61927 .71248 L
s
.47957 .5563 m
.47859 .55191 L
s
.53551 .64068 m
.53907 .63792 L
s
.53262 .63691 m
.53599 .634 L
s
.54056 .64754 m
.54443 .64501 L
s
.62332 .73427 m
.63075 .73886 L
s
.48378 .56281 m
.4832 .55853 L
s
.52972 .63323 m
.53289 .63019 L
s
.54434 .65263 m
.54844 .65029 L
s
.61538 .71139 m
.62266 .71641 L
s
.74533 .85248 m
.75268 .87385 L
s
.63151 .72749 m
.63923 .73424 L
s
.49379 .58199 m
.49415 .57769 L
s
.49322 .57661 m
.49352 .57265 L
s
.72218 .82713 m
.73001 .84506 L
s
.66255 .76756 m
.67068 .77724 L
s
.55617 .65155 m
.56094 .6512 L
s
.60696 .70355 m
.61393 .70767 L
s
.76954 .88076 m
.77603 .90577 L
s
.84635 .97438 m
.84886 1.01251 L
s
.47443 .55046 m
.47293 .5459 L
s
.52977 .63499 m
.53293 .63188 L
s
.54981 .6614 m
.5542 .65928 L
s
.59942 .69637 m
.6061 .69972 L
s
.52172 .6136 m
.52432 .61097 L
s
.56827 .6838 m
.57361 .68285 L
s
.54838 .64363 m
.55269 .6427 L
s
.74662 .8542 m
.75383 .87569 L
s
.61799 .71496 m
.62527 .72018 L
s
.54301 .63789 m
.54701 .63658 L
s
.48474 .56607 m
.48426 .56179 L
s
.555 .65091 m
.55968 .65045 L
s
.5598 .67427 m
.56472 .67273 L
s
.61619 .73069 m
.62332 .73427 L
s
.43372 .48864 m
.42749 .48348 L
s
.49719 .58917 m
.49785 .58491 L
s
.672 .7708 m
.6802 .78221 L
s
.55417 .65028 m
.5588 .64976 L
s
.72363 .8283 m
.73134 .84644 L
s
.70009 .80192 m
.70815 .81686 L
s
.5252 .61847 m
.52803 .61601 L
s
.48046 .56072 m
.47957 .5563 L
s
.58631 .68387 m
.59245 .68597 L
s
.78747 .90276 m
.79308 .93049 L
s
.62409 .72166 m
.63151 .72749 L
s
.53041 .6377 m
.5336 .63455 L
s
.70668 .80954 m
.71463 .82532 L
s
.78234 .89672 m
.78816 .92361 L
s
.56842 .66579 m
.57376 .66635 L
s
.51032 .60113 m
.51205 .59786 L
s
.51196 .61211 m
.51383 .60825 L
s
.64684 .75571 m
.65466 .76315 L
s
.63915 .74927 m
.64684 .75571 L
s
.50276 .59885 m
.50389 .5947 L
s
.63165 .74384 m
.63915 .74927 L
s
.53501 .64446 m
.53849 .64149 L
s
.48429 .56713 m
.48378 .56281 L
s
.73603 .84379 m
.74337 .86353 L
s
.49528 .58789 m
.49578 .58354 L
s
.51544 .61766 m
.51757 .61389 L
s
.68295 .78358 m
.69105 .79626 L
s
.57506 .67302 m
.58069 .67412 L
s
.53761 .63339 m
.54125 .63168 L
s
.47578 .55502 m
.47443 .55046 L
s
.7337 .84135 m
.74108 .86073 L
s
.5123 .61345 m
.51419 .60957 L
s
.58107 .67929 m
.58696 .68089 L
s
.54973 .66433 m
.55407 .66206 L
s
.52167 .61552 m
.52424 .61283 L
s
.55419 .67014 m
.55877 .66811 L
s
.52991 .6385 m
.53305 .63527 L
s
.67068 .77724 m
.67866 .78781 L
s
.56706 .68569 m
.57228 .68448 L
s
.65466 .76315 m
.66252 .77156 L
s
.62437 .73942 m
.63165 .74384 L
s
.53474 .64531 m
.53818 .64228 L
s
.60529 .70396 m
.61208 .70779 L
s
.5379 .63428 m
.54153 .63257 L
s
.51577 .6089 m
.51791 .60589 L
s
.50828 .59989 m
.50984 .59651 L
s
.49346 .58642 m
.49379 .58199 L
s
.6085 .70725 m
.61538 .71139 L
s
.57489 .69511 m
.58045 .69443 L
s
.60936 .72811 m
.61619 .73069 L
s
.55791 .67564 m
.56267 .67379 L
s
.57428 .6947 m
.57981 .69396 L
s
.41901 .46848 m
.41087 .4633 L
s
.51831 .62343 m
.52064 .61971 L
s
.68949 .79155 m
.69748 .80498 L
s
.49294 .58066 m
.49322 .57661 L
s
.53628 .64849 m
.53982 .64548 L
s
.48516 .57039 m
.48474 .56607 L
s
.55516 .67319 m
.55976 .67113 L
s
.72231 .82848 m
.72983 .84621 L
s
.40856 .45195 m
.39894 .44682 L
s
.58934 .68881 m
.59551 .6911 L
s
.48126 .56517 m
.48046 .56072 L
s
.53925 .63682 m
.54295 .63517 L
s
.7189 .82477 m
.72647 .84202 L
s
.53224 .64391 m
.53551 .64068 L
s
.61107 .7106 m
.61799 .71496 L
s
.52953 .64025 m
.53262 .63691 L
s
.61736 .73601 m
.62437 .73942 L
s
.52681 .6367 m
.52972 .63323 L
s
.42749 .48348 m
.42054 .47829 L
s
.537 .65057 m
.54056 .64754 L
s
.57585 .67551 m
.58145 .6766 L
s
.71477 .82035 m
.72239 .83701 L
s
.54056 .6555 m
.54434 .65263 L
s
.65136 .75078 m
.65922 .75956 L
s
.64363 .74289 m
.65136 .75078 L
s
.60041 .70025 m
.60696 .70355 L
s
.61702 .71671 m
.62409 .72166 L
s
.77151 .88577 m
.77749 .91064 L
s
.47698 .5596 m
.47578 .55502 L
s
.66252 .77156 m
.67034 .78088 L
s
.55917 .6586 m
.56396 .65835 L
s
.6802 .78221 m
.68813 .79438 L
s
.49658 .5936 m
.49719 .58917 L
s
.65922 .75956 m
.6671 .76921 L
s
.6361 .7359 m
.64363 .74289 L
s
.40481 .44749 m
.39469 .44239 L
s
.69504 .79883 m
.70285 .81283 L
s
.48475 .57149 m
.48429 .56713 L
s
.71467 .8226 m
.72219 .83902 L
s
.56329 .68549 m
.56827 .6838 L
s
.52687 .63851 m
.52977 .63499 L
s
.59317 .69379 m
.59942 .69637 L
s
.74784 .85867 m
.75456 .87988 L
s
.60285 .7265 m
.60936 .72811 L
s
.54575 .66411 m
.54981 .6614 L
s
.49482 .5924 m
.49528 .58789 L
s
.69819 .8027 m
.70593 .81706 L
s
.76731 .88149 m
.77333 .90559 L
s
.55524 .67649 m
.5598 .67427 L
s
.45573 .5302 m
.45228 .5251 L
s
.45884 .53527 m
.45573 .5302 L
s
.77394 .88956 m
.77967 .91465 L
s
.50172 .6032 m
.50276 .59885 L
s
.45228 .5251 m
.44843 .51997 L
s
.61064 .73358 m
.61736 .73601 L
s
.51937 .61649 m
.52172 .6136 L
s
.46163 .54032 m
.45884 .53527 L
s
.51025 .61624 m
.51196 .61211 L
s
.55181 .65239 m
.55617 .65155 L
s
.49315 .591 m
.49346 .58642 L
s
.62882 .7298 m
.6361 .7359 L
s
.6671 .76921 m
.67491 .77968 L
s
.44843 .51997 m
.44414 .51479 L
s
.52749 .64128 m
.53041 .6377 L
s
.71522 .82419 m
.7226 .84055 L
s
.67866 .78781 m
.68637 .79914 L
s
.46414 .54536 m
.46163 .54032 L
s
.48197 .56964 m
.48126 .56517 L
s
.50875 .60457 m
.51032 .60113 L
s
.51349 .62172 m
.51544 .61766 L
s
.47807 .56419 m
.47698 .5596 L
s
.77517 .89156 m
.78076 .91675 L
s
.51058 .61761 m
.5123 .61345 L
s
.54444 .645 m
.54838 .64363 L
s
.48554 .57476 m
.48516 .57039 L
s
.53937 .6396 m
.54301 .63789 L
s
.7669 .88174 m
.77282 .90566 L
s
.53181 .64791 m
.53501 .64446 L
s
.55072 .65185 m
.555 .65091 L
s
.52263 .6212 m
.5252 .61847 L
s
.58061 .68247 m
.58631 .68387 L
s
.49268 .58479 m
.49294 .58066 L
s
.60202 .70391 m
.6085 .70725 L
s
.83074 .95909 m
.83339 .99347 L
s
.59892 .70093 m
.60529 .70396 L
s
.56219 .68764 m
.56706 .68569 L
s
.64938 .75063 m
.65704 .75902 L
s
.64186 .7431 m
.64938 .75063 L
s
.54994 .65128 m
.55417 .65028 L
s
.56968 .69658 m
.57489 .69511 L
s
.67034 .78088 m
.67799 .79103 L
s
.54571 .66719 m
.54973 .66433 L
s
.54994 .67279 m
.55419 .67014 L
s
.44414 .51479 m
.43937 .50958 L
s
.5691 .69623 m
.57428 .6947 L
s
.52703 .64216 m
.52991 .6385 L
s
.65704 .75902 m
.66474 .76826 L
s
.46639 .55041 m
.46414 .54536 L
s
.53156 .64882 m
.53474 .64531 L
s
.50686 .60345 m
.50828 .59989 L
s
.69105 .79626 m
.69869 .80955 L
s
.56351 .6658 m
.56842 .66579 L
s
.61031 .71259 m
.61702 .71671 L
s
.51617 .62749 m
.51831 .62343 L
s
.55349 .67815 m
.55791 .67564 L
s
.63453 .73645 m
.64186 .7431 L
s
.51934 .61845 m
.52167 .61552 L
s
.60455 .70706 m
.61107 .7106 L
s
.51384 .61212 m
.51577 .6089 L
s
.57563 .67834 m
.58107 .67929 L
s
.6042 .73212 m
.61064 .73358 L
s
.48516 .5759 m
.48475 .57149 L
s
.56987 .67254 m
.57506 .67302 L
s
.59665 .72584 m
.60285 .7265 L
s
.49602 .59819 m
.49658 .5936 L
s
.42054 .47829 m
.41277 .47308 L
s
.53431 .63546 m
.53761 .63339 L
s
.53303 .65199 m
.53628 .64849 L
s
.55089 .67589 m
.55516 .67319 L
s
.62184 .72455 m
.62882 .7298 L
s
.46842 .55546 m
.46639 .55041 L
s
.41087 .4633 m
.40178 .45815 L
s
.66474 .76826 m
.67238 .7783 L
s
.53459 .63634 m
.5379 .63428 L
s
.52668 .64402 m
.52953 .64025 L
s
.52923 .64759 m
.53224 .64391 L
s
.43937 .50958 m
.43406 .50433 L
s
.52413 .64056 m
.52681 .6367 L
s
.77287 .89031 m
.77833 .9149 L
s
.4944 .59707 m
.49482 .5924 L
s
.59428 .69772 m
.60041 .70025 L
s
.64991 .7525 m
.65745 .76084 L
s
.64248 .74501 m
.64991 .7525 L
s
.53371 .65409 m
.537 .65057 L
s
.47905 .56879 m
.47807 .56419 L
s
.58361 .68723 m
.58934 .68881 L
s
.53708 .6589 m
.54056 .6555 L
s
.67491 .77968 m
.68252 .79087 L
s
.65745 .76084 m
.66502 .77 L
s
.48261 .57415 m
.48197 .56964 L
s
.62746 .73065 m
.63453 .73645 L
s
.63524 .73836 m
.64248 .74501 L
s
.49285 .59572 m
.49315 .591 L
s
.55866 .68789 m
.56329 .68549 L
s
.50077 .60776 m
.50172 .6032 L
s
.68813 .79438 m
.69564 .80715 L
s
.76638 .88336 m
.77199 .90685 L
s
.48589 .57918 m
.48554 .57476 L
s
.53589 .63883 m
.53925 .63682 L
s
.47025 .56053 m
.46842 .55546 L
s
.5242 .64245 m
.52687 .63851 L
s
.57069 .67503 m
.57585 .67551 L
s
.69748 .80498 m
.70487 .81889 L
s
.70815 .81686 m
.71537 .83214 L
s
.45214 .53131 m
.44836 .5261 L
s
.45554 .53651 m
.45214 .53131 L
s
.4586 .54169 m
.45554 .53651 L
s
.542 .66738 m
.54575 .66411 L
s
.551 .67936 m
.55524 .67649 L
s
.50868 .62065 m
.51025 .61624 L
s
.58735 .69193 m
.59317 .69379 L
s
.59805 .73161 m
.6042 .73212 L
s
.80016 .92372 m
.80417 .95247 L
s
.72714 .83968 m
.73393 .85736 L
s
.46135 .54685 m
.4586 .54169 L
s
.44836 .5261 m
.44415 .52085 L
s
.55478 .65935 m
.55917 .6586 L
s
.66502 .77 m
.67252 .77994 L
s
.49245 .589 m
.49268 .58479 L
s
.39894 .44682 m
.38819 .4418 L
s
.59075 .7261 m
.59665 .72584 L
s
.43406 .50433 m
.42814 .49905 L
s
.50899 .62204 m
.51058 .61761 L
s
.5117 .62609 m
.51349 .62172 L
s
.63762 .75917 m
.64472 .76457 L
s
.63065 .75473 m
.63762 .75917 L
s
.62824 .73256 m
.63524 .73836 L
s
.52479 .64527 m
.52749 .64128 L
s
.48553 .58035 m
.48516 .5759 L
s
.46382 .55202 m
.46135 .54685 L
s
.62385 .75125 m
.63065 .75473 L
s
.67238 .7783 m
.67985 .78906 L
s
.64472 .76457 m
.6519 .7709 L
s
.51723 .61961 m
.51937 .61649 L
s
.56481 .69881 m
.56968 .69658 L
s
.67799 .79103 m
.68534 .8019 L
s
.44415 .52085 m
.43947 .51557 L
s
.61518 .72012 m
.62184 .72455 L
s
.50733 .60818 m
.50875 .60457 L
s
.47189 .56563 m
.47025 .56053 L
s
.65344 .75809 m
.66084 .76667 L
s
.6461 .75033 m
.65344 .75809 L
s
.55765 .6903 m
.56219 .68764 L
s
.56426 .69851 m
.5691 .69623 L
s
.52886 .6518 m
.53181 .64791 L
s
.59595 .70133 m
.60202 .70391 L
s
.73644 .8497 m
.74291 .86867 L
s
.4955 .60296 m
.49602 .59819 L
s
.6389 .74339 m
.6461 .75033 L
s
.60399 .70927 m
.61031 .71259 L
s
.76393 .88148 m
.76945 .90442 L
s
.47993 .57342 m
.47905 .56879 L
s
.62067 .72567 m
.62746 .73065 L
s
.59296 .69863 m
.59892 .70093 L
s
.81721 .94539 m
.8201 .9768 L
s
.68637 .79914 m
.69364 .8111 L
s
.71463 .82532 m
.72158 .8413 L
s
.54199 .67062 m
.54571 .66719 L
s
.73787 .85242 m
.74424 .87148 L
s
.546 .67605 m
.54994 .67279 L
s
.52437 .64623 m
.52703 .64216 L
s
.61725 .74875 m
.62385 .75125 L
s
.46605 .5572 m
.46382 .55202 L
s
.51421 .63186 m
.51617 .62749 L
s
.59843 .70427 m
.60455 .70706 L
s
.76738 .8861 m
.7727 .90947 L
s
.52863 .65277 m
.53156 .64882 L
s
.6519 .7709 m
.65909 .77812 L
s
.54783 .65368 m
.55181 .65239 L
s
.494 .6019 m
.4944 .59707 L
s
.48319 .5787 m
.48261 .57415 L
s
.54938 .6813 m
.55349 .67815 L
s
.50558 .60715 m
.50686 .60345 L
s
.5203 .62417 m
.52263 .6212 L
s
.66084 .76667 m
.66822 .77601 L
s
.57535 .6817 m
.58061 .68247 L
s
.63191 .73728 m
.6389 .74339 L
s
.39469 .44239 m
.38336 .43744 L
s
.43947 .51557 m
.43426 .51026 L
s
.53606 .64166 m
.53937 .6396 L
s
.54085 .64676 m
.54444 .645 L
s
.70285 .81283 m
.70993 .8272 L
s
.49258 .6006 m
.49285 .59572 L
s
.59219 .73204 m
.59805 .73161 L
s
.41277 .47308 m
.4041 .46791 L
s
.53002 .65595 m
.53303 .65199 L
s
.54691 .67921 m
.55089 .67589 L
s
.54681 .65323 m
.55072 .65185 L
s
.51208 .61554 m
.51384 .61212 L
s
.48619 .58364 m
.48589 .57918 L
s
.47336 .57078 m
.47189 .56563 L
s
.61087 .74722 m
.61725 .74875 L
s
.62151 .72758 m
.62824 .73256 L
s
.51723 .62161 m
.51934 .61845 L
s
.54608 .65271 m
.54994 .65128 L
s
.46805 .5624 m
.46605 .5572 L
s
.49989 .61253 m
.50077 .60776 L
s
.52406 .6482 m
.52668 .64402 L
s
.52166 .64481 m
.52413 .64056 L
s
.67252 .77994 m
.67983 .79056 L
s
.52645 .6517 m
.52923 .64759 L
s
.76645 .88557 m
.77169 .90869 L
s
.68252 .79087 m
.68977 .80267 L
s
.42814 .49905 m
.42155 .49376 L
s
.53067 .65808 m
.53371 .65409 L
s
.55901 .66633 m
.56351 .6658 L
s
.58515 .72726 m
.59075 .7261 L
s
.53385 .66279 m
.53708 .6589 L
s
.57061 .67799 m
.57563 .67834 L
s
.73001 .84506 m
.73642 .86283 L
s
.58857 .69589 m
.59428 .69772 L
s
.55433 .69098 m
.55866 .68789 L
s
.56509 .67263 m
.56987 .67254 L
s
.5313 .63785 m
.53431 .63546 L
s
.70593 .81706 m
.71285 .83172 L
s
.65909 .77812 m
.66619 .78616 L
s
.62516 .73197 m
.63191 .73728 L
s
.50724 .62533 m
.50868 .62065 L
s
.75894 .87743 m
.76438 .89934 L
s
.48587 .58485 m
.48553 .58035 L
s
.92355 1.08432 m
.91797 1.1358 L
s
.52174 .64677 m
.5242 .64245 L
s
.66822 .77601 m
.67546 .78607 L
s
.79989 .92597 m
.80345 .95418 L
s
.48072 .57808 m
.47993 .57342 L
s
.43426 .51026 m
.42847 .50494 L
s
.49224 .59329 m
.49245 .589 L
s
.57831 .68629 m
.58361 .68723 L
s
.83714 .97185 m
.83844 1.00633 L
s
.61421 .72149 m
.62067 .72567 L
s
.53158 .63873 m
.53459 .63634 L
s
.60471 .74666 m
.61087 .74722 L
s
.54705 .68284 m
.551 .67936 L
s
.53851 .6712 m
.542 .66738 L
s
.46986 .56762 m
.46805 .5624 L
s
.60887 .71647 m
.61518 .72012 L
s
.69869 .80955 m
.70566 .82323 L
s
.50752 .62674 m
.50899 .62204 L
s
.40178 .45815 m
.39162 .45311 L
s
.49501 .6079 m
.4955 .60296 L
s
.74491 .86168 m
.75078 .8815 L
s
.47469 .57598 m
.47336 .57078 L
s
.51005 .63075 m
.5117 .62609 L
s
.67985 .78906 m
.68699 .80042 L
s
.6359 .76457 m
.6427 .76924 L
s
.62921 .76083 m
.6359 .76457 L
s
.62266 .75805 m
.62921 .76083 L
s
.56023 .70178 m
.56481 .69881 L
s
.73134 .84644 m
.73759 .86434 L
s
.48371 .58329 m
.48319 .5787 L
s
.58659 .73339 m
.59219 .73204 L
s
.55971 .70154 m
.56426 .69851 L
s
.5223 .64967 m
.52479 .64527 L
s
.58195 .69073 m
.58735 .69193 L
s
.49363 .6069 m
.494 .6019 L
s
.6427 .76924 m
.64955 .77482 L
s
.5534 .69363 m
.55765 .6903 L
s
.61627 .75625 m
.62266 .75805 L
s
.53283 .64117 m
.53589 .63883 L
s
.59805 .70667 m
.60399 .70927 L
s
.56595 .67512 m
.57069 .67503 L
s
.6151 .72337 m
.62151 .72758 L
s
.52613 .65612 m
.52886 .6518 L
s
.49231 .60564 m
.49258 .6006 L
s
.74453 .86264 m
.75028 .88223 L
s
.50605 .61194 m
.50733 .60818 L
s
.69564 .80715 m
.70254 .82034 L
s
.59878 .74708 m
.60471 .74666 L
s
.59029 .69944 m
.59595 .70133 L
s
.47148 .5729 m
.46986 .56762 L
s
.5124 .63656 m
.51421 .63186 L
s
.72239 .83701 m
.72876 .8536 L
s
.54233 .6799 m
.546 .67605 L
s
.52191 .65071 m
.52437 .64623 L
s
.53852 .6746 m
.54199 .67062 L
s
.48647 .58816 m
.48619 .58364 L
s
.61006 .75543 m
.61627 .75625 L
s
.5153 .62294 m
.51723 .61961 L
s
.57982 .72932 m
.58515 .72726 L
s
.54554 .68507 m
.54938 .6813 L
s
.68534 .8019 m
.69223 .81332 L
s
.55077 .66056 m
.55478 .65935 L
s
.52592 .65716 m
.52863 .65277 L
s
.6187 .72745 m
.62516 .73197 L
s
.58742 .69701 m
.59296 .69863 L
s
.64955 .77482 m
.6564 .78126 L
s
.59271 .7022 m
.59843 .70427 L
s
.42155 .49376 m
.41421 .48848 L
s
.66619 .78616 m
.67312 .79494 L
s
.42847 .50494 m
.42202 .49961 L
s
.75952 .88016 m
.76465 .90184 L
s
.49907 .61751 m
.49989 .61253 L
s
.72647 .84202 m
.73268 .8591 L
s
.50442 .611 m
.50558 .60715 L
s
.47588 .58124 m
.47469 .57598 L
s
.7534 .87289 m
.75875 .89369 L
s
.67983 .79056 m
.6868 .80175 L
s
.54321 .68313 m
.54691 .67921 L
s
.72219 .83902 m
.72846 .85537 L
s
.48144 .58277 m
.48072 .57808 L
s
.52723 .66036 m
.53002 .65595 L
s
.72983 .84621 m
.73591 .86369 L
s
.67546 .78607 m
.68243 .79672 L
s
.60404 .7556 m
.61006 .75543 L
s
.51938 .64944 m
.52166 .64481 L
s
.48617 .5894 m
.48587 .58485 L
s
.52163 .65278 m
.52406 .6482 L
s
.75043 .87035 m
.75582 .89063 L
s
.52388 .65623 m
.52645 .6517 L
s
.51819 .62738 m
.5203 .62417 L
s
.52785 .66253 m
.53067 .65808 L
s
.60809 .71806 m
.61421 .72149 L
s
.59306 .74848 m
.59878 .74708 L
s
.55027 .69473 m
.55433 .69098 L
s
.58125 .73566 m
.58659 .73339 L
s
.5105 .61912 m
.51208 .61554 L
s
.47294 .57822 m
.47148 .5729 L
s
.53085 .66718 m
.53385 .66279 L
s
.5705 .6815 m
.57535 .6817 L
s
.76599 .88843 m
.77073 .91093 L
s
.5059 .63028 m
.50724 .62533 L
s
.77076 .894 m
.77528 .91721 L
s
.64992 .75919 m
.65684 .76695 L
s
.64306 .75217 m
.64992 .75919 L
s
.5442 .65537 m
.54783 .65368 L
s
.49205 .59765 m
.49224 .59329 L
s
.49456 .61303 m
.49501 .6079 L
s
.70487 .81889 m
.71142 .83303 L
s
.51532 .62497 m
.51723 .62161 L
s
.48418 .58791 m
.48371 .58329 L
s
.53305 .64405 m
.53606 .64166 L
s
.4041 .46791 m
.39443 .46284 L
s
.60293 .71356 m
.60887 .71647 L
s
.63635 .74591 m
.64306 .75217 L
s
.6564 .78126 m
.66316 .78849 L
s
.69364 .8111 m
.70029 .82347 L
s
.51946 .65148 m
.52174 .64677 L
s
.53759 .64888 m
.54085 .64676 L
s
.62309 .76676 m
.62946 .76898 L
s
.61684 .76552 m
.62309 .76676 L
s
.62946 .76898 m
.63593 .77216 L
s
.5982 .75679 m
.60404 .7556 L
s
.50617 .63173 m
.50752 .62674 L
s
.65684 .76695 m
.66375 .77543 L
s
.54336 .68694 m
.54705 .68284 L
s
.7226 .84055 m
.72871 .85681 L
s
.49327 .61207 m
.49363 .6069 L
s
.54325 .65499 m
.54681 .65323 L
s
.74108 .86073 m
.74665 .87954 L
s
.58327 .6947 m
.58857 .69589 L
s
.38819 .4418 m
.37617 .43701 L
s
.50852 .6357 m
.51005 .63075 L
s
.53527 .67555 m
.53851 .6712 L
s
.68977 .80267 m
.69651 .81491 L
s
.61072 .7653 m
.61684 .76552 L
s
.55592 .70548 m
.56023 .70178 L
s
.75268 .87385 m
.75784 .89429 L
s
.63593 .77216 m
.64246 .77626 L
s
.47695 .58658 m
.47588 .58124 L
s
.60903 .71991 m
.6151 .72337 L
s
.54256 .65453 m
.54608 .65271 L
s
.55543 .70528 m
.55971 .70154 L
s
.622 .76857 m
.62832 .77047 L
s
.61579 .76767 m
.622 .76857 L
s
.49205 .61086 m
.49231 .60564 L
s
.74337 .86353 m
.74883 .88262 L
s
.57473 .73227 m
.57982 .72932 L
s
.62832 .77047 m
.63473 .77334 L
s
.56599 .67818 m
.57061 .67799 L
s
.60971 .7678 m
.61579 .76767 L
s
.60474 .76612 m
.61072 .7653 L
s
.61256 .72368 m
.6187 .72745 L
s
.54941 .69764 m
.5534 .69363 L
s
.84464 .9846 m
.84476 1.01968 L
s
.5549 .66733 m
.55901 .66633 L
s
.64941 .75967 m
.65623 .76729 L
s
.64265 .75278 m
.64941 .75967 L
s
.62982 .74041 m
.63635 .74591 L
s
.52858 .64052 m
.5313 .63785 L
s
.58753 .75086 m
.59306 .74848 L
s
.51999 .65446 m
.5223 .64967 L
s
.48672 .59273 m
.48647 .58816 L
s
.63473 .77334 m
.6412 .77714 L
s
.56072 .67322 m
.56509 .67263 L
s
.60375 .76898 m
.60971 .7678 L
s
.42202 .49961 m
.41486 .4943 L
s
.47425 .58361 m
.47294 .57822 L
s
.64246 .77626 m
.64901 .78125 L
s
.59252 .759 m
.5982 .75679 L
s
.63603 .74664 m
.64265 .75278 L
s
.57342 .68593 m
.57831 .68629 L
s
.59888 .768 m
.60474 .76612 L
s
.68699 .80042 m
.69366 .81223 L
s
.65623 .76729 m
.66304 .7756 L
s
.52359 .66088 m
.52613 .65612 L
s
.48208 .58748 m
.48144 .58277 L
s
.51072 .64157 m
.5124 .63656 L
s
.52885 .6414 m
.53158 .63873 L
s
.66375 .77543 m
.67055 .78456 L
s
.59251 .70476 m
.59805 .70667 L
s
.79098 .91927 m
.79429 .9453 L
s
.5979 .77125 m
.60375 .76898 L
s
.49831 .62272 m
.49907 .61751 L
s
.57612 .73884 m
.58125 .73566 L
s
.53889 .68433 m
.54233 .6799 L
s
.51963 .65558 m
.52191 .65071 L
s
.53529 .67912 m
.53852 .6746 L
s
.75383 .87569 m
.75879 .89618 L
s
.67312 .79494 m
.67975 .80436 L
s
.6412 .77714 m
.64769 .78182 L
s
.71537 .83214 m
.72151 .84741 L
s
.54195 .68944 m
.54554 .68507 L
s
.59313 .77099 m
.59888 .768 L
s
.41421 .48848 m
.40604 .48325 L
s
.50489 .61583 m
.50605 .61194 L
s
.5234 .66199 m
.52592 .65716 L
s
.57696 .69013 m
.58195 .69073 L
s
.59214 .77466 m
.5979 .77125 L
s
.48644 .594 m
.48617 .5894 L
s
.6296 .74124 m
.63603 .74664 L
s
.58503 .6982 m
.59029 .69944 L
s
.66316 .78849 m
.66975 .79645 L
s
.58699 .76226 m
.59252 .759 L
s
.38336 .43744 m
.37072 .43278 L
s
.53974 .68764 m
.54321 .68313 L
s
.4779 .59202 m
.47695 .58658 L
s
.76529 .88981 m
.7697 .91183 L
s
.64901 .78125 m
.65551 .78707 L
s
.58217 .75425 m
.58753 .75086 L
s
.62353 .73565 m
.62982 .74041 L
s
.58645 .77924 m
.59214 .77466 L
s
.53006 .6438 m
.53283 .64117 L
s
.52464 .66522 m
.52723 .66036 L
s
.58747 .77511 m
.59313 .77099 L
s
.58739 .70077 m
.59271 .7022 L
s
.49412 .61835 m
.49456 .61303 L
s
.50338 .61497 m
.50442 .611 L
s
.66304 .7756 m
.66974 .78456 L
s
.56161 .6757 m
.56595 .67512 L
s
.51355 .62645 m
.5153 .62294 L
s
.51726 .65446 m
.51938 .64944 L
s
.60233 .71534 m
.60809 .71806 L
s
.4846 .59258 m
.48418 .58791 L
s
.51937 .65776 m
.52163 .65278 L
s
.58228 .69602 m
.58742 .69701 L
s
.54646 .69914 m
.55027 .69473 L
s
.52148 .66118 m
.52388 .65623 L
s
.68243 .79672 m
.689 .80786 L
s
.47543 .58908 m
.47425 .58361 L
s
.50466 .6355 m
.5059 .63028 L
s
.58078 .78505 m
.58645 .77924 L
s
.56985 .7361 m
.57473 .73227 L
s
.64769 .78182 m
.65413 .78735 L
s
.52522 .66744 m
.52785 .66253 L
s
.49293 .61744 m
.49327 .61207 L
s
.58186 .78042 m
.58747 .77511 L
s
.49188 .60209 m
.49205 .59765 L
s
.39162 .45311 m
.38029 .44827 L
s
.52805 .67204 m
.53085 .66718 L
s
.79634 .92695 m
.79913 .95358 L
s
.70993 .8272 m
.71603 .84163 L
s
.6868 .80175 m
.69328 .81336 L
s
.57508 .79216 m
.58078 .78505 L
s
.4918 .61625 m
.49205 .61086 L
s
.58157 .7666 m
.58699 .76226 L
s
.5049 .63698 m
.50617 .63173 L
s
.54712 .66216 m
.55077 .66056 L
s
.51733 .65658 m
.51946 .65148 L
s
.55185 .70989 m
.55592 .70548 L
s
.59735 .71133 m
.60293 .71356 L
s
.57625 .78698 m
.58186 .78042 L
s
.56929 .80065 m
.57508 .79216 L
s
.53989 .69163 m
.54336 .68694 L
s
.5071 .64095 m
.50852 .6357 L
s
.57118 .74295 m
.57612 .73884 L
s
.55137 .70974 m
.55543 .70528 L
s
.67055 .78456 m
.67713 .79426 L
s
.6234 .73658 m
.6296 .74124 L
s
.6033 .71716 m
.60903 .71991 L
s
.56334 .81061 m
.56929 .80065 L
s
.50907 .62287 m
.5105 .61912 L
s
.60675 .72062 m
.61256 .72368 L
s
.51628 .63078 m
.51819 .62738 L
s
.53223 .68043 m
.53527 .67555 L
s
.57696 .75865 m
.58217 .75425 L
s
.57059 .79486 m
.57625 .78698 L
s
.48695 .59735 m
.48672 .59273 L
s
.55712 .82214 m
.56334 .81061 L
s
.69223 .81332 m
.6985 .8251 L
s
.54565 .7023 m
.54941 .69764 L
s
.48267 .59223 m
.48208 .58748 L
s
.70566 .82323 m
.71175 .83703 L
s
.65551 .78707 m
.66189 .79364 L
s
.55052 .83535 m
.55712 .82214 L
s
.5648 .80415 m
.57059 .79486 L
s
.5136 .62851 m
.51532 .62497 L
s
.57622 .77205 m
.58157 .7666 L
s
.47875 .59755 m
.4779 .59202 L
s
.41486 .4943 m
.40689 .48905 L
s
.51783 .65965 m
.51999 .65446 L
s
.56605 .68183 m
.5705 .6815 L
s
.61751 .73161 m
.62353 .73565 L
s
.49759 .62815 m
.49831 .62272 L
s
.5588 .81493 m
.5648 .80415 L
s
.72158 .8413 m
.72725 .85706 L
s
.5434 .85034 m
.55052 .83535 L
s
.65413 .78735 m
.66046 .79364 L
s
.47648 .59464 m
.47543 .58908 L
s
.66974 .78456 m
.67623 .79408 L
s
.50915 .6469 m
.51072 .64157 L
s
.71285 .83172 m
.71872 .84635 L
s
.57838 .6941 m
.58327 .6947 L
s
.54091 .65742 m
.5442 .65537 L
s
.52122 .66607 m
.52359 .66088 L
s
.55248 .82731 m
.5588 .81493 L
s
.70254 .82034 m
.70862 .83368 L
s
.53032 .64673 m
.53305 .64405 L
s
.53567 .68932 m
.53889 .68433 L
s
.53463 .65131 m
.53759 .64888 L
s
.51749 .66084 m
.51963 .65558 L
s
.48669 .59865 m
.48644 .594 L
s
.56515 .74083 m
.56985 .7361 L
s
.53226 .68418 m
.53529 .67912 L
s
.53856 .69441 m
.54195 .68944 L
s
.57091 .77867 m
.57622 .77205 L
s
.57184 .76411 m
.57696 .75865 L
s
.54571 .84139 m
.55248 .82731 L
s
.66975 .79645 m
.67605 .80501 L
s
.4937 .62387 m
.49412 .61835 L
s
.52104 .66724 m
.5234 .66199 L
s
.54002 .65711 m
.54325 .65499 L
s
.53559 .86723 m
.5434 .85034 L
s
.58735 .70347 m
.59251 .70476 L
s
.56639 .74799 m
.57118 .74295 L
s
.48499 .59729 m
.4846 .59258 L
s
.39443 .46284 m
.38367 .45796 L
s
.53937 .65669 m
.54256 .65453 L
s
.53647 .69272 m
.53974 .68764 L
s
.56177 .67887 m
.56599 .67818 L
s
.61746 .73262 m
.6234 .73658 L
s
.4926 .62299 m
.49293 .61744 L
s
.52612 .64345 m
.52858 .64052 L
s
.53835 .85729 m
.54571 .84139 L
s
.67975 .80436 m
.68595 .81426 L
s
.52221 .67052 m
.52464 .66522 L
s
.73393 .85736 m
.73906 .8745 L
s
.75456 .87988 m
.75896 .89992 L
s
.54285 .7042 m
.54646 .69914 L
s
.50385 .61985 m
.50489 .61583 L
s
.56556 .78652 m
.57091 .77867 L
s
.49155 .62183 m
.4918 .61625 L
s
.55115 .66876 m
.5549 .66733 L
s
.50349 .641 m
.50466 .6355 L
s
.56893 .68611 m
.57342 .68593 L
s
.51527 .65986 m
.51726 .65446 L
s
.55673 .67427 m
.56072 .67322 L
s
.40604 .48325 m
.39696 .47814 L
s
.51725 .66314 m
.51937 .65776 L
s
.51924 .66655 m
.52148 .66118 L
s
.59693 .71327 m
.60233 .71534 L
s
.69651 .81491 m
.70253 .82737 L
s
.52638 .64434 m
.52885 .6414 L
s
.47951 .60319 m
.47875 .59755 L
s
.52276 .6728 m
.52522 .66744 L
s
.49173 .60659 m
.49188 .60209 L
s
.56677 .77065 m
.57184 .76411 L
s
.54797 .71502 m
.55185 .70989 L
s
.50372 .64253 m
.5049 .63698 L
s
.52542 .67739 m
.52805 .67204 L
s
.50244 .61906 m
.50338 .61497 L
s
.54752 .71491 m
.55137 .70974 L
s
.47742 .6003 m
.47648 .59464 L
s
.8101 .94624 m
.8116 .97452 L
s
.56012 .79566 m
.56556 .78652 L
s
.57237 .69008 m
.57696 .69013 L
s
.66189 .79364 m
.66807 .80089 L
s
.58017 .69754 m
.58503 .6982 L
s
.52686 .88606 m
.53559 .86723 L
s
.50577 .64651 m
.5071 .64095 L
s
.51534 .66207 m
.51733 .65658 L
s
.53662 .69692 m
.53989 .69163 L
s
.77603 .90577 m
.77936 .92876 L
s
.67713 .79426 m
.68337 .80441 L
s
.58246 .69994 m
.58739 .70077 L
s
.69366 .81223 m
.69968 .8243 L
s
.4832 .59702 m
.48267 .59223 L
s
.53019 .87507 m
.53835 .85729 L
s
.70029 .82347 m
.70613 .83601 L
s
.61179 .72827 m
.61751 .73161 L
s
.48716 .60201 m
.48695 .59735 L
s
.60128 .71822 m
.60675 .72062 L
s
.66046 .79364 m
.6666 .8006 L
s
.51197 .63013 m
.51355 .62645 L
s
.56058 .74647 m
.56515 .74083 L
s
.52936 .68584 m
.53223 .68043 L
s
.54207 .70763 m
.54565 .7023 L
s
.59793 .71506 m
.6033 .71716 L
s
.55449 .80617 m
.56012 .79566 L
s
.57753 .69559 m
.58228 .69602 L
s
.59215 .70973 m
.59735 .71133 L
s
.56171 .75399 m
.56639 .74799 L
s
.52755 .6467 m
.53006 .6438 L
s
.49691 .63381 m
.49759 .62815 L
s
.80755 .94381 m
.80907 .97154 L
s
.56171 .77834 m
.56677 .77065 L
s
.55764 .67674 m
.56161 .6757 L
s
.51581 .66523 m
.51783 .65965 L
s
.689 .80786 m
.695 .81928 L
s
.54859 .81816 m
.55449 .80617 L
s
.67623 .79408 m
.68238 .80405 L
s
.50767 .65256 m
.50915 .6469 L
s
.50778 .62676 m
.50907 .62287 L
s
.49329 .6296 m
.4937 .62387 L
s
.51899 .67169 m
.52122 .66607 L
s
.48692 .60334 m
.48669 .59865 L
s
.53261 .69488 m
.53567 .68932 L
s
.61182 .72934 m
.61746 .73262 L
s
.40689 .48905 m
.39804 .48392 L
s
.53535 .69998 m
.53856 .69441 L
s
.37617 .43701 m
.36278 .43262 L
s
.52939 .68978 m
.53226 .68418 L
s
.51549 .66651 m
.51749 .66084 L
s
.51456 .63436 m
.51628 .63078 L
s
.54229 .8317 m
.54859 .81816 L
s
.71142 .83303 m
.71692 .84708 L
s
.49226 .62875 m
.4926 .62299 L
s
.55657 .78723 m
.56171 .77834 L
s
.48018 .60896 m
.47951 .60319 L
s
.54381 .66413 m
.54712 .66216 L
s
.48535 .60203 m
.48499 .59729 L
s
.47825 .60608 m
.47742 .6003 L
s
.49129 .6276 m
.49155 .62183 L
s
.74291 .86867 m
.74741 .88675 L
s
.51882 .67293 m
.52104 .66724 L
s
.521 .89478 m
.53019 .87507 L
s
.51205 .63222 m
.5136 .62851 L
s
.69328 .81336 m
.69911 .82519 L
s
.53337 .6984 m
.53647 .69272 L
s
.5394 .70992 m
.54285 .7042 L
s
.51696 .90685 m
.52686 .88606 L
s
.55611 .75305 m
.56058 .74647 L
s
.55709 .76099 m
.56171 .75399 L
s
.50238 .64679 m
.50349 .641 L
s
.53545 .8469 m
.54229 .8317 L
s
.51991 .67628 m
.52221 .67052 L
s
.54425 .72087 m
.54797 .71502 L
s
.67605 .80501 m
.68195 .81404 L
s
.5134 .66564 m
.51527 .65986 L
s
.55128 .79739 m
.55657 .78723 L
s
.51526 .66893 m
.51725 .66314 L
s
.73642 .86283 m
.74105 .87988 L
s
.54382 .7208 m
.54752 .71491 L
s
.74424 .87148 m
.7486 .8896 L
s
.51712 .67235 m
.51924 .66655 L
s
.56198 .68263 m
.56605 .68183 L
s
.57387 .69405 m
.57838 .6941 L
s
.50259 .64836 m
.50372 .64253 L
s
.52043 .67862 m
.52276 .6728 L
s
.52293 .68322 m
.52542 .67739 L
s
.79164 .92644 m
.79375 .95134 L
s
.66807 .80089 m
.67394 .80869 L
s
.52786 .64966 m
.53032 .64673 L
s
.5045 .65237 m
.50577 .64651 L
s
.48369 .60183 m
.4832 .59702 L
s
.4916 .61115 m
.49173 .60659 L
s
.72876 .8536 m
.73361 .86967 L
s
.58258 .70277 m
.58735 .70347 L
s
.5335 .70282 m
.53662 .69692 L
s
.60638 .72558 m
.61179 .72827 L
s
.53793 .65978 m
.54091 .65742 L
s
.51346 .66795 m
.51534 .66207 L
s
.50291 .62399 m
.50385 .61985 L
s
.53865 .71362 m
.54207 .70763 L
s
.5919 .71183 m
.59693 .71327 L
s
.54577 .8089 m
.55128 .79739 L
s
.53196 .65402 m
.53463 .65131 L
s
.6666 .8006 m
.67245 .80814 L
s
.5279 .86384 m
.53545 .8469 L
s
.48736 .60672 m
.48716 .60201 L
s
.49625 .63971 m
.49691 .63381 L
s
.52664 .69177 m
.52936 .68584 L
s
.38029 .44827 m
.36768 .44379 L
s
.5371 .65954 m
.54002 .65711 L
s
.55248 .76901 m
.55709 .76099 L
s
.50161 .62326 m
.50244 .61906 L
s
.48076 .61487 m
.48018 .60896 L
s
.59616 .71646 m
.60128 .71822 L
s
.47899 .61198 m
.47825 .60608 L
s
.5239 .64662 m
.52612 .64345 L
s
.55167 .76059 m
.55611 .75305 L
s
.53649 .65916 m
.53937 .65669 L
s
.55793 .67999 m
.56177 .67887 L
s
.72846 .85537 m
.73318 .87118 L
s
.49288 .63555 m
.49329 .6296 L
s
.6985 .8251 m
.70395 .83698 L
s
.73759 .86434 m
.74202 .88144 L
s
.5399 .82185 m
.54577 .8089 L
s
.77333 .90559 m
.77624 .92762 L
s
.77749 .91064 m
.78019 .93326 L
s
.51389 .67122 m
.51581 .66523 L
s
.37072 .43278 m
.35663 .42859 L
s
.56482 .68677 m
.56893 .68611 L
s
.59292 .71357 m
.59793 .71506 L
s
.50627 .65855 m
.50767 .65256 L
s
.68595 .81426 m
.69158 .82446 L
s
.39696 .47814 m
.38687 .47322 L
s
.68337 .80441 m
.68912 .81488 L
s
.60649 .72671 m
.61182 .72934 L
s
.49193 .63473 m
.49226 .62875 L
s
.54775 .67056 m
.55115 .66876 L
s
.5531 .67573 m
.55673 .67427 L
s
.73268 .8591 m
.73724 .87551 L
s
.57569 .69742 m
.58017 .69754 L
s
.52417 .6475 m
.52638 .64434 L
s
.5297 .70102 m
.53261 .69488 L
s
.53228 .70616 m
.53535 .69998 L
s
.79948 .93698 m
.80093 .96285 L
s
.49102 .63359 m
.49129 .6276 L
s
.51687 .67775 m
.51899 .67169 L
s
.57792 .69966 m
.58246 .69994 L
s
.48714 .60807 m
.48692 .60334 L
s
.58733 .70873 m
.59215 .70973 L
s
.51049 .91639 m
.521 .89478 L
s
.52666 .69591 m
.52939 .68978 L
s
.56817 .69052 m
.57237 .69008 L
s
.78816 .92361 m
.79022 .94772 L
s
.44316 .54946 m
.43886 .54401 L
s
.44705 .5549 m
.44316 .54946 L
s
.51359 .67258 m
.51549 .66651 L
s
.51056 .63396 m
.51197 .63013 L
s
.45056 .56033 m
.44705 .5549 L
s
.53356 .83632 m
.5399 .82185 L
s
.77282 .90566 m
.77564 .92749 L
s
.53608 .7163 m
.5394 .70992 L
s
.48568 .60682 m
.48535 .60203 L
s
.44316 .5499 m
.43887 .54444 L
s
.44704 .55534 m
.44316 .5499 L
s
.54064 .72745 m
.54425 .72087 L
s
.5304 .70466 m
.53337 .6984 L
s
.43886 .54401 m
.4341 .53855 L
s
.51671 .67906 m
.51882 .67293 L
s
.45055 .56077 m
.44704 .55534 L
s
.51942 .88255 m
.5279 .86384 L
s
.5478 .77813 m
.55248 .76901 L
s
.57318 .69569 m
.57753 .69559 L
s
.54023 .72742 m
.54382 .7208 L
s
.68238 .80405 m
.68806 .81432 L
s
.45373 .56574 m
.45056 .56033 L
s
.50133 .65288 m
.50238 .64679 L
s
.43887 .54444 m
.43411 .53898 L
s
.38367 .45796 m
.3717 .45341 L
s
.72871 .85681 m
.73325 .87248 L
s
.54721 .76915 m
.55167 .76059 L
s
.45372 .56619 m
.45055 .56077 L
s
.51773 .68248 m
.51991 .67628 L
s
.5253 .64982 m
.52755 .6467 L
s
.72151 .84741 m
.72628 .86227 L
s
.50663 .63078 m
.50778 .62676 L
s
.50555 .92953 m
.51696 .90685 L
s
.51162 .67182 m
.5134 .66564 L
s
.73591 .86369 m
.7402 .88037 L
s
.51336 .67513 m
.51526 .66893 L
s
.50152 .6545 m
.50259 .64836 L
s
.4341 .53855 m
.42883 .5331 L
s
.51511 .67857 m
.51712 .67235 L
s
.4566 .57114 m
.45373 .56574 L
s
.77967 .91465 m
.782 .93731 L
s
.51821 .6849 m
.52043 .67862 L
s
.71603 .84163 m
.72092 .85576 L
s
.47963 .61804 m
.47899 .61198 L
s
.43411 .53898 m
.42885 .53353 L
s
.53534 .72029 m
.53865 .71362 L
s
.53049 .70932 m
.5335 .70282 L
s
.55404 .67819 m
.55764 .67674 L
s
.79308 .93049 m
.79467 .95514 L
s
.52659 .85239 m
.53356 .83632 L
s
.48127 .62094 m
.48076 .61487 L
s
.52056 .68954 m
.52293 .68322 L
s
.50329 .65856 m
.5045 .65237 L
s
.48414 .60668 m
.48369 .60183 L
s
.51303 .6381 m
.51456 .63436 L
s
.71175 .83703 m
.71673 .85061 L
s
.39804 .48392 m
.38821 .47898 L
s
.45658 .57158 m
.45372 .56619 L
s
.54298 .78838 m
.5478 .77813 L
s
.4956 .64588 m
.49625 .63971 L
s
.70862 .83368 m
.71366 .84686 L
s
.51166 .67423 m
.51346 .66795 L
s
.60129 .72351 m
.60638 .72558 L
s
.51066 .63608 m
.51205 .63222 L
s
.52404 .69824 m
.52664 .69177 L
s
.4915 .61577 m
.4916 .61115 L
s
.49247 .64174 m
.49288 .63555 L
s
.75078 .8815 m
.75436 .90001 L
s
.48755 .61147 m
.48736 .60672 L
s
.70253 .82737 m
.70767 .83978 L
s
.54266 .77877 m
.54721 .76915 L
s
.69968 .8243 m
.70487 .83636 L
s
.42883 .5331 m
.42299 .52767 L
s
.54082 .66643 m
.54381 .66413 L
s
.49158 .64094 m
.49193 .63473 L
s
.67394 .80869 m
.67941 .81692 L
s
.4592 .57652 m
.4566 .57114 L
s
.78076 .91675 m
.78289 .93942 L
s
.695 .81928 m
.70027 .8308 L
s
.49074 .63981 m
.49102 .63359 L
s
.42885 .53353 m
.42303 .5281 L
s
.51206 .67762 m
.51389 .67122 L
s
.67245 .80814 m
.6779 .81613 L
s
.50493 .66488 m
.50627 .65855 L
s
.68195 .81404 m
.68731 .82338 L
s
.5293 .71295 m
.53228 .70616 L
s
.45918 .57697 m
.45658 .57158 L
s
.52688 .70774 m
.5297 .70102 L
s
.53794 .79985 m
.54298 .78838 L
s
.53711 .73479 m
.54064 .72745 L
s
.58723 .71096 m
.5919 .71183 L
s
.50209 .62823 m
.50291 .62399 L
s
.77199 .90685 m
.77451 .92818 L
s
.56975 .69448 m
.57387 .69405 L
s
.51881 .87011 m
.52659 .85239 L
s
.50977 .90303 m
.51942 .88255 L
s
.60147 .72469 m
.60649 .72671 L
s
.53671 .73479 m
.54023 .72742 L
s
.53286 .72336 m
.53608 .7163 L
s
.51484 .68425 m
.51687 .67775 L
s
.52402 .7026 m
.52666 .69591 L
s
.5782 .7026 m
.58258 .70277 L
s
.75028 .88223 m
.75375 .90051 L
s
.59141 .71528 m
.59616 .71646 L
s
.55829 .68386 m
.56198 .68263 L
s
.44715 .56626 m
.44342 .56044 L
s
.45052 .57213 m
.44715 .56626 L
s
.51176 .67906 m
.51359 .67258 L
s
.44342 .56044 m
.43929 .55465 L
s
.52752 .71153 m
.5304 .70466 L
s
.50087 .62755 m
.50161 .62326 L
s
.48734 .61284 m
.48714 .60807 L
s
.45357 .57804 m
.45052 .57213 L
s
.51468 .68564 m
.51671 .67906 L
s
.52566 .65282 m
.52786 .64966 L
s
.5003 .65927 m
.50133 .65288 L
s
.43929 .55465 m
.43472 .54891 L
s
.48019 .62424 m
.47963 .61804 L
s
.53794 .78952 m
.54266 .77877 L
s
.71872 .84635 m
.72328 .86055 L
s
.58828 .71266 m
.59292 .71357 L
s
.48599 .61164 m
.48568 .60682 L
s
.4817 .62717 m
.48127 .62094 L
s
.77833 .9149 m
.7804 .93702 L
s
.53525 .66244 m
.53793 .65978 L
s
.44505 .56417 m
.44111 .55835 L
s
.44861 .57003 m
.44505 .56417 L
s
.46156 .58188 m
.4592 .57652 L
s
.76945 .90442 m
.77197 .92527 L
s
.53257 .81261 m
.53794 .79985 L
s
.52956 .65698 m
.53196 .65402 L
s
.70613 .83601 m
.71096 .8484 L
s
.45182 .57594 m
.44861 .57003 L
s
.51563 .68915 m
.51773 .68248 L
s
.44111 .55835 m
.43676 .55258 L
s
.5321 .72766 m
.53534 .72029 L
s
.45632 .58402 m
.45357 .57804 L
s
.50047 .66095 m
.50152 .6545 L
s
.5099 .6784 m
.51162 .67182 L
s
.46153 .58234 m
.45918 .57697 L
s
.42299 .52767 m
.41654 .52229 L
s
.51153 .68175 m
.51336 .67513 L
s
.52757 .71644 m
.53049 .70932 L
s
.51317 .68524 m
.51511 .67857 L
s
.49832 .93974 m
.51049 .91639 L
s
.43472 .54891 m
.42967 .54322 L
s
.69911 .82519 m
.70411 .83699 L
s
.45473 .58191 m
.45182 .57594 L
s
.42303 .5281 m
.41658 .52271 L
s
.52192 .64998 m
.5239 .64662 L
s
.53447 .66225 m
.5371 .65954 L
s
.51606 .69166 m
.51821 .6849 L
s
.58288 .70827 m
.58733 .70873 L
s
.50212 .66507 m
.50329 .65856 L
s
.51827 .69636 m
.52056 .68954 L
s
.49496 .65231 m
.4956 .64588 L
s
.43676 .55258 m
.43194 .54684 L
s
.5339 .66191 m
.53649 .65916 L
s
.55444 .68152 m
.55793 .67999 L
s
.56109 .68787 m
.56482 .68677 L
s
.5716 .6978 m
.57569 .69742 L
s
.57376 .69988 m
.57792 .69966 L
s
.50993 .68092 m
.51166 .67423 L
s
.45881 .59006 m
.45632 .58402 L
s
.53296 .80145 m
.53794 .78952 L
s
.50931 .63792 m
.51056 .63396 L
s
.48456 .61156 m
.48414 .60668 L
s
.49204 .64818 m
.49247 .64174 L
s
.52151 .70526 m
.52404 .69824 L
s
.74665 .87954 m
.75005 .89709 L
s
.52218 .65087 m
.52417 .6475 L
s
.45735 .58794 m
.45473 .58191 L
s
.76438 .89934 m
.76699 .91933 L
s
.52676 .82673 m
.53257 .81261 L
s
.68912 .81488 m
.69424 .82547 L
s
.54982 .67756 m
.5531 .67573 L
s
.53359 .74291 m
.53711 .73479 L
s
.54469 .6727 m
.54775 .67056 L
s
.49121 .64739 m
.49158 .64094 L
s
.72725 .85706 m
.73136 .87215 L
s
.56434 .69143 m
.56817 .69052 L
s
.50998 .88949 m
.51881 .87011 L
s
.49043 .64626 m
.49074 .63981 L
s
.53321 .74295 m
.53671 .73479 L
s
.7727 .90947 m
.77485 .93057 L
s
.59655 .72203 m
.60129 .72351 L
s
.52639 .72038 m
.5293 .71295 L
s
.46369 .58724 m
.46156 .58188 L
s
.43194 .54684 m
.42662 .54117 L
s
.42967 .54322 m
.42408 .53758 L
s
.5692 .69627 m
.57318 .69569 L
s
.50562 .63491 m
.50663 .63078 L
s
.52967 .73112 m
.53286 .72336 L
s
.52413 .71506 m
.52688 .70774 L
s
.51028 .68445 m
.51206 .67762 L
s
.50363 .67158 m
.50493 .66488 L
s
.38687 .47322 m
.37569 .46862 L
s
.48773 .61626 m
.48755 .61147 L
s
.46104 .59618 m
.45881 .59006 L
s
.74883 .88262 m
.75203 .90036 L
s
.46366 .58769 m
.46153 .58234 L
s
.48066 .63063 m
.48019 .62424 L
s
.68806 .81432 m
.69313 .82472 L
s
.45971 .59404 m
.45735 .58794 L
s
.49142 .62044 m
.4915 .61577 L
s
.52145 .70986 m
.52402 .7026 L
s
.75582 .89063 m
.75869 .90928 L
s
.69158 .82446 m
.69648 .83476 L
s
.5247 .71902 m
.52752 .71153 L
s
.51287 .69121 m
.51484 .68425 L
s
.52762 .81465 m
.53296 .80145 L
s
.48205 .63359 m
.4817 .62717 L
s
.77169 .90869 m
.7738 .92955 L
s
.52328 .65316 m
.5253 .64982 L
s
.75875 .89369 m
.76148 .91275 L
s
.50999 .68597 m
.51176 .67906 L
s
.49227 .95384 m
.50555 .92953 L
s
.36278 .43262 m
.34789 .42884 L
s
.52036 .84226 m
.52676 .82673 L
s
.51166 .64199 m
.51303 .6381 L
s
.52888 .73574 m
.5321 .72766 L
s
.4993 .66599 m
.5003 .65927 L
s
.5127 .69268 m
.51468 .68564 L
s
.41654 .52229 m
.40939 .51699 L
s
.59679 .72325 m
.60147 .72469 L
s
.41658 .52271 m
.40945 .51741 L
s
.50943 .64007 m
.51066 .63608 L
s
.49863 .92518 m
.50977 .90303 L
s
.55079 .68001 m
.55404 .67819 L
s
.52469 .72421 m
.52757 .71644 L
s
.42662 .54117 m
.42074 .53556 L
s
.51358 .6963 m
.51563 .68915 L
s
.49944 .66773 m
.50047 .66095 L
s
.46184 .60023 m
.45971 .59404 L
s
.46306 .60238 m
.46104 .59618 L
s
.50823 .68541 m
.5099 .6784 L
s
.48755 .61766 m
.48734 .61284 L
s
.50975 .6888 m
.51153 .68175 L
s
.42408 .53758 m
.41791 .53202 L
s
.51127 .69236 m
.51317 .68524 L
s
.53005 .75185 m
.53359 .74291 L
s
.48628 .61649 m
.48599 .61164 L
s
.71692 .84708 m
.72113 .86066 L
s
.49431 .65903 m
.49496 .65231 L
s
.58294 .71062 m
.58723 .71096 L
s
.52179 .82918 m
.52762 .81465 L
s
.50136 .63256 m
.50209 .62823 L
s
.51397 .69891 m
.51606 .69166 L
s
.51602 .7037 m
.51827 .69636 L
s
.50097 .67194 m
.50212 .66507 L
s
.52967 .75192 m
.53321 .74295 L
s
.46563 .59258 m
.46369 .58724 L
s
.58701 .71464 m
.59141 .71528 L
s
.67941 .81692 m
.68434 .82541 L
s
.38821 .47898 m
.37733 .47435 L
s
.6779 .81613 m
.68285 .82439 L
s
.76465 .90184 m
.76691 .9215 L
s
.4916 .65488 m
.49204 .64818 L
s
.36768 .44379 m
.35368 .43986 L
s
.51902 .71285 m
.52151 .70526 L
s
.50824 .68804 m
.50993 .68092 L
s
.4656 .59304 m
.46366 .58769 L
s
.70395 .83698 m
.70842 .84869 L
s
.49082 .65411 m
.49121 .64739 L
s
.50022 .63193 m
.50087 .62755 L
s
.75784 .89429 m
.76039 .91298 L
s
.49009 .65297 m
.49043 .64626 L
s
.53814 .66902 m
.54082 .66643 L
s
.52648 .73961 m
.52967 .73112 L
s
.57418 .70292 m
.5782 .7026 L
s
.5235 .72847 m
.52639 .72038 L
s
.51321 .85927 m
.52036 .84226 L
s
.566 .69537 m
.56975 .69448 L
s
.584 .71227 m
.58828 .71266 L
s
.48104 .6372 m
.48066 .63063 L
s
.52141 .72301 m
.52413 .71506 L
s
.46375 .60652 m
.46184 .60023 L
s
.44335 .57067 m
.43938 .56474 L
s
.44694 .57667 m
.44335 .57067 L
s
.46486 .6087 m
.46306 .60238 L
s
.45019 .58273 m
.44694 .57667 L
s
.48495 .61646 m
.48456 .61156 L
s
.48232 .64021 m
.48205 .63359 L
s
.43938 .56474 m
.435 .55886 L
s
.44511 .57393 m
.44133 .56796 L
s
.44853 .57996 m
.44511 .57393 L
s
.44133 .56796 m
.43716 .56205 L
s
.49984 .91047 m
.50998 .88949 L
s
.50234 .67864 m
.50363 .67158 L
s
.50854 .69171 m
.51028 .68445 L
s
.5219 .72716 m
.5247 .71902 L
s
.51891 .71771 m
.52145 .70986 L
s
.55495 .68548 m
.55829 .68386 L
s
.52563 .74458 m
.52888 .73574 L
s
.45161 .58606 m
.44853 .57996 L
s
.68731 .82338 m
.69201 .83284 L
s
.45312 .58885 m
.45019 .58273 L
s
.42074 .53556 m
.41424 .53004 L
s
.51533 .84508 m
.52179 .82918 L
s
.43716 .56205 m
.43255 .5562 L
s
.52369 .65619 m
.52566 .65282 L
s
.51093 .69865 m
.51287 .69121 L
s
.3717 .45341 m
.35843 .44936 L
s
.435 .55886 m
.43015 .55305 L
s
.50824 .69334 m
.50999 .68597 L
s
.57879 .70832 m
.58288 .70827 L
s
.52641 .76164 m
.53005 .75185 L
s
.4544 .59223 m
.45161 .58606 L
s
.53285 .66535 m
.53525 .66244 L
s
.52742 .66018 m
.52956 .65698 L
s
.49829 .67305 m
.4993 .66599 L
s
.5218 .73265 m
.52469 .72421 L
s
.51076 .7002 m
.5127 .69268 L
s
.52604 .76174 m
.52967 .75192 L
s
.41791 .53202 m
.41109 .52656 L
s
.73906 .8745 m
.74222 .89049 L
s
.45577 .59506 m
.45312 .58885 L
s
.59214 .7211 m
.59655 .72203 L
s
.75879 .89618 m
.7611 .91481 L
s
.44258 .57216 m
.43858 .56619 L
s
.44621 .57819 m
.44258 .57216 L
s
.48792 .62108 m
.48773 .61626 L
s
.40939 .51699 m
.4015 .51182 L
s
.43255 .5562 m
.42745 .55042 L
s
.46739 .59791 m
.46563 .59258 L
s
.52015 .65354 m
.52192 .64998 L
s
.44948 .58428 m
.44621 .57819 L
s
.46546 .61292 m
.46375 .60652 L
s
.50821 .64201 m
.50931 .63792 L
s
.40945 .51741 m
.40157 .51224 L
s
.51155 .70396 m
.51358 .6963 L
s
.43858 .56619 m
.43415 .56029 L
s
.49841 .67486 m
.49944 .66773 L
s
.46647 .61513 m
.46486 .6087 L
s
.35663 .42859 m
.34097 .42514 L
s
.56997 .70057 m
.57376 .69988 L
s
.53213 .66521 m
.53447 .66225 L
s
.56787 .69863 m
.5716 .6978 L
s
.49138 .62516 m
.49142 .62044 L
s
.50657 .69285 m
.50823 .68541 L
s
.43015 .55305 m
.4248 .54731 L
s
.50798 .69632 m
.50975 .6888 L
s
.46736 .59838 m
.4656 .59304 L
s
.49364 .66605 m
.49431 .65903 L
s
.45244 .59045 m
.44948 .58428 L
s
.45692 .59849 m
.4544 .59223 L
s
.50939 .69995 m
.51127 .69236 L
s
.52324 .74886 m
.52648 .73961 L
s
.51379 .71158 m
.51602 .7037 L
s
.70027 .8308 m
.70464 .84214 L
s
.51189 .70667 m
.51397 .69891 L
s
.53159 .6649 m
.5339 .66191 L
s
.55771 .68936 m
.56109 .68787 L
s
.5513 .68341 m
.55444 .68152 L
s
.49982 .67916 m
.50097 .67194 L
s
.52042 .65442 m
.52218 .65087 L
s
.50473 .63915 m
.50562 .63491 L
s
.49111 .66187 m
.4916 .65488 L
s
.51653 .72103 m
.51902 .71285 L
s
.45815 .60136 m
.45577 .59506 L
s
.43415 .56029 m
.42927 .55446 L
s
.50509 .87775 m
.51321 .85927 L
s
.77073 .91093 m
.77232 .93105 L
s
.52058 .73725 m
.5235 .72847 L
s
.49039 .6611 m
.49082 .65411 L
s
.48134 .64398 m
.48104 .6372 L
s
.48971 .65995 m
.49009 .65297 L
s
.56088 .69274 m
.56434 .69143 L
s
.50655 .69561 m
.50824 .68804 L
s
.59245 .72235 m
.59679 .72325 L
s
.45511 .59671 m
.45244 .59045 L
s
.48408 .96451 m
.49832 .93974 L
s
.54687 .67973 m
.54982 .67756 L
s
.51866 .73161 m
.52141 .72301 L
s
.54194 .67515 m
.54469 .6727 L
s
.56559 .69729 m
.5692 .69627 L
s
.50805 .8624 m
.51533 .84508 L
s
.42745 .55042 m
.42183 .54472 L
s
.48251 .64704 m
.48232 .64021 L
s
.5223 .75421 m
.52563 .74458 L
s
.70487 .83636 m
.70904 .84815 L
s
.48776 .6225 m
.48755 .61766 L
s
.5226 .77233 m
.52641 .76164 L
s
.51906 .73597 m
.5219 .72716 L
s
.48657 .62137 m
.48628 .61649 L
s
.45918 .60485 m
.45692 .59849 L
s
.51635 .72617 m
.51891 .71771 L
s
.52225 .77246 m
.52604 .76174 L
s
.46699 .61945 m
.46546 .61292 L
s
.70767 .83978 m
.71172 .85184 L
s
.50679 .69944 m
.50854 .69171 L
s
.42927 .55446 m
.42387 .54871 L
s
.50104 .6861 m
.50234 .67864 L
s
.41424 .53004 m
.40706 .52466 L
s
.4248 .54731 m
.4189 .54166 L
s
.4603 .60776 m
.45815 .60136 L
s
.46791 .62169 m
.46647 .61513 L
s
.51046 .646 m
.51166 .64199 L
s
.5215 .65668 m
.52328 .65316 L
s
.45752 .60306 m
.45511 .59671 L
s
.51886 .7418 m
.5218 .73265 L
s
.50899 .70659 m
.51093 .69865 L
s
.50836 .64418 m
.50943 .64007 L
s
.77528 .91721 m
.77645 .93776 L
s
.69424 .82547 m
.69858 .83597 L
s
.50649 .70116 m
.50824 .69334 L
s
.71366 .84686 m
.71746 .85955 L
s
.50074 .63697 m
.50136 .63256 L
s
.58297 .71451 m
.58701 .71464 L
s
.5088 .70823 m
.51076 .7002 L
s
.49726 .68047 m
.49829 .67305 L
s
.579 .71077 m
.58294 .71062 L
s
.469 .60323 m
.46739 .59791 L
s
.51987 .75892 m
.52324 .74886 L
s
.48533 .62139 m
.48495 .61646 L
s
.46121 .61131 m
.45918 .60485 L
s
.41109 .52656 m
.40356 .52125 L
s
.48565 .94872 m
.49863 .92518 L
s
.71673 .85061 m
.72038 .86361 L
s
.49967 .63639 m
.50022 .63193 L
s
.5095 .71213 m
.51155 .70396 L
s
.69313 .82472 m
.69743 .83503 L
s
.54787 .68217 m
.55079 .68001 L
s
.42183 .54472 m
.41562 .53912 L
s
.46897 .6037 m
.46736 .59838 L
s
.49736 .68235 m
.49841 .67486 L
s
.73361 .86967 m
.73663 .88468 L
s
.45969 .60951 m
.45752 .60306 L
s
.51758 .74675 m
.52058 .73725 L
s
.50491 .70075 m
.50657 .69285 L
s
.46222 .61427 m
.4603 .60776 L
s
.51856 .78398 m
.5226 .77233 L
s
.51153 .72003 m
.51379 .71158 L
s
.49293 .6734 m
.49364 .66605 L
s
.5062 .70431 m
.50798 .69632 L
s
.5075 .70805 m
.50939 .69995 L
s
.51882 .76467 m
.5223 .75421 L
s
.50979 .71497 m
.51189 .70667 L
s
.51401 .72983 m
.51653 .72103 L
s
.42387 .54871 m
.41792 .54306 L
s
.70411 .83699 m
.70809 .84849 L
s
.48155 .65099 m
.48134 .64398 L
s
.51821 .78414 m
.52225 .77246 L
s
.58008 .71238 m
.584 .71227 L
s
.46834 .62612 m
.46699 .61945 L
s
.49059 .66915 m
.49111 .66187 L
s
.49864 .68678 m
.49982 .67916 L
s
.72092 .85576 m
.72436 .86917 L
s
.51585 .74089 m
.51866 .73161 L
s
.37569 .46862 m
.36331 .46447 L
s
.48991 .66839 m
.49039 .6611 L
s
.57053 .70369 m
.57418 .70292 L
s
.48928 .66722 m
.48971 .65995 L
s
.80417 .95247 m
.80342 .97699 L
s
.46918 .6284 m
.46791 .62169 L
s
.48262 .65411 m
.48251 .64704 L
s
.51613 .74548 m
.51906 .73597 L
s
.48808 .93286 m
.49984 .91047 L
s
.68285 .82439 m
.68717 .83277 L
s
.7697 .91183 m
.77096 .9314 L
s
.50484 .70364 m
.50655 .69561 L
s
.4189 .54166 m
.41238 .53612 L
s
.49976 .88112 m
.50805 .8624 L
s
.4015 .51182 m
.39278 .50685 L
s
.68434 .82541 m
.68862 .83398 L
s
.56261 .69667 m
.566 .69537 L
s
.46303 .6179 m
.46121 .61131 L
s
.49578 .89765 m
.50509 .87775 L
s
.51373 .73527 m
.51635 .72617 L
s
.48812 .62594 m
.48792 .62108 L
s
.53575 .67187 m
.53814 .66902 L
s
.40157 .51224 m
.39287 .50727 L
s
.73318 .87118 m
.73608 .88591 L
s
.69648 .83476 m
.70051 .84491 L
s
.72628 .86227 m
.72945 .87624 L
s
.58808 .72068 m
.59214 .7211 L
s
.5158 .75168 m
.51886 .7418 L
s
.74105 .87988 m
.74361 .89559 L
s
.46163 .61608 m
.45969 .60951 L
s
.43624 .56329 m
.43162 .55773 L
s
.44044 .56887 m
.43624 .56329 L
s
.47665 .97933 m
.49227 .95384 L
s
.71096 .8484 m
.71457 .86033 L
s
.50502 .70766 m
.50679 .69944 L
s
.51632 .76982 m
.51987 .75892 L
s
.44425 .57444 m
.44044 .56887 L
s
.49972 .69397 m
.50104 .6861 L
s
.46394 .62091 m
.46222 .61427 L
s
.49136 .62992 m
.49138 .62516 L
s
.57507 .70883 m
.57879 .70832 L
s
.50701 .71505 m
.50899 .70659 L
s
.55195 .68746 m
.55495 .68548 L
s
.43162 .55773 m
.42651 .5522 L
s
.51418 .79663 m
.51856 .78398 L
s
.52196 .65974 m
.52369 .65619 L
s
.75896 .89992 m
.76064 .91793 L
s
.51383 .79681 m
.51821 .78414 L
s
.37733 .47435 m
.3653 .47016 L
s
.5047 .70948 m
.50649 .70116 L
s
.74741 .88675 m
.74962 .90325 L
s
.44771 .58002 m
.44425 .57444 L
s
.40706 .52466 m
.39915 .51944 L
s
.51512 .776 m
.51882 .76467 L
s
.5068 .71678 m
.5088 .70823 L
s
.46953 .63296 m
.46834 .62612 L
s
.51444 .75702 m
.51758 .74675 L
s
.41562 .53912 m
.40878 .53365 L
s
.49619 .68826 m
.49726 .68047 L
s
.50725 .6462 m
.50821 .64201 L
s
.41792 .54306 m
.41136 .53753 L
s
.47048 .60854 m
.469 .60323 L
s
.52553 .66357 m
.52742 .66018 L
s
.48797 .62737 m
.48776 .6225 L
s
.50741 .72085 m
.5095 .71213 L
s
.53073 .66849 m
.53285 .66535 L
s
.58845 .72196 m
.59245 .72235 L
s
.48686 .62627 m
.48657 .62137 L
s
.47029 .63528 m
.46918 .6284 L
s
.73724 .87551 m
.73983 .89067 L
s
.46465 .62462 m
.46303 .6179 L
s
.5186 .65725 m
.52015 .65354 L
s
.51139 .73928 m
.51401 .72983 L
s
.50921 .72907 m
.51153 .72003 L
s
.42651 .5522 m
.42089 .54672 L
s
.51291 .75089 m
.51585 .74089 L
s
.48167 .65824 m
.48155 .65099 L
s
.49626 .69022 m
.49736 .68235 L
s
.50396 .64348 m
.50473 .63915 L
s
.56655 .70168 m
.56997 .70057 L
s
.46336 .62278 m
.46163 .61608 L
s
.47045 .60901 m
.46897 .6037 L
s
.50319 .70913 m
.50491 .70075 L
s
.50763 .72382 m
.50979 .71497 L
s
.50438 .7128 m
.5062 .70431 L
s
.56451 .69987 m
.56787 .69863 L
s
.50556 .71666 m
.5075 .70805 L
s
.49217 .68108 m
.49293 .6734 L
s
.51307 .75575 m
.51613 .74548 L
s
.73325 .87248 m
.73594 .88702 L
s
.45085 .58559 m
.44771 .58002 L
s
.49 .67676 m
.49059 .66915 L
s
.48264 .66144 m
.48262 .65411 L
s
.53005 .6684 m
.53213 .66521 L
s
.49742 .6948 m
.49864 .68678 L
s
.46546 .6277 m
.46394 .62091 L
s
.48936 .676 m
.48991 .66839 L
s
.48878 .6748 m
.48928 .66722 L
s
.74202 .88144 m
.74432 .8971 L
s
.7486 .8896 m
.75059 .90604 L
s
.51887 .65814 m
.52042 .65442 L
s
.40356 .52125 m
.39526 .51614 L
s
.511 .74506 m
.51373 .73527 L
s
.51258 .76234 m
.5158 .75168 L
s
.55469 .69122 m
.55771 .68936 L
s
.51251 .78162 m
.51632 .76982 L
s
.52955 .66812 m
.53159 .6649 L
s
.50309 .71217 m
.50484 .70364 L
s
.41238 .53612 m
.4052 .53074 L
s
.5485 .68563 m
.5513 .68341 L
s
.69201 .83284 m
.69591 .84219 L
s
.50938 .81033 m
.51418 .79663 L
s
.72328 .86055 m
.72629 .87391 L
s
.48571 .62633 m
.48533 .62139 L
s
.55777 .69443 m
.56088 .69274 L
s
.50902 .81054 m
.51383 .79681 L
s
.56234 .69871 m
.56559 .69729 L
s
.51111 .78826 m
.51512 .776 L
s
.54425 .6822 m
.54687 .67973 L
s
.47056 .63997 m
.46953 .63296 L
s
.5395 .67787 m
.54194 .67515 L
s
.50319 .71638 m
.50502 .70766 L
s
.42089 .54672 m
.41468 .54131 L
s
.46608 .6315 m
.46465 .62462 L
s
.51109 .76808 m
.51444 .75702 L
s
.49834 .70228 m
.49972 .69397 L
s
.50942 .65013 m
.51046 .646 L
s
.50496 .72406 m
.50701 .71505 L
s
.4537 .59114 m
.45085 .58559 L
s
.46489 .62964 m
.46336 .62278 L
s
.80345 .95418 m
.80223 .97804 L
s
.50021 .64145 m
.50074 .63697 L
s
.50743 .64839 m
.50836 .64418 L
s
.57928 .71485 m
.58297 .71451 L
s
.47124 .64235 m
.47029 .63528 L
s
.49021 .90114 m
.49976 .88112 L
s
.43749 .56972 m
.43308 .56414 L
s
.4415 .57531 m
.43749 .56972 L
s
.50285 .71832 m
.5047 .70948 L
s
.43308 .56414 m
.42822 .55858 L
s
.50472 .7259 m
.5068 .71678 L
s
.7402 .88037 m
.74242 .89564 L
s
.51994 .66038 m
.5215 .65668 L
s
.57543 .71137 m
.579 .71077 L
s
.50979 .76164 m
.51291 .75089 L
s
.49921 .64091 m
.49967 .63639 L
s
.4668 .63465 m
.46546 .6277 L
s
.50863 .74942 m
.51139 .73928 L
s
.5098 .7668 m
.51307 .75575 L
s
.49506 .69647 m
.49619 .68826 L
s
.44514 .58091 m
.4415 .57531 L
s
.50522 .73015 m
.50741 .72085 L
s
.41136 .53753 m
.40413 .53215 L
s
.50678 .73873 m
.50921 .72907 L
s
.48169 .66576 m
.48167 .65824 L
s
.50835 .79435 m
.51251 .78162 L
s
.42822 .55858 m
.42287 .55307 L
s
.40878 .53365 m
.40125 .52836 L
s
.50537 .73327 m
.50763 .72382 L
s
.50911 .77383 m
.51258 .76234 L
s
.50353 .72583 m
.50556 .71666 L
s
.5014 .71802 m
.50319 .70913 L
s
.4951 .69851 m
.49626 .69022 L
s
.50247 .72182 m
.50438 .7128 L
s
.48833 .63082 m
.48812 .62594 L
s
.70842 .84869 m
.7117 .8599 L
s
.50402 .82513 m
.50938 .81033 L
s
.34789 .42884 m
.33139 .42599 L
s
.49133 .68913 m
.49217 .68108 L
s
.5081 .75555 m
.511 .74506 L
s
.47184 .61384 m
.47048 .60854 L
s
.57652 .71294 m
.58008 .71238 L
s
.43479 .5678 m
.43014 .56223 L
s
.43902 .5734 m
.43479 .5678 L
s
.48256 .66905 m
.48264 .66144 L
s
.485 .91881 m
.49578 .89765 L
s
.48933 .68472 m
.49 .67676 L
s
.50366 .82536 m
.50902 .81054 L
s
.50672 .80149 m
.51111 .78826 L
s
.44286 .579 m
.43902 .5734 L
s
.35368 .43986 m
.33818 .43675 L
s
.49613 .70325 m
.49742 .6948 L
s
.48874 .68394 m
.48936 .676 L
s
.44845 .5865 m
.44514 .58091 L
s
.39278 .50685 m
.38317 .50215 L
s
.4882 .68272 m
.48878 .6748 L
s
.43014 .56223 m
.42501 .5567 L
s
.39287 .50727 m
.38328 .50257 L
s
.46733 .63855 m
.46608 .6315 L
s
.47181 .61432 m
.47045 .60901 L
s
.50124 .72122 m
.50309 .71217 L
s
.54528 .68464 m
.54787 .68217 L
s
.4563 .59668 m
.4537 .59114 L
s
.58436 .72073 m
.58808 .72068 L
s
.46624 .63666 m
.46489 .62964 L
s
.47143 .64718 m
.47056 .63997 L
s
.56725 .70487 m
.57053 .70369 L
s
.50746 .77999 m
.51109 .76808 L
s
.39915 .51944 m
.39042 .51447 L
s
.41468 .54131 m
.40785 .53602 L
s
.49139 .63472 m
.49136 .62992 L
s
.35843 .44936 m
.34375 .44604 L
s
.42287 .55307 m
.41697 .54763 L
s
.44635 .5846 m
.44286 .579 L
s
.47204 .64962 m
.47124 .64235 L
s
.50125 .72564 m
.50319 .71638 L
s
.46796 .64178 m
.4668 .63465 L
s
.50279 .73365 m
.50496 .72406 L
s
.42501 .5567 m
.41936 .55122 L
s
.4052 .53074 m
.3973 .52555 L
s
.49688 .71105 m
.49834 .70228 L
s
.50642 .7732 m
.50979 .76164 L
s
.55958 .69835 m
.56261 .69667 L
s
.50625 .77868 m
.5098 .7668 L
s
.70464 .84214 m
.70794 .85303 L
s
.48716 .6312 m
.48686 .62627 L
s
.4882 .63227 m
.48797 .62737 L
s
.45146 .59208 m
.44845 .5865 L
s
.50568 .76028 m
.50863 .74942 L
s
.50374 .80807 m
.50835 .79435 L
s
.50252 .7356 m
.50472 .7259 L
s
.50088 .7277 m
.50285 .71832 L
s
.57171 .70978 m
.57507 .70883 L
s
.53365 .67497 m
.53575 .67187 L
s
.50532 .78618 m
.50911 .77383 L
s
.72113 .86066 m
.72383 .87336 L
s
.58479 .72204 m
.58845 .72196 L
s
.50418 .74905 m
.50678 .73873 L
s
.73136 .87215 m
.73366 .88604 L
s
.5029 .74006 m
.50522 .73015 L
s
.44953 .59019 m
.44635 .5846 L
s
.79429 .9453 m
.79324 .96738 L
s
.49384 .7051 m
.49506 .69647 L
s
.4816 .67356 m
.48169 .66576 L
s
.46729 .99011 m
.48408 .96451 L
s
.50296 .74335 m
.50537 .73327 L
s
.69858 .83597 m
.70199 .84613 L
s
.50497 .76681 m
.5081 .75555 L
s
.49796 .84104 m
.50402 .82513 L
s
.50181 .81573 m
.50672 .80149 L
s
.84886 1.01251 m
.84378 1.04291 L
s
.50137 .73558 m
.50353 .72583 L
s
.47431 .95631 m
.48808 .93286 L
s
.50643 .65049 m
.50725 .6462 L
s
.46841 .64579 m
.46733 .63855 L
s
.50044 .7314 m
.50247 .72182 L
s
.49759 .84129 m
.50366 .82536 L
s
.52045 .66346 m
.52196 .65974 L
s
.4995 .72745 m
.5014 .71802 L
s
.4674 .64387 m
.46624 .63666 L
s
.8201 .9768 m
.81723 1.00262 L
s
.39526 .51614 m
.38612 .5113 L
s
.68717 .83277 m
.69074 .84105 L
s
.5493 .68975 m
.55195 .68746 L
s
.49384 .70724 m
.4951 .69851 L
s
.4704 .97322 m
.48565 .94872 L
s
.41697 .54763 m
.41048 .54228 L
s
.48238 .67696 m
.48256 .66905 L
s
.48608 .6313 m
.48571 .62633 L
s
.49041 .69758 m
.49133 .68913 L
s
.69743 .83503 m
.70081 .84502 L
s
.50347 .79279 m
.50746 .77999 L
s
.45868 .6022 m
.4563 .59668 L
s
.50332 .64788 m
.50396 .64348 L
s
.47216 .6546 m
.47143 .64718 L
s
.41936 .55122 m
.41315 .54583 L
s
.48857 .69304 m
.48933 .68472 L
s
.83339 .99347 m
.82947 1.02129 L
s
.68862 .83398 m
.69213 .84243 L
s
.48802 .69225 m
.48874 .68394 L
s
.49474 .71216 m
.49613 .70325 L
s
.48753 .691 m
.4882 .68272 L
s
.49927 .73083 m
.50124 .72122 L
s
.40413 .53215 m
.39618 .527 L
s
.52389 .66714 m
.52553 .66357 L
s
.51726 .66112 m
.5186 .65725 L
s
.56348 .70318 m
.56655 .70168 L
s
.46896 .6491 m
.46796 .64178 L
s
.4727 .65711 m
.47204 .64962 L
s
.70904 .84815 m
.71202 .85935 L
s
.4542 .59764 m
.45146 .59208 L
s
.52887 .67185 m
.53073 .66849 L
s
.56151 .70149 m
.56451 .69987 L
s
.43959 .59218 m
.43572 .58588 L
s
.4431 .59859 m
.43959 .59218 L
s
.50271 .7856 m
.50642 .7732 L
s
.50233 .79143 m
.50625 .77868 L
s
.45242 .59577 m
.44953 .59019 L
s
.43572 .58588 m
.43145 .57969 L
s
.43883 .59115 m
.43488 .58486 L
s
.4424 .59754 m
.43883 .59115 L
s
.44627 .60512 m
.4431 .59859 L
s
.4731 .61913 m
.47184 .61384 L
s
.40125 .52836 m
.39295 .5233 L
s
.40785 .53602 m
.40033 .53088 L
s
.49917 .73548 m
.50125 .72564 L
s
.50045 .74386 m
.50279 .73365 L
s
.44563 .60404 m
.4424 .59754 L
s
.49857 .82281 m
.50374 .80807 L
s
.43488 .58486 m
.43053 .57869 L
s
.50245 .77191 m
.50568 .76028 L
s
.77936 .92876 m
.77902 .94852 L
s
.50112 .79943 m
.50532 .78618 L
s
.51753 .662 m
.51887 .65814 L
s
.49529 .72031 m
.49688 .71105 L
s
.52824 .6718 m
.53005 .6684 L
s
.43145 .57969 m
.42674 .57362 L
s
.50014 .74592 m
.50252 .7356 L
s
.49876 .73766 m
.50088 .7277 L
s
.47307 .61961 m
.47181 .61432 L
s
.44912 .61176 m
.44627 .60512 L
s
.50136 .76007 m
.50418 .74905 L
s
.44855 .61067 m
.44563 .60404 L
s
.55201 .69341 m
.55469 .69122 L
s
.50038 .75062 m
.5029 .74006 L
s
.50153 .77886 m
.50497 .76681 L
s
.52776 .67154 m
.52955 .66812 L
s
.43053 .57869 m
.42573 .57264 L
s
.36331 .46447 m
.34966 .461 L
s
.49979 .646 m
.50021 .64145 L
s
.54603 .68815 m
.5485 .68563 L
s
.47913 .9223 m
.49021 .90114 L
s
.4684 .65128 m
.4674 .64387 L
s
.46932 .65324 m
.46841 .64579 L
s
.43376 .57272 m
.42912 .56714 L
s
.43798 .57832 m
.43376 .57272 L
s
.71172 .85184 m
.71449 .86322 L
s
.50035 .75409 m
.50296 .74335 L
s
.49628 .831 m
.50181 .81573 L
s
.55944 .7005 m
.56234 .69871 L
s
.57595 .71563 m
.57928 .71485 L
s
.555 .69648 m
.55777 .69443 L
s
.75436 .90001 m
.75531 .91642 L
s
.42912 .56714 m
.42401 .56161 L
s
.48138 .68168 m
.4816 .67356 L
s
.50854 .65436 m
.50942 .65013 L
s
.49251 .71418 m
.49384 .7051 L
s
.44181 .58393 m
.43798 .57832 L
s
.49902 .74595 m
.50137 .73558 L
s
.49902 .80651 m
.50347 .79279 L
s
.50664 .6527 m
.50743 .64839 L
s
.48857 .63573 m
.48833 .63082 L
s
.34097 .42514 m
.32366 .42276 L
s
.49884 .64549 m
.49921 .64091 L
s
.49824 .74158 m
.50044 .7314 L
s
.45117 .61743 m
.44855 .61067 L
s
.45169 .61854 m
.44912 .61176 L
s
.49743 .73745 m
.4995 .72745 L
s
.41315 .54583 m
.40631 .54057 L
s
.47273 .66226 m
.47216 .6546 L
s
.42674 .57362 m
.42156 .56767 L
s
.49105 .85806 m
.49796 .84104 L
s
.57222 .71239 m
.57543 .71137 L
s
.54194 .68495 m
.54425 .6822 L
s
.41048 .54228 m
.40334 .53708 L
s
.48207 .68519 m
.48238 .67696 L
s
.49245 .71643 m
.49384 .70724 L
s
.53737 .68085 m
.5395 .67787 L
s
.46085 .6077 m
.45868 .6022 L
s
.49067 .85832 m
.49759 .84129 L
s
.48936 .70643 m
.49041 .69758 L
s
.46979 .65665 m
.46896 .6491 L
s
.70051 .84491 m
.7035 .85464 L
s
.42573 .57264 m
.42045 .56672 L
s
.48769 .70175 m
.48857 .69304 L
s
.45671 .60319 m
.4542 .59764 L
s
.42401 .56161 m
.4184 .55614 L
s
.45507 .60133 m
.45242 .59577 L
s
.49712 .74102 m
.49927 .73083 L
s
.4732 .66485 m
.4727 .65711 L
s
.70809 .84849 m
.71089 .85936 L
s
.49859 .79888 m
.50271 .7856 L
s
.49321 .72155 m
.49474 .71216 L
s
.44531 .58954 m
.44181 .58393 L
s
.51859 .66422 m
.51994 .66038 L
s
.48717 .70095 m
.48802 .69225 L
s
.49796 .80509 m
.50233 .79143 L
s
.48673 .69966 m
.48753 .691 L
s
.3653 .47016 m
.35204 .46661 L
s
.75375 .90051 m
.7546 .91667 L
s
.3973 .52555 m
.3886 .52064 L
s
.45352 .62432 m
.45117 .61743 L
s
.57332 .71392 m
.57652 .71294 L
s
.49889 .78434 m
.50245 .77191 L
s
.45399 .62546 m
.45169 .61854 L
s
.49146 .63954 m
.49139 .63472 L
s
.58099 .72123 m
.58436 .72073 L
s
.4964 .81363 m
.50112 .79943 L
s
.49789 .75472 m
.50045 .74386 L
s
.43958 .59756 m
.43581 .59116 L
s
.44299 .60407 m
.43958 .59756 L
s
.79913 .95358 m
.79727 .97581 L
s
.4969 .74592 m
.49917 .73548 L
s
.39042 .51447 m
.38083 .50983 L
s
.43581 .59116 m
.43165 .58489 L
s
.4927 .83857 m
.49857 .82281 L
s
.44607 .61071 m
.44299 .60407 L
s
.49825 .77183 m
.50136 .76007 L
s
.49753 .75691 m
.50014 .74592 L
s
.49771 .79174 m
.50153 .77886 L
s
.48748 .63614 m
.48716 .6312 L
s
.42156 .56767 m
.41585 .56186 L
s
.43165 .58489 m
.42707 .57874 L
s
.46922 .65891 m
.4684 .65128 L
s
.49355 .7301 m
.49529 .72031 L
s
.49644 .74824 m
.49876 .73766 L
s
.48846 .63719 m
.4882 .63227 L
s
.49762 .76186 m
.50038 .75062 L
s
.47006 .66092 m
.46932 .65324 L
s
.71746 .85955 m
.71982 .87136 L
s
.38317 .50215 m
.37259 .49785 L
s
.49747 .76553 m
.50035 .75409 L
s
.43685 .59435 m
.43283 .58802 L
s
.4405 .60081 m
.43685 .59435 L
s
.38328 .50257 m
.37273 .49827 L
s
.44849 .59515 m
.44531 .58954 L
s
.44379 .60738 m
.4405 .60081 L
s
.4184 .55614 m
.41222 .55076 L
s
.44885 .61748 m
.44607 .61071 L
s
.42045 .56672 m
.41464 .56094 L
s
.75005 .89709 m
.75095 .91265 L
s
.47241 .94096 m
.485 .91881 L
s
.56432 .70644 m
.56725 .70487 L
s
.45562 .63137 m
.45352 .62432 L
s
.49399 .82119 m
.49902 .80651 L
s
.43283 .58802 m
.42839 .58182 L
s
.43077 .57261 m
.42591 .56706 L
s
.4352 .5782 m
.43077 .57261 L
s
.49645 .75697 m
.49902 .74595 L
s
.45604 .63254 m
.45399 .62546 L
s
.43917 .59914 m
.43541 .59272 L
s
.44258 .60569 m
.43917 .59914 L
s
.43923 .58381 m
.4352 .5782 L
s
.69591 .84219 m
.69886 .85119 L
s
.43541 .59272 m
.43125 .58642 L
s
.48104 .69013 m
.48138 .68168 L
s
.48997 .84731 m
.49628 .831 L
s
.49582 .75238 m
.49824 .74158 L
s
.44676 .61409 m
.44379 .60738 L
s
.47314 .67019 m
.47273 .66226 L
s
.54301 .68738 m
.54528 .68464 L
s
.49101 .72375 m
.49251 .71418 L
s
.49516 .74806 m
.49743 .73745 L
s
.42707 .57874 m
.42202 .57272 L
s
.58148 .72256 m
.58479 .72204 L
s
.44566 .61236 m
.44258 .60569 L
s
.47045 .66444 m
.46979 .65665 L
s
.40033 .53088 m
.39206 .52597 L
s
.42591 .56706 m
.42056 .56156 L
s
.43125 .58642 m
.42667 .58025 L
s
.39618 .527 m
.38743 .52212 L
s
.48647 .63627 m
.48608 .6313 L
s
.47427 .62441 m
.4731 .61913 L
s
.48162 .69376 m
.48207 .68519 L
s
.49091 .72611 m
.49245 .71643 L
s
.45134 .6244 m
.44885 .61748 L
s
.42839 .58182 m
.42351 .57574 L
s
.47354 .67285 m
.4732 .66485 L
s
.49393 .81307 m
.49859 .79888 L
s
.56871 .71112 m
.57171 .70978 L
s
.4429 .58943 m
.43923 .58381 L
s
.49475 .75183 m
.49712 .74102 L
s
.45821 1.00525 m
.47665 .97933 L
s
.45748 .60687 m
.45507 .60133 L
s
.48817 .71573 m
.48936 .70643 L
s
.49302 .81968 m
.49796 .80509 L
s
.44944 .62094 m
.44676 .61409 L
s
.43366 .57735 m
.4291 .57177 L
s
.43781 .58295 m
.43366 .57735 L
s
.40631 .54057 m
.39879 .53548 L
s
.72038 .86361 m
.7225 .87561 L
s
.4291 .57177 m
.4241 .56623 L
s
.5569 .70037 m
.55958 .69835 L
s
.48667 .71089 m
.48769 .70175 L
s
.44843 .61918 m
.44566 .61236 L
s
.459 .60871 m
.45671 .60319 L
s
.49151 .73147 m
.49321 .72155 L
s
.49489 .79762 m
.49889 .78434 L
s
.48619 .71007 m
.48717 .70095 L
s
.48579 .70873 m
.48673 .69966 L
s
.77624 .92762 m
.77558 .94643 L
s
.47425 .62488 m
.47307 .61961 L
s
.46285 .61317 m
.46085 .6077 L
s
.49506 .76626 m
.49789 .75472 L
s
.45747 .63859 m
.45562 .63137 L
s
.49438 .757 m
.4969 .74592 L
s
.38612 .5113 m
.37607 .50685 L
s
.44159 .58857 m
.43781 .58295 L
s
.42667 .58025 m
.42162 .57422 L
s
.41585 .56186 m
.40958 .55622 L
s
.49104 .82878 m
.4964 .81363 L
s
.40334 .53708 m
.39549 .53208 L
s
.45785 .63979 m
.45604 .63254 L
s
.50576 .65487 m
.50643 .65049 L
s
.49478 .78436 m
.49825 .77183 L
s
.42056 .56156 m
.41468 .55614 L
s
.4514 .60074 m
.44849 .59515 L
s
.4241 .56623 m
.41859 .56075 L
s
.53183 .67828 m
.53365 .67497 L
s
.39295 .5233 m
.38383 .51856 L
s
.49462 .76859 m
.49753 .75691 L
s
.46987 .66679 m
.46922 .65891 L
s
.4934 .80549 m
.49771 .79174 L
s
.75203 .90036 m
.75264 .91597 L
s
.42202 .57272 m
.41647 .56685 L
s
.48309 .87612 m
.49105 .85806 L
s
.47063 .66885 m
.47006 .66092 L
s
.5028 .65236 m
.50332 .64788 L
s
.49454 .77382 m
.49762 .76186 L
s
.45356 .63147 m
.45134 .6244 L
s
.45183 .62794 m
.44944 .62094 L
s
.71457 .86033 m
.71679 .87141 L
s
.45091 .62614 m
.44843 .61918 L
s
.49386 .75946 m
.49644 .74824 L
s
.42351 .57574 m
.41813 .56981 L
s
.49161 .74044 m
.49355 .7301 L
s
.44625 .59504 m
.4429 .58943 L
s
.49426 .7777 m
.49747 .76553 L
s
.4827 .87639 m
.49067 .85832 L
s
.41222 .55076 m
.40544 .54552 L
s
.41464 .56094 m
.40826 .55533 L
s
.77564 .92749 m
.77491 .9461 L
s
.51917 .66732 m
.52045 .66346 L
s
.48597 .85534 m
.4927 .83857 L
s
.49357 .76867 m
.49645 .75697 L
s
.54697 .69235 m
.5493 .68975 L
s
.44503 .59419 m
.44159 .58857 L
s
.49312 .76385 m
.49582 .75238 L
s
.47339 .67839 m
.47314 .67019 L
s
.78019 .93326 m
.77912 .95241 L
s
.49262 .7593 m
.49516 .74806 L
s
.47093 .67248 m
.47045 .66444 L
s
.48053 .69894 m
.48104 .69013 L
s
.48825 .83683 m
.49399 .82119 L
s
.48933 .73384 m
.49101 .72375 L
s
.42162 .57422 m
.41608 .56834 L
s
.56077 .70504 m
.56348 .70318 L
s
.51613 .66511 m
.51726 .66112 L
s
.41859 .56075 m
.41255 .55538 L
s
.72436 .86917 m
.72613 .88143 L
s
.45313 .63326 m
.45091 .62614 L
s
.4591 .646 m
.45747 .63859 L
s
.45396 .6351 m
.45183 .62794 L
s
.52248 .67089 m
.52389 .66714 L
s
.55886 .70347 m
.56151 .70149 L
s
.45553 .63871 m
.45356 .63147 L
s
.45944 .64723 m
.45785 .63979 L
s
.47372 .68115 m
.47354 .67285 L
s
.49209 .76329 m
.49475 .75183 L
s
.48884 .64065 m
.48857 .63573 L
s
.48916 .73632 m
.49091 .72611 L
s
.48102 .70272 m
.48162 .69376 L
s
.52728 .67539 m
.52887 .67185 L
s
.48863 .82818 m
.49393 .81307 L
s
.41468 .55614 m
.40822 .55085 L
s
.48679 .72551 m
.48817 .71573 L
s
.49947 .6506 m
.49979 .646 L
s
.49035 .81175 m
.49489 .79762 L
s
.74222 .89049 m
.74313 .9047 L
s
.43119 .57765 m
.42646 .57209 L
s
.4355 .58325 m
.43119 .57765 L
s
.48959 .74193 m
.49151 .73147 L
s
.48547 .72047 m
.48667 .71089 L
s
.48737 .83521 m
.49302 .81968 L
s
.49187 .77853 m
.49506 .76626 L
s
.41647 .56685 m
.41037 .56115 L
s
.4493 .60064 m
.44625 .59504 L
s
.57298 .71681 m
.57595 .71563 L
s
.41813 .56981 m
.41223 .56405 L
s
.48503 .71963 m
.48619 .71007 L
s
.48468 .71824 m
.48579 .70873 L
s
.51641 .666 m
.51753 .662 L
s
.42646 .57209 m
.42127 .56658 L
s
.48271 .86462 m
.48997 .84731 L
s
.4597 .61239 m
.45748 .60687 L
s
.49156 .76876 m
.49438 .757 L
s
.45406 .60631 m
.4514 .60074 L
s
.43943 .58886 m
.4355 .58325 L
s
.47034 .67493 m
.46987 .66679 L
s
.49085 .79768 m
.49478 .78436 L
s
.49858 .65013 m
.49884 .64549 L
s
.49136 .781 m
.49462 .76859 L
s
.47102 .67706 m
.47063 .66885 L
s
.5267 .67538 m
.52824 .6718 L
s
.44818 .59979 m
.44503 .59419 L
s
.46111 .61421 m
.459 .60871 L
s
.75869 .90928 m
.7587 .92547 L
s
.49106 .78653 m
.49454 .77382 L
s
.45509 .64056 m
.45313 .63326 L
s
.49096 .77136 m
.49386 .75946 L
s
.4885 .82012 m
.4934 .80549 L
s
.54967 .69591 m
.55201 .69341 L
s
.40958 .55622 m
.4027 .55078 L
s
.50601 .65709 m
.50664 .6527 L
s
.50782 .65869 m
.50854 .65436 L
s
.45584 .64244 m
.45396 .6351 L
s
.49063 .79064 m
.49426 .7777 L
s
.3886 .52064 m
.37905 .51608 L
s
.52624 .67514 m
.52776 .67154 L
s
.5569 .70262 m
.55944 .7005 L
s
.48942 .75136 m
.49161 .74044 L
s
.4849 .84488 m
.49104 .82878 L
s
.56936 .71381 m
.57222 .71239 L
s
.69074 .84105 m
.69345 .84903 L
s
.43517 .60098 m
.43117 .59455 L
s
.4388 .60755 m
.43517 .60098 L
s
.55259 .69884 m
.555 .69648 L
s
.44207 .61427 m
.4388 .60755 L
s
.42127 .56658 m
.41556 .56116 L
s
.45726 .64614 m
.45553 .63871 L
s
.54388 .69095 m
.54603 .68815 L
s
.4605 .65361 m
.4591 .646 L
s
.49159 .6444 m
.49146 .63954 L
s
.49032 .7811 m
.49357 .76867 L
s
.43729 .60528 m
.43352 .59876 L
s
.4407 .61195 m
.43729 .60528 L
s
.46469 .61862 m
.46285 .61317 L
s
.41608 .56834 m
.40999 .56264 L
s
.44301 .59447 m
.43943 .58886 L
s
.43117 .59455 m
.42676 .58825 L
s
.4608 .65487 m
.45944 .64723 L
s
.43352 .59876 m
.42936 .59238 L
s
.41255 .55538 m
.40591 .55013 L
s
.49007 .77601 m
.49312 .76385 L
s
.44502 .62113 m
.44207 .61427 L
s
.39879 .53548 m
.39053 .53064 L
s
.48783 .6411 m
.48748 .63614 L
s
.47347 .6869 m
.47339 .67839 L
s
.57797 .72216 m
.58099 .72123 L
s
.47124 .68081 m
.47093 .67248 L
s
.40826 .55533 m
.40125 .54994 L
s
.44378 .61876 m
.4407 .61195 L
s
.48975 .77122 m
.49262 .7593 L
s
.40544 .54552 m
.39799 .54047 L
s
.48876 .64212 m
.48846 .63719 L
s
.69213 .84243 m
.69474 .85052 L
s
.76148 .91275 m
.76122 .92918 L
s
.46617 .94424 m
.47913 .9223 L
s
.47538 .62966 m
.47427 .62441 L
s
.47986 .70814 m
.48053 .69894 L
s
.72945 .87624 m
.73078 .88885 L
s
.48741 .74448 m
.48933 .73384 L
s
.57047 .7153 m
.57332 .71392 L
s
.42936 .59238 m
.42477 .58614 L
s
.77451 .92818 m
.77348 .94625 L
s
.53995 .68795 m
.54194 .68495 L
s
.42891 .57728 m
.424 .57175 L
s
.43338 .58286 m
.42891 .57728 L
s
.53553 .68407 m
.53737 .68085 L
s
.39206 .52597 m
.38299 .52137 L
s
.47373 .68976 m
.47372 .68115 L
s
.42676 .58825 m
.4219 .58211 L
s
.76699 .91933 m
.76639 .93642 L
s
.51746 .6682 m
.51859 .66422 L
s
.44654 .62573 m
.44378 .61876 L
s
.48909 .77544 m
.49209 .76329 L
s
.44767 .62815 m
.44502 .62113 L
s
.43745 .58847 m
.43338 .58286 L
s
.45681 .64805 m
.45509 .64056 L
s
.48717 .74708 m
.48916 .73632 L
s
.48023 .71207 m
.48102 .70272 L
s
.77197 .92527 m
.77105 .94297 L
s
.424 .57175 m
.41862 .56628 L
s
.4521 .60623 m
.4493 .60064 L
s
.4307 .57998 m
.42598 .57443 L
s
.435 .58557 m
.4307 .57998 L
s
.47536 .63014 m
.47425 .62488 L
s
.45748 .64997 m
.45584 .64244 L
s
.73663 .88468 m
.73758 .89804 L
s
.38083 .50983 m
.3703 .50563 L
s
.70199 .84613 m
.70431 .85569 L
s
.4852 .73579 m
.48679 .72551 L
s
.40822 .55085 m
.40114 .54571 L
s
.48741 .75297 m
.48959 .74193 L
s
.42598 .57443 m
.4208 .56893 L
s
.39549 .53208 m
.38687 .52735 L
s
.48825 .79155 m
.49187 .77853 L
s
.782 .93731 m
.78044 .95629 L
s
.7117 .8599 m
.71364 .87026 L
s
.41223 .56405 m
.40575 .55848 L
s
.48406 .73054 m
.48547 .72047 L
s
.48166 .8534 m
.48825 .83683 L
s
.41556 .56116 m
.4093 .55584 L
s
.45105 .60538 m
.44818 .59979 L
s
.45814 .98024 m
.47431 .95631 L
s
.48835 .78122 m
.49156 .76876 L
s
.47062 .68336 m
.47034 .67493 L
s
.45875 .65377 m
.45726 .64614 L
s
.48366 .72967 m
.48503 .71963 L
s
.48516 .82676 m
.49035 .81175 L
s
.48336 .72822 m
.48468 .71824 L
s
.70081 .84502 m
.70316 .85444 L
s
.48689 .64126 m
.48647 .63627 L
s
.41037 .56115 m
.40367 .55566 L
s
.42477 .58614 m
.41973 .58006 L
s
.44629 .60008 m
.44301 .59447 L
s
.43893 .59118 m
.435 .58557 L
s
.47123 .68556 m
.47102 .67706 L
s
.79375 .95134 m
.79138 .97187 L
s
.4782 .87306 m
.48597 .85534 L
s
.48764 .79416 m
.49136 .781 L
s
.44117 .59408 m
.43745 .58847 L
s
.44901 .63286 m
.44654 .62573 L
s
.57852 .7235 m
.58148 .72256 L
s
.38743 .52212 m
.37784 .51762 L
s
.48638 .81183 m
.49085 .79768 L
s
.46169 .66144 m
.4605 .65361 L
s
.48255 .8442 m
.48863 .82818 L
s
.45003 .63534 m
.44767 .62815 L
s
.70794 .85303 m
.71 .86315 L
s
.48711 .80001 m
.49106 .78653 L
s
.48766 .78398 m
.49096 .77136 L
s
.4565 .61186 m
.45406 .60631 L
s
.46194 .66274 m
.4608 .65487 L
s
.4208 .56893 m
.41511 .56351 L
s
.4219 .58211 m
.41656 .57614 L
s
.47388 .89511 m
.48309 .87612 L
s
.83844 1.00633 m
.83266 1.03333 L
s
.48692 .76291 m
.48942 .75136 L
s
.48649 .80437 m
.49063 .79064 L
s
.41862 .56628 m
.41271 .5609 L
s
.56175 .70837 m
.56432 .70644 L
s
.48088 .85166 m
.48737 .83521 L
s
.34375 .44604 m
.32759 .44376 L
s
.47346 .89538 m
.4827 .87639 L
s
.46174 .61787 m
.4597 .61239 L
s
.48662 .79427 m
.49032 .7811 L
s
.48288 .83563 m
.4885 .82012 L
s
.76039 .91298 m
.75997 .92902 L
s
.73608 .88591 m
.7369 .899 L
s
.45829 .65574 m
.45681 .64805 L
s
.47136 .68945 m
.47124 .68081 L
s
.44251 .59679 m
.43893 .59118 L
s
.48659 .78889 m
.49007 .77601 L
s
.47336 .69574 m
.47347 .6869 L
s
.79022 .94772 m
.78797 .96764 L
s
.40999 .56264 m
.4033 .55714 L
s
.72629 .87391 m
.72755 .88594 L
s
.45121 .64017 m
.44901 .63286 L
s
.48648 .78384 m
.48975 .77122 L
s
.45889 .65772 m
.45748 .64997 L
s
.33818 .43675 m
.32111 .43479 L
s
.56606 .71284 m
.56871 .71112 L
s
.45212 .64271 m
.45003 .63534 L
s
.46306 .61968 m
.46111 .61421 L
s
.41973 .58006 m
.41419 .57415 L
s
.44457 .59969 m
.44117 .59408 L
s
.4852 .75569 m
.48741 .74448 L
s
.54106 .69038 m
.54301 .68738 L
s
.40591 .55013 m
.39863 .54507 L
s
.47898 .71776 m
.47986 .70814 L
s
.37259 .49785 m
.36098 .4941 L
s
.4027 .55078 m
.39515 .54559 L
s
.37273 .49827 m
.36114 .49451 L
s
.47354 .69871 m
.47373 .68976 L
s
.78289 .93942 m
.78106 .95829 L
s
.46002 .66162 m
.45875 .65377 L
s
.38383 .51856 m
.37384 .51423 L
s
.48566 .7883 m
.48909 .77544 L
s
.48488 .75843 m
.48717 .74708 L
s
.47782 .86189 m
.4849 .84488 L
s
.41511 .56351 m
.40888 .55821 L
s
.47924 .72186 m
.48023 .71207 L
s
.55457 .70272 m
.5569 .70037 L
s
.44928 .60568 m
.44629 .60008 L
s
.47432 .88282 m
.48271 .86462 L
s
.48491 .76463 m
.48741 .75297 L
s
.50524 .65932 m
.50576 .65487 L
s
.48334 .7466 m
.4852 .73579 L
s
.45244 .99791 m
.4704 .97322 L
s
.46266 .66951 m
.46169 .66144 L
s
.4093 .55584 m
.40243 .55069 L
s
.47071 .69211 m
.47062 .68336 L
s
.45466 .61179 m
.4521 .60623 L
s
.50242 .65691 m
.5028 .65236 L
s
.48241 .74111 m
.48406 .73054 L
s
.48411 .80533 m
.48825 .79155 L
s
.41656 .57614 m
.4107 .57034 L
s
.33139 .42599 m
.31322 .42445 L
s
.46288 .67086 m
.46194 .66274 L
s
.48468 .79441 m
.48835 .78122 L
s
.47125 .69438 m
.47123 .68556 L
s
.48204 .74021 m
.48366 .72967 L
s
.48179 .7387 m
.48336 .72822 L
s
.41271 .5609 m
.40623 .55566 L
s
.45314 .64766 m
.45121 .64017 L
s
.45369 .61095 m
.45105 .60538 L
s
.40125 .54994 m
.39357 .54481 L
s
.4664 .62404 m
.46469 .61862 L
s
.7804 .93702 m
.77862 .95545 L
s
.44578 .6024 m
.44251 .59679 L
s
.77485 .93057 m
.77342 .94827 L
s
.48338 .8081 m
.48764 .79416 L
s
.45395 .65028 m
.45212 .64271 L
s
.45954 .66366 m
.45829 .65574 L
s
.37607 .50685 m
.36505 .5029 L
s
.39799 .54047 m
.38983 .53567 L
s
.48387 .79733 m
.48766 .78398 L
s
.76691 .9215 m
.76593 .93816 L
s
.5303 .68179 m
.53183 .67828 L
s
.40575 .55848 m
.39864 .55315 L
s
.48916 .64559 m
.48884 .64065 L
s
.8116 .97452 m
.80763 .99718 L
s
.48404 .7751 m
.48692 .76291 L
s
.48257 .81429 m
.48711 .80001 L
s
.46008 .66569 m
.45889 .65772 L
s
.48123 .82681 m
.48638 .81183 L
s
.80907 .97154 m
.80527 .99382 L
s
.40114 .54571 m
.39336 .54081 L
s
.47919 .84262 m
.48516 .82676 L
s
.73594 .88702 m
.73655 .89986 L
s
.51811 .67133 m
.51917 .66732 L
s
.34966 .461 m
.33465 .45844 L
s
.48174 .8189 m
.48649 .80437 L
s
.44768 .60529 m
.44457 .59969 L
s
.7738 .92955 m
.77235 .94705 L
s
.40367 .55566 m
.39633 .55041 L
s
.47128 .69842 m
.47136 .68945 L
s
.47304 .70494 m
.47336 .69574 L
s
.7611 .91481 m
.7604 .9307 L
s
.41419 .57415 m
.40811 .56844 L
s
.46107 .66972 m
.46002 .66162 L
s
.48237 .80821 m
.48662 .79427 L
s
.71202 .85935 m
.71364 .86961 L
s
.74361 .89559 m
.74381 .90931 L
s
.45875 .61738 m
.4565 .61186 L
s
.4826 .80252 m
.48659 .78889 L
s
.44746 1.0156 m
.46729 .99011 L
s
.45768 .9636 m
.47241 .94096 L
s
.48272 .79719 m
.48648 .78384 L
s
.54498 .69521 m
.54697 .69235 L
s
.39053 .53064 m
.38148 .52612 L
s
.45482 .65537 m
.45314 .64766 L
s
.49927 .65526 m
.49947 .6506 L
s
.55841 .70724 m
.56077 .70504 L
s
.73983 .89067 m
.74021 .90397 L
s
.48265 .76751 m
.4852 .75569 L
s
.47787 .72782 m
.47898 .71776 L
s
.5152 .66923 m
.51613 .66511 L
s
.47314 .70803 m
.47354 .69871 L
s
.47644 .6349 m
.47538 .62966 L
s
.47403 .87083 m
.48166 .8534 L
s
.35204 .46661 m
.33747 .46394 L
s
.47552 .86108 m
.48255 .8442 L
s
.46341 .67784 m
.46266 .66951 L
s
.45553 .65806 m
.45395 .65028 L
s
.57036 .71837 m
.57298 .71681 L
s
.55656 .70577 m
.55886 .70347 L
s
.40888 .55821 m
.40204 .55307 L
s
.7035 .85464 m
.70532 .86366 L
s
.48223 .7704 m
.48488 .75843 L
s
.52132 .67478 m
.52248 .67089 L
s
.48171 .8019 m
.48566 .7883 L
s
.49843 .65481 m
.49858 .65013 L
s
.46359 .67924 m
.46288 .67086 L
s
.478 .7321 m
.47924 .72186 L
s
.47639 .85198 m
.48288 .83563 L
s
.47059 .7012 m
.47071 .69211 L
s
.45203 .61126 m
.44928 .60568 L
s
.4033 .55714 m
.39598 .5519 L
s
.48117 .75797 m
.48334 .7466 L
s
.46057 .67182 m
.45954 .66366 L
s
.48201 .77692 m
.48491 .76463 L
s
.52595 .67912 m
.52728 .67539 L
s
.47105 .70355 m
.47125 .69438 L
s
.47643 .63538 m
.47536 .63014 L
s
.48045 .75222 m
.48241 .74111 L
s
.4107 .57034 m
.40427 .56477 L
s
.44878 .60799 m
.44578 .6024 L
s
.48821 .64607 m
.48783 .6411 L
s
.49179 .64927 m
.49159 .6444 L
s
.46364 .62333 m
.46174 .61787 L
s
.48013 .75129 m
.48204 .74021 L
s
.47994 .7497 m
.48179 .7387 L
s
.46103 .67392 m
.46008 .66569 L
s
.51549 .67013 m
.51641 .666 L
s
.79467 .95514 m
.79169 .9752 L
s
.47337 .86895 m
.48088 .85166 L
s
.4891 .64707 m
.48876 .64212 L
s
.48046 .80834 m
.48468 .79441 L
s
.40623 .55566 m
.39912 .5506 L
s
.50553 .66156 m
.50601 .65709 L
s
.47933 .81989 m
.48411 .80533 L
s
.37905 .51608 m
.36859 .512 L
s
.50727 .6631 m
.50782 .65869 L
s
.72383 .87336 m
.72482 .88474 L
s
.56686 .71559 m
.56936 .71381 L
s
.39863 .54507 m
.39065 .54026 L
s
.57531 .72347 m
.57797 .72216 L
s
.80093 .96285 m
.79746 .98372 L
s
.40243 .55069 m
.3949 .54575 L
s
.69886 .85119 m
.70074 .85958 L
s
.38687 .52735 m
.37743 .52299 L
s
.4692 .89159 m
.4782 .87306 L
s
.45625 .6633 m
.45482 .65537 L
s
.45702 .61732 m
.45466 .61179 L
s
.46189 .67807 m
.46107 .66972 L
s
.46487 .62512 m
.46306 .61968 L
s
.48072 .78796 m
.48404 .7751 L
s
.38299 .52137 m
.37304 .51718 L
s
.52541 .67914 m
.5267 .67538 L
s
.45612 .61649 m
.45369 .61095 L
s
.47951 .81143 m
.48387 .79733 L
s
.47847 .82281 m
.48338 .8081 L
s
.5547 .70507 m
.5569 .70262 L
s
.54766 .69869 m
.54967 .69591 L
s
.71449 .86322 m
.71583 .87356 L
s
.47098 .70775 m
.47128 .69842 L
s
.45053 .61087 m
.44768 .60529 L
s
.4725 .71452 m
.47304 .70494 L
s
.45687 .66606 m
.45553 .65806 L
s
.52498 .67892 m
.52624 .67514 L
s
.55051 .7015 m
.55259 .69884 L
s
.71089 .85936 m
.71235 .8693 L
s
.56798 .71704 m
.57047 .7153 L
s
.39515 .54559 m
.38688 .54072 L
s
.47733 .82934 m
.48257 .81429 L
s
.48733 .64625 m
.48689 .64126 L
s
.54205 .69401 m
.54388 .69095 L
s
.46394 .68646 m
.46341 .67784 L
s
.40811 .56844 m
.40145 .56296 L
s
.74432 .8971 m
.74424 .91068 L
s
.47649 .73835 m
.47787 .72782 L
s
.47251 .71773 m
.47314 .70803 L
s
.47969 .77996 m
.48265 .76751 L
s
.46408 .68791 m
.46359 .67924 L
s
.46136 .68026 m
.46057 .67182 L
s
.47839 .81126 m
.48272 .79719 L
s
.47747 .82291 m
.48237 .80821 L
s
.74962 .90325 m
.74924 .91742 L
s
.478 .8169 m
.4826 .80252 L
s
.47528 .84258 m
.48123 .82681 L
s
.47625 .83421 m
.48174 .8189 L
s
.43221 .61273 m
.42827 .60612 L
s
.43576 .61951 m
.43221 .61273 L
s
.43897 .62645 m
.43576 .61951 L
s
.57591 .72483 m
.57852 .7235 L
s
.47916 .783 m
.48223 .7704 L
s
.46962 .87968 m
.47782 .86189 L
s
.47024 .71065 m
.47059 .7012 L
s
.46176 .68241 m
.46103 .67392 L
s
.47647 .74282 m
.478 .7321 L
s
.39864 .55315 m
.39086 .54811 L
s
.51655 .67231 m
.51746 .6682 L
s
.42827 .60612 m
.42393 .59969 L
s
.44185 .63358 m
.43897 .62645 L
s
.47062 .71309 m
.47105 .70355 L
s
.53827 .69119 m
.53995 .68795 L
s
.468 .62943 m
.4664 .62404 L
s
.47863 .76993 m
.48117 .75797 L
s
.43512 .61916 m
.43152 .6124 L
s
.43837 .6261 m
.43512 .61916 L
s
.43152 .6124 m
.42753 .60581 L
s
.53399 .68749 m
.53553 .68407 L
s
.45744 .67147 m
.45625 .6633 L
s
.47865 .78987 m
.48201 .77692 L
s
.47815 .7639 m
.48045 .75222 L
s
.47714 .81623 m
.48171 .8019 L
s
.39357 .54481 m
.38516 .54001 L
s
.47228 .85928 m
.47919 .84262 L
s
.47786 .76292 m
.48013 .75129 L
s
.47774 .76126 m
.47994 .7497 L
s
.44129 .63322 m
.43837 .6261 L
s
.37784 .51762 m
.36733 .51361 L
s
.46315 .91479 m
.47388 .89511 L
s
.40204 .55307 m
.39456 .54815 L
s
.46083 .62286 m
.45875 .61738 L
s
.45154 .61356 m
.44878 .60799 L
s
.46248 .68671 m
.46189 .67807 L
s
.42753 .60581 m
.42314 .59939 L
s
.45797 .67432 m
.45687 .66606 L
s
.45456 .6168 m
.45203 .61126 L
s
.44442 .6409 m
.44185 .63358 L
s
.74242 .89564 m
.7423 .90886 L
s
.39633 .55041 m
.3883 .54548 L
s
.39336 .54081 m
.38486 .5362 L
s
.46271 .91504 m
.47346 .89538 L
s
.42393 .59969 m
.41916 .59344 L
s
.38983 .53567 m
.38088 .5312 L
s
.40427 .56477 m
.39724 .55945 L
s
.4439 .64052 m
.44129 .63322 L
s
.47043 .71746 m
.47098 .70775 L
s
.47556 .82301 m
.48046 .80834 L
s
.3703 .50563 m
.35877 .50203 L
s
.55954 .71062 m
.56175 .70837 L
s
.4717 .7245 m
.4725 .71452 L
s
.46456 .90174 m
.47432 .88282 L
s
.47687 .8015 m
.48072 .78796 L
s
.73366 .88604 m
.73392 .89821 L
s
.46424 .69539 m
.46394 .68646 L
s
.42314 .59939 m
.4183 .59316 L
s
.46192 .68898 m
.46136 .68026 L
s
.47381 .83521 m
.47933 .81989 L
s
.44669 .64841 m
.44442 .6409 L
s
.46433 .69689 m
.46408 .68791 L
s
.39912 .5506 m
.39135 .54578 L
s
.75059 .90604 m
.74995 .92008 L
s
.56377 .7149 m
.56606 .71284 L
s
.45315 .61642 m
.45053 .61087 L
s
.47446 .82626 m
.47951 .81143 L
s
.47161 .72786 m
.47251 .71773 L
s
.44621 .64803 m
.4439 .64052 L
s
.47479 .74937 m
.47649 .73835 L
s
.42701 .58672 m
.42217 .58123 L
s
.43143 .59226 m
.42701 .58672 L
s
.46225 .6912 m
.46176 .68241 L
s
.39598 .5519 m
.38797 .54698 L
s
.45838 .6799 m
.45744 .67147 L
s
.42217 .58123 m
.41688 .57581 L
s
.77232 .93105 m
.77037 .9477 L
s
.47623 .79306 m
.47969 .77996 L
s
.46886 .86909 m
.47639 .85198 L
s
.41916 .59344 m
.41391 .58738 L
s
.46737 .87871 m
.47552 .86108 L
s
.69345 .84903 m
.69518 .85646 L
s
.47278 .83827 m
.47847 .82281 L
s
.46964 .72048 m
.47024 .71065 L
s
.45837 .622 m
.45612 .61649 L
s
.45921 .62282 m
.45702 .61732 L
s
.32366 .42276 m
.30462 .4219 L
s
.46541 .62875 m
.46364 .62333 L
s
.47462 .75406 m
.47647 .74282 L
s
.46992 .72303 m
.47062 .71309 L
s
.45882 .68285 m
.45797 .67432 L
s
.43548 .59783 m
.43143 .59226 L
s
.48953 .65053 m
.48916 .64559 L
s
.47557 .79626 m
.47916 .783 L
s
.3949 .54575 m
.38666 .54109 L
s
.46283 .69565 m
.46248 .68671 L
s
.53943 .69363 m
.54106 .69038 L
s
.50218 .66151 m
.50242 .65691 L
s
.50488 .66384 m
.50524 .65932 L
s
.37384 .51423 m
.3629 .51045 L
s
.44868 .65613 m
.44669 .64841 L
s
.47564 .7825 m
.47863 .76993 L
s
.46517 .88898 m
.47403 .87083 L
s
.47336 .82606 m
.47839 .81126 L
s
.47747 .64012 m
.47644 .6349 L
s
.40145 .56296 m
.39416 .55776 L
s
.47543 .77616 m
.47815 .7639 L
s
.4183 .59316 m
.413 .58713 L
s
.41688 .57581 m
.41108 .57049 L
s
.47125 .84515 m
.47733 .82934 L
s
.44823 .65574 m
.44621 .64803 L
s
.47519 .77514 m
.47786 .76292 L
s
.47514 .77339 m
.47774 .76126 L
s
.47265 .832 m
.478 .8169 L
s
.55259 .70537 m
.55457 .70272 L
s
.71982 .87136 m
.72056 .88187 L
s
.47474 .80348 m
.47865 .78987 L
s
.47178 .83834 m
.47747 .82291 L
s
.46656 .63052 m
.46487 .62512 L
s
.39065 .54026 m
.38192 .53577 L
s
.45101 .96643 m
.46617 .94424 L
s
.38148 .52612 m
.37158 .52203 L
s
.69474 .85052 m
.69635 .85803 L
s
.76064 .91793 m
.75927 .93302 L
s
.46962 .72757 m
.47043 .71746 L
s
.47746 .64059 m
.47643 .63538 L
s
.84476 1.01968 m
.83721 1.04626 L
s
.46428 .70464 m
.46424 .69539 L
s
.46465 .88695 m
.47337 .86895 L
s
.46988 .85026 m
.47625 .83421 L
s
.42414 .58537 m
.41907 .57992 L
s
.42877 .59087 m
.42414 .58537 L
s
.47061 .73492 m
.4717 .7245 L
s
.46223 .698 m
.46192 .68898 L
s
.47184 .83127 m
.47714 .81623 L
s
.43918 .60341 m
.43548 .59783 L
s
.45408 .6191 m
.45154 .61356 L
s
.46433 .70621 m
.46433 .69689 L
s
.45907 .68861 m
.45838 .6799 L
s
.46839 .85907 m
.47528 .84258 L
s
.433 .59642 m
.42877 .59087 L
s
.42291 .58435 m
.41773 .57892 L
s
.42764 .58984 m
.42291 .58435 L
s
.45039 .66407 m
.44868 .65613 L
s
.41391 .58738 m
.40816 .58155 L
s
.41907 .57992 m
.41353 .57456 L
s
.46249 .70031 m
.46225 .6912 L
s
.43196 .59538 m
.42764 .58984 L
s
.44997 .66367 m
.44823 .65574 L
s
.47042 .73842 m
.47161 .72786 L
s
.52904 .68549 m
.5303 .68179 L
s
.4992 .65996 m
.49927 .65526 L
s
.4569 .62232 m
.45456 .6168 L
s
.47239 .81572 m
.47687 .8015 L
s
.47273 .76092 m
.47479 .74937 L
s
.43132 .62074 m
.42752 .614 L
s
.43475 .62766 m
.43132 .62074 L
s
.41108 .57049 m
.40474 .56532 L
s
.51727 .67546 m
.51811 .67133 L
s
.45942 .69166 m
.45882 .68285 L
s
.43783 .63478 m
.43475 .62766 L
s
.48865 .65104 m
.48821 .64607 L
s
.41773 .57892 m
.41207 .57359 L
s
.46875 .73074 m
.46964 .72048 L
s
.56811 .72029 m
.57036 .71837 L
s
.39456 .54815 m
.38637 .54352 L
s
.42752 .614 m
.42332 .60745 L
s
.36098 .4941 m
.34827 .49108 L
s
.4984 .65953 m
.49843 .65481 L
s
.46292 .70492 m
.46283 .69565 L
s
.49206 .65416 m
.49179 .64927 L
s
.413 .58713 m
.40718 .58132 L
s
.36114 .49451 m
.34846 .49148 L
s
.46894 .73339 m
.46992 .72303 L
s
.44058 .64209 m
.43783 .63478 L
s
.38688 .54072 m
.37785 .53626 L
s
.46989 .83839 m
.47556 .82301 L
s
.46277 .62831 m
.46083 .62286 L
s
.55641 .70975 m
.55841 .70724 L
s
.4895 .65202 m
.4891 .64707 L
s
.43688 .60198 m
.433 .59642 L
s
.47238 .76582 m
.47462 .75406 L
s
.43314 .62561 m
.42957 .61875 L
s
.43636 .63266 m
.43314 .62561 L
s
.43592 .60094 m
.43196 .59538 L
s
.42957 .61875 m
.42562 .61208 L
s
.71679 .87141 m
.71746 .88127 L
s
.39086 .54811 m
.38235 .54343 L
s
.4722 .80681 m
.47623 .79306 L
s
.54331 .69834 m
.54498 .69521 L
s
.39724 .55945 m
.38955 .55444 L
s
.5145 .67347 m
.5152 .66923 L
s
.43924 .63991 m
.43636 .63266 L
s
.41353 .57456 m
.40747 .56933 L
s
.46952 .63479 m
.468 .62943 L
s
.36505 .5029 m
.353 .49963 L
s
.55462 .70838 m
.55656 .70577 L
s
.45558 .62195 m
.45315 .61642 L
s
.42332 .60745 m
.41871 .6011 L
s
.45183 .67226 m
.45039 .66407 L
s
.57299 .72515 m
.57531 .72347 L
s
.7225 .87561 m
.72291 .88619 L
s
.44303 .6496 m
.44058 .64209 L
s
.46425 .87663 m
.47228 .85928 L
s
.42562 .61208 m
.42126 .6056 L
s
.47214 .79569 m
.47564 .7825 L
s
.47223 .78902 m
.47543 .77616 L
s
.37743 .52299 m
.3671 .51912 L
s
.45144 .67185 m
.44997 .66367 L
s
.44258 .60898 m
.43918 .60341 L
s
.47206 .78611 m
.47514 .77339 L
s
.46859 .84179 m
.47446 .82626 L
s
.47138 .81016 m
.47557 .79626 L
s
.47203 .78795 m
.47519 .77514 L
s
.5204 .67882 m
.52132 .67478 L
s
.45872 .9107 m
.4692 .89159 L
s
.46739 .85122 m
.47381 .83521 L
s
.4418 .64736 m
.43924 .63991 L
s
.46407 .71425 m
.46428 .70464 L
s
.46228 .70737 m
.46223 .698 L
s
.77645 .93776 m
.77385 .95453 L
s
.77096 .9314 m
.76871 .94748 L
s
.46849 .73812 m
.46962 .72757 L
s
.45951 .69763 m
.45907 .68861 L
s
.70431 .85569 m
.70544 .86437 L
s
.41207 .57359 m
.40589 .5684 L
s
.70316 .85444 m
.70433 .863 L
s
.50522 .66609 m
.50553 .66156 L
s
.48783 .65125 m
.48733 .64625 L
s
.56473 .71771 m
.56686 .71559 L
s
.46406 .71588 m
.46433 .70621 L
s
.43641 1.03045 m
.45821 1.00525 L
s
.46921 .7458 m
.47061 .73492 L
s
.52488 .68301 m
.52595 .67912 L
s
.5148 .67437 m
.51549 .67013 L
s
.50689 .66758 m
.50727 .6631 L
s
.3883 .54548 m
.37952 .54093 L
s
.46246 .70975 m
.46249 .70031 L
s
.38516 .54001 m
.37598 .53563 L
s
.47018 .81776 m
.47474 .80348 L
s
.46008 .89809 m
.46962 .87968 L
s
.39135 .54578 m
.38285 .54129 L
s
.44517 .65733 m
.44303 .6496 L
s
.43955 .6065 m
.43592 .60094 L
s
.42126 .6056 m
.41646 .59932 L
s
.45975 .70079 m
.45942 .69166 L
s
.37304 .51718 m
.36216 .51353 L
s
.46046 .62747 m
.45837 .622 L
s
.46617 .85441 m
.47278 .83827 L
s
.44044 .60755 m
.43688 .60198 L
s
.44405 .65503 m
.4418 .64736 L
s
.40816 .58155 m
.40187 .57596 L
s
.38486 .5362 m
.37556 .53198 L
s
.46125 .62829 m
.45921 .62282 L
s
.41871 .6011 m
.41363 .59495 L
s
.46751 .84154 m
.47336 .82606 L
s
.46889 .74945 m
.47042 .73842 L
s
.56586 .71913 m
.56798 .71704 L
s
.40474 .56532 m
.3978 .56034 L
s
.55285 .70781 m
.5547 .70507 L
s
.46275 .71454 m
.46292 .70492 L
s
.47025 .773 m
.47273 .76092 L
s
.46754 .74142 m
.46875 .73074 L
s
.57365 .72653 m
.57591 .72483 L
s
.52438 .68306 m
.52541 .67914 L
s
.36859 .512 m
.35716 .50855 L
s
.453 .68071 m
.45183 .67226 L
s
.46644 .84777 m
.47265 .832 L
s
.54599 .70174 m
.54766 .69869 L
s
.45263 .68028 m
.45144 .67185 L
s
.40747 .56933 m
.40084 .56427 L
s
.46763 .74419 m
.46894 .73339 L
s
.39416 .55776 m
.3862 .5529 L
s
.54878 .70444 m
.55051 .7015 L
s
.46708 .63414 m
.46541 .62875 L
s
.38088 .5312 m
.37111 .52718 L
s
.40718 .58132 m
.40082 .57577 L
s
.52398 .68285 m
.52498 .67892 L
s
.38797 .54698 m
.37922 .54245 L
s
.46517 .85444 m
.47178 .83834 L
s
.44701 .66529 m
.44517 .65733 L
s
.4697 .77814 m
.47238 .76582 L
s
.4642 .86161 m
.47125 .84515 L
s
.44601 .66291 m
.44405 .65503 L
s
.45644 .62461 m
.45408 .6191 L
s
.54055 .6973 m
.54205 .69401 L
s
.46568 .84698 m
.47184 .83127 L
s
.41646 .59932 m
.4112 .59327 L
s
.45967 .70697 m
.45951 .69763 L
s
.46205 .71708 m
.46228 .70737 L
s
.46716 .83059 m
.47239 .81572 L
s
.46356 .72424 m
.46407 .71425 L
s
.38666 .54109 m
.37766 .53681 L
s
.40589 .5684 m
.39912 .56339 L
s
.46012 .88681 m
.46886 .86909 L
s
.4457 .61454 m
.44258 .60898 L
s
.4635 .72594 m
.46406 .71588 L
s
.46703 .74912 m
.46849 .73812 L
s
.71 .86315 m
.71071 .8722 L
s
.41363 .59495 m
.40807 .58904 L
s
.46215 .71955 m
.46246 .70975 L
s
.51587 .67654 m
.51655 .67231 L
s
.46817 .63589 m
.46656 .63052 L
s
.46748 .82119 m
.4722 .80681 L
s
.45981 .71025 m
.45975 .70079 L
s
.46845 .80247 m
.47223 .78902 L
s
.46742 .75715 m
.46921 .7458 L
s
.46844 .79942 m
.47206 .78611 L
s
.44289 .61206 m
.43955 .6065 L
s
.46248 .86694 m
.46988 .85026 L
s
.45908 .62779 m
.4569 .62232 L
s
.42284 .58934 m
.41777 .58394 L
s
.42747 .59481 m
.42284 .58934 L
s
.46832 .80135 m
.47203 .78795 L
s
.46802 .80949 m
.47214 .79569 L
s
.5369 .69466 m
.53827 .69119 L
s
.4539 .68943 m
.453 .68071 L
s
.44371 .61311 m
.44044 .60755 L
s
.44768 .67104 m
.44601 .66291 L
s
.4579 .89689 m
.46737 .87871 L
s
.44858 .67349 m
.44701 .66529 L
s
.53275 .69113 m
.53399 .68749 L
s
.43912 1.00377 m
.45814 .98024 L
s
.45355 .68899 m
.45263 .68028 L
s
.41777 .58394 m
.41224 .57863 L
s
.72613 .88143 m
.72607 .89208 L
s
.43172 .60032 m
.42747 .59481 L
s
.4785 .64532 m
.47747 .64012 L
s
.46648 .8247 m
.47138 .81016 L
s
.71364 .87026 m
.71409 .87942 L
s
.46227 .72453 m
.46275 .71454 L
s
.46697 .76096 m
.46889 .74945 L
s
.46328 .8544 m
.46989 .83839 L
s
.46037 .87618 m
.46839 .85907 L
s
.46597 .75256 m
.46754 .74142 L
s
.38192 .53577 m
.37239 .53171 L
s
.36733 .51361 m
.35586 .51026 L
s
.55768 .7132 m
.55954 .71062 L
s
.45784 .62743 m
.45558 .62195 L
s
.45321 .92108 m
.46456 .90174 L
s
.46596 .75546 m
.46763 .74419 L
s
.46729 .78563 m
.47025 .773 L
s
.40187 .57596 m
.395 .57066 L
s
.56185 .7173 m
.56377 .7149 L
s
.4646 .63373 m
.46277 .62831 L
s
.48997 .65549 m
.48953 .65053 L
s
.47849 .64579 m
.47746 .64059 L
s
.4112 .59327 m
.40544 .58745 L
s
.45065 .93479 m
.46315 .91479 L
s
.41224 .57863 m
.4062 .57345 L
s
.46485 .83266 m
.47018 .81776 L
s
.45954 .71666 m
.45967 .70697 L
s
.38637 .54352 m
.37743 .53926 L
s
.40084 .56427 m
.3936 .55944 L
s
.46151 .72717 m
.46205 .71708 L
s
.44906 .67942 m
.44768 .67104 L
s
.45487 .90761 m
.46517 .88898 L
s
.43562 .60585 m
.43172 .60032 L
s
.38955 .55444 m
.38115 .54981 L
s
.3978 .56034 m
.39023 .55561 L
s
.44985 .68195 m
.44858 .67349 L
s
.46273 .73462 m
.46356 .72424 L
s
.46177 .85793 m
.46859 .84179 L
s
.45018 .93502 m
.46271 .91504 L
s
.4665 .79101 m
.4697 .77814 L
s
.43087 .63311 m
.42735 .62614 L
s
.43402 .64028 m
.43087 .63311 L
s
.46261 .7364 m
.4635 .72594 L
s
.45451 .69844 m
.4539 .68943 L
s
.45957 .72006 m
.45981 .71025 L
s
.46153 .72974 m
.46215 .71955 L
s
.45419 .698 m
.45355 .68899 L
s
.42735 .62614 m
.42346 .61938 L
s
.50209 .66618 m
.50218 .66151 L
s
.42967 .63111 m
.42603 .6242 L
s
.43294 .63822 m
.42967 .63111 L
s
.43684 .64767 m
.43402 .64028 L
s
.40807 .58904 m
.40199 .58338 L
s
.43586 .64555 m
.43294 .63822 L
s
.40082 .57577 m
.39387 .57052 L
s
.46517 .76059 m
.46703 .74912 L
s
.50469 .66844 m
.50488 .66384 L
s
.45451 .90541 m
.46465 .88695 L
s
.45992 .86782 m
.46739 .85122 L
s
.42603 .6242 m
.42201 .61751 L
s
.47097 .64011 m
.46952 .63479 L
s
.32759 .44376 m
.3099 .44292 L
s
.41982 .58864 m
.41454 .5833 L
s
.42466 .59406 m
.41982 .58864 L
s
.46522 .76899 m
.46742 .75715 L
s
.4404 .986 m
.45768 .9636 L
s
.42346 .61938 m
.41916 .61284 L
s
.43845 .65309 m
.43586 .64555 L
s
.42909 .59953 m
.42466 .59406 L
s
.43933 .65528 m
.43684 .64767 L
s
.44859 .62007 m
.4457 .61454 L
s
.39912 .56339 m
.39174 .55862 L
s
.44596 .6176 m
.44289 .61206 L
s
.38235 .54343 m
.37308 .53921 L
s
.37158 .52203 m
.36078 .51852 L
s
.46243 .6329 m
.46046 .62747 L
s
.4607 .85761 m
.46751 .84154 L
s
.46148 .73491 m
.46227 .72453 L
s
.53811 .6971 m
.53943 .69363 L
s
.55096 .7083 m
.55259 .70537 L
s
.46317 .63371 m
.46125 .62829 L
s
.42201 .61751 m
.41758 .61103 L
s
.41454 .5833 m
.40878 .57808 L
s
.44673 .61864 m
.44371 .61311 L
s
.45015 .68807 m
.44906 .67942 L
s
.35877 .50203 m
.34618 .49921 L
s
.46461 .77297 m
.46697 .76096 L
s
.45084 .69069 m
.44985 .68195 L
s
.44072 .66086 m
.43845 .65309 L
s
.46417 .81331 m
.46844 .79942 L
s
.4062 .57345 m
.3996 .56845 L
s
.37785 .53626 m
.368 .5323 L
s
.48916 .65602 m
.48865 .65104 L
s
.46402 .81651 m
.46845 .80247 L
s
.45848 .87112 m
.46617 .85441 L
s
.46399 .76418 m
.46597 .75256 L
s
.46394 .81533 m
.46832 .80135 L
s
.4415 .66311 m
.43933 .65528 L
s
.33465 .45844 m
.31824 .45716 L
s
.4392 .61138 m
.43562 .60585 L
s
.70532 .86366 m
.70586 .87168 L
s
.45864 .63007 m
.45644 .62461 L
s
.43316 .60503 m
.42909 .59953 L
s
.70074 .85958 m
.70145 .86709 L
s
.45922 .86413 m
.46644 .84777 L
s
.41916 .61284 m
.41443 .60652 L
s
.45909 .72671 m
.45954 .71666 L
s
.33747 .46394 m
.32155 .46248 L
s
.46319 .82387 m
.46802 .80949 L
s
.46386 .7672 m
.46596 .75546 L
s
.45492 .89446 m
.46425 .87663 L
s
.38285 .54129 m
.37358 .53721 L
s
.49926 .6647 m
.4992 .65996 L
s
.46107 .84605 m
.46716 .83059 L
s
.48998 .65699 m
.4895 .65202 L
s
.49243 .65908 m
.49206 .65416 L
s
.46064 .73766 m
.46151 .72717 L
s
.46197 .83616 m
.46748 .82119 L
s
.42844 .6323 m
.42477 .6254 L
s
.43174 .63941 m
.42844 .6323 L
s
.3629 .51045 m
.35097 .50739 L
s
.45483 .70778 m
.45451 .69844 L
s
.43469 .64674 m
.43174 .63941 L
s
.45454 .70732 m
.45419 .698 L
s
.40544 .58745 m
.39914 .58191 L
s
.56621 .72255 m
.56811 .72029 L
s
.46155 .74542 m
.46273 .73462 L
s
.75531 .91642 m
.75335 .92993 L
s
.46375 .79881 m
.46729 .78563 L
s
.44268 .66887 m
.44072 .66086 L
s
.41758 .61103 m
.41271 .60478 L
s
.4985 .6643 m
.4984 .65953 L
s
.42477 .6254 m
.42071 .61872 L
s
.45901 .73024 m
.45957 .72006 L
s
.43731 .65429 m
.43469 .64674 L
s
.43075 .63818 m
.42736 .63111 L
s
.43378 .64547 m
.43075 .63818 L
s
.42736 .63111 m
.4236 .62426 L
s
.46137 .74727 m
.46261 .7364 L
s
.3862 .5529 m
.37752 .54846 L
s
.45851 .86325 m
.46568 .84698 L
s
.37952 .54093 m
.36996 .53689 L
s
.46056 .74032 m
.46153 .72974 L
s
.44336 .67119 m
.4415 .66311 L
s
.45748 .87108 m
.46517 .85444 L
s
.46868 .63949 m
.46708 .63414 L
s
.32111 .43479 m
.30242 .43444 L
s
.40878 .57808 m
.40249 .57301 L
s
.43647 .65297 m
.43378 .64547 L
s
.57104 .72719 m
.57299 .72515 L
s
.51668 .67972 m
.51727 .67546 L
s
.52807 .68936 m
.52904 .68549 L
s
.46076 .83981 m
.46648 .8247 L
s
.71364 .86961 m
.71378 .8786 L
s
.45095 .69701 m
.45015 .68807 L
s
.4236 .62426 m
.41944 .61763 L
s
.4884 .65625 m
.48783 .65125 L
s
.55476 .71256 m
.55641 .70975 L
s
.4396 .66206 m
.43731 .65429 L
s
.46113 .63323 m
.45908 .62779 L
s
.46286 .77254 m
.46517 .76059 L
s
.73078 .88885 m
.73009 .89957 L
s
.45599 .87859 m
.4642 .86161 L
s
.42071 .61872 m
.41623 .61226 L
s
.45153 .69971 m
.45084 .69069 L
s
.37598 .53563 m
.36597 .5318 L
s
.4627 .80442 m
.4665 .79101 L
s
.43884 .66071 m
.43647 .65297 L
s
.41443 .60652 m
.40924 .60044 L
s
.4369 .61054 m
.43316 .60503 L
s
.46032 .7457 m
.46148 .73491 L
s
.37556 .53198 m
.36542 .52829 L
s
.44433 .67712 m
.44268 .66887 L
s
.51401 .67782 m
.5145 .67347 L
s
.46253 .78133 m
.46522 .76899 L
s
.40199 .58338 m
.39535 .57802 L
s
.55303 .71128 m
.55462 .70838 L
s
.395 .57066 m
.3875 .5657 L
s
.7546 .91667 m
.75255 .92994 L
s
.3936 .55944 m
.38571 .5549 L
s
.54198 .70171 m
.54331 .69834 L
s
.44492 .67952 m
.44336 .67119 L
s
.4313 1.02171 m
.45244 .99791 L
s
.37922 .54245 m
.36968 .53842 L
s
.56295 .72016 m
.56473 .71771 L
s
.75095 .91265 m
.7491 .92548 L
s
.41944 .61763 m
.41486 .61123 L
s
.44158 .67008 m
.4396 .66206 L
s
.46972 .64122 m
.46817 .63589 L
s
.45996 .63287 m
.45784 .62743 L
s
.45831 .73715 m
.45909 .72671 L
s
.3671 .51912 m
.35585 .51589 L
s
.44089 .66868 m
.43884 .66071 L
s
.50508 .6707 m
.50522 .66609 L
s
.45484 .71744 m
.45483 .70778 L
s
.41271 .60478 m
.40737 .59878 L
s
.45457 .71697 m
.45454 .70732 L
s
.4425 .6169 m
.4392 .61138 L
s
.45864 .84811 m
.46485 .83266 L
s
.51974 .683 m
.5204 .67882 L
s
.46155 .77627 m
.46399 .76418 L
s
.46175 .78548 m
.46461 .77297 L
s
.57175 .72858 m
.57365 .72653 L
s
.5067 .67215 m
.50689 .66758 L
s
.3996 .56845 m
.3924 .56369 L
s
.44881 .62311 m
.44596 .6176 L
s
.41623 .61226 m
.41132 .60604 L
s
.39023 .55561 m
.38198 .55122 L
s
.45939 .74856 m
.46064 .73766 L
s
.37766 .53681 m
.36786 .53301 L
s
.45388 .8841 m
.46248 .86694 L
s
.44898 .91681 m
.46008 .89809 L
s
.45559 .87092 m
.46328 .8544 L
s
.46128 .77943 m
.46386 .7672 L
s
.56409 .72155 m
.56586 .71913 L
s
.51433 .67872 m
.5148 .67437 L
s
.45127 .62557 m
.44859 .62007 L
s
.72755 .88594 m
.7269 .89619 L
s
.69518 .85646 m
.69587 .86313 L
s
.45809 .74082 m
.45901 .73024 L
s
.45144 .70626 m
.45095 .69701 L
s
.39387 .57052 m
.38629 .56562 L
s
.45998 .75664 m
.46155 .74542 L
s
.44568 .68565 m
.44433 .67712 L
s
.52409 .68706 m
.52488 .68301 L
s
.44952 .62414 m
.44673 .61864 L
s
.44652 .93002 m
.45872 .9107 L
s
.45922 .75132 m
.46056 .74032 L
s
.44325 .67835 m
.44158 .67008 L
s
.45972 .75858 m
.46137 .74727 L
s
.45192 .70905 m
.45153 .69971 L
s
.40249 .57301 m
.39562 .56815 L
s
.37111 .52718 m
.36047 .52374 L
s
.39174 .55862 m
.38369 .55417 L
s
.44262 .6769 m
.44089 .66868 L
s
.46634 .63909 m
.4646 .63373 L
s
.44618 .68811 m
.44492 .67952 L
s
.41486 .61123 m
.40983 .60506 L
s
.71235 .8693 m
.71234 .87796 L
s
.40924 .60044 m
.40357 .59462 L
s
.55136 .71084 m
.55285 .70781 L
s
.45915 .82774 m
.46417 .81331 L
s
.74313 .9047 m
.74157 .91649 L
s
.45881 .83109 m
.46402 .81651 L
s
.44996 .90489 m
.46012 .88681 L
s
.4588 .82985 m
.46394 .81533 L
s
.44034 .61605 m
.4369 .61054 L
s
.39914 .58191 m
.39227 .57669 L
s
.31322 .42445 m
.29331 .42474 L
s
.47953 .6505 m
.4785 .64532 L
s
.52363 .68714 m
.52438 .68306 L
s
.54467 .70505 m
.54599 .70174 L
s
.45957 .81251 m
.46375 .79881 L
s
.45876 .75691 m
.46032 .7457 L
s
.36216 .51353 m
.35032 .51061 L
s
.45382 .87455 m
.46177 .85793 L
s
.5474 .70765 m
.54878 .70444 L
s
.46005 .78498 m
.46286 .77254 L
s
.45105 .89368 m
.46037 .87618 L
s
.71583 .87356 m
.71561 .88249 L
s
.45452 .72745 m
.45484 .71744 L
s
.45754 .83878 m
.46319 .82387 L
s
.41132 .60604 m
.40593 .60008 L
s
.45427 .72697 m
.45457 .71697 L
s
.38115 .54981 m
.37201 .54567 L
s
.69635 .85803 m
.69688 .86471 L
s
.44672 .69445 m
.44568 .68565 L
s
.52326 .68695 m
.52398 .68285 L
s
.4446 .68689 m
.44325 .67835 L
s
.44405 .68539 m
.44262 .6769 L
s
.73758 .89804 m
.73626 .9092 L
s
.40737 .59878 m
.40153 .59306 L
s
.45714 .74798 m
.45831 .73715 L
s
.37743 .53926 m
.36769 .5355 L
s
.46429 .63829 m
.46243 .6329 L
s
.47953 .65097 m
.47849 .64579 L
s
.53938 .70083 m
.54055 .6973 L
s
.45929 .79416 m
.46253 .78133 L
s
.45161 .71583 m
.45144 .70626 L
s
.353 .49963 m
.33987 .49726 L
s
.44713 .69699 m
.44618 .68811 L
s
.37239 .53171 m
.36201 .52822 L
s
.465 .63909 m
.46317 .63371 L
s
.75264 .91597 m
.75042 .9287 L
s
.45821 .81835 m
.4627 .80442 L
s
.46072 .63549 m
.45864 .63007 L
s
.45774 .75988 m
.45939 .74856 L
s
.45198 .71872 m
.45192 .70905 L
s
.45553 .85164 m
.46197 .83616 L
s
.34827 .49108 m
.33442 .48904 L
s
.47239 .6454 m
.47097 .64011 L
s
.45277 .87413 m
.4607 .85761 L
s
.34846 .49148 m
.33464 .48943 L
s
.45679 .75179 m
.45809 .74082 L
s
.40983 .60506 m
.40433 .59917 L
s
.51542 .68089 m
.51587 .67654 L
s
.44688 .91533 m
.4579 .89689 L
s
.45124 .88484 m
.45992 .86782 L
s
.45857 .78885 m
.46155 .77627 L
s
.45396 .86199 m
.46107 .84605 L
s
.45796 .76831 m
.45998 .75664 L
s
.44555 .6224 m
.4425 .6169 L
s
.4583 .79848 m
.46175 .78548 L
s
.49051 .66046 m
.48997 .65549 L
s
.39535 .57802 m
.38811 .57301 L
s
.45745 .76274 m
.45922 .75132 L
s
.35716 .50855 m
.34471 .50592 L
s
.42687 .64151 m
.42337 .63447 L
s
.43001 .64878 m
.42687 .64151 L
s
.44516 .69415 m
.44405 .68539 L
s
.45815 .79213 m
.46128 .77943 L
s
.45761 .77033 m
.45972 .75858 L
s
.43279 .65629 m
.43001 .64878 L
s
.44565 .6957 m
.4446 .68689 L
s
.53586 .69835 m
.5369 .69466 L
s
.44745 .70354 m
.44672 .69445 L
s
.53182 .69496 m
.53275 .69113 L
s
.55619 .71607 m
.55768 .7132 L
s
.42337 .63447 m
.41949 .62767 L
s
.7369 .899 m
.73546 .90987 L
s
.43523 .66403 m
.43279 .65629 L
s
.45408 .8554 m
.46076 .83981 L
s
.40357 .59462 m
.39737 .58909 L
s
.56029 .72001 m
.56185 .7173 L
s
.44776 .70617 m
.44713 .69699 L
s
.45081 .88089 m
.45922 .86413 L
s
.3924 .56369 m
.38457 .55924 L
s
.45383 .73783 m
.45452 .72745 L
s
.45361 .73733 m
.45427 .72697 L
s
.39562 .56815 m
.38815 .56357 L
s
.45675 .76856 m
.45876 .75691 L
s
.45146 .62858 m
.44881 .62311 L
s
.44954 .88821 m
.45848 .87112 L
s
.40593 .60008 m
.40004 .5944 L
s
.45144 .72573 m
.45161 .71583 L
s
.41949 .62767 m
.4152 .6211 L
s
.43735 .67202 m
.43523 .66403 L
s
.42408 1.03966 m
.44746 1.0156 L
s
.46307 .63862 m
.46113 .63323 L
s
.72482 .88474 m
.72396 .89436 L
s
.44353 .62154 m
.44034 .61605 L
s
.37308 .53921 m
.36299 .53558 L
s
.38571 .5549 m
.37711 .55074 L
s
.3875 .5657 m
.37934 .56117 L
s
.43328 .98808 m
.45101 .96643 L
s
.45556 .75923 m
.45714 .74798 L
s
.4517 .72872 m
.45198 .71872 L
s
.47022 .6448 m
.46868 .63949 L
s
.45016 .87992 m
.45851 .86325 L
s
.50217 .6709 m
.50209 .66618 L
s
.45377 .63103 m
.45127 .62557 L
s
.45213 .62961 m
.44952 .62414 L
s
.44595 .70321 m
.44516 .69415 L
s
.45666 .79789 m
.46005 .78498 L
s
.44637 .7048 m
.44565 .6957 L
s
.37358 .53721 m
.36349 .53368 L
s
.42643 .64456 m
.423 .63748 L
s
.4295 .65189 m
.42643 .64456 L
s
.40153 .59306 m
.39515 .58764 L
s
.50468 .6731 m
.50469 .66844 L
s
.43222 .65945 m
.4295 .65189 L
s
.37752 .54846 m
.36808 .54454 L
s
.43913 .68026 m
.43735 .67202 L
s
.44784 .71294 m
.44745 .70354 L
s
.46197 .63827 m
.45996 .63287 L
s
.45561 .77163 m
.45774 .75988 L
s
.423 .63748 m
.41918 .63063 L
s
.48976 .66102 m
.48916 .65602 L
s
.45505 .76318 m
.45679 .75179 L
s
.44854 .88808 m
.45748 .87108 L
s
.4429 .92636 m
.45487 .90761 L
s
.40433 .59917 m
.39832 .59357 L
s
.4346 .66726 m
.43222 .65945 L
s
.4152 .6211 m
.41048 .61479 L
s
.45139 .86399 m
.45864 .84811 L
s
.45464 .82668 m
.45957 .81251 L
s
.44805 .71566 m
.44776 .70617 L
s
.45541 .80747 m
.45929 .79416 L
s
.45327 .84264 m
.45915 .82774 L
s
.39227 .57669 m
.38479 .57185 L
s
.38629 .56562 m
.37805 .56115 L
s
.35586 .51026 m
.34339 .50774 L
s
.368 .5323 m
.35729 .529 L
s
.38198 .55122 m
.373 .54726 L
s
.49055 .66197 m
.48998 .65699 L
s
.80342 .97699 m
.79738 .99556 L
s
.45543 .78041 m
.45796 .76831 L
s
.4552 .77459 m
.45745 .76274 L
s
.41918 .63063 m
.41496 .62403 L
s
.45279 .84483 m
.4588 .82985 L
s
.44272 .924 m
.45451 .90541 L
s
.45272 .84612 m
.45881 .83109 L
s
.43664 .67532 m
.4346 .66726 L
s
.54968 .71152 m
.55096 .7083 L
s
.4929 .66401 m
.49243 .65908 L
s
.38369 .55417 m
.37493 .55013 L
s
.43999 .9404 m
.45321 .92108 L
s
.45499 .78251 m
.45761 .77033 L
s
.47122 .64651 m
.46972 .64122 L
s
.45499 .80188 m
.45857 .78885 L
s
.44059 .68878 m
.43913 .68026 L
s
.45256 .74807 m
.45361 .73733 L
s
.45276 .74859 m
.45383 .73783 L
s
.53713 .70079 m
.53811 .6971 L
s
.73655 .89986 m
.7349 .91045 L
s
.4509 .73599 m
.45144 .72573 L
s
.49947 .6695 m
.49926 .6647 L
s
.56468 .72514 m
.56621 .72255 L
s
.36996 .53689 m
.35957 .53346 L
s
.44641 .71257 m
.44595 .70321 L
s
.44407 .91248 m
.45492 .89446 L
s
.44646 .89586 m
.45599 .87859 L
s
.70433 .863 m
.70423 .87044 L
s
.36078 .51852 m
.34903 .51575 L
s
.44676 .71422 m
.44637 .7048 L
s
.56946 .72956 m
.57104 .72719 L
s
.4542 .81194 m
.4583 .79848 L
s
.4544 .8053 m
.45815 .79213 L
s
.45104 .73909 m
.4517 .72872 L
s
.70544 .86437 m
.70528 .87189 L
s
.45293 .83274 m
.45821 .81835 L
s
.49876 .66911 m
.4985 .6643 L
s
.48906 .66126 m
.4884 .65625 L
s
.43836 .68363 m
.43664 .67532 L
s
.44839 .62786 m
.44555 .6224 L
s
.44789 .72266 m
.44784 .71294 L
s
.45424 .78063 m
.45675 .76856 L
s
.45094 .85412 m
.45754 .83878 L
s
.41496 .62403 m
.41031 .61768 L
s
.46802 .64442 m
.46634 .63909 L
s
.41048 .61479 m
.4053 .60875 L
s
.42634 .64933 m
.42304 .64216 L
s
.42928 .65675 m
.42634 .64933 L
s
.77902 .94852 m
.77465 .96387 L
s
.45351 .77089 m
.45556 .75923 L
s
.42518 .64704 m
.42176 .63994 L
s
.42824 .65438 m
.42518 .64704 L
s
.39737 .58909 m
.39061 .58391 L
s
.43094 .66197 m
.42824 .65438 L
s
.43187 .66442 m
.42928 .65675 L
s
.42304 .64216 m
.41936 .63522 L
s
.40004 .5944 m
.39362 .58904 L
s
.44665 .88775 m
.45559 .87092 L
s
.44172 .69757 m
.44059 .68878 L
s
.448 .72547 m
.44805 .71566 L
s
.42176 .63994 m
.41795 .63309 L
s
.4333 .6698 m
.43094 .66197 L
s
.43411 .67233 m
.43187 .66442 L
s
.36968 .53842 m
.35933 .53502 L
s
.36597 .5318 m
.3551 .52864 L
s
.41936 .63522 m
.41529 .62854 L
s
.55348 .71567 m
.55476 .71256 L
s
.36542 .52829 m
.3544 .52526 L
s
.43974 .69222 m
.43836 .68363 L
s
.4361 .95457 m
.45065 .93479 L
s
.45282 .77499 m
.45505 .76318 L
s
.51633 .6841 m
.51668 .67972 L
s
.44649 .62699 m
.44353 .62154 L
s
.38811 .57301 m
.38024 .56842 L
s
.45296 .7838 m
.45561 .77163 L
s
.7587 .92547 m
.75559 .93833 L
s
.43532 .67789 m
.4333 .6698 L
s
.5274 .69342 m
.52807 .68936 L
s
.44652 .72224 m
.44641 .71257 L
s
.57022 .73097 m
.57175 .72858 L
s
.41795 .63309 m
.41374 .62649 L
s
.56155 .72293 m
.56295 .72016 L
s
.74021 .90397 m
.73818 .91482 L
s
.4627 .64087 m
.46072 .63549 L
s
.43602 .6805 m
.43411 .67233 L
s
.46608 .64364 m
.46429 .63829 L
s
.4468 .72395 m
.44676 .71422 L
s
.72056 .88187 m
.71957 .89071 L
s
.45261 .81124 m
.45666 .79789 L
s
.44388 .90147 m
.45388 .8841 L
s
.38815 .56357 m
.38002 .55934 L
s
.36786 .53301 m
.3572 .52984 L
s
.44998 .74661 m
.4509 .73599 L
s
.5518 .71447 m
.55303 .71128 L
s
.4356 .95475 m
.45018 .93502 L
s
.44803 .86748 m
.45553 .85164 L
s
.39832 .59357 m
.39176 .5883 L
s
.51376 .68228 m
.51401 .67782 L
s
.41031 .61768 m
.40522 .61161 L
s
.45107 .75919 m
.45256 .74807 L
s
.45125 .75973 m
.45276 .74859 L
s
.39515 .58764 m
.38822 .58258 L
s
.46675 .64442 m
.465 .63909 L
s
.44252 .70665 m
.44172 .69757 L
s
.45241 .78687 m
.4552 .77459 L
s
.41529 .62854 m
.4108 .62211 L
s
.50514 .67539 m
.50508 .6707 L
s
.44758 .73272 m
.44789 .72266 L
s
.45395 .63401 m
.45146 .62858 L
s
.541 .70532 m
.54198 .70171 L
s
.38457 .55924 m
.37605 .55518 L
s
.45235 .79294 m
.45543 .78041 L
s
.43701 .68625 m
.43532 .67789 L
s
.48059 .65566 m
.47953 .6505 L
s
.44998 .74981 m
.45104 .73909 L
s
.56271 .72429 m
.56409 .72155 L
s
.44459 .89142 m
.45382 .87455 L
s
.44079 .70109 m
.43974 .69222 L
s
.4376 .68894 m
.43602 .6805 L
s
.5067 .67679 m
.5067 .67215 L
s
.4518 .79513 m
.45499 .78251 L
s
.4053 .60875 m
.39964 .603 L
s
.41374 .62649 m
.4091 .62015 L
s
.74381 .90931 m
.74147 .92039 L
s
.44758 .73562 m
.448 .72547 L
s
.37201 .54567 m
.36209 .54213 L
s
.51934 .68732 m
.51974 .683 L
s
.45081 .8212 m
.45541 .80747 L
s
.35097 .50739 m
.33801 .50527 L
s
.44569 .87824 m
.45396 .86199 L
s
.45458 .63503 m
.45213 .62961 L
s
.47379 .65065 m
.47239 .6454 L
s
.5141 .68319 m
.51433 .67872 L
s
.48061 .65612 m
.47953 .65097 L
s
.45613 .63644 m
.45377 .63103 L
s
.45072 .81534 m
.45499 .80188 L
s
.4463 .87132 m
.45408 .8554 L
s
.43835 .69488 m
.43701 .68625 L
s
.45093 .78295 m
.45351 .77089 L
s
.71746 .88127 m
.71645 .88953 L
s
.34618 .49921 m
.33252 .49743 L
s
.44626 .73225 m
.44652 .72224 L
s
.45116 .79312 m
.45424 .78063 L
s
.52359 .69127 m
.52409 .68706 L
s
.44357 .8909 m
.45277 .87413 L
s
.44884 .84126 m
.45464 .82668 L
s
.44647 .73401 m
.4468 .72395 L
s
.4108 .62211 m
.40587 .61596 L
s
.43884 .69765 m
.4376 .68894 L
s
.44297 .71603 m
.44252 .70665 L
s
.36769 .5355 m
.35712 .53236 L
s
.55023 .71415 m
.55136 .71084 L
s
.35585 .51589 m
.34363 .5135 L
s
.36047 .52374 m
.34891 .52105 L
s
.46493 .64397 m
.46307 .63862 L
s
.30462 .4219 m
.28383 .42314 L
s
.44993 .81888 m
.4544 .8053 L
s
.76122 .92918 m
.75771 .9421 L
s
.44149 .71026 m
.44079 .70109 L
s
.37934 .56117 m
.37048 .55714 L
s
.37711 .55074 m
.36778 .54708 L
s
.44933 .82581 m
.4542 .81194 L
s
.44861 .75759 m
.44998 .74661 L
s
.40522 .61161 m
.39965 .60583 L
s
.44023 .91129 m
.45105 .89368 L
s
.45005 .7872 m
.45282 .77499 L
s
.38479 .57185 m
.37667 .56746 L
s
.44687 .74313 m
.44758 .73272 L
s
.4091 .62015 m
.40401 .6141 L
s
.80223 .97804 m
.79573 .99584 L
s
.5437 .70861 m
.54467 .70505 L
s
.39362 .58904 m
.38663 .58406 L
s
.54637 .71112 m
.5474 .70765 L
s
.71071 .8722 m
.70995 .87985 L
s
.43936 .70379 m
.43835 .69488 L
s
.52317 .69138 m
.52363 .68714 L
s
.4464 .85788 m
.45327 .84264 L
s
.44911 .7707 m
.45107 .75919 L
s
.73392 .89821 m
.73198 .90813 L
s
.44116 .90201 m
.45124 .88484 L
s
.46389 .64362 m
.46197 .63827 L
s
.44973 .79638 m
.45296 .7838 L
s
.44926 .77125 m
.45125 .75973 L
s
.43816 .92296 m
.44996 .90489 L
s
.79324 .96738 m
.78741 .98401 L
s
.44848 .76091 m
.44998 .74981 L
s
.45105 .63328 m
.44839 .62786 L
s
.43609 .93541 m
.44898 .91681 L
s
.39061 .58391 m
.38327 .57913 L
s
.77558 .94643 m
.77102 .9609 L
s
.42599 .66 m
.42299 .65261 L
s
.42862 .66764 m
.42599 .66 L
s
.47174 .65007 m
.47022 .6448 L
s
.44675 .74611 m
.44758 .73562 L
s
.43973 .70665 m
.43884 .69765 L
s
.42299 .65261 m
.41963 .64548 L
s
.49115 .66545 m
.49051 .66046 L
s
.44577 .86015 m
.45279 .84483 L
s
.52281 .6912 m
.52326 .68695 L
s
.36201 .52822 m
.35074 .52546 L
s
.44561 .86148 m
.45272 .84612 L
s
.4309 .67553 m
.42862 .66764 L
s
.44674 .84749 m
.45293 .83274 L
s
.53855 .70459 m
.53938 .70083 L
s
.41963 .64548 m
.41589 .6386 L
s
.44305 .72573 m
.44297 .71603 L
s
.72291 .88619 m
.72149 .89493 L
s
.44105 .89781 m
.45081 .88089 L
s
.37805 .56115 m
.3691 .55721 L
s
.4456 .74259 m
.44626 .73225 L
s
.44184 .71973 m
.44149 .71026 L
s
.44902 .79954 m
.45241 .78687 L
s
.39964 .603 m
.39348 .59759 L
s
.40587 .61596 m
.40047 .61011 L
s
.44574 .74442 m
.44647 .73401 L
s
.44926 .63241 m
.44649 .62699 L
s
.43283 .68369 m
.4309 .67553 L
s
.44296 .88011 m
.45139 .86399 L
s
.44862 .80587 m
.45235 .79294 L
s
.51522 .68536 m
.51542 .68089 L
s
.4478 .82498 m
.45261 .81124 L
s
.44001 .71299 m
.43936 .70379 L
s
.77491 .9461 m
.77029 .96038 L
s
.75997 .92902 m
.75635 .94157 L
s
.39176 .5883 m
.38464 .58343 L
s
.37493 .55013 m
.36542 .54661 L
s
.41589 .6386 m
.41174 .63199 L
s
.373 .54726 m
.36325 .54385 L
s
.5591 .72303 m
.56029 .72001 L
s
.44047 .89673 m
.45016 .87992 L
s
.55507 .71924 m
.55619 .71607 L
s
.74424 .91068 m
.74157 .92152 L
s
.44795 .80813 m
.4518 .79513 L
s
.43916 .90538 m
.44954 .88821 L
s
.70145 .86709 m
.70092 .87348 L
s
.44027 .71594 m
.43973 .70665 L
s
.53515 .70225 m
.53586 .69835 L
s
.43442 .69212 m
.43283 .68369 L
s
.44777 .7954 m
.45093 .78295 L
s
.44573 .75388 m
.44687 .74313 L
s
.36808 .54454 m
.35785 .54129 L
s
.76639 .93642 m
.76229 .94965 L
s
.40401 .6141 m
.39846 .60836 L
s
.38822 .58258 m
.38068 .57794 L
s
.35032 .51061 m
.33747 .50863 L
s
.47271 .65177 m
.47122 .64651 L
s
.5312 .69898 m
.53182 .69496 L
s
.43235 .94902 m
.44652 .93002 L
s
.44677 .76894 m
.44861 .75759 L
s
.44325 .86973 m
.45094 .85412 L
s
.36299 .53558 m
.35206 .53267 L
s
.71409 .87942 m
.71295 .88704 L
s
.44743 .806 m
.45116 .79312 L
s
.39965 .60583 m
.39358 .60039 L
s
.7423 .90886 m
.73967 .91942 L
s
.36349 .53368 m
.35255 .53085 L
s
.44181 .7295 m
.44184 .71973 L
s
.44274 .73575 m
.44305 .72573 L
s
.49048 .66602 m
.48976 .66102 L
s
.44548 .75696 m
.44675 .74611 L
s
.38024 .56842 m
.3717 .56433 L
s
.38002 .55934 m
.3712 .55555 L
s
.46966 .64971 m
.46802 .64442 L
s
.41174 .63199 m
.40717 .62566 L
s
.44649 .77237 m
.44848 .76091 L
s
.50243 .67568 m
.50217 .6709 L
s
.42418 .66231 m
.42118 .65493 L
s
.42681 .66995 m
.42418 .66231 L
s
.4403 .7225 m
.44001 .71299 L
s
.44661 .78257 m
.44911 .7707 L
s
.43409 .93361 m
.44688 .91533 L
s
.43816 .90514 m
.44854 .88808 L
s
.43566 .70083 m
.43442 .69212 L
s
.42118 .65493 m
.4178 .64782 L
s
.44539 .83528 m
.45081 .8212 L
s
.44674 .78314 m
.44926 .77125 L
s
.44666 .79978 m
.45005 .7872 L
s
.42909 .67785 m
.42681 .66995 L
s
.70586 .87168 m
.70504 .87841 L
s
.44567 .82916 m
.45072 .81534 L
s
.44451 .75328 m
.4456 .74259 L
s
.4563 .63939 m
.45395 .63401 L
s
.50486 .67783 m
.50468 .6731 L
s
.49124 .66697 m
.49055 .66197 L
s
.44457 .75516 m
.44574 .74442 L
s
.4178 .64782 m
.41404 .64097 L
s
.44044 .72553 m
.44027 .71594 L
s
.69587 .86313 m
.69542 .8688 L
s
.4646 .6462 m
.4627 .64087 L
s
.43102 .68601 m
.42909 .67785 L
s
.49351 .66897 m
.4929 .66401 L
s
.44583 .80933 m
.44973 .79638 L
s
.40047 .61011 m
.39459 .60459 L
s
.74924 .91742 m
.74607 .92858 L
s
.44466 .83281 m
.44993 .81888 L
s
.46783 .64894 m
.46608 .64364 L
s
.56824 .73227 m
.56946 .72956 L
s
.37605 .55518 m
.36681 .55162 L
s
.77912 .95241 m
.77394 .96689 L
s
.4569 .64041 m
.45458 .63503 L
s
.56353 .72805 m
.56468 .72514 L
s
.43655 .70982 m
.43566 .70083 L
s
.43259 .69445 m
.43102 .68601 L
s
.48982 .66629 m
.48906 .66126 L
s
.41404 .64097 m
.40988 .63439 L
s
.49986 .67435 m
.49947 .6695 L
s
.77105 .94297 m
.7664 .95649 L
s
.45837 .64181 m
.45613 .63644 L
s
.46847 .64972 m
.46675 .64442 L
s
.40717 .62566 m
.40216 .61963 L
s
.54878 .715 m
.54968 .71152 L
s
.44412 .76497 m
.44573 .75388 L
s
.44362 .84 m
.44933 .82581 L
s
.44138 .7396 m
.44181 .7295 L
s
.4402 .73231 m
.4403 .7225 L
s
.39348 .59759 m
.38678 .59256 L
s
.38663 .58406 m
.37905 .57951 L
s
.41398 .60198 m
.40866 .59692 L
s
.41888 .60714 m
.41398 .60198 L
s
.44203 .74609 m
.44274 .73575 L
s
.44495 .81257 m
.44902 .79954 L
s
.7604 .9307 m
.75644 .94298 L
s
.32155 .46248 m
.30425 .46263 L
s
.35729 .529 m
.34569 .52652 L
s
.43931 .88348 m
.44803 .86748 L
s
.44207 .85611 m
.44884 .84126 L
s
.34471 .50592 m
.33123 .50435 L
s
.4354 .91309 m
.44646 .89586 L
s
.49918 .67397 m
.49876 .66911 L
s
.40866 .59692 m
.40288 .592 L
s
.35957 .53346 m
.34831 .53082 L
s
.39846 .60836 m
.3924 .60296 L
s
.77348 .94625 m
.76861 .95997 L
s
.4444 .78064 m
.44677 .76894 L
s
.53649 .70471 m
.53713 .70079 L
s
.33987 .49726 m
.32564 .49605 L
s
.42024 1.00712 m
.4404 .986 L
s
.43628 .90461 m
.44665 .88775 L
s
.43381 .70317 m
.43259 .69445 L
s
.44374 .76814 m
.44548 .75696 L
s
.44021 .73544 m
.44044 .72553 L
s
.44417 .81914 m
.44862 .80587 L
s
.41686 1.02565 m
.43912 1.00377 L
s
.42341 .61236 m
.41888 .60714 L
s
.31824 .45716 m
.30041 .45758 L
s
.69688 .86471 m
.69625 .87034 L
s
.45357 .63866 m
.45105 .63328 L
s
.56907 .73369 m
.57022 .73097 L
s
.38327 .57913 m
.37531 .57481 L
s
.44296 .7643 m
.44451 .75328 L
s
.43706 .7191 m
.43655 .70982 L
s
.40988 .63439 m
.4053 .62811 L
s
.44394 .8082 m
.44777 .7954 L
s
.44395 .78418 m
.44649 .77237 L
s
.44336 .82147 m
.44795 .80813 L
s
.44293 .76624 m
.44457 .75516 L
s
.48172 .6608 m
.48059 .65566 L
s
.40288 .592 m
.39661 .58726 L
s
.39358 .60039 m
.38698 .59534 L
s
.72607 .89208 m
.72404 .90067 L
s
.37667 .56746 m
.36787 .56361 L
s
.46675 .64927 m
.46493 .64397 L
s
.42141 .66391 m
.41834 .6566 L
s
.42411 .67148 m
.42141 .66391 L
s
.35933 .53502 m
.34812 .53241 L
s
.44353 .79479 m
.44661 .78257 L
s
.4752 .65588 m
.47379 .65065 L
s
.42644 .67932 m
.42411 .67148 L
s
.56053 .72601 m
.56155 .72293 L
s
.55258 .71906 m
.55348 .71567 L
s
.44215 .83901 m
.4478 .82498 L
s
.44362 .79538 m
.44674 .78314 L
s
.45187 .63778 m
.44926 .63241 L
s
.43466 .71217 m
.43381 .70317 L
s
.41834 .6566 m
.4149 .64957 L
s
.38464 .58343 m
.37692 .57901 L
s
.3099 .44292 m
.29066 .44402 L
s
.76593 .93816 m
.76144 .95087 L
s
.44299 .8192 m
.44743 .806 L
s
.43728 .88735 m
.4463 .87132 L
s
.4315 .93028 m
.44407 .91248 L
s
.43969 .74244 m
.4402 .73231 L
s
.42842 .68742 m
.42644 .67932 L
s
.44052 .75002 m
.44138 .7396 L
s
.33464 .48943 m
.31967 .48865 L
s
.71378 .8786 m
.71234 .88598 L
s
.33442 .48904 m
.31941 .48828 L
s
.40216 .61963 m
.39668 .61392 L
s
.4361 .89454 m
.44569 .87824 L
s
.51625 .68861 m
.51633 .6841 L
s
.41078 1.0533 m
.43641 1.03045 L
s
.74995 .92008 m
.74646 .93099 L
s
.42759 .61762 m
.42341 .61236 L
s
.43952 .86246 m
.44674 .84749 L
s
.46576 .64893 m
.46389 .64362 L
s
.43841 .8733 m
.4464 .85788 L
s
.42901 .94471 m
.4429 .92636 L
s
.37048 .55714 m
.3609 .55373 L
s
.44259 .81269 m
.44666 .79978 L
s
.5617 .72734 m
.56271 .72429 L
s
.55095 .71794 m
.5518 .71447 L
s
.48175 .66127 m
.48061 .65612 L
s
.44086 .75675 m
.44203 .74609 L
s
.4149 .64957 m
.41106 .64281 L
s
.3551 .52864 m
.34333 .52635 L
s
.34903 .51575 m
.33631 .51395 L
s
.52704 .69766 m
.5274 .69342 L
s
.39459 .60459 m
.38819 .59944 L
s
.43003 .6958 m
.42842 .68742 L
s
.4372 .72868 m
.43706 .7191 L
s
.3572 .52984 m
.34566 .52748 L
s
.442 .7764 m
.44412 .76497 L
s
.36778 .54708 m
.35767 .54405 L
s
.3544 .52526 m
.34248 .52309 L
s
.43957 .74566 m
.44021 .73544 L
s
.43388 .90824 m
.44459 .89142 L
s
.42905 .94221 m
.44272 .924 L
s
.36209 .54213 m
.35136 .53933 L
s
.5054 .68015 m
.50514 .67539 L
s
.51377 .68685 m
.51376 .68228 L
s
.4053 .62811 m
.40027 .62213 L
s
.4376 .87561 m
.44577 .86015 L
s
.4323 .9187 m
.44388 .90147 L
s
.34339 .50774 m
.32989 .50632 L
s
.38068 .57794 m
.37252 .5738 L
s
.43514 .72145 m
.43466 .71217 L
s
.54036 .70917 m
.541 .70532 L
s
.43734 .87698 m
.44561 .86148 L
s
.50693 .68153 m
.5067 .67679 L
s
.79727 .97581 m
.79033 .99205 L
s
.43129 .70446 m
.43003 .6958 L
s
.44118 .82258 m
.44583 .80933 L
s
.47327 .65532 m
.47174 .65007 L
s
.39661 .58726 m
.38982 .58277 L
s
.41106 .64281 m
.40681 .63634 L
s
.44146 .77966 m
.44374 .76814 L
s
.44145 .79267 m
.4444 .78064 L
s
.44089 .77565 m
.44296 .7643 L
s
.43974 .84324 m
.44567 .82916 L
s
.51922 .69178 m
.51934 .68732 L
s
.3691 .55721 m
.35943 .55391 L
s
.43289 .90758 m
.44357 .8909 L
s
.43903 .8496 m
.44539 .83528 L
s
.3924 .60296 m
.38583 .59795 L
s
.43874 .75288 m
.43969 .74244 L
s
.51412 .68778 m
.5141 .68319 L
s
.44077 .77764 m
.44293 .76624 L
s
.71234 .87796 m
.7108 .88502 L
s
.4392 .76075 m
.44052 .75002 L
s
.43692 .73855 m
.4372 .72868 L
s
.54948 .71774 m
.55023 .71415 L
s
.35712 .53236 m
.34569 .53004 L
s
.42072 .66418 m
.41762 .65701 L
s
.42345 .67161 m
.42072 .66418 L
s
.43217 .7134 m
.43129 .70446 L
s
.38678 .59256 m
.37951 .58796 L
s
.44081 .7963 m
.44395 .78418 L
s
.78044 .95629 m
.77466 .97038 L
s
.44011 .82588 m
.44495 .81257 L
s
.43147 .6229 m
.42759 .61762 L
s
.41762 .65701 m
.41414 .65009 L
s
.52338 .69564 m
.52359 .69127 L
s
.43522 .73104 m
.43514 .72145 L
s
.45856 .64473 m
.4563 .63939 L
s
.42584 .67929 m
.42345 .67161 L
s
.43848 .84696 m
.44466 .83281 L
s
.42467 .95907 m
.43999 .9404 L
s
.4392 .76773 m
.44086 .75675 L
s
.43848 .75619 m
.43957 .74566 L
s
.36542 .54661 m
.35514 .54375 L
s
.3712 .55555 m
.36166 .55234 L
s
.40681 .63634 m
.40214 .63018 L
s
.77342 .94827 m
.76811 .9615 L
s
.39668 .61392 m
.39072 .60857 L
s
.49193 .67047 m
.49115 .66545 L
s
.41414 .65009 m
.41028 .64345 L
s
.3717 .56433 m
.36247 .56084 L
s
.40027 .62213 m
.39479 .61649 L
s
.42787 .68722 m
.42584 .67929 L
s
.43319 .89622 m
.44296 .88011 L
s
.54572 .71486 m
.54637 .71112 L
s
.43978 .80732 m
.44353 .79479 L
s
.54309 .71243 m
.5437 .70861 L
s
.43938 .82129 m
.44394 .8082 L
s
.47422 .657 m
.47271 .65177 L
s
.77235 .94705 m
.76708 .96012 L
s
.36325 .54385 m
.35271 .54113 L
s
.43985 .80792 m
.44362 .79538 L
s
.43433 .88538 m
.44325 .86973 L
s
.43891 .83267 m
.44417 .81914 L
s
.43931 .78814 m
.442 .7764 L
s
.523 .69578 m
.52317 .69138 L
s
.45913 .64573 m
.4569 .64041 L
s
.37905 .57951 m
.37086 .57548 L
s
.47131 .65497 m
.46966 .64971 L
s
.38698 .59534 m
.37982 .59071 L
s
.43267 .72262 m
.43217 .7134 L
s
.30242 .43444 m
.28212 .43627 L
s
.43693 .85438 m
.44362 .84 L
s
.41964 .67125 m
.41675 .66387 L
s
.42216 .67891 m
.41964 .67125 L
s
.42431 .68684 m
.42216 .67891 L
s
.41028 .64345 m
.40601 .63708 L
s
.46647 .65149 m
.4646 .6462 L
s
.41675 .66387 m
.41349 .65677 L
s
.42949 .91895 m
.44116 .90201 L
s
.42955 .6954 m
.42787 .68722 L
s
.43795 .83505 m
.44336 .82147 L
s
.34891 .52105 m
.33642 .51932 L
s
.52267 .69561 m
.52281 .6912 L
s
.71561 .88249 m
.71373 .88968 L
s
.46054 .64713 m
.45837 .64181 L
s
.42609 .69504 m
.42431 .68684 L
s
.43622 .74873 m
.43692 .73855 L
s
.53808 .70859 m
.53855 .70459 L
s
.5583 .72635 m
.5591 .72303 L
s
.43732 .76362 m
.43874 .75288 L
s
.43489 .74091 m
.43522 .73104 L
s
.42975 .91453 m
.44105 .89781 L
s
.38982 .58277 m
.38246 .5786 L
s
.38819 .59944 m
.38125 .59472 L
s
.41349 .65677 m
.40983 .64995 L
s
.42771 .92855 m
.44023 .91129 L
s
.55433 .7227 m
.55507 .71924 L
s
.43861 .79147 m
.44146 .77966 L
s
.43773 .83265 m
.44299 .8192 L
s
.43825 .7873 m
.44089 .77565 L
s
.46956 .65421 m
.46783 .64894 L
s
.43775 .82586 m
.44259 .81269 L
s
.45597 .64399 m
.45357 .63866 L
s
.41997 .67537 m
.41724 .66788 L
s
.42232 .68312 m
.41997 .67537 L
s
.43737 .77179 m
.4392 .76075 L
s
.51529 .68997 m
.51522 .68536 L
s
.36681 .55162 m
.35682 .5487 L
s
.4275 .70351 m
.42609 .69504 L
s
.40214 .63018 m
.39703 .62434 L
s
.35074 .52546 m
.33857 .52361 L
s
.41724 .66788 m
.41413 .66068 L
s
.35785 .54129 m
.3468 .53884 L
s
.42431 .69115 m
.42232 .68312 L
s
.43419 .87106 m
.44207 .85611 L
s
.43088 .70383 m
.42955 .6954 L
s
.37531 .57481 m
.36671 .57106 L
s
.42926 .91335 m
.44047 .89673 L
s
.43803 .78934 m
.44077 .77764 L
s
.43277 .73213 m
.43267 .72262 L
s
.43785 .80499 m
.44145 .79267 L
s
.34363 .5135 m
.33043 .51217 L
s
.78106 .95829 m
.77496 .97215 L
s
.4369 .76701 m
.43848 .75619 L
s
.49132 .67106 m
.49048 .66602 L
s
.77862 .95545 m
.7727 .96902 L
s
.40601 .63708 m
.40133 .63101 L
s
.47018 .65498 m
.46847 .64972 L
s
.41413 .66068 m
.41064 .65376 L
s
.70423 .87044 m
.70281 .87651 L
s
.45436 .64311 m
.45187 .63778 L
s
.43554 .85322 m
.44215 .83901 L
s
.42593 .69945 m
.42431 .69115 L
s
.40983 .64995 m
.40577 .64343 L
s
.43702 .77901 m
.4392 .76773 L
s
.43508 .62817 m
.43147 .6229 L
s
.53478 .70637 m
.53515 .70225 L
s
.37692 .57901 m
.36858 .57513 L
s
.33801 .50527 m
.32401 .50435 L
s
.42854 .71226 m
.4275 .70351 L
s
.53093 .70322 m
.5312 .69898 L
s
.49207 .672 m
.49124 .66697 L
s
.73009 .89957 m
.72728 .90796 L
s
.70528 .87189 m
.70375 .878 L
s
.5029 .68054 m
.50243 .67568 L
s
.75927 .93302 m
.75464 .94436 L
s
.39479 .61649 m
.38882 .61123 L
s
.56742 .7353 m
.56824 .73227 L
s
.42716 .92224 m
.43916 .90538 L
s
.42718 .70803 m
.42593 .69945 L
s
.41064 .65376 m
.40675 .64714 L
s
.43701 .8087 m
.44081 .7963 L
s
.38583 .59795 m
.3787 .59339 L
s
.4245 .94053 m
.43816 .92296 L
s
.43412 .75108 m
.43489 .74091 L
s
.4357 .83604 m
.44118 .82258 L
s
.41978 .67906 m
.41717 .67152 L
s
.42201 .68688 m
.41978 .67906 L
s
.41717 .67152 m
.41419 .66425 L
s
.35206 .53267 m
.34026 .53068 L
s
.43186 .71251 m
.43088 .70383 L
s
.43505 .75919 m
.43622 .74873 L
s
.35255 .53085 m
.34074 .5289 L
s
.39072 .60857 m
.38426 .60362 L
s
.7269 .89619 m
.72422 .90423 L
s
.56277 .73127 m
.56353 .72805 L
s
.49428 .67397 m
.49351 .66897 L
s
.41924 .97338 m
.4361 .95457 L
s
.42387 .69497 m
.42201 .68688 L
s
.50527 .68266 m
.50486 .67783 L
s
.41419 .66425 m
.41083 .65727 L
s
.81723 1.00262 m
.80804 1.02075 L
s
.41017 .60641 m
.40474 .60155 L
s
.41519 .6114 m
.41017 .60641 L
s
.42919 .72129 m
.42854 .71226 L
s
.43245 .74192 m
.43277 .73213 L
s
.36787 .56361 m
.35838 .56042 L
s
.40577 .64343 m
.4013 .63722 L
s
.46855 .65453 m
.46675 .64927 L
s
.49072 .67134 m
.48982 .66629 L
s
.43538 .77465 m
.43732 .76362 L
s
.40474 .60155 m
.39886 .59684 L
s
.43599 .80015 m
.43931 .78814 L
s
.42536 .70334 m
.42387 .69497 L
s
.42804 .71689 m
.42718 .70803 L
s
.40133 .63101 m
.39621 .62527 L
s
.42923 .89935 m
.43931 .88348 L
s
.4187 .97349 m
.4356 .95475 L
s
.33252 .49743 m
.31775 .49697 L
s
.42617 .92187 m
.43816 .90514 L
s
.40675 .64714 m
.40246 .64082 L
s
.41083 .65727 m
.40708 .65058 L
s
.39703 .62434 m
.39146 .61887 L
s
.4353 .82008 m
.43978 .80732 L
s
.37252 .5738 m
.36371 .57026 L
s
.41983 .61646 m
.41519 .6114 L
s
.50044 .67926 m
.49986 .67435 L
s
.46762 .6542 m
.46576 .64893 L
s
.5683 .73673 m
.56907 .73369 L
s
.43533 .82069 m
.43985 .80792 L
s
.43114 .87743 m
.43952 .86246 L
s
.43442 .83938 m
.44011 .82588 L
s
.435 .7831 m
.43737 .77179 L
s
.41265 1.00811 m
.43328 .98808 L
s
.37951 .58796 m
.37166 .58388 L
s
.54826 .71876 m
.54878 .715 L
s
.47667 .66108 m
.4752 .65588 L
s
.43282 .85743 m
.43974 .84324 L
s
.40656 1.04308 m
.4313 1.02171 L
s
.78797 .96764 m
.78108 .98202 L
s
.42647 .71197 m
.42536 .70334 L
s
.42118 .95328 m
.43609 .93541 L
s
.43247 .72146 m
.43186 .71251 L
s
.43479 .77812 m
.4369 .76701 L
s
.49979 .6789 m
.49918 .67397 L
s
.435 .79921 m
.43825 .7873 L
s
.48293 .66595 m
.48172 .6608 L
s
.39886 .59684 m
.3925 .59234 L
s
.42944 .7306 m
.42919 .72129 L
s
.43399 .83456 m
.43938 .82129 L
s
.43511 .80354 m
.43861 .79147 L
s
.79138 .97187 m
.78419 .98661 L
s
.42851 .72602 m
.42804 .71689 L
s
.43164 .86399 m
.43903 .8496 L
s
.43287 .76152 m
.43412 .75108 L
s
.38246 .5786 m
.3745 .57483 L
s
.42916 .88863 m
.43841 .8733 L
s
.40708 .65058 m
.40292 .6442 L
s
.40987 .60775 m
.40446 .60291 L
s
.41488 .6127 m
.40987 .60775 L
s
.43466 .8013 m
.43803 .78934 L
s
.43425 .79055 m
.43702 .77901 L
s
.5362 .70886 m
.53649 .70471 L
s
.40446 .60291 m
.3986 .59823 L
s
.4013 .63722 m
.3964 .63134 L
s
.43168 .752 m
.43245 .74192 L
s
.37982 .59071 m
.37209 .5866 L
s
.29331 .42474 m
.27172 .42752 L
s
.43338 .76993 m
.43505 .75919 L
s
.3609 .55373 m
.35057 .55109 L
s
.43275 .84634 m
.43891 .83267 L
s
.4272 .72088 m
.42647 .71197 L
s
.55991 .7294 m
.56053 .72601 L
s
.48298 .66642 m
.48175 .66127 L
s
.40712 .60572 m
.40149 .60096 L
s
.41232 .61061 m
.40712 .60572 L
s
.40246 .64082 m
.39774 .63483 L
s
.43128 .86119 m
.43848 .84696 L
s
.42414 .62156 m
.41983 .61646 L
s
.33747 .50863 m
.3236 .50786 L
s
.43352 .81752 m
.43785 .80499 L
s
.42684 .90316 m
.43728 .88735 L
s
.46075 .65002 m
.45856 .64473 L
s
.42815 .89096 m
.4376 .87561 L
s
.55207 .72273 m
.55258 .71906 L
s
.38125 .59472 m
.37375 .59049 L
s
.41951 .61773 m
.41488 .6127 L
s
.43847 .63341 m
.43508 .62817 L
s
.77037 .9477 m
.76464 .95989 L
s
.41713 .61559 m
.41232 .61061 L
s
.34831 .53082 m
.33618 .52917 L
s
.47483 .66054 m
.47327 .65532 L
s
.56109 .73071 m
.5617 .72734 L
s
.35767 .54405 m
.34677 .54179 L
s
.40149 .60096 m
.39541 .59639 L
s
.42431 .92107 m
.43628 .90461 L
s
.39621 .62527 m
.39063 .61989 L
s
.38882 .61123 m
.38234 .60639 L
s
.43271 .73065 m
.43247 .72146 L
s
.42778 .89235 m
.43734 .87698 L
s
.42926 .74018 m
.42944 .7306 L
s
.3986 .59823 m
.39227 .59377 L
s
.42857 .73542 m
.42851 .72602 L
s
.43161 .84875 m
.43795 .83505 L
s
.72396 .89436 m
.72116 .90182 L
s
.43287 .78594 m
.43538 .77465 L
s
.34569 .52652 m
.33319 .52508 L
s
.43206 .83918 m
.43775 .82586 L
s
.40292 .6442 m
.39835 .63814 L
s
.55049 .72169 m
.55095 .71794 L
s
.3925 .59234 m
.38562 .58812 L
s
.43157 .84622 m
.43773 .83265 L
s
.42263 .92983 m
.4354 .91309 L
s
.42752 .73007 m
.4272 .72088 L
s
.37086 .57548 m
.36201 .57207 L
s
.42502 .91054 m
.4361 .89454 L
s
.46131 .65102 m
.45913 .64573 L
s
.41932 .95111 m
.43409 .93361 L
s
.51646 .69327 m
.51625 .68861 L
s
.43246 .82129 m
.43701 .8087 L
s
.39146 .61887 m
.3854 .6138 L
s
.35943 .55391 m
.34902 .5514 L
s
.34812 .53241 m
.33605 .53079 L
s
.4164 .68323 m
.41383 .67576 L
s
.41859 .69098 m
.4164 .68323 L
s
.42916 .86877 m
.43693 .85438 L
s
.38426 .60362 m
.37726 .59914 L
s
.4216 .62064 m
.41713 .61559 L
s
.41383 .67576 m
.41088 .66857 L
s
.42041 .69901 m
.41859 .69098 L
s
.5059 .68501 m
.5054 .68015 L
s
.52702 .70209 m
.52704 .69766 L
s
.36166 .55234 m
.35137 .54984 L
s
.43202 .79465 m
.435 .7831 L
s
.43043 .76233 m
.43168 .752 L
s
.43198 .81237 m
.43599 .80015 L
s
.43111 .77223 m
.43287 .76152 L
s
.43211 .78947 m
.43479 .77812 L
s
.39541 .59639 m
.38884 .59207 L
s
.42382 .6228 m
.41951 .61773 L
s
.51405 .69157 m
.51377 .68685 L
s
.35136 .53933 m
.33981 .53746 L
s
.3964 .63134 m
.39105 .62583 L
s
.36247 .56084 m
.35254 .5581 L
s
.46265 .6524 m
.46054 .64713 L
s
.41088 .66857 m
.40754 .66167 L
s
.42185 .70732 m
.42041 .69901 L
s
.39774 .63483 m
.39259 .6292 L
s
.54011 .71327 m
.54036 .70917 L
s
.3787 .59339 m
.37101 .58935 L
s
.45829 .64927 m
.45597 .64399 L
s
.42819 .74509 m
.42857 .73542 L
s
.5074 .68636 m
.50693 .68153 L
s
.42864 .75003 m
.42926 .74018 L
s
.42816 .62669 m
.42414 .62156 L
s
.46834 .65674 m
.46647 .65149 L
s
.41597 .96699 m
.43235 .94902 L
s
.47577 .66221 m
.47422 .657 L
s
.43117 .78092 m
.43338 .76993 L
s
.43255 .74009 m
.43271 .73065 L
s
.39227 .59377 m
.38543 .58958 L
s
.42742 .73951 m
.42752 .73007 L
s
.47298 .6602 m
.47131 .65497 L
s
.45676 .64839 m
.45436 .64311 L
s
.70092 .87348 m
.69909 .8785 L
s
.73626 .9092 m
.73256 .91763 L
s
.43105 .81133 m
.435 .79921 L
s
.34566 .52748 m
.33323 .52614 L
s
.4229 .71589 m
.42185 .70732 L
s
.69542 .8688 m
.69383 .87328 L
s
.40754 .66167 m
.40382 .65508 L
s
.42929 .84958 m
.4357 .83604 L
s
.39835 .63814 m
.39335 .63244 L
s
.42153 .92457 m
.43388 .90824 L
s
.35514 .54375 m
.34406 .54172 L
s
.43084 .8023 m
.43425 .79055 L
s
.54912 .7216 m
.54948 .71774 L
s
.51941 .6964 m
.51922 .69178 L
s
.70995 .87985 m
.70768 .88583 L
s
.36671 .57106 m
.35745 .56798 L
s
.4309 .8158 m
.43511 .80354 L
s
.43 .83298 m
.4353 .82008 L
s
.42786 .86741 m
.43554 .85322 L
s
.51444 .69251 m
.51412 .68778 L
s
.34333 .52635 m
.33067 .52514 L
s
.36858 .57513 m
.35959 .57191 L
s
.49288 .67552 m
.49193 .67047 L
s
.43 .83359 m
.43533 .82069 L
s
.91797 1.1358 m
.89767 1.16846 L
s
.71957 .89071 m
.71677 .89751 L
s
.4306 .81344 m
.43466 .8013 L
s
.47131 .65944 m
.46956 .65421 L
s
.39063 .61989 m
.38457 .61491 L
s
.34248 .52309 m
.32963 .52201 L
s
.42402 .90077 m
.43433 .88538 L
s
.41512 .68649 m
.41263 .67902 L
s
.41723 .69424 m
.41512 .68649 L
s
.42576 .62571 m
.4216 .62064 L
s
.42354 .72473 m
.4229 .71589 L
s
.41263 .67902 m
.40977 .67183 L
s
.41896 .70227 m
.41723 .69424 L
s
.33123 .50435 m
.3167 .50413 L
s
.5235 .7002 m
.52338 .69564 L
s
.35271 .54113 m
.34136 .53929 L
s
.74157 .91649 m
.73742 .92527 L
s
.76871 .94748 m
.76272 .95907 L
s
.38562 .58812 m
.3782 .58425 L
s
.42975 .79745 m
.43287 .78594 L
s
.42735 .75502 m
.42819 .74509 L
s
.42509 .88585 m
.43419 .87106 L
s
.54545 .71886 m
.54572 .71486 L
s
.40382 .65508 m
.39969 .64881 L
s
.42059 .92376 m
.43289 .90758 L
s
.47192 .66021 m
.47018 .65498 L
s
.42866 .77291 m
.43043 .76233 L
s
.40977 .67183 m
.40651 .66494 L
s
.73546 .90987 m
.73166 .91802 L
s
.42688 .74921 m
.42742 .73951 L
s
.54287 .7165 m
.54309 .71243 L
s
.42031 .71057 m
.41896 .70227 L
s
.38884 .59207 m
.38174 .58805 L
s
.71645 .88953 m
.71372 .89586 L
s
.41894 .93527 m
.4323 .9187 L
s
.42755 .76012 m
.42864 .75003 L
s
.34569 .53004 m
.33338 .52873 L
s
.42784 .6279 m
.42382 .6228 L
s
.42193 .91193 m
.43319 .89622 L
s
.3745 .57483 m
.36592 .57156 L
s
.35682 .5487 m
.34607 .54657 L
s
.42777 .85291 m
.43442 .83938 L
s
.42879 .78316 m
.43111 .77223 L
s
.5579 .72998 m
.5583 .72635 L
s
.417 .94726 m
.4315 .93028 L
s
.37166 .58388 m
.3632 .58041 L
s
.33631 .51395 m
.32262 .51337 L
s
.42769 .84789 m
.43399 .83456 L
s
.43197 .74978 m
.43255 .74009 L
s
.38234 .60639 m
.37535 .60203 L
s
.39259 .6292 m
.38698 .62395 L
s
.44166 .63863 m
.43847 .63341 L
s
.39105 .62583 m
.38524 .62073 L
s
.4284 .83018 m
.43352 .81752 L
s
.52316 .70036 m
.523 .69578 L
s
.42378 .73383 m
.42354 .72473 L
s
.42126 .71914 m
.42031 .71057 L
s
.82947 1.02129 m
.81835 1.04008 L
s
.40651 .66494 m
.40287 .65835 L
s
.69625 .87034 m
.69443 .87473 L
s
.7491 .92548 m
.74436 .9349 L
s
.554 .72647 m
.55433 .7227 L
s
.75335 .92993 m
.74833 .9398 L
s
.3854 .6138 m
.37885 .60917 L
s
.70504 .87841 m
.70281 .88361 L
s
.32564 .49605 m
.31031 .49633 L
s
.42879 .80101 m
.43211 .78947 L
s
.79169 .9752 m
.78381 .98924 L
s
.52286 .7002 m
.52267 .69561 L
s
.42838 .80638 m
.43202 .79465 L
s
.38543 .58958 m
.37805 .58574 L
s
.53798 .71283 m
.53808 .70859 L
s
.39335 .63244 m
.38789 .62711 L
s
.43191 .63181 m
.42816 .62669 L
s
.37209 .5866 m
.36376 .58309 L
s
.42837 .79211 m
.43117 .78092 L
s
.47038 .65977 m
.46855 .65453 L
s
.49234 .67614 m
.49132 .67106 L
s
.39969 .64881 m
.39514 .64288 L
s
.56699 .73865 m
.56742 .7353 L
s
.36371 .57026 m
.35424 .56744 L
s
.37375 .59049 m
.36568 .58684 L
s
.42479 .87152 m
.43282 .85743 L
s
.42181 .72797 m
.42126 .71914 L
s
.51566 .69472 m
.51529 .68997 L
s
.35838 .56042 m
.34817 .55804 L
s
.40287 .65835 m
.39882 .65209 L
s
.42586 .75916 m
.42688 .74921 L
s
.42558 .85998 m
.43275 .84634 L
s
.42602 .76518 m
.42735 .75502 L
s
.77385 .95453 m
.76726 .96644 L
s
.75255 .92994 m
.74747 .93959 L
s
.42721 .82472 m
.43198 .81237 L
s
.46949 .65943 m
.46762 .6542 L
s
.42709 .83397 m
.43246 .82129 L
s
.42359 .74318 m
.42378 .73383 L
s
.49308 .67708 m
.49207 .672 L
s
.37726 .59914 m
.36972 .5952 L
s
.56242 .73482 m
.56277 .73127 L
s
.32989 .50632 m
.31537 .50629 L
s
.41259 .68846 m
.4101 .68109 L
s
.41471 .69612 m
.41259 .68846 L
s
.42964 .6308 m
.42576 .62571 L
s
.41644 .70405 m
.41471 .69612 L
s
.3468 .53884 m
.33493 .53741 L
s
.42595 .77045 m
.42755 .76012 L
s
.42541 .8525 m
.43206 .83918 L
s
.41299 .96197 m
.42901 .94471 L
s
.4101 .68109 m
.40722 .67401 L
s
.53479 .71072 m
.53478 .70637 L
s
.41329 .95936 m
.42905 .94221 L
s
.7349 .91045 m
.73088 .91828 L
s
.71295 .88704 m
.71018 .89282 L
s
.42634 .7837 m
.42866 .77291 L
s
.42673 .81421 m
.43084 .8023 L
s
.50361 .6855 m
.5029 .68054 L
s
.42308 .87822 m
.43164 .86399 L
s
.41778 .71225 m
.41644 .70405 L
s
.39674 1.06045 m
.42408 1.03966 L
s
.53101 .70767 m
.53093 .70322 L
s
.49524 .67903 m
.49428 .67397 L
s
.43096 .75969 m
.43197 .74978 L
s
.42194 .73705 m
.42181 .72797 L
s
.42636 .82355 m
.43105 .81133 L
s
.56794 .7401 m
.5683 .73673 L
s
.38457 .61491 m
.37803 .61038 L
s
.42425 .86239 m
.43161 .84875 L
s
.42147 .89214 m
.43114 .87743 L
s
.47821 .66628 m
.47667 .66108 L
s
.40722 .67401 m
.40396 .66722 L
s
.41316 .6931 m
.41087 .6856 L
s
.41506 .70088 m
.41316 .6931 L
s
.49179 .67643 m
.49072 .67134 L
s
.41087 .6856 m
.4082 .67838 L
s
.46291 .65527 m
.46075 .65002 L
s
.42294 .87527 m
.43128 .86119 L
s
.42441 .85974 m
.43157 .84622 L
s
.41674 .93058 m
.42975 .91453 L
s
.41658 .70893 m
.41506 .70088 L
s
.41605 .93516 m
.42949 .91895 L
s
.50593 .68759 m
.50527 .68266 L
s
.4316 .63299 m
.42784 .6279 L
s
.41873 .72071 m
.41778 .71225 L
s
.38174 .58805 m
.37409 .58443 L
s
.4082 .67838 m
.40514 .67146 L
s
.42588 .79427 m
.42879 .78316 L
s
.42591 .82815 m
.4309 .8158 L
s
.39882 .65209 m
.39437 .64617 L
s
.42595 .8091 m
.42975 .79745 L
s
.39514 .64288 m
.39018 .63733 L
s
.33642 .51932 m
.32298 .51881 L
s
.31967 .48865 m
.30355 .48953 L
s
.72149 .89493 m
.71818 .90148 L
s
.31941 .48828 m
.30325 .48918 L
s
.42577 .82568 m
.4306 .81344 L
s
.48427 .67112 m
.48293 .66595 L
s
.3782 .58425 m
.3702 .58082 L
s
.41771 .71724 m
.41658 .70893 L
s
.37101 .58935 m
.36274 .58593 L
s
.41635 .92928 m
.42926 .91335 L
s
.38698 .62395 m
.3809 .61914 L
s
.42293 .75277 m
.42359 .74318 L
s
.33857 .52361 m
.32548 .52294 L
s
.40396 .66722 m
.4003 .66076 L
s
.38524 .62073 m
.37895 .61607 L
s
.50126 .68426 m
.50044 .67926 L
s
.40514 .67146 m
.4017 .66485 L
s
.42435 .76932 m
.42586 .75916 L
s
.54814 .72281 m
.54826 .71876 L
s
.36201 .57207 m
.35252 .5694 L
s
.38789 .62711 m
.38198 .62222 L
s
.41927 .72942 m
.41873 .72071 L
s
.42162 .74637 m
.42194 .73705 L
s
.79746 .98372 m
.78875 .99803 L
s
.46346 .65626 m
.46131 .65102 L
s
.42417 .77555 m
.42602 .76518 L
s
.41762 .91469 m
.42923 .89935 L
s
.4238 .84587 m
.43 .83298 L
s
.41843 .72582 m
.41771 .71724 L
s
.75042 .9287 m
.74523 .93786 L
s
.50064 .68391 m
.49979 .6789 L
s
.47647 .66575 m
.47483 .66054 L
s
.48434 .67159 m
.48298 .66642 L
s
.34074 .5289 m
.32805 .52808 L
s
.42377 .84649 m
.43 .83359 L
s
.55969 .73311 m
.55991 .7294 L
s
.4185 .90354 m
.42916 .88863 L
s
.34026 .53068 m
.32759 .52984 L
s
.42492 .80345 m
.42837 .79211 L
s
.4133 .94491 m
.42771 .92855 L
s
.46058 .65451 m
.45829 .64927 L
s
.42478 .81268 m
.42879 .80101 L
s
.4238 .78097 m
.42595 .77045 L
s
.37805 .58574 m
.3701 .58233 L
s
.35057 .55109 m
.33948 .54939 L
s
.4003 .66076 m
.39625 .65462 L
s
.43544 .63692 m
.43191 .63181 L
s
.4017 .66485 m
.39787 .65857 L
s
.37885 .60917 m
.37179 .60506 L
s
.45912 .65363 m
.45676 .64839 L
s
.4202 .8829 m
.42916 .86877 L
s
.46476 .65764 m
.46265 .6524 L
s
.42402 .81822 m
.42838 .80638 L
s
.42186 .86301 m
.42929 .84958 L
s
.56089 .73439 m
.56109 .73071 L
s
.37535 .60203 m
.36783 .59823 L
s
.41939 .73838 m
.41927 .72942 L
s
.39437 .64617 m
.3895 .64063 L
s
.5363 .71325 m
.5362 .70886 L
s
.42947 .7698 m
.43096 .75969 L
s
.41874 .73463 m
.41843 .72582 L
s
.30425 .46263 m
.28562 .46489 L
s
.55197 .72671 m
.55207 .72273 L
s
.80527 .99382 m
.79575 1.0089 L
s
.40327 .61151 m
.3976 .60702 L
s
.40854 .61615 m
.40327 .61151 L
s
.4218 .76257 m
.42293 .75277 L
s
.41335 .93826 m
.42716 .92224 L
s
.4447 .64381 m
.44166 .63863 L
s
.33043 .51217 m
.31624 .51221 L
s
.73818 .91482 m
.73367 .92269 L
s
.42342 .79464 m
.42634 .7837 L
s
.41728 .90584 m
.42815 .89096 L
s
.4333 .63587 m
.42964 .6308 L
s
.28383 .42314 m
.26136 .42722 L
s
.3976 .60702 m
.39148 .60273 L
s
.42241 .84282 m
.4284 .83018 L
s
.42085 .75591 m
.42162 .74637 L
s
.39018 .63733 m
.38477 .63217 L
s
.47024 .66198 m
.46834 .65674 L
s
.41344 .6209 m
.40854 .61615 L
s
.36592 .57156 m
.3567 .56891 L
s
.34677 .54179 m
.33507 .54053 L
s
.41678 .90723 m
.42778 .89235 L
s
.71234 .88598 m
.70928 .89147 L
s
.55044 .72574 m
.55049 .72169 L
s
.73198 .90813 m
.72778 .91534 L
s
.35137 .54984 m
.34032 .54822 L
s
.80763 .99718 m
.79778 1.01242 L
s
.35959 .57191 m
.34995 .56946 L
s
.39787 .65857 m
.39363 .65263 L
s
.47472 .66541 m
.47298 .6602 L
s
.42229 .77966 m
.42435 .76932 L
s
.35254 .5581 m
.34188 .55625 L
s
.47741 .66742 m
.47577 .66221 L
s
.39625 .65462 m
.39179 .64885 L
s
.40701 .97626 m
.42467 .95907 L
s
.41861 .74369 m
.41874 .73463 L
s
.35745 .56798 m
.34751 .56571 L
s
.419 .88133 m
.42786 .86741 L
s
.41906 .74757 m
.41939 .73838 L
s
.34902 .5514 m
.33785 .54985 L
s
.42037 .86109 m
.42769 .84789 L
s
.41239 .93772 m
.42617 .92187 L
s
.41485 .91834 m
.42684 .90316 L
s
.30041 .45758 m
.28122 .46024 L
s
.42231 .80551 m
.42588 .79427 L
s
.42007 .86629 m
.42777 .85291 L
s
.4216 .83706 m
.42721 .82472 L
s
.42175 .78609 m
.42417 .77555 L
s
.37803 .61038 m
.37097 .60636 L
s
.3632 .58041 m
.35412 .57765 L
s
.42185 .82615 m
.42673 .81421 L
s
.39148 .60273 m
.3849 .59871 L
s
.40956 .69611 m
.40729 .68878 L
s
.41146 .70371 m
.40956 .69611 L
s
.43514 .63807 m
.4316 .63299 L
s
.40729 .68878 m
.40463 .68174 L
s
.51698 .69809 m
.51646 .69327 L
s
.41296 .71159 m
.41146 .70371 L
s
.47313 .66467 m
.47131 .65944 L
s
.50667 .68998 m
.5059 .68501 L
s
.3809 .61914 m
.37434 .61483 L
s
.32401 .50435 m
.30898 .50496 L
s
.41801 .62572 m
.41344 .6209 L
s
.42083 .8466 m
.42709 .83397 L
s
.37409 .58443 m
.36587 .58129 L
s
.42142 .82081 m
.42595 .8091 L
s
.52735 .70673 m
.52702 .70209 L
s
.36972 .5952 m
.36161 .59188 L
s
.40463 .68174 m
.40159 .67499 L
s
.38198 .62222 m
.3756 .6178 L
s
.36568 .58684 m
.35701 .58387 L
s
.41407 .71971 m
.41296 .71159 L
s
.42083 .83578 m
.42636 .82355 L
s
.51465 .69644 m
.51405 .69157 L
s
.36376 .58309 m
.35483 .58029 L
s
.42106 .79163 m
.4238 .78097 L
s
.4088 .9569 m
.4245 .94053 L
s
.42015 .77256 m
.4218 .76257 L
s
.54025 .71764 m
.54011 .71327 L
s
.3895 .64063 m
.3842 .63549 L
s
.7108 .88502 m
.70768 .89023 L
s
.41958 .76566 m
.42085 .75591 L
s
.84378 1.04291 m
.83038 1.0626 L
s
.50815 .69133 m
.5074 .68636 L
s
.37895 .61607 m
.37218 .61192 L
s
.47372 .66544 m
.47192 .66021 L
s
.74147 .92039 m
.7365 .92827 L
s
.33618 .52917 m
.32318 .52874 L
s
.41803 .75295 m
.41861 .74369 L
s
.54917 .72576 m
.54912 .7216 L
s
.42747 .78008 m
.42947 .7698 L
s
.39363 .65263 m
.38899 .64706 L
s
.41827 .75697 m
.41906 .74757 L
s
.4123 .92578 m
.42502 .91054 L
s
.40159 .67499 m
.39816 .66857 L
s
.41478 .72809 m
.41407 .71971 L
s
.3702 .58082 m
.36161 .57794 L
s
.40894 .70046 m
.40684 .69307 L
s
.41066 .70812 m
.40894 .70046 L
s
.40684 .69307 m
.40435 .68596 L
s
.49402 .68064 m
.49288 .67552 L
s
.70281 .87651 m
.70004 .881 L
s
.42007 .84046 m
.42591 .82815 L
s
.42078 .81487 m
.42492 .80345 L
s
.4201 .8379 m
.42577 .82568 L
s
.39179 .64885 m
.38692 .64345 L
s
.41198 .71605 m
.41066 .70812 L
s
.34406 .54172 m
.33219 .54072 L
s
.33981 .53746 m
.32743 .53674 L
s
.41057 .93662 m
.42431 .92107 L
s
.40435 .68596 m
.40148 .67915 L
s
.51993 .70121 m
.51941 .6964 L
s
.38477 .63217 m
.37892 .62746 L
s
.51506 .6974 m
.51444 .69251 L
s
.41462 .90014 m
.42509 .88585 L
s
.41773 .86562 m
.42541 .8525 L
s
.33319 .52508 m
.31981 .52493 L
s
.41731 .87337 m
.42558 .85998 L
s
.33605 .53079 m
.32312 .5304 L
s
.41984 .80568 m
.42342 .79464 L
s
.42003 .82437 m
.42478 .81268 L
s
.3849 .59871 m
.37782 .59502 L
s
.41291 .72423 m
.41198 .71605 L
s
.40289 .61465 m
.39728 .61024 L
s
.40811 .61921 m
.40289 .61465 L
s
.55792 .73393 m
.5579 .72998 L
s
.39687 1.02561 m
.42024 1.00712 L
s
.47226 .665 m
.47038 .65977 L
s
.39728 .61024 m
.39125 .60602 L
s
.41507 .73669 m
.41478 .72809 L
s
.41966 .79014 m
.42229 .77966 L
s
.54559 .72316 m
.54545 .71886 L
s
.70375 .878 m
.70085 .88247 L
s
.72404 .90067 m
.72002 .90685 L
s
.4388 .64201 m
.43544 .63692 L
s
.39816 .66857 m
.39435 .66247 L
s
.40148 .67915 m
.39823 .67266 L
s
.35424 .56744 m
.3441 .56547 L
s
.41555 .88525 m
.42479 .87152 L
s
.3701 .58233 m
.36157 .57948 L
s
.34607 .54657 m
.33454 .54544 L
s
.52397 .70496 m
.5235 .7002 L
s
.42229 .63057 m
.41801 .62572 L
s
.54306 .72085 m
.54287 .7165 L
s
.41887 .83004 m
.42402 .81822 L
s
.56699 .74233 m
.56699 .73865 L
s
.41221 .91548 m
.42402 .90077 L
s
.47141 .66466 m
.46949 .65943 L
s
.41342 .73264 m
.41291 .72423 L
s
.41697 .76241 m
.41803 .75295 L
s
.37179 .60506 m
.36421 .60155 L
s
.29066 .44402 m
.26995 .44769 L
s
.31775 .49697 m
.30192 .49821 L
s
.55409 .73054 m
.554 .72647 L
s
.43675 .64093 m
.4333 .63587 L
s
.34136 .53929 m
.3292 .53854 L
s
.41872 .79673 m
.42175 .78609 L
s
.36274 .58593 m
.35387 .58322 L
s
.41297 .62387 m
.40811 .61921 L
s
.41778 .77556 m
.41958 .76566 L
s
.41577 .87572 m
.42425 .86239 L
s
.41615 .87298 m
.42441 .85974 L
s
.41698 .76654 m
.41827 .75697 L
s
.3236 .50786 m
.30874 .50861 L
s
.41795 .7827 m
.42015 .77256 L
s
.39125 .60602 m
.38476 .60207 L
s
.40798 .94547 m
.42263 .92983 L
s
.46509 .66049 m
.46291 .65527 L
s
.39823 .67266 m
.39459 .66649 L
s
.38899 .64706 m
.38393 .64189 L
s
.40739 .70376 m
.40539 .6964 L
s
.40901 .71138 m
.40739 .70376 L
s
.41663 .85859 m
.4238 .84587 L
s
.40539 .6964 m
.40301 .68933 L
s
.41492 .74551 m
.41507 .73669 L
s
.52368 .70515 m
.52316 .70036 L
s
.71373 .88968 m
.71018 .89486 L
s
.33323 .52614 m
.31992 .52608 L
s
.3842 .63549 m
.37846 .6308 L
s
.49356 .68128 m
.49234 .67614 L
s
.36783 .59823 m
.35975 .59507 L
s
.41803 .81678 m
.42231 .80551 L
s
.41023 .71926 m
.40901 .71138 L
s
.56248 .73868 m
.56242 .73482 L
s
.41655 .8592 m
.42377 .84649 L
s
.40405 .96965 m
.42118 .95328 L
s
.34817 .55804 m
.33725 .55662 L
s
.40301 .68933 m
.40024 .68255 L
s
.53828 .71733 m
.53798 .71283 L
s
.41351 .74128 m
.41342 .73264 L
s
.39435 .66247 m
.39014 .65674 L
s
.4177 .80238 m
.42106 .79163 L
s
.56799 .7438 m
.56794 .7401 L
s
.5234 .705 m
.52286 .7002 L
s
.38692 .64345 m
.38163 .63848 L
s
.41326 .89197 m
.42308 .87822 L
s
.44763 .64895 m
.4447 .64381 L
s
.40618 .70109 m
.40403 .69389 L
s
.40796 .70856 m
.40618 .70109 L
s
.41104 .72738 m
.41023 .71926 L
s
.74157 .92152 m
.73626 .92907 L
s
.41337 .8889 m
.42294 .87527 L
s
.40403 .69389 m
.40149 .68697 L
s
.40934 .71629 m
.40796 .70856 L
s
.4943 .68223 m
.49308 .67708 L
s
.42494 .79049 m
.42747 .78008 L
s
.47987 .6715 m
.47821 .66628 L
s
.73967 .91942 m
.73447 .92678 L
s
.40024 .68255 m
.39709 .67609 L
s
.40738 .93985 m
.42153 .92457 L
s
.33067 .52514 m
.31712 .52528 L
s
.37434 .61483 m
.36729 .61106 L
s
.41752 .6286 m
.41297 .62387 L
s
.51636 .69964 m
.51566 .69472 L
s
.46563 .66148 m
.46346 .65626 L
s
.43852 .64312 m
.43514 .63807 L
s
.40902 .92677 m
.42193 .91193 L
s
.3756 .6178 m
.36874 .61392 L
s
.37097 .60636 m
.36341 .60294 L
s
.40149 .68697 m
.39857 .68036 L
s
.39459 .66649 m
.39056 .66067 L
s
.41032 .72427 m
.40934 .71629 L
s
.41546 .85528 m
.42241 .84282 L
s
.33338 .52873 m
.32021 .52869 L
s
.32963 .52201 m
.31588 .52229 L
s
.75559 .93833 m
.74924 .94713 L
s
.46287 .65972 m
.46058 .65451 L
s
.4154 .77202 m
.41697 .76241 L
s
.41614 .83802 m
.42185 .82615 L
s
.41432 .75452 m
.41492 .74551 L
s
.41144 .73573 m
.41104 .72738 L
s
.38476 .60207 m
.3778 .59844 L
s
.35252 .5694 m
.34237 .56762 L
s
.39983 .99022 m
.41924 .97338 L
s
.37782 .59502 m
.37022 .59176 L
s
.46146 .65884 m
.45912 .65363 L
s
.49642 .68417 m
.49524 .67903 L
s
.41314 .75012 m
.41351 .74128 L
s
.4161 .83246 m
.42142 .82081 L
s
.49307 .6816 m
.49179 .67643 L
s
.53519 .71533 m
.53479 .71072 L
s
.50459 .69057 m
.50361 .6855 L
s
.39102 1.04425 m
.41686 1.02565 L
s
.37892 .62746 m
.37262 .62325 L
s
.39709 .67609 m
.39356 .66995 L
s
.37218 .61192 m
.3649 .60835 L
s
.41517 .77626 m
.41698 .76654 L
s
.4133 .87609 m
.42186 .86301 L
s
.41509 .84925 m
.4216 .83706 L
s
.4109 .73247 m
.41032 .72427 L
s
.48577 .67632 m
.48427 .67112 L
s
.39857 .68036 m
.39527 .67406 L
s
.36587 .58129 m
.35705 .57877 L
s
.4104 .90619 m
.42147 .89214 L
s
.4263 .63545 m
.42229 .63057 L
s
.53148 .71236 m
.53101 .70767 L
s
.41641 .80069 m
.41966 .79014 L
s
.4065 .93886 m
.42059 .92376 L
s
.41544 .78558 m
.41778 .77556 L
s
.46691 .66286 m
.46476 .65764 L
s
.39926 .99024 m
.4187 .97349 L
s
.69383 .87328 m
.69107 .87641 L
s
.39014 .65674 m
.38553 .65138 L
s
.3567 .56891 m
.34682 .56703 L
s
.47821 .67097 m
.47647 .66575 L
s
.41588 .82625 m
.42078 .81487 L
s
.50688 .69265 m
.50593 .68759 L
s
.41556 .81673 m
.41984 .80568 L
s
.40237 .96707 m
.41932 .95111 L
s
.41517 .79292 m
.41795 .7827 L
s
.41141 .74429 m
.41144 .73573 L
s
.38393 .64189 m
.37845 .63717 L
s
.41441 .84784 m
.42083 .83578 L
s
.55991 .73713 m
.55969 .73311 L
s
.54844 .72715 m
.54814 .72281 L
s
.41504 .80742 m
.41872 .79673 L
s
.41105 .74089 m
.4109 .73247 L
s
.48586 .6768 m
.48434 .67159 L
s
.39056 .66067 m
.38613 .65524 L
s
.33493 .53741 m
.32225 .53722 L
s
.39527 .67406 m
.39159 .6681 L
s
.50233 .68938 m
.50126 .68426 L
s
.41359 .85898 m
.42083 .8466 L
s
.36161 .59188 m
.35295 .58928 L
s
.39356 .66995 m
.38964 .66417 L
s
.41232 .75913 m
.41314 .75012 L
s
.41324 .7637 m
.41432 .75452 L
s
.56113 .7384 m
.56089 .73439 L
s
.69909 .8785 m
.69597 .88198 L
s
.41196 .87392 m
.42037 .86109 L
s
.41445 .83596 m
.42003 .82437 L
s
.40993 .89645 m
.4202 .8829 L
s
.47222 .6672 m
.47024 .66198 L
s
.38163 .63848 m
.37591 .63397 L
s
.40365 .95055 m
.41894 .93527 L
s
.50174 .68903 m
.50064 .68391 L
s
.37846 .6308 m
.37228 .62661 L
s
.42178 .63337 m
.41752 .6286 L
s
.36161 .57794 m
.35242 .57573 L
s
.32262 .51337 m
.30797 .51434 L
s
.41353 .84992 m
.4201 .8379 L
s
.39962 .61674 m
.3939 .61253 L
s
.40495 .62111 m
.39962 .61674 L
s
.4133 .85256 m
.42007 .84046 L
s
.35412 .57765 m
.34443 .57574 L
s
.41328 .78175 m
.4154 .77202 L
s
.3939 .61253 m
.38777 .60855 L
s
.41124 .87923 m
.42007 .86629 L
s
.41092 .75303 m
.41141 .74429 L
s
.35701 .58387 m
.34775 .58171 L
s
.44201 .64706 m
.4388 .64201 L
s
.34995 .56946 m
.33965 .56793 L
s
.5523 .731 m
.55197 .72671 L
s
.41077 .74949 m
.41105 .74089 L
s
.41365 .81313 m
.4177 .80238 L
s
.3778 .59844 m
.37033 .59523 L
s
.3167 .50413 m
.30117 .50564 L
s
.47656 .67065 m
.47472 .66541 L
s
.44006 .64596 m
.43675 .64093 L
s
.35483 .58029 m
.3453 .57832 L
s
.41287 .84172 m
.41887 .83004 L
s
.40993 .6256 m
.40495 .62111 L
s
.28212 .43627 m
.26029 .44098 L
s
.42182 .80097 m
.42494 .79049 L
s
.69443 .87473 m
.69145 .87771 L
s
.41281 .78608 m
.41517 .77626 L
s
.39159 .6681 m
.38752 .6625 L
s
.33948 .54939 m
.32765 .54882 L
s
.74607 .92858 m
.74005 .93612 L
s
.38553 .65138 m
.38052 .64645 L
s
.5368 .71791 m
.5363 .71325 L
s
.36157 .57948 m
.35244 .57729 L
s
.47918 .67265 m
.47741 .66742 L
s
.34751 .56571 m
.33691 .56442 L
s
.75771 .9421 m
.75086 .95074 L
s
.41299 .82797 m
.41803 .81678 L
s
.40633 .91759 m
.4185 .90354 L
s
.40886 .89465 m
.419 .88133 L
s
.38964 .66417 m
.38534 .65876 L
s
.38777 .60855 m
.38119 .60484 L
s
.36421 .60155 m
.35611 .59871 L
s
.55082 .7301 m
.55044 .72574 L
s
.47504 .6699 m
.47313 .66467 L
s
.40188 .70363 m
.39973 .6967 L
s
.40366 .71084 m
.40188 .70363 L
s
.41249 .79566 m
.41544 .78558 L
s
.40505 .71829 m
.40366 .71084 L
s
.41099 .76828 m
.41232 .75913 L
s
.4004 .96268 m
.417 .94726 L
s
.38613 .65524 m
.38131 .65021 L
s
.39973 .6967 m
.39719 .69005 L
s
.39828 .6172 m
.39251 .61308 L
s
.40367 .6215 m
.39828 .6172 L
s
.41165 .773 m
.41324 .7637 L
s
.40604 .72598 m
.40505 .71829 L
s
.34032 .54822 m
.32853 .54771 L
s
.39718 .98299 m
.41597 .96699 L
s
.37022 .59176 m
.36208 .58902 L
s
.34188 .55625 m
.33052 .55548 L
s
.39251 .61308 m
.38632 .60918 L
s
.40997 .76193 m
.41092 .75303 L
s
.40437 .929 m
.41762 .91469 L
s
.72422 .90423 m
.7195 .90969 L
s
.41249 .81123 m
.41641 .80069 L
s
.41002 .75826 m
.41077 .74949 L
s
.43011 .64032 m
.4263 .63545 L
s
.39719 .69005 m
.39428 .68371 L
s
.47563 .67067 m
.47372 .66544 L
s
.83266 1.03333 m
.81924 1.05025 L
s
.37845 .63717 m
.37254 .63294 L
s
.36874 .61392 m
.36139 .61065 L
s
.41175 .80317 m
.41517 .79292 L
s
.37262 .62325 m
.36585 .6196 L
s
.70768 .88583 m
.7039 .88991 L
s
.36729 .61106 m
.35975 .60793 L
s
.4087 .62593 m
.40367 .6215 L
s
.4146 .63017 m
.40993 .6256 L
s
.40892 .87828 m
.41773 .86562 L
s
.32548 .52294 m
.31152 .52372 L
s
.40188 .94533 m
.41674 .93058 L
s
.40663 .73389 m
.40604 .72598 L
s
.40486 .91978 m
.41728 .90584 L
s
.75635 .94157 m
.74942 .94988 L
s
.33507 .54053 m
.32259 .54048 L
s
.72728 .90796 m
.72231 .91362 L
s
.32805 .52808 m
.31451 .52864 L
s
.35975 .59507 m
.35114 .59266 L
s
.32298 .51881 m
.30865 .51983 L
s
.33785 .54985 m
.32595 .54947 L
s
.44176 .64814 m
.43852 .64312 L
s
.38752 .6625 m
.38307 .65729 L
s
.40161 .94393 m
.41635 .92928 L
s
.32759 .52984 m
.31409 .53041 L
s
.4007 .94997 m
.41605 .93516 L
s
.50773 .69511 m
.50667 .68998 L
s
.51785 .70311 m
.51698 .69809 L
s
.35387 .58322 m
.34442 .58136 L
s
.39428 .68371 m
.391 .67769 L
s
.40784 .8862 m
.41731 .87337 L
s
.36341 .60294 m
.35533 .60021 L
s
.38632 .60918 m
.37969 .60559 L
s
.40423 .92114 m
.41678 .90723 L
s
.4106 .79154 m
.41328 .78175 L
s
.40102 .70776 m
.39903 .70082 L
s
.40263 .71496 m
.40102 .70776 L
s
.31031 .49633 m
.29394 .49851 L
s
.31537 .50629 m
.29987 .508 L
s
.42581 .63815 m
.42178 .63337 L
s
.54081 .72229 m
.54025 .71764 L
s
.70281 .88361 m
.69918 .88708 L
s
.38119 .60484 m
.37414 .6015 L
s
.39903 .70082 m
.39667 .69415 L
s
.4505 .65406 m
.44763 .64895 L
s
.40384 .7224 m
.40263 .71496 L
s
.52807 .71162 m
.52735 .70673 L
s
.54966 .73024 m
.54917 .72576 L
s
.41066 .81804 m
.41504 .80742 L
s
.41053 .82766 m
.41556 .81673 L
s
.37591 .63397 m
.36975 .62998 L
s
.4068 .742 m
.40663 .73389 L
s
.38534 .65876 m
.38064 .65376 L
s
.47424 .67023 m
.47226 .665 L
s
.40839 .87088 m
.41663 .85859 L
s
.40991 .8439 m
.4161 .83246 L
s
.3649 .60835 m
.35713 .60545 L
s
.51558 .70149 m
.51465 .69644 L
s
.50921 .69645 m
.50815 .69133 L
s
.40953 .84963 m
.41614 .83802 L
s
.39667 .69415 m
.39393 .68779 L
s
.38052 .64645 m
.3751 .64198 L
s
.40466 .73007 m
.40384 .7224 L
s
.40916 .77753 m
.41099 .76828 L
s
.4954 .68585 m
.49402 .68064 L
s
.40827 .87148 m
.41655 .8592 L
s
.56741 .74635 m
.56699 .74233 L
s
.41017 .83745 m
.41588 .82625 L
s
.40985 .79593 m
.41281 .78608 L
s
.55838 .73821 m
.55792 .73393 L
s
.41342 .63044 m
.4087 .62593 L
s
.37228 .62661 m
.36564 .62298 L
s
.40852 .77094 m
.40997 .76193 L
s
.38886 1.02508 m
.41265 1.00811 L
s
.74646 .93099 m
.74008 .93818 L
s
.47343 .6699 m
.47141 .66466 L
s
.4088 .76716 m
.41002 .75826 L
s
.46732 .66571 m
.46509 .66049 L
s
.3441 .56547 m
.3333 .56454 L
s
.38131 .65021 m
.37609 .64563 L
s
.72116 .90182 m
.71641 .9068 L
s
.4067 .88565 m
.41615 .87298 L
s
.391 .67769 m
.38734 .67201 L
s
.40954 .78238 m
.41165 .773 L
s
.38098 1.07172 m
.41078 1.0533 L
s
.37033 .59523 m
.36234 .59253 L
s
.40607 .88845 m
.41577 .87572 L
s
.39393 .68779 m
.39082 .68174 L
s
.40507 .73794 m
.40466 .73007 L
s
.35705 .57877 m
.34764 .57698 L
s
.77465 .96387 m
.7661 .97376 L
s
.40501 .89825 m
.41555 .88525 L
s
.40653 .75028 m
.4068 .742 L
s
.40748 .86733 m
.41546 .85528 L
s
.54617 .72776 m
.54559 .72316 L
s
.52082 .70623 m
.51993 .70121 L
s
.51603 .70248 m
.51506 .6974 L
s
.40117 .93235 m
.41485 .91834 L
s
.41899 .63479 m
.4146 .63017 L
s
.4076 .86107 m
.41509 .84925 L
s
.55463 .73493 m
.55409 .73054 L
s
.41808 .81143 m
.42182 .80097 L
s
.40891 .80572 m
.41249 .79566 L
s
.40887 .82376 m
.41365 .81313 L
s
.56848 .74784 m
.56799 .7438 L
s
.54368 .72551 m
.54306 .72085 L
s
.38307 .65729 m
.37822 .65251 L
s
.37969 .60559 m
.37259 .60236 L
s
.56299 .74289 m
.56248 .73868 L
s
.39527 .97459 m
.41329 .95936 L
s
.4027 .9135 m
.41462 .90014 L
s
.52483 .70995 m
.52397 .70496 L
s
.76229 .94965 m
.7546 .9582 L
s
.39466 .97724 m
.41299 .96197 L
s
.46787 .6667 m
.46563 .66148 L
s
.40505 .74599 m
.40507 .73794 L
s
.40703 .85953 m
.41441 .84784 L
s
.71677 .89751 m
.71215 .90199 L
s
.39082 .68174 m
.38735 .67602 L
s
.40801 .84729 m
.41445 .83596 L
s
.33219 .54072 m
.31954 .541 L
s
.4652 .66493 m
.46287 .65972 L
s
.71372 .89586 m
.70926 .89999 L
s
.46385 .66404 m
.46146 .65884 L
s
.39685 .95961 m
.4133 .94491 L
s
.75644 .94298 m
.74916 .95092 L
s
.38734 .67201 m
.3833 .66671 L
s
.39761 .95273 m
.41335 .93826 L
s
.33454 .54544 m
.32227 .54552 L
s
.31624 .51221 m
.30113 .51395 L
s
.38064 .65376 m
.37555 .64921 L
s
.37254 .63294 m
.3662 .62925 L
s
.49502 .68652 m
.49356 .68128 L
s
.40581 .7587 m
.40653 .75028 L
s
.37414 .6015 m
.3666 .59861 L
s
.40767 .81334 m
.41175 .80317 L
s
.48169 .67676 m
.47987 .6715 L
s
.40707 .77614 m
.4088 .76716 L
s
.40655 .78003 m
.40852 .77094 L
s
.40713 .83893 m
.41299 .82797 L
s
.44514 .65208 m
.44201 .64706 L
s
.41786 .63501 m
.41342 .63044 L
s
.4073 .8013 m
.4106 .79154 L
s
.40677 .78683 m
.40916 .77753 L
s
.44327 .65096 m
.44006 .64596 L
s
.40786 .82165 m
.41249 .81123 L
s
.52458 .71017 m
.52368 .70515 L
s
.53901 .72213 m
.53828 .71733 L
s
.32743 .53674 m
.31426 .53742 L
s
.34682 .56703 m
.33631 .56608 L
s
.35295 .58928 m
.34374 .58755 L
s
.33725 .55662 m
.32565 .55638 L
s
.46913 .66809 m
.46691 .66286 L
s
.35242 .57573 m
.34262 .57434 L
s
.43374 .64518 m
.43011 .64032 L
s
.40598 .86154 m
.41353 .84992 L
s
.40246 .90172 m
.41337 .8889 L
s
.4053 .87088 m
.41359 .85898 L
s
.32318 .52874 m
.30935 .52984 L
s
.30355 .48953 m
.28636 .4925 L
s
.40459 .75419 m
.40505 .74599 L
s
.40596 .85305 m
.41287 .84172 L
s
.34237 .56762 m
.33158 .5669 L
s
.40207 .90488 m
.41326 .89197 L
s
.36208 .58902 m
.35339 .58692 L
s
.40354 .88849 m
.4133 .87609 L
s
.49577 .68748 m
.4943 .68223 L
s
.30325 .48918 m
.28602 .49218 L
s
.39668 .952 m
.41239 .93772 L
s
.52432 .71004 m
.5234 .705 L
s
.38735 .67602 m
.3835 .67068 L
s
.40554 .86423 m
.4133 .85256 L
s
.3751 .64198 m
.36927 .63802 L
s
.71018 .89282 m
.70578 .89651 L
s
.36585 .6196 m
.35863 .6166 L
s
.40686 .79178 m
.40954 .78238 L
s
.3292 .53854 m
.31626 .53914 L
s
.42964 .64294 m
.42581 .63815 L
s
.39782 .93964 m
.4123 .92578 L
s
.37609 .64563 m
.37046 .64155 L
s
.77102 .9609 m
.76244 .97006 L
s
.40627 .80572 m
.40985 .79593 L
s
.36975 .62998 m
.36317 .62657 L
s
.27172 .42752 m
.24856 .4336 L
s
.51741 .70477 m
.51636 .69964 L
s
.35611 .59871 m
.34748 .59668 L
s
.35244 .57729 m
.34271 .57592 L
s
.48012 .67624 m
.47821 .67097 L
s
.36139 .61065 m
.35356 .60809 L
s
.32312 .5304 m
.30937 .53153 L
s
.48747 .6816 m
.48577 .67632 L
s
.49459 .68686 m
.49307 .6816 L
s
.39876 .92897 m
.41221 .91548 L
s
.49786 .68943 m
.49642 .68417 L
s
.3833 .66671 m
.3789 .66182 L
s
.37822 .65251 m
.37299 .64819 L
s
.40462 .76722 m
.40581 .7587 L
s
.53602 .72022 m
.53519 .71533 L
s
.56059 .7415 m
.55991 .73713 L
s
.40553 .82848 m
.41066 .81804 L
s
.37259 .60236 m
.36501 .5996 L
s
.77029 .96038 m
.76168 .96939 L
s
.35975 .60793 m
.35172 .60554 L
s
.34775 .58171 m
.33792 .58048 L
s
.42314 .63943 m
.41899 .63479 L
s
.50588 .6958 m
.50459 .69057 L
s
.40237 .88608 m
.41196 .87392 L
s
.31981 .52493 m
.30557 .5264 L
s
.56182 .74276 m
.56113 .7384 L
s
.53237 .71732 m
.53148 .71236 L
s
.40368 .76251 m
.40459 .75419 L
s
.47431 .67246 m
.47222 .6672 L
s
.36564 .62298 m
.35857 .61998 L
s
.34443 .57574 m
.33414 .57485 L
s
.40469 .83833 m
.41053 .82766 L
s
.5492 .73182 m
.54844 .72715 L
s
.48758 .68208 m
.48586 .6768 L
s
.44492 .65314 m
.44176 .64814 L
s
.3835 .67068 m
.37928 .66572 L
s
.4048 .78515 m
.40707 .77614 L
s
.50815 .69788 m
.50688 .69265 L
s
.3453 .57832 m
.33518 .57735 L
s
.40467 .81566 m
.40891 .80572 L
s
.39492 .95056 m
.41057 .93662 L
s
.37555 .64921 m
.37007 .64516 L
s
.40402 .78913 m
.40655 .78003 L
s
.30898 .50496 m
.293 .50749 L
s
.36234 .59253 m
.35382 .59046 L
s
.40118 .89143 m
.41124 .87923 L
s
.35533 .60021 m
.34674 .59828 L
s
.7664 .95649 m
.75795 .96493 L
s
.40381 .7961 m
.40677 .78683 L
s
.76144 .95087 m
.75336 .95882 L
s
.50371 .69464 m
.50233 .68938 L
s
.35713 .60545 m
.34887 .60332 L
s
.41368 .82179 m
.41808 .81143 L
s
.42207 .6396 m
.41786 .63501 L
s
.33965 .56793 m
.32873 .56752 L
s
.47856 .67592 m
.47656 .67065 L
s
.31992 .52608 m
.30578 .52761 L
s
.39782 .91911 m
.4104 .90619 L
s
.35114 .59266 m
.34199 .59112 L
s
.55308 .73562 m
.5523 .731 L
s
.40359 .84831 m
.41017 .83745 L
s
.40281 .85494 m
.40991 .8439 L
s
.37796 1.0601 m
.40656 1.04308 L
s
.50314 .6943 m
.50174 .68903 L
s
.70004 .881 m
.69596 .88375 L
s
.3666 .59861 m
.35856 .59627 L
s
.40332 .83414 m
.40887 .82376 L
s
.73256 .91763 m
.72648 .92291 L
s
.40294 .7758 m
.40462 .76722 L
s
.48112 .67794 m
.47918 .67265 L
s
.40337 .81096 m
.4073 .8013 L
s
.3789 .66182 m
.37411 .65736 L
s
.39827 .90901 m
.40993 .89645 L
s
.45334 .65915 m
.4505 .65406 L
s
.47709 .67518 m
.47504 .6699 L
s
.40197 .86077 m
.40953 .84963 L
s
.39092 .97122 m
.4088 .9569 L
s
.70928 .89147 m
.70463 .89486 L
s
.39087 .61967 m
.38481 .61602 L
s
.39655 .62354 m
.39087 .61967 L
s
.3662 .62925 m
.35944 .62619 L
s
.71818 .90148 m
.71299 .90555 L
s
.40229 .77091 m
.40368 .76251 L
s
.40359 .80112 m
.40686 .79178 L
s
.40289 .82333 m
.40767 .81334 L
s
.33691 .56442 m
.32567 .56429 L
s
.40188 .62758 m
.39655 .62354 L
s
.55167 .73479 m
.55082 .7301 L
s
.32021 .52869 m
.30622 .53023 L
s
.36927 .63802 m
.36303 .63462 L
s
.53775 .72287 m
.5368 .71791 L
s
.39436 .94012 m
.40902 .92677 L
s
.76861 .95997 m
.7598 .96844 L
s
.37046 .64155 m
.36444 .63802 L
s
.37299 .64819 m
.36737 .64439 L
s
.38481 .61602 m
.37835 .61267 L
s
.37928 .66572 m
.37469 .6612 L
s
.34442 .58136 m
.3344 .58051 L
s
.70085 .88247 m
.69661 .88516 L
s
.31712 .52528 m
.30274 .5271 L
s
.4777 .67596 m
.47563 .67067 L
s
.3989 .89014 m
.40892 .87828 L
s
.40248 .83182 m
.40786 .82165 L
s
.40203 .81537 m
.40627 .80572 L
s
.73166 .91802 m
.72549 .92303 L
s
.70768 .89023 m
.70301 .89338 L
s
.39132 .95926 m
.40798 .94547 L
s
.39735 .90697 m
.40886 .89465 L
s
.30874 .50861 m
.29295 .51128 L
s
.31588 .52229 m
.30129 .52427 L
s
.38686 .99091 m
.40701 .97626 L
s
.34764 .57698 m
.33765 .57609 L
s
.39902 .88246 m
.40839 .87088 L
s
.40198 .79413 m
.4048 .78515 L
s
.40688 .63174 m
.40188 .62758 L
s
.32225 .53722 m
.30881 .53856 L
s
.36501 .5996 m
.35693 .59741 L
s
.43726 .65003 m
.43374 .64518 L
s
.5683 .75072 m
.56741 .74635 L
s
.40064 .85814 m
.40801 .84729 L
s
.40093 .79816 m
.40402 .78913 L
s
.36317 .62657 m
.35616 .62381 L
s
.43332 .64771 m
.42964 .64294 L
s
.39886 .88304 m
.40827 .87148 L
s
.77394 .96689 m
.76456 .97572 L
s
.32765 .54882 m
.31512 .54964 L
s
.42711 .64409 m
.42314 .63943 L
s
.39131 .95335 m
.40738 .93985 L
s
.40041 .84949 m
.40713 .83893 L
s
.69107 .87641 m
.6872 .87806 L
s
.47638 .67552 m
.47424 .67023 L
s
.39906 .87227 m
.4076 .86107 L
s
.28562 .46489 m
.26577 .46988 L
s
.37007 .64516 m
.3642 .64165 L
s
.35863 .6166 m
.35096 .61432 L
s
.37835 .61267 m
.37145 .60968 L
s
.46966 .67095 m
.46732 .66571 L
s
.33052 .55548 m
.31848 .55603 L
s
.39711 .89812 m
.40784 .8862 L
s
.39841 .87869 m
.40748 .86733 L
s
.40074 .78438 m
.40294 .7758 L
s
.75464 .94436 m
.74671 .95128 L
s
.40041 .77932 m
.40229 .77091 L
s
.55061 .73505 m
.54966 .73024 L
s
.30192 .49821 m
.2851 .50159 L
s
.35339 .58692 m
.34417 .58559 L
s
.32853 .54771 m
.31602 .54853 L
s
.55932 .74283 m
.55838 .73821 L
s
.44642 .65594 m
.44327 .65096 L
s
.4756 .67518 m
.47343 .6699 L
s
.40024 .80526 m
.40381 .7961 L
s
.44822 .65709 m
.44514 .65208 L
s
.39862 .87061 m
.40703 .85953 L
s
.37411 .65736 m
.36896 .65339 L
s
.54183 .72726 m
.54081 .72229 L
s
.73742 .92527 m
.73069 .93059 L
s
.56943 .75223 m
.56848 .74784 L
s
.50915 .70043 m
.50773 .69511 L
s
.39051 .95217 m
.4065 .93886 L
s
.51912 .70836 m
.51785 .70311 L
s
.39962 .83858 m
.40553 .82848 L
s
.79738 .99556 m
.78584 1.00666 L
s
.39971 .82535 m
.40467 .81566 L
s
.52922 .71678 m
.52807 .71162 L
s
.42608 .64421 m
.42207 .6396 L
s
.37469 .6612 m
.36975 .65715 L
s
.73088 .91828 m
.72453 .92297 L
s
.56397 .74744 m
.56299 .74289 L
s
.39253 .93021 m
.40633 .91759 L
s
.49707 .69121 m
.4954 .68585 L
s
.39599 .89738 m
.4067 .88565 L
s
.51689 .70677 m
.51558 .70149 L
s
.35356 .60809 m
.34526 .60634 L
s
.39809 .86382 m
.40596 .85305 L
s
.51062 .70177 m
.50921 .69645 L
s
.35857 .61998 m
.35105 .61771 L
s
.46632 .66925 m
.46385 .66404 L
s
.41161 .63599 m
.40688 .63174 L
s
.46763 .67016 m
.4652 .66493 L
s
.47023 .67195 m
.46787 .6667 L
s
.55564 .73968 m
.55463 .73493 L
s
.3333 .56454 m
.32187 .56485 L
s
.32595 .54947 m
.31335 .55051 L
s
.39509 .90019 m
.40607 .88845 L
s
.39969 .81031 m
.40359 .80112 L
s
.54722 .73269 m
.54617 .72776 L
s
.78741 .98401 m
.77664 .99392 L
s
.39741 .8725 m
.40598 .86154 L
s
.39875 .8204 m
.40337 .81096 L
s
.34374 .58755 m
.33399 .58681 L
s
.35172 .60554 m
.34322 .60398 L
s
.34262 .57434 m
.33223 .57395 L
s
.398 .84857 m
.40469 .83833 L
s
.32259 .54048 m
.30936 .54192 L
s
.28122 .46024 m
.26078 .46578 L
s
.35856 .59627 m
.35002 .5946 L
s
.35382 .59046 m
.34478 .58915 L
s
.36737 .64439 m
.36136 .64115 L
s
.40857 .83192 m
.41368 .82179 L
s
.34748 .59668 m
.33835 .59556 L
s
.69145 .87771 m
.68733 .87917 L
s
.54477 .73049 m
.54368 .72551 L
s
.39673 .8752 m
.40554 .86423 L
s
.69597 .88198 m
.69161 .88378 L
s
.39139 .62382 m
.38549 .62026 L
s
.39695 .62759 m
.39139 .62382 L
s
.37145 .60968 m
.36411 .60715 L
s
.52212 .71151 m
.52082 .70623 L
s
.76708 .96012 m
.75792 .9679 L
s
.51739 .70779 m
.51603 .70248 L
s
.36444 .63802 m
.35802 .63511 L
s
.38549 .62026 m
.3792 .61697 L
s
.76811 .9615 m
.75885 .96937 L
s
.39591 .882 m
.4053 .87088 L
s
.38457 .9835 m
.40405 .96965 L
s
.39858 .80299 m
.40198 .79413 L
s
.36303 .63462 m
.3564 .63187 L
s
.71018 .89486 m
.705 .89779 L
s
.39081 .93223 m
.40486 .91978 L
s
.39309 .9101 m
.40501 .89825 L
s
.30797 .51434 m
.29246 .51723 L
s
.35944 .62619 m
.35226 .62382 L
s
.34271 .57592 m
.3324 .57554 L
s
.39801 .7877 m
.40041 .77932 L
s
.47148 .67335 m
.46913 .66809 L
s
.44804 .65813 m
.44492 .65314 L
s
.33631 .56608 m
.32517 .56627 L
s
.398 .7929 m
.40074 .78438 L
s
.39735 .83299 m
.40289 .82333 L
s
.5261 .71522 m
.52483 .70995 L
s
.48372 .68211 m
.48169 .67676 L
s
.39723 .80705 m
.40093 .79816 L
s
.39695 .8441 m
.40332 .83414 L
s
.40217 .63152 m
.39695 .62759 L
s
.38936 .94163 m
.40437 .929 L
s
.39709 .82475 m
.40203 .81537 L
s
.83721 1.04626 m
.82148 1.06163 L
s
.39003 .93351 m
.40423 .92114 L
s
.38631 .96371 m
.40365 .95055 L
s
.3792 .61697 m
.3725 .61403 L
s
.49677 .69192 m
.49502 .68652 L
s
.34887 .60332 m
.34013 .60207 L
s
.36896 .65339 m
.36345 .64996 L
s
.31451 .52864 m
.30018 .53093 L
s
.34674 .59828 m
.33766 .59727 L
s
.5402 .72724 m
.53901 .72213 L
s
.3961 .8586 m
.40359 .84831 L
s
.72778 .91534 m
.72135 .91949 L
s
.3642 .64165 m
.35795 .63875 L
s
.31409 .53041 m
.29981 .53272 L
s
.31152 .52372 m
.29674 .52632 L
s
.52591 .71548 m
.52458 .71017 L
s
.36975 .65715 m
.36444 .65361 L
s
.39251 .89985 m
.40354 .88849 L
s
.35693 .59741 m
.34837 .59591 L
s
.74436 .9349 m
.73673 .94038 L
s
.33158 .5669 m
.32018 .56744 L
s
.33792 .58048 m
.32754 .58038 L
s
.56174 .74624 m
.56059 .7415 L
s
.39604 .81421 m
.40024 .80526 L
s
.4161 .6403 m
.41161 .63599 L
s
.39475 .86533 m
.40281 .85494 L
s
.39631 .84157 m
.40248 .83182 L
s
.49753 .69289 m
.49577 .68748 L
s
.38313 .98051 m
.40237 .96707 L
s
.48223 .6816 m
.48012 .67624 L
s
.56299 .74747 m
.56182 .74276 L
s
.72002 .90685 m
.71402 .91032 L
s
.43093 .64875 m
.42711 .64409 L
s
.52568 .71535 m
.52432 .71004 L
s
.30117 .50564 m
.28473 .50928 L
s
.77466 .97038 m
.7646 .97858 L
s
.35616 .62381 m
.34873 .6218 L
s
.40711 .63556 m
.40217 .63152 L
s
.30865 .51983 m
.29348 .52274 L
s
.48942 .68699 m
.48747 .6816 L
s
.34199 .59112 m
.33234 .59061 L
s
.32227 .54552 m
.3093 .54709 L
s
.38923 .92541 m
.4027 .9135 L
s
.47658 .67778 m
.47431 .67246 L
s
.32565 .55638 m
.3134 .55755 L
s
.4964 .69228 m
.49459 .68686 L
s
.73367 .92269 m
.7267 .92717 L
s
.31954 .541 m
.30617 .54284 L
s
.79573 .99584 m
.78378 1.00613 L
s
.4369 .65249 m
.43332 .64771 L
s
.39016 .91327 m
.40246 .90172 L
s
.33414 .57485 m
.32328 .57515 L
s
.39155 .89719 m
.40237 .88608 L
s
.3934 .87118 m
.40197 .86077 L
s
.45622 .66424 m
.45334 .65915 L
s
.49962 .69486 m
.49786 .68943 L
s
.51888 .71016 m
.51741 .70477 L
s
.33518 .57735 m
.3245 .57755 L
s
.53732 .72544 m
.53602 .72022 L
s
.3725 .61403 m
.36539 .61151 L
s
.38507 .95801 m
.40188 .94533 L
s
.44069 .65487 m
.43726 .65003 L
s
.55045 .73685 m
.5492 .73182 L
s
.74833 .9398 m
.74025 .94546 L
s
.38944 .91644 m
.40207 .90488 L
s
.36411 .60715 m
.35633 .60518 L
s
.38494 .95652 m
.40161 .94393 L
s
.39506 .79597 m
.39801 .7877 L
s
.50752 .70124 m
.50588 .6958 L
s
.39515 .81924 m
.39969 .81031 L
s
.42995 .64883 m
.42608 .64421 L
s
.26136 .42722 m
.2374 .43502 L
s
.35096 .61432 m
.34285 .61286 L
s
.53371 .7226 m
.53237 .71732 L
s
.48957 .68749 m
.48758 .68208 L
s
.39401 .83466 m
.39971 .82535 L
s
.3947 .80126 m
.398 .7929 L
s
.36136 .64115 m
.35499 .63856 L
s
.55436 .74061 m
.55308 .73562 L
s
.39457 .81163 m
.39858 .80299 L
s
.39278 .85942 m
.40041 .84949 L
s
.74747 .93959 m
.73935 .94505 L
s
.48077 .68128 m
.47856 .67592 L
s
.38573 .94452 m
.40117 .93235 L
s
.38333 .96257 m
.4007 .94997 L
s
.50979 .70333 m
.50815 .69788 L
s
.39343 .82948 m
.39875 .8204 L
s
.7727 .96902 m
.76257 .97677 L
s
.37775 1.00388 m
.39983 .99022 L
s
.69918 .88708 m
.69421 .88867 L
s
.38161 .9756 m
.4004 .96268 L
s
.38984 .90248 m
.40118 .89143 L
s
.39288 .84816 m
.39962 .83858 L
s
.7039 .88991 m
.69866 .89194 L
s
.39229 .86827 m
.40064 .85814 L
s
.47935 .68054 m
.47709 .67518 L
s
.34417 .58559 m
.33441 .58519 L
s
.48328 .68333 m
.48112 .67794 L
s
.32873 .56752 m
.31723 .56842 L
s
.29987 .508 m
.28348 .51189 L
s
.35105 .61771 m
.34312 .61625 L
s
.35802 .63511 m
.35122 .63288 L
s
.3929 .81567 m
.39723 .80705 L
s
.31426 .53742 m
.30038 .53983 L
s
.50544 .70011 m
.50371 .69464 L
s
.33765 .57609 m
.32709 .57627 L
s
.37716 1.00378 m
.39926 .99024 L
s
.31626 .53914 m
.30261 .54138 L
s
.76464 .95989 m
.75509 .96678 L
s
.44956 .66093 m
.44642 .65594 L
s
.36345 .64996 m
.35758 .64711 L
s
.26995 .44769 m
.24794 .45469 L
s
.4118 .63969 m
.40711 .63556 L
s
.55301 .73985 m
.55167 .73479 L
s
.3344 .58051 m
.32385 .58083 L
s
.3564 .63187 m
.34938 .62982 L
s
.77496 .97215 m
.76453 .98 L
s
.5049 .69978 m
.50314 .6943 L
s
.4513 .66211 m
.44822 .65709 L
s
.56966 .75545 m
.5683 .75072 L
s
.36444 .65361 m
.35879 .65065 L
s
.35002 .5946 m
.34099 .59373 L
s
.40272 .84166 m
.40857 .83192 L
s
.47996 .68133 m
.4777 .67596 L
s
.34526 .60634 m
.33652 .60552 L
s
.42039 .64465 m
.4161 .6403 L
s
.74523 .93786 m
.73709 .94292 L
s
.53917 .72817 m
.53775 .72287 L
s
.35226 .62382 m
.34468 .62223 L
s
.36539 .61151 m
.35785 .60952 L
s
.36523 1.0757 m
.39674 1.06045 L
s
.30935 .52984 m
.29476 .53279 L
s
.29394 .49851 m
.27664 .50308 L
s
.38945 .88253 m
.39906 .87227 L
s
.35795 .63875 m
.35133 .63652 L
s
.39143 .8337 m
.39709 .82475 L
s
.32567 .56429 m
.31384 .56556 L
s
.38848 .89297 m
.39902 .88246 L
s
.57085 .75699 m
.56943 .75223 L
s
.39105 .84215 m
.39735 .83299 L
s
.34478 .58915 m
.33524 .58874 L
s
.39043 .85815 m
.398 .84857 L
s
.7365 .92827 m
.72893 .93252 L
s
.39118 .82282 m
.39604 .81421 L
s
.38915 .88077 m
.39862 .87061 L
s
.38764 .90082 m
.3989 .89014 L
s
.34322 .60398 m
.33427 .60339 L
s
.47215 .67625 m
.46966 .67095 L
s
.38827 .8935 m
.39886 .88304 L
s
.38361 .94062 m
.39876 .92897 L
s
.37016 1.03974 m
.39687 1.02561 L
s
.56074 .74784 m
.55932 .74283 L
s
.30937 .53153 m
.29488 .53451 L
s
.38921 .87375 m
.39809 .86382 L
s
.38821 .88901 m
.39841 .87869 L
s
.47871 .68089 m
.47638 .67552 L
s
.30113 .51395 m
.28518 .51782 L
s
.39156 .80404 m
.39506 .79597 L
s
.38515 .92005 m
.39827 .90901 L
s
.38974 .85343 m
.39695 .8441 L
s
.55207 .74023 m
.55061 .73505 L
s
.56544 .75238 m
.56397 .74744 L
s
.47797 .68055 m
.4756 .67518 L
s
.37588 .99587 m
.39718 .98299 L
s
.3815 .95142 m
.39782 .93964 L
s
.37984 .96483 m
.39761 .95273 L
s
.34837 .59591 m
.33932 .59523 L
s
.38367 .93034 m
.39782 .91911 L
s
.35633 .60518 m
.34809 .60387 L
s
.33835 .59556 m
.32876 .59551 L
s
.39082 .80939 m
.3947 .80126 L
s
.76272 .95907 m
.75299 .96542 L
s
.46893 .67453 m
.46632 .66925 L
s
.43465 .65341 m
.43093 .64875 L
s
.54334 .73259 m
.54183 .72726 L
s
.47022 .67545 m
.46763 .67016 L
s
.45118 .66313 m
.44804 .65813 L
s
.38776 .88249 m
.39741 .8725 L
s
.30557 .5264 m
.29058 .52983 L
s
.33399 .58681 m
.32374 .58724 L
s
.79033 .99205 m
.77819 1.00101 L
s
.47275 .67727 m
.47023 .67195 L
s
.55715 .7448 m
.55564 .73968 L
s
.37829 .97174 m
.39685 .95961 L
s
.38933 .85071 m
.39631 .84157 L
s
.38443 .91779 m
.39735 .90697 L
s
.34873 .6218 m
.34092 .62062 L
s
.38993 .82776 m
.39515 .81924 L
s
.33223 .57395 m
.3213 .57474 L
s
.38993 .81993 m
.39457 .81163 L
s
.38505 .90867 m
.39711 .89812 L
s
.41628 .64387 m
.4118 .63969 L
s
.37897 .96389 m
.39668 .952 L
s
.34013 .60207 m
.33095 .60184 L
s
.35499 .63856 m
.34826 .63667 L
s
.51095 .70599 m
.50915 .70043 L
s
.38683 .88515 m
.39673 .8752 L
s
.52081 .7139 m
.51912 .70836 L
s
.53084 .72227 m
.52922 .71678 L
s
.54877 .738 m
.54722 .73269 L
s
.38767 .86808 m
.3961 .8586 L
s
.3324 .57554 m
.32156 .57634 L
s
.49907 .69675 m
.49707 .69121 L
s
.7195 .90969 m
.7128 .91232 L
s
.30578 .52761 m
.29089 .53109 L
s
.73447 .92678 m
.72673 .93055 L
s
.35758 .64711 m
.35138 .64492 L
s
.33766 .59727 m
.32814 .59734 L
s
.43373 .65346 m
.42995 .64883 L
s
.35879 .65065 m
.35281 .64831 L
s
.31848 .55603 m
.30584 .55814 L
s
.51864 .71234 m
.51689 .70677 L
s
.44044 .65726 m
.4369 .65249 L
s
.51244 .70734 m
.51062 .70177 L
s
.38792 .82391 m
.3929 .81567 L
s
.38755 .84339 m
.39401 .83466 L
s
.54636 .73585 m
.54477 .73049 L
s
.31512 .54964 m
.30195 .55212 L
s
.38537 .89197 m
.39591 .882 L
s
.38399 .90773 m
.39599 .89738 L
s
.3749 .98683 m
.39527 .97459 L
s
.73626 .92907 m
.72834 .93293 L
s
.47402 .6787 m
.47148 .67335 L
s
.35785 .60952 m
.34988 .60815 L
s
.70926 .89999 m
.70314 .90175 L
s
.38738 .83804 m
.39343 .82948 L
s
.31602 .54853 m
.30288 .55098 L
s
.32187 .56485 m
.30989 .56662 L
s
.69596 .88375 m
.69063 .88465 L
s
.35122 .63288 m
.34407 .63143 L
s
.30622 .53023 m
.2915 .5337 L
s
.38569 .87479 m
.39475 .86533 L
s
.44411 .65972 m
.44069 .65487 L
s
.70578 .89651 m
.69983 .89797 L
s
.37396 .98943 m
.39466 .97724 L
s
.34285 .61286 m
.33435 .61236 L
s
.71215 .90199 m
.7058 .90396 L
s
.38278 .91048 m
.39509 .90019 L
s
.71641 .9068 m
.70979 .90907 L
s
.78108 .98202 m
.76949 .98974 L
s
.37732 .96207 m
.39492 .95056 L
s
.42453 .64903 m
.42039 .64465 L
s
.52387 .71709 m
.52212 .71151 L
s
.6872 .87806 m
.68229 .87818 L
s
.32517 .56627 m
.31348 .56782 L
s
.30881 .53856 m
.29468 .54175 L
s
.51919 .7134 m
.51739 .70779 L
s
.56341 .75135 m
.56174 .74624 L
s
.34938 .62982 m
.34201 .62859 L
s
.72231 .91362 m
.71527 .91629 L
s
.48601 .6876 m
.48372 .68211 L
s
.28636 .4925 m
.26824 .4981 L
s
.56467 .75257 m
.56299 .74747 L
s
.38749 .81181 m
.39156 .80404 L
s
.28602 .49218 m
.26786 .49784 L
s
.30274 .5271 m
.28763 .53096 L
s
.52785 .72081 m
.5261 .71522 L
s
.35133 .63652 m
.34437 .63506 L
s
.33234 .59061 m
.32223 .59128 L
s
.3779 .95125 m
.39436 .94012 L
s
.38529 .85699 m
.39288 .84816 L
s
.45919 .66938 m
.45622 .66424 L
s
.293 .50749 m
.27617 .51241 L
s
.34312 .61625 m
.33481 .61573 L
s
.32754 .58038 m
.31666 .58158 L
s
.54191 .73273 m
.5402 .72724 L
s
.69661 .88516 m
.6911 .88595 L
s
.38565 .83096 m
.39118 .82282 L
s
.3838 .88056 m
.3934 .87118 L
s
.49887 .69751 m
.49677 .69192 L
s
.31335 .55051 m
.30015 .55325 L
s
.26029 .44098 m
.23717 .44944 L
s
.38422 .86847 m
.39278 .85942 L
s
.30129 .52427 m
.28595 .52833 L
s
.76726 .96644 m
.75667 .97265 L
s
.38503 .84207 m
.39143 .8337 L
s
.38635 .81716 m
.39082 .80939 L
s
.78419 .98661 m
.77212 .9944 L
s
.34099 .59373 m
.3315 .59381 L
s
.4846 .6871 m
.48223 .6816 L
s
.34468 .62223 m
.33674 .62154 L
s
.39611 .85084 m
.40272 .84166 L
s
.52771 .72111 m
.52591 .71548 L
s
.47908 .68322 m
.47658 .67778 L
s
.49965 .69851 m
.49753 .69289 L
s
.37975 .92029 m
.39309 .9101 L
s
.33441 .58519 m
.32418 .5859 L
s
.38395 .85061 m
.39105 .84215 L
s
.32018 .56744 m
.30826 .56947 L
s
.52751 .72099 m
.52568 .71535 L
s
.49168 .69257 m
.48942 .68699 L
s
.55221 .74227 m
.55045 .73685 L
s
.30936 .54192 m
.29549 .54517 L
s
.34809 .60387 m
.33943 .60336 L
s
.45276 .66594 m
.44956 .66093 L
s
.38018 .9097 m
.39251 .89985 L
s
.38296 .87738 m
.39229 .86827 L
s
.4206 .64809 m
.41628 .64387 L
s
.3245 .57755 m
.31333 .57912 L
s
.3615 1.05755 m
.39102 1.04425 L
s
.70463 .89486 m
.69848 .89601 L
s
.68733 .87917 m
.68216 .87904 L
s
.37709 .94077 m
.39253 .93021 L
s
.32328 .57515 m
.31193 .57686 L
s
.53912 .73103 m
.53732 .72544 L
s
.49857 .69791 m
.4964 .69228 L
s
.33652 .60552 m
.32738 .60577 L
s
.45446 .66716 m
.4513 .66211 L
s
.55617 .74599 m
.55436 .74061 L
s
.57153 .76057 m
.56966 .75545 L
s
.38464 .82777 m
.38993 .81993 L
s
.50175 .70052 m
.49962 .69486 L
s
.29295 .51128 m
.27637 .51631 L
s
.52079 .71586 m
.51888 .71016 L
s
.70301 .89338 m
.69688 .89435 L
s
.35281 .64831 m
.34652 .64668 L
s
.38403 .83574 m
.38993 .82776 L
s
.33524 .58874 m
.32522 .58941 L
s
.53556 .72824 m
.53371 .7226 L
s
.37947 .90682 m
.39155 .89719 L
s
.49187 .69309 m
.48957 .68749 L
s
.35138 .64492 m
.34486 .64346 L
s
.34826 .63667 m
.3412 .63558 L
s
.38195 .86681 m
.39043 .85815 L
s
.32709 .57627 m
.31603 .57774 L
s
.48324 .68679 m
.48077 .68128 L
s
.38234 .62983 m
.37622 .62707 L
s
.38813 .63286 m
.38234 .62983 L
s
.50958 .70695 m
.50752 .70124 L
s
.37262 .97028 m
.39132 .95926 L
s
.37328 .96423 m
.39131 .95335 L
s
.69161 .88378 m
.68609 .88383 L
s
.33932 .59523 m
.32984 .59553 L
s
.57279 .76213 m
.57085 .75699 L
s
.37622 .62707 m
.36977 .62464 L
s
.34988 .60815 m
.34151 .60754 L
s
.33427 .60339 m
.32493 .60391 L
s
.38167 .86191 m
.38974 .85343 L
s
.55488 .74531 m
.55301 .73985 L
s
.3708 .98246 m
.39092 .97122 L
s
.43834 .6581 m
.43465 .65341 L
s
.38229 .83161 m
.38792 .82391 L
s
.48187 .68604 m
.47935 .68054 L
s
.3134 .55755 m
.30059 .56039 L
s
.48573 .68888 m
.48328 .68333 L
s
.3751 .94251 m
.39081 .93223 L
s
.39364 .6361 m
.38813 .63286 L
s
.34092 .62062 m
.33275 .62039 L
s
.51185 .70907 m
.50979 .70333 L
s
.32385 .58083 m
.31284 .58253 L
s
.74005 .93612 m
.73125 .9396 L
s
.37258 .96287 m
.39051 .95217 L
s
.74924 .94713 m
.73971 .95132 L
s
.38151 .85902 m
.38933 .85071 L
s
.38284 .81916 m
.38749 .81181 L
s
.3093 .54709 m
.29572 .55045 L
s
.36977 .62464 m
.36296 .62263 L
s
.50757 .70585 m
.50544 .70011 L
s
.37643 .923 m
.39016 .91327 L
s
.5627 .75324 m
.56074 .74784 L
s
.4825 .68686 m
.47996 .68133 L
s
.37874 .89151 m
.38945 .88253 L
s
.37931 .88251 m
.38921 .87375 L
s
.71299 .90555 m
.70602 .90696 L
s
.37417 .94366 m
.39003 .93351 L
s
.56743 .75771 m
.56544 .75238 L
s
.34407 .63143 m
.33659 .63084 L
s
.43747 .65811 m
.43373 .65346 L
s
.31723 .56842 m
.30522 .57089 L
s
.36185 1.0373 m
.38886 1.02508 L
s
.50706 .70552 m
.5049 .69978 L
s
.37721 .9119 m
.38984 .90248 L
s
.3806 .84589 m
.38738 .83804 L
s
.3786 .88966 m
.38915 .88077 L
s
.54112 .73386 m
.53917 .72817 L
s
.38032 .85136 m
.38755 .84339 L
s
.30018 .53093 m
.28517 .5353 L
s
.42858 .65344 m
.42453 .64903 L
s
.37537 .92611 m
.38944 .91644 L
s
.45441 .66818 m
.45118 .66313 L
s
.30617 .54284 m
.29218 .54657 L
s
.2851 .50159 m
.26746 .50762 L
s
.47487 .68168 m
.47215 .67625 L
s
.32876 .59551 m
.31876 .5967 L
s
.37259 .95183 m
.38936 .94163 L
s
.37421 .93524 m
.38923 .92541 L
s
.29981 .53272 m
.28487 .53713 L
s
.39888 .63951 m
.39364 .6361 L
s
.55406 .74582 m
.55207 .74023 L
s
.44398 .66208 m
.44044 .65726 L
s
.34201 .62859 m
.33431 .62825 L
s
.38128 .82444 m
.38635 .81716 L
s
.34437 .63506 m
.3371 .63444 L
s
.33095 .60184 m
.32139 .60279 L
s
.48132 .68642 m
.47871 .68089 L
s
.29246 .51723 m
.2762 .52249 L
s
.37674 .90198 m
.38848 .89297 L
s
.37685 .8979 m
.38821 .88901 L
s
.37943 .83845 m
.38565 .83096 L
s
.29674 .52632 m
.28127 .53111 L
s
.48061 .68607 m
.47797 .68055 L
s
.47175 .67991 m
.46893 .67453 L
s
.37649 .90247 m
.38827 .8935 L
s
.55921 .75034 m
.55715 .7448 L
s
.36296 .62263 m
.3558 .62112 L
s
.37829 .87645 m
.38767 .86808 L
s
.47302 .68086 m
.47022 .67545 L
s
.32374 .58724 m
.31308 .58902 L
s
.33435 .61236 m
.32549 .61294 L
s
.37704 .89115 m
.38776 .88249 L
s
.31384 .56556 m
.30151 .56846 L
s
.44757 .66462 m
.44411 .65972 L
s
.32814 .59734 m
.31821 .59864 L
s
.37511 .90984 m
.38764 .90082 L
s
.5454 .73832 m
.54334 .73259 L
s
.47551 .68273 m
.47275 .67727 L
s
.78381 .98924 m
.77101 .99612 L
s
.3213 .57474 m
.30988 .57694 L
s
.705 .89779 m
.69828 .89838 L
s
.42481 .65236 m
.4206 .64809 L
s
.74008 .93818 m
.7309 .94124 L
s
.37788 .84963 m
.38503 .84207 L
s
.33481 .61573 m
.32615 .61626 L
s
.29348 .52274 m
.27762 .52796 L
s
.55086 .74372 m
.54877 .738 L
s
.36419 1.00178 m
.38686 .99091 L
s
.37583 .8937 m
.38683 .88515 L
s
.34652 .64668 m
.33995 .64581 L
s
.32156 .57634 m
.31024 .57853 L
s
.30261 .54138 m
.28835 .54561 L
s
.37685 .86484 m
.38529 .85699 L
s
.33674 .62154 m
.32847 .62186 L
s
.37872 .83497 m
.38464 .82777 L
s
.33943 .60336 m
.33037 .60379 L
s
.34486 .64346 m
.33807 .6428 L
s
.37564 .883 m
.38569 .87479 L
s
.30038 .53983 m
.28589 .5443 L
s
.75086 .95074 m
.74074 .95455 L
s
.4039 .64304 m
.39888 .63951 L
s
.53298 .72814 m
.53084 .72227 L
s
.56561 .75689 m
.56341 .75135 L
s
.38873 .85925 m
.39611 .85084 L
s
.5485 .74162 m
.54636 .73585 L
s
.5669 .75809 m
.56467 .75257 L
s
.52301 .7198 m
.52081 .7139 L
s
.51321 .71187 m
.51095 .70599 L
s
.36692 .97381 m
.38631 .96371 L
s
.69421 .88867 m
.68801 .88833 L
s
.4768 .6842 m
.47402 .6787 L
s
.3315 .59381 m
.32159 .59502 L
s
.3412 .63558 m
.33386 .63537 L
s
.37606 .85814 m
.38395 .85061 L
s
.50147 .70256 m
.49907 .69675 L
s
.37744 .84298 m
.38403 .83574 L
s
.72648 .92291 m
.71814 .92477 L
s
.34151 .60754 m
.33275 .60781 L
s
.52088 .71825 m
.51864 .71234 L
s
.51472 .71325 m
.51244 .70734 L
s
.24856 .4336 m
.22412 .44395 L
s
.36853 .95407 m
.38573 .94452 L
s
.28473 .50928 m
.26755 .51557 L
s
.37368 .9004 m
.38537 .89197 L
s
.74942 .94988 m
.73928 .95342 L
s
.3776 .82596 m
.38284 .81916 L
s
.376 .83862 m
.38229 .83161 L
s
.46232 .67462 m
.45919 .66938 L
s
.26577 .46988 m
.24492 .4783 L
s
.37474 .87633 m
.38422 .86847 L
s
.3558 .62112 m
.34829 .62023 L
s
.32223 .59128 m
.31172 .59332 L
s
.37059 .929 m
.38515 .92005 L
s
.37168 .91736 m
.38505 .90867 L
s
.69866 .89194 m
.69207 .89185 L
s
.3663 .96772 m
.38507 .95801 L
s
.36633 .96618 m
.38494 .95652 L
s
.72549 .92303 m
.71709 .92465 L
s
.48864 .6933 m
.48601 .6876 L
s
.37318 .88856 m
.3838 .88056 L
s
.36273 .99368 m
.38457 .9835 L
s
.52613 .72305 m
.52387 .71709 L
s
.29476 .53279 m
.27956 .538 L
s
.57393 .76609 m
.57153 .76057 L
s
.52148 .71937 m
.51919 .7134 L
s
.32418 .5859 m
.31351 .58791 L
s
.54416 .73864 m
.54191 .73273 L
s
.3701 .92654 m
.38443 .91779 L
s
.32738 .60577 m
.3179 .60724 L
s
.45607 .67105 m
.45276 .66594 L
s
.31348 .56782 m
.3013 .57097 L
s
.53013 .7268 m
.52785 .72081 L
s
.80804 1.02075 m
.79244 1.02947 L
s
.31666 .58158 m
.30537 .5843 L
s
.32984 .59553 m
.31995 .59698 L
s
.37069 .91621 m
.38399 .90773 L
s
.30989 .56662 m
.29743 .57012 L
s
.44205 .66284 m
.43834 .6581 L
s
.33275 .62039 m
.32428 .62123 L
s
.29488 .53451 m
.27979 .53974 L
s
.37561 .83109 m
.38128 .82444 L
s
.30584 .55814 m
.29271 .56211 L
s
.45775 .6723 m
.45446 .66716 L
s
.57525 .76768 m
.57279 .76213 L
s
.33659 .63084 m
.32884 .63122 L
s
.36797 .93921 m
.38367 .93034 L
s
.55454 .74812 m
.55221 .74227 L
s
.32522 .58941 m
.3148 .59134 L
s
.37264 .88513 m
.38296 .87738 L
s
.50138 .70339 m
.49887 .69751 L
s
.36678 .94966 m
.38361 .94062 L
s
.37259 .87427 m
.38195 .86681 L
s
.37275 .86925 m
.38167 .86191 L
s
.48731 .69281 m
.4846 .6871 L
s
.55854 .75181 m
.55617 .74599 L
s
.48188 .68885 m
.47908 .68322 L
s
.4326 .6579 m
.42858 .65344 L
s
.36397 .97202 m
.38333 .96257 L
s
.28348 .51189 m
.26639 .51844 L
s
.37308 .85283 m
.3806 .84589 L
s
.36161 .9903 m
.38313 .98051 L
s
.53004 .72714 m
.52771 .72111 L
s
.40873 .64668 m
.4039 .64304 L
s
.68229 .87818 m
.67644 .87676 L
s
.36916 .91881 m
.38278 .91048 L
s
.3371 .63444 m
.32957 .63477 L
s
.32493 .60391 m
.31524 .6057 L
s
.30195 .55212 m
.28828 .55658 L
s
.72453 .92297 m
.71595 .92426 L
s
.30288 .55098 m
.2892 .55537 L
s
.71402 .91032 m
.70619 .91093 L
s
.37287 .86623 m
.38151 .85902 L
s
.50219 .70443 m
.49965 .69851 L
s
.44123 .66283 m
.43747 .65811 L
s
.37232 .85833 m
.38032 .85136 L
s
.33431 .62825 m
.32633 .62893 L
s
.26078 .46578 m
.23934 .47498 L
s
.52988 .72704 m
.52751 .72099 L
s
.37255 .84511 m
.37943 .83845 L
s
.54148 .73705 m
.53912 .73103 L
s
.49433 .6984 m
.49168 .69257 L
s
.78875 .99803 m
.77478 1.00457 L
s
.74916 .95092 m
.73866 .95402 L
s
.55732 .75121 m
.55488 .74531 L
s
.31333 .57912 m
.30176 .5823 L
s
.29058 .52983 m
.27498 .53564 L
s
.50116 .70384 m
.49857 .69791 L
s
.28518 .51782 m
.26856 .52426 L
s
.56998 .76346 m
.56743 .75771 L
s
.34698 1.08315 m
.38098 1.07172 L
s
.33995 .64581 m
.33314 .6458 L
s
.31603 .57774 m
.30455 .58071 L
s
.31193 .57686 m
.30016 .58022 L
s
.69063 .88465 m
.68418 .8837 L
s
.53797 .73432 m
.53556 .72824 L
s
.34829 .62023 m
.34045 .62005 L
s
.56522 .75908 m
.5627 .75324 L
s
.52323 .72194 m
.52079 .71586 L
s
.50432 .70648 m
.50175 .70052 L
s
.36062 .98494 m
.38161 .9756 L
s
.73069 .93059 m
.7215 .93214 L
s
.42897 .65669 m
.42481 .65236 L
s
.36337 .96026 m
.3815 .95142 L
s
.30826 .56947 m
.2959 .57327 L
s
.48604 .69253 m
.48324 .68679 L
s
.49456 .69895 m
.49187 .69309 L
s
.4476 .66697 m
.44398 .66208 L
s
.72135 .91949 m
.71281 .92038 L
s
.33807 .6428 m
.33104 .64303 L
s
.29089 .53109 m
.2754 .53692 L
s
.37216 .84138 m
.37872 .83497 L
s
.51211 .713 m
.50958 .70695 L
s
.48471 .69176 m
.48187 .68604 L
s
.45779 .67334 m
.45441 .66818 L
s
.27664 .50308 m
.2586 .51057 L
s
.30015 .55325 m
.28645 .55802 L
s
.7546 .9582 m
.74344 .96149 L
s
.29468 .54175 m
.28003 .54716 L
s
.68216 .87904 m
.67607 .87736 L
s
.48854 .69467 m
.48573 .68888 L
s
.36658 .91753 m
.38018 .9097 L
s
.37001 .85619 m
.37788 .84963 L
s
.2915 .5337 m
.27621 .53949 L
s
.36842 .88976 m
.37931 .88251 L
s
.31284 .58253 m
.30144 .58582 L
s
.3718 .83206 m
.3776 .82596 L
s
.32139 .60279 m
.31151 .60508 L
s
.32549 .61294 m
.31635 .61473 L
s
.31876 .5967 m
.30843 .5993 L
s
.51441 .71517 m
.51185 .70907 L
s
.6911 .88595 m
.68445 .88485 L
s
.33037 .60379 m
.32096 .60532 L
s
.55662 .75187 m
.55406 .74582 L
s
.36502 .92821 m
.37975 .92029 L
s
.33386 .63537 m
.32628 .63615 L
s
.36615 .91446 m
.37947 .90682 L
s
.48538 .69261 m
.4825 .68686 L
s
.54365 .74 m
.54112 .73386 L
s
.32847 .62186 m
.31994 .6233 L
s
.36009 .97357 m
.37984 .96483 L
s
.32615 .61626 m
.31722 .61799 L
s
.45114 .66961 m
.44757 .66462 L
s
.51019 .71193 m
.50757 .70585 L
s
.36695 .89879 m
.37874 .89151 L
s
.33275 .60781 m
.32366 .60912 L
s
.56184 .75633 m
.55921 .75034 L
s
.37017 .8493 m
.37744 .84298 L
s
.47788 .68731 m
.47487 .68168 L
s
.36699 .89689 m
.3786 .88966 L
s
.36907 .84474 m
.376 .83862 L
s
.36798 .88339 m
.37829 .87645 L
s
.5097 .71161 m
.50706 .70552 L
s
.29549 .54517 m
.28111 .55058 L
s
.31821 .59864 m
.30798 .60135 L
s
.36759 .87142 m
.37685 .86484 L
s
.35929 .97242 m
.37897 .96389 L
s
.28763 .53096 m
.27195 .53729 L
s
.69983 .89797 m
.69248 .89713 L
s
.38057 .86665 m
.38873 .85925 L
s
.41344 .65041 m
.40873 .64668 L
s
.48426 .69218 m
.48132 .68642 L
s
.47485 .6855 m
.47175 .67991 L
s
.68609 .88383 m
.67955 .88213 L
s
.3674 .8645 m
.37606 .85814 L
s
.3455 1.07043 m
.37796 1.0601 L
s
.4761 .68647 m
.47302 .68086 L
s
.70314 .90175 m
.69552 .90105 L
s
.30059 .56039 m
.28735 .56522 L
s
.36936 .83695 m
.37561 .83109 L
s
.48358 .69183 m
.48061 .68607 L
s
.56969 .76405 m
.5669 .75809 L
s
.54804 .74452 m
.5454 .73832 L
s
.5684 .76287 m
.56561 .75689 L
s
.30522 .57089 m
.29281 .57517 L
s
.31308 .58902 m
.30208 .59237 L
s
.79575 1.0089 m
.78051 1.01541 L
s
.35765 .98027 m
.37829 .97174 L
s
.7267 .92717 m
.71741 .92802 L
s
.32159 .59502 m
.31134 .59753 L
s
.55355 .74991 m
.55086 .74372 L
s
.28595 .52833 m
.27004 .53491 L
s
.47858 .6884 m
.47551 .68273 L
s
.35967 .95933 m
.3779 .95125 L
s
.35304 1.01292 m
.37775 1.00388 L
s
.36438 .90492 m
.37685 .8979 L
s
.36526 .89808 m
.37704 .89115 L
s
.36385 .90904 m
.37674 .90198 L
s
.36331 .91917 m
.37721 .9119 L
s
.7661 .97376 m
.75349 .97747 L
s
.34045 .62005 m
.3323 .62071 L
s
.30988 .57694 m
.29808 .58079 L
s
.35781 .97021 m
.37732 .96207 L
s
.75336 .95882 m
.74184 .96148 L
s
.36003 .9485 m
.37709 .94077 L
s
.35244 1.01268 m
.37716 1.00378 L
s
.32884 .63122 m
.32087 .63267 L
s
.57688 .77204 m
.57393 .76609 L
s
.7058 .90396 m
.69788 .90334 L
s
.36463 .8896 m
.37564 .883 L
s
.55123 .74787 m
.5485 .74162 L
s
.36356 .90946 m
.37649 .90247 L
s
.29572 .55045 m
.28167 .55594 L
s
.31024 .57853 m
.29856 .58235 L
s
.36132 .93031 m
.37643 .923 L
s
.32957 .63477 m
.32182 .63614 L
s
.69848 .89601 m
.69097 .89489 L
s
.32428 .62123 m
.31558 .62327 L
s
.36378 .90044 m
.37583 .8937 L
s
.57826 .77364 m
.57525 .76768 L
s
.36436 .88268 m
.37474 .87633 L
s
.74671 .95128 m
.73564 .95332 L
s
.53571 .73448 m
.53298 .72814 L
s
.27617 .51241 m
.25872 .52023 L
s
.79778 1.01242 m
.78208 1.01881 L
s
.69688 .89435 m
.68945 .89311 L
s
.43664 .66245 m
.4326 .6579 L
s
.33314 .6458 m
.32615 .64672 L
s
.7128 .91232 m
.70429 .91201 L
s
.46568 .68002 m
.46232 .67462 L
s
.47992 .68994 m
.4768 .6842 L
s
.36486 .85863 m
.37308 .85283 L
s
.36501 .85074 m
.37255 .84511 L
s
.44586 .66769 m
.44205 .66284 L
s
.30151 .56846 m
.28881 .57329 L
s
.31995 .59698 m
.30975 .59975 L
s
.52576 .72613 m
.52301 .7198 L
s
.70979 .90907 m
.70145 .90853 L
s
.76244 .97006 m
.74996 .97325 L
s
.3179 .60724 m
.30815 .61009 L
s
.35212 1.00431 m
.37588 .99587 L
s
.36137 .9167 m
.37511 .90984 L
s
.73673 .94038 m
.72638 .94158 L
s
.32633 .62893 m
.31815 .63073 L
s
.516 .71815 m
.51321 .71187 L
s
.35989 .93326 m
.37537 .92611 L
s
.29218 .54657 m
.27773 .55256 L
s
.75795 .96493 m
.74582 .96771 L
s
.31172 .59332 m
.30093 .59693 L
s
.76168 .96939 m
.74922 .97246 L
s
.45959 .6763 m
.45607 .67105 L
s
.50434 .70873 m
.50147 .70256 L
s
.24794 .45469 m
.22494 .46593 L
s
.33104 .64303 m
.32382 .64424 L
s
.52366 .7246 m
.52088 .71825 L
s
.35779 .94986 m
.3751 .94251 L
s
.31351 .58791 m
.30252 .59143 L
s
.26824 .4981 m
.24942 .50695 L
s
.36359 .86406 m
.37232 .85833 L
s
.51754 .71956 m
.51472 .71325 L
s
.36301 .87516 m
.37275 .86925 L
s
.26786 .49784 m
.249 .50675 L
s
.35226 .99488 m
.3749 .98683 L
s
.36498 .84681 m
.37216 .84138 L
s
.54702 .74504 m
.54416 .73864 L
s
.44509 .66765 m
.44123 .66283 L
s
.36544 .8373 m
.3718 .83206 L
s
.3148 .59134 m
.30406 .59474 L
s
.46125 .67761 m
.45775 .6723 L
s
.43314 .6611 m
.42897 .65669 L
s
.55748 .75445 m
.55454 .74812 L
s
.56151 .75811 m
.55854 .75181 L
s
.27637 .51631 m
.25919 .52423 L
s
.36236 .88021 m
.37259 .87427 L
s
.36157 .89477 m
.37318 .88856 L
s
.36344 .87207 m
.37287 .86623 L
s
.35769 .94229 m
.37421 .93524 L
s
.3609 .90683 m
.37368 .9004 L
s
.52897 .72947 m
.52613 .72305 L
s
.49168 .69931 m
.48864 .6933 L
s
.28517 .5353 m
.26967 .54218 L
s
.3567 .95081 m
.37417 .94366 L
s
.31524 .6057 m
.30532 .60893 L
s
.5731 .76967 m
.56998 .76346 L
s
.2374 .43502 m
.21233 .44761 L
s
.52433 .72578 m
.52148 .71937 L
s
.53299 .73325 m
.53013 .7268 L
s
.71527 .91629 m
.70631 .91584 L
s
.35095 .9973 m
.37396 .98943 L
s
.28487 .53713 m
.26945 .54407 L
s
.72893 .93252 m
.71894 .93291 L
s
.36138 .89116 m
.37264 .88513 L
s
.56833 .76539 m
.56522 .75908 L
s
.32628 .63615 m
.31852 .63801 L
s
.41808 .65424 m
.41344 .65041 L
s
.30537 .5843 m
.29379 .58878 L
s
.56037 .7576 m
.55732 .75121 L
s
.7598 .96844 m
.74722 .97102 L
s
.35335 .97153 m
.37328 .96423 L
s
.36145 .86149 m
.37001 .85619 L
s
.74025 .94546 m
.72929 .94656 L
s
.48505 .69476 m
.48188 .68885 L
s
.36153 .84978 m
.36907 .84474 L
s
.49043 .69883 m
.48731 .69281 L
s
.50437 .70964 m
.50138 .70339 L
s
.53297 .73365 m
.53004 .72714 L
s
.3013 .57097 m
.28878 .57602 L
s
.54446 .74356 m
.54148 .73705 L
s
.32366 .60912 m
.3143 .61162 L
s
.45138 .672 m
.4476 .66697 L
s
.32096 .60532 m
.31128 .60811 L
s
.68801 .88833 m
.68072 .88609 L
s
.36227 .85448 m
.37017 .8493 L
s
.28835 .54561 m
.27366 .5522 L
s
.28127 .53111 m
.26531 .53856 L
s
.35412 .95878 m
.37259 .95183 L
s
.3528 .96998 m
.37258 .96287 L
s
.73935 .94505 m
.72839 .94599 L
s
.35194 .97751 m
.37262 .97028 L
s
.81835 1.04008 m
.79995 1.04785 L
s
.67644 .87676 m
.66981 .87386 L
s
.36256 .84184 m
.36936 .83695 L
s
.53284 .73357 m
.52988 .72704 L
s
.31994 .6233 m
.31123 .626 L
s
.35706 .92363 m
.37168 .91736 L
s
.31635 .61473 m
.30701 .61789 L
s
.3323 .62071 m
.32391 .62234 L
s
.50523 .71073 m
.50219 .70443 L
s
.49742 .70458 m
.49433 .6984 L
s
.28589 .5443 m
.27098 .55122 L
s
.29743 .57012 m
.28466 .57564 L
s
.2762 .52249 m
.25942 .5306 L
s
.54099 .74088 m
.53797 .73432 L
s
.72673 .93055 m
.71666 .93053 L
s
.31722 .61799 m
.30811 .62106 L
s
.70602 .90696 m
.69745 .90567 L
s
.73709 .94292 m
.72619 .94357 L
s
.3699 .6387 m
.3636 .63729 L
s
.37596 .64046 m
.3699 .6387 L
s
.46139 .67869 m
.45779 .67334 L
s
.3636 .63729 m
.35706 .63631 L
s
.69828 .89838 m
.6902 .89662 L
s
.30455 .58071 m
.29276 .58544 L
s
.31151 .60508 m
.30142 .60888 L
s
.35617 .92226 m
.37069 .91621 L
s
.50424 .71015 m
.50116 .70384 L
s
.55981 .75841 m
.55662 .75187 L
s
.52625 .7285 m
.52323 .72194 L
s
.56509 .76281 m
.56184 .75633 L
s
.35465 .93521 m
.37059 .929 L
s
.30176 .5823 m
.28992 .58732 L
s
.48926 .69858 m
.48604 .69253 L
s
.50739 .71286 m
.50432 .70648 L
s
.4549 .67477 m
.45114 .66961 L
s
.29271 .56211 m
.27923 .56826 L
s
.27762 .52796 m
.26127 .53597 L
s
.3818 .64251 m
.37596 .64046 L
s
.72834 .93293 m
.71802 .93287 L
s
.49772 .70517 m
.49456 .69895 L
s
.34855 .98947 m
.3708 .98246 L
s
.30843 .5993 m
.29789 .60351 L
s
.69207 .89185 m
.68431 .88965 L
s
.35706 .63631 m
.35027 .63584 L
s
.26746 .50762 m
.24923 .51688 L
s
.35443 .9326 m
.3701 .92654 L
s
.48797 .69781 m
.48471 .69176 L
s
.30016 .58022 m
.28813 .58547 L
s
.57309 .77048 m
.56969 .76405 L
s
.37167 .87279 m
.38057 .86665 L
s
.35802 .86941 m
.3674 .8645 L
s
.57179 .76932 m
.5684 .76287 L
s
.51519 .7195 m
.51211 .713 L
s
.32615 .64672 m
.31903 .64868 L
s
.5468 .74665 m
.54365 .74 L
s
.76456 .97572 m
.75113 .9782 L
s
.35755 .87642 m
.36759 .87142 L
s
.35659 .89509 m
.36842 .88976 L
s
.32087 .63267 m
.31275 .63532 L
s
.58041 .77841 m
.57688 .77204 L
s
.49177 .7008 m
.48854 .69467 L
s
.34022 1.04756 m
.37016 1.03974 L
s
.3543 .9246 m
.36916 .91881 L
s
.67607 .87736 m
.6692 .87417 L
s
.75792 .9679 m
.74504 .96983 L
s
.32182 .63614 m
.31395 .63867 L
s
.58185 .78002 m
.57826 .77364 L
s
.51753 .72172 m
.51441 .71517 L
s
.3568 .88852 m
.36798 .88339 L
s
.30144 .58582 m
.28981 .59096 L
s
.75885 .96937 m
.74584 .97129 L
s
.30798 .60135 m
.29754 .60568 L
s
.48868 .6987 m
.48538 .69261 L
s
.2959 .57327 m
.28326 .5791 L
s
.2892 .55537 m
.27518 .56204 L
s
.68418 .8837 m
.67677 .88096 L
s
.31134 .59753 m
.30085 .60156 L
s
.48127 .69323 m
.47788 .68731 L
s
.28828 .55658 m
.27426 .56337 L
s
.32382 .64424 m
.3165 .64653 L
s
.35688 .85512 m
.36501 .85074 L
s
.51335 .71847 m
.51019 .71193 L
s
.55686 .75661 m
.55355 .74991 L
s
.38744 .64481 m
.3818 .64251 L
s
.27956 .538 m
.26396 .54588 L
s
.55132 .75124 m
.54804 .74452 L
s
.35027 .63584 m
.34325 .63597 L
s
.35857 .84153 m
.36544 .8373 L
s
.31558 .62327 m
.30674 .62664 L
s
.34965 .96015 m
.36853 .95407 L
s
.3544 .90201 m
.36699 .89689 L
s
.35416 .90392 m
.36695 .89879 L
s
.31815 .63073 m
.30985 .63378 L
s
.5129 .71816 m
.5097 .71161 L
s
.356 .86304 m
.36486 .85863 L
s
.3508 .94499 m
.36797 .93921 L
s
.47831 .69136 m
.47485 .6855 L
s
.27979 .53974 m
.2643 .54762 L
s
.44078 .66713 m
.43664 .66245 L
s
.48763 .69828 m
.48426 .69218 L
s
.35725 .85105 m
.36498 .84681 L
s
.47957 .69238 m
.4761 .68647 L
s
.55462 .75464 m
.55123 .74787 L
s
.48697 .69793 m
.48358 .69183 L
s
.30208 .59237 m
.29088 .59751 L
s
.68445 .88485 m
.67684 .88191 L
s
.35179 .92278 m
.36658 .91753 L
s
.23717 .44944 m
.21313 .46264 L
s
.48204 .69439 m
.47858 .6884 L
s
.44984 .67271 m
.44586 .66769 L
s
.26755 .51557 m
.24986 .52504 L
s
.35167 .91959 m
.36615 .91446 L
s
.30975 .59975 m
.29933 .60406 L
s
.4227 .6582 m
.41808 .65424 L
s
.28645 .55802 m
.27245 .56515 L
s
.35419 .86827 m
.36359 .86406 L
s
.34836 .9553 m
.36678 .94966 L
s
.4374 .66566 m
.43314 .6611 L
s
.67955 .88213 m
.67214 .87878 L
s
.34559 .97979 m
.36692 .97381 L
s
.30815 .61009 m
.29827 .61449 L
s
.35315 .88718 m
.36436 .88268 L
s
.35274 .8942 m
.36463 .8896 L
s
.57684 .77634 m
.5731 .76967 L
s
.35253 .90283 m
.36526 .89808 L
s
.31852 .63801 m
.31068 .64107 L
s
.34591 .97193 m
.36633 .96618 L
s
.34569 .97347 m
.3663 .96772 L
s
.53907 .74135 m
.53571 .73448 L
s
.46936 .68569 m
.46568 .68002 L
s
.34325 .63597 m
.33603 .63681 L
s
.29808 .58079 m
.28604 .58655 L
s
.32391 .62234 m
.31533 .62507 L
s
.56513 .76493 m
.56151 .75811 L
s
.39294 .64733 m
.38744 .64481 L
s
.29281 .57517 m
.28018 .58156 L
s
.35343 .85354 m
.36153 .84978 L
s
.44913 .67266 m
.44509 .66765 L
s
.75509 .96678 m
.74194 .96789 L
s
.35525 .8456 m
.36256 .84184 L
s
.35089 .9096 m
.36438 .90492 L
s
.35252 .87934 m
.36301 .87516 L
s
.29856 .58235 m
.28664 .58807 L
s
.349 .93324 m
.36502 .92821 L
s
.56107 .76132 m
.55748 .75445 L
s
.27498 .53564 m
.25901 .54429 L
s
.35329 .87625 m
.36344 .87207 L
s
.46338 .68179 m
.45959 .6763 L
s
.28003 .54716 m
.26504 .55518 L
s
.48344 .69601 m
.47992 .68994 L
s
.57207 .77219 m
.56833 .76539 L
s
.52913 .73299 m
.52576 .72613 L
s
.35379 .8583 m
.36227 .85448 L
s
.34991 .91365 m
.36385 .90904 L
s
.35225 .8653 m
.36145 .86149 L
s
.30252 .59143 m
.29133 .59669 L
s
.55054 .75198 m
.54702 .74504 L
s
.30093 .59693 m
.28998 .60233 L
s
.35076 .90492 m
.36378 .90044 L
s
.3143 .61162 m
.30477 .61548 L
s
.2754 .53692 m
.25955 .54556 L
s
.26639 .51844 m
.24885 .52821 L
s
.28735 .56522 m
.27386 .57235 L
s
.35136 .88431 m
.36236 .88021 L
s
.30406 .59474 m
.29313 .59983 L
s
.51938 .72493 m
.516 .71815 L
s
.7646 .97858 m
.75045 .98025 L
s
.46505 .68317 m
.46125 .67761 L
s
.32971 1.08279 m
.36523 1.0757 L
s
.30532 .60893 m
.29528 .61378 L
s
.27621 .53949 m
.26056 .54805 L
s
.34958 .91398 m
.36356 .90946 L
s
.56407 .76452 m
.56037 .7576 L
s
.52708 .73148 m
.52366 .7246 L
s
.31128 .60811 m
.30143 .61235 L
s
.50777 .71536 m
.50434 .70873 L
s
.28111 .55058 m
.26642 .55855 L
s
.73125 .9396 m
.7199 .93884 L
s
.26856 .52426 m
.25153 .53381 L
s
.52096 .72639 m
.51754 .71956 L
s
.70619 .91093 m
.69674 .90868 L
s
.31123 .626 m
.30244 .6301 L
s
.34826 .92373 m
.36331 .91917 L
s
.35926 .64101 m
.35272 .64062 L
s
.3656 .64186 m
.35926 .64101 L
s
.37174 .6431 m
.3656 .64186 L
s
.34274 .97728 m
.36397 .97202 L
s
.33916 1.00747 m
.36419 1.00178 L
s
.75299 .96542 m
.73975 .96605 L
s
.31903 .64868 m
.31188 .65174 L
s
.69248 .89713 m
.68392 .89406 L
s
.53245 .73644 m
.52897 .72947 L
s
.76257 .97677 m
.74846 .9781 L
s
.71814 .92477 m
.70775 .92313 L
s
.34907 .89881 m
.36157 .89477 L
s
.5365 .74026 m
.53299 .73325 L
s
.34356 .96525 m
.36337 .96026 L
s
.52782 .73274 m
.52433 .72578 L
s
.49522 .70573 m
.49168 .69931 L
s
.45539 .67726 m
.45138 .672 L
s
.28881 .57329 m
.2759 .58033 L
s
.35272 .64062 m
.34598 .64077 L
s
.30701 .61789 m
.29758 .62258 L
s
.58453 .78521 m
.58041 .77841 L
s
.77664 .99392 m
.76112 .99626 L
s
.30811 .62106 m
.29892 .62561 L
s
.34927 .89509 m
.36138 .89116 L
s
.5481 .75064 m
.54446 .74356 L
s
.37769 .64467 m
.37174 .6431 L
s
.71709 .92465 m
.70666 .92281 L
s
.58602 .78683 m
.58185 .78002 L
s
.66981 .87386 m
.66255 .8696 L
s
.57713 .77739 m
.57309 .77048 L
s
.569 .76982 m
.56509 .76281 L
s
.28167 .55594 m
.26737 .56394 L
s
.33603 .63681 m
.32863 .63844 L
s
.34652 .92086 m
.36137 .9167 L
s
.31275 .63532 m
.3046 .63927 L
s
.31395 .63867 m
.30604 .64246 L
s
.57582 .77627 m
.57179 .76932 L
s
.53655 .74072 m
.53297 .73365 L
s
.33869 .9989 m
.36273 .99368 L
s
.69552 .90105 m
.68659 .89796 L
s
.56367 .76549 m
.55981 .75841 L
s
.27195 .53729 m
.25596 .54654 L
s
.3165 .64653 m
.30915 .64998 L
s
.24492 .4783 m
.22344 .49099 L
s
.35125 .84456 m
.35857 .84153 L
s
.34713 .91078 m
.3609 .90683 L
s
.34495 .93456 m
.36132 .93031 L
s
.48869 .70107 m
.48505 .69476 L
s
.68945 .89311 m
.68091 .88974 L
s
.39831 .65004 m
.39294 .64733 L
s
.76453 .98 m
.75001 .98121 L
s
.69097 .89489 m
.68231 .89158 L
s
.29379 .58878 m
.28207 .59525 L
s
.49404 .70528 m
.49043 .69883 L
s
.53647 .74067 m
.53284 .73357 L
s
.50794 .71638 m
.50437 .70964 L
s
.54469 .74803 m
.54099 .74088 L
s
.34801 .87261 m
.35802 .86941 L
s
.34598 .64077 m
.33906 .64155 L
s
.30142 .60888 m
.29126 .61437 L
s
.46532 .68432 m
.46139 .67869 L
s
.34822 .85805 m
.35688 .85512 L
s
.33796 .9952 m
.36161 .9903 L
s
.36209 .8774 m
.37167 .87279 L
s
.33182 1.04285 m
.36185 1.0373 L
s
.2586 .51057 m
.24014 .52159 L
s
.27004 .53491 m
.2538 .54449 L
s
.73971 .95132 m
.72726 .95064 L
s
.71595 .92426 m
.7054 .9221 L
s
.45894 .68019 m
.4549 .67477 L
s
.7309 .94124 m
.71917 .93997 L
s
.50884 .71753 m
.50523 .71073 L
s
.38349 .64652 m
.37769 .64467 L
s
.32851 1.06328 m
.3615 1.05755 L
s
.34684 .87956 m
.35755 .87642 L
s
.34903 .85391 m
.35725 .85105 L
s
.50106 .71123 m
.49742 .70458 L
s
.34314 .93723 m
.35989 .93326 L
s
.27773 .55256 m
.26303 .56118 L
s
.30985 .63378 m
.30152 .63819 L
s
.69788 .90334 m
.68859 .90018 L
s
.34151 .95262 m
.36003 .9485 L
s
.28878 .57602 m
.27608 .58324 L
s
.68072 .88609 m
.67255 .88205 L
s
.52993 .73563 m
.52625 .7285 L
s
.55064 .75388 m
.5468 .74665 L
s
.33763 .98954 m
.36062 .98494 L
s
.71281 .92038 m
.70242 .91798 L
s
.6692 .87417 m
.66172 .86962 L
s
.29789 .60351 m
.28726 .60952 L
s
.30674 .62664 m
.29787 .63149 L
s
.78584 1.00666 m
.769 1.00927 L
s
.34656 .86583 m
.356 .86304 L
s
.33851 .97793 m
.36009 .97357 L
s
.50791 .71697 m
.50424 .71015 L
s
.29276 .58544 m
.28083 .59219 L
s
.56087 .76389 m
.55686 .75661 L
s
.33985 .96344 m
.35967 .95933 L
s
.49299 .70508 m
.48926 .69858 L
s
.51107 .71975 m
.50739 .71286 L
s
.4274 .66233 m
.4227 .6582 L
s
.30085 .60156 m
.29024 .60729 L
s
.50143 .71188 m
.49772 .70517 L
s
.83038 1.0626 m
.80864 1.06922 L
s
.5812 .78348 m
.57684 .77634 L
s
.49173 .70429 m
.48797 .69781 L
s
.31533 .62507 m
.30665 .62906 L
s
.44512 .67204 m
.44078 .66713 L
s
.55529 .75855 m
.55132 .75124 L
s
.33783 .97657 m
.35929 .97242 L
s
.51891 .72655 m
.51519 .7195 L
s
.29754 .60568 m
.28706 .6118 L
s
.28992 .58732 m
.27798 .59444 L
s
.31068 .64107 m
.30286 .64542 L
s
.34751 .84806 m
.35525 .8456 L
s
.33906 .64155 m
.332 .64304 L
s
.34394 .89812 m
.35659 .89509 L
s
.34485 .89151 m
.3568 .88852 L
s
.28466 .57564 m
.27176 .58347 L
s
.49554 .7074 m
.49177 .7008 L
s
.34487 .85581 m
.35343 .85354 L
s
.5213 .72884 m
.51753 .72172 L
s
.32863 .63844 m
.32113 .64099 L
s
.5587 .762 m
.55462 .75464 L
s
.23934 .47498 m
.21732 .48869 L
s
.33982 .94582 m
.35769 .94229 L
s
.75667 .97265 m
.74236 .9727 L
s
.33903 .95347 m
.35779 .94986 L
s
.28813 .58547 m
.27601 .59287 L
s
.70145 .90853 m
.69163 .90525 L
s
.34421 .87073 m
.35419 .86827 L
s
.49249 .70524 m
.48868 .6987 L
s
.48512 .69957 m
.48127 .69323 L
s
.34133 .92688 m
.35706 .92363 L
s
.44184 .67045 m
.4374 .66566 L
s
.67677 .88096 m
.6686 .87655 L
s
.26967 .54218 m
.25392 .55202 L
s
.7215 .93214 m
.71012 .92985 L
s
.33657 .97398 m
.35781 .97021 L
s
.57647 .77951 m
.57207 .77219 L
s
.28981 .59096 m
.27811 .59817 L
s
.38917 .64862 m
.38349 .64652 L
s
.51715 .72556 m
.51335 .71847 L
s
.70429 .91201 m
.6942 .90881 L
s
.45408 .678 m
.44984 .67271 L
s
.56943 .7723 m
.56513 .76493 L
s
.33512 .9841 m
.35765 .98027 L
s
.26945 .54407 m
.25381 .55397 L
s
.29933 .60406 m
.28884 .61009 L
s
.68431 .88965 m
.67558 .88548 L
s
.22412 .44395 m
.1989 .4597 L
s
.25872 .52023 m
.24094 .53153 L
s
.34482 .86054 m
.35379 .8583 L
s
.48223 .69765 m
.47831 .69136 L
s
.27366 .5522 m
.25877 .56157 L
s
.34056 .9253 m
.35617 .92226 L
s
.51673 .72526 m
.5129 .71816 L
s
.40363 .65296 m
.39831 .65004 L
s
.33779 .95417 m
.3567 .95081 L
s
.31188 .65174 m
.30478 .656 L
s
.29827 .61449 m
.28839 .62061 L
s
.48349 .69871 m
.47957 .69238 L
s
.56536 .76877 m
.56107 .76132 L
s
.49151 .70484 m
.48763 .69828 L
s
.27923 .56826 m
.26564 .57692 L
s
.58926 .79245 m
.58453 .78521 L
s
.74074 .95455 m
.72763 .95329 L
s
.6902 .89662 m
.68099 .89261 L
s
.30477 .61548 m
.29518 .62087 L
s
.34254 .86736 m
.35225 .8653 L
s
.59079 .79405 m
.58602 .78683 L
s
.34096 .90461 m
.3544 .90201 L
s
.78378 1.00613 m
.76662 1.00795 L
s
.49088 .70449 m
.48697 .69793 L
s
.67214 .87878 m
.66406 .8739 L
s
.29088 .59751 m
.27965 .60465 L
s
.28326 .5791 m
.27055 .58725 L
s
.34051 .90648 m
.35416 .90392 L
s
.81924 1.05025 m
.79827 1.05517 L
s
.67684 .88191 m
.66846 .87728 L
s
.48599 .70082 m
.48204 .69439 L
s
.34124 .88947 m
.35315 .88718 L
s
.45344 .67795 m
.44913 .67266 L
s
.34253 .87847 m
.35329 .87625 L
s
.73928 .95342 m
.72621 .95196 L
s
.27098 .55122 m
.2559 .56102 L
s
.56848 .77201 m
.56407 .76452 L
s
.3414 .88149 m
.35252 .87934 L
s
.25919 .52423 m
.24172 .53557 L
s
.54315 .74884 m
.53907 .74135 L
s
.332 .64304 m
.32484 .64536 L
s
.71741 .92802 m
.70609 .92523 L
s
.33837 .92727 m
.3543 .9246 L
s
.33751 .93802 m
.35465 .93521 L
s
.30143 .61235 m
.29155 .61821 L
s
.30244 .6301 m
.29371 .63572 L
s
.26531 .53856 m
.24912 .54913 L
s
.55478 .75955 m
.55054 .75198 L
s
.58182 .7848 m
.57713 .77739 L
s
.34008 .89642 m
.35274 .8942 L
s
.34357 .84625 m
.35125 .84456 L
s
.47345 .69175 m
.46936 .68569 L
s
.33759 .93532 m
.35443 .9326 L
s
.30915 .64998 m
.30189 .65468 L
s
.58052 .78373 m
.57582 .77627 L
s
.46754 .68765 m
.46338 .68179 L
s
.30604 .64246 m
.29821 .64761 L
s
.69745 .90567 m
.68753 .90176 L
s
.76949 .98974 m
.75348 .99015 L
s
.29528 .61378 m
.28526 .62042 L
s
.33971 .88622 m
.35136 .88431 L
s
.27518 .56204 m
.26103 .57138 L
s
.70631 .91584 m
.69572 .91232 L
s
.3046 .63927 m
.29652 .64463 L
s
.5736 .77738 m
.569 .76982 L
s
.35303 .6453 m
.34647 .64575 L
s
.35944 .64535 m
.35303 .6453 L
s
.66255 .8696 m
.65485 .86414 L
s
.53321 .74048 m
.52913 .73299 L
s
.29313 .59983 m
.28217 .60681 L
s
.33896 .905 m
.35253 .90283 L
s
.36571 .64585 m
.35944 .64535 L
s
.33415 .96158 m
.35412 .95878 L
s
.27426 .56337 m
.26015 .57285 L
s
.29133 .59669 m
.2801 .60393 L
s
.24942 .50695 m
.23026 .51971 L
s
.48748 .70255 m
.48344 .69601 L
s
.28604 .58655 m
.27396 .59449 L
s
.46924 .68911 m
.46505 .68317 L
s
.29892 .62561 m
.28979 .63178 L
s
.28998 .60233 m
.27905 .60972 L
s
.249 .50675 m
.22981 .51958 L
s
.28664 .58807 m
.27468 .59593 L
s
.34647 .64575 m
.33978 .6468 L
s
.29758 .62258 m
.28823 .62895 L
s
.56823 .77317 m
.56367 .76549 L
s
.52344 .73233 m
.51938 .72493 L
s
.5312 .73899 m
.52708 .73148 L
s
.25942 .5306 m
.24243 .54209 L
s
.32113 .64099 m
.31358 .64455 L
s
.33914 .85931 m
.34822 .85805 L
s
.39477 .65097 m
.38917 .64862 L
s
.33177 .97423 m
.35335 .97153 L
s
.77819 1.00101 m
.76114 1.00186 L
s
.33622 .92166 m
.35167 .91959 L
s
.33598 .92488 m
.35179 .92278 L
s
.37185 .64673 m
.36571 .64585 L
s
.34041 .85521 m
.34903 .85391 L
s
.54075 .74792 m
.5365 .74026 L
s
.52508 .73385 m
.52096 .72639 L
s
.53666 .74405 m
.53245 .73644 L
s
.55249 .75836 m
.5481 .75064 L
s
.26127 .53597 m
.24473 .54725 L
s
.73866 .95402 m
.72525 .95207 L
s
.33652 .91147 m
.35089 .9096 L
s
.45973 .68286 m
.45539 .67726 L
s
.33138 .97255 m
.3528 .96998 L
s
.51184 .72259 m
.50777 .71536 L
s
.28018 .58156 m
.26753 .59034 L
s
.33692 .90671 m
.35076 .90492 L
s
.58622 .79111 m
.5812 .78348 L
s
.53203 .74034 m
.52782 .73274 L
s
.32598 1.01584 m
.35304 1.01292 L
s
.30152 .63819 m
.29331 .64408 L
s
.33748 .87383 m
.34801 .87261 L
s
.33978 .6468 m
.33299 .64851 L
s
.66172 .86962 m
.65382 .86387 L
s
.27245 .56515 m
.2584 .57502 L
s
.30665 .62906 m
.298 .63443 L
s
.77212 .9944 m
.75547 .99455 L
s
.26396 .54588 m
.24823 .55689 L
s
.54087 .74845 m
.53655 .74072 L
s
.33507 .91532 m
.34991 .91365 L
s
.3276 .99746 m
.35226 .99488 L
s
.33944 .84904 m
.34751 .84806 L
s
.32953 .9799 m
.35194 .97751 L
s
.33583 .90026 m
.34907 .89881 L
s
.32538 1.01543 m
.35244 1.01268 L
s
.49935 .71271 m
.49522 .70573 L
s
.32484 .64536 m
.31764 .6486 L
s
.33646 .89653 m
.34927 .89509 L
s
.33237 .94695 m
.3508 .94499 L
s
.54913 .75584 m
.54469 .74803 L
s
.32619 1.00692 m
.35212 1.00431 L
s
.2643 .54762 m
.24871 .55861 L
s
.35192 .88021 m
.36209 .8774 L
s
.33669 .86676 m
.34656 .86583 L
s
.30286 .64542 m
.29517 .65116 L
s
.29787 .63149 m
.28913 .63793 L
s
.54084 .74843 m
.53647 .74067 L
s
.33471 .91554 m
.34958 .91398 L
s
.43224 .66672 m
.4274 .66233 L
s
.29126 .61437 m
.28119 .62175 L
s
.37787 .64795 m
.37185 .64673 L
s
.59616 .80165 m
.59079 .79405 L
s
.56561 .77178 m
.56087 .76389 L
s
.40896 .6561 m
.40363 .65296 L
s
.59459 .80008 m
.58926 .79245 L
s
.33557 .88054 m
.34684 .87956 L
s
.55524 .76177 m
.55064 .75388 L
s
.27386 .57235 m
.26036 .58212 L
s
.33595 .85641 m
.34487 .85581 L
s
.32591 .99955 m
.35095 .9973 L
s
.4929 .70792 m
.48869 .70107 L
s
.46966 .69038 m
.46532 .68432 L
s
.58156 .78735 m
.57647 .77951 L
s
.71894 .93291 m
.70683 .92943 L
s
.46335 .686 m
.45894 .68019 L
s
.33191 .93474 m
.349 .93324 L
s
.49826 .7123 m
.49404 .70528 L
s
.51217 .72375 m
.50794 .71638 L
s
.24923 .51688 m
.23079 .52999 L
s
.68392 .89406 m
.67439 .88891 L
s
.34969 .64728 m
.34313 .64819 L
s
.35615 .64691 m
.34969 .64728 L
s
.72638 .94158 m
.71362 .93846 L
s
.30478 .656 m
.29786 .66152 L
s
.32934 .96188 m
.34965 .96015 L
s
.56002 .76651 m
.55529 .75855 L
s
.36249 .647 m
.35615 .64691 L
s
.33299 .64851 m
.32615 .65099 L
s
.28207 .59525 m
.27043 .60396 L
s
.33225 .92501 m
.34826 .92373 L
s
.67255 .88205 m
.66371 .8764 L
s
.2759 .58033 m
.26303 .58989 L
s
.53435 .74343 m
.52993 .73563 L
s
.74344 .96149 m
.72913 .95929 L
s
.57446 .78026 m
.56943 .7723 L
s
.26504 .55518 m
.25002 .56623 L
s
.28726 .60952 m
.27676 .61754 L
s
.44975 .67729 m
.44512 .67204 L
s
.68091 .88974 m
.6715 .88443 L
s
.29024 .60729 m
.2797 .61494 L
s
.34313 .64819 m
.33647 .64971 L
s
.56353 .77001 m
.5587 .762 L
s
.51314 .72497 m
.50884 .71753 L
s
.33254 .91179 m
.34713 .91078 L
s
.33548 .86102 m
.34482 .86054 L
s
.50535 .71849 m
.50106 .71123 L
s
.3338 .87117 m
.34421 .87073 L
s
.71666 .93053 m
.70457 .92675 L
s
.32861 .9567 m
.34836 .9553 L
s
.22494 .46593 m
.20147 .48241 L
s
.68231 .89158 m
.67274 .88624 L
s
.36872 .64752 m
.36249 .647 L
s
.26642 .55855 m
.2517 .56947 L
s
.58718 .7927 m
.58182 .7848 L
s
.33077 .92177 m
.34652 .92086 L
s
.51226 .72443 m
.50791 .71697 L
s
.57039 .77683 m
.56536 .76877 L
s
.28706 .6118 m
.2767 .61991 L
s
.6686 .87655 m
.65987 .87067 L
s
.33562 .84644 m
.34357 .84625 L
s
.32444 .99106 m
.34855 .98947 L
s
.44656 .67557 m
.44184 .67045 L
s
.25901 .54429 m
.24297 .55625 L
s
.51544 .72729 m
.51107 .71975 L
s
.31358 .64455 m
.30609 .64924 L
s
.49733 .71216 m
.49299 .70508 L
s
.40035 .65357 m
.39477 .65097 L
s
.5859 .79169 m
.58052 .78373 L
s
.30189 .65468 m
.29483 .66071 L
s
.68659 .89796 m
.67663 .89265 L
s
.52335 .73428 m
.51891 .72655 L
s
.25955 .54556 m
.24364 .55747 L
s
.57362 .7801 m
.56848 .77201 L
s
.33232 .892 m
.34485 .89151 L
s
.33243 .86747 m
.34254 .86736 L
s
.28083 .59219 m
.26897 .6012 L
s
.50579 .71921 m
.50143 .71188 L
s
.33647 .64971 m
.32975 .65194 L
s
.26056 .54805 m
.24487 .55983 L
s
.65485 .86414 m
.64688 .85768 L
s
.29518 .62087 m
.2857 .62794 L
s
.38381 .64948 m
.37787 .64795 L
s
.49609 .71136 m
.49173 .70429 L
s
.24986 .52504 m
.23205 .53829 L
s
.73564 .95332 m
.72176 .95035 L
s
.66406 .8739 m
.65553 .8677 L
s
.71802 .93287 m
.70562 .92894 L
s
.26737 .56394 m
.25307 .57482 L
s
.27608 .58324 m
.26345 .59293 L
s
.28884 .61009 m
.27845 .61805 L
s
.31764 .6486 m
.31049 .65286 L
s
.33064 .89846 m
.34394 .89812 L
s
.5258 .73666 m
.5213 .72884 L
s
.69674 .90868 m
.68595 .9037 L
s
.49994 .7146 m
.49554 .7074 L
s
.29821 .64761 m
.29059 .65421 L
s
.4587 .6837 m
.45408 .678 L
s
.57893 .78551 m
.5736 .77738 L
s
.28839 .62061 m
.27868 .62862 L
s
.32615 .65099 m
.3193 .65431 L
s
.29371 .63572 m
.28517 .64298 L
s
.27798 .59444 m
.26616 .60392 L
s
.48956 .70648 m
.48512 .69957 L
s
.37485 .6484 m
.36872 .64752 L
s
.66846 .87728 m
.65954 .87117 L
s
.32756 .93512 m
.34495 .93456 L
s
.29652 .64463 m
.28867 .6515 L
s
.49692 .71239 m
.49249 .70524 L
s
.33132 .87847 m
.34253 .87847 L
s
.59189 .79918 m
.58622 .79111 L
s
.52169 .73335 m
.51715 .72556 L
s
.72929 .94656 m
.71579 .94304 L
s
.77101 .99612 m
.75364 .99522 L
s
.74184 .96148 m
.72724 .95866 L
s
.32397 .97278 m
.34591 .97193 L
s
.29155 .61821 m
.28179 .62586 L
s
.55981 .76779 m
.55478 .75955 L
s
.60211 .80958 m
.59616 .80165 L
s
.72839 .94599 m
.71492 .94236 L
s
.67558 .88548 m
.66613 .87953 L
s
.32355 .97426 m
.34569 .97347 L
s
.32982 .88131 m
.3414 .88149 L
s
.60053 .80806 m
.59459 .80008 L
s
.52129 .73307 m
.51673 .72526 L
s
.72619 .94357 m
.71288 .93979 L
s
.48672 .7045 m
.48223 .69765 L
s
.68859 .90018 m
.67821 .89468 L
s
.57355 .78145 m
.56823 .77317 L
s
.32262 .98057 m
.34559 .97979 L
s
.54802 .75705 m
.54315 .74884 L
s
.65382 .86387 m
.64568 .85713 L
s
.45812 .68366 m
.45344 .67795 L
s
.24885 .52821 m
.23123 .54178 L
s
.25153 .53381 m
.23444 .54701 L
s
.27601 .59287 m
.26403 .6027 L
s
.27811 .59817 m
.26656 .6077 L
s
.32975 .65194 m
.32302 .65494 L
s
.32977 .85874 m
.33914 .85931 L
s
.33153 .85479 m
.34041 .85521 L
s
.488 .70562 m
.48349 .69871 L
s
.32881 .88923 m
.34124 .88947 L
s
.3092 1.08487 m
.34698 1.08315 L
s
.49602 .71202 m
.49151 .70484 L
s
.27176 .58347 m
.25898 .59391 L
s
.26303 .56118 m
.24839 .57284 L
s
.25596 .54654 m
.23997 .55918 L
s
.21233 .44761 m
.18673 .46619 L
s
.32538 .93736 m
.34314 .93723 L
s
.49542 .71167 m
.49088 .70449 L
s
.28979 .63178 m
.28091 .63971 L
s
.27965 .60465 m
.26861 .61402 L
s
.33116 .84841 m
.33944 .84904 L
s
.49054 .70786 m
.48599 .70082 L
s
.28526 .62042 m
.27548 .62902 L
s
.298 .63443 m
.2895 .64131 L
s
.28823 .62895 m
.27911 .63713 L
s
.32687 .90427 m
.34096 .90461 L
s
.32237 .9655 m
.34356 .96525 L
s
.32759 .88567 m
.33971 .88622 L
s
.29331 .64408 m
.28536 .65154 L
s
.30962 1.0716 m
.3455 1.07043 L
s
.47807 .69835 m
.47345 .69175 L
s
.32687 .89592 m
.34008 .89642 L
s
.4722 .69402 m
.46754 .68765 L
s
.41438 .65954 m
.40896 .6561 L
s
.68099 .89261 m
.67092 .88656 L
s
.53809 .74871 m
.53321 .74048 L
s
.58735 .79571 m
.58156 .78735 L
s
.3262 .90604 m
.34051 .90648 L
s
.29517 .65116 m
.28775 .65837 L
s
.55768 .7668 m
.55249 .75836 L
s
.28217 .60681 m
.27138 .61591 L
s
.2538 .54449 m
.2376 .55754 L
s
.70775 .92313 m
.69565 .91811 L
s
.38971 .65133 m
.38381 .64948 L
s
.38093 .64964 m
.37485 .6484 L
s
.32473 .92656 m
.34133 .92688 L
s
.3193 .65431 m
.31252 .65857 L
s
.31997 .97734 m
.34274 .97728 L
s
.74582 .96771 m
.7304 .96462 L
s
.29786 .66152 m
.29123 .66837 L
s
.2801 .60393 m
.26905 .61335 L
s
.3266 .87284 m
.33748 .87383 L
s
.32682 .85519 m
.33595 .85641 L
s
.27055 .58725 m
.25801 .59802 L
s
.53612 .74726 m
.5312 .73899 L
s
.70666 .92281 m
.69457 .91762 L
s
.5458 .75633 m
.54075 .74792 L
s
.32653 .86563 m
.33669 .86676 L
s
.47394 .6956 m
.46924 .68911 L
s
.32182 .95235 m
.34151 .95262 L
s
.64688 .85768 m
.63882 .85042 L
s
.27905 .60972 m
.26835 .61931 L
s
.32413 .92481 m
.34056 .9253 L
s
.57113 .78033 m
.56561 .77178 L
s
.59323 .80107 m
.58718 .7927 L
s
.52829 .74049 m
.52344 .73233 L
s
.49214 .70973 m
.48748 .70255 L
s
.54167 .75242 m
.53666 .74405 L
s
.32302 .65494 m
.31634 .65882 L
s
.30609 .64924 m
.29876 .65515 L
s
.69163 .90525 m
.68064 .89942 L
s
.28913 .63793 m
.28067 .64609 L
s
.26564 .57692 m
.25221 .58842 L
s
.31049 .65286 m
.30347 .65821 L
s
.60862 .81776 m
.60211 .80958 L
s
.75349 .97747 m
.73722 .97467 L
s
.46453 .68897 m
.45973 .68286 L
s
.3248 .90417 m
.33896 .905 L
s
.52999 .74207 m
.52508 .73385 L
s
.58025 .78882 m
.57446 .78026 L
s
.59197 .80014 m
.5859 .79169 L
s
.74996 .97325 m
.734 .97022 L
s
.5544 .76438 m
.54913 .75584 L
s
.43734 .67149 m
.43224 .66672 L
s
.74922 .97246 m
.73331 .96935 L
s
.40599 .65649 m
.40035 .65357 L
s
.27468 .59593 m
.26291 .6062 L
s
.54601 .75694 m
.54087 .74845 L
s
.27396 .59449 m
.26207 .60486 L
s
.53705 .74871 m
.53203 .74034 L
s
.60703 .81633 m
.60053 .80806 L
s
.3413 .88096 m
.35192 .88021 L
s
.70242 .91798 m
.69049 .91245 L
s
.56065 .77039 m
.55524 .76177 L
s
.51667 .73055 m
.51184 .72259 L
s
.3209 .94514 m
.33982 .94582 L
s
.32754 .84502 m
.33562 .84644 L
s
.7054 .9221 m
.69321 .91665 L
s
.25877 .56157 m
.24401 .5741 L
s
.6942 .90881 m
.68286 .90289 L
s
.82148 1.06163 m
.79783 1.06385 L
s
.56556 .77517 m
.56002 .76651 L
s
.54603 .75697 m
.54084 .74843 L
s
.59821 .80766 m
.59189 .79918 L
s
.32593 .85956 m
.33548 .86102 L
s
.32396 .8791 m
.33557 .88054 L
s
.29483 .66071 m
.2881 .66811 L
s
.66371 .8764 m
.65443 .86936 L
s
.32162 .92628 m
.33837 .92727 L
s
.56916 .77869 m
.56353 .77001 L
s
.25392 .55202 m
.23829 .56528 L
s
.28119 .62175 m
.27141 .63115 L
s
.64568 .85713 m
.63749 .84964 L
s
.31874 .96274 m
.33985 .96344 L
s
.65553 .8677 m
.64673 .86042 L
s
.24014 .52159 m
.22167 .5368 L
s
.65987 .87067 m
.65082 .86356 L
s
.57621 .78553 m
.57039 .77683 L
s
.25381 .55397 m
.23831 .56728 L
s
.31913 .95258 m
.33903 .95347 L
s
.57953 .78881 m
.57362 .7801 L
s
.74722 .97102 m
.73127 .96754 L
s
.7199 .93884 m
.70638 .93389 L
s
.68753 .90176 m
.67656 .89545 L
s
.32316 .89516 m
.33646 .89653 L
s
.32251 .90541 m
.33692 .90671 L
s
.50419 .72041 m
.49935 .71271 L
s
.32312 .8694 m
.3338 .87117 L
s
.585 .79421 m
.57893 .78551 L
s
.32154 .9101 m
.33652 .91147 L
s
.32209 .89878 m
.33583 .90026 L
s
.2559 .56102 m
.24099 .57409 L
s
.26103 .57138 m
.24707 .58373 L
s
.31945 .93679 m
.33751 .93802 L
s
.21313 .46264 m
.1888 .48169 L
s
.31987 .9341 m
.33759 .93532 L
s
.26753 .59034 m
.25514 .60179 L
s
.77478 1.00457 m
.75598 1.00269 L
s
.29059 .65421 m
.28334 .66234 L
s
.46827 .69237 m
.46335 .686 L
s
.26015 .57285 m
.24626 .58537 L
s
.32006 .92018 m
.33622 .92166 L
s
.47455 .69703 m
.46966 .69038 L
s
.63882 .85042 m
.63084 .8426 L
s
.31548 .97688 m
.33851 .97793 L
s
.61563 .82609 m
.60862 .81776 L
s
.31777 .95296 m
.33779 .95417 L
s
.32211 .86542 m
.33243 .86747 L
s
.30751 1.04704 m
.34022 1.04756 L
s
.31252 .65857 m
.30591 .66384 L
s
.31634 .65882 m
.30979 .66363 L
s
.53961 .75204 m
.53435 .74343 L
s
.31217 1.00658 m
.33916 1.00747 L
s
.2797 .61494 m
.26943 .62469 L
s
.38699 .65123 m
.38093 .64964 L
s
.4978 .71548 m
.4929 .70792 L
s
.45478 .68303 m
.44975 .67729 L
s
.6715 .88443 m
.66148 .87741 L
s
.31943 .92333 m
.33598 .92488 L
s
.67439 .88891 m
.66417 .88193 L
s
.51719 .73189 m
.51217 .72375 L
s
.65954 .87117 m
.65029 .86383 L
s
.31286 .99788 m
.33869 .9989 L
s
.2857 .62794 m
.2765 .63685 L
s
.50319 .72005 m
.49826 .7123 L
s
.27676 .61754 m
.26659 .62774 L
s
.31495 .97534 m
.33783 .97657 L
s
.3196 .91358 m
.33507 .91532 L
s
.28867 .6515 m
.2812 .65996 L
s
.61406 .82477 m
.60703 .81633 L
s
.57964 .79037 m
.57355 .78145 L
s
.3126 .99398 m
.33796 .9952 L
s
.28517 .64298 m
.27702 .65198 L
s
.67274 .88624 m
.66254 .87915 L
s
.24912 .54913 m
.23311 .56332 L
s
.31302 .98824 m
.33763 .98954 L
s
.45166 .68118 m
.44656 .67557 L
s
.39565 .65353 m
.38971 .65133 L
s
.51822 .7332 m
.51314 .72497 L
s
.59384 .80455 m
.58735 .79571 L
s
.31922 .91368 m
.33471 .91554 L
s
.32253 .8525 m
.33153 .85479 L
s
.22344 .49099 m
.20188 .50881 L
s
.69572 .91232 m
.68381 .90596 L
s
.24094 .53153 m
.22328 .54691 L
s
.2767 .61991 m
.26671 .63017 L
s
.32281 .84606 m
.33116 .84841 L
s
.27043 .60396 m
.25912 .61514 L
s
.32029 .85619 m
.32977 .85874 L
s
.5104 .72652 m
.50535 .71849 L
s
.74504 .96983 m
.72889 .96575 L
s
.63749 .84964 m
.62939 .8416 L
s
.59995 .80985 m
.59323 .80107 L
s
.31397 .97242 m
.33657 .97398 L
s
.56567 .77678 m
.55981 .76779 L
s
.62306 .83443 m
.61563 .82609 L
s
.63084 .8426 m
.62306 .83443 L
s
.71917 .93997 m
.70528 .93449 L
s
.2584 .57502 m
.24462 .58796 L
s
.30347 .65821 m
.2967 .66475 L
s
.27845 .61805 m
.26839 .62811 L
s
.5174 .73269 m
.51226 .72443 L
s
.52062 .73565 m
.51544 .72729 L
s
.27868 .62862 m
.26937 .63865 L
s
.31941 .88971 m
.33232 .892 L
s
.52863 .74284 m
.52335 .73428 L
s
.28179 .62586 m
.27236 .63545 L
s
.74584 .97129 m
.7295 .96712 L
s
.24172 .53557 m
.22441 .55092 L
s
.66613 .87953 m
.65621 .87207 L
s
.71012 .92985 m
.69693 .92389 L
s
.31986 .87602 m
.33132 .87847 L
s
.59873 .80902 m
.59197 .80014 L
s
.2895 .64131 m
.28133 .6498 L
s
.60515 .81648 m
.59821 .80766 L
s
.29876 .65515 m
.29171 .66235 L
s
.5024 .72001 m
.49733 .71216 L
s
.26036 .58212 m
.24717 .59484 L
s
.62154 .83325 m
.61406 .82477 L
s
.53115 .74531 m
.5258 .73666 L
s
.29123 .66837 m
.28504 .67656 L
s
.51094 .72734 m
.50579 .71921 L
s
.31742 .90944 m
.33254 .91179 L
s
.67663 .89265 m
.66592 .88537 L
s
.26303 .58989 m
.25049 .60226 L
s
.28775 .65837 m
.28078 .66711 L
s
.55376 .76607 m
.54802 .75705 L
s
.46381 .68998 m
.4587 .6837 L
s
.50119 .71919 m
.49609 .71136 L
s
.31798 .87858 m
.32982 .88131 L
s
.28536 .65154 m
.27786 .66064 L
s
.31113 .98213 m
.33512 .9841 L
s
.70609 .92523 m
.69311 .91897 L
s
.62939 .8416 m
.62154 .83325 L
s
.26897 .6012 m
.25745 .61273 L
s
.41998 .66336 m
.41438 .65954 L
s
.75113 .9782 m
.73413 .97414 L
s
.31305 .95941 m
.33415 .96158 L
s
.31695 .89579 m
.33064 .89846 L
s
.28091 .63971 m
.27246 .6495 L
s
.64673 .86042 m
.63788 .85231 L
s
.50509 .7226 m
.49994 .7146 L
s
.31764 .85203 m
.32682 .85519 L
s
.31558 .92253 m
.33225 .92501 L
s
.5868 .79796 m
.58025 .78882 L
s
.52706 .74198 m
.52169 .73335 L
s
.30979 .66363 m
.30346 .66945 L
s
.24473 .54725 m
.22842 .56233 L
s
.24243 .54209 m
.22564 .5575 L
s
.57746 .78955 m
.57113 .78033 L
s
.24823 .55689 m
.23277 .57149 L
s
.27911 .63713 m
.27044 .64723 L
s
.4947 .71415 m
.48956 .70648 L
s
.5021 .72032 m
.49692 .71239 L
s
.31404 .93214 m
.33191 .93474 L
s
.24871 .55861 m
.2334 .57315 L
s
.65082 .86356 m
.64164 .8555 L
s
.31303 .9444 m
.33237 .94695 L
s
.30591 .66384 m
.29955 .67018 L
s
.5267 .74173 m
.52129 .73307 L
s
.31947 .84191 m
.32754 .84502 L
s
.56373 .77601 m
.55768 .7668 L
s
.72726 .95064 m
.71232 .94514 L
s
.31609 .88621 m
.32881 .88923 L
s
.46331 .68997 m
.45812 .68366 L
s
.74194 .96789 m
.72565 .96312 L
s
.31442 .91897 m
.33077 .92177 L
s
.41176 .65978 m
.40599 .65649 L
s
.31627 .86231 m
.32653 .86563 L
s
.26345 .59293 m
.25118 .60536 L
s
.27548 .62902 m
.26614 .6397 L
s
.26616 .60392 m
.25476 .61597 L
s
.49191 .7121 m
.48672 .7045 L
s
.65443 .86936 m
.64494 .86123 L
s
.2881 .66811 m
.28187 .67692 L
s
.3156 .86946 m
.3266 .87284 L
s
.59183 .80346 m
.585 .79421 L
s
.79244 1.02947 m
.77086 1.0278 L
s
.31523 .88239 m
.32759 .88567 L
s
.28067 .64609 m
.2727 .65604 L
s
.49322 .7133 m
.488 .70562 L
s
.58623 .79812 m
.57953 .78881 L
s
.50128 .72 m
.49602 .71202 L
s
.54385 .75781 m
.53809 .74871 L
s
.21732 .48869 m
.1953 .50785 L
s
.39309 .65321 m
.38699 .65123 L
s
.26656 .6077 m
.25545 .61976 L
s
.58283 .79488 m
.57621 .78553 L
s
.67821 .89468 m
.66706 .88711 L
s
.67092 .88656 m
.66026 .87877 L
s
.25002 .56623 m
.23533 .58072 L
s
.73975 .96605 m
.72347 .96093 L
s
.26861 .61402 m
.25801 .6258 L
s
.6073 .81896 m
.59995 .80985 L
s
.30892 .9714 m
.33177 .97423 L
s
.61268 .82551 m
.60515 .81648 L
s
.2517 .56947 m
.23733 .58372 L
s
.50071 .71966 m
.49542 .71167 L
s
.31634 .85603 m
.32593 .85956 L
s
.55174 .76558 m
.5458 .75633 L
s
.57564 .78809 m
.56916 .77869 L
s
.23026 .51971 m
.21127 .53707 L
s
.65029 .86383 m
.64095 .85553 L
s
.26403 .6027 m
.25248 .61517 L
s
.57195 .78457 m
.56556 .77517 L
s
.60102 .81381 m
.59384 .80455 L
s
.68595 .9037 m
.67416 .89629 L
s
.56693 .77978 m
.56065 .77039 L
s
.30875 .96962 m
.33138 .97255 L
s
.49581 .71568 m
.49054 .70786 L
s
.56054 .77374 m
.5544 .76438 L
s
.27138 .61591 m
.26101 .62731 L
s
.22981 .51958 m
.21079 .53704 L
s
.78051 1.01541 m
.76003 1.01265 L
s
.31336 .89238 m
.32687 .89592 L
s
.54758 .76165 m
.54167 .75242 L
s
.54193 .75641 m
.53612 .74726 L
s
.25307 .57482 m
.23914 .58893 L
s
.48335 .70569 m
.47807 .69835 L
s
.47747 .7011 m
.4722 .69402 L
s
.60615 .81825 m
.59873 .80902 L
s
.31242 .90067 m
.32687 .90427 L
s
.63788 .85231 m
.62916 .84363 L
s
.55205 .76628 m
.54601 .75694 L
s
.44282 .67678 m
.43734 .67149 L
s
.26905 .61335 m
.25844 .62516 L
s
.53403 .74953 m
.52829 .74049 L
s
.33042 .87943 m
.3413 .88096 L
s
.2967 .66475 m
.29031 .67251 L
s
.28334 .66234 m
.27663 .67201 L
s
.25898 .59391 m
.24666 .60723 L
s
.58654 .7999 m
.57964 .79037 L
s
.26835 .61931 m
.25816 .63126 L
s
.31153 .90225 m
.3262 .90604 L
s
.40168 .65613 m
.39565 .65353 L
s
.54296 .75796 m
.53705 .74871 L
s
.30801 .95846 m
.32934 .96188 L
s
.55213 .76637 m
.54603 .75697 L
s
.5358 .75119 m
.52999 .74207 L
s
.3124 .86527 m
.32312 .8694 L
s
.31222 .87505 m
.32396 .8791 L
s
.29934 1.03982 m
.33182 1.04285 L
s
.47929 .70282 m
.47394 .6956 L
s
.3095 .93143 m
.32756 .93512 L
s
.30346 .66945 m
.29746 .67632 L
s
.24297 .55625 m
.2273 .57198 L
s
.24487 .55983 m
.22955 .57528 L
s
.31456 .84194 m
.32281 .84606 L
s
.30585 .97643 m
.32953 .9799 L
s
.30791 .95311 m
.32861 .9567 L
s
.49756 .71774 m
.49214 .70973 L
s
.62071 .83463 m
.61268 .82551 L
s
.24364 .55747 m
.22809 .57312 L
s
.31178 .8611 m
.32211 .86542 L
s
.46991 .69576 m
.46453 .68897 L
s
.2812 .65996 m
.27429 .67003 L
s
.89767 1.16846 m
.86216 1.17649 L
s
.64164 .8555 m
.63255 .84675 L
s
.27141 .63115 m
.26218 .64271 L
s
.31361 .84828 m
.32253 .8525 L
s
.66148 .87741 m
.65113 .86901 L
s
.75045 .98025 m
.73273 .97522 L
s
.29171 .66235 m
.2851 .6709 L
s
.70683 .92943 m
.69303 .92232 L
s
.52237 .73943 m
.51667 .73055 L
s
.72763 .95329 m
.71201 .94705 L
s
.62916 .84363 m
.62071 .83463 L
s
.78208 1.01881 m
.76102 1.01567 L
s
.74846 .9781 m
.73087 .97289 L
s
.29955 .67018 m
.29357 .67764 L
s
.61525 .82826 m
.6073 .81896 L
s
.31089 .85158 m
.32029 .85619 L
s
.23079 .52999 m
.21264 .5476 L
s
.72621 .95196 m
.71069 .94561 L
s
.31032 .90002 m
.3248 .90417 L
s
.66417 .88193 m
.65353 .87344 L
s
.2765 .63685 m
.2678 .64771 L
s
.25801 .59802 m
.24598 .61166 L
s
.26291 .6062 m
.25164 .6191 L
s
.28504 .67656 m
.27945 .6861 L
s
.70457 .92675 m
.69086 .91946 L
s
.68064 .89942 m
.66881 .89135 L
s
.65621 .87207 m
.64608 .86342 L
s
.26207 .60486 m
.25068 .61789 L
s
.27702 .65198 m
.26946 .66278 L
s
.59414 .80764 m
.5868 .79796 L
s
.66254 .87915 m
.65197 .87061 L
s
.24839 .57284 m
.23418 .58791 L
s
.57241 .78654 m
.56567 .77678 L
s
.64494 .86123 m
.63547 .85229 L
s
.30696 .93309 m
.32538 .93736 L
s
.30966 .8907 m
.32316 .89516 L
s
.64095 .85553 m
.63171 .84657 L
s
.60886 .82338 m
.60102 .81381 L
s
.61418 .8277 m
.60615 .81825 L
s
.28133 .6498 m
.27368 .65999 L
s
.54579 .76156 m
.53961 .75204 L
s
.30762 .9222 m
.32473 .92656 L
s
.30144 .99336 m
.3276 .99746 L
s
.5994 .81317 m
.59183 .80346 L
s
.28078 .66711 m
.27443 .67738 L
s
.26943 .62469 m
.2597 .63669 L
s
.1989 .4597 m
.17363 .48208 L
s
.50987 .72902 m
.50419 .72041 L
s
.30812 .89408 m
.32209 .89878 L
s
.30721 .92031 m
.32413 .92481 L
s
.31159 .83709 m
.31947 .84191 L
s
.2909 1.07904 m
.32971 1.08279 L
s
.67656 .89545 m
.66486 .88708 L
s
.63255 .84675 m
.6237 .83759 L
s
.30861 .84688 m
.31764 .85203 L
s
.23205 .53829 m
.21461 .55589 L
s
.58464 .79944 m
.57746 .78955 L
s
.25221 .58842 m
.23931 .60307 L
s
.6237 .83759 m
.61525 .82826 L
s
.27786 .66064 m
.27098 .67142 L
s
.30782 .90069 m
.32251 .90541 L
s
.71362 .93846 m
.69891 .93123 L
s
.75001 .98121 m
.73192 .97568 L
s
.26659 .62774 m
.25702 .64025 L
s
.46035 .68946 m
.45478 .68303 L
s
.47382 .6995 m
.46827 .69237 L
s
.70562 .92894 m
.69157 .92139 L
s
.68286 .90289 m
.67062 .8946 L
s
.59373 .808 m
.58623 .79812 L
s
.23997 .55918 m
.22445 .57568 L
s
.29271 1.05918 m
.32851 1.06328 L
s
.5231 .74099 m
.51719 .73189 L
s
.48012 .70448 m
.47455 .69703 L
s
.27236 .63545 m
.2635 .6471 L
s
.30839 .87098 m
.31986 .87602 L
s
.72525 .95207 m
.70942 .94523 L
s
.30626 .90514 m
.32154 .9101 L
s
.26671 .63017 m
.25733 .64271 L
s
.28187 .67692 m
.2763 .68711 L
s
.50352 .72394 m
.4978 .71548 L
s
.59028 .80483 m
.58283 .79488 L
s
.29864 1.00237 m
.32619 1.00692 L
s
.26937 .63865 m
.26069 .6508 L
s
.29937 .99497 m
.32591 .99955 L
s
.23444 .54701 m
.21779 .56438 L
s
.50898 .72873 m
.50319 .72005 L
s
.4573 .68747 m
.45166 .68118 L
s
.26839 .62811 m
.2589 .6404 L
s
.56043 .77598 m
.55376 .76607 L
s
.39932 .65564 m
.39309 .65321 L
s
.74236 .9727 m
.72485 .96657 L
s
.62273 .83721 m
.61418 .8277 L
s
.52421 .74239 m
.51822 .7332 L
s
.63171 .84657 m
.62273 .83721 L
s
.27246 .6495 m
.26466 .66121 L
s
.29746 .67632 m
.2919 .68428 L
s
.42587 .66771 m
.41998 .66336 L
s
.29715 1.01118 m
.32598 1.01584 L
s
.66592 .88537 m
.65476 .87647 L
s
.69565 .91811 m
.68225 .91002 L
s
.30442 .92116 m
.32162 .92628 L
s
.23123 .54178 m
.21405 .5597 L
s
.5707 .78604 m
.56373 .77601 L
s
.25514 .60179 m
.24335 .61615 L
s
.30616 .87315 m
.31798 .87858 L
s
.30098 .96785 m
.32397 .97278 L
s
.29031 .67251 m
.28443 .68153 L
s
.30615 .8567 m
.31627 .86231 L
s
.30642 .88441 m
.31941 .88971 L
s
.61728 .83312 m
.60886 .82338 L
s
.69457 .91762 m
.6812 .90942 L
s
.29658 1.0106 m
.32538 1.01543 L
s
.51633 .73552 m
.5104 .72652 L
s
.53484 .75236 m
.52863 .74284 L
s
.2376 .55754 m
.22189 .57455 L
s
.69049 .91245 m
.67744 .90413 L
s
.29901 .98611 m
.32444 .99106 L
s
.41778 .66358 m
.41176 .65978 L
s
.63547 .85229 m
.62619 .84283 L
s
.58299 .7982 m
.57564 .78809 L
s
.30035 .96919 m
.32355 .97426 L
s
.52672 .74499 m
.52062 .73565 L
s
.59423 .80999 m
.58654 .7999 L
s
.52346 .74194 m
.5174 .73269 L
s
.27044 .64723 m
.26245 .65932 L
s
.24401 .5741 m
.2298 .59019 L
s
.25912 .61514 m
.24846 .62897 L
s
.53745 .75493 m
.53115 .74531 L
s
.30693 .8504 m
.31634 .85603 L
s
.57924 .79473 m
.57195 .78457 L
s
.30354 .91473 m
.32006 .92018 L
s
.30385 .9081 m
.3196 .91358 L
s
.29357 .67764 m
.28809 .68623 L
s
.3014 .94702 m
.32182 .95235 L
s
.2727 .65604 m
.26542 .66782 L
s
.30027 .9602 m
.32237 .9655 L
s
.3047 .86359 m
.3156 .86946 L
s
.66026 .87877 m
.64932 .86958 L
s
.69321 .91665 m
.6798 .90823 L
s
.24707 .58373 m
.2337 .59942 L
s
.57413 .78998 m
.56693 .77978 L
s
.76112 .99626 m
.74143 .99078 L
s
.30135 .93964 m
.3209 .94514 L
s
.50834 .72882 m
.5024 .72001 L
s
.29853 .97519 m
.32262 .98057 L
s
.51698 .73646 m
.51094 .72734 L
s
.30346 .90807 m
.31922 .91368 L
s
.30252 .91769 m
.31943 .92333 L
s
.62619 .84283 m
.61728 .83312 L
s
.30658 .83604 m
.31456 .84194 L
s
.60223 .81779 m
.59414 .80764 L
s
.46956 .69706 m
.46381 .68998 L
s
.2851 .6709 m
.27908 .68082 L
s
.60769 .82326 m
.5994 .81317 L
s
.24626 .58537 m
.23298 .60125 L
s
.27663 .67201 m
.27066 .68323 L
s
.53339 .75161 m
.52706 .74198 L
s
.26614 .6397 m
.25751 .65256 L
s
.30318 .88987 m
.31695 .89579 L
s
.30167 .92842 m
.31987 .9341 L
s
.64608 .86342 m
.63596 .85391 L
s
.50715 .72799 m
.50119 .71919 L
s
.30337 .88022 m
.31609 .88621 L
s
.65113 .86901 m
.64069 .85956 L
s
.56764 .78397 m
.56054 .77374 L
s
.23829 .56528 m
.22322 .58239 L
s
.30089 .931 m
.31945 .93679 L
s
.30291 .87624 m
.31523 .88239 L
s
.68381 .90596 m
.67099 .89711 L
s
.51114 .73158 m
.50509 .7226 L
s
.53307 .7514 m
.5267 .74173 L
s
.71288 .93979 m
.69765 .93184 L
s
.23831 .56728 m
.22339 .58442 L
s
.24099 .57409 m
.22669 .59083 L
s
.55865 .77576 m
.55174 .76558 L
s
.25745 .61273 m
.24659 .62695 L
s
.40792 .65924 m
.40168 .65613 L
s
.30496 .84211 m
.31361 .84828 L
s
.66706 .88711 m
.65545 .87784 L
s
.55059 .76787 m
.54385 .75781 L
s
.71579 .94304 m
.70026 .93516 L
s
.30211 .90342 m
.31742 .90944 L
s
.71492 .94236 m
.69945 .93442 L
s
.27945 .6861 m
.27462 .69695 L
s
.50816 .72925 m
.5021 .72032 L
s
.27429 .67003 m
.26815 .68172 L
s
.46915 .69709 m
.46331 .68997 L
s
.50069 .72278 m
.4947 .71415 L
s
.29857 .94653 m
.31913 .95258 L
s
.72176 .95035 m
.70561 .94261 L
s
.65197 .87061 m
.64131 .86099 L
s
.30188 .85871 m
.3124 .86527 L
s
.55448 .77185 m
.54758 .76165 L
s
.30178 .84489 m
.31089 .85158 L
s
.65353 .87344 m
.64275 .8638 L
s
.30169 .85447 m
.31178 .8611 L
s
.55907 .77657 m
.55205 .76628 L
s
.602 .81835 m
.59373 .808 L
s
.25049 .60226 m
.23866 .61767 L
s
.2962 .97126 m
.31997 .97734 L
s
.20147 .48241 m
.17826 .50518 L
s
.72913 .95929 m
.71223 .95177 L
s
.54873 .76655 m
.54193 .75641 L
s
.24462 .58796 m
.23152 .60429 L
s
.24717 .59484 m
.23468 .61079 L
s
.30407 .83057 m
.31159 .83709 L
s
.2919 .68428 m
.28691 .6933 L
s
.49794 .72068 m
.49191 .7121 L
s
.59266 .80995 m
.58464 .79944 L
s
.25476 .61597 m
.2441 .63079 L
s
.29685 .95646 m
.31874 .96274 L
s
.55921 .77671 m
.55213 .76637 L
s
.26101 .62731 m
.25137 .64114 L
s
.30064 .86829 m
.31222 .87505 L
s
.31949 .87546 m
.33042 .87943 L
s
.25801 .6258 m
.24819 .64013 L
s
.58008 .79708 m
.57241 .78654 L
s
.49929 .72196 m
.49322 .7133 L
s
.50744 .729 m
.50128 .72 L
s
.59853 .81533 m
.59028 .80483 L
s
.29711 .94652 m
.31777 .95296 L
s
.29988 .88563 m
.31336 .89238 L
s
.25545 .61976 m
.2451 .63451 L
s
.27443 .67738 m
.26889 .68916 L
s
.29995 .83974 m
.30861 .84688 L
s
.54988 .76822 m
.54296 .75796 L
s
.61661 .83355 m
.60769 .82326 L
s
.25118 .60536 m
.23962 .62077 L
s
.67416 .89629 m
.66173 .88682 L
s
.54076 .75961 m
.53403 .74953 L
s
.5069 .72867 m
.50071 .71966 L
s
.29864 .91588 m
.31558 .92253 L
s
.27368 .65999 m
.26674 .67191 L
s
.26946 .66278 m
.26272 .67538 L
s
.44881 .6828 m
.44282 .67678 L
s
.63596 .85391 m
.62609 .84385 L
s
.50197 .72451 m
.49581 .71568 L
s
.60271 .82056 m
.59423 .80999 L
s
.28443 .68153 m
.27923 .69178 L
s
.5426 .76135 m
.5358 .75119 L
s
.2678 .64771 m
.25985 .66057 L
s
.2763 .68711 m
.27156 .69865 L
s
.25844 .62516 m
.24859 .63949 L
s
.29786 .9121 m
.31442 .91897 L
s
.23311 .56332 m
.21775 .58156 L
s
.61103 .82827 m
.60223 .81779 L
s
.28809 .68623 m
.28325 .69593 L
s
.26218 .64271 m
.25376 .65651 L
s
.25248 .61517 m
.24172 .63047 L
s
.25816 .63126 m
.24878 .64568 L
s
.22167 .5368 m
.20379 .55681 L
s
.48353 .70913 m
.47747 .7011 L
s
.48944 .714 m
.48335 .70569 L
s
.27098 .67142 m
.26495 .68384 L
s
.29796 .89355 m
.31242 .90067 L
s
.70638 .93389 m
.69119 .9251 L
s
.64069 .85956 m
.6304 .84941 L
s
.72724 .95866 m
.71011 .95058 L
s
.29586 .92499 m
.31404 .93214 L
s
.62609 .84385 m
.61661 .83355 L
s
.59123 .80898 m
.58299 .7982 L
s
.29685 .89489 m
.31153 .90225 L
s
.75348 .99015 m
.73369 .98319 L
s
.69311 .91897 m
.67892 .90965 L
s
.65476 .87647 m
.64345 .86633 L
s
.48543 .71101 m
.47929 .70282 L
s
.66881 .89135 m
.65649 .88145 L
s
.69693 .92389 m
.68239 .91463 L
s
.55299 .7721 m
.54579 .76156 L
s
.52907 .74939 m
.52237 .73943 L
s
.64932 .86958 m
.63835 .85938 L
s
.50388 .72679 m
.49756 .71774 L
s
.40578 .65865 m
.39932 .65564 L
s
.769 1.00927 m
.7475 1.00306 L
s
.611 .82904 m
.602 .81835 L
s
.47603 .70349 m
.46991 .69576 L
s
.57863 .7969 m
.5707 .78604 L
s
.58745 .80561 m
.57924 .79473 L
s
.66486 .88708 m
.65279 .87706 L
s
.29156 .96954 m
.31548 .97688 L
s
.79995 1.04785 m
.7749 1.04357 L
s
.29641 .8488 m
.30615 .8567 L
s
.29908 .82843 m
.30658 .83604 L
s
.27908 .68082 m
.27382 .69207 L
s
.22328 .54691 m
.20629 .5669 L
s
.64131 .86099 m
.6308 .85064 L
s
.2597 .63669 m
.25079 .65103 L
s
.24666 .60723 m
.23517 .62365 L
s
.29793 .84267 m
.30693 .8504 L
s
.2972 .86328 m
.30839 .87098 L
s
.29122 .96786 m
.31495 .97534 L
s
.5681 .78681 m
.56043 .77598 L
s
.23277 .57149 m
.21807 .59006 L
s
.2334 .57315 m
.21885 .59163 L
s
.29328 .93681 m
.31303 .9444 L
s
.29629 .883 m
.30966 .8907 L
s
.29589 .89234 m
.31032 .90002 L
s
.62046 .83889 m
.61103 .82827 L
s
.2635 .6471 m
.25547 .66087 L
s
.64275 .8638 m
.63209 .85336 L
s
.26466 .66121 m
.25777 .67484 L
s
.22441 .55092 m
.20779 .5708 L
s
.28691 .6933 m
.28262 .70337 L
s
.25164 .6191 m
.24121 .63478 L
s
.58228 .80097 m
.57413 .78998 L
s
.6304 .84941 m
.62046 .83889 L
s
.23733 .58372 m
.22375 .60164 L
s
.29059 .9647 m
.31397 .97242 L
s
.26069 .6508 m
.25292 .6651 L
s
.27462 .69695 m
.2707 .709 L
s
.27066 .68323 m
.26561 .69593 L
s
.60756 .82624 m
.59853 .81533 L
s
.22842 .56233 m
.21287 .58165 L
s
.23533 .58072 m
.22146 .59898 L
s
.25702 .64025 m
.24836 .65514 L
s
.23914 .58893 m
.22603 .6066 L
s
.25068 .61789 m
.24013 .63376 L
s
.29136 .9516 m
.31305 .95941 L
s
.61191 .83146 m
.60271 .82056 L
s
.2968 .83405 m
.30496 .84211 L
s
.29464 .86495 m
.30616 .87315 L
s
.29429 .88599 m
.30812 .89408 L
s
.70528 .93449 m
.68976 .92516 L
s
.60151 .82098 m
.59266 .80995 L
s
.26542 .66782 m
.25909 .6814 L
s
.25733 .64271 m
.24888 .65759 L
s
.29419 .85521 m
.3047 .86359 L
s
.2589 .6404 m
.25029 .65501 L
s
.51654 .73874 m
.50987 .72902 L
s
.29709 .82245 m
.30407 .83057 L
s
.22564 .5575 m
.20961 .57732 L
s
.26245 .65932 m
.2554 .67341 L
s
.67062 .8946 m
.65786 .88437 L
s
.24598 .61166 m
.23485 .62835 L
s
.4322 .67279 m
.42587 .66771 L
s
.53004 .75121 m
.5231 .74099 L
s
.42417 .66808 m
.41778 .66358 L
s
.62064 .83989 m
.611 .82904 L
s
.57573 .79508 m
.56764 .78397 L
s
.2932 .83618 m
.30178 .84489 L
s
.76662 1.00795 m
.74492 1.00106 L
s
.65545 .87784 m
.6437 .86729 L
s
.28325 .69593 m
.27919 .70669 L
s
.18673 .46619 m
.1615 .49201 L
s
.29323 .89237 m
.30782 .90069 L
s
.28743 .98004 m
.31302 .98824 L
s
.46663 .69682 m
.46035 .68946 L
s
.6308 .85064 m
.62064 .83989 L
s
.29368 .87601 m
.30642 .88441 L
s
.29124 .92308 m
.3095 .93143 L
s
.26815 .68172 m
.26298 .69495 L
s
.75547 .99455 m
.73489 .987 L
s
.48017 .70764 m
.47382 .6995 L
s
.27923 .69178 m
.27485 .70321 L
s
.28592 .98952 m
.31286 .99788 L
s
.53125 .75272 m
.52421 .74239 L
s
.7304 .96462 m
.71232 .95589 L
s
.54212 .76301 m
.53484 .75236 L
s
.2862 .9856 m
.3126 .99398 L
s
.48654 .71297 m
.48012 .70448 L
s
.29187 .83071 m
.29995 .83974 L
s
.2921 .84554 m
.30169 .85447 L
s
.51022 .73354 m
.50352 .72394 L
s
.51576 .73855 m
.50898 .72873 L
s
.5448 .76567 m
.53745 .75493 L
s
.46362 .69469 m
.4573 .68747 L
s
.5887 .80836 m
.58008 .79708 L
s
.76114 1.00186 m
.73986 .99447 L
s
.63209 .85336 m
.62175 .84247 L
s
.29184 .84974 m
.30188 .85871 L
s
.63835 .85938 m
.62761 .84854 L
s
.5666 .78693 m
.55865 .77576 L
s
.62175 .84247 m
.61191 .83146 L
s
.29108 .89638 m
.30626 .90514 L
s
.27156 .69865 m
.26781 .7114 L
s
.26889 .68916 m
.26435 .70236 L
s
.53388 .75548 m
.52672 .74499 L
s
.25751 .65256 m
.24988 .66762 L
s
.41447 .66303 m
.40792 .65924 L
s
.2863 .97347 m
.31113 .98213 L
s
.29045 .91348 m
.30762 .9222 L
s
.28395 .99791 m
.31217 1.00658 L
s
.5233 .74568 m
.51633 .73552 L
s
.53057 .75234 m
.52346 .74194 L
s
.29025 .91151 m
.30721 .92031 L
s
.291 .87119 m
.30337 .88022 L
s
.61729 .83739 m
.60756 .82624 L
s
.60033 .82032 m
.59123 .80898 L
s
.29097 .86718 m
.30291 .87624 L
s
.22955 .57528 m
.21511 .59478 L
s
.5584 .779 m
.55059 .76787 L
s
.64345 .86633 m
.63226 .85536 L
s
.23931 .60307 m
.22737 .62108 L
s
.23418 .58791 m
.2209 .60672 L
s
.56713 .78785 m
.55907 .77657 L
s
.20188 .50881 m
.18098 .53264 L
s
.24846 .62897 m
.2388 .64555 L
s
.2273 .57198 m
.21253 .59189 L
s
.22809 .57312 m
.21344 .59289 L
s
.28262 .70337 m
.27916 .71438 L
s
.26674 .67191 m
.26076 .68552 L
s
.56244 .78309 m
.55448 .77185 L
s
.2884 .92403 m
.30696 .93309 L
s
.54079 .76239 m
.53339 .75161 L
s
.28969 .88061 m
.30318 .88987 L
s
.69303 .92232 m
.67803 .91203 L
s
.24335 .61615 m
.23256 .63358 L
s
.69086 .91946 m
.67603 .90911 L
s
.29224 .81921 m
.29908 .82843 L
s
.28545 .96227 m
.30892 .9714 L
s
.26272 .67538 m
.25702 .68972 L
s
.56736 .78807 m
.55921 .77671 L
s
.28683 .94397 m
.30791 .95311 L
s
.28551 .96046 m
.30875 .96962 L
s
.67744 .90413 m
.66368 .89348 L
s
.52408 .74676 m
.51698 .73646 L
s
.61113 .83237 m
.60151 .82098 L
s
.73331 .96935 m
.71458 .96031 L
s
.28952 .85882 m
.30064 .86829 L
s
.734 .97022 m
.71519 .96119 L
s
.54053 .76223 m
.53307 .7514 L
s
.28623 .94926 m
.30801 .95846 L
s
.26495 .68384 m
.25997 .69784 L
s
.59656 .81714 m
.58745 .80561 L
s
.62761 .84854 m
.61729 .83739 L
s
.5153 .73881 m
.50834 .72882 L
s
.27382 .69207 m
.26949 .70459 L
s
.55661 .77778 m
.54873 .76655 L
s
.28824 .89866 m
.30385 .9081 L
s
.67099 .89711 m
.65764 .88625 L
s
.68225 .91002 m
.668 .89934 L
s
.71232 .94514 m
.69548 .93521 L
s
.1888 .48169 m
.16504 .50771 L
s
.51414 .73799 m
.50715 .72799 L
s
.47612 .70519 m
.46956 .69706 L
s
.28725 .91163 m
.30442 .92116 L
s
.6812 .90942 m
.66701 .89867 L
s
.73127 .96754 m
.7126 .95824 L
s
.30876 .86899 m
.31949 .87546 L
s
.66173 .88682 m
.64903 .87577 L
s
.73722 .97467 m
.71794 .96559 L
s
.2707 .709 m
.26786 .7221 L
s
.25985 .66057 m
.25291 .67545 L
s
.21127 .53707 m
.19312 .55968 L
s
.28787 .89849 m
.30346 .90807 L
s
.51822 .74176 m
.51114 .73158 L
s
.29083 .81287 m
.29709 .82245 L
s
.28713 .90508 m
.30354 .91473 L
s
.58754 .80856 m
.57863 .7969 L
s
.28958 .83295 m
.29793 .84267 L
s
.24659 .62695 m
.23676 .644 L
s
.55789 .77958 m
.54988 .76822 L
s
.27919 .70669 m
.27603 .71839 L
s
.21079 .53704 m
.19263 .55977 L
s
.28732 .83872 m
.29641 .8488 L
s
.65279 .87706 m
.64065 .86583 L
s
.6798 .90823 m
.66562 .89733 L
s
.28933 .82422 m
.2968 .83405 L
s
.25137 .64114 m
.24276 .65746 L
s
.59141 .81272 m
.58228 .80097 L
s
.69157 .92139 m
.67638 .9107 L
s
.28702 .89357 m
.30211 .90342 L
s
.51526 .73939 m
.50816 .72925 L
s
.28679 .87561 m
.29988 .88563 L
s
.65649 .88145 m
.64404 .87018 L
s
.63226 .85536 m
.62143 .84393 L
s
.54859 .77085 m
.54076 .75961 L
s
.26561 .69593 m
.26167 .70999 L
s
.28571 .90771 m
.30252 .91769 L
s
.25376 .65651 m
.24646 .67252 L
s
.5077 .73262 m
.50069 .72278 L
s
.6437 .86729 m
.6321 .85589 L
s
.47581 .7053 m
.46915 .69709 L
s
.27485 .70321 m
.27145 .71571 L
s
.24819 .64013 m
.23947 .65706 L
s
.62143 .84393 m
.61113 .83237 L
s
.75364 .99522 m
.73244 .98658 L
s
.55052 .77267 m
.5426 .76135 L
s
.22445 .57568 m
.20994 .59642 L
s
.28538 .82562 m
.2932 .83618 L
s
.28156 .96632 m
.30585 .97643 L
s
.61025 .83208 m
.60033 .82032 L
s
.57684 .7986 m
.5681 .78681 L
s
.2337 .59942 m
.22138 .61871 L
s
.72889 .96575 m
.71013 .95597 L
s
.2441 .63079 m
.23456 .64844 L
s
.27916 .71438 m
.27665 .72621 L
s
.2298 .59019 m
.21663 .61012 L
s
.50497 .73047 m
.49794 .72068 L
s
.28659 .85297 m
.2972 .86328 L
s
.2846 .81996 m
.29187 .83071 L
s
.21264 .5476 m
.19545 .57027 L
s
.2451 .63451 m
.23589 .65203 L
s
.24859 .63949 m
.23983 .6564 L
s
.27132 1.0613 m
.30962 1.0716 L
s
.24878 .64568 m
.24054 .66261 L
s
.51465 .73923 m
.50744 .729 L
s
.41259 .66242 m
.40578 .65865 L
s
.5613 .78375 m
.55299 .7721 L
s
.25777 .67484 m
.25205 .69031 L
s
.23298 .60125 m
.22081 .62073 L
s
.59825 .8203 m
.5887 .80836 L
s
.50638 .73186 m
.49929 .72196 L
s
.26781 .7114 m
.26521 .7252 L
s
.23866 .61767 m
.22795 .63626 L
s
.28351 .91798 m
.30167 .92842 L
s
.69891 .93123 m
.6828 .92037 L
s
.28436 .84443 m
.29419 .85521 L
s
.51414 .73893 m
.5069 .72867 L
s
.26298 .69495 m
.25897 .7096 L
s
.25909 .6814 m
.25393 .6967 L
s
.4555 .68983 m
.44881 .6828 L
s
.7295 .96712 m
.71052 .95718 L
s
.58485 .80706 m
.57573 .79508 L
s
.25547 .66087 m
.24855 .67673 L
s
.2687 1.07427 m
.3092 1.08487 L
s
.2839 .88286 m
.29796 .89355 L
s
.1953 .50785 m
.17411 .53336 L
s
.21461 .55589 m
.19819 .57838 L
s
.27297 1.03637 m
.30751 1.04704 L
s
.50916 .73459 m
.50197 .72451 L
s
.28623 .80859 m
.29224 .81921 L
s
.28237 .92032 m
.30089 .931 L
s
.26435 .70236 m
.26099 .71682 L
s
.28375 .85405 m
.29464 .86495 L
s
.22189 .57455 m
.20724 .5959 L
s
.21779 .56438 m
.20218 .58639 L
s
.28175 .92892 m
.30135 .93964 L
s
.28327 .83448 m
.2921 .84554 L
s
.23962 .62077 m
.2292 .63928 L
s
.60655 .82917 m
.59656 .81714 L
s
.25079 .65103 m
.24303 .66773 L
s
.24172 .63047 m
.23214 .64869 L
s
.23468 .61079 m
.22334 .63015 L
s
.25292 .6651 m
.24636 .6815 L
s
.65786 .88437 m
.64493 .87269 L
s
.2554 .67341 m
.24955 .68941 L
s
.28084 .93616 m
.3014 .94702 L
s
.72565 .96312 m
.70688 .95285 L
s
.27603 .71839 m
.27391 .73089 L
s
.28544 .80204 m
.29083 .81287 L
s
.71069 .94561 m
.69332 .93484 L
s
.2826 .88388 m
.29685 .89489 L
s
.28256 .83851 m
.29184 .84974 L
s
.49652 .72355 m
.48944 .714 L
s
.5369 .76061 m
.52907 .74939 L
s
.49053 .71836 m
.48353 .70913 L
s
.28343 .87205 m
.29629 .883 L
s
.22669 .59083 m
.21353 .61153 L
s
.71201 .94705 m
.6945 .93629 L
s
.6321 .85589 m
.62088 .84404 L
s
.26949 .70459 m
.26626 .71822 L
s
.23152 .60429 m
.21959 .62422 L
s
.62088 .84404 m
.61025 .83208 L
s
.28193 .90486 m
.29864 .91588 L
s
.26786 .7221 m
.26622 .73605 L
s
.28157 .90098 m
.29786 .9121 L
s
.72347 .96093 m
.7048 .95045 L
s
.22322 .58239 m
.20928 .60368 L
s
.21405 .5597 m
.19795 .58247 L
s
.24836 .65514 m
.24094 .6724 L
s
.22339 .58442 m
.20962 .60572 L
s
.25029 .65501 m
.24287 .67193 L
s
.24888 .65759 m
.24167 .67479 L
s
.28193 .88109 m
.29589 .89234 L
s
.57564 .7991 m
.5666 .78693 L
s
.51128 .73714 m
.50388 .72679 L
s
.64065 .86583 m
.62875 .85384 L
s
.27665 .72621 m
.2752 .7387 L
s
.26076 .68552 m
.25595 .70072 L
s
.27764 .95648 m
.30098 .96785 L
s
.49256 .72045 m
.48543 .71101 L
s
.28101 .87451 m
.29429 .88599 L
s
.28275 .81283 m
.28933 .82422 L
s
.27793 .94876 m
.30027 .9602 L
s
.27145 .71571 m
.26916 .7291 L
s
.73413 .97414 m
.71425 .96385 L
s
.25997 .69784 m
.25625 .71325 L
s
.28155 .86454 m
.29368 .87601 L
s
.48308 .71243 m
.47603 .70349 L
s
.59743 .82091 m
.58754 .80856 L
s
.28209 .82143 m
.28958 .83295 L
s
.2768 .9576 m
.30035 .96919 L
s
.60147 .82509 m
.59141 .81272 L
s
.25702 .68972 m
.25261 .70567 L
s
.24121 .63478 m
.23201 .65331 L
s
.5763 .80015 m
.56713 .78785 L
s
.27797 .93489 m
.29857 .94653 L
s
.27457 .98165 m
.30144 .99336 L
s
.67892 .90965 m
.66401 .89781 L
s
.27974 .85529 m
.29097 .86718 L
s
.64903 .87577 m
.6364 .86363 L
s
.64404 .87018 m
.63175 .85802 L
s
.27913 .82664 m
.28732 .83872 L
s
.27832 .80773 m
.2846 .81996 L
s
.70942 .94523 m
.6918 .93398 L
s
.4311 .6735 m
.42417 .66808 L
s
.27853 .81342 m
.28538 .82562 L
s
.24988 .66762 m
.24355 .6848 L
s
.24013 .63376 m
.23084 .65252 L
s
.61732 .8415 m
.60655 .82917 L
s
.53815 .76273 m
.53004 .75121 L
s
.69765 .93184 m
.68106 .92026 L
s
.23517 .62365 m
.22496 .64327 L
s
.26167 .70999 m
.25902 .72521 L
s
.27932 .85921 m
.291 .87119 L
s
.60868 .83272 m
.59825 .8203 L
s
.27919 .84677 m
.28952 .85882 L
s
.55056 .7749 m
.54212 .76301 L
s
.57661 .80044 m
.56736 .78807 L
s
.28121 .79681 m
.28623 .80859 L
s
.56735 .79125 m
.5584 .779 L
s
.55333 .77764 m
.5448 .76567 L
s
.57153 .79541 m
.56244 .78309 L
s
.43914 .67886 m
.4322 .67279 L
s
.52435 .7498 m
.51654 .73874 L
s
.26521 .7252 m
.2639 .73981 L
s
.27791 .91304 m
.29586 .92499 L
s
.27391 .73089 m
.27292 .74398 L
s
.28108 .79021 m
.28544 .80204 L
s
.27919 .88041 m
.29323 .89237 L
s
.68239 .91463 m
.66703 .90264 L
s
.27646 .93444 m
.29711 .94652 L
s
.53946 .76437 m
.53125 .75272 L
s
.4215 .66772 m
.41447 .66303 L
s
.69945 .93442 m
.68257 .92271 L
s
.62875 .85384 m
.61732 .8415 L
s
.70026 .93516 m
.68329 .92347 L
s
.2752 .7387 m
.27488 .75161 L
s
.27408 .96295 m
.29853 .97519 L
s
.27305 .97379 m
.29901 .98611 L
s
.65764 .88625 m
.64417 .8739 L
s
.27217 .9826 m
.29937 .99497 L
s
.25291 .67545 m
.24727 .69223 L
s
.54223 .76727 m
.53388 .75548 L
s
.26622 .73605 m
.26589 .75057 L
s
.23485 .62835 m
.22505 .64819 L
s
.27487 .9441 m
.29685 .95646 L
s
.56567 .79017 m
.55661 .77778 L
s
.21775 .58156 m
.20365 .60421 L
s
.26099 .71682 m
.25897 .73231 L
s
.53887 .76407 m
.53057 .75234 L
s
.4738 .70541 m
.46663 .69682 L
s
.27691 .86805 m
.28969 .88061 L
s
.5237 .74974 m
.51576 .73855 L
s
.25897 .7096 m
.25633 .72545 L
s
.54939 .77446 m
.54079 .76239 L
s
.58665 .81129 m
.57684 .7986 L
s
.69119 .9251 m
.67488 .91305 L
s
.26626 .71822 m
.26427 .73278 L
s
.66368 .89348 m
.64964 .88106 L
s
.27648 .88379 m
.29108 .89638 L
s
.51805 .74452 m
.51022 .73354 L
s
.595 .81982 m
.58485 .80706 L
s
.29851 .86001 m
.30876 .86899 L
s
.53145 .7572 m
.5233 .74568 L
s
.48752 .71709 m
.48017 .70764 L
s
.27033 .98963 m
.29864 1.00237 L
s
.79827 1.05517 m
.77058 1.04729 L
s
.26916 .7291 m
.2681 .74317 L
s
.27546 .82151 m
.28327 .83448 L
s
.56706 .79209 m
.55789 .77958 L
s
.27782 .77766 m
.28108 .79021 L
s
.49399 .7228 m
.48654 .71297 L
s
.27725 .80014 m
.28275 .81283 L
s
.2755 .83146 m
.28436 .84443 L
s
.54919 .77436 m
.54053 .76223 L
s
.47082 .70314 m
.46362 .69469 L
s
.75598 1.00269 m
.73316 .9925 L
s
.2773 .78414 m
.28121 .79681 L
s
.22603 .6066 m
.21426 .628 L
s
.27689 .84024 m
.28659 .85297 L
s
.27292 .74398 m
.27314 .75741 L
s
.2388 .64555 m
.23053 .66489 L
s
.27217 .9584 m
.2962 .97126 L
s
.27488 .75161 m
.27575 .76469 L
s
.61989 .8454 m
.60868 .83272 L
s
.64493 .87269 m
.63218 .86006 L
s
.63175 .85802 m
.61989 .8454 L
s
.22375 .60164 m
.21151 .62346 L
s
.27321 .79431 m
.27832 .80773 L
s
.25393 .6967 m
.25017 .71353 L
s
.61241 .83789 m
.60147 .82509 L
s
.25205 .69031 m
.24773 .70747 L
s
.27372 .92386 m
.29328 .93681 L
s
.70561 .94261 m
.68782 .93063 L
s
.2743 .82524 m
.28256 .83851 L
s
.26545 1.02661 m
.29934 1.03982 L
s
.24646 .67252 m
.24058 .69065 L
s
.60824 .83379 m
.59743 .82091 L
s
.53237 .75844 m
.52408 .74676 L
s
.27575 .76469 m
.27782 .77766 L
s
.27284 .79988 m
.27853 .81342 L
s
.21885 .59163 m
.20566 .61434 L
s
.73087 .97289 m
.71055 .96155 L
s
.22146 .59898 m
.20895 .62127 L
s
.27569 .80838 m
.28209 .82143 L
s
.80864 1.06922 m
.7794 1.06168 L
s
.2745 .86241 m
.28679 .87561 L
s
.21807 .59006 m
.20472 .61291 L
s
.73273 .97522 m
.7122 .96391 L
s
.2639 .73981 m
.26397 .75495 L
s
.6364 .86363 m
.62411 .85086 L
s
.66701 .89867 m
.65245 .88596 L
s
.668 .89934 m
.65337 .88665 L
s
.27336 .90989 m
.29124 .92308 L
s
.24276 .65746 m
.23556 .67622 L
s
.26747 .99779 m
.29715 1.01118 L
s
.55764 .78336 m
.54859 .77085 L
s
.27382 .84065 m
.28375 .85405 L
s
.26589 .75057 m
.26694 .76536 L
s
.27376 .90027 m
.29045 .91348 L
s
.2738 .89829 m
.29025 .91151 L
s
.57079 .79654 m
.5613 .78375 L
s
.55965 .78524 m
.55052 .77267 L
s
.27314 .75741 m
.2746 .7709 L
s
.52345 .75022 m
.5153 .73881 L
s
.2746 .7709 m
.2773 .78414 L
s
.66562 .89733 m
.6511 .88453 L
s
.23256 .63358 m
.22322 .65414 L
s
.26696 .99705 m
.29658 1.0106 L
s
.27328 .88525 m
.28824 .89866 L
s
.24855 .67673 m
.24305 .69457 L
s
.25625 .71325 m
.25398 .72982 L
s
.27207 .81286 m
.27913 .82664 L
s
.68976 .92516 m
.67317 .91259 L
s
.24955 .68941 m
.24518 .70716 L
s
.25902 .72521 m
.25782 .7413 L
s
.23676 .644 m
.22836 .66387 L
s
.52232 .74941 m
.51414 .73799 L
s
.25595 .70072 m
.25254 .71732 L
s
.20379 .55681 m
.18724 .58215 L
s
.67603 .90911 m
.66059 .89632 L
s
.23947 .65706 m
.23223 .67654 L
s
.52651 .75338 m
.51822 .74176 L
s
.2681 .74317 m
.26836 .75765 L
s
.22737 .62108 m
.21688 .64258 L
s
.72485 .96657 m
.7049 .95473 L
s
.27293 .88494 m
.28787 .89849 L
s
.26939 .78007 m
.27321 .79431 L
s
.17363 .48208 m
.14938 .51228 L
s
.62411 .85086 m
.61241 .83789 L
s
.27296 .78648 m
.27725 .80014 L
s
.24636 .6815 m
.2413 .69986 L
s
.27265 .87992 m
.28702 .89357 L
s
.67803 .91203 m
.66235 .89917 L
s
.21287 .58165 m
.19871 .60556 L
s
.24054 .66261 m
.2338 .68197 L
s
.58581 .81224 m
.57564 .7991 L
s
.26694 .76536 m
.26939 .78007 L
s
.26427 .73278 m
.26365 .74799 L
s
.71223 .95177 m
.69342 .93948 L
s
.48369 .71469 m
.47612 .70519 L
s
.23983 .6564 m
.23255 .67586 L
s
.26979 .93775 m
.29136 .9516 L
s
.25261 .70567 m
.2497 .723 L
s
.27135 .89119 m
.28713 .90508 L
s
.52358 .75098 m
.51526 .73939 L
s
.41991 .66718 m
.41259 .66242 L
s
.20629 .5669 m
.1907 .59197 L
s
.25897 .73231 m
.25844 .74853 L
s
.20779 .5708 m
.19258 .59563 L
s
.26846 .78537 m
.27284 .79988 L
s
.63218 .86006 m
.61987 .84696 L
s
.26397 .75495 m
.26549 .77026 L
s
.24303 .66773 m
.23675 .6867 L
s
.2703 .91001 m
.2884 .92403 L
s
.61987 .84696 m
.60824 .83379 L
s
.27066 .8976 m
.28725 .91163 L
s
.73192 .97568 m
.71105 .96383 L
s
.5866 .81341 m
.5763 .80015 L
s
.23589 .65203 m
.22821 .67227 L
s
.2209 .60672 m
.20909 .62943 L
s
.26756 .95533 m
.29156 .96954 L
s
.23456 .64844 m
.22655 .66892 L
s
.51589 .74392 m
.5077 .73262 L
s
.27149 .858 m
.28343 .87205 L
s
.27069 .86869 m
.2839 .88286 L
s
.20961 .57732 m
.19502 .60192 L
s
.25633 .72545 m
.25521 .74221 L
s
.26745 .95358 m
.29122 .96786 L
s
.26997 .8324 m
.27919 .84677 L
s
.26836 .75765 m
.26998 .7722 L
s
.26889 .80696 m
.27546 .82151 L
s
.60613 .83318 m
.595 .81982 L
s
.26998 .7722 m
.27296 .78648 L
s
.58701 .81379 m
.57661 .80044 L
s
.27054 .79412 m
.27569 .80838 L
s
.64417 .8739 m
.63091 .86062 L
s
.26722 .9503 m
.29059 .9647 L
s
.26956 .89335 m
.28571 .90771 L
s
.26959 .84081 m
.27974 .85529 L
s
.48349 .71491 m
.47581 .7053 L
s
.24287 .67193 m
.23697 .69103 L
s
.67638 .9107 m
.66057 .89752 L
s
.24094 .6724 m
.23509 .69189 L
s
.24167 .67479 m
.23604 .69416 L
s
.26549 .77026 m
.26846 .78537 L
s
.27043 .85019 m
.28155 .86454 L
s
.21511 .59478 m
.20217 .61858 L
s
.52309 .75095 m
.51465 .73923 L
s
.5132 .74175 m
.50497 .73047 L
s
.26923 .86933 m
.2826 .88388 L
s
.5818 .80878 m
.57153 .79541 L
s
.59753 .82478 m
.58665 .81129 L
s
.71011 .95058 m
.69116 .93783 L
s
.26788 .8166 m
.2755 .83146 L
s
.26872 .8445 m
.27932 .85921 L
s
.51468 .74325 m
.50638 .73186 L
s
.52262 .75069 m
.51414 .73893 L
s
.54601 .77325 m
.5369 .76061 L
s
.2687 .8598 m
.28101 .87451 L
s
.57751 .80462 m
.56735 .79125 L
s
.24355 .6848 m
.23883 .70394 L
s
.26732 .81028 m
.2743 .82524 L
s
.21344 .59289 m
.20031 .61706 L
s
.26365 .74799 m
.26447 .76353 L
s
.21253 .59189 m
.19929 .61624 L
s
.26636 .79773 m
.27207 .81286 L
s
.23214 .64869 m
.22417 .66978 L
s
.25782 .7413 m
.25818 .75794 L
s
.22795 .63626 m
.21885 .65807 L
s
.2689 .86639 m
.28193 .88109 L
s
.51758 .74618 m
.50916 .73459 L
s
.46308 .69819 m
.4555 .68983 L
s
.24727 .69223 m
.24318 .71073 L
s
.17826 .50518 m
.15634 .53522 L
s
.26838 .82537 m
.27689 .84024 L
s
.26609 .92897 m
.28683 .94397 L
s
.2292 .63928 m
.22038 .66091 L
s
.25017 .71353 m
.24804 .73161 L
s
.64964 .88106 m
.63571 .86745 L
s
.25844 .74853 m
.25948 .76512 L
s
.25398 .72982 m
.25332 .74723 L
s
.26677 .77904 m
.27054 .79412 L
s
.22138 .61871 m
.21067 .6417 L
s
.56313 .79092 m
.55333 .77764 L
s
.24773 .70747 m
.24507 .72603 L
s
.56029 .78814 m
.55056 .7749 L
s
.57595 .80373 m
.56567 .79017 L
s
.26476 .93394 m
.28623 .94926 L
s
.22081 .62073 m
.21027 .64391 L
s
.26447 .76353 m
.26677 .77904 L
s
.66401 .89781 m
.64884 .88409 L
s
.26602 .90271 m
.28351 .91798 L
s
.26611 .88566 m
.28157 .90098 L
s
.50478 .73463 m
.49652 .72355 L
s
.26374 .79122 m
.26889 .80696 L
s
.25535 1.04337 m
.29271 1.05918 L
s
.61815 .8469 m
.60613 .83318 L
s
.49869 .72912 m
.49053 .71836 L
s
.26517 .82506 m
.27382 .84065 L
s
.25254 .71732 m
.25071 .73505 L
s
.26602 .8895 m
.28193 .90486 L
s
.22334 .63015 m
.21367 .65297 L
s
.63091 .86062 m
.61815 .8469 L
s
.57747 .80576 m
.56706 .79209 L
s
.23201 .65331 m
.22447 .67463 L
s
.21663 .61012 m
.20511 .63406 L
s
.25521 .74221 m
.25571 .75952 L
s
.26616 .86499 m
.27919 .88041 L
s
.26177 .96431 m
.28743 .98004 L
s
.54756 .77571 m
.53815 .76273 L
s
.51994 .74904 m
.51128 .73714 L
s
.26524 .85242 m
.27691 .86805 L
s
.26213 .78167 m
.26636 .79773 L
s
.28904 .84866 m
.29851 .86001 L
s
.26453 .90467 m
.28237 .92032 L
s
.25818 .75794 m
.26015 .77473 L
s
.26249 .94465 m
.28551 .96046 L
s
.23084 .65252 m
.22323 .67411 L
s
.6828 .92037 m
.66589 .90658 L
s
.25948 .76512 m
.26213 .78167 L
s
.26218 .94639 m
.28545 .96227 L
s
.2497 .723 m
.24847 .74137 L
s
.26152 .95755 m
.2863 .97347 L
s
.76003 1.01265 m
.73527 1.00081 L
s
.69548 .93521 m
.67739 .92155 L
s
.54898 .77747 m
.53946 .76437 L
s
.50086 .73144 m
.49256 .72045 L
s
.59709 .82621 m
.58581 .81224 L
s
.24518 .70716 m
.24253 .72636 L
s
.20994 .59642 m
.1971 .62163 L
s
.24058 .69065 m
.23643 .71067 L
s
.26181 .79402 m
.26732 .81028 L
s
.21959 .62422 m
.20937 .64783 L
s
.43876 .68018 m
.4311 .6735 L
s
.55189 .78052 m
.54223 .76727 L
s
.5593 .78791 m
.54939 .77446 L
s
.65245 .88596 m
.63794 .87192 L
s
.26015 .77473 m
.26374 .79122 L
s
.53346 .7624 m
.52435 .7498 L
s
.58151 .81044 m
.57079 .79654 L
s
.66703 .90264 m
.65134 .88859 L
s
.65337 .88665 m
.63877 .87259 L
s
.49126 .72292 m
.48308 .71243 L
s
.26277 .91285 m
.28175 .92892 L
s
.6511 .88453 m
.63667 .87046 L
s
.25969 .96934 m
.2862 .9856 L
s
.26171 .80027 m
.26788 .8166 L
s
.26342 .84631 m
.2745 .86241 L
s
.24305 .69457 m
.23924 .71417 L
s
.60943 .83886 m
.59753 .82478 L
s
.59801 .82749 m
.5866 .81341 L
s
.26215 .81608 m
.26997 .8324 L
s
.42918 .67361 m
.4215 .66772 L
s
.22496 .64327 m
.2165 .66606 L
s
.25882 .97309 m
.28592 .98952 L
s
.55916 .78789 m
.54919 .77436 L
s
.54849 .77729 m
.53887 .76407 L
s
.26295 .86756 m
.27648 .88379 L
s
.44688 .68625 m
.43914 .67886 L
s
.25016 1.06217 m
.2909 1.07904 L
s
.74143 .99078 m
.71848 .97792 L
s
.25332 .74723 m
.25437 .76509 L
s
.21353 .61153 m
.20212 .63632 L
s
.59852 .82796 m
.58701 .81379 L
s
.2413 .69986 m
.23802 .7199 L
s
.25571 .75952 m
.25792 .77694 L
s
.57008 .7991 m
.55965 .78524 L
s
.56799 .79718 m
.55764 .78336 L
s
.71232 .95589 m
.69233 .94219 L
s
.26088 .91962 m
.28084 .93616 L
s
.23556 .67622 m
.23013 .69726 L
s
.23053 .66489 m
.22407 .68685 L
s
.54094 .77027 m
.53145 .7572 L
s
.22505 .64819 m
.21706 .67111 L
s
.26084 .8241 m
.26959 .84081 L
s
.63571 .86745 m
.62222 .85321 L
s
.53297 .76252 m
.5237 .74974 L
s
.20724 .5959 m
.19434 .62183 L
s
.25792 .77694 m
.26181 .79402 L
s
.26133 .80877 m
.26838 .82537 L
s
.26083 .89632 m
.27791 .91304 L
s
.24804 .73161 m
.24769 .75056 L
s
.19312 .55968 m
.17667 .58803 L
s
.52722 .75711 m
.51805 .74452 L
s
.59325 .8231 m
.5818 .80878 L
s
.77086 1.0278 m
.74431 1.01577 L
s
.20928 .60368 m
.19712 .62935 L
s
.20962 .60572 m
.19765 .63136 L
s
.76102 1.01567 m
.7356 1.00318 L
s
.19263 .55977 m
.17617 .58826 L
s
.25718 .78294 m
.26171 .80027 L
s
.25554 .98063 m
.28395 .99791 L
s
.26087 .84117 m
.27149 .858 L
s
.25071 .73505 m
.25061 .75353 L
s
.25954 .82743 m
.26872 .8445 L
s
.23223 .67654 m
.22685 .69836 L
s
.26068 .83333 m
.27043 .85019 L
s
.2338 .68197 m
.22892 .70352 L
s
.54202 .7717 m
.53237 .75844 L
s
.25755 .94913 m
.28156 .96632 L
s
.23675 .6867 m
.23229 .70769 L
s
.20218 .58639 m
.18834 .61334 L
s
.62222 .85321 m
.60943 .83886 L
s
.66059 .89632 m
.64502 .88177 L
s
.68106 .92026 m
.66375 .90578 L
s
.25437 .76509 m
.25718 .78294 L
s
.48208 .71558 m
.4738 .70541 L
s
.25806 .80773 m
.26517 .82506 L
s
.58889 .81904 m
.57751 .80462 L
s
.24507 .72603 m
.24424 .74564 L
s
.25948 .86807 m
.27328 .88525 L
s
.19545 .57027 m
.18002 .59841 L
s
.24318 .71073 m
.24091 .73064 L
s
.18098 .53264 m
.16174 .56321 L
s
.23255 .67586 m
.22711 .69766 L
s
.49607 .72818 m
.48752 .71709 L
s
.67488 .91305 m
.65804 .89846 L
s
.24847 .74137 m
.24908 .76037 L
s
.19819 .57838 m
.18356 .6061 L
s
.50269 .73429 m
.49399 .7228 L
s
.69332 .93484 m
.6748 .92038 L
s
.25806 .91752 m
.27797 .93489 L
s
.23697 .69103 m
.23291 .71208 L
s
.22836 .66387 m
.22183 .68643 L
s
.23883 .70394 m
.23598 .72471 L
s
.2595 .8627 m
.27265 .87992 L
s
.25879 .85134 m
.27069 .86869 L
s
.23604 .69416 m
.2323 .71543 L
s
.25918 .86764 m
.27293 .88494 L
s
.23509 .69189 m
.23114 .71336 L
s
.66235 .89917 m
.64649 .88445 L
s
.60943 .84081 m
.59709 .82621 L
s
.47912 .71319 m
.47082 .70314 L
s
.6945 .93629 m
.67579 .92176 L
s
.53296 .76327 m
.52345 .75022 L
s
.73369 .98319 m
.71101 .96941 L
s
.25844 .88082 m
.2738 .89829 L
s
.22322 .65414 m
.2158 .67772 L
s
.25778 .8422 m
.2687 .8598 L
s
.25596 .79828 m
.26215 .81608 L
s
.68257 .92271 m
.6649 .908 L
s
.71458 .96031 m
.69385 .94603 L
s
.25815 .88272 m
.27376 .90027 L
s
.25617 .93098 m
.27793 .94876 L
s
.61048 .84219 m
.59801 .82749 L
s
.68329 .92347 m
.66552 .90871 L
s
.71519 .96119 m
.69436 .94686 L
s
.53618 .76663 m
.52651 .75338 L
s
.22821 .67227 m
.22247 .69504 L
s
.7126 .95824 m
.69201 .94385 L
s
.53186 .76249 m
.52232 .74941 L
s
.19795 .58247 m
.1837 .61042 L
s
.63667 .87046 m
.62269 .8557 L
s
.25656 .91663 m
.27646 .93444 L
s
.25722 .85156 m
.26923 .86933 L
s
.63794 .87192 m
.62386 .85714 L
s
.21426 .628 m
.2044 .65318 L
s
.58749 .81838 m
.57595 .80373 L
s
.24253 .72636 m
.2418 .74664 L
s
.61109 .84274 m
.59852 .82796 L
s
.22655 .66892 m
.22051 .69204 L
s
.63877 .87259 m
.62458 .85777 L
s
.25677 .87328 m
.27135 .89119 L
s
.25652 .89194 m
.27336 .90989 L
s
.25594 .79091 m
.26133 .80877 L
s
.25481 .93837 m
.27764 .95648 L
s
.25724 .84857 m
.2689 .86639 L
s
.64884 .88409 m
.63387 .86917 L
s
.66057 .89752 m
.64465 .88256 L
s
.58913 .82049 m
.57747 .80576 L
s
.24769 .75056 m
.24923 .76992 L
s
.79783 1.06385 m
.76732 1.05237 L
s
.25061 .75353 m
.25235 .77232 L
s
.6918 .93398 m
.67309 .91911 L
s
.21151 .62346 m
.20122 .64923 L
s
.53328 .76424 m
.52358 .75098 L
s
.67317 .91259 m
.65611 .89755 L
s
.42793 .67328 m
.41991 .66718 L
s
.1615 .49201 m
.13786 .52625 L
s
.2551 .90558 m
.27372 .92386 L
s
.24908 .76037 m
.25157 .77952 L
s
.25379 .9392 m
.2768 .9576 L
s
.57427 .80552 m
.56313 .79092 L
s
.71013 .95597 m
.68956 .94125 L
s
.25509 .83413 m
.26524 .85242 L
s
.21688 .64258 m
.2084 .6675 L
s
.25377 .80565 m
.26084 .8241 L
s
.25271 .78916 m
.25806 .80773 L
s
.55651 .78742 m
.54601 .77325 L
s
.25527 .87928 m
.27066 .8976 L
s
.59346 .82535 m
.58151 .81044 L
s
.62269 .8557 m
.60943 .84081 L
s
.28063 .83517 m
.28904 .84866 L
s
.20365 .60421 m
.19152 .63143 L
s
.71794 .96559 m
.69652 .95094 L
s
.23924 .71417 m
.23737 .73516 L
s
.25157 .77952 m
.25596 .79828 L
s
.23643 .71067 m
.23429 .73222 L
s
.57137 .80274 m
.56029 .78814 L
s
.25362 .92551 m
.27487 .9441 L
s
.20895 .62127 m
.19845 .64764 L
s
.25466 .87485 m
.26956 .89335 L
s
.52546 .75696 m
.51589 .74392 L
s
.25393 .82774 m
.26342 .84631 L
s
.62386 .85714 m
.61048 .84219 L
s
.25235 .77232 m
.25594 .79091 L
s
.49249 .72591 m
.48369 .71469 L
s
.22417 .66978 m
.21824 .69356 L
s
.60583 .83818 m
.59325 .8231 L
s
.23802 .7199 m
.23676 .74123 L
s
.24424 .74564 m
.24539 .76582 L
s
.2546 .84646 m
.26616 .86499 L
s
.70688 .95285 m
.68645 .93784 L
s
.71052 .95718 m
.68973 .94223 L
s
.53294 .76439 m
.52309 .75095 L
s
.20566 .61434 m
.1945 .64136 L
s
.24923 .76992 m
.25271 .78916 L
s
.62458 .85777 m
.61109 .84274 L
s
.7048 .95045 m
.68455 .93539 L
s
.25208 .80851 m
.25954 .82743 L
s
.25334 .89117 m
.2703 .91001 L
s
.20472 .61291 m
.19342 .64014 L
s
.53252 .76417 m
.52262 .75069 L
s
.65134 .88859 m
.63578 .8732 L
s
.16504 .50771 m
.14304 .54171 L
s
.52283 .7548 m
.5132 .74175 L
s
.68782 .93063 m
.66909 .91524 L
s
.25262 .81442 m
.26068 .83333 L
s
.73489 .987 m
.71137 .97237 L
s
.21885 .65807 m
.21184 .68294 L
s
.24091 .73064 m
.24063 .75153 L
s
.52438 .75641 m
.51468 .74325 L
s
.22038 .66091 m
.21364 .68549 L
s
.2502 .94353 m
.27408 .96295 L
s
.22447 .67463 m
.21901 .69851 L
s
.60147 .83432 m
.58889 .81904 L
s
.49244 .72629 m
.48349 .71491 L
s
.17411 .53336 m
.15482 .56595 L
s
.5584 .79025 m
.54756 .77571 L
s
.57059 .80278 m
.5593 .78791 L
s
.25205 .86643 m
.26611 .88566 L
s
.52742 .75954 m
.51758 .74618 L
s
.25194 .82202 m
.26087 .84117 L
s
.58185 .81421 m
.57008 .7991 L
s
.20909 .62943 m
.19938 .65607 L
s
.2418 .74664 m
.24312 .76748 L
s
.5797 .81229 m
.56799 .79718 L
s
.24858 .78603 m
.25377 .80565 L
s
.55994 .79213 m
.54898 .77747 L
s
.7475 1.00306 m
.72238 .98855 L
s
.24805 .96182 m
.27457 .98165 L
s
.22323 .67411 m
.21774 .69831 L
s
.25098 .84808 m
.26295 .86756 L
s
.57054 .80285 m
.55916 .78789 L
s
.56298 .79529 m
.55189 .78052 L
s
.23013 .69726 m
.22679 .72024 L
s
.2515 .87008 m
.26602 .8895 L
s
.23598 .72471 m
.23524 .74668 L
s
.64502 .88177 m
.62975 .86618 L
s
.24539 .76582 m
.24858 .78603 L
s
.63387 .86917 m
.61943 .85368 L
s
.24884 .93854 m
.27217 .9584 L
s
.23229 .70769 m
.22993 .73035 L
s
.24759 .95371 m
.27305 .97379 L
s
.61943 .85368 m
.60583 .83818 L
s
.4718 .70829 m
.46308 .69819 L
s
.24919 .91781 m
.26979 .93775 L
s
.19871 .60556 m
.1867 .6342 L
s
.23291 .71208 m
.23098 .73467 L
s
.2323 .71543 m
.23072 .73819 L
s
.55957 .7921 m
.54849 .77729 L
s
.24984 .88283 m
.26602 .90271 L
s
.22892 .70352 m
.22623 .72691 L
s
.24863 .82223 m
.25778 .8422 L
s
.66589 .90658 m
.64874 .89067 L
s
.60027 .83396 m
.58749 .81838 L
s
.73986 .99447 m
.71537 .97945 L
s
.22407 .68685 m
.21981 .71112 L
s
.24656 .78831 m
.25208 .80851 L
s
.53005 .76275 m
.51994 .74904 L
s
.21067 .6417 m
.20214 .66831 L
s
.51444 .74756 m
.50478 .73463 L
s
.21367 .65297 m
.20622 .67909 L
s
.23114 .71336 m
.22939 .73637 L
s
.602 .83611 m
.58913 .82049 L
s
.64649 .88445 m
.63092 .8686 L
s
.24861 .83129 m
.25879 .85134 L
s
.54404 .77674 m
.53346 .7624 L
s
.22685 .69836 m
.22369 .72218 L
s
.60659 .84103 m
.59346 .82535 L
s
.20217 .61858 m
.19142 .64674 L
s
.50824 .74174 m
.49869 .72912 L
s
.21027 .64391 m
.20195 .67068 L
s
.2454 .96196 m
.27217 .9826 L
s
.71425 .96385 m
.6924 .94813 L
s
.74492 1.00106 m
.71973 .98602 L
s
.24312 .76748 m
.24656 .78831 L
s
.23737 .73516 m
.23765 .75706 L
s
.22711 .69766 m
.22386 .72145 L
s
.24804 .8843 m
.26453 .90467 L
s
.2468 .81373 m
.25509 .83413 L
s
.2165 .66606 m
.2103 .69181 L
s
.24634 .80727 m
.25393 .82774 L
s
.23676 .74123 m
.23768 .76332 L
s
.24063 .75153 m
.24248 .77287 L
s
.64465 .88256 m
.62907 .86654 L
s
.24803 .84239 m
.2595 .8627 L
s
.2465 .79405 m
.25262 .81442 L
s
.23429 .73222 m
.23436 .75479 L
s
.55191 .78503 m
.54094 .77027 L
s
.24698 .83106 m
.25722 .85156 L
s
.24736 .84759 m
.25948 .86807 L
s
.19502 .60192 m
.18264 .63147 L
s
.20031 .61706 m
.18942 .64569 L
s
.19258 .59563 m
.17958 .62563 L
s
.24737 .82815 m
.25724 .84857 L
s
.61514 .85017 m
.60147 .83432 L
s
.69342 .93948 m
.67349 .92332 L
s
.51058 .74433 m
.50086 .73144 L
s
.21706 .67111 m
.21135 .69686 L
s
.19929 .61624 m
.18832 .64512 L
s
.18724 .58215 m
.17289 .61311 L
s
.24651 .90819 m
.26609 .92897 L
s
.1907 .59197 m
.17733 .62235 L
s
.24712 .84705 m
.25918 .86764 L
s
.20937 .64783 m
.20145 .67498 L
s
.73244 .98658 m
.7084 .97091 L
s
.54374 .77707 m
.53297 .76252 L
s
.63578 .8732 m
.62077 .85714 L
s
.44739 .68851 m
.43876 .68018 L
s
.20511 .63406 m
.19587 .66196 L
s
.22183 .68643 m
.21757 .71135 L
s
.27352 .81986 m
.28063 .83517 L
s
.65804 .89846 m
.6412 .88214 L
s
.43775 .68111 m
.42918 .67361 L
s
.62975 .86618 m
.61514 .85017 L
s
.24479 .92914 m
.26722 .9503 L
s
.24445 .93412 m
.26756 .95533 L
s
.55317 .78666 m
.54202 .7717 L
s
.24458 .93239 m
.26745 .95358 L
s
.50081 .73532 m
.49126 .72292 L
s
.24244 .96816 m
.27033 .98963 L
s
.24497 .80117 m
.25194 .82202 L
s
.58679 .82135 m
.57427 .80552 L
s
.22247 .69504 m
.21906 .71997 L
s
.24518 .89166 m
.26277 .91285 L
s
.53788 .77153 m
.52722 .75711 L
s
.24528 .87516 m
.26083 .89632 L
s
.23524 .74668 m
.23678 .76928 L
s
.67739 .92155 m
.65874 .90504 L
s
.24248 .77287 m
.2465 .79405 L
s
.23806 1.01432 m
.27297 1.03637 L
s
.45567 .69538 m
.44688 .68625 L
s
.24447 .91259 m
.26476 .93394 L
s
.24492 .82538 m
.2546 .84646 L
s
.66375 .90578 m
.64628 .88926 L
s
.69116 .93783 m
.67118 .92133 L
s
.62077 .85714 m
.60659 .84103 L
s
.58386 .81865 m
.57137 .80274 L
s
.22051 .69204 m
.21684 .71742 L
s
.24476 .85951 m
.25844 .88082 L
s
.616 .8523 m
.602 .83611 L
s
.61418 .85016 m
.60027 .83396 L
s
.24394 .85181 m
.25677 .87328 L
s
.2158 .67772 m
.21077 .70401 L
s
.23768 .76332 m
.24088 .78556 L
s
.24088 .78556 m
.24634 .80727 L
s
.63092 .8686 m
.616 .8523 L
s
.23765 .75706 m
.24018 .77928 L
s
.24423 .86126 m
.25815 .88272 L
s
.24156 .80052 m
.24863 .82223 L
s
.7049 .95473 m
.68337 .93811 L
s
.65611 .89755 m
.63913 .88087 L
s
.544 .77814 m
.53296 .76327 L
s
.71055 .96155 m
.68843 .94497 L
s
.59497 .83044 m
.58185 .81421 L
s
.24064 .79187 m
.2468 .81373 L
s
.20212 .63632 m
.19311 .66512 L
s
.1971 .62163 m
.18667 .65133 L
s
.56852 .80317 m
.55651 .78742 L
s
.62907 .86654 m
.61418 .85016 L
s
.54739 .78169 m
.53618 .76663 L
s
.23072 .73819 m
.23151 .76187 L
s
.24234 .8976 m
.26088 .91962 L
s
.22993 .73035 m
.22993 .75415 L
s
.23098 .73467 m
.2314 .75828 L
s
.6649 .908 m
.64708 .89115 L
s
.23436 .75479 m
.23678 .77779 L
s
.59278 .82857 m
.5797 .81229 L
s
.24018 .77928 m
.24497 .80117 L
s
.7122 .96391 m
.68978 .9472 L
s
.54296 .77743 m
.53186 .76249 L
s
.22679 .72024 m
.22583 .74467 L
s
.23821 .9751 m
.26747 .99779 L
s
.24053 .80919 m
.24861 .83129 L
s
.66552 .90871 m
.64758 .89179 L
s
.21824 .69356 m
.21476 .71962 L
s
.22939 .73637 m
.23003 .76038 L
s
.23678 .76928 m
.24064 .79187 L
s
.24101 .82596 m
.25098 .84808 L
s
.24168 .85713 m
.25527 .87928 L
s
.24159 .8527 m
.25466 .87485 L
s
.51286 .74777 m
.50269 .73429 L
s
.58333 .81901 m
.57059 .80278 L
s
.24063 .92221 m
.26249 .94465 L
s
.23779 .97421 m
.26696 .99705 L
s
.50607 .74127 m
.49607 .72818 L
s
.23225 1.0379 m
.27132 1.0613 L
s
.49174 .72774 m
.48208 .71558 L
s
.24139 .86967 m
.25652 .89194 L
s
.24007 .92379 m
.26218 .94639 L
s
.22623 .72691 m
.22598 .75158 L
s
.54453 .77938 m
.53328 .76424 L
s
.58337 .81918 m
.57054 .80285 L
s
.23964 .80578 m
.24737 .82815 L
s
.21901 .69851 m
.21602 .72454 L
s
.23889 .80852 m
.24698 .83106 L
s
.19765 .63136 m
.18819 .66126 L
s
.23678 .77779 m
.24156 .80052 L
s
.19712 .62935 m
.18746 .65934 L
s
.6748 .92038 m
.65582 .90318 L
s
.48879 .72524 m
.47912 .71319 L
s
.23993 .84386 m
.25205 .86643 L
s
.19434 .62183 m
.18394 .65234 L
s
.23969 .89472 m
.25806 .91752 L
s
.57076 .80638 m
.5584 .79025 L
s
.22369 .72218 m
.22302 .74745 L
s
.2084 .6675 m
.20246 .69556 L
s
.2044 .65318 m
.19707 .68194 L
s
.57557 .81158 m
.56298 .79529 L
s
.21774 .69831 m
.21476 .72469 L
s
.57241 .80836 m
.55994 .79213 L
s
.23783 .93432 m
.26152 .95755 L
s
.67579 .92176 m
.6566 .90441 L
s
.22386 .72145 m
.22311 .74671 L
s
.71105 .96383 m
.68836 .94661 L
s
.23868 .81961 m
.24803 .84239 L
s
.21364 .68549 m
.20944 .71265 L
s
.23714 .94092 m
.26177 .96431 L
s
.64874 .89067 m
.63189 .87347 L
s
.21981 .71112 m
.2181 .73721 L
s
.26792 .80315 m
.27352 .81986 L
s
.23894 .84717 m
.2515 .87008 L
s
.21184 .68294 m
.20741 .7105 L
s
.53662 .77196 m
.52546 .75696 L
s
.54437 .77973 m
.53294 .76439 L
s
.23745 .80244 m
.24492 .82538 L
s
.43692 .68115 m
.42793 .67328 L
s
.23826 .89338 m
.25656 .91663 L
s
.23737 .82444 m
.24736 .84759 L
s
.23818 .88233 m
.2551 .90558 L
s
.23151 .76187 m
.23478 .78579 L
s
.2382 .86796 m
.25334 .89117 L
s
.60065 .83822 m
.58679 .82135 L
s
.20122 .64923 m
.19353 .67875 L
s
.67309 .91911 m
.65399 .90157 L
s
.544 .77958 m
.53252 .76417 L
s
.2314 .75828 m
.23428 .78223 L
s
.23478 .78579 m
.24053 .80919 L
s
.6412 .88214 m
.62485 .86491 L
s
.57219 .8085 m
.55957 .7921 L
s
.22728 1.04951 m
.2687 1.07427 L
s
.2372 .82381 m
.24712 .84705 L
s
.23164 1.00225 m
.26545 1.02661 L
s
.22993 .75415 m
.23243 .77843 L
s
.23003 .76038 m
.2332 .78469 L
s
.18834 .61334 m
.17712 .64526 L
s
.69233 .94219 m
.67129 .92452 L
s
.60935 .84748 m
.59497 .83044 L
s
.7749 1.04357 m
.7445 1.02749 L
s
.53405 .76986 m
.52283 .7548 L
s
.23428 .78223 m
.23964 .80578 L
s
.53568 .77158 m
.52438 .75641 L
s
.23593 .90706 m
.25617 .93098 L
s
.59774 .83567 m
.58386 .81865 L
s
.2332 .78469 m
.23889 .80852 L
s
.50279 .73925 m
.49249 .72591 L
s
.23423 .94508 m
.25969 .96934 L
s
.19845 .64764 m
.19063 .67789 L
s
.53887 .7749 m
.52742 .75954 L
s
.21906 .71997 m
.21829 .74648 L
s
.60715 .84573 m
.59278 .82857 L
s
.23487 .92494 m
.25755 .94913 L
s
.21757 .71135 m
.21594 .73812 L
s
.66909 .91524 m
.6501 .89742 L
s
.22583 .74467 m
.22746 .7699 L
s
.23566 .85889 m
.24984 .88283 L
s
.23339 .80193 m
.24101 .82596 L
s
.63913 .88087 m
.62269 .86335 L
s
.22598 .75158 m
.22835 .77685 L
s
.23243 .77843 m
.23745 .80244 L
s
.14938 .51228 m
.12756 .5513 L
s
.18356 .6061 m
.17161 .63914 L
s
.23278 .9484 m
.25882 .97309 L
s
.55625 .79294 m
.54404 .77674 L
s
.64628 .88926 m
.6292 .87157 L
s
.2103 .69181 m
.20682 .72007 L
s
.73316 .9925 m
.70747 .97489 L
s
.56449 .80156 m
.55191 .78503 L
s
.21135 .69686 m
.20837 .72496 L
s
.21684 .71742 m
.21587 .74451 L
s
.20622 .67909 m
.2015 .70814 L
s
.17667 .58803 m
.16288 .62237 L
s
.19152 .63143 m
.18211 .66313 L
s
.1945 .64136 m
.18608 .67254 L
s
.23402 .901 m
.25362 .92551 L
s
.2335 .91373 m
.25481 .93837 L
s
.23338 .82748 m
.24394 .85181 L
s
.18002 .59841 m
.1673 .63219 L
s
.19938 .65607 m
.19241 .68636 L
s
.50291 .73983 m
.49244 .72629 L
s
.17617 .58826 m
.16241 .62276 L
s
.62485 .86491 m
.60935 .84748 L
s
.1837 .61042 m
.1722 .64359 L
s
.23361 .85978 m
.24804 .8843 L
s
.5418 .77848 m
.53005 .76275 L
s
.19342 .64014 m
.18489 .67159 L
s
.23176 .79516 m
.23868 .81961 L
s
.2333 .83505 m
.24476 .85951 L
s
.15634 .53522 m
.137 .57327 L
s
.5975 .83639 m
.58333 .81901 L
s
.22302 .74745 m
.22506 .77348 L
s
.20214 .66831 m
.19639 .69822 L
s
.26399 .78549 m
.26792 .80315 L
s
.56594 .80338 m
.55317 .78666 L
s
.23232 .91418 m
.25379 .9392 L
s
.61575 .85576 m
.60065 .83822 L
s
.63189 .87347 m
.61575 .85576 L
s
.20195 .67068 m
.19645 .70069 L
s
.23255 .83657 m
.24423 .86126 L
s
.22311 .74671 m
.22506 .77275 L
s
.55615 .79353 m
.54374 .77707 L
s
.59764 .83668 m
.58337 .81918 L
s
.52574 .76263 m
.51444 .74756 L
s
.23191 .8502 m
.24528 .87516 L
s
.22835 .77685 m
.23339 .80193 L
s
.62269 .86335 m
.60715 .84573 L
s
.64708 .89115 m
.62963 .87307 L
s
.58207 .82043 m
.56852 .80317 L
s
.69201 .94385 m
.67041 .92543 L
s
.22986 .79944 m
.23737 .82444 L
s
.21077 .70401 m
.20855 .73248 L
s
.21476 .71962 m
.21409 .74735 L
s
.69385 .94603 m
.67204 .92758 L
s
.22746 .7699 m
.23176 .79516 L
s
.23086 .82764 m
.24159 .8527 L
s
.23022 .81871 m
.23993 .84386 L
s
.64758 .89179 m
.63001 .8736 L
s
.22978 .79875 m
.2372 .82381 L
s
.69436 .94686 m
.67242 .92833 L
s
.5194 .75655 m
.50824 .74174 L
s
.48193 .72056 m
.4718 .70829 L
s
.23042 .83189 m
.24168 .85713 L
s
.21602 .72454 m
.21583 .75208 L
s
.65874 .90504 m
.64017 .88666 L
s
.68455 .93539 m
.66356 .91681 L
s
.68956 .94125 m
.66807 .92267 L
s
.20145 .67498 m
.1964 .70528 L
s
.2181 .73721 m
.2192 .76441 L
s
.61292 .85348 m
.59774 .83567 L
s
.22822 .95455 m
.25554 .98063 L
s
.23045 .89221 m
.24919 .91781 L
s
.68645 .93784 m
.6652 .91919 L
s
.55023 .78796 m
.53788 .77153 L
s
.21476 .72469 m
.21462 .75259 L
s
.58969 .82925 m
.57557 .81158 L
s
.22972 .86594 m
.24518 .89166 L
s
.52195 .75942 m
.51058 .74433 L
s
.22506 .77348 m
.22986 .79944 L
s
.22883 .82154 m
.23894 .84717 L
s
.19142 .64674 m
.1836 .67904 L
s
.6292 .87157 m
.61292 .85348 L
s
.5847 .82401 m
.57076 .80638 L
s
.68973 .94223 m
.668 .92338 L
s
.58645 .82605 m
.57241 .80836 L
s
.19587 .66196 m
.18957 .69348 L
s
.55673 .79497 m
.544 .77814 L
s
.22859 .84377 m
.24139 .86967 L
s
.22506 .77275 m
.22978 .79875 L
s
.56028 .79866 m
.54739 .78169 L
s
.21829 .74648 m
.22039 .77385 L
s
.26179 .76736 m
.26399 .78549 L
s
.22895 .88216 m
.24651 .90819 L
s
.1867 .6342 m
.17763 .66743 L
s
.22798 .91718 m
.2502 .94353 L
s
.16174 .56321 m
.14536 .60097 L
s
.67349 .92332 m
.65321 .90436 L
s
.22726 .91196 m
.24884 .93854 L
s
.20944 .71265 m
.20817 .74178 L
s
.512 .74999 m
.50081 .73532 L
s
.55575 .79435 m
.54296 .77743 L
s
.21594 .73812 m
.21721 .76601 L
s
.18942 .64569 m
.18152 .67855 L
s
.69652 .95094 m
.67391 .93186 L
s
.22545 .80117 m
.23338 .82748 L
s
.613 .85459 m
.5975 .83639 L
s
.45728 .69901 m
.44739 .68851 L
s
.4475 .6907 m
.43775 .68111 L
s
.58639 .8264 m
.57219 .8085 L
s
.18832 .64512 m
.18037 .67827 L
s
.20741 .7105 m
.20598 .74013 L
s
.21587 .74451 m
.21784 .77253 L
s
.65582 .90318 m
.63703 .88424 L
s
.55751 .7965 m
.54453 .77938 L
s
.71848 .97792 m
.69338 .95877 L
s
.61325 .855 m
.59764 .83668 L
s
.67118 .92133 m
.65093 .90215 L
s
.62963 .87307 m
.613 .85459 L
s
.20246 .69556 m
.19956 .72621 L
s
.22625 .88572 m
.24447 .91259 L
s
.26134 .74922 m
.26179 .76736 L
s
.22602 .87074 m
.24234 .8976 L
s
.22553 .84118 m
.2382 .86796 L
s
.22325 .7919 m
.23022 .81871 L
s
.46583 .70676 m
.45567 .69538 L
s
.2192 .76441 m
.22325 .7919 L
s
.27519 .68393 m
.26967 .69859 L
s
.28179 .67066 m
.27519 .68393 L
s
.19311 .66512 m
.18719 .69755 L
s
.2245 .80833 m
.2333 .83505 L
s
.18264 .63147 m
.17333 .66582 L
s
.28929 .6589 m
.28179 .67066 L
s
.63001 .8736 m
.61325 .855 L
s
.6566 .90441 m
.63759 .88528 L
s
.26967 .69859 m
.26541 .71451 L
s
.71101 .96941 m
.68654 .94996 L
s
.22286 .80058 m
.23086 .82764 L
s
.22039 .77385 m
.22545 .80117 L
s
.65399 .90157 m
.63515 .8824 L
s
.22382 .92607 m
.24759 .95371 L
s
.21823 1.01478 m
.25535 1.04337 L
s
.26258 .73148 m
.26134 .74922 L
s
.22355 .80954 m
.23255 .83657 L
s
.26541 .71451 m
.26258 .73148 L
s
.22435 .90165 m
.24479 .92914 L
s
.21409 .74735 m
.21644 .77596 L
s
.17958 .62563 m
.16969 .66067 L
s
.21583 .75208 m
.21864 .78033 L
s
.22313 .93399 m
.24805 .96182 L
s
.22405 .83174 m
.23566 .85889 L
s
.29754 .64869 m
.28929 .6589 L
s
.19707 .68194 m
.19285 .71377 L
s
.20837 .72496 m
.20847 .7547 L
s
.55754 .79709 m
.54437 .77973 L
s
.52477 .76357 m
.51286 .74777 L
s
.20682 .72007 m
.20644 .75013 L
s
.22368 .90468 m
.24458 .93239 L
s
.2237 .85487 m
.23818 .88233 L
s
.22192 .80449 m
.23042 .83189 L
s
.6501 .89742 m
.63148 .87816 L
s
.2233 .9063 m
.24445 .93412 L
s
.22366 .86715 m
.23969 .89472 L
s
.18667 .65133 m
.1794 .6852 L
s
.17733 .62235 m
.16712 .65794 L
s
.22152 .79415 m
.22883 .82154 L
s
.51779 .75671 m
.50607 .74127 L
s
.54953 .78909 m
.53662 .77196 L
s
.55725 .79703 m
.544 .77958 L
s
.59718 .83898 m
.58207 .82043 L
s
.21462 .75259 m
.21754 .7812 L
s
.57875 .81978 m
.56449 .80156 L
s
.21721 .76601 m
.22152 .79415 L
s
.21784 .77253 m
.22286 .80058 L
s
.20855 .73248 m
.20947 .76236 L
s
.50305 .74231 m
.49174 .72774 L
s
.22182 .83198 m
.23361 .85978 L
s
.60529 .848 m
.58969 .82925 L
s
.22125 .82235 m
.23191 .8502 L
s
.22236 .86541 m
.23826 .89338 L
s
.17289 .61311 m
.16174 .64969 L
s
.6924 .94813 m
.66955 .9282 L
s
.18819 .66126 m
.18195 .69504 L
s
.57018 .811 m
.55625 .79294 L
s
.64017 .88666 m
.62221 .86737 L
s
.2015 .70814 m
.19999 .73945 L
s
.19353 .67875 m
.18905 .71154 L
s
.18746 .65934 m
.18103 .69329 L
s
.30643 .6401 m
.29754 .64869 L
s
.22034 .93323 m
.2454 .96196 L
s
.21864 .78033 m
.2245 .80833 L
s
.5804 .8218 m
.56594 .80338 L
s
.50012 .73973 m
.48879 .72524 L
s
.22097 .89368 m
.24063 .92221 L
s
.60201 .84493 m
.58645 .82605 L
s
.54706 .78713 m
.53405 .76986 L
s
.60018 .84288 m
.5847 .82401 L
s
.73527 1.00081 m
.70752 .98093 L
s
.54877 .78893 m
.53568 .77158 L
s
.55211 .79241 m
.53887 .7749 L
s
.21644 .77596 m
.22192 .80449 L
s
.15482 .56595 m
.13871 .60602 L
s
.21754 .7812 m
.22355 .80954 L
s
.18394 .65234 m
.17683 .6871 L
s
.22017 .895 m
.24007 .92379 L
s
.68337 .93811 m
.66119 .91791 L
s
.21863 .81523 m
.22859 .84377 L
s
.19063 .67789 m
.18613 .71151 L
s
.20817 .74178 m
.21014 .77204 L
s
.57033 .81189 m
.55615 .79353 L
s
.60214 .8455 m
.58639 .8264 L
s
.19639 .69822 m
.19395 .73078 L
s
.19645 .70069 m
.19427 .73329 L
s
.44717 .69132 m
.43692 .68115 L
s
.55536 .79635 m
.5418 .77848 L
s
.71137 .97237 m
.68606 .95191 L
s
.19241 .68636 m
.18878 .71974 L
s
.63703 .88424 m
.61896 .86455 L
s
.20598 .74013 m
.20784 .77097 L
s
.62221 .86737 m
.60529 .848 L
s
.21814 .87771 m
.23593 .90706 L
s
.68843 .94497 m
.66547 .92441 L
s
.13786 .52625 m
.11739 .56973 L
s
.21633 .93814 m
.24244 .96816 L
s
.67129 .92452 m
.65003 .90409 L
s
.1964 .70528 m
.19473 .73804 L
s
.51486 .75507 m
.50279 .73925 L
s
.21707 .83664 m
.22972 .86594 L
s
.61372 .85842 m
.59718 .83898 L
s
.20847 .7547 m
.21187 .78515 L
s
.14304 .54171 m
.12428 .58434 L
s
.21582 .81183 m
.22553 .84118 L
s
.20957 1.03091 m
.25016 1.06217 L
s
.21545 .8024 m
.22405 .83174 L
s
.63515 .8824 m
.61708 .86256 L
s
.63148 .87816 m
.61372 .85842 L
s
.31585 .6332 m
.30643 .6401 L
s
.63759 .88528 m
.6193 .86536 L
s
.21697 .87131 m
.23402 .901 L
s
.18608 .67254 m
.1811 .70737 L
s
.20947 .76236 m
.21371 .79268 L
s
.21638 .9043 m
.23783 .93432 L
s
.5644 .80644 m
.55023 .78796 L
s
.57494 .81752 m
.56028 .79866 L
s
.20644 .75013 m
.20941 .78109 L
s
.68978 .9472 m
.66649 .92639 L
s
.21371 .79268 m
.22125 .82235 L
s
.7356 1.00318 m
.70717 .98249 L
s
.61896 .86455 m
.60201 .84493 L
s
.57127 .81376 m
.55673 .79497 L
s
.77058 1.04729 m
.73773 1.02724 L
s
.17712 .64526 m
.16936 .68185 L
s
.18489 .67159 m
.17984 .70675 L
s
.61708 .86256 m
.60018 .84288 L
s
.5389 .78009 m
.52574 .76263 L
s
.19956 .72621 m
.20011 .75862 L
s
.18211 .66313 m
.1762 .69885 L
s
.51518 .75592 m
.50291 .73983 L
s
.21314 .80198 m
.22182 .83198 L
s
.21473 .91036 m
.23714 .94092 L
s
.21187 .78515 m
.21863 .81523 L
s
.21473 .88327 m
.2335 .91373 L
s
.21014 .77204 m
.21545 .8024 L
s
.21461 .89438 m
.23487 .92494 L
s
.57037 .81326 m
.55575 .79435 L
s
.65321 .90436 m
.63328 .88375 L
s
.6193 .86536 m
.60214 .8455 L
s
.21445 .86181 m
.23045 .89221 L
s
.21422 .85178 m
.22895 .88216 L
s
.66356 .91681 m
.64261 .89595 L
s
.18957 .69348 m
.1868 .72797 L
s
.53245 .77384 m
.5194 .75655 L
s
.57231 .81559 m
.55751 .7965 L
s
.65093 .90215 m
.6311 .88145 L
s
.68836 .94661 m
.66485 .92535 L
s
.21344 .8833 m
.23232 .91418 L
s
.59469 .8395 m
.57875 .81978 L
s
.71537 .97945 m
.6889 .9581 L
s
.7084 .97091 m
.68271 .94955 L
s
.21227 .82424 m
.2237 .85487 L
s
.20784 .77097 m
.21314 .80198 L
s
.21266 .84002 m
.22602 .87074 L
s
.6652 .91919 m
.64396 .89812 L
s
.20941 .78109 m
.21582 .81183 L
s
.67041 .92543 m
.64863 .90425 L
s
.19999 .73945 m
.20202 .77209 L
s
.17161 .63914 m
.16329 .6772 L
s
.53521 .77701 m
.52195 .75942 L
s
.21087 .9433 m
.23821 .9751 L
s
.66807 .92267 m
.64649 .90149 L
s
.59654 .84168 m
.5804 .8218 L
s
.1836 .67904 m
.1794 .71488 L
s
.74431 1.01577 m
.71426 .99447 L
s
.72238 .98855 m
.69495 .96703 L
s
.21055 .9423 m
.23779 .97421 L
s
.67204 .92758 m
.65001 .90626 L
s
.1722 .64359 m
.16435 .68165 L
s
.19285 .71377 m
.19224 .74789 L
s
.2111 .91333 m
.23423 .94508 L
s
.57257 .81646 m
.55754 .79709 L
s
.21068 .83587 m
.22366 .86715 L
s
.49381 .73551 m
.48193 .72056 L
s
.67242 .92833 m
.65025 .90689 L
s
.5859 .83081 m
.57018 .811 L
s
.21097 .85429 m
.22625 .88572 L
s
.18719 .69755 m
.18495 .73289 L
s
.1673 .63219 m
.15828 .67133 L
s
.668 .92338 m
.6462 .90191 L
s
.57236 .81652 m
.55725 .79703 L
s
.18152 .67855 m
.17732 .71501 L
s
.71973 .98602 m
.69237 .96419 L
s
.20958 .8338 m
.22236 .86541 L
s
.3258 .62813 m
.31585 .6332 L
s
.17763 .66743 m
.1723 .70472 L
s
.20911 .916 m
.23278 .9484 L
s
.20773 .80492 m
.21707 .83664 L
s
.52511 .7673 m
.512 .74999 L
s
.18037 .67827 m
.17617 .71507 L
s
.56436 .80841 m
.54953 .78909 L
s
.16288 .62237 m
.15285 .66251 L
s
.7794 1.06168 m
.74435 1.04056 L
s
.18905 .71154 m
.18832 .74677 L
s
.16241 .62276 m
.15244 .66306 L
s
.19427 .73329 m
.19582 .76753 L
s
.19395 .73078 m
.19522 .76507 L
s
.20849 .87952 m
.22726 .91196 L
s
.20853 .88471 m
.22798 .91718 L
s
.58633 .83202 m
.57033 .81189 L
s
.20011 .75862 m
.20434 .79172 L
s
.20462 .98064 m
.23806 1.01432 L
s
.19473 .73804 m
.19681 .77227 L
s
.20202 .77209 m
.20773 .80492 L
s
.56728 .8121 m
.55211 .79241 L
s
.53864 .78194 m
.52477 .76357 L
s
.20434 .79172 m
.21227 .82424 L
s
.61222 .86027 m
.59469 .8395 L
s
.20688 .86877 m
.22435 .90165 L
s
.46878 .71224 m
.45728 .69901 L
s
.45876 .70299 m
.4475 .6907 L
s
.56382 .80854 m
.54877 .78893 L
s
.63328 .88375 m
.61425 .86255 L
s
.1794 .6852 m
.17601 .72257 L
s
.56203 .80667 m
.54706 .78713 L
s
.67391 .93186 m
.65106 .9097 L
s
.18195 .69504 m
.17959 .73194 L
s
.6311 .88145 m
.61222 .86027 L
s
.18878 .71974 m
.18899 .75531 L
s
.61425 .86255 m
.59654 .84168 L
s
.59141 .83804 m
.57494 .81752 L
s
.18613 .71151 m
.1855 .74764 L
s
.17333 .66582 m
.16793 .7044 L
s
.18103 .69329 m
.1785 .73043 L
s
.20578 .87142 m
.22368 .90468 L
s
.53148 .77483 m
.51779 .75671 L
s
.57086 .81637 m
.55536 .79635 L
s
.58765 .83433 m
.57127 .81376 L
s
.20516 .87284 m
.2233 .9063 L
s
.47769 .72095 m
.46583 .70676 L
s
.65003 .90409 m
.62927 .88214 L
s
.20281 .80673 m
.21266 .84002 L
s
.58047 .82689 m
.5644 .80644 L
s
.20446 .86012 m
.22097 .89368 L
s
.20345 .92026 m
.22822 .95455 L
s
.16969 .66067 m
.1638 .70021 L
s
.20364 .84408 m
.21814 .87771 L
s
.20295 .81831 m
.21422 .85178 L
s
.58685 .834 m
.57037 .81326 L
s
.20329 .83765 m
.21697 .87131 L
s
.20345 .86111 m
.22017 .895 L
s
.17683 .6871 m
.17373 .72535 L
s
.51633 .7597 m
.50305 .74231 L
s
.20131 .80219 m
.21068 .83587 L
s
.66119 .91791 m
.6392 .89548 L
s
.64261 .89595 m
.62237 .87399 L
s
.58897 .83647 m
.57231 .81559 L
s
.20296 .89173 m
.22382 .92607 L
s
.60336 .852 m
.5859 .83081 L
s
.19224 .74789 m
.19557 .78319 L
s
.20191 .82785 m
.21445 .86181 L
s
.16712 .65794 m
.16098 .6982 L
s
.19976 .96678 m
.23164 1.00225 L
s
.20044 .79987 m
.20958 .8338 L
s
.1868 .72797 m
.18804 .76441 L
s
.66955 .9282 m
.64662 .90547 L
s
.1811 .70737 m
.18018 .74496 L
s
.19582 .76753 m
.20131 .80219 L
s
.19681 .77227 m
.20281 .80673 L
s
.19522 .76507 m
.20044 .79987 L
s
.51343 .7571 m
.50012 .73973 L
s
.64396 .89812 m
.62341 .87588 L
s
.20112 .899 m
.22313 .93399 L
s
.17984 .70675 m
.17889 .74472 L
s
.58949 .83764 m
.57257 .81646 L
s
.70747 .97489 m
.68022 .95138 L
s
.60408 .85356 m
.58633 .83202 L
s
.1993 .81964 m
.21097 .85429 L
s
.64649 .90149 m
.62555 .87898 L
s
.137 .57327 m
.12175 .61958 L
s
.33631 .62513 m
.3258 .62813 L
s
.55413 .8001 m
.5389 .78009 L
s
.64863 .90425 m
.62744 .88162 L
s
.1994 .84821 m
.21473 .88327 L
s
.58937 .83783 m
.57236 .81652 L
s
.16174 .64969 m
.1548 .69136 L
s
.1762 .69885 m
.17447 .73772 L
s
.18495 .73289 m
.18684 .77006 L
s
.19461 1.00092 m
.23225 1.0379 L
s
.52899 .77374 m
.51486 .75507 L
s
.66547 .92441 m
.6426 .9013 L
s
.18832 .74677 m
.1917 .78327 L
s
.6096 .85981 m
.59141 .83804 L
s
.14536 .60097 m
.13318 .64587 L
s
.86216 1.17649 m
.81317 1.15712 L
s
.68654 .94996 m
.66141 .92638 L
s
.19557 .78319 m
.20295 .81831 L
s
.1794 .71488 m
.17941 .75326 L
s
.19832 .89731 m
.22034 .93323 L
s
.65001 .90626 m
.62854 .8834 L
s
.62237 .87399 m
.60336 .852 L
s
.19808 .84781 m
.21344 .8833 L
s
.19827 .86862 m
.21638 .9043 L
s
.6462 .90191 m
.62506 .87912 L
s
.12756 .5513 m
.10986 .59964 L
s
.18899 .75531 m
.19335 .79183 L
s
.19779 .85865 m
.21461 .89438 L
s
.45907 .70445 m
.44717 .69132 L
s
.16936 .68185 m
.16589 .72232 L
s
.62927 .88214 m
.6096 .85981 L
s
.69338 .95877 m
.66734 .9349 L
s
.65025 .90689 m
.62865 .88387 L
s
.60581 .85628 m
.58765 .83433 L
s
.66649 .92639 m
.64327 .90294 L
s
.5476 .79382 m
.53245 .77384 L
s
.58119 .8298 m
.56436 .80841 L
s
.52954 .77489 m
.51518 .75592 L
s
.1855 .74764 m
.18911 .78506 L
s
.17732 .71501 m
.17742 .75408 L
s
.55059 .79725 m
.53521 .77701 L
s
.62341 .87588 m
.60408 .85356 L
s
.19335 .79183 m
.20191 .82785 L
s
.19572 .87377 m
.21473 .91036 L
s
.60515 .85617 m
.58685 .834 L
s
.58445 .83381 m
.56728 .8121 L
s
.17617 .71507 m
.17633 .75451 L
s
.19354 .80148 m
.20329 .83765 L
s
.60742 .8587 m
.58897 .83647 L
s
.59842 .84898 m
.58047 .82689 L
s
.18804 .76441 m
.19354 .80148 L
s
.76732 1.05237 m
.73181 1.02824 L
s
.19309 .80765 m
.20364 .84408 L
s
.1917 .78327 m
.1993 .81964 L
s
.66485 .92535 m
.64149 .90153 L
s
.17959 .73194 m
.1816 .7708 L
s
.58089 .83026 m
.56382 .80854 L
s
.58834 .83832 m
.57086 .81637 L
s
.1723 .70472 m
.17139 .74506 L
s
.57905 .82839 m
.56203 .80667 L
s
.62555 .87898 m
.60581 .85628 L
s
.19347 .8426 m
.20849 .87952 L
s
.19324 .83194 m
.20688 .86877 L
s
.1785 .73043 m
.18038 .76961 L
s
.19343 .90056 m
.21633 .93814 L
s
.17601 .72257 m
.17706 .7623 L
s
.60823 .86019 m
.58949 .83764 L
s
.16329 .6772 m
.15947 .71948 L
s
.19282 .84749 m
.20853 .88471 L
s
.19187 .82299 m
.20446 .86012 L
s
.62744 .88162 m
.60742 .8587 L
s
.16435 .68165 m
.16102 .72375 L
s
.6392 .89548 m
.61811 .87213 L
s
.18684 .77006 m
.19309 .80765 L
s
.18737 1.01003 m
.22728 1.04951 L
s
.65106 .9097 m
.62879 .8859 L
s
.19175 .83406 m
.20578 .87142 L
s
.18911 .78506 m
.19708 .82229 L
s
.60822 .86052 m
.58937 .83783 L
s
.68606 .95191 m
.66013 .92724 L
s
.62506 .87912 m
.60515 .85617 L
s
.54039 .78749 m
.52511 .7673 L
s
.18018 .74496 m
.18372 .78402 L
s
.19071 .82359 m
.20345 .86111 L
s
.19093 .83519 m
.20516 .87284 L
s
.19155 .87533 m
.2111 .91333 L
s
.62854 .8834 m
.60823 .86019 L
s
.5547 .80301 m
.53864 .78194 L
s
.5078 .75364 m
.49381 .73551 L
s
.17889 .74472 m
.18247 .78421 L
s
.13871 .60602 m
.12721 .65342 L
s
.17373 .72535 m
.17521 .76593 L
s
.62865 .88387 m
.60822 .86052 L
s
.16793 .7044 m
.16715 .74617 L
s
.18822 .81013 m
.1994 .84821 L
s
.15828 .67133 m
.15393 .71505 L
s
.61811 .87213 m
.59842 .84898 L
s
.64662 .90547 m
.62442 .88135 L
s
.17941 .75326 m
.18399 .79284 L
s
.1891 .87714 m
.20911 .916 L
s
.54741 .79582 m
.53148 .77483 L
s
.18692 .80932 m
.19808 .84781 L
s
.59999 .8529 m
.58119 .8298 L
s
.17447 .73772 m
.1774 .77845 L
s
.6426 .9013 m
.62058 .87705 L
s
.68271 .94955 m
.65657 .9242 L
s
.1816 .7708 m
.18822 .81013 L
s
.1638 .70021 m
.16268 .74321 L
s
.18698 .90347 m
.21087 .9433 L
s
.15285 .66251 m
.14763 .70768 L
s
.17742 .75408 m
.18221 .79433 L
s
.18679 .90242 m
.21055 .9423 L
s
.60357 .85713 m
.58445 .83381 L
s
.18372 .78402 m
.19187 .82299 L
s
.60773 .86176 m
.58834 .83832 L
s
.34751 .62458 m
.33631 .62513 L
s
.18399 .79284 m
.19324 .83194 L
s
.15244 .66306 m
.14729 .70841 L
s
.18358 .97364 m
.21823 1.01478 L
s
.18038 .76961 m
.18692 .80932 L
s
.18522 .81939 m
.19779 .85865 L
s
.18611 .85219 m
.20296 .89173 L
s
.17633 .75451 m
.18123 .79512 L
s
.57157 .8226 m
.55413 .8001 L
s
.18247 .78421 m
.19071 .82359 L
s
.59998 .85374 m
.58089 .83026 L
s
.70752 .98093 m
.67824 .95481 L
s
.1844 .82889 m
.19827 .86862 L
s
.64327 .90294 m
.6209 .87829 L
s
.16098 .6982 m
.15973 .74206 L
s
.6889 .9581 m
.66175 .93221 L
s
.48231 .72886 m
.46878 .71224 L
s
.18288 .8029 m
.19347 .8426 L
s
.17706 .7623 m
.18288 .8029 L
s
.7445 1.02749 m
.71056 1.00119 L
s
.62879 .8859 m
.60773 .86176 L
s
.53188 .78025 m
.51633 .7597 L
s
.18221 .79433 m
.19175 .83406 L
s
.47197 .71866 m
.45876 .70299 L
s
.59811 .85193 m
.57905 .82839 L
s
.18123 .79512 m
.19093 .83519 L
s
.16589 .72232 m
.16735 .7654 L
s
.49166 .73856 m
.47769 .72095 L
s
.12428 .58434 m
.11046 .63563 L
s
.1832 .85837 m
.20112 .899 L
s
.18158 .80726 m
.19282 .84749 L
s
.17139 .74506 m
.17537 .78705 L
s
.64149 .90153 m
.61905 .87664 L
s
.62442 .88135 m
.60357 .85713 L
s
.62058 .87705 m
.59999 .8529 L
s
.18261 .87916 m
.20345 .92026 L
s
.52903 .7777 m
.51343 .7571 L
s
.56503 .8165 m
.5476 .79382 L
s
.17521 .76593 m
.18158 .80726 L
s
.54545 .79545 m
.52899 .77374 L
s
.18109 .83285 m
.19572 .87377 L
s
.56826 .82015 m
.55059 .79725 L
s
.1774 .77845 m
.18522 .81939 L
s
.11739 .56973 m
.10192 .62267 L
s
.69495 .96703 m
.66659 .94036 L
s
.1548 .69136 m
.15296 .73706 L
s
.18054 .85581 m
.19832 .89731 L
s
.69237 .96419 m
.6642 .93742 L
s
.66141 .92638 m
.63663 .90037 L
s
.70717 .98249 m
.67725 .95549 L
s
.6209 .87829 m
.59998 .85374 L
s
.54628 .79696 m
.52954 .77489 L
s
.16715 .74617 m
.17148 .78962 L
s
.61905 .87664 m
.59811 .85193 L
s
.16102 .72375 m
.16288 .76853 L
s
.17537 .78705 m
.1844 .82889 L
s
.15947 .71948 m
.16087 .76464 L
s
.17658 .83286 m
.19155 .87533 L
s
.57309 .82673 m
.5547 .80301 L
s
.66734 .9349 m
.64149 .90813 L
s
.55808 .81066 m
.54039 .78749 L
s
.17473 .93628 m
.20462 .98064 L
s
.1741 .80937 m
.18611 .85219 L
s
.17502 .85712 m
.19343 .90056 L
s
.16268 .74321 m
.16688 .78809 L
s
.17172 .98547 m
.20957 1.03091 L
s
.47306 .72124 m
.45907 .70445 L
s
.59125 .84729 m
.57157 .8226 L
s
.16735 .7654 m
.1741 .80937 L
s
.17381 .83371 m
.1891 .87714 L
s
.68022 .95138 m
.65268 .9239 L
s
.17148 .78962 m
.18109 .83285 L
s
.15393 .71505 m
.15504 .76195 L
s
.56575 .81969 m
.54741 .79582 L
s
.66013 .92724 m
.63466 .90019 L
s
.15973 .74206 m
.16394 .78792 L
s
.13318 .64587 m
.12656 .69712 L
s
.1718 .92144 m
.19976 .96678 L
s
.71426 .99447 m
.6824 .96596 L
s
.17029 .81413 m
.1832 .85837 L
s
.52426 .77536 m
.5078 .75364 L
s
.58826 .84543 m
.56826 .82015 L
s
.58484 .84166 m
.56503 .8165 L
s
.35963 .62706 m
.34751 .62458 L
s
.65657 .9242 m
.63103 .89669 L
s
.16688 .78809 m
.17658 .83286 L
s
.16288 .76853 m
.17029 .81413 L
s
.1679 .81082 m
.18054 .85581 L
s
.14763 .70768 m
.14811 .75651 L
s
.12175 .61958 m
.11224 .67363 L
s
.63663 .90037 m
.61305 .87355 L
s
.14729 .70841 m
.14788 .75738 L
s
.16087 .76464 m
.1679 .81082 L
s
.16793 .85752 m
.18698 .90347 L
s
.16789 .85647 m
.18679 .90242 L
s
.16685 .83329 m
.18261 .87916 L
s
.61305 .87355 m
.59125 .84729 L
s
.15296 .73706 m
.15689 .78509 L
s
.55 .80413 m
.53188 .78025 L
s
.16394 .78792 m
.17381 .83371 L
s
.56445 .82024 m
.54545 .79545 L
s
.59383 .85271 m
.57309 .82673 L
s
.66175 .93221 m
.63507 .90373 L
s
.73773 1.02724 m
.70177 .9971 L
s
.54724 .80175 m
.52903 .7777 L
s
.12721 .65342 m
.12172 .70717 L
s
.56558 .82213 m
.54628 .79696 L
s
.10986 .59964 m
.09817 .65697 L
s
.16207 .81009 m
.17502 .85712 L
s
.64149 .90813 m
.61677 .88023 L
s
.15504 .76195 m
.16207 .81009 L
s
.63466 .90019 m
.61051 .87245 L
s
.16091 .9514 m
.19461 1.00092 L
s
.49832 .74949 m
.48231 .72886 L
s
.5783 .83664 m
.55808 .81066 L
s
.61051 .87245 m
.58826 .84543 L
s
.50819 .76017 m
.49166 .73856 L
s
.48761 .73841 m
.47197 .71866 L
s
.60694 .86871 m
.58484 .84166 L
s
.58658 .84615 m
.56575 .81969 L
s
.63103 .89669 m
.60694 .86871 L
s
.15689 .78509 m
.16685 .83329 L
s
.61677 .88023 m
.59383 .85271 L
s
.6642 .93742 m
.63648 .90781 L
s
.66659 .94036 m
.63859 .91066 L
s
.67824 .95481 m
.64889 .92467 L
s
.14811 .75651 m
.15484 .80694 L
s
.14788 .75738 m
.15474 .80792 L
s
.65268 .9239 m
.626 .89447 L
s
.15484 .80694 m
.16789 .85647 L
s
.15474 .80792 m
.16793 .85752 L
s
.15374 .9216 m
.18358 .97364 L
s
.63507 .90373 m
.60981 .87453 L
s
.58607 .84779 m
.56445 .82024 L
s
.15174 .957 m
.18737 1.01003 L
s
.67725 .95549 m
.64734 .92447 L
s
.74435 1.04056 m
.70578 1.00809 L
s
.11046 .63563 m
.1033 .69467 L
s
.60981 .87453 m
.58658 .84615 L
s
.60103 .86491 m
.5783 .83664 L
s
.57085 .83126 m
.55 .80413 L
s
.54353 .80093 m
.52426 .77536 L
s
.12656 .69712 m
.12668 .7531 L
s
.58753 .85006 m
.56558 .82213 L
s
.48966 .74244 m
.47306 .72124 L
s
.15034 .88345 m
.17473 .93628 L
s
.14954 .86857 m
.1718 .92144 L
s
.37305 .63339 m
.35963 .62706 L
s
.56825 .82918 m
.54724 .80175 L
s
.10192 .62267 m
.09337 .68424 L
s
.626 .89447 m
.60103 .86491 L
s
.63648 .90781 m
.6102 .87738 L
s
.63859 .91066 m
.612 .87999 L
s
.6102 .87738 m
.58607 .84779 L
s
.12172 .70717 m
.12341 .76539 L
s
.73181 1.02824 m
.69358 .99404 L
s
.11224 .67363 m
.10995 .7339 L
s
.71056 1.00119 m
.67513 .96734 L
s
.612 .87999 m
.58753 .85006 L
s
.6824 .96596 m
.65041 .9328 L
s
.64889 .92467 m
.62067 .89278 L
s
.52772 .7862 m
.50819 .76017 L
s
.59448 .86114 m
.57085 .83126 L
s
.5173 .7747 m
.49832 .74949 L
s
.13934 .92783 m
.17172 .98547 L
s
.50619 .7629 m
.48761 .73841 L
s
.12668 .7531 m
.13429 .81131 L
s
.59213 .85953 m
.56825 .82918 L
s
.64734 .92447 m
.61866 .8918 L
s
.13429 .81131 m
.14954 .86857 L
s
.56587 .83028 m
.54353 .80093 L
s
.09817 .65697 m
.09429 .72182 L
s
.13296 .82529 m
.15034 .88345 L
s
.13354 .89199 m
.16091 .9514 L
s
.62067 .89278 m
.59448 .86114 L
s
.12341 .76539 m
.13296 .82529 L
s
.13074 .86169 m
.15374 .9216 L
s
.61866 .8918 m
.59213 .85953 L
s
.1033 .69467 m
.10429 .75938 L
s
.50942 .7687 m
.48966 .74244 L
s
.10995 .7339 m
.11598 .79777 L
s
.70177 .9971 m
.66489 .95994 L
s
.38831 .64468 m
.37305 .63339 L
s
.65041 .9328 m
.61971 .89766 L
s
.12306 .89341 m
.15174 .957 L
s
.59133 .8629 m
.56587 .83028 L
s
.09337 .68424 m
.09347 .75236 L
s
.55063 .8168 m
.52772 .7862 L
s
.53969 .80477 m
.5173 .7747 L
s
.11598 .79777 m
.13074 .86169 L
s
.52824 .7926 m
.50619 .7629 L
s
.11436 .82653 m
.13354 .89199 L
s
.1148 .8616 m
.13934 .92783 L
s
.61971 .89766 m
.59133 .8629 L
s
.67513 .96734 m
.64014 .92912 L
s
.10429 .75938 m
.11436 .82653 L
s
.09429 .72182 m
.09963 .79136 L
s
.70578 1.00809 m
.66616 .96777 L
s
.69358 .99404 m
.65499 .95332 L
s
.53287 .80044 m
.50942 .7687 L
s
.57712 .85164 m
.55063 .8168 L
s
.09347 .75236 m
.10331 .82358 L
s
.10331 .82358 m
.12306 .89341 L
s
.09963 .79136 m
.1148 .8616 L
s
.56581 .83957 m
.53969 .80477 L
s
.66489 .95994 m
.62904 .91926 L
s
.81317 1.15712 m
.75467 1.11215 L
s
.64014 .92912 m
.60712 .88968 L
s
.40618 .66237 m
.38831 .64468 L
s
.55418 .82755 m
.52824 .7926 L
s
.60712 .88968 m
.57712 .85164 L
s
.59572 .87829 m
.56581 .83957 L
s
.56041 .83755 m
.53287 .80044 L
s
.62904 .91926 m
.59572 .87829 L
s
.65499 .95332 m
.61805 .9099 L
s
.66616 .96777 m
.62773 .92357 L
s
.58419 .86715 m
.55418 .82755 L
s
.59215 .87921 m
.56041 .83755 L
s
.61805 .9099 m
.58419 .86715 L
s
.62773 .92357 m
.59215 .87921 L
s
.42766 .68815 m
.40618 .66237 L
s
.454 .72376 m
.42766 .68815 L
s
.75467 1.11215 m
.69204 1.04793 L
s
.48656 .77066 m
.454 .72376 L
s
.52661 .82932 m
.48656 .77066 L
s
.69204 1.04793 m
.63072 .97358 L
s
.57482 .89834 m
.52661 .82932 L
s
.63072 .97358 m
.57482 .89834 L
s
.25 Mabswid
.53814 0 m
.93025 .55706 L
s
.93025 .55706 m
1 1.35457 L
s
1 1.35457 m
.53815 .87334 L
s
.53815 .87334 m
.53814 0 L
s
.09234 .18581 m
0 1.03786 L
s
0 1.03786 m
.53815 .87334 L
s
.53815 .87334 m
.53814 0 L
s
.53814 0 m
.09234 .18581 L
s
.09234 .18581 m
.53814 0 L
s
.11362 .17694 m
.1199 .18407 L
s
[(-10)] .10106 .16269 .88106 1 Mshowa
.20098 .14053 m
.20711 .14779 L
s
[(-5)] .18874 .12601 .84296 1 Mshowa
.29043 .10325 m
.29638 .11065 L
s
[(0)] .27852 .08845 .80487 1 Mshowa
.38202 .06507 m
.3878 .07261 L
s
[(5)] .37047 .05 .76678 1 Mshowa
.47585 .02596 m
.48144 .03364 L
s
[(10)] .46466 .01061 .72868 1 Mshowa
.125 Mabswid
.13093 .16973 m
.13468 .17402 L
s
.14832 .16248 m
.15205 .16679 L
s
.16579 .1552 m
.1695 .15952 L
s
.18335 .14788 m
.18704 .15222 L
s
.2187 .13314 m
.22236 .13752 L
s
.23651 .12572 m
.24014 .13011 L
s
.2544 .11827 m
.25801 .12267 L
s
.27237 .11077 m
.27596 .1152 L
s
.30857 .09568 m
.31212 .10014 L
s
.3268 .08809 m
.33033 .09256 L
s
.34512 .08045 m
.34863 .08494 L
s
.36353 .07278 m
.36702 .07728 L
s
.40061 .05732 m
.40405 .06186 L
s
.41928 .04954 m
.42271 .05409 L
s
.43805 .04172 m
.44145 .04629 L
s
.4569 .03386 m
.46028 .03845 L
s
.09639 .18412 m
.10017 .18838 L
s
.49489 .01802 m
.49822 .02265 L
s
.51402 .01005 m
.51733 .01469 L
s
.53325 .00204 m
.53654 .00669 L
s
.25 Mabswid
0 1.03786 m
.538 1.46125 L
s
.13415 1.14343 m
.1349 1.13396 L
s
[(-10)] .13264 1.16236 .07966 -1 Mshowa
.26118 1.2434 m
.26169 1.23392 L
s
[(0)] .26016 1.26237 .05355 -1 Mshowa
.37684 1.33442 m
.37713 1.32493 L
s
[(10)] .37626 1.35341 .03064 -1 Mshowa
.48258 1.41764 m
.48268 1.40814 L
s
[(20)] .48239 1.43663 .01038 -1 Mshowa
.125 Mabswid
.02315 1.05608 m
.02374 1.05041 L
s
.05174 1.07858 m
.0523 1.07291 L
s
.07976 1.10063 m
.08028 1.09495 L
s
.10722 1.12224 m
.10771 1.11656 L
s
.16054 1.1642 m
.16096 1.15852 L
s
.18643 1.18457 m
.18682 1.17889 L
s
.21182 1.20456 m
.21218 1.19887 L
s
.23673 1.22416 m
.23707 1.21847 L
s
.28517 1.26228 m
.28545 1.25659 L
s
.30872 1.28081 m
.30897 1.27512 L
s
.33184 1.29901 m
.33206 1.29331 L
s
.35454 1.31687 m
.35474 1.31118 L
s
.39874 1.35166 m
.39889 1.34596 L
s
.42025 1.36859 m
.42038 1.36289 L
s
.44139 1.38522 m
.4415 1.37953 L
s
.46217 1.40157 m
.46225 1.39587 L
s
.50265 1.43343 m
.50269 1.42774 L
s
.52239 1.44896 m
.5224 1.44327 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["NDSolve", "MR"],
  " solves a particular set of differential equations, it always tries to \
choose a step size appropriate for those equations. In some cases, the very \
first step that ",
  StyleBox["NDSolve", "MR"],
  " makes may be too large, and it may miss an important feature in the \
solution. To avoid this problem, you can explicitly set the option ",
  StyleBox["StartingStepSize", "MR"],
  " to specify the size to use for the first step. "
}], "Text",
  CellTags->{"S3.9.7", "7.43"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NDSolve[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "find a numerical solution for ",
              StyleBox["y", "TI"],
              " with ",
              StyleBox["x", "TI"],
              " in the range ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NDSolve[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, {",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "find numerical solutions for all the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.9.7"],

Cell["\<\
Finding numerical solutions to differential\[Hyphen]algebraic \
equations. \
\>", "Caption",
  CellTags->"S3.9.7"],

Cell[TextData[{
  "The equations you give to ",
  StyleBox["NDSolve", "MR"],
  " do not necessarily all have to involve derivatives; they can also just be \
algebraic. You can use ",
  StyleBox["NDSolve", "MR"],
  " to solve many such ",
  StyleBox["differential\[Hyphen]algebraic equations", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.9.7", "7.44"}],

Cell["\<\
This solves a system of differential\[Hyphen]algebraic equations. \
\
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.45"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[{x'[t] == y[t]^2 + x[t] y[t], 2 x[t]^2 + y[t]^2 == 1, x[0] \
== 0, y[0] == 1}, {x, y}, {t, 0, 5}]\
\>", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"x", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 5.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"y", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 5.`}}, "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell["Here is the solution. ", "MathCaption",
  CellTags->{"S3.9.7", "7.46"}],

Cell[CellGroupData[{

Cell["Plot[Evaluate[{x[t], y[t]} /. %], {t, 0, 5}]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S3.9.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.190476 0.23003 0.373289 [
[.21429 .21753 -3 -9 ]
[.21429 .21753 3 0 ]
[.40476 .21753 -3 -9 ]
[.40476 .21753 3 0 ]
[.59524 .21753 -3 -9 ]
[.59524 .21753 3 0 ]
[.78571 .21753 -3 -9 ]
[.78571 .21753 3 0 ]
[.97619 .21753 -3 -9 ]
[.97619 .21753 3 0 ]
[.01131 .04338 -24 -4.5 ]
[.01131 .04338 0 4.5 ]
[.01131 .13671 -30 -4.5 ]
[.01131 .13671 0 4.5 ]
[.01131 .32335 -24 -4.5 ]
[.01131 .32335 0 4.5 ]
[.01131 .41667 -18 -4.5 ]
[.01131 .41667 0 4.5 ]
[.01131 .51 -24 -4.5 ]
[.01131 .51 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .23003 m
.21429 .23628 L
s
[(1)] .21429 .21753 0 1 Mshowa
.40476 .23003 m
.40476 .23628 L
s
[(2)] .40476 .21753 0 1 Mshowa
.59524 .23003 m
.59524 .23628 L
s
[(3)] .59524 .21753 0 1 Mshowa
.78571 .23003 m
.78571 .23628 L
s
[(4)] .78571 .21753 0 1 Mshowa
.97619 .23003 m
.97619 .23628 L
s
[(5)] .97619 .21753 0 1 Mshowa
.125 Mabswid
.0619 .23003 m
.0619 .23378 L
s
.1 .23003 m
.1 .23378 L
s
.1381 .23003 m
.1381 .23378 L
s
.17619 .23003 m
.17619 .23378 L
s
.25238 .23003 m
.25238 .23378 L
s
.29048 .23003 m
.29048 .23378 L
s
.32857 .23003 m
.32857 .23378 L
s
.36667 .23003 m
.36667 .23378 L
s
.44286 .23003 m
.44286 .23378 L
s
.48095 .23003 m
.48095 .23378 L
s
.51905 .23003 m
.51905 .23378 L
s
.55714 .23003 m
.55714 .23378 L
s
.63333 .23003 m
.63333 .23378 L
s
.67143 .23003 m
.67143 .23378 L
s
.70952 .23003 m
.70952 .23378 L
s
.74762 .23003 m
.74762 .23378 L
s
.82381 .23003 m
.82381 .23378 L
s
.8619 .23003 m
.8619 .23378 L
s
.9 .23003 m
.9 .23378 L
s
.9381 .23003 m
.9381 .23378 L
s
.25 Mabswid
0 .23003 m
1 .23003 L
s
.02381 .04338 m
.03006 .04338 L
s
[(-0.5)] .01131 .04338 1 0 Mshowa
.02381 .13671 m
.03006 .13671 L
s
[(-0.25)] .01131 .13671 1 0 Mshowa
.02381 .32335 m
.03006 .32335 L
s
[(0.25)] .01131 .32335 1 0 Mshowa
.02381 .41667 m
.03006 .41667 L
s
[(0.5)] .01131 .41667 1 0 Mshowa
.02381 .51 m
.03006 .51 L
s
[(0.75)] .01131 .51 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .06205 m
.02756 .06205 L
s
.02381 .08071 m
.02756 .08071 L
s
.02381 .09938 m
.02756 .09938 L
s
.02381 .11804 m
.02756 .11804 L
s
.02381 .15537 m
.02756 .15537 L
s
.02381 .17404 m
.02756 .17404 L
s
.02381 .1927 m
.02756 .1927 L
s
.02381 .21137 m
.02756 .21137 L
s
.02381 .24869 m
.02756 .24869 L
s
.02381 .26736 m
.02756 .26736 L
s
.02381 .28602 m
.02756 .28602 L
s
.02381 .30469 m
.02756 .30469 L
s
.02381 .34202 m
.02756 .34202 L
s
.02381 .36068 m
.02756 .36068 L
s
.02381 .37935 m
.02756 .37935 L
s
.02381 .39801 m
.02756 .39801 L
s
.02381 .43534 m
.02756 .43534 L
s
.02381 .454 m
.02756 .454 L
s
.02381 .47267 m
.02756 .47267 L
s
.02381 .49133 m
.02756 .49133 L
s
.02381 .52866 m
.02756 .52866 L
s
.02381 .54733 m
.02756 .54733 L
s
.02381 .56599 m
.02756 .56599 L
s
.02381 .58465 m
.02756 .58465 L
s
.02381 .02472 m
.02756 .02472 L
s
.02381 .00606 m
.02756 .00606 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .23003 m
.06244 .31132 L
.10458 .39833 L
.12507 .43259 L
.14415 .45742 L
.16254 .47458 L
.17284 .48148 L
.18221 .48625 L
.18704 .48819 L
.19216 .48989 L
.19659 .4911 L
.20135 .49213 L
.20402 .4926 L
.20646 .49296 L
.20894 .49327 L
.21124 .49351 L
.21391 .49371 L
.21533 .4938 L
.21683 .49387 L
.21752 .4939 L
.21826 .49392 L
.21892 .49394 L
.21961 .49396 L
.22093 .49398 L
.22214 .49398 L
.22336 .49398 L
.22405 .49397 L
.22468 .49396 L
.22585 .49394 L
.2271 .4939 L
.22924 .49382 L
.23162 .49369 L
.23686 .49329 L
.24178 .49279 L
.2506 .49163 L
.26011 .49008 L
.30125 .48157 L
.34087 .47314 L
.37898 .46621 L
.41954 .46041 L
.45859 .45624 L
.50009 .45301 L
.54007 .4508 L
.57853 .44928 L
.59802 .44868 L
.61945 .44813 L
.65886 .44736 L
.6783 .44707 L
.6992 .44681 L
.71894 .4466 L
Mistroke
.74047 .44642 L
.78023 .44615 L
.79995 .44605 L
.82093 .44597 L
.84094 .4459 L
.86257 .44583 L
.90268 .44575 L
.92266 .44571 L
.94374 .44569 L
.97619 .44565 L
Mfstroke
.02381 .60332 m
.02499 .6033 L
.02605 .60327 L
.02729 .60319 L
.02846 .60309 L
.03053 .60284 L
.03279 .60245 L
.03527 .60189 L
.0379 .60113 L
.04262 .59933 L
.04749 .59687 L
.05205 .59398 L
.06244 .58518 L
.07305 .57294 L
.08274 .55883 L
.10458 .5176 L
.14429 .41923 L
.18248 .31907 L
.22313 .22836 L
.26226 .16299 L
.28367 .13562 L
.30384 .11438 L
.34239 .08362 L
.36233 .07168 L
.38339 .06135 L
.42136 .04728 L
.44087 .04182 L
.46179 .03699 L
.4816 .03321 L
.50315 .02983 L
.543 .02512 L
.56277 .02336 L
.58378 .02181 L
.62153 .01968 L
.64087 .01884 L
.66173 .01809 L
.68138 .0175 L
.70287 .01697 L
.74249 .01622 L
.76211 .01594 L
.78306 .01569 L
.80297 .0155 L
.82455 .01532 L
.86454 .01507 L
.88441 .01498 L
.90545 .0149 L
.94334 .01479 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NDSolve[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["u", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve a system of partial differential equations for ",
              StyleBox["u", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NDSolve[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["eqn",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, {",
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "solve a system of partial differential equations for several \
functions ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["u",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.9.7"],

Cell["\<\
Finding numerical solutions to partial differential equations. \
\
\>", "Caption",
  CellTags->"S3.9.7"],

Cell["\<\
This finds a numerical solution to the wave equation. The result is \
a two\[Hyphen]dimensional interpolating function. \
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.47"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[{D[u[t, x], t, t] == D[u[t, x], x, x], u[0, x] == \
Exp[-x^2], Derivative[1,0][u][0, x] == 0, u[t, -6] == u[t, 6]}, u, {t, 0, 6}, \
{x, -6, 6}]\
\>", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{0.`, 6.`}, {"...", \(-6.`\), 6.`, 
                  "..."}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[29]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell["This generates a plot of the result. ", "MathCaption",
  CellTags->{"S3.9.7", "7.48"}],

Cell[CellGroupData[{

Cell["\<\
Plot3D[Evaluate[u[t, x] /. First[%]], {t, 0, 6}, {x, -6, 6}, \
PlotPoints->50]\
\>", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S3.9.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
2.63732e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.22808 .16727 -5.79519 -9 ]
[.22808 .16727 .20481 0 ]
[.44535 .08183 -5.37821 -9 ]
[.44535 .08183 .62179 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.72942 .0388 0 -6.21888 ]
[.72942 .0388 12 2.78112 ]
[.79593 .14064 0 -6.11966 ]
[.79593 .14064 24 2.88034 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.91188 .3182 0 -5.95203 ]
[.91188 .3182 18 3.04797 ]
[.96273 .39607 0 -5.88058 ]
[.96273 .39607 6 3.11942 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01569 .31792 -24 -2.78697 ]
[.01569 .31792 0 6.21303 ]
[.00697 .37258 -18 -2.83334 ]
[.00697 .37258 0 6.16666 ]
[-0.00206 .42918 -24 -2.88153 ]
[-0.00206 .42918 0 6.11847 ]
[-0.01142 .48782 -6 -2.93165 ]
[-0.01142 .48782 0 6.06835 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.23703 .17687 m
.2415 .18167 L
s
[(2)] .22808 .16727 .93173 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(4)] .44535 .08183 .79274 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(6)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.08568 .23614 m
.08851 .23887 L
s
.13514 .21677 m
.13793 .21955 L
s
.18558 .19702 m
.18832 .19985 L
s
.28951 .15632 m
.29214 .15925 L
s
.34306 .13535 m
.34564 .13834 L
s
.39772 .11395 m
.40023 .11699 L
s
.51046 .06981 m
.51284 .07294 L
s
.56863 .04703 m
.57093 .05022 L
s
.62804 .02377 m
.63027 .02701 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.71716 .04348 m
.71104 .04583 L
s
[(-5)] .72942 .0388 -1 .38197 Mshowa
.78358 .14509 m
.77741 .14731 L
s
[(-2.5)] .79593 .14064 -1 .35992 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.89939 .32223 m
.89315 .32425 L
s
[(2.5)] .91188 .3182 -1 .32267 Mshowa
.95018 .39992 m
.94391 .40184 L
s
[(5)] .96273 .39607 -1 .3068 Mshowa
.125 Mabswid
.73096 .06459 m
.72728 .06598 L
s
.7445 .0853 m
.74081 .08667 L
s
.75778 .10561 m
.75408 .10697 L
s
.7708 .12553 m
.7671 .12688 L
s
.79613 .16428 m
.79242 .1656 L
s
.80845 .18312 m
.80473 .18442 L
s
.82054 .20161 m
.81682 .20291 L
s
.83241 .21978 m
.82869 .22106 L
s
.85553 .25514 m
.8518 .25639 L
s
.86679 .27235 m
.86305 .2736 L
s
.87784 .28927 m
.87411 .2905 L
s
.88871 .30589 m
.88497 .30711 L
s
.9099 .3383 m
.90615 .3395 L
s
.92022 .35409 m
.91647 .35528 L
s
.93037 .36962 m
.92662 .3708 L
s
.94036 .3849 m
.9366 .38606 L
s
.70309 .02196 m
.69942 .02338 L
s
.95984 .4147 m
.95608 .41584 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26034 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02795 .31325 m
.03408 .31092 L
s
[(0.25)] .01569 .31792 1 -0.38067 Mshowa
.01927 .36802 m
.02542 .36574 L
s
[(0.5)] .00697 .37258 1 -0.37037 Mshowa
.01028 .42474 m
.01646 .42252 L
s
[(0.75)] -0.00206 .42918 1 -0.35966 Mshowa
.00097 .4835 m
.00717 .48134 L
s
[(1)] -0.01142 .48782 1 -0.34852 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03302 .28129 m
.03669 .27987 L
s
.03134 .29187 m
.03501 .29046 L
s
.02965 .30253 m
.03333 .30112 L
s
.02624 .32406 m
.02992 .32266 L
s
.02451 .33493 m
.0282 .33355 L
s
.02278 .34589 m
.02647 .34451 L
s
.02103 .35692 m
.02472 .35554 L
s
.0175 .37921 m
.02119 .37785 L
s
.01571 .39047 m
.01941 .38911 L
s
.01392 .40181 m
.01762 .40046 L
s
.01211 .41323 m
.01581 .41189 L
s
.00845 .43632 m
.01215 .435 L
s
.0066 .44799 m
.01031 .44667 L
s
.00474 .45974 m
.00845 .45843 L
s
.00286 .47158 m
.00657 .47028 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.664 .741 .908 r
.39889 .59792 .40512 .60371 .41558 .60058 .40937 .59476 Metetra
.664 .741 .908 r
.40937 .59476 .41558 .60058 .42607 .59743 .41989 .59159 Metetra
.664 .741 .908 r
.41989 .59159 .42607 .59743 .4366 .59427 .43045 .5884 Metetra
.664 .741 .908 r
.43045 .5884 .4366 .59427 .44718 .5911 .44106 .58521 Metetra
.664 .741 .908 r
.44106 .58521 .44718 .5911 .4578 .58791 .4517 .582 Metetra
.664 .741 .908 r
.4517 .582 .4578 .58791 .46846 .58471 .46239 .57878 Metetra
.664 .741 .908 r
.46239 .57878 .46846 .58471 .47916 .5815 .47312 .57554 Metetra
.664 .741 .908 r
.47312 .57554 .47916 .5815 .4899 .57828 .48389 .5723 Metetra
.664 .741 .908 r
.48389 .5723 .4899 .57828 .50069 .57504 .4947 .56904 Metetra
.664 .741 .908 r
.4947 .56904 .50069 .57504 .51152 .5718 .50556 .56576 Metetra
.664 .741 .908 r
.50556 .56576 .51152 .5718 .52239 .56853 .51646 .56248 Metetra
.664 .741 .908 r
.51646 .56248 .52239 .56853 .5333 .56526 .5274 .55918 Metetra
.664 .741 .908 r
.5274 .55918 .5333 .56526 .54426 .56197 .53839 .55587 Metetra
.664 .741 .908 r
.53839 .55587 .54426 .56197 .55526 .55867 .54942 .55254 Metetra
.664 .741 .908 r
.54942 .55254 .55526 .55867 .56631 .55536 .56049 .54921 Metetra
.664 .741 .908 r
.56049 .54921 .56631 .55536 .5774 .55203 .57161 .54585 Metetra
.664 .741 .908 r
.57161 .54585 .5774 .55203 .58853 .54869 .58277 .54249 Metetra
.664 .741 .908 r
.58277 .54249 .58853 .54869 .59971 .54534 .59398 .53911 Metetra
.664 .741 .908 r
.59398 .53911 .59971 .54534 .61094 .54197 .60524 .53572 Metetra
.664 .741 .908 r
.60524 .53572 .61094 .54197 .62221 .53859 .61654 .53231 Metetra
.663 .741 .908 r
.61654 .53231 .62221 .53859 .63352 .5352 .62788 .5289 Metetra
.663 .741 .908 r
.62788 .5289 .63352 .5352 .64488 .53179 .63928 .52547 Metetra
.663 .741 .908 r
.63928 .52547 .64488 .53179 .65629 .52837 .65072 .52203 Metetra
.663 .741 .908 r
.65072 .52203 .65629 .52837 .66774 .52495 .6622 .51859 Metetra
.662 .742 .909 r
.6622 .51859 .66774 .52495 .67925 .52151 .67374 .51515 Metetra
.661 .742 .91 r
.67374 .51515 .67925 .52151 .69079 .51809 .68532 .51172 Metetra
.659 .742 .911 r
.68532 .51172 .69079 .51809 .70239 .51468 .69695 .50834 Metetra
.656 .743 .914 r
.69695 .50834 .70239 .51468 .71404 .51131 .70864 .50504 Metetra
.651 .744 .918 r
.70864 .50504 .71404 .51131 .72575 .50803 .72039 .50187 Metetra
.642 .745 .924 r
.72039 .50187 .72575 .50803 .73751 .5049 .7322 .49891 Metetra
.628 .747 .933 r
.7322 .49891 .73751 .5049 .74934 .50202 .74409 .4963 Metetra
.604 .749 .946 r
.74409 .4963 .74934 .50202 .76126 .49954 .75607 .49418 Metetra
.565 .748 .963 r
.75607 .49418 .76126 .49954 .77328 .49764 .76816 .49277 Metetra
.497 .738 .98 r
.76816 .49277 .77328 .49764 .78543 .49659 .78039 .49233 Metetra
.38 .706 .985 r
.78039 .49233 .78543 .49659 .79774 .49672 .79281 .49315 Metetra
.188 .622 .945 r
.79281 .49315 .79774 .49672 .81027 .49838 .80544 .49555 Metetra
0 .46 .815 r
.80544 .49555 .81027 .49838 .82306 .50199 .81833 .49985 Metetra
.33 0 0 r
.81833 .49985 .82306 .50199 .83617 .50793 .83154 .50631 Metetra
.51 0 0 r
.83154 .50631 .83617 .50793 .84967 .51652 .8451 .51512 Metetra
.613 .05 0 r
.8451 .51512 .84967 .51652 .86361 .52794 .85905 .52629 Metetra
.661 .114 0 r
.85905 .52629 .86361 .52794 .878 .54213 .8734 .53963 Metetra
.663 .128 0 r
.8734 .53963 .878 .54213 .89285 .55874 .88812 .55473 Metetra
.6 .085 0 r
.88812 .55473 .89285 .55874 .90811 .57706 .90316 .57086 Metetra
0 .026 .558 r
.90316 .57086 .90811 .57706 .92367 .596 .91843 .58707 Metetra
0 .189 .721 r
.91843 .58707 .92367 .596 .93938 .61416 .93378 .6022 Metetra
.149 .333 .793 r
.93378 .6022 .93938 .61416 .95501 .6299 .94905 .61495 Metetra
.361 .425 .792 r
.94905 .61495 .95501 .6299 .97035 .64162 .96406 .62412 Metetra
.499 .482 .77 r
.96406 .62412 .97035 .64162 .98515 .64791 .97863 .62867 Metetra
.592 .524 .747 r
.97863 .62867 .98515 .64791 .99922 .6478 .9926 .62789 Metetra
.664 .741 .908 r
.39262 .59207 .39889 .59792 .40937 .59476 .40313 .58889 Metetra
.664 .741 .908 r
.40313 .58889 .40937 .59476 .41989 .59159 .41367 .5857 Metetra
.664 .741 .908 r
.41367 .5857 .41989 .59159 .43045 .5884 .42426 .58249 Metetra
.664 .741 .908 r
.42426 .58249 .43045 .5884 .44106 .58521 .43489 .57927 Metetra
.664 .741 .908 r
.43489 .57927 .44106 .58521 .4517 .582 .44556 .57604 Metetra
.664 .741 .908 r
.44556 .57604 .4517 .582 .46239 .57878 .45627 .5728 Metetra
.664 .741 .908 r
.45627 .5728 .46239 .57878 .47312 .57554 .46703 .56954 Metetra
.664 .741 .908 r
.46703 .56954 .47312 .57554 .48389 .5723 .47782 .56627 Metetra
.664 .741 .908 r
.47782 .56627 .48389 .5723 .4947 .56904 .48867 .56299 Metetra
.664 .741 .908 r
.48867 .56299 .4947 .56904 .50556 .56576 .49955 .55969 Metetra
.664 .741 .908 r
.49955 .55969 .50556 .56576 .51646 .56248 .51048 .55638 Metetra
.664 .741 .908 r
.51048 .55638 .51646 .56248 .5274 .55918 .52145 .55306 Metetra
.664 .741 .908 r
.52145 .55306 .5274 .55918 .53839 .55587 .53246 .54972 Metetra
.664 .741 .908 r
.53246 .54972 .53839 .55587 .54942 .55254 .54352 .54637 Metetra
.664 .741 .908 r
.54352 .54637 .54942 .55254 .56049 .54921 .55463 .54301 Metetra
.664 .741 .908 r
.55463 .54301 .56049 .54921 .57161 .54585 .56578 .53963 Metetra
.664 .741 .908 r
.56578 .53963 .57161 .54585 .58277 .54249 .57697 .53624 Metetra
.664 .741 .908 r
.57697 .53624 .58277 .54249 .59398 .53911 .58821 .53284 Metetra
.663 .741 .908 r
.58821 .53284 .59398 .53911 .60524 .53572 .5995 .52942 Metetra
.663 .741 .908 r
.5995 .52942 .60524 .53572 .61654 .53231 .61083 .526 Metetra
.663 .741 .908 r
.61083 .526 .61654 .53231 .62788 .5289 .6222 .52256 Metetra
.663 .742 .908 r
.6222 .52256 .62788 .5289 .63928 .52547 .63363 .51912 Metetra
.662 .742 .909 r
.63363 .51912 .63928 .52547 .65072 .52203 .6451 .51568 Metetra
.661 .742 .91 r
.6451 .51568 .65072 .52203 .6622 .51859 .65662 .51225 Metetra
.66 .743 .912 r
.65662 .51225 .6622 .51859 .67374 .51515 .66819 .50887 Metetra
.657 .745 .915 r
.66819 .50887 .67374 .51515 .68532 .51172 .67981 .50555 Metetra
.652 .747 .92 r
.67981 .50555 .68532 .51172 .69695 .50834 .69149 .50234 Metetra
.644 .752 .928 r
.69149 .50234 .69695 .50834 .70864 .50504 .70323 .49933 Metetra
.63 .758 .94 r
.70323 .49933 .70864 .50504 .72039 .50187 .71504 .49662 Metetra
.605 .767 .957 r
.71504 .49662 .72039 .50187 .7322 .49891 .72693 .49432 Metetra
.561 .778 .98 r
.72693 .49432 .7322 .49891 .74409 .4963 .73892 .49262 Metetra
.474 .78 .998 r
.73892 .49262 .74409 .4963 .75607 .49418 .75103 .4917 Metetra
.295 .735 .965 r
.75103 .4917 .75607 .49418 .76816 .49277 .76328 .49179 Metetra
0 .557 .77 r
.76328 .49179 .76816 .49277 .78039 .49233 .7757 .49311 Metetra
.335 0 0 r
.7757 .49311 .78039 .49233 .79281 .49315 .78832 .49585 Metetra
.52 0 0 r
.78832 .49585 .79281 .49315 .80544 .49555 .80118 .50016 Metetra
.606 .114 .06 r
.80118 .50016 .80544 .49555 .81833 .49985 .81429 .5061 Metetra
.648 .192 .157 r
.81429 .5061 .81833 .49985 .83154 .50631 .82766 .51361 Metetra
.671 .234 .203 r
.82766 .51361 .83154 .50631 .8451 .51512 .84132 .52251 Metetra
.686 .25 .209 r
.84132 .52251 .8451 .51512 .85905 .52629 .85522 .53247 Metetra
.696 .242 .169 r
.85522 .53247 .85905 .52629 .8734 .53963 .86935 .54303 Metetra
.692 .188 .038 r
.86935 .54303 .8734 .53963 .88812 .55473 .88366 .55364 Metetra
.566 0 0 r
.88366 .55364 .88812 .55473 .90316 .57086 .89807 .56373 Metetra
.033 .376 .842 r
.89807 .56373 .90316 .57086 .91843 .58707 .91253 .5727 Metetra
.396 .453 .801 r
.91253 .5727 .91843 .58707 .93378 .6022 .92696 .58004 Metetra
.506 .451 .729 r
.92696 .58004 .93378 .6022 .94905 .61495 .94128 .58533 Metetra
.552 .448 .689 r
.94128 .58533 .94905 .61495 .96406 .62412 .95544 .58825 Metetra
.578 .448 .667 r
.95544 .58825 .96406 .62412 .97863 .62867 .96938 .5886 Metetra
.596 .451 .655 r
.96938 .5886 .97863 .62867 .9926 .62789 .98306 .58627 Metetra
.664 .741 .908 r
.3863 .58619 .39262 .59207 .40313 .58889 .39683 .58299 Metetra
.664 .741 .908 r
.39683 .58299 .40313 .58889 .41367 .5857 .4074 .57977 Metetra
.664 .741 .908 r
.4074 .57977 .41367 .5857 .42426 .58249 .41802 .57654 Metetra
.664 .741 .908 r
.41802 .57654 .42426 .58249 .43489 .57927 .42867 .5733 Metetra
.664 .741 .908 r
.42867 .5733 .43489 .57927 .44556 .57604 .43937 .57004 Metetra
.664 .741 .908 r
.43937 .57004 .44556 .57604 .45627 .5728 .45011 .56677 Metetra
.664 .741 .908 r
.45011 .56677 .45627 .5728 .46703 .56954 .46089 .56349 Metetra
.664 .741 .908 r
.46089 .56349 .46703 .56954 .47782 .56627 .47172 .5602 Metetra
.664 .741 .908 r
.47172 .5602 .47782 .56627 .48867 .56299 .48259 .55689 Metetra
.664 .741 .908 r
.48259 .55689 .48867 .56299 .49955 .55969 .4935 .55357 Metetra
.664 .741 .908 r
.4935 .55357 .49955 .55969 .51048 .55638 .50446 .55023 Metetra
.664 .741 .908 r
.50446 .55023 .51048 .55638 .52145 .55306 .51546 .54689 Metetra
.664 .741 .908 r
.51546 .54689 .52145 .55306 .53246 .54972 .5265 .54353 Metetra
.664 .741 .908 r
.5265 .54353 .53246 .54972 .54352 .54637 .53759 .54015 Metetra
.664 .741 .908 r
.53759 .54015 .54352 .54637 .55463 .54301 .54872 .53676 Metetra
.664 .741 .908 r
.54872 .53676 .55463 .54301 .56578 .53963 .5599 .53336 Metetra
.663 .741 .908 r
.5599 .53336 .56578 .53963 .57697 .53624 .57113 .52995 Metetra
.663 .741 .908 r
.57113 .52995 .57697 .53624 .58821 .53284 .5824 .52652 Metetra
.663 .741 .908 r
.5824 .52652 .58821 .53284 .5995 .52942 .59371 .52309 Metetra
.663 .742 .908 r
.59371 .52309 .5995 .52942 .61083 .526 .60507 .51965 Metetra
.662 .742 .909 r
.60507 .51965 .61083 .526 .6222 .52256 .61648 .51621 Metetra
.661 .742 .91 r
.61648 .51621 .6222 .52256 .63363 .51912 .62794 .51279 Metetra
.66 .743 .912 r
.62794 .51279 .63363 .51912 .6451 .51568 .63945 .5094 Metetra
.657 .745 .915 r
.63945 .5094 .6451 .51568 .65662 .51225 .651 .50609 Metetra
.652 .748 .92 r
.651 .50609 .65662 .51225 .66819 .50887 .66262 .50288 Metetra
.644 .752 .928 r
.66262 .50288 .66819 .50887 .67981 .50555 .67429 .49987 Metetra
.63 .759 .94 r
.67429 .49987 .67981 .50555 .69149 .50234 .68602 .49715 Metetra
.605 .769 .958 r
.68602 .49715 .69149 .50234 .70323 .49933 .69784 .49484 Metetra
.56 .781 .982 r
.69784 .49484 .70323 .49933 .71504 .49662 .70975 .4931 Metetra
.468 .785 .999 r
.70975 .4931 .71504 .49662 .72693 .49432 .72176 .49213 Metetra
.274 .733 .952 r
.72176 .49213 .72693 .49432 .73892 .49262 .73391 .49211 Metetra
0 .526 .71 r
.73391 .49211 .73892 .49262 .75103 .4917 .7462 .49325 Metetra
.372 0 0 r
.7462 .49325 .75103 .4917 .76328 .49179 .75868 .49569 Metetra
.532 .016 0 r
.75868 .49569 .76328 .49179 .7757 .49311 .77136 .49952 Metetra
.599 .143 .141 r
.77136 .49952 .7757 .49311 .78832 .49585 .78425 .50471 Metetra
.628 .211 .234 r
.78425 .50471 .78832 .49585 .80118 .50016 .79737 .5111 Metetra
.639 .247 .285 r
.79737 .5111 .80118 .50016 .81429 .5061 .81068 .5184 Metetra
.642 .262 .309 r
.81068 .5184 .81429 .5061 .82766 .51361 .82418 .52612 Metetra
.639 .26 .309 r
.82418 .52612 .82766 .51361 .84132 .52251 .83781 .53372 Metetra
.629 .236 .279 r
.83781 .53372 .84132 .52251 .85522 .53247 .85151 .54058 Metetra
.604 .169 .187 r
.85151 .54058 .85522 .53247 .86935 .54303 .86521 .54613 Metetra
.488 0 0 r
.86521 .54613 .86935 .54303 .88366 .55364 .87887 .54991 Metetra
.254 .664 .965 r
.87887 .54991 .88366 .55364 .89807 .56373 .89242 .5517 Metetra
.571 .589 .832 r
.89242 .5517 .89807 .56373 .91253 .5727 .90585 .55152 Metetra
.605 .516 .727 r
.90585 .55152 .91253 .5727 .92696 .58004 .91917 .54962 Metetra
.609 .48 .679 r
.91917 .54962 .92696 .58004 .94128 .58533 .93242 .54647 Metetra
.607 .459 .655 r
.93242 .54647 .94128 .58533 .95544 .58825 .94564 .54261 Metetra
.603 .446 .642 r
.94564 .54261 .95544 .58825 .96938 .5886 .95889 .53851 Metetra
.6 .439 .635 r
.95889 .53851 .96938 .5886 .98306 .58627 .97222 .53455 Metetra
.664 .741 .908 r
.37994 .58027 .3863 .58619 .39683 .58299 .39049 .57704 Metetra
.664 .741 .908 r
.39049 .57704 .39683 .58299 .4074 .57977 .40109 .5738 Metetra
.664 .741 .908 r
.40109 .5738 .4074 .57977 .41802 .57654 .41173 .57054 Metetra
.664 .741 .908 r
.41173 .57054 .41802 .57654 .42867 .5733 .42241 .56728 Metetra
.664 .741 .908 r
.42241 .56728 .42867 .5733 .43937 .57004 .43314 .564 Metetra
.664 .741 .908 r
.43314 .564 .43937 .57004 .45011 .56677 .4439 .5607 Metetra
.664 .741 .908 r
.4439 .5607 .45011 .56677 .46089 .56349 .45471 .5574 Metetra
.664 .741 .908 r
.45471 .5574 .46089 .56349 .47172 .5602 .46557 .55408 Metetra
.664 .741 .908 r
.46557 .55408 .47172 .5602 .48259 .55689 .47646 .55075 Metetra
.664 .741 .908 r
.47646 .55075 .48259 .55689 .4935 .55357 .4874 .5474 Metetra
.664 .741 .908 r
.4874 .5474 .4935 .55357 .50446 .55023 .49839 .54404 Metetra
.664 .741 .908 r
.49839 .54404 .50446 .55023 .51546 .54689 .50942 .54067 Metetra
.664 .741 .908 r
.50942 .54067 .51546 .54689 .5265 .54353 .52049 .53729 Metetra
.664 .741 .908 r
.52049 .53729 .5265 .54353 .53759 .54015 .53161 .53389 Metetra
.663 .741 .908 r
.53161 .53389 .53759 .54015 .54872 .53676 .54277 .53048 Metetra
.663 .741 .908 r
.54277 .53048 .54872 .53676 .5599 .53336 .55398 .52705 Metetra
.663 .741 .908 r
.55398 .52705 .5599 .53336 .57113 .52995 .56524 .52362 Metetra
.663 .742 .908 r
.56524 .52362 .57113 .52995 .5824 .52652 .57654 .52018 Metetra
.662 .742 .909 r
.57654 .52018 .5824 .52652 .59371 .52309 .58788 .51675 Metetra
.661 .742 .91 r
.58788 .51675 .59371 .52309 .60507 .51965 .59928 .51333 Metetra
.66 .743 .912 r
.59928 .51333 .60507 .51965 .61648 .51621 .61072 .50994 Metetra
.657 .745 .915 r
.61072 .50994 .61648 .51621 .62794 .51279 .62221 .50663 Metetra
.652 .748 .92 r
.62221 .50663 .62794 .51279 .63945 .5094 .63376 .50343 Metetra
.644 .752 .928 r
.63376 .50343 .63945 .5094 .651 .50609 .64536 .50042 Metetra
.63 .759 .94 r
.64536 .50042 .651 .50609 .66262 .50288 .65703 .49769 Metetra
.605 .77 .959 r
.65703 .49769 .66262 .50288 .67429 .49987 .66877 .49538 Metetra
.559 .782 .982 r
.66877 .49538 .67429 .49987 .68602 .49715 .6806 .49365 Metetra
.467 .785 .999 r
.6806 .49365 .68602 .49715 .69784 .49484 .69252 .49267 Metetra
.27 .732 .95 r
.69252 .49267 .69784 .49484 .70975 .4931 .70457 .49265 Metetra
.068 0 0 r
.70457 .49265 .70975 .4931 .72176 .49213 .71676 .49377 Metetra
.378 0 0 r
.71676 .49377 .72176 .49213 .73391 .49211 .72912 .49618 Metetra
.534 .023 0 r
.72912 .49618 .73391 .49211 .7462 .49325 .74166 .49995 Metetra
.598 .148 .153 r
.74166 .49995 .7462 .49325 .75868 .49569 .75439 .50504 Metetra
.625 .215 .246 r
.75439 .50504 .75868 .49569 .77136 .49952 .76733 .51125 Metetra
.633 .249 .299 r
.76733 .51125 .77136 .49952 .78425 .50471 .78046 .51823 Metetra
.633 .264 .326 r
.78046 .51823 .78425 .50471 .79737 .5111 .79374 .52545 Metetra
.626 .262 .333 r
.79374 .52545 .79737 .5111 .81068 .5184 .80713 .53228 Metetra
.61 .242 .32 r
.80713 .53228 .81068 .5184 .82418 .52612 .82055 .53799 Metetra
.58 .193 .274 r
.82055 .53799 .82418 .52612 .83781 .53372 .83394 .54189 Metetra
.506 .069 .144 r
.83394 .54189 .83781 .53372 .85151 .54058 .84721 .54341 Metetra
.19 0 0 r
.84721 .54341 .85151 .54058 .86521 .54613 .86031 .54222 Metetra
.632 .852 .983 r
.86031 .54222 .86521 .54613 .87887 .54991 .87321 .5383 Metetra
.699 .66 .807 r
.87321 .5383 .87887 .54991 .89242 .5517 .88591 .53195 Metetra
.682 .569 .721 r
.88591 .53195 .89242 .5517 .90585 .55152 .89844 .52375 Metetra
.664 .521 .68 r
.89844 .52375 .90585 .55152 .91917 .54962 .91087 .51453 Metetra
.648 .492 .658 r
.91087 .51453 .91917 .54962 .93242 .54647 .92331 .50522 Metetra
.633 .471 .646 r
.92331 .50522 .93242 .54647 .94564 .54261 .93586 .49669 Metetra
.619 .455 .639 r
.93586 .49669 .94564 .54261 .95889 .53851 .94862 .48967 Metetra
.605 .443 .635 r
.94862 .48967 .95889 .53851 .97222 .53455 .96169 .48467 Metetra
.664 .741 .908 r
.37353 .5743 .37994 .58027 .39049 .57704 .38411 .57104 Metetra
.664 .741 .908 r
.38411 .57104 .39049 .57704 .40109 .5738 .39473 .56778 Metetra
.664 .741 .908 r
.39473 .56778 .40109 .5738 .41173 .57054 .4054 .5645 Metetra
.664 .741 .908 r
.4054 .5645 .41173 .57054 .42241 .56728 .41611 .56121 Metetra
.664 .741 .908 r
.41611 .56121 .42241 .56728 .43314 .564 .42686 .55791 Metetra
.664 .741 .908 r
.42686 .55791 .43314 .564 .4439 .5607 .43765 .55459 Metetra
.664 .741 .908 r
.43765 .55459 .4439 .5607 .45471 .5574 .44849 .55126 Metetra
.664 .741 .908 r
.44849 .55126 .45471 .5574 .46557 .55408 .45937 .54792 Metetra
.664 .741 .908 r
.45937 .54792 .46557 .55408 .47646 .55075 .4703 .54456 Metetra
.664 .741 .908 r
.4703 .54456 .47646 .55075 .4874 .5474 .48126 .54119 Metetra
.664 .741 .908 r
.48126 .54119 .4874 .5474 .49839 .54404 .49228 .53781 Metetra
.664 .741 .908 r
.49228 .53781 .49839 .54404 .50942 .54067 .50334 .53441 Metetra
.663 .741 .908 r
.50334 .53441 .50942 .54067 .52049 .53729 .51444 .531 Metetra
.663 .741 .908 r
.51444 .531 .52049 .53729 .53161 .53389 .52558 .52758 Metetra
.663 .741 .908 r
.52558 .52758 .53161 .53389 .54277 .53048 .53678 .52415 Metetra
.663 .742 .908 r
.53678 .52415 .54277 .53048 .55398 .52705 .54802 .52072 Metetra
.662 .742 .909 r
.54802 .52072 .55398 .52705 .56524 .52362 .5593 .51728 Metetra
.661 .742 .91 r
.5593 .51728 .56524 .52362 .57654 .52018 .57063 .51386 Metetra
.66 .743 .912 r
.57063 .51386 .57654 .52018 .58788 .51675 .58201 .51048 Metetra
.657 .745 .915 r
.58201 .51048 .58788 .51675 .59928 .51333 .59344 .50717 Metetra
.652 .748 .92 r
.59344 .50717 .59928 .51333 .61072 .50994 .60492 .50397 Metetra
.643 .752 .928 r
.60492 .50397 .61072 .50994 .62221 .50663 .61646 .50096 Metetra
.629 .759 .941 r
.61646 .50096 .62221 .50663 .63376 .50343 .62805 .49824 Metetra
.605 .77 .959 r
.62805 .49824 .63376 .50343 .64536 .50042 .63972 .49593 Metetra
.559 .782 .982 r
.63972 .49593 .64536 .50042 .65703 .49769 .65146 .4942 Metetra
.466 .785 .999 r
.65146 .4942 .65703 .49769 .66877 .49538 .6633 .49323 Metetra
.268 .731 .949 r
.6633 .49323 .66877 .49538 .6806 .49365 .67525 .49321 Metetra
.072 0 0 r
.67525 .49321 .6806 .49365 .69252 .49267 .68734 .49433 Metetra
.38 0 0 r
.68734 .49433 .69252 .49267 .70457 .49265 .69957 .49674 Metetra
.535 .025 0 r
.69957 .49674 .70457 .49265 .71676 .49377 .71198 .5005 Metetra
.599 .149 .155 r
.71198 .5005 .71676 .49377 .72912 .49618 .72457 .50558 Metetra
.625 .216 .248 r
.72457 .50558 .72912 .49618 .74166 .49995 .73735 .51178 Metetra
.633 .25 .301 r
.73735 .51178 .74166 .49995 .75439 .50504 .75031 .51873 Metetra
.632 .264 .328 r
.75031 .51873 .75439 .50504 .76733 .51125 .76342 .5259 Metetra
.624 .262 .337 r
.76342 .5259 .76733 .51125 .78046 .51823 .77663 .53261 Metetra
.607 .243 .326 r
.77663 .53261 .78046 .51823 .79374 .52545 .78988 .53811 Metetra
.575 .196 .287 r
.78988 .53811 .79374 .52545 .80713 .53228 .8031 .54169 Metetra
.503 .087 .182 r
.8031 .54169 .80713 .53228 .82055 .53799 .81621 .54271 Metetra
.262 0 0 r
.81621 .54271 .82055 .53799 .83394 .54189 .82914 .54075 Metetra
.577 .927 .951 r
.82914 .54075 .83394 .54189 .84721 .54341 .84185 .53568 Metetra
.758 .761 .855 r
.84185 .53568 .84721 .54341 .86031 .54222 .85433 .5277 Metetra
.736 .639 .751 r
.85433 .5277 .86031 .54222 .87321 .5383 .86658 .51728 Metetra
.714 .579 .702 r
.86658 .51728 .87321 .5383 .88591 .53195 .87865 .50516 Metetra
.695 .543 .676 r
.87865 .50516 .88591 .53195 .89844 .52375 .89062 .49221 Metetra
.679 .519 .662 r
.89062 .49221 .89844 .52375 .91087 .51453 .90259 .47935 Metetra
.664 .501 .654 r
.90259 .47935 .91087 .51453 .92331 .50522 .91466 .46746 Metetra
.648 .486 .65 r
.91466 .46746 .92331 .50522 .93586 .49669 .92694 .45726 Metetra
.631 .472 .649 r
.92694 .45726 .93586 .49669 .94862 .48967 .9395 .44932 Metetra
.613 .459 .649 r
.9395 .44932 .94862 .48967 .96169 .48467 .95244 .44398 Metetra
.664 .741 .908 r
.36707 .56828 .37353 .5743 .38411 .57104 .37768 .56501 Metetra
.664 .741 .908 r
.37768 .56501 .38411 .57104 .39473 .56778 .38833 .56172 Metetra
.664 .741 .908 r
.38833 .56172 .39473 .56778 .4054 .5645 .39902 .55842 Metetra
.664 .741 .908 r
.39902 .55842 .4054 .5645 .41611 .56121 .40975 .5551 Metetra
.664 .741 .908 r
.40975 .5551 .41611 .56121 .42686 .55791 .42053 .55177 Metetra
.664 .741 .908 r
.42053 .55177 .42686 .55791 .43765 .55459 .43135 .54843 Metetra
.664 .741 .908 r
.43135 .54843 .43765 .55459 .44849 .55126 .44222 .54508 Metetra
.664 .741 .908 r
.44222 .54508 .44849 .55126 .45937 .54792 .45313 .54171 Metetra
.664 .741 .908 r
.45313 .54171 .45937 .54792 .4703 .54456 .46408 .53833 Metetra
.664 .741 .908 r
.46408 .53833 .4703 .54456 .48126 .54119 .47508 .53493 Metetra
.663 .741 .908 r
.47508 .53493 .48126 .54119 .49228 .53781 .48612 .53153 Metetra
.663 .741 .908 r
.48612 .53153 .49228 .53781 .50334 .53441 .49721 .52811 Metetra
.663 .741 .908 r
.49721 .52811 .50334 .53441 .51444 .531 .50834 .52468 Metetra
.663 .742 .908 r
.50834 .52468 .51444 .531 .52558 .52758 .51952 .52125 Metetra
.662 .742 .909 r
.51952 .52125 .52558 .52758 .53678 .52415 .53074 .51782 Metetra
.661 .742 .91 r
.53074 .51782 .53678 .52415 .54802 .52072 .54201 .5144 Metetra
.66 .743 .912 r
.54201 .5144 .54802 .52072 .5593 .51728 .55332 .51102 Metetra
.657 .745 .915 r
.55332 .51102 .5593 .51728 .57063 .51386 .56469 .50771 Metetra
.652 .748 .92 r
.56469 .50771 .57063 .51386 .58201 .51048 .5761 .50451 Metetra
.643 .752 .928 r
.5761 .50451 .58201 .51048 .59344 .50717 .58757 .5015 Metetra
.629 .759 .941 r
.58757 .5015 .59344 .50717 .60492 .50397 .5991 .49879 Metetra
.605 .77 .959 r
.5991 .49879 .60492 .50397 .61646 .50096 .61069 .49648 Metetra
.559 .782 .982 r
.61069 .49648 .61646 .50096 .62805 .49824 .62235 .49475 Metetra
.465 .785 .999 r
.62235 .49475 .62805 .49824 .63972 .49593 .6341 .49378 Metetra
.265 .73 .948 r
.6341 .49378 .63972 .49593 .65146 .4942 .64596 .49376 Metetra
.075 0 0 r
.64596 .49376 .65146 .4942 .6633 .49323 .65793 .49488 Metetra
.383 0 0 r
.65793 .49488 .6633 .49323 .67525 .49321 .67005 .49729 Metetra
.536 .027 0 r
.67005 .49729 .67525 .49321 .68734 .49433 .68232 .50106 Metetra
.6 .151 .157 r
.68232 .50106 .68734 .49433 .69957 .49674 .69477 .50614 Metetra
.625 .217 .249 r
.69477 .50614 .69957 .49674 .71198 .5005 .7074 .51234 Metetra
.633 .251 .301 r
.7074 .51234 .71198 .5005 .72457 .50558 .72019 .51929 Metetra
.632 .264 .328 r
.72019 .51929 .72457 .50558 .73735 .51178 .73313 .52646 Metetra
.623 .262 .337 r
.73313 .52646 .73735 .51178 .75031 .51873 .74618 .53317 Metetra
.606 .242 .326 r
.74618 .53317 .75031 .51873 .76342 .5259 .75927 .53866 Metetra
.574 .196 .287 r
.75927 .53866 .76342 .5259 .77663 .53261 .77235 .54219 Metetra
.502 .087 .185 r
.77235 .54219 .77663 .53261 .78988 .53811 .78534 .54314 Metetra
.267 0 0 r
.78534 .54314 .78988 .53811 .8031 .54169 .79817 .54106 Metetra
.558 .927 .928 r
.79817 .54106 .8031 .54169 .81621 .54271 .81081 .5358 Metetra
.771 .786 .865 r
.81081 .5358 .81621 .54271 .82914 .54075 .82322 .52751 Metetra
.751 .66 .76 r
.82322 .52751 .82914 .54075 .84185 .53568 .8354 .5166 Metetra
.731 .599 .71 r
.8354 .5166 .84185 .53568 .85433 .5277 .8474 .50372 Metetra
.715 .565 .684 r
.8474 .50372 .85433 .5277 .86658 .51728 .85927 .48966 Metetra
.703 .545 .67 r
.85927 .48966 .86658 .51728 .87865 .50516 .87107 .47521 Metetra
.692 .531 .664 r
.87107 .47521 .87865 .50516 .89062 .49221 .88289 .46114 Metetra
.682 .521 .662 r
.88289 .46114 .89062 .49221 .90259 .47935 .8948 .44811 Metetra
.671 .514 .664 r
.8948 .44811 .90259 .47935 .91466 .46746 .90688 .43661 Metetra
.658 .507 .668 r
.90688 .43661 .91466 .46746 .92694 .45726 .91918 .42703 Metetra
.643 .499 .673 r
.91918 .42703 .92694 .45726 .9395 .44932 .93176 .41958 Metetra
.625 .49 .678 r
.93176 .41958 .9395 .44932 .95244 .44398 .94467 .41442 Metetra
.664 .741 .908 r
.36056 .56223 .36707 .56828 .37768 .56501 .3712 .55893 Metetra
.664 .741 .908 r
.3712 .55893 .37768 .56501 .38833 .56172 .38187 .55561 Metetra
.664 .741 .908 r
.38187 .55561 .38833 .56172 .39902 .55842 .39259 .55229 Metetra
.664 .741 .908 r
.39259 .55229 .39902 .55842 .40975 .5551 .40336 .54895 Metetra
.664 .741 .908 r
.40336 .54895 .40975 .5551 .42053 .55177 .41416 .5456 Metetra
.664 .741 .908 r
.41416 .5456 .42053 .55177 .43135 .54843 .42501 .54223 Metetra
.664 .741 .908 r
.42501 .54223 .43135 .54843 .44222 .54508 .4359 .53885 Metetra
.664 .741 .908 r
.4359 .53885 .44222 .54508 .45313 .54171 .44684 .53546 Metetra
.663 .741 .908 r
.44684 .53546 .45313 .54171 .46408 .53833 .45782 .53205 Metetra
.663 .741 .908 r
.45782 .53205 .46408 .53833 .47508 .53493 .46885 .52864 Metetra
.663 .741 .908 r
.46885 .52864 .47508 .53493 .48612 .53153 .47992 .52521 Metetra
.663 .742 .908 r
.47992 .52521 .48612 .53153 .49721 .52811 .49103 .52178 Metetra
.662 .742 .909 r
.49103 .52178 .49721 .52811 .50834 .52468 .50219 .51835 Metetra
.661 .742 .91 r
.50219 .51835 .50834 .52468 .51952 .52125 .5134 .51494 Metetra
.66 .743 .912 r
.5134 .51494 .51952 .52125 .53074 .51782 .52465 .51156 Metetra
.657 .745 .915 r
.52465 .51156 .53074 .51782 .54201 .5144 .53595 .50825 Metetra
.652 .748 .92 r
.53595 .50825 .54201 .5144 .55332 .51102 .5473 .50505 Metetra
.643 .752 .928 r
.5473 .50505 .55332 .51102 .56469 .50771 .5587 .50205 Metetra
.629 .759 .941 r
.5587 .50205 .56469 .50771 .5761 .50451 .57016 .49933 Metetra
.605 .77 .959 r
.57016 .49933 .5761 .50451 .58757 .5015 .58167 .49703 Metetra
.558 .782 .982 r
.58167 .49703 .58757 .5015 .5991 .49879 .59326 .4953 Metetra
.463 .785 .999 r
.59326 .4953 .5991 .49879 .61069 .49648 .60492 .49433 Metetra
.263 .729 .946 r
.60492 .49433 .61069 .49648 .62235 .49475 .61668 .49432 Metetra
.079 0 0 r
.61668 .49432 .62235 .49475 .6341 .49378 .62855 .49544 Metetra
.385 0 0 r
.62855 .49544 .6341 .49378 .64596 .49376 .64054 .49785 Metetra
.537 .029 0 r
.64054 .49785 .64596 .49376 .65793 .49488 .65269 .50162 Metetra
.6 .152 .158 r
.65269 .50162 .65793 .49488 .67005 .49729 .66499 .5067 Metetra
.625 .217 .25 r
.66499 .5067 .67005 .49729 .68232 .50106 .67746 .5129 Metetra
.633 .251 .302 r
.67746 .5129 .68232 .50106 .69477 .50614 .69009 .51986 Metetra
.632 .265 .329 r
.69009 .51986 .69477 .50614 .7074 .51234 .70286 .52702 Metetra
.623 .262 .337 r
.70286 .52702 .7074 .51234 .72019 .51929 .71575 .53373 Metetra
.606 .242 .326 r
.71575 .53373 .72019 .51929 .73313 .52646 .72869 .53923 Metetra
.573 .195 .286 r
.72869 .53923 .73313 .52646 .74618 .53317 .74163 .54276 Metetra
.5 .084 .183 r
.74163 .54276 .74618 .53317 .75927 .53866 .7545 .5437 Metetra
.262 0 0 r
.7545 .5437 .75927 .53866 .77235 .54219 .76725 .54161 Metetra
.561 .929 .928 r
.76725 .54161 .77235 .54219 .78534 .54314 .77982 .53634 Metetra
.772 .788 .866 r
.77982 .53634 .78534 .54314 .79817 .54106 .7922 .52801 Metetra
.753 .663 .761 r
.7922 .52801 .79817 .54106 .81081 .5358 .80437 .51704 Metetra
.734 .603 .711 r
.80437 .51704 .81081 .5358 .82322 .52751 .81637 .50406 Metetra
.719 .57 .685 r
.81637 .50406 .82322 .52751 .8354 .5166 .82825 .48981 Metetra
.708 .551 .672 r
.82825 .48981 .8354 .5166 .8474 .50372 .84004 .47506 Metetra
.7 .539 .667 r
.84004 .47506 .8474 .50372 .85927 .48966 .85183 .46051 Metetra
.693 .533 .666 r
.85183 .46051 .85927 .48966 .87107 .47521 .86368 .44673 Metetra
.687 .532 .67 r
.86368 .44673 .87107 .47521 .88289 .46114 .87562 .43413 Metetra
.681 .533 .678 r
.87562 .43413 .88289 .46114 .8948 .44811 .88772 .42298 Metetra
.674 .536 .688 r
.88772 .42298 .8948 .44811 .90688 .43661 .9 .4134 Metetra
.666 .539 .701 r
.9 .4134 .90688 .43661 .91918 .42703 .91248 .40543 Metetra
.654 .541 .714 r
.91248 .40543 .91918 .42703 .93176 .41958 .92519 .39904 Metetra
.639 .539 .725 r
.92519 .39904 .93176 .41958 .94467 .41442 .93814 .39423 Metetra
.664 .741 .908 r
.35401 .55612 .36056 .56223 .3712 .55893 .36467 .5528 Metetra
.664 .741 .908 r
.36467 .5528 .3712 .55893 .38187 .55561 .37537 .54946 Metetra
.664 .741 .908 r
.37537 .54946 .38187 .55561 .39259 .55229 .38612 .54611 Metetra
.664 .741 .908 r
.38612 .54611 .39259 .55229 .40336 .54895 .39691 .54275 Metetra
.664 .741 .908 r
.39691 .54275 .40336 .54895 .41416 .5456 .40774 .53937 Metetra
.664 .741 .908 r
.40774 .53937 .41416 .5456 .42501 .54223 .41862 .53598 Metetra
.663 .741 .908 r
.41862 .53598 .42501 .54223 .4359 .53885 .42954 .53258 Metetra
.663 .741 .908 r
.42954 .53258 .4359 .53885 .44684 .53546 .4405 .52916 Metetra
.663 .741 .908 r
.4405 .52916 .44684 .53546 .45782 .53205 .45151 .52574 Metetra
.663 .742 .908 r
.45151 .52574 .45782 .53205 .46885 .52864 .46257 .52231 Metetra
.662 .742 .909 r
.46257 .52231 .46885 .52864 .47992 .52521 .47366 .51888 Metetra
.661 .742 .91 r
.47366 .51888 .47992 .52521 .49103 .52178 .48481 .51547 Metetra
.66 .743 .912 r
.48481 .51547 .49103 .52178 .50219 .51835 .496 .5121 Metetra
.657 .745 .915 r
.496 .5121 .50219 .51835 .5134 .51494 .50723 .50879 Metetra
.652 .748 .92 r
.50723 .50879 .5134 .51494 .52465 .51156 .51852 .5056 Metetra
.643 .752 .928 r
.51852 .5056 .52465 .51156 .53595 .50825 .52985 .50259 Metetra
.629 .76 .941 r
.52985 .50259 .53595 .50825 .5473 .50505 .54124 .49988 Metetra
.604 .77 .959 r
.54124 .49988 .5473 .50505 .5587 .50205 .55268 .49757 Metetra
.558 .782 .983 r
.55268 .49757 .5587 .50205 .57016 .49933 .56418 .49585 Metetra
.463 .785 .999 r
.56418 .49585 .57016 .49933 .58167 .49703 .57576 .49488 Metetra
.26 .728 .945 r
.57576 .49488 .58167 .49703 .59326 .4953 .58742 .49487 Metetra
.083 0 0 r
.58742 .49487 .59326 .4953 .60492 .49433 .59918 .496 Metetra
.388 0 0 r
.59918 .496 .60492 .49433 .61668 .49432 .61106 .49841 Metetra
.539 .031 0 r
.61106 .49841 .61668 .49432 .62855 .49544 .62307 .50218 Metetra
.601 .153 .16 r
.62307 .50218 .62855 .49544 .64054 .49785 .63523 .50727 Metetra
.625 .218 .251 r
.63523 .50727 .64054 .49785 .65269 .50162 .64754 .51347 Metetra
.634 .251 .302 r
.64754 .51347 .65269 .50162 .66499 .5067 .66001 .52042 Metetra
.632 .265 .329 r
.66001 .52042 .66499 .5067 .67746 .5129 .67262 .52759 Metetra
.623 .262 .337 r
.67262 .52759 .67746 .5129 .69009 .51986 .68534 .5343 Metetra
.606 .242 .325 r
.68534 .5343 .69009 .51986 .70286 .52702 .69812 .53979 Metetra
.573 .194 .285 r
.69812 .53979 .70286 .52702 .71575 .53373 .71092 .54333 Metetra
.499 .082 .18 r
.71092 .54333 .71575 .53373 .72869 .53923 .72368 .54427 Metetra
.256 0 0 r
.72368 .54427 .72869 .53923 .74163 .54276 .73634 .54218 Metetra
.567 .931 .932 r
.73634 .54218 .74163 .54276 .7545 .5437 .74886 .5369 Metetra
.772 .786 .865 r
.74886 .5369 .7545 .5437 .76725 .54161 .7612 .52857 Metetra
.753 .663 .761 r
.7612 .52857 .76725 .54161 .77982 .53634 .77337 .51761 Metetra
.734 .603 .711 r
.77337 .51761 .77982 .53634 .7922 .52801 .78539 .50462 Metetra
.719 .57 .686 r
.78539 .50462 .7922 .52801 .80437 .51704 .79728 .49036 Metetra
.709 .551 .673 r
.79728 .49036 .80437 .51704 .81637 .50406 .80911 .47558 Metetra
.701 .541 .667 r
.80911 .47558 .81637 .50406 .82825 .48981 .82092 .46097 Metetra
.695 .535 .667 r
.82092 .46097 .82825 .48981 .84004 .47506 .83277 .44709 Metetra
.69 .535 .672 r
.83277 .44709 .84004 .47506 .85183 .46051 .84471 .43431 Metetra
.686 .539 .68 r
.84471 .43431 .85183 .46051 .86368 .44673 .85677 .42286 Metetra
.683 .546 .693 r
.85677 .42286 .86368 .44673 .87562 .43413 .86898 .4128 Metetra
.68 .557 .709 r
.86898 .4128 .87562 .43413 .88772 .42298 .88134 .40409 Metetra
.677 .571 .728 r
.88134 .40409 .88772 .42298 .9 .4134 .89386 .39661 Metetra
.672 .585 .75 r
.89386 .39661 .9 .4134 .91248 .40543 .90655 .39024 Metetra
.665 .597 .77 r
.90655 .39024 .91248 .40543 .92519 .39904 .91939 .38484 Metetra
.654 .603 .785 r
.91939 .38484 .92519 .39904 .93814 .39423 .9324 .38035 Metetra
.664 .741 .908 r
.34741 .54998 .35401 .55612 .36467 .5528 .3581 .54663 Metetra
.664 .741 .908 r
.3581 .54663 .36467 .5528 .37537 .54946 .36882 .54327 Metetra
.664 .741 .908 r
.36882 .54327 .37537 .54946 .38612 .54611 .3796 .53989 Metetra
.664 .741 .908 r
.3796 .53989 .38612 .54611 .39691 .54275 .39041 .5365 Metetra
.663 .741 .908 r
.39041 .5365 .39691 .54275 .40774 .53937 .40127 .5331 Metetra
.663 .741 .908 r
.40127 .5331 .40774 .53937 .41862 .53598 .41218 .52969 Metetra
.663 .741 .908 r
.41218 .52969 .41862 .53598 .42954 .53258 .42313 .52627 Metetra
.663 .742 .908 r
.42313 .52627 .42954 .53258 .4405 .52916 .43412 .52284 Metetra
.662 .742 .909 r
.43412 .52284 .4405 .52916 .45151 .52574 .44515 .51942 Metetra
.661 .742 .91 r
.44515 .51942 .45151 .52574 .46257 .52231 .45624 .51601 Metetra
.66 .743 .912 r
.45624 .51601 .46257 .52231 .47366 .51888 .46736 .51263 Metetra
.657 .745 .915 r
.46736 .51263 .47366 .51888 .48481 .51547 .47854 .50933 Metetra
.652 .748 .92 r
.47854 .50933 .48481 .51547 .496 .5121 .48975 .50614 Metetra
.643 .752 .928 r
.48975 .50614 .496 .5121 .50723 .50879 .50102 .50314 Metetra
.629 .76 .941 r
.50102 .50314 .50723 .50879 .51852 .5056 .51233 .50042 Metetra
.604 .77 .959 r
.51233 .50042 .51852 .5056 .52985 .50259 .5237 .49812 Metetra
.557 .782 .983 r
.5237 .49812 .52985 .50259 .54124 .49988 .53512 .4964 Metetra
.462 .785 .999 r
.53512 .4964 .54124 .49988 .55268 .49757 .54661 .49543 Metetra
.258 .727 .944 r
.54661 .49543 .55268 .49757 .56418 .49585 .55818 .49542 Metetra
.086 0 0 r
.55818 .49542 .56418 .49585 .57576 .49488 .56983 .49655 Metetra
.39 0 0 r
.56983 .49655 .57576 .49488 .58742 .49487 .58159 .49897 Metetra
.54 .033 0 r
.58159 .49897 .58742 .49487 .59918 .496 .59347 .50274 Metetra
.601 .154 .161 r
.59347 .50274 .59918 .496 .61106 .49841 .60548 .50783 Metetra
.626 .219 .252 r
.60548 .50783 .61106 .49841 .62307 .50218 .61764 .51403 Metetra
.634 .252 .303 r
.61764 .51403 .62307 .50218 .63523 .50727 .62995 .52098 Metetra
.632 .265 .329 r
.62995 .52098 .63523 .50727 .64754 .51347 .64239 .52815 Metetra
.623 .262 .336 r
.64239 .52815 .64754 .51347 .66001 .52042 .65494 .53486 Metetra
.606 .241 .325 r
.65494 .53486 .66001 .52042 .67262 .52759 .66758 .54035 Metetra
.572 .193 .284 r
.66758 .54035 .67262 .52759 .68534 .5343 .68024 .54389 Metetra
.498 .08 .178 r
.68024 .54389 .68534 .5343 .69812 .53979 .69289 .54483 Metetra
.251 0 0 r
.69289 .54483 .69812 .53979 .71092 .54333 .70546 .54274 Metetra
.573 .932 .935 r
.70546 .54274 .71092 .54333 .72368 .54427 .71792 .53747 Metetra
.772 .785 .864 r
.71792 .53747 .72368 .54427 .73634 .54218 .73023 .52913 Metetra
.753 .662 .761 r
.73023 .52913 .73634 .54218 .74886 .5369 .7424 .51817 Metetra
.734 .603 .711 r
.7424 .51817 .74886 .5369 .7612 .52857 .75442 .50519 Metetra
.719 .57 .686 r
.75442 .50519 .7612 .52857 .77337 .51761 .76634 .49094 Metetra
.709 .551 .673 r
.76634 .49094 .77337 .51761 .78539 .50462 .7782 .47616 Metetra
.701 .541 .667 r
.7782 .47616 .78539 .50462 .79728 .49036 .79004 .46156 Metetra
.695 .536 .667 r
.79004 .46156 .79728 .49036 .80911 .47558 .80191 .44767 Metetra
.69 .535 .672 r
.80191 .44767 .80911 .47558 .82092 .46097 .81386 .43488 Metetra
.686 .539 .68 r
.81386 .43488 .82092 .46097 .83277 .44709 .82592 .4234 Metetra
.684 .548 .693 r
.82592 .4234 .83277 .44709 .84471 .43431 .8381 .41328 Metetra
.682 .56 .71 r
.8381 .41328 .84471 .43431 .85677 .42286 .85043 .40446 Metetra
.681 .577 .732 r
.85043 .40446 .85677 .42286 .86898 .4128 .86289 .39681 Metetra
.68 .597 .756 r
.86289 .39681 .86898 .4128 .88134 .40409 .87549 .39013 Metetra
.678 .618 .782 r
.87549 .39013 .88134 .40409 .89386 .39661 .88822 .38426 Metetra
.675 .639 .807 r
.88822 .38426 .89386 .39661 .90655 .39024 .90107 .37902 Metetra
.67 .656 .828 r
.90107 .37902 .90655 .39024 .91939 .38484 .91402 .37429 Metetra
.663 .666 .843 r
.91402 .37429 .91939 .38484 .9324 .38035 .92709 .36999 Metetra
.664 .741 .908 r
.34076 .54379 .34741 .54998 .3581 .54663 .35147 .54041 Metetra
.664 .741 .908 r
.35147 .54041 .3581 .54663 .36882 .54327 .36223 .53703 Metetra
.663 .741 .908 r
.36223 .53703 .36882 .54327 .3796 .53989 .37303 .53363 Metetra
.663 .741 .908 r
.37303 .53363 .3796 .53989 .39041 .5365 .38387 .53022 Metetra
.663 .741 .908 r
.38387 .53022 .39041 .5365 .40127 .5331 .39476 .5268 Metetra
.663 .742 .908 r
.39476 .5268 .40127 .5331 .41218 .52969 .40569 .52337 Metetra
.662 .742 .909 r
.40569 .52337 .41218 .52969 .42313 .52627 .41666 .51995 Metetra
.661 .742 .91 r
.41666 .51995 .42313 .52627 .43412 .52284 .42768 .51654 Metetra
.66 .743 .912 r
.42768 .51654 .43412 .52284 .44515 .51942 .43875 .51317 Metetra
.657 .745 .915 r
.43875 .51317 .44515 .51942 .45624 .51601 .44985 .50987 Metetra
.652 .748 .92 r
.44985 .50987 .45624 .51601 .46736 .51263 .46101 .50668 Metetra
.643 .752 .928 r
.46101 .50668 .46736 .51263 .47854 .50933 .47221 .50368 Metetra
.629 .76 .941 r
.47221 .50368 .47854 .50933 .48975 .50614 .48345 .50097 Metetra
.604 .77 .959 r
.48345 .50097 .48975 .50614 .50102 .50314 .49474 .49867 Metetra
.557 .782 .983 r
.49474 .49867 .50102 .50314 .51233 .50042 .50609 .49695 Metetra
.461 .785 .999 r
.50609 .49695 .51233 .50042 .5237 .49812 .51749 .49598 Metetra
.255 .726 .943 r
.51749 .49598 .5237 .49812 .53512 .4964 .52896 .49597 Metetra
.09 0 0 r
.52896 .49597 .53512 .4964 .54661 .49543 .5405 .4971 Metetra
.393 0 0 r
.5405 .4971 .54661 .49543 .55818 .49542 .55214 .49952 Metetra
.541 .035 .003 r
.55214 .49952 .55818 .49542 .56983 .49655 .56389 .5033 Metetra
.602 .156 .163 r
.56389 .5033 .56983 .49655 .58159 .49897 .57576 .50839 Metetra
.626 .219 .253 r
.57576 .50839 .58159 .49897 .59347 .50274 .58776 .51459 Metetra
.634 .252 .303 r
.58776 .51459 .59347 .50274 .60548 .50783 .59991 .52155 Metetra
.632 .265 .329 r
.59991 .52155 .60548 .50783 .61764 .51403 .61218 .52872 Metetra
.623 .262 .336 r
.61218 .52872 .61764 .51403 .62995 .52098 .62457 .53542 Metetra
.605 .241 .324 r
.62457 .53542 .62995 .52098 .64239 .52815 .63705 .54092 Metetra
.572 .192 .283 r
.63705 .54092 .64239 .52815 .65494 .53486 .64958 .54445 Metetra
.497 .078 .175 r
.64958 .54445 .65494 .53486 .66758 .54035 .66211 .5454 Metetra
.246 0 0 r
.66211 .5454 .66758 .54035 .68024 .54389 .6746 .54331 Metetra
.578 .933 .938 r
.6746 .54331 .68024 .54389 .69289 .54483 .687 .53803 Metetra
.771 .784 .863 r
.687 .53803 .69289 .54483 .70546 .54274 .69928 .52971 Metetra
.753 .662 .761 r
.69928 .52971 .70546 .54274 .71792 .53747 .71144 .51874 Metetra
.734 .603 .711 r
.71144 .51874 .71792 .53747 .73023 .52913 .72348 .50576 Metetra
.719 .57 .686 r
.72348 .50576 .73023 .52913 .7424 .51817 .73543 .49151 Metetra
.709 .551 .673 r
.73543 .49151 .7424 .51817 .75442 .50519 .74731 .47675 Metetra
.701 .541 .667 r
.74731 .47675 .75442 .50519 .76634 .49094 .75918 .46215 Metetra
.695 .536 .667 r
.75918 .46215 .76634 .49094 .7782 .47616 .77108 .44827 Metetra
.69 .535 .672 r
.77108 .44827 .7782 .47616 .79004 .46156 .78304 .43548 Metetra
.687 .539 .68 r
.78304 .43548 .79004 .46156 .80191 .44767 .79509 .424 Metetra
.684 .548 .693 r
.79509 .424 .80191 .44767 .81386 .43488 .80726 .41388 Metetra
.682 .56 .711 r
.80726 .41388 .81386 .43488 .82592 .4234 .81956 .40506 Metetra
.681 .577 .732 r
.81956 .40506 .82592 .4234 .8381 .41328 .83199 .39739 Metetra
.681 .598 .757 r
.83199 .39739 .8381 .41328 .85043 .40446 .84454 .39068 Metetra
.68 .621 .783 r
.84454 .39068 .85043 .40446 .86289 .39681 .8572 .38475 Metetra
.678 .645 .81 r
.8572 .38475 .86289 .39681 .87549 .39013 .86998 .37941 Metetra
.675 .668 .835 r
.86998 .37941 .87549 .39013 .88822 .38426 .88285 .37449 Metetra
.672 .687 .856 r
.88285 .37449 .88822 .38426 .90107 .37902 .8958 .36989 Metetra
.669 .701 .871 r
.8958 .36989 .90107 .37902 .91402 .37429 .90884 .3655 Metetra
.665 .709 .88 r
.90884 .3655 .91402 .37429 .92709 .36999 .92196 .36129 Metetra
.664 .741 .908 r
.33406 .53755 .34076 .54379 .35147 .54041 .3448 .53415 Metetra
.663 .741 .908 r
.3448 .53415 .35147 .54041 .36223 .53703 .35558 .53074 Metetra
.663 .741 .908 r
.35558 .53074 .36223 .53703 .37303 .53363 .36641 .52733 Metetra
.663 .742 .908 r
.36641 .52733 .37303 .53363 .38387 .53022 .37728 .5239 Metetra
.662 .742 .909 r
.37728 .5239 .38387 .53022 .39476 .5268 .38819 .52048 Metetra
.661 .742 .91 r
.38819 .52048 .39476 .5268 .40569 .52337 .39915 .51708 Metetra
.66 .743 .912 r
.39915 .51708 .40569 .52337 .41666 .51995 .41015 .51371 Metetra
.657 .745 .915 r
.41015 .51371 .41666 .51995 .42768 .51654 .42119 .5104 Metetra
.652 .748 .92 r
.42119 .5104 .42768 .51654 .43875 .51317 .43228 .50722 Metetra
.643 .752 .928 r
.43228 .50722 .43875 .51317 .44985 .50987 .44341 .50422 Metetra
.629 .76 .941 r
.44341 .50422 .44985 .50987 .46101 .50668 .45458 .50151 Metetra
.604 .77 .96 r
.45458 .50151 .46101 .50668 .47221 .50368 .4658 .49922 Metetra
.556 .783 .983 r
.4658 .49922 .47221 .50368 .48345 .50097 .47707 .49749 Metetra
.459 .785 .999 r
.47707 .49749 .48345 .50097 .49474 .49867 .48838 .49653 Metetra
.253 .725 .942 r
.48838 .49653 .49474 .49867 .50609 .49695 .49975 .49652 Metetra
.093 0 0 r
.49975 .49652 .50609 .49695 .51749 .49598 .5112 .49766 Metetra
.395 0 0 r
.5112 .49766 .51749 .49598 .52896 .49597 .52272 .50008 Metetra
.542 .037 .005 r
.52272 .50008 .52896 .49597 .5405 .4971 .53433 .50386 Metetra
.603 .157 .165 r
.53433 .50386 .5405 .4971 .55214 .49952 .54606 .50895 Metetra
.626 .22 .254 r
.54606 .50895 .55214 .49952 .56389 .5033 .55791 .51516 Metetra
.634 .253 .304 r
.55791 .51516 .56389 .5033 .57576 .50839 .56988 .52212 Metetra
.632 .265 .329 r
.56988 .52212 .57576 .50839 .58776 .51459 .58199 .52928 Metetra
.623 .262 .336 r
.58199 .52928 .58776 .51459 .59991 .52155 .59422 .53599 Metetra
.605 .24 .324 r
.59422 .53599 .59991 .52155 .61218 .52872 .60655 .54148 Metetra
.571 .191 .282 r
.60655 .54148 .61218 .52872 .62457 .53542 .61894 .54502 Metetra
.495 .075 .172 r
.61894 .54502 .62457 .53542 .63705 .54092 .63136 .54596 Metetra
.241 0 0 r
.63136 .54596 .63705 .54092 .64958 .54445 .64376 .54388 Metetra
.584 .934 .941 r
.64376 .54388 .64958 .54445 .66211 .5454 .6561 .5386 Metetra
.771 .783 .862 r
.6561 .5386 .66211 .5454 .6746 .54331 .66835 .53028 Metetra
.753 .662 .76 r
.66835 .53028 .6746 .54331 .687 .53803 .68051 .51931 Metetra
.733 .603 .711 r
.68051 .51931 .687 .53803 .69928 .52971 .69256 .50634 Metetra
.719 .57 .686 r
.69256 .50634 .69928 .52971 .71144 .51874 .70453 .49209 Metetra
.709 .551 .673 r
.70453 .49209 .71144 .51874 .72348 .50576 .71645 .47732 Metetra
.701 .541 .667 r
.71645 .47732 .72348 .50576 .73543 .49151 .72834 .46274 Metetra
.695 .536 .667 r
.72834 .46274 .73543 .49151 .74731 .47675 .74026 .44887 Metetra
.69 .535 .672 r
.74026 .44887 .74731 .47675 .75918 .46215 .75224 .43609 Metetra
.687 .539 .68 r
.75224 .43609 .75918 .46215 .77108 .44827 .76429 .42461 Metetra
.684 .548 .693 r
.76429 .42461 .77108 .44827 .78304 .43548 .77645 .41449 Metetra
.682 .56 .711 r
.77645 .41449 .78304 .43548 .79509 .424 .78872 .40567 Metetra
.681 .577 .732 r
.78872 .40567 .79509 .424 .80726 .41388 .80111 .398 Metetra
.681 .598 .757 r
.80111 .398 .80726 .41388 .81956 .40506 .81361 .3913 Metetra
.68 .622 .784 r
.81361 .3913 .81956 .40506 .83199 .39739 .82622 .38537 Metetra
.678 .646 .811 r
.82622 .38537 .83199 .39739 .84454 .39068 .83893 .38002 Metetra
.676 .669 .836 r
.83893 .38002 .84454 .39068 .8572 .38475 .85174 .37509 Metetra
.673 .69 .857 r
.85174 .37509 .8572 .38475 .86998 .37941 .86462 .37045 Metetra
.671 .706 .874 r
.86462 .37045 .86998 .37941 .88285 .37449 .87758 .36601 Metetra
.668 .718 .886 r
.87758 .36601 .88285 .37449 .8958 .36989 .89062 .36169 Metetra
.666 .725 .894 r
.89062 .36169 .8958 .36989 .90884 .3655 .90372 .35744 Metetra
.664 .729 .898 r
.90372 .35744 .90884 .3655 .92196 .36129 .91689 .35325 Metetra
.663 .742 .908 r
.32731 .53128 .33406 .53755 .3448 .53415 .33807 .52786 Metetra
.663 .742 .909 r
.33807 .52786 .3448 .53415 .35558 .53074 .34888 .52444 Metetra
.662 .742 .909 r
.34888 .52444 .35558 .53074 .36641 .52733 .35973 .52102 Metetra
.661 .742 .91 r
.35973 .52102 .36641 .52733 .37728 .5239 .37063 .51761 Metetra
.66 .743 .912 r
.37063 .51761 .37728 .5239 .38819 .52048 .38157 .51424 Metetra
.657 .745 .915 r
.38157 .51424 .38819 .52048 .39915 .51708 .39255 .51094 Metetra
.652 .748 .92 r
.39255 .51094 .39915 .51708 .41015 .51371 .40357 .50776 Metetra
.643 .753 .928 r
.40357 .50776 .41015 .51371 .42119 .5104 .41463 .50477 Metetra
.629 .76 .941 r
.41463 .50477 .42119 .5104 .43228 .50722 .42574 .50206 Metetra
.604 .77 .96 r
.42574 .50206 .43228 .50722 .44341 .50422 .43688 .49976 Metetra
.556 .783 .983 r
.43688 .49976 .44341 .50422 .45458 .50151 .44806 .49804 Metetra
.458 .785 .999 r
.44806 .49804 .45458 .50151 .4658 .49922 .45929 .49708 Metetra
.25 .724 .94 r
.45929 .49708 .4658 .49922 .47707 .49749 .47057 .49708 Metetra
.097 0 0 r
.47057 .49708 .47707 .49749 .48838 .49653 .48191 .49821 Metetra
.398 0 0 r
.48191 .49821 .48838 .49653 .49975 .49652 .49331 .50064 Metetra
.544 .039 .008 r
.49331 .50064 .49975 .49652 .5112 .49766 .50479 .50442 Metetra
.603 .158 .166 r
.50479 .50442 .5112 .49766 .52272 .50008 .51637 .50952 Metetra
.627 .221 .255 r
.51637 .50952 .52272 .50008 .53433 .50386 .52807 .51573 Metetra
.634 .253 .304 r
.52807 .51573 .53433 .50386 .54606 .50895 .53988 .52269 Metetra
.632 .265 .329 r
.53988 .52269 .54606 .50895 .55791 .51516 .55182 .52985 Metetra
.623 .261 .336 r
.55182 .52985 .55791 .51516 .56988 .52212 .56389 .53656 Metetra
.605 .24 .323 r
.56389 .53656 .56988 .52212 .58199 .52928 .57606 .54205 Metetra
.571 .19 .281 r
.57606 .54205 .58199 .52928 .59422 .53599 .58832 .54558 Metetra
.494 .073 .17 r
.58832 .54558 .59422 .53599 .60655 .54148 .60062 .54653 Metetra
.235 0 0 r
.60062 .54653 .60655 .54148 .61894 .54502 .61294 .54444 Metetra
.589 .935 .943 r
.61294 .54444 .61894 .54502 .63136 .54596 .62522 .53917 Metetra
.771 .782 .862 r
.62522 .53917 .63136 .54596 .64376 .54388 .63745 .53085 Metetra
.753 .661 .76 r
.63745 .53085 .64376 .54388 .6561 .5386 .64959 .51989 Metetra
.733 .603 .711 r
.64959 .51989 .6561 .5386 .66835 .53028 .66166 .50691 Metetra
.719 .57 .686 r
.66166 .50691 .66835 .53028 .68051 .51931 .67365 .49267 Metetra
.709 .551 .673 r
.67365 .49267 .68051 .51931 .69256 .50634 .6856 .47792 Metetra
.701 .541 .667 r
.6856 .47792 .69256 .50634 .70453 .49209 .69753 .46333 Metetra
.695 .536 .667 r
.69753 .46333 .70453 .49209 .71645 .47732 .70947 .44946 Metetra
.69 .535 .672 r
.70947 .44946 .71645 .47732 .72834 .46274 .72145 .43669 Metetra
.686 .539 .68 r
.72145 .43669 .72834 .46274 .74026 .44887 .73351 .42522 Metetra
.684 .548 .693 r
.73351 .42522 .74026 .44887 .75224 .43609 .74565 .4151 Metetra
.682 .56 .711 r
.74565 .4151 .75224 .43609 .76429 .42461 .7579 .40628 Metetra
.681 .577 .732 r
.7579 .40628 .76429 .42461 .77645 .41449 .77025 .39862 Metetra
.681 .598 .757 r
.77025 .39862 .77645 .41449 .78872 .40567 .78271 .39192 Metetra
.68 .622 .784 r
.78271 .39192 .78872 .40567 .80111 .398 .79526 .38599 Metetra
.678 .646 .811 r
.79526 .38599 .80111 .398 .81361 .3913 .80791 .38064 Metetra
.676 .67 .836 r
.80791 .38064 .81361 .3913 .82622 .38537 .82065 .37571 Metetra
.673 .69 .857 r
.82065 .37571 .82622 .38537 .83893 .38002 .83347 .37108 Metetra
.671 .706 .874 r
.83347 .37108 .83893 .38002 .85174 .37509 .84636 .36663 Metetra
.668 .719 .886 r
.84636 .36663 .85174 .37509 .86462 .37045 .85932 .36231 Metetra
.667 .727 .895 r
.85932 .36231 .86462 .37045 .87758 .36601 .87235 .35805 Metetra
.665 .733 .9 r
.87235 .35805 .87758 .36601 .89062 .36169 .88543 .35382 Metetra
.664 .736 .903 r
.88543 .35382 .89062 .36169 .90372 .35744 .89859 .3496 Metetra
.664 .738 .905 r
.89859 .3496 .90372 .35744 .91689 .35325 .9118 .34539 Metetra
.663 .743 .909 r
.3205 .525 .32731 .53128 .33807 .52786 .33129 .52156 Metetra
.662 .743 .91 r
.33129 .52156 .33807 .52786 .34888 .52444 .34213 .51815 Metetra
.66 .744 .912 r
.34213 .51815 .34888 .52444 .35973 .52102 .353 .51478 Metetra
.657 .745 .915 r
.353 .51478 .35973 .52102 .37063 .51761 .36392 .51148 Metetra
.652 .748 .92 r
.36392 .51148 .37063 .51761 .38157 .51424 .37488 .5083 Metetra
.643 .753 .928 r
.37488 .5083 .38157 .51424 .39255 .51094 .38587 .50531 Metetra
.629 .76 .941 r
.38587 .50531 .39255 .51094 .40357 .50776 .39691 .5026 Metetra
.603 .771 .96 r
.39691 .5026 .40357 .50776 .41463 .50477 .40798 .50031 Metetra
.556 .783 .984 r
.40798 .50031 .41463 .50477 .42574 .50206 .41908 .49859 Metetra
.457 .784 .999 r
.41908 .49859 .42574 .50206 .43688 .49976 .43022 .49763 Metetra
.248 .722 .939 r
.43022 .49763 .43688 .49976 .44806 .49804 .44141 .49763 Metetra
.101 0 0 r
.44141 .49763 .44806 .49804 .45929 .49708 .45263 .49877 Metetra
.4 0 0 r
.45263 .49877 .45929 .49708 .47057 .49708 .46392 .50119 Metetra
.545 .041 .01 r
.46392 .50119 .47057 .49708 .48191 .49821 .47527 .50498 Metetra
.604 .159 .168 r
.47527 .50498 .48191 .49821 .49331 .50064 .48671 .51007 Metetra
.627 .222 .256 r
.48671 .51007 .49331 .50064 .50479 .50442 .49825 .51629 Metetra
.634 .254 .305 r
.49825 .51629 .50479 .50442 .51637 .50952 .5099 .52325 Metetra
.632 .265 .33 r
.5099 .52325 .51637 .50952 .52807 .51573 .52168 .53043 Metetra
.623 .261 .336 r
.52168 .53043 .52807 .51573 .53988 .52269 .53358 .53713 Metetra
.605 .239 .323 r
.53358 .53713 .53988 .52269 .55182 .52985 .5456 .54262 Metetra
.57 .188 .279 r
.5456 .54262 .55182 .52985 .56389 .53656 .55772 .54615 Metetra
.492 .07 .167 r
.55772 .54615 .56389 .53656 .57606 .54205 .56991 .54709 Metetra
.23 0 0 r
.56991 .54709 .57606 .54205 .58832 .54558 .58214 .54501 Metetra
.594 .936 .946 r
.58214 .54501 .58832 .54558 .60062 .54653 .59436 .53974 Metetra
.771 .781 .861 r
.59436 .53974 .60062 .54653 .61294 .54444 .60656 .53142 Metetra
.753 .661 .76 r
.60656 .53142 .61294 .54444 .62522 .53917 .6187 .52046 Metetra
.733 .603 .711 r
.6187 .52046 .62522 .53917 .63745 .53085 .63078 .50749 Metetra
.719 .57 .686 r
.63078 .50749 .63745 .53085 .64959 .51989 .6428 .49326 Metetra
.709 .551 .673 r
.6428 .49326 .64959 .51989 .66166 .50691 .65478 .4785 Metetra
.701 .541 .667 r
.65478 .4785 .66166 .50691 .67365 .49267 .66673 .46392 Metetra
.695 .536 .667 r
.66673 .46392 .67365 .49267 .6856 .47792 .67869 .45006 Metetra
.69 .535 .672 r
.67869 .45006 .6856 .47792 .69753 .46333 .69069 .43729 Metetra
.686 .539 .68 r
.69069 .43729 .69753 .46333 .70947 .44946 .70275 .42582 Metetra
.684 .548 .693 r
.70275 .42582 .70947 .44946 .72145 .43669 .71488 .41571 Metetra
.682 .56 .711 r
.71488 .41571 .72145 .43669 .73351 .42522 .7271 .4069 Metetra
.681 .577 .732 r
.7271 .4069 .73351 .42522 .74565 .4151 .73941 .39923 Metetra
.68 .598 .757 r
.73941 .39923 .74565 .4151 .7579 .40628 .75182 .39254 Metetra
.68 .622 .784 r
.75182 .39254 .7579 .40628 .77025 .39862 .76433 .38661 Metetra
.678 .646 .811 r
.76433 .38661 .77025 .39862 .78271 .39192 .77692 .38126 Metetra
.676 .67 .836 r
.77692 .38126 .78271 .39192 .79526 .38599 .78959 .37634 Metetra
.673 .69 .858 r
.78959 .37634 .79526 .38599 .80791 .38064 .80234 .37171 Metetra
.671 .706 .874 r
.80234 .37171 .80791 .38064 .82065 .37571 .81516 .36727 Metetra
.668 .719 .886 r
.81516 .36727 .82065 .37571 .83347 .37108 .82805 .36294 Metetra
.667 .727 .895 r
.82805 .36294 .83347 .37108 .84636 .36663 .841 .35868 Metetra
.665 .733 .9 r
.841 .35868 .84636 .36663 .85932 .36231 .85401 .35446 Metetra
.665 .736 .903 r
.85401 .35446 .85932 .36231 .87235 .35805 .86709 .35024 Metetra
.664 .739 .905 r
.86709 .35024 .87235 .35805 .88543 .35382 .88023 .34602 Metetra
.664 .74 .907 r
.88023 .34602 .88543 .35382 .89859 .3496 .89342 .3418 Metetra
.664 .74 .907 r
.89342 .3418 .89859 .3496 .9118 .34539 .90668 .33756 Metetra
.662 .747 .913 r
.31364 .51881 .3205 .525 .33129 .52156 .32445 .51539 Metetra
.658 .747 .916 r
.32445 .51539 .33129 .52156 .34213 .51815 .33531 .51206 Metetra
.652 .749 .921 r
.33531 .51206 .34213 .51815 .353 .51478 .3462 .50886 Metetra
.643 .753 .929 r
.3462 .50886 .353 .51478 .36392 .51148 .35713 .50586 Metetra
.629 .76 .941 r
.35713 .50586 .36392 .51148 .37488 .5083 .3681 .50315 Metetra
.603 .771 .96 r
.3681 .50315 .37488 .5083 .38587 .50531 .37909 .50086 Metetra
.555 .783 .984 r
.37909 .50086 .38587 .50531 .39691 .5026 .39012 .49914 Metetra
.456 .784 .999 r
.39012 .49914 .39691 .5026 .40798 .50031 .40117 .49819 Metetra
.245 .721 .938 r
.40117 .49819 .40798 .50031 .41908 .49859 .41226 .49818 Metetra
.104 0 0 r
.41226 .49818 .41908 .49859 .43022 .49763 .42338 .49932 Metetra
.402 0 0 r
.42338 .49932 .43022 .49763 .44141 .49763 .43455 .50175 Metetra
.546 .043 .013 r
.43455 .50175 .44141 .49763 .45263 .49877 .44577 .50554 Metetra
.604 .16 .169 r
.44577 .50554 .45263 .49877 .46392 .50119 .45706 .51063 Metetra
.627 .222 .256 r
.45706 .51063 .46392 .50119 .47527 .50498 .46844 .51685 Metetra
.635 .254 .305 r
.46844 .51685 .47527 .50498 .48671 .51007 .47993 .52381 Metetra
.632 .266 .33 r
.47993 .52381 .48671 .51007 .49825 .51629 .49155 .53099 Metetra
.623 .261 .336 r
.49155 .53099 .49825 .51629 .5099 .52325 .50329 .5377 Metetra
.604 .239 .322 r
.50329 .5377 .5099 .52325 .52168 .53043 .51516 .54319 Metetra
.569 .187 .278 r
.51516 .54319 .52168 .53043 .53358 .53713 .52714 .54672 Metetra
.491 .068 .164 r
.52714 .54672 .53358 .53713 .5456 .54262 .53922 .54766 Metetra
.224 0 0 r
.53922 .54766 .5456 .54262 .55772 .54615 .55136 .54557 Metetra
.599 .937 .948 r
.55136 .54557 .55772 .54615 .56991 .54709 .56353 .5403 Metetra
.771 .78 .86 r
.56353 .5403 .56991 .54709 .58214 .54501 .57569 .53198 Metetra
.752 .661 .76 r
.57569 .53198 .58214 .54501 .59436 .53974 .58783 .52103 Metetra
.733 .602 .711 r
.58783 .52103 .59436 .53974 .60656 .53142 .59992 .50807 Metetra
.719 .57 .686 r
.59992 .50807 .60656 .53142 .6187 .52046 .61197 .49384 Metetra
.709 .551 .673 r
.61197 .49384 .6187 .52046 .63078 .50749 .62397 .47909 Metetra
.701 .541 .667 r
.62397 .47909 .63078 .50749 .6428 .49326 .63596 .46451 Metetra
.695 .536 .667 r
.63596 .46451 .6428 .49326 .65478 .4785 .64794 .45065 Metetra
.69 .535 .672 r
.64794 .45065 .65478 .4785 .66673 .46392 .65995 .43789 Metetra
.686 .539 .68 r
.65995 .43789 .66673 .46392 .67869 .45006 .67201 .42643 Metetra
.684 .548 .693 r
.67201 .42643 .67869 .45006 .69069 .43729 .68412 .41633 Metetra
.682 .56 .711 r
.68412 .41633 .69069 .43729 .70275 .42582 .69632 .40752 Metetra
.681 .577 .732 r
.69632 .40752 .70275 .42582 .71488 .41571 .7086 .39985 Metetra
.68 .598 .757 r
.7086 .39985 .71488 .41571 .7271 .4069 .72096 .39316 Metetra
.68 .622 .784 r
.72096 .39316 .7271 .4069 .73941 .39923 .73341 .38723 Metetra
.678 .646 .811 r
.73341 .38723 .73941 .39923 .75182 .39254 .74594 .38189 Metetra
.676 .67 .836 r
.74594 .38189 .75182 .39254 .76433 .38661 .75855 .37697 Metetra
.673 .69 .858 r
.75855 .37697 .76433 .38661 .77692 .38126 .77123 .37234 Metetra
.671 .706 .874 r
.77123 .37234 .77692 .38126 .78959 .37634 .78398 .3679 Metetra
.668 .719 .886 r
.78398 .3679 .78959 .37634 .80234 .37171 .79679 .36358 Metetra
.667 .727 .895 r
.79679 .36358 .80234 .37171 .81516 .36727 .80967 .35932 Metetra
.665 .733 .9 r
.80967 .35932 .81516 .36727 .82805 .36294 .82261 .3551 Metetra
.665 .736 .903 r
.82261 .3551 .82805 .36294 .841 .35868 .83562 .35088 Metetra
.664 .739 .905 r
.83562 .35088 .841 .35868 .85401 .35446 .84868 .34667 Metetra
.664 .74 .907 r
.84868 .34667 .85401 .35446 .86709 .35024 .8618 .34244 Metetra
.664 .741 .907 r
.8618 .34244 .86709 .35024 .88023 .34602 .87498 .3382 Metetra
.664 .741 .908 r
.87498 .3382 .88023 .34602 .89342 .3418 .88822 .33395 Metetra
.664 .741 .908 r
.88822 .33395 .89342 .3418 .90668 .33756 .90152 .32968 Metetra
.658 .759 .925 r
.30669 .51299 .31364 .51881 .32445 .51539 .31753 .50962 Metetra
.647 .759 .931 r
.31753 .50962 .32445 .51539 .33531 .51206 .3284 .50652 Metetra
.631 .764 .943 r
.3284 .50652 .33531 .51206 .3462 .50886 .3393 .50376 Metetra
.604 .773 .961 r
.3393 .50376 .3462 .50886 .35713 .50586 .35022 .50144 Metetra
.555 .784 .984 r
.35022 .50144 .35713 .50586 .3681 .50315 .36117 .49971 Metetra
.455 .785 .999 r
.36117 .49971 .3681 .50315 .37909 .50086 .37214 .49874 Metetra
.242 .72 .936 r
.37214 .49874 .37909 .50086 .39012 .49914 .38313 .49874 Metetra
.108 0 0 r
.38313 .49874 .39012 .49914 .40117 .49819 .39415 .49988 Metetra
.405 0 0 r
.39415 .49988 .40117 .49819 .41226 .49818 .40519 .50231 Metetra
.547 .045 .015 r
.40519 .50231 .41226 .49818 .42338 .49932 .41628 .5061 Metetra
.605 .162 .171 r
.41628 .5061 .42338 .49932 .43455 .50175 .42743 .51119 Metetra
.628 .223 .257 r
.42743 .51119 .43455 .50175 .44577 .50554 .43866 .51741 Metetra
.635 .254 .306 r
.43866 .51741 .44577 .50554 .45706 .51063 .44999 .52437 Metetra
.632 .266 .33 r
.44999 .52437 .45706 .51063 .46844 .51685 .46144 .53155 Metetra
.623 .261 .336 r
.46144 .53155 .46844 .51685 .47993 .52381 .47302 .53826 Metetra
.604 .239 .322 r
.47302 .53826 .47993 .52381 .49155 .53099 .48473 .54376 Metetra
.569 .186 .277 r
.48473 .54376 .49155 .53099 .50329 .5377 .49658 .54729 Metetra
.489 .065 .162 r
.49658 .54729 .50329 .5377 .51516 .54319 .50855 .54823 Metetra
.217 0 0 r
.50855 .54823 .51516 .54319 .52714 .54672 .5206 .54614 Metetra
.605 .937 .951 r
.5206 .54614 .52714 .54672 .53922 .54766 .53271 .54086 Metetra
.77 .778 .859 r
.53271 .54086 .53922 .54766 .55136 .54557 .54485 .53255 Metetra
.752 .66 .76 r
.54485 .53255 .55136 .54557 .56353 .5403 .55698 .5216 Metetra
.733 .602 .711 r
.55698 .5216 .56353 .5403 .57569 .53198 .56908 .50865 Metetra
.719 .57 .686 r
.56908 .50865 .57569 .53198 .58783 .52103 .58115 .49442 Metetra
.709 .551 .673 r
.58115 .49442 .58783 .52103 .59992 .50807 .59319 .47968 Metetra
.701 .541 .667 r
.59319 .47968 .59992 .50807 .61197 .49384 .6052 .46511 Metetra
.695 .536 .667 r
.6052 .46511 .61197 .49384 .62397 .47909 .61721 .45125 Metetra
.69 .535 .672 r
.61721 .45125 .62397 .47909 .63596 .46451 .62923 .43849 Metetra
.686 .539 .68 r
.62923 .43849 .63596 .46451 .64794 .45065 .64128 .42703 Metetra
.684 .548 .693 r
.64128 .42703 .64794 .45065 .65995 .43789 .65339 .41693 Metetra
.682 .56 .711 r
.65339 .41693 .65995 .43789 .67201 .42643 .66556 .40813 Metetra
.681 .577 .732 r
.66556 .40813 .67201 .42643 .68412 .41633 .6778 .40047 Metetra
.68 .598 .757 r
.6778 .40047 .68412 .41633 .69632 .40752 .69012 .39378 Metetra
.68 .622 .784 r
.69012 .39378 .69632 .40752 .7086 .39985 .70251 .38785 Metetra
.678 .646 .811 r
.70251 .38785 .7086 .39985 .72096 .39316 .71498 .38251 Metetra
.676 .67 .836 r
.71498 .38251 .72096 .39316 .73341 .38723 .72753 .37759 Metetra
.673 .69 .858 r
.72753 .37759 .73341 .38723 .74594 .38189 .74014 .37297 Metetra
.671 .707 .874 r
.74014 .37297 .74594 .38189 .75855 .37697 .75282 .36853 Metetra
.668 .719 .887 r
.75282 .36853 .75855 .37697 .77123 .37234 .76556 .36421 Metetra
.667 .727 .895 r
.76556 .36421 .77123 .37234 .78398 .3679 .77837 .35996 Metetra
.665 .733 .9 r
.77837 .35996 .78398 .3679 .79679 .36358 .79124 .35574 Metetra
.665 .736 .903 r
.79124 .35574 .79679 .36358 .80967 .35932 .80416 .35153 Metetra
.664 .739 .905 r
.80416 .35153 .80967 .35932 .82261 .3551 .81715 .34732 Metetra
.664 .74 .907 r
.81715 .34732 .82261 .3551 .83562 .35088 .83019 .34309 Metetra
.664 .741 .907 r
.83019 .34309 .83562 .35088 .84868 .34667 .8433 .33886 Metetra
.664 .741 .908 r
.8433 .33886 .84868 .34667 .8618 .34244 .85646 .3346 Metetra
.664 .741 .908 r
.85646 .3346 .8618 .34244 .87498 .3382 .86969 .33033 Metetra
.664 .741 .908 r
.86969 .33033 .87498 .3382 .88822 .33395 .88297 .32604 Metetra
.664 .741 .908 r
.88297 .32604 .88822 .33395 .90152 .32968 .89632 .32173 Metetra
.645 .794 .954 r
.29962 .50822 .30669 .51299 .31753 .50962 .31048 .505 Metetra
.612 .793 .968 r
.31048 .505 .31753 .50962 .3284 .50652 .32135 .50239 Metetra
.559 .796 .988 r
.32135 .50239 .3284 .50652 .3393 .50376 .33223 .50048 Metetra
.454 .791 .999 r
.33223 .50048 .3393 .50376 .35022 .50144 .34312 .49942 Metetra
.238 .72 .932 r
.34312 .49942 .35022 .50144 .36117 .49971 .35402 .49936 Metetra
.113 0 0 r
.35402 .49936 .36117 .49971 .37214 .49874 .36493 .50047 Metetra
.407 0 0 r
.36493 .50047 .37214 .49874 .38313 .49874 .37586 .50288 Metetra
.548 .047 .018 r
.37586 .50288 .38313 .49874 .39415 .49988 .38682 .50666 Metetra
.605 .163 .172 r
.38682 .50666 .39415 .49988 .40519 .50231 .39783 .51176 Metetra
.628 .224 .258 r
.39783 .51176 .40519 .50231 .41628 .5061 .4089 .51797 Metetra
.635 .255 .306 r
.4089 .51797 .41628 .5061 .42743 .51119 .42007 .52493 Metetra
.632 .266 .33 r
.42007 .52493 .42743 .51119 .43866 .51741 .43135 .53211 Metetra
.623 .261 .336 r
.43135 .53211 .43866 .51741 .44999 .52437 .44277 .53882 Metetra
.604 .238 .321 r
.44277 .53882 .44999 .52437 .46144 .53155 .45433 .54432 Metetra
.568 .185 .276 r
.45433 .54432 .46144 .53155 .47302 .53826 .46605 .54786 Metetra
.488 .063 .159 r
.46605 .54786 .47302 .53826 .48473 .54376 .4779 .54879 Metetra
.212 0 0 r
.4779 .54879 .48473 .54376 .49658 .54729 .48987 .5467 Metetra
.61 .938 .953 r
.48987 .5467 .49658 .54729 .50855 .54823 .50192 .54143 Metetra
.77 .777 .858 r
.50192 .54143 .50855 .54823 .5206 .54614 .51403 .53311 Metetra
.752 .66 .759 r
.51403 .53311 .5206 .54614 .53271 .54086 .52615 .52217 Metetra
.733 .602 .711 r
.52615 .52217 .53271 .54086 .54485 .53255 .53827 .50921 Metetra
.719 .57 .686 r
.53827 .50921 .54485 .53255 .55698 .5216 .55036 .495 Metetra
.709 .551 .673 r
.55036 .495 .55698 .5216 .56908 .50865 .56243 .48027 Metetra
.701 .541 .667 r
.56243 .48027 .56908 .50865 .58115 .49442 .57447 .4657 Metetra
.695 .536 .667 r
.57447 .4657 .58115 .49442 .59319 .47968 .5865 .45185 Metetra
.69 .535 .672 r
.5865 .45185 .59319 .47968 .6052 .46511 .59853 .43909 Metetra
.686 .539 .68 r
.59853 .43909 .6052 .46511 .61721 .45125 .61059 .42764 Metetra
.684 .548 .693 r
.61059 .42764 .61721 .45125 .62923 .43849 .62268 .41754 Metetra
.682 .56 .711 r
.62268 .41754 .62923 .43849 .64128 .42703 .63482 .40874 Metetra
.681 .577 .732 r
.63482 .40874 .64128 .42703 .65339 .41693 .64702 .40109 Metetra
.68 .598 .757 r
.64702 .40109 .65339 .41693 .66556 .40813 .6593 .3944 Metetra
.679 .622 .784 r
.6593 .3944 .66556 .40813 .6778 .40047 .67164 .38848 Metetra
.678 .646 .811 r
.67164 .38848 .6778 .40047 .69012 .39378 .68405 .38314 Metetra
.676 .67 .836 r
.68405 .38314 .69012 .39378 .70251 .38785 .69653 .37822 Metetra
.673 .69 .858 r
.69653 .37822 .70251 .38785 .71498 .38251 .70907 .3736 Metetra
.671 .707 .874 r
.70907 .3736 .71498 .38251 .72753 .37759 .72168 .36916 Metetra
.668 .719 .887 r
.72168 .36916 .72753 .37759 .74014 .37297 .73435 .36485 Metetra
.667 .727 .895 r
.73435 .36485 .74014 .37297 .75282 .36853 .74709 .3606 Metetra
.665 .733 .9 r
.74709 .3606 .75282 .36853 .76556 .36421 .75988 .35638 Metetra
.665 .736 .904 r
.75988 .35638 .76556 .36421 .77837 .35996 .77273 .35217 Metetra
.664 .739 .905 r
.77273 .35217 .77837 .35996 .79124 .35574 .78564 .34796 Metetra
.664 .74 .907 r
.78564 .34796 .79124 .35574 .80416 .35153 .79861 .34374 Metetra
.664 .741 .907 r
.79861 .34374 .80416 .35153 .81715 .34732 .81164 .33951 Metetra
.664 .741 .908 r
.81164 .33951 .81715 .34732 .83019 .34309 .82473 .33526 Metetra
.664 .741 .908 r
.82473 .33526 .83019 .34309 .8433 .33886 .83788 .33099 Metetra
.664 .741 .908 r
.83788 .33099 .8433 .33886 .85646 .3346 .85109 .3267 Metetra
.664 .741 .908 r
.85109 .3267 .85646 .3346 .86969 .33033 .86435 .3224 Metetra
.664 .741 .908 r
.86435 .3224 .86969 .33033 .88297 .32604 .87768 .31807 Metetra
.664 .741 .908 r
.87768 .31807 .88297 .32604 .89632 .32173 .89107 .31373 Metetra
.574 .867 .995 r
.29231 .50588 .29962 .50822 .31048 .505 .30319 .50291 Metetra
.451 .83 .989 r
.30319 .50291 .31048 .505 .32135 .50239 .31405 .50114 Metetra
.219 .726 .896 r
.31405 .50114 .32135 .50239 .33223 .50048 .32488 .50061 Metetra
.126 0 0 r
.32488 .50061 .33223 .50048 .34312 .49942 .33571 .50143 Metetra
.408 0 0 r
.33571 .50143 .34312 .49942 .35402 .49936 .34653 .50367 Metetra
.546 .049 .026 r
.34653 .50367 .35402 .49936 .36493 .50047 .35737 .50735 Metetra
.604 .163 .175 r
.35737 .50735 .36493 .50047 .37586 .50288 .36824 .51238 Metetra
.627 .224 .26 r
.36824 .51238 .37586 .50288 .38682 .50666 .37916 .51856 Metetra
.635 .255 .307 r
.37916 .51856 .38682 .50666 .39783 .51176 .39016 .52551 Metetra
.632 .266 .33 r
.39016 .52551 .39783 .51176 .4089 .51797 .40128 .53267 Metetra
.623 .261 .335 r
.40128 .53267 .4089 .51797 .42007 .52493 .41254 .53938 Metetra
.604 .238 .321 r
.41254 .53938 .42007 .52493 .43135 .53211 .42395 .54488 Metetra
.568 .184 .275 r
.42395 .54488 .43135 .53211 .44277 .53882 .43553 .54841 Metetra
.486 .06 .156 r
.43553 .54841 .44277 .53882 .45433 .54432 .44727 .54935 Metetra
.206 0 0 r
.44727 .54935 .45433 .54432 .46605 .54786 .45915 .54727 Metetra
.614 .938 .954 r
.45915 .54727 .46605 .54786 .4779 .54879 .47115 .54199 Metetra
.77 .776 .858 r
.47115 .54199 .4779 .54879 .48987 .5467 .48322 .53367 Metetra
.752 .66 .759 r
.48322 .53367 .48987 .5467 .50192 .54143 .49534 .52273 Metetra
.733 .602 .711 r
.49534 .52273 .50192 .54143 .51403 .53311 .50747 .50978 Metetra
.719 .57 .686 r
.50747 .50978 .51403 .53311 .52615 .52217 .51959 .49557 Metetra
.709 .551 .673 r
.51959 .49557 .52615 .52217 .53827 .50921 .53169 .48084 Metetra
.701 .541 .667 r
.53169 .48084 .53827 .50921 .55036 .495 .54376 .46629 Metetra
.695 .536 .667 r
.54376 .46629 .55036 .495 .56243 .48027 .55581 .45245 Metetra
.69 .535 .672 r
.55581 .45245 .56243 .48027 .57447 .4657 .56785 .43969 Metetra
.686 .539 .68 r
.56785 .43969 .57447 .4657 .5865 .45185 .57991 .42824 Metetra
.684 .547 .693 r
.57991 .42824 .5865 .45185 .59853 .43909 .59199 .41815 Metetra
.682 .56 .711 r
.59199 .41815 .59853 .43909 .61059 .42764 .6041 .40935 Metetra
.681 .577 .732 r
.6041 .40935 .61059 .42764 .62268 .41754 .61627 .4017 Metetra
.68 .598 .757 r
.61627 .4017 .62268 .41754 .63482 .40874 .6285 .39501 Metetra
.679 .622 .784 r
.6285 .39501 .63482 .40874 .64702 .40109 .64078 .3891 Metetra
.678 .646 .811 r
.64078 .3891 .64702 .40109 .6593 .3944 .65313 .38376 Metetra
.676 .67 .837 r
.65313 .38376 .6593 .3944 .67164 .38848 .66555 .37885 Metetra
.673 .69 .858 r
.66555 .37885 .67164 .38848 .68405 .38314 .67803 .37423 Metetra
.671 .707 .874 r
.67803 .37423 .68405 .38314 .69653 .37822 .69057 .3698 Metetra
.668 .719 .887 r
.69057 .3698 .69653 .37822 .70907 .3736 .70317 .36548 Metetra
.667 .727 .895 r
.70317 .36548 .70907 .3736 .72168 .36916 .71583 .36123 Metetra
.665 .733 .9 r
.71583 .36123 .72168 .36916 .73435 .36485 .72855 .35702 Metetra
.665 .736 .904 r
.72855 .35702 .73435 .36485 .74709 .3606 .74132 .35282 Metetra
.664 .739 .905 r
.74132 .35282 .74709 .3606 .75988 .35638 .75416 .34861 Metetra
.664 .74 .907 r
.75416 .34861 .75988 .35638 .77273 .35217 .76706 .34439 Metetra
.664 .741 .907 r
.76706 .34439 .77273 .35217 .78564 .34796 .78001 .34016 Metetra
.664 .741 .908 r
.78001 .34016 .78564 .34796 .79861 .34374 .79302 .33591 Metetra
.664 .741 .908 r
.79302 .33591 .79861 .34374 .81164 .33951 .80609 .33165 Metetra
.664 .741 .908 r
.80609 .33165 .81164 .33951 .82473 .33526 .81922 .32736 Metetra
.664 .741 .908 r
.81922 .32736 .82473 .33526 .83788 .33099 .83241 .32306 Metetra
.664 .741 .908 r
.83241 .32306 .83788 .33099 .85109 .3267 .84566 .31874 Metetra
.664 .741 .908 r
.84566 .31874 .85109 .3267 .86435 .3224 .85897 .3144 Metetra
.664 .741 .908 r
.85897 .3144 .86435 .3224 .87768 .31807 .87235 .31003 Metetra
.664 .741 .908 r
.87235 .31003 .87768 .31807 .89107 .31373 .88578 .30565 Metetra
.28459 .50826 .29231 .50588 .30319 .50291 .2955 .50566 Metetra
.175 0 0 r
.2955 .50566 .30319 .50291 .31405 .50114 .30633 .50496 Metetra
.4 0 0 r
.30633 .50496 .31405 .50114 .32488 .50061 .31712 .50614 Metetra
.53 .052 .065 r
.31712 .50614 .32488 .50061 .33571 .50143 .32787 .50909 Metetra
.593 .161 .19 r
.32787 .50909 .33571 .50143 .34653 .50367 .33863 .51366 Metetra
.621 .222 .266 r
.33863 .51366 .34653 .50367 .35737 .50735 .34941 .51954 Metetra
.631 .253 .309 r
.34941 .51954 .35737 .50735 .36824 .51238 .36027 .5263 Metetra
.63 .265 .331 r
.36027 .5263 .36824 .51238 .37916 .51856 .37123 .53336 Metetra
.622 .26 .336 r
.37123 .53336 .37916 .51856 .39016 .52551 .38232 .54001 Metetra
.603 .237 .32 r
.38232 .54001 .39016 .52551 .40128 .53267 .39359 .54547 Metetra
.567 .183 .274 r
.39359 .54547 .40128 .53267 .41254 .53938 .40503 .54898 Metetra
.485 .058 .154 r
.40503 .54898 .41254 .53938 .42395 .54488 .41666 .54992 Metetra
.201 0 0 r
.41666 .54992 .42395 .54488 .43553 .54841 .42845 .54783 Metetra
.618 .938 .956 r
.42845 .54783 .43553 .54841 .44727 .54935 .44039 .54256 Metetra
.77 .775 .857 r
.44039 .54256 .44727 .54935 .45915 .54727 .45244 .53425 Metetra
.752 .659 .759 r
.45244 .53425 .45915 .54727 .47115 .54199 .46455 .5233 Metetra
.733 .602 .711 r
.46455 .5233 .47115 .54199 .48322 .53367 .4767 .51035 Metetra
.719 .57 .686 r
.4767 .51035 .48322 .53367 .49534 .52273 .48884 .49614 Metetra
.709 .551 .673 r
.48884 .49614 .49534 .52273 .50747 .50978 .50097 .48142 Metetra
.701 .541 .667 r
.50097 .48142 .50747 .50978 .51959 .49557 .51307 .46687 Metetra
.695 .536 .667 r
.51307 .46687 .51959 .49557 .53169 .48084 .52514 .45304 Metetra
.69 .535 .672 r
.52514 .45304 .53169 .48084 .54376 .46629 .53719 .4403 Metetra
.686 .539 .68 r
.53719 .4403 .54376 .46629 .55581 .45245 .54925 .42885 Metetra
.684 .547 .693 r
.54925 .42885 .55581 .45245 .56785 .43969 .56131 .41876 Metetra
.682 .56 .711 r
.56131 .41876 .56785 .43969 .57991 .42824 .57341 .40996 Metetra
.681 .577 .732 r
.57341 .40996 .57991 .42824 .59199 .41815 .58554 .40231 Metetra
.68 .598 .757 r
.58554 .40231 .59199 .41815 .6041 .40935 .59772 .39563 Metetra
.679 .622 .784 r
.59772 .39563 .6041 .40935 .61627 .4017 .60995 .38972 Metetra
.678 .647 .812 r
.60995 .38972 .61627 .4017 .6285 .39501 .62224 .38439 Metetra
.676 .67 .837 r
.62224 .38439 .6285 .39501 .64078 .3891 .63459 .37948 Metetra
.673 .69 .858 r
.63459 .37948 .64078 .3891 .65313 .38376 .647 .37486 Metetra
.671 .707 .875 r
.647 .37486 .65313 .38376 .66555 .37885 .65947 .37043 Metetra
.668 .719 .887 r
.65947 .37043 .66555 .37885 .67803 .37423 .672 .36612 Metetra
.667 .727 .895 r
.672 .36612 .67803 .37423 .69057 .3698 .68459 .36187 Metetra
.665 .733 .9 r
.68459 .36187 .69057 .3698 .70317 .36548 .69723 .35766 Metetra
.665 .737 .904 r
.69723 .35766 .70317 .36548 .71583 .36123 .70994 .35346 Metetra
.664 .739 .906 r
.70994 .35346 .71583 .36123 .72855 .35702 .7227 .34925 Metetra
.664 .74 .907 r
.7227 .34925 .72855 .35702 .74132 .35282 .73552 .34504 Metetra
.664 .741 .907 r
.73552 .34504 .74132 .35282 .75416 .34861 .7484 .34081 Metetra
.664 .741 .908 r
.7484 .34081 .75416 .34861 .76706 .34439 .76133 .33657 Metetra
.664 .741 .908 r
.76133 .33657 .76706 .34439 .78001 .34016 .77433 .33231 Metetra
.664 .741 .908 r
.77433 .33231 .78001 .34016 .79302 .33591 .78738 .32802 Metetra
.664 .741 .908 r
.78738 .32802 .79302 .33591 .80609 .33165 .80049 .32373 Metetra
.664 .741 .908 r
.80049 .32373 .80609 .33165 .81922 .32736 .81367 .3194 Metetra
.664 .741 .908 r
.81367 .3194 .81922 .32736 .83241 .32306 .8269 .31506 Metetra
.664 .741 .908 r
.8269 .31506 .83241 .32306 .84566 .31874 .84019 .31071 Metetra
.664 .741 .908 r
.84019 .31071 .84566 .31874 .85897 .3144 .85355 .30633 Metetra
.664 .741 .908 r
.85355 .30633 .85897 .3144 .87235 .31003 .86696 .30193 Metetra
.664 .741 .908 r
.86696 .30193 .87235 .31003 .88578 .30565 .88044 .29751 Metetra
.362 0 .094 r
.27618 .51843 .28459 .50826 .2955 .50566 .28715 .51614 Metetra
.47 .058 .175 r
.28715 .51614 .2955 .50566 .30633 .50496 .298 .51634 Metetra
.544 .148 .242 r
.298 .51634 .30633 .50496 .31712 .50614 .30877 .51881 Metetra
.587 .208 .291 r
.30877 .51881 .31712 .50614 .32787 .50909 .31952 .52315 Metetra
.609 .243 .323 r
.31952 .52315 .32787 .50909 .33863 .51366 .33029 .52882 Metetra
.616 .258 .339 r
.33029 .52882 .33863 .51366 .34941 .51954 .34113 .53514 Metetra
.613 .255 .34 r
.34113 .53514 .34941 .51954 .36027 .5263 .35209 .5413 Metetra
.597 .233 .323 r
.35209 .5413 .36027 .5263 .37123 .53336 .36322 .54645 Metetra
.563 .181 .275 r
.36322 .54645 .37123 .53336 .38232 .54001 .37454 .54978 Metetra
.481 .055 .154 r
.37454 .54978 .38232 .54001 .39359 .54547 .38606 .55061 Metetra
.195 0 0 r
.38606 .55061 .39359 .54547 .40503 .54898 .39778 .54846 Metetra
.621 .939 .956 r
.39778 .54846 .40503 .54898 .41666 .54992 .40966 .54316 Metetra
.77 .775 .856 r
.40966 .54316 .41666 .54992 .42845 .54783 .42168 .53483 Metetra
.752 .659 .759 r
.42168 .53483 .42845 .54783 .44039 .54256 .43379 .52388 Metetra
.733 .602 .711 r
.43379 .52388 .44039 .54256 .45244 .53425 .44594 .51093 Metetra
.719 .57 .686 r
.44594 .51093 .45244 .53425 .46455 .5233 .45811 .49672 Metetra
.709 .551 .673 r
.45811 .49672 .46455 .5233 .4767 .51035 .47027 .482 Metetra
.701 .541 .667 r
.47027 .482 .4767 .51035 .48884 .49614 .48239 .46746 Metetra
.695 .536 .667 r
.48239 .46746 .48884 .49614 .50097 .48142 .49449 .45363 Metetra
.69 .535 .672 r
.49449 .45363 .50097 .48142 .51307 .46687 .50656 .44089 Metetra
.686 .539 .68 r
.50656 .44089 .51307 .46687 .52514 .45304 .51861 .42945 Metetra
.684 .547 .693 r
.51861 .42945 .52514 .45304 .53719 .4403 .53066 .41937 Metetra
.682 .56 .711 r
.53066 .41937 .53719 .4403 .54925 .42885 .54273 .41057 Metetra
.681 .577 .732 r
.54273 .41057 .54925 .42885 .56131 .41876 .55482 .40293 Metetra
.68 .598 .757 r
.55482 .40293 .56131 .41876 .57341 .40996 .56696 .39625 Metetra
.679 .622 .784 r
.56696 .39625 .57341 .40996 .58554 .40231 .57914 .39034 Metetra
.678 .647 .812 r
.57914 .39034 .58554 .40231 .59772 .39563 .59137 .38501 Metetra
.676 .67 .837 r
.59137 .38501 .59772 .39563 .60995 .38972 .60365 .3801 Metetra
.673 .69 .858 r
.60365 .3801 .60995 .38972 .62224 .38439 .616 .37548 Metetra
.671 .707 .875 r
.616 .37548 .62224 .38439 .63459 .37948 .6284 .37106 Metetra
.668 .719 .887 r
.6284 .37106 .63459 .37948 .647 .37486 .64086 .36675 Metetra
.666 .727 .895 r
.64086 .36675 .647 .37486 .65947 .37043 .65337 .36251 Metetra
.665 .733 .9 r
.65337 .36251 .65947 .37043 .672 .36612 .66594 .3583 Metetra
.665 .737 .904 r
.66594 .3583 .672 .36612 .68459 .36187 .67857 .3541 Metetra
.664 .739 .906 r
.67857 .3541 .68459 .36187 .69723 .35766 .69126 .3499 Metetra
.664 .74 .907 r
.69126 .3499 .69723 .35766 .70994 .35346 .704 .34569 Metetra
.664 .741 .907 r
.704 .34569 .70994 .35346 .7227 .34925 .71681 .34146 Metetra
.664 .741 .908 r
.71681 .34146 .7227 .34925 .73552 .34504 .72967 .33722 Metetra
.664 .741 .908 r
.72967 .33722 .73552 .34504 .7484 .34081 .74258 .33296 Metetra
.664 .741 .908 r
.74258 .33296 .7484 .34081 .76133 .33657 .75556 .32868 Metetra
.664 .741 .908 r
.75556 .32868 .76133 .33657 .77433 .33231 .7686 .32439 Metetra
.664 .741 .908 r
.7686 .32439 .77433 .33231 .78738 .32802 .78169 .32007 Metetra
.664 .741 .908 r
.78169 .32007 .78738 .32802 .80049 .32373 .79485 .31573 Metetra
.664 .741 .908 r
.79485 .31573 .80049 .32373 .81367 .3194 .80806 .31138 Metetra
.664 .741 .908 r
.80806 .31138 .81367 .3194 .8269 .31506 .82134 .307 Metetra
.664 .741 .908 r
.82134 .307 .8269 .31506 .84019 .31071 .83468 .3026 Metetra
.664 .741 .908 r
.83468 .3026 .84019 .31071 .85355 .30633 .84808 .29819 Metetra
.664 .741 .908 r
.84808 .29819 .85355 .30633 .86696 .30193 .86154 .29375 Metetra
.664 .741 .908 r
.86154 .29375 .86696 .30193 .88044 .29751 .87506 .28929 Metetra
.465 .132 .316 r
.26684 .53906 .27618 .51843 .28715 .51614 .27791 .53678 Metetra
.514 .18 .339 r
.27791 .53678 .28715 .51614 .298 .51634 .28887 .53692 Metetra
.548 .214 .355 r
.28887 .53692 .298 .51634 .30877 .51881 .29977 .53908 Metetra
.568 .234 .362 r
.29977 .53908 .30877 .51881 .31952 .52315 .31067 .54258 Metetra
.576 .237 .357 r
.31067 .54258 .31952 .52315 .33029 .52882 .32163 .54658 Metetra
.569 .22 .337 r
.32163 .54658 .33029 .52882 .34113 .53514 .33272 .55015 Metetra
.541 .172 .29 r
.33272 .55015 .34113 .53514 .35209 .5413 .34398 .55235 Metetra
.465 .053 .173 r
.34398 .55235 .35209 .5413 .36322 .54645 .35543 .55242 Metetra
.194 0 0 r
.35543 .55242 .36322 .54645 .37454 .54978 .36709 .54977 Metetra
.621 .947 .941 r
.36709 .54977 .37454 .54978 .38606 .55061 .37893 .54416 Metetra
.776 .782 .858 r
.37893 .54416 .38606 .55061 .39778 .54846 .39093 .53565 Metetra
.754 .662 .76 r
.39093 .53565 .39778 .54846 .40966 .54316 .40304 .52459 Metetra
.734 .603 .711 r
.40304 .52459 .40966 .54316 .42168 .53483 .41521 .51158 Metetra
.72 .571 .686 r
.41521 .51158 .42168 .53483 .43379 .52388 .4274 .49734 Metetra
.709 .552 .673 r
.4274 .49734 .43379 .52388 .44594 .51093 .43959 .4826 Metetra
.701 .541 .667 r
.43959 .4826 .44594 .51093 .45811 .49672 .45174 .46805 Metetra
.695 .536 .667 r
.45174 .46805 .45811 .49672 .47027 .482 .46386 .45422 Metetra
.69 .535 .672 r
.46386 .45422 .47027 .482 .48239 .46746 .47594 .44149 Metetra
.686 .539 .68 r
.47594 .44149 .48239 .46746 .49449 .45363 .48799 .43006 Metetra
.684 .547 .693 r
.48799 .43006 .49449 .45363 .50656 .44089 .50003 .41998 Metetra
.682 .56 .711 r
.50003 .41998 .50656 .44089 .51861 .42945 .51207 .41119 Metetra
.681 .577 .732 r
.51207 .41119 .51861 .42945 .53066 .41937 .52413 .40354 Metetra
.68 .598 .757 r
.52413 .40354 .53066 .41937 .54273 .41057 .53622 .39687 Metetra
.679 .622 .784 r
.53622 .39687 .54273 .41057 .55482 .40293 .54835 .39096 Metetra
.678 .647 .812 r
.54835 .39096 .55482 .40293 .56696 .39625 .56052 .38563 Metetra
.676 .67 .837 r
.56052 .38563 .56696 .39625 .57914 .39034 .57274 .38073 Metetra
.673 .69 .858 r
.57274 .38073 .57914 .39034 .59137 .38501 .58501 .37611 Metetra
.671 .707 .875 r
.58501 .37611 .59137 .38501 .60365 .3801 .59734 .37169 Metetra
.668 .719 .887 r
.59734 .37169 .60365 .3801 .616 .37548 .60973 .36738 Metetra
.666 .727 .895 r
.60973 .36738 .616 .37548 .6284 .37106 .62217 .36314 Metetra
.665 .733 .9 r
.62217 .36314 .6284 .37106 .64086 .36675 .63467 .35894 Metetra
.664 .737 .904 r
.63467 .35894 .64086 .36675 .65337 .36251 .64723 .35474 Metetra
.664 .739 .906 r
.64723 .35474 .65337 .36251 .66594 .3583 .65984 .35054 Metetra
.664 .74 .907 r
.65984 .35054 .66594 .3583 .67857 .3541 .67251 .34634 Metetra
.664 .741 .907 r
.67251 .34634 .67857 .3541 .69126 .3499 .68524 .34211 Metetra
.664 .741 .908 r
.68524 .34211 .69126 .3499 .704 .34569 .69802 .33788 Metetra
.664 .741 .908 r
.69802 .33788 .704 .34569 .71681 .34146 .71086 .33362 Metetra
.664 .741 .908 r
.71086 .33362 .71681 .34146 .72967 .33722 .72376 .32934 Metetra
.664 .741 .908 r
.72376 .32934 .72967 .33722 .74258 .33296 .73672 .32505 Metetra
.664 .741 .908 r
.73672 .32505 .74258 .33296 .75556 .32868 .74974 .32074 Metetra
.664 .741 .908 r
.74974 .32074 .75556 .32868 .7686 .32439 .76282 .3164 Metetra
.664 .741 .908 r
.76282 .3164 .7686 .32439 .78169 .32007 .77596 .31205 Metetra
.664 .741 .908 r
.77596 .31205 .78169 .32007 .79485 .31573 .78916 .30768 Metetra
.664 .741 .908 r
.78916 .30768 .79485 .31573 .80806 .31138 .80241 .30328 Metetra
.664 .741 .908 r
.80241 .30328 .80806 .31138 .82134 .307 .81573 .29887 Metetra
.664 .741 .908 r
.81573 .29887 .82134 .307 .83468 .3026 .82912 .29443 Metetra
.664 .741 .908 r
.82912 .29443 .83468 .3026 .84808 .29819 .84256 .28998 Metetra
.664 .741 .908 r
.84256 .28998 .84808 .29819 .86154 .29375 .85606 .2855 Metetra
.664 .741 .908 r
.85606 .2855 .86154 .29375 .87506 .28929 .86963 .28101 Metetra
.487 .19 .386 r
.25645 .57045 .26684 .53906 .27791 .53678 .26772 .56759 Metetra
.503 .203 .39 r
.26772 .56759 .27791 .53678 .28887 .53692 .27895 .56594 Metetra
.51 .205 .385 r
.27895 .56594 .28887 .53692 .29977 .53908 .29019 .56506 Metetra
.507 .192 .368 r
.29019 .56506 .29977 .53908 .31067 .54258 .30149 .56429 Metetra
.484 .152 .328 r
.30149 .56429 .31067 .54258 .32163 .54658 .3129 .56286 Metetra
.419 .055 .237 r
.3129 .56286 .32163 .54658 .33272 .55015 .32446 .56001 Metetra
.205 0 0 r
.32446 .56001 .33272 .55015 .34398 .55235 .33618 .55514 Metetra
.561 .931 .802 r
.33618 .55514 .34398 .55235 .35543 .55242 .34807 .5479 Metetra
.811 .835 .868 r
.34807 .5479 .35543 .55242 .36709 .54977 .36011 .53824 Metetra
.772 .684 .766 r
.36011 .53824 .36709 .54977 .37893 .54416 .37225 .52642 Metetra
.743 .613 .714 r
.37225 .52642 .37893 .54416 .39093 .53565 .38447 .51291 Metetra
.724 .576 .687 r
.38447 .51291 .39093 .53565 .40304 .52459 .3967 .49836 Metetra
.712 .554 .674 r
.3967 .49836 .40304 .52459 .41521 .51158 .40892 .48343 Metetra
.702 .542 .668 r
.40892 .48343 .41521 .51158 .4274 .49734 .42111 .46877 Metetra
.696 .536 .667 r
.42111 .46877 .4274 .49734 .43959 .4826 .43325 .45488 Metetra
.69 .536 .672 r
.43325 .45488 .43959 .4826 .45174 .46805 .44534 .44213 Metetra
.687 .539 .68 r
.44534 .44213 .45174 .46805 .46386 .45422 .4574 .43067 Metetra
.684 .548 .693 r
.4574 .43067 .46386 .45422 .47594 .44149 .46942 .42059 Metetra
.682 .56 .711 r
.46942 .42059 .47594 .44149 .48799 .43006 .48144 .41181 Metetra
.681 .577 .732 r
.48144 .41181 .48799 .43006 .50003 .41998 .49346 .40416 Metetra
.68 .598 .757 r
.49346 .40416 .50003 .41998 .51207 .41119 .5055 .39749 Metetra
.679 .622 .785 r
.5055 .39749 .51207 .41119 .52413 .40354 .51757 .39158 Metetra
.678 .647 .812 r
.51757 .39158 .52413 .40354 .53622 .39687 .52969 .38625 Metetra
.676 .67 .837 r
.52969 .38625 .53622 .39687 .54835 .39096 .54184 .38135 Metetra
.673 .691 .858 r
.54184 .38135 .54835 .39096 .56052 .38563 .55405 .37674 Metetra
.67 .707 .875 r
.55405 .37674 .56052 .38563 .57274 .38073 .56631 .37232 Metetra
.668 .719 .887 r
.56631 .37232 .57274 .38073 .58501 .37611 .57863 .36802 Metetra
.667 .727 .895 r
.57863 .36802 .58501 .37611 .59734 .37169 .591 .36378 Metetra
.665 .733 .9 r
.591 .36378 .59734 .37169 .60973 .36738 .60342 .35958 Metetra
.665 .737 .904 r
.60342 .35958 .60973 .36738 .62217 .36314 .61591 .35538 Metetra
.664 .739 .905 r
.61591 .35538 .62217 .36314 .63467 .35894 .62844 .35119 Metetra
.664 .74 .907 r
.62844 .35119 .63467 .35894 .64723 .35474 .64104 .34699 Metetra
.664 .741 .907 r
.64104 .34699 .64723 .35474 .65984 .35054 .65369 .34276 Metetra
.664 .741 .908 r
.65369 .34276 .65984 .35054 .67251 .34634 .6664 .33853 Metetra
.664 .741 .908 r
.6664 .33853 .67251 .34634 .68524 .34211 .67917 .33428 Metetra
.664 .741 .908 r
.67917 .33428 .68524 .34211 .69802 .33788 .69199 .33 Metetra
.663 .741 .908 r
.69199 .33 .69802 .33788 .71086 .33362 .70487 .32571 Metetra
.664 .741 .908 r
.70487 .32571 .71086 .33362 .72376 .32934 .71781 .3214 Metetra
.664 .741 .908 r
.71781 .3214 .72376 .32934 .73672 .32505 .73081 .31707 Metetra
.664 .741 .908 r
.73081 .31707 .73672 .32505 .74974 .32074 .74387 .31272 Metetra
.664 .741 .908 r
.74387 .31272 .74974 .32074 .76282 .3164 .75699 .30835 Metetra
.664 .741 .908 r
.75699 .30835 .76282 .3164 .77596 .31205 .77017 .30396 Metetra
.664 .741 .908 r
.77017 .30396 .77596 .31205 .78916 .30768 .78341 .29955 Metetra
.664 .741 .908 r
.78341 .29955 .78916 .30768 .80241 .30328 .79672 .29512 Metetra
.664 .741 .908 r
.79672 .29512 .80241 .30328 .81573 .29887 .81008 .29067 Metetra
.664 .741 .908 r
.81008 .29067 .81573 .29887 .82912 .29443 .8235 .28619 Metetra
.664 .741 .908 r
.8235 .28619 .82912 .29443 .84256 .28998 .83699 .2817 Metetra
.664 .741 .908 r
.83699 .2817 .84256 .28998 .85606 .2855 .85054 .27719 Metetra
.664 .741 .908 r
.85054 .27719 .85606 .2855 .86963 .28101 .86416 .27265 Metetra
.482 .196 .403 r
.24531 .60821 .25645 .57045 .26772 .56759 .25684 .6041 Metetra
.464 .177 .392 r
.25684 .6041 .26772 .56759 .27895 .56594 .26851 .59879 Metetra
.433 .139 .365 r
.26851 .59879 .27895 .56594 .29019 .56506 .28032 .59212 Metetra
.371 .064 .309 r
.28032 .59212 .29019 .56506 .30149 .56429 .29226 .58389 Metetra
.223 0 .171 r
.29226 .58389 .30149 .56429 .3129 .56286 .30433 .57394 Metetra
.30433 .57394 .3129 .56286 .32446 .56001 .31652 .56222 Metetra
.877 .984 .829 r
.31652 .56222 .32446 .56001 .33618 .55514 .32881 .54881 Metetra
.847 .779 .785 r
.32881 .54881 .33618 .55514 .34807 .5479 .34115 .53402 Metetra
.786 .662 .726 r
.34115 .53402 .34807 .5479 .36011 .53824 .35352 .51826 Metetra
.75 .603 .695 r
.35352 .51826 .36011 .53824 .37225 .52642 .36588 .50208 Metetra
.727 .571 .678 r
.36588 .50208 .37225 .52642 .38447 .51291 .3782 .48602 Metetra
.712 .552 .67 r
.3782 .48602 .38447 .51291 .3967 .49836 .39045 .47059 Metetra
.702 .543 .669 r
.39045 .47059 .3967 .49836 .40892 .48343 .40264 .45621 Metetra
.694 .54 .673 r
.40264 .45621 .40892 .48343 .42111 .46877 .41475 .44314 Metetra
.689 .542 .681 r
.41475 .44314 .42111 .46877 .43325 .45488 .42681 .43151 Metetra
.685 .549 .694 r
.42681 .43151 .43325 .45488 .44534 .44213 .43883 .42133 Metetra
.683 .561 .711 r
.43883 .42133 .44534 .44213 .4574 .43067 .45082 .41248 Metetra
.682 .578 .733 r
.45082 .41248 .4574 .43067 .46942 .42059 .46281 .40481 Metetra
.681 .599 .758 r
.46281 .40481 .46942 .42059 .48144 .41181 .47481 .39812 Metetra
.68 .622 .785 r
.47481 .39812 .48144 .41181 .49346 .40416 .48682 .3922 Metetra
.678 .647 .812 r
.48682 .3922 .49346 .40416 .5055 .39749 .49888 .38688 Metetra
.676 .67 .837 r
.49888 .38688 .5055 .39749 .51757 .39158 .51097 .38198 Metetra
.673 .691 .858 r
.51097 .38198 .51757 .39158 .52969 .38625 .52311 .37737 Metetra
.67 .707 .875 r
.52311 .37737 .52969 .38625 .54184 .38135 .5353 .37295 Metetra
.668 .719 .887 r
.5353 .37295 .54184 .38135 .55405 .37674 .54755 .36865 Metetra
.666 .727 .895 r
.54755 .36865 .55405 .37674 .56631 .37232 .55985 .36441 Metetra
.665 .733 .9 r
.55985 .36441 .56631 .37232 .57863 .36802 .5722 .36022 Metetra
.665 .737 .904 r
.5722 .36022 .57863 .36802 .591 .36378 .58461 .35602 Metetra
.664 .739 .906 r
.58461 .35602 .591 .36378 .60342 .35958 .59707 .35183 Metetra
.664 .74 .907 r
.59707 .35183 .60342 .35958 .61591 .35538 .60959 .34763 Metetra
.664 .741 .907 r
.60959 .34763 .61591 .35538 .62844 .35119 .62217 .34341 Metetra
.664 .741 .908 r
.62217 .34341 .62844 .35119 .64104 .34699 .6348 .33918 Metetra
.664 .741 .908 r
.6348 .33918 .64104 .34699 .65369 .34276 .64749 .33493 Metetra
.663 .741 .908 r
.64749 .33493 .65369 .34276 .6664 .33853 .66024 .33066 Metetra
.664 .741 .908 r
.66024 .33066 .6664 .33853 .67917 .33428 .67304 .32637 Metetra
.664 .741 .908 r
.67304 .32637 .67917 .33428 .69199 .33 .68591 .32206 Metetra
.663 .741 .908 r
.68591 .32206 .69199 .33 .70487 .32571 .69883 .31774 Metetra
.664 .741 .908 r
.69883 .31774 .70487 .32571 .71781 .3214 .71181 .31339 Metetra
.664 .741 .908 r
.71181 .31339 .71781 .3214 .73081 .31707 .72485 .30902 Metetra
.664 .741 .908 r
.72485 .30902 .73081 .31707 .74387 .31272 .73795 .30464 Metetra
.664 .741 .908 r
.73795 .30464 .74387 .31272 .75699 .30835 .75112 .30023 Metetra
.664 .741 .908 r
.75112 .30023 .75699 .30835 .77017 .30396 .76434 .2958 Metetra
.664 .741 .908 r
.76434 .2958 .77017 .30396 .78341 .29955 .77762 .29135 Metetra
.664 .741 .908 r
.77762 .29135 .78341 .29955 .79672 .29512 .79097 .28688 Metetra
.664 .741 .908 r
.79097 .28688 .79672 .29512 .81008 .29067 .80438 .28239 Metetra
.664 .741 .908 r
.80438 .28239 .81008 .29067 .8235 .28619 .81785 .27788 Metetra
.664 .741 .908 r
.81785 .27788 .8235 .28619 .83699 .2817 .83138 .27335 Metetra
.664 .741 .908 r
.83138 .27335 .83699 .2817 .85054 .27719 .84498 .2688 Metetra
.664 .741 .908 r
.84498 .2688 .85054 .27719 .86416 .27265 .85864 .26422 Metetra
.45 .156 .374 r
.23417 .64253 .24531 .60821 .25684 .6041 .24599 .63689 Metetra
.375 .083 .336 r
.24599 .63689 .25684 .6041 .26851 .59879 .25817 .62714 Metetra
.25 0 .255 r
.25817 .62714 .26851 .59879 .28032 .59212 .27063 .61367 Metetra
0 0 .062 r
.27063 .61367 .28032 .59212 .29226 .58389 .28329 .5971 Metetra
.589 .804 .399 r
.28329 .5971 .29226 .58389 .30433 .57394 .29608 .5782 Metetra
.945 .953 .74 r
.29608 .5782 .30433 .57394 .31652 .56222 .30891 .55785 Metetra
.897 .8 .744 r
.30891 .55785 .31652 .56222 .32881 .54881 .32171 .53691 Metetra
.831 .694 .713 r
.32171 .53691 .32881 .54881 .34115 .53402 .33443 .51621 Metetra
.785 .633 .693 r
.33443 .51621 .34115 .53402 .35352 .51826 .34703 .49643 Metetra
.754 .597 .682 r
.34703 .49643 .35352 .51826 .36588 .50208 .3595 .47807 Metetra
.733 .575 .678 r
.3595 .47807 .36588 .50208 .3782 .48602 .37184 .46148 Metetra
.717 .564 .68 r
.37184 .46148 .3782 .48602 .39045 .47059 .38406 .44681 Metetra
.706 .56 .686 r
.38406 .44681 .39045 .47059 .40264 .45621 .39618 .43407 Metetra
.698 .562 .698 r
.39618 .43407 .40264 .45621 .41475 .44314 .40822 .42314 Metetra
.692 .571 .714 r
.40822 .42314 .41475 .44314 .42681 .43151 .42021 .41381 Metetra
.688 .585 .735 r
.42021 .41381 .42681 .43151 .43883 .42133 .43217 .40584 Metetra
.685 .604 .76 r
.43217 .40584 .43883 .42133 .45082 .41248 .44412 .39897 Metetra
.682 .626 .786 r
.44412 .39897 .45082 .41248 .46281 .40481 .45609 .39295 Metetra
.679 .649 .813 r
.45609 .39295 .46281 .40481 .47481 .39812 .46809 .38757 Metetra
.677 .672 .838 r
.46809 .38757 .47481 .39812 .48682 .3922 .48012 .38263 Metetra
.674 .691 .859 r
.48012 .38263 .48682 .3922 .49888 .38688 .49219 .37801 Metetra
.671 .707 .875 r
.49219 .37801 .49888 .38688 .51097 .38198 .50431 .37359 Metetra
.668 .719 .887 r
.50431 .37359 .51097 .38198 .52311 .37737 .51649 .36928 Metetra
.666 .728 .895 r
.51649 .36928 .52311 .37737 .5353 .37295 .52871 .36505 Metetra
.665 .733 .9 r
.52871 .36505 .5353 .37295 .54755 .36865 .54099 .36085 Metetra
.665 .737 .904 r
.54099 .36085 .54755 .36865 .55985 .36441 .55333 .35666 Metetra
.664 .739 .906 r
.55333 .35666 .55985 .36441 .5722 .36022 .56572 .35248 Metetra
.664 .74 .907 r
.56572 .35248 .5722 .36022 .58461 .35602 .57816 .34828 Metetra
.664 .741 .907 r
.57816 .34828 .58461 .35602 .59707 .35183 .59066 .34406 Metetra
.664 .741 .908 r
.59066 .34406 .59707 .35183 .60959 .34763 .60322 .33983 Metetra
.664 .741 .908 r
.60322 .33983 .60959 .34763 .62217 .34341 .61583 .33559 Metetra
.664 .741 .908 r
.61583 .33559 .62217 .34341 .6348 .33918 .62851 .33132 Metetra
.664 .741 .908 r
.62851 .33132 .6348 .33918 .64749 .33493 .64124 .32703 Metetra
.664 .741 .908 r
.64124 .32703 .64749 .33493 .66024 .33066 .65402 .32273 Metetra
.664 .741 .908 r
.65402 .32273 .66024 .33066 .67304 .32637 .66687 .31841 Metetra
.664 .741 .908 r
.66687 .31841 .67304 .32637 .68591 .32206 .67977 .31406 Metetra
.664 .741 .908 r
.67977 .31406 .68591 .32206 .69883 .31774 .69274 .3097 Metetra
.664 .741 .908 r
.69274 .3097 .69883 .31774 .71181 .31339 .70576 .30531 Metetra
.664 .741 .908 r
.70576 .30531 .71181 .31339 .72485 .30902 .71884 .30091 Metetra
.664 .741 .908 r
.71884 .30091 .72485 .30902 .73795 .30464 .73199 .29648 Metetra
.664 .741 .908 r
.73199 .29648 .73795 .30464 .75112 .30023 .74519 .29204 Metetra
.664 .741 .908 r
.74519 .29204 .75112 .30023 .76434 .2958 .75846 .28757 Metetra
.664 .741 .908 r
.75846 .28757 .76434 .2958 .77762 .29135 .77178 .28309 Metetra
.664 .741 .908 r
.77178 .28309 .77762 .29135 .79097 .28688 .78517 .27858 Metetra
.664 .741 .908 r
.78517 .27858 .79097 .28688 .80438 .28239 .79862 .27405 Metetra
.664 .741 .908 r
.79862 .27405 .80438 .28239 .81785 .27788 .81214 .2695 Metetra
.664 .741 .908 r
.81214 .2695 .81785 .27788 .83138 .27335 .82572 .26493 Metetra
.664 .741 .908 r
.82572 .26493 .83138 .27335 .84498 .2688 .83936 .26034 Metetra
.664 .741 .908 r
.83936 .26034 .84498 .2688 .85864 .26422 .85307 .25572 Metetra
.302 0 .183 r
.22414 .66096 .23417 .64253 .24599 .63689 .23617 .65422 Metetra
.23617 .65422 .24599 .63689 .25817 .62714 .24871 .64136 Metetra
.24871 .64136 .25817 .62714 .27063 .61367 .26165 .62319 Metetra
.892 .964 .638 r
.26165 .62319 .27063 .61367 .28329 .5971 .27484 .60101 Metetra
.963 .912 .716 r
.27484 .60101 .28329 .5971 .29608 .5782 .28814 .57631 Metetra
.93 .821 .717 r
.28814 .57631 .29608 .5782 .30891 .55785 .3014 .55062 Metetra
.886 .751 .708 r
.3014 .55062 .30891 .55785 .32171 .53691 .31455 .5253 Metetra
.847 .701 .7 r
.31455 .5253 .32171 .53691 .33443 .51621 .32751 .50143 Metetra
.815 .666 .697 r
.32751 .50143 .33443 .51621 .34703 .49643 .34026 .47976 Metetra
.789 .642 .699 r
.34026 .47976 .34703 .49643 .3595 .47807 .3528 .46068 Metetra
.768 .628 .705 r
.3528 .46068 .3595 .47807 .37184 .46148 .36515 .44431 Metetra
.75 .621 .716 r
.36515 .44431 .37184 .46148 .38406 .44681 .37735 .43051 Metetra
.735 .62 .731 r
.37735 .43051 .38406 .44681 .39618 .43407 .38943 .41903 Metetra
.722 .626 .75 r
.38943 .41903 .39618 .43407 .40822 .42314 .40144 .40949 Metetra
.711 .637 .772 r
.40144 .40949 .40822 .42314 .42021 .41381 .4134 .40153 Metetra
.702 .651 .796 r
.4134 .40153 .42021 .41381 .43217 .40584 .42535 .39477 Metetra
.693 .668 .821 r
.42535 .39477 .43217 .40584 .44412 .39897 .4373 .38891 Metetra
.686 .685 .843 r
.4373 .38891 .44412 .39897 .45609 .39295 .44928 .38367 Metetra
.679 .7 .862 r
.44928 .38367 .45609 .39295 .46809 .38757 .46129 .37887 Metetra
.674 .713 .877 r
.46129 .37887 .46809 .38757 .48012 .38263 .47334 .37434 Metetra
.67 .722 .888 r
.47334 .37434 .48012 .38263 .49219 .37801 .48545 .36998 Metetra
.667 .729 .896 r
.48545 .36998 .49219 .37801 .50431 .37359 .4976 .36572 Metetra
.666 .734 .901 r
.4976 .36572 .50431 .37359 .51649 .36928 .50981 .36151 Metetra
.665 .737 .904 r
.50981 .36151 .51649 .36928 .52871 .36505 .52207 .35731 Metetra
.664 .739 .906 r
.52207 .35731 .52871 .36505 .54099 .36085 .53438 .35312 Metetra
.664 .74 .907 r
.53438 .35312 .54099 .36085 .55333 .35666 .54676 .34892 Metetra
.664 .741 .907 r
.54676 .34892 .55333 .35666 .56572 .35248 .55918 .34471 Metetra
.664 .741 .908 r
.55918 .34471 .56572 .35248 .57816 .34828 .57166 .34049 Metetra
.664 .741 .908 r
.57166 .34049 .57816 .34828 .59066 .34406 .5842 .33624 Metetra
.663 .741 .908 r
.5842 .33624 .59066 .34406 .60322 .33983 .5968 .33198 Metetra
.664 .741 .908 r
.5968 .33198 .60322 .33983 .61583 .33559 .60945 .32769 Metetra
.664 .741 .908 r
.60945 .32769 .61583 .33559 .62851 .33132 .62216 .32339 Metetra
.663 .741 .908 r
.62216 .32339 .62851 .33132 .64124 .32703 .63493 .31907 Metetra
.664 .741 .908 r
.63493 .31907 .64124 .32703 .65402 .32273 .64776 .31473 Metetra
.663 .741 .908 r
.64776 .31473 .65402 .32273 .66687 .31841 .66064 .31037 Metetra
.664 .741 .908 r
.66064 .31037 .66687 .31841 .67977 .31406 .67359 .30599 Metetra
.664 .741 .908 r
.67359 .30599 .67977 .31406 .69274 .3097 .68659 .30159 Metetra
.663 .741 .908 r
.68659 .30159 .69274 .3097 .70576 .30531 .69966 .29717 Metetra
.664 .741 .908 r
.69966 .29717 .70576 .30531 .71884 .30091 .71278 .29272 Metetra
.664 .741 .908 r
.71278 .29272 .71884 .30091 .73199 .29648 .72597 .28826 Metetra
.664 .741 .908 r
.72597 .28826 .73199 .29648 .74519 .29204 .73921 .28378 Metetra
.664 .741 .908 r
.73921 .28378 .74519 .29204 .75846 .28757 .75252 .27927 Metetra
.663 .741 .908 r
.75252 .27927 .75846 .28757 .77178 .28309 .76589 .27475 Metetra
.664 .741 .908 r
.76589 .27475 .77178 .28309 .78517 .27858 .77933 .2702 Metetra
.664 .741 .908 r
.77933 .2702 .78517 .27858 .79862 .27405 .79282 .26563 Metetra
.663 .741 .908 r
.79282 .26563 .79862 .27405 .81214 .2695 .80638 .26104 Metetra
.664 .741 .908 r
.80638 .26104 .81214 .2695 .82572 .26493 .82001 .25643 Metetra
.664 .741 .908 r
.82001 .25643 .82572 .26493 .83936 .26034 .83369 .2518 Metetra
.663 .741 .908 r
.83369 .2518 .83936 .26034 .85307 .25572 .84745 .24715 Metetra
.739 .778 .884 r
.21613 .65445 .22414 .66096 .23617 .65422 .2282 .64767 Metetra
.825 .776 .806 r
.2282 .64767 .23617 .65422 .24871 .64136 .2408 .63475 Metetra
.861 .768 .758 r
.2408 .63475 .24871 .64136 .26165 .62319 .25381 .61653 Metetra
.878 .761 .729 r
.25381 .61653 .26165 .62319 .27484 .60101 .26708 .59427 Metetra
.886 .757 .714 r
.26708 .59427 .27484 .60101 .28814 .57631 .28046 .5695 Metetra
.889 .755 .708 r
.28046 .5695 .28814 .57631 .3014 .55062 .29381 .54373 Metetra
.889 .756 .709 r
.29381 .54373 .3014 .55062 .31455 .5253 .30704 .51833 Metetra
.885 .757 .715 r
.30704 .51833 .31455 .5253 .32751 .50143 .32008 .4944 Metetra
.878 .76 .728 r
.32008 .4944 .32751 .50143 .34026 .47976 .33291 .47266 Metetra
.868 .763 .745 r
.33291 .47266 .34026 .47976 .3528 .46068 .34552 .45352 Metetra
.853 .766 .765 r
.34552 .45352 .3528 .46068 .36515 .44431 .35794 .43709 Metetra
.834 .768 .789 r
.35794 .43709 .36515 .44431 .37735 .43051 .37019 .42325 Metetra
.812 .769 .813 r
.37019 .42325 .37735 .43051 .38943 .41903 .38232 .41171 Metetra
.786 .768 .836 r
.38232 .41171 .38943 .41903 .40144 .40949 .39437 .40214 Metetra
.761 .764 .856 r
.39437 .40214 .40144 .40949 .4134 .40153 .40638 .39413 Metetra
.736 .76 .872 r
.40638 .39413 .4134 .40153 .42535 .39477 .41836 .38734 Metetra
.715 .756 .884 r
.41836 .38734 .42535 .39477 .4373 .38891 .43035 .38144 Metetra
.698 .751 .893 r
.43035 .38144 .4373 .38891 .44928 .38367 .44237 .37617 Metetra
.686 .748 .899 r
.44237 .37617 .44928 .38367 .46129 .37887 .45441 .37133 Metetra
.677 .746 .902 r
.45441 .37133 .46129 .37887 .47334 .37434 .4665 .36677 Metetra
.672 .744 .905 r
.4665 .36677 .47334 .37434 .48545 .36998 .47864 .36238 Metetra
.668 .743 .906 r
.47864 .36238 .48545 .36998 .4976 .36572 .49083 .35808 Metetra
.666 .742 .907 r
.49083 .35808 .4976 .36572 .50981 .36151 .50307 .35383 Metetra
.665 .742 .907 r
.50307 .35383 .50981 .36151 .52207 .35731 .51537 .3496 Metetra
.664 .742 .908 r
.51537 .3496 .52207 .35731 .53438 .35312 .52772 .34538 Metetra
.664 .741 .908 r
.52772 .34538 .53438 .35312 .54676 .34892 .54013 .34114 Metetra
.664 .741 .908 r
.54013 .34114 .54676 .34892 .55918 .34471 .55259 .3369 Metetra
.664 .741 .908 r
.55259 .3369 .55918 .34471 .57166 .34049 .56511 .33264 Metetra
.664 .741 .908 r
.56511 .33264 .57166 .34049 .5842 .33624 .57769 .32835 Metetra
.663 .741 .908 r
.57769 .32835 .5842 .33624 .5968 .33198 .59032 .32406 Metetra
.664 .741 .908 r
.59032 .32406 .5968 .33198 .60945 .32769 .60301 .31974 Metetra
.664 .741 .908 r
.60301 .31974 .60945 .32769 .62216 .32339 .61576 .3154 Metetra
.663 .741 .908 r
.61576 .3154 .62216 .32339 .63493 .31907 .62857 .31104 Metetra
.664 .741 .908 r
.62857 .31104 .63493 .31907 .64776 .31473 .64144 .30666 Metetra
.663 .741 .908 r
.64144 .30666 .64776 .31473 .66064 .31037 .65436 .30227 Metetra
.664 .741 .908 r
.65436 .30227 .66064 .31037 .67359 .30599 .66735 .29785 Metetra
.664 .741 .908 r
.66735 .29785 .67359 .30599 .68659 .30159 .68039 .29341 Metetra
.663 .741 .908 r
.68039 .29341 .68659 .30159 .69966 .29717 .6935 .28895 Metetra
.664 .741 .908 r
.6935 .28895 .69966 .29717 .71278 .29272 .70667 .28447 Metetra
.664 .741 .908 r
.70667 .28447 .71278 .29272 .72597 .28826 .71989 .27997 Metetra
.664 .741 .908 r
.71989 .27997 .72597 .28826 .73921 .28378 .73318 .27545 Metetra
.664 .741 .908 r
.73318 .27545 .73921 .28378 .75252 .27927 .74654 .2709 Metetra
.663 .741 .908 r
.74654 .2709 .75252 .27927 .76589 .27475 .75995 .26634 Metetra
.664 .741 .908 r
.75995 .26634 .76589 .27475 .77933 .2702 .77343 .26175 Metetra
.664 .741 .908 r
.77343 .26175 .77933 .2702 .79282 .26563 .78697 .25714 Metetra
.663 .741 .908 r
.78697 .25714 .79282 .26563 .80638 .26104 .80057 .25251 Metetra
.664 .741 .908 r
.80057 .25251 .80638 .26104 .82001 .25643 .81424 .24786 Metetra
.664 .741 .908 r
.81424 .24786 .82001 .25643 .83369 .2518 .82798 .24319 Metetra
.663 .741 .908 r
.82798 .24319 .83369 .2518 .84745 .24715 .84178 .23849 Metetra
.619 .48 .67 r
.21034 .62282 .21613 .65445 .2282 .64767 .22227 .61707 Metetra
.659 .509 .67 r
.22227 .61707 .2282 .64767 .2408 .63475 .23459 .6072 Metetra
.698 .544 .675 r
.23459 .6072 .2408 .63475 .25381 .61653 .24722 .59357 Metetra
.738 .586 .685 r
.24722 .59357 .25381 .61653 .26708 .59427 .26008 .57682 Metetra
.783 .637 .699 r
.26008 .57682 .26708 .59427 .28046 .5695 .27308 .55773 Metetra
.831 .698 .717 r
.27308 .55773 .28046 .5695 .29381 .54373 .28613 .53718 Metetra
.879 .768 .736 r
.28613 .53718 .29381 .54373 .30704 .51833 .29915 .51605 Metetra
.918 .84 .752 r
.29915 .51605 .30704 .51833 .32008 .4944 .3121 .49515 Metetra
.939 .903 .762 r
.3121 .49515 .32008 .4944 .33291 .47266 .32492 .47518 Metetra
.936 .949 .767 r
.32492 .47518 .33291 .47266 .34552 .45352 .33759 .45664 Metetra
.916 .975 .776 r
.33759 .45664 .34552 .45352 .35794 .43709 .35012 .43988 Metetra
.89 .987 .798 r
.35012 .43988 .35794 .43709 .37019 .42325 .36251 .42506 Metetra
.865 .989 .833 r
.36251 .42506 .37019 .42325 .38232 .41171 .37479 .41217 Metetra
.841 .978 .875 r
.37479 .41217 .38232 .41171 .39437 .40214 .38698 .4011 Metetra
.814 .953 .908 r
.38698 .4011 .39437 .40214 .40638 .39413 .3991 .39165 Metetra
.784 .916 .928 r
.3991 .39165 .40638 .39413 .41836 .38734 .41119 .38356 Metetra
.754 .876 .934 r
.41119 .38356 .41836 .38734 .43035 .38144 .42326 .37658 Metetra
.728 .839 .933 r
.42326 .37658 .43035 .38144 .44237 .37617 .43535 .37045 Metetra
.708 .808 .928 r
.43535 .37045 .44237 .37617 .45441 .37133 .44745 .36496 Metetra
.693 .786 .922 r
.44745 .36496 .45441 .37133 .4665 .36677 .45959 .35992 Metetra
.682 .77 .918 r
.45959 .35992 .4665 .36677 .47864 .36238 .47177 .35519 Metetra
.675 .759 .914 r
.47177 .35519 .47864 .36238 .49083 .35808 .484 .35067 Metetra
.67 .752 .912 r
.484 .35067 .49083 .35808 .50307 .35383 .49628 .34626 Metetra
.667 .747 .91 r
.49628 .34626 .50307 .35383 .51537 .3496 .50862 .34192 Metetra
.666 .745 .909 r
.50862 .34192 .51537 .3496 .52772 .34538 .521 .33762 Metetra
.665 .743 .909 r
.521 .33762 .52772 .34538 .54013 .34114 .53345 .33333 Metetra
.664 .742 .908 r
.53345 .33333 .54013 .34114 .55259 .3369 .54595 .32903 Metetra
.664 .742 .908 r
.54595 .32903 .55259 .3369 .56511 .33264 .55851 .32473 Metetra
.664 .741 .908 r
.55851 .32473 .56511 .33264 .57769 .32835 .57112 .32041 Metetra
.664 .741 .908 r
.57112 .32041 .57769 .32835 .59032 .32406 .58379 .31607 Metetra
.664 .741 .908 r
.58379 .31607 .59032 .32406 .60301 .31974 .59652 .31171 Metetra
.664 .741 .908 r
.59652 .31171 .60301 .31974 .61576 .3154 .60931 .30734 Metetra
.664 .741 .908 r
.60931 .30734 .61576 .3154 .62857 .31104 .62216 .30294 Metetra
.664 .741 .908 r
.62216 .30294 .62857 .31104 .64144 .30666 .63506 .29853 Metetra
.664 .741 .908 r
.63506 .29853 .64144 .30666 .65436 .30227 .64803 .29409 Metetra
.664 .741 .908 r
.64803 .29409 .65436 .30227 .66735 .29785 .66106 .28964 Metetra
.664 .741 .908 r
.66106 .28964 .66735 .29785 .68039 .29341 .67414 .28516 Metetra
.664 .741 .908 r
.67414 .28516 .68039 .29341 .6935 .28895 .68729 .28066 Metetra
.664 .741 .908 r
.68729 .28066 .6935 .28895 .70667 .28447 .7005 .27614 Metetra
.664 .741 .908 r
.7005 .27614 .70667 .28447 .71989 .27997 .71377 .2716 Metetra
.664 .741 .908 r
.71377 .2716 .71989 .27997 .73318 .27545 .7271 .26704 Metetra
.664 .741 .908 r
.7271 .26704 .73318 .27545 .74654 .2709 .7405 .26246 Metetra
.664 .741 .908 r
.7405 .26246 .74654 .2709 .75995 .26634 .75396 .25785 Metetra
.664 .741 .908 r
.75396 .25785 .75995 .26634 .77343 .26175 .76748 .25323 Metetra
.664 .741 .908 r
.76748 .25323 .77343 .26175 .78697 .25714 .78107 .24858 Metetra
.664 .741 .908 r
.78107 .24858 .78697 .25714 .80057 .25251 .79472 .24391 Metetra
.664 .741 .908 r
.79472 .24391 .80057 .25251 .81424 .24786 .80843 .23922 Metetra
.664 .741 .908 r
.80843 .23922 .81424 .24786 .82798 .24319 .82221 .2345 Metetra
.664 .741 .908 r
.82221 .2345 .82798 .24319 .84178 .23849 .83606 .22977 Metetra
.585 .421 .626 r
.20613 .5749 .21034 .62282 .22227 .61707 .21782 .57064 Metetra
.595 .431 .629 r
.21782 .57064 .22227 .61707 .23459 .6072 .22967 .56516 Metetra
.611 .449 .638 r
.22967 .56516 .23459 .6072 .24722 .59357 .24167 .55831 Metetra
.635 .48 .655 r
.24167 .55831 .24722 .59357 .26008 .57682 .25383 .54988 Metetra
.672 .529 .682 r
.25383 .54988 .26008 .57682 .27308 .55773 .26614 .53971 Metetra
.728 .607 .722 r
.26614 .53971 .27308 .55773 .28613 .53718 .27859 .52775 Metetra
.808 .727 .775 r
.27859 .52775 .28613 .53718 .29915 .51605 .29115 .51409 Metetra
.891 .881 .817 r
.29115 .51409 .29915 .51605 .3121 .49515 .3038 .49902 Metetra
.896 .987 .777 r
.3038 .49902 .3121 .49515 .32492 .47518 .31648 .48299 Metetra
.774 .955 .635 r
.31648 .48299 .32492 .47518 .33759 .45664 .32915 .46652 Metetra
.637 .868 .505 r
.32915 .46652 .33759 .45664 .35012 .43988 .34177 .45019 Metetra
.562 .819 .451 r
.34177 .45019 .35012 .43988 .36251 .42506 .35433 .43449 Metetra
.551 .824 .471 r
.35433 .43449 .36251 .42506 .37479 .41217 .36681 .41985 Metetra
.591 .873 .553 r
.36681 .41985 .37479 .41217 .38698 .4011 .3792 .40654 Metetra
.66 .939 .676 r
.3792 .40654 .38698 .4011 .3991 .39165 .39151 .39467 Metetra
.725 .987 .803 r
.39151 .39467 .3991 .39165 .41119 .38356 .40377 .38427 Metetra
.761 .989 .894 r
.40377 .38427 .41119 .38356 .42326 .37658 .41598 .37521 Metetra
.762 .952 .937 r
.41598 .37521 .42326 .37658 .43535 .37045 .42818 .36735 Metetra
.745 .901 .948 r
.42818 .36735 .43535 .37045 .44745 .36496 .44038 .36047 Metetra
.725 .854 .943 r
.44038 .36047 .44745 .36496 .45959 .35992 .45259 .35436 Metetra
.706 .817 .934 r
.45259 .35436 .45959 .35992 .47177 .35519 .46483 .34886 Metetra
.692 .791 .926 r
.46483 .34886 .47177 .35519 .484 .35067 .47711 .34378 Metetra
.681 .772 .92 r
.47711 .34378 .484 .35067 .49628 .34626 .48943 .33899 Metetra
.674 .76 .915 r
.48943 .33899 .49628 .34626 .50862 .34192 .5018 .3344 Metetra
.67 .752 .912 r
.5018 .3344 .50862 .34192 .521 .33762 .51423 .32993 Metetra
.667 .748 .91 r
.51423 .32993 .521 .33762 .53345 .33333 .52671 .32552 Metetra
.666 .745 .909 r
.52671 .32552 .53345 .33333 .54595 .32903 .53925 .32114 Metetra
.665 .743 .909 r
.53925 .32114 .54595 .32903 .55851 .32473 .55184 .31677 Metetra
.664 .742 .908 r
.55184 .31677 .55851 .32473 .57112 .32041 .5645 .3124 Metetra
.664 .742 .908 r
.5645 .3124 .57112 .32041 .58379 .31607 .57721 .30802 Metetra
.664 .742 .908 r
.57721 .30802 .58379 .31607 .59652 .31171 .58997 .30362 Metetra
.664 .741 .908 r
.58997 .30362 .59652 .31171 .60931 .30734 .6028 .29921 Metetra
.664 .741 .908 r
.6028 .29921 .60931 .30734 .62216 .30294 .61569 .29478 Metetra
.664 .741 .908 r
.61569 .29478 .62216 .30294 .63506 .29853 .62864 .29032 Metetra
.664 .741 .908 r
.62864 .29032 .63506 .29853 .64803 .29409 .64164 .28585 Metetra
.664 .741 .908 r
.64164 .28585 .64803 .29409 .66106 .28964 .65471 .28135 Metetra
.664 .741 .908 r
.65471 .28135 .66106 .28964 .67414 .28516 .66784 .27684 Metetra
.664 .741 .908 r
.66784 .27684 .67414 .28516 .68729 .28066 .68103 .2723 Metetra
.664 .741 .908 r
.68103 .2723 .68729 .28066 .7005 .27614 .69428 .26774 Metetra
.664 .741 .908 r
.69428 .26774 .7005 .27614 .71377 .2716 .70759 .26316 Metetra
.664 .741 .908 r
.70759 .26316 .71377 .2716 .7271 .26704 .72097 .25856 Metetra
.664 .741 .908 r
.72097 .25856 .7271 .26704 .7405 .26246 .73441 .25394 Metetra
.664 .741 .908 r
.73441 .25394 .7405 .26246 .75396 .25785 .74791 .2493 Metetra
.664 .741 .908 r
.74791 .2493 .75396 .25785 .76748 .25323 .76148 .24463 Metetra
.664 .741 .908 r
.76148 .24463 .76748 .25323 .78107 .24858 .77511 .23994 Metetra
.664 .741 .908 r
.77511 .23994 .78107 .24858 .79472 .24391 .78881 .23523 Metetra
.664 .741 .908 r
.78881 .23523 .79472 .24391 .80843 .23922 .80257 .2305 Metetra
.664 .741 .908 r
.80257 .2305 .80843 .23922 .82221 .2345 .8164 .22574 Metetra
.664 .741 .908 r
.8164 .22574 .82221 .2345 .83606 .22977 .83029 .22096 Metetra
.572 .406 .617 r
.20243 .52317 .20613 .5749 .21782 .57064 .21389 .5201 Metetra
.563 .4 .619 r
.21389 .5201 .21782 .57064 .22967 .56516 .22529 .51827 Metetra
.558 .402 .625 r
.22529 .51827 .22967 .56516 .24167 .55831 .23669 .51722 Metetra
.559 .413 .639 r
.23669 .51722 .24167 .55831 .25383 .54988 .24815 .51629 Metetra
.57 .439 .663 r
.24815 .51629 .25383 .54988 .26614 .53971 .25974 .51468 Metetra
.598 .49 .702 r
.25974 .51468 .26614 .53971 .27859 .52775 .2715 .51162 Metetra
.654 .587 .768 r
.2715 .51162 .27859 .52775 .29115 .51409 .28347 .50652 Metetra
.747 .759 .862 r
.28347 .50652 .29115 .51409 .3038 .49902 .29564 .49901 Metetra
.816 .968 .901 r
.29564 .49901 .3038 .49902 .31648 .48299 .30801 .48904 Metetra
.666 .942 .678 r
.30801 .48904 .31648 .48299 .32915 .46652 .32052 .47688 Metetra
.32052 .47688 .32915 .46652 .34177 .45019 .33313 .46302 Metetra
.33313 .46302 .34177 .45019 .35433 .43449 .34578 .44809 Metetra
.34578 .44809 .35433 .43449 .36681 .41985 .35842 .43279 Metetra
.35842 .43279 .36681 .41985 .3792 .40654 .37102 .41776 Metetra
.37102 .41776 .3792 .40654 .39151 .39467 .38356 .40351 Metetra
.38356 .40351 .39151 .39467 .40377 .38427 .39603 .39041 Metetra
.588 .894 .613 r
.39603 .39041 .40377 .38427 .41598 .37521 .40844 .37863 Metetra
.69 .973 .775 r
.40844 .37863 .41598 .37521 .42818 .36735 .4208 .36824 Metetra
.747 .99 .887 r
.4208 .36824 .42818 .36735 .44038 .36047 .43313 .35916 Metetra
.758 .956 .937 r
.43313 .35916 .44038 .36047 .45259 .35436 .44545 .35123 Metetra
.744 .904 .949 r
.44545 .35123 .45259 .35436 .46483 .34886 .45778 .34429 Metetra
.724 .856 .944 r
.45778 .34429 .46483 .34886 .47711 .34378 .47012 .33812 Metetra
.706 .818 .935 r
.47012 .33812 .47711 .34378 .48943 .33899 .4825 .33254 Metetra
.691 .791 .926 r
.4825 .33254 .48943 .33899 .5018 .3344 .49493 .32739 Metetra
.681 .772 .92 r
.49493 .32739 .5018 .3344 .51423 .32993 .50739 .32253 Metetra
.674 .76 .915 r
.50739 .32253 .51423 .32993 .52671 .32552 .51992 .31786 Metetra
.67 .752 .912 r
.51992 .31786 .52671 .32552 .53925 .32114 .53249 .31331 Metetra
.667 .748 .91 r
.53249 .31331 .53925 .32114 .55184 .31677 .54512 .30882 Metetra
.666 .745 .909 r
.54512 .30882 .55184 .31677 .5645 .3124 .55781 .30437 Metetra
.665 .743 .909 r
.55781 .30437 .5645 .3124 .57721 .30802 .57056 .29992 Metetra
.664 .742 .908 r
.57056 .29992 .57721 .30802 .58997 .30362 .58337 .29548 Metetra
.664 .742 .908 r
.58337 .29548 .58997 .30362 .6028 .29921 .59624 .29102 Metetra
.664 .742 .908 r
.59624 .29102 .6028 .29921 .61569 .29478 .60917 .28654 Metetra
.664 .741 .908 r
.60917 .28654 .61569 .29478 .62864 .29032 .62215 .28205 Metetra
.664 .741 .908 r
.62215 .28205 .62864 .29032 .64164 .28585 .6352 .27754 Metetra
.664 .741 .908 r
.6352 .27754 .64164 .28585 .65471 .28135 .64831 .273 Metetra
.664 .741 .908 r
.64831 .273 .65471 .28135 .66784 .27684 .66148 .26845 Metetra
.664 .741 .908 r
.66148 .26845 .66784 .27684 .68103 .2723 .67471 .26387 Metetra
.664 .741 .908 r
.67471 .26387 .68103 .2723 .69428 .26774 .68801 .25927 Metetra
.664 .741 .908 r
.68801 .25927 .69428 .26774 .70759 .26316 .70136 .25465 Metetra
.664 .741 .908 r
.70136 .25465 .70759 .26316 .72097 .25856 .71478 .25001 Metetra
.664 .741 .908 r
.71478 .25001 .72097 .25856 .73441 .25394 .72827 .24535 Metetra
.664 .741 .908 r
.72827 .24535 .73441 .25394 .74791 .2493 .74181 .24066 Metetra
.664 .741 .908 r
.74181 .24066 .74791 .2493 .76148 .24463 .75543 .23596 Metetra
.664 .741 .908 r
.75543 .23596 .76148 .24463 .77511 .23994 .7691 .23123 Metetra
.664 .741 .908 r
.7691 .23123 .77511 .23994 .78881 .23523 .78285 .22647 Metetra
.664 .741 .908 r
.78285 .22647 .78881 .23523 .80257 .2305 .79665 .2217 Metetra
.664 .741 .908 r
.79665 .2217 .80257 .2305 .8164 .22574 .81053 .2169 Metetra
.664 .741 .908 r
.81053 .2169 .8164 .22574 .83029 .22096 .82447 .21208 Metetra
.57 .411 .627 r
.19828 .47757 .20243 .52317 .21389 .5201 .20958 .47505 Metetra
.548 .396 .627 r
.20958 .47505 .21389 .5201 .22529 .51827 .22072 .47499 Metetra
.527 .384 .63 r
.22072 .47499 .22529 .51827 .23669 .51722 .23174 .47697 Metetra
.51 .378 .637 r
.23174 .47697 .23669 .51722 .24815 .51629 .24274 .48033 Metetra
.499 .381 .65 r
.24274 .48033 .24815 .51629 .25974 .51468 .2538 .48419 Metetra
.497 .399 .674 r
.2538 .48419 .25974 .51468 .2715 .51162 .265 .48761 Metetra
.511 .441 .714 r
.265 .48761 .2715 .51162 .28347 .50652 .27641 .48965 Metetra
.548 .524 .781 r
.27641 .48965 .28347 .50652 .29564 .49901 .28807 .4895 Metetra
.623 .682 .885 r
.28807 .4895 .29564 .49901 .30801 .48904 .29999 .48659 Metetra
.702 .91 .968 r
.29999 .48659 .30801 .48904 .32052 .47688 .31217 .48066 Metetra
.602 .942 .768 r
.31217 .48066 .32052 .47688 .33313 .46302 .32457 .47178 Metetra
.32457 .47178 .33313 .46302 .34578 .44809 .33714 .4603 Metetra
.33714 .4603 .34578 .44809 .35842 .43279 .34981 .44683 Metetra
.34981 .44683 .35842 .43279 .37102 .41776 .36253 .43211 Metetra
.36253 .43211 .37102 .41776 .38356 .40351 .37525 .4169 Metetra
.37525 .4169 .38356 .40351 .39603 .39041 .38794 .40187 Metetra
.38794 .40187 .39603 .39041 .40844 .37863 .40057 .38757 Metetra
.40057 .38757 .40844 .37863 .4208 .36824 .41314 .3744 Metetra
.578 .887 .604 r
.41314 .3744 .4208 .36824 .43313 .35916 .42565 .36254 Metetra
.686 .971 .771 r
.42565 .36254 .43313 .35916 .44545 .35123 .43813 .35206 Metetra
.746 .99 .886 r
.43813 .35206 .44545 .35123 .45778 .34429 .45058 .34289 Metetra
.758 .956 .937 r
.45058 .34289 .45778 .34429 .47012 .33812 .46303 .33488 Metetra
.744 .905 .949 r
.46303 .33488 .47012 .33812 .4825 .33254 .47549 .32785 Metetra
.724 .856 .944 r
.47549 .32785 .4825 .33254 .49493 .32739 .48797 .3216 Metetra
.706 .818 .935 r
.48797 .3216 .49493 .32739 .50739 .32253 .50049 .31594 Metetra
.691 .791 .927 r
.50049 .31594 .50739 .32253 .51992 .31786 .51306 .31071 Metetra
.681 .772 .92 r
.51306 .31071 .51992 .31786 .53249 .31331 .52568 .30577 Metetra
.674 .76 .915 r
.52568 .30577 .53249 .31331 .54512 .30882 .53835 .30102 Metetra
.67 .752 .912 r
.53835 .30102 .54512 .30882 .55781 .30437 .55108 .2964 Metetra
.667 .748 .91 r
.55108 .2964 .55781 .30437 .57056 .29992 .56387 .29183 Metetra
.666 .745 .909 r
.56387 .29183 .57056 .29992 .58337 .29548 .57671 .2873 Metetra
.665 .743 .909 r
.57671 .2873 .58337 .29548 .59624 .29102 .58962 .28278 Metetra
.664 .742 .908 r
.58962 .28278 .59624 .29102 .60917 .28654 .60259 .27825 Metetra
.664 .742 .908 r
.60259 .27825 .60917 .28654 .62215 .28205 .61561 .27371 Metetra
.664 .742 .908 r
.61561 .27371 .62215 .28205 .6352 .27754 .6287 .26915 Metetra
.664 .741 .908 r
.6287 .26915 .6352 .27754 .64831 .273 .64185 .26458 Metetra
.664 .741 .908 r
.64185 .26458 .64831 .273 .66148 .26845 .65506 .25998 Metetra
.664 .741 .908 r
.65506 .25998 .66148 .26845 .67471 .26387 .66834 .25537 Metetra
.664 .741 .908 r
.66834 .25537 .67471 .26387 .68801 .25927 .68168 .25073 Metetra
.664 .741 .908 r
.68168 .25073 .68801 .25927 .70136 .25465 .69508 .24607 Metetra
.664 .741 .908 r
.69508 .24607 .70136 .25465 .71478 .25001 .70854 .24139 Metetra
.664 .741 .908 r
.70854 .24139 .71478 .25001 .72827 .24535 .72207 .23668 Metetra
.664 .741 .908 r
.72207 .23668 .72827 .24535 .74181 .24066 .73566 .23196 Metetra
.664 .741 .908 r
.73566 .23196 .74181 .24066 .75543 .23596 .74932 .22721 Metetra
.664 .741 .908 r
.74932 .22721 .75543 .23596 .7691 .23123 .76304 .22243 Metetra
.664 .741 .908 r
.76304 .22243 .7691 .23123 .78285 .22647 .77683 .21764 Metetra
.664 .741 .908 r
.77683 .21764 .78285 .22647 .79665 .2217 .79069 .21282 Metetra
.664 .741 .908 r
.79069 .21282 .79665 .2217 .81053 .2169 .80461 .20798 Metetra
.664 .741 .908 r
.80461 .20798 .81053 .2169 .82447 .21208 .8186 .20312 Metetra
.578 .438 .654 r
.19317 .44269 .19828 .47757 .20958 .47505 .20441 .4401 Metetra
.548 .417 .654 r
.20441 .4401 .20958 .47505 .22072 .47499 .21547 .44005 Metetra
.518 .396 .653 r
.21547 .44005 .22072 .47499 .23174 .47697 .22639 .44231 Metetra
.49 .377 .653 r
.22639 .44231 .23174 .47697 .24274 .48033 .23723 .44649 Metetra
.467 .364 .655 r
.23723 .44649 .24274 .48033 .2538 .48419 .24806 .45203 Metetra
.451 .36 .662 r
.24806 .45203 .2538 .48419 .265 .48761 .25896 .45822 Metetra
.444 .367 .676 r
.25896 .45822 .265 .48761 .27641 .48965 .26999 .46426 Metetra
.449 .393 .703 r
.26999 .46426 .27641 .48965 .28807 .4895 .28122 .46926 Metetra
.471 .446 .748 r
.28122 .46926 .28807 .4895 .29999 .48659 .2927 .4724 Metetra
.518 .546 .824 r
.2927 .4724 .29999 .48659 .31217 .48066 .30446 .47298 Metetra
.599 .724 .932 r
.30446 .47298 .31217 .48066 .32457 .47178 .3165 .47052 Metetra
.656 .935 .968 r
.3165 .47052 .32457 .47178 .33714 .4603 .32879 .46483 Metetra
.524 .895 .7 r
.32879 .46483 .33714 .4603 .34981 .44683 .3413 .45604 Metetra
.3413 .45604 .34981 .44683 .36253 .43211 .35397 .44458 Metetra
.35397 .44458 .36253 .43211 .37525 .4169 .36674 .43107 Metetra
.36674 .43107 .37525 .4169 .38794 .40187 .37956 .41627 Metetra
.37956 .41627 .38794 .40187 .40057 .38757 .39237 .40096 Metetra
.39237 .40096 .40057 .38757 .41314 .3744 .40515 .38582 Metetra
.40515 .38582 .41314 .3744 .42565 .36254 .41788 .37142 Metetra
.41788 .37142 .42565 .36254 .43813 .35206 .43055 .35814 Metetra
.576 .886 .602 r
.43055 .35814 .43813 .35206 .45058 .34289 .44317 .34618 Metetra
.685 .971 .77 r
.44317 .34618 .45058 .34289 .46303 .33488 .45576 .33559 Metetra
.745 .99 .885 r
.45576 .33559 .46303 .33488 .47549 .32785 .46834 .32633 Metetra
.757 .956 .937 r
.46834 .32633 .47549 .32785 .48797 .3216 .48091 .31823 Metetra
.744 .905 .949 r
.48091 .31823 .48797 .3216 .50049 .31594 .49351 .31112 Metetra
.724 .856 .944 r
.49351 .31112 .50049 .31594 .51306 .31071 .50613 .30479 Metetra
.706 .818 .935 r
.50613 .30479 .51306 .31071 .52568 .30577 .5188 .29905 Metetra
.691 .791 .927 r
.5188 .29905 .52568 .30577 .53835 .30102 .53152 .29374 Metetra
.681 .773 .92 r
.53152 .29374 .53835 .30102 .55108 .2964 .54429 .28872 Metetra
.674 .76 .915 r
.54429 .28872 .55108 .2964 .56387 .29183 .55711 .28389 Metetra
.67 .752 .912 r
.55711 .28389 .56387 .29183 .57671 .2873 .57 .27918 Metetra
.667 .748 .91 r
.57 .27918 .57671 .2873 .58962 .28278 .58294 .27454 Metetra
.666 .745 .909 r
.58294 .27454 .58962 .28278 .60259 .27825 .59595 .26992 Metetra
.665 .743 .909 r
.59595 .26992 .60259 .27825 .61561 .27371 .60902 .26532 Metetra
.664 .742 .908 r
.60902 .26532 .61561 .27371 .6287 .26915 .62215 .26071 Metetra
.664 .742 .908 r
.62215 .26071 .6287 .26915 .64185 .26458 .63534 .25609 Metetra
.664 .742 .908 r
.63534 .25609 .64185 .26458 .65506 .25998 .64859 .25145 Metetra
.664 .741 .908 r
.64859 .25145 .65506 .25998 .66834 .25537 .66191 .24679 Metetra
.664 .741 .908 r
.66191 .24679 .66834 .25537 .68168 .25073 .67529 .24211 Metetra
.664 .741 .908 r
.67529 .24211 .68168 .25073 .69508 .24607 .68874 .23741 Metetra
.664 .741 .908 r
.68874 .23741 .69508 .24607 .70854 .24139 .70224 .23268 Metetra
.664 .741 .908 r
.70224 .23268 .70854 .24139 .72207 .23668 .71582 .22794 Metetra
.664 .741 .908 r
.71582 .22794 .72207 .23668 .73566 .23196 .72945 .22317 Metetra
.664 .741 .908 r
.72945 .22317 .73566 .23196 .74932 .22721 .74316 .21838 Metetra
.664 .741 .908 r
.74316 .21838 .74932 .22721 .76304 .22243 .75693 .21356 Metetra
.664 .741 .908 r
.75693 .21356 .76304 .22243 .77683 .21764 .77076 .20873 Metetra
.664 .741 .908 r
.77076 .20873 .77683 .21764 .79069 .21282 .78467 .20387 Metetra
.664 .741 .908 r
.78467 .20387 .79069 .21282 .80461 .20798 .79864 .19898 Metetra
.664 .741 .908 r
.79864 .19898 .80461 .20798 .8186 .20312 .81267 .19407 Metetra
.595 .488 .702 r
.18704 .41832 .19317 .44269 .20441 .4401 .19828 .41536 Metetra
.564 .467 .702 r
.19828 .41536 .20441 .4401 .21547 .44005 .20939 .41434 Metetra
.531 .44 .698 r
.20939 .41434 .21547 .44005 .22639 .44231 .22039 .41524 Metetra
.499 .413 .689 r
.22039 .41524 .22639 .44231 .23723 .44649 .2313 .41796 Metetra
.47 .387 .68 r
.2313 .41796 .23723 .44649 .24806 .45203 .24216 .42233 Metetra
.448 .367 .673 r
.24216 .42233 .24806 .45203 .25896 .45822 .25303 .42805 Metetra
.432 .355 .67 r
.25303 .42805 .25896 .45822 .26999 .46426 .26393 .43468 Metetra
.424 .353 .673 r
.26393 .43468 .26999 .46426 .28122 .46926 .27495 .4416 Metetra
.424 .364 .686 r
.27495 .4416 .28122 .46926 .2927 .4724 .28612 .4481 Metetra
.435 .392 .712 r
.28612 .4481 .2927 .4724 .30446 .47298 .29751 .45339 Metetra
.461 .448 .757 r
.29751 .45339 .30446 .47298 .3165 .47052 .30915 .45668 Metetra
.512 .551 .832 r
.30915 .45668 .3165 .47052 .32879 .46483 .32106 .45732 Metetra
.595 .731 .939 r
.32106 .45732 .32879 .46483 .3413 .45604 .33325 .45486 Metetra
.648 .937 .966 r
.33325 .45486 .3413 .45604 .35397 .44458 .34568 .44913 Metetra
.516 .889 .693 r
.34568 .44913 .35397 .44458 .36674 .43107 .35831 .44026 Metetra
.35831 .44026 .36674 .43107 .37956 .41627 .3711 .4287 Metetra
.3711 .4287 .37956 .41627 .39237 .40096 .38398 .41509 Metetra
.38398 .41509 .39237 .40096 .40515 .38582 .39689 .40018 Metetra
.39689 .40018 .40515 .38582 .41788 .37142 .40979 .38475 Metetra
.40979 .38475 .41788 .37142 .43055 .35814 .42267 .3695 Metetra
.42267 .3695 .43055 .35814 .44317 .34618 .43549 .35499 Metetra
.43549 .35499 .44317 .34618 .45576 .33559 .44827 .34159 Metetra
.575 .885 .601 r
.44827 .34159 .45576 .33559 .46834 .32633 .461 .32952 Metetra
.684 .97 .769 r
.461 .32952 .46834 .32633 .48091 .31823 .47371 .31884 Metetra
.745 .99 .885 r
.47371 .31884 .48091 .31823 .49351 .31112 .48641 .30948 Metetra
.757 .957 .937 r
.48641 .30948 .49351 .31112 .50613 .30479 .49912 .30129 Metetra
.744 .905 .949 r
.49912 .30129 .50613 .30479 .5188 .29905 .51185 .29409 Metetra
.724 .856 .944 r
.51185 .29409 .5188 .29905 .53152 .29374 .52462 .28768 Metetra
.706 .818 .935 r
.52462 .28768 .53152 .29374 .54429 .28872 .53744 .28185 Metetra
.691 .791 .927 r
.53744 .28185 .54429 .28872 .55711 .28389 .5503 .27646 Metetra
.681 .773 .92 r
.5503 .27646 .55711 .28389 .57 .27918 .56323 .27135 Metetra
.674 .76 .915 r
.56323 .27135 .57 .27918 .58294 .27454 .57621 .26645 Metetra
.67 .752 .912 r
.57621 .26645 .58294 .27454 .59595 .26992 .58926 .26165 Metetra
.667 .748 .91 r
.58926 .26165 .59595 .26992 .60902 .26532 .60237 .25693 Metetra
.666 .745 .909 r
.60237 .25693 .60902 .26532 .62215 .26071 .61554 .25223 Metetra
.665 .743 .909 r
.61554 .25223 .62215 .26071 .63534 .25609 .62877 .24754 Metetra
.664 .742 .908 r
.62877 .24754 .63534 .25609 .64859 .25145 .64207 .24285 Metetra
.664 .742 .908 r
.64207 .24285 .64859 .25145 .66191 .24679 .65543 .23814 Metetra
.664 .742 .908 r
.65543 .23814 .66191 .24679 .67529 .24211 .66885 .23342 Metetra
.664 .741 .908 r
.66885 .23342 .67529 .24211 .68874 .23741 .68234 .22867 Metetra
.664 .741 .908 r
.68234 .22867 .68874 .23741 .70224 .23268 .69589 .22391 Metetra
.664 .741 .908 r
.69589 .22391 .70224 .23268 .71582 .22794 .70951 .21912 Metetra
.664 .741 .908 r
.70951 .21912 .71582 .22794 .72945 .22317 .72319 .21431 Metetra
.664 .741 .908 r
.72319 .21431 .72945 .22317 .74316 .21838 .73694 .20947 Metetra
.664 .741 .908 r
.73694 .20947 .74316 .21838 .75693 .21356 .75076 .20461 Metetra
.664 .741 .908 r
.75076 .20461 .75693 .21356 .77076 .20873 .76464 .19973 Metetra
.664 .741 .908 r
.76464 .19973 .77076 .20873 .78467 .20387 .77859 .19483 Metetra
.664 .741 .908 r
.77859 .19483 .78467 .20387 .79864 .19898 .79261 .1899 Metetra
.664 .741 .908 r
.79261 .1899 .79864 .19898 .81267 .19407 .8067 .18495 Metetra
.62 .562 .767 r
.18009 .40183 .18704 .41832 .19828 .41536 .19137 .39844 Metetra
.594 .544 .768 r
.19137 .39844 .19828 .41536 .20939 .41434 .20258 .39626 Metetra
.564 .516 .76 r
.20258 .39626 .20939 .41434 .22039 .41524 .21372 .39537 Metetra
.532 .481 .745 r
.21372 .39537 .22039 .41524 .2313 .41796 .22481 .39586 Metetra
.502 .446 .726 r
.22481 .39586 .2313 .41796 .24216 .42233 .23585 .3978 Metetra
.476 .413 .707 r
.23585 .3978 .24216 .42233 .25303 .42805 .24685 .40122 Metetra
.453 .385 .691 r
.24685 .40122 .25303 .42805 .26393 .43468 .25784 .40604 Metetra
.436 .365 .679 r
.25784 .40604 .26393 .43468 .27495 .4416 .26885 .41204 Metetra
.424 .354 .674 r
.26885 .41204 .27495 .4416 .28612 .4481 .27993 .41882 Metetra
.419 .352 .676 r
.27993 .41882 .28612 .4481 .29751 .45339 .29112 .42583 Metetra
.421 .363 .688 r
.29112 .42583 .29751 .45339 .30915 .45668 .30248 .43236 Metetra
.433 .392 .713 r
.30248 .43236 .30915 .45668 .32106 .45732 .31405 .43765 Metetra
.46 .448 .758 r
.31405 .43765 .32106 .45732 .33325 .45486 .32587 .44092 Metetra
.512 .552 .833 r
.32587 .44092 .33325 .45486 .34568 .44913 .33795 .44152 Metetra
.595 .732 .94 r
.33795 .44152 .34568 .44913 .35831 .44026 .35029 .43899 Metetra
.649 .937 .966 r
.35029 .43899 .35831 .44026 .3711 .4287 .36287 .43318 Metetra
.517 .89 .694 r
.36287 .43318 .3711 .4287 .38398 .41509 .37564 .42422 Metetra
.37564 .42422 .38398 .41509 .39689 .40018 .38854 .41256 Metetra
.38854 .41256 .39689 .40018 .40979 .38475 .40152 .39883 Metetra
.40152 .39883 .40979 .38475 .42267 .3695 .41453 .38381 Metetra
.41453 .38381 .42267 .3695 .43549 .35499 .42753 .36826 Metetra
.42753 .36826 .43549 .35499 .44827 .34159 .4405 .35289 Metetra
.4405 .35289 .44827 .34159 .461 .32952 .45342 .33825 Metetra
.45342 .33825 .461 .32952 .47371 .31884 .4663 .32474 Metetra
.574 .884 .6 r
.4663 .32474 .47371 .31884 .48641 .30948 .47915 .31257 Metetra
.684 .97 .769 r
.47915 .31257 .48641 .30948 .49912 .30129 .49198 .30178 Metetra
.745 .99 .885 r
.49198 .30178 .49912 .30129 .51185 .29409 .50481 .29233 Metetra
.757 .957 .937 r
.50481 .29233 .51185 .29409 .52462 .28768 .51765 .28405 Metetra
.744 .905 .949 r
.51765 .28405 .52462 .28768 .53744 .28185 .53052 .27676 Metetra
.724 .856 .944 r
.53052 .27676 .53744 .28185 .5503 .27646 .54344 .27025 Metetra
.706 .819 .935 r
.54344 .27025 .5503 .27646 .56323 .27135 .55641 .26434 Metetra
.691 .791 .927 r
.55641 .26434 .56323 .27135 .57621 .26645 .56943 .25886 Metetra
.681 .773 .92 r
.56943 .25886 .57621 .26645 .58926 .26165 .58252 .25368 Metetra
.674 .76 .915 r
.58252 .25368 .58926 .26165 .60237 .25693 .59566 .24868 Metetra
.67 .752 .912 r
.59566 .24868 .60237 .25693 .61554 .25223 .60887 .24381 Metetra
.667 .748 .91 r
.60887 .24381 .61554 .25223 .62877 .24754 .62215 .23899 Metetra
.666 .745 .909 r
.62215 .23899 .62877 .24754 .64207 .24285 .63549 .23421 Metetra
.665 .743 .909 r
.63549 .23421 .64207 .24285 .65543 .23814 .64889 .22944 Metetra
.664 .742 .908 r
.64889 .22944 .65543 .23814 .66885 .23342 .66235 .22466 Metetra
.664 .742 .908 r
.66235 .22466 .66885 .23342 .68234 .22867 .67589 .21986 Metetra
.664 .742 .908 r
.67589 .21986 .68234 .22867 .69589 .22391 .68948 .21505 Metetra
.664 .741 .908 r
.68948 .21505 .69589 .22391 .70951 .21912 .70315 .21022 Metetra
.664 .741 .908 r
.70315 .21022 .70951 .21912 .72319 .21431 .71687 .20536 Metetra
.664 .741 .908 r
.71687 .20536 .72319 .21431 .73694 .20947 .73067 .20049 Metetra
.664 .741 .908 r
.73067 .20049 .73694 .20947 .75076 .20461 .74453 .19559 Metetra
.664 .741 .908 r
.74453 .19559 .75076 .20461 .76464 .19973 .75846 .19066 Metetra
.664 .741 .908 r
.75846 .19066 .76464 .19973 .77859 .19483 .77246 .18571 Metetra
.664 .741 .908 r
.77246 .18571 .77859 .19483 .79261 .1899 .78653 .18074 Metetra
.664 .741 .908 r
.78653 .18074 .79261 .1899 .8067 .18495 .80066 .17574 Metetra
.643 .639 .831 r
.1726 .39014 .18009 .40183 .19137 .39844 .18392 .38642 Metetra
.625 .627 .832 r
.18392 .38642 .19137 .39844 .20258 .39626 .19522 .38333 Metetra
.603 .602 .823 r
.19522 .38333 .20258 .39626 .21372 .39537 .20651 .38097 Metetra
.578 .568 .806 r
.20651 .38097 .21372 .39537 .22481 .39586 .21778 .37947 Metetra
.551 .529 .784 r
.21778 .37947 .22481 .39586 .23585 .3978 .22902 .379 Metetra
.523 .487 .758 r
.22902 .379 .23585 .3978 .24685 .40122 .24023 .37973 Metetra
.496 .448 .733 r
.24023 .37973 .24685 .40122 .25784 .40604 .25141 .38181 Metetra
.471 .413 .711 r
.25141 .38181 .25784 .40604 .26885 .41204 .26257 .3853 Metetra
.451 .385 .693 r
.26257 .3853 .26885 .41204 .27993 .41882 .27373 .39014 Metetra
.435 .365 .68 r
.27373 .39014 .27993 .41882 .29112 .42583 .28492 .39614 Metetra
.424 .354 .674 r
.28492 .39614 .29112 .42583 .30248 .43236 .29619 .40291 Metetra
.418 .352 .676 r
.29619 .40291 .30248 .43236 .31405 .43765 .30757 .4099 Metetra
.421 .363 .688 r
.30757 .4099 .31405 .43765 .32587 .44092 .31912 .41641 Metetra
.433 .392 .713 r
.31912 .41641 .32587 .44092 .33795 .44152 .33089 .42167 Metetra
.461 .448 .758 r
.33089 .42167 .33795 .44152 .35029 .43899 .34289 .4249 Metetra
.512 .552 .833 r
.34289 .4249 .35029 .43899 .36287 .43318 .35515 .42543 Metetra
.595 .732 .939 r
.35515 .42543 .36287 .43318 .37564 .42422 .36765 .42283 Metetra
.65 .937 .966 r
.36765 .42283 .37564 .42422 .38854 .41256 .38037 .41694 Metetra
.519 .891 .696 r
.38037 .41694 .38854 .41256 .40152 .39883 .39327 .40789 Metetra
.39327 .40789 .40152 .39883 .41453 .38381 .40629 .39612 Metetra
.40629 .39612 .41453 .38381 .42753 .36826 .41938 .38229 Metetra
.41938 .38229 .42753 .36826 .4405 .35289 .43249 .36715 Metetra
.43249 .36715 .4405 .35289 .45342 .33825 .44559 .35147 Metetra
.44559 .35147 .45342 .33825 .4663 .32474 .45866 .33597 Metetra
.45866 .33597 .4663 .32474 .47915 .31257 .47168 .32121 Metetra
.47168 .32121 .47915 .31257 .49198 .30178 .48467 .30759 Metetra
.574 .884 .599 r
.48467 .30759 .49198 .30178 .50481 .29233 .49763 .29531 Metetra
.683 .97 .768 r
.49763 .29531 .50481 .29233 .51765 .28405 .51058 .28442 Metetra
.744 .99 .885 r
.51058 .28442 .51765 .28405 .53052 .27676 .52354 .27486 Metetra
.757 .957 .937 r
.52354 .27486 .53052 .27676 .54344 .27025 .53652 .26649 Metetra
.744 .905 .949 r
.53652 .26649 .54344 .27025 .55641 .26434 .54954 .25911 Metetra
.724 .857 .944 r
.54954 .25911 .55641 .26434 .56943 .25886 .56261 .25251 Metetra
.705 .819 .935 r
.56261 .25251 .56943 .25886 .58252 .25368 .57573 .24652 Metetra
.691 .791 .927 r
.57573 .24652 .58252 .25368 .59566 .24868 .58891 .24095 Metetra
.681 .773 .92 r
.58891 .24095 .59566 .24868 .60887 .24381 .60216 .23567 Metetra
.674 .76 .915 r
.60216 .23567 .60887 .24381 .62215 .23899 .61547 .23059 Metetra
.67 .752 .912 r
.61547 .23059 .62215 .23899 .63549 .23421 .62885 .22563 Metetra
.667 .748 .91 r
.62885 .22563 .63549 .23421 .64889 .22944 .64229 .22073 Metetra
.666 .745 .909 r
.64229 .22073 .64889 .22944 .66235 .22466 .6558 .21586 Metetra
.665 .743 .909 r
.6558 .21586 .66235 .22466 .67589 .21986 .66938 .211 Metetra
.664 .742 .908 r
.66938 .211 .67589 .21986 .68948 .21505 .68302 .20613 Metetra
.664 .742 .908 r
.68302 .20613 .68948 .21505 .70315 .21022 .69673 .20125 Metetra
.664 .742 .908 r
.69673 .20125 .70315 .21022 .71687 .20536 .7105 .19635 Metetra
.664 .741 .908 r
.7105 .19635 .71687 .20536 .73067 .20049 .72434 .19142 Metetra
.664 .741 .908 r
.72434 .19142 .73067 .20049 .74453 .19559 .73825 .18647 Metetra
.664 .741 .908 r
.73825 .18647 .74453 .19559 .75846 .19066 .75223 .1815 Metetra
.664 .741 .908 r
.75223 .1815 .75846 .19066 .77246 .18571 .76628 .17651 Metetra
.664 .741 .908 r
.76628 .17651 .77246 .18571 .78653 .18074 .78039 .17149 Metetra
.664 .741 .908 r
.78039 .17149 .78653 .18074 .80066 .17574 .79458 .16645 Metetra
.655 .695 .875 r
.16477 .38093 .1726 .39014 .18392 .38642 .17614 .377 Metetra
.646 .688 .875 r
.17614 .377 .18392 .38642 .19522 .38333 .18752 .37334 Metetra
.634 .672 .868 r
.18752 .37334 .19522 .38333 .20651 .38097 .19892 .37003 Metetra
.619 .647 .856 r
.19892 .37003 .20651 .38097 .21778 .37947 .21033 .36718 Metetra
.599 .614 .838 r
.21033 .36718 .21778 .37947 .22902 .379 .22174 .36493 Metetra
.575 .574 .814 r
.22174 .36493 .22902 .379 .24023 .37973 .23314 .36348 Metetra
.549 .531 .788 r
.23314 .36348 .24023 .37973 .25141 .38181 .24452 .36301 Metetra
.521 .488 .76 r
.24452 .36301 .25141 .38181 .26257 .3853 .25589 .36372 Metetra
.495 .448 .734 r
.25589 .36372 .26257 .3853 .27373 .39014 .26723 .36577 Metetra
.471 .413 .711 r
.26723 .36577 .27373 .39014 .28492 .39614 .27856 .36922 Metetra
.45 .385 .693 r
.27856 .36922 .28492 .39614 .29619 .40291 .2899 .37403 Metetra
.434 .365 .68 r
.2899 .37403 .29619 .40291 .30757 .4099 .30128 .37999 Metetra
.423 .354 .674 r
.30128 .37999 .30757 .4099 .31912 .41641 .31274 .38673 Metetra
.418 .352 .676 r
.31274 .38673 .31912 .41641 .33089 .42167 .32432 .39369 Metetra
.421 .363 .688 r
.32432 .39369 .33089 .42167 .34289 .4249 .33607 .40017 Metetra
.433 .392 .713 r
.33607 .40017 .34289 .4249 .35515 .42543 .34803 .40539 Metetra
.461 .448 .758 r
.34803 .40539 .35515 .42543 .36765 .42283 .36022 .40857 Metetra
.513 .552 .833 r
.36022 .40857 .36765 .42283 .38037 .41694 .37266 .40905 Metetra
.596 .731 .939 r
.37266 .40905 .38037 .41694 .39327 .40789 .38533 .40638 Metetra
.651 .937 .967 r
.38533 .40638 .39327 .40789 .40629 .39612 .3982 .4004 Metetra
.521 .893 .698 r
.3982 .4004 .40629 .39612 .41938 .38229 .41123 .39126 Metetra
.41123 .39126 .41938 .38229 .43249 .36715 .42437 .37939 Metetra
.42437 .37939 .43249 .36715 .44559 .35147 .43757 .36543 Metetra
.43757 .36543 .44559 .35147 .45866 .33597 .45078 .35016 Metetra
.45078 .35016 .45866 .33597 .47168 .32121 .46398 .33436 Metetra
.46398 .33436 .47168 .32121 .48467 .30759 .47715 .31874 Metetra
.47715 .31874 .48467 .30759 .49763 .29531 .49027 .30386 Metetra
.49027 .30386 .49763 .29531 .51058 .28442 .50337 .29012 Metetra
.573 .883 .599 r
.50337 .29012 .51058 .28442 .52354 .27486 .51644 .27773 Metetra
.682 .969 .767 r
.51644 .27773 .52354 .27486 .53652 .26649 .52952 .26674 Metetra
.744 .99 .884 r
.52952 .26674 .53652 .26649 .54954 .25911 .54261 .25708 Metetra
.757 .957 .937 r
.54261 .25708 .54954 .25911 .56261 .25251 .55573 .24861 Metetra
.744 .905 .949 r
.55573 .24861 .56261 .25251 .57573 .24652 .5689 .24114 Metetra
.724 .857 .944 r
.5689 .24114 .57573 .24652 .58891 .24095 .58212 .23445 Metetra
.706 .819 .935 r
.58212 .23445 .58891 .24095 .60216 .23567 .5954 .22836 Metetra
.691 .791 .927 r
.5954 .22836 .60216 .23567 .61547 .23059 .60875 .2227 Metetra
.681 .773 .92 r
.60875 .2227 .61547 .23059 .62885 .22563 .62216 .21734 Metetra
.674 .76 .915 r
.62216 .21734 .62885 .22563 .64229 .22073 .63565 .21217 Metetra
.67 .752 .912 r
.63565 .21217 .64229 .22073 .6558 .21586 .6492 .20712 Metetra
.667 .748 .91 r
.6492 .20712 .6558 .21586 .66938 .211 .66281 .20213 Metetra
.666 .745 .909 r
.66281 .20213 .66938 .211 .68302 .20613 .6765 .19717 Metetra
.665 .743 .909 r
.6765 .19717 .68302 .20613 .69673 .20125 .69025 .19222 Metetra
.664 .742 .908 r
.69025 .19222 .69673 .20125 .7105 .19635 .70407 .18725 Metetra
.664 .742 .908 r
.70407 .18725 .7105 .19635 .72434 .19142 .71796 .18228 Metetra
.664 .742 .908 r
.71796 .18228 .72434 .19142 .73825 .18647 .73191 .17728 Metetra
.664 .741 .908 r
.73191 .17728 .73825 .18647 .75223 .1815 .74594 .17227 Metetra
.664 .741 .908 r
.74594 .17227 .75223 .1815 .76628 .17651 .76003 .16723 Metetra
.664 .741 .908 r
.76003 .16723 .76628 .17651 .78039 .17149 .7742 .16216 Metetra
.664 .741 .908 r
.7742 .16216 .78039 .17149 .79458 .16645 .78843 .15707 Metetra
.661 .724 .896 r
.15677 .37277 .16477 .38093 .17614 .377 .16816 .36872 Metetra
.657 .721 .896 r
.16816 .36872 .17614 .377 .18752 .37334 .1796 .36477 Metetra
.652 .712 .892 r
.1796 .36477 .18752 .37334 .19892 .37003 .19107 .36095 Metetra
.644 .698 .886 r
.19107 .36095 .19892 .37003 .21033 .36718 .20258 .35734 Metetra
.633 .678 .875 r
.20258 .35734 .21033 .36718 .22174 .36493 .21411 .35402 Metetra
.618 .65 .859 r
.21411 .35402 .22174 .36493 .23314 .36348 .22565 .35113 Metetra
.598 .615 .84 r
.22565 .35113 .23314 .36348 .24452 .36301 .2372 .34884 Metetra
.575 .575 .815 r
.2372 .34884 .24452 .36301 .25589 .36372 .24875 .34733 Metetra
.549 .531 .788 r
.24875 .34733 .25589 .36372 .26723 .36577 .26029 .34681 Metetra
.521 .488 .76 r
.26029 .34681 .26723 .36577 .27856 .36922 .27181 .34747 Metetra
.495 .448 .734 r
.27181 .34747 .27856 .36922 .2899 .37403 .28332 .34946 Metetra
.471 .413 .711 r
.28332 .34946 .2899 .37403 .30128 .37999 .29483 .35286 Metetra
.45 .385 .693 r
.29483 .35286 .30128 .37999 .31274 .38673 .30635 .35763 Metetra
.434 .365 .68 r
.30635 .35763 .31274 .38673 .32432 .39369 .31792 .36356 Metetra
.423 .353 .674 r
.31792 .36356 .32432 .39369 .33607 .40017 .32958 .37026 Metetra
.419 .352 .676 r
.32958 .37026 .33607 .40017 .34803 .40539 .34137 .37719 Metetra
.421 .363 .688 r
.34137 .37719 .34803 .40539 .36022 .40857 .35333 .38364 Metetra
.434 .392 .713 r
.35333 .38364 .36022 .40857 .37266 .40905 .36549 .38881 Metetra
.462 .449 .758 r
.36549 .38881 .37266 .40905 .38533 .40638 .37787 .39194 Metetra
.513 .552 .833 r
.37787 .39194 .38533 .40638 .3982 .4004 .39049 .39236 Metetra
.596 .731 .938 r
.39049 .39236 .3982 .4004 .41123 .39126 .40333 .38962 Metetra
.652 .936 .967 r
.40333 .38962 .41123 .39126 .42437 .37939 .41636 .38356 Metetra
.523 .894 .701 r
.41636 .38356 .42437 .37939 .43757 .36543 .42953 .37432 Metetra
.42953 .37432 .43757 .36543 .45078 .35016 .44279 .36234 Metetra
.44279 .36234 .45078 .35016 .46398 .33436 .4561 .34826 Metetra
.4561 .34826 .46398 .33436 .47715 .31874 .46942 .33287 Metetra
.46942 .33287 .47715 .31874 .49027 .30386 .48271 .31694 Metetra
.48271 .31694 .49027 .30386 .50337 .29012 .49598 .30119 Metetra
.49598 .30119 .50337 .29012 .51644 .27773 .50921 .28619 Metetra
.50921 .28619 .51644 .27773 .52952 .26674 .52241 .27233 Metetra
.572 .882 .598 r
.52241 .27233 .52952 .26674 .54261 .25708 .53561 .25983 Metetra
.682 .969 .767 r
.53561 .25983 .54261 .25708 .55573 .24861 .54881 .24873 Metetra
.744 .99 .884 r
.54881 .24873 .55573 .24861 .5689 .24114 .56204 .23897 Metetra
.757 .957 .937 r
.56204 .23897 .5689 .24114 .58212 .23445 .5753 .2304 Metetra
.744 .905 .949 r
.5753 .2304 .58212 .23445 .5954 .22836 .58862 .22283 Metetra
.724 .857 .944 r
.58862 .22283 .5954 .22836 .60875 .2227 .602 .21604 Metetra
.705 .819 .935 r
.602 .21604 .60875 .2227 .62216 .21734 .61544 .20986 Metetra
.691 .791 .927 r
.61544 .20986 .62216 .21734 .63565 .21217 .62896 .20411 Metetra
.681 .773 .92 r
.62896 .20411 .63565 .21217 .6492 .20712 .64254 .19866 Metetra
.674 .76 .915 r
.64254 .19866 .6492 .20712 .66281 .20213 .6562 .1934 Metetra
.67 .752 .912 r
.6562 .1934 .66281 .20213 .6765 .19717 .66992 .18826 Metetra
.667 .748 .91 r
.66992 .18826 .6765 .19717 .69025 .19222 .68372 .18318 Metetra
.666 .745 .909 r
.68372 .18318 .69025 .19222 .70407 .18725 .69758 .17812 Metetra
.665 .743 .909 r
.69758 .17812 .70407 .18725 .71796 .18228 .71152 .17308 Metetra
.664 .742 .908 r
.71152 .17308 .71796 .18228 .73191 .17728 .72552 .16802 Metetra
.664 .742 .908 r
.72552 .16802 .73191 .17728 .74594 .17227 .73959 .16295 Metetra
.664 .742 .908 r
.73959 .16295 .74594 .17227 .76003 .16723 .75374 .15786 Metetra
.664 .741 .908 r
.75374 .15786 .76003 .16723 .7742 .16216 .76795 .15275 Metetra
.664 .741 .908 r
.76795 .15275 .7742 .16216 .78843 .15707 .78223 .14761 Metetra
.663 .736 .904 r
.14864 .36499 .15677 .37277 .16816 .36872 .16007 .36087 Metetra
.661 .734 .904 r
.16007 .36087 .16816 .36872 .1796 .36477 .17155 .35677 Metetra
.659 .731 .902 r
.17155 .35677 .1796 .36477 .19107 .36095 .18307 .35272 Metetra
.656 .725 .899 r
.18307 .35272 .19107 .36095 .20258 .35734 .19464 .34873 Metetra
.651 .715 .894 r
.19464 .34873 .20258 .35734 .21411 .35402 .20624 .34486 Metetra
.644 .7 .887 r
.20624 .34486 .21411 .35402 .22565 .35113 .21788 .34118 Metetra
.633 .678 .875 r
.21788 .34118 .22565 .35113 .2372 .34884 .22955 .3378 Metetra
.618 .65 .86 r
.22955 .3378 .2372 .34884 .24875 .34733 .24124 .33484 Metetra
.598 .615 .84 r
.24124 .33484 .24875 .34733 .26029 .34681 .25294 .33248 Metetra
.575 .575 .815 r
.25294 .33248 .26029 .34681 .27181 .34747 .26464 .33091 Metetra
.548 .531 .788 r
.26464 .33091 .27181 .34747 .28332 .34946 .27633 .33032 Metetra
.521 .488 .76 r
.27633 .33032 .28332 .34946 .29483 .35286 .28802 .33092 Metetra
.494 .448 .734 r
.28802 .33092 .29483 .35286 .30635 .35763 .2997 .33286 Metetra
.47 .413 .711 r
.2997 .33286 .30635 .35763 .31792 .36356 .31138 .33622 Metetra
.45 .385 .693 r
.31138 .33622 .31792 .36356 .32958 .37026 .3231 .34094 Metetra
.434 .365 .68 r
.3231 .34094 .32958 .37026 .34137 .37719 .33487 .34683 Metetra
.423 .353 .674 r
.33487 .34683 .34137 .37719 .35333 .38364 .34673 .3535 Metetra
.419 .352 .676 r
.34673 .3535 .35333 .38364 .36549 .38881 .35873 .36038 Metetra
.421 .364 .688 r
.35873 .36038 .36549 .38881 .37787 .39194 .3709 .36679 Metetra
.434 .393 .713 r
.3709 .36679 .37787 .39194 .39049 .39236 .38326 .37192 Metetra
.462 .449 .758 r
.38326 .37192 .39049 .39236 .40333 .38962 .39585 .37499 Metetra
.514 .552 .832 r
.39585 .37499 .40333 .38962 .41636 .38356 .40866 .37535 Metetra
.596 .73 .938 r
.40866 .37535 .41636 .38356 .42953 .37432 .42167 .37255 Metetra
.653 .936 .967 r
.42167 .37255 .42953 .37432 .44279 .36234 .43485 .3664 Metetra
.525 .896 .702 r
.43485 .3664 .44279 .36234 .4561 .34826 .44816 .35706 Metetra
.44816 .35706 .4561 .34826 .46942 .33287 .46155 .34497 Metetra
.46155 .34497 .46942 .33287 .48271 .31694 .47497 .33077 Metetra
.47497 .33077 .48271 .31694 .49598 .30119 .4884 .31524 Metetra
.4884 .31524 .49598 .30119 .50921 .28619 .5018 .29919 Metetra
.5018 .29919 .50921 .28619 .52241 .27233 .51516 .28331 Metetra
.51516 .28331 .52241 .27233 .53561 .25983 .5285 .26819 Metetra
.5285 .26819 .53561 .25983 .54881 .24873 .54181 .25421 Metetra
.571 .882 .597 r
.54181 .25421 .54881 .24873 .56204 .23897 .55513 .24159 Metetra
.681 .969 .766 r
.55513 .24159 .56204 .23897 .5753 .2304 .56846 .23039 Metetra
.743 .99 .884 r
.56846 .23039 .5753 .2304 .58862 .22283 .58182 .22052 Metetra
.756 .957 .937 r
.58182 .22052 .58862 .22283 .602 .21604 .59524 .21185 Metetra
.743 .905 .949 r
.59524 .21185 .602 .21604 .61544 .20986 .60871 .20418 Metetra
.724 .857 .945 r
.60871 .20418 .61544 .20986 .62896 .20411 .62225 .1973 Metetra
.705 .819 .935 r
.62225 .1973 .62896 .20411 .64254 .19866 .63586 .19102 Metetra
.691 .791 .927 r
.63586 .19102 .64254 .19866 .6562 .1934 .64955 .18518 Metetra
.681 .773 .92 r
.64955 .18518 .6562 .1934 .66992 .18826 .66331 .17963 Metetra
.674 .76 .915 r
.66331 .17963 .66992 .18826 .68372 .18318 .67714 .17428 Metetra
.67 .752 .912 r
.67714 .17428 .68372 .18318 .69758 .17812 .69104 .16904 Metetra
.667 .748 .91 r
.69104 .16904 .69758 .17812 .71152 .17308 .70502 .16386 Metetra
.666 .745 .909 r
.70502 .16386 .71152 .17308 .72552 .16802 .71907 .15872 Metetra
.665 .743 .909 r
.71907 .15872 .72552 .16802 .73959 .16295 .73319 .15357 Metetra
.664 .742 .908 r
.73319 .15357 .73959 .16295 .75374 .15786 .74738 .14842 Metetra
.664 .742 .908 r
.74738 .14842 .75374 .15786 .76795 .15275 .76164 .14326 Metetra
.664 .742 .908 r
.76164 .14326 .76795 .15275 .78223 .14761 .77598 .13807 Metetra
.663 .74 .907 r
.14044 .35729 .14864 .36499 .16007 .36087 .1519 .35312 Metetra
.663 .739 .907 r
.1519 .35312 .16007 .36087 .17155 .35677 .16341 .34895 Metetra
.662 .738 .906 r
.16341 .34895 .17155 .35677 .18307 .35272 .17497 .34478 Metetra
.661 .736 .905 r
.17497 .34478 .18307 .35272 .19464 .34873 .18658 .34062 Metetra
.659 .732 .903 r
.18658 .34062 .19464 .34873 .20624 .34486 .19823 .3365 Metetra
.656 .725 .9 r
.19823 .3365 .20624 .34486 .21788 .34118 .20994 .33244 Metetra
.651 .715 .895 r
.20994 .33244 .21788 .34118 .22955 .3378 .22168 .32849 Metetra
.644 .7 .887 r
.22168 .32849 .22955 .3378 .24124 .33484 .23346 .32474 Metetra
.633 .679 .875 r
.23346 .32474 .24124 .33484 .25294 .33248 .24527 .32129 Metetra
.618 .65 .86 r
.24527 .32129 .25294 .33248 .26464 .33091 .2571 .31826 Metetra
.598 .615 .84 r
.2571 .31826 .26464 .33091 .27633 .33032 .26895 .31583 Metetra
.575 .575 .815 r
.26895 .31583 .27633 .33032 .28802 .33092 .2808 .31419 Metetra
.548 .531 .788 r
.2808 .31419 .28802 .33092 .2997 .33286 .29266 .31354 Metetra
.521 .488 .761 r
.29266 .31354 .2997 .33286 .31138 .33622 .30451 .31408 Metetra
.494 .448 .734 r
.30451 .31408 .31138 .33622 .3231 .34094 .31637 .31597 Metetra
.47 .413 .711 r
.31637 .31597 .3231 .34094 .33487 .34683 .32824 .31927 Metetra
.45 .385 .693 r
.32824 .31927 .33487 .34683 .34673 .3535 .34015 .32395 Metetra
.434 .365 .68 r
.34015 .32395 .34673 .3535 .35873 .36038 .35213 .32979 Metetra
.423 .354 .674 r
.35213 .32979 .35873 .36038 .3709 .36679 .3642 .33642 Metetra
.419 .352 .676 r
.3642 .33642 .3709 .36679 .38326 .37192 .37641 .34326 Metetra
.421 .364 .688 r
.37641 .34326 .38326 .37192 .39585 .37499 .38879 .34962 Metetra
.434 .393 .713 r
.38879 .34962 .39585 .37499 .40866 .37535 .40137 .3547 Metetra
.462 .449 .758 r
.40137 .3547 .40866 .37535 .42167 .37255 .41417 .35774 Metetra
.514 .552 .832 r
.41417 .35774 .42167 .37255 .43485 .3664 .42717 .35804 Metetra
.597 .73 .937 r
.42717 .35804 .43485 .3664 .44816 .35706 .44036 .35516 Metetra
.654 .936 .968 r
.44036 .35516 .44816 .35706 .46155 .34497 .4537 .34892 Metetra
.527 .897 .704 r
.4537 .34892 .46155 .34497 .47497 .33077 .46715 .33948 Metetra
.46715 .33948 .47497 .33077 .4884 .31524 .48067 .32726 Metetra
.48067 .32726 .4884 .31524 .5018 .29919 .49421 .31294 Metetra
.49421 .31294 .5018 .29919 .51516 .28331 .50773 .29729 Metetra
.50773 .29729 .51516 .28331 .5285 .26819 .52124 .2811 Metetra
.52124 .2811 .5285 .26819 .54181 .25421 .5347 .2651 Metetra
.5347 .2651 .54181 .25421 .55513 .24159 .54815 .24985 Metetra
.54815 .24985 .55513 .24159 .56846 .23039 .56158 .23575 Metetra
.57 .881 .596 r
.56158 .23575 .56846 .23039 .58182 .22052 .57501 .22302 Metetra
.68 .968 .765 r
.57501 .22302 .58182 .22052 .59524 .21185 .58848 .21169 Metetra
.743 .99 .884 r
.58848 .21169 .59524 .21185 .60871 .20418 .60198 .20172 Metetra
.756 .957 .937 r
.60198 .20172 .60871 .20418 .62225 .1973 .61555 .19295 Metetra
.743 .905 .95 r
.61555 .19295 .62225 .1973 .63586 .19102 .62918 .18518 Metetra
.724 .857 .945 r
.62918 .18518 .63586 .19102 .64955 .18518 .64288 .1782 Metetra
.705 .819 .935 r
.64288 .1782 .64955 .18518 .66331 .17963 .65667 .17183 Metetra
.691 .791 .927 r
.65667 .17183 .66331 .17963 .67714 .17428 .67053 .16589 Metetra
.681 .773 .92 r
.67053 .16589 .67714 .17428 .69104 .16904 .68446 .16024 Metetra
.674 .76 .915 r
.68446 .16024 .69104 .16904 .70502 .16386 .69848 .15479 Metetra
.67 .752 .912 r
.69848 .15479 .70502 .16386 .71907 .15872 .71257 .14946 Metetra
.667 .748 .91 r
.71257 .14946 .71907 .15872 .73319 .15357 .72673 .14418 Metetra
.666 .745 .909 r
.72673 .14418 .73319 .15357 .74738 .14842 .74097 .13894 Metetra
.665 .743 .909 r
.74097 .13894 .74738 .14842 .76164 .14326 .75528 .1337 Metetra
.664 .742 .909 r
.75528 .1337 .76164 .14326 .77598 .13807 .76966 .12846 Metetra
.663 .741 .908 r
.13216 .34956 .14044 .35729 .1519 .35312 .14365 .34536 Metetra
.663 .741 .908 r
.14365 .34536 .1519 .35312 .16341 .34895 .15519 .34114 Metetra
.663 .74 .907 r
.15519 .34114 .16341 .34895 .17497 .34478 .16678 .33691 Metetra
.663 .74 .907 r
.16678 .33691 .17497 .34478 .18658 .34062 .17843 .33267 Metetra
.662 .738 .906 r
.17843 .33267 .18658 .34062 .19823 .3365 .19012 .32843 Metetra
.661 .736 .905 r
.19012 .32843 .19823 .3365 .20994 .33244 .20187 .32419 Metetra
.659 .732 .903 r
.20187 .32419 .20994 .33244 .22168 .32849 .21366 .31999 Metetra
.656 .725 .9 r
.21366 .31999 .22168 .32849 .23346 .32474 .2255 .31586 Metetra
.651 .715 .895 r
.2255 .31586 .23346 .32474 .24527 .32129 .23739 .31184 Metetra
.644 .7 .887 r
.23739 .31184 .24527 .32129 .2571 .31826 .24931 .30802 Metetra
.633 .679 .875 r
.24931 .30802 .2571 .31826 .26895 .31583 .26126 .30449 Metetra
.618 .65 .86 r
.26126 .30449 .26895 .31583 .2808 .31419 .27325 .30139 Metetra
.598 .615 .84 r
.27325 .30139 .2808 .31419 .29266 .31354 .28524 .29889 Metetra
.575 .575 .816 r
.28524 .29889 .29266 .31354 .30451 .31408 .29726 .29718 Metetra
.548 .531 .788 r
.29726 .29718 .30451 .31408 .31637 .31597 .30928 .29647 Metetra
.521 .488 .761 r
.30928 .29647 .31637 .31597 .32824 .31927 .3213 .29694 Metetra
.494 .448 .734 r
.3213 .29694 .32824 .31927 .34015 .32395 .33334 .29877 Metetra
.47 .413 .711 r
.33334 .29877 .34015 .32395 .35213 .32979 .3454 .30202 Metetra
.45 .385 .693 r
.3454 .30202 .35213 .32979 .3642 .33642 .35751 .30665 Metetra
.434 .365 .68 r
.35751 .30665 .3642 .33642 .37641 .34326 .3697 .31244 Metetra
.423 .354 .674 r
.3697 .31244 .37641 .34326 .38879 .34962 .38199 .31902 Metetra
.419 .352 .676 r
.38199 .31902 .38879 .34962 .40137 .3547 .39442 .32582 Metetra
.422 .364 .688 r
.39442 .32582 .40137 .3547 .41417 .35774 .40703 .33214 Metetra
.434 .393 .713 r
.40703 .33214 .41417 .35774 .42717 .35804 .41982 .33718 Metetra
.462 .449 .758 r
.41982 .33718 .42717 .35804 .44036 .35516 .43283 .34016 Metetra
.514 .552 .832 r
.43283 .34016 .44036 .35516 .4537 .34892 .44603 .34039 Metetra
.597 .729 .937 r
.44603 .34039 .4537 .34892 .46715 .33948 .4594 .33743 Metetra
.655 .935 .968 r
.4594 .33743 .46715 .33948 .48067 .32726 .4729 .3311 Metetra
.529 .898 .706 r
.4729 .3311 .48067 .32726 .49421 .31294 .4865 .32155 Metetra
.4865 .32155 .49421 .31294 .50773 .29729 .50015 .30922 Metetra
.50015 .30922 .50773 .29729 .52124 .2811 .5138 .29477 Metetra
.5138 .29477 .52124 .2811 .5347 .2651 .52744 .27899 Metetra
.52744 .27899 .5347 .2651 .54815 .24985 .54105 .26267 Metetra
.54105 .26267 .54815 .24985 .56158 .23575 .55462 .24654 Metetra
.55462 .24654 .56158 .23575 .57501 .22302 .56817 .23117 Metetra
.56817 .23117 .57501 .22302 .58848 .21169 .58172 .21694 Metetra
.569 .88 .594 r
.58172 .21694 .58848 .21169 .60198 .20172 .59528 .20409 Metetra
.68 .968 .765 r
.59528 .20409 .60198 .20172 .61555 .19295 .60888 .19265 Metetra
.743 .99 .883 r
.60888 .19265 .61555 .19295 .62918 .18518 .62253 .18257 Metetra
.756 .957 .937 r
.62253 .18257 .62918 .18518 .64288 .1782 .63624 .17369 Metetra
.743 .906 .95 r
.63624 .17369 .64288 .1782 .65667 .17183 .65004 .16581 Metetra
.723 .857 .945 r
.65004 .16581 .65667 .17183 .67053 .16589 .66391 .15874 Metetra
.705 .819 .935 r
.66391 .15874 .67053 .16589 .68446 .16024 .67787 .15226 Metetra
.691 .791 .927 r
.67787 .15226 .68446 .16024 .69848 .15479 .69191 .14623 Metetra
.681 .773 .92 r
.69191 .14623 .69848 .15479 .71257 .14946 .70603 .14048 Metetra
.674 .76 .916 r
.70603 .14048 .71257 .14946 .72673 .14418 .72023 .13494 Metetra
.67 .753 .913 r
.72023 .13494 .72673 .14418 .74097 .13894 .73451 .12951 Metetra
.667 .748 .911 r
.73451 .12951 .74097 .13894 .75528 .1337 .74887 .12416 Metetra
.665 .745 .91 r
.74887 .12416 .75528 .1337 .76966 .12846 .7633 .11885 Metetra
.664 .741 .908 r
.12381 .34179 .13216 .34956 .14365 .34536 .13533 .33755 Metetra
.664 .741 .908 r
.13533 .33755 .14365 .34536 .15519 .34114 .1469 .33329 Metetra
.663 .741 .908 r
.1469 .33329 .15519 .34114 .16678 .33691 .15852 .32902 Metetra
.663 .741 .908 r
.15852 .32902 .16678 .33691 .17843 .33267 .1702 .32473 Metetra
.663 .74 .907 r
.1702 .32473 .17843 .33267 .19012 .32843 .18193 .32042 Metetra
.663 .74 .907 r
.18193 .32042 .19012 .32843 .20187 .32419 .19371 .31611 Metetra
.662 .738 .906 r
.19371 .31611 .20187 .32419 .21366 .31999 .20554 .31179 Metetra
.661 .736 .905 r
.20554 .31179 .21366 .31999 .2255 .31586 .21743 .30748 Metetra
.659 .732 .903 r
.21743 .30748 .2255 .31586 .23739 .31184 .22936 .3032 Metetra
.656 .725 .9 r
.22936 .3032 .23739 .31184 .24931 .30802 .24134 .29899 Metetra
.651 .715 .895 r
.24134 .29899 .24931 .30802 .26126 .30449 .25337 .2949 Metetra
.644 .7 .887 r
.25337 .2949 .26126 .30449 .27325 .30139 .26544 .291 Metetra
.633 .679 .876 r
.26544 .291 .27325 .30139 .28524 .29889 .27755 .28739 Metetra
.618 .65 .86 r
.27755 .28739 .28524 .29889 .29726 .29718 .28968 .28422 Metetra
.598 .615 .84 r
.28968 .28422 .29726 .29718 .30928 .29647 .30183 .28165 Metetra
.575 .575 .816 r
.30183 .28165 .30928 .29647 .3213 .29694 .31401 .27986 Metetra
.548 .531 .788 r
.31401 .27986 .3213 .29694 .33334 .29877 .3262 .27908 Metetra
.521 .488 .761 r
.3262 .27908 .33334 .29877 .3454 .30202 .3384 .27949 Metetra
.494 .448 .734 r
.3384 .27949 .3454 .30202 .35751 .30665 .35062 .28126 Metetra
.47 .413 .711 r
.35062 .28126 .35751 .30665 .3697 .31244 .36288 .28445 Metetra
.45 .385 .693 r
.36288 .28445 .3697 .31244 .38199 .31902 .3752 .28902 Metetra
.434 .365 .68 r
.3752 .28902 .38199 .31902 .39442 .32582 .3876 .29476 Metetra
.423 .354 .674 r
.3876 .29476 .39442 .32582 .40703 .33214 .40011 .3013 Metetra
.419 .352 .676 r
.40011 .3013 .40703 .33214 .41982 .33718 .41277 .30806 Metetra
.422 .364 .688 r
.41277 .30806 .41982 .33718 .43283 .34016 .4256 .31433 Metetra
.435 .393 .713 r
.4256 .31433 .43283 .34016 .44603 .34039 .43863 .31932 Metetra
.463 .449 .758 r
.43863 .31932 .44603 .34039 .4594 .33743 .45184 .32224 Metetra
.515 .552 .832 r
.45184 .32224 .4594 .33743 .4729 .3311 .46525 .32241 Metetra
.598 .729 .936 r
.46525 .32241 .4729 .3311 .4865 .32155 .4788 .31937 Metetra
.656 .935 .968 r
.4788 .31937 .4865 .32155 .50015 .30922 .49248 .31294 Metetra
.531 .899 .708 r
.49248 .31294 .50015 .30922 .5138 .29477 .50623 .30329 Metetra
.50623 .30329 .5138 .29477 .52744 .27899 .52001 .29083 Metetra
.52001 .29083 .52744 .27899 .54105 .26267 .53378 .27626 Metetra
.53378 .27626 .54105 .26267 .55462 .24654 .54753 .26035 Metetra
.54753 .26035 .55462 .24654 .56817 .23117 .56124 .2439 Metetra
.56124 .2439 .56817 .23117 .58172 .21694 .57492 .22764 Metetra
.57492 .22764 .58172 .21694 .59528 .20409 .58858 .21212 Metetra
.58858 .21212 .59528 .20409 .60888 .19265 .60224 .19777 Metetra
.568 .879 .593 r
.60224 .19777 .60888 .19265 .62253 .18257 .61593 .18479 Metetra
.679 .968 .764 r
.61593 .18479 .62253 .18257 .63624 .17369 .62967 .17324 Metetra
.742 .99 .883 r
.62967 .17324 .63624 .17369 .65004 .16581 .64346 .16305 Metetra
.756 .958 .937 r
.64346 .16305 .65004 .16581 .66391 .15874 .65734 .15406 Metetra
.743 .906 .95 r
.65734 .15406 .66391 .15874 .67787 .15226 .6713 .14608 Metetra
.723 .857 .945 r
.6713 .14608 .67787 .15226 .69191 .14623 .68534 .13891 Metetra
.705 .819 .936 r
.68534 .13891 .69191 .14623 .70603 .14048 .69948 .13234 Metetra
.691 .792 .927 r
.69948 .13234 .70603 .14048 .72023 .13494 .7137 .12622 Metetra
.68 .773 .921 r
.7137 .12622 .72023 .13494 .73451 .12951 .72802 .12041 Metetra
.672 .761 .917 r
.72802 .12041 .73451 .12951 .74887 .12416 .74241 .11482 Metetra
.666 .754 .916 r
.74241 .11482 .74887 .12416 .7633 .11885 .7569 .10941 Metetra
.664 .741 .908 r
.11539 .33395 .12381 .34179 .13533 .33755 .12694 .32967 Metetra
.664 .741 .908 r
.12694 .32967 .13533 .33755 .1469 .33329 .13854 .32538 Metetra
.664 .741 .908 r
.13854 .32538 .1469 .33329 .15852 .32902 .15019 .32107 Metetra
.664 .741 .908 r
.15019 .32107 .15852 .32902 .1702 .32473 .1619 .31674 Metetra
.663 .741 .908 r
.1619 .31674 .1702 .32473 .18193 .32042 .17366 .31239 Metetra
.663 .741 .908 r
.17366 .31239 .18193 .32042 .19371 .31611 .18547 .30802 Metetra
.663 .74 .907 r
.18547 .30802 .19371 .31611 .20554 .31179 .19734 .30364 Metetra
.663 .74 .907 r
.19734 .30364 .20554 .31179 .21743 .30748 .20926 .29925 Metetra
.662 .738 .906 r
.20926 .29925 .21743 .30748 .22936 .3032 .22123 .29485 Metetra
.661 .736 .905 r
.22123 .29485 .22936 .3032 .24134 .29899 .23326 .29046 Metetra
.659 .732 .903 r
.23326 .29046 .24134 .29899 .25337 .2949 .24534 .28611 Metetra
.656 .725 .9 r
.24534 .28611 .25337 .2949 .26544 .291 .25747 .28182 Metetra
.651 .715 .895 r
.25747 .28182 .26544 .291 .27755 .28739 .26965 .27765 Metetra
.644 .7 .887 r
.26965 .27765 .27755 .28739 .28968 .28422 .28186 .27367 Metetra
.633 .679 .876 r
.28186 .27367 .28968 .28422 .30183 .28165 .29412 .26999 Metetra
.618 .65 .86 r
.29412 .26999 .30183 .28165 .31401 .27986 .30641 .26674 Metetra
.598 .615 .84 r
.30641 .26674 .31401 .27986 .3262 .27908 .31873 .26409 Metetra
.574 .575 .816 r
.31873 .26409 .3262 .27908 .3384 .27949 .33106 .26223 Metetra
.548 .531 .789 r
.33106 .26223 .3384 .27949 .35062 .28126 .34343 .26138 Metetra
.52 .488 .761 r
.34343 .26138 .35062 .28126 .36288 .28445 .35581 .26173 Metetra
.494 .447 .734 r
.35581 .26173 .36288 .28445 .3752 .28902 .36822 .26343 Metetra
.47 .413 .711 r
.36822 .26343 .3752 .28902 .3876 .29476 .38068 .26656 Metetra
.45 .385 .693 r
.38068 .26656 .3876 .29476 .40011 .3013 .39321 .27107 Metetra
.434 .365 .68 r
.39321 .27107 .40011 .3013 .41277 .30806 .40583 .27676 Metetra
.423 .354 .674 r
.40583 .27676 .41277 .30806 .4256 .31433 .41857 .28325 Metetra
.419 .353 .676 r
.41857 .28325 .4256 .31433 .43863 .31932 .43146 .28996 Metetra
.422 .364 .688 r
.43146 .28996 .43863 .31932 .45184 .32224 .44453 .29619 Metetra
.435 .393 .713 r
.44453 .29619 .45184 .32224 .46525 .32241 .45779 .30113 Metetra
.463 .449 .758 r
.45779 .30113 .46525 .32241 .4788 .31937 .47123 .30399 Metetra
.515 .552 .832 r
.47123 .30399 .4788 .31937 .49248 .31294 .48484 .30408 Metetra
.598 .729 .936 r
.48484 .30408 .49248 .31294 .50623 .30329 .49859 .30095 Metetra
.656 .935 .968 r
.49859 .30095 .50623 .30329 .52001 .29083 .51243 .29443 Metetra
.532 .901 .709 r
.51243 .29443 .52001 .29083 .53378 .27626 .52634 .28466 Metetra
.52634 .28466 .53378 .27626 .54753 .26035 .54025 .27209 Metetra
.54025 .27209 .54753 .26035 .56124 .2439 .55415 .2574 Metetra
.55415 .2574 .56124 .2439 .57492 .22764 .568 .24135 Metetra
.568 .24135 .57492 .22764 .58858 .21212 .58182 .22476 Metetra
.58182 .22476 .58858 .21212 .60224 .19777 .59561 .20835 Metetra
.59561 .20835 .60224 .19777 .61593 .18479 .60938 .19271 Metetra
.60938 .19271 .61593 .18479 .62967 .17324 .62317 .17823 Metetra
.567 .878 .592 r
.62317 .17823 .62967 .17324 .64346 .16305 .63698 .16513 Metetra
.678 .967 .763 r
.63698 .16513 .64346 .16305 .65734 .15406 .65086 .15347 Metetra
.741 .99 .883 r
.65086 .15347 .65734 .15406 .6713 .14608 .66481 .14317 Metetra
.755 .958 .937 r
.66481 .14317 .6713 .14608 .68534 .13891 .67884 .13409 Metetra
.742 .906 .95 r
.67884 .13409 .68534 .13891 .69948 .13234 .69297 .12604 Metetra
.721 .858 .947 r
.69297 .12604 .69948 .13234 .7137 .12622 .7072 .11882 Metetra
.702 .821 .939 r
.7072 .11882 .7137 .12622 .72802 .12041 .72153 .11226 Metetra
.685 .795 .933 r
.72153 .11226 .72802 .12041 .74241 .11482 .73596 .10622 Metetra
.671 .778 .93 r
.73596 .10622 .74241 .11482 .7569 .10941 .75049 .10063 Metetra
.664 .741 .908 r
.1069 .32604 .11539 .33395 .12694 .32967 .11848 .32173 Metetra
.664 .741 .908 r
.11848 .32173 .12694 .32967 .13854 .32538 .13011 .3174 Metetra
.664 .741 .908 r
.13011 .3174 .13854 .32538 .15019 .32107 .14179 .31306 Metetra
.664 .741 .908 r
.14179 .31306 .15019 .32107 .1619 .31674 .15353 .30869 Metetra
.664 .741 .908 r
.15353 .30869 .1619 .31674 .17366 .31239 .16532 .3043 Metetra
.664 .741 .908 r
.16532 .3043 .17366 .31239 .18547 .30802 .17716 .29989 Metetra
.663 .741 .908 r
.17716 .29989 .18547 .30802 .19734 .30364 .18906 .29546 Metetra
.663 .741 .908 r
.18906 .29546 .19734 .30364 .20926 .29925 .20102 .29102 Metetra
.663 .74 .907 r
.20102 .29102 .20926 .29925 .22123 .29485 .21303 .28656 Metetra
.663 .74 .907 r
.21303 .28656 .22123 .29485 .23326 .29046 .22509 .28208 Metetra
.662 .738 .906 r
.22509 .28208 .23326 .29046 .24534 .28611 .23721 .27761 Metetra
.661 .736 .905 r
.23721 .27761 .24534 .28611 .25747 .28182 .24938 .27314 Metetra
.659 .732 .903 r
.24938 .27314 .25747 .28182 .26965 .27765 .26161 .26871 Metetra
.656 .725 .9 r
.26161 .26871 .26965 .27765 .28186 .27367 .27389 .26434 Metetra
.651 .715 .895 r
.27389 .26434 .28186 .27367 .29412 .26999 .28621 .26008 Metetra
.644 .7 .887 r
.28621 .26008 .29412 .26999 .30641 .26674 .29858 .25602 Metetra
.633 .679 .876 r
.29858 .25602 .30641 .26674 .31873 .26409 .311 .25226 Metetra
.618 .65 .86 r
.311 .25226 .31873 .26409 .33106 .26223 .32345 .24893 Metetra
.598 .615 .84 r
.32345 .24893 .33106 .26223 .34343 .26138 .33593 .24621 Metetra
.574 .575 .816 r
.33593 .24621 .34343 .26138 .35581 .26173 .34843 .24428 Metetra
.548 .531 .789 r
.34843 .24428 .35581 .26173 .36822 .26343 .36097 .24335 Metetra
.52 .488 .761 r
.36097 .24335 .36822 .26343 .38068 .26656 .37354 .24363 Metetra
.494 .447 .734 r
.37354 .24363 .38068 .26656 .39321 .27107 .38615 .24526 Metetra
.47 .413 .711 r
.38615 .24526 .39321 .27107 .40583 .27676 .39882 .24833 Metetra
.45 .385 .693 r
.39882 .24833 .40583 .27676 .41857 .28325 .41156 .25278 Metetra
.434 .365 .68 r
.41156 .25278 .41857 .28325 .43146 .28996 .42441 .25842 Metetra
.423 .354 .674 r
.42441 .25842 .43146 .28996 .44453 .29619 .43738 .26485 Metetra
.419 .353 .676 r
.43738 .26485 .44453 .29619 .45779 .30113 .45052 .27152 Metetra
.422 .364 .688 r
.45052 .27152 .45779 .30113 .47123 .30399 .46383 .2777 Metetra
.435 .393 .713 r
.46383 .2777 .47123 .30399 .48484 .30408 .47732 .28258 Metetra
.463 .449 .758 r
.47732 .28258 .48484 .30408 .49859 .30095 .49099 .28537 Metetra
.515 .552 .831 r
.49099 .28537 .49859 .30095 .51243 .29443 .50481 .28539 Metetra
.599 .729 .936 r
.50481 .28539 .51243 .29443 .52634 .28466 .51876 .28218 Metetra
.657 .935 .968 r
.51876 .28218 .52634 .28466 .54025 .27209 .53278 .27556 Metetra
.534 .902 .711 r
.53278 .27556 .54025 .27209 .55415 .2574 .54684 .26568 Metetra
.54684 .26568 .55415 .2574 .568 .24135 .56089 .25299 Metetra
.56089 .25299 .568 .24135 .58182 .22476 .57491 .23815 Metetra
.57491 .23815 .58182 .22476 .59561 .20835 .58888 .22197 Metetra
.58888 .22197 .59561 .20835 .60938 .19271 .60281 .20524 Metetra
.60281 .20524 .60938 .19271 .62317 .17823 .61671 .1887 Metetra
.61671 .1887 .62317 .17823 .63698 .16513 .63059 .17293 Metetra
.63059 .17293 .63698 .16513 .65086 .15347 .6445 .15834 Metetra
.562 .876 .589 r
.6445 .15834 .65086 .15347 .66481 .14317 .65845 .14515 Metetra
.671 .964 .76 r
.65845 .14515 .66481 .14317 .67884 .13409 .67247 .13343 Metetra
.733 .989 .881 r
.67247 .13343 .67884 .13409 .69297 .12604 .68658 .12314 Metetra
.745 .96 .939 r
.68658 .12314 .69297 .12604 .7072 .11882 .7008 .11413 Metetra
.729 .912 .957 r
.7008 .11413 .7072 .11882 .72153 .11226 .71512 .10629 Metetra
.702 .868 .96 r
.71512 .10629 .72153 .11226 .73596 .10622 .72957 .09947 Metetra
.673 .836 .961 r
.72957 .09947 .73596 .10622 .75049 .10063 .74415 .09358 Metetra
.664 .741 .908 r
.09834 .31807 .1069 .32604 .11848 .32173 .10995 .31373 Metetra
.664 .741 .908 r
.10995 .31373 .11848 .32173 .13011 .3174 .12161 .30936 Metetra
.664 .741 .908 r
.12161 .30936 .13011 .3174 .14179 .31306 .13332 .30497 Metetra
.664 .741 .908 r
.13332 .30497 .14179 .31306 .15353 .30869 .14509 .30057 Metetra
.664 .741 .908 r
.14509 .30057 .15353 .30869 .16532 .3043 .15691 .29614 Metetra
.664 .741 .908 r
.15691 .29614 .16532 .3043 .17716 .29989 .16879 .2917 Metetra
.664 .741 .908 r
.16879 .2917 .17716 .29989 .18906 .29546 .18072 .28723 Metetra
.664 .741 .908 r
.18072 .28723 .18906 .29546 .20102 .29102 .1927 .28274 Metetra
.663 .741 .908 r
.1927 .28274 .20102 .29102 .21303 .28656 .20474 .27823 Metetra
.663 .741 .908 r
.20474 .27823 .21303 .28656 .22509 .28208 .21684 .27371 Metetra
.663 .74 .907 r
.21684 .27371 .22509 .28208 .23721 .27761 .229 .26917 Metetra
.663 .74 .907 r
.229 .26917 .23721 .27761 .24938 .27314 .24121 .26461 Metetra
.662 .738 .906 r
.24121 .26461 .24938 .27314 .26161 .26871 .25347 .26006 Metetra
.661 .736 .905 r
.25347 .26006 .26161 .26871 .27389 .26434 .2658 .25551 Metetra
.659 .732 .903 r
.2658 .25551 .27389 .26434 .28621 .26008 .27817 .25099 Metetra
.656 .725 .9 r
.27817 .25099 .28621 .26008 .29858 .25602 .2906 .24654 Metetra
.651 .715 .895 r
.2906 .24654 .29858 .25602 .311 .25226 .30308 .2422 Metetra
.644 .7 .887 r
.30308 .2422 .311 .25226 .32345 .24893 .31561 .23806 Metetra
.633 .679 .876 r
.31561 .23806 .32345 .24893 .33593 .24621 .32818 .23421 Metetra
.618 .65 .86 r
.32818 .23421 .33593 .24621 .34843 .24428 .34079 .23081 Metetra
.598 .615 .84 r
.34079 .23081 .34843 .24428 .36097 .24335 .35344 .228 Metetra
.574 .575 .816 r
.35344 .228 .36097 .24335 .37354 .24363 .36613 .22599 Metetra
.548 .531 .789 r
.36613 .22599 .37354 .24363 .38615 .24526 .37885 .22499 Metetra
.52 .488 .761 r
.37885 .22499 .38615 .24526 .39882 .24833 .39161 .22519 Metetra
.494 .447 .734 r
.39161 .22519 .39882 .24833 .41156 .25278 .40442 .22675 Metetra
.47 .412 .711 r
.40442 .22675 .41156 .25278 .42441 .25842 .41729 .22975 Metetra
.45 .385 .693 r
.41729 .22975 .42441 .25842 .43738 .26485 .43026 .23415 Metetra
.434 .365 .68 r
.43026 .23415 .43738 .26485 .45052 .27152 .44334 .23973 Metetra
.423 .354 .674 r
.44334 .23973 .45052 .27152 .46383 .2777 .45656 .24611 Metetra
.419 .353 .676 r
.45656 .24611 .46383 .2777 .47732 .28258 .46994 .25272 Metetra
.422 .364 .688 r
.46994 .25272 .47732 .28258 .49099 .28537 .48349 .25884 Metetra
.435 .393 .713 r
.48349 .25884 .49099 .28537 .50481 .28539 .49723 .26367 Metetra
.464 .45 .758 r
.49723 .26367 .50481 .28539 .51876 .28218 .51114 .2664 Metetra
.516 .552 .831 r
.51114 .2664 .51876 .28218 .53278 .27556 .52518 .26634 Metetra
.599 .728 .935 r
.52518 .26634 .53278 .27556 .54684 .26568 .53933 .26303 Metetra
.658 .934 .969 r
.53933 .26303 .54684 .26568 .56089 .25299 .55353 .25631 Metetra
.536 .903 .714 r
.55353 .25631 .56089 .25299 .57491 .23815 .56775 .24632 Metetra
.56775 .24632 .57491 .23815 .58888 .22197 .58194 .23351 Metetra
.58194 .23351 .58888 .22197 .60281 .20524 .59609 .21854 Metetra
.59609 .21854 .60281 .20524 .61671 .1887 .61018 .20224 Metetra
.61018 .20224 .61671 .1887 .63059 .17293 .62421 .1854 Metetra
.62421 .1854 .63059 .17293 .6445 .15834 .63822 .16879 Metetra
.63822 .16879 .6445 .15834 .65845 .14515 .65223 .153 Metetra
.65223 .153 .65845 .14515 .67247 .13343 .66627 .13848 Metetra
.524 .851 .565 r
.66627 .13848 .67247 .13343 .68658 .12314 .68038 .12548 Metetra
.615 .939 .729 r
.68038 .12548 .68658 .12314 .7008 .11413 .69458 .11415 Metetra
.663 .974 .856 r
.69458 .11415 .7008 .11413 .71512 .10629 .7089 .10452 Metetra
.66 .962 .932 r
.7089 .10452 .71512 .10629 .72957 .09947 .72338 .09656 Metetra
.619 .928 .969 r
.72338 .09656 .72957 .09947 .74415 .09358 .73802 .09025 Metetra
.664 .741 .908 r
.08971 .31003 .09834 .31807 .10995 .31373 .10135 .30565 Metetra
.664 .741 .908 r
.10135 .30565 .10995 .31373 .12161 .30936 .11303 .30125 Metetra
.664 .741 .908 r
.11303 .30125 .12161 .30936 .13332 .30497 .12478 .29682 Metetra
.664 .741 .908 r
.12478 .29682 .13332 .30497 .14509 .30057 .13658 .29238 Metetra
.664 .741 .908 r
.13658 .29238 .14509 .30057 .15691 .29614 .14843 .28792 Metetra
.664 .741 .908 r
.14843 .28792 .15691 .29614 .16879 .2917 .16033 .28343 Metetra
.664 .741 .908 r
.16033 .28343 .16879 .2917 .18072 .28723 .1723 .27893 Metetra
.664 .741 .908 r
.1723 .27893 .18072 .28723 .1927 .28274 .18432 .2744 Metetra
.664 .741 .908 r
.18432 .2744 .1927 .28274 .20474 .27823 .19639 .26985 Metetra
.664 .741 .908 r
.19639 .26985 .20474 .27823 .21684 .27371 .20852 .26528 Metetra
.663 .741 .908 r
.20852 .26528 .21684 .27371 .229 .26917 .22071 .26069 Metetra
.663 .741 .908 r
.22071 .26069 .229 .26917 .24121 .26461 .23295 .25609 Metetra
.663 .74 .907 r
.23295 .25609 .24121 .26461 .25347 .26006 .24526 .25146 Metetra
.663 .74 .907 r
.24526 .25146 .25347 .26006 .2658 .25551 .25762 .24682 Metetra
.662 .738 .906 r
.25762 .24682 .2658 .25551 .27817 .25099 .27004 .24218 Metetra
.661 .736 .905 r
.27004 .24218 .27817 .25099 .2906 .24654 .28251 .23755 Metetra
.659 .732 .903 r
.28251 .23755 .2906 .24654 .30308 .2422 .29504 .23295 Metetra
.656 .725 .9 r
.29504 .23295 .30308 .2422 .31561 .23806 .30763 .22841 Metetra
.651 .715 .895 r
.30763 .22841 .31561 .23806 .32818 .23421 .32026 .22399 Metetra
.644 .7 .887 r
.32026 .22399 .32818 .23421 .34079 .23081 .33295 .21976 Metetra
.633 .679 .876 r
.33295 .21976 .34079 .23081 .35344 .228 .34569 .21583 Metetra
.617 .65 .86 r
.34569 .21583 .35344 .228 .36613 .22599 .35847 .21234 Metetra
.598 .615 .84 r
.35847 .21234 .36613 .22599 .37885 .22499 .37129 .20945 Metetra
.574 .575 .816 r
.37129 .20945 .37885 .22499 .39161 .22519 .38415 .20736 Metetra
.548 .531 .789 r
.38415 .20736 .39161 .22519 .40442 .22675 .39705 .20628 Metetra
.52 .488 .761 r
.39705 .20628 .40442 .22675 .41729 .22975 .41001 .2064 Metetra
.494 .447 .734 r
.41001 .2064 .41729 .22975 .43026 .23415 .42303 .20789 Metetra
.47 .412 .711 r
.42303 .20789 .43026 .23415 .44334 .23973 .43612 .21083 Metetra
.449 .385 .693 r
.43612 .21083 .44334 .23973 .45656 .24611 .44932 .21516 Metetra
.434 .365 .68 r
.44932 .21516 .45656 .24611 .46994 .25272 .46263 .22068 Metetra
.423 .354 .674 r
.46263 .22068 .46994 .25272 .48349 .25884 .4761 .227 Metetra
.419 .353 .676 r
.4761 .227 .48349 .25884 .49723 .26367 .48974 .23356 Metetra
.422 .364 .688 r
.48974 .23356 .49723 .26367 .51114 .2664 .50355 .23962 Metetra
.436 .394 .713 r
.50355 .23962 .51114 .2664 .52518 .26634 .51754 .24438 Metetra
.464 .45 .757 r
.51754 .24438 .52518 .26634 .53933 .26303 .53168 .24703 Metetra
.516 .552 .831 r
.53168 .24703 .53933 .26303 .55353 .25631 .54595 .2469 Metetra
.599 .728 .935 r
.54595 .2469 .55353 .25631 .56775 .24632 .56031 .24352 Metetra
.658 .934 .969 r
.56031 .24352 .56775 .24632 .58194 .23351 .5747 .23672 Metetra
.534 .902 .713 r
.5747 .23672 .58194 .23351 .59609 .21854 .58908 .22664 Metetra
.58908 .22664 .59609 .21854 .61018 .20224 .60342 .21377 Metetra
.60342 .21377 .61018 .20224 .62421 .1854 .6177 .19878 Metetra
.6177 .19878 .62421 .1854 .63822 .16879 .63191 .18254 Metetra
.63191 .18254 .63822 .16879 .65223 .153 .64608 .16589 Metetra
.64608 .16589 .65223 .153 .66627 .13848 .66023 .14965 Metetra
.66023 .14965 .66627 .13848 .68038 .12548 .6744 .13452 Metetra
.6744 .13452 .68038 .12548 .69458 .11415 .68865 .12104 Metetra
.68865 .12104 .69458 .11415 .7089 .10452 .70301 .10958 Metetra
.70301 .10958 .7089 .10452 .72338 .09656 .71754 .10039 Metetra
.71754 .10039 .72338 .09656 .73802 .09025 .73228 .09361 Metetra
.664 .741 .908 r
.081 .30193 .08971 .31003 .10135 .30565 .09267 .29751 Metetra
.664 .741 .908 r
.09267 .29751 .10135 .30565 .11303 .30125 .10439 .29307 Metetra
.664 .741 .908 r
.10439 .29307 .11303 .30125 .12478 .29682 .11616 .2886 Metetra
.664 .741 .908 r
.11616 .2886 .12478 .29682 .13658 .29238 .12799 .28412 Metetra
.664 .741 .908 r
.12799 .28412 .13658 .29238 .14843 .28792 .13987 .27962 Metetra
.664 .741 .908 r
.13987 .27962 .14843 .28792 .16033 .28343 .15181 .2751 Metetra
.664 .741 .908 r
.15181 .2751 .16033 .28343 .1723 .27893 .1638 .27055 Metetra
.664 .741 .908 r
.1638 .27055 .1723 .27893 .18432 .2744 .17585 .26599 Metetra
.664 .741 .908 r
.17585 .26599 .18432 .2744 .19639 .26985 .18796 .2614 Metetra
.664 .741 .908 r
.18796 .2614 .19639 .26985 .20852 .26528 .20013 .25679 Metetra
.664 .741 .908 r
.20013 .25679 .20852 .26528 .22071 .26069 .21235 .25216 Metetra
.664 .741 .908 r
.21235 .25216 .22071 .26069 .23295 .25609 .22463 .24751 Metetra
.663 .741 .908 r
.22463 .24751 .23295 .25609 .24526 .25146 .23696 .24283 Metetra
.663 .741 .908 r
.23696 .24283 .24526 .25146 .25762 .24682 .24936 .23814 Metetra
.663 .74 .907 r
.24936 .23814 .25762 .24682 .27004 .24218 .26182 .23343 Metetra
.663 .74 .907 r
.26182 .23343 .27004 .24218 .28251 .23755 .27433 .22871 Metetra
.662 .738 .906 r
.27433 .22871 .28251 .23755 .29504 .23295 .2869 .22398 Metetra
.661 .736 .905 r
.2869 .22398 .29504 .23295 .30763 .22841 .29953 .21926 Metetra
.659 .732 .903 r
.29953 .21926 .30763 .22841 .32026 .22399 .31222 .21457 Metetra
.656 .725 .9 r
.31222 .21457 .32026 .22399 .33295 .21976 .32497 .20994 Metetra
.651 .715 .895 r
.32497 .20994 .33295 .21976 .34569 .21583 .33777 .20544 Metetra
.644 .7 .887 r
.33777 .20544 .34569 .21583 .35847 .21234 .35062 .20112 Metetra
.633 .679 .876 r
.35062 .20112 .35847 .21234 .37129 .20945 .36352 .19711 Metetra
.617 .65 .86 r
.36352 .19711 .37129 .20945 .38415 .20736 .37647 .19353 Metetra
.598 .615 .84 r
.37647 .19353 .38415 .20736 .39705 .20628 .38947 .19055 Metetra
.574 .575 .816 r
.38947 .19055 .39705 .20628 .41001 .2064 .40251 .18838 Metetra
.548 .531 .789 r
.40251 .18838 .41001 .2064 .42303 .20789 .41561 .18721 Metetra
.52 .488 .761 r
.41561 .18721 .42303 .20789 .43612 .21083 .42876 .18726 Metetra
.493 .447 .734 r
.42876 .18726 .43612 .21083 .44932 .21516 .44199 .18868 Metetra
.469 .412 .711 r
.44199 .18868 .44932 .21516 .46263 .22068 .45531 .19154 Metetra
.449 .384 .693 r
.45531 .19154 .46263 .22068 .4761 .227 .46874 .1958 Metetra
.434 .365 .68 r
.46874 .1958 .4761 .227 .48974 .23356 .48231 .20126 Metetra
.423 .354 .674 r
.48231 .20126 .48974 .23356 .50355 .23962 .49603 .20753 Metetra
.419 .353 .676 r
.49603 .20753 .50355 .23962 .51754 .24438 .50993 .21402 Metetra
.422 .364 .688 r
.50993 .21402 .51754 .24438 .53168 .24703 .524 .22002 Metetra
.435 .393 .713 r
.524 .22002 .53168 .24703 .54595 .2469 .53825 .22473 Metetra
.463 .449 .758 r
.53825 .22473 .54595 .2469 .56031 .24352 .55264 .22736 Metetra
.514 .552 .832 r
.55264 .22736 .56031 .24352 .5747 .23672 .56715 .22722 Metetra
.594 .728 .937 r
.56715 .22722 .5747 .23672 .58908 .22664 .58172 .22387 Metetra
.644 .933 .969 r
.58172 .22387 .58908 .22664 .60342 .21377 .59631 .21716 Metetra
.494 .878 .688 r
.59631 .21716 .60342 .21377 .6177 .19878 .61087 .20731 Metetra
.61087 .20731 .6177 .19878 .63191 .18254 .62538 .19484 Metetra
.62538 .19484 .63191 .18254 .64608 .16589 .63982 .18053 Metetra
.63982 .18053 .64608 .16589 .66023 .14965 .65422 .16534 Metetra
.65422 .16534 .66023 .14965 .6744 .13452 .6686 .15024 Metetra
.6686 .15024 .6744 .13452 .68865 .12104 .68302 .13618 Metetra
.044 0 0 r
.68302 .13618 .68865 .12104 .70301 .10958 .69753 .12394 Metetra
.112 0 0 r
.69753 .12394 .70301 .10958 .71754 .10039 .71222 .1141 Metetra
.195 0 .007 r
.71222 .1141 .71754 .10039 .73228 .09361 .72712 .10705 Metetra
.664 .741 .908 r
.07222 .29375 .081 .30193 .09267 .29751 .08392 .28929 Metetra
.664 .741 .908 r
.08392 .28929 .09267 .29751 .10439 .29307 .09567 .28481 Metetra
.664 .741 .908 r
.09567 .28481 .10439 .29307 .11616 .2886 .10747 .28031 Metetra
.664 .741 .908 r
.10747 .28031 .11616 .2886 .12799 .28412 .11933 .27579 Metetra
.664 .741 .908 r
.11933 .27579 .12799 .28412 .13987 .27962 .13124 .27125 Metetra
.664 .741 .908 r
.13124 .27125 .13987 .27962 .15181 .2751 .14321 .26669 Metetra
.664 .741 .908 r
.14321 .26669 .15181 .2751 .1638 .27055 .15524 .2621 Metetra
.664 .741 .908 r
.15524 .2621 .1638 .27055 .17585 .26599 .16732 .2575 Metetra
.664 .741 .908 r
.16732 .2575 .17585 .26599 .18796 .2614 .17946 .25287 Metetra
.664 .741 .908 r
.17946 .25287 .18796 .2614 .20013 .25679 .19166 .24822 Metetra
.664 .741 .908 r
.19166 .24822 .20013 .25679 .21235 .25216 .20391 .24355 Metetra
.664 .741 .908 r
.20391 .24355 .21235 .25216 .22463 .24751 .21623 .23886 Metetra
.664 .741 .908 r
.21623 .23886 .22463 .24751 .23696 .24283 .2286 .23414 Metetra
.664 .741 .908 r
.2286 .23414 .23696 .24283 .24936 .23814 .24103 .2294 Metetra
.663 .741 .908 r
.24103 .2294 .24936 .23814 .26182 .23343 .25352 .22464 Metetra
.663 .741 .908 r
.25352 .22464 .26182 .23343 .27433 .22871 .26607 .21986 Metetra
.663 .74 .907 r
.26607 .21986 .27433 .22871 .2869 .22398 .27868 .21507 Metetra
.663 .74 .907 r
.27868 .21507 .2869 .22398 .29953 .21926 .29135 .21026 Metetra
.662 .738 .906 r
.29135 .21026 .29953 .21926 .31222 .21457 .30408 .20544 Metetra
.661 .736 .905 r
.30408 .20544 .31222 .21457 .32497 .20994 .31687 .20063 Metetra
.659 .732 .903 r
.31687 .20063 .32497 .20994 .33777 .20544 .32972 .19585 Metetra
.656 .725 .9 r
.32972 .19585 .33777 .20544 .35062 .20112 .34263 .19113 Metetra
.651 .715 .895 r
.34263 .19113 .35062 .20112 .36352 .19711 .3556 .18654 Metetra
.644 .7 .887 r
.3556 .18654 .36352 .19711 .37647 .19353 .36862 .18213 Metetra
.633 .679 .876 r
.36862 .18213 .37647 .19353 .38947 .19055 .38169 .17803 Metetra
.617 .65 .86 r
.38169 .17803 .38947 .19055 .40251 .18838 .39482 .17436 Metetra
.598 .615 .84 r
.39482 .17436 .40251 .18838 .41561 .18721 .40799 .17129 Metetra
.574 .575 .816 r
.40799 .17129 .41561 .18721 .42876 .18726 .42123 .16903 Metetra
.547 .531 .789 r
.42123 .16903 .42876 .18726 .44199 .18868 .43452 .16778 Metetra
.52 .488 .761 r
.43452 .16778 .44199 .18868 .45531 .19154 .44788 .16775 Metetra
.493 .447 .734 r
.44788 .16775 .45531 .19154 .46874 .1958 .46132 .16909 Metetra
.469 .412 .711 r
.46132 .16909 .46874 .1958 .48231 .20126 .47487 .17189 Metetra
.449 .384 .693 r
.47487 .17189 .48231 .20126 .49603 .20753 .48854 .17609 Metetra
.433 .364 .68 r
.48854 .17609 .49603 .20753 .50993 .21402 .50236 .1815 Metetra
.423 .353 .674 r
.50236 .1815 .50993 .21402 .524 .22002 .51635 .18772 Metetra
.418 .352 .676 r
.51635 .18772 .524 .22002 .53825 .22473 .53052 .19422 Metetra
.42 .363 .689 r
.53052 .19422 .53825 .22473 .55264 .22736 .54486 .20029 Metetra
.431 .392 .714 r
.54486 .20029 .55264 .22736 .56715 .22722 .55938 .20514 Metetra
.454 .447 .761 r
.55938 .20514 .56715 .22722 .58172 .22387 .57404 .20804 Metetra
.497 .55 .841 r
.57404 .20804 .58172 .22387 .59631 .21716 .5888 .20836 Metetra
.556 .735 .959 r
.5888 .20836 .59631 .21716 .61087 .20731 .60362 .20575 Metetra
.523 .908 .94 r
.60362 .20575 .61087 .20731 .62538 .19484 .61845 .20017 Metetra
.61845 .20017 .62538 .19484 .63982 .18053 .63327 .19195 Metetra
.63327 .19195 .63982 .18053 .65422 .16534 .64806 .18174 Metetra
.095 0 .012 r
.64806 .18174 .65422 .16534 .6686 .15024 .66282 .17041 Metetra
.173 0 .103 r
.66282 .17041 .6686 .15024 .68302 .13618 .67761 .15898 Metetra
.236 0 .158 r
.67761 .15898 .68302 .13618 .69753 .12394 .69246 .14839 Metetra
.291 0 .193 r
.69246 .14839 .69753 .12394 .71222 .1141 .70744 .13942 Metetra
.34 0 .216 r
.70744 .13942 .71222 .1141 .72712 .10705 .72262 .13261 Metetra
.664 .741 .908 r
.06337 .2855 .07222 .29375 .08392 .28929 .07509 .28101 Metetra
.664 .741 .908 r
.07509 .28101 .08392 .28929 .09567 .28481 .08687 .27649 Metetra
.664 .741 .908 r
.08687 .27649 .09567 .28481 .10747 .28031 .0987 .27195 Metetra
.664 .741 .908 r
.0987 .27195 .10747 .28031 .11933 .27579 .11059 .26739 Metetra
.664 .741 .908 r
.11059 .26739 .11933 .27579 .13124 .27125 .12254 .26281 Metetra
.664 .741 .908 r
.12254 .26281 .13124 .27125 .14321 .26669 .13454 .25821 Metetra
.664 .741 .908 r
.13454 .25821 .14321 .26669 .15524 .2621 .1466 .25358 Metetra
.664 .741 .908 r
.1466 .25358 .15524 .2621 .16732 .2575 .15871 .24894 Metetra
.664 .741 .908 r
.15871 .24894 .16732 .2575 .17946 .25287 .17088 .24427 Metetra
.664 .741 .908 r
.17088 .24427 .17946 .25287 .19166 .24822 .18311 .23958 Metetra
.664 .741 .908 r
.18311 .23958 .19166 .24822 .20391 .24355 .1954 .23487 Metetra
.664 .741 .908 r
.1954 .23487 .20391 .24355 .21623 .23886 .20775 .23013 Metetra
.664 .741 .908 r
.20775 .23013 .21623 .23886 .2286 .23414 .22016 .22537 Metetra
.664 .741 .908 r
.22016 .22537 .2286 .23414 .24103 .2294 .23262 .22059 Metetra
.664 .741 .908 r
.23262 .22059 .24103 .2294 .25352 .22464 .24515 .21579 Metetra
.664 .741 .908 r
.24515 .21579 .25352 .22464 .26607 .21986 .25774 .21096 Metetra
.663 .741 .908 r
.25774 .21096 .26607 .21986 .27868 .21507 .27038 .20612 Metetra
.663 .741 .908 r
.27038 .20612 .27868 .21507 .29135 .21026 .28309 .20125 Metetra
.663 .74 .907 r
.28309 .20125 .29135 .21026 .30408 .20544 .29586 .19636 Metetra
.663 .74 .907 r
.29586 .19636 .30408 .20544 .31687 .20063 .30869 .19146 Metetra
.662 .738 .906 r
.30869 .19146 .31687 .20063 .32972 .19585 .32158 .18655 Metetra
.661 .736 .905 r
.32158 .18655 .32972 .19585 .34263 .19113 .33454 .18165 Metetra
.659 .732 .903 r
.33454 .18165 .34263 .19113 .3556 .18654 .34755 .17678 Metetra
.656 .725 .9 r
.34755 .17678 .3556 .18654 .36862 .18213 .36063 .17197 Metetra
.651 .715 .895 r
.36063 .17197 .36862 .18213 .38169 .17803 .37376 .16728 Metetra
.644 .7 .887 r
.37376 .16728 .38169 .17803 .39482 .17436 .38696 .16278 Metetra
.633 .679 .876 r
.38696 .16278 .39482 .17436 .40799 .17129 .4002 .15858 Metetra
.617 .65 .86 r
.4002 .15858 .40799 .17129 .42123 .16903 .41351 .15482 Metetra
.598 .615 .84 r
.41351 .15482 .42123 .16903 .43452 .16778 .42687 .15167 Metetra
.574 .575 .816 r
.42687 .15167 .43452 .16778 .44788 .16775 .4403 .14932 Metetra
.547 .531 .789 r
.4403 .14932 .44788 .16775 .46132 .16909 .45379 .148 Metetra
.519 .487 .761 r
.45379 .148 .46132 .16909 .47487 .17189 .46737 .1479 Metetra
.492 .447 .734 r
.46737 .1479 .47487 .17189 .48854 .17609 .48103 .14919 Metetra
.468 .412 .711 r
.48103 .14919 .48854 .17609 .50236 .1815 .49482 .15197 Metetra
.446 .383 .693 r
.49482 .15197 .50236 .1815 .51635 .18772 .50874 .15622 Metetra
.429 .362 .681 r
.50874 .15622 .51635 .18772 .53052 .19422 .52282 .16175 Metetra
.416 .35 .676 r
.52282 .16175 .53052 .19422 .54486 .20029 .53708 .16825 Metetra
.406 .347 .679 r
.53708 .16825 .54486 .20029 .55938 .20514 .55153 .17523 Metetra
.4 .355 .693 r
.55153 .17523 .55938 .20514 .57404 .20804 .56618 .18206 Metetra
.398 .38 .723 r
.56618 .18206 .57404 .20804 .5888 .20836 .58101 .18809 Metetra
.396 .433 .781 r
.58101 .18809 .5888 .20836 .60362 .20575 .59599 .1927 Metetra
.383 .54 .888 r
.59599 .1927 .60362 .20575 .61845 .20017 .6111 .19539 Metetra
.256 .693 .961 r
.6111 .19539 .61845 .20017 .63327 .19195 .6263 .19591 Metetra
.107 0 0 r
.6263 .19591 .63327 .19195 .64806 .18174 .64155 .19427 Metetra
.274 0 0 r
.64155 .19427 .64806 .18174 .66282 .17041 .65685 .19077 Metetra
.333 0 .149 r
.65685 .19077 .66282 .17041 .67761 .15898 .67218 .18589 Metetra
.364 .011 .227 r
.67218 .18589 .67761 .15898 .69246 .14839 .68757 .18022 Metetra
.384 .047 .267 r
.68757 .18022 .69246 .14839 .70744 .13942 .70302 .17429 Metetra
.397 .068 .287 r
.70302 .17429 .70744 .13942 .72262 .13261 .71856 .1685 Metetra
.664 .741 .908 r
.05443 .27719 .06337 .2855 .07509 .28101 .06619 .27265 Metetra
.664 .741 .908 r
.06619 .27265 .07509 .28101 .08687 .27649 .078 .2681 Metetra
.664 .741 .908 r
.078 .2681 .08687 .27649 .0987 .27195 .08986 .26352 Metetra
.664 .741 .908 r
.08986 .26352 .0987 .27195 .11059 .26739 .10178 .25892 Metetra
.664 .741 .908 r
.10178 .25892 .11059 .26739 .12254 .26281 .11376 .2543 Metetra
.664 .741 .908 r
.11376 .2543 .12254 .26281 .13454 .25821 .12579 .24965 Metetra
.664 .741 .908 r
.12579 .24965 .13454 .25821 .1466 .25358 .13788 .24499 Metetra
.664 .741 .908 r
.13788 .24499 .1466 .25358 .15871 .24894 .15003 .2403 Metetra
.664 .741 .908 r
.15003 .2403 .15871 .24894 .17088 .24427 .16223 .23559 Metetra
.664 .741 .908 r
.16223 .23559 .17088 .24427 .18311 .23958 .1745 .23086 Metetra
.664 .741 .908 r
.1745 .23086 .18311 .23958 .1954 .23487 .18682 .22611 Metetra
.664 .741 .908 r
.18682 .22611 .1954 .23487 .20775 .23013 .1992 .22133 Metetra
.664 .741 .908 r
.1992 .22133 .20775 .23013 .22016 .22537 .21164 .21653 Metetra
.664 .741 .908 r
.21164 .21653 .22016 .22537 .23262 .22059 .22414 .21171 Metetra
.664 .741 .908 r
.22414 .21171 .23262 .22059 .24515 .21579 .2367 .20686 Metetra
.664 .741 .908 r
.2367 .20686 .24515 .21579 .25774 .21096 .24933 .20199 Metetra
.664 .741 .908 r
.24933 .20199 .25774 .21096 .27038 .20612 .26201 .1971 Metetra
.664 .741 .908 r
.26201 .1971 .27038 .20612 .28309 .20125 .27475 .19218 Metetra
.663 .741 .908 r
.27475 .19218 .28309 .20125 .29586 .19636 .28756 .18724 Metetra
.663 .741 .908 r
.28756 .18724 .29586 .19636 .30869 .19146 .30043 .18228 Metetra
.663 .74 .907 r
.30043 .18228 .30869 .19146 .32158 .18655 .31336 .1773 Metetra
.663 .74 .907 r
.31336 .1773 .32158 .18655 .33454 .18165 .32636 .1723 Metetra
.662 .738 .906 r
.32636 .1723 .33454 .18165 .34755 .17678 .33942 .1673 Metetra
.661 .736 .905 r
.33942 .1673 .34755 .17678 .36063 .17197 .35254 .16231 Metetra
.659 .732 .903 r
.35254 .16231 .36063 .17197 .37376 .16728 .36572 .15734 Metetra
.656 .725 .9 r
.36572 .15734 .37376 .16728 .38696 .16278 .37897 .15244 Metetra
.651 .715 .895 r
.37897 .15244 .38696 .16278 .4002 .15858 .39228 .14765 Metetra
.643 .7 .887 r
.39228 .14765 .4002 .15858 .41351 .15482 .40565 .14307 Metetra
.632 .679 .876 r
.40565 .14307 .41351 .15482 .42687 .15167 .41908 .13878 Metetra
.617 .651 .861 r
.41908 .13878 .42687 .15167 .4403 .14932 .43257 .13494 Metetra
.597 .615 .841 r
.43257 .13494 .4403 .14932 .45379 .148 .44612 .13173 Metetra
.572 .575 .817 r
.44612 .13173 .45379 .148 .46737 .1479 .45974 .12936 Metetra
.544 .531 .791 r
.45974 .12936 .46737 .1479 .48103 .14919 .47344 .12806 Metetra
.515 .486 .763 r
.47344 .12806 .48103 .14919 .49482 .15197 .48723 .12807 Metetra
.485 .445 .737 r
.48723 .12807 .49482 .15197 .50874 .15622 .50112 .1296 Metetra
.456 .407 .715 r
.50112 .1296 .50874 .15622 .52282 .16175 .51515 .13283 Metetra
.428 .376 .698 r
.51515 .13283 .52282 .16175 .53708 .16825 .52934 .1378 Metetra
.401 .351 .687 r
.52934 .1378 .53708 .16825 .55153 .17523 .54371 .14448 Metetra
.374 .333 .684 r
.54371 .14448 .55153 .17523 .56618 .18206 .55829 .15265 Metetra
.343 .321 .69 r
.55829 .15265 .56618 .18206 .58101 .18809 .5731 .16198 Metetra
.301 .318 .711 r
.5731 .16198 .58101 .18809 .59599 .1927 .58814 .17197 Metetra
.23 .324 .754 r
.58814 .17197 .59599 .1927 .6111 .19539 .60342 .18203 Metetra
.068 .335 .813 r
.60342 .18203 .6111 .19539 .6263 .19591 .61893 .19153 Metetra
0 .256 .654 r
.61893 .19153 .6263 .19591 .64155 .19427 .63462 .19981 Metetra
.505 0 0 r
.63462 .19981 .64155 .19427 .65685 .19077 .65047 .20632 Metetra
.496 .053 .126 r
.65047 .20632 .65685 .19077 .67218 .18589 .66642 .21057 Metetra
.469 .085 .229 r
.66642 .21057 .67218 .18589 .68757 .18022 .68243 .21223 Metetra
.444 .093 .275 r
.68243 .21223 .68757 .18022 .70302 .17429 .69844 .21107 Metetra
.419 .087 .294 r
.69844 .21107 .70302 .17429 .71856 .1685 .7144 .20695 Metetra
.664 .741 .908 r
.04542 .2688 .05443 .27719 .06619 .27265 .05721 .26422 Metetra
.664 .741 .908 r
.05721 .26422 .06619 .27265 .078 .2681 .06905 .25963 Metetra
.664 .741 .908 r
.06905 .25963 .078 .2681 .08986 .26352 .08094 .25501 Metetra
.664 .741 .908 r
.08094 .25501 .08986 .26352 .10178 .25892 .09289 .25037 Metetra
.664 .741 .908 r
.09289 .25037 .10178 .25892 .11376 .2543 .1049 .24571 Metetra
.664 .741 .908 r
.1049 .24571 .11376 .2543 .12579 .24965 .11697 .24103 Metetra
.664 .741 .908 r
.11697 .24103 .12579 .24965 .13788 .24499 .12909 .23632 Metetra
.664 .741 .908 r
.12909 .23632 .13788 .24499 .15003 .2403 .14127 .23159 Metetra
.664 .741 .908 r
.14127 .23159 .15003 .2403 .16223 .23559 .15351 .22684 Metetra
.664 .741 .908 r
.15351 .22684 .16223 .23559 .1745 .23086 .1658 .22207 Metetra
.664 .741 .908 r
.1658 .22207 .1745 .23086 .18682 .22611 .17816 .21727 Metetra
.664 .741 .908 r
.17816 .21727 .18682 .22611 .1992 .22133 .19057 .21245 Metetra
.664 .741 .908 r
.19057 .21245 .1992 .22133 .21164 .21653 .20305 .20761 Metetra
.664 .741 .908 r
.20305 .20761 .21164 .21653 .22414 .21171 .21559 .20274 Metetra
.664 .741 .908 r
.21559 .20274 .22414 .21171 .2367 .20686 .22818 .19785 Metetra
.664 .741 .908 r
.22818 .19785 .2367 .20686 .24933 .20199 .24084 .19294 Metetra
.664 .741 .908 r
.24084 .19294 .24933 .20199 .26201 .1971 .25356 .188 Metetra
.664 .741 .908 r
.25356 .188 .26201 .1971 .27475 .19218 .26634 .18304 Metetra
.664 .741 .908 r
.26634 .18304 .27475 .19218 .28756 .18724 .27919 .17805 Metetra
.664 .741 .908 r
.27919 .17805 .28756 .18724 .30043 .18228 .2921 .17304 Metetra
.663 .741 .908 r
.2921 .17304 .30043 .18228 .31336 .1773 .30507 .16801 Metetra
.663 .741 .908 r
.30507 .16801 .31336 .1773 .32636 .1723 .3181 .16295 Metetra
.663 .74 .907 r
.3181 .16295 .32636 .1723 .33942 .1673 .3312 .15788 Metetra
.663 .74 .907 r
.3312 .15788 .33942 .1673 .35254 .16231 .34437 .15279 Metetra
.662 .738 .906 r
.34437 .15279 .35254 .16231 .36572 .15734 .35759 .14769 Metetra
.661 .736 .905 r
.35759 .14769 .36572 .15734 .37897 .15244 .37089 .1426 Metetra
.659 .732 .903 r
.37089 .1426 .37897 .15244 .39228 .14765 .38424 .13755 Metetra
.655 .725 .9 r
.38424 .13755 .39228 .14765 .40565 .14307 .39767 .13257 Metetra
.65 .715 .896 r
.39767 .13257 .40565 .14307 .41908 .13878 .41115 .12772 Metetra
.642 .7 .889 r
.41115 .12772 .41908 .13878 .43257 .13494 .4247 .1231 Metetra
.629 .679 .879 r
.4247 .1231 .43257 .13494 .44612 .13173 .43831 .11883 Metetra
.612 .652 .865 r
.43831 .11883 .44612 .13173 .45974 .12936 .45198 .11508 Metetra
.588 .617 .848 r
.45198 .11508 .45974 .12936 .47344 .12806 .46573 .11209 Metetra
.559 .575 .827 r
.46573 .11209 .47344 .12806 .48723 .12807 .47955 .11014 Metetra
.524 .529 .803 r
.47955 .11014 .48723 .12807 .50112 .1296 .49346 .10954 Metetra
.483 .481 .779 r
.49346 .10954 .50112 .1296 .51515 .13283 .50747 .11063 Metetra
.439 .434 .756 r
.50747 .11063 .51515 .13283 .52934 .1378 .52162 .11377 Metetra
.39 .388 .736 r
.52162 .11377 .52934 .1378 .54371 .14448 .53594 .11925 Metetra
.335 .344 .72 r
.53594 .11925 .54371 .14448 .55829 .15265 .55046 .12726 Metetra
.27 .301 .71 r
.55046 .12726 .55829 .15265 .5731 .16198 .56522 .13785 Metetra
.186 .258 .706 r
.56522 .13785 .5731 .16198 .58814 .17197 .58027 .15082 Metetra
.066 .21 .704 r
.58027 .15082 .58814 .17197 .60342 .18203 .59562 .16572 Metetra
0 .143 .686 r
.59562 .16572 .60342 .18203 .61893 .19153 .6113 .18179 Metetra
0 .039 .573 r
.6113 .18179 .61893 .19153 .63462 .19981 .62729 .19798 Metetra
.633 .074 0 r
.62729 .19798 .63462 .19981 .65047 .20632 .64355 .21301 Metetra
.637 .118 0 r
.64355 .21301 .65047 .20632 .66642 .21057 .65999 .22546 Metetra
.565 .111 .132 r
.65999 .22546 .66642 .21057 .68243 .21223 .67651 .23396 Metetra
.486 .08 .196 r
.67651 .23396 .68243 .21223 .69844 .21107 .693 .23737 Metetra
.405 .033 .216 r
.693 .23737 .69844 .21107 .7144 .20695 .70932 .23489 Metetra
.664 .741 .908 r
.03634 .26034 .04542 .2688 .05721 .26422 .04815 .25572 Metetra
.664 .741 .908 r
.04815 .25572 .05721 .26422 .06905 .25963 .06002 .25109 Metetra
.664 .741 .908 r
.06002 .25109 .06905 .25963 .08094 .25501 .07194 .24643 Metetra
.664 .741 .908 r
.07194 .24643 .08094 .25501 .09289 .25037 .08393 .24175 Metetra
.664 .741 .908 r
.08393 .24175 .09289 .25037 .1049 .24571 .09597 .23704 Metetra
.664 .741 .908 r
.09597 .23704 .1049 .24571 .11697 .24103 .10806 .23232 Metetra
.664 .741 .908 r
.10806 .23232 .11697 .24103 .12909 .23632 .12022 .22757 Metetra
.664 .741 .908 r
.12022 .22757 .12909 .23632 .14127 .23159 .13243 .2228 Metetra
.664 .741 .908 r
.13243 .2228 .14127 .23159 .15351 .22684 .1447 .21801 Metetra
.664 .741 .908 r
.1447 .21801 .15351 .22684 .1658 .22207 .15703 .21319 Metetra
.664 .741 .908 r
.15703 .21319 .1658 .22207 .17816 .21727 .16942 .20835 Metetra
.664 .741 .908 r
.16942 .20835 .17816 .21727 .19057 .21245 .18187 .20349 Metetra
.664 .741 .908 r
.18187 .20349 .19057 .21245 .20305 .20761 .19438 .1986 Metetra
.664 .741 .908 r
.19438 .1986 .20305 .20761 .21559 .20274 .20695 .19369 Metetra
.664 .741 .908 r
.20695 .19369 .21559 .20274 .22818 .19785 .21959 .18876 Metetra
.664 .741 .908 r
.21959 .18876 .22818 .19785 .24084 .19294 .23228 .1838 Metetra
.664 .741 .908 r
.23228 .1838 .24084 .19294 .25356 .188 .24504 .17882 Metetra
.664 .741 .908 r
.24504 .17882 .25356 .188 .26634 .18304 .25785 .17381 Metetra
.664 .741 .908 r
.25785 .17381 .26634 .18304 .27919 .17805 .27074 .16878 Metetra
.664 .741 .908 r
.27074 .16878 .27919 .17805 .2921 .17304 .28368 .16372 Metetra
.663 .741 .908 r
.28368 .16372 .2921 .17304 .30507 .16801 .29669 .15864 Metetra
.663 .741 .908 r
.29669 .15864 .30507 .16801 .3181 .16295 .30977 .15354 Metetra
.663 .741 .908 r
.30977 .15354 .3181 .16295 .3312 .15788 .32291 .14841 Metetra
.663 .741 .908 r
.32291 .14841 .3312 .15788 .34437 .15279 .33611 .14326 Metetra
.663 .741 .908 r
.33611 .14326 .34437 .15279 .35759 .14769 .34938 .1381 Metetra
.662 .74 .908 r
.34938 .1381 .35759 .14769 .37089 .1426 .36272 .13293 Metetra
.661 .739 .907 r
.36272 .13293 .37089 .1426 .38424 .13755 .37612 .12777 Metetra
.659 .737 .907 r
.37612 .12777 .38424 .13755 .39767 .13257 .38958 .12264 Metetra
.656 .733 .906 r
.38958 .12264 .39767 .13257 .41115 .12772 .40311 .1176 Metetra
.65 .728 .906 r
.40311 .1176 .41115 .12772 .4247 .1231 .41671 .11271 Metetra
.641 .719 .904 r
.41671 .11271 .4247 .1231 .43831 .11883 .43037 .10808 Metetra
.627 .706 .903 r
.43037 .10808 .43831 .11883 .45198 .11508 .44409 .10386 Metetra
.606 .688 .9 r
.44409 .10386 .45198 .11508 .46573 .11209 .45788 .10027 Metetra
.576 .662 .896 r
.45788 .10027 .46573 .11209 .47955 .11014 .47174 .09759 Metetra
.534 .627 .89 r
.47174 .09759 .47955 .11014 .49346 .10954 .48568 .09617 Metetra
.477 .581 .88 r
.48568 .09617 .49346 .10954 .50747 .11063 .49972 .0964 Metetra
.402 .523 .865 r
.49972 .0964 .50747 .11063 .52162 .11377 .51387 .09873 Metetra
.308 .453 .843 r
.51387 .09873 .52162 .11377 .53594 .11925 .52818 .10359 Metetra
.194 .371 .812 r
.52818 .10359 .53594 .11925 .55046 .12726 .54269 .11132 Metetra
.064 .28 .77 r
.54269 .11132 .55046 .12726 .56522 .13785 .55743 .12214 Metetra
0 .186 .716 r
.55743 .12214 .56522 .13785 .58027 .15082 .57247 .136 Metetra
0 .095 .652 r
.57247 .136 .58027 .15082 .59562 .16572 .58784 .15254 Metetra
0 .016 .581 r
.58784 .15254 .59562 .16572 .6113 .18179 .60357 .17099 Metetra
0 0 .508 r
.60357 .17099 .6113 .18179 .62729 .19798 .61966 .19017 Metetra
.556 .061 0 r
.61966 .19017 .62729 .19798 .64355 .21301 .63606 .20855 Metetra
.58 .034 0 r
.63606 .20855 .64355 .21301 .65999 .22546 .65269 .22431 Metetra
.528 0 0 r
.65269 .22431 .65999 .22546 .67651 .23396 .66943 .23562 Metetra
.37 0 0 r
.66943 .23562 .67651 .23396 .693 .23737 .68612 .24093 Metetra
.07 0 0 r
.68612 .24093 .693 .23737 .70932 .23489 .70262 .2391 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.23703 .17687 m
.2415 .18167 L
s
[(2)] .22808 .16727 .93173 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(4)] .44535 .08183 .79274 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(6)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.08568 .23614 m
.08851 .23887 L
s
.13514 .21677 m
.13793 .21955 L
s
.18558 .19702 m
.18832 .19985 L
s
.28951 .15632 m
.29214 .15925 L
s
.34306 .13535 m
.34564 .13834 L
s
.39772 .11395 m
.40023 .11699 L
s
.51046 .06981 m
.51284 .07294 L
s
.56863 .04703 m
.57093 .05022 L
s
.62804 .02377 m
.63027 .02701 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S3.9.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[30]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell["\<\
This finds a numerical solution to a nonlinear wave equation. \
\
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.49"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[ {D[u[t, x], t, t] == D[u[t, x], x, x] + (1 - u[t, x]^2)(1 \
+ 2u[t, x]), u[0, x] == Exp[-x^2], Derivative[1, 0][u][0, x] == 0, u[t, -10] \
== u[t, 10]}, u, {t, 0, 10}, {x, -10, 10}]\
\>", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S3.9.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{0.`, 10.`}, {"...", \(-10.`\), 
                  10.`, "..."}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[31]= ",
  CellTags->"S3.9.7"]
}, Open  ]],

Cell["Here is a 3D plot of the result. ", "MathCaption",
  CellTags->{"S3.9.7", "7.50"}],

Cell[CellGroupData[{

Cell["\<\
Plot3D[Evaluate[u[t, x] /. First[%]], {t, 0, 10}, {x, -10, 10}, \
PlotPoints->80]\
\>", "Input",
  CellLabel->"In[32]:= ",
  CellTags->"S3.9.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
2.50451e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.14598 .19958 -5.96199 -9 ]
[.14598 .19958 .03801 0 ]
[.27013 .15073 -5.7118 -9 ]
[.27013 .15073 .2882 0 ]
[.40046 .09948 -5.46161 -9 ]
[.40046 .09948 .53839 0 ]
[.53743 .04564 -5.21142 -9 ]
[.53743 .04564 .78858 0 ]
[.68156 -0.01098 -9.92245 -9 ]
[.68156 -0.01098 2.07755 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 18 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 12 3.14607 ]
[.02399 .2659 -12 -2.74298 ]
[.02399 .2659 0 6.25702 ]
[.01222 .33964 -6 -2.80538 ]
[.01222 .33964 0 6.19462 ]
[-0.00012 .417 -6 -2.87115 ]
[-0.00012 .417 0 6.12885 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.1552 .20892 m
.15981 .21359 L
s
[(2)] .14598 .19958 .98733 1 Mshowa
.27893 .16047 m
.28333 .16533 L
s
[(4)] .27013 .15073 .90393 1 Mshowa
.40878 .10962 m
.41294 .11469 L
s
[(6)] .40046 .09948 .82054 1 Mshowa
.54521 .0562 m
.54911 .06148 L
s
[(8)] .53743 .04564 .73714 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(10)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.18558 .19702 m
.18832 .19985 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.3108 .14799 m
.31341 .15094 L
s
.34306 .13535 m
.34564 .13834 L
s
.37572 .12257 m
.37826 .12558 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.51046 .06981 m
.51284 .07294 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-10)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-5)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(5)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(10)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03621 .26112 m
.04232 .25874 L
s
[(-1)] .02399 .2659 1 -0.39045 Mshowa
.0245 .33501 m
.03064 .3327 L
s
[(0)] .01222 .33964 1 -0.37658 Mshowa
.01222 .41253 m
.01839 .4103 L
s
[(1)] -0.00012 .417 1 -0.36197 Mshowa
.125 Mabswid
.03391 .27562 m
.03758 .2742 L
s
.03159 .29026 m
.03527 .28885 L
s
.02925 .30504 m
.03293 .30363 L
s
.02689 .31995 m
.03057 .31856 L
s
.02209 .35022 m
.02578 .34884 L
s
.01966 .36557 m
.02335 .3642 L
s
.0172 .38107 m
.0209 .37971 L
s
.01472 .39673 m
.01842 .39538 L
s
.00969 .4285 m
.01339 .42717 L
s
.00713 .44462 m
.01084 .4433 L
s
.00455 .4609 m
.00826 .45959 L
s
.00195 .47735 m
.00566 .47605 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.623 .739 .93 r
.3988 .66835 .40274 .67186 .40933 .67052 .4054 .667 Metetra
.53 .708 .953 r
.4054 .667 .40933 .67052 .4159 .67029 .41197 .66677 Metetra
.393 .649 .96 r
.41197 .66677 .4159 .67029 .42245 .67125 .41854 .66772 Metetra
.193 .543 .928 r
.41854 .66772 .42245 .67125 .429 .67347 .42509 .66994 Metetra
0 .369 .821 r
.42509 .66994 .429 .67347 .43555 .6771 .43165 .67357 Metetra
0 .145 .629 r
.43165 .67357 .43555 .6771 .4421 .68227 .4382 .67874 Metetra
.588 .071 0 r
.4382 .67874 .4421 .68227 .44865 .68912 .44475 .68559 Metetra
.73 .23 0 r
.44475 .68559 .44865 .68912 .45522 .69773 .45132 .69421 Metetra
.807 .331 0 r
.45132 .69421 .45522 .69773 .46182 .70801 .45791 .7045 Metetra
.843 .384 0 r
.45791 .7045 .46182 .70801 .46846 .71958 .46455 .71607 Metetra
.85 .395 .013 r
.46455 .71607 .46846 .71958 .47517 .73155 .47125 .72805 Metetra
.818 .346 0 r
.47125 .72805 .47517 .73155 .48196 .74245 .47804 .73896 Metetra
.654 .14 0 r
.47804 .73896 .48196 .74245 .48885 .75033 .48493 .74684 Metetra
.078 .479 .893 r
.48493 .74684 .48885 .75033 .49583 .75326 .49192 .74977 Metetra
.712 .774 .901 r
.49192 .74977 .49583 .75326 .50289 .75015 .49899 .74665 Metetra
.849 .778 .782 r
.49899 .74665 .50289 .75015 .50999 .74127 .50611 .73775 Metetra
.885 .767 .726 r
.50611 .73775 .50999 .74127 .51708 .72811 .51323 .72457 Metetra
.897 .761 .704 r
.51323 .72457 .51708 .72811 .52415 .71269 .52032 .70912 Metetra
.899 .76 .699 r
.52032 .70912 .52415 .71269 .53119 .69682 .52738 .69322 Metetra
.896 .762 .705 r
.52738 .69322 .53119 .69682 .53818 .68173 .53441 .67811 Metetra
.889 .765 .719 r
.53441 .67811 .53818 .68173 .54516 .66812 .5414 .66447 Metetra
.878 .769 .737 r
.5414 .66447 .54516 .66812 .55211 .65622 .54838 .65255 Metetra
.864 .773 .759 r
.54838 .65255 .55211 .65622 .55907 .64606 .55536 .64236 Metetra
.845 .775 .784 r
.55536 .64236 .55907 .64606 .56602 .63752 .56233 .63381 Metetra
.822 .777 .81 r
.56233 .63381 .56602 .63752 .57299 .63048 .56931 .62675 Metetra
.795 .776 .836 r
.56931 .62675 .57299 .63048 .57998 .62479 .57632 .62105 Metetra
.761 .772 .863 r
.57632 .62105 .57998 .62479 .58699 .62034 .58334 .61659 Metetra
.718 .764 .889 r
.58334 .61659 .58699 .62034 .59403 .61706 .5904 .6133 Metetra
.665 .75 .914 r
.5904 .6133 .59403 .61706 .60111 .6149 .59749 .61113 Metetra
.595 .727 .936 r
.59749 .61113 .60111 .6149 .60824 .61387 .60463 .61009 Metetra
.501 .689 .952 r
.60463 .61009 .60824 .61387 .61542 .614 .61182 .61021 Metetra
.372 .626 .952 r
.61182 .61021 .61542 .614 .62266 .61537 .61907 .61157 Metetra
.199 .527 .921 r
.61907 .61157 .62266 .61537 .62998 .61808 .6264 .61428 Metetra
0 .384 .841 r
.6264 .61428 .62998 .61808 .63738 .62227 .63381 .61847 Metetra
0 .206 .704 r
.63381 .61847 .63738 .62227 .64489 .6281 .64132 .6243 Metetra
0 .026 .537 r
.64132 .6243 .64489 .6281 .65251 .63568 .64894 .63189 Metetra
.61 .121 0 r
.64894 .63189 .65251 .63568 .66026 .64506 .6567 .64126 Metetra
.701 .218 0 r
.6567 .64126 .66026 .64506 .66815 .65603 .66458 .65225 Metetra
.741 .266 0 r
.66458 .65225 .66815 .65603 .67615 .66804 .67259 .66426 Metetra
.732 .255 0 r
.67259 .66426 .67615 .66804 .68424 .67994 .68067 .67618 Metetra
.634 .144 0 r
.68067 .67618 .68424 .67994 .69231 .69002 .68875 .68626 Metetra
0 .2 .698 r
.68875 .68626 .69231 .69002 .70027 .6962 .69671 .69244 Metetra
.455 .678 .961 r
.69671 .69244 .70027 .6962 .70798 .69674 .70444 .69298 Metetra
.794 .794 .853 r
.70444 .69298 .70798 .69674 .71539 .69104 .71187 .68726 Metetra
.883 .793 .756 r
.71187 .68726 .71539 .69104 .7225 .67992 .719 .67612 Metetra
.911 .785 .709 r
.719 .67612 .7225 .67992 .72938 .66522 .72591 .66139 Metetra
.919 .781 .692 r
.72591 .66139 .72938 .66522 .73614 .64899 .73269 .64513 Metetra
.919 .781 .692 r
.73269 .64513 .73614 .64899 .74285 .63287 .73943 .62898 Metetra
.914 .784 .704 r
.73943 .62898 .74285 .63287 .7496 .61789 .7462 .61398 Metetra
.903 .787 .722 r
.7462 .61398 .7496 .61789 .75642 .60456 .75305 .60061 Metetra
.889 .79 .746 r
.75305 .60061 .75642 .60456 .76334 .593 .75999 .58904 Metetra
.87 .792 .772 r
.75999 .58904 .76334 .593 .77036 .58319 .76703 .5792 Metetra
.846 .793 .799 r
.76703 .5792 .77036 .58319 .77749 .57498 .77417 .57098 Metetra
.818 .791 .826 r
.77417 .57098 .77749 .57498 .78472 .56823 .78142 .56422 Metetra
.785 .785 .853 r
.78142 .56422 .78472 .56823 .79205 .56282 .78877 .55879 Metetra
.745 .776 .878 r
.78877 .55879 .79205 .56282 .79949 .55864 .79623 .5546 Metetra
.698 .762 .901 r
.79623 .5546 .79949 .55864 .80704 .55563 .80379 .55157 Metetra
.641 .742 .922 r
.80379 .55157 .80704 .55563 .81471 .55376 .81147 .54969 Metetra
.57 .712 .938 r
.81147 .54969 .81471 .55376 .82249 .55304 .81927 .54897 Metetra
.479 .669 .947 r
.81927 .54897 .82249 .55304 .83042 .55354 .82721 .54945 Metetra
.365 .607 .942 r
.82721 .54945 .83042 .55354 .8385 .55533 .8353 .55124 Metetra
.223 .52 .915 r
.8353 .55124 .8385 .55533 .84675 .55855 .84357 .55444 Metetra
.056 .408 .86 r
.84357 .55444 .84675 .55855 .85521 .56333 .85203 .55919 Metetra
0 .277 .775 r
.85203 .55919 .85521 .56333 .86389 .56981 .86071 .56564 Metetra
0 .146 .672 r
.86071 .56564 .86389 .56981 .87281 .57808 .86964 .57386 Metetra
0 .036 .575 r
.86964 .57386 .87281 .57808 .88199 .58808 .87882 .5838 Metetra
0 0 .507 r
.87882 .5838 .88199 .58808 .8914 .59947 .88822 .59512 Metetra
0 0 .487 r
.88822 .59512 .8914 .59947 .90096 .61143 .89778 .60705 Metetra
0 0 .536 r
.89778 .60705 .90096 .61143 .91052 .62261 .90736 .61827 Metetra
0 .154 .682 r
.90736 .61827 .91052 .62261 .91987 .63115 .91673 .62696 Metetra
.14 .466 .891 r
.91673 .62696 .91987 .63115 .92876 .63515 .92567 .63122 Metetra
.603 .748 .946 r
.92567 .63122 .92876 .63515 .93702 .6334 .93398 .62978 Metetra
.838 .837 .845 r
.93398 .62978 .93702 .6334 .94461 .62593 .94163 .62256 Metetra
.919 .844 .754 r
.94163 .62256 .94461 .62593 .95165 .61402 .9487 .61071 Metetra
.945 .837 .706 r
.9487 .61071 .95165 .61402 .95834 .59955 .95539 .59606 Metetra
.949 .828 .69 r
.95539 .59606 .95834 .59955 .96489 .5843 .96191 .58035 Metetra
.941 .815 .692 r
.96191 .58035 .96489 .5843 .97145 .56946 .96841 .56477 Metetra
.923 .795 .7 r
.96841 .56477 .97145 .56946 .9781 .55558 .97495 .54988 Metetra
.899 .766 .706 r
.97495 .54988 .9781 .55558 .98485 .54263 .98155 .53572 Metetra
.623 .739 .93 r
.39484 .66483 .3988 .66835 .4054 .667 .40145 .66347 Metetra
.53 .708 .953 r
.40145 .66347 .4054 .667 .41197 .66677 .40803 .66323 Metetra
.393 .649 .96 r
.40803 .66323 .41197 .66677 .41854 .66772 .41461 .66417 Metetra
.193 .543 .928 r
.41461 .66417 .41854 .66772 .42509 .66994 .42117 .66639 Metetra
0 .369 .821 r
.42117 .66639 .42509 .66994 .43165 .67357 .42772 .67002 Metetra
0 .145 .629 r
.42772 .67002 .43165 .67357 .4382 .67874 .43427 .67519 Metetra
.588 .071 0 r
.43427 .67519 .4382 .67874 .44475 .68559 .44083 .68205 Metetra
.73 .23 0 r
.44083 .68205 .44475 .68559 .45132 .69421 .4474 .69066 Metetra
.807 .331 0 r
.4474 .69066 .45132 .69421 .45791 .7045 .45399 .70096 Metetra
.843 .384 0 r
.45399 .70096 .45791 .7045 .46455 .71607 .46062 .71254 Metetra
.85 .395 .013 r
.46062 .71254 .46455 .71607 .47125 .72805 .46732 .72453 Metetra
.818 .346 0 r
.46732 .72453 .47125 .72805 .47804 .73896 .4741 .73545 Metetra
.654 .14 0 r
.4741 .73545 .47804 .73896 .48493 .74684 .48099 .74334 Metetra
.078 .479 .893 r
.48099 .74334 .48493 .74684 .49192 .74977 .48799 .74627 Metetra
.712 .774 .901 r
.48799 .74627 .49192 .74977 .49899 .74665 .49507 .74314 Metetra
.849 .778 .782 r
.49507 .74314 .49899 .74665 .50611 .73775 .50221 .73422 Metetra
.885 .767 .726 r
.50221 .73422 .50611 .73775 .51323 .72457 .50935 .72101 Metetra
.897 .761 .704 r
.50935 .72101 .51323 .72457 .52032 .70912 .51647 .70553 Metetra
.899 .76 .699 r
.51647 .70553 .52032 .70912 .52738 .69322 .52356 .6896 Metetra
.896 .762 .705 r
.52356 .6896 .52738 .69322 .53441 .67811 .53061 .67447 Metetra
.889 .765 .719 r
.53061 .67447 .53441 .67811 .5414 .66447 .53763 .6608 Metetra
.878 .769 .737 r
.53763 .6608 .5414 .66447 .54838 .65255 .54464 .64886 Metetra
.864 .773 .759 r
.54464 .64886 .54838 .65255 .55536 .64236 .55163 .63865 Metetra
.845 .775 .784 r
.55163 .63865 .55536 .64236 .56233 .63381 .55862 .63009 Metetra
.822 .777 .81 r
.55862 .63009 .56233 .63381 .56931 .62675 .56562 .62301 Metetra
.795 .776 .836 r
.56562 .62301 .56931 .62675 .57632 .62105 .57264 .61729 Metetra
.761 .772 .863 r
.57264 .61729 .57632 .62105 .58334 .61659 .57968 .61282 Metetra
.718 .764 .889 r
.57968 .61282 .58334 .61659 .5904 .6133 .58675 .60951 Metetra
.665 .75 .914 r
.58675 .60951 .5904 .6133 .59749 .61113 .59386 .60734 Metetra
.595 .727 .936 r
.59386 .60734 .59749 .61113 .60463 .61009 .60101 .60629 Metetra
.501 .689 .952 r
.60101 .60629 .60463 .61009 .61182 .61021 .60821 .60641 Metetra
.372 .626 .952 r
.60821 .60641 .61182 .61021 .61907 .61157 .61547 .60776 Metetra
.199 .527 .921 r
.61547 .60776 .61907 .61157 .6264 .61428 .6228 .61047 Metetra
0 .384 .841 r
.6228 .61047 .6264 .61428 .63381 .61847 .63021 .61466 Metetra
0 .206 .704 r
.63021 .61466 .63381 .61847 .64132 .6243 .63773 .62048 Metetra
0 .026 .537 r
.63773 .62048 .64132 .6243 .64894 .63189 .64536 .62807 Metetra
.61 .121 0 r
.64536 .62807 .64894 .63189 .6567 .64126 .65312 .63746 Metetra
.701 .218 0 r
.65312 .63746 .6567 .64126 .66458 .65225 .661 .64844 Metetra
.741 .266 0 r
.661 .64844 .66458 .65225 .67259 .66426 .66901 .66047 Metetra
.732 .255 0 r
.66901 .66047 .67259 .66426 .68067 .67618 .6771 .67239 Metetra
.634 .144 0 r
.6771 .67239 .68067 .67618 .68875 .68626 .68518 .68249 Metetra
0 .2 .698 r
.68518 .68249 .68875 .68626 .69671 .69244 .69314 .68867 Metetra
.455 .678 .961 r
.69314 .68867 .69671 .69244 .70444 .69298 .70089 .6892 Metetra
.794 .794 .853 r
.70089 .6892 .70444 .69298 .71187 .68726 .70833 .68346 Metetra
.883 .793 .756 r
.70833 .68346 .71187 .68726 .719 .67612 .71548 .6723 Metetra
.911 .785 .709 r
.71548 .6723 .719 .67612 .72591 .66139 .72241 .65754 Metetra
.919 .781 .692 r
.72241 .65754 .72591 .66139 .73269 .64513 .72922 .64125 Metetra
.919 .781 .692 r
.72922 .64125 .73269 .64513 .73943 .62898 .73599 .62507 Metetra
.914 .784 .704 r
.73599 .62507 .73943 .62898 .7462 .61398 .74279 .61004 Metetra
.903 .787 .722 r
.74279 .61004 .7462 .61398 .75305 .60061 .74966 .59666 Metetra
.889 .79 .746 r
.74966 .59666 .75305 .60061 .75999 .58904 .75662 .58506 Metetra
.87 .792 .772 r
.75662 .58506 .75999 .58904 .76703 .5792 .76368 .5752 Metetra
.846 .793 .799 r
.76368 .5752 .76703 .5792 .77417 .57098 .77084 .56696 Metetra
.818 .791 .826 r
.77084 .56696 .77417 .57098 .78142 .56422 .77811 .56018 Metetra
.785 .785 .853 r
.77811 .56018 .78142 .56422 .78877 .55879 .78547 .55474 Metetra
.745 .776 .878 r
.78547 .55474 .78877 .55879 .79623 .5546 .79295 .55053 Metetra
.698 .762 .902 r
.79295 .55053 .79623 .5546 .80379 .55157 .80053 .5475 Metetra
.641 .742 .922 r
.80053 .5475 .80379 .55157 .81147 .54969 .80822 .54561 Metetra
.57 .712 .938 r
.80822 .54561 .81147 .54969 .81927 .54897 .81603 .54487 Metetra
.481 .669 .946 r
.81603 .54487 .81927 .54897 .82721 .54945 .82398 .54534 Metetra
.368 .608 .942 r
.82398 .54534 .82721 .54945 .8353 .55124 .83208 .54709 Metetra
.231 .524 .916 r
.83208 .54709 .8353 .55124 .84357 .55444 .84035 .55024 Metetra
.074 .416 .865 r
.84035 .55024 .84357 .55444 .85203 .55919 .84882 .55491 Metetra
0 .294 .788 r
.84882 .55491 .85203 .55919 .86071 .56564 .8575 .56125 Metetra
0 .172 .698 r
.8575 .56125 .86071 .56564 .86964 .57386 .86642 .56932 Metetra
0 .069 .613 r
.86642 .56932 .86964 .57386 .87882 .5838 .87559 .57909 Metetra
0 0 .552 r
.87559 .57909 .87882 .5838 .88822 .59512 .88498 .59028 Metetra
0 0 .531 r
.88498 .59028 .88822 .59512 .89778 .60705 .89455 .60221 Metetra
0 .009 .563 r
.89455 .60221 .89778 .60705 .90736 .61827 .90415 .61365 Metetra
0 .136 .671 r
.90415 .61365 .90736 .61827 .91673 .62696 .91359 .62287 Metetra
.048 .408 .86 r
.91359 .62287 .91673 .62696 .92567 .63122 .92263 .6279 Metetra
.527 .751 .978 r
.92263 .6279 .92567 .63122 .93398 .62978 .93106 .62724 Metetra
.84 .897 .879 r
.93106 .62724 .93398 .62978 .94163 .62256 .93879 .6205 Metetra
.943 .898 .753 r
.93879 .6205 .94163 .62256 .9487 .61071 .94588 .60856 Metetra
.968 .87 .686 r
.94588 .60856 .9487 .61071 .95539 .59606 .9525 .59307 Metetra
.965 .836 .665 r
.9525 .59307 .95539 .59606 .96191 .58035 .95885 .57577 Metetra
.943 .793 .665 r
.95885 .57577 .96191 .58035 .96841 .56477 .96508 .55793 Metetra
.904 .74 .668 r
.96508 .55793 .96841 .56477 .97495 .54988 .97128 .54034 Metetra
.858 .686 .667 r
.97128 .54034 .97495 .54988 .98155 .53572 .97751 .52334 Metetra
.623 .739 .93 r
.39087 .66129 .39484 .66483 .40145 .66347 .39748 .65992 Metetra
.53 .708 .953 r
.39748 .65992 .40145 .66347 .40803 .66323 .40408 .65967 Metetra
.393 .649 .96 r
.40408 .65967 .40803 .66323 .41461 .66417 .41065 .66061 Metetra
.193 .543 .928 r
.41065 .66061 .41461 .66417 .42117 .66639 .41722 .66283 Metetra
0 .369 .821 r
.41722 .66283 .42117 .66639 .42772 .67002 .42378 .66645 Metetra
0 .145 .629 r
.42378 .66645 .42772 .67002 .43427 .67519 .43033 .67162 Metetra
.588 .071 0 r
.43033 .67162 .43427 .67519 .44083 .68205 .43689 .67848 Metetra
.73 .23 0 r
.43689 .67848 .44083 .68205 .4474 .69066 .44346 .68711 Metetra
.807 .331 0 r
.44346 .68711 .4474 .69066 .45399 .70096 .45004 .69741 Metetra
.843 .384 0 r
.45004 .69741 .45399 .70096 .46062 .71254 .45667 .709 Metetra
.85 .395 .013 r
.45667 .709 .46062 .71254 .46732 .72453 .46336 .721 Metetra
.818 .346 0 r
.46336 .721 .46732 .72453 .4741 .73545 .47014 .73193 Metetra
.654 .14 0 r
.47014 .73193 .4741 .73545 .48099 .74334 .47703 .73982 Metetra
.078 .479 .893 r
.47703 .73982 .48099 .74334 .48799 .74627 .48404 .74275 Metetra
.712 .774 .901 r
.48404 .74275 .48799 .74627 .49507 .74314 .49113 .7396 Metetra
.849 .778 .782 r
.49113 .7396 .49507 .74314 .50221 .73422 .49829 .73067 Metetra
.885 .767 .726 r
.49829 .73067 .50221 .73422 .50935 .72101 .50546 .71743 Metetra
.897 .761 .704 r
.50546 .71743 .50935 .72101 .51647 .70553 .51261 .70193 Metetra
.899 .76 .699 r
.51261 .70193 .51647 .70553 .52356 .6896 .51972 .68597 Metetra
.896 .762 .705 r
.51972 .68597 .52356 .6896 .53061 .67447 .5268 .67081 Metetra
.889 .765 .719 r
.5268 .67081 .53061 .67447 .53763 .6608 .53385 .65712 Metetra
.878 .769 .737 r
.53385 .65712 .53763 .6608 .54464 .64886 .54087 .64515 Metetra
.864 .773 .759 r
.54087 .64515 .54464 .64886 .55163 .63865 .54788 .63493 Metetra
.845 .775 .784 r
.54788 .63493 .55163 .63865 .55862 .63009 .55489 .62634 Metetra
.822 .777 .81 r
.55489 .62634 .55862 .63009 .56562 .62301 .56191 .61925 Metetra
.795 .776 .836 r
.56191 .61925 .56562 .62301 .57264 .61729 .56895 .61352 Metetra
.761 .772 .863 r
.56895 .61352 .57264 .61729 .57968 .61282 .576 .60903 Metetra
.718 .764 .889 r
.576 .60903 .57968 .61282 .58675 .60951 .58309 .60572 Metetra
.665 .75 .914 r
.58309 .60572 .58675 .60951 .59386 .60734 .5902 .60353 Metetra
.595 .727 .936 r
.5902 .60353 .59386 .60734 .60101 .60629 .59736 .60247 Metetra
.501 .689 .952 r
.59736 .60247 .60101 .60629 .60821 .60641 .60457 .60258 Metetra
.372 .626 .952 r
.60457 .60258 .60821 .60641 .61547 .60776 .61184 .60393 Metetra
.199 .527 .921 r
.61184 .60393 .61547 .60776 .6228 .61047 .61918 .60663 Metetra
0 .384 .841 r
.61918 .60663 .6228 .61047 .63021 .61466 .62661 .61082 Metetra
0 .206 .704 r
.62661 .61082 .63021 .61466 .63773 .62048 .63413 .61665 Metetra
0 .026 .537 r
.63413 .61665 .63773 .62048 .64536 .62807 .64176 .62424 Metetra
.61 .121 0 r
.64176 .62424 .64536 .62807 .65312 .63746 .64952 .63363 Metetra
.701 .218 0 r
.64952 .63363 .65312 .63746 .661 .64844 .65741 .64462 Metetra
.741 .266 0 r
.65741 .64462 .661 .64844 .66901 .66047 .66541 .65666 Metetra
.732 .255 0 r
.66541 .65666 .66901 .66047 .6771 .67239 .6735 .66859 Metetra
.634 .144 0 r
.6735 .66859 .6771 .67239 .68518 .68249 .68158 .67869 Metetra
0 .2 .698 r
.68158 .67869 .68518 .68249 .69314 .68867 .68956 .68487 Metetra
.455 .678 .961 r
.68956 .68487 .69314 .68867 .70089 .6892 .69731 .68539 Metetra
.794 .794 .853 r
.69731 .68539 .70089 .6892 .70833 .68346 .70477 .67965 Metetra
.883 .793 .756 r
.70477 .67965 .70833 .68346 .71548 .6723 .71195 .66846 Metetra
.911 .785 .709 r
.71195 .66846 .71548 .6723 .72241 .65754 .7189 .65367 Metetra
.919 .781 .692 r
.7189 .65367 .72241 .65754 .72922 .64125 .72574 .63735 Metetra
.919 .781 .692 r
.72574 .63735 .72922 .64125 .73599 .62507 .73253 .62115 Metetra
.914 .784 .704 r
.73253 .62115 .73599 .62507 .74279 .61004 .73935 .60609 Metetra
.903 .787 .722 r
.73935 .60609 .74279 .61004 .74966 .59666 .74625 .59268 Metetra
.889 .79 .746 r
.74625 .59268 .74966 .59666 .75662 .58506 .75323 .58106 Metetra
.87 .793 .772 r
.75323 .58106 .75662 .58506 .76368 .5752 .76031 .57118 Metetra
.846 .793 .799 r
.76031 .57118 .76368 .5752 .77084 .56696 .76749 .56292 Metetra
.818 .791 .826 r
.76749 .56292 .77084 .56696 .77811 .56018 .77478 .55613 Metetra
.785 .786 .853 r
.77478 .55613 .77811 .56018 .78547 .55474 .78216 .55067 Metetra
.745 .776 .878 r
.78216 .55067 .78547 .55474 .79295 .55053 .78965 .54645 Metetra
.698 .762 .901 r
.78965 .54645 .79295 .55053 .80053 .5475 .79724 .5434 Metetra
.641 .742 .922 r
.79724 .5434 .80053 .5475 .80822 .54561 .80495 .54149 Metetra
.572 .712 .937 r
.80495 .54149 .80822 .54561 .81603 .54487 .81278 .54072 Metetra
.486 .67 .945 r
.81278 .54072 .81603 .54487 .82398 .54534 .82073 .54113 Metetra
.38 .611 .94 r
.82073 .54113 .82398 .54534 .83208 .54709 .82884 .54281 Metetra
.254 .532 .918 r
.82884 .54281 .83208 .54709 .84035 .55024 .83711 .54584 Metetra
.113 .433 .874 r
.83711 .54584 .84035 .55024 .84882 .55491 .84557 .55035 Metetra
0 .321 .808 r
.84557 .55035 .84882 .55491 .8575 .56125 .85424 .5565 Metetra
0 .207 .73 r
.85424 .5565 .8575 .56125 .86642 .56932 .86315 .56438 Metetra
0 .104 .649 r
.86315 .56438 .86642 .56932 .87559 .57909 .87231 .57402 Metetra
0 .021 .578 r
.87231 .57402 .87559 .57909 .88498 .59028 .88171 .58525 Metetra
0 0 .528 r
.88171 .58525 .88498 .59028 .89455 .60221 .89131 .5975 Metetra
0 0 .514 r
.89131 .5975 .89455 .60221 .90415 .61365 .901 .60963 Metetra
0 .028 .562 r
.901 .60963 .90415 .61365 .91359 .62287 .91056 .61985 Metetra
0 .257 .729 r
.91056 .61985 .91359 .62287 .92263 .6279 .91974 .62596 Metetra
.336 .743 .981 r
.91974 .62596 .92263 .6279 .93106 .62724 .92827 .62601 Metetra
.841 .969 .882 r
.92827 .62601 .93106 .62724 .93879 .6205 .93601 .61913 Metetra
.961 .913 .72 r
.93601 .61913 .93879 .6205 .94588 .60856 .94298 .60594 Metetra
.971 .843 .658 r
.94298 .60594 .94588 .60856 .9525 .59307 .94935 .58814 Metetra
.947 .78 .642 r
.94935 .58814 .9525 .59307 .95885 .57577 .95534 .56781 Metetra
.906 .721 .641 r
.95534 .56781 .95885 .57577 .96508 .55793 .96117 .54674 Metetra
.861 .669 .642 r
.96117 .54674 .96508 .55793 .97128 .54034 .967 .52622 Metetra
.82 .628 .643 r
.967 .52622 .97128 .54034 .97751 .52334 .97295 .5071 Metetra
.623 .739 .93 r
.38687 .65773 .39087 .66129 .39748 .65992 .3935 .65635 Metetra
.53 .708 .953 r
.3935 .65635 .39748 .65992 .40408 .65967 .4001 .6561 Metetra
.393 .649 .96 r
.4001 .6561 .40408 .65967 .41065 .66061 .40668 .65704 Metetra
.193 .543 .928 r
.40668 .65704 .41065 .66061 .41722 .66283 .41326 .65925 Metetra
0 .369 .821 r
.41326 .65925 .41722 .66283 .42378 .66645 .41982 .66287 Metetra
0 .145 .629 r
.41982 .66287 .42378 .66645 .43033 .67162 .42638 .66804 Metetra
.588 .071 0 r
.42638 .66804 .43033 .67162 .43689 .67848 .43293 .6749 Metetra
.73 .23 0 r
.43293 .6749 .43689 .67848 .44346 .68711 .4395 .68353 Metetra
.807 .331 0 r
.4395 .68353 .44346 .68711 .45004 .69741 .44608 .69384 Metetra
.843 .384 0 r
.44608 .69384 .45004 .69741 .45667 .709 .4527 .70544 Metetra
.85 .395 .013 r
.4527 .70544 .45667 .709 .46336 .721 .45939 .71745 Metetra
.818 .346 0 r
.45939 .71745 .46336 .721 .47014 .73193 .46617 .72839 Metetra
.654 .14 0 r
.46617 .72839 .47014 .73193 .47703 .73982 .47306 .73628 Metetra
.078 .479 .893 r
.47306 .73628 .47703 .73982 .48404 .74275 .48007 .73921 Metetra
.712 .774 .901 r
.48007 .73921 .48404 .74275 .49113 .7396 .48718 .73605 Metetra
.849 .778 .782 r
.48718 .73605 .49113 .7396 .49829 .73067 .49435 .7271 Metetra
.885 .767 .726 r
.49435 .7271 .49829 .73067 .50546 .71743 .50155 .71384 Metetra
.897 .761 .704 r
.50155 .71384 .50546 .71743 .51261 .70193 .50872 .69831 Metetra
.899 .76 .699 r
.50872 .69831 .51261 .70193 .51972 .68597 .51587 .68232 Metetra
.896 .762 .705 r
.51587 .68232 .51972 .68597 .5268 .67081 .52297 .66713 Metetra
.889 .765 .719 r
.52297 .66713 .5268 .67081 .53385 .65712 .53004 .65341 Metetra
.878 .769 .737 r
.53004 .65341 .53385 .65712 .54087 .64515 .53709 .64143 Metetra
.864 .773 .759 r
.53709 .64143 .54087 .64515 .54788 .63493 .54412 .63118 Metetra
.845 .775 .784 r
.54412 .63118 .54788 .63493 .55489 .62634 .55115 .62258 Metetra
.822 .777 .81 r
.55115 .62258 .55489 .62634 .56191 .61925 .55819 .61547 Metetra
.795 .776 .836 r
.55819 .61547 .56191 .61925 .56895 .61352 .56524 .60972 Metetra
.761 .772 .863 r
.56524 .60972 .56895 .61352 .576 .60903 .57231 .60523 Metetra
.718 .764 .889 r
.57231 .60523 .576 .60903 .58309 .60572 .5794 .6019 Metetra
.665 .75 .914 r
.5794 .6019 .58309 .60572 .5902 .60353 .58653 .5997 Metetra
.595 .727 .936 r
.58653 .5997 .5902 .60353 .59736 .60247 .59371 .59864 Metetra
.501 .689 .952 r
.59371 .59864 .59736 .60247 .60457 .60258 .60093 .59874 Metetra
.372 .626 .952 r
.60093 .59874 .60457 .60258 .61184 .60393 .6082 .60009 Metetra
.199 .527 .921 r
.6082 .60009 .61184 .60393 .61918 .60663 .61555 .60278 Metetra
0 .384 .841 r
.61555 .60278 .61918 .60663 .62661 .61082 .62298 .60697 Metetra
0 .206 .704 r
.62298 .60697 .62661 .61082 .63413 .61665 .6305 .61279 Metetra
0 .026 .537 r
.6305 .61279 .63413 .61665 .64176 .62424 .63814 .62039 Metetra
.61 .121 0 r
.63814 .62039 .64176 .62424 .64952 .63363 .6459 .62978 Metetra
.701 .218 0 r
.6459 .62978 .64952 .63363 .65741 .64462 .65379 .64078 Metetra
.741 .266 0 r
.65379 .64078 .65741 .64462 .66541 .65666 .6618 .65282 Metetra
.732 .255 0 r
.6618 .65282 .66541 .65666 .6735 .66859 .66988 .66477 Metetra
.634 .144 0 r
.66988 .66477 .6735 .66859 .68158 .67869 .67797 .67487 Metetra
0 .2 .698 r
.67797 .67487 .68158 .67869 .68956 .68487 .68595 .68106 Metetra
.455 .678 .961 r
.68595 .68106 .68956 .68487 .69731 .68539 .69372 .68157 Metetra
.794 .794 .853 r
.69372 .68157 .69731 .68539 .70477 .67965 .7012 .67581 Metetra
.883 .793 .756 r
.7012 .67581 .70477 .67965 .71195 .66846 .70839 .6646 Metetra
.911 .785 .709 r
.70839 .6646 .71195 .66846 .7189 .65367 .71538 .64979 Metetra
.919 .781 .692 r
.71538 .64979 .7189 .65367 .72574 .63735 .72223 .63344 Metetra
.919 .781 .692 r
.72223 .63344 .72574 .63735 .73253 .62115 .72905 .6172 Metetra
.914 .784 .704 r
.72905 .6172 .73253 .62115 .73935 .60609 .7359 .60212 Metetra
.903 .787 .722 r
.7359 .60212 .73935 .60609 .74625 .59268 .74282 .58868 Metetra
.889 .79 .746 r
.74282 .58868 .74625 .59268 .75323 .58106 .74983 .57704 Metetra
.87 .793 .772 r
.74983 .57704 .75323 .58106 .76031 .57118 .75693 .56714 Metetra
.846 .793 .799 r
.75693 .56714 .76031 .57118 .76749 .56292 .76413 .55886 Metetra
.818 .791 .826 r
.76413 .55886 .76749 .56292 .77478 .55613 .77143 .55205 Metetra
.785 .786 .853 r
.77143 .55205 .77478 .55613 .78216 .55067 .77883 .54658 Metetra
.746 .776 .878 r
.77883 .54658 .78216 .55067 .78965 .54645 .78634 .54234 Metetra
.699 .762 .9 r
.78634 .54234 .78965 .54645 .79724 .5434 .79394 .53925 Metetra
.644 .741 .92 r
.79394 .53925 .79724 .5434 .80495 .54149 .80166 .53729 Metetra
.578 .711 .934 r
.80166 .53729 .80495 .54149 .81278 .54072 .80949 .53644 Metetra
.498 .67 .94 r
.80949 .53644 .81278 .54072 .82073 .54113 .81745 .53674 Metetra
.404 .614 .936 r
.81745 .53674 .82073 .54113 .82884 .54281 .82556 .53826 Metetra
.293 .542 .917 r
.82556 .53826 .82884 .54281 .83711 .54584 .83382 .5411 Metetra
.167 .452 .88 r
.83382 .5411 .83711 .54584 .84557 .55035 .84227 .54543 Metetra
.025 .346 .824 r
.84227 .54543 .84557 .55035 .85424 .5565 .85094 .55142 Metetra
0 .226 .746 r
.85094 .55142 .85424 .5565 .86315 .56438 .85985 .55928 Metetra
0 .099 .646 r
.85985 .55928 .86315 .56438 .87231 .57402 .86903 .56913 Metetra
0 0 .532 r
.86903 .56913 .87231 .57402 .88171 .58525 .8785 .58091 Metetra
.574 .126 0 r
.8785 .58091 .88171 .58525 .89131 .5975 .88821 .59412 Metetra
.663 .186 0 r
.88821 .59412 .89131 .5975 .901 .60963 .89804 .60755 Metetra
.688 .175 0 r
.89804 .60755 .901 .60963 .91056 .61985 .90776 .61908 Metetra
.576 .004 0 r
.90776 .61908 .91056 .61985 .91974 .62596 .91704 .62591 Metetra
.084 .644 .754 r
.91704 .62591 .91974 .62596 .92827 .62601 .92554 .6254 Metetra
.896 .98 .807 r
.92554 .6254 .92827 .62601 .93601 .61913 .93305 .61636 Metetra
.964 .845 .677 r
.93305 .61636 .93601 .61913 .94298 .60594 .93963 .59972 Metetra
.932 .753 .637 r
.93963 .59972 .94298 .60594 .94935 .58814 .94555 .5781 Metetra
.891 .692 .627 r
.94555 .5781 .94935 .58814 .95534 .56781 .95115 .55453 Metetra
.853 .65 .628 r
.95115 .55453 .95534 .56781 .96117 .54674 .95673 .53143 Metetra
.822 .622 .633 r
.95673 .53143 .96117 .54674 .967 .52622 .96248 .51029 Metetra
.798 .606 .641 r
.96248 .51029 .967 .52622 .97295 .5071 .96852 .49181 Metetra
.623 .739 .93 r
.38286 .65416 .38687 .65773 .3935 .65635 .38949 .65277 Metetra
.53 .708 .953 r
.38949 .65277 .3935 .65635 .4001 .6561 .3961 .65251 Metetra
.393 .649 .96 r
.3961 .65251 .4001 .6561 .40668 .65704 .4027 .65344 Metetra
.193 .543 .928 r
.4027 .65344 .40668 .65704 .41326 .65925 .40927 .65565 Metetra
0 .369 .821 r
.40927 .65565 .41326 .65925 .41982 .66287 .41584 .65927 Metetra
0 .145 .629 r
.41584 .65927 .41982 .66287 .42638 .66804 .4224 .66444 Metetra
.588 .071 0 r
.4224 .66444 .42638 .66804 .43293 .6749 .42896 .67131 Metetra
.73 .23 0 r
.42896 .67131 .43293 .6749 .4395 .68353 .43552 .67994 Metetra
.807 .331 0 r
.43552 .67994 .4395 .68353 .44608 .69384 .4421 .69026 Metetra
.843 .384 0 r
.4421 .69026 .44608 .69384 .4527 .70544 .44872 .70186 Metetra
.85 .395 .013 r
.44872 .70186 .4527 .70544 .45939 .71745 .4554 .71389 Metetra
.818 .346 0 r
.4554 .71389 .45939 .71745 .46617 .72839 .46217 .72483 Metetra
.654 .14 0 r
.46217 .72483 .46617 .72839 .47306 .73628 .46906 .73273 Metetra
.078 .479 .893 r
.46906 .73273 .47306 .73628 .48007 .73921 .47608 .73565 Metetra
.712 .774 .901 r
.47608 .73565 .48007 .73921 .48718 .73605 .4832 .73249 Metetra
.849 .778 .782 r
.4832 .73249 .48718 .73605 .49435 .7271 .4904 .72351 Metetra
.885 .767 .726 r
.4904 .72351 .49435 .7271 .50155 .71384 .49762 .71023 Metetra
.897 .761 .704 r
.49762 .71023 .50155 .71384 .50872 .69831 .50482 .69467 Metetra
.899 .76 .699 r
.50482 .69467 .50872 .69831 .51587 .68232 .51199 .67865 Metetra
.896 .762 .705 r
.51199 .67865 .51587 .68232 .52297 .66713 .51912 .66344 Metetra
.889 .765 .719 r
.51912 .66344 .52297 .66713 .53004 .65341 .52621 .6497 Metetra
.878 .769 .737 r
.52621 .6497 .53004 .65341 .53709 .64143 .53328 .63769 Metetra
.864 .773 .759 r
.53328 .63769 .53709 .64143 .54412 .63118 .54034 .62742 Metetra
.845 .775 .784 r
.54034 .62742 .54412 .63118 .55115 .62258 .54739 .6188 Metetra
.822 .777 .81 r
.54739 .6188 .55115 .62258 .55819 .61547 .55444 .61167 Metetra
.795 .776 .836 r
.55444 .61167 .55819 .61547 .56524 .60972 .56151 .60591 Metetra
.761 .772 .863 r
.56151 .60591 .56524 .60972 .57231 .60523 .56859 .6014 Metetra
.718 .764 .889 r
.56859 .6014 .57231 .60523 .5794 .6019 .5757 .59806 Metetra
.665 .75 .914 r
.5757 .59806 .5794 .6019 .58653 .5997 .58285 .59586 Metetra
.595 .727 .936 r
.58285 .59586 .58653 .5997 .59371 .59864 .59003 .59479 Metetra
.501 .689 .952 r
.59003 .59479 .59371 .59864 .60093 .59874 .59726 .59488 Metetra
.372 .626 .952 r
.59726 .59488 .60093 .59874 .6082 .60009 .60455 .59622 Metetra
.199 .527 .921 r
.60455 .59622 .6082 .60009 .61555 .60278 .6119 .59891 Metetra
0 .384 .841 r
.6119 .59891 .61555 .60278 .62298 .60697 .61934 .60309 Metetra
0 .206 .704 r
.61934 .60309 .62298 .60697 .6305 .61279 .62687 .60892 Metetra
0 .026 .537 r
.62687 .60892 .6305 .61279 .63814 .62039 .63451 .61652 Metetra
.61 .121 0 r
.63451 .61652 .63814 .62039 .6459 .62978 .64227 .62592 Metetra
.701 .218 0 r
.64227 .62592 .6459 .62978 .65379 .64078 .65016 .63693 Metetra
.741 .266 0 r
.65016 .63693 .65379 .64078 .6618 .65282 .65817 .64898 Metetra
.732 .255 0 r
.65817 .64898 .6618 .65282 .66988 .66477 .66625 .66093 Metetra
.634 .144 0 r
.66625 .66093 .66988 .66477 .67797 .67487 .67434 .67104 Metetra
0 .2 .698 r
.67434 .67104 .67797 .67487 .68595 .68106 .68233 .67722 Metetra
.455 .678 .961 r
.68233 .67722 .68595 .68106 .69372 .68157 .6901 .67773 Metetra
.794 .794 .853 r
.6901 .67773 .69372 .68157 .7012 .67581 .6976 .67195 Metetra
.883 .793 .756 r
.6976 .67195 .7012 .67581 .70839 .6646 .70482 .66072 Metetra
.911 .785 .709 r
.70482 .66072 .70839 .6646 .71538 .64979 .71183 .64588 Metetra
.919 .781 .692 r
.71183 .64588 .71538 .64979 .72223 .63344 .71871 .6295 Metetra
.919 .781 .692 r
.71871 .6295 .72223 .63344 .72905 .6172 .72556 .61324 Metetra
.914 .784 .704 r
.72556 .61324 .72905 .6172 .7359 .60212 .73244 .59813 Metetra
.903 .787 .722 r
.73244 .59813 .7359 .60212 .74282 .58868 .73938 .58466 Metetra
.889 .79 .746 r
.73938 .58466 .74282 .58868 .74983 .57704 .7464 .573 Metetra
.87 .793 .772 r
.7464 .573 .74983 .57704 .75693 .56714 .75353 .56308 Metetra
.847 .793 .799 r
.75353 .56308 .75693 .56714 .76413 .55886 .76075 .55478 Metetra
.818 .791 .826 r
.76075 .55478 .76413 .55886 .77143 .55205 .76807 .54794 Metetra
.785 .785 .852 r
.76807 .54794 .77143 .55205 .77883 .54658 .77548 .54243 Metetra
.747 .775 .876 r
.77548 .54243 .77883 .54658 .78634 .54234 .783 .53814 Metetra
.702 .76 .897 r
.783 .53814 .78634 .54234 .79394 .53925 .79062 .53497 Metetra
.65 .738 .914 r
.79062 .53497 .79394 .53925 .80166 .53729 .79834 .5329 Metetra
.589 .708 .925 r
.79834 .5329 .80166 .53729 .80949 .53644 .80617 .5319 Metetra
.518 .667 .93 r
.80617 .5319 .80949 .53644 .81745 .53674 .81413 .53203 Metetra
.433 .615 .926 r
.81413 .53203 .81745 .53674 .82556 .53826 .82223 .53337 Metetra
.329 .547 .911 r
.82223 .53337 .82556 .53826 .83382 .5411 .8305 .53608 Metetra
.195 .457 .879 r
.8305 .53608 .83382 .5411 .84227 .54543 .83895 .54038 Metetra
.02 .337 .818 r
.83895 .54038 .84227 .54543 .85094 .55142 .84764 .54655 Metetra
0 .178 .708 r
.84764 .54655 .85094 .55142 .85985 .55928 .85661 .5549 Metetra
0 0 .534 r
.85661 .5549 .85985 .55928 .86903 .56913 .86589 .56566 Metetra
.66 .184 0 r
.86589 .56566 .86903 .56913 .8785 .58091 .8755 .57881 Metetra
.783 .301 0 r
.8755 .57881 .8785 .58091 .88821 .59412 .8854 .59371 Metetra
.825 .347 .006 r
.8854 .59371 .88821 .59412 .89804 .60755 .89542 .60873 Metetra
.799 .315 .06 r
.89542 .60873 .89804 .60755 .90776 .61908 .90524 .62094 Metetra
.641 .111 0 r
.90524 .62094 .90776 .61908 .91704 .62591 .9144 .62653 Metetra
.448 .874 .771 r
.9144 .62653 .91704 .62591 .92554 .6254 .92251 .62247 Metetra
.946 .853 .719 r
.92251 .62247 .92554 .6254 .93305 .61636 .92946 .60842 Metetra
.906 .722 .642 r
.92946 .60842 .93305 .61636 .93963 .59972 .9355 .58706 Metetra
.866 .661 .623 r
.9355 .58706 .93963 .59972 .94555 .5781 .94107 .56251 Metetra
.837 .629 .622 r
.94107 .56251 .94555 .5781 .95115 .55453 .94659 .53825 Metetra
.818 .615 .629 r
.94659 .53825 .95115 .55453 .95673 .53143 .95233 .51635 Metetra
.808 .616 .643 r
.95233 .51635 .95673 .53143 .96248 .51029 .9584 .49764 Metetra
.807 .632 .665 r
.9584 .49764 .96248 .51029 .96852 .49181 .96485 .4822 Metetra
.623 .739 .93 r
.37883 .65057 .38286 .65416 .38949 .65277 .38547 .64917 Metetra
.53 .708 .953 r
.38547 .64917 .38949 .65277 .3961 .65251 .39209 .64891 Metetra
.393 .649 .96 r
.39209 .64891 .3961 .65251 .4027 .65344 .39869 .64983 Metetra
.193 .543 .928 r
.39869 .64983 .4027 .65344 .40927 .65565 .40527 .65204 Metetra
0 .369 .821 r
.40527 .65204 .40927 .65565 .41584 .65927 .41184 .65565 Metetra
0 .145 .629 r
.41184 .65565 .41584 .65927 .4224 .66444 .4184 .66083 Metetra
.588 .071 0 r
.4184 .66083 .4224 .66444 .42896 .67131 .42496 .66769 Metetra
.73 .23 0 r
.42496 .66769 .42896 .67131 .43552 .67994 .43152 .67633 Metetra
.807 .331 0 r
.43152 .67633 .43552 .67994 .4421 .69026 .4381 .68665 Metetra
.843 .384 0 r
.4381 .68665 .4421 .69026 .44872 .70186 .44471 .69827 Metetra
.85 .395 .013 r
.44471 .69827 .44872 .70186 .4554 .71389 .45139 .7103 Metetra
.818 .346 0 r
.45139 .7103 .4554 .71389 .46217 .72483 .45816 .72126 Metetra
.654 .14 0 r
.45816 .72126 .46217 .72483 .46906 .73273 .46505 .72916 Metetra
.078 .479 .893 r
.46505 .72916 .46906 .73273 .47608 .73565 .47207 .73208 Metetra
.712 .774 .901 r
.47207 .73208 .47608 .73565 .4832 .73249 .47921 .7289 Metetra
.849 .778 .782 r
.47921 .7289 .4832 .73249 .4904 .72351 .48642 .71991 Metetra
.885 .767 .726 r
.48642 .71991 .4904 .72351 .49762 .71023 .49367 .7066 Metetra
.897 .761 .704 r
.49367 .7066 .49762 .71023 .50482 .69467 .5009 .69101 Metetra
.899 .76 .699 r
.5009 .69101 .50482 .69467 .51199 .67865 .5081 .67497 Metetra
.896 .762 .705 r
.5081 .67497 .51199 .67865 .51912 .66344 .51525 .65973 Metetra
.889 .765 .719 r
.51525 .65973 .51912 .66344 .52621 .6497 .52237 .64596 Metetra
.878 .769 .737 r
.52237 .64596 .52621 .6497 .53328 .63769 .52946 .63393 Metetra
.864 .773 .759 r
.52946 .63393 .53328 .63769 .54034 .62742 .53654 .62364 Metetra
.845 .775 .784 r
.53654 .62364 .54034 .62742 .54739 .6188 .54361 .615 Metetra
.822 .777 .81 r
.54361 .615 .54739 .6188 .55444 .61167 .55068 .60786 Metetra
.795 .776 .836 r
.55068 .60786 .55444 .61167 .56151 .60591 .55776 .60208 Metetra
.761 .772 .863 r
.55776 .60208 .56151 .60591 .56859 .6014 .56486 .59756 Metetra
.718 .764 .889 r
.56486 .59756 .56859 .6014 .5757 .59806 .57199 .59421 Metetra
.665 .75 .914 r
.57199 .59421 .5757 .59806 .58285 .59586 .57914 .592 Metetra
.595 .727 .936 r
.57914 .592 .58285 .59586 .59003 .59479 .58633 .59091 Metetra
.501 .689 .952 r
.58633 .59091 .59003 .59479 .59726 .59488 .59357 .591 Metetra
.372 .626 .952 r
.59357 .591 .59726 .59488 .60455 .59622 .60087 .59233 Metetra
.199 .527 .921 r
.60087 .59233 .60455 .59622 .6119 .59891 .60823 .59502 Metetra
0 .384 .841 r
.60823 .59502 .6119 .59891 .61934 .60309 .61567 .5992 Metetra
0 .206 .704 r
.61567 .5992 .61934 .60309 .62687 .60892 .62321 .60503 Metetra
0 .026 .537 r
.62321 .60503 .62687 .60892 .63451 .61652 .63085 .61263 Metetra
.61 .121 0 r
.63085 .61263 .63451 .61652 .64227 .62592 .63862 .62203 Metetra
.701 .218 0 r
.63862 .62203 .64227 .62592 .65016 .63693 .64651 .63305 Metetra
.741 .266 0 r
.64651 .63305 .65016 .63693 .65817 .64898 .65452 .64511 Metetra
.732 .255 0 r
.65452 .64511 .65817 .64898 .66625 .66093 .6626 .65707 Metetra
.634 .144 0 r
.6626 .65707 .66625 .66093 .67434 .67104 .67069 .66719 Metetra
0 .2 .698 r
.67069 .66719 .67434 .67104 .68233 .67722 .67869 .67337 Metetra
.455 .678 .961 r
.67869 .67337 .68233 .67722 .6901 .67773 .68648 .67388 Metetra
.794 .794 .853 r
.68648 .67388 .6901 .67773 .6976 .67195 .69399 .66808 Metetra
.883 .793 .756 r
.69399 .66808 .6976 .67195 .70482 .66072 .70123 .65682 Metetra
.911 .785 .709 r
.70123 .65682 .70482 .66072 .71183 .64588 .70827 .64196 Metetra
.919 .781 .692 r
.70827 .64196 .71183 .64588 .71871 .6295 .71518 .62555 Metetra
.919 .781 .692 r
.71518 .62555 .71871 .6295 .72556 .61324 .72205 .60926 Metetra
.914 .784 .704 r
.72205 .60926 .72556 .61324 .73244 .59813 .72895 .59412 Metetra
.903 .787 .722 r
.72895 .59412 .73244 .59813 .73938 .58466 .73592 .58063 Metetra
.889 .79 .746 r
.73592 .58063 .73938 .58466 .7464 .573 .74297 .56894 Metetra
.87 .792 .772 r
.74297 .56894 .7464 .573 .75353 .56308 .75011 .55899 Metetra
.847 .792 .798 r
.75011 .55899 .75353 .56308 .76075 .55478 .75735 .55065 Metetra
.819 .789 .825 r
.75735 .55065 .76075 .55478 .76807 .54794 .76468 .54376 Metetra
.786 .782 .849 r
.76468 .54376 .76807 .54794 .77548 .54243 .77211 .53817 Metetra
.749 .771 .871 r
.77211 .53817 .77548 .54243 .783 .53814 .77964 .53376 Metetra
.706 .754 .889 r
.77964 .53376 .783 .53814 .79062 .53497 .78726 .53046 Metetra
.658 .73 .903 r
.78726 .53046 .79062 .53497 .79834 .5329 .79498 .52822 Metetra
.602 .7 .913 r
.79498 .52822 .79834 .5329 .80617 .5319 .80282 .52707 Metetra
.533 .661 .918 r
.80282 .52707 .80617 .5319 .81413 .53203 .81078 .52708 Metetra
.444 .609 .918 r
.81078 .52708 .81413 .53203 .82223 .53337 .81889 .52841 Metetra
.316 .536 .907 r
.81889 .52841 .82223 .53337 .8305 .53608 .82718 .5313 Metetra
.12 .421 .866 r
.82718 .5313 .8305 .53608 .83895 .54038 .83569 .53608 Metetra
0 .233 .743 r
.83569 .53608 .83895 .54038 .84764 .54655 .84447 .54313 Metetra
0 0 .489 r
.84447 .54313 .84764 .54655 .85661 .5549 .85358 .55284 Metetra
.744 .244 0 r
.85358 .55284 .85661 .5549 .86589 .56566 .86306 .56545 Metetra
.836 .365 .039 r
.86306 .56545 .86589 .56566 .8755 .57881 .8729 .58075 Metetra
.85 .41 .17 r
.8729 .58075 .8755 .57881 .8854 .59371 .88302 .59754 Metetra
.826 .401 .229 r
.88302 .59754 .8854 .59371 .89542 .60873 .89312 .61309 Metetra
.755 .315 .207 r
.89312 .61309 .89542 .60873 .90524 .62094 .90273 .62317 Metetra
.351 0 0 r
.90273 .62317 .90524 .62094 .9144 .62653 .91134 .62361 Metetra
.913 .869 .781 r
.91134 .62361 .9144 .62653 .92251 .62247 .91871 .61287 Metetra
.873 .692 .654 r
.91871 .61287 .92251 .62247 .92946 .60842 .92503 .59332 Metetra
.838 .633 .626 r
.92503 .59332 .92946 .60842 .9355 .58706 .93079 .56954 Metetra
.818 .611 .622 r
.93079 .56954 .9355 .58706 .94107 .56251 .93645 .54569 Metetra
.81 .609 .631 r
.93645 .54569 .94107 .56251 .94659 .53825 .94232 .52424 Metetra
.814 .626 .649 r
.94232 .52424 .94659 .53825 .95233 .51635 .94854 .50614 Metetra
.83 .667 .68 r
.94854 .50614 .95233 .51635 .9584 .49764 .95515 .49143 Metetra
.864 .749 .734 r
.95515 .49143 .9584 .49764 .96485 .4822 .96213 .47978 Metetra
.623 .739 .93 r
.37478 .64696 .37883 .65057 .38547 .64917 .38143 .64556 Metetra
.53 .708 .953 r
.38143 .64556 .38547 .64917 .39209 .64891 .38806 .64529 Metetra
.393 .649 .96 r
.38806 .64529 .39209 .64891 .39869 .64983 .39467 .6462 Metetra
.193 .543 .928 r
.39467 .6462 .39869 .64983 .40527 .65204 .40125 .64841 Metetra
0 .369 .821 r
.40125 .64841 .40527 .65204 .41184 .65565 .40783 .65202 Metetra
0 .145 .629 r
.40783 .65202 .41184 .65565 .4184 .66083 .41439 .65719 Metetra
.588 .071 0 r
.41439 .65719 .4184 .66083 .42496 .66769 .42095 .66406 Metetra
.73 .23 0 r
.42095 .66406 .42496 .66769 .43152 .67633 .42751 .6727 Metetra
.807 .331 0 r
.42751 .6727 .43152 .67633 .4381 .68665 .43408 .68303 Metetra
.843 .384 0 r
.43408 .68303 .4381 .68665 .44471 .69827 .44069 .69466 Metetra
.85 .395 .013 r
.44069 .69466 .44471 .69827 .45139 .7103 .44736 .7067 Metetra
.818 .346 0 r
.44736 .7067 .45139 .7103 .45816 .72126 .45412 .71766 Metetra
.654 .14 0 r
.45412 .71766 .45816 .72126 .46505 .72916 .46102 .72557 Metetra
.078 .479 .893 r
.46102 .72557 .46505 .72916 .47207 .73208 .46804 .72849 Metetra
.712 .774 .901 r
.46804 .72849 .47207 .73208 .47921 .7289 .47519 .7253 Metetra
.849 .778 .782 r
.47519 .7253 .47921 .7289 .48642 .71991 .48243 .71629 Metetra
.885 .767 .726 r
.48243 .71629 .48642 .71991 .49367 .7066 .4897 .70295 Metetra
.897 .761 .704 r
.4897 .70295 .49367 .7066 .5009 .69101 .49696 .68734 Metetra
.899 .76 .699 r
.49696 .68734 .5009 .69101 .5081 .67497 .50418 .67127 Metetra
.896 .762 .705 r
.50418 .67127 .5081 .67497 .51525 .65973 .51137 .656 Metetra
.889 .765 .719 r
.51137 .656 .51525 .65973 .52237 .64596 .51851 .6422 Metetra
.878 .769 .737 r
.51851 .6422 .52237 .64596 .52946 .63393 .52563 .63015 Metetra
.864 .773 .759 r
.52563 .63015 .52946 .63393 .53654 .62364 .53272 .61984 Metetra
.845 .775 .784 r
.53272 .61984 .53654 .62364 .54361 .615 .53981 .61118 Metetra
.822 .777 .81 r
.53981 .61118 .54361 .615 .55068 .60786 .5469 .60403 Metetra
.795 .776 .836 r
.5469 .60403 .55068 .60786 .55776 .60208 .554 .59824 Metetra
.761 .772 .863 r
.554 .59824 .55776 .60208 .56486 .59756 .56111 .5937 Metetra
.718 .764 .889 r
.56111 .5937 .56486 .59756 .57199 .59421 .56825 .59034 Metetra
.665 .75 .914 r
.56825 .59034 .57199 .59421 .57914 .592 .57542 .58811 Metetra
.595 .727 .936 r
.57542 .58811 .57914 .592 .58633 .59091 .58262 .58702 Metetra
.501 .689 .952 r
.58262 .58702 .58633 .59091 .59357 .591 .58987 .5871 Metetra
.372 .626 .952 r
.58987 .5871 .59357 .591 .60087 .59233 .59718 .58843 Metetra
.199 .527 .921 r
.59718 .58843 .60087 .59233 .60823 .59502 .60455 .59111 Metetra
0 .384 .841 r
.60455 .59111 .60823 .59502 .61567 .5992 .612 .59529 Metetra
0 .206 .704 r
.612 .59529 .61567 .5992 .62321 .60503 .61954 .60112 Metetra
0 .026 .537 r
.61954 .60112 .62321 .60503 .63085 .61263 .62718 .60872 Metetra
.611 .121 0 r
.62718 .60872 .63085 .61263 .63862 .62203 .63495 .61813 Metetra
.701 .218 0 r
.63495 .61813 .63862 .62203 .64651 .63305 .64284 .62915 Metetra
.741 .266 0 r
.64284 .62915 .64651 .63305 .65452 .64511 .65085 .64122 Metetra
.732 .255 0 r
.65085 .64122 .65452 .64511 .6626 .65707 .65893 .65319 Metetra
.634 .144 0 r
.65893 .65319 .6626 .65707 .67069 .66719 .66703 .66332 Metetra
0 .2 .697 r
.66703 .66332 .67069 .66719 .67869 .67337 .67503 .6695 Metetra
.455 .678 .961 r
.67503 .6695 .67869 .67337 .68648 .67388 .68283 .67 Metetra
.794 .795 .853 r
.68283 .67 .68648 .67388 .69399 .66808 .69036 .66419 Metetra
.883 .793 .756 r
.69036 .66419 .69399 .66808 .70123 .65682 .69763 .65291 Metetra
.911 .785 .709 r
.69763 .65291 .70123 .65682 .70827 .64196 .70469 .63802 Metetra
.919 .781 .692 r
.70469 .63802 .70827 .64196 .71518 .62555 .71162 .62158 Metetra
.919 .781 .692 r
.71162 .62158 .71518 .62555 .72205 .60926 .71853 .60526 Metetra
.914 .784 .704 r
.71853 .60526 .72205 .60926 .72895 .59412 .72545 .59008 Metetra
.903 .787 .722 r
.72545 .59008 .72895 .59412 .73592 .58063 .73244 .57656 Metetra
.889 .79 .745 r
.73244 .57656 .73592 .58063 .74297 .56894 .73951 .56482 Metetra
.87 .791 .771 r
.73951 .56482 .74297 .56894 .75011 .55899 .74667 .55482 Metetra
.846 .79 .796 r
.74667 .55482 .75011 .55899 .75735 .55065 .75393 .5464 Metetra
.819 .785 .821 r
.75393 .5464 .75735 .55065 .76468 .54376 .76127 .5394 Metetra
.787 .776 .843 r
.76127 .5394 .76468 .54376 .77211 .53817 .76871 .53368 Metetra
.751 .762 .862 r
.76871 .53368 .77211 .53817 .77964 .53376 .77624 .52912 Metetra
.71 .744 .878 r
.77624 .52912 .77964 .53376 .78726 .53046 .78387 .52568 Metetra
.662 .72 .892 r
.78387 .52568 .78726 .53046 .79498 .52822 .7916 .52334 Metetra
.602 .691 .905 r
.7916 .52334 .79498 .52822 .80282 .52707 .79944 .5222 Metetra
.52 .653 .919 r
.79944 .5222 .80282 .52707 .81078 .52708 .80743 .52241 Metetra
.389 .594 .927 r
.80743 .52241 .81078 .52708 .81889 .52841 .8156 .52422 Metetra
.157 .479 .898 r
.8156 .52422 .81889 .52841 .82718 .5313 .82397 .52797 Metetra
0 .24 .724 r
.82397 .52797 .82718 .5313 .83569 .53608 .83262 .53407 Metetra
.621 .085 0 r
.83262 .53407 .83569 .53608 .84447 .54313 .84159 .54298 Metetra
.796 .3 0 r
.84159 .54298 .84447 .54313 .85358 .55284 .85094 .55503 Metetra
.837 .395 .175 r
.85094 .55503 .85358 .55284 .86306 .56545 .86069 .57019 Metetra
.834 .427 .273 r
.86069 .57019 .86306 .56545 .8729 .58075 .87077 .5875 Metetra
.811 .421 .315 r
.87077 .5875 .8729 .58075 .88302 .59754 .88093 .60446 Metetra
.765 .368 .302 r
.88093 .60446 .88302 .59754 .89312 .61309 .89072 .61687 Metetra
.584 .104 .081 r
.89072 .61687 .89312 .61309 .90273 .62317 .89964 .62031 Metetra
.857 .88 .854 r
.89964 .62031 .90273 .62317 .91134 .62361 .90738 .61273 Metetra
.836 .664 .669 r
.90738 .61273 .91134 .62361 .91871 .61287 .91408 .59603 Metetra
.809 .61 .633 r
.91408 .59603 .91871 .61287 .92503 .59332 .92018 .57459 Metetra
.798 .595 .627 r
.92018 .57459 .92503 .59332 .93079 .56954 .92615 .55261 Metetra
.8 .603 .636 r
.92615 .55261 .93079 .56954 .93645 .54569 .93228 .53266 Metetra
.814 .634 .658 r
.93228 .53266 .93645 .54569 .94232 .52424 .93873 .51578 Metetra
.846 .698 .698 r
.93873 .51578 .94232 .52424 .94854 .50614 .94554 .5021 Metetra
.898 .826 .767 r
.94554 .5021 .94854 .50614 .95515 .49143 .95268 .49129 Metetra
.854 .998 .792 r
.95268 .49129 .95515 .49143 .96213 .47978 .96012 .48292 Metetra
.623 .739 .93 r
.37071 .64334 .37478 .64696 .38143 .64556 .37737 .64193 Metetra
.53 .708 .953 r
.37737 .64193 .38143 .64556 .38806 .64529 .38401 .64165 Metetra
.393 .649 .96 r
.38401 .64165 .38806 .64529 .39467 .6462 .39062 .64256 Metetra
.193 .543 .928 r
.39062 .64256 .39467 .6462 .40125 .64841 .39722 .64476 Metetra
0 .369 .821 r
.39722 .64476 .40125 .64841 .40783 .65202 .40379 .64837 Metetra
0 .145 .629 r
.40379 .64837 .40783 .65202 .41439 .65719 .41036 .65354 Metetra
.588 .071 0 r
.41036 .65354 .41439 .65719 .42095 .66406 .41691 .66041 Metetra
.73 .23 0 r
.41691 .66041 .42095 .66406 .42751 .6727 .42347 .66906 Metetra
.807 .331 0 r
.42347 .66906 .42751 .6727 .43408 .68303 .43004 .6794 Metetra
.843 .384 0 r
.43004 .6794 .43408 .68303 .44069 .69466 .43664 .69103 Metetra
.85 .395 .013 r
.43664 .69103 .44069 .69466 .44736 .7067 .44331 .70308 Metetra
.818 .346 0 r
.44331 .70308 .44736 .7067 .45412 .71766 .45007 .71406 Metetra
.654 .14 0 r
.45007 .71406 .45412 .71766 .46102 .72557 .45696 .72197 Metetra
.078 .479 .893 r
.45696 .72197 .46102 .72557 .46804 .72849 .464 .72488 Metetra
.712 .774 .901 r
.464 .72488 .46804 .72849 .47519 .7253 .47116 .72168 Metetra
.849 .778 .782 r
.47116 .72168 .47519 .7253 .48243 .71629 .47842 .71265 Metetra
.885 .767 .726 r
.47842 .71265 .48243 .71629 .4897 .70295 .48571 .69929 Metetra
.897 .761 .704 r
.48571 .69929 .4897 .70295 .49696 .68734 .493 .68365 Metetra
.899 .76 .699 r
.493 .68365 .49696 .68734 .50418 .67127 .50025 .66755 Metetra
.896 .762 .705 r
.50025 .66755 .50418 .67127 .51137 .656 .50746 .65225 Metetra
.889 .765 .719 r
.50746 .65225 .51137 .656 .51851 .6422 .51463 .63843 Metetra
.878 .769 .737 r
.51463 .63843 .51851 .6422 .52563 .63015 .52177 .62635 Metetra
.864 .773 .759 r
.52177 .62635 .52563 .63015 .53272 .61984 .52889 .61603 Metetra
.845 .775 .784 r
.52889 .61603 .53272 .61984 .53981 .61118 .536 .60735 Metetra
.822 .777 .81 r
.536 .60735 .53981 .61118 .5469 .60403 .5431 .60018 Metetra
.795 .776 .836 r
.5431 .60018 .5469 .60403 .554 .59824 .55022 .59437 Metetra
.761 .772 .863 r
.55022 .59437 .554 .59824 .56111 .5937 .55735 .58982 Metetra
.718 .764 .889 r
.55735 .58982 .56111 .5937 .56825 .59034 .5645 .58645 Metetra
.665 .75 .914 r
.5645 .58645 .56825 .59034 .57542 .58811 .57168 .58421 Metetra
.595 .727 .936 r
.57168 .58421 .57542 .58811 .58262 .58702 .57889 .58312 Metetra
.501 .689 .952 r
.57889 .58312 .58262 .58702 .58987 .5871 .58615 .58319 Metetra
.372 .626 .952 r
.58615 .58319 .58987 .5871 .59718 .58843 .59347 .58451 Metetra
.199 .527 .921 r
.59347 .58451 .59718 .58843 .60455 .59111 .60084 .58719 Metetra
0 .384 .841 r
.60084 .58719 .60455 .59111 .612 .59529 .6083 .59136 Metetra
0 .206 .704 r
.6083 .59136 .612 .59529 .61954 .60112 .61584 .59719 Metetra
0 .026 .537 r
.61584 .59719 .61954 .60112 .62718 .60872 .62349 .6048 Metetra
.611 .121 0 r
.62349 .6048 .62718 .60872 .63495 .61813 .63126 .61421 Metetra
.701 .218 0 r
.63126 .61421 .63495 .61813 .64284 .62915 .63915 .62524 Metetra
.741 .266 0 r
.63915 .62524 .64284 .62915 .65085 .64122 .64716 .63731 Metetra
.732 .255 0 r
.64716 .63731 .65085 .64122 .65893 .65319 .65525 .64929 Metetra
.634 .145 0 r
.65525 .64929 .65893 .65319 .66703 .66332 .66334 .65943 Metetra
0 .199 .697 r
.66334 .65943 .66703 .66332 .67503 .6695 .67135 .66562 Metetra
.454 .678 .961 r
.67135 .66562 .67503 .6695 .68283 .67 .67916 .66611 Metetra
.794 .795 .853 r
.67916 .66611 .68283 .67 .69036 .66419 .68671 .66029 Metetra
.883 .793 .756 r
.68671 .66029 .69036 .66419 .69763 .65291 .694 .64898 Metetra
.911 .785 .709 r
.694 .64898 .69763 .65291 .70469 .63802 .70109 .63406 Metetra
.919 .781 .692 r
.70109 .63406 .70469 .63802 .71162 .62158 .70805 .61759 Metetra
.919 .781 .692 r
.70805 .61759 .71162 .62158 .71853 .60526 .71498 .60122 Metetra
.914 .783 .703 r
.71498 .60122 .71853 .60526 .72545 .59008 .72193 .586 Metetra
.903 .786 .722 r
.72193 .586 .72545 .59008 .73244 .57656 .72894 .57241 Metetra
.888 .788 .744 r
.72894 .57241 .73244 .57656 .73951 .56482 .73603 .56059 Metetra
.869 .788 .768 r
.73603 .56059 .73951 .56482 .74667 .55482 .74321 .55048 Metetra
.845 .784 .792 r
.74321 .55048 .74667 .55482 .75393 .5464 .75047 .54193 Metetra
.818 .777 .815 r
.75047 .54193 .75393 .5464 .76127 .5394 .75783 .5348 Metetra
.786 .767 .835 r
.75783 .5348 .76127 .5394 .76871 .53368 .76527 .52895 Metetra
.75 .753 .854 r
.76527 .52895 .76871 .53368 .77624 .52912 .77281 .52431 Metetra
.707 .736 .874 r
.77281 .52431 .77624 .52912 .78387 .52568 .78046 .5209 Metetra
.651 .717 .897 r
.78046 .5209 .78387 .52568 .7916 .52334 .78822 .51878 Metetra
.568 .693 .925 r
.78822 .51878 .7916 .52334 .79944 .5222 .79612 .51813 Metetra
.419 .645 .951 r
.79612 .51813 .79944 .5222 .80743 .52241 .8042 .51917 Metetra
.109 .508 .907 r
.8042 .51917 .80743 .52241 .8156 .52422 .81248 .52226 Metetra
.393 0 0 r
.81248 .52226 .8156 .52422 .82397 .52797 .82103 .52779 Metetra
.712 .176 0 r
.82103 .52779 .82397 .52797 .83262 .53407 .82991 .53621 Metetra
.799 .337 .14 r
.82991 .53621 .83262 .53407 .84159 .54298 .83915 .54784 Metetra
.812 .402 .271 r
.83915 .54784 .84159 .54298 .85094 .55503 .84879 .56261 Metetra
.804 .424 .336 r
.84879 .56261 .85094 .55503 .86069 .57019 .85875 .57956 Metetra
.786 .418 .361 r
.85875 .57956 .86069 .57019 .87077 .5875 .86881 .59633 Metetra
.752 .376 .342 r
.86881 .59633 .87077 .5875 .88093 .60446 .87857 .60907 Metetra
.634 .181 .159 r
.87857 .60907 .88093 .60446 .89072 .61687 .88758 .6138 Metetra
.78 .861 .91 r
.88758 .6138 .89072 .61687 .89964 .62031 .89558 .60865 Metetra
.799 .639 .684 r
.89558 .60865 .89964 .62031 .90738 .61273 .90267 .59515 Metetra
.782 .591 .642 r
.90267 .59515 .90738 .61273 .91408 .59603 .90921 .577 Metetra
.778 .583 .636 r
.90921 .577 .91408 .59603 .92018 .57459 .91558 .55789 Metetra
.786 .597 .645 r
.91558 .55789 .92018 .57459 .92615 .55261 .92205 .5402 Metetra
.807 .636 .669 r
.92205 .5402 .92615 .55261 .93228 .53266 .92877 .52499 Metetra
.847 .713 .715 r
.92877 .52499 .93228 .53266 .93873 .51578 .93578 .51248 Metetra
.901 .859 .79 r
.93578 .51248 .93873 .51578 .94554 .5021 .94307 .50246 Metetra
.792 .994 .77 r
.94307 .50246 .94554 .5021 .95268 .49129 .95064 .49464 Metetra
.95064 .49464 .95268 .49129 .96012 .48292 .95845 .48877 Metetra
.623 .739 .93 r
.36662 .6397 .37071 .64334 .37737 .64193 .3733 .63828 Metetra
.53 .708 .953 r
.3733 .63828 .37737 .64193 .38401 .64165 .37994 .63799 Metetra
.393 .649 .96 r
.37994 .63799 .38401 .64165 .39062 .64256 .38656 .6389 Metetra
.193 .543 .928 r
.38656 .6389 .39062 .64256 .39722 .64476 .39316 .64109 Metetra
0 .369 .821 r
.39316 .64109 .39722 .64476 .40379 .64837 .39974 .6447 Metetra
0 .145 .629 r
.39974 .6447 .40379 .64837 .41036 .65354 .40631 .64988 Metetra
.588 .071 0 r
.40631 .64988 .41036 .65354 .41691 .66041 .41286 .65675 Metetra
.73 .23 0 r
.41286 .65675 .41691 .66041 .42347 .66906 .41942 .6654 Metetra
.807 .331 0 r
.41942 .6654 .42347 .66906 .43004 .6794 .42598 .67575 Metetra
.843 .384 0 r
.42598 .67575 .43004 .6794 .43664 .69103 .43258 .68739 Metetra
.85 .395 .013 r
.43258 .68739 .43664 .69103 .44331 .70308 .43924 .69945 Metetra
.818 .346 0 r
.43924 .69945 .44331 .70308 .45007 .71406 .446 .71043 Metetra
.654 .14 0 r
.446 .71043 .45007 .71406 .45696 .72197 .45289 .71835 Metetra
.078 .479 .893 r
.45289 .71835 .45696 .72197 .464 .72488 .45993 .72126 Metetra
.712 .774 .901 r
.45993 .72126 .464 .72488 .47116 .72168 .46711 .71805 Metetra
.849 .778 .782 r
.46711 .71805 .47116 .72168 .47842 .71265 .47438 .70899 Metetra
.885 .767 .726 r
.47438 .70899 .47842 .71265 .48571 .69929 .4817 .69561 Metetra
.897 .761 .704 r
.4817 .69561 .48571 .69929 .493 .68365 .48902 .67994 Metetra
.899 .76 .699 r
.48902 .67994 .493 .68365 .50025 .66755 .4963 .66381 Metetra
.896 .762 .705 r
.4963 .66381 .50025 .66755 .50746 .65225 .50354 .64848 Metetra
.889 .765 .719 r
.50354 .64848 .50746 .65225 .51463 .63843 .51073 .63464 Metetra
.878 .769 .737 r
.51073 .63464 .51463 .63843 .52177 .62635 .5179 .62254 Metetra
.864 .773 .759 r
.5179 .62254 .52177 .62635 .52889 .61603 .52504 .61219 Metetra
.845 .775 .784 r
.52504 .61219 .52889 .61603 .536 .60735 .53216 .6035 Metetra
.822 .777 .81 r
.53216 .6035 .536 .60735 .5431 .60018 .53929 .59631 Metetra
.795 .776 .836 r
.53929 .59631 .5431 .60018 .55022 .59437 .54642 .59049 Metetra
.761 .772 .863 r
.54642 .59049 .55022 .59437 .55735 .58982 .55356 .58593 Metetra
.718 .764 .889 r
.55356 .58593 .55735 .58982 .5645 .58645 .56073 .58254 Metetra
.665 .75 .914 r
.56073 .58254 .5645 .58645 .57168 .58421 .56792 .5803 Metetra
.595 .727 .936 r
.56792 .5803 .57168 .58421 .57889 .58312 .57514 .57919 Metetra
.501 .689 .952 r
.57514 .57919 .57889 .58312 .58615 .58319 .58242 .57925 Metetra
.372 .626 .952 r
.58242 .57925 .58615 .58319 .59347 .58451 .58974 .58057 Metetra
.199 .527 .921 r
.58974 .58057 .59347 .58451 .60084 .58719 .59712 .58324 Metetra
0 .384 .841 r
.59712 .58324 .60084 .58719 .6083 .59136 .60458 .58742 Metetra
0 .205 .704 r
.60458 .58742 .6083 .59136 .61584 .59719 .61213 .59324 Metetra
0 .026 .537 r
.61213 .59324 .61584 .59719 .62349 .6048 .61979 .60085 Metetra
.611 .121 0 r
.61979 .60085 .62349 .6048 .63126 .61421 .62756 .61027 Metetra
.701 .219 0 r
.62756 .61027 .63126 .61421 .63915 .62524 .63545 .62131 Metetra
.741 .266 0 r
.63545 .62131 .63915 .62524 .64716 .63731 .64346 .63339 Metetra
.733 .256 0 r
.64346 .63339 .64716 .63731 .65525 .64929 .65154 .64538 Metetra
.635 .145 0 r
.65154 .64538 .65525 .64929 .66334 .65943 .65964 .65553 Metetra
0 .198 .696 r
.65964 .65553 .66334 .65943 .67135 .66562 .66765 .66172 Metetra
.453 .679 .961 r
.66765 .66172 .67135 .66562 .67916 .66611 .67548 .66221 Metetra
.794 .795 .853 r
.67548 .66221 .67916 .66611 .68671 .66029 .68305 .65637 Metetra
.884 .794 .756 r
.68305 .65637 .68671 .66029 .694 .64898 .69036 .64504 Metetra
.911 .785 .709 r
.69036 .64504 .694 .64898 .70109 .63406 .69747 .63008 Metetra
.919 .781 .692 r
.69747 .63008 .70109 .63406 .70805 .61759 .70446 .61355 Metetra
.919 .781 .692 r
.70446 .61355 .70805 .61759 .71498 .60122 .71142 .59711 Metetra
.913 .782 .703 r
.71142 .59711 .71498 .60122 .72193 .586 .71839 .5818 Metetra
.902 .783 .72 r
.71839 .5818 .72193 .586 .72894 .57241 .72542 .5681 Metetra
.886 .783 .742 r
.72542 .5681 .72894 .57241 .73603 .56059 .73252 .55616 Metetra
.867 .781 .764 r
.73252 .55616 .73603 .56059 .74321 .55048 .73971 .54591 Metetra
.843 .776 .787 r
.73971 .54591 .74321 .55048 .75047 .54193 .74699 .53725 Metetra
.815 .769 .81 r
.74699 .53725 .75047 .54193 .75783 .5348 .75436 .53005 Metetra
.782 .761 .834 r
.75436 .53005 .75783 .5348 .76527 .52895 .76183 .52425 Metetra
.743 .753 .861 r
.76183 .52425 .76527 .52895 .77281 .52431 .7694 .51986 Metetra
.689 .747 .896 r
.7694 .51986 .77281 .52431 .78046 .5209 .7771 .51693 Metetra
.598 .738 .942 r
.7771 .51693 .78046 .5209 .78822 .51878 .78494 .51564 Metetra
.401 .695 .98 r
.78494 .51564 .78822 .51878 .79612 .51813 .79296 .5162 Metetra
0 .465 .824 r
.79296 .5162 .79612 .51813 .8042 .51917 .80119 .51893 Metetra
.565 0 0 r
.80119 .51893 .8042 .51917 .81248 .52226 .80968 .52421 Metetra
.737 .247 .073 r
.80968 .52421 .81248 .52226 .82103 .52779 .81849 .53238 Metetra
.776 .353 .246 r
.81849 .53238 .82103 .52779 .82991 .53621 .82765 .54365 Metetra
.78 .397 .33 r
.82765 .54365 .82991 .53621 .83915 .54784 .83716 .55776 Metetra
.774 .412 .371 r
.83716 .55776 .83915 .54784 .84879 .56261 .84694 .57363 Metetra
.76 .405 .381 r
.84694 .57363 .84879 .56261 .85875 .57956 .85678 .58899 Metetra
.734 .364 .35 r
.85678 .58899 .85875 .57956 .86881 .59633 .86635 .60055 Metetra
.631 .168 .135 r
.86635 .60055 .86881 .59633 .87857 .60907 .87531 .60519 Metetra
.71 .799 .92 r
.87531 .60519 .87857 .60907 .88758 .6138 .88347 .60164 Metetra
.761 .615 .698 r
.88347 .60164 .88758 .6138 .89558 .60865 .8909 .59115 Metetra
.755 .576 .654 r
.8909 .59115 .89558 .60865 .90267 .59515 .89787 .57657 Metetra
.757 .572 .647 r
.89787 .57657 .90267 .59515 .90921 .577 .90466 .56078 Metetra
.769 .59 .656 r
.90466 .56078 .90921 .577 .91558 .55789 .9115 .54574 Metetra
.792 .631 .681 r
.9115 .54574 .91558 .55789 .92205 .5402 .91849 .53243 Metetra
.83 .705 .727 r
.91849 .53243 .92205 .5402 .92877 .52499 .9257 .52114 Metetra
.877 .835 .801 r
.9257 .52114 .92877 .52499 .93578 .51248 .93314 .51189 Metetra
.836 .994 .849 r
.93314 .51189 .93578 .51248 .94307 .50246 .94081 .50456 Metetra
.94081 .50456 .94307 .50246 .95064 .49464 .94871 .49912 Metetra
.212 0 0 r
.94871 .49912 .95064 .49464 .95845 .48877 .95688 .49562 Metetra
.623 .739 .93 r
.36252 .63604 .36662 .6397 .3733 .63828 .3692 .63461 Metetra
.53 .708 .953 r
.3692 .63461 .3733 .63828 .37994 .63799 .37585 .63432 Metetra
.393 .649 .96 r
.37585 .63432 .37994 .63799 .38656 .6389 .38248 .63522 Metetra
.193 .543 .928 r
.38248 .63522 .38656 .6389 .39316 .64109 .38908 .63741 Metetra
0 .369 .821 r
.38908 .63741 .39316 .64109 .39974 .6447 .39567 .64102 Metetra
0 .145 .629 r
.39567 .64102 .39974 .6447 .40631 .64988 .40224 .64619 Metetra
.588 .071 0 r
.40224 .64619 .40631 .64988 .41286 .65675 .40879 .65307 Metetra
.73 .23 0 r
.40879 .65307 .41286 .65675 .41942 .6654 .41534 .66172 Metetra
.807 .331 0 r
.41534 .66172 .41942 .6654 .42598 .67575 .42191 .67207 Metetra
.843 .384 0 r
.42191 .67207 .42598 .67575 .43258 .68739 .4285 .68373 Metetra
.85 .395 .013 r
.4285 .68373 .43258 .68739 .43924 .69945 .43515 .6958 Metetra
.818 .346 0 r
.43515 .6958 .43924 .69945 .446 .71043 .44191 .70678 Metetra
.654 .14 0 r
.44191 .70678 .446 .71043 .45289 .71835 .4488 .71471 Metetra
.078 .479 .893 r
.4488 .71471 .45289 .71835 .45993 .72126 .45584 .71761 Metetra
.712 .774 .901 r
.45584 .71761 .45993 .72126 .46711 .71805 .46304 .71439 Metetra
.849 .778 .782 r
.46304 .71439 .46711 .71805 .47438 .70899 .47033 .70532 Metetra
.885 .767 .726 r
.47033 .70532 .47438 .70899 .4817 .69561 .47768 .69191 Metetra
.897 .761 .704 r
.47768 .69191 .4817 .69561 .48902 .67994 .48502 .67621 Metetra
.899 .76 .699 r
.48502 .67621 .48902 .67994 .4963 .66381 .49233 .66005 Metetra
.896 .762 .705 r
.49233 .66005 .4963 .66381 .50354 .64848 .4996 .6447 Metetra
.889 .765 .719 r
.4996 .6447 .50354 .64848 .51073 .63464 .50682 .63083 Metetra
.878 .769 .737 r
.50682 .63083 .51073 .63464 .5179 .62254 .514 .61871 Metetra
.864 .773 .759 r
.514 .61871 .5179 .62254 .52504 .61219 .52116 .60834 Metetra
.845 .775 .784 r
.52116 .60834 .52504 .61219 .53216 .6035 .52831 .59963 Metetra
.822 .777 .81 r
.52831 .59963 .53216 .6035 .53929 .59631 .53545 .59242 Metetra
.795 .776 .836 r
.53545 .59242 .53929 .59631 .54642 .59049 .5426 .58659 Metetra
.761 .772 .863 r
.5426 .58659 .54642 .59049 .55356 .58593 .54976 .58201 Metetra
.718 .764 .889 r
.54976 .58201 .55356 .58593 .56073 .58254 .55694 .57861 Metetra
.665 .75 .914 r
.55694 .57861 .56073 .58254 .56792 .5803 .56414 .57636 Metetra
.595 .727 .936 r
.56414 .57636 .56792 .5803 .57514 .57919 .57138 .57524 Metetra
.501 .689 .952 r
.57138 .57524 .57514 .57919 .58242 .57925 .57866 .5753 Metetra
.372 .626 .952 r
.57866 .5753 .58242 .57925 .58974 .58057 .58599 .57661 Metetra
.199 .527 .921 r
.58599 .57661 .58974 .58057 .59712 .58324 .59338 .57928 Metetra
0 .384 .841 r
.59338 .57928 .59712 .58324 .60458 .58742 .60085 .58345 Metetra
0 .205 .704 r
.60085 .58345 .60458 .58742 .61213 .59324 .60841 .58928 Metetra
0 .025 .537 r
.60841 .58928 .61213 .59324 .61979 .60085 .61606 .59689 Metetra
.611 .121 0 r
.61606 .59689 .61979 .60085 .62756 .61027 .62383 .60631 Metetra
.701 .219 0 r
.62383 .60631 .62756 .61027 .63545 .62131 .63173 .61736 Metetra
.742 .267 0 r
.63173 .61736 .63545 .62131 .64346 .63339 .63973 .62946 Metetra
.734 .256 0 r
.63973 .62946 .64346 .63339 .65154 .64538 .64782 .64147 Metetra
.637 .147 0 r
.64782 .64147 .65154 .64538 .65964 .65553 .65592 .65163 Metetra
0 .196 .693 r
.65592 .65163 .65964 .65553 .66765 .66172 .66394 .65783 Metetra
.452 .679 .962 r
.66394 .65783 .66765 .66172 .67548 .66221 .67178 .65831 Metetra
.794 .796 .853 r
.67178 .65831 .67548 .66221 .68305 .65637 .67936 .65244 Metetra
.884 .794 .756 r
.67936 .65244 .68305 .65637 .69036 .64504 .6867 .64105 Metetra
.911 .785 .709 r
.6867 .64105 .69036 .64504 .69747 .63008 .69383 .62601 Metetra
.919 .78 .691 r
.69383 .62601 .69747 .63008 .70446 .61355 .70085 .60938 Metetra
.918 .778 .691 r
.70085 .60938 .70446 .61355 .71142 .59711 .70782 .59282 Metetra
.911 .778 .701 r
.70782 .59282 .71142 .59711 .71839 .5818 .71482 .57738 Metetra
.899 .777 .718 r
.71482 .57738 .71839 .5818 .72542 .5681 .72186 .56355 Metetra
.883 .776 .739 r
.72186 .56355 .72542 .5681 .73252 .55616 .72899 .5515 Metetra
.863 .774 .762 r
.72899 .5515 .73252 .55616 .73971 .54591 .73619 .54121 Metetra
.839 .772 .787 r
.73619 .54121 .73971 .54591 .74699 .53725 .7435 .53262 Metetra
.811 .772 .816 r
.7435 .53262 .74699 .53725 .75436 .53005 .7509 .52568 Metetra
.775 .775 .853 r
.7509 .52568 .75436 .53005 .76183 .52425 .75842 .52038 Metetra
.72 .786 .904 r
.75842 .52038 .76183 .52425 .7694 .51986 .76607 .51678 Metetra
.609 .796 .971 r
.76607 .51678 .7694 .51986 .7771 .51693 .77388 .51502 Metetra
.297 .72 .972 r
.77388 .51502 .7771 .51693 .78494 .51564 .78186 .51531 Metetra
.319 0 0 r
.78186 .51531 .78494 .51564 .79296 .5162 .79006 .51791 Metetra
.642 .116 0 r
.79006 .51791 .79296 .5162 .80119 .51893 .79852 .5231 Metetra
.726 .284 .203 r
.79852 .5231 .80119 .51893 .80968 .52421 .80727 .53109 Metetra
.748 .355 .309 r
.80727 .53109 .80968 .52421 .81849 .53238 .81634 .54185 Metetra
.751 .386 .362 r
.81634 .54185 .81849 .53238 .82765 .54365 .82569 .55489 Metetra
.747 .395 .385 r
.82569 .55489 .82765 .54365 .83716 .55776 .83524 .56897 Metetra
.737 .383 .381 r
.83524 .56897 .83716 .55776 .84694 .57363 .84479 .58201 Metetra
.714 .333 .325 r
.84479 .58201 .84694 .57363 .85678 .58899 .85409 .59142 Metetra
.573 .049 0 r
.85409 .59142 .85678 .58899 .86635 .60055 .86291 .59512 Metetra
.668 .71 .88 r
.86291 .59512 .86635 .60055 .87531 .60519 .87114 .59246 Metetra
.722 .59 .707 r
.87114 .59246 .87531 .60519 .88347 .60164 .87884 .58451 Metetra
.727 .562 .667 r
.87884 .58451 .88347 .60164 .8909 .59115 .88618 .57329 Metetra
.734 .562 .659 r
.88618 .57329 .8909 .59115 .89787 .57657 .89337 .56079 Metetra
.748 .581 .668 r
.89337 .56079 .89787 .57657 .90466 .56078 .90055 .54847 Metetra
.77 .618 .691 r
.90055 .54847 .90466 .56078 .9115 .54574 .90782 .53711 Metetra
.799 .679 .731 r
.90782 .53711 .9115 .54574 .91849 .53243 .91522 .52714 Metetra
.833 .773 .795 r
.91522 .52714 .91849 .53243 .9257 .52114 .92279 .51872 Metetra
.841 .911 .884 r
.92279 .51872 .9257 .52114 .93314 .51189 .93057 .512 Metetra
.606 .954 .843 r
.93057 .512 .93314 .51189 .94081 .50456 .93857 .50714 Metetra
.069 0 0 r
.93857 .50714 .94081 .50456 .94871 .49912 .94685 .50428 Metetra
.414 0 .097 r
.94685 .50428 .94871 .49912 .95688 .49562 .95541 .50349 Metetra
.623 .739 .93 r
.35839 .63237 .36252 .63604 .3692 .63461 .36508 .63093 Metetra
.53 .708 .953 r
.36508 .63093 .3692 .63461 .37585 .63432 .37174 .63063 Metetra
.393 .649 .96 r
.37174 .63063 .37585 .63432 .38248 .63522 .37838 .63153 Metetra
.193 .543 .928 r
.37838 .63153 .38248 .63522 .38908 .63741 .38499 .63371 Metetra
0 .369 .821 r
.38499 .63371 .38908 .63741 .39567 .64102 .39158 .63732 Metetra
0 .145 .629 r
.39158 .63732 .39567 .64102 .40224 .64619 .39815 .64249 Metetra
.588 .071 0 r
.39815 .64249 .40224 .64619 .40879 .65307 .4047 .64937 Metetra
.73 .23 0 r
.4047 .64937 .40879 .65307 .41534 .66172 .41125 .65803 Metetra
.807 .331 0 r
.41125 .65803 .41534 .66172 .42191 .67207 .41781 .66839 Metetra
.843 .384 0 r
.41781 .66839 .42191 .67207 .4285 .68373 .4244 .68005 Metetra
.85 .395 .013 r
.4244 .68005 .4285 .68373 .43515 .6958 .43105 .69213 Metetra
.818 .346 0 r
.43105 .69213 .43515 .6958 .44191 .70678 .4378 .70312 Metetra
.654 .14 0 r
.4378 .70312 .44191 .70678 .4488 .71471 .44469 .71105 Metetra
.078 .479 .893 r
.44469 .71105 .4488 .71471 .45584 .71761 .45174 .71395 Metetra
.712 .774 .901 r
.45174 .71395 .45584 .71761 .46304 .71439 .45894 .71072 Metetra
.849 .778 .782 r
.45894 .71072 .46304 .71439 .47033 .70532 .46626 .70163 Metetra
.885 .767 .726 r
.46626 .70163 .47033 .70532 .47768 .69191 .47363 .68819 Metetra
.897 .761 .704 r
.47363 .68819 .47768 .69191 .48502 .67621 .481 .67246 Metetra
.899 .76 .699 r
.481 .67246 .48502 .67621 .49233 .66005 .48834 .65628 Metetra
.896 .762 .705 r
.48834 .65628 .49233 .66005 .4996 .6447 .49563 .6409 Metetra
.889 .765 .719 r
.49563 .6409 .4996 .6447 .50682 .63083 .50288 .627 Metetra
.878 .769 .737 r
.50288 .627 .50682 .63083 .514 .61871 .51009 .61486 Metetra
.864 .773 .759 r
.51009 .61486 .514 .61871 .52116 .60834 .51727 .60447 Metetra
.845 .775 .784 r
.51727 .60447 .52116 .60834 .52831 .59963 .52444 .59574 Metetra
.822 .777 .81 r
.52444 .59574 .52831 .59963 .53545 .59242 .5316 .58851 Metetra
.795 .776 .836 r
.5316 .58851 .53545 .59242 .5426 .58659 .53876 .58266 Metetra
.761 .772 .863 r
.53876 .58266 .5426 .58659 .54976 .58201 .54594 .57808 Metetra
.718 .764 .889 r
.54594 .57808 .54976 .58201 .55694 .57861 .55313 .57467 Metetra
.665 .75 .914 r
.55313 .57467 .55694 .57861 .56414 .57636 .56035 .5724 Metetra
.595 .727 .936 r
.56035 .5724 .56414 .57636 .57138 .57524 .5676 .57127 Metetra
.501 .689 .952 r
.5676 .57127 .57138 .57524 .57866 .5753 .57489 .57133 Metetra
.372 .626 .952 r
.57489 .57133 .57866 .5753 .58599 .57661 .58223 .57263 Metetra
.199 .527 .921 r
.58223 .57263 .58599 .57661 .59338 .57928 .58963 .57529 Metetra
0 .384 .841 r
.58963 .57529 .59338 .57928 .60085 .58345 .5971 .57947 Metetra
0 .205 .704 r
.5971 .57947 .60085 .58345 .60841 .58928 .60466 .58529 Metetra
0 .025 .536 r
.60466 .58529 .60841 .58928 .61606 .59689 .61232 .59291 Metetra
.612 .122 0 r
.61232 .59291 .61606 .59689 .62383 .60631 .62009 .60234 Metetra
.702 .22 0 r
.62009 .60234 .62383 .60631 .63173 .61736 .62799 .61341 Metetra
.744 .268 0 r
.62799 .61341 .63173 .61736 .63973 .62946 .63599 .62553 Metetra
.736 .258 0 r
.63599 .62553 .63973 .62946 .64782 .64147 .64408 .63757 Metetra
.64 .15 0 r
.64408 .63757 .64782 .64147 .65592 .65163 .65218 .64774 Metetra
0 .194 .69 r
.65218 .64774 .65592 .65163 .66394 .65783 .66021 .65394 Metetra
.454 .681 .963 r
.66021 .65394 .66394 .65783 .67178 .65831 .66805 .65438 Metetra
.796 .796 .852 r
.66805 .65438 .67178 .65831 .67936 .65244 .67566 .64844 Metetra
.884 .792 .754 r
.67566 .64844 .67936 .65244 .6867 .64105 .68301 .63693 Metetra
.91 .781 .707 r
.68301 .63693 .6867 .64105 .69383 .62601 .69017 .62175 Metetra
.917 .775 .69 r
.69017 .62175 .69383 .62601 .70085 .60938 .6972 .60496 Metetra
.915 .772 .689 r
.6972 .60496 .70085 .60938 .70782 .59282 .7042 .58827 Metetra
.907 .771 .7 r
.7042 .58827 .70782 .59282 .71482 .57738 .71121 .57272 Metetra
.895 .771 .717 r
.71121 .57272 .71482 .57738 .72186 .56355 .71829 .55886 Metetra
.88 .773 .739 r
.71829 .55886 .72186 .56355 .72899 .5515 .72544 .5469 Metetra
.861 .777 .767 r
.72544 .5469 .72899 .5515 .73619 .54121 .73268 .53689 Metetra
.838 .787 .802 r
.73268 .53689 .73619 .54121 .7435 .53262 .74004 .5288 Metetra
.807 .806 .851 r
.74004 .5288 .7435 .53262 .7509 .52568 .74752 .52265 Metetra
.749 .84 .92 r
.74752 .52265 .7509 .52568 .75842 .52038 .75514 .51846 Metetra
.587 .864 .995 r
.75514 .51846 .75842 .52038 .76607 .51678 .76292 .51636 Metetra
.06 .621 .787 r
.76292 .51636 .76607 .51678 .77388 .51502 .77088 .51649 Metetra
.484 0 0 r
.77088 .51649 .77388 .51502 .78186 .51531 .77906 .51903 Metetra
.654 .189 .136 r
.77906 .51903 .78186 .51531 .79006 .51791 .78749 .52411 Metetra
.704 .298 .274 r
.78749 .52411 .79006 .51791 .79852 .5231 .79618 .53172 Metetra
.721 .347 .341 r
.79618 .53172 .79852 .5231 .80727 .53109 .80513 .54159 Metetra
.725 .368 .373 r
.80513 .54159 .80727 .53109 .81634 .54185 .81429 .55297 Metetra
.723 .369 .379 r
.81429 .55297 .81634 .54185 .82569 .55489 .82355 .56456 Metetra
.714 .347 .353 r
.82355 .56456 .82569 .55489 .83524 .56897 .83277 .57462 Metetra
.685 .261 .234 r
.83277 .57462 .83524 .56897 .84479 .58201 .84177 .58135 Metetra
.2 0 0 r
.84177 .58135 .84479 .58201 .85409 .59142 .8504 .58359 Metetra
.646 .625 .814 r
.8504 .58359 .85409 .59142 .86291 .59512 .85863 .58126 Metetra
.686 .559 .706 r
.85863 .58126 .86291 .59512 .87114 .59246 .86651 .57524 Metetra
.696 .543 .675 r
.86651 .57524 .87114 .59246 .87884 .58451 .87416 .56684 Metetra
.706 .546 .669 r
.87416 .56684 .87884 .58451 .88618 .57329 .88167 .5573 Metetra
.719 .563 .677 r
.88167 .5573 .88618 .57329 .89337 .56079 .88916 .54755 Metetra
.736 .592 .696 r
.88916 .54755 .89337 .56079 .90055 .54847 .89667 .53821 Metetra
.756 .635 .726 r
.89667 .53821 .90055 .54847 .90782 .53711 .90427 .52972 Metetra
.774 .694 .775 r
.90427 .52972 .90782 .53711 .91522 .52714 .912 .52243 Metetra
.782 .784 .854 r
.912 .52243 .91522 .52714 .92279 .51872 .91991 .51667 Metetra
.71 .914 .965 r
.91991 .51667 .92279 .51872 .93057 .512 .92805 .51271 Metetra
.92805 .51271 .93057 .512 .93857 .50714 .93644 .51071 Metetra
.391 0 0 r
.93644 .51071 .93857 .50714 .94685 .50428 .94511 .51065 Metetra
.54 .122 .197 r
.94511 .51065 .94685 .50428 .95541 .50349 .95403 .51236 Metetra
.623 .739 .93 r
.35425 .62868 .35839 .63237 .36508 .63093 .36095 .62723 Metetra
.53 .708 .953 r
.36095 .62723 .36508 .63093 .37174 .63063 .36762 .62692 Metetra
.393 .649 .96 r
.36762 .62692 .37174 .63063 .37838 .63153 .37426 .62781 Metetra
.193 .543 .928 r
.37426 .62781 .37838 .63153 .38499 .63371 .38087 .63 Metetra
0 .369 .821 r
.38087 .63 .38499 .63371 .39158 .63732 .38747 .6336 Metetra
0 .145 .629 r
.38747 .6336 .39158 .63732 .39815 .64249 .39404 .63877 Metetra
.588 .071 0 r
.39404 .63877 .39815 .64249 .4047 .64937 .40059 .64565 Metetra
.73 .23 0 r
.40059 .64565 .4047 .64937 .41125 .65803 .40714 .65431 Metetra
.807 .331 0 r
.40714 .65431 .41125 .65803 .41781 .66839 .41369 .66468 Metetra
.843 .384 0 r
.41369 .66468 .41781 .66839 .4244 .68005 .42028 .67635 Metetra
.85 .395 .013 r
.42028 .67635 .4244 .68005 .43105 .69213 .42692 .68844 Metetra
.818 .346 0 r
.42692 .68844 .43105 .69213 .4378 .70312 .43366 .69944 Metetra
.654 .14 0 r
.43366 .69944 .4378 .70312 .44469 .71105 .44055 .70737 Metetra
.078 .479 .893 r
.44055 .70737 .44469 .71105 .45174 .71395 .44761 .71027 Metetra
.712 .774 .901 r
.44761 .71027 .45174 .71395 .45894 .71072 .45483 .70703 Metetra
.849 .778 .782 r
.45483 .70703 .45894 .71072 .46626 .70163 .46217 .69792 Metetra
.885 .767 .726 r
.46217 .69792 .46626 .70163 .47363 .68819 .46956 .68446 Metetra
.897 .761 .704 r
.46956 .68446 .47363 .68819 .481 .67246 .47696 .6687 Metetra
.899 .76 .699 r
.47696 .6687 .481 .67246 .48834 .65628 .48433 .65248 Metetra
.896 .762 .705 r
.48433 .65248 .48834 .65628 .49563 .6409 .49165 .63708 Metetra
.889 .765 .719 r
.49165 .63708 .49563 .6409 .50288 .627 .49893 .62316 Metetra
.878 .769 .737 r
.49893 .62316 .50288 .627 .51009 .61486 .50616 .61099 Metetra
.864 .773 .759 r
.50616 .61099 .51009 .61486 .51727 .60447 .51336 .60058 Metetra
.845 .775 .784 r
.51336 .60058 .51727 .60447 .52444 .59574 .52055 .59183 Metetra
.822 .777 .81 r
.52055 .59183 .52444 .59574 .5316 .58851 .52773 .58459 Metetra
.795 .776 .836 r
.52773 .58459 .5316 .58851 .53876 .58266 .53491 .57872 Metetra
.761 .772 .863 r
.53491 .57872 .53876 .58266 .54594 .57808 .5421 .57412 Metetra
.718 .764 .889 r
.5421 .57412 .54594 .57808 .55313 .57467 .5493 .5707 Metetra
.665 .75 .914 r
.5493 .5707 .55313 .57467 .56035 .5724 .55653 .56843 Metetra
.595 .727 .936 r
.55653 .56843 .56035 .5724 .5676 .57127 .56379 .56729 Metetra
.501 .689 .952 r
.56379 .56729 .5676 .57127 .57489 .57133 .57109 .56733 Metetra
.372 .626 .952 r
.57109 .56733 .57489 .57133 .58223 .57263 .57844 .56863 Metetra
.198 .527 .921 r
.57844 .56863 .58223 .57263 .58963 .57529 .58585 .5713 Metetra
0 .383 .84 r
.58585 .5713 .58963 .57529 .5971 .57947 .59333 .57547 Metetra
0 .204 .703 r
.59333 .57547 .5971 .57947 .60466 .58529 .6009 .5813 Metetra
0 .023 .533 r
.6009 .5813 .60466 .58529 .61232 .59291 .60856 .58893 Metetra
.615 .124 0 r
.60856 .58893 .61232 .59291 .62009 .60234 .61633 .59839 Metetra
.705 .223 0 r
.61633 .59839 .62009 .60234 .62799 .61341 .62423 .60948 Metetra
.747 .271 0 r
.62423 .60948 .62799 .61341 .63599 .62553 .63223 .62163 Metetra
.739 .261 0 r
.63223 .62163 .63599 .62553 .64408 .63757 .64032 .63368 Metetra
.643 .151 0 r
.64032 .63368 .64408 .63757 .65218 .64774 .64843 .64385 Metetra
0 .198 .694 r
.64843 .64385 .65218 .64774 .66021 .65394 .65646 .64999 Metetra
.466 .685 .961 r
.65646 .64999 .66021 .65394 .66805 .65438 .66431 .65032 Metetra
.798 .791 .846 r
.66431 .65032 .66805 .65438 .67566 .64844 .67192 .6442 Metetra
.881 .785 .75 r
.67192 .6442 .67566 .64844 .68301 .63693 .67929 .63249 Metetra
.906 .773 .704 r
.67929 .63249 .68301 .63693 .69017 .62175 .68647 .61712 Metetra
.912 .767 .688 r
.68647 .61712 .69017 .62175 .6972 .60496 .69353 .60021 Metetra
.91 .765 .689 r
.69353 .60021 .6972 .60496 .7042 .58827 .70055 .58349 Metetra
.903 .766 .701 r
.70055 .58349 .7042 .58827 .71121 .57272 .7076 .56806 Metetra
.893 .772 .721 r
.7076 .56806 .71121 .57272 .71829 .55886 .71471 .55451 Metetra
.881 .785 .75 r
.71471 .55451 .71829 .55886 .72544 .5469 .72192 .54308 Metetra
.866 .807 .79 r
.72192 .54308 .72544 .5469 .73268 .53689 .72924 .53386 Metetra
.841 .847 .85 r
.72924 .53386 .73268 .53689 .74004 .5288 .73669 .52686 Metetra
.773 .909 .933 r
.73669 .52686 .74004 .5288 .74752 .52265 .74428 .52212 Metetra
.486 .89 .939 r
.74428 .52212 .74752 .52265 .75514 .51846 .75205 .51968 Metetra
.194 0 0 r
.75205 .51968 .75514 .51846 .76292 .51636 .76 .51963 Metetra
.537 .044 .031 r
.76 .51963 .76292 .51636 .77088 .51649 .76816 .52198 Metetra
.642 .217 .222 r
.76816 .52198 .77088 .51649 .77906 .51903 .77654 .52669 Metetra
.679 .293 .308 r
.77654 .52669 .77906 .51903 .78749 .52411 .78513 .5335 Metetra
.694 .327 .349 r
.78513 .5335 .78749 .52411 .79618 .53172 .79392 .54188 Metetra
.698 .338 .361 r
.79392 .54188 .79618 .53172 .80513 .54159 .80284 .55092 Metetra
.695 .326 .344 r
.80284 .55092 .80513 .54159 .81429 .55297 .81179 .5594 Metetra
.679 .27 .263 r
.81179 .5594 .81429 .55297 .82355 .56456 .82066 .56601 Metetra
.545 0 0 r
.82066 .56601 .82355 .56456 .83277 .57462 .82933 .56973 Metetra
.495 .653 .929 r
.82933 .56973 .83277 .57462 .84177 .58135 .83775 .57016 Metetra
.638 .56 .75 r
.83775 .57016 .84177 .58135 .8504 .58359 .84592 .56759 Metetra
.657 .526 .693 r
.84592 .56759 .8504 .58359 .85863 .58126 .8539 .56273 Metetra
.665 .517 .673 r
.8539 .56273 .85863 .58126 .86651 .57524 .86173 .55638 Metetra
.673 .52 .67 r
.86173 .55638 .86651 .57524 .87416 .56684 .86949 .54923 Metetra
.682 .532 .675 r
.86949 .54923 .87416 .56684 .88167 .5573 .87722 .5418 Metetra
.692 .55 .689 r
.87722 .5418 .88167 .5573 .88916 .54755 .88497 .53456 Metetra
.701 .575 .711 r
.88497 .53456 .88916 .54755 .89667 .53821 .89278 .52791 Metetra
.706 .61 .746 r
.89278 .52791 .89667 .53821 .90427 .52972 .90071 .5223 Metetra
.703 .664 .808 r
.90071 .5223 .90427 .52972 .912 .52243 .90881 .51809 Metetra
.661 .76 .924 r
.90881 .51809 .912 .52243 .91991 .51667 .91712 .51554 Metetra
.313 .778 .941 r
.91712 .51554 .91991 .51667 .92805 .51271 .92567 .51476 Metetra
.365 0 0 r
.92567 .51476 .92805 .51271 .93644 .51071 .93445 .51566 Metetra
.547 .092 .124 r
.93445 .51566 .93644 .51071 .94511 .51065 .94346 .518 Metetra
.591 .187 .246 r
.94346 .518 .94511 .51065 .95403 .51236 .95264 .5213 Metetra
.623 .739 .93 r
.35008 .62497 .35425 .62868 .36095 .62723 .3568 .62352 Metetra
.53 .708 .953 r
.3568 .62352 .36095 .62723 .36762 .62692 .36347 .6232 Metetra
.393 .649 .96 r
.36347 .6232 .36762 .62692 .37426 .62781 .37012 .62408 Metetra
.193 .543 .928 r
.37012 .62408 .37426 .62781 .38087 .63 .37674 .62626 Metetra
0 .369 .821 r
.37674 .62626 .38087 .63 .38747 .6336 .38333 .62986 Metetra
0 .145 .629 r
.38333 .62986 .38747 .6336 .39404 .63877 .38991 .63503 Metetra
.588 .071 0 r
.38991 .63503 .39404 .63877 .40059 .64565 .39646 .64192 Metetra
.73 .23 0 r
.39646 .64192 .40059 .64565 .40714 .65431 .40301 .65058 Metetra
.807 .331 0 r
.40301 .65058 .40714 .65431 .41369 .66468 .40956 .66096 Metetra
.843 .384 0 r
.40956 .66096 .41369 .66468 .42028 .67635 .41613 .67264 Metetra
.85 .395 .013 r
.41613 .67264 .42028 .67635 .42692 .68844 .42277 .68473 Metetra
.818 .346 0 r
.42277 .68473 .42692 .68844 .43366 .69944 .42951 .69575 Metetra
.654 .14 0 r
.42951 .69575 .43366 .69944 .44055 .70737 .4364 .70368 Metetra
.078 .479 .893 r
.4364 .70368 .44055 .70737 .44761 .71027 .44347 .70658 Metetra
.712 .774 .901 r
.44347 .70658 .44761 .71027 .45483 .70703 .4507 .70332 Metetra
.849 .778 .782 r
.4507 .70332 .45483 .70703 .46217 .69792 .45806 .69419 Metetra
.885 .767 .726 r
.45806 .69419 .46217 .69792 .46956 .68446 .46548 .6807 Metetra
.897 .761 .704 r
.46548 .6807 .46956 .68446 .47696 .6687 .47291 .66492 Metetra
.899 .76 .699 r
.47291 .66492 .47696 .6687 .48433 .65248 .4803 .64867 Metetra
.896 .762 .705 r
.4803 .64867 .48433 .65248 .49165 .63708 .48765 .63324 Metetra
.889 .765 .719 r
.48765 .63324 .49165 .63708 .49893 .62316 .49495 .61929 Metetra
.878 .769 .737 r
.49495 .61929 .49893 .62316 .50616 .61099 .50221 .6071 Metetra
.864 .773 .759 r
.50221 .6071 .50616 .61099 .51336 .60058 .50944 .59667 Metetra
.845 .775 .784 r
.50944 .59667 .51336 .60058 .52055 .59183 .51664 .5879 Metetra
.822 .777 .81 r
.51664 .5879 .52055 .59183 .52773 .58459 .52384 .58065 Metetra
.795 .776 .836 r
.52384 .58065 .52773 .58459 .53491 .57872 .53103 .57477 Metetra
.761 .772 .863 r
.53103 .57477 .53491 .57872 .5421 .57412 .53824 .57015 Metetra
.718 .764 .889 r
.53824 .57015 .5421 .57412 .5493 .5707 .54546 .56672 Metetra
.665 .75 .914 r
.54546 .56672 .5493 .5707 .55653 .56843 .5527 .56443 Metetra
.595 .727 .936 r
.5527 .56443 .55653 .56843 .56379 .56729 .55997 .56329 Metetra
.501 .689 .952 r
.55997 .56329 .56379 .56729 .57109 .56733 .56728 .56333 Metetra
.371 .626 .952 r
.56728 .56333 .57109 .56733 .57844 .56863 .57464 .56462 Metetra
.197 .527 .921 r
.57464 .56462 .57844 .56863 .58585 .5713 .58206 .56729 Metetra
0 .382 .839 r
.58206 .56729 .58585 .5713 .59333 .57547 .58954 .57147 Metetra
0 .201 .7 r
.58954 .57147 .59333 .57547 .6009 .5813 .59711 .57732 Metetra
0 .019 .528 r
.59711 .57732 .6009 .5813 .60856 .58893 .60478 .58497 Metetra
.62 .129 0 r
.60478 .58497 .60856 .58893 .61633 .59839 .61256 .59445 Metetra
.71 .226 0 r
.61256 .59445 .61633 .59839 .62423 .60948 .62045 .60557 Metetra
.75 .273 0 r
.62045 .60557 .62423 .60948 .63223 .62163 .62846 .61774 Metetra
.739 .261 0 r
.62846 .61774 .63223 .62163 .64032 .63368 .63654 .62976 Metetra
.635 .143 0 r
.63654 .62976 .64032 .63368 .64843 .64385 .64465 .63983 Metetra
0 .227 .721 r
.64465 .63983 .64843 .64385 .65646 .64999 .65267 .64578 Metetra
.5 .687 .951 r
.65267 .64578 .65646 .64999 .66431 .65032 .66053 .64583 Metetra
.798 .774 .832 r
.66053 .64583 .66431 .65032 .67192 .6442 .66815 .63943 Metetra
.874 .769 .743 r
.66815 .63943 .67192 .6442 .67929 .63249 .67553 .62751 Metetra
.897 .761 .702 r
.67553 .62751 .67929 .63249 .68647 .61712 .68273 .61207 Metetra
.905 .758 .689 r
.68273 .61207 .68647 .61712 .69353 .60021 .68983 .5953 Metetra
.905 .762 .692 r
.68983 .5953 .69353 .60021 .70055 .58349 .6969 .57894 Metetra
.903 .773 .708 r
.6969 .57894 .70055 .58349 .7076 .56806 .704 .5641 Metetra
.9 .795 .736 r
.704 .5641 .7076 .56806 .71471 .55451 .71119 .55139 Metetra
.893 .832 .779 r
.71119 .55139 .71471 .55451 .72192 .54308 .71848 .54106 Metetra
.874 .896 .845 r
.71848 .54106 .72192 .54308 .72924 .53386 .72591 .53321 Metetra
.774 .975 .917 r
.72591 .53321 .72924 .53386 .73669 .52686 .73349 .52785 Metetra
.284 .773 .706 r
.73349 .52785 .73669 .52686 .74428 .52212 .74124 .52498 Metetra
.319 0 0 r
.74124 .52498 .74428 .52212 .75205 .51968 .74917 .52454 Metetra
.538 .092 .139 r
.74917 .52454 .75205 .51968 .76 .51963 .75729 .52639 Metetra
.616 .214 .258 r
.75729 .52639 .76 .51963 .76816 .52198 .76559 .53024 Metetra
.647 .268 .312 r
.76559 .53024 .76816 .52198 .77654 .52669 .77406 .53561 Metetra
.659 .287 .329 r
.77406 .53561 .77654 .52669 .78513 .5335 .78265 .54177 Metetra
.659 .278 .312 r
.78265 .54177 .78513 .5335 .79392 .54188 .79129 .54777 Metetra
.64 .219 .229 r
.79129 .54777 .79392 .54188 .80284 .55092 .7999 .55258 Metetra
.501 0 0 r
.7999 .55258 .80284 .55092 .81179 .5594 .80839 .5554 Metetra
.455 .68 .962 r
.80839 .5554 .81179 .5594 .82066 .56601 .81673 .55586 Metetra
.621 .565 .77 r
.81673 .55586 .82066 .56601 .82933 .56973 .82492 .55411 Metetra
.637 .516 .699 r
.82492 .55411 .82933 .56973 .83775 .57016 .83297 .55063 Metetra
.64 .496 .671 r
.83297 .55063 .83775 .57016 .84592 .56759 .84093 .546 Metetra
.641 .489 .661 r
.84093 .546 .84592 .56759 .8539 .56273 .84884 .54072 Metetra
.643 .489 .658 r
.84884 .54072 .8539 .56273 .86173 .55638 .85673 .53517 Metetra
.645 .493 .662 r
.85673 .53517 .86173 .55638 .86949 .54923 .86463 .52967 Metetra
.646 .5 .67 r
.86463 .52967 .86949 .54923 .87722 .5418 .87259 .52455 Metetra
.644 .511 .685 r
.87259 .52455 .87722 .5418 .88497 .53456 .88063 .52018 Metetra
.638 .527 .711 r
.88063 .52018 .88497 .53456 .89278 .52791 .88881 .5169 Metetra
.622 .554 .757 r
.88881 .5169 .89278 .52791 .90071 .5223 .89715 .51497 Metetra
.577 .604 .843 r
.89715 .51497 .90071 .5223 .90881 .51809 .9057 .51454 Metetra
.374 .664 .971 r
.9057 .51454 .90881 .51809 .91712 .51554 .91445 .51559 Metetra
.298 0 0 r
.91445 .51559 .91712 .51554 .92567 .51476 .9234 .51798 Metetra
.564 .057 .007 r
.9234 .51798 .92567 .51476 .93445 .51566 .93253 .52142 Metetra
.606 .169 .185 r
.93253 .52142 .93445 .51566 .94346 .518 .94179 .52542 Metetra
.606 .201 .249 r
.94179 .52542 .94346 .518 .95264 .5213 .95109 .52935 Metetra
.623 .739 .93 r
.3459 .62124 .35008 .62497 .3568 .62352 .35262 .61978 Metetra
.53 .708 .953 r
.35262 .61978 .3568 .62352 .36347 .6232 .35931 .61946 Metetra
.393 .649 .96 r
.35931 .61946 .36347 .6232 .37012 .62408 .36596 .62034 Metetra
.193 .543 .928 r
.36596 .62034 .37012 .62408 .37674 .62626 .37259 .62251 Metetra
0 .369 .821 r
.37259 .62251 .37674 .62626 .38333 .62986 .37919 .62611 Metetra
0 .145 .629 r
.37919 .62611 .38333 .62986 .38991 .63503 .38576 .63128 Metetra
.588 .071 0 r
.38576 .63128 .38991 .63503 .39646 .64192 .39232 .63816 Metetra
.73 .23 0 r
.39232 .63816 .39646 .64192 .40301 .65058 .39886 .64684 Metetra
.807 .331 0 r
.39886 .64684 .40301 .65058 .40956 .66096 .4054 .65721 Metetra
.843 .384 0 r
.4054 .65721 .40956 .66096 .41613 .67264 .41197 .6689 Metetra
.85 .395 .013 r
.41197 .6689 .41613 .67264 .42277 .68473 .4186 .68101 Metetra
.818 .346 0 r
.4186 .68101 .42277 .68473 .42951 .69575 .42534 .69203 Metetra
.654 .14 0 r
.42534 .69203 .42951 .69575 .4364 .70368 .43223 .69997 Metetra
.078 .479 .893 r
.43223 .69997 .4364 .70368 .44347 .70658 .4393 .70286 Metetra
.712 .774 .901 r
.4393 .70286 .44347 .70658 .4507 .70332 .44654 .6996 Metetra
.849 .778 .782 r
.44654 .6996 .4507 .70332 .45806 .69419 .45392 .69044 Metetra
.885 .767 .726 r
.45392 .69044 .45806 .69419 .46548 .6807 .46137 .67693 Metetra
.897 .761 .704 r
.46137 .67693 .46548 .6807 .47291 .66492 .46883 .66112 Metetra
.899 .76 .699 r
.46883 .66112 .47291 .66492 .4803 .64867 .47626 .64484 Metetra
.896 .762 .705 r
.47626 .64484 .4803 .64867 .48765 .63324 .48363 .62938 Metetra
.889 .765 .719 r
.48363 .62938 .48765 .63324 .49495 .61929 .49096 .61541 Metetra
.878 .769 .737 r
.49096 .61541 .49495 .61929 .50221 .6071 .49824 .60319 Metetra
.864 .773 .759 r
.49824 .60319 .50221 .6071 .50944 .59667 .50549 .59274 Metetra
.845 .775 .784 r
.50549 .59274 .50944 .59667 .51664 .5879 .51271 .58395 Metetra
.822 .777 .81 r
.51271 .58395 .51664 .5879 .52384 .58065 .51993 .57668 Metetra
.795 .776 .836 r
.51993 .57668 .52384 .58065 .53103 .57477 .52714 .57079 Metetra
.761 .772 .863 r
.52714 .57079 .53103 .57477 .53824 .57015 .53436 .56616 Metetra
.718 .764 .889 r
.53436 .56616 .53824 .57015 .54546 .56672 .54159 .56272 Metetra
.665 .75 .914 r
.54159 .56272 .54546 .56672 .5527 .56443 .54885 .56042 Metetra
.594 .727 .936 r
.54885 .56042 .5527 .56443 .55997 .56329 .55613 .55927 Metetra
.5 .688 .952 r
.55613 .55927 .55997 .56329 .56728 .56333 .56345 .55931 Metetra
.37 .625 .952 r
.56345 .55931 .56728 .56333 .57464 .56462 .57082 .56061 Metetra
.193 .525 .92 r
.57082 .56061 .57464 .56462 .58206 .56729 .57825 .56328 Metetra
0 .378 .836 r
.57825 .56328 .58206 .56729 .58954 .57147 .58574 .56748 Metetra
0 .195 .694 r
.58574 .56748 .58954 .57147 .59711 .57732 .59331 .57336 Metetra
0 .013 .52 r
.59331 .57336 .59711 .57732 .60478 .58497 .60098 .58104 Metetra
.626 .133 0 r
.60098 .58104 .60478 .58497 .61256 .59445 .60876 .59054 Metetra
.712 .227 0 r
.60876 .59054 .61256 .59445 .62045 .60557 .61666 .60165 Metetra
.746 .269 0 r
.61666 .60165 .62045 .60557 .62846 .61774 .62466 .61373 Metetra
.725 .246 0 r
.62466 .61373 .62846 .61774 .63654 .62976 .63274 .62555 Metetra
.586 .102 0 r
.63274 .62555 .63654 .62976 .64465 .63983 .64083 .63529 Metetra
0 .302 .79 r
.64083 .63529 .64465 .63983 .65267 .64578 .64885 .6408 Metetra
.551 .673 .919 r
.64885 .6408 .65267 .64578 .66053 .64583 .6567 .64044 Metetra
.788 .741 .809 r
.6567 .64044 .66053 .64583 .66815 .63943 .66433 .63379 Metetra
.858 .745 .737 r
.66433 .63379 .66815 .63943 .67553 .62751 .67173 .62193 Metetra
.885 .747 .704 r
.67173 .62193 .67553 .62751 .68273 .61207 .67897 .60689 Metetra
.899 .756 .695 r
.67897 .60689 .68273 .61207 .68983 .5953 .68613 .59084 Metetra
.907 .775 .703 r
.68613 .59084 .68983 .5953 .6969 .57894 .69328 .57546 Metetra
.915 .807 .727 r
.69328 .57546 .6969 .57894 .704 .5641 .70048 .56184 Metetra
.919 .861 .768 r
.70048 .56184 .704 .5641 .71119 .55139 .70777 .55055 Metetra
.9 .946 .827 r
.70777 .55055 .71119 .55139 .71848 .54106 .71519 .54183 Metetra
.72 .987 .822 r
.71519 .54183 .71848 .54106 .72591 .53321 .72275 .53574 Metetra
.72275 .53574 .72591 .53321 .73349 .52785 .73048 .5322 Metetra
.345 0 .002 r
.73048 .5322 .73349 .52785 .74124 .52498 .73837 .531 Metetra
.507 .089 .181 r
.73837 .531 .74124 .52498 .74917 .52454 .74642 .53181 Metetra
.572 .177 .256 r
.74642 .53181 .74917 .52454 .75729 .52639 .75461 .53414 Metetra
.596 .209 .279 r
.75461 .53414 .75729 .52639 .76559 .53024 .76291 .53731 Metetra
.594 .195 .256 r
.76291 .53731 .76559 .53024 .77406 .53561 .77125 .54046 Metetra
.552 .103 .138 r
.77125 .54046 .77406 .53561 .78265 .54177 .77957 .54273 Metetra
.245 0 0 r
.77957 .54273 .78265 .54177 .79129 .54777 .78782 .5434 Metetra
.592 .725 .936 r
.78782 .5434 .79129 .54777 .7999 .55258 .79595 .54216 Metetra
.651 .577 .758 r
.79595 .54216 .7999 .55258 .80839 .5554 .80396 .53915 Metetra
.648 .518 .691 r
.80396 .53915 .80839 .5554 .81673 .55586 .81187 .53483 Metetra
.641 .49 .663 r
.81187 .53483 .81673 .55586 .82492 .55411 .81974 .52975 Metetra
.634 .475 .649 r
.81974 .52975 .82492 .55411 .83297 .55063 .82759 .5244 Metetra
.629 .466 .643 r
.82759 .5244 .83297 .55063 .84093 .546 .83546 .51915 Metetra
.624 .461 .642 r
.83546 .51915 .84093 .546 .84884 .54072 .84337 .51429 Metetra
.618 .459 .644 r
.84337 .51429 .84884 .54072 .85673 .53517 .85136 .51012 Metetra
.61 .457 .649 r
.85136 .51012 .85673 .53517 .86463 .52967 .85947 .50691 Metetra
.599 .457 .66 r
.85947 .50691 .86463 .52967 .87259 .52455 .86772 .50493 Metetra
.583 .46 .678 r
.86772 .50493 .87259 .52455 .88063 .52018 .87614 .50435 Metetra
.557 .466 .708 r
.87614 .50435 .88063 .52018 .88881 .5169 .88476 .50524 Metetra
.507 .478 .759 r
.88476 .50524 .88881 .5169 .89715 .51497 .89357 .50756 Metetra
.379 .489 .846 r
.89357 .50756 .89715 .51497 .9057 .51454 .90259 .51119 Metetra
0 .395 .839 r
.90259 .51119 .9057 .51454 .91445 .51559 .91178 .51591 Metetra
.559 0 0 r
.91178 .51591 .91445 .51559 .9234 .51798 .92113 .52137 Metetra
.649 .155 .064 r
.92113 .52137 .9234 .51798 .93253 .52142 .93057 .5271 Metetra
.641 .202 .19 r
.93057 .5271 .93253 .52142 .94179 .52542 .94003 .53244 Metetra
.609 .195 .232 r
.94003 .53244 .94179 .52542 .95109 .52935 .94941 .53654 Metetra
.623 .739 .93 r
.3417 .6175 .3459 .62124 .35262 .61978 .34843 .61603 Metetra
.53 .708 .953 r
.34843 .61603 .35262 .61978 .35931 .61946 .35512 .6157 Metetra
.393 .649 .96 r
.35512 .6157 .35931 .61946 .36596 .62034 .36178 .61657 Metetra
.193 .543 .928 r
.36178 .61657 .36596 .62034 .37259 .62251 .36841 .61874 Metetra
0 .369 .821 r
.36841 .61874 .37259 .62251 .37919 .62611 .37502 .62234 Metetra
0 .145 .629 r
.37502 .62234 .37919 .62611 .38576 .63128 .38159 .62751 Metetra
.588 .071 0 r
.38159 .62751 .38576 .63128 .39232 .63816 .38815 .63439 Metetra
.73 .23 0 r
.38815 .63439 .39232 .63816 .39886 .64684 .39469 .64307 Metetra
.807 .331 0 r
.39469 .64307 .39886 .64684 .4054 .65721 .40123 .65345 Metetra
.843 .384 0 r
.40123 .65345 .4054 .65721 .41197 .6689 .40779 .66515 Metetra
.85 .395 .013 r
.40779 .66515 .41197 .6689 .4186 .68101 .41441 .67727 Metetra
.818 .346 0 r
.41441 .67727 .4186 .68101 .42534 .69203 .42115 .6883 Metetra
.654 .14 0 r
.42115 .6883 .42534 .69203 .43223 .69997 .42803 .69624 Metetra
.078 .479 .893 r
.42803 .69624 .43223 .69997 .4393 .70286 .43511 .69913 Metetra
.712 .774 .901 r
.43511 .69913 .4393 .70286 .44654 .6996 .44237 .69585 Metetra
.849 .778 .782 r
.44237 .69585 .44654 .6996 .45392 .69044 .44977 .68668 Metetra
.885 .767 .726 r
.44977 .68668 .45392 .69044 .46137 .67693 .45725 .67314 Metetra
.897 .761 .704 r
.45725 .67314 .46137 .67693 .46883 .66112 .46473 .6573 Metetra
.899 .76 .699 r
.46473 .6573 .46883 .66112 .47626 .64484 .47219 .64099 Metetra
.896 .762 .705 r
.47219 .64099 .47626 .64484 .48363 .62938 .47959 .6255 Metetra
.889 .765 .719 r
.47959 .6255 .48363 .62938 .49096 .61541 .48695 .61151 Metetra
.878 .769 .737 r
.48695 .61151 .49096 .61541 .49824 .60319 .49425 .59927 Metetra
.864 .773 .759 r
.49425 .59927 .49824 .60319 .50549 .59274 .50152 .5888 Metetra
.845 .775 .784 r
.50152 .5888 .50549 .59274 .51271 .58395 .50877 .57999 Metetra
.822 .777 .81 r
.50877 .57999 .51271 .58395 .51993 .57668 .516 .5727 Metetra
.795 .776 .836 r
.516 .5727 .51993 .57668 .52714 .57079 .52323 .56679 Metetra
.76 .772 .863 r
.52323 .56679 .52714 .57079 .53436 .56616 .53046 .56215 Metetra
.718 .764 .889 r
.53046 .56215 .53436 .56616 .54159 .56272 .53771 .5587 Metetra
.664 .75 .914 r
.53771 .5587 .54159 .56272 .54885 .56042 .54498 .5564 Metetra
.594 .727 .937 r
.54498 .5564 .54885 .56042 .55613 .55927 .55228 .55525 Metetra
.498 .688 .953 r
.55228 .55525 .55613 .55927 .56345 .55931 .55961 .55529 Metetra
.366 .625 .952 r
.55961 .55529 .56345 .55931 .57082 .56061 .56698 .5566 Metetra
.186 .523 .919 r
.56698 .5566 .57082 .56061 .57825 .56328 .57442 .5593 Metetra
0 .373 .832 r
.57442 .5593 .57825 .56328 .58574 .56748 .58192 .56352 Metetra
0 .19 .688 r
.58192 .56352 .58574 .56748 .59331 .57336 .58949 .56941 Metetra
0 .011 .517 r
.58949 .56941 .59331 .57336 .60098 .58104 .59717 .57708 Metetra
.62 .127 0 r
.59717 .57708 .60098 .58104 .60876 .59054 .60495 .5865 Metetra
.694 .211 0 r
.60495 .5865 .60876 .59054 .61666 .60165 .61283 .59742 Metetra
.712 .236 0 r
.61283 .59742 .61666 .60165 .62466 .61373 .62083 .60913 Metetra
.653 .183 0 r
.62083 .60913 .62466 .61373 .63274 .62555 .62889 .62039 Metetra
0 .019 .564 r
.62889 .62039 .63274 .62555 .64083 .63529 .63696 .62942 Metetra
.135 .399 .849 r
.63696 .62942 .64083 .63529 .64885 .6408 .64495 .63429 Metetra
.585 .629 .861 r
.64495 .63429 .64885 .6408 .6567 .64044 .6528 .6336 Metetra
.762 .693 .786 r
.6528 .6336 .6567 .64044 .66433 .63379 .66045 .62716 Metetra
.834 .718 .737 r
.66045 .62716 .66433 .63379 .67173 .62193 .66791 .61608 Metetra
.873 .742 .715 r
.66791 .61608 .67173 .62193 .67897 .60689 .67523 .6023 Metetra
.899 .773 .713 r
.67523 .6023 .67897 .60689 .68613 .59084 .68248 .5878 Metetra
.922 .821 .729 r
.68248 .5878 .68613 .59084 .69328 .57546 .68974 .57414 Metetra
.937 .893 .76 r
.68974 .57414 .69328 .57546 .70048 .56184 .69707 .56232 Metetra
.902 .983 .785 r
.69707 .56232 .70048 .56184 .70777 .55055 .7045 .55285 Metetra
.593 .903 .633 r
.7045 .55285 .70777 .55055 .71519 .54183 .71205 .54589 Metetra
.71205 .54589 .71519 .54183 .72275 .53574 .71974 .54132 Metetra
.31 0 .064 r
.71974 .54132 .72275 .53574 .73048 .5322 .72757 .53884 Metetra
.438 .035 .176 r
.72757 .53884 .73048 .5322 .73837 .531 .73552 .53793 Metetra
.484 .084 .206 r
.73552 .53793 .73837 .531 .74642 .53181 .74356 .53793 Metetra
.474 .057 .167 r
.74356 .53793 .74642 .53181 .75461 .53414 .75163 .53802 Metetra
.358 0 0 r
.75163 .53802 .75461 .53414 .76291 .53731 .75969 .53736 Metetra
.328 .813 .843 r
.75969 .53736 .76291 .53731 .77125 .54046 .76768 .53526 Metetra
.715 .734 .866 r
.76768 .53526 .77125 .54046 .77957 .54273 .77555 .53144 Metetra
.695 .588 .732 r
.77555 .53144 .77957 .54273 .78782 .5434 .78333 .52601 Metetra
.673 .526 .677 r
.78333 .52601 .78782 .5434 .79595 .54216 .79101 .51945 Metetra
.657 .494 .652 r
.79101 .51945 .79595 .54216 .80396 .53915 .79866 .51235 Metetra
.645 .475 .639 r
.79866 .51235 .80396 .53915 .81187 .53483 .80631 .50523 Metetra
.635 .462 .632 r
.80631 .50523 .81187 .53483 .81974 .52975 .81399 .49853 Metetra
.625 .453 .629 r
.81399 .49853 .81974 .52975 .82759 .5244 .82174 .49258 Metetra
.615 .445 .628 r
.82174 .49258 .82759 .5244 .83546 .51915 .82959 .48771 Metetra
.604 .438 .63 r
.82959 .48771 .83546 .51915 .84337 .51429 .83758 .4842 Metetra
.59 .432 .635 r
.83758 .4842 .84337 .51429 .85136 .51012 .84575 .48233 Metetra
.574 .425 .642 r
.84575 .48233 .85136 .51012 .85947 .50691 .85413 .48223 Metetra
.552 .42 .654 r
.85413 .48223 .85947 .50691 .86772 .50493 .86272 .48394 Metetra
.52 .413 .672 r
.86272 .48394 .86772 .50493 .87614 .50435 .87154 .48739 Metetra
.472 .404 .7 r
.87154 .48739 .87614 .50435 .88476 .50524 .88059 .49245 Metetra
.385 .388 .74 r
.88059 .49245 .88476 .50524 .89357 .50756 .88986 .49895 Metetra
.198 .342 .784 r
.88986 .49895 .89357 .50756 .90259 .51119 .89933 .50662 Metetra
0 .18 .704 r
.89933 .50662 .90259 .51119 .91178 .51591 .90897 .51514 Metetra
.649 .098 0 r
.90897 .51514 .91178 .51591 .92113 .52137 .91874 .524 Metetra
.718 .219 .052 r
.91874 .524 .92113 .52137 .93057 .5271 .92854 .53245 Metetra
.681 .235 .186 r
.92854 .53245 .93057 .5271 .94003 .53244 .93825 .53945 Metetra
.614 .198 .231 r
.93825 .53945 .94003 .53244 .94941 .53654 .9477 .5438 Metetra
.623 .739 .93 r
.33748 .61374 .3417 .6175 .34843 .61603 .34422 .61226 Metetra
.53 .708 .953 r
.34422 .61226 .34843 .61603 .35512 .6157 .35092 .61192 Metetra
.393 .649 .96 r
.35092 .61192 .35512 .6157 .36178 .61657 .35759 .61279 Metetra
.193 .543 .928 r
.35759 .61279 .36178 .61657 .36841 .61874 .36422 .61496 Metetra
0 .369 .821 r
.36422 .61496 .36841 .61874 .37502 .62234 .37083 .61855 Metetra
0 .145 .629 r
.37083 .61855 .37502 .62234 .38159 .62751 .3774 .62372 Metetra
.588 .071 0 r
.3774 .62372 .38159 .62751 .38815 .63439 .38396 .6306 Metetra
.73 .23 0 r
.38396 .6306 .38815 .63439 .39469 .64307 .3905 .63929 Metetra
.807 .331 0 r
.3905 .63929 .39469 .64307 .40123 .65345 .39703 .64968 Metetra
.843 .384 0 r
.39703 .64968 .40123 .65345 .40779 .66515 .40359 .66138 Metetra
.85 .395 .013 r
.40359 .66138 .40779 .66515 .41441 .67727 .41021 .67351 Metetra
.818 .346 0 r
.41021 .67351 .41441 .67727 .42115 .6883 .41693 .68454 Metetra
.654 .14 0 r
.41693 .68454 .42115 .6883 .42803 .69624 .42382 .69249 Metetra
.078 .479 .893 r
.42382 .69249 .42803 .69624 .43511 .69913 .4309 .69538 Metetra
.712 .774 .901 r
.4309 .69538 .43511 .69913 .44237 .69585 .43818 .69209 Metetra
.849 .778 .782 r
.43818 .69209 .44237 .69585 .44977 .68668 .4456 .6829 Metetra
.885 .767 .726 r
.4456 .6829 .44977 .68668 .45725 .67314 .4531 .66933 Metetra
.897 .761 .704 r
.4531 .66933 .45725 .67314 .46473 .6573 .46062 .65346 Metetra
.899 .76 .699 r
.46062 .65346 .46473 .6573 .47219 .64099 .4681 .63713 Metetra
.896 .762 .705 r
.4681 .63713 .47219 .64099 .47959 .6255 .47554 .62161 Metetra
.889 .765 .719 r
.47554 .62161 .47959 .6255 .48695 .61151 .48291 .60759 Metetra
.878 .769 .737 r
.48291 .60759 .48695 .61151 .49425 .59927 .49024 .59532 Metetra
.864 .773 .759 r
.49024 .59532 .49425 .59927 .50152 .5888 .49754 .58483 Metetra
.845 .775 .784 r
.49754 .58483 .50152 .5888 .50877 .57999 .5048 .57601 Metetra
.822 .777 .81 r
.5048 .57601 .50877 .57999 .516 .5727 .51205 .5687 Metetra
.795 .776 .836 r
.51205 .5687 .516 .5727 .52323 .56679 .5193 .56278 Metetra
.76 .772 .863 r
.5193 .56278 .52323 .56679 .53046 .56215 .52655 .55813 Metetra
.718 .765 .889 r
.52655 .55813 .53046 .56215 .53771 .5587 .53381 .55468 Metetra
.664 .751 .915 r
.53381 .55468 .53771 .5587 .54498 .5564 .54109 .55238 Metetra
.592 .728 .938 r
.54109 .55238 .54498 .5564 .55228 .55525 .5484 .55124 Metetra
.495 .689 .954 r
.5484 .55124 .55228 .55525 .55961 .55529 .55574 .55129 Metetra
.36 .624 .953 r
.55574 .55129 .55961 .55529 .56698 .5566 .56313 .55262 Metetra
.179 .521 .918 r
.56313 .55262 .56698 .5566 .57442 .5593 .57057 .55533 Metetra
0 .373 .832 r
.57057 .55533 .57442 .5593 .58192 .56352 .57807 .55953 Metetra
0 .199 .696 r
.57807 .55953 .58192 .56352 .58949 .56941 .58566 .56534 Metetra
0 .038 .549 r
.58566 .56534 .58949 .56941 .59717 .57708 .59333 .57281 Metetra
.561 .077 0 r
.59333 .57281 .59717 .57708 .60495 .5865 .6011 .58186 Metetra
.603 .134 0 r
.6011 .58186 .60495 .5865 .61283 .59742 .60897 .59213 Metetra
0 0 .424 r
.60897 .59213 .61283 .59742 .62083 .60913 .61693 .60293 Metetra
0 0 .559 r
.61693 .60293 .62083 .60913 .62889 .62039 .62495 .6131 Metetra
0 .218 .738 r
.62495 .6131 .62889 .62039 .63696 .62942 .63299 .62111 Metetra
.334 .437 .818 r
.63299 .62111 .63696 .62942 .64495 .63429 .64096 .62543 Metetra
.581 .565 .801 r
.64096 .62543 .64495 .63429 .6528 .6336 .64882 .62502 Metetra
.716 .638 .769 r
.64882 .62502 .6528 .6336 .66045 .62716 .65653 .61979 Metetra
.798 .694 .749 r
.65653 .61979 .66045 .62716 .66791 .61608 .66408 .61069 Metetra
.859 .753 .745 r
.66408 .61069 .66791 .61608 .67523 .6023 .67153 .59931 Metetra
.909 .829 .755 r
.67153 .59931 .67523 .6023 .68248 .5878 .67893 .5873 Metetra
.939 .928 .768 r
.67893 .5873 .68248 .5878 .68974 .57414 .68634 .576 Metetra
.846 .986 .71 r
.68634 .576 .68974 .57414 .69707 .56232 .69381 .56625 Metetra
.69381 .56625 .69707 .56232 .7045 .55285 .70136 .55843 Metetra
.015 0 0 r
.70136 .55843 .7045 .55285 .71205 .54589 .70901 .5525 Metetra
.227 0 .078 r
.70901 .5525 .71205 .54589 .71974 .54132 .71676 .54811 Metetra
.3 0 .119 r
.71676 .54811 .71974 .54132 .72757 .53884 .72457 .54466 Metetra
.265 0 .055 r
.72457 .54466 .72757 .53884 .73552 .53793 .73242 .54139 Metetra
.73242 .54139 .73552 .53793 .74356 .53793 .74023 .53745 Metetra
.749 .98 .914 r
.74023 .53745 .74356 .53793 .75163 .53802 .74798 .53217 Metetra
.79 .734 .801 r
.74798 .53217 .75163 .53802 .75969 .53736 .75561 .52525 Metetra
.734 .6 .707 r
.75561 .52525 .75969 .53736 .76768 .53526 .76314 .51681 Metetra
.7 .538 .664 r
.76314 .51681 .76768 .53526 .77555 .53144 .77059 .50737 Metetra
.678 .503 .642 r
.77059 .50737 .77555 .53144 .78333 .52601 .778 .49753 Metetra
.662 .482 .631 r
.778 .49753 .78333 .52601 .79101 .51945 .7854 .48788 Metetra
.649 .468 .625 r
.7854 .48788 .79101 .51945 .79866 .51235 .79285 .47886 Metetra
.637 .457 .622 r
.79285 .47886 .79866 .51235 .80631 .50523 .80037 .47083 Metetra
.626 .447 .621 r
.80037 .47083 .80631 .50523 .81399 .49853 .80799 .46412 Metetra
.613 .439 .622 r
.80799 .46412 .81399 .49853 .82174 .49258 .81576 .45903 Metetra
.599 .431 .625 r
.81576 .45903 .82174 .49258 .82959 .48771 .82371 .4558 Metetra
.583 .422 .63 r
.82371 .4558 .82959 .48771 .83758 .4842 .83187 .45458 Metetra
.563 .413 .636 r
.83187 .45458 .83758 .4842 .84575 .48233 .84025 .45541 Metetra
.538 .404 .646 r
.84025 .45541 .84575 .48233 .85413 .48223 .84888 .45826 Metetra
.506 .392 .657 r
.84888 .45826 .85413 .48223 .86272 .48394 .85775 .46305 Metetra
.463 .376 .672 r
.85775 .46305 .86272 .48394 .87154 .48739 .86687 .46969 Metetra
.399 .352 .69 r
.86687 .46969 .87154 .48739 .88059 .49245 .87625 .47809 Metetra
.295 .312 .709 r
.87625 .47809 .88059 .49245 .88986 .49895 .8859 .48818 Metetra
.103 .234 .715 r
.8859 .48818 .88986 .49895 .89933 .50662 .8958 .49978 Metetra
0 .065 .628 r
.8958 .49978 .89933 .50662 .90897 .51514 .90593 .51251 Metetra
.677 .18 0 r
.90593 .51251 .90897 .51514 .91874 .524 .91621 .52565 Metetra
.785 .294 .043 r
.91621 .52565 .91874 .524 .92854 .53245 .9265 .53793 Metetra
.728 .289 .207 r
.9265 .53793 .92854 .53245 .93825 .53945 .93656 .54748 Metetra
.618 .217 .262 r
.93656 .54748 .93825 .53945 .9477 .5438 .94608 .55208 Metetra
.623 .739 .93 r
.33323 .60996 .33748 .61374 .34422 .61226 .33998 .60847 Metetra
.53 .708 .953 r
.33998 .60847 .34422 .61226 .35092 .61192 .34669 .60813 Metetra
.393 .649 .96 r
.34669 .60813 .35092 .61192 .35759 .61279 .35337 .60899 Metetra
.193 .543 .928 r
.35337 .60899 .35759 .61279 .36422 .61496 .36001 .61115 Metetra
0 .369 .821 r
.36001 .61115 .36422 .61496 .37083 .61855 .36662 .61474 Metetra
0 .145 .629 r
.36662 .61474 .37083 .61855 .3774 .62372 .3732 .61991 Metetra
.588 .071 0 r
.3732 .61991 .3774 .62372 .38396 .6306 .37975 .6268 Metetra
.73 .23 0 r
.37975 .6268 .38396 .6306 .3905 .63929 .38628 .63548 Metetra
.807 .331 0 r
.38628 .63548 .3905 .63929 .39703 .64968 .39282 .64588 Metetra
.843 .384 0 r
.39282 .64588 .39703 .64968 .40359 .66138 .39937 .65759 Metetra
.85 .395 .013 r
.39937 .65759 .40359 .66138 .41021 .67351 .40598 .66973 Metetra
.818 .346 0 r
.40598 .66973 .41021 .67351 .41693 .68454 .4127 .68077 Metetra
.654 .14 0 r
.4127 .68077 .41693 .68454 .42382 .69249 .41959 .68872 Metetra
.078 .479 .893 r
.41959 .68872 .42382 .69249 .4309 .69538 .42667 .69161 Metetra
.712 .774 .901 r
.42667 .69161 .4309 .69538 .43818 .69209 .43396 .68831 Metetra
.849 .778 .782 r
.43396 .68831 .43818 .69209 .4456 .6829 .44141 .67909 Metetra
.885 .767 .726 r
.44141 .67909 .4456 .6829 .4531 .66933 .44893 .6655 Metetra
.897 .761 .704 r
.44893 .6655 .4531 .66933 .46062 .65346 .45648 .6496 Metetra
.899 .76 .699 r
.45648 .6496 .46062 .65346 .4681 .63713 .46399 .63324 Metetra
.896 .762 .705 r
.46399 .63324 .4681 .63713 .47554 .62161 .47146 .61769 Metetra
.889 .765 .719 r
.47146 .61769 .47554 .62161 .48291 .60759 .47886 .60365 Metetra
.878 .769 .737 r
.47886 .60365 .48291 .60759 .49024 .59532 .48622 .59136 Metetra
.864 .773 .759 r
.48622 .59136 .49024 .59532 .49754 .58483 .49353 .58085 Metetra
.845 .776 .784 r
.49353 .58085 .49754 .58483 .5048 .57601 .50082 .57201 Metetra
.822 .777 .81 r
.50082 .57201 .5048 .57601 .51205 .5687 .50809 .56469 Metetra
.795 .776 .836 r
.50809 .56469 .51205 .5687 .5193 .56278 .51535 .55877 Metetra
.76 .773 .863 r
.51535 .55877 .5193 .56278 .52655 .55813 .52261 .55411 Metetra
.717 .766 .89 r
.52261 .55411 .52655 .55813 .53381 .55468 .52989 .55066 Metetra
.662 .752 .917 r
.52989 .55066 .53381 .55468 .54109 .55238 .53718 .54837 Metetra
.59 .729 .94 r
.53718 .54837 .54109 .55238 .5484 .55124 .5445 .54724 Metetra
.492 .69 .955 r
.5445 .54724 .5484 .55124 .55574 .55129 .55186 .5473 Metetra
.36 .626 .954 r
.55186 .5473 .55574 .55129 .56313 .55262 .55925 .54861 Metetra
.192 .528 .921 r
.55925 .54861 .56313 .55262 .57057 .55533 .5667 .55123 Metetra
.003 .399 .851 r
.5667 .55123 .57057 .55533 .57807 .55953 .57421 .55524 Metetra
0 .262 .756 r
.57421 .55524 .57807 .55953 .58566 .56534 .58179 .56066 Metetra
0 .149 .671 r
.58179 .56066 .58566 .56534 .59333 .57281 .58945 .56748 Metetra
0 .086 .629 r
.58945 .56748 .59333 .57281 .6011 .58186 .59719 .57552 Metetra
0 .084 .64 r
.59719 .57552 .6011 .58186 .60897 .59213 .60503 .58444 Metetra
0 .142 .686 r
.60503 .58444 .60897 .59213 .61693 .60293 .61294 .59364 Metetra
.064 .237 .731 r
.61294 .59364 .61693 .60293 .62495 .6131 .62091 .60228 Metetra
.261 .335 .751 r
.62091 .60228 .62495 .6131 .63299 .62111 .6289 .60931 Metetra
.419 .419 .753 r
.6289 .60931 .63299 .62111 .64096 .62543 .63687 .61372 Metetra
.54 .495 .754 r
.63687 .61372 .64096 .62543 .64882 .62502 .64478 .61475 Metetra
.641 .572 .762 r
.64478 .61475 .64882 .62502 .65653 .61979 .65259 .61223 Metetra
.735 .667 .784 r
.65259 .61223 .65653 .61979 .66408 .61069 .6603 .60664 Metetra
.833 .799 .819 r
.6603 .60664 .66408 .61069 .67153 .59931 .66792 .59894 Metetra
.894 .963 .829 r
.66792 .59894 .67153 .59931 .67893 .5873 .67551 .59027 Metetra
.668 .914 .595 r
.67551 .59027 .67893 .5873 .68634 .576 .68308 .58157 Metetra
.68308 .58157 .68634 .576 .69381 .56625 .69067 .57346 Metetra
.033 0 .015 r
.69067 .57346 .69381 .56625 .70136 .55843 .6983 .56609 Metetra
.109 0 .07 r
.6983 .56609 .70136 .55843 .70901 .5525 .70595 .55923 Metetra
.038 0 0 r
.70595 .55923 .70901 .5525 .71676 .54811 .7136 .55233 Metetra
.7136 .55233 .71676 .54811 .72457 .54466 .7212 .5447 Metetra
.894 .981 .808 r
.7212 .5447 .72457 .54466 .73242 .54139 .72873 .53573 Metetra
.85 .752 .754 r
.72873 .53573 .73242 .54139 .74023 .53745 .73614 .52518 Metetra
.774 .619 .687 r
.73614 .52518 .74023 .53745 .74798 .53217 .74345 .51325 Metetra
.729 .553 .653 r
.74345 .51325 .74798 .53217 .75561 .52525 .75067 .50051 Metetra
.7 .516 .635 r
.75067 .50051 .75561 .52525 .76314 .51681 .75787 .48765 Metetra
.68 .493 .626 r
.75787 .48765 .76314 .51681 .77059 .50737 .76506 .47527 Metetra
.665 .477 .621 r
.76506 .47527 .77059 .50737 .778 .49753 .7723 .4638 Metetra
.652 .466 .619 r
.7723 .4638 .778 .49753 .7854 .48788 .77962 .45357 Metetra
.64 .457 .619 r
.77962 .45357 .7854 .48788 .79285 .47886 .78703 .44485 Metetra
.628 .449 .621 r
.78703 .44485 .79285 .47886 .80037 .47083 .79458 .43786 Metetra
.614 .441 .624 r
.79458 .43786 .80037 .47083 .80799 .46412 .8023 .43281 Metetra
.599 .434 .629 r
.8023 .43281 .80799 .46412 .81576 .45903 .81021 .42979 Metetra
.581 .426 .636 r
.81021 .42979 .81576 .45903 .82371 .4558 .81831 .42881 Metetra
.56 .417 .643 r
.81831 .42881 .82371 .4558 .83187 .45458 .82664 .42981 Metetra
.534 .406 .652 r
.82664 .42981 .83187 .45458 .84025 .45541 .83518 .43271 Metetra
.502 .393 .662 r
.83518 .43271 .84025 .45541 .84888 .45826 .84395 .43744 Metetra
.462 .375 .671 r
.84395 .43744 .84888 .45826 .85775 .46305 .85297 .44401 Metetra
.409 .349 .68 r
.85297 .44401 .85775 .46305 .86687 .46969 .86226 .45253 Metetra
.332 .312 .686 r
.86226 .45253 .86687 .46969 .87625 .47809 .87185 .46315 Metetra
.212 .252 .686 r
.87185 .46315 .87625 .47809 .8859 .48818 .88178 .47605 Metetra
.005 .145 .66 r
.88178 .47605 .8859 .48818 .8958 .49978 .89208 .49132 Metetra
0 0 .536 r
.89208 .49132 .8958 .49978 .90593 .51251 .90273 .50868 Metetra
.735 .285 0 r
.90273 .50868 .90593 .51251 .91621 .52565 .91363 .5271 Metetra
.84 .377 .093 r
.91363 .5271 .91621 .52565 .9265 .53793 .92453 .54434 Metetra
.763 .342 .249 r
.92453 .54434 .9265 .53793 .93656 .54748 .93499 .55683 Metetra
.594 .213 .289 r
.93499 .55683 .93656 .54748 .94608 .55208 .94445 .56048 Metetra
.623 .739 .93 r
.32897 .60617 .33323 .60996 .33998 .60847 .33573 .60467 Metetra
.53 .708 .953 r
.33573 .60467 .33998 .60847 .34669 .60813 .34245 .60432 Metetra
.393 .649 .96 r
.34245 .60432 .34669 .60813 .35337 .60899 .34913 .60517 Metetra
.193 .543 .928 r
.34913 .60517 .35337 .60899 .36001 .61115 .35578 .60733 Metetra
0 .369 .821 r
.35578 .60733 .36001 .61115 .36662 .61474 .36239 .61091 Metetra
0 .145 .629 r
.36239 .61091 .36662 .61474 .3732 .61991 .36897 .61608 Metetra
.588 .071 0 r
.36897 .61608 .3732 .61991 .37975 .6268 .37552 .62297 Metetra
.73 .23 0 r
.37552 .62297 .37975 .6268 .38628 .63548 .38205 .63166 Metetra
.807 .331 0 r
.38205 .63166 .38628 .63548 .39282 .64588 .38858 .64207 Metetra
.843 .384 0 r
.38858 .64207 .39282 .64588 .39937 .65759 .39512 .65379 Metetra
.85 .395 .013 r
.39512 .65379 .39937 .65759 .40598 .66973 .40173 .66593 Metetra
.818 .346 0 r
.40173 .66593 .40598 .66973 .4127 .68077 .40844 .67698 Metetra
.654 .14 0 r
.40844 .67698 .4127 .68077 .41959 .68872 .41533 .68494 Metetra
.078 .479 .893 r
.41533 .68494 .41959 .68872 .42667 .69161 .42242 .68782 Metetra
.712 .774 .901 r
.42242 .68782 .42667 .69161 .43396 .68831 .42973 .68451 Metetra
.849 .778 .782 r
.42973 .68451 .43396 .68831 .44141 .67909 .43719 .67527 Metetra
.885 .767 .726 r
.43719 .67527 .44141 .67909 .44893 .6655 .44475 .66166 Metetra
.897 .761 .704 r
.44475 .66166 .44893 .6655 .45648 .6496 .45232 .64572 Metetra
.899 .76 .699 r
.45232 .64572 .45648 .6496 .46399 .63324 .45987 .62933 Metetra
.896 .762 .705 r
.45987 .62933 .46399 .63324 .47146 .61769 .46736 .61376 Metetra
.889 .765 .719 r
.46736 .61376 .47146 .61769 .47886 .60365 .47479 .59969 Metetra
.878 .769 .737 r
.47479 .59969 .47886 .60365 .48622 .59136 .48217 .58738 Metetra
.864 .773 .76 r
.48217 .58738 .48622 .59136 .49353 .58085 .48951 .57686 Metetra
.845 .776 .784 r
.48951 .57686 .49353 .58085 .50082 .57201 .49681 .568 Metetra
.822 .778 .81 r
.49681 .568 .50082 .57201 .50809 .56469 .5041 .56068 Metetra
.794 .777 .837 r
.5041 .56068 .50809 .56469 .51535 .55877 .51138 .55475 Metetra
.76 .774 .865 r
.51138 .55475 .51535 .55877 .52261 .55411 .51866 .55011 Metetra
.717 .767 .892 r
.51866 .55011 .52261 .55411 .52989 .55066 .52595 .54666 Metetra
.662 .754 .918 r
.52595 .54666 .52989 .55066 .53718 .54837 .53326 .54437 Metetra
.591 .73 .94 r
.53326 .54437 .53718 .54837 .5445 .54724 .54059 .54321 Metetra
.5 .692 .954 r
.54059 .54321 .5445 .54724 .55186 .5473 .54795 .54318 Metetra
.39 .635 .952 r
.54795 .54318 .55186 .5473 .55925 .54861 .55535 .54429 Metetra
.271 .558 .931 r
.55535 .54429 .55925 .54861 .5667 .55123 .5628 .54653 Metetra
.166 .475 .894 r
.5628 .54653 .5667 .55123 .57421 .55524 .57031 .5499 Metetra
.104 .401 .854 r
.57031 .5499 .57421 .55524 .58179 .56066 .57787 .55432 Metetra
.098 .352 .821 r
.57787 .55432 .58179 .56066 .58945 .56748 .58551 .55971 Metetra
.142 .329 .792 r
.58551 .55971 .58945 .56748 .59719 .57552 .59321 .56591 Metetra
.212 .325 .763 r
.59321 .56591 .59719 .57552 .60503 .58444 .60099 .57273 Metetra
.282 .332 .737 r
.60099 .57273 .60503 .58444 .61294 .59364 .60884 .57987 Metetra
.341 .343 .716 r
.60884 .57987 .61294 .59364 .62091 .60228 .61675 .58699 Metetra
.388 .359 .705 r
.61675 .58699 .62091 .60228 .6289 .60931 .62471 .59363 Metetra
.427 .381 .705 r
.62471 .59363 .6289 .60931 .63687 .61372 .6327 .59925 Metetra
.465 .417 .72 r
.6327 .59925 .63687 .61372 .64478 .61475 .64069 .60327 Metetra
.509 .48 .76 r
.64069 .60327 .64478 .61475 .65259 .61223 .64866 .6052 Metetra
.574 .61 .851 r
.64866 .6052 .65259 .61223 .6603 .60664 .65658 .60475 Metetra
.64 .886 .985 r
.65658 .60475 .6603 .60664 .66792 .59894 .66443 .60196 Metetra
.66443 .60196 .66792 .59894 .67551 .59027 .67221 .59709 Metetra
.055 0 0 r
.67221 .59709 .67551 .59027 .68308 .58157 .67993 .5905 Metetra
.1 0 .107 r
.67993 .5905 .68308 .58157 .69067 .57346 .68758 .58245 Metetra
.008 0 .073 r
.68758 .58245 .69067 .57346 .6983 .56609 .69515 .57292 Metetra
.69515 .57292 .6983 .56609 .70595 .55923 .70262 .5617 Metetra
.907 .961 .633 r
.70262 .5617 .70595 .55923 .7136 .55233 .70996 .54859 Metetra
.922 .803 .711 r
.70996 .54859 .7136 .55233 .7212 .5447 .71717 .53368 Metetra
.826 .655 .671 r
.71717 .53368 .7212 .5447 .72873 .53573 .72427 .51748 Metetra
.765 .578 .645 r
.72427 .51748 .72873 .53573 .73614 .52518 .7313 .50081 Metetra
.727 .534 .63 r
.7313 .50081 .73614 .52518 .74345 .51325 .7383 .48449 Metetra
.702 .508 .623 r
.7383 .48449 .74345 .51325 .75067 .50051 .74532 .46917 Metetra
.684 .491 .62 r
.74532 .46917 .75067 .50051 .75787 .48765 .75239 .45522 Metetra
.67 .48 .619 r
.75239 .45522 .75787 .48765 .76506 .47527 .75955 .44287 Metetra
.658 .471 .621 r
.75955 .44287 .76506 .47527 .7723 .4638 .76681 .43226 Metetra
.646 .465 .624 r
.76681 .43226 .7723 .4638 .77962 .45357 .7742 .42354 Metetra
.633 .459 .629 r
.7742 .42354 .77962 .45357 .78703 .44485 .78173 .4168 Metetra
.619 .453 .635 r
.78173 .4168 .78703 .44485 .79458 .43786 .78943 .41207 Metetra
.602 .447 .644 r
.78943 .41207 .79458 .43786 .8023 .43281 .79731 .40933 Metetra
.582 .441 .654 r
.79731 .40933 .8023 .43281 .81021 .42979 .80537 .40846 Metetra
.559 .434 .666 r
.80537 .40846 .81021 .42979 .81831 .42881 .81361 .40934 Metetra
.53 .424 .678 r
.81361 .40934 .81831 .42881 .82664 .42981 .82205 .41182 Metetra
.495 .41 .689 r
.82205 .41182 .82664 .42981 .83518 .43271 .83068 .41585 Metetra
.453 .39 .697 r
.83068 .41585 .83518 .43271 .84395 .43744 .83952 .42148 Metetra
.398 .362 .702 r
.83952 .42148 .84395 .43744 .85297 .44401 .8486 .42889 Metetra
.324 .322 .703 r
.8486 .42889 .85297 .44401 .86226 .45253 .85797 .43838 Metetra
.212 .259 .694 r
.85797 .43838 .86226 .45253 .87185 .46315 .86769 .45043 Metetra
.033 .155 .661 r
.86769 .45043 .87185 .46315 .88178 .47605 .87785 .46558 Metetra
0 0 .561 r
.87785 .46558 .88178 .47605 .89208 .49132 .8885 .4842 Metetra
0 0 .327 r
.8885 .4842 .89208 .49132 .90273 .50868 .89966 .50614 Metetra
.847 .409 0 r
.89966 .50614 .90273 .50868 .91363 .5271 .91119 .52989 Metetra
.866 .434 .178 r
.91119 .52989 .91363 .5271 .92453 .54434 .92264 .55159 Metetra
.767 .356 .272 r
.92264 .55159 .92453 .54434 .93499 .55683 .93325 .5651 Metetra
.473 .088 .228 r
.93325 .5651 .93499 .55683 .94445 .56048 .94225 .56458 Metetra
.623 .739 .93 r
.32469 .60235 .32897 .60617 .33573 .60467 .33146 .60085 Metetra
.53 .708 .953 r
.33146 .60085 .33573 .60467 .34245 .60432 .33819 .60049 Metetra
.393 .649 .96 r
.33819 .60049 .34245 .60432 .34913 .60517 .34487 .60133 Metetra
.193 .543 .928 r
.34487 .60133 .34913 .60517 .35578 .60733 .35152 .60349 Metetra
0 .369 .821 r
.35152 .60349 .35578 .60733 .36239 .61091 .35814 .60707 Metetra
0 .145 .629 r
.35814 .60707 .36239 .61091 .36897 .61608 .36472 .61224 Metetra
.588 .071 0 r
.36472 .61224 .36897 .61608 .37552 .62297 .37127 .61913 Metetra
.73 .23 0 r
.37127 .61913 .37552 .62297 .38205 .63166 .3778 .62782 Metetra
.807 .331 0 r
.3778 .62782 .38205 .63166 .38858 .64207 .38432 .63823 Metetra
.843 .384 0 r
.38432 .63823 .38858 .64207 .39512 .65379 .39086 .64996 Metetra
.85 .395 .013 r
.39086 .64996 .39512 .65379 .40173 .66593 .39746 .66212 Metetra
.818 .346 0 r
.39746 .66212 .40173 .66593 .40844 .67698 .40417 .67318 Metetra
.654 .14 0 r
.40417 .67318 .40844 .67698 .41533 .68494 .41105 .68113 Metetra
.078 .479 .893 r
.41105 .68113 .41533 .68494 .42242 .68782 .41815 .68401 Metetra
.712 .774 .901 r
.41815 .68401 .42242 .68782 .42973 .68451 .42547 .68069 Metetra
.849 .778 .782 r
.42547 .68069 .42973 .68451 .43719 .67527 .43296 .67143 Metetra
.885 .767 .726 r
.43296 .67143 .43719 .67527 .44475 .66166 .44054 .65779 Metetra
.897 .761 .704 r
.44054 .65779 .44475 .66166 .45232 .64572 .44814 .64183 Metetra
.899 .76 .699 r
.44814 .64183 .45232 .64572 .45987 .62933 .45572 .62541 Metetra
.896 .762 .705 r
.45572 .62541 .45987 .62933 .46736 .61376 .46324 .60981 Metetra
.889 .765 .719 r
.46324 .60981 .46736 .61376 .47479 .59969 .4707 .59572 Metetra
.878 .769 .738 r
.4707 .59572 .47479 .59969 .48217 .58738 .4781 .5834 Metetra
.864 .773 .76 r
.4781 .5834 .48217 .58738 .48951 .57686 .48546 .57286 Metetra
.845 .776 .785 r
.48546 .57286 .48951 .57686 .49681 .568 .49279 .564 Metetra
.823 .778 .811 r
.49279 .564 .49681 .568 .5041 .56068 .5001 .55668 Metetra
.795 .778 .838 r
.5001 .55668 .5041 .56068 .51138 .55475 .50739 .55075 Metetra
.76 .775 .866 r
.50739 .55075 .51138 .55475 .51866 .55011 .51469 .5461 Metetra
.718 .768 .892 r
.51469 .5461 .51866 .55011 .52595 .54666 .52199 .54262 Metetra
.666 .754 .915 r
.52199 .54262 .52595 .54666 .53326 .54437 .52931 .54023 Metetra
.606 .73 .933 r
.52931 .54023 .53326 .54437 .54059 .54321 .53665 .53888 Metetra
.54 .694 .939 r
.53665 .53888 .54059 .54321 .54795 .54318 .54402 .53848 Metetra
.479 .648 .933 r
.54402 .53848 .54795 .54318 .55535 .54429 .55143 .53896 Metetra
.434 .596 .912 r
.55143 .53896 .55535 .54429 .5628 .54653 .55887 .54024 Metetra
.415 .545 .879 r
.55887 .54024 .5628 .54653 .57031 .5499 .56636 .54222 Metetra
.416 .499 .837 r
.56636 .54222 .57031 .5499 .57787 .55432 .5739 .54481 Metetra
.428 .461 .792 r
.5739 .54481 .57787 .55432 .58551 .55971 .58149 .54798 Metetra
.439 .429 .751 r
.58149 .54798 .58551 .55971 .59321 .56591 .58914 .55173 Metetra
.445 .404 .719 r
.58914 .55173 .59321 .56591 .60099 .57273 .59684 .55617 Metetra
.444 .383 .695 r
.59684 .55617 .60099 .57273 .60884 .57987 .60462 .56144 Metetra
.434 .365 .68 r
.60462 .56144 .60884 .57987 .61675 .58699 .61248 .5677 Metetra
.416 .348 .673 r
.61248 .5677 .61675 .58699 .62471 .59363 .62043 .575 Metetra
.386 .332 .675 r
.62043 .575 .62471 .59363 .6327 .59925 .62847 .58316 Metetra
.337 .319 .691 r
.62847 .58316 .6327 .59925 .64069 .60327 .63659 .59166 Metetra
.243 .312 .735 r
.63659 .59166 .64069 .60327 .64866 .6052 .64476 .59956 Metetra
0 .304 .798 r
.64476 .59956 .64866 .6052 .65658 .60475 .65293 .60563 Metetra
.481 0 0 r
.65293 .60563 .65658 .60475 .66443 .60196 .66104 .60856 Metetra
.407 0 .145 r
.66104 .60856 .66443 .60196 .67221 .59709 .66902 .60725 Metetra
.261 0 .204 r
.66902 .60725 .67221 .59709 .67993 .5905 .67681 .60103 Metetra
0 0 .107 r
.67681 .60103 .67993 .5905 .68758 .58245 .68436 .58976 Metetra
.68436 .58976 .68758 .58245 .69515 .57292 .69167 .57388 Metetra
.988 .887 .627 r
.69167 .57388 .69515 .57292 .70262 .5617 .69875 .55445 Metetra
.901 .722 .651 r
.69875 .55445 .70262 .5617 .70996 .54859 .70567 .53303 Metetra
.817 .62 .636 r
.70567 .53303 .70996 .54859 .71717 .53368 .7125 .51127 Metetra
.765 .564 .626 r
.7125 .51127 .71717 .53368 .72427 .51748 .71931 .4905 Metetra
.732 .531 .621 r
.71931 .4905 .72427 .51748 .7313 .50081 .72617 .4715 Metetra
.71 .512 .62 r
.72617 .4715 .7313 .50081 .7383 .48449 .73311 .45463 Metetra
.694 .5 .621 r
.73311 .45463 .7383 .48449 .74532 .46917 .74014 .43991 Metetra
.681 .492 .624 r
.74014 .43991 .74532 .46917 .75239 .45522 .74727 .42732 Metetra
.67 .487 .629 r
.74727 .42732 .75239 .45522 .75955 .44287 .75453 .41682 Metetra
.658 .483 .637 r
.75453 .41682 .75955 .44287 .76681 .43226 .76192 .40839 Metetra
.645 .48 .646 r
.76192 .40839 .76681 .43226 .7742 .42354 .76945 .40202 Metetra
.629 .478 .658 r
.76945 .40202 .7742 .42354 .78173 .4168 .77715 .39762 Metetra
.61 .476 .673 r
.77715 .39762 .78173 .4168 .78943 .41207 .78501 .3951 Metetra
.586 .473 .691 r
.78501 .3951 .78943 .41207 .79731 .40933 .79303 .39428 Metetra
.556 .468 .71 r
.79303 .39428 .79731 .40933 .80537 .40846 .80122 .39498 Metetra
.518 .459 .73 r
.80122 .39498 .80537 .40846 .81361 .40934 .80956 .39707 Metetra
.471 .444 .747 r
.80956 .39707 .81361 .40934 .82205 .41182 .81807 .40048 Metetra
.411 .421 .759 r
.81807 .40048 .82205 .41182 .83068 .41585 .82676 .40523 Metetra
.332 .383 .765 r
.82676 .40523 .83068 .41585 .83952 .42148 .83566 .41149 Metetra
.22 .324 .758 r
.83566 .41149 .83952 .42148 .8486 .42889 .84481 .41962 Metetra
.051 .226 .724 r
.84481 .41962 .8486 .42889 .85797 .43838 .85427 .43011 Metetra
0 .069 .631 r
.85427 .43011 .85797 .43838 .86769 .45043 .86414 .44364 Metetra
0 0 .434 r
.86414 .44364 .86769 .45043 .87785 .46558 .87453 .46095 Metetra
.767 .34 0 r
.87453 .46095 .87785 .46558 .8885 .4842 .8855 .48254 Metetra
.875 .444 .045 r
.8855 .48254 .8885 .4842 .89966 .50614 .89706 .50794 Metetra
.892 .472 .176 r
.89706 .50794 .89966 .50614 .91119 .52989 .90893 .53456 Metetra
.858 .44 .234 r
.90893 .53456 .91119 .52989 .92264 .55159 .92045 .5567 Metetra
.735 .286 .186 r
.92045 .5567 .92264 .55159 .93325 .5651 .93068 .5667 Metetra
.545 .882 .627 r
.93068 .5667 .93325 .5651 .94225 .56458 .93892 .5597 Metetra
.623 .739 .93 r
.32039 .59852 .32469 .60235 .33146 .60085 .32717 .597 Metetra
.53 .708 .953 r
.32717 .597 .33146 .60085 .33819 .60049 .3339 .59664 Metetra
.393 .649 .96 r
.3339 .59664 .33819 .60049 .34487 .60133 .3406 .59748 Metetra
.193 .543 .928 r
.3406 .59748 .34487 .60133 .35152 .60349 .34725 .59963 Metetra
0 .369 .821 r
.34725 .59963 .35152 .60349 .35814 .60707 .35387 .60321 Metetra
0 .145 .629 r
.35387 .60321 .35814 .60707 .36472 .61224 .36045 .60837 Metetra
.588 .071 0 r
.36045 .60837 .36472 .61224 .37127 .61913 .367 .61527 Metetra
.73 .23 0 r
.367 .61527 .37127 .61913 .3778 .62782 .37353 .62396 Metetra
.807 .331 0 r
.37353 .62396 .3778 .62782 .38432 .63823 .38004 .63438 Metetra
.843 .384 0 r
.38004 .63438 .38432 .63823 .39086 .64996 .38657 .64612 Metetra
.85 .395 .013 r
.38657 .64612 .39086 .64996 .39746 .66212 .39317 .65828 Metetra
.818 .346 0 r
.39317 .65828 .39746 .66212 .40417 .67318 .39987 .66935 Metetra
.654 .14 0 r
.39987 .66935 .40417 .67318 .41105 .68113 .40676 .67731 Metetra
.078 .479 .893 r
.40676 .67731 .41105 .68113 .41815 .68401 .41386 .68019 Metetra
.712 .774 .901 r
.41386 .68019 .41815 .68401 .42547 .68069 .42119 .67685 Metetra
.849 .778 .782 r
.42119 .67685 .42547 .68069 .43296 .67143 .4287 .66758 Metetra
.885 .767 .726 r
.4287 .66758 .43296 .67143 .44054 .65779 .43631 .65391 Metetra
.897 .762 .704 r
.43631 .65391 .44054 .65779 .44814 .64183 .44394 .63793 Metetra
.899 .76 .699 r
.44394 .63793 .44814 .64183 .45572 .62541 .45155 .62148 Metetra
.896 .762 .705 r
.45155 .62148 .45572 .62541 .46324 .60981 .4591 .60586 Metetra
.889 .766 .719 r
.4591 .60586 .46324 .60981 .4707 .59572 .46659 .59175 Metetra
.879 .77 .738 r
.46659 .59175 .4707 .59572 .4781 .5834 .47401 .57942 Metetra
.864 .774 .76 r
.47401 .57942 .4781 .5834 .48546 .57286 .4814 .56888 Metetra
.846 .778 .785 r
.4814 .56888 .48546 .57286 .49279 .564 .48874 .56001 Metetra
.823 .78 .812 r
.48874 .56001 .49279 .564 .5001 .55668 .49607 .55267 Metetra
.795 .779 .838 r
.49607 .55267 .5001 .55668 .50739 .55075 .50338 .54671 Metetra
.762 .775 .863 r
.50338 .54671 .50739 .55075 .51469 .5461 .5107 .54195 Metetra
.724 .764 .884 r
.5107 .54195 .51469 .5461 .52199 .54262 .51801 .53828 Metetra
.683 .745 .898 r
.51801 .53828 .52199 .54262 .52931 .54023 .52535 .53553 Metetra
.644 .717 .901 r
.52535 .53553 .52931 .54023 .53665 .53888 .5327 .53358 Metetra
.612 .679 .89 r
.5327 .53358 .53665 .53888 .54402 .53848 .54007 .53226 Metetra
.59 .635 .864 r
.54007 .53226 .54402 .53848 .55143 .53896 .54747 .53144 Metetra
.578 .59 .829 r
.54747 .53144 .55143 .53896 .55887 .54024 .55491 .53099 Metetra
.57 .546 .789 r
.55491 .53099 .55887 .54024 .56636 .54222 .56237 .53086 Metetra
.562 .508 .752 r
.56237 .53086 .56636 .54222 .5739 .54481 .56987 .53107 Metetra
.552 .475 .722 r
.56987 .53107 .5739 .54481 .58149 .54798 .5774 .53179 Metetra
.537 .445 .698 r
.5774 .53179 .58149 .54798 .58914 .55173 .58499 .5333 Metetra
.517 .418 .682 r
.58499 .5333 .58914 .55173 .59684 .55617 .59264 .53602 Metetra
.487 .39 .67 r
.59264 .53602 .59684 .55617 .60462 .56144 .60036 .54044 Metetra
.445 .357 .663 r
.60036 .54044 .60462 .56144 .61248 .5677 .6082 .54703 Metetra
.382 .317 .659 r
.6082 .54703 .61248 .5677 .62043 .575 .61616 .55615 Metetra
.277 .257 .656 r
.61616 .55615 .62043 .575 .62847 .58316 .62428 .56788 Metetra
.082 .155 .641 r
.62428 .56788 .62847 .58316 .63659 .59166 .63254 .58175 Metetra
0 0 .53 r
.63254 .58175 .63659 .59166 .64476 .59956 .64094 .59647 Metetra
.796 .318 0 r
.64094 .59647 .64476 .59956 .65293 .60563 .64938 .60972 Metetra
.736 .301 .218 r
.64938 .60972 .65293 .60563 .66104 .60856 .65773 .61819 Metetra
.514 .149 .285 r
.65773 .61819 .66104 .60856 .66902 .60725 .66582 .6185 Metetra
.113 0 .168 r
.66582 .6185 .66902 .60725 .67681 .60103 .67351 .60869 Metetra
.744 .802 .322 r
.67351 .60869 .67681 .60103 .68436 .58976 .68075 .58949 Metetra
.987 .828 .6 r
.68075 .58949 .68436 .58976 .69167 .57388 .68764 .56406 Metetra
.894 .692 .621 r
.68764 .56406 .69167 .57388 .69875 .55445 .69433 .53638 Metetra
.823 .613 .619 r
.69433 .53638 .69875 .55445 .70567 .53303 .70097 .50962 Metetra
.778 .57 .618 r
.70097 .50962 .70567 .53303 .7125 .51127 .70766 .48547 Metetra
.749 .545 .619 r
.70766 .48547 .7125 .51127 .71931 .4905 .71444 .46448 Metetra
.73 .532 .624 r
.71444 .46448 .71931 .4905 .72617 .4715 .72134 .44654 Metetra
.716 .525 .63 r
.72134 .44654 .72617 .4715 .73311 .45463 .72836 .43136 Metetra
.706 .522 .638 r
.72836 .43136 .73311 .45463 .74014 .43991 .7355 .41863 Metetra
.695 .521 .648 r
.7355 .41863 .74014 .43991 .74727 .42732 .74277 .40817 Metetra
.684 .522 .661 r
.74277 .40817 .74727 .42732 .75453 .41682 .75016 .39984 Metetra
.671 .525 .677 r
.75016 .39984 .75453 .41682 .76192 .40839 .7577 .39354 Metetra
.653 .528 .698 r
.7577 .39354 .76192 .40839 .76945 .40202 .76538 .38917 Metetra
.629 .531 .725 r
.76538 .38917 .76945 .40202 .77715 .39762 .77321 .38659 Metetra
.595 .534 .756 r
.77321 .38659 .77715 .39762 .78501 .3951 .7812 .38563 Metetra
.547 .533 .791 r
.7812 .38563 .78501 .3951 .79303 .39428 .78933 .38613 Metetra
.479 .524 .826 r
.78933 .38613 .79303 .39428 .80122 .39498 .79761 .38796 Metetra
.383 .502 .855 r
.79761 .38796 .80122 .39498 .80956 .39707 .80605 .39102 Metetra
.245 .454 .865 r
.80605 .39102 .80956 .39707 .81807 .40048 .81465 .39532 Metetra
.045 .361 .833 r
.81465 .39532 .81807 .40048 .82676 .40523 .82344 .40101 Metetra
0 .2 .713 r
.82344 .40101 .82676 .40523 .83566 .41149 .83245 .40836 Metetra
.521 .018 0 r
.83245 .40836 .83566 .41149 .84481 .41962 .84174 .41782 Metetra
.727 .218 0 r
.84174 .41782 .84481 .41962 .85427 .43011 .85138 .42996 Metetra
.826 .349 .012 r
.85138 .42996 .85427 .43011 .86414 .44364 .86147 .44548 Metetra
.862 .421 .152 r
.86147 .44548 .86414 .44364 .87453 .46095 .8721 .46489 Metetra
.871 .457 .234 r
.8721 .46489 .87453 .46095 .8855 .48254 .88328 .48814 Metetra
.87 .47 .273 r
.88328 .48814 .8855 .48254 .89706 .50794 .89488 .51379 Metetra
.861 .457 .27 r
.89488 .51379 .89706 .50794 .90893 .53456 .9065 .53799 Metetra
.828 .381 .169 r
.9065 .53799 .90893 .53456 .92045 .5567 .91741 .55471 Metetra
0 .424 .794 r
.91741 .55471 .92045 .5567 .93068 .5667 .92689 .55822 Metetra
.823 .703 .732 r
.92689 .55822 .93068 .5667 .93892 .5597 .93462 .54693 Metetra
.623 .739 .93 r
.31606 .59467 .32039 .59852 .32717 .597 .32285 .59314 Metetra
.53 .708 .953 r
.32285 .59314 .32717 .597 .3339 .59664 .3296 .59277 Metetra
.393 .649 .96 r
.3296 .59277 .3339 .59664 .3406 .59748 .3363 .59361 Metetra
.193 .543 .928 r
.3363 .59361 .3406 .59748 .34725 .59963 .34296 .59575 Metetra
0 .369 .821 r
.34296 .59575 .34725 .59963 .35387 .60321 .34958 .59933 Metetra
0 .145 .629 r
.34958 .59933 .35387 .60321 .36045 .60837 .35616 .60449 Metetra
.588 .071 0 r
.35616 .60449 .36045 .60837 .367 .61527 .36271 .61139 Metetra
.73 .23 0 r
.36271 .61139 .367 .61527 .37353 .62396 .36924 .62009 Metetra
.807 .331 0 r
.36924 .62009 .37353 .62396 .38004 .63438 .37574 .63051 Metetra
.843 .384 0 r
.37574 .63051 .38004 .63438 .38657 .64612 .38227 .64226 Metetra
.85 .395 .013 r
.38227 .64226 .38657 .64612 .39317 .65828 .38885 .65443 Metetra
.818 .346 0 r
.38885 .65443 .39317 .65828 .39987 .66935 .39555 .66551 Metetra
.654 .14 0 r
.39555 .66551 .39987 .66935 .40676 .67731 .40244 .67347 Metetra
.077 .479 .893 r
.40244 .67347 .40676 .67731 .41386 .68019 .40955 .67635 Metetra
.712 .774 .901 r
.40955 .67635 .41386 .68019 .42119 .67685 .41689 .673 Metetra
.849 .778 .782 r
.41689 .673 .42119 .67685 .4287 .66758 .42442 .66371 Metetra
.885 .767 .726 r
.42442 .66371 .4287 .66758 .43631 .65391 .43206 .65002 Metetra
.897 .762 .704 r
.43206 .65002 .43631 .65391 .44394 .63793 .43972 .63402 Metetra
.9 .761 .699 r
.43972 .63402 .44394 .63793 .45155 .62148 .44736 .61755 Metetra
.897 .763 .706 r
.44736 .61755 .45155 .62148 .4591 .60586 .45494 .60192 Metetra
.89 .766 .719 r
.45494 .60192 .4591 .60586 .46659 .59175 .46245 .5878 Metetra
.879 .771 .738 r
.46245 .5878 .46659 .59175 .47401 .57942 .46991 .57545 Metetra
.865 .775 .761 r
.46991 .57545 .47401 .57942 .4814 .56888 .47731 .56488 Metetra
.846 .778 .785 r
.47731 .56488 .4814 .56888 .48874 .56001 .48468 .55597 Metetra
.824 .778 .809 r
.48468 .55597 .48874 .56001 .49607 .55267 .49202 .54853 Metetra
.798 .774 .832 r
.49202 .54853 .49607 .55267 .50338 .54671 .49936 .54236 Metetra
.768 .764 .849 r
.49936 .54236 .50338 .54671 .5107 .54195 .50669 .53726 Metetra
.738 .744 .857 r
.50669 .53726 .5107 .54195 .51801 .53828 .51402 .53301 Metetra
.711 .715 .852 r
.51402 .53301 .51801 .53828 .52535 .53553 .52136 .5294 Metetra
.688 .678 .835 r
.52136 .5294 .52535 .53553 .5327 .53358 .52872 .52622 Metetra
.67 .637 .808 r
.52872 .52622 .5327 .53358 .54007 .53226 .5361 .52332 Metetra
.654 .596 .777 r
.5361 .52332 .54007 .53226 .54747 .53144 .54349 .52057 Metetra
.64 .558 .747 r
.54349 .52057 .54747 .53144 .55491 .53099 .5509 .51798 Metetra
.625 .525 .721 r
.5509 .51798 .55491 .53099 .56237 .53086 .55833 .51565 Metetra
.608 .496 .701 r
.55833 .51565 .56237 .53086 .56987 .53107 .56579 .51386 Metetra
.587 .47 .687 r
.56579 .51386 .56987 .53107 .5774 .53179 .57328 .51298 Metetra
.56 .444 .677 r
.57328 .51298 .5774 .53179 .58499 .5333 .58083 .5135 Metetra
.524 .415 .672 r
.58083 .5135 .58499 .5333 .59264 .53602 .58845 .516 Metetra
.471 .379 .67 r
.58845 .516 .59264 .53602 .60036 .54044 .59616 .52106 Metetra
.388 .327 .667 r
.59616 .52106 .60036 .54044 .6082 .54703 .604 .52928 Metetra
.242 .24 .656 r
.604 .52928 .6082 .54703 .61616 .55615 .61201 .54116 Metetra
0 .071 .599 r
.61201 .54116 .61616 .55615 .62428 .56788 .62021 .557 Metetra
0 0 .371 r
.62021 .557 .62428 .56788 .63254 .58175 .62863 .57646 Metetra
.873 .461 .018 r
.62863 .57646 .63254 .58175 .64094 .59647 .63724 .5978 Metetra
.877 .471 .25 r
.63724 .5978 .64094 .59647 .64938 .60972 .6459 .61702 Metetra
.745 .361 .326 r
.6459 .61702 .64938 .60972 .65773 .61819 .65437 .62795 Metetra
.388 .033 .237 r
.65437 .62795 .65773 .61819 .66582 .6185 .66237 .62484 Metetra
.818 .862 .414 r
.66237 .62484 .66582 .6185 .67351 .60869 .66975 .60663 Metetra
.972 .79 .599 r
.66975 .60663 .67351 .60869 .68075 .58949 .67662 .57805 Metetra
.892 .679 .607 r
.67662 .57805 .68075 .58949 .68764 .56406 .68322 .54595 Metetra
.838 .622 .61 r
.68322 .54595 .68764 .56406 .69433 .53638 .68977 .51537 Metetra
.804 .593 .615 r
.68977 .51537 .69433 .53638 .70097 .50962 .69641 .48855 Metetra
.784 .579 .624 r
.69641 .48855 .70097 .50962 .70766 .48547 .70318 .46588 Metetra
.772 .576 .634 r
.70318 .46588 .70766 .48547 .71444 .46448 .71008 .44692 Metetra
.764 .579 .647 r
.71008 .44692 .71444 .46448 .72134 .44654 .7171 .4311 Metetra
.758 .586 .663 r
.7171 .4311 .72134 .44654 .72836 .43136 .72425 .41793 Metetra
.752 .596 .683 r
.72425 .41793 .72836 .43136 .7355 .41863 .73151 .40707 Metetra
.745 .609 .707 r
.73151 .40707 .7355 .41863 .74277 .40817 .7389 .39833 Metetra
.732 .624 .738 r
.7389 .39833 .74277 .40817 .75016 .39984 .74641 .39157 Metetra
.712 .642 .778 r
.74641 .39157 .75016 .39984 .7577 .39354 .75405 .3867 Metetra
.676 .662 .828 r
.75405 .3867 .7577 .39354 .76538 .38917 .76184 .38361 Metetra
.612 .678 .888 r
.76184 .38361 .76538 .38917 .77321 .38659 .76978 .38218 Metetra
.495 .677 .946 r
.76978 .38218 .77321 .38659 .7812 .38563 .77786 .3823 Metetra
.288 .627 .962 r
.77786 .3823 .7812 .38563 .78933 .38613 .7861 .38382 Metetra
0 .477 .852 r
.7861 .38382 .78933 .38613 .79761 .38796 .79449 .38667 Metetra
.347 0 0 r
.79449 .38667 .79761 .38796 .80605 .39102 .80304 .39086 Metetra
.57 0 0 r
.80304 .39086 .80605 .39102 .81465 .39532 .81178 .39646 Metetra
.687 .155 0 r
.81178 .39646 .81465 .39532 .82344 .40101 .82073 .40367 Metetra
.744 .262 .097 r
.82073 .40367 .82344 .40101 .83245 .40836 .82993 .4128 Metetra
.772 .332 .205 r
.82993 .4128 .83245 .40836 .84174 .41782 .83944 .42425 Metetra
.786 .377 .276 r
.83944 .42425 .84174 .41782 .85138 .42996 .84932 .4384 Metetra
.795 .408 .321 r
.84932 .4384 .85138 .42996 .86147 .44548 .85962 .45553 Metetra
.802 .427 .345 r
.85962 .45553 .86147 .44548 .8721 .46489 .87033 .47548 Metetra
.809 .437 .35 r
.87033 .47548 .8721 .46489 .88328 .48814 .88139 .49721 Metetra
.818 .434 .326 r
.88139 .49721 .88328 .48814 .89488 .51379 .89254 .51844 Metetra
.824 .394 .217 r
.89254 .51844 .89488 .51379 .9065 .53799 .90338 .53557 Metetra
.518 0 0 r
.90338 .53557 .9065 .53799 .91741 .55471 .91342 .54461 Metetra
.609 .571 .786 r
.91342 .54461 .91741 .55471 .92689 .55822 .9223 .54311 Metetra
.749 .59 .679 r
.9223 .54311 .92689 .55822 .93462 .54693 .93 .53151 Metetra
.623 .739 .93 r
.31172 .5908 .31606 .59467 .32285 .59314 .31852 .58927 Metetra
.53 .708 .953 r
.31852 .58927 .32285 .59314 .3296 .59277 .32527 .58888 Metetra
.393 .649 .96 r
.32527 .58888 .3296 .59277 .3363 .59361 .33198 .58971 Metetra
.193 .543 .928 r
.33198 .58971 .3363 .59361 .34296 .59575 .33864 .59185 Metetra
0 .369 .821 r
.33864 .59185 .34296 .59575 .34958 .59933 .34527 .59543 Metetra
0 .145 .629 r
.34527 .59543 .34958 .59933 .35616 .60449 .35185 .60059 Metetra
.588 .071 0 r
.35185 .60059 .35616 .60449 .36271 .61139 .3584 .60749 Metetra
.73 .23 0 r
.3584 .60749 .36271 .61139 .36924 .62009 .36492 .61619 Metetra
.807 .331 0 r
.36492 .61619 .36924 .62009 .37574 .63051 .37142 .62662 Metetra
.843 .384 0 r
.37142 .62662 .37574 .63051 .38227 .64226 .37794 .63838 Metetra
.85 .395 .013 r
.37794 .63838 .38227 .64226 .38885 .65443 .38452 .65056 Metetra
.818 .346 0 r
.38452 .65056 .38885 .65443 .39555 .66551 .39121 .66165 Metetra
.655 .141 0 r
.39121 .66165 .39555 .66551 .40244 .67347 .39809 .66962 Metetra
.075 .478 .892 r
.39809 .66962 .40244 .67347 .40955 .67635 .40521 .6725 Metetra
.712 .775 .902 r
.40521 .6725 .40955 .67635 .41689 .673 .41257 .66915 Metetra
.849 .779 .783 r
.41257 .66915 .41689 .673 .42442 .66371 .42012 .65985 Metetra
.886 .768 .727 r
.42012 .65985 .42442 .66371 .43206 .65002 .42778 .64615 Metetra
.898 .763 .704 r
.42778 .64615 .43206 .65002 .43972 .63402 .43548 .63013 Metetra
.9 .762 .699 r
.43548 .63013 .43972 .63402 .44736 .61755 .44315 .61365 Metetra
.897 .764 .706 r
.44315 .61365 .44736 .61755 .45494 .60192 .45076 .59799 Metetra
.89 .767 .719 r
.45076 .59799 .45494 .60192 .46245 .5878 .4583 .58384 Metetra
.88 .771 .738 r
.4583 .58384 .46245 .5878 .46991 .57545 .46578 .57143 Metetra
.865 .774 .759 r
.46578 .57143 .46991 .57545 .47731 .56488 .47321 .56076 Metetra
.847 .774 .781 r
.47321 .56076 .47731 .56488 .48468 .55597 .4806 .55164 Metetra
.825 .768 .799 r
.4806 .55164 .48468 .55597 .49202 .54853 .48797 .54386 Metetra
.8 .755 .811 r
.48797 .54386 .49202 .54853 .49936 .54236 .49532 .53714 Metetra
.775 .733 .814 r
.49532 .53714 .49936 .54236 .50669 .53726 .50267 .53121 Metetra
.751 .702 .805 r
.50267 .53121 .50669 .53726 .51402 .53301 .51002 .52582 Metetra
.729 .665 .787 r
.51002 .52582 .51402 .53301 .52136 .5294 .51737 .52075 Metetra
.709 .627 .764 r
.51737 .52075 .52136 .5294 .52872 .52622 .52473 .51584 Metetra
.691 .592 .74 r
.52473 .51584 .52872 .52622 .5361 .52332 .5321 .51106 Metetra
.673 .56 .719 r
.5321 .51106 .5361 .52332 .54349 .52057 .53948 .50646 Metetra
.656 .534 .703 r
.53948 .50646 .54349 .52057 .5509 .51798 .54688 .50225 Metetra
.636 .51 .692 r
.54688 .50225 .5509 .51798 .55833 .51565 .55429 .49875 Metetra
.613 .488 .686 r
.55429 .49875 .55833 .51565 .56579 .51386 .56172 .49638 Metetra
.584 .466 .685 r
.56172 .49638 .56579 .51386 .57328 .51298 .5692 .4956 Metetra
.542 .44 .688 r
.5692 .4956 .57328 .51298 .58083 .5135 .57674 .49692 Metetra
.477 .403 .694 r
.57674 .49692 .58083 .5135 .58845 .516 .58436 .50084 Metetra
.359 .338 .7 r
.58436 .50084 .58845 .516 .59616 .52106 .59209 .50795 Metetra
.118 .202 .676 r
.59209 .50795 .59616 .52106 .604 .52928 .59998 .51889 Metetra
0 0 .497 r
.59998 .51889 .604 .52928 .61201 .54116 .60806 .53429 Metetra
.818 .418 0 r
.60806 .53429 .61201 .54116 .62021 .557 .61637 .55452 Metetra
.918 .521 .196 r
.61637 .55452 .62021 .557 .62863 .57646 .62493 .57889 Metetra
.894 .518 .317 r
.62493 .57889 .62863 .57646 .63724 .5978 .63367 .60433 Metetra
.833 .464 .356 r
.63367 .60433 .63724 .5978 .6459 .61702 .64237 .62433 Metetra
.669 .274 .288 r
.64237 .62433 .6459 .61702 .65437 .62795 .65071 .63068 Metetra
.857 .97 .653 r
.65071 .63068 .65437 .62795 .66237 .62484 .65841 .61909 Metetra
.93 .743 .629 r
.65841 .61909 .66237 .62484 .66975 .60663 .66551 .59313 Metetra
.876 .661 .608 r
.66551 .59313 .66975 .60663 .67662 .57805 .67223 .56085 Metetra
.849 .631 .608 r
.67223 .56085 .67662 .57805 .68322 .54595 .67886 .52896 Metetra
.837 .625 .616 r
.67886 .52896 .68322 .54595 .68977 .51537 .68554 .50068 Metetra
.836 .635 .63 r
.68554 .50068 .68977 .51537 .69641 .48855 .69234 .47673 Metetra
.843 .655 .649 r
.69234 .47673 .69641 .48855 .70318 .46588 .69927 .45675 Metetra
.853 .686 .674 r
.69927 .45675 .70318 .46588 .71008 .44692 .70631 .44006 Metetra
.866 .725 .705 r
.70631 .44006 .71008 .44692 .7171 .4311 .71347 .42609 Metetra
.877 .773 .743 r
.71347 .42609 .7171 .4311 .72425 .41793 .72073 .41442 Metetra
.882 .83 .791 r
.72073 .41442 .72425 .41793 .73151 .40707 .7281 .4048 Metetra
.87 .895 .849 r
.7281 .4048 .73151 .40707 .7389 .39833 .73558 .39708 Metetra
.812 .957 .909 r
.73558 .39708 .7389 .39833 .74641 .39157 .74318 .39119 Metetra
.644 .96 .924 r
.74318 .39119 .74641 .39157 .75405 .3867 .75091 .38709 Metetra
.303 .796 .789 r
.75091 .38709 .75405 .3867 .76184 .38361 .75878 .38475 Metetra
.089 0 0 r
.75878 .38475 .76184 .38361 .76978 .38218 .7668 .38408 Metetra
.361 0 0 r
.7668 .38408 .76978 .38218 .77786 .3823 .77498 .38502 Metetra
.516 0 0 r
.77498 .38502 .77786 .3823 .7861 .38382 .78333 .38754 Metetra
.605 .121 .08 r
.78333 .38754 .7861 .38382 .79449 .38667 .79185 .39158 Metetra
.656 .208 .175 r
.79185 .39158 .79449 .38667 .80304 .39086 .80056 .39718 Metetra
.688 .269 .245 r
.80056 .39718 .80304 .39086 .81178 .39646 .80948 .40443 Metetra
.708 .313 .297 r
.80948 .40443 .81178 .39646 .82073 .40367 .81863 .41345 Metetra
.721 .344 .336 r
.81863 .41345 .82073 .40367 .82993 .4128 .82805 .42438 Metetra
.73 .367 .363 r
.82805 .42438 .82993 .4128 .83944 .42425 .83776 .43733 Metetra
.739 .384 .38 r
.83776 .43733 .83944 .42425 .84932 .4384 .84776 .45222 Metetra
.747 .395 .386 r
.84776 .45222 .84932 .4384 .85962 .45553 .85804 .46871 Metetra
.758 .401 .378 r
.85804 .46871 .85962 .45553 .87033 .47548 .86853 .48603 Metetra
.773 .397 .344 r
.86853 .48603 .87033 .47548 .88139 .49721 .87909 .50285 Metetra
.791 .365 .236 r
.87909 .50285 .88139 .49721 .89254 .51844 .88953 .51726 Metetra
.657 .114 0 r
.88953 .51726 .89254 .51844 .90338 .53557 .89957 .52712 Metetra
.4 .486 .832 r
.89957 .52712 .90338 .53557 .91342 .54461 .90898 .53068 Metetra
.64 .538 .723 r
.90898 .53068 .91342 .54461 .9223 .54311 .91762 .52718 Metetra
.722 .569 .682 r
.91762 .52718 .9223 .54311 .93 .53151 .92553 .51733 Metetra
.623 .739 .93 r
.30735 .58691 .31172 .5908 .31852 .58927 .31416 .58537 Metetra
.53 .708 .953 r
.31416 .58537 .31852 .58927 .32527 .58888 .32092 .58498 Metetra
.393 .649 .96 r
.32092 .58498 .32527 .58888 .33198 .58971 .32764 .5858 Metetra
.193 .543 .928 r
.32764 .5858 .33198 .58971 .33864 .59185 .33431 .58793 Metetra
0 .369 .821 r
.33431 .58793 .33864 .59185 .34527 .59543 .34094 .59151 Metetra
0 .144 .629 r
.34094 .59151 .34527 .59543 .35185 .60059 .34752 .59667 Metetra
.588 .071 0 r
.34752 .59667 .35185 .60059 .3584 .60749 .35407 .60357 Metetra
.73 .23 0 r
.35407 .60357 .3584 .60749 .36492 .61619 .36059 .61228 Metetra
.807 .331 0 r
.36059 .61228 .36492 .61619 .37142 .62662 .36708 .62272 Metetra
.843 .384 0 r
.36708 .62272 .37142 .62662 .37794 .63838 .37359 .63448 Metetra
.85 .395 .014 r
.37359 .63448 .37794 .63838 .38452 .65056 .38016 .64668 Metetra
.819 .347 0 r
.38016 .64668 .38452 .65056 .39121 .66165 .38685 .65778 Metetra
.657 .144 0 r
.38685 .65778 .39121 .66165 .39809 .66962 .39373 .66578 Metetra
.067 .475 .889 r
.39373 .66578 .39809 .66962 .40521 .6725 .40085 .66867 Metetra
.711 .777 .904 r
.40085 .66867 .40521 .6725 .41257 .66915 .40822 .66533 Metetra
.85 .781 .784 r
.40822 .66533 .41257 .66915 .42012 .65985 .4158 .65604 Metetra
.887 .77 .727 r
.4158 .65604 .42012 .65985 .42778 .64615 .42349 .64232 Metetra
.899 .764 .704 r
.42349 .64232 .42778 .64615 .43548 .63013 .43121 .62628 Metetra
.901 .763 .7 r
.43121 .62628 .43548 .63013 .44315 .61365 .43891 .60976 Metetra
.898 .764 .706 r
.43891 .60976 .44315 .61365 .45076 .59799 .44655 .59403 Metetra
.891 .767 .718 r
.44655 .59403 .45076 .59799 .4583 .58384 .45412 .57975 Metetra
.879 .768 .735 r
.45412 .57975 .4583 .58384 .46578 .57143 .46163 .56714 Metetra
.864 .766 .752 r
.46163 .56714 .46578 .57143 .47321 .56076 .46909 .55611 Metetra
.844 .757 .767 r
.46909 .55611 .47321 .56076 .4806 .55164 .47651 .54646 Metetra
.822 .741 .775 r
.47651 .54646 .4806 .55164 .48797 .54386 .4839 .53789 Metetra
.798 .716 .774 r
.4839 .53789 .48797 .54386 .49532 .53714 .49128 .53011 Metetra
.773 .684 .765 r
.49128 .53011 .49532 .53714 .50267 .53121 .49865 .52284 Metetra
.751 .65 .75 r
.49865 .52284 .50267 .53121 .51002 .52582 .50602 .51591 Metetra
.729 .617 .733 r
.50602 .51591 .51002 .52582 .51737 .52075 .51338 .5092 Metetra
.71 .588 .717 r
.51338 .5092 .51737 .52075 .52473 .51584 .52074 .50276 Metetra
.691 .563 .705 r
.52074 .50276 .52473 .51584 .5321 .51106 .52811 .49674 Metetra
.673 .542 .697 r
.52811 .49674 .5321 .51106 .53948 .50646 .53548 .4914 Metetra
.653 .525 .695 r
.53548 .4914 .53948 .50646 .54688 .50225 .54286 .48707 Metetra
.628 .509 .698 r
.54286 .48707 .54688 .50225 .55429 .49875 .55027 .48414 Metetra
.594 .492 .708 r
.55027 .48414 .55429 .49875 .56172 .49638 .55771 .48299 Metetra
.541 .471 .726 r
.55771 .48299 .56172 .49638 .5692 .4956 .5652 .48401 Metetra
.438 .43 .753 r
.5652 .48401 .5692 .4956 .57674 .49692 .57276 .48761 Metetra
.191 .319 .765 r
.57276 .48761 .57674 .49692 .58436 .50084 .58042 .49425 Metetra
0 0 .551 r
.58042 .49425 .58436 .50084 .59209 .50795 .58822 .50454 Metetra
.837 .379 0 r
.58822 .50454 .59209 .50795 .59998 .51889 .59618 .51912 Metetra
.889 .483 .238 r
.59618 .51912 .59998 .51889 .60806 .53429 .60436 .53847 Metetra
.874 .505 .346 r
.60436 .53847 .60806 .53429 .61637 .55452 .61277 .5623 Metetra
.851 .502 .39 r
.61277 .5623 .61637 .55452 .62493 .57889 .62139 .58837 Metetra
.824 .476 .398 r
.62139 .58837 .62493 .57889 .63367 .60433 .63007 .61142 Metetra
.766 .383 .33 r
.63007 .61142 .63367 .60433 .64237 .62433 .63855 .62394 Metetra
.581 .933 .94 r
.63855 .62394 .64237 .62433 .65071 .63068 .64656 .62052 Metetra
.848 .675 .667 r
.64656 .62052 .65071 .63068 .65841 .61909 .65402 .60217 Metetra
.832 .624 .622 r
.65402 .60217 .65841 .61909 .66551 .59313 .66108 .57516 Metetra
.833 .621 .615 r
.66108 .57516 .66551 .59313 .67223 .56085 .66796 .54605 Metetra
.849 .642 .621 r
.66796 .54605 .67223 .56085 .67886 .52896 .67481 .51881 Metetra
.878 .684 .636 r
.67481 .51881 .67886 .52896 .68554 .50068 .68173 .49496 Metetra
.917 .749 .658 r
.68173 .49496 .68554 .50068 .69234 .47673 .68875 .47462 Metetra
.958 .837 .68 r
.68875 .47462 .69234 .47673 .69927 .45675 .69586 .45738 Metetra
.97 .929 .682 r
.69586 .45738 .69927 .45675 .70631 .44006 .70306 .44276 Metetra
.871 .956 .612 r
.70306 .44276 .70631 .44006 .71347 .42609 .71035 .43033 Metetra
.604 .823 .429 r
.71035 .43033 .71347 .42609 .72073 .41442 .71773 .41983 Metetra
.71773 .41983 .72073 .41442 .7281 .4048 .7252 .41108 Metetra
.7252 .41108 .7281 .4048 .73558 .39708 .73277 .40404 Metetra
.175 0 .07 r
.73277 .40404 .73558 .39708 .74318 .39119 .74045 .3987 Metetra
.311 0 .149 r
.74045 .3987 .74318 .39119 .75091 .38709 .74827 .39509 Metetra
.413 .033 .205 r
.74827 .39509 .75091 .38709 .75878 .38475 .75622 .39324 Metetra
.49 .111 .248 r
.75622 .39324 .75878 .38475 .7668 .38408 .76434 .39317 Metetra
.549 .174 .283 r
.76434 .39317 .7668 .38408 .77498 .38502 .77262 .39487 Metetra
.593 .225 .312 r
.77262 .39487 .77498 .38502 .78333 .38754 .78109 .3983 Metetra
.627 .265 .337 r
.78109 .3983 .78333 .38754 .79185 .39158 .78975 .40345 Metetra
.65 .296 .358 r
.78975 .40345 .79185 .39158 .80056 .39718 .79861 .41026 Metetra
.667 .32 .375 r
.79861 .41026 .80056 .39718 .80948 .40443 .80769 .41865 Metetra
.68 .337 .388 r
.80769 .41865 .80948 .40443 .81863 .41345 .81698 .42853 Metetra
.69 .35 .396 r
.81698 .42853 .81863 .41345 .82805 .42438 .82647 .43973 Metetra
.699 .359 .397 r
.82647 .43973 .82805 .42438 .83776 .43733 .83617 .45197 Metetra
.709 .364 .39 r
.83617 .45197 .83776 .43733 .84776 .45222 .84603 .46492 Metetra
.723 .364 .369 r
.84603 .46492 .84776 .45222 .85804 .46871 .85602 .47807 Metetra
.742 .355 .319 r
.85602 .47807 .85804 .46871 .86853 .48603 .86607 .49071 Metetra
.761 .313 .188 r
.86607 .49071 .86853 .48603 .87909 .50285 .87608 .50201 Metetra
.644 .091 0 r
.87608 .50201 .87909 .50285 .88953 .51726 .88593 .51088 Metetra
.192 .421 .854 r
.88593 .51088 .88953 .51726 .89957 .52712 .89548 .51624 Metetra
.533 .514 .781 r
.89548 .51624 .89957 .52712 .90898 .53068 .9046 .51727 Metetra
.644 .546 .729 r
.9046 .51727 .90898 .53068 .91762 .52718 .91323 .51369 Metetra
.715 .585 .709 r
.91323 .51369 .91762 .52718 .92553 .51733 .92138 .50584 Metetra
.623 .739 .93 r
.30297 .58301 .30735 .58691 .31416 .58537 .30979 .58146 Metetra
.53 .708 .953 r
.30979 .58146 .31416 .58537 .32092 .58498 .31656 .58106 Metetra
.393 .649 .96 r
.31656 .58106 .32092 .58498 .32764 .5858 .32328 .58187 Metetra
.193 .543 .928 r
.32328 .58187 .32764 .5858 .33431 .58793 .32995 .584 Metetra
0 .369 .821 r
.32995 .584 .33431 .58793 .34094 .59151 .33658 .58757 Metetra
0 .144 .628 r
.33658 .58757 .34094 .59151 .34752 .59667 .34317 .59273 Metetra
.588 .071 0 r
.34317 .59273 .34752 .59667 .35407 .60357 .34972 .59964 Metetra
.731 .231 0 r
.34972 .59964 .35407 .60357 .36059 .61228 .35623 .60835 Metetra
.808 .332 0 r
.35623 .60835 .36059 .61228 .36708 .62272 .36272 .6188 Metetra
.844 .385 0 r
.36272 .6188 .36708 .62272 .37359 .63448 .36922 .63059 Metetra
.851 .396 .016 r
.36922 .63059 .37359 .63448 .38016 .64668 .37578 .64282 Metetra
.821 .35 0 r
.37578 .64282 .38016 .64668 .38685 .65778 .38246 .65396 Metetra
.665 .151 0 r
.38246 .65396 .38685 .65778 .39373 .66578 .38934 .662 Metetra
.047 .466 .883 r
.38934 .662 .39373 .66578 .40085 .66867 .39647 .66493 Metetra
.71 .782 .908 r
.39647 .66493 .40085 .66867 .40822 .66533 .40385 .66162 Metetra
.852 .785 .786 r
.40385 .66162 .40822 .66533 .4158 .65604 .41144 .65233 Metetra
.889 .773 .728 r
.41144 .65233 .4158 .65604 .42349 .64232 .41917 .63858 Metetra
.9 .766 .704 r
.41917 .63858 .42349 .64232 .43121 .62628 .42692 .62245 Metetra
.902 .763 .699 r
.42692 .62245 .43121 .62628 .43891 .60976 .43466 .60578 Metetra
.898 .762 .704 r
.43466 .60578 .43891 .60976 .44655 .59403 .44233 .58981 Metetra
.889 .76 .714 r
.44233 .58981 .44655 .59403 .45412 .57975 .44994 .57517 Metetra
.875 .755 .726 r
.44994 .57517 .45412 .57975 .46163 .56714 .45748 .56201 Metetra
.857 .743 .736 r
.45748 .56201 .46163 .56714 .46909 .55611 .46498 .55022 Metetra
.835 .723 .742 r
.46498 .55022 .46909 .55611 .47651 .54646 .47243 .53956 Metetra
.81 .697 .74 r
.47243 .53956 .47651 .54646 .4839 .53789 .47985 .52976 Metetra
.786 .668 .733 r
.47985 .52976 .4839 .53789 .49128 .53011 .48726 .5206 Metetra
.763 .638 .723 r
.48726 .5206 .49128 .53011 .49865 .52284 .49465 .51194 Metetra
.741 .611 .713 r
.49465 .51194 .49865 .52284 .50602 .51591 .50203 .50375 Metetra
.722 .588 .706 r
.50203 .50375 .50602 .51591 .51338 .5092 .50939 .49616 Metetra
.703 .57 .702 r
.50939 .49616 .51338 .5092 .52074 .50276 .51676 .48934 Metetra
.685 .556 .703 r
.51676 .48934 .52074 .50276 .52811 .49674 .52412 .48358 Metetra
.664 .546 .711 r
.52412 .48358 .52811 .49674 .53548 .4914 .53149 .47918 Metetra
.636 .54 .728 r
.53149 .47918 .53548 .4914 .54286 .48707 .53888 .47644 Metetra
.59 .534 .76 r
.53888 .47644 .54286 .48707 .55027 .48414 .54629 .47564 Metetra
.493 .521 .815 r
.54629 .47564 .55027 .48414 .55771 .48299 .55376 .47706 Metetra
.197 .436 .864 r
.55376 .47706 .55771 .48299 .5652 .48401 .56129 .48103 Metetra
.54 .003 0 r
.56129 .48103 .5652 .48401 .57276 .48761 .5689 .48791 Metetra
.803 .33 .099 r
.5689 .48791 .57276 .48761 .58042 .49425 .57664 .49817 Metetra
.819 .42 .297 r
.57664 .49817 .58042 .49425 .58822 .50454 .58452 .51229 Metetra
.811 .453 .378 r
.58452 .51229 .58822 .50454 .59618 .51912 .59258 .5305 Metetra
.803 .465 .417 r
.59258 .5305 .59618 .51912 .60436 .53847 .60083 .55234 Metetra
.794 .466 .433 r
.60083 .55234 .60436 .53847 .61277 .5623 .60927 .57589 Metetra
.783 .451 .426 r
.60927 .57589 .61277 .5623 .62139 .58837 .61778 .59711 Metetra
.761 .394 .361 r
.61778 .59711 .62139 .58837 .63007 .61142 .6262 .61055 Metetra
0 .487 .73 r
.6262 .61055 .63007 .61142 .63855 .62394 .63433 .61201 Metetra
.764 .62 .7 r
.63433 .61201 .63855 .62394 .64656 .62052 .64209 .60131 Metetra
.775 .583 .639 r
.64209 .60131 .64656 .62052 .65402 .60217 .64951 .5821 Metetra
.791 .589 .628 r
.64951 .5821 .65402 .60217 .66108 .57516 .65674 .55912 Metetra
.821 .621 .633 r
.65674 .55912 .66108 .57516 .66796 .54605 .66388 .53596 Metetra
.868 .682 .649 r
.66388 .53596 .66796 .54605 .67481 .51881 .67102 .51455 Metetra
.932 .78 .67 r
.67102 .51455 .67481 .51881 .68173 .49496 .6782 .49554 Metetra
.979 .907 .663 r
.6782 .49554 .68173 .49496 .68875 .47462 .68545 .47899 Metetra
.818 .904 .497 r
.68545 .47899 .68875 .47462 .69586 .45738 .69276 .46466 Metetra
.69276 .46466 .69586 .45738 .70306 .44276 .70014 .45228 Metetra
0 0 .074 r
.70014 .45228 .70306 .44276 .71035 .43033 .70759 .4416 Metetra
.16 0 .197 r
.70759 .4416 .71035 .43033 .71773 .41983 .71511 .4325 Metetra
.276 0 .267 r
.71511 .4325 .71773 .41983 .7252 .41108 .72272 .42489 Metetra
.355 .055 .311 r
.72272 .42489 .7252 .41108 .73277 .40404 .73041 .41876 Metetra
.414 .111 .34 r
.73041 .41876 .73277 .40404 .74045 .3987 .73821 .41416 Metetra
.461 .156 .361 r
.73821 .41416 .74045 .3987 .74827 .39509 .74614 .41118 Metetra
.501 .194 .377 r
.74614 .41118 .74827 .39509 .75622 .39324 .7542 .40986 Metetra
.536 .226 .389 r
.7542 .40986 .75622 .39324 .76434 .39317 .76241 .41026 Metetra
.565 .253 .399 r
.76241 .41026 .76434 .39317 .77262 .39487 .7708 .41239 Metetra
.59 .276 .406 r
.7708 .41239 .77262 .39487 .78109 .3983 .77936 .41616 Metetra
.61 .294 .411 r
.77936 .41616 .78109 .3983 .78975 .40345 .7881 .42144 Metetra
.626 .308 .413 r
.7881 .42144 .78975 .40345 .79861 .41026 .79701 .42803 Metetra
.638 .318 .412 r
.79701 .42803 .79861 .41026 .80769 .41865 .80609 .43568 Metetra
.65 .323 .407 r
.80609 .43568 .80769 .41865 .81698 .42853 .81531 .44408 Metetra
.661 .326 .394 r
.81531 .44408 .81698 .42853 .82647 .43973 .82465 .453 Metetra
.674 .323 .371 r
.82465 .453 .82647 .43973 .83617 .45197 .83411 .46217 Metetra
.692 .314 .327 r
.83411 .46217 .83617 .45197 .84603 .46492 .84365 .47138 Metetra
.713 .289 .239 r
.84365 .47138 .84603 .46492 .85602 .47807 .85327 .48042 Metetra
.717 .212 .033 r
.85327 .48042 .85602 .47807 .86607 .49071 .86292 .48894 Metetra
.513 0 0 r
.86292 .48894 .86607 .49071 .87608 .50201 .87255 .49645 Metetra
.078 .379 .842 r
.87255 .49645 .87608 .50201 .88593 .51088 .88209 .50233 Metetra
.403 .485 .83 r
.88209 .50233 .88593 .51088 .89548 .51624 .89143 .50581 Metetra
.549 .532 .788 r
.89143 .50581 .89548 .51624 .9046 .51727 .90048 .50623 Metetra
.641 .574 .764 r
.90048 .50623 .9046 .51727 .91323 .51369 .9092 .5033 Metetra
.716 .624 .753 r
.9092 .5033 .91323 .51369 .92138 .50584 .91755 .49709 Metetra
.623 .739 .93 r
.29856 .57908 .30297 .58301 .30979 .58146 .30539 .57752 Metetra
.53 .708 .953 r
.30539 .57752 .30979 .58146 .31656 .58106 .31217 .57711 Metetra
.393 .649 .96 r
.31217 .57711 .31656 .58106 .32328 .58187 .3189 .57792 Metetra
.193 .543 .928 r
.3189 .57792 .32328 .58187 .32995 .584 .32558 .58005 Metetra
0 .369 .821 r
.32558 .58005 .32995 .584 .33658 .58757 .33221 .58362 Metetra
0 .144 .628 r
.33221 .58362 .33658 .58757 .34317 .59273 .3388 .58878 Metetra
.589 .072 0 r
.3388 .58878 .34317 .59273 .34972 .59964 .34534 .59569 Metetra
.732 .232 0 r
.34534 .59569 .34972 .59964 .35623 .60835 .35185 .60443 Metetra
.809 .333 0 r
.35185 .60443 .35623 .60835 .36272 .6188 .35833 .61491 Metetra
.846 .387 .004 r
.35833 .61491 .36272 .6188 .36922 .63059 .36483 .62674 Metetra
.854 .4 .024 r
.36483 .62674 .36922 .63059 .37578 .64282 .37138 .63904 Metetra
.826 .356 0 r
.37138 .63904 .37578 .64282 .38246 .65396 .37805 .65027 Metetra
.684 .168 0 r
.37805 .65027 .38246 .65396 .38934 .662 .38492 .65841 Metetra
.001 .447 .864 r
.38492 .65841 .38934 .662 .39647 .66493 .39205 .66143 Metetra
.709 .794 .917 r
.39205 .66143 .39647 .66493 .40385 .66162 .39945 .65814 Metetra
.857 .793 .788 r
.39945 .65814 .40385 .66162 .41144 .65233 .40707 .64878 Metetra
.892 .777 .727 r
.40707 .64878 .41144 .65233 .41917 .63858 .41482 .63486 Metetra
.902 .766 .702 r
.41482 .63486 .41917 .63858 .42692 .62245 .42262 .61844 Metetra
.901 .759 .695 r
.42262 .61844 .42692 .62245 .43466 .60578 .4304 .60134 Metetra
.894 .752 .697 r
.4304 .60134 .43466 .60578 .44233 .58981 .43811 .58477 Metetra
.881 .742 .704 r
.43811 .58477 .44233 .58981 .44994 .57517 .44577 .56934 Metetra
.863 .726 .71 r
.44577 .56934 .44994 .57517 .45748 .56201 .45335 .5552 Metetra
.841 .706 .713 r
.45335 .5552 .45748 .56201 .46498 .55022 .46089 .54227 Metetra
.817 .681 .713 r
.46089 .54227 .46498 .55022 .47243 .53956 .46837 .53038 Metetra
.793 .655 .71 r
.46837 .53038 .47243 .53956 .47985 .52976 .47583 .5194 Metetra
.771 .631 .706 r
.47583 .5194 .47985 .52976 .48726 .5206 .48325 .50926 Metetra
.751 .611 .704 r
.48325 .50926 .48726 .5206 .49465 .51194 .49065 .50001 Metetra
.732 .596 .704 r
.49065 .50001 .49465 .51194 .50203 .50375 .49803 .49178 Metetra
.715 .586 .71 r
.49803 .49178 .50203 .50375 .50939 .49616 .5054 .48476 Metetra
.697 .583 .723 r
.5054 .48476 .50939 .49616 .51676 .48934 .51276 .47917 Metetra
.674 .586 .749 r
.51276 .47917 .51676 .48934 .52412 .48358 .52012 .47525 Metetra
.636 .6 .796 r
.52012 .47525 .52412 .48358 .53149 .47918 .5275 .47319 Metetra
.538 .622 .884 r
.5275 .47319 .53149 .47918 .53888 .47644 .53491 .4732 Metetra
.126 .54 .919 r
.53491 .4732 .53888 .47644 .54629 .47564 .54235 .47546 Metetra
.598 .029 0 r
.54235 .47546 .54629 .47564 .55376 .47706 .54986 .48023 Metetra
.732 .286 .192 r
.54986 .48023 .55376 .47706 .56129 .48103 .55745 .48775 Metetra
.75 .368 .331 r
.55745 .48775 .56129 .48103 .5689 .48791 .56514 .4983 Metetra
.753 .405 .394 r
.56514 .4983 .5689 .48791 .57664 .49817 .57296 .51209 Metetra
.753 .424 .428 r
.57296 .51209 .57664 .49817 .58452 .51229 .58092 .529 Metetra
.751 .433 .444 r
.58092 .529 .58452 .51229 .59258 .5305 .58904 .54829 Metetra
.749 .432 .448 r
.58904 .54829 .59258 .5305 .60083 .55234 .59729 .56814 Metetra
.744 .419 .434 r
.59729 .56814 .60083 .55234 .60927 .57589 .60561 .58555 Metetra
.731 .369 .365 r
.60561 .58555 .60927 .57589 .61778 .59711 .61389 .59698 Metetra
.39 0 0 r
.61389 .59698 .61778 .59711 .6262 .61055 .62201 .59982 Metetra
.71 .607 .74 r
.62201 .59982 .6262 .61055 .63433 .61201 .62991 .59381 Metetra
.735 .562 .659 r
.62991 .59381 .63433 .61201 .64209 .60131 .63759 .58095 Metetra
.751 .564 .642 r
.63759 .58095 .64209 .60131 .64951 .5821 .6451 .56424 Metetra
.776 .588 .645 r
.6451 .56424 .64951 .5821 .65674 .55912 .65253 .54632 Metetra
.816 .638 .661 r
.65253 .54632 .65674 .55912 .66388 .53596 .65992 .52889 Metetra
.876 .724 .691 r
.65992 .52889 .66388 .53596 .67102 .51455 .66732 .51284 Metetra
.95 .867 .721 r
.66732 .51284 .67102 .51455 .6782 .49554 .67475 .49847 Metetra
.872 .957 .613 r
.67475 .49847 .6782 .49554 .68545 .47899 .68223 .48578 Metetra
.68223 .48578 .68545 .47899 .69276 .46466 .68976 .47467 Metetra
.056 0 .117 r
.68976 .47467 .69276 .46466 .70014 .45228 .69734 .46501 Metetra
.243 0 .251 r
.69734 .46501 .70014 .45228 .70759 .4416 .70499 .4567 Metetra
.343 .052 .319 r
.70499 .4567 .70759 .4416 .71511 .4325 .7127 .44964 Metetra
.404 .117 .36 r
.7127 .44964 .71511 .4325 .72272 .42489 .72049 .44382 Metetra
.447 .162 .386 r
.72049 .44382 .72272 .42489 .73041 .41876 .72836 .43923 Metetra
.479 .195 .404 r
.72836 .43923 .73041 .41876 .73821 .41416 .73632 .43589 Metetra
.505 .221 .417 r
.73632 .43589 .73821 .41416 .74614 .41118 .74439 .43383 Metetra
.526 .241 .426 r
.74439 .43383 .74614 .41118 .7542 .40986 .75257 .43307 Metetra
.543 .257 .431 r
.75257 .43307 .7542 .40986 .76241 .41026 .76088 .43357 Metetra
.558 .27 .434 r
.76088 .43357 .76241 .41026 .7708 .41239 .76932 .43525 Metetra
.571 .279 .433 r
.76932 .43525 .7708 .41239 .77936 .41616 .77788 .43798 Metetra
.581 .284 .429 r
.77788 .43798 .77936 .41616 .7881 .42144 .78655 .44151 Metetra
.59 .285 .419 r
.78655 .44151 .7881 .42144 .79701 .42803 .79534 .44566 Metetra
.599 .281 .403 r
.79534 .44566 .79701 .42803 .80609 .43568 .80422 .45022 Metetra
.608 .272 .375 r
.80422 .45022 .80609 .43568 .81531 .44408 .81318 .45507 Metetra
.62 .255 .327 r
.81318 .45507 .81531 .44408 .82465 .453 .82223 .46017 Metetra
.637 .221 .238 r
.82223 .46017 .82465 .453 .83411 .46217 .83137 .46555 Metetra
.644 .148 .056 r
.83137 .46555 .83411 .46217 .84365 .47138 .84061 .47123 Metetra
.559 0 0 r
.84061 .47123 .84365 .47138 .85327 .48042 .84994 .47716 Metetra
0 .265 .732 r
.84994 .47716 .85327 .48042 .86292 .48894 .85935 .48319 Metetra
.105 .39 .847 r
.85935 .48319 .86292 .48894 .87255 .49645 .8688 .48888 Metetra
.293 .446 .843 r
.8688 .48888 .87255 .49645 .88209 .50233 .87822 .49365 Metetra
.42 .493 .828 r
.87822 .49365 .88209 .50233 .89143 .50581 .88753 .49679 Metetra
.528 .548 .82 r
.88753 .49679 .89143 .50581 .90048 .50623 .89663 .49756 Metetra
.627 .611 .815 r
.89663 .49756 .90048 .50623 .9092 .5033 .90545 .49548 Metetra
.717 .676 .809 r
.90545 .49548 .9092 .5033 .91755 .49709 .91396 .4905 Metetra
.623 .739 .93 r
.29413 .57514 .29856 .57908 .30539 .57752 .30097 .57357 Metetra
.53 .708 .953 r
.30097 .57357 .30539 .57752 .31217 .57711 .30776 .57316 Metetra
.393 .649 .96 r
.30776 .57316 .31217 .57711 .3189 .57792 .31449 .57396 Metetra
.192 .542 .928 r
.31449 .57396 .3189 .57792 .32558 .58005 .32118 .57608 Metetra
0 .368 .82 r
.32118 .57608 .32558 .58005 .33221 .58362 .32781 .57965 Metetra
0 .141 .625 r
.32781 .57965 .33221 .58362 .3388 .58878 .3344 .58483 Metetra
.594 .076 0 r
.3344 .58483 .3388 .58878 .34534 .59569 .34094 .59177 Metetra
.737 .237 0 r
.34094 .59177 .34534 .59569 .35185 .60443 .34744 .60055 Metetra
.814 .339 0 r
.34744 .60055 .35185 .60443 .35833 .61491 .35392 .61111 Metetra
.85 .394 .019 r
.35392 .61111 .35833 .61491 .36483 .62674 .3604 .62306 Metetra
.859 .408 .045 r
.3604 .62306 .36483 .62674 .37138 .63904 .36693 .63552 Metetra
.837 .37 0 r
.36693 .63552 .37138 .63904 .37805 .65027 .37359 .64695 Metetra
.719 .203 0 r
.37359 .64695 .37805 .65027 .38492 .65841 .38046 .65526 Metetra
0 .409 .819 r
.38046 .65526 .38492 .65841 .39205 .66143 .38759 .65836 Metetra
.713 .818 .93 r
.38759 .65836 .39205 .66143 .39945 .65814 .39501 .65497 Metetra
.866 .804 .787 r
.39501 .65497 .39945 .65814 .40707 .64878 .40266 .6453 Metetra
.896 .777 .722 r
.40266 .6453 .40707 .64878 .41482 .63486 .41046 .63083 Metetra
.901 .759 .695 r
.41046 .63083 .41482 .63486 .42262 .61844 .41831 .61366 Metetra
.895 .743 .686 r
.41831 .61366 .42262 .61844 .4304 .60134 .42615 .59564 Metetra
.882 .728 .686 r
.42615 .59564 .4304 .60134 .43811 .58477 .43392 .57802 Metetra
.864 .709 .688 r
.43392 .57802 .43811 .58477 .44577 .56934 .44163 .56145 Metetra
.843 .689 .691 r
.44163 .56145 .44577 .56934 .45335 .5552 .44926 .54619 Metetra
.821 .668 .693 r
.44926 .54619 .45335 .5552 .46089 .54227 .45683 .53227 Metetra
.799 .648 .695 r
.45683 .53227 .46089 .54227 .46837 .53038 .46434 .51967 Metetra
.779 .632 .698 r
.46434 .51967 .46837 .53038 .47583 .5194 .47181 .50841 Metetra
.762 .62 .703 r
.47181 .50841 .47583 .5194 .48325 .50926 .47923 .49853 Metetra
.746 .615 .714 r
.47923 .49853 .48325 .50926 .49065 .50001 .48663 .49014 Metetra
.731 .619 .733 r
.48663 .49014 .49065 .50001 .49803 .49178 .49401 .48337 Metetra
.714 .635 .768 r
.49401 .48337 .49803 .49178 .5054 .48476 .50137 .47837 Metetra
.683 .671 .832 r
.50137 .47837 .5054 .48476 .51276 .47917 .50873 .47527 Metetra
.577 .737 .952 r
.50873 .47527 .51276 .47917 .52012 .47525 .5161 .47417 Metetra
0 .555 .8 r
.5161 .47417 .52012 .47525 .5275 .47319 .5235 .4752 Metetra
.573 .051 0 r
.5235 .4752 .5275 .47319 .53491 .4732 .53093 .47848 Metetra
.672 .254 .243 r
.53093 .47848 .53491 .4732 .54235 .47546 .53842 .48413 Metetra
.698 .331 .348 r
.53842 .48413 .54235 .47546 .54986 .48023 .54599 .49227 Metetra
.708 .369 .4 r
.54599 .49227 .54986 .48023 .55745 .48775 .55364 .50296 Metetra
.713 .39 .429 r
.55364 .50296 .55745 .48775 .56514 .4983 .5614 .5161 Metetra
.716 .402 .445 r
.5614 .5161 .56514 .4983 .57296 .51209 .56928 .53129 Metetra
.718 .407 .451 r
.56928 .53129 .57296 .51209 .58092 .529 .57728 .54763 Metetra
.718 .404 .447 r
.57728 .54763 .58092 .529 .58904 .54829 .58538 .56359 Metetra
.715 .388 .424 r
.58538 .56359 .58904 .54829 .59729 .56814 .59354 .57706 Metetra
.702 .33 .341 r
.59354 .57706 .59729 .56814 .60561 .58555 .60169 .58584 Metetra
.401 0 0 r
.60169 .58584 .60561 .58555 .61389 .59698 .60976 .58841 Metetra
.681 .629 .79 r
.60976 .58841 .61389 .59698 .62201 .59982 .6177 .58462 Metetra
.716 .568 .686 r
.6177 .58462 .62201 .59982 .62991 .59381 .62551 .57565 Metetra
.73 .559 .66 r
.62551 .57565 .62991 .59381 .63759 .58095 .6332 .56338 Metetra
.747 .572 .658 r
.6332 .56338 .63759 .58095 .6451 .56424 .64082 .54967 Metetra
.77 .602 .67 r
.64082 .54967 .6451 .56424 .65253 .54632 .6484 .53593 Metetra
.806 .656 .696 r
.6484 .53593 .65253 .54632 .65992 .52889 .65599 .523 Metetra
.859 .749 .741 r
.65599 .523 .65992 .52889 .66732 .51284 .6636 .51128 Metetra
.918 .906 .796 r
.6636 .51128 .66732 .51284 .67475 .49847 .67124 .50091 Metetra
.746 .958 .66 r
.67124 .50091 .67475 .49847 .68223 .48578 .67893 .49189 Metetra
.67893 .49189 .68223 .48578 .68976 .47467 .68668 .48411 Metetra
.202 0 .154 r
.68668 .48411 .68976 .47467 .69734 .46501 .69448 .47749 Metetra
.344 .028 .277 r
.69448 .47749 .69734 .46501 .70499 .4567 .70234 .47197 Metetra
.417 .113 .34 r
.70234 .47197 .70499 .4567 .7127 .44964 .71026 .46747 Metetra
.46 .165 .377 r
.71026 .46747 .7127 .44964 .72049 .44382 .71826 .46392 Metetra
.488 .199 .401 r
.71826 .46392 .72049 .44382 .72836 .43923 .72633 .46128 Metetra
.508 .223 .417 r
.72633 .46128 .72836 .43923 .73632 .43589 .73447 .45945 Metetra
.521 .238 .427 r
.73447 .45945 .73632 .43589 .74439 .43383 .74269 .45831 Metetra
.53 .249 .432 r
.74269 .45831 .74439 .43383 .75257 .43307 .75098 .45776 Metetra
.535 .253 .434 r
.75098 .45776 .75257 .43307 .76088 .43357 .75933 .45761 Metetra
.538 .253 .431 r
.75933 .45761 .76088 .43357 .76932 .43525 .76773 .4577 Metetra
.538 .248 .423 r
.76773 .4577 .76932 .43525 .77788 .43798 .77618 .45792 Metetra
.535 .237 .408 r
.77618 .45792 .77788 .43798 .78655 .44151 .78468 .45818 Metetra
.531 .218 .381 r
.78468 .45818 .78655 .44151 .79534 .44566 .79321 .45851 Metetra
.526 .186 .335 r
.79321 .45851 .79534 .44566 .80422 .45022 .80181 .45903 Metetra
.517 .132 .249 r
.80181 .45903 .80422 .45022 .81318 .45507 .81048 .45994 Metetra
.496 .029 .075 r
.81048 .45994 .81318 .45507 .82223 .46017 .81924 .46144 Metetra
.408 0 0 r
.81924 .46144 .82223 .46017 .83137 .46555 .82812 .46374 Metetra
0 .414 .769 r
.82812 .46374 .83137 .46555 .84061 .47123 .83715 .46696 Metetra
.099 .46 .888 r
.83715 .46696 .84061 .47123 .84994 .47716 .84631 .47105 Metetra
.202 .441 .866 r
.84631 .47105 .84994 .47716 .85935 .48319 .85561 .47583 Metetra
.26 .432 .843 r
.85561 .47583 .85935 .48319 .8688 .48888 .86499 .4809 Metetra
.315 .448 .836 r
.86499 .4809 .8688 .48888 .87822 .49365 .87441 .48556 Metetra
.385 .489 .842 r
.87441 .48556 .87822 .49365 .88753 .49679 .88376 .48906 Metetra
.48 .555 .855 r
.88376 .48906 .88753 .49679 .89663 .49756 .89295 .49055 Metetra
.594 .641 .866 r
.89295 .49055 .89663 .49756 .90545 .49548 .90189 .48936 Metetra
.707 .724 .863 r
.90189 .48936 .90545 .49548 .91396 .4905 .91052 .48527 Metetra
.623 .739 .93 r
.28968 .57118 .29413 .57514 .30097 .57357 .29653 .5696 Metetra
.529 .708 .953 r
.29653 .5696 .30097 .57357 .30776 .57316 .30333 .56918 Metetra
.391 .649 .96 r
.30333 .56918 .30776 .57316 .31449 .57396 .31007 .56999 Metetra
.189 .541 .927 r
.31007 .56999 .31449 .57396 .32118 .57608 .31676 .57212 Metetra
0 .363 .816 r
.31676 .57212 .32118 .57608 .32781 .57965 .32339 .57571 Metetra
0 .132 .614 r
.32339 .57571 .32781 .57965 .3344 .58483 .32998 .58093 Metetra
.608 .089 0 r
.32998 .58093 .3344 .58483 .34094 .59177 .33652 .58794 Metetra
.75 .251 0 r
.33652 .58794 .34094 .59177 .34744 .60055 .34301 .59684 Metetra
.825 .353 0 r
.34301 .59684 .34744 .60055 .35392 .61111 .34947 .60759 Metetra
.86 .408 .054 r
.34947 .60759 .35392 .61111 .3604 .62306 .35593 .61982 Metetra
.869 .424 .089 r
.35593 .61982 .3604 .62306 .36693 .63552 .36244 .63261 Metetra
.852 .393 .061 r
.36244 .63261 .36693 .63552 .37359 .64695 .36908 .64437 Metetra
.762 .25 0 r
.36908 .64437 .37359 .64695 .38046 .65526 .37594 .65288 Metetra
0 .358 .731 r
.37594 .65288 .38046 .65526 .38759 .65836 .38308 .65588 Metetra
.738 .854 .934 r
.38308 .65588 .38759 .65836 .39501 .65497 .39054 .65197 Metetra
.878 .806 .775 r
.39054 .65197 .39501 .65497 .40266 .6453 .39825 .64135 Metetra
.895 .764 .709 r
.39825 .64135 .40266 .6453 .41046 .63083 .40612 .62564 Metetra
.891 .735 .683 r
.40612 .62564 .41046 .63083 .41831 .61366 .41405 .60708 Metetra
.878 .713 .673 r
.41405 .60708 .41831 .61366 .42615 .59564 .42195 .58772 Metetra
.861 .693 .672 r
.42195 .58772 .42615 .59564 .43392 .57802 .42978 .56893 Metetra
.842 .675 .675 r
.42978 .56893 .43392 .57802 .44163 .56145 .43753 .55149 Metetra
.823 .659 .679 r
.43753 .55149 .44163 .56145 .44926 .54619 .44519 .53576 Metetra
.805 .647 .686 r
.44519 .53576 .44926 .54619 .45683 .53227 .45277 .52186 Metetra
.79 .64 .696 r
.45277 .52186 .45683 .53227 .46434 .51967 .46028 .50985 Metetra
.777 .641 .711 r
.46028 .50985 .46434 .51967 .47181 .50841 .46774 .49975 Metetra
.766 .652 .736 r
.46774 .49975 .47181 .50841 .47923 .49853 .47515 .49158 Metetra
.756 .682 .78 r
.47515 .49158 .47923 .49853 .48663 .49014 .48254 .48538 Metetra
.735 .745 .86 r
.48254 .48538 .48663 .49014 .49401 .48337 .4899 .48119 Metetra
.613 .851 .989 r
.4899 .48119 .49401 .48337 .50137 .47837 .49726 .47905 Metetra
.102 0 0 r
.49726 .47905 .50137 .47837 .50873 .47527 .50463 .47899 Metetra
.532 .053 .065 r
.50463 .47899 .50873 .47527 .5161 .47417 .51202 .48104 Metetra
.626 .228 .27 r
.51202 .48104 .5161 .47417 .5235 .4752 .51944 .48521 Metetra
.658 .301 .355 r
.51944 .48521 .5235 .4752 .53093 .47848 .52692 .4915 Metetra
.673 .339 .4 r
.52692 .4915 .53093 .47848 .53842 .48413 .53446 .49984 Metetra
.682 .361 .425 r
.53446 .49984 .53842 .48413 .54599 .49227 .54208 .51009 Metetra
.688 .375 .439 r
.54208 .51009 .54599 .49227 .55364 .50296 .54979 .52196 Metetra
.692 .382 .445 r
.54979 .52196 .55364 .50296 .5614 .5161 .5576 .53493 Metetra
.695 .383 .444 r
.5576 .53493 .5614 .5161 .56928 .53129 .5655 .54819 Metetra
.697 .377 .432 r
.5655 .54819 .56928 .53129 .57728 .54763 .57349 .56059 Metetra
.694 .354 .397 r
.57349 .56059 .57728 .54763 .58538 .56359 .58153 .57073 Metetra
.673 .277 .286 r
.58153 .57073 .58538 .56359 .59354 .57706 .58958 .57723 Metetra
.316 0 0 r
.58958 .57723 .59354 .57706 .60169 .58584 .59759 .57915 Metetra
.664 .669 .845 r
.59759 .57915 .60169 .58584 .60976 .58841 .60554 .57637 Metetra
.711 .592 .721 r
.60554 .57637 .60976 .58841 .6177 .58462 .6134 .56958 Metetra
.724 .573 .684 r
.6134 .56958 .6177 .58462 .62551 .57565 .62119 .56002 Metetra
.735 .576 .676 r
.62119 .56002 .62551 .57565 .6332 .56338 .62892 .54904 Metetra
.748 .592 .682 r
.62892 .54904 .6332 .56338 .64082 .54967 .63662 .53781 Metetra
.766 .622 .7 r
.63662 .53781 .64082 .54967 .6484 .53593 .64433 .5271 Metetra
.789 .671 .733 r
.64433 .5271 .6484 .53593 .65599 .523 .65205 .51741 Metetra
.821 .754 .788 r
.65205 .51741 .65599 .523 .6636 .51128 .65982 .50897 Metetra
.849 .895 .87 r
.65982 .50897 .6636 .51128 .67124 .50091 .66763 .50181 Metetra
.68 .976 .819 r
.66763 .50181 .67124 .50091 .67893 .49189 .6755 .4959 Metetra
.6755 .4959 .67893 .49189 .68668 .48411 .68343 .49117 Metetra
.27 0 .09 r
.68343 .49117 .68668 .48411 .69448 .47749 .69143 .48747 Metetra
.399 .043 .241 r
.69143 .48747 .69448 .47749 .70234 .47197 .69949 .48469 Metetra
.46 .128 .315 r
.69949 .48469 .70234 .47197 .71026 .46747 .70762 .4827 Metetra
.492 .175 .357 r
.70762 .4827 .71026 .46747 .71826 .46392 .71581 .48133 Metetra
.509 .202 .382 r
.71581 .48133 .71826 .46392 .72633 .46128 .72405 .48038 Metetra
.517 .217 .397 r
.72405 .48038 .72633 .46128 .73447 .45945 .73234 .47965 Metetra
.519 .223 .405 r
.73234 .47965 .73447 .45945 .74269 .45831 .74066 .47888 Metetra
.514 .221 .406 r
.74066 .47888 .74269 .45831 .75098 .45776 .74899 .47779 Metetra
.505 .211 .401 r
.74899 .47779 .75098 .45776 .75933 .45761 .75732 .47623 Metetra
.49 .193 .388 r
.75732 .47623 .75933 .45761 .76773 .4577 .76563 .47407 Metetra
.469 .162 .363 r
.76563 .47407 .76773 .4577 .77618 .45792 .77393 .47135 Metetra
.438 .115 .319 r
.77393 .47135 .77618 .45792 .78468 .45818 .78223 .46829 Metetra
.393 .04 .243 r
.78223 .46829 .78468 .45818 .79321 .45851 .79054 .46517 Metetra
.32 0 .097 r
.79054 .46517 .79321 .45851 .80181 .45903 .7989 .46237 Metetra
.179 0 0 r
.7989 .46237 .80181 .45903 .81048 .45994 .80735 .4603 Metetra
.087 .644 .705 r
.80735 .4603 .81048 .45994 .81924 .46144 .81592 .45927 Metetra
.297 .72 .972 r
.81592 .45927 .81924 .46144 .82812 .46374 .82463 .45952 Metetra
.333 .617 .954 r
.82463 .45952 .82812 .46374 .83715 .46696 .83352 .46118 Metetra
.315 .527 .901 r
.83352 .46118 .83715 .46696 .84631 .47105 .8426 .46421 Metetra
.291 .47 .864 r
.8426 .46421 .84631 .47105 .85561 .47583 .85184 .46836 Metetra
.276 .439 .843 r
.85184 .46836 .85561 .47583 .86499 .4809 .86121 .47323 Metetra
.285 .439 .84 r
.86121 .47323 .86499 .4809 .87441 .48556 .87065 .47812 Metetra
.331 .476 .854 r
.87065 .47812 .87441 .48556 .88376 .48906 .88007 .48214 Metetra
.419 .547 .879 r
.88007 .48214 .88376 .48906 .89295 .49055 .88936 .48438 Metetra
.548 .648 .9 r
.88936 .48438 .89295 .49055 .90189 .48936 .8984 .48402 Metetra
.685 .747 .898 r
.8984 .48402 .90189 .48936 .91052 .48527 .90714 .48064 Metetra
.622 .739 .931 r
.28521 .56721 .28968 .57118 .29653 .5696 .29207 .56562 Metetra
.528 .708 .954 r
.29207 .56562 .29653 .5696 .30333 .56918 .29887 .56521 Metetra
.387 .648 .961 r
.29887 .56521 .30333 .56918 .31007 .56999 .30562 .56603 Metetra
.177 .536 .925 r
.30562 .56603 .31007 .56999 .31676 .57212 .31231 .56819 Metetra
0 .349 .804 r
.31231 .56819 .31676 .57212 .32339 .57571 .31895 .57185 Metetra
0 .105 .583 r
.31895 .57185 .32339 .57571 .32998 .58093 .32553 .57719 Metetra
.644 .122 0 r
.32553 .57719 .32998 .58093 .33652 .58794 .33205 .5844 Metetra
.778 .283 0 r
.33205 .5844 .33652 .58794 .34301 .59684 .33852 .5936 Metetra
.844 .38 .03 r
.33852 .5936 .34301 .59684 .34947 .60759 .34496 .60477 Metetra
.872 .431 .119 r
.34496 .60477 .34947 .60759 .35593 .61982 .35138 .61752 Metetra
.877 .445 .16 r
.35138 .61752 .35593 .61982 .36244 .63261 .35786 .63087 Metetra
.859 .416 .146 r
.35786 .63087 .36244 .63261 .36908 .64437 .36448 .64303 Metetra
.783 .285 .009 r
.36448 .64303 .36908 .64437 .37594 .65288 .37134 .65149 Metetra
.219 0 0 r
.37134 .65149 .37594 .65288 .38308 .65588 .37853 .65374 Metetra
.799 .871 .901 r
.37853 .65374 .38308 .65588 .39054 .65197 .38606 .64835 Metetra
.883 .78 .743 r
.38606 .64835 .39054 .65197 .39825 .64135 .39387 .63575 Metetra
.882 .729 .688 r
.39387 .63575 .39825 .64135 .40612 .62564 .40185 .61802 Metetra
.869 .698 .667 r
.40185 .61802 .40612 .62564 .41405 .60708 .40985 .59781 Metetra
.854 .677 .662 r
.40985 .59781 .41405 .60708 .42195 .58772 .41781 .57738 Metetra
.838 .662 .663 r
.41781 .57738 .42195 .58772 .42978 .56893 .42568 .55822 Metetra
.824 .653 .67 r
.42568 .55822 .42978 .56893 .43753 .55149 .43343 .54108 Metetra
.812 .65 .682 r
.43343 .54108 .43753 .55149 .44519 .53576 .44108 .52628 Metetra
.803 .656 .7 r
.44108 .52628 .44519 .53576 .45277 .52186 .44865 .51389 Metetra
.799 .676 .729 r
.44865 .51389 .45277 .52186 .46028 .50985 .45614 .50387 Metetra
.797 .717 .777 r
.45614 .50387 .46028 .50985 .46774 .49975 .46357 .49616 Metetra
.789 .803 .863 r
.46357 .49616 .46774 .49975 .47515 .49158 .47096 .49067 Metetra
.66 .931 .971 r
.47096 .49067 .47515 .49158 .48254 .48538 .47833 .48736 Metetra
.092 0 0 r
.47833 .48736 .48254 .48538 .4899 .48119 .48569 .48615 Metetra
.482 .031 .102 r
.48569 .48615 .4899 .48119 .49726 .47905 .49305 .48699 Metetra
.584 .199 .277 r
.49305 .48699 .49726 .47905 .50463 .47899 .50043 .48979 Metetra
.624 .272 .354 r
.50043 .48979 .50463 .47899 .51202 .48104 .50785 .49445 Metetra
.643 .311 .394 r
.50785 .49445 .51202 .48104 .51944 .48521 .51531 .50081 Metetra
.655 .334 .416 r
.51531 .50081 .51944 .48521 .52692 .4915 .52284 .50868 Metetra
.663 .348 .429 r
.52284 .50868 .52692 .4915 .53446 .49984 .53043 .5178 Metetra
.669 .356 .435 r
.53043 .5178 .53446 .49984 .54208 .51009 .5381 .52783 Metetra
.675 .36 .433 r
.5381 .52783 .54208 .51009 .54979 .52196 .54585 .53833 Metetra
.679 .358 .424 r
.54585 .53833 .54979 .52196 .5576 .53493 .55368 .5487 Metetra
.682 .347 .402 r
.55368 .5487 .5576 .53493 .5655 .54819 .56158 .55817 Metetra
.677 .314 .351 r
.56158 .55817 .5655 .54819 .57349 .56059 .56953 .56578 Metetra
.641 .206 .2 r
.56953 .56578 .57349 .56059 .58153 .57073 .57751 .5706 Metetra
.202 0 0 r
.57751 .5706 .58153 .57073 .58958 .57723 .58548 .57196 Metetra
.649 .714 .896 r
.58548 .57196 .58958 .57723 .59759 .57915 .59342 .56968 Metetra
.713 .627 .76 r
.59342 .56968 .59759 .57915 .60554 .57637 .60131 .56414 Metetra
.727 .598 .713 r
.60131 .56414 .60554 .57637 .6134 .56958 .60915 .55622 Metetra
.735 .592 .697 r
.60915 .55622 .6134 .56958 .62119 .56002 .61694 .54692 Metetra
.742 .598 .696 r
.61694 .54692 .62119 .56002 .62892 .54904 .62472 .5372 Metetra
.75 .614 .708 r
.62472 .5372 .62892 .54904 .63662 .53781 .63249 .52784 Metetra
.758 .641 .731 r
.63249 .52784 .63662 .53781 .64433 .5271 .64028 .51935 Metetra
.768 .683 .769 r
.64028 .51935 .64433 .5271 .65205 .51741 .64811 .51201 Metetra
.776 .751 .831 r
.64811 .51201 .65205 .51741 .65982 .50897 .65599 .50598 Metetra
.761 .859 .922 r
.65599 .50598 .65982 .50897 .66763 .50181 .66393 .50129 Metetra
.585 .934 .943 r
.66393 .50129 .66763 .50181 .6755 .4959 .67194 .49785 Metetra
.67194 .49785 .6755 .4959 .68343 .49117 .68002 .49557 Metetra
.31 0 0 r
.68002 .49557 .68343 .49117 .69143 .48747 .68817 .49428 Metetra
.437 .02 .149 r
.68817 .49428 .69143 .48747 .69949 .48469 .6964 .49375 Metetra
.488 .108 .245 r
.6964 .49375 .69949 .48469 .70762 .4827 .70468 .49372 Metetra
.508 .151 .297 r
.70468 .49372 .70762 .4827 .71581 .48133 .71301 .49391 Metetra
.511 .17 .324 r
.71301 .49391 .71581 .48133 .72405 .48038 .72137 .49395 Metetra
.504 .171 .336 r
.72137 .49395 .72405 .48038 .73234 .47965 .72974 .4935 Metetra
.486 .158 .335 r
.72974 .4935 .73234 .47965 .74066 .47888 .73809 .49227 Metetra
.457 .129 .321 r
.73809 .49227 .74066 .47888 .74899 .47779 .74641 .49003 Metetra
.414 .081 .29 r
.74641 .49003 .74899 .47779 .75732 .47623 .75468 .4867 Metetra
.351 .007 .234 r
.75468 .4867 .75732 .47623 .76563 .47407 .76289 .4824 Metetra
.254 0 .137 r
.76289 .4824 .76563 .47407 .77393 .47135 .77107 .47738 Metetra
.107 0 0 r
.77107 .47738 .77393 .47135 .78223 .46829 .77924 .47201 Metetra
.77924 .47201 .78223 .46829 .79054 .46517 .78742 .46678 Metetra
.378 .81 .645 r
.78742 .46678 .79054 .46517 .7989 .46237 .79566 .46209 Metetra
.551 .929 .905 r
.79566 .46209 .7989 .46237 .80735 .4603 .804 .45834 Metetra
.573 .878 .993 r
.804 .45834 .80735 .4603 .81592 .45927 .81246 .4559 Metetra
.517 .769 .988 r
.81246 .4559 .81592 .45927 .82463 .45952 .82109 .45496 Metetra
.437 .659 .955 r
.82109 .45496 .82463 .45952 .83352 .46118 .82991 .45564 Metetra
.357 .565 .916 r
.82991 .45564 .83352 .46118 .8426 .46421 .83892 .45794 Metetra
.292 .493 .883 r
.83892 .45794 .8426 .46421 .85184 .46836 .84813 .46162 Metetra
.249 .448 .86 r
.84813 .46162 .85184 .46836 .86121 .47323 .85749 .46627 Metetra
.24 .435 .852 r
.85749 .46627 .86121 .47323 .87065 .47812 .86695 .47125 Metetra
.278 .464 .863 r
.86695 .47125 .87065 .47812 .88007 .48214 .87641 .47562 Metetra
.369 .534 .888 r
.87641 .47562 .88007 .48214 .88936 .48438 .88577 .47841 Metetra
.506 .635 .911 r
.88577 .47841 .88936 .48438 .8984 .48402 .8949 .47872 Metetra
.658 .739 .909 r
.8949 .47872 .8984 .48402 .90714 .48064 .90373 .47595 Metetra
.621 .741 .932 r
.28072 .56326 .28521 .56721 .29207 .56562 .28759 .56167 Metetra
.523 .709 .956 r
.28759 .56167 .29207 .56562 .29887 .56521 .29439 .56128 Metetra
.374 .645 .962 r
.29439 .56128 .29887 .56521 .30562 .56603 .30114 .56215 Metetra
.144 .522 .917 r
.30114 .56215 .30562 .56603 .31231 .56819 .30783 .56443 Metetra
0 .31 .766 r
.30783 .56443 .31231 .56819 .31895 .57185 .31446 .56827 Metetra
.494 0 0 r
.31446 .56827 .31895 .57185 .32553 .57719 .32102 .5739 Metetra
.711 .19 0 r
.32102 .5739 .32553 .57719 .33205 .5844 .32752 .58154 Metetra
.818 .336 0 r
.32752 .58154 .33205 .5844 .33852 .5936 .33396 .59134 Metetra
.862 .417 .128 r
.33396 .59134 .33852 .5936 .34496 .60477 .34034 .60328 Metetra
.875 .455 .208 r
.34034 .60328 .34496 .60477 .35138 .61752 .34672 .61687 Metetra
.87 .459 .243 r
.34672 .61687 .35138 .61752 .35786 .63087 .35317 .63088 Metetra
.847 .423 .226 r
.35317 .63088 .35786 .63087 .36448 .64303 .35978 .64312 Metetra
.76 .272 .073 r
.35978 .64312 .36448 .64303 .37134 .65149 .36669 .65066 Metetra
.112 .653 .844 r
.36669 .65066 .37134 .65149 .37853 .65374 .37399 .65081 Metetra
.852 .82 .817 r
.37399 .65081 .37853 .65374 .38606 .64835 .38166 .64253 Metetra
.868 .727 .704 r
.38166 .64253 .38606 .64835 .39387 .63575 .3896 .6271 Metetra
.856 .684 .668 r
.3896 .6271 .39387 .63575 .40185 .61802 .39767 .60734 Metetra
.843 .661 .656 r
.39767 .60734 .40185 .61802 .40985 .59781 .40573 .58628 Metetra
.832 .65 .657 r
.40573 .58628 .40985 .59781 .41781 .57738 .4137 .56614 Metetra
.823 .648 .665 r
.4137 .56614 .41781 .57738 .42568 .55822 .42155 .54819 Metetra
.819 .657 .682 r
.42155 .54819 .42568 .55822 .43343 .54108 .42927 .53294 Metetra
.82 .68 .709 r
.42927 .53294 .43343 .54108 .44108 .52628 .43688 .52049 Metetra
.827 .727 .755 r
.43688 .52049 .44108 .52628 .44865 .51389 .4444 .51075 Metetra
.835 .821 .835 r
.4444 .51075 .44865 .51389 .45614 .50387 .45185 .50357 Metetra
.751 .968 .931 r
.45185 .50357 .45614 .50387 .46357 .49616 .45925 .49877 Metetra
.45925 .49877 .46357 .49616 .47096 .49067 .46663 .4962 Metetra
.409 0 .084 r
.46663 .4962 .47096 .49067 .47833 .48736 .47399 .49569 Metetra
.538 .155 .263 r
.47399 .49569 .47833 .48736 .48569 .48615 .48135 .49706 Metetra
.588 .236 .34 r
.48135 .49706 .48569 .48615 .49305 .48699 .48873 .50013 Metetra
.613 .279 .38 r
.48873 .50013 .49305 .48699 .50043 .48979 .49615 .50465 Metetra
.628 .303 .402 r
.49615 .50465 .50043 .48979 .50785 .49445 .5036 .5104 Metetra
.638 .318 .413 r
.5036 .5104 .50785 .49445 .51531 .50081 .51112 .51713 Metetra
.646 .327 .417 r
.51112 .51713 .51531 .50081 .52284 .50868 .51869 .52459 Metetra
.654 .332 .415 r
.51869 .52459 .52284 .50868 .53043 .5178 .52632 .53254 Metetra
.661 .333 .407 r
.52632 .53254 .53043 .5178 .5381 .52783 .53403 .54069 Metetra
.667 .327 .389 r
.53403 .54069 .5381 .52783 .54585 .53833 .54181 .54866 Metetra
.669 .309 .354 r
.54181 .54866 .54585 .53833 .55368 .5487 .54965 .5559 Metetra
.659 .262 .281 r
.54965 .5559 .55368 .5487 .56158 .55817 .55754 .56173 Metetra
.598 .117 .083 r
.55754 .56173 .56158 .55817 .56953 .56578 .56546 .56543 Metetra
.111 0 0 r
.56546 .56543 .56953 .56578 .57751 .5706 .5734 .56641 Metetra
.627 .757 .94 r
.5734 .56641 .57751 .5706 .58548 .57196 .58133 .56443 Metetra
.715 .668 .802 r
.58133 .56443 .58548 .57196 .59342 .56968 .58923 .55969 Metetra
.733 .629 .743 r
.58923 .55969 .59342 .56968 .60131 .56414 .5971 .55278 Metetra
.74 .614 .719 r
.5971 .55278 .60131 .56414 .60915 .55622 .60493 .5445 Metetra
.744 .612 .712 r
.60493 .5445 .60915 .55622 .61694 .54692 .61275 .53569 Metetra
.746 .619 .718 r
.61275 .53569 .61694 .54692 .62472 .5372 .62056 .52709 Metetra
.748 .634 .734 r
.62056 .52709 .62472 .5372 .63249 .52784 .62839 .5192 Metetra
.747 .658 .762 r
.62839 .5192 .63249 .52784 .64028 .51935 .63625 .5124 Metetra
.742 .694 .806 r
.63625 .5124 .64028 .51935 .64811 .51201 .64416 .50688 Metetra
.725 .749 .871 r
.64416 .50688 .64811 .51201 .65599 .50598 .65213 .50271 Metetra
.665 .822 .959 r
.65213 .50271 .65599 .50598 .66393 .50129 .66017 .49989 Metetra
.451 .843 .981 r
.66017 .49989 .66393 .50129 .67194 .49785 .66828 .49834 Metetra
.007 0 0 r
.66828 .49834 .67194 .49785 .68002 .49557 .67647 .49789 Metetra
.329 0 0 r
.67647 .49789 .68002 .49557 .68817 .49428 .68474 .49832 Metetra
.454 0 .001 r
.68474 .49832 .68817 .49428 .6964 .49375 .69308 .49934 Metetra
.495 .048 .116 r
.69308 .49934 .6964 .49375 .70468 .49372 .70147 .50054 Metetra
.499 .078 .173 r
.70147 .50054 .70468 .49372 .71301 .49391 .70989 .50148 Metetra
.48 .074 .192 r
.70989 .50148 .71301 .49391 .72137 .49395 .7183 .50172 Metetra
.436 .036 .181 r
.7183 .50172 .72137 .49395 .72974 .4935 .72669 .50084 Metetra
.363 0 .135 r
.72669 .50084 .72974 .4935 .73809 .49227 .73503 .49861 Metetra
.24 0 .036 r
.73503 .49861 .73809 .49227 .74641 .49003 .7433 .49495 Metetra
.036 0 0 r
.7433 .49495 .74641 .49003 .75468 .4867 .75149 .48999 Metetra
.75149 .48999 .75468 .4867 .76289 .4824 .75964 .48408 Metetra
.571 .911 .688 r
.75964 .48408 .76289 .4824 .77107 .47738 .76775 .47765 Metetra
.739 .992 .842 r
.76775 .47765 .77107 .47738 .77924 .47201 .77586 .47115 Metetra
.785 .981 .905 r
.77586 .47115 .77924 .47201 .78742 .46678 .78401 .46503 Metetra
.771 .945 .936 r
.78401 .46503 .78742 .46678 .79566 .46209 .79222 .45968 Metetra
.726 .903 .958 r
.79222 .45968 .79566 .46209 .804 .45834 .80054 .4554 Metetra
.654 .852 .976 r
.80054 .4554 .804 .45834 .81246 .4559 .80899 .45245 Metetra
.559 .785 .983 r
.80899 .45245 .81246 .4559 .82109 .45496 .81759 .45101 Metetra
.449 .702 .975 r
.81759 .45101 .82109 .45496 .82991 .45564 .82638 .45117 Metetra
.338 .609 .949 r
.82638 .45117 .82991 .45564 .83892 .45794 .83536 .45292 Metetra
.249 .525 .915 r
.83536 .45292 .83892 .45794 .84813 .46162 .84452 .4561 Metetra
.197 .467 .886 r
.84452 .4561 .84813 .46162 .85749 .46627 .85385 .46033 Metetra
.192 .445 .872 r
.85385 .46033 .85749 .46627 .86695 .47125 .86329 .46503 Metetra
.242 .467 .876 r
.86329 .46503 .86695 .47125 .87641 .47562 .87276 .46935 Metetra
.345 .53 .894 r
.87276 .46935 .87641 .47562 .88577 .47841 .88215 .4723 Metetra
.487 .62 .908 r
.88215 .4723 .88577 .47841 .8949 .47872 .89134 .47296 Metetra
.637 .711 .901 r
.89134 .47296 .8949 .47872 .90373 .47595 .90023 .47066 Metetra
.618 .746 .937 r
.27619 .55939 .28072 .56326 .28759 .56167 .28307 .55783 Metetra
.51 .711 .962 r
.28307 .55783 .28759 .56167 .29439 .56128 .28988 .55751 Metetra
.335 .637 .963 r
.28988 .55751 .29439 .56128 .30114 .56215 .29662 .55855 Metetra
.053 .481 .887 r
.29662 .55855 .30114 .56215 .30783 .56443 .3033 .56109 Metetra
0 .21 .655 r
.3033 .56109 .30783 .56443 .31446 .56827 .3099 .56535 Metetra
.631 .085 0 r
.3099 .56535 .31446 .56827 .32102 .5739 .31643 .57158 Metetra
.786 .286 0 r
.31643 .57158 .32102 .5739 .32752 .58154 .32288 .58003 Metetra
.845 .394 .135 r
.32288 .58003 .32752 .58154 .33396 .59134 .32926 .59086 Metetra
.862 .447 .238 r
.32926 .59086 .33396 .59134 .34034 .60328 .33558 .60391 Metetra
.86 .466 .293 r
.33558 .60391 .34034 .60328 .34672 .61687 .34192 .61844 Metetra
.847 .457 .308 r
.34192 .61844 .34672 .61687 .35317 .63088 .34835 .6327 Metetra
.814 .401 .265 r
.34835 .6327 .35317 .63088 .35978 .64312 .35502 .64389 Metetra
.657 .133 0 r
.35502 .64389 .35978 .64312 .36669 .65066 .36206 .64876 Metetra
.719 .885 .957 r
.36206 .64876 .36669 .65066 .37399 .65081 .36954 .6451 Metetra
.847 .73 .734 r
.36954 .6451 .37399 .65081 .38166 .64253 .37739 .63308 Metetra
.839 .671 .674 r
.37739 .63308 .38166 .64253 .3896 .6271 .38545 .61519 Metetra
.829 .647 .656 r
.38545 .61519 .3896 .6271 .39767 .60734 .39356 .59479 Metetra
.823 .64 .655 r
.39356 .59479 .39767 .60734 .40573 .58628 .40161 .57472 Metetra
.821 .645 .665 r
.40161 .57472 .40573 .58628 .4137 .56614 .40952 .55668 Metetra
.825 .665 .685 r
.40952 .55668 .4137 .56614 .42155 .54819 .41731 .54144 Metetra
.837 .708 .721 r
.41731 .54144 .42155 .54819 .42927 .53294 .42496 .52919 Metetra
.857 .79 .785 r
.42496 .52919 .42927 .53294 .43688 .52049 .43251 .51982 Metetra
.849 .942 .882 r
.43251 .51982 .43688 .52049 .4444 .51075 .43999 .51311 Metetra
.388 .817 .648 r
.43999 .51311 .4444 .51075 .45185 .50357 .4474 .50882 Metetra
.264 0 0 r
.4474 .50882 .45185 .50357 .45925 .49877 .45479 .50668 Metetra
.468 .076 .212 r
.45479 .50668 .45925 .49877 .46663 .4962 .46216 .50644 Metetra
.543 .183 .307 r
.46216 .50644 .46663 .4962 .47399 .49569 .46953 .50782 Metetra
.578 .236 .352 r
.46953 .50782 .47399 .49569 .48135 .49706 .47692 .51053 Metetra
.598 .264 .376 r
.47692 .51053 .48135 .49706 .48873 .50013 .48434 .51428 Metetra
.61 .281 .387 r
.48434 .51428 .48873 .50013 .49615 .50465 .4918 .51883 Metetra
.62 .29 .39 r
.4918 .51883 .49615 .50465 .5036 .5104 .4993 .52399 Metetra
.629 .295 .386 r
.4993 .52399 .5036 .5104 .51112 .51713 .50686 .52961 Metetra
.639 .297 .376 r
.50686 .52961 .51112 .51713 .51869 .52459 .51448 .53559 Metetra
.648 .295 .358 r
.51448 .53559 .51869 .52459 .52632 .53254 .52215 .54178 Metetra
.656 .285 .33 r
.52215 .54178 .52632 .53254 .53403 .54069 .52989 .54792 Metetra
.656 .26 .282 r
.52989 .54792 .53403 .54069 .54181 .54866 .53768 .55361 Metetra
.637 .197 .188 r
.53768 .55361 .54181 .54866 .54965 .5559 .54553 .55828 Metetra
.547 .023 0 r
.54553 .55828 .54965 .5559 .55754 .56173 .55342 .56131 Metetra
0 .517 .704 r
.55342 .56131 .55754 .56173 .56546 .56543 .56133 .56211 Metetra
.594 .793 .975 r
.56133 .56211 .56546 .56543 .5734 .56641 .56925 .56039 Metetra
.717 .711 .844 r
.56925 .56039 .5734 .56641 .58133 .56443 .57716 .55619 Metetra
.741 .662 .773 r
.57716 .55619 .58133 .56443 .58923 .55969 .58504 .54992 Metetra
.747 .639 .74 r
.58504 .54992 .58923 .55969 .5971 .55278 .5929 .54228 Metetra
.749 .629 .727 r
.5929 .54228 .5971 .55278 .60493 .5445 .60074 .534 Metetra
.748 .629 .728 r
.60074 .534 .60493 .5445 .61275 .53569 .60858 .52577 Metetra
.745 .636 .739 r
.60858 .52577 .61275 .53569 .62056 .52709 .61643 .51816 Metetra
.74 .65 .76 r
.61643 .51816 .62056 .52709 .62839 .5192 .6243 .51154 Metetra
.73 .672 .793 r
.6243 .51154 .62839 .5192 .63625 .5124 .63222 .50614 Metetra
.709 .703 .842 r
.63222 .50614 .63625 .5124 .64416 .50688 .6402 .50209 Metetra
.665 .745 .91 r
.6402 .50209 .64416 .50688 .65213 .50271 .64824 .49942 Metetra
.557 .785 .984 r
.64824 .49942 .65213 .50271 .66017 .49989 .65636 .49807 Metetra
.303 .742 .966 r
.65636 .49807 .66017 .49989 .66828 .49834 .66455 .49794 Metetra
0 .515 .705 r
.66455 .49794 .66828 .49834 .67647 .49789 .67283 .4988 Metetra
.328 0 0 r
.67283 .4988 .67647 .49789 .68474 .49832 .68118 .50037 Metetra
.435 0 0 r
.68118 .50037 .68474 .49832 .69308 .49934 .68959 .50224 Metetra
.458 0 0 r
.68959 .50224 .69308 .49934 .70147 .50054 .69804 .50395 Metetra
.428 0 0 r
.69804 .50395 .70147 .50054 .70989 .50148 .70649 .50494 Metetra
.342 0 0 r
.70649 .50494 .70989 .50148 .7183 .50172 .71492 .50475 Metetra
.167 0 0 r
.71492 .50475 .7183 .50172 .72669 .50084 .72329 .50302 Metetra
.72329 .50302 .72669 .50084 .73503 .49861 .73159 .4996 Metetra
.531 .915 .776 r
.73159 .4996 .73503 .49861 .7433 .49495 .73981 .49464 Metetra
.765 .991 .888 r
.73981 .49464 .7433 .49495 .75149 .48999 .74795 .48845 Metetra
.837 .953 .892 r
.74795 .48845 .75149 .48999 .75964 .48408 .75605 .48153 Metetra
.843 .904 .879 r
.75605 .48153 .75964 .48408 .76775 .47765 .76414 .4744 Metetra
.829 .87 .875 r
.76414 .4744 .76775 .47765 .77586 .47115 .77225 .46753 Metetra
.806 .851 .883 r
.77225 .46753 .77586 .47115 .78401 .46503 .78042 .46131 Metetra
.773 .842 .904 r
.78042 .46131 .78401 .46503 .79222 .45968 .78866 .45605 Metetra
.726 .836 .933 r
.78866 .45605 .79222 .45968 .80054 .4554 .79702 .45195 Metetra
.653 .823 .965 r
.79702 .45195 .80054 .4554 .80899 .45245 .8055 .44915 Metetra
.548 .79 .988 r
.8055 .44915 .80899 .45245 .81759 .45101 .81413 .44776 Metetra
.415 .726 .989 r
.81413 .44776 .81759 .45101 .82638 .45117 .82293 .4478 Metetra
.277 .638 .965 r
.82293 .4478 .82638 .45117 .83536 .45292 .8319 .44925 Metetra
.171 .55 .929 r
.8319 .44925 .83536 .45292 .84452 .4561 .84104 .45195 Metetra
.125 .491 .903 r
.84104 .45195 .84452 .4561 .85385 .46033 .85032 .45559 Metetra
.144 .472 .894 r
.85032 .45559 .85385 .46033 .86329 .46503 .85971 .45966 Metetra
.225 .495 .899 r
.85971 .45966 .86329 .46503 .87276 .46935 .86914 .46343 Metetra
.352 .55 .907 r
.86914 .46343 .87276 .46935 .88215 .4723 .8785 .46602 Metetra
.495 .619 .903 r
.8785 .46602 .88215 .4723 .89134 .47296 .88769 .46659 Metetra
.628 .684 .884 r
.88769 .46659 .89134 .47296 .90023 .47066 .89663 .46451 Metetra
.609 .76 .951 r
.27162 .55583 .27619 .55939 .28307 .55783 .2785 .55432 Metetra
.472 .716 .976 r
.2785 .55432 .28307 .55783 .28988 .55751 .28531 .5542 Metetra
.229 .608 .953 r
.28531 .5542 .28988 .55751 .29662 .55855 .29203 .55558 Metetra
0 .359 .767 r
.29203 .55558 .29662 .55855 .3033 .56109 .29868 .55867 Metetra
.556 0 0 r
.29868 .55867 .3033 .56109 .3099 .56535 .30524 .5637 Metetra
.754 .239 0 r
.30524 .5637 .3099 .56535 .31643 .57158 .31171 .57096 Metetra
.823 .369 .149 r
.31171 .57096 .31643 .57158 .32288 .58003 .31808 .58068 Metetra
.841 .431 .262 r
.31808 .58068 .32288 .58003 .32926 .59086 .32438 .59287 Metetra
.842 .458 .323 r
.32438 .59287 .32926 .59086 .33558 .60391 .33065 .60705 Metetra
.833 .46 .348 r
.33065 .60705 .33558 .60391 .34192 .61844 .33696 .62191 Metetra
.814 .433 .333 r
.33696 .62191 .34192 .61844 .34835 .6327 .34346 .63501 Metetra
.759 .322 .214 r
.34346 .63501 .34835 .6327 .35502 .64389 .35029 .64311 Metetra
.06 .617 .811 r
.35029 .64311 .35502 .64389 .36206 .64876 .35757 .64345 Metetra
.811 .738 .784 r
.35757 .64345 .36206 .64876 .36954 .6451 .36526 .63529 Metetra
.817 .66 .688 r
.36526 .63529 .36954 .6451 .37739 .63308 .37325 .62041 Metetra
.812 .634 .661 r
.37325 .62041 .37739 .63308 .38545 .61519 .38135 .60201 Metetra
.811 .63 .658 r
.38135 .60201 .38545 .61519 .39356 .59479 .38942 .58313 Metetra
.816 .642 .668 r
.38942 .58313 .39356 .59479 .40161 .57472 .39738 .56582 Metetra
.828 .673 .691 r
.39738 .56582 .40161 .57472 .40952 .55668 .4052 .55108 Metetra
.85 .734 .735 r
.4052 .55108 .40952 .55668 .41731 .54144 .4129 .53924 Metetra
.878 .849 .811 r
.4129 .53924 .41731 .54144 .42496 .52919 .42048 .53023 Metetra
.79 .997 .858 r
.42048 .53023 .42496 .52919 .43251 .51982 .42798 .52382 Metetra
.42798 .52382 .43251 .51982 .43999 .51311 .43542 .51971 Metetra
.324 0 .078 r
.43542 .51971 .43999 .51311 .4474 .50882 .44282 .51758 Metetra
.465 .084 .232 r
.44282 .51758 .4474 .50882 .45479 .50668 .45021 .51708 Metetra
.524 .164 .299 r
.45021 .51708 .45479 .50668 .46216 .50644 .4576 .51786 Metetra
.554 .204 .33 r
.4576 .51786 .46216 .50644 .46953 .50782 .46501 .51963 Metetra
.572 .225 .342 r
.46501 .51963 .46953 .50782 .47692 .51053 .47245 .52211 Metetra
.584 .235 .344 r
.47245 .52211 .47692 .51053 .48434 .51428 .47992 .52513 Metetra
.595 .24 .336 r
.47992 .52513 .48434 .51428 .4918 .51883 .48743 .52861 Metetra
.607 .241 .321 r
.48743 .52861 .4918 .51883 .4993 .52399 .49498 .53253 Metetra
.621 .24 .3 r
.49498 .53253 .4993 .52399 .50686 .52961 .50258 .53688 Metetra
.633 .236 .273 r
.50258 .53688 .50686 .52961 .51448 .53559 .51023 .54159 Metetra
.642 .225 .236 r
.51023 .54159 .51448 .53559 .52215 .54178 .51794 .54647 Metetra
.64 .196 .18 r
.51794 .54647 .52215 .54178 .52989 .54792 .5257 .55118 Metetra
.611 .125 .077 r
.5257 .55118 .52989 .54792 .53768 .55361 .53351 .5552 Metetra
.501 0 0 r
.53351 .5552 .53768 .55361 .54553 .55828 .54137 .55791 Metetra
.084 0 0 r
.54137 .55791 .54553 .55828 .55342 .56131 .54926 .55874 Metetra
.539 .816 .997 r
.54926 .55874 .55342 .56131 .56133 .56211 .55717 .55729 Metetra
.713 .756 .886 r
.55717 .55729 .56133 .56211 .56925 .56039 .56507 .55352 Metetra
.748 .697 .803 r
.56507 .55352 .56925 .56039 .57716 .55619 .57296 .54772 Metetra
.756 .665 .76 r
.57296 .54772 .57716 .55619 .58504 .54992 .58084 .54047 Metetra
.757 .648 .741 r
.58084 .54047 .58504 .54992 .5929 .54228 .5887 .53246 Metetra
.754 .641 .737 r
.5887 .53246 .5929 .54228 .60074 .534 .59656 .52438 Metetra
.748 .642 .743 r
.59656 .52438 .60074 .534 .60858 .52577 .60442 .5168 Metetra
.74 .65 .759 r
.60442 .5168 .60858 .52577 .61643 .51816 .61231 .51012 Metetra
.728 .663 .786 r
.61231 .51012 .61643 .51816 .6243 .51154 .62023 .50463 Metetra
.706 .683 .825 r
.62023 .50463 .6243 .51154 .63222 .50614 .6282 .50046 Metetra
.668 .71 .879 r
.6282 .50046 .63222 .50614 .6402 .50209 .63623 .49767 Metetra
.59 .736 .945 r
.63623 .49767 .6402 .50209 .64824 .49942 .64434 .49626 Metetra
.434 .737 .991 r
.64434 .49626 .64824 .49942 .65636 .49807 .65252 .4961 Metetra
.161 .644 .923 r
.65252 .4961 .65636 .49807 .66455 .49794 .66078 .49704 Metetra
0 .455 .709 r
.66078 .49704 .66455 .49794 .67283 .4988 .66912 .49881 Metetra
.31 0 0 r
.66912 .49881 .67283 .4988 .68118 .50037 .67752 .50103 Metetra
.37 0 0 r
.67752 .50103 .68118 .50037 .68959 .50224 .68597 .50323 Metetra
.339 0 0 r
.68597 .50323 .68959 .50224 .69804 .50395 .69444 .50488 Metetra
.206 0 0 r
.69444 .50488 .69804 .50395 .70649 .50494 .7029 .50543 Metetra
.7029 .50543 .70649 .50494 .71492 .50475 .71131 .50442 Metetra
.46 .884 .91 r
.71131 .50442 .71492 .50475 .72329 .50302 .71965 .50164 Metetra
.716 .947 .955 r
.71965 .50164 .72329 .50302 .73159 .4996 .7279 .4971 Metetra
.806 .904 .909 r
.7279 .4971 .73159 .4996 .73981 .49464 .73608 .4911 Metetra
.828 .854 .866 r
.73608 .4911 .73981 .49464 .74795 .48845 .7442 .48411 Metetra
.827 .818 .841 r
.7442 .48411 .74795 .48845 .75605 .48153 .75229 .47667 Metetra
.817 .796 .833 r
.75229 .47667 .75605 .48153 .76414 .4744 .76038 .46932 Metetra
.801 .785 .838 r
.76038 .46932 .76414 .4744 .77225 .46753 .76852 .46251 Metetra
.779 .784 .856 r
.76852 .46251 .77225 .46753 .78042 .46131 .77673 .45657 Metetra
.748 .788 .885 r
.77673 .45657 .78042 .46131 .78866 .45605 .78503 .45173 Metetra
.701 .794 .922 r
.78503 .45173 .78866 .45605 .79702 .45195 .79345 .44813 Metetra
.627 .794 .962 r
.79345 .44813 .79702 .45195 .8055 .44915 .80199 .44582 Metetra
.514 .774 .991 r
.80199 .44582 .8055 .44915 .81413 .44776 .81068 .44483 Metetra
.363 .718 .987 r
.81068 .44483 .81413 .44776 .82293 .4478 .81952 .4451 Metetra
.205 .633 .95 r
.81952 .4451 .82293 .4478 .8319 .44925 .82851 .44652 Metetra
.091 .551 .908 r
.82851 .44652 .8319 .44925 .84104 .45195 .83764 .44892 Metetra
.056 .507 .892 r
.83764 .44892 .84104 .45195 .85032 .45559 .84689 .45197 Metetra
.108 .51 .908 r
.84689 .45197 .85032 .45559 .85971 .45966 .85621 .45521 Metetra
.231 .548 .929 r
.85621 .45521 .85971 .45966 .86914 .46343 .86556 .45807 Metetra
.384 .597 .93 r
.86556 .45807 .86914 .46343 .8785 .46602 .87484 .45983 Metetra
.524 .639 .905 r
.87484 .45983 .8785 .46602 .88769 .46659 .88398 .45981 Metetra
.635 .674 .87 r
.88398 .45981 .88769 .46659 .89663 .46451 .89292 .45754 Metetra
.58 .796 .981 r
.26696 .55302 .27162 .55583 .2785 .55432 .27385 .55162 Metetra
.358 .714 .986 r
.27385 .55162 .2785 .55432 .28531 .5542 .28064 .55186 Metetra
0 .478 .826 r
.28064 .55186 .28531 .5542 .29203 .55558 .28733 .55389 Metetra
.503 0 0 r
.28733 .55389 .29203 .55558 .29868 .55867 .29392 .55789 Metetra
.724 .203 0 r
.29392 .55789 .29868 .55867 .30524 .5637 .30041 .56413 Metetra
.796 .344 .171 r
.30041 .56413 .30524 .5637 .31171 .57096 .30679 .57281 Metetra
.816 .411 .282 r
.30679 .57281 .31171 .57096 .31808 .58068 .31308 .584 Metetra
.819 .442 .341 r
.31308 .584 .31808 .58068 .32438 .59287 .31932 .59735 Metetra
.815 .45 .366 r
.31932 .59735 .32438 .59287 .33065 .60705 .32557 .6118 Metetra
.804 .435 .359 r
.32557 .6118 .33065 .60705 .33696 .62191 .33197 .6253 Metetra
.775 .37 .284 r
.33197 .6253 .33696 .62191 .34346 .63501 .33866 .63502 Metetra
.509 0 0 r
.33866 .63502 .34346 .63501 .35029 .64311 .34575 .63822 Metetra
.741 .743 .854 r
.34575 .63822 .35029 .64311 .35757 .64345 .35327 .6337 Metetra
.788 .649 .709 r
.35327 .6337 .35757 .64345 .36526 .63529 .36112 .62249 Metetra
.792 .624 .672 r
.36112 .62249 .36526 .63529 .37325 .62041 .36913 .60717 Metetra
.797 .623 .666 r
.36913 .60717 .37325 .62041 .38135 .60201 .37717 .59057 Metetra
.808 .641 .675 r
.37717 .59057 .38135 .60201 .38942 .58313 .38513 .57479 Metetra
.827 .681 .701 r
.38513 .57479 .38942 .58313 .39738 .56582 .39298 .56104 Metetra
.857 .755 .749 r
.39298 .56104 .39738 .56582 .4052 .55108 .4007 .54979 Metetra
.886 .889 .828 r
.4007 .54979 .4052 .55108 .4129 .53924 .40832 .54109 Metetra
.726 .987 .807 r
.40832 .54109 .4129 .53924 .42048 .53023 .41585 .53473 Metetra
.41585 .53473 .42048 .53023 .42798 .52382 .42332 .53043 Metetra
.284 0 .051 r
.42332 .53043 .42798 .52382 .43542 .51971 .43076 .52781 Metetra
.415 .022 .183 r
.43076 .52781 .43542 .51971 .44282 .51758 .43818 .52651 Metetra
.473 .093 .238 r
.43818 .52651 .44282 .51758 .45021 .51708 .44561 .52619 Metetra
.502 .125 .257 r
.44561 .52619 .45021 .51708 .4576 .51786 .45305 .52659 Metetra
.52 .137 .256 r
.45305 .52659 .4576 .51786 .46501 .51963 .46051 .52753 Metetra
.533 .138 .239 r
.46051 .52753 .46501 .51963 .47245 .52211 .46799 .52895 Metetra
.547 .135 .212 r
.46799 .52895 .47245 .52211 .47992 .52513 .47551 .53089 Metetra
.563 .132 .18 r
.47551 .53089 .47992 .52513 .48743 .52861 .48306 .53338 Metetra
.584 .133 .148 r
.48306 .53338 .48743 .52861 .49498 .53253 .49065 .53649 Metetra
.604 .137 .118 r
.49065 .53649 .49498 .53253 .50258 .53688 .49828 .54018 Metetra
.617 .136 .089 r
.49828 .54018 .50258 .53688 .51023 .54159 .50596 .54429 Metetra
.615 .117 .046 r
.50596 .54429 .51023 .54159 .51794 .54647 .51369 .54846 Metetra
.583 .057 0 r
.51369 .54846 .51794 .54647 .5257 .55118 .52147 .55221 Metetra
.476 0 0 r
.52147 .55221 .5257 .55118 .53351 .5552 .5293 .55493 Metetra
.138 0 0 r
.5293 .55493 .53351 .5552 .54137 .55791 .53717 .55598 Metetra
.448 .813 .995 r
.53717 .55598 .54137 .55791 .54926 .55874 .54506 .55492 Metetra
.699 .799 .927 r
.54506 .55492 .54926 .55874 .55717 .55729 .55297 .55158 Metetra
.755 .734 .833 r
.55297 .55158 .55717 .55729 .56507 .55352 .56087 .54617 Metetra
.766 .692 .78 r
.56087 .54617 .56507 .55352 .57296 .54772 .56876 .53919 Metetra
.766 .668 .754 r
.56876 .53919 .57296 .54772 .58084 .54047 .57664 .5313 Metetra
.762 .655 .744 r
.57664 .5313 .58084 .54047 .5887 .53246 .58451 .5232 Metetra
.755 .651 .746 r
.58451 .5232 .5887 .53246 .59656 .52438 .59238 .51547 Metetra
.745 .653 .758 r
.59238 .51547 .59656 .52438 .60442 .5168 .60027 .50857 Metetra
.731 .661 .78 r
.60027 .50857 .60442 .5168 .61231 .51012 .60819 .5028 Metetra
.71 .674 .812 r
.60819 .5028 .61231 .51012 .62023 .50463 .61615 .49834 Metetra
.675 .691 .857 r
.61615 .49834 .62023 .50463 .6282 .50046 .62417 .49527 Metetra
.614 .71 .913 r
.62417 .49527 .6282 .50046 .63623 .49767 .63226 .49359 Metetra
.5 .716 .968 r
.63226 .49359 .63623 .49767 .64434 .49626 .64041 .49324 Metetra
.303 .675 .975 r
.64041 .49324 .64434 .49626 .65252 .4961 .64865 .49406 Metetra
.043 .558 .873 r
.64865 .49406 .65252 .4961 .66078 .49704 .65696 .49582 Metetra
0 .414 .705 r
.65696 .49582 .66078 .49704 .66912 .49881 .66534 .49819 Metetra
.271 0 0 r
.66534 .49819 .66912 .49881 .67752 .50103 .67378 .50072 Metetra
.26 0 0 r
.67378 .50072 .67752 .50103 .68597 .50323 .68226 .50287 Metetra
.126 0 0 r
.68226 .50287 .68597 .50323 .69444 .50488 .69073 .50409 Metetra
.161 .691 .861 r
.69073 .50409 .69444 .50488 .7029 .50543 .69917 .50387 Metetra
.503 .865 .987 r
.69917 .50387 .7029 .50543 .71131 .50442 .70755 .50186 Metetra
.706 .885 .963 r
.70755 .50186 .71131 .50442 .71965 .50164 .71585 .49801 Metetra
.782 .844 .898 r
.71585 .49801 .71965 .50164 .7279 .4971 .72407 .4925 Metetra
.806 .804 .849 r
.72407 .4925 .7279 .4971 .73608 .4911 .73222 .48574 Metetra
.81 .776 .821 r
.73222 .48574 .73608 .4911 .7442 .48411 .74033 .47829 Metetra
.806 .76 .81 r
.74033 .47829 .7442 .48411 .75229 .47667 .74843 .47068 Metetra
.796 .753 .813 r
.74843 .47068 .75229 .47667 .76038 .46932 .75655 .46343 Metetra
.781 .752 .827 r
.75655 .46343 .76038 .46932 .76852 .46251 .76473 .45691 Metetra
.759 .757 .85 r
.76473 .45691 .76852 .46251 .77673 .45657 .77299 .45141 Metetra
.725 .764 .884 r
.77299 .45141 .77673 .45657 .78503 .45173 .78135 .44711 Metetra
.673 .77 .923 r
.78135 .44711 .78503 .45173 .79345 .44813 .78984 .44408 Metetra
.593 .769 .963 r
.78984 .44408 .79345 .44813 .80199 .44582 .79845 .44236 Metetra
.473 .746 .989 r
.79845 .44236 .80199 .44582 .81068 .44483 .80721 .44189 Metetra
.318 .691 .979 r
.80721 .44189 .81068 .44483 .81952 .4451 .81611 .44255 Metetra
.161 .613 .934 r
.81611 .44255 .81952 .4451 .82851 .44652 .82513 .44416 Metetra
.053 .545 .887 r
.82513 .44416 .82851 .44652 .83764 .44892 .83427 .44645 Metetra
.031 .522 .878 r
.83427 .44645 .83764 .44892 .84689 .45197 .8435 .44905 Metetra
.107 .553 .915 r
.8435 .44905 .84689 .45197 .85621 .45521 .85277 .45152 Metetra
.263 .614 .957 r
.85277 .45152 .85621 .45521 .86556 .45807 .86202 .45335 Metetra
.437 .66 .955 r
.86202 .45335 .86556 .45807 .87484 .45983 .87121 .454 Metetra
.57 .679 .914 r
.87121 .454 .87484 .45983 .88398 .45981 .88027 .45303 Metetra
.657 .686 .865 r
.88027 .45303 .88398 .45981 .89292 .45754 .88915 .45016 Metetra
.451 .835 .986 r
.26216 .55178 .26696 .55302 .27385 .55162 .26905 .55056 Metetra
.001 .565 .796 r
.26905 .55056 .27385 .55162 .28064 .55186 .27581 .55136 Metetra
.471 0 0 r
.27581 .55136 .28064 .55186 .28733 .55389 .28244 .5543 Metetra
.689 .175 .007 r
.28244 .5543 .28733 .55389 .29392 .55789 .28896 .55952 Metetra
.763 .319 .196 r
.28896 .55952 .29392 .55789 .30041 .56413 .29536 .56717 Metetra
.787 .388 .296 r
.29536 .56717 .30041 .56413 .30679 .57281 .30166 .57724 Metetra
.795 .421 .348 r
.30166 .57724 .30679 .57281 .31308 .584 .3079 .58937 Metetra
.795 .433 .37 r
.3079 .58937 .31308 .584 .31932 .59735 .31415 .60266 Metetra
.791 .424 .362 r
.31415 .60266 .31932 .59735 .32557 .6118 .32052 .61542 Metetra
.776 .376 .295 r
.32052 .61542 .32557 .6118 .33197 .6253 .32712 .62536 Metetra
.644 .101 0 r
.32712 .62536 .33197 .6253 .33866 .63502 .33408 .63021 Metetra
.611 .712 .917 r
.33408 .63021 .33866 .63502 .34575 .63822 .34143 .62871 Metetra
.744 .635 .738 r
.34143 .62871 .34575 .63822 .35327 .6337 .3491 .62131 Metetra
.765 .613 .69 r
.3491 .62131 .35327 .6337 .36112 .62249 .35697 .60977 Metetra
.779 .617 .68 r
.35697 .60977 .36112 .62249 .36913 .60717 .36491 .59632 Metetra
.797 .642 .689 r
.36491 .59632 .36913 .60717 .37717 .59057 .37283 .58285 Metetra
.823 .689 .716 r
.37283 .58285 .37717 .59057 .38513 .57479 .38066 .57059 Metetra
.858 .773 .766 r
.38066 .57059 .38513 .57479 .39298 .56104 .3884 .56015 Metetra
.885 .909 .838 r
.3884 .56015 .39298 .56104 .4007 .54979 .39605 .55173 Metetra
.734 .989 .804 r
.39605 .55173 .4007 .54979 .40832 .54109 .40362 .5452 Metetra
.40362 .5452 .40832 .54109 .41585 .53473 .41114 .54032 Metetra
.13 0 0 r
.41114 .54032 .41585 .53473 .42332 .53043 .41863 .53677 Metetra
.274 0 .029 r
.41863 .53677 .42332 .53043 .43076 .52781 .4261 .53422 Metetra
.337 0 .07 r
.4261 .53422 .43076 .52781 .43818 .52651 .43357 .53243 Metetra
.362 0 .062 r
.43357 .53243 .43818 .52651 .44561 .52619 .44105 .53122 Metetra
.37 0 .018 r
.44105 .53122 .44561 .52619 .45305 .52659 .44854 .53054 Metetra
.375 0 0 r
.44854 .53054 .45305 .52659 .46051 .52753 .45605 .53045 Metetra
.386 0 0 r
.45605 .53045 .46051 .52753 .46799 .52895 .46357 .53102 Metetra
.416 0 0 r
.46357 .53102 .46799 .52895 .47551 .53089 .47112 .53238 Metetra
.464 0 0 r
.47112 .53238 .47551 .53089 .48306 .53338 .4787 .53458 Metetra
.518 0 0 r
.4787 .53458 .48306 .53338 .49065 .53649 .48631 .5376 Metetra
.56 .006 0 r
.48631 .5376 .49065 .53649 .49828 .54018 .49396 .54125 Metetra
.578 .028 0 r
.49396 .54125 .49828 .54018 .50596 .54429 .50165 .54523 Metetra
.56 .001 0 r
.50165 .54523 .50596 .54429 .51369 .54846 .5094 .54903 Metetra
.474 0 0 r
.5094 .54903 .51369 .54846 .52147 .55221 .5172 .552 Metetra
.219 0 0 r
.5172 .552 .52147 .55221 .5293 .55493 .52505 .55351 Metetra
.308 .763 .953 r
.52505 .55351 .5293 .55493 .53717 .55598 .53293 .55301 Metetra
.661 .835 .967 r
.53293 .55301 .53717 .55598 .54506 .55492 .54084 .55023 Metetra
.755 .772 .867 r
.54084 .55023 .54506 .55492 .55297 .55158 .54875 .54526 Metetra
.776 .721 .802 r
.54875 .54526 .55297 .55158 .56087 .54617 .55665 .53854 Metetra
.778 .69 .767 r
.55665 .53854 .56087 .54617 .56876 .53919 .56455 .53071 Metetra
.773 .672 .752 r
.56455 .53071 .56876 .53919 .57664 .5313 .57243 .52247 Metetra
.765 .662 .75 r
.57243 .52247 .57664 .5313 .58451 .5232 .58031 .51447 Metetra
.754 .66 .758 r
.58031 .51447 .58451 .5232 .59238 .51547 .58821 .50719 Metetra
.74 .663 .775 r
.58821 .50719 .59238 .51547 .60027 .50857 .59613 .50099 Metetra
.719 .671 .802 r
.59613 .50099 .60027 .50857 .60819 .5028 .60408 .49608 Metetra
.687 .682 .84 r
.60408 .49608 .60819 .5028 .61615 .49834 .61208 .49256 Metetra
.636 .695 .888 r
.61208 .49256 .61615 .49834 .62417 .49527 .62014 .49047 Metetra
.548 .701 .941 r
.62014 .49047 .62417 .49527 .63226 .49359 .62827 .48976 Metetra
.399 .682 .975 r
.62827 .48976 .63226 .49359 .64041 .49324 .63647 .49031 Metetra
.183 .608 .943 r
.63647 .49031 .64041 .49324 .64865 .49406 .64475 .49193 Metetra
0 .491 .832 r
.64475 .49193 .64865 .49406 .65696 .49582 .6531 .4943 Metetra
0 .397 .716 r
.6531 .4943 .65696 .49582 .66534 .49819 .66152 .49704 Metetra
.209 0 0 r
.66152 .49704 .66534 .49819 .67378 .50072 .66998 .49962 Metetra
0 .468 .735 r
.66998 .49962 .67378 .50072 .68226 .50287 .67846 .50149 Metetra
.126 .647 .884 r
.67846 .50149 .68226 .50287 .69073 .50409 .68693 .50207 Metetra
.442 .812 .994 r
.68693 .50207 .69073 .50409 .69917 .50387 .69534 .50095 Metetra
.66 .853 .973 r
.69534 .50095 .69917 .50387 .70755 .50186 .70369 .49792 Metetra
.755 .824 .905 r
.70369 .49792 .70755 .50186 .71585 .49801 .71195 .49308 Metetra
.79 .787 .85 r
.71195 .49308 .71585 .49801 .72407 .4925 .72015 .48676 Metetra
.8 .761 .817 r
.72015 .48676 .72407 .4925 .73222 .48574 .72829 .47947 Metetra
.8 .744 .801 r
.72829 .47947 .73222 .48574 .74033 .47829 .7364 .47178 Metetra
.794 .736 .799 r
.7364 .47178 .74033 .47829 .74843 .47068 .74452 .46422 Metetra
.783 .735 .808 r
.74452 .46422 .74843 .47068 .75655 .46343 .75268 .45723 Metetra
.766 .739 .827 r
.75268 .45723 .75655 .46343 .76473 .45691 .76091 .45113 Metetra
.741 .745 .855 r
.76091 .45113 .76473 .45691 .77299 .45141 .76923 .44614 Metetra
.703 .753 .891 r
.76923 .44614 .77299 .45141 .78135 .44711 .77765 .44239 Metetra
.644 .756 .931 r
.77765 .44239 .78135 .44711 .78984 .44408 .7862 .43994 Metetra
.556 .748 .967 r
.7862 .43994 .78984 .44408 .79845 .44236 .79488 .43877 Metetra
.433 .719 .985 r
.79488 .43877 .79845 .44236 .80721 .44189 .8037 .43879 Metetra
.285 .663 .971 r
.8037 .43879 .80721 .44189 .81611 .44255 .81265 .43985 Metetra
.148 .596 .93 r
.81265 .43985 .81611 .44255 .82513 .44416 .82172 .4417 Metetra
.062 .547 .893 r
.82172 .4417 .82513 .44416 .83427 .44645 .83089 .444 Metetra
.06 .546 .891 r
.83089 .444 .83427 .44645 .8435 .44905 .84011 .44632 Metetra
.155 .599 .933 r
.84011 .44632 .8435 .44905 .85277 .45152 .84934 .44818 Metetra
.325 .674 .977 r
.84934 .44818 .85277 .45152 .86202 .45335 .85852 .44909 Metetra
.5 .72 .971 r
.85852 .44909 .86202 .45335 .87121 .454 .86761 .44865 Metetra
.621 .725 .921 r
.86761 .44865 .87121 .454 .88027 .45303 .87657 .44659 Metetra
.69 .713 .866 r
.87657 .44659 .88027 .45303 .88915 .45016 .88537 .44286 Metetra
.019 0 0 r
.25711 .55325 .26216 .55178 .26905 .55056 .264 .55224 Metetra
.43 0 0 r
.264 .55224 .26905 .55056 .27581 .55136 .27073 .55366 Metetra
.631 .145 .081 r
.27073 .55366 .27581 .55136 .28244 .5543 .27731 .55753 Metetra
.715 .284 .224 r
.27731 .55753 .28244 .5543 .28896 .55952 .28377 .56384 Metetra
.75 .355 .303 r
.28377 .56384 .28896 .55952 .29536 .56717 .29012 .57244 Metetra
.766 .391 .345 r
.29012 .57244 .29536 .56717 .30166 .57724 .29641 .5829 Metetra
.774 .406 .359 r
.29641 .5829 .30166 .57724 .3079 .58937 .3027 .59437 Metetra
.777 .4 .343 r
.3027 .59437 .3079 .58937 .31415 .60266 .30909 .6055 Metetra
.772 .356 .261 r
.30909 .6055 .31415 .60266 .32052 .61542 .31568 .61459 Metetra
.659 .108 0 r
.31568 .61459 .32052 .61542 .32712 .62536 .32256 .62 Metetra
.449 .621 .925 r
.32256 .62 .32712 .62536 .33408 .63021 .32975 .62076 Metetra
.677 .605 .768 r
.32975 .62076 .33408 .63021 .34143 .62871 .33722 .61691 Metetra
.723 .597 .715 r
.33722 .61691 .34143 .62871 .3491 .62131 .3449 .60944 Metetra
.75 .61 .703 r
.3449 .60944 .3491 .62131 .35697 .60977 .35268 .59978 Metetra
.778 .643 .712 r
.35268 .59978 .35697 .60977 .36491 .59632 .3605 .58933 Metetra
.812 .7 .741 r
.3605 .58933 .36491 .59632 .37283 .58285 .36828 .57914 Metetra
.853 .792 .79 r
.36828 .57914 .37283 .58285 .38066 .57059 .37601 .56987 Metetra
.879 .921 .849 r
.37601 .56987 .38066 .57059 .3884 .56015 .38368 .56181 Metetra
.78 .998 .828 r
.38368 .56181 .3884 .56015 .39605 .55173 .3913 .55498 Metetra
.479 .851 .618 r
.3913 .55498 .39605 .55173 .40362 .5452 .39888 .54925 Metetra
.39888 .54925 .40362 .5452 .41114 .54032 .40643 .54443 Metetra
.40643 .54443 .41114 .54032 .41863 .53677 .41397 .54032 Metetra
.41397 .54032 .41863 .53677 .4261 .53422 .4215 .53681 Metetra
.4215 .53681 .4261 .53422 .43357 .53243 .42903 .53388 Metetra
.42903 .53388 .43357 .53243 .44105 .53122 .43656 .53159 Metetra
.232 .751 .797 r
.43656 .53159 .44105 .53122 .44854 .53054 .44409 .53006 Metetra
.2 .722 .859 r
.44409 .53006 .44854 .53054 .45605 .53045 .45163 .52944 Metetra
.088 .632 .843 r
.45163 .52944 .45605 .53045 .46357 .53102 .45918 .52984 Metetra
0 .491 .751 r
.45918 .52984 .46357 .53102 .47112 .53238 .46674 .53133 Metetra
.279 0 0 r
.46674 .53133 .47112 .53238 .4787 .53458 .47433 .53385 Metetra
.431 0 0 r
.47433 .53385 .4787 .53458 .48631 .5376 .48195 .53726 Metetra
.516 0 0 r
.48195 .53726 .48631 .5376 .49396 .54125 .48961 .54122 Metetra
.537 0 0 r
.48961 .54122 .49396 .54125 .50165 .54523 .49732 .54526 Metetra
.488 0 0 r
.49732 .54526 .50165 .54523 .5094 .54903 .50509 .54873 Metetra
.311 0 0 r
.50509 .54873 .5094 .54903 .5172 .552 .51291 .55093 Metetra
.12 .654 .862 r
.51291 .55093 .5172 .552 .52505 .55351 .52078 .55122 Metetra
.576 .847 .996 r
.52078 .55122 .52505 .55351 .53293 .55301 .52868 .54922 Metetra
.742 .811 .906 r
.52868 .54922 .53293 .55301 .54084 .55023 .53659 .54489 Metetra
.782 .754 .827 r
.53659 .54489 .54084 .55023 .54875 .54526 .54451 .53854 Metetra
.789 .715 .782 r
.54451 .53854 .54875 .54526 .55665 .53854 .55242 .53082 Metetra
.785 .691 .76 r
.55242 .53082 .55665 .53854 .56455 .53071 .56032 .52243 Metetra
.778 .678 .753 r
.56032 .52243 .56455 .53071 .57243 .52247 .56822 .51406 Metetra
.767 .671 .757 r
.56822 .51406 .57243 .52247 .58031 .51447 .57612 .50628 Metetra
.752 .67 .771 r
.57612 .50628 .58031 .51447 .58821 .50719 .58403 .4995 Metetra
.732 .674 .793 r
.58403 .4995 .58821 .50719 .59613 .50099 .59198 .49398 Metetra
.704 .68 .825 r
.59198 .49398 .59613 .50099 .60408 .49608 .59996 .48986 Metetra
.66 .688 .866 r
.59996 .48986 .60408 .49608 .61208 .49256 .60799 .48719 Metetra
.589 .693 .914 r
.60799 .48719 .61208 .49256 .62014 .49047 .61609 .48596 Metetra
.473 .682 .957 r
.61609 .48596 .62014 .49047 .62827 .48976 .62426 .48607 Metetra
.3 .636 .965 r
.62426 .48607 .62827 .48976 .63647 .49031 .6325 .48738 Metetra
.091 .547 .908 r
.6325 .48738 .63647 .49031 .64475 .49193 .64082 .48963 Metetra
0 .45 .811 r
.64082 .48963 .64475 .49193 .6531 .4943 .64921 .49245 Metetra
0 .404 .746 r
.64921 .49245 .6531 .4943 .66152 .49704 .65765 .49538 Metetra
0 .443 .762 r
.65765 .49538 .66152 .49704 .66998 .49962 .66613 .49786 Metetra
.051 .577 .866 r
.66613 .49786 .66998 .49962 .67846 .50149 .67461 .4993 Metetra
.334 .745 .979 r
.67461 .4993 .67846 .50149 .68693 .50207 .68306 .49917 Metetra
.586 .828 .99 r
.68306 .49917 .68693 .50207 .69534 .50095 .69145 .49714 Metetra
.72 .822 .929 r
.69145 .49714 .69534 .50095 .70369 .49792 .69976 .49316 Metetra
.775 .792 .867 r
.69976 .49316 .70369 .49792 .71195 .49308 .708 .48746 Metetra
.795 .764 .825 r
.708 .48746 .71195 .49308 .72015 .48676 .71618 .4805 Metetra
.799 .745 .802 r
.71618 .4805 .72015 .48676 .72829 .47947 .72431 .47284 Metetra
.796 .734 .794 r
.72431 .47284 .72829 .47947 .7364 .47178 .73244 .46505 Metetra
.788 .729 .798 r
.73244 .46505 .7364 .47178 .74452 .46422 .74059 .45764 Metetra
.774 .729 .811 r
.74059 .45764 .74452 .46422 .75268 .45723 .74879 .45097 Metetra
.754 .733 .834 r
.74879 .45097 .75268 .45723 .76091 .45113 .75707 .44533 Metetra
.724 .74 .864 r
.75707 .44533 .76091 .45113 .76923 .44614 .76544 .44086 Metetra
.68 .745 .9 r
.76544 .44086 .76923 .44614 .77765 .44239 .77393 .43766 Metetra
.613 .744 .939 r
.77393 .43766 .77765 .44239 .7862 .43994 .78254 .43575 Metetra
.519 .729 .969 r
.78254 .43575 .7862 .43994 .79488 .43877 .79128 .43507 Metetra
.396 .694 .98 r
.79128 .43507 .79488 .43877 .8037 .43879 .80016 .43552 Metetra
.262 .64 .964 r
.80016 .43552 .8037 .43879 .81265 .43985 .80916 .43691 Metetra
.151 .585 .932 r
.80916 .43691 .81265 .43985 .82172 .4417 .81827 .43896 Metetra
.097 .558 .91 r
.81827 .43896 .82172 .4417 .83089 .444 .82745 .44126 Metetra
.122 .576 .92 r
.82745 .44126 .83089 .444 .84011 .44632 .83667 .44337 Metetra
.232 .64 .958 r
.83667 .44337 .84011 .44632 .84934 .44818 .84588 .44475 Metetra
.4 .716 .987 r
.84588 .44475 .84934 .44818 .85852 .44909 .85501 .44494 Metetra
.56 .758 .97 r
.85501 .44494 .85852 .44909 .86761 .44865 .86403 .4436 Metetra
.666 .76 .92 r
.86403 .4436 .86761 .44865 .87657 .44659 .87291 .44058 Metetra
.723 .743 .868 r
.87291 .44058 .87657 .44659 .88537 .44286 .88163 .43599 Metetra
.356 0 .023 r
.25171 .55851 .25711 .55325 .264 .55224 .25862 .55762 Metetra
.538 .104 .165 r
.25862 .55762 .264 .55224 .27073 .55366 .26535 .55936 Metetra
.638 .23 .254 r
.26535 .55936 .27073 .55366 .27731 .55753 .27193 .56358 Metetra
.691 .302 .306 r
.27193 .56358 .27731 .55753 .28377 .56384 .2784 .56997 Metetra
.722 .342 .33 r
.2784 .56997 .28377 .56384 .29012 .57244 .2848 .578 Metetra
.741 .359 .329 r
.2848 .578 .29012 .57244 .29641 .5829 .29121 .58688 Metetra
.754 .351 .289 r
.29121 .58688 .29641 .5829 .3027 .59437 .2977 .59556 Metetra
.754 .29 .149 r
.2977 .59556 .3027 .59437 .30909 .6055 .30434 .60292 Metetra
.523 0 0 r
.30434 .60292 .30909 .6055 .31568 .61459 .31118 .60797 Metetra
.365 .524 .882 r
.31118 .60797 .31568 .61459 .32256 .62 .31824 .61011 Metetra
.587 .551 .782 r
.31824 .61011 .32256 .62 .32975 .62076 .32552 .60925 Metetra
.654 .564 .74 r
.32552 .60925 .32975 .62076 .33722 .61691 .33297 .60576 Metetra
.697 .591 .733 r
.33297 .60576 .33722 .61691 .3449 .60944 .34055 .60027 Metetra
.738 .638 .748 r
.34055 .60027 .3449 .60944 .35268 .59978 .3482 .59349 Metetra
.785 .71 .781 r
.3482 .59349 .35268 .59978 .3605 .58933 .35588 .58608 Metetra
.836 .815 .83 r
.35588 .58608 .3605 .58933 .36828 .57914 .36356 .57854 Metetra
.863 .934 .869 r
.36356 .57854 .36828 .57914 .37601 .56987 .37124 .57118 Metetra
.813 .998 .846 r
.37124 .57118 .37601 .56987 .38368 .56181 .3789 .56415 Metetra
.707 .977 .773 r
.3789 .56415 .38368 .56181 .3913 .55498 .38654 .55751 Metetra
.646 .953 .743 r
.38654 .55751 .3913 .55498 .39888 .54925 .39417 .55124 Metetra
.661 .967 .791 r
.39417 .55124 .39888 .54925 .40643 .54443 .40179 .54539 Metetra
.71 .986 .874 r
.40179 .54539 .40643 .54443 .41397 .54032 .4094 .54003 Metetra
.736 .966 .936 r
.4094 .54003 .41397 .54032 .4215 .53681 .41699 .53531 Metetra
.721 .915 .961 r
.41699 .53531 .4215 .53681 .42903 .53388 .42457 .53139 Metetra
.673 .855 .969 r
.42457 .53139 .42903 .53388 .43656 .53159 .43213 .52846 Metetra
.599 .801 .977 r
.43213 .52846 .43656 .53159 .44409 .53006 .43969 .52669 Metetra
.489 .746 .986 r
.43969 .52669 .44409 .53006 .45163 .52944 .44724 .52618 Metetra
.318 .67 .975 r
.44724 .52618 .45163 .52944 .45918 .52984 .45479 .52697 Metetra
.068 .538 .898 r
.45479 .52697 .45918 .52984 .46674 .53133 .46236 .52904 Metetra
0 .352 .722 r
.46236 .52904 .46674 .53133 .47433 .53385 .46994 .53221 Metetra
.409 0 0 r
.46994 .53221 .47433 .53385 .48195 .53726 .47757 .5362 Metetra
.501 0 0 r
.47757 .5362 .48195 .53726 .48961 .54122 .48524 .54056 Metetra
.5 0 0 r
.48524 .54056 .48961 .54122 .49732 .54526 .49296 .54464 Metetra
.393 0 0 r
.49296 .54464 .49732 .54526 .50509 .54873 .50075 .54773 Metetra
0 .497 .74 r
.50075 .54773 .50509 .54873 .51291 .55093 .50859 .5491 Metetra
.415 .803 .989 r
.50859 .5491 .51291 .55093 .52078 .55122 .51647 .54819 Metetra
.698 .841 .952 r
.51647 .54819 .52078 .55122 .52868 .54922 .52439 .54479 Metetra
.779 .788 .86 r
.52439 .54479 .52868 .54922 .53659 .54489 .53232 .53911 Metetra
.798 .744 .802 r
.53232 .53911 .53659 .54489 .54451 .53854 .54025 .53168 Metetra
.799 .714 .771 r
.54025 .53168 .54451 .53854 .55242 .53082 .54817 .52322 Metetra
.792 .696 .759 r
.54817 .52322 .55242 .53082 .56032 .52243 .55609 .51449 Metetra
.782 .687 .758 r
.55609 .51449 .56032 .52243 .56822 .51406 .564 .50615 Metetra
.768 .682 .768 r
.564 .50615 .56822 .51406 .57612 .50628 .57192 .49867 Metetra
.75 .682 .786 r
.57192 .49867 .57612 .50628 .58403 .4995 .57985 .49238 Metetra
.724 .686 .813 r
.57985 .49238 .58403 .4995 .59198 .49398 .58782 .48747 Metetra
.686 .69 .848 r
.58782 .48747 .59198 .49398 .59996 .48986 .59583 .48405 Metetra
.628 .692 .89 r
.59583 .48405 .59996 .48986 .60799 .48719 .6039 .48211 Metetra
.537 .684 .934 r
.6039 .48211 .60799 .48719 .61609 .48596 .61203 .4816 Metetra
.399 .654 .961 r
.61203 .4816 .61609 .48596 .62426 .48607 .62023 .48241 Metetra
.217 .589 .946 r
.62023 .48241 .62426 .48607 .6325 .48738 .6285 .48434 Metetra
.032 .5 .882 r
.6285 .48434 .6325 .48738 .64082 .48963 .63685 .48707 Metetra
0 .431 .81 r
.63685 .48707 .64082 .48963 .64921 .49245 .64527 .49021 Metetra
0 .426 .789 r
.64527 .49021 .64921 .49245 .65765 .49538 .65373 .49321 Metetra
0 .507 .843 r
.65373 .49321 .65765 .49538 .66613 .49786 .66222 .49549 Metetra
.204 .656 .946 r
.66222 .49549 .66613 .49786 .67461 .4993 .67069 .49645 Metetra
.472 .782 .998 r
.67069 .49645 .67461 .4993 .68306 .49917 .67913 .49562 Metetra
.658 .818 .96 r
.67913 .49562 .68306 .49917 .69145 .49714 .6875 .49277 Metetra
.75 .803 .895 r
.6875 .49277 .69145 .49714 .69976 .49316 .6958 .48797 Metetra
.788 .778 .844 r
.6958 .48797 .69976 .49316 .708 .48746 .70402 .48157 Metetra
.801 .757 .813 r
.70402 .48157 .708 .48746 .71618 .4805 .71219 .47411 Metetra
.802 .743 .797 r
.71219 .47411 .71618 .4805 .72431 .47284 .72033 .4662 Metetra
.797 .735 .795 r
.72033 .4662 .72431 .47284 .73244 .46505 .72847 .45839 Metetra
.785 .731 .802 r
.72847 .45839 .73244 .46505 .74059 .45764 .73665 .45115 Metetra
.768 .731 .819 r
.73665 .45115 .74059 .45764 .74879 .45097 .74489 .4448 Metetra
.743 .734 .843 r
.74489 .4448 .74879 .45097 .75707 .44533 .75321 .43957 Metetra
.707 .736 .874 r
.75321 .43957 .75707 .44533 .76544 .44086 .76164 .43559 Metetra
.656 .737 .909 r
.76164 .43559 .76544 .44086 .77393 .43766 .77019 .43289 Metetra
.583 .73 .944 r
.77019 .43289 .77393 .43766 .78254 .43575 .77885 .43147 Metetra
.485 .709 .969 r
.77885 .43147 .78254 .43575 .79128 .43507 .78765 .43124 Metetra
.366 .671 .974 r
.78765 .43124 .79128 .43507 .80016 .43552 .79658 .43207 Metetra
.248 .621 .958 r
.79658 .43207 .80016 .43552 .80916 .43691 .80562 .43372 Metetra
.163 .58 .935 r
.80562 .43372 .80916 .43691 .81827 .43896 .81476 .43589 Metetra
.138 .57 .926 r
.81476 .43589 .81827 .43896 .82745 .44126 .82396 .43816 Metetra
.188 .603 .944 r
.82396 .43816 .82745 .44126 .83667 .44337 .83318 .44005 Metetra
.311 .669 .975 r
.83318 .44005 .83667 .44337 .84588 .44475 .84237 .44102 Metetra
.469 .736 .986 r
.84237 .44102 .84588 .44475 .85501 .44494 .85147 .44064 Metetra
.607 .772 .959 r
.85147 .44064 .85501 .44494 .86403 .4436 .86044 .4386 Metetra
.698 .776 .912 r
.86044 .4386 .86403 .4436 .87291 .44058 .86926 .43485 Metetra
.748 .764 .866 r
.86926 .43485 .87291 .44058 .88163 .43599 .87793 .42957 Metetra
.437 .059 .222 r
.24593 .56776 .25171 .55851 .25862 .55762 .25288 .56672 Metetra
.532 .157 .275 r
.25288 .56672 .25862 .55762 .26535 .55936 .25969 .56794 Metetra
.595 .22 .301 r
.25969 .56794 .26535 .55936 .27193 .56358 .26638 .57108 Metetra
.637 .255 .303 r
.26638 .57108 .27193 .56358 .2784 .56997 .273 .57563 Metetra
.666 .262 .27 r
.273 .57563 .2784 .56997 .2848 .578 .27962 .58091 Metetra
.683 .229 .167 r
.27962 .58091 .2848 .578 .29121 .58688 .28629 .58623 Metetra
.626 .066 0 r
.28629 .58623 .29121 .58688 .2977 .59556 .29305 .59096 Metetra
0 .376 .834 r
.29305 .59096 .2977 .59556 .30434 .60292 .29992 .59468 Metetra
.39 .482 .834 r
.29992 .59468 .30434 .60292 .31118 .60797 .30692 .59717 Metetra
.506 .491 .774 r
.30692 .59717 .31118 .60797 .31824 .61011 .31403 .59837 Metetra
.56 .507 .753 r
.31403 .59837 .31824 .61011 .32552 .60925 .32126 .59828 Metetra
.601 .542 .76 r
.32126 .59828 .32552 .60925 .33297 .60576 .32859 .59691 Metetra
.648 .603 .79 r
.32859 .59691 .33297 .60576 .34055 .60027 .33601 .59428 Metetra
.708 .7 .84 r
.33601 .59428 .34055 .60027 .3482 .59349 .34352 .59044 Metetra
.775 .83 .895 r
.34352 .59044 .3482 .59349 .35588 .58608 .3511 .58549 Metetra
.815 .948 .909 r
.3511 .58549 .35588 .58608 .36356 .57854 .35873 .57955 Metetra
.811 .995 .865 r
.35873 .57955 .36356 .57854 .37124 .57118 .36641 .57282 Metetra
.811 1 .829 r
.36641 .57282 .37124 .57118 .3789 .56415 .37411 .56551 Metetra
.838 .997 .836 r
.37411 .56551 .3789 .56415 .38654 .55751 .38183 .55789 Metetra
.862 .974 .859 r
.38183 .55789 .38654 .55751 .39417 .55124 .38954 .55029 Metetra
.859 .924 .871 r
.38954 .55029 .39417 .55124 .40179 .54539 .39724 .54303 Metetra
.83 .865 .871 r
.39724 .54303 .40179 .54539 .4094 .54003 .40491 .53646 Metetra
.789 .811 .87 r
.40491 .53646 .4094 .54003 .41699 .53531 .41255 .53086 Metetra
.742 .769 .875 r
.41255 .53086 .41699 .53531 .42457 .53139 .42016 .52647 Metetra
.685 .737 .89 r
.42016 .52647 .42457 .53139 .43213 .52846 .42774 .52346 Metetra
.609 .709 .915 r
.42774 .52346 .43213 .52846 .43969 .52669 .4353 .52193 Metetra
.495 .674 .944 r
.4353 .52193 .43969 .52669 .44724 .52618 .44284 .52192 Metetra
.311 .61 .953 r
.44284 .52192 .44724 .52618 .45479 .52697 .45039 .52338 Metetra
.042 .481 .884 r
.45039 .52338 .45479 .52697 .46236 .52904 .45795 .52619 Metetra
0 .301 .713 r
.45795 .52619 .46236 .52904 .46994 .53221 .46553 .53007 Metetra
.425 0 0 r
.46553 .53007 .46994 .53221 .47757 .5362 .47316 .53465 Metetra
.491 0 0 r
.47316 .53465 .47757 .5362 .48524 .54056 .48084 .53933 Metetra
.45 0 0 r
.48084 .53933 .48524 .54056 .49296 .54464 .48857 .54339 Metetra
.258 0 0 r
.48857 .54339 .49296 .54464 .50075 .54773 .49638 .54603 Metetra
.17 .667 .916 r
.49638 .54603 .50075 .54773 .50859 .5491 .50424 .54656 Metetra
.588 .839 .992 r
.50424 .54656 .50859 .5491 .51647 .54819 .51215 .54453 Metetra
.752 .82 .905 r
.51215 .54453 .51647 .54819 .52439 .54479 .52009 .53993 Metetra
.799 .775 .831 r
.52009 .53993 .52439 .54479 .53232 .53911 .52803 .53316 Metetra
.81 .741 .788 r
.52803 .53316 .53232 .53911 .54025 .53168 .53598 .5249 Metetra
.808 .719 .767 r
.53598 .5249 .54025 .53168 .54817 .52322 .54391 .51595 Metetra
.8 .706 .762 r
.54391 .51595 .54817 .52322 .55609 .51449 .55184 .50706 Metetra
.788 .699 .767 r
.55184 .50706 .55609 .51449 .564 .50615 .55977 .49881 Metetra
.771 .697 .781 r
.55977 .49881 .564 .50615 .57192 .49867 .56771 .49164 Metetra
.748 .697 .803 r
.56771 .49164 .57192 .49867 .57985 .49238 .57567 .48579 Metetra
.715 .698 .833 r
.57567 .48579 .57985 .49238 .58782 .48747 .58366 .48142 Metetra
.667 .699 .87 r
.58366 .48142 .58782 .48747 .59583 .48405 .59169 .47857 Metetra
.594 .693 .911 r
.59169 .47857 .59583 .48405 .6039 .48211 .59979 .47723 Metetra
.486 .671 .946 r
.59979 .47723 .6039 .48211 .61203 .4816 .60794 .47731 Metetra
.335 .624 .957 r
.60794 .47731 .61203 .4816 .62023 .48241 .61617 .47868 Metetra
.16 .549 .928 r
.61617 .47868 .62023 .48241 .6285 .48434 .62448 .48108 Metetra
.007 .47 .869 r
.62448 .48108 .6285 .48434 .63685 .48707 .63285 .48418 Metetra
0 .429 .825 r
.63285 .48418 .63685 .48707 .64527 .49021 .64129 .48752 Metetra
0 .456 .835 r
.64129 .48752 .64527 .49021 .65373 .49321 .64977 .49052 Metetra
.088 .56 .905 r
.64977 .49052 .65373 .49321 .66222 .49549 .65826 .49256 Metetra
.325 .699 .981 r
.65826 .49256 .66222 .49549 .67069 .49645 .66674 .49306 Metetra
.555 .789 .986 r
.66674 .49306 .67069 .49645 .67913 .49562 .67516 .4916 Metetra
.698 .807 .933 r
.67516 .4916 .67913 .49562 .6875 .49277 .68352 .48805 Metetra
.768 .793 .874 r
.68352 .48805 .6875 .49277 .6958 .48797 .6918 .48259 Metetra
.798 .774 .832 r
.6918 .48259 .6958 .48797 .70402 .48157 .70001 .47565 Metetra
.808 .759 .807 r
.70001 .47565 .70402 .48157 .71219 .47411 .70818 .46784 Metetra
.807 .748 .797 r
.70818 .46784 .71219 .47411 .72033 .4662 .71633 .45976 Metetra
.8 .742 .799 r
.71633 .45976 .72033 .4662 .72847 .45839 .7245 .45197 Metetra
.786 .739 .81 r
.7245 .45197 .72847 .45839 .73665 .45115 .73271 .44488 Metetra
.765 .738 .828 r
.73271 .44488 .73665 .45115 .74489 .4448 .74098 .4388 Metetra
.735 .738 .854 r
.74098 .4388 .74489 .4448 .75321 .43957 .74935 .43391 Metetra
.693 .736 .884 r
.74935 .43391 .75321 .43957 .76164 .43559 .75782 .43033 Metetra
.635 .73 .917 r
.75782 .43033 .76164 .43559 .77019 .43289 .76642 .42805 Metetra
.557 .716 .947 r
.76642 .42805 .77019 .43289 .77885 .43147 .77514 .42705 Metetra
.457 .688 .966 r
.77514 .42705 .77885 .43147 .78765 .43124 .78398 .42721 Metetra
.346 .648 .967 r
.78398 .42721 .78765 .43124 .79658 .43207 .79296 .42837 Metetra
.244 .605 .953 r
.79296 .42837 .79658 .43207 .80562 .43372 .80204 .43025 Metetra
.181 .577 .938 r
.80204 .43025 .80562 .43372 .81476 .43589 .8112 .43251 Metetra
.179 .581 .938 r
.8112 .43251 .81476 .43589 .82396 .43816 .82042 .43472 Metetra
.248 .623 .958 r
.82042 .43472 .82396 .43816 .83318 .44005 .82964 .43637 Metetra
.375 .688 .98 r
.82964 .43637 .83318 .44005 .84237 .44102 .83881 .43696 Metetra
.521 .745 .977 r
.83881 .43696 .84237 .44102 .85147 .44064 .84788 .43609 Metetra
.64 .775 .945 r
.84788 .43609 .85147 .44064 .86044 .4386 .85681 .43351 Metetra
.719 .781 .901 r
.85681 .43351 .86044 .4386 .86926 .43485 .8656 .42922 Metetra
.764 .774 .862 r
.8656 .42922 .86926 .43485 .87793 .42957 .87425 .42346 Metetra
.437 .086 .27 r
.23988 .57942 .24593 .56776 .25288 .56672 .24693 .57779 Metetra
.475 .118 .28 r
.24693 .57779 .25288 .56672 .25969 .56794 .25391 .57725 Metetra
.495 .119 .255 r
.25391 .57725 .25969 .56794 .26638 .57108 .26085 .57753 Metetra
.493 .071 .167 r
.26085 .57753 .26638 .57108 .273 .57563 .26778 .5783 Metetra
.423 0 0 r
.26778 .5783 .273 .57563 .27962 .58091 .27473 .5793 Metetra
.021 .565 .838 r
.27473 .5793 .27962 .58091 .28629 .58623 .2817 .58042 Metetra
.41 .581 .91 r
.2817 .58042 .28629 .58623 .29305 .59096 .2887 .5817 Metetra
.473 .502 .807 r
.2887 .5817 .29305 .59096 .29992 .59468 .29571 .58324 Metetra
.481 .465 .762 r
.29571 .58324 .29992 .59468 .30692 .59717 .30274 .58509 Metetra
.478 .453 .752 r
.30274 .58509 .30692 .59717 .31403 .59837 .30979 .58715 Metetra
.475 .465 .767 r
.30979 .58715 .31403 .59837 .32126 .59828 .31689 .5891 Metetra
.481 .51 .811 r
.31689 .5891 .32126 .59828 .32859 .59691 .32405 .59048 Metetra
.512 .609 .886 r
.32405 .59048 .32859 .59691 .33601 .59428 .33132 .59073 Metetra
.581 .77 .969 r
.33132 .59073 .33601 .59428 .34352 .59044 .33871 .58933 Metetra
.67 .921 .974 r
.33871 .58933 .34352 .59044 .3511 .58549 .34623 .58596 Metetra
.753 .984 .906 r
.34623 .58596 .3511 .58549 .35873 .57955 .35386 .58056 Metetra
.832 .993 .858 r
.35386 .58056 .35873 .57955 .36641 .57282 .36159 .57339 Metetra
.884 .967 .839 r
.36159 .57339 .36641 .57282 .37411 .56551 .36937 .56494 Metetra
.897 .918 .828 r
.36937 .56494 .37411 .56551 .38183 .55789 .37718 .55587 Metetra
.879 .861 .818 r
.37718 .55587 .38183 .55789 .38954 .55029 .38498 .54682 Metetra
.848 .809 .812 r
.38498 .54682 .38954 .55029 .39724 .54303 .39274 .53839 Metetra
.812 .768 .812 r
.39274 .53839 .39724 .54303 .40491 .53646 .40046 .53102 Metetra
.772 .738 .821 r
.40046 .53102 .40491 .53646 .41255 .53086 .40813 .52502 Metetra
.727 .714 .838 r
.40813 .52502 .41255 .53086 .42016 .52647 .41575 .52059 Metetra
.669 .695 .865 r
.41575 .52059 .42016 .52647 .42774 .52346 .42334 .51782 Metetra
.585 .673 .9 r
.42334 .51782 .42774 .52346 .4353 .52193 .43089 .51675 Metetra
.454 .636 .933 r
.43089 .51675 .4353 .52193 .44284 .52192 .43843 .51735 Metetra
.246 .556 .933 r
.43843 .51735 .44284 .52192 .45039 .52338 .44597 .51949 Metetra
0 .413 .846 r
.44597 .51949 .45039 .52338 .45795 .52619 .45352 .52298 Metetra
0 .247 .683 r
.45352 .52298 .45795 .52619 .46553 .53007 .4611 .5275 Metetra
.432 0 0 r
.4611 .5275 .46553 .53007 .47316 .53465 .46873 .53254 Metetra
.462 0 0 r
.46873 .53254 .47316 .53465 .48084 .53933 .47641 .53745 Metetra
.369 0 0 r
.47641 .53745 .48084 .53933 .48857 .54339 .48416 .54141 Metetra
0 .47 .795 r
.48416 .54141 .48857 .54339 .49638 .54603 .49199 .54361 Metetra
.375 .753 .99 r
.49199 .54361 .49638 .54603 .50424 .54656 .49987 .54338 Metetra
.672 .829 .959 r
.49987 .54338 .50424 .54656 .51215 .54453 .5078 .54042 Metetra
.779 .803 .872 r
.5078 .54042 .51215 .54453 .52009 .53993 .51576 .53487 Metetra
.812 .77 .813 r
.51576 .53487 .52009 .53993 .52803 .53316 .52373 .52728 Metetra
.82 .746 .782 r
.52373 .52728 .52803 .53316 .53598 .5249 .53169 .51845 Metetra
.817 .73 .768 r
.53169 .51845 .53598 .5249 .54391 .51595 .53964 .50919 Metetra
.809 .721 .768 r
.53964 .50919 .54391 .51595 .55184 .50706 .54759 .50023 Metetra
.795 .716 .778 r
.54759 .50023 .55184 .50706 .55977 .49881 .55553 .49211 Metetra
.775 .715 .795 r
.55553 .49211 .55977 .49881 .56771 .49164 .56349 .4852 Metetra
.747 .714 .821 r
.56349 .4852 .56771 .49164 .57567 .48579 .57147 .47971 Metetra
.707 .713 .853 r
.57147 .47971 .57567 .48579 .58366 .48142 .57948 .47575 Metetra
.648 .707 .89 r
.57948 .47575 .58366 .48142 .59169 .47857 .58754 .47335 Metetra
.563 .691 .927 r
.58754 .47335 .59169 .47857 .59979 .47723 .59566 .47246 Metetra
.442 .657 .952 r
.59566 .47246 .59979 .47723 .60794 .47731 .60384 .47299 Metetra
.289 .597 .949 r
.60384 .47299 .60794 .47731 .61617 .47868 .61209 .47477 Metetra
.129 .521 .915 r
.61209 .47477 .61617 .47868 .62448 .48108 .62042 .47753 Metetra
.008 .456 .868 r
.62042 .47753 .62448 .48108 .63285 .48418 .62881 .48089 Metetra
0 .437 .847 r
.62881 .48089 .63285 .48418 .64129 .48752 .63727 .48435 Metetra
.019 .485 .875 r
.63727 .48435 .64129 .48752 .64977 .49052 .64576 .4873 Metetra
.182 .596 .942 r
.64576 .4873 .64977 .49052 .65826 .49256 .65426 .48912 Metetra
.409 .717 .987 r
.65426 .48912 .65826 .49256 .66674 .49306 .66273 .48922 Metetra
.604 .785 .967 r
.66273 .48922 .66674 .49306 .67516 .4916 .67116 .48726 Metetra
.722 .799 .912 r
.67116 .48726 .67516 .4916 .68352 .48805 .67951 .48316 Metetra
.78 .79 .861 r
.67951 .48316 .68352 .48805 .6918 .48259 .68779 .4772 Metetra
.806 .777 .826 r
.68779 .4772 .6918 .48259 .70001 .47565 .696 .46988 Metetra
.815 .766 .807 r
.696 .46988 .70001 .47565 .70818 .46784 .70418 .46182 Metetra
.814 .758 .801 r
.70418 .46182 .70818 .46784 .71633 .45976 .71234 .45363 Metetra
.804 .753 .806 r
.71234 .45363 .71633 .45976 .7245 .45197 .72053 .44586 Metetra
.788 .751 .819 r
.72053 .44586 .7245 .45197 .73271 .44488 .72877 .4389 Metetra
.763 .748 .839 r
.72877 .4389 .73271 .44488 .74098 .4388 .73708 .43302 Metetra
.729 .745 .865 r
.73708 .43302 .74098 .4388 .74935 .43391 .74548 .4284 Metetra
.681 .738 .894 r
.74548 .4284 .74935 .43391 .75782 .43033 .75399 .4251 Metetra
.617 .726 .923 r
.75399 .4251 .75782 .43033 .76642 .42805 .76263 .42315 Metetra
.535 .704 .948 r
.76263 .42315 .76642 .42805 .77514 .42705 .77139 .42246 Metetra
.438 .67 .961 r
.77139 .42246 .77514 .42705 .78398 .42721 .78028 .42293 Metetra
.336 .63 .96 r
.78028 .42293 .78398 .42721 .79296 .42837 .78929 .42435 Metetra
.25 .592 .949 r
.78929 .42435 .79296 .42837 .80204 .43025 .7984 .42642 Metetra
.205 .574 .94 r
.7984 .42642 .80204 .43025 .8112 .43251 .80759 .42876 Metetra
.219 .588 .946 r
.80759 .42876 .8112 .43251 .82042 .43472 .81682 .43091 Metetra
.297 .635 .965 r
.81682 .43091 .82042 .43472 .82964 .43637 .82604 .43236 Metetra
.423 .698 .978 r
.82604 .43236 .82964 .43637 .83881 .43696 .8352 .43263 Metetra
.557 .75 .967 r
.8352 .43263 .83881 .43696 .84788 .43609 .84425 .43134 Metetra
.664 .776 .933 r
.84425 .43134 .84788 .43609 .85681 .43351 .85317 .42831 Metetra
.733 .783 .892 r
.85317 .42831 .85681 .43351 .8656 .42922 .86193 .42362 Metetra
.774 .78 .858 r
.86193 .42362 .8656 .42922 .87425 .42346 .87057 .41753 Metetra
.374 .008 .208 r
.23386 .58989 .23988 .57942 .24693 .57779 .24102 .58734 Metetra
.318 0 .153 r
.24102 .58734 .24693 .57779 .25391 .57725 .24825 .5842 Metetra
.18 0 0 r
.24825 .5842 .25391 .57725 .26085 .57753 .25552 .58069 Metetra
.25552 .58069 .26085 .57753 .26778 .5783 .26281 .57716 Metetra
.66 .912 .978 r
.26281 .57716 .26778 .5783 .27473 .5793 .27008 .57408 Metetra
.648 .706 .89 r
.27008 .57408 .27473 .5793 .2817 .58042 .27729 .57194 Metetra
.583 .578 .813 r
.27729 .57194 .2817 .58042 .2887 .5817 .28443 .57114 Metetra
.522 .503 .777 r
.28443 .57114 .2887 .5817 .29571 .58324 .29149 .57191 Metetra
.457 .452 .765 r
.29149 .57191 .29571 .58324 .30274 .58509 .29847 .57421 Metetra
.383 .416 .771 r
.29847 .57421 .30274 .58509 .30979 .58715 .30542 .57774 Metetra
.297 .398 .796 r
.30542 .57774 .30979 .58715 .31689 .5891 .31238 .58187 Metetra
.213 .416 .844 r
.31238 .58187 .31689 .5891 .32405 .59048 .3194 .58572 Metetra
.184 .513 .914 r
.3194 .58572 .32405 .59048 .33132 .59073 .32654 .58825 Metetra
.31 .712 .978 r
.32654 .58825 .33132 .59073 .33871 .58933 .33385 .58852 Metetra
.573 .907 .977 r
.33385 .58852 .33871 .58933 .34623 .58596 .34135 .5859 Metetra
.786 .971 .916 r
.34135 .5859 .34623 .58596 .35386 .58056 .34902 .58031 Metetra
.878 .941 .853 r
.34902 .58031 .35386 .58056 .36159 .57339 .35682 .57223 Metetra
.898 .886 .812 r
.35682 .57223 .36159 .57339 .36937 .56494 .36469 .56251 Metetra
.887 .835 .789 r
.36469 .56251 .36937 .56494 .37718 .55587 .37258 .55215 Metetra
.864 .794 .78 r
.37258 .55215 .37718 .55587 .38498 .54682 .38045 .54204 Metetra
.836 .763 .782 r
.38045 .54204 .38498 .54682 .39274 .53839 .38826 .53287 Metetra
.805 .74 .792 r
.38826 .53287 .39274 .53839 .40046 .53102 .39601 .52511 Metetra
.768 .723 .811 r
.39601 .52511 .40046 .53102 .40813 .52502 .4037 .51902 Metetra
.721 .708 .838 r
.4037 .51902 .40813 .52502 .41575 .52059 .41133 .51473 Metetra
.655 .692 .873 r
.41133 .51473 .41575 .52059 .42334 .51782 .41891 .51229 Metetra
.556 .667 .911 r
.41891 .51229 .42334 .51782 .43089 .51675 .42647 .51165 Metetra
.401 .614 .937 r
.42647 .51165 .43089 .51675 .43843 .51735 .434 .51274 Metetra
.173 .512 .914 r
.434 .51274 .43843 .51735 .44597 .51949 .44153 .51541 Metetra
0 .361 .813 r
.44153 .51541 .44597 .51949 .45352 .52298 .44908 .51942 Metetra
0 .217 .673 r
.44908 .51942 .45352 .52298 .4611 .5275 .45666 .52438 Metetra
.409 0 0 r
.45666 .52438 .4611 .5275 .46873 .53254 .46428 .52975 Metetra
.401 0 0 r
.46428 .52975 .46873 .53254 .47641 .53745 .47197 .53478 Metetra
0 .3 .699 r
.47197 .53478 .47641 .53745 .48416 .54141 .47974 .53863 Metetra
.095 .565 .908 r
.47974 .53863 .48416 .54141 .49199 .54361 .48757 .54046 Metetra
.494 .77 .993 r
.48757 .54046 .49199 .54361 .49987 .54338 .49548 .53967 Metetra
.71 .811 .928 r
.49548 .53967 .49987 .54338 .5078 .54042 .50343 .53603 Metetra
.793 .794 .853 r
.50343 .53603 .5078 .54042 .51576 .53487 .51141 .52983 Metetra
.822 .772 .805 r
.51141 .52983 .51576 .53487 .52373 .52728 .5194 .5217 Metetra
.83 .756 .781 r
.5194 .5217 .52373 .52728 .53169 .51845 .52738 .5125 Metetra
.828 .746 .773 r
.52738 .5125 .53169 .51845 .53964 .50919 .53535 .50306 Metetra
.819 .74 .777 r
.53535 .50306 .53964 .50919 .54759 .50023 .54332 .49408 Metetra
.804 .737 .79 r
.54332 .49408 .54759 .50023 .55553 .49211 .55129 .48607 Metetra
.781 .736 .811 r
.55129 .48607 .55553 .49211 .56349 .4852 .55926 .47935 Metetra
.748 .734 .839 r
.55926 .47935 .56349 .4852 .57147 .47971 .56726 .47411 Metetra
.701 .729 .872 r
.56726 .47411 .57147 .47971 .57948 .47575 .57529 .47043 Metetra
.633 .717 .907 r
.57529 .47043 .57948 .47575 .58754 .47335 .58337 .46833 Metetra
.537 .691 .938 r
.58337 .46833 .58754 .47335 .59566 .47246 .5915 .46774 Metetra
.411 .644 .953 r
.5915 .46774 .59566 .47246 .60384 .47299 .5997 .46857 Metetra
.263 .578 .942 r
.5997 .46857 .60384 .47299 .61209 .47477 .60798 .47062 Metetra
.123 .505 .908 r
.60798 .47062 .61209 .47477 .62042 .47753 .61632 .4736 Metetra
.03 .453 .874 r
.61632 .4736 .62042 .47753 .62881 .48089 .62473 .47712 Metetra
.012 .449 .868 r
.62473 .47712 .62881 .48089 .63727 .48435 .6332 .48065 Metetra
.088 .507 .903 r
.6332 .48065 .63727 .48435 .64576 .4873 .6417 .48356 Metetra
.256 .613 .956 r
.6417 .48356 .64576 .4873 .65426 .48912 .65021 .48519 Metetra
.463 .719 .979 r
.65021 .48519 .65426 .48912 .66273 .48922 .65869 .48501 Metetra
.632 .777 .951 r
.65869 .48501 .66273 .48922 .67116 .48726 .66712 .48269 Metetra
.735 .794 .899 r
.66712 .48269 .67116 .48726 .67951 .48316 .67547 .47823 Metetra
.788 .791 .854 r
.67547 .47823 .67951 .48316 .68779 .4772 .68376 .47193 Metetra
.814 .783 .824 r
.68376 .47193 .68779 .4772 .696 .46988 .69198 .46435 Metetra
.822 .776 .809 r
.69198 .46435 .696 .46988 .70418 .46182 .70017 .45613 Metetra
.821 .771 .806 r
.70017 .45613 .70418 .46182 .71234 .45363 .70835 .44788 Metetra
.81 .768 .813 r
.70835 .44788 .71234 .45363 .72053 .44586 .71656 .44012 Metetra
.792 .765 .828 r
.71656 .44012 .72053 .44586 .72877 .4389 .72483 .43324 Metetra
.764 .761 .85 r
.72483 .43324 .72877 .4389 .73708 .43302 .73317 .4275 Metetra
.725 .755 .876 r
.73317 .4275 .73708 .43302 .74548 .4284 .7416 .42305 Metetra
.673 .743 .903 r
.7416 .42305 .74548 .4284 .75399 .4251 .75014 .41994 Metetra
.605 .724 .929 r
.75014 .41994 .75399 .4251 .76263 .42315 .75881 .41819 Metetra
.521 .695 .948 r
.75881 .41819 .76263 .42315 .77139 .42246 .76761 .41772 Metetra
.426 .657 .956 r
.76761 .41772 .77139 .42246 .78028 .42293 .77653 .41839 Metetra
.334 .615 .953 r
.77653 .41839 .78028 .42293 .78929 .42435 .78557 .41998 Metetra
.263 .582 .944 r
.78557 .41998 .78929 .42435 .7984 .42642 .79471 .42218 Metetra
.233 .57 .94 r
.79471 .42218 .7984 .42642 .80759 .42876 .80393 .42459 Metetra
.257 .589 .948 r
.80393 .42459 .80759 .42876 .81682 .43091 .81317 .42671 Metetra
.338 .639 .964 r
.81317 .42671 .81682 .43091 .82604 .43236 .8224 .42803 Metetra
.458 .7 .972 r
.8224 .42803 .82604 .43236 .8352 .43263 .83156 .42806 Metetra
.582 .75 .958 r
.83156 .42806 .8352 .43263 .84425 .43134 .8406 .42646 Metetra
.679 .778 .925 r
.8406 .42646 .84425 .43134 .85317 .42831 .8495 .42309 Metetra
.744 .786 .887 r
.8495 .42309 .85317 .42831 .86193 .42362 .85825 .41809 Metetra
.781 .786 .857 r
.85825 .41809 .86193 .42362 .87057 .41753 .86689 .41177 Metetra
.024 0 0 r
.22827 .59467 .23386 .58989 .24102 .58734 .23552 .59137 Metetra
.23552 .59137 .24102 .58734 .24825 .5842 .24295 .58621 Metetra
.75 .994 .836 r
.24295 .58621 .24825 .5842 .25552 .58069 .25046 .57996 Metetra
.835 .924 .892 r
.25046 .57996 .25552 .58069 .26281 .57716 .25799 .57362 Metetra
.785 .8 .864 r
.25799 .57362 .26281 .57716 .27008 .57408 .26545 .56818 Metetra
.708 .699 .84 r
.26545 .56818 .27008 .57408 .27729 .57194 .2728 .56438 Metetra
.619 .619 .828 r
.2728 .56438 .27729 .57194 .28443 .57114 .28 .56273 Metetra
.51 .544 .827 r
.28 .56273 .28443 .57114 .29149 .57191 .28706 .56338 Metetra
.365 .461 .826 r
.28706 .56338 .29149 .57191 .29847 .57421 .29401 .56622 Metetra
.177 .366 .813 r
.29401 .56622 .29847 .57421 .30542 .57774 .30088 .57078 Metetra
0 .273 .777 r
.30088 .57078 .30542 .57774 .31238 .58187 .30775 .57627 Metetra
0 .241 .749 r
.30775 .57627 .31238 .58187 .3194 .58572 .31468 .58157 Metetra
0 .352 .804 r
.31468 .58157 .3194 .58572 .32654 .58825 .32175 .58536 Metetra
.214 .637 .953 r
.32175 .58536 .32654 .58825 .33385 .58852 .32902 .58645 Metetra
.619 .864 .989 r
.32902 .58645 .33385 .58852 .34135 .5859 .33653 .58405 Metetra
.814 .89 .898 r
.33653 .58405 .34135 .5859 .34902 .58031 .34424 .57814 Metetra
.871 .855 .823 r
.34424 .57814 .34902 .58031 .35682 .57223 .3521 .56937 Metetra
.881 .82 .783 r
.3521 .56937 .35682 .57223 .36469 .56251 .36004 .55885 Metetra
.874 .793 .767 r
.36004 .55885 .36469 .56251 .37258 .55215 .36799 .54776 Metetra
.859 .773 .766 r
.36799 .54776 .37258 .55215 .38045 .54204 .3759 .53711 Metetra
.838 .759 .776 r
.3759 .53711 .38045 .54204 .38826 .53287 .38375 .52761 Metetra
.811 .749 .795 r
.38375 .52761 .38826 .53287 .39601 .52511 .39152 .51971 Metetra
.775 .741 .822 r
.39152 .51971 .39601 .52511 .4037 .51902 .39923 .51363 Metetra
.724 .731 .856 r
.39923 .51363 .4037 .51902 .41133 .51473 .40686 .50946 Metetra
.647 .713 .896 r
.40686 .50946 .41133 .51473 .41891 .51229 .41445 .50721 Metetra
.53 .677 .932 r
.41445 .50721 .41891 .51229 .42647 .51165 .42201 .50682 Metetra
.354 .605 .943 r
.42201 .50682 .42647 .51165 .434 .51274 .42954 .50819 Metetra
.123 .485 .9 r
.42954 .50819 .434 .51274 .44153 .51541 .43707 .51115 Metetra
0 .338 .8 r
.43707 .51115 .44153 .51541 .44908 .51942 .44462 .51542 Metetra
0 .219 .693 r
.44462 .51542 .44908 .51942 .45666 .52438 .45219 .52062 Metetra
0 .169 .637 r
.45219 .52062 .45666 .52438 .46428 .52975 .45982 .52614 Metetra
0 .213 .671 r
.45982 .52614 .46428 .52975 .47197 .53478 .46752 .53122 Metetra
0 .372 .802 r
.46752 .53122 .47197 .53478 .47974 .53863 .47529 .535 Metetra
.226 .603 .951 r
.47529 .535 .47974 .53863 .48757 .54046 .48314 .53662 Metetra
.55 .755 .973 r
.48314 .53662 .48757 .54046 .49548 .53967 .49106 .53551 Metetra
.724 .794 .907 r
.49106 .53551 .49548 .53967 .50343 .53603 .49903 .53153 Metetra
.799 .79 .844 r
.49903 .53153 .50343 .53603 .51141 .52983 .50704 .52498 Metetra
.83 .78 .805 r
.50704 .52498 .51141 .52983 .5194 .5217 .51505 .51658 Metetra
.841 .772 .785 r
.51505 .51658 .5194 .5217 .52738 .5125 .52305 .5072 Metetra
.84 .766 .781 r
.52305 .5072 .52738 .5125 .53535 .50306 .53105 .49767 Metetra
.831 .764 .788 r
.53105 .49767 .53535 .50306 .54332 .49408 .53904 .48867 Metetra
.815 .762 .803 r
.53904 .48867 .54332 .49408 .55129 .48607 .54702 .48071 Metetra
.79 .761 .827 r
.54702 .48071 .55129 .48607 .55926 .47935 .55502 .47408 Metetra
.752 .757 .856 r
.55502 .47408 .55926 .47935 .56726 .47411 .56304 .46896 Metetra
.699 .747 .889 r
.56304 .46896 .56726 .47411 .57529 .47043 .57109 .46542 Metetra
.623 .728 .922 r
.57109 .46542 .57529 .47043 .58337 .46833 .57918 .46346 Metetra
.522 .692 .946 r
.57918 .46346 .58337 .46833 .5915 .46774 .58733 .46302 Metetra
.395 .637 .953 r
.58733 .46302 .5915 .46774 .5997 .46857 .59555 .46399 Metetra
.258 .567 .937 r
.59555 .46399 .5997 .46857 .60798 .47062 .60383 .46617 Metetra
.137 .499 .907 r
.60383 .46617 .60798 .47062 .61632 .4736 .61219 .46927 Metetra
.065 .457 .883 r
.61219 .46927 .61632 .4736 .62473 .47712 .62062 .47287 Metetra
.065 .461 .884 r
.62062 .47287 .62473 .47712 .6332 .48065 .6291 .47642 Metetra
.149 .519 .916 r
.6291 .47642 .6332 .48065 .6417 .48356 .63761 .47929 Metetra
.308 .617 .957 r
.63761 .47929 .6417 .48356 .65021 .48519 .64613 .48083 Metetra
.494 .711 .967 r
.64613 .48083 .65021 .48519 .65869 .48501 .65462 .48049 Metetra
.644 .767 .938 r
.65462 .48049 .65869 .48501 .66712 .48269 .66305 .47798 Metetra
.74 .789 .892 r
.66305 .47798 .66712 .48269 .67547 .47823 .67142 .47332 Metetra
.793 .794 .852 r
.67142 .47332 .67547 .47823 .68376 .47193 .67972 .46685 Metetra
.82 .792 .826 r
.67972 .46685 .68376 .47193 .69198 .46435 .68796 .45913 Metetra
.829 .789 .814 r
.68796 .45913 .69198 .46435 .70017 .45613 .69617 .45082 Metetra
.828 .786 .813 r
.69617 .45082 .70017 .45613 .70835 .44788 .70437 .44253 Metetra
.817 .784 .822 r
.70437 .44253 .70835 .44788 .71656 .44012 .7126 .43478 Metetra
.797 .781 .838 r
.7126 .43478 .71656 .44012 .72483 .43324 .72089 .42793 Metetra
.767 .776 .86 r
.72089 .42793 .72483 .43324 .73317 .4275 .72925 .42225 Metetra
.725 .766 .886 r
.72925 .42225 .73317 .4275 .7416 .42305 .73771 .41787 Metetra
.669 .75 .912 r
.73771 .41787 .7416 .42305 .75014 .41994 .74628 .41485 Metetra
.598 .726 .934 r
.74628 .41485 .75014 .41994 .75881 .41819 .75497 .41319 Metetra
.514 .691 .948 r
.75497 .41319 .75881 .41819 .76761 .41772 .76379 .41282 Metetra
.423 .649 .952 r
.76379 .41282 .76761 .41772 .77653 .41839 .77274 .41358 Metetra
.34 .607 .947 r
.77274 .41358 .77653 .41839 .78557 .41998 .7818 .41526 Metetra
.281 .575 .939 r
.7818 .41526 .78557 .41998 .79471 .42218 .79097 .41753 Metetra
.26 .566 .937 r
.79097 .41753 .79471 .42218 .80393 .42459 .8002 .41997 Metetra
.29 .587 .944 r
.8002 .41997 .80393 .42459 .81317 .42671 .80946 .42208 Metetra
.369 .635 .957 r
.80946 .42208 .81317 .42671 .8224 .42803 .8187 .42333 Metetra
.48 .694 .962 r
.8187 .42333 .8224 .42803 .83156 .42806 .82786 .42323 Metetra
.595 .745 .948 r
.82786 .42323 .83156 .42806 .8406 .42646 .83691 .42146 Metetra
.687 .776 .919 r
.83691 .42146 .8406 .42646 .8495 .42309 .84581 .4179 Metetra
.75 .791 .886 r
.84581 .4179 .8495 .42309 .85825 .41809 .85458 .41272 Metetra
.787 .795 .859 r
.85458 .41272 .85825 .41809 .86689 .41177 .86322 .40626 Metetra
.706 .766 .899 r
.22341 .59054 .22827 .59467 .23552 .59137 .23068 .58722 Metetra
.769 .773 .856 r
.23068 .58722 .23552 .59137 .24295 .58621 .23811 .58205 Metetra
.795 .773 .833 r
.23811 .58205 .24295 .58621 .25046 .57996 .24565 .57579 Metetra
.797 .773 .831 r
.24565 .57579 .25046 .57996 .25799 .57362 .2532 .56943 Metetra
.776 .773 .85 r
.2532 .56943 .25799 .57362 .26545 .56818 .26067 .56397 Metetra
.725 .768 .887 r
.26067 .56397 .26545 .56818 .2728 .56438 .26803 .56016 Metetra
.615 .743 .937 r
.26803 .56016 .2728 .56438 .28 .56273 .27525 .55849 Metetra
.397 .657 .963 r
.27525 .55849 .28 .56273 .28706 .56338 .28232 .55914 Metetra
.061 .465 .885 r
.28232 .55914 .28706 .56338 .29401 .56622 .28927 .56197 Metetra
0 .243 .717 r
.28927 .56197 .29401 .56622 .30088 .57078 .29614 .56653 Metetra
0 .123 .606 r
.29614 .56653 .30088 .57078 .30775 .57627 .30301 .57202 Metetra
0 .154 .636 r
.30301 .57202 .30775 .57627 .31468 .58157 .30994 .57732 Metetra
0 .357 .81 r
.30994 .57732 .31468 .58157 .32175 .58536 .31701 .58111 Metetra
.342 .632 .96 r
.31701 .58111 .32175 .58536 .32902 .58645 .3243 .58218 Metetra
.655 .759 .926 r
.3243 .58218 .32902 .58645 .33653 .58405 .33181 .57978 Metetra
.786 .781 .848 r
.33181 .57978 .33653 .58405 .34424 .57814 .33954 .57385 Metetra
.838 .779 .795 r
.33954 .57385 .34424 .57814 .3521 .56937 .34742 .56506 Metetra
.858 .775 .769 r
.34742 .56506 .3521 .56937 .36004 .55885 .35539 .55451 Metetra
.864 .774 .761 r
.35539 .55451 .36004 .55885 .36799 .54776 .36336 .5434 Metetra
.86 .775 .766 r
.36336 .5434 .36799 .54776 .3759 .53711 .3713 .53272 Metetra
.848 .777 .783 r
.3713 .53272 .3759 .53711 .38375 .52761 .37918 .52321 Metetra
.825 .779 .809 r
.37918 .52321 .38375 .52761 .39152 .51971 .38697 .51529 Metetra
.79 .779 .843 r
.38697 .51529 .39152 .51971 .39923 .51363 .39469 .50919 Metetra
.734 .772 .883 r
.39469 .50919 .39923 .51363 .40686 .50946 .40235 .50501 Metetra
.646 .75 .925 r
.40235 .50501 .40686 .50946 .41445 .50721 .40995 .50274 Metetra
.514 .701 .955 r
.40995 .50274 .41445 .50721 .42201 .50682 .41751 .50234 Metetra
.329 .612 .952 r
.41751 .50234 .42201 .50682 .42954 .50819 .42506 .5037 Metetra
.113 .483 .899 r
.42506 .5037 .42954 .50819 .43707 .51115 .43259 .50665 Metetra
0 .348 .812 r
.43259 .50665 .43707 .51115 .44462 .51542 .44014 .51093 Metetra
0 .249 .735 r
.44014 .51093 .44462 .51542 .45219 .52062 .44772 .51612 Metetra
0 .216 .707 r
.44772 .51612 .45219 .52062 .45982 .52614 .45536 .52164 Metetra
0 .27 .752 r
.45536 .52164 .45982 .52614 .46752 .53122 .46306 .52672 Metetra
.008 .413 .857 r
.46306 .52672 .46752 .53122 .47529 .535 .47083 .53049 Metetra
.302 .599 .949 r
.47083 .53049 .47529 .535 .48314 .53662 .47869 .53211 Metetra
.566 .727 .95 r
.47869 .53211 .48314 .53662 .49106 .53551 .48663 .53099 Metetra
.722 .777 .897 r
.48663 .53099 .49106 .53551 .49903 .53153 .49462 .52698 Metetra
.799 .79 .844 r
.49462 .52698 .49903 .53153 .50704 .52498 .50264 .52042 Metetra
.835 .791 .809 r
.50264 .52042 .50704 .52498 .51505 .51658 .51067 .512 Metetra
.85 .79 .793 r
.51067 .512 .51505 .51658 .52305 .5072 .5187 .50259 Metetra
.852 .79 .79 r
.5187 .50259 .52305 .5072 .53105 .49767 .52672 .49304 Metetra
.845 .791 .799 r
.52672 .49304 .53105 .49767 .53904 .48867 .53474 .48402 Metetra
.828 .791 .817 r
.53474 .48402 .53904 .48867 .54702 .48071 .54274 .47604 Metetra
.801 .789 .842 r
.54274 .47604 .54702 .48071 .55502 .47408 .55076 .46939 Metetra
.76 .782 .872 r
.55076 .46939 .55502 .47408 .56304 .46896 .5588 .46425 Metetra
.701 .768 .904 r
.5588 .46425 .56304 .46896 .57109 .46542 .56686 .4607 Metetra
.621 .742 .933 r
.56686 .4607 .57109 .46542 .57918 .46346 .57497 .45872 Metetra
.517 .698 .951 r
.57497 .45872 .57918 .46346 .58733 .46302 .58314 .45828 Metetra
.395 .637 .953 r
.58314 .45828 .58733 .46302 .59555 .46399 .59136 .45924 Metetra
.27 .566 .936 r
.59136 .45924 .59555 .46399 .60383 .46617 .59966 .46141 Metetra
.166 .502 .909 r
.59966 .46141 .60383 .46617 .61219 .46927 .60803 .4645 Metetra
.11 .465 .89 r
.60803 .4645 .61219 .46927 .62062 .47287 .61646 .46809 Metetra
.118 .47 .893 r
.61646 .46809 .62062 .47287 .6291 .47642 .62495 .47163 Metetra
.199 .523 .919 r
.62495 .47163 .6291 .47642 .63761 .47929 .63347 .4745 Metetra
.342 .609 .948 r
.63347 .4745 .63761 .47929 .64613 .48083 .642 .47603 Metetra
.507 .696 .954 r
.642 .47603 .64613 .48083 .65462 .48049 .65051 .47568 Metetra
.646 .756 .929 r
.65051 .47568 .65462 .48049 .66305 .47798 .65896 .47316 Metetra
.739 .786 .89 r
.65896 .47316 .66305 .47798 .67142 .47332 .66735 .46848 Metetra
.795 .798 .855 r
.66735 .46848 .67142 .47332 .67972 .46685 .67567 .46199 Metetra
.824 .802 .831 r
.67567 .46199 .67972 .46685 .68796 .45913 .68393 .45425 Metetra
.836 .803 .82 r
.68393 .45425 .68796 .45913 .69617 .45082 .69216 .44592 Metetra
.835 .803 .82 r
.69216 .44592 .69617 .45082 .70437 .44253 .70039 .43761 Metetra
.824 .802 .83 r
.70039 .43761 .70437 .44253 .7126 .43478 .70865 .42983 Metetra
.804 .799 .847 r
.70865 .42983 .7126 .43478 .72089 .42793 .71696 .42296 Metetra
.772 .792 .87 r
.71696 .42296 .72089 .42793 .72925 .42225 .72534 .41726 Metetra
.727 .78 .894 r
.72534 .41726 .72925 .42225 .73771 .41787 .73382 .41286 Metetra
.669 .76 .918 r
.73382 .41286 .73771 .41787 .74628 .41485 .74241 .40983 Metetra
.596 .73 .937 r
.74241 .40983 .74628 .41485 .75497 .41319 .75112 .40816 Metetra
.514 .691 .948 r
.75112 .40816 .75497 .41319 .76379 .41282 .75995 .40777 Metetra
.429 .646 .949 r
.75995 .40777 .76379 .41282 .77274 .41358 .76891 .40852 Metetra
.353 .603 .942 r
.76891 .40852 .77274 .41358 .7818 .41526 .77799 .41019 Metetra
.302 .572 .934 r
.77799 .41019 .7818 .41526 .79097 .41753 .78717 .41245 Metetra
.288 .563 .931 r
.78717 .41245 .79097 .41753 .8002 .41997 .79641 .41488 Metetra
.318 .582 .937 r
.79641 .41488 .8002 .41997 .80946 .42208 .80569 .41698 Metetra
.391 .625 .947 r
.80569 .41698 .80946 .42208 .8187 .42333 .81495 .41822 Metetra
.493 .682 .95 r
.81495 .41822 .8187 .42333 .82786 .42323 .82413 .41811 Metetra
.598 .734 .939 r
.82413 .41811 .82786 .42323 .83691 .42146 .83319 .41633 Metetra
.687 .772 .916 r
.83319 .41633 .83691 .42146 .84581 .4179 .84212 .41276 Metetra
.751 .794 .888 r
.84212 .41276 .84581 .4179 .85458 .41272 .8509 .40755 Metetra
.79 .805 .864 r
.8509 .40755 .85458 .41272 .86322 .40626 .85957 .40107 Metetra
.625 .528 .724 r
.21932 .57747 .22341 .59054 .23068 .58722 .22652 .57488 Metetra
.642 .546 .73 r
.22652 .57488 .23068 .58722 .23811 .58205 .23379 .5717 Metetra
.663 .583 .755 r
.23379 .5717 .23811 .58205 .24565 .57579 .2411 .56815 Metetra
.685 .645 .804 r
.2411 .56815 .24565 .57579 .2532 .56943 .24843 .56459 Metetra
.692 .736 .884 r
.24843 .56459 .2532 .56943 .26067 .56397 .25573 .56147 Metetra
.623 .837 .982 r
.25573 .56147 .26067 .56397 .26803 .56016 .26298 .55929 Metetra
.309 .781 .931 r
.26298 .55929 .26803 .56016 .27525 .55849 .27015 .55846 Metetra
.146 0 0 r
.27015 .55846 .27525 .55849 .28232 .55914 .27723 .5592 Metetra
.408 0 0 r
.27723 .5592 .28232 .55914 .28927 .56197 .28423 .56149 Metetra
.514 0 0 r
.28423 .56149 .28927 .56197 .29614 .56653 .29119 .56501 Metetra
.504 0 0 r
.29119 .56501 .29614 .56653 .30301 .57202 .29815 .56913 Metetra
0 .251 .655 r
.29815 .56913 .30301 .57202 .30994 .57732 .30518 .57296 Metetra
.133 .508 .91 r
.30518 .57296 .30994 .57732 .31701 .58111 .31234 .57548 Metetra
.49 .636 .919 r
.31234 .57548 .31701 .58111 .3243 .58218 .31968 .57572 Metetra
.661 .675 .853 r
.31968 .57572 .3243 .58218 .33181 .57978 .32721 .57307 Metetra
.746 .696 .803 r
.32721 .57307 .33181 .57978 .33954 .57385 .33494 .56743 Metetra
.796 .715 .775 r
.33494 .56743 .33954 .57385 .34742 .56506 .3428 .55928 Metetra
.827 .736 .763 r
.3428 .55928 .34742 .56506 .35539 .55451 .35075 .5495 Metetra
.847 .757 .763 r
.35075 .5495 .35539 .55451 .36336 .5434 .35872 .53907 Metetra
.855 .778 .774 r
.35872 .53907 .36336 .5434 .3713 .53272 .36666 .52889 Metetra
.853 .796 .795 r
.36666 .52889 .3713 .53272 .37918 .52321 .37454 .51966 Metetra
.838 .812 .825 r
.37454 .51966 .37918 .52321 .38697 .51529 .38235 .51185 Metetra
.805 .821 .864 r
.38235 .51185 .38697 .51529 .39469 .50919 .3901 .5057 Metetra
.747 .818 .908 r
.3901 .5057 .39469 .50919 .40235 .50501 .39778 .50137 Metetra
.653 .794 .95 r
.39778 .50137 .40235 .50501 .40995 .50274 .4054 .49888 Metetra
.516 .736 .974 r
.4054 .49888 .40995 .50274 .41751 .50234 .41299 .49821 Metetra
.338 .637 .963 r
.41299 .49821 .41751 .50234 .42506 .5037 .42054 .49928 Metetra
.146 .509 .912 r
.42054 .49928 .42506 .5037 .43259 .50665 .4281 .50194 Metetra
0 .386 .842 r
.4281 .50194 .43259 .50665 .44014 .51093 .43566 .50593 Metetra
0 .3 .785 r
.43566 .50593 .44014 .51093 .44772 .51612 .44325 .51088 Metetra
0 .272 .769 r
.44325 .51088 .44772 .51612 .45536 .52164 .45088 .51624 Metetra
0 .316 .802 r
.45088 .51624 .45536 .52164 .46306 .52672 .45859 .52126 Metetra
.1 .428 .871 r
.45859 .52126 .46306 .52672 .47083 .53049 .46637 .5251 Metetra
.336 .574 .928 r
.46637 .5251 .47083 .53049 .47869 .53211 .47423 .52691 Metetra
.556 .692 .931 r
.47423 .52691 .47869 .53211 .48663 .53099 .48217 .52608 Metetra
.706 .758 .893 r
.48217 .52608 .48663 .53099 .49462 .52698 .49018 .5224 Metetra
.791 .789 .85 r
.49018 .5224 .49462 .52698 .50264 .52042 .49822 .51614 Metetra
.836 .803 .819 r
.49822 .51614 .50264 .52042 .51067 .512 .50627 .50795 Metetra
.857 .811 .803 r
.50627 .50795 .51067 .512 .5187 .50259 .51433 .49869 Metetra
.864 .816 .801 r
.51433 .49869 .5187 .50259 .52672 .49304 .52237 .48918 Metetra
.858 .82 .81 r
.52237 .48918 .52672 .49304 .53474 .48402 .53041 .48013 Metetra
.842 .821 .828 r
.53041 .48013 .53474 .48402 .54274 .47604 .53844 .47206 Metetra
.814 .819 .854 r
.53844 .47206 .54274 .47604 .55076 .46939 .54648 .46528 Metetra
.771 .811 .884 r
.54648 .46528 .55076 .46939 .5588 .46425 .55454 .45999 Metetra
.71 .792 .915 r
.55454 .45999 .5588 .46425 .56686 .4607 .56262 .45627 Metetra
.628 .759 .941 r
.56262 .45627 .56686 .4607 .57497 .45872 .57074 .45412 Metetra
.525 .71 .956 r
.57074 .45412 .57497 .45872 .58314 .45828 .57892 .4535 Metetra
.41 .645 .954 r
.57892 .4535 .58314 .45828 .59136 .45924 .58715 .4543 Metetra
.296 .574 .936 r
.58715 .4543 .59136 .45924 .59966 .46141 .59546 .45633 Metetra
.206 .512 .912 r
.59546 .45633 .59966 .46141 .60803 .4645 .60383 .45929 Metetra
.158 .476 .896 r
.60383 .45929 .60803 .4645 .61646 .46809 .61227 .46279 Metetra
.167 .477 .896 r
.61227 .46279 .61646 .46809 .62495 .47163 .62077 .4663 Metetra
.238 .521 .914 r
.62077 .4663 .62495 .47163 .63347 .4745 .6293 .46919 Metetra
.361 .595 .935 r
.6293 .46919 .63347 .4745 .642 .47603 .63784 .4708 Metetra
.507 .677 .941 r
.63784 .4708 .642 .47603 .65051 .47568 .64637 .47058 Metetra
.638 .741 .923 r
.64637 .47058 .65051 .47568 .65896 .47316 .65484 .46822 Metetra
.732 .78 .891 r
.65484 .46822 .65896 .47316 .66735 .46848 .66326 .4637 Metetra
.792 .801 .86 r
.66326 .4637 .66735 .46848 .67567 .46199 .6716 .45735 Metetra
.825 .812 .838 r
.6716 .45735 .67567 .46199 .68393 .45425 .6799 .44971 Metetra
.84 .818 .827 r
.6799 .44971 .68393 .45425 .69216 .44592 .68816 .44142 Metetra
.842 .82 .828 r
.68816 .44142 .69216 .44592 .70039 .43761 .69641 .4331 Metetra
.832 .821 .838 r
.69641 .4331 .70039 .43761 .70865 .42983 .70469 .42528 Metetra
.811 .817 .855 r
.70469 .42528 .70865 .42983 .71696 .42296 .71302 .41834 Metetra
.779 .809 .877 r
.71302 .41834 .71696 .42296 .72534 .41726 .72142 .41254 Metetra
.733 .795 .901 r
.72142 .41254 .72534 .41726 .73382 .41286 .72992 .40804 Metetra
.674 .771 .923 r
.72992 .40804 .73382 .41286 .74241 .40983 .73852 .40489 Metetra
.602 .737 .94 r
.73852 .40489 .74241 .40983 .75112 .40816 .74724 .40309 Metetra
.522 .694 .947 r
.74724 .40309 .75112 .40816 .75995 .40777 .75608 .40258 Metetra
.441 .647 .946 r
.75608 .40258 .75995 .40777 .76891 .40852 .76504 .40322 Metetra
.373 .603 .937 r
.