(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    369788,       9265]*)
(*NotebookOutlinePosition[    411267,      10460]*)
(*  CellTagsIndexPosition[    407520,      10313]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["3.10 ", "HeadingNumber"],
  "Mathematical and Other Notation"
}], "Section",
  CellTags->{"S3.10.0", "0.1"}],

Cell[CellGroupData[{

Cell["3.10.1 Special Characters", "Subsection",
  CellTags->{"S3.10.1", "1.1"}],

Cell[TextData[{
  "Built into ",
  StyleBox["Mathematica", "TI"],
  " are a large number of special characters intended for use in mathematical \
and other notation. Section\[NonBreakingSpace]",
  ButtonBox["A.12.1",
    ButtonData:>{"A.12.1", "1.1000"},
    ButtonStyle->"MainBookLink"],
  " gives a complete listing. "
}], "Text",
  CellTags->{"S3.10.1", "1.2"}],

Cell[TextData[{
  "Each special character is assigned a full name such as \[Backslash]",
  StyleBox["[Infinity]", "MR"],
  ". More common special characters are also assigned aliases, such as \
\[AliasIndicator]",
  StyleBox["inf\[AliasIndicator]", "MR"],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
  " stands for the ",
  Cell[BoxData[
      \(TraditionalForm\`\[EscapeKey]\)], "InlineFormula"],
  " key. You can set up additional aliases using the ",
  StyleBox["InputAliases", "MR"],
  " notebook option discussed in Section\[NonBreakingSpace]",
  ButtonBox["2.11.11",
    ButtonData:>{"2.11.11", "11.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S3.10.1", "1.3"}],

Cell[TextData[{
  "For special characters that are supported in standard dialects of TeX, ",
  StyleBox["Mathematica", "TI"],
  " also allows you to use aliases based on TeX names. Thus, for example, you \
can enter \[Backslash]",
  StyleBox["[Infinity]", "MR"],
  " using the alias \[AliasIndicator]",
  StyleBox["\\infty\[AliasIndicator]", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " also supports aliases such as \[AliasIndicator]",
  StyleBox["&infin\[AliasIndicator]", "MR"],
  " based on names used in SGML and HTML. "
}], "Text",
  CellTags->{"S3.10.1", "1.4"}],

Cell[TextData[{
  "Standard system software on many computer systems also supports special \
key combinations for entering certain special characters. On a Macintosh, for \
example, Option\[Hyphen]5 will produce ",
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  " in most fonts. With the notebook front end ",
  StyleBox["Mathematica", "TI"],
  " automatically allows you to use special key combinations when these are \
available, and with a text\[Hyphen]based interface you can get ",
  StyleBox["Mathematica", "TI"],
  " to accept such key combinations if you set an appropriate value for ",
  StyleBox["$CharacterEncoding", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.10.1", "1.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] Use a full name such as \[Backslash]",
              StyleBox["[Infinity]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Use an alias such as \[EscapeKey]",
              StyleBox["inf\[EscapeKey]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Use a TeX alias such as \[EscapeKey]",
              StyleBox["\\infty\[EscapeKey]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              
              "\[FilledSmallSquare] Use an SGML or HTML alias such as \
\[EscapeKey]",
              StyleBox["&infin\[EscapeKey]", "MR"],
              " "
            }]]},
          {
            Cell["\<\
\[FilledSmallSquare] Click on a button in a palette \
\
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Use a special key combination \
supported by your computer system \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.10.1"],

Cell["Ways to enter special characters. ", "Caption",
  CellTags->"S3.10.1"],

Cell[TextData[{
  "In a ",
  StyleBox["Mathematica", "TI"],
  " notebook, you can use special characters just like you use standard \
keyboard characters. You can include special characters both in ordinary text \
and in input that you intend to give to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.10.1", "1.6"}],

Cell[TextData[{
  "Some special characters are set up to have an immediate meaning to ",
  StyleBox["Mathematica", "TI"],
  ". Thus, for example, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " is taken to be the symbol ",
  StyleBox["Pi", "MR"],
  ". Similarly, ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterEqual] \)], "InlineFormula"],
  " is taken to be the operator ",
  StyleBox[">=", "MR"],
  ", while ",
  Cell[BoxData[
      \(TraditionalForm\`\[Union]\)], "InlineFormula"],
  " is equivalent to the function ",
  StyleBox["Union", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.1", "1.7"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterEqual] \)], "InlineFormula"],
  " have immediate meanings in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.8"}],

Cell[CellGroupData[{

Cell["\[Pi] \[GreaterEqual] 3", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[Union]\)], "InlineFormula"],
  " or \[Backslash]",
  StyleBox["[Union]", "MR"],
  " is immediately interpreted as the ",
  StyleBox["Union", "MR"],
  " function. "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.9"}],

Cell[CellGroupData[{

Cell["{a, b, c} \[Union] {c, d, e}", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    \({a, b, c, d, e}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\` \[SquareUnion] \)], "InlineFormula"],
  " or \[Backslash]",
  StyleBox["[SquareUnion]", "MR"],
  " has no immediate meaning to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.10"}],

Cell[CellGroupData[{

Cell["{a, b, c} \[SquareUnion] {c, d, e}", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    \({a, b, c} \[SquareUnion] {c, d, e}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "Among ordinary characters such as ",
  StyleBox["E", "MR"],
  " and ",
  StyleBox["i", "MR"],
  ", some have an immediate meaning to ",
  StyleBox["Mathematica", "TI"],
  ", but most do not. And the same is true of special characters. "
}], "Text",
  CellTags->{"S3.10.1", "1.11"}],

Cell[TextData[{
  "Thus, for example, while ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  " have an immediate meaning to ",
  StyleBox["Mathematica", "TI"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalL]\)], "InlineFormula"],
  " do not. "
}], "Text",
  CellTags->{"S3.10.1", "1.12"}],

Cell[TextData[{
  "This allows you to set up your own definitions for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalL]\)], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S3.10.1", "1.13"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\)], "InlineFormula"],
  " has no immediate meaning in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.14"}],

Cell[CellGroupData[{

Cell["\[Lambda][2] + \[Lambda][3]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    \(\[Lambda][2] + \[Lambda][3]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "This defines a meaning for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.15"}],

Cell[BoxData[
    \(\[Lambda][x_] := \@\(x\^2 - 1\)\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.10.1"],

Cell[TextData[{
  "Now ",
  StyleBox["Mathematica", "TI"],
  " evaluates ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\)], "InlineFormula"],
  " just as it would any other function. "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.16"}],

Cell[CellGroupData[{

Cell["\[Lambda][2] + \[Lambda][3]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    \(2\ \@2 + \@3\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "Characters such as ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalL]\)], "InlineFormula"],
  " are treated by ",
  StyleBox["Mathematica", "TI"],
  " as letters\[LongDash]just like ordinary keyboard letters like ",
  StyleBox["a", "MR"],
  " or ",
  StyleBox["b", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.1", "1.17"}],

Cell[TextData[{
  "But characters such as ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\` \[SquareUnion] \)], "InlineFormula"],
  " are treated by ",
  StyleBox["Mathematica", "TI"],
  " as ",
  StyleBox["operators", "TI"],
  ". And although these particular characters are not assigned any built\
\[Hyphen]in meaning by ",
  StyleBox["Mathematica", "TI"],
  ", they are nevertheless required to follow a definite ",
  StyleBox["syntax", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.10.1", "1.18"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\` \[SquareUnion] \)], "InlineFormula"],
  " is an infix operator. "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.19"}],

Cell[CellGroupData[{

Cell["{a, b, c} \[SquareUnion] {c, d, e}", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    \({a, b, c} \[SquareUnion] {c, d, e}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "The definition assigns a meaning to the ",
  Cell[BoxData[
      \(TraditionalForm\` \[SquareUnion] \)], "InlineFormula"],
  " operator. "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.20"}],

Cell["x_ \[SquareUnion] y_ := Join[x, y]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S3.10.1"],

Cell[TextData[{
  "Now ",
  Cell[BoxData[
      \(TraditionalForm\` \[SquareUnion] \)], "InlineFormula"],
  " can be evaluated by ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.21"}],

Cell[CellGroupData[{

Cell["{a, b, c} \[SquareUnion] {c, d, e}", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    \({a, b, c, c, d, e}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "The details of how input you give to ",
  StyleBox["Mathematica", "TI"],
  " is interpreted depends on whether you are using ",
  StyleBox["StandardForm", "MR"],
  " or ",
  StyleBox["TraditionalForm", "MR"],
  ", and on what additional information you supply in ",
  StyleBox["InterpretationBox", "MR"],
  " and similar constructs. "
}], "Text",
  CellTags->{"S3.10.1", "1.22"}],

Cell[TextData[{
  "But unless you explicitly override its built\[Hyphen]in rules by giving \
your own definitions for ",
  StyleBox["MakeExpression", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will always assign the same basic syntactic properties to any particular \
special character. "
}], "Text",
  CellTags->{"S3.10.1", "1.23"}],

Cell[TextData[{
  "These properties not only affect the interpretation of the special \
characters in ",
  StyleBox["Mathematica", "TI"],
  " input, but also determine the structure of expressions built with these \
special characters. They also affect various aspects of formatting; \
operators, for example, have extra space left around them, while letters do \
not. "
}], "Text",
  CellTags->{"S3.10.1", "1.24"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Letters "], Cell[TextData[{
              StyleBox["a", "MR"],
              ", ",
              StyleBox["E", "MR"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CapitalXi]\)], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\[ScriptCapitalL]\)], "InlineFormula"],
              ", etc. "
            }]]},
          {Cell["Letter\[Hyphen]like forms "], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\[EmptySet]\)], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Mho]\)], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Sterling]\)], "InlineFormula"],
              ", etc. "
            }]]},
          {Cell["Operators "], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\[PartialD]\)], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\` \[TildeTilde] \)], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Equilibrium] \)], "InlineFormula"],
              ", etc. "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.10.1"],

Cell["Types of special characters. ", "Caption",
  CellTags->"S3.10.1"],

Cell["\<\
In using special characters, it is important to make sure that you \
have the correct character for a particular purpose. There are quite a few \
examples of characters that look similar, yet are in fact quite different. \
\
\>", "Text",
  CellTags->{"S3.10.1", "1.25"}],

Cell[TextData[{
  "A common issue is operators whose forms are derived from letters. An \
example is ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\)], "InlineFormula"],
  " or \[Backslash]",
  StyleBox["[Sum]", "MR"],
  ", which looks very similar to ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalSigma]\)], "InlineFormula"],
  " or \[Backslash]",
  StyleBox["[CapitalSigma]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.1", "1.26"}],

Cell[TextData[{
  "As is typical, however, the operator form ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\)], "InlineFormula"],
  " is slightly less elaborate and more stylized than the letter form ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalSigma]\)], "InlineFormula"],
  ". In addition, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\)], "InlineFormula"],
  " is an extensible character which grows depending on the summand, while ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalSigma]\)], "InlineFormula"],
  " has a size determined only by the current font. "
}], "Text",
  CellTags->{"S3.10.1", "1.27"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[CapitalAlpha]\)], 
                            "InlineFormula"],
                          "  A "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalAlpha]", "MR"],
                          ",  keyboard ",
                          StyleBox["A", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[Angstrom]\)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[CapitalARing]\)], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Angstrom]", "MR"],
                          ",  \[Backslash]",
                          StyleBox["[CapitalARing]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[DifferentialD]\)], 
                            "InlineFormula"],
                          "  d "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DifferentialD]", "MR"],
                          ",  keyboard ",
                          StyleBox["d", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[ExponentialE]\)], 
                            "InlineFormula"],
                          "  e "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ExponentialE]", "MR"],
                          ",  keyboard ",
                          StyleBox["e", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\` \[Element] \)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[Epsilon]\)], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Element]", "MR"],
                          ",  \[Backslash]",
                          StyleBox["[Epsilon]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[ImaginaryI]\)], 
                            "InlineFormula"],
                          "  i "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ImaginaryI]", "MR"],
                          ",  keyboard ",
                          StyleBox["i", "MR"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]], 
            Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[Micro]\)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[Mu]\)], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Micro]", "MR"],
                          ",  \[Backslash]",
                          StyleBox["[Mu]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[EmptySet]\)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[CapitalOSlash]\)], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EmptySet]", "MR"],
                          ",  \[Backslash]",
                          StyleBox["[CapitalOSlash]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[Product]\)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[CapitalPi]\)], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Product]", "MR"],
                          ",  \[Backslash]",
                          StyleBox["[CapitalPi]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[Sum]\)], "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[CapitalSigma]\)], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Sum]", "MR"],
                          ",  \[Backslash]",
                          StyleBox["[CapitalSigma]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[Transpose] \)], 
                            "InlineFormula"],
                          "  T "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Transpose]", "MR"],
                          ",  keyboard ",
                          StyleBox["T", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[Union]\)], 
                            "InlineFormula"],
                          "  U "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Union]", "MR"],
                          ",  keyboard ",
                          StyleBox["U", "MR"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.1"],

Cell["Different characters that look similar. ", "Caption",
  CellTags->"S3.10.1"],

Cell[TextData[{
  "In cases such as \[Backslash]",
  StyleBox["[CapitalAlpha]", "MR"],
  " versus ",
  StyleBox["A", "MR"],
  ", both characters are letters. However, ",
  StyleBox["Mathematica", "TI"],
  " treats these characters as different, and in some fonts, for example, \
they may look quite different.  "
}], "Text",
  CellTags->{"S3.10.1", "1.28"}],

Cell["The result contains four distinct characters. ", "MathCaption",
  CellTags->{"S3.10.1", "1.29"}],

Cell[CellGroupData[{

Cell["Union[ {\\[CapitalAlpha], A, A, \\[Mu], \\[Mu], \\[Micro]} ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    \({A, \[CapitalAlpha], \[Mu], \[Micro]}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "Traditional mathematical notation occasionally uses ordinary letters as \
operators. An example is the ",
  StyleBox["d", "MR"],
  " in a differential such as ",
  StyleBox["dx", "MR"],
  " that appears in an integral. "
}], "Text",
  CellTags->{"S3.10.1", "1.30"}],

Cell[TextData[{
  "To make ",
  StyleBox["Mathematica", "TI"],
  " have a precise and consistent syntax, it is necessary at least in ",
  StyleBox["StandardForm", "MR"],
  " to distinguish between an ordinary ",
  StyleBox["d", "MR"],
  " and the ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  " used as a differential operator. "
}], "Text",
  CellTags->{"S3.10.1", "1.31"}],

Cell[TextData[{
  "The way ",
  StyleBox["Mathematica", "TI"],
  " does this is to use a special character ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  " or \[Backslash]",
  StyleBox["[DifferentialD]", "MR"],
  " as the differential operator. This special character can be entered using \
the alias \[AliasIndicator]",
  StyleBox["dd\[AliasIndicator]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.1", "1.32"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " uses a special character for the differential operator, so there is no \
conflict with an ordinary ",
  StyleBox["d", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.33"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\(x\^d\) \[DifferentialD]x\)], "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    \(x\^\(1 + d\)\/\(1 + d\)\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "When letters and letter\[Hyphen]like forms appear in ",
  StyleBox["Mathematica", "TI"],
  " input, they are typically treated as names of symbols. But when operators \
appear, functions must be constructed that correspond to these operators. In \
almost all cases, what ",
  StyleBox["Mathematica", "TI"],
  " does is to create a function whose name is the full name of the special \
character that appears as the operator. "
}], "Text",
  CellTags->{"S3.10.1", "1.34"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " constructs a ",
  StyleBox["CirclePlus", "MR"],
  " function to correspond to the operator ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  ", whose full name is \[Backslash]",
  StyleBox["[CirclePlus]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.35"}],

Cell[CellGroupData[{

Cell["a \[CirclePlus] b \[CirclePlus] c // FullForm", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    TagBox[
      StyleBox[\(CirclePlus[a, b, c]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[12]//FullForm= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "This constructs an ",
  StyleBox["And", "MR"],
  " function, which happens to have built\[Hyphen]in evaluation rules in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.36"}],

Cell[CellGroupData[{

Cell["a \[And] b \[And] c // FullForm", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    TagBox[
      StyleBox[\(And[a, b, c]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[13]//FullForm= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "Following the correspondence between operator names and function names, \
special characters such as ",
  Cell[BoxData[
      \(TraditionalForm\`\[Union]\)], "InlineFormula"],
  " that represent built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions have names that correspond to those functions. Thus, for \
example, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Divide]\)], "InlineFormula"],
  " is named \[Backslash]",
  StyleBox["[Divide]", "MR"],
  " to correspond to the built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["Divide", "MR"],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\` \[Implies] \)], "InlineFormula"],
  " is named \[Backslash]",
  StyleBox["[Implies]", "MR"],
  " to correspond to the built\[Hyphen]in function ",
  StyleBox["Implies", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.1", "1.37"}],

Cell[TextData[{
  "In general, however, special characters in ",
  StyleBox["Mathematica", "TI"],
  " are given names that are as generic as possible, so as not to prejudice \
different uses. Most often, characters are thus named mainly according to \
their appearance. The character ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " is therefore named \[Backslash]",
  StyleBox["[CirclePlus]", "MR"],
  ", rather than, say \[Backslash]",
  StyleBox["[DirectSum]", "MR"],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\` \[TildeTilde] \)], "InlineFormula"],
  " is named \[Backslash]",
  StyleBox["[TildeTilde]", "MR"],
  " rather than, say, \[Backslash]",
  StyleBox["[ApproximatelyEqual]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.1", "1.38"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[Times]\)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[Cross]\)], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Times]", "MR"],
                          ",  \[Backslash]",
                          StyleBox["[Cross]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\` \[And] \)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[Wedge]\)], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[And]", "MR"],
                          ",  \[Backslash]",
                          StyleBox["[Wedge]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\` \[Or] \)], "InlineFormula"],
                          
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[Vee]\)], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Or]", "MR"],
                          ",  \[Backslash]",
                          StyleBox["[Vee]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\` \[Rule] \)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[Rule] \)], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Rule]", "MR"],
                          ",  \[Backslash]",
                          StyleBox["[RightArrow]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\` \[Implies] \)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[DoubleRightArrow] \)], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Implies]", "MR"],
                          ",  \[Backslash]",
                          StyleBox["[DoubleRightArrow]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\` \[LongEqual] \)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\` = \)], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LongEqual]", "MR"],
                          ",  keyboard ",
                          StyleBox["=", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[Piecewise]\)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\`{\[Null]\)], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Piecewise]", "MR"],
                          ",  keyboard ",
                          StyleBox["{", "MR"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]], 
            Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[Star]\)], "InlineFormula"],
                          
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\`*\)], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Star]", "MR"],
                          ",  keyboard ",
                          StyleBox["*", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[Backslash]\)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\`\\\)], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Backslash]", "MR"],
                          ",  keyboard \[Backslash] "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[CenterDot]\)], 
                            "InlineFormula"],
                          "  . "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CenterDot]", "MR"],
                          ",  keyboard ",
                          StyleBox[".", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[Wedge]\)], 
                            "InlineFormula"],
                          "  ",
                          StyleBox["^", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Wedge]", "MR"],
                          ",  keyboard ",
                          StyleBox["^", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\` \[VerticalBar] \)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[VerticalBar] \)], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[VerticalBar]", "MR"],
                          ",  keyboard ",
                          StyleBox["|", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\` \[VerticalSeparator] \)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[VerticalSeparator] \)], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[VerticalSeparator]", "MR"],
                          ",  keyboard ",
                          StyleBox["|", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              \(TraditionalForm\`\[LeftAngleBracket]\)], 
                            "InlineFormula"],
                          "  ",
                          Cell[BoxData[
                              \(TraditionalForm\` < \)], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftAngleBracket]", "MR"],
                          ",  keyboard ",
                          StyleBox["<", "MR"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.1"],

Cell["Different operator characters that look similar. ", "Caption",
  CellTags->"S3.10.1"],

Cell[TextData[{
  "There are sometimes characters that look similar but which are used to \
represent different operators. An example is \[Backslash]",
  StyleBox["[Times]", "MR"],
  " and \[Backslash]",
  StyleBox["[Cross]", "MR"],
  ". \[Backslash]",
  StyleBox["[Times]", "MR"],
  " corresponds to the ordinary ",
  StyleBox["Times", "MR"],
  " function for multiplication; \[Backslash]",
  StyleBox["[Cross]", "MR"],
  " corresponds to the ",
  StyleBox["Cross", "MR"],
  " function for vector cross products. The ",
  Cell[BoxData[
      \(TraditionalForm\`\[Cross]\)], "InlineFormula"],
  " for \[Backslash]",
  StyleBox["[Cross]", "MR"],
  " is drawn slightly smaller than ",
  Cell[BoxData[
      \(TraditionalForm\`\[Times]\)], "InlineFormula"],
  " for ",
  StyleBox["Times", "MR"],
  ", corresponding to usual careful usage in mathematical typography. "
}], "Text",
  CellTags->{"S3.10.1", "1.39"}],

Cell[TextData[{
  "The \[Backslash]",
  StyleBox["[Times]", "MR"],
  " operator represents ordinary multiplication. "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.40"}],

Cell[CellGroupData[{

Cell["{5, 6, 7} \\[Times] {2, 3, 1}", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    \({10, 18, 7}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "The \[Backslash]",
  StyleBox["[Cross]", "MR"],
  " operator represents vector cross products. "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.41"}],

Cell[CellGroupData[{

Cell["{5, 6, 7} \\[Cross] {2, 3, 1}", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    \({\(-15\), 9, 3}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "The two operators display in a similar way\[LongDash]with \[Backslash]",
  StyleBox["[Times]", "MR"],
  " slightly larger than \[Backslash]",
  StyleBox["[Cross]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.42"}],

Cell[CellGroupData[{

Cell["{a \[Times] b, a \[Cross] b}", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    \({a\ b, a\[Cross]b}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "In the example of \[Backslash]",
  StyleBox["[And]", "MR"],
  " and \[Backslash]",
  StyleBox["[Wedge]", "MR"],
  ", the \[Backslash]",
  StyleBox["[And]", "MR"],
  " operator\[LongDash]which happens to be drawn slightly \
larger\[LongDash]corresponds to the built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["And", "MR"],
  ", while the \[Backslash]",
  StyleBox["[Wedge]", "MR"],
  " operator has a generic name based on the appearance of the character and \
has no built\[Hyphen]in meaning. "
}], "Text",
  CellTags->{"S3.10.1", "1.43"}],

Cell[TextData[{
  "You can mix \[Backslash]",
  StyleBox["[Wedge]", "MR"],
  " and \[Backslash]",
  StyleBox["[And]", "MR"],
  " operators. Each has a definite precedence. "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.44"}],

Cell[CellGroupData[{

Cell["a \\[Wedge] b \\[And] c \\[Wedge] d // FullForm", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    TagBox[
      StyleBox[\(And[Wedge[a, b], Wedge[c, d]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[17]//FullForm= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "Some of the special characters commonly used as operators in mathematical \
notation look similar to ordinary keyboard characters. Thus, for example, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Wedge]\)], "InlineFormula"],
  " or \[Backslash]",
  StyleBox["[Wedge]", "MR"],
  " looks similar to the ",
  StyleBox["^", "MR"],
  " character on a standard keyboard. "
}], "Text",
  CellTags->{"S3.10.1", "1.45"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " interprets a raw ",
  StyleBox["^", "MR"],
  " as a power. But it interprets ",
  Cell[BoxData[
      \(TraditionalForm\`\[Wedge]\)], "InlineFormula"],
  " as a generic ",
  StyleBox["Wedge", "MR"],
  " function. In cases such as this where there is a special character that \
looks similar to an ordinary keyboard character, the convention is to use the \
ordinary keyboard character as the alias for the special character. Thus, for \
example, \[AliasIndicator]",
  StyleBox["^\[AliasIndicator]", "MR"],
  " is the alias for \[Backslash]",
  StyleBox["[Wedge]", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.10.1", "1.46"}],

Cell[TextData[{
  "The raw ",
  StyleBox["^", "MR"],
  " is interpreted as a power, but the \[AliasIndicator]",
  StyleBox["^\[AliasIndicator]", "MR"],
  " is a generic wedge operator. "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.47"}],

Cell[CellGroupData[{

Cell[TextData[{
  "{x ^ y, x \[AliasIndicator]",
  StyleBox["^\[AliasIndicator]", "MR"],
  " y}"
}], "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    \({x\^y, x\[Wedge]y}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell[TextData[{
  "A related convention is that when a special character is used to represent \
an operator that can be typed using ordinary keyboard characters, those \
characters are used in the alias for the special character. Thus, for \
example, \[AliasIndicator]",
  StyleBox["->\[AliasIndicator]", "MR"],
  " is the alias for ",
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
  " or \[Backslash]",
  StyleBox["[Rule]", "MR"],
  ", while \[AliasIndicator]",
  StyleBox["&&\[AliasIndicator]", "MR"],
  " is the alias for ",
  Cell[BoxData[
      \(TraditionalForm\` \[And] \)], "InlineFormula"],
  " or \[Backslash]",
  StyleBox["[And]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.1", "1.48"}],

Cell[TextData[{
  "\[AliasIndicator]",
  StyleBox["->\[AliasIndicator]", "MR"],
  " is the alias for \[Backslash]",
  StyleBox["[Rule]", "MR"],
  ", and \[AliasIndicator]",
  StyleBox["&&\[AliasIndicator]", "MR"],
  " for \[Backslash]",
  StyleBox["[And]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.1", "1.49"}],

Cell[CellGroupData[{

Cell[TextData[{
  "{x \[AliasIndicator]",
  StyleBox["->\[AliasIndicator]", "MR"],
  " y, x \[AliasIndicator]",
  StyleBox["&&\[AliasIndicator]", "MR"],
  " y} // FullForm"
}], "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S3.10.1"],

Cell[BoxData[
    TagBox[
      StyleBox[\(List[Rule[x, y], And[x, y]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[19]//FullForm= ",
  CellTags->"S3.10.1"]
}, Open  ]],

Cell["\<\
The most extreme case of characters that look alike but work \
differently occurs with vertical bars. \
\>", "Text",
  CellTags->{"S3.10.1", "1.50"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["character name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["alias", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["interpretation", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["|", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "keyboard ",
              StyleBox["|", "MR"],
              " "
            }]], Cell[""], Cell[TextData[{
              StyleBox["Alternatives[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[VerticalSeparator] \)], 
                "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[VerticalSeparator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["|\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["VerticalSeparator[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[VerticalBar] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[VerticalBar]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              StyleBox["|\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["VerticalBar[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftBracketingBar]\)], 
                "InlineFormula"],
              " ",
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightBracketingBar]\)], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[LeftBracketingBar]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["l|\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["BracketingBar[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[""], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[RightBracketingBar]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["r|\[AliasIndicator]", "MR"],
              " "
            }]], Cell[""]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox4Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S3.10.1"],

Cell["Different types of vertical bars. ", "Caption",
  CellTags->"S3.10.1"],

Cell[TextData[{
  "Notice that the alias for \[Backslash]",
  StyleBox["[VerticalBar]", "MR"],
  " is \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  StyleBox["|\[AliasIndicator]", "MR"],
  ", while the alias for the somewhat more common \[Backslash]",
  StyleBox["[VerticalSeparator]", "MR"],
  " is \[AliasIndicator]",
  StyleBox["|\[AliasIndicator]", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " often gives similar\[Hyphen]looking characters similar aliases; it is a \
general convention that the aliases for the less commonly used characters are \
distinguished by having spaces at the beginning. "
}], "Text",
  CellTags->{"S3.10.1", "1.51"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              StyleBox["nnn", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              " "
            }]], 
            Cell["\<\
built\[Hyphen]in alias for a common character \
\>"]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              StyleBox["nnn", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              " "
            }]], 
            Cell["\<\
built\[Hyphen]in alias for similar but less common \
character \
\>"]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              StyleBox[".", "MR"],
              StyleBox["nnn", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "alias globally defined in a ",
              StyleBox["Mathematica", "TI"],
              " session "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              StyleBox[",", "MR"],
              StyleBox["nnn", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              " "
            }]], Cell["alias defined in a specific notebook "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.10.1"],

Cell["Conventions for special character aliases. ", "Caption",
  CellTags->"S3.10.1"],

Cell[TextData[{
  "The notebook front end for ",
  StyleBox["Mathematica", "TI"],
  " often allows you to set up your own aliases for special characters. If \
you want to, you can overwrite the built\[Hyphen]in aliases. But the \
convention is to use aliases that begin with a dot or comma. "
}], "Text",
  CellTags->{"S3.10.1", "1.52"}],

Cell["\<\
Note that whatever aliases you may use to enter special characters, \
the full names of the characters will always be used when the characters are \
stored in files. \
\>", "Text",
  CellTags->{"S3.10.1", "1.53"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.10.2 Names of Symbols and Mathematical Objects", "Subsection",
  CellTags->{"S3.10.2", "2.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " by default interprets any sequence of letters or letter\[Hyphen]like \
forms as the name of a symbol. "
}], "Text",
  CellTags->{"S3.10.2", "2.2"}],

Cell[TextData[{
  "All these are treated by ",
  StyleBox["Mathematica", "TI"],
  " as symbols. "
}], "MathCaption",
  CellTags->{"S3.10.2", "2.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({\[Xi], \[CapitalSigma]\[Alpha], 
      R\[Infinity], \[ScriptCapitalH], \[Aleph], \[Angle]ABC, \
\[FilledSquare]X, m\[Ellipsis]n}\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.10.2"],

Cell[BoxData[
    \({\[Xi], \[CapitalSigma]\[Alpha], 
      R\[Infinity], \[ScriptCapitalH], \[Aleph], \[Angle]ABC, \
\[FilledSquare]X, m\[Ellipsis]n}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.10.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["character name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["alias", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["interpretation", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Pi]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["p\[AliasIndicator]", "MR"],
              ", \[AliasIndicator]",
              StyleBox["pi\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "equivalent to ",
              StyleBox["Pi", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Infinity]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["inf\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "equivalent to ",
              StyleBox["Infinity", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[ExponentialE]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[ExponentialE]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["ee\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "equivalent to ",
              StyleBox["E", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[ImaginaryI]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[ImaginaryI]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["ii\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "equivalent to ",
              StyleBox["I", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[ImaginaryJ]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[ImaginaryJ]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["jj\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "equivalent to ",
              StyleBox["I", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox4Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S3.10.2"],

Cell["\<\
Symbols with built\[Hyphen]in meanings whose names do not start \
with capital English letters. \
\>", "Caption",
  CellTags->"S3.10.2"],

Cell[TextData[{
  "Essentially all symbols with built\[Hyphen]in meanings in ",
  StyleBox["Mathematica", "TI"],
  " have names that start with capital English letters. Among the exceptions \
are ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[ImaginaryI]\)], "InlineFormula"],
  ", which correspond to ",
  StyleBox["E", "MR"],
  " and ",
  StyleBox["I", "MR"],
  " respectively. "
}], "Text",
  CellTags->{"S3.10.2", "2.4"}],

Cell[TextData[{
  "Forms such as ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\)], "InlineFormula"],
  " are used for both input and output in ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.2", "2.5"}],

Cell[CellGroupData[{

Cell["{\[ExponentialE] ^ (2 \[Pi] \[ImaginaryI]), \[ExponentialE] ^ \[Pi]}", \
"Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.10.2"],

Cell[BoxData[
    \({1, \[ExponentialE]\^\[Pi]}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.10.2"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["OutputForm", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\)], "InlineFormula"],
  " is output as ",
  StyleBox["E", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.2", "2.6"}],

Cell[CellGroupData[{

Cell["OutputForm[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.10.2"],

Cell["{1, E^Pi}", "Output",
  CellLabel->"Out[3]//OutputForm= ",
  CellTags->"S3.10.2"],

Cell[OutputFormData["\<\
     Pi
{1, E  }\
\>"], "Output",
  CellLabel->"Out[3]//OutputForm= ",
  CellTags->"S3.10.2"]
}, Open  ]],

Cell[TextData[{
  "In written material, it is standard to use very short \
names\[LongDash]often single letters\[LongDash]for most of the mathematical \
objects that one considers. But in ",
  StyleBox["Mathematica", "TI"],
  ", it is usually better to use longer and more explicit names. "
}], "Text",
  CellTags->{"S3.10.2", "2.7"}],

Cell[TextData[{
  "In written material you can always explain that a particular single\
\[Hyphen]letter name means one thing in one place and another in another \
place. But in ",
  StyleBox["Mathematica", "TI"],
  ", unless you use different contexts, a global symbol with a particular \
name will always be assumed to mean the same thing. "
}], "Text",
  CellTags->{"S3.10.2", "2.8"}],

Cell["\<\
As a result, it is typically better to use longer names, which are \
more likely to be unique, and which describe more explicitly what they mean. \
\
\>", "Text",
  CellTags->{"S3.10.2", "2.9"}],

Cell["\<\
For variables to which no value will be assigned, or for local \
symbols, it is nevertheless convenient and appropriate to use short, often \
single\[Hyphen]letter, names. \
\>", "Text",
  CellTags->{"S3.10.2", "2.10"}],

Cell[TextData[{
  "It is sensible to give the global function ",
  StyleBox["LagrangianL", "MR"],
  " a long and explicit name. The local variables can be given short names. "
}], "MathCaption",
  CellTags->{"S3.10.2", "2.11"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LagrangianL[\[Phi]_, \[Mu]_] = \((\[Square]\[Phi])\)\^2 + \(\[Mu]\^2\) \
\[Phi]\^2\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.10.2"],

Cell[BoxData[
    \(\[Mu]\^2\ \[Phi]\^2 + \((\[Square]\[Phi])\)\^2\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S3.10.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["input", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["interpretation", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["x",
                      "TI"], 
                    StyleBox["n",
                      "TI"]]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox["_\[RightModified]", "MR"],
              StyleBox["n", "TI"],
              "\[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["_", "MR"],
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Subscript[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["x",
                      "TI"], "+"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "_\[RightModified]+\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["_+", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["SubPlus[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["x",
                      "TI"], "-"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "_\[RightModified]-\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["_-", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["SubMinus[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["x",
                      "TI"], "*"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "_\[RightModified]*\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["_*", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["SubStar[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["x",
                      "TI"], "+"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "^\[RightModified]+\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["^+", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["SuperPlus[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["x",
                      "TI"], "-"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "^\[RightModified]-\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["^-", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["SuperMinus[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["x",
                      "TI"], "*"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "^\[RightModified]*\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["^*", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["SuperStar[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["x",
                      "TI"], "\[Dagger]"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "^\[RightModified]\[AliasIndicator]dg\[AliasIndicator]\
\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["^\[Backslash][Dagger]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["SuperDagger[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  OverscriptBox[
                    StyleBox["x",
                      "TI"], "_"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "&\[RightModified]_\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["&_", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverBar[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  OverscriptBox[
                    StyleBox["x",
                      "TI"], "\[RightVector]"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "&\[RightModified]\[AliasIndicator]vec\[AliasIndicator]\
\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["&\[Backslash][RightVector]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverVector[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  OverscriptBox[
                    StyleBox["x",
                      "TI"], "~"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "&\[RightModified]~\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["&~", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverTilde[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  OverscriptBox[
                    StyleBox["x",
                      "TI"], "^"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "&\[RightModified]^\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["&^", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverHat[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  OverscriptBox[
                    StyleBox["x",
                      "TI"], "."]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "&\[RightModified].\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["&.", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverDot[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  UnderscriptBox[
                    StyleBox["x",
                      "TI"], "_"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "+\[RightModified]_\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["+_", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["UnderBar[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TBI"],
              " "
            }]], Cell[TextData[{
              StyleBox["StyleBox[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["FontWeight->\"Bold\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, False, False, False, True, False, False, False, True, False, False, 
      False, False, True}},
  CellTags->"S3.10.2"],

Cell["Creating objects with annotated names. ", "Caption",
  CellTags->"S3.10.2"],

Cell[TextData[{
  "Note that with a notebook front end, you can typically change the style of \
text using menu items. Internally the result will be to insert ",
  StyleBox["StyleBox", "MR"],
  " objects, but you do not need to do this explicitly. "
}], "Text",
  CellTags->{"S3.10.2", "2.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["typical default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["SingleLetterItalics", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], 
            Cell["\<\
whether to use italics for single\[Hyphen]letter symbol \
names \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->True},
  CellTags->"S3.10.2"],

Cell["An option for cells in a notebook. ", "Caption",
  CellTags->"S3.10.2"],

Cell[TextData[{
  "It is conventional in traditional mathematical notation that names \
consisting of single ordinary English letters are normally shown in italics, \
while other names are not. If you use ",
  StyleBox["TraditionalForm", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " will by default follow this convention. You can explicitly specify \
whether you want the convention followed by setting the ",
  StyleBox["SingleLetterItalics", "MR"],
  " option for particular cells or cell styles. "
}], "Text",
  CellTags->{"S3.10.2", "2.13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
3.10.3 Letters and Letter\[Hyphen]like Forms\
\>", "Subsection",
  CellTags->{"S3.10.3", "3.1"}],

Cell[CellGroupData[{

Cell["Greek Letters", "Subsubsection",
  CellTags->{"S3.10.3", "3.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["aliases", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Alpha]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Alpha]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["a\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["alpha\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Beta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Beta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["b\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["beta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Gamma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Gamma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["g\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["gamma\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Delta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Delta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["d\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["delta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Epsilon]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Epsilon]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["e\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["epsilon\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CurlyEpsilon]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CurlyEpsilon]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ce\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["cepsilon\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Zeta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Zeta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["z\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["zeta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Eta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Eta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["h\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["et\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["eta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Theta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Theta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["q\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["th\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["theta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CurlyTheta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CurlyTheta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["cq\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["cth\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["ctheta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Iota]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Iota]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["i\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["iota\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Kappa]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Kappa]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["k\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["kappa\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CurlyKappa]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CurlyKappa]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ck\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["ckappa\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Lambda]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Lambda]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["l\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["lambda\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Mu]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Mu]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["m\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["mu\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Nu]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Nu]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["n\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["nu\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Xi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Xi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["x\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["xi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Omicron]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Omicron]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["om\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["omicron\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Pi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Pi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["p\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["pi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CurlyPi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CurlyPi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["cp\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["cpi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Rho]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Rho]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["r\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["rho\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CurlyRho]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CurlyRho]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["cr\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["crho\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Sigma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Sigma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["s\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["sigma\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[FinalSigma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[FinalSigma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["fs\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Tau]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Tau]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["t\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["tau\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Upsilon]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Upsilon]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["u\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["upsilon\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell[""], "\[Null]", "\[Null]"},
                      {Cell["\[Phi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Phi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["f\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["ph\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["phi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CurlyPhi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CurlyPhi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["j\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["cph\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["cphi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Chi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Chi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["c\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["ch\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["chi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Psi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Psi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["y\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["ps\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["psi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Omega]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Omega]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["w\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["omega\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Digamma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Digamma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["di\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["digamma\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Koppa]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Koppa]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ko\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["koppa\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Stigma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Stigma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sti\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["stigma\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Sampi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Sampi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sa\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["sampi\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["aliases", "SO10"],
                          " "
                        }]]},
                      {Cell["\[CapitalAlpha]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalAlpha]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["A\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Alpha\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalBeta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalBeta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["B\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Beta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalGamma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalGamma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["G\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Gamma\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalDelta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalDelta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["D\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Delta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalEpsilon]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalEpsilon]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["E\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Epsilon\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell[""], "\[Null]", "\[Null]"},
                      {Cell["\[CapitalZeta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalZeta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Z\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Zeta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalEta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalEta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["H\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Et\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Eta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalTheta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalTheta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Q\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Th\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Theta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell[""], "\[Null]", "\[Null]"},
                      {Cell["\[CapitalIota]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalIota]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["I\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Iota\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalKappa]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalKappa]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["K\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Kappa\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell[""], "\[Null]", "\[Null]"},
                      {Cell["\[CapitalLambda]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalLambda]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["L\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Lambda\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalMu]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalMu]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["M\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Mu\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalNu]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalNu]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["N\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Nu\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalXi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalXi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["X\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Xi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalOmicron]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalOmicron]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Om\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Omicron\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalPi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalPi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["P\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Pi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell[""], "\[Null]", "\[Null]"},
                      {Cell["\[CapitalRho]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalRho]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["R\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Rho\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell[""], "\[Null]", "\[Null]"},
                      {Cell["\[CapitalSigma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalSigma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["S\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Sigma\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell[""], "\[Null]", "\[Null]"},
                      {Cell["\[CapitalTau]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalTau]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["T\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Tau\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalUpsilon]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalUpsilon]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["U\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Upsilon\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CurlyCapitalUpsilon]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CurlyCapitalUpsilon]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["cU\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["cUpsilon\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalPhi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalPhi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["F\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Ph\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Phi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell[""], "\[Null]", "\[Null]"},
                      {Cell["\[CapitalChi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalChi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["C\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Ch\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Chi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalPsi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalPsi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Y\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Ps\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Psi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalOmega]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalOmega]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["O\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["W\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Omega\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalDigamma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalDigamma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Di\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Digamma\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalKoppa]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalKoppa]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Ko\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Koppa\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalStigma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalStigma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Sti\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Stigma\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalSampi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalSampi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Sa\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Sampi\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.3"],

Cell[TextData[{
  "The complete collection of Greek letters in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S3.10.3"],

Cell[TextData[{
  "You can use Greek letters as the names of symbols. The only Greek letter \
with a built\[Hyphen]in meaning in ",
  StyleBox["StandardForm", "MR"],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  ", which ",
  StyleBox["Mathematica", "TI"],
  " takes to stand for the symbol ",
  StyleBox["Pi", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.3", "3.3"}],

Cell[TextData[{
  "Note that even though ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " on its own is assigned a built\[Hyphen]in meaning, combinations such as \
",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]  2\)], "InlineFormula"],
  " or ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "\[Pi]"}], TraditionalForm]], "InlineFormula"],
  " have no built\[Hyphen]in meanings. "
}], "Text",
  CellTags->{"S3.10.3", "3.4"}],

Cell[TextData[{
  "The Greek letters ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalSigma]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPi]\)], "InlineFormula"],
  " look very much like the operators for sum and product. But as discussed \
above, these operators are different characters, entered as \[Backslash]",
  StyleBox["[Sum]", "MR"],
  " and \[Backslash]",
  StyleBox["[Product]", "MR"],
  " respectively. "
}], "Text",
  CellTags->{"S3.10.3", "3.5"}],

Cell[TextData[{
  "Similarly, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\)], "InlineFormula"],
  " is different from the ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " operator \[Backslash]",
  StyleBox["[Element]", "MR"],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\)], "InlineFormula"],
  " is different from ",
  Cell[BoxData[
      \(TraditionalForm\`\[Micro]\)], "InlineFormula"],
  " or \[Backslash]",
  StyleBox["[Micro]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.3", "3.6"}],

Cell[TextData[{
  "Some capital Greek letters such as \[Backslash]",
  StyleBox["[CapitalAlpha]", "MR"],
  " look essentially the same as capital English letters. ",
  StyleBox["Mathematica", "TI"],
  " however treats them as different characters, and in ",
  StyleBox["TraditionalForm", "MR"],
  " it uses \[Backslash]",
  StyleBox["[CapitalBeta]", "MR"],
  ", for example, to denote the built\[Hyphen]in function ",
  StyleBox["Beta", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.3", "3.7"}],

Cell[TextData[{
  "Following common convention, lower\[Hyphen]case Greek letters are rendered \
slightly slanted in the standard fonts provided with ",
  StyleBox["Mathematica", "TI"],
  ", while capital Greek letters are unslanted. "
}], "Text",
  CellTags->{"S3.10.3", "3.8"}],

Cell[TextData[{
  "Almost all Greek letters that do not look similar to English letters are \
widely used in science and mathematics. The ",
  StyleBox["capital xi", "TB"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalXi]\)], "InlineFormula"],
  " is rare, though it is used to denote the cascade hyperon particles, the \
grand canonical partition function and regular language complexity. The ",
  StyleBox["capital upsilon", "TB"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalUpsilon]\)], "InlineFormula"],
  " is also rare, though it is used to denote ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["b",
            "TI"], 
          OverscriptBox[
            StyleBox["b",
              "TI"], "_"]}], TraditionalForm]], "InlineFormula"],
  " particles, as well as the vernal equinox.  "
}], "Text",
  CellTags->{"S3.10.3", "3.9"}],

Cell[TextData[{
  StyleBox["Curly Greek letters", "TB"],
  " are often assumed to have different meanings from their ordinary \
counterparts. Indeed, in pure mathematics a single formula can sometimes \
contain both curly and ordinary forms of a particular letter. The curly pi ",
  Cell[BoxData[
      \(TraditionalForm\`\[CurlyPi]\)], "InlineFormula"],
  " is rare, except in astronomy. "
}], "Text",
  CellTags->{"S3.10.3", "3.10"}],

Cell[TextData[{
  "The ",
  StyleBox["final sigma", "TB"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[FinalSigma]\)], "InlineFormula"],
  " is used for sigmas that appear at the ends of words in written Greek; it \
is not commonly used in technical notation. "
}], "Text",
  CellTags->{"S3.10.3", "3.11"}],

Cell[TextData[{
  "The ",
  StyleBox["digamma", "TB"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Digamma]\)], "InlineFormula"],
  ", ",
  StyleBox["koppa", "TB"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Koppa]\)], "InlineFormula"],
  ", ",
  StyleBox["stigma", "TB"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Stigma]\)], "InlineFormula"],
  " and ",
  StyleBox["sampi", "TB"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sampi]\)], "InlineFormula"],
  " are archaic Greek letters. These letters provide a convenient extension \
to the usual set of Greek letters. They are sometimes needed in making \
correspondences with English letters. The digamma corresponds to an English \
w, and koppa to an English q. Digamma is occasionally used to denote the \
digamma function ",
  StyleBox["PolyGamma[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.3", "3.12"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Variants of English Letters", "Subsubsection",
  CellTags->{"S3.10.3", "3.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[ScriptL]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ScriptL]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["scl\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ScriptCapitalE]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ScriptCapitalE]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["scE\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ScriptCapitalH]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ScriptCapitalH]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["scH\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ScriptCapitalL]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ScriptCapitalL]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["scL\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[GothicCapitalC]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GothicCapitalC]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["goC\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[GothicCapitalH]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GothicCapitalH]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["goH\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[GothicCapitalI]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GothicCapitalI]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["goI\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[GothicCapitalR]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GothicCapitalR]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["goR\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[DoubleStruckCapitalC]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleStruckCapitalC]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["dsC\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubleStruckCapitalR]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleStruckCapitalR]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["dsR\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubleStruckCapitalQ]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleStruckCapitalQ]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["dsQ\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubleStruckCapitalZ]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleStruckCapitalZ]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["dsZ\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubleStruckCapitalN]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleStruckCapitalN]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["dsN\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DotlessI]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DotlessI]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DotlessJ]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DotlessJ]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[WeierstrassP]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[WeierstrassP]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["wp\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.3"],

Cell["Some commonly used variants of English letters. ", "Caption",
  CellTags->"S3.10.3"],

Cell[TextData[{
  "By using menu items in the notebook front end, or explicit ",
  StyleBox["StyleBox", "MR"],
  " objects, you can make changes in the font and style of ordinary text. \
However, such changes are usually discarded whenever you send input to the ",
  StyleBox["Mathematica", "TI"],
  " kernel. "
}], "Text",
  CellTags->{"S3.10.3", "3.14"}],

Cell[TextData[{
  "Script, gothic and double\[Hyphen]struck characters are however treated as \
fundamentally different from their ordinary forms. This means that even \
though a ",
  StyleBox["C", "MR"],
  " that is italic or a different size will be considered equivalent to an \
ordinary ",
  StyleBox["C", "MR"],
  " when fed to the kernel, a double\[Hyphen]struck ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\)], "InlineFormula"],
  " will not. "
}], "Text",
  CellTags->{"S3.10.3", "3.15"}],

Cell["\<\
Different styles and sizes of C are treated as the same by the \
kernel. But gothic and double\[Hyphen]struck characters are treated as \
different. \
\>", "MathCaption",
  CellTags->{"S3.10.3", "3.16"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"C", "+", 
      StyleBox["C",
        FontSlant->"Italic"], "+", 
      StyleBox["C",
        FontSize->14], "+", "\[GothicCapitalC]", "+", 
      "\[DoubleStruckCapitalC]"}]], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.10.3"],

Cell[BoxData[
    \(3\ C + \[GothicCapitalC] + \[DoubleStruckCapitalC]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.10.3"]
}, Open  ]],

Cell[TextData[{
  "In standard mathematical notation, capital script and gothic letters are \
sometimes used interchangeably. The double\[Hyphen]struck letters, sometimes \
called blackboard or openface letters, are conventionally used to denote \
specific sets. Thus, for example, ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\)], "InlineFormula"],
  " conventionally denotes the set of complex numbers, and ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\)], "InlineFormula"],
  " the set of integers. "
}], "Text",
  CellTags->{"S3.10.3", "3.17"}],

Cell["\<\
Dotless i and j are not usually taken to be different in meaning \
from ordinary i and j; they are simply used when overscripts are being placed \
on the ordinary characters. \
\>", "Text",
  CellTags->{"S3.10.3", "3.18"}],

Cell[TextData[{
  "\[Backslash]",
  StyleBox["[WeierstrassP]", "MR"],
  " is a notation specifically used for the Weierstrass P function ",
  StyleBox["WeierstrassP", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.3", "3.19"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["full names", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["aliases", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[ScriptA]", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox["[ScriptZ]", "MR"]
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["sca\[AliasIndicator]", "MR"],
              " \[Dash] \[AliasIndicator]",
              StyleBox["scz\[AliasIndicator]", "MR"]
            }]], Cell["lower\[Hyphen]case script letters"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[ScriptCapitalA]", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox["[ScriptCapitalZ]", "MR"]
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["scA\[AliasIndicator]", "MR"],
              " \[Dash] \[AliasIndicator]",
              StyleBox["scZ\[AliasIndicator]", "MR"]
            }]], Cell["upper\[Hyphen]case script letters"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[GothicA]", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox["[GothicZ]", "MR"]
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["goa\[AliasIndicator]", "MR"],
              " \[Dash] \[AliasIndicator]",
              StyleBox["goz\[AliasIndicator]", "MR"]
            }]], Cell["lower\[Hyphen]case gothic letters"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[GothicCapitalA]", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox["[GothicCapitalZ]", "MR"]
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["goA\[AliasIndicator]", "MR"],
              " \[Dash] \[AliasIndicator]",
              StyleBox["goZ\[AliasIndicator]", "MR"]
            }]], Cell["upper\[Hyphen]case gothic letters"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[DoubleStruckA]", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox["[DoubleStruckZ]", "MR"]
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["dsa\[AliasIndicator]", "MR"],
              " \[Dash] \[AliasIndicator]",
              StyleBox["dsz\[AliasIndicator]", "MR"]
            }]], 
            Cell["\<\
lower\[Hyphen]case double\[Hyphen]struck \
letters\
\>"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[DoubleStruckCapitalA]", "MR"],
              "\[NonBreakingSpace]\[Dash] \[Backslash]",
              StyleBox["[DoubleStruckCapitalZ]", "MR"]
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["dsA\[AliasIndicator]", "MR"],
              " \[Dash] \[AliasIndicator]",
              StyleBox["dsZ\[AliasIndicator]", "MR"]
            }]], 
            Cell["\<\
upper\[Hyphen]case double\[Hyphen]struck letters\
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False, True, False, True, False}},
  CellTags->"S3.10.3"],

Cell["Complete alphabets of variant English letters. ", "Caption",
  CellTags->"S3.10.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hebrew Letters", "Subsubsection",
  CellTags->{"S3.10.3", "3.20"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Aleph]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Aleph]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["al\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Bet]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Bet]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[""]},
                      {Cell["\[Gimel]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Gimel]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Dalet]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Dalet]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.3"],

Cell["Hebrew characters. ", "Caption",
  CellTags->"S3.10.3"],

Cell[TextData[{
  "Hebrew characters are used in mathematics in the theory of transfinite \
sets; ",
  Cell[BoxData[
      \(TraditionalForm\`\[Aleph]\_0\)], "InlineFormula"],
  " is for example used to denote the total number of integers. "
}], "Text",
  CellTags->{"S3.10.3", "3.21"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Units and Letter\[Hyphen]like Mathematical Symbols\
\>", \
"Subsubsection",
  CellTags->{"S3.10.3", "3.22"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Micro]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Micro]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["mi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Mho]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Mho]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["mho\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Angstrom]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Angstrom]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Ang\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[HBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[HBar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["hb\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Cent]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Cent]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["cent\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Sterling]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Sterling]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Euro]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Euro]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Yen]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Yen]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Degree]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Degree]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["deg\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EmptySet]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EmptySet]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["es\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Infinity]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Infinity]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["inf\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ExponentialE]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ExponentialE]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ee\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ImaginaryI]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ImaginaryI]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ii\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ImaginaryJ]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ImaginaryJ]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["jj\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubledPi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubledPi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["pp\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubledGamma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubledGamma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["gg\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.3"],

Cell["\<\
Units and letter\[Hyphen]like mathematical symbols. \
\>", "Caption",
  CellTags->"S3.10.3"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " treats ",
  Cell[BoxData[
      \(TraditionalForm\`\[Degree]\)], "InlineFormula"],
  " or \[Backslash]",
  StyleBox["[Degree]", "MR"],
  " as the symbol ",
  StyleBox["Degree", "MR"],
  ", so that, for example, ",
  StyleBox["30", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[Degree]\)], "InlineFormula"],
  " is equivalent to ",
  StyleBox["30", "MR"],
  " ",
  StyleBox["Degree", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.3", "3.23"}],

Cell[TextData[{
  "Note that ",
  Cell[BoxData[
      \(TraditionalForm\`\[Micro]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Angstrom]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[EmptySet]\)], "InlineFormula"],
  " are all distinct from the ordinary letters ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\)], "InlineFormula"],
  " (\[Backslash]",
  StyleBox["[Mu]", "MR"],
  "), ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalARing]\)], "InlineFormula"],
  " (\[Backslash]",
  StyleBox["[CapitalARing]", "MR"],
  ") and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOSlash]\)], "InlineFormula"],
  " (\[Backslash]",
  StyleBox["[CapitalOSlash]", "MR"],
  "). "
}], "Text",
  CellTags->{"S3.10.3", "3.24"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " interprets ",
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  " as ",
  StyleBox["Infinity", "MR"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\)], "InlineFormula"],
  " as ",
  StyleBox["E", "MR"],
  ", and both ",
  Cell[BoxData[
      \(TraditionalForm\`\[ImaginaryI]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[ImaginaryJ]\)], "InlineFormula"],
  " as ",
  StyleBox["I", "MR"],
  ". The characters ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[ImaginaryI]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[ImaginaryJ]\)], "InlineFormula"],
  " are provided as alternatives to the usual upper\[Hyphen]case letters ",
  StyleBox["E", "MR"],
  " and ",
  StyleBox["I", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.3", "3.25"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[DoubledPi]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubledGamma]\)], "InlineFormula"],
  " are not by default assigned meanings in ",
  StyleBox["StandardForm", "MR"],
  ". You can therefore use ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubledPi]\)], "InlineFormula"],
  " to represent a pi that will not automatically be treated as ",
  StyleBox["Pi", "MR"],
  ". In ",
  StyleBox["TraditionalForm", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubledGamma]\)], "InlineFormula"],
  " is interpreted as ",
  StyleBox["EulerGamma", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.3", "3.26"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[PartialD]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[PartialD]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["pd\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DifferentialD]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DifferentialD]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["dd\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalDifferentialD]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalDifferentialD]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["DD\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Del]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Del]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["del\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Sum]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Sum]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sum\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Product]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Product]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["prod\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Transpose]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Transpose]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["tr\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[HermitianConjugate]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[HermitianConjugate]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["hc\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.3"],

Cell["Operators that look like letters. ", "Caption",
  CellTags->"S3.10.3"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\)], "InlineFormula"],
  " is an operator while ",
  Cell[BoxData[
      \(TraditionalForm\`\[HBar]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Degree]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Yen]\)], "InlineFormula"],
  " are ordinary symbols. "
}], "MathCaption",
  CellTags->{"S3.10.3", "3.27"}],

Cell[CellGroupData[{

Cell["\<\
{\[Del] f, \[HBar]^2, 45\[Degree], 5000\[Yen]} // FullForm\
\>", \
"Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.10.3"],

Cell[BoxData[
    TagBox[
      StyleBox[\(List[Del[f], Power[\\[HBar], 2], Times[45, Degree], 
          Times[5000, \\[Yen]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[1]//FullForm= ",
  CellTags->"S3.10.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Shapes, Icons and Geometrical Constructs", "Subsubsection",
  CellTags->{"S3.10.3", "3.28"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[FilledVerySmallSquare]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[FilledVerySmallSquare]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["fvssq\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EmptySmallSquare]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EmptySmallSquare]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["essq\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[FilledSmallSquare]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[FilledSmallSquare]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["fssq\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EmptySquare]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EmptySquare]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["esq\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[GraySquare]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GraySquare]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["gsq\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[FilledSquare]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[FilledSquare]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["fsq\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DottedSquare]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DottedSquare]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[EmptyRectangle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EmptyRectangle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[FilledRectangle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[FilledRectangle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[EmptyDiamond]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EmptyDiamond]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[FilledDiamond]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[FilledDiamond]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[EmptySmallCircle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EmptySmallCircle]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["esci\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[FilledSmallCircle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[FilledSmallCircle]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["fsci\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EmptyCircle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EmptyCircle]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["eci\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[GrayCircle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GrayCircle]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["gci\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[FilledCircle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[FilledCircle]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["fci\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EmptyUpTriangle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EmptyUpTriangle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[FilledUpTriangle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[FilledUpTriangle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[EmptyDownTriangle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EmptyDownTriangle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[FilledDownTriangle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[FilledDownTriangle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[FivePointedStar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[FivePointedStar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["*5\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[SixPointedStar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SixPointedStar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["*6\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.3"],

Cell["Shapes. ", "Caption",
  CellTags->"S3.10.3"],

Cell[TextData[{
  "Shapes are most often used as \[OpenCurlyDoubleQuote]dingbats\
\[CloseCurlyDoubleQuote] to emphasize pieces of text. But ",
  StyleBox["Mathematica", "TI"],
  " treats them as letter\[Hyphen]like forms, and also allows them to appear \
in the names of symbols. "
}], "Text",
  CellTags->{"S3.10.3", "3.29"}],

Cell[TextData[{
  "In addition to shapes such as \[Backslash]",
  StyleBox["[EmptySquare]", "MR"],
  ", there are characters such as \[Backslash]",
  StyleBox["[Square]", "MR"],
  " which are treated by ",
  StyleBox["Mathematica", "TI"],
  " as operators rather than letter\[Hyphen]like forms. "
}], "Text",
  CellTags->{"S3.10.3", "3.30"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[MathematicaIcon]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[MathematicaIcon]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["math\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[KernelIcon]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[KernelIcon]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LightBulb]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LightBulb]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[WarningSign]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[WarningSign]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[WatchIcon]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[WatchIcon]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["aliases", "SO10"],
                          " "
                        }]]},
                      {Cell["\[HappySmiley]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[HappySmiley]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox[":)\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox[":-)\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NeutralSmiley]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NeutralSmiley]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox[":-|\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[SadSmiley]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SadSmiley]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox[":-(\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[FreakedSmiley]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[FreakedSmiley]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox[":-@\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Wolf]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Wolf]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["wf\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["wolf\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.3"],

Cell["Icons. ", "Caption",
  CellTags->"S3.10.3"],

Cell["\<\
You can use icon characters just like any other letter\[Hyphen]like \
forms. \
\>", "MathCaption",
  CellTags->{"S3.10.3", "3.31"}],

Cell[CellGroupData[{

Cell["Expand[(\[HappySmiley] + \[Wolf])^4]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.10.3"],

Cell[BoxData[
    \(\[HappySmiley]\^4 + 4\ \[HappySmiley]\^3\ \[Wolf] + 
      6\ \[HappySmiley]\^2\ \[Wolf]\^2 + 
      4\ \[HappySmiley]\ \[Wolf]\^3 + \[Wolf]\^4\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.10.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[" "]},
                      {Cell["\[Angle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Angle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightAngle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightAngle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[MeasuredAngle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[MeasuredAngle]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[" "]},
                      {Cell["\[SphericalAngle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SphericalAngle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[EmptyUpTriangle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EmptyUpTriangle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Diameter]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Diameter]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.3"],

Cell["Notation for geometrical constructs. ", "Caption",
  CellTags->"S3.10.3"],

Cell[TextData[{
  "Since ",
  StyleBox["Mathematica", "TI"],
  " treats characters like ",
  Cell[BoxData[
      \(TraditionalForm\`\[Angle]\)], "InlineFormula"],
  " as letter\[Hyphen]like forms, constructs like ",
  Cell[BoxData[
      \(TraditionalForm\`\[Angle]\)], "InlineFormula"],
  "BC are treated in ",
  StyleBox["Mathematica", "TI"],
  " as single symbols. "
}], "Text",
  CellTags->{"S3.10.3", "3.32"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Textual Elements", "Subsubsection",
  CellTags->{"S3.10.3", "3.33"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Dash]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Dash]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["-\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LongDash]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LongDash]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["--\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Bullet]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Bullet]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["bu\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Paragraph]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Paragraph]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Section]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Section]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DownQuestion]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownQuestion]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["d?\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DownExclamation]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownExclamation]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["d!\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Prime]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Prime]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoublePrime]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoublePrime]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["''\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ReversePrime]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ReversePrime]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ReverseDoublePrime]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ReverseDoublePrime]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["``\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LeftGuillemet]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftGuillemet]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["g<<\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[RightGuillemet]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightGuillemet]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["g>>\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Ellipsis]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Ellipsis]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["...\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.3"],

Cell["Characters used for punctuation and annotation. ", "Caption",
  CellTags->"S3.10.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[""]},
                      {Cell["\[Copyright]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Copyright]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RegisteredTrademark]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RegisteredTrademark]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Trademark]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Trademark]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Flat]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Flat]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Natural]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Natural]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Sharp]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Sharp]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Dagger]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Dagger]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["dg\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubleDagger]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleDagger]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ddg\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ClubSuit]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ClubSuit]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DiamondSuit]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DiamondSuit]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[HeartSuit]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[HeartSuit]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[SpadeSuit]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SpadeSuit]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.3"],

Cell["Other characters used in text. ", "Caption",
  CellTags->"S3.10.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[HorizontalLine]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[HorizontalLine]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["hline\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[VerticalLine]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[VerticalLine]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["vline\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Ellipsis]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Ellipsis]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["...\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CenterEllipsis]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CenterEllipsis]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[VerticalEllipsis]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[VerticalEllipsis]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[AscendingEllipsis]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[AscendingEllipsis]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DescendingEllipsis]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DescendingEllipsis]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[UnderParenthesis]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UnderParenthesis]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["u(\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[OverParenthesis]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[OverParenthesis]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o(\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[UnderBracket]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UnderBracket]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["u[\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[OverBracket]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[OverBracket]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o[\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[UnderBrace]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UnderBrace]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["u", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`{\)], "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[OverBrace]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[OverBrace]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`{\)], "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.3"],

Cell["Characters used in building sequences and arrays. ", "Caption",
  CellTags->"S3.10.3"],

Cell["\<\
The under and over braces grow to enclose the whole expression. \
\
\>", "MathCaption",
  CellTags->{"S3.10.3", "3.34"}],

Cell[CellGroupData[{

Cell["\<\
Underoverscript[Expand[(1 + x)^4], \\[UnderBrace], \\[OverBrace]]\
\
\>", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.10.3"],

Cell[BoxData[
    \(\(1 + 4\ x + 6\ x\^2 + 4\ x\^3 + \
x\^4\)\+\[UnderBrace]\%\[OverBrace]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.10.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extended Latin Letters", "Subsubsection",
  CellTags->{"S3.10.3", "3.35"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " supports all the characters commonly used in Western European languages \
based on Latin scripts. "
}], "Text",
  CellTags->{"S3.10.3", "3.36"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[AGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[AGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["a`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[AAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[AAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["a'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[AHat]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[AHat]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["a^\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ATilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ATilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["a~\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ADoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ADoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["a\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ARing]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ARing]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ao\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ABar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ABar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["a-\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ACup]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ACup]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["au\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[AE]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[AE]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ae\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["c'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CCedilla]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CCedilla]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["c,\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CHacek]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CHacek]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["cv\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["e`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["e'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EBar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["e-\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EHat]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EHat]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["e^\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EDoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EDoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["e\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ECup]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ECup]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["eu\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[IGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[IGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["i`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[IAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[IAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["i'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[IHat]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[IHat]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["i^\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[IDoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[IDoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["i\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ICup]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ICup]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["iu\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Eth]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Eth]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["d-\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LSlash]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LSlash]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["l/\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["n~\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[OGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[OGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[OAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[OAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[OHat]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[OHat]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o^\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[OTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[OTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o~\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ODoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ODoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ODoubleAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ODoubleAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o''\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[OSlash]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[OSlash]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o/\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[SHacek]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SHacek]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sv\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[UGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["u`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[UAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["u'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[UHat]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UHat]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["u^\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[UDoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UDoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["u\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[UDoubleAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UDoubleAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["u''\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[YAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[YAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["y'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Thorn]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Thorn]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["thn\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[SZ]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SZ]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sz\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["ss\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[CapitalAGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalAGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["A`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalAAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalAAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["A'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalAHat]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalAHat]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["A^\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalATilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalATilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["A~\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalADoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalADoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["A\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalARing]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalARing]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Ao\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalABar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalABar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["A-\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalACup]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalACup]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Au\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalAE]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalAE]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["AE\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalCAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalCAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["C'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalCCedilla]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalCCedilla]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["C,\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalCHacek]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalCHacek]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Cv\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalEGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalEGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["E`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalEAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalEAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["E'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalEBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalEBar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["E-\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalEHat]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalEHat]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["E^\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalEDoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalEDoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["E\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalECup]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalECup]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Eu\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalIGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalIGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["I`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalIAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalIAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["I'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalIHat]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalIHat]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["I^\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalIDoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalIDoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["I\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalICup]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalICup]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Iu\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalEth]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalEth]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["D-\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalLSlash]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalLSlash]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["L/\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalNTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalNTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["N~\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalOGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalOGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["O`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalOAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalOAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["O'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalOHat]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalOHat]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["O^\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalOTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalOTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["O~\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalODoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalODoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["O\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalODoubleAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalODoubleAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["O''\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalOSlash]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalOSlash]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["O/\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalSHacek]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalSHacek]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Sv\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalUGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalUGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["U`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalUAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalUAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["U'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalUHat]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalUHat]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["U^\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalUDoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalUDoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["U\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalUDoubleAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalUDoubleAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["U''\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalYAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalYAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Y'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalThorn]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalThorn]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Thn\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.3"],

Cell["Variants of English letters. ", "Caption",
  CellTags->"S3.10.3"],

Cell[TextData[{
  "Most of the characters shown are formed by adding diacritical marks to \
ordinary English letters. Exceptions include \[Backslash]",
  StyleBox["[SZ]", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[SZ]\)], "InlineFormula"],
  ", used in German, and \[Backslash]",
  StyleBox["[Thorn]", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Thorn]\)], "InlineFormula"],
  " and \[Backslash]",
  StyleBox["[Eth]", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Eth]\)], "InlineFormula"],
  ", used primarily in Old English. "
}], "Text",
  CellTags->{"S3.10.3", "3.37"}],

Cell["\<\
You can make additional characters by explicitly adding diacritical \
marks yourself. \
\>", "Text",
  CellTags->{"S3.10.3", "3.38"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["char", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]&\[RightModified]", "MR"],
              
              " ",
              StyleBox["mark", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  \[Backslash]",
              StyleBox["(", "MR"],
              StyleBox["char", "TI"],
              "\[Backslash]",
              StyleBox["&", "MR"],
              StyleBox["mark", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              " "
            }]], Cell["add a mark above a character "]},
          {Cell[TextData[{
              StyleBox["char", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]+\[RightModified]", "MR"],
              
              " ",
              StyleBox["mark", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  \[Backslash]",
              StyleBox["(", "MR"],
              StyleBox["char", "TI"],
              "\[Backslash]",
              StyleBox["+", "MR"],
              StyleBox["mark", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              " "
            }]], Cell["add a mark below a character "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.10.3"],

Cell["Adding marks above and below characters. ", "Caption",
  CellTags->"S3.10.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["alias", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["full name", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`'\)], "InlineFormula"],
              " "
            }]], Cell["(keyboard character) "], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[RawQuote]", "MR"],
              " "
            }]], Cell["acute accent "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Prime]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["'\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Prime]", "MR"],
              " "
            }]], Cell["acute accent "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\``\)], "InlineFormula"],
              " "
            }]], Cell["(keyboard character) "], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[RawBackquote]", "MR"],
              " "
            }]], Cell["grave accent "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[ReversePrime]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["`\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[ReversePrime]", "MR"],
              " "
            }]], Cell["grave accent "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\(\(\(.\)\(\ \)\)\(.\)\)\)], 
                "InlineFormula"],
              " "
            }]], Cell["(keyboard characters) "], Cell[""], Cell[
            "umlaut or diaeresis "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`^\)], "InlineFormula"],
              " "
            }]], Cell["(keyboard character) "], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[RawWedge]", "MR"],
              " "
            }]], Cell["circumflex or hat "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[EmptySmallCircle]\)], "InlineFormula"],
              
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["esci\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[EmptySmallCircle]", "MR"],
              " "
            }]], Cell["ring "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\` . \)], "InlineFormula"],
              " "
            }]], Cell["(keyboard character) "], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[RawDot]", "MR"],
              " "
            }]], Cell["dot "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`~\)], "InlineFormula"],
              " "
            }]], Cell["(keyboard character) "], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[RawTilde]", "MR"],
              " "
            }]], Cell["tilde "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`_\)], "InlineFormula"],
              " "
            }]], Cell["(keyboard character) "], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[RawUnderscore]", "MR"],
              " "
            }]], Cell["bar or macron "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Hacek]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["hc\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Hacek]", "MR"],
              " "
            }]], Cell["hacek or check "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Breve]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["bv\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Breve]", "MR"],
              " "
            }]], Cell["breve "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[DownBreve]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["dbv\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[DownBreve]", "MR"],
              " "
            }]], Cell["tie accent "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[DoublePrime]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["''\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[DoublePrime]", "MR"],
              " "
            }]], Cell["long umlaut "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Cedilla]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["cd\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Cedilla]", "MR"],
              " "
            }]], Cell["cedilla "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox4Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, False, False, False, False, False, False, False, False, False, 
      False, False, False, False, True}},
  CellTags->"S3.10.3"],

Cell["Diacritical marks to add to characters. ", "Caption",
  CellTags->"S3.10.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.10.4 Operators", "Subsection",
  CellTags->{"S3.10.4", "4.1"}],

Cell[CellGroupData[{

Cell["Basic Mathematical Operators", "Subsubsection",
  CellTags->{"S3.10.4", "4.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Times]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Times]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["*\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Divide]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Divide]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["div\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Sqrt]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Sqrt]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sqrt\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Cross]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Cross]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["cross\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[PlusMinus]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[PlusMinus]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["+-\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[MinusPlus]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[MinusPlus]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["-+\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell["Some operators used in basic arithmetic and algebra. ", "Caption",
  CellTags->"S3.10.4"],

Cell[TextData[{
  "Note that the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Cross]\)], "InlineFormula"],
  " for \[Backslash]",
  StyleBox["[Cross]", "MR"],
  " is distinguished by being drawn slightly smaller than the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Times]\)], "InlineFormula"],
  " for \[Backslash]",
  StyleBox["[Times]", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.10.4", "4.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Times]\)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Times[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["multiplication "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Divide]\)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Divide[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["division "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Sqrt]\)], "InlineFormula"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Sqrt[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["square root "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cross]\)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Cross[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["vector cross product "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[PlusMinus]\)], "InlineFormula"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["PlusMinus[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["(no built\[Hyphen]in meaning) "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[PlusMinus]\)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["PlusMinus[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["(no built\[Hyphen]in meaning) "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[MinusPlus]\)], "InlineFormula"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["MinusPlus[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["(no built\[Hyphen]in meaning) "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[MinusPlus]\)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["MinusPlus[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["(no built\[Hyphen]in meaning) "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, True, False}},
  CellTags->"S3.10.4"],

Cell["\<\
Interpretation of some operators in basic arithmetic and algebra. \
\
\>", "Caption",
  CellTags->"S3.10.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operators in Calculus and Algebra", "Subsubsection",
  CellTags->{"S3.10.4", "4.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Del]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Del]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["del\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[PartialD]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[PartialD]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["pd\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DifferentialD]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DifferentialD]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["dd\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Sum]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Sum]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sum\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Product]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Product]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["prod\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Integral]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Integral]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["int\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ContourIntegral]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ContourIntegral]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["cint\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubleContourIntegral]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleContourIntegral]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[CounterClockwiseContourIntegral]"], Cell[
                        TextData[{
                          "\[Backslash]",
                          StyleBox["[CounterClockwiseContourIntegral]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["cccint\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ClockwiseContourIntegral]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ClockwiseContourIntegral]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ccint\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell["Operators used in calculus. ", "Caption",
  CellTags->"S3.10.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["aliases", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Conjugate]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Conjugate]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["co\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["conj\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Transpose]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Transpose]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["tr\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[ConjugateTranspose]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ConjugateTranspose]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ct\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[HermitianConjugate]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[HermitianConjugate]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["hc\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell["Operators for complex numbers and matrices. ", "Caption",
  CellTags->"S3.10.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Logical and Other Connectives", "Subsubsection",
  CellTags->{"S3.10.4", "4.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["aliases", "SO10"],
                          " "
                        }]]},
                      {Cell["\[And]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[And]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["&&\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["and\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Or]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Or]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["||\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["or\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Not]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Not]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["not\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Element]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Element]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["el\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ForAll]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ForAll]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["fa\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Exists]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Exists]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ex\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotExists]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotExists]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!ex\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Xor]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Xor]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["xor\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Nand]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Nand]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["nand\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Nor]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Nor]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["nor\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Implies]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Implies]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["=>\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[RoundImplies]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RoundImplies]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Therefore]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Therefore]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["tf\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Because]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Because]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightTee]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightTee]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftTee]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftTee]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DoubleRightTee]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleRightTee]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DoubleLeftTee]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleLeftTee]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[SuchThat]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SuchThat]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["st\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[VerticalSeparator]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[VerticalSeparator]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["|\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Colon]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Colon]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox[":\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell["Operators used as logical connectives. ", "Caption",
  CellTags->"S3.10.4"],

Cell[TextData[{
  "The operators ",
  Cell[BoxData[
      \(TraditionalForm\` \[And] \)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\` \[Or] \)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Not] \)], "InlineFormula"],
  " are interpreted as corresponding to the built\[Hyphen]in functions ",
  StyleBox["And", "MR"],
  ", ",
  StyleBox["Or", "MR"],
  " and ",
  StyleBox["Not", "MR"],
  ", and are equivalent to the keyboard operators ",
  StyleBox["&&", "MR"],
  ", ",
  StyleBox["||", "MR"],
  " and ",
  StyleBox["!", "MR"],
  ". The operators ",
  Cell[BoxData[
      \(TraditionalForm\` \[Xor] \)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\` \[Nand] \)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\` \[Nor] \)], "InlineFormula"],
  " correspond to the built\[Hyphen]in functions ",
  StyleBox["Xor", "MR"],
  ", ",
  StyleBox["Nand", "MR"],
  " and ",
  StyleBox["Nor", "MR"],
  ". Note that ",
  Cell[BoxData[
      \(TraditionalForm\`\[Not] \)], "InlineFormula"],
  " is a prefix operator. "
}], "Text",
  CellTags->{"S3.10.4", "4.6"}],

Cell[TextData[{
  StyleBox["x", "TI"],
  Cell[BoxData[
      \(TraditionalForm\` \[Implies] \)], "InlineFormula"],
  StyleBox["y", "TI"],
  " and ",
  StyleBox["x", "TI"],
  Cell[BoxData[
      \(TraditionalForm\` \[RoundImplies] \)], "InlineFormula"],
  StyleBox["y", "TI"],
  " are both taken to give the built\[Hyphen]in function ",
  StyleBox["Implies[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ".  ",
  StyleBox["x", "TI"],
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  StyleBox["y", "TI"],
  " gives the built\[Hyphen]in function ",
  StyleBox["Element[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.10.4", "4.7"}],

Cell[TextData[{
  "This is interpreted using the built\[Hyphen]in functions ",
  StyleBox["And", "MR"],
  " and ",
  StyleBox["Implies", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.4", "4.8"}],

Cell[CellGroupData[{

Cell["3 < 4 \[And] x > 5 \[Implies] y < 7", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.10.4"],

Cell[BoxData[
    \(Implies[x > 5, y < 7]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.10.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " supports most of the standard syntax used in mathematical logic. In ",
  StyleBox["Mathematica", "TI"],
  ", however, the variables that appear in the quantifiers ",
  Cell[BoxData[
      \(TraditionalForm\`\[ForAll] \)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Exists] \)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[NotExists] \)], "InlineFormula"],
  " must appear as subscripts. If they appeared directly after the quantifier \
symbols then there could be a conflict with multiplication operations. "
}], "Text",
  CellTags->{"S3.10.4", "4.9"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[ForAll] \)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Exists] \)], "InlineFormula"],
  " are essentially prefix operators like ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.4", "4.10"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[ForAll] \_x\(\[Exists] \_y \[Phi][x, y]\) // FullForm\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.10.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(ForAll[x, Exists[y, \\[Phi][x, y]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[2]//FullForm= ",
  CellTags->"S3.10.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operators Used to Represent Actions", "Subsubsection",
  CellTags->{"S3.10.4", "4.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[SmallCircle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SmallCircle]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sc\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CirclePlus]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CirclePlus]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["c+\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CircleMinus]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CircleMinus]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["c-\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CircleTimes]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CircleTimes]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["c*\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CircleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CircleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["c.\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Diamond]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Diamond]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["dia\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CenterDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CenterDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox[".\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Star]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Star]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["star\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[VerticalTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[VerticalTilde]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Backslash]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Backslash]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["\\\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Wedge]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Wedge]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["^\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Vee]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Vee]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["v\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Union]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Union]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["un\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[UnionPlus]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UnionPlus]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Intersection]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Intersection]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["inter\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[SquareIntersection]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SquareIntersection]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[SquareUnion]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SquareUnion]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Coproduct]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Coproduct]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["coprod\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Cap]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Cap]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Cup]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Cup]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Square]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Square]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sq\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell[TextData[{
  "Operators typically used to represent actions. All the operators except \
\[Backslash]",
  StyleBox["[Square]", "MR"],
  " are infix. "
}], "Caption",
  CellTags->"S3.10.4"],

Cell[TextData[{
  "Following ",
  StyleBox["Mathematica", "TI"],
  "'s usual convention, all the operators in the table above are interpreted \
to give functions whose names are exactly the names of the characters that \
appear in the operators. "
}], "Text",
  CellTags->{"S3.10.4", "4.12"}],

Cell["\<\
The operators are interpreted as functions with corresponding \
names. \
\>", "MathCaption",
  CellTags->{"S3.10.4", "4.13"}],

Cell[CellGroupData[{

Cell["x \[CirclePlus] y \[Cap] z // FullForm", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.10.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(CirclePlus[x, Cap[y, z]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[1]//FullForm= ",
  CellTags->"S3.10.4"]
}, Open  ]],

Cell[TextData[{
  "All the operators in the table above, except for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Square]\)], "InlineFormula"],
  ", are infix, so that they must appear in between their operands. "
}], "Text",
  CellTags->{"S3.10.4", "4.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bracketing Operators", "Subsubsection",
  CellTags->{"S3.10.4", "4.15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\<\
\[LeftFloor]\
\>"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftFloor]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["lf\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[RightFloor]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightFloor]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["rf\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LeftCeiling]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftCeiling]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["lc\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[RightCeiling]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightCeiling]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["rc\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LeftDoubleBracket]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftDoubleBracket]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["[[\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[RightDoubleBracket]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightDoubleBracket]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["]]\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[LeftAngleBracket]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftAngleBracket]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["<\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[RightAngleBracket]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightAngleBracket]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox[">\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LeftBracketingBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftBracketingBar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["l|\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[RightBracketingBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightBracketingBar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["r|\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LeftDoubleBracketingBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftDoubleBracketingBar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["l||\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[RightDoubleBracketingBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightDoubleBracketingBar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["r||\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell["Characters used as bracketing operators. ", "Caption",
  CellTags->"S3.10.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftFloor]\)], "InlineFormula"],
              StyleBox["x", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[RightFloor]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Floor[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftCeiling]\)], "InlineFormula"],
              StyleBox["x", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[RightCeiling]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Ceiling[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftDoubleBracket]\)], 
                "InlineFormula"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightDoubleBracket]\)], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
              
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightAngleBracket]\)], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["AngleBracket[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftBracketingBar]\)], 
                "InlineFormula"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightBracketingBar]\)], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["BracketingBar[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftDoubleBracketingBar]\)], 
                "InlineFormula"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightDoubleBracketingBar]\)], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["DoubleBracketingBar[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.10.4"],

Cell["Interpretations of bracketing operators. ", "Caption",
  CellTags->"S3.10.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operators Used to Represent Relations", "Subsubsection",
  CellTags->{"S3.10.4", "4.16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Equal]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Equal]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["==\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LongEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LongEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["l=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Congruent]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Congruent]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["===\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Tilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Tilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[TildeTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[TildeTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[TildeEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[TildeEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          StyleBox["=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[TildeFullEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[TildeFullEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          StyleBox["==\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EqualTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EqualTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["=", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[HumpEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[HumpEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["h=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[HumpDownHump]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[HumpDownHump]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[CupCap]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CupCap]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DotEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DotEqual]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[NotEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotCongruent]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotCongruent]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!===\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[NotTildeTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotTildeTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[NotTildeEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotTildeEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          "=\[AliasIndicator]"
                        }]]},
                      {Cell["\[NotTildeFullEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotTildeFullEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          "==\[AliasIndicator]"
                        }]]},
                      {Cell["\[NotEqualTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotEqualTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!=", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[NotHumpEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotHumpEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!h=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotHumpDownHump]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotHumpDownHump]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotCupCap]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotCupCap]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Proportional]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Proportional]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["prop\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Proportion]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Proportion]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell["\<\
Operators usually used to represent similarity or equivalence. \
\
\>", "Caption",
  CellTags->"S3.10.4"],

Cell[TextData[{
  "The special character ",
  Cell[BoxData[
      \(TraditionalForm\` \[Equal] \)], "InlineFormula"],
  " (or \[Backslash]",
  StyleBox["[Equal]", "MR"],
  ") is an alternative input form for ",
  StyleBox["==", "MR"],
  ". ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotEqual] \)], "InlineFormula"],
  "\[NonBreakingSpace]is used both for input and output. "
}], "MathCaption",
  CellTags->{"S3.10.4", "4.17"}],

Cell[CellGroupData[{

Cell["{a == b, a \[Equal] b, a != b, a \[NotEqual] b}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.10.4"],

Cell[BoxData[
    \({a \[Equal] b, a \[Equal] b, a \[NotEqual] b, 
      a \[NotEqual] b}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.10.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[GreaterEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GreaterEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox[">=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LessEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LessEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["<=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[GreaterSlantEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GreaterSlantEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox[">/\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LessSlantEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LessSlantEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["</\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[GreaterFullEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GreaterFullEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LessFullEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LessFullEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[GreaterTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GreaterTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox[">", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[LessTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LessTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["<", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[GreaterGreater]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GreaterGreater]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LessLess]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LessLess]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NestedGreaterGreater]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NestedGreaterGreater]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NestedLessLess]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NestedLessLess]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[GreaterLess]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GreaterLess]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LessGreater]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LessGreater]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[GreaterEqualLess]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GreaterEqualLess]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LessEqualGreater]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LessEqualGreater]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[NotGreaterEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotGreaterEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!>=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotLessEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotLessEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!<=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotGreaterSlantEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotGreaterSlantEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!>/\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotLessSlantEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotLessSlantEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!</\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotGreaterFullEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotGreaterFullEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotLessFullEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotLessFullEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotGreaterTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotGreaterTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!>", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[NotLessTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotLessTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!<", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`~\)], "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[NotGreaterGreater]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotGreaterGreater]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotLessLess]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotLessLess]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotNestedGreaterGreater]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotNestedGreaterGreater]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotNestedLessLess]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotNestedLessLess]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotGreaterLess]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotGreaterLess]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotLessGreater]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotLessGreater]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotGreater]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotGreater]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!>\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotLess]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotLess]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!<\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell["Operators usually used for ordering by magnitude. ", "Caption",
  CellTags->"S3.10.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Subset]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Subset]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sub\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Superset]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Superset]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sup\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[SubsetEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SubsetEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sub=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[SupersetEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SupersetEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sup=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Element]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Element]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["el\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ReverseElement]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ReverseElement]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["mem\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[NotSubset]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotSubset]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!sub\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotSuperset]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotSuperset]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!sup\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotSubsetEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotSubsetEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!sub=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotSupersetEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotSupersetEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!sup=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotElement]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotElement]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!el\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotReverseElement]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotReverseElement]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!mem\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell["Operators used for relations in sets. ", "Caption",
  CellTags->"S3.10.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[""]},
                      {Cell["\[Succeeds]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Succeeds]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Precedes]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Precedes]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[SucceedsEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SucceedsEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[PrecedesEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[PrecedesEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[SucceedsSlantEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SucceedsSlantEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[PrecedesSlantEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[PrecedesSlantEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[SucceedsTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SucceedsTilde]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[PrecedesTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[PrecedesTilde]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightTriangle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightTriangle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftTriangle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftTriangle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightTriangleEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightTriangleEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftTriangleEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftTriangleEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightTriangleBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightTriangleBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftTriangleBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftTriangleBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[SquareSuperset]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SquareSuperset]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[SquareSubset]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SquareSubset]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[SquareSupersetEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SquareSupersetEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[SquareSubsetEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SquareSubsetEqual]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[""]},
                      {Cell["\[NotSucceeds]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotSucceeds]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotPrecedes]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotPrecedes]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotSucceedsEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotSucceedsEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotPrecedesTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotPrecedesTilde]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotSucceedsSlantEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotSucceedsSlantEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotPrecedesSlantEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotPrecedesSlantEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotSucceedsTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotSucceedsTilde]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotPrecedesEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotPrecedesEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotRightTriangle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotRightTriangle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotLeftTriangle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotLeftTriangle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotRightTriangleEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotRightTriangleEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotLeftTriangleEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotLeftTriangleEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotRightTriangleBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotRightTriangleBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotLeftTriangleBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotLeftTriangleBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotSquareSuperset]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotSquareSuperset]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotSquareSubset]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotSquareSubset]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotSquareSupersetEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotSquareSupersetEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[NotSquareSubsetEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotSquareSubsetEqual]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell["Operators usually used for other kinds of orderings. ", "Caption",
  CellTags->"S3.10.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[VerticalBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[VerticalBar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          StyleBox["|\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubleVerticalBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleVerticalBar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          StyleBox["||\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[NotVerticalBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotVerticalBar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!|\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotDoubleVerticalBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotDoubleVerticalBar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!||\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell["Relational operators based on vertical bars. ", "Caption",
  CellTags->"S3.10.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operators Based on Arrows and Vectors", "Subsubsection",
  CellTags->{"S3.10.4", "4.18"}],

Cell["\<\
Operators based on arrows are often used in pure mathematics and \
elsewhere to represent various kinds of transformations or changes. \
\>", \
"Text",
  CellTags->{"S3.10.4", "4.19"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
  " is equivalent to ",
  StyleBox["->", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.4", "4.20"}],

Cell[CellGroupData[{

Cell["x + y /. x \[Rule] 3", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.10.4"],

Cell[BoxData[
    \(3 + y\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.10.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Rule]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Rule]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["->\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[RuleDelayed]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RuleDelayed]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox[":>\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Implies]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Implies]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["=>\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[RoundImplies]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RoundImplies]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell[TextData[{
  "Arrow\[Hyphen]like operators with built\[Hyphen]in meanings in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S3.10.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[RightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          StyleBox["->\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LeftArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["<-\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LeftRightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftRightArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["<->\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LongRightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LongRightArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["-->\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LongLeftArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LongLeftArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["<--\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LongLeftRightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LongLeftRightArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["<-->\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ShortRightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ShortRightArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[ShortLeftArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ShortLeftArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightTeeArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightTeeArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftTeeArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftTeeArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightArrowBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightArrowBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftArrowBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftArrowBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DoubleRightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleRightArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          StyleBox["=>\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubleLeftArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleLeftArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          StyleBox["<=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubleLeftRightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleLeftRightArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["<=>\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubleLongRightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleLongRightArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["==>\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubleLongLeftArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleLongLeftArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["<==\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubleLongLeftRightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleLongLeftRightArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["<==>\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], ""},
                      {Cell["\[UpArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UpArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DownArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[UpDownArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UpDownArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[UpTeeArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UpTeeArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DownTeeArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownTeeArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[UpArrowBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UpArrowBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DownArrowBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownArrowBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DoubleUpArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleUpArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DoubleDownArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleDownArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DoubleUpDownArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleUpDownArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightArrowLeftArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightArrowLeftArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftArrowRightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftArrowRightArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[UpArrowDownArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UpArrowDownArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DownArrowUpArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownArrowUpArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LowerRightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LowerRightArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LowerLeftArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LowerLeftArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[UpperLeftArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UpperLeftArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[UpperRightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UpperRightArrow]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell["Ordinary arrows. ", "Caption",
  CellTags->"S3.10.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[RightVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightVector]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["vec\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LeftVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftRightVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftRightVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DownRightVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownRightVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DownLeftVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownLeftVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DownLeftRightVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownLeftRightVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightTeeVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightTeeVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftTeeVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftTeeVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DownRightTeeVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownRightTeeVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DownLeftTeeVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownLeftTeeVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightVectorBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightVectorBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftVectorBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftVectorBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DownRightVectorBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownRightVectorBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DownLeftVectorBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownLeftVectorBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Equilibrium]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Equilibrium]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["equi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ReverseEquilibrium]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ReverseEquilibrium]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[""]},
                      {Cell["\[LeftUpVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftUpVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftDownVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftDownVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftUpDownVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftUpDownVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightUpVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightUpVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightDownVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightDownVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightUpDownVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightUpDownVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftUpTeeVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftUpTeeVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftDownTeeVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftDownTeeVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightUpTeeVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightUpTeeVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightDownTeeVector]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightDownTeeVector]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftUpVectorBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftUpVectorBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftDownVectorBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftDownVectorBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightUpVectorBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightUpVectorBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightDownVectorBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightDownVectorBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[UpEquilibrium]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UpEquilibrium]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[ReverseUpEquilibrium]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ReverseUpEquilibrium]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell["Vectors and related arrows. ", "Caption",
  CellTags->"S3.10.4"],

Cell[TextData[{
  "All the arrow and vector\[Hyphen]like operators in ",
  StyleBox["Mathematica", "TI"],
  " are infix. "
}], "MathCaption",
  CellTags->{"S3.10.4", "4.21"}],

Cell[CellGroupData[{

Cell["x \[Equilibrium] y \[UpEquilibrium] z", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.10.4"],

Cell[BoxData[
    \(x \[Equilibrium] y\[UpEquilibrium]z\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S3.10.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[RightTee]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightTee]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["rT\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LeftTee]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftTee]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["lT\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[UpTee]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UpTee]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["uT\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DownTee]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DownTee]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["dT\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[""]},
                      {Cell["\[DoubleRightTee]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleRightTee]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[DoubleLeftTee]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleLeftTee]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.4"],

Cell["Tees. ", "Caption",
  CellTags->"S3.10.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.10.5 Structural Elements and Keyboard Characters", "Subsection",
  CellTags->{"S3.10.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[""], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[InvisibleComma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[InvisibleComma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox[",\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[InvisibleApplication]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[InvisibleApplication]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["@\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[InvisibleSpace]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[InvisibleSpace]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["is\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[""], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[AlignmentMarker]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[AlignmentMarker]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["am\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NoBreak]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NoBreak]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["nb\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Null]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Null]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["null\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.5"],

Cell["Invisible characters. ", "Caption",
  CellTags->"S3.10.5"],

Cell[TextData[{
  "In the input there is an invisible comma between the ",
  StyleBox["1", "MR"],
  " and ",
  StyleBox["2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.5", "5.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(m\_\(1\[InvisibleComma]2\)\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S3.10.5"],

Cell[BoxData[
    \(m\_\(1, 2\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S3.10.5"]
}, Open  ]],

Cell[TextData[{
  "Here there is an invisible space between the ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ", interpreted as multiplication. "
}], "MathCaption",
  CellTags->{"S3.10.5", "5.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[x\[InvisibleSpace]y]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S3.10.5"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Times[x, y]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[2]//FullForm= ",
  CellTags->"S3.10.5"]
}, Open  ]],

Cell[TextData[{
  "\[Backslash]",
  StyleBox["[Null]", "MR"],
  " does not display, but can take modifications such as superscripts. "
}], "MathCaption",
  CellTags->{"S3.10.5", "5.4"}],

Cell[CellGroupData[{

Cell["\\!\\(f[x, \\[Null]\\^a]\\)", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S3.10.5"],

Cell[BoxData[
    \(f[x, \[Null]\^a]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S3.10.5"]
}, Open  ]],

Cell[TextData[{
  "The \[Backslash]",
  StyleBox["[AlignmentMarker]", "MR"],
  " does not display, but shows how to line up the elements of the column. "
}], "MathCaption",
  CellTags->{"S3.10.5", "5.5"}],

Cell[CellGroupData[{

Cell["\<\
GridBox[{{\"b \\[AlignmentMarker]+ c + d\"}, {\"a + b \
\\[AlignmentMarker]+ c\"}}, ColumnAlignments->\"\\[AlignmentMarker]\"] // \
DisplayForm\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S3.10.5"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(b\ \[AlignmentMarker] + \ c\  + \ d\)},
          {\(a\  + \ b\ \[AlignmentMarker] + \ c\)}
          },
        ColumnAlignments->{"\[AlignmentMarker]"}],
      DisplayForm]], "Output",
  CellLabel->"Out[4]//DisplayForm= ",
  CellTags->"S3.10.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[""], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\<\
\[VeryThinSpace]\
\>"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[VeryThinSpace]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[ThinSpace]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ThinSpace]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[MediumSpace]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[MediumSpace]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[ThickSpace]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ThickSpace]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[InvisibleSpace]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[InvisibleSpace]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["is\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\<\

\
\>"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NewLine]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[""], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[NegativeVeryThinSpace]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NegativeVeryThinSpace]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["-", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[NegativeThinSpace]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NegativeThinSpace]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["-", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[NegativeMediumSpace]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NegativeMediumSpace]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["-", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[NegativeThickSpace]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NegativeThickSpace]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["-", "MR"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          "\[AliasIndicator]"
                        }]]},
                      {Cell["\[NonBreakingSpace]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NonBreakingSpace]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["nbs\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[IndentingNewLine]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[IndentingNewLine]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["nl\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.5"],

Cell["Spacing and newline characters. ", "Caption",
  CellTags->"S3.10.5"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[SelectionPlaceholder]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SelectionPlaceholder]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["spl\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Placeholder]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Placeholder]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["pl\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.5"],

Cell["Characters used in buttons. ", "Caption",
  CellTags->"S3.10.5"],

Cell[TextData[{
  "In the buttons in a palette, you often want to set up a template with \
placeholders to indicate where expressions should be inserted. \[Backslash]",
  StyleBox["[SelectionPlaceholder]", "MR"],
  " marks the position where an expression that is currently selected should \
be inserted when the contents of the button are pasted. \[Backslash]",
  StyleBox["[Placeholder]", "MR"],
  " marks other positions where subsequent expressions can be inserted. The \
Tab key will take you from one such position to the next. "
}], "Text",
  CellTags->{"S3.10.5", "5.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[SpaceIndicator]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SpaceIndicator]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["space\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ReturnIndicator]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ReturnIndicator]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ret\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ReturnKey]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ReturnKey]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          StyleBox["ret\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EnterKey]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EnterKey]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ent\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EscapeKey]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EscapeKey]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          StyleBox["esc\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[AliasIndicator]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[AliasIndicator]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["esc\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[RoundSpaceIndicator]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RoundSpaceIndicator]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[ControlKey]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ControlKey]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ctrl\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CommandKey]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CommandKey]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["cmd\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LeftModified]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftModified]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["[\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[RightModified]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightModified]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["]\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CloverLeaf]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CloverLeaf]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["cl\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.5"],

Cell["Representations of keys on a keyboard. ", "Caption",
  CellTags->"S3.10.5"],

Cell[TextData[{
  "In describing how to enter input into ",
  StyleBox["Mathematica", "TI"],
  ", it is sometimes useful to give explicit representations for keys you \
should press. You can do this using characters like ",
  Cell[BoxData[
      \(TraditionalForm\`\[ReturnIndicator]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[EscapeKey]\)], "InlineFormula"],
  ". Note that ",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[RoundSpaceIndicator]\)], "InlineFormula"],
  " are actually treated as spacing characters by ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S3.10.5", "5.7"}],

Cell[TextData[{
  "This string shows how to type ",
  Cell[BoxData[
      \(\[Alpha]\^2\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S3.10.5", "5.8"}],

Cell[CellGroupData[{

Cell["\<\
\"\\[EscapeKey]a\\[EscapeKey] \
\\[ControlKey]\\[LeftModified]^\\[RightModified]2 \
\\[ControlKey]\\[LeftModified]\\[SpaceIndicator]\\[RightModified]\"\
\>", \
"Input",
  CellLabel->"In[5]:= ",
  CellTags->"S3.10.5"],

Cell[BoxData[
    \("\[EscapeKey]a\[EscapeKey] \
\[ControlKey]\[LeftModified]^\[RightModified]2 \[ControlKey]\[LeftModified]\
\[SpaceIndicator]\[RightModified]"\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S3.10.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[""]},
                      {Cell["\[Continuation]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Continuation]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[LeftSkeleton]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftSkeleton]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightSkeleton]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightSkeleton]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[""]},
                      {Cell["\[SkeletonIndicator]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SkeletonIndicator]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[ErrorIndicator]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ErrorIndicator]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.5"],

Cell[TextData[{
  "Characters generated in ",
  StyleBox["Mathematica", "SO"],
  " output. "
}], "Caption",
  CellTags->"S3.10.5"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " uses a \[Backslash]",
  StyleBox["[Continuation]", "MR"],
  " character to indicate that the number continues onto the next line. "
}], "MathCaption",
  CellTags->{"S3.10.5", "5.9"}],

Cell[CellGroupData[{

Cell["60!", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S3.10.5"],

Cell[BoxData[
    \(832098711274139014427634118322336438075417260636124595244927769640960000\
0000000000\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S3.10.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[""]},
                      {Cell["\t"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawTab]", "MR"]
                        }]], Cell[""]},
                      {Cell["\<\

\
\>"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NewLine]", "MR"]
                        }]], Cell[""]},
                      {Cell["\<\

\
\>"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawReturn]", "MR"]
                        }]], Cell[""]},
                      {Cell[" "], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawSpace]", "MR"]
                        }]], Cell[""]},
                      {Cell["!"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawExclamation]", "MR"]
                        }]], Cell[""]},
                      {Cell["\""], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawDoubleQuote]", "MR"]
                        }]], Cell[""]},
                      {Cell["#"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawNumberSign]", "MR"]
                        }]], Cell[""]},
                      {Cell["$"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawDollar]", "MR"]
                        }]], Cell[""]},
                      {Cell["%"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawPercent]", "MR"]
                        }]], Cell[""]},
                      {Cell["&"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawAmpersand]", "MR"]
                        }]], Cell[""]},
                      {Cell["'"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawQuote]", "MR"]
                        }]], Cell[""]},
                      {Cell["("], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawLeftParenthesis]", "MR"]
                        }]], Cell[""]},
                      {Cell[")"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawRightParenthesis]", "MR"]
                        }]], Cell[""]},
                      {Cell["*"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawStar]", "MR"]
                        }]], Cell[""]},
                      {Cell["+"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawPlus]", "MR"]
                        }]], Cell[""]},
                      {Cell[","], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawComma]", "MR"]
                        }]], Cell[""]},
                      {Cell["-"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawDash]", "MR"]
                        }]], Cell[""]},
                      {Cell["."], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawDot]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["form", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[""]},
                      {Cell["/"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawSlash]", "MR"]
                        }]], Cell[""]},
                      {Cell[":"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawColon]", "MR"]
                        }]], Cell[""]},
                      {Cell[";"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawSemicolon]", "MR"]
                        }]], Cell[""]},
                      {Cell["<"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawLess]", "MR"]
                        }]], Cell[""]},
                      {Cell["="], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawEqual]", "MR"]
                        }]], Cell[""]},
                      {Cell[">"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawGreater]", "MR"]
                        }]], Cell[""]},
                      {Cell["?"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawQuestion]", "MR"]
                        }]], Cell[""]},
                      {Cell["@"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawAt]", "MR"]
                        }]], Cell[""]},
                      {Cell["["], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawLeftBracket]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Backslash]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawBackslash]", "MR"]
                        }]], Cell[""]},
                      {Cell["]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawRightBracket]", "MR"]
                        }]], Cell[""]},
                      {Cell["^"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawWedge]", "MR"]
                        }]], Cell[""]},
                      {Cell["_"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawUnderscore]", "MR"]
                        }]], Cell[""]},
                      {Cell["`"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawBackquote]", "MR"]
                        }]], Cell[""]},
                      {Cell["{"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawLeftBrace]", "MR"]
                        }]], Cell[""]},
                      {Cell["|"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawVerticalBar]", "MR"]
                        }]], Cell[""]},
                      {Cell["}"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawRightBrace]", "MR"]
                        }]], Cell[""]},
                      {Cell["~"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawTilde]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S3.10.5"],

Cell["Raw keyboard characters. ", "Caption",
  CellTags->"S3.10.5"],

Cell[TextData[{
  "The fonts that are distributed with ",
  StyleBox["Mathematica", "TI"],
  " contain their own renderings of many ordinary keyboard characters. The \
reason for this is that standard system fonts often do not contain \
appropriate renderings. For example, ",
  StyleBox["^", "MR"],
  " and ",
  StyleBox["~", "MR"],
  " are often drawn small and above the centerline, while for clarity in ",
  StyleBox["Mathematica", "TI"],
  " they must be drawn larger and centered on the centerline.  "
}], "Text",
  CellTags->{"S3.10.5", "5.10"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S3.10.0"->{
    Cell[1776, 53, 136, 4, 65, "Section",
      CellTags->{"S3.10.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 136, 4, 65, "Section",
      CellTags->{"S3.10.0", "0.1"}]},
  "S3.10.1"->{
    Cell[1937, 61, 79, 1, 70, "Subsection",
      CellTags->{"S3.10.1", "1.1"}],
    Cell[2019, 64, 364, 10, 70, "Text",
      CellTags->{"S3.10.1", "1.2"}],
    Cell[2386, 76, 745, 20, 70, "Text",
      CellTags->{"S3.10.1", "1.3"}],
    Cell[3134, 98, 576, 14, 70, "Text",
      CellTags->{"S3.10.1", "1.4"}],
    Cell[3713, 114, 716, 15, 70, "Text",
      CellTags->{"S3.10.1", "1.5"}],
    Cell[4432, 131, 1195, 38, 70, "FramedBox",
      CellTags->"S3.10.1"],
    Cell[5630, 171, 76, 1, 70, "Caption",
      CellTags->"S3.10.1"],
    Cell[5709, 174, 340, 9, 70, "Text",
      CellTags->{"S3.10.1", "1.6"}],
    Cell[6052, 185, 634, 20, 70, "Text",
      CellTags->{"S3.10.1", "1.7"}],
    Cell[6689, 207, 301, 10, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.8"}],
    Cell[7015, 221, 88, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[7106, 225, 86, 3, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[7207, 231, 273, 9, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.9"}],
    Cell[7505, 244, 93, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[7601, 248, 97, 3, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[7713, 254, 279, 9, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.10"}],
    Cell[8017, 267, 99, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[8119, 271, 116, 3, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[8250, 277, 300, 9, 70, "Text",
      CellTags->{"S3.10.1", "1.11"}],
    Cell[8553, 288, 502, 17, 70, "Text",
      CellTags->{"S3.10.1", "1.12"}],
    Cell[9058, 307, 289, 9, 70, "Text",
      CellTags->{"S3.10.1", "1.13"}],
    Cell[9350, 318, 215, 7, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.14"}],
    Cell[9590, 329, 92, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[9685, 333, 109, 3, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[9809, 339, 180, 6, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.15"}],
    Cell[9992, 347, 112, 3, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[10107, 352, 243, 8, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.16"}],
    Cell[10375, 364, 92, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[10470, 368, 94, 3, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[10579, 374, 437, 15, 70, "Text",
      CellTags->{"S3.10.1", "1.17"}],
    Cell[11019, 391, 581, 18, 70, "Text",
      CellTags->{"S3.10.1", "1.18"}],
    Cell[11603, 411, 175, 5, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.19"}],
    Cell[11803, 420, 99, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[11905, 424, 116, 3, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[12036, 430, 209, 6, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.20"}],
    Cell[12248, 438, 99, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[12350, 442, 224, 8, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.21"}],
    Cell[12599, 454, 99, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[12701, 458, 100, 3, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[12816, 464, 398, 11, 70, "Text",
      CellTags->{"S3.10.1", "1.22"}],
    Cell[13217, 477, 342, 9, 70, "Text",
      CellTags->{"S3.10.1", "1.23"}],
    Cell[13562, 488, 415, 9, 70, "Text",
      CellTags->{"S3.10.1", "1.24"}],
    Cell[13980, 499, 1852, 49, 70, "DefinitionBox",
      CellTags->"S3.10.1"],
    Cell[15835, 550, 71, 1, 70, "Caption",
      CellTags->"S3.10.1"],
    Cell[15909, 553, 280, 6, 70, "Text",
      CellTags->{"S3.10.1", "1.25"}],
    Cell[16192, 561, 447, 14, 70, "Text",
      CellTags->{"S3.10.1", "1.26"}],
    Cell[16642, 577, 632, 15, 70, "Text",
      CellTags->{"S3.10.1", "1.27"}],
    Cell[17277, 594, 7849, 180, 70, "DoubleBox",
      CellTags->"S3.10.1"],
    Cell[25129, 776, 82, 1, 70, "Caption",
      CellTags->"S3.10.1"],
    Cell[25214, 779, 357, 10, 70, "Text",
      CellTags->{"S3.10.1", "1.28"}],
    Cell[25574, 791, 102, 1, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.29"}],
    Cell[25701, 796, 126, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[25830, 800, 120, 3, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[25965, 806, 284, 8, 70, "Text",
      CellTags->{"S3.10.1", "1.30"}],
    Cell[26252, 816, 413, 12, 70, "Text",
      CellTags->{"S3.10.1", "1.31"}],
    Cell[26668, 830, 451, 13, 70, "Text",
      CellTags->{"S3.10.1", "1.32"}],
    Cell[27122, 845, 236, 7, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.33"}],
    Cell[27383, 856, 119, 3, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[27505, 861, 106, 3, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[27626, 867, 490, 10, 70, "Text",
      CellTags->{"S3.10.1", "1.34"}],
    Cell[28119, 879, 355, 11, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.35"}],
    Cell[28499, 894, 111, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[28613, 898, 254, 8, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[28882, 909, 233, 7, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.36"}],
    Cell[29140, 920, 97, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[29240, 924, 247, 8, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[29502, 935, 886, 26, 70, "Text",
      CellTags->{"S3.10.1", "1.37"}],
    Cell[30391, 963, 789, 21, 70, "Text",
      CellTags->{"S3.10.1", "1.38"}],
    Cell[31183, 986, 9836, 225, 70, "DoubleBox",
      CellTags->"S3.10.1"],
    Cell[41022, 1213, 91, 1, 70, "Caption",
      CellTags->"S3.10.1"],
    Cell[41116, 1216, 909, 26, 70, "Text",
      CellTags->{"S3.10.1", "1.39"}],
    Cell[42028, 1244, 169, 5, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.40"}],
    Cell[42222, 1253, 95, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[42320, 1257, 94, 3, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[42429, 1263, 167, 5, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.41"}],
    Cell[42621, 1272, 95, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[42719, 1276, 98, 3, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[42832, 1282, 248, 7, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.42"}],
    Cell[43105, 1293, 94, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[43202, 1297, 101, 3, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[43318, 1303, 589, 17, 70, "Text",
      CellTags->{"S3.10.1", "1.43"}],
    Cell[43910, 1322, 225, 7, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.44"}],
    Cell[44160, 1333, 113, 2, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[44276, 1337, 264, 8, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[44555, 1348, 430, 11, 70, "Text",
      CellTags->{"S3.10.1", "1.45"}],
    Cell[44988, 1361, 676, 18, 70, "Text",
      CellTags->{"S3.10.1", "1.46"}],
    Cell[45667, 1381, 238, 7, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.47"}],
    Cell[45930, 1392, 158, 6, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[46091, 1400, 101, 3, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[46207, 1406, 727, 20, 70, "Text",
      CellTags->{"S3.10.1", "1.48"}],
    Cell[46937, 1428, 322, 11, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.49"}],
    Cell[47284, 1443, 234, 8, 70, "Input",
      CellTags->"S3.10.1"],
    Cell[47521, 1453, 262, 8, 70, "Output",
      CellTags->"S3.10.1"],
    Cell[47798, 1464, 159, 4, 70, "Text",
      CellTags->{"S3.10.1", "1.50"}],
    Cell[47960, 1470, 4062, 126, 70, "DefinitionBox4Col",
      CellTags->"S3.10.1"],
    Cell[52025, 1598, 76, 1, 70, "Caption",
      CellTags->"S3.10.1"],
    Cell[52104, 1601, 710, 17, 70, "Text",
      CellTags->{"S3.10.1", "1.51"}],
    Cell[52817, 1620, 1988, 53, 70, "DefinitionBox",
      CellTags->"S3.10.1"],
    Cell[54808, 1675, 85, 1, 70, "Caption",
      CellTags->"S3.10.1"],
    Cell[54896, 1678, 337, 7, 70, "Text",
      CellTags->{"S3.10.1", "1.52"}],
    Cell[55236, 1687, 223, 5, 70, "Text",
      CellTags->{"S3.10.1", "1.53"}]},
  "1.1"->{
    Cell[1937, 61, 79, 1, 70, "Subsection",
      CellTags->{"S3.10.1", "1.1"}]},
  "1.2"->{
    Cell[2019, 64, 364, 10, 70, "Text",
      CellTags->{"S3.10.1", "1.2"}]},
  "1.3"->{
    Cell[2386, 76, 745, 20, 70, "Text",
      CellTags->{"S3.10.1", "1.3"}]},
  "1.4"->{
    Cell[3134, 98, 576, 14, 70, "Text",
      CellTags->{"S3.10.1", "1.4"}]},
  "1.5"->{
    Cell[3713, 114, 716, 15, 70, "Text",
      CellTags->{"S3.10.1", "1.5"}]},
  "1.6"->{
    Cell[5709, 174, 340, 9, 70, "Text",
      CellTags->{"S3.10.1", "1.6"}]},
  "1.7"->{
    Cell[6052, 185, 634, 20, 70, "Text",
      CellTags->{"S3.10.1", "1.7"}]},
  "1.8"->{
    Cell[6689, 207, 301, 10, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.8"}]},
  "1.9"->{
    Cell[7207, 231, 273, 9, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.9"}]},
  "1.10"->{
    Cell[7713, 254, 279, 9, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.10"}]},
  "1.11"->{
    Cell[8250, 277, 300, 9, 70, "Text",
      CellTags->{"S3.10.1", "1.11"}]},
  "1.12"->{
    Cell[8553, 288, 502, 17, 70, "Text",
      CellTags->{"S3.10.1", "1.12"}]},
  "1.13"->{
    Cell[9058, 307, 289, 9, 70, "Text",
      CellTags->{"S3.10.1", "1.13"}]},
  "1.14"->{
    Cell[9350, 318, 215, 7, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.14"}]},
  "1.15"->{
    Cell[9809, 339, 180, 6, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.15"}]},
  "1.16"->{
    Cell[10107, 352, 243, 8, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.16"}]},
  "1.17"->{
    Cell[10579, 374, 437, 15, 70, "Text",
      CellTags->{"S3.10.1", "1.17"}]},
  "1.18"->{
    Cell[11019, 391, 581, 18, 70, "Text",
      CellTags->{"S3.10.1", "1.18"}]},
  "1.19"->{
    Cell[11603, 411, 175, 5, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.19"}]},
  "1.20"->{
    Cell[12036, 430, 209, 6, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.20"}]},
  "1.21"->{
    Cell[12350, 442, 224, 8, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.21"}]},
  "1.22"->{
    Cell[12816, 464, 398, 11, 70, "Text",
      CellTags->{"S3.10.1", "1.22"}]},
  "1.23"->{
    Cell[13217, 477, 342, 9, 70, "Text",
      CellTags->{"S3.10.1", "1.23"}]},
  "1.24"->{
    Cell[13562, 488, 415, 9, 70, "Text",
      CellTags->{"S3.10.1", "1.24"}]},
  "1.25"->{
    Cell[15909, 553, 280, 6, 70, "Text",
      CellTags->{"S3.10.1", "1.25"}]},
  "1.26"->{
    Cell[16192, 561, 447, 14, 70, "Text",
      CellTags->{"S3.10.1", "1.26"}]},
  "1.27"->{
    Cell[16642, 577, 632, 15, 70, "Text",
      CellTags->{"S3.10.1", "1.27"}]},
  "1.28"->{
    Cell[25214, 779, 357, 10, 70, "Text",
      CellTags->{"S3.10.1", "1.28"}]},
  "1.29"->{
    Cell[25574, 791, 102, 1, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.29"}]},
  "1.30"->{
    Cell[25965, 806, 284, 8, 70, "Text",
      CellTags->{"S3.10.1", "1.30"}]},
  "1.31"->{
    Cell[26252, 816, 413, 12, 70, "Text",
      CellTags->{"S3.10.1", "1.31"}]},
  "1.32"->{
    Cell[26668, 830, 451, 13, 70, "Text",
      CellTags->{"S3.10.1", "1.32"}]},
  "1.33"->{
    Cell[27122, 845, 236, 7, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.33"}]},
  "1.34"->{
    Cell[27626, 867, 490, 10, 70, "Text",
      CellTags->{"S3.10.1", "1.34"}]},
  "1.35"->{
    Cell[28119, 879, 355, 11, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.35"}]},
  "1.36"->{
    Cell[28882, 909, 233, 7, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.36"}]},
  "1.37"->{
    Cell[29502, 935, 886, 26, 70, "Text",
      CellTags->{"S3.10.1", "1.37"}]},
  "1.38"->{
    Cell[30391, 963, 789, 21, 70, "Text",
      CellTags->{"S3.10.1", "1.38"}]},
  "1.39"->{
    Cell[41116, 1216, 909, 26, 70, "Text",
      CellTags->{"S3.10.1", "1.39"}]},
  "1.40"->{
    Cell[42028, 1244, 169, 5, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.40"}]},
  "1.41"->{
    Cell[42429, 1263, 167, 5, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.41"}]},
  "1.42"->{
    Cell[42832, 1282, 248, 7, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.42"}]},
  "1.43"->{
    Cell[43318, 1303, 589, 17, 70, "Text",
      CellTags->{"S3.10.1", "1.43"}]},
  "1.44"->{
    Cell[43910, 1322, 225, 7, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.44"}]},
  "1.45"->{
    Cell[44555, 1348, 430, 11, 70, "Text",
      CellTags->{"S3.10.1", "1.45"}]},
  "1.46"->{
    Cell[44988, 1361, 676, 18, 70, "Text",
      CellTags->{"S3.10.1", "1.46"}]},
  "1.47"->{
    Cell[45667, 1381, 238, 7, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.47"}]},
  "1.48"->{
    Cell[46207, 1406, 727, 20, 70, "Text",
      CellTags->{"S3.10.1", "1.48"}]},
  "1.49"->{
    Cell[46937, 1428, 322, 11, 70, "MathCaption",
      CellTags->{"S3.10.1", "1.49"}]},
  "1.50"->{
    Cell[47798, 1464, 159, 4, 70, "Text",
      CellTags->{"S3.10.1", "1.50"}]},
  "1.51"->{
    Cell[52104, 1601, 710, 17, 70, "Text",
      CellTags->{"S3.10.1", "1.51"}]},
  "1.52"->{
    Cell[54896, 1678, 337, 7, 70, "Text",
      CellTags->{"S3.10.1", "1.52"}]},
  "1.53"->{
    Cell[55236, 1687, 223, 5, 70, "Text",
      CellTags->{"S3.10.1", "1.53"}]},
  "S3.10.2"->{
    Cell[55496, 1697, 102, 1, 70, "Subsection",
      CellTags->{"S3.10.2", "2.1"}],
    Cell[55601, 1700, 200, 5, 70, "Text",
      CellTags->{"S3.10.2", "2.2"}],
    Cell[55804, 1707, 148, 5, 70, "MathCaption",
      CellTags->{"S3.10.2", "2.3"}],
    Cell[55977, 1716, 211, 5, 70, "Input",
      CellTags->"S3.10.2"],
    Cell[56191, 1723, 212, 5, 70, "Output",
      CellTags->"S3.10.2"],
    Cell[56418, 1731, 3429, 106, 70, "DefinitionBox4Col",
      CellTags->"S3.10.2"],
    Cell[59850, 1839, 146, 4, 70, "Caption",
      CellTags->"S3.10.2"],
    Cell[59999, 1845, 514, 16, 70, "Text",
      CellTags->{"S3.10.2", "2.4"}],
    Cell[60516, 1863, 251, 8, 70, "MathCaption",
      CellTags->{"S3.10.2", "2.5"}],
    Cell[60792, 1875, 135, 3, 70, "Input",
      CellTags->"S3.10.2"],
    Cell[60930, 1880, 109, 3, 70, "Output",
      CellTags->"S3.10.2"],
    Cell[61054, 1886, 243, 10, 70, "MathCaption",
      CellTags->{"S3.10.2", "2.6"}],
    Cell[61322, 1900, 78, 2, 70, "Input",
      CellTags->"S3.10.2"],
    Cell[61403, 1904, 87, 2, 70, "Output",
      CellTags->"S3.10.2"],
    Cell[61493, 1908, 118, 5, 70, "Output",
      CellTags->"S3.10.2"],
    Cell[61626, 1916, 334, 7, 70, "Text",
      CellTags->{"S3.10.2", "2.7"}],
    Cell[61963, 1925, 386, 8, 70, "Text",
      CellTags->{"S3.10.2", "2.8"}],
    Cell[62352, 1935, 204, 5, 70, "Text",
      CellTags->{"S3.10.2", "2.9"}],
    Cell[62559, 1942, 229, 5, 70, "Text",
      CellTags->{"S3.10.2", "2.10"}],
    Cell[62791, 1949, 227, 5, 70, "MathCaption",
      CellTags->{"S3.10.2", "2.11"}],
    Cell[63043, 1958, 163, 4, 70, "Input",
      CellTags->"S3.10.2"],
    Cell[63209, 1964, 128, 3, 70, "Output",
      CellTags->"S3.10.2"],
    Cell[63352, 1970, 13273, 377, 70, "DefinitionBox3Col",
      CellTags->"S3.10.2"],
    Cell[76628, 2349, 81, 1, 70, "Caption",
      CellTags->"S3.10.2"],
    Cell[76712, 2352, 294, 6, 70, "Text",
      CellTags->{"S3.10.2", "2.12"}],
    Cell[77009, 2360, 729, 24, 70, "DefinitionBox3Col",
      CellTags->"S3.10.2"],
    Cell[77741, 2386, 77, 1, 70, "Caption",
      CellTags->"S3.10.2"],
    Cell[77821, 2389, 558, 12, 70, "Text",
      CellTags->{"S3.10.2", "2.13"}]},
  "2.1"->{
    Cell[55496, 1697, 102, 1, 70, "Subsection",
      CellTags->{"S3.10.2", "2.1"}]},
  "2.2"->{
    Cell[55601, 1700, 200, 5, 70, "Text",
      CellTags->{"S3.10.2", "2.2"}]},
  "2.3"->{
    Cell[55804, 1707, 148, 5, 70, "MathCaption",
      CellTags->{"S3.10.2", "2.3"}]},
  "2.4"->{
    Cell[59999, 1845, 514, 16, 70, "Text",
      CellTags->{"S3.10.2", "2.4"}]},
  "2.5"->{
    Cell[60516, 1863, 251, 8, 70, "MathCaption",
      CellTags->{"S3.10.2", "2.5"}]},
  "2.6"->{
    Cell[61054, 1886, 243, 10, 70, "MathCaption",
      CellTags->{"S3.10.2", "2.6"}]},
  "2.7"->{
    Cell[61626, 1916, 334, 7, 70, "Text",
      CellTags->{"S3.10.2", "2.7"}]},
  "2.8"->{
    Cell[61963, 1925, 386, 8, 70, "Text",
      CellTags->{"S3.10.2", "2.8"}]},
  "2.9"->{
    Cell[62352, 1935, 204, 5, 70, "Text",
      CellTags->{"S3.10.2", "2.9"}]},
  "2.10"->{
    Cell[62559, 1942, 229, 5, 70, "Text",
      CellTags->{"S3.10.2", "2.10"}]},
  "2.11"->{
    Cell[62791, 1949, 227, 5, 70, "MathCaption",
      CellTags->{"S3.10.2", "2.11"}]},
  "2.12"->{
    Cell[76712, 2352, 294, 6, 70, "Text",
      CellTags->{"S3.10.2", "2.12"}]},
  "2.13"->{
    Cell[77821, 2389, 558, 12, 70, "Text",
      CellTags->{"S3.10.2", "2.13"}]},
  "S3.10.3"->{
    Cell[78416, 2406, 106, 3, 70, "Subsection",
      CellTags->{"S3.10.3", "3.1"}],
    Cell[78547, 2413, 70, 1, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.2"}],
    Cell[78620, 2416, 32666, 644, 70, "DoubleBox",
      CellTags->"S3.10.3"],
    Cell[111289, 3062, 143, 5, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[111435, 3069, 403, 13, 70, "Text",
      CellTags->{"S3.10.3", "3.3"}],
    Cell[111841, 3084, 499, 16, 70, "Text",
      CellTags->{"S3.10.3", "3.4"}],
    Cell[112343, 3102, 503, 14, 70, "Text",
      CellTags->{"S3.10.3", "3.5"}],
    Cell[112849, 3118, 550, 19, 70, "Text",
      CellTags->{"S3.10.3", "3.6"}],
    Cell[113402, 3139, 494, 13, 70, "Text",
      CellTags->{"S3.10.3", "3.7"}],
    Cell[113899, 3154, 278, 6, 70, "Text",
      CellTags->{"S3.10.3", "3.8"}],
    Cell[114180, 3162, 884, 24, 70, "Text",
      CellTags->{"S3.10.3", "3.9"}],
    Cell[115067, 3188, 435, 9, 70, "Text",
      CellTags->{"S3.10.3", "3.10"}],
    Cell[115505, 3199, 312, 9, 70, "Text",
      CellTags->{"S3.10.3", "3.11"}],
    Cell[115820, 3210, 936, 31, 70, "Text",
      CellTags->{"S3.10.3", "3.12"}],
    Cell[116793, 3246, 85, 1, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.13"}],
    Cell[116881, 3249, 6761, 140, 70, "DoubleBox",
      CellTags->"S3.10.3"],
    Cell[123645, 3391, 90, 1, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[123738, 3394, 356, 8, 70, "Text",
      CellTags->{"S3.10.3", "3.14"}],
    Cell[124097, 3404, 519, 13, 70, "Text",
      CellTags->{"S3.10.3", "3.15"}],
    Cell[124619, 3419, 213, 5, 70, "MathCaption",
      CellTags->{"S3.10.3", "3.16"}],
    Cell[124857, 3428, 260, 8, 70, "Input",
      CellTags->"S3.10.3"],
    Cell[125120, 3438, 132, 3, 70, "Output",
      CellTags->"S3.10.3"],
    Cell[125267, 3444, 592, 12, 70, "Text",
      CellTags->{"S3.10.3", "3.17"}],
    Cell[125862, 3458, 232, 5, 70, "Text",
      CellTags->{"S3.10.3", "3.18"}],
    Cell[126097, 3465, 225, 7, 70, "Text",
      CellTags->{"S3.10.3", "3.19"}],
    Cell[126325, 3474, 3373, 86, 70, "DefinitionBox3Col",
      CellTags->"S3.10.3"],
    Cell[129701, 3562, 89, 1, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[129827, 3568, 72, 1, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.20"}],
    Cell[129902, 3571, 2130, 50, 70, "DoubleBox",
      CellTags->"S3.10.3"],
    Cell[132035, 3623, 61, 1, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[132099, 3626, 286, 7, 70, "Text",
      CellTags->{"S3.10.3", "3.21"}],
    Cell[132422, 3638, 118, 4, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.22"}],
    Cell[132543, 3644, 6370, 137, 70, "DoubleBox",
      CellTags->"S3.10.3"],
    Cell[138916, 3783, 102, 3, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[139021, 3788, 498, 19, 70, "Text",
      CellTags->{"S3.10.3", "3.23"}],
    Cell[139522, 3809, 783, 27, 70, "Text",
      CellTags->{"S3.10.3", "3.24"}],
    Cell[140308, 3838, 976, 35, 70, "Text",
      CellTags->{"S3.10.3", "3.25"}],
    Cell[141287, 3875, 702, 22, 70, "Text",
      CellTags->{"S3.10.3", "3.26"}],
    Cell[141992, 3899, 4124, 90, 70, "DoubleBox",
      CellTags->"S3.10.3"],
    Cell[146119, 3991, 76, 1, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[146198, 3994, 426, 14, 70, "MathCaption",
      CellTags->{"S3.10.3", "3.27"}],
    Cell[146649, 4012, 133, 5, 70, "Input",
      CellTags->"S3.10.3"],
    Cell[146785, 4019, 318, 9, 70, "Output",
      CellTags->"S3.10.3"],
    Cell[147152, 4034, 98, 1, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.28"}],
    Cell[147253, 4037, 7867, 161, 70, "DoubleBox",
      CellTags->"S3.10.3"],
    Cell[155123, 4200, 50, 1, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[155176, 4203, 326, 7, 70, "Text",
      CellTags->{"S3.10.3", "3.29"}],
    Cell[155505, 4212, 341, 9, 70, "Text",
      CellTags->{"S3.10.3", "3.30"}],
    Cell[155849, 4223, 4474, 96, 70, "DoubleBox",
      CellTags->"S3.10.3"],
    Cell[160326, 4321, 49, 1, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[160378, 4324, 141, 4, 70, "MathCaption",
      CellTags->{"S3.10.3", "3.31"}],
    Cell[160544, 4332, 101, 2, 70, "Input",
      CellTags->"S3.10.3"],
    Cell[160648, 4336, 225, 5, 70, "Output",
      CellTags->"S3.10.3"],
    Cell[160888, 4344, 2324, 52, 70, "DoubleBox",
      CellTags->"S3.10.3"],
    Cell[163215, 4398, 79, 1, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[163297, 4401, 414, 13, 70, "Text",
      CellTags->{"S3.10.3", "3.32"}],
    Cell[163748, 4419, 74, 1, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.33"}],
    Cell[163825, 4422, 5912, 126, 70, "DoubleBox",
      CellTags->"S3.10.3"],
    Cell[169740, 4550, 90, 1, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[169833, 4553, 3905, 85, 70, "DoubleBox",
      CellTags->"S3.10.3"],
    Cell[173741, 4640, 73, 1, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[173817, 4643, 5644, 119, 70, "DoubleBox",
      CellTags->"S3.10.3"],
    Cell[179464, 4764, 92, 1, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[179559, 4767, 130, 4, 70, "MathCaption",
      CellTags->{"S3.10.3", "3.34"}],
    Cell[179714, 4775, 140, 5, 70, "Input",
      CellTags->"S3.10.3"],
    Cell[179857, 4782, 152, 4, 70, "Output",
      CellTags->"S3.10.3"],
    Cell[180058, 4792, 80, 1, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.35"}],
    Cell[180141, 4795, 197, 5, 70, "Text",
      CellTags->{"S3.10.3", "3.36"}],
    Cell[180341, 4802, 30195, 617, 70, "DoubleBox",
      CellTags->"S3.10.3"],
    Cell[210539, 5421, 71, 1, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[210613, 5424, 611, 19, 70, "Text",
      CellTags->{"S3.10.3", "3.37"}],
    Cell[211227, 5445, 143, 4, 70, "Text",
      CellTags->{"S3.10.3", "3.38"}],
    Cell[211373, 5451, 1783, 48, 70, "DefinitionBox",
      CellTags->"S3.10.3"],
    Cell[213159, 5501, 83, 1, 70, "Caption",
      CellTags->"S3.10.3"],
    Cell[213245, 5504, 6474, 184, 70, "DefinitionBox4Col",
      CellTags->"S3.10.3"],
    Cell[219722, 5690, 82, 1, 70, "Caption",
      CellTags->"S3.10.3"]},
  "3.1"->{
    Cell[78416, 2406, 106, 3, 70, "Subsection",
      CellTags->{"S3.10.3", "3.1"}]},
  "3.2"->{
    Cell[78547, 2413, 70, 1, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.2"}]},
  "3.3"->{
    Cell[111435, 3069, 403, 13, 70, "Text",
      CellTags->{"S3.10.3", "3.3"}]},
  "3.4"->{
    Cell[111841, 3084, 499, 16, 70, "Text",
      CellTags->{"S3.10.3", "3.4"}]},
  "3.5"->{
    Cell[112343, 3102, 503, 14, 70, "Text",
      CellTags->{"S3.10.3", "3.5"}]},
  "3.6"->{
    Cell[112849, 3118, 550, 19, 70, "Text",
      CellTags->{"S3.10.3", "3.6"}]},
  "3.7"->{
    Cell[113402, 3139, 494, 13, 70, "Text",
      CellTags->{"S3.10.3", "3.7"}]},
  "3.8"->{
    Cell[113899, 3154, 278, 6, 70, "Text",
      CellTags->{"S3.10.3", "3.8"}]},
  "3.9"->{
    Cell[114180, 3162, 884, 24, 70, "Text",
      CellTags->{"S3.10.3", "3.9"}]},
  "3.10"->{
    Cell[115067, 3188, 435, 9, 70, "Text",
      CellTags->{"S3.10.3", "3.10"}]},
  "3.11"->{
    Cell[115505, 3199, 312, 9, 70, "Text",
      CellTags->{"S3.10.3", "3.11"}]},
  "3.12"->{
    Cell[115820, 3210, 936, 31, 70, "Text",
      CellTags->{"S3.10.3", "3.12"}]},
  "3.13"->{
    Cell[116793, 3246, 85, 1, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.13"}]},
  "3.14"->{
    Cell[123738, 3394, 356, 8, 70, "Text",
      CellTags->{"S3.10.3", "3.14"}]},
  "3.15"->{
    Cell[124097, 3404, 519, 13, 70, "Text",
      CellTags->{"S3.10.3", "3.15"}]},
  "3.16"->{
    Cell[124619, 3419, 213, 5, 70, "MathCaption",
      CellTags->{"S3.10.3", "3.16"}]},
  "3.17"->{
    Cell[125267, 3444, 592, 12, 70, "Text",
      CellTags->{"S3.10.3", "3.17"}]},
  "3.18"->{
    Cell[125862, 3458, 232, 5, 70, "Text",
      CellTags->{"S3.10.3", "3.18"}]},
  "3.19"->{
    Cell[126097, 3465, 225, 7, 70, "Text",
      CellTags->{"S3.10.3", "3.19"}]},
  "3.20"->{
    Cell[129827, 3568, 72, 1, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.20"}]},
  "3.21"->{
    Cell[132099, 3626, 286, 7, 70, "Text",
      CellTags->{"S3.10.3", "3.21"}]},
  "3.22"->{
    Cell[132422, 3638, 118, 4, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.22"}]},
  "3.23"->{
    Cell[139021, 3788, 498, 19, 70, "Text",
      CellTags->{"S3.10.3", "3.23"}]},
  "3.24"->{
    Cell[139522, 3809, 783, 27, 70, "Text",
      CellTags->{"S3.10.3", "3.24"}]},
  "3.25"->{
    Cell[140308, 3838, 976, 35, 70, "Text",
      CellTags->{"S3.10.3", "3.25"}]},
  "3.26"->{
    Cell[141287, 3875, 702, 22, 70, "Text",
      CellTags->{"S3.10.3", "3.26"}]},
  "3.27"->{
    Cell[146198, 3994, 426, 14, 70, "MathCaption",
      CellTags->{"S3.10.3", "3.27"}]},
  "3.28"->{
    Cell[147152, 4034, 98, 1, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.28"}]},
  "3.29"->{
    Cell[155176, 4203, 326, 7, 70, "Text",
      CellTags->{"S3.10.3", "3.29"}]},
  "3.30"->{
    Cell[155505, 4212, 341, 9, 70, "Text",
      CellTags->{"S3.10.3", "3.30"}]},
  "3.31"->{
    Cell[160378, 4324, 141, 4, 70, "MathCaption",
      CellTags->{"S3.10.3", "3.31"}]},
  "3.32"->{
    Cell[163297, 4401, 414, 13, 70, "Text",
      CellTags->{"S3.10.3", "3.32"}]},
  "3.33"->{
    Cell[163748, 4419, 74, 1, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.33"}]},
  "3.34"->{
    Cell[179559, 4767, 130, 4, 70, "MathCaption",
      CellTags->{"S3.10.3", "3.34"}]},
  "3.35"->{
    Cell[180058, 4792, 80, 1, 70, "Subsubsection",
      CellTags->{"S3.10.3", "3.35"}]},
  "3.36"->{
    Cell[180141, 4795, 197, 5, 70, "Text",
      CellTags->{"S3.10.3", "3.36"}]},
  "3.37"->{
    Cell[210613, 5424, 611, 19, 70, "Text",
      CellTags->{"S3.10.3", "3.37"}]},
  "3.38"->{
    Cell[211227, 5445, 143, 4, 70, "Text",
      CellTags->{"S3.10.3", "3.38"}]},
  "S3.10.4"->{
    Cell[219853, 5697, 70, 1, 70, "Subsection",
      CellTags->{"S3.10.4", "4.1"}],
    Cell[219948, 5702, 85, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.2"}],
    Cell[220036, 5705, 3385, 76, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[223424, 5783, 95, 1, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[223522, 5786, 399, 13, 70, "Text",
      CellTags->{"S3.10.4", "4.3"}],
    Cell[223924, 5801, 4227, 127, 70, "DefinitionBox3Col",
      CellTags->"S3.10.4"],
    Cell[228154, 5930, 118, 4, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[228309, 5939, 90, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.4"}],
    Cell[228402, 5942, 4771, 102, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[233176, 6046, 70, 1, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[233249, 6049, 2876, 64, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[236128, 6115, 86, 1, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[236251, 6121, 86, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.5"}],
    Cell[236340, 6124, 7987, 169, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[244330, 6295, 81, 1, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[244414, 6298, 1144, 42, 70, "Text",
      CellTags->{"S3.10.4", "4.6"}],
    Cell[245561, 6342, 819, 31, 70, "Text",
      CellTags->{"S3.10.4", "4.7"}],
    Cell[246383, 6375, 201, 7, 70, "MathCaption",
      CellTags->{"S3.10.4", "4.8"}],
    Cell[246609, 6386, 100, 2, 70, "Input",
      CellTags->"S3.10.4"],
    Cell[246712, 6390, 103, 3, 70, "Output",
      CellTags->"S3.10.4"],
    Cell[246830, 6396, 659, 16, 70, "Text",
      CellTags->{"S3.10.4", "4.9"}],
    Cell[247492, 6414, 353, 11, 70, "MathCaption",
      CellTags->{"S3.10.4", "4.10"}],
    Cell[247870, 6429, 136, 3, 70, "Input",
      CellTags->"S3.10.4"],
    Cell[248009, 6434, 269, 8, 70, "Output",
      CellTags->"S3.10.4"],
    Cell[248327, 6448, 93, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.11"}],
    Cell[248423, 6451, 7696, 163, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[256122, 6616, 192, 6, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[256317, 6624, 292, 7, 70, "Text",
      CellTags->{"S3.10.4", "4.12"}],
    Cell[256612, 6633, 135, 4, 70, "MathCaption",
      CellTags->{"S3.10.4", "4.13"}],
    Cell[256772, 6641, 103, 2, 70, "Input",
      CellTags->"S3.10.4"],
    Cell[256878, 6645, 258, 8, 70, "Output",
      CellTags->"S3.10.4"],
    Cell[257151, 6656, 258, 6, 70, "Text",
      CellTags->{"S3.10.4", "4.14"}],
    Cell[257446, 6667, 78, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.15"}],
    Cell[257527, 6670, 5658, 120, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[263188, 6792, 83, 1, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[263274, 6795, 4783, 148, 70, "DefinitionBox",
      CellTags->"S3.10.4"],
    Cell[268060, 6945, 83, 1, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[268180, 6951, 95, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.16"}],
    Cell[268278, 6954, 10315, 214, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[278596, 7170, 115, 4, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[278714, 7176, 430, 13, 70, "MathCaption",
      CellTags->{"S3.10.4", "4.17"}],
    Cell[279169, 7193, 112, 2, 70, "Input",
      CellTags->"S3.10.4"],
    Cell[279284, 7197, 151, 4, 70, "Output",
      CellTags->"S3.10.4"],
    Cell[279450, 7204, 10654, 216, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[290107, 7422, 92, 1, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[290202, 7425, 5558, 118, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[295763, 7545, 80, 1, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[295846, 7548, 8758, 172, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[304607, 7722, 95, 1, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[304705, 7725, 3090, 68, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[307798, 7795, 87, 1, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[307922, 7801, 95, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.18"}],
    Cell[308020, 7804, 194, 5, 70, "Text",
      CellTags->{"S3.10.4", "4.19"}],
    Cell[308217, 7811, 195, 7, 70, "MathCaption",
      CellTags->{"S3.10.4", "4.20"}],
    Cell[308437, 7822, 85, 2, 70, "Input",
      CellTags->"S3.10.4"],
    Cell[308525, 7826, 87, 3, 70, "Output",
      CellTags->"S3.10.4"],
    Cell[308627, 7832, 2572, 59, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[311202, 7893, 162, 5, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[311367, 7900, 11000, 220, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[322370, 8122, 59, 1, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[322432, 8125, 8289, 165, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[330724, 8292, 70, 1, 70, "Caption",
      CellTags->"S3.10.4"],
    Cell[330797, 8295, 174, 5, 70, "MathCaption",
      CellTags->{"S3.10.4", "4.21"}],
    Cell[330996, 8304, 102, 2, 70, "Input",
      CellTags->"S3.10.4"],
    Cell[331101, 8308, 117, 3, 70, "Output",
      CellTags->"S3.10.4"],
    Cell[331233, 8314, 3002, 67, 70, "DoubleBox",
      CellTags->"S3.10.4"],
    Cell[334238, 8383, 48, 1, 70, "Caption",
      CellTags->"S3.10.4"]},
  "4.1"->{
    Cell[219853, 5697, 70, 1, 70, "Subsection",
      CellTags->{"S3.10.4", "4.1"}]},
  "4.2"->{
    Cell[219948, 5702, 85, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.2"}]},
  "4.3"->{
    Cell[223522, 5786, 399, 13, 70, "Text",
      CellTags->{"S3.10.4", "4.3"}]},
  "4.4"->{
    Cell[228309, 5939, 90, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.4"}]},
  "4.5"->{
    Cell[236251, 6121, 86, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.5"}]},
  "4.6"->{
    Cell[244414, 6298, 1144, 42, 70, "Text",
      CellTags->{"S3.10.4", "4.6"}]},
  "4.7"->{
    Cell[245561, 6342, 819, 31, 70, "Text",
      CellTags->{"S3.10.4", "4.7"}]},
  "4.8"->{
    Cell[246383, 6375, 201, 7, 70, "MathCaption",
      CellTags->{"S3.10.4", "4.8"}]},
  "4.9"->{
    Cell[246830, 6396, 659, 16, 70, "Text",
      CellTags->{"S3.10.4", "4.9"}]},
  "4.10"->{
    Cell[247492, 6414, 353, 11, 70, "MathCaption",
      CellTags->{"S3.10.4", "4.10"}]},
  "4.11"->{
    Cell[248327, 6448, 93, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.11"}]},
  "4.12"->{
    Cell[256317, 6624, 292, 7, 70, "Text",
      CellTags->{"S3.10.4", "4.12"}]},
  "4.13"->{
    Cell[256612, 6633, 135, 4, 70, "MathCaption",
      CellTags->{"S3.10.4", "4.13"}]},
  "4.14"->{
    Cell[257151, 6656, 258, 6, 70, "Text",
      CellTags->{"S3.10.4", "4.14"}]},
  "4.15"->{
    Cell[257446, 6667, 78, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.15"}]},
  "4.16"->{
    Cell[268180, 6951, 95, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.16"}]},
  "4.17"->{
    Cell[278714, 7176, 430, 13, 70, "MathCaption",
      CellTags->{"S3.10.4", "4.17"}]},
  "4.18"->{
    Cell[307922, 7801, 95, 1, 70, "Subsubsection",
      CellTags->{"S3.10.4", "4.18"}]},
  "4.19"->{
    Cell[308020, 7804, 194, 5, 70, "Text",
      CellTags->{"S3.10.4", "4.19"}]},
  "4.20"->{
    Cell[308217, 7811, 195, 7, 70, "MathCaption",
      CellTags->{"S3.10.4", "4.20"}]},
  "4.21"->{
    Cell[330797, 8295, 174, 5, 70, "MathCaption",
      CellTags->{"S3.10.4", "4.21"}]},
  "S3.10.5"->{
    Cell[334335, 8390, 104, 1, 70, "Subsection",
      CellTags->{"S3.10.5", "5.1"}],
    Cell[334442, 8393, 3218, 70, 70, "DoubleBox",
      CellTags->"S3.10.5"],
    Cell[337663, 8465, 64, 1, 70, "Caption",
      CellTags->"S3.10.5"],
    Cell[337730, 8468, 189, 7, 70, "MathCaption",
      CellTags->{"S3.10.5", "5.2"}],
    Cell[337944, 8479, 107, 3, 70, "Input",
      CellTags->"S3.10.5"],
    Cell[338054, 8484, 93, 3, 70, "Output",
      CellTags->"S3.10.5"],
    Cell[338162, 8490, 212, 7, 70, "MathCaption",
      CellTags->{"S3.10.5", "5.3"}],
    Cell[338399, 8501, 110, 3, 70, "Input",
      CellTags->"S3.10.5"],
    Cell[338512, 8506, 245, 8, 70, "Output",
      CellTags->"S3.10.5"],
    Cell[338772, 8517, 185, 5, 70, "MathCaption",
      CellTags->{"S3.10.5", "5.4"}],
    Cell[338982, 8526, 92, 2, 70, "Input",
      CellTags->"S3.10.5"],
    Cell[339077, 8530, 98, 3, 70, "Output",
      CellTags->"S3.10.5"],
    Cell[339190, 8536, 204, 5, 70, "MathCaption",
      CellTags->{"S3.10.5", "5.5"}],
    Cell[339419, 8545, 216, 6, 70, "Input",
      CellTags->"S3.10.5"],
    Cell[339638, 8553, 295, 8, 70, "Output",
      CellTags->"S3.10.5"],
    Cell[339948, 8564, 8440, 178, 70, "DoubleBox",
      CellTags->"S3.10.5"],
    Cell[348391, 8744, 74, 1, 70, "Caption",
      CellTags->"S3.10.5"],
    Cell[348468, 8747, 2059, 48, 70, "DoubleBox",
      CellTags->"S3.10.5"],
    Cell[350530, 8797, 70, 1, 70, "Caption",
      CellTags->"S3.10.5"],
    Cell[350603, 8800, 579, 10, 70, "Text",
      CellTags->{"S3.10.5", "5.6"}],
    Cell[351185, 8812, 5731, 121, 70, "DoubleBox",
      CellTags->"S3.10.5"],
    Cell[356919, 8935, 81, 1, 70, "Caption",
      CellTags->"S3.10.5"],
    Cell[357003, 8938, 725, 20, 70, "Text",
      CellTags->{"S3.10.5", "5.7"}],
    Cell[357731, 8960, 167, 6, 70, "MathCaption",
      CellTags->{"S3.10.5", "5.8"}],
    Cell[357923, 8970, 226, 7, 70, "Input",
      CellTags->"S3.10.5"],
    Cell[358152, 8979, 222, 5, 70, "Output",
      CellTags->"S3.10.5"],
    Cell[358389, 8987, 2147, 48, 70, "DoubleBox",
      CellTags->"S3.10.5"],
    Cell[360539, 9037, 130, 5, 70, "Caption",
      CellTags->"S3.10.5"],
    Cell[360672, 9044, 235, 6, 56, "MathCaption",
      CellTags->{"S3.10.5", "5.9"}],
    Cell[360932, 9054, 68, 2, 70, "Input",
      CellTags->"S3.10.5"],
    Cell[361003, 9058, 166, 4, 41, "Output",
      CellTags->"S3.10.5"],
    Cell[361184, 9065, 7951, 178, 514, "DoubleBox",
      CellTags->"S3.10.5"],
    Cell[369138, 9245, 67, 1, 16, "Caption",
      CellTags->"S3.10.5"],
    Cell[369208, 9248, 552, 13, 88, "Text",
      CellTags->{"S3.10.5", "5.10"}]},
  "5.1"->{
    Cell[334335, 8390, 104, 1, 70, "Subsection",
      CellTags->{"S3.10.5", "5.1"}]},
  "5.2"->{
    Cell[337730, 8468, 189, 7, 70, "MathCaption",
      CellTags->{"S3.10.5", "5.2"}]},
  "5.3"->{
    Cell[338162, 8490, 212, 7, 70, "MathCaption",
      CellTags->{"S3.10.5", "5.3"}]},
  "5.4"->{
    Cell[338772, 8517, 185, 5, 70, "MathCaption",
      CellTags->{"S3.10.5", "5.4"}]},
  "5.5"->{
    Cell[339190, 8536, 204, 5, 70, "MathCaption",
      CellTags->{"S3.10.5", "5.5"}]},
  "5.6"->{
    Cell[350603, 8800, 579, 10, 70, "Text",
      CellTags->{"S3.10.5", "5.6"}]},
  "5.7"->{
    Cell[357003, 8938, 725, 20, 70, "Text",
      CellTags->{"S3.10.5", "5.7"}]},
  "5.8"->{
    Cell[357731, 8960, 167, 6, 70, "MathCaption",
      CellTags->{"S3.10.5", "5.8"}]},
  "5.9"->{
    Cell[360672, 9044, 235, 6, 56, "MathCaption",
      CellTags->{"S3.10.5", "5.9"}]},
  "5.10"->{
    Cell[369208, 9248, 552, 13, 88, "Text",
      CellTags->{"S3.10.5", "5.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S3.10.0", 370404, 9281},
  {"0.1", 370495, 9284},
  {"S3.10.1", 370590, 9287},
  {"1.1", 378367, 9490},
  {"1.2", 378460, 9493},
  {"1.3", 378549, 9496},
  {"1.4", 378638, 9499},
  {"1.5", 378727, 9502},
  {"1.6", 378817, 9505},
  {"1.7", 378906, 9508},
  {"1.8", 378996, 9511},
  {"1.9", 379093, 9514},
  {"1.10", 379190, 9517},
  {"1.11", 379288, 9520},
  {"1.12", 379379, 9523},
  {"1.13", 379471, 9526},
  {"1.14", 379562, 9529},
  {"1.15", 379660, 9532},
  {"1.16", 379758, 9535},
  {"1.17", 379857, 9538},
  {"1.18", 379950, 9541},
  {"1.19", 380043, 9544},
  {"1.20", 380142, 9547},
  {"1.21", 380241, 9550},
  {"1.22", 380340, 9553},
  {"1.23", 380433, 9556},
  {"1.24", 380525, 9559},
  {"1.25", 380617, 9562},
  {"1.26", 380709, 9565},
  {"1.27", 380802, 9568},
  {"1.28", 380895, 9571},
  {"1.29", 380988, 9574},
  {"1.30", 381087, 9577},
  {"1.31", 381179, 9580},
  {"1.32", 381272, 9583},
  {"1.33", 381365, 9586},
  {"1.34", 381464, 9589},
  {"1.35", 381557, 9592},
  {"1.36", 381657, 9595},
  {"1.37", 381756, 9598},
  {"1.38", 381849, 9601},
  {"1.39", 381942, 9604},
  {"1.40", 382036, 9607},
  {"1.41", 382136, 9610},
  {"1.42", 382236, 9613},
  {"1.43", 382336, 9616},
  {"1.44", 382430, 9619},
  {"1.45", 382530, 9622},
  {"1.46", 382624, 9625},
  {"1.47", 382718, 9628},
  {"1.48", 382818, 9631},
  {"1.49", 382912, 9634},
  {"1.50", 383013, 9637},
  {"1.51", 383106, 9640},
  {"1.52", 383200, 9643},
  {"1.53", 383293, 9646},
  {"S3.10.2", 383389, 9649},
  {"2.1", 385585, 9706},
  {"2.2", 385682, 9709},
  {"2.3", 385773, 9712},
  {"2.4", 385871, 9715},
  {"2.5", 385963, 9718},
  {"2.6", 386061, 9721},
  {"2.7", 386160, 9724},
  {"2.8", 386251, 9727},
  {"2.9", 386342, 9730},
  {"2.10", 386434, 9733},
  {"2.11", 386527, 9736},
  {"2.12", 386627, 9739},
  {"2.13", 386720, 9742},
  {"S3.10.3", 386817, 9745},
  {"3.1", 392879, 9898},
  {"3.2", 392976, 9901},
  {"3.3", 393075, 9904},
  {"3.4", 393168, 9907},
  {"3.5", 393261, 9910},
  {"3.6", 393354, 9913},
  {"3.7", 393447, 9916},
  {"3.8", 393540, 9919},
  {"3.9", 393632, 9922},
  {"3.10", 393726, 9925},
  {"3.11", 393820, 9928},
  {"3.12", 393914, 9931},
  {"3.13", 394009, 9934},
  {"3.14", 394111, 9937},
  {"3.15", 394205, 9940},
  {"3.16", 394300, 9943},
  {"3.17", 394401, 9946},
  {"3.18", 394496, 9949},
  {"3.19", 394590, 9952},
  {"3.20", 394684, 9955},
  {"3.21", 394786, 9958},
  {"3.22", 394880, 9961},
  {"3.23", 394983, 9964},
  {"3.24", 395078, 9967},
  {"3.25", 395173, 9970},
  {"3.26", 395268, 9973},
  {"3.27", 395363, 9976},
  {"3.28", 395465, 9979},
  {"3.29", 395567, 9982},
  {"3.30", 395661, 9985},
  {"3.31", 395755, 9988},
  {"3.32", 395856, 9991},
  {"3.33", 395951, 9994},
  {"3.34", 396053, 9997},
  {"3.35", 396154, 10000},
  {"3.36", 396256, 10003},
  {"3.37", 396350, 10006},
  {"3.38", 396445, 10009},
  {"S3.10.4", 396542, 10012},
  {"4.1", 401822, 10147},
  {"4.2", 401919, 10150},
  {"4.3", 402019, 10153},
  {"4.4", 402112, 10156},
  {"4.5", 402212, 10159},
  {"4.6", 402312, 10162},
  {"4.7", 402406, 10165},
  {"4.8", 402499, 10168},
  {"4.9", 402598, 10171},
  {"4.10", 402692, 10174},
  {"4.11", 402794, 10177},
  {"4.12", 402896, 10180},
  {"4.13", 402990, 10183},
  {"4.14", 403091, 10186},
  {"4.15", 403185, 10189},
  {"4.16", 403287, 10192},
  {"4.17", 403389, 10195},
  {"4.18", 403491, 10198},
  {"4.19", 403593, 10201},
  {"4.20", 403687, 10204},
  {"4.21", 403788, 10207},
  {"S3.10.5", 403892, 10210},
  {"5.1", 406533, 10279},
  {"5.2", 406631, 10282},
  {"5.3", 406730, 10285},
  {"5.4", 406829, 10288},
  {"5.5", 406928, 10291},
  {"5.6", 407027, 10294},
  {"5.7", 407120, 10297},
  {"5.8", 407213, 10300},
  {"5.9", 407312, 10303},
  {"5.10", 407412, 10306}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 136, 4, 65, "Section",
  CellTags->{"S3.10.0", "0.1"}],

Cell[CellGroupData[{
Cell[1937, 61, 79, 1, 70, "Subsection",
  CellTags->{"S3.10.1", "1.1"}],
Cell[2019, 64, 364, 10, 70, "Text",
  CellTags->{"S3.10.1", "1.2"}],
Cell[2386, 76, 745, 20, 70, "Text",
  CellTags->{"S3.10.1", "1.3"}],
Cell[3134, 98, 576, 14, 70, "Text",
  CellTags->{"S3.10.1", "1.4"}],
Cell[3713, 114, 716, 15, 70, "Text",
  CellTags->{"S3.10.1", "1.5"}],
Cell[4432, 131, 1195, 38, 70, "FramedBox",
  CellTags->"S3.10.1"],
Cell[5630, 171, 76, 1, 70, "Caption",
  CellTags->"S3.10.1"],
Cell[5709, 174, 340, 9, 70, "Text",
  CellTags->{"S3.10.1", "1.6"}],
Cell[6052, 185, 634, 20, 70, "Text",
  CellTags->{"S3.10.1", "1.7"}],
Cell[6689, 207, 301, 10, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.8"}],

Cell[CellGroupData[{
Cell[7015, 221, 88, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[7106, 225, 86, 3, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[7207, 231, 273, 9, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.9"}],

Cell[CellGroupData[{
Cell[7505, 244, 93, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[7601, 248, 97, 3, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[7713, 254, 279, 9, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.10"}],

Cell[CellGroupData[{
Cell[8017, 267, 99, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[8119, 271, 116, 3, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[8250, 277, 300, 9, 70, "Text",
  CellTags->{"S3.10.1", "1.11"}],
Cell[8553, 288, 502, 17, 70, "Text",
  CellTags->{"S3.10.1", "1.12"}],
Cell[9058, 307, 289, 9, 70, "Text",
  CellTags->{"S3.10.1", "1.13"}],
Cell[9350, 318, 215, 7, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.14"}],

Cell[CellGroupData[{
Cell[9590, 329, 92, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[9685, 333, 109, 3, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[9809, 339, 180, 6, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.15"}],
Cell[9992, 347, 112, 3, 70, "Input",
  CellTags->"S3.10.1"],
Cell[10107, 352, 243, 8, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.16"}],

Cell[CellGroupData[{
Cell[10375, 364, 92, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[10470, 368, 94, 3, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[10579, 374, 437, 15, 70, "Text",
  CellTags->{"S3.10.1", "1.17"}],
Cell[11019, 391, 581, 18, 70, "Text",
  CellTags->{"S3.10.1", "1.18"}],
Cell[11603, 411, 175, 5, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.19"}],

Cell[CellGroupData[{
Cell[11803, 420, 99, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[11905, 424, 116, 3, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[12036, 430, 209, 6, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.20"}],
Cell[12248, 438, 99, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[12350, 442, 224, 8, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.21"}],

Cell[CellGroupData[{
Cell[12599, 454, 99, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[12701, 458, 100, 3, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[12816, 464, 398, 11, 70, "Text",
  CellTags->{"S3.10.1", "1.22"}],
Cell[13217, 477, 342, 9, 70, "Text",
  CellTags->{"S3.10.1", "1.23"}],
Cell[13562, 488, 415, 9, 70, "Text",
  CellTags->{"S3.10.1", "1.24"}],
Cell[13980, 499, 1852, 49, 70, "DefinitionBox",
  CellTags->"S3.10.1"],
Cell[15835, 550, 71, 1, 70, "Caption",
  CellTags->"S3.10.1"],
Cell[15909, 553, 280, 6, 70, "Text",
  CellTags->{"S3.10.1", "1.25"}],
Cell[16192, 561, 447, 14, 70, "Text",
  CellTags->{"S3.10.1", "1.26"}],
Cell[16642, 577, 632, 15, 70, "Text",
  CellTags->{"S3.10.1", "1.27"}],
Cell[17277, 594, 7849, 180, 70, "DoubleBox",
  CellTags->"S3.10.1"],
Cell[25129, 776, 82, 1, 70, "Caption",
  CellTags->"S3.10.1"],
Cell[25214, 779, 357, 10, 70, "Text",
  CellTags->{"S3.10.1", "1.28"}],
Cell[25574, 791, 102, 1, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.29"}],

Cell[CellGroupData[{
Cell[25701, 796, 126, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[25830, 800, 120, 3, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[25965, 806, 284, 8, 70, "Text",
  CellTags->{"S3.10.1", "1.30"}],
Cell[26252, 816, 413, 12, 70, "Text",
  CellTags->{"S3.10.1", "1.31"}],
Cell[26668, 830, 451, 13, 70, "Text",
  CellTags->{"S3.10.1", "1.32"}],
Cell[27122, 845, 236, 7, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.33"}],

Cell[CellGroupData[{
Cell[27383, 856, 119, 3, 70, "Input",
  CellTags->"S3.10.1"],
Cell[27505, 861, 106, 3, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[27626, 867, 490, 10, 70, "Text",
  CellTags->{"S3.10.1", "1.34"}],
Cell[28119, 879, 355, 11, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.35"}],

Cell[CellGroupData[{
Cell[28499, 894, 111, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[28613, 898, 254, 8, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[28882, 909, 233, 7, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.36"}],

Cell[CellGroupData[{
Cell[29140, 920, 97, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[29240, 924, 247, 8, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[29502, 935, 886, 26, 70, "Text",
  CellTags->{"S3.10.1", "1.37"}],
Cell[30391, 963, 789, 21, 70, "Text",
  CellTags->{"S3.10.1", "1.38"}],
Cell[31183, 986, 9836, 225, 70, "DoubleBox",
  CellTags->"S3.10.1"],
Cell[41022, 1213, 91, 1, 70, "Caption",
  CellTags->"S3.10.1"],
Cell[41116, 1216, 909, 26, 70, "Text",
  CellTags->{"S3.10.1", "1.39"}],
Cell[42028, 1244, 169, 5, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.40"}],

Cell[CellGroupData[{
Cell[42222, 1253, 95, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[42320, 1257, 94, 3, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[42429, 1263, 167, 5, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.41"}],

Cell[CellGroupData[{
Cell[42621, 1272, 95, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[42719, 1276, 98, 3, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[42832, 1282, 248, 7, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.42"}],

Cell[CellGroupData[{
Cell[43105, 1293, 94, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[43202, 1297, 101, 3, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[43318, 1303, 589, 17, 70, "Text",
  CellTags->{"S3.10.1", "1.43"}],
Cell[43910, 1322, 225, 7, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.44"}],

Cell[CellGroupData[{
Cell[44160, 1333, 113, 2, 70, "Input",
  CellTags->"S3.10.1"],
Cell[44276, 1337, 264, 8, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[44555, 1348, 430, 11, 70, "Text",
  CellTags->{"S3.10.1", "1.45"}],
Cell[44988, 1361, 676, 18, 70, "Text",
  CellTags->{"S3.10.1", "1.46"}],
Cell[45667, 1381, 238, 7, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.47"}],

Cell[CellGroupData[{
Cell[45930, 1392, 158, 6, 70, "Input",
  CellTags->"S3.10.1"],
Cell[46091, 1400, 101, 3, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[46207, 1406, 727, 20, 70, "Text",
  CellTags->{"S3.10.1", "1.48"}],
Cell[46937, 1428, 322, 11, 70, "MathCaption",
  CellTags->{"S3.10.1", "1.49"}],

Cell[CellGroupData[{
Cell[47284, 1443, 234, 8, 70, "Input",
  CellTags->"S3.10.1"],
Cell[47521, 1453, 262, 8, 70, "Output",
  CellTags->"S3.10.1"]
}, Open  ]],
Cell[47798, 1464, 159, 4, 70, "Text",
  CellTags->{"S3.10.1", "1.50"}],
Cell[47960, 1470, 4062, 126, 70, "DefinitionBox4Col",
  CellTags->"S3.10.1"],
Cell[52025, 1598, 76, 1, 70, "Caption",
  CellTags->"S3.10.1"],
Cell[52104, 1601, 710, 17, 70, "Text",
  CellTags->{"S3.10.1", "1.51"}],
Cell[52817, 1620, 1988, 53, 70, "DefinitionBox",
  CellTags->"S3.10.1"],
Cell[54808, 1675, 85, 1, 70, "Caption",
  CellTags->"S3.10.1"],
Cell[54896, 1678, 337, 7, 70, "Text",
  CellTags->{"S3.10.1", "1.52"}],
Cell[55236, 1687, 223, 5, 70, "Text",
  CellTags->{"S3.10.1", "1.53"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[55496, 1697, 102, 1, 70, "Subsection",
  CellTags->{"S3.10.2", "2.1"}],
Cell[55601, 1700, 200, 5, 70, "Text",
  CellTags->{"S3.10.2", "2.2"}],
Cell[55804, 1707, 148, 5, 70, "MathCaption",
  CellTags->{"S3.10.2", "2.3"}],

Cell[CellGroupData[{
Cell[55977, 1716, 211, 5, 70, "Input",
  CellTags->"S3.10.2"],
Cell[56191, 1723, 212, 5, 70, "Output",
  CellTags->"S3.10.2"]
}, Open  ]],
Cell[56418, 1731, 3429, 106, 70, "DefinitionBox4Col",
  CellTags->"S3.10.2"],
Cell[59850, 1839, 146, 4, 70, "Caption",
  CellTags->"S3.10.2"],
Cell[59999, 1845, 514, 16, 70, "Text",
  CellTags->{"S3.10.2", "2.4"}],
Cell[60516, 1863, 251, 8, 70, "MathCaption",
  CellTags->{"S3.10.2", "2.5"}],

Cell[CellGroupData[{
Cell[60792, 1875, 135, 3, 70, "Input",
  CellTags->"S3.10.2"],
Cell[60930, 1880, 109, 3, 70, "Output",
  CellTags->"S3.10.2"]
}, Open  ]],
Cell[61054, 1886, 243, 10, 70, "MathCaption",
  CellTags->{"S3.10.2", "2.6"}],

Cell[CellGroupData[{
Cell[61322, 1900, 78, 2, 70, "Input",
  CellTags->"S3.10.2"],
Cell[61403, 1904, 87, 2, 70, "Output",
  CellTags->"S3.10.2"],
Cell[61493, 1908, 118, 5, 70, "Output",
  CellTags->"S3.10.2"]
}, Open  ]],
Cell[61626, 1916, 334, 7, 70, "Text",
  CellTags->{"S3.10.2", "2.7"}],
Cell[61963, 1925, 386, 8, 70, "Text",
  CellTags->{"S3.10.2", "2.8"}],
Cell[62352, 1935, 204, 5, 70, "Text",
  CellTags->{"S3.10.2", "2.9"}],
Cell[62559, 1942, 229, 5, 70, "Text",
  CellTags->{"S3.10.2", "2.10"}],
Cell[62791, 1949, 227, 5, 70, "MathCaption",
  CellTags->{"S3.10.2", "2.11"}],

Cell[CellGroupData[{
Cell[63043, 1958, 163, 4, 70, "Input",
  CellTags->"S3.10.2"],
Cell[63209, 1964, 128, 3, 70, "Output",
  CellTags->"S3.10.2"]
}, Open  ]],
Cell[63352, 1970, 13273, 377, 70, "DefinitionBox3Col",
  CellTags->"S3.10.2"],
Cell[76628, 2349, 81, 1, 70, "Caption",
  CellTags->"S3.10.2"],
Cell[76712, 2352, 294, 6, 70, "Text",
  CellTags->{"S3.10.2", "2.12"}],
Cell[77009, 2360, 729, 24, 70, "DefinitionBox3Col",
  CellTags->"S3.10.2"],
Cell[77741, 2386, 77, 1, 70, "Caption",
  CellTags->"S3.10.2"],
Cell[77821, 2389, 558, 12, 70, "Text",
  CellTags->{"S3.10.2", "2.13"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[78416, 2406, 106, 3, 70, "Subsection",
  CellTags->{"S3.10.3", "3.1"}],

Cell[CellGroupData[{
Cell[78547, 2413, 70, 1, 70, "Subsubsection",
  CellTags->{"S3.10.3", "3.2"}],
Cell[78620, 2416, 32666, 644, 70, "DoubleBox",
  CellTags->"S3.10.3"],
Cell[111289, 3062, 143, 5, 70, "Caption",
  CellTags->"S3.10.3"],
Cell[111435, 3069, 403, 13, 70, "Text",
  CellTags->{"S3.10.3", "3.3"}],
Cell[111841, 3084, 499, 16, 70, "Text",
  CellTags->{"S3.10.3", "3.4"}],
Cell[112343, 3102, 503, 14, 70, "Text",
  CellTags->{"S3.10.3", "3.5"}],
Cell[112849, 3118, 550, 19, 70, "Text",
  CellTags->{"S3.10.3", "3.6"}],
Cell[113402, 3139, 494, 13, 70, "Text",
  CellTags->{"S3.10.3", "3.7"}],
Cell[113899, 3154, 278, 6, 70, "Text",
  CellTags->{"S3.10.3", "3.8"}],
Cell[114180, 3162, 884, 24, 70, "Text",
  CellTags->{"S3.10.3", "3.9"}],
Cell[115067, 3188, 435, 9, 70, "Text",
  CellTags->{"S3.10.3", "3.10"}],
Cell[115505, 3199, 312, 9, 70, "Text",
  CellTags->{"S3.10.3", "3.11"}],
Cell[115820, 3210, 936, 31, 70, "Text",
  CellTags->{"S3.10.3", "3.12"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[116793, 3246, 85, 1, 70, "Subsubsection",
  CellTags->{"S3.10.3", "3.13"}],
Cell[116881, 3249, 6761, 140, 70, "DoubleBox",
  CellTags->"S3.10.3"],
Cell[123645, 3391, 90, 1, 70, "Caption",
  CellTags->"S3.10.3"],
Cell[123738, 3394, 356, 8, 70, "Text",
  CellTags->{"S3.10.3", "3.14"}],
Cell[124097, 3404, 519, 13, 70, "Text",
  CellTags->{"S3.10.3", "3.15"}],
Cell[124619, 3419, 213, 5, 70, "MathCaption",
  CellTags->{"S3.10.3", "3.16"}],

Cell[CellGroupData[{
Cell[124857, 3428, 260, 8, 70, "Input",
  CellTags->"S3.10.3"],
Cell[125120, 3438, 132, 3, 70, "Output",
  CellTags->"S3.10.3"]
}, Open  ]],
Cell[125267, 3444, 592, 12, 70, "Text",
  CellTags->{"S3.10.3", "3.17"}],
Cell[125862, 3458, 232, 5, 70, "Text",
  CellTags->{"S3.10.3", "3.18"}],
Cell[126097, 3465, 225, 7, 70, "Text",
  CellTags->{"S3.10.3", "3.19"}],
Cell[126325, 3474, 3373, 86, 70, "DefinitionBox3Col",
  CellTags->"S3.10.3"],
Cell[129701, 3562, 89, 1, 70, "Caption",
  CellTags->"S3.10.3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[129827, 3568, 72, 1, 70, "Subsubsection",
  CellTags->{"S3.10.3", "3.20"}],
Cell[129902, 3571, 2130, 50, 70, "DoubleBox",
  CellTags->"S3.10.3"],
Cell[132035, 3623, 61, 1, 70, "Caption",
  CellTags->"S3.10.3"],
Cell[132099, 3626, 286, 7, 70, "Text",
  CellTags->{"S3.10.3", "3.21"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[132422, 3638, 118, 4, 70, "Subsubsection",
  CellTags->{"S3.10.3", "3.22"}],
Cell[132543, 3644, 6370, 137, 70, "DoubleBox",
  CellTags->"S3.10.3"],
Cell[138916, 3783, 102, 3, 70, "Caption",
  CellTags->"S3.10.3"],
Cell[139021, 3788, 498, 19, 70, "Text",
  CellTags->{"S3.10.3", "3.23"}],
Cell[139522, 3809, 783, 27, 70, "Text",
  CellTags->{"S3.10.3", "3.24"}],
Cell[140308, 3838, 976, 35, 70, "Text",
  CellTags->{"S3.10.3", "3.25"}],
Cell[141287, 3875, 702, 22, 70, "Text",
  CellTags->{"S3.10.3", "3.26"}],
Cell[141992, 3899, 4124, 90, 70, "DoubleBox",
  CellTags->"S3.10.3"],
Cell[146119, 3991, 76, 1, 70, "Caption",
  CellTags->"S3.10.3"],
Cell[146198, 3994, 426, 14, 70, "MathCaption",
  CellTags->{"S3.10.3", "3.27"}],

Cell[CellGroupData[{
Cell[146649, 4012, 133, 5, 70, "Input",
  CellTags->"S3.10.3"],
Cell[146785, 4019, 318, 9, 70, "Output",
  CellTags->"S3.10.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[147152, 4034, 98, 1, 70, "Subsubsection",
  CellTags->{"S3.10.3", "3.28"}],
Cell[147253, 4037, 7867, 161, 70, "DoubleBox",
  CellTags->"S3.10.3"],
Cell[155123, 4200, 50, 1, 70, "Caption",
  CellTags->"S3.10.3"],
Cell[155176, 4203, 326, 7, 70, "Text",
  CellTags->{"S3.10.3", "3.29"}],
Cell[155505, 4212, 341, 9, 70, "Text",
  CellTags->{"S3.10.3", "3.30"}],
Cell[155849, 4223, 4474, 96, 70, "DoubleBox",
  CellTags->"S3.10.3"],
Cell[160326, 4321, 49, 1, 70, "Caption",
  CellTags->"S3.10.3"],
Cell[160378, 4324, 141, 4, 70, "MathCaption",
  CellTags->{"S3.10.3", "3.31"}],

Cell[CellGroupData[{
Cell[160544, 4332, 101, 2, 70, "Input",
  CellTags->"S3.10.3"],
Cell[160648, 4336, 225, 5, 70, "Output",
  CellTags->"S3.10.3"]
}, Open  ]],
Cell[160888, 4344, 2324, 52, 70, "DoubleBox",
  CellTags->"S3.10.3"],
Cell[163215, 4398, 79, 1, 70, "Caption",
  CellTags->"S3.10.3"],
Cell[163297, 4401, 414, 13, 70, "Text",
  CellTags->{"S3.10.3", "3.32"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[163748, 4419, 74, 1, 70, "Subsubsection",
  CellTags->{"S3.10.3", "3.33"}],
Cell[163825, 4422, 5912, 126, 70, "DoubleBox",
  CellTags->"S3.10.3"],
Cell[169740, 4550, 90, 1, 70, "Caption",
  CellTags->"S3.10.3"],
Cell[169833, 4553, 3905, 85, 70, "DoubleBox",
  CellTags->"S3.10.3"],
Cell[173741, 4640, 73, 1, 70, "Caption",
  CellTags->"S3.10.3"],
Cell[173817, 4643, 5644, 119, 70, "DoubleBox",
  CellTags->"S3.10.3"],
Cell[179464, 4764, 92, 1, 70, "Caption",
  CellTags->"S3.10.3"],
Cell[179559, 4767, 130, 4, 70, "MathCaption",
  CellTags->{"S3.10.3", "3.34"}],

Cell[CellGroupData[{
Cell[179714, 4775, 140, 5, 70, "Input",
  CellTags->"S3.10.3"],
Cell[179857, 4782, 152, 4, 70, "Output",
  CellTags->"S3.10.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[180058, 4792, 80, 1, 70, "Subsubsection",
  CellTags->{"S3.10.3", "3.35"}],
Cell[180141, 4795, 197, 5, 70, "Text",
  CellTags->{"S3.10.3", "3.36"}],
Cell[180341, 4802, 30195, 617, 70, "DoubleBox",
  CellTags->"S3.10.3"],
Cell[210539, 5421, 71, 1, 70, "Caption",
  CellTags->"S3.10.3"],
Cell[210613, 5424, 611, 19, 70, "Text",
  CellTags->{"S3.10.3", "3.37"}],
Cell[211227, 5445, 143, 4, 70, "Text",
  CellTags->{"S3.10.3", "3.38"}],
Cell[211373, 5451, 1783, 48, 70, "DefinitionBox",
  CellTags->"S3.10.3"],
Cell[213159, 5501, 83, 1, 70, "Caption",
  CellTags->"S3.10.3"],
Cell[213245, 5504, 6474, 184, 70, "DefinitionBox4Col",
  CellTags->"S3.10.3"],
Cell[219722, 5690, 82, 1, 70, "Caption",
  CellTags->"S3.10.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[219853, 5697, 70, 1, 70, "Subsection",
  CellTags->{"S3.10.4", "4.1"}],

Cell[CellGroupData[{
Cell[219948, 5702, 85, 1, 70, "Subsubsection",
  CellTags->{"S3.10.4", "4.2"}],
Cell[220036, 5705, 3385, 76, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[223424, 5783, 95, 1, 70, "Caption",
  CellTags->"S3.10.4"],
Cell[223522, 5786, 399, 13, 70, "Text",
  CellTags->{"S3.10.4", "4.3"}],
Cell[223924, 5801, 4227, 127, 70, "DefinitionBox3Col",
  CellTags->"S3.10.4"],
Cell[228154, 5930, 118, 4, 70, "Caption",
  CellTags->"S3.10.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[228309, 5939, 90, 1, 70, "Subsubsection",
  CellTags->{"S3.10.4", "4.4"}],
Cell[228402, 5942, 4771, 102, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[233176, 6046, 70, 1, 70, "Caption",
  CellTags->"S3.10.4"],
Cell[233249, 6049, 2876, 64, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[236128, 6115, 86, 1, 70, "Caption",
  CellTags->"S3.10.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[236251, 6121, 86, 1, 70, "Subsubsection",
  CellTags->{"S3.10.4", "4.5"}],
Cell[236340, 6124, 7987, 169, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[244330, 6295, 81, 1, 70, "Caption",
  CellTags->"S3.10.4"],
Cell[244414, 6298, 1144, 42, 70, "Text",
  CellTags->{"S3.10.4", "4.6"}],
Cell[245561, 6342, 819, 31, 70, "Text",
  CellTags->{"S3.10.4", "4.7"}],
Cell[246383, 6375, 201, 7, 70, "MathCaption",
  CellTags->{"S3.10.4", "4.8"}],

Cell[CellGroupData[{
Cell[246609, 6386, 100, 2, 70, "Input",
  CellTags->"S3.10.4"],
Cell[246712, 6390, 103, 3, 70, "Output",
  CellTags->"S3.10.4"]
}, Open  ]],
Cell[246830, 6396, 659, 16, 70, "Text",
  CellTags->{"S3.10.4", "4.9"}],
Cell[247492, 6414, 353, 11, 70, "MathCaption",
  CellTags->{"S3.10.4", "4.10"}],

Cell[CellGroupData[{
Cell[247870, 6429, 136, 3, 70, "Input",
  CellTags->"S3.10.4"],
Cell[248009, 6434, 269, 8, 70, "Output",
  CellTags->"S3.10.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[248327, 6448, 93, 1, 70, "Subsubsection",
  CellTags->{"S3.10.4", "4.11"}],
Cell[248423, 6451, 7696, 163, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[256122, 6616, 192, 6, 70, "Caption",
  CellTags->"S3.10.4"],
Cell[256317, 6624, 292, 7, 70, "Text",
  CellTags->{"S3.10.4", "4.12"}],
Cell[256612, 6633, 135, 4, 70, "MathCaption",
  CellTags->{"S3.10.4", "4.13"}],

Cell[CellGroupData[{
Cell[256772, 6641, 103, 2, 70, "Input",
  CellTags->"S3.10.4"],
Cell[256878, 6645, 258, 8, 70, "Output",
  CellTags->"S3.10.4"]
}, Open  ]],
Cell[257151, 6656, 258, 6, 70, "Text",
  CellTags->{"S3.10.4", "4.14"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[257446, 6667, 78, 1, 70, "Subsubsection",
  CellTags->{"S3.10.4", "4.15"}],
Cell[257527, 6670, 5658, 120, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[263188, 6792, 83, 1, 70, "Caption",
  CellTags->"S3.10.4"],
Cell[263274, 6795, 4783, 148, 70, "DefinitionBox",
  CellTags->"S3.10.4"],
Cell[268060, 6945, 83, 1, 70, "Caption",
  CellTags->"S3.10.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[268180, 6951, 95, 1, 70, "Subsubsection",
  CellTags->{"S3.10.4", "4.16"}],
Cell[268278, 6954, 10315, 214, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[278596, 7170, 115, 4, 70, "Caption",
  CellTags->"S3.10.4"],
Cell[278714, 7176, 430, 13, 70, "MathCaption",
  CellTags->{"S3.10.4", "4.17"}],

Cell[CellGroupData[{
Cell[279169, 7193, 112, 2, 70, "Input",
  CellTags->"S3.10.4"],
Cell[279284, 7197, 151, 4, 70, "Output",
  CellTags->"S3.10.4"]
}, Open  ]],
Cell[279450, 7204, 10654, 216, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[290107, 7422, 92, 1, 70, "Caption",
  CellTags->"S3.10.4"],
Cell[290202, 7425, 5558, 118, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[295763, 7545, 80, 1, 70, "Caption",
  CellTags->"S3.10.4"],
Cell[295846, 7548, 8758, 172, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[304607, 7722, 95, 1, 70, "Caption",
  CellTags->"S3.10.4"],
Cell[304705, 7725, 3090, 68, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[307798, 7795, 87, 1, 70, "Caption",
  CellTags->"S3.10.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[307922, 7801, 95, 1, 70, "Subsubsection",
  CellTags->{"S3.10.4", "4.18"}],
Cell[308020, 7804, 194, 5, 70, "Text",
  CellTags->{"S3.10.4", "4.19"}],
Cell[308217, 7811, 195, 7, 70, "MathCaption",
  CellTags->{"S3.10.4", "4.20"}],

Cell[CellGroupData[{
Cell[308437, 7822, 85, 2, 70, "Input",
  CellTags->"S3.10.4"],
Cell[308525, 7826, 87, 3, 70, "Output",
  CellTags->"S3.10.4"]
}, Open  ]],
Cell[308627, 7832, 2572, 59, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[311202, 7893, 162, 5, 70, "Caption",
  CellTags->"S3.10.4"],
Cell[311367, 7900, 11000, 220, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[322370, 8122, 59, 1, 70, "Caption",
  CellTags->"S3.10.4"],
Cell[322432, 8125, 8289, 165, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[330724, 8292, 70, 1, 70, "Caption",
  CellTags->"S3.10.4"],
Cell[330797, 8295, 174, 5, 70, "MathCaption",
  CellTags->{"S3.10.4", "4.21"}],

Cell[CellGroupData[{
Cell[330996, 8304, 102, 2, 70, "Input",
  CellTags->"S3.10.4"],
Cell[331101, 8308, 117, 3, 70, "Output",
  CellTags->"S3.10.4"]
}, Open  ]],
Cell[331233, 8314, 3002, 67, 70, "DoubleBox",
  CellTags->"S3.10.4"],
Cell[334238, 8383, 48, 1, 70, "Caption",
  CellTags->"S3.10.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[334335, 8390, 104, 1, 70, "Subsection",
  CellTags->{"S3.10.5", "5.1"}],
Cell[334442, 8393, 3218, 70, 70, "DoubleBox",
  CellTags->"S3.10.5"],
Cell[337663, 8465, 64, 1, 70, "Caption",
  CellTags->"S3.10.5"],
Cell[337730, 8468, 189, 7, 70, "MathCaption",
  CellTags->{"S3.10.5", "5.2"}],

Cell[CellGroupData[{
Cell[337944, 8479, 107, 3, 70, "Input",
  CellTags->"S3.10.5"],
Cell[338054, 8484, 93, 3, 70, "Output",
  CellTags->"S3.10.5"]
}, Open  ]],
Cell[338162, 8490, 212, 7, 70, "MathCaption",
  CellTags->{"S3.10.5", "5.3"}],

Cell[CellGroupData[{
Cell[338399, 8501, 110, 3, 70, "Input",
  CellTags->"S3.10.5"],
Cell[338512, 8506, 245, 8, 70, "Output",
  CellTags->"S3.10.5"]
}, Open  ]],
Cell[338772, 8517, 185, 5, 70, "MathCaption",
  CellTags->{"S3.10.5", "5.4"}],

Cell[CellGroupData[{
Cell[338982, 8526, 92, 2, 70, "Input",
  CellTags->"S3.10.5"],
Cell[339077, 8530, 98, 3, 70, "Output",
  CellTags->"S3.10.5"]
}, Open  ]],
Cell[339190, 8536, 204, 5, 70, "MathCaption",
  CellTags->{"S3.10.5", "5.5"}],

Cell[CellGroupData[{
Cell[339419, 8545, 216, 6, 70, "Input",
  CellTags->"S3.10.5"],
Cell[339638, 8553, 295, 8, 70, "Output",
  CellTags->"S3.10.5"]
}, Open  ]],
Cell[339948, 8564, 8440, 178, 70, "DoubleBox",
  CellTags->"S3.10.5"],
Cell[348391, 8744, 74, 1, 70, "Caption",
  CellTags->"S3.10.5"],
Cell[348468, 8747, 2059, 48, 70, "DoubleBox",
  CellTags->"S3.10.5"],
Cell[350530, 8797, 70, 1, 70, "Caption",
  CellTags->"S3.10.5"],
Cell[350603, 8800, 579, 10, 70, "Text",
  CellTags->{"S3.10.5", "5.6"}],
Cell[351185, 8812, 5731, 121, 70, "DoubleBox",
  CellTags->"S3.10.5"],
Cell[356919, 8935, 81, 1, 70, "Caption",
  CellTags->"S3.10.5"],
Cell[357003, 8938, 725, 20, 70, "Text",
  CellTags->{"S3.10.5", "5.7"}],
Cell[357731, 8960, 167, 6, 70, "MathCaption",
  CellTags->{"S3.10.5", "5.8"}],

Cell[CellGroupData[{
Cell[357923, 8970, 226, 7, 70, "Input",
  CellTags->"S3.10.5"],
Cell[358152, 8979, 222, 5, 70, "Output",
  CellTags->"S3.10.5"]
}, Open  ]],
Cell[358389, 8987, 2147, 48, 70, "DoubleBox",
  CellTags->"S3.10.5"],
Cell[360539, 9037, 130, 5, 70, "Caption",
  CellTags->"S3.10.5"],
Cell[360672, 9044, 235, 6, 56, "MathCaption",
  CellTags->{"S3.10.5", "5.9"}],

Cell[CellGroupData[{
Cell[360932, 9054, 68, 2, 70, "Input",
  CellTags->"S3.10.5"],
Cell[361003, 9058, 166, 4, 41, "Output",
  CellTags->"S3.10.5"]
}, Open  ]],
Cell[361184, 9065, 7951, 178, 514, "DoubleBox",
  CellTags->"S3.10.5"],
Cell[369138, 9245, 67, 1, 16, "Caption",
  CellTags->"S3.10.5"],
Cell[369208, 9248, 552, 13, 88, "Text",
  CellTags->{"S3.10.5", "5.10"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

