(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23775,        838]*)
(*NotebookOutlinePosition[     32780,       1127]*)
(*  CellTagsIndexPosition[     31639,       1076]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.1 ", "HeadingNumber"],
  "Basic Objects"
}], "Section",
  CellTags->{"SA.1.0", "0.1"}],

Cell[CellGroupData[{

Cell["A.1.1 Expressions", "Subsection",
  CellTags->{"SA.1.1", "1.1"}],

Cell[TextData[{
  StyleBox["Expressions", "TI"],
  " are the main type of data in ",
  StyleBox["Mathematica", "TI"],
  ".  "
}], "Text",
  CellTags->{"SA.1.1", "1.2"}],

Cell[TextData[{
  "Expressions can be written in the form ",
  StyleBox["h", "TI"],
  StyleBox["[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ". The object ",
  StyleBox["h", "TI"],
  " is known generically as the ",
  StyleBox["head", "TI"],
  " of the expression. The ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " are termed the ",
  StyleBox["elements", "TI"],
  " of the expression. Both the head and the elements may themselves be \
expressions.  "
}], "Text",
  CellTags->{"SA.1.1", "1.3"}],

Cell[TextData[{
  "The ",
  StyleBox["parts", "TI"],
  " of an expression can be referred to by numerical indices. The head has \
index ",
  StyleBox["0", "MR"],
  "; element ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " has index ",
  StyleBox["i", "TI"],
  ". ",
  StyleBox["Part[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  " or ",
  StyleBox["expr", "TI"],
  StyleBox["[[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]]", "MR"],
  " gives the part of ",
  StyleBox["expr", "TI"],
  " with index ",
  StyleBox["i", "TI"],
  ". Negative indices count from the end. "
}], "Text",
  CellTags->{"SA.1.1", "1.4"}],

Cell[TextData[{
  StyleBox["Part[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ", ",
  StyleBox["expr", "TI"],
  StyleBox["[[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]]", "MR"],
  " or ",
  StyleBox["Extract[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " gives the piece of ",
  StyleBox["expr", "TI"],
  " found by successively extracting parts of subexpressions with indices ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  ", \[Ellipsis]",
  " ",
  ". If you think of expressions as trees, the indices specify which branch \
to take at each node as you descend from the root. "
}], "Text",
  CellTags->{"SA.1.1", "1.5"}],

Cell[TextData[{
  "The pieces of an expression that are specified by giving a sequence of \
exactly ",
  StyleBox["n", "TI"],
  " indices are defined to be at ",
  StyleBox["level", "TI"],
  " ",
  StyleBox["n", "TI"],
  " in the expression. You can use levels to determine the domain of \
application of functions like ",
  StyleBox["Map", "MR"],
  ". Level ",
  StyleBox["0", "MR"],
  " corresponds to the whole expression.  "
}], "Text",
  CellTags->{"SA.1.1", "1.6"}],

Cell[TextData[{
  "The ",
  StyleBox["depth", "TI"],
  " of an expression is defined to be the maximum number of indices needed to \
specify any part of the expression, plus one. A negative level number ",
  StyleBox["-", "MR"],
  StyleBox["n", "TI"],
  " refers to all parts of an expression that have depth ",
  StyleBox["n", "TI"],
  ". "
}], "Text",
  CellTags->{"SA.1.1", "1.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.1.2 Symbols", "Subsection",
  CellTags->{"SA.1.2", "2.1"}],

Cell[TextData[{
  StyleBox["Symbols", "TI"],
  " are the basic named objects in ",
  StyleBox["Mathematica", "TI"],
  ".  "
}], "Text",
  CellTags->{"SA.1.2", "2.2"}],

Cell[TextData[{
  "The name of a symbol must be a sequence of letters, letter\[Hyphen]like \
forms and digits, not starting with a digit. Upper\[Hyphen] and \
lower\[Hyphen]case letters are always distinguished in ",
  StyleBox["Mathematica", "TI"],
  ".  "
}], "Text",
  CellTags->{"SA.1.2", "2.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["aaaaa", "TI"],
              " "
            }]], Cell["user\[Hyphen]defined symbol "]},
          {Cell[TextData[{
              StyleBox["Aaaaa", "TI"],
              " "
            }]], Cell["system\[Hyphen]defined symbol "]},
          {Cell[TextData[{
              StyleBox["$", "MR"],
              StyleBox["Aaaa", "TI"],
              " "
            }]], 
            Cell["\<\
global or internal system\[Hyphen]defined symbol \
\
\>"]},
          {Cell[TextData[{
              StyleBox["aaaa", "TI"],
              StyleBox["$", "MR"],
              " "
            }]], Cell["symbol renamed in a scoping construct "]},
          {Cell[TextData[{
              StyleBox["aa", "TI"],
              StyleBox["$", "MR"],
              StyleBox["nn", "TI"],
              " "
            }]], Cell["unique local symbol generated in a module "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.1.2"],

Cell["Conventions for symbol names. ", "Caption",
  CellTags->"SA.1.2"],

Cell[TextData[{
  "Essentially all system\[Hyphen]defined symbols have names that contain \
only ordinary English letters, together with numbers and ",
  StyleBox["$", "MR"],
  ". The exceptions are ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[ImaginaryI]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[ImaginaryJ]\)], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"SA.1.2", "2.4"}],

Cell["\<\
System\[Hyphen]defined symbols conventionally have names that \
consist of one or more complete English words. The first letter of each word \
is capitalized, and the words are run together. \
\>", "Text",
  CellTags->{"SA.1.2", "2.5"}],

Cell[TextData[{
  "Once created, an ordinary symbol in ",
  StyleBox["Mathematica", "TI"],
  " continues to exist unless it is explicitly removed using ",
  StyleBox["Remove", "MR"],
  ". However, symbols created automatically in scoping constructs such as ",
  StyleBox["Module", "MR"],
  " carry the attribute ",
  StyleBox["Temporary", "MR"],
  " which specifies that they should automatically be removed as soon as they \
no longer appear in any expression. "
}], "Text",
  CellTags->{"SA.1.2", "2.6"}],

Cell[TextData[{
  "When a new symbol is to be created, ",
  StyleBox["Mathematica", "TI"],
  " first applies any value that has been assigned to ",
  StyleBox["$NewSymbol", "MR"],
  " to strings giving the name of the symbol, and the context in which the \
symbol would be created. "
}], "Text",
  CellTags->{"SA.1.2", "2.7"}],

Cell[TextData[{
  "If the message ",
  StyleBox["General::newsym", "MR"],
  " is switched on, then ",
  StyleBox["Mathematica", "TI"],
  " reports new symbols that are created. This message is switched off by \
default. Symbols created automatically in scoping constructs are not \
reported.  "
}], "Text",
  CellTags->{"SA.1.2", "2.8"}],

Cell[TextData[{
  "If the message ",
  StyleBox["General::spell", "MR"],
  " is switched on, then ",
  StyleBox["Mathematica", "TI"],
  " prints a warning if the name of a new symbol is close to the names of one \
or more existing symbols. "
}], "Text",
  CellTags->{"SA.1.2", "2.9"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.1.3 Contexts", "Subsection",
  CellTags->{"SA.1.3", "3.1"}],

Cell[TextData[{
  "The full name of any symbol in ",
  StyleBox["Mathematica", "TI"],
  " consists of two parts: a ",
  StyleBox["context", "TI"],
  ", and a ",
  StyleBox["short name", "TI"],
  ". The full name is written in the form ",
  StyleBox["context", "TI"],
  StyleBox["`", "MR"],
  StyleBox["name", "TI"],
  ". The context ",
  StyleBox["context", "TI"],
  StyleBox["`", "MR"],
  " can contain the same characters as the short name. It may also contain \
any number of context mark characters ",
  StyleBox["`", "MR"],
  ", and must end with a context mark.    "
}], "Text",
  CellTags->{"SA.1.3", "3.2"}],

Cell[TextData[{
  "At any point in a ",
  StyleBox["Mathematica", "TI"],
  " session, there is a ",
  StyleBox["current context", "TI"],
  " ",
  StyleBox["$Context", "MR"],
  " and a ",
  StyleBox["context search path", "TI"],
  " ",
  StyleBox["$ContextPath", "MR"],
  " consisting of a list of contexts. Symbols in the current context, or in \
contexts on the context search path can be specified by giving only their \
short names.  "
}], "Text",
  CellTags->{"SA.1.3", "3.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["name", "TI"],
              " "
            }]], Cell[TextData[{
              "search ",
              StyleBox["$Context", "MR"],
              ", then ",
              StyleBox["$ContextPath", "MR"],
              "; create in ",
              StyleBox["$Context", "MR"],
              " if necessary "
            }]]},
          {Cell[TextData[{
              StyleBox["`", "MR"],
              StyleBox["name", "TI"],
              " "
            }]], Cell[TextData[{
              "search ",
              StyleBox["$Context", "MR"],
              " only; create there if necessary "
            }]]},
          {Cell[TextData[{
              StyleBox["context", "TI"],
              StyleBox["`", "MR"],
              StyleBox["name", "TI"],
              " "
            }]], Cell[TextData[{
              "search ",
              StyleBox["context", "TI"],
              " only; create there if necessary "
            }]]},
          {Cell[TextData[{
              StyleBox["`", "MR"],
              StyleBox["context", "TI"],
              StyleBox["`", "MR"],
              StyleBox["name", "TI"],
              " "
            }]], Cell[TextData[{
              "search ",
              StyleBox["$Context`", "MR"],
              StyleBox["context", "TI"],
              " only; create there if necessary "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.1.3"],

Cell["Contexts used for various specifications of symbols. ", "Caption",
  CellTags->"SA.1.3"],

Cell[TextData[{
  "With ",
  StyleBox["Mathematica", "TI"],
  " packages, it is conventional to associate contexts whose names correspond \
to the names of the packages. Packages typically use ",
  StyleBox["BeginPackage", "MR"],
  " and ",
  StyleBox["EndPackage", "MR"],
  " to define objects in the appropriate context, and to add the context to \
the global ",
  StyleBox["$ContextPath", "MR"],
  ". ",
  StyleBox["EndPackage", "MR"],
  " prints a warning about any symbols that were created in a package but \
which are \[OpenCurlyDoubleQuote]shadowed\[CloseCurlyDoubleQuote] by existing \
symbols on the context search path. "
}], "Text",
  CellTags->{"SA.1.3", "3.4"}],

Cell[TextData[{
  "The context is included in the printed form of a symbol only if it would \
be needed to specify the symbol ",
  StyleBox["at the time of printing", "TI"],
  ".  "
}], "Text",
  CellTags->{"SA.1.3", "3.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.1.4 Atomic Objects", "Subsection",
  CellTags->{"SA.1.4", "4.1"}],

Cell[TextData[{
  "All expressions in ",
  StyleBox["Mathematica", "TI"],
  " are ultimately made up from a small number of basic or atomic types of \
objects.  "
}], "Text",
  CellTags->{"SA.1.4", "4.2"}],

Cell[TextData[{
  "These objects have heads which are symbols that can be thought of as \
\[OpenCurlyDoubleQuote]tagging\[CloseCurlyDoubleQuote] their types. The \
objects contain \[OpenCurlyDoubleQuote]raw data\[CloseCurlyDoubleQuote], \
which can usually be accessed only by functions specific to the particular \
type of object. You can extract the head of the object using ",
  StyleBox["Head", "MR"],
  ", but you cannot directly extract any of its other parts.  "
}], "Text",
  CellTags->{"SA.1.4", "4.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Symbol", "MR"],
              " "
            }]], Cell[TextData[{
              "symbol (extract name using ",
              StyleBox["SymbolName", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["String", "MR"],
              " "
            }]], Cell[TextData[{
              "character string ",
              StyleBox["\"", "MR"],
              StyleBox["cccc", "TI"],
              StyleBox["\"", "MR"],
              " (extract characters using ",
              StyleBox["Characters", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["Integer", "MR"],
              " "
            }]], Cell[TextData[{
              "integer (extract digits using ",
              StyleBox["IntegerDigits", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["Real", "MR"],
              " "
            }]], Cell[TextData[{
              "approximate real number (extract digits using ",
              StyleBox["RealDigits", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["Rational", "MR"],
              " "
            }]], Cell[TextData[{
              "rational number (extract parts using ",
              StyleBox["Numerator", "MR"],
              " and ",
              StyleBox["Denominator", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["Complex", "MR"],
              " "
            }]], Cell[TextData[{
              "complex number (extract parts using ",
              StyleBox["Re", "MR"],
              " and ",
              StyleBox["Im", "MR"],
              ") "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.1.4"],

Cell["Atomic objects. ", "Caption",
  CellTags->"SA.1.4"],

Cell[TextData[{
  "Atomic objects in ",
  StyleBox["Mathematica", "TI"],
  " are considered to have depth 0 and yield ",
  StyleBox["True", "MR"],
  " when tested with ",
  StyleBox["AtomQ", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.1.4", "4.4"}],

Cell[TextData[{
  "As an optimization for some special kinds of computations, the raw data in \
",
  StyleBox["Mathematica", "TI"],
  " atomic objects can be given explicitly using ",
  StyleBox["Raw[", "MR"],
  StyleBox["head", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["\"", "MR"],
  StyleBox["hexstring", "TI"],
  StyleBox["\"]", "MR"],
  ". The data is specified as a string of hexadecimal digits, corresponding \
to an array of bytes. When no special output form exists, ",
  StyleBox["InputForm", "MR"],
  " prints special objects using ",
  StyleBox["Raw", "MR"],
  ". ",
  StyleBox["The behavior of ", "TI"],
  StyleBox["Raw", "MR"],
  StyleBox[" differs from one implementation of Mathematica to another; its \
general use is strongly discouraged.", "TI"],
  " "
}], "Text",
  CellTags->{"SA.1.4", "4.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.1.5 Numbers", "Subsection",
  CellTags->{"SA.1.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Integer", "MR"],
              " "
            }]], Cell[TextData[{
              "integer ",
              StyleBox["nnnn", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Real", "MR"],
              " "
            }]], Cell[TextData[{
              "approximate real number ",
              StyleBox["nnn", "TI"],
              StyleBox[".", "MR"],
              StyleBox["nnn", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Rational", "MR"],
              " "
            }]], Cell[TextData[{
              "rational number ",
              StyleBox["nnn", "TI"],
              StyleBox["/", "MR"],
              StyleBox["nnn", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Complex", "MR"],
              " "
            }]], Cell[TextData[{
              "complex number ",
              StyleBox["nnn", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["nnn", "TI"],
              " ",
              StyleBox["I", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.1.5"],

Cell["Basic types of numbers. ", "Caption",
  CellTags->"SA.1.5"],

Cell[TextData[{
  "All numbers in ",
  StyleBox["Mathematica", "TI"],
  " can contain any number of digits. ",
  StyleBox["Mathematica", "TI"],
  " does exact computations when possible with integers and rational numbers, \
and with complex numbers whose real and imaginary parts are integers or \
rational numbers. "
}], "Text",
  CellTags->{"SA.1.5", "5.2"}],

Cell[TextData[{
  "There are two types of approximate real numbers in ",
  StyleBox["Mathematica", "TI"],
  ": ",
  StyleBox["arbitrary precision", "TI"],
  " and ",
  StyleBox["machine precision", "TI"],
  ". In manipulating arbitrary\[Hyphen]precision numbers, ",
  StyleBox["Mathematica", "TI"],
  " always tries to modify the precision so as to ensure that all digits \
actually given are correct. "
}], "Text",
  CellTags->{"SA.1.5", "5.3"}],

Cell["\<\
With machine\[Hyphen]precision numbers, all computations are done \
to the same fixed precision, so some digits given may not be correct. \
\>", \
"Text",
  CellTags->{"SA.1.5", "5.4"}],

Cell[TextData[{
  "Unless otherwise specified, ",
  StyleBox["Mathematica", "TI"],
  " treats as machine\[Hyphen]precision numbers all approximate real numbers \
that lie between ",
  StyleBox["$MinMachineNumber", "MR"],
  " and ",
  StyleBox["$MaxMachineNumber", "MR"],
  " and that are input with less than ",
  StyleBox["$MachinePrecision", "MR"],
  " digits. "
}], "Text",
  CellTags->{"SA.1.5", "5.5"}],

Cell[TextData[{
  "In ",
  StyleBox["InputForm", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " prints machine\[Hyphen]precision numbers with ",
  StyleBox["$MachinePrecision", "MR"],
  " digits, except when trailing digits are zero. "
}], "Text",
  CellTags->{"SA.1.5", "5.6"}],

Cell[TextData[{
  "In any implementation of ",
  StyleBox["Mathematica", "TI"],
  ", the magnitudes of numbers (except 0) must lie between ",
  StyleBox["$MinNumber", "MR"],
  " and ",
  StyleBox["$MaxNumber", "MR"],
  ". Numbers with magnitudes outside this range are represented by ",
  StyleBox["Underflow[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " and ",
  StyleBox["Overflow[", "MR"],
  " ",
  StyleBox["]", "MR"],
  ".  "
}], "Text",
  CellTags->{"SA.1.5", "5.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.1.6 Character Strings", "Subsection",
  CellTags->{"SA.1.6", "6.1"}],

Cell[TextData[{
  "Character strings in ",
  StyleBox["Mathematica", "TI"],
  " can contain any sequence of characters. They are input in the form ",
  StyleBox["\"", "MR"],
  StyleBox["ccccc", "TI"],
  StyleBox["\"", "MR"],
  ".  "
}], "Text",
  CellTags->{"SA.1.6", "6.2"}],

Cell[TextData[{
  "The individual characters can be printable ASCII (with character codes \
between 32 and 126), or in general any 8\[Hyphen] or 16\[Hyphen]bit \
characters. ",
  StyleBox["Mathematica", "TI"],
  " uses the Unicode character encoding for 16\[Hyphen]bit characters. "
}], "Text",
  CellTags->{"SA.1.6", "6.3"}],

Cell[TextData[{
  "In input form, 16\[Hyphen]bit characters are represented when possible in \
the form \[Backslash]",
  StyleBox["[", "MR"],
  StyleBox["name", "TI"],
  StyleBox["]", "MR"],
  ", and otherwise as \[Backslash]",
  StyleBox[":", "MR"],
  StyleBox["nnnn", "TI"],
  ". "
}], "Text",
  CellTags->{"SA.1.6", "6.4"}],

Cell[TextData[{
  "Null bytes can appear at any point within ",
  StyleBox["Mathematica", "TI"],
  " strings. "
}], "Text",
  CellTags->{"SA.1.6", "6.5"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 124}, {28, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.1.0"->{
    Cell[1776, 53, 116, 4, 65, "Section",
      CellTags->{"SA.1.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 116, 4, 65, "Section",
      CellTags->{"SA.1.0", "0.1"}]},
  "SA.1.1"->{
    Cell[1917, 61, 70, 1, 70, "Subsection",
      CellTags->{"SA.1.1", "1.1"}],
    Cell[1990, 64, 168, 6, 70, "Text",
      CellTags->{"SA.1.1", "1.2"}],
    Cell[2161, 72, 987, 38, 70, "Text",
      CellTags->{"SA.1.1", "1.3"}],
    Cell[3151, 112, 818, 34, 70, "Text",
      CellTags->{"SA.1.1", "1.4"}],
    Cell[3972, 148, 2047, 84, 70, "Text",
      CellTags->{"SA.1.1", "1.5"}],
    Cell[6022, 234, 471, 15, 70, "Text",
      CellTags->{"SA.1.1", "1.6"}],
    Cell[6496, 251, 384, 11, 70, "Text",
      CellTags->{"SA.1.1", "1.7"}]},
  "1.1"->{
    Cell[1917, 61, 70, 1, 70, "Subsection",
      CellTags->{"SA.1.1", "1.1"}]},
  "1.2"->{
    Cell[1990, 64, 168, 6, 70, "Text",
      CellTags->{"SA.1.1", "1.2"}]},
  "1.3"->{
    Cell[2161, 72, 987, 38, 70, "Text",
      CellTags->{"SA.1.1", "1.3"}]},
  "1.4"->{
    Cell[3151, 112, 818, 34, 70, "Text",
      CellTags->{"SA.1.1", "1.4"}]},
  "1.5"->{
    Cell[3972, 148, 2047, 84, 70, "Text",
      CellTags->{"SA.1.1", "1.5"}]},
  "1.6"->{
    Cell[6022, 234, 471, 15, 70, "Text",
      CellTags->{"SA.1.1", "1.6"}]},
  "1.7"->{
    Cell[6496, 251, 384, 11, 70, "Text",
      CellTags->{"SA.1.1", "1.7"}]},
  "SA.1.2"->{
    Cell[6917, 267, 66, 1, 70, "Subsection",
      CellTags->{"SA.1.2", "2.1"}],
    Cell[6986, 270, 166, 6, 70, "Text",
      CellTags->{"SA.1.2", "2.2"}],
    Cell[7155, 278, 300, 7, 70, "Text",
      CellTags->{"SA.1.2", "2.3"}],
    Cell[7458, 287, 1110, 34, 70, "DefinitionBox",
      CellTags->"SA.1.2"],
    Cell[8571, 323, 71, 1, 70, "Caption",
      CellTags->"SA.1.2"],
    Cell[8645, 326, 663, 21, 70, "Text",
      CellTags->{"SA.1.2", "2.4"}],
    Cell[9311, 349, 246, 5, 70, "Text",
      CellTags->{"SA.1.2", "2.5"}],
    Cell[9560, 356, 506, 12, 70, "Text",
      CellTags->{"SA.1.2", "2.6"}],
    Cell[10069, 370, 326, 8, 70, "Text",
      CellTags->{"SA.1.2", "2.7"}],
    Cell[10398, 380, 337, 9, 70, "Text",
      CellTags->{"SA.1.2", "2.8"}],
    Cell[10738, 391, 284, 8, 70, "Text",
      CellTags->{"SA.1.2", "2.9"}]},
  "2.1"->{
    Cell[6917, 267, 66, 1, 70, "Subsection",
      CellTags->{"SA.1.2", "2.1"}]},
  "2.2"->{
    Cell[6986, 270, 166, 6, 70, "Text",
      CellTags->{"SA.1.2", "2.2"}]},
  "2.3"->{
    Cell[7155, 278, 300, 7, 70, "Text",
      CellTags->{"SA.1.2", "2.3"}]},
  "2.4"->{
    Cell[8645, 326, 663, 21, 70, "Text",
      CellTags->{"SA.1.2", "2.4"}]},
  "2.5"->{
    Cell[9311, 349, 246, 5, 70, "Text",
      CellTags->{"SA.1.2", "2.5"}]},
  "2.6"->{
    Cell[9560, 356, 506, 12, 70, "Text",
      CellTags->{"SA.1.2", "2.6"}]},
  "2.7"->{
    Cell[10069, 370, 326, 8, 70, "Text",
      CellTags->{"SA.1.2", "2.7"}]},
  "2.8"->{
    Cell[10398, 380, 337, 9, 70, "Text",
      CellTags->{"SA.1.2", "2.8"}]},
  "2.9"->{
    Cell[10738, 391, 284, 8, 70, "Text",
      CellTags->{"SA.1.2", "2.9"}]},
  "SA.1.3"->{
    Cell[11059, 404, 67, 1, 70, "Subsection",
      CellTags->{"SA.1.3", "3.1"}],
    Cell[11129, 407, 615, 19, 70, "Text",
      CellTags->{"SA.1.3", "3.2"}],
    Cell[11747, 428, 481, 15, 70, "Text",
      CellTags->{"SA.1.3", "3.3"}],
    Cell[12231, 445, 1595, 49, 70, "DefinitionBox",
      CellTags->"SA.1.3"],
    Cell[13829, 496, 94, 1, 70, "Caption",
      CellTags->"SA.1.3"],
    Cell[13926, 499, 675, 17, 70, "Text",
      CellTags->{"SA.1.3", "3.4"}],
    Cell[14604, 518, 224, 6, 70, "Text",
      CellTags->{"SA.1.3", "3.5"}]},
  "3.1"->{
    Cell[11059, 404, 67, 1, 70, "Subsection",
      CellTags->{"SA.1.3", "3.1"}]},
  "3.2"->{
    Cell[11129, 407, 615, 19, 70, "Text",
      CellTags->{"SA.1.3", "3.2"}]},
  "3.3"->{
    Cell[11747, 428, 481, 15, 70, "Text",
      CellTags->{"SA.1.3", "3.3"}]},
  "3.4"->{
    Cell[13926, 499, 675, 17, 70, "Text",
      CellTags->{"SA.1.3", "3.4"}]},
  "3.5"->{
    Cell[14604, 518, 224, 6, 70, "Text",
      CellTags->{"SA.1.3", "3.5"}]},
  "SA.1.4"->{
    Cell[14865, 529, 73, 1, 70, "Subsection",
      CellTags->{"SA.1.4", "4.1"}],
    Cell[14941, 532, 205, 6, 70, "Text",
      CellTags->{"SA.1.4", "4.2"}],
    Cell[15149, 540, 512, 9, 70, "Text",
      CellTags->{"SA.1.4", "4.3"}],
    Cell[15664, 551, 1977, 62, 70, "DefinitionBox",
      CellTags->"SA.1.4"],
    Cell[17644, 615, 57, 1, 70, "Caption",
      CellTags->"SA.1.4"],
    Cell[17704, 618, 247, 9, 70, "Text",
      CellTags->{"SA.1.4", "4.4"}],
    Cell[17954, 629, 820, 24, 104, "Text",
      CellTags->{"SA.1.4", "4.5"}]},
  "4.1"->{
    Cell[14865, 529, 73, 1, 70, "Subsection",
      CellTags->{"SA.1.4", "4.1"}]},
  "4.2"->{
    Cell[14941, 532, 205, 6, 70, "Text",
      CellTags->{"SA.1.4", "4.2"}]},
  "4.3"->{
    Cell[15149, 540, 512, 9, 70, "Text",
      CellTags->{"SA.1.4", "4.3"}]},
  "4.4"->{
    Cell[17704, 618, 247, 9, 70, "Text",
      CellTags->{"SA.1.4", "4.4"}]},
  "4.5"->{
    Cell[17954, 629, 820, 24, 104, "Text",
      CellTags->{"SA.1.4", "4.5"}]},
  "SA.1.5"->{
    Cell[18811, 658, 66, 1, 70, "Subsection",
      CellTags->{"SA.1.5", "5.1"}],
    Cell[18880, 661, 1414, 48, 108, "DefinitionBox",
      CellTags->"SA.1.5"],
    Cell[20297, 711, 65, 1, 16, "Caption",
      CellTags->"SA.1.5"],
    Cell[20365, 714, 360, 9, 56, "Text",
      CellTags->{"SA.1.5", "5.2"}],
    Cell[20728, 725, 446, 12, 72, "Text",
      CellTags->{"SA.1.5", "5.3"}],
    Cell[21177, 739, 195, 5, 40, "Text",
      CellTags->{"SA.1.5", "5.4"}],
    Cell[21375, 746, 407, 12, 56, "Text",
      CellTags->{"SA.1.5", "5.5"}],
    Cell[21785, 760, 283, 9, 40, "Text",
      CellTags->{"SA.1.5", "5.6"}],
    Cell[22071, 771, 471, 17, 56, "Text",
      CellTags->{"SA.1.5", "5.7"}]},
  "5.1"->{
    Cell[18811, 658, 66, 1, 70, "Subsection",
      CellTags->{"SA.1.5", "5.1"}]},
  "5.2"->{
    Cell[20365, 714, 360, 9, 56, "Text",
      CellTags->{"SA.1.5", "5.2"}]},
  "5.3"->{
    Cell[20728, 725, 446, 12, 72, "Text",
      CellTags->{"SA.1.5", "5.3"}]},
  "5.4"->{
    Cell[21177, 739, 195, 5, 40, "Text",
      CellTags->{"SA.1.5", "5.4"}]},
  "5.5"->{
    Cell[21375, 746, 407, 12, 56, "Text",
      CellTags->{"SA.1.5", "5.5"}]},
  "5.6"->{
    Cell[21785, 760, 283, 9, 40, "Text",
      CellTags->{"SA.1.5", "5.6"}]},
  "5.7"->{
    Cell[22071, 771, 471, 17, 56, "Text",
      CellTags->{"SA.1.5", "5.7"}]},
  "SA.1.6"->{
    Cell[22579, 793, 76, 1, 38, "Subsection",
      CellTags->{"SA.1.6", "6.1"}],
    Cell[22658, 796, 275, 9, 40, "Text",
      CellTags->{"SA.1.6", "6.2"}],
    Cell[22936, 807, 325, 7, 56, "Text",
      CellTags->{"SA.1.6", "6.3"}],
    Cell[23264, 816, 326, 11, 40, "Text",
      CellTags->{"SA.1.6", "6.4"}],
    Cell[23593, 829, 154, 5, 24, "Text",
      CellTags->{"SA.1.6", "6.5"}]},
  "6.1"->{
    Cell[22579, 793, 76, 1, 38, "Subsection",
      CellTags->{"SA.1.6", "6.1"}]},
  "6.2"->{
    Cell[22658, 796, 275, 9, 40, "Text",
      CellTags->{"SA.1.6", "6.2"}]},
  "6.3"->{
    Cell[22936, 807, 325, 7, 56, "Text",
      CellTags->{"SA.1.6", "6.3"}]},
  "6.4"->{
    Cell[23264, 816, 326, 11, 40, "Text",
      CellTags->{"SA.1.6", "6.4"}]},
  "6.5"->{
    Cell[23593, 829, 154, 5, 24, "Text",
      CellTags->{"SA.1.6", "6.5"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.1.0", 24390, 854},
  {"0.1", 24480, 857},
  {"SA.1.1", 24573, 860},
  {"1.1", 25125, 875},
  {"1.2", 25217, 878},
  {"1.3", 25304, 881},
  {"1.4", 25392, 884},
  {"1.5", 25481, 887},
  {"1.6", 25571, 890},
  {"1.7", 25660, 893},
  {"SA.1.2", 25752, 896},
  {"2.1", 26605, 919},
  {"2.2", 26698, 922},
  {"2.3", 26786, 925},
  {"2.4", 26874, 928},
  {"2.5", 26963, 931},
  {"2.6", 27051, 934},
  {"2.7", 27140, 937},
  {"2.8", 27229, 940},
  {"2.9", 27318, 943},
  {"SA.1.3", 27410, 946},
  {"3.1", 27964, 961},
  {"3.2", 28058, 964},
  {"3.3", 28148, 967},
  {"3.4", 28238, 970},
  {"3.5", 28328, 973},
  {"SA.1.4", 28420, 976},
  {"4.1", 28973, 991},
  {"4.2", 29067, 994},
  {"4.3", 29156, 997},
  {"4.4", 29245, 1000},
  {"4.5", 29334, 1003},
  {"SA.1.5", 29428, 1006},
  {"5.1", 30137, 1025},
  {"5.2", 30231, 1028},
  {"5.3", 30320, 1031},
  {"5.4", 30410, 1034},
  {"5.5", 30499, 1037},
  {"5.6", 30589, 1040},
  {"5.7", 30678, 1043},
  {"SA.1.6", 30771, 1046},
  {"6.1", 31174, 1057},
  {"6.2", 31268, 1060},
  {"6.3", 31357, 1063},
  {"6.4", 31446, 1066},
  {"6.5", 31536, 1069}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 116, 4, 65, "Section",
  CellTags->{"SA.1.0", "0.1"}],

Cell[CellGroupData[{
Cell[1917, 61, 70, 1, 70, "Subsection",
  CellTags->{"SA.1.1", "1.1"}],
Cell[1990, 64, 168, 6, 70, "Text",
  CellTags->{"SA.1.1", "1.2"}],
Cell[2161, 72, 987, 38, 70, "Text",
  CellTags->{"SA.1.1", "1.3"}],
Cell[3151, 112, 818, 34, 70, "Text",
  CellTags->{"SA.1.1", "1.4"}],
Cell[3972, 148, 2047, 84, 70, "Text",
  CellTags->{"SA.1.1", "1.5"}],
Cell[6022, 234, 471, 15, 70, "Text",
  CellTags->{"SA.1.1", "1.6"}],
Cell[6496, 251, 384, 11, 70, "Text",
  CellTags->{"SA.1.1", "1.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6917, 267, 66, 1, 70, "Subsection",
  CellTags->{"SA.1.2", "2.1"}],
Cell[6986, 270, 166, 6, 70, "Text",
  CellTags->{"SA.1.2", "2.2"}],
Cell[7155, 278, 300, 7, 70, "Text",
  CellTags->{"SA.1.2", "2.3"}],
Cell[7458, 287, 1110, 34, 70, "DefinitionBox",
  CellTags->"SA.1.2"],
Cell[8571, 323, 71, 1, 70, "Caption",
  CellTags->"SA.1.2"],
Cell[8645, 326, 663, 21, 70, "Text",
  CellTags->{"SA.1.2", "2.4"}],
Cell[9311, 349, 246, 5, 70, "Text",
  CellTags->{"SA.1.2", "2.5"}],
Cell[9560, 356, 506, 12, 70, "Text",
  CellTags->{"SA.1.2", "2.6"}],
Cell[10069, 370, 326, 8, 70, "Text",
  CellTags->{"SA.1.2", "2.7"}],
Cell[10398, 380, 337, 9, 70, "Text",
  CellTags->{"SA.1.2", "2.8"}],
Cell[10738, 391, 284, 8, 70, "Text",
  CellTags->{"SA.1.2", "2.9"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11059, 404, 67, 1, 70, "Subsection",
  CellTags->{"SA.1.3", "3.1"}],
Cell[11129, 407, 615, 19, 70, "Text",
  CellTags->{"SA.1.3", "3.2"}],
Cell[11747, 428, 481, 15, 70, "Text",
  CellTags->{"SA.1.3", "3.3"}],
Cell[12231, 445, 1595, 49, 70, "DefinitionBox",
  CellTags->"SA.1.3"],
Cell[13829, 496, 94, 1, 70, "Caption",
  CellTags->"SA.1.3"],
Cell[13926, 499, 675, 17, 70, "Text",
  CellTags->{"SA.1.3", "3.4"}],
Cell[14604, 518, 224, 6, 70, "Text",
  CellTags->{"SA.1.3", "3.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[14865, 529, 73, 1, 70, "Subsection",
  CellTags->{"SA.1.4", "4.1"}],
Cell[14941, 532, 205, 6, 70, "Text",
  CellTags->{"SA.1.4", "4.2"}],
Cell[15149, 540, 512, 9, 70, "Text",
  CellTags->{"SA.1.4", "4.3"}],
Cell[15664, 551, 1977, 62, 70, "DefinitionBox",
  CellTags->"SA.1.4"],
Cell[17644, 615, 57, 1, 70, "Caption",
  CellTags->"SA.1.4"],
Cell[17704, 618, 247, 9, 70, "Text",
  CellTags->{"SA.1.4", "4.4"}],
Cell[17954, 629, 820, 24, 104, "Text",
  CellTags->{"SA.1.4", "4.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[18811, 658, 66, 1, 70, "Subsection",
  CellTags->{"SA.1.5", "5.1"}],
Cell[18880, 661, 1414, 48, 108, "DefinitionBox",
  CellTags->"SA.1.5"],
Cell[20297, 711, 65, 1, 16, "Caption",
  CellTags->"SA.1.5"],
Cell[20365, 714, 360, 9, 56, "Text",
  CellTags->{"SA.1.5", "5.2"}],
Cell[20728, 725, 446, 12, 72, "Text",
  CellTags->{"SA.1.5", "5.3"}],
Cell[21177, 739, 195, 5, 40, "Text",
  CellTags->{"SA.1.5", "5.4"}],
Cell[21375, 746, 407, 12, 56, "Text",
  CellTags->{"SA.1.5", "5.5"}],
Cell[21785, 760, 283, 9, 40, "Text",
  CellTags->{"SA.1.5", "5.6"}],
Cell[22071, 771, 471, 17, 56, "Text",
  CellTags->{"SA.1.5", "5.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22579, 793, 76, 1, 38, "Subsection",
  CellTags->{"SA.1.6", "6.1"}],
Cell[22658, 796, 275, 9, 40, "Text",
  CellTags->{"SA.1.6", "6.2"}],
Cell[22936, 807, 325, 7, 56, "Text",
  CellTags->{"SA.1.6", "6.3"}],
Cell[23264, 816, 326, 11, 40, "Text",
  CellTags->{"SA.1.6", "6.4"}],
Cell[23593, 829, 154, 5, 24, "Text",
  CellTags->{"SA.1.6", "6.5"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

