(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    405060,      11756]*)
(*NotebookOutlinePosition[    430545,      12513]*)
(*  CellTagsIndexPosition[    427557,      12398]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.2 ", "HeadingNumber"],
  "Input Syntax"
}], "Section",
  CellTags->{"SA.2.0", "0.1"}],

Cell[CellGroupData[{

Cell["A.2.1 Entering Characters", "Subsection",
  CellTags->{"SA.2.1", "1.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] Enter it directly (e.g. ",
              StyleBox["+", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Enter it by full name (e.g. \[Backslash]",
              
              StyleBox["[Alpha]", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              
              "\[FilledSmallSquare] Enter it by alias (e.g. \
\[AliasIndicator]",
              StyleBox["a\[AliasIndicator]", "MR"],
              ") (notebook front end only) "
            }]]},
          {
            Cell["\<\
\[FilledSmallSquare] Enter it by choosing from a \
palette (notebook front end only) \
\>"]},
          {Cell[TextData[{
              
              "\[FilledSmallSquare] Enter it by character code (e.g. \
\[Backslash]",
              StyleBox["053", "MR"],
              ") "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.1"],

Cell["Typical ways to enter characters. ", "Caption",
  CellTags->"SA.2.1"],

Cell[TextData[{
  "All printable ASCII characters can be entered directly. Those that are not \
alphanumeric are assigned explicit names in ",
  StyleBox["Mathematica", "TI"],
  ", allowing them to be entered even on keyboards where they do not \
explicitly appear. "
}], "Text",
  CellTags->{"SA.2.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[" "], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawSpace]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["!", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawExclamation]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["\"", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawDoubleQuote]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["#", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawNumberSign]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["$", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawDollar]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["%", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawPercent]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["&", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawAmpersand]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["'", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawQuote]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["(", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawLeftParenthesis]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox[")", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawRightParenthesis]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["*", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawStar]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["+", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawPlus]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox[",", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawComma]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["-", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawDash]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox[".", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawDot]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["/", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawSlash]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox[":", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawColon]", "MR"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]], 
            Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox[";", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawSemicolon]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["<", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawLess]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["=", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawEqual]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox[">", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawGreater]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["?", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawQuestion]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["@", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawAt]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["[", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawLeftBracket]", "MR"],
                          " "
                        }]]},
                      {Cell["\[Backslash] "], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawBackslash]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["]", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawRightBracket]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["^", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawWedge]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["_", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawUnderscore]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["`", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawBackquote]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["{", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawLeftBrace]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["|", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawVerticalBar]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["}", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawRightBrace]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["~", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawTilde]", "MR"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"SA.2.1"],

Cell["\<\
Full names for non\[Hyphen]alphanumeric printable ASCII characters. \
\
\>", "Caption",
  CellTags->"SA.2.1"],

Cell[TextData[{
  "All characters which are entered into the ",
  StyleBox["Mathematica", "TI"],
  " kernel are interpreted according to the setting for the ",
  StyleBox["CharacterEncoding", "MR"],
  " option for the stream from which they came. "
}], "Text",
  CellTags->{"SA.2.1", "1.3"}],

Cell[TextData[{
  "In the ",
  StyleBox["Mathematica", "TI"],
  " front end, characters entered on the keyboard are interpreted according \
to the current setting of the ",
  StyleBox["CharacterEncoding", "MR"],
  " option for the current notebook. "
}], "Text",
  CellTags->{"SA.2.1", "1.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Name] ", "TI"]
            }]], Cell["a character with the specified full name "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["nnn ", "TI"]
            }]], Cell[TextData[{
              "a character with octal code ",
              StyleBox["nnn", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox[".nn ", "TI"]
            }]], Cell[TextData[{
              "a character with hexadecimal code ",
              StyleBox["nn", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox[":nnnn ", "TI"]
            }]], Cell[TextData[{
              "a character with hexadecimal code ",
              StyleBox["nnnn", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.1"],

Cell["Ways to enter characters. ", "Caption",
  CellTags->"SA.2.1"],

Cell[TextData[{
  "Codes for characters can be generated using ",
  StyleBox["ToCharacterCode", "MR"],
  ". The Unicode standard is followed, with various extensions. "
}], "Text",
  CellTags->{"SA.2.1", "1.5"}],

Cell[TextData[{
  "8\[Hyphen]bit characters have codes less than 256; 16\[Hyphen]bit \
characters have codes between 256 and 65535. Approximately 750 characters are \
assigned explicit names in ",
  StyleBox["Mathematica", "TI"],
  ". Other characters must be entered using their character codes. "
}], "Text",
  CellTags->{"SA.2.1", "1.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["\[Backslash]\[Backslash] "], Cell[
            "single backslash (decimal code 92) "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["b", "MR"],
              " "
            }]], 
            Cell["\<\
backspace or Control\[Hyphen]H (decimal code 8) \
\
\>"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["t", "MR"],
              " "
            }]], Cell["\<\
tab or Control\[Hyphen]I (decimal code 9) \
\>"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["n", "MR"],
              " "
            }]], Cell[TextData[{
              
              "newline or Control\[Hyphen]J (decimal code 10; full name \
\[Backslash]",
              StyleBox["[NewLine]", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["f", "MR"],
              " "
            }]], 
            Cell["\<\
form feed or Control\[Hyphen]L (decimal code 12) \
\
\>"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["r", "MR"],
              " "
            }]], 
            Cell["\<\
carriage return or Control\[Hyphen]M (decimal code 13) \
\
\>"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["000", "MR"],
              " "
            }]], Cell["null byte (code 0) "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.1"],

Cell["\<\
Some special 8\[Hyphen]bit characters. \
\>", "Caption",
  CellTags->"SA.2.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.2.2 Types of Input Syntax", "Subsection",
  CellTags->{"SA.2.2", "2.1"}],

Cell[TextData[{
  "This appendix describes the standard input syntax used by ",
  StyleBox["Mathematica", "TI"],
  ". This input syntax is the one used by default in ",
  StyleBox["InputForm", "MR"],
  " and ",
  StyleBox["StandardForm", "MR"],
  ". You can modify the syntax by making definitions for ",
  StyleBox["MakeExpression[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.2", "2.2"}],

Cell["\<\
Options can be set to specify what form of input should be accepted \
by a particular cell in a notebook or from a particular stream. \
\>", "Text",\

  CellTags->{"SA.2.2", "2.3"}],

Cell[TextData[{
  "The input syntax in ",
  StyleBox["TraditionalForm", "MR"],
  ", for example, is different from that in ",
  StyleBox["InputForm", "MR"],
  " and ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.2", "2.4"}],

Cell[TextData[{
  "In general, what input syntax does is to determine how a particular string \
or collection of boxes should be interpreted as an expression. When boxes are \
set up, say with the notebook front end, there can be hidden ",
  StyleBox["InterpretationBox", "MR"],
  " or ",
  StyleBox["TagBox", "MR"],
  " objects which modify the interpretation of the boxes. "
}], "Text",
  CellTags->{"SA.2.2", "2.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.2.3 Character Strings", "Subsection",
  CellTags->{"SA.2.3", "3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"", "MR"],
              StyleBox["characters", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["a character string "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["\"", "MR"],
              " "
            }]], Cell[TextData[{
              "a literal ",
              StyleBox["\"", "MR"],
              " in a character string "
            }]]},
          {Cell["\[Backslash]\[Backslash] "], 
            Cell["\<\
a literal \[Backslash] in a character string \
\>"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["<", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["\[Backslash]>", "MR"],
              " "
            }]], Cell[
            "a substring in which newlines are interpreted literally "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["\[Backslash])", "MR"],
              " "
            }]], 
            Cell["\<\
a substring representing two\[Hyphen]dimensional boxes \
\
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.3"],

Cell["Entering character strings. ", "Caption",
  CellTags->"SA.2.3"],

Cell["\<\
Character strings can contain any sequence of 8\[Hyphen] or 16\
\[Hyphen]bit characters. Characters entered by name or character code are \
stored the same as if they were entered directly. \
\>", "Text",
  CellTags->{"SA.2.3", "3.2"}],

Cell[TextData[{
  "Raw newlines and tabs are normally converted to spaces when a string is \
entered, unless they occur within \[Backslash]",
  StyleBox["<", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash]>", "MR"],
  ", in which case they are left unchanged.  "
}], "Text",
  CellTags->{"SA.2.3", "3.3"}],

Cell[TextData[{
  "Within \[Backslash]",
  StyleBox["!\[Backslash](", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " any box structures represented using backslash sequences can be used. "
}], "Text",
  CellTags->{"SA.2.3", "3.4"}],

Cell[TextData[{
  StyleBox["StringExpression", "MR"],
  " objects can be used to represent strings that contain symbolic \
constructs, such as pattern elements. "
}], "Text",
  CellTags->{"SA.2.3", "3.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.2.4 Symbol Names and Contexts", "Subsection",
  CellTags->{"SA.2.4", "4.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["name", "TI"],
              " "
            }]], Cell["symbol name "]},
          {Cell[TextData[{
              StyleBox["`", "MR"],
              StyleBox["name", "TI"],
              " "
            }]], Cell["symbol name in current context "]},
          {Cell[TextData[{
              StyleBox["context", "TI"],
              StyleBox["`", "MR"],
              StyleBox["name", "TI"],
              " "
            }]], Cell["symbol name in specified context "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.4"],

Cell["Symbol names and contexts. ", "Caption",
  CellTags->"SA.2.4"],

Cell[TextData[{
  "Symbol names and contexts can contain any characters that are treated by \
",
  StyleBox["Mathematica", "TI"],
  " as letters or letter\[Hyphen]like forms. They can contain digits but \
cannot start with them. "
}], "Text",
  CellTags->{"SA.2.4", "4.2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.2.5 Numbers", "Subsection",
  CellTags->{"SA.2.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["digits", "TI"],
              " "
            }]], Cell["integer "]},
          {Cell[TextData[{
              StyleBox["digits", "TI"],
              StyleBox[".", "MR"],
              StyleBox["digits", "TI"],
              " "
            }]], Cell["approximate number "]},
          {Cell[TextData[{
              StyleBox["base", "TI"],
              StyleBox["^^", "MR"],
              StyleBox["digits", "TI"],
              " "
            }]], Cell["integer in specified base "]},
          {Cell[TextData[{
              StyleBox["base", "TI"],
              StyleBox["^^", "MR"],
              StyleBox["digits", "TI"],
              StyleBox[".", "MR"],
              StyleBox["digits", "TI"],
              " "
            }]], Cell["approximate number in specified base "]},
          {Cell[TextData[{
              StyleBox["mantissa", "TI"],
              StyleBox["*^", "MR"],
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "scientific notation (",
              StyleBox["mantissa", "TI"],
              " ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\(\[Cross]\)\(\ \)\), 
                      SuperscriptBox["10", 
                        StyleBox["n",
                          "TI"]]}], TraditionalForm]], "InlineFormula"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["base", "TI"],
              StyleBox["^^", "MR"],
              StyleBox["mantissa", "TI"],
              StyleBox["*^", "MR"],
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "scientific notation in specified base (",
              StyleBox["mantissa", "TI"],
              " ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\(\[Cross]\)\(\ \)\), 
                      SuperscriptBox[
                        StyleBox["base",
                          "TI"], 
                        StyleBox["n",
                          "TI"]]}], TraditionalForm]], "InlineFormula"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["number", "TI"],
              StyleBox["`", "MR"],
              " "
            }]], 
            Cell["\<\
machine\[Hyphen]precision approximate number \
\>"]},
          {Cell[TextData[{
              StyleBox["number", "TI"],
              StyleBox["`", "MR"],
              StyleBox["s", "TI"],
              " "
            }]], Cell[TextData[{
              "arbitrary\[Hyphen]precision number with precision ",
              StyleBox["s", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["number", "TI"],
              StyleBox["``", "MR"],
              StyleBox["s", "TI"],
              " "
            }]], Cell[TextData[{
              "arbitrary\[Hyphen]precision number with accuracy ",
              StyleBox["s", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.5"],

Cell["Input forms for numbers. ", "Caption",
  CellTags->"SA.2.5"],

Cell[TextData[{
  "Numbers can be entered with the notation ",
  StyleBox["base", "TI"],
  StyleBox["^^", "MR"],
  StyleBox["digits", "TI"],
  " in any base from ",
  StyleBox["2", "MR"],
  " to ",
  StyleBox["36", "MR"],
  ". The base itself is given in decimal. For bases larger than ",
  StyleBox["10", "MR"],
  ", additional digits are chosen from the letters ",
  StyleBox["a", "MR"],
  "\[Dash]",
  StyleBox["z", "MR"],
  " or ",
  StyleBox["A", "MR"],
  "\[Dash]",
  StyleBox["Z", "MR"],
  ". Upper\[Hyphen] and lower\[Hyphen]case letters are equivalent for these \
purposes. Floating\[Hyphen]point numbers can be specified by including ",
  StyleBox[".", "MR"],
  " in the ",
  StyleBox["digits", "TI"],
  " sequence.  "
}], "Text",
  CellTags->{"SA.2.5", "5.2"}],

Cell[TextData[{
  "In scientific notation, ",
  StyleBox["mantissa", "TI"],
  " can contain ",
  StyleBox["`", "MR"],
  " marks. The exponent ",
  StyleBox["n", "TI"],
  " must always be an integer, specified in decimal.   "
}], "Text",
  CellTags->{"SA.2.5", "5.3"}],

Cell[TextData[{
  "The precision or accuracy ",
  StyleBox["s", "TI"],
  " can be any real number; it does not need to be an integer. "
}], "Text",
  CellTags->{"SA.2.5", "5.4"}],

Cell[TextData[{
  "In the form ",
  StyleBox["base", "TI"],
  StyleBox["^^", "MR"],
  StyleBox["number", "TI"],
  StyleBox["`", "MR"],
  StyleBox["s", "TI"],
  " the precision ",
  StyleBox["s", "TI"],
  " is given in decimal, but it gives the effective number of digits of \
precision in the specified base, not in base 10. "
}], "Text",
  CellTags->{"SA.2.5", "5.5"}],

Cell[TextData[{
  "An approximate number ",
  StyleBox["x", "TI"],
  " is taken to be machine precision if the number of digits given in it is \
",
  StyleBox["Ceiling[$MachinePrecision]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  " or less. If more digits are given, then ",
  StyleBox["x", "TI"],
  " is taken to be an arbitrary\[Hyphen]precision number. The accuracy of ",
  StyleBox["x", "TI"],
  " is taken to be the number of digits that appear to the right of the \
decimal point, while its precision is taken to be ",
  StyleBox["Log[10,", "MR"],
  " ",
  StyleBox["Abs[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["Accuracy[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.5", "5.6"}],

Cell[TextData[{
  "A number entered in the form ",
  StyleBox["0``", "MR"],
  StyleBox["s", "TI"],
  " is taken to have precision ",
  StyleBox["Indeterminate", "MR"],
  " and accuracy ",
  StyleBox["s", "TI"],
  ". "
}], "Text",
  CellTags->{"SA.2.5", "5.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.2.6 Bracketed Objects", "Subsection",
  CellTags->{"SA.2.6", "6.1"}],

Cell[TextData[{
  "Bracketed objects use explicit left and right delimiters to indicate their \
extent. They can appear anywhere within ",
  StyleBox["Mathematica", "TI"],
  " input, and can be nested in any way. "
}], "Text",
  CellTags->{"SA.2.6", "6.2"}],

Cell[TextData[{
  "The delimiters in bracketed objects are ",
  StyleBox["matchfix operators", "TI"],
  ". But since these delimiters explicitly enclose all operands, no \
precedence need be assigned to such operators. "
}], "Text",
  CellTags->{"SA.2.6", "6.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["(*", "MR"],
              " ",
              StyleBox["any", "TI"],
              " ",
              StyleBox["text", "TI"],
              " ",
              StyleBox["*)", "MR"],
              " "
            }]], Cell["comment "]},
          {Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["parenthesization: grouping of input "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.6"],

Cell["\<\
Bracketed objects without comma\[Hyphen]separated elements. \
\>", \
"Caption",
  CellTags->"SA.2.6"],

Cell["\<\
Comments can be nested, and can continue for any number of lines. \
They can contain any 8\[Hyphen] or 16\[Hyphen]bit characters.  \
\>", "Text",
  CellTags->{"SA.2.6", "6.4"}],

Cell[TextData[{
  "Parentheses must enclose a single complete expression; neither ",
  StyleBox["(", "MR"],
  StyleBox["e", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["e", "TI"],
  StyleBox[")", "MR"],
  " nor ",
  StyleBox["(", "MR"],
  " ",
  StyleBox[")", "MR"],
  " are allowed. "
}], "Text",
  CellTags->{"SA.2.6", "6.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["List[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
              
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              "  ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightAngleBracket]\)], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["AngleBracket[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftFloor]\)], "InlineFormula"],
              " ",
              StyleBox["expr", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightFloor]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Floor[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftCeiling]\)], "InlineFormula"],
              " ",
              StyleBox["expr", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightCeiling]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Ceiling[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftBracketingBar]\)], 
                "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              "  ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightBracketingBar]\)], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["BracketingBar[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftDoubleBracketingBar]\)], 
                "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              "  ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightDoubleBracketingBar]\)], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["DoubleBracketingBar[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["(", "MR"],
              StyleBox["input", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              " "
            }]], Cell["input or grouping of boxes "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.6"],

Cell["\<\
Bracketed objects that allow comma\[Hyphen]separated elements. \
\
\>", "Caption",
  CellTags->"SA.2.6"],

Cell["\<\
Throughout this book the notation  \[Ellipsis]  is used to stand \
for any sequence of expressions. \
\>", "Text",
  CellTags->{"SA.2.6", "6.6"}],

Cell[TextData[{
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  " can include any number of elements, with successive elements separated by \
commas. "
}], "Text",
  CellTags->{"SA.2.6", "6.7"}],

Cell[TextData[{
  StyleBox["{", "MR"],
  " ",
  StyleBox["}", "MR"],
  " is ",
  StyleBox["List[", "MR"],
  " ",
  StyleBox["]", "MR"],
  ", a list with zero elements. "
}], "Text",
  CellTags->{"SA.2.6", "6.8"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightAngleBracket]\)], "InlineFormula"],
  " can be entered as \[Backslash]",
  StyleBox["[LeftAngleBracket]", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash][RightAngleBracket]", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.6", "6.9"}],

Cell[TextData[{
  "The character \[Backslash]",
  StyleBox["[InvisibleComma]", "MR"],
  " can be used interchangeably with ordinary commas; the only difference is \
that \[Backslash]",
  StyleBox["[InvisibleComma]", "MR"],
  " will not be displayed. "
}], "Text",
  CellTags->{"SA.2.6", "6.10"}],

Cell[TextData[{
  "When the delimiters are special characters, it is a convention that they \
are named \[Backslash]",
  StyleBox["[Left", "MR"],
  StyleBox["Name", "TI"],
  StyleBox["]", "MR"],
  " and \[Backslash]",
  StyleBox["[Right", "MR"],
  StyleBox["Name", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.6", "6.11"}],

Cell[TextData[{
  "\[Backslash]",
  StyleBox["(", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " is used to enter boxes using one\[Hyphen]dimensional strings. Note that \
within the outermost \[Backslash]",
  StyleBox["(", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " in a piece of input the syntax used is slightly different from outside, \
as described in Section\[NonBreakingSpace]",
  ButtonBox["A.2.9",
    ButtonData:>{"A.2.9", "9.9"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"SA.2.6", "6.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["h", "TI"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["standard expression "]},
          {Cell[TextData[{
              StyleBox["e", "TI"],
              StyleBox["[[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["e", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["e", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftDoubleBracket]\)], 
                "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              "  ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightDoubleBracket]\)], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["e", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.6"],

Cell["Bracketed objects with heads. ", "Caption",
  CellTags->"SA.2.6"],

Cell["\<\
Bracketed objects with heads explicitly delimit all their operands \
except the head. A precedence must be assigned to define the extent of the \
head. \
\>", "Text",
  CellTags->{"SA.2.6", "6.13"}],

Cell[TextData[{
  "The precedence of ",
  StyleBox["h", "TI"],
  StyleBox["[", "MR"],
  StyleBox["e", "TI"],
  StyleBox["]", "MR"],
  " is high enough that ",
  StyleBox["!", "MR"],
  StyleBox["h", "TI"],
  StyleBox["[", "MR"],
  StyleBox["e", "TI"],
  StyleBox["]", "MR"],
  " is interpreted as ",
  StyleBox["Not[", "MR"],
  StyleBox["h", "TI"],
  StyleBox["[", "MR"],
  StyleBox["e", "TI"],
  StyleBox["]]", "MR"],
  ". However, ",
  StyleBox["h", "TI"],
  StyleBox["_", "MR"],
  StyleBox["s", "TI"],
  StyleBox["[", "MR"],
  StyleBox["e", "TI"],
  StyleBox["]", "MR"],
  " is interpreted as ",
  StyleBox["(", "MR"],
  StyleBox["h", "TI"],
  StyleBox["_", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")[", "MR"],
  StyleBox["e", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.6", "6.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.2.7 Operator Input Forms", "Subsection",
  CellTags->{"SA.2.7", "7.1"}],

Cell[TextData[{
  "Characters that are not letters, letter\[Hyphen]like forms or structural \
elements are treated by ",
  StyleBox["Mathematica", "TI"],
  " as ",
  StyleBox["operators", "TI"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " has built\[Hyphen]in rules for interpreting all operators. The functions \
to which these operators correspond may or may not, however, have built\
\[Hyphen]in evaluation or other rules. Cases in which built\[Hyphen]in \
meanings are by default defined are indicated by ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftTriangle] \)], "InlineFormula"],
  " in the tables below. "
}], "Text",
  CellTags->{"SA.2.7", "7.2"}],

Cell[TextData[{
  "Operators that construct two\[Hyphen]dimensional boxes\[LongDash]all of \
which have names beginning with back\[Hyphen]slash\[LongDash]can only be used \
inside \[Backslash]",
  StyleBox["(", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  ". The table below gives the interpretations of these operators within \
\[Backslash]",
  StyleBox["!\[Backslash](", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  ". Section\[NonBreakingSpace]",
  ButtonBox["A.2.9",
    ButtonData:>{"A.2.9", "9.11"},
    ButtonStyle->"MainBookLink"],
  " gives interpretations when no \[Backslash]",
  StyleBox["!", "MR"],
  " is included. "
}], "Text",
  CellTags->{"SA.2.7", "7.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " \[ThinSpace]and \[ThinSpace]",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell["any expression "]},
          {Cell[TextData[{
              StyleBox["symb", "TI"],
              " "
            }]], Cell["any symbol "]},
          {Cell[TextData[{
              StyleBox["patt", "TI"],
              " "
            }]], Cell["any pattern object "]},
          {Cell[TextData[{
              StyleBox["string", "TI"],
              " \[ThinSpace]and \[ThinSpace]",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["string",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["\"", "MR"],
              StyleBox["cccc", "TI"],
              StyleBox["\"", "MR"],
              
              " or a sequence of letters, letter\[Hyphen]like forms and \
digits "
            }]]},
          {Cell[TextData[{
              StyleBox["filename", "TI"],
              " "
            }]], Cell[TextData[{
              "like ",
              StyleBox["string", "TI"],
              ", but can include additional characters described below "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\` \[LeftTriangle] \)], "InlineFormula"],
              " "
            }]], Cell["built\[Hyphen]in meanings exist "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.7"],

Cell["Objects used in the tables of operator input forms. ", "Caption",
  CellTags->"SA.2.7"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["operator form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["full form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["grouping", "SO10"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              StyleBox[
              "forms representing numbers (see Section\[NonBreakingSpace]", 
                "TI"],
              StyleBox[ButtonBox["A.2.5",
                ButtonData:>{"A.2.5", "5.1"},
                ButtonStyle->"MainBookLink"], "TI"],
              StyleBox[")", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], Cell[
            "\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox[
              "forms representing symbols (see Section\[NonBreakingSpace]", 
                "TI"],
              StyleBox[ButtonBox["A.2.4",
                ButtonData:>{"A.2.4", "4.1"},
                ButtonStyle->"MainBookLink"], "TI"],
              StyleBox[")", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], Cell[
            "\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox[
              "forms representing character strings (see Section\
\[NonBreakingSpace]", "TI"],
              StyleBox[ButtonBox["A.2.3",
                ButtonData:>{"A.2.3", "3.1"},
                ButtonStyle->"MainBookLink"], "TI"],
              StyleBox[")", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], Cell[
            "\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[GridBox[{
                      {
                        StyleBox[\(e\_11\),
                          "TI"], 
                        StyleBox[\(e\_12\),
                          "TI"], "\[Ellipsis]"},
                      {
                        StyleBox[\(e\_21\),
                          "TI"], 
                        StyleBox[\(e\_22\),
                          "TI"], "\[Ellipsis]"},
                      {"\[Ellipsis]", "", ""}
                      }]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "11"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "12"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "21"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "22"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] }",
              StyleBox[" ", "TR"]
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{"\[Piecewise]", GridBox[{
                        {
                          StyleBox[\(e\_11\),
                            "TI"], 
                          StyleBox[\(e\_12\),
                            "TI"]},
                        {
                          StyleBox[\(e\_21\),
                            "TI"], 
                          StyleBox[\(e\_22\),
                            "TI"]},
                        {"\[Ellipsis]", ""}
                        }]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Piecewise[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "11"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "12"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "21"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "22"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              StyleBox["::", "MR"],
              StyleBox["string", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["MessageName[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              StyleBox["::", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["string",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["::", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["string",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["MessageName[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["string",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["string",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["forms containing ", "TI"],
              StyleBox["#", "MR"],
              StyleBox[" (see Section\[NonBreakingSpace]", "TI"],
              StyleBox[ButtonBox["A.2.7",
                ButtonData:>{"A.2.7", "7.3"},
                ButtonStyle->"MainBookLink"], "TI"],
              StyleBox[")", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], Cell[
            "\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["forms containing ", "TI"],
              StyleBox["%", "MR"],
              StyleBox[" (see Section\[NonBreakingSpace]", "TI"],
              StyleBox[ButtonBox["A.2.7",
                ButtonData:>{"A.2.7", "7.3"},
                ButtonStyle->"MainBookLink"], "TI"],
              StyleBox[")", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], Cell[
            "\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["forms containing ", "TI"],
              StyleBox["_", "MR"],
              StyleBox[" (see Section\[NonBreakingSpace]", "TI"],
              StyleBox[ButtonBox["A.2.7",
                ButtonData:>{"A.2.7", "7.3"},
                ButtonStyle->"MainBookLink"], "TI"],
              StyleBox[")", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], Cell[
            "\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["<<", "MR"],
              " ",
              StyleBox["filename", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Get[\"", "MR"],
              StyleBox["filename", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  OverscriptBox[
                    StyleBox[\(expr\_1\),
                      "TI"], 
                    StyleBox[\(expr\_2\),
                      "TI"]]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Overscript[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  OverscriptBox[
                    StyleBox["e",
                      "TI"], 
                    RowBox[{"(", 
                      OverscriptBox[
                        StyleBox["e",
                          "TI"], 
                        StyleBox["e",
                          "TI"]], ")"}]]], "InlineFormula"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]&", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Overscript[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              "\[Backslash]",
              StyleBox["&(", "MR"],
              StyleBox["e", "TI"],
              "\[Backslash]",
              StyleBox["&", "MR"],
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  UnderscriptBox[
                    StyleBox[\(expr\_1\),
                      "TI"], 
                    StyleBox[\(expr\_2\),
                      "TI"]]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Underscript[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  UnderscriptBox[
                    StyleBox["e",
                      "TI"], 
                    RowBox[{"(", 
                      AdjustmentBox[
                        UnderscriptBox[
                          StyleBox["e",
                            "TI"], 
                          StyleBox["e",
                            "TI"]],
                        BoxBaselineShift->-1], ")"}]]], "InlineFormula"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]+", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Underscript[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              "\[Backslash]",
              StyleBox["+(", "MR"],
              StyleBox["e", "TI"],
              "\[Backslash]",
              StyleBox["+", "MR"],
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  UnderoverscriptBox[
                    StyleBox[\(expr\_1\),
                      "TI"], 
                    StyleBox[\(expr\_2\),
                      "TI"], 
                    StyleBox[\(expr\_3\),
                      "TI"]]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Underoverscript[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]+", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]%", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Underoverscript[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]&", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]%", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Underoverscript[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox[\(expr\_1\),
                      "TI"], 
                    StyleBox[\(expr\_2\),
                      "TI"]]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Subscript[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["e",
                      "TI"], 
                    RowBox[{"(", 
                      SubscriptBox[
                        StyleBox["e",
                          "TI"], 
                        StyleBox["e",
                          "TI"]], ")"}]]], "InlineFormula"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]_", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Subscript[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              "\[Backslash]",
              StyleBox["_(", "MR"],
              StyleBox["e", "TI"],
              "\[Backslash]",
              StyleBox["_", "MR"],
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]_", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]%", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Power[Subscript[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["],", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!", "MR"],
              StyleBox["boxes", "TI"],
              " "
            }]], Cell[TextData[{
              "(interpreted version of ",
              StyleBox["boxes", "TI"],
              ") "
            }]], Cell[""], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["?", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["PatternTest[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              StyleBox["[", "MR"],
              StyleBox["e", "TI"],
              StyleBox["])[", "MR"],
              StyleBox["e", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["[[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Part[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["e", "TI"],
              StyleBox["]])[[", "MR"],
              StyleBox["e", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftDoubleBracket]\)], 
                "InlineFormula"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightDoubleBracket]\)], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Part[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftDoubleBracket]\)], 
                "InlineFormula"],
              StyleBox["e", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[RightDoubleBracket]\)], 
                "InlineFormula"],
              StyleBox[")", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftDoubleBracket]\)], 
                "InlineFormula"],
              StyleBox["e", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[RightDoubleBracket]\)], 
                "InlineFormula"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox[\(expr\_1\),
                      "TI"], 
                    RowBox[{"\[LeftDoubleBracket]", 
                      RowBox[{
                        StyleBox[\(expr\_2\),
                          "TI"], ",", "\[Ellipsis]"}], 
                      "\[RightDoubleBracket]"}]]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Part[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  SubscriptBox[
                    RowBox[{"(", 
                      SubscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{"\[LeftDoubleBracket]", 
                          StyleBox["e",
                            "TI"], "\[RightDoubleBracket]"}]], ")"}], 
                    RowBox[{"\[LeftDoubleBracket]", 
                      StyleBox["e",
                        "TI"], "\[RightDoubleBracket]"}]]], "InlineFormula"],
              " "
            }]], Cell["\[LeftTriangle]"]}
          },
        ColumnAlignments->{Left, Left, Left, Right}], 
      TraditionalForm]], "PrecedenceTable",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, False, False, True, False, True, False, True, True, True, True, 
      True, False, False, False, False, False, False, True, False, False, 
      True, True, True, False}},
  CellTags->"SA.2.7"],

Cell["\<\
Operator input forms, in order of decreasing precedence, part \
one.\
\>", "Caption",
  CellTags->"SA.2.7"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["operator form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["full form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["grouping", "SO10"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["*", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              "(boxes constructed from ",
              StyleBox["expr", "TI"],
              ") "
            }]], Cell[""], "\[Null]"},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              StyleBox["++", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Increment[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              StyleBox["--", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Decrement[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["++", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["PreIncrement[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["--", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["PreDecrement[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["@", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["@", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["@", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[" ", "TI"]
            }]], Cell[TextData[{
              StyleBox["(invisible application, input as ", "TI"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[AliasIndicator]@\[AliasIndicator]", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[") ", "TI"]
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[""], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["~", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["~", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["~", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["~", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              StyleBox["~", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["~", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["/@", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Map[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["/@", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["/@", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["//@", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["MapAll[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["//@", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["//@", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["@@", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Apply[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["@@", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["@@", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["@@@", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Apply[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{1}]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["@@@", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["@@@", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              StyleBox["!", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Factorial[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              StyleBox["!!", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Factorial2[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["expr",
                      "TI"], "\[Conjugate]"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Conjugate[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["expr",
                      "TI"], "\[Transpose]"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Transpose[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["expr",
                      "TI"], "\[ConjugateTranspose]"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["ConjugateTranspose[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["expr",
                      "TI"], "\[HermitianConjugate]"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["ConjugateTranspose[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              StyleBox["'", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Derivative[1][", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              StyleBox["''", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["'", "MR"],
              " (",
              StyleBox["n", "TI"],
              " times) "
            }]], Cell[TextData[{
              StyleBox["Derivative[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["][", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["<>", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["<>", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["StringJoin[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["<>", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["<>", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["^", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Power[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              StyleBox["^(", "MR"],
              StyleBox["e", "TI"],
              StyleBox["^", "MR"],
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox[\(expr\_1\),
                      "TI"], 
                    StyleBox[\(expr\_2\),
                      "TI"]]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Power[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["e",
                      "TI"], 
                    RowBox[{"(", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        StyleBox["e",
                          "TI"]], ")"}]]], "InlineFormula"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  SubsuperscriptBox[
                    StyleBox[\(expr\_1\),
                      "TI"], 
                    StyleBox[\(expr\_2\),
                      "TI"], 
                    StyleBox[\(expr\_3\),
                      "TI"]]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Power[Subscript[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["],", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]^", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]%", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Power[Subscript[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["],", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["vertical arrow and vector operators", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], 
            "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Sqrt]\)], "InlineFormula"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Sqrt[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Sqrt]\)], "InlineFormula"],
              StyleBox["(", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Sqrt]\)], "InlineFormula"],
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["@", "MR"],
              " ",
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Sqrt[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["@(\[Backslash]@", "MR"],
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["@", "MR"],
              " ",
              StyleBox["expr", "TI"],
              " ",
              StyleBox["\[Backslash]%", "MR"],
              " ",
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Power[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["1/", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
              " ",
              StyleBox["(", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubsuperscriptBox["\[Integral]", 
                      StyleBox[\(e\_1\),
                        "TI"], 
                      StyleBox[\(e\_2\),
                        "TI"]], 
                    StyleBox[\(e\_3\),
                      "TI"], 
                    RowBox[{"\[DifferentialD]", 
                      StyleBox[\(e\_4\),
                        "TI"]}]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "4"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
              " ",
              StyleBox["(", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox[
              "other integration operators: see Section\[NonBreakingSpace]", 
                "TI"],
              StyleBox[ButtonBox["A.2.7",
                ButtonData:>{"A.2.7", "7.12"},
                ButtonStyle->"MainBookLink"], "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], 
            "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[PartialD]", 
                      StyleBox[\(expr\_1\),
                        "TI"]], 
                    StyleBox[\(expr\_2\),
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["D[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[PartialD]", 
                      StyleBox["e",
                        "TI"]], 
                    RowBox[{"(", 
                      RowBox[{
                        SubscriptBox["\[PartialD]", 
                          StyleBox["e",
                            "TI"]], 
                        StyleBox["e",
                          "TI"]}], ")"}]}]], "InlineFormula"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Del]\)], "InlineFormula"],
              " ",
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Del[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Del]\)], "InlineFormula"],
              " ",
              StyleBox["(", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Del]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Square]\)], "InlineFormula"],
              " ",
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Square[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Square]\)], "InlineFormula"],
              " ",
              StyleBox["(", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Square]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[SmallCircle]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[SmallCircle]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["SmallCircle[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[SmallCircle]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[SmallCircle]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"}
          },
        ColumnAlignments->{Left, Left, Left, Right}], 
      TraditionalForm]], "PrecedenceTable",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, False, False, True, False, True, False, False, True, True, False, 
      False, False, True, False, True, False, False, False, True, False, True,
       True, False, False, False, True, True, False, False, True, False, 
      False, True, False, True, False}},
  CellTags->"SA.2.7"],

Cell["\<\
Operator input forms, in order of decreasing precedence, part two. \
\
\>", "Caption",
  CellTags->"SA.2.7"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["operator form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["full form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["grouping", "SO10"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CircleDot]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CircleDot]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["CircleDot[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CircleDot]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CircleDot]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["**", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["**", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["NonCommutativeMultiply[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " ",
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["**", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["**", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cross]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cross]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Cross[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cross]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cross]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox[".", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox[".", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Dot[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox[".", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox[".", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["-", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Times[-1,", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["+", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["expr", "TI"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[PlusMinus]\)], "InlineFormula"],
              " ",
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["PlusMinus[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[MinusPlus]\)], "InlineFormula"],
              " ",
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["MinusPlus[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["/", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["(", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[")^-1", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["/", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              StyleBox["/", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Divide]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Divide[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Divide]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Divide]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]/", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Divide[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              "\[Backslash]",
              StyleBox["/", "MR"],
              StyleBox["e", "TI"],
              StyleBox[")\[Backslash]/", "MR"],
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Backslash]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Backslash]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Backslash[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Backslash]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Backslash]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Diamond]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Diamond]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Diamond[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Diamond]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Diamond]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Wedge]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Wedge]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Wedge[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Wedge]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Wedge]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Vee]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Vee]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Vee[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Vee]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Vee]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CircleTimes]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CircleTimes]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["CircleTimes[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CircleTimes]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CircleTimes]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CenterDot]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CenterDot]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["CenterDot[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CenterDot]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CenterDot]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Times[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["*", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["*", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Times[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["*", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["*", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Times]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Times]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Times[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Times]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Times]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Star]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Star]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Star[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Star]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Star]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    UnderoverscriptBox["\[Product]", 
                      RowBox[{
                        StyleBox[\(e\_1\),
                          "TI"], "=", 
                        StyleBox[\(e\_2\),
                          "TI"]}], 
                      StyleBox[\(e\_3\),
                        "TI"]], 
                    StyleBox[\(e\_4\),
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Product[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "4"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Product]\)], "InlineFormula"],
              " ",
              StyleBox["(", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Product]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[VerticalTilde]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[VerticalTilde]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["VerticalTilde[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[VerticalTilde]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[VerticalTilde]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Coproduct]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Coproduct]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Coproduct[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Coproduct]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Coproduct]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cap]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cap]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Cap[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cap]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cap]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cup]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cup]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Cup[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cup]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cup]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["CirclePlus[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CircleMinus]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["CircleMinus[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CircleMinus]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CircleMinus]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"}
          },
        ColumnAlignments->{Left, Left, Left, Right}], 
      TraditionalForm]], "PrecedenceTable",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, True, True, True, True, False, False, False, True, False, False, 
      True, True, True, True, True, True, True, False, False, True, True, 
      True, True, True, False, True, False}},
  CellTags->"SA.2.7"],

Cell["\<\
Operator input forms, in order of decreasing precedence, part \
three. \
\>", "Caption",
  CellTags->"SA.2.7"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["operator form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["full form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["grouping", "SO10"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    UnderoverscriptBox["\[Sum]", 
                      RowBox[{
                        StyleBox[\(e\_1\),
                          "TI"], "=", 
                        StyleBox[\(e\_2\),
                          "TI"]}], 
                      StyleBox[\(e\_3\),
                        "TI"]], 
                    StyleBox[\(e\_4\),
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Sum[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "4"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Sum]\)], "InlineFormula"],
              " ",
              StyleBox["(", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Sum]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["+", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["+", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Plus[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["-", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["(-1", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["-", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              StyleBox["-", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[PlusMinus]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["PlusMinus[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[PlusMinus]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[PlusMinus]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[MinusPlus]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["MinusPlus[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[MinusPlus]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[MinusPlus]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Intersection]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Intersection[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Intersection]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Intersection]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["other intersection operators", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], 
            "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Union]\)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Union[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Union]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Union]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["other union operators", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], 
            "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["==", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Equal[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Equal] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Equal[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Equal] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Equal] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LongEqual] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Equal[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LongEqual] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LongEqual] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["!=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Unequal[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["!=", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["!=", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotEqual] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Unequal[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotEqual] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotEqual] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["other equality and similarity operators", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], 
            "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox[">", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Greater[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox[">", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox[">", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox[">=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["GreaterEqual[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox[">=", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox[">=", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[GreaterEqual] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["GreaterEqual[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[GreaterEqual] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[GreaterEqual] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[GreaterSlantEqual] \)], 
                "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["GreaterEqual[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[GreaterSlantEqual] \)], 
                "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[GreaterSlantEqual] \)], 
                "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["<", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Less[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["<", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["<", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["<=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["LessEqual[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["<=", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["<=", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LessEqual] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["LessEqual[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LessEqual] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LessEqual] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LessSlantEqual] \)], "InlineFormula"],
              
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["LessEqual[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LessSlantEqual] \)], "InlineFormula"],
              
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LessSlantEqual] \)], "InlineFormula"],
              
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["other ordering operators", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], 
            "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[VerticalBar] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["VerticalBar[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[VerticalBar] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[VerticalBar] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotVerticalBar] \)], "InlineFormula"],
              
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["NotVerticalBar[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotVerticalBar] \)], "InlineFormula"],
              
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotVerticalBar] \)], "InlineFormula"],
              
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[DoubleVerticalBar] \)], 
                "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["DoubleVerticalBar[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[DoubleVerticalBar] \)], 
                "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[DoubleVerticalBar] \)], 
                "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotDoubleVerticalBar] \)], 
                "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["NotDoubleVerticalBar[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotDoubleVerticalBar] \)], 
                "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotDoubleVerticalBar] \)], 
                "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              StyleBox["horizontal arrow and vector operators", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], 
            "\[Null]"},
          {Cell[TextData[{
              StyleBox["diagonal arrow operators", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], 
            "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["===", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["SameQ[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["===", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["===", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["=!=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["UnsameQ[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["=!=", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["=!=", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]}
          },
        ColumnAlignments->{Left, Left, Left, Right}], 
      TraditionalForm]], "PrecedenceTable",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, True, False, False, False, True, False, True, False, True, False, 
      False, False, False, False, False, False, False, False, False, False, 
      False, False, False, False, False, False, False, False, False, True, 
      False}},
  CellTags->"SA.2.7"],

Cell["\<\
Operator input forms, in order of decreasing precedence, part four. \
\
\>", "Caption",
  CellTags->"SA.2.7"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["operator form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["full form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["grouping", "SO10"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Element] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Element[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Element] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Element] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotElement] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["NotElement[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotElement] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotElement] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Subset] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Subset[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Subset] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Subset] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Superset] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Superset[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Superset] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Superset] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              StyleBox["other set relation operators", "TI"],
              " "
            }]], Cell["\[SpanFromLeft]"], Cell["\[SpanFromLeft] "], 
            "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[ForAll]", 
                      SubscriptBox[
                        StyleBox["expr",
                          "TI"], "1"]], 
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["ForAll[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[ForAll]", 
                      StyleBox["e",
                        "TI"]], 
                    RowBox[{"(", 
                      RowBox[{
                        SubscriptBox["\[ForAll]", 
                          StyleBox["e",
                            "TI"]], 
                        StyleBox["e",
                          "TI"]}], ")"}]}]], "InlineFormula"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[Exists]", 
                      SubscriptBox[
                        StyleBox["expr",
                          "TI"], "1"]], 
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Exists[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[Exists]", 
                      StyleBox["e",
                        "TI"]], 
                    RowBox[{"(", 
                      RowBox[{
                        SubscriptBox["\[Exists]", 
                          StyleBox["e",
                            "TI"]], 
                        StyleBox["e",
                          "TI"]}], ")"}]}]], "InlineFormula"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[NotExists]", 
                      SubscriptBox[
                        StyleBox["expr",
                          "TI"], "1"]], 
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["NotExists[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[NotExists]", 
                      StyleBox["e",
                        "TI"]], 
                    RowBox[{"(", 
                      RowBox[{
                        SubscriptBox["\[NotExists]", 
                          StyleBox["e",
                            "TI"]], 
                        StyleBox["e",
                          "TI"]}], ")"}]}]], "InlineFormula"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              StyleBox["!", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Not[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["!(!", "MR"],
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Not] \)], "InlineFormula"],
              " ",
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Not[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Not] \)], "InlineFormula"],
              " ",
              StyleBox["(", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Not] \)], "InlineFormula"],
              " ",
              StyleBox["e)", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["&&", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["&&", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["And[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["&&", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["&&", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[And] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[And] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["And[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[And] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[And] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Nand] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Nand] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Nand[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Nand] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Nand] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Xor] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Xor] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Xor[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Xor] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Xor] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["||", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["||", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Or[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["||", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["||", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Or] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Or] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Or[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Or] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Or] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Nor] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Nor] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Nor[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Nor] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Nor] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Implies] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Implies[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\` \[Implies] \)], "InlineFormula"],
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\` \[Implies] \)], "InlineFormula"],
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[RoundImplies] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Implies[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\` \[RoundImplies] \)], "InlineFormula"],
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\` \[RoundImplies] \)], "InlineFormula"],
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[RightTee] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["RightTee[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[RightTee] \)], "InlineFormula"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[RightTee] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[DoubleRightTee] \)], "InlineFormula"],
              
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["DoubleRightTee[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[DoubleRightTee] \)], "InlineFormula"],
              
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[DoubleRightTee] \)], "InlineFormula"],
              
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LeftTee] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["LeftTee[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LeftTee] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LeftTee] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[DoubleLeftTee] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["DoubleLeftTee[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[DoubleLeftTee] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[DoubleLeftTee] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[SuchThat] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["SuchThat[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[SuchThat] \)], "InlineFormula"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[SuchThat] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              StyleBox["..", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Repeated[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              StyleBox["...", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["RepeatedNull[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["|", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Alternatives[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["|", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["|", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["symb", "TI"],
              StyleBox[":", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Pattern[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["patt", "TI"],
              StyleBox[":", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Optional[", "MR"],
              StyleBox["patt", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]}
          },
        ColumnAlignments->{Left, Left, Left, Right}], 
      TraditionalForm]], "PrecedenceTable",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, False, False, False, False, True, False, False, True, False, True, 
      False, False, True, True, False, False, True, False, True, False, False,
       False, True, True, False, True, True, False}},
  CellTags->"SA.2.7"],

Cell["\<\
Operator input forms, in order of decreasing precedence, part five. \
\
\>", "Caption",
  CellTags->"SA.2.7"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["operator form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["full form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["grouping", "SO10"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["~~", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["~~", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["StringExpression[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["~~", "MR"],
              " ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["~~", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Condition[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              StyleBox["/;", "MR"],
              StyleBox["e", "TI"],
              StyleBox[")/;", "MR"],
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Rule[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Rule[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox[":>", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["RuleDelayed[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox[":>", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox[":>", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[RuleDelayed] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["RuleDelayed[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[RuleDelayed] \)], "InlineFormula"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[RuleDelayed] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["ReplaceAll[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["//.", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["ReplaceRepeated[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["//.", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              StyleBox["//.", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["+=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["AddTo[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["+=", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["+=", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["-=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["SubtractFrom[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["-=", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["-=", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["*=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["TimesBy[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["*=", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["*=", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["/=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["DivideBy[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["/=", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["/=", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["&", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Function[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Colon] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Colon[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Colon] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Colon] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["//", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["//", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              StyleBox["//", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[VerticalSeparator] \)], 
                "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["VerticalSeparator[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[VerticalSeparator] \)], 
                "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[VerticalSeparator] \)], 
                "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Therefore] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Therefore[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Therefore] \)], "InlineFormula"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Therefore] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Because] \)], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Because[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Because] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Because] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Set[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["SetDelayed[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["^=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["UpSet[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["^=", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["^=", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["^:=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["UpSetDelayed[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["^:=", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["^:=", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["symb", "TI"],
              StyleBox["/:", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["TagSet[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["symb", "TI"],
              StyleBox["/:", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["TagSetDelayed[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["=.", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Unset[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["symb", "TI"],
              StyleBox["/:", "MR"],
              " ",
              StyleBox["expr", "TI"],
              " ",
              StyleBox["=.", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["TagUnset[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox[">>", "MR"],
              " ",
              StyleBox["filename", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Put[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["filename", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox[">>>", "MR"],
              " ",
              StyleBox["filename", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["PutAppend[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["filename", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[";", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[";", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["CompoundExpression[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[";", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[";", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["CompoundExpression[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Null]", "MR"],
              " "
            }]], Cell[""], Cell["\[LeftTriangle]"]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]`", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["FormBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["\[Backslash]`", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["\[Backslash]`", "MR"],
              " ",
              StyleBox["e", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["\[LeftTriangle]"]}
          },
        ColumnAlignments->{Left, Left, Left, Right}], 
      TraditionalForm]], "PrecedenceTable",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, True, True, False, False, False, True, False, True, False, False, 
      False, True, True, True, True, True, False, True, False, False, False, 
      False, False, False, False, True, False, True, False, True}},
  CellTags->"SA.2.7"],

Cell["\<\
Operator input forms, in order of decreasing precedence, part six. \
\
\>", "Caption",
  CellTags->"SA.2.7"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["special input form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["full form", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["#", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Slot[1]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["#", "MR"],
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Slot[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["##", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["SlotSequence[1]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["##", "MR"],
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["SlotSequence[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["%", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Out[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["%%", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Out[-2]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["%%", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["%", "MR"],
              " (",
              StyleBox["n", "TI"],
              " times) "
            }]], Cell[TextData[{
              StyleBox["Out[-", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["%", "MR"],
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Out[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["_", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Blank[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["_", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Blank[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["__", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["BlankSequence[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["__", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["BlankSequence[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["___", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["BlankNullSequence[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["___", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["BlankNullSequence[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["_.", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Optional[Blank[", "MR"],
              " ",
              StyleBox["]]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["symb", "TI"],
              StyleBox["_", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Pattern[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Blank[", "MR"],
              " ",
              StyleBox["]]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["symb", "TI"],
              StyleBox["_", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Pattern[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Blank[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["symb", "TI"],
              StyleBox["__", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Pattern[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["BlankSequence[", "MR"],
              " ",
              StyleBox["]]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["symb", "TI"],
              StyleBox["__", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Pattern[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["BlankSequence[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["symb", "TI"],
              StyleBox["___", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Pattern[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["BlankNullSequence[", "MR"],
              " ",
              StyleBox["]]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["symb", "TI"],
              StyleBox["___", "MR"],
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Pattern[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["BlankNullSequence[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["symb", "TI"],
              StyleBox["_.", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Optional[Pattern[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Blank[", "MR"],
              " ",
              StyleBox["]]]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, False, False, False, True, False, False, False, True, False}},
  CellTags->"SA.2.7"],

Cell["Additional input forms, in order of decreasing precedence. ", "Caption",
  CellTags->"SA.2.7"],

Cell[CellGroupData[{

Cell["Special Characters", "Subsubsection",
  CellTags->{"SA.2.7", "7.4"}],

Cell[TextData[{
  "Special characters that appear in operators usually have names that \
correspond to the names of the functions they represent. Thus the character \
",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " has name \[Backslash]",
  StyleBox["[CirclePlus]", "MR"],
  " and yields the function ",
  StyleBox["CirclePlus", "MR"],
  ". Exceptions are \[Backslash]",
  StyleBox["[GreaterSlantEqual]", "MR"],
  ", \[Backslash]",
  StyleBox["[LessSlantEqual]", "MR"],
  " and \[Backslash]",
  StyleBox["[RoundImplies]", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.7", "7.5"}],

Cell[TextData[{
  "The delimiters in matchfix operators have names \[Backslash]",
  StyleBox["[Left", "MR"],
  StyleBox["Name", "TI"],
  StyleBox["]", "MR"],
  " and \[Backslash]",
  StyleBox["[Right", "MR"],
  StyleBox["Name", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.7", "7.6"}],

Cell[TextData[{
  "Section\[NonBreakingSpace]",
  ButtonBox["A.12.1",
    ButtonData:>{"A.12.1", "1.1000"},
    ButtonStyle->"MainBookLink"],
  " gives a complete listing of special characters that appear in operators. \
"
}], "Text",
  CellTags->{"SA.2.7", "7.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["keyboard characters", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["special character", "SO10"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["->", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Rule]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[Rule] \)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox[":>", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RuleDelayed]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[RuleDelayed] \)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["==", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Equal]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[Equal] \)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["!=", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotEqual]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[NotEqual] \)], 
                            "InlineFormula"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]], 
            Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["keyboard characters", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["special character", "SO10"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox[">=", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GreaterEqual]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[GreaterEqual] \)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox[">=", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GreaterSlantEqual]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[GreaterSlantEqual] \)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["<=", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LessEqual]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[LessEqual] \)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["<=", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LessSlantEqual]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[LessSlantEqual] \)], 
                            "InlineFormula"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"SA.2.7"],

Cell["\<\
Keyboard and special characters with the same interpretations. \
\
\>", "Caption",
  CellTags->"SA.2.7"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["keyboard character", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["special character", "SO10"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawColon]", "MR"],
                          " ",
                          StyleBox[":", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Colon]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[Colon] \)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawTilde]", "MR"],
                          " ",
                          StyleBox["~", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Tilde]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[Tilde] \)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawWedge]", "MR"],
                          " ",
                          StyleBox["^", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Wedge]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[Wedge]\)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawWedge]", "MR"],
                          " ",
                          StyleBox["^", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[And]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[And] \)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawStar]", "MR"],
                          " ",
                          StyleBox["*", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Star]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[Star]\)], "InlineFormula"],
                          
                          " "
                        }]]},
                      {Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawBackslash]", "MR"],
                          " \[Backslash] "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Backslash]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[Backslash]\)], 
                            "InlineFormula"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]], 
            Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          StyleBox["keyboard character", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["special character", "SO10"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawDot]", "MR"],
                          " ",
                          StyleBox[".", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CenterDot]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[CenterDot]\)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawVerticalBar]", "MR"],
                          " ",
                          StyleBox["|", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[VerticalBar]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[VerticalBar] \)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawVerticalBar]", "MR"],
                          " ",
                          StyleBox["|", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[VerticalSeparator]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\` \[VerticalSeparator] \)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawVerticalBar]", "MR"],
                          " ",
                          StyleBox["|", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftBracketingBar]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[LeftBracketingBar]\)], 
                            "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RawDash]", "MR"],
                          " ",
                          StyleBox["-", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Dash]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[Dash]\)], "InlineFormula"],
                          
                          " "
                        }]]},
                      {Cell[TextData[{
                          StyleBox["...", "MR"],
                          " "
                        }]], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Ellipsis]", "MR"],
                          " ",
                          Cell[BoxData[
                              \(TraditionalForm\`\[Ellipsis]\)], 
                            "InlineFormula"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"SA.2.7"],

Cell["\<\
Some keyboard and special characters with different \
interpretations.  \
\>", "Caption",
  CellTags->"SA.2.7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Precedence and the Ordering of Input Forms", "Subsubsection",
  CellTags->{"SA.2.7", "7.8"}],

Cell[TextData[{
  "The tables of input forms are arranged in decreasing order of precedence. \
Input forms in the same box have the same precedence. Each page in the table \
begins a new box. As discussed in Section ",
  ButtonBox["2.1.3",
    ButtonData:>{"2.1.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  ", precedence determines how ",
  StyleBox["Mathematica", "TI"],
  " groups terms in input expressions. The general rule is that if ",
  Cell[BoxData[
      \(TraditionalForm\`\[CircleTimes]\)], "InlineFormula"],
  " has higher precedence than ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  ", then ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["a",
            "TI"], "\[CirclePlus]", 
          StyleBox["b",
            "TI"], "\[CircleTimes]", 
          StyleBox["c",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " is interpreted as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["a",
            "TI"], "\[CirclePlus]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["b",
                "TI"], "\[CircleTimes]", 
              StyleBox["c",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["a",
            "TI"], "\[CircleTimes]", 
          StyleBox["b",
            "TI"], "\[CirclePlus]", 
          StyleBox["c",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " is interpreted as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], "\[CircleTimes]", 
              StyleBox["b",
                "TI"]}], ")"}], "\[CirclePlus]", 
          StyleBox["c",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"SA.2.7", "7.9"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Grouping of Input Forms", "Subsubsection",
  CellTags->{"SA.2.7", "7.10"}],

Cell[TextData[{
  "The third columns in the tables show how multiple occurrences of a single \
input form, or of several input forms with the same precedence, are grouped. \
For example, ",
  StyleBox["a/b/c", "MR"],
  " is grouped as ",
  StyleBox["(a/b)/c", "MR"],
  " (\[OpenCurlyDoubleQuote]left associative\[CloseCurlyDoubleQuote]), while \
",
  StyleBox["a^b^c", "MR"],
  " is grouped as ",
  StyleBox["a^(b^c)", "MR"],
  " (\[OpenCurlyDoubleQuote]right associative\[CloseCurlyDoubleQuote]). No \
grouping is needed in an expression like ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["c", "MR"],
  ", since ",
  StyleBox["Plus", "MR"],
  " is fully associative, as represented by the attribute ",
  StyleBox["Flat", "MR"],
  ".  "
}], "Text",
  CellTags->{"SA.2.7", "7.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Precedence of Integration Operators", "Subsubsection",
  CellTags->{"SA.2.7", "7.12"}],

Cell[TextData[{
  "Forms such as ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " have an \[OpenCurlyDoubleQuote]outer\[CloseCurlyDoubleQuote] precedence \
just below ",
  StyleBox["Power", "MR"],
  ", as indicated in the table above, but an \[OpenCurlyDoubleQuote]inner\
\[CloseCurlyDoubleQuote] precedence just above ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\)], "InlineFormula"],
  ". The outer precedence determines when ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " needs to be parenthesized; the inner precedence determines when ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " needs to be parenthesized. "
}], "Text",
  CellTags->{"SA.2.7", "7.13"}],

Cell[TextData[{
  "\[Backslash]",
  StyleBox["[ContourIntegral]", "MR"],
  ", \[Backslash]",
  StyleBox["[ClockwiseContourIntegral]", "MR"],
  " and \[Backslash]",
  StyleBox["[DoubleContourIntegral]", "MR"],
  " work the same as \[Backslash]",
  StyleBox["[Integral]", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.7", "7.14"}],

Cell[TextData[{
  "See Section\[NonBreakingSpace]",
  ButtonBox["A.2.8",
    ButtonData:>{"A.2.8", "8.3"},
    ButtonStyle->"MainBookLink"],
  " for two\[Hyphen]dimensional input forms associated with integration \
operators. "
}], "Text",
  CellTags->{"SA.2.7", "7.15"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spaces and Multiplication", "Subsubsection",
  CellTags->{"SA.2.7", "7.16"}],

Cell[TextData[{
  "Spaces in ",
  StyleBox["Mathematica", "TI"],
  " denote multiplication, just as they do in standard mathematical notation. \
In addition, ",
  StyleBox["Mathematica", "TI"],
  " takes complete expressions that are adjacent, not necessarily separated \
by spaces, to be multiplied together.  "
}], "Text",
  CellTags->{"SA.2.7", "7.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["x", "MR"],
              " ",
              StyleBox["y", "MR"],
              " ",
              StyleBox["z", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
              " ",
              StyleBox["x*y*z", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["2x", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
              " ",
              StyleBox["2*x", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["2(x+1)", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
              " ",
              StyleBox["2*(x+1)", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["c(x+1)", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
              " ",
              StyleBox["c*(x+1)", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["(x+1)(y+2)", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
              " ",
              StyleBox["(x+1)*(y+2)", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["x!", "MR"],
              " ",
              StyleBox["y", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
              " ",
              StyleBox["x!*y", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["x!y", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
              " ",
              StyleBox["x!*y", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.7"],

Cell["Alternative forms for multiplication. ", "Caption",
  CellTags->"SA.2.7"],

Cell[TextData[{
  "An expression like ",
  StyleBox["x!y", "MR"],
  " could potentially mean either ",
  StyleBox["(x!)*y", "MR"],
  " or ",
  StyleBox["x*(!y)", "MR"],
  ". The first interpretation is chosen because ",
  StyleBox["Factorial", "MR"],
  " has higher precedence than ",
  StyleBox["Not", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.7", "7.18"}],

Cell[TextData[{
  "Spaces within single input forms are ignored. Thus, for example, ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  " is equivalent to ",
  StyleBox["a+b", "MR"],
  ". You will often want to insert spaces around lower precedence operators \
to improve readability. "
}], "Text",
  CellTags->{"SA.2.7", "7.19"}],

Cell["\<\
You can give a \[OpenCurlyDoubleQuote]coefficient\
\[CloseCurlyDoubleQuote] for a symbol by preceding it with any sequence of \
digits. When you use numbers in bases larger than 10, the digits can include \
letters. (In bases other than 10, there must be a space between the end of \
the coefficient, and the beginning of the symbol name.)  \
\>", "Text",
  CellTags->{"SA.2.7", "7.20"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["x^2y", "MR"],
              ", like ",
              StyleBox["x^2", "MR"],
              " ",
              StyleBox["y", "MR"],
              ", means ",
              StyleBox["(x^2)", "MR"],
              " ",
              StyleBox["y", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["x/2y", "MR"],
              ", like ",
              StyleBox["x/2", "MR"],
              " ",
              StyleBox["y", "MR"],
              ", means ",
              StyleBox["(x/2)", "MR"],
              " ",
              StyleBox["y", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["xy", "MR"],
              " is a single symbol, not ",
              StyleBox["x*y", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.7"],

Cell["Some cases to be careful about. ", "Caption",
  CellTags->"SA.2.7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spaces to Avoid", "Subsubsection",
  CellTags->{"SA.2.7", "7.21"}],

Cell[TextData[{
  "You should avoid inserting any spaces between the different characters in \
composite operators such as ",
  StyleBox["/.", "MR"],
  ", ",
  StyleBox["=.", "MR"],
  " and ",
  StyleBox[">=", "MR"],
  ". Although in some cases such spaces are allowed, they are liable to lead \
to confusion. "
}], "Text",
  CellTags->{"SA.2.7", "7.22"}],

Cell[TextData[{
  "Another case where spaces must be avoided is between the characters of the \
pattern object ",
  StyleBox["x_", "MR"],
  ". If you type ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["_", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will interpret this as ",
  StyleBox["x*_", "MR"],
  ", rather than the single named pattern object ",
  StyleBox["x_", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.7", "7.23"}],

Cell[TextData[{
  "Similarly, you should not insert any spaces inside pattern objects like ",
  StyleBox["x", "TI"],
  StyleBox["_:", "MR"],
  StyleBox["value", "TI"],
  ". "
}], "Text",
  CellTags->{"SA.2.7", "7.24"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spacing Characters", "Subsubsection",
  CellTags->{"SA.2.7", "7.25"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] Ordinary keyboard space (\[Backslash]",
              StyleBox["[RawSpace]", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] \[Backslash]",
              StyleBox["[VeryThinSpace]", "MR"],
              ", \[Backslash]",
              StyleBox["[ThinSpace]", "MR"],
              ", ..., \[Backslash]",
              StyleBox["[ThickSpace]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] \[Backslash]",
              StyleBox["[NegativeVeryThinSpace]", "MR"],
              ", \[Backslash]",
              StyleBox["[NegativeThinSpace]", "MR"],
              ", ..., \[Backslash]",
              StyleBox["[NegativeThickSpace]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              " (\[Backslash]",
              StyleBox["[SpaceIndicator]", "MR"],
              ") "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.7"],

Cell["\<\
Spacing characters equivalent to an ordinary keyboard space. \
\>", \
"Caption",
  CellTags->"SA.2.7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Relational Operators", "Subsubsection",
  CellTags->{"SA.2.7", "7.26"}],

Cell[TextData[{
  "Relational operators can be mixed. An expression like ",
  StyleBox["a", "MR"],
  " ",
  StyleBox[">", "MR"],
  " ",
  StyleBox["b", "MR"],
  " ",
  StyleBox[">=", "MR"],
  " ",
  StyleBox["c", "MR"],
  " is converted to ",
  StyleBox["Inequality[a,", "MR"],
  " ",
  StyleBox["Greater,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["GreaterEqual,", "MR"],
  " ",
  StyleBox["c]", "MR"],
  ", which effectively evaluates as ",
  StyleBox["(a", "MR"],
  " ",
  StyleBox[">", "MR"],
  " ",
  StyleBox["b)", "MR"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  StyleBox["(b", "MR"],
  " ",
  StyleBox[">=", "MR"],
  " ",
  StyleBox["c)", "MR"],
  ". (The reason for the intermediate ",
  StyleBox["Inequality", "MR"],
  " form is that it prevents objects from being evaluated twice when input \
like ",
  StyleBox["a", "MR"],
  " ",
  StyleBox[">", "MR"],
  " ",
  StyleBox["b", "MR"],
  " ",
  StyleBox[">=", "MR"],
  " ",
  StyleBox["c", "MR"],
  " is processed.)   "
}], "Text",
  CellTags->{"SA.2.7", "7.27"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["File Names", "Subsubsection",
  CellTags->{"SA.2.7", "7.28"}],

Cell[TextData[{
  "Any file name can be given in quotes after ",
  StyleBox["<<", "MR"],
  ", ",
  StyleBox[">>", "MR"],
  " and ",
  StyleBox[">>>", "MR"],
  ". File names can also be given without quotes if they contain only \
alphanumeric characters, special characters and the characters ",
  StyleBox["`", "MR"],
  ", ",
  StyleBox["/", "MR"],
  ", ",
  StyleBox[".", "MR"],
  ", \[Backslash], ",
  StyleBox["!", "MR"],
  ", ",
  StyleBox["-", "MR"],
  ", ",
  StyleBox["_", "MR"],
  ", ",
  StyleBox[":", "MR"],
  ", ",
  StyleBox["$", "MR"],
  ", ",
  StyleBox["*", "MR"],
  ", ",
  StyleBox["~", "MR"],
  " and ",
  StyleBox["?", "MR"],
  ", together with matched pairs of square brackets enclosing any characters \
other than spaces, tabs and newlines. Note that file names given without \
quotes can be followed only by spaces, tabs or newlines, or by the characters \
",
  StyleBox[")", "MR"],
  ", ",
  StyleBox["]", "MR"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  " as well as semicolon and comma. "
}], "Text",
  CellTags->{"SA.2.7", "7.29"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
A.2.8 Two\[Hyphen]Dimensional Input Forms\
\>", "Subsection",
  CellTags->{"SA.2.8", "8.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          Cell[BoxData[
                              SuperscriptBox[
                                StyleBox["x",
                                  "TI"], 
                                StyleBox["y",
                                  "TI"]]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Power[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["y", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              FractionBox[
                                StyleBox["x",
                                  "TI"], 
                                StyleBox["y",
                                  "TI"]]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Divide[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["y", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SqrtBox[
                                StyleBox["x",
                                  "TI"]]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Sqrt[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              RadicalBox[
                                StyleBox["x",
                                  "TI"], 
                                StyleBox["n",
                                  "TI"]]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Power[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["1/", "MR"],
                          StyleBox["n", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[GridBox[{
                                  {
                                    StyleBox[\(a\_11\),
                                      "TI"], 
                                    StyleBox[\(a\_12\),
                                      "TI"], "\[Ellipsis]"},
                                  {
                                    StyleBox[\(a\_21\),
                                      "TI"], 
                                    StyleBox[\(a\_22\),
                                      "TI"], "\[Ellipsis]"}
                                  }]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          Cell[BoxData[
                              RowBox[{"{", 
                                RowBox[{
                                  RowBox[{"{", 
                                    RowBox[{
                                      StyleBox[\(a\_11\),
                                        "TI"], ",", 
                                      StyleBox[\(a\_12\),
                                        "TI"], ",", "\[Ellipsis]"}], "}"}], 
                                  ",", 
                                  RowBox[{"{", 
                                    RowBox[{
                                      StyleBox[\(a\_21\),
                                        "TI"], ",", 
                                      StyleBox[\(a\_22\),
                                        "TI"], ",", "\[Ellipsis]"}], "}"}]}], 
                                "}"}]], "InlineFormula"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              RowBox[{
                                SubscriptBox["\[PartialD]", 
                                  StyleBox["x",
                                    "TI"]], 
                                StyleBox["y",
                                  "TI"]}]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["D[", "MR"],
                          StyleBox["y", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              RowBox[{
                                SubscriptBox["\[PartialD]", 
                                  RowBox[{
                                    StyleBox["x",
                                      "TI"], ",", "\[Ellipsis]"}]], 
                                StyleBox["y",
                                  "TI"]}]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["D[", "MR"],
                          StyleBox["y", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          "\[Ellipsis]",
                          " ",
                          StyleBox["]", "MR"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]], 
            Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          Cell[BoxData[
                              FormBox[
                                RowBox[{
                                  SubsuperscriptBox["\[Integral]", 
                                    SubscriptBox[
                                      StyleBox["x",
                                        "TI"], 
                                      StyleBox["min",
                                        "TI"]], 
                                    SubscriptBox[
                                      StyleBox["x",
                                        "TI"], 
                                      StyleBox["max",
                                        "TI"]]], 
                                  StyleBox["y",
                                    "TI"]}], TraditionalForm]], 
                            "InlineFormula"],
                          Cell[BoxData[
                              RowBox[{"\[MediumSpace]", "\[DifferentialD]", 
                                StyleBox["x",
                                  "TI"]}]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Integrate[", "MR"],
                          StyleBox["y", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["{", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          Cell[BoxData[
                              FormBox[
                                SubscriptBox[
                                  StyleBox["x",
                                    "TI"], 
                                  StyleBox["min",
                                    "TI"]], TraditionalForm]], 
                            "InlineFormula"],
                          StyleBox[",", "MR"],
                          " ",
                          Cell[BoxData[
                              FormBox[
                                SubscriptBox[
                                  StyleBox["x",
                                    "TI"], 
                                  StyleBox["max",
                                    "TI"]], TraditionalForm]], 
                            "InlineFormula"],
                          StyleBox["}]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              FormBox[
                                SubsuperscriptBox["\[Integral]", 
                                  SubscriptBox[
                                    StyleBox["x",
                                      "TI"], 
                                    StyleBox["min",
                                      "TI"]], 
                                  SubscriptBox[
                                    StyleBox["x",
                                      "TI"], 
                                    StyleBox["max",
                                      "TI"]]], TraditionalForm]], 
                            "InlineFormula"],
                          Cell[BoxData[
                              RowBox[{
                                StyleBox["y",
                                  "TI"], "\[MediumSpace]", 
                                StyleBox["w",
                                  "TI"], 
                                FractionBox[
                                  RowBox[{"\[DifferentialD]", 
                                    StyleBox["x",
                                      "TI"]}], 
                                  StyleBox["z",
                                    "TI"]]}]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Integrate[", "MR"],
                          StyleBox["y", "TI"],
                          " ",
                          StyleBox["w", "TI"],
                          StyleBox["/", "MR"],
                          StyleBox["z", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["{", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          Cell[BoxData[
                              FormBox[
                                SubscriptBox[
                                  StyleBox["x",
                                    "TI"], 
                                  StyleBox["min",
                                    "TI"]], TraditionalForm]], 
                            "InlineFormula"],
                          StyleBox[",", "MR"],
                          " ",
                          Cell[BoxData[
                              FormBox[
                                SubscriptBox[
                                  StyleBox["x",
                                    "TI"], 
                                  StyleBox["max",
                                    "TI"]], TraditionalForm]], 
                            "InlineFormula"],
                          StyleBox["}]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              FormBox[
                                RowBox[{
                                  UnderoverscriptBox["\[Sum]", 
                                    RowBox[{
                                      StyleBox["x",
                                        "TI"], "=", 
                                      SubscriptBox[
                                        StyleBox["x",
                                        "TI"], 
                                        StyleBox["min",
                                        "TI"]]}], 
                                    SubscriptBox[
                                      StyleBox["x",
                                        "TI"], 
                                      StyleBox["max",
                                        "TI"]],
                                    LimitsPositioning->False], 
                                  StyleBox["y",
                                    "TI"]}], TraditionalForm]], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Sum[", "MR"],
                          StyleBox["y", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["{", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          Cell[BoxData[
                              FormBox[
                                SubscriptBox[
                                  StyleBox["x",
                                    "TI"], 
                                  StyleBox["min",
                                    "TI"]], TraditionalForm]], 
                            "InlineFormula"],
                          StyleBox[",", "MR"],
                          " ",
                          Cell[BoxData[
                              FormBox[
                                SubscriptBox[
                                  StyleBox["x",
                                    "TI"], 
                                  StyleBox["max",
                                    "TI"]], TraditionalForm]], 
                            "InlineFormula"],
                          StyleBox["}]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              FormBox[
                                RowBox[{
                                  UnderoverscriptBox["\[Product]", 
                                    RowBox[{
                                      StyleBox["x",
                                        "TI"], "=", 
                                      SubscriptBox[
                                        StyleBox["x",
                                        "TI"], 
                                        StyleBox["min",
                                        "TI"]]}], 
                                    SubscriptBox[
                                      StyleBox["x",
                                        "TI"], 
                                      StyleBox["max",
                                        "TI"]],
                                    LimitsPositioning->False], 
                                  StyleBox["y",
                                    "TI"]}], TraditionalForm]], 
                            "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Product[", "MR"],
                          StyleBox["y", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["{", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          Cell[BoxData[
                              FormBox[
                                SubscriptBox[
                                  StyleBox["x",
                                    "TI"], 
                                  StyleBox["min",
                                    "TI"]], TraditionalForm]], 
                            "InlineFormula"],
                          StyleBox[",", "MR"],
                          " ",
                          Cell[BoxData[
                              FormBox[
                                SubscriptBox[
                                  StyleBox["x",
                                    "TI"], 
                                  StyleBox["max",
                                    "TI"]], TraditionalForm]], 
                            "InlineFormula"],
                          StyleBox["}]", "MR"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"SA.2.8"],

Cell["\<\
Two\[Hyphen]dimensional input forms with built\[Hyphen]in \
evaluation rules. \
\>", "Caption",
  CellTags->"SA.2.8"],

Cell[TextData[{
  "Any array of expressions represented by a ",
  StyleBox["GridBox", "MR"],
  " is interpreted as a list of lists. Even if the ",
  StyleBox["GridBox", "MR"],
  " has only one row, the interpretation is still ",
  StyleBox["{{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}}", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.8", "8.2"}],

Cell[TextData[{
  "In the form ",
  Cell[BoxData[
      RowBox[{
        SubsuperscriptBox["\[Integral]", 
          StyleBox[\(x\_min\),
            "TI"], 
          StyleBox[\(x\_max\),
            "TI"]], 
        RowBox[{
          StyleBox["y",
            "TI"], 
          RowBox[{
            StyleBox["w",
              "TI"], 
            FractionBox[
              RowBox[{"\[DifferentialD]", 
                StyleBox["x",
                  "TI"]}], 
              StyleBox["z",
                "TI"]]}]}]}]], "InlineFormula"],
  " the limits ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " can be omitted, as can ",
  StyleBox["y", "TI"],
  " and ",
  StyleBox["w", "TI"],
  ".  "
}], "Text",
  CellTags->{"SA.2.8", "8.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          Cell[BoxData[
                              SubscriptBox[
                                StyleBox["x",
                                  "TI"], 
                                StyleBox["y",
                                  "TI"]]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Subscript[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["y", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SubscriptBox[
                                StyleBox["x",
                                  "TI"], "+"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SubPlus[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SubscriptBox[
                                StyleBox["x",
                                  "TI"], "-"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SubMinus[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SubscriptBox[
                                StyleBox["x",
                                  "TI"], "*"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SubStar[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SuperscriptBox[
                                StyleBox["x",
                                  "TI"], "+"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SuperPlus[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SuperscriptBox[
                                StyleBox["x",
                                  "TI"], "-"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SuperMinus[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SuperscriptBox[
                                StyleBox["x",
                                  "TI"], "*"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SuperStar[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SuperscriptBox[
                                StyleBox["x",
                                  "TI"], "\[Dagger]"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SuperDagger[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]], 
            Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          Cell[BoxData[
                              OverscriptBox[
                                StyleBox["x",
                                  "TI"], 
                                StyleBox["y",
                                  "TI"]]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Overscript[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["y", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              UnderscriptBox[
                                StyleBox["x",
                                  "TI"], 
                                StyleBox["y",
                                  "TI"]]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Underscript[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["y", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              OverscriptBox[
                                StyleBox["x",
                                  "TI"], "_"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["OverBar[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              OverscriptBox[
                                StyleBox["x",
                                  "TI"], "\[RightVector]"]], "InlineFormula"],
                          
                          " "
                        }]], Cell[TextData[{
                          StyleBox["OverVector[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              OverscriptBox[
                                StyleBox["x",
                                  "TI"], "~"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["OverTilde[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              OverscriptBox[
                                StyleBox["x",
                                  "TI"], "^"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["OverHat[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              OverscriptBox[
                                StyleBox["x",
                                  "TI"], "."]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["OverDot[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              UnderscriptBox[
                                StyleBox["x",
                                  "TI"], "_"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["UnderBar[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"SA.2.8"],

Cell["\<\
Two\[Hyphen]dimensional input forms without built\[Hyphen]in \
evaluation rules. \
\>", "Caption",
  CellTags->"SA.2.8"],

Cell[TextData[{
  "There is no issue of precedence for forms such as ",
  Cell[BoxData[
      SqrtBox[
        StyleBox["x",
          "TI"]]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      OverscriptBox[
        StyleBox["x",
          "TI"], "^"]], "InlineFormula"],
  " in which operands are effectively spanned by the operator. For forms such \
as ",
  Cell[BoxData[
      SubscriptBox[
        StyleBox["x",
          "TI"], 
        StyleBox["y",
          "TI"]]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      SuperscriptBox[
        StyleBox["x",
          "TI"], "\[Dagger]"]], "InlineFormula"],
  " a left precedence does need to be specified, so such forms are included \
in the main table of precedences above. "
}], "Text",
  CellTags->{"SA.2.8", "8.4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.2.9 Input of Boxes", "Subsection",
  CellTags->{"SA.2.9", "9.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["\[FilledSmallSquare] Use a palette "]},
          {Cell["\[FilledSmallSquare] Use control keys "]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Use \[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              StyleBox["input", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              ", together with \[ControlKey]\[LeftModified]",
              StyleBox["!\[RightModified]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Use \[ControlKey]\[LeftModified]",
              StyleBox["*\[RightModified]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.9"],

Cell["Ways to input boxes. ", "Caption",
  CellTags->"SA.2.9"],

Cell[CellGroupData[{

Cell["Control Keys", "Subsubsection",
  CellTags->{"SA.2.9", "9.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["1\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["!\[RightModified]", "MR"],
              " "
            }]], Cell[TextData[{
              "activate \[Backslash]",
              StyleBox["!", "MR"],
              " form "
            }]]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["2\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["@\[RightModified]", "MR"],
              " "
            }]], Cell["square root "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["5\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["%\[RightModified]", "MR"],
              " "
            }]], 
            Cell["\<\
switch to alternate position (e.g. subscript to \
superscript) \
\>"]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["6\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["^\[RightModified]", "MR"],
              " "
            }]], Cell["superscript "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["7\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["&\[RightModified]", "MR"],
              " "
            }]], Cell["overscript "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["8\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["*\[RightModified]", "MR"],
              " "
            }]], Cell["enter raw boxes "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["9\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["(\[RightModified]", "MR"],
              " "
            }]], Cell["begin a new cell within an existing cell "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["0\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox[")\[RightModified]", "MR"],
              " "
            }]], Cell["end a new cell within an existing cell "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["-\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["_\[RightModified]", "MR"],
              " "
            }]], Cell["subscript "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["=\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["+\[RightModified]", "MR"],
              " "
            }]], Cell["underscript "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\`\[ReturnIndicator]\)], "InlineFormula"],
              "\[RightModified] (Control\[Hyphen]Return) "
            }]], Cell[TextData[{
              "create a new row in a ",
              StyleBox["GridBox", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox[",\[RightModified]", "MR"],
              " "
            }]], Cell[TextData[{
              "create a new column in a ",
              StyleBox["GridBox", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox[".\[RightModified]", "MR"],
              " "
            }]], Cell["expand current selection "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["/\[RightModified]", "MR"],
              " "
            }]], Cell["fraction "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] (Control\[Hyphen]Space) "
            }]], Cell["return from current position or state "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
              "\[RightModified], \[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\` \[LeftArrow] \)], "InlineFormula"],
              "\[RightModified], \[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\`\[UpArrow]\)], "InlineFormula"],
              "\[RightModified], \[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\`\[DownArrow]\)], "InlineFormula"],
              "\[RightModified] "
            }]], Cell["move an object by minimal increments on the screen "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.9"],

Cell["Standard control keys. ", "Caption",
  CellTags->"SA.2.9"],

Cell["\<\
On English\[Hyphen]language keyboards both forms will work where \
alternates are given. On other keyboards the first form should work but the \
second may not. \
\>", "Text",
  CellTags->{"SA.2.9", "9.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Boxes Constructed from Text", "Subsubsection",
  CellTags->{"SA.2.9", "9.4"}],

Cell[TextData[{
  "When textual input that you give is used to construct boxes, as in ",
  StyleBox["StandardForm", "MR"],
  " or ",
  StyleBox["TraditionalForm", "MR"],
  " cells in a notebook, the input is handled slightly differently from when \
it is fed directly to the kernel. "
}], "Text",
  CellTags->{"SA.2.9", "9.5"}],

Cell[TextData[{
  "The input is broken into ",
  StyleBox["tokens", "TI"],
  ", and then each token is included in the box structure as a separate \
character string. Thus, for example, ",
  StyleBox["xx+yyy", "MR"],
  " is broken into the tokens ",
  StyleBox["\"xx\"", "MR"],
  ", ",
  StyleBox["\"+\"", "MR"],
  ", ",
  StyleBox["\"yyy\"", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.9", "9.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] symbol name (e.g. ",
              StyleBox["x123", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] number (e.g. ",
              StyleBox["12.345", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] operator (e.g. ",
              StyleBox["+=", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] spacing (e.g. ",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] character string (e.g. ",
              StyleBox["\"text\"", "MR"],
              ") "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.9"],

Cell["Types of tokens in text used to construct boxes. ", "Caption",
  CellTags->"SA.2.9"],

Cell[TextData[{
  "A ",
  StyleBox["RowBox", "MR"],
  " is constructed to hold each operator and its operands. The nesting of ",
  StyleBox["RowBox", "MR"],
  " objects is determined by the precedence of the operators in standard ",
  StyleBox["Mathematica", "TI"],
  " syntax. "
}], "Text",
  CellTags->{"SA.2.9", "9.7"}],

Cell["\<\
Note that spacing characters are not automatically discarded. \
Instead, each sequence of consecutive such characters is made into a separate \
token. \
\>", "Text",
  CellTags->{"SA.2.9", "9.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["String\[Hyphen]Based Input", "Subsubsection",
  CellTags->{"SA.2.9", "9.9"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["(", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["\[Backslash])", "MR"],
              " "
            }]], Cell["input raw boxes "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["\[Backslash])", "MR"],
              " "
            }]], Cell["input and interpret boxes "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.9"],

Cell["Inputting raw and interpreted boxes. ", "Caption",
  CellTags->"SA.2.9"],

Cell[TextData[{
  "Any textual input that you give between \[Backslash]",
  StyleBox["(", "MR"],
  " and \[Backslash]",
  StyleBox[")", "MR"],
  " is taken to specify boxes to construct. The boxes are only interpreted if \
you specify with \[Backslash]",
  StyleBox["!", "MR"],
  " that this should be done. Otherwise ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["\[Backslash]^", "MR"],
  " ",
  StyleBox["y", "TI"],
  " is left for example as ",
  StyleBox["SuperscriptBox[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ", and is not converted to ",
  StyleBox["Power[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.2.9", "9.10"}],

Cell[TextData[{
  "Within the outermost \[Backslash]",
  StyleBox["(", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  ", further \[Backslash]",
  StyleBox["(", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " specify grouping and lead to the insertion of ",
  StyleBox["RowBox", "MR"],
  " objects. "
}], "Text",
  CellTags->{"SA.2.9", "9.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["(", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] \[Backslash])",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              StyleBox["RowBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]^", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["SuperscriptBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]_", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["SubscriptBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]_", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]%", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["SubsuperscriptBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]&", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverscriptBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]+", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["UnderscriptBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]+", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]%", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["UnderoverscriptBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]/", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["FractionBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["@", "MR"],
              " ",
              StyleBox["box", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["SqrtBox[", "MR"],
              StyleBox["box", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["form", "TI"],
              " ",
              StyleBox["\[Backslash]`", "MR"],
              " ",
              StyleBox["box", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["FormBox[", "MR"],
              StyleBox["box", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["*", "MR"],
              " ",
              StyleBox["input", "TI"],
              " "
            }]], Cell[TextData[{
              "construct box by interpreting ",
              StyleBox["input", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              " "
            }]], Cell["insert a space "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["n", "MR"],
              " "
            }]], Cell["insert a newline "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["t", "MR"],
              " "
            }]], Cell["indent at the beginning of a line "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    False, False, False, False, False, False, False, False, True, False, True,
       False}},
  CellTags->"SA.2.9"],

Cell["\<\
String\[Hyphen]based ways of constructing raw boxes. \
\>", \
"Caption",
  CellTags->"SA.2.9"],

Cell[TextData[{
  "In string\[Hyphen]based input between \[Backslash]",
  StyleBox["(", "MR"],
  " and \[Backslash]",
  StyleBox[")", "MR"],
  " spaces, tabs and newlines are discarded. \[Backslash]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  " can be used to insert a single space. Special spacing characters such as \
\[Backslash]",
  StyleBox["[ThinSpace]", "MR"],
  ", \[Backslash]",
  StyleBox["[ThickSpace]", "MR"],
  " or \[Backslash]",
  StyleBox["[NegativeThinSpace]", "MR"],
  " are not discarded. "
}], "Text",
  CellTags->{"SA.2.9", "9.12"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.2.10 The Extent of Input Expressions", "Subsection",
  CellTags->{"SA.2.10", "10.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " will treat all input that you give on a single line as being part of the \
same expression. "
}], "Text",
  CellTags->{"SA.2.10", "10.2"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows a single expression to continue for several lines. In general, it \
treats the input that you give on successive lines as belonging to the same \
expression whenever no complete expression would be formed without doing \
this. "
}], "Text",
  CellTags->{"SA.2.10", "10.3"}],

Cell[TextData[{
  "Thus, for example, if one line ends with ",
  StyleBox["=", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " will assume that the expression must continue on the next line. It will \
do the same if for example parentheses or other matchfix operators remain \
open at the end of the line. "
}], "Text",
  CellTags->{"SA.2.10", "10.4"}],

Cell[TextData[{
  "If at the end of a particular line the input you have given so far \
corresponds to a complete expression, then ",
  StyleBox["Mathematica", "TI"],
  " will normally begin immediately to process that expression. "
}], "Text",
  CellTags->{"SA.2.10", "10.5"}],

Cell[TextData[{
  "You can however explicitly tell ",
  StyleBox["Mathematica", "TI"],
  " that a particular expression is incomplete by putting a \[Backslash] or a \
",
  Cell[BoxData[
      \(TraditionalForm\`\[Continuation]\)], "InlineFormula"],
  " (\[Backslash]",
  StyleBox["[Continuation]", "MR"],
  ") at the end of the line. ",
  StyleBox["Mathematica", "TI"],
  " will then include the next line in the same expression, discarding any \
spaces or tabs that occur at the beginning of that line. "
}], "Text",
  CellTags->{"SA.2.10", "10.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.2.11 Special Input", "Subsection",
  CellTags->{"SA.2.11", "11.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["?", "MR"],
              StyleBox["symbol", "TI"],
              " "
            }]], Cell["get information "]},
          {Cell[TextData[{
              StyleBox["??", "MR"],
              StyleBox["symbol", "TI"],
              " "
            }]], Cell["get more information "]},
          {Cell[TextData[{
              StyleBox["?", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]], Cell["get information on several objects "]},
          {Cell[TextData[{
              StyleBox["!", "MR"],
              StyleBox["command", "TI"],
              " "
            }]], Cell["execute an external command "]},
          {Cell[TextData[{
              StyleBox["!!", "MR"],
              StyleBox["file", "TI"],
              " "
            }]], Cell["display the contents of an external file "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.2.11"],

Cell["Special input lines. ", "Caption",
  CellTags->"SA.2.11"],

Cell[TextData[{
  "In most implementations of ",
  StyleBox["Mathematica", "TI"],
  ", you can give a line of special input anywhere in your input. The only \
constraint is that the special input must start at the beginning of a line. "
}], "Text",
  CellTags->{"SA.2.11", "11.2"}],

Cell[TextData[{
  "Some implementations of ",
  StyleBox["Mathematica", "TI"],
  " may not allow you to execute external commands using ",
  StyleBox["!", "MR"],
  StyleBox["command", "TI"],
  ". "
}], "Text",
  CellTags->{"SA.2.11", "11.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.2.12 Front End Files", "Subsection",
  CellTags->{"SA.2.12", "12.1"}],

Cell[TextData[{
  "Notebook files as well as front end initialization files can contain a \
subset of standard ",
  StyleBox["Mathematica", "TI"],
  " language syntax. This syntax includes: "
}], "Text",
  CellTags->{"SA.2.12", "12.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Any ",
  StyleBox["Mathematica", "TI"],
  " expression in ",
  StyleBox["FullForm", "MR"],
  ".  \n\[FilledSmallSquare] Lists in ",
  StyleBox["{", "MR"],
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  " form. The operators ",
  StyleBox["->", "MR"],
  ", ",
  StyleBox[":>", "MR"],
  " and ",
  StyleBox["&", "MR"],
  ". Function slots in ",
  StyleBox["#", "MR"],
  " form.  \n\[FilledSmallSquare] Various ",
  StyleBox["Mathematica", "TI"],
  " operators such as ",
  StyleBox["+", "MR"],
  ", ",
  StyleBox["*", "MR"],
  ", ",
  StyleBox[";", "MR"],
  ", etc.  \n\[FilledSmallSquare] Special characters in \[Backslash]",
  StyleBox["[", "MR"],
  StyleBox["Name", "TI"],
  StyleBox["]", "MR"],
  ", \[Backslash]",
  StyleBox[":", "MR"],
  StyleBox["xxxx", "TI"],
  " or \[Backslash]",
  StyleBox[".", "MR"],
  StyleBox["xx", "TI"],
  " form.  \n\[FilledSmallSquare] String representation of boxes involving \
\[Backslash]",
  StyleBox["(", "MR"],
  ", \[Backslash]",
  StyleBox[")", "MR"],
  " and other backslash operators.  \n\[FilledSmallSquare] ",
  StyleBox["Mathematica", "TI"],
  " comments delimited by ",
  StyleBox["(*", "MR"],
  " and ",
  StyleBox["*)", "MR"],
  ".  "
}], "Notes",
  CellTags->{"SA.2.12", "12.3"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.2.0"->{
    Cell[1776, 53, 115, 4, 65, "Section",
      CellTags->{"SA.2.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 115, 4, 65, "Section",
      CellTags->{"SA.2.0", "0.1"}]},
  "SA.2.1"->{
    Cell[1916, 61, 78, 1, 70, "Subsection",
      CellTags->{"SA.2.1", "1.1"}],
    Cell[1997, 64, 1123, 36, 70, "FramedBox",
      CellTags->"SA.2.1"],
    Cell[3123, 102, 75, 1, 70, "Caption",
      CellTags->"SA.2.1"],
    Cell[3201, 105, 310, 7, 70, "Text",
      CellTags->{"SA.2.1", "1.2"}],
    Cell[3514, 114, 10937, 272, 70, "DoubleBox",
      CellTags->"SA.2.1"],
    Cell[14454, 388, 119, 4, 70, "Caption",
      CellTags->"SA.2.1"],
    Cell[14576, 394, 291, 7, 70, "Text",
      CellTags->{"SA.2.1", "1.3"}],
    Cell[14870, 403, 293, 8, 70, "Text",
      CellTags->{"SA.2.1", "1.4"}],
    Cell[15166, 413, 1122, 34, 70, "DefinitionBox",
      CellTags->"SA.2.1"],
    Cell[16291, 449, 67, 1, 70, "Caption",
      CellTags->"SA.2.1"],
    Cell[16361, 452, 211, 5, 70, "Text",
      CellTags->{"SA.2.1", "1.5"}],
    Cell[16575, 459, 341, 7, 70, "Text",
      CellTags->{"SA.2.1", "1.6"}],
    Cell[16919, 468, 1618, 58, 70, "DefinitionBox",
      CellTags->"SA.2.1"],
    Cell[18540, 528, 88, 3, 70, "Caption",
      CellTags->"SA.2.1"]},
  "1.1"->{
    Cell[1916, 61, 78, 1, 70, "Subsection",
      CellTags->{"SA.2.1", "1.1"}]},
  "1.2"->{
    Cell[3201, 105, 310, 7, 70, "Text",
      CellTags->{"SA.2.1", "1.2"}]},
  "1.3"->{
    Cell[14576, 394, 291, 7, 70, "Text",
      CellTags->{"SA.2.1", "1.3"}]},
  "1.4"->{
    Cell[14870, 403, 293, 8, 70, "Text",
      CellTags->{"SA.2.1", "1.4"}]},
  "1.5"->{
    Cell[16361, 452, 211, 5, 70, "Text",
      CellTags->{"SA.2.1", "1.5"}]},
  "1.6"->{
    Cell[16575, 459, 341, 7, 70, "Text",
      CellTags->{"SA.2.1", "1.6"}]},
  "SA.2.2"->{
    Cell[18665, 536, 80, 1, 70, "Subsection",
      CellTags->{"SA.2.2", "2.1"}],
    Cell[18748, 539, 496, 16, 70, "Text",
      CellTags->{"SA.2.2", "2.2"}],
    Cell[19247, 557, 191, 5, 70, "Text",
      CellTags->{"SA.2.2", "2.3"}],
    Cell[19441, 564, 251, 9, 70, "Text",
      CellTags->{"SA.2.2", "2.4"}],
    Cell[19695, 575, 419, 9, 70, "Text",
      CellTags->{"SA.2.2", "2.5"}]},
  "2.1"->{
    Cell[18665, 536, 80, 1, 70, "Subsection",
      CellTags->{"SA.2.2", "2.1"}]},
  "2.2"->{
    Cell[18748, 539, 496, 16, 70, "Text",
      CellTags->{"SA.2.2", "2.2"}]},
  "2.3"->{
    Cell[19247, 557, 191, 5, 70, "Text",
      CellTags->{"SA.2.2", "2.3"}]},
  "2.4"->{
    Cell[19441, 564, 251, 9, 70, "Text",
      CellTags->{"SA.2.2", "2.4"}]},
  "2.5"->{
    Cell[19695, 575, 419, 9, 70, "Text",
      CellTags->{"SA.2.2", "2.5"}]},
  "SA.2.3"->{
    Cell[20151, 589, 76, 1, 70, "Subsection",
      CellTags->{"SA.2.3", "3.1"}],
    Cell[20230, 592, 1465, 48, 70, "DefinitionBox",
      CellTags->"SA.2.3"],
    Cell[21698, 642, 69, 1, 70, "Caption",
      CellTags->"SA.2.3"],
    Cell[21770, 645, 245, 5, 70, "Text",
      CellTags->{"SA.2.3", "3.2"}],
    Cell[22018, 652, 320, 10, 70, "Text",
      CellTags->{"SA.2.3", "3.3"}],
    Cell[22341, 664, 261, 9, 70, "Text",
      CellTags->{"SA.2.3", "3.4"}],
    Cell[22605, 675, 205, 5, 70, "Text",
      CellTags->{"SA.2.3", "3.5"}]},
  "3.1"->{
    Cell[20151, 589, 76, 1, 70, "Subsection",
      CellTags->{"SA.2.3", "3.1"}]},
  "3.2"->{
    Cell[21770, 645, 245, 5, 70, "Text",
      CellTags->{"SA.2.3", "3.2"}]},
  "3.3"->{
    Cell[22018, 652, 320, 10, 70, "Text",
      CellTags->{"SA.2.3", "3.3"}]},
  "3.4"->{
    Cell[22341, 664, 261, 9, 70, "Text",
      CellTags->{"SA.2.3", "3.4"}]},
  "3.5"->{
    Cell[22605, 675, 205, 5, 70, "Text",
      CellTags->{"SA.2.3", "3.5"}]},
  "SA.2.4"->{
    Cell[22847, 685, 84, 1, 70, "Subsection",
      CellTags->{"SA.2.4", "4.1"}],
    Cell[22934, 688, 724, 21, 70, "DefinitionBox",
      CellTags->"SA.2.4"],
    Cell[23661, 711, 68, 1, 70, "Caption",
      CellTags->"SA.2.4"],
    Cell[23732, 714, 273, 7, 70, "Text",
      CellTags->{"SA.2.4", "4.2"}]},
  "4.1"->{
    Cell[22847, 685, 84, 1, 70, "Subsection",
      CellTags->{"SA.2.4", "4.1"}]},
  "4.2"->{
    Cell[23732, 714, 273, 7, 70, "Text",
      CellTags->{"SA.2.4", "4.2"}]},
  "SA.2.5"->{
    Cell[24042, 726, 66, 1, 70, "Subsection",
      CellTags->{"SA.2.5", "5.1"}],
    Cell[24111, 729, 3255, 96, 70, "DefinitionBox",
      CellTags->"SA.2.5"],
    Cell[27369, 827, 66, 1, 70, "Caption",
      CellTags->"SA.2.5"],
    Cell[27438, 830, 771, 26, 70, "Text",
      CellTags->{"SA.2.5", "5.2"}],
    Cell[28212, 858, 267, 9, 70, "Text",
      CellTags->{"SA.2.5", "5.3"}],
    Cell[28482, 869, 178, 5, 70, "Text",
      CellTags->{"SA.2.5", "5.4"}],
    Cell[28663, 876, 369, 12, 70, "Text",
      CellTags->{"SA.2.5", "5.5"}],
    Cell[29035, 890, 825, 29, 70, "Text",
      CellTags->{"SA.2.5", "5.6"}],
    Cell[29863, 921, 260, 10, 70, "Text",
      CellTags->{"SA.2.5", "5.7"}]},
  "5.1"->{
    Cell[24042, 726, 66, 1, 70, "Subsection",
      CellTags->{"SA.2.5", "5.1"}]},
  "5.2"->{
    Cell[27438, 830, 771, 26, 70, "Text",
      CellTags->{"SA.2.5", "5.2"}]},
  "5.3"->{
    Cell[28212, 858, 267, 9, 70, "Text",
      CellTags->{"SA.2.5", "5.3"}]},
  "5.4"->{
    Cell[28482, 869, 178, 5, 70, "Text",
      CellTags->{"SA.2.5", "5.4"}]},
  "5.5"->{
    Cell[28663, 876, 369, 12, 70, "Text",
      CellTags->{"SA.2.5", "5.5"}]},
  "5.6"->{
    Cell[29035, 890, 825, 29, 70, "Text",
      CellTags->{"SA.2.5", "5.6"}]},
  "5.7"->{
    Cell[29863, 921, 260, 10, 70, "Text",
      CellTags->{"SA.2.5", "5.7"}]},
  "SA.2.6"->{
    Cell[30160, 936, 76, 1, 70, "Subsection",
      CellTags->{"SA.2.6", "6.1"}],
    Cell[30239, 939, 257, 6, 70, "Text",
      CellTags->{"SA.2.6", "6.2"}],
    Cell[30499, 947, 263, 6, 70, "Text",
      CellTags->{"SA.2.6", "6.3"}],
    Cell[30765, 955, 706, 22, 70, "DefinitionBox",
      CellTags->"SA.2.6"],
    Cell[31474, 979, 111, 4, 70, "Caption",
      CellTags->"SA.2.6"],
    Cell[31588, 985, 186, 4, 70, "Text",
      CellTags->{"SA.2.6", "6.4"}],
    Cell[31777, 991, 332, 14, 70, "Text",
      CellTags->{"SA.2.6", "6.5"}],
    Cell[32112, 1007, 7594, 223, 70, "DefinitionBox",
      CellTags->"SA.2.6"],
    Cell[39709, 1232, 114, 4, 70, "Caption",
      CellTags->"SA.2.6"],
    Cell[39826, 1238, 155, 4, 70, "Text",
      CellTags->{"SA.2.6", "6.6"}],
    Cell[39984, 1244, 556, 22, 70, "Text",
      CellTags->{"SA.2.6", "6.7"}],
    Cell[40543, 1268, 212, 10, 70, "Text",
      CellTags->{"SA.2.6", "6.8"}],
    Cell[40758, 1280, 1100, 44, 70, "Text",
      CellTags->{"SA.2.6", "6.9"}],
    Cell[41861, 1326, 295, 8, 70, "Text",
      CellTags->{"SA.2.6", "6.10"}],
    Cell[42159, 1336, 345, 12, 70, "Text",
      CellTags->{"SA.2.6", "6.11"}],
    Cell[42507, 1350, 588, 21, 70, "Text",
      CellTags->{"SA.2.6", "6.12"}],
    Cell[43098, 1373, 4139, 123, 70, "DefinitionBox",
      CellTags->"SA.2.6"],
    Cell[47240, 1498, 71, 1, 70, "Caption",
      CellTags->"SA.2.6"],
    Cell[47314, 1501, 208, 5, 70, "Text",
      CellTags->{"SA.2.6", "6.13"}],
    Cell[47525, 1508, 810, 35, 70, "Text",
      CellTags->{"SA.2.6", "6.14"}]},
  "6.1"->{
    Cell[30160, 936, 76, 1, 70, "Subsection",
      CellTags->{"SA.2.6", "6.1"}]},
  "6.2"->{
    Cell[30239, 939, 257, 6, 70, "Text",
      CellTags->{"SA.2.6", "6.2"}]},
  "6.3"->{
    Cell[30499, 947, 263, 6, 70, "Text",
      CellTags->{"SA.2.6", "6.3"}]},
  "6.4"->{
    Cell[31588, 985, 186, 4, 70, "Text",
      CellTags->{"SA.2.6", "6.4"}]},
  "6.5"->{
    Cell[31777, 991, 332, 14, 70, "Text",
      CellTags->{"SA.2.6", "6.5"}]},
  "6.6"->{
    Cell[39826, 1238, 155, 4, 70, "Text",
      CellTags->{"SA.2.6", "6.6"}]},
  "6.7"->{
    Cell[39984, 1244, 556, 22, 70, "Text",
      CellTags->{"SA.2.6", "6.7"}]},
  "6.8"->{
    Cell[40543, 1268, 212, 10, 70, "Text",
      CellTags->{"SA.2.6", "6.8"}]},
  "6.9"->{
    Cell[40758, 1280, 1100, 44, 70, "Text",
      CellTags->{"SA.2.6", "6.9"}]},
  "6.10"->{
    Cell[41861, 1326, 295, 8, 70, "Text",
      CellTags->{"SA.2.6", "6.10"}]},
  "6.11"->{
    Cell[42159, 1336, 345, 12, 70, "Text",
      CellTags->{"SA.2.6", "6.11"}]},
  "6.12"->{
    Cell[42507, 1350, 588, 21, 70, "Text",
      CellTags->{"SA.2.6", "6.12"}]},
  "6.13"->{
    Cell[47314, 1501, 208, 5, 70, "Text",
      CellTags->{"SA.2.6", "6.13"}]},
  "6.14"->{
    Cell[47525, 1508, 810, 35, 70, "Text",
      CellTags->{"SA.2.6", "6.14"}]},
  "SA.2.7"->{
    Cell[48372, 1548, 79, 1, 70, "Subsection",
      CellTags->{"SA.2.7", "7.1"}],
    Cell[48454, 1551, 663, 16, 70, "Text",
      CellTags->{"SA.2.7", "7.2"}],
    Cell[49120, 1569, 733, 24, 70, "Text",
      CellTags->{"SA.2.7", "7.3"}],
    Cell[49856, 1595, 2036, 58, 70, "DefinitionBox",
      CellTags->"SA.2.7"],
    Cell[51895, 1655, 93, 1, 70, "Caption",
      CellTags->"SA.2.7"],
    Cell[51991, 1658, 32989, 907, 70, "PrecedenceTable",
      CellTags->"SA.2.7"],
    Cell[84983, 2567, 117, 4, 70, "Caption",
      CellTags->"SA.2.7"],
    Cell[85103, 2573, 37408, 1063, 70, "PrecedenceTable",
      CellTags->"SA.2.7"],
    Cell[122514, 3638, 118, 4, 70, "Caption",
      CellTags->"SA.2.7"],
    Cell[122635, 3644, 51695, 1456, 70, "PrecedenceTable",
      CellTags->"SA.2.7"],
    Cell[174333, 5102, 120, 4, 70, "Caption",
      CellTags->"SA.2.7"],
    Cell[174456, 5108, 44460, 1266, 70, "PrecedenceTable",
      CellTags->"SA.2.7"],
    Cell[218919, 6376, 119, 4, 70, "Caption",
      CellTags->"SA.2.7"],
    Cell[219041, 6382, 43458, 1220, 70, "PrecedenceTable",
      CellTags->"SA.2.7"],
    Cell[262502, 7604, 119, 4, 70, "Caption",
      CellTags->"SA.2.7"],
    Cell[262624, 7610, 43631, 1258, 70, "PrecedenceTable",
      CellTags->"SA.2.7"],
    Cell[306258, 8870, 118, 4, 70, "Caption",
      CellTags->"SA.2.7"],
    Cell[306379, 8876, 7684, 256, 70, "DefinitionBox",
      CellTags->"SA.2.7"],
    Cell[314066, 9134, 100, 1, 70, "Caption",
      CellTags->"SA.2.7"],
    Cell[314191, 9139, 74, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.4"}],
    Cell[314268, 9142, 614, 18, 70, "Text",
      CellTags->{"SA.2.7", "7.5"}],
    Cell[314885, 9162, 307, 11, 70, "Text",
      CellTags->{"SA.2.7", "7.6"}],
    Cell[315195, 9175, 265, 8, 70, "Text",
      CellTags->{"SA.2.7", "7.7"}],
    Cell[315463, 9185, 5217, 124, 70, "DoubleBox",
      CellTags->"SA.2.7"],
    Cell[320683, 9311, 114, 4, 70, "Caption",
      CellTags->"SA.2.7"],
    Cell[320800, 9317, 8549, 203, 70, "DoubleBox",
      CellTags->"SA.2.7"],
    Cell[329352, 9522, 121, 4, 70, "Caption",
      CellTags->"SA.2.7"],
    Cell[329510, 9531, 98, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.8"}],
    Cell[329611, 9534, 1910, 61, 70, "Text",
      CellTags->{"SA.2.7", "7.9"}],
    Cell[331558, 9600, 80, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.10"}],
    Cell[331641, 9603, 868, 29, 70, "Text",
      CellTags->{"SA.2.7", "7.11"}],
    Cell[332546, 9637, 92, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.12"}],
    Cell[332641, 9640, 1286, 40, 70, "Text",
      CellTags->{"SA.2.7", "7.13"}],
    Cell[333930, 9682, 327, 11, 70, "Text",
      CellTags->{"SA.2.7", "7.14"}],
    Cell[334260, 9695, 271, 8, 70, "Text",
      CellTags->{"SA.2.7", "7.15"}],
    Cell[334568, 9708, 82, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.16"}],
    Cell[334653, 9711, 356, 9, 70, "Text",
      CellTags->{"SA.2.7", "7.17"}],
    Cell[335012, 9722, 2617, 82, 70, "FramedBox",
      CellTags->"SA.2.7"],
    Cell[337632, 9806, 79, 1, 70, "Caption",
      CellTags->"SA.2.7"],
    Cell[337714, 9809, 360, 13, 70, "Text",
      CellTags->{"SA.2.7", "7.18"}],
    Cell[338077, 9824, 366, 12, 70, "Text",
      CellTags->{"SA.2.7", "7.19"}],
    Cell[338446, 9838, 397, 7, 70, "Text",
      CellTags->{"SA.2.7", "7.20"}],
    Cell[338846, 9847, 1161, 39, 70, "FramedBox",
      CellTags->"SA.2.7"],
    Cell[340010, 9888, 73, 1, 70, "Caption",
      CellTags->"SA.2.7"],
    Cell[340120, 9894, 72, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.21"}],
    Cell[340195, 9897, 355, 11, 70, "Text",
      CellTags->{"SA.2.7", "7.22"}],
    Cell[340553, 9910, 433, 16, 70, "Text",
      CellTags->{"SA.2.7", "7.23"}],
    Cell[340989, 9928, 218, 7, 70, "Text",
      CellTags->{"SA.2.7", "7.24"}],
    Cell[341244, 9940, 75, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.25"}],
    Cell[341322, 9943, 1337, 37, 70, "FramedBox",
      CellTags->"SA.2.7"],
    Cell[342662, 9982, 112, 4, 70, "Caption",
      CellTags->"SA.2.7"],
    Cell[342811, 9991, 77, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.26"}],
    Cell[342891, 9994, 1035, 50, 70, "Text",
      CellTags->{"SA.2.7", "7.27"}],
    Cell[343963, 10049, 67, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.28"}],
    Cell[344033, 10052, 1090, 42, 70, "Text",
      CellTags->{"SA.2.7", "7.29"}]},
  "7.1"->{
    Cell[48372, 1548, 79, 1, 70, "Subsection",
      CellTags->{"SA.2.7", "7.1"}]},
  "7.2"->{
    Cell[48454, 1551, 663, 16, 70, "Text",
      CellTags->{"SA.2.7", "7.2"}]},
  "7.3"->{
    Cell[49120, 1569, 733, 24, 70, "Text",
      CellTags->{"SA.2.7", "7.3"}]},
  "7.4"->{
    Cell[314191, 9139, 74, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.4"}]},
  "7.5"->{
    Cell[314268, 9142, 614, 18, 70, "Text",
      CellTags->{"SA.2.7", "7.5"}]},
  "7.6"->{
    Cell[314885, 9162, 307, 11, 70, "Text",
      CellTags->{"SA.2.7", "7.6"}]},
  "7.7"->{
    Cell[315195, 9175, 265, 8, 70, "Text",
      CellTags->{"SA.2.7", "7.7"}]},
  "7.8"->{
    Cell[329510, 9531, 98, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.8"}]},
  "7.9"->{
    Cell[329611, 9534, 1910, 61, 70, "Text",
      CellTags->{"SA.2.7", "7.9"}]},
  "7.10"->{
    Cell[331558, 9600, 80, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.10"}]},
  "7.11"->{
    Cell[331641, 9603, 868, 29, 70, "Text",
      CellTags->{"SA.2.7", "7.11"}]},
  "7.12"->{
    Cell[332546, 9637, 92, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.12"}]},
  "7.13"->{
    Cell[332641, 9640, 1286, 40, 70, "Text",
      CellTags->{"SA.2.7", "7.13"}]},
  "7.14"->{
    Cell[333930, 9682, 327, 11, 70, "Text",
      CellTags->{"SA.2.7", "7.14"}]},
  "7.15"->{
    Cell[334260, 9695, 271, 8, 70, "Text",
      CellTags->{"SA.2.7", "7.15"}]},
  "7.16"->{
    Cell[334568, 9708, 82, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.16"}]},
  "7.17"->{
    Cell[334653, 9711, 356, 9, 70, "Text",
      CellTags->{"SA.2.7", "7.17"}]},
  "7.18"->{
    Cell[337714, 9809, 360, 13, 70, "Text",
      CellTags->{"SA.2.7", "7.18"}]},
  "7.19"->{
    Cell[338077, 9824, 366, 12, 70, "Text",
      CellTags->{"SA.2.7", "7.19"}]},
  "7.20"->{
    Cell[338446, 9838, 397, 7, 70, "Text",
      CellTags->{"SA.2.7", "7.20"}]},
  "7.21"->{
    Cell[340120, 9894, 72, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.21"}]},
  "7.22"->{
    Cell[340195, 9897, 355, 11, 70, "Text",
      CellTags->{"SA.2.7", "7.22"}]},
  "7.23"->{
    Cell[340553, 9910, 433, 16, 70, "Text",
      CellTags->{"SA.2.7", "7.23"}]},
  "7.24"->{
    Cell[340989, 9928, 218, 7, 70, "Text",
      CellTags->{"SA.2.7", "7.24"}]},
  "7.25"->{
    Cell[341244, 9940, 75, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.25"}]},
  "7.26"->{
    Cell[342811, 9991, 77, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.26"}]},
  "7.27"->{
    Cell[342891, 9994, 1035, 50, 70, "Text",
      CellTags->{"SA.2.7", "7.27"}]},
  "7.28"->{
    Cell[343963, 10049, 67, 1, 70, "Subsubsection",
      CellTags->{"SA.2.7", "7.28"}]},
  "7.29"->{
    Cell[344033, 10052, 1090, 42, 70, "Text",
      CellTags->{"SA.2.7", "7.29"}]},
  "SA.2.8"->{
    Cell[345172, 10100, 102, 3, 70, "Subsection",
      CellTags->{"SA.2.8", "8.1"}],
    Cell[345277, 10105, 17037, 374, 70, "DoubleBox",
      CellTags->"SA.2.8"],
    Cell[362317, 10481, 127, 4, 70, "Caption",
      CellTags->"SA.2.8"],
    Cell[362447, 10487, 688, 26, 70, "Text",
      CellTags->{"SA.2.8", "8.2"}],
    Cell[363138, 10515, 1067, 43, 70, "Text",
      CellTags->{"SA.2.8", "8.3"}],
    Cell[364208, 10560, 9538, 222, 70, "DoubleBox",
      CellTags->"SA.2.8"],
    Cell[373749, 10784, 130, 4, 70, "Caption",
      CellTags->"SA.2.8"],
    Cell[373882, 10790, 778, 27, 70, "Text",
      CellTags->{"SA.2.8", "8.4"}]},
  "8.1"->{
    Cell[345172, 10100, 102, 3, 70, "Subsection",
      CellTags->{"SA.2.8", "8.1"}]},
  "8.2"->{
    Cell[362447, 10487, 688, 26, 70, "Text",
      CellTags->{"SA.2.8", "8.2"}]},
  "8.3"->{
    Cell[363138, 10515, 1067, 43, 70, "Text",
      CellTags->{"SA.2.8", "8.3"}]},
  "8.4"->{
    Cell[373882, 10790, 778, 27, 70, "Text",
      CellTags->{"SA.2.8", "8.4"}]},
  "SA.2.9"->{
    Cell[374697, 10822, 73, 1, 70, "Subsection",
      CellTags->{"SA.2.9", "9.1"}],
    Cell[374773, 10825, 878, 23, 70, "FramedBox",
      CellTags->"SA.2.9"],
    Cell[375654, 10850, 62, 1, 70, "Caption",
      CellTags->"SA.2.9"],
    Cell[375741, 10855, 68, 1, 70, "Subsubsection",
      CellTags->{"SA.2.9", "9.2"}],
    Cell[375812, 10858, 5431, 134, 70, "DefinitionBox",
      CellTags->"SA.2.9"],
    Cell[381246, 10994, 64, 1, 70, "Caption",
      CellTags->"SA.2.9"],
    Cell[381313, 10997, 216, 5, 70, "Text",
      CellTags->{"SA.2.9", "9.3"}],
    Cell[381566, 11007, 83, 1, 70, "Subsubsection",
      CellTags->{"SA.2.9", "9.4"}],
    Cell[381652, 11010, 327, 8, 70, "Text",
      CellTags->{"SA.2.9", "9.5"}],
    Cell[381982, 11020, 399, 14, 70, "Text",
      CellTags->{"SA.2.9", "9.6"}],
    Cell[382384, 11036, 1052, 32, 70, "FramedBox",
      CellTags->"SA.2.9"],
    Cell[383439, 11070, 90, 1, 70, "Caption",
      CellTags->"SA.2.9"],
    Cell[383532, 11073, 322, 9, 70, "Text",
      CellTags->{"SA.2.9", "9.7"}],
    Cell[383857, 11084, 206, 5, 70, "Text",
      CellTags->{"SA.2.9", "9.8"}],
    Cell[384100, 11094, 82, 1, 70, "Subsubsection",
      CellTags->{"SA.2.9", "9.9"}],
    Cell[384185, 11097, 763, 24, 70, "DefinitionBox",
      CellTags->"SA.2.9"],
    Cell[384951, 11123, 78, 1, 70, "Caption",
      CellTags->"SA.2.9"],
    Cell[385032, 11126, 791, 30, 70, "Text",
      CellTags->{"SA.2.9", "9.10"}],
    Cell[385826, 11158, 400, 17, 70, "Text",
      CellTags->{"SA.2.9", "9.11"}],
    Cell[386229, 11177, 12362, 354, 70, "DefinitionBox",
      CellTags->"SA.2.9"],
    Cell[398594, 11533, 104, 4, 70, "Caption",
      CellTags->"SA.2.9"],
    Cell[398701, 11539, 594, 17, 70, "Text",
      CellTags->{"SA.2.9", "9.12"}]},
  "9.1"->{
    Cell[374697, 10822, 73, 1, 70, "Subsection",
      CellTags->{"SA.2.9", "9.1"}]},
  "9.2"->{
    Cell[375741, 10855, 68, 1, 70, "Subsubsection",
      CellTags->{"SA.2.9", "9.2"}]},
  "9.3"->{
    Cell[381313, 10997, 216, 5, 70, "Text",
      CellTags->{"SA.2.9", "9.3"}]},
  "9.4"->{
    Cell[381566, 11007, 83, 1, 70, "Subsubsection",
      CellTags->{"SA.2.9", "9.4"}]},
  "9.5"->{
    Cell[381652, 11010, 327, 8, 70, "Text",
      CellTags->{"SA.2.9", "9.5"}]},
  "9.6"->{
    Cell[381982, 11020, 399, 14, 70, "Text",
      CellTags->{"SA.2.9", "9.6"}]},
  "9.7"->{
    Cell[383532, 11073, 322, 9, 70, "Text",
      CellTags->{"SA.2.9", "9.7"}]},
  "9.8"->{
    Cell[383857, 11084, 206, 5, 70, "Text",
      CellTags->{"SA.2.9", "9.8"}]},
  "9.9"->{
    Cell[384100, 11094, 82, 1, 70, "Subsubsection",
      CellTags->{"SA.2.9", "9.9"}]},
  "9.10"->{
    Cell[385032, 11126, 791, 30, 70, "Text",
      CellTags->{"SA.2.9", "9.10"}]},
  "9.11"->{
    Cell[385826, 11158, 400, 17, 70, "Text",
      CellTags->{"SA.2.9", "9.11"}]},
  "9.12"->{
    Cell[398701, 11539, 594, 17, 70, "Text",
      CellTags->{"SA.2.9", "9.12"}]},
  "SA.2.10"->{
    Cell[399344, 11562, 93, 1, 70, "Subsection",
      CellTags->{"SA.2.10", "10.1"}],
    Cell[399440, 11565, 191, 5, 40, "Text",
      CellTags->{"SA.2.10", "10.2"}],
    Cell[399634, 11572, 333, 7, 70, "Text",
      CellTags->{"SA.2.10", "10.3"}],
    Cell[399970, 11581, 361, 9, 56, "Text",
      CellTags->{"SA.2.10", "10.4"}],
    Cell[400334, 11592, 277, 6, 56, "Text",
      CellTags->{"SA.2.10", "10.5"}],
    Cell[400614, 11600, 550, 14, 72, "Text",
      CellTags->{"SA.2.10", "10.6"}]},
  "10.1"->{
    Cell[399344, 11562, 93, 1, 70, "Subsection",
      CellTags->{"SA.2.10", "10.1"}]},
  "10.2"->{
    Cell[399440, 11565, 191, 5, 40, "Text",
      CellTags->{"SA.2.10", "10.2"}]},
  "10.3"->{
    Cell[399634, 11572, 333, 7, 70, "Text",
      CellTags->{"SA.2.10", "10.3"}]},
  "10.4"->{
    Cell[399970, 11581, 361, 9, 56, "Text",
      CellTags->{"SA.2.10", "10.4"}]},
  "10.5"->{
    Cell[400334, 11592, 277, 6, 56, "Text",
      CellTags->{"SA.2.10", "10.5"}]},
  "10.6"->{
    Cell[400614, 11600, 550, 14, 72, "Text",
      CellTags->{"SA.2.10", "10.6"}]},
  "SA.2.11"->{
    Cell[401201, 11619, 75, 1, 38, "Subsection",
      CellTags->{"SA.2.11", "11.1"}],
    Cell[401279, 11622, 1531, 44, 130, "DefinitionBox",
      CellTags->"SA.2.11"],
    Cell[402813, 11668, 63, 1, 16, "Caption",
      CellTags->"SA.2.11"],
    Cell[402879, 11671, 281, 6, 56, "Text",
      CellTags->{"SA.2.11", "11.2"}],
    Cell[403163, 11679, 242, 8, 40, "Text",
      CellTags->{"SA.2.11", "11.3"}]},
  "11.1"->{
    Cell[401201, 11619, 75, 1, 38, "Subsection",
      CellTags->{"SA.2.11", "11.1"}]},
  "11.2"->{
    Cell[402879, 11671, 281, 6, 56, "Text",
      CellTags->{"SA.2.11", "11.2"}]},
  "11.3"->{
    Cell[403163, 11679, 242, 8, 40, "Text",
      CellTags->{"SA.2.11", "11.3"}]},
  "SA.2.12"->{
    Cell[403442, 11692, 77, 1, 38, "Subsection",
      CellTags->{"SA.2.12", "12.1"}],
    Cell[403522, 11695, 236, 6, 40, "Text",
      CellTags->{"SA.2.12", "12.2"}],
    Cell[403761, 11703, 1271, 49, 134, "Notes",
      CellTags->{"SA.2.12", "12.3"}]},
  "12.1"->{
    Cell[403442, 11692, 77, 1, 38, "Subsection",
      CellTags->{"SA.2.12", "12.1"}]},
  "12.2"->{
    Cell[403522, 11695, 236, 6, 40, "Text",
      CellTags->{"SA.2.12", "12.2"}]},
  "12.3"->{
    Cell[403761, 11703, 1271, 49, 134, "Notes",
      CellTags->{"SA.2.12", "12.3"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.2.0", 405675, 11772},
  {"0.1", 405765, 11775},
  {"SA.2.1", 405858, 11778},
  {"1.1", 406921, 11807},
  {"1.2", 407013, 11810},
  {"1.3", 407101, 11813},
  {"1.4", 407190, 11816},
  {"1.5", 407279, 11819},
  {"1.6", 407368, 11822},
  {"SA.2.2", 407460, 11825},
  {"2.1", 407863, 11836},
  {"2.2", 407957, 11839},
  {"2.3", 408047, 11842},
  {"2.4", 408136, 11845},
  {"2.5", 408225, 11848},
  {"SA.2.3", 408317, 11851},
  {"3.1", 408869, 11866},
  {"3.2", 408963, 11869},
  {"3.3", 409052, 11872},
  {"3.4", 409142, 11875},
  {"3.5", 409231, 11878},
  {"SA.2.4", 409323, 11881},
  {"4.1", 409642, 11890},
  {"4.2", 409736, 11893},
  {"SA.2.5", 409828, 11896},
  {"5.1", 410537, 11915},
  {"5.2", 410631, 11918},
  {"5.3", 410721, 11921},
  {"5.4", 410810, 11924},
  {"5.5", 410899, 11927},
  {"5.6", 410989, 11930},
  {"5.7", 411079, 11933},
  {"SA.2.6", 411172, 11936},
  {"6.1", 412743, 11977},
  {"6.2", 412837, 11980},
  {"6.3", 412926, 11983},
  {"6.4", 413015, 11986},
  {"6.5", 413104, 11989},
  {"6.6", 413194, 11992},
  {"6.7", 413284, 11995},
  {"6.8", 413375, 11998},
  {"6.9", 413466, 12001},
  {"6.10", 413559, 12004},
  {"6.11", 413651, 12007},
  {"6.12", 413744, 12010},
  {"6.13", 413837, 12013},
  {"6.14", 413929, 12016},
  {"SA.2.7", 414024, 12019},
  {"7.1", 418447, 12130},
  {"7.2", 418542, 12133},
  {"7.3", 418633, 12136},
  {"7.4", 418724, 12139},
  {"7.5", 418823, 12142},
  {"7.6", 418915, 12145},
  {"7.7", 419007, 12148},
  {"7.8", 419098, 12151},
  {"7.9", 419197, 12154},
  {"7.10", 419291, 12157},
  {"7.11", 419392, 12160},
  {"7.12", 419486, 12163},
  {"7.13", 419587, 12166},
  {"7.14", 419682, 12169},
  {"7.15", 419776, 12172},
  {"7.16", 419869, 12175},
  {"7.17", 419970, 12178},
  {"7.18", 420063, 12181},
  {"7.19", 420157, 12184},
  {"7.20", 420251, 12187},
  {"7.21", 420344, 12190},
  {"7.22", 420445, 12193},
  {"7.23", 420539, 12196},
  {"7.24", 420633, 12199},
  {"7.25", 420726, 12202},
  {"7.26", 420827, 12205},
  {"7.27", 420928, 12208},
  {"7.28", 421023, 12211},
  {"7.29", 421125, 12214},
  {"SA.2.8", 421223, 12217},
  {"8.1", 421872, 12234},
  {"8.2", 421970, 12237},
  {"8.3", 422063, 12240},
  {"8.4", 422157, 12243},
  {"SA.2.9", 422253, 12246},
  {"9.1", 424030, 12291},
  {"9.2", 424127, 12294},
  {"9.3", 424227, 12297},
  {"9.4", 424319, 12300},
  {"9.5", 424419, 12303},
  {"9.6", 424511, 12306},
  {"9.7", 424604, 12309},
  {"9.8", 424696, 12312},
  {"9.9", 424788, 12315},
  {"9.10", 424889, 12318},
  {"9.11", 424984, 12321},
  {"9.12", 425079, 12324},
  {"SA.2.10", 425177, 12327},
  {"10.1", 425688, 12340},
  {"10.2", 425788, 12343},
  {"10.3", 425883, 12346},
  {"10.4", 425978, 12349},
  {"10.5", 426073, 12352},
  {"10.6", 426168, 12355},
  {"SA.2.11", 426267, 12358},
  {"11.1", 426689, 12369},
  {"11.2", 426789, 12372},
  {"11.3", 426884, 12375},
  {"SA.2.12", 426982, 12378},
  {"12.1", 427250, 12385},
  {"12.2", 427350, 12388},
  {"12.3", 427445, 12391}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 115, 4, 65, "Section",
  CellTags->{"SA.2.0", "0.1"}],

Cell[CellGroupData[{
Cell[1916, 61, 78, 1, 70, "Subsection",
  CellTags->{"SA.2.1", "1.1"}],
Cell[1997, 64, 1123, 36, 70, "FramedBox",
  CellTags->"SA.2.1"],
Cell[3123, 102, 75, 1, 70, "Caption",
  CellTags->"SA.2.1"],
Cell[3201, 105, 310, 7, 70, "Text",
  CellTags->{"SA.2.1", "1.2"}],
Cell[3514, 114, 10937, 272, 70, "DoubleBox",
  CellTags->"SA.2.1"],
Cell[14454, 388, 119, 4, 70, "Caption",
  CellTags->"SA.2.1"],
Cell[14576, 394, 291, 7, 70, "Text",
  CellTags->{"SA.2.1", "1.3"}],
Cell[14870, 403, 293, 8, 70, "Text",
  CellTags->{"SA.2.1", "1.4"}],
Cell[15166, 413, 1122, 34, 70, "DefinitionBox",
  CellTags->"SA.2.1"],
Cell[16291, 449, 67, 1, 70, "Caption",
  CellTags->"SA.2.1"],
Cell[16361, 452, 211, 5, 70, "Text",
  CellTags->{"SA.2.1", "1.5"}],
Cell[16575, 459, 341, 7, 70, "Text",
  CellTags->{"SA.2.1", "1.6"}],
Cell[16919, 468, 1618, 58, 70, "DefinitionBox",
  CellTags->"SA.2.1"],
Cell[18540, 528, 88, 3, 70, "Caption",
  CellTags->"SA.2.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18665, 536, 80, 1, 70, "Subsection",
  CellTags->{"SA.2.2", "2.1"}],
Cell[18748, 539, 496, 16, 70, "Text",
  CellTags->{"SA.2.2", "2.2"}],
Cell[19247, 557, 191, 5, 70, "Text",
  CellTags->{"SA.2.2", "2.3"}],
Cell[19441, 564, 251, 9, 70, "Text",
  CellTags->{"SA.2.2", "2.4"}],
Cell[19695, 575, 419, 9, 70, "Text",
  CellTags->{"SA.2.2", "2.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[20151, 589, 76, 1, 70, "Subsection",
  CellTags->{"SA.2.3", "3.1"}],
Cell[20230, 592, 1465, 48, 70, "DefinitionBox",
  CellTags->"SA.2.3"],
Cell[21698, 642, 69, 1, 70, "Caption",
  CellTags->"SA.2.3"],
Cell[21770, 645, 245, 5, 70, "Text",
  CellTags->{"SA.2.3", "3.2"}],
Cell[22018, 652, 320, 10, 70, "Text",
  CellTags->{"SA.2.3", "3.3"}],
Cell[22341, 664, 261, 9, 70, "Text",
  CellTags->{"SA.2.3", "3.4"}],
Cell[22605, 675, 205, 5, 70, "Text",
  CellTags->{"SA.2.3", "3.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22847, 685, 84, 1, 70, "Subsection",
  CellTags->{"SA.2.4", "4.1"}],
Cell[22934, 688, 724, 21, 70, "DefinitionBox",
  CellTags->"SA.2.4"],
Cell[23661, 711, 68, 1, 70, "Caption",
  CellTags->"SA.2.4"],
Cell[23732, 714, 273, 7, 70, "Text",
  CellTags->{"SA.2.4", "4.2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[24042, 726, 66, 1, 70, "Subsection",
  CellTags->{"SA.2.5", "5.1"}],
Cell[24111, 729, 3255, 96, 70, "DefinitionBox",
  CellTags->"SA.2.5"],
Cell[27369, 827, 66, 1, 70, "Caption",
  CellTags->"SA.2.5"],
Cell[27438, 830, 771, 26, 70, "Text",
  CellTags->{"SA.2.5", "5.2"}],
Cell[28212, 858, 267, 9, 70, "Text",
  CellTags->{"SA.2.5", "5.3"}],
Cell[28482, 869, 178, 5, 70, "Text",
  CellTags->{"SA.2.5", "5.4"}],
Cell[28663, 876, 369, 12, 70, "Text",
  CellTags->{"SA.2.5", "5.5"}],
Cell[29035, 890, 825, 29, 70, "Text",
  CellTags->{"SA.2.5", "5.6"}],
Cell[29863, 921, 260, 10, 70, "Text",
  CellTags->{"SA.2.5", "5.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[30160, 936, 76, 1, 70, "Subsection",
  CellTags->{"SA.2.6", "6.1"}],
Cell[30239, 939, 257, 6, 70, "Text",
  CellTags->{"SA.2.6", "6.2"}],
Cell[30499, 947, 263, 6, 70, "Text",
  CellTags->{"SA.2.6", "6.3"}],
Cell[30765, 955, 706, 22, 70, "DefinitionBox",
  CellTags->"SA.2.6"],
Cell[31474, 979, 111, 4, 70, "Caption",
  CellTags->"SA.2.6"],
Cell[31588, 985, 186, 4, 70, "Text",
  CellTags->{"SA.2.6", "6.4"}],
Cell[31777, 991, 332, 14, 70, "Text",
  CellTags->{"SA.2.6", "6.5"}],
Cell[32112, 1007, 7594, 223, 70, "DefinitionBox",
  CellTags->"SA.2.6"],
Cell[39709, 1232, 114, 4, 70, "Caption",
  CellTags->"SA.2.6"],
Cell[39826, 1238, 155, 4, 70, "Text",
  CellTags->{"SA.2.6", "6.6"}],
Cell[39984, 1244, 556, 22, 70, "Text",
  CellTags->{"SA.2.6", "6.7"}],
Cell[40543, 1268, 212, 10, 70, "Text",
  CellTags->{"SA.2.6", "6.8"}],
Cell[40758, 1280, 1100, 44, 70, "Text",
  CellTags->{"SA.2.6", "6.9"}],
Cell[41861, 1326, 295, 8, 70, "Text",
  CellTags->{"SA.2.6", "6.10"}],
Cell[42159, 1336, 345, 12, 70, "Text",
  CellTags->{"SA.2.6", "6.11"}],
Cell[42507, 1350, 588, 21, 70, "Text",
  CellTags->{"SA.2.6", "6.12"}],
Cell[43098, 1373, 4139, 123, 70, "DefinitionBox",
  CellTags->"SA.2.6"],
Cell[47240, 1498, 71, 1, 70, "Caption",
  CellTags->"SA.2.6"],
Cell[47314, 1501, 208, 5, 70, "Text",
  CellTags->{"SA.2.6", "6.13"}],
Cell[47525, 1508, 810, 35, 70, "Text",
  CellTags->{"SA.2.6", "6.14"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[48372, 1548, 79, 1, 70, "Subsection",
  CellTags->{"SA.2.7", "7.1"}],
Cell[48454, 1551, 663, 16, 70, "Text",
  CellTags->{"SA.2.7", "7.2"}],
Cell[49120, 1569, 733, 24, 70, "Text",
  CellTags->{"SA.2.7", "7.3"}],
Cell[49856, 1595, 2036, 58, 70, "DefinitionBox",
  CellTags->"SA.2.7"],
Cell[51895, 1655, 93, 1, 70, "Caption",
  CellTags->"SA.2.7"],
Cell[51991, 1658, 32989, 907, 70, "PrecedenceTable",
  CellTags->"SA.2.7"],
Cell[84983, 2567, 117, 4, 70, "Caption",
  CellTags->"SA.2.7"],
Cell[85103, 2573, 37408, 1063, 70, "PrecedenceTable",
  CellTags->"SA.2.7"],
Cell[122514, 3638, 118, 4, 70, "Caption",
  CellTags->"SA.2.7"],
Cell[122635, 3644, 51695, 1456, 70, "PrecedenceTable",
  CellTags->"SA.2.7"],
Cell[174333, 5102, 120, 4, 70, "Caption",
  CellTags->"SA.2.7"],
Cell[174456, 5108, 44460, 1266, 70, "PrecedenceTable",
  CellTags->"SA.2.7"],
Cell[218919, 6376, 119, 4, 70, "Caption",
  CellTags->"SA.2.7"],
Cell[219041, 6382, 43458, 1220, 70, "PrecedenceTable",
  CellTags->"SA.2.7"],
Cell[262502, 7604, 119, 4, 70, "Caption",
  CellTags->"SA.2.7"],
Cell[262624, 7610, 43631, 1258, 70, "PrecedenceTable",
  CellTags->"SA.2.7"],
Cell[306258, 8870, 118, 4, 70, "Caption",
  CellTags->"SA.2.7"],
Cell[306379, 8876, 7684, 256, 70, "DefinitionBox",
  CellTags->"SA.2.7"],
Cell[314066, 9134, 100, 1, 70, "Caption",
  CellTags->"SA.2.7"],

Cell[CellGroupData[{
Cell[314191, 9139, 74, 1, 70, "Subsubsection",
  CellTags->{"SA.2.7", "7.4"}],
Cell[314268, 9142, 614, 18, 70, "Text",
  CellTags->{"SA.2.7", "7.5"}],
Cell[314885, 9162, 307, 11, 70, "Text",
  CellTags->{"SA.2.7", "7.6"}],
Cell[315195, 9175, 265, 8, 70, "Text",
  CellTags->{"SA.2.7", "7.7"}],
Cell[315463, 9185, 5217, 124, 70, "DoubleBox",
  CellTags->"SA.2.7"],
Cell[320683, 9311, 114, 4, 70, "Caption",
  CellTags->"SA.2.7"],
Cell[320800, 9317, 8549, 203, 70, "DoubleBox",
  CellTags->"SA.2.7"],
Cell[329352, 9522, 121, 4, 70, "Caption",
  CellTags->"SA.2.7"]
}, Open  ]],

Cell[CellGroupData[{
Cell[329510, 9531, 98, 1, 70, "Subsubsection",
  CellTags->{"SA.2.7", "7.8"}],
Cell[329611, 9534, 1910, 61, 70, "Text",
  CellTags->{"SA.2.7", "7.9"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[331558, 9600, 80, 1, 70, "Subsubsection",
  CellTags->{"SA.2.7", "7.10"}],
Cell[331641, 9603, 868, 29, 70, "Text",
  CellTags->{"SA.2.7", "7.11"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[332546, 9637, 92, 1, 70, "Subsubsection",
  CellTags->{"SA.2.7", "7.12"}],
Cell[332641, 9640, 1286, 40, 70, "Text",
  CellTags->{"SA.2.7", "7.13"}],
Cell[333930, 9682, 327, 11, 70, "Text",
  CellTags->{"SA.2.7", "7.14"}],
Cell[334260, 9695, 271, 8, 70, "Text",
  CellTags->{"SA.2.7", "7.15"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[334568, 9708, 82, 1, 70, "Subsubsection",
  CellTags->{"SA.2.7", "7.16"}],
Cell[334653, 9711, 356, 9, 70, "Text",
  CellTags->{"SA.2.7", "7.17"}],
Cell[335012, 9722, 2617, 82, 70, "FramedBox",
  CellTags->"SA.2.7"],
Cell[337632, 9806, 79, 1, 70, "Caption",
  CellTags->"SA.2.7"],
Cell[337714, 9809, 360, 13, 70, "Text",
  CellTags->{"SA.2.7", "7.18"}],
Cell[338077, 9824, 366, 12, 70, "Text",
  CellTags->{"SA.2.7", "7.19"}],
Cell[338446, 9838, 397, 7, 70, "Text",
  CellTags->{"SA.2.7", "7.20"}],
Cell[338846, 9847, 1161, 39, 70, "FramedBox",
  CellTags->"SA.2.7"],
Cell[340010, 9888, 73, 1, 70, "Caption",
  CellTags->"SA.2.7"]
}, Open  ]],

Cell[CellGroupData[{
Cell[340120, 9894, 72, 1, 70, "Subsubsection",
  CellTags->{"SA.2.7", "7.21"}],
Cell[340195, 9897, 355, 11, 70, "Text",
  CellTags->{"SA.2.7", "7.22"}],
Cell[340553, 9910, 433, 16, 70, "Text",
  CellTags->{"SA.2.7", "7.23"}],
Cell[340989, 9928, 218, 7, 70, "Text",
  CellTags->{"SA.2.7", "7.24"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[341244, 9940, 75, 1, 70, "Subsubsection",
  CellTags->{"SA.2.7", "7.25"}],
Cell[341322, 9943, 1337, 37, 70, "FramedBox",
  CellTags->"SA.2.7"],
Cell[342662, 9982, 112, 4, 70, "Caption",
  CellTags->"SA.2.7"]
}, Open  ]],

Cell[CellGroupData[{
Cell[342811, 9991, 77, 1, 70, "Subsubsection",
  CellTags->{"SA.2.7", "7.26"}],
Cell[342891, 9994, 1035, 50, 70, "Text",
  CellTags->{"SA.2.7", "7.27"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[343963, 10049, 67, 1, 70, "Subsubsection",
  CellTags->{"SA.2.7", "7.28"}],
Cell[344033, 10052, 1090, 42, 70, "Text",
  CellTags->{"SA.2.7", "7.29"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[345172, 10100, 102, 3, 70, "Subsection",
  CellTags->{"SA.2.8", "8.1"}],
Cell[345277, 10105, 17037, 374, 70, "DoubleBox",
  CellTags->"SA.2.8"],
Cell[362317, 10481, 127, 4, 70, "Caption",
  CellTags->"SA.2.8"],
Cell[362447, 10487, 688, 26, 70, "Text",
  CellTags->{"SA.2.8", "8.2"}],
Cell[363138, 10515, 1067, 43, 70, "Text",
  CellTags->{"SA.2.8", "8.3"}],
Cell[364208, 10560, 9538, 222, 70, "DoubleBox",
  CellTags->"SA.2.8"],
Cell[373749, 10784, 130, 4, 70, "Caption",
  CellTags->"SA.2.8"],
Cell[373882, 10790, 778, 27, 70, "Text",
  CellTags->{"SA.2.8", "8.4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[374697, 10822, 73, 1, 70, "Subsection",
  CellTags->{"SA.2.9", "9.1"}],
Cell[374773, 10825, 878, 23, 70, "FramedBox",
  CellTags->"SA.2.9"],
Cell[375654, 10850, 62, 1, 70, "Caption",
  CellTags->"SA.2.9"],

Cell[CellGroupData[{
Cell[375741, 10855, 68, 1, 70, "Subsubsection",
  CellTags->{"SA.2.9", "9.2"}],
Cell[375812, 10858, 5431, 134, 70, "DefinitionBox",
  CellTags->"SA.2.9"],
Cell[381246, 10994, 64, 1, 70, "Caption",
  CellTags->"SA.2.9"],
Cell[381313, 10997, 216, 5, 70, "Text",
  CellTags->{"SA.2.9", "9.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[381566, 11007, 83, 1, 70, "Subsubsection",
  CellTags->{"SA.2.9", "9.4"}],
Cell[381652, 11010, 327, 8, 70, "Text",
  CellTags->{"SA.2.9", "9.5"}],
Cell[381982, 11020, 399, 14, 70, "Text",
  CellTags->{"SA.2.9", "9.6"}],
Cell[382384, 11036, 1052, 32, 70, "FramedBox",
  CellTags->"SA.2.9"],
Cell[383439, 11070, 90, 1, 70, "Caption",
  CellTags->"SA.2.9"],
Cell[383532, 11073, 322, 9, 70, "Text",
  CellTags->{"SA.2.9", "9.7"}],
Cell[383857, 11084, 206, 5, 70, "Text",
  CellTags->{"SA.2.9", "9.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[384100, 11094, 82, 1, 70, "Subsubsection",
  CellTags->{"SA.2.9", "9.9"}],
Cell[384185, 11097, 763, 24, 70, "DefinitionBox",
  CellTags->"SA.2.9"],
Cell[384951, 11123, 78, 1, 70, "Caption",
  CellTags->"SA.2.9"],
Cell[385032, 11126, 791, 30, 70, "Text",
  CellTags->{"SA.2.9", "9.10"}],
Cell[385826, 11158, 400, 17, 70, "Text",
  CellTags->{"SA.2.9", "9.11"}],
Cell[386229, 11177, 12362, 354, 70, "DefinitionBox",
  CellTags->"SA.2.9"],
Cell[398594, 11533, 104, 4, 70, "Caption",
  CellTags->"SA.2.9"],
Cell[398701, 11539, 594, 17, 70, "Text",
  CellTags->{"SA.2.9", "9.12"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[399344, 11562, 93, 1, 70, "Subsection",
  CellTags->{"SA.2.10", "10.1"}],
Cell[399440, 11565, 191, 5, 40, "Text",
  CellTags->{"SA.2.10", "10.2"}],
Cell[399634, 11572, 333, 7, 70, "Text",
  CellTags->{"SA.2.10", "10.3"}],
Cell[399970, 11581, 361, 9, 56, "Text",
  CellTags->{"SA.2.10", "10.4"}],
Cell[400334, 11592, 277, 6, 56, "Text",
  CellTags->{"SA.2.10", "10.5"}],
Cell[400614, 11600, 550, 14, 72, "Text",
  CellTags->{"SA.2.10", "10.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[401201, 11619, 75, 1, 38, "Subsection",
  CellTags->{"SA.2.11", "11.1"}],
Cell[401279, 11622, 1531, 44, 130, "DefinitionBox",
  CellTags->"SA.2.11"],
Cell[402813, 11668, 63, 1, 16, "Caption",
  CellTags->"SA.2.11"],
Cell[402879, 11671, 281, 6, 56, "Text",
  CellTags->{"SA.2.11", "11.2"}],
Cell[403163, 11679, 242, 8, 40, "Text",
  CellTags->{"SA.2.11", "11.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[403442, 11692, 77, 1, 38, "Subsection",
  CellTags->{"SA.2.12", "12.1"}],
Cell[403522, 11695, 236, 6, 40, "Text",
  CellTags->{"SA.2.12", "12.2"}],
Cell[403761, 11703, 1271, 49, 134, "Notes",
  CellTags->{"SA.2.12", "12.3"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

