(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     40426,       1347]*)
(*NotebookOutlinePosition[     52132,       1716]*)
(*  CellTagsIndexPosition[     50539,       1649]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.3 ", "HeadingNumber"],
  "Some General Notations and Conventions"
}], "Section",
  CellTags->{"SA.3.0", "0.1"}],

Cell[CellGroupData[{

Cell["A.3.1 Function Names", "Subsection",
  CellTags->{"SA.3.1", "1.1"}],

Cell["\<\
The names of built\[Hyphen]in functions follow some general \
guidelines.    \
\>", "Text",
  CellTags->{"SA.3.1", "1.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The name consists of complete English words, or \
standard mathematical abbreviations. American spelling is used.  \n\
\[FilledSmallSquare] The first letter of each word is capitalized.  \n\
\[FilledSmallSquare] Functions whose names end with ",
  StyleBox["Q", "MR"],
  " usually \[OpenCurlyDoubleQuote]ask a question\[CloseCurlyDoubleQuote], \
and return either ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  ".  \n\[FilledSmallSquare] Mathematical functions that are named after \
people usually have names in ",
  StyleBox["Mathematica", "TI"],
  " of the form ",
  StyleBox["PersonSymbol", "TI"],
  ".    "
}], "Notes",
  CellTags->{"SA.3.1", "1.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.3.2 Function Arguments", "Subsection",
  CellTags->{"SA.3.2", "2.1"}],

Cell["\<\
The main expression or object on which a built\[Hyphen]in function \
acts is usually given as the first argument to the function. Subsidiary \
parameters appear as subsequent arguments.  \
\>", "Text",
  CellTags->{"SA.3.2", "2.2"}],

Cell["The following are exceptions: ", "Text",
  CellTags->{"SA.3.2", "2.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] In functions like ",
  StyleBox["Map", "MR"],
  " and ",
  StyleBox["Apply", "MR"],
  ", the function to apply comes before the expression it is to be applied \
to. \n\[FilledSmallSquare] In scoping constructs such as ",
  StyleBox["Module", "MR"],
  " and ",
  StyleBox["Function", "MR"],
  ", local variables and parameter names come before bodies.  \n\
\[FilledSmallSquare] In functions like ",
  StyleBox["Write", "MR"],
  " and ",
  StyleBox["Display", "MR"],
  ", the name of the file is given before the objects to be written to it.  "
}], "Notes",
  CellTags->{"SA.3.2", "2.4"}],

Cell["\<\
For mathematical functions, arguments that are written as \
subscripts in standard mathematical notation are given before those that are \
written as superscripts. \
\>", "Text",
  CellTags->{"SA.3.2", "2.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.3.3 Options", "Subsection",
  CellTags->{"SA.3.3", "3.1"}],

Cell[TextData[{
  "Some built\[Hyphen]in functions can take ",
  StyleBox["options", "TI"],
  ". Each option has a name, represented as a symbol, or in some cases a \
string. Options are set by giving rules of the form ",
  StyleBox["name", "TI"],
  StyleBox["->", "MR"],
  StyleBox["value", "TI"],
  " or ",
  StyleBox["name", "TI"],
  StyleBox[":>", "MR"],
  StyleBox["value", "TI"],
  ". Such rules must appear after all the other arguments in a function. \
Rules for different options can be given in any order. If you do not \
explicitly give a rule for a particular option, a default setting for that \
option is used. "
}], "Text",
  CellTags->{"SA.3.3", "3.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the default rules for all options associated with ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["give the options set in a particular expression "]},
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["name", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the setting for the option ",
              StyleBox["name", "TI"],
              " in an expression "
            }]]},
          {Cell[TextData[{
              StyleBox["AbsoluteOptions[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["name", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the absolute setting for ",
              StyleBox["name", "TI"],
              ", even if its actual setting is ",
              StyleBox["Automatic", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SetOptions[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["name", "TI"],
              StyleBox["->", "MR"],
              StyleBox["value", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "set default rules for options associated with ",
              StyleBox["f", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.3.3"],

Cell["Operations on options. ", "Caption",
  CellTags->"SA.3.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.3.4 Part Numbering", "Subsection",
  CellTags->{"SA.3.4", "4.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "element ",
              StyleBox["n", "TI"],
              " (starting at ",
              StyleBox["1", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["-", "MR"],
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "element ",
              StyleBox["n", "TI"],
              " from the end "
            }]]},
          {Cell[TextData[{
              StyleBox["0", "MR"],
              " "
            }]], Cell["head "]},
          {Cell[TextData[{
              StyleBox["All", "MR"],
              " "
            }]], Cell["all elements "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.3.4"],

Cell["Numbering of parts. ", "Caption",
  CellTags->"SA.3.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.3.5 Sequence Specifications", "Subsection",
  CellTags->{"SA.3.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["All", "MR"],
              " "
            }]], Cell["all elements "]},
          {Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell["no elements "]},
          {Cell[TextData[{
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "elements ",
              StyleBox["1", "MR"],
              " through ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["-", "MR"],
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "last ",
              StyleBox["n", "TI"],
              " elements "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "element ",
              StyleBox["n", "TI"],
              " only "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "elements ",
              StyleBox["m", "TI"],
              " through ",
              StyleBox["n", "TI"],
              " (inclusive) "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["s", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "elements ",
              StyleBox["m", "TI"],
              " through ",
              StyleBox["n", "TI"],
              " in steps of ",
              StyleBox["s", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.3.5"],

Cell["Specifications for sequences of parts. ", "Caption",
  CellTags->"SA.3.5"],

Cell[TextData[{
  "The sequence specification ",
  StyleBox["{", "MR"],
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["s", "TI"],
  StyleBox["}", "MR"],
  " corresponds to elements ",
  StyleBox["m", "TI"],
  ", ",
  StyleBox["m", "TI"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["s", "TI"],
  ", ",
  StyleBox["m", "TI"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2", "MR"],
  StyleBox["s", "TI"],
  ", \[Ellipsis]",
  " ",
  ", up to the largest element not greater than ",
  StyleBox["n", "TI"],
  ". "
}], "Text",
  CellTags->{"SA.3.5", "5.2"}],

Cell[TextData[{
  "Sequence specifications are used in the functions ",
  StyleBox["Drop", "MR"],
  ", ",
  StyleBox["Ordering", "MR"],
  ", ",
  StyleBox["StringDrop", "MR"],
  ", ",
  StyleBox["StringTake", "MR"],
  ", ",
  StyleBox["Take", "MR"],
  " and ",
  StyleBox["Thread", "MR"],
  ".   "
}], "Text",
  CellTags->{"SA.3.5", "5.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.3.6 Level Specifications", "Subsection",
  CellTags->{"SA.3.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "levels ",
              StyleBox["1", "MR"],
              " through ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Infinity", "MR"],
              " "
            }]], Cell[TextData[{
              "levels ",
              StyleBox["1", "MR"],
              " through ",
              StyleBox["Infinity", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "level ",
              StyleBox["n", "TI"],
              " only "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "levels ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " through ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Heads", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True", "MR"],
              " "
            }]], Cell["include heads of expressions "]},
          {Cell[TextData[{
              StyleBox["Heads", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["False", "MR"],
              " "
            }]], Cell["do not include heads of expressions "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.3.6"],

Cell["Level specifications. ", "Caption",
  CellTags->"SA.3.6"],

Cell[TextData[{
  "The level in an expression corresponding to a non\[Hyphen]negative integer \
",
  StyleBox["n", "TI"],
  " is defined to consist of parts specified by ",
  StyleBox["n", "TI"],
  " indices. A negative level number ",
  StyleBox["-", "MR"],
  StyleBox["n", "TI"],
  " represents all parts of an expression that have depth ",
  StyleBox["n", "TI"],
  ". The depth of an expression, ",
  StyleBox["Depth[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  ", is the maximum number of indices needed to specify any part, plus one. \
Levels ",
  StyleBox["do not", "TI"],
  " include heads of expressions, except with the option setting ",
  StyleBox["Heads", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ". Level ",
  StyleBox["0", "MR"],
  " is the whole expression. Level ",
  StyleBox["-1", "MR"],
  " contains all symbols and other objects that have no subparts. "
}], "Text",
  CellTags->{"SA.3.6", "6.2"}],

Cell[TextData[{
  "Ranges of levels specified by ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["}", "MR"],
  " contain all parts that are neither above level ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  ", nor below level ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " in the tree. The ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " need not have the same sign. Thus, for example, ",
  StyleBox["{2,", "MR"],
  " ",
  StyleBox["-2}", "MR"],
  " specifies subexpressions which occur anywhere below the top level, but \
above the leaves, of the expression tree. "
}], "Text",
  CellTags->{"SA.3.6", "6.3"}],

Cell[TextData[{
  "Level specifications are used by functions such as ",
  StyleBox["Apply", "MR"],
  ", ",
  StyleBox["Cases", "MR"],
  ", ",
  StyleBox["Count", "MR"],
  ", ",
  StyleBox["FreeQ", "MR"],
  ", ",
  StyleBox["Level", "MR"],
  ", ",
  StyleBox["Map", "MR"],
  ", ",
  StyleBox["MapIndexed", "MR"],
  ", ",
  StyleBox["Position", "MR"],
  ", ",
  StyleBox["Replace", "MR"],
  " and ",
  StyleBox["Scan", "MR"],
  ". Note, however, that the default level specifications are not the same \
for all of these functions.       "
}], "Text",
  CellTags->{"SA.3.6", "6.4"}],

Cell["\<\
Functions with level specifications visit different subexpressions \
in an order that corresponds to depth\[Hyphen]first traversal of the \
expression tree, with leaves visited before roots. The subexpressions visited \
have part specifications which occur in an order which is lexicographic, \
except that longer sequences appear before shorter ones.   \
\>", "Text",
  CellTags->{"SA.3.6", "6.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.3.7 Iterators", "Subsection",
  CellTags->{"SA.3.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "iterate ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " times "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["i", "TI"],
              " goes from ",
              StyleBox["1", "MR"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " in steps of ",
              StyleBox["1", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["i", "TI"],
              " goes from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " in steps of ",
              StyleBox["1", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["di", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["i", "TI"],
              " goes from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " in steps of ",
              StyleBox["di", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]], Cell[TextData[{
              StyleBox["i", "TI"],
              " goes from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", and for each value of ",
              StyleBox["i", "TI"],
              ", ",
              StyleBox["j", "TI"],
              " goes from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", etc. "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.3.7"],

Cell["Iterator notation. ", "Caption",
  CellTags->"SA.3.7"],

Cell[TextData[{
  "Iterators are used in such functions as ",
  StyleBox["Sum", "MR"],
  ", ",
  StyleBox["Table", "MR"],
  ", ",
  StyleBox["Do", "MR"],
  " and ",
  StyleBox["Range", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.3.7", "7.2"}],

Cell[TextData[{
  "The iteration parameters ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " and ",
  StyleBox["di", "TI"],
  " do not need to be integers. The variable ",
  StyleBox["i", "TI"],
  " is given a sequence of values starting at ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", and increasing in steps of ",
  StyleBox["di", "TI"],
  ", stopping when the next value of ",
  StyleBox["i", "TI"],
  " would be greater than ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". The iteration parameters can be arbitrary symbolic expressions, so long \
as ",
  StyleBox["(", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["-", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[")/", "MR"],
  StyleBox["di", "TI"],
  " is a number.  "
}], "Text",
  CellTags->{"SA.3.7", "7.3"}],

Cell["\<\
When several iteration variables are used, the limits for the later \
ones can depend on the values of earlier ones. \
\>", "Text",
  CellTags->{"SA.3.7", "7.4"}],

Cell[TextData[{
  "The variable ",
  StyleBox["i", "TI"],
  " can be any symbolic expression; it need not be a single symbol. The value \
of ",
  StyleBox["i", "TI"],
  " is automatically set up to be local to the iteration function. This is \
effectively done by wrapping a ",
  StyleBox["Block", "MR"],
  " construct containing ",
  StyleBox["i", "TI"],
  " around the iteration function.  "
}], "Text",
  CellTags->{"SA.3.7", "7.5"}],

Cell[TextData[{
  "The procedure for evaluating iteration functions is described in Section\
\[NonBreakingSpace]",
  ButtonBox["A.4.2",
    ButtonData:>{"A.4.2", "2.7"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"SA.3.7", "7.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.3.8 Scoping Constructs", "Subsection",
  CellTags->{"SA.3.8", "8.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Function[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["local parameters "]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " \[ThinSpace]and \[ThinSpace]",
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":>", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell["local pattern names "]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " \[ThinSpace]and \[ThinSpace]",
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell["local pattern names "]},
          {Cell[TextData[{
              StyleBox["With[{", "MR"],
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["local constants "]},
          {Cell[TextData[{
              StyleBox["Module[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["local variables "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.3.8"],

Cell[TextData[{
  "Scoping constructs in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"SA.3.8"],

Cell["\<\
Scoping constructs allow the names of certain symbols to be local. \
\
\>", "Text",
  CellTags->{"SA.3.8", "8.2"}],

Cell["\<\
When nested scoping constructs are evaluated, new symbols are \
automatically generated in the inner scoping constructs so as to avoid name \
conflicts with symbols in outer scoping constructs. \
\>", "Text",
  CellTags->{"SA.3.8", "8.3"}],

Cell[TextData[{
  "In general, symbols with names of the form ",
  StyleBox["xxx", "TI"],
  " are renamed ",
  StyleBox["xxx", "TI"],
  StyleBox["$", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.3.8", "8.4"}],

Cell[TextData[{
  "When a transformation rule or definition is used, ",
  StyleBox["ReplaceAll", "MR"],
  " (",
  StyleBox["/.", "MR"],
  ") is effectively used to replace the pattern names that appear on the \
right\[Hyphen]hand side. Nevertheless, new symbols are generated when \
necessary to represent other objects that appear in scoping constructs on the \
right\[Hyphen]hand side. "
}], "Text",
  CellTags->{"SA.3.8", "8.5"}],

Cell[TextData[{
  "Each time it is evaluated, ",
  StyleBox["Module", "MR"],
  " generates symbols with unique names of the form ",
  StyleBox["xxx", "TI"],
  StyleBox["$", "MR"],
  StyleBox["nnn", "TI"],
  " as replacements for all local variables that appear in its body. "
}], "Text",
  CellTags->{"SA.3.8", "8.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.3.9 Ordering of Expressions", "Subsection",
  CellTags->{"SA.3.9", "9.1"}],

Cell[TextData[{
  "The canonical ordering of expressions used automatically with the \
attribute ",
  StyleBox["Orderless", "MR"],
  " and in functions such as ",
  StyleBox["Sort", "MR"],
  " satisfies the following rules: "
}], "Text",
  CellTags->{"SA.3.9", "9.2"}],

Cell["\<\
\[FilledSmallSquare] Integers, rational and approximate real \
numbers are ordered by their numerical values.  
\[FilledSmallSquare] Complex numbers are ordered by their real parts, and in \
the event of a tie, by the absolute values of their imaginary parts.  
\[FilledSmallSquare] Symbols are ordered according to their names, and in the \
event of a tie, by their contexts.  
\[FilledSmallSquare] Expressions are usually ordered by comparing their parts \
in a depth\[Hyphen]first manner. Shorter expressions come first.  
\[FilledSmallSquare] Powers and products are treated specially, and are \
ordered to correspond to terms in a polynomial.  
\[FilledSmallSquare] Strings are ordered as they would be in a dictionary, \
with the upper\[Hyphen]case versions of letters coming after \
lower\[Hyphen]case ones. Ordinary letters appear first, followed in order by \
script, Gothic, double\[Hyphen]struck, Greek and Hebrew. Mathematical \
operators appear in order of decreasing precedence.  \
\>", "Notes",
  CellTags->{"SA.3.9", "9.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.3.10 Mathematical Functions", "Subsection",
  CellTags->{"SA.3.10", "10.1"}],

Cell[TextData[{
  "The mathematical functions such as ",
  StyleBox["Log[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["BesselJ[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " that are built into ",
  StyleBox["Mathematica", "TI"],
  " have a number of features in common.  "
}], "Text",
  CellTags->{"SA.3.10", "10.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] They carry the attribute ",
  StyleBox["Listable", "MR"],
  ", so that they are automatically \[OpenCurlyDoubleQuote]threaded\
\[CloseCurlyDoubleQuote] over any lists that appear as arguments.   \n\
\[FilledSmallSquare] They carry the attribute ",
  StyleBox["NumericFunction", "MR"],
  ", so that they are assumed to give numerical values when their arguments \
are numerical.   \n\[FilledSmallSquare] They give exact results in terms of \
integers, rational numbers and algebraic expressions in special cases.  \n\
\[FilledSmallSquare] Except for functions whose arguments are always \
integers, mathematical functions in ",
  StyleBox["Mathematica", "TI"],
  " can be evaluated to any numerical precision, with any complex numbers as \
arguments. If a function is undefined for a particular set of arguments, it \
is returned in symbolic form in this case.   "
}], "Notes",
  CellTags->{"SA.3.10", "10.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] Numerical evaluation leads to results of a precision \
no higher than can be justified on the basis of the precision of the \
arguments. Thus ",
  StyleBox["N[Gamma[27/10],", "MR"],
  " ",
  StyleBox["100]", "MR"],
  " yields a high\[Hyphen]precision result, but ",
  StyleBox["N[Gamma[2.7],", "MR"],
  " ",
  StyleBox["100]", "MR"],
  " cannot.  \n\[FilledSmallSquare] When possible, symbolic derivatives, \
integrals and series expansions of built\[Hyphen]in mathematical functions \
are evaluated in terms of other built\[Hyphen]in functions.   "
}], "Notes",
  CellTags->{"SA.3.10", "10.4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.3.11 Mathematical Constants", "Subsection",
  CellTags->{"SA.3.11", "11.1"}],

Cell[TextData[{
  "Mathematical constants such as ",
  StyleBox["E", "MR"],
  " and ",
  StyleBox["Pi", "MR"],
  " that are built into ",
  StyleBox["Mathematica", "TI"],
  " have the following properties: "
}], "Text",
  CellTags->{"SA.3.11", "11.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] They do not have values as such.  \n\
\[FilledSmallSquare] They have numerical values that can be found to any \
precision.  \n\[FilledSmallSquare] They are treated as numeric quantities in \
",
  StyleBox["NumericQ", "MR"],
  " and elsewhere.   \n\[FilledSmallSquare] They carry the attribute ",
  StyleBox["Constant", "MR"],
  ", and so are treated as constants in derivatives.   "
}], "Notes",
  CellTags->{"SA.3.11", "11.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.3.12 Protection", "Subsection",
  CellTags->{"SA.3.12", "12.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to make assignments that override the standard operation and \
meaning of built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " objects. "
}], "Text",
  CellTags->{"SA.3.12", "12.2"}],

Cell[TextData[{
  "To make it difficult to make such assignments by mistake, most built\
\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " objects have the attribute ",
  StyleBox["Protected", "MR"],
  ". If you want to make an assignment for a built\[Hyphen]in object, you \
must first remove this attribute. You can do this by calling the function ",
  StyleBox["Unprotect", "MR"],
  ".   "
}], "Text",
  CellTags->{"SA.3.12", "12.3"}],

Cell[TextData[{
  "There are a few fundamental ",
  StyleBox["Mathematica", "TI"],
  " objects to which you absolutely cannot assign your own values. These \
objects carry the attribute ",
  StyleBox["Locked", "MR"],
  ", as well as ",
  StyleBox["Protected", "MR"],
  ". The ",
  StyleBox["Locked", "MR"],
  " attribute prevents you from changing any of the attributes, and thus from \
removing the ",
  StyleBox["Protected", "MR"],
  " attribute.  "
}], "Text",
  CellTags->{"SA.3.12", "12.4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.3.13 Abbreviated String Patterns", "Subsection",
  CellTags->{"SA.3.13", "13.1"}],

Cell[TextData[{
  "Functions such as ",
  StyleBox["StringMatchQ", "MR"],
  ", ",
  StyleBox["Names", "MR"],
  " and ",
  StyleBox["Remove", "MR"],
  " allow you to give ",
  StyleBox["abbreviated string patterns", "TI"],
  ", as well as full string patterns specified by ",
  StyleBox["StringExpression", "MR"],
  ". Abbreviated string patterns can contain certain metacharacters, which \
can stand for sequences of ordinary characters. "
}], "Text",
  CellTags->{"SA.3.13", "13.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["*", "MR"],
              " "
            }]], Cell["zero or more characters "]},
          {Cell[TextData[{
              StyleBox["@", "MR"],
              " "
            }]], 
            Cell["\<\
one or more characters excluding upper\[Hyphen]case \
letters \
\>"]},
          {Cell[TextData[{
              "\[Backslash]\[Backslash]",
              StyleBox["*", "MR"],
              "  etc. "
            }]], Cell[TextData[{
              "literal ",
              StyleBox["*", "MR"],
              ", etc. "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.3.13"],

Cell["Metacharacters used in abbreviated string patterns. ", "Caption",
  CellTags->"SA.3.13"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.3.0"->{
    Cell[1776, 53, 141, 4, 91, "Section",
      CellTags->{"SA.3.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 141, 4, 91, "Section",
      CellTags->{"SA.3.0", "0.1"}]},
  "SA.3.1"->{
    Cell[1942, 61, 73, 1, 70, "Subsection",
      CellTags->{"SA.3.1", "1.1"}],
    Cell[2018, 64, 132, 4, 70, "Text",
      CellTags->{"SA.3.1", "1.2"}],
    Cell[2153, 70, 716, 18, 70, "Notes",
      CellTags->{"SA.3.1", "1.3"}]},
  "1.1"->{
    Cell[1942, 61, 73, 1, 70, "Subsection",
      CellTags->{"SA.3.1", "1.1"}]},
  "1.2"->{
    Cell[2018, 64, 132, 4, 70, "Text",
      CellTags->{"SA.3.1", "1.2"}]},
  "1.3"->{
    Cell[2153, 70, 716, 18, 70, "Notes",
      CellTags->{"SA.3.1", "1.3"}]},
  "SA.3.2"->{
    Cell[2906, 93, 77, 1, 70, "Subsection",
      CellTags->{"SA.3.2", "2.1"}],
    Cell[2986, 96, 242, 5, 70, "Text",
      CellTags->{"SA.3.2", "2.2"}],
    Cell[3231, 103, 77, 1, 70, "Text",
      CellTags->{"SA.3.2", "2.3"}],
    Cell[3311, 106, 626, 17, 70, "Notes",
      CellTags->{"SA.3.2", "2.4"}],
    Cell[3940, 125, 219, 5, 70, "Text",
      CellTags->{"SA.3.2", "2.5"}]},
  "2.1"->{
    Cell[2906, 93, 77, 1, 70, "Subsection",
      CellTags->{"SA.3.2", "2.1"}]},
  "2.2"->{
    Cell[2986, 96, 242, 5, 70, "Text",
      CellTags->{"SA.3.2", "2.2"}]},
  "2.3"->{
    Cell[3231, 103, 77, 1, 70, "Text",
      CellTags->{"SA.3.2", "2.3"}]},
  "2.4"->{
    Cell[3311, 106, 626, 17, 70, "Notes",
      CellTags->{"SA.3.2", "2.4"}]},
  "2.5"->{
    Cell[3940, 125, 219, 5, 70, "Text",
      CellTags->{"SA.3.2", "2.5"}]},
  "SA.3.3"->{
    Cell[4196, 135, 66, 1, 70, "Subsection",
      CellTags->{"SA.3.3", "3.1"}],
    Cell[4265, 138, 669, 17, 70, "Text",
      CellTags->{"SA.3.3", "3.2"}],
    Cell[4937, 157, 2305, 69, 70, "DefinitionBox",
      CellTags->"SA.3.3"],
    Cell[7245, 228, 64, 1, 70, "Caption",
      CellTags->"SA.3.3"]},
  "3.1"->{
    Cell[4196, 135, 66, 1, 70, "Subsection",
      CellTags->{"SA.3.3", "3.1"}]},
  "3.2"->{
    Cell[4265, 138, 669, 17, 70, "Text",
      CellTags->{"SA.3.3", "3.2"}]},
  "SA.3.4"->{
    Cell[7346, 234, 73, 1, 70, "Subsection",
      CellTags->{"SA.3.4", "4.1"}],
    Cell[7422, 237, 976, 33, 70, "DefinitionBox",
      CellTags->"SA.3.4"],
    Cell[8401, 272, 61, 1, 70, "Caption",
      CellTags->"SA.3.4"]},
  "4.1"->{
    Cell[7346, 234, 73, 1, 70, "Subsection",
      CellTags->{"SA.3.4", "4.1"}]},
  "SA.3.5"->{
    Cell[8499, 278, 82, 1, 70, "Subsection",
      CellTags->{"SA.3.5", "5.1"}],
    Cell[8584, 281, 2290, 78, 70, "DefinitionBox",
      CellTags->"SA.3.5"],
    Cell[10877, 361, 80, 1, 70, "Caption",
      CellTags->"SA.3.5"],
    Cell[10960, 364, 632, 32, 70, "Text",
      CellTags->{"SA.3.5", "5.2"}],
    Cell[11595, 398, 340, 15, 70, "Text",
      CellTags->{"SA.3.5", "5.3"}]},
  "5.1"->{
    Cell[8499, 278, 82, 1, 70, "Subsection",
      CellTags->{"SA.3.5", "5.1"}]},
  "5.2"->{
    Cell[10960, 364, 632, 32, 70, "Text",
      CellTags->{"SA.3.5", "5.2"}]},
  "5.3"->{
    Cell[11595, 398, 340, 15, 70, "Text",
      CellTags->{"SA.3.5", "5.3"}]},
  "SA.3.6"->{
    Cell[11972, 418, 79, 1, 70, "Subsection",
      CellTags->{"SA.3.6", "6.1"}],
    Cell[12054, 421, 2643, 83, 70, "DefinitionBox",
      CellTags->"SA.3.6"],
    Cell[14700, 506, 63, 1, 70, "Caption",
      CellTags->"SA.3.6"],
    Cell[14766, 509, 963, 30, 70, "Text",
      CellTags->{"SA.3.6", "6.2"}],
    Cell[15732, 541, 1239, 43, 70, "Text",
      CellTags->{"SA.3.6", "6.3"}],
    Cell[16974, 586, 580, 24, 70, "Text",
      CellTags->{"SA.3.6", "6.4"}],
    Cell[17557, 612, 409, 7, 70, "Text",
      CellTags->{"SA.3.6", "6.5"}]},
  "6.1"->{
    Cell[11972, 418, 79, 1, 70, "Subsection",
      CellTags->{"SA.3.6", "6.1"}]},
  "6.2"->{
    Cell[14766, 509, 963, 30, 70, "Text",
      CellTags->{"SA.3.6", "6.2"}]},
  "6.3"->{
    Cell[15732, 541, 1239, 43, 70, "Text",
      CellTags->{"SA.3.6", "6.3"}]},
  "6.4"->{
    Cell[16974, 586, 580, 24, 70, "Text",
      CellTags->{"SA.3.6", "6.4"}]},
  "6.5"->{
    Cell[17557, 612, 409, 7, 70, "Text",
      CellTags->{"SA.3.6", "6.5"}]},
  "SA.3.7"->{
    Cell[18003, 624, 68, 1, 70, "Subsection",
      CellTags->{"SA.3.7", "7.1"}],
    Cell[18074, 627, 8112, 239, 70, "DefinitionBox",
      CellTags->"SA.3.7"],
    Cell[26189, 868, 60, 1, 70, "Caption",
      CellTags->"SA.3.7"],
    Cell[26252, 871, 241, 11, 70, "Text",
      CellTags->{"SA.3.7", "7.2"}],
    Cell[26496, 884, 1682, 63, 70, "Text",
      CellTags->{"SA.3.7", "7.3"}],
    Cell[28181, 949, 172, 4, 70, "Text",
      CellTags->{"SA.3.7", "7.4"}],
    Cell[28356, 955, 436, 13, 70, "Text",
      CellTags->{"SA.3.7", "7.5"}],
    Cell[28795, 970, 253, 8, 70, "Text",
      CellTags->{"SA.3.7", "7.6"}]},
  "7.1"->{
    Cell[18003, 624, 68, 1, 70, "Subsection",
      CellTags->{"SA.3.7", "7.1"}]},
  "7.2"->{
    Cell[26252, 871, 241, 11, 70, "Text",
      CellTags->{"SA.3.7", "7.2"}]},
  "7.3"->{
    Cell[26496, 884, 1682, 63, 70, "Text",
      CellTags->{"SA.3.7", "7.3"}]},
  "7.4"->{
    Cell[28181, 949, 172, 4, 70, "Text",
      CellTags->{"SA.3.7", "7.4"}]},
  "7.5"->{
    Cell[28356, 955, 436, 13, 70, "Text",
      CellTags->{"SA.3.7", "7.5"}]},
  "7.6"->{
    Cell[28795, 970, 253, 8, 70, "Text",
      CellTags->{"SA.3.7", "7.6"}]},
  "SA.3.8"->{
    Cell[29085, 983, 77, 1, 70, "Subsection",
      CellTags->{"SA.3.8", "8.1"}],
    Cell[29165, 986, 2536, 81, 70, "DefinitionBox",
      CellTags->"SA.3.8"],
    Cell[31704, 1069, 120, 5, 70, "Caption",
      CellTags->"SA.3.8"],
    Cell[31827, 1076, 124, 4, 70, "Text",
      CellTags->{"SA.3.8", "8.2"}],
    Cell[31954, 1082, 249, 5, 70, "Text",
      CellTags->{"SA.3.8", "8.3"}],
    Cell[32206, 1089, 206, 8, 70, "Text",
      CellTags->{"SA.3.8", "8.4"}],
    Cell[32415, 1099, 432, 10, 70, "Text",
      CellTags->{"SA.3.8", "8.5"}],
    Cell[32850, 1111, 318, 9, 70, "Text",
      CellTags->{"SA.3.8", "8.6"}]},
  "8.1"->{
    Cell[29085, 983, 77, 1, 70, "Subsection",
      CellTags->{"SA.3.8", "8.1"}]},
  "8.2"->{
    Cell[31827, 1076, 124, 4, 70, "Text",
      CellTags->{"SA.3.8", "8.2"}]},
  "8.3"->{
    Cell[31954, 1082, 249, 5, 70, "Text",
      CellTags->{"SA.3.8", "8.3"}]},
  "8.4"->{
    Cell[32206, 1089, 206, 8, 70, "Text",
      CellTags->{"SA.3.8", "8.4"}]},
  "8.5"->{
    Cell[32415, 1099, 432, 10, 70, "Text",
      CellTags->{"SA.3.8", "8.5"}]},
  "8.6"->{
    Cell[32850, 1111, 318, 9, 70, "Text",
      CellTags->{"SA.3.8", "8.6"}]},
  "SA.3.9"->{
    Cell[33205, 1125, 82, 1, 70, "Subsection",
      CellTags->{"SA.3.9", "9.1"}],
    Cell[33290, 1128, 268, 8, 70, "Text",
      CellTags->{"SA.3.9", "9.2"}],
    Cell[33561, 1138, 1050, 17, 70, "Notes",
      CellTags->{"SA.3.9", "9.3"}]},
  "9.1"->{
    Cell[33205, 1125, 82, 1, 70, "Subsection",
      CellTags->{"SA.3.9", "9.1"}]},
  "9.2"->{
    Cell[33290, 1128, 268, 8, 70, "Text",
      CellTags->{"SA.3.9", "9.2"}]},
  "9.3"->{
    Cell[33561, 1138, 1050, 17, 70, "Notes",
      CellTags->{"SA.3.9", "9.3"}]},
  "SA.3.10"->{
    Cell[34648, 1160, 84, 1, 70, "Subsection",
      CellTags->{"SA.3.10", "10.1"}],
    Cell[34735, 1163, 417, 16, 70, "Text",
      CellTags->{"SA.3.10", "10.2"}],
    Cell[35155, 1181, 949, 17, 70, "Notes",
      CellTags->{"SA.3.10", "10.3"}],
    Cell[36107, 1200, 635, 15, 94, "Notes",
      CellTags->{"SA.3.10", "10.4"}]},
  "10.1"->{
    Cell[34648, 1160, 84, 1, 70, "Subsection",
      CellTags->{"SA.3.10", "10.1"}]},
  "10.2"->{
    Cell[34735, 1163, 417, 16, 70, "Text",
      CellTags->{"SA.3.10", "10.2"}]},
  "10.3"->{
    Cell[35155, 1181, 949, 17, 70, "Notes",
      CellTags->{"SA.3.10", "10.3"}]},
  "10.4"->{
    Cell[36107, 1200, 635, 15, 94, "Notes",
      CellTags->{"SA.3.10", "10.4"}]},
  "SA.3.11"->{
    Cell[36779, 1220, 84, 1, 70, "Subsection",
      CellTags->{"SA.3.11", "11.1"}],
    Cell[36866, 1223, 252, 9, 40, "Text",
      CellTags->{"SA.3.11", "11.2"}],
    Cell[37121, 1234, 469, 10, 90, "Notes",
      CellTags->{"SA.3.11", "11.3"}]},
  "11.1"->{
    Cell[36779, 1220, 84, 1, 70, "Subsection",
      CellTags->{"SA.3.11", "11.1"}]},
  "11.2"->{
    Cell[36866, 1223, 252, 9, 40, "Text",
      CellTags->{"SA.3.11", "11.2"}]},
  "11.3"->{
    Cell[37121, 1234, 469, 10, 90, "Notes",
      CellTags->{"SA.3.11", "11.3"}]},
  "SA.3.12"->{
    Cell[37627, 1249, 72, 1, 38, "Subsection",
      CellTags->{"SA.3.12", "12.1"}],
    Cell[37702, 1252, 250, 7, 40, "Text",
      CellTags->{"SA.3.12", "12.2"}],
    Cell[37955, 1261, 439, 11, 72, "Text",
      CellTags->{"SA.3.12", "12.3"}],
    Cell[38397, 1274, 496, 15, 72, "Text",
      CellTags->{"SA.3.12", "12.4"}]},
  "12.1"->{
    Cell[37627, 1249, 72, 1, 38, "Subsection",
      CellTags->{"SA.3.12", "12.1"}]},
  "12.2"->{
    Cell[37702, 1252, 250, 7, 40, "Text",
      CellTags->{"SA.3.12", "12.2"}]},
  "12.3"->{
    Cell[37955, 1261, 439, 11, 72, "Text",
      CellTags->{"SA.3.12", "12.3"}]},
  "12.4"->{
    Cell[38397, 1274, 496, 15, 72, "Text",
      CellTags->{"SA.3.12", "12.4"}]},
  "SA.3.13"->{
    Cell[38930, 1294, 89, 1, 38, "Subsection",
      CellTags->{"SA.3.13", "13.1"}],
    Cell[39022, 1297, 484, 14, 72, "Text",
      CellTags->{"SA.3.13", "13.2"}],
    Cell[39509, 1313, 792, 27, 106, "DefinitionBox",
      CellTags->"SA.3.13"],
    Cell[40304, 1342, 94, 1, 16, "Caption",
      CellTags->"SA.3.13"]},
  "13.1"->{
    Cell[38930, 1294, 89, 1, 38, "Subsection",
      CellTags->{"SA.3.13", "13.1"}]},
  "13.2"->{
    Cell[39022, 1297, 484, 14, 72, "Text",
      CellTags->{"SA.3.13", "13.2"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.3.0", 41041, 1363},
  {"0.1", 41131, 1366},
  {"SA.3.1", 41224, 1369},
  {"1.1", 41468, 1376},
  {"1.2", 41560, 1379},
  {"1.3", 41647, 1382},
  {"SA.3.2", 41739, 1385},
  {"2.1", 42135, 1396},
  {"2.2", 42227, 1399},
  {"2.3", 42314, 1402},
  {"2.4", 42401, 1405},
  {"2.5", 42491, 1408},
  {"SA.3.3", 42582, 1411},
  {"3.1", 42899, 1420},
  {"3.2", 42992, 1423},
  {"SA.3.4", 43084, 1426},
  {"4.1", 43323, 1433},
  {"SA.3.5", 43419, 1436},
  {"5.1", 43816, 1447},
  {"5.2", 43909, 1450},
  {"5.3", 43999, 1453},
  {"SA.3.6", 44092, 1456},
  {"6.1", 44647, 1471},
  {"6.2", 44741, 1474},
  {"6.3", 44831, 1477},
  {"6.4", 44922, 1480},
  {"6.5", 45012, 1483},
  {"SA.3.7", 45104, 1486},
  {"7.1", 45737, 1503},
  {"7.2", 45831, 1506},
  {"7.3", 45921, 1509},
  {"7.4", 46012, 1512},
  {"7.5", 46101, 1515},
  {"7.6", 46191, 1518},
  {"SA.3.8", 46283, 1521},
  {"8.1", 46919, 1538},
  {"8.2", 47013, 1541},
  {"8.3", 47103, 1544},
  {"8.4", 47193, 1547},
  {"8.5", 47283, 1550},
  {"8.6", 47374, 1553},
  {"SA.3.9", 47467, 1556},
  {"9.1", 47721, 1563},
  {"9.2", 47816, 1566},
  {"9.3", 47906, 1569},
  {"SA.3.10", 48003, 1572},
  {"10.1", 48346, 1581},
  {"10.2", 48444, 1584},
  {"10.3", 48538, 1587},
  {"10.4", 48633, 1590},
  {"SA.3.11", 48731, 1593},
  {"11.1", 48991, 1600},
  {"11.2", 49089, 1603},
  {"11.3", 49182, 1606},
  {"SA.3.12", 49280, 1609},
  {"12.1", 49620, 1618},
  {"12.2", 49718, 1621},
  {"12.3", 49811, 1624},
  {"12.4", 49905, 1627},
  {"SA.3.13", 50002, 1630},
  {"13.1", 50334, 1639},
  {"13.2", 50432, 1642}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 141, 4, 91, "Section",
  CellTags->{"SA.3.0", "0.1"}],

Cell[CellGroupData[{
Cell[1942, 61, 73, 1, 70, "Subsection",
  CellTags->{"SA.3.1", "1.1"}],
Cell[2018, 64, 132, 4, 70, "Text",
  CellTags->{"SA.3.1", "1.2"}],
Cell[2153, 70, 716, 18, 70, "Notes",
  CellTags->{"SA.3.1", "1.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[2906, 93, 77, 1, 70, "Subsection",
  CellTags->{"SA.3.2", "2.1"}],
Cell[2986, 96, 242, 5, 70, "Text",
  CellTags->{"SA.3.2", "2.2"}],
Cell[3231, 103, 77, 1, 70, "Text",
  CellTags->{"SA.3.2", "2.3"}],
Cell[3311, 106, 626, 17, 70, "Notes",
  CellTags->{"SA.3.2", "2.4"}],
Cell[3940, 125, 219, 5, 70, "Text",
  CellTags->{"SA.3.2", "2.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[4196, 135, 66, 1, 70, "Subsection",
  CellTags->{"SA.3.3", "3.1"}],
Cell[4265, 138, 669, 17, 70, "Text",
  CellTags->{"SA.3.3", "3.2"}],
Cell[4937, 157, 2305, 69, 70, "DefinitionBox",
  CellTags->"SA.3.3"],
Cell[7245, 228, 64, 1, 70, "Caption",
  CellTags->"SA.3.3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7346, 234, 73, 1, 70, "Subsection",
  CellTags->{"SA.3.4", "4.1"}],
Cell[7422, 237, 976, 33, 70, "DefinitionBox",
  CellTags->"SA.3.4"],
Cell[8401, 272, 61, 1, 70, "Caption",
  CellTags->"SA.3.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8499, 278, 82, 1, 70, "Subsection",
  CellTags->{"SA.3.5", "5.1"}],
Cell[8584, 281, 2290, 78, 70, "DefinitionBox",
  CellTags->"SA.3.5"],
Cell[10877, 361, 80, 1, 70, "Caption",
  CellTags->"SA.3.5"],
Cell[10960, 364, 632, 32, 70, "Text",
  CellTags->{"SA.3.5", "5.2"}],
Cell[11595, 398, 340, 15, 70, "Text",
  CellTags->{"SA.3.5", "5.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11972, 418, 79, 1, 70, "Subsection",
  CellTags->{"SA.3.6", "6.1"}],
Cell[12054, 421, 2643, 83, 70, "DefinitionBox",
  CellTags->"SA.3.6"],
Cell[14700, 506, 63, 1, 70, "Caption",
  CellTags->"SA.3.6"],
Cell[14766, 509, 963, 30, 70, "Text",
  CellTags->{"SA.3.6", "6.2"}],
Cell[15732, 541, 1239, 43, 70, "Text",
  CellTags->{"SA.3.6", "6.3"}],
Cell[16974, 586, 580, 24, 70, "Text",
  CellTags->{"SA.3.6", "6.4"}],
Cell[17557, 612, 409, 7, 70, "Text",
  CellTags->{"SA.3.6", "6.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[18003, 624, 68, 1, 70, "Subsection",
  CellTags->{"SA.3.7", "7.1"}],
Cell[18074, 627, 8112, 239, 70, "DefinitionBox",
  CellTags->"SA.3.7"],
Cell[26189, 868, 60, 1, 70, "Caption",
  CellTags->"SA.3.7"],
Cell[26252, 871, 241, 11, 70, "Text",
  CellTags->{"SA.3.7", "7.2"}],
Cell[26496, 884, 1682, 63, 70, "Text",
  CellTags->{"SA.3.7", "7.3"}],
Cell[28181, 949, 172, 4, 70, "Text",
  CellTags->{"SA.3.7", "7.4"}],
Cell[28356, 955, 436, 13, 70, "Text",
  CellTags->{"SA.3.7", "7.5"}],
Cell[28795, 970, 253, 8, 70, "Text",
  CellTags->{"SA.3.7", "7.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[29085, 983, 77, 1, 70, "Subsection",
  CellTags->{"SA.3.8", "8.1"}],
Cell[29165, 986, 2536, 81, 70, "DefinitionBox",
  CellTags->"SA.3.8"],
Cell[31704, 1069, 120, 5, 70, "Caption",
  CellTags->"SA.3.8"],
Cell[31827, 1076, 124, 4, 70, "Text",
  CellTags->{"SA.3.8", "8.2"}],
Cell[31954, 1082, 249, 5, 70, "Text",
  CellTags->{"SA.3.8", "8.3"}],
Cell[32206, 1089, 206, 8, 70, "Text",
  CellTags->{"SA.3.8", "8.4"}],
Cell[32415, 1099, 432, 10, 70, "Text",
  CellTags->{"SA.3.8", "8.5"}],
Cell[32850, 1111, 318, 9, 70, "Text",
  CellTags->{"SA.3.8", "8.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[33205, 1125, 82, 1, 70, "Subsection",
  CellTags->{"SA.3.9", "9.1"}],
Cell[33290, 1128, 268, 8, 70, "Text",
  CellTags->{"SA.3.9", "9.2"}],
Cell[33561, 1138, 1050, 17, 70, "Notes",
  CellTags->{"SA.3.9", "9.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[34648, 1160, 84, 1, 70, "Subsection",
  CellTags->{"SA.3.10", "10.1"}],
Cell[34735, 1163, 417, 16, 70, "Text",
  CellTags->{"SA.3.10", "10.2"}],
Cell[35155, 1181, 949, 17, 70, "Notes",
  CellTags->{"SA.3.10", "10.3"}],
Cell[36107, 1200, 635, 15, 94, "Notes",
  CellTags->{"SA.3.10", "10.4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[36779, 1220, 84, 1, 70, "Subsection",
  CellTags->{"SA.3.11", "11.1"}],
Cell[36866, 1223, 252, 9, 40, "Text",
  CellTags->{"SA.3.11", "11.2"}],
Cell[37121, 1234, 469, 10, 90, "Notes",
  CellTags->{"SA.3.11", "11.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[37627, 1249, 72, 1, 38, "Subsection",
  CellTags->{"SA.3.12", "12.1"}],
Cell[37702, 1252, 250, 7, 40, "Text",
  CellTags->{"SA.3.12", "12.2"}],
Cell[37955, 1261, 439, 11, 72, "Text",
  CellTags->{"SA.3.12", "12.3"}],
Cell[38397, 1274, 496, 15, 72, "Text",
  CellTags->{"SA.3.12", "12.4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[38930, 1294, 89, 1, 38, "Subsection",
  CellTags->{"SA.3.13", "13.1"}],
Cell[39022, 1297, 484, 14, 72, "Text",
  CellTags->{"SA.3.13", "13.2"}],
Cell[39509, 1313, 792, 27, 106, "DefinitionBox",
  CellTags->"SA.3.13"],
Cell[40304, 1342, 94, 1, 16, "Caption",
  CellTags->"SA.3.13"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

