(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     25019,        894]*)
(*NotebookOutlinePosition[     32992,       1147]*)
(*  CellTagsIndexPosition[     31977,       1102]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.4 ", "HeadingNumber"],
  "Evaluation"
}], "Section",
  CellTags->{"SA.4.0", "0.1"}],

Cell[CellGroupData[{

Cell["A.4.1 The Standard Evaluation Sequence", "Subsection",
  CellTags->{"SA.4.1", "1.1"}],

Cell[TextData[{
  "The following is the sequence of steps that ",
  StyleBox["Mathematica", "TI"],
  " follows in evaluating an expression like ",
  StyleBox["h", "TI"],
  StyleBox["[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ". Every time the expression changes, ",
  StyleBox["Mathematica", "TI"],
  " effectively starts the evaluation sequence over again.  "
}], "Text",
  CellTags->{"SA.4.1", "1.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the expression is a raw object (e.g., ",
  StyleBox["Integer", "MR"],
  ", ",
  StyleBox["String", "MR"],
  ", etc.), leave it unchanged.  \n\[FilledSmallSquare] Evaluate the head ",
  StyleBox["h", "TI"],
  " of the expression.  \n\[FilledSmallSquare] Evaluate each element ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " of the expression in turn. If ",
  StyleBox["h", "TI"],
  " is a symbol with attributes ",
  StyleBox["HoldFirst", "MR"],
  ", ",
  StyleBox["HoldRest", "MR"],
  ", ",
  StyleBox["HoldAll", "MR"],
  " or ",
  StyleBox["HoldAllComplete", "MR"],
  ", then skip evaluation of certain elements.   \n\[FilledSmallSquare] \
Unless ",
  StyleBox["h", "TI"],
  " has attribute ",
  StyleBox["HoldAllComplete", "MR"],
  " strip the outermost of any ",
  StyleBox["Unevaluated", "MR"],
  " wrappers that appear in the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ".  \n\[FilledSmallSquare] Unless ",
  StyleBox["h", "TI"],
  " has attribute ",
  StyleBox["SequenceHold", "MR"],
  ", flatten out all ",
  StyleBox["Sequence", "MR"],
  " objects that appear among the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ".   \n\[FilledSmallSquare] If ",
  StyleBox["h", "TI"],
  " has attribute ",
  StyleBox["Flat", "MR"],
  ", then flatten out all nested expressions with head ",
  StyleBox["h", "TI"],
  ".  \n\[FilledSmallSquare] If ",
  StyleBox["h", "TI"],
  " has attribute ",
  StyleBox["Listable", "MR"],
  ", then thread through any ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " that are lists.  \n\[FilledSmallSquare] If ",
  StyleBox["h", "TI"],
  " has attribute ",
  StyleBox["Orderless", "MR"],
  ", then sort the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " into order.  \n\[FilledSmallSquare] Unless ",
  StyleBox["h", "TI"],
  " has attribute ",
  StyleBox["HoldAllComplete", "MR"],
  ", use any applicable transformation rules associated with ",
  StyleBox["f", "TI"],
  " that you have defined for objects of the form ",
  StyleBox["h", "TI"],
  StyleBox["[", "MR"],
  " ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["],", "MR"],
  " ",
  "\[Ellipsis]",
  "  ",
  StyleBox["]", "MR"],
  ".   \n\[FilledSmallSquare] Use any built\[Hyphen]in transformation rules \
associated with ",
  StyleBox["f", "TI"],
  " for objects of the form ",
  StyleBox["h", "TI"],
  StyleBox["[", "MR"],
  " ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["],", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ".  \n\[FilledSmallSquare] Use any applicable transformation rules that you \
have defined for ",
  StyleBox["h", "TI"],
  StyleBox["[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " or for ",
  StyleBox["h", "TI"],
  StyleBox["[", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["][", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ".  \n\[FilledSmallSquare] Use any built\[Hyphen]in transformation rules \
for ",
  StyleBox["h", "TI"],
  StyleBox["[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " or for ",
  StyleBox["h", "TI"],
  StyleBox["[", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["][", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ".  "
}], "Notes",
  CellTags->{"SA.4.1", "1.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
A.4.2 Non\[Hyphen]Standard Argument Evaluation\
\>", "Subsection",
  CellTags->{"SA.4.2", "2.1"}],

Cell[TextData[{
  "There are a number of built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions that evaluate their arguments in special ways. The control \
structure ",
  StyleBox["While", "MR"],
  " is an example. The symbol ",
  StyleBox["While", "MR"],
  " has the attribute ",
  StyleBox["HoldAll", "MR"],
  ". As a result, the arguments of ",
  StyleBox["While", "MR"],
  " are not evaluated as part of the standard evaluation process. Instead, \
the internal code for ",
  StyleBox["While", "MR"],
  " evaluates the arguments in a special way. In the case of ",
  StyleBox["While", "MR"],
  ", the code evaluates the arguments repeatedly, so as to implement a loop. \
"
}], "Text",
  CellTags->{"SA.4.2", "2.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Control structures "], Cell[TextData[{
              
              "arguments evaluated in a sequence determined by control flow \
(e.g., ",
              StyleBox["CompoundExpression", "MR"],
              ") "
            }]]},
          {Cell["Conditionals "], Cell[TextData[{
              
              "arguments evaluated only when they correspond to branches that \
are taken (e.g., ",
              StyleBox["If", "MR"],
              ", ",
              StyleBox["Which", "MR"],
              ") "
            }]]},
          {Cell["Logical operations "], Cell[TextData[{
              
              "arguments evaluated only when they are needed in determining \
the logical result (e.g., ",
              StyleBox["And", "MR"],
              ", ",
              StyleBox["Or", "MR"],
              ") "
            }]]},
          {Cell["Iteration functions "], Cell[TextData[{
              
              "first argument evaluated for each step in the iteration (e.g., \
",
              StyleBox["Do", "MR"],
              ", ",
              StyleBox["Sum", "MR"],
              ", ",
              StyleBox["Plot", "MR"],
              ") "
            }]]},
          {Cell["Tracing functions "], Cell[TextData[{
              "form never evaluated (e.g., ",
              StyleBox["Trace", "MR"],
              ") "
            }]]},
          {Cell["Assignments "], Cell[TextData[{
              "first argument only partially evaluated (e.g., ",
              StyleBox["Set", "MR"],
              ", ",
              StyleBox["AddTo", "MR"],
              ") "
            }]]},
          {Cell["Pure functions "], Cell[TextData[{
              "function body not evaluated (e.g., ",
              StyleBox["Function", "MR"],
              ") "
            }]]},
          {Cell["Scoping constructs "], Cell[TextData[{
              "variable specifications not evaluated (e.g., ",
              StyleBox["Module", "MR"],
              ", ",
              StyleBox["Block", "MR"],
              ") "
            }]]},
          {Cell["Holding functions "], Cell[TextData[{
              "argument maintained in unevaluated form (e.g., ",
              StyleBox["Hold", "MR"],
              ", ",
              StyleBox["HoldPattern", "MR"],
              ") "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.4.2"],

Cell["\<\
Built\[Hyphen]in functions that evaluate their arguments in special \
ways. \
\>", "Caption",
  CellTags->"SA.4.2"],

Cell[CellGroupData[{

Cell["Logical Operations", "Subsubsection",
  CellTags->{"SA.4.2", "2.3"}],

Cell[TextData[{
  "In an expression of the form ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox["&&", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["&&", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "3"], TraditionalForm]], "InlineFormula"],
  " the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " are evaluated in order. As soon as any ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " is found to be ",
  StyleBox["False", "MR"],
  ", evaluation is stopped, and the result ",
  StyleBox["False", "MR"],
  " is returned. This means that you can use the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " to represent different \[OpenCurlyDoubleQuote]branches\
\[CloseCurlyDoubleQuote] in a program, with a particular branch being \
evaluated only if certain conditions are met.  "
}], "Text",
  CellTags->{"SA.4.2", "2.4"}],

Cell[TextData[{
  "The ",
  StyleBox["Or", "MR"],
  " function works much like ",
  StyleBox["And", "MR"],
  "; it returns ",
  StyleBox["True", "MR"],
  " as soon as it finds any argument that is ",
  StyleBox["True", "MR"],
  ". ",
  StyleBox["Xor", "MR"],
  ", on the other hand, always evaluates ",
  StyleBox["all", "TI"],
  " its arguments. "
}], "Text",
  CellTags->{"SA.4.2", "2.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Iteration Functions", "Subsubsection",
  CellTags->{"SA.4.2", "2.6"}],

Cell[TextData[{
  "An iteration function such as  ",
  StyleBox["Do[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  " is evaluated as follows:"
}], "Text",
  CellTags->{"SA.4.2", "2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] The iteration specification is evaluated. If it is \
not found to be of the form ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}", "MR"],
  ", the evaluation stops. \n\[FilledSmallSquare] The value of the iteration \
variable ",
  StyleBox["i", "TI"],
  " is made local, effectively using ",
  StyleBox["Block", "MR"],
  ".  \n\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " are used to determine the sequence of values to be assigned to the \
iteration variable\[NonBreakingSpace]",
  StyleBox["i", "TI"],
  ".  \n\[FilledSmallSquare] The iteration variable is successively set to \
each value, and ",
  StyleBox["f", "TI"],
  " is evaluated in each case.  \n\[FilledSmallSquare] The local values \
assigned to ",
  StyleBox["i", "TI"],
  " are cleared.  "
}], "Notes",
  CellTags->{"SA.4.2", "2.8"}],

Cell["\<\
If there are several iteration variables, the same procedure is \
followed for each variable in turn, for every value of all the preceding \
variables. \
\>", "Text",
  CellTags->{"SA.4.2", "2.9"}],

Cell[TextData[{
  "Unless otherwise specified, ",
  StyleBox["f", "TI"],
  " is not evaluated until a specific value has been assigned to ",
  StyleBox["i", "TI"],
  ", and is then evaluated for each value of ",
  StyleBox["i", "TI"],
  " chosen. You can use ",
  StyleBox["Evaluate[", "MR"],
  StyleBox["f", "TI"],
  StyleBox["]", "MR"],
  " to make ",
  StyleBox["f", "TI"],
  " be evaluated immediately, rather than only after a specific value has \
been assigned to ",
  StyleBox["i", "TI"],
  ". "
}], "Text",
  CellTags->{"SA.4.2", "2.10"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Assignments", "Subsubsection",
  CellTags->{"SA.4.2", "2.11"}],

Cell["\<\
The left\[Hyphen]hand sides of assignments are only partially \
evaluated. \
\>", "Text",
  CellTags->{"SA.4.2", "2.12"}],

Cell["\<\
\[FilledSmallSquare] If the left\[Hyphen]hand side is a symbol, no \
evaluation is performed.  
\[FilledSmallSquare] If the left\[Hyphen]hand side is a function without hold \
attributes, the arguments of the function are evaluated, but the function \
itself is not evaluated.  \
\>", "Notes",
  CellTags->{"SA.4.2", "2.13"}],

Cell[TextData[{
  "The right\[Hyphen]hand side is evaluated for immediate (",
  StyleBox["=", "MR"],
  "), but not for delayed (",
  StyleBox[":=", "MR"],
  "), assignments. "
}], "Text",
  CellTags->{"SA.4.2", "2.14"}],

Cell[TextData[{
  "Any subexpression of the form ",
  StyleBox["HoldPattern[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " that appears on the left\[Hyphen]hand side of an assignment is not \
evaluated, but is replaced by the unevaluated form of ",
  StyleBox["expr", "TI"],
  " before the assignment is done.  "
}], "Text",
  CellTags->{"SA.4.2", "2.15"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
A.4.3 Overriding Non\[Hyphen]Standard Argument Evaluation\
\>", \
"Subsection",
  CellTags->{"SA.4.3", "3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              StyleBox["Evaluate[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "], \[Ellipsis] ]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "evaluates the argument ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", whether or not the attributes of ",
              StyleBox["f", "TI"],
              " specify that it should be held "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.4.3"],

Cell["Overriding holding of arguments. ", "Caption",
  CellTags->"SA.4.3"],

Cell[TextData[{
  "By using ",
  StyleBox["Evaluate", "MR"],
  ", you can get any argument of a function evaluated immediately, even if \
the argument would usually be evaluated later under the control of the \
function.  "
}], "Text",
  CellTags->{"SA.4.3", "3.2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.4.4 Preventing Evaluation", "Subsection",
  CellTags->{"SA.4.4", "4.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " provides various functions which act as \[OpenCurlyDoubleQuote]wrappers\
\[CloseCurlyDoubleQuote] to prevent the expressions they contain from being \
evaluated. "
}], "Text",
  CellTags->{"SA.4.4", "4.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Hold[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "treated as ",
              StyleBox["Hold[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " in all cases "
            }]]},
          {Cell[TextData[{
              StyleBox["HoldComplete[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "treated as ",
              StyleBox["HoldComplete[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " with upvalues disabled "
            }]]},
          {Cell[TextData[{
              StyleBox["HoldForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "treated as ",
              StyleBox["expr", "TI"],
              " for printing "
            }]]},
          {Cell[TextData[{
              StyleBox["HoldPattern[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "treated as ",
              StyleBox["expr", "TI"],
              " in rules, definitions and patterns "
            }]]},
          {Cell[TextData[{
              StyleBox["Unevaluated[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "treated as ",
              StyleBox["expr", "TI"],
              " when arguments are passed to a function "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.4.4"],

Cell["Wrappers that prevent expressions from being evaluated. ", "Caption",
  CellTags->"SA.4.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.4.5 Global Control of Evaluation", "Subsection",
  CellTags->{"SA.4.5", "5.1"}],

Cell["\<\
In the evaluation procedure described above, two basic kinds of \
steps are involved: \
\>", "Text",
  CellTags->{"SA.4.5", "5.2"}],

Cell["\<\
\[FilledSmallSquare] Iteration: evaluate a particular expression \
until it no longer changes.  
\[FilledSmallSquare] Recursion: evaluate subsidiary expressions needed to \
find the value of a particular expression.  \
\>", "Notes",
  CellTags->{"SA.4.5", "5.3"}],

Cell["\<\
Iteration leads to evaluation chains in which successive \
expressions are obtained by the application of various transformation rules. \
\
\>", "Text",
  CellTags->{"SA.4.5", "5.4"}],

Cell[TextData[{
  StyleBox["Trace", "MR"],
  " shows evaluation chains as lists, and shows subsidiary evaluations \
corresponding to recursion in sublists. "
}], "Text",
  CellTags->{"SA.4.5", "5.5"}],

Cell[TextData[{
  "The expressions associated with the sequence of subsidiary evaluations \
which lead to an expression currently being evaluated are given in the list \
returned by ",
  StyleBox["Stack[", "MR"],
  " ",
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.4.5", "5.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$RecursionLimit", "MR"],
              " "
            }]], Cell["maximum recursion depth "]},
          {Cell[TextData[{
              StyleBox["$IterationLimit", "MR"],
              " "
            }]], Cell["maximum number of iterations "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.4.5"],

Cell["Global variables controlling the evaluation of expressions. ", "Caption",
  CellTags->"SA.4.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.4.6 Aborts", "Subsection",
  CellTags->{"SA.4.6", "6.1"}],

Cell[TextData[{
  "You can ask ",
  StyleBox["Mathematica", "TI"],
  " to abort at any point in a computation, either by calling the function ",
  StyleBox["Abort[", "MR"],
  " ",
  StyleBox["]", "MR"],
  ", or by typing appropriate interrupt keys. "
}], "Text",
  CellTags->{"SA.4.6", "6.2"}],

Cell[TextData[{
  "When asked to abort, ",
  StyleBox["Mathematica", "TI"],
  " will terminate the computation as quickly as possible. If the answer \
obtained would be incorrect or incomplete, then ",
  StyleBox["Mathematica", "TI"],
  " returns ",
  StyleBox["$Aborted", "MR"],
  " instead of giving that answer. "
}], "Text",
  CellTags->{"SA.4.6", "6.3"}],

Cell[TextData[{
  "Aborts can be caught using ",
  StyleBox["CheckAbort", "MR"],
  ", and can be postponed using ",
  StyleBox["AbortProtect", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.4.6", "6.4"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.4.0"->{
    Cell[1776, 53, 113, 4, 65, "Section",
      CellTags->{"SA.4.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 113, 4, 65, "Section",
      CellTags->{"SA.4.0", "0.1"}]},
  "SA.4.1"->{
    Cell[1914, 61, 91, 1, 70, "Subsection",
      CellTags->{"SA.4.1", "1.1"}],
    Cell[2008, 64, 758, 27, 70, "Text",
      CellTags->{"SA.4.1", "1.2"}],
    Cell[2769, 93, 5007, 199, 70, "Notes",
      CellTags->{"SA.4.1", "1.3"}]},
  "1.1"->{
    Cell[1914, 61, 91, 1, 70, "Subsection",
      CellTags->{"SA.4.1", "1.1"}]},
  "1.2"->{
    Cell[2008, 64, 758, 27, 70, "Text",
      CellTags->{"SA.4.1", "1.2"}]},
  "1.3"->{
    Cell[2769, 93, 5007, 199, 70, "Notes",
      CellTags->{"SA.4.1", "1.3"}]},
  "SA.4.2"->{
    Cell[7813, 297, 107, 3, 70, "Subsection",
      CellTags->{"SA.4.2", "2.1"}],
    Cell[7923, 302, 731, 20, 70, "Text",
      CellTags->{"SA.4.2", "2.2"}],
    Cell[8657, 324, 2523, 73, 70, "DefinitionBox",
      CellTags->"SA.4.2"],
    Cell[11183, 399, 125, 4, 70, "Caption",
      CellTags->"SA.4.2"],
    Cell[11333, 407, 74, 1, 70, "Subsubsection",
      CellTags->{"SA.4.2", "2.3"}],
    Cell[11410, 410, 1504, 51, 70, "Text",
      CellTags->{"SA.4.2", "2.4"}],
    Cell[12917, 463, 391, 15, 70, "Text",
      CellTags->{"SA.4.2", "2.5"}],
    Cell[13345, 483, 75, 1, 70, "Subsubsection",
      CellTags->{"SA.4.2", "2.6"}],
    Cell[13423, 486, 693, 29, 70, "Text",
      CellTags->{"SA.4.2", "2.7"}],
    Cell[14119, 517, 1627, 56, 70, "Notes",
      CellTags->{"SA.4.2", "2.8"}],
    Cell[15749, 575, 207, 5, 70, "Text",
      CellTags->{"SA.4.2", "2.9"}],
    Cell[15959, 582, 546, 18, 70, "Text",
      CellTags->{"SA.4.2", "2.10"}],
    Cell[16542, 605, 68, 1, 70, "Subsubsection",
      CellTags->{"SA.4.2", "2.11"}],
    Cell[16613, 608, 131, 4, 70, "Text",
      CellTags->{"SA.4.2", "2.12"}],
    Cell[16747, 614, 335, 7, 70, "Notes",
      CellTags->{"SA.4.2", "2.13"}],
    Cell[17085, 623, 219, 7, 70, "Text",
      CellTags->{"SA.4.2", "2.14"}],
    Cell[17307, 632, 372, 10, 70, "Text",
      CellTags->{"SA.4.2", "2.15"}]},
  "2.1"->{
    Cell[7813, 297, 107, 3, 70, "Subsection",
      CellTags->{"SA.4.2", "2.1"}]},
  "2.2"->{
    Cell[7923, 302, 731, 20, 70, "Text",
      CellTags->{"SA.4.2", "2.2"}]},
  "2.3"->{
    Cell[11333, 407, 74, 1, 70, "Subsubsection",
      CellTags->{"SA.4.2", "2.3"}]},
  "2.4"->{
    Cell[11410, 410, 1504, 51, 70, "Text",
      CellTags->{"SA.4.2", "2.4"}]},
  "2.5"->{
    Cell[12917, 463, 391, 15, 70, "Text",
      CellTags->{"SA.4.2", "2.5"}]},
  "2.6"->{
    Cell[13345, 483, 75, 1, 70, "Subsubsection",
      CellTags->{"SA.4.2", "2.6"}]},
  "2.7"->{
    Cell[13423, 486, 693, 29, 70, "Text",
      CellTags->{"SA.4.2", "2.7"}]},
  "2.8"->{
    Cell[14119, 517, 1627, 56, 70, "Notes",
      CellTags->{"SA.4.2", "2.8"}]},
  "2.9"->{
    Cell[15749, 575, 207, 5, 70, "Text",
      CellTags->{"SA.4.2", "2.9"}]},
  "2.10"->{
    Cell[15959, 582, 546, 18, 70, "Text",
      CellTags->{"SA.4.2", "2.10"}]},
  "2.11"->{
    Cell[16542, 605, 68, 1, 70, "Subsubsection",
      CellTags->{"SA.4.2", "2.11"}]},
  "2.12"->{
    Cell[16613, 608, 131, 4, 70, "Text",
      CellTags->{"SA.4.2", "2.12"}]},
  "2.13"->{
    Cell[16747, 614, 335, 7, 70, "Notes",
      CellTags->{"SA.4.2", "2.13"}]},
  "2.14"->{
    Cell[17085, 623, 219, 7, 70, "Text",
      CellTags->{"SA.4.2", "2.14"}]},
  "2.15"->{
    Cell[17307, 632, 372, 10, 70, "Text",
      CellTags->{"SA.4.2", "2.15"}]},
  "SA.4.3"->{
    Cell[17728, 648, 120, 4, 70, "Subsection",
      CellTags->{"SA.4.3", "3.1"}],
    Cell[17851, 654, 1529, 43, 70, "DefinitionBox",
      CellTags->"SA.4.3"],
    Cell[19383, 699, 74, 1, 70, "Caption",
      CellTags->"SA.4.3"],
    Cell[19460, 702, 266, 7, 70, "Text",
      CellTags->{"SA.4.3", "3.2"}]},
  "3.1"->{
    Cell[17728, 648, 120, 4, 70, "Subsection",
      CellTags->{"SA.4.3", "3.1"}]},
  "3.2"->{
    Cell[19460, 702, 266, 7, 70, "Text",
      CellTags->{"SA.4.3", "3.2"}]},
  "SA.4.4"->{
    Cell[19763, 714, 80, 1, 38, "Subsection",
      CellTags->{"SA.4.4", "4.1"}],
    Cell[19846, 717, 259, 6, 70, "Text",
      CellTags->{"SA.4.4", "4.2"}],
    Cell[20108, 725, 1975, 60, 166, "DefinitionBox",
      CellTags->"SA.4.4"],
    Cell[22086, 787, 97, 1, 16, "Caption",
      CellTags->"SA.4.4"]},
  "4.1"->{
    Cell[19763, 714, 80, 1, 38, "Subsection",
      CellTags->{"SA.4.4", "4.1"}]},
  "4.2"->{
    Cell[19846, 717, 259, 6, 70, "Text",
      CellTags->{"SA.4.4", "4.2"}]},
  "SA.4.5"->{
    Cell[22220, 793, 87, 1, 38, "Subsection",
      CellTags->{"SA.4.5", "5.1"}],
    Cell[22310, 796, 141, 4, 24, "Text",
      CellTags->{"SA.4.5", "5.2"}],
    Cell[22454, 802, 273, 6, 62, "Notes",
      CellTags->{"SA.4.5", "5.3"}],
    Cell[22730, 810, 193, 5, 40, "Text",
      CellTags->{"SA.4.5", "5.4"}],
    Cell[22926, 817, 200, 5, 40, "Text",
      CellTags->{"SA.4.5", "5.5"}],
    Cell[23129, 824, 292, 9, 40, "Text",
      CellTags->{"SA.4.5", "5.6"}],
    Cell[23424, 835, 501, 14, 66, "DefinitionBox",
      CellTags->"SA.4.5"],
    Cell[23928, 851, 101, 1, 16, "Caption",
      CellTags->"SA.4.5"]},
  "5.1"->{
    Cell[22220, 793, 87, 1, 38, "Subsection",
      CellTags->{"SA.4.5", "5.1"}]},
  "5.2"->{
    Cell[22310, 796, 141, 4, 24, "Text",
      CellTags->{"SA.4.5", "5.2"}]},
  "5.3"->{
    Cell[22454, 802, 273, 6, 62, "Notes",
      CellTags->{"SA.4.5", "5.3"}]},
  "5.4"->{
    Cell[22730, 810, 193, 5, 40, "Text",
      CellTags->{"SA.4.5", "5.4"}]},
  "5.5"->{
    Cell[22926, 817, 200, 5, 40, "Text",
      CellTags->{"SA.4.5", "5.5"}]},
  "5.6"->{
    Cell[23129, 824, 292, 9, 40, "Text",
      CellTags->{"SA.4.5", "5.6"}]},
  "SA.4.6"->{
    Cell[24066, 857, 65, 1, 38, "Subsection",
      CellTags->{"SA.4.6", "6.1"}],
    Cell[24134, 860, 293, 9, 40, "Text",
      CellTags->{"SA.4.6", "6.2"}],
    Cell[24430, 871, 359, 10, 56, "Text",
      CellTags->{"SA.4.6", "6.3"}],
    Cell[24792, 883, 199, 7, 40, "Text",
      CellTags->{"SA.4.6", "6.4"}]},
  "6.1"->{
    Cell[24066, 857, 65, 1, 38, "Subsection",
      CellTags->{"SA.4.6", "6.1"}]},
  "6.2"->{
    Cell[24134, 860, 293, 9, 40, "Text",
      CellTags->{"SA.4.6", "6.2"}]},
  "6.3"->{
    Cell[24430, 871, 359, 10, 56, "Text",
      CellTags->{"SA.4.6", "6.3"}]},
  "6.4"->{
    Cell[24792, 883, 199, 7, 40, "Text",
      CellTags->{"SA.4.6", "6.4"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.4.0", 25634, 910},
  {"0.1", 25724, 913},
  {"SA.4.1", 25817, 916},
  {"1.1", 26064, 923},
  {"1.2", 26156, 926},
  {"1.3", 26244, 929},
  {"SA.4.2", 26338, 932},
  {"2.1", 27699, 967},
  {"2.2", 27793, 970},
  {"2.3", 27882, 973},
  {"2.4", 27979, 976},
  {"2.5", 28070, 979},
  {"2.6", 28160, 982},
  {"2.7", 28257, 985},
  {"2.8", 28347, 988},
  {"2.9", 28439, 991},
  {"2.10", 28529, 994},
  {"2.11", 28621, 997},
  {"2.12", 28720, 1000},
  {"2.13", 28811, 1003},
  {"2.14", 28903, 1006},
  {"2.15", 28994, 1009},
  {"SA.4.3", 29088, 1012},
  {"3.1", 29409, 1021},
  {"3.2", 29504, 1024},
  {"SA.4.4", 29596, 1027},
  {"4.1", 29917, 1036},
  {"4.2", 30011, 1039},
  {"SA.4.5", 30103, 1042},
  {"5.1", 30732, 1059},
  {"5.2", 30826, 1062},
  {"5.3", 30915, 1065},
  {"5.4", 31005, 1068},
  {"5.5", 31094, 1071},
  {"5.6", 31183, 1074},
  {"SA.4.6", 31275, 1077},
  {"6.1", 31601, 1086},
  {"6.2", 31695, 1089},
  {"6.3", 31784, 1092},
  {"6.4", 31874, 1095}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 113, 4, 65, "Section",
  CellTags->{"SA.4.0", "0.1"}],

Cell[CellGroupData[{
Cell[1914, 61, 91, 1, 70, "Subsection",
  CellTags->{"SA.4.1", "1.1"}],
Cell[2008, 64, 758, 27, 70, "Text",
  CellTags->{"SA.4.1", "1.2"}],
Cell[2769, 93, 5007, 199, 70, "Notes",
  CellTags->{"SA.4.1", "1.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7813, 297, 107, 3, 70, "Subsection",
  CellTags->{"SA.4.2", "2.1"}],
Cell[7923, 302, 731, 20, 70, "Text",
  CellTags->{"SA.4.2", "2.2"}],
Cell[8657, 324, 2523, 73, 70, "DefinitionBox",
  CellTags->"SA.4.2"],
Cell[11183, 399, 125, 4, 70, "Caption",
  CellTags->"SA.4.2"],

Cell[CellGroupData[{
Cell[11333, 407, 74, 1, 70, "Subsubsection",
  CellTags->{"SA.4.2", "2.3"}],
Cell[11410, 410, 1504, 51, 70, "Text",
  CellTags->{"SA.4.2", "2.4"}],
Cell[12917, 463, 391, 15, 70, "Text",
  CellTags->{"SA.4.2", "2.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13345, 483, 75, 1, 70, "Subsubsection",
  CellTags->{"SA.4.2", "2.6"}],
Cell[13423, 486, 693, 29, 70, "Text",
  CellTags->{"SA.4.2", "2.7"}],
Cell[14119, 517, 1627, 56, 70, "Notes",
  CellTags->{"SA.4.2", "2.8"}],
Cell[15749, 575, 207, 5, 70, "Text",
  CellTags->{"SA.4.2", "2.9"}],
Cell[15959, 582, 546, 18, 70, "Text",
  CellTags->{"SA.4.2", "2.10"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16542, 605, 68, 1, 70, "Subsubsection",
  CellTags->{"SA.4.2", "2.11"}],
Cell[16613, 608, 131, 4, 70, "Text",
  CellTags->{"SA.4.2", "2.12"}],
Cell[16747, 614, 335, 7, 70, "Notes",
  CellTags->{"SA.4.2", "2.13"}],
Cell[17085, 623, 219, 7, 70, "Text",
  CellTags->{"SA.4.2", "2.14"}],
Cell[17307, 632, 372, 10, 70, "Text",
  CellTags->{"SA.4.2", "2.15"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17728, 648, 120, 4, 70, "Subsection",
  CellTags->{"SA.4.3", "3.1"}],
Cell[17851, 654, 1529, 43, 70, "DefinitionBox",
  CellTags->"SA.4.3"],
Cell[19383, 699, 74, 1, 70, "Caption",
  CellTags->"SA.4.3"],
Cell[19460, 702, 266, 7, 70, "Text",
  CellTags->{"SA.4.3", "3.2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[19763, 714, 80, 1, 38, "Subsection",
  CellTags->{"SA.4.4", "4.1"}],
Cell[19846, 717, 259, 6, 70, "Text",
  CellTags->{"SA.4.4", "4.2"}],
Cell[20108, 725, 1975, 60, 166, "DefinitionBox",
  CellTags->"SA.4.4"],
Cell[22086, 787, 97, 1, 16, "Caption",
  CellTags->"SA.4.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22220, 793, 87, 1, 38, "Subsection",
  CellTags->{"SA.4.5", "5.1"}],
Cell[22310, 796, 141, 4, 24, "Text",
  CellTags->{"SA.4.5", "5.2"}],
Cell[22454, 802, 273, 6, 62, "Notes",
  CellTags->{"SA.4.5", "5.3"}],
Cell[22730, 810, 193, 5, 40, "Text",
  CellTags->{"SA.4.5", "5.4"}],
Cell[22926, 817, 200, 5, 40, "Text",
  CellTags->{"SA.4.5", "5.5"}],
Cell[23129, 824, 292, 9, 40, "Text",
  CellTags->{"SA.4.5", "5.6"}],
Cell[23424, 835, 501, 14, 66, "DefinitionBox",
  CellTags->"SA.4.5"],
Cell[23928, 851, 101, 1, 16, "Caption",
  CellTags->"SA.4.5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24066, 857, 65, 1, 38, "Subsection",
  CellTags->{"SA.4.6", "6.1"}],
Cell[24134, 860, 293, 9, 40, "Text",
  CellTags->{"SA.4.6", "6.2"}],
Cell[24430, 871, 359, 10, 56, "Text",
  CellTags->{"SA.4.6", "6.3"}],
Cell[24792, 883, 199, 7, 40, "Text",
  CellTags->{"SA.4.6", "6.4"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

