(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     35480,       1195]*)
(*NotebookOutlinePosition[     41862,       1396]*)
(*  CellTagsIndexPosition[     41126,       1363]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.5 ", "HeadingNumber"],
  "Patterns and Transformation Rules"
}], "Section",
  CellTags->{"SA.5.0", "0.1"}],

Cell[CellGroupData[{

Cell["A.5.1 Patterns", "Subsection",
  CellTags->{"SA.5.1", "1.1"}],

Cell[TextData[{
  StyleBox["Patterns", "TI"],
  " stand for classes of expressions. They contain ",
  StyleBox["pattern objects", "TI"],
  " which represent sets of possible expressions.  "
}], "Text",
  CellTags->{"SA.5.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["_", "MR"],
              " "
            }]], Cell["any expression "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              " "
            }]], Cell[TextData[{
              "any expression, given the name ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox[":", "MR"],
              StyleBox["pattern", "TI"],
              " "
            }]], Cell[TextData[{
              "a pattern, given the name ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["pattern", "TI"],
              " ",
              StyleBox["?", "MR"],
              " ",
              StyleBox["test", "TI"],
              " "
            }]], Cell[TextData[{
              "a pattern that yields ",
              StyleBox["True", "MR"],
              " when ",
              StyleBox["test", "TI"],
              " is applied to its value "
            }]]},
          {Cell[TextData[{
              StyleBox["_", "MR"],
              StyleBox["h", "TI"],
              " "
            }]], Cell[TextData[{
              "any expression with head ",
              StyleBox["h", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              StyleBox["h", "TI"],
              " "
            }]], Cell[TextData[{
              "any expression with head ",
              StyleBox["h", "TI"],
              ", given the name ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["__", "MR"],
              " "
            }]], Cell["any sequence of one or more expressions "]},
          {Cell[TextData[{
              StyleBox["___", "MR"],
              " "
            }]], Cell["any sequence of zero or more expressions "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["__", "MR"],
              " \[ThinSpace]and \[ThinSpace]",
              StyleBox["x", "TI"],
              StyleBox["___", "MR"],
              " "
            }]], Cell[TextData[{
              "sequences of expressions, given the name ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["__", "MR"],
              StyleBox["h", "TI"],
              " \[ThinSpace]and \[ThinSpace]",
              StyleBox["___", "MR"],
              StyleBox["h", "TI"],
              " "
            }]], Cell[TextData[{
              "sequences of expressions, each with head ",
              StyleBox["h", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["__", "MR"],
              StyleBox["h", "TI"],
              " \[ThinSpace]and \[ThinSpace]",
              StyleBox["x", "TI"],
              StyleBox["___", "MR"],
              StyleBox["h", "TI"],
              " "
            }]], Cell[TextData[{
              "sequences of expressions with head ",
              StyleBox["h", "TI"],
              ", given the name ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_:", "MR"],
              StyleBox["v", "TI"],
              " "
            }]], Cell[TextData[{
              "an expression with default value ",
              StyleBox["v", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              StyleBox["h", "TI"],
              StyleBox[":", "MR"],
              StyleBox["v", "TI"],
              " "
            }]], Cell[TextData[{
              "an expression with head ",
              StyleBox["h", "TI"],
              " and default value ",
              StyleBox["v", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_.", "MR"],
              " "
            }]], Cell[
            "an expression with a globally defined default value "]},
          {Cell[TextData[{
              StyleBox["Optional[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              StyleBox["h", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "an expression that must have head ",
              StyleBox["h", "TI"],
              ", and has a globally defined default value "
            }]]},
          {Cell[TextData[{
              StyleBox["Except[", "MR"],
              StyleBox["c", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "any expression except one that matches ",
              StyleBox["c", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Except[", "MR"],
              StyleBox["c", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["pattern", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "any expression matching ",
              StyleBox["pattern", "TI"],
              ", except one that matches ",
              StyleBox["c", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["pattern", "TI"],
              StyleBox["..", "MR"],
              " "
            }]], Cell["a pattern repeated one or more times "]},
          {Cell[TextData[{
              StyleBox["pattern", "TI"],
              StyleBox["...", "MR"],
              " "
            }]], Cell["a pattern repeated zero or more times "]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pattern",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["|", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pattern",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["|", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]], Cell[TextData[{
              "a pattern which matches at least one of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pattern",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["pattern", "TI"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["cond", "TI"],
              " "
            }]], Cell[TextData[{
              "a pattern for which ",
              StyleBox["cond", "TI"],
              " evaluates to ",
              StyleBox["True", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["HoldPattern[", "MR"],
              StyleBox["pattern", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["a pattern not evaluated "]},
          {Cell[TextData[{
              StyleBox["Verbatim[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["an expression to be matched verbatim "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.5.1"],

Cell["Pattern objects. ", "Caption",
  CellTags->"SA.5.1"],

Cell[TextData[{
  "When several pattern objects with the same name occur in a single pattern, \
all the objects must stand for the same expression. Thus ",
  StyleBox["f[x_,", "MR"],
  " ",
  StyleBox["x_]", "MR"],
  " can stand for ",
  StyleBox["f[2,", "MR"],
  " ",
  StyleBox["2]", "MR"],
  " but not ",
  StyleBox["f[2,", "MR"],
  " ",
  StyleBox["3]", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.5.1", "1.3"}],

Cell[TextData[{
  "In a pattern object such as ",
  StyleBox["_", "MR"],
  StyleBox["h", "TI"],
  ", the head ",
  StyleBox["h", "TI"],
  " can be any expression, but cannot itself be a pattern. "
}], "Text",
  CellTags->{"SA.5.1", "1.4"}],

Cell[TextData[{
  "A pattern object such as ",
  StyleBox["x", "TI"],
  StyleBox["__", "MR"],
  " stands for a ",
  StyleBox["sequence", "TI"],
  " of expressions. So, for example, ",
  StyleBox["f[x__]", "MR"],
  " can stand for ",
  StyleBox["f[a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c]", "MR"],
  ", with ",
  StyleBox["x", "MR"],
  " being ",
  StyleBox["Sequence[a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c]", "MR"],
  ". If you use ",
  StyleBox["x", "MR"],
  ", say in the result of a transformation rule, the sequence will be spliced \
into the function in which ",
  StyleBox["x", "MR"],
  " appears. Thus ",
  StyleBox["g[u,", "MR"],
  " ",
  StyleBox["x,", "MR"],
  " ",
  StyleBox["u]", "MR"],
  " would become ",
  StyleBox["g[u,", "MR"],
  " ",
  StyleBox["a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c,", "MR"],
  " ",
  StyleBox["u]", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.5.1", "1.5"}],

Cell[TextData[{
  "When the pattern objects ",
  StyleBox["x", "TI"],
  StyleBox["_:", "MR"],
  StyleBox["v", "TI"],
  " and ",
  StyleBox["x", "TI"],
  StyleBox["_.", "MR"],
  " appear as arguments of functions, they represent arguments which may be \
omitted. When the argument corresponding to ",
  StyleBox["x", "TI"],
  StyleBox["_:", "MR"],
  StyleBox["v", "TI"],
  " is omitted, ",
  StyleBox["x", "TI"],
  " is taken to have value ",
  StyleBox["v", "TI"],
  ". When the argument corresponding to ",
  StyleBox["x", "TI"],
  StyleBox["_.", "MR"],
  " is omitted, ",
  StyleBox["x", "TI"],
  " is taken to have a ",
  StyleBox["default value", "TI"],
  " that is associated with the function in which it appears. You can specify \
this default value by making assignments for ",
  StyleBox["Default[", "MR"],
  StyleBox["f", "TI"],
  StyleBox["]", "MR"],
  " and so on. "
}], "Text",
  CellTags->{"SA.5.1", "1.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Default[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "default value for ",
              StyleBox["x", "TI"],
              StyleBox["_.", "MR"],
              " when it appears as any argument of the function ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Default[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "default value for ",
              StyleBox["x", "TI"],
              StyleBox["_.", "MR"],
              " when it appears as the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " argument (negative ",
              StyleBox["n", "TI"],
              " count from the end) "
            }]]},
          {Cell[TextData[{
              StyleBox["Default[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["tot", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "default value for the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " argument when there are a total of ",
              StyleBox["tot", "TI"],
              " arguments "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.5.1"],

Cell["Default values. ", "Caption",
  CellTags->"SA.5.1"],

Cell[TextData[{
  "A pattern like ",
  StyleBox["f[x__,", "MR"],
  " ",
  StyleBox["y__,", "MR"],
  " ",
  StyleBox["z__]", "MR"],
  " can match an expression like ",
  StyleBox["f[a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c,", "MR"],
  " ",
  StyleBox["d,", "MR"],
  " ",
  StyleBox["e]", "MR"],
  " with several different choices of ",
  StyleBox["x", "MR"],
  ", ",
  StyleBox["y", "MR"],
  " and ",
  StyleBox["z", "MR"],
  ". The choices with ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  " of minimum length are tried first. In general, when there are multiple ",
  StyleBox["__", "MR"],
  " or ",
  StyleBox["___", "MR"],
  " in a single function, the case that is tried first takes all the ",
  StyleBox["__", "MR"],
  " and ",
  StyleBox["___", "MR"],
  " to stand for sequences of minimum length, except the last one, which \
stands for \[OpenCurlyDoubleQuote]the rest\[CloseCurlyDoubleQuote] of the \
arguments. "
}], "Text",
  CellTags->{"SA.5.1", "1.7"}],

Cell[TextData[{
  "When ",
  StyleBox["x", "TI"],
  StyleBox["_:", "MR"],
  StyleBox["v", "TI"],
  " or ",
  StyleBox["x", "TI"],
  StyleBox["_.", "MR"],
  " are present, the case that is tried first is the one in which none of \
them correspond to omitted arguments. Cases in which later arguments are \
dropped are tried next.  "
}], "Text",
  CellTags->{"SA.5.1", "1.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Orderless", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " and ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " are equivalent "
            }]]},
          {Cell[TextData[{
              StyleBox["Flat", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " and ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " are equivalent "
            }]]},
          {Cell[TextData[{
              StyleBox["OneIdentity", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " and ",
              StyleBox["x", "TI"],
              " are equivalent "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.5.1"],

Cell["Attributes used in matching patterns. ", "Caption",
  CellTags->"SA.5.1"],

Cell[TextData[{
  "Pattern objects like ",
  StyleBox["x", "TI"],
  StyleBox["_", "MR"],
  " can represent any sequence of arguments in a function ",
  StyleBox["f", "TI"],
  " with attribute ",
  StyleBox["Flat", "MR"],
  ". The value of ",
  StyleBox["x", "TI"],
  " in this case is ",
  StyleBox["f", "TI"],
  " applied to the sequence of arguments. If ",
  StyleBox["f", "TI"],
  " has the attribute ",
  StyleBox["OneIdentity", "MR"],
  ", then ",
  StyleBox["e", "TI"],
  " is used instead of ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["e", "TI"],
  StyleBox["]", "MR"],
  " when ",
  StyleBox["x", "TI"],
  " corresponds to a sequence of just one argument. "
}], "Text",
  CellTags->{"SA.5.1", "1.9"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.5.2 Assignments", "Subsection",
  CellTags->{"SA.5.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "immediate assignment: ",
              StyleBox["rhs", "TI"],
              " is evaluated at the time of assignment "
            }]]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "delayed assignment: ",
              StyleBox["rhs", "TI"],
              " is evaluated when the value of ",
              StyleBox["lhs", "TI"],
              " is requested "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.5.2"],

Cell[TextData[{
  "The two basic types of assignment in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"SA.5.2"],

Cell[TextData[{
  "Assignments in ",
  StyleBox["Mathematica", "TI"],
  " specify transformation rules for expressions. Every assignment that you \
make must be associated with a particular ",
  StyleBox["Mathematica", "TI"],
  " symbol.  "
}], "Text",
  CellTags->{"SA.5.2", "2.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "assignment is associated with ",
              StyleBox["f", "TI"],
              " (downvalue) "
            }]]},
          {Cell[TextData[{
              StyleBox["t", "TI"],
              StyleBox["/:", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "assignment is associated with ",
              StyleBox["t", "TI"],
              " (upvalue) "
            }]]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["g", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["^=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "assignment is associated with ",
              StyleBox["g", "TI"],
              " (upvalue) "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.5.2"],

Cell["Assignments associated with different symbols. ", "Caption",
  CellTags->"SA.5.2"],

Cell[TextData[{
  "In the case of an assignment like ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["args", "TI"],
  StyleBox["]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " looks at ",
  StyleBox["f", "TI"],
  ", then the head of ",
  StyleBox["f", "TI"],
  ", then the head of that, and so on, until it finds a symbol with which to \
associate the assignment. "
}], "Text",
  CellTags->{"SA.5.2", "2.3"}],

Cell[TextData[{
  "When you make an assignment like ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox["^=", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will set up transformation rules associated with each distinct symbol \
that occurs either as an argument of ",
  StyleBox["lhs", "TI"],
  ", or as the head of an argument of ",
  StyleBox["lhs", "TI"],
  ". "
}], "Text",
  CellTags->{"SA.5.2", "2.4"}],

Cell[TextData[{
  "The transformation rules associated with a particular symbol ",
  StyleBox["s", "TI"],
  " are always stored in a definite order, and are tested in that order when \
they are used. Each time you make an assignment, the corresponding \
transformation rule is inserted at the end of the list of transformation \
rules associated with ",
  StyleBox["s", "TI"],
  ", except in the following cases: "
}], "Text",
  CellTags->{"SA.5.2", "2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] The left\[Hyphen]hand side of the transformation rule \
is identical to a transformation rule that has already been stored, and any \
",
  StyleBox["/;", "MR"],
  " conditions on the right\[Hyphen]hand side are also identical. In this \
case, the new transformation rule is inserted in place of the old one.  \n\
\[FilledSmallSquare] ",
  StyleBox["Mathematica", "TI"],
  " determines that the new transformation rule is more specific than a rule \
already present, and would never be used if it were placed after this rule. \
In this case, the new rule is placed before the old one. Note that in many \
cases it is not possible to determine whether one rule is more specific than \
another; in such cases, the new rule is always inserted at the end.  "
}], "Notes",
  CellTags->{"SA.5.2", "2.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.5.3 Types of Values", "Subsection",
  CellTags->{"SA.5.3", "3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Attributes[", "MR"],
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "attributes of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["DefaultValues[", "MR"],
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "default values for arguments of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["DownValues[", "MR"],
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "values for ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              ", ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["][", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              ", etc. "
            }]]},
          {Cell[TextData[{
              StyleBox["FormatValues[", "MR"],
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "print forms associated with ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Messages[", "MR"],
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "messages associated with ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NValues[", "MR"],
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "numerical values associated with ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "defaults for options associated with ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["OwnValues[", "MR"],
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "values for ",
              StyleBox["f", "TI"],
              " itself "
            }]]},
          {Cell[TextData[{
              StyleBox["UpValues[", "MR"],
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "values for \[Ellipsis]",
              " ",
              StyleBox["[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.5.3"],

Cell["Types of values associated with symbols. ", "Caption",
  CellTags->"SA.5.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.5.4 Clearing and Removing Objects", "Subsection",
  CellTags->{"SA.5.4", "4.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["=.", "MR"],
              " "
            }]], Cell[TextData[{
              "clear a value defined for ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["/:", "MR"],
              " ",
              StyleBox["expr", "TI"],
              " ",
              StyleBox["=.", "MR"],
              " "
            }]], Cell[TextData[{
              "clear a value associated with ",
              StyleBox["f", "TI"],
              " defined for ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Clear[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "clear all values for the symbols ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", except for attributes, messages and defaults "
            }]]},
          {Cell[TextData[{
              StyleBox["ClearAll[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "clear all values for the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", including attributes, messages and defaults "
            }]]},
          {Cell[TextData[{
              StyleBox["Remove[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "clear all values, and then remove the names of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.5.4"],

Cell["Ways to clear and remove objects. ", "Caption",
  CellTags->"SA.5.4"],

Cell[TextData[{
  StyleBox["Clear", "MR"],
  ", ",
  StyleBox["ClearAll", "MR"],
  " and ",
  StyleBox["Remove", "MR"],
  " can all take string patterns as arguments, to specify action on all \
symbols whose names match the string pattern. "
}], "Text",
  CellTags->{"SA.5.4", "4.2"}],

Cell[TextData[{
  StyleBox["Clear", "MR"],
  ", ",
  StyleBox["ClearAll", "MR"],
  " and ",
  StyleBox["Remove", "MR"],
  " do nothing to symbols with the attribute ",
  StyleBox["Protected", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.5.4", "4.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.5.5 Transformation Rules", "Subsection",
  CellTags->{"SA.5.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "immediate rule: ",
              StyleBox["rhs", "TI"],
              " is evaluated when the rule is first given "
            }]]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":>", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "delayed rule: ",
              StyleBox["rhs", "TI"],
              " is evaluated when the rule is used "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.5.5"],

Cell[TextData[{
  "The two basic types of transformation rules in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"SA.5.5"],

Cell[TextData[{
  "Replacements for pattern variables that appear in transformation rules are \
effectively done using ",
  StyleBox["ReplaceAll", "MR"],
  " (the ",
  StyleBox["/.", "MR"],
  " operator). "
}], "Text",
  CellTags->{"SA.5.5", "5.2"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 4}, {28, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.5.0"->{
    Cell[1776, 53, 136, 4, 65, "Section",
      CellTags->{"SA.5.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 136, 4, 65, "Section",
      CellTags->{"SA.5.0", "0.1"}]},
  "SA.5.1"->{
    Cell[1937, 61, 67, 1, 70, "Subsection",
      CellTags->{"SA.5.1", "1.1"}],
    Cell[2007, 64, 232, 6, 70, "Text",
      CellTags->{"SA.5.1", "1.2"}],
    Cell[2242, 72, 8046, 246, 70, "DefinitionBox",
      CellTags->"SA.5.1"],
    Cell[10291, 320, 58, 1, 70, "Caption",
      CellTags->"SA.5.1"],
    Cell[10352, 323, 414, 16, 70, "Text",
      CellTags->{"SA.5.1", "1.3"}],
    Cell[10769, 341, 239, 8, 70, "Text",
      CellTags->{"SA.5.1", "1.4"}],
    Cell[11011, 351, 968, 45, 70, "Text",
      CellTags->{"SA.5.1", "1.5"}],
    Cell[11982, 398, 921, 31, 70, "Text",
      CellTags->{"SA.5.1", "1.6"}],
    Cell[12906, 431, 2011, 59, 70, "DefinitionBox",
      CellTags->"SA.5.1"],
    Cell[14920, 492, 57, 1, 70, "Caption",
      CellTags->"SA.5.1"],
    Cell[14980, 495, 1003, 39, 70, "Text",
      CellTags->{"SA.5.1", "1.7"}],
    Cell[15986, 536, 374, 12, 70, "Text",
      CellTags->{"SA.5.1", "1.8"}],
    Cell[16363, 550, 1948, 62, 70, "DefinitionBox",
      CellTags->"SA.5.1"],
    Cell[18314, 614, 79, 1, 70, "Caption",
      CellTags->"SA.5.1"],
    Cell[18396, 617, 725, 27, 70, "Text",
      CellTags->{"SA.5.1", "1.9"}]},
  "1.1"->{
    Cell[1937, 61, 67, 1, 70, "Subsection",
      CellTags->{"SA.5.1", "1.1"}]},
  "1.2"->{
    Cell[2007, 64, 232, 6, 70, "Text",
      CellTags->{"SA.5.1", "1.2"}]},
  "1.3"->{
    Cell[10352, 323, 414, 16, 70, "Text",
      CellTags->{"SA.5.1", "1.3"}]},
  "1.4"->{
    Cell[10769, 341, 239, 8, 70, "Text",
      CellTags->{"SA.5.1", "1.4"}]},
  "1.5"->{
    Cell[11011, 351, 968, 45, 70, "Text",
      CellTags->{"SA.5.1", "1.5"}]},
  "1.6"->{
    Cell[11982, 398, 921, 31, 70, "Text",
      CellTags->{"SA.5.1", "1.6"}]},
  "1.7"->{
    Cell[14980, 495, 1003, 39, 70, "Text",
      CellTags->{"SA.5.1", "1.7"}]},
  "1.8"->{
    Cell[15986, 536, 374, 12, 70, "Text",
      CellTags->{"SA.5.1", "1.8"}]},
  "1.9"->{
    Cell[18396, 617, 725, 27, 70, "Text",
      CellTags->{"SA.5.1", "1.9"}]},
  "SA.5.2"->{
    Cell[19158, 649, 70, 1, 70, "Subsection",
      CellTags->{"SA.5.2", "2.1"}],
    Cell[19231, 652, 1018, 32, 70, "DefinitionBox",
      CellTags->"SA.5.2"],
    Cell[20252, 686, 135, 5, 70, "Caption",
      CellTags->"SA.5.2"],
    Cell[20390, 693, 283, 8, 70, "Text",
      CellTags->{"SA.5.2", "2.2"}],
    Cell[20676, 703, 1748, 56, 70, "DefinitionBox",
      CellTags->"SA.5.2"],
    Cell[22427, 761, 88, 1, 70, "Caption",
      CellTags->"SA.5.2"],
    Cell[22518, 764, 490, 19, 70, "Text",
      CellTags->{"SA.5.2", "2.3"}],
    Cell[23011, 785, 440, 16, 70, "Text",
      CellTags->{"SA.5.2", "2.4"}],
    Cell[23454, 803, 457, 10, 70, "Text",
      CellTags->{"SA.5.2", "2.5"}],
    Cell[23914, 815, 837, 15, 142, "Notes",
      CellTags->{"SA.5.2", "2.6"}]},
  "2.1"->{
    Cell[19158, 649, 70, 1, 70, "Subsection",
      CellTags->{"SA.5.2", "2.1"}]},
  "2.2"->{
    Cell[20390, 693, 283, 8, 70, "Text",
      CellTags->{"SA.5.2", "2.2"}]},
  "2.3"->{
    Cell[22518, 764, 490, 19, 70, "Text",
      CellTags->{"SA.5.2", "2.3"}]},
  "2.4"->{
    Cell[23011, 785, 440, 16, 70, "Text",
      CellTags->{"SA.5.2", "2.4"}]},
  "2.5"->{
    Cell[23454, 803, 457, 10, 70, "Text",
      CellTags->{"SA.5.2", "2.5"}]},
  "2.6"->{
    Cell[23914, 815, 837, 15, 142, "Notes",
      CellTags->{"SA.5.2", "2.6"}]},
  "SA.5.3"->{
    Cell[24788, 835, 74, 1, 70, "Subsection",
      CellTags->{"SA.5.3", "3.1"}],
    Cell[24865, 838, 4079, 137, 214, "DefinitionBox",
      CellTags->"SA.5.3"],
    Cell[28947, 977, 82, 1, 16, "Caption",
      CellTags->"SA.5.3"]},
  "3.1"->{
    Cell[24788, 835, 74, 1, 70, "Subsection",
      CellTags->{"SA.5.3", "3.1"}]},
  "SA.5.4"->{
    Cell[29066, 983, 88, 1, 38, "Subsection",
      CellTags->{"SA.5.4", "4.1"}],
    Cell[29157, 986, 4215, 124, 184, "DefinitionBox",
      CellTags->"SA.5.4"],
    Cell[33375, 1112, 75, 1, 16, "Caption",
      CellTags->"SA.5.4"],
    Cell[33453, 1115, 284, 9, 40, "Text",
      CellTags->{"SA.5.4", "4.2"}],
    Cell[33740, 1126, 248, 10, 24, "Text",
      CellTags->{"SA.5.4", "4.3"}]},
  "4.1"->{
    Cell[29066, 983, 88, 1, 38, "Subsection",
      CellTags->{"SA.5.4", "4.1"}]},
  "4.2"->{
    Cell[33453, 1115, 284, 9, 40, "Text",
      CellTags->{"SA.5.4", "4.2"}]},
  "4.3"->{
    Cell[33740, 1126, 248, 10, 24, "Text",
      CellTags->{"SA.5.4", "4.3"}]},
  "SA.5.5"->{
    Cell[34025, 1141, 79, 1, 38, "Subsection",
      CellTags->{"SA.5.5", "5.1"}],
    Cell[34107, 1144, 945, 30, 102, "DefinitionBox",
      CellTags->"SA.5.5"],
    Cell[35055, 1176, 145, 5, 16, "Caption",
      CellTags->"SA.5.5"],
    Cell[35203, 1183, 249, 8, 40, "Text",
      CellTags->{"SA.5.5", "5.2"}]},
  "5.1"->{
    Cell[34025, 1141, 79, 1, 38, "Subsection",
      CellTags->{"SA.5.5", "5.1"}]},
  "5.2"->{
    Cell[35203, 1183, 249, 8, 40, "Text",
      CellTags->{"SA.5.5", "5.2"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.5.0", 36093, 1211},
  {"0.1", 36183, 1214},
  {"SA.5.1", 36276, 1217},
  {"1.1", 37435, 1248},
  {"1.2", 37527, 1251},
  {"1.3", 37614, 1254},
  {"1.4", 37704, 1257},
  {"1.5", 37793, 1260},
  {"1.6", 37883, 1263},
  {"1.7", 37973, 1266},
  {"1.8", 38064, 1269},
  {"1.9", 38154, 1272},
  {"SA.5.2", 38247, 1275},
  {"2.1", 39031, 1296},
  {"2.2", 39125, 1299},
  {"2.3", 39214, 1302},
  {"2.4", 39304, 1305},
  {"2.5", 39394, 1308},
  {"2.6", 39484, 1311},
  {"SA.5.3", 39579, 1314},
  {"3.1", 39824, 1321},
  {"SA.5.4", 39921, 1324},
  {"4.1", 40324, 1335},
  {"4.2", 40418, 1338},
  {"4.3", 40508, 1341},
  {"SA.5.5", 40602, 1344},
  {"5.1", 40927, 1353},
  {"5.2", 41022, 1356}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 136, 4, 65, "Section",
  CellTags->{"SA.5.0", "0.1"}],

Cell[CellGroupData[{
Cell[1937, 61, 67, 1, 70, "Subsection",
  CellTags->{"SA.5.1", "1.1"}],
Cell[2007, 64, 232, 6, 70, "Text",
  CellTags->{"SA.5.1", "1.2"}],
Cell[2242, 72, 8046, 246, 70, "DefinitionBox",
  CellTags->"SA.5.1"],
Cell[10291, 320, 58, 1, 70, "Caption",
  CellTags->"SA.5.1"],
Cell[10352, 323, 414, 16, 70, "Text",
  CellTags->{"SA.5.1", "1.3"}],
Cell[10769, 341, 239, 8, 70, "Text",
  CellTags->{"SA.5.1", "1.4"}],
Cell[11011, 351, 968, 45, 70, "Text",
  CellTags->{"SA.5.1", "1.5"}],
Cell[11982, 398, 921, 31, 70, "Text",
  CellTags->{"SA.5.1", "1.6"}],
Cell[12906, 431, 2011, 59, 70, "DefinitionBox",
  CellTags->"SA.5.1"],
Cell[14920, 492, 57, 1, 70, "Caption",
  CellTags->"SA.5.1"],
Cell[14980, 495, 1003, 39, 70, "Text",
  CellTags->{"SA.5.1", "1.7"}],
Cell[15986, 536, 374, 12, 70, "Text",
  CellTags->{"SA.5.1", "1.8"}],
Cell[16363, 550, 1948, 62, 70, "DefinitionBox",
  CellTags->"SA.5.1"],
Cell[18314, 614, 79, 1, 70, "Caption",
  CellTags->"SA.5.1"],
Cell[18396, 617, 725, 27, 70, "Text",
  CellTags->{"SA.5.1", "1.9"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[19158, 649, 70, 1, 70, "Subsection",
  CellTags->{"SA.5.2", "2.1"}],
Cell[19231, 652, 1018, 32, 70, "DefinitionBox",
  CellTags->"SA.5.2"],
Cell[20252, 686, 135, 5, 70, "Caption",
  CellTags->"SA.5.2"],
Cell[20390, 693, 283, 8, 70, "Text",
  CellTags->{"SA.5.2", "2.2"}],
Cell[20676, 703, 1748, 56, 70, "DefinitionBox",
  CellTags->"SA.5.2"],
Cell[22427, 761, 88, 1, 70, "Caption",
  CellTags->"SA.5.2"],
Cell[22518, 764, 490, 19, 70, "Text",
  CellTags->{"SA.5.2", "2.3"}],
Cell[23011, 785, 440, 16, 70, "Text",
  CellTags->{"SA.5.2", "2.4"}],
Cell[23454, 803, 457, 10, 70, "Text",
  CellTags->{"SA.5.2", "2.5"}],
Cell[23914, 815, 837, 15, 142, "Notes",
  CellTags->{"SA.5.2", "2.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[24788, 835, 74, 1, 70, "Subsection",
  CellTags->{"SA.5.3", "3.1"}],
Cell[24865, 838, 4079, 137, 214, "DefinitionBox",
  CellTags->"SA.5.3"],
Cell[28947, 977, 82, 1, 16, "Caption",
  CellTags->"SA.5.3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29066, 983, 88, 1, 38, "Subsection",
  CellTags->{"SA.5.4", "4.1"}],
Cell[29157, 986, 4215, 124, 184, "DefinitionBox",
  CellTags->"SA.5.4"],
Cell[33375, 1112, 75, 1, 16, "Caption",
  CellTags->"SA.5.4"],
Cell[33453, 1115, 284, 9, 40, "Text",
  CellTags->{"SA.5.4", "4.2"}],
Cell[33740, 1126, 248, 10, 24, "Text",
  CellTags->{"SA.5.4", "4.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[34025, 1141, 79, 1, 38, "Subsection",
  CellTags->{"SA.5.5", "5.1"}],
Cell[34107, 1144, 945, 30, 102, "DefinitionBox",
  CellTags->"SA.5.5"],
Cell[35055, 1176, 145, 5, 16, "Caption",
  CellTags->"SA.5.5"],
Cell[35203, 1183, 249, 8, 40, "Text",
  CellTags->{"SA.5.5", "5.2"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

