(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10091,        335]*)
(*NotebookOutlinePosition[     13426,        444]*)
(*  CellTagsIndexPosition[     13049,        425]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.6 ", "HeadingNumber"],
  "Files and Streams"
}], "Section",
  CellTags->{"SA.6.0", "0.1"}],

Cell[CellGroupData[{

Cell["A.6.1 File Names", "Subsection",
  CellTags->{"SA.6.1", "1.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox[".m", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " language source file "
            }]]},
          {Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox[".nb", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " notebook file "
            }]]},
          {Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox[".ma", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " notebook file from before Version 3 "
            }]]},
          {Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox[".mx", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " expression dump "
            }]]},
          {Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox[".exe", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MathLink", "TI"],
              " executable program "
            }]]},
          {Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox[".tm", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MathLink", "TI"],
              " template file "
            }]]},
          {Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox[".ml", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MathLink", "TI"],
              " stream file "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.6.1"],

Cell["Conventions for file names. ", "Caption",
  CellTags->"SA.6.1"],

Cell[TextData[{
  "Most files used by ",
  StyleBox["Mathematica", "TI"],
  " are completely system independent. ",
  StyleBox[".mx", "MR"],
  " and ",
  StyleBox[".exe", "MR"],
  " files are however system dependent. For these files, there is a \
convention that bundles of versions for different computer systems have names \
with forms such as ",
  StyleBox["name", "TI"],
  StyleBox["/$SystemID/", "MR"],
  StyleBox["name", "TI"],
  ". "
}], "Text",
  CellTags->{"SA.6.1", "1.2"}],

Cell[TextData[{
  "In general, when you refer to a file, ",
  StyleBox["Mathematica", "TI"],
  " tries to resolve its name as follows: "
}], "Text",
  CellTags->{"SA.6.1", "1.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the name starts with ",
  StyleBox["!", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " treats the remainder of the name as an external command, and uses a pipe \
to this command.  \n\[FilledSmallSquare] If the name contains metacharacters \
used by your operating system, then ",
  StyleBox["Mathematica", "TI"],
  " passes the name directly to the operating system for interpretation.  \n\
\[FilledSmallSquare] Unless the file is to be used for input, no further \
processing on the name is done.  \n\[FilledSmallSquare] Unless the name given \
is an absolute file name under your operating system, ",
  StyleBox["Mathematica", "TI"],
  " will search each of the directories specified in the list ",
  StyleBox["$Path", "MR"],
  ".  \n\[FilledSmallSquare] If what is found is a directory rather than a \
file, then ",
  StyleBox["Mathematica", "TI"],
  " will look for a file ",
  StyleBox["name", "TI"],
  StyleBox["/$SystemID/", "MR"],
  StyleBox["name", "TI"],
  ".  "
}], "Notes",
  CellTags->{"SA.6.1", "1.4"}],

Cell[TextData[{
  "For names of the form ",
  StyleBox["name", "TI"],
  StyleBox["`", "MR"],
  " the following further translations are done in ",
  StyleBox["Get", "MR"],
  " and related functions: "
}], "Text",
  CellTags->{"SA.6.1", "1.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] A file ",
  StyleBox["name", "TI"],
  StyleBox[".mx", "MR"],
  " is used if it exists.  \n\[FilledSmallSquare] A file ",
  StyleBox["name", "TI"],
  StyleBox[".m", "MR"],
  " is used if it exists.  "
}], "Notes",
  CellTags->{"SA.6.1", "1.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["name", "TI"],
  " is a directory, then the file ",
  StyleBox["name", "TI"],
  StyleBox["/init.m", "MR"],
  " is used if it exists.  \n\[FilledSmallSquare] If ",
  StyleBox["name.mx", "MR"],
  " is a directory, then ",
  StyleBox["name", "TI"],
  StyleBox[".mx/$SystemID/", "MR"],
  StyleBox["name", "TI"],
  StyleBox[".mx", "MR"],
  " is used if it exists.  "
}], "Notes",
  CellTags->{"SA.6.1", "1.7"}],

Cell[TextData[{
  "In ",
  StyleBox["Install", "MR"],
  ", ",
  StyleBox["name", "TI"],
  StyleBox["`", "MR"],
  " is taken to refer to a file or directory named ",
  StyleBox["name", "TI"],
  StyleBox[".exe", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.6.1", "1.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.6.2 Streams", "Subsection",
  CellTags->{"SA.6.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["InputStream[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["input from a file or pipe "]},
          {Cell[TextData[{
              StyleBox["OutputStream[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["output to a file or pipe "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.6.2"],

Cell["Types of streams. ", "Caption",
  CellTags->"SA.6.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["CharacterEncoding", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["$CharacterEncoding", "MR"],
              " "
            }]], Cell["encoding to use for special characters "]},
          {Cell[TextData[{
              StyleBox["BinaryFormat", "MR"],
              " "
            }]], Cell[TextData[{
              ButtonBox["False",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[
            "whether to treat the file as being in binary format "]},
          {Cell[TextData[{
              StyleBox["FormatType", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["InputForm", "MR"],
              " "
            }]], Cell["default format for expressions "]},
          {Cell[TextData[{
              StyleBox["PageWidth", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["78", "MR"],
              " "
            }]], Cell["number of characters per line "]},
          {Cell[TextData[{
              StyleBox["TotalWidth", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Infinity", "MR"],
              " "
            }]], Cell[
            "maximum number of characters in a single expression "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"SA.6.2"],

Cell["Options for output streams. ", "Caption",
  CellTags->"SA.6.2"],

Cell[TextData[{
  "You can test options for streams using ",
  StyleBox["Options", "MR"],
  ", and reset them using ",
  StyleBox["SetOptions", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.6.2", "2.2"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{50, Automatic}, {Automatic, 29}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.6.0"->{
    Cell[1776, 53, 120, 4, 65, "Section",
      CellTags->{"SA.6.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 120, 4, 65, "Section",
      CellTags->{"SA.6.0", "0.1"}]},
  "SA.6.1"->{
    Cell[1921, 61, 69, 1, 70, "Subsection",
      CellTags->{"SA.6.1", "1.1"}],
    Cell[1993, 64, 1965, 62, 70, "DefinitionBox",
      CellTags->"SA.6.1"],
    Cell[3961, 128, 69, 1, 70, "Caption",
      CellTags->"SA.6.1"],
    Cell[4033, 131, 484, 15, 72, "Text",
      CellTags->{"SA.6.1", "1.2"}],
    Cell[4520, 148, 179, 5, 70, "Text",
      CellTags->{"SA.6.1", "1.3"}],
    Cell[4702, 155, 1064, 25, 176, "Notes",
      CellTags->{"SA.6.1", "1.4"}],
    Cell[5769, 182, 243, 8, 40, "Text",
      CellTags->{"SA.6.1", "1.5"}],
    Cell[6015, 192, 283, 9, 46, "Notes",
      CellTags->{"SA.6.1", "1.6"}],
    Cell[6301, 203, 462, 15, 62, "Notes",
      CellTags->{"SA.6.1", "1.7"}],
    Cell[6766, 220, 266, 11, 24, "Text",
      CellTags->{"SA.6.1", "1.8"}]},
  "1.1"->{
    Cell[1921, 61, 69, 1, 70, "Subsection",
      CellTags->{"SA.6.1", "1.1"}]},
  "1.2"->{
    Cell[4033, 131, 484, 15, 72, "Text",
      CellTags->{"SA.6.1", "1.2"}]},
  "1.3"->{
    Cell[4520, 148, 179, 5, 70, "Text",
      CellTags->{"SA.6.1", "1.3"}]},
  "1.4"->{
    Cell[4702, 155, 1064, 25, 176, "Notes",
      CellTags->{"SA.6.1", "1.4"}]},
  "1.5"->{
    Cell[5769, 182, 243, 8, 40, "Text",
      CellTags->{"SA.6.1", "1.5"}]},
  "1.6"->{
    Cell[6015, 192, 283, 9, 46, "Notes",
      CellTags->{"SA.6.1", "1.6"}]},
  "1.7"->{
    Cell[6301, 203, 462, 15, 62, "Notes",
      CellTags->{"SA.6.1", "1.7"}]},
  "1.8"->{
    Cell[6766, 220, 266, 11, 24, "Text",
      CellTags->{"SA.6.1", "1.8"}]},
  "SA.6.2"->{
    Cell[7069, 236, 66, 1, 38, "Subsection",
      CellTags->{"SA.6.2", "2.1"}],
    Cell[7138, 239, 826, 24, 66, "DefinitionBox",
      CellTags->"SA.6.2"],
    Cell[7967, 265, 59, 1, 16, "Caption",
      CellTags->"SA.6.2"],
    Cell[8029, 268, 1759, 51, 206, "DefinitionBox3Col",
      CellTags->"SA.6.2"],
    Cell[9791, 321, 69, 1, 16, "Caption",
      CellTags->"SA.6.2"],
    Cell[9863, 324, 200, 7, 24, "Text",
      CellTags->{"SA.6.2", "2.2"}]},
  "2.1"->{
    Cell[7069, 236, 66, 1, 38, "Subsection",
      CellTags->{"SA.6.2", "2.1"}]},
  "2.2"->{
    Cell[9863, 324, 200, 7, 24, "Text",
      CellTags->{"SA.6.2", "2.2"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.6.0", 10705, 351},
  {"0.1", 10795, 354},
  {"SA.6.1", 10888, 357},
  {"1.1", 11667, 378},
  {"1.2", 11759, 381},
  {"1.3", 11848, 384},
  {"1.4", 11936, 387},
  {"1.5", 12028, 390},
  {"1.6", 12116, 393},
  {"1.7", 12205, 396},
  {"1.8", 12295, 399},
  {"SA.6.2", 12387, 402},
  {"2.1", 12854, 415},
  {"2.2", 12947, 418}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 120, 4, 65, "Section",
  CellTags->{"SA.6.0", "0.1"}],

Cell[CellGroupData[{
Cell[1921, 61, 69, 1, 70, "Subsection",
  CellTags->{"SA.6.1", "1.1"}],
Cell[1993, 64, 1965, 62, 70, "DefinitionBox",
  CellTags->"SA.6.1"],
Cell[3961, 128, 69, 1, 70, "Caption",
  CellTags->"SA.6.1"],
Cell[4033, 131, 484, 15, 72, "Text",
  CellTags->{"SA.6.1", "1.2"}],
Cell[4520, 148, 179, 5, 70, "Text",
  CellTags->{"SA.6.1", "1.3"}],
Cell[4702, 155, 1064, 25, 176, "Notes",
  CellTags->{"SA.6.1", "1.4"}],
Cell[5769, 182, 243, 8, 40, "Text",
  CellTags->{"SA.6.1", "1.5"}],
Cell[6015, 192, 283, 9, 46, "Notes",
  CellTags->{"SA.6.1", "1.6"}],
Cell[6301, 203, 462, 15, 62, "Notes",
  CellTags->{"SA.6.1", "1.7"}],
Cell[6766, 220, 266, 11, 24, "Text",
  CellTags->{"SA.6.1", "1.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7069, 236, 66, 1, 38, "Subsection",
  CellTags->{"SA.6.2", "2.1"}],
Cell[7138, 239, 826, 24, 66, "DefinitionBox",
  CellTags->"SA.6.2"],
Cell[7967, 265, 59, 1, 16, "Caption",
  CellTags->"SA.6.2"],
Cell[8029, 268, 1759, 51, 206, "DefinitionBox3Col",
  CellTags->"SA.6.2"],
Cell[9791, 321, 69, 1, 16, "Caption",
  CellTags->"SA.6.2"],
Cell[9863, 324, 200, 7, 24, "Text",
  CellTags->{"SA.6.2", "2.2"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

