(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     24204,        805]*)
(*NotebookOutlinePosition[     31616,       1040]*)
(*  CellTagsIndexPosition[     30790,       1002]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.7 ", "HeadingNumber"],
  StyleBox["Mathematica", "SBO"],
  " Sessions"
}], "Section",
  CellTags->{"SA.7.0", "0.1"}],

Cell[CellGroupData[{

Cell["\<\
A.7.1 Command\[Hyphen]Line Options and Environment Variables\
\>", \
"Subsection",
  CellTags->{"SA.7.1", "1.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["-pwfile", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " password file "
            }]]},
          {Cell[TextData[{
              StyleBox["-pwpath", "MR"],
              " "
            }]], Cell[TextData[{
              "path to search for a ",
              StyleBox["Mathematica", "TI"],
              " password file "
            }]]},
          {Cell[TextData[{
              StyleBox["-run", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " input to run (kernel only) "
            }]]},
          {Cell[TextData[{
              StyleBox["-initfile", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " initialization file "
            }]]},
          {Cell[TextData[{
              StyleBox["-initpath", "MR"],
              " "
            }]], Cell["path to search for initialization files "]},
          {Cell[TextData[{
              StyleBox["-noinit", "MR"],
              " "
            }]], Cell["do not run initialization files "]},
          {Cell[TextData[{
              StyleBox["-mathlink", "MR"],
              " "
            }]], Cell[TextData[{
              "communicate only via ",
              StyleBox["MathLink", "TI"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.7.1"],

Cell[TextData[{
  "Typical command\[Hyphen]line options for ",
  StyleBox["Mathematica", "SO"],
  " executables. "
}], "Caption",
  CellTags->"SA.7.1"],

Cell[TextData[{
  "If the ",
  StyleBox["Mathematica", "TI"],
  " front end is called with a notebook file as a command\[Hyphen]line \
argument, then this notebook will be made the initial selected notebook. \
Otherwise, a new notebook will be created for this purpose. "
}], "Text",
  CellTags->{"SA.7.1", "1.2"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " kernels and front ends can also take additional command\[Hyphen]line \
options specific to particular window environments. "
}], "Text",
  CellTags->{"SA.7.1", "1.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$MATHINIT", "MR"],
              " "
            }]], Cell[TextData[{
              "command\[Hyphen]line environment for the ",
              StyleBox["Mathematica", "TI"],
              " front end, as well as ",
              StyleBox["MathReader", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["$MATHKERNELINIT", "MR"],
              " "
            }]], Cell[TextData[{
              "command\[Hyphen]line environment for the ",
              StyleBox["Mathematica", "TI"],
              " kernel "
            }]]},
          {Cell[TextData[{
              StyleBox["$MATHEMATICA_BASE", "MR"],
              " "
            }]], Cell[TextData[{
              "setting for ",
              StyleBox["$BaseDirectory", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["$MATHEMATICA_USERBASE", "MR"],
              " "
            }]], Cell[TextData[{
              "setting for ",
              StyleBox["$UserBaseDirectory", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.7.1"],

Cell["Environment variables. ", "Caption",
  CellTags->"SA.7.1"],

Cell[TextData[{
  "If no command\[Hyphen]line options are explicitly given, ",
  StyleBox["Mathematica", "TI"],
  " will read the values of operating system environment variables, and will \
use these values like command lines. "
}], "Text",
  CellTags->{"SA.7.1", "1.4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.7.2 Initialization", "Subsection",
  CellTags->{"SA.7.2", "2.1"}],

Cell[TextData[{
  "On startup, the ",
  StyleBox["Mathematica", "TI"],
  " kernel does the following: "
}], "Text",
  CellTags->{"SA.7.2", "2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Perform license management operations.  \n\
\[FilledSmallSquare] Run ",
  StyleBox["Mathematica", "TI"],
  " commands specified in any ",
  StyleBox["-run", "MR"],
  " options passed to the kernel executable.  \n\[FilledSmallSquare] Run the \
",
  StyleBox["Mathematica", "TI"],
  " commands in the system\[Hyphen]wide kernel ",
  StyleBox["init.m", "MR"],
  " file.  \n\[FilledSmallSquare] Run the ",
  StyleBox["Mathematica", "TI"],
  " commands in the user\[Hyphen]specific kernel ",
  StyleBox["init.m", "MR"],
  " file.  \n\[FilledSmallSquare] Load ",
  StyleBox["init.m", "MR"],
  " and ",
  StyleBox["Kernel/init.m", "MR"],
  " files in ",
  StyleBox["Autoload", "MR"],
  " directories.  \n\[FilledSmallSquare] Begin running the main loop.   "
}], "Notes",
  CellTags->{"SA.7.2", "2.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.7.3 The Main Loop", "Subsection",
  CellTags->{"SA.7.3", "3.1"}],

Cell[TextData[{
  "All ",
  StyleBox["Mathematica", "TI"],
  " sessions repeatedly execute the following main loop: "
}], "Text",
  CellTags->{"SA.7.3", "3.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Read in input.  \n\[FilledSmallSquare] Apply ",
  StyleBox["$PreRead", "MR"],
  " function, if defined, to the input string.  \n\[FilledSmallSquare] Print \
syntax warnings if necessary.  \n\[FilledSmallSquare] Apply ",
  StyleBox["$SyntaxHandler", "MR"],
  " function if there is a syntax error.  \n\[FilledSmallSquare] Assign ",
  StyleBox["InString[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ".  \n\[FilledSmallSquare] Apply ",
  StyleBox["$Pre", "MR"],
  " function, if defined, to the input expression.  \n\[FilledSmallSquare] \
Assign ",
  StyleBox["In[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ".  \n\[FilledSmallSquare] Evaluate expression.  \n\[FilledSmallSquare] \
Apply ",
  StyleBox["$Post", "MR"],
  " function, if defined.  \n\[FilledSmallSquare] Assign ",
  StyleBox["Out[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ", stripping off any formatting wrappers.  \n\[FilledSmallSquare] Apply ",
  StyleBox["$PrePrint", "MR"],
  " function, if defined.  \n\[FilledSmallSquare] Assign ",
  StyleBox["MessageList[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " and clear ",
  StyleBox["$MessageList", "MR"],
  ".  \n\[FilledSmallSquare] Print expression, if it is not ",
  StyleBox["Null", "MR"],
  ".  \n\[FilledSmallSquare] Increment ",
  StyleBox["$Line", "MR"],
  ".  \n\[FilledSmallSquare] Clear any pending aborts.  "
}], "Notes",
  CellTags->{"SA.7.3", "3.3"}],

Cell[TextData[{
  "Note that if you call ",
  StyleBox["Mathematica", "TI"],
  " via ",
  StyleBox["MathLink", "TI"],
  " from within an external program, then you must effectively create your \
own main loop, which will usually differ from the one described above. "
}], "Text",
  CellTags->{"SA.7.3", "3.4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.7.4 Messages", "Subsection",
  CellTags->{"SA.7.4", "4.1"}],

Cell[TextData[{
  "During a ",
  StyleBox["Mathematica", "TI"],
  " session messages can be generated either by explicit calls to ",
  StyleBox["Message", "MR"],
  ", or in the course of executing other built\[Hyphen]in functions. "
}], "Text",
  CellTags->{"SA.7.4", "4.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["::", "MR"],
              StyleBox["name", "TI"],
              StyleBox["::", "MR"],
              StyleBox["lang", "TI"],
              " "
            }]], Cell["a message in a specific language "]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["::", "MR"],
              StyleBox["name", "TI"],
              " "
            }]], Cell["a message in a default language "]},
          {Cell[TextData[{
              StyleBox["General::", "MR"],
              StyleBox["name", "TI"],
              " "
            }]], Cell["a general message with a given name "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.7.4"],

Cell["Message names. ", "Caption",
  CellTags->"SA.7.4"],

Cell[TextData[{
  "If no language is specified for a particular message, text for the message \
is sought in each of the languages specified by ",
  StyleBox["$Language", "MR"],
  ". If ",
  StyleBox["f", "TI"],
  StyleBox["::", "MR"],
  StyleBox["name", "TI"],
  " is not defined, a definition for ",
  StyleBox["General::", "MR"],
  StyleBox["name", "TI"],
  " is sought. If still no message is found, any value defined for ",
  StyleBox["$NewMessage", "MR"],
  " is applied to ",
  StyleBox["f", "TI"],
  " and ",
  StyleBox["\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\"", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.7.4", "4.3"}],

Cell[TextData[{
  StyleBox["Off[", "MR"],
  StyleBox["message", "TI"],
  StyleBox["]", "MR"],
  " prevents a specified message from ever being printed. ",
  StyleBox["Check", "MR"],
  " allows you to determine whether particular messages were generated during \
the evaluation of an expression. ",
  StyleBox["$MessageList", "MR"],
  " and ",
  StyleBox["MessageList[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " record all the messages that were generated during the evaluation of a \
particular line in a ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Text",
  CellTags->{"SA.7.4", "4.4"}],

Cell[TextData[{
  "Messages are specified as strings to be used as the first argument of ",
  StyleBox["StringForm", "MR"],
  ". ",
  StyleBox["$MessagePrePrint", "MR"],
  " is applied to each expression to be spliced into the string. "
}], "Text",
  CellTags->{"SA.7.4", "4.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.7.5 Termination", "Subsection",
  CellTags->{"SA.7.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Exit[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Quit[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "terminate ",
              StyleBox["Mathematica", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["$Epilog", "MR"],
              " "
            }]], Cell[TextData[{
              "symbol to evaluate before ",
              StyleBox["Mathematica", "TI"],
              " exits "
            }]]},
          {Cell[TextData[{
              StyleBox["$IgnoreEOF", "MR"],
              " "
            }]], Cell[TextData[{
              "whether to exit an interactive ",
              StyleBox["Mathematica", "TI"],
              
              " session when an end\[Hyphen]of\[Hyphen]file character is \
received "
            }]]},
          {Cell[TextData[{
              StyleBox["end.m", "MR"],
              " "
            }]], Cell[TextData[{
              "file to read when ",
              StyleBox["Mathematica", "TI"],
              " terminates "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.7.5"],

Cell[TextData[{
  StyleBox["Mathematica", "SO"],
  " termination. "
}], "Caption",
  CellTags->"SA.7.5"],

Cell[TextData[{
  "There are several ways to end a ",
  StyleBox["Mathematica", "TI"],
  " session. If you are using ",
  StyleBox["Mathematica", "TI"],
  " interactively, typing ",
  StyleBox["Exit[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " or ",
  StyleBox["Quit[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " on an input line will always terminate ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"SA.7.5", "5.2"}],

Cell[TextData[{
  "If you are taking input for ",
  StyleBox["Mathematica", "TI"],
  " from a file, ",
  StyleBox["Mathematica", "TI"],
  " will exit when it reaches the end of the file. If you are using ",
  StyleBox["Mathematica", "TI"],
  " interactively, it will still exit if it receives an end\[Hyphen]of\
\[Hyphen]file character (typically \[ControlKey]\[LeftModified]",
  StyleBox["d\[RightModified]", "MR"],
  "). You can stop ",
  StyleBox["Mathematica", "TI"],
  " from doing this by setting ",
  StyleBox["$IgnoreEOF=True", "MR"],
  ".  "
}], "Text",
  CellTags->{"SA.7.5", "5.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.7.6 Network License Management", "Subsection",
  CellTags->{"SA.7.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["single\[Hyphen]machine license", "TI"],
              " "
            }]], Cell["a process must always run on a specific machine "]},
          {Cell[TextData[{
              StyleBox["network license", "TI"],
              " "
            }]], Cell["a process can run on any machine on a network "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.7.6"],

Cell["\<\
Single\[Hyphen]machine and network licenses. \
\>", "Caption",
  CellTags->"SA.7.6"],

Cell[TextData[{
  "Copies of ",
  StyleBox["Mathematica", "TI"],
  " can be set up with either single\[Hyphen]machine or network licenses. A \
network license is indicated by a line in the ",
  StyleBox["mathpass", "MR"],
  " file starting with ",
  StyleBox["!", "MR"],
  StyleBox["name", "TI"],
  ", where ",
  StyleBox["name", "TI"],
  " is the name of the server machine for the network license. "
}], "Text",
  CellTags->{"SA.7.6", "6.2"}],

Cell[TextData[{
  "Network licenses are controlled by the ",
  StyleBox["Mathematica", "TI"],
  " license management program ",
  StyleBox["mathlm", "MR"],
  ". This program must be running whenever a ",
  StyleBox["Mathematica", "TI"],
  " with a network license is being used. Typically you will want to set up \
your system so that ",
  StyleBox["mathlm", "MR"],
  " is started whenever the system boots.  "
}], "Text",
  CellTags->{"SA.7.6", "6.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] Type ",
              StyleBox[".\[Backslash]mathlm", "MR"],
              " directly on the command line "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Add ",
              StyleBox["mathlm", "MR"],
              " as a Windows service "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.7.6"],

Cell["\<\
Ways to start the network license manager under Microsoft Windows. \
\
\>", "Caption",
  CellTags->"SA.7.6"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] Type ",
              StyleBox["./mathlm", "MR"],
              " directly on the Unix command line "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Add a line to start ",
              StyleBox["mathlm", "MR"],
              " in your central system startup script "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.7.6"],

Cell["\<\
Ways to start the network license manager on Macintosh and Unix \
systems. \
\>", "Caption",
  CellTags->"SA.7.6"],

Cell[TextData[{
  "When ",
  StyleBox["mathlm", "MR"],
  " is not started directly from a command line, it normally sets itself up \
as a background process, and continues running until it is explicitly \
terminated. Note that if one ",
  StyleBox["mathlm", "MR"],
  " process is running, any other ",
  StyleBox["mathlm", "MR"],
  " processes you try to start will automatically exit immediately. "
}], "Text",
  CellTags->{"SA.7.6", "6.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["-logfile", "MR"],
              " ",
              StyleBox["file", "TI"],
              " "
            }]], Cell[TextData[{
              "write a log of license server actions to ",
              StyleBox["file", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["-loglevel", "MR"],
              " ",
              StyleBox["n", "TI"],
              " "
            }]], Cell["how verbose to make log entries (1 to 4) "]},
          {Cell[TextData[{
              StyleBox["-logformat", "MR"],
              " ",
              StyleBox["string", "TI"],
              " "
            }]], Cell[TextData[{
              "use a log format specified by ",
              StyleBox["string", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["-language", "MR"],
              " ",
              StyleBox["name", "TI"],
              " "
            }]], Cell[TextData[{
              "language to use for messages (default ",
              StyleBox["English", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["-pwfile", "MR"],
              " ",
              StyleBox["file", "TI"],
              " "
            }]], Cell[TextData[{
              "use the specified ",
              StyleBox["mathpass", "MR"],
              " file (default ",
              StyleBox["./mathpass", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["-timeout", "MR"],
              " ",
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "suspend authorization on stopped ",
              StyleBox["Mathematica", "TI"],
              " jobs after ",
              StyleBox["n", "TI"],
              " hours "
            }]]},
          {Cell[TextData[{
              StyleBox["-restrict", "MR"],
              " ",
              StyleBox["file", "TI"],
              " "
            }]], Cell["use the specified restriction file "]},
          {Cell[TextData[{
              StyleBox["-mathid", "MR"],
              " "
            }]], Cell["print the MathID for the license server, and exit "]},
          {Cell[TextData[{
              StyleBox["-foreground", "MR"],
              " "
            }]], Cell[TextData[{
              "run ",
              StyleBox["mathlm", "MR"],
              " in the foreground, logging to ",
              StyleBox["stdout", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["-install", "MR"],
              " "
            }]], Cell[TextData[{
              "install ",
              StyleBox["mathlm", "MR"],
              " as a Windows service (Microsoft Windows only) "
            }]]},
          {Cell[TextData[{
              StyleBox["-uninstall", "MR"],
              " "
            }]], Cell[TextData[{
              "uninstall ",
              StyleBox["mathlm", "MR"],
              " as a Windows service (Microsoft Windows only) "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.7.6"],

Cell[TextData[{
  "Some command\[Hyphen]line options for ",
  StyleBox["mathlm", "MR"],
  ". "
}], "Caption",
  CellTags->"SA.7.6"],

Cell[TextData[{
  "For more detailed information on ",
  StyleBox["mathlm", "MR"],
  ", see the ",
  StyleBox["Mathematica Products System Administration Guide", "TI"],
  ". "
}], "Text",
  CellTags->{"SA.7.6", "6.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["monitorlm", "MR"],
              " "
            }]], Cell["a program to monitor network license activity "]},
          {Cell[TextData[{
              StyleBox["monitorlm", "MR"],
              " ",
              StyleBox["name", "TI"],
              " "
            }]], Cell[TextData[{
              "monitor activity for license server ",
              StyleBox["name", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.7.6"],

Cell["Monitoring network license activity. ", "Caption",
  CellTags->"SA.7.6"],

Cell[TextData[{
  "If ",
  StyleBox["monitorlm", "MR"],
  " is run in an environment where a web browser can be started, it will \
automatically generate HTML output in the browser. Otherwise it will generate \
plain text. "
}], "Text",
  CellTags->{"SA.7.6", "6.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["-file", "MR"],
              " ",
              StyleBox["file", "TI"],
              " "
            }]], Cell["write output to a file "]},
          {Cell[TextData[{
              StyleBox["-format", "MR"],
              " ",
              StyleBox["spec", "TI"],
              " "
            }]], Cell[TextData[{
              "use the specified format (",
              StyleBox["text", "MR"],
              ", ",
              StyleBox["html", "MR"],
              " or ",
              StyleBox["cgi", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["-template", "MR"],
              " ",
              StyleBox["file", "TI"],
              " "
            }]], Cell[
            "use the specified file as a template for the output "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.7.6"],

Cell[TextData[{
  "Some command\[Hyphen]line options for ",
  StyleBox["monitorlm", "MR"],
  ". "
}], "Caption",
  CellTags->"SA.7.6"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.7.0"->{
    Cell[1776, 53, 146, 5, 65, "Section",
      CellTags->{"SA.7.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 146, 5, 65, "Section",
      CellTags->{"SA.7.0", "0.1"}]},
  "SA.7.1"->{
    Cell[1947, 62, 123, 4, 70, "Subsection",
      CellTags->{"SA.7.1", "1.1"}],
    Cell[2073, 68, 1638, 50, 70, "DefinitionBox",
      CellTags->"SA.7.1"],
    Cell[3714, 120, 151, 5, 70, "Caption",
      CellTags->"SA.7.1"],
    Cell[3868, 127, 314, 7, 70, "Text",
      CellTags->{"SA.7.1", "1.2"}],
    Cell[4185, 136, 220, 5, 70, "Text",
      CellTags->{"SA.7.1", "1.3"}],
    Cell[4408, 143, 1299, 39, 70, "DefinitionBox",
      CellTags->"SA.7.1"],
    Cell[5710, 184, 64, 1, 70, "Caption",
      CellTags->"SA.7.1"],
    Cell[5777, 187, 272, 6, 70, "Text",
      CellTags->{"SA.7.1", "1.4"}]},
  "1.1"->{
    Cell[1947, 62, 123, 4, 70, "Subsection",
      CellTags->{"SA.7.1", "1.1"}]},
  "1.2"->{
    Cell[3868, 127, 314, 7, 70, "Text",
      CellTags->{"SA.7.1", "1.2"}]},
  "1.3"->{
    Cell[4185, 136, 220, 5, 70, "Text",
      CellTags->{"SA.7.1", "1.3"}]},
  "1.4"->{
    Cell[5777, 187, 272, 6, 70, "Text",
      CellTags->{"SA.7.1", "1.4"}]},
  "SA.7.2"->{
    Cell[6086, 198, 73, 1, 70, "Subsection",
      CellTags->{"SA.7.2", "2.1"}],
    Cell[6162, 201, 146, 5, 70, "Text",
      CellTags->{"SA.7.2", "2.2"}],
    Cell[6311, 208, 834, 23, 70, "Notes",
      CellTags->{"SA.7.2", "2.3"}]},
  "2.1"->{
    Cell[6086, 198, 73, 1, 70, "Subsection",
      CellTags->{"SA.7.2", "2.1"}]},
  "2.2"->{
    Cell[6162, 201, 146, 5, 70, "Text",
      CellTags->{"SA.7.2", "2.2"}]},
  "2.3"->{
    Cell[6311, 208, 834, 23, 70, "Notes",
      CellTags->{"SA.7.2", "2.3"}]},
  "SA.7.3"->{
    Cell[7182, 236, 72, 1, 70, "Subsection",
      CellTags->{"SA.7.3", "3.1"}],
    Cell[7257, 239, 160, 5, 70, "Text",
      CellTags->{"SA.7.3", "3.2"}],
    Cell[7420, 246, 1472, 38, 70, "Notes",
      CellTags->{"SA.7.3", "3.3"}],
    Cell[8895, 286, 310, 8, 70, "Text",
      CellTags->{"SA.7.3", "3.4"}]},
  "3.1"->{
    Cell[7182, 236, 72, 1, 70, "Subsection",
      CellTags->{"SA.7.3", "3.1"}]},
  "3.2"->{
    Cell[7257, 239, 160, 5, 70, "Text",
      CellTags->{"SA.7.3", "3.2"}]},
  "3.3"->{
    Cell[7420, 246, 1472, 38, 70, "Notes",
      CellTags->{"SA.7.3", "3.3"}]},
  "3.4"->{
    Cell[8895, 286, 310, 8, 70, "Text",
      CellTags->{"SA.7.3", "3.4"}]},
  "SA.7.4"->{
    Cell[9242, 299, 67, 1, 70, "Subsection",
      CellTags->{"SA.7.4", "4.1"}],
    Cell[9312, 302, 275, 7, 70, "Text",
      CellTags->{"SA.7.4", "4.2"}],
    Cell[9590, 311, 897, 25, 70, "DefinitionBox",
      CellTags->"SA.7.4"],
    Cell[10490, 338, 56, 1, 70, "Caption",
      CellTags->"SA.7.4"],
    Cell[10549, 341, 640, 21, 70, "Text",
      CellTags->{"SA.7.4", "4.3"}],
    Cell[11192, 364, 614, 18, 70, "Text",
      CellTags->{"SA.7.4", "4.4"}],
    Cell[11809, 384, 279, 7, 70, "Text",
      CellTags->{"SA.7.4", "4.5"}]},
  "4.1"->{
    Cell[9242, 299, 67, 1, 70, "Subsection",
      CellTags->{"SA.7.4", "4.1"}]},
  "4.2"->{
    Cell[9312, 302, 275, 7, 70, "Text",
      CellTags->{"SA.7.4", "4.2"}]},
  "4.3"->{
    Cell[10549, 341, 640, 21, 70, "Text",
      CellTags->{"SA.7.4", "4.3"}]},
  "4.4"->{
    Cell[11192, 364, 614, 18, 70, "Text",
      CellTags->{"SA.7.4", "4.4"}]},
  "4.5"->{
    Cell[11809, 384, 279, 7, 70, "Text",
      CellTags->{"SA.7.4", "4.5"}]},
  "SA.7.5"->{
    Cell[12125, 396, 70, 1, 70, "Subsection",
      CellTags->{"SA.7.5", "5.1"}],
    Cell[12198, 399, 1453, 46, 70, "DefinitionBox",
      CellTags->"SA.7.5"],
    Cell[13654, 447, 104, 4, 70, "Caption",
      CellTags->"SA.7.5"],
    Cell[13761, 453, 434, 17, 70, "Text",
      CellTags->{"SA.7.5", "5.2"}],
    Cell[14198, 472, 593, 16, 70, "Text",
      CellTags->{"SA.7.5", "5.3"}]},
  "5.1"->{
    Cell[12125, 396, 70, 1, 70, "Subsection",
      CellTags->{"SA.7.5", "5.1"}]},
  "5.2"->{
    Cell[13761, 453, 434, 17, 70, "Text",
      CellTags->{"SA.7.5", "5.2"}]},
  "5.3"->{
    Cell[14198, 472, 593, 16, 70, "Text",
      CellTags->{"SA.7.5", "5.3"}]},
  "SA.7.6"->{
    Cell[14828, 493, 85, 1, 70, "Subsection",
      CellTags->{"SA.7.6", "6.1"}],
    Cell[14916, 496, 557, 14, 70, "DefinitionBox",
      CellTags->"SA.7.6"],
    Cell[15476, 512, 94, 3, 70, "Caption",
      CellTags->"SA.7.6"],
    Cell[15573, 517, 444, 13, 70, "Text",
      CellTags->{"SA.7.6", "6.2"}],
    Cell[16020, 532, 453, 12, 70, "Text",
      CellTags->{"SA.7.6", "6.3"}],
    Cell[16476, 546, 549, 16, 70, "FramedBox",
      CellTags->"SA.7.6"],
    Cell[17028, 564, 118, 4, 70, "Caption",
      CellTags->"SA.7.6"],
    Cell[17149, 570, 576, 16, 70, "FramedBox",
      CellTags->"SA.7.6"],
    Cell[17728, 588, 124, 4, 16, "Caption",
      CellTags->"SA.7.6"],
    Cell[17855, 594, 442, 11, 70, "Text",
      CellTags->{"SA.7.6", "6.4"}],
    Cell[18300, 607, 3309, 102, 328, "DefinitionBox",
      CellTags->"SA.7.6"],
    Cell[21612, 711, 131, 5, 16, "Caption",
      CellTags->"SA.7.6"],
    Cell[21746, 718, 218, 7, 40, "Text",
      CellTags->{"SA.7.6", "6.5"}],
    Cell[21967, 727, 672, 20, 66, "DefinitionBox",
      CellTags->"SA.7.6"],
    Cell[22642, 749, 78, 1, 16, "Caption",
      CellTags->"SA.7.6"],
    Cell[22723, 752, 267, 7, 56, "Text",
      CellTags->{"SA.7.6", "6.6"}],
    Cell[22993, 761, 1046, 33, 88, "DefinitionBox",
      CellTags->"SA.7.6"],
    Cell[24042, 796, 134, 5, 16, "Caption",
      CellTags->"SA.7.6"]},
  "6.1"->{
    Cell[14828, 493, 85, 1, 70, "Subsection",
      CellTags->{"SA.7.6", "6.1"}]},
  "6.2"->{
    Cell[15573, 517, 444, 13, 70, "Text",
      CellTags->{"SA.7.6", "6.2"}]},
  "6.3"->{
    Cell[16020, 532, 453, 12, 70, "Text",
      CellTags->{"SA.7.6", "6.3"}]},
  "6.4"->{
    Cell[17855, 594, 442, 11, 70, "Text",
      CellTags->{"SA.7.6", "6.4"}]},
  "6.5"->{
    Cell[21746, 718, 218, 7, 40, "Text",
      CellTags->{"SA.7.6", "6.5"}]},
  "6.6"->{
    Cell[22723, 752, 267, 7, 56, "Text",
      CellTags->{"SA.7.6", "6.6"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.7.0", 24819, 821},
  {"0.1", 24909, 824},
  {"SA.7.1", 25002, 827},
  {"1.1", 25617, 844},
  {"1.2", 25710, 847},
  {"1.3", 25798, 850},
  {"1.4", 25886, 853},
  {"SA.7.2", 25977, 856},
  {"2.1", 26224, 863},
  {"2.2", 26317, 866},
  {"2.3", 26405, 869},
  {"SA.7.3", 26498, 872},
  {"3.1", 26822, 881},
  {"3.2", 26915, 884},
  {"3.3", 27003, 887},
  {"3.4", 27094, 890},
  {"SA.7.4", 27185, 893},
  {"4.1", 27734, 908},
  {"4.2", 27827, 911},
  {"4.3", 27915, 914},
  {"4.4", 28005, 917},
  {"4.5", 28095, 920},
  {"SA.7.5", 28187, 923},
  {"5.1", 28587, 934},
  {"5.2", 28681, 937},
  {"5.3", 28771, 940},
  {"SA.7.6", 28864, 943},
  {"6.1", 30234, 980},
  {"6.2", 30328, 983},
  {"6.3", 30418, 986},
  {"6.4", 30508, 989},
  {"6.5", 30598, 992},
  {"6.6", 30687, 995}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 146, 5, 65, "Section",
  CellTags->{"SA.7.0", "0.1"}],

Cell[CellGroupData[{
Cell[1947, 62, 123, 4, 70, "Subsection",
  CellTags->{"SA.7.1", "1.1"}],
Cell[2073, 68, 1638, 50, 70, "DefinitionBox",
  CellTags->"SA.7.1"],
Cell[3714, 120, 151, 5, 70, "Caption",
  CellTags->"SA.7.1"],
Cell[3868, 127, 314, 7, 70, "Text",
  CellTags->{"SA.7.1", "1.2"}],
Cell[4185, 136, 220, 5, 70, "Text",
  CellTags->{"SA.7.1", "1.3"}],
Cell[4408, 143, 1299, 39, 70, "DefinitionBox",
  CellTags->"SA.7.1"],
Cell[5710, 184, 64, 1, 70, "Caption",
  CellTags->"SA.7.1"],
Cell[5777, 187, 272, 6, 70, "Text",
  CellTags->{"SA.7.1", "1.4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6086, 198, 73, 1, 70, "Subsection",
  CellTags->{"SA.7.2", "2.1"}],
Cell[6162, 201, 146, 5, 70, "Text",
  CellTags->{"SA.7.2", "2.2"}],
Cell[6311, 208, 834, 23, 70, "Notes",
  CellTags->{"SA.7.2", "2.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7182, 236, 72, 1, 70, "Subsection",
  CellTags->{"SA.7.3", "3.1"}],
Cell[7257, 239, 160, 5, 70, "Text",
  CellTags->{"SA.7.3", "3.2"}],
Cell[7420, 246, 1472, 38, 70, "Notes",
  CellTags->{"SA.7.3", "3.3"}],
Cell[8895, 286, 310, 8, 70, "Text",
  CellTags->{"SA.7.3", "3.4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9242, 299, 67, 1, 70, "Subsection",
  CellTags->{"SA.7.4", "4.1"}],
Cell[9312, 302, 275, 7, 70, "Text",
  CellTags->{"SA.7.4", "4.2"}],
Cell[9590, 311, 897, 25, 70, "DefinitionBox",
  CellTags->"SA.7.4"],
Cell[10490, 338, 56, 1, 70, "Caption",
  CellTags->"SA.7.4"],
Cell[10549, 341, 640, 21, 70, "Text",
  CellTags->{"SA.7.4", "4.3"}],
Cell[11192, 364, 614, 18, 70, "Text",
  CellTags->{"SA.7.4", "4.4"}],
Cell[11809, 384, 279, 7, 70, "Text",
  CellTags->{"SA.7.4", "4.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12125, 396, 70, 1, 70, "Subsection",
  CellTags->{"SA.7.5", "5.1"}],
Cell[12198, 399, 1453, 46, 70, "DefinitionBox",
  CellTags->"SA.7.5"],
Cell[13654, 447, 104, 4, 70, "Caption",
  CellTags->"SA.7.5"],
Cell[13761, 453, 434, 17, 70, "Text",
  CellTags->{"SA.7.5", "5.2"}],
Cell[14198, 472, 593, 16, 70, "Text",
  CellTags->{"SA.7.5", "5.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[14828, 493, 85, 1, 70, "Subsection",
  CellTags->{"SA.7.6", "6.1"}],
Cell[14916, 496, 557, 14, 70, "DefinitionBox",
  CellTags->"SA.7.6"],
Cell[15476, 512, 94, 3, 70, "Caption",
  CellTags->"SA.7.6"],
Cell[15573, 517, 444, 13, 70, "Text",
  CellTags->{"SA.7.6", "6.2"}],
Cell[16020, 532, 453, 12, 70, "Text",
  CellTags->{"SA.7.6", "6.3"}],
Cell[16476, 546, 549, 16, 70, "FramedBox",
  CellTags->"SA.7.6"],
Cell[17028, 564, 118, 4, 70, "Caption",
  CellTags->"SA.7.6"],
Cell[17149, 570, 576, 16, 70, "FramedBox",
  CellTags->"SA.7.6"],
Cell[17728, 588, 124, 4, 16, "Caption",
  CellTags->"SA.7.6"],
Cell[17855, 594, 442, 11, 70, "Text",
  CellTags->{"SA.7.6", "6.4"}],
Cell[18300, 607, 3309, 102, 328, "DefinitionBox",
  CellTags->"SA.7.6"],
Cell[21612, 711, 131, 5, 16, "Caption",
  CellTags->"SA.7.6"],
Cell[21746, 718, 218, 7, 40, "Text",
  CellTags->{"SA.7.6", "6.5"}],
Cell[21967, 727, 672, 20, 66, "DefinitionBox",
  CellTags->"SA.7.6"],
Cell[22642, 749, 78, 1, 16, "Caption",
  CellTags->"SA.7.6"],
Cell[22723, 752, 267, 7, 56, "Text",
  CellTags->{"SA.7.6", "6.6"}],
Cell[22993, 761, 1046, 33, 88, "DefinitionBox",
  CellTags->"SA.7.6"],
Cell[24042, 796, 134, 5, 16, "Caption",
  CellTags->"SA.7.6"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

