(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     26156,        825]*)
(*NotebookOutlinePosition[     32088,       1008]*)
(*  CellTagsIndexPosition[     31596,        984]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.8 ", "HeadingNumber"],
  StyleBox["Mathematica", "SBO"],
  " File Organization"
}], "Section",
  CellTags->{"SA.8.0", "0.1"}],

Cell[CellGroupData[{

Cell[TextData[{
  "A.8.1 ",
  StyleBox["Mathematica", "SBO"],
  " Distribution Files"
}], "Subsection",
  CellTags->{"SA.8.1", "1.1"}],

Cell[TextData[{
  "A full ",
  StyleBox["Mathematica", "TI"],
  " installation consists of something over 2200 separate files, arranged in \
a total of about 280 directories under the main installation directory. The \
location of the main installation directory is determined at install time. \
From within a ",
  StyleBox["Mathematica", "TI"],
  " kernel, its name is given by the value of ",
  StyleBox["$InstallationDirectory", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.8.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["C:\[Backslash]Program", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              StyleBox["Files\[Backslash]Wolfram", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              StyleBox[
              "Research\[Backslash]Mathematica\[Backslash]5.2", "MR"],
              " "
            }]], Cell["Windows "]},
          {Cell[TextData[{
              StyleBox["/Applications/Mathematica", "MR"],
              " ",
              StyleBox["5.2.app", "MR"],
              " "
            }]], Cell["Macintosh "]},
          {Cell[TextData[{
              StyleBox["/usr/local/Wolfram/Mathematica/5.2", "MR"],
              " "
            }]], Cell["Unix "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.8.1"],

Cell[TextData[{
  "Default locations for the ",
  StyleBox["Mathematica", "SO"],
  " installation directory. "
}], "Caption",
  CellTags->"SA.8.1"],

Cell[TextData[{
  "The executable programs that launch ",
  StyleBox["Mathematica", "TI"],
  " are typically in the main installation directory. Sometimes there may \
also be links to them, or scripts accessing them, in other locations. From \
within a ",
  StyleBox["Mathematica", "TI"],
  " kernel, ",
  StyleBox["First[$CommandLine]", "MR"],
  " gives the full name of the executable program corresponding to that \
kernel. "
}], "Text",
  CellTags->{"SA.8.1", "1.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Mathematica", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " front end "
            }]]},
          {Cell[TextData[{
              StyleBox["MathKernel", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " kernel, usually with its own text\[Hyphen]based interface "
            }]]},
          {Cell[TextData[{
              StyleBox["math", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " kernel to be run in a terminal or shell "
            }]]},
          {Cell[TextData[{
              StyleBox["mcc", "MR"],
              " "
            }]], Cell[TextData[{
              "script for preprocessing and compiling ",
              StyleBox["MathLink", "TI"],
              " C source files "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.8.1"],

Cell["\<\
Typical executable programs accessible from the installation \
directory. \
\>", "Caption",
  CellTags->"SA.8.1"],

Cell[TextData[{
  "The main installation directory has three standard subdirectories that \
contain material distributed with ",
  StyleBox["Mathematica", "TI"],
  ". Under normal circumstances, none of the contents of these directories \
should ever be modified, except, for example, if you choose to edit a shared \
style sheet. "
}], "Text",
  CellTags->{"SA.8.1", "1.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["AddOns", "MR"],
              " "
            }]], Cell[TextData[{
              "bundled ",
              StyleBox["Mathematica", "TI"],
              " add\[Hyphen]ons "
            }]]},
          {Cell[TextData[{
              StyleBox["Documentation", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " system documentation "
            }]]},
          {Cell[TextData[{
              StyleBox["SystemFiles", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " system files "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.8.1"],

Cell["\<\
Top\[Hyphen]level subdirectories of the main installation \
directory. \
\>", "Caption",
  CellTags->"SA.8.1"],

Cell[TextData[{
  "Particularly on Unix systems, ",
  StyleBox["Mathematica", "TI"],
  " often has executable files for different computer architectures and \
systems stored in a single overall directory structure. Each system is in a \
subdirectory with a name given by ",
  StyleBox["$SystemID", "MR"],
  ". Some resource directories may also contain files specific both to \
particular languages and particular computing environments. These files are \
given in subdirectories such as ",
  StyleBox["Japanese/Windows", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.8.1", "1.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Kernel/Binaries/", "MR"],
              StyleBox["system", "TI"],
              " "
            }]], Cell[
            "kernel binaries or elements for each computer system "]},
          {Cell[TextData[{
              StyleBox["Kernel/SystemResources/", "MR"],
              StyleBox["system", "TI"],
              " "
            }]], Cell[TextData[{
              "system\[Hyphen]specific ",
              StyleBox[".mx", "MR"],
              " files used by the kernel "
            }]]},
          {Cell[TextData[{
              StyleBox["Kernel/TextResources", "MR"],
              " "
            }]], Cell["message and text files used by the kernel "]},
          {Cell[TextData[{
              StyleBox["FrontEnd/Binaries/", "MR"],
              StyleBox["system", "TI"],
              " "
            }]], Cell[
            "front end binaries or elements for each computer system "]},
          {Cell[TextData[{
              StyleBox["FrontEnd/SystemResources", "MR"],
              " "
            }]], 
            Cell["\<\
files used by the front end in each window system \
environment \
\>"]},
          {Cell[TextData[{
              StyleBox["FrontEnd/TextResources", "MR"],
              " "
            }]], Cell["message and text files used by the front end "]},
          {Cell[TextData[{
              StyleBox["FrontEnd/StyleSheets", "MR"],
              " "
            }]], Cell["default notebook style sheets "]},
          {Cell[TextData[{
              StyleBox["FrontEnd/Palettes", "MR"],
              " "
            }]], Cell["default palette notebooks "]},
          {Cell[TextData[{
              StyleBox["Libraries/", "MR"],
              StyleBox["system", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["MathLink", "TI"],
              " and other libraries used by the kernel and front end "
            }]]},
          {Cell[TextData[{
              StyleBox["Fonts", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " fonts, often copied to a central directory "
            }]]},
          {Cell[TextData[{
              StyleBox["CharacterEncodings", "MR"],
              " "
            }]], Cell["specifications of character encodings "]},
          {Cell[TextData[{
              StyleBox["SpellingDictionaries", "MR"],
              " "
            }]], Cell["spelling dictionaries "]},
          {Cell[TextData[{
              StyleBox["SystemDocumentation/", "MR"],
              StyleBox["env", "TI"],
              " "
            }]], Cell[TextData[{
              "Unix ",
              StyleBox["man", "MR"],
              " pages and other environment\[Hyphen]specific documentation "
            }]]},
          {Cell[TextData[{
              StyleBox["Graphics/Binaries/", "MR"],
              StyleBox["system", "TI"],
              " "
            }]], Cell["PostScript interpreters and graphics programs "]},
          {Cell[TextData[{
              StyleBox["Graphics/SystemResources", "MR"],
              " "
            }]], Cell[
            "PostScript definitions and other resources for graphics "]},
          {Cell[TextData[{
              StyleBox["Graphics/Packages", "MR"],
              " "
            }]], Cell["packages for setting up graphics "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False, False, False, False, True, False}},
  CellTags->"SA.8.1"],

Cell[TextData[{
  "Typical subdirectories of the ",
  StyleBox["SystemFiles", "MR"],
  " directory, part one. "
}], "Caption",
  CellTags->"SA.8.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Installation", "MR"],
              " "
            }]], 
            Cell["\<\
various auxiliary programs used in installation, called \
automatically by the main installer program \
\>"]},
          {Cell[TextData[{
              StyleBox["IncludeFiles", "MR"],
              " "
            }]], Cell["files for inclusion in other programs "]},
          {Cell[TextData[{
              StyleBox["Java", "MR"],
              " "
            }]], Cell["files for the Java Runtime Environment (if needed) "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.8.1"],

Cell[TextData[{
  "Typical subdirectories of the ",
  StyleBox["SystemFiles", "MR"],
  " directory, part two. "
}], "Caption",
  CellTags->"SA.8.1"],

Cell[TextData[{
  "Bundled with versions of ",
  StyleBox["Mathematica", "TI"],
  " are various standard add\[Hyphen]on items. These are placed in the ",
  StyleBox["AddOns", "MR"],
  " subdirectory of the main installation directory. "
}], "Text",
  CellTags->{"SA.8.1", "1.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StandardPackages", "MR"],
              " "
            }]], Cell[TextData[{
              "standard add\[Hyphen]on packages distributed with ",
              StyleBox["Mathematica", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["MathLink", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MathLink", "TI"],
              " development material "
            }]]},
          {Cell[TextData[{
              StyleBox["JLink", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["J/Link", "TI"],
              " material "
            }]]},
          {Cell[TextData[{
              StyleBox["NETLink", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox[".NET/Link", "TI"],
              " material "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.8.1"],

Cell[TextData[{
  "Typical subdirectories of the ",
  StyleBox["AddOns", "MR"],
  " directory. "
}], "Caption",
  CellTags->"SA.8.1"],

Cell[TextData[{
  "The default contents of the ",
  StyleBox["Mathematica", "TI"],
  " Help Browser are stored in the ",
  StyleBox["Documentation", "MR"],
  " directory. ",
  StyleBox["BrowserCategories", "MR"],
  " files in each subdirectory set up the categories used in the Help \
Browser. ",
  StyleBox["BrowserIndex", "MR"],
  " files provide data for the master index.   "
}], "Text",
  CellTags->{"SA.8.1", "1.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["RefGuide", "MR"],
              " "
            }]], 
            Cell["\<\
reference guide and examples for built\[Hyphen]in \
functions \
\>"]},
          {Cell[TextData[{
              StyleBox["MainBook", "MR"],
              " "
            }]], Cell["the complete text of this book "]},
          {Cell[TextData[{
              StyleBox["AddOns", "MR"],
              " "
            }]], 
            Cell["\<\
documentation for standard add\[Hyphen]on items \
\
\>"]},
          {Cell[TextData[{
              StyleBox["GettingStarted", "MR"],
              " "
            }]], Cell["introductory documentation, and demos "]},
          {Cell[TextData[{
              StyleBox["OtherInformation", "MR"],
              " "
            }]], Cell["additional information "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.8.1"],

Cell[TextData[{
  "Typical subdirectories of the ",
  StyleBox["Documentation", "MR"],
  " directory. "
}], "Caption",
  CellTags->"SA.8.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.8.2 Loadable Files", "Subsection",
  CellTags->{"SA.8.2", "2.1"}],

Cell[TextData[{
  "You can customize your ",
  StyleBox["Mathematica", "TI"],
  " by adding files that can loaded into the system under different \
circumstances. Such files are conventionally placed in either \
system\[Hyphen]wide or user\[Hyphen]specific ",
  StyleBox["base directories", "TI"],
  ".       "
}], "Text",
  CellTags->{"SA.8.2", "2.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$BaseDirectory", "MR"],
              " "
            }]], Cell[TextData[{
              "system\[Hyphen]wide base directory for files to be loaded by ",
              
              StyleBox["Mathematica", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["$UserBaseDirectory", "MR"],
              " "
            }]], Cell[TextData[{
              
              "user\[Hyphen]specific base directory for files to be loaded by \
",
              StyleBox["Mathematica", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.8.2"],

Cell[TextData[{
  "Base directories for files to be loaded by ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"SA.8.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["C:\[Backslash]Documents", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              StyleBox["and", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              StyleBox["Settings\[Backslash]All", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              StyleBox["Users\[Backslash]Application", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              StyleBox["Data\[Backslash]Mathematica", "MR"],
              " "
            }]], Cell["Windows "]},
          {Cell[TextData[{
              StyleBox["/Library/Mathematica", "MR"],
              " "
            }]], Cell["Macintosh "]},
          {Cell[TextData[{
              StyleBox["/usr/share/Mathematica", "MR"],
              " "
            }]], Cell["Unix "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.8.2"],

Cell[TextData[{
  "Typical values of ",
  StyleBox["$BaseDirectory", "MR"],
  "."
}], "Caption",
  CellTags->"SA.8.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["C:\[Backslash]Documents", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              StyleBox["and", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              StyleBox["Settings\[Backslash]", "MR"],
              StyleBox["username", "TI"],
              "\[Backslash]",
              StyleBox["Application", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "Data\[Backslash]Mathematica",
              StyleBox[" ", "TR"]
            }]], Cell["Windows "]},
          {Cell[TextData[{
              StyleBox["~/Library/Mathematica", "MR"],
              " "
            }]], Cell["Macintosh "]},
          {Cell[TextData[{
              StyleBox["~/.Mathematica", "MR"],
              " "
            }]], Cell["Unix "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.8.2"],

Cell[TextData[{
  "Typical values of ",
  StyleBox["$UserBaseDirectory", "MR"],
  "."
}], "Caption",
  CellTags->"SA.8.2"],

Cell[TextData[{
  "You can specify different locations for these directories by setting \
operating system environment variables when you launch ",
  StyleBox["Mathematica", "TI"],
  ", as discussed in Section\[NonBreakingSpace]",
  ButtonBox["A.7.1",
    ButtonData:>{"A.7.1", "1.3"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"SA.8.2", "2.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Applications", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " application packages "
            }]]},
          {Cell[TextData[{
              StyleBox["Autoload", "MR"],
              " "
            }]], Cell["packages to be autoloaded on startup "]},
          {Cell[TextData[{
              StyleBox["FrontEnd", "MR"],
              " "
            }]], Cell["front end initialization files "]},
          {Cell[TextData[{
              StyleBox["Kernel", "MR"],
              " "
            }]], Cell["kernel initialization files "]},
          {Cell[TextData[{
              StyleBox["Licensing", "MR"],
              " "
            }]], Cell["license management files "]},
          {Cell[TextData[{
              StyleBox["SystemFiles", "MR"],
              " "
            }]], Cell["general system files "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.8.2"],

Cell[TextData[{
  "Typical subdirectories of ",
  StyleBox["Mathematica", "SO"],
  " base directories. "
}], "Caption",
  CellTags->"SA.8.2"],

Cell[TextData[{
  "Some files in base directories serve as configuration files, automatically \
used by the ",
  StyleBox["Mathematica", "TI"],
  " kernel or front end. "
}], "Text",
  CellTags->{"SA.8.2", "2.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Kernel/init.m", "MR"],
              " "
            }]], Cell["run when the kernel is started "]},
          {Cell[TextData[{
              StyleBox["Kernel/end.m", "MR"],
              " "
            }]], Cell["run when the kernel is terminated "]},
          {Cell[TextData[{
              StyleBox["FrontEnd/init.m", "MR"],
              " "
            }]], Cell["read when the front end is started "]},
          {Cell[TextData[{
              StyleBox["SystemFiles/FrontEnd/StyleSheets/", "MR"],
              " "
            }]], Cell["customized notebook style sheets "]},
          {Cell[TextData[{
              StyleBox["SystemFiles/FrontEnd/Palettes/", "MR"],
              " "
            }]], Cell[
            "additional palettes to appear in the front end menu "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.8.2"],

Cell["Some typical kernel and front end configuration files. ", "Caption",
  CellTags->"SA.8.2"],

Cell[TextData[{
  "Kernel configuration files can contain any ",
  StyleBox["Mathematica", "TI"],
  " commands. These commands can test global variables such as ",
  StyleBox["$SystemID", "MR"],
  " and ",
  StyleBox["$MachineName", "MR"],
  " to determine what operations to perform. Front end configuration files \
can contain only certain special commands, as described in Section\
\[NonBreakingSpace]",
  ButtonBox["A.2.12",
    ButtonData:>{"A.2.12", "12.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"SA.8.2", "2.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Applications/", "MR"],
              StyleBox["name", "TI"],
              StyleBox["/", "MR"],
              " "
            }]], Cell["named add\[Hyphen]on applications "]},
          {Cell[TextData[{
              StyleBox["Autoload/", "MR"],
              StyleBox["name", "TI"],
              StyleBox["/", "MR"],
              " "
            }]], Cell[TextData[{
              "add\[Hyphen]ons to be loaded automatically when ",
              StyleBox["Mathematica", "TI"],
              " is started "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.8.2"],

Cell[TextData[{
  "Subdirectories under ",
  StyleBox["$BaseDirectory", "MR"],
  " and ",
  StyleBox["$UserBaseDirectory", "MR"],
  ". "
}], "Caption",
  CellTags->"SA.8.2"],

Cell[TextData[{
  "With the default setting for the kernel ",
  StyleBox["$Path", "MR"],
  " variable, an add\[Hyphen]on can be loaded from within a ",
  StyleBox["Mathematica", "TI"],
  " session simply by using the command ",
  StyleBox["<<", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`", "MR"],
  ". This will load the ",
  StyleBox["init.m", "MR"],
  " file for the add\[Hyphen]on, which should in turn be set up to load other \
necessary files or packages. "
}], "Text",
  CellTags->{"SA.8.2", "2.6"}],

Cell[TextData[{
  "By placing an add\[Hyphen]on under the ",
  StyleBox["Autoload", "MR"],
  " subdirectory of ",
  StyleBox["$BaseDirectory", "MR"],
  " or ",
  StyleBox["$UserBaseDirectory", "MR"],
  ", you can have ",
  StyleBox["Mathematica", "TI"],
  " automatically load the add\[Hyphen]on whenever you start the kernel or \
the front end.  "
}], "Text",
  CellTags->{"SA.8.2", "2.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["init.m", "MR"],
              "  or  ",
              StyleBox["Kernel/init.m", "MR"],
              " "
            }]], Cell["an initialization file to be loaded by the kernel "]},
          {Cell[TextData[{
              StyleBox["FrontEnd/init.m", "MR"],
              " "
            }]], Cell[
            "an initialization file to be loaded by the front end "]},
          {Cell[TextData[{
              StyleBox["Documentation/", "MR"],
              " "
            }]], Cell["documentation to be found by the front end "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.8.2"],

Cell["\<\
Typical possible contents of the directory for an add\[Hyphen]on. \
\
\>", "Caption",
  CellTags->"SA.8.2"],

Cell[TextData[{
  "Note that with the default setting for the front end documentation path, \
all documentation in ",
  StyleBox["Documentation", "MR"],
  " directories will automatically show up in the front end Help Browser. "
}], "Text",
  CellTags->{"SA.8.2", "2.8"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{110, Automatic}, {58, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.8.0"->{
    Cell[1776, 53, 155, 5, 65, "Section",
      CellTags->{"SA.8.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 155, 5, 65, "Section",
      CellTags->{"SA.8.0", "0.1"}]},
  "SA.8.1"->{
    Cell[1956, 62, 134, 5, 70, "Subsection",
      CellTags->{"SA.8.1", "1.1"}],
    Cell[2093, 69, 488, 12, 70, "Text",
      CellTags->{"SA.8.1", "1.2"}],
    Cell[2584, 83, 1051, 27, 70, "DefinitionBox",
      CellTags->"SA.8.1"],
    Cell[3638, 112, 147, 5, 70, "Caption",
      CellTags->"SA.8.1"],
    Cell[3788, 119, 471, 12, 70, "Text",
      CellTags->{"SA.8.1", "1.3"}],
    Cell[4262, 133, 1181, 35, 70, "DefinitionBox",
      CellTags->"SA.8.1"],
    Cell[5446, 170, 123, 4, 70, "Caption",
      CellTags->"SA.8.1"],
    Cell[5572, 176, 375, 8, 70, "Text",
      CellTags->{"SA.8.1", "1.4"}],
    Cell[5950, 186, 889, 28, 70, "DefinitionBox",
      CellTags->"SA.8.1"],
    Cell[6842, 216, 120, 4, 70, "Caption",
      CellTags->"SA.8.1"],
    Cell[6965, 222, 578, 13, 70, "Text",
      CellTags->{"SA.8.1", "1.5"}],
    Cell[7546, 237, 3642, 97, 70, "DefinitionBox",
      CellTags->"SA.8.1"],
    Cell[11191, 336, 148, 5, 70, "Caption",
      CellTags->"SA.8.1"],
    Cell[11342, 343, 765, 22, 70, "DefinitionBox",
      CellTags->"SA.8.1"],
    Cell[12110, 367, 148, 5, 70, "Caption",
      CellTags->"SA.8.1"],
    Cell[12261, 374, 279, 7, 70, "Text",
      CellTags->{"SA.8.1", "1.6"}],
    Cell[12543, 383, 1090, 34, 70, "DefinitionBox",
      CellTags->"SA.8.1"],
    Cell[13636, 419, 133, 5, 70, "Caption",
      CellTags->"SA.8.1"],
    Cell[13772, 426, 422, 12, 70, "Text",
      CellTags->{"SA.8.1", "1.7"}],
    Cell[14197, 440, 1037, 34, 70, "DefinitionBox",
      CellTags->"SA.8.1"],
    Cell[15237, 476, 140, 5, 70, "Caption",
      CellTags->"SA.8.1"]},
  "1.1"->{
    Cell[1956, 62, 134, 5, 70, "Subsection",
      CellTags->{"SA.8.1", "1.1"}]},
  "1.2"->{
    Cell[2093, 69, 488, 12, 70, "Text",
      CellTags->{"SA.8.1", "1.2"}]},
  "1.3"->{
    Cell[3788, 119, 471, 12, 70, "Text",
      CellTags->{"SA.8.1", "1.3"}]},
  "1.4"->{
    Cell[5572, 176, 375, 8, 70, "Text",
      CellTags->{"SA.8.1", "1.4"}]},
  "1.5"->{
    Cell[6965, 222, 578, 13, 70, "Text",
      CellTags->{"SA.8.1", "1.5"}]},
  "1.6"->{
    Cell[12261, 374, 279, 7, 70, "Text",
      CellTags->{"SA.8.1", "1.6"}]},
  "1.7"->{
    Cell[13772, 426, 422, 12, 70, "Text",
      CellTags->{"SA.8.1", "1.7"}]},
  "SA.8.2"->{
    Cell[15414, 486, 73, 1, 70, "Subsection",
      CellTags->{"SA.8.2", "2.1"}],
    Cell[15490, 489, 353, 9, 70, "Text",
      CellTags->{"SA.8.2", "2.2"}],
    Cell[15846, 500, 814, 25, 70, "DefinitionBox",
      CellTags->"SA.8.2"],
    Cell[16663, 527, 141, 5, 70, "Caption",
      CellTags->"SA.8.2"],
    Cell[16807, 534, 1250, 30, 70, "DefinitionBox",
      CellTags->"SA.8.2"],
    Cell[18060, 566, 118, 5, 70, "Caption",
      CellTags->"SA.8.2"],
    Cell[18181, 573, 1190, 30, 70, "DefinitionBox",
      CellTags->"SA.8.2"],
    Cell[19374, 605, 122, 5, 70, "Caption",
      CellTags->"SA.8.2"],
    Cell[19499, 612, 369, 10, 70, "Text",
      CellTags->{"SA.8.2", "2.3"}],
    Cell[19871, 624, 1149, 33, 70, "DefinitionBox",
      CellTags->"SA.8.2"],
    Cell[21023, 659, 141, 5, 16, "Caption",
      CellTags->"SA.8.2"],
    Cell[21167, 666, 213, 6, 70, "Text",
      CellTags->{"SA.8.2", "2.4"}],
    Cell[21383, 674, 1040, 27, 166, "DefinitionBox",
      CellTags->"SA.8.2"],
    Cell[22426, 703, 96, 1, 16, "Caption",
      CellTags->"SA.8.2"],
    Cell[22525, 706, 548, 15, 72, "Text",
      CellTags->{"SA.8.2", "2.5"}],
    Cell[23076, 723, 783, 22, 84, "DefinitionBox",
      CellTags->"SA.8.2"],
    Cell[23862, 747, 173, 7, 16, "Caption",
      CellTags->"SA.8.2"],
    Cell[24038, 756, 509, 14, 72, "Text",
      CellTags->{"SA.8.2", "2.6"}],
    Cell[24550, 772, 391, 12, 56, "Text",
      CellTags->{"SA.8.2", "2.7"}],
    Cell[24944, 786, 790, 21, 88, "DefinitionBox",
      CellTags->"SA.8.2"],
    Cell[25737, 809, 117, 4, 16, "Caption",
      CellTags->"SA.8.2"],
    Cell[25857, 815, 271, 6, 56, "Text",
      CellTags->{"SA.8.2", "2.8"}]},
  "2.1"->{
    Cell[15414, 486, 73, 1, 70, "Subsection",
      CellTags->{"SA.8.2", "2.1"}]},
  "2.2"->{
    Cell[15490, 489, 353, 9, 70, "Text",
      CellTags->{"SA.8.2", "2.2"}]},
  "2.3"->{
    Cell[19499, 612, 369, 10, 70, "Text",
      CellTags->{"SA.8.2", "2.3"}]},
  "2.4"->{
    Cell[21167, 666, 213, 6, 70, "Text",
      CellTags->{"SA.8.2", "2.4"}]},
  "2.5"->{
    Cell[22525, 706, 548, 15, 72, "Text",
      CellTags->{"SA.8.2", "2.5"}]},
  "2.6"->{
    Cell[24038, 756, 509, 14, 72, "Text",
      CellTags->{"SA.8.2", "2.6"}]},
  "2.7"->{
    Cell[24550, 772, 391, 12, 56, "Text",
      CellTags->{"SA.8.2", "2.7"}]},
  "2.8"->{
    Cell[25857, 815, 271, 6, 56, "Text",
      CellTags->{"SA.8.2", "2.8"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.8.0", 26771, 841},
  {"0.1", 26861, 844},
  {"SA.8.1", 26954, 847},
  {"1.1", 28548, 890},
  {"1.2", 28641, 893},
  {"1.3", 28729, 896},
  {"1.4", 28818, 899},
  {"1.5", 28906, 902},
  {"1.6", 28995, 905},
  {"1.7", 29084, 908},
  {"SA.8.2", 29177, 911},
  {"2.1", 30861, 956},
  {"2.2", 30955, 959},
  {"2.3", 31044, 962},
  {"2.4", 31134, 965},
  {"2.5", 31223, 968},
  {"2.6", 31313, 971},
  {"2.7", 31403, 974},
  {"2.8", 31493, 977}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 155, 5, 65, "Section",
  CellTags->{"SA.8.0", "0.1"}],

Cell[CellGroupData[{
Cell[1956, 62, 134, 5, 70, "Subsection",
  CellTags->{"SA.8.1", "1.1"}],
Cell[2093, 69, 488, 12, 70, "Text",
  CellTags->{"SA.8.1", "1.2"}],
Cell[2584, 83, 1051, 27, 70, "DefinitionBox",
  CellTags->"SA.8.1"],
Cell[3638, 112, 147, 5, 70, "Caption",
  CellTags->"SA.8.1"],
Cell[3788, 119, 471, 12, 70, "Text",
  CellTags->{"SA.8.1", "1.3"}],
Cell[4262, 133, 1181, 35, 70, "DefinitionBox",
  CellTags->"SA.8.1"],
Cell[5446, 170, 123, 4, 70, "Caption",
  CellTags->"SA.8.1"],
Cell[5572, 176, 375, 8, 70, "Text",
  CellTags->{"SA.8.1", "1.4"}],
Cell[5950, 186, 889, 28, 70, "DefinitionBox",
  CellTags->"SA.8.1"],
Cell[6842, 216, 120, 4, 70, "Caption",
  CellTags->"SA.8.1"],
Cell[6965, 222, 578, 13, 70, "Text",
  CellTags->{"SA.8.1", "1.5"}],
Cell[7546, 237, 3642, 97, 70, "DefinitionBox",
  CellTags->"SA.8.1"],
Cell[11191, 336, 148, 5, 70, "Caption",
  CellTags->"SA.8.1"],
Cell[11342, 343, 765, 22, 70, "DefinitionBox",
  CellTags->"SA.8.1"],
Cell[12110, 367, 148, 5, 70, "Caption",
  CellTags->"SA.8.1"],
Cell[12261, 374, 279, 7, 70, "Text",
  CellTags->{"SA.8.1", "1.6"}],
Cell[12543, 383, 1090, 34, 70, "DefinitionBox",
  CellTags->"SA.8.1"],
Cell[13636, 419, 133, 5, 70, "Caption",
  CellTags->"SA.8.1"],
Cell[13772, 426, 422, 12, 70, "Text",
  CellTags->{"SA.8.1", "1.7"}],
Cell[14197, 440, 1037, 34, 70, "DefinitionBox",
  CellTags->"SA.8.1"],
Cell[15237, 476, 140, 5, 70, "Caption",
  CellTags->"SA.8.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15414, 486, 73, 1, 70, "Subsection",
  CellTags->{"SA.8.2", "2.1"}],
Cell[15490, 489, 353, 9, 70, "Text",
  CellTags->{"SA.8.2", "2.2"}],
Cell[15846, 500, 814, 25, 70, "DefinitionBox",
  CellTags->"SA.8.2"],
Cell[16663, 527, 141, 5, 70, "Caption",
  CellTags->"SA.8.2"],
Cell[16807, 534, 1250, 30, 70, "DefinitionBox",
  CellTags->"SA.8.2"],
Cell[18060, 566, 118, 5, 70, "Caption",
  CellTags->"SA.8.2"],
Cell[18181, 573, 1190, 30, 70, "DefinitionBox",
  CellTags->"SA.8.2"],
Cell[19374, 605, 122, 5, 70, "Caption",
  CellTags->"SA.8.2"],
Cell[19499, 612, 369, 10, 70, "Text",
  CellTags->{"SA.8.2", "2.3"}],
Cell[19871, 624, 1149, 33, 70, "DefinitionBox",
  CellTags->"SA.8.2"],
Cell[21023, 659, 141, 5, 16, "Caption",
  CellTags->"SA.8.2"],
Cell[21167, 666, 213, 6, 70, "Text",
  CellTags->{"SA.8.2", "2.4"}],
Cell[21383, 674, 1040, 27, 166, "DefinitionBox",
  CellTags->"SA.8.2"],
Cell[22426, 703, 96, 1, 16, "Caption",
  CellTags->"SA.8.2"],
Cell[22525, 706, 548, 15, 72, "Text",
  CellTags->{"SA.8.2", "2.5"}],
Cell[23076, 723, 783, 22, 84, "DefinitionBox",
  CellTags->"SA.8.2"],
Cell[23862, 747, 173, 7, 16, "Caption",
  CellTags->"SA.8.2"],
Cell[24038, 756, 509, 14, 72, "Text",
  CellTags->{"SA.8.2", "2.6"}],
Cell[24550, 772, 391, 12, 56, "Text",
  CellTags->{"SA.8.2", "2.7"}],
Cell[24944, 786, 790, 21, 88, "DefinitionBox",
  CellTags->"SA.8.2"],
Cell[25737, 809, 117, 4, 16, "Caption",
  CellTags->"SA.8.2"],
Cell[25857, 815, 271, 6, 56, "Text",
  CellTags->{"SA.8.2", "2.8"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

