(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     62503,       2114]*)
(*NotebookOutlinePosition[    130092,       4059]*)
(*  CellTagsIndexPosition[    120864,       3710]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.9 ", "HeadingNumber"],
  "Some Notes on Internal Implementation"
}], "Section",
  CellTags->{"SA.9.0", "0.1"}],

Cell[CellGroupData[{

Cell["A.9.1 Introduction", "Subsection",
  CellTags->{"SA.9.1", "1.1"}],

Cell[TextData[{
  "General issues about the internal implementation of ",
  StyleBox["Mathematica", "TI"],
  " are discussed in Section\[NonBreakingSpace]",
  ButtonBox["1.12",
    ButtonData:>{"1.12"},
    ButtonStyle->"MainBookLink"],
  ". Given here are brief notes on particular features. "
}], "Text",
  CellTags->{"SA.9.1", "1.2"}],

Cell["\<\
These notes apply to Version 5.2. Algorithms and other aspects of \
implementation are subject to change in future versions. \
\>", "Text",
  CellTags->{"SA.9.1", "1.3"}],

Cell["\<\
It should be emphasized that these notes give only a rough \
indication of basic methods and algorithms used. The actual implementation \
usually involves many substantial additional elements. \
\>", "Text",
  CellTags->{"SA.9.1", "1.4"}],

Cell[TextData[{
  "Thus, for example, the notes simply say that ",
  StyleBox["DSolve", "MR"],
  " solves second\[Hyphen]order linear differential equations using the \
Kovacic algorithm. But the internal code which achieves this is over 60 pages \
long, includes a number of other algorithms, and involves a great many \
subtleties. "
}], "Text",
  CellTags->{"SA.9.1", "1.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.9.2 Data Structures and Memory Management", "Subsection",
  CellTags->{"SA.9.2", "2.1"}],

Cell[TextData[{
  "A ",
  StyleBox["Mathematica", "TI"],
  " expression internally consists of a contiguous array of pointers, the \
first to the head, and the rest to its successive elements. "
}], "Text",
  CellTags->{"SA.9.2", "2.2"}],

Cell["\<\
Each expression contains a special form of hash code which is used \
both in pattern matching and evaluation. \
\>", "Text",
  CellTags->{"SA.9.2", "2.3"}],

Cell[TextData[{
  "For every symbol there is a central ",
  StyleBox["symbol table entry", "TI"],
  " which stores all information about the symbol. "
}], "Text",
  CellTags->{"SA.9.2", "2.4"}],

Cell["\<\
Most raw objects such as strings and numbers are allocated \
separately; unique copies are however maintained of small integers and of \
certain approximate numbers generated in computations. \
\>", "Text",
  CellTags->{"SA.9.2", "2.5"}],

Cell[TextData[{
  "Every piece of memory used by ",
  StyleBox["Mathematica", "TI"],
  " maintains a count of how many times it is referenced. Memory is \
automatically freed when this count reaches zero. "
}], "Text",
  CellTags->{"SA.9.2", "2.6"}],

Cell["\<\
The contiguous storage of elements in expressions reduces memory \
fragmentation and swapping. However, it can lead to the copying of a complete \
array of pointers when a single element in a long expression is modified. \
Many optimizations based on reference counts and pre\[Hyphen]allocation are \
used to avoid such copying. \
\>", "Text",
  CellTags->{"SA.9.2", "2.7"}],

Cell[TextData[{
  "When appropriate, large lists and nested lists of numbers are \
automatically stored as packed arrays of machine\[Hyphen]sized integers or \
real numbers. The ",
  StyleBox["Mathematica", "TI"],
  " compiler is automatically used to compile complicated functions that will \
be repeatedly applied to such packed arrays. ",
  StyleBox["MathLink", "TI"],
  ", ",
  StyleBox["DumpSave", "MR"],
  ", ",
  StyleBox["Display", "MR"],
  ", as well as various ",
  StyleBox["Import", "MR"],
  " and ",
  StyleBox["Export", "MR"],
  " formats, make external use of packed arrays.  "
}], "Text",
  CellTags->{"SA.9.2", "2.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.9.3 Basic System Features", "Subsection",
  CellTags->{"SA.9.3", "3.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " is fundamentally an interpreter which scans through expressions calling \
internal code pointed to by the symbol table entries of heads that it \
encounters. "
}], "Text",
  CellTags->{"SA.9.3", "3.2"}],

Cell[TextData[{
  "Any transformation rule\[LongDash]whether given as ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["y", "TI"],
  " or in a definition\[LongDash]is automatically compiled into a form which \
allows for rapid pattern matching. Many different types of patterns are \
distinguished and are handled by special code. "
}], "Text",
  CellTags->{"SA.9.3", "3.3", "Rule"}],

Cell["\<\
A form of hashing that takes account of blanks and other features \
of patterns is used in pattern matching. \
\>", "Text",
  CellTags->{"SA.9.3", "3.4"}],

Cell["\<\
The internal code associated with pattern matching is approximately \
250 pages long. \
\>", "Text",
  CellTags->{"SA.9.3", "3.5"}],

Cell["\<\
 String patterns are implemented using a symbolic extension of the \
PCRE regular expression library. \
\>", "Text",
  CellTags->{"SA.9.3", "3.6", "RegularExpression", "StringExpression"}],

Cell[TextData[{
  "When a large number of definitions are given for a particular symbol, a \
hash table is automatically built using a version of ",
  StyleBox["Dispatch", "MR"],
  " so that appropriate rules can quickly be found. "
}], "Text",
  CellTags->{"SA.9.3", "3.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.9.4 Numerical and Related Functions", "Subsection",
  CellTags->{"SA.9.4", "4.1"}],

Cell[CellGroupData[{

Cell["Number representation and numerical evaluation", "Subsubsection",
  CellTags->{"SA.9.4", "4.2"}],

Cell[TextData[{
  "\[FilledSmallCircle] Large integers and high\[Hyphen]precision approximate \
numbers are stored as arrays of base ",
  Cell[BoxData[
      \(TraditionalForm\`2\^32\)], "InlineFormula"],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`2\^64\)], "InlineFormula"],
  " digits, depending on the lengths of machine integers. "
}], "Notes",
  CellTags->{"SA.9.4", "4.3"}],

Cell["\<\
\[FilledSmallCircle] Precision is internally maintained as a \
floating\[Hyphen]point number. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.4"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["IntegerDigits", "MR"],
  ", ",
  StyleBox["RealDigits", "MR"],
  " and related base conversion functions use recursive divide\[Hyphen]and\
\[Hyphen]conquer algorithms. Similar algorithms are used for number input and \
output. "
}], "Notes",
  CellTags->{"SA.9.4", "4.5", "IntegerDigits", "RealDigits"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["N", "MR"],
  " uses an adaptive procedure to increase its internal working precision in \
order to achieve whatever overall precision is requested. "
}], "Notes",
  CellTags->{"SA.9.4", "4.6", "N"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Floor", "MR"],
  ", ",
  StyleBox["Ceiling", "MR"],
  " and related functions use an adaptive procedure similar to ",
  StyleBox["N", "MR"],
  " to generate exact results from exact input.  "
}], "Notes",
  CellTags->{"SA.9.4", "4.7", "Floor", "Ceiling"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic arithmetic", "Subsubsection",
  CellTags->{"SA.9.4", "4.8"}],

Cell["\<\
\[FilledSmallCircle] Multiplication of large integers and high\
\[Hyphen]precision approximate numbers is done using interleaved schoolbook, \
Karatsuba, three\[Hyphen]way Toom\[Hyphen]Cook and number\[Hyphen]theoretic \
transform algorithms. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.9"}],

Cell["\<\
\[FilledSmallCircle] Machine\[Hyphen]code optimization for specific \
architectures is achieved by using GMP. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.10"}],

Cell["\<\
\[FilledSmallCircle] Integer powers are found by a \
left\[Hyphen]right binary decomposition algorithm. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.11"}],

Cell["\<\
\[FilledSmallCircle] Reciprocals and rational powers of approximate \
numbers use Newton's method. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.12"}],

Cell["\<\
\[FilledSmallCircle] Exact roots start from numerical estimates. \
\
\>", "Notes",
  CellTags->{"SA.9.4", "4.13"}],

Cell["\<\
\[FilledSmallCircle] Significance arithmetic is used for all \
arithmetic with approximate numbers beyond machine precision.  \
\>", "Notes",\

  CellTags->{"SA.9.4", "4.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pseudorandom numbers", "Subsubsection",
  CellTags->{"SA.9.4", "4.15"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Random", "MR"],
  " uses the Wolfram rule 30 cellular automaton generator for integers. "
}], "Notes",
  CellTags->{"SA.9.4", "4.16", "Random"}],

Cell["\<\
\[FilledSmallCircle] It uses a Marsaglia\[Hyphen]Zaman subtract\
\[Hyphen]with\[Hyphen]borrow generator for real numbers. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.17"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Number\[Hyphen]theoretical functions", "Subsubsection",
  CellTags->{"SA.9.4", "4.18"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["GCD", "MR"],
  " interleaves the HGCD algorithm, the \
Jebelean\[Hyphen]Sorenson\[Hyphen]Weber accelerated GCD algorithm, and a \
combination of Euclid's algorithm and an algorithm based on iterative removal \
of powers of 2. "
}], "Notes",
  CellTags->{"SA.9.4", "4.19"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["PrimeQ", "MR"],
  " first tests for divisibility using small primes, then uses the Miller\
\[Hyphen]Rabin strong pseudoprime test base 2 and base 3, and then uses a \
Lucas test. "
}], "Notes",
  CellTags->{"SA.9.4", "4.20", "PrimeQ"}],

Cell[TextData[{
  "\[FilledSmallCircle] As of 1997, this procedure is known to be correct \
only for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "<", \(10\^16\)}], TraditionalForm]], "InlineFormula"],
  ", and it is conceivable that for larger ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " it could claim a composite number to be prime. "
}], "Notes",
  CellTags->{"SA.9.4", "4.21"}],

Cell[TextData[{
  "\[FilledSmallCircle] The package ",
  StyleBox["NumberTheory`PrimeQ`", "MR"],
  " contains a much slower algorithm which has been proved correct for all ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". It can return an explicit certificate of primality. "
}], "Notes",
  CellTags->{"SA.9.4", "4.22"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["FactorInteger", "MR"],
  " switches between trial division, Pollard ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["p",
            "TI"], "-", "1"}], TraditionalForm]], "InlineFormula"],
  ", Pollard rho and quadratic sieve algorithms. "
}], "Notes",
  CellTags->{"SA.9.4", "4.23", "FactorInteger"}],

Cell[TextData[{
  "\[FilledSmallCircle] The package ",
  StyleBox["NumberTheory`FactorIntegerECM`", "MR"],
  " contains an elliptic curve algorithm suitable for factoring some very \
large integers. "
}], "Notes",
  CellTags->{"SA.9.4", "4.24"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Prime", "MR"],
  " and ",
  StyleBox["PrimePi", "MR"],
  " use sparse caching and sieving. For large ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", the Lagarias\[Hyphen]Miller\[Hyphen]Odlyzko algorithm for ",
  StyleBox["PrimePi", "MR"],
  " is used, based on asymptotic estimates of the density of primes, and is \
inverted to give ",
  StyleBox["Prime", "MR"],
  ". "
}], "Notes",
  CellTags->{"SA.9.4", "4.25", "Prime", "PrimePi"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["LatticeReduce", "MR"],
  " uses the Lenstra\[Hyphen]Lenstra\[Hyphen]Lovasz lattice reduction \
algorithm. "
}], "Notes",
  CellTags->{"SA.9.4", "4.26", "LatticeReduce"}],

Cell[TextData[{
  "\[FilledSmallCircle] To find a requested number of terms ",
  StyleBox["ContinuedFraction", "MR"],
  " uses a modification of Lehmer's indirect method, with a \
self\[Hyphen]restarting divide\[Hyphen]and\[Hyphen]conquer algorithm to \
reduce the numerical precision required at each step. "
}], "Notes",
  CellTags->{"SA.9.4", "4.27"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["ContinuedFraction", "MR"],
  " uses recurrence relations to find periodic continued fractions for \
quadratic irrationals. "
}], "Notes",
  CellTags->{"SA.9.4", "4.28", "ContinuedFraction"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["FromContinuedFraction", "MR"],
  " uses iterated matrix multiplication optimized by a divide\[Hyphen]and\
\[Hyphen]conquer method.  "
}], "Notes",
  CellTags->{"SA.9.4", "4.29", "FromContinuedFraction"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Combinatorial functions", "Subsubsection",
  CellTags->{"SA.9.4", "4.30"}],

Cell["\<\
\[FilledSmallCircle] Most combinatorial functions use sparse \
caching and recursion. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.31"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Factorial", "MR"],
  ", ",
  StyleBox["Binomial", "MR"],
  " and related functions use a divide\[Hyphen]and\[Hyphen]conquer algorithm \
to balance the number of digits in subproducts. "
}], "Notes",
  CellTags->{"SA.9.4", "4.32", "Factorial", "Binomial"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Fibonacci[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " uses an iterative method based on the binary digit sequence of ",
  StyleBox["n", "TI"],
  ". "
}], "Notes",
  CellTags->{"SA.9.4", "4.33", "Fibonacci"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["PartitionsP[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " uses Euler's pentagonal formula for small ",
  StyleBox["n", "TI"],
  ", and the non\[Hyphen]recursive Hardy\[Hyphen]Ramanujan\[Hyphen]Rademacher \
method for larger ",
  StyleBox["n", "TI"],
  ". "
}], "Notes",
  CellTags->{"SA.9.4", "4.34", "PartitionsP"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["ClebschGordan", "MR"],
  " and related functions use generalized hypergeometric series. "
}], "Notes",
  CellTags->{"SA.9.4", "4.35", "ClebschGordan"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elementary transcendental functions", "Subsubsection",
  CellTags->{"SA.9.4", "4.36"}],

Cell["\<\
\[FilledSmallCircle] Exponential and trigonometric functions use \
Taylor series, stable recursion by argument doubling, and functional \
relations. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.37"}],

Cell["\<\
\[FilledSmallCircle] Log and inverse trigonometric functions use \
Taylor series and functional relations.  \
\>", "Notes",
  CellTags->{"SA.9.4", "4.38"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematical constants", "Subsubsection",
  CellTags->{"SA.9.4", "4.39"}],

Cell["\<\
\[FilledSmallCircle] Values of constants are cached once computed. \
\
\>", "Notes",
  CellTags->{"SA.9.4", "4.40"}],

Cell["\<\
\[FilledSmallCircle] Binary splitting is used to subdivide \
computations of constants. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.41"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Pi", "MR"],
  " is computed using the Chudnovsky formula. "
}], "Notes",
  CellTags->{"SA.9.4", "4.42", "Pi"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["E", "MR"],
  " is computed from its series expansion. "
}], "Notes",
  CellTags->{"SA.9.4", "4.43", "E"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["EulerGamma", "MR"],
  " uses the Brent\[Hyphen]McMillan algorithm. "
}], "Notes",
  CellTags->{"SA.9.4", "4.44", "EulerGamma"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Catalan", "MR"],
  " is computed from a linearly convergent Ramanujan sum.  "
}], "Notes",
  CellTags->{"SA.9.4", "4.45", "Catalan"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special functions", "Subsubsection",
  CellTags->{"SA.9.4", "4.46"}],

Cell[TextData[{
  "\[FilledSmallCircle] For machine precision most special functions use ",
  StyleBox["Mathematica", "TI"],
  "\[Hyphen]derived rational minimax approximations. The notes that follow \
apply mainly to arbitrary precision. "
}], "Notes",
  CellTags->{"SA.9.4", "4.47"}],

Cell["\<\
\[FilledSmallCircle] Orthogonal polynomials use stable recursion \
formulas for polynomial cases and hypergeometric functions in general. \
\>", \
"Notes",
  CellTags->{"SA.9.4", "4.48"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Gamma", "MR"],
  " uses recursion, functional equations and the Binet asymptotic formula. "
}], "Notes",
  CellTags->{"SA.9.4", "4.49", "Gamma"}],

Cell["\<\
\[FilledSmallCircle] Incomplete gamma and beta functions use \
hypergeometric series and continued fractions. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.50"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["PolyGamma", "MR"],
  " uses Euler\[Hyphen]Maclaurin summation, functional equations and \
recursion. "
}], "Notes",
  CellTags->{"SA.9.4", "4.51", "PolyGamma"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["PolyLog", "MR"],
  " uses Euler\[Hyphen]Maclaurin summation, expansions in terms of incomplete \
gamma functions and numerical quadrature. "
}], "Notes",
  CellTags->{"SA.9.4", "4.52", "PolyLog"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Zeta", "MR"],
  " and related functions use Euler\[Hyphen]Maclaurin summation and \
functional equations. Near the critical strip they also use the Riemann\
\[Hyphen]Siegel formula. "
}], "Notes",
  CellTags->{"SA.9.4", "4.53", "Zeta"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["StieltjesGamma", "MR"],
  " uses Keiper's algorithm based on numerical quadrature of an integral \
representation of the zeta function. "
}], "Notes",
  CellTags->{"SA.9.4", "4.54", "StieltjesGamma"}],

Cell["\<\
\[FilledSmallCircle] The error function and functions related to \
exponential integrals are all evaluated using incomplete gamma functions. \
\
\>", "Notes",
  CellTags->{"SA.9.4", "4.55"}],

Cell["\<\
\[FilledSmallCircle] The inverse error functions use binomial \
search and a high\[Hyphen]order generalized Newton's method. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.56"}],

Cell["\<\
\[FilledSmallCircle] Bessel functions use series and asymptotic \
expansions. For integer orders, some also use stable forward recursion. \
\
\>", "Notes",
  CellTags->{"SA.9.4", "4.57"}],

Cell[TextData[{
  "\[FilledSmallCircle] The hypergeometric functions use functional \
equations, stable recurrence relations, series expansions and asymptotic \
series. Methods from ",
  StyleBox["NSum", "MR"],
  " and ",
  StyleBox["NIntegrate", "MR"],
  " are also sometimes used. "
}], "Notes",
  CellTags->{"SA.9.4", "4.58"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["ProductLog", "MR"],
  " uses high\[Hyphen]order Newton's method starting from rational \
approximations and asymptotic expansions. "
}], "Notes",
  CellTags->{"SA.9.4", "4.59"}],

Cell["\<\
\[FilledSmallCircle] Elliptic integrals are evaluated using the \
descending Gauss transformation.  \
\>", "Notes",
  CellTags->{"SA.9.4", "4.60"}],

Cell["\<\
\[FilledSmallCircle] Elliptic theta functions use series summation \
with recursive evaluation of series terms. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.61"}],

Cell["\<\
\[FilledSmallCircle] Other elliptic functions mostly use arithmetic\
\[Hyphen]geometric mean methods. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.62"}],

Cell["\<\
\[FilledSmallCircle] Mathieu functions use Fourier series. The \
Mathieu characteristic functions use generalizations of Blanch's Newton \
method.  \
\>", "Notes",
  CellTags->{"SA.9.4", "4.63"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical integration", "Subsubsection",
  CellTags->{"SA.9.4", "4.64"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["NIntegrate", "MR"],
  " uses symbolic preprocessing to resolve function symmetries, expand \
piecewise functions into cases, and decompose regions specified by \
inequalities into cells. "
}], "Notes",
  CellTags->{"SA.9.4", "4.65", "NIntegrate"}],

Cell[TextData[{
  "\[FilledSmallCircle] With ",
  StyleBox["Method->Automatic", "MR"],
  ", ",
  StyleBox["NIntegrate", "MR"],
  " uses ",
  StyleBox["GaussKronrod", "MR"],
  " in one dimension, and ",
  StyleBox["MultiDimensional", "MR"],
  " otherwise. "
}], "Notes",
  CellTags->{"SA.9.4", "4.66"}],

Cell[TextData[{
  "\[FilledSmallCircle] If an explicit setting for ",
  StyleBox["MaxPoints", "MR"],
  " is given, ",
  StyleBox["NIntegrate", "MR"],
  " by default uses ",
  StyleBox["Method->QuasiMonteCarlo", "MR"],
  ". "
}], "Notes",
  CellTags->{"SA.9.4", "4.67"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["GaussKronrod", "MR"],
  ": adaptive Gaussian quadrature with error estimation based on evaluation \
at Kronrod points. "
}], "Notes",
  CellTags->{"SA.9.4", "4.68"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["DoubleExponential", "MR"],
  ": non\[Hyphen]adaptive double\[Hyphen]exponential quadrature. "
}], "Notes",
  CellTags->{"SA.9.4", "4.69"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Trapezoidal", "MR"],
  ": elementary trapezoidal method. "
}], "Notes",
  CellTags->{"SA.9.4", "4.70"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Oscillatory", "MR"],
  ": transformation to handle certain integrals containing trigonometric and \
Bessel functions. "
}], "Notes",
  CellTags->{"SA.9.4", "4.71"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["MultiDimensional", "MR"],
  ": adaptive Genz\[Hyphen]Malik algorithm. "
}], "Notes",
  CellTags->{"SA.9.4", "4.72"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["MonteCarlo", "MR"],
  ": non\[Hyphen]adaptive Monte Carlo. "
}], "Notes",
  CellTags->{"SA.9.4", "4.73"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["QuasiMonteCarlo", "MR"],
  ": non\[Hyphen]adaptive Halton\[Hyphen]Hammersley\[Hyphen]Wozniakowski \
algorithm. "
}], "Notes",
  CellTags->{"SA.9.4", "4.74"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical sums and products", "Subsubsection",
  CellTags->{"SA.9.4", "4.75"}],

Cell["\<\
\[FilledSmallCircle] If the ratio test does not give 1, the Wynn \
epsilon algorithm is applied to a sequence of partial sums or products. \
\
\>", "Notes",
  CellTags->{"SA.9.4", "4.76", "NSum"}],

Cell[TextData[{
  "\[FilledSmallCircle] Otherwise Euler\[Hyphen]Maclaurin summation is used \
with ",
  StyleBox["Integrate", "MR"],
  " or ",
  StyleBox["NIntegrate", "MR"],
  ".  "
}], "Notes",
  CellTags->{"SA.9.4", "4.77"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical differential equations", "Subsubsection",
  CellTags->{"SA.9.4", "4.78"}],

Cell[TextData[{
  "\[FilledSmallCircle] For ordinary differential equations, ",
  StyleBox["NDSolve", "MR"],
  " by default uses an LSODA approach, switching between a non\[Hyphen]stiff \
Adams method and a stiff Gear backward differentiation formula method. "
}], "Notes",
  CellTags->{"SA.9.4", "4.79", "NDSolve"}],

Cell["\<\
\[FilledSmallCircle] For linear boundary value problems the \
Gel'fand\[Hyphen]Lokutsiyevskii chasing method is used. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.80"}],

Cell["\<\
\[FilledSmallCircle] Differential\[Hyphen]algebraic equations use \
IDA, based on repeated BDF and Newton iteration methods. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.81"}],

Cell[TextData[{
  "\[FilledSmallCircle] For ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            StyleBox["n",
              "TI"], "+", "1"}], ")"}], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]dimensional PDEs the method of lines is used. "
}], "Notes",
  CellTags->{"SA.9.4", "4.82"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["NDSolve", "MR"],
  " supports explicit ",
  StyleBox["Method", "MR"],
  " settings that cover most known methods from the literature. "
}], "Notes",
  CellTags->{"SA.9.4", "4.83"}],

Cell[TextData[{
  "\[FilledSmallCircle] The code for ",
  StyleBox["NDSolve", "MR"],
  " and related functions is about 1400 pages long.  "
}], "Notes",
  CellTags->{"SA.9.4", "4.84"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Approximate equation solving and optimization", "Subsubsection",
  CellTags->{"SA.9.4", "4.85"}],

Cell["\<\
\[FilledSmallCircle] Polynomial root finding is done based on the \
Jenkins\[Hyphen]Traub algorithm. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.86", "NSolve"}],

Cell[TextData[{
  "\[FilledSmallCircle] For sparse linear systems, ",
  StyleBox["Solve", "MR"],
  " and ",
  StyleBox["NSolve", "MR"],
  " use several efficient numerical methods, mostly based on Gauss factoring \
with Markowitz products (approximately 250 pages of code). "
}], "Notes",
  CellTags->{"SA.9.4", "4.87"}],

Cell[TextData[{
  "\[FilledSmallCircle] For systems of algebraic equations, ",
  StyleBox["NSolve", "MR"],
  " computes a numerical Gr\[ODoubleDot]bner basis using an efficient \
monomial ordering, then uses eigensystem methods to extract numerical roots. \
"
}], "Notes",
  CellTags->{"SA.9.4", "4.88"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["FindRoot", "MR"],
  " uses a damped Newton's method, the secant method and Brent's method. "
}], "Notes",
  CellTags->{"SA.9.4", "4.89", "FindRoot"}],

Cell[TextData[{
  "\[FilledSmallCircle] With ",
  StyleBox["Method->Automatic", "MR"],
  " and two starting values, ",
  StyleBox["FindMinimum", "MR"],
  " uses Brent's principal axis method. With one starting value for each \
variable, ",
  StyleBox["FindMinimum", "MR"],
  " uses BFGS quasi\[Hyphen]Newton methods, with a limited memory variant for \
large systems. "
}], "Notes",
  CellTags->{"SA.9.4", "4.90", "FindMaximum", "FindMinimum"}],

Cell[TextData[{
  "\[FilledSmallCircle] If the function to be minimized is a sum of squares, \
",
  StyleBox["FindMinimum", "MR"],
  " uses the Levenberg\[Hyphen]Marquardt method (",
  StyleBox["Method->LevenbergMarquardt", "MR"],
  "). "
}], "Notes",
  CellTags->{"SA.9.4", "4.91"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["LinearProgramming", "MR"],
  " uses simplex and revised simplex methods, and with ",
  StyleBox["Method->\"InteriorPoint\"", "MR"],
  " uses primal\[Hyphen]dual interior point methods. "
}], "Notes",
  CellTags->{"SA.9.4", "4.92", "LinearProgramming"}],

Cell[TextData[{
  "\[FilledSmallCircle] For linear cases, ",
  StyleBox["NMinimize", "MR"],
  " and ",
  StyleBox["NMaximize", "MR"],
  " use the same methods as ",
  StyleBox["LinearProgramming", "MR"],
  ". For nonlinear cases, they use Nelder\[Hyphen]Mead methods, supplemented \
by differential evolution, especially when integer variables are present.   "
}], "Notes",
  CellTags->{"SA.9.4", "4.93", "NMinimize", "NMaximize"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data manipulation", "Subsubsection",
  CellTags->{"SA.9.4", "4.94"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Fourier", "MR"],
  " uses the FFT algorithm with decomposition of the length into prime \
factors. When the prime factors are large, fast convolution methods are used \
to maintain ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["O",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], "log", 
              RowBox[{"(", 
                StyleBox["n",
                  "TI"], ")"}]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  " asymptotic complexity. "
}], "Notes",
  CellTags->{"SA.9.4", "4.95", "Fourier"}],

Cell[TextData[{
  "\[FilledSmallCircle] For real input, ",
  StyleBox["Fourier", "MR"],
  " uses a real transform method. "
}], "Notes",
  CellTags->{"SA.9.4", "4.96"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["ListConvolve", "MR"],
  " and ",
  StyleBox["ListCorrelate", "MR"],
  " use FFT algorithms when possible. For exact integer inputs, enough digits \
are computed to deduce exact integer results. "
}], "Notes",
  CellTags->{"SA.9.4", "4.97", "ListConvolve", "ListCorrelate"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["InterpolatingFunction", "MR"],
  " uses divided differences to construct Lagrange or Hermite interpolating \
polynomials. "
}], "Notes",
  CellTags->{"SA.9.4", "4.98", "InterpolatingFunction"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Fit", "MR"],
  " works using singular value decomposition. ",
  StyleBox["FindFit", "MR"],
  " uses the same method for the linear least\[Hyphen]squares case, the \
Levenberg\[Hyphen]Marquardt method for nonlinear least\[Hyphen]squares, and \
general ",
  StyleBox["FindMinimum", "MR"],
  " methods for other norms. "
}], "Notes",
  CellTags->{"SA.9.4", "4.99", "Fit", "FindFit"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["CellularAutomaton", "MR"],
  " uses bit\[Hyphen]packed parallel operations with bit slicing. For \
elementary rules, absolutely optimal Boolean functions are used, while for \
totalistic rules, just\[Hyphen]in\[Hyphen]time\[Hyphen]compiled \
bit\[Hyphen]packed tables are used. In two dimensions, sparse \
bit\[Hyphen]packed arrays are used when possible, with only active clusters \
updated.  "
}], "Notes",
  CellTags->{"SA.9.4", "4.100", "CellularAutomaton"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Approximate numerical linear algebra", "Subsubsection",
  CellTags->{"SA.9.4", "4.101"}],

Cell["\<\
\[FilledSmallCircle] Machine\[Hyphen]precision matrices are \
typically converted to a special internal representation for processing. \
\
\>", "Notes",
  CellTags->{"SA.9.4", "4.102"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["SparseArray", "MR"],
  " with rules involving patterns uses cylindrical algebraic decomposition to \
find connected array components. Sparse arrays are stored internally using \
compressed sparse row formats, generalized for tensors of arbitrary rank. "
}], "Notes",
  CellTags->{"SA.9.4", "4.103", "SparseArray"}],

Cell["\<\
\[FilledSmallCircle] For dense arrays, LAPACK algorithms extended \
for arbitrary precision are used when appropriate. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.104"}],

Cell["\<\
\[FilledSmallCircle] BLAS technology is used to optimize for \
particular machine architectures. \
\>", "Notes",
  CellTags->{"SA.9.4", "4.105"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["LUDecomposition", "MR"],
  ", ",
  StyleBox["Inverse", "MR"],
  ", ",
  StyleBox["RowReduce", "MR"],
  " and ",
  StyleBox["Det", "MR"],
  " use Gaussian elimination with partial pivoting. ",
  StyleBox["LinearSolve", "MR"],
  " uses the same methods, together with adaptive iterative improvement for \
high\[Hyphen]precision numbers. "
}], "Notes",
  CellTags->{
  "SA.9.4", "4.106", "LinearSolve", "LUDecomposition", "Inverse", "RowReduce",
     "Det"}],

Cell[TextData[{
  "\[FilledSmallCircle] For sparse arrays, ",
  StyleBox["LinearSolve", "MR"],
  " uses UMFPACK multifrontal direct solver methods and with ",
  StyleBox["Method->\"Krylov\"", "MR"],
  " uses Krylov iterative methods preconditioned by an incomplete LU \
factorization. For high\[Hyphen]precision numbers, it uses adaptive iterative \
improvement methods. ",
  StyleBox["Eigenvalues", "MR"],
  " and ",
  StyleBox["Eigenvectors", "MR"],
  " use ARPACK Arnoldi methods. "
}], "Notes",
  CellTags->{"SA.9.4", "4.107", "LinearSolve", "Eigenvalues", "Eigenvectors"}],\


Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["SingularValueDecomposition", "MR"],
  " uses the QR algorithm with Givens rotations. ",
  StyleBox["PseudoInverse", "MR"],
  ", ",
  StyleBox["NullSpace", "MR"],
  " and ",
  StyleBox["MatrixRank", "MR"],
  " are based on ",
  StyleBox["SingularValueDecomposition", "MR"],
  ". For sparse arrays, Arnoldi methods are used. "
}], "Notes",
  CellTags->{
  "SA.9.4", "4.108", "SingularValueDecomposition", "MatrixRank", "NullSpace"}],\


Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["QRDecomposition", "MR"],
  " uses Householder transformations. "
}], "Notes",
  CellTags->{"SA.9.4", "4.109", "QRDecomposition"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["SchurDecomposition", "MR"],
  " uses QR iteration. "
}], "Notes",
  CellTags->{"SA.9.4", "4.110", "SchurDecomposition"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["MatrixExp", "MR"],
  " uses variable\[Hyphen]order Pad\[EAcute] approximation, evaluating \
rational matrix functions using Paterson\[Hyphen]Stockmeyer methods.   "
}], "Notes",
  CellTags->{"SA.9.4", "4.111", "MatrixExp"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exact numerical linear algebra", "Subsubsection",
  CellTags->{"SA.9.4", "4.112"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Inverse", "MR"],
  " and ",
  StyleBox["LinearSolve", "MR"],
  " use efficient row reduction based on numerical approximation. "
}], "Notes",
  CellTags->{"SA.9.4", "4.113", "Inverse", "LinearSolve"}],

Cell[TextData[{
  "\[FilledSmallCircle] With ",
  StyleBox["Modulus->", "MR"],
  StyleBox["n", "TI"],
  ", modular Gaussian elimination is used. "
}], "Notes",
  CellTags->{"SA.9.4", "4.114"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Det", "MR"],
  " uses modular methods and row reduction, constructing a result using the \
Chinese Remainder Theorem. "
}], "Notes",
  CellTags->{"SA.9.4", "4.115", "Det"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Eigenvalues", "MR"],
  " works by interpolating the characteristic polynomial. "
}], "Notes",
  CellTags->{"SA.9.4", "4.116"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["MatrixExp", "MR"],
  " uses Putzer's method or Jordan decomposition.  "
}], "Notes",
  CellTags->{"SA.9.4", "4.117"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.9.5 Algebra and Calculus", "Subsection",
  CellTags->{"SA.9.5", "5.1"}],

Cell[CellGroupData[{

Cell["Polynomial manipulation", "Subsubsection",
  CellTags->{"SA.9.5", "5.2"}],

Cell[TextData[{
  "\[FilledSmallCircle] For univariate polynomials, ",
  StyleBox["Factor", "MR"],
  " uses a variant of the Cantor\[Hyphen]Zassenhaus algorithm to factor \
modulo a prime, then uses Hensel lifting and recombination to build up \
factors over the integers. "
}], "Notes",
  CellTags->{"SA.9.5", "5.3", "Factor"}],

Cell["\<\
\[FilledSmallCircle] Factoring over algebraic number fields is done \
by finding a primitive element over the rationals and then using Trager's \
algorithm. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.4"}],

Cell[TextData[{
  "\[FilledSmallCircle] For multivariate polynomials ",
  StyleBox["Factor", "MR"],
  " works by substituting appropriate choices of integers for all but one \
variable, then factoring the resulting univariate polynomials, and \
reconstructing multivariate factors using Wang's algorithm. "
}], "Notes",
  CellTags->{"SA.9.5", "5.5"}],

Cell[TextData[{
  "\[FilledSmallCircle] The internal code for ",
  StyleBox["Factor", "MR"],
  " exclusive of general polynomial manipulation is about 250 pages long. "
}], "Notes",
  CellTags->{"SA.9.5", "5.6"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["FactorSquareFree", "MR"],
  " works by finding a derivative and then iteratively computing GCDs. "
}], "Notes",
  CellTags->{"SA.9.5", "5.7"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Resultant", "MR"],
  " uses either explicit subresultant polynomial remainder sequences or \
modular sequences accompanied by the Chinese Remainder Theorem. "
}], "Notes",
  CellTags->{"SA.9.5", "5.8"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Apart", "MR"],
  " uses either a version of the Pad\[EAcute] technique or the method of \
undetermined coefficients. "
}], "Notes",
  CellTags->{"SA.9.5", "5.9"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["PolynomialGCD", "MR"],
  " and ",
  StyleBox["Together", "MR"],
  " usually use modular algorithms, including Zippel's sparse modular \
algorithm, but in some cases use subresultant polynomial remainder sequences. \
"
}], "Notes",
  CellTags->{"SA.9.5", "5.10"}],

Cell["\<\
\[FilledSmallCircle] For multivariate polynomials the Chinese \
Remainder Theorem together with sparse interpolation are also used.  \
\>", \
"Notes",
  CellTags->{"SA.9.5", "5.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic linear algebra", "Subsubsection",
  CellTags->{"SA.9.5", "5.12"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["RowReduce", "MR"],
  ", ",
  StyleBox["LinearSolve", "MR"],
  ", ",
  StyleBox["NullSpace", "MR"],
  " and ",
  StyleBox["MatrixRank", "MR"],
  " are based on Gaussian elimination. "
}], "Notes",
  CellTags->{"SA.9.5", "5.13", "NullSpace", "MatrixRank"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Inverse", "MR"],
  " uses cofactor expansion and row reduction. Pivots are chosen \
heuristically by looking for simple expressions. "
}], "Notes",
  CellTags->{"SA.9.5", "5.14"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Det", "MR"],
  " uses direct cofactor expansion for small matrices, and Gaussian \
elimination for larger ones. "
}], "Notes",
  CellTags->{"SA.9.5", "5.15"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["MatrixExp", "MR"],
  " finds eigenvalues and then uses Putzer's method. "
}], "Notes",
  CellTags->{"SA.9.5", "5.16", "MatrixExp"}],

Cell["\<\
\[FilledSmallCircle] Zero testing for various functions is done \
using symbolic transformations and interval\[Hyphen]based numerical \
approximations after random numerical values have been substituted for \
variables.  \
\>", "Notes",
  CellTags->{"SA.9.5", "5.17"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exact equation solving and reduction", "Subsubsection",
  CellTags->{"SA.9.5", "5.18"}],

Cell["\<\
\[FilledSmallCircle] For linear equations Gaussian elimination and \
other methods of linear algebra are used. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.19"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Root", "MR"],
  " objects representing algebraic numbers are usually isolated and \
manipulated using validated numerical methods. With ",
  StyleBox["ExactRootIsolation->True", "MR"],
  ", ",
  StyleBox["Root", "MR"],
  " uses for real roots a continued fraction version of an algorithm based on \
Descartes' rule of signs, and for complex roots the Collins\[Hyphen]Krandick \
algorithm. "
}], "Notes",
  CellTags->{"SA.9.5", "5.20"}],

Cell[TextData[{
  "\[FilledSmallCircle] For single polynomial equations, ",
  StyleBox["Solve", "MR"],
  " uses explicit formulas up to degree four, attempts to reduce polynomials \
using ",
  StyleBox["Factor", "MR"],
  " and ",
  StyleBox["Decompose", "MR"],
  ", and recognizes cyclotomic and other special polynomials. "
}], "Notes",
  CellTags->{"SA.9.5", "5.21"}],

Cell[TextData[{
  "\[FilledSmallCircle] For systems of polynomial equations, ",
  StyleBox["Solve", "MR"],
  " constructs a Gr\[ODoubleDot]bner basis. "
}], "Notes",
  CellTags->{"SA.9.5", "5.22", "Solve"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Solve", "MR"],
  " and ",
  StyleBox["GroebnerBasis", "MR"],
  " use an efficient version of the Buchberger algorithm. "
}], "Notes",
  CellTags->{"SA.9.5", "5.23", "GroebnerBasis"}],

Cell[TextData[{
  "\[FilledSmallCircle] For non\[Hyphen]polynomial equations, ",
  StyleBox["Solve", "MR"],
  " attempts to change variables and add polynomial side conditions. "
}], "Notes",
  CellTags->{"SA.9.5", "5.24"}],

Cell[TextData[{
  "\[FilledSmallCircle] The code for ",
  StyleBox["Solve", "MR"],
  " and related functions is about 500 pages long. "
}], "Notes",
  CellTags->{"SA.9.5", "5.25"}],

Cell[TextData[{
  "\[FilledSmallCircle] For polynomial systems ",
  StyleBox["Reduce", "MR"],
  " uses cylindrical algebraic decomposition for real domains and Gr\
\[ODoubleDot]bner basis methods for complex domains. "
}], "Notes",
  CellTags->{"SA.9.5", "5.26", "Reduce"}],

Cell[TextData[{
  "\[FilledSmallCircle] With algebraic functions, ",
  StyleBox["Reduce", "MR"],
  " constructs equivalent purely polynomial systems. With transcendental \
functions, ",
  StyleBox["Reduce", "MR"],
  " generates polynomial systems composed with transcendental conditions, \
then reduces these using functional relations and a database of inverse image \
information. With piecewise functions, ",
  StyleBox["Reduce", "MR"],
  " does symbolic expansion to construct a collection of continuous systems. \
"
}], "Notes",
  CellTags->{"SA.9.5", "5.27"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["CylindricalDecomposition", "MR"],
  " uses the Collins\[Hyphen]Hong algorithm with Brown\[Hyphen]McCallum \
projection for well\[Hyphen]oriented sets and Hong projection for other sets. \
CAD construction is done by Strzebonski's genealogy\[Hyphen]based method \
using validated numerics backed up by exact algebraic number computation. For \
zero\[Hyphen]dimensional systems Gr\[ODoubleDot]bner basis methods are used. \
"
}], "Notes",
  CellTags->{"SA.9.5", "5.28", "CylindricalDecomposition"}],

Cell[TextData[{
  "\[FilledSmallCircle] For Diophantine systems, ",
  StyleBox["Reduce", "MR"],
  " solves linear equations using Hermite normal form, and linear \
inequalities using Contejean\[Hyphen]Devie methods. For univariate polynomial \
equations it uses an improved Cucker\[Hyphen]Koiran\[Hyphen]Smale method, \
while for bivariate quadratic equations, it uses \
Hardy\[Hyphen]Muskat\[Hyphen]Williams methods for ellipses, and classical \
techniques for Pell and other cases. ",
  StyleBox["Reduce", "MR"],
  " includes specialized methods for about 25 classes of Diophantine \
equations, including the Tzanakis\[Hyphen]de Weger algorithm for Thue \
equations. "
}], "Notes",
  CellTags->{"SA.9.5", "5.29"}],

Cell[TextData[{
  "\[FilledSmallCircle] With prime moduli, ",
  StyleBox["Reduce", "MR"],
  " uses linear algebra for linear equations and Gr\[ODoubleDot]bner bases \
over prime fields for polynomial equations. For composite moduli, it uses \
Hermite normal form and Gr\[ODoubleDot]bner bases over integers. "
}], "Notes",
  CellTags->{"SA.9.5", "5.30"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Resolve", "MR"],
  " mainly uses an optimized subset of the methods from ",
  StyleBox["Reduce", "MR"],
  ". "
}], "Notes",
  CellTags->{"SA.9.5", "5.31", "Resolve"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Reduce", "MR"],
  " and related functions use about 350 pages of ",
  StyleBox["Mathematica", "TI"],
  " code and 1400 pages of C code.  "
}], "Notes",
  CellTags->{"SA.9.5", "5.32"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exact optimization", "Subsubsection",
  CellTags->{"SA.9.5", "5.33"}],

Cell[TextData[{
  "\[FilledSmallCircle] For linear cases, ",
  StyleBox["Minimize", "MR"],
  " and ",
  StyleBox["Maximize", "MR"],
  " use exact linear programming methods. For polynomial cases they use \
cylindrical algebraic decomposition. "
}], "Notes",
  CellTags->{"SA.9.5", "5.34", "Maximize", "Minimize"}],

Cell["\<\
\[FilledSmallCircle] Piecewise functions are symbolically expanded, \
with each case being treated as a separate optimization problem.  \
\>", \
"Notes",
  CellTags->{"SA.9.5", "5.35"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simplification", "Subsubsection",
  CellTags->{"SA.9.5", "5.36"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["FullSimplify", "MR"],
  " automatically applies about 40 types of general algebraic \
transformations, as well as about 400 types of rules for specific \
mathematical functions. "
}], "Notes",
  CellTags->{"SA.9.5", "5.37", "FunctionExpand", "FullSimplify", "Simplify"}],\


Cell[TextData[{
  "\[FilledSmallCircle] Generalized hypergeometric functions are simplified \
using about 70 pages of ",
  StyleBox["Mathematica", "TI"],
  " transformation rules. These functions are fundamental to many calculus \
operations in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->{"SA.9.5", "5.38"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["FunctionExpand", "MR"],
  " uses an extension of Gauss's algorithm to expand trigonometric functions \
with arguments that are rational multiples of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"SA.9.5", "5.39"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Simplify", "MR"],
  " and ",
  StyleBox["FullSimplify", "MR"],
  " cache results when appropriate. "
}], "Notes",
  CellTags->{"SA.9.5", "5.40"}],

Cell["\<\
\[FilledSmallCircle] When assumptions specify that variables are \
real, polynomial constraints are handled by cylindrical algebraic \
decomposition, while linear constraints are handled by the simplex algorithm \
or Loos\[Hyphen]Weispfenning linear quantifier elimination. For strict \
polynomial inequalities, Strzebonski's generic CAD algorithm is used. \
\>", \
"Notes",
  CellTags->{"SA.9.5", "5.41"}],

Cell["\<\
\[FilledSmallCircle] When assumptions involve equations among \
polynomials, Gr\[ODoubleDot]bner basis methods are used. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.42"}],

Cell["\<\
\[FilledSmallCircle] For non\[Hyphen]algebraic functions, a \
database of relations is used to determine the domains of function values \
from the domains of their arguments. Polynomial\[Hyphen]oriented algorithms \
are used whenever the resulting domains correspond to semi\[Hyphen]algebraic \
sets. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.43"}],

Cell[TextData[{
  "\[FilledSmallCircle] For integer functions, several hundred theorems of \
number theory are used in the form of ",
  StyleBox["Mathematica", "TI"],
  " rules. "
}], "Notes",
  CellTags->{"SA.9.5", "5.44"}],

Cell["\<\
\[FilledSmallCircle] Piecewise functions are handled using a \
recursive procedure based on piecewise distributivity.  \
\>", "Notes",
  CellTags->{"SA.9.5", "5.45", "Piecewise", "PiecewiseExpand"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Differentiation and integration", "Subsubsection",
  CellTags->{"SA.9.5", "5.46"}],

Cell["\<\
\[FilledSmallCircle] Differentiation uses caching to avoid \
recomputing partial results. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.47", "D"}],

Cell["\<\
\[FilledSmallCircle] For indefinite integrals, an extended version \
of the Risch algorithm is used whenever both the integrand and integral can \
be expressed in terms of elementary functions, exponential integral \
functions, polylogarithms and other related functions. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.48", "Integrate"}],

Cell["\<\
\[FilledSmallCircle] For other indefinite integrals, heuristic \
simplification followed by pattern matching is used. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.49"}],

Cell[TextData[{
  "\[FilledSmallCircle] The algorithms in ",
  StyleBox["Mathematica", "TI"],
  " cover all of the indefinite integrals in standard reference books such as \
Gradshteyn\[Hyphen]Ryzhik. "
}], "Notes",
  CellTags->{"SA.9.5", "5.50"}],

Cell["\<\
\[FilledSmallCircle] Definite integrals that involve no \
singularities are mostly done by taking limits of the indefinite integrals. \
\
\>", "Notes",
  CellTags->{"SA.9.5", "5.51"}],

Cell["\<\
\[FilledSmallCircle] Many other definite integrals are done using \
Marichev\[Hyphen]Adamchik Mellin transform methods. The results are often \
initially expressed in terms of Meijer G functions, which are converted into \
hypergeometric functions using Slater's Theorem and then simplified. \
\>", \
"Notes",
  CellTags->{"SA.9.5", "5.52"}],

Cell["\<\
\[FilledSmallCircle] Integrals over multidimensional regions \
defined by inequalities are computed by iterative decomposition into disjoint \
cylindrical or triangular cells. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.53"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Integrate", "MR"],
  " uses about 500 pages of ",
  StyleBox["Mathematica", "TI"],
  " code and 600 pages of C code.  "
}], "Notes",
  CellTags->{"SA.9.5", "5.54"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Differential equations", "Subsubsection",
  CellTags->{"SA.9.5", "5.55"}],

Cell["\<\
\[FilledSmallCircle] Systems of linear equations with constant \
coefficients are solved using matrix exponentiation. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.56", "DSolve"}],

Cell["\<\
\[FilledSmallCircle] Second\[Hyphen]order linear equations with \
variable coefficients whose solutions can be expressed in terms of elementary \
functions and their integrals are solved using the Kovacic algorithm. \
\>", \
"Notes",
  CellTags->{"SA.9.5", "5.57"}],

Cell["\<\
\[FilledSmallCircle] Higher\[Hyphen]order linear equations are \
solved using Abramov and Bronstein algorithms. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.58"}],

Cell["\<\
\[FilledSmallCircle] Linear equations with rational function \
coefficients are solved in terms of special functions by using Mellin \
transforms. Equations with more general coefficients are if possible reduced \
using variable transformations. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.59"}],

Cell["\<\
\[FilledSmallCircle] Systems of linear equations with rational \
function coefficients whose solutions can be given as rational functions are \
solved using Abramov\[Hyphen]Bronstein elimination algorithms. \
\>", "Notes",\

  CellTags->{"SA.9.5", "5.60"}],

Cell["\<\
\[FilledSmallCircle] When possible, nonlinear equations are solved \
by symmetry reduction techniques. For first\[Hyphen]order equations many \
classical techniques are used; for second\[Hyphen]order equations and systems \
integrating factor and Bocharov techniques are used. Abel equations are \
solved by computing invariants to determine equivalence classes. \
\>", \
"Notes",
  CellTags->{"SA.9.5", "5.61"}],

Cell["\<\
\[FilledSmallCircle] Piecewise equations are typically solved by \
decomposition into collections of boundary\[Hyphen]value problems. \
\>", \
"Notes",
  CellTags->{"SA.9.5", "5.62"}],

Cell[TextData[{
  "\[FilledSmallCircle] The algorithms in ",
  StyleBox["Mathematica", "TI"],
  " cover almost all of the ordinary differential equations in standard \
reference books such as Kamke. "
}], "Notes",
  CellTags->{"SA.9.5", "5.63"}],

Cell["\<\
\[FilledSmallCircle] For linear and quasilinear partial \
differential equations, separation of variables and symmetry reduction are \
used. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.64"}],

Cell["\<\
\[FilledSmallCircle] For first\[Hyphen]order nonlinear PDEs, \
complete integrals are computed by reduction through Legendre, Euler and \
other transformations. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.65"}],

Cell["\<\
\[FilledSmallCircle] For differential\[Hyphen]algebraic equations, \
a method based on isolating singular parts by core nilpotent decomposition is \
used. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.66"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["DSolve", "MR"],
  " uses about 300 pages of ",
  StyleBox["Mathematica", "TI"],
  " code and 200 pages of C code.  "
}], "Notes",
  CellTags->{"SA.9.5", "5.67"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sums and products", "Subsubsection",
  CellTags->{"SA.9.5", "5.68"}],

Cell["\<\
\[FilledSmallCircle] Polynomial series are summed using Bernoulli \
and Euler polynomials. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.69", "Sum", "Product"}],

Cell["\<\
\[FilledSmallCircle] Series involving rational and factorial \
functions are summed using Adamchik techniques in terms of generalized \
hypergeometric functions, which are then simplified. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.70"}],

Cell["\<\
\[FilledSmallCircle] Series involving polygamma functions are \
summed using integral representations. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.71"}],

Cell["\<\
\[FilledSmallCircle] Dirichlet and related series are summed using \
pattern matching. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.72"}],

Cell["\<\
\[FilledSmallCircle] For infinite series, d'Alembert and Raabe \
convergence tests are used. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.73"}],

Cell[TextData[{
  "\[FilledSmallCircle] The algorithms in ",
  StyleBox["Mathematica", "TI"],
  " cover at least 90% of the sums in standard reference books such as \
Gradshteyn\[Hyphen]Ryzhik. "
}], "Notes",
  CellTags->{"SA.9.5", "5.74"}],

Cell["\<\
\[FilledSmallCircle] Products are done primarily using pattern \
matching. \
\>", "Notes",
  CellTags->{"SA.9.5", "5.75"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Sum", "MR"],
  " and ",
  StyleBox["Product", "MR"],
  " use about 100 pages of ",
  StyleBox["Mathematica", "TI"],
  " code.  "
}], "Notes",
  CellTags->{"SA.9.5", "5.76"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series and limits", "Subsubsection",
  CellTags->{"SA.9.5", "5.77"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["Series", "MR"],
  " works by recursively composing series expansions of functions with series \
expansions of their arguments. "
}], "Notes",
  CellTags->{"SA.9.5", "5.78", "Series"}],

Cell["\<\
\[FilledSmallCircle] Limits are found from series and using other \
methods.  \
\>", "Notes",
  CellTags->{"SA.9.5", "5.79"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Recurrence equations", "Subsubsection",
  CellTags->{"SA.9.5", "5.80"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["RSolve", "MR"],
  " solves systems of linear equations with constant coefficients using \
matrix powers. "
}], "Notes",
  CellTags->{"SA.9.5", "5.81", "RSolve"}],

Cell["\<\
\[FilledSmallCircle] Linear equations with polynomial coefficients \
whose solutions can be given as hypergeometric terms are solved using van \
Hoeij algorithms.  \
\>", "Notes",
  CellTags->{"SA.9.5", "5.82"}],

Cell["\<\
\[FilledSmallCircle] Systems of linear equations with rational \
function coefficients whose solutions can be given as rational functions are \
solved using Abramov\[Hyphen]Bronstein elimination algorithms. \
\>", "Notes",\

  CellTags->{"SA.9.5", "5.83"}],

Cell["\<\
\[FilledSmallCircle] Nonlinear equations are solved by \
transformation of variables, G\[ODoubleDot]kta\:015f symmetry reduction \
methods or Germundsson trigonometric power methods.  \
\>", "Notes",
  CellTags->{"SA.9.5", "5.84"}],

Cell[TextData[{
  "\[FilledSmallCircle] The algorithms in ",
  StyleBox["Mathematica", "TI"],
  " cover most of the ordinary and ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]difference equations ever discussed in the mathematical \
literature. "
}], "Notes",
  CellTags->{"SA.9.5", "5.85"}],

Cell["\<\
\[FilledSmallCircle] For difference\[Hyphen]algebraic equations, a \
method based on isolating singular parts by core nilpotent decomposition is \
used.   \
\>", "Notes",
  CellTags->{"SA.9.5", "5.86"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.9.6 Output and Interfacing", "Subsection",
  CellTags->{"SA.9.6", "6.1"}],

Cell[CellGroupData[{

Cell["Graphics", "Subsubsection",
  CellTags->{"SA.9.6", "6.2"}],

Cell["\<\
\[FilledSmallCircle]  Hidden\[Hyphen]surface elimination for 3D \
graphics is done so as to be independent of display resolution. \
\>", "Notes",\

  CellTags->{"SA.9.6", "6.3", "Plot3D"}],

Cell["\<\
\[FilledSmallCircle] A custom\[Hyphen]written PostScript \
interpreter is used to render graphics in the front end. \
\>", "Notes",
  CellTags->{"SA.9.6", "6.4"}],

Cell["\<\
\[FilledSmallCircle] Notebooks use a custom \
platform\[Hyphen]independent bitmap image format.  \
\>", "Notes",
  CellTags->{"SA.9.6", "6.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Front end", "Subsubsection",
  CellTags->{"SA.9.6", "6.6"}],

Cell[TextData[{
  "\[FilledSmallCircle] The front end uses ",
  StyleBox["MathLink", "TI"],
  " both for communication with the kernel, and for communication between its \
different internal components. "
}], "Notes",
  CellTags->{"SA.9.6", "6.7"}],

Cell[TextData[{
  "\[FilledSmallCircle] All menu items and other functions in the front end \
are specified using ",
  StyleBox["Mathematica", "TI"],
  " expressions. "
}], "Notes",
  CellTags->{"SA.9.6", "6.8"}],

Cell[TextData[{
  "\[FilledSmallCircle] Configuration and preference files use ",
  StyleBox["Mathematica", "TI"],
  " language format. "
}], "Notes",
  CellTags->{"SA.9.6", "6.9"}],

Cell[TextData[{
  "\[FilledSmallCircle] The Help Browser is based on ",
  StyleBox["Mathematica", "TI"],
  " notebooks generated from the same source code as this book.  "
}], "Notes",
  CellTags->{"SA.9.6", "6.10"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notebooks", "Subsubsection",
  CellTags->{"SA.9.6", "6.11"}],

Cell[TextData[{
  "\[FilledSmallCircle] Notebooks are represented as ",
  StyleBox["Mathematica", "TI"],
  " expressions. "
}], "Notes",
  CellTags->{"SA.9.6", "6.12"}],

Cell[TextData[{
  "\[FilledSmallCircle] Notebook files contain additional cached outline \
information in the form of ",
  StyleBox["Mathematica", "TI"],
  " comments. This information makes possible efficient random access. "
}], "Notes",
  CellTags->{"SA.9.6", "6.13"}],

Cell["\<\
\[FilledSmallCircle] Incremental saving of notebooks is done so as \
to minimize rewriting of data, moving data already written out whenever \
possible. \
\>", "Notes",
  CellTags->{"SA.9.6", "6.14"}],

Cell["\<\
\[FilledSmallCircle] Platform\[Hyphen]independent \
double\[Hyphen]buffering is used by default to minimize flicker when window \
contents are updated. \
\>", "Notes",
  CellTags->{"SA.9.6", "6.15"}],

Cell["\<\
\[FilledSmallCircle] Autoscrolling uses a \
control\[Hyphen]theoretical mechanism to optimize smoothness and \
controllability. \
\>", "Notes",
  CellTags->{"SA.9.6", "6.16"}],

Cell["\<\
\[FilledSmallCircle] All special characters are \
platform\[Hyphen]independently represented using Unicode. Mapping tables are \
set up for specific Kanji and other fonts. \
\>", "Notes",
  CellTags->{"SA.9.6", "6.17"}],

Cell[TextData[{
  "\[FilledSmallCircle] Spell checking and hyphenation are done using \
algorithms and a 100,000\[Hyphen]word standard English dictionary, together \
with a 20,000\[Hyphen]word technical dictionary, with 5000 ",
  StyleBox["Mathematica", "TI"],
  " and other words added. Spelling correction is done using textual and \
phonetic metrics.   "
}], "Notes",
  CellTags->{"SA.9.6", "6.18"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["MathLink", "SBO"]], "Subsubsection",
  CellTags->{"SA.9.6", "6.19"}],

Cell[TextData[{
  "\[FilledSmallCircle] In OSI terms, ",
  StyleBox["MathLink", "TI"],
  " is a presentation\[Hyphen]level protocol, which can be layered on top of \
any transport medium, both message\[Hyphen]based and stream\[Hyphen]based. "
}], "Notes",
  CellTags->{"SA.9.6", "6.20"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["MathLink", "TI"],
  " encodes data in a compressed format when it determines that both ends of \
a link are on compatible computer systems. "
}], "Notes",
  CellTags->{"SA.9.6", "6.21"}],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox["MathLink", "TI"],
  " can transmit out\[Hyphen]of\[Hyphen]band data such as interrupts as well \
as ",
  StyleBox["Mathematica", "TI"],
  " expressions. "
}], "Notes",
  CellTags->{"SA.9.6", "6.22"}],

Cell[TextData[{
  "\[FilledSmallCircle] When possible ",
  StyleBox["MathLink", "TI"],
  " is implemented using dynamically linked shared libraries.  "
}], "Notes",
  CellTags->{"SA.9.6", "6.23"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expression formatting", "Subsubsection",
  CellTags->{"SA.9.6", "6.24"}],

Cell["\<\
\[FilledSmallCircle] The front end uses a directed acyclic graph to \
represent the box structure of formatted expressions. \
\>", "Notes",
  CellTags->{"SA.9.6", "6.25"}],

Cell["\<\
\[FilledSmallCircle] Boxes are interpreted using a \
two\[Hyphen]dimensional generalization of an operator precedence parser. \
\
\>", "Notes",
  CellTags->{"SA.9.6", "6.26"}],

Cell["\<\
\[FilledSmallCircle] Incremental parsing is used to minimize \
structure and display updating. \
\>", "Notes",
  CellTags->{"SA.9.6", "6.27"}],

Cell["\<\
\[FilledSmallCircle] Character spacing and positioning are \
determined from font data and operator tables. \
\>", "Notes",
  CellTags->{"SA.9.6", "6.28"}],

Cell["\<\
\[FilledSmallCircle] Line breaking is globally optimized throughout \
expressions, based on a method similar to the one used for text layout in \
TeX. \
\>", "Notes",
  CellTags->{"SA.9.6", "6.29"}],

Cell["\<\
\[FilledSmallCircle] During input, linebreaking is set up so that \
small changes to expressions rarely cause large\[Hyphen]scale reformatting; \
if the input needs to jump, an elliptical cursor tracker momentarily appears \
to guide the eye.  \
\>", "Notes",
  CellTags->{"SA.9.6", "6.30"}],

Cell["\<\
\[FilledSmallCircle] Expression formatting uses about 2000 pages of \
C code.  \
\>", "Notes",
  CellTags->{"SA.9.6", "6.31"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.9.0"->{
    Cell[1776, 53, 140, 4, 65, "Section",
      CellTags->{"SA.9.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 140, 4, 65, "Section",
      CellTags->{"SA.9.0", "0.1"}]},
  "SA.9.1"->{
    Cell[1941, 61, 71, 1, 70, "Subsection",
      CellTags->{"SA.9.1", "1.1"}],
    Cell[2015, 64, 337, 9, 70, "Text",
      CellTags->{"SA.9.1", "1.2"}],
    Cell[2355, 75, 180, 4, 70, "Text",
      CellTags->{"SA.9.1", "1.3"}],
    Cell[2538, 81, 248, 5, 70, "Text",
      CellTags->{"SA.9.1", "1.4"}],
    Cell[2789, 88, 378, 8, 70, "Text",
      CellTags->{"SA.9.1", "1.5"}]},
  "1.1"->{
    Cell[1941, 61, 71, 1, 70, "Subsection",
      CellTags->{"SA.9.1", "1.1"}]},
  "1.2"->{
    Cell[2015, 64, 337, 9, 70, "Text",
      CellTags->{"SA.9.1", "1.2"}]},
  "1.3"->{
    Cell[2355, 75, 180, 4, 70, "Text",
      CellTags->{"SA.9.1", "1.3"}]},
  "1.4"->{
    Cell[2538, 81, 248, 5, 70, "Text",
      CellTags->{"SA.9.1", "1.4"}]},
  "1.5"->{
    Cell[2789, 88, 378, 8, 70, "Text",
      CellTags->{"SA.9.1", "1.5"}]},
  "SA.9.2"->{
    Cell[3204, 101, 96, 1, 70, "Subsection",
      CellTags->{"SA.9.2", "2.1"}],
    Cell[3303, 104, 237, 6, 70, "Text",
      CellTags->{"SA.9.2", "2.2"}],
    Cell[3543, 112, 165, 4, 70, "Text",
      CellTags->{"SA.9.2", "2.3"}],
    Cell[3711, 118, 193, 5, 70, "Text",
      CellTags->{"SA.9.2", "2.4"}],
    Cell[3907, 125, 247, 5, 70, "Text",
      CellTags->{"SA.9.2", "2.5"}],
    Cell[4157, 132, 249, 6, 70, "Text",
      CellTags->{"SA.9.2", "2.6"}],
    Cell[4409, 140, 384, 7, 70, "Text",
      CellTags->{"SA.9.2", "2.7"}],
    Cell[4796, 149, 635, 18, 70, "Text",
      CellTags->{"SA.9.2", "2.8"}]},
  "2.1"->{
    Cell[3204, 101, 96, 1, 70, "Subsection",
      CellTags->{"SA.9.2", "2.1"}]},
  "2.2"->{
    Cell[3303, 104, 237, 6, 70, "Text",
      CellTags->{"SA.9.2", "2.2"}]},
  "2.3"->{
    Cell[3543, 112, 165, 4, 70, "Text",
      CellTags->{"SA.9.2", "2.3"}]},
  "2.4"->{
    Cell[3711, 118, 193, 5, 70, "Text",
      CellTags->{"SA.9.2", "2.4"}]},
  "2.5"->{
    Cell[3907, 125, 247, 5, 70, "Text",
      CellTags->{"SA.9.2", "2.5"}]},
  "2.6"->{
    Cell[4157, 132, 249, 6, 70, "Text",
      CellTags->{"SA.9.2", "2.6"}]},
  "2.7"->{
    Cell[4409, 140, 384, 7, 70, "Text",
      CellTags->{"SA.9.2", "2.7"}]},
  "2.8"->{
    Cell[4796, 149, 635, 18, 70, "Text",
      CellTags->{"SA.9.2", "2.8"}]},
  "SA.9.3"->{
    Cell[5468, 172, 80, 1, 70, "Subsection",
      CellTags->{"SA.9.3", "3.1"}],
    Cell[5551, 175, 255, 6, 70, "Text",
      CellTags->{"SA.9.3", "3.2"}],
    Cell[5809, 183, 409, 11, 70, "Text",
      CellTags->{"SA.9.3", "3.3", "Rule"}],
    Cell[6221, 196, 164, 4, 70, "Text",
      CellTags->{"SA.9.3", "3.4"}],
    Cell[6388, 202, 141, 4, 70, "Text",
      CellTags->{"SA.9.3", "3.5"}],
    Cell[6532, 208, 198, 4, 70, "Text",
      CellTags->{"SA.9.3", "3.6", "RegularExpression", "StringExpression"}],
    Cell[6733, 214, 275, 6, 70, "Text",
      CellTags->{"SA.9.3", "3.7"}]},
  "3.1"->{
    Cell[5468, 172, 80, 1, 70, "Subsection",
      CellTags->{"SA.9.3", "3.1"}]},
  "3.2"->{
    Cell[5551, 175, 255, 6, 70, "Text",
      CellTags->{"SA.9.3", "3.2"}]},
  "3.3"->{
    Cell[5809, 183, 409, 11, 70, "Text",
      CellTags->{"SA.9.3", "3.3", "Rule"}]},
  "Rule"->{
    Cell[5809, 183, 409, 11, 70, "Text",
      CellTags->{"SA.9.3", "3.3", "Rule"}]},
  "3.4"->{
    Cell[6221, 196, 164, 4, 70, "Text",
      CellTags->{"SA.9.3", "3.4"}]},
  "3.5"->{
    Cell[6388, 202, 141, 4, 70, "Text",
      CellTags->{"SA.9.3", "3.5"}]},
  "3.6"->{
    Cell[6532, 208, 198, 4, 70, "Text",
      CellTags->{"SA.9.3", "3.6", "RegularExpression", "StringExpression"}]},
  "RegularExpression"->{
    Cell[6532, 208, 198, 4, 70, "Text",
      CellTags->{"SA.9.3", "3.6", "RegularExpression", "StringExpression"}]},
  "StringExpression"->{
    Cell[6532, 208, 198, 4, 70, "Text",
      CellTags->{"SA.9.3", "3.6", "RegularExpression", "StringExpression"}]},
  "3.7"->{
    Cell[6733, 214, 275, 6, 70, "Text",
      CellTags->{"SA.9.3", "3.7"}]},
  "SA.9.4"->{
    Cell[7045, 225, 90, 1, 70, "Subsection",
      CellTags->{"SA.9.4", "4.1"}],
    Cell[7160, 230, 102, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.2"}],
    Cell[7265, 233, 387, 10, 70, "Notes",
      CellTags->{"SA.9.4", "4.3"}],
    Cell[7655, 245, 150, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.4"}],
    Cell[7808, 251, 358, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.5", "IntegerDigits", "RealDigits"}],
    Cell[8169, 262, 253, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.6", "N"}],
    Cell[8425, 270, 310, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.7", "Floor", "Ceiling"}],
    Cell[8772, 284, 72, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.8"}],
    Cell[8847, 287, 299, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.9"}],
    Cell[9149, 295, 167, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.10"}],
    Cell[9319, 301, 161, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.11"}],
    Cell[9483, 307, 156, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.12"}],
    Cell[9642, 313, 124, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.13"}],
    Cell[9769, 319, 185, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.14"}],
    Cell[9991, 329, 77, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.15"}],
    Cell[10071, 332, 199, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.16", "Random"}],
    Cell[10273, 339, 179, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.17"}],
    Cell[10489, 348, 93, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.18"}],
    Cell[10585, 351, 327, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.19"}],
    Cell[10915, 361, 290, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.20", "PrimeQ"}],
    Cell[11208, 370, 501, 15, 70, "Notes",
      CellTags->{"SA.9.4", "4.21"}],
    Cell[11712, 387, 385, 10, 70, "Notes",
      CellTags->{"SA.9.4", "4.22"}],
    Cell[12100, 399, 378, 11, 70, "Notes",
      CellTags->{"SA.9.4", "4.23", "FactorInteger"}],
    Cell[12481, 412, 245, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.24"}],
    Cell[12729, 420, 557, 17, 70, "Notes",
      CellTags->{"SA.9.4", "4.25", "Prime", "PrimePi"}],
    Cell[13289, 439, 224, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.26", "LatticeReduce"}],
    Cell[13516, 447, 354, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.27"}],
    Cell[13873, 456, 245, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.28", "ContinuedFraction"}],
    Cell[14121, 464, 258, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.29", "FromContinuedFraction"}],
    Cell[14416, 475, 80, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.30"}],
    Cell[14499, 478, 143, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.31"}],
    Cell[14645, 484, 310, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.32", "Factorial", "Binomial"}],
    Cell[14958, 494, 278, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.33", "Fibonacci"}],
    Cell[15239, 505, 385, 12, 70, "Notes",
      CellTags->{"SA.9.4", "4.34", "PartitionsP"}],
    Cell[15627, 519, 206, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.35", "ClebschGordan"}],
    Cell[15870, 529, 92, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.36"}],
    Cell[15965, 532, 206, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.37"}],
    Cell[16174, 539, 165, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.38"}],
    Cell[16376, 548, 79, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.39"}],
    Cell[16458, 551, 126, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.40"}],
    Cell[16587, 557, 145, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.41"}],
    Cell[16735, 563, 165, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.42", "Pi"}],
    Cell[16903, 570, 160, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.43", "E"}],
    Cell[17066, 577, 182, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.44", "EulerGamma"}],
    Cell[17251, 584, 188, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.45", "Catalan"}],
    Cell[17476, 594, 74, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.46"}],
    Cell[17553, 597, 285, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.47"}],
    Cell[17841, 605, 197, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.48"}],
    Cell[18041, 612, 200, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.49", "Gamma"}],
    Cell[18244, 619, 167, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.50"}],
    Cell[18414, 625, 215, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.51", "PolyGamma"}],
    Cell[18632, 633, 251, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.52", "PolyLog"}],
    Cell[18886, 641, 291, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.53", "Zeta"}],
    Cell[19180, 650, 255, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.54", "StieltjesGamma"}],
    Cell[19438, 658, 200, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.55"}],
    Cell[19641, 665, 182, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.56"}],
    Cell[19826, 671, 197, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.57"}],
    Cell[20026, 678, 329, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.58"}],
    Cell[20358, 689, 232, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.59"}],
    Cell[20593, 697, 157, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.60"}],
    Cell[20753, 703, 169, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.61"}],
    Cell[20925, 709, 159, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.62"}],
    Cell[21087, 715, 205, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.63"}],
    Cell[21329, 725, 78, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.64"}],
    Cell[21410, 728, 302, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.65", "NIntegrate"}],
    Cell[21715, 737, 301, 11, 70, "Notes",
      CellTags->{"SA.9.4", "4.66"}],
    Cell[22019, 750, 269, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.67"}],
    Cell[22291, 761, 220, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.68"}],
    Cell[22514, 769, 193, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.69"}],
    Cell[22710, 776, 158, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.70"}],
    Cell[22871, 783, 219, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.71"}],
    Cell[23093, 791, 171, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.72"}],
    Cell[23267, 798, 160, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.73"}],
    Cell[23430, 805, 212, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.74"}],
    Cell[23679, 816, 84, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.75"}],
    Cell[23766, 819, 206, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.76", "NSum"}],
    Cell[23975, 826, 227, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.77"}],
    Cell[24239, 839, 89, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.78"}],
    Cell[24331, 842, 316, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.79", "NDSolve"}],
    Cell[24650, 850, 175, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.80"}],
    Cell[24828, 856, 182, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.81"}],
    Cell[25013, 862, 326, 10, 70, "Notes",
      CellTags->{"SA.9.4", "4.82"}],
    Cell[25342, 874, 235, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.83"}],
    Cell[25580, 883, 184, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.84"}],
    Cell[25801, 893, 102, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.85"}],
    Cell[25906, 896, 168, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.86", "NSolve"}],
    Cell[26077, 902, 320, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.87"}],
    Cell[26400, 912, 304, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.88"}],
    Cell[26707, 921, 204, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.89", "FindRoot"}],
    Cell[26914, 928, 444, 11, 70, "Notes",
      CellTags->{"SA.9.4", "4.90", "FindMaximum", "FindMinimum"}],
    Cell[27361, 941, 283, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.91"}],
    Cell[27647, 951, 307, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.92", "LinearProgramming"}],
    Cell[27957, 960, 431, 10, 70, "Notes",
      CellTags->{"SA.9.4", "4.93", "NMinimize", "NMaximize"}],
    Cell[28425, 975, 74, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.94"}],
    Cell[28502, 978, 662, 21, 70, "Notes",
      CellTags->{"SA.9.4", "4.95", "Fourier"}],
    Cell[29167, 1001, 168, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.96"}],
    Cell[29338, 1008, 328, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.97", "ListConvolve", "ListCorrelate"}],
    Cell[29669, 1018, 248, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.98", "InterpolatingFunction"}],
    Cell[29920, 1026, 435, 11, 70, "Notes",
      CellTags->{"SA.9.4", "4.99", "Fit", "FindFit"}],
    Cell[30358, 1039, 517, 10, 70, "Notes",
      CellTags->{"SA.9.4", "4.100", "CellularAutomaton"}],
    Cell[30912, 1054, 94, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.101"}],
    Cell[31009, 1057, 195, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.102"}],
    Cell[31207, 1064, 369, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.103", "SparseArray"}],
    Cell[31579, 1073, 177, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.104"}],
    Cell[31759, 1079, 155, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.105"}],
    Cell[31917, 1085, 510, 16, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.106", "LinearSolve", "LUDecomposition", "Inverse", 
        "RowReduce", "Det"}],
    Cell[32430, 1103, 577, 13, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.107", "LinearSolve", "Eigenvalues", "Eigenvectors"}],
    Cell[33012, 1119, 485, 14, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.108", "SingularValueDecomposition", "MatrixRank", 
        "NullSpace"}],
    Cell[33502, 1136, 184, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.109", "QRDecomposition"}],
    Cell[33689, 1143, 175, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.110", "SchurDecomposition"}],
    Cell[33867, 1150, 278, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.111", "MatrixExp"}],
    Cell[34182, 1161, 88, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.112"}],
    Cell[34273, 1164, 255, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.113", "Inverse", "LinearSolve"}],
    Cell[34531, 1173, 192, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.114"}],
    Cell[34726, 1181, 227, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.115", "Det"}],
    Cell[34956, 1189, 181, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.116"}],
    Cell[35140, 1196, 172, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.117"}]},
  "4.1"->{
    Cell[7045, 225, 90, 1, 70, "Subsection",
      CellTags->{"SA.9.4", "4.1"}]},
  "4.2"->{
    Cell[7160, 230, 102, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.2"}]},
  "4.3"->{
    Cell[7265, 233, 387, 10, 70, "Notes",
      CellTags->{"SA.9.4", "4.3"}]},
  "4.4"->{
    Cell[7655, 245, 150, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.4"}]},
  "4.5"->{
    Cell[7808, 251, 358, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.5", "IntegerDigits", "RealDigits"}]},
  "IntegerDigits"->{
    Cell[7808, 251, 358, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.5", "IntegerDigits", "RealDigits"}]},
  "RealDigits"->{
    Cell[7808, 251, 358, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.5", "IntegerDigits", "RealDigits"}]},
  "4.6"->{
    Cell[8169, 262, 253, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.6", "N"}]},
  "N"->{
    Cell[8169, 262, 253, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.6", "N"}]},
  "4.7"->{
    Cell[8425, 270, 310, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.7", "Floor", "Ceiling"}]},
  "Floor"->{
    Cell[8425, 270, 310, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.7", "Floor", "Ceiling"}]},
  "Ceiling"->{
    Cell[8425, 270, 310, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.7", "Floor", "Ceiling"}]},
  "4.8"->{
    Cell[8772, 284, 72, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.8"}]},
  "4.9"->{
    Cell[8847, 287, 299, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.9"}]},
  "4.10"->{
    Cell[9149, 295, 167, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.10"}]},
  "4.11"->{
    Cell[9319, 301, 161, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.11"}]},
  "4.12"->{
    Cell[9483, 307, 156, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.12"}]},
  "4.13"->{
    Cell[9642, 313, 124, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.13"}]},
  "4.14"->{
    Cell[9769, 319, 185, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.14"}]},
  "4.15"->{
    Cell[9991, 329, 77, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.15"}]},
  "4.16"->{
    Cell[10071, 332, 199, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.16", "Random"}]},
  "Random"->{
    Cell[10071, 332, 199, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.16", "Random"}]},
  "4.17"->{
    Cell[10273, 339, 179, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.17"}]},
  "4.18"->{
    Cell[10489, 348, 93, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.18"}]},
  "4.19"->{
    Cell[10585, 351, 327, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.19"}]},
  "4.20"->{
    Cell[10915, 361, 290, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.20", "PrimeQ"}]},
  "PrimeQ"->{
    Cell[10915, 361, 290, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.20", "PrimeQ"}]},
  "4.21"->{
    Cell[11208, 370, 501, 15, 70, "Notes",
      CellTags->{"SA.9.4", "4.21"}]},
  "4.22"->{
    Cell[11712, 387, 385, 10, 70, "Notes",
      CellTags->{"SA.9.4", "4.22"}]},
  "4.23"->{
    Cell[12100, 399, 378, 11, 70, "Notes",
      CellTags->{"SA.9.4", "4.23", "FactorInteger"}]},
  "FactorInteger"->{
    Cell[12100, 399, 378, 11, 70, "Notes",
      CellTags->{"SA.9.4", "4.23", "FactorInteger"}]},
  "4.24"->{
    Cell[12481, 412, 245, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.24"}]},
  "4.25"->{
    Cell[12729, 420, 557, 17, 70, "Notes",
      CellTags->{"SA.9.4", "4.25", "Prime", "PrimePi"}]},
  "Prime"->{
    Cell[12729, 420, 557, 17, 70, "Notes",
      CellTags->{"SA.9.4", "4.25", "Prime", "PrimePi"}]},
  "PrimePi"->{
    Cell[12729, 420, 557, 17, 70, "Notes",
      CellTags->{"SA.9.4", "4.25", "Prime", "PrimePi"}]},
  "4.26"->{
    Cell[13289, 439, 224, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.26", "LatticeReduce"}]},
  "LatticeReduce"->{
    Cell[13289, 439, 224, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.26", "LatticeReduce"}]},
  "4.27"->{
    Cell[13516, 447, 354, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.27"}]},
  "4.28"->{
    Cell[13873, 456, 245, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.28", "ContinuedFraction"}]},
  "ContinuedFraction"->{
    Cell[13873, 456, 245, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.28", "ContinuedFraction"}]},
  "4.29"->{
    Cell[14121, 464, 258, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.29", "FromContinuedFraction"}]},
  "FromContinuedFraction"->{
    Cell[14121, 464, 258, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.29", "FromContinuedFraction"}]},
  "4.30"->{
    Cell[14416, 475, 80, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.30"}]},
  "4.31"->{
    Cell[14499, 478, 143, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.31"}]},
  "4.32"->{
    Cell[14645, 484, 310, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.32", "Factorial", "Binomial"}]},
  "Factorial"->{
    Cell[14645, 484, 310, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.32", "Factorial", "Binomial"}]},
  "Binomial"->{
    Cell[14645, 484, 310, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.32", "Factorial", "Binomial"}]},
  "4.33"->{
    Cell[14958, 494, 278, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.33", "Fibonacci"}]},
  "Fibonacci"->{
    Cell[14958, 494, 278, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.33", "Fibonacci"}]},
  "4.34"->{
    Cell[15239, 505, 385, 12, 70, "Notes",
      CellTags->{"SA.9.4", "4.34", "PartitionsP"}]},
  "PartitionsP"->{
    Cell[15239, 505, 385, 12, 70, "Notes",
      CellTags->{"SA.9.4", "4.34", "PartitionsP"}]},
  "4.35"->{
    Cell[15627, 519, 206, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.35", "ClebschGordan"}]},
  "ClebschGordan"->{
    Cell[15627, 519, 206, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.35", "ClebschGordan"}]},
  "4.36"->{
    Cell[15870, 529, 92, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.36"}]},
  "4.37"->{
    Cell[15965, 532, 206, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.37"}]},
  "4.38"->{
    Cell[16174, 539, 165, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.38"}]},
  "4.39"->{
    Cell[16376, 548, 79, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.39"}]},
  "4.40"->{
    Cell[16458, 551, 126, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.40"}]},
  "4.41"->{
    Cell[16587, 557, 145, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.41"}]},
  "4.42"->{
    Cell[16735, 563, 165, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.42", "Pi"}]},
  "Pi"->{
    Cell[16735, 563, 165, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.42", "Pi"}]},
  "4.43"->{
    Cell[16903, 570, 160, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.43", "E"}]},
  "E"->{
    Cell[16903, 570, 160, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.43", "E"}]},
  "4.44"->{
    Cell[17066, 577, 182, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.44", "EulerGamma"}]},
  "EulerGamma"->{
    Cell[17066, 577, 182, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.44", "EulerGamma"}]},
  "4.45"->{
    Cell[17251, 584, 188, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.45", "Catalan"}]},
  "Catalan"->{
    Cell[17251, 584, 188, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.45", "Catalan"}]},
  "4.46"->{
    Cell[17476, 594, 74, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.46"}]},
  "4.47"->{
    Cell[17553, 597, 285, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.47"}]},
  "4.48"->{
    Cell[17841, 605, 197, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.48"}]},
  "4.49"->{
    Cell[18041, 612, 200, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.49", "Gamma"}]},
  "Gamma"->{
    Cell[18041, 612, 200, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.49", "Gamma"}]},
  "4.50"->{
    Cell[18244, 619, 167, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.50"}]},
  "4.51"->{
    Cell[18414, 625, 215, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.51", "PolyGamma"}]},
  "PolyGamma"->{
    Cell[18414, 625, 215, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.51", "PolyGamma"}]},
  "4.52"->{
    Cell[18632, 633, 251, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.52", "PolyLog"}]},
  "PolyLog"->{
    Cell[18632, 633, 251, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.52", "PolyLog"}]},
  "4.53"->{
    Cell[18886, 641, 291, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.53", "Zeta"}]},
  "Zeta"->{
    Cell[18886, 641, 291, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.53", "Zeta"}]},
  "4.54"->{
    Cell[19180, 650, 255, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.54", "StieltjesGamma"}]},
  "StieltjesGamma"->{
    Cell[19180, 650, 255, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.54", "StieltjesGamma"}]},
  "4.55"->{
    Cell[19438, 658, 200, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.55"}]},
  "4.56"->{
    Cell[19641, 665, 182, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.56"}]},
  "4.57"->{
    Cell[19826, 671, 197, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.57"}]},
  "4.58"->{
    Cell[20026, 678, 329, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.58"}]},
  "4.59"->{
    Cell[20358, 689, 232, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.59"}]},
  "4.60"->{
    Cell[20593, 697, 157, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.60"}]},
  "4.61"->{
    Cell[20753, 703, 169, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.61"}]},
  "4.62"->{
    Cell[20925, 709, 159, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.62"}]},
  "4.63"->{
    Cell[21087, 715, 205, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.63"}]},
  "4.64"->{
    Cell[21329, 725, 78, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.64"}]},
  "4.65"->{
    Cell[21410, 728, 302, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.65", "NIntegrate"}]},
  "NIntegrate"->{
    Cell[21410, 728, 302, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.65", "NIntegrate"}]},
  "4.66"->{
    Cell[21715, 737, 301, 11, 70, "Notes",
      CellTags->{"SA.9.4", "4.66"}]},
  "4.67"->{
    Cell[22019, 750, 269, 9, 70, "Notes",
      CellTags->{"SA.9.4", "4.67"}]},
  "4.68"->{
    Cell[22291, 761, 220, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.68"}]},
  "4.69"->{
    Cell[22514, 769, 193, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.69"}]},
  "4.70"->{
    Cell[22710, 776, 158, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.70"}]},
  "4.71"->{
    Cell[22871, 783, 219, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.71"}]},
  "4.72"->{
    Cell[23093, 791, 171, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.72"}]},
  "4.73"->{
    Cell[23267, 798, 160, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.73"}]},
  "4.74"->{
    Cell[23430, 805, 212, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.74"}]},
  "4.75"->{
    Cell[23679, 816, 84, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.75"}]},
  "4.76"->{
    Cell[23766, 819, 206, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.76", "NSum"}]},
  "NSum"->{
    Cell[23766, 819, 206, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.76", "NSum"}]},
  "4.77"->{
    Cell[23975, 826, 227, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.77"}]},
  "4.78"->{
    Cell[24239, 839, 89, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.78"}]},
  "4.79"->{
    Cell[24331, 842, 316, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.79", "NDSolve"}]},
  "NDSolve"->{
    Cell[24331, 842, 316, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.79", "NDSolve"}]},
  "4.80"->{
    Cell[24650, 850, 175, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.80"}]},
  "4.81"->{
    Cell[24828, 856, 182, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.81"}]},
  "4.82"->{
    Cell[25013, 862, 326, 10, 70, "Notes",
      CellTags->{"SA.9.4", "4.82"}]},
  "4.83"->{
    Cell[25342, 874, 235, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.83"}]},
  "4.84"->{
    Cell[25580, 883, 184, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.84"}]},
  "4.85"->{
    Cell[25801, 893, 102, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.85"}]},
  "4.86"->{
    Cell[25906, 896, 168, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.86", "NSolve"}]},
  "NSolve"->{
    Cell[25906, 896, 168, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.86", "NSolve"}]},
  "4.87"->{
    Cell[26077, 902, 320, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.87"}]},
  "4.88"->{
    Cell[26400, 912, 304, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.88"}]},
  "4.89"->{
    Cell[26707, 921, 204, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.89", "FindRoot"}]},
  "FindRoot"->{
    Cell[26707, 921, 204, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.89", "FindRoot"}]},
  "4.90"->{
    Cell[26914, 928, 444, 11, 70, "Notes",
      CellTags->{"SA.9.4", "4.90", "FindMaximum", "FindMinimum"}]},
  "FindMaximum"->{
    Cell[26914, 928, 444, 11, 70, "Notes",
      CellTags->{"SA.9.4", "4.90", "FindMaximum", "FindMinimum"}]},
  "FindMinimum"->{
    Cell[26914, 928, 444, 11, 70, "Notes",
      CellTags->{"SA.9.4", "4.90", "FindMaximum", "FindMinimum"}]},
  "4.91"->{
    Cell[27361, 941, 283, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.91"}]},
  "4.92"->{
    Cell[27647, 951, 307, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.92", "LinearProgramming"}]},
  "LinearProgramming"->{
    Cell[27647, 951, 307, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.92", "LinearProgramming"}]},
  "4.93"->{
    Cell[27957, 960, 431, 10, 70, "Notes",
      CellTags->{"SA.9.4", "4.93", "NMinimize", "NMaximize"}]},
  "NMinimize"->{
    Cell[27957, 960, 431, 10, 70, "Notes",
      CellTags->{"SA.9.4", "4.93", "NMinimize", "NMaximize"}]},
  "NMaximize"->{
    Cell[27957, 960, 431, 10, 70, "Notes",
      CellTags->{"SA.9.4", "4.93", "NMinimize", "NMaximize"}]},
  "4.94"->{
    Cell[28425, 975, 74, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.94"}]},
  "4.95"->{
    Cell[28502, 978, 662, 21, 70, "Notes",
      CellTags->{"SA.9.4", "4.95", "Fourier"}]},
  "Fourier"->{
    Cell[28502, 978, 662, 21, 70, "Notes",
      CellTags->{"SA.9.4", "4.95", "Fourier"}]},
  "4.96"->{
    Cell[29167, 1001, 168, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.96"}]},
  "4.97"->{
    Cell[29338, 1008, 328, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.97", "ListConvolve", "ListCorrelate"}]},
  "ListConvolve"->{
    Cell[29338, 1008, 328, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.97", "ListConvolve", "ListCorrelate"}]},
  "ListCorrelate"->{
    Cell[29338, 1008, 328, 8, 70, "Notes",
      CellTags->{"SA.9.4", "4.97", "ListConvolve", "ListCorrelate"}]},
  "4.98"->{
    Cell[29669, 1018, 248, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.98", "InterpolatingFunction"}]},
  "InterpolatingFunction"->{
    Cell[29669, 1018, 248, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.98", "InterpolatingFunction"}]},
  "4.99"->{
    Cell[29920, 1026, 435, 11, 70, "Notes",
      CellTags->{"SA.9.4", "4.99", "Fit", "FindFit"}]},
  "Fit"->{
    Cell[29920, 1026, 435, 11, 70, "Notes",
      CellTags->{"SA.9.4", "4.99", "Fit", "FindFit"}]},
  "FindFit"->{
    Cell[29920, 1026, 435, 11, 70, "Notes",
      CellTags->{"SA.9.4", "4.99", "Fit", "FindFit"}]},
  "4.100"->{
    Cell[30358, 1039, 517, 10, 70, "Notes",
      CellTags->{"SA.9.4", "4.100", "CellularAutomaton"}]},
  "CellularAutomaton"->{
    Cell[30358, 1039, 517, 10, 70, "Notes",
      CellTags->{"SA.9.4", "4.100", "CellularAutomaton"}]},
  "4.101"->{
    Cell[30912, 1054, 94, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.101"}]},
  "4.102"->{
    Cell[31009, 1057, 195, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.102"}]},
  "4.103"->{
    Cell[31207, 1064, 369, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.103", "SparseArray"}]},
  "SparseArray"->{
    Cell[31207, 1064, 369, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.103", "SparseArray"}]},
  "4.104"->{
    Cell[31579, 1073, 177, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.104"}]},
  "4.105"->{
    Cell[31759, 1079, 155, 4, 70, "Notes",
      CellTags->{"SA.9.4", "4.105"}]},
  "4.106"->{
    Cell[31917, 1085, 510, 16, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.106", "LinearSolve", "LUDecomposition", "Inverse", 
        "RowReduce", "Det"}]},
  "LinearSolve"->{
    Cell[31917, 1085, 510, 16, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.106", "LinearSolve", "LUDecomposition", "Inverse", 
        "RowReduce", "Det"}],
    Cell[32430, 1103, 577, 13, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.107", "LinearSolve", "Eigenvalues", "Eigenvectors"}],
    Cell[34273, 1164, 255, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.113", "Inverse", "LinearSolve"}]},
  "LUDecomposition"->{
    Cell[31917, 1085, 510, 16, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.106", "LinearSolve", "LUDecomposition", "Inverse", 
        "RowReduce", "Det"}]},
  "Inverse"->{
    Cell[31917, 1085, 510, 16, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.106", "LinearSolve", "LUDecomposition", "Inverse", 
        "RowReduce", "Det"}],
    Cell[34273, 1164, 255, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.113", "Inverse", "LinearSolve"}]},
  "RowReduce"->{
    Cell[31917, 1085, 510, 16, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.106", "LinearSolve", "LUDecomposition", "Inverse", 
        "RowReduce", "Det"}]},
  "Det"->{
    Cell[31917, 1085, 510, 16, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.106", "LinearSolve", "LUDecomposition", "Inverse", 
        "RowReduce", "Det"}],
    Cell[34726, 1181, 227, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.115", "Det"}]},
  "4.107"->{
    Cell[32430, 1103, 577, 13, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.107", "LinearSolve", "Eigenvalues", "Eigenvectors"}]},
  "Eigenvalues"->{
    Cell[32430, 1103, 577, 13, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.107", "LinearSolve", "Eigenvalues", "Eigenvectors"}]},
  "Eigenvectors"->{
    Cell[32430, 1103, 577, 13, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.107", "LinearSolve", "Eigenvalues", "Eigenvectors"}]},
  "4.108"->{
    Cell[33012, 1119, 485, 14, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.108", "SingularValueDecomposition", "MatrixRank", 
        "NullSpace"}]},
  "SingularValueDecomposition"->{
    Cell[33012, 1119, 485, 14, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.108", "SingularValueDecomposition", "MatrixRank", 
        "NullSpace"}]},
  "MatrixRank"->{
    Cell[33012, 1119, 485, 14, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.108", "SingularValueDecomposition", "MatrixRank", 
        "NullSpace"}],
    Cell[37974, 1294, 309, 11, 70, "Notes",
      CellTags->{"SA.9.5", "5.13", "NullSpace", "MatrixRank"}]},
  "NullSpace"->{
    Cell[33012, 1119, 485, 14, 70, "Notes",
      CellTags->{
      "SA.9.4", "4.108", "SingularValueDecomposition", "MatrixRank", 
        "NullSpace"}],
    Cell[37974, 1294, 309, 11, 70, "Notes",
      CellTags->{"SA.9.5", "5.13", "NullSpace", "MatrixRank"}]},
  "4.109"->{
    Cell[33502, 1136, 184, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.109", "QRDecomposition"}]},
  "QRDecomposition"->{
    Cell[33502, 1136, 184, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.109", "QRDecomposition"}]},
  "4.110"->{
    Cell[33689, 1143, 175, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.110", "SchurDecomposition"}]},
  "SchurDecomposition"->{
    Cell[33689, 1143, 175, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.110", "SchurDecomposition"}]},
  "4.111"->{
    Cell[33867, 1150, 278, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.111", "MatrixExp"}]},
  "MatrixExp"->{
    Cell[33867, 1150, 278, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.111", "MatrixExp"}],
    Cell[38739, 1323, 186, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.16", "MatrixExp"}]},
  "4.112"->{
    Cell[34182, 1161, 88, 1, 70, "Subsubsection",
      CellTags->{"SA.9.4", "4.112"}]},
  "4.113"->{
    Cell[34273, 1164, 255, 7, 70, "Notes",
      CellTags->{"SA.9.4", "4.113", "Inverse", "LinearSolve"}]},
  "4.114"->{
    Cell[34531, 1173, 192, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.114"}]},
  "4.115"->{
    Cell[34726, 1181, 227, 6, 70, "Notes",
      CellTags->{"SA.9.4", "4.115", "Det"}]},
  "4.116"->{
    Cell[34956, 1189, 181, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.116"}]},
  "4.117"->{
    Cell[35140, 1196, 172, 5, 70, "Notes",
      CellTags->{"SA.9.4", "4.117"}]},
  "SA.9.5"->{
    Cell[35361, 1207, 79, 1, 70, "Subsection",
      CellTags->{"SA.9.5", "5.1"}],
    Cell[35465, 1212, 79, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.2"}],
    Cell[35547, 1215, 328, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.3", "Factor"}],
    Cell[35878, 1224, 213, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.4"}],
    Cell[36094, 1231, 350, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.5"}],
    Cell[36447, 1240, 212, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.6"}],
    Cell[36662, 1247, 197, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.7"}],
    Cell[36862, 1254, 257, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.8"}],
    Cell[37122, 1262, 217, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.9"}],
    Cell[37342, 1270, 317, 9, 70, "Notes",
      CellTags->{"SA.9.5", "5.10"}],
    Cell[37662, 1281, 192, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.11"}],
    Cell[37891, 1291, 80, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.12"}],
    Cell[37974, 1294, 309, 11, 70, "Notes",
      CellTags->{"SA.9.5", "5.13", "NullSpace", "MatrixRank"}],
    Cell[38286, 1307, 234, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.14"}],
    Cell[38523, 1315, 213, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.15"}],
    Cell[38739, 1323, 186, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.16", "MatrixExp"}],
    Cell[38928, 1330, 278, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.17"}],
    Cell[39243, 1341, 93, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.18"}],
    Cell[39339, 1344, 168, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.19"}],
    Cell[39510, 1350, 490, 12, 70, "Notes",
      CellTags->{"SA.9.5", "5.20"}],
    Cell[40003, 1364, 369, 10, 70, "Notes",
      CellTags->{"SA.9.5", "5.21"}],
    Cell[40375, 1376, 206, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.22", "Solve"}],
    Cell[40584, 1383, 237, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.23", "GroebnerBasis"}],
    Cell[40824, 1392, 223, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.24"}],
    Cell[41050, 1399, 180, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.25"}],
    Cell[41233, 1406, 273, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.26", "Reduce"}],
    Cell[41509, 1414, 565, 13, 70, "Notes",
      CellTags->{"SA.9.5", "5.27"}],
    Cell[42077, 1429, 551, 10, 70, "Notes",
      CellTags->{"SA.9.5", "5.28", "CylindricalDecomposition"}],
    Cell[42631, 1441, 715, 14, 70, "Notes",
      CellTags->{"SA.9.5", "5.29"}],
    Cell[43349, 1457, 354, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.30"}],
    Cell[43706, 1466, 221, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.31", "Resolve"}],
    Cell[43930, 1475, 238, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.32"}],
    Cell[44205, 1487, 75, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.33"}],
    Cell[44283, 1490, 313, 8, 70, "Notes",
      CellTags->{"SA.9.5", "5.34", "Maximize", "Minimize"}],
    Cell[44599, 1500, 195, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.35"}],
    Cell[44831, 1510, 71, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.36"}],
    Cell[44905, 1513, 325, 7, 70, "Notes",
      CellTags->{
      "SA.9.5", "5.37", "FunctionExpand", "FullSimplify", "Simplify"}],
    Cell[45235, 1523, 332, 9, 70, "Notes",
      CellTags->{"SA.9.5", "5.38"}],
    Cell[45570, 1534, 327, 9, 70, "Notes",
      CellTags->{"SA.9.5", "5.39"}],
    Cell[45900, 1545, 200, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.40"}],
    Cell[46103, 1554, 416, 8, 70, "Notes",
      CellTags->{"SA.9.5", "5.41"}],
    Cell[46522, 1564, 178, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.42"}],
    Cell[46703, 1570, 358, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.43"}],
    Cell[47064, 1579, 224, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.44"}],
    Cell[47291, 1587, 208, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.45", "Piecewise", "PiecewiseExpand"}],
    Cell[47536, 1596, 88, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.46"}],
    Cell[47627, 1599, 152, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.47", "D"}],
    Cell[47782, 1605, 342, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.48", "Integrate"}],
    Cell[48127, 1613, 175, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.49"}],
    Cell[48305, 1619, 247, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.50"}],
    Cell[48555, 1627, 193, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.51"}],
    Cell[48751, 1634, 351, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.52"}],
    Cell[49105, 1643, 233, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.53"}],
    Cell[49341, 1650, 219, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.54"}],
    Cell[49597, 1662, 79, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.55"}],
    Cell[49679, 1665, 185, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.56", "DSolve"}],
    Cell[49867, 1671, 275, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.57"}],
    Cell[50145, 1679, 169, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.58"}],
    Cell[50317, 1685, 303, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.59"}],
    Cell[50623, 1693, 266, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.60"}],
    Cell[50892, 1701, 422, 8, 70, "Notes",
      CellTags->{"SA.9.5", "5.61"}],
    Cell[51317, 1711, 193, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.62"}],
    Cell[51513, 1718, 245, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.63"}],
    Cell[51761, 1726, 198, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.64"}],
    Cell[51962, 1733, 218, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.65"}],
    Cell[52183, 1740, 212, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.66"}],
    Cell[52398, 1747, 216, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.67"}],
    Cell[52651, 1759, 74, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.68"}],
    Cell[52728, 1762, 166, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.69", "Sum", "Product"}],
    Cell[52897, 1768, 246, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.70"}],
    Cell[53146, 1775, 160, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.71"}],
    Cell[53309, 1781, 144, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.72"}],
    Cell[53456, 1787, 150, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.73"}],
    Cell[53609, 1793, 240, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.74"}],
    Cell[53852, 1801, 132, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.75"}],
    Cell[53987, 1807, 228, 9, 70, "Notes",
      CellTags->{"SA.9.5", "5.76"}],
    Cell[54252, 1821, 74, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.77"}],
    Cell[54329, 1824, 238, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.78", "Series"}],
    Cell[54570, 1832, 135, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.79"}],
    Cell[54742, 1841, 77, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.80"}],
    Cell[54822, 1844, 216, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.81", "RSolve"}],
    Cell[55041, 1852, 221, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.82"}],
    Cell[55265, 1859, 266, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.83"}],
    Cell[55534, 1867, 241, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.84"}],
    Cell[55778, 1874, 367, 11, 70, "Notes",
      CellTags->{"SA.9.5", "5.85"}],
    Cell[56148, 1887, 212, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.86"}]},
  "5.1"->{
    Cell[35361, 1207, 79, 1, 70, "Subsection",
      CellTags->{"SA.9.5", "5.1"}]},
  "5.2"->{
    Cell[35465, 1212, 79, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.2"}]},
  "5.3"->{
    Cell[35547, 1215, 328, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.3", "Factor"}]},
  "Factor"->{
    Cell[35547, 1215, 328, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.3", "Factor"}]},
  "5.4"->{
    Cell[35878, 1224, 213, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.4"}]},
  "5.5"->{
    Cell[36094, 1231, 350, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.5"}]},
  "5.6"->{
    Cell[36447, 1240, 212, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.6"}]},
  "5.7"->{
    Cell[36662, 1247, 197, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.7"}]},
  "5.8"->{
    Cell[36862, 1254, 257, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.8"}]},
  "5.9"->{
    Cell[37122, 1262, 217, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.9"}]},
  "5.10"->{
    Cell[37342, 1270, 317, 9, 70, "Notes",
      CellTags->{"SA.9.5", "5.10"}]},
  "5.11"->{
    Cell[37662, 1281, 192, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.11"}]},
  "5.12"->{
    Cell[37891, 1291, 80, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.12"}]},
  "5.13"->{
    Cell[37974, 1294, 309, 11, 70, "Notes",
      CellTags->{"SA.9.5", "5.13", "NullSpace", "MatrixRank"}]},
  "5.14"->{
    Cell[38286, 1307, 234, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.14"}]},
  "5.15"->{
    Cell[38523, 1315, 213, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.15"}]},
  "5.16"->{
    Cell[38739, 1323, 186, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.16", "MatrixExp"}]},
  "5.17"->{
    Cell[38928, 1330, 278, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.17"}]},
  "5.18"->{
    Cell[39243, 1341, 93, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.18"}]},
  "5.19"->{
    Cell[39339, 1344, 168, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.19"}]},
  "5.20"->{
    Cell[39510, 1350, 490, 12, 70, "Notes",
      CellTags->{"SA.9.5", "5.20"}]},
  "5.21"->{
    Cell[40003, 1364, 369, 10, 70, "Notes",
      CellTags->{"SA.9.5", "5.21"}]},
  "5.22"->{
    Cell[40375, 1376, 206, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.22", "Solve"}]},
  "Solve"->{
    Cell[40375, 1376, 206, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.22", "Solve"}]},
  "5.23"->{
    Cell[40584, 1383, 237, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.23", "GroebnerBasis"}]},
  "GroebnerBasis"->{
    Cell[40584, 1383, 237, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.23", "GroebnerBasis"}]},
  "5.24"->{
    Cell[40824, 1392, 223, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.24"}]},
  "5.25"->{
    Cell[41050, 1399, 180, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.25"}]},
  "5.26"->{
    Cell[41233, 1406, 273, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.26", "Reduce"}]},
  "Reduce"->{
    Cell[41233, 1406, 273, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.26", "Reduce"}]},
  "5.27"->{
    Cell[41509, 1414, 565, 13, 70, "Notes",
      CellTags->{"SA.9.5", "5.27"}]},
  "5.28"->{
    Cell[42077, 1429, 551, 10, 70, "Notes",
      CellTags->{"SA.9.5", "5.28", "CylindricalDecomposition"}]},
  "CylindricalDecomposition"->{
    Cell[42077, 1429, 551, 10, 70, "Notes",
      CellTags->{"SA.9.5", "5.28", "CylindricalDecomposition"}]},
  "5.29"->{
    Cell[42631, 1441, 715, 14, 70, "Notes",
      CellTags->{"SA.9.5", "5.29"}]},
  "5.30"->{
    Cell[43349, 1457, 354, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.30"}]},
  "5.31"->{
    Cell[43706, 1466, 221, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.31", "Resolve"}]},
  "Resolve"->{
    Cell[43706, 1466, 221, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.31", "Resolve"}]},
  "5.32"->{
    Cell[43930, 1475, 238, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.32"}]},
  "5.33"->{
    Cell[44205, 1487, 75, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.33"}]},
  "5.34"->{
    Cell[44283, 1490, 313, 8, 70, "Notes",
      CellTags->{"SA.9.5", "5.34", "Maximize", "Minimize"}]},
  "Maximize"->{
    Cell[44283, 1490, 313, 8, 70, "Notes",
      CellTags->{"SA.9.5", "5.34", "Maximize", "Minimize"}]},
  "Minimize"->{
    Cell[44283, 1490, 313, 8, 70, "Notes",
      CellTags->{"SA.9.5", "5.34", "Maximize", "Minimize"}]},
  "5.35"->{
    Cell[44599, 1500, 195, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.35"}]},
  "5.36"->{
    Cell[44831, 1510, 71, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.36"}]},
  "5.37"->{
    Cell[44905, 1513, 325, 7, 70, "Notes",
      CellTags->{
      "SA.9.5", "5.37", "FunctionExpand", "FullSimplify", "Simplify"}]},
  "FunctionExpand"->{
    Cell[44905, 1513, 325, 7, 70, "Notes",
      CellTags->{
      "SA.9.5", "5.37", "FunctionExpand", "FullSimplify", "Simplify"}]},
  "FullSimplify"->{
    Cell[44905, 1513, 325, 7, 70, "Notes",
      CellTags->{
      "SA.9.5", "5.37", "FunctionExpand", "FullSimplify", "Simplify"}]},
  "Simplify"->{
    Cell[44905, 1513, 325, 7, 70, "Notes",
      CellTags->{
      "SA.9.5", "5.37", "FunctionExpand", "FullSimplify", "Simplify"}]},
  "5.38"->{
    Cell[45235, 1523, 332, 9, 70, "Notes",
      CellTags->{"SA.9.5", "5.38"}]},
  "5.39"->{
    Cell[45570, 1534, 327, 9, 70, "Notes",
      CellTags->{"SA.9.5", "5.39"}]},
  "5.40"->{
    Cell[45900, 1545, 200, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.40"}]},
  "5.41"->{
    Cell[46103, 1554, 416, 8, 70, "Notes",
      CellTags->{"SA.9.5", "5.41"}]},
  "5.42"->{
    Cell[46522, 1564, 178, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.42"}]},
  "5.43"->{
    Cell[46703, 1570, 358, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.43"}]},
  "5.44"->{
    Cell[47064, 1579, 224, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.44"}]},
  "5.45"->{
    Cell[47291, 1587, 208, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.45", "Piecewise", "PiecewiseExpand"}]},
  "Piecewise"->{
    Cell[47291, 1587, 208, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.45", "Piecewise", "PiecewiseExpand"}]},
  "PiecewiseExpand"->{
    Cell[47291, 1587, 208, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.45", "Piecewise", "PiecewiseExpand"}]},
  "5.46"->{
    Cell[47536, 1596, 88, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.46"}]},
  "5.47"->{
    Cell[47627, 1599, 152, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.47", "D"}]},
  "D"->{
    Cell[47627, 1599, 152, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.47", "D"}]},
  "5.48"->{
    Cell[47782, 1605, 342, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.48", "Integrate"}]},
  "Integrate"->{
    Cell[47782, 1605, 342, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.48", "Integrate"}]},
  "5.49"->{
    Cell[48127, 1613, 175, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.49"}]},
  "5.50"->{
    Cell[48305, 1619, 247, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.50"}]},
  "5.51"->{
    Cell[48555, 1627, 193, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.51"}]},
  "5.52"->{
    Cell[48751, 1634, 351, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.52"}]},
  "5.53"->{
    Cell[49105, 1643, 233, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.53"}]},
  "5.54"->{
    Cell[49341, 1650, 219, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.54"}]},
  "5.55"->{
    Cell[49597, 1662, 79, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.55"}]},
  "5.56"->{
    Cell[49679, 1665, 185, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.56", "DSolve"}]},
  "DSolve"->{
    Cell[49679, 1665, 185, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.56", "DSolve"}]},
  "5.57"->{
    Cell[49867, 1671, 275, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.57"}]},
  "5.58"->{
    Cell[50145, 1679, 169, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.58"}]},
  "5.59"->{
    Cell[50317, 1685, 303, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.59"}]},
  "5.60"->{
    Cell[50623, 1693, 266, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.60"}]},
  "5.61"->{
    Cell[50892, 1701, 422, 8, 70, "Notes",
      CellTags->{"SA.9.5", "5.61"}]},
  "5.62"->{
    Cell[51317, 1711, 193, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.62"}]},
  "5.63"->{
    Cell[51513, 1718, 245, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.63"}]},
  "5.64"->{
    Cell[51761, 1726, 198, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.64"}]},
  "5.65"->{
    Cell[51962, 1733, 218, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.65"}]},
  "5.66"->{
    Cell[52183, 1740, 212, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.66"}]},
  "5.67"->{
    Cell[52398, 1747, 216, 7, 70, "Notes",
      CellTags->{"SA.9.5", "5.67"}]},
  "5.68"->{
    Cell[52651, 1759, 74, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.68"}]},
  "5.69"->{
    Cell[52728, 1762, 166, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.69", "Sum", "Product"}]},
  "Sum"->{
    Cell[52728, 1762, 166, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.69", "Sum", "Product"}]},
  "Product"->{
    Cell[52728, 1762, 166, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.69", "Sum", "Product"}]},
  "5.70"->{
    Cell[52897, 1768, 246, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.70"}]},
  "5.71"->{
    Cell[53146, 1775, 160, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.71"}]},
  "5.72"->{
    Cell[53309, 1781, 144, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.72"}]},
  "5.73"->{
    Cell[53456, 1787, 150, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.73"}]},
  "5.74"->{
    Cell[53609, 1793, 240, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.74"}]},
  "5.75"->{
    Cell[53852, 1801, 132, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.75"}]},
  "5.76"->{
    Cell[53987, 1807, 228, 9, 70, "Notes",
      CellTags->{"SA.9.5", "5.76"}]},
  "5.77"->{
    Cell[54252, 1821, 74, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.77"}]},
  "5.78"->{
    Cell[54329, 1824, 238, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.78", "Series"}]},
  "Series"->{
    Cell[54329, 1824, 238, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.78", "Series"}]},
  "5.79"->{
    Cell[54570, 1832, 135, 4, 70, "Notes",
      CellTags->{"SA.9.5", "5.79"}]},
  "5.80"->{
    Cell[54742, 1841, 77, 1, 70, "Subsubsection",
      CellTags->{"SA.9.5", "5.80"}]},
  "5.81"->{
    Cell[54822, 1844, 216, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.81", "RSolve"}]},
  "RSolve"->{
    Cell[54822, 1844, 216, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.81", "RSolve"}]},
  "5.82"->{
    Cell[55041, 1852, 221, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.82"}]},
  "5.83"->{
    Cell[55265, 1859, 266, 6, 70, "Notes",
      CellTags->{"SA.9.5", "5.83"}]},
  "5.84"->{
    Cell[55534, 1867, 241, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.84"}]},
  "5.85"->{
    Cell[55778, 1874, 367, 11, 70, "Notes",
      CellTags->{"SA.9.5", "5.85"}]},
  "5.86"->{
    Cell[56148, 1887, 212, 5, 70, "Notes",
      CellTags->{"SA.9.5", "5.86"}]},
  "SA.9.6"->{
    Cell[56409, 1898, 81, 1, 70, "Subsection",
      CellTags->{"SA.9.6", "6.1"}],
    Cell[56515, 1903, 64, 1, 70, "Subsubsection",
      CellTags->{"SA.9.6", "6.2"}],
    Cell[56582, 1906, 198, 5, 70, "Notes",
      CellTags->{"SA.9.6", "6.3", "Plot3D"}],
    Cell[56783, 1913, 172, 4, 70, "Notes",
      CellTags->{"SA.9.6", "6.4"}],
    Cell[56958, 1919, 153, 4, 70, "Notes",
      CellTags->{"SA.9.6", "6.5"}],
    Cell[57148, 1928, 65, 1, 70, "Subsubsection",
      CellTags->{"SA.9.6", "6.6"}],
    Cell[57216, 1931, 248, 6, 70, "Notes",
      CellTags->{"SA.9.6", "6.7"}],
    Cell[57467, 1939, 212, 6, 70, "Notes",
      CellTags->{"SA.9.6", "6.8"}],
    Cell[57682, 1947, 181, 5, 70, "Notes",
      CellTags->{"SA.9.6", "6.9"}],
    Cell[57866, 1954, 216, 5, 70, "Notes",
      CellTags->{"SA.9.6", "6.10"}],
    Cell[58119, 1964, 66, 1, 70, "Subsubsection",
      CellTags->{"SA.9.6", "6.11"}],
    Cell[58188, 1967, 168, 5, 70, "Notes",
      CellTags->{"SA.9.6", "6.12"}],
    Cell[58359, 1974, 271, 6, 70, "Notes",
      CellTags->{"SA.9.6", "6.13"}],
    Cell[58633, 1982, 210, 5, 70, "Notes",
      CellTags->{"SA.9.6", "6.14"}],
    Cell[58846, 1989, 209, 5, 40, "Notes",
      CellTags->{"SA.9.6", "6.15"}],
    Cell[59058, 1996, 185, 5, 70, "Notes",
      CellTags->{"SA.9.6", "6.16"}],
    Cell[59246, 2003, 229, 5, 40, "Notes",
      CellTags->{"SA.9.6", "6.17"}],
    Cell[59478, 2010, 402, 8, 72, "Notes",
      CellTags->{"SA.9.6", "6.18"}],
    Cell[59917, 2023, 92, 1, 34, "Subsubsection",
      CellTags->{"SA.9.6", "6.19"}],
    Cell[60012, 2026, 287, 6, 40, "Notes",
      CellTags->{"SA.9.6", "6.20"}],
    Cell[60302, 2034, 241, 6, 40, "Notes",
      CellTags->{"SA.9.6", "6.21"}],
    Cell[60546, 2042, 254, 8, 40, "Notes",
      CellTags->{"SA.9.6", "6.22"}],
    Cell[60803, 2052, 196, 5, 24, "Notes",
      CellTags->{"SA.9.6", "6.23"}],
    Cell[61036, 2062, 78, 1, 34, "Subsubsection",
      CellTags->{"SA.9.6", "6.24"}],
    Cell[61117, 2065, 181, 4, 40, "Notes",
      CellTags->{"SA.9.6", "6.25"}],
    Cell[61301, 2071, 185, 5, 40, "Notes",
      CellTags->{"SA.9.6", "6.26"}],
    Cell[61489, 2078, 152, 4, 24, "Notes",
      CellTags->{"SA.9.6", "6.27"}],
    Cell[61644, 2084, 165, 4, 24, "Notes",
      CellTags->{"SA.9.6", "6.28"}],
    Cell[61812, 2090, 208, 5, 40, "Notes",
      CellTags->{"SA.9.6", "6.29"}],
    Cell[62023, 2097, 301, 6, 56, "Notes",
      CellTags->{"SA.9.6", "6.30"}],
    Cell[62327, 2105, 136, 4, 24, "Notes",
      CellTags->{"SA.9.6", "6.31"}]},
  "6.1"->{
    Cell[56409, 1898, 81, 1, 70, "Subsection",
      CellTags->{"SA.9.6", "6.1"}]},
  "6.2"->{
    Cell[56515, 1903, 64, 1, 70, "Subsubsection",
      CellTags->{"SA.9.6", "6.2"}]},
  "6.3"->{
    Cell[56582, 1906, 198, 5, 70, "Notes",
      CellTags->{"SA.9.6", "6.3", "Plot3D"}]},
  "Plot3D"->{
    Cell[56582, 1906, 198, 5, 70, "Notes",
      CellTags->{"SA.9.6", "6.3", "Plot3D"}]},
  "6.4"->{
    Cell[56783, 1913, 172, 4, 70, "Notes",
      CellTags->{"SA.9.6", "6.4"}]},
  "6.5"->{
    Cell[56958, 1919, 153, 4, 70, "Notes",
      CellTags->{"SA.9.6", "6.5"}]},
  "6.6"->{
    Cell[57148, 1928, 65, 1, 70, "Subsubsection",
      CellTags->{"SA.9.6", "6.6"}]},
  "6.7"->{
    Cell[57216, 1931, 248, 6, 70, "Notes",
      CellTags->{"SA.9.6", "6.7"}]},
  "6.8"->{
    Cell[57467, 1939, 212, 6, 70, "Notes",
      CellTags->{"SA.9.6", "6.8"}]},
  "6.9"->{
    Cell[57682, 1947, 181, 5, 70, "Notes",
      CellTags->{"SA.9.6", "6.9"}]},
  "6.10"->{
    Cell[57866, 1954, 216, 5, 70, "Notes",
      CellTags->{"SA.9.6", "6.10"}]},
  "6.11"->{
    Cell[58119, 1964, 66, 1, 70, "Subsubsection",
      CellTags->{"SA.9.6", "6.11"}]},
  "6.12"->{
    Cell[58188, 1967, 168, 5, 70, "Notes",
      CellTags->{"SA.9.6", "6.12"}]},
  "6.13"->{
    Cell[58359, 1974, 271, 6, 70, "Notes",
      CellTags->{"SA.9.6", "6.13"}]},
  "6.14"->{
    Cell[58633, 1982, 210, 5, 70, "Notes",
      CellTags->{"SA.9.6", "6.14"}]},
  "6.15"->{
    Cell[58846, 1989, 209, 5, 40, "Notes",
      CellTags->{"SA.9.6", "6.15"}]},
  "6.16"->{
    Cell[59058, 1996, 185, 5, 70, "Notes",
      CellTags->{"SA.9.6", "6.16"}]},
  "6.17"->{
    Cell[59246, 2003, 229, 5, 40, "Notes",
      CellTags->{"SA.9.6", "6.17"}]},
  "6.18"->{
    Cell[59478, 2010, 402, 8, 72, "Notes",
      CellTags->{"SA.9.6", "6.18"}]},
  "6.19"->{
    Cell[59917, 2023, 92, 1, 34, "Subsubsection",
      CellTags->{"SA.9.6", "6.19"}]},
  "6.20"->{
    Cell[60012, 2026, 287, 6, 40, "Notes",
      CellTags->{"SA.9.6", "6.20"}]},
  "6.21"->{
    Cell[60302, 2034, 241, 6, 40, "Notes",
      CellTags->{"SA.9.6", "6.21"}]},
  "6.22"->{
    Cell[60546, 2042, 254, 8, 40, "Notes",
      CellTags->{"SA.9.6", "6.22"}]},
  "6.23"->{
    Cell[60803, 2052, 196, 5, 24, "Notes",
      CellTags->{"SA.9.6", "6.23"}]},
  "6.24"->{
    Cell[61036, 2062, 78, 1, 34, "Subsubsection",
      CellTags->{"SA.9.6", "6.24"}]},
  "6.25"->{
    Cell[61117, 2065, 181, 4, 40, "Notes",
      CellTags->{"SA.9.6", "6.25"}]},
  "6.26"->{
    Cell[61301, 2071, 185, 5, 40, "Notes",
      CellTags->{"SA.9.6", "6.26"}]},
  "6.27"->{
    Cell[61489, 2078, 152, 4, 24, "Notes",
      CellTags->{"SA.9.6", "6.27"}]},
  "6.28"->{
    Cell[61644, 2084, 165, 4, 24, "Notes",
      CellTags->{"SA.9.6", "6.28"}]},
  "6.29"->{
    Cell[61812, 2090, 208, 5, 40, "Notes",
      CellTags->{"SA.9.6", "6.29"}]},
  "6.30"->{
    Cell[62023, 2097, 301, 6, 56, "Notes",
      CellTags->{"SA.9.6", "6.30"}]},
  "6.31"->{
    Cell[62327, 2105, 136, 4, 24, "Notes",
      CellTags->{"SA.9.6", "6.31"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.9.0", 63118, 2130},
  {"0.1", 63208, 2133},
  {"SA.9.1", 63301, 2136},
  {"1.1", 63693, 2147},
  {"1.2", 63785, 2150},
  {"1.3", 63872, 2153},
  {"1.4", 63959, 2156},
  {"1.5", 64046, 2159},
  {"SA.9.2", 64136, 2162},
  {"2.1", 64762, 2179},
  {"2.2", 64855, 2182},
  {"2.3", 64943, 2185},
  {"2.4", 65031, 2188},
  {"2.5", 65119, 2191},
  {"2.6", 65207, 2194},
  {"2.7", 65295, 2197},
  {"2.8", 65383, 2200},
  {"SA.9.3", 65475, 2203},
  {"3.1", 66074, 2218},
  {"3.2", 66167, 2221},
  {"3.3", 66255, 2224},
  {"Rule", 66353, 2227},
  {"3.4", 66450, 2230},
  {"3.5", 66538, 2233},
  {"3.6", 66626, 2236},
  {"RegularExpression", 66769, 2239},
  {"StringExpression", 66911, 2242},
  {"3.7", 67040, 2245},
  {"SA.9.4", 67131, 2248},
  {"4.1", 77419, 2488},
  {"4.2", 77512, 2491},
  {"4.3", 77609, 2494},
  {"4.4", 77699, 2497},
  {"4.5", 77788, 2500},
  {"IntegerDigits", 77918, 2503},
  {"RealDigits", 78045, 2506},
  {"4.6", 78165, 2509},
  {"N", 78257, 2512},
  {"4.7", 78351, 2515},
  {"Floor", 78462, 2518},
  {"Ceiling", 78575, 2521},
  {"4.8", 78684, 2524},
  {"4.9", 78780, 2527},
  {"4.10", 78870, 2530},
  {"4.11", 78961, 2533},
  {"4.12", 79052, 2536},
  {"4.13", 79143, 2539},
  {"4.14", 79234, 2542},
  {"4.15", 79325, 2545},
  {"4.16", 79423, 2548},
  {"Random", 79527, 2551},
  {"4.17", 79629, 2554},
  {"4.18", 79721, 2557},
  {"4.19", 79820, 2560},
  {"4.20", 79912, 2563},
  {"PrimeQ", 80016, 2566},
  {"4.21", 80118, 2569},
  {"4.22", 80211, 2572},
  {"4.23", 80304, 2575},
  {"FactorInteger", 80423, 2578},
  {"4.24", 80533, 2581},
  {"4.25", 80625, 2584},
  {"Prime", 80739, 2587},
  {"PrimePi", 80855, 2590},
  {"4.26", 80968, 2593},
  {"LatticeReduce", 81086, 2596},
  {"4.27", 81195, 2599},
  {"4.28", 81287, 2602},
  {"ContinuedFraction", 81413, 2605},
  {"4.29", 81526, 2608},
  {"FromContinuedFraction", 81660, 2611},
  {"4.30", 81777, 2614},
  {"4.31", 81876, 2617},
  {"4.32", 81968, 2620},
  {"Factorial", 82090, 2623},
  {"Binomial", 82211, 2626},
  {"4.33", 82328, 2629},
  {"Fibonacci", 82438, 2632},
  {"4.34", 82543, 2635},
  {"PartitionsP", 82658, 2638},
  {"4.35", 82766, 2641},
  {"ClebschGordan", 82884, 2644},
  {"4.36", 82993, 2647},
  {"4.37", 83092, 2650},
  {"4.38", 83184, 2653},
  {"4.39", 83276, 2656},
  {"4.40", 83375, 2659},
  {"4.41", 83467, 2662},
  {"4.42", 83559, 2665},
  {"Pi", 83655, 2668},
  {"4.43", 83753, 2671},
  {"E", 83847, 2674},
  {"4.44", 83944, 2677},
  {"EulerGamma", 84056, 2680},
  {"4.45", 84162, 2683},
  {"Catalan", 84268, 2686},
  {"4.46", 84371, 2689},
  {"4.47", 84470, 2692},
  {"4.48", 84562, 2695},
  {"4.49", 84654, 2698},
  {"Gamma", 84756, 2701},
  {"4.50", 84857, 2704},
  {"4.51", 84949, 2707},
  {"PolyGamma", 85059, 2710},
  {"4.52", 85164, 2713},
  {"PolyLog", 85270, 2716},
  {"4.53", 85373, 2719},
  {"Zeta", 85473, 2722},
  {"4.54", 85573, 2725},
  {"StieltjesGamma", 85693, 2728},
  {"4.55", 85803, 2731},
  {"4.56", 85895, 2734},
  {"4.57", 85987, 2737},
  {"4.58", 86079, 2740},
  {"4.59", 86171, 2743},
  {"4.60", 86263, 2746},
  {"4.61", 86355, 2749},
  {"4.62", 86447, 2752},
  {"4.63", 86539, 2755},
  {"4.64", 86631, 2758},
  {"4.65", 86730, 2761},
  {"NIntegrate", 86842, 2764},
  {"4.66", 86948, 2767},
  {"4.67", 87041, 2770},
  {"4.68", 87133, 2773},
  {"4.69", 87225, 2776},
  {"4.70", 87317, 2779},
  {"4.71", 87409, 2782},
  {"4.72", 87501, 2785},
  {"4.73", 87593, 2788},
  {"4.74", 87685, 2791},
  {"4.75", 87777, 2794},
  {"4.76", 87876, 2797},
  {"NSum", 87976, 2800},
  {"4.77", 88076, 2803},
  {"4.78", 88168, 2806},
  {"4.79", 88267, 2809},
  {"NDSolve", 88373, 2812},
  {"4.80", 88476, 2815},
  {"4.81", 88568, 2818},
  {"4.82", 88660, 2821},
  {"4.83", 88753, 2824},
  {"4.84", 88845, 2827},
  {"4.85", 88937, 2830},
  {"4.86", 89037, 2833},
  {"NSolve", 89141, 2836},
  {"4.87", 89243, 2839},
  {"4.88", 89335, 2842},
  {"4.89", 89427, 2845},
  {"FindRoot", 89535, 2848},
  {"4.90", 89639, 2851},
  {"FindMaximum", 89769, 2854},
  {"FindMinimum", 89899, 2857},
  {"4.91", 90022, 2860},
  {"4.92", 90114, 2863},
  {"LinearProgramming", 90240, 2866},
  {"4.93", 90353, 2869},
  {"NMinimize", 90477, 2872},
  {"NMaximize", 90601, 2875},
  {"4.94", 90720, 2878},
  {"4.95", 90819, 2881},
  {"Fourier", 90926, 2884},
  {"4.96", 91030, 2887},
  {"4.97", 91123, 2890},
  {"ListConvolve", 91257, 2893},
  {"ListCorrelate", 91392, 2896},
  {"4.98", 91518, 2899},
  {"InterpolatingFunction", 91653, 2902},
  {"4.99", 91771, 2905},
  {"Fit", 91882, 2908},
  {"FindFit", 91997, 2911},
  {"4.100", 92110, 2914},
  {"CellularAutomaton", 92239, 2917},
  {"4.101", 92356, 2920},
  {"4.102", 92458, 2923},
  {"4.103", 92553, 2926},
  {"SparseArray", 92669, 2929},
  {"4.104", 92779, 2932},
  {"4.105", 92874, 2935},
  {"4.106", 92969, 2938},
  {"LinearSolve", 93152, 2943},
  {"LUDecomposition", 93581, 2953},
  {"Inverse", 93760, 2958},
  {"RowReduce", 94048, 2965},
  {"Det", 94223, 2970},
  {"4.107", 94488, 2977},
  {"Eigenvalues", 94643, 2981},
  {"Eigenvectors", 94799, 2985},
  {"4.108", 94948, 2989},
  {"SingularValueDecomposition", 95138, 2994},
  {"MatrixRank", 95312, 2999},
  {"NullSpace", 95593, 3006},
  {"4.109", 95870, 3013},
  {"QRDecomposition", 95994, 3016},
  {"4.110", 96108, 3019},
  {"SchurDecomposition", 96238, 3022},
  {"4.111", 96355, 3025},
  {"MatrixExp", 96467, 3028},
  {"4.112", 96668, 3033},
  {"4.113", 96770, 3036},
  {"4.114", 96891, 3039},
  {"4.115", 96986, 3042},
  {"4.116", 97088, 3045},
  {"4.117", 97183, 3048},
  {"SA.9.5", 97279, 3051},
  {"5.1", 104543, 3225},
  {"5.2", 104638, 3228},
  {"5.3", 104736, 3231},
  {"Factor", 104840, 3234},
  {"5.4", 104941, 3237},
  {"5.5", 105032, 3240},
  {"5.6", 105123, 3243},
  {"5.7", 105214, 3246},
  {"5.8", 105305, 3249},
  {"5.9", 105396, 3252},
  {"5.10", 105488, 3255},
  {"5.11", 105581, 3258},
  {"5.12", 105674, 3261},
  {"5.13", 105774, 3264},
  {"5.14", 105895, 3267},
  {"5.15", 105988, 3270},
  {"5.16", 106081, 3273},
  {"5.17", 106187, 3276},
  {"5.18", 106280, 3279},
  {"5.19", 106380, 3282},
  {"5.20", 106473, 3285},
  {"5.21", 106567, 3288},
  {"5.22", 106661, 3291},
  {"Solve", 106764, 3294},
  {"5.23", 106866, 3297},
  {"GroebnerBasis", 106985, 3300},
  {"5.24", 107095, 3303},
  {"5.25", 107188, 3306},
  {"5.26", 107281, 3309},
  {"Reduce", 107386, 3312},
  {"5.27", 107489, 3315},
  {"5.28", 107583, 3318},
  {"CylindricalDecomposition", 107725, 3321},
  {"5.29", 107847, 3324},
  {"5.30", 107941, 3327},
  {"5.31", 108034, 3330},
  {"Resolve", 108141, 3333},
  {"5.32", 108245, 3336},
  {"5.33", 108338, 3339},
  {"5.34", 108438, 3342},
  {"Maximize", 108559, 3345},
  {"Minimize", 108680, 3348},
  {"5.35", 108797, 3351},
  {"5.36", 108890, 3354},
  {"5.37", 108990, 3357},
  {"FunctionExpand", 109146, 3361},
  {"FullSimplify", 109300, 3365},
  {"Simplify", 109450, 3369},
  {"5.38", 109596, 3373},
  {"5.39", 109689, 3376},
  {"5.40", 109782, 3379},
  {"5.41", 109875, 3382},
  {"5.42", 109968, 3385},
  {"5.43", 110061, 3388},
  {"5.44", 110154, 3391},
  {"5.45", 110247, 3394},
  {"Piecewise", 110377, 3397},
  {"PiecewiseExpand", 110513, 3400},
  {"5.46", 110638, 3403},
  {"5.47", 110738, 3406},
  {"D", 110833, 3409},
  {"5.48", 110931, 3412},
  {"Integrate", 111042, 3415},
  {"5.49", 111148, 3418},
  {"5.50", 111241, 3421},
  {"5.51", 111334, 3424},
  {"5.52", 111427, 3427},
  {"5.53", 111520, 3430},
  {"5.54", 111613, 3433},
  {"5.55", 111706, 3436},
  {"5.56", 111806, 3439},
  {"DSolve", 111911, 3442},
  {"5.57", 112014, 3445},
  {"5.58", 112107, 3448},
  {"5.59", 112200, 3451},
  {"5.60", 112293, 3454},
  {"5.61", 112386, 3457},
  {"5.62", 112479, 3460},
  {"5.63", 112572, 3463},
  {"5.64", 112665, 3466},
  {"5.65", 112758, 3469},
  {"5.66", 112851, 3472},
  {"5.67", 112944, 3475},
  {"5.68", 113037, 3478},
  {"5.69", 113137, 3481},
  {"Sum", 113247, 3484},
  {"Product", 113361, 3487},
  {"5.70", 113472, 3490},
  {"5.71", 113565, 3493},
  {"5.72", 113658, 3496},
  {"5.73", 113751, 3499},
  {"5.74", 113844, 3502},
  {"5.75", 113937, 3505},
  {"5.76", 114030, 3508},
  {"5.77", 114123, 3511},
  {"5.78", 114223, 3514},
  {"Series", 114328, 3517},
  {"5.79", 114431, 3520},
  {"5.80", 114524, 3523},
  {"5.81", 114624, 3526},
  {"RSolve", 114729, 3529},
  {"5.82", 114832, 3532},
  {"5.83", 114925, 3535},
  {"5.84", 115018, 3538},
  {"5.85", 115111, 3541},
  {"5.86", 115205, 3544},
  {"SA.9.6", 115300, 3547},
  {"6.1", 117832, 3610},
  {"6.2", 117927, 3613},
  {"6.3", 118025, 3616},
  {"Plot3D", 118129, 3619},
  {"6.4", 118230, 3622},
  {"6.5", 118321, 3625},
  {"6.6", 118412, 3628},
  {"6.7", 118510, 3631},
  {"6.8", 118601, 3634},
  {"6.9", 118692, 3637},
  {"6.10", 118784, 3640},
  {"6.11", 118877, 3643},
  {"6.12", 118977, 3646},
  {"6.13", 119070, 3649},
  {"6.14", 119163, 3652},
  {"6.15", 119256, 3655},
  {"6.16", 119349, 3658},
  {"6.17", 119442, 3661},
  {"6.18", 119535, 3664},
  {"6.19", 119628, 3667},
  {"6.20", 119728, 3670},
  {"6.21", 119821, 3673},
  {"6.22", 119914, 3676},
  {"6.23", 120007, 3679},
  {"6.24", 120100, 3682},
  {"6.25", 120200, 3685},
  {"6.26", 120293, 3688},
  {"6.27", 120386, 3691},
  {"6.28", 120479, 3694},
  {"6.29", 120572, 3697},
  {"6.30", 120665, 3700},
  {"6.31", 120758, 3703}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 140, 4, 65, "Section",
  CellTags->{"SA.9.0", "0.1"}],

Cell[CellGroupData[{
Cell[1941, 61, 71, 1, 70, "Subsection",
  CellTags->{"SA.9.1", "1.1"}],
Cell[2015, 64, 337, 9, 70, "Text",
  CellTags->{"SA.9.1", "1.2"}],
Cell[2355, 75, 180, 4, 70, "Text",
  CellTags->{"SA.9.1", "1.3"}],
Cell[2538, 81, 248, 5, 70, "Text",
  CellTags->{"SA.9.1", "1.4"}],
Cell[2789, 88, 378, 8, 70, "Text",
  CellTags->{"SA.9.1", "1.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[3204, 101, 96, 1, 70, "Subsection",
  CellTags->{"SA.9.2", "2.1"}],
Cell[3303, 104, 237, 6, 70, "Text",
  CellTags->{"SA.9.2", "2.2"}],
Cell[3543, 112, 165, 4, 70, "Text",
  CellTags->{"SA.9.2", "2.3"}],
Cell[3711, 118, 193, 5, 70, "Text",
  CellTags->{"SA.9.2", "2.4"}],
Cell[3907, 125, 247, 5, 70, "Text",
  CellTags->{"SA.9.2", "2.5"}],
Cell[4157, 132, 249, 6, 70, "Text",
  CellTags->{"SA.9.2", "2.6"}],
Cell[4409, 140, 384, 7, 70, "Text",
  CellTags->{"SA.9.2", "2.7"}],
Cell[4796, 149, 635, 18, 70, "Text",
  CellTags->{"SA.9.2", "2.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5468, 172, 80, 1, 70, "Subsection",
  CellTags->{"SA.9.3", "3.1"}],
Cell[5551, 175, 255, 6, 70, "Text",
  CellTags->{"SA.9.3", "3.2"}],
Cell[5809, 183, 409, 11, 70, "Text",
  CellTags->{"SA.9.3", "3.3", "Rule"}],
Cell[6221, 196, 164, 4, 70, "Text",
  CellTags->{"SA.9.3", "3.4"}],
Cell[6388, 202, 141, 4, 70, "Text",
  CellTags->{"SA.9.3", "3.5"}],
Cell[6532, 208, 198, 4, 70, "Text",
  CellTags->{"SA.9.3", "3.6", "RegularExpression", "StringExpression"}],
Cell[6733, 214, 275, 6, 70, "Text",
  CellTags->{"SA.9.3", "3.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7045, 225, 90, 1, 70, "Subsection",
  CellTags->{"SA.9.4", "4.1"}],

Cell[CellGroupData[{
Cell[7160, 230, 102, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.2"}],
Cell[7265, 233, 387, 10, 70, "Notes",
  CellTags->{"SA.9.4", "4.3"}],
Cell[7655, 245, 150, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.4"}],
Cell[7808, 251, 358, 9, 70, "Notes",
  CellTags->{"SA.9.4", "4.5", "IntegerDigits", "RealDigits"}],
Cell[8169, 262, 253, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.6", "N"}],
Cell[8425, 270, 310, 9, 70, "Notes",
  CellTags->{"SA.9.4", "4.7", "Floor", "Ceiling"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8772, 284, 72, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.8"}],
Cell[8847, 287, 299, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.9"}],
Cell[9149, 295, 167, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.10"}],
Cell[9319, 301, 161, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.11"}],
Cell[9483, 307, 156, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.12"}],
Cell[9642, 313, 124, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.13"}],
Cell[9769, 319, 185, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.14"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9991, 329, 77, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.15"}],
Cell[10071, 332, 199, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.16", "Random"}],
Cell[10273, 339, 179, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.17"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[10489, 348, 93, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.18"}],
Cell[10585, 351, 327, 8, 70, "Notes",
  CellTags->{"SA.9.4", "4.19"}],
Cell[10915, 361, 290, 7, 70, "Notes",
  CellTags->{"SA.9.4", "4.20", "PrimeQ"}],
Cell[11208, 370, 501, 15, 70, "Notes",
  CellTags->{"SA.9.4", "4.21"}],
Cell[11712, 387, 385, 10, 70, "Notes",
  CellTags->{"SA.9.4", "4.22"}],
Cell[12100, 399, 378, 11, 70, "Notes",
  CellTags->{"SA.9.4", "4.23", "FactorInteger"}],
Cell[12481, 412, 245, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.24"}],
Cell[12729, 420, 557, 17, 70, "Notes",
  CellTags->{"SA.9.4", "4.25", "Prime", "PrimePi"}],
Cell[13289, 439, 224, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.26", "LatticeReduce"}],
Cell[13516, 447, 354, 7, 70, "Notes",
  CellTags->{"SA.9.4", "4.27"}],
Cell[13873, 456, 245, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.28", "ContinuedFraction"}],
Cell[14121, 464, 258, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.29", "FromContinuedFraction"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[14416, 475, 80, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.30"}],
Cell[14499, 478, 143, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.31"}],
Cell[14645, 484, 310, 8, 70, "Notes",
  CellTags->{"SA.9.4", "4.32", "Factorial", "Binomial"}],
Cell[14958, 494, 278, 9, 70, "Notes",
  CellTags->{"SA.9.4", "4.33", "Fibonacci"}],
Cell[15239, 505, 385, 12, 70, "Notes",
  CellTags->{"SA.9.4", "4.34", "PartitionsP"}],
Cell[15627, 519, 206, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.35", "ClebschGordan"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[15870, 529, 92, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.36"}],
Cell[15965, 532, 206, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.37"}],
Cell[16174, 539, 165, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.38"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16376, 548, 79, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.39"}],
Cell[16458, 551, 126, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.40"}],
Cell[16587, 557, 145, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.41"}],
Cell[16735, 563, 165, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.42", "Pi"}],
Cell[16903, 570, 160, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.43", "E"}],
Cell[17066, 577, 182, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.44", "EulerGamma"}],
Cell[17251, 584, 188, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.45", "Catalan"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[17476, 594, 74, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.46"}],
Cell[17553, 597, 285, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.47"}],
Cell[17841, 605, 197, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.48"}],
Cell[18041, 612, 200, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.49", "Gamma"}],
Cell[18244, 619, 167, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.50"}],
Cell[18414, 625, 215, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.51", "PolyGamma"}],
Cell[18632, 633, 251, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.52", "PolyLog"}],
Cell[18886, 641, 291, 7, 70, "Notes",
  CellTags->{"SA.9.4", "4.53", "Zeta"}],
Cell[19180, 650, 255, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.54", "StieltjesGamma"}],
Cell[19438, 658, 200, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.55"}],
Cell[19641, 665, 182, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.56"}],
Cell[19826, 671, 197, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.57"}],
Cell[20026, 678, 329, 9, 70, "Notes",
  CellTags->{"SA.9.4", "4.58"}],
Cell[20358, 689, 232, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.59"}],
Cell[20593, 697, 157, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.60"}],
Cell[20753, 703, 169, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.61"}],
Cell[20925, 709, 159, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.62"}],
Cell[21087, 715, 205, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.63"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[21329, 725, 78, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.64"}],
Cell[21410, 728, 302, 7, 70, "Notes",
  CellTags->{"SA.9.4", "4.65", "NIntegrate"}],
Cell[21715, 737, 301, 11, 70, "Notes",
  CellTags->{"SA.9.4", "4.66"}],
Cell[22019, 750, 269, 9, 70, "Notes",
  CellTags->{"SA.9.4", "4.67"}],
Cell[22291, 761, 220, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.68"}],
Cell[22514, 769, 193, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.69"}],
Cell[22710, 776, 158, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.70"}],
Cell[22871, 783, 219, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.71"}],
Cell[23093, 791, 171, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.72"}],
Cell[23267, 798, 160, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.73"}],
Cell[23430, 805, 212, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.74"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[23679, 816, 84, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.75"}],
Cell[23766, 819, 206, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.76", "NSum"}],
Cell[23975, 826, 227, 8, 70, "Notes",
  CellTags->{"SA.9.4", "4.77"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[24239, 839, 89, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.78"}],
Cell[24331, 842, 316, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.79", "NDSolve"}],
Cell[24650, 850, 175, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.80"}],
Cell[24828, 856, 182, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.81"}],
Cell[25013, 862, 326, 10, 70, "Notes",
  CellTags->{"SA.9.4", "4.82"}],
Cell[25342, 874, 235, 7, 70, "Notes",
  CellTags->{"SA.9.4", "4.83"}],
Cell[25580, 883, 184, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.84"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[25801, 893, 102, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.85"}],
Cell[25906, 896, 168, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.86", "NSolve"}],
Cell[26077, 902, 320, 8, 70, "Notes",
  CellTags->{"SA.9.4", "4.87"}],
Cell[26400, 912, 304, 7, 70, "Notes",
  CellTags->{"SA.9.4", "4.88"}],
Cell[26707, 921, 204, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.89", "FindRoot"}],
Cell[26914, 928, 444, 11, 70, "Notes",
  CellTags->{"SA.9.4", "4.90", "FindMaximum", "FindMinimum"}],
Cell[27361, 941, 283, 8, 70, "Notes",
  CellTags->{"SA.9.4", "4.91"}],
Cell[27647, 951, 307, 7, 70, "Notes",
  CellTags->{"SA.9.4", "4.92", "LinearProgramming"}],
Cell[27957, 960, 431, 10, 70, "Notes",
  CellTags->{"SA.9.4", "4.93", "NMinimize", "NMaximize"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[28425, 975, 74, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.94"}],
Cell[28502, 978, 662, 21, 70, "Notes",
  CellTags->{"SA.9.4", "4.95", "Fourier"}],
Cell[29167, 1001, 168, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.96"}],
Cell[29338, 1008, 328, 8, 70, "Notes",
  CellTags->{"SA.9.4", "4.97", "ListConvolve", "ListCorrelate"}],
Cell[29669, 1018, 248, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.98", "InterpolatingFunction"}],
Cell[29920, 1026, 435, 11, 70, "Notes",
  CellTags->{"SA.9.4", "4.99", "Fit", "FindFit"}],
Cell[30358, 1039, 517, 10, 70, "Notes",
  CellTags->{"SA.9.4", "4.100", "CellularAutomaton"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[30912, 1054, 94, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.101"}],
Cell[31009, 1057, 195, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.102"}],
Cell[31207, 1064, 369, 7, 70, "Notes",
  CellTags->{"SA.9.4", "4.103", "SparseArray"}],
Cell[31579, 1073, 177, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.104"}],
Cell[31759, 1079, 155, 4, 70, "Notes",
  CellTags->{"SA.9.4", "4.105"}],
Cell[31917, 1085, 510, 16, 70, "Notes",
  CellTags->{
  "SA.9.4", "4.106", "LinearSolve", "LUDecomposition", "Inverse", "RowReduce",
     "Det"}],
Cell[32430, 1103, 577, 13, 70, "Notes",
  CellTags->{
  "SA.9.4", "4.107", "LinearSolve", "Eigenvalues", "Eigenvectors"}],
Cell[33012, 1119, 485, 14, 70, "Notes",
  CellTags->{
  "SA.9.4", "4.108", "SingularValueDecomposition", "MatrixRank", 
    "NullSpace"}],
Cell[33502, 1136, 184, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.109", "QRDecomposition"}],
Cell[33689, 1143, 175, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.110", "SchurDecomposition"}],
Cell[33867, 1150, 278, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.111", "MatrixExp"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[34182, 1161, 88, 1, 70, "Subsubsection",
  CellTags->{"SA.9.4", "4.112"}],
Cell[34273, 1164, 255, 7, 70, "Notes",
  CellTags->{"SA.9.4", "4.113", "Inverse", "LinearSolve"}],
Cell[34531, 1173, 192, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.114"}],
Cell[34726, 1181, 227, 6, 70, "Notes",
  CellTags->{"SA.9.4", "4.115", "Det"}],
Cell[34956, 1189, 181, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.116"}],
Cell[35140, 1196, 172, 5, 70, "Notes",
  CellTags->{"SA.9.4", "4.117"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35361, 1207, 79, 1, 70, "Subsection",
  CellTags->{"SA.9.5", "5.1"}],

Cell[CellGroupData[{
Cell[35465, 1212, 79, 1, 70, "Subsubsection",
  CellTags->{"SA.9.5", "5.2"}],
Cell[35547, 1215, 328, 7, 70, "Notes",
  CellTags->{"SA.9.5", "5.3", "Factor"}],
Cell[35878, 1224, 213, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.4"}],
Cell[36094, 1231, 350, 7, 70, "Notes",
  CellTags->{"SA.9.5", "5.5"}],
Cell[36447, 1240, 212, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.6"}],
Cell[36662, 1247, 197, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.7"}],
Cell[36862, 1254, 257, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.8"}],
Cell[37122, 1262, 217, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.9"}],
Cell[37342, 1270, 317, 9, 70, "Notes",
  CellTags->{"SA.9.5", "5.10"}],
Cell[37662, 1281, 192, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.11"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[37891, 1291, 80, 1, 70, "Subsubsection",
  CellTags->{"SA.9.5", "5.12"}],
Cell[37974, 1294, 309, 11, 70, "Notes",
  CellTags->{"SA.9.5", "5.13", "NullSpace", "MatrixRank"}],
Cell[38286, 1307, 234, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.14"}],
Cell[38523, 1315, 213, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.15"}],
Cell[38739, 1323, 186, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.16", "MatrixExp"}],
Cell[38928, 1330, 278, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.17"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[39243, 1341, 93, 1, 70, "Subsubsection",
  CellTags->{"SA.9.5", "5.18"}],
Cell[39339, 1344, 168, 4, 70, "Notes",
  CellTags->{"SA.9.5", "5.19"}],
Cell[39510, 1350, 490, 12, 70, "Notes",
  CellTags->{"SA.9.5", "5.20"}],
Cell[40003, 1364, 369, 10, 70, "Notes",
  CellTags->{"SA.9.5", "5.21"}],
Cell[40375, 1376, 206, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.22", "Solve"}],
Cell[40584, 1383, 237, 7, 70, "Notes",
  CellTags->{"SA.9.5", "5.23", "GroebnerBasis"}],
Cell[40824, 1392, 223, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.24"}],
Cell[41050, 1399, 180, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.25"}],
Cell[41233, 1406, 273, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.26", "Reduce"}],
Cell[41509, 1414, 565, 13, 70, "Notes",
  CellTags->{"SA.9.5", "5.27"}],
Cell[42077, 1429, 551, 10, 70, "Notes",
  CellTags->{"SA.9.5", "5.28", "CylindricalDecomposition"}],
Cell[42631, 1441, 715, 14, 70, "Notes",
  CellTags->{"SA.9.5", "5.29"}],
Cell[43349, 1457, 354, 7, 70, "Notes",
  CellTags->{"SA.9.5", "5.30"}],
Cell[43706, 1466, 221, 7, 70, "Notes",
  CellTags->{"SA.9.5", "5.31", "Resolve"}],
Cell[43930, 1475, 238, 7, 70, "Notes",
  CellTags->{"SA.9.5", "5.32"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[44205, 1487, 75, 1, 70, "Subsubsection",
  CellTags->{"SA.9.5", "5.33"}],
Cell[44283, 1490, 313, 8, 70, "Notes",
  CellTags->{"SA.9.5", "5.34", "Maximize", "Minimize"}],
Cell[44599, 1500, 195, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.35"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[44831, 1510, 71, 1, 70, "Subsubsection",
  CellTags->{"SA.9.5", "5.36"}],
Cell[44905, 1513, 325, 7, 70, "Notes",
  CellTags->{
  "SA.9.5", "5.37", "FunctionExpand", "FullSimplify", "Simplify"}],
Cell[45235, 1523, 332, 9, 70, "Notes",
  CellTags->{"SA.9.5", "5.38"}],
Cell[45570, 1534, 327, 9, 70, "Notes",
  CellTags->{"SA.9.5", "5.39"}],
Cell[45900, 1545, 200, 7, 70, "Notes",
  CellTags->{"SA.9.5", "5.40"}],
Cell[46103, 1554, 416, 8, 70, "Notes",
  CellTags->{"SA.9.5", "5.41"}],
Cell[46522, 1564, 178, 4, 70, "Notes",
  CellTags->{"SA.9.5", "5.42"}],
Cell[46703, 1570, 358, 7, 70, "Notes",
  CellTags->{"SA.9.5", "5.43"}],
Cell[47064, 1579, 224, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.44"}],
Cell[47291, 1587, 208, 4, 70, "Notes",
  CellTags->{"SA.9.5", "5.45", "Piecewise", "PiecewiseExpand"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[47536, 1596, 88, 1, 70, "Subsubsection",
  CellTags->{"SA.9.5", "5.46"}],
Cell[47627, 1599, 152, 4, 70, "Notes",
  CellTags->{"SA.9.5", "5.47", "D"}],
Cell[47782, 1605, 342, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.48", "Integrate"}],
Cell[48127, 1613, 175, 4, 70, "Notes",
  CellTags->{"SA.9.5", "5.49"}],
Cell[48305, 1619, 247, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.50"}],
Cell[48555, 1627, 193, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.51"}],
Cell[48751, 1634, 351, 7, 70, "Notes",
  CellTags->{"SA.9.5", "5.52"}],
Cell[49105, 1643, 233, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.53"}],
Cell[49341, 1650, 219, 7, 70, "Notes",
  CellTags->{"SA.9.5", "5.54"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[49597, 1662, 79, 1, 70, "Subsubsection",
  CellTags->{"SA.9.5", "5.55"}],
Cell[49679, 1665, 185, 4, 70, "Notes",
  CellTags->{"SA.9.5", "5.56", "DSolve"}],
Cell[49867, 1671, 275, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.57"}],
Cell[50145, 1679, 169, 4, 70, "Notes",
  CellTags->{"SA.9.5", "5.58"}],
Cell[50317, 1685, 303, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.59"}],
Cell[50623, 1693, 266, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.60"}],
Cell[50892, 1701, 422, 8, 70, "Notes",
  CellTags->{"SA.9.5", "5.61"}],
Cell[51317, 1711, 193, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.62"}],
Cell[51513, 1718, 245, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.63"}],
Cell[51761, 1726, 198, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.64"}],
Cell[51962, 1733, 218, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.65"}],
Cell[52183, 1740, 212, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.66"}],
Cell[52398, 1747, 216, 7, 70, "Notes",
  CellTags->{"SA.9.5", "5.67"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[52651, 1759, 74, 1, 70, "Subsubsection",
  CellTags->{"SA.9.5", "5.68"}],
Cell[52728, 1762, 166, 4, 70, "Notes",
  CellTags->{"SA.9.5", "5.69", "Sum", "Product"}],
Cell[52897, 1768, 246, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.70"}],
Cell[53146, 1775, 160, 4, 70, "Notes",
  CellTags->{"SA.9.5", "5.71"}],
Cell[53309, 1781, 144, 4, 70, "Notes",
  CellTags->{"SA.9.5", "5.72"}],
Cell[53456, 1787, 150, 4, 70, "Notes",
  CellTags->{"SA.9.5", "5.73"}],
Cell[53609, 1793, 240, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.74"}],
Cell[53852, 1801, 132, 4, 70, "Notes",
  CellTags->{"SA.9.5", "5.75"}],
Cell[53987, 1807, 228, 9, 70, "Notes",
  CellTags->{"SA.9.5", "5.76"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[54252, 1821, 74, 1, 70, "Subsubsection",
  CellTags->{"SA.9.5", "5.77"}],
Cell[54329, 1824, 238, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.78", "Series"}],
Cell[54570, 1832, 135, 4, 70, "Notes",
  CellTags->{"SA.9.5", "5.79"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[54742, 1841, 77, 1, 70, "Subsubsection",
  CellTags->{"SA.9.5", "5.80"}],
Cell[54822, 1844, 216, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.81", "RSolve"}],
Cell[55041, 1852, 221, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.82"}],
Cell[55265, 1859, 266, 6, 70, "Notes",
  CellTags->{"SA.9.5", "5.83"}],
Cell[55534, 1867, 241, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.84"}],
Cell[55778, 1874, 367, 11, 70, "Notes",
  CellTags->{"SA.9.5", "5.85"}],
Cell[56148, 1887, 212, 5, 70, "Notes",
  CellTags->{"SA.9.5", "5.86"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[56409, 1898, 81, 1, 70, "Subsection",
  CellTags->{"SA.9.6", "6.1"}],

Cell[CellGroupData[{
Cell[56515, 1903, 64, 1, 70, "Subsubsection",
  CellTags->{"SA.9.6", "6.2"}],
Cell[56582, 1906, 198, 5, 70, "Notes",
  CellTags->{"SA.9.6", "6.3", "Plot3D"}],
Cell[56783, 1913, 172, 4, 70, "Notes",
  CellTags->{"SA.9.6", "6.4"}],
Cell[56958, 1919, 153, 4, 70, "Notes",
  CellTags->{"SA.9.6", "6.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[57148, 1928, 65, 1, 70, "Subsubsection",
  CellTags->{"SA.9.6", "6.6"}],
Cell[57216, 1931, 248, 6, 70, "Notes",
  CellTags->{"SA.9.6", "6.7"}],
Cell[57467, 1939, 212, 6, 70, "Notes",
  CellTags->{"SA.9.6", "6.8"}],
Cell[57682, 1947, 181, 5, 70, "Notes",
  CellTags->{"SA.9.6", "6.9"}],
Cell[57866, 1954, 216, 5, 70, "Notes",
  CellTags->{"SA.9.6", "6.10"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[58119, 1964, 66, 1, 70, "Subsubsection",
  CellTags->{"SA.9.6", "6.11"}],
Cell[58188, 1967, 168, 5, 70, "Notes",
  CellTags->{"SA.9.6", "6.12"}],
Cell[58359, 1974, 271, 6, 70, "Notes",
  CellTags->{"SA.9.6", "6.13"}],
Cell[58633, 1982, 210, 5, 70, "Notes",
  CellTags->{"SA.9.6", "6.14"}],
Cell[58846, 1989, 209, 5, 40, "Notes",
  CellTags->{"SA.9.6", "6.15"}],
Cell[59058, 1996, 185, 5, 70, "Notes",
  CellTags->{"SA.9.6", "6.16"}],
Cell[59246, 2003, 229, 5, 40, "Notes",
  CellTags->{"SA.9.6", "6.17"}],
Cell[59478, 2010, 402, 8, 72, "Notes",
  CellTags->{"SA.9.6", "6.18"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[59917, 2023, 92, 1, 34, "Subsubsection",
  CellTags->{"SA.9.6", "6.19"}],
Cell[60012, 2026, 287, 6, 40, "Notes",
  CellTags->{"SA.9.6", "6.20"}],
Cell[60302, 2034, 241, 6, 40, "Notes",
  CellTags->{"SA.9.6", "6.21"}],
Cell[60546, 2042, 254, 8, 40, "Notes",
  CellTags->{"SA.9.6", "6.22"}],
Cell[60803, 2052, 196, 5, 24, "Notes",
  CellTags->{"SA.9.6", "6.23"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[61036, 2062, 78, 1, 34, "Subsubsection",
  CellTags->{"SA.9.6", "6.24"}],
Cell[61117, 2065, 181, 4, 40, "Notes",
  CellTags->{"SA.9.6", "6.25"}],
Cell[61301, 2071, 185, 5, 40, "Notes",
  CellTags->{"SA.9.6", "6.26"}],
Cell[61489, 2078, 152, 4, 24, "Notes",
  CellTags->{"SA.9.6", "6.27"}],
Cell[61644, 2084, 165, 4, 24, "Notes",
  CellTags->{"SA.9.6", "6.28"}],
Cell[61812, 2090, 208, 5, 40, "Notes",
  CellTags->{"SA.9.6", "6.29"}],
Cell[62023, 2097, 301, 6, 56, "Notes",
  CellTags->{"SA.9.6", "6.30"}],
Cell[62327, 2105, 136, 4, 24, "Notes",
  CellTags->{"SA.9.6", "6.31"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

