(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    102829,       4353]*)
(*NotebookOutlinePosition[    175987,       6114]*)
(*  CellTagsIndexPosition[    171418,       5965]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.11 ", "HeadingNumber"],
  "Listing of C Functions in the ",
  StyleBox["MathLink", "SBO"],
  " Library"
}], "Section",
  CellTags->{"SA.11.0", "0.1"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->{"SA.11.1", "1.1"}],

Cell[TextData[{
  "Listed here are functions provided in the ",
  StyleBox["MathLink", "TI"],
  " Developer Kit.    "
}], "Text",
  CellTags->{"SA.11.1", "1.2"}],

Cell[TextData[{
  "These functions are declared in the file ",
  StyleBox["mathlink.h", "MR"],
  ", which should be included in the source code for any ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible program. "
}], "Text",
  CellTags->{"SA.11.1", "1.3"}],

Cell[TextData[{
  "Unless you specify ",
  StyleBox["#define", "MR"],
  " ",
  StyleBox["MLPROTOTYPES", "MR"],
  " ",
  StyleBox["0", "MR"],
  " before ",
  StyleBox["#include", "MR"],
  " ",
  StyleBox["\"mathlink.h\"", "MR"],
  " the functions will be included with standard C prototypes. "
}], "Text",
  CellTags->{"SA.11.1", "1.4"}],

Cell[TextData[{
  "The following special types are defined in ",
  StyleBox["mathlink.h", "MR"],
  ": "
}], "Text",
  CellTags->{"SA.11.1", "1.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLINK", "MR"],
  ": a ",
  StyleBox["MathLink", "TI"],
  " link object (analogous to ",
  StyleBox["LinkObject", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ")  \n\[FilledSmallSquare] ",
  StyleBox["MLMARK", "MR"],
  ": a mark in a ",
  StyleBox["MathLink", "TI"],
  " stream  \n\[FilledSmallSquare] ",
  StyleBox["MLENV", "MR"],
  ": ",
  StyleBox["MathLink", "TI"],
  " library environment   "
}], "Notes",
  CellTags->{"SA.11.1", "1.6"}],

Cell[TextData[{
  "The following constants are set up when a ",
  StyleBox["MathLink", "TI"],
  " template file is processed: "
}], "Text",
  CellTags->{"SA.11.1", "1.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLINK", "MR"],
  " ",
  StyleBox["stdlink", "MR"],
  ": the standard link that connects a program built from ",
  StyleBox["MathLink", "TI"],
  " templates to ",
  StyleBox["Mathematica", "TI"],
  " \n\[FilledSmallSquare] ",
  StyleBox["MLENV", "MR"],
  " ",
  StyleBox["stdenv", "MR"],
  ": the standard ",
  StyleBox["MathLink", "TI"],
  " environment in a program built from ",
  StyleBox["MathLink", "TI"],
  " templates   "
}], "Notes",
  CellTags->{"SA.11.1", "1.8"}],

Cell["\<\
All functions described here are C language functions. They can be \
called from other languages with appropriate wrappers. \
\>", "Text",
  CellTags->{"SA.11.1", "1.9"}],

Cell["The functions have the following general features: ", "Text",
  CellTags->{"SA.11.1", "1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] Those which return ",
  StyleBox["int", "MR"],
  " yield a non\[Hyphen]zero value if they succeed; otherwise they return ",
  StyleBox["0", "MR"],
  " and have no effect.  \n\[FilledSmallSquare] In a program set up using ",
  StyleBox["MathLink", "TI"],
  " templates, the link to ",
  StyleBox["Mathematica", "TI"],
  " is called ",
  StyleBox["stdlink", "MR"],
  ".  \n\[FilledSmallSquare] Functions which put data to a link do not \
deallocate memory used to store the data.  \n\[FilledSmallSquare] Functions \
which get data from a link may allocate memory to store the data.  \n\
\[FilledSmallSquare] Functions which get data from a link will not return \
until the necessary data becomes available. A yield function can be \
registered to be called during the wait.  "
}], "Notes",
  CellTags->{"SA.11.1", "1.11"}],

Cell[CellGroupData[{

Cell["MLAbort", "ObjectName",
  CellTags->{"S1.1001", "MLAbort"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLAbort", "MR"],
  " is a global variable set when a program created using ",
  StyleBox["mcc", "MR"],
  " or ",
  StyleBox["mprep", "MR"],
  " has been sent an abort interrupt. "
}], "Usage",
  CellTags->{"S1.1001", "MLAbort"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkInterrupt[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " can be used to send an abort interrupt from ",
  StyleBox["Mathematica", "TI"],
  " to a program connected to a particular link. "
}], "Notes",
  CellTags->{"S1.1001", "MLAbort"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.13",
    ButtonData:>{"2.13.13", "13.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1001", "MLAbort"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLActivate()", "ObjectName",
  CellTags->{"S1.1002", "MLActivate"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLActivate(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " activates a ",
  StyleBox["MathLink", "TI"],
  " connection, waiting for the program at the other end to respond. "
}], "Usage",
  CellTags->{"S1.1002", "MLActivate"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLActivate()", "MR"],
  " can be called only after ",
  StyleBox["MLOpenArgv()", "MR"],
  " or ",
  StyleBox["MLOpenString()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1002", "MLActivate"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1002", "MLActivate"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLCheckFunction()", "ObjectName",
  CellTags->{"S1.1003", "MLCheckFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLCheckFunction(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["name", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " checks that a function whose head is a symbol with the specified name is \
on ",
  StyleBox["link", "TI"],
  ", and stores the number of the arguments of the function in ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1003", "MLCheckFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLCheckFunction()", "MR"],
  " returns ",
  StyleBox["0", "MR"],
  " if the current object on the link is not a function with a symbol as a \
head, or if the name of the symbol does not match ",
  StyleBox["name", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1003", "MLCheckFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.125"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1003", "MLCheckFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetFunction",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1003", "MLCheckFunction"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLClearError()", "ObjectName",
  CellTags->{"S1.1004", "MLClearError"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLClearError(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " if possible clears any error on ",
  StyleBox["link", "TI"],
  " and reactivates the link. "
}], "Usage",
  CellTags->{"S1.1004", "MLClearError"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLClearError()", "MR"],
  " returns ",
  StyleBox["0", "MR"],
  " if it was unable to clear the error. This can happen if the error was for \
example the result of a link no longer being open. "
}], "Notes",
  CellTags->{"S1.1004", "MLClearError"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.13",
    ButtonData:>{"2.13.13", "13.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1004", "MLClearError"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLClose()", "ObjectName",
  CellTags->{"S1.1005", "MLClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void", "MR"],
  " ",
  StyleBox["MLClose(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " closes a ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Usage",
  CellTags->{"S1.1005", "MLClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] Calling ",
  StyleBox["MLClose()", "MR"],
  " does not necessarily terminate a program at the other end of the link. "
}], "Notes",
  CellTags->{"S1.1005", "MLClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] Any data buffered in the link is sent when ",
  StyleBox["MLClose()", "MR"],
  " is called. "
}], "Notes",
  CellTags->{"S1.1005", "MLClose"}],

Cell["\<\
\[FilledSmallSquare] Programs should close all links they have \
opened before terminating. \
\>", "Notes",
  CellTags->{"S1.1005", "MLClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1005", "MLClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLDeinitialize",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1005", "MLClose"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLCreateMark()", "ObjectName",
  CellTags->{"S1.1006", "MLCreateMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLMARK", "MR"],
  " ",
  StyleBox["MLCreateMark(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " creates a mark at the current position in a sequence of expressions on a \
link. "
}], "Usage",
  CellTags->{"S1.1006", "MLCreateMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] Calling ",
  StyleBox["MLCreateMark()", "MR"],
  " effectively starts recording all expressions received on the link. "
}], "Notes",
  CellTags->{"S1.1006", "MLCreateMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1006", "MLCreateMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLLoopbackOpen",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1006", "MLCreateMark"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDeinitialize()", "ObjectName",
  CellTags->{"S1.1007", "MLDeinitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void", "MR"],
  " ",
  StyleBox["MLDeinitialize(MLENV", "MR"],
  " ",
  StyleBox["env", "TI"],
  StyleBox[")", "MR"],
  " deinitializes functions in the ",
  StyleBox["MathLink", "TI"],
  " library. "
}], "Usage",
  CellTags->{"S1.1007", "MLDeinitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] An appropriate call to ",
  StyleBox["MLDeinitialize()", "MR"],
  " is generated automatically when an external program is created from ",
  StyleBox["MathLink", "TI"],
  " templates. "
}], "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] Any external program that uses the ",
  StyleBox["MathLink", "TI"],
  " library must call ",
  StyleBox["MLDeinitialize()", "MR"],
  " before exiting. "
}], "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLClose()", "MR"],
  " must be called for all open links before calling ",
  StyleBox["MLDeinitialize()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDestroyMark()", "ObjectName",
  CellTags->{"S1.1008", "MLDestroyMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLDestroyMark(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["MLMARK", "MR"],
  " ",
  StyleBox["mark", "TI"],
  StyleBox[")", "MR"],
  " destroys the specified mark on a link. "
}], "Usage",
  CellTags->{"S1.1008", "MLDestroyMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] Calling ",
  StyleBox["MLDestroyMark()", "MR"],
  " disowns memory associated with the storage of expressions recorded after \
the mark. "
}], "Notes",
  CellTags->{"S1.1008", "MLDestroyMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1008", "MLDestroyMark"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownByteString()", "ObjectName",
  CellTags->{"S1.1009", "MLDisownByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void", "MR"],
  " ",
  StyleBox["MLDisownByteString(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["unsigned", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetByteString()", "MR"],
  " to store the array of character codes ",
  StyleBox["s", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1009", "MLDisownByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1009", "MLDisownByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLDisownString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1009", "MLDisownByteString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownIntegerArray()", "ObjectName",
  CellTags->{"S1.1010", "MLDisownIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void", "MR"],
  " ",
  StyleBox["MLDisownIntegerArray(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["dims", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["heads", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["d", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetIntegerArray()", "MR"],
  " to store the array ",
  StyleBox["a", "TI"],
  ", its dimensions ",
  StyleBox["dims", "TI"],
  " and the heads ",
  StyleBox["heads", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1010", "MLDisownIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.162"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1010", "MLDisownIntegerArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownIntegerList()", "ObjectName",
  CellTags->{"S1.1011", "MLDisownIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void", "MR"],
  " ",
  StyleBox["MLDisownIntegerList(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetIntegerList()", "MR"],
  " to store the array ",
  StyleBox["a", "TI"],
  " of length ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1011", "MLDisownIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.146"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1011", "MLDisownIntegerList"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownRealArray()", "ObjectName",
  CellTags->{"S1.1012", "MLDisownRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void", "MR"],
  " ",
  StyleBox["MLDisownRealArray(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["double", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["dims", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["heads", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["d", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetRealArray()", "MR"],
  " to store the array ",
  StyleBox["a", "TI"],
  ", its dimensions ",
  StyleBox["dims", "TI"],
  " and the heads ",
  StyleBox["heads", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1012", "MLDisownRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.162"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1012", "MLDisownRealArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownRealList()", "ObjectName",
  CellTags->{"S1.1013", "MLDisownRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void", "MR"],
  " ",
  StyleBox["MLDisownRealList(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["double", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetRealList()", "MR"],
  " to store the array ",
  StyleBox["a", "TI"],
  " of length ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1013", "MLDisownRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.146"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1013", "MLDisownRealList"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownString()", "ObjectName",
  CellTags->{"S1.1014", "MLDisownString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void", "MR"],
  " ",
  StyleBox["MLDisownString(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetString()", "MR"],
  " to store the character string ",
  StyleBox["s", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1014", "MLDisownString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.166"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1014", "MLDisownString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLDisownUnicodeString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1014", "MLDisownString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownSymbol()", "ObjectName",
  CellTags->{"S1.1015", "MLDisownSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void", "MR"],
  " ",
  StyleBox["MLDisownSymbol(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetSymbol()", "MR"],
  " or ",
  StyleBox["MLGetFunction()", "MR"],
  " to store the character string ",
  StyleBox["s", "TI"],
  " corresponding to the name of a symbol. "
}], "Usage",
  CellTags->{"S1.1015", "MLDisownSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.166"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.168"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1015", "MLDisownSymbol"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownUnicodeString()", "ObjectName",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void", "MR"],
  " ",
  StyleBox["MLDisownUnicodeString(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["unsigned", "MR"],
  " ",
  StyleBox["short", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetUnicodeString()", "MR"],
  " to store the string ",
  StyleBox["s", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLDisownString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLEndPacket()", "ObjectName",
  CellTags->{"S1.1017", "MLEndPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLEndPacket(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " specifies that a packet expression is complete and is ready to be sent on \
the specified link. "
}], "Usage",
  CellTags->{"S1.1017", "MLEndPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLEndPacket()", "MR"],
  " should be called to indicate the end of any top\[Hyphen]level expression, \
regardless of whether its head is a standard packet. "
}], "Notes",
  CellTags->{"S1.1017", "MLEndPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.9",
    ButtonData:>{"2.13.9", "9.40"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1017", "MLEndPacket"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLError()", "ObjectName",
  CellTags->{"S1.1018", "MLError"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["MLError(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " returns a constant identifying the last error to occur on ",
  StyleBox["link", "TI"],
  ", or ",
  StyleBox["0", "MR"],
  " if none has occurred since the previous call to ",
  StyleBox["MLClearError()", "MR"],
  ". "
}], "Usage",
  CellTags->{"S1.1018", "MLError"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can get a textual description of errors by \
calling ",
  StyleBox["MLErrorMessage()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1018", "MLError"}],

Cell[TextData[{
  "\[FilledSmallSquare] Constants corresponding to standard ",
  StyleBox["MathLink", "TI"],
  " errors are defined in ",
  StyleBox["mathlink.h", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1018", "MLError"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.13",
    ButtonData:>{"2.13.13", "13.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1018", "MLError"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLErrorMessage()", "ObjectName",
  CellTags->{"S1.1019", "MLErrorMessage"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*MLErrorMessage(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " returns a character string describing the last error to occur on ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1019", "MLErrorMessage"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.13",
    ButtonData:>{"2.13.13", "13.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1019", "MLErrorMessage"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLEvaluateString()", "ObjectName",
  CellTags->{"S1.1020", "MLEvaluateString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLEvaluateString(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["string", "TI"],
  StyleBox[")", "MR"],
  " sends a string to ",
  StyleBox["Mathematica", "TI"],
  " for evaluation, and discards any packets sent in response. "
}], "Usage",
  CellTags->{"S1.1020", "MLEvaluateString"}],

Cell[TextData[{
  "\[FilledSmallSquare] The code for ",
  StyleBox["MLEvaluateString()", "MR"],
  " is not included in the ",
  StyleBox["MathLink", "TI"],
  " library, but is generated automatically by ",
  StyleBox["mcc", "MR"],
  " or ",
  StyleBox["mprep", "MR"],
  " in processing ",
  StyleBox["MathLink", "TI"],
  " template files. "
}], "Notes",
  CellTags->{"S1.1020", "MLEvaluateString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLEvaluateString(\"Print[\[Backslash]\"", "MR"],
  StyleBox["string", "TI"],
  "\[Backslash]",
  StyleBox["\"]\")", "MR"],
  " will cause ",
  StyleBox["string", "TI"],
  " to be printed in a ",
  StyleBox["Mathematica", "TI"],
  " session at the other end of the link. "
}], "Notes",
  CellTags->{"S1.1020", "MLEvaluateString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.3",
    ButtonData:>{"2.13.3", "3.70"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.9",
    ButtonData:>{"2.13.9", "9.23"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1020", "MLEvaluateString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLFlush()", "ObjectName",
  CellTags->{"S1.1021", "MLFlush"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLFlush(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " flushes out any buffers containing data waiting to be sent on ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1021", "MLFlush"}],

Cell[TextData[{
  "\[FilledSmallSquare] If you call ",
  StyleBox["MLNextPacket()", "MR"],
  " or any of the ",
  StyleBox["MLGet*()", "MR"],
  " functions, then ",
  StyleBox["MLFlush()", "MR"],
  " will be called automatically. "
}], "Notes",
  CellTags->{"S1.1021", "MLFlush"}],

Cell[TextData[{
  "\[FilledSmallSquare] If you call ",
  StyleBox["MLReady()", "MR"],
  ", then you need to call ",
  StyleBox["MLFlush()", "MR"],
  " first in order to ensure that any necessary outgoing data has been sent. \
"
}], "Notes",
  CellTags->{"S1.1021", "MLFlush"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.29"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1021", "MLFlush"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLReady",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1021", "MLFlush"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetArgCount()", "ObjectName",
  CellTags->{"S1.1022", "MLGetArgCount"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetArgCount(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " finds the number of arguments to a function on ",
  StyleBox["link", "TI"],
  " and stores the result in ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1022", "MLGetArgCount"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.52"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1022", "MLGetArgCount"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetByteString()", "ObjectName",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetByteString(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["unsigned", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["spec", "TI"],
  StyleBox[")", "MR"],
  " gets a string of characters from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the codes for the characters in ",
  StyleBox["s", "TI"],
  " and the number of characters in ",
  StyleBox["n", "TI"],
  ". The code ",
  StyleBox["spec", "TI"],
  " is used for any character whose ",
  StyleBox["Mathematica", "TI"],
  " character code is larger than 255. "
}], "Usage",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetByteString()", "MR"],
  " allocates memory for the array of character codes. You must call ",
  StyleBox["MLDisownByteString()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetByteString()", "MR"],
  " is convenient in situations where no special characters occur. "
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] The character codes used by ",
  StyleBox["MLGetByteString()", "MR"],
  " are exactly the ones returned by ",
  StyleBox["ToCharacterCode", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] The array of character codes in ",
  StyleBox["MLGetByteString()", "MR"],
  " is not terminated by a null character. "
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] Characters such as newlines are specified by their \
raw character codes, not by ASCII forms such as \[Backslash]",
  StyleBox["n", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetUnicodeString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetDouble()", "ObjectName",
  CellTags->{"S1.1024", "MLGetDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetDouble(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["double", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["x", "TI"],
  StyleBox[")", "MR"],
  " gets a floating\[Hyphen]point number from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " and stores it as C type ",
  StyleBox["double", "MR"],
  " in ",
  StyleBox["x", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1024", "MLGetDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetDouble()", "MR"],
  " is normally equivalent to ",
  StyleBox["MLGetReal()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLGetReal()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetFloat",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetFloat()", "ObjectName",
  CellTags->{"S1.1025", "MLGetFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetFloat(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["float", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["x", "TI"],
  StyleBox[")", "MR"],
  " gets a floating\[Hyphen]point number from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " and stores it as C type ",
  StyleBox["float", "MR"],
  " in ",
  StyleBox["x", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1025", "MLGetFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLGetReal()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1025", "MLGetFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1025", "MLGetFloat"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetFunction()", "ObjectName",
  CellTags->{"S1.1026", "MLGetFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetFunction(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " gets a function with a symbol as a head from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the name of the symbol in ",
  StyleBox["s", "TI"],
  " and the number of arguments of the function in ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1026", "MLGetFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetFunction()", "MR"],
  " allocates memory for the character string corresponding to the name of \
the head of the function. You must call ",
  StyleBox["MLDisownSymbol()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify the character \
string ",
  StyleBox["s", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetFunction(", "MR"],
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["&", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["&", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " has the same effect as ",
  StyleBox["MLGetNext(", "MR"],
  StyleBox["link", "TI"],
  StyleBox[");", "MR"],
  " ",
  StyleBox["MLGetArgCount(", "MR"],
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["&", "MR"],
  StyleBox["n", "TI"],
  StyleBox[");", "MR"],
  " ",
  StyleBox["MLGetSymbol(", "MR"],
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["&", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.168"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetNext",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetInteger()", "ObjectName",
  CellTags->{"S1.1027", "MLGetInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetInteger(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["i", "TI"],
  StyleBox[")", "MR"],
  " gets an integer from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " and stores it in ",
  StyleBox["i", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1027", "MLGetInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the data on the link corresponds to a real number, \
",
  StyleBox["MLGetInteger()", "MR"],
  " will round it to an integer. "
}], "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the data on the link corresponds to an integer too \
large to store in a C ",
  StyleBox["int", "MR"],
  " on your computer system, then ",
  StyleBox["MLGetInteger()", "MR"],
  " will fail, and return ",
  StyleBox["0", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can get arbitrary\[Hyphen]precision integers by \
first using ",
  StyleBox["IntegerDigits", "MR"],
  " to generate lists of digits, then calling ",
  StyleBox["MLGetIntegerList()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.105"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetShortInteger",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetLongInteger",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetIntegerArray()", "ObjectName",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetIntegerArray(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["dims", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["***", "MR"],
  StyleBox["heads", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["d", "TI"],
  StyleBox[")", "MR"],
  " gets an array of integers from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the array in ",
  StyleBox["a", "TI"],
  ", its dimensions in ",
  StyleBox["dims", "TI"],
  " and its depth in ",
  StyleBox["d", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] The array ",
  StyleBox["a", "TI"],
  " is laid out in memory like a C array declared as ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["a[m][n]", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  ". "
}], "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["heads", "TI"],
  " gives a list of character strings corresponding to the names of symbols \
that appear as heads at each level in the array. "
}], "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetIntegerArray()", "MR"],
  " allocates memory which must be disowned by calling ",
  StyleBox["MLDisownIntegerArray()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify the arrays \
generated by ",
  StyleBox["MLGetIntegerArray()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.162"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetIntegerList",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetIntegerList()", "ObjectName",
  CellTags->{"S1.1029", "MLGetIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetIntegerList(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " gets a list of integers from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the integers in the array ",
  StyleBox["a", "TI"],
  " and the length of the list in ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1029", "MLGetIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetIntegerList()", "MR"],
  " allocates memory for the array of integers. You must call ",
  StyleBox["MLDisownIntegerList()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify the array \
generated by ",
  StyleBox["MLGetIntegerList()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLGetInteger()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.146"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetIntegerArray",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetByteString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetLongInteger()", "ObjectName",
  CellTags->{"S1.1030", "MLGetLongInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetLongInteger(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["i", "TI"],
  StyleBox[")", "MR"],
  " gets an integer from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " and stores it as a C ",
  StyleBox["long", "MR"],
  " in ",
  StyleBox["i", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1030", "MLGetLongInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLGetInteger()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1030", "MLGetLongInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1030", "MLGetLongInteger"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetNext()", "ObjectName",
  CellTags->{"S1.1031", "MLGetNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetNext(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " goes to the next object on ",
  StyleBox["link", "TI"],
  " and returns its type. "
}], "Usage",
  CellTags->{"S1.1031", "MLGetNext"}],

Cell["\<\
\[FilledSmallSquare] The following values can be returned: \
\>", \
"Notes",
  CellTags->{"S1.1031", "MLGetNext"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLTKERR", "MR"],
              " "
            }]], Cell["error "]},
          {Cell[TextData[{
              StyleBox["MLTKINT", "MR"],
              " "
            }]], Cell["integer "]},
          {Cell[TextData[{
              StyleBox["MLTKFUNC", "MR"],
              " "
            }]], Cell["composite function "]},
          {Cell[TextData[{
              StyleBox["MLTKREAL", "MR"],
              " "
            }]], Cell["approximate real number "]},
          {Cell[TextData[{
              StyleBox["MLTKSTR", "MR"],
              " "
            }]], Cell["character string "]},
          {Cell[TextData[{
              StyleBox["MLTKSYM", "MR"],
              " "
            }]], Cell["symbol "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->{"MLGetNext", "S1.1031"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLTKINT", "MR"],
  " and ",
  StyleBox["MLTKREAL", "MR"],
  " do not necessarily signify numbers that can be stored in C ",
  StyleBox["int", "MR"],
  " and ",
  StyleBox["double", "MR"],
  " variables. "
}], "Notes",
  CellTags->{"S1.1031", "MLGetNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.52"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1031", "MLGetNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetArgCount",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1031", "MLGetNext"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetReal()", "ObjectName",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetReal(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["double", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["x", "TI"],
  StyleBox[")", "MR"],
  " gets a floating\[Hyphen]point number from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " and stores it in ",
  StyleBox["x", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the data on the link corresponds to an integer, ",
  StyleBox["MLGetReal()", "MR"],
  " will coerce it to a ",
  StyleBox["double", "MR"],
  " before storing it in ",
  StyleBox["x", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the data on the link corresponds to a number \
outside the range that can be stored in a C ",
  StyleBox["double", "MR"],
  " on your computer system, then ",
  StyleBox["MLGetReal()", "MR"],
  " will fail, and return ",
  StyleBox["0", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can get arbitrary\[Hyphen]precision real numbers \
by first using ",
  StyleBox["RealDigits", "MR"],
  " to generate lists of digits, then calling ",
  StyleBox["MLGetIntegerList()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetReal()", "MR"],
  " is normally equivalent to ",
  StyleBox["MLGetDouble()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.105"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetFloat",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetDouble",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetRealList",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1032", "MLGetReal"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetRealArray()", "ObjectName",
  CellTags->{"S1.1033", "MLGetRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetRealArray(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["double", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["dims", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["***", "MR"],
  StyleBox["heads", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["d", "TI"],
  StyleBox[")", "MR"],
  " gets an array of floating\[Hyphen]point numbers from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the array in ",
  StyleBox["a", "TI"],
  ", its dimensions in ",
  StyleBox["dims", "TI"],
  " and its depth in ",
  StyleBox["d", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1033", "MLGetRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] The array ",
  StyleBox["a", "TI"],
  " is laid out in memory like a C array declared as ",
  StyleBox["double", "MR"],
  " ",
  StyleBox["a[m][n]", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  ". "
}], "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["heads", "TI"],
  " gives a list of character strings corresponding to the names of symbols \
that appear as heads at each level in the array. "
}], "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetRealArray()", "MR"],
  " allocates memory which must be disowned by calling ",
  StyleBox["MLDisownRealArray()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify the arrays \
generated by ",
  StyleBox["MLGetRealArray()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.162"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetRealList()", "ObjectName",
  CellTags->{"S1.1034", "MLGetRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetRealList(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["double", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " gets a list of floating\[Hyphen]point numbers from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the numbers in the array ",
  StyleBox["a", "TI"],
  " and the length of the list in ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1034", "MLGetRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetRealList()", "MR"],
  " allocates memory for the array of numbers. You must call ",
  StyleBox["MLDisownRealList()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify the array \
generated by ",
  StyleBox["MLGetRealList()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLGetReal()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.146"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetShortInteger()", "ObjectName",
  CellTags->{"S1.1035", "MLGetShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetShortInteger(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["short", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["i", "TI"],
  StyleBox[")", "MR"],
  " gets an integer from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " and stores it as a C ",
  StyleBox["short", "MR"],
  " in ",
  StyleBox["i", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1035", "MLGetShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLGetInteger()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1035", "MLGetShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1035", "MLGetShortInteger"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetString()", "ObjectName",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetString(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  " gets a character string from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the string in ",
  StyleBox["s", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetString()", "MR"],
  " allocates memory for the character string. You must call ",
  StyleBox["MLDisownString()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify strings generated \
by ",
  StyleBox["MLGetString()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetString()", "MR"],
  " creates a string that is terminated by \[Backslash]",
  StyleBox["0", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetString()", "MR"],
  " stores single \[Backslash] characters from ",
  StyleBox["Mathematica", "TI"],
  " as pairs of characters \[Backslash]\[Backslash]. "
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetString()", "MR"],
  " stores special characters from ",
  StyleBox["Mathematica", "TI"],
  " in a private format. "
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetByteString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetUnicodeString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetSymbol()", "ObjectName",
  CellTags->{"S1.1037", "MLGetSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetSymbol(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  " gets a character string corresponding to the name of a symbol from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the resulting string in ",
  StyleBox["s", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1037", "MLGetSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetSymbol()", "MR"],
  " allocates memory for the character string. You must call ",
  StyleBox["MLDisownSymbol()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1037", "MLGetSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetSymbol()", "MR"],
  " creates a string that is terminated by \[Backslash]",
  StyleBox["0", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1037", "MLGetSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.166"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.52"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1037", "MLGetSymbol"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetUnicodeString()", "ObjectName",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLGetUnicodeString(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["unsigned", "MR"],
  " ",
  StyleBox["short", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " gets a character string from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the string in ",
  StyleBox["s", "TI"],
  " as a sequence of 16\[Hyphen]bit Unicode characters. "
}], "Usage",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetUnicodeString()", "MR"],
  " allocates memory for the character string. You must call ",
  StyleBox["MLDisownUnicodeString()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify strings generated \
by ",
  StyleBox["MLGetUnicodeString()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetUnicodeString()", "MR"],
  " stores all characters directly in 16\[Hyphen]bit Unicode form. "
}], "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell["\<\
\[FilledSmallSquare] 8\[Hyphen]bit ASCII characters are stored with \
a null high\[Hyphen]order byte. \
\>", "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetByteString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLInitialize()", "ObjectName",
  CellTags->{"S1.1039", "MLInitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLENV", "MR"],
  " ",
  StyleBox["MLInitialize(0)", "MR"],
  " initializes functions in the ",
  StyleBox["MathLink", "TI"],
  " library. "
}], "Usage",
  CellTags->{"S1.1039", "MLInitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] An appropriate call to ",
  StyleBox["MLInitialize()", "MR"],
  " is generated automatically when an external program is created from ",
  StyleBox["MathLink", "TI"],
  " templates. "
}], "Notes",
  CellTags->{"S1.1039", "MLInitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] Any external program that uses the ",
  StyleBox["MathLink", "TI"],
  " library must call ",
  StyleBox["MLInitialize()", "MR"],
  " before calling any other ",
  StyleBox["MathLink", "TI"],
  " library functions. "
}], "Notes",
  CellTags->{"S1.1039", "MLInitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1039", "MLInitialize"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLLoopbackOpen()", "ObjectName",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLINK", "MR"],
  " ",
  StyleBox["MLLoopbackOpen(MLENV", "MR"],
  " ",
  StyleBox["env", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["errno", "TI"],
  StyleBox[")", "MR"],
  " opens a loopback ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Usage",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],

Cell[TextData[{
  "\[FilledSmallSquare] In an external program set up with ",
  StyleBox["MathLink", "TI"],
  " templates, the environment ",
  StyleBox["stdenv", "MR"],
  " should be used. "
}], "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use loopback links to effectively store ",
  StyleBox["Mathematica", "TI"],
  " expressions in external programs. "
}], "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLCreateMark",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLMain()", "ObjectName",
  CellTags->{"S1.1041", "MLMain"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLMain(int", "MR"],
  " ",
  StyleBox["argc", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["argv", "TI"],
  StyleBox[")", "MR"],
  " sets up communication between an external program started using ",
  StyleBox["Install", "MR"],
  " and ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1041", "MLMain"}],

Cell[TextData[{
  "\[FilledSmallSquare] The code for ",
  StyleBox["MLMain()", "MR"],
  " is generated automatically by ",
  StyleBox["mprep", "MR"],
  " or ",
  StyleBox["mcc", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1041", "MLMain"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLMain()", "MR"],
  " opens a ",
  StyleBox["MathLink", "TI"],
  " connection using the parameters specified in ",
  StyleBox["argv", "TI"],
  ", then goes into a loop waiting for ",
  StyleBox["CallPacket", "MR"],
  " objects to arrive from ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1041", "MLMain"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLMain()", "MR"],
  " internally calls ",
  StyleBox["MLOpenArgv()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1041", "MLMain"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.3",
    ButtonData:>{"2.13.3", "3.70"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1041", "MLMain"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLNewPacket()", "ObjectName",
  CellTags->{"S1.1042", "MLNewPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLNewPacket(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " skips to the end of the current packet on ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1042", "MLNewPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLNewPacket()", "MR"],
  " works even if the head of the current top\[Hyphen]level expression is not \
a standard packet type. "
}], "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLNewPacket()", "MR"],
  " does nothing if you are already at the end of a packet. "
}], "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.13",
    ButtonData:>{"2.13.13", "13.3"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLNextPacket",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLNextPacket()", "ObjectName",
  CellTags->{"S1.1043", "MLNextPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLNextPacket(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " goes to the next packet on ",
  StyleBox["link", "TI"],
  " and returns a constant to indicate its head. "
}], "Usage",
  CellTags->{"S1.1043", "MLNextPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1043", "MLNextPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLNewPacket",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1043", "MLNextPacket"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLOpenArgv()", "ObjectName",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLINK", "MR"],
  " ",
  StyleBox["MLOpenArgv(MLENV", "MR"],
  " ",
  StyleBox["env", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["argv0", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["argv1", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["errno", "TI"],
  StyleBox[")", "MR"],
  " opens a ",
  StyleBox["MathLink", "TI"],
  " connection taking parameters from an ",
  StyleBox["argv", "MR"],
  " array. "
}], "Usage",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLInitialize()", "MR"],
  " must be called before ",
  StyleBox["MLOpenArgv()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLOpenArgv()", "MR"],
  " scans for the following at successive locations starting at ",
  StyleBox["argv0", "TI"],
  " and going up to just before ",
  StyleBox["argv1", "TI"],
  ": "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"-linkconnect\"", "MR"],
              " "
            }]], Cell[TextData[{
              "connect to an existing link (",
              StyleBox["LinkConnect", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["\"-linkcreate\"", "MR"],
              " "
            }]], Cell[TextData[{
              "create a link (",
              StyleBox["LinkCreate", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["\"-linklaunch\"", "MR"],
              " "
            }]], Cell[TextData[{
              "launch a child process (",
              StyleBox["LinkLaunch", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["\"-linkname\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["the name to use in opening the link "]},
          {Cell[TextData[{
              StyleBox["\"-linkprotocol\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["protocol", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell[TextData[{
              "the link protocol to use (",
              StyleBox["tcp", "MR"],
              ", ",
              StyleBox["pipes", "MR"],
              ", etc.) "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->{"MLOpenArgv", "S1.1044"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLOpenArgv()", "MR"],
  " is not sensitive to the case of argument names. "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLOpenArgv()", "MR"],
  " ignores argument names that it does not recognize. "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLOpenArgv()", "MR"],
  " is called automatically by the ",
  StyleBox["MLMain()", "MR"],
  " function created by ",
  StyleBox["mprep", "MR"],
  " and ",
  StyleBox["mcc", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] With a main program ",
  StyleBox["main(int", "MR"],
  " ",
  StyleBox["argc,", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*argv[])", "MR"],
  " typical usage is ",
  StyleBox["MLOpenArgv(", "MR"],
  StyleBox["env", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["argv,", "MR"],
  " ",
  StyleBox["argv+argc,", "MR"],
  " ",
  StyleBox["errno", "TI"],
  StyleBox[")", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] Avoiding an explicit ",
  StyleBox["argc", "MR"],
  " argument allows ",
  StyleBox["MLOpenArgv()", "MR"],
  " to work independent of the size of an ",
  StyleBox["int", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] On some computer systems, giving ",
  StyleBox["0", "MR"],
  " for ",
  StyleBox["argv0", "TI"],
  " and ",
  StyleBox["argv1", "TI"],
  " will cause arguments to be requested interactively, typically through a \
dialog box. "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLActivate",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLOpenString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLOpenString()", "ObjectName",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLINK", "MR"],
  " ",
  StyleBox["MLOpenString(MLENV", "MR"],
  " ",
  StyleBox["env", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["string", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["errno", "TI"],
  StyleBox[")", "MR"],
  " opens a ",
  StyleBox["MathLink", "TI"],
  " connection taking parameters from a character string. "
}], "Usage",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLInitialize()", "MR"],
  " must be called before ",
  StyleBox["MLOpenString()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLOpenString()", "MR"],
  " takes a single string instead of the ",
  StyleBox["argv", "TI"],
  " array used by ",
  StyleBox["MLOpenArgv()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell["\<\
\[FilledSmallSquare] Arguments in the string are separated by \
spaces. \
\>", "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell[TextData[{
  "\[FilledSmallSquare] On some computer systems, giving ",
  StyleBox["NULL", "MR"],
  " in place of the string pointer will cause arguments to be requested \
interactively, typically through a dialog box. "
}], "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLActivate",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLOpenArgv",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1045", "MLOpenString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutArgCount()", "ObjectName",
  CellTags->{"S1.1046", "MLPutArgCount"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutArgCount(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " specifies the number of arguments of a composite function to be put on ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1046", "MLPutArgCount"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutByteString()", "ObjectName",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutByteString(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["unsigned", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " puts a string of ",
  StyleBox["n", "TI"],
  " characters starting from location ",
  StyleBox["s", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] All characters in the string must be specified using \
character codes as obtained from ",
  StyleBox["ToCharacterCode", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] Newlines must thus be specified in terms of their raw \
character codes, rather than using \[Backslash]",
  StyleBox["n", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLPutByteString()", "MR"],
  " handles only characters with codes less than 256. "
}], "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell["\<\
\[FilledSmallSquare] It can handle both ordinary ASCII as well as \
ISO Latin\[Hyphen]1 characters. \
\>", "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutIntegerList",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutDouble()", "ObjectName",
  CellTags->{"S1.1048", "MLPutDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutDouble(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["double", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[")", "MR"],
  " puts the floating\[Hyphen]point number ",
  StyleBox["x", "TI"],
  " of C type ",
  StyleBox["double", "MR"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1048", "MLPutDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLPutReal()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1048", "MLPutDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1048", "MLPutDouble"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutFloat()", "ObjectName",
  CellTags->{"S1.1049", "MLPutFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutFloat(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["double", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[")", "MR"],
  " puts the floating\[Hyphen]point number ",
  StyleBox["x", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " with a precision corresponding to the C type ",
  StyleBox["float", "MR"],
  ". "
}], "Usage",
  CellTags->{"S1.1049", "MLPutFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] The argument ",
  StyleBox["x", "TI"],
  " is typically declared as ",
  StyleBox["float", "MR"],
  " in external programs, but must be declared as ",
  StyleBox["double", "MR"],
  " in ",
  StyleBox["MLPutFloat()", "MR"],
  " itself in order to work even in the absence of C prototypes. "
}], "Notes",
  CellTags->{"S1.1049", "MLPutFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLPutReal()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1049", "MLPutFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1049", "MLPutFloat"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutFunction()", "ObjectName",
  CellTags->{"S1.1050", "MLPutFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutFunction(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " puts a function with head given by a symbol with name ",
  StyleBox["s", "TI"],
  " and with ",
  StyleBox["n", "TI"],
  " arguments to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1050", "MLPutFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] After the call to ",
  StyleBox["MLPutFunction()", "MR"],
  " other ",
  StyleBox["MathLink", "TI"],
  " functions must be called to send the arguments of the function. "
}], "Notes",
  CellTags->{"S1.1050", "MLPutFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1050", "MLPutFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1050", "MLPutFunction"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutInteger()", "ObjectName",
  CellTags->{"S1.1051", "MLPutInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutInteger(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["i", "TI"],
  StyleBox[")", "MR"],
  " puts the integer ",
  StyleBox["i", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1051", "MLPutInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can send arbitrary\[Hyphen]precision integers to \
",
  StyleBox["Mathematica", "TI"],
  " by giving lists of digits, then converting them to numbers using ",
  StyleBox["FromDigits", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1051", "MLPutInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.64"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1051", "MLPutInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetInteger",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutShortInteger",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutLongInteger",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutIntegerList",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1051", "MLPutInteger"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutIntegerArray()", "ObjectName",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutIntegerArray(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["dims", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["heads", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["d", "TI"],
  StyleBox[")", "MR"],
  " puts an array of integers to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " to form a depth ",
  StyleBox["d", "TI"],
  " array with dimensions ",
  StyleBox["dims", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] The array ",
  StyleBox["a", "TI"],
  " must be laid out in memory like a C array declared explicitly as ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["a[m][n]", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  ". "
}], "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["heads", "TI"],
  " is given as ",
  StyleBox["NULL", "MR"],
  ", the array will be assumed to have head ",
  StyleBox["List", "MR"],
  " at every level. "
}], "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] The length of the array at level ",
  StyleBox["i", "TI"],
  " is taken to be ",
  StyleBox["dims[i]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutIntegerList",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutIntegerList()", "ObjectName",
  CellTags->{"S1.1053", "MLPutIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutIntegerList(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " puts a list of ",
  StyleBox["n", "TI"],
  " integers starting from location ",
  StyleBox["a", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1053", "MLPutIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1053", "MLPutIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutIntegerArray",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutByteString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1053", "MLPutIntegerList"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutLongInteger()", "ObjectName",
  CellTags->{"S1.1054", "MLPutLongInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutLongInteger(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["i", "TI"],
  StyleBox[")", "MR"],
  " puts the long integer ",
  StyleBox["i", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1054", "MLPutLongInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLPutInteger()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1054", "MLPutLongInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1054", "MLPutLongInteger"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutNext()", "ObjectName",
  CellTags->{"S1.1055", "MLPutNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutNext(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["type", "TI"],
  StyleBox[")", "MR"],
  " prepares to put an object of the specified type on ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1055", "MLPutNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] The type specifications are as given in the notes for \
",
  StyleBox["MLGetNext()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1055", "MLPutNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.64"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1055", "MLPutNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutArgCount",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1055", "MLPutNext"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutReal()", "ObjectName",
  CellTags->{"S1.1056", "MLPutReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutReal(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["double", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[")", "MR"],
  " puts the floating\[Hyphen]point number ",
  StyleBox["x", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1056", "MLPutReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can send arbitrary\[Hyphen]precision real numbers \
to ",
  StyleBox["Mathematica", "TI"],
  " by giving lists of digits, then converting them to numbers using ",
  StyleBox["FromDigits", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1056", "MLPutReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLPutReal()", "MR"],
  " is normally equivalent to ",
  StyleBox["MLPutDouble()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1056", "MLPutReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.64"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1056", "MLPutReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutRealList",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutFloat",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutDouble",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1056", "MLPutReal"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutRealArray()", "ObjectName",
  CellTags->{"S1.1057", "MLPutRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutRealArray(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["double", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["dims", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["**", "MR"],
  StyleBox["heads", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["d", "TI"],
  StyleBox[")", "MR"],
  " puts an array of floating\[Hyphen]point numbers to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " to form a depth ",
  StyleBox["d", "TI"],
  " array with dimensions ",
  StyleBox["dims", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1057", "MLPutRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] The array ",
  StyleBox["a", "TI"],
  " must be laid out in memory like a C array declared explicitly as ",
  StyleBox["double", "MR"],
  " ",
  StyleBox["a[m][n]", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  ". "
}], "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["heads", "TI"],
  " is given as ",
  StyleBox["NULL", "MR"],
  ", the array will be assumed to have head ",
  StyleBox["List", "MR"],
  " at every level. "
}], "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] The length of the array at level ",
  StyleBox["i", "TI"],
  " is taken to be ",
  StyleBox["dims[i]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutRealList",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutRealList()", "ObjectName",
  CellTags->{"S1.1058", "MLPutRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutRealList(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["double", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " puts a list of ",
  StyleBox["n", "TI"],
  " floating\[Hyphen]point numbers starting from location ",
  StyleBox["a", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1058", "MLPutRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1058", "MLPutRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutRealArray",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1058", "MLPutRealList"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutShortInteger()", "ObjectName",
  CellTags->{"S1.1059", "MLPutShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutShortInteger(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["i", "TI"],
  StyleBox[")", "MR"],
  " puts the integer ",
  StyleBox["i", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", assuming that ",
  StyleBox["i", "TI"],
  " contains only the number of digits in the C type ",
  StyleBox["short", "MR"],
  ". "
}], "Usage",
  CellTags->{"S1.1059", "MLPutShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] The argument ",
  StyleBox["i", "TI"],
  " is typically declared as ",
  StyleBox["short", "MR"],
  " in external programs, but must be declared as ",
  StyleBox["int", "MR"],
  " in ",
  StyleBox["MLPutShortInteger()", "MR"],
  " itself in order to work even in the absence of C prototypes. "
}], "Notes",
  CellTags->{"S1.1059", "MLPutShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLPutInteger()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1059", "MLPutShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1059", "MLPutShortInteger"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutString()", "ObjectName",
  CellTags->{"S1.1060", "MLPutString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutString(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  " puts a character string to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1060", "MLPutString"}],

Cell[TextData[{
  "\[FilledSmallSquare] The character string must be terminated with a null \
byte, corresponding to \[Backslash]",
  StyleBox["0", "MR"],
  " in C. "
}], "Notes",
  CellTags->{"S1.1060", "MLPutString"}],

Cell["\<\
\[FilledSmallSquare] A raw backslash in the string must be sent as \
two characters \[Backslash]\[Backslash]. \
\>", "Notes",
  CellTags->{"S1.1060", "MLPutString"}],

Cell[TextData[{
  "\[FilledSmallSquare] Special characters can be sent only using the private \
format returned by ",
  StyleBox["MLGetString()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1060", "MLPutString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1060", "MLPutString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutByteString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutUnicodeString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutSymbol",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1060", "MLPutString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutSymbol()", "ObjectName",
  CellTags->{"S1.1061", "MLPutSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutSymbol(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  " puts a symbol whose name is given by the character string ",
  StyleBox["s", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1061", "MLPutSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] The character string must be terminated with \
\[Backslash]",
  StyleBox["0", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1061", "MLPutSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.64"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1061", "MLPutSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1061", "MLPutSymbol"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutUnicodeString()", "ObjectName",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLPutUnicodeString(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["unsigned", "MR"],
  " ",
  StyleBox["short", "MR"],
  " ",
  StyleBox["*", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " puts a string of ",
  StyleBox["n", "TI"],
  " 16\[Hyphen]bit Unicode characters to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],

Cell["\<\
\[FilledSmallSquare] All characters are assumed to be 16 bit. \
\
\>", "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],

Cell["\<\
\[FilledSmallSquare] 8\[Hyphen]bit characters can be sent by having \
the higher\[Hyphen]order byte be null. \
\>", "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutByteString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLReady()", "ObjectName",
  CellTags->{"S1.1063", "MLReady"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLReady(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " tests whether there is data ready to be read from ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1063", "MLReady"}],

Cell[TextData[{
  "\[FilledSmallSquare] Analogous to the ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["LinkReadyQ", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1063", "MLReady"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLReady()", "MR"],
  " is often called in a loop as a way of polling a ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Notes",
  CellTags->{"S1.1063", "MLReady"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLReady()", "MR"],
  " will always return immediately, and will not block. "
}], "Notes",
  CellTags->{"S1.1063", "MLReady"}],

Cell[TextData[{
  "\[FilledSmallSquare] You need to call ",
  StyleBox["MLFlush()", "MR"],
  " before starting to call ",
  StyleBox["MLReady()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1063", "MLReady"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.29"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1063", "MLReady"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLSeekMark()", "ObjectName",
  CellTags->{"S1.1064", "MLSeekMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLMARK", "MR"],
  " ",
  StyleBox["MLSeekMark(MLINK", "MR"],
  " ",
  StyleBox["link", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["MLMARK", "MR"],
  " ",
  StyleBox["mark", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["long", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " goes back to a position ",
  StyleBox["n", "TI"],
  " expressions after the specified mark on a link. "
}], "Usage",
  CellTags->{"S1.1064", "MLSeekMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1064", "MLSeekMark"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLTransferExpression()", "ObjectName",
  CellTags->{"S1.1065", "MLTransferExpression"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLTransferExpression(MLINK", "MR"],
  " ",
  StyleBox["dest", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["MLINK", "MR"],
  " ",
  StyleBox["src", "TI"],
  StyleBox[")", "MR"],
  " transfers an expression from one ",
  StyleBox["MathLink", "TI"],
  " connection to another. "
}], "Usage",
  CellTags->{"S1.1065", "MLTransferExpression"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["src", "TI"],
  " and ",
  StyleBox["dest", "TI"],
  " need not be distinct. "
}], "Notes",
  CellTags->{"S1.1065", "MLTransferExpression"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["src", "TI"],
  " and ",
  StyleBox["dest", "TI"],
  " can be either loopback or ordinary links. "
}], "Notes",
  CellTags->{"S1.1065", "MLTransferExpression"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1065", "MLTransferExpression"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{200, Automatic}, {Automatic, 59}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.11.0"->{
    Cell[1776, 53, 180, 6, 91, "Section",
      CellTags->{"SA.11.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 180, 6, 91, "Section",
      CellTags->{"SA.11.0", "0.1"}]},
  "SA.11.1"->{
    Cell[1981, 63, 66, 1, 70, "Subsection",
      CellTags->{"SA.11.1", "1.1"}],
    Cell[2050, 66, 161, 5, 70, "Text",
      CellTags->{"SA.11.1", "1.2"}],
    Cell[2214, 73, 262, 7, 70, "Text",
      CellTags->{"SA.11.1", "1.3"}],
    Cell[2479, 82, 336, 13, 70, "Text",
      CellTags->{"SA.11.1", "1.4"}],
    Cell[2818, 97, 147, 5, 70, "Text",
      CellTags->{"SA.11.1", "1.5"}],
    Cell[2968, 104, 503, 19, 70, "Notes",
      CellTags->{"SA.11.1", "1.6"}],
    Cell[3474, 125, 171, 5, 70, "Text",
      CellTags->{"SA.11.1", "1.7"}],
    Cell[3648, 132, 528, 19, 70, "Notes",
      CellTags->{"SA.11.1", "1.8"}],
    Cell[4179, 153, 180, 4, 70, "Text",
      CellTags->{"SA.11.1", "1.9"}],
    Cell[4362, 159, 100, 1, 70, "Text",
      CellTags->{"SA.11.1", "1.10"}],
    Cell[4465, 162, 860, 18, 70, "Notes",
      CellTags->{"SA.11.1", "1.11"}]},
  "1.1"->{
    Cell[1981, 63, 66, 1, 70, "Subsection",
      CellTags->{"SA.11.1", "1.1"}]},
  "1.2"->{
    Cell[2050, 66, 161, 5, 70, "Text",
      CellTags->{"SA.11.1", "1.2"}]},
  "1.3"->{
    Cell[2214, 73, 262, 7, 70, "Text",
      CellTags->{"SA.11.1", "1.3"}]},
  "1.4"->{
    Cell[2479, 82, 336, 13, 70, "Text",
      CellTags->{"SA.11.1", "1.4"}]},
  "1.5"->{
    Cell[2818, 97, 147, 5, 70, "Text",
      CellTags->{"SA.11.1", "1.5"}]},
  "1.6"->{
    Cell[2968, 104, 503, 19, 70, "Notes",
      CellTags->{"SA.11.1", "1.6"}]},
  "1.7"->{
    Cell[3474, 125, 171, 5, 70, "Text",
      CellTags->{"SA.11.1", "1.7"}]},
  "1.8"->{
    Cell[3648, 132, 528, 19, 70, "Notes",
      CellTags->{"SA.11.1", "1.8"}]},
  "1.9"->{
    Cell[4179, 153, 180, 4, 70, "Text",
      CellTags->{"SA.11.1", "1.9"}]},
  "1.10"->{
    Cell[4362, 159, 100, 1, 70, "Text",
      CellTags->{"SA.11.1", "1.10"}]},
  "1.11"->{
    Cell[4465, 162, 860, 18, 70, "Notes",
      CellTags->{"SA.11.1", "1.11"}]},
  "S1.1001"->{
    Cell[5350, 184, 65, 1, 70, "ObjectName",
      CellTags->{"S1.1001", "MLAbort"}],
    Cell[5418, 187, 315, 11, 70, "Usage",
      CellTags->{"S1.1001", "MLAbort"}],
    Cell[5736, 200, 311, 9, 70, "Notes",
      CellTags->{"S1.1001", "MLAbort"}],
    Cell[6050, 211, 203, 7, 70, "Notes",
      CellTags->{"S1.1001", "MLAbort"}]},
  "MLAbort"->{
    Cell[5350, 184, 65, 1, 70, "ObjectName",
      CellTags->{"S1.1001", "MLAbort"}],
    Cell[5418, 187, 315, 11, 70, "Usage",
      CellTags->{"S1.1001", "MLAbort"}],
    Cell[5736, 200, 311, 9, 70, "Notes",
      CellTags->{"S1.1001", "MLAbort"}],
    Cell[6050, 211, 203, 7, 70, "Notes",
      CellTags->{"S1.1001", "MLAbort"}]},
  "S1.1002"->{
    Cell[6290, 223, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1002", "MLActivate"}],
    Cell[6366, 226, 340, 12, 70, "Usage",
      CellTags->{"S1.1002", "MLActivate"}],
    Cell[6709, 240, 247, 9, 70, "Notes",
      CellTags->{"S1.1002", "MLActivate"}],
    Cell[6959, 251, 206, 7, 70, "Notes",
      CellTags->{"S1.1002", "MLActivate"}]},
  "MLActivate"->{
    Cell[6290, 223, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1002", "MLActivate"}],
    Cell[6366, 226, 340, 12, 70, "Usage",
      CellTags->{"S1.1002", "MLActivate"}],
    Cell[6709, 240, 247, 9, 70, "Notes",
      CellTags->{"S1.1002", "MLActivate"}],
    Cell[6959, 251, 206, 7, 70, "Notes",
      CellTags->{"S1.1002", "MLActivate"}]},
  "S1.1003"->{
    Cell[7202, 263, 83, 1, 70, "ObjectName",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[7288, 266, 658, 27, 70, "Usage",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[7949, 295, 339, 10, 70, "Notes",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[8291, 307, 210, 7, 70, "Notes",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[8504, 316, 179, 6, 70, "Notes",
      CellTags->{"S1.1003", "MLCheckFunction"}]},
  "MLCheckFunction"->{
    Cell[7202, 263, 83, 1, 70, "ObjectName",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[7288, 266, 658, 27, 70, "Usage",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[7949, 295, 339, 10, 70, "Notes",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[8291, 307, 210, 7, 70, "Notes",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[8504, 316, 179, 6, 70, "Notes",
      CellTags->{"S1.1003", "MLCheckFunction"}]},
  "S1.1004"->{
    Cell[8720, 327, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1004", "MLClearError"}],
    Cell[8800, 330, 321, 12, 70, "Usage",
      CellTags->{"S1.1004", "MLClearError"}],
    Cell[9124, 344, 303, 8, 70, "Notes",
      CellTags->{"S1.1004", "MLClearError"}],
    Cell[9430, 354, 208, 7, 70, "Notes",
      CellTags->{"S1.1004", "MLClearError"}]},
  "MLClearError"->{
    Cell[8720, 327, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1004", "MLClearError"}],
    Cell[8800, 330, 321, 12, 70, "Usage",
      CellTags->{"S1.1004", "MLClearError"}],
    Cell[9124, 344, 303, 8, 70, "Notes",
      CellTags->{"S1.1004", "MLClearError"}],
    Cell[9430, 354, 208, 7, 70, "Notes",
      CellTags->{"S1.1004", "MLClearError"}]},
  "S1.1005"->{
    Cell[9675, 366, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[9745, 369, 279, 12, 70, "Usage",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10027, 383, 207, 5, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10237, 390, 182, 5, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10422, 397, 153, 4, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10578, 403, 334, 11, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10915, 416, 172, 6, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}]},
  "MLClose"->{
    Cell[9675, 366, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[9745, 369, 279, 12, 70, "Usage",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10027, 383, 207, 5, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10237, 390, 182, 5, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10422, 397, 153, 4, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10578, 403, 334, 11, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10915, 416, 172, 6, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}]},
  "S1.1006"->{
    Cell[11124, 427, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11204, 430, 314, 11, 70, "Usage",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11521, 443, 213, 5, 70, "Notes",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11737, 450, 209, 7, 70, "Notes",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11949, 459, 177, 6, 70, "Notes",
      CellTags->{"S1.1006", "MLCreateMark"}]},
  "MLCreateMark"->{
    Cell[11124, 427, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11204, 430, 314, 11, 70, "Usage",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11521, 443, 213, 5, 70, "Notes",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11737, 450, 209, 7, 70, "Notes",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11949, 459, 177, 6, 70, "Notes",
      CellTags->{"S1.1006", "MLCreateMark"}]},
  "S1.1007"->{
    Cell[12163, 470, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[12247, 473, 311, 12, 70, "Usage",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[12561, 487, 281, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[12845, 496, 248, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[13096, 505, 230, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[13329, 514, 210, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}]},
  "MLDeinitialize"->{
    Cell[12163, 470, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[12247, 473, 311, 12, 70, "Usage",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[12561, 487, 281, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[12845, 496, 248, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[13096, 505, 230, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[13329, 514, 210, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}]},
  "S1.1008"->{
    Cell[13576, 526, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1008", "MLDestroyMark"}],
    Cell[13658, 529, 362, 15, 70, "Usage",
      CellTags->{"S1.1008", "MLDestroyMark"}],
    Cell[14023, 546, 233, 6, 70, "Notes",
      CellTags->{"S1.1008", "MLDestroyMark"}],
    Cell[14259, 554, 210, 7, 70, "Notes",
      CellTags->{"S1.1008", "MLDestroyMark"}]},
  "MLDestroyMark"->{
    Cell[13576, 526, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1008", "MLDestroyMark"}],
    Cell[13658, 529, 362, 15, 70, "Usage",
      CellTags->{"S1.1008", "MLDestroyMark"}],
    Cell[14023, 546, 233, 6, 70, "Notes",
      CellTags->{"S1.1008", "MLDestroyMark"}],
    Cell[14259, 554, 210, 7, 70, "Notes",
      CellTags->{"S1.1008", "MLDestroyMark"}]},
  "S1.1009"->{
    Cell[14506, 566, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1009", "MLDisownByteString"}],
    Cell[14598, 569, 618, 27, 70, "Usage",
      CellTags->{"S1.1009", "MLDisownByteString"}],
    Cell[15219, 598, 212, 7, 70, "Notes",
      CellTags->{"S1.1009", "MLDisownByteString"}],
    Cell[15434, 607, 183, 6, 70, "Notes",
      CellTags->{"S1.1009", "MLDisownByteString"}]},
  "MLDisownByteString"->{
    Cell[14506, 566, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1009", "MLDisownByteString"}],
    Cell[14598, 569, 618, 27, 70, "Usage",
      CellTags->{"S1.1009", "MLDisownByteString"}],
    Cell[15219, 598, 212, 7, 70, "Notes",
      CellTags->{"S1.1009", "MLDisownByteString"}],
    Cell[15434, 607, 183, 6, 70, "Notes",
      CellTags->{"S1.1009", "MLDisownByteString"}]},
  "S1.1010"->{
    Cell[15654, 618, 93, 1, 70, "ObjectName",
      CellTags->{"S1.1010", "MLDisownIntegerArray"}],
    Cell[15750, 621, 890, 41, 70, "Usage",
      CellTags->{"S1.1010", "MLDisownIntegerArray"}],
    Cell[16643, 664, 215, 7, 70, "Notes",
      CellTags->{"S1.1010", "MLDisownIntegerArray"}]},
  "MLDisownIntegerArray"->{
    Cell[15654, 618, 93, 1, 70, "ObjectName",
      CellTags->{"S1.1010", "MLDisownIntegerArray"}],
    Cell[15750, 621, 890, 41, 70, "Usage",
      CellTags->{"S1.1010", "MLDisownIntegerArray"}],
    Cell[16643, 664, 215, 7, 70, "Notes",
      CellTags->{"S1.1010", "MLDisownIntegerArray"}]},
  "S1.1011"->{
    Cell[16895, 676, 91, 1, 70, "ObjectName",
      CellTags->{"S1.1011", "MLDisownIntegerList"}],
    Cell[16989, 679, 604, 27, 70, "Usage",
      CellTags->{"S1.1011", "MLDisownIntegerList"}],
    Cell[17596, 708, 214, 7, 70, "Notes",
      CellTags->{"S1.1011", "MLDisownIntegerList"}]},
  "MLDisownIntegerList"->{
    Cell[16895, 676, 91, 1, 70, "ObjectName",
      CellTags->{"S1.1011", "MLDisownIntegerList"}],
    Cell[16989, 679, 604, 27, 70, "Usage",
      CellTags->{"S1.1011", "MLDisownIntegerList"}],
    Cell[17596, 708, 214, 7, 70, "Notes",
      CellTags->{"S1.1011", "MLDisownIntegerList"}]},
  "S1.1012"->{
    Cell[17847, 720, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1012", "MLDisownRealArray"}],
    Cell[17937, 723, 884, 41, 70, "Usage",
      CellTags->{"S1.1012", "MLDisownRealArray"}],
    Cell[18824, 766, 212, 7, 70, "Notes",
      CellTags->{"S1.1012", "MLDisownRealArray"}]},
  "MLDisownRealArray"->{
    Cell[17847, 720, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1012", "MLDisownRealArray"}],
    Cell[17937, 723, 884, 41, 70, "Usage",
      CellTags->{"S1.1012", "MLDisownRealArray"}],
    Cell[18824, 766, 212, 7, 70, "Notes",
      CellTags->{"S1.1012", "MLDisownRealArray"}]},
  "S1.1013"->{
    Cell[19073, 778, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1013", "MLDisownRealList"}],
    Cell[19161, 781, 598, 27, 70, "Usage",
      CellTags->{"S1.1013", "MLDisownRealList"}],
    Cell[19762, 810, 211, 7, 70, "Notes",
      CellTags->{"S1.1013", "MLDisownRealList"}]},
  "MLDisownRealList"->{
    Cell[19073, 778, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1013", "MLDisownRealList"}],
    Cell[19161, 781, 598, 27, 70, "Usage",
      CellTags->{"S1.1013", "MLDisownRealList"}],
    Cell[19762, 810, 211, 7, 70, "Notes",
      CellTags->{"S1.1013", "MLDisownRealList"}]},
  "S1.1014"->{
    Cell[20010, 822, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1014", "MLDisownString"}],
    Cell[20094, 825, 475, 20, 70, "Usage",
      CellTags->{"S1.1014", "MLDisownString"}],
    Cell[20572, 847, 209, 7, 70, "Notes",
      CellTags->{"S1.1014", "MLDisownString"}],
    Cell[20784, 856, 186, 6, 70, "Notes",
      CellTags->{"S1.1014", "MLDisownString"}]},
  "MLDisownString"->{
    Cell[20010, 822, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1014", "MLDisownString"}],
    Cell[20094, 825, 475, 20, 70, "Usage",
      CellTags->{"S1.1014", "MLDisownString"}],
    Cell[20572, 847, 209, 7, 70, "Notes",
      CellTags->{"S1.1014", "MLDisownString"}],
    Cell[20784, 856, 186, 6, 70, "Notes",
      CellTags->{"S1.1014", "MLDisownString"}]},
  "S1.1015"->{
    Cell[21007, 867, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1015", "MLDisownSymbol"}],
    Cell[21091, 870, 560, 22, 70, "Usage",
      CellTags->{"S1.1015", "MLDisownSymbol"}],
    Cell[21654, 894, 339, 11, 70, "Notes",
      CellTags->{"S1.1015", "MLDisownSymbol"}]},
  "MLDisownSymbol"->{
    Cell[21007, 867, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1015", "MLDisownSymbol"}],
    Cell[21091, 870, 560, 22, 70, "Usage",
      CellTags->{"S1.1015", "MLDisownSymbol"}],
    Cell[21654, 894, 339, 11, 70, "Notes",
      CellTags->{"S1.1015", "MLDisownSymbol"}]},
  "S1.1016"->{
    Cell[22030, 910, 95, 1, 70, "ObjectName",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}],
    Cell[22128, 913, 610, 27, 70, "Usage",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}],
    Cell[22741, 942, 215, 7, 70, "Notes",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}],
    Cell[22959, 951, 186, 6, 70, "Notes",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}]},
  "MLDisownUnicodeString"->{
    Cell[22030, 910, 95, 1, 70, "ObjectName",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}],
    Cell[22128, 913, 610, 27, 70, "Usage",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}],
    Cell[22741, 942, 215, 7, 70, "Notes",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}],
    Cell[22959, 951, 186, 6, 70, "Notes",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}]},
  "S1.1017"->{
    Cell[23182, 962, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1017", "MLEndPacket"}],
    Cell[23260, 965, 324, 11, 70, "Usage",
      CellTags->{"S1.1017", "MLEndPacket"}],
    Cell[23587, 978, 265, 6, 70, "Notes",
      CellTags->{"S1.1017", "MLEndPacket"}],
    Cell[23855, 986, 337, 11, 70, "Notes",
      CellTags->{"S1.1017", "MLEndPacket"}]},
  "MLEndPacket"->{
    Cell[23182, 962, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1017", "MLEndPacket"}],
    Cell[23260, 965, 324, 11, 70, "Usage",
      CellTags->{"S1.1017", "MLEndPacket"}],
    Cell[23587, 978, 265, 6, 70, "Notes",
      CellTags->{"S1.1017", "MLEndPacket"}],
    Cell[23855, 986, 337, 11, 70, "Notes",
      CellTags->{"S1.1017", "MLEndPacket"}]},
  "S1.1018"->{
    Cell[24229, 1002, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1018", "MLError"}],
    Cell[24299, 1005, 438, 16, 70, "Usage",
      CellTags->{"S1.1018", "MLError"}],
    Cell[24740, 1023, 193, 6, 70, "Notes",
      CellTags->{"S1.1018", "MLError"}],
    Cell[24936, 1031, 225, 7, 70, "Notes",
      CellTags->{"S1.1018", "MLError"}],
    Cell[25164, 1040, 203, 7, 70, "Notes",
      CellTags->{"S1.1018", "MLError"}]},
  "MLError"->{
    Cell[24229, 1002, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1018", "MLError"}],
    Cell[24299, 1005, 438, 16, 70, "Usage",
      CellTags->{"S1.1018", "MLError"}],
    Cell[24740, 1023, 193, 6, 70, "Notes",
      CellTags->{"S1.1018", "MLError"}],
    Cell[24936, 1031, 225, 7, 70, "Notes",
      CellTags->{"S1.1018", "MLError"}],
    Cell[25164, 1040, 203, 7, 70, "Notes",
      CellTags->{"S1.1018", "MLError"}]},
  "S1.1019"->{
    Cell[25404, 1052, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1019", "MLErrorMessage"}],
    Cell[25488, 1055, 335, 12, 70, "Usage",
      CellTags->{"S1.1019", "MLErrorMessage"}],
    Cell[25826, 1069, 210, 7, 70, "Notes",
      CellTags->{"S1.1019", "MLErrorMessage"}]},
  "MLErrorMessage"->{
    Cell[25404, 1052, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1019", "MLErrorMessage"}],
    Cell[25488, 1055, 335, 12, 70, "Usage",
      CellTags->{"S1.1019", "MLErrorMessage"}],
    Cell[25826, 1069, 210, 7, 70, "Notes",
      CellTags->{"S1.1019", "MLErrorMessage"}]},
  "S1.1020"->{
    Cell[26073, 1081, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[26161, 1084, 469, 18, 70, "Usage",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[26633, 1104, 398, 13, 70, "Notes",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[27034, 1119, 384, 12, 70, "Notes",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[27421, 1133, 339, 11, 70, "Notes",
      CellTags->{"S1.1020", "MLEvaluateString"}]},
  "MLEvaluateString"->{
    Cell[26073, 1081, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[26161, 1084, 469, 18, 70, "Usage",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[26633, 1104, 398, 13, 70, "Notes",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[27034, 1119, 384, 12, 70, "Notes",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[27421, 1133, 339, 11, 70, "Notes",
      CellTags->{"S1.1020", "MLEvaluateString"}]},
  "S1.1021"->{
    Cell[27797, 1149, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[27867, 1152, 316, 12, 70, "Usage",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[28186, 1166, 280, 9, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[28469, 1177, 276, 8, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[28748, 1187, 204, 7, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[28955, 1196, 165, 6, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}]},
  "MLFlush"->{
    Cell[27797, 1149, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[27867, 1152, 316, 12, 70, "Usage",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[28186, 1166, 280, 9, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[28469, 1177, 276, 8, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[28748, 1187, 204, 7, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[28955, 1196, 165, 6, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}]},
  "S1.1022"->{
    Cell[29157, 1207, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1022", "MLGetArgCount"}],
    Cell[29239, 1210, 477, 20, 70, "Usage",
      CellTags->{"S1.1022", "MLGetArgCount"}],
    Cell[29719, 1232, 210, 7, 70, "Notes",
      CellTags->{"S1.1022", "MLGetArgCount"}]},
  "MLGetArgCount"->{
    Cell[29157, 1207, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1022", "MLGetArgCount"}],
    Cell[29239, 1210, 477, 20, 70, "Usage",
      CellTags->{"S1.1022", "MLGetArgCount"}],
    Cell[29719, 1232, 210, 7, 70, "Notes",
      CellTags->{"S1.1022", "MLGetArgCount"}]},
  "S1.1023"->{
    Cell[29966, 1244, 83, 1, 70, "ObjectName",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[30052, 1247, 995, 41, 70, "Usage",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[31050, 1290, 281, 7, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[31334, 1299, 207, 5, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[31544, 1306, 293, 9, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[31840, 1317, 215, 5, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[32058, 1324, 242, 6, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[32303, 1332, 209, 7, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[32515, 1341, 253, 9, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}]},
  "MLGetByteString"->{
    Cell[29966, 1244, 83, 1, 70, "ObjectName",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[30052, 1247, 995, 41, 70, "Usage",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[31050, 1290, 281, 7, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[31334, 1299, 207, 5, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[31544, 1306, 293, 9, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[31840, 1317, 215, 5, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[32058, 1324, 242, 6, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[32303, 1332, 209, 7, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[32515, 1341, 253, 9, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}]},
  "S1.1024"->{
    Cell[32805, 1355, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[32883, 1358, 572, 24, 70, "Usage",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[33458, 1384, 203, 7, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[33664, 1393, 149, 5, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[33816, 1400, 204, 7, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[34023, 1409, 172, 6, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}]},
  "MLGetDouble"->{
    Cell[32805, 1355, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[32883, 1358, 572, 24, 70, "Usage",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[33458, 1384, 203, 7, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[33664, 1393, 149, 5, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[33816, 1400, 204, 7, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[34023, 1409, 172, 6, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}]},
  "S1.1025"->{
    Cell[34232, 1420, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1025", "MLGetFloat"}],
    Cell[34308, 1423, 568, 24, 70, "Usage",
      CellTags->{"S1.1025", "MLGetFloat"}],
    Cell[34879, 1449, 148, 5, 70, "Notes",
      CellTags->{"S1.1025", "MLGetFloat"}],
    Cell[35030, 1456, 203, 7, 70, "Notes",
      CellTags->{"S1.1025", "MLGetFloat"}]},
  "MLGetFloat"->{
    Cell[34232, 1420, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1025", "MLGetFloat"}],
    Cell[34308, 1423, 568, 24, 70, "Usage",
      CellTags->{"S1.1025", "MLGetFloat"}],
    Cell[34879, 1449, 148, 5, 70, "Notes",
      CellTags->{"S1.1025", "MLGetFloat"}],
    Cell[35030, 1456, 203, 7, 70, "Notes",
      CellTags->{"S1.1025", "MLGetFloat"}]},
  "S1.1026"->{
    Cell[35270, 1468, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[35352, 1471, 737, 30, 70, "Usage",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[36092, 1503, 321, 8, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[36416, 1513, 186, 6, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[36605, 1521, 788, 35, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[37396, 1558, 208, 7, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[37607, 1567, 173, 6, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}]},
  "MLGetFunction"->{
    Cell[35270, 1468, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[35352, 1471, 737, 30, 70, "Usage",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[36092, 1503, 321, 8, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[36416, 1513, 186, 6, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[36605, 1521, 788, 35, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[37396, 1558, 208, 7, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[37607, 1567, 173, 6, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}]},
  "S1.1027"->{
    Cell[37817, 1578, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[37897, 1581, 505, 22, 70, "Usage",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[38405, 1605, 223, 6, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[38631, 1613, 331, 10, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[38965, 1625, 293, 8, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[39261, 1635, 207, 7, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[39471, 1644, 254, 9, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}]},
  "MLGetInteger"->{
    Cell[37817, 1578, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[37897, 1581, 505, 22, 70, "Usage",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[38405, 1605, 223, 6, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[38631, 1613, 331, 10, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[38965, 1625, 293, 8, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[39261, 1635, 207, 7, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[39471, 1644, 254, 9, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}]},
  "S1.1028"->{
    Cell[39762, 1658, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[39852, 1661, 967, 44, 70, "Usage",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[40822, 1707, 289, 12, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[41114, 1721, 257, 6, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[41374, 1729, 251, 7, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[41628, 1738, 211, 6, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[41842, 1746, 212, 7, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[42057, 1755, 184, 6, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}]},
  "MLGetIntegerArray"->{
    Cell[39762, 1658, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[39852, 1661, 967, 44, 70, "Usage",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[40822, 1707, 289, 12, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[41114, 1721, 257, 6, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[41374, 1729, 251, 7, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[41628, 1738, 211, 6, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[41842, 1746, 212, 7, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[42057, 1755, 184, 6, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}]},
  "S1.1029"->{
    Cell[42278, 1766, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[42366, 1769, 709, 30, 70, "Usage",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[43078, 1801, 277, 7, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[43358, 1810, 208, 6, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[43569, 1818, 157, 5, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[43729, 1825, 211, 7, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[43943, 1834, 257, 9, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}]},
  "MLGetIntegerList"->{
    Cell[42278, 1766, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[42366, 1769, 709, 30, 70, "Usage",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[43078, 1801, 277, 7, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[43358, 1810, 208, 6, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[43569, 1818, 157, 5, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[43729, 1825, 211, 7, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[43943, 1834, 257, 9, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}]},
  "S1.1030"->{
    Cell[44237, 1848, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1030", "MLGetLongInteger"}],
    Cell[44325, 1851, 554, 24, 70, "Usage",
      CellTags->{"S1.1030", "MLGetLongInteger"}],
    Cell[44882, 1877, 157, 5, 70, "Notes",
      CellTags->{"S1.1030", "MLGetLongInteger"}],
    Cell[45042, 1884, 209, 7, 70, "Notes",
      CellTags->{"S1.1030", "MLGetLongInteger"}]},
  "MLGetLongInteger"->{
    Cell[44237, 1848, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1030", "MLGetLongInteger"}],
    Cell[44325, 1851, 554, 24, 70, "Usage",
      CellTags->{"S1.1030", "MLGetLongInteger"}],
    Cell[44882, 1877, 157, 5, 70, "Notes",
      CellTags->{"S1.1030", "MLGetLongInteger"}],
    Cell[45042, 1884, 209, 7, 70, "Notes",
      CellTags->{"S1.1030", "MLGetLongInteger"}]},
  "S1.1031"->{
    Cell[45288, 1896, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[45362, 1899, 306, 12, 70, "Usage",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[45671, 1913, 124, 4, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[45798, 1919, 922, 28, 70, "2ColumnTable",
      CellTags->{"MLGetNext", "S1.1031"}],
    Cell[46723, 1949, 310, 11, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[47036, 1962, 206, 7, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[47245, 1971, 173, 6, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}]},
  "MLGetNext"->{
    Cell[45288, 1896, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[45362, 1899, 306, 12, 70, "Usage",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[45671, 1913, 124, 4, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[45798, 1919, 922, 28, 70, "2ColumnTable",
      CellTags->{"MLGetNext", "S1.1031"}],
    Cell[46723, 1949, 310, 11, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[47036, 1962, 206, 7, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[47245, 1971, 173, 6, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}]},
  "S1.1032"->{
    Cell[47455, 1982, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[47529, 1985, 523, 22, 70, "Usage",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[48055, 2009, 290, 9, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[48348, 2020, 344, 10, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[48695, 2032, 291, 8, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[48989, 2042, 201, 7, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[49193, 2051, 204, 7, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[49400, 2060, 310, 12, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}]},
  "MLGetReal"->{
    Cell[47455, 1982, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[47529, 1985, 523, 22, 70, "Usage",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[48055, 2009, 290, 9, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[48348, 2020, 344, 10, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[48695, 2032, 291, 8, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[48989, 2042, 201, 7, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[49193, 2051, 204, 7, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[49400, 2060, 310, 12, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}]},
  "S1.1033"->{
    Cell[49747, 2077, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[49831, 2080, 986, 44, 70, "Usage",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[50820, 2126, 289, 12, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[51112, 2140, 254, 6, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[51369, 2148, 242, 7, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[51614, 2157, 205, 6, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[51822, 2165, 209, 7, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}]},
  "MLGetRealArray"->{
    Cell[49747, 2077, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[49831, 2080, 986, 44, 70, "Usage",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[50820, 2126, 289, 12, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[51112, 2140, 254, 6, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[51369, 2148, 242, 7, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[51614, 2157, 205, 6, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[51822, 2165, 209, 7, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}]},
  "S1.1034"->{
    Cell[52068, 2177, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[52150, 2180, 727, 30, 70, "Usage",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[52880, 2212, 267, 7, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[53150, 2221, 202, 6, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[53355, 2229, 151, 5, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[53509, 2236, 208, 7, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}]},
  "MLGetRealList"->{
    Cell[52068, 2177, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[52150, 2180, 727, 30, 70, "Usage",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[52880, 2212, 267, 7, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[53150, 2221, 202, 6, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[53355, 2229, 151, 5, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[53509, 2236, 208, 7, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}]},
  "S1.1035"->{
    Cell[53754, 2248, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1035", "MLGetShortInteger"}],
    Cell[53844, 2251, 558, 24, 70, "Usage",
      CellTags->{"S1.1035", "MLGetShortInteger"}],
    Cell[54405, 2277, 158, 5, 70, "Notes",
      CellTags->{"S1.1035", "MLGetShortInteger"}],
    Cell[54566, 2284, 210, 7, 70, "Notes",
      CellTags->{"S1.1035", "MLGetShortInteger"}]},
  "MLGetShortInteger"->{
    Cell[53754, 2248, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1035", "MLGetShortInteger"}],
    Cell[53844, 2251, 558, 24, 70, "Usage",
      CellTags->{"S1.1035", "MLGetShortInteger"}],
    Cell[54405, 2277, 158, 5, 70, "Notes",
      CellTags->{"S1.1035", "MLGetShortInteger"}],
    Cell[54566, 2284, 210, 7, 70, "Notes",
      CellTags->{"S1.1035", "MLGetShortInteger"}]},
  "S1.1036"->{
    Cell[54813, 2296, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[54891, 2299, 519, 22, 70, "Usage",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[55413, 2323, 261, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[55677, 2332, 196, 6, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[55876, 2340, 218, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[56097, 2349, 268, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[56368, 2358, 228, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[56599, 2367, 205, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[56807, 2376, 253, 9, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}]},
  "MLGetString"->{
    Cell[54813, 2296, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[54891, 2299, 519, 22, 70, "Usage",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[55413, 2323, 261, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[55677, 2332, 196, 6, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[55876, 2340, 218, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[56097, 2349, 268, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[56368, 2358, 228, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[56599, 2367, 205, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[56807, 2376, 253, 9, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}]},
  "S1.1037"->{
    Cell[57097, 2390, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[57175, 2393, 567, 22, 70, "Usage",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[57745, 2417, 261, 7, 70, "Notes",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[58009, 2426, 218, 7, 70, "Notes",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[58230, 2435, 338, 11, 70, "Notes",
      CellTags->{"S1.1037", "MLGetSymbol"}]},
  "MLGetSymbol"->{
    Cell[57097, 2390, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[57175, 2393, 567, 22, 70, "Usage",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[57745, 2417, 261, 7, 70, "Notes",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[58009, 2426, 218, 7, 70, "Notes",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[58230, 2435, 338, 11, 70, "Notes",
      CellTags->{"S1.1037", "MLGetSymbol"}]},
  "S1.1038"->{
    Cell[58605, 2451, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[58697, 2454, 731, 30, 70, "Usage",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[59431, 2486, 282, 7, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[59716, 2495, 210, 6, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[59929, 2503, 213, 5, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[60145, 2510, 174, 4, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[60322, 2516, 212, 7, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[60537, 2525, 253, 9, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}]},
  "MLGetUnicodeString"->{
    Cell[58605, 2451, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[58697, 2454, 731, 30, 70, "Usage",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[59431, 2486, 282, 7, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[59716, 2495, 210, 6, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[59929, 2503, 213, 5, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[60145, 2510, 174, 4, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[60322, 2516, 212, 7, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[60537, 2525, 253, 9, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}]},
  "S1.1039"->{
    Cell[60827, 2539, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[60907, 2542, 248, 9, 70, "Usage",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[61158, 2553, 277, 7, 70, "Notes",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[61438, 2562, 309, 9, 70, "Notes",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[61750, 2573, 208, 7, 70, "Notes",
      CellTags->{"S1.1039", "MLInitialize"}]},
  "MLInitialize"->{
    Cell[60827, 2539, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[60907, 2542, 248, 9, 70, "Usage",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[61158, 2553, 277, 7, 70, "Notes",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[61438, 2562, 309, 9, 70, "Notes",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[61750, 2573, 208, 7, 70, "Notes",
      CellTags->{"S1.1039", "MLInitialize"}]},
  "S1.1040"->{
    Cell[61995, 2585, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[62079, 2588, 414, 18, 70, "Usage",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[62496, 2608, 247, 7, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[62746, 2617, 219, 5, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[62968, 2624, 210, 7, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[63181, 2633, 177, 6, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}]},
  "MLLoopbackOpen"->{
    Cell[61995, 2585, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[62079, 2588, 414, 18, 70, "Usage",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[62496, 2608, 247, 7, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[62746, 2617, 219, 5, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[62968, 2624, 210, 7, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[63181, 2633, 177, 6, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}]},
  "S1.1041"->{
    Cell[63395, 2644, 65, 1, 70, "ObjectName",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[63463, 2647, 474, 20, 70, "Usage",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[63940, 2669, 239, 9, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[64182, 2680, 387, 13, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[64572, 2695, 185, 7, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[64760, 2704, 200, 7, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}]},
  "MLMain"->{
    Cell[63395, 2644, 65, 1, 70, "ObjectName",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[63463, 2647, 474, 20, 70, "Usage",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[63940, 2669, 239, 9, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[64182, 2680, 387, 13, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[64572, 2695, 185, 7, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[64760, 2704, 200, 7, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}]},
  "S1.1042"->{
    Cell[64997, 2716, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[65075, 2719, 304, 12, 70, "Usage",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[65382, 2733, 236, 6, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[65621, 2741, 192, 5, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[65816, 2748, 339, 11, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[66158, 2761, 174, 6, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}]},
  "MLNewPacket"->{
    Cell[64997, 2716, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[65075, 2719, 304, 12, 70, "Usage",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[65382, 2733, 236, 6, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[65621, 2741, 192, 5, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[65816, 2748, 339, 11, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[66158, 2761, 174, 6, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}]},
  "S1.1043"->{
    Cell[66369, 2772, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1043", "MLNextPacket"}],
    Cell[66449, 2775, 335, 12, 70, "Usage",
      CellTags->{"S1.1043", "MLNextPacket"}],
    Cell[66787, 2789, 209, 7, 70, "Notes",
      CellTags->{"S1.1043", "MLNextPacket"}],
    Cell[66999, 2798, 174, 6, 70, "Notes",
      CellTags->{"S1.1043", "MLNextPacket"}]},
  "MLNextPacket"->{
    Cell[66369, 2772, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1043", "MLNextPacket"}],
    Cell[66449, 2775, 335, 12, 70, "Usage",
      CellTags->{"S1.1043", "MLNextPacket"}],
    Cell[66787, 2789, 209, 7, 70, "Notes",
      CellTags->{"S1.1043", "MLNextPacket"}],
    Cell[66999, 2798, 174, 6, 70, "Notes",
      CellTags->{"S1.1043", "MLNextPacket"}]},
  "S1.1044"->{
    Cell[67210, 2809, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[67286, 2812, 690, 32, 70, "Usage",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[67979, 2846, 200, 7, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[68182, 2855, 291, 9, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[68476, 2866, 1636, 50, 70, "2ColumnTable",
      CellTags->{"MLOpenArgv", "S1.1044"}],
    Cell[70115, 2918, 182, 5, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[70300, 2925, 185, 5, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[70488, 2932, 293, 11, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[70784, 2945, 490, 22, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[71277, 2969, 275, 9, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[71555, 2980, 318, 10, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[71876, 2992, 206, 7, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[72085, 3001, 241, 9, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}]},
  "MLOpenArgv"->{
    Cell[67210, 2809, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[67286, 2812, 690, 32, 70, "Usage",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[67979, 2846, 200, 7, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[68182, 2855, 291, 9, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[68476, 2866, 1636, 50, 70, "2ColumnTable",
      CellTags->{"MLOpenArgv", "S1.1044"}],
    Cell[70115, 2918, 182, 5, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[70300, 2925, 185, 5, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[70488, 2932, 293, 11, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[70784, 2945, 490, 22, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[71277, 2969, 275, 9, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[71555, 2980, 318, 10, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[71876, 2992, 206, 7, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[72085, 3001, 241, 9, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}]},
  "S1.1045"->{
    Cell[72363, 3015, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[72443, 3018, 557, 24, 70, "Usage",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[73003, 3044, 204, 7, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[73210, 3053, 264, 9, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[73477, 3064, 138, 4, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[73618, 3070, 278, 6, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[73899, 3078, 208, 7, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[74110, 3087, 241, 9, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}]},
  "MLOpenString"->{
    Cell[72363, 3015, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[72443, 3018, 557, 24, 70, "Usage",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[73003, 3044, 204, 7, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[73210, 3053, 264, 9, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[73477, 3064, 138, 4, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[73618, 3070, 278, 6, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[73899, 3078, 208, 7, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[74110, 3087, 241, 9, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}]},
  "S1.1046"->{
    Cell[74388, 3101, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1046", "MLPutArgCount"}],
    Cell[74470, 3104, 423, 17, 70, "Usage",
      CellTags->{"S1.1046", "MLPutArgCount"}]},
  "MLPutArgCount"->{
    Cell[74388, 3101, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1046", "MLPutArgCount"}],
    Cell[74470, 3104, 423, 17, 70, "Usage",
      CellTags->{"S1.1046", "MLPutArgCount"}]},
  "S1.1047"->{
    Cell[74930, 3126, 83, 1, 70, "ObjectName",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[75016, 3129, 681, 31, 70, "Usage",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[75700, 3162, 274, 8, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[75977, 3172, 232, 6, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[76212, 3180, 194, 5, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[76409, 3187, 169, 4, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[76581, 3193, 209, 7, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[76793, 3202, 251, 9, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}]},
  "MLPutByteString"->{
    Cell[74930, 3126, 83, 1, 70, "ObjectName",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[75016, 3129, 681, 31, 70, "Usage",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[75700, 3162, 274, 8, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[75977, 3172, 232, 6, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[76212, 3180, 194, 5, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[76409, 3187, 169, 4, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[76581, 3193, 209, 7, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[76793, 3202, 251, 9, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}]},
  "S1.1048"->{
    Cell[77081, 3216, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1048", "MLPutDouble"}],
    Cell[77159, 3219, 532, 23, 70, "Usage",
      CellTags->{"S1.1048", "MLPutDouble"}],
    Cell[77694, 3244, 149, 5, 70, "Notes",
      CellTags->{"S1.1048", "MLPutDouble"}],
    Cell[77846, 3251, 204, 7, 70, "Notes",
      CellTags->{"S1.1048", "MLPutDouble"}]},
  "MLPutDouble"->{
    Cell[77081, 3216, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1048", "MLPutDouble"}],
    Cell[77159, 3219, 532, 23, 70, "Usage",
      CellTags->{"S1.1048", "MLPutDouble"}],
    Cell[77694, 3244, 149, 5, 70, "Notes",
      CellTags->{"S1.1048", "MLPutDouble"}],
    Cell[77846, 3251, 204, 7, 70, "Notes",
      CellTags->{"S1.1048", "MLPutDouble"}]},
  "S1.1049"->{
    Cell[78087, 3263, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[78163, 3266, 564, 23, 70, "Usage",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[78730, 3291, 381, 11, 70, "Notes",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[79114, 3304, 148, 5, 70, "Notes",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[79265, 3311, 203, 7, 70, "Notes",
      CellTags->{"S1.1049", "MLPutFloat"}]},
  "MLPutFloat"->{
    Cell[78087, 3263, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[78163, 3266, 564, 23, 70, "Usage",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[78730, 3291, 381, 11, 70, "Notes",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[79114, 3304, 148, 5, 70, "Notes",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[79265, 3311, 203, 7, 70, "Notes",
      CellTags->{"S1.1049", "MLPutFloat"}]},
  "S1.1050"->{
    Cell[79505, 3323, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[79587, 3326, 662, 29, 70, "Usage",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[80252, 3357, 265, 7, 70, "Notes",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[80520, 3366, 207, 7, 70, "Notes",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[80730, 3375, 175, 6, 70, "Notes",
      CellTags->{"S1.1050", "MLPutFunction"}]},
  "MLPutFunction"->{
    Cell[79505, 3323, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[79587, 3326, 662, 29, 70, "Usage",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[80252, 3357, 265, 7, 70, "Notes",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[80520, 3366, 207, 7, 70, "Notes",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[80730, 3375, 175, 6, 70, "Notes",
      CellTags->{"S1.1050", "MLPutFunction"}]},
  "S1.1051"->{
    Cell[80942, 3386, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[81022, 3389, 464, 21, 70, "Usage",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[81489, 3412, 295, 8, 70, "Notes",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[81787, 3422, 338, 11, 70, "Notes",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[82128, 3435, 398, 15, 70, "Notes",
      CellTags->{"S1.1051", "MLPutInteger"}]},
  "MLPutInteger"->{
    Cell[80942, 3386, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[81022, 3389, 464, 21, 70, "Usage",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[81489, 3412, 295, 8, 70, "Notes",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[81787, 3422, 338, 11, 70, "Notes",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[82128, 3435, 398, 15, 70, "Notes",
      CellTags->{"S1.1051", "MLPutInteger"}]},
  "S1.1052"->{
    Cell[82563, 3455, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[82653, 3458, 889, 41, 70, "Usage",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[83545, 3501, 305, 12, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[83853, 3515, 271, 9, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[84127, 3526, 215, 7, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[84345, 3535, 211, 7, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[84559, 3544, 184, 6, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}]},
  "MLPutIntegerArray"->{
    Cell[82563, 3455, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[82653, 3458, 889, 41, 70, "Usage",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[83545, 3501, 305, 12, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[83853, 3515, 271, 9, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[84127, 3526, 215, 7, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[84345, 3535, 211, 7, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[84559, 3544, 184, 6, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}]},
  "S1.1053"->{
    Cell[84780, 3555, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1053", "MLPutIntegerList"}],
    Cell[84868, 3558, 641, 29, 70, "Usage",
      CellTags->{"S1.1053", "MLPutIntegerList"}],
    Cell[85512, 3589, 210, 7, 70, "Notes",
      CellTags->{"S1.1053", "MLPutIntegerList"}],
    Cell[85725, 3598, 257, 9, 70, "Notes",
      CellTags->{"S1.1053", "MLPutIntegerList"}]},
  "MLPutIntegerList"->{
    Cell[84780, 3555, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1053", "MLPutIntegerList"}],
    Cell[84868, 3558, 641, 29, 70, "Usage",
      CellTags->{"S1.1053", "MLPutIntegerList"}],
    Cell[85512, 3589, 210, 7, 70, "Notes",
      CellTags->{"S1.1053", "MLPutIntegerList"}],
    Cell[85725, 3598, 257, 9, 70, "Notes",
      CellTags->{"S1.1053", "MLPutIntegerList"}]},
  "S1.1054"->{
    Cell[86019, 3612, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1054", "MLPutLongInteger"}],
    Cell[86107, 3615, 478, 21, 70, "Usage",
      CellTags->{"S1.1054", "MLPutLongInteger"}],
    Cell[86588, 3638, 157, 5, 70, "Notes",
      CellTags->{"S1.1054", "MLPutLongInteger"}],
    Cell[86748, 3645, 209, 7, 70, "Notes",
      CellTags->{"S1.1054", "MLPutLongInteger"}]},
  "MLPutLongInteger"->{
    Cell[86019, 3612, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1054", "MLPutLongInteger"}],
    Cell[86107, 3615, 478, 21, 70, "Usage",
      CellTags->{"S1.1054", "MLPutLongInteger"}],
    Cell[86588, 3638, 157, 5, 70, "Notes",
      CellTags->{"S1.1054", "MLPutLongInteger"}],
    Cell[86748, 3645, 209, 7, 70, "Notes",
      CellTags->{"S1.1054", "MLPutLongInteger"}]},
  "S1.1055"->{
    Cell[86994, 3657, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[87068, 3660, 397, 17, 70, "Usage",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[87468, 3679, 189, 6, 70, "Notes",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[87660, 3687, 206, 7, 70, "Notes",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[87869, 3696, 173, 6, 70, "Notes",
      CellTags->{"S1.1055", "MLPutNext"}]},
  "MLPutNext"->{
    Cell[86994, 3657, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[87068, 3660, 397, 17, 70, "Usage",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[87468, 3679, 189, 6, 70, "Notes",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[87660, 3687, 206, 7, 70, "Notes",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[87869, 3696, 173, 6, 70, "Notes",
      CellTags->{"S1.1055", "MLPutNext"}]},
  "S1.1056"->{
    Cell[88079, 3707, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[88153, 3710, 483, 21, 70, "Usage",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[88639, 3733, 296, 8, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[88938, 3743, 201, 7, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[89142, 3752, 335, 11, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[89480, 3765, 310, 12, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}]},
  "MLPutReal"->{
    Cell[88079, 3707, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[88153, 3710, 483, 21, 70, "Usage",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[88639, 3733, 296, 8, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[88938, 3743, 201, 7, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[89142, 3752, 335, 11, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[89480, 3765, 310, 12, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}]},
  "S1.1057"->{
    Cell[89827, 3782, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[89911, 3785, 908, 41, 70, "Usage",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[90822, 3828, 305, 12, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[91130, 3842, 268, 9, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[91401, 3853, 212, 7, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[91616, 3862, 208, 7, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[91827, 3871, 178, 6, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}]},
  "MLPutRealArray"->{
    Cell[89827, 3782, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[89911, 3785, 908, 41, 70, "Usage",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[90822, 3828, 305, 12, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[91130, 3842, 268, 9, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[91401, 3853, 212, 7, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[91616, 3862, 208, 7, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[91827, 3871, 178, 6, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}]},
  "S1.1058"->{
    Cell[92042, 3882, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1058", "MLPutRealList"}],
    Cell[92124, 3885, 660, 29, 70, "Usage",
      CellTags->{"S1.1058", "MLPutRealList"}],
    Cell[92787, 3916, 207, 7, 70, "Notes",
      CellTags->{"S1.1058", "MLPutRealList"}],
    Cell[92997, 3925, 178, 6, 70, "Notes",
      CellTags->{"S1.1058", "MLPutRealList"}]},
  "MLPutRealList"->{
    Cell[92042, 3882, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1058", "MLPutRealList"}],
    Cell[92124, 3885, 660, 29, 70, "Usage",
      CellTags->{"S1.1058", "MLPutRealList"}],
    Cell[92787, 3916, 207, 7, 70, "Notes",
      CellTags->{"S1.1058", "MLPutRealList"}],
    Cell[92997, 3925, 178, 6, 70, "Notes",
      CellTags->{"S1.1058", "MLPutRealList"}]},
  "S1.1059"->{
    Cell[93212, 3936, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[93302, 3939, 602, 25, 70, "Usage",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[93907, 3966, 392, 11, 70, "Notes",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[94302, 3979, 158, 5, 70, "Notes",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[94463, 3986, 210, 7, 70, "Notes",
      CellTags->{"S1.1059", "MLPutShortInteger"}]},
  "MLPutShortInteger"->{
    Cell[93212, 3936, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[93302, 3939, 602, 25, 70, "Usage",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[93907, 3966, 392, 11, 70, "Notes",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[94302, 3979, 158, 5, 70, "Notes",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[94463, 3986, 210, 7, 70, "Notes",
      CellTags->{"S1.1059", "MLPutShortInteger"}]},
  "S1.1060"->{
    Cell[94710, 3998, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[94788, 4001, 463, 20, 70, "Usage",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[95254, 4023, 219, 6, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[95476, 4031, 175, 4, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[95654, 4037, 212, 6, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[95869, 4045, 205, 7, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[96077, 4054, 322, 12, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}]},
  "MLPutString"->{
    Cell[94710, 3998, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[94788, 4001, 463, 20, 70, "Usage",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[95254, 4023, 219, 6, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[95476, 4031, 175, 4, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[95654, 4037, 212, 6, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[95869, 4045, 205, 7, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[96077, 4054, 322, 12, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}]},
  "S1.1061"->{
    Cell[96436, 4071, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[96514, 4074, 527, 22, 70, "Usage",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[97044, 4098, 184, 6, 70, "Notes",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[97231, 4106, 337, 11, 70, "Notes",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[97571, 4119, 173, 6, 24, "Notes",
      CellTags->{"S1.1061", "MLPutSymbol"}]},
  "MLPutSymbol"->{
    Cell[96436, 4071, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[96514, 4074, 527, 22, 70, "Usage",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[97044, 4098, 184, 6, 70, "Notes",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[97231, 4106, 337, 11, 70, "Notes",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[97571, 4119, 173, 6, 24, "Notes",
      CellTags->{"S1.1061", "MLPutSymbol"}]},
  "S1.1062"->{
    Cell[97781, 4130, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[97873, 4133, 658, 29, 48, "Usage",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[98534, 4164, 136, 4, 24, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[98673, 4170, 181, 4, 24, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[98857, 4176, 212, 7, 24, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[99072, 4185, 253, 9, 24, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}]},
  "MLPutUnicodeString"->{
    Cell[97781, 4130, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[97873, 4133, 658, 29, 48, "Usage",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[98534, 4164, 136, 4, 24, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[98673, 4170, 181, 4, 24, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[98857, 4176, 212, 7, 24, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[99072, 4185, 253, 9, 24, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}]},
  "S1.1063"->{
    Cell[99362, 4199, 67, 1, 38, "ObjectName",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[99432, 4202, 304, 12, 32, "Usage",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[99739, 4216, 196, 7, 24, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[99938, 4225, 225, 7, 24, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[100166, 4234, 180, 5, 24, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[100349, 4241, 208, 7, 24, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[100560, 4250, 204, 7, 24, "Notes",
      CellTags->{"S1.1063", "MLReady"}]},
  "MLReady"->{
    Cell[99362, 4199, 67, 1, 38, "ObjectName",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[99432, 4202, 304, 12, 32, "Usage",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[99739, 4216, 196, 7, 24, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[99938, 4225, 225, 7, 24, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[100166, 4234, 180, 5, 24, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[100349, 4241, 208, 7, 24, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[100560, 4250, 204, 7, 24, "Notes",
      CellTags->{"S1.1063", "MLReady"}]},
  "S1.1064"->{
    Cell[100801, 4262, 73, 1, 38, "ObjectName",
      CellTags->{"S1.1064", "MLSeekMark"}],
    Cell[100877, 4265, 508, 22, 48, "Usage",
      CellTags->{"S1.1064", "MLSeekMark"}],
    Cell[101388, 4289, 207, 7, 24, "Notes",
      CellTags->{"S1.1064", "MLSeekMark"}]},
  "MLSeekMark"->{
    Cell[100801, 4262, 73, 1, 38, "ObjectName",
      CellTags->{"S1.1064", "MLSeekMark"}],
    Cell[100877, 4265, 508, 22, 48, "Usage",
      CellTags->{"S1.1064", "MLSeekMark"}],
    Cell[101388, 4289, 207, 7, 24, "Notes",
      CellTags->{"S1.1064", "MLSeekMark"}]},
  "S1.1065"->{
    Cell[101632, 4301, 93, 1, 38, "ObjectName",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[101728, 4304, 428, 17, 48, "Usage",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[102159, 4323, 194, 7, 24, "Notes",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[102356, 4332, 214, 7, 24, "Notes",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[102573, 4341, 216, 7, 24, "Notes",
      CellTags->{"S1.1065", "MLTransferExpression"}]},
  "MLTransferExpression"->{
    Cell[101632, 4301, 93, 1, 38, "ObjectName",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[101728, 4304, 428, 17, 48, "Usage",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[102159, 4323, 194, 7, 24, "Notes",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[102356, 4332, 214, 7, 24, "Notes",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[102573, 4341, 216, 7, 24, "Notes",
      CellTags->{"S1.1065", "MLTransferExpression"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.11.0", 103445, 4369},
  {"0.1", 103536, 4372},
  {"SA.11.1", 103631, 4375},
  {"1.1", 104499, 4398},
  {"1.2", 104592, 4401},
  {"1.3", 104680, 4404},
  {"1.4", 104768, 4407},
  {"1.5", 104857, 4410},
  {"1.6", 104945, 4413},
  {"1.7", 105036, 4416},
  {"1.8", 105125, 4419},
  {"1.9", 105216, 4422},
  {"1.10", 105306, 4425},
  {"1.11", 105397, 4428},
  {"S1.1001", 105493, 4431},
  {"MLAbort", 105842, 4440},
  {"S1.1002", 106191, 4449},
  {"MLActivate", 106555, 4458},
  {"S1.1003", 106916, 4467},
  {"MLCheckFunction", 107396, 4478},
  {"S1.1004", 107868, 4489},
  {"MLClearError", 108242, 4498},
  {"S1.1005", 108611, 4507},
  {"MLClose", 109212, 4522},
  {"S1.1006", 109813, 4537},
  {"MLCreateMark", 110279, 4548},
  {"S1.1007", 110740, 4559},
  {"MLDeinitialize", 111308, 4572},
  {"S1.1008", 111869, 4585},
  {"MLDestroyMark", 112252, 4594},
  {"S1.1009", 112629, 4603},
  {"MLDisownByteString", 113037, 4612},
  {"S1.1010", 113434, 4621},
  {"MLDisownIntegerArray", 113756, 4628},
  {"S1.1011", 114065, 4635},
  {"MLDisownIntegerList", 114383, 4642},
  {"S1.1012", 114689, 4649},
  {"MLDisownRealArray", 114999, 4656},
  {"S1.1013", 115299, 4663},
  {"MLDisownRealList", 115605, 4670},
  {"S1.1014", 115902, 4677},
  {"MLDisownString", 116290, 4686},
  {"S1.1015", 116671, 4695},
  {"MLDisownSymbol", 116970, 4702},
  {"S1.1016", 117262, 4709},
  {"MLDisownUnicodeString", 117685, 4718},
  {"S1.1017", 118094, 4727},
  {"MLEndPacket", 118468, 4736},
  {"S1.1018", 118838, 4745},
  {"MLError", 119279, 4756},
  {"S1.1019", 119720, 4767},
  {"MLErrorMessage", 120021, 4774},
  {"S1.1020", 120315, 4781},
  {"MLEvaluateString", 120813, 4792},
  {"S1.1021", 121302, 4803},
  {"MLFlush", 121827, 4816},
  {"S1.1022", 122352, 4829},
  {"MLGetArgCount", 122649, 4836},
  {"S1.1023", 122940, 4843},
  {"MLGetByteString", 123797, 4862},
  {"S1.1024", 124646, 4881},
  {"MLGetDouble", 125199, 4894},
  {"S1.1025", 125748, 4907},
  {"MLGetFloat", 126120, 4916},
  {"S1.1026", 126489, 4925},
  {"MLGetFunction", 127147, 4940},
  {"S1.1027", 127799, 4955},
  {"MLGetInteger", 128449, 4970},
  {"S1.1028", 129094, 4985},
  {"MLGetIntegerArray", 129878, 5002},
  {"S1.1029", 130652, 5019},
  {"MLGetIntegerList", 131333, 5034},
  {"S1.1030", 132005, 5049},
  {"MLGetLongInteger", 132407, 5058},
  {"S1.1031", 132800, 5067},
  {"MLGetNext", 133434, 5082},
  {"S1.1032", 134066, 5097},
  {"MLGetReal", 134779, 5114},
  {"S1.1033", 135490, 5131},
  {"MLGetRealArray", 136156, 5146},
  {"S1.1034", 136815, 5161},
  {"MLGetRealList", 137382, 5174},
  {"S1.1035", 137943, 5187},
  {"MLGetShortInteger", 138350, 5196},
  {"S1.1036", 138747, 5205},
  {"MLGetString", 139564, 5224},
  {"S1.1037", 140377, 5243},
  {"MLGetSymbol", 140843, 5254},
  {"S1.1038", 141305, 5265},
  {"MLGetUnicodeString", 142097, 5282},
  {"S1.1039", 142878, 5299},
  {"MLInitialize", 143348, 5310},
  {"S1.1040", 143813, 5321},
  {"MLLoopbackOpen", 144387, 5334},
  {"S1.1041", 144954, 5347},
  {"MLMain", 145473, 5360},
  {"S1.1042", 145993, 5373},
  {"MLNewPacket", 146547, 5386},
  {"S1.1043", 147097, 5399},
  {"MLNextPacket", 147479, 5408},
  {"S1.1044", 147856, 5417},
  {"MLOpenArgv", 149023, 5444},
  {"S1.1045", 150187, 5471},
  {"MLOpenString", 150925, 5488},
  {"S1.1046", 151658, 5505},
  {"MLPutArgCount", 151865, 5510},
  {"S1.1047", 152066, 5515},
  {"MLPutByteString", 152831, 5532},
  {"S1.1048", 153588, 5549},
  {"MLPutDouble", 153965, 5558},
  {"S1.1049", 154338, 5567},
  {"MLPutFloat", 154798, 5578},
  {"S1.1050", 155255, 5589},
  {"MLPutFunction", 155732, 5600},
  {"S1.1051", 156203, 5611},
  {"MLPutInteger", 156676, 5622},
  {"S1.1052", 157144, 5633},
  {"MLPutIntegerArray", 157834, 5648},
  {"S1.1053", 158514, 5663},
  {"MLPutIntegerList", 158916, 5672},
  {"S1.1054", 159309, 5681},
  {"MLPutLongInteger", 159711, 5690},
  {"S1.1055", 160104, 5699},
  {"MLPutNext", 160557, 5710},
  {"S1.1056", 161008, 5721},
  {"MLPutReal", 161549, 5734},
  {"S1.1057", 162088, 5747},
  {"MLPutRealArray", 162754, 5762},
  {"S1.1058", 163413, 5777},
  {"MLPutRealList", 163800, 5786},
  {"S1.1059", 164181, 5795},
  {"MLPutShortInteger", 164683, 5806},
  {"S1.1060", 165175, 5817},
  {"MLPutString", 165817, 5832},
  {"S1.1061", 166455, 5847},
  {"MLPutSymbol", 166921, 5858},
  {"S1.1062", 167383, 5869},
  {"MLPutUnicodeString", 167985, 5882},
  {"S1.1063", 168576, 5895},
  {"MLReady", 169188, 5910},
  {"S1.1064", 169800, 5925},
  {"MLSeekMark", 170088, 5932},
  {"S1.1065", 170373, 5939},
  {"MLTransferExpression", 170897, 5950}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 180, 6, 91, "Section",
  CellTags->{"SA.11.0", "0.1"}],

Cell[CellGroupData[{
Cell[1981, 63, 66, 1, 70, "Subsection",
  CellTags->{"SA.11.1", "1.1"}],
Cell[2050, 66, 161, 5, 70, "Text",
  CellTags->{"SA.11.1", "1.2"}],
Cell[2214, 73, 262, 7, 70, "Text",
  CellTags->{"SA.11.1", "1.3"}],
Cell[2479, 82, 336, 13, 70, "Text",
  CellTags->{"SA.11.1", "1.4"}],
Cell[2818, 97, 147, 5, 70, "Text",
  CellTags->{"SA.11.1", "1.5"}],
Cell[2968, 104, 503, 19, 70, "Notes",
  CellTags->{"SA.11.1", "1.6"}],
Cell[3474, 125, 171, 5, 70, "Text",
  CellTags->{"SA.11.1", "1.7"}],
Cell[3648, 132, 528, 19, 70, "Notes",
  CellTags->{"SA.11.1", "1.8"}],
Cell[4179, 153, 180, 4, 70, "Text",
  CellTags->{"SA.11.1", "1.9"}],
Cell[4362, 159, 100, 1, 70, "Text",
  CellTags->{"SA.11.1", "1.10"}],
Cell[4465, 162, 860, 18, 70, "Notes",
  CellTags->{"SA.11.1", "1.11"}],

Cell[CellGroupData[{
Cell[5350, 184, 65, 1, 70, "ObjectName",
  CellTags->{"S1.1001", "MLAbort"}],
Cell[5418, 187, 315, 11, 70, "Usage",
  CellTags->{"S1.1001", "MLAbort"}],
Cell[5736, 200, 311, 9, 70, "Notes",
  CellTags->{"S1.1001", "MLAbort"}],
Cell[6050, 211, 203, 7, 70, "Notes",
  CellTags->{"S1.1001", "MLAbort"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6290, 223, 73, 1, 70, "ObjectName",
  CellTags->{"S1.1002", "MLActivate"}],
Cell[6366, 226, 340, 12, 70, "Usage",
  CellTags->{"S1.1002", "MLActivate"}],
Cell[6709, 240, 247, 9, 70, "Notes",
  CellTags->{"S1.1002", "MLActivate"}],
Cell[6959, 251, 206, 7, 70, "Notes",
  CellTags->{"S1.1002", "MLActivate"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7202, 263, 83, 1, 70, "ObjectName",
  CellTags->{"S1.1003", "MLCheckFunction"}],
Cell[7288, 266, 658, 27, 70, "Usage",
  CellTags->{"S1.1003", "MLCheckFunction"}],
Cell[7949, 295, 339, 10, 70, "Notes",
  CellTags->{"S1.1003", "MLCheckFunction"}],
Cell[8291, 307, 210, 7, 70, "Notes",
  CellTags->{"S1.1003", "MLCheckFunction"}],
Cell[8504, 316, 179, 6, 70, "Notes",
  CellTags->{"S1.1003", "MLCheckFunction"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8720, 327, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1004", "MLClearError"}],
Cell[8800, 330, 321, 12, 70, "Usage",
  CellTags->{"S1.1004", "MLClearError"}],
Cell[9124, 344, 303, 8, 70, "Notes",
  CellTags->{"S1.1004", "MLClearError"}],
Cell[9430, 354, 208, 7, 70, "Notes",
  CellTags->{"S1.1004", "MLClearError"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9675, 366, 67, 1, 70, "ObjectName",
  CellTags->{"S1.1005", "MLClose"}],
Cell[9745, 369, 279, 12, 70, "Usage",
  CellTags->{"S1.1005", "MLClose"}],
Cell[10027, 383, 207, 5, 70, "Notes",
  CellTags->{"S1.1005", "MLClose"}],
Cell[10237, 390, 182, 5, 70, "Notes",
  CellTags->{"S1.1005", "MLClose"}],
Cell[10422, 397, 153, 4, 70, "Notes",
  CellTags->{"S1.1005", "MLClose"}],
Cell[10578, 403, 334, 11, 70, "Notes",
  CellTags->{"S1.1005", "MLClose"}],
Cell[10915, 416, 172, 6, 70, "Notes",
  CellTags->{"S1.1005", "MLClose"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11124, 427, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1006", "MLCreateMark"}],
Cell[11204, 430, 314, 11, 70, "Usage",
  CellTags->{"S1.1006", "MLCreateMark"}],
Cell[11521, 443, 213, 5, 70, "Notes",
  CellTags->{"S1.1006", "MLCreateMark"}],
Cell[11737, 450, 209, 7, 70, "Notes",
  CellTags->{"S1.1006", "MLCreateMark"}],
Cell[11949, 459, 177, 6, 70, "Notes",
  CellTags->{"S1.1006", "MLCreateMark"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12163, 470, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1007", "MLDeinitialize"}],
Cell[12247, 473, 311, 12, 70, "Usage",
  CellTags->{"S1.1007", "MLDeinitialize"}],
Cell[12561, 487, 281, 7, 70, "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}],
Cell[12845, 496, 248, 7, 70, "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}],
Cell[13096, 505, 230, 7, 70, "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}],
Cell[13329, 514, 210, 7, 70, "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13576, 526, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1008", "MLDestroyMark"}],
Cell[13658, 529, 362, 15, 70, "Usage",
  CellTags->{"S1.1008", "MLDestroyMark"}],
Cell[14023, 546, 233, 6, 70, "Notes",
  CellTags->{"S1.1008", "MLDestroyMark"}],
Cell[14259, 554, 210, 7, 70, "Notes",
  CellTags->{"S1.1008", "MLDestroyMark"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[14506, 566, 89, 1, 70, "ObjectName",
  CellTags->{"S1.1009", "MLDisownByteString"}],
Cell[14598, 569, 618, 27, 70, "Usage",
  CellTags->{"S1.1009", "MLDisownByteString"}],
Cell[15219, 598, 212, 7, 70, "Notes",
  CellTags->{"S1.1009", "MLDisownByteString"}],
Cell[15434, 607, 183, 6, 70, "Notes",
  CellTags->{"S1.1009", "MLDisownByteString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[15654, 618, 93, 1, 70, "ObjectName",
  CellTags->{"S1.1010", "MLDisownIntegerArray"}],
Cell[15750, 621, 890, 41, 70, "Usage",
  CellTags->{"S1.1010", "MLDisownIntegerArray"}],
Cell[16643, 664, 215, 7, 70, "Notes",
  CellTags->{"S1.1010", "MLDisownIntegerArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16895, 676, 91, 1, 70, "ObjectName",
  CellTags->{"S1.1011", "MLDisownIntegerList"}],
Cell[16989, 679, 604, 27, 70, "Usage",
  CellTags->{"S1.1011", "MLDisownIntegerList"}],
Cell[17596, 708, 214, 7, 70, "Notes",
  CellTags->{"S1.1011", "MLDisownIntegerList"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[17847, 720, 87, 1, 70, "ObjectName",
  CellTags->{"S1.1012", "MLDisownRealArray"}],
Cell[17937, 723, 884, 41, 70, "Usage",
  CellTags->{"S1.1012", "MLDisownRealArray"}],
Cell[18824, 766, 212, 7, 70, "Notes",
  CellTags->{"S1.1012", "MLDisownRealArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[19073, 778, 85, 1, 70, "ObjectName",
  CellTags->{"S1.1013", "MLDisownRealList"}],
Cell[19161, 781, 598, 27, 70, "Usage",
  CellTags->{"S1.1013", "MLDisownRealList"}],
Cell[19762, 810, 211, 7, 70, "Notes",
  CellTags->{"S1.1013", "MLDisownRealList"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[20010, 822, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1014", "MLDisownString"}],
Cell[20094, 825, 475, 20, 70, "Usage",
  CellTags->{"S1.1014", "MLDisownString"}],
Cell[20572, 847, 209, 7, 70, "Notes",
  CellTags->{"S1.1014", "MLDisownString"}],
Cell[20784, 856, 186, 6, 70, "Notes",
  CellTags->{"S1.1014", "MLDisownString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[21007, 867, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1015", "MLDisownSymbol"}],
Cell[21091, 870, 560, 22, 70, "Usage",
  CellTags->{"S1.1015", "MLDisownSymbol"}],
Cell[21654, 894, 339, 11, 70, "Notes",
  CellTags->{"S1.1015", "MLDisownSymbol"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22030, 910, 95, 1, 70, "ObjectName",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}],
Cell[22128, 913, 610, 27, 70, "Usage",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}],
Cell[22741, 942, 215, 7, 70, "Notes",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}],
Cell[22959, 951, 186, 6, 70, "Notes",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[23182, 962, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1017", "MLEndPacket"}],
Cell[23260, 965, 324, 11, 70, "Usage",
  CellTags->{"S1.1017", "MLEndPacket"}],
Cell[23587, 978, 265, 6, 70, "Notes",
  CellTags->{"S1.1017", "MLEndPacket"}],
Cell[23855, 986, 337, 11, 70, "Notes",
  CellTags->{"S1.1017", "MLEndPacket"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[24229, 1002, 67, 1, 70, "ObjectName",
  CellTags->{"S1.1018", "MLError"}],
Cell[24299, 1005, 438, 16, 70, "Usage",
  CellTags->{"S1.1018", "MLError"}],
Cell[24740, 1023, 193, 6, 70, "Notes",
  CellTags->{"S1.1018", "MLError"}],
Cell[24936, 1031, 225, 7, 70, "Notes",
  CellTags->{"S1.1018", "MLError"}],
Cell[25164, 1040, 203, 7, 70, "Notes",
  CellTags->{"S1.1018", "MLError"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[25404, 1052, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1019", "MLErrorMessage"}],
Cell[25488, 1055, 335, 12, 70, "Usage",
  CellTags->{"S1.1019", "MLErrorMessage"}],
Cell[25826, 1069, 210, 7, 70, "Notes",
  CellTags->{"S1.1019", "MLErrorMessage"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[26073, 1081, 85, 1, 70, "ObjectName",
  CellTags->{"S1.1020", "MLEvaluateString"}],
Cell[26161, 1084, 469, 18, 70, "Usage",
  CellTags->{"S1.1020", "MLEvaluateString"}],
Cell[26633, 1104, 398, 13, 70, "Notes",
  CellTags->{"S1.1020", "MLEvaluateString"}],
Cell[27034, 1119, 384, 12, 70, "Notes",
  CellTags->{"S1.1020", "MLEvaluateString"}],
Cell[27421, 1133, 339, 11, 70, "Notes",
  CellTags->{"S1.1020", "MLEvaluateString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[27797, 1149, 67, 1, 70, "ObjectName",
  CellTags->{"S1.1021", "MLFlush"}],
Cell[27867, 1152, 316, 12, 70, "Usage",
  CellTags->{"S1.1021", "MLFlush"}],
Cell[28186, 1166, 280, 9, 70, "Notes",
  CellTags->{"S1.1021", "MLFlush"}],
Cell[28469, 1177, 276, 8, 70, "Notes",
  CellTags->{"S1.1021", "MLFlush"}],
Cell[28748, 1187, 204, 7, 70, "Notes",
  CellTags->{"S1.1021", "MLFlush"}],
Cell[28955, 1196, 165, 6, 70, "Notes",
  CellTags->{"S1.1021", "MLFlush"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[29157, 1207, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1022", "MLGetArgCount"}],
Cell[29239, 1210, 477, 20, 70, "Usage",
  CellTags->{"S1.1022", "MLGetArgCount"}],
Cell[29719, 1232, 210, 7, 70, "Notes",
  CellTags->{"S1.1022", "MLGetArgCount"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[29966, 1244, 83, 1, 70, "ObjectName",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[30052, 1247, 995, 41, 70, "Usage",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[31050, 1290, 281, 7, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[31334, 1299, 207, 5, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[31544, 1306, 293, 9, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[31840, 1317, 215, 5, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[32058, 1324, 242, 6, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[32303, 1332, 209, 7, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[32515, 1341, 253, 9, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[32805, 1355, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1024", "MLGetDouble"}],
Cell[32883, 1358, 572, 24, 70, "Usage",
  CellTags->{"S1.1024", "MLGetDouble"}],
Cell[33458, 1384, 203, 7, 70, "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}],
Cell[33664, 1393, 149, 5, 70, "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}],
Cell[33816, 1400, 204, 7, 70, "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}],
Cell[34023, 1409, 172, 6, 70, "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[34232, 1420, 73, 1, 70, "ObjectName",
  CellTags->{"S1.1025", "MLGetFloat"}],
Cell[34308, 1423, 568, 24, 70, "Usage",
  CellTags->{"S1.1025", "MLGetFloat"}],
Cell[34879, 1449, 148, 5, 70, "Notes",
  CellTags->{"S1.1025", "MLGetFloat"}],
Cell[35030, 1456, 203, 7, 70, "Notes",
  CellTags->{"S1.1025", "MLGetFloat"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[35270, 1468, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1026", "MLGetFunction"}],
Cell[35352, 1471, 737, 30, 70, "Usage",
  CellTags->{"S1.1026", "MLGetFunction"}],
Cell[36092, 1503, 321, 8, 70, "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],
Cell[36416, 1513, 186, 6, 70, "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],
Cell[36605, 1521, 788, 35, 70, "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],
Cell[37396, 1558, 208, 7, 70, "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],
Cell[37607, 1567, 173, 6, 70, "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[37817, 1578, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1027", "MLGetInteger"}],
Cell[37897, 1581, 505, 22, 70, "Usage",
  CellTags->{"S1.1027", "MLGetInteger"}],
Cell[38405, 1605, 223, 6, 70, "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],
Cell[38631, 1613, 331, 10, 70, "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],
Cell[38965, 1625, 293, 8, 70, "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],
Cell[39261, 1635, 207, 7, 70, "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],
Cell[39471, 1644, 254, 9, 70, "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[39762, 1658, 87, 1, 70, "ObjectName",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[39852, 1661, 967, 44, 70, "Usage",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[40822, 1707, 289, 12, 70, "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[41114, 1721, 257, 6, 70, "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[41374, 1729, 251, 7, 70, "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[41628, 1738, 211, 6, 70, "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[41842, 1746, 212, 7, 70, "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[42057, 1755, 184, 6, 70, "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[42278, 1766, 85, 1, 70, "ObjectName",
  CellTags->{"S1.1029", "MLGetIntegerList"}],
Cell[42366, 1769, 709, 30, 70, "Usage",
  CellTags->{"S1.1029", "MLGetIntegerList"}],
Cell[43078, 1801, 277, 7, 70, "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],
Cell[43358, 1810, 208, 6, 70, "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],
Cell[43569, 1818, 157, 5, 70, "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],
Cell[43729, 1825, 211, 7, 70, "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],
Cell[43943, 1834, 257, 9, 70, "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[44237, 1848, 85, 1, 70, "ObjectName",
  CellTags->{"S1.1030", "MLGetLongInteger"}],
Cell[44325, 1851, 554, 24, 70, "Usage",
  CellTags->{"S1.1030", "MLGetLongInteger"}],
Cell[44882, 1877, 157, 5, 70, "Notes",
  CellTags->{"S1.1030", "MLGetLongInteger"}],
Cell[45042, 1884, 209, 7, 70, "Notes",
  CellTags->{"S1.1030", "MLGetLongInteger"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[45288, 1896, 71, 1, 70, "ObjectName",
  CellTags->{"S1.1031", "MLGetNext"}],
Cell[45362, 1899, 306, 12, 70, "Usage",
  CellTags->{"S1.1031", "MLGetNext"}],
Cell[45671, 1913, 124, 4, 70, "Notes",
  CellTags->{"S1.1031", "MLGetNext"}],
Cell[45798, 1919, 922, 28, 70, "2ColumnTable",
  CellTags->{"MLGetNext", "S1.1031"}],
Cell[46723, 1949, 310, 11, 70, "Notes",
  CellTags->{"S1.1031", "MLGetNext"}],
Cell[47036, 1962, 206, 7, 70, "Notes",
  CellTags->{"S1.1031", "MLGetNext"}],
Cell[47245, 1971, 173, 6, 70, "Notes",
  CellTags->{"S1.1031", "MLGetNext"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[47455, 1982, 71, 1, 70, "ObjectName",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[47529, 1985, 523, 22, 70, "Usage",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[48055, 2009, 290, 9, 70, "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[48348, 2020, 344, 10, 70, "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[48695, 2032, 291, 8, 70, "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[48989, 2042, 201, 7, 70, "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[49193, 2051, 204, 7, 70, "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[49400, 2060, 310, 12, 70, "Notes",
  CellTags->{"S1.1032", "MLGetReal"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[49747, 2077, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1033", "MLGetRealArray"}],
Cell[49831, 2080, 986, 44, 70, "Usage",
  CellTags->{"S1.1033", "MLGetRealArray"}],
Cell[50820, 2126, 289, 12, 70, "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],
Cell[51112, 2140, 254, 6, 70, "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],
Cell[51369, 2148, 242, 7, 70, "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],
Cell[51614, 2157, 205, 6, 70, "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],
Cell[51822, 2165, 209, 7, 70, "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[52068, 2177, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1034", "MLGetRealList"}],
Cell[52150, 2180, 727, 30, 70, "Usage",
  CellTags->{"S1.1034", "MLGetRealList"}],
Cell[52880, 2212, 267, 7, 70, "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}],
Cell[53150, 2221, 202, 6, 70, "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}],
Cell[53355, 2229, 151, 5, 70, "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}],
Cell[53509, 2236, 208, 7, 70, "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[53754, 2248, 87, 1, 70, "ObjectName",
  CellTags->{"S1.1035", "MLGetShortInteger"}],
Cell[53844, 2251, 558, 24, 70, "Usage",
  CellTags->{"S1.1035", "MLGetShortInteger"}],
Cell[54405, 2277, 158, 5, 70, "Notes",
  CellTags->{"S1.1035", "MLGetShortInteger"}],
Cell[54566, 2284, 210, 7, 70, "Notes",
  CellTags->{"S1.1035", "MLGetShortInteger"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[54813, 2296, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[54891, 2299, 519, 22, 70, "Usage",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[55413, 2323, 261, 7, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[55677, 2332, 196, 6, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[55876, 2340, 218, 7, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[56097, 2349, 268, 7, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[56368, 2358, 228, 7, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[56599, 2367, 205, 7, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[56807, 2376, 253, 9, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[57097, 2390, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1037", "MLGetSymbol"}],
Cell[57175, 2393, 567, 22, 70, "Usage",
  CellTags->{"S1.1037", "MLGetSymbol"}],
Cell[57745, 2417, 261, 7, 70, "Notes",
  CellTags->{"S1.1037", "MLGetSymbol"}],
Cell[58009, 2426, 218, 7, 70, "Notes",
  CellTags->{"S1.1037", "MLGetSymbol"}],
Cell[58230, 2435, 338, 11, 70, "Notes",
  CellTags->{"S1.1037", "MLGetSymbol"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[58605, 2451, 89, 1, 70, "ObjectName",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[58697, 2454, 731, 30, 70, "Usage",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[59431, 2486, 282, 7, 70, "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[59716, 2495, 210, 6, 70, "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[59929, 2503, 213, 5, 70, "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[60145, 2510, 174, 4, 70, "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[60322, 2516, 212, 7, 70, "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[60537, 2525, 253, 9, 70, "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[60827, 2539, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1039", "MLInitialize"}],
Cell[60907, 2542, 248, 9, 70, "Usage",
  CellTags->{"S1.1039", "MLInitialize"}],
Cell[61158, 2553, 277, 7, 70, "Notes",
  CellTags->{"S1.1039", "MLInitialize"}],
Cell[61438, 2562, 309, 9, 70, "Notes",
  CellTags->{"S1.1039", "MLInitialize"}],
Cell[61750, 2573, 208, 7, 70, "Notes",
  CellTags->{"S1.1039", "MLInitialize"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[61995, 2585, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],
Cell[62079, 2588, 414, 18, 70, "Usage",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],
Cell[62496, 2608, 247, 7, 70, "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],
Cell[62746, 2617, 219, 5, 70, "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],
Cell[62968, 2624, 210, 7, 70, "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],
Cell[63181, 2633, 177, 6, 70, "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[63395, 2644, 65, 1, 70, "ObjectName",
  CellTags->{"S1.1041", "MLMain"}],
Cell[63463, 2647, 474, 20, 70, "Usage",
  CellTags->{"S1.1041", "MLMain"}],
Cell[63940, 2669, 239, 9, 70, "Notes",
  CellTags->{"S1.1041", "MLMain"}],
Cell[64182, 2680, 387, 13, 70, "Notes",
  CellTags->{"S1.1041", "MLMain"}],
Cell[64572, 2695, 185, 7, 70, "Notes",
  CellTags->{"S1.1041", "MLMain"}],
Cell[64760, 2704, 200, 7, 70, "Notes",
  CellTags->{"S1.1041", "MLMain"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[64997, 2716, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1042", "MLNewPacket"}],
Cell[65075, 2719, 304, 12, 70, "Usage",
  CellTags->{"S1.1042", "MLNewPacket"}],
Cell[65382, 2733, 236, 6, 70, "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}],
Cell[65621, 2741, 192, 5, 70, "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}],
Cell[65816, 2748, 339, 11, 70, "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}],
Cell[66158, 2761, 174, 6, 70, "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[66369, 2772, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1043", "MLNextPacket"}],
Cell[66449, 2775, 335, 12, 70, "Usage",
  CellTags->{"S1.1043", "MLNextPacket"}],
Cell[66787, 2789, 209, 7, 70, "Notes",
  CellTags->{"S1.1043", "MLNextPacket"}],
Cell[66999, 2798, 174, 6, 70, "Notes",
  CellTags->{"S1.1043", "MLNextPacket"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[67210, 2809, 73, 1, 70, "ObjectName",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[67286, 2812, 690, 32, 70, "Usage",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[67979, 2846, 200, 7, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[68182, 2855, 291, 9, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[68476, 2866, 1636, 50, 70, "2ColumnTable",
  CellTags->{"MLOpenArgv", "S1.1044"}],
Cell[70115, 2918, 182, 5, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[70300, 2925, 185, 5, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[70488, 2932, 293, 11, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[70784, 2945, 490, 22, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[71277, 2969, 275, 9, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[71555, 2980, 318, 10, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[71876, 2992, 206, 7, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[72085, 3001, 241, 9, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[72363, 3015, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[72443, 3018, 557, 24, 70, "Usage",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[73003, 3044, 204, 7, 70, "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[73210, 3053, 264, 9, 70, "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[73477, 3064, 138, 4, 70, "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[73618, 3070, 278, 6, 70, "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[73899, 3078, 208, 7, 70, "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[74110, 3087, 241, 9, 70, "Notes",
  CellTags->{"S1.1045", "MLOpenString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[74388, 3101, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1046", "MLPutArgCount"}],
Cell[74470, 3104, 423, 17, 70, "Usage",
  CellTags->{"S1.1046", "MLPutArgCount"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[74930, 3126, 83, 1, 70, "ObjectName",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[75016, 3129, 681, 31, 70, "Usage",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[75700, 3162, 274, 8, 70, "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[75977, 3172, 232, 6, 70, "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[76212, 3180, 194, 5, 70, "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[76409, 3187, 169, 4, 70, "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[76581, 3193, 209, 7, 70, "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[76793, 3202, 251, 9, 70, "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[77081, 3216, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1048", "MLPutDouble"}],
Cell[77159, 3219, 532, 23, 70, "Usage",
  CellTags->{"S1.1048", "MLPutDouble"}],
Cell[77694, 3244, 149, 5, 70, "Notes",
  CellTags->{"S1.1048", "MLPutDouble"}],
Cell[77846, 3251, 204, 7, 70, "Notes",
  CellTags->{"S1.1048", "MLPutDouble"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[78087, 3263, 73, 1, 70, "ObjectName",
  CellTags->{"S1.1049", "MLPutFloat"}],
Cell[78163, 3266, 564, 23, 70, "Usage",
  CellTags->{"S1.1049", "MLPutFloat"}],
Cell[78730, 3291, 381, 11, 70, "Notes",
  CellTags->{"S1.1049", "MLPutFloat"}],
Cell[79114, 3304, 148, 5, 70, "Notes",
  CellTags->{"S1.1049", "MLPutFloat"}],
Cell[79265, 3311, 203, 7, 70, "Notes",
  CellTags->{"S1.1049", "MLPutFloat"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[79505, 3323, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1050", "MLPutFunction"}],
Cell[79587, 3326, 662, 29, 70, "Usage",
  CellTags->{"S1.1050", "MLPutFunction"}],
Cell[80252, 3357, 265, 7, 70, "Notes",
  CellTags->{"S1.1050", "MLPutFunction"}],
Cell[80520, 3366, 207, 7, 70, "Notes",
  CellTags->{"S1.1050", "MLPutFunction"}],
Cell[80730, 3375, 175, 6, 70, "Notes",
  CellTags->{"S1.1050", "MLPutFunction"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[80942, 3386, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1051", "MLPutInteger"}],
Cell[81022, 3389, 464, 21, 70, "Usage",
  CellTags->{"S1.1051", "MLPutInteger"}],
Cell[81489, 3412, 295, 8, 70, "Notes",
  CellTags->{"S1.1051", "MLPutInteger"}],
Cell[81787, 3422, 338, 11, 70, "Notes",
  CellTags->{"S1.1051", "MLPutInteger"}],
Cell[82128, 3435, 398, 15, 70, "Notes",
  CellTags->{"S1.1051", "MLPutInteger"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[82563, 3455, 87, 1, 70, "ObjectName",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],
Cell[82653, 3458, 889, 41, 70, "Usage",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],
Cell[83545, 3501, 305, 12, 70, "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],
Cell[83853, 3515, 271, 9, 70, "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],
Cell[84127, 3526, 215, 7, 70, "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],
Cell[84345, 3535, 211, 7, 70, "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],
Cell[84559, 3544, 184, 6, 70, "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[84780, 3555, 85, 1, 70, "ObjectName",
  CellTags->{"S1.1053", "MLPutIntegerList"}],
Cell[84868, 3558, 641, 29, 70, "Usage",
  CellTags->{"S1.1053", "MLPutIntegerList"}],
Cell[85512, 3589, 210, 7, 70, "Notes",
  CellTags->{"S1.1053", "MLPutIntegerList"}],
Cell[85725, 3598, 257, 9, 70, "Notes",
  CellTags->{"S1.1053", "MLPutIntegerList"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[86019, 3612, 85, 1, 70, "ObjectName",
  CellTags->{"S1.1054", "MLPutLongInteger"}],
Cell[86107, 3615, 478, 21, 70, "Usage",
  CellTags->{"S1.1054", "MLPutLongInteger"}],
Cell[86588, 3638, 157, 5, 70, "Notes",
  CellTags->{"S1.1054", "MLPutLongInteger"}],
Cell[86748, 3645, 209, 7, 70, "Notes",
  CellTags->{"S1.1054", "MLPutLongInteger"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[86994, 3657, 71, 1, 70, "ObjectName",
  CellTags->{"S1.1055", "MLPutNext"}],
Cell[87068, 3660, 397, 17, 70, "Usage",
  CellTags->{"S1.1055", "MLPutNext"}],
Cell[87468, 3679, 189, 6, 70, "Notes",
  CellTags->{"S1.1055", "MLPutNext"}],
Cell[87660, 3687, 206, 7, 70, "Notes",
  CellTags->{"S1.1055", "MLPutNext"}],
Cell[87869, 3696, 173, 6, 70, "Notes",
  CellTags->{"S1.1055", "MLPutNext"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[88079, 3707, 71, 1, 70, "ObjectName",
  CellTags->{"S1.1056", "MLPutReal"}],
Cell[88153, 3710, 483, 21, 70, "Usage",
  CellTags->{"S1.1056", "MLPutReal"}],
Cell[88639, 3733, 296, 8, 70, "Notes",
  CellTags->{"S1.1056", "MLPutReal"}],
Cell[88938, 3743, 201, 7, 70, "Notes",
  CellTags->{"S1.1056", "MLPutReal"}],
Cell[89142, 3752, 335, 11, 70, "Notes",
  CellTags->{"S1.1056", "MLPutReal"}],
Cell[89480, 3765, 310, 12, 70, "Notes",
  CellTags->{"S1.1056", "MLPutReal"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[89827, 3782, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1057", "MLPutRealArray"}],
Cell[89911, 3785, 908, 41, 70, "Usage",
  CellTags->{"S1.1057", "MLPutRealArray"}],
Cell[90822, 3828, 305, 12, 70, "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],
Cell[91130, 3842, 268, 9, 70, "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],
Cell[91401, 3853, 212, 7, 70, "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],
Cell[91616, 3862, 208, 7, 70, "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],
Cell[91827, 3871, 178, 6, 70, "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[92042, 3882, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1058", "MLPutRealList"}],
Cell[92124, 3885, 660, 29, 70, "Usage",
  CellTags->{"S1.1058", "MLPutRealList"}],
Cell[92787, 3916, 207, 7, 70, "Notes",
  CellTags->{"S1.1058", "MLPutRealList"}],
Cell[92997, 3925, 178, 6, 70, "Notes",
  CellTags->{"S1.1058", "MLPutRealList"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[93212, 3936, 87, 1, 70, "ObjectName",
  CellTags->{"S1.1059", "MLPutShortInteger"}],
Cell[93302, 3939, 602, 25, 70, "Usage",
  CellTags->{"S1.1059", "MLPutShortInteger"}],
Cell[93907, 3966, 392, 11, 70, "Notes",
  CellTags->{"S1.1059", "MLPutShortInteger"}],
Cell[94302, 3979, 158, 5, 70, "Notes",
  CellTags->{"S1.1059", "MLPutShortInteger"}],
Cell[94463, 3986, 210, 7, 70, "Notes",
  CellTags->{"S1.1059", "MLPutShortInteger"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[94710, 3998, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1060", "MLPutString"}],
Cell[94788, 4001, 463, 20, 70, "Usage",
  CellTags->{"S1.1060", "MLPutString"}],
Cell[95254, 4023, 219, 6, 70, "Notes",
  CellTags->{"S1.1060", "MLPutString"}],
Cell[95476, 4031, 175, 4, 70, "Notes",
  CellTags->{"S1.1060", "MLPutString"}],
Cell[95654, 4037, 212, 6, 70, "Notes",
  CellTags->{"S1.1060", "MLPutString"}],
Cell[95869, 4045, 205, 7, 70, "Notes",
  CellTags->{"S1.1060", "MLPutString"}],
Cell[96077, 4054, 322, 12, 70, "Notes",
  CellTags->{"S1.1060", "MLPutString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[96436, 4071, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1061", "MLPutSymbol"}],
Cell[96514, 4074, 527, 22, 70, "Usage",
  CellTags->{"S1.1061", "MLPutSymbol"}],
Cell[97044, 4098, 184, 6, 70, "Notes",
  CellTags->{"S1.1061", "MLPutSymbol"}],
Cell[97231, 4106, 337, 11, 70, "Notes",
  CellTags->{"S1.1061", "MLPutSymbol"}],
Cell[97571, 4119, 173, 6, 24, "Notes",
  CellTags->{"S1.1061", "MLPutSymbol"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[97781, 4130, 89, 1, 70, "ObjectName",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],
Cell[97873, 4133, 658, 29, 48, "Usage",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],
Cell[98534, 4164, 136, 4, 24, "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],
Cell[98673, 4170, 181, 4, 24, "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],
Cell[98857, 4176, 212, 7, 24, "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],
Cell[99072, 4185, 253, 9, 24, "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[99362, 4199, 67, 1, 38, "ObjectName",
  CellTags->{"S1.1063", "MLReady"}],
Cell[99432, 4202, 304, 12, 32, "Usage",
  CellTags->{"S1.1063", "MLReady"}],
Cell[99739, 4216, 196, 7, 24, "Notes",
  CellTags->{"S1.1063", "MLReady"}],
Cell[99938, 4225, 225, 7, 24, "Notes",
  CellTags->{"S1.1063", "MLReady"}],
Cell[100166, 4234, 180, 5, 24, "Notes",
  CellTags->{"S1.1063", "MLReady"}],
Cell[100349, 4241, 208, 7, 24, "Notes",
  CellTags->{"S1.1063", "MLReady"}],
Cell[100560, 4250, 204, 7, 24, "Notes",
  CellTags->{"S1.1063", "MLReady"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[100801, 4262, 73, 1, 38, "ObjectName",
  CellTags->{"S1.1064", "MLSeekMark"}],
Cell[100877, 4265, 508, 22, 48, "Usage",
  CellTags->{"S1.1064", "MLSeekMark"}],
Cell[101388, 4289, 207, 7, 24, "Notes",
  CellTags->{"S1.1064", "MLSeekMark"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[101632, 4301, 93, 1, 38, "ObjectName",
  CellTags->{"S1.1065", "MLTransferExpression"}],
Cell[101728, 4304, 428, 17, 48, "Usage",
  CellTags->{"S1.1065", "MLTransferExpression"}],
Cell[102159, 4323, 194, 7, 24, "Notes",
  CellTags->{"S1.1065", "MLTransferExpression"}],
Cell[102356, 4332, 214, 7, 24, "Notes",
  CellTags->{"S1.1065", "MLTransferExpression"}],
Cell[102573, 4341, 216, 7, 24, "Notes",
  CellTags->{"S1.1065", "MLTransferExpression"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

