(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    863509,      37483]*)
(*NotebookOutlinePosition[   1215456,      47422]*)
(*  CellTagsIndexPosition[   1196901,      46809]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.12 ", "HeadingNumber"],
  "Listing of Named Characters"
}], "Section",
  CellTags->{"SA.12.0", "0.1"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->{"SA.12.1", "1.1"}],

Cell[TextData[{
  "This section gives a list of all characters that are assigned full names \
in ",
  StyleBox["Mathematica", "TI"],
  " Version 5.2. The list is ordered alphabetically by full name. "
}], "Text",
  CellTags->{"SA.12.1", "1.2"}],

Cell[TextData[{
  "The standard ",
  StyleBox["Mathematica", "TI"],
  " fonts support all of the characters in the list. "
}], "Text",
  CellTags->{"SA.12.1", "1.3"}],

Cell["There are a total of 770 characters in the list. ", "Text",
  CellTags->{"SA.12.1", "1.4"}],

Cell[TextData[{
  "\[AliasIndicator]",
  StyleBox["aaa\[AliasIndicator]", "MR"],
  " stands for ",
  Cell[BoxData[
      \(TraditionalForm\`\[EscapeKey]\)], "InlineFormula"],
  StyleBox["aaa", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[EscapeKey]\)], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"SA.12.1", "1.5"}],

Cell[CellGroupData[{

Cell["Interpretation of Characters", "Subsubsection",
  CellTags->{"SA.12.1", "1.6"}],

Cell[TextData[{
  "The interpretations given here are those used in ",
  StyleBox["StandardForm", "MR"],
  " and ",
  StyleBox["InputForm", "MR"],
  ". Most of the interpretations also work in ",
  StyleBox["TraditionalForm", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.12.1", "1.7"}],

Cell[TextData[{
  "You can override the interpretations by giving your own rules for ",
  StyleBox["MakeExpression", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.12.1", "1.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Letters and letter\[Hyphen]like forms "], Cell[
            "used in symbol names "]},
          {Cell["Infix operators "], Cell[TextData[{
              "e.g. ",
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell["Prefix operators "], Cell[TextData[{
              "e.g. ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Not] \)], "InlineFormula"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell["Postfix operators "], Cell[TextData[{
              "e.g. ",
              StyleBox["x", "TI"],
              StyleBox["!", "MR"],
              " "
            }]]},
          {Cell["Matchfix operators "], Cell[TextData[{
              "e.g. ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
              
              StyleBox["x", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[RightAngleBracket]\)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell["Compound operators "], Cell[TextData[{
              "e.g. ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
              " ",
              StyleBox["f", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell["Raw operators "], 
            Cell["\<\
operator characters that can be typed on an ordinary \
keyboard \
\>"]},
          {Cell["Spacing characters "], Cell[
            "interpreted in the same way as an ordinary space "]},
          {Cell["Structural elements "], 
            Cell["\<\
characters used to specify structure; usually ignored \
in interpretation \
\>"]},
          {Cell["Uninterpretable elements "], Cell[
            "characters indicating missing information "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.12.1"],

Cell["Types of characters. ", "Caption",
  CellTags->"SA.12.1"],

Cell[TextData[{
  "The precedences of operators are given in Section\[NonBreakingSpace]",
  ButtonBox["A.2.7",
    ButtonData:>{"A.2.7", "7.3"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"SA.12.1", "1.9"}],

Cell[TextData[{
  "Infix operators for which no grouping is specified in the listing are \
interpreted so that for example ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  " becomes ",
  StyleBox["CirclePlus[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"SA.12.1", "1.10"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Naming Conventions", "Subsubsection",
  CellTags->{"SA.12.1", "1.11"}],

Cell[TextData[{
  "Characters that correspond to built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions typically have names corresponding to those functions. Other \
characters typically have names that are as generic as possible. "
}], "Text",
  CellTags->{"SA.12.1", "1.12"}],

Cell["\<\
Characters with different names almost always look at least \
slightly different. \
\>", "Text",
  CellTags->{"SA.12.1", "1.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Capital", "MR"],
              "\[Ellipsis]",
              StyleBox["]", "MR"],
              " "
            }]], Cell["upper\[Hyphen]case form of a letter "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Left", "MR"],
              "\[Ellipsis]",
              StyleBox["]", "MR"],
              "  and  \[Backslash]",
              StyleBox["[Right", "MR"],
              "\[Ellipsis]",
              StyleBox["]", "MR"],
              " "
            }]], Cell["pieces of a matchfix operator (also arrows) "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Raw", "MR"],
              "\[Ellipsis]",
              StyleBox["]", "MR"],
              " "
            }]], Cell["a printable ASCII character "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[", "MR"],
              "\[Ellipsis]",
              StyleBox["Indicator]", "MR"],
              " "
            }]], Cell["a visual representation of a keyboard character "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.12.1"],

Cell["Some special classes of characters. ", "Caption",
  CellTags->"SA.12.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["style "], Cell[TextData[{
              StyleBox["Script", "MR"],
              ", ",
              StyleBox["Gothic", "MR"],
              ", etc. "
            }]]},
          {Cell["variation "], Cell[TextData[{
              StyleBox["Curly", "MR"],
              ", ",
              StyleBox["Gray", "MR"],
              ", etc. "
            }]]},
          {Cell["case "], Cell[TextData[{
              StyleBox["Capital", "MR"],
              ", etc. "
            }]]},
          {Cell["modifiers "], Cell[TextData[{
              StyleBox["Not", "MR"],
              ", ",
              StyleBox["Double", "MR"],
              ", ",
              StyleBox["Nested", "MR"],
              ", etc. "
            }]]},
          {Cell["direction "], Cell[TextData[{
              StyleBox["Left", "MR"],
              ", ",
              StyleBox["Up", "MR"],
              ", ",
              StyleBox["UpperRight", "MR"],
              ", etc. "
            }]]},
          {Cell["base "], Cell[TextData[{
              StyleBox["A", "MR"],
              ", ",
              StyleBox["Epsilon", "MR"],
              ", ",
              StyleBox["Plus", "MR"],
              ", etc. "
            }]]},
          {Cell["diacritical mark "], Cell[TextData[{
              StyleBox["Acute", "MR"],
              ", ",
              StyleBox["Ring", "MR"],
              ", etc. "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.12.1"],

Cell["Typical ordering of elements in character names. ", "Caption",
  CellTags->"SA.12.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Aliases", "Subsubsection",
  CellTags->{"SA.12.1", "1.14"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " supports both its own system of aliases, as well as aliases based on \
character names in TeX and SGML or HTML. Except where they conflict, \
character names corresponding to plain TeX, LaTeX and AMSTeX are all \
supported. Note that TeX and SGML or HTML aliases are not given explicitly in \
the list of characters below. "
}], "Text",
  CellTags->{"SA.12.1", "1.15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              StyleBox["xxx", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "ordinary ",
              StyleBox["Mathematica", "TI"],
              " alias "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              "\[Backslash]",
              StyleBox["xxx", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              " "
            }]], Cell["TeX alias "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              StyleBox["&", "MR"],
              StyleBox["xxx", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
              " "
            }]], Cell["SGML or HTML alias "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.12.1"],

Cell["Types of aliases. ", "Caption",
  CellTags->"SA.12.1"],

Cell["The following general conventions are used for all aliases: ", "Text",
  CellTags->{"SA.12.1", "1.16"}],

Cell[TextData[{
  "\[FilledSmallSquare] Characters that are alternatives to standard keyboard \
operators use these operators as their aliases (e.g. \[AliasIndicator]",
  StyleBox["->\[AliasIndicator]", "MR"],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
  ", \[AliasIndicator]",
  StyleBox["&&\[AliasIndicator]", "MR"],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\` \[And] \)], "InlineFormula"],
  ").  \n\[FilledSmallSquare] Most single\[Hyphen]letter aliases stand for \
Greek letters.  \n\[FilledSmallSquare] Capital\[Hyphen]letter characters have \
aliases beginning with capital letters.  \n\[FilledSmallSquare] When there is \
ambiguity in the assignment of aliases, a space is inserted at the beginning \
of the alias for the less common character (e.g. \[AliasIndicator]",
  StyleBox["->\[AliasIndicator]", "MR"],
  " for \[Backslash]",
  StyleBox["[Rule]", "MR"],
  " and \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  StyleBox["->\[AliasIndicator]", "MR"],
  " for \[Backslash]",
  StyleBox["[RightArrow]", "MR"],
  ").  \n\[FilledSmallSquare] ",
  StyleBox["!", "MR"],
  " is inserted at the beginning of the alias for a ",
  StyleBox["Not", "MR"],
  " character.  \n\[FilledSmallSquare] TeX aliases begin with a backslash \
\[Backslash].  \n\[FilledSmallSquare] SGML aliases begin with an ampersand ",
  StyleBox["&", "MR"],
  ".  \n\[FilledSmallSquare] User\[Hyphen]defined aliases conventionally \
begin with a dot or comma.  "
}], "Notes",
  CellTags->{"SA.12.1", "1.17"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Font Matching", "Subsubsection",
  CellTags->{"SA.12.1", "1.18"}],

Cell[TextData[{
  "The special fonts provided with ",
  StyleBox["Mathematica", "TI"],
  " include all the characters given in this listing. Some of these \
characters also appear in certain ordinary text fonts. "
}], "Text",
  CellTags->{"SA.12.1", "1.19"}],

Cell[TextData[{
  "When rendering text in a particular font, the ",
  StyleBox["Mathematica", "TI"],
  " notebook front end will use all the characters available in that font. It \
will use the special ",
  StyleBox["Mathematica", "TI"],
  " fonts only for other characters. "
}], "Text",
  CellTags->{"SA.12.1", "1.20"}],

Cell["\<\
A choice is made between Times\[Hyphen]like, Helvetica\[Hyphen]like \
(sans serif) and Courier\[Hyphen]like (monospaced) variants to achieve the \
best matching with the ordinary text font in use. \
\>", "Text",
  CellTags->{"SA.12.1", "1.21"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["AAcute", "ObjectName",
  CellTags->"S1.1001"],

Cell[TextData[{
  "\[AAcute]  \[Backslash]",
  StyleBox["[AAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1001"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["a'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1001"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1001"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1001"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1001"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalAAcute]",
    ButtonData:>{"CapitalAAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1001"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ABar", "ObjectName",
  CellTags->"S1.1002"],

Cell[TextData[{
  "\[ABar]  \[Backslash]",
  StyleBox["[ABar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1002"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["a-\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1002"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1002"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]4. ", "Notes",
  CellTags->"S1.1002"],

Cell["\<\
\[FilledSmallSquare] Used in transliterations of various non\
\[Hyphen]Latin alphabets. \
\>", "Notes",
  CellTags->"S1.1002"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1002"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalABar]",
    ButtonData:>{"CapitalABar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1002"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ACup", "ObjectName",
  CellTags->"S1.1003"],

Cell[TextData[{
  "\[ACup]  \[Backslash]",
  StyleBox["[ACup]", "MR"]
}], "CharacterName",
  CellTags->"S1.1003"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["au\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1003"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1003"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1003"],

Cell["\<\
\[FilledSmallSquare] Used in transliterations of Cyrillic \
characters. \
\>", "Notes",
  CellTags->"S1.1003"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1003"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalACup]",
    ButtonData:>{"CapitalACup"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1003"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ADoubleDot", "ObjectName",
  CellTags->"S1.1004"],

Cell[TextData[{
  "\[ADoubleDot]  \[Backslash]",
  StyleBox["[ADoubleDot]", "MR"]
}], "CharacterName",
  CellTags->"S1.1004"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["a\"\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1004"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1004"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1004"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1004"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalADoubleDot]",
    ButtonData:>{"CapitalADoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EDoubleDot]",
    ButtonData:>{"EDoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1004"]
}, Open  ]],

Cell[CellGroupData[{

Cell["AE", "ObjectName",
  CellTags->"S1.1005"],

Cell[TextData[{
  "\[AE]  \[Backslash]",
  StyleBox["[AE]", "MR"]
}], "CharacterName",
  CellTags->"S1.1005"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["ae\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1005"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1005"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1005"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1005"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalAE]",
    ButtonData:>{"CapitalAE"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1005"]
}, Open  ]],

Cell[CellGroupData[{

Cell["AGrave", "ObjectName",
  CellTags->"S1.1006"],

Cell[TextData[{
  "\[AGrave]  \[Backslash]",
  StyleBox["[AGrave]", "MR"]
}], "CharacterName",
  CellTags->"S1.1006"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["a`\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1006"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1006"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1006"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1006"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalAGrave]",
    ButtonData:>{"CapitalAGrave"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1006"]
}, Open  ]],

Cell[CellGroupData[{

Cell["AHat", "ObjectName",
  CellTags->"S1.1007"],

Cell[TextData[{
  "\[AHat]  \[Backslash]",
  StyleBox["[AHat]", "MR"]
}], "CharacterName",
  CellTags->"S1.1007"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["a^\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1007"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1007"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1007"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1007"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalAHat]",
    ButtonData:>{"CapitalAHat"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1007"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Aleph", "ObjectName",
  CellTags->"S1.1008"],

Cell[TextData[{
  "\[Aleph]  \[Backslash]",
  StyleBox["[Aleph]", "MR"]
}], "CharacterName",
  CellTags->"S1.1008"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["al\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1008"],

Cell["\[FilledSmallSquare] Hebrew letter. ", "Notes",
  CellTags->"S1.1008"],

Cell["\[FilledSmallSquare] Sometimes called alef. ", "Notes",
  CellTags->"S1.1008"],

Cell["\<\
\[FilledSmallSquare] Used in pure mathematics to denote transfinite \
cardinals. \
\>", "Notes",
  CellTags->"S1.1008"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1008"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Bet]",
    ButtonData:>{"Bet"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Gimel]",
    ButtonData:>{"Gimel"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Dalet]",
    ButtonData:>{"Dalet"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1008"]
}, Open  ]],

Cell[CellGroupData[{

Cell["AliasIndicator", "ObjectName",
  CellTags->"S1.1009"],

Cell[TextData[{
  "\[AliasIndicator]  \[Backslash]",
  StyleBox["[AliasIndicator]", "MR"]
}], "CharacterName",
  CellTags->"S1.1009"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["esc\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1009"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1009"],

Cell[TextData[{
  "\[FilledSmallSquare] Representation of the indicator for special character \
aliases in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1009"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[AliasIndicator]", "MR"],
  " is an inactive letter\[Hyphen]like form, used in describing how to type \
aliases. "
}], "Notes",
  CellTags->"S1.1009"],

Cell["\<\
\[FilledSmallSquare] An active character of the same appearance is \
typically obtained by typing Escape. \
\>", "Notes",
  CellTags->"S1.1009"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1009"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EscapeKey]",
    ButtonData:>{"EscapeKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SpaceIndicator]",
    ButtonData:>{"SpaceIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReturnIndicator]",
    ButtonData:>{"ReturnIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1009"]
}, Open  ]],

Cell[CellGroupData[{

Cell["AlignmentMarker", "ObjectName",
  CellTags->"S1.1010"],

Cell[TextData[{
  "\[AlignmentMarker]  \[Backslash]",
  StyleBox["[AlignmentMarker]", "MR"]
}], "CharacterName",
  CellTags->"S1.1010"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["am\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1010"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1010"],

Cell["\<\
\[FilledSmallSquare] Invisible by default on display. \
\>", "Notes",
  CellTags->"S1.1010"],

Cell[TextData[{
  "\[FilledSmallSquare] Used as a marker to indicate for example how entries \
in a ",
  StyleBox["GridBox", "MR"],
  " column should be lined up. "
}], "Notes",
  CellTags->"S1.1010"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.11"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1010"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][InvisibleComma]",
    ButtonData:>{"InvisibleComma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][InvisibleSpace]",
    ButtonData:>{"InvisibleSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Null]",
    ButtonData:>{"Null"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NoBreak]",
    ButtonData:>{"NoBreak"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1010"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Alpha", "ObjectName",
  CellTags->"S1.1011"],

Cell[TextData[{
  "\[Alpha]  \[Backslash]",
  StyleBox["[Alpha]", "MR"]
}], "CharacterName",
  CellTags->"S1.1011"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["a\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["alpha\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1011"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1011"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Proportional]",
    ButtonData:>{"Proportional"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1011"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1011"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalAlpha]",
    ButtonData:>{"CapitalAlpha"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1011"]
}, Open  ]],

Cell[CellGroupData[{

Cell["And", "ObjectName",
  CellTags->"S1.1012"],

Cell[TextData[{
  "\[And]  \[Backslash]",
  StyleBox["[And]", "MR"]
}], "CharacterName",
  CellTags->"S1.1012"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["&&\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["and\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1012"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1012"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[And] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["And[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ", equivalent to ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1012"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Wedge]",
    ButtonData:>{"Wedge"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1012"],

Cell[TextData[{
  "\[FilledSmallSquare] Drawn slightly larger than ",
  ButtonBox["\[Backslash][Wedge]",
    ButtonData:>{"Wedge"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1012"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.10"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1012"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Or]",
    ButtonData:>{"Or"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Nand]",
    ButtonData:>{"Nand"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Not]",
    ButtonData:>{"Not"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1012"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Angle", "ObjectName",
  CellTags->"S1.1013"],

Cell[TextData[{
  "\[Angle]  \[Backslash]",
  StyleBox["[Angle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1013"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1013"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in geometry to indicate an angle, as in the \
symbol ",
  Cell[BoxData[
      \(TraditionalForm\`\[Angle]\)], "InlineFormula"],
  " ",
  StyleBox["ABC", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1013"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.31"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1013"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][MeasuredAngle]",
    ButtonData:>{"MeasuredAngle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SphericalAngle]",
    ButtonData:>{"SphericalAngle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightAngle]",
    ButtonData:>{"RightAngle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1013"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Angstrom", "ObjectName",
  CellTags->"S1.1014"],

Cell[TextData[{
  "\[Angstrom]  \[Backslash]",
  StyleBox["[Angstrom]", "MR"]
}], "CharacterName",
  CellTags->"S1.1014"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["Ang\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1014"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1014"],

Cell[TextData[{
  "\[FilledSmallSquare] Unit corresponding to ",
  Cell[BoxData[
      \(TraditionalForm\`10\^\(-10\)\)], "InlineFormula"],
  " meters. "
}], "Notes",
  CellTags->"S1.1014"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as the letter ",
  ButtonBox["\[Backslash][CapitalARing]",
    ButtonData:>{"CapitalARing"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1014"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1014"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ARing]",
    ButtonData:>{"ARing"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Micro]",
    ButtonData:>{"Micro"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptySmallCircle]",
    ButtonData:>{"EmptySmallCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][HBar]",
    ButtonData:>{"HBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1014"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ARing", "ObjectName",
  CellTags->"S1.1015"],

Cell[TextData[{
  "\[ARing]  \[Backslash]",
  StyleBox["[ARing]", "MR"]
}], "CharacterName",
  CellTags->"S1.1015"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["ao\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1015"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1015"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1015"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1015"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalARing]",
    ButtonData:>{"CapitalARing"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptySmallCircle]",
    ButtonData:>{"EmptySmallCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1015"]
}, Open  ]],

Cell[CellGroupData[{

Cell["AscendingEllipsis", "ObjectName",
  CellTags->"S1.1016"],

Cell[TextData[{
  "\[AscendingEllipsis]  \[Backslash]",
  StyleBox["[AscendingEllipsis]", "MR"]
}], "CharacterName",
  CellTags->"S1.1016"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1016"],

Cell["\<\
\[FilledSmallSquare] Used to indicate omitted elements in a matrix. \
\
\>", "Notes",
  CellTags->"S1.1016"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1016"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DescendingEllipsis]",
    ButtonData:>{"DescendingEllipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VerticalEllipsis]",
    ButtonData:>{"VerticalEllipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Ellipsis]",
    ButtonData:>{"Ellipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1016"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ATilde", "ObjectName",
  CellTags->"S1.1017"],

Cell[TextData[{
  "\[ATilde]  \[Backslash]",
  StyleBox["[ATilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1017"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["a", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1017"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1017"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1017"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1017"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalATilde]",
    ButtonData:>{"CapitalATilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1017"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Backslash", "ObjectName",
  CellTags->"S1.1018"],

Cell[TextData[{
  "\[Backslash]  \[Backslash]",
  StyleBox["[Backslash]", "MR"]
}], "CharacterName",
  CellTags->"S1.1018"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["\\\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1018"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1018"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Backslash]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Backslash[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1018"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics for set difference. \
\>", \
"Notes",
  CellTags->"S1.1018"],

Cell["\<\
\[FilledSmallSquare] Also used to separate arguments of elliptic \
functions. \
\>", "Notes",
  CellTags->"S1.1018"],

Cell[TextData[{
  "\[FilledSmallSquare] Sometimes used to indicate ",
  StyleBox["x", "TI"],
  " divides ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1018"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1018"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawBackslash]",
    ButtonData:>{"RawBackslash"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Colon]",
    ButtonData:>{"Colon"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VerticalBar]",
    ButtonData:>{"VerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Continuation]",
    ButtonData:>{"Continuation"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1018"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Because", "ObjectName",
  CellTags->"S1.1019"],

Cell[TextData[{
  "\[Because]  \[Backslash]",
  StyleBox["[Because]", "MR"]
}], "CharacterName",
  CellTags->"S1.1019"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1019"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Because] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Because[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1019"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Because] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Because] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  " groups as ",
  StyleBox["(", "MR"],
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Because] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[")", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Because] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1019"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1019"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Therefore]",
    ButtonData:>{"Therefore"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTee]",
    ButtonData:>{"LeftTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledRectangle]",
    ButtonData:>{"FilledRectangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Proportion]",
    ButtonData:>{"Proportion"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1019"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bet", "ObjectName",
  CellTags->"S1.1020"],

Cell[TextData[{
  "\[Bet]  \[Backslash]",
  StyleBox["[Bet]", "MR"]
}], "CharacterName",
  CellTags->"S1.1020"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["be\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1020"],

Cell["\[FilledSmallSquare] Hebrew letter. ", "Notes",
  CellTags->"S1.1020"],

Cell["\[FilledSmallSquare] Sometimes called beth. ", "Notes",
  CellTags->"S1.1020"],

Cell["\<\
\[FilledSmallSquare] Used in pure mathematics in the theory of \
transfinite cardinals. \
\>", "Notes",
  CellTags->"S1.1020"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1020"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Aleph]",
    ButtonData:>{"Aleph"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1020"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Beta", "ObjectName",
  CellTags->"S1.1021"],

Cell[TextData[{
  "\[Beta]  \[Backslash]",
  StyleBox["[Beta]", "MR"]
}], "CharacterName",
  CellTags->"S1.1021"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["b\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["beta\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1021"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1021"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1021"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalBeta]",
    ButtonData:>{"CapitalBeta"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SZ]",
    ButtonData:>{"SZ"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1021"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Breve", "ObjectName",
  CellTags->"S1.1022"],

Cell[TextData[{
  "\[Breve]  \[Backslash]",
  StyleBox["[Breve]", "MR"]
}], "CharacterName",
  CellTags->"S1.1022"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["bv\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1022"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1022"],

Cell["\<\
\[FilledSmallSquare] Used in an overscript position as a \
diacritical mark. \
\>", "Notes",
  CellTags->"S1.1022"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.38"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1022"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownBreve]",
    ButtonData:>{"DownBreve"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Cup]",
    ButtonData:>{"Cup"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RoundSpaceIndicator]",
    ButtonData:>{"RoundSpaceIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Hacek]",
    ButtonData:>{"Hacek"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1022"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bullet", "ObjectName",
  CellTags->"S1.1023"],

Cell[TextData[{
  "\[Bullet]  \[Backslash]",
  StyleBox["[Bullet]", "MR"]
}], "CharacterName",
  CellTags->"S1.1023"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["bu\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1023"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1023"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1023"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][FilledSmallCircle]",
    ButtonData:>{"FilledSmallCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledCircle]",
    ButtonData:>{"FilledCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1023"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CAcute", "ObjectName",
  CellTags->"S1.1024"],

Cell[TextData[{
  "\[CAcute]  \[Backslash]",
  StyleBox["[CAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1024"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["c'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1024"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1024"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1024"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1024"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalCAcute]",
    ButtonData:>{"CapitalCAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1024"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cap", "ObjectName",
  CellTags->"S1.1025"],

Cell[TextData[{
  "\[Cap]  \[Backslash]",
  StyleBox["[Cap]", "MR"]
}], "CharacterName",
  CellTags->"S1.1025"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1025"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Cap]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Cap[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1025"],

Cell["\<\
\[FilledSmallSquare] Used in pure mathematics to mean cap product. \
\
\>", "Notes",
  CellTags->"S1.1025"],

Cell["\<\
\[FilledSmallSquare] Sometimes used as an overscript to indicate \
arc between. \
\>", "Notes",
  CellTags->"S1.1025"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1025"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Cup]",
    ButtonData:>{"Cup"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Intersection]",
    ButtonData:>{"Intersection"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CupCap]",
    ButtonData:>{"CupCap"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownBreve]",
    ButtonData:>{"DownBreve"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1025"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalAAcute", "ObjectName",
  CellTags->"S1.1026"],

Cell[TextData[{
  "\[CapitalAAcute]  \[Backslash]",
  StyleBox["[CapitalAAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1026"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["A'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1026"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1026"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1026"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1026"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][AAcute]",
    ButtonData:>{"AAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1026"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalABar", "ObjectName",
  CellTags->"S1.1027"],

Cell[TextData[{
  "\[CapitalABar]  \[Backslash]",
  StyleBox["[CapitalABar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1027"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["A-\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1027"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1027"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]4. ", "Notes",
  CellTags->"S1.1027"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1027"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ABar]",
    ButtonData:>{"ABar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1027"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalACup", "ObjectName",
  CellTags->"S1.1028"],

Cell[TextData[{
  "\[CapitalACup]  \[Backslash]",
  StyleBox["[CapitalACup]", "MR"]
}], "CharacterName",
  CellTags->"S1.1028"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["Au\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1028"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1028"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1028"],

Cell["\<\
\[FilledSmallSquare] Used in transliterations of Cyrillic \
characters. \
\>", "Notes",
  CellTags->"S1.1028"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1028"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ACup]",
    ButtonData:>{"ACup"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1028"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalADoubleDot", "ObjectName",
  CellTags->"S1.1029"],

Cell[TextData[{
  "\[CapitalADoubleDot]  \[Backslash]",
  StyleBox["[CapitalADoubleDot]", "MR"]
}], "CharacterName",
  CellTags->"S1.1029"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["A\"\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1029"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1029"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1029"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1029"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ADoubleDot]",
    ButtonData:>{"ADoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1029"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalAE", "ObjectName",
  CellTags->"S1.1030"],

Cell[TextData[{
  "\[CapitalAE]  \[Backslash]",
  StyleBox["[CapitalAE]", "MR"]
}], "CharacterName",
  CellTags->"S1.1030"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["AE\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1030"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1030"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1030"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1030"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][AE]",
    ButtonData:>{"AE"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1030"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalAGrave", "ObjectName",
  CellTags->"S1.1031"],

Cell[TextData[{
  "\[CapitalAGrave]  \[Backslash]",
  StyleBox["[CapitalAGrave]", "MR"]
}], "CharacterName",
  CellTags->"S1.1031"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["A`\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1031"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1031"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1031"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1031"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][AGrave]",
    ButtonData:>{"AGrave"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1031"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalAHat", "ObjectName",
  CellTags->"S1.1032"],

Cell[TextData[{
  "\[CapitalAHat]  \[Backslash]",
  StyleBox["[CapitalAHat]", "MR"]
}], "CharacterName",
  CellTags->"S1.1032"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["A^\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1032"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1032"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1032"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1032"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][AHat]",
    ButtonData:>{"AHat"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1032"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalAlpha", "ObjectName",
  CellTags->"S1.1033"],

Cell[TextData[{
  "\[CapitalAlpha]  \[Backslash]",
  StyleBox["[CapitalAlpha]", "MR"]
}], "CharacterName",
  CellTags->"S1.1033"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["A\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Alpha\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1033"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1033"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English ",
  StyleBox["A", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1033"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.27"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1033"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Alpha]",
    ButtonData:>{"Alpha"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1033"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalARing", "ObjectName",
  CellTags->"S1.1034"],

Cell[TextData[{
  "\[CapitalARing]  \[Backslash]",
  StyleBox["[CapitalARing]", "MR"]
}], "CharacterName",
  CellTags->"S1.1034"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["Ao\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1034"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1034"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1034"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Angstrom]",
    ButtonData:>{"Angstrom"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1034"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1034"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ARing]",
    ButtonData:>{"ARing"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1034"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalATilde", "ObjectName",
  CellTags->"S1.1035"],

Cell[TextData[{
  "\[CapitalATilde]  \[Backslash]",
  StyleBox["[CapitalATilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1035"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["A", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1035"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1035"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1035"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1035"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ATilde]",
    ButtonData:>{"ATilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1035"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalBeta", "ObjectName",
  CellTags->"S1.1036"],

Cell[TextData[{
  "\[CapitalBeta]  \[Backslash]",
  StyleBox["[CapitalBeta]", "MR"]
}], "CharacterName",
  CellTags->"S1.1036"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["B\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Beta\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1036"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1036"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["Beta", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1036"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English ",
  StyleBox["B", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1036"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1036"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Beta]",
    ButtonData:>{"Beta"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1036"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalCAcute", "ObjectName",
  CellTags->"S1.1037"],

Cell[TextData[{
  "\[CapitalCAcute]  \[Backslash]",
  StyleBox["[CapitalCAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1037"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["C'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1037"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1037"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1037"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1037"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CAcute]",
    ButtonData:>{"CAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1037"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalCCedilla", "ObjectName",
  CellTags->"S1.1038"],

Cell[TextData[{
  "\[CapitalCCedilla]  \[Backslash]",
  StyleBox["[CapitalCCedilla]", "MR"]
}], "CharacterName",
  CellTags->"S1.1038"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["C,\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1038"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1038"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1038"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1038"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CCedilla]",
    ButtonData:>{"CCedilla"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1038"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalCHacek", "ObjectName",
  CellTags->"S1.1039"],

Cell[TextData[{
  "\[CapitalCHacek]  \[Backslash]",
  StyleBox["[CapitalCHacek]", "MR"]
}], "CharacterName",
  CellTags->"S1.1039"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["Cv\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1039"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1039"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1039"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1039"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CHacek]",
    ButtonData:>{"CHacek"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1039"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalChi", "ObjectName",
  CellTags->"S1.1040"],

Cell[TextData[{
  "\[CapitalChi]  \[Backslash]",
  StyleBox["[CapitalChi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1040"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["Ch\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Chi\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["C\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1040"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1040"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English ",
  StyleBox["X", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1040"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1040"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Chi]",
    ButtonData:>{"Chi"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalXi]",
    ButtonData:>{"CapitalXi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1040"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalDelta", "ObjectName",
  CellTags->"S1.1041"],

Cell[TextData[{
  "\[CapitalDelta]  \[Backslash]",
  StyleBox["[CapitalDelta]", "MR"]
}], "CharacterName",
  CellTags->"S1.1041"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["D\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Delta\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1041"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1041"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][EmptyUpTriangle]",
    ButtonData:>{"EmptyUpTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1041"],

Cell["\<\
\[FilledSmallSquare] Sometimes used in mathematics to denote \
Laplacian. \
\>", "Notes",
  CellTags->"S1.1041"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1041"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Delta]",
    ButtonData:>{"Delta"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Del]",
    ButtonData:>{"Del"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1041"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalDifferentialD", "ObjectName",
  CellTags->"S1.1042"],

Cell[TextData[{
  "\[CapitalDifferentialD]  \[Backslash]",
  StyleBox["[CapitalDifferentialD]", "MR"]
}], "CharacterName",
  CellTags->"S1.1042"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["DD\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1042"],

Cell["\[FilledSmallSquare] Compound operator. ", "Notes",
  CellTags->"S1.1042"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDifferentialD]\)], "InlineFormula"],
  " can only be interpreted by default when it appears with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
  " or other integral operators. "
}], "Notes",
  CellTags->"S1.1042"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate a functional \
differential. \
\>", "Notes",
  CellTags->"S1.1042"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.26"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1042"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DifferentialD]",
    ButtonData:>{"DifferentialD"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleStruckD]",
    ButtonData:>{"DoubleStruckA"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1042"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalDigamma", "ObjectName",
  CellTags->"S1.1043"],

Cell[TextData[{
  "\[CapitalDigamma]  \[Backslash]",
  StyleBox["[CapitalDigamma]", "MR"]
}], "CharacterName",
  CellTags->"S1.1043"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["Di\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Digamma\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1043"],

Cell["\[FilledSmallSquare] Special Greek letter. ", "Notes",
  CellTags->"S1.1043"],

Cell[TextData[{
  "\[FilledSmallSquare] Analogous to English ",
  StyleBox["W", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1043"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1043"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Digamma]",
    ButtonData:>{"Digamma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1043"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalEAcute", "ObjectName",
  CellTags->"S1.1044"],

Cell[TextData[{
  "\[CapitalEAcute]  \[Backslash]",
  StyleBox["[CapitalEAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1044"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["E'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1044"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1044"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1044"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1044"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EAcute]",
    ButtonData:>{"EAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1044"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalEBar", "ObjectName",
  CellTags->"S1.1045"],

Cell[TextData[{
  "\[CapitalEBar]  \[Backslash]",
  StyleBox["[CapitalEBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1045"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["E-\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1045"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1045"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]4. ", "Notes",
  CellTags->"S1.1045"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1045"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EBar]",
    ButtonData:>{"EBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1045"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalECup", "ObjectName",
  CellTags->"S1.1046"],

Cell[TextData[{
  "\[CapitalECup]  \[Backslash]",
  StyleBox["[CapitalECup]", "MR"]
}], "CharacterName",
  CellTags->"S1.1046"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["Eu\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1046"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1046"],

Cell["\[FilledSmallSquare] Not included in ISO Latin. ", "Notes",
  CellTags->"S1.1046"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1046"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ECup]",
    ButtonData:>{"ECup"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1046"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalEDoubleDot", "ObjectName",
  CellTags->"S1.1047"],

Cell[TextData[{
  "\[CapitalEDoubleDot]  \[Backslash]",
  StyleBox["[CapitalEDoubleDot]", "MR"]
}], "CharacterName",
  CellTags->"S1.1047"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["E\"\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1047"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1047"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1047"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1047"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EDoubleDot]",
    ButtonData:>{"EDoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1047"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalEGrave", "ObjectName",
  CellTags->"S1.1048"],

Cell[TextData[{
  "\[CapitalEGrave]  \[Backslash]",
  StyleBox["[CapitalEGrave]", "MR"]
}], "CharacterName",
  CellTags->"S1.1048"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["E`\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1048"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1048"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1048"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1048"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EGrave]",
    ButtonData:>{"EGrave"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1048"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalEHat", "ObjectName",
  CellTags->"S1.1049"],

Cell[TextData[{
  "\[CapitalEHat]  \[Backslash]",
  StyleBox["[CapitalEHat]", "MR"]
}], "CharacterName",
  CellTags->"S1.1049"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["E^\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1049"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1049"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1049"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1049"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EHat]",
    ButtonData:>{"EHat"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1049"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalEpsilon", "ObjectName",
  CellTags->"S1.1050"],

Cell[TextData[{
  "\[CapitalEpsilon]  \[Backslash]",
  StyleBox["[CapitalEpsilon]", "MR"]
}], "CharacterName",
  CellTags->"S1.1050"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["E\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Epsilon\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1050"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1050"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English ",
  StyleBox["E", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1050"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1050"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Epsilon]",
    ButtonData:>{"Epsilon"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1050"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalEta", "ObjectName",
  CellTags->"S1.1051"],

Cell[TextData[{
  "\[CapitalEta]  \[Backslash]",
  StyleBox["[CapitalEta]", "MR"]
}], "CharacterName",
  CellTags->"S1.1051"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["Et\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Eta\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["H\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1051"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1051"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English ",
  StyleBox["H", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1051"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1051"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Eta]",
    ButtonData:>{"Eta"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1051"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalEth", "ObjectName",
  CellTags->"S1.1052"],

Cell[TextData[{
  "\[CapitalEth]  \[Backslash]",
  StyleBox["[CapitalEth]", "MR"]
}], "CharacterName",
  CellTags->"S1.1052"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["D-\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1052"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1052"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1052"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1052"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Eth]",
    ButtonData:>{"Eth"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1052"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalGamma", "ObjectName",
  CellTags->"S1.1053"],

Cell[TextData[{
  "\[CapitalGamma]  \[Backslash]",
  StyleBox["[CapitalGamma]", "MR"]
}], "CharacterName",
  CellTags->"S1.1053"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["G\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Gamma\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1053"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1053"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["Gamma", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1053"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1053"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Gamma]",
    ButtonData:>{"Gamma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalDigamma]",
    ButtonData:>{"CapitalDigamma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1053"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalIAcute", "ObjectName",
  CellTags->"S1.1054"],

Cell[TextData[{
  "\[CapitalIAcute]  \[Backslash]",
  StyleBox["[CapitalIAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1054"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["I'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1054"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1054"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1054"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1054"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][IAcute]",
    ButtonData:>{"IAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1054"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalICup", "ObjectName",
  CellTags->"S1.1055"],

Cell[TextData[{
  "\[CapitalICup]  \[Backslash]",
  StyleBox["[CapitalICup]", "MR"]
}], "CharacterName",
  CellTags->"S1.1055"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["Iu\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1055"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1055"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1055"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1055"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ICup]",
    ButtonData:>{"ICup"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1055"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalIDoubleDot", "ObjectName",
  CellTags->"S1.1056"],

Cell[TextData[{
  "\[CapitalIDoubleDot]  \[Backslash]",
  StyleBox["[CapitalIDoubleDot]", "MR"]
}], "CharacterName",
  CellTags->"S1.1056"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["I\"\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1056"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1056"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1056"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1056"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][IDoubleDot]",
    ButtonData:>{"IDoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1056"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalIGrave", "ObjectName",
  CellTags->"S1.1057"],

Cell[TextData[{
  "\[CapitalIGrave]  \[Backslash]",
  StyleBox["[CapitalIGrave]", "MR"]
}], "CharacterName",
  CellTags->"S1.1057"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["I`\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1057"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1057"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1057"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1057"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][IGrave]",
    ButtonData:>{"IGrave"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1057"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalIHat", "ObjectName",
  CellTags->"S1.1058"],

Cell[TextData[{
  "\[CapitalIHat]  \[Backslash]",
  StyleBox["[CapitalIHat]", "MR"]
}], "CharacterName",
  CellTags->"S1.1058"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["I^\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1058"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1058"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1058"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1058"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][IHat]",
    ButtonData:>{"IHat"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1058"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalIota", "ObjectName",
  CellTags->"S1.1059"],

Cell[TextData[{
  "\[CapitalIota]  \[Backslash]",
  StyleBox["[CapitalIota]", "MR"]
}], "CharacterName",
  CellTags->"S1.1059"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["I\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Iota\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1059"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1059"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English ",
  StyleBox["I", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1059"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1059"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Iota]",
    ButtonData:>{"Iota"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1059"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalKappa", "ObjectName",
  CellTags->"S1.1060"],

Cell[TextData[{
  "\[CapitalKappa]  \[Backslash]",
  StyleBox["[CapitalKappa]", "MR"]
}], "CharacterName",
  CellTags->"S1.1060"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["K\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Kappa\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1060"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1060"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English ",
  StyleBox["K", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1060"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1060"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Kappa]",
    ButtonData:>{"Kappa"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1060"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalKoppa", "ObjectName",
  CellTags->"S1.1061"],

Cell[TextData[{
  "\[CapitalKoppa]  \[Backslash]",
  StyleBox["[CapitalKoppa]", "MR"]
}], "CharacterName",
  CellTags->"S1.1061"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["Ko\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Koppa\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1061"],

Cell["\[FilledSmallSquare] Special Greek letter. ", "Notes",
  CellTags->"S1.1061"],

Cell[TextData[{
  "\[FilledSmallSquare] Analogous to English ",
  StyleBox["Q", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1061"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1061"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Koppa]",
    ButtonData:>{"Koppa"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1061"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalLambda", "ObjectName",
  CellTags->"S1.1062"],

Cell[TextData[{
  "\[CapitalLambda]  \[Backslash]",
  StyleBox["[CapitalLambda]", "MR"]
}], "CharacterName",
  CellTags->"S1.1062"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["L\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Lambda\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1062"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1062"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Wedge]",
    ButtonData:>{"Wedge"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1062"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1062"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Lambda]",
    ButtonData:>{"Lambda"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1062"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalLSlash", "ObjectName",
  CellTags->"S1.1063"],

Cell[TextData[{
  "\[CapitalLSlash]  \[Backslash]",
  StyleBox["[CapitalLSlash]", "MR"]
}], "CharacterName",
  CellTags->"S1.1063"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["L/\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1063"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1063"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1063"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1063"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LSlash]",
    ButtonData:>{"LSlash"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1063"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalMu", "ObjectName",
  CellTags->"S1.1064"],

Cell[TextData[{
  "\[CapitalMu]  \[Backslash]",
  StyleBox["[CapitalMu]", "MR"]
}], "CharacterName",
  CellTags->"S1.1064"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["M\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Mu\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1064"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1064"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English ",
  StyleBox["M", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1064"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1064"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Mu]",
    ButtonData:>{"Mu"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1064"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalNTilde", "ObjectName",
  CellTags->"S1.1065"],

Cell[TextData[{
  "\[CapitalNTilde]  \[Backslash]",
  StyleBox["[CapitalNTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1065"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["N", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1065"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1065"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1065"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1065"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NTilde]",
    ButtonData:>{"NTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1065"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalNu", "ObjectName",
  CellTags->"S1.1066"],

Cell[TextData[{
  "\[CapitalNu]  \[Backslash]",
  StyleBox["[CapitalNu]", "MR"]
}], "CharacterName",
  CellTags->"S1.1066"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["N\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Nu\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1066"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1066"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English ",
  StyleBox["N", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1066"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1066"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Nu]",
    ButtonData:>{"Nu"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1066"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalOAcute", "ObjectName",
  CellTags->"S1.1067"],

Cell[TextData[{
  "\[CapitalOAcute]  \[Backslash]",
  StyleBox["[CapitalOAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1067"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["O'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1067"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1067"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1067"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1067"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][OAcute]",
    ButtonData:>{"OAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1067"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalODoubleAcute", "ObjectName",
  CellTags->"S1.1068"],

Cell[TextData[{
  "\[CapitalODoubleAcute]  \[Backslash]",
  StyleBox["[CapitalODoubleAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1068"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["O''\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1068"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1068"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1068"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1068"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ODoubleAcute]",
    ButtonData:>{"ODoubleAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1068"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalODoubleDot", "ObjectName",
  CellTags->"S1.1069"],

Cell[TextData[{
  "\[CapitalODoubleDot]  \[Backslash]",
  StyleBox["[CapitalODoubleDot]", "MR"]
}], "CharacterName",
  CellTags->"S1.1069"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["O\"\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1069"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1069"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1069"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1069"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ODoubleDot]",
    ButtonData:>{"ODoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1069"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalOGrave", "ObjectName",
  CellTags->"S1.1070"],

Cell[TextData[{
  "\[CapitalOGrave]  \[Backslash]",
  StyleBox["[CapitalOGrave]", "MR"]
}], "CharacterName",
  CellTags->"S1.1070"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["O`\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1070"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1070"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1070"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1070"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][OGrave]",
    ButtonData:>{"OGrave"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1070"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalOHat", "ObjectName",
  CellTags->"S1.1071"],

Cell[TextData[{
  "\[CapitalOHat]  \[Backslash]",
  StyleBox["[CapitalOHat]", "MR"]
}], "CharacterName",
  CellTags->"S1.1071"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["O^\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1071"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1071"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1071"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1071"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][OHat]",
    ButtonData:>{"OHat"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1071"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalOmega", "ObjectName",
  CellTags->"S1.1072"],

Cell[TextData[{
  "\[CapitalOmega]  \[Backslash]",
  StyleBox["[CapitalOmega]", "MR"]
}], "CharacterName",
  CellTags->"S1.1072"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["O\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Omega\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["W\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1072"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1072"],

Cell["\<\
\[FilledSmallSquare] Used as the symbol for ohms. \
\>", "Notes",
  CellTags->"S1.1072"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1072"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Omega]",
    ButtonData:>{"Omega"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Mho]",
    ButtonData:>{"Mho"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1072"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalOmicron", "ObjectName",
  CellTags->"S1.1073"],

Cell[TextData[{
  "\[CapitalOmicron]  \[Backslash]",
  StyleBox["[CapitalOmicron]", "MR"]
}], "CharacterName",
  CellTags->"S1.1073"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["Om\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Omicron\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1073"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1073"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English ",
  StyleBox["O", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1073"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1073"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Omicron]",
    ButtonData:>{"Omicron"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1073"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalOSlash", "ObjectName",
  CellTags->"S1.1074"],

Cell[TextData[{
  "\[CapitalOSlash]  \[Backslash]",
  StyleBox["[CapitalOSlash]", "MR"]
}], "CharacterName",
  CellTags->"S1.1074"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["O/\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1074"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1074"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1074"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][EmptySet]",
    ButtonData:>{"EmptySet"},
    ButtonStyle->"MainBookLinkMR"],
  " or ",
  ButtonBox["\[Backslash][Diameter]",
    ButtonData:>{"Diameter"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1074"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.27"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1074"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][OSlash]",
    ButtonData:>{"OSlash"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1074"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalOTilde", "ObjectName",
  CellTags->"S1.1075"],

Cell[TextData[{
  "\[CapitalOTilde]  \[Backslash]",
  StyleBox["[CapitalOTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1075"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["O", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1075"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1075"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1075"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1075"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][OTilde]",
    ButtonData:>{"OTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1075"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalPhi", "ObjectName",
  CellTags->"S1.1076"],

Cell[TextData[{
  "\[CapitalPhi]  \[Backslash]",
  StyleBox["[CapitalPhi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1076"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["Ph\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Phi\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["F\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1076"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1076"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["LerchPhi", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1076"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1076"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Phi]",
    ButtonData:>{"Phi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1076"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalPi", "ObjectName",
  CellTags->"S1.1077"],

Cell[TextData[{
  "\[CapitalPi]  \[Backslash]",
  StyleBox["[CapitalPi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1077"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["P\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Pi\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1077"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1077"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["EllipticPi", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1077"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Product]",
    ButtonData:>{"Product"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1077"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1077"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Pi]",
    ButtonData:>{"Pi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1077"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalPsi", "ObjectName",
  CellTags->"S1.1078"],

Cell[TextData[{
  "\[CapitalPsi]  \[Backslash]",
  StyleBox["[CapitalPsi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1078"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["Ps\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Psi\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Y\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1078"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1078"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1078"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Psi]",
    ButtonData:>{"Psi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1078"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalRho", "ObjectName",
  CellTags->"S1.1079"],

Cell[TextData[{
  "\[CapitalRho]  \[Backslash]",
  StyleBox["[CapitalRho]", "MR"]
}], "CharacterName",
  CellTags->"S1.1079"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["R\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Rho\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1079"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1079"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English ",
  StyleBox["P", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1079"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1079"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Rho]",
    ButtonData:>{"Rho"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1079"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalSampi", "ObjectName",
  CellTags->"S1.1080"],

Cell[TextData[{
  "\[CapitalSampi]  \[Backslash]",
  StyleBox["[CapitalSampi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1080"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["Sa\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Sampi\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1080"],

Cell["\[FilledSmallSquare] Special Greek letter. ", "Notes",
  CellTags->"S1.1080"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1080"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Sampi]",
    ButtonData:>{"Sampi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1080"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalSHacek", "ObjectName",
  CellTags->"S1.1081"],

Cell[TextData[{
  "\[CapitalSHacek]  \[Backslash]",
  StyleBox["[CapitalSHacek]", "MR"]
}], "CharacterName",
  CellTags->"S1.1081"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["Sv\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1081"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1081"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1081"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1081"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][SHacek]",
    ButtonData:>{"SHacek"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1081"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalSigma", "ObjectName",
  CellTags->"S1.1082"],

Cell[TextData[{
  "\[CapitalSigma]  \[Backslash]",
  StyleBox["[CapitalSigma]", "MR"]
}], "CharacterName",
  CellTags->"S1.1082"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["S\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Sigma\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1082"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1082"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Sum]",
    ButtonData:>{"Sum"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1082"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1082"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Sigma]",
    ButtonData:>{"Sigma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1082"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalStigma", "ObjectName",
  CellTags->"S1.1083"],

Cell[TextData[{
  "\[CapitalStigma]  \[Backslash]",
  StyleBox["[CapitalStigma]", "MR"]
}], "CharacterName",
  CellTags->"S1.1083"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["Sti\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Stigma\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1083"],

Cell["\[FilledSmallSquare] Special Greek letter. ", "Notes",
  CellTags->"S1.1083"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1083"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Stigma]",
    ButtonData:>{"Stigma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1083"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalTau", "ObjectName",
  CellTags->"S1.1084"],

Cell[TextData[{
  "\[CapitalTau]  \[Backslash]",
  StyleBox["[CapitalTau]", "MR"]
}], "CharacterName",
  CellTags->"S1.1084"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["T\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Tau\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1084"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1084"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English ",
  StyleBox["T", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1084"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1084"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Tau]",
    ButtonData:>{"Tau"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1084"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalTheta", "ObjectName",
  CellTags->"S1.1085"],

Cell[TextData[{
  "\[CapitalTheta]  \[Backslash]",
  StyleBox["[CapitalTheta]", "MR"]
}], "CharacterName",
  CellTags->"S1.1085"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["Th\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Theta\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Q\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1085"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1085"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1085"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Theta]",
    ButtonData:>{"Theta"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1085"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalThorn", "ObjectName",
  CellTags->"S1.1086"],

Cell[TextData[{
  "\[CapitalThorn]  \[Backslash]",
  StyleBox["[CapitalThorn]", "MR"]
}], "CharacterName",
  CellTags->"S1.1086"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["Thn\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1086"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1086"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1086"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1086"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Thorn]",
    ButtonData:>{"Thorn"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1086"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalUAcute", "ObjectName",
  CellTags->"S1.1087"],

Cell[TextData[{
  "\[CapitalUAcute]  \[Backslash]",
  StyleBox["[CapitalUAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1087"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["U'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1087"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1087"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1087"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1087"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UAcute]",
    ButtonData:>{"UAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1087"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalUDoubleAcute", "ObjectName",
  CellTags->"S1.1088"],

Cell[TextData[{
  "\[CapitalUDoubleAcute]  \[Backslash]",
  StyleBox["[CapitalUDoubleAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1088"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["U''\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1088"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1088"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1088"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1088"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UDoubleAcute]",
    ButtonData:>{"UDoubleAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1088"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalUDoubleDot", "ObjectName",
  CellTags->"S1.1089"],

Cell[TextData[{
  "\[CapitalUDoubleDot]  \[Backslash]",
  StyleBox["[CapitalUDoubleDot]", "MR"]
}], "CharacterName",
  CellTags->"S1.1089"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["U\"\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1089"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1089"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1089"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1089"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UDoubleDot]",
    ButtonData:>{"UDoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1089"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalUGrave", "ObjectName",
  CellTags->"S1.1090"],

Cell[TextData[{
  "\[CapitalUGrave]  \[Backslash]",
  StyleBox["[CapitalUGrave]", "MR"]
}], "CharacterName",
  CellTags->"S1.1090"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["U`\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1090"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1090"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1090"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1090"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UGrave]",
    ButtonData:>{"UGrave"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1090"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalUHat", "ObjectName",
  CellTags->"S1.1091"],

Cell[TextData[{
  "\[CapitalUHat]  \[Backslash]",
  StyleBox["[CapitalUHat]", "MR"]
}], "CharacterName",
  CellTags->"S1.1091"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["U^\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1091"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1091"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1091"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1091"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UHat]",
    ButtonData:>{"UHat"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1091"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalUpsilon", "ObjectName",
  CellTags->"S1.1092"],

Cell[TextData[{
  "\[CapitalUpsilon]  \[Backslash]",
  StyleBox["[CapitalUpsilon]", "MR"]
}], "CharacterName",
  CellTags->"S1.1092"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["U\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Upsilon\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1092"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1092"],

Cell["\[FilledSmallSquare] Not commonly used. ", "Notes",
  CellTags->"S1.1092"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in physics for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["b",
            "TI"], 
          OverscriptBox[
            StyleBox["b",
              "TI"], "_"]}], TraditionalForm]], "InlineFormula"],
  " particles, and in the quantum theory of measurement. "
}], "Notes",
  CellTags->"S1.1092"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1092"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CurlyCapitalUpsilon]",
    ButtonData:>{"CurlyCapitalUpsilon"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Upsilon]",
    ButtonData:>{"Upsilon"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1092"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalXi", "ObjectName",
  CellTags->"S1.1093"],

Cell[TextData[{
  "\[CapitalXi]  \[Backslash]",
  StyleBox["[CapitalXi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1093"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["X\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Xi\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1093"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1093"],

Cell["\[FilledSmallSquare] Not commonly used. ", "Notes",
  CellTags->"S1.1093"],

Cell["\<\
\[FilledSmallSquare] Used for grand canonical partition function, \
cascade hyperon and regular language complexity. \
\>", "Notes",
  CellTags->"S1.1093"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1093"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Xi]",
    ButtonData:>{"Xi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1093"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalYAcute", "ObjectName",
  CellTags->"S1.1094"],

Cell[TextData[{
  "\[CapitalYAcute]  \[Backslash]",
  StyleBox["[CapitalYAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1094"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["Y'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1094"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1094"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1094"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1094"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][YAcute]",
    ButtonData:>{"YAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1094"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CapitalZeta", "ObjectName",
  CellTags->"S1.1095"],

Cell[TextData[{
  "\[CapitalZeta]  \[Backslash]",
  StyleBox["[CapitalZeta]", "MR"]
}], "CharacterName",
  CellTags->"S1.1095"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["Z\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["Zeta\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1095"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1095"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["JacobiZeta", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1095"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English\[NonBreakingSpace]",
  StyleBox["Z", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1095"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1095"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Zeta]",
    ButtonData:>{"Zeta"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1095"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CCedilla", "ObjectName",
  CellTags->"S1.1096"],

Cell[TextData[{
  "\[CCedilla]  \[Backslash]",
  StyleBox["[CCedilla]", "MR"]
}], "CharacterName",
  CellTags->"S1.1096"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["c,\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1096"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1096"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1096"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1096"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalCCedilla]",
    ButtonData:>{"CapitalCCedilla"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1096"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cedilla", "ObjectName",
  CellTags->"S1.1097"],

Cell[TextData[{
  "\[Cedilla]  \[Backslash]",
  StyleBox["[Cedilla]", "MR"]
}], "CharacterName",
  CellTags->"S1.1097"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["cd\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1097"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1097"],

Cell["\<\
\[FilledSmallSquare] Used in an underscript position as a \
diacritical mark. \
\>", "Notes",
  CellTags->"S1.1097"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.38"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1097"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Hacek]",
    ButtonData:>{"Hacek"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Breve]",
    ButtonData:>{"Breve"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1097"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cent", "ObjectName",
  CellTags->"S1.1098"],

Cell[TextData[{
  "\[Cent]  \[Backslash]",
  StyleBox["[Cent]", "MR"]
}], "CharacterName",
  CellTags->"S1.1098"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["cent\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1098"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1098"],

Cell[TextData[{
  "\[FilledSmallSquare] Currency symbol, used as in ",
  StyleBox["5", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[Cent]\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->"S1.1098"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1098"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CenterDot", "ObjectName",
  CellTags->"S1.1099"],

Cell[TextData[{
  "\[CenterDot]  \[Backslash]",
  StyleBox["[CenterDot]", "MR"]
}], "CharacterName",
  CellTags->"S1.1099"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox[".\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1099"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1099"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[CenterDot]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["CenterDot[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1099"],

Cell["\<\
\[FilledSmallSquare] Used to indicate various forms of \
multiplication, particularly dot products of vectors. \
\>", "Notes",
  CellTags->"S1.1099"],

Cell["\<\
\[FilledSmallSquare] Sometimes used to indicate concatenation or \
composition. \
\>", "Notes",
  CellTags->"S1.1099"],

Cell["\<\
\[FilledSmallSquare] Used in the British mathematical tradition as \
a decimal point. \
\>", "Notes",
  CellTags->"S1.1099"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1099"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CenterEllipsis]",
    ButtonData:>{"CenterEllipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawDot]",
    ButtonData:>{"RawDot"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CircleDot]",
    ButtonData:>{"CircleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1099"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CenterEllipsis", "ObjectName",
  CellTags->"S1.1100"],

Cell[TextData[{
  "\[CenterEllipsis]  \[Backslash]",
  StyleBox["[CenterEllipsis]", "MR"]
}], "CharacterName",
  CellTags->"S1.1100"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1100"],

Cell["\<\
\[FilledSmallSquare] Used to indicate omitted elements in a row of \
a matrix. \
\>", "Notes",
  CellTags->"S1.1100"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1100"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Ellipsis]",
    ButtonData:>{"Ellipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VerticalEllipsis]",
    ButtonData:>{"VerticalEllipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CenterDot]",
    ButtonData:>{"CenterDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1100"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CHacek", "ObjectName",
  CellTags->"S1.1101"],

Cell[TextData[{
  "\[CHacek]  \[Backslash]",
  StyleBox["[CHacek]", "MR"]
}], "CharacterName",
  CellTags->"S1.1101"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["cv\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1101"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1101"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1101"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1101"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalCHacek]",
    ButtonData:>{"CapitalCHacek"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SHacek]",
    ButtonData:>{"SHacek"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1101"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chi", "ObjectName",
  CellTags->"S1.1102"],

Cell[TextData[{
  "\[Chi]  \[Backslash]",
  StyleBox["[Chi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1102"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["ch\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["chi\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["c\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1102"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1102"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1102"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalChi]",
    ButtonData:>{"CapitalChi"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Xi]",
    ButtonData:>{"Xi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1102"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CircleDot", "ObjectName",
  CellTags->"S1.1103"],

Cell[TextData[{
  "\[CircleDot]  \[Backslash]",
  StyleBox["[CircleDot]", "MR"]
}], "CharacterName",
  CellTags->"S1.1103"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["c.\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1103"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1103"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[CircleDot]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["CircleDot[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1103"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics for various operations \
related to multiplication, such as direct or tensor products. \
\>", "Notes",
  CellTags->"S1.1103"],

Cell["\<\
\[FilledSmallSquare] Also sometimes used to indicate a vector \
pointing out of the page. \
\>", "Notes",
  CellTags->"S1.1103"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1103"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CircleTimes]",
    ButtonData:>{"CircleTimes"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CenterDot]",
    ButtonData:>{"CenterDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1103"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CircleMinus", "ObjectName",
  CellTags->"S1.1104"],

Cell[TextData[{
  "\[CircleMinus]  \[Backslash]",
  StyleBox["[CircleMinus]", "MR"]
}], "CharacterName",
  CellTags->"S1.1104"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["c-\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1104"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1104"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[CircleMinus]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["CircleMinus[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1104"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1104"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CirclePlus]",
    ButtonData:>{"CirclePlus"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1104"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CirclePlus", "ObjectName",
  CellTags->"S1.1105"],

Cell[TextData[{
  "\[CirclePlus]  \[Backslash]",
  StyleBox["[CirclePlus]", "MR"]
}], "CharacterName",
  CellTags->"S1.1105"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["c+\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1105"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1105"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["CirclePlus[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1105"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics for various operations \
related to addition, such as direct sum and addition modulo two. \
\>", \
"Notes",
  CellTags->"S1.1105"],

Cell["\<\
\[FilledSmallSquare] Also sometimes used to indicate a vector \
pointing into the page. \
\>", "Notes",
  CellTags->"S1.1105"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1105"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CircleTimes]",
    ButtonData:>{"CircleTimes"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CircleMinus]",
    ButtonData:>{"CircleMinus"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Xor]",
    ButtonData:>{"Xor"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1105"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CircleTimes", "ObjectName",
  CellTags->"S1.1106"],

Cell[TextData[{
  "\[CircleTimes]  \[Backslash]",
  StyleBox["[CircleTimes]", "MR"]
}], "CharacterName",
  CellTags->"S1.1106"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["c*\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1106"],

Cell["\[FilledSmallSquare] Infix and prefix operator. ", "Notes",
  CellTags->"S1.1106"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[CircleTimes]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["CircleTimes[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1106"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics for various operations \
related to multiplication, such as direct or tensor products. \
\>", "Notes",
  CellTags->"S1.1106"],

Cell["\<\
\[FilledSmallSquare] Also sometimes used to indicate a vector \
pointing into the page. \
\>", "Notes",
  CellTags->"S1.1106"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1106"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CircleDot]",
    ButtonData:>{"CircleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Times]",
    ButtonData:>{"Times"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Cross]",
    ButtonData:>{"Cross"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Wedge]",
    ButtonData:>{"Wedge"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CirclePlus]",
    ButtonData:>{"CirclePlus"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1106"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ClockwiseContourIntegral", "ObjectName",
  CellTags->"S1.1107"],

Cell[TextData[{
  "\[ClockwiseContourIntegral]  \[Backslash]",
  StyleBox["[ClockwiseContourIntegral]", "MR"]
}], "CharacterName",
  CellTags->"S1.1107"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["ccint\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1107"],

Cell[TextData[{
  "\[FilledSmallSquare] Compound operator (see Section\[NonBreakingSpace]",
  ButtonBox["A.2.7",
    ButtonData:>{"A.2.7", "7.12"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->"S1.1107"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[ClockwiseContourIntegral]\)], "InlineFormula"],
  " ",
  StyleBox["f", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  StyleBox["x", "TI"],
  " is by default interpreted as ",
  StyleBox["ClockwiseContourIntegral[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1107"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1107"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CounterClockwiseContourIntegral]",
    ButtonData:>{"CounterClockwiseContourIntegral"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ContourIntegral]",
    ButtonData:>{"ContourIntegral"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1107"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CloverLeaf", "ObjectName",
  CellTags->"S1.1108"],

Cell[TextData[{
  "\[CloverLeaf]  \[Backslash]",
  StyleBox["[CloverLeaf]", "MR"]
}], "CharacterName",
  CellTags->"S1.1108"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["cl\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1108"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1108"],

Cell["\<\
\[FilledSmallSquare] Used on Macintosh and other computers to \
indicate command keys. \
\>", "Notes",
  CellTags->"S1.1108"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1108"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CommandKey]",
    ButtonData:>{"CommandKey"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1108"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ClubSuit", "ObjectName",
  CellTags->"S1.1109"],

Cell[TextData[{
  "\[ClubSuit]  \[Backslash]",
  StyleBox["[ClubSuit]", "MR"]
}], "CharacterName",
  CellTags->"S1.1109"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1109"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1109"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DiamondSuit]",
    ButtonData:>{"DiamondSuit"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][HeartSuit]",
    ButtonData:>{"HeartSuit"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SpadeSuit]",
    ButtonData:>{"SpadeSuit"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1109"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Colon", "ObjectName",
  CellTags->"S1.1110"],

Cell[TextData[{
  "\[Colon]  \[Backslash]",
  StyleBox["[Colon]", "MR"]
}], "CharacterName",
  CellTags->"S1.1110"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox[":\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1110"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1110"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Colon] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Colon[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1110"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to mean \
\[OpenCurlyDoubleQuote]such that\[CloseCurlyDoubleQuote]. \
\>", "Notes",
  CellTags->"S1.1110"],

Cell["\<\
\[FilledSmallSquare] Occasionally used to indicate proportion. \
\
\>", "Notes",
  CellTags->"S1.1110"],

Cell["\<\
\[FilledSmallSquare] Used to separate hours and minutes in times. \
\
\>", "Notes",
  CellTags->"S1.1110"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1110"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][SuchThat]",
    ButtonData:>{"SuchThat"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VerticalSeparator]",
    ButtonData:>{"VerticalSeparator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Exists]",
    ButtonData:>{"Exists"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ForAll]",
    ButtonData:>{"ForAll"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawColon]",
    ButtonData:>{"RawColon"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Proportion]",
    ButtonData:>{"Proportion"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Therefore]",
    ButtonData:>{"Therefore"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1110"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CommandKey", "ObjectName",
  CellTags->"S1.1111"],

Cell[TextData[{
  "\[CommandKey]  \[Backslash]",
  StyleBox["[CommandKey]", "MR"]
}], "CharacterName",
  CellTags->"S1.1111"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["cmd\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1111"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1111"],

Cell["\<\
\[FilledSmallSquare] Representation of the Command or Alt key on a \
keyboard. \
\>", "Notes",
  CellTags->"S1.1111"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1111"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CloverLeaf]",
    ButtonData:>{"CloverLeaf"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftModified]",
    ButtonData:>{"LeftModified"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ControlKey]",
    ButtonData:>{"ControlKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EscapeKey]",
    ButtonData:>{"EscapeKey"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1111"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conjugate", "ObjectName",
  CellTags->"S1.1112"],

Cell[TextData[{
  "\[Conjugate]  \[Backslash]",
  StyleBox["[Conjugate]", "MR"]
}], "CharacterName",
  CellTags->"S1.1112"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["co\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["conj\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1112"],

Cell["\<\
\[FilledSmallSquare] Superscript postfix operator with built\
\[Hyphen]in evaluation rules. \
\>", "Notes",
  CellTags->"S1.1112"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      SuperscriptBox[
        StyleBox["z",
          "TI"], "\[Conjugate]"]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Conjugate[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1112"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as keyboard ",
  StyleBox["*", "MR"],
  " or ",
  ButtonBox["\[Backslash][Star]",
    ButtonData:>{"Star"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1112"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.12"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1112"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ConjugateTranspose]",
    ButtonData:>{"ConjugateTranspose"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][HermitianConjugate]",
    ButtonData:>{"HermitianConjugate"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1112"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ConjugateTranspose", "ObjectName",
  CellTags->"S1.1113"],

Cell[TextData[{
  "\[ConjugateTranspose]  \[Backslash]",
  StyleBox["[ConjugateTranspose]", "MR"]
}], "CharacterName",
  CellTags->"S1.1113"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["ct\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1113"],

Cell["\<\
\[FilledSmallSquare] Superscript postfix operator with built\
\[Hyphen]in evaluation rules. \
\>", "Notes",
  CellTags->"S1.1113"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      SuperscriptBox[
        StyleBox["m",
          "TI"], "\[ConjugateTranspose]"]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["ConjugateTranspose[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1113"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Dagger]",
    ButtonData:>{"Dagger"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1113"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.12"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1113"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][HermitianConjugate]",
    ButtonData:>{"HermitianConjugate"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Conjugate]",
    ButtonData:>{"Conjugate"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Transpose]",
    ButtonData:>{"Transpose"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1113"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Congruent", "ObjectName",
  CellTags->"S1.1114"],

Cell[TextData[{
  "\[Congruent]  \[Backslash]",
  StyleBox["[Congruent]", "MR"]
}], "CharacterName",
  CellTags->"S1.1114"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["===\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1114"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1114"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Congruent] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Congruent[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1114"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics for many notions of \
equivalence and equality. \
\>", "Notes",
  CellTags->"S1.1114"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1114"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotCongruent]",
    ButtonData:>{"NotCongruent"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Equal]",
    ButtonData:>{"Equal"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][TildeFullEqual]",
    ButtonData:>{"TildeFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CupCap]",
    ButtonData:>{"CupCap"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftRightArrow]",
    ButtonData:>{"LeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1114"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Continuation", "ObjectName",
  CellTags->"S1.1115"],

Cell[TextData[{
  "\[Continuation]  \[Backslash]",
  StyleBox["[Continuation]", "MR"]
}], "CharacterName",
  CellTags->"S1.1115"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["cont\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1115"],

Cell["\[FilledSmallSquare] Structural element. ", "Notes",
  CellTags->"S1.1115"],

Cell["\<\
\[FilledSmallSquare] Used at the end of a line of input to indicate \
that the expression on that line continues onto the next line. \
\>", "Notes",\

  CellTags->"S1.1115"],

Cell["\<\
\[FilledSmallSquare] Equivalent in meaning to \[Backslash] at the \
end of a line. \
\>", "Notes",
  CellTags->"S1.1115"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][DescendingEllipsis]",
    ButtonData:>{"DescendingEllipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1115"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1115"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawBackslash]",
    ButtonData:>{"RawBackslash"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Backslash]",
    ButtonData:>{"Backslash"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReturnIndicator]",
    ButtonData:>{"ReturnIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1115"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ContourIntegral", "ObjectName",
  CellTags->"S1.1116"],

Cell[TextData[{
  "\[ContourIntegral]  \[Backslash]",
  StyleBox["[ContourIntegral]", "MR"]
}], "CharacterName",
  CellTags->"S1.1116"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["cint\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1116"],

Cell[TextData[{
  "\[FilledSmallSquare] Compound operator (see Section\[NonBreakingSpace]",
  ButtonBox["A.2.7",
    ButtonData:>{"A.2.7", "7.12"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->"S1.1116"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[ContourIntegral]\)], "InlineFormula"],
  " ",
  StyleBox["f", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  StyleBox["x", "TI"],
  " is by default interpreted as ",
  StyleBox["ContourIntegral[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1116"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1116"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ClockwiseContourIntegral]",
    ButtonData:>{"ClockwiseContourIntegral"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleContourIntegral]",
    ButtonData:>{"DoubleContourIntegral"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1116"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ControlKey", "ObjectName",
  CellTags->"S1.1117"],

Cell[TextData[{
  "\[ControlKey]  \[Backslash]",
  StyleBox["[ControlKey]", "MR"]
}], "CharacterName",
  CellTags->"S1.1117"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["ctrl\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1117"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1117"],

Cell["\<\
\[FilledSmallSquare] Representation of the Control key on a \
keyboard. \
\>", "Notes",
  CellTags->"S1.1117"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1117"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftModified]",
    ButtonData:>{"LeftModified"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CommandKey]",
    ButtonData:>{"CommandKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EscapeKey]",
    ButtonData:>{"EscapeKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReturnKey]",
    ButtonData:>{"ReturnKey"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1117"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coproduct", "ObjectName",
  CellTags->"S1.1118"],

Cell[TextData[{
  "\[Coproduct]  \[Backslash]",
  StyleBox["[Coproduct]", "MR"]
}], "CharacterName",
  CellTags->"S1.1118"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["coprod\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1118"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1118"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Coproduct]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Coproduct[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1118"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[Coproduct]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " is by default interpreted as ",
  StyleBox["Coproduct[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1118"],

Cell["\<\
\[FilledSmallSquare] Coproduct is used as an abstract dual to the \
operation of multiplication, most often in infix form. \
\>", "Notes",
  CellTags->"S1.1118"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1118"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Product]",
    ButtonData:>{"Product"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Wedge]",
    ButtonData:>{"Wedge"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Vee]",
    ButtonData:>{"Vee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CircleTimes]",
    ButtonData:>{"CircleTimes"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SquareUnion]",
    ButtonData:>{"SquareUnion"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1118"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Copyright", "ObjectName",
  CellTags->"S1.1119"],

Cell[TextData[{
  "\[Copyright]  \[Backslash]",
  StyleBox["[Copyright]", "MR"]
}], "CharacterName",
  CellTags->"S1.1119"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1119"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1119"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RegisteredTrademark]",
    ButtonData:>{"RegisteredTrademark"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1119"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CounterClockwiseContourIntegral", "ObjectName",
  CellTags->"S1.1120"],

Cell[TextData[{
  "\[CounterClockwiseContourIntegral]  \[Backslash]",
  StyleBox["[CounterClockwiseContourIntegral]", "MR"]
}], "CharacterName",
  CellTags->"S1.1120"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["cccint\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1120"],

Cell[TextData[{
  "\[FilledSmallSquare] Compound operator (see Section\[NonBreakingSpace]",
  ButtonBox["A.2.7",
    ButtonData:>{"A.2.7", "7.12"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->"S1.1120"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[CounterClockwiseContourIntegral]\)], 
    "InlineFormula"],
  " ",
  StyleBox["f", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  StyleBox["x", "TI"],
  " is by default interpreted as ",
  StyleBox["CounterClockwiseContourIntegral[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1120"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1120"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ClockwiseContourIntegral]",
    ButtonData:>{"ClockwiseContourIntegral"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ContourIntegral]",
    ButtonData:>{"ContourIntegral"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1120"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cross", "ObjectName",
  CellTags->"S1.1121"],

Cell[TextData[{
  "\[Cross]  \[Backslash]",
  StyleBox["[Cross]", "MR"]
}], "CharacterName",
  CellTags->"S1.1121"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["cross\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1121"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1121"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Cross]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Cross[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1121"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Times]",
    ButtonData:>{"Times"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1121"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[Cross]", "MR"],
  " represents vector cross product, while ",
  ButtonBox["\[Backslash][Times]",
    ButtonData:>{"Times"},
    ButtonStyle->"MainBookLinkMR"],
  " represents ordinary multiplication. "
}], "Notes",
  CellTags->"S1.1121"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[Cross]", "MR"],
  " is drawn smaller than ",
  ButtonBox["\[Backslash][Times]",
    ButtonData:>{"Times"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1121"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.10"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1121"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CircleTimes]",
    ButtonData:>{"CircleTimes"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1121"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cup", "ObjectName",
  CellTags->"S1.1122"],

Cell[TextData[{
  "\[Cup]  \[Backslash]",
  StyleBox["[Cup]", "MR"]
}], "CharacterName",
  CellTags->"S1.1122"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1122"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Cup]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Cup[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1122"],

Cell["\<\
\[FilledSmallSquare] Used in pure mathematics to mean cup product. \
\
\>", "Notes",
  CellTags->"S1.1122"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1122"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Cap]",
    ButtonData:>{"Cap"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Union]",
    ButtonData:>{"Union"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CupCap]",
    ButtonData:>{"CupCap"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RoundSpaceIndicator]",
    ButtonData:>{"RoundSpaceIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Breve]",
    ButtonData:>{"Breve"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1122"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CupCap", "ObjectName",
  CellTags->"S1.1123"],

Cell[TextData[{
  "\[CupCap]  \[Backslash]",
  StyleBox["[CupCap]", "MR"]
}], "CharacterName",
  CellTags->"S1.1123"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1123"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[CupCap] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["CupCap[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1123"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics for various notions of \
equivalence, usually fairly weak. \
\>", "Notes",
  CellTags->"S1.1123"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["f", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[CupCap] \)], "InlineFormula"],
  " ",
  StyleBox["g", "TI"],
  " is often specifically used to indicate that ",
  StyleBox["f", "TI"],
  StyleBox["/", "MR"],
  StyleBox["g", "TI"],
  " has bounded variation. "
}], "Notes",
  CellTags->"S1.1123"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1123"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotCupCap]",
    ButtonData:>{"NotCupCap"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Cap]",
    ButtonData:>{"Cap"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Cup]",
    ButtonData:>{"Cup"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1123"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CurlyCapitalUpsilon", "ObjectName",
  CellTags->"S1.1124"],

Cell[TextData[{
  "\[CurlyCapitalUpsilon]  \[Backslash]",
  StyleBox["[CurlyCapitalUpsilon]", "MR"]
}], "CharacterName",
  CellTags->"S1.1124"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["cU\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["cUpsilon\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1124"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1124"],

Cell["\[FilledSmallSquare] Not commonly used. ", "Notes",
  CellTags->"S1.1124"],

Cell["\<\
\[FilledSmallSquare] Used in astronomy for mass to light ratio. \
\
\>", "Notes",
  CellTags->"S1.1124"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1124"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalUpsilon]",
    ButtonData:>{"CapitalUpsilon"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1124"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CurlyEpsilon", "ObjectName",
  CellTags->"S1.1125"],

Cell[TextData[{
  "\[CurlyEpsilon]  \[Backslash]",
  StyleBox["[CurlyEpsilon]", "MR"]
}], "CharacterName",
  CellTags->"S1.1125"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["ce\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["cepsilon\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1125"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1125"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Element]",
    ButtonData:>{"Element"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1125"],

Cell["\<\
\[FilledSmallSquare] Used in physics for Fermi energy and \
dielectric constant. \
\>", "Notes",
  CellTags->"S1.1125"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1125"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Epsilon]",
    ButtonData:>{"Epsilon"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ScriptCapitalE]",
    ButtonData:>{"ScriptCapitalA"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1125"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CurlyKappa", "ObjectName",
  CellTags->"S1.1126"],

Cell[TextData[{
  "\[CurlyKappa]  \[Backslash]",
  StyleBox["[CurlyKappa]", "MR"]
}], "CharacterName",
  CellTags->"S1.1126"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["ck\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["ckappa\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1126"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1126"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1126"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Kappa]",
    ButtonData:>{"Kappa"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1126"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CurlyPhi", "ObjectName",
  CellTags->"S1.1127"],

Cell[TextData[{
  "\[CurlyPhi]  \[Backslash]",
  StyleBox["[CurlyPhi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1127"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["j\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["cph\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["cphi\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1127"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1127"],

Cell[TextData[{
  "\[FilledSmallSquare] Commonly used as a variant of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->"S1.1127"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1127"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Phi]",
    ButtonData:>{"Phi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1127"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CurlyPi", "ObjectName",
  CellTags->"S1.1128"],

Cell[TextData[{
  "\[CurlyPi]  \[Backslash]",
  StyleBox["[CurlyPi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1128"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["cp\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["cpi\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1128"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1128"],

Cell["\<\
\[FilledSmallSquare] Not commonly used, except in astronomy. \
\>", \
"Notes",
  CellTags->"S1.1128"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1128"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Pi]",
    ButtonData:>{"Pi"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Omega]",
    ButtonData:>{"Omega"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1128"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CurlyRho", "ObjectName",
  CellTags->"S1.1129"],

Cell[TextData[{
  "\[CurlyRho]  \[Backslash]",
  StyleBox["[CurlyRho]", "MR"]
}], "CharacterName",
  CellTags->"S1.1129"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["cr\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["crho\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1129"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1129"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1129"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Rho]",
    ButtonData:>{"Rho"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1129"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CurlyTheta", "ObjectName",
  CellTags->"S1.1130"],

Cell[TextData[{
  "\[CurlyTheta]  \[Backslash]",
  StyleBox["[CurlyTheta]", "MR"]
}], "CharacterName",
  CellTags->"S1.1130"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["cq\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["cth\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["ctheta\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1130"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1130"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["EllipticTheta", "MR"],
  " and ",
  StyleBox["RiemannSiegelTheta", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1130"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1130"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalTheta]",
    ButtonData:>{"CapitalTheta"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Theta]",
    ButtonData:>{"Theta"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1130"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dagger", "ObjectName",
  CellTags->"S1.1131"],

Cell[TextData[{
  "\[Dagger]  \[Backslash]",
  StyleBox["[Dagger]", "MR"]
}], "CharacterName",
  CellTags->"S1.1131"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["dg\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1131"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1131"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      SuperscriptBox[
        StyleBox["x",
          "TI"], "\[Dagger]"]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["SuperDagger[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1131"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][ConjugateTranspose]",
    ButtonData:>{"ConjugateTranspose"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1131"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1131"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubleDagger]",
    ButtonData:>{"DoubleDagger"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1131"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dalet", "ObjectName",
  CellTags->"S1.1132"],

Cell[TextData[{
  "\[Dalet]  \[Backslash]",
  StyleBox["[Dalet]", "MR"]
}], "CharacterName",
  CellTags->"S1.1132"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["da\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1132"],

Cell["\[FilledSmallSquare] Hebrew letter. ", "Notes",
  CellTags->"S1.1132"],

Cell["\[FilledSmallSquare] Sometimes called daleth. ", "Notes",
  CellTags->"S1.1132"],

Cell["\<\
\[FilledSmallSquare] Used occasionally in pure mathematics in the \
theory of transfinite cardinals. \
\>", "Notes",
  CellTags->"S1.1132"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1132"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Aleph]",
    ButtonData:>{"Aleph"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1132"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dash", "ObjectName",
  CellTags->"S1.1133"],

Cell[TextData[{
  "\[Dash]  \[Backslash]",
  StyleBox["[Dash]", "MR"]
}], "CharacterName",
  CellTags->"S1.1133"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["-\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1133"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1133"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1133"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LongDash]",
    ButtonData:>{"LongDash"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][HorizontalLine]",
    ButtonData:>{"HorizontalLine"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1133"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Degree", "ObjectName",
  CellTags->"S1.1134"],

Cell[TextData[{
  "\[Degree]  \[Backslash]",
  StyleBox["[Degree]", "MR"]
}], "CharacterName",
  CellTags->"S1.1134"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["deg\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1134"],

Cell["\<\
\[FilledSmallSquare] Letter\[Hyphen]like form with built\[Hyphen]in \
value. \
\>", "Notes",
  CellTags->"S1.1134"],

Cell[TextData[{
  "\[FilledSmallSquare] Interpreted by default as the symbol ",
  StyleBox["Degree", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1134"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["30", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[Degree]\)], "InlineFormula"],
  " is interpreted as ",
  StyleBox["30", "MR"],
  " ",
  StyleBox["Degree", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1134"],

Cell[TextData[{
  "\[FilledSmallSquare] The symbol ",
  Cell[BoxData[
      \(TraditionalForm\`\[Degree]\)], "InlineFormula"],
  " is sometimes used in mathematics to indicate the interior of a set. "
}], "Notes",
  CellTags->"S1.1134"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][SmallCircle]",
    ButtonData:>{"SmallCircle"},
    ButtonStyle->"MainBookLinkMR"],
  " or ",
  ButtonBox["\[Backslash][EmptySmallCircle]",
    ButtonData:>{"EmptySmallCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1134"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1134"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Prime]",
    ButtonData:>{"Prime"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoublePrime]",
    ButtonData:>{"DoublePrime"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1134"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Del", "ObjectName",
  CellTags->"S1.1135"],

Cell[TextData[{
  "\[Del]  \[Backslash]",
  StyleBox["[Del]", "MR"]
}], "CharacterName",
  CellTags->"S1.1135"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["del\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1135"],

Cell["\[FilledSmallSquare] Prefix operator. ", "Notes",
  CellTags->"S1.1135"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\)], "InlineFormula"],
  StyleBox["f", "TI"],
  " is by default interpreted as ",
  StyleBox["Del[", "MR"],
  StyleBox["f", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1135"],

Cell["\<\
\[FilledSmallSquare] Used in vector analysis to denote gradient \
operator and its generalizations. \
\>", "Notes",
  CellTags->"S1.1135"],

Cell["\<\
\[FilledSmallSquare] Used in numerical analysis to denote backward \
difference operator. \
\>", "Notes",
  CellTags->"S1.1135"],

Cell["\[FilledSmallSquare] Also called nabla. ", "Notes",
  CellTags->"S1.1135"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][EmptyDownTriangle]",
    ButtonData:>{"EmptyDownTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1135"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.26"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1135"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalDelta]",
    ButtonData:>{"CapitalDelta"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][PartialD]",
    ButtonData:>{"PartialD"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Square]",
    ButtonData:>{"Square"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1135"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Delta", "ObjectName",
  CellTags->"S1.1136"],

Cell[TextData[{
  "\[Delta]  \[Backslash]",
  StyleBox["[Delta]", "MR"]
}], "CharacterName",
  CellTags->"S1.1136"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["d\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["delta\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1136"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1136"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1136"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][PartialD]",
    ButtonData:>{"PartialD"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Del]",
    ButtonData:>{"Del"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalDelta]",
    ButtonData:>{"CapitalDelta"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1136"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DescendingEllipsis", "ObjectName",
  CellTags->"S1.1137"],

Cell[TextData[{
  "\[DescendingEllipsis]  \[Backslash]",
  StyleBox["[DescendingEllipsis]", "MR"]
}], "CharacterName",
  CellTags->"S1.1137"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1137"],

Cell["\<\
\[FilledSmallSquare] Used to indicate omitted elements in a matrix. \
\
\>", "Notes",
  CellTags->"S1.1137"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Continuation]",
    ButtonData:>{"Continuation"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1137"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1137"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][AscendingEllipsis]",
    ButtonData:>{"AscendingEllipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VerticalEllipsis]",
    ButtonData:>{"VerticalEllipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Ellipsis]",
    ButtonData:>{"Ellipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1137"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Diameter", "ObjectName",
  CellTags->"S1.1138"],

Cell[TextData[{
  "\[Diameter]  \[Backslash]",
  StyleBox["[Diameter]", "MR"]
}], "CharacterName",
  CellTags->"S1.1138"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1138"],

Cell["\[FilledSmallSquare] Used in geometry. ", "Notes",
  CellTags->"S1.1138"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][CapitalOSlash]",
    ButtonData:>{"CapitalOSlash"},
    ButtonStyle->"MainBookLinkMR"],
  " or ",
  ButtonBox["\[Backslash][EmptySet]",
    ButtonData:>{"EmptySet"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1138"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.31"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1138"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Diamond", "ObjectName",
  CellTags->"S1.1139"],

Cell[TextData[{
  "\[Diamond]  \[Backslash]",
  StyleBox["[Diamond]", "MR"]
}], "CharacterName",
  CellTags->"S1.1139"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["dia\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1139"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1139"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Diamond]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Diamond[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1139"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1139"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EmptyDiamond]",
    ButtonData:>{"EmptyDiamond"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledDiamond]",
    ButtonData:>{"FilledDiamond"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DiamondSuit]",
    ButtonData:>{"DiamondSuit"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1139"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiamondSuit", "ObjectName",
  CellTags->"S1.1140"],

Cell[TextData[{
  "\[DiamondSuit]  \[Backslash]",
  StyleBox["[DiamondSuit]", "MR"]
}], "CharacterName",
  CellTags->"S1.1140"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1140"],

Cell["\<\
\[FilledSmallSquare] Sometimes used to indicate the end of a proof. \
\
\>", "Notes",
  CellTags->"S1.1140"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Diamond]",
    ButtonData:>{"Diamond"},
    ButtonStyle->"MainBookLinkMR"],
  " or ",
  ButtonBox["\[Backslash][EmptyDiamond]",
    ButtonData:>{"EmptyDiamond"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1140"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1140"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ClubSuit]",
    ButtonData:>{"ClubSuit"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1140"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DifferentialD", "ObjectName",
  CellTags->"S1.1141"],

Cell[TextData[{
  "\[DifferentialD]  \[Backslash]",
  StyleBox["[DifferentialD]", "MR"]
}], "CharacterName",
  CellTags->"S1.1141"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["dd\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1141"],

Cell["\<\
\[FilledSmallSquare] Compound operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1141"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  " can only be interpreted by default when it appears with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
  " or other integral operators. "
}], "Notes",
  CellTags->"S1.1141"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
  " ",
  StyleBox["f", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  StyleBox["x", "TI"],
  " is by default interpreted as ",
  StyleBox["Integrate[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1141"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[DifferentialD]", "MR"],
  " is also used in ",
  StyleBox["TraditionalForm", "MR"],
  " to indicate total derivatives. "
}], "Notes",
  CellTags->"S1.1141"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.12"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.27"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.26"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1141"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][PartialD]",
    ButtonData:>{"PartialD"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalDifferentialD]",
    ButtonData:>{"CapitalDifferentialD"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Delta]",
    ButtonData:>{"Delta"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1141"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Digamma", "ObjectName",
  CellTags->"S1.1142"],

Cell[TextData[{
  "\[Digamma]  \[Backslash]",
  StyleBox["[Digamma]", "MR"]
}], "CharacterName",
  CellTags->"S1.1142"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["di\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["digamma\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1142"],

Cell["\[FilledSmallSquare] Special Greek letter. ", "Notes",
  CellTags->"S1.1142"],

Cell[TextData[{
  "\[FilledSmallSquare] Analogous to English ",
  StyleBox["w", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1142"],

Cell[TextData[{
  "\[FilledSmallSquare] Sometimes used to denote ",
  StyleBox["PolyGamma[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1142"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1142"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalDigamma]",
    ButtonData:>{"CapitalDigamma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Koppa]",
    ButtonData:>{"Koppa"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Stigma]",
    ButtonData:>{"Stigma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Sampi]",
    ButtonData:>{"Sampi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1142"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Divide", "ObjectName",
  CellTags->"S1.1143"],

Cell[TextData[{
  "\[Divide]  \[Backslash]",
  StyleBox["[Divide]", "MR"]
}], "CharacterName",
  CellTags->"S1.1143"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["div\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1143"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1143"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Divide]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Divide[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  " or ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["/", "MR"],
  " ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1143"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Divide]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Divide]\)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  " groups as ",
  StyleBox["(", "MR"],
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Divide]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[")", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Divide]\)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1143"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1143"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Times]",
    ButtonData:>{"Times"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Proportion]",
    ButtonData:>{"Proportion"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Backslash]",
    ButtonData:>{"Backslash"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1143"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DotEqual", "ObjectName",
  CellTags->"S1.1144"],

Cell[TextData[{
  "\[DotEqual]  \[Backslash]",
  StyleBox["[DotEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1144"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox[".=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1144"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1144"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DotEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DotEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1144"],

Cell["\<\
\[FilledSmallSquare] Used to mean approximately equal, or in some \
cases, \[OpenCurlyDoubleQuote]image of\[CloseCurlyDoubleQuote], or \
\[OpenCurlyDoubleQuote]equal by definition\[CloseCurlyDoubleQuote]. \
\>", \
"Notes",
  CellTags->"S1.1144"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1144"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][TildeEqual]",
    ButtonData:>{"TildeEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1144"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DotlessI", "ObjectName",
  CellTags->"S1.1145"],

Cell[TextData[{
  "\[DotlessI]  \[Backslash]",
  StyleBox["[DotlessI]", "MR"]
}], "CharacterName",
  CellTags->"S1.1145"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1145"],

Cell[TextData[{
  "\[FilledSmallSquare] Used when an ",
  StyleBox["i", "MR"],
  " will have an overscript on top. "
}], "Notes",
  CellTags->"S1.1145"],

Cell[TextData[{
  "\[FilledSmallSquare] May or may not match the ordinary ",
  StyleBox["i", "MR"],
  " from the text font. "
}], "Notes",
  CellTags->"S1.1145"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.13"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1145"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DotlessJ]",
    ButtonData:>{"DotlessJ"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Iota]",
    ButtonData:>{"Iota"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1145"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DotlessJ", "ObjectName",
  CellTags->"S1.1146"],

Cell[TextData[{
  "\[DotlessJ]  \[Backslash]",
  StyleBox["[DotlessJ]", "MR"]
}], "CharacterName",
  CellTags->"S1.1146"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1146"],

Cell[TextData[{
  "\[FilledSmallSquare] Used when a ",
  StyleBox["j", "MR"],
  " will have an overscript on top. "
}], "Notes",
  CellTags->"S1.1146"],

Cell[TextData[{
  "\[FilledSmallSquare] May or may not match the ordinary ",
  StyleBox["j", "MR"],
  " from the text font. "
}], "Notes",
  CellTags->"S1.1146"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.13"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1146"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DotlessI]",
    ButtonData:>{"DotlessI"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1146"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DottedSquare", "ObjectName",
  CellTags->"S1.1147"],

Cell[TextData[{
  "\[DottedSquare]  \[Backslash]",
  StyleBox["[DottedSquare]", "MR"]
}], "CharacterName",
  CellTags->"S1.1147"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1147"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1147"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EmptySquare]",
    ButtonData:>{"EmptySquare"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Placeholder]",
    ButtonData:>{"Placeholder"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1147"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleContourIntegral", "ObjectName",
  CellTags->"S1.1148"],

Cell[TextData[{
  "\[DoubleContourIntegral]  \[Backslash]",
  StyleBox["[DoubleContourIntegral]", "MR"]
}], "CharacterName",
  CellTags->"S1.1148"],

Cell[TextData[{
  "\[FilledSmallSquare] Compound operator (see Section\[NonBreakingSpace]",
  ButtonBox["A.2.7",
    ButtonData:>{"A.2.7", "7.12"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->"S1.1148"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleContourIntegral]\)], "InlineFormula"],
  " ",
  StyleBox["f", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  StyleBox["s", "TI"],
  " is by default interpreted as ",
  StyleBox["ContourIntegral[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["s", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1148"],

Cell["\<\
\[FilledSmallSquare] Used to indicate integrals over closed \
surfaces. \
\>", "Notes",
  CellTags->"S1.1148"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1148"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ContourIntegral]",
    ButtonData:>{"ContourIntegral"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Integral]",
    ButtonData:>{"Integral"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1148"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleDagger", "ObjectName",
  CellTags->"S1.1149"],

Cell[TextData[{
  "\[DoubleDagger]  \[Backslash]",
  StyleBox["[DoubleDagger]", "MR"]
}], "CharacterName",
  CellTags->"S1.1149"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["ddg\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1149"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1149"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1149"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Dagger]",
    ButtonData:>{"Dagger"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1149"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubledGamma", "ObjectName",
  CellTags->"S1.1150"],

Cell[TextData[{
  "\[DoubledGamma]  \[Backslash]",
  StyleBox["[DoubledGamma]", "MR"]
}], "CharacterName",
  CellTags->"S1.1150"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["gg\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1150"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1150"],

Cell[TextData[{
  "\[FilledSmallSquare] Not by default assigned any interpretation in ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1150"],

Cell[TextData[{
  "\[FilledSmallSquare] Interpreted as ",
  StyleBox["EulerGamma", "MR"],
  " in ",
  StyleBox["TraditionalForm", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1150"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Gamma]",
    ButtonData:>{"Gamma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1150"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1150"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubledPi]",
    ButtonData:>{"DoubledPi"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ExponentialE]",
    ButtonData:>{"ExponentialE"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleStruckA]",
    ButtonData:>{"DoubleStruckA"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1150"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleDownArrow", "ObjectName",
  CellTags->"S1.1151"],

Cell[TextData[{
  "\[DoubleDownArrow]  \[Backslash]",
  StyleBox["[DoubleDownArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1151"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1151"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleDownArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DoubleDownArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1151"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1151"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1151"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownArrow]",
    ButtonData:>{"DownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleUpArrow]",
    ButtonData:>{"DoubleUpArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1151"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubledPi", "ObjectName",
  CellTags->"S1.1152"],

Cell[TextData[{
  "\[DoubledPi]  \[Backslash]",
  StyleBox["[DoubledPi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1152"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["pp\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1152"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1152"],

Cell["\<\
\[FilledSmallSquare] Not by default assigned any interpretation. \
\
\>", "Notes",
  CellTags->"S1.1152"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Pi]",
    ButtonData:>{"Pi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1152"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1152"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubledGamma]",
    ButtonData:>{"DoubledGamma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ExponentialE]",
    ButtonData:>{"ExponentialE"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleStruckA]",
    ButtonData:>{"DoubleStruckA"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1152"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleLeftArrow", "ObjectName",
  CellTags->"S1.1153"],

Cell[TextData[{
  "\[DoubleLeftArrow]  \[Backslash]",
  StyleBox["[DoubleLeftArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1153"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  StyleBox["<=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1153"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1153"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleLeftArrow] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DoubleLeftArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1153"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1153"],

Cell[TextData[{
  "\[FilledSmallSquare] \[AliasIndicator]",
  StyleBox["<=\[AliasIndicator]", "MR"],
  " is the alias for ",
  ButtonBox["\[Backslash][LessEqual]",
    ButtonData:>{"LessEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". The alias for \[Backslash]",
  StyleBox["[DoubleLeftArrow]", "MR"],
  " has a space at the beginning. "
}], "Notes",
  CellTags->"S1.1153"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1153"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubleLongLeftArrow]",
    ButtonData:>{"DoubleLongLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrow]",
    ButtonData:>{"LeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleRightArrow]",
    ButtonData:>{"DoubleRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1153"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleLeftRightArrow", "ObjectName",
  CellTags->"S1.1154"],

Cell[TextData[{
  "\[DoubleLeftRightArrow]  \[Backslash]",
  StyleBox["[DoubleLeftRightArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1154"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["<=>\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1154"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1154"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleLeftRightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DoubleLeftRightArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1154"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate logical \
equivalence. \
\>", "Notes",
  CellTags->"S1.1154"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1154"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1154"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubleLongLeftRightArrow]",
    ButtonData:>{"DoubleLongLeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftRightArrow]",
    ButtonData:>{"LeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrowLeftArrow]",
    ButtonData:>{"RightArrowLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrowRightArrow]",
    ButtonData:>{"LeftArrowRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Congruent]",
    ButtonData:>{"Congruent"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Implies]",
    ButtonData:>{"Implies"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1154"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleLeftTee", "ObjectName",
  CellTags->"S1.1155"],

Cell[TextData[{
  "\[DoubleLeftTee]  \[Backslash]",
  StyleBox["[DoubleLeftTee]", "MR"]
}], "CharacterName",
  CellTags->"S1.1155"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1155"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleLeftTee] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DoubleLeftTee[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1155"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleLeftTee] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleLeftTee] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  " groups as ",
  StyleBox["(", "MR"],
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleLeftTee] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[")", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleLeftTee] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1155"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in mathematics to indicate various strong forms \
of logical implication of ",
  StyleBox["x", "TI"],
  " from ",
  StyleBox["y", "TI"],
  "\[LongDash]often tautological implication. "
}], "Notes",
  CellTags->"S1.1155"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1155"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftTee]",
    ButtonData:>{"LeftTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleRightTee]",
    ButtonData:>{"DoubleRightTee"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1155"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleLongLeftArrow", "ObjectName",
  CellTags->"S1.1156"],

Cell[TextData[{
  "\[DoubleLongLeftArrow]  \[Backslash]",
  StyleBox["[DoubleLongLeftArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1156"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["<==\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1156"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1156"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["\[ThinSpace]", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleLongLeftArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DoubleLongLeftArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1156"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1156"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubleLeftArrow]",
    ButtonData:>{"DoubleLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LongLeftArrow]",
    ButtonData:>{"LongLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleLongRightArrow]",
    ButtonData:>{"DoubleLongRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1156"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleLongLeftRightArrow", "ObjectName",
  CellTags->"S1.1157"],

Cell[TextData[{
  "\[DoubleLongLeftRightArrow]  \[Backslash]",
  StyleBox["[DoubleLongLeftRightArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1157"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["<==>\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1157"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1157"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["\[ThinSpace]", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleLongLeftRightArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DoubleLongLeftRightArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1157"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1157"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubleLeftRightArrow]",
    ButtonData:>{"DoubleLeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LongLeftRightArrow]",
    ButtonData:>{"LongLeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrowLeftArrow]",
    ButtonData:>{"RightArrowLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrowRightArrow]",
    ButtonData:>{"LeftArrowRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1157"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleLongRightArrow", "ObjectName",
  CellTags->"S1.1158"],

Cell[TextData[{
  "\[DoubleLongRightArrow]  \[Backslash]",
  StyleBox["[DoubleLongRightArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1158"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["==>\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1158"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1158"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["\[ThinSpace]", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleLongRightArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DoubleLongRightArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1158"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1158"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubleRightArrow]",
    ButtonData:>{"DoubleRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LongRightArrow]",
    ButtonData:>{"LongRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleLongLeftArrow]",
    ButtonData:>{"DoubleLongLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1158"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoublePrime", "ObjectName",
  CellTags->"S1.1159"],

Cell[TextData[{
  "\[DoublePrime]  \[Backslash]",
  StyleBox["[DoublePrime]", "MR"]
}], "CharacterName",
  CellTags->"S1.1159"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["''\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1159"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1159"],

Cell["\<\
\[FilledSmallSquare] Used to indicate angles in seconds or \
distances in inches. \
\>", "Notes",
  CellTags->"S1.1159"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1159"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Prime]",
    ButtonData:>{"Prime"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReverseDoublePrime]",
    ButtonData:>{"ReverseDoublePrime"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1159"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleRightArrow", "ObjectName",
  CellTags->"S1.1160"],

Cell[TextData[{
  "\[DoubleRightArrow]  \[Backslash]",
  StyleBox["[DoubleRightArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1160"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  StyleBox["=>\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1160"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1160"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleRightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DoubleRightArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1160"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate various strong \
forms of convergence. \
\>", "Notes",
  CellTags->"S1.1160"],

Cell["\<\
\[FilledSmallSquare] Also used to indicate algebraic field \
extensions. \
\>", "Notes",
  CellTags->"S1.1160"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Implies]",
    ButtonData:>{"Implies"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1160"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1160"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1160"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubleLongRightArrow]",
    ButtonData:>{"DoubleLongRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleLeftArrow]",
    ButtonData:>{"DoubleLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1160"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleRightTee", "ObjectName",
  CellTags->"S1.1161"],

Cell[TextData[{
  "\[DoubleRightTee]  \[Backslash]",
  StyleBox["[DoubleRightTee]", "MR"]
}], "CharacterName",
  CellTags->"S1.1161"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1161"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleRightTee] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DoubleRightTee[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1161"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleRightTee] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleRightTee] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  " groups as ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleRightTee] \)], "InlineFormula"],
  " ",
  StyleBox["(", "MR"],
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleRightTee] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[")", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1161"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate various strong \
forms of logical implication\[LongDash]often tautological implication. \
\>", \
"Notes",
  CellTags->"S1.1161"],

Cell["\<\
\[FilledSmallSquare] In prefix form, used to indicate a tautology. \
\
\>", "Notes",
  CellTags->"S1.1161"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1161"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightTee]",
    ButtonData:>{"RightTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleLeftTee]",
    ButtonData:>{"DoubleLeftTee"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1161"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleStruckA \[Ellipsis] DoubleStruckZ", "ObjectName",
  CellTags->"S1.1162"],

Cell[TextData[{
  "\[DoubleStruckA] \[Ellipsis] \[DoubleStruckZ]  \[Backslash]",
  StyleBox["[DoubleStruckA]", "MR"],
  " \[Ellipsis] \[Backslash]",
  StyleBox["[DoubleStruckZ]", "MR"]
}], "CharacterName",
  CellTags->"S1.1162"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["dsa\[AliasIndicator]", "MR"],
  " through \[AliasIndicator]",
  StyleBox["dsz\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1162"],

Cell["\[FilledSmallSquare] Letters. ", "Notes",
  CellTags->"S1.1162"],

Cell["\<\
\[FilledSmallSquare] Treated as distinct characters rather than \
style modifications of ordinary letters. \
\>", "Notes",
  CellTags->"S1.1162"],

Cell["\<\
\[FilledSmallSquare] Contiguous character codes from the private \
Unicode character range are used, even though a few double\[Hyphen]struck \
characters are included in ordinary Unicode. \
\>", "Notes",
  CellTags->"S1.1162"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.19"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1162"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubleStruckCapitalA]",
    ButtonData:>{"DoubleStruckCapitalA"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GothicA]",
    ButtonData:>{"GothicA"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ScriptA]",
    ButtonData:>{"ScriptA"},
    ButtonStyle->"MainBookLinkMR"],
  ", etc. "
}], "Notes",
  CellTags->"S1.1162"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DoubleStruckCapitalA \[Ellipsis] DoubleStruckCapitalZ\
\>", \
"ObjectName",
  CellTags->"S1.1163"],

Cell[TextData[{
  "\[DoubleStruckCapitalA] \[Ellipsis] \[DoubleStruckCapitalZ]  \
\[Backslash]",
  StyleBox["[DoubleStruckCapitalA]", "MR"],
  " \[Ellipsis] \[Backslash]",
  StyleBox["[DoubleStruckCapitalZ]", "MR"]
}], "CharacterName",
  CellTags->"S1.1163"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["dsA\[AliasIndicator]", "MR"],
  " through \[AliasIndicator]",
  StyleBox["dsZ\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1163"],

Cell["\[FilledSmallSquare] Letters. ", "Notes",
  CellTags->"S1.1163"],

Cell["\<\
\[FilledSmallSquare] Treated as distinct characters rather than \
style modifications of ordinary letters. \
\>", "Notes",
  CellTags->"S1.1163"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalN]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalH]\)], "InlineFormula"],
  " are used respectively to denote the sets of natural numbers, integers, \
rationals, reals, complex numbers and quaternions. "
}], "Notes",
  CellTags->"S1.1163"],

Cell["\<\
\[FilledSmallSquare] Contiguous character codes from the private \
Unicode character range are used, even though a few capital \
double\[Hyphen]struck characters are included in ordinary Unicode. \
\>", \
"Notes",
  CellTags->"S1.1163"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.19"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1163"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GothicCapitalA]",
    ButtonData:>{"GothicCapitalA"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ScriptCapitalA]",
    ButtonData:>{"ScriptCapitalA"},
    ButtonStyle->"MainBookLinkMR"],
  ", etc. "
}], "Notes",
  CellTags->"S1.1163"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleUpArrow", "ObjectName",
  CellTags->"S1.1164"],

Cell[TextData[{
  "\[DoubleUpArrow]  \[Backslash]",
  StyleBox["[DoubleUpArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1164"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1164"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleUpArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DoubleUpArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1164"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1164"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1164"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UpArrow]",
    ButtonData:>{"UpArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleDownArrow]",
    ButtonData:>{"DoubleDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1164"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleUpDownArrow", "ObjectName",
  CellTags->"S1.1165"],

Cell[TextData[{
  "\[DoubleUpDownArrow]  \[Backslash]",
  StyleBox["[DoubleUpDownArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1165"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1165"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleUpDownArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DoubleUpDownArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1165"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1165"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1165"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UpDownArrow]",
    ButtonData:>{"UpDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrowDownArrow]",
    ButtonData:>{"UpArrowDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownArrowUpArrow]",
    ButtonData:>{"DownArrowUpArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1165"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DoubleVerticalBar", "ObjectName",
  CellTags->"S1.1166"],

Cell[TextData[{
  "\[DoubleVerticalBar]  \[Backslash]",
  StyleBox["[DoubleVerticalBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1166"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  StyleBox["||\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1166"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1166"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DoubleVerticalBar] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DoubleVerticalBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1166"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in mathematics to indicate that ",
  StyleBox["x", "TI"],
  " exactly divides ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1166"],

Cell["\<\
\[FilledSmallSquare] Used in geometry to mean \
\[OpenCurlyDoubleQuote]parallel to\[CloseCurlyDoubleQuote]. \
\>", "Notes",
  CellTags->"S1.1166"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][LeftDoubleBracketingBar]",
    ButtonData:>{"LeftDoubleBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightDoubleBracketingBar]",
    ButtonData:>{"RightDoubleBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1166"],

Cell[TextData[{
  "\[FilledSmallSquare] \[AliasIndicator]",
  StyleBox["||\[AliasIndicator]", "MR"],
  " is the alias for ",
  ButtonBox["\[Backslash][Or]",
    ButtonData:>{"Or"},
    ButtonStyle->"MainBookLinkMR"],
  ". The alias for \[Backslash]",
  StyleBox["[DoubleVerticalBar]", "MR"],
  " has a space at the beginning. "
}], "Notes",
  CellTags->"S1.1166"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1166"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][VerticalBar]",
    ButtonData:>{"VerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VerticalSeparator]",
    ButtonData:>{"VerticalSeparator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotDoubleVerticalBar]",
    ButtonData:>{"NotDoubleVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1166"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownArrow", "ObjectName",
  CellTags->"S1.1167"],

Cell[TextData[{
  "\[DownArrow]  \[Backslash]",
  StyleBox["[DownArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1167"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1167"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DownArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DownArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1167"],

Cell["\<\
\[FilledSmallSquare] Used to indicate monotonic decrease to a \
limit. \
\>", "Notes",
  CellTags->"S1.1167"],

Cell["\<\
\[FilledSmallSquare] Sometimes used for logical nor. \
\>", "Notes",
  CellTags->"S1.1167"],

Cell["\<\
\[FilledSmallSquare] Sometimes used in prefix form to indicate the \
closure of a set. \
\>", "Notes",
  CellTags->"S1.1167"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1167"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1167"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownTeeArrow]",
    ButtonData:>{"DownTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownArrowBar]",
    ButtonData:>{"DownArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleDownArrow]",
    ButtonData:>{"DoubleDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftDownVector]",
    ButtonData:>{"LeftDownVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrow]",
    ButtonData:>{"UpArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1167"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownArrowBar", "ObjectName",
  CellTags->"S1.1168"],

Cell[TextData[{
  "\[DownArrowBar]  \[Backslash]",
  StyleBox["[DownArrowBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1168"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1168"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DownArrowBar]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DownArrowBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1168"],

Cell["\<\
\[FilledSmallSquare] Sometimes used as an indicator of depth. \
\
\>", "Notes",
  CellTags->"S1.1168"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1168"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1168"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownTeeArrow]",
    ButtonData:>{"DownTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownArrow]",
    ButtonData:>{"DownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftDownVectorBar]",
    ButtonData:>{"LeftDownVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrowBar]",
    ButtonData:>{"UpArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1168"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownArrowUpArrow", "ObjectName",
  CellTags->"S1.1169"],

Cell[TextData[{
  "\[DownArrowUpArrow]  \[Backslash]",
  StyleBox["[DownArrowUpArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1169"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1169"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DownArrowUpArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DownArrowUpArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1169"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1169"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1169"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UpDownArrow]",
    ButtonData:>{"UpDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleUpDownArrow]",
    ButtonData:>{"DoubleUpDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrowDownArrow]",
    ButtonData:>{"UpArrowDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpEquilibrium]",
    ButtonData:>{"UpEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1169"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownBreve", "ObjectName",
  CellTags->"S1.1170"],

Cell[TextData[{
  "\[DownBreve]  \[Backslash]",
  StyleBox["[DownBreve]", "MR"]
}], "CharacterName",
  CellTags->"S1.1170"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["dbv\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1170"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1170"],

Cell["\<\
\[FilledSmallSquare] Used in an overscript position as a \
diacritical mark. \
\>", "Notes",
  CellTags->"S1.1170"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.38"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1170"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Breve]",
    ButtonData:>{"Breve"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Cap]",
    ButtonData:>{"Cap"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1170"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownExclamation", "ObjectName",
  CellTags->"S1.1171"],

Cell[TextData[{
  "\[DownExclamation]  \[Backslash]",
  StyleBox["[DownExclamation]", "MR"]
}], "CharacterName",
  CellTags->"S1.1171"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["d!\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1171"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1171"],

Cell["\[FilledSmallSquare] Used in Spanish. ", "Notes",
  CellTags->"S1.1171"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1171"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawExclamation]",
    ButtonData:>{"RawExclamation"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownQuestion]",
    ButtonData:>{"DownQuestion"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1171"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownLeftRightVector", "ObjectName",
  CellTags->"S1.1172"],

Cell[TextData[{
  "\[DownLeftRightVector]  \[Backslash]",
  StyleBox["[DownLeftRightVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1172"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1172"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DownLeftRightVector]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DownLeftRightVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1172"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1172"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1172"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftRightVector]",
    ButtonData:>{"LeftRightVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Equilibrium]",
    ButtonData:>{"Equilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightUpDownVector]",
    ButtonData:>{"RightUpDownVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1172"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownLeftTeeVector", "ObjectName",
  CellTags->"S1.1173"],

Cell[TextData[{
  "\[DownLeftTeeVector]  \[Backslash]",
  StyleBox["[DownLeftTeeVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1173"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1173"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DownLeftTeeVector] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DownLeftTeeVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1173"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1173"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1173"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftTeeVector]",
    ButtonData:>{"LeftTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftVectorBar]",
    ButtonData:>{"LeftVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1173"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownLeftVector", "ObjectName",
  CellTags->"S1.1174"],

Cell[TextData[{
  "\[DownLeftVector]  \[Backslash]",
  StyleBox["[DownLeftVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1174"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1174"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DownLeftVector] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DownLeftVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1174"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1174"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1174"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftVector]",
    ButtonData:>{"LeftVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTeeVector]",
    ButtonData:>{"LeftTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrow]",
    ButtonData:>{"LeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftUpVector]",
    ButtonData:>{"LeftUpVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1174"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownLeftVectorBar", "ObjectName",
  CellTags->"S1.1175"],

Cell[TextData[{
  "\[DownLeftVectorBar]  \[Backslash]",
  StyleBox["[DownLeftVectorBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1175"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1175"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DownLeftVectorBar]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DownLeftVectorBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1175"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1175"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1175"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftVectorBar]",
    ButtonData:>{"LeftVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTeeVector]",
    ButtonData:>{"LeftTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1175"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownQuestion", "ObjectName",
  CellTags->"S1.1176"],

Cell[TextData[{
  "\[DownQuestion]  \[Backslash]",
  StyleBox["[DownQuestion]", "MR"]
}], "CharacterName",
  CellTags->"S1.1176"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["d?\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1176"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1176"],

Cell["\[FilledSmallSquare] Used in Spanish. ", "Notes",
  CellTags->"S1.1176"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1176"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawQuestion]",
    ButtonData:>{"RawQuestion"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownExclamation]",
    ButtonData:>{"DownExclamation"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1176"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownRightTeeVector", "ObjectName",
  CellTags->"S1.1177"],

Cell[TextData[{
  "\[DownRightTeeVector]  \[Backslash]",
  StyleBox["[DownRightTeeVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1177"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1177"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DownRightTeeVector] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DownRightTeeVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1177"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1177"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1177"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightTeeVector]",
    ButtonData:>{"RightTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightVectorBar]",
    ButtonData:>{"RightVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1177"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownRightVector", "ObjectName",
  CellTags->"S1.1178"],

Cell[TextData[{
  "\[DownRightVector]  \[Backslash]",
  StyleBox["[DownRightVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1178"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1178"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DownRightVector] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DownRightVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1178"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1178"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1178"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightVector]",
    ButtonData:>{"RightVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTeeVector]",
    ButtonData:>{"RightTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightUpVector]",
    ButtonData:>{"RightUpVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1178"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownRightVectorBar", "ObjectName",
  CellTags->"S1.1179"],

Cell[TextData[{
  "\[DownRightVectorBar]  \[Backslash]",
  StyleBox["[DownRightVectorBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1179"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1179"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DownRightVectorBar]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DownRightVectorBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1179"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1179"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1179"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightVectorBar]",
    ButtonData:>{"RightVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTeeVector]",
    ButtonData:>{"RightTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1179"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownTee", "ObjectName",
  CellTags->"S1.1180"],

Cell[TextData[{
  "\[DownTee]  \[Backslash]",
  StyleBox["[DownTee]", "MR"]
}], "CharacterName",
  CellTags->"S1.1180"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["dT\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1180"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1180"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[DownTee] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DownTee[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1180"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1180"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UpTee]",
    ButtonData:>{"UpTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTee]",
    ButtonData:>{"RightTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownTeeArrow]",
    ButtonData:>{"DownTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1180"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DownTeeArrow", "ObjectName",
  CellTags->"S1.1181"],

Cell[TextData[{
  "\[DownTeeArrow]  \[Backslash]",
  StyleBox["[DownTeeArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1181"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1181"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DownTeeArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["DownTeeArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1181"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1181"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1181"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownArrowBar]",
    ButtonData:>{"DownArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightDownTeeVector]",
    ButtonData:>{"RightDownTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownTee]",
    ButtonData:>{"DownTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpTeeArrow]",
    ButtonData:>{"UpTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1181"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EAcute", "ObjectName",
  CellTags->"S1.1182"],

Cell[TextData[{
  "\[EAcute]  \[Backslash]",
  StyleBox["[EAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1182"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["e'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1182"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1182"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1182"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1182"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalEAcute]",
    ButtonData:>{"CapitalEAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1182"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EBar", "ObjectName",
  CellTags->"S1.1183"],

Cell[TextData[{
  "\[EBar]  \[Backslash]",
  StyleBox["[EBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1183"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["e-\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1183"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1183"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]4. ", "Notes",
  CellTags->"S1.1183"],

Cell["\<\
\[FilledSmallSquare] Used in transliterations of various non\
\[Hyphen]Latin alphabets. \
\>", "Notes",
  CellTags->"S1.1183"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1183"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalEBar]",
    ButtonData:>{"CapitalEBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1183"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ECup", "ObjectName",
  CellTags->"S1.1184"],

Cell[TextData[{
  "\[ECup]  \[Backslash]",
  StyleBox["[ECup]", "MR"]
}], "CharacterName",
  CellTags->"S1.1184"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["eu\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1184"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1184"],

Cell["\[FilledSmallSquare] Not included in ISO Latin. ", "Notes",
  CellTags->"S1.1184"],

Cell["\<\
\[FilledSmallSquare] Used in transliterations of Cyrillic \
characters. \
\>", "Notes",
  CellTags->"S1.1184"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1184"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalECup]",
    ButtonData:>{"CapitalECup"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1184"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EDoubleDot", "ObjectName",
  CellTags->"S1.1185"],

Cell[TextData[{
  "\[EDoubleDot]  \[Backslash]",
  StyleBox["[EDoubleDot]", "MR"]
}], "CharacterName",
  CellTags->"S1.1185"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["e\"\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1185"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1185"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1185"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1185"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalEDoubleDot]",
    ButtonData:>{"CapitalEDoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][IDoubleDot]",
    ButtonData:>{"IDoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ADoubleDot]",
    ButtonData:>{"ADoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1185"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EGrave", "ObjectName",
  CellTags->"S1.1186"],

Cell[TextData[{
  "\[EGrave]  \[Backslash]",
  StyleBox["[EGrave]", "MR"]
}], "CharacterName",
  CellTags->"S1.1186"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["e`\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1186"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1186"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1186"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1186"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalEGrave]",
    ButtonData:>{"CapitalEGrave"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1186"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EHat", "ObjectName",
  CellTags->"S1.1187"],

Cell[TextData[{
  "\[EHat]  \[Backslash]",
  StyleBox["[EHat]", "MR"]
}], "CharacterName",
  CellTags->"S1.1187"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["e^\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1187"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1187"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1187"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1187"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalEHat]",
    ButtonData:>{"CapitalEHat"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1187"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Element", "ObjectName",
  CellTags->"S1.1188"],

Cell[TextData[{
  "\[Element]  \[Backslash]",
  StyleBox["[Element]", "MR"]
}], "CharacterName",
  CellTags->"S1.1188"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["el\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1188"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1188"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Element[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1188"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Epsilon]",
    ButtonData:>{"Epsilon"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1188"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1188"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotElement]",
    ButtonData:>{"NotElement"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReverseElement]",
    ButtonData:>{"ReverseElement"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Euro]",
    ButtonData:>{"Euro"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1188"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ellipsis", "ObjectName",
  CellTags->"S1.1189"],

Cell[TextData[{
  "\[Ellipsis]  \[Backslash]",
  StyleBox["[Ellipsis]", "MR"]
}], "CharacterName",
  CellTags->"S1.1189"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["...\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1189"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1189"],

Cell["\<\
\[FilledSmallSquare] Used to indicate omitted elements in a row of \
a matrix. \
\>", "Notes",
  CellTags->"S1.1189"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[Ellipsis]", "MR"],
  " on its own will act as a symbol. "
}], "Notes",
  CellTags->"S1.1189"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1189"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CenterEllipsis]",
    ButtonData:>{"CenterEllipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VerticalEllipsis]",
    ButtonData:>{"VerticalEllipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][AscendingEllipsis]",
    ButtonData:>{"AscendingEllipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][HorizontalLine]",
    ButtonData:>{"HorizontalLine"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftSkeleton]",
    ButtonData:>{"LeftSkeleton"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawDot]",
    ButtonData:>{"RawDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1189"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EmptyCircle", "ObjectName",
  CellTags->"S1.1190"],

Cell[TextData[{
  "\[EmptyCircle]  \[Backslash]",
  StyleBox["[EmptyCircle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1190"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["eci\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1190"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1190"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as the infix operator ",
  ButtonBox["\[Backslash][SmallCircle]",
    ButtonData:>{"SmallCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1190"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1190"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EmptySmallCircle]",
    ButtonData:>{"EmptySmallCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledCircle]",
    ButtonData:>{"FilledCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Degree]",
    ButtonData:>{"Degree"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1190"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EmptyDiamond", "ObjectName",
  CellTags->"S1.1191"],

Cell[TextData[{
  "\[EmptyDiamond]  \[Backslash]",
  StyleBox["[EmptyDiamond]", "MR"]
}], "CharacterName",
  CellTags->"S1.1191"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1191"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1191"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Diamond]",
    ButtonData:>{"Diamond"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledDiamond]",
    ButtonData:>{"FilledDiamond"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1191"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EmptyDownTriangle", "ObjectName",
  CellTags->"S1.1192"],

Cell[TextData[{
  "\[EmptyDownTriangle]  \[Backslash]",
  StyleBox["[EmptyDownTriangle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1192"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1192"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Del]",
    ButtonData:>{"Del"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1192"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1192"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EmptyUpTriangle]",
    ButtonData:>{"EmptyUpTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledDownTriangle]",
    ButtonData:>{"FilledDownTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledUpTriangle]",
    ButtonData:>{"FilledUpTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTriangle]",
    ButtonData:>{"LeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLeftTriangle]",
    ButtonData:>{"NotLeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotRightTriangle]",
    ButtonData:>{"NotRightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangle]",
    ButtonData:>{"RightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1192"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EmptyRectangle", "ObjectName",
  CellTags->"S1.1193"],

Cell[TextData[{
  "\[EmptyRectangle]  \[Backslash]",
  StyleBox["[EmptyRectangle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1193"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1193"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1193"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][FilledRectangle]",
    ButtonData:>{"FilledRectangle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1193"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EmptySet", "ObjectName",
  CellTags->"S1.1194"],

Cell[TextData[{
  "\[EmptySet]  \[Backslash]",
  StyleBox["[EmptySet]", "MR"]
}], "CharacterName",
  CellTags->"S1.1194"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["es\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1194"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1194"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][CapitalOSlash]",
    ButtonData:>{"CapitalOSlash"},
    ButtonStyle->"MainBookLinkMR"],
  " or ",
  ButtonBox["\[Backslash][Diameter]",
    ButtonData:>{"Diameter"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1194"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1194"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EmptySmallCircle", "ObjectName",
  CellTags->"S1.1195"],

Cell[TextData[{
  "\[EmptySmallCircle]  \[Backslash]",
  StyleBox["[EmptySmallCircle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1195"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["esci\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1195"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1195"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as the infix operator ",
  ButtonBox["\[Backslash][SmallCircle]",
    ButtonData:>{"SmallCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1195"],

Cell["\<\
\[FilledSmallSquare] Used as an overscript to add ring diacritical \
marks. \
\>", "Notes",
  CellTags->"S1.1195"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1195"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][FilledSmallCircle]",
    ButtonData:>{"FilledSmallCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Degree]",
    ButtonData:>{"Degree"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ARing]",
    ButtonData:>{"ARing"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Angstrom]",
    ButtonData:>{"Angstrom"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1195"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EmptySmallSquare", "ObjectName",
  CellTags->"S1.1196"],

Cell[TextData[{
  "\[EmptySmallSquare]  \[Backslash]",
  StyleBox["[EmptySmallSquare]", "MR"]
}], "CharacterName",
  CellTags->"S1.1196"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["essq\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1196"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1196"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as the operator ",
  ButtonBox["\[Backslash][Square]",
    ButtonData:>{"Square"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1196"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Placeholder]",
    ButtonData:>{"Placeholder"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1196"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1196"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EmptySquare]",
    ButtonData:>{"EmptySquare"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledSmallSquare]",
    ButtonData:>{"FilledSmallSquare"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1196"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EmptySquare", "ObjectName",
  CellTags->"S1.1197"],

Cell[TextData[{
  "\[EmptySquare]  \[Backslash]",
  StyleBox["[EmptySquare]", "MR"]
}], "CharacterName",
  CellTags->"S1.1197"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["esq\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1197"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1197"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as the operator ",
  ButtonBox["\[Backslash][Square]",
    ButtonData:>{"Square"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1197"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Placeholder]",
    ButtonData:>{"Placeholder"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1197"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1197"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][FilledSquare]",
    ButtonData:>{"FilledSquare"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GraySquare]",
    ButtonData:>{"GraySquare"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DottedSquare]",
    ButtonData:>{"DottedSquare"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptyRectangle]",
    ButtonData:>{"EmptyRectangle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1197"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EmptyUpTriangle", "ObjectName",
  CellTags->"S1.1198"],

Cell[TextData[{
  "\[EmptyUpTriangle]  \[Backslash]",
  StyleBox["[EmptyUpTriangle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1198"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1198"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in geometry to indicate a triangle, as in the \
symbol ",
  Cell[BoxData[
      \(TraditionalForm\`\[EmptyUpTriangle]\)], "InlineFormula"],
  StyleBox["ABC", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1198"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][CapitalDelta]",
    ButtonData:>{"CapitalDelta"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1198"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.31"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1198"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][FilledUpTriangle]",
    ButtonData:>{"FilledUpTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptyDownTriangle]",
    ButtonData:>{"EmptyDownTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangle]",
    ButtonData:>{"RightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Angle]",
    ButtonData:>{"Angle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1198"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EnterKey", "ObjectName",
  CellTags->"S1.1199"],

Cell[TextData[{
  "\[EnterKey]  \[Backslash]",
  StyleBox["[EnterKey]", "MR"]
}], "CharacterName",
  CellTags->"S1.1199"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["ent\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1199"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1199"],

Cell["\<\
\[FilledSmallSquare] Representation of the Enter key on a keyboard. \
\
\>", "Notes",
  CellTags->"S1.1199"],

Cell["\<\
\[FilledSmallSquare] Used in describing how to type textual input. \
\
\>", "Notes",
  CellTags->"S1.1199"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1199"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ReturnKey]",
    ButtonData:>{"ReturnKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReturnIndicator]",
    ButtonData:>{"ReturnIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ControlKey]",
    ButtonData:>{"ControlKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CommandKey]",
    ButtonData:>{"CommandKey"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1199"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EntityEnd", "ObjectName",
  CellTags->"S1.1200"],

Cell[TextData[{
  "\[EntityEnd]  \[Backslash]",
  StyleBox["[EntityEnd]", "MR"]
}], "CharacterName",
  CellTags->"S1.1200"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1200"],

Cell["\<\
\[FilledSmallSquare] Used to indicate the end of an \
XML\[Hyphen]style entity specifier. \
\>", "Notes",
  CellTags->"S1.1200"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EntityStart]",
    ButtonData:>{"EntityStart"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1200"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EntityStart", "ObjectName",
  CellTags->"S1.1201"],

Cell[TextData[{
  "\[EntityStart]  \[Backslash]",
  StyleBox["[EntityStart]", "MR"]
}], "CharacterName",
  CellTags->"S1.1201"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1201"],

Cell["\<\
\[FilledSmallSquare] Used to indicate the start of an \
XML\[Hyphen]style entity specifier. \
\>", "Notes",
  CellTags->"S1.1201"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EntityEnd]",
    ButtonData:>{"EntityEnd"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1201"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Epsilon", "ObjectName",
  CellTags->"S1.1202"],

Cell[TextData[{
  "\[Epsilon]  \[Backslash]",
  StyleBox["[Epsilon]", "MR"]
}], "CharacterName",
  CellTags->"S1.1202"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["e\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["epsilon\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1202"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1202"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Element]",
    ButtonData:>{"Element"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1202"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1202"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CurlyEpsilon]",
    ButtonData:>{"CurlyEpsilon"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalEpsilon]",
    ButtonData:>{"CapitalEpsilon"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Eta]",
    ButtonData:>{"Eta"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Euro]",
    ButtonData:>{"Euro"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1202"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equal", "ObjectName",
  CellTags->"S1.1203"],

Cell[TextData[{
  "\[Equal]  \[Backslash]",
  StyleBox["[Equal]", "MR"]
}], "CharacterName",
  CellTags->"S1.1203"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["==\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1203"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1203"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Equal] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Equal[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  " or ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1203"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[Equal]", "MR"],
  " is drawn longer than ",
  ButtonBox["\[Backslash][RawEqual]",
    ButtonData:>{"RawEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1203"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1203"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LongEqual]",
    ButtonData:>{"LongEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotEqual]",
    ButtonData:>{"NotEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Congruent]",
    ButtonData:>{"Congruent"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Rule]",
    ButtonData:>{"Rule"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1203"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EqualTilde", "ObjectName",
  CellTags->"S1.1204"],

Cell[TextData[{
  "\[EqualTilde]  \[Backslash]",
  StyleBox["[EqualTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1204"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["=", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1204"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1204"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[EqualTilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["EqualTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1204"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1204"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotEqualTilde]",
    ButtonData:>{"NotEqualTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1204"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equilibrium", "ObjectName",
  CellTags->"S1.1205"],

Cell[TextData[{
  "\[Equilibrium]  \[Backslash]",
  StyleBox["[Equilibrium]", "MR"]
}], "CharacterName",
  CellTags->"S1.1205"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["equi\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1205"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1205"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Equilibrium] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Equilibrium[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1205"],

Cell["\<\
\[FilledSmallSquare] Used in chemistry to represent a reversible \
reaction. \
\>", "Notes",
  CellTags->"S1.1205"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1205"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1205"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ReverseEquilibrium]",
    ButtonData:>{"ReverseEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrowLeftArrow]",
    ButtonData:>{"RightArrowLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftRightArrow]",
    ButtonData:>{"LeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftRightVector]",
    ButtonData:>{"LeftRightVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpEquilibrium]",
    ButtonData:>{"UpEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  "."
}], "Notes",
  CellTags->"S1.1205"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ErrorIndicator", "ObjectName",
  CellTags->"S1.1206"],

Cell[TextData[{
  "\[ErrorIndicator]  \[Backslash]",
  StyleBox["[ErrorIndicator]", "MR"]
}], "CharacterName",
  CellTags->"S1.1206"],

Cell["\[FilledSmallSquare] Uninterpretable element. ", "Notes",
  CellTags->"S1.1206"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated to indicate the position of a syntax error \
in messages produced by functions like ",
  StyleBox["Get", "MR"],
  " and ",
  StyleBox["ToExpression", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1206"],

Cell[TextData[{
  "\[FilledSmallSquare] Shown as ",
  StyleBox["^^^", "MR"],
  " in ",
  StyleBox["OutputForm", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1206"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[ErrorIndicator]", "MR"],
  " indicates the presence of a syntax error, and so by default generates an \
error if you try to interpret it. "
}], "Notes",
  CellTags->"S1.1206"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftSkeleton]",
    ButtonData:>{"LeftSkeleton"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1206"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EscapeKey", "ObjectName",
  CellTags->"S1.1207"],

Cell[TextData[{
  "\[EscapeKey]  \[Backslash]",
  StyleBox["[EscapeKey]", "MR"]
}], "CharacterName",
  CellTags->"S1.1207"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  StyleBox["esc\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1207"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1207"],

Cell["\<\
\[FilledSmallSquare] Representation of the Escape key on a \
keyboard. \
\>", "Notes",
  CellTags->"S1.1207"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in describing how to type aliases for special \
characters in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1207"],

Cell[TextData[{
  "\[FilledSmallSquare] \[AliasIndicator]",
  StyleBox["esc\[AliasIndicator]", "MR"],
  " is the alias for ",
  ButtonBox["\[Backslash][AliasIndicator]",
    ButtonData:>{"AliasIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ". The alias for \[Backslash]",
  StyleBox["[EscapeKey]", "MR"],
  " has a space at the beginning. "
}], "Notes",
  CellTags->"S1.1207"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1207"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][AliasIndicator]",
    ButtonData:>{"AliasIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawEscape]",
    ButtonData:>{"RawEscape"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReturnKey]",
    ButtonData:>{"ReturnKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ControlKey]",
    ButtonData:>{"ControlKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CommandKey]",
    ButtonData:>{"CommandKey"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1207"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eta", "ObjectName",
  CellTags->"S1.1208"],

Cell[TextData[{
  "\[Eta]  \[Backslash]",
  StyleBox["[Eta]", "MR"]
}], "CharacterName",
  CellTags->"S1.1208"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["et\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["eta\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["h\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1208"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1208"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["DedekindEta", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1208"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1208"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalEta]",
    ButtonData:>{"CapitalEta"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Epsilon]",
    ButtonData:>{"Epsilon"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1208"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eth", "ObjectName",
  CellTags->"S1.1209"],

Cell[TextData[{
  "\[Eth]  \[Backslash]",
  StyleBox["[Eth]", "MR"]
}], "CharacterName",
  CellTags->"S1.1209"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["d-\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1209"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1209"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1209"],

Cell["\<\
\[FilledSmallSquare] Used in Icelandic and Old English. \
\>", \
"Notes",
  CellTags->"S1.1209"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1209"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalEth]",
    ButtonData:>{"CapitalEth"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Thorn]",
    ButtonData:>{"Thorn"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][PartialD]",
    ButtonData:>{"PartialD"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1209"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Euro", "ObjectName",
  CellTags->"S1.1210"],

Cell[TextData[{
  "\[Euro]  \[Backslash]",
  StyleBox["[Euro]", "MR"]
}], "CharacterName",
  CellTags->"S1.1210"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1210"],

Cell[TextData[{
  "\[FilledSmallSquare] Sign for euro European currency, as in ",
  Cell[BoxData[
      \(TraditionalForm\`\[Euro]\)], "InlineFormula"],
  " ",
  StyleBox["5", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1210"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1210"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Epsilon]",
    ButtonData:>{"Epsilon"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Element]",
    ButtonData:>{"Element"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Sterling]",
    ButtonData:>{"Sterling"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1210"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exists", "ObjectName",
  CellTags->"S1.1211"],

Cell[TextData[{
  "\[Exists]  \[Backslash]",
  StyleBox["[Exists]", "MR"]
}], "CharacterName",
  CellTags->"S1.1211"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["ex\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1211"],

Cell["\[FilledSmallSquare] Compound operator. ", "Notes",
  CellTags->"S1.1211"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      RowBox[{
        SubscriptBox["\[Exists]", 
          StyleBox["x",
            "TI"]], 
        StyleBox["y",
          "TI"]}]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Exists[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1211"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1211"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotExists]",
    ButtonData:>{"NotExists"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1211"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ExponentialE", "ObjectName",
  CellTags->"S1.1212"],

Cell[TextData[{
  "\[ExponentialE]  \[Backslash]",
  StyleBox["[ExponentialE]", "MR"]
}], "CharacterName",
  CellTags->"S1.1212"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["ee\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1212"],

Cell["\<\
\[FilledSmallSquare] Letter\[Hyphen]like form with built\[Hyphen]in \
value. \
\>", "Notes",
  CellTags->"S1.1212"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\)], "InlineFormula"],
  " is interpreted by default as the symbol ",
  StyleBox["E", "MR"],
  ", representing the exponential constant. "
}], "Notes",
  CellTags->"S1.1212"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.27"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.2",
    ButtonData:>{"3.10.2", "2.3"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1212"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DifferentialD]",
    ButtonData:>{"DifferentialD"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ImaginaryI]",
    ButtonData:>{"ImaginaryI"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1212"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FilledCircle", "ObjectName",
  CellTags->"S1.1213"],

Cell[TextData[{
  "\[FilledCircle]  \[Backslash]",
  StyleBox["[FilledCircle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1213"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["fci\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1213"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1213"],

Cell["\[FilledSmallSquare] Used as a dingbat. ", "Notes",
  CellTags->"S1.1213"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1213"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Bullet]",
    ButtonData:>{"Bullet"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledSmallCircle]",
    ButtonData:>{"FilledSmallCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SmallCircle]",
    ButtonData:>{"SmallCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptyCircle]",
    ButtonData:>{"EmptyCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1213"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FilledDiamond", "ObjectName",
  CellTags->"S1.1214"],

Cell[TextData[{
  "\[FilledDiamond]  \[Backslash]",
  StyleBox["[FilledDiamond]", "MR"]
}], "CharacterName",
  CellTags->"S1.1214"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1214"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1214"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Diamond]",
    ButtonData:>{"Diamond"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptyDiamond]",
    ButtonData:>{"EmptyDiamond"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1214"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FilledDownTriangle", "ObjectName",
  CellTags->"S1.1215"],

Cell[TextData[{
  "\[FilledDownTriangle]  \[Backslash]",
  StyleBox["[FilledDownTriangle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1215"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1215"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1215"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EmptyDownTriangle]",
    ButtonData:>{"EmptyDownTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptyUpTriangle]",
    ButtonData:>{"EmptyUpTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledUpTriangle]",
    ButtonData:>{"FilledUpTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTriangle]",
    ButtonData:>{"LeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLeftTriangle]",
    ButtonData:>{"NotLeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotRightTriangle]",
    ButtonData:>{"NotRightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangle]",
    ButtonData:>{"RightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1215"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FilledRectangle", "ObjectName",
  CellTags->"S1.1216"],

Cell[TextData[{
  "\[FilledRectangle]  \[Backslash]",
  StyleBox["[FilledRectangle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1216"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1216"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate the end of a \
proof. \
\>", "Notes",
  CellTags->"S1.1216"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1216"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EmptyRectangle]",
    ButtonData:>{"EmptyRectangle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1216"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FilledSmallCircle", "ObjectName",
  CellTags->"S1.1217"],

Cell[TextData[{
  "\[FilledSmallCircle]  \[Backslash]",
  StyleBox["[FilledSmallCircle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1217"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["fsci\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1217"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1217"],

Cell["\[FilledSmallSquare] Used as a dingbat. ", "Notes",
  CellTags->"S1.1217"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1217"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Bullet]",
    ButtonData:>{"Bullet"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledCircle]",
    ButtonData:>{"FilledCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptySmallCircle]",
    ButtonData:>{"EmptySmallCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1217"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FilledSmallSquare", "ObjectName",
  CellTags->"S1.1218"],

Cell[TextData[{
  "\[FilledSmallSquare]  \[Backslash]",
  StyleBox["[FilledSmallSquare]", "MR"]
}], "CharacterName",
  CellTags->"S1.1218"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["fssq\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1218"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1218"],

Cell["\[FilledSmallSquare] Used as a dingbat. ", "Notes",
  CellTags->"S1.1218"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][SelectionPlaceholder]",
    ButtonData:>{"SelectionPlaceholder"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1218"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1218"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][FilledSquare]",
    ButtonData:>{"FilledSquare"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptySmallSquare]",
    ButtonData:>{"EmptySmallSquare"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Square]",
    ButtonData:>{"Square"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1218"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FilledSquare", "ObjectName",
  CellTags->"S1.1219"],

Cell[TextData[{
  "\[FilledSquare]  \[Backslash]",
  StyleBox["[FilledSquare]", "MR"]
}], "CharacterName",
  CellTags->"S1.1219"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["fsq\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1219"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1219"],

Cell["\[FilledSmallSquare] Used as a dingbat. ", "Notes",
  CellTags->"S1.1219"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][SelectionPlaceholder]",
    ButtonData:>{"SelectionPlaceholder"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1219"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1219"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][FilledSmallSquare]",
    ButtonData:>{"FilledSmallSquare"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptySquare]",
    ButtonData:>{"EmptySquare"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Square]",
    ButtonData:>{"Square"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GraySquare]",
    ButtonData:>{"GraySquare"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledRectangle]",
    ButtonData:>{"FilledRectangle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1219"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FilledUpTriangle", "ObjectName",
  CellTags->"S1.1220"],

Cell[TextData[{
  "\[FilledUpTriangle]  \[Backslash]",
  StyleBox["[FilledUpTriangle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1220"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1220"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1220"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EmptyDownTriangle]",
    ButtonData:>{"EmptyDownTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptyUpTriangle]",
    ButtonData:>{"EmptyUpTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledDownTriangle]",
    ButtonData:>{"FilledDownTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTriangle]",
    ButtonData:>{"LeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLeftTriangle]",
    ButtonData:>{"NotLeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotRightTriangle]",
    ButtonData:>{"NotRightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangle]",
    ButtonData:>{"RightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1220"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FilledVerySmallSquare", "ObjectName",
  CellTags->"S1.1221"],

Cell[TextData[{
  "\[FilledVerySmallSquare]  \[Backslash]",
  StyleBox["[FilledVerySmallSquare]", "MR"]
}], "CharacterName",
  CellTags->"S1.1221"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["fvssq\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1221"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1221"],

Cell["\[FilledSmallSquare] Used as a dingbat. ", "Notes",
  CellTags->"S1.1221"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1221"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][FilledSmallSquare]",
    ButtonData:>{"FilledSmallSquare"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Square]",
    ButtonData:>{"Square"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1221"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FinalSigma", "ObjectName",
  CellTags->"S1.1222"],

Cell[TextData[{
  "\[FinalSigma]  \[Backslash]",
  StyleBox["[FinalSigma]", "MR"]
}], "CharacterName",
  CellTags->"S1.1222"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["fs\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1222"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1222"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in written Greek when ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\)], "InlineFormula"],
  " occurs at the end of a word. "
}], "Notes",
  CellTags->"S1.1222"],

Cell["\<\
\[FilledSmallSquare] Not commonly used in technical notation. \
\
\>", "Notes",
  CellTags->"S1.1222"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Stigma]",
    ButtonData:>{"Stigma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1222"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1222"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Sigma]",
    ButtonData:>{"Sigma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1222"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FivePointedStar", "ObjectName",
  CellTags->"S1.1223"],

Cell[TextData[{
  "\[FivePointedStar]  \[Backslash]",
  StyleBox["[FivePointedStar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1223"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["*5\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1223"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1223"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as the operator ",
  ButtonBox["\[Backslash][Star]",
    ButtonData:>{"Star"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1223"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1223"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][SixPointedStar]",
    ButtonData:>{"SixPointedStar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Star]",
    ButtonData:>{"Star"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawStar]",
    ButtonData:>{"RawStar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1223"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Flat", "ObjectName",
  CellTags->"S1.1224"],

Cell[TextData[{
  "\[Flat]  \[Backslash]",
  StyleBox["[Flat]", "MR"]
}], "CharacterName",
  CellTags->"S1.1224"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1224"],

Cell["\<\
\[FilledSmallSquare] Used to denote musical notes. \
\>", "Notes",
  CellTags->"S1.1224"],

Cell["\<\
\[FilledSmallSquare] Sometimes used in mathematical notation. \
\
\>", "Notes",
  CellTags->"S1.1224"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1224"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Sharp]",
    ButtonData:>{"Sharp"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Natural]",
    ButtonData:>{"Natural"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1224"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ForAll", "ObjectName",
  CellTags->"S1.1225"],

Cell[TextData[{
  "\[ForAll]  \[Backslash]",
  StyleBox["[ForAll]", "MR"]
}], "CharacterName",
  CellTags->"S1.1225"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["fa\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1225"],

Cell["\[FilledSmallSquare] Compound operator. ", "Notes",
  CellTags->"S1.1225"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      RowBox[{
        SubscriptBox["\[ForAll]", 
          StyleBox["x",
            "TI"]], 
        StyleBox["y",
          "TI"]}]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["ForAll[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1225"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1225"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Exists]",
    ButtonData:>{"Exists"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Not]",
    ButtonData:>{"Not"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1225"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FreakedSmiley", "ObjectName",
  CellTags->"S1.1226"],

Cell[TextData[{
  "\[FreakedSmiley]  \[Backslash]",
  StyleBox["[FreakedSmiley]", "MR"]
}], "CharacterName",
  CellTags->"S1.1226"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox[":-@\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1226"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1226"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.30"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1226"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][HappySmiley]",
    ButtonData:>{"HappySmiley"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NeutralSmiley]",
    ButtonData:>{"NeutralSmiley"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SadSmiley]",
    ButtonData:>{"SadSmiley"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][WarningSign]",
    ButtonData:>{"WarningSign"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1226"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gamma", "ObjectName",
  CellTags->"S1.1227"],

Cell[TextData[{
  "\[Gamma]  \[Backslash]",
  StyleBox["[Gamma]", "MR"]
}], "CharacterName",
  CellTags->"S1.1227"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["g\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["gamma\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1227"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1227"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["EulerGamma", "MR"],
  " and ",
  StyleBox["StieltjesGamma", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1227"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1227"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubledGamma]",
    ButtonData:>{"DoubledGamma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalGamma]",
    ButtonData:>{"CapitalGamma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Digamma]",
    ButtonData:>{"Digamma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1227"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gimel", "ObjectName",
  CellTags->"S1.1228"],

Cell[TextData[{
  "\[Gimel]  \[Backslash]",
  StyleBox["[Gimel]", "MR"]
}], "CharacterName",
  CellTags->"S1.1228"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["gi\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1228"],

Cell["\[FilledSmallSquare] Hebrew letter. ", "Notes",
  CellTags->"S1.1228"],

Cell["\<\
\[FilledSmallSquare] Used occasionally in pure mathematics in the \
theory of transfinite cardinals. \
\>", "Notes",
  CellTags->"S1.1228"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1228"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Aleph]",
    ButtonData:>{"Aleph"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1228"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GothicA \[Ellipsis] GothicZ", "ObjectName",
  CellTags->"S1.1229"],

Cell[TextData[{
  "\[GothicA] \[Ellipsis] \[GothicZ]  \[Backslash]",
  StyleBox["[GothicA]", "MR"],
  " \[Ellipsis] \[Backslash]",
  StyleBox["[GothicZ]", "MR"]
}], "CharacterName",
  CellTags->"S1.1229"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["goa\[AliasIndicator]", "MR"],
  " through \[AliasIndicator]",
  StyleBox["goz\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1229"],

Cell["\[FilledSmallSquare] Letters. ", "Notes",
  CellTags->"S1.1229"],

Cell["\<\
\[FilledSmallSquare] Treated as distinct characters rather than \
style modifications of ordinary letters. \
\>", "Notes",
  CellTags->"S1.1229"],

Cell["\[FilledSmallSquare] Used in pure mathematics. ", "Notes",
  CellTags->"S1.1229"],

Cell["\<\
\[FilledSmallSquare] Contiguous character codes from the private \
Unicode character range are used, even though a few gothic characters are \
included in ordinary Unicode. \
\>", "Notes",
  CellTags->"S1.1229"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.19"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1229"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GothicCapitalA]",
    ButtonData:>{"GothicCapitalA"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ScriptA]",
    ButtonData:>{"ScriptA"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleStruckA]",
    ButtonData:>{"DoubleStruckA"},
    ButtonStyle->"MainBookLinkMR"],
  ", etc. "
}], "Notes",
  CellTags->"S1.1229"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GothicCapitalA \[Ellipsis] GothicCapitalZ\
\>", "ObjectName",
  CellTags->"S1.1230"],

Cell[TextData[{
  "\[GothicCapitalA] \[Ellipsis] \[GothicCapitalZ]  \[Backslash]",
  StyleBox["[GothicCapitalA]", "MR"],
  " \[Ellipsis] \[Backslash]",
  StyleBox["[GothicCapitalZ]", "MR"]
}], "CharacterName",
  CellTags->"S1.1230"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["goA\[AliasIndicator]", "MR"],
  " through \[AliasIndicator]",
  StyleBox["goZ\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1230"],

Cell["\[FilledSmallSquare] Letters. ", "Notes",
  CellTags->"S1.1230"],

Cell["\<\
\[FilledSmallSquare] Treated as distinct characters rather than \
style modifications of ordinary letters. \
\>", "Notes",
  CellTags->"S1.1230"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalI]\)], "InlineFormula"],
  " is used to denote imaginary part; ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalR]\)], "InlineFormula"],
  " is used to denote real part. "
}], "Notes",
  CellTags->"S1.1230"],

Cell["\<\
\[FilledSmallSquare] Used in pure mathematics and theory of \
computation. \
\>", "Notes",
  CellTags->"S1.1230"],

Cell["\<\
\[FilledSmallSquare] Contiguous character codes from the private \
Unicode character range are used, even though a few capital gothic characters \
are included in ordinary Unicode. \
\>", "Notes",
  CellTags->"S1.1230"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.19"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1230"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GothicA]",
    ButtonData:>{"GothicA"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ScriptCapitalA]",
    ButtonData:>{"ScriptCapitalA"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleStruckCapitalA]",
    ButtonData:>{"DoubleStruckCapitalA"},
    ButtonStyle->"MainBookLinkMR"],
  ", etc. "
}], "Notes",
  CellTags->"S1.1230"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GrayCircle", "ObjectName",
  CellTags->"S1.1231"],

Cell[TextData[{
  "\[GrayCircle]  \[Backslash]",
  StyleBox["[GrayCircle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1231"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["gci\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1231"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1231"],

Cell["\[FilledSmallSquare] Used as a dingbat. ", "Notes",
  CellTags->"S1.1231"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated internally by ",
  StyleBox["Mathematica", "TI"],
  ", rather than being an explicit font character. "
}], "Notes",
  CellTags->"S1.1231"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1231"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][FilledCircle]",
    ButtonData:>{"FilledCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GraySquare]",
    ButtonData:>{"GraySquare"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1231"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GraySquare", "ObjectName",
  CellTags->"S1.1232"],

Cell[TextData[{
  "\[GraySquare]  \[Backslash]",
  StyleBox["[GraySquare]", "MR"]
}], "CharacterName",
  CellTags->"S1.1232"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["gsq\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1232"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1232"],

Cell["\[FilledSmallSquare] Used as a dingbat. ", "Notes",
  CellTags->"S1.1232"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated internally by ",
  StyleBox["Mathematica", "TI"],
  ", rather than being an explicit font character. "
}], "Notes",
  CellTags->"S1.1232"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1232"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][FilledSquare]",
    ButtonData:>{"FilledSquare"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptySquare]",
    ButtonData:>{"EmptySquare"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1232"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GreaterEqual", "ObjectName",
  CellTags->"S1.1233"],

Cell[TextData[{
  "\[GreaterEqual]  \[Backslash]",
  StyleBox["[GreaterEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1233"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox[">=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1233"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1233"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["GreaterEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1233"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1233"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GreaterSlantEqual]",
    ButtonData:>{"GreaterSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GreaterFullEqual]",
    ButtonData:>{"GreaterFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotGreaterEqual]",
    ButtonData:>{"NotGreaterEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1233"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GreaterEqualLess", "ObjectName",
  CellTags->"S1.1234"],

Cell[TextData[{
  "\[GreaterEqualLess]  \[Backslash]",
  StyleBox["[GreaterEqualLess]", "MR"]
}], "CharacterName",
  CellTags->"S1.1234"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1234"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterEqualLess] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["GreaterEqualLess[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1234"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1234"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LessEqualGreater]",
    ButtonData:>{"LessEqualGreater"},
    ButtonStyle->"MainBookLinkMR"],
  "."
}], "Notes",
  CellTags->"S1.1234"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GreaterFullEqual", "ObjectName",
  CellTags->"S1.1235"],

Cell[TextData[{
  "\[GreaterFullEqual]  \[Backslash]",
  StyleBox["[GreaterFullEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1235"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1235"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterFullEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["GreaterFullEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1235"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1235"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GreaterEqual]",
    ButtonData:>{"GreaterEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GreaterSlantEqual]",
    ButtonData:>{"GreaterSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotGreaterFullEqual]",
    ButtonData:>{"NotGreaterFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1235"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GreaterGreater", "ObjectName",
  CellTags->"S1.1236"],

Cell[TextData[{
  "\[GreaterGreater]  \[Backslash]",
  StyleBox["[GreaterGreater]", "MR"]
}], "CharacterName",
  CellTags->"S1.1236"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1236"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterGreater] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["GreaterGreater[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1236"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][RightGuillemet]",
    ButtonData:>{"RightGuillemet"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1236"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1236"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NestedGreaterGreater]",
    ButtonData:>{"NestedGreaterGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotGreaterGreater]",
    ButtonData:>{"NotGreaterGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotNestedGreaterGreater]",
    ButtonData:>{"NotNestedGreaterGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1236"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GreaterLess", "ObjectName",
  CellTags->"S1.1237"],

Cell[TextData[{
  "\[GreaterLess]  \[Backslash]",
  StyleBox["[GreaterLess]", "MR"]
}], "CharacterName",
  CellTags->"S1.1237"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1237"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterLess] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["GreaterLess[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1237"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1237"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GreaterEqualLess]",
    ButtonData:>{"GreaterEqualLess"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotGreaterLess]",
    ButtonData:>{"NotGreaterLess"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1237"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GreaterSlantEqual", "ObjectName",
  CellTags->"S1.1238"],

Cell[TextData[{
  "\[GreaterSlantEqual]  \[Backslash]",
  StyleBox["[GreaterSlantEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1238"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox[">/\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1238"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1238"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterSlantEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["GreaterEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1238"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1238"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GreaterEqual]",
    ButtonData:>{"GreaterEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GreaterFullEqual]",
    ButtonData:>{"GreaterFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotGreaterSlantEqual]",
    ButtonData:>{"NotGreaterSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1238"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GreaterTilde", "ObjectName",
  CellTags->"S1.1239"],

Cell[TextData[{
  "\[GreaterTilde]  \[Backslash]",
  StyleBox["[GreaterTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1239"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox[">", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1239"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1239"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterTilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["GreaterTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1239"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1239"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotGreaterTilde]",
    ButtonData:>{"NotGreaterTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1239"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hacek", "ObjectName",
  CellTags->"S1.1240"],

Cell[TextData[{
  "\[Hacek]  \[Backslash]",
  StyleBox["[Hacek]", "MR"]
}], "CharacterName",
  CellTags->"S1.1240"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["hck\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1240"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1240"],

Cell["\<\
\[FilledSmallSquare] Used primarily in an overscript position. \
\
\>", "Notes",
  CellTags->"S1.1240"],

Cell["\<\
\[FilledSmallSquare] Used as a diacritical mark in Eastern European \
languages. \
\>", "Notes",
  CellTags->"S1.1240"],

Cell[TextData[{
  "\[FilledSmallSquare] Sometimes used in mathematical notation, for example \
in ",
  Cell[BoxData[
      FormBox[
        OverscriptBox[
          StyleBox["C",
            "TI"], "\[Hacek]"], TraditionalForm]], "InlineFormula"],
  "ech cohomology. "
}], "Notes",
  CellTags->"S1.1240"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.38"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1240"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Vee]",
    ButtonData:>{"Vee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Breve]",
    ButtonData:>{"Breve"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1240"]
}, Open  ]],

Cell[CellGroupData[{

Cell["HappySmiley", "ObjectName",
  CellTags->"S1.1241"],

Cell[TextData[{
  "\[HappySmiley]  \[Backslash]",
  StyleBox["[HappySmiley]", "MR"]
}], "CharacterName",
  CellTags->"S1.1241"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox[":)\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox[":-)\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1241"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1241"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.30"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1241"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NeutralSmiley]",
    ButtonData:>{"NeutralSmiley"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SadSmiley]",
    ButtonData:>{"SadSmiley"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FreakedSmiley]",
    ButtonData:>{"FreakedSmiley"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Wolf]",
    ButtonData:>{"Wolf"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1241"]
}, Open  ]],

Cell[CellGroupData[{

Cell["HBar", "ObjectName",
  CellTags->"S1.1242"],

Cell[TextData[{
  "\[HBar]  \[Backslash]",
  StyleBox["[HBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1242"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["hb\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1242"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1242"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in physics to denote Planck's constant divided \
by ",
  Cell[BoxData[
      \(TraditionalForm\`2  \[Pi]\)], "InlineFormula"],
  "; sometimes called Dirac's constant. "
}], "Notes",
  CellTags->"S1.1242"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1242"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Angstrom]",
    ButtonData:>{"Angstrom"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1242"]
}, Open  ]],

Cell[CellGroupData[{

Cell["HeartSuit", "ObjectName",
  CellTags->"S1.1243"],

Cell[TextData[{
  "\[HeartSuit]  \[Backslash]",
  StyleBox["[HeartSuit]", "MR"]
}], "CharacterName",
  CellTags->"S1.1243"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1243"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1243"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ClubSuit]",
    ButtonData:>{"ClubSuit"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1243"]
}, Open  ]],

Cell[CellGroupData[{

Cell["HermitianConjugate", "ObjectName",
  CellTags->"S1.1244"],

Cell[TextData[{
  "\[HermitianConjugate]  \[Backslash]",
  StyleBox["[HermitianConjugate]", "MR"]
}], "CharacterName",
  CellTags->"S1.1244"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["hc\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1244"],

Cell["\<\
\[FilledSmallSquare] Superscript postfix operator with built\
\[Hyphen]in evaluation rules. \
\>", "Notes",
  CellTags->"S1.1244"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      SuperscriptBox[
        StyleBox["m",
          "TI"], "\[HermitianConjugate]"]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["ConjugateTranspose[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1244"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as keyboard ",
  StyleBox["H", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1244"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.26"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1244"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ConjugateTranspose]",
    ButtonData:>{"ConjugateTranspose"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Conjugate]",
    ButtonData:>{"Conjugate"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Transpose]",
    ButtonData:>{"Transpose"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1244"]
}, Open  ]],

Cell[CellGroupData[{

Cell["HorizontalLine", "ObjectName",
  CellTags->"S1.1245"],

Cell[TextData[{
  "\[HorizontalLine]  \[Backslash]",
  StyleBox["[HorizontalLine]", "MR"]
}], "CharacterName",
  CellTags->"S1.1245"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["hline\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1245"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1245"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1245"],

Cell[TextData[{
  "\[FilledSmallSquare] Thickness can be adjusted using the ",
  StyleBox["SpanThickness", "MR"],
  " option in ",
  StyleBox["StyleBox", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1245"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1245"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Dash]",
    ButtonData:>{"Dash"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LongDash]",
    ButtonData:>{"LongDash"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VerticalSeparator]",
    ButtonData:>{"VerticalSeparator"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1245"]
}, Open  ]],

Cell[CellGroupData[{

Cell["HumpDownHump", "ObjectName",
  CellTags->"S1.1246"],

Cell[TextData[{
  "\[HumpDownHump]  \[Backslash]",
  StyleBox["[HumpDownHump]", "MR"]
}], "CharacterName",
  CellTags->"S1.1246"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1246"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[HumpDownHump] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["HumpDownHump[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1246"],

Cell["\<\
\[FilledSmallSquare] Used to indicate geometrical equivalence. \
\
\>", "Notes",
  CellTags->"S1.1246"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1246"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][HumpEqual]",
    ButtonData:>{"HumpEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotHumpDownHump]",
    ButtonData:>{"NotHumpDownHump"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1246"]
}, Open  ]],

Cell[CellGroupData[{

Cell["HumpEqual", "ObjectName",
  CellTags->"S1.1247"],

Cell[TextData[{
  "\[HumpEqual]  \[Backslash]",
  StyleBox["[HumpEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1247"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["h=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1247"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1247"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[HumpEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["HumpEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1247"],

Cell["\<\
\[FilledSmallSquare] Sometimes used to mean \
\[OpenCurlyDoubleQuote]approximately equal\[CloseCurlyDoubleQuote] and \
sometimes \[OpenCurlyDoubleQuote]difference between\[CloseCurlyDoubleQuote]. \
\
\>", "Notes",
  CellTags->"S1.1247"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1247"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][HumpDownHump]",
    ButtonData:>{"HumpDownHump"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][TildeEqual]",
    ButtonData:>{"TildeEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotHumpEqual]",
    ButtonData:>{"NotHumpEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1247"]
}, Open  ]],

Cell[CellGroupData[{

Cell["IAcute", "ObjectName",
  CellTags->"S1.1248"],

Cell[TextData[{
  "\[IAcute]  \[Backslash]",
  StyleBox["[IAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1248"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["i'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1248"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1248"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1248"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1248"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalIAcute]",
    ButtonData:>{"CapitalIAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1248"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ICup", "ObjectName",
  CellTags->"S1.1249"],

Cell[TextData[{
  "\[ICup]  \[Backslash]",
  StyleBox["[ICup]", "MR"]
}], "CharacterName",
  CellTags->"S1.1249"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["iu\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1249"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1249"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1249"],

Cell["\<\
\[FilledSmallSquare] Used in transliterations of Cyrillic \
characters. \
\>", "Notes",
  CellTags->"S1.1249"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1249"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalICup]",
    ButtonData:>{"CapitalICup"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1249"]
}, Open  ]],

Cell[CellGroupData[{

Cell["IDoubleDot", "ObjectName",
  CellTags->"S1.1250"],

Cell[TextData[{
  "\[IDoubleDot]  \[Backslash]",
  StyleBox["[IDoubleDot]", "MR"]
}], "CharacterName",
  CellTags->"S1.1250"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["i\"\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1250"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1250"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1250"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1250"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalIDoubleDot]",
    ButtonData:>{"CapitalIDoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EDoubleDot]",
    ButtonData:>{"EDoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ADoubleDot]",
    ButtonData:>{"ADoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1250"]
}, Open  ]],

Cell[CellGroupData[{

Cell["IGrave", "ObjectName",
  CellTags->"S1.1251"],

Cell[TextData[{
  "\[IGrave]  \[Backslash]",
  StyleBox["[IGrave]", "MR"]
}], "CharacterName",
  CellTags->"S1.1251"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["i`\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1251"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1251"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1251"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1251"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalIGrave]",
    ButtonData:>{"CapitalIGrave"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1251"]
}, Open  ]],

Cell[CellGroupData[{

Cell["IHat", "ObjectName",
  CellTags->"S1.1252"],

Cell[TextData[{
  "\[IHat]  \[Backslash]",
  StyleBox["[IHat]", "MR"]
}], "CharacterName",
  CellTags->"S1.1252"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["i^\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1252"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1252"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1252"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1252"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalIHat]",
    ButtonData:>{"CapitalIHat"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1252"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ImaginaryI", "ObjectName",
  CellTags->"S1.1253"],

Cell[TextData[{
  "\[ImaginaryI]  \[Backslash]",
  StyleBox["[ImaginaryI]", "MR"]
}], "CharacterName",
  CellTags->"S1.1253"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["ii\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1253"],

Cell["\<\
\[FilledSmallSquare] Letter\[Hyphen]like form with built\[Hyphen]in \
value. \
\>", "Notes",
  CellTags->"S1.1253"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[ImaginaryI]\)], "InlineFormula"],
  " is interpreted by default as the symbol ",
  StyleBox["I", "MR"],
  ", representing ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(-1\)\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->"S1.1253"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.27"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.2",
    ButtonData:>{"3.10.2", "2.3"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1253"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ImaginaryJ]",
    ButtonData:>{"ImaginaryJ"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ExponentialE]",
    ButtonData:>{"ExponentialE"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1253"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ImaginaryJ", "ObjectName",
  CellTags->"S1.1254"],

Cell[TextData[{
  "\[ImaginaryJ]  \[Backslash]",
  StyleBox["[ImaginaryJ]", "MR"]
}], "CharacterName",
  CellTags->"S1.1254"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["jj\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1254"],

Cell["\<\
\[FilledSmallSquare] Letter\[Hyphen]like form with built\[Hyphen]in \
value. \
\>", "Notes",
  CellTags->"S1.1254"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[ImaginaryJ]\)], "InlineFormula"],
  " is interpreted by default as the symbol ",
  StyleBox["I", "MR"],
  ", representing ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(-1\)\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->"S1.1254"],

Cell["\<\
\[FilledSmallSquare] Used in electrical engineering. \
\>", "Notes",
  CellTags->"S1.1254"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.2",
    ButtonData:>{"3.10.2", "2.3"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1254"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ImaginaryI]",
    ButtonData:>{"ImaginaryI"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ExponentialE]",
    ButtonData:>{"ExponentialE"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1254"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implies", "ObjectName",
  CellTags->"S1.1255"],

Cell[TextData[{
  "\[Implies]  \[Backslash]",
  StyleBox["[Implies]", "MR"]
}], "CharacterName",
  CellTags->"S1.1255"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["=>\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1255"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1255"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Implies] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Implies[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1255"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Implies] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Implies] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  " groups as ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Implies] \)], "InlineFormula"],
  " ",
  StyleBox["(", "MR"],
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Implies] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[")", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1255"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][DoubleRightArrow]",
    ButtonData:>{"DoubleRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1255"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["\[Backslash][DoubleRightArrow]",
    ButtonData:>{"DoubleRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  " is extensible; \[Backslash]",
  StyleBox["[Implies]", "MR"],
  " is not. "
}], "Notes",
  CellTags->"S1.1255"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.10"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1255"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RoundImplies]",
    ButtonData:>{"RoundImplies"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SuchThat]",
    ButtonData:>{"SuchThat"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Rule]",
    ButtonData:>{"Rule"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1255"]
}, Open  ]],

Cell[CellGroupData[{

Cell["IndentingNewLine", "ObjectName",
  CellTags->"S1.1256"],

Cell[TextData[{
  "\[IndentingNewLine]  \[Backslash]",
  StyleBox["[IndentingNewLine]", "MR"]
}], "CharacterName",
  CellTags->"S1.1256"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["nl\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1256"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1256"],

Cell["\<\
\[FilledSmallSquare] Forces a line break in an expression, \
maintaining the correct indenting level based on the environment of the line \
break. \
\>", "Notes",
  CellTags->"S1.1256"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.64"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1256"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NewLine]",
    ButtonData:>{"NewLine"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NoBreak]",
    ButtonData:>{"NoBreak"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1256"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Infinity", "ObjectName",
  CellTags->"S1.1257"],

Cell[TextData[{
  "\[Infinity]  \[Backslash]",
  StyleBox["[Infinity]", "MR"]
}], "CharacterName",
  CellTags->"S1.1257"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["inf\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1257"],

Cell["\<\
\[FilledSmallSquare] Letter\[Hyphen]like form with built\[Hyphen]in \
value. \
\>", "Notes",
  CellTags->"S1.1257"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  " is interpreted by default as the symbol ",
  StyleBox["Infinity", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1257"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.2",
    ButtonData:>{"3.10.2", "2.3"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1257"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integral", "ObjectName",
  CellTags->"S1.1258"],

Cell[TextData[{
  "\[Integral]  \[Backslash]",
  StyleBox["[Integral]", "MR"]
}], "CharacterName",
  CellTags->"S1.1258"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["int\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1258"],

Cell["\<\
\[FilledSmallSquare] Compound operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1258"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
  " ",
  StyleBox["f", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " is by default interpreted as ",
  StyleBox["Integrate[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1258"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["\[Integral]", 
          StyleBox["a",
            "TI"], 
          StyleBox["b",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["f", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " is by default interpreted as ",
  StyleBox["Integral[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["}]", "MR"],
  ". ",
  StyleBox["a", "TI"],
  " and ",
  StyleBox["b", "TI"],
  " must appear as a subscript and superscript, respectively. "
}], "Notes",
  CellTags->"S1.1258"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
  " ",
  StyleBox["a", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[SmallCircle]\)], "InlineFormula"],
  " ",
  StyleBox["b", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " is by default output as ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
  " ",
  StyleBox["(", "MR"],
  StyleBox["a", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[SmallCircle]\)], "InlineFormula"],
  " ",
  StyleBox["b", "TI"],
  StyleBox[")", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " whenever ",
  Cell[BoxData[
      \(TraditionalForm\`\[SmallCircle]\)], "InlineFormula"],
  " is an operator with a precedence lower than ",
  Cell[BoxData[
      \(TraditionalForm\`\[Star]\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->"S1.1258"],

Cell[TextData[{
  "\[FilledSmallSquare] Note the use of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  ", entered as \[AliasIndicator]",
  StyleBox["dd\[AliasIndicator]", "MR"],
  " or ",
  ButtonBox["\[Backslash][DifferentialD]",
    ButtonData:>{"DifferentialD"},
    ButtonStyle->"MainBookLinkMR"],
  ", rather than ordinary ",
  StyleBox["d", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1258"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.12"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1258"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ContourIntegral]",
    ButtonData:>{"ContourIntegral"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1258"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Intersection", "ObjectName",
  CellTags->"S1.1259"],

Cell[TextData[{
  "\[Intersection]  \[Backslash]",
  StyleBox["[Intersection]", "MR"]
}], "CharacterName",
  CellTags->"S1.1259"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["inter\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1259"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1259"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Intersection]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Intersection[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1259"],

Cell[TextData[{
  "\[FilledSmallSquare] The character ",
  Cell[BoxData[
      \(TraditionalForm\`\[Intersection]\)], "InlineFormula"],
  " is sometimes called \[OpenCurlyDoubleQuote]cap\[CloseCurlyDoubleQuote]; \
but see also ",
  ButtonBox["\[Backslash][Cap]",
    ButtonData:>{"Cap"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1259"],

Cell[TextData[{
  "\[FilledSmallSquare] \[AliasIndicator]",
  StyleBox["int\[AliasIndicator]", "MR"],
  " gives ",
  ButtonBox["\[Backslash][Integral]",
    ButtonData:>{"Integral"},
    ButtonStyle->"MainBookLinkMR"],
  " not \[Backslash]",
  StyleBox["[Intersection]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1259"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1259"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Union]",
    ButtonData:>{"Union"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SquareIntersection]",
    ButtonData:>{"SquareIntersection"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Cap]",
    ButtonData:>{"Cap"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Wedge]",
    ButtonData:>{"Wedge"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1259"]
}, Open  ]],

Cell[CellGroupData[{

Cell["InvisibleApplication", "ObjectName",
  CellTags->"S1.1260"],

Cell[TextData[{
  "\[InvisibleApplication]  \[Backslash]",
  StyleBox["[InvisibleApplication]", "MR"]
}], "CharacterName",
  CellTags->"S1.1260"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["@\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1260"],

Cell["\<\
\[FilledSmallSquare] Structural element with built\[Hyphen]in \
meaning. \
\>", "Notes",
  CellTags->"S1.1260"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[InvisibleApplication]", "MR"],
  " is by default not visible on display, but is interpreted as function \
application. "
}], "Notes",
  CellTags->"S1.1260"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["f", "TI"],
  " ",
  StyleBox["\[AliasIndicator]@\[AliasIndicator]", "MR"],
  " ",
  StyleBox["x", "TI"],
  " is interpreted as ",
  StyleBox["f", "TI"],
  " ",
  StyleBox["@", "MR"],
  " ",
  StyleBox["x", "TI"],
  " or ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1260"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[InvisibleApplication]", "MR"],
  " can be used as an invisible separator between functions or between \
functions and their arguments. "
}], "Notes",
  CellTags->"S1.1260"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1260"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][InvisibleSpace]",
    ButtonData:>{"InvisibleSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][InvisibleComma]",
    ButtonData:>{"InvisibleComma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawAt]",
    ButtonData:>{"RawAt"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1260"]
}, Open  ]],

Cell[CellGroupData[{

Cell["InvisibleComma", "ObjectName",
  CellTags->"S1.1261"],

Cell[TextData[{
  "\[InvisibleComma]  \[Backslash]",
  StyleBox["[InvisibleComma]", "MR"]
}], "CharacterName",
  CellTags->"S1.1261"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox[",\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1261"],

Cell["\<\
\[FilledSmallSquare] Structural element with built\[Hyphen]in \
meaning. \
\>", "Notes",
  CellTags->"S1.1261"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[InvisibleComma]", "MR"],
  " is by default not visible on display, but is interpreted on input as an \
ordinary comma. "
}], "Notes",
  CellTags->"S1.1261"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[InvisibleComma]", "MR"],
  " can be used as an invisible separator between indices, as in ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["M",
            "TI"], 
          StyleBox["ij",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->"S1.1261"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1261"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][AlignmentMarker]",
    ButtonData:>{"AlignmentMarker"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Null]",
    ButtonData:>{"Null"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][InvisibleSpace]",
    ButtonData:>{"InvisibleSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawComma]",
    ButtonData:>{"RawComma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1261"]
}, Open  ]],

Cell[CellGroupData[{

Cell["InvisibleSpace", "ObjectName",
  CellTags->"S1.1262"],

Cell[TextData[{
  "\[InvisibleSpace]  \[Backslash]",
  StyleBox["[InvisibleSpace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1262"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["is\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1262"],

Cell["\[FilledSmallSquare] Spacing character. ", "Notes",
  CellTags->"S1.1262"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[InvisibleSpace]", "MR"],
  " is by default not visible on display, but is interpreted on input as an \
ordinary space. "
}], "Notes",
  CellTags->"S1.1262"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[InvisibleSpace]", "MR"],
  " can be used as an invisible separator between variables that are being \
multiplied together, as in ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x  y\),
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->"S1.1262"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.25"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1262"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][AlignmentMarker]",
    ButtonData:>{"AlignmentMarker"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Null]",
    ButtonData:>{"Null"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VeryThinSpace]",
    ButtonData:>{"VeryThinSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawSpace]",
    ButtonData:>{"RawSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1262"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Iota", "ObjectName",
  CellTags->"S1.1263"],

Cell[TextData[{
  "\[Iota]  \[Backslash]",
  StyleBox["[Iota]", "MR"]
}], "CharacterName",
  CellTags->"S1.1263"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["i\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["iota\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1263"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1263"],

Cell["\[FilledSmallSquare] Not commonly used. ", "Notes",
  CellTags->"S1.1263"],

Cell["\<\
\[FilledSmallSquare] Used in set theory to indicate an explicitly \
constructible set. \
\>", "Notes",
  CellTags->"S1.1263"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1263"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalIota]",
    ButtonData:>{"CapitalIota"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DotlessI]",
    ButtonData:>{"DotlessI"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1263"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Kappa", "ObjectName",
  CellTags->"S1.1264"],

Cell[TextData[{
  "\[Kappa]  \[Backslash]",
  StyleBox["[Kappa]", "MR"]
}], "CharacterName",
  CellTags->"S1.1264"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["k\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["kappa\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1264"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1264"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1264"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CurlyKappa]",
    ButtonData:>{"CurlyKappa"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalKappa]",
    ButtonData:>{"CapitalKappa"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1264"]
}, Open  ]],

Cell[CellGroupData[{

Cell["KernelIcon", "ObjectName",
  CellTags->"S1.1265"],

Cell[TextData[{
  "\[KernelIcon]  \[Backslash]",
  StyleBox["[KernelIcon]", "MR"]
}], "CharacterName",
  CellTags->"S1.1265"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1265"],

Cell[TextData[{
  "\[FilledSmallSquare] Icon typically used for the ",
  StyleBox["Mathematica", "TI"],
  " kernel. "
}], "Notes",
  CellTags->"S1.1265"],

Cell["\<\
\[FilledSmallSquare] This icon is a trademark of Wolfram Research. \
\
\>", "Notes",
  CellTags->"S1.1265"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.30"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1265"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][MathematicaIcon]",
    ButtonData:>{"MathematicaIcon"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1265"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Koppa", "ObjectName",
  CellTags->"S1.1266"],

Cell[TextData[{
  "\[Koppa]  \[Backslash]",
  StyleBox["[Koppa]", "MR"]
}], "CharacterName",
  CellTags->"S1.1266"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["ko\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["koppa\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1266"],

Cell["\[FilledSmallSquare] Special Greek letter. ", "Notes",
  CellTags->"S1.1266"],

Cell[TextData[{
  "\[FilledSmallSquare] Analogous to English ",
  StyleBox["q", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1266"],

Cell[TextData[{
  "\[FilledSmallSquare] Appeared between ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho]\)], "InlineFormula"],
  " in early Greek alphabet; used for Greek numeral 90. "
}], "Notes",
  CellTags->"S1.1266"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1266"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalKoppa]",
    ButtonData:>{"CapitalKoppa"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Digamma]",
    ButtonData:>{"Digamma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Stigma]",
    ButtonData:>{"Stigma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Sampi]",
    ButtonData:>{"Sampi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1266"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lambda", "ObjectName",
  CellTags->"S1.1267"],

Cell[TextData[{
  "\[Lambda]  \[Backslash]",
  StyleBox["[Lambda]", "MR"]
}], "CharacterName",
  CellTags->"S1.1267"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["l\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["lambda\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1267"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1267"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["ModularLambda", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1267"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1267"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalLambda]",
    ButtonData:>{"CapitalLambda"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1267"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftAngleBracket", "ObjectName",
  CellTags->"S1.1268"],

Cell[TextData[{
  "\[LeftAngleBracket]  \[Backslash]",
  StyleBox["[LeftAngleBracket]", "MR"]
}], "CharacterName",
  CellTags->"S1.1268"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["<\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1268"],

Cell["\[FilledSmallSquare] Matchfix operator. ", "Notes",
  CellTags->"S1.1268"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightAngleBracket]\)], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["AngleBracket[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1268"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in the form ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
  StyleBox["x", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[RightAngleBracket]\)], "InlineFormula"],
  " to indicate expected or average value. "
}], "Notes",
  CellTags->"S1.1268"],

Cell["\<\
\[FilledSmallSquare] Called bra in quantum mechanics. \
\>", "Notes",
  CellTags->"S1.1268"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in the form ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[RightAngleBracket]\)], "InlineFormula"],
  " to indicate various forms of inner product. "
}], "Notes",
  CellTags->"S1.1268"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in the form ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightAngleBracket]\)], "InlineFormula"],
  " to denote an ordered set of objects. "
}], "Notes",
  CellTags->"S1.1268"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][RawLess]",
    ButtonData:>{"RawLess"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1268"],

Cell["\<\
\[FilledSmallSquare] Extensible character; grows by default to \
limited size. \
\>", "Notes",
  CellTags->"S1.1268"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1268"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightAngleBracket]",
    ButtonData:>{"RightAngleBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftFloor]",
    ButtonData:>{"LeftFloor"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftCeiling]",
    ButtonData:>{"LeftCeiling"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1268"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftArrow", "ObjectName",
  CellTags->"S1.1269"],

Cell[TextData[{
  "\[LeftArrow]  \[Backslash]",
  StyleBox["[LeftArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1269"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["<-\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1269"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1269"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftArrow] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1269"],

Cell[TextData[{
  "\[FilledSmallSquare] Sometimes used in computer science to indicate \
assignment: ",
  StyleBox["x", "TI"],
  " gets value ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1269"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1269"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1269"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LongLeftArrow]",
    ButtonData:>{"LongLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ShortLeftArrow]",
    ButtonData:>{"ShortLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleLeftArrow]",
    ButtonData:>{"DoubleLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTeeArrow]",
    ButtonData:>{"LeftTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrowBar]",
    ButtonData:>{"LeftArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LowerLeftArrow]",
    ButtonData:>{"LowerLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftVector]",
    ButtonData:>{"LeftVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTriangle]",
    ButtonData:>{"LeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1269"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftArrowBar", "ObjectName",
  CellTags->"S1.1270"],

Cell[TextData[{
  "\[LeftArrowBar]  \[Backslash]",
  StyleBox["[LeftArrowBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1270"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1270"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftArrowBar] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftArrowBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1270"],

Cell["\<\
\[FilledSmallSquare] Sometimes used to indicate a backtab. \
\>", \
"Notes",
  CellTags->"S1.1270"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1270"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1270"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftTeeArrow]",
    ButtonData:>{"LeftTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftVectorBar]",
    ButtonData:>{"LeftVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownArrowBar]",
    ButtonData:>{"DownArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrowBar]",
    ButtonData:>{"RightArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1270"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftArrowRightArrow", "ObjectName",
  CellTags->"S1.1271"],

Cell[TextData[{
  "\[LeftArrowRightArrow]  \[Backslash]",
  StyleBox["[LeftArrowRightArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1271"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1271"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftArrowRightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftArrowRightArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1271"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate logical \
equivalence. \
\>", "Notes",
  CellTags->"S1.1271"],

Cell["\<\
\[FilledSmallSquare] Sometimes used to indicate chemical \
equilibrium. \
\>", "Notes",
  CellTags->"S1.1271"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1271"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1271"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightArrowLeftArrow]",
    ButtonData:>{"RightArrowLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftRightArrow]",
    ButtonData:>{"LeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleLeftRightArrow]",
    ButtonData:>{"DoubleLeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Equilibrium]",
    ButtonData:>{"Equilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrowDownArrow]",
    ButtonData:>{"UpArrowDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1271"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftBracketingBar", "ObjectName",
  CellTags->"S1.1272"],

Cell[TextData[{
  "\[LeftBracketingBar]  \[Backslash]",
  StyleBox["[LeftBracketingBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1272"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["l|\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1272"],

Cell["\[FilledSmallSquare] Matchfix operator. ", "Notes",
  CellTags->"S1.1272"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftBracketingBar]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightBracketingBar]\)], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["BracketingBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1272"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in mathematics to indicate absolute value (",
  StyleBox["Abs", "MR"],
  "), determinant (",
  StyleBox["Det", "MR"],
  "), and other notions of evaluating size or magnitude. "
}], "Notes",
  CellTags->"S1.1272"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][VerticalBar]",
    ButtonData:>{"VerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1272"],

Cell["\<\
\[FilledSmallSquare] Drawn in monospaced fonts with a small left\
\[Hyphen]pointing tee to indicate direction. \
\>", "Notes",
  CellTags->"S1.1272"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1272"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.50"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1272"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftDoubleBracketingBar]",
    ButtonData:>{"LeftDoubleBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTee]",
    ButtonData:>{"LeftTee"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1272"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftCeiling", "ObjectName",
  CellTags->"S1.1273"],

Cell[TextData[{
  "\[LeftCeiling]  \[Backslash]",
  StyleBox["[LeftCeiling]", "MR"]
}], "CharacterName",
  CellTags->"S1.1273"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["lc\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1273"],

Cell["\<\
\[FilledSmallSquare] Matchfix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1273"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftCeiling]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightCeiling]\)], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Ceiling[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1273"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1273"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1273"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightCeiling]",
    ButtonData:>{"RightCeiling"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftFloor]",
    ButtonData:>{"LeftFloor"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftAngleBracket]",
    ButtonData:>{"LeftAngleBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1273"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftDoubleBracket", "ObjectName",
  CellTags->"S1.1274"],

Cell[TextData[{
  "\[LeftDoubleBracket]  \[Backslash]",
  StyleBox["[LeftDoubleBracket]", "MR"]
}], "CharacterName",
  CellTags->"S1.1274"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["[[\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1274"],

Cell["\<\
\[FilledSmallSquare] Compound operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1274"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["m", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracket]\)], "InlineFormula"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  StyleBox["j", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightDoubleBracket]\)], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Part[", "MR"],
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["j", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1274"],

Cell["\<\
\[FilledSmallSquare] Sometimes used in mathematics to indicate a \
class of algebraic objects with certain variables or extensions. \
\>", \
"Notes",
  CellTags->"S1.1274"],

Cell["\<\
\[FilledSmallSquare] Extensible character; grows by default to \
limited size. \
\>", "Notes",
  CellTags->"S1.1274"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.12"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1274"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawLeftBracket]",
    ButtonData:>{"RawLeftBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftDoubleBracketingBar]",
    ButtonData:>{"LeftDoubleBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1274"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftDoubleBracketingBar", "ObjectName",
  CellTags->"S1.1275"],

Cell[TextData[{
  "\[LeftDoubleBracketingBar]  \[Backslash]",
  StyleBox["[LeftDoubleBracketingBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1275"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["l||\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1275"],

Cell["\[FilledSmallSquare] Matchfix operator. ", "Notes",
  CellTags->"S1.1275"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightDoubleBracketingBar]\)], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["DoubleBracketingBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1275"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate taking a norm. \
\
\>", "Notes",
  CellTags->"S1.1275"],

Cell["\<\
\[FilledSmallSquare] Sometimes used for determinant. \
\>", "Notes",
  CellTags->"S1.1275"],

Cell["\<\
\[FilledSmallSquare] Sometimes used to indicate a matrix. \
\>", \
"Notes",
  CellTags->"S1.1275"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][DoubleVerticalBar]",
    ButtonData:>{"DoubleVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1275"],

Cell["\<\
\[FilledSmallSquare] Drawn in monospaced fonts with a small left\
\[Hyphen]pointing tee to indicate direction. \
\>", "Notes",
  CellTags->"S1.1275"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1275"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1275"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftBracketingBar]",
    ButtonData:>{"LeftBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1275"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftDownTeeVector", "ObjectName",
  CellTags->"S1.1276"],

Cell[TextData[{
  "\[LeftDownTeeVector]  \[Backslash]",
  StyleBox["[LeftDownTeeVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1276"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1276"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDownTeeVector]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftDownTeeVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1276"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1276"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1276"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightDownTeeVector]",
    ButtonData:>{"RightDownTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftDownVectorBar]",
    ButtonData:>{"LeftDownVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownTeeArrow]",
    ButtonData:>{"DownTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftUpTeeVector]",
    ButtonData:>{"LeftUpTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1276"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftDownVector", "ObjectName",
  CellTags->"S1.1277"],

Cell[TextData[{
  "\[LeftDownVector]  \[Backslash]",
  StyleBox["[LeftDownVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1277"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1277"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDownVector]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftDownVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1277"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1277"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1277"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightDownVector]",
    ButtonData:>{"RightDownVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftDownTeeVector]",
    ButtonData:>{"LeftDownTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownArrow]",
    ButtonData:>{"DownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpEquilibrium]",
    ButtonData:>{"UpEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftUpVector]",
    ButtonData:>{"LeftUpVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1277"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftDownVectorBar", "ObjectName",
  CellTags->"S1.1278"],

Cell[TextData[{
  "\[LeftDownVectorBar]  \[Backslash]",
  StyleBox["[LeftDownVectorBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1278"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1278"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDownVectorBar]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftDownVectorBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1278"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1278"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1278"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightDownVectorBar]",
    ButtonData:>{"RightDownVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftDownTeeVector]",
    ButtonData:>{"LeftDownTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownArrowBar]",
    ButtonData:>{"DownArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftUpVectorBar]",
    ButtonData:>{"LeftUpVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1278"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftFloor", "ObjectName",
  CellTags->"S1.1279"],

Cell[TextData[{
  "\[LeftFloor]  \[Backslash]",
  StyleBox["[LeftFloor]", "MR"]
}], "CharacterName",
  CellTags->"S1.1279"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["lf\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1279"],

Cell["\<\
\[FilledSmallSquare] Matchfix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1279"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftFloor]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightFloor]\)], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Floor[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1279"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1279"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1279"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightFloor]",
    ButtonData:>{"RightFloor"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftCeiling]",
    ButtonData:>{"LeftCeiling"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftAngleBracket]",
    ButtonData:>{"LeftAngleBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1279"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftGuillemet", "ObjectName",
  CellTags->"S1.1280"],

Cell[TextData[{
  "\[LeftGuillemet]  \[Backslash]",
  StyleBox["[LeftGuillemet]", "MR"]
}], "CharacterName",
  CellTags->"S1.1280"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["g<<\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1280"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1280"],

Cell["\<\
\[FilledSmallSquare] Used as opening quotation marks in languages \
such as Spanish. \
\>", "Notes",
  CellTags->"S1.1280"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][LessLess]",
    ButtonData:>{"LessLess"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1280"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][LeftSkeleton]",
    ButtonData:>{"LeftSkeleton"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1280"],

Cell["\<\
\[FilledSmallSquare] Guillemet is sometimes misspelled as \
guillemot. \
\>", "Notes",
  CellTags->"S1.1280"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1280"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightGuillemet]",
    ButtonData:>{"RightGuillemet"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1280"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftModified", "ObjectName",
  CellTags->"S1.1281"],

Cell[TextData[{
  "\[LeftModified]  \[Backslash]",
  StyleBox["[LeftModified]", "MR"]
}], "CharacterName",
  CellTags->"S1.1281"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["[\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1281"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1281"],

Cell["\<\
\[FilledSmallSquare] Used in documenting control and command \
characters. \
\>", "Notes",
  CellTags->"S1.1281"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["key", "TI"],
  "\[Backslash]",
  StyleBox["[LeftModified]", "MR"],
  StyleBox["char", "TI"],
  "\[Backslash]",
  StyleBox["[RightModified]", "MR"],
  " is used to indicate that ",
  StyleBox["char", "TI"],
  " should be typed while ",
  StyleBox["key", "TI"],
  " is being pressed. "
}], "Notes",
  CellTags->"S1.1281"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][RawLeftBracket]",
    ButtonData:>{"RawLeftBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1281"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1281"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ControlKey]",
    ButtonData:>{"ControlKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CommandKey]",
    ButtonData:>{"CommandKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightModified]",
    ButtonData:>{"RightModified"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1281"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftRightArrow", "ObjectName",
  CellTags->"S1.1282"],

Cell[TextData[{
  "\[LeftRightArrow]  \[Backslash]",
  StyleBox["[LeftRightArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1282"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["<->\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1282"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1282"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftRightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftRightArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1282"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics for various notions of \
equivalence and equality. \
\>", "Notes",
  CellTags->"S1.1282"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1282"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1282"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LongLeftRightArrow]",
    ButtonData:>{"LongLeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleLeftRightArrow]",
    ButtonData:>{"DoubleLeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrowRightArrow]",
    ButtonData:>{"LeftArrowRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftRightVector]",
    ButtonData:>{"LeftRightVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Equilibrium]",
    ButtonData:>{"Equilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpDownArrow]",
    ButtonData:>{"UpDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1282"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftRightVector", "ObjectName",
  CellTags->"S1.1283"],

Cell[TextData[{
  "\[LeftRightVector]  \[Backslash]",
  StyleBox["[LeftRightVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1283"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1283"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftRightVector]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftRightVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1283"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1283"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1283"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownLeftRightVector]",
    ButtonData:>{"DownLeftRightVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Equilibrium]",
    ButtonData:>{"Equilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReverseEquilibrium]",
    ButtonData:>{"ReverseEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftRightArrow]",
    ButtonData:>{"LeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrowLeftArrow]",
    ButtonData:>{"RightArrowLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightUpDownVector]",
    ButtonData:>{"RightUpDownVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1283"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftSkeleton", "ObjectName",
  CellTags->"S1.1284"],

Cell[TextData[{
  "\[LeftSkeleton]  \[Backslash]",
  StyleBox["[LeftSkeleton]", "MR"]
}], "CharacterName",
  CellTags->"S1.1284"],

Cell["\[FilledSmallSquare] Uninterpretable element. ", "Notes",
  CellTags->"S1.1284"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftSkeleton]\)], "InlineFormula"],
  " ",
  StyleBox["n", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightSkeleton]\)], "InlineFormula"],
  " is used on output to indicate ",
  StyleBox["n", "TI"],
  " omitted pieces in an expression obtained from ",
  StyleBox["Short", "MR"],
  " or ",
  StyleBox["Shallow", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1284"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[LeftSkeleton]", "MR"],
  " indicates the presence of missing information, and so by default \
generates an error if you try to interpret it. "
}], "Notes",
  CellTags->"S1.1284"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][LeftGuillemet]",
    ButtonData:>{"LeftGuillemet"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1284"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1284"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightSkeleton]",
    ButtonData:>{"RightSkeleton"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SkeletonIndicator]",
    ButtonData:>{"SkeletonIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Ellipsis]",
    ButtonData:>{"Ellipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ErrorIndicator]",
    ButtonData:>{"ErrorIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1284"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftTee", "ObjectName",
  CellTags->"S1.1285"],

Cell[TextData[{
  "\[LeftTee]  \[Backslash]",
  StyleBox["[LeftTee]", "MR"]
}], "CharacterName",
  CellTags->"S1.1285"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["lT\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1285"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1285"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftTee] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftTee[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1285"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftTee] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftTee] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  " groups as ",
  StyleBox["(", "MR"],
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftTee] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[")", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftTee] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1285"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate the lack of \
logical implication or proof. \
\>", "Notes",
  CellTags->"S1.1285"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1285"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubleLeftTee]",
    ButtonData:>{"DoubleLeftTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTeeArrow]",
    ButtonData:>{"LeftTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTeeVector]",
    ButtonData:>{"LeftTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTee]",
    ButtonData:>{"RightTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownTee]",
    ButtonData:>{"DownTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftBracketingBar]",
    ButtonData:>{"LeftBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  "."
}], "Notes",
  CellTags->"S1.1285"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftTeeArrow", "ObjectName",
  CellTags->"S1.1286"],

Cell[TextData[{
  "\[LeftTeeArrow]  \[Backslash]",
  StyleBox["[LeftTeeArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1286"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1286"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftTeeArrow] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftTeeArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1286"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1286"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1286"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftTeeVector]",
    ButtonData:>{"LeftTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTee]",
    ButtonData:>{"LeftTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTeeArrow]",
    ButtonData:>{"RightTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownTeeArrow]",
    ButtonData:>{"DownTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1286"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftTeeVector", "ObjectName",
  CellTags->"S1.1287"],

Cell[TextData[{
  "\[LeftTeeVector]  \[Backslash]",
  StyleBox["[LeftTeeVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1287"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1287"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftTeeVector] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftTeeVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1287"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1287"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1287"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownLeftTeeVector]",
    ButtonData:>{"DownLeftTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftVectorBar]",
    ButtonData:>{"LeftVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftVector]",
    ButtonData:>{"LeftVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTeeArrow]",
    ButtonData:>{"LeftTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1287"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftTriangle", "ObjectName",
  CellTags->"S1.1288"],

Cell[TextData[{
  "\[LeftTriangle]  \[Backslash]",
  StyleBox["[LeftTriangle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1288"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1288"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftTriangle] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftTriangle[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1288"],

Cell["\<\
\[FilledSmallSquare] Used in pure mathematics to mean \
\[OpenCurlyDoubleQuote]normal subgroup of\[CloseCurlyDoubleQuote]. \
\>", \
"Notes",
  CellTags->"S1.1288"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1288"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftTriangleEqual]",
    ButtonData:>{"LeftTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTriangleBar]",
    ButtonData:>{"LeftTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrow]",
    ButtonData:>{"LeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLeftTriangle]",
    ButtonData:>{"NotLeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangle]",
    ButtonData:>{"RightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptyUpTriangle]",
    ButtonData:>{"EmptyUpTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledUpTriangle]",
    ButtonData:>{"FilledUpTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1288"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftTriangleBar", "ObjectName",
  CellTags->"S1.1289"],

Cell[TextData[{
  "\[LeftTriangleBar]  \[Backslash]",
  StyleBox["[LeftTriangleBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1289"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1289"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftTriangleBar] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftTriangleBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1289"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1289"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftTriangle]",
    ButtonData:>{"LeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTriangleEqual]",
    ButtonData:>{"LeftTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrowBar]",
    ButtonData:>{"LeftArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLeftTriangleBar]",
    ButtonData:>{"NotLeftTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1289"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftTriangleEqual", "ObjectName",
  CellTags->"S1.1290"],

Cell[TextData[{
  "\[LeftTriangleEqual]  \[Backslash]",
  StyleBox["[LeftTriangleEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1290"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1290"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftTriangleEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftTriangleEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1290"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1290"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftTriangle]",
    ButtonData:>{"LeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTriangleBar]",
    ButtonData:>{"LeftTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][PrecedesEqual]",
    ButtonData:>{"PrecedesEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLeftTriangleEqual]",
    ButtonData:>{"NotLeftTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangleEqual]",
    ButtonData:>{"RightTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1290"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftUpDownVector", "ObjectName",
  CellTags->"S1.1291"],

Cell[TextData[{
  "\[LeftUpDownVector]  \[Backslash]",
  StyleBox["[LeftUpDownVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1291"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1291"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftUpDownVector]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftUpDownVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1291"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1291"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1291"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightUpDownVector]",
    ButtonData:>{"RightUpDownVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpEquilibrium]",
    ButtonData:>{"UpEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrowDownArrow]",
    ButtonData:>{"UpArrowDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftRightVector]",
    ButtonData:>{"LeftRightVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1291"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftUpTeeVector", "ObjectName",
  CellTags->"S1.1292"],

Cell[TextData[{
  "\[LeftUpTeeVector]  \[Backslash]",
  StyleBox["[LeftUpTeeVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1292"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1292"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftUpTeeVector]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftUpTeeVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1292"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1292"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1292"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightUpTeeVector]",
    ButtonData:>{"RightUpTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftUpVectorBar]",
    ButtonData:>{"LeftUpVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpTeeArrow]",
    ButtonData:>{"UpTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftDownTeeVector]",
    ButtonData:>{"LeftDownTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1292"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftUpVector", "ObjectName",
  CellTags->"S1.1293"],

Cell[TextData[{
  "\[LeftUpVector]  \[Backslash]",
  StyleBox["[LeftUpVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1293"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1293"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftUpVector]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftUpVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1293"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1293"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1293"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightUpVector]",
    ButtonData:>{"RightUpVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftUpTeeVector]",
    ButtonData:>{"LeftUpTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrow]",
    ButtonData:>{"UpArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpEquilibrium]",
    ButtonData:>{"UpEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftDownVector]",
    ButtonData:>{"LeftDownVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1293"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftUpVectorBar", "ObjectName",
  CellTags->"S1.1294"],

Cell[TextData[{
  "\[LeftUpVectorBar]  \[Backslash]",
  StyleBox["[LeftUpVectorBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1294"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1294"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftUpVectorBar]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftUpVectorBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1294"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1294"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1294"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightUpVectorBar]",
    ButtonData:>{"RightUpVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftUpTeeVector]",
    ButtonData:>{"LeftUpTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrowBar]",
    ButtonData:>{"UpArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftDownVectorBar]",
    ButtonData:>{"LeftDownVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1294"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftVector", "ObjectName",
  CellTags->"S1.1295"],

Cell[TextData[{
  "\[LeftVector]  \[Backslash]",
  StyleBox["[LeftVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1295"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1295"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftVector] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1295"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1295"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1295"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownLeftVector]",
    ButtonData:>{"DownLeftVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTeeVector]",
    ButtonData:>{"LeftTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftVectorBar]",
    ButtonData:>{"LeftVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrow]",
    ButtonData:>{"LeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightVector]",
    ButtonData:>{"RightVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftUpVector]",
    ButtonData:>{"LeftUpVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1295"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeftVectorBar", "ObjectName",
  CellTags->"S1.1296"],

Cell[TextData[{
  "\[LeftVectorBar]  \[Backslash]",
  StyleBox["[LeftVectorBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1296"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1296"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftVectorBar]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LeftVectorBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1296"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1296"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1296"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownLeftVectorBar]",
    ButtonData:>{"DownLeftVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTeeVector]",
    ButtonData:>{"LeftTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrowBar]",
    ButtonData:>{"LeftArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1296"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LessEqual", "ObjectName",
  CellTags->"S1.1297"],

Cell[TextData[{
  "\[LessEqual]  \[Backslash]",
  StyleBox["[LessEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1297"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["<=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1297"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1297"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LessEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LessEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1297"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1297"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LessSlantEqual]",
    ButtonData:>{"LessSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LessFullEqual]",
    ButtonData:>{"LessFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLessEqual]",
    ButtonData:>{"NotLessEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1297"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LessEqualGreater", "ObjectName",
  CellTags->"S1.1298"],

Cell[TextData[{
  "\[LessEqualGreater]  \[Backslash]",
  StyleBox["[LessEqualGreater]", "MR"]
}], "CharacterName",
  CellTags->"S1.1298"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1298"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LessEqualGreater] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LessEqualGreater[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1298"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1298"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GreaterEqualLess]",
    ButtonData:>{"GreaterEqualLess"},
    ButtonStyle->"MainBookLinkMR"],
  "."
}], "Notes",
  CellTags->"S1.1298"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LessFullEqual", "ObjectName",
  CellTags->"S1.1299"],

Cell[TextData[{
  "\[LessFullEqual]  \[Backslash]",
  StyleBox["[LessFullEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1299"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1299"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LessFullEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LessFullEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1299"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1299"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LessEqual]",
    ButtonData:>{"LessEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LessSlantEqual]",
    ButtonData:>{"LessSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLessFullEqual]",
    ButtonData:>{"NotLessFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1299"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LessGreater", "ObjectName",
  CellTags->"S1.1300"],

Cell[TextData[{
  "\[LessGreater]  \[Backslash]",
  StyleBox["[LessGreater]", "MR"]
}], "CharacterName",
  CellTags->"S1.1300"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1300"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LessGreater] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LessGreater[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1300"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1300"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LessEqualGreater]",
    ButtonData:>{"LessEqualGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLessGreater]",
    ButtonData:>{"NotLessGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1300"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LessLess", "ObjectName",
  CellTags->"S1.1301"],

Cell[TextData[{
  "\[LessLess]  \[Backslash]",
  StyleBox["[LessLess]", "MR"]
}], "CharacterName",
  CellTags->"S1.1301"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1301"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LessLess] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LessLess[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1301"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][LeftGuillemet]",
    ButtonData:>{"LeftGuillemet"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1301"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1301"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NestedLessLess]",
    ButtonData:>{"NestedLessLess"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLessLess]",
    ButtonData:>{"NotLessLess"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotNestedLessLess]",
    ButtonData:>{"NotNestedLessLess"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1301"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LessSlantEqual", "ObjectName",
  CellTags->"S1.1302"],

Cell[TextData[{
  "\[LessSlantEqual]  \[Backslash]",
  StyleBox["[LessSlantEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1302"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["</\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1302"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1302"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LessSlantEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LessEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1302"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1302"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LessEqual]",
    ButtonData:>{"LessEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LessFullEqual]",
    ButtonData:>{"LessFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLessSlantEqual]",
    ButtonData:>{"NotLessSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1302"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LessTilde", "ObjectName",
  CellTags->"S1.1303"],

Cell[TextData[{
  "\[LessTilde]  \[Backslash]",
  StyleBox["[LessTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1303"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["<", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1303"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1303"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LessTilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LessTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1303"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1303"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotLessTilde]",
    ButtonData:>{"NotLessTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1303"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LightBulb", "ObjectName",
  CellTags->"S1.1304"],

Cell[TextData[{
  "\[LightBulb]  \[Backslash]",
  StyleBox["[LightBulb]", "MR"]
}], "CharacterName",
  CellTags->"S1.1304"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1304"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.30"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1304"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LongDash", "ObjectName",
  CellTags->"S1.1305"],

Cell[TextData[{
  "\[LongDash]  \[Backslash]",
  StyleBox["[LongDash]", "MR"]
}], "CharacterName",
  CellTags->"S1.1305"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["--\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1305"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1305"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1305"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Dash]",
    ButtonData:>{"Dash"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][HorizontalLine]",
    ButtonData:>{"HorizontalLine"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1305"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LongEqual", "ObjectName",
  CellTags->"S1.1306"],

Cell[TextData[{
  "\[LongEqual]  \[Backslash]",
  StyleBox["[LongEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1306"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1306"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LongEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Equal[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  " or ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1306"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[LongEqual]", "MR"],
  " is drawn longer than ",
  ButtonBox["\[Backslash][RawEqual]",
    ButtonData:>{"RawEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1306"],

Cell[TextData[{
  "\[FilledSmallSquare] Used as an alternative to ",
  ButtonBox["\[Backslash][Equal]",
    ButtonData:>{"Equal"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1306"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.10"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1306"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Equal]",
    ButtonData:>{"Equal"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotEqual]",
    ButtonData:>{"NotEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Congruent]",
    ButtonData:>{"Congruent"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1306"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LongLeftArrow", "ObjectName",
  CellTags->"S1.1307"],

Cell[TextData[{
  "\[LongLeftArrow]  \[Backslash]",
  StyleBox["[LongLeftArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1307"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["<--\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1307"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1307"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[LongLeftArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LongLeftArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1307"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1307"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftArrow]",
    ButtonData:>{"LeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleLongLeftArrow]",
    ButtonData:>{"DoubleLongLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LongRightArrow]",
    ButtonData:>{"LongRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LongLeftRightArrow]",
    ButtonData:>{"LongLeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1307"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LongLeftRightArrow", "ObjectName",
  CellTags->"S1.1308"],

Cell[TextData[{
  "\[LongLeftRightArrow]  \[Backslash]",
  StyleBox["[LongLeftRightArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1308"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["<-->\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1308"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1308"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[LongLeftRightArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LongLeftRightArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1308"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1308"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftRightArrow]",
    ButtonData:>{"LeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleLongLeftRightArrow]",
    ButtonData:>{"DoubleLongLeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrowRightArrow]",
    ButtonData:>{"LeftArrowRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Equilibrium]",
    ButtonData:>{"Equilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1308"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LongRightArrow", "ObjectName",
  CellTags->"S1.1309"],

Cell[TextData[{
  "\[LongRightArrow]  \[Backslash]",
  StyleBox["[LongRightArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1309"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["-->\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1309"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1309"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LongRightArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1309"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Rule]",
    ButtonData:>{"Rule"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1309"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1309"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleLongRightArrow]",
    ButtonData:>{"DoubleLongRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LongLeftArrow]",
    ButtonData:>{"LongLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LongLeftRightArrow]",
    ButtonData:>{"LongLeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1309"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LowerLeftArrow", "ObjectName",
  CellTags->"S1.1310"],

Cell[TextData[{
  "\[LowerLeftArrow]  \[Backslash]",
  StyleBox["[LowerLeftArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1310"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1310"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LowerLeftArrow] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LowerLeftArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1310"],

Cell["\<\
\[FilledSmallSquare] Extensible character; grows by default to \
limited size. \
\>", "Notes",
  CellTags->"S1.1310"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1310"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftArrow]",
    ButtonData:>{"LeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpperRightArrow]",
    ButtonData:>{"UpperRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1310"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LowerRightArrow", "ObjectName",
  CellTags->"S1.1311"],

Cell[TextData[{
  "\[LowerRightArrow]  \[Backslash]",
  StyleBox["[LowerRightArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1311"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1311"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[LowerRightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["LowerRightArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1311"],

Cell["\<\
\[FilledSmallSquare] Extensible character; grows by default to \
limited size. \
\>", "Notes",
  CellTags->"S1.1311"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1311"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpperLeftArrow]",
    ButtonData:>{"UpperLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1311"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LSlash", "ObjectName",
  CellTags->"S1.1312"],

Cell[TextData[{
  "\[LSlash]  \[Backslash]",
  StyleBox["[LSlash]", "MR"]
}], "CharacterName",
  CellTags->"S1.1312"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["l/\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1312"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1312"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1312"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1312"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalLSlash]",
    ButtonData:>{"CapitalLSlash"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1312"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathematicaIcon", "ObjectName",
  CellTags->"S1.1313"],

Cell[TextData[{
  "\[MathematicaIcon]  \[Backslash]",
  StyleBox["[MathematicaIcon]", "MR"]
}], "CharacterName",
  CellTags->"S1.1313"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["math\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1313"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1313"],

Cell[TextData[{
  "\[FilledSmallSquare] Icon typically used for ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1313"],

Cell["\<\
\[FilledSmallSquare] Based on a stellated icosahedron. \
\>", \
"Notes",
  CellTags->"S1.1313"],

Cell["\<\
\[FilledSmallSquare] This icon is a trademark of Wolfram Research. \
\
\>", "Notes",
  CellTags->"S1.1313"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.30"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1313"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][KernelIcon]",
    ButtonData:>{"KernelIcon"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1313"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MeasuredAngle", "ObjectName",
  CellTags->"S1.1314"],

Cell[TextData[{
  "\[MeasuredAngle]  \[Backslash]",
  StyleBox["[MeasuredAngle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1314"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1314"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in geometry to indicate an angle, as in the \
symbol ",
  Cell[BoxData[
      \(TraditionalForm\`\[MeasuredAngle]\)], "InlineFormula"],
  " ",
  StyleBox["ABC", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1314"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.31"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1314"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Angle]",
    ButtonData:>{"Angle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SphericalAngle]",
    ButtonData:>{"SphericalAngle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightAngle]",
    ButtonData:>{"RightAngle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1314"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MediumSpace", "ObjectName",
  CellTags->"S1.1315"],

Cell[TextData[{
  "\[MediumSpace]  \[Backslash]",
  StyleBox["[MediumSpace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1315"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1315"],

Cell["\[FilledSmallSquare] Spacing character. ", "Notes",
  CellTags->"S1.1315"],

Cell["\[FilledSmallSquare] Width: 4/18 em. ", "Notes",
  CellTags->"S1.1315"],

Cell[TextData[{
  "\[FilledSmallSquare] Interpreted by default just like an ordinary ",
  ButtonBox["\[Backslash][RawSpace]",
    ButtonData:>{"RawSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1315"],

Cell["\<\
\[FilledSmallSquare] Sometimes used in output as a separator \
between digits in numbers. \
\>", "Notes",
  CellTags->"S1.1315"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.25"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1315"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ThinSpace]",
    ButtonData:>{"ThinSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ThickSpace]",
    ButtonData:>{"ThickSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NegativeMediumSpace]",
    ButtonData:>{"NegativeMediumSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NonBreakingSpace]",
    ButtonData:>{"NonBreakingSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SpaceIndicator]",
    ButtonData:>{"SpaceIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1315"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mho", "ObjectName",
  CellTags->"S1.1316"],

Cell[TextData[{
  "\[Mho]  \[Backslash]",
  StyleBox["[Mho]", "MR"]
}], "CharacterName",
  CellTags->"S1.1316"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["mho\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1316"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1316"],

Cell["\<\
\[FilledSmallSquare] Used to denote the inverse ohm unit of \
conductance. \
\>", "Notes",
  CellTags->"S1.1316"],

Cell["\<\
\[FilledSmallSquare] \"Mho\" is \"ohm\" spelled backwards. \
\>", \
"Notes",
  CellTags->"S1.1316"],

Cell["\<\
\[FilledSmallSquare] Occasionally called \
\[OpenCurlyDoubleQuote]agemo\[CloseCurlyDoubleQuote] in pure mathematics. \
\
\>", "Notes",
  CellTags->"S1.1316"],

Cell["\<\
\[FilledSmallSquare] Used to denote characteristic subgroups, and \
in set theory to denote functions of sets with special properties. \
\>", \
"Notes",
  CellTags->"S1.1316"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1316"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalOmega]",
    ButtonData:>{"CapitalOmega"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1316"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Micro", "ObjectName",
  CellTags->"S1.1317"],

Cell[TextData[{
  "\[Micro]  \[Backslash]",
  StyleBox["[Micro]", "MR"]
}], "CharacterName",
  CellTags->"S1.1317"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["mi\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1317"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1317"],

Cell[TextData[{
  "\[FilledSmallSquare] Used as a prefix in units to denote ",
  Cell[BoxData[
      \(TraditionalForm\`10\^\(-6\)\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->"S1.1317"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Mu]",
    ButtonData:>{"Mu"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1317"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1317"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Angstrom]",
    ButtonData:>{"Angstrom"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1317"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MinusPlus", "ObjectName",
  CellTags->"S1.1318"],

Cell[TextData[{
  "\[MinusPlus]  \[Backslash]",
  StyleBox["[MinusPlus]", "MR"]
}], "CharacterName",
  CellTags->"S1.1318"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["-+\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1318"],

Cell["\[FilledSmallSquare] Prefix or infix operator. ", "Notes",
  CellTags->"S1.1318"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[MinusPlus]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " is by default interpreted as ",
  StyleBox["MinusPlus[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1318"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[MinusPlus]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["MinusPlus[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1318"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1318"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][PlusMinus]",
    ButtonData:>{"PlusMinus"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1318"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mu", "ObjectName",
  CellTags->"S1.1319"],

Cell[TextData[{
  "\[Mu]  \[Backslash]",
  StyleBox["[Mu]", "MR"]
}], "CharacterName",
  CellTags->"S1.1319"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["m\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["mu\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1319"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1319"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["MoebiusMu", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1319"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Micro]",
    ButtonData:>{"Micro"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1319"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1319"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalMu]",
    ButtonData:>{"CapitalMu"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1319"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nand", "ObjectName",
  CellTags->"S1.1320"],

Cell[TextData[{
  "\[Nand]  \[Backslash]",
  StyleBox["[Nand]", "MR"]
}], "CharacterName",
  CellTags->"S1.1320"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["nand\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1320"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1320"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Nand] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Nand[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1320"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1320"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][And]",
    ButtonData:>{"And"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Not]",
    ButtonData:>{"Not"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Nor]",
    ButtonData:>{"Nor"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VerticalBar]",
    ButtonData:>{"VerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1320"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Natural", "ObjectName",
  CellTags->"S1.1321"],

Cell[TextData[{
  "\[Natural]  \[Backslash]",
  StyleBox["[Natural]", "MR"]
}], "CharacterName",
  CellTags->"S1.1321"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1321"],

Cell["\<\
\[FilledSmallSquare] Used to denote musical notes. \
\>", "Notes",
  CellTags->"S1.1321"],

Cell[TextData[{
  "\[FilledSmallSquare] Sometimes used in mathematical notation, often as an \
inverse of numbering operations represented by ",
  ButtonBox["\[Backslash][Sharp]",
    ButtonData:>{"Sharp"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1321"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1321"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Flat]",
    ButtonData:>{"Flat"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Sharp]",
    ButtonData:>{"Sharp"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1321"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NegativeMediumSpace", "ObjectName",
  CellTags->"S1.1322"],

Cell[TextData[{
  "\[NegativeMediumSpace]  \[Backslash]",
  StyleBox["[NegativeMediumSpace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1322"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["-", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1322"],

Cell["\[FilledSmallSquare] Negative spacing character. ", "Notes",
  CellTags->"S1.1322"],

Cell["\<\
\[FilledSmallSquare] Used to bring characters on either side closer \
together. \
\>", "Notes",
  CellTags->"S1.1322"],

Cell[TextData[{
  "\[FilledSmallSquare] Width: ",
  Cell[BoxData[
      \(TraditionalForm\`\(-4\)/18\)], "InlineFormula"],
  " em. "
}], "Notes",
  CellTags->"S1.1322"],

Cell[TextData[{
  "\[FilledSmallSquare] Interpreted by default just like an ordinary ",
  ButtonBox["\[Backslash][RawSpace]",
    ButtonData:>{"RawSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1322"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.25"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1322"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NegativeThinSpace]",
    ButtonData:>{"NegativeThinSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NegativeThickSpace]",
    ButtonData:>{"NegativeThickSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][MediumSpace]",
    ButtonData:>{"MediumSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1322"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NegativeThickSpace", "ObjectName",
  CellTags->"S1.1323"],

Cell[TextData[{
  "\[NegativeThickSpace]  \[Backslash]",
  StyleBox["[NegativeThickSpace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1323"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["-", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1323"],

Cell["\[FilledSmallSquare] Negative spacing character. ", "Notes",
  CellTags->"S1.1323"],

Cell["\<\
\[FilledSmallSquare] Used to bring characters on either side closer \
together. \
\>", "Notes",
  CellTags->"S1.1323"],

Cell[TextData[{
  "\[FilledSmallSquare] Width: ",
  Cell[BoxData[
      \(TraditionalForm\`\(-5\)/18\)], "InlineFormula"],
  " em. "
}], "Notes",
  CellTags->"S1.1323"],

Cell[TextData[{
  "\[FilledSmallSquare] Interpreted by default just like an ordinary ",
  ButtonBox["\[Backslash][RawSpace]",
    ButtonData:>{"RawSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1323"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.25"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1323"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NegativeMediumSpace]",
    ButtonData:>{"NegativeMediumSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ThickSpace]",
    ButtonData:>{"ThickSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1323"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NegativeThinSpace", "ObjectName",
  CellTags->"S1.1324"],

Cell[TextData[{
  "\[NegativeThinSpace]  \[Backslash]",
  StyleBox["[NegativeThinSpace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1324"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["-", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1324"],

Cell["\[FilledSmallSquare] Negative spacing character. ", "Notes",
  CellTags->"S1.1324"],

Cell["\<\
\[FilledSmallSquare] Used to bring characters on either side closer \
together. \
\>", "Notes",
  CellTags->"S1.1324"],

Cell[TextData[{
  "\[FilledSmallSquare] Width: ",
  Cell[BoxData[
      \(TraditionalForm\`\(-3\)/18\)], "InlineFormula"],
  " em. "
}], "Notes",
  CellTags->"S1.1324"],

Cell[TextData[{
  "\[FilledSmallSquare] Interpreted by default just like an ordinary ",
  ButtonBox["\[Backslash][RawSpace]",
    ButtonData:>{"RawSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1324"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.25"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1324"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NegativeVeryThinSpace]",
    ButtonData:>{"NegativeVeryThinSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NegativeMediumSpace]",
    ButtonData:>{"NegativeMediumSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ThinSpace]",
    ButtonData:>{"ThinSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1324"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NegativeVeryThinSpace", "ObjectName",
  CellTags->"S1.1325"],

Cell[TextData[{
  "\[NegativeVeryThinSpace]  \[Backslash]",
  StyleBox["[NegativeVeryThinSpace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1325"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["-", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1325"],

Cell["\[FilledSmallSquare] Negative spacing character. ", "Notes",
  CellTags->"S1.1325"],

Cell["\<\
\[FilledSmallSquare] Used to bring characters on either side closer \
together. \
\>", "Notes",
  CellTags->"S1.1325"],

Cell[TextData[{
  "\[FilledSmallSquare] Width: ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)/18\)], "InlineFormula"],
  " em. "
}], "Notes",
  CellTags->"S1.1325"],

Cell[TextData[{
  "\[FilledSmallSquare] Interpreted by default just like an ordinary ",
  ButtonBox["\[Backslash][RawSpace]",
    ButtonData:>{"RawSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1325"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.25"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1325"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NegativeThinSpace]",
    ButtonData:>{"NegativeThinSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VeryThinSpace]",
    ButtonData:>{"VeryThinSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1325"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NestedGreaterGreater", "ObjectName",
  CellTags->"S1.1326"],

Cell[TextData[{
  "\[NestedGreaterGreater]  \[Backslash]",
  StyleBox["[NestedGreaterGreater]", "MR"]
}], "CharacterName",
  CellTags->"S1.1326"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1326"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NestedGreaterGreater] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NestedGreaterGreater[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1326"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1326"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GreaterGreater]",
    ButtonData:>{"GreaterGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotGreaterGreater]",
    ButtonData:>{"NotGreaterGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotNestedGreaterGreater]",
    ButtonData:>{"NotNestedGreaterGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1326"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NestedLessLess", "ObjectName",
  CellTags->"S1.1327"],

Cell[TextData[{
  "\[NestedLessLess]  \[Backslash]",
  StyleBox["[NestedLessLess]", "MR"]
}], "CharacterName",
  CellTags->"S1.1327"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1327"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NestedLessLess] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NestedLessLess[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1327"],

Cell["\<\
\[FilledSmallSquare] Used to denote \[OpenCurlyDoubleQuote]much \
less than\[CloseCurlyDoubleQuote]. \
\>", "Notes",
  CellTags->"S1.1327"],

Cell["\<\
\[FilledSmallSquare] Occasionally used in measure theory to denote \
\[OpenCurlyDoubleQuote]absolutely continuous with respect to\
\[CloseCurlyDoubleQuote]. \
\>", "Notes",
  CellTags->"S1.1327"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1327"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LessLess]",
    ButtonData:>{"LessLess"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLessLess]",
    ButtonData:>{"NotLessLess"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotNestedLessLess]",
    ButtonData:>{"NotNestedLessLess"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1327"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NeutralSmiley", "ObjectName",
  CellTags->"S1.1328"],

Cell[TextData[{
  "\[NeutralSmiley]  \[Backslash]",
  StyleBox["[NeutralSmiley]", "MR"]
}], "CharacterName",
  CellTags->"S1.1328"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox[":-|\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1328"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1328"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.30"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1328"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][HappySmiley]",
    ButtonData:>{"HappySmiley"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SadSmiley]",
    ButtonData:>{"SadSmiley"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FreakedSmiley]",
    ButtonData:>{"FreakedSmiley"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1328"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NewLine", "ObjectName",
  CellTags->"S1.1329"],

Cell[TextData[{
  "\n  \[Backslash]",
  StyleBox["[NewLine]", "MR"]
}], "CharacterName",
  CellTags->"S1.1329"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1329"],

Cell["\<\
\[FilledSmallSquare] Inserted whenever a raw newline is entered on \
the keyboard. \
\>", "Notes",
  CellTags->"S1.1329"],

Cell["\<\
\[FilledSmallSquare] Forces a line break in an expression, fixing \
the indenting level at the time when the line break is inserted. \
\>", \
"Notes",
  CellTags->"S1.1329"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[NewLine]", "MR"],
  " represents a newline on any computer system, independent of the \
underlying character code used on that computer system. "
}], "Notes",
  CellTags->"S1.1329"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.64"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1329"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][IndentingNewLine]",
    ButtonData:>{"IndentingNewLine"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawReturn]",
    ButtonData:>{"RawReturn"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1329"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NoBreak", "ObjectName",
  CellTags->"S1.1330"],

Cell[TextData[{
  "\[NoBreak]  \[Backslash]",
  StyleBox["[NoBreak]", "MR"]
}], "CharacterName",
  CellTags->"S1.1330"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["nb\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1330"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1330"],

Cell["\<\
\[FilledSmallSquare] Used to indicate that no line break can occur \
at this position in an expression. \
\>", "Notes",
  CellTags->"S1.1330"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.63"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1330"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NonBreakingSpace]",
    ButtonData:>{"NonBreakingSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NewLine]",
    ButtonData:>{"NewLine"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Continuation]",
    ButtonData:>{"Continuation"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][AlignmentMarker]",
    ButtonData:>{"AlignmentMarker"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Null]",
    ButtonData:>{"Null"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][InvisibleSpace]",
    ButtonData:>{"InvisibleSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1330"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NonBreakingSpace", "ObjectName",
  CellTags->"S1.1331"],

Cell[TextData[{
  "\[NonBreakingSpace]  \[Backslash]",
  StyleBox["[NonBreakingSpace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1331"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["nbs\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1331"],

Cell["\[FilledSmallSquare] Spacing character. ", "Notes",
  CellTags->"S1.1331"],

Cell[TextData[{
  "\[FilledSmallSquare] Generates a space with the same width as \
\[Backslash]",
  StyleBox["[RawSpace]", "MR"],
  ", but with no line break allowed to occur on either side of it. "
}], "Notes",
  CellTags->"S1.1331"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.63"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1331"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NoBreak]",
    ButtonData:>{"NoBreak"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][InvisibleSpace]",
    ButtonData:>{"InvisibleSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NewLine]",
    ButtonData:>{"NewLine"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1331"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nor", "ObjectName",
  CellTags->"S1.1332"],

Cell[TextData[{
  "\[Nor]  \[Backslash]",
  StyleBox["[Nor]", "MR"]
}], "CharacterName",
  CellTags->"S1.1332"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["nor\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1332"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1332"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Nor] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Nor[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1332"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1332"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Xor]",
    ButtonData:>{"Xor"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Or]",
    ButtonData:>{"Or"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Not]",
    ButtonData:>{"Not"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1332"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Not", "ObjectName",
  CellTags->"S1.1333"],

Cell[TextData[{
  "\[Not]  \[Backslash]",
  StyleBox["[Not]", "MR"]
}], "CharacterName",
  CellTags->"S1.1333"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["!\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["not\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1333"],

Cell["\<\
\[FilledSmallSquare] Prefix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1333"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[Not] \)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " is by default interpreted as ",
  StyleBox["Not[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ", equivalent to ",
  StyleBox["!", "MR"],
  StyleBox["x", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1333"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1333"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightTee]",
    ButtonData:>{"RightTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][And]",
    ButtonData:>{"And"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Or]",
    ButtonData:>{"Or"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1333"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotCongruent", "ObjectName",
  CellTags->"S1.1334"],

Cell[TextData[{
  "\[NotCongruent]  \[Backslash]",
  StyleBox["[NotCongruent]", "MR"]
}], "CharacterName",
  CellTags->"S1.1334"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!===\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1334"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1334"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotCongruent] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotCongruent[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1334"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1334"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotEqual]",
    ButtonData:>{"NotEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Congruent]",
    ButtonData:>{"Congruent"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1334"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotCupCap", "ObjectName",
  CellTags->"S1.1335"],

Cell[TextData[{
  "\[NotCupCap]  \[Backslash]",
  StyleBox["[NotCupCap]", "MR"]
}], "CharacterName",
  CellTags->"S1.1335"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1335"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotCupCap] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotCupCap[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1335"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1335"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CupCap]",
    ButtonData:>{"CupCap"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1335"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotDoubleVerticalBar", "ObjectName",
  CellTags->"S1.1336"],

Cell[TextData[{
  "\[NotDoubleVerticalBar]  \[Backslash]",
  StyleBox["[NotDoubleVerticalBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1336"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!||\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1336"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1336"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotDoubleVerticalBar] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotDoubleVerticalBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1336"],

Cell["\<\
\[FilledSmallSquare] Used in geometry to mean \
\[OpenCurlyDoubleQuote]not parallel to\[CloseCurlyDoubleQuote]. \
\>", "Notes",\

  CellTags->"S1.1336"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1336"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubleVerticalBar]",
    ButtonData:>{"DoubleVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotVerticalBar]",
    ButtonData:>{"NotVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpTee]",
    ButtonData:>{"UpTee"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1336"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotElement", "ObjectName",
  CellTags->"S1.1337"],

Cell[TextData[{
  "\[NotElement]  \[Backslash]",
  StyleBox["[NotElement]", "MR"]
}], "CharacterName",
  CellTags->"S1.1337"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!el\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1337"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator with \
built\[Hyphen]in evaluation rules. \
\>", "Notes",
  CellTags->"S1.1337"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotElement] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotElement[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1337"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1337"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Element]",
    ButtonData:>{"Element"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotReverseElement]",
    ButtonData:>{"NotReverseElement"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1337"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotEqual", "ObjectName",
  CellTags->"S1.1338"],

Cell[TextData[{
  "\[NotEqual]  \[Backslash]",
  StyleBox["[NotEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1338"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1338"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1338"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Unequal[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1338"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1338"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Equal]",
    ButtonData:>{"Equal"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotCongruent]",
    ButtonData:>{"NotCongruent"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GreaterLess]",
    ButtonData:>{"GreaterLess"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1338"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotEqualTilde", "ObjectName",
  CellTags->"S1.1339"],

Cell[TextData[{
  "\[NotEqualTilde]  \[Backslash]",
  StyleBox["[NotEqualTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1339"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!=", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1339"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1339"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotEqualTilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotEqualTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1339"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1339"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EqualTilde]",
    ButtonData:>{"EqualTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1339"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotExists", "ObjectName",
  CellTags->"S1.1340"],

Cell[TextData[{
  "\[NotExists]  \[Backslash]",
  StyleBox["[NotExists]", "MR"]
}], "CharacterName",
  CellTags->"S1.1340"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!ex\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1340"],

Cell["\[FilledSmallSquare] Compound operator. ", "Notes",
  CellTags->"S1.1340"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      RowBox[{
        SubscriptBox["\[NotExists]", 
          StyleBox["x",
            "TI"]], 
        StyleBox["y",
          "TI"]}]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["NotExists[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1340"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1340"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Exists]",
    ButtonData:>{"Exists"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ForAll]",
    ButtonData:>{"ForAll"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1340"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotGreater", "ObjectName",
  CellTags->"S1.1341"],

Cell[TextData[{
  "\[NotGreater]  \[Backslash]",
  StyleBox["[NotGreater]", "MR"]
}], "CharacterName",
  CellTags->"S1.1341"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!>\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1341"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1341"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotGreater] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotGreater[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1341"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotGreater] \)], "InlineFormula"],
  " is equivalent to ",
  Cell[BoxData[
      \(TraditionalForm\` \[LessEqual] \)], "InlineFormula"],
  " only for a totally ordered set. "
}], "Notes",
  CellTags->"S1.1341"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1341"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawGreater]",
    ButtonData:>{"RawGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1341"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotGreaterEqual", "ObjectName",
  CellTags->"S1.1342"],

Cell[TextData[{
  "\[NotGreaterEqual]  \[Backslash]",
  StyleBox["[NotGreaterEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1342"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!>=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1342"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1342"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotGreaterEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotGreaterEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1342"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1342"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GreaterEqual]",
    ButtonData:>{"GreaterEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GreaterFullEqual]",
    ButtonData:>{"GreaterFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GreaterSlantEqual]",
    ButtonData:>{"GreaterSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotGreaterFullEqual]",
    ButtonData:>{"NotGreaterFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotGreaterSlantEqual]",
    ButtonData:>{"NotGreaterSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1342"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotGreaterFullEqual", "ObjectName",
  CellTags->"S1.1343"],

Cell[TextData[{
  "\[NotGreaterFullEqual]  \[Backslash]",
  StyleBox["[NotGreaterFullEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1343"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1343"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotGreaterFullEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotGreaterFullEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1343"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1343"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GreaterEqual]",
    ButtonData:>{"GreaterEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GreaterFullEqual]",
    ButtonData:>{"GreaterFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GreaterSlantEqual]",
    ButtonData:>{"GreaterSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotGreaterEqual]",
    ButtonData:>{"NotGreaterEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotGreaterSlantEqual]",
    ButtonData:>{"NotGreaterSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1343"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotGreaterGreater", "ObjectName",
  CellTags->"S1.1344"],

Cell[TextData[{
  "\[NotGreaterGreater]  \[Backslash]",
  StyleBox["[NotGreaterGreater]", "MR"]
}], "CharacterName",
  CellTags->"S1.1344"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1344"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotGreaterGreater] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotGreaterGreater[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1344"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1344"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GreaterGreater]",
    ButtonData:>{"GreaterGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NestedGreaterGreater]",
    ButtonData:>{"NestedGreaterGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotNestedGreaterGreater]",
    ButtonData:>{"NotNestedGreaterGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1344"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotGreaterLess", "ObjectName",
  CellTags->"S1.1345"],

Cell[TextData[{
  "\[NotGreaterLess]  \[Backslash]",
  StyleBox["[NotGreaterLess]", "MR"]
}], "CharacterName",
  CellTags->"S1.1345"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1345"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotGreaterLess] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotGreaterLess[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1345"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1345"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GreaterLess]",
    ButtonData:>{"GreaterLess"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1345"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotGreaterSlantEqual", "ObjectName",
  CellTags->"S1.1346"],

Cell[TextData[{
  "\[NotGreaterSlantEqual]  \[Backslash]",
  StyleBox["[NotGreaterSlantEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1346"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!>/\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1346"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1346"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotGreaterSlantEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotGreaterSlantEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1346"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1346"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GreaterEqual]",
    ButtonData:>{"GreaterEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GreaterFullEqual]",
    ButtonData:>{"GreaterFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GreaterSlantEqual]",
    ButtonData:>{"GreaterSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotGreaterEqual]",
    ButtonData:>{"NotGreaterEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotGreaterFullEqual]",
    ButtonData:>{"NotGreaterFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1346"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotGreaterTilde", "ObjectName",
  CellTags->"S1.1347"],

Cell[TextData[{
  "\[NotGreaterTilde]  \[Backslash]",
  StyleBox["[NotGreaterTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1347"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!>", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1347"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1347"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotGreaterTilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotGreaterTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1347"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1347"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GreaterTilde]",
    ButtonData:>{"GreaterTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1347"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotHumpDownHump", "ObjectName",
  CellTags->"S1.1348"],

Cell[TextData[{
  "\[NotHumpDownHump]  \[Backslash]",
  StyleBox["[NotHumpDownHump]", "MR"]
}], "CharacterName",
  CellTags->"S1.1348"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1348"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotHumpDownHump] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotHumpDownHump[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1348"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1348"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][HumpDownHump]",
    ButtonData:>{"HumpDownHump"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1348"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotHumpEqual", "ObjectName",
  CellTags->"S1.1349"],

Cell[TextData[{
  "\[NotHumpEqual]  \[Backslash]",
  StyleBox["[NotHumpEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1349"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!h=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1349"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1349"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotHumpEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotHumpEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1349"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1349"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][HumpEqual]",
    ButtonData:>{"HumpEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1349"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotLeftTriangle", "ObjectName",
  CellTags->"S1.1350"],

Cell[TextData[{
  "\[NotLeftTriangle]  \[Backslash]",
  StyleBox["[NotLeftTriangle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1350"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1350"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotLeftTriangle] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotLeftTriangle[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1350"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1350"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotLeftTriangleBar]",
    ButtonData:>{"NotLeftTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLeftTriangleEqual]",
    ButtonData:>{"NotLeftTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotRightTriangle]",
    ButtonData:>{"NotRightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTriangle]",
    ButtonData:>{"LeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1350"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotLeftTriangleBar", "ObjectName",
  CellTags->"S1.1351"],

Cell[TextData[{
  "\[NotLeftTriangleBar]  \[Backslash]",
  StyleBox["[NotLeftTriangleBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1351"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1351"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotLeftTriangleBar] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotLeftTriangleBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1351"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1351"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotLeftTriangle]",
    ButtonData:>{"NotLeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLeftTriangleEqual]",
    ButtonData:>{"NotLeftTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotRightTriangleBar]",
    ButtonData:>{"NotRightTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTriangleBar]",
    ButtonData:>{"LeftTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1351"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotLeftTriangleEqual", "ObjectName",
  CellTags->"S1.1352"],

Cell[TextData[{
  "\[NotLeftTriangleEqual]  \[Backslash]",
  StyleBox["[NotLeftTriangleEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1352"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1352"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotLeftTriangleEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotLeftTriangleEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1352"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1352"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotLeftTriangle]",
    ButtonData:>{"NotLeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLeftTriangleBar]",
    ButtonData:>{"NotLeftTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotRightTriangleEqual]",
    ButtonData:>{"NotRightTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTriangleEqual]",
    ButtonData:>{"LeftTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1352"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotLess", "ObjectName",
  CellTags->"S1.1353"],

Cell[TextData[{
  "\[NotLess]  \[Backslash]",
  StyleBox["[NotLess]", "MR"]
}], "CharacterName",
  CellTags->"S1.1353"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!<\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1353"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1353"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotLess] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotLess[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1353"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotLess] \)], "InlineFormula"],
  " is equivalent to ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterEqual] \)], "InlineFormula"],
  " only for a totally ordered set. "
}], "Notes",
  CellTags->"S1.1353"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1353"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawLess]",
    ButtonData:>{"RawLess"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1353"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotLessEqual", "ObjectName",
  CellTags->"S1.1354"],

Cell[TextData[{
  "\[NotLessEqual]  \[Backslash]",
  StyleBox["[NotLessEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1354"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!<=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1354"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1354"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotLessEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotLessEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1354"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1354"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LessEqual]",
    ButtonData:>{"LessEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LessFullEqual]",
    ButtonData:>{"LessFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LessSlantEqual]",
    ButtonData:>{"LessSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLessFullEqual]",
    ButtonData:>{"NotLessFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLessSlantEqual]",
    ButtonData:>{"NotLessSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1354"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotLessFullEqual", "ObjectName",
  CellTags->"S1.1355"],

Cell[TextData[{
  "\[NotLessFullEqual]  \[Backslash]",
  StyleBox["[NotLessFullEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1355"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1355"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotLessFullEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotLessFullEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1355"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1355"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LessEqual]",
    ButtonData:>{"LessEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LessFullEqual]",
    ButtonData:>{"LessFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LessSlantEqual]",
    ButtonData:>{"LessSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLessEqual]",
    ButtonData:>{"NotLessEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLessSlantEqual]",
    ButtonData:>{"NotLessSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1355"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotLessGreater", "ObjectName",
  CellTags->"S1.1356"],

Cell[TextData[{
  "\[NotLessGreater]  \[Backslash]",
  StyleBox["[NotLessGreater]", "MR"]
}], "CharacterName",
  CellTags->"S1.1356"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1356"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotLessGreater] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotLessGreater[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1356"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1356"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LessGreater]",
    ButtonData:>{"LessGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1356"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotLessLess", "ObjectName",
  CellTags->"S1.1357"],

Cell[TextData[{
  "\[NotLessLess]  \[Backslash]",
  StyleBox["[NotLessLess]", "MR"]
}], "CharacterName",
  CellTags->"S1.1357"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1357"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotLessLess] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotLessLess[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1357"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1357"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LessLess]",
    ButtonData:>{"LessLess"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NestedLessLess]",
    ButtonData:>{"NestedLessLess"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotNestedLessLess]",
    ButtonData:>{"NotNestedLessLess"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1357"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotLessSlantEqual", "ObjectName",
  CellTags->"S1.1358"],

Cell[TextData[{
  "\[NotLessSlantEqual]  \[Backslash]",
  StyleBox["[NotLessSlantEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1358"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!</\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1358"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1358"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotLessSlantEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotLessSlantEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1358"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1358"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LessEqual]",
    ButtonData:>{"LessEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LessFullEqual]",
    ButtonData:>{"LessFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LessSlantEqual]",
    ButtonData:>{"LessSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLessEqual]",
    ButtonData:>{"NotLessEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLessFullEqual]",
    ButtonData:>{"NotLessFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1358"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotLessTilde", "ObjectName",
  CellTags->"S1.1359"],

Cell[TextData[{
  "\[NotLessTilde]  \[Backslash]",
  StyleBox["[NotLessTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1359"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!<", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1359"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1359"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotLessTilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotLessTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1359"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1359"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LessTilde]",
    ButtonData:>{"LessTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1359"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotNestedGreaterGreater", "ObjectName",
  CellTags->"S1.1360"],

Cell[TextData[{
  "\[NotNestedGreaterGreater]  \[Backslash]",
  StyleBox["[NotNestedGreaterGreater]", "MR"]
}], "CharacterName",
  CellTags->"S1.1360"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1360"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotNestedGreaterGreater] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotNestedGreaterGreater[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1360"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1360"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GreaterGreater]",
    ButtonData:>{"GreaterGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NestedGreaterGreater]",
    ButtonData:>{"NestedGreaterGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotGreaterGreater]",
    ButtonData:>{"NotGreaterGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1360"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotNestedLessLess", "ObjectName",
  CellTags->"S1.1361"],

Cell[TextData[{
  "\[NotNestedLessLess]  \[Backslash]",
  StyleBox["[NotNestedLessLess]", "MR"]
}], "CharacterName",
  CellTags->"S1.1361"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1361"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotNestedLessLess] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotNestedLessLess[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1361"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1361"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LessLess]",
    ButtonData:>{"LessLess"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NestedLessLess]",
    ButtonData:>{"NestedLessLess"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLessLess]",
    ButtonData:>{"NotLessLess"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1361"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotPrecedes", "ObjectName",
  CellTags->"S1.1362"],

Cell[TextData[{
  "\[NotPrecedes]  \[Backslash]",
  StyleBox["[NotPrecedes]", "MR"]
}], "CharacterName",
  CellTags->"S1.1362"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1362"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotPrecedes] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotPrecedes[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1362"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1362"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Precedes]",
    ButtonData:>{"Precedes"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1362"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotPrecedesEqual", "ObjectName",
  CellTags->"S1.1363"],

Cell[TextData[{
  "\[NotPrecedesEqual]  \[Backslash]",
  StyleBox["[NotPrecedesEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1363"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1363"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotPrecedesEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotPrecedesEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1363"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1363"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotPrecedesSlantEqual]",
    ButtonData:>{"NotPrecedesSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotPrecedesTilde]",
    ButtonData:>{"NotPrecedesTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][PrecedesEqual]",
    ButtonData:>{"PrecedesEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1363"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotPrecedesSlantEqual", "ObjectName",
  CellTags->"S1.1364"],

Cell[TextData[{
  "\[NotPrecedesSlantEqual]  \[Backslash]",
  StyleBox["[NotPrecedesSlantEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1364"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1364"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotPrecedesSlantEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotPrecedesSlantEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1364"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1364"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotPrecedesEqual]",
    ButtonData:>{"NotPrecedesEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][PrecedesSlantEqual]",
    ButtonData:>{"PrecedesSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1364"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotPrecedesTilde", "ObjectName",
  CellTags->"S1.1365"],

Cell[TextData[{
  "\[NotPrecedesTilde]  \[Backslash]",
  StyleBox["[NotPrecedesTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1365"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1365"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotPrecedesTilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotPrecedesTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1365"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1365"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotPrecedesEqual]",
    ButtonData:>{"NotPrecedesEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][PrecedesTilde]",
    ButtonData:>{"PrecedesTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1365"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotReverseElement", "ObjectName",
  CellTags->"S1.1366"],

Cell[TextData[{
  "\[NotReverseElement]  \[Backslash]",
  StyleBox["[NotReverseElement]", "MR"]
}], "CharacterName",
  CellTags->"S1.1366"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!mem\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1366"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1366"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotReverseElement] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotReverseElement[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1366"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1366"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ReverseElement]",
    ButtonData:>{"ReverseElement"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotElement]",
    ButtonData:>{"NotElement"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1366"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotRightTriangle", "ObjectName",
  CellTags->"S1.1367"],

Cell[TextData[{
  "\[NotRightTriangle]  \[Backslash]",
  StyleBox["[NotRightTriangle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1367"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1367"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotRightTriangle] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotRightTriangle[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1367"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1367"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotRightTriangleBar]",
    ButtonData:>{"NotRightTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotRightTriangleEqual]",
    ButtonData:>{"NotRightTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLeftTriangle]",
    ButtonData:>{"NotLeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangle]",
    ButtonData:>{"RightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1367"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotRightTriangleBar", "ObjectName",
  CellTags->"S1.1368"],

Cell[TextData[{
  "\[NotRightTriangleBar]  \[Backslash]",
  StyleBox["[NotRightTriangleBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1368"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1368"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotRightTriangleBar] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotRightTriangleBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1368"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1368"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotRightTriangle]",
    ButtonData:>{"NotRightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotRightTriangleEqual]",
    ButtonData:>{"NotRightTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLeftTriangleBar]",
    ButtonData:>{"NotLeftTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangleBar]",
    ButtonData:>{"RightTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1368"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotRightTriangleEqual", "ObjectName",
  CellTags->"S1.1369"],

Cell[TextData[{
  "\[NotRightTriangleEqual]  \[Backslash]",
  StyleBox["[NotRightTriangleEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1369"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1369"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotRightTriangleEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotRightTriangleEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1369"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1369"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotRightTriangle]",
    ButtonData:>{"NotRightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotRightTriangleBar]",
    ButtonData:>{"NotRightTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotLeftTriangleEqual]",
    ButtonData:>{"NotLeftTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangleEqual]",
    ButtonData:>{"RightTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1369"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotSquareSubset", "ObjectName",
  CellTags->"S1.1370"],

Cell[TextData[{
  "\[NotSquareSubset]  \[Backslash]",
  StyleBox["[NotSquareSubset]", "MR"]
}], "CharacterName",
  CellTags->"S1.1370"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1370"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotSquareSubset] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotSquareSubset[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1370"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1370"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSquareSubsetEqual]",
    ButtonData:>{"NotSquareSubsetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SquareSubset]",
    ButtonData:>{"SquareSubset"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1370"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotSquareSubsetEqual", "ObjectName",
  CellTags->"S1.1371"],

Cell[TextData[{
  "\[NotSquareSubsetEqual]  \[Backslash]",
  StyleBox["[NotSquareSubsetEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1371"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1371"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotSquareSubsetEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotSquareSubsetEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1371"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1371"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSquareSubset]",
    ButtonData:>{"NotSquareSubset"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SquareSubsetEqual]",
    ButtonData:>{"SquareSubsetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1371"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotSquareSuperset", "ObjectName",
  CellTags->"S1.1372"],

Cell[TextData[{
  "\[NotSquareSuperset]  \[Backslash]",
  StyleBox["[NotSquareSuperset]", "MR"]
}], "CharacterName",
  CellTags->"S1.1372"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1372"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotSquareSuperset] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotSquareSuperset[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1372"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1372"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSquareSupersetEqual]",
    ButtonData:>{"NotSquareSupersetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SquareSuperset]",
    ButtonData:>{"SquareSuperset"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1372"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotSquareSupersetEqual", "ObjectName",
  CellTags->"S1.1373"],

Cell[TextData[{
  "\[NotSquareSupersetEqual]  \[Backslash]",
  StyleBox["[NotSquareSupersetEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1373"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1373"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotSquareSupersetEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotSquareSupersetEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1373"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1373"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSquareSuperset]",
    ButtonData:>{"NotSquareSuperset"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SquareSupersetEqual]",
    ButtonData:>{"SquareSupersetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1373"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotSubset", "ObjectName",
  CellTags->"S1.1374"],

Cell[TextData[{
  "\[NotSubset]  \[Backslash]",
  StyleBox["[NotSubset]", "MR"]
}], "CharacterName",
  CellTags->"S1.1374"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!sub\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1374"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1374"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotSubset] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotSubset[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1374"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1374"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSubsetEqual]",
    ButtonData:>{"NotSubsetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Subset]",
    ButtonData:>{"Subset"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1374"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotSubsetEqual", "ObjectName",
  CellTags->"S1.1375"],

Cell[TextData[{
  "\[NotSubsetEqual]  \[Backslash]",
  StyleBox["[NotSubsetEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1375"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!sub=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1375"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1375"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotSubsetEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotSubsetEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1375"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1375"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSubset]",
    ButtonData:>{"NotSubset"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SubsetEqual]",
    ButtonData:>{"SubsetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1375"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotSucceeds", "ObjectName",
  CellTags->"S1.1376"],

Cell[TextData[{
  "\[NotSucceeds]  \[Backslash]",
  StyleBox["[NotSucceeds]", "MR"]
}], "CharacterName",
  CellTags->"S1.1376"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1376"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotSucceeds] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotSucceeds[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1376"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1376"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSucceedsEqual]",
    ButtonData:>{"NotSucceedsEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Succeeds]",
    ButtonData:>{"Succeeds"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1376"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotSucceedsEqual", "ObjectName",
  CellTags->"S1.1377"],

Cell[TextData[{
  "\[NotSucceedsEqual]  \[Backslash]",
  StyleBox["[NotSucceedsEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1377"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1377"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotSucceedsEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotSucceedsEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1377"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1377"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSucceedsSlantEqual]",
    ButtonData:>{"NotSucceedsSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotSucceedsTilde]",
    ButtonData:>{"NotSucceedsTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SucceedsSlantEqual]",
    ButtonData:>{"SucceedsSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1377"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotSucceedsSlantEqual", "ObjectName",
  CellTags->"S1.1378"],

Cell[TextData[{
  "\[NotSucceedsSlantEqual]  \[Backslash]",
  StyleBox["[NotSucceedsSlantEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1378"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1378"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotSucceedsSlantEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotSucceedsSlantEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1378"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1378"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSucceedsEqual]",
    ButtonData:>{"NotSucceedsEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SucceedsSlantEqual]",
    ButtonData:>{"SucceedsSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1378"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotSucceedsTilde", "ObjectName",
  CellTags->"S1.1379"],

Cell[TextData[{
  "\[NotSucceedsTilde]  \[Backslash]",
  StyleBox["[NotSucceedsTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1379"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1379"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotSucceedsTilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotSucceedsTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1379"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1379"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSucceedsEqual]",
    ButtonData:>{"NotSucceedsEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SucceedsTilde]",
    ButtonData:>{"SucceedsTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1379"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotSuperset", "ObjectName",
  CellTags->"S1.1380"],

Cell[TextData[{
  "\[NotSuperset]  \[Backslash]",
  StyleBox["[NotSuperset]", "MR"]
}], "CharacterName",
  CellTags->"S1.1380"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!sup\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1380"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1380"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotSuperset] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotSuperset[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1380"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1380"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSupersetEqual]",
    ButtonData:>{"NotSupersetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Superset]",
    ButtonData:>{"Superset"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1380"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotSupersetEqual", "ObjectName",
  CellTags->"S1.1381"],

Cell[TextData[{
  "\[NotSupersetEqual]  \[Backslash]",
  StyleBox["[NotSupersetEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1381"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!sup=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1381"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1381"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotSupersetEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotSupersetEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1381"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1381"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSuperset]",
    ButtonData:>{"NotSuperset"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SupersetEqual]",
    ButtonData:>{"SupersetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1381"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotTilde", "ObjectName",
  CellTags->"S1.1382"],

Cell[TextData[{
  "\[NotTilde]  \[Backslash]",
  StyleBox["[NotTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1382"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1382"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1382"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotTilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1382"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1382"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Tilde]",
    ButtonData:>{"Tilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1382"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotTildeEqual", "ObjectName",
  CellTags->"S1.1383"],

Cell[TextData[{
  "\[NotTildeEqual]  \[Backslash]",
  StyleBox["[NotTildeEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1383"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  StyleBox["=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1383"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1383"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotTildeEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotTildeEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1383"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1383"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotTildeFullEqual]",
    ButtonData:>{"NotTildeFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][TildeEqual]",
    ButtonData:>{"TildeEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][TildeFullEqual]",
    ButtonData:>{"TildeFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1383"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotTildeFullEqual", "ObjectName",
  CellTags->"S1.1384"],

Cell[TextData[{
  "\[NotTildeFullEqual]  \[Backslash]",
  StyleBox["[NotTildeFullEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1384"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  StyleBox["==\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1384"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1384"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotTildeFullEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotTildeFullEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1384"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1384"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotTildeEqual]",
    ButtonData:>{"NotTildeEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotCongruent]",
    ButtonData:>{"NotCongruent"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][TildeFullEqual]",
    ButtonData:>{"TildeFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1384"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotTildeTilde", "ObjectName",
  CellTags->"S1.1385"],

Cell[TextData[{
  "\[NotTildeTilde]  \[Backslash]",
  StyleBox["[NotTildeTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1385"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1385"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1385"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotTildeTilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotTildeTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1385"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1385"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][TildeTilde]",
    ButtonData:>{"TildeTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1385"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotVerticalBar", "ObjectName",
  CellTags->"S1.1386"],

Cell[TextData[{
  "\[NotVerticalBar]  \[Backslash]",
  StyleBox["[NotVerticalBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1386"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["!|\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1386"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1386"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[NotVerticalBar] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["NotVerticalBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1386"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in mathematics to mean ",
  StyleBox["x", "TI"],
  " does not divide ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1386"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1386"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][VerticalBar]",
    ButtonData:>{"VerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotDoubleVerticalBar]",
    ButtonData:>{"NotDoubleVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1386"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NTilde", "ObjectName",
  CellTags->"S1.1387"],

Cell[TextData[{
  "\[NTilde]  \[Backslash]",
  StyleBox["[NTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1387"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["n", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1387"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1387"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1387"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1387"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalNTilde]",
    ButtonData:>{"CapitalNTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1387"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nu", "ObjectName",
  CellTags->"S1.1388"],

Cell[TextData[{
  "\[Nu]  \[Backslash]",
  StyleBox["[Nu]", "MR"]
}], "CharacterName",
  CellTags->"S1.1388"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["n\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["nu\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1388"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1388"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1388"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalNu]",
    ButtonData:>{"CapitalNu"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Vee]",
    ButtonData:>{"Vee"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1388"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Null", "ObjectName",
  CellTags->"S1.1389"],

Cell[TextData[{
  "\[Null]  \[Backslash]",
  StyleBox["[Null]", "MR"]
}], "CharacterName",
  CellTags->"S1.1389"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["null\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1389"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1389"],

Cell["\<\
\[FilledSmallSquare] Can be used to place subscripts and \
superscripts without having a visible base. \
\>", "Notes",
  CellTags->"S1.1389"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1389"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][InvisibleComma]",
    ButtonData:>{"InvisibleComma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][InvisibleSpace]",
    ButtonData:>{"InvisibleSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][AlignmentMarker]",
    ButtonData:>{"AlignmentMarker"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1389"]
}, Open  ]],

Cell[CellGroupData[{

Cell["OAcute", "ObjectName",
  CellTags->"S1.1390"],

Cell[TextData[{
  "\[OAcute]  \[Backslash]",
  StyleBox["[OAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1390"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["o'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1390"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1390"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1390"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1390"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalOAcute]",
    ButtonData:>{"CapitalOAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1390"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ODoubleAcute", "ObjectName",
  CellTags->"S1.1391"],

Cell[TextData[{
  "\[ODoubleAcute]  \[Backslash]",
  StyleBox["[ODoubleAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1391"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["o''\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1391"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1391"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1391"],

Cell["\<\
\[FilledSmallSquare] Used in Hungarian, for example in the name Erd\
\[DoublePrime]os. \
\>", "Notes",
  CellTags->"S1.1391"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1391"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalODoubleAcute]",
    ButtonData:>{"CapitalODoubleAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UDoubleAcute]",
    ButtonData:>{"UDoubleAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1391"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ODoubleDot", "ObjectName",
  CellTags->"S1.1392"],

Cell[TextData[{
  "\[ODoubleDot]  \[Backslash]",
  StyleBox["[ODoubleDot]", "MR"]
}], "CharacterName",
  CellTags->"S1.1392"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["o\"\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1392"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1392"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1392"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1392"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ODoubleAcute]",
    ButtonData:>{"ODoubleAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalODoubleDot]",
    ButtonData:>{"CapitalODoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1392"]
}, Open  ]],

Cell[CellGroupData[{

Cell["OGrave", "ObjectName",
  CellTags->"S1.1393"],

Cell[TextData[{
  "\[OGrave]  \[Backslash]",
  StyleBox["[OGrave]", "MR"]
}], "CharacterName",
  CellTags->"S1.1393"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["o`\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1393"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1393"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1393"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1393"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalOGrave]",
    ButtonData:>{"CapitalOGrave"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1393"]
}, Open  ]],

Cell[CellGroupData[{

Cell["OHat", "ObjectName",
  CellTags->"S1.1394"],

Cell[TextData[{
  "\[OHat]  \[Backslash]",
  StyleBox["[OHat]", "MR"]
}], "CharacterName",
  CellTags->"S1.1394"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["o^\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1394"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1394"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1394"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1394"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalOHat]",
    ButtonData:>{"CapitalOHat"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1394"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Omega", "ObjectName",
  CellTags->"S1.1395"],

Cell[TextData[{
  "\[Omega]  \[Backslash]",
  StyleBox["[Omega]", "MR"]
}], "CharacterName",
  CellTags->"S1.1395"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["o\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["omega\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["w\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1395"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1395"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1395"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalOmega]",
    ButtonData:>{"CapitalOmega"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CurlyPi]",
    ButtonData:>{"CurlyPi"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Omicron]",
    ButtonData:>{"Omicron"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1395"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Omicron", "ObjectName",
  CellTags->"S1.1396"],

Cell[TextData[{
  "\[Omicron]  \[Backslash]",
  StyleBox["[Omicron]", "MR"]
}], "CharacterName",
  CellTags->"S1.1396"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["om\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["omicron\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1396"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1396"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as English ",
  StyleBox["o", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1396"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1396"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalOmicron]",
    ButtonData:>{"CapitalOmicron"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Omega]",
    ButtonData:>{"Omega"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1396"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Or", "ObjectName",
  CellTags->"S1.1397"],

Cell[TextData[{
  "\[Or]  \[Backslash]",
  StyleBox["[Or]", "MR"]
}], "CharacterName",
  CellTags->"S1.1397"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["||\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["or\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1397"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1397"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Or] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Or[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ", equivalent to ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["||", "MR"],
  " ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1397"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Vee]",
    ButtonData:>{"Vee"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1397"],

Cell[TextData[{
  "\[FilledSmallSquare] Drawn slightly larger than ",
  ButtonBox["\[Backslash][Vee]",
    ButtonData:>{"Vee"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1397"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.10"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1397"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][And]",
    ButtonData:>{"And"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Xor]",
    ButtonData:>{"Xor"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Nor]",
    ButtonData:>{"Nor"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Not]",
    ButtonData:>{"Not"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1397"]
}, Open  ]],

Cell[CellGroupData[{

Cell["OSlash", "ObjectName",
  CellTags->"S1.1398"],

Cell[TextData[{
  "\[OSlash]  \[Backslash]",
  StyleBox["[OSlash]", "MR"]
}], "CharacterName",
  CellTags->"S1.1398"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["o/\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1398"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1398"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1398"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][EmptySet]",
    ButtonData:>{"EmptySet"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1398"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1398"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalOSlash]",
    ButtonData:>{"CapitalOSlash"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1398"]
}, Open  ]],

Cell[CellGroupData[{

Cell["OTilde", "ObjectName",
  CellTags->"S1.1399"],

Cell[TextData[{
  "\[OTilde]  \[Backslash]",
  StyleBox["[OTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1399"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["o", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1399"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1399"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1399"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1399"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalOTilde]",
    ButtonData:>{"CapitalOTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1399"]
}, Open  ]],

Cell[CellGroupData[{

Cell["OverBrace", "ObjectName",
  CellTags->"S1.1400"],

Cell[TextData[{
  "\[OverBrace]  \[Backslash]",
  StyleBox["[OverBrace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1400"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["o", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1400"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1400"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1400"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1400"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][OverBracket]",
    ButtonData:>{"OverBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][OverParenthesis]",
    ButtonData:>{"OverParenthesis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UnderBrace]",
    ButtonData:>{"UnderBrace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1400"]
}, Open  ]],

Cell[CellGroupData[{

Cell["OverBracket", "ObjectName",
  CellTags->"S1.1401"],

Cell[TextData[{
  "\[OverBracket]  \[Backslash]",
  StyleBox["[OverBracket]", "MR"]
}], "CharacterName",
  CellTags->"S1.1401"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["o[\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1401"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1401"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1401"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1401"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][OverParenthesis]",
    ButtonData:>{"OverParenthesis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][OverBrace]",
    ButtonData:>{"OverBrace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UnderBracket]",
    ButtonData:>{"UnderBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][HorizontalLine]",
    ButtonData:>{"HorizontalLine"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1401"]
}, Open  ]],

Cell[CellGroupData[{

Cell["OverParenthesis", "ObjectName",
  CellTags->"S1.1402"],

Cell[TextData[{
  "\[OverParenthesis]  \[Backslash]",
  StyleBox["[OverParenthesis]", "MR"]
}], "CharacterName",
  CellTags->"S1.1402"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["o(\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1402"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1402"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1402"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1402"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][OverBracket]",
    ButtonData:>{"OverBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][OverBrace]",
    ButtonData:>{"OverBrace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UnderParenthesis]",
    ButtonData:>{"UnderParenthesis"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1402"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Paragraph", "ObjectName",
  CellTags->"S1.1403"],

Cell[TextData[{
  "\[Paragraph]  \[Backslash]",
  StyleBox["[Paragraph]", "MR"]
}], "CharacterName",
  CellTags->"S1.1403"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1403"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1403"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Section]",
    ButtonData:>{"Section"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1403"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PartialD", "ObjectName",
  CellTags->"S1.1404"],

Cell[TextData[{
  "\[PartialD]  \[Backslash]",
  StyleBox["[PartialD]", "MR"]
}], "CharacterName",
  CellTags->"S1.1404"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["pd\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1404"],

Cell["\<\
\[FilledSmallSquare] Prefix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1404"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      RowBox[{
        SubscriptBox["\[PartialD]", 
          StyleBox["x",
            "TI"]], 
        StyleBox["y",
          "TI"]}]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["D[", "MR"],
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1404"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\)], "InlineFormula"],
  " is used in mathematics to indicate boundary. "
}], "Notes",
  CellTags->"S1.1404"],

Cell[TextData[{
  "\[FilledSmallSquare] \[AliasIndicator]",
  StyleBox["d\[AliasIndicator]", "MR"],
  " gives ",
  ButtonBox["\[Backslash][Delta]",
    ButtonData:>{"Delta"},
    ButtonStyle->"MainBookLinkMR"],
  ", not \[Backslash]",
  StyleBox["[PartialD]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1404"],

Cell[TextData[{
  "\[FilledSmallSquare] You can use ",
  ButtonBox["\[Backslash][InvisibleComma]",
    ButtonData:>{"InvisibleComma"},
    ButtonStyle->"MainBookLinkMR"],
  " in the subscript to ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\)], "InlineFormula"],
  " to give several variables without having them separated by visible \
commas. "
}], "Notes",
  CellTags->"S1.1404"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.12"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.26"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1404"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Delta]",
    ButtonData:>{"Delta"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Del]",
    ButtonData:>{"Del"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DifferentialD]",
    ButtonData:>{"DifferentialD"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Eth]",
    ButtonData:>{"Eth"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1404"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Phi", "ObjectName",
  CellTags->"S1.1405"],

Cell[TextData[{
  "\[Phi]  \[Backslash]",
  StyleBox["[Phi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1405"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["ph\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["phi\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["f\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1405"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1405"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["EulerPhi", "MR"],
  " and ",
  StyleBox["GoldenRatio", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1405"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1405"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CurlyPhi]",
    ButtonData:>{"CurlyPhi"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalPhi]",
    ButtonData:>{"CapitalPhi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1405"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pi", "ObjectName",
  CellTags->"S1.1406"],

Cell[TextData[{
  "\[Pi]  \[Backslash]",
  StyleBox["[Pi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1406"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["p\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["pi\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1406"],

Cell["\<\
\[FilledSmallSquare] Greek letter with built\[Hyphen]in value. \
\
\>", "Notes",
  CellTags->"S1.1406"],

Cell[TextData[{
  "\[FilledSmallSquare] Interpreted by default as the symbol ",
  StyleBox["Pi", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1406"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1406"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubledPi]",
    ButtonData:>{"DoubledPi"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalPi]",
    ButtonData:>{"CapitalPi"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CurlyPi]",
    ButtonData:>{"CurlyPi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1406"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Piecewise", "ObjectName",
  CellTags->"S1.1407"],

Cell[TextData[{
  "\[Piecewise]  \[Backslash]",
  StyleBox["[Piecewise]", "MR"]
}], "CharacterName",
  CellTags->"S1.1407"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["pw\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1407"],

Cell["\<\
\[FilledSmallSquare] Prefix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1407"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      RowBox[{"\[Piecewise]", GridBox[{
            {
              StyleBox[\(e\_1\),
                "TI"], 
              StyleBox[\(c\_1\),
                "TI"]},
            {
              StyleBox[\(e\_2\),
                "TI"], 
              StyleBox[\(c\_2\),
                "TI"]}
            }]}]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Piecewise[{{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["}}]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1407"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1407"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as keyboard ",
  StyleBox["{", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1407"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1407"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Placeholder", "ObjectName",
  CellTags->"S1.1408"],

Cell[TextData[{
  "\[Placeholder]  \[Backslash]",
  StyleBox["[Placeholder]", "MR"]
}], "CharacterName",
  CellTags->"S1.1408"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["pl\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1408"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1408"],

Cell["\<\
\[FilledSmallSquare] Used to indicate where expressions can be \
inserted in a form obtained by pasting the contents of a button. \
\>", \
"Notes",
  CellTags->"S1.1408"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][EmptySquare]",
    ButtonData:>{"EmptySquare"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1408"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.12",
    ButtonData:>{"1.10.12", "12.10"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.11.3",
    ButtonData:>{"2.11.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1408"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][SelectionPlaceholder]",
    ButtonData:>{"SelectionPlaceholder"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawNumberSign]",
    ButtonData:>{"RawNumberSign"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1408"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PlusMinus", "ObjectName",
  CellTags->"S1.1409"],

Cell[TextData[{
  "\[PlusMinus]  \[Backslash]",
  StyleBox["[PlusMinus]", "MR"]
}], "CharacterName",
  CellTags->"S1.1409"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["+-\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1409"],

Cell["\[FilledSmallSquare] Prefix or infix operator. ", "Notes",
  CellTags->"S1.1409"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[PlusMinus]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " is by default interpreted as ",
  StyleBox["PlusMinus[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1409"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[PlusMinus]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["PlusMinus[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1409"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1409"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][MinusPlus]",
    ButtonData:>{"MinusPlus"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1409"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Precedes", "ObjectName",
  CellTags->"S1.1410"],

Cell[TextData[{
  "\[Precedes]  \[Backslash]",
  StyleBox["[Precedes]", "MR"]
}], "CharacterName",
  CellTags->"S1.1410"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1410"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Precedes] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Precedes[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1410"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate various \
notions of partial ordering. \
\>", "Notes",
  CellTags->"S1.1410"],

Cell[TextData[{
  "\[FilledSmallSquare] Often applied to functions and read \
\[OpenCurlyDoubleQuote]",
  StyleBox["x", "TI"],
  " is dominated by ",
  StyleBox["y", "TI"],
  "\[CloseCurlyDoubleQuote]. "
}], "Notes",
  CellTags->"S1.1410"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1410"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][PrecedesEqual]",
    ButtonData:>{"PrecedesEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Succeeds]",
    ButtonData:>{"Succeeds"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotPrecedes]",
    ButtonData:>{"NotPrecedes"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1410"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PrecedesEqual", "ObjectName",
  CellTags->"S1.1411"],

Cell[TextData[{
  "\[PrecedesEqual]  \[Backslash]",
  StyleBox["[PrecedesEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1411"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1411"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[PrecedesEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["PrecedesEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1411"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1411"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][PrecedesSlantEqual]",
    ButtonData:>{"PrecedesSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][PrecedesTilde]",
    ButtonData:>{"PrecedesTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SucceedsEqual]",
    ButtonData:>{"SucceedsEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotPrecedesEqual]",
    ButtonData:>{"NotPrecedesEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1411"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PrecedesSlantEqual", "ObjectName",
  CellTags->"S1.1412"],

Cell[TextData[{
  "\[PrecedesSlantEqual]  \[Backslash]",
  StyleBox["[PrecedesSlantEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1412"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1412"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[PrecedesSlantEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["PrecedesSlantEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1412"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1412"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][PrecedesEqual]",
    ButtonData:>{"PrecedesEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SucceedsSlantEqual]",
    ButtonData:>{"SucceedsSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotPrecedesSlantEqual]",
    ButtonData:>{"NotPrecedesSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1412"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PrecedesTilde", "ObjectName",
  CellTags->"S1.1413"],

Cell[TextData[{
  "\[PrecedesTilde]  \[Backslash]",
  StyleBox["[PrecedesTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1413"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1413"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[PrecedesTilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["PrecedesTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1413"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1413"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][PrecedesEqual]",
    ButtonData:>{"PrecedesEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SucceedsTilde]",
    ButtonData:>{"SucceedsTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotPrecedesTilde]",
    ButtonData:>{"NotPrecedesTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1413"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Prime", "ObjectName",
  CellTags->"S1.1414"],

Cell[TextData[{
  "\[Prime]  \[Backslash]",
  StyleBox["[Prime]", "MR"]
}], "CharacterName",
  CellTags->"S1.1414"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1414"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1414"],

Cell["\<\
\[FilledSmallSquare] Used to indicate angles in minutes or \
distances in feet. \
\>", "Notes",
  CellTags->"S1.1414"],

Cell["\<\
\[FilledSmallSquare] Used in an overscript position as an acute \
accent. \
\>", "Notes",
  CellTags->"S1.1414"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1414"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoublePrime]",
    ButtonData:>{"DoublePrime"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReversePrime]",
    ButtonData:>{"ReversePrime"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawQuote]",
    ButtonData:>{"RawQuote"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1414"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Product", "ObjectName",
  CellTags->"S1.1415"],

Cell[TextData[{
  "\[Product]  \[Backslash]",
  StyleBox["[Product]", "MR"]
}], "CharacterName",
  CellTags->"S1.1415"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["prod\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1415"],

Cell["\<\
\[FilledSmallSquare] Compound operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1415"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Product]", 
            StyleBox["i",
              "TI"], 
            SubscriptBox[
              StyleBox["i",
                "TI"], 
              StyleBox["max",
                "TI"]],
            LimitsPositioning->False], 
          StyleBox["f",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Product[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1415"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Product]", 
            SubscriptBox[
              StyleBox[\(i = i\),
                "TI"], 
              StyleBox["min",
                "TI"]], 
            SubscriptBox[
              StyleBox["i",
                "TI"], 
              StyleBox["max",
                "TI"]],
            LimitsPositioning->False], 
          StyleBox["f",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Product[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1415"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as the Greek letter ",
  ButtonBox["\[Backslash][CapitalPi]",
    ButtonData:>{"CapitalPi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1415"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.12"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.27"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.26"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1415"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Coproduct]",
    ButtonData:>{"Coproduct"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Sum]",
    ButtonData:>{"Sum"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Times]",
    ButtonData:>{"Times"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1415"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Proportion", "ObjectName",
  CellTags->"S1.1416"],

Cell[TextData[{
  "\[Proportion]  \[Backslash]",
  StyleBox["[Proportion]", "MR"]
}], "CharacterName",
  CellTags->"S1.1416"],

Cell["\[FilledSmallSquare] Infix relational operator. ", "Notes",
  CellTags->"S1.1416"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Proportion] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Proportion[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1416"],

Cell["\<\
\[FilledSmallSquare] Used historically to indicate equality; now \
used to indicate proportion. \
\>", "Notes",
  CellTags->"S1.1416"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1416"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Divide]",
    ButtonData:>{"Divide"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Proportional]",
    ButtonData:>{"Proportional"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Colon]",
    ButtonData:>{"Colon"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Therefore]",
    ButtonData:>{"Therefore"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1416"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Proportional", "ObjectName",
  CellTags->"S1.1417"],

Cell[TextData[{
  "\[Proportional]  \[Backslash]",
  StyleBox["[Proportional]", "MR"]
}], "CharacterName",
  CellTags->"S1.1417"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["prop\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1417"],

Cell["\[FilledSmallSquare] Infix relational operator. ", "Notes",
  CellTags->"S1.1417"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Proportional] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Proportional[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1417"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Alpha]",
    ButtonData:>{"Alpha"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1417"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1417"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Proportion]",
    ButtonData:>{"Proportion"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1417"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Psi", "ObjectName",
  CellTags->"S1.1418"],

Cell[TextData[{
  "\[Psi]  \[Backslash]",
  StyleBox["[Psi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1418"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["ps\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["psi\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["y\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1418"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1418"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["PolyGamma", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1418"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1418"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalPsi]",
    ButtonData:>{"CapitalPsi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1418"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawAmpersand", "ObjectName",
  CellTags->"S1.1419"],

Cell[TextData[{
  "&  \[Backslash]",
  StyleBox["[RawAmpersand]", "MR"]
}], "CharacterName",
  CellTags->"S1.1419"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1419"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 38. \
\>", "Notes",
  CellTags->"S1.1419"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1419"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][And]",
    ButtonData:>{"And"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1419"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawAt", "ObjectName",
  CellTags->"S1.1420"],

Cell[TextData[{
  "@  \[Backslash]",
  StyleBox["[RawAt]", "MR"]
}], "CharacterName",
  CellTags->"S1.1420"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1420"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 64. \
\>", "Notes",
  CellTags->"S1.1420"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1420"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawAmpersand]",
    ButtonData:>{"RawAmpersand"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SmallCircle]",
    ButtonData:>{"SmallCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1420"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawBackquote", "ObjectName",
  CellTags->"S1.1421"],

Cell[TextData[{
  "`  \[Backslash]",
  StyleBox["[RawBackquote]", "MR"]
}], "CharacterName",
  CellTags->"S1.1421"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1421"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 96. \
\>", "Notes",
  CellTags->"S1.1421"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1421"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawQuote]",
    ButtonData:>{"RawQuote"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Prime]",
    ButtonData:>{"Prime"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1421"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawBackslash", "ObjectName",
  CellTags->"S1.1422"],

Cell[TextData[{
  "\[Backslash]  \[Backslash]",
  StyleBox["[RawBackslash]", "MR"]
}], "CharacterName",
  CellTags->"S1.1422"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1422"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 92. \
\>", "Notes",
  CellTags->"S1.1422"],

Cell["\<\
\[FilledSmallSquare] Equivalent in strings to \[Backslash]\
\[Backslash]. \
\>", "Notes",
  CellTags->"S1.1422"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1422"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Backslash]",
    ButtonData:>{"Backslash"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1422"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawColon", "ObjectName",
  CellTags->"S1.1423"],

Cell[TextData[{
  ":  \[Backslash]",
  StyleBox["[RawColon]", "MR"]
}], "CharacterName",
  CellTags->"S1.1423"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1423"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 58. \
\>", "Notes",
  CellTags->"S1.1423"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1423"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Colon]",
    ButtonData:>{"Colon"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1423"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawComma", "ObjectName",
  CellTags->"S1.1424"],

Cell[TextData[{
  ",  \[Backslash]",
  StyleBox["[RawComma]", "MR"]
}], "CharacterName",
  CellTags->"S1.1424"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1424"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 44. \
\>", "Notes",
  CellTags->"S1.1424"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1424"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][InvisibleComma]",
    ButtonData:>{"InvisibleComma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1424"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawDash", "ObjectName",
  CellTags->"S1.1425"],

Cell[TextData[{
  "-  \[Backslash]",
  StyleBox["[RawDash]", "MR"]
}], "CharacterName",
  CellTags->"S1.1425"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1425"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 45. \
\>", "Notes",
  CellTags->"S1.1425"],

Cell["\<\
\[FilledSmallSquare] As an overscript, used to indicate conjugation \
or negation. \
\>", "Notes",
  CellTags->"S1.1425"],

Cell["\<\
\[FilledSmallSquare] Also used to indicate an average value or an \
upper value. \
\>", "Notes",
  CellTags->"S1.1425"],

Cell["\<\
\[FilledSmallSquare] In geometry, used to denote a line segment. \
\
\>", "Notes",
  CellTags->"S1.1425"],

Cell["\<\
\[FilledSmallSquare] As an underscript, used to indicate a lower \
value. \
\>", "Notes",
  CellTags->"S1.1425"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      SuperscriptBox[
        StyleBox["x",
          "TI"], "-"]], "InlineFormula"],
  " is interpreted as ",
  StyleBox["SuperMinus[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1425"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      SubscriptBox[
        StyleBox["x",
          "TI"], "-"]], "InlineFormula"],
  " is interpreted as ",
  StyleBox["SubMinus[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1425"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as the letter\[Hyphen]like form ",
  ButtonBox["\[Backslash][Dash]",
    ButtonData:>{"Dash"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1425"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1425"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawPlus]",
    ButtonData:>{"RawPlus"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][HorizontalLine]",
    ButtonData:>{"HorizontalLine"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1425"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawDollar", "ObjectName",
  CellTags->"S1.1426"],

Cell[TextData[{
  "$  \[Backslash]",
  StyleBox["[RawDollar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1426"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1426"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 36. \
\>", "Notes",
  CellTags->"S1.1426"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1426"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawDot", "ObjectName",
  CellTags->"S1.1427"],

Cell[TextData[{
  ".  \[Backslash]",
  StyleBox["[RawDot]", "MR"]
}], "CharacterName",
  CellTags->"S1.1427"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1427"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 46. \
\>", "Notes",
  CellTags->"S1.1427"],

Cell["\<\
\[FilledSmallSquare] As an overscript, used to indicate time \
derivative. \
\>", "Notes",
  CellTags->"S1.1427"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      OverscriptBox[
        StyleBox["x",
          "TI"], "."]], "InlineFormula"],
  " is interpreted as ",
  StyleBox["OverDot[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1427"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1427"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CenterDot]",
    ButtonData:>{"CenterDot"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Ellipsis]",
    ButtonData:>{"Ellipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1427"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawDoubleQuote", "ObjectName",
  CellTags->"S1.1428"],

Cell[TextData[{
  "\"  \[Backslash]",
  StyleBox["[RawDoubleQuote]", "MR"]
}], "CharacterName",
  CellTags->"S1.1428"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1428"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 34. \
\>", "Notes",
  CellTags->"S1.1428"],

Cell[TextData[{
  "\[FilledSmallSquare] Equivalent to \[Backslash]",
  StyleBox["\"", "MR"],
  " in strings. "
}], "Notes",
  CellTags->"S1.1428"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1428"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawQuote]",
    ButtonData:>{"RawQuote"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Prime]",
    ButtonData:>{"Prime"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1428"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawEqual", "ObjectName",
  CellTags->"S1.1429"],

Cell[TextData[{
  "=  \[Backslash]",
  StyleBox["[RawEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1429"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1429"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 61. \
\>", "Notes",
  CellTags->"S1.1429"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1429"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Equal]",
    ButtonData:>{"Equal"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotEqual]",
    ButtonData:>{"NotEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1429"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawEscape", "ObjectName",
  CellTags->"S1.1430"],

Cell[TextData[{
  "   \[Backslash]",
  StyleBox["[RawEscape]", "MR"]
}], "CharacterName",
  CellTags->"S1.1430"],

Cell["\[FilledSmallSquare] Raw element. ", "Notes",
  CellTags->"S1.1430"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the non\[Hyphen]printable ASCII \
character with code 27. \
\>", "Notes",
  CellTags->"S1.1430"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in entering aliases for special characters in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1430"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][AliasIndicator]",
    ButtonData:>{"AliasIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EscapeKey]",
    ButtonData:>{"EscapeKey"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1430"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawExclamation", "ObjectName",
  CellTags->"S1.1431"],

Cell[TextData[{
  "!  \[Backslash]",
  StyleBox["[RawExclamation]", "MR"]
}], "CharacterName",
  CellTags->"S1.1431"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1431"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 33. \
\>", "Notes",
  CellTags->"S1.1431"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1431"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownExclamation]",
    ButtonData:>{"DownExclamation"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1431"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawGreater", "ObjectName",
  CellTags->"S1.1432"],

Cell[TextData[{
  ">  \[Backslash]",
  StyleBox["[RawGreater]", "MR"]
}], "CharacterName",
  CellTags->"S1.1432"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1432"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 62. \
\>", "Notes",
  CellTags->"S1.1432"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][RightAngleBracket]",
    ButtonData:>{"RightAngleBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1432"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1432"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotGreater]",
    ButtonData:>{"NotGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1432"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawLeftBrace", "ObjectName",
  CellTags->"S1.1433"],

Cell[TextData[{
  "{  \[Backslash]",
  StyleBox["[RawLeftBrace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1433"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1433"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 123. \
\>", "Notes",
  CellTags->"S1.1433"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1433"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1433"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawRightBrace]",
    ButtonData:>{"RawRightBrace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1433"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawLeftBracket", "ObjectName",
  CellTags->"S1.1434"],

Cell[TextData[{
  "[  \[Backslash]",
  StyleBox["[RawLeftBracket]", "MR"]
}], "CharacterName",
  CellTags->"S1.1434"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1434"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 91. \
\>", "Notes",
  CellTags->"S1.1434"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1434"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1434"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftDoubleBracket]",
    ButtonData:>{"LeftDoubleBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawRightBracket]",
    ButtonData:>{"RawRightBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightDoubleBracket]",
    ButtonData:>{"RightDoubleBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1434"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawLeftParenthesis", "ObjectName",
  CellTags->"S1.1435"],

Cell[TextData[{
  "(  \[Backslash]",
  StyleBox["[RawLeftParenthesis]", "MR"]
}], "CharacterName",
  CellTags->"S1.1435"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1435"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 40. \
\>", "Notes",
  CellTags->"S1.1435"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1435"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1435"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawRightParenthesis]",
    ButtonData:>{"RawRightParenthesis"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1435"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawLess", "ObjectName",
  CellTags->"S1.1436"],

Cell[TextData[{
  "<  \[Backslash]",
  StyleBox["[RawLess]", "MR"]
}], "CharacterName",
  CellTags->"S1.1436"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1436"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 60. \
\>", "Notes",
  CellTags->"S1.1436"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][LeftAngleBracket]",
    ButtonData:>{"LeftAngleBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1436"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1436"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotLess]",
    ButtonData:>{"NotLess"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1436"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawNumberSign", "ObjectName",
  CellTags->"S1.1437"],

Cell[TextData[{
  "#  \[Backslash]",
  StyleBox["[RawNumberSign]", "MR"]
}], "CharacterName",
  CellTags->"S1.1437"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1437"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 35. \
\>", "Notes",
  CellTags->"S1.1437"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Sharp]",
    ButtonData:>{"Sharp"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1437"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1437"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Placeholder]",
    ButtonData:>{"Placeholder"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1437"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawPercent", "ObjectName",
  CellTags->"S1.1438"],

Cell[TextData[{
  "%  \[Backslash]",
  StyleBox["[RawPercent]", "MR"]
}], "CharacterName",
  CellTags->"S1.1438"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1438"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 37. \
\>", "Notes",
  CellTags->"S1.1438"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1438"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawPlus", "ObjectName",
  CellTags->"S1.1439"],

Cell[TextData[{
  "+  \[Backslash]",
  StyleBox["[RawPlus]", "MR"]
}], "CharacterName",
  CellTags->"S1.1439"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1439"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 43. \
\>", "Notes",
  CellTags->"S1.1439"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1439"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawDash]",
    ButtonData:>{"RawDash"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1439"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawQuestion", "ObjectName",
  CellTags->"S1.1440"],

Cell[TextData[{
  "?  \[Backslash]",
  StyleBox["[RawQuestion]", "MR"]
}], "CharacterName",
  CellTags->"S1.1440"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1440"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 63. \
\>", "Notes",
  CellTags->"S1.1440"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1440"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownQuestion]",
    ButtonData:>{"DownQuestion"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1440"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawQuote", "ObjectName",
  CellTags->"S1.1441"],

Cell[TextData[{
  "'  \[Backslash]",
  StyleBox["[RawQuote]", "MR"]
}], "CharacterName",
  CellTags->"S1.1441"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1441"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 39. \
\>", "Notes",
  CellTags->"S1.1441"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1441"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Prime]",
    ButtonData:>{"Prime"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawDoubleQuote]",
    ButtonData:>{"RawDoubleQuote"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1441"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawReturn", "ObjectName",
  CellTags->"S1.1442"],

Cell[TextData[{
  "\n  \[Backslash]",
  StyleBox["[RawReturn]", "MR"]
}], "CharacterName",
  CellTags->"S1.1442"],

Cell["\[FilledSmallSquare] Spacing character. ", "Notes",
  CellTags->"S1.1442"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 13. \
\>", "Notes",
  CellTags->"S1.1442"],

Cell[TextData[{
  "\[FilledSmallSquare] Can be entered as \[Backslash]",
  StyleBox["r", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1442"],

Cell[TextData[{
  "\[FilledSmallSquare] Not always the same as ",
  ButtonBox["\[Backslash][NewLine]",
    ButtonData:>{"NewLine"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1442"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1442"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ReturnIndicator]",
    ButtonData:>{"ReturnIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  "."
}], "Notes",
  CellTags->"S1.1442"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawRightBrace", "ObjectName",
  CellTags->"S1.1443"],

Cell[TextData[{
  "}  \[Backslash]",
  StyleBox["[RawRightBrace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1443"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1443"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 125. \
\>", "Notes",
  CellTags->"S1.1443"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1443"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1443"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawLeftBrace]",
    ButtonData:>{"RawLeftBrace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1443"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawRightBracket", "ObjectName",
  CellTags->"S1.1444"],

Cell[TextData[{
  "]  \[Backslash]",
  StyleBox["[RawRightBracket]", "MR"]
}], "CharacterName",
  CellTags->"S1.1444"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1444"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 93. \
\>", "Notes",
  CellTags->"S1.1444"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1444"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][RightModified]",
    ButtonData:>{"RightModified"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1444"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1444"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftDoubleBracket]",
    ButtonData:>{"LeftDoubleBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawLeftBracket]",
    ButtonData:>{"RawLeftBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightDoubleBracket]",
    ButtonData:>{"RightDoubleBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1444"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawRightParenthesis", "ObjectName",
  CellTags->"S1.1445"],

Cell[TextData[{
  ")  \[Backslash]",
  StyleBox["[RawRightParenthesis]", "MR"]
}], "CharacterName",
  CellTags->"S1.1445"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1445"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 41. \
\>", "Notes",
  CellTags->"S1.1445"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1445"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1445"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawLeftParenthesis]",
    ButtonData:>{"RawLeftParenthesis"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1445"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawSemicolon", "ObjectName",
  CellTags->"S1.1446"],

Cell[TextData[{
  ";  \[Backslash]",
  StyleBox["[RawSemicolon]", "MR"]
}], "CharacterName",
  CellTags->"S1.1446"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1446"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 59. \
\>", "Notes",
  CellTags->"S1.1446"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1446"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawSlash", "ObjectName",
  CellTags->"S1.1447"],

Cell[TextData[{
  "/  \[Backslash]",
  StyleBox["[RawSlash]", "MR"]
}], "CharacterName",
  CellTags->"S1.1447"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1447"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 47. \
\>", "Notes",
  CellTags->"S1.1447"],

Cell["\<\
\[FilledSmallSquare] Extensible character; grows by default to \
limited size. \
\>", "Notes",
  CellTags->"S1.1447"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1447"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Divide]",
    ButtonData:>{"Divide"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1447"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawSpace", "ObjectName",
  CellTags->"S1.1448"],

Cell[TextData[{
  "   \[Backslash]",
  StyleBox["[RawSpace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1448"],

Cell["\[FilledSmallSquare] Spacing character. ", "Notes",
  CellTags->"S1.1448"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 32. \
\>", "Notes",
  CellTags->"S1.1448"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.25"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1448"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NonBreakingSpace]",
    ButtonData:>{"NonBreakingSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][MediumSpace]",
    ButtonData:>{"MediumSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SpaceIndicator]",
    ButtonData:>{"SpaceIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][InvisibleSpace]",
    ButtonData:>{"InvisibleSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1448"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawStar", "ObjectName",
  CellTags->"S1.1449"],

Cell[TextData[{
  "*  \[Backslash]",
  StyleBox["[RawStar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1449"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1449"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 42. \
\>", "Notes",
  CellTags->"S1.1449"],

Cell[TextData[{
  "\[FilledSmallSquare] In addition to one\[Hyphen]dimensional uses, ",
  Cell[BoxData[
      SuperscriptBox[
        StyleBox["x",
          "TI"], "*"]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["SuperStar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1449"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      SuperscriptBox[
        StyleBox["x",
          "TI"], "*"]], "InlineFormula"],
  " is often used in mathematics to indicate a conjugate, dual, or completion \
of ",
  StyleBox["x", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1449"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1449"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Star]",
    ButtonData:>{"Star"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Times]",
    ButtonData:>{"Times"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SixPointedStar]",
    ButtonData:>{"SixPointedStar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1449"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawTab", "ObjectName",
  CellTags->"S1.1450"],

Cell[TextData[{
  "\t  \[Backslash]",
  StyleBox["[RawTab]", "MR"]
}], "CharacterName",
  CellTags->"S1.1450"],

Cell["\[FilledSmallSquare] Spacing character. ", "Notes",
  CellTags->"S1.1450"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 9. \
\>", "Notes",
  CellTags->"S1.1450"],

Cell[TextData[{
  "\[FilledSmallSquare] Can be entered in strings as \[Backslash]",
  StyleBox["t", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1450"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1450"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightArrowBar]",
    ButtonData:>{"RightArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1450"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawTilde", "ObjectName",
  CellTags->"S1.1451"],

Cell[TextData[{
  "~  \[Backslash]",
  StyleBox["[RawTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1451"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1451"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 126. \
\>", "Notes",
  CellTags->"S1.1451"],

Cell[TextData[{
  "\[FilledSmallSquare] In addition to one\[Hyphen]dimensional uses, ",
  Cell[BoxData[
      OverscriptBox[
        StyleBox["x",
          "TI"], "~"]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["OverTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1451"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1451"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Tilde]",
    ButtonData:>{"Tilde"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotTilde]",
    ButtonData:>{"NotTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1451"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawUnderscore", "ObjectName",
  CellTags->"S1.1452"],

Cell[TextData[{
  "_  \[Backslash]",
  StyleBox["[RawUnderscore]", "MR"]
}], "CharacterName",
  CellTags->"S1.1452"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1452"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 95. \
\>", "Notes",
  CellTags->"S1.1452"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      OverscriptBox[
        StyleBox["x",
          "TI"], "_"]], "InlineFormula"],
  " is interpreted as ",
  StyleBox["OverBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1452"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      UnderscriptBox[
        StyleBox["x",
          "TI"], "_"]], "InlineFormula"],
  " is interpreted as ",
  StyleBox["UnderBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1452"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1452"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Dash]",
    ButtonData:>{"Dash"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1452"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawVerticalBar", "ObjectName",
  CellTags->"S1.1453"],

Cell[TextData[{
  "|  \[Backslash]",
  StyleBox["[RawVerticalBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1453"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1453"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 124. \
\>", "Notes",
  CellTags->"S1.1453"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1453"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1453"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][VerticalBar]",
    ButtonData:>{"VerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftBracketingBar]",
    ButtonData:>{"LeftBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1453"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RawWedge", "ObjectName",
  CellTags->"S1.1454"],

Cell[TextData[{
  "^  \[Backslash]",
  StyleBox["[RawWedge]", "MR"]
}], "CharacterName",
  CellTags->"S1.1454"],

Cell["\[FilledSmallSquare] Raw operator. ", "Notes",
  CellTags->"S1.1454"],

Cell["\<\
\[FilledSmallSquare] Equivalent to the ordinary ASCII character \
with code 94. \
\>", "Notes",
  CellTags->"S1.1454"],

Cell[TextData[{
  "\[FilledSmallSquare] In addition to one\[Hyphen]dimensional uses, ",
  Cell[BoxData[
      OverscriptBox[
        StyleBox["x",
          "TI"], "^"]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["OverHat[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1454"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      OverscriptBox[
        StyleBox["x",
          "TI"], "^"]], "InlineFormula"],
  " is used for many purposes in mathematics, from indicating an operator \
form of ",
  StyleBox["x", "TI"],
  " to indicating that ",
  StyleBox["x", "TI"],
  " is an angle. "
}], "Notes",
  CellTags->"S1.1454"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1454"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Wedge]",
    ButtonData:>{"Wedge"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1454"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RegisteredTrademark", "ObjectName",
  CellTags->"S1.1455"],

Cell[TextData[{
  "\[RegisteredTrademark]  \[Backslash]",
  StyleBox["[RegisteredTrademark]", "MR"]
}], "CharacterName",
  CellTags->"S1.1455"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["rtm\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1455"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1455"],

Cell[TextData[{
  "\[FilledSmallSquare] Used as a superscript to indicate a registered \
trademark such as ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1455"],

Cell["\<\
\[FilledSmallSquare] Typically used only on the first occurrence of \
a trademark in a document. \
\>", "Notes",
  CellTags->"S1.1455"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1455"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Trademark]",
    ButtonData:>{"Trademark"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Copyright]",
    ButtonData:>{"Copyright"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1455"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReturnIndicator", "ObjectName",
  CellTags->"S1.1456"],

Cell[TextData[{
  "\[ReturnIndicator]  \[Backslash]",
  StyleBox["[ReturnIndicator]", "MR"]
}], "CharacterName",
  CellTags->"S1.1456"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["ret\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1456"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1456"],

Cell["\<\
\[FilledSmallSquare] Representation of the return or newline \
character on a keyboard. \
\>", "Notes",
  CellTags->"S1.1456"],

Cell["\<\
\[FilledSmallSquare] Used in showing how textual input is typed. \
\
\>", "Notes",
  CellTags->"S1.1456"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1456"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ReturnKey]",
    ButtonData:>{"ReturnKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EnterKey]",
    ButtonData:>{"EnterKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Continuation]",
    ButtonData:>{"Continuation"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ControlKey]",
    ButtonData:>{"ControlKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CommandKey]",
    ButtonData:>{"CommandKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SpaceIndicator]",
    ButtonData:>{"SpaceIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NonBreakingSpace]",
    ButtonData:>{"NonBreakingSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1456"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReturnKey", "ObjectName",
  CellTags->"S1.1457"],

Cell[TextData[{
  "\[ReturnKey]  \[Backslash]",
  StyleBox["[ReturnKey]", "MR"]
}], "CharacterName",
  CellTags->"S1.1457"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  StyleBox["ret\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1457"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1457"],

Cell["\<\
\[FilledSmallSquare] Representation of the Return key on a \
keyboard. \
\>", "Notes",
  CellTags->"S1.1457"],

Cell["\<\
\[FilledSmallSquare] Used in describing how to type textual input. \
\
\>", "Notes",
  CellTags->"S1.1457"],

Cell[TextData[{
  "\[FilledSmallSquare] \[AliasIndicator]",
  StyleBox["ret\[AliasIndicator]", "MR"],
  " is the alias for ",
  ButtonBox["\[Backslash][ReturnIndicator]",
    ButtonData:>{"ReturnIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ". The alias for \[Backslash]",
  StyleBox["[ReturnKey]", "MR"],
  " has a space at the beginning. "
}], "Notes",
  CellTags->"S1.1457"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1457"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][EnterKey]",
    ButtonData:>{"EnterKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReturnIndicator]",
    ButtonData:>{"ReturnIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ControlKey]",
    ButtonData:>{"ControlKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CommandKey]",
    ButtonData:>{"CommandKey"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1457"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReverseDoublePrime", "ObjectName",
  CellTags->"S1.1458"],

Cell[TextData[{
  "\[ReverseDoublePrime]  \[Backslash]",
  StyleBox["[ReverseDoublePrime]", "MR"]
}], "CharacterName",
  CellTags->"S1.1458"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["``\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1458"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1458"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1458"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoublePrime]",
    ButtonData:>{"DoublePrime"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Prime]",
    ButtonData:>{"Prime"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReversePrime]",
    ButtonData:>{"ReversePrime"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1458"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReverseElement", "ObjectName",
  CellTags->"S1.1459"],

Cell[TextData[{
  "\[ReverseElement]  \[Backslash]",
  StyleBox["[ReverseElement]", "MR"]
}], "CharacterName",
  CellTags->"S1.1459"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["mem\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1459"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1459"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[ReverseElement] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["ReverseElement[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1459"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][SuchThat]",
    ButtonData:>{"SuchThat"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1459"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1459"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Element]",
    ButtonData:>{"Element"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotReverseElement]",
    ButtonData:>{"NotReverseElement"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1459"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReverseEquilibrium", "ObjectName",
  CellTags->"S1.1460"],

Cell[TextData[{
  "\[ReverseEquilibrium]  \[Backslash]",
  StyleBox["[ReverseEquilibrium]", "MR"]
}], "CharacterName",
  CellTags->"S1.1460"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1460"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[ReverseEquilibrium] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["ReverseEquilibrium[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1460"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1460"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1460"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Equilibrium]",
    ButtonData:>{"Equilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReverseUpEquilibrium]",
    ButtonData:>{"ReverseUpEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrowRightArrow]",
    ButtonData:>{"LeftArrowRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftRightArrow]",
    ButtonData:>{"LeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1460"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReversePrime", "ObjectName",
  CellTags->"S1.1461"],

Cell[TextData[{
  "\[ReversePrime]  \[Backslash]",
  StyleBox["[ReversePrime]", "MR"]
}], "CharacterName",
  CellTags->"S1.1461"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["`\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1461"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1461"],

Cell["\<\
\[FilledSmallSquare] Used in an overscript position as a grave \
accent. \
\>", "Notes",
  CellTags->"S1.1461"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1461"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoublePrime]",
    ButtonData:>{"DoublePrime"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Prime]",
    ButtonData:>{"Prime"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReverseDoublePrime]",
    ButtonData:>{"ReverseDoublePrime"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawBackquote]",
    ButtonData:>{"RawBackquote"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1461"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReverseUpEquilibrium", "ObjectName",
  CellTags->"S1.1462"],

Cell[TextData[{
  "\[ReverseUpEquilibrium]  \[Backslash]",
  StyleBox["[ReverseUpEquilibrium]", "MR"]
}], "CharacterName",
  CellTags->"S1.1462"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1462"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[ReverseUpEquilibrium]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["ReverseUpEquilibrium[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1462"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1462"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1462"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UpEquilibrium]",
    ButtonData:>{"UpEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownArrowUpArrow]",
    ButtonData:>{"DownArrowUpArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightUpDownVector]",
    ButtonData:>{"RightUpDownVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Equilibrium]",
    ButtonData:>{"Equilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1462"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rho", "ObjectName",
  CellTags->"S1.1463"],

Cell[TextData[{
  "\[Rho]  \[Backslash]",
  StyleBox["[Rho]", "MR"]
}], "CharacterName",
  CellTags->"S1.1463"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["r\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["rho\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1463"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1463"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1463"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CurlyRho]",
    ButtonData:>{"CurlyRho"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalRho]",
    ButtonData:>{"CapitalRho"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1463"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightAngle", "ObjectName",
  CellTags->"S1.1464"],

Cell[TextData[{
  "\[RightAngle]  \[Backslash]",
  StyleBox["[RightAngle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1464"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1464"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in geometry to indicate a right angle, as in the \
symbol ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightAngle]\)], "InlineFormula"],
  " ",
  StyleBox["ABC", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1464"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.31"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1464"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Angle]",
    ButtonData:>{"Angle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][MeasuredAngle]",
    ButtonData:>{"MeasuredAngle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpTee]",
    ButtonData:>{"UpTee"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1464"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightAngleBracket", "ObjectName",
  CellTags->"S1.1465"],

Cell[TextData[{
  "\[RightAngleBracket]  \[Backslash]",
  StyleBox["[RightAngleBracket]", "MR"]
}], "CharacterName",
  CellTags->"S1.1465"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox[">\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1465"],

Cell["\[FilledSmallSquare] Matchfix operator. ", "Notes",
  CellTags->"S1.1465"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightAngleBracket]\)], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["AngleBracket[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1465"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in the form ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
  StyleBox["x", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[RightAngleBracket]\)], "InlineFormula"],
  " to indicate expected or average value. "
}], "Notes",
  CellTags->"S1.1465"],

Cell["\<\
\[FilledSmallSquare] Called ket in quantum mechanics. \
\>", "Notes",
  CellTags->"S1.1465"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in the form ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[RightAngleBracket]\)], "InlineFormula"],
  " to indicate various forms of inner product. "
}], "Notes",
  CellTags->"S1.1465"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in the form ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightAngleBracket]\)], "InlineFormula"],
  " to denote an ordered set of objects. "
}], "Notes",
  CellTags->"S1.1465"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][RawGreater]",
    ButtonData:>{"RawGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1465"],

Cell["\<\
\[FilledSmallSquare] Extensible character; grows by default to \
limited size. \
\>", "Notes",
  CellTags->"S1.1465"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1465"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftAngleBracket]",
    ButtonData:>{"LeftAngleBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1465"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightArrow", "ObjectName",
  CellTags->"S1.1466"],

Cell[TextData[{
  "\[RightArrow]  \[Backslash]",
  StyleBox["[RightArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1466"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  StyleBox["->\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1466"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1466"],

Cell["\<\
\[FilledSmallSquare] Used for many purposes in mathematics to \
indicate transformation, tending to a limit or implication. \
\>", "Notes",
  CellTags->"S1.1466"],

Cell["\<\
\[FilledSmallSquare] Used as an overscript to indicate a directed \
object. \
\>", "Notes",
  CellTags->"S1.1466"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Rule]",
    ButtonData:>{"Rule"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1466"],

Cell[TextData[{
  "\[FilledSmallSquare] \[AliasIndicator]",
  StyleBox["->\[AliasIndicator]", "MR"],
  " is the alias for ",
  ButtonBox["\[Backslash][Rule]",
    ButtonData:>{"Rule"},
    ButtonStyle->"MainBookLinkMR"],
  ". The alias for \[Backslash]",
  StyleBox["[RightArrow]", "MR"],
  " has a space at the beginning. "
}], "Notes",
  CellTags->"S1.1466"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1466"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1466"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LongRightArrow]",
    ButtonData:>{"LongRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ShortRightArrow]",
    ButtonData:>{"ShortRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleRightArrow]",
    ButtonData:>{"DoubleRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTeeArrow]",
    ButtonData:>{"RightTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrowBar]",
    ButtonData:>{"RightArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpperRightArrow]",
    ButtonData:>{"UpperRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightVector]",
    ButtonData:>{"RightVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangle]",
    ButtonData:>{"RightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrow]",
    ButtonData:>{"LeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][HorizontalLine]",
    ButtonData:>{"HorizontalLine"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Implies]",
    ButtonData:>{"Implies"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1466"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightArrowBar", "ObjectName",
  CellTags->"S1.1467"],

Cell[TextData[{
  "\[RightArrowBar]  \[Backslash]",
  StyleBox["[RightArrowBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1467"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1467"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrowBar] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightArrowBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1467"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate an \
epimorphism. \
\>", "Notes",
  CellTags->"S1.1467"],

Cell["\<\
\[FilledSmallSquare] Sometimes used to indicate a tab. \
\>", \
"Notes",
  CellTags->"S1.1467"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1467"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1467"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightTeeArrow]",
    ButtonData:>{"RightTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightVectorBar]",
    ButtonData:>{"RightVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrowBar]",
    ButtonData:>{"UpArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrowBar]",
    ButtonData:>{"LeftArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawTab]",
    ButtonData:>{"RawTab"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1467"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightArrowLeftArrow", "ObjectName",
  CellTags->"S1.1468"],

Cell[TextData[{
  "\[RightArrowLeftArrow]  \[Backslash]",
  StyleBox["[RightArrowLeftArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1468"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1468"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrowLeftArrow] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightArrowLeftArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1468"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1468"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1468"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftArrowRightArrow]",
    ButtonData:>{"LeftArrowRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftRightArrow]",
    ButtonData:>{"LeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleLeftRightArrow]",
    ButtonData:>{"DoubleLeftRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Equilibrium]",
    ButtonData:>{"Equilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrowDownArrow]",
    ButtonData:>{"UpArrowDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1468"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightBracketingBar", "ObjectName",
  CellTags->"S1.1469"],

Cell[TextData[{
  "\[RightBracketingBar]  \[Backslash]",
  StyleBox["[RightBracketingBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1469"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["r|\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1469"],

Cell["\[FilledSmallSquare] Matchfix operator. ", "Notes",
  CellTags->"S1.1469"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftBracketingBar]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightBracketingBar]\)], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["BracketingBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1469"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in mathematics to indicate absolute value (",
  StyleBox["Abs", "MR"],
  "), determinant (",
  StyleBox["Det", "MR"],
  "), and other notions of evaluating size or magnitude. "
}], "Notes",
  CellTags->"S1.1469"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][VerticalBar]",
    ButtonData:>{"VerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1469"],

Cell["\<\
\[FilledSmallSquare] Drawn in monospaced fonts with a small right\
\[Hyphen]pointing tee to indicate direction. \
\>", "Notes",
  CellTags->"S1.1469"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1469"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1469"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightDoubleBracketingBar]",
    ButtonData:>{"RightDoubleBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTee]",
    ButtonData:>{"RightTee"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1469"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightCeiling", "ObjectName",
  CellTags->"S1.1470"],

Cell[TextData[{
  "\[RightCeiling]  \[Backslash]",
  StyleBox["[RightCeiling]", "MR"]
}], "CharacterName",
  CellTags->"S1.1470"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["rc\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1470"],

Cell["\<\
\[FilledSmallSquare] Matchfix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1470"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftCeiling]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightCeiling]\)], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Ceiling[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1470"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1470"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1470"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftCeiling]",
    ButtonData:>{"LeftCeiling"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightFloor]",
    ButtonData:>{"RightFloor"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1470"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightDoubleBracket", "ObjectName",
  CellTags->"S1.1471"],

Cell[TextData[{
  "\[RightDoubleBracket]  \[Backslash]",
  StyleBox["[RightDoubleBracket]", "MR"]
}], "CharacterName",
  CellTags->"S1.1471"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["]]\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1471"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["m", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracket]\)], "InlineFormula"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  StyleBox["j", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightDoubleBracket]\)], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Part[", "MR"],
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["j", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1471"],

Cell["\<\
\[FilledSmallSquare] Extensible character; grows by default to \
limited size. \
\>", "Notes",
  CellTags->"S1.1471"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1471"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawRightBracket]",
    ButtonData:>{"RawRightBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightDoubleBracketingBar]",
    ButtonData:>{"RightDoubleBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1471"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightDoubleBracketingBar", "ObjectName",
  CellTags->"S1.1472"],

Cell[TextData[{
  "\[RightDoubleBracketingBar]  \[Backslash]",
  StyleBox["[RightDoubleBracketingBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1472"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["r||\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1472"],

Cell["\[FilledSmallSquare] Matchfix operator. ", "Notes",
  CellTags->"S1.1472"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightDoubleBracketingBar]\)], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["DoubleBracketingBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1472"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate taking a norm. \
\
\>", "Notes",
  CellTags->"S1.1472"],

Cell["\<\
\[FilledSmallSquare] Sometimes used for determinant. \
\>", "Notes",
  CellTags->"S1.1472"],

Cell["\<\
\[FilledSmallSquare] Sometimes used to indicate a matrix. \
\>", \
"Notes",
  CellTags->"S1.1472"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][DoubleVerticalBar]",
    ButtonData:>{"DoubleVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1472"],

Cell["\<\
\[FilledSmallSquare] Drawn in monospaced fonts with a small right\
\[Hyphen]pointing tee to indicate direction. \
\>", "Notes",
  CellTags->"S1.1472"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1472"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1472"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightBracketingBar]",
    ButtonData:>{"RightBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1472"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightDownTeeVector", "ObjectName",
  CellTags->"S1.1473"],

Cell[TextData[{
  "\[RightDownTeeVector]  \[Backslash]",
  StyleBox["[RightDownTeeVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1473"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1473"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightDownTeeVector]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightDownTeeVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1473"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1473"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1473"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftDownTeeVector]",
    ButtonData:>{"LeftDownTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightDownVectorBar]",
    ButtonData:>{"RightDownVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownTeeArrow]",
    ButtonData:>{"DownTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightUpTeeVector]",
    ButtonData:>{"RightUpTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1473"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightDownVector", "ObjectName",
  CellTags->"S1.1474"],

Cell[TextData[{
  "\[RightDownVector]  \[Backslash]",
  StyleBox["[RightDownVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1474"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1474"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightDownVector]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightDownVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1474"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1474"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1474"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftDownVector]",
    ButtonData:>{"LeftDownVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightDownTeeVector]",
    ButtonData:>{"RightDownTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownArrow]",
    ButtonData:>{"DownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpEquilibrium]",
    ButtonData:>{"UpEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightUpVector]",
    ButtonData:>{"RightUpVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1474"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightDownVectorBar", "ObjectName",
  CellTags->"S1.1475"],

Cell[TextData[{
  "\[RightDownVectorBar]  \[Backslash]",
  StyleBox["[RightDownVectorBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1475"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1475"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightDownVectorBar]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightDownVectorBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1475"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1475"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1475"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftDownVectorBar]",
    ButtonData:>{"LeftDownVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightDownTeeVector]",
    ButtonData:>{"RightDownTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownArrowBar]",
    ButtonData:>{"DownArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightUpVectorBar]",
    ButtonData:>{"RightUpVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1475"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightFloor", "ObjectName",
  CellTags->"S1.1476"],

Cell[TextData[{
  "\[RightFloor]  \[Backslash]",
  StyleBox["[RightFloor]", "MR"]
}], "CharacterName",
  CellTags->"S1.1476"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["rf\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1476"],

Cell["\<\
\[FilledSmallSquare] Matchfix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1476"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftFloor]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightFloor]\)], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Floor[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1476"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1476"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1476"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftFloor]",
    ButtonData:>{"LeftFloor"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightCeiling]",
    ButtonData:>{"RightCeiling"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1476"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightGuillemet", "ObjectName",
  CellTags->"S1.1477"],

Cell[TextData[{
  "\[RightGuillemet]  \[Backslash]",
  StyleBox["[RightGuillemet]", "MR"]
}], "CharacterName",
  CellTags->"S1.1477"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["g>>\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1477"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1477"],

Cell["\<\
\[FilledSmallSquare] Used as closing quotation marks in languages \
such as Spanish. \
\>", "Notes",
  CellTags->"S1.1477"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][GreaterGreater]",
    ButtonData:>{"GreaterGreater"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1477"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][RightSkeleton]",
    ButtonData:>{"RightSkeleton"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1477"],

Cell["\<\
\[FilledSmallSquare] Guillemet is sometimes misspelled as \
guillemot. \
\>", "Notes",
  CellTags->"S1.1477"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1477"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftGuillemet]",
    ButtonData:>{"LeftGuillemet"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1477"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightModified", "ObjectName",
  CellTags->"S1.1478"],

Cell[TextData[{
  "\[RightModified]  \[Backslash]",
  StyleBox["[RightModified]", "MR"]
}], "CharacterName",
  CellTags->"S1.1478"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["]\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1478"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1478"],

Cell["\<\
\[FilledSmallSquare] Used in documenting control and command \
characters. \
\>", "Notes",
  CellTags->"S1.1478"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["key", "TI"],
  "\[Backslash]",
  StyleBox["[LeftModified]", "MR"],
  StyleBox["char", "TI"],
  "\[Backslash]",
  StyleBox["[RightModified]", "MR"],
  " is used to indicate that ",
  StyleBox["char", "TI"],
  " should be typed while ",
  StyleBox["key", "TI"],
  " is being pressed. "
}], "Notes",
  CellTags->"S1.1478"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][RawRightBracket]",
    ButtonData:>{"RawRightBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1478"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1478"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ControlKey]",
    ButtonData:>{"ControlKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CommandKey]",
    ButtonData:>{"CommandKey"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftModified]",
    ButtonData:>{"LeftModified"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1478"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightSkeleton", "ObjectName",
  CellTags->"S1.1479"],

Cell[TextData[{
  "\[RightSkeleton]  \[Backslash]",
  StyleBox["[RightSkeleton]", "MR"]
}], "CharacterName",
  CellTags->"S1.1479"],

Cell["\[FilledSmallSquare] Uninterpretable element. ", "Notes",
  CellTags->"S1.1479"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftSkeleton]\)], "InlineFormula"],
  " ",
  StyleBox["n", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightSkeleton]\)], "InlineFormula"],
  " is used on output to indicate ",
  StyleBox["n", "TI"],
  " omitted pieces in an expression obtained from ",
  StyleBox["Short", "MR"],
  " or ",
  StyleBox["Shallow", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1479"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[RightSkeleton]", "MR"],
  " indicates the presence of missing information, and so by default \
generates an error if you try to interpret it. "
}], "Notes",
  CellTags->"S1.1479"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][RightGuillemet]",
    ButtonData:>{"RightGuillemet"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1479"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1479"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftSkeleton]",
    ButtonData:>{"LeftSkeleton"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SkeletonIndicator]",
    ButtonData:>{"SkeletonIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Ellipsis]",
    ButtonData:>{"Ellipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1479"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightTee", "ObjectName",
  CellTags->"S1.1480"],

Cell[TextData[{
  "\[RightTee]  \[Backslash]",
  StyleBox["[RightTee]", "MR"]
}], "CharacterName",
  CellTags->"S1.1480"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["rT\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1480"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1480"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightTee] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightTee[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1480"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightTee] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightTee] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  " groups as ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightTee] \)], "InlineFormula"],
  " ",
  StyleBox["(", "MR"],
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightTee] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[")", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1480"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate logical \
implication or proof. \
\>", "Notes",
  CellTags->"S1.1480"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1480"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DoubleRightTee]",
    ButtonData:>{"DoubleRightTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTeeArrow]",
    ButtonData:>{"RightTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTeeVector]",
    ButtonData:>{"RightTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTee]",
    ButtonData:>{"LeftTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownTee]",
    ButtonData:>{"DownTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightBracketingBar]",
    ButtonData:>{"RightBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1480"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightTeeArrow", "ObjectName",
  CellTags->"S1.1481"],

Cell[TextData[{
  "\[RightTeeArrow]  \[Backslash]",
  StyleBox["[RightTeeArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1481"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1481"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightTeeArrow] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightTeeArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1481"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate a \
transformation, often the action of a mapping on a specific element in a \
space. \
\>", "Notes",
  CellTags->"S1.1481"],

Cell["\<\
\[FilledSmallSquare] Also used in logic to indicate deducibility. \
\
\>", "Notes",
  CellTags->"S1.1481"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1481"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1481"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightTeeVector]",
    ButtonData:>{"RightTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTee]",
    ButtonData:>{"RightTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTeeArrow]",
    ButtonData:>{"LeftTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpTeeArrow]",
    ButtonData:>{"UpTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1481"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightTeeVector", "ObjectName",
  CellTags->"S1.1482"],

Cell[TextData[{
  "\[RightTeeVector]  \[Backslash]",
  StyleBox["[RightTeeVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1482"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1482"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightTeeVector] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightTeeVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1482"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1482"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1482"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownRightTeeVector]",
    ButtonData:>{"DownRightTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightVectorBar]",
    ButtonData:>{"RightVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightVector]",
    ButtonData:>{"RightVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTeeArrow]",
    ButtonData:>{"RightTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1482"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightTriangle", "ObjectName",
  CellTags->"S1.1483"],

Cell[TextData[{
  "\[RightTriangle]  \[Backslash]",
  StyleBox["[RightTriangle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1483"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1483"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightTriangle] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightTriangle[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1483"],

Cell["\<\
\[FilledSmallSquare] Used in pure mathematics to mean \
\[OpenCurlyDoubleQuote]contains as a normal subgroup\[CloseCurlyDoubleQuote]. \
\
\>", "Notes",
  CellTags->"S1.1483"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1483"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightTriangleEqual]",
    ButtonData:>{"RightTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangleBar]",
    ButtonData:>{"RightTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotRightTriangle]",
    ButtonData:>{"NotRightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTriangle]",
    ButtonData:>{"LeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][EmptyUpTriangle]",
    ButtonData:>{"EmptyUpTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledUpTriangle]",
    ButtonData:>{"FilledUpTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightAngle]",
    ButtonData:>{"RightAngle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1483"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightTriangleBar", "ObjectName",
  CellTags->"S1.1484"],

Cell[TextData[{
  "\[RightTriangleBar]  \[Backslash]",
  StyleBox["[RightTriangleBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1484"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1484"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightTriangleBar] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightTriangleBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1484"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1484"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightTriangle]",
    ButtonData:>{"RightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangleEqual]",
    ButtonData:>{"RightTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrowBar]",
    ButtonData:>{"RightArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotRightTriangleBar]",
    ButtonData:>{"NotRightTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1484"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightTriangleEqual", "ObjectName",
  CellTags->"S1.1485"],

Cell[TextData[{
  "\[RightTriangleEqual]  \[Backslash]",
  StyleBox["[RightTriangleEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1485"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1485"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightTriangleEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightTriangleEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1485"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1485"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightTriangle]",
    ButtonData:>{"RightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangleBar]",
    ButtonData:>{"RightTriangleBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SucceedsEqual]",
    ButtonData:>{"SucceedsEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotRightTriangleEqual]",
    ButtonData:>{"NotRightTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTriangleEqual]",
    ButtonData:>{"LeftTriangleEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1485"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightUpDownVector", "ObjectName",
  CellTags->"S1.1486"],

Cell[TextData[{
  "\[RightUpDownVector]  \[Backslash]",
  StyleBox["[RightUpDownVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1486"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1486"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightUpDownVector]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightUpDownVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1486"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1486"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1486"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftUpDownVector]",
    ButtonData:>{"LeftUpDownVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpEquilibrium]",
    ButtonData:>{"UpEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrowDownArrow]",
    ButtonData:>{"UpArrowDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftRightVector]",
    ButtonData:>{"LeftRightVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1486"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightUpTeeVector", "ObjectName",
  CellTags->"S1.1487"],

Cell[TextData[{
  "\[RightUpTeeVector]  \[Backslash]",
  StyleBox["[RightUpTeeVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1487"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1487"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightUpTeeVector]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightUpTeeVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1487"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1487"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1487"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftUpTeeVector]",
    ButtonData:>{"LeftUpTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightUpVectorBar]",
    ButtonData:>{"RightUpVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpTeeArrow]",
    ButtonData:>{"UpTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightDownTeeVector]",
    ButtonData:>{"RightDownTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1487"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightUpVector", "ObjectName",
  CellTags->"S1.1488"],

Cell[TextData[{
  "\[RightUpVector]  \[Backslash]",
  StyleBox["[RightUpVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1488"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1488"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightUpVector]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightUpVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1488"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in pure mathematics to indicate the restriction \
of ",
  StyleBox["x", "TI"],
  " to ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1488"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1488"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1488"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftUpVector]",
    ButtonData:>{"LeftUpVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightUpTeeVector]",
    ButtonData:>{"RightUpTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrow]",
    ButtonData:>{"UpArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpEquilibrium]",
    ButtonData:>{"UpEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightDownVector]",
    ButtonData:>{"RightDownVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1488"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightUpVectorBar", "ObjectName",
  CellTags->"S1.1489"],

Cell[TextData[{
  "\[RightUpVectorBar]  \[Backslash]",
  StyleBox["[RightUpVectorBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1489"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1489"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightUpVectorBar]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightUpVectorBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1489"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1489"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1489"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftUpVectorBar]",
    ButtonData:>{"LeftUpVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightUpTeeVector]",
    ButtonData:>{"RightUpTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrowBar]",
    ButtonData:>{"UpArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightDownVectorBar]",
    ButtonData:>{"RightDownVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1489"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightVector", "ObjectName",
  CellTags->"S1.1490"],

Cell[TextData[{
  "\[RightVector]  \[Backslash]",
  StyleBox["[RightVector]", "MR"]
}], "CharacterName",
  CellTags->"S1.1490"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["vec\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1490"],

Cell["\<\
\[FilledSmallSquare] Infix and overfix arrow\[Hyphen]like operator. \
\
\>", "Notes",
  CellTags->"S1.1490"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightVector] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1490"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate weak \
convergence. \
\>", "Notes",
  CellTags->"S1.1490"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      OverscriptBox[
        StyleBox["x",
          "TI"], "\[RightVector]"]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["OverVector[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1490"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate a vector \
quantity. \
\>", "Notes",
  CellTags->"S1.1490"],

Cell["\<\
\[FilledSmallSquare] Sometimes used in prefix form as a \
typographical symbol to stand for \[OpenCurlyDoubleQuote]see also\
\[CloseCurlyDoubleQuote]. \
\>", "Notes",
  CellTags->"S1.1490"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1490"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1490"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownRightVector]",
    ButtonData:>{"DownRightVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTeeVector]",
    ButtonData:>{"RightTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightVectorBar]",
    ButtonData:>{"RightVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftVector]",
    ButtonData:>{"LeftVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightUpVector]",
    ButtonData:>{"RightUpVector"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1490"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RightVectorBar", "ObjectName",
  CellTags->"S1.1491"],

Cell[TextData[{
  "\[RightVectorBar]  \[Backslash]",
  StyleBox["[RightVectorBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1491"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1491"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightVectorBar]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["RightVectorBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1491"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1491"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1491"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownRightVectorBar]",
    ButtonData:>{"DownRightVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTeeVector]",
    ButtonData:>{"RightTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrowBar]",
    ButtonData:>{"RightArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1491"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RoundImplies", "ObjectName",
  CellTags->"S1.1492"],

Cell[TextData[{
  "\[RoundImplies]  \[Backslash]",
  StyleBox["[RoundImplies]", "MR"]
}], "CharacterName",
  CellTags->"S1.1492"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1492"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RoundImplies] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Implies[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1492"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RoundImplies] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RoundImplies] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  " groups as ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RoundImplies] \)], "InlineFormula"],
  " ",
  StyleBox["(", "MR"],
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RoundImplies] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[")", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1492"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Superset]",
    ButtonData:>{"Superset"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1492"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1492"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Implies]",
    ButtonData:>{"Implies"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SuchThat]",
    ButtonData:>{"SuchThat"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Rule]",
    ButtonData:>{"Rule"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1492"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RoundSpaceIndicator", "ObjectName",
  CellTags->"S1.1493"],

Cell[TextData[{
  "\[RoundSpaceIndicator]  \[Backslash]",
  StyleBox["[RoundSpaceIndicator]", "MR"]
}], "CharacterName",
  CellTags->"S1.1493"],

Cell["\[FilledSmallSquare] Spacing character. ", "Notes",
  CellTags->"S1.1493"],

Cell[TextData[{
  "\[FilledSmallSquare] Interpreted by default as equivalent to ",
  ButtonBox["\[Backslash][RawSpace]",
    ButtonData:>{"RawSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1493"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1493"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][SpaceIndicator]",
    ButtonData:>{"SpaceIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Cup]",
    ButtonData:>{"Cup"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Breve]",
    ButtonData:>{"Breve"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1493"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rule", "ObjectName",
  CellTags->"S1.1494"],

Cell[TextData[{
  "\[Rule]  \[Backslash]",
  StyleBox["[Rule]", "MR"]
}], "CharacterName",
  CellTags->"S1.1494"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["->\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1494"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1494"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["y", "TI"],
  " or ",
  StyleBox["Rule[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1494"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  " groups as ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
  " ",
  StyleBox["(", "MR"],
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[")", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1494"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[Rule]", "MR"],
  " is not the same as ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1494"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1494"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RuleDelayed]",
    ButtonData:>{"RuleDelayed"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1494"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RuleDelayed", "ObjectName",
  CellTags->"S1.1495"],

Cell[TextData[{
  "\[RuleDelayed]  \[Backslash]",
  StyleBox["[RuleDelayed]", "MR"]
}], "CharacterName",
  CellTags->"S1.1495"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox[":>\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1495"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1495"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RuleDelayed] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["x", "TI"],
  " ",
  StyleBox[":>", "MR"],
  " ",
  StyleBox["y", "TI"],
  " or ",
  StyleBox["RuleDelayed[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1495"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RuleDelayed] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RuleDelayed] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  " groups as ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RuleDelayed] \)], "InlineFormula"],
  " ",
  StyleBox["(", "MR"],
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RuleDelayed] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[")", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1495"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1495"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Rule]",
    ButtonData:>{"Rule"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Colon]",
    ButtonData:>{"Colon"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1495"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SadSmiley", "ObjectName",
  CellTags->"S1.1496"],

Cell[TextData[{
  "\[SadSmiley]  \[Backslash]",
  StyleBox["[SadSmiley]", "MR"]
}], "CharacterName",
  CellTags->"S1.1496"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox[":-(\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1496"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1496"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.30"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1496"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][HappySmiley]",
    ButtonData:>{"HappySmiley"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NeutralSmiley]",
    ButtonData:>{"NeutralSmiley"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FreakedSmiley]",
    ButtonData:>{"FreakedSmiley"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1496"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sampi", "ObjectName",
  CellTags->"S1.1497"],

Cell[TextData[{
  "\[Sampi]  \[Backslash]",
  StyleBox["[Sampi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1497"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["sa\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["sampi\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1497"],

Cell["\[FilledSmallSquare] Special Greek letter. ", "Notes",
  CellTags->"S1.1497"],

Cell[TextData[{
  "\[FilledSmallSquare] Appeared after ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\)], "InlineFormula"],
  " in early Greek alphabet; used for Greek numeral 900. "
}], "Notes",
  CellTags->"S1.1497"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1497"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalSampi]",
    ButtonData:>{"CapitalSampi"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Digamma]",
    ButtonData:>{"Digamma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Stigma]",
    ButtonData:>{"Stigma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Koppa]",
    ButtonData:>{"Koppa"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1497"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ScriptA \[Ellipsis] ScriptZ", "ObjectName",
  CellTags->"S1.1498"],

Cell[TextData[{
  "\[ScriptA] \[Ellipsis] \[ScriptZ]  \[Backslash]",
  StyleBox["[ScriptA]", "MR"],
  " \[Ellipsis] \[Backslash]",
  StyleBox["[ScriptZ]", "MR"]
}], "CharacterName",
  CellTags->"S1.1498"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["sca\[AliasIndicator]", "MR"],
  " through \[AliasIndicator]",
  StyleBox["scz\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1498"],

Cell["\[FilledSmallSquare] Letters. ", "Notes",
  CellTags->"S1.1498"],

Cell["\<\
\[FilledSmallSquare] Treated as distinct characters rather than \
style modifications of ordinary letters. \
\>", "Notes",
  CellTags->"S1.1498"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[ScriptL]", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptL]\)], "InlineFormula"],
  " is a commonly used form. "
}], "Notes",
  CellTags->"S1.1498"],

Cell["\<\
\[FilledSmallSquare] Contiguous character codes from the private \
Unicode character range are used, even though a few script characters are \
included in ordinary Unicode. \
\>", "Notes",
  CellTags->"S1.1498"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.19"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1498"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ScriptCapitalA]",
    ButtonData:>{"ScriptCapitalA"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][GothicA]",
    ButtonData:>{"GothicA"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleStruckA]",
    ButtonData:>{"DoubleStruckA"},
    ButtonStyle->"MainBookLinkMR"],
  ", etc. "
}], "Notes",
  CellTags->"S1.1498"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ScriptCapitalA \[Ellipsis] ScriptCapitalZ\
\>", "ObjectName",
  CellTags->"S1.1499"],

Cell[TextData[{
  "\[ScriptCapitalA] \[Ellipsis] \[ScriptCapitalZ]  \[Backslash]",
  StyleBox["[ScriptCapitalA]", "MR"],
  " \[Ellipsis] \[Backslash]",
  StyleBox["[ScriptCapitalZ]", "MR"]
}], "CharacterName",
  CellTags->"S1.1499"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["scA\[AliasIndicator]", "MR"],
  " through \[AliasIndicator]",
  StyleBox["scZ\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1499"],

Cell["\[FilledSmallSquare] Letters. ", "Notes",
  CellTags->"S1.1499"],

Cell["\<\
\[FilledSmallSquare] Treated as distinct characters rather than \
style modifications of ordinary letters. \
\>", "Notes",
  CellTags->"S1.1499"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalE]\)], "InlineFormula"],
  " is sometimes called Euler's E. "
}], "Notes",
  CellTags->"S1.1499"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[ScriptCapitalE]", "MR"],
  " is not the same as ",
  ButtonBox["\[Backslash][CurlyEpsilon]",
    ButtonData:>{"CurlyEpsilon"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1499"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalF]\)], "InlineFormula"],
  " is sometimes used to denote Fourier transform. "
}], "Notes",
  CellTags->"S1.1499"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalL]\)], "InlineFormula"],
  " is sometimes used to denote Laplace transform. "
}], "Notes",
  CellTags->"S1.1499"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalH]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalL]\)], "InlineFormula"],
  " are used in physics to denote Hamiltonian and Lagrangian density. "
}], "Notes",
  CellTags->"S1.1499"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[ScriptCapitalP]", "MR"],
  " is not the same as ",
  ButtonBox["\[Backslash][WeierstrassP]",
    ButtonData:>{"WeierstrassP"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1499"],

Cell["\<\
\[FilledSmallSquare] Contiguous character codes from the private \
Unicode character range are used, even though a few capital script characters \
are included in ordinary Unicode. \
\>", "Notes",
  CellTags->"S1.1499"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.19"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1499"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][GothicCapitalA]",
    ButtonData:>{"GothicCapitalA"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleStruckCapitalA]",
    ButtonData:>{"DoubleStruckCapitalA"},
    ButtonStyle->"MainBookLinkMR"],
  ", etc. "
}], "Notes",
  CellTags->"S1.1499"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Section", "ObjectName",
  CellTags->"S1.1500"],

Cell[TextData[{
  "\[Section]  \[Backslash]",
  StyleBox["[Section]", "MR"]
}], "CharacterName",
  CellTags->"S1.1500"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1500"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1500"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Paragraph]",
    ButtonData:>{"Paragraph"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1500"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SelectionPlaceholder", "ObjectName",
  CellTags->"S1.1501"],

Cell[TextData[{
  "\[SelectionPlaceholder]  \[Backslash]",
  StyleBox["[SelectionPlaceholder]", "MR"]
}], "CharacterName",
  CellTags->"S1.1501"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["spl\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1501"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1501"],

Cell[TextData[{
  "\[FilledSmallSquare] Used to indicate where the current selection should \
be inserted when the contents of a button are pasted by ",
  StyleBox["NotebookApply", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1501"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][FilledSquare]",
    ButtonData:>{"FilledSquare"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1501"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.12",
    ButtonData:>{"1.10.12", "12.10"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.11.3",
    ButtonData:>{"2.11.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1501"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Placeholder]",
    ButtonData:>{"Placeholder"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1501"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SHacek", "ObjectName",
  CellTags->"S1.1502"],

Cell[TextData[{
  "\[SHacek]  \[Backslash]",
  StyleBox["[SHacek]", "MR"]
}], "CharacterName",
  CellTags->"S1.1502"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["sv\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1502"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1502"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1502"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1502"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalSHacek]",
    ButtonData:>{"CapitalSHacek"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CHacek]",
    ButtonData:>{"CHacek"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1502"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sharp", "ObjectName",
  CellTags->"S1.1503"],

Cell[TextData[{
  "\[Sharp]  \[Backslash]",
  StyleBox["[Sharp]", "MR"]
}], "CharacterName",
  CellTags->"S1.1503"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1503"],

Cell["\<\
\[FilledSmallSquare] Used to denote musical notes. \
\>", "Notes",
  CellTags->"S1.1503"],

Cell["\<\
\[FilledSmallSquare] Sometimes used in mathematical notation, \
typically to indicate some form of numbering or indexing. \
\>", "Notes",
  CellTags->"S1.1503"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][RawNumberSign]",
    ButtonData:>{"RawNumberSign"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1503"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1503"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Flat]",
    ButtonData:>{"Flat"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Natural]",
    ButtonData:>{"Natural"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1503"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ShortLeftArrow", "ObjectName",
  CellTags->"S1.1504"],

Cell[TextData[{
  "\[ShortLeftArrow]  \[Backslash]",
  StyleBox["[ShortLeftArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1504"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1504"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1504"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1504"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftArrow]",
    ButtonData:>{"LeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LongLeftArrow]",
    ButtonData:>{"LongLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1504"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ShortRightArrow", "ObjectName",
  CellTags->"S1.1505"],

Cell[TextData[{
  "\[ShortRightArrow]  \[Backslash]",
  StyleBox["[ShortRightArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1505"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1505"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Rule]",
    ButtonData:>{"Rule"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1505"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1505"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1505"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LongRightArrow]",
    ButtonData:>{"LongRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1505"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sigma", "ObjectName",
  CellTags->"S1.1506"],

Cell[TextData[{
  "\[Sigma]  \[Backslash]",
  StyleBox["[Sigma]", "MR"]
}], "CharacterName",
  CellTags->"S1.1506"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["s\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["sigma\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1506"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1506"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["DivisorSigma", "MR"],
  " and ",
  StyleBox["WeierstrassSigma", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1506"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1506"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalSigma]",
    ButtonData:>{"CapitalSigma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FinalSigma]",
    ButtonData:>{"FinalSigma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1506"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SixPointedStar", "ObjectName",
  CellTags->"S1.1507"],

Cell[TextData[{
  "\[SixPointedStar]  \[Backslash]",
  StyleBox["[SixPointedStar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1507"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["*6\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1507"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1507"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as the operator ",
  ButtonBox["\[Backslash][Star]",
    ButtonData:>{"Star"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1507"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1507"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][FivePointedStar]",
    ButtonData:>{"FivePointedStar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Star]",
    ButtonData:>{"Star"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawStar]",
    ButtonData:>{"RawStar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1507"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SkeletonIndicator", "ObjectName",
  CellTags->"S1.1508"],

Cell[TextData[{
  "\[SkeletonIndicator]  \[Backslash]",
  StyleBox["[SkeletonIndicator]", "MR"]
}], "CharacterName",
  CellTags->"S1.1508"],

Cell["\[FilledSmallSquare] Uninterpretable element. ", "Notes",
  CellTags->"S1.1508"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[SkeletonIndicator]\)], "InlineFormula"],
  " ",
  StyleBox["name", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[SkeletonIndicator]\)], "InlineFormula"],
  " is used on output to indicate an expression that has head ",
  StyleBox["name", "TI"],
  ", but whose arguments will not explicitly be given. "
}], "Notes",
  CellTags->"S1.1508"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[SkeletonIndicator]", "MR"],
  " indicates the presence of missing information, and so by default \
generates an error if you try to interpret it. "
}], "Notes",
  CellTags->"S1.1508"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1508"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][LeftSkeleton]",
    ButtonData:>{"LeftSkeleton"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Ellipsis]",
    ButtonData:>{"Ellipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1508"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SmallCircle", "ObjectName",
  CellTags->"S1.1509"],

Cell[TextData[{
  "\[SmallCircle]  \[Backslash]",
  StyleBox["[SmallCircle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1509"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["sc\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1509"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1509"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[SmallCircle]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["SmallCircle[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1509"],

Cell["\<\
\[FilledSmallSquare] Used to indicate function composition. \
\>", \
"Notes",
  CellTags->"S1.1509"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as the letter\[Hyphen]like form ",
  ButtonBox["\[Backslash][EmptyCircle]",
    ButtonData:>{"EmptyCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1509"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Degree]",
    ButtonData:>{"Degree"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1509"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1509"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][FilledCircle]",
    ButtonData:>{"FilledCircle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CircleDot]",
    ButtonData:>{"CircleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CircleTimes]",
    ButtonData:>{"CircleTimes"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1509"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SpaceIndicator", "ObjectName",
  CellTags->"S1.1510"],

Cell[TextData[{
  "\[SpaceIndicator]  \[Backslash]",
  StyleBox["[SpaceIndicator]", "MR"]
}], "CharacterName",
  CellTags->"S1.1510"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["space\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1510"],

Cell["\[FilledSmallSquare] Spacing character. ", "Notes",
  CellTags->"S1.1510"],

Cell[TextData[{
  "\[FilledSmallSquare] Interpreted by default as equivalent to ",
  ButtonBox["\[Backslash][RawSpace]",
    ButtonData:>{"RawSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1510"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.25"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1510"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RoundSpaceIndicator]",
    ButtonData:>{"RoundSpaceIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ThinSpace]",
    ButtonData:>{"ThinSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReturnIndicator]",
    ButtonData:>{"ReturnIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  "."
}], "Notes",
  CellTags->"S1.1510"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SpadeSuit", "ObjectName",
  CellTags->"S1.1511"],

Cell[TextData[{
  "\[SpadeSuit]  \[Backslash]",
  StyleBox["[SpadeSuit]", "MR"]
}], "CharacterName",
  CellTags->"S1.1511"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1511"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1511"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ClubSuit]",
    ButtonData:>{"ClubSuit"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1511"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SphericalAngle", "ObjectName",
  CellTags->"S1.1512"],

Cell[TextData[{
  "\[SphericalAngle]  \[Backslash]",
  StyleBox["[SphericalAngle]", "MR"]
}], "CharacterName",
  CellTags->"S1.1512"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1512"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in geometry to indicate a spherical angle, as in \
the symbol ",
  Cell[BoxData[
      \(TraditionalForm\`\[SphericalAngle]\)], "InlineFormula"],
  " ",
  StyleBox["ABC", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1512"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.31"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1512"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Angle]",
    ButtonData:>{"Angle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][MeasuredAngle]",
    ButtonData:>{"MeasuredAngle"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1512"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sqrt", "ObjectName",
  CellTags->"S1.1513"],

Cell[TextData[{
  "\[Sqrt]  \[Backslash]",
  StyleBox["[Sqrt]", "MR"]
}], "CharacterName",
  CellTags->"S1.1513"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["sqrt\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1513"],

Cell["\<\
\[FilledSmallSquare] Prefix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1513"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sqrt]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " is by default interpreted as ",
  StyleBox["Sqrt[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1513"],

Cell[TextData[{
  "\[FilledSmallSquare] \[ControlKey]\[LeftModified]",
  StyleBox["@\[RightModified]", "MR"],
  ", \[ControlKey]\[LeftModified]",
  StyleBox["2\[RightModified]", "MR"],
  " or \[Backslash]",
  StyleBox["@", "MR"],
  " yields a complete ",
  StyleBox["SqrtBox", "MR"],
  " object. "
}], "Notes",
  CellTags->"S1.1513"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[Sqrt]", "MR"],
  " is equivalent when evaluated, but will not draw a line on top of the \
quantity whose square root is being taken. "
}], "Notes",
  CellTags->"S1.1513"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1513"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Square", "ObjectName",
  CellTags->"S1.1514"],

Cell[TextData[{
  "\[Square]  \[Backslash]",
  StyleBox["[Square]", "MR"]
}], "CharacterName",
  CellTags->"S1.1514"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["sq\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1514"],

Cell["\[FilledSmallSquare] Prefix operator. ", "Notes",
  CellTags->"S1.1514"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[Square]\)], "InlineFormula"],
  " ",
  StyleBox["x", "TI"],
  " is by default interpreted as ",
  StyleBox["Square[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1514"],

Cell["\<\
\[FilledSmallSquare] Used in mathematical physics to denote the \
d'Alembertian operator. \
\>", "Notes",
  CellTags->"S1.1514"],

Cell["\<\
\[FilledSmallSquare] Sometimes used in number theory to indicate a \
quadratic residue. \
\>", "Notes",
  CellTags->"S1.1514"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][EmptySquare]",
    ButtonData:>{"EmptySquare"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1514"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1514"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Del]",
    ButtonData:>{"Del"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1514"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SquareIntersection", "ObjectName",
  CellTags->"S1.1515"],

Cell[TextData[{
  "\[SquareIntersection]  \[Backslash]",
  StyleBox["[SquareIntersection]", "MR"]
}], "CharacterName",
  CellTags->"S1.1515"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1515"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SquareIntersection] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["SquareIntersection[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1515"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1515"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][SquareUnion]",
    ButtonData:>{"SquareUnion"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Intersection]",
    ButtonData:>{"Intersection"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Wedge]",
    ButtonData:>{"Wedge"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1515"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SquareSubset", "ObjectName",
  CellTags->"S1.1516"],

Cell[TextData[{
  "\[SquareSubset]  \[Backslash]",
  StyleBox["[SquareSubset]", "MR"]
}], "CharacterName",
  CellTags->"S1.1516"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1516"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SquareSubset] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["SquareSubset[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1516"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in computer science to indicate that ",
  StyleBox["x", "TI"],
  " is a substring occurring at the beginning of ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1516"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1516"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSquareSubset]",
    ButtonData:>{"NotSquareSubset"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SquareSuperset]",
    ButtonData:>{"SquareSuperset"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1516"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SquareSubsetEqual", "ObjectName",
  CellTags->"S1.1517"],

Cell[TextData[{
  "\[SquareSubsetEqual]  \[Backslash]",
  StyleBox["[SquareSubsetEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1517"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1517"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SquareSubsetEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["SquareSubsetEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1517"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1517"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSquareSubsetEqual]",
    ButtonData:>{"NotSquareSubsetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1517"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SquareSuperset", "ObjectName",
  CellTags->"S1.1518"],

Cell[TextData[{
  "\[SquareSuperset]  \[Backslash]",
  StyleBox["[SquareSuperset]", "MR"]
}], "CharacterName",
  CellTags->"S1.1518"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1518"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SquareSuperset] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["SquareSuperset[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1518"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in computer science to indicate that ",
  StyleBox["x", "TI"],
  " is a substring occurring at the end of ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1518"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1518"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSquareSuperset]",
    ButtonData:>{"NotSquareSuperset"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SquareSubset]",
    ButtonData:>{"SquareSubset"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1518"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SquareSupersetEqual", "ObjectName",
  CellTags->"S1.1519"],

Cell[TextData[{
  "\[SquareSupersetEqual]  \[Backslash]",
  StyleBox["[SquareSupersetEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1519"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1519"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SquareSupersetEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["SquareSupersetEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1519"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1519"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSquareSupersetEqual]",
    ButtonData:>{"NotSquareSupersetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1519"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SquareUnion", "ObjectName",
  CellTags->"S1.1520"],

Cell[TextData[{
  "\[SquareUnion]  \[Backslash]",
  StyleBox["[SquareUnion]", "MR"]
}], "CharacterName",
  CellTags->"S1.1520"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1520"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SquareUnion] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["SquareUnion[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1520"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to denote various forms of \
generalized union, typically of disjoint subspaces. \
\>", "Notes",
  CellTags->"S1.1520"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1520"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][SquareIntersection]",
    ButtonData:>{"SquareIntersection"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Union]",
    ButtonData:>{"Union"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UnionPlus]",
    ButtonData:>{"UnionPlus"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Vee]",
    ButtonData:>{"Vee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Coproduct]",
    ButtonData:>{"Coproduct"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1520"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Star", "ObjectName",
  CellTags->"S1.1521"],

Cell[TextData[{
  "\[Star]  \[Backslash]",
  StyleBox["[Star]", "MR"]
}], "CharacterName",
  CellTags->"S1.1521"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["star\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1521"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1521"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Star]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Star[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1521"],

Cell["\<\
\[FilledSmallSquare] Used to denote convolution and generalized \
forms of multiplication. \
\>", "Notes",
  CellTags->"S1.1521"],

Cell["\<\
\[FilledSmallSquare] Sometimes used in prefix form to indicate \
dual. \
\>", "Notes",
  CellTags->"S1.1521"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][SixPointedStar]",
    ButtonData:>{"SixPointedStar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawStar]",
    ButtonData:>{"RawStar"},
    ButtonStyle->"MainBookLinkMR"],
  " or ",
  ButtonBox["\[Backslash][Conjugate]",
    ButtonData:>{"Conjugate"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1521"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["\[Backslash][RawStar]",
    ButtonData:>{"RawStar"},
    ButtonStyle->"MainBookLinkMR"],
  " is the character entered for superscripts. "
}], "Notes",
  CellTags->"S1.1521"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1521"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Times]",
    ButtonData:>{"Times"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Cross]",
    ButtonData:>{"Cross"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1521"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sterling", "ObjectName",
  CellTags->"S1.1522"],

Cell[TextData[{
  "\[Sterling]  \[Backslash]",
  StyleBox["[Sterling]", "MR"]
}], "CharacterName",
  CellTags->"S1.1522"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1522"],

Cell[TextData[{
  "\[FilledSmallSquare] Currency symbol for British pound sterling, as in ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sterling]\)], "InlineFormula"],
  " ",
  StyleBox["5", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1522"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to denote Lie derivative. \
\
\>", "Notes",
  CellTags->"S1.1522"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.10"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1522"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawNumberSign]",
    ButtonData:>{"RawNumberSign"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Euro]",
    ButtonData:>{"Euro"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1522"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stigma", "ObjectName",
  CellTags->"S1.1523"],

Cell[TextData[{
  "\[Stigma]  \[Backslash]",
  StyleBox["[Stigma]", "MR"]
}], "CharacterName",
  CellTags->"S1.1523"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["sti\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["stigma\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1523"],

Cell["\[FilledSmallSquare] Special Greek letter. ", "Notes",
  CellTags->"S1.1523"],

Cell[TextData[{
  "\[FilledSmallSquare] Appeared between ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Zeta]\)], "InlineFormula"],
  " in early Greek alphabet; used for Greek numeral 6. "
}], "Notes",
  CellTags->"S1.1523"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][FinalSigma]",
    ButtonData:>{"FinalSigma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1523"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1523"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalStigma]",
    ButtonData:>{"CapitalStigma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Digamma]",
    ButtonData:>{"Digamma"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Koppa]",
    ButtonData:>{"Koppa"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Sampi]",
    ButtonData:>{"Sampi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1523"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Subset", "ObjectName",
  CellTags->"S1.1524"],

Cell[TextData[{
  "\[Subset]  \[Backslash]",
  StyleBox["[Subset]", "MR"]
}], "CharacterName",
  CellTags->"S1.1524"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["sub\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1524"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1524"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Subset] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Subset[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1524"],

Cell["\<\
\[FilledSmallSquare] Usually used in mathematics to indicate \
subset; sometimes proper subset. \
\>", "Notes",
  CellTags->"S1.1524"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1524"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][SubsetEqual]",
    ButtonData:>{"SubsetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SquareSubset]",
    ButtonData:>{"SquareSubset"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Element]",
    ButtonData:>{"Element"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Precedes]",
    ButtonData:>{"Precedes"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftTriangle]",
    ButtonData:>{"LeftTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotSubset]",
    ButtonData:>{"NotSubset"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1524"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SubsetEqual", "ObjectName",
  CellTags->"S1.1525"],

Cell[TextData[{
  "\[SubsetEqual]  \[Backslash]",
  StyleBox["[SubsetEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1525"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["sub=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1525"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1525"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SubsetEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["SubsetEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1525"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1525"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSubsetEqual]",
    ButtonData:>{"NotSubsetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1525"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Succeeds", "ObjectName",
  CellTags->"S1.1526"],

Cell[TextData[{
  "\[Succeeds]  \[Backslash]",
  StyleBox["[Succeeds]", "MR"]
}], "CharacterName",
  CellTags->"S1.1526"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1526"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Succeeds] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Succeeds[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1526"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate various \
notions of partial ordering. \
\>", "Notes",
  CellTags->"S1.1526"],

Cell[TextData[{
  "\[FilledSmallSquare] Often applied to functions and read \
\[OpenCurlyDoubleQuote]",
  StyleBox["x", "TI"],
  " dominates ",
  StyleBox["y", "TI"],
  "\[CloseCurlyDoubleQuote]. "
}], "Notes",
  CellTags->"S1.1526"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1526"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][SucceedsEqual]",
    ButtonData:>{"SucceedsEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Precedes]",
    ButtonData:>{"Precedes"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotSucceeds]",
    ButtonData:>{"NotSucceeds"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1526"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SucceedsEqual", "ObjectName",
  CellTags->"S1.1527"],

Cell[TextData[{
  "\[SucceedsEqual]  \[Backslash]",
  StyleBox["[SucceedsEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1527"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1527"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SucceedsEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["SucceedsEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1527"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1527"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][SucceedsSlantEqual]",
    ButtonData:>{"SucceedsSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SucceedsTilde]",
    ButtonData:>{"SucceedsTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][PrecedesEqual]",
    ButtonData:>{"PrecedesEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotSucceedsEqual]",
    ButtonData:>{"NotSucceedsEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1527"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SucceedsSlantEqual", "ObjectName",
  CellTags->"S1.1528"],

Cell[TextData[{
  "\[SucceedsSlantEqual]  \[Backslash]",
  StyleBox["[SucceedsSlantEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1528"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1528"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SucceedsSlantEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["SucceedsSlantEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1528"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1528"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][SucceedsEqual]",
    ButtonData:>{"SucceedsEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][PrecedesSlantEqual]",
    ButtonData:>{"PrecedesSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotSucceedsSlantEqual]",
    ButtonData:>{"NotSucceedsSlantEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1528"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SucceedsTilde", "ObjectName",
  CellTags->"S1.1529"],

Cell[TextData[{
  "\[SucceedsTilde]  \[Backslash]",
  StyleBox["[SucceedsTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1529"],

Cell["\[FilledSmallSquare] Infix ordering operator. ", "Notes",
  CellTags->"S1.1529"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SucceedsTilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["SucceedsTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1529"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1529"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][SucceedsEqual]",
    ButtonData:>{"SucceedsEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][PrecedesTilde]",
    ButtonData:>{"PrecedesTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotSucceedsTilde]",
    ButtonData:>{"NotSucceedsTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1529"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SuchThat", "ObjectName",
  CellTags->"S1.1530"],

Cell[TextData[{
  "\[SuchThat]  \[Backslash]",
  StyleBox["[SuchThat]", "MR"]
}], "CharacterName",
  CellTags->"S1.1530"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["st\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1530"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1530"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SuchThat] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["SuchThat[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1530"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SuchThat] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SuchThat] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  " groups as ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SuchThat] \)], "InlineFormula"],
  " ",
  StyleBox["(", "MR"],
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SuchThat] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[")", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1530"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][ReverseElement]",
    ButtonData:>{"ReverseElement"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1530"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1530"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Exists]",
    ButtonData:>{"Exists"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ForAll]",
    ButtonData:>{"ForAll"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Colon]",
    ButtonData:>{"Colon"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VerticalBar]",
    ButtonData:>{"VerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1530"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sum", "ObjectName",
  CellTags->"S1.1531"],

Cell[TextData[{
  "\[Sum]  \[Backslash]",
  StyleBox["[Sum]", "MR"]
}], "CharacterName",
  CellTags->"S1.1531"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["sum\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1531"],

Cell["\<\
\[FilledSmallSquare] Compound operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1531"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            StyleBox["i",
              "TI"], 
            SubscriptBox[
              StyleBox["i",
                "TI"], 
              StyleBox["max",
                "TI"]],
            LimitsPositioning->False], 
          StyleBox["f",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Sum[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1531"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            SubscriptBox[
              StyleBox[\(i = i\),
                "TI"], 
              StyleBox["min",
                "TI"]], 
            SubscriptBox[
              StyleBox["i",
                "TI"], 
              StyleBox["max",
                "TI"]],
            LimitsPositioning->False], 
          StyleBox["f",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Sum[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1531"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as the Greek letter ",
  ButtonBox["\[Backslash][CapitalSigma]",
    ButtonData:>{"CapitalSigma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1531"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.12"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.27"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.26"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1531"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Product]",
    ButtonData:>{"Product"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Integral]",
    ButtonData:>{"Integral"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1531"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Superset", "ObjectName",
  CellTags->"S1.1532"],

Cell[TextData[{
  "\[Superset]  \[Backslash]",
  StyleBox["[Superset]", "MR"]
}], "CharacterName",
  CellTags->"S1.1532"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["sup\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1532"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1532"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Superset] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Superset[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1532"],

Cell["\<\
\[FilledSmallSquare] Usually used in mathematics to indicate \
superset; sometimes proper superset. \
\>", "Notes",
  CellTags->"S1.1532"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][RoundImplies]",
    ButtonData:>{"RoundImplies"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1532"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1532"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][SupersetEqual]",
    ButtonData:>{"SupersetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SquareSuperset]",
    ButtonData:>{"SquareSuperset"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][ReverseElement]",
    ButtonData:>{"ReverseElement"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Succeeds]",
    ButtonData:>{"Succeeds"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTriangle]",
    ButtonData:>{"RightTriangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotSuperset]",
    ButtonData:>{"NotSuperset"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1532"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SupersetEqual", "ObjectName",
  CellTags->"S1.1533"],

Cell[TextData[{
  "\[SupersetEqual]  \[Backslash]",
  StyleBox["[SupersetEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1533"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["sup=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1533"],

Cell["\<\
\[FilledSmallSquare] Infix set relation operator. \
\>", "Notes",
  CellTags->"S1.1533"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[SupersetEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["SupersetEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1533"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1533"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotSupersetEqual]",
    ButtonData:>{"NotSupersetEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1533"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SZ", "ObjectName",
  CellTags->"S1.1534"],

Cell[TextData[{
  "\[SZ]  \[Backslash]",
  StyleBox["[SZ]", "MR"]
}], "CharacterName",
  CellTags->"S1.1534"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["sz\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["ss\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1534"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1534"],

Cell["\[FilledSmallSquare] Used in German. ", "Notes",
  CellTags->"S1.1534"],

Cell["\<\
\[FilledSmallSquare] Sometimes called s sharp, ess\[Hyphen]zed or \
ess\[Hyphen]zet. \
\>", "Notes",
  CellTags->"S1.1534"],

Cell[TextData[{
  "\[FilledSmallSquare] Usually transliterated in English as ",
  StyleBox["ss", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1534"],

Cell[TextData[{
  "\[FilledSmallSquare] Upper\[Hyphen]case form is ",
  StyleBox["SS", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1534"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1534"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1534"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Beta]",
    ButtonData:>{"Beta"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1534"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tau", "ObjectName",
  CellTags->"S1.1535"],

Cell[TextData[{
  "\[Tau]  \[Backslash]",
  StyleBox["[Tau]", "MR"]
}], "CharacterName",
  CellTags->"S1.1535"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["t\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["tau\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1535"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1535"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1535"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalTau]",
    ButtonData:>{"CapitalTau"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Theta]",
    ButtonData:>{"Theta"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1535"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Therefore", "ObjectName",
  CellTags->"S1.1536"],

Cell[TextData[{
  "\[Therefore]  \[Backslash]",
  StyleBox["[Therefore]", "MR"]
}], "CharacterName",
  CellTags->"S1.1536"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["tf\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1536"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1536"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Therefore] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Therefore[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1536"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Therefore] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Therefore] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  " groups as ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Therefore] \)], "InlineFormula"],
  " ",
  StyleBox["(", "MR"],
  StyleBox["y", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Therefore] \)], "InlineFormula"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[")", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1536"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1536"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Because]",
    ButtonData:>{"Because"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Implies]",
    ButtonData:>{"Implies"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightTee]",
    ButtonData:>{"RightTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][FilledRectangle]",
    ButtonData:>{"FilledRectangle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Proportion]",
    ButtonData:>{"Proportion"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1536"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Theta", "ObjectName",
  CellTags->"S1.1537"],

Cell[TextData[{
  "\[Theta]  \[Backslash]",
  StyleBox["[Theta]", "MR"]
}], "CharacterName",
  CellTags->"S1.1537"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["th\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["theta\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["q\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1537"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1537"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1537"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CurlyTheta]",
    ButtonData:>{"CurlyTheta"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalTheta]",
    ButtonData:>{"CapitalTheta"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Tau]",
    ButtonData:>{"Tau"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1537"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ThickSpace", "ObjectName",
  CellTags->"S1.1538"],

Cell[TextData[{
  "\[ThickSpace]  \[Backslash]",
  StyleBox["[ThickSpace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1538"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1538"],

Cell["\[FilledSmallSquare] Spacing character. ", "Notes",
  CellTags->"S1.1538"],

Cell["\[FilledSmallSquare] Width: 5/18 em. ", "Notes",
  CellTags->"S1.1538"],

Cell[TextData[{
  "\[FilledSmallSquare] Interpreted by default just like an ordinary ",
  ButtonBox["\[Backslash][RawSpace]",
    ButtonData:>{"RawSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1538"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.25"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1538"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][MediumSpace]",
    ButtonData:>{"MediumSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NegativeThickSpace]",
    ButtonData:>{"NegativeThickSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  StyleBox["SpaceIndicator", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1538"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ThinSpace", "ObjectName",
  CellTags->"S1.1539"],

Cell[TextData[{
  "\[ThinSpace]  \[Backslash]",
  StyleBox["[ThinSpace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1539"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1539"],

Cell["\[FilledSmallSquare] Spacing character. ", "Notes",
  CellTags->"S1.1539"],

Cell["\[FilledSmallSquare] Width: 3/18 em. ", "Notes",
  CellTags->"S1.1539"],

Cell[TextData[{
  "\[FilledSmallSquare] Interpreted by default just like an ordinary ",
  ButtonBox["\[Backslash][RawSpace]",
    ButtonData:>{"RawSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1539"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.25"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1539"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][VeryThinSpace]",
    ButtonData:>{"VeryThinSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][MediumSpace]",
    ButtonData:>{"MediumSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NegativeThinSpace]",
    ButtonData:>{"NegativeThinSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SpaceIndicator]",
    ButtonData:>{"SpaceIndicator"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1539"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Thorn", "ObjectName",
  CellTags->"S1.1540"],

Cell[TextData[{
  "\[Thorn]  \[Backslash]",
  StyleBox["[Thorn]", "MR"]
}], "CharacterName",
  CellTags->"S1.1540"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["thn\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1540"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1540"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1540"],

Cell["\<\
\[FilledSmallSquare] Used in Icelandic and Old English. \
\>", \
"Notes",
  CellTags->"S1.1540"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1540"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalThorn]",
    ButtonData:>{"CapitalThorn"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Eth]",
    ButtonData:>{"Eth"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1540"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tilde", "ObjectName",
  CellTags->"S1.1541"],

Cell[TextData[{
  "\[Tilde]  \[Backslash]",
  StyleBox["[Tilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1541"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["~\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1541"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1541"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Tilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Tilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1541"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics for many notions of \
similarity or equivalence. \
\>", "Notes",
  CellTags->"S1.1541"],

Cell["\<\
\[FilledSmallSquare] Used in physical science to indicate \
approximate equality. \
\>", "Notes",
  CellTags->"S1.1541"],

Cell["\<\
\[FilledSmallSquare] Occasionally used in mathematics for notions \
of difference. \
\>", "Notes",
  CellTags->"S1.1541"],

Cell["\<\
\[FilledSmallSquare] Occasionally used in prefix form to indicate \
complement or negation. \
\>", "Notes",
  CellTags->"S1.1541"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][RawTilde]",
    ButtonData:>{"RawTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1541"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1541"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][NotTilde]",
    ButtonData:>{"NotTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VerticalTilde]",
    ButtonData:>{"VerticalTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Not]",
    ButtonData:>{"Not"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1541"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TildeEqual", "ObjectName",
  CellTags->"S1.1542"],

Cell[TextData[{
  "\[TildeEqual]  \[Backslash]",
  StyleBox["[TildeEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1542"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  StyleBox["=\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1542"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1542"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[TildeEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["TildeEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1542"],

Cell["\<\
\[FilledSmallSquare] Used to mean approximately or asymptotically \
equal. \
\>", "Notes",
  CellTags->"S1.1542"],

Cell["\<\
\[FilledSmallSquare] Also used in mathematics to indicate homotopy. \
\
\>", "Notes",
  CellTags->"S1.1542"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1542"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][TildeTilde]",
    ButtonData:>{"TildeTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][TildeFullEqual]",
    ButtonData:>{"TildeFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotTildeEqual]",
    ButtonData:>{"NotTildeEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1542"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TildeFullEqual", "ObjectName",
  CellTags->"S1.1543"],

Cell[TextData[{
  "\[TildeFullEqual]  \[Backslash]",
  StyleBox["[TildeFullEqual]", "MR"]
}], "CharacterName",
  CellTags->"S1.1543"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  StyleBox["==\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1543"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1543"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[TildeFullEqual] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["TildeFullEqual[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1543"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to indicate isomorphism, \
congruence and homotopic equivalence. \
\>", "Notes",
  CellTags->"S1.1543"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1543"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][TildeEqual]",
    ButtonData:>{"TildeEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Congruent]",
    ButtonData:>{"Congruent"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotTildeFullEqual]",
    ButtonData:>{"NotTildeFullEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1543"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TildeTilde", "ObjectName",
  CellTags->"S1.1544"],

Cell[TextData[{
  "\[TildeTilde]  \[Backslash]",
  StyleBox["[TildeTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1544"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`~\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1544"],

Cell["\[FilledSmallSquare] Infix similarity operator. ", "Notes",
  CellTags->"S1.1544"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[TildeTilde] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["TildeTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1544"],

Cell["\<\
\[FilledSmallSquare] Used for various notions of approximate or \
asymptotic equality. \
\>", "Notes",
  CellTags->"S1.1544"],

Cell["\<\
\[FilledSmallSquare] Used in pure mathematics to indicate \
homeomorphism. \
\>", "Notes",
  CellTags->"S1.1544"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.16"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1544"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][TildeEqual]",
    ButtonData:>{"TildeEqual"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotTildeTilde]",
    ButtonData:>{"NotTildeTilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1544"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Times", "ObjectName",
  CellTags->"S1.1545"],

Cell[TextData[{
  "\[Times]  \[Backslash]",
  StyleBox["[Times]", "MR"]
}], "CharacterName",
  CellTags->"S1.1545"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["*\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1545"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1545"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Times]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Times[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ", which is equivalent to ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["y", "TI"],
  " or ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["*", "MR"],
  " ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1545"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Cross]",
    ButtonData:>{"Cross"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1545"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[Times]", "MR"],
  " represents ordinary multiplication, while ",
  ButtonBox["\[Backslash][Cross]",
    ButtonData:>{"Cross"},
    ButtonStyle->"MainBookLinkMR"],
  " represents vector cross product. "
}], "Notes",
  CellTags->"S1.1545"],

Cell[TextData[{
  "\[FilledSmallSquare] \[Backslash]",
  StyleBox["[Times]", "MR"],
  " is drawn larger than ",
  ButtonBox["\[Backslash][Cross]",
    ButtonData:>{"Cross"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1545"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.10"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1545"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Star]",
    ButtonData:>{"Star"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CircleTimes]",
    ButtonData:>{"CircleTimes"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Divide]",
    ButtonData:>{"Divide"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Wedge]",
    ButtonData:>{"Wedge"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1545"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trademark", "ObjectName",
  CellTags->"S1.1546"],

Cell[TextData[{
  "\[Trademark]  \[Backslash]",
  StyleBox["[Trademark]", "MR"]
}], "CharacterName",
  CellTags->"S1.1546"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["tm\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1546"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1546"],

Cell["\<\
\[FilledSmallSquare] Used to indicate a trademark that may not be \
registered. \
\>", "Notes",
  CellTags->"S1.1546"],

Cell["\<\
\[FilledSmallSquare] Typically used only on the first occurrence of \
a trademark in a document. \
\>", "Notes",
  CellTags->"S1.1546"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1546"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RegisteredTrademark]",
    ButtonData:>{"RegisteredTrademark"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Copyright]",
    ButtonData:>{"Copyright"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1546"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transpose", "ObjectName",
  CellTags->"S1.1547"],

Cell[TextData[{
  "\[Transpose]  \[Backslash]",
  StyleBox["[Transpose]", "MR"]
}], "CharacterName",
  CellTags->"S1.1547"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["tr\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1547"],

Cell["\<\
\[FilledSmallSquare] Superscript postfix operator with built\
\[Hyphen]in evaluation rules. \
\>", "Notes",
  CellTags->"S1.1547"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      SuperscriptBox[
        StyleBox["m",
          "TI"], "\[Transpose]"]], "InlineFormula"],
  " is by default interpreted as ",
  StyleBox["Transpose[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1547"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as keyboard ",
  StyleBox["T", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1547"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.12"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.27"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.26"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1547"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ConjugateTranspose]",
    ButtonData:>{"ConjugateTranspose"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1547"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UAcute", "ObjectName",
  CellTags->"S1.1548"],

Cell[TextData[{
  "\[UAcute]  \[Backslash]",
  StyleBox["[UAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1548"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["u'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1548"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1548"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1548"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1548"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalUAcute]",
    ButtonData:>{"CapitalUAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1548"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UDoubleAcute", "ObjectName",
  CellTags->"S1.1549"],

Cell[TextData[{
  "\[UDoubleAcute]  \[Backslash]",
  StyleBox["[UDoubleAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1549"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["u''\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1549"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1549"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]2. ", "Notes",
  CellTags->"S1.1549"],

Cell["\[FilledSmallSquare] Used in Hungarian. ", "Notes",
  CellTags->"S1.1549"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1549"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalUDoubleAcute]",
    ButtonData:>{"CapitalUDoubleAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1549"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UDoubleDot", "ObjectName",
  CellTags->"S1.1550"],

Cell[TextData[{
  "\[UDoubleDot]  \[Backslash]",
  StyleBox["[UDoubleDot]", "MR"]
}], "CharacterName",
  CellTags->"S1.1550"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["u\"\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1550"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1550"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1550"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1550"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UDoubleAcute]",
    ButtonData:>{"UDoubleAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalUDoubleDot]",
    ButtonData:>{"CapitalUDoubleDot"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1550"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UGrave", "ObjectName",
  CellTags->"S1.1551"],

Cell[TextData[{
  "\[UGrave]  \[Backslash]",
  StyleBox["[UGrave]", "MR"]
}], "CharacterName",
  CellTags->"S1.1551"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["u`\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1551"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1551"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1551"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.7",
    ButtonData:>{"1.10.7", "7.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1551"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalUGrave]",
    ButtonData:>{"CapitalUGrave"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1551"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UHat", "ObjectName",
  CellTags->"S1.1552"],

Cell[TextData[{
  "\[UHat]  \[Backslash]",
  StyleBox["[UHat]", "MR"]
}], "CharacterName",
  CellTags->"S1.1552"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["u^\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1552"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1552"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1552"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1552"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalUHat]",
    ButtonData:>{"CapitalUHat"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1552"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UnderBrace", "ObjectName",
  CellTags->"S1.1553"],

Cell[TextData[{
  "\[UnderBrace]  \[Backslash]",
  StyleBox["[UnderBrace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1553"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["u", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1553"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1553"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1553"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1553"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UnderBracket]",
    ButtonData:>{"UnderBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UnderParenthesis]",
    ButtonData:>{"UnderParenthesis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][OverBrace]",
    ButtonData:>{"OverBrace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1553"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UnderBracket", "ObjectName",
  CellTags->"S1.1554"],

Cell[TextData[{
  "\[UnderBracket]  \[Backslash]",
  StyleBox["[UnderBracket]", "MR"]
}], "CharacterName",
  CellTags->"S1.1554"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["u[\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1554"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1554"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1554"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1554"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UnderParenthesis]",
    ButtonData:>{"UnderParenthesis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UnderBrace]",
    ButtonData:>{"UnderBrace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][OverBracket]",
    ButtonData:>{"OverBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][HorizontalLine]",
    ButtonData:>{"HorizontalLine"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1554"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UnderParenthesis", "ObjectName",
  CellTags->"S1.1555"],

Cell[TextData[{
  "\[UnderParenthesis]  \[Backslash]",
  StyleBox["[UnderParenthesis]", "MR"]
}], "CharacterName",
  CellTags->"S1.1555"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["u(\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1555"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1555"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1555"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1555"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UnderBracket]",
    ButtonData:>{"UnderBracket"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UnderBrace]",
    ButtonData:>{"UnderBrace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][OverParenthesis]",
    ButtonData:>{"OverParenthesis"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1555"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Union", "ObjectName",
  CellTags->"S1.1556"],

Cell[TextData[{
  "\[Union]  \[Backslash]",
  StyleBox["[Union]", "MR"]
}], "CharacterName",
  CellTags->"S1.1556"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["un\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1556"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1556"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Union]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Union[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1556"],

Cell[TextData[{
  "\[FilledSmallSquare] The character ",
  Cell[BoxData[
      \(TraditionalForm\`\[Union]\)], "InlineFormula"],
  " is sometimes called \[OpenCurlyDoubleQuote]cup\[CloseCurlyDoubleQuote]; \
but see also ",
  ButtonBox["\[Backslash][Cup]",
    ButtonData:>{"Cup"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1556"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.4",
    ButtonData:>{"1.10.4", "4.10"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 3.10.1",
    ButtonData:>{"3.10.1", "1.27"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1556"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Intersection]",
    ButtonData:>{"Intersection"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SquareUnion]",
    ButtonData:>{"SquareUnion"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UnionPlus]",
    ButtonData:>{"UnionPlus"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Cup]",
    ButtonData:>{"Cup"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Vee]",
    ButtonData:>{"Vee"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1556"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UnionPlus", "ObjectName",
  CellTags->"S1.1557"],

Cell[TextData[{
  "\[UnionPlus]  \[Backslash]",
  StyleBox["[UnionPlus]", "MR"]
}], "CharacterName",
  CellTags->"S1.1557"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1557"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[UnionPlus]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["UnionPlus[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1557"],

Cell["\<\
\[FilledSmallSquare] Used to denote union of multisets, in which \
multiplicities of elements are added. \
\>", "Notes",
  CellTags->"S1.1557"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1557"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Union]",
    ButtonData:>{"Union"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CirclePlus]",
    ButtonData:>{"CirclePlus"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1557"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UpArrow", "ObjectName",
  CellTags->"S1.1558"],

Cell[TextData[{
  "\[UpArrow]  \[Backslash]",
  StyleBox["[UpArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1558"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1558"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[UpArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["UpArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1558"],

Cell["\<\
\[FilledSmallSquare] Sometimes used in mathematics to denote \
generalization of powers. \
\>", "Notes",
  CellTags->"S1.1558"],

Cell["\<\
\[FilledSmallSquare] Used to indicate monotonic increase to a \
limit. \
\>", "Notes",
  CellTags->"S1.1558"],

Cell["\<\
\[FilledSmallSquare] Sometimes used in prefix form to indicate the \
closure of a set. \
\>", "Notes",
  CellTags->"S1.1558"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1558"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1558"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UpTeeArrow]",
    ButtonData:>{"UpTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrowBar]",
    ButtonData:>{"UpArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleUpArrow]",
    ButtonData:>{"DoubleUpArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftUpVector]",
    ButtonData:>{"LeftUpVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownArrow]",
    ButtonData:>{"DownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Wedge]",
    ButtonData:>{"Wedge"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RawWedge]",
    ButtonData:>{"RawWedge"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1558"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UpArrowBar", "ObjectName",
  CellTags->"S1.1559"],

Cell[TextData[{
  "\[UpArrowBar]  \[Backslash]",
  StyleBox["[UpArrowBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1559"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1559"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[UpArrowBar]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["UpArrowBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1559"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1559"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1559"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UpTeeArrow]",
    ButtonData:>{"UpTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftUpVectorBar]",
    ButtonData:>{"LeftUpVectorBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1559"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UpArrowDownArrow", "ObjectName",
  CellTags->"S1.1560"],

Cell[TextData[{
  "\[UpArrowDownArrow]  \[Backslash]",
  StyleBox["[UpArrowDownArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1560"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1560"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[UpArrowDownArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["UpArrowDownArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1560"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1560"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1560"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][DownArrowUpArrow]",
    ButtonData:>{"DownArrowUpArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpDownArrow]",
    ButtonData:>{"UpDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleUpDownArrow]",
    ButtonData:>{"DoubleUpDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpEquilibrium]",
    ButtonData:>{"UpEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1560"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UpDownArrow", "ObjectName",
  CellTags->"S1.1561"],

Cell[TextData[{
  "\[UpDownArrow]  \[Backslash]",
  StyleBox["[UpDownArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1561"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1561"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[UpDownArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["UpDownArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1561"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1561"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1561"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UpArrowDownArrow]",
    ButtonData:>{"UpArrowDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleUpDownArrow]",
    ButtonData:>{"DoubleUpDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftUpDownVector]",
    ButtonData:>{"LeftUpDownVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpEquilibrium]",
    ButtonData:>{"UpEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1561"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UpEquilibrium", "ObjectName",
  CellTags->"S1.1562"],

Cell[TextData[{
  "\[UpEquilibrium]  \[Backslash]",
  StyleBox["[UpEquilibrium]", "MR"]
}], "CharacterName",
  CellTags->"S1.1562"],

Cell["\[FilledSmallSquare] Infix arrow\[Hyphen]like operator. ", "Notes",
  CellTags->"S1.1562"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[UpEquilibrium]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["UpEquilibrium[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1562"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1562"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1562"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ReverseUpEquilibrium]",
    ButtonData:>{"ReverseUpEquilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrowDownArrow]",
    ButtonData:>{"UpArrowDownArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftUpDownVector]",
    ButtonData:>{"LeftUpDownVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Equilibrium]",
    ButtonData:>{"Equilibrium"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1562"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UpperLeftArrow", "ObjectName",
  CellTags->"S1.1563"],

Cell[TextData[{
  "\[UpperLeftArrow]  \[Backslash]",
  StyleBox["[UpperLeftArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1563"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1563"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[UpperLeftArrow] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["UpperLeftArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1563"],

Cell["\<\
\[FilledSmallSquare] Extensible character; grows by default to \
limited size. \
\>", "Notes",
  CellTags->"S1.1563"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1563"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UpperRightArrow]",
    ButtonData:>{"UpperRightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftArrow]",
    ButtonData:>{"LeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1563"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UpperRightArrow", "ObjectName",
  CellTags->"S1.1564"],

Cell[TextData[{
  "\[UpperRightArrow]  \[Backslash]",
  StyleBox["[UpperRightArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1564"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1564"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[UpperRightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["UpperRightArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1564"],

Cell["\<\
\[FilledSmallSquare] Extensible character; grows by default to \
limited size. \
\>", "Notes",
  CellTags->"S1.1564"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1564"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UpperLeftArrow]",
    ButtonData:>{"UpperLeftArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][RightArrow]",
    ButtonData:>{"RightArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1564"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Upsilon", "ObjectName",
  CellTags->"S1.1565"],

Cell[TextData[{
  "\[Upsilon]  \[Backslash]",
  StyleBox["[Upsilon]", "MR"]
}], "CharacterName",
  CellTags->"S1.1565"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["u\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["upsilon\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1565"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1565"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1565"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalUpsilon]",
    ButtonData:>{"CapitalUpsilon"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1565"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UpTee", "ObjectName",
  CellTags->"S1.1566"],

Cell[TextData[{
  "\[UpTee]  \[Backslash]",
  StyleBox["[UpTee]", "MR"]
}], "CharacterName",
  CellTags->"S1.1566"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["uT\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1566"],

Cell["\[FilledSmallSquare] Infix relational operator. ", "Notes",
  CellTags->"S1.1566"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[UpTee] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["UpTee[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1566"],

Cell["\<\
\[FilledSmallSquare] Used in geometry to indicate perpendicular. \
\
\>", "Notes",
  CellTags->"S1.1566"],

Cell["\<\
\[FilledSmallSquare] Used in number theory to indicate relative \
primality. \
\>", "Notes",
  CellTags->"S1.1566"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1566"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RightAngle]",
    ButtonData:>{"RightAngle"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotDoubleVerticalBar]",
    ButtonData:>{"NotDoubleVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownTee]",
    ButtonData:>{"DownTee"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1566"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UpTeeArrow", "ObjectName",
  CellTags->"S1.1567"],

Cell[TextData[{
  "\[UpTeeArrow]  \[Backslash]",
  StyleBox["[UpTeeArrow]", "MR"]
}], "CharacterName",
  CellTags->"S1.1567"],

Cell["\[FilledSmallSquare] Infix arrow operator. ", "Notes",
  CellTags->"S1.1567"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[UpTeeArrow]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["UpTeeArrow[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1567"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1567"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1567"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][UpArrowBar]",
    ButtonData:>{"UpArrowBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][LeftUpTeeVector]",
    ButtonData:>{"LeftUpTeeVector"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpTee]",
    ButtonData:>{"UpTee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DownTeeArrow]",
    ButtonData:>{"DownTeeArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1567"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vee", "ObjectName",
  CellTags->"S1.1568"],

Cell[TextData[{
  "\[Vee]  \[Backslash]",
  StyleBox["[Vee]", "MR"]
}], "CharacterName",
  CellTags->"S1.1568"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["v\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1568"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1568"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Vee]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Vee[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1568"],

Cell[TextData[{
  "\[FilledSmallSquare] Used to indicate various notions of joining, and as a \
dual of ",
  ButtonBox["\[Backslash][Wedge]",
    ButtonData:>{"Wedge"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1568"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][Or]",
    ButtonData:>{"Or"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1568"],

Cell[TextData[{
  "\[FilledSmallSquare] Drawn slightly smaller than ",
  ButtonBox["\[Backslash][Or]",
    ButtonData:>{"Or"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1568"],

Cell["\<\
\[FilledSmallSquare] Sometimes used in prefix form to indicate the \
total variation of a function. \
\>", "Notes",
  CellTags->"S1.1568"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1568"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Wedge]",
    ButtonData:>{"Wedge"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Union]",
    ButtonData:>{"Union"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SquareUnion]",
    ButtonData:>{"SquareUnion"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Nu]",
    ButtonData:>{"Nu"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Hacek]",
    ButtonData:>{"Hacek"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1568"]
}, Open  ]],

Cell[CellGroupData[{

Cell["VerticalBar", "ObjectName",
  CellTags->"S1.1569"],

Cell[TextData[{
  "\[VerticalBar]  \[Backslash]",
  StyleBox["[VerticalBar]", "MR"]
}], "CharacterName",
  CellTags->"S1.1569"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  StyleBox["|\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1569"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1569"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[VerticalBar] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["VerticalBar[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1569"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in mathematics to indicate that ",
  StyleBox["x", "TI"],
  " divides ",
  StyleBox["y", "TI"],
  ". "
}], "Notes",
  CellTags->"S1.1569"],

Cell["\<\
\[FilledSmallSquare] Also sometimes called Sheffer stroke, and used \
to indicate logical NAND. \
\>", "Notes",
  CellTags->"S1.1569"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][VerticalSeparator]",
    ButtonData:>{"VerticalSeparator"},
    ButtonStyle->"MainBookLinkMR"],
  ", which is drawn longer. "
}], "Notes",
  CellTags->"S1.1569"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][LeftBracketingBar]",
    ButtonData:>{"LeftBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  " and ",
  ButtonBox["\[Backslash][RightBracketingBar]",
    ButtonData:>{"RightBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", which are drawn with a small tee to indicate their direction. "
}], "Notes",
  CellTags->"S1.1569"],

Cell[TextData[{
  "\[FilledSmallSquare] \[AliasIndicator]",
  StyleBox["|\[AliasIndicator]", "MR"],
  " is the alias for ",
  ButtonBox["\[Backslash][VerticalSeparator]",
    ButtonData:>{"VerticalSeparator"},
    ButtonStyle->"MainBookLinkMR"],
  ". The alias for \[Backslash]",
  StyleBox["[VerticalBar]", "MR"],
  " has a space at the beginning. "
}], "Notes",
  CellTags->"S1.1569"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1569"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawVerticalBar]",
    ButtonData:>{"RawVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Nand]",
    ButtonData:>{"Nand"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotVerticalBar]",
    ButtonData:>{"NotVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleVerticalBar]",
    ButtonData:>{"DoubleVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Backslash]",
    ButtonData:>{"Backslash"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][HorizontalLine]",
    ButtonData:>{"HorizontalLine"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1569"]
}, Open  ]],

Cell[CellGroupData[{

Cell["VerticalEllipsis", "ObjectName",
  CellTags->"S1.1570"],

Cell[TextData[{
  "\[VerticalEllipsis]  \[Backslash]",
  StyleBox["[VerticalEllipsis]", "MR"]
}], "CharacterName",
  CellTags->"S1.1570"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1570"],

Cell["\<\
\[FilledSmallSquare] Used to indicate omitted elements in columns \
of a matrix. \
\>", "Notes",
  CellTags->"S1.1570"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1570"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Ellipsis]",
    ButtonData:>{"Ellipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][AscendingEllipsis]",
    ButtonData:>{"AscendingEllipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VerticalBar]",
    ButtonData:>{"VerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1570"]
}, Open  ]],

Cell[CellGroupData[{

Cell["VerticalLine", "ObjectName",
  CellTags->"S1.1571"],

Cell[TextData[{
  "\[VerticalLine]  \[Backslash]",
  StyleBox["[VerticalLine]", "MR"]
}], "CharacterName",
  CellTags->"S1.1571"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["vline\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1571"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1571"],

Cell["\[FilledSmallSquare] Extensible character. ", "Notes",
  CellTags->"S1.1571"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][VerticalSeparator]",
    ButtonData:>{"VerticalSeparator"},
    ButtonStyle->"MainBookLinkMR"],
  " or ",
  ButtonBox["\[Backslash][VerticalBar]",
    ButtonData:>{"VerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", which are infix operators. "
}], "Notes",
  CellTags->"S1.1571"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][LeftBracketingBar]",
    ButtonData:>{"LeftBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  " and ",
  ButtonBox["\[Backslash][RightBracketingBar]",
    ButtonData:>{"RightBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", which are matchfix operators, drawn with a small tee to indicate their \
direction. "
}], "Notes",
  CellTags->"S1.1571"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1571"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawVerticalBar]",
    ButtonData:>{"RawVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][HorizontalLine]",
    ButtonData:>{"HorizontalLine"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][VerticalEllipsis]",
    ButtonData:>{"VerticalEllipsis"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrow]",
    ButtonData:>{"UpArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1571"]
}, Open  ]],

Cell[CellGroupData[{

Cell["VerticalSeparator", "ObjectName",
  CellTags->"S1.1572"],

Cell[TextData[{
  "\[VerticalSeparator]  \[Backslash]",
  StyleBox["[VerticalSeparator]", "MR"]
}], "CharacterName",
  CellTags->"S1.1572"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["|\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1572"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1572"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[VerticalSeparator] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["VerticalSeparator[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1572"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics for many purposes, \
including indicating restriction and standing for \[OpenCurlyDoubleQuote]such \
that\[CloseCurlyDoubleQuote]. \
\>", "Notes",
  CellTags->"S1.1572"],

Cell["\<\
\[FilledSmallSquare] Also used to separate arguments of various \
mathematical functions. \
\>", "Notes",
  CellTags->"S1.1572"],

Cell["\<\
\[FilledSmallSquare] Extensible character; grows by default to \
limited size. \
\>", "Notes",
  CellTags->"S1.1572"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][VerticalBar]",
    ButtonData:>{"VerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", which is drawn shorter. "
}], "Notes",
  CellTags->"S1.1572"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][LeftBracketingBar]",
    ButtonData:>{"LeftBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  " and ",
  ButtonBox["\[Backslash][RightBracketingBar]",
    ButtonData:>{"RightBracketingBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", which are drawn with a small tee to indicate their direction. "
}], "Notes",
  CellTags->"S1.1572"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][VerticalLine]",
    ButtonData:>{"VerticalLine"},
    ButtonStyle->"MainBookLinkMR"],
  ", which is a letter\[Hyphen]like form, and is indefinitely extensible. "
}], "Notes",
  CellTags->"S1.1572"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1572"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][RawVerticalBar]",
    ButtonData:>{"RawVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NotVerticalBar]",
    ButtonData:>{"NotVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][DoubleVerticalBar]",
    ButtonData:>{"DoubleVerticalBar"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Colon]",
    ButtonData:>{"Colon"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SuchThat]",
    ButtonData:>{"SuchThat"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][HorizontalLine]",
    ButtonData:>{"HorizontalLine"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1572"]
}, Open  ]],

Cell[CellGroupData[{

Cell["VerticalTilde", "ObjectName",
  CellTags->"S1.1573"],

Cell[TextData[{
  "\[VerticalTilde]  \[Backslash]",
  StyleBox["[VerticalTilde]", "MR"]
}], "CharacterName",
  CellTags->"S1.1573"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1573"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[VerticalTilde]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["VerticalTilde[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1573"],

Cell["\<\
\[FilledSmallSquare] Used in mathematics to mean wreath product. \
\
\>", "Notes",
  CellTags->"S1.1573"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1573"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Tilde]",
    ButtonData:>{"Tilde"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1573"]
}, Open  ]],

Cell[CellGroupData[{

Cell["VeryThinSpace", "ObjectName",
  CellTags->"S1.1574"],

Cell[TextData[{
  "\[VeryThinSpace]  \[Backslash]",
  StyleBox["[VeryThinSpace]", "MR"]
}], "CharacterName",
  CellTags->"S1.1574"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[AliasIndicator]. "
}], "Notes",
  CellTags->"S1.1574"],

Cell["\[FilledSmallSquare] Spacing character. ", "Notes",
  CellTags->"S1.1574"],

Cell["\[FilledSmallSquare] Width: 1/18 em. ", "Notes",
  CellTags->"S1.1574"],

Cell[TextData[{
  "\[FilledSmallSquare] Interpreted by default just like an ordinary ",
  ButtonBox["\[Backslash][RawSpace]",
    ButtonData:>{"RawSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1574"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.25"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.5",
    ButtonData:>{"3.10.5", "5.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1574"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][ThinSpace]",
    ButtonData:>{"ThinSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][NegativeVeryThinSpace]",
    ButtonData:>{"NegativeVeryThinSpace"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][AlignmentMarker]",
    ButtonData:>{"AlignmentMarker"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Null]",
    ButtonData:>{"Null"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][InvisibleComma]",
    ButtonData:>{"InvisibleComma"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1574"]
}, Open  ]],

Cell[CellGroupData[{

Cell["WarningSign", "ObjectName",
  CellTags->"S1.1575"],

Cell[TextData[{
  "\[WarningSign]  \[Backslash]",
  StyleBox["[WarningSign]", "MR"]
}], "CharacterName",
  CellTags->"S1.1575"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1575"],

Cell["\<\
\[FilledSmallSquare] Based on an international standard road sign. \
\
\>", "Notes",
  CellTags->"S1.1575"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.30"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1575"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][WatchIcon]",
    ButtonData:>{"WatchIcon"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1575"]
}, Open  ]],

Cell[CellGroupData[{

Cell["WatchIcon", "ObjectName",
  CellTags->"S1.1576"],

Cell[TextData[{
  "\[WatchIcon]  \[Backslash]",
  StyleBox["[WatchIcon]", "MR"]
}], "CharacterName",
  CellTags->"S1.1576"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1576"],

Cell["\<\
\[FilledSmallSquare] Used to indicate a calculation that may take a \
long time. \
\>", "Notes",
  CellTags->"S1.1576"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.30"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1576"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][WarningSign]",
    ButtonData:>{"WarningSign"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1576"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wedge", "ObjectName",
  CellTags->"S1.1577"],

Cell[TextData[{
  "\[Wedge]  \[Backslash]",
  StyleBox["[Wedge]", "MR"]
}], "CharacterName",
  CellTags->"S1.1577"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["^\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1577"],

Cell["\[FilledSmallSquare] Infix operator. ", "Notes",
  CellTags->"S1.1577"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Wedge]\)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Wedge[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1577"],

Cell["\<\
\[FilledSmallSquare] Used to mean wedge or exterior product and \
other generalized antisymmetric products. \
\>", "Notes",
  CellTags->"S1.1577"],

Cell["\<\
\[FilledSmallSquare] Occasionally used for generalized notions of \
intersection. \
\>", "Notes",
  CellTags->"S1.1577"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][And]",
    ButtonData:>{"And"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CapitalLambda]",
    ButtonData:>{"CapitalLambda"},
    ButtonStyle->"MainBookLinkMR"],
  " or ",
  ButtonBox["\[Backslash][RawWedge]",
    ButtonData:>{"RawWedge"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1577"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.8",
    ButtonData:>{"1.10.8", "8.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1577"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Vee]",
    ButtonData:>{"Vee"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][UpArrow]",
    ButtonData:>{"UpArrow"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Intersection]",
    ButtonData:>{"Intersection"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][SquareIntersection]",
    ButtonData:>{"SquareIntersection"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CircleTimes]",
    ButtonData:>{"CircleTimes"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1577"]
}, Open  ]],

Cell[CellGroupData[{

Cell["WeierstrassP", "ObjectName",
  CellTags->"S1.1578"],

Cell[TextData[{
  "\[WeierstrassP]  \[Backslash]",
  StyleBox["[WeierstrassP]", "MR"]
}], "CharacterName",
  CellTags->"S1.1578"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["wp\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1578"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1578"],

Cell[TextData[{
  "\[FilledSmallSquare] Used to denote the function ",
  StyleBox["WeierstrassP", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1578"],

Cell[TextData[{
  "\[FilledSmallSquare] Not the same as ",
  ButtonBox["\[Backslash][ScriptCapitalP]",
    ButtonData:>{"ScriptCapitalA"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1578"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.13"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1578"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wolf", "ObjectName",
  CellTags->"S1.1579"],

Cell[TextData[{
  "\[Wolf]  \[Backslash]",
  StyleBox["[Wolf]", "MR"]
}], "CharacterName",
  CellTags->"S1.1579"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["wf\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["wolf\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1579"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1579"],

Cell["\<\
\[FilledSmallSquare] Iconic representation of a wolf. \
\>", "Notes",
  CellTags->"S1.1579"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.30"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1579"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Xi", "ObjectName",
  CellTags->"S1.1580"],

Cell[TextData[{
  "\[Xi]  \[Backslash]",
  StyleBox["[Xi]", "MR"]
}], "CharacterName",
  CellTags->"S1.1580"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["x\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["xi\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1580"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1580"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1580"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalXi]",
    ButtonData:>{"CapitalXi"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Chi]",
    ButtonData:>{"Chi"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Zeta]",
    ButtonData:>{"Zeta"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1580"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Xor", "ObjectName",
  CellTags->"S1.1581"],

Cell[TextData[{
  "\[Xor]  \[Backslash]",
  StyleBox["[Xor]", "MR"]
}], "CharacterName",
  CellTags->"S1.1581"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["xor\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1581"],

Cell["\<\
\[FilledSmallSquare] Infix operator with built\[Hyphen]in \
evaluation rules. \
\>", "Notes",
  CellTags->"S1.1581"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Xor] \)], "InlineFormula"],
  " ",
  StyleBox["y", "TI"],
  " is by default interpreted as ",
  StyleBox["Xor[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1581"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.4",
    ButtonData:>{"3.10.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1581"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][Nor]",
    ButtonData:>{"Nor"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Or]",
    ButtonData:>{"Or"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][CirclePlus]",
    ButtonData:>{"CirclePlus"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1581"]
}, Open  ]],

Cell[CellGroupData[{

Cell["YAcute", "ObjectName",
  CellTags->"S1.1582"],

Cell[TextData[{
  "\[YAcute]  \[Backslash]",
  StyleBox["[YAcute]", "MR"]
}], "CharacterName",
  CellTags->"S1.1582"],

Cell[TextData[{
  "\[FilledSmallSquare] Alias: \[AliasIndicator]",
  StyleBox["y'\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1582"],

Cell["\[FilledSmallSquare] Letter. ", "Notes",
  CellTags->"S1.1582"],

Cell["\[FilledSmallSquare] Included in ISO Latin\[Hyphen]1. ", "Notes",
  CellTags->"S1.1582"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.36"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1582"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalYAcute]",
    ButtonData:>{"CapitalYAcute"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1582"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yen", "ObjectName",
  CellTags->"S1.1583"],

Cell[TextData[{
  "\[Yen]  \[Backslash]",
  StyleBox["[Yen]", "MR"]
}], "CharacterName",
  CellTags->"S1.1583"],

Cell["\[FilledSmallSquare] Letter\[Hyphen]like form. ", "Notes",
  CellTags->"S1.1583"],

Cell[TextData[{
  "\[FilledSmallSquare] Currency symbol for Japanese yen, as in ",
  Cell[BoxData[
      \(TraditionalForm\`\[Yen]\)], "InlineFormula"],
  StyleBox["5000", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1583"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.22"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1583"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Zeta", "ObjectName",
  CellTags->"S1.1584"],

Cell[TextData[{
  "\[Zeta]  \[Backslash]",
  StyleBox["[Zeta]", "MR"]
}], "CharacterName",
  CellTags->"S1.1584"],

Cell[TextData[{
  "\[FilledSmallSquare] Aliases: \[AliasIndicator]",
  StyleBox["z\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["zeta\[AliasIndicator]", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1584"],

Cell["\[FilledSmallSquare] Greek letter. ", "Notes",
  CellTags->"S1.1584"],

Cell[TextData[{
  "\[FilledSmallSquare] Used in ",
  StyleBox["TraditionalForm", "MR"],
  " for ",
  StyleBox["Zeta", "MR"],
  " and ",
  StyleBox["WeierstrassZeta", "MR"],
  ". "
}], "Notes",
  CellTags->"S1.1584"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.10.1",
    ButtonData:>{"1.10.1", "1.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.10.3",
    ButtonData:>{"3.10.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"S1.1584"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["\[Backslash][CapitalZeta]",
    ButtonData:>{"CapitalZeta"},
    ButtonStyle->"MainBookLinkMR"],
  ", ",
  ButtonBox["\[Backslash][Xi]",
    ButtonData:>{"Xi"},
    ButtonStyle->"MainBookLinkMR"],
  ". "
}], "Notes",
  CellTags->"S1.1584"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{230, Automatic}, {58, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.12.0"->{
    Cell[1776, 53, 132, 4, 65, "Section",
      CellTags->{"SA.12.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 132, 4, 65, "Section",
      CellTags->{"SA.12.0", "0.1"}]},
  "SA.12.1"->{
    Cell[1933, 61, 66, 1, 70, "Subsection",
      CellTags->{"SA.12.1", "1.1"}],
    Cell[2002, 64, 244, 6, 70, "Text",
      CellTags->{"SA.12.1", "1.2"}],
    Cell[2249, 72, 166, 5, 70, "Text",
      CellTags->{"SA.12.1", "1.3"}],
    Cell[2418, 79, 97, 1, 70, "Text",
      CellTags->{"SA.12.1", "1.4"}],
    Cell[2518, 82, 326, 11, 70, "Text",
      CellTags->{"SA.12.1", "1.5"}],
    Cell[2869, 97, 85, 1, 70, "Subsubsection",
      CellTags->{"SA.12.1", "1.6"}],
    Cell[2957, 100, 283, 9, 70, "Text",
      CellTags->{"SA.12.1", "1.7"}],
    Cell[3243, 111, 174, 5, 70, "Text",
      CellTags->{"SA.12.1", "1.8"}],
    Cell[3420, 118, 2421, 70, 70, "DefinitionBox",
      CellTags->"SA.12.1"],
    Cell[5844, 190, 63, 1, 70, "Caption",
      CellTags->"SA.12.1"],
    Cell[5910, 193, 229, 7, 70, "Text",
      CellTags->{"SA.12.1", "1.9"}],
    Cell[6142, 202, 628, 26, 70, "Text",
      CellTags->{"SA.12.1", "1.10"}],
    Cell[6807, 233, 76, 1, 70, "Subsubsection",
      CellTags->{"SA.12.1", "1.11"}],
    Cell[6886, 236, 290, 6, 70, "Text",
      CellTags->{"SA.12.1", "1.12"}],
    Cell[7179, 244, 139, 4, 70, "Text",
      CellTags->{"SA.12.1", "1.13"}],
    Cell[7321, 250, 1333, 38, 70, "DefinitionBox",
      CellTags->"SA.12.1"],
    Cell[8657, 290, 78, 1, 70, "Caption",
      CellTags->"SA.12.1"],
    Cell[8738, 293, 1625, 52, 70, "DefinitionBox",
      CellTags->"SA.12.1"],
    Cell[10366, 347, 91, 1, 70, "Caption",
      CellTags->"SA.12.1"],
    Cell[10494, 353, 65, 1, 70, "Subsubsection",
      CellTags->{"SA.12.1", "1.14"}],
    Cell[10562, 356, 422, 8, 70, "Text",
      CellTags->{"SA.12.1", "1.15"}],
    Cell[10987, 366, 1378, 36, 70, "DefinitionBox",
      CellTags->"SA.12.1"],
    Cell[12368, 404, 60, 1, 70, "Caption",
      CellTags->"SA.12.1"],
    Cell[12431, 407, 109, 1, 70, "Text",
      CellTags->{"SA.12.1", "1.16"}],
    Cell[12543, 410, 1590, 36, 70, "Notes",
      CellTags->{"SA.12.1", "1.17"}],
    Cell[14170, 451, 71, 1, 70, "Subsubsection",
      CellTags->{"SA.12.1", "1.18"}],
    Cell[14244, 454, 258, 6, 70, "Text",
      CellTags->{"SA.12.1", "1.19"}],
    Cell[14505, 462, 321, 8, 70, "Text",
      CellTags->{"SA.12.1", "1.20"}],
    Cell[14829, 472, 254, 5, 70, "Text",
      CellTags->{"SA.12.1", "1.21"}]},
  "1.1"->{
    Cell[1933, 61, 66, 1, 70, "Subsection",
      CellTags->{"SA.12.1", "1.1"}]},
  "1.2"->{
    Cell[2002, 64, 244, 6, 70, "Text",
      CellTags->{"SA.12.1", "1.2"}]},
  "1.3"->{
    Cell[2249, 72, 166, 5, 70, "Text",
      CellTags->{"SA.12.1", "1.3"}]},
  "1.4"->{
    Cell[2418, 79, 97, 1, 70, "Text",
      CellTags->{"SA.12.1", "1.4"}]},
  "1.5"->{
    Cell[2518, 82, 326, 11, 70, "Text",
      CellTags->{"SA.12.1", "1.5"}]},
  "1.6"->{
    Cell[2869, 97, 85, 1, 70, "Subsubsection",
      CellTags->{"SA.12.1", "1.6"}]},
  "1.7"->{
    Cell[2957, 100, 283, 9, 70, "Text",
      CellTags->{"SA.12.1", "1.7"}]},
  "1.8"->{
    Cell[3243, 111, 174, 5, 70, "Text",
      CellTags->{"SA.12.1", "1.8"}]},
  "1.9"->{
    Cell[5910, 193, 229, 7, 70, "Text",
      CellTags->{"SA.12.1", "1.9"}]},
  "1.10"->{
    Cell[6142, 202, 628, 26, 70, "Text",
      CellTags->{"SA.12.1", "1.10"}]},
  "1.11"->{
    Cell[6807, 233, 76, 1, 70, "Subsubsection",
      CellTags->{"SA.12.1", "1.11"}]},
  "1.12"->{
    Cell[6886, 236, 290, 6, 70, "Text",
      CellTags->{"SA.12.1", "1.12"}]},
  "1.13"->{
    Cell[7179, 244, 139, 4, 70, "Text",
      CellTags->{"SA.12.1", "1.13"}]},
  "1.14"->{
    Cell[10494, 353, 65, 1, 70, "Subsubsection",
      CellTags->{"SA.12.1", "1.14"}]},
  "1.15"->{
    Cell[10562, 356, 422, 8, 70, "Text",
      CellTags->{"SA.12.1", "1.15"}]},
  "1.16"->{
    Cell[12431, 407, 109, 1, 70, "Text",
      CellTags->{"SA.12.1", "1.16"}]},
  "1.17"->{
    Cell[12543, 410, 1590, 36, 70, "Notes",
      CellTags->{"SA.12.1", "1.17"}]},
  "1.18"->{
    Cell[14170, 451, 71, 1, 70, "Subsubsection",
      CellTags->{"SA.12.1", "1.18"}]},
  "1.19"->{
    Cell[14244, 454, 258, 6, 70, "Text",
      CellTags->{"SA.12.1", "1.19"}]},
  "1.20"->{
    Cell[14505, 462, 321, 8, 70, "Text",
      CellTags->{"SA.12.1", "1.20"}]},
  "1.21"->{
    Cell[14829, 472, 254, 5, 70, "Text",
      CellTags->{"SA.12.1", "1.21"}]},
  "S1.1001"->{
    Cell[15120, 482, 51, 1, 70, "ObjectName",
      CellTags->"S1.1001"],
    Cell[15174, 485, 117, 4, 70, "CharacterName",
      CellTags->"S1.1001"],
    Cell[15294, 491, 150, 5, 70, "Notes",
      CellTags->"S1.1001"],
    Cell[15447, 498, 69, 1, 70, "Notes",
      CellTags->"S1.1001"],
    Cell[15519, 501, 94, 1, 70, "Notes",
      CellTags->"S1.1001"],
    Cell[15616, 504, 188, 7, 70, "Notes",
      CellTags->"S1.1001"],
    Cell[15807, 513, 209, 7, 70, "Notes",
      CellTags->"S1.1001"]},
  "S1.1002"->{
    Cell[16053, 525, 49, 1, 70, "ObjectName",
      CellTags->"S1.1002"],
    Cell[16105, 528, 113, 4, 70, "CharacterName",
      CellTags->"S1.1002"],
    Cell[16221, 534, 150, 5, 70, "Notes",
      CellTags->"S1.1002"],
    Cell[16374, 541, 69, 1, 70, "Notes",
      CellTags->"S1.1002"],
    Cell[16446, 544, 94, 1, 70, "Notes",
      CellTags->"S1.1002"],
    Cell[16543, 547, 136, 4, 70, "Notes",
      CellTags->"S1.1002"],
    Cell[16682, 553, 188, 7, 70, "Notes",
      CellTags->"S1.1002"],
    Cell[16873, 562, 205, 7, 70, "Notes",
      CellTags->"S1.1002"]},
  "S1.1003"->{
    Cell[17115, 574, 49, 1, 70, "ObjectName",
      CellTags->"S1.1003"],
    Cell[17167, 577, 113, 4, 70, "CharacterName",
      CellTags->"S1.1003"],
    Cell[17283, 583, 150, 5, 70, "Notes",
      CellTags->"S1.1003"],
    Cell[17436, 590, 69, 1, 70, "Notes",
      CellTags->"S1.1003"],
    Cell[17508, 593, 94, 1, 70, "Notes",
      CellTags->"S1.1003"],
    Cell[17605, 596, 120, 4, 70, "Notes",
      CellTags->"S1.1003"],
    Cell[17728, 602, 188, 7, 70, "Notes",
      CellTags->"S1.1003"],
    Cell[17919, 611, 205, 7, 70, "Notes",
      CellTags->"S1.1003"]},
  "S1.1004"->{
    Cell[18161, 623, 55, 1, 70, "ObjectName",
      CellTags->"S1.1004"],
    Cell[18219, 626, 125, 4, 70, "CharacterName",
      CellTags->"S1.1004"],
    Cell[18347, 632, 151, 5, 70, "Notes",
      CellTags->"S1.1004"],
    Cell[18501, 639, 69, 1, 70, "Notes",
      CellTags->"S1.1004"],
    Cell[18573, 642, 94, 1, 70, "Notes",
      CellTags->"S1.1004"],
    Cell[18670, 645, 316, 11, 70, "Notes",
      CellTags->"S1.1004"],
    Cell[18989, 658, 333, 11, 70, "Notes",
      CellTags->"S1.1004"]},
  "S1.1005"->{
    Cell[19359, 674, 47, 1, 70, "ObjectName",
      CellTags->"S1.1005"],
    Cell[19409, 677, 109, 4, 70, "CharacterName",
      CellTags->"S1.1005"],
    Cell[19521, 683, 150, 5, 70, "Notes",
      CellTags->"S1.1005"],
    Cell[19674, 690, 69, 1, 70, "Notes",
      CellTags->"S1.1005"],
    Cell[19746, 693, 94, 1, 70, "Notes",
      CellTags->"S1.1005"],
    Cell[19843, 696, 188, 7, 70, "Notes",
      CellTags->"S1.1005"],
    Cell[20034, 705, 201, 7, 70, "Notes",
      CellTags->"S1.1005"]},
  "S1.1006"->{
    Cell[20272, 717, 51, 1, 70, "ObjectName",
      CellTags->"S1.1006"],
    Cell[20326, 720, 117, 4, 70, "CharacterName",
      CellTags->"S1.1006"],
    Cell[20446, 726, 150, 5, 70, "Notes",
      CellTags->"S1.1006"],
    Cell[20599, 733, 69, 1, 70, "Notes",
      CellTags->"S1.1006"],
    Cell[20671, 736, 94, 1, 70, "Notes",
      CellTags->"S1.1006"],
    Cell[20768, 739, 316, 11, 70, "Notes",
      CellTags->"S1.1006"],
    Cell[21087, 752, 209, 7, 70, "Notes",
      CellTags->"S1.1006"]},
  "S1.1007"->{
    Cell[21333, 764, 49, 1, 70, "ObjectName",
      CellTags->"S1.1007"],
    Cell[21385, 767, 113, 4, 70, "CharacterName",
      CellTags->"S1.1007"],
    Cell[21501, 773, 150, 5, 70, "Notes",
      CellTags->"S1.1007"],
    Cell[21654, 780, 69, 1, 70, "Notes",
      CellTags->"S1.1007"],
    Cell[21726, 783, 94, 1, 70, "Notes",
      CellTags->"S1.1007"],
    Cell[21823, 786, 188, 7, 70, "Notes",
      CellTags->"S1.1007"],
    Cell[22014, 795, 205, 7, 70, "Notes",
      CellTags->"S1.1007"]},
  "S1.1008"->{
    Cell[22256, 807, 50, 1, 70, "ObjectName",
      CellTags->"S1.1008"],
    Cell[22309, 810, 115, 4, 70, "CharacterName",
      CellTags->"S1.1008"],
    Cell[22427, 816, 150, 5, 70, "Notes",
      CellTags->"S1.1008"],
    Cell[22580, 823, 76, 1, 70, "Notes",
      CellTags->"S1.1008"],
    Cell[22659, 826, 84, 1, 70, "Notes",
      CellTags->"S1.1008"],
    Cell[22746, 829, 129, 4, 70, "Notes",
      CellTags->"S1.1008"],
    Cell[22878, 835, 317, 11, 70, "Notes",
      CellTags->"S1.1008"],
    Cell[23198, 848, 401, 15, 70, "Notes",
      CellTags->"S1.1008"]},
  "S1.1009"->{
    Cell[23636, 868, 59, 1, 70, "ObjectName",
      CellTags->"S1.1009"],
    Cell[23698, 871, 133, 4, 70, "CharacterName",
      CellTags->"S1.1009"],
    Cell[23834, 877, 151, 5, 70, "Notes",
      CellTags->"S1.1009"],
    Cell[23988, 884, 87, 1, 70, "Notes",
      CellTags->"S1.1009"],
    Cell[24078, 887, 185, 6, 70, "Notes",
      CellTags->"S1.1009"],
    Cell[24266, 895, 217, 6, 70, "Notes",
      CellTags->"S1.1009"],
    Cell[24486, 903, 154, 4, 70, "Notes",
      CellTags->"S1.1009"],
    Cell[24643, 909, 187, 7, 70, "Notes",
      CellTags->"S1.1009"],
    Cell[24833, 918, 451, 15, 70, "Notes",
      CellTags->"S1.1009"]},
  "S1.1010"->{
    Cell[25321, 938, 60, 1, 70, "ObjectName",
      CellTags->"S1.1010"],
    Cell[25384, 941, 135, 4, 70, "CharacterName",
      CellTags->"S1.1010"],
    Cell[25522, 947, 150, 5, 70, "Notes",
      CellTags->"S1.1010"],
    Cell[25675, 954, 87, 1, 70, "Notes",
      CellTags->"S1.1010"],
    Cell[25765, 957, 102, 3, 70, "Notes",
      CellTags->"S1.1010"],
    Cell[25870, 962, 200, 6, 70, "Notes",
      CellTags->"S1.1010"],
    Cell[26073, 970, 317, 11, 70, "Notes",
      CellTags->"S1.1010"],
    Cell[26393, 983, 549, 19, 70, "Notes",
      CellTags->"S1.1010"]},
  "S1.1011"->{
    Cell[26979, 1007, 50, 1, 70, "ObjectName",
      CellTags->"S1.1011"],
    Cell[27032, 1010, 115, 4, 70, "CharacterName",
      CellTags->"S1.1011"],
    Cell[27150, 1016, 220, 7, 70, "Notes",
      CellTags->"S1.1011"],
    Cell[27373, 1025, 75, 1, 70, "Notes",
      CellTags->"S1.1011"],
    Cell[27451, 1028, 213, 7, 70, "Notes",
      CellTags->"S1.1011"],
    Cell[27667, 1037, 315, 11, 70, "Notes",
      CellTags->"S1.1011"],
    Cell[27985, 1050, 207, 7, 70, "Notes",
      CellTags->"S1.1011"]},
  "S1.1012"->{
    Cell[28229, 1062, 48, 1, 70, "ObjectName",
      CellTags->"S1.1012"],
    Cell[28280, 1065, 111, 4, 70, "CharacterName",
      CellTags->"S1.1012"],
    Cell[28394, 1071, 219, 7, 70, "Notes",
      CellTags->"S1.1012"],
    Cell[28616, 1080, 126, 4, 70, "Notes",
      CellTags->"S1.1012"],
    Cell[28745, 1086, 484, 23, 70, "Notes",
      CellTags->"S1.1012"],
    Cell[29232, 1111, 199, 7, 70, "Notes",
      CellTags->"S1.1012"],
    Cell[29434, 1120, 210, 7, 70, "Notes",
      CellTags->"S1.1012"],
    Cell[29647, 1129, 424, 15, 70, "Notes",
      CellTags->"S1.1012"],
    Cell[30074, 1146, 393, 15, 70, "Notes",
      CellTags->"S1.1012"]},
  "S1.1013"->{
    Cell[30504, 1166, 50, 1, 70, "ObjectName",
      CellTags->"S1.1013"],
    Cell[30557, 1169, 115, 4, 70, "CharacterName",
      CellTags->"S1.1013"],
    Cell[30675, 1175, 87, 1, 70, "Notes",
      CellTags->"S1.1013"],
    Cell[30765, 1178, 247, 9, 70, "Notes",
      CellTags->"S1.1013"],
    Cell[31015, 1189, 317, 11, 70, "Notes",
      CellTags->"S1.1013"],
    Cell[31335, 1202, 449, 15, 70, "Notes",
      CellTags->"S1.1013"]},
  "S1.1014"->{
    Cell[31821, 1222, 53, 1, 70, "ObjectName",
      CellTags->"S1.1014"],
    Cell[31877, 1225, 121, 4, 70, "CharacterName",
      CellTags->"S1.1014"],
    Cell[32001, 1231, 151, 5, 70, "Notes",
      CellTags->"S1.1014"],
    Cell[32155, 1238, 87, 1, 70, "Notes",
      CellTags->"S1.1014"],
    Cell[32245, 1241, 189, 6, 70, "Notes",
      CellTags->"S1.1014"],
    Cell[32437, 1249, 224, 7, 70, "Notes",
      CellTags->"S1.1014"],
    Cell[32664, 1258, 317, 11, 70, "Notes",
      CellTags->"S1.1014"],
    Cell[32984, 1271, 531, 19, 70, "Notes",
      CellTags->"S1.1014"]},
  "S1.1015"->{
    Cell[33552, 1295, 50, 1, 70, "ObjectName",
      CellTags->"S1.1015"],
    Cell[33605, 1298, 115, 4, 70, "CharacterName",
      CellTags->"S1.1015"],
    Cell[33723, 1304, 150, 5, 70, "Notes",
      CellTags->"S1.1015"],
    Cell[33876, 1311, 69, 1, 70, "Notes",
      CellTags->"S1.1015"],
    Cell[33948, 1314, 94, 1, 70, "Notes",
      CellTags->"S1.1015"],
    Cell[34045, 1317, 316, 11, 70, "Notes",
      CellTags->"S1.1015"],
    Cell[34364, 1330, 335, 11, 70, "Notes",
      CellTags->"S1.1015"]},
  "S1.1016"->{
    Cell[34736, 1346, 62, 1, 70, "ObjectName",
      CellTags->"S1.1016"],
    Cell[34801, 1349, 139, 4, 70, "CharacterName",
      CellTags->"S1.1016"],
    Cell[34943, 1355, 87, 1, 70, "Notes",
      CellTags->"S1.1016"],
    Cell[35033, 1358, 118, 4, 70, "Notes",
      CellTags->"S1.1016"],
    Cell[35154, 1364, 188, 7, 70, "Notes",
      CellTags->"S1.1016"],
    Cell[35345, 1373, 459, 15, 70, "Notes",
      CellTags->"S1.1016"]},
  "S1.1017"->{
    Cell[35841, 1393, 51, 1, 70, "ObjectName",
      CellTags->"S1.1017"],
    Cell[35895, 1396, 117, 4, 70, "CharacterName",
      CellTags->"S1.1017"],
    Cell[36015, 1402, 214, 7, 70, "Notes",
      CellTags->"S1.1017"],
    Cell[36232, 1411, 69, 1, 70, "Notes",
      CellTags->"S1.1017"],
    Cell[36304, 1414, 94, 1, 70, "Notes",
      CellTags->"S1.1017"],
    Cell[36401, 1417, 188, 7, 70, "Notes",
      CellTags->"S1.1017"],
    Cell[36592, 1426, 209, 7, 70, "Notes",
      CellTags->"S1.1017"]},
  "S1.1018"->{
    Cell[36838, 1438, 54, 1, 70, "ObjectName",
      CellTags->"S1.1018"],
    Cell[36895, 1441, 123, 4, 70, "CharacterName",
      CellTags->"S1.1018"],
    Cell[37021, 1447, 150, 5, 70, "Notes",
      CellTags->"S1.1018"],
    Cell[37174, 1454, 77, 1, 70, "Notes",
      CellTags->"S1.1018"],
    Cell[37254, 1457, 388, 17, 70, "Notes",
      CellTags->"S1.1018"],
    Cell[37645, 1476, 111, 4, 70, "Notes",
      CellTags->"S1.1018"],
    Cell[37759, 1482, 126, 4, 70, "Notes",
      CellTags->"S1.1018"],
    Cell[37888, 1488, 173, 7, 70, "Notes",
      CellTags->"S1.1018"],
    Cell[38064, 1497, 316, 11, 70, "Notes",
      CellTags->"S1.1018"],
    Cell[38383, 1510, 551, 19, 70, "Notes",
      CellTags->"S1.1018"]},
  "S1.1019"->{
    Cell[38971, 1534, 52, 1, 70, "ObjectName",
      CellTags->"S1.1019"],
    Cell[39026, 1537, 119, 4, 70, "CharacterName",
      CellTags->"S1.1019"],
    Cell[39148, 1543, 77, 1, 70, "Notes",
      CellTags->"S1.1019"],
    Cell[39228, 1546, 386, 17, 70, "Notes",
      CellTags->"S1.1019"],
    Cell[39617, 1565, 646, 29, 70, "Notes",
      CellTags->"S1.1019"],
    Cell[40266, 1596, 187, 7, 70, "Notes",
      CellTags->"S1.1019"],
    Cell[40456, 1605, 553, 19, 70, "Notes",
      CellTags->"S1.1019"]},
  "S1.1020"->{
    Cell[41046, 1629, 48, 1, 70, "ObjectName",
      CellTags->"S1.1020"],
    Cell[41097, 1632, 111, 4, 70, "CharacterName",
      CellTags->"S1.1020"],
    Cell[41211, 1638, 150, 5, 70, "Notes",
      CellTags->"S1.1020"],
    Cell[41364, 1645, 76, 1, 70, "Notes",
      CellTags->"S1.1020"],
    Cell[41443, 1648, 84, 1, 70, "Notes",
      CellTags->"S1.1020"],
    Cell[41530, 1651, 136, 4, 70, "Notes",
      CellTags->"S1.1020"],
    Cell[41669, 1657, 188, 7, 70, "Notes",
      CellTags->"S1.1020"],
    Cell[41860, 1666, 193, 7, 70, "Notes",
      CellTags->"S1.1020"]},
  "S1.1021"->{
    Cell[42090, 1678, 49, 1, 70, "ObjectName",
      CellTags->"S1.1021"],
    Cell[42142, 1681, 113, 4, 70, "CharacterName",
      CellTags->"S1.1021"],
    Cell[42258, 1687, 219, 7, 70, "Notes",
      CellTags->"S1.1021"],
    Cell[42480, 1696, 75, 1, 70, "Notes",
      CellTags->"S1.1021"],
    Cell[42558, 1699, 315, 11, 70, "Notes",
      CellTags->"S1.1021"],
    Cell[42876, 1712, 305, 11, 70, "Notes",
      CellTags->"S1.1021"]},
  "S1.1022"->{
    Cell[43218, 1728, 50, 1, 70, "ObjectName",
      CellTags->"S1.1022"],
    Cell[43271, 1731, 115, 4, 70, "CharacterName",
      CellTags->"S1.1022"],
    Cell[43389, 1737, 150, 5, 70, "Notes",
      CellTags->"S1.1022"],
    Cell[43542, 1744, 87, 1, 70, "Notes",
      CellTags->"S1.1022"],
    Cell[43632, 1747, 125, 4, 70, "Notes",
      CellTags->"S1.1022"],
    Cell[43760, 1753, 188, 7, 70, "Notes",
      CellTags->"S1.1022"],
    Cell[43951, 1762, 543, 19, 70, "Notes",
      CellTags->"S1.1022"]},
  "S1.1023"->{
    Cell[44531, 1786, 51, 1, 70, "ObjectName",
      CellTags->"S1.1023"],
    Cell[44585, 1789, 117, 4, 70, "CharacterName",
      CellTags->"S1.1023"],
    Cell[44705, 1795, 150, 5, 70, "Notes",
      CellTags->"S1.1023"],
    Cell[44858, 1802, 87, 1, 70, "Notes",
      CellTags->"S1.1023"],
    Cell[44948, 1805, 317, 11, 70, "Notes",
      CellTags->"S1.1023"],
    Cell[45268, 1818, 337, 11, 70, "Notes",
      CellTags->"S1.1023"]},
  "S1.1024"->{
    Cell[45642, 1834, 51, 1, 70, "ObjectName",
      CellTags->"S1.1024"],
    Cell[45696, 1837, 117, 4, 70, "CharacterName",
      CellTags->"S1.1024"],
    Cell[45816, 1843, 150, 5, 70, "Notes",
      CellTags->"S1.1024"],
    Cell[45969, 1850, 69, 1, 70, "Notes",
      CellTags->"S1.1024"],
    Cell[46041, 1853, 94, 1, 70, "Notes",
      CellTags->"S1.1024"],
    Cell[46138, 1856, 188, 7, 70, "Notes",
      CellTags->"S1.1024"],
    Cell[46329, 1865, 209, 7, 70, "Notes",
      CellTags->"S1.1024"]},
  "S1.1025"->{
    Cell[46575, 1877, 48, 1, 70, "ObjectName",
      CellTags->"S1.1025"],
    Cell[46626, 1880, 111, 4, 70, "CharacterName",
      CellTags->"S1.1025"],
    Cell[46740, 1886, 77, 1, 70, "Notes",
      CellTags->"S1.1025"],
    Cell[46820, 1889, 376, 17, 70, "Notes",
      CellTags->"S1.1025"],
    Cell[47199, 1908, 117, 4, 70, "Notes",
      CellTags->"S1.1025"],
    Cell[47319, 1914, 128, 4, 70, "Notes",
      CellTags->"S1.1025"],
    Cell[47450, 1920, 188, 7, 70, "Notes",
      CellTags->"S1.1025"],
    Cell[47641, 1929, 531, 19, 70, "Notes",
      CellTags->"S1.1025"]},
  "S1.1026"->{
    Cell[48209, 1953, 58, 1, 70, "ObjectName",
      CellTags->"S1.1026"],
    Cell[48270, 1956, 131, 4, 70, "CharacterName",
      CellTags->"S1.1026"],
    Cell[48404, 1962, 150, 5, 70, "Notes",
      CellTags->"S1.1026"],
    Cell[48557, 1969, 69, 1, 70, "Notes",
      CellTags->"S1.1026"],
    Cell[48629, 1972, 94, 1, 70, "Notes",
      CellTags->"S1.1026"],
    Cell[48726, 1975, 188, 7, 70, "Notes",
      CellTags->"S1.1026"],
    Cell[48917, 1984, 195, 7, 70, "Notes",
      CellTags->"S1.1026"]},
  "S1.1027"->{
    Cell[49149, 1996, 56, 1, 70, "ObjectName",
      CellTags->"S1.1027"],
    Cell[49208, 1999, 127, 4, 70, "CharacterName",
      CellTags->"S1.1027"],
    Cell[49338, 2005, 150, 5, 70, "Notes",
      CellTags->"S1.1027"],
    Cell[49491, 2012, 69, 1, 70, "Notes",
      CellTags->"S1.1027"],
    Cell[49563, 2015, 94, 1, 70, "Notes",
      CellTags->"S1.1027"],
    Cell[49660, 2018, 188, 7, 70, "Notes",
      CellTags->"S1.1027"],
    Cell[49851, 2027, 191, 7, 70, "Notes",
      CellTags->"S1.1027"]},
  "S1.1028"->{
    Cell[50079, 2039, 56, 1, 70, "ObjectName",
      CellTags->"S1.1028"],
    Cell[50138, 2042, 127, 4, 70, "CharacterName",
      CellTags->"S1.1028"],
    Cell[50268, 2048, 150, 5, 70, "Notes",
      CellTags->"S1.1028"],
    Cell[50421, 2055, 69, 1, 70, "Notes",
      CellTags->"S1.1028"],
    Cell[50493, 2058, 94, 1, 70, "Notes",
      CellTags->"S1.1028"],
    Cell[50590, 2061, 120, 4, 70, "Notes",
      CellTags->"S1.1028"],
    Cell[50713, 2067, 188, 7, 70, "Notes",
      CellTags->"S1.1028"],
    Cell[50904, 2076, 191, 7, 70, "Notes",
      CellTags->"S1.1028"]},
  "S1.1029"->{
    Cell[51132, 2088, 62, 1, 70, "ObjectName",
      CellTags->"S1.1029"],
    Cell[51197, 2091, 139, 4, 70, "CharacterName",
      CellTags->"S1.1029"],
    Cell[51339, 2097, 151, 5, 70, "Notes",
      CellTags->"S1.1029"],
    Cell[51493, 2104, 69, 1, 70, "Notes",
      CellTags->"S1.1029"],
    Cell[51565, 2107, 94, 1, 70, "Notes",
      CellTags->"S1.1029"],
    Cell[51662, 2110, 316, 11, 70, "Notes",
      CellTags->"S1.1029"],
    Cell[51981, 2123, 203, 7, 70, "Notes",
      CellTags->"S1.1029"]},
  "S1.1030"->{
    Cell[52221, 2135, 54, 1, 70, "ObjectName",
      CellTags->"S1.1030"],
    Cell[52278, 2138, 123, 4, 70, "CharacterName",
      CellTags->"S1.1030"],
    Cell[52404, 2144, 150, 5, 70, "Notes",
      CellTags->"S1.1030"],
    Cell[52557, 2151, 69, 1, 70, "Notes",
      CellTags->"S1.1030"],
    Cell[52629, 2154, 94, 1, 70, "Notes",
      CellTags->"S1.1030"],
    Cell[52726, 2157, 188, 7, 70, "Notes",
      CellTags->"S1.1030"],
    Cell[52917, 2166, 187, 7, 70, "Notes",
      CellTags->"S1.1030"]},
  "S1.1031"->{
    Cell[53141, 2178, 58, 1, 70, "ObjectName",
      CellTags->"S1.1031"],
    Cell[53202, 2181, 131, 4, 70, "CharacterName",
      CellTags->"S1.1031"],
    Cell[53336, 2187, 150, 5, 70, "Notes",
      CellTags->"S1.1031"],
    Cell[53489, 2194, 69, 1, 70, "Notes",
      CellTags->"S1.1031"],
    Cell[53561, 2197, 94, 1, 70, "Notes",
      CellTags->"S1.1031"],
    Cell[53658, 2200, 188, 7, 70, "Notes",
      CellTags->"S1.1031"],
    Cell[53849, 2209, 195, 7, 70, "Notes",
      CellTags->"S1.1031"]},
  "S1.1032"->{
    Cell[54081, 2221, 56, 1, 70, "ObjectName",
      CellTags->"S1.1032"],
    Cell[54140, 2224, 127, 4, 70, "CharacterName",
      CellTags->"S1.1032"],
    Cell[54270, 2230, 150, 5, 70, "Notes",
      CellTags->"S1.1032"],
    Cell[54423, 2237, 69, 1, 70, "Notes",
      CellTags->"S1.1032"],
    Cell[54495, 2240, 94, 1, 70, "Notes",
      CellTags->"S1.1032"],
    Cell[54592, 2243, 188, 7, 70, "Notes",
      CellTags->"S1.1032"],
    Cell[54783, 2252, 191, 7, 70, "Notes",
      CellTags->"S1.1032"]},
  "S1.1033"->{
    Cell[55011, 2264, 57, 1, 70, "ObjectName",
      CellTags->"S1.1033"],
    Cell[55071, 2267, 129, 4, 70, "CharacterName",
      CellTags->"S1.1033"],
    Cell[55203, 2273, 220, 7, 70, "Notes",
      CellTags->"S1.1033"],
    Cell[55426, 2282, 75, 1, 70, "Notes",
      CellTags->"S1.1033"],
    Cell[55504, 2285, 132, 5, 70, "Notes",
      CellTags->"S1.1033"],
    Cell[55639, 2292, 316, 11, 70, "Notes",
      CellTags->"S1.1033"],
    Cell[55958, 2305, 193, 7, 70, "Notes",
      CellTags->"S1.1033"]},
  "S1.1034"->{
    Cell[56188, 2317, 57, 1, 70, "ObjectName",
      CellTags->"S1.1034"],
    Cell[56248, 2320, 129, 4, 70, "CharacterName",
      CellTags->"S1.1034"],
    Cell[56380, 2326, 150, 5, 70, "Notes",
      CellTags->"S1.1034"],
    Cell[56533, 2333, 69, 1, 70, "Notes",
      CellTags->"S1.1034"],
    Cell[56605, 2336, 94, 1, 70, "Notes",
      CellTags->"S1.1034"],
    Cell[56702, 2339, 205, 7, 70, "Notes",
      CellTags->"S1.1034"],
    Cell[56910, 2348, 316, 11, 70, "Notes",
      CellTags->"S1.1034"],
    Cell[57229, 2361, 193, 7, 70, "Notes",
      CellTags->"S1.1034"]},
  "S1.1035"->{
    Cell[57459, 2373, 58, 1, 70, "ObjectName",
      CellTags->"S1.1035"],
    Cell[57520, 2376, 131, 4, 70, "CharacterName",
      CellTags->"S1.1035"],
    Cell[57654, 2382, 214, 7, 70, "Notes",
      CellTags->"S1.1035"],
    Cell[57871, 2391, 69, 1, 70, "Notes",
      CellTags->"S1.1035"],
    Cell[57943, 2394, 94, 1, 70, "Notes",
      CellTags->"S1.1035"],
    Cell[58040, 2397, 188, 7, 70, "Notes",
      CellTags->"S1.1035"],
    Cell[58231, 2406, 195, 7, 70, "Notes",
      CellTags->"S1.1035"]},
  "S1.1036"->{
    Cell[58463, 2418, 56, 1, 70, "ObjectName",
      CellTags->"S1.1036"],
    Cell[58522, 2421, 127, 4, 70, "CharacterName",
      CellTags->"S1.1036"],
    Cell[58652, 2427, 219, 7, 70, "Notes",
      CellTags->"S1.1036"],
    Cell[58874, 2436, 75, 1, 70, "Notes",
      CellTags->"S1.1036"],
    Cell[58952, 2439, 167, 7, 70, "Notes",
      CellTags->"S1.1036"],
    Cell[59122, 2448, 132, 5, 70, "Notes",
      CellTags->"S1.1036"],
    Cell[59257, 2455, 187, 7, 70, "Notes",
      CellTags->"S1.1036"],
    Cell[59447, 2464, 191, 7, 70, "Notes",
      CellTags->"S1.1036"]},
  "S1.1037"->{
    Cell[59675, 2476, 58, 1, 70, "ObjectName",
      CellTags->"S1.1037"],
    Cell[59736, 2479, 131, 4, 70, "CharacterName",
      CellTags->"S1.1037"],
    Cell[59870, 2485, 150, 5, 70, "Notes",
      CellTags->"S1.1037"],
    Cell[60023, 2492, 69, 1, 70, "Notes",
      CellTags->"S1.1037"],
    Cell[60095, 2495, 94, 1, 70, "Notes",
      CellTags->"S1.1037"],
    Cell[60192, 2498, 188, 7, 70, "Notes",
      CellTags->"S1.1037"],
    Cell[60383, 2507, 195, 7, 70, "Notes",
      CellTags->"S1.1037"]},
  "S1.1038"->{
    Cell[60615, 2519, 60, 1, 70, "ObjectName",
      CellTags->"S1.1038"],
    Cell[60678, 2522, 135, 4, 70, "CharacterName",
      CellTags->"S1.1038"],
    Cell[60816, 2528, 150, 5, 70, "Notes",
      CellTags->"S1.1038"],
    Cell[60969, 2535, 69, 1, 70, "Notes",
      CellTags->"S1.1038"],
    Cell[61041, 2538, 94, 1, 70, "Notes",
      CellTags->"S1.1038"],
    Cell[61138, 2541, 188, 7, 70, "Notes",
      CellTags->"S1.1038"],
    Cell[61329, 2550, 199, 7, 70, "Notes",
      CellTags->"S1.1038"]},
  "S1.1039"->{
    Cell[61565, 2562, 58, 1, 70, "ObjectName",
      CellTags->"S1.1039"],
    Cell[61626, 2565, 131, 4, 70, "CharacterName",
      CellTags->"S1.1039"],
    Cell[61760, 2571, 150, 5, 70, "Notes",
      CellTags->"S1.1039"],
    Cell[61913, 2578, 69, 1, 70, "Notes",
      CellTags->"S1.1039"],
    Cell[61985, 2581, 94, 1, 70, "Notes",
      CellTags->"S1.1039"],
    Cell[62082, 2584, 188, 7, 70, "Notes",
      CellTags->"S1.1039"],
    Cell[62273, 2593, 195, 7, 70, "Notes",
      CellTags->"S1.1039"]},
  "S1.1040"->{
    Cell[62505, 2605, 55, 1, 70, "ObjectName",
      CellTags->"S1.1040"],
    Cell[62563, 2608, 125, 4, 70, "CharacterName",
      CellTags->"S1.1040"],
    Cell[62691, 2614, 284, 9, 70, "Notes",
      CellTags->"S1.1040"],
    Cell[62978, 2625, 75, 1, 70, "Notes",
      CellTags->"S1.1040"],
    Cell[63056, 2628, 132, 5, 70, "Notes",
      CellTags->"S1.1040"],
    Cell[63191, 2635, 315, 11, 70, "Notes",
      CellTags->"S1.1040"],
    Cell[63509, 2648, 303, 11, 70, "Notes",
      CellTags->"S1.1040"]},
  "S1.1041"->{
    Cell[63849, 2664, 57, 1, 70, "ObjectName",
      CellTags->"S1.1041"],
    Cell[63909, 2667, 129, 4, 70, "CharacterName",
      CellTags->"S1.1041"],
    Cell[64041, 2673, 220, 7, 70, "Notes",
      CellTags->"S1.1041"],
    Cell[64264, 2682, 75, 1, 70, "Notes",
      CellTags->"S1.1041"],
    Cell[64342, 2685, 219, 7, 70, "Notes",
      CellTags->"S1.1041"],
    Cell[64564, 2694, 122, 4, 70, "Notes",
      CellTags->"S1.1041"],
    Cell[64689, 2700, 315, 11, 70, "Notes",
      CellTags->"S1.1041"],
    Cell[65007, 2713, 295, 11, 70, "Notes",
      CellTags->"S1.1041"]},
  "S1.1042"->{
    Cell[65339, 2729, 65, 1, 70, "ObjectName",
      CellTags->"S1.1042"],
    Cell[65407, 2732, 145, 4, 70, "CharacterName",
      CellTags->"S1.1042"],
    Cell[65555, 2738, 150, 5, 70, "Notes",
      CellTags->"S1.1042"],
    Cell[65708, 2745, 80, 1, 70, "Notes",
      CellTags->"S1.1042"],
    Cell[65791, 2748, 338, 9, 70, "Notes",
      CellTags->"S1.1042"],
    Cell[66132, 2759, 130, 4, 70, "Notes",
      CellTags->"S1.1042"],
    Cell[66265, 2765, 188, 7, 70, "Notes",
      CellTags->"S1.1042"],
    Cell[66456, 2774, 331, 11, 70, "Notes",
      CellTags->"S1.1042"]},
  "S1.1043"->{
    Cell[66824, 2790, 59, 1, 70, "ObjectName",
      CellTags->"S1.1043"],
    Cell[66886, 2793, 133, 4, 70, "CharacterName",
      CellTags->"S1.1043"],
    Cell[67022, 2799, 223, 7, 70, "Notes",
      CellTags->"S1.1043"],
    Cell[67248, 2808, 83, 1, 70, "Notes",
      CellTags->"S1.1043"],
    Cell[67334, 2811, 129, 5, 70, "Notes",
      CellTags->"S1.1043"],
    Cell[67466, 2818, 187, 7, 70, "Notes",
      CellTags->"S1.1043"],
    Cell[67656, 2827, 197, 7, 70, "Notes",
      CellTags->"S1.1043"]},
  "S1.1044"->{
    Cell[67890, 2839, 58, 1, 70, "ObjectName",
      CellTags->"S1.1044"],
    Cell[67951, 2842, 131, 4, 70, "CharacterName",
      CellTags->"S1.1044"],
    Cell[68085, 2848, 150, 5, 70, "Notes",
      CellTags->"S1.1044"],
    Cell[68238, 2855, 69, 1, 70, "Notes",
      CellTags->"S1.1044"],
    Cell[68310, 2858, 94, 1, 70, "Notes",
      CellTags->"S1.1044"],
    Cell[68407, 2861, 188, 7, 70, "Notes",
      CellTags->"S1.1044"],
    Cell[68598, 2870, 195, 7, 70, "Notes",
      CellTags->"S1.1044"]},
  "S1.1045"->{
    Cell[68830, 2882, 56, 1, 70, "ObjectName",
      CellTags->"S1.1045"],
    Cell[68889, 2885, 127, 4, 70, "CharacterName",
      CellTags->"S1.1045"],
    Cell[69019, 2891, 150, 5, 70, "Notes",
      CellTags->"S1.1045"],
    Cell[69172, 2898, 69, 1, 70, "Notes",
      CellTags->"S1.1045"],
    Cell[69244, 2901, 94, 1, 70, "Notes",
      CellTags->"S1.1045"],
    Cell[69341, 2904, 188, 7, 70, "Notes",
      CellTags->"S1.1045"],
    Cell[69532, 2913, 191, 7, 70, "Notes",
      CellTags->"S1.1045"]},
  "S1.1046"->{
    Cell[69760, 2925, 56, 1, 70, "ObjectName",
      CellTags->"S1.1046"],
    Cell[69819, 2928, 127, 4, 70, "CharacterName",
      CellTags->"S1.1046"],
    Cell[69949, 2934, 150, 5, 70, "Notes",
      CellTags->"S1.1046"],
    Cell[70102, 2941, 69, 1, 70, "Notes",
      CellTags->"S1.1046"],
    Cell[70174, 2944, 88, 1, 70, "Notes",
      CellTags->"S1.1046"],
    Cell[70265, 2947, 188, 7, 70, "Notes",
      CellTags->"S1.1046"],
    Cell[70456, 2956, 191, 7, 70, "Notes",
      CellTags->"S1.1046"]},
  "S1.1047"->{
    Cell[70684, 2968, 62, 1, 70, "ObjectName",
      CellTags->"S1.1047"],
    Cell[70749, 2971, 139, 4, 70, "CharacterName",
      CellTags->"S1.1047"],
    Cell[70891, 2977, 151, 5, 70, "Notes",
      CellTags->"S1.1047"],
    Cell[71045, 2984, 69, 1, 70, "Notes",
      CellTags->"S1.1047"],
    Cell[71117, 2987, 94, 1, 70, "Notes",
      CellTags->"S1.1047"],
    Cell[71214, 2990, 188, 7, 70, "Notes",
      CellTags->"S1.1047"],
    Cell[71405, 2999, 203, 7, 70, "Notes",
      CellTags->"S1.1047"]},
  "S1.1048"->{
    Cell[71645, 3011, 58, 1, 70, "ObjectName",
      CellTags->"S1.1048"],
    Cell[71706, 3014, 131, 4, 70, "CharacterName",
      CellTags->"S1.1048"],
    Cell[71840, 3020, 150, 5, 70, "Notes",
      CellTags->"S1.1048"],
    Cell[71993, 3027, 69, 1, 70, "Notes",
      CellTags->"S1.1048"],
    Cell[72065, 3030, 94, 1, 70, "Notes",
      CellTags->"S1.1048"],
    Cell[72162, 3033, 188, 7, 70, "Notes",
      CellTags->"S1.1048"],
    Cell[72353, 3042, 195, 7, 70, "Notes",
      CellTags->"S1.1048"]},
  "S1.1049"->{
    Cell[72585, 3054, 56, 1, 70, "ObjectName",
      CellTags->"S1.1049"],
    Cell[72644, 3057, 127, 4, 70, "CharacterName",
      CellTags->"S1.1049"],
    Cell[72774, 3063, 150, 5, 70, "Notes",
      CellTags->"S1.1049"],
    Cell[72927, 3070, 69, 1, 70, "Notes",
      CellTags->"S1.1049"],
    Cell[72999, 3073, 94, 1, 70, "Notes",
      CellTags->"S1.1049"],
    Cell[73096, 3076, 188, 7, 70, "Notes",
      CellTags->"S1.1049"],
    Cell[73287, 3085, 191, 7, 70, "Notes",
      CellTags->"S1.1049"]},
  "S1.1050"->{
    Cell[73515, 3097, 59, 1, 70, "ObjectName",
      CellTags->"S1.1050"],
    Cell[73577, 3100, 133, 4, 70, "CharacterName",
      CellTags->"S1.1050"],
    Cell[73713, 3106, 222, 7, 70, "Notes",
      CellTags->"S1.1050"],
    Cell[73938, 3115, 75, 1, 70, "Notes",
      CellTags->"S1.1050"],
    Cell[74016, 3118, 132, 5, 70, "Notes",
      CellTags->"S1.1050"],
    Cell[74151, 3125, 187, 7, 70, "Notes",
      CellTags->"S1.1050"],
    Cell[74341, 3134, 197, 7, 70, "Notes",
      CellTags->"S1.1050"]},
  "S1.1051"->{
    Cell[74575, 3146, 55, 1, 70, "ObjectName",
      CellTags->"S1.1051"],
    Cell[74633, 3149, 125, 4, 70, "CharacterName",
      CellTags->"S1.1051"],
    Cell[74761, 3155, 284, 9, 70, "Notes",
      CellTags->"S1.1051"],
    Cell[75048, 3166, 75, 1, 70, "Notes",
      CellTags->"S1.1051"],
    Cell[75126, 3169, 132, 5, 70, "Notes",
      CellTags->"S1.1051"],
    Cell[75261, 3176, 187, 7, 70, "Notes",
      CellTags->"S1.1051"],
    Cell[75451, 3185, 189, 7, 70, "Notes",
      CellTags->"S1.1051"]},
  "S1.1052"->{
    Cell[75677, 3197, 55, 1, 70, "ObjectName",
      CellTags->"S1.1052"],
    Cell[75735, 3200, 125, 4, 70, "CharacterName",
      CellTags->"S1.1052"],
    Cell[75863, 3206, 150, 5, 70, "Notes",
      CellTags->"S1.1052"],
    Cell[76016, 3213, 69, 1, 70, "Notes",
      CellTags->"S1.1052"],
    Cell[76088, 3216, 94, 1, 70, "Notes",
      CellTags->"S1.1052"],
    Cell[76185, 3219, 188, 7, 70, "Notes",
      CellTags->"S1.1052"],
    Cell[76376, 3228, 189, 7, 70, "Notes",
      CellTags->"S1.1052"]},
  "S1.1053"->{
    Cell[76602, 3240, 57, 1, 70, "ObjectName",
      CellTags->"S1.1053"],
    Cell[76662, 3243, 129, 4, 70, "CharacterName",
      CellTags->"S1.1053"],
    Cell[76794, 3249, 220, 7, 70, "Notes",
      CellTags->"S1.1053"],
    Cell[77017, 3258, 75, 1, 70, "Notes",
      CellTags->"S1.1053"],
    Cell[77095, 3261, 168, 7, 70, "Notes",
      CellTags->"S1.1053"],
    Cell[77266, 3270, 315, 11, 70, "Notes",
      CellTags->"S1.1053"],
    Cell[77584, 3283, 317, 11, 70, "Notes",
      CellTags->"S1.1053"]},
  "S1.1054"->{
    Cell[77938, 3299, 58, 1, 70, "ObjectName",
      CellTags->"S1.1054"],
    Cell[77999, 3302, 131, 4, 70, "CharacterName",
      CellTags->"S1.1054"],
    Cell[78133, 3308, 150, 5, 70, "Notes",
      CellTags->"S1.1054"],
    Cell[78286, 3315, 69, 1, 70, "Notes",
      CellTags->"S1.1054"],
    Cell[78358, 3318, 94, 1, 70, "Notes",
      CellTags->"S1.1054"],
    Cell[78455, 3321, 188, 7, 70, "Notes",
      CellTags->"S1.1054"],
    Cell[78646, 3330, 195, 7, 70, "Notes",
      CellTags->"S1.1054"]},
  "S1.1055"->{
    Cell[78878, 3342, 56, 1, 70, "ObjectName",
      CellTags->"S1.1055"],
    Cell[78937, 3345, 127, 4, 70, "CharacterName",
      CellTags->"S1.1055"],
    Cell[79067, 3351, 150, 5, 70, "Notes",
      CellTags->"S1.1055"],
    Cell[79220, 3358, 69, 1, 70, "Notes",
      CellTags->"S1.1055"],
    Cell[79292, 3361, 94, 1, 70, "Notes",
      CellTags->"S1.1055"],
    Cell[79389, 3364, 188, 7, 70, "Notes",
      CellTags->"S1.1055"],
    Cell[79580, 3373, 191, 7, 70, "Notes",
      CellTags->"S1.1055"]},
  "S1.1056"->{
    Cell[79808, 3385, 62, 1, 70, "ObjectName",
      CellTags->"S1.1056"],
    Cell[79873, 3388, 139, 4, 70, "CharacterName",
      CellTags->"S1.1056"],
    Cell[80015, 3394, 151, 5, 70, "Notes",
      CellTags->"S1.1056"],
    Cell[80169, 3401, 69, 1, 70, "Notes",
      CellTags->"S1.1056"],
    Cell[80241, 3404, 94, 1, 70, "Notes",
      CellTags->"S1.1056"],
    Cell[80338, 3407, 188, 7, 70, "Notes",
      CellTags->"S1.1056"],
    Cell[80529, 3416, 203, 7, 70, "Notes",
      CellTags->"S1.1056"]},
  "S1.1057"->{
    Cell[80769, 3428, 58, 1, 70, "ObjectName",
      CellTags->"S1.1057"],
    Cell[80830, 3431, 131, 4, 70, "CharacterName",
      CellTags->"S1.1057"],
    Cell[80964, 3437, 150, 5, 70, "Notes",
      CellTags->"S1.1057"],
    Cell[81117, 3444, 69, 1, 70, "Notes",
      CellTags->"S1.1057"],
    Cell[81189, 3447, 94, 1, 70, "Notes",
      CellTags->"S1.1057"],
    Cell[81286, 3450, 188, 7, 70, "Notes",
      CellTags->"S1.1057"],
    Cell[81477, 3459, 195, 7, 70, "Notes",
      CellTags->"S1.1057"]},
  "S1.1058"->{
    Cell[81709, 3471, 56, 1, 70, "ObjectName",
      CellTags->"S1.1058"],
    Cell[81768, 3474, 127, 4, 70, "CharacterName",
      CellTags->"S1.1058"],
    Cell[81898, 3480, 150, 5, 70, "Notes",
      CellTags->"S1.1058"],
    Cell[82051, 3487, 69, 1, 70, "Notes",
      CellTags->"S1.1058"],
    Cell[82123, 3490, 94, 1, 70, "Notes",
      CellTags->"S1.1058"],
    Cell[82220, 3493, 188, 7, 70, "Notes",
      CellTags->"S1.1058"],
    Cell[82411, 3502, 191, 7, 70, "Notes",
      CellTags->"S1.1058"]},
  "S1.1059"->{
    Cell[82639, 3514, 56, 1, 70, "ObjectName",
      CellTags->"S1.1059"],
    Cell[82698, 3517, 127, 4, 70, "CharacterName",
      CellTags->"S1.1059"],
    Cell[82828, 3523, 219, 7, 70, "Notes",
      CellTags->"S1.1059"],
    Cell[83050, 3532, 75, 1, 70, "Notes",
      CellTags->"S1.1059"],
    Cell[83128, 3535, 132, 5, 70, "Notes",
      CellTags->"S1.1059"],
    Cell[83263, 3542, 187, 7, 70, "Notes",
      CellTags->"S1.1059"],
    Cell[83453, 3551, 191, 7, 70, "Notes",
      CellTags->"S1.1059"]},
  "S1.1060"->{
    Cell[83681, 3563, 57, 1, 70, "ObjectName",
      CellTags->"S1.1060"],
    Cell[83741, 3566, 129, 4, 70, "CharacterName",
      CellTags->"S1.1060"],
    Cell[83873, 3572, 220, 7, 70, "Notes",
      CellTags->"S1.1060"],
    Cell[84096, 3581, 75, 1, 70, "Notes",
      CellTags->"S1.1060"],
    Cell[84174, 3584, 132, 5, 70, "Notes",
      CellTags->"S1.1060"],
    Cell[84309, 3591, 187, 7, 70, "Notes",
      CellTags->"S1.1060"],
    Cell[84499, 3600, 193, 7, 70, "Notes",
      CellTags->"S1.1060"]},
  "S1.1061"->{
    Cell[84729, 3612, 57, 1, 70, "ObjectName",
      CellTags->"S1.1061"],
    Cell[84789, 3615, 129, 4, 70, "CharacterName",
      CellTags->"S1.1061"],
    Cell[84921, 3621, 221, 7, 70, "Notes",
      CellTags->"S1.1061"],
    Cell[85145, 3630, 83, 1, 70, "Notes",
      CellTags->"S1.1061"],
    Cell[85231, 3633, 129, 5, 70, "Notes",
      CellTags->"S1.1061"],
    Cell[85363, 3640, 187, 7, 70, "Notes",
      CellTags->"S1.1061"],
    Cell[85553, 3649, 193, 7, 70, "Notes",
      CellTags->"S1.1061"]},
  "S1.1062"->{
    Cell[85783, 3661, 58, 1, 70, "ObjectName",
      CellTags->"S1.1062"],
    Cell[85844, 3664, 131, 4, 70, "CharacterName",
      CellTags->"S1.1062"],
    Cell[85978, 3670, 221, 7, 70, "Notes",
      CellTags->"S1.1062"],
    Cell[86202, 3679, 75, 1, 70, "Notes",
      CellTags->"S1.1062"],
    Cell[86280, 3682, 199, 7, 70, "Notes",
      CellTags->"S1.1062"],
    Cell[86482, 3691, 315, 11, 70, "Notes",
      CellTags->"S1.1062"],
    Cell[86800, 3704, 195, 7, 70, "Notes",
      CellTags->"S1.1062"]},
  "S1.1063"->{
    Cell[87032, 3716, 58, 1, 70, "ObjectName",
      CellTags->"S1.1063"],
    Cell[87093, 3719, 131, 4, 70, "CharacterName",
      CellTags->"S1.1063"],
    Cell[87227, 3725, 150, 5, 70, "Notes",
      CellTags->"S1.1063"],
    Cell[87380, 3732, 69, 1, 70, "Notes",
      CellTags->"S1.1063"],
    Cell[87452, 3735, 94, 1, 70, "Notes",
      CellTags->"S1.1063"],
    Cell[87549, 3738, 188, 7, 70, "Notes",
      CellTags->"S1.1063"],
    Cell[87740, 3747, 195, 7, 70, "Notes",
      CellTags->"S1.1063"]},
  "S1.1064"->{
    Cell[87972, 3759, 54, 1, 70, "ObjectName",
      CellTags->"S1.1064"],
    Cell[88029, 3762, 123, 4, 70, "CharacterName",
      CellTags->"S1.1064"],
    Cell[88155, 3768, 217, 7, 70, "Notes",
      CellTags->"S1.1064"],
    Cell[88375, 3777, 75, 1, 70, "Notes",
      CellTags->"S1.1064"],
    Cell[88453, 3780, 132, 5, 70, "Notes",
      CellTags->"S1.1064"],
    Cell[88588, 3787, 187, 7, 70, "Notes",
      CellTags->"S1.1064"],
    Cell[88778, 3796, 187, 7, 70, "Notes",
      CellTags->"S1.1064"]},
  "S1.1065"->{
    Cell[89002, 3808, 58, 1, 70, "ObjectName",
      CellTags->"S1.1065"],
    Cell[89063, 3811, 131, 4, 70, "CharacterName",
      CellTags->"S1.1065"],
    Cell[89197, 3817, 214, 7, 70, "Notes",
      CellTags->"S1.1065"],
    Cell[89414, 3826, 69, 1, 70, "Notes",
      CellTags->"S1.1065"],
    Cell[89486, 3829, 94, 1, 70, "Notes",
      CellTags->"S1.1065"],
    Cell[89583, 3832, 188, 7, 70, "Notes",
      CellTags->"S1.1065"],
    Cell[89774, 3841, 195, 7, 70, "Notes",
      CellTags->"S1.1065"]},
  "S1.1066"->{
    Cell[90006, 3853, 54, 1, 70, "ObjectName",
      CellTags->"S1.1066"],
    Cell[90063, 3856, 123, 4, 70, "CharacterName",
      CellTags->"S1.1066"],
    Cell[90189, 3862, 217, 7, 70, "Notes",
      CellTags->"S1.1066"],
    Cell[90409, 3871, 75, 1, 70, "Notes",
      CellTags->"S1.1066"],
    Cell[90487, 3874, 132, 5, 70, "Notes",
      CellTags->"S1.1066"],
    Cell[90622, 3881, 187, 7, 70, "Notes",
      CellTags->"S1.1066"],
    Cell[90812, 3890, 187, 7, 70, "Notes",
      CellTags->"S1.1066"]},
  "S1.1067"->{
    Cell[91036, 3902, 58, 1, 70, "ObjectName",
      CellTags->"S1.1067"],
    Cell[91097, 3905, 131, 4, 70, "CharacterName",
      CellTags->"S1.1067"],
    Cell[91231, 3911, 150, 5, 70, "Notes",
      CellTags->"S1.1067"],
    Cell[91384, 3918, 69, 1, 70, "Notes",
      CellTags->"S1.1067"],
    Cell[91456, 3921, 94, 1, 70, "Notes",
      CellTags->"S1.1067"],
    Cell[91553, 3924, 188, 7, 70, "Notes",
      CellTags->"S1.1067"],
    Cell[91744, 3933, 195, 7, 70, "Notes",
      CellTags->"S1.1067"]},
  "S1.1068"->{
    Cell[91976, 3945, 64, 1, 70, "ObjectName",
      CellTags->"S1.1068"],
    Cell[92043, 3948, 143, 4, 70, "CharacterName",
      CellTags->"S1.1068"],
    Cell[92189, 3954, 151, 5, 70, "Notes",
      CellTags->"S1.1068"],
    Cell[92343, 3961, 69, 1, 70, "Notes",
      CellTags->"S1.1068"],
    Cell[92415, 3964, 94, 1, 70, "Notes",
      CellTags->"S1.1068"],
    Cell[92512, 3967, 188, 7, 70, "Notes",
      CellTags->"S1.1068"],
    Cell[92703, 3976, 207, 7, 70, "Notes",
      CellTags->"S1.1068"]},
  "S1.1069"->{
    Cell[92947, 3988, 62, 1, 70, "ObjectName",
      CellTags->"S1.1069"],
    Cell[93012, 3991, 139, 4, 70, "CharacterName",
      CellTags->"S1.1069"],
    Cell[93154, 3997, 151, 5, 70, "Notes",
      CellTags->"S1.1069"],
    Cell[93308, 4004, 69, 1, 70, "Notes",
      CellTags->"S1.1069"],
    Cell[93380, 4007, 94, 1, 70, "Notes",
      CellTags->"S1.1069"],
    Cell[93477, 4010, 316, 11, 70, "Notes",
      CellTags->"S1.1069"],
    Cell[93796, 4023, 203, 7, 70, "Notes",
      CellTags->"S1.1069"]},
  "S1.1070"->{
    Cell[94036, 4035, 58, 1, 70, "ObjectName",
      CellTags->"S1.1070"],
    Cell[94097, 4038, 131, 4, 70, "CharacterName",
      CellTags->"S1.1070"],
    Cell[94231, 4044, 150, 5, 70, "Notes",
      CellTags->"S1.1070"],
    Cell[94384, 4051, 69, 1, 70, "Notes",
      CellTags->"S1.1070"],
    Cell[94456, 4054, 94, 1, 70, "Notes",
      CellTags->"S1.1070"],
    Cell[94553, 4057, 188, 7, 70, "Notes",
      CellTags->"S1.1070"],
    Cell[94744, 4066, 195, 7, 70, "Notes",
      CellTags->"S1.1070"]},
  "S1.1071"->{
    Cell[94976, 4078, 56, 1, 70, "ObjectName",
      CellTags->"S1.1071"],
    Cell[95035, 4081, 127, 4, 70, "CharacterName",
      CellTags->"S1.1071"],
    Cell[95165, 4087, 150, 5, 70, "Notes",
      CellTags->"S1.1071"],
    Cell[95318, 4094, 69, 1, 70, "Notes",
      CellTags->"S1.1071"],
    Cell[95390, 4097, 94, 1, 70, "Notes",
      CellTags->"S1.1071"],
    Cell[95487, 4100, 188, 7, 70, "Notes",
      CellTags->"S1.1071"],
    Cell[95678, 4109, 191, 7, 70, "Notes",
      CellTags->"S1.1071"]},
  "S1.1072"->{
    Cell[95906, 4121, 57, 1, 70, "ObjectName",
      CellTags->"S1.1072"],
    Cell[95966, 4124, 129, 4, 70, "CharacterName",
      CellTags->"S1.1072"],
    Cell[96098, 4130, 285, 9, 70, "Notes",
      CellTags->"S1.1072"],
    Cell[96386, 4141, 75, 1, 70, "Notes",
      CellTags->"S1.1072"],
    Cell[96464, 4144, 98, 3, 70, "Notes",
      CellTags->"S1.1072"],
    Cell[96565, 4149, 315, 11, 70, "Notes",
      CellTags->"S1.1072"],
    Cell[96883, 4162, 295, 11, 70, "Notes",
      CellTags->"S1.1072"]},
  "S1.1073"->{
    Cell[97215, 4178, 59, 1, 70, "ObjectName",
      CellTags->"S1.1073"],
    Cell[97277, 4181, 133, 4, 70, "CharacterName",
      CellTags->"S1.1073"],
    Cell[97413, 4187, 223, 7, 70, "Notes",
      CellTags->"S1.1073"],
    Cell[97639, 4196, 75, 1, 70, "Notes",
      CellTags->"S1.1073"],
    Cell[97717, 4199, 132, 5, 70, "Notes",
      CellTags->"S1.1073"],
    Cell[97852, 4206, 187, 7, 70, "Notes",
      CellTags->"S1.1073"],
    Cell[98042, 4215, 197, 7, 70, "Notes",
      CellTags->"S1.1073"]},
  "S1.1074"->{
    Cell[98276, 4227, 58, 1, 70, "ObjectName",
      CellTags->"S1.1074"],
    Cell[98337, 4230, 131, 4, 70, "CharacterName",
      CellTags->"S1.1074"],
    Cell[98471, 4236, 150, 5, 70, "Notes",
      CellTags->"S1.1074"],
    Cell[98624, 4243, 69, 1, 70, "Notes",
      CellTags->"S1.1074"],
    Cell[98696, 4246, 94, 1, 70, "Notes",
      CellTags->"S1.1074"],
    Cell[98793, 4249, 319, 11, 70, "Notes",
      CellTags->"S1.1074"],
    Cell[99115, 4262, 317, 11, 70, "Notes",
      CellTags->"S1.1074"],
    Cell[99435, 4275, 195, 7, 70, "Notes",
      CellTags->"S1.1074"]},
  "S1.1075"->{
    Cell[99667, 4287, 58, 1, 70, "ObjectName",
      CellTags->"S1.1075"],
    Cell[99728, 4290, 131, 4, 70, "CharacterName",
      CellTags->"S1.1075"],
    Cell[99862, 4296, 214, 7, 70, "Notes",
      CellTags->"S1.1075"],
    Cell[100079, 4305, 69, 1, 70, "Notes",
      CellTags->"S1.1075"],
    Cell[100151, 4308, 94, 1, 70, "Notes",
      CellTags->"S1.1075"],
    Cell[100248, 4311, 188, 7, 70, "Notes",
      CellTags->"S1.1075"],
    Cell[100439, 4320, 195, 7, 70, "Notes",
      CellTags->"S1.1075"]},
  "S1.1076"->{
    Cell[100671, 4332, 55, 1, 70, "ObjectName",
      CellTags->"S1.1076"],
    Cell[100729, 4335, 125, 4, 70, "CharacterName",
      CellTags->"S1.1076"],
    Cell[100857, 4341, 284, 9, 70, "Notes",
      CellTags->"S1.1076"],
    Cell[101144, 4352, 75, 1, 70, "Notes",
      CellTags->"S1.1076"],
    Cell[101222, 4355, 171, 7, 70, "Notes",
      CellTags->"S1.1076"],
    Cell[101396, 4364, 315, 11, 70, "Notes",
      CellTags->"S1.1076"],
    Cell[101714, 4377, 189, 7, 70, "Notes",
      CellTags->"S1.1076"]},
  "S1.1077"->{
    Cell[101940, 4389, 54, 1, 70, "ObjectName",
      CellTags->"S1.1077"],
    Cell[101997, 4392, 123, 4, 70, "CharacterName",
      CellTags->"S1.1077"],
    Cell[102123, 4398, 217, 7, 70, "Notes",
      CellTags->"S1.1077"],
    Cell[102343, 4407, 75, 1, 70, "Notes",
      CellTags->"S1.1077"],
    Cell[102421, 4410, 173, 7, 70, "Notes",
      CellTags->"S1.1077"],
    Cell[102597, 4419, 203, 7, 70, "Notes",
      CellTags->"S1.1077"],
    Cell[102803, 4428, 315, 11, 70, "Notes",
      CellTags->"S1.1077"],
    Cell[103121, 4441, 187, 7, 70, "Notes",
      CellTags->"S1.1077"]},
  "S1.1078"->{
    Cell[103345, 4453, 55, 1, 70, "ObjectName",
      CellTags->"S1.1078"],
    Cell[103403, 4456, 125, 4, 70, "CharacterName",
      CellTags->"S1.1078"],
    Cell[103531, 4462, 284, 9, 70, "Notes",
      CellTags->"S1.1078"],
    Cell[103818, 4473, 75, 1, 70, "Notes",
      CellTags->"S1.1078"],
    Cell[103896, 4476, 315, 11, 70, "Notes",
      CellTags->"S1.1078"],
    Cell[104214, 4489, 189, 7, 70, "Notes",
      CellTags->"S1.1078"]},
  "S1.1079"->{
    Cell[104440, 4501, 55, 1, 70, "ObjectName",
      CellTags->"S1.1079"],
    Cell[104498, 4504, 125, 4, 70, "CharacterName",
      CellTags->"S1.1079"],
    Cell[104626, 4510, 218, 7, 70, "Notes",
      CellTags->"S1.1079"],
    Cell[104847, 4519, 75, 1, 70, "Notes",
      CellTags->"S1.1079"],
    Cell[104925, 4522, 132, 5, 70, "Notes",
      CellTags->"S1.1079"],
    Cell[105060, 4529, 187, 7, 70, "Notes",
      CellTags->"S1.1079"],
    Cell[105250, 4538, 189, 7, 70, "Notes",
      CellTags->"S1.1079"]},
  "S1.1080"->{
    Cell[105476, 4550, 57, 1, 70, "ObjectName",
      CellTags->"S1.1080"],
    Cell[105536, 4553, 129, 4, 70, "CharacterName",
      CellTags->"S1.1080"],
    Cell[105668, 4559, 221, 7, 70, "Notes",
      CellTags->"S1.1080"],
    Cell[105892, 4568, 83, 1, 70, "Notes",
      CellTags->"S1.1080"],
    Cell[105978, 4571, 187, 7, 70, "Notes",
      CellTags->"S1.1080"],
    Cell[106168, 4580, 193, 7, 70, "Notes",
      CellTags->"S1.1080"]},
  "S1.1081"->{
    Cell[106398, 4592, 58, 1, 70, "ObjectName",
      CellTags->"S1.1081"],
    Cell[106459, 4595, 131, 4, 70, "CharacterName",
      CellTags->"S1.1081"],
    Cell[106593, 4601, 150, 5, 70, "Notes",
      CellTags->"S1.1081"],
    Cell[106746, 4608, 69, 1, 70, "Notes",
      CellTags->"S1.1081"],
    Cell[106818, 4611, 94, 1, 70, "Notes",
      CellTags->"S1.1081"],
    Cell[106915, 4614, 188, 7, 70, "Notes",
      CellTags->"S1.1081"],
    Cell[107106, 4623, 195, 7, 70, "Notes",
      CellTags->"S1.1081"]},
  "S1.1082"->{
    Cell[107338, 4635, 57, 1, 70, "ObjectName",
      CellTags->"S1.1082"],
    Cell[107398, 4638, 129, 4, 70, "CharacterName",
      CellTags->"S1.1082"],
    Cell[107530, 4644, 220, 7, 70, "Notes",
      CellTags->"S1.1082"],
    Cell[107753, 4653, 75, 1, 70, "Notes",
      CellTags->"S1.1082"],
    Cell[107831, 4656, 195, 7, 70, "Notes",
      CellTags->"S1.1082"],
    Cell[108029, 4665, 315, 11, 70, "Notes",
      CellTags->"S1.1082"],
    Cell[108347, 4678, 193, 7, 70, "Notes",
      CellTags->"S1.1082"]},
  "S1.1083"->{
    Cell[108577, 4690, 58, 1, 70, "ObjectName",
      CellTags->"S1.1083"],
    Cell[108638, 4693, 131, 4, 70, "CharacterName",
      CellTags->"S1.1083"],
    Cell[108772, 4699, 223, 7, 70, "Notes",
      CellTags->"S1.1083"],
    Cell[108998, 4708, 83, 1, 70, "Notes",
      CellTags->"S1.1083"],
    Cell[109084, 4711, 187, 7, 70, "Notes",
      CellTags->"S1.1083"],
    Cell[109274, 4720, 195, 7, 70, "Notes",
      CellTags->"S1.1083"]},
  "S1.1084"->{
    Cell[109506, 4732, 55, 1, 70, "ObjectName",
      CellTags->"S1.1084"],
    Cell[109564, 4735, 125, 4, 70, "CharacterName",
      CellTags->"S1.1084"],
    Cell[109692, 4741, 218, 7, 70, "Notes",
      CellTags->"S1.1084"],
    Cell[109913, 4750, 75, 1, 70, "Notes",
      CellTags->"S1.1084"],
    Cell[109991, 4753, 132, 5, 70, "Notes",
      CellTags->"S1.1084"],
    Cell[110126, 4760, 187, 7, 70, "Notes",
      CellTags->"S1.1084"],
    Cell[110316, 4769, 189, 7, 70, "Notes",
      CellTags->"S1.1084"]},
  "S1.1085"->{
    Cell[110542, 4781, 57, 1, 70, "ObjectName",
      CellTags->"S1.1085"],
    Cell[110602, 4784, 129, 4, 70, "CharacterName",
      CellTags->"S1.1085"],
    Cell[110734, 4790, 286, 9, 70, "Notes",
      CellTags->"S1.1085"],
    Cell[111023, 4801, 75, 1, 70, "Notes",
      CellTags->"S1.1085"],
    Cell[111101, 4804, 315, 11, 70, "Notes",
      CellTags->"S1.1085"],
    Cell[111419, 4817, 193, 7, 70, "Notes",
      CellTags->"S1.1085"]},
  "S1.1086"->{
    Cell[111649, 4829, 57, 1, 70, "ObjectName",
      CellTags->"S1.1086"],
    Cell[111709, 4832, 129, 4, 70, "CharacterName",
      CellTags->"S1.1086"],
    Cell[111841, 4838, 151, 5, 70, "Notes",
      CellTags->"S1.1086"],
    Cell[111995, 4845, 69, 1, 70, "Notes",
      CellTags->"S1.1086"],
    Cell[112067, 4848, 94, 1, 70, "Notes",
      CellTags->"S1.1086"],
    Cell[112164, 4851, 188, 7, 70, "Notes",
      CellTags->"S1.1086"],
    Cell[112355, 4860, 193, 7, 70, "Notes",
      CellTags->"S1.1086"]},
  "S1.1087"->{
    Cell[112585, 4872, 58, 1, 70, "ObjectName",
      CellTags->"S1.1087"],
    Cell[112646, 4875, 131, 4, 70, "CharacterName",
      CellTags->"S1.1087"],
    Cell[112780, 4881, 150, 5, 70, "Notes",
      CellTags->"S1.1087"],
    Cell[112933, 4888, 69, 1, 70, "Notes",
      CellTags->"S1.1087"],
    Cell[113005, 4891, 94, 1, 70, "Notes",
      CellTags->"S1.1087"],
    Cell[113102, 4894, 188, 7, 70, "Notes",
      CellTags->"S1.1087"],
    Cell[113293, 4903, 195, 7, 70, "Notes",
      CellTags->"S1.1087"]},
  "S1.1088"->{
    Cell[113525, 4915, 64, 1, 70, "ObjectName",
      CellTags->"S1.1088"],
    Cell[113592, 4918, 143, 4, 70, "CharacterName",
      CellTags->"S1.1088"],
    Cell[113738, 4924, 151, 5, 70, "Notes",
      CellTags->"S1.1088"],
    Cell[113892, 4931, 69, 1, 70, "Notes",
      CellTags->"S1.1088"],
    Cell[113964, 4934, 94, 1, 70, "Notes",
      CellTags->"S1.1088"],
    Cell[114061, 4937, 188, 7, 70, "Notes",
      CellTags->"S1.1088"],
    Cell[114252, 4946, 207, 7, 70, "Notes",
      CellTags->"S1.1088"]},
  "S1.1089"->{
    Cell[114496, 4958, 62, 1, 70, "ObjectName",
      CellTags->"S1.1089"],
    Cell[114561, 4961, 139, 4, 70, "CharacterName",
      CellTags->"S1.1089"],
    Cell[114703, 4967, 151, 5, 70, "Notes",
      CellTags->"S1.1089"],
    Cell[114857, 4974, 69, 1, 70, "Notes",
      CellTags->"S1.1089"],
    Cell[114929, 4977, 94, 1, 70, "Notes",
      CellTags->"S1.1089"],
    Cell[115026, 4980, 316, 11, 70, "Notes",
      CellTags->"S1.1089"],
    Cell[115345, 4993, 203, 7, 70, "Notes",
      CellTags->"S1.1089"]},
  "S1.1090"->{
    Cell[115585, 5005, 58, 1, 70, "ObjectName",
      CellTags->"S1.1090"],
    Cell[115646, 5008, 131, 4, 70, "CharacterName",
      CellTags->"S1.1090"],
    Cell[115780, 5014, 150, 5, 70, "Notes",
      CellTags->"S1.1090"],
    Cell[115933, 5021, 69, 1, 70, "Notes",
      CellTags->"S1.1090"],
    Cell[116005, 5024, 94, 1, 70, "Notes",
      CellTags->"S1.1090"],
    Cell[116102, 5027, 188, 7, 70, "Notes",
      CellTags->"S1.1090"],
    Cell[116293, 5036, 195, 7, 70, "Notes",
      CellTags->"S1.1090"]},
  "S1.1091"->{
    Cell[116525, 5048, 56, 1, 70, "ObjectName",
      CellTags->"S1.1091"],
    Cell[116584, 5051, 127, 4, 70, "CharacterName",
      CellTags->"S1.1091"],
    Cell[116714, 5057, 150, 5, 70, "Notes",
      CellTags->"S1.1091"],
    Cell[116867, 5064, 69, 1, 70, "Notes",
      CellTags->"S1.1091"],
    Cell[116939, 5067, 94, 1, 70, "Notes",
      CellTags->"S1.1091"],
    Cell[117036, 5070, 188, 7, 70, "Notes",
      CellTags->"S1.1091"],
    Cell[117227, 5079, 191, 7, 70, "Notes",
      CellTags->"S1.1091"]},
  "S1.1092"->{
    Cell[117455, 5091, 59, 1, 70, "ObjectName",
      CellTags->"S1.1092"],
    Cell[117517, 5094, 133, 4, 70, "CharacterName",
      CellTags->"S1.1092"],
    Cell[117653, 5100, 222, 7, 70, "Notes",
      CellTags->"S1.1092"],
    Cell[117878, 5109, 75, 1, 70, "Notes",
      CellTags->"S1.1092"],
    Cell[117956, 5112, 80, 1, 70, "Notes",
      CellTags->"S1.1092"],
    Cell[118039, 5115, 366, 12, 70, "Notes",
      CellTags->"S1.1092"],
    Cell[118408, 5129, 315, 11, 70, "Notes",
      CellTags->"S1.1092"],
    Cell[118726, 5142, 331, 11, 70, "Notes",
      CellTags->"S1.1092"]},
  "S1.1093"->{
    Cell[119094, 5158, 54, 1, 70, "ObjectName",
      CellTags->"S1.1093"],
    Cell[119151, 5161, 123, 4, 70, "CharacterName",
      CellTags->"S1.1093"],
    Cell[119277, 5167, 217, 7, 70, "Notes",
      CellTags->"S1.1093"],
    Cell[119497, 5176, 75, 1, 70, "Notes",
      CellTags->"S1.1093"],
    Cell[119575, 5179, 80, 1, 70, "Notes",
      CellTags->"S1.1093"],
    Cell[119658, 5182, 165, 4, 70, "Notes",
      CellTags->"S1.1093"],
    Cell[119826, 5188, 315, 11, 70, "Notes",
      CellTags->"S1.1093"],
    Cell[120144, 5201, 187, 7, 70, "Notes",
      CellTags->"S1.1093"]},
  "S1.1094"->{
    Cell[120368, 5213, 58, 1, 70, "ObjectName",
      CellTags->"S1.1094"],
    Cell[120429, 5216, 131, 4, 70, "CharacterName",
      CellTags->"S1.1094"],
    Cell[120563, 5222, 150, 5, 70, "Notes",
      CellTags->"S1.1094"],
    Cell[120716, 5229, 69, 1, 70, "Notes",
      CellTags->"S1.1094"],
    Cell[120788, 5232, 94, 1, 70, "Notes",
      CellTags->"S1.1094"],
    Cell[120885, 5235, 188, 7, 70, "Notes",
      CellTags->"S1.1094"],
    Cell[121076, 5244, 195, 7, 70, "Notes",
      CellTags->"S1.1094"]},
  "S1.1095"->{
    Cell[121308, 5256, 56, 1, 70, "ObjectName",
      CellTags->"S1.1095"],
    Cell[121367, 5259, 127, 4, 70, "CharacterName",
      CellTags->"S1.1095"],
    Cell[121497, 5265, 219, 7, 70, "Notes",
      CellTags->"S1.1095"],
    Cell[121719, 5274, 75, 1, 70, "Notes",
      CellTags->"S1.1095"],
    Cell[121797, 5277, 173, 7, 70, "Notes",
      CellTags->"S1.1095"],
    Cell[121973, 5286, 150, 5, 70, "Notes",
      CellTags->"S1.1095"],
    Cell[122126, 5293, 187, 7, 70, "Notes",
      CellTags->"S1.1095"],
    Cell[122316, 5302, 191, 7, 70, "Notes",
      CellTags->"S1.1095"]},
  "S1.1096"->{
    Cell[122544, 5314, 53, 1, 70, "ObjectName",
      CellTags->"S1.1096"],
    Cell[122600, 5317, 121, 4, 70, "CharacterName",
      CellTags->"S1.1096"],
    Cell[122724, 5323, 150, 5, 70, "Notes",
      CellTags->"S1.1096"],
    Cell[122877, 5330, 69, 1, 70, "Notes",
      CellTags->"S1.1096"],
    Cell[122949, 5333, 94, 1, 70, "Notes",
      CellTags->"S1.1096"],
    Cell[123046, 5336, 316, 11, 70, "Notes",
      CellTags->"S1.1096"],
    Cell[123365, 5349, 213, 7, 70, "Notes",
      CellTags->"S1.1096"]},
  "S1.1097"->{
    Cell[123615, 5361, 52, 1, 70, "ObjectName",
      CellTags->"S1.1097"],
    Cell[123670, 5364, 119, 4, 70, "CharacterName",
      CellTags->"S1.1097"],
    Cell[123792, 5370, 150, 5, 70, "Notes",
      CellTags->"S1.1097"],
    Cell[123945, 5377, 87, 1, 70, "Notes",
      CellTags->"S1.1097"],
    Cell[124035, 5380, 126, 4, 70, "Notes",
      CellTags->"S1.1097"],
    Cell[124164, 5386, 188, 7, 70, "Notes",
      CellTags->"S1.1097"],
    Cell[124355, 5395, 299, 11, 70, "Notes",
      CellTags->"S1.1097"]},
  "S1.1098"->{
    Cell[124691, 5411, 49, 1, 70, "ObjectName",
      CellTags->"S1.1098"],
    Cell[124743, 5414, 113, 4, 70, "CharacterName",
      CellTags->"S1.1098"],
    Cell[124859, 5420, 152, 5, 70, "Notes",
      CellTags->"S1.1098"],
    Cell[125014, 5427, 87, 1, 70, "Notes",
      CellTags->"S1.1098"],
    Cell[125104, 5430, 207, 7, 70, "Notes",
      CellTags->"S1.1098"],
    Cell[125314, 5439, 188, 7, 70, "Notes",
      CellTags->"S1.1098"]},
  "S1.1099"->{
    Cell[125539, 5451, 54, 1, 70, "ObjectName",
      CellTags->"S1.1099"],
    Cell[125596, 5454, 123, 4, 70, "CharacterName",
      CellTags->"S1.1099"],
    Cell[125722, 5460, 149, 5, 70, "Notes",
      CellTags->"S1.1099"],
    Cell[125874, 5467, 77, 1, 70, "Notes",
      CellTags->"S1.1099"],
    Cell[125954, 5470, 388, 17, 70, "Notes",
      CellTags->"S1.1099"],
    Cell[126345, 5489, 159, 4, 70, "Notes",
      CellTags->"S1.1099"],
    Cell[126507, 5495, 128, 4, 70, "Notes",
      CellTags->"S1.1099"],
    Cell[126638, 5501, 134, 4, 70, "Notes",
      CellTags->"S1.1099"],
    Cell[126775, 5507, 317, 11, 70, "Notes",
      CellTags->"S1.1099"],
    Cell[127095, 5520, 433, 15, 70, "Notes",
      CellTags->"S1.1099"]},
  "S1.1100"->{
    Cell[127565, 5540, 59, 1, 70, "ObjectName",
      CellTags->"S1.1100"],
    Cell[127627, 5543, 133, 4, 70, "CharacterName",
      CellTags->"S1.1100"],
    Cell[127763, 5549, 87, 1, 70, "Notes",
      CellTags->"S1.1100"],
    Cell[127853, 5552, 127, 4, 70, "Notes",
      CellTags->"S1.1100"],
    Cell[127983, 5558, 188, 7, 70, "Notes",
      CellTags->"S1.1100"],
    Cell[128174, 5567, 441, 15, 70, "Notes",
      CellTags->"S1.1100"]},
  "S1.1101"->{
    Cell[128652, 5587, 51, 1, 70, "ObjectName",
      CellTags->"S1.1101"],
    Cell[128706, 5590, 117, 4, 70, "CharacterName",
      CellTags->"S1.1101"],
    Cell[128826, 5596, 150, 5, 70, "Notes",
      CellTags->"S1.1101"],
    Cell[128979, 5603, 69, 1, 70, "Notes",
      CellTags->"S1.1101"],
    Cell[129051, 5606, 94, 1, 70, "Notes",
      CellTags->"S1.1101"],
    Cell[129148, 5609, 316, 11, 70, "Notes",
      CellTags->"S1.1101"],
    Cell[129467, 5622, 317, 11, 70, "Notes",
      CellTags->"S1.1101"]},
  "S1.1102"->{
    Cell[129821, 5638, 48, 1, 70, "ObjectName",
      CellTags->"S1.1102"],
    Cell[129872, 5641, 111, 4, 70, "CharacterName",
      CellTags->"S1.1102"],
    Cell[129986, 5647, 284, 9, 70, "Notes",
      CellTags->"S1.1102"],
    Cell[130273, 5658, 75, 1, 70, "Notes",
      CellTags->"S1.1102"],
    Cell[130351, 5661, 315, 11, 70, "Notes",
      CellTags->"S1.1102"],
    Cell[130669, 5674, 303, 11, 70, "Notes",
      CellTags->"S1.1102"]},
  "S1.1103"->{
    Cell[131009, 5690, 54, 1, 70, "ObjectName",
      CellTags->"S1.1103"],
    Cell[131066, 5693, 123, 4, 70, "CharacterName",
      CellTags->"S1.1103"],
    Cell[131192, 5699, 150, 5, 70, "Notes",
      CellTags->"S1.1103"],
    Cell[131345, 5706, 77, 1, 70, "Notes",
      CellTags->"S1.1103"],
    Cell[131425, 5709, 388, 17, 70, "Notes",
      CellTags->"S1.1103"],
    Cell[131816, 5728, 176, 4, 70, "Notes",
      CellTags->"S1.1103"],
    Cell[131995, 5734, 138, 4, 70, "Notes",
      CellTags->"S1.1103"],
    Cell[132136, 5740, 188, 7, 70, "Notes",
      CellTags->"S1.1103"],
    Cell[132327, 5749, 319, 11, 70, "Notes",
      CellTags->"S1.1103"]},
  "S1.1104"->{
    Cell[132683, 5765, 56, 1, 70, "ObjectName",
      CellTags->"S1.1104"],
    Cell[132742, 5768, 127, 4, 70, "CharacterName",
      CellTags->"S1.1104"],
    Cell[132872, 5774, 150, 5, 70, "Notes",
      CellTags->"S1.1104"],
    Cell[133025, 5781, 77, 1, 70, "Notes",
      CellTags->"S1.1104"],
    Cell[133105, 5784, 392, 17, 70, "Notes",
      CellTags->"S1.1104"],
    Cell[133500, 5803, 188, 7, 70, "Notes",
      CellTags->"S1.1104"],
    Cell[133691, 5812, 203, 7, 70, "Notes",
      CellTags->"S1.1104"]},
  "S1.1105"->{
    Cell[133931, 5824, 55, 1, 70, "ObjectName",
      CellTags->"S1.1105"],
    Cell[133989, 5827, 125, 4, 70, "CharacterName",
      CellTags->"S1.1105"],
    Cell[134117, 5833, 150, 5, 70, "Notes",
      CellTags->"S1.1105"],
    Cell[134270, 5840, 77, 1, 70, "Notes",
      CellTags->"S1.1105"],
    Cell[134350, 5843, 390, 17, 70, "Notes",
      CellTags->"S1.1105"],
    Cell[134743, 5862, 181, 5, 70, "Notes",
      CellTags->"S1.1105"],
    Cell[134927, 5869, 136, 4, 70, "Notes",
      CellTags->"S1.1105"],
    Cell[135066, 5875, 316, 11, 70, "Notes",
      CellTags->"S1.1105"],
    Cell[135385, 5888, 425, 15, 70, "Notes",
      CellTags->"S1.1105"]},
  "S1.1106"->{
    Cell[135847, 5908, 56, 1, 70, "ObjectName",
      CellTags->"S1.1106"],
    Cell[135906, 5911, 127, 4, 70, "CharacterName",
      CellTags->"S1.1106"],
    Cell[136036, 5917, 150, 5, 70, "Notes",
      CellTags->"S1.1106"],
    Cell[136189, 5924, 88, 1, 70, "Notes",
      CellTags->"S1.1106"],
    Cell[136280, 5927, 392, 17, 70, "Notes",
      CellTags->"S1.1106"],
    Cell[136675, 5946, 176, 4, 70, "Notes",
      CellTags->"S1.1106"],
    Cell[136854, 5952, 136, 4, 70, "Notes",
      CellTags->"S1.1106"],
    Cell[136993, 5958, 316, 11, 70, "Notes",
      CellTags->"S1.1106"],
    Cell[137312, 5971, 635, 23, 70, "Notes",
      CellTags->"S1.1106"]},
  "S1.1107"->{
    Cell[137984, 5999, 69, 1, 70, "ObjectName",
      CellTags->"S1.1107"],
    Cell[138056, 6002, 153, 4, 70, "CharacterName",
      CellTags->"S1.1107"],
    Cell[138212, 6008, 153, 5, 70, "Notes",
      CellTags->"S1.1107"],
    Cell[138368, 6015, 225, 7, 70, "Notes",
      CellTags->"S1.1107"],
    Cell[138596, 6024, 498, 19, 70, "Notes",
      CellTags->"S1.1107"],
    Cell[139097, 6045, 187, 7, 70, "Notes",
      CellTags->"S1.1107"],
    Cell[139287, 6054, 371, 11, 70, "Notes",
      CellTags->"S1.1107"]},
  "S1.1108"->{
    Cell[139695, 6070, 55, 1, 70, "ObjectName",
      CellTags->"S1.1108"],
    Cell[139753, 6073, 125, 4, 70, "CharacterName",
      CellTags->"S1.1108"],
    Cell[139881, 6079, 150, 5, 70, "Notes",
      CellTags->"S1.1108"],
    Cell[140034, 6086, 87, 1, 70, "Notes",
      CellTags->"S1.1108"],
    Cell[140124, 6089, 135, 4, 70, "Notes",
      CellTags->"S1.1108"],
    Cell[140262, 6095, 187, 7, 70, "Notes",
      CellTags->"S1.1108"],
    Cell[140452, 6104, 203, 7, 70, "Notes",
      CellTags->"S1.1108"]},
  "S1.1109"->{
    Cell[140692, 6116, 53, 1, 70, "ObjectName",
      CellTags->"S1.1109"],
    Cell[140748, 6119, 121, 4, 70, "CharacterName",
      CellTags->"S1.1109"],
    Cell[140872, 6125, 87, 1, 70, "Notes",
      CellTags->"S1.1109"],
    Cell[140962, 6128, 188, 7, 70, "Notes",
      CellTags->"S1.1109"],
    Cell[141153, 6137, 433, 15, 70, "Notes",
      CellTags->"S1.1109"]},
  "S1.1110"->{
    Cell[141623, 6157, 50, 1, 70, "ObjectName",
      CellTags->"S1.1110"],
    Cell[141676, 6160, 115, 4, 70, "CharacterName",
      CellTags->"S1.1110"],
    Cell[141794, 6166, 149, 5, 70, "Notes",
      CellTags->"S1.1110"],
    Cell[141946, 6173, 77, 1, 70, "Notes",
      CellTags->"S1.1110"],
    Cell[142026, 6176, 382, 17, 70, "Notes",
      CellTags->"S1.1110"],
    Cell[142411, 6195, 157, 4, 70, "Notes",
      CellTags->"S1.1110"],
    Cell[142571, 6201, 113, 4, 70, "Notes",
      CellTags->"S1.1110"],
    Cell[142687, 6207, 116, 4, 70, "Notes",
      CellTags->"S1.1110"],
    Cell[142806, 6213, 187, 7, 70, "Notes",
      CellTags->"S1.1110"],
    Cell[142996, 6222, 887, 31, 70, "Notes",
      CellTags->"S1.1110"]},
  "S1.1111"->{
    Cell[143920, 6258, 55, 1, 70, "ObjectName",
      CellTags->"S1.1111"],
    Cell[143978, 6261, 125, 4, 70, "CharacterName",
      CellTags->"S1.1111"],
    Cell[144106, 6267, 151, 5, 70, "Notes",
      CellTags->"S1.1111"],
    Cell[144260, 6274, 87, 1, 70, "Notes",
      CellTags->"S1.1111"],
    Cell[144350, 6277, 127, 4, 70, "Notes",
      CellTags->"S1.1111"],
    Cell[144480, 6283, 187, 7, 70, "Notes",
      CellTags->"S1.1111"],
    Cell[144670, 6292, 553, 19, 70, "Notes",
      CellTags->"S1.1111"]},
  "S1.1112"->{
    Cell[145260, 6316, 54, 1, 70, "ObjectName",
      CellTags->"S1.1112"],
    Cell[145317, 6319, 123, 4, 70, "CharacterName",
      CellTags->"S1.1112"],
    Cell[145443, 6325, 220, 7, 70, "Notes",
      CellTags->"S1.1112"],
    Cell[145666, 6334, 140, 4, 70, "Notes",
      CellTags->"S1.1112"],
    Cell[145809, 6340, 312, 12, 70, "Notes",
      CellTags->"S1.1112"],
    Cell[146124, 6354, 239, 9, 70, "Notes",
      CellTags->"S1.1112"],
    Cell[146366, 6365, 316, 11, 70, "Notes",
      CellTags->"S1.1112"],
    Cell[146685, 6378, 351, 11, 70, "Notes",
      CellTags->"S1.1112"]},
  "S1.1113"->{
    Cell[147073, 6394, 63, 1, 70, "ObjectName",
      CellTags->"S1.1113"],
    Cell[147139, 6397, 141, 4, 70, "CharacterName",
      CellTags->"S1.1113"],
    Cell[147283, 6403, 150, 5, 70, "Notes",
      CellTags->"S1.1113"],
    Cell[147436, 6410, 140, 4, 70, "Notes",
      CellTags->"S1.1113"],
    Cell[147579, 6416, 330, 12, 70, "Notes",
      CellTags->"S1.1113"],
    Cell[147912, 6430, 201, 7, 70, "Notes",
      CellTags->"S1.1113"],
    Cell[148116, 6439, 316, 11, 70, "Notes",
      CellTags->"S1.1113"],
    Cell[148435, 6452, 447, 15, 70, "Notes",
      CellTags->"S1.1113"]},
  "S1.1114"->{
    Cell[148919, 6472, 54, 1, 70, "ObjectName",
      CellTags->"S1.1114"],
    Cell[148976, 6475, 123, 4, 70, "CharacterName",
      CellTags->"S1.1114"],
    Cell[149102, 6481, 151, 5, 70, "Notes",
      CellTags->"S1.1114"],
    Cell[149256, 6488, 88, 1, 70, "Notes",
      CellTags->"S1.1114"],
    Cell[149347, 6491, 390, 17, 70, "Notes",
      CellTags->"S1.1114"],
    Cell[149740, 6510, 137, 4, 70, "Notes",
      CellTags->"S1.1114"],
    Cell[149880, 6516, 316, 11, 70, "Notes",
      CellTags->"S1.1114"],
    Cell[150199, 6529, 669, 23, 70, "Notes",
      CellTags->"S1.1114"]},
  "S1.1115"->{
    Cell[150905, 6557, 57, 1, 70, "ObjectName",
      CellTags->"S1.1115"],
    Cell[150965, 6560, 129, 4, 70, "CharacterName",
      CellTags->"S1.1115"],
    Cell[151097, 6566, 152, 5, 70, "Notes",
      CellTags->"S1.1115"],
    Cell[151252, 6573, 81, 1, 70, "Notes",
      CellTags->"S1.1115"],
    Cell[151336, 6576, 183, 5, 70, "Notes",
      CellTags->"S1.1115"],
    Cell[151522, 6583, 131, 4, 70, "Notes",
      CellTags->"S1.1115"],
    Cell[151656, 6589, 225, 7, 70, "Notes",
      CellTags->"S1.1115"],
    Cell[151884, 6598, 187, 7, 70, "Notes",
      CellTags->"S1.1115"],
    Cell[152074, 6607, 447, 15, 70, "Notes",
      CellTags->"S1.1115"]},
  "S1.1116"->{
    Cell[152558, 6627, 60, 1, 70, "ObjectName",
      CellTags->"S1.1116"],
    Cell[152621, 6630, 135, 4, 70, "CharacterName",
      CellTags->"S1.1116"],
    Cell[152759, 6636, 152, 5, 70, "Notes",
      CellTags->"S1.1116"],
    Cell[152914, 6643, 225, 7, 70, "Notes",
      CellTags->"S1.1116"],
    Cell[153142, 6652, 480, 19, 70, "Notes",
      CellTags->"S1.1116"],
    Cell[153625, 6673, 187, 7, 70, "Notes",
      CellTags->"S1.1116"],
    Cell[153815, 6682, 369, 11, 70, "Notes",
      CellTags->"S1.1116"]},
  "S1.1117"->{
    Cell[154221, 6698, 55, 1, 70, "ObjectName",
      CellTags->"S1.1117"],
    Cell[154279, 6701, 125, 4, 70, "CharacterName",
      CellTags->"S1.1117"],
    Cell[154407, 6707, 152, 5, 70, "Notes",
      CellTags->"S1.1117"],
    Cell[154562, 6714, 87, 1, 70, "Notes",
      CellTags->"S1.1117"],
    Cell[154652, 6717, 120, 4, 70, "Notes",
      CellTags->"S1.1117"],
    Cell[154775, 6723, 187, 7, 70, "Notes",
      CellTags->"S1.1117"],
    Cell[154965, 6732, 551, 19, 70, "Notes",
      CellTags->"S1.1117"]},
  "S1.1118"->{
    Cell[155553, 6756, 54, 1, 70, "ObjectName",
      CellTags->"S1.1118"],
    Cell[155610, 6759, 123, 4, 70, "CharacterName",
      CellTags->"S1.1118"],
    Cell[155736, 6765, 154, 5, 70, "Notes",
      CellTags->"S1.1118"],
    Cell[155893, 6772, 77, 1, 70, "Notes",
      CellTags->"S1.1118"],
    Cell[155973, 6775, 388, 17, 70, "Notes",
      CellTags->"S1.1118"],
    Cell[156364, 6794, 305, 12, 70, "Notes",
      CellTags->"S1.1118"],
    Cell[156672, 6808, 171, 4, 70, "Notes",
      CellTags->"S1.1118"],
    Cell[156846, 6814, 188, 7, 70, "Notes",
      CellTags->"S1.1118"],
    Cell[157037, 6823, 641, 23, 70, "Notes",
      CellTags->"S1.1118"]},
  "S1.1119"->{
    Cell[157715, 6851, 54, 1, 70, "ObjectName",
      CellTags->"S1.1119"],
    Cell[157772, 6854, 123, 4, 70, "CharacterName",
      CellTags->"S1.1119"],
    Cell[157898, 6860, 87, 1, 70, "Notes",
      CellTags->"S1.1119"],
    Cell[157988, 6863, 188, 7, 70, "Notes",
      CellTags->"S1.1119"],
    Cell[158179, 6872, 221, 7, 70, "Notes",
      CellTags->"S1.1119"]},
  "S1.1120"->{
    Cell[158437, 6884, 76, 1, 70, "ObjectName",
      CellTags->"S1.1120"],
    Cell[158516, 6887, 167, 4, 70, "CharacterName",
      CellTags->"S1.1120"],
    Cell[158686, 6893, 154, 5, 70, "Notes",
      CellTags->"S1.1120"],
    Cell[158843, 6900, 225, 7, 70, "Notes",
      CellTags->"S1.1120"],
    Cell[159071, 6909, 517, 20, 70, "Notes",
      CellTags->"S1.1120"],
    Cell[159591, 6931, 187, 7, 70, "Notes",
      CellTags->"S1.1120"],
    Cell[159781, 6940, 357, 11, 70, "Notes",
      CellTags->"S1.1120"]},
  "S1.1121"->{
    Cell[160175, 6956, 50, 1, 70, "ObjectName",
      CellTags->"S1.1121"],
    Cell[160228, 6959, 115, 4, 70, "CharacterName",
      CellTags->"S1.1121"],
    Cell[160346, 6965, 153, 5, 70, "Notes",
      CellTags->"S1.1121"],
    Cell[160502, 6972, 126, 4, 70, "Notes",
      CellTags->"S1.1121"],
    Cell[160631, 6978, 380, 17, 70, "Notes",
      CellTags->"S1.1121"],
    Cell[161014, 6997, 199, 7, 70, "Notes",
      CellTags->"S1.1121"],
    Cell[161216, 7006, 305, 9, 70, "Notes",
      CellTags->"S1.1121"],
    Cell[161524, 7017, 253, 9, 70, "Notes",
      CellTags->"S1.1121"],
    Cell[161780, 7028, 424, 15, 70, "Notes",
      CellTags->"S1.1121"],
    Cell[162207, 7045, 205, 7, 70, "Notes",
      CellTags->"S1.1121"]},
  "S1.1122"->{
    Cell[162449, 7057, 48, 1, 70, "ObjectName",
      CellTags->"S1.1122"],
    Cell[162500, 7060, 111, 4, 70, "CharacterName",
      CellTags->"S1.1122"],
    Cell[162614, 7066, 77, 1, 70, "Notes",
      CellTags->"S1.1122"],
    Cell[162694, 7069, 376, 17, 70, "Notes",
      CellTags->"S1.1122"],
    Cell[163073, 7088, 117, 4, 70, "Notes",
      CellTags->"S1.1122"],
    Cell[163193, 7094, 188, 7, 70, "Notes",
      CellTags->"S1.1122"],
    Cell[163384, 7103, 643, 23, 70, "Notes",
      CellTags->"S1.1122"]},
  "S1.1123"->{
    Cell[164064, 7131, 51, 1, 70, "ObjectName",
      CellTags->"S1.1123"],
    Cell[164118, 7134, 117, 4, 70, "CharacterName",
      CellTags->"S1.1123"],
    Cell[164238, 7140, 88, 1, 70, "Notes",
      CellTags->"S1.1123"],
    Cell[164329, 7143, 384, 17, 70, "Notes",
      CellTags->"S1.1123"],
    Cell[164716, 7162, 148, 4, 70, "Notes",
      CellTags->"S1.1123"],
    Cell[164867, 7168, 362, 14, 70, "Notes",
      CellTags->"S1.1123"],
    Cell[165232, 7184, 188, 7, 70, "Notes",
      CellTags->"S1.1123"],
    Cell[165423, 7193, 405, 15, 70, "Notes",
      CellTags->"S1.1123"]},
  "S1.1124"->{
    Cell[165865, 7213, 64, 1, 70, "ObjectName",
      CellTags->"S1.1124"],
    Cell[165932, 7216, 143, 4, 70, "CharacterName",
      CellTags->"S1.1124"],
    Cell[166078, 7222, 224, 7, 70, "Notes",
      CellTags->"S1.1124"],
    Cell[166305, 7231, 75, 1, 70, "Notes",
      CellTags->"S1.1124"],
    Cell[166383, 7234, 80, 1, 70, "Notes",
      CellTags->"S1.1124"],
    Cell[166466, 7237, 114, 4, 70, "Notes",
      CellTags->"S1.1124"],
    Cell[166583, 7243, 187, 7, 70, "Notes",
      CellTags->"S1.1124"],
    Cell[166773, 7252, 211, 7, 70, "Notes",
      CellTags->"S1.1124"]},
  "S1.1125"->{
    Cell[167021, 7264, 57, 1, 70, "ObjectName",
      CellTags->"S1.1125"],
    Cell[167081, 7267, 129, 4, 70, "CharacterName",
      CellTags->"S1.1125"],
    Cell[167213, 7273, 224, 7, 70, "Notes",
      CellTags->"S1.1125"],
    Cell[167440, 7282, 75, 1, 70, "Notes",
      CellTags->"S1.1125"],
    Cell[167518, 7285, 203, 7, 70, "Notes",
      CellTags->"S1.1125"],
    Cell[167724, 7294, 129, 4, 70, "Notes",
      CellTags->"S1.1125"],
    Cell[167856, 7300, 187, 7, 70, "Notes",
      CellTags->"S1.1125"],
    Cell[168046, 7309, 321, 11, 70, "Notes",
      CellTags->"S1.1125"]},
  "S1.1126"->{
    Cell[168404, 7325, 55, 1, 70, "ObjectName",
      CellTags->"S1.1126"],
    Cell[168462, 7328, 125, 4, 70, "CharacterName",
      CellTags->"S1.1126"],
    Cell[168590, 7334, 222, 7, 70, "Notes",
      CellTags->"S1.1126"],
    Cell[168815, 7343, 75, 1, 70, "Notes",
      CellTags->"S1.1126"],
    Cell[168893, 7346, 187, 7, 70, "Notes",
      CellTags->"S1.1126"],
    Cell[169083, 7355, 193, 7, 70, "Notes",
      CellTags->"S1.1126"]},
  "S1.1127"->{
    Cell[169313, 7367, 53, 1, 70, "ObjectName",
      CellTags->"S1.1127"],
    Cell[169369, 7370, 121, 4, 70, "CharacterName",
      CellTags->"S1.1127"],
    Cell[169493, 7376, 286, 9, 70, "Notes",
      CellTags->"S1.1127"],
    Cell[169782, 7387, 75, 1, 70, "Notes",
      CellTags->"S1.1127"],
    Cell[169860, 7390, 185, 6, 70, "Notes",
      CellTags->"S1.1127"],
    Cell[170048, 7398, 315, 11, 70, "Notes",
      CellTags->"S1.1127"],
    Cell[170366, 7411, 189, 7, 70, "Notes",
      CellTags->"S1.1127"]},
  "S1.1128"->{
    Cell[170592, 7423, 52, 1, 70, "ObjectName",
      CellTags->"S1.1128"],
    Cell[170647, 7426, 119, 4, 70, "CharacterName",
      CellTags->"S1.1128"],
    Cell[170769, 7432, 219, 7, 70, "Notes",
      CellTags->"S1.1128"],
    Cell[170991, 7441, 75, 1, 70, "Notes",
      CellTags->"S1.1128"],
    Cell[171069, 7444, 111, 4, 70, "Notes",
      CellTags->"S1.1128"],
    Cell[171183, 7450, 187, 7, 70, "Notes",
      CellTags->"S1.1128"],
    Cell[171373, 7459, 293, 11, 70, "Notes",
      CellTags->"S1.1128"]},
  "S1.1129"->{
    Cell[171703, 7475, 53, 1, 70, "ObjectName",
      CellTags->"S1.1129"],
    Cell[171759, 7478, 121, 4, 70, "CharacterName",
      CellTags->"S1.1129"],
    Cell[171883, 7484, 220, 7, 70, "Notes",
      CellTags->"S1.1129"],
    Cell[172106, 7493, 75, 1, 70, "Notes",
      CellTags->"S1.1129"],
    Cell[172184, 7496, 187, 7, 70, "Notes",
      CellTags->"S1.1129"],
    Cell[172374, 7505, 189, 7, 70, "Notes",
      CellTags->"S1.1129"]},
  "S1.1130"->{
    Cell[172600, 7517, 55, 1, 70, "ObjectName",
      CellTags->"S1.1130"],
    Cell[172658, 7520, 125, 4, 70, "CharacterName",
      CellTags->"S1.1130"],
    Cell[172786, 7526, 289, 9, 70, "Notes",
      CellTags->"S1.1130"],
    Cell[173078, 7537, 75, 1, 70, "Notes",
      CellTags->"S1.1130"],
    Cell[173156, 7540, 227, 9, 70, "Notes",
      CellTags->"S1.1130"],
    Cell[173386, 7551, 187, 7, 70, "Notes",
      CellTags->"S1.1130"],
    Cell[173576, 7560, 313, 11, 70, "Notes",
      CellTags->"S1.1130"]},
  "S1.1131"->{
    Cell[173926, 7576, 51, 1, 70, "ObjectName",
      CellTags->"S1.1131"],
    Cell[173980, 7579, 117, 4, 70, "CharacterName",
      CellTags->"S1.1131"],
    Cell[174100, 7585, 150, 5, 70, "Notes",
      CellTags->"S1.1131"],
    Cell[174253, 7592, 87, 1, 70, "Notes",
      CellTags->"S1.1131"],
    Cell[174343, 7595, 311, 12, 70, "Notes",
      CellTags->"S1.1131"],
    Cell[174657, 7609, 225, 7, 70, "Notes",
      CellTags->"S1.1131"],
    Cell[174885, 7618, 317, 11, 70, "Notes",
      CellTags->"S1.1131"],
    Cell[175205, 7631, 207, 7, 70, "Notes",
      CellTags->"S1.1131"]},
  "S1.1132"->{
    Cell[175449, 7643, 50, 1, 70, "ObjectName",
      CellTags->"S1.1132"],
    Cell[175502, 7646, 115, 4, 70, "CharacterName",
      CellTags->"S1.1132"],
    Cell[175620, 7652, 150, 5, 70, "Notes",
      CellTags->"S1.1132"],
    Cell[175773, 7659, 76, 1, 70, "Notes",
      CellTags->"S1.1132"],
    Cell[175852, 7662, 86, 1, 70, "Notes",
      CellTags->"S1.1132"],
    Cell[175941, 7665, 149, 4, 70, "Notes",
      CellTags->"S1.1132"],
    Cell[176093, 7671, 188, 7, 70, "Notes",
      CellTags->"S1.1132"],
    Cell[176284, 7680, 193, 7, 70, "Notes",
      CellTags->"S1.1132"]},
  "S1.1133"->{
    Cell[176514, 7692, 49, 1, 70, "ObjectName",
      CellTags->"S1.1133"],
    Cell[176566, 7695, 113, 4, 70, "CharacterName",
      CellTags->"S1.1133"],
    Cell[176682, 7701, 149, 5, 70, "Notes",
      CellTags->"S1.1133"],
    Cell[176834, 7708, 87, 1, 70, "Notes",
      CellTags->"S1.1133"],
    Cell[176924, 7711, 188, 7, 70, "Notes",
      CellTags->"S1.1133"],
    Cell[177115, 7720, 323, 11, 70, "Notes",
      CellTags->"S1.1133"]},
  "S1.1134"->{
    Cell[177475, 7736, 51, 1, 70, "ObjectName",
      CellTags->"S1.1134"],
    Cell[177529, 7739, 117, 4, 70, "CharacterName",
      CellTags->"S1.1134"],
    Cell[177649, 7745, 151, 5, 70, "Notes",
      CellTags->"S1.1134"],
    Cell[177803, 7752, 125, 4, 70, "Notes",
      CellTags->"S1.1134"],
    Cell[177931, 7758, 150, 5, 70, "Notes",
      CellTags->"S1.1134"],
    Cell[178084, 7765, 266, 11, 70, "Notes",
      CellTags->"S1.1134"],
    Cell[178353, 7778, 236, 6, 70, "Notes",
      CellTags->"S1.1134"],
    Cell[178592, 7786, 341, 11, 70, "Notes",
      CellTags->"S1.1134"],
    Cell[178936, 7799, 316, 11, 70, "Notes",
      CellTags->"S1.1134"],
    Cell[179255, 7812, 311, 11, 70, "Notes",
      CellTags->"S1.1134"]},
  "S1.1135"->{
    Cell[179603, 7828, 48, 1, 70, "ObjectName",
      CellTags->"S1.1135"],
    Cell[179654, 7831, 111, 4, 70, "CharacterName",
      CellTags->"S1.1135"],
    Cell[179768, 7837, 151, 5, 70, "Notes",
      CellTags->"S1.1135"],
    Cell[179922, 7844, 78, 1, 70, "Notes",
      CellTags->"S1.1135"],
    Cell[180003, 7847, 286, 11, 70, "Notes",
      CellTags->"S1.1135"],
    Cell[180292, 7860, 148, 4, 70, "Notes",
      CellTags->"S1.1135"],
    Cell[180443, 7866, 138, 4, 70, "Notes",
      CellTags->"S1.1135"],
    Cell[180584, 7872, 80, 1, 70, "Notes",
      CellTags->"S1.1135"],
    Cell[180667, 7875, 223, 7, 70, "Notes",
      CellTags->"S1.1135"],
    Cell[180893, 7884, 316, 11, 70, "Notes",
      CellTags->"S1.1135"],
    Cell[181212, 7897, 427, 15, 70, "Notes",
      CellTags->"S1.1135"]},
  "S1.1136"->{
    Cell[181676, 7917, 50, 1, 70, "ObjectName",
      CellTags->"S1.1136"],
    Cell[181729, 7920, 115, 4, 70, "CharacterName",
      CellTags->"S1.1136"],
    Cell[181847, 7926, 220, 7, 70, "Notes",
      CellTags->"S1.1136"],
    Cell[182070, 7935, 75, 1, 70, "Notes",
      CellTags->"S1.1136"],
    Cell[182148, 7938, 315, 11, 70, "Notes",
      CellTags->"S1.1136"],
    Cell[182466, 7951, 421, 15, 70, "Notes",
      CellTags->"S1.1136"]},
  "S1.1137"->{
    Cell[182924, 7971, 63, 1, 70, "ObjectName",
      CellTags->"S1.1137"],
    Cell[182990, 7974, 141, 4, 70, "CharacterName",
      CellTags->"S1.1137"],
    Cell[183134, 7980, 87, 1, 70, "Notes",
      CellTags->"S1.1137"],
    Cell[183224, 7983, 118, 4, 70, "Notes",
      CellTags->"S1.1137"],
    Cell[183345, 7989, 213, 7, 70, "Notes",
      CellTags->"S1.1137"],
    Cell[183561, 7998, 188, 7, 70, "Notes",
      CellTags->"S1.1137"],
    Cell[183752, 8007, 457, 15, 70, "Notes",
      CellTags->"S1.1137"]},
  "S1.1138"->{
    Cell[184246, 8027, 53, 1, 70, "ObjectName",
      CellTags->"S1.1138"],
    Cell[184302, 8030, 121, 4, 70, "CharacterName",
      CellTags->"S1.1138"],
    Cell[184426, 8036, 87, 1, 70, "Notes",
      CellTags->"S1.1138"],
    Cell[184516, 8039, 79, 1, 70, "Notes",
      CellTags->"S1.1138"],
    Cell[184598, 8042, 329, 11, 70, "Notes",
      CellTags->"S1.1138"],
    Cell[184930, 8055, 188, 7, 70, "Notes",
      CellTags->"S1.1138"]},
  "S1.1139"->{
    Cell[185155, 8067, 52, 1, 70, "ObjectName",
      CellTags->"S1.1139"],
    Cell[185210, 8070, 119, 4, 70, "CharacterName",
      CellTags->"S1.1139"],
    Cell[185332, 8076, 151, 5, 70, "Notes",
      CellTags->"S1.1139"],
    Cell[185486, 8083, 77, 1, 70, "Notes",
      CellTags->"S1.1139"],
    Cell[185566, 8086, 384, 17, 70, "Notes",
      CellTags->"S1.1139"],
    Cell[185953, 8105, 188, 7, 70, "Notes",
      CellTags->"S1.1139"],
    Cell[186144, 8114, 447, 15, 70, "Notes",
      CellTags->"S1.1139"]},
  "S1.1140"->{
    Cell[186628, 8134, 56, 1, 70, "ObjectName",
      CellTags->"S1.1140"],
    Cell[186687, 8137, 127, 4, 70, "CharacterName",
      CellTags->"S1.1140"],
    Cell[186817, 8143, 87, 1, 70, "Notes",
      CellTags->"S1.1140"],
    Cell[186907, 8146, 118, 4, 70, "Notes",
      CellTags->"S1.1140"],
    Cell[187028, 8152, 325, 11, 70, "Notes",
      CellTags->"S1.1140"],
    Cell[187356, 8165, 188, 7, 70, "Notes",
      CellTags->"S1.1140"],
    Cell[187547, 8174, 199, 7, 70, "Notes",
      CellTags->"S1.1140"]},
  "S1.1141"->{
    Cell[187783, 8186, 58, 1, 70, "ObjectName",
      CellTags->"S1.1141"],
    Cell[187844, 8189, 131, 4, 70, "CharacterName",
      CellTags->"S1.1141"],
    Cell[187978, 8195, 150, 5, 70, "Notes",
      CellTags->"S1.1141"],
    Cell[188131, 8202, 129, 4, 70, "Notes",
      CellTags->"S1.1141"],
    Cell[188263, 8208, 331, 9, 70, "Notes",
      CellTags->"S1.1141"],
    Cell[188597, 8219, 467, 19, 70, "Notes",
      CellTags->"S1.1141"],
    Cell[189067, 8240, 224, 7, 70, "Notes",
      CellTags->"S1.1141"],
    Cell[189294, 8249, 640, 23, 70, "Notes",
      CellTags->"S1.1141"],
    Cell[189937, 8274, 441, 15, 70, "Notes",
      CellTags->"S1.1141"]},
  "S1.1142"->{
    Cell[190415, 8294, 52, 1, 70, "ObjectName",
      CellTags->"S1.1142"],
    Cell[190470, 8297, 119, 4, 70, "CharacterName",
      CellTags->"S1.1142"],
    Cell[190592, 8303, 223, 7, 70, "Notes",
      CellTags->"S1.1142"],
    Cell[190818, 8312, 83, 1, 70, "Notes",
      CellTags->"S1.1142"],
    Cell[190904, 8315, 129, 5, 70, "Notes",
      CellTags->"S1.1142"],
    Cell[191036, 8322, 188, 7, 70, "Notes",
      CellTags->"S1.1142"],
    Cell[191227, 8331, 187, 7, 70, "Notes",
      CellTags->"S1.1142"],
    Cell[191417, 8340, 531, 19, 70, "Notes",
      CellTags->"S1.1142"]},
  "S1.1143"->{
    Cell[191985, 8364, 51, 1, 70, "ObjectName",
      CellTags->"S1.1143"],
    Cell[192039, 8367, 117, 4, 70, "CharacterName",
      CellTags->"S1.1143"],
    Cell[192159, 8373, 151, 5, 70, "Notes",
      CellTags->"S1.1143"],
    Cell[192313, 8380, 126, 4, 70, "Notes",
      CellTags->"S1.1143"],
    Cell[192442, 8386, 475, 23, 70, "Notes",
      CellTags->"S1.1143"],
    Cell[192920, 8411, 634, 29, 70, "Notes",
      CellTags->"S1.1143"],
    Cell[193557, 8442, 316, 11, 70, "Notes",
      CellTags->"S1.1143"],
    Cell[193876, 8455, 423, 15, 70, "Notes",
      CellTags->"S1.1143"]},
  "S1.1144"->{
    Cell[194336, 8475, 53, 1, 70, "ObjectName",
      CellTags->"S1.1144"],
    Cell[194392, 8478, 121, 4, 70, "CharacterName",
      CellTags->"S1.1144"],
    Cell[194516, 8484, 150, 5, 70, "Notes",
      CellTags->"S1.1144"],
    Cell[194669, 8491, 88, 1, 70, "Notes",
      CellTags->"S1.1144"],
    Cell[194760, 8494, 388, 17, 70, "Notes",
      CellTags->"S1.1144"],
    Cell[195151, 8513, 255, 6, 70, "Notes",
      CellTags->"S1.1144"],
    Cell[195409, 8521, 188, 7, 70, "Notes",
      CellTags->"S1.1144"],
    Cell[195600, 8530, 319, 11, 70, "Notes",
      CellTags->"S1.1144"]},
  "S1.1145"->{
    Cell[195956, 8546, 53, 1, 70, "ObjectName",
      CellTags->"S1.1145"],
    Cell[196012, 8549, 121, 4, 70, "CharacterName",
      CellTags->"S1.1145"],
    Cell[196136, 8555, 69, 1, 70, "Notes",
      CellTags->"S1.1145"],
    Cell[196208, 8558, 152, 5, 70, "Notes",
      CellTags->"S1.1145"],
    Cell[196363, 8565, 161, 5, 70, "Notes",
      CellTags->"S1.1145"],
    Cell[196527, 8572, 188, 7, 70, "Notes",
      CellTags->"S1.1145"],
    Cell[196718, 8581, 303, 11, 70, "Notes",
      CellTags->"S1.1145"]},
  "S1.1146"->{
    Cell[197058, 8597, 53, 1, 70, "ObjectName",
      CellTags->"S1.1146"],
    Cell[197114, 8600, 121, 4, 70, "CharacterName",
      CellTags->"S1.1146"],
    Cell[197238, 8606, 69, 1, 70, "Notes",
      CellTags->"S1.1146"],
    Cell[197310, 8609, 151, 5, 70, "Notes",
      CellTags->"S1.1146"],
    Cell[197464, 8616, 161, 5, 70, "Notes",
      CellTags->"S1.1146"],
    Cell[197628, 8623, 188, 7, 70, "Notes",
      CellTags->"S1.1146"],
    Cell[197819, 8632, 199, 7, 70, "Notes",
      CellTags->"S1.1146"]},
  "S1.1147"->{
    Cell[198055, 8644, 57, 1, 70, "ObjectName",
      CellTags->"S1.1147"],
    Cell[198115, 8647, 129, 4, 70, "CharacterName",
      CellTags->"S1.1147"],
    Cell[198247, 8653, 87, 1, 70, "Notes",
      CellTags->"S1.1147"],
    Cell[198337, 8656, 188, 7, 70, "Notes",
      CellTags->"S1.1147"],
    Cell[198528, 8665, 323, 11, 70, "Notes",
      CellTags->"S1.1147"]},
  "S1.1148"->{
    Cell[198888, 8681, 66, 1, 70, "ObjectName",
      CellTags->"S1.1148"],
    Cell[198957, 8684, 147, 4, 70, "CharacterName",
      CellTags->"S1.1148"],
    Cell[199107, 8690, 225, 7, 70, "Notes",
      CellTags->"S1.1148"],
    Cell[199335, 8699, 486, 19, 70, "Notes",
      CellTags->"S1.1148"],
    Cell[199824, 8720, 120, 4, 70, "Notes",
      CellTags->"S1.1148"],
    Cell[199947, 8726, 187, 7, 70, "Notes",
      CellTags->"S1.1148"],
    Cell[200137, 8735, 325, 11, 70, "Notes",
      CellTags->"S1.1148"]},
  "S1.1149"->{
    Cell[200499, 8751, 57, 1, 70, "ObjectName",
      CellTags->"S1.1149"],
    Cell[200559, 8754, 129, 4, 70, "CharacterName",
      CellTags->"S1.1149"],
    Cell[200691, 8760, 151, 5, 70, "Notes",
      CellTags->"S1.1149"],
    Cell[200845, 8767, 87, 1, 70, "Notes",
      CellTags->"S1.1149"],
    Cell[200935, 8770, 188, 7, 70, "Notes",
      CellTags->"S1.1149"],
    Cell[201126, 8779, 195, 7, 70, "Notes",
      CellTags->"S1.1149"]},
  "S1.1150"->{
    Cell[201358, 8791, 57, 1, 70, "ObjectName",
      CellTags->"S1.1150"],
    Cell[201418, 8794, 129, 4, 70, "CharacterName",
      CellTags->"S1.1150"],
    Cell[201550, 8800, 150, 5, 70, "Notes",
      CellTags->"S1.1150"],
    Cell[201703, 8807, 87, 1, 70, "Notes",
      CellTags->"S1.1150"],
    Cell[201793, 8810, 165, 5, 70, "Notes",
      CellTags->"S1.1150"],
    Cell[201961, 8817, 179, 7, 70, "Notes",
      CellTags->"S1.1150"],
    Cell[202143, 8826, 199, 7, 70, "Notes",
      CellTags->"S1.1150"],
    Cell[202345, 8835, 188, 7, 70, "Notes",
      CellTags->"S1.1150"],
    Cell[202536, 8844, 443, 15, 70, "Notes",
      CellTags->"S1.1150"]},
  "S1.1151"->{
    Cell[203016, 8864, 60, 1, 70, "ObjectName",
      CellTags->"S1.1151"],
    Cell[203079, 8867, 135, 4, 70, "CharacterName",
      CellTags->"S1.1151"],
    Cell[203217, 8873, 83, 1, 70, "Notes",
      CellTags->"S1.1151"],
    Cell[203303, 8876, 400, 17, 70, "Notes",
      CellTags->"S1.1151"],
    Cell[203706, 8895, 83, 1, 70, "Notes",
      CellTags->"S1.1151"],
    Cell[203792, 8898, 188, 7, 70, "Notes",
      CellTags->"S1.1151"],
    Cell[203983, 8907, 323, 11, 70, "Notes",
      CellTags->"S1.1151"]},
  "S1.1152"->{
    Cell[204343, 8923, 54, 1, 70, "ObjectName",
      CellTags->"S1.1152"],
    Cell[204400, 8926, 123, 4, 70, "CharacterName",
      CellTags->"S1.1152"],
    Cell[204526, 8932, 150, 5, 70, "Notes",
      CellTags->"S1.1152"],
    Cell[204679, 8939, 87, 1, 70, "Notes",
      CellTags->"S1.1152"],
    Cell[204769, 8942, 115, 4, 70, "Notes",
      CellTags->"S1.1152"],
    Cell[204887, 8948, 193, 7, 70, "Notes",
      CellTags->"S1.1152"],
    Cell[205083, 8957, 188, 7, 70, "Notes",
      CellTags->"S1.1152"],
    Cell[205274, 8966, 449, 15, 70, "Notes",
      CellTags->"S1.1152"]},
  "S1.1153"->{
    Cell[205760, 8986, 60, 1, 70, "ObjectName",
      CellTags->"S1.1153"],
    Cell[205823, 8989, 135, 4, 70, "CharacterName",
      CellTags->"S1.1153"],
    Cell[205961, 8995, 231, 7, 70, "Notes",
      CellTags->"S1.1153"],
    Cell[206195, 9004, 83, 1, 70, "Notes",
      CellTags->"S1.1153"],
    Cell[206281, 9007, 402, 17, 70, "Notes",
      CellTags->"S1.1153"],
    Cell[206686, 9026, 83, 1, 70, "Notes",
      CellTags->"S1.1153"],
    Cell[206772, 9029, 375, 11, 70, "Notes",
      CellTags->"S1.1153"],
    Cell[207150, 9042, 188, 7, 70, "Notes",
      CellTags->"S1.1153"],
    Cell[207341, 9051, 463, 15, 70, "Notes",
      CellTags->"S1.1153"]},
  "S1.1154"->{
    Cell[207841, 9071, 65, 1, 70, "ObjectName",
      CellTags->"S1.1154"],
    Cell[207909, 9074, 145, 4, 70, "CharacterName",
      CellTags->"S1.1154"],
    Cell[208057, 9080, 151, 5, 70, "Notes",
      CellTags->"S1.1154"],
    Cell[208211, 9087, 83, 1, 70, "Notes",
      CellTags->"S1.1154"],
    Cell[208297, 9090, 412, 17, 70, "Notes",
      CellTags->"S1.1154"],
    Cell[208712, 9109, 124, 4, 70, "Notes",
      CellTags->"S1.1154"],
    Cell[208839, 9115, 83, 1, 70, "Notes",
      CellTags->"S1.1154"],
    Cell[208925, 9118, 188, 7, 70, "Notes",
      CellTags->"S1.1154"],
    Cell[209116, 9127, 847, 27, 70, "Notes",
      CellTags->"S1.1154"]},
  "S1.1155"->{
    Cell[210000, 9159, 58, 1, 70, "ObjectName",
      CellTags->"S1.1155"],
    Cell[210061, 9162, 131, 4, 70, "CharacterName",
      CellTags->"S1.1155"],
    Cell[210195, 9168, 77, 1, 70, "Notes",
      CellTags->"S1.1155"],
    Cell[210275, 9171, 398, 17, 70, "Notes",
      CellTags->"S1.1155"],
    Cell[210676, 9190, 670, 29, 70, "Notes",
      CellTags->"S1.1155"],
    Cell[211349, 9221, 265, 8, 70, "Notes",
      CellTags->"S1.1155"],
    Cell[211617, 9231, 316, 11, 70, "Notes",
      CellTags->"S1.1155"],
    Cell[211936, 9244, 321, 11, 70, "Notes",
      CellTags->"S1.1155"]},
  "S1.1156"->{
    Cell[212294, 9260, 64, 1, 70, "ObjectName",
      CellTags->"S1.1156"],
    Cell[212361, 9263, 143, 4, 70, "CharacterName",
      CellTags->"S1.1156"],
    Cell[212507, 9269, 151, 5, 70, "Notes",
      CellTags->"S1.1156"],
    Cell[212661, 9276, 83, 1, 70, "Notes",
      CellTags->"S1.1156"],
    Cell[212747, 9279, 442, 18, 70, "Notes",
      CellTags->"S1.1156"],
    Cell[213192, 9299, 188, 7, 70, "Notes",
      CellTags->"S1.1156"],
    Cell[213383, 9308, 471, 15, 70, "Notes",
      CellTags->"S1.1156"]},
  "S1.1157"->{
    Cell[213891, 9328, 69, 1, 70, "ObjectName",
      CellTags->"S1.1157"],
    Cell[213963, 9331, 153, 4, 70, "CharacterName",
      CellTags->"S1.1157"],
    Cell[214119, 9337, 152, 5, 70, "Notes",
      CellTags->"S1.1157"],
    Cell[214274, 9344, 83, 1, 70, "Notes",
      CellTags->"S1.1157"],
    Cell[214360, 9347, 452, 18, 70, "Notes",
      CellTags->"S1.1157"],
    Cell[214815, 9367, 188, 7, 70, "Notes",
      CellTags->"S1.1157"],
    Cell[215006, 9376, 623, 19, 70, "Notes",
      CellTags->"S1.1157"]},
  "S1.1158"->{
    Cell[215666, 9400, 65, 1, 70, "ObjectName",
      CellTags->"S1.1158"],
    Cell[215734, 9403, 145, 4, 70, "CharacterName",
      CellTags->"S1.1158"],
    Cell[215882, 9409, 151, 5, 70, "Notes",
      CellTags->"S1.1158"],
    Cell[216036, 9416, 83, 1, 70, "Notes",
      CellTags->"S1.1158"],
    Cell[216122, 9419, 444, 18, 70, "Notes",
      CellTags->"S1.1158"],
    Cell[216569, 9439, 188, 7, 70, "Notes",
      CellTags->"S1.1158"],
    Cell[216760, 9448, 473, 15, 70, "Notes",
      CellTags->"S1.1158"]},
  "S1.1159"->{
    Cell[217270, 9468, 56, 1, 70, "ObjectName",
      CellTags->"S1.1159"],
    Cell[217329, 9471, 127, 4, 70, "CharacterName",
      CellTags->"S1.1159"],
    Cell[217459, 9477, 150, 5, 70, "Notes",
      CellTags->"S1.1159"],
    Cell[217612, 9484, 87, 1, 70, "Notes",
      CellTags->"S1.1159"],
    Cell[217702, 9487, 130, 4, 70, "Notes",
      CellTags->"S1.1159"],
    Cell[217835, 9493, 188, 7, 70, "Notes",
      CellTags->"S1.1159"],
    Cell[218026, 9502, 325, 11, 70, "Notes",
      CellTags->"S1.1159"]},
  "S1.1160"->{
    Cell[218388, 9518, 61, 1, 70, "ObjectName",
      CellTags->"S1.1160"],
    Cell[218452, 9521, 137, 4, 70, "CharacterName",
      CellTags->"S1.1160"],
    Cell[218592, 9527, 231, 7, 70, "Notes",
      CellTags->"S1.1160"],
    Cell[218826, 9536, 83, 1, 70, "Notes",
      CellTags->"S1.1160"],
    Cell[218912, 9539, 404, 17, 70, "Notes",
      CellTags->"S1.1160"],
    Cell[219319, 9558, 140, 4, 70, "Notes",
      CellTags->"S1.1160"],
    Cell[219462, 9564, 121, 4, 70, "Notes",
      CellTags->"S1.1160"],
    Cell[219586, 9570, 203, 7, 70, "Notes",
      CellTags->"S1.1160"],
    Cell[219792, 9579, 83, 1, 70, "Notes",
      CellTags->"S1.1160"],
    Cell[219878, 9582, 317, 11, 70, "Notes",
      CellTags->"S1.1160"],
    Cell[220198, 9595, 465, 15, 70, "Notes",
      CellTags->"S1.1160"]},
  "S1.1161"->{
    Cell[220700, 9615, 59, 1, 70, "ObjectName",
      CellTags->"S1.1161"],
    Cell[220762, 9618, 133, 4, 70, "CharacterName",
      CellTags->"S1.1161"],
    Cell[220898, 9624, 77, 1, 70, "Notes",
      CellTags->"S1.1161"],
    Cell[220978, 9627, 400, 17, 70, "Notes",
      CellTags->"S1.1161"],
    Cell[221381, 9646, 674, 29, 70, "Notes",
      CellTags->"S1.1161"],
    Cell[222058, 9677, 191, 5, 70, "Notes",
      CellTags->"S1.1161"],
    Cell[222252, 9684, 117, 4, 70, "Notes",
      CellTags->"S1.1161"],
    Cell[222372, 9690, 316, 11, 70, "Notes",
      CellTags->"S1.1161"],
    Cell[222691, 9703, 321, 11, 70, "Notes",
      CellTags->"S1.1161"]},
  "S1.1162"->{
    Cell[223049, 9719, 84, 1, 70, "ObjectName",
      CellTags->"S1.1162"],
    Cell[223136, 9722, 228, 6, 70, "CharacterName",
      CellTags->"S1.1162"],
    Cell[223367, 9730, 227, 7, 70, "Notes",
      CellTags->"S1.1162"],
    Cell[223597, 9739, 70, 1, 70, "Notes",
      CellTags->"S1.1162"],
    Cell[223670, 9742, 155, 4, 70, "Notes",
      CellTags->"S1.1162"],
    Cell[223828, 9748, 236, 5, 70, "Notes",
      CellTags->"S1.1162"],
    Cell[224067, 9755, 188, 7, 70, "Notes",
      CellTags->"S1.1162"],
    Cell[224258, 9764, 448, 15, 70, "Notes",
      CellTags->"S1.1162"]},
  "S1.1163"->{
    Cell[224743, 9784, 108, 4, 70, "ObjectName",
      CellTags->"S1.1163"],
    Cell[224854, 9790, 258, 7, 70, "CharacterName",
      CellTags->"S1.1163"],
    Cell[225115, 9799, 227, 7, 70, "Notes",
      CellTags->"S1.1163"],
    Cell[225345, 9808, 70, 1, 70, "Notes",
      CellTags->"S1.1163"],
    Cell[225418, 9811, 155, 4, 70, "Notes",
      CellTags->"S1.1163"],
    Cell[225576, 9817, 770, 22, 70, "Notes",
      CellTags->"S1.1163"],
    Cell[226349, 9841, 246, 6, 70, "Notes",
      CellTags->"S1.1163"],
    Cell[226598, 9849, 188, 7, 70, "Notes",
      CellTags->"S1.1163"],
    Cell[226789, 9858, 340, 11, 70, "Notes",
      CellTags->"S1.1163"]},
  "S1.1164"->{
    Cell[227166, 9874, 58, 1, 70, "ObjectName",
      CellTags->"S1.1164"],
    Cell[227227, 9877, 131, 4, 70, "CharacterName",
      CellTags->"S1.1164"],
    Cell[227361, 9883, 83, 1, 70, "Notes",
      CellTags->"S1.1164"],
    Cell[227447, 9886, 396, 17, 70, "Notes",
      CellTags->"S1.1164"],
    Cell[227846, 9905, 83, 1, 70, "Notes",
      CellTags->"S1.1164"],
    Cell[227932, 9908, 188, 7, 70, "Notes",
      CellTags->"S1.1164"],
    Cell[228123, 9917, 323, 11, 70, "Notes",
      CellTags->"S1.1164"]},
  "S1.1165"->{
    Cell[228483, 9933, 62, 1, 70, "ObjectName",
      CellTags->"S1.1165"],
    Cell[228548, 9936, 139, 4, 70, "CharacterName",
      CellTags->"S1.1165"],
    Cell[228690, 9942, 83, 1, 70, "Notes",
      CellTags->"S1.1165"],
    Cell[228776, 9945, 404, 17, 70, "Notes",
      CellTags->"S1.1165"],
    Cell[229183, 9964, 83, 1, 70, "Notes",
      CellTags->"S1.1165"],
    Cell[229269, 9967, 188, 7, 70, "Notes",
      CellTags->"S1.1165"],
    Cell[229460, 9976, 461, 15, 70, "Notes",
      CellTags->"S1.1165"]},
  "S1.1166"->{
    Cell[229958, 9996, 62, 1, 70, "ObjectName",
      CellTags->"S1.1166"],
    Cell[230023, 9999, 139, 4, 70, "CharacterName",
      CellTags->"S1.1166"],
    Cell[230165, 10005, 231, 7, 70, "Notes",
      CellTags->"S1.1166"],
    Cell[230399, 10014, 77, 1, 70, "Notes",
      CellTags->"S1.1166"],
    Cell[230479, 10017, 406, 17, 70, "Notes",
      CellTags->"S1.1166"],
    Cell[230888, 10036, 191, 7, 70, "Notes",
      CellTags->"S1.1166"],
    Cell[231082, 10045, 156, 4, 70, "Notes",
      CellTags->"S1.1166"],
    Cell[231241, 10051, 379, 11, 70, "Notes",
      CellTags->"S1.1166"],
    Cell[231623, 10064, 363, 11, 70, "Notes",
      CellTags->"S1.1166"],
    Cell[231989, 10077, 188, 7, 70, "Notes",
      CellTags->"S1.1166"],
    Cell[232180, 10086, 471, 15, 70, "Notes",
      CellTags->"S1.1166"]},
  "S1.1167"->{
    Cell[232688, 10106, 54, 1, 70, "ObjectName",
      CellTags->"S1.1167"],
    Cell[232745, 10109, 123, 4, 70, "CharacterName",
      CellTags->"S1.1167"],
    Cell[232871, 10115, 83, 1, 70, "Notes",
      CellTags->"S1.1167"],
    Cell[232957, 10118, 388, 17, 70, "Notes",
      CellTags->"S1.1167"],
    Cell[233348, 10137, 119, 4, 70, "Notes",
      CellTags->"S1.1167"],
    Cell[233470, 10143, 101, 3, 70, "Notes",
      CellTags->"S1.1167"],
    Cell[233574, 10148, 135, 4, 70, "Notes",
      CellTags->"S1.1167"],
    Cell[233712, 10154, 83, 1, 70, "Notes",
      CellTags->"S1.1167"],
    Cell[233798, 10157, 188, 7, 70, "Notes",
      CellTags->"S1.1167"],
    Cell[233989, 10166, 687, 23, 70, "Notes",
      CellTags->"S1.1167"]},
  "S1.1168"->{
    Cell[234713, 10194, 57, 1, 70, "ObjectName",
      CellTags->"S1.1168"],
    Cell[234773, 10197, 129, 4, 70, "CharacterName",
      CellTags->"S1.1168"],
    Cell[234905, 10203, 83, 1, 70, "Notes",
      CellTags->"S1.1168"],
    Cell[234991, 10206, 394, 17, 70, "Notes",
      CellTags->"S1.1168"],
    Cell[235388, 10225, 112, 4, 70, "Notes",
      CellTags->"S1.1168"],
    Cell[235503, 10231, 83, 1, 70, "Notes",
      CellTags->"S1.1168"],
    Cell[235589, 10234, 188, 7, 70, "Notes",
      CellTags->"S1.1168"],
    Cell[235780, 10243, 567, 19, 70, "Notes",
      CellTags->"S1.1168"]},
  "S1.1169"->{
    Cell[236384, 10267, 61, 1, 70, "ObjectName",
      CellTags->"S1.1169"],
    Cell[236448, 10270, 137, 4, 70, "CharacterName",
      CellTags->"S1.1169"],
    Cell[236588, 10276, 83, 1, 70, "Notes",
      CellTags->"S1.1169"],
    Cell[236674, 10279, 402, 17, 70, "Notes",
      CellTags->"S1.1169"],
    Cell[237079, 10298, 83, 1, 70, "Notes",
      CellTags->"S1.1169"],
    Cell[237165, 10301, 188, 7, 70, "Notes",
      CellTags->"S1.1169"],
    Cell[237356, 10310, 585, 19, 70, "Notes",
      CellTags->"S1.1169"]},
  "S1.1170"->{
    Cell[237978, 10334, 54, 1, 70, "ObjectName",
      CellTags->"S1.1170"],
    Cell[238035, 10337, 123, 4, 70, "CharacterName",
      CellTags->"S1.1170"],
    Cell[238161, 10343, 151, 5, 70, "Notes",
      CellTags->"S1.1170"],
    Cell[238315, 10350, 87, 1, 70, "Notes",
      CellTags->"S1.1170"],
    Cell[238405, 10353, 125, 4, 70, "Notes",
      CellTags->"S1.1170"],
    Cell[238533, 10359, 188, 7, 70, "Notes",
      CellTags->"S1.1170"],
    Cell[238724, 10368, 295, 11, 70, "Notes",
      CellTags->"S1.1170"]},
  "S1.1171"->{
    Cell[239056, 10384, 60, 1, 70, "ObjectName",
      CellTags->"S1.1171"],
    Cell[239119, 10387, 135, 4, 70, "CharacterName",
      CellTags->"S1.1171"],
    Cell[239257, 10393, 150, 5, 70, "Notes",
      CellTags->"S1.1171"],
    Cell[239410, 10400, 87, 1, 70, "Notes",
      CellTags->"S1.1171"],
    Cell[239500, 10403, 78, 1, 70, "Notes",
      CellTags->"S1.1171"],
    Cell[239581, 10406, 188, 7, 70, "Notes",
      CellTags->"S1.1171"],
    Cell[239772, 10415, 331, 11, 70, "Notes",
      CellTags->"S1.1171"]},
  "S1.1172"->{
    Cell[240140, 10431, 64, 1, 70, "ObjectName",
      CellTags->"S1.1172"],
    Cell[240207, 10434, 143, 4, 70, "CharacterName",
      CellTags->"S1.1172"],
    Cell[240353, 10440, 96, 1, 70, "Notes",
      CellTags->"S1.1172"],
    Cell[240452, 10443, 408, 17, 70, "Notes",
      CellTags->"S1.1172"],
    Cell[240863, 10462, 83, 1, 70, "Notes",
      CellTags->"S1.1172"],
    Cell[240949, 10465, 188, 7, 70, "Notes",
      CellTags->"S1.1172"],
    Cell[241140, 10474, 461, 15, 70, "Notes",
      CellTags->"S1.1172"]},
  "S1.1173"->{
    Cell[241638, 10494, 62, 1, 70, "ObjectName",
      CellTags->"S1.1173"],
    Cell[241703, 10497, 139, 4, 70, "CharacterName",
      CellTags->"S1.1173"],
    Cell[241845, 10503, 96, 1, 70, "Notes",
      CellTags->"S1.1173"],
    Cell[241944, 10506, 406, 17, 70, "Notes",
      CellTags->"S1.1173"],
    Cell[242353, 10525, 83, 1, 70, "Notes",
      CellTags->"S1.1173"],
    Cell[242439, 10528, 188, 7, 70, "Notes",
      CellTags->"S1.1173"],
    Cell[242630, 10537, 331, 11, 70, "Notes",
      CellTags->"S1.1173"]},
  "S1.1174"->{
    Cell[242998, 10553, 59, 1, 70, "ObjectName",
      CellTags->"S1.1174"],
    Cell[243060, 10556, 133, 4, 70, "CharacterName",
      CellTags->"S1.1174"],
    Cell[243196, 10562, 96, 1, 70, "Notes",
      CellTags->"S1.1174"],
    Cell[243295, 10565, 400, 17, 70, "Notes",
      CellTags->"S1.1174"],
    Cell[243698, 10584, 83, 1, 70, "Notes",
      CellTags->"S1.1174"],
    Cell[243784, 10587, 188, 7, 70, "Notes",
      CellTags->"S1.1174"],
    Cell[243975, 10596, 559, 19, 70, "Notes",
      CellTags->"S1.1174"]},
  "S1.1175"->{
    Cell[244571, 10620, 62, 1, 70, "ObjectName",
      CellTags->"S1.1175"],
    Cell[244636, 10623, 139, 4, 70, "CharacterName",
      CellTags->"S1.1175"],
    Cell[244778, 10629, 96, 1, 70, "Notes",
      CellTags->"S1.1175"],
    Cell[244877, 10632, 404, 17, 70, "Notes",
      CellTags->"S1.1175"],
    Cell[245284, 10651, 83, 1, 70, "Notes",
      CellTags->"S1.1175"],
    Cell[245370, 10654, 188, 7, 70, "Notes",
      CellTags->"S1.1175"],
    Cell[245561, 10663, 331, 11, 70, "Notes",
      CellTags->"S1.1175"]},
  "S1.1176"->{
    Cell[245929, 10679, 57, 1, 70, "ObjectName",
      CellTags->"S1.1176"],
    Cell[245989, 10682, 129, 4, 70, "CharacterName",
      CellTags->"S1.1176"],
    Cell[246121, 10688, 150, 5, 70, "Notes",
      CellTags->"S1.1176"],
    Cell[246274, 10695, 87, 1, 70, "Notes",
      CellTags->"S1.1176"],
    Cell[246364, 10698, 78, 1, 70, "Notes",
      CellTags->"S1.1176"],
    Cell[246445, 10701, 188, 7, 70, "Notes",
      CellTags->"S1.1176"],
    Cell[246636, 10710, 331, 11, 70, "Notes",
      CellTags->"S1.1176"]},
  "S1.1177"->{
    Cell[247004, 10726, 63, 1, 70, "ObjectName",
      CellTags->"S1.1177"],
    Cell[247070, 10729, 141, 4, 70, "CharacterName",
      CellTags->"S1.1177"],
    Cell[247214, 10735, 96, 1, 70, "Notes",
      CellTags->"S1.1177"],
    Cell[247313, 10738, 408, 17, 70, "Notes",
      CellTags->"S1.1177"],
    Cell[247724, 10757, 83, 1, 70, "Notes",
      CellTags->"S1.1177"],
    Cell[247810, 10760, 188, 7, 70, "Notes",
      CellTags->"S1.1177"],
    Cell[248001, 10769, 335, 11, 70, "Notes",
      CellTags->"S1.1177"]},
  "S1.1178"->{
    Cell[248373, 10785, 60, 1, 70, "ObjectName",
      CellTags->"S1.1178"],
    Cell[248436, 10788, 135, 4, 70, "CharacterName",
      CellTags->"S1.1178"],
    Cell[248574, 10794, 96, 1, 70, "Notes",
      CellTags->"S1.1178"],
    Cell[248673, 10797, 402, 17, 70, "Notes",
      CellTags->"S1.1178"],
    Cell[249078, 10816, 83, 1, 70, "Notes",
      CellTags->"S1.1178"],
    Cell[249164, 10819, 188, 7, 70, "Notes",
      CellTags->"S1.1178"],
    Cell[249355, 10828, 567, 19, 70, "Notes",
      CellTags->"S1.1178"]},
  "S1.1179"->{
    Cell[249959, 10852, 63, 1, 70, "ObjectName",
      CellTags->"S1.1179"],
    Cell[250025, 10855, 141, 4, 70, "CharacterName",
      CellTags->"S1.1179"],
    Cell[250169, 10861, 96, 1, 70, "Notes",
      CellTags->"S1.1179"],
    Cell[250268, 10864, 406, 17, 70, "Notes",
      CellTags->"S1.1179"],
    Cell[250677, 10883, 83, 1, 70, "Notes",
      CellTags->"S1.1179"],
    Cell[250763, 10886, 188, 7, 70, "Notes",
      CellTags->"S1.1179"],
    Cell[250954, 10895, 335, 11, 70, "Notes",
      CellTags->"S1.1179"]},
  "S1.1180"->{
    Cell[251326, 10911, 52, 1, 70, "ObjectName",
      CellTags->"S1.1180"],
    Cell[251381, 10914, 119, 4, 70, "CharacterName",
      CellTags->"S1.1180"],
    Cell[251503, 10920, 150, 5, 70, "Notes",
      CellTags->"S1.1180"],
    Cell[251656, 10927, 77, 1, 70, "Notes",
      CellTags->"S1.1180"],
    Cell[251736, 10930, 386, 17, 70, "Notes",
      CellTags->"S1.1180"],
    Cell[252125, 10949, 188, 7, 70, "Notes",
      CellTags->"S1.1180"],
    Cell[252316, 10958, 425, 15, 70, "Notes",
      CellTags->"S1.1180"]},
  "S1.1181"->{
    Cell[252778, 10978, 57, 1, 70, "ObjectName",
      CellTags->"S1.1181"],
    Cell[252838, 10981, 129, 4, 70, "CharacterName",
      CellTags->"S1.1181"],
    Cell[252970, 10987, 83, 1, 70, "Notes",
      CellTags->"S1.1181"],
    Cell[253056, 10990, 394, 17, 70, "Notes",
      CellTags->"S1.1181"],
    Cell[253453, 11009, 83, 1, 70, "Notes",
      CellTags->"S1.1181"],
    Cell[253539, 11012, 188, 7, 70, "Notes",
      CellTags->"S1.1181"],
    Cell[253730, 11021, 565, 19, 70, "Notes",
      CellTags->"S1.1181"]},
  "S1.1182"->{
    Cell[254332, 11045, 51, 1, 70, "ObjectName",
      CellTags->"S1.1182"],
    Cell[254386, 11048, 117, 4, 70, "CharacterName",
      CellTags->"S1.1182"],
    Cell[254506, 11054, 150, 5, 70, "Notes",
      CellTags->"S1.1182"],
    Cell[254659, 11061, 69, 1, 70, "Notes",
      CellTags->"S1.1182"],
    Cell[254731, 11064, 94, 1, 70, "Notes",
      CellTags->"S1.1182"],
    Cell[254828, 11067, 316, 11, 70, "Notes",
      CellTags->"S1.1182"],
    Cell[255147, 11080, 209, 7, 70, "Notes",
      CellTags->"S1.1182"]},
  "S1.1183"->{
    Cell[255393, 11092, 49, 1, 70, "ObjectName",
      CellTags->"S1.1183"],
    Cell[255445, 11095, 113, 4, 70, "CharacterName",
      CellTags->"S1.1183"],
    Cell[255561, 11101, 150, 5, 70, "Notes",
      CellTags->"S1.1183"],
    Cell[255714, 11108, 69, 1, 70, "Notes",
      CellTags->"S1.1183"],
    Cell[255786, 11111, 94, 1, 70, "Notes",
      CellTags->"S1.1183"],
    Cell[255883, 11114, 136, 4, 70, "Notes",
      CellTags->"S1.1183"],
    Cell[256022, 11120, 188, 7, 70, "Notes",
      CellTags->"S1.1183"],
    Cell[256213, 11129, 205, 7, 70, "Notes",
      CellTags->"S1.1183"]},
  "S1.1184"->{
    Cell[256455, 11141, 49, 1, 70, "ObjectName",
      CellTags->"S1.1184"],
    Cell[256507, 11144, 113, 4, 70, "CharacterName",
      CellTags->"S1.1184"],
    Cell[256623, 11150, 150, 5, 70, "Notes",
      CellTags->"S1.1184"],
    Cell[256776, 11157, 69, 1, 70, "Notes",
      CellTags->"S1.1184"],
    Cell[256848, 11160, 88, 1, 70, "Notes",
      CellTags->"S1.1184"],
    Cell[256939, 11163, 120, 4, 70, "Notes",
      CellTags->"S1.1184"],
    Cell[257062, 11169, 188, 7, 70, "Notes",
      CellTags->"S1.1184"],
    Cell[257253, 11178, 205, 7, 70, "Notes",
      CellTags->"S1.1184"]},
  "S1.1185"->{
    Cell[257495, 11190, 55, 1, 70, "ObjectName",
      CellTags->"S1.1185"],
    Cell[257553, 11193, 125, 4, 70, "CharacterName",
      CellTags->"S1.1185"],
    Cell[257681, 11199, 151, 5, 70, "Notes",
      CellTags->"S1.1185"],
    Cell[257835, 11206, 69, 1, 70, "Notes",
      CellTags->"S1.1185"],
    Cell[257907, 11209, 94, 1, 70, "Notes",
      CellTags->"S1.1185"],
    Cell[258004, 11212, 188, 7, 70, "Notes",
      CellTags->"S1.1185"],
    Cell[258195, 11221, 449, 15, 70, "Notes",
      CellTags->"S1.1185"]},
  "S1.1186"->{
    Cell[258681, 11241, 51, 1, 70, "ObjectName",
      CellTags->"S1.1186"],
    Cell[258735, 11244, 117, 4, 70, "CharacterName",
      CellTags->"S1.1186"],
    Cell[258855, 11250, 150, 5, 70, "Notes",
      CellTags->"S1.1186"],
    Cell[259008, 11257, 69, 1, 70, "Notes",
      CellTags->"S1.1186"],
    Cell[259080, 11260, 94, 1, 70, "Notes",
      CellTags->"S1.1186"],
    Cell[259177, 11263, 316, 11, 70, "Notes",
      CellTags->"S1.1186"],
    Cell[259496, 11276, 209, 7, 70, "Notes",
      CellTags->"S1.1186"]},
  "S1.1187"->{
    Cell[259742, 11288, 49, 1, 70, "ObjectName",
      CellTags->"S1.1187"],
    Cell[259794, 11291, 113, 4, 70, "CharacterName",
      CellTags->"S1.1187"],
    Cell[259910, 11297, 150, 5, 70, "Notes",
      CellTags->"S1.1187"],
    Cell[260063, 11304, 69, 1, 70, "Notes",
      CellTags->"S1.1187"],
    Cell[260135, 11307, 94, 1, 70, "Notes",
      CellTags->"S1.1187"],
    Cell[260232, 11310, 188, 7, 70, "Notes",
      CellTags->"S1.1187"],
    Cell[260423, 11319, 205, 7, 70, "Notes",
      CellTags->"S1.1187"]},
  "S1.1188"->{
    Cell[260665, 11331, 52, 1, 70, "ObjectName",
      CellTags->"S1.1188"],
    Cell[260720, 11334, 119, 4, 70, "CharacterName",
      CellTags->"S1.1188"],
    Cell[260842, 11340, 150, 5, 70, "Notes",
      CellTags->"S1.1188"],
    Cell[260995, 11347, 126, 4, 70, "Notes",
      CellTags->"S1.1188"],
    Cell[261124, 11353, 386, 17, 70, "Notes",
      CellTags->"S1.1188"],
    Cell[261513, 11372, 203, 7, 70, "Notes",
      CellTags->"S1.1188"],
    Cell[261719, 11381, 530, 19, 70, "Notes",
      CellTags->"S1.1188"],
    Cell[262252, 11402, 431, 15, 70, "Notes",
      CellTags->"S1.1188"]},
  "S1.1189"->{
    Cell[262720, 11422, 53, 1, 70, "ObjectName",
      CellTags->"S1.1189"],
    Cell[262776, 11425, 121, 4, 70, "CharacterName",
      CellTags->"S1.1189"],
    Cell[262900, 11431, 151, 5, 70, "Notes",
      CellTags->"S1.1189"],
    Cell[263054, 11438, 87, 1, 70, "Notes",
      CellTags->"S1.1189"],
    Cell[263144, 11441, 127, 4, 70, "Notes",
      CellTags->"S1.1189"],
    Cell[263274, 11447, 161, 5, 70, "Notes",
      CellTags->"S1.1189"],
    Cell[263438, 11454, 188, 7, 70, "Notes",
      CellTags->"S1.1189"],
    Cell[263629, 11463, 821, 27, 70, "Notes",
      CellTags->"S1.1189"]},
  "S1.1190"->{
    Cell[264487, 11495, 56, 1, 70, "ObjectName",
      CellTags->"S1.1190"],
    Cell[264546, 11498, 127, 4, 70, "CharacterName",
      CellTags->"S1.1190"],
    Cell[264676, 11504, 151, 5, 70, "Notes",
      CellTags->"S1.1190"],
    Cell[264830, 11511, 87, 1, 70, "Notes",
      CellTags->"S1.1190"],
    Cell[264920, 11514, 230, 7, 70, "Notes",
      CellTags->"S1.1190"],
    Cell[265153, 11523, 188, 7, 70, "Notes",
      CellTags->"S1.1190"],
    Cell[265344, 11532, 443, 15, 70, "Notes",
      CellTags->"S1.1190"]},
  "S1.1191"->{
    Cell[265824, 11552, 57, 1, 70, "ObjectName",
      CellTags->"S1.1191"],
    Cell[265884, 11555, 129, 4, 70, "CharacterName",
      CellTags->"S1.1191"],
    Cell[266016, 11561, 87, 1, 70, "Notes",
      CellTags->"S1.1191"],
    Cell[266106, 11564, 188, 7, 70, "Notes",
      CellTags->"S1.1191"],
    Cell[266297, 11573, 319, 11, 70, "Notes",
      CellTags->"S1.1191"]},
  "S1.1192"->{
    Cell[266653, 11589, 62, 1, 70, "ObjectName",
      CellTags->"S1.1192"],
    Cell[266718, 11592, 139, 4, 70, "CharacterName",
      CellTags->"S1.1192"],
    Cell[266860, 11598, 87, 1, 70, "Notes",
      CellTags->"S1.1192"],
    Cell[266950, 11601, 195, 7, 70, "Notes",
      CellTags->"S1.1192"],
    Cell[267148, 11610, 188, 7, 70, "Notes",
      CellTags->"S1.1192"],
    Cell[267339, 11619, 969, 31, 70, "Notes",
      CellTags->"S1.1192"]},
  "S1.1193"->{
    Cell[268345, 11655, 59, 1, 70, "ObjectName",
      CellTags->"S1.1193"],
    Cell[268407, 11658, 133, 4, 70, "CharacterName",
      CellTags->"S1.1193"],
    Cell[268543, 11664, 87, 1, 70, "Notes",
      CellTags->"S1.1193"],
    Cell[268633, 11667, 188, 7, 70, "Notes",
      CellTags->"S1.1193"],
    Cell[268824, 11676, 213, 7, 70, "Notes",
      CellTags->"S1.1193"]},
  "S1.1194"->{
    Cell[269074, 11688, 53, 1, 70, "ObjectName",
      CellTags->"S1.1194"],
    Cell[269130, 11691, 121, 4, 70, "CharacterName",
      CellTags->"S1.1194"],
    Cell[269254, 11697, 150, 5, 70, "Notes",
      CellTags->"S1.1194"],
    Cell[269407, 11704, 87, 1, 70, "Notes",
      CellTags->"S1.1194"],
    Cell[269497, 11707, 329, 11, 70, "Notes",
      CellTags->"S1.1194"],
    Cell[269829, 11720, 317, 11, 70, "Notes",
      CellTags->"S1.1194"]},
  "S1.1195"->{
    Cell[270183, 11736, 61, 1, 70, "ObjectName",
      CellTags->"S1.1195"],
    Cell[270247, 11739, 137, 4, 70, "CharacterName",
      CellTags->"S1.1195"],
    Cell[270387, 11745, 152, 5, 70, "Notes",
      CellTags->"S1.1195"],
    Cell[270542, 11752, 87, 1, 70, "Notes",
      CellTags->"S1.1195"],
    Cell[270632, 11755, 230, 7, 70, "Notes",
      CellTags->"S1.1195"],
    Cell[270865, 11764, 124, 4, 70, "Notes",
      CellTags->"S1.1195"],
    Cell[270992, 11770, 188, 7, 70, "Notes",
      CellTags->"S1.1195"],
    Cell[271183, 11779, 543, 19, 70, "Notes",
      CellTags->"S1.1195"]},
  "S1.1196"->{
    Cell[271763, 11803, 61, 1, 70, "ObjectName",
      CellTags->"S1.1196"],
    Cell[271827, 11806, 137, 4, 70, "CharacterName",
      CellTags->"S1.1196"],
    Cell[271967, 11812, 152, 5, 70, "Notes",
      CellTags->"S1.1196"],
    Cell[272122, 11819, 87, 1, 70, "Notes",
      CellTags->"S1.1196"],
    Cell[272212, 11822, 214, 7, 70, "Notes",
      CellTags->"S1.1196"],
    Cell[272429, 11831, 211, 7, 70, "Notes",
      CellTags->"S1.1196"],
    Cell[272643, 11840, 188, 7, 70, "Notes",
      CellTags->"S1.1196"],
    Cell[272834, 11849, 335, 11, 70, "Notes",
      CellTags->"S1.1196"]},
  "S1.1197"->{
    Cell[273206, 11865, 56, 1, 70, "ObjectName",
      CellTags->"S1.1197"],
    Cell[273265, 11868, 127, 4, 70, "CharacterName",
      CellTags->"S1.1197"],
    Cell[273395, 11874, 151, 5, 70, "Notes",
      CellTags->"S1.1197"],
    Cell[273549, 11881, 87, 1, 70, "Notes",
      CellTags->"S1.1197"],
    Cell[273639, 11884, 214, 7, 70, "Notes",
      CellTags->"S1.1197"],
    Cell[273856, 11893, 211, 7, 70, "Notes",
      CellTags->"S1.1197"],
    Cell[274070, 11902, 188, 7, 70, "Notes",
      CellTags->"S1.1197"],
    Cell[274261, 11911, 567, 19, 70, "Notes",
      CellTags->"S1.1197"]},
  "S1.1198"->{
    Cell[274865, 11935, 60, 1, 70, "ObjectName",
      CellTags->"S1.1198"],
    Cell[274928, 11938, 135, 4, 70, "CharacterName",
      CellTags->"S1.1198"],
    Cell[275066, 11944, 87, 1, 70, "Notes",
      CellTags->"S1.1198"],
    Cell[275156, 11947, 252, 8, 70, "Notes",
      CellTags->"S1.1198"],
    Cell[275411, 11957, 213, 7, 70, "Notes",
      CellTags->"S1.1198"],
    Cell[275627, 11966, 317, 11, 70, "Notes",
      CellTags->"S1.1198"],
    Cell[275947, 11979, 573, 19, 70, "Notes",
      CellTags->"S1.1198"]},
  "S1.1199"->{
    Cell[276557, 12003, 53, 1, 70, "ObjectName",
      CellTags->"S1.1199"],
    Cell[276613, 12006, 121, 4, 70, "CharacterName",
      CellTags->"S1.1199"],
    Cell[276737, 12012, 151, 5, 70, "Notes",
      CellTags->"S1.1199"],
    Cell[276891, 12019, 87, 1, 70, "Notes",
      CellTags->"S1.1199"],
    Cell[276981, 12022, 118, 4, 70, "Notes",
      CellTags->"S1.1199"],
    Cell[277102, 12028, 117, 4, 70, "Notes",
      CellTags->"S1.1199"],
    Cell[277222, 12034, 187, 7, 70, "Notes",
      CellTags->"S1.1199"],
    Cell[277412, 12043, 559, 19, 70, "Notes",
      CellTags->"S1.1199"]},
  "S1.1200"->{
    Cell[278008, 12067, 54, 1, 70, "ObjectName",
      CellTags->"S1.1200"],
    Cell[278065, 12070, 123, 4, 70, "CharacterName",
      CellTags->"S1.1200"],
    Cell[278191, 12076, 87, 1, 70, "Notes",
      CellTags->"S1.1200"],
    Cell[278281, 12079, 138, 4, 70, "Notes",
      CellTags->"S1.1200"],
    Cell[278422, 12085, 205, 7, 70, "Notes",
      CellTags->"S1.1200"]},
  "S1.1201"->{
    Cell[278664, 12097, 56, 1, 70, "ObjectName",
      CellTags->"S1.1201"],
    Cell[278723, 12100, 127, 4, 70, "CharacterName",
      CellTags->"S1.1201"],
    Cell[278853, 12106, 87, 1, 70, "Notes",
      CellTags->"S1.1201"],
    Cell[278943, 12109, 140, 4, 70, "Notes",
      CellTags->"S1.1201"],
    Cell[279086, 12115, 201, 7, 70, "Notes",
      CellTags->"S1.1201"]},
  "S1.1202"->{
    Cell[279324, 12127, 52, 1, 70, "ObjectName",
      CellTags->"S1.1202"],
    Cell[279379, 12130, 119, 4, 70, "CharacterName",
      CellTags->"S1.1202"],
    Cell[279501, 12136, 222, 7, 70, "Notes",
      CellTags->"S1.1202"],
    Cell[279726, 12145, 75, 1, 70, "Notes",
      CellTags->"S1.1202"],
    Cell[279804, 12148, 203, 7, 70, "Notes",
      CellTags->"S1.1202"],
    Cell[280010, 12157, 315, 11, 70, "Notes",
      CellTags->"S1.1202"],
    Cell[280328, 12170, 537, 19, 70, "Notes",
      CellTags->"S1.1202"]},
  "S1.1203"->{
    Cell[280902, 12194, 50, 1, 70, "ObjectName",
      CellTags->"S1.1203"],
    Cell[280955, 12197, 115, 4, 70, "CharacterName",
      CellTags->"S1.1203"],
    Cell[281073, 12203, 150, 5, 70, "Notes",
      CellTags->"S1.1203"],
    Cell[281226, 12210, 126, 4, 70, "Notes",
      CellTags->"S1.1203"],
    Cell[281355, 12216, 476, 23, 70, "Notes",
      CellTags->"S1.1203"],
    Cell[281834, 12241, 258, 9, 70, "Notes",
      CellTags->"S1.1203"],
    Cell[282095, 12252, 317, 11, 70, "Notes",
      CellTags->"S1.1203"],
    Cell[282415, 12265, 531, 19, 70, "Notes",
      CellTags->"S1.1203"]},
  "S1.1204"->{
    Cell[282983, 12289, 55, 1, 70, "ObjectName",
      CellTags->"S1.1204"],
    Cell[283041, 12292, 125, 4, 70, "CharacterName",
      CellTags->"S1.1204"],
    Cell[283169, 12298, 214, 7, 70, "Notes",
      CellTags->"S1.1204"],
    Cell[283386, 12307, 88, 1, 70, "Notes",
      CellTags->"S1.1204"],
    Cell[283477, 12310, 392, 17, 70, "Notes",
      CellTags->"S1.1204"],
    Cell[283872, 12329, 188, 7, 70, "Notes",
      CellTags->"S1.1204"],
    Cell[284063, 12338, 209, 7, 70, "Notes",
      CellTags->"S1.1204"]},
  "S1.1205"->{
    Cell[284309, 12350, 56, 1, 70, "ObjectName",
      CellTags->"S1.1205"],
    Cell[284368, 12353, 127, 4, 70, "CharacterName",
      CellTags->"S1.1205"],
    Cell[284498, 12359, 152, 5, 70, "Notes",
      CellTags->"S1.1205"],
    Cell[284653, 12366, 96, 1, 70, "Notes",
      CellTags->"S1.1205"],
    Cell[284752, 12369, 394, 17, 70, "Notes",
      CellTags->"S1.1205"],
    Cell[285149, 12388, 125, 4, 70, "Notes",
      CellTags->"S1.1205"],
    Cell[285277, 12394, 83, 1, 70, "Notes",
      CellTags->"S1.1205"],
    Cell[285363, 12397, 316, 11, 70, "Notes",
      CellTags->"S1.1205"],
    Cell[285682, 12410, 724, 23, 70, "Notes",
      CellTags->"S1.1205"]},
  "S1.1206"->{
    Cell[286443, 12438, 59, 1, 70, "ObjectName",
      CellTags->"S1.1206"],
    Cell[286505, 12441, 133, 4, 70, "CharacterName",
      CellTags->"S1.1206"],
    Cell[286641, 12447, 86, 1, 70, "Notes",
      CellTags->"S1.1206"],
    Cell[286730, 12450, 249, 8, 70, "Notes",
      CellTags->"S1.1206"],
    Cell[286982, 12460, 161, 7, 70, "Notes",
      CellTags->"S1.1206"],
    Cell[287146, 12469, 243, 6, 70, "Notes",
      CellTags->"S1.1206"],
    Cell[287392, 12477, 207, 7, 70, "Notes",
      CellTags->"S1.1206"]},
  "S1.1207"->{
    Cell[287636, 12489, 54, 1, 70, "ObjectName",
      CellTags->"S1.1207"],
    Cell[287693, 12492, 123, 4, 70, "CharacterName",
      CellTags->"S1.1207"],
    Cell[287819, 12498, 232, 7, 70, "Notes",
      CellTags->"S1.1207"],
    Cell[288054, 12507, 87, 1, 70, "Notes",
      CellTags->"S1.1207"],
    Cell[288144, 12510, 119, 4, 70, "Notes",
      CellTags->"S1.1207"],
    Cell[288266, 12516, 185, 6, 70, "Notes",
      CellTags->"S1.1207"],
    Cell[288454, 12524, 380, 11, 70, "Notes",
      CellTags->"S1.1207"],
    Cell[288837, 12537, 187, 7, 70, "Notes",
      CellTags->"S1.1207"],
    Cell[289027, 12546, 671, 23, 70, "Notes",
      CellTags->"S1.1207"]},
  "S1.1208"->{
    Cell[289735, 12574, 48, 1, 70, "ObjectName",
      CellTags->"S1.1208"],
    Cell[289786, 12577, 111, 4, 70, "CharacterName",
      CellTags->"S1.1208"],
    Cell[289900, 12583, 284, 9, 70, "Notes",
      CellTags->"S1.1208"],
    Cell[290187, 12594, 75, 1, 70, "Notes",
      CellTags->"S1.1208"],
    Cell[290265, 12597, 174, 7, 70, "Notes",
      CellTags->"S1.1208"],
    Cell[290442, 12606, 315, 11, 70, "Notes",
      CellTags->"S1.1208"],
    Cell[290760, 12619, 313, 11, 70, "Notes",
      CellTags->"S1.1208"]},
  "S1.1209"->{
    Cell[291110, 12635, 48, 1, 70, "ObjectName",
      CellTags->"S1.1209"],
    Cell[291161, 12638, 111, 4, 70, "CharacterName",
      CellTags->"S1.1209"],
    Cell[291275, 12644, 150, 5, 70, "Notes",
      CellTags->"S1.1209"],
    Cell[291428, 12651, 69, 1, 70, "Notes",
      CellTags->"S1.1209"],
    Cell[291500, 12654, 94, 1, 70, "Notes",
      CellTags->"S1.1209"],
    Cell[291597, 12657, 106, 4, 70, "Notes",
      CellTags->"S1.1209"],
    Cell[291706, 12663, 188, 7, 70, "Notes",
      CellTags->"S1.1209"],
    Cell[291897, 12672, 421, 15, 70, "Notes",
      CellTags->"S1.1209"]},
  "S1.1210"->{
    Cell[292355, 12692, 49, 1, 70, "ObjectName",
      CellTags->"S1.1210"],
    Cell[292407, 12695, 113, 4, 70, "CharacterName",
      CellTags->"S1.1210"],
    Cell[292523, 12701, 87, 1, 70, "Notes",
      CellTags->"S1.1210"],
    Cell[292613, 12704, 225, 8, 70, "Notes",
      CellTags->"S1.1210"],
    Cell[292841, 12714, 188, 7, 70, "Notes",
      CellTags->"S1.1210"],
    Cell[293032, 12723, 419, 15, 70, "Notes",
      CellTags->"S1.1210"]},
  "S1.1211"->{
    Cell[293488, 12743, 51, 1, 70, "ObjectName",
      CellTags->"S1.1211"],
    Cell[293542, 12746, 117, 4, 70, "CharacterName",
      CellTags->"S1.1211"],
    Cell[293662, 12752, 150, 5, 70, "Notes",
      CellTags->"S1.1211"],
    Cell[293815, 12759, 80, 1, 70, "Notes",
      CellTags->"S1.1211"],
    Cell[293898, 12762, 420, 18, 70, "Notes",
      CellTags->"S1.1211"],
    Cell[294321, 12782, 187, 7, 70, "Notes",
      CellTags->"S1.1211"],
    Cell[294511, 12791, 201, 7, 70, "Notes",
      CellTags->"S1.1211"]},
  "S1.1212"->{
    Cell[294749, 12803, 57, 1, 70, "ObjectName",
      CellTags->"S1.1212"],
    Cell[294809, 12806, 129, 4, 70, "CharacterName",
      CellTags->"S1.1212"],
    Cell[294941, 12812, 150, 5, 70, "Notes",
      CellTags->"S1.1212"],
    Cell[295094, 12819, 125, 4, 70, "Notes",
      CellTags->"S1.1212"],
    Cell[295222, 12825, 273, 8, 70, "Notes",
      CellTags->"S1.1212"],
    Cell[295498, 12835, 424, 15, 70, "Notes",
      CellTags->"S1.1212"],
    Cell[295925, 12852, 325, 11, 70, "Notes",
      CellTags->"S1.1212"]},
  "S1.1213"->{
    Cell[296287, 12868, 57, 1, 70, "ObjectName",
      CellTags->"S1.1213"],
    Cell[296347, 12871, 129, 4, 70, "CharacterName",
      CellTags->"S1.1213"],
    Cell[296479, 12877, 151, 5, 70, "Notes",
      CellTags->"S1.1213"],
    Cell[296633, 12884, 87, 1, 70, "Notes",
      CellTags->"S1.1213"],
    Cell[296723, 12887, 80, 1, 70, "Notes",
      CellTags->"S1.1213"],
    Cell[296806, 12890, 188, 7, 70, "Notes",
      CellTags->"S1.1213"],
    Cell[296997, 12899, 561, 19, 70, "Notes",
      CellTags->"S1.1213"]},
  "S1.1214"->{
    Cell[297595, 12923, 58, 1, 70, "ObjectName",
      CellTags->"S1.1214"],
    Cell[297656, 12926, 131, 4, 70, "CharacterName",
      CellTags->"S1.1214"],
    Cell[297790, 12932, 87, 1, 70, "Notes",
      CellTags->"S1.1214"],
    Cell[297880, 12935, 188, 7, 70, "Notes",
      CellTags->"S1.1214"],
    Cell[298071, 12944, 317, 11, 70, "Notes",
      CellTags->"S1.1214"]},
  "S1.1215"->{
    Cell[298425, 12960, 63, 1, 70, "ObjectName",
      CellTags->"S1.1215"],
    Cell[298491, 12963, 141, 4, 70, "CharacterName",
      CellTags->"S1.1215"],
    Cell[298635, 12969, 87, 1, 70, "Notes",
      CellTags->"S1.1215"],
    Cell[298725, 12972, 188, 7, 70, "Notes",
      CellTags->"S1.1215"],
    Cell[298916, 12981, 967, 31, 70, "Notes",
      CellTags->"S1.1215"]},
  "S1.1216"->{
    Cell[299920, 13017, 60, 1, 70, "ObjectName",
      CellTags->"S1.1216"],
    Cell[299983, 13020, 135, 4, 70, "CharacterName",
      CellTags->"S1.1216"],
    Cell[300121, 13026, 87, 1, 70, "Notes",
      CellTags->"S1.1216"],
    Cell[300211, 13029, 123, 4, 70, "Notes",
      CellTags->"S1.1216"],
    Cell[300337, 13035, 188, 7, 70, "Notes",
      CellTags->"S1.1216"],
    Cell[300528, 13044, 211, 7, 70, "Notes",
      CellTags->"S1.1216"]},
  "S1.1217"->{
    Cell[300776, 13056, 62, 1, 70, "ObjectName",
      CellTags->"S1.1217"],
    Cell[300841, 13059, 139, 4, 70, "CharacterName",
      CellTags->"S1.1217"],
    Cell[300983, 13065, 152, 5, 70, "Notes",
      CellTags->"S1.1217"],
    Cell[301138, 13072, 87, 1, 70, "Notes",
      CellTags->"S1.1217"],
    Cell[301228, 13075, 80, 1, 70, "Notes",
      CellTags->"S1.1217"],
    Cell[301311, 13078, 188, 7, 70, "Notes",
      CellTags->"S1.1217"],
    Cell[301502, 13087, 443, 15, 70, "Notes",
      CellTags->"S1.1217"]},
  "S1.1218"->{
    Cell[301982, 13107, 62, 1, 70, "ObjectName",
      CellTags->"S1.1218"],
    Cell[302047, 13110, 139, 4, 70, "CharacterName",
      CellTags->"S1.1218"],
    Cell[302189, 13116, 152, 5, 70, "Notes",
      CellTags->"S1.1218"],
    Cell[302344, 13123, 87, 1, 70, "Notes",
      CellTags->"S1.1218"],
    Cell[302434, 13126, 80, 1, 70, "Notes",
      CellTags->"S1.1218"],
    Cell[302517, 13129, 229, 7, 70, "Notes",
      CellTags->"S1.1218"],
    Cell[302749, 13138, 188, 7, 70, "Notes",
      CellTags->"S1.1218"],
    Cell[302940, 13147, 443, 15, 70, "Notes",
      CellTags->"S1.1218"]},
  "S1.1219"->{
    Cell[303420, 13167, 57, 1, 70, "ObjectName",
      CellTags->"S1.1219"],
    Cell[303480, 13170, 129, 4, 70, "CharacterName",
      CellTags->"S1.1219"],
    Cell[303612, 13176, 151, 5, 70, "Notes",
      CellTags->"S1.1219"],
    Cell[303766, 13183, 87, 1, 70, "Notes",
      CellTags->"S1.1219"],
    Cell[303856, 13186, 80, 1, 70, "Notes",
      CellTags->"S1.1219"],
    Cell[303939, 13189, 229, 7, 70, "Notes",
      CellTags->"S1.1219"],
    Cell[304171, 13198, 188, 7, 70, "Notes",
      CellTags->"S1.1219"],
    Cell[304362, 13207, 685, 23, 70, "Notes",
      CellTags->"S1.1219"]},
  "S1.1220"->{
    Cell[305084, 13235, 61, 1, 70, "ObjectName",
      CellTags->"S1.1220"],
    Cell[305148, 13238, 137, 4, 70, "CharacterName",
      CellTags->"S1.1220"],
    Cell[305288, 13244, 87, 1, 70, "Notes",
      CellTags->"S1.1220"],
    Cell[305378, 13247, 188, 7, 70, "Notes",
      CellTags->"S1.1220"],
    Cell[305569, 13256, 971, 31, 70, "Notes",
      CellTags->"S1.1220"]},
  "S1.1221"->{
    Cell[306577, 13292, 66, 1, 70, "ObjectName",
      CellTags->"S1.1221"],
    Cell[306646, 13295, 147, 4, 70, "CharacterName",
      CellTags->"S1.1221"],
    Cell[306796, 13301, 153, 5, 70, "Notes",
      CellTags->"S1.1221"],
    Cell[306952, 13308, 87, 1, 70, "Notes",
      CellTags->"S1.1221"],
    Cell[307042, 13311, 80, 1, 70, "Notes",
      CellTags->"S1.1221"],
    Cell[307125, 13314, 188, 7, 70, "Notes",
      CellTags->"S1.1221"],
    Cell[307316, 13323, 325, 11, 70, "Notes",
      CellTags->"S1.1221"]},
  "S1.1222"->{
    Cell[307678, 13339, 55, 1, 70, "ObjectName",
      CellTags->"S1.1222"],
    Cell[307736, 13342, 125, 4, 70, "CharacterName",
      CellTags->"S1.1222"],
    Cell[307864, 13348, 150, 5, 70, "Notes",
      CellTags->"S1.1222"],
    Cell[308017, 13355, 75, 1, 70, "Notes",
      CellTags->"S1.1222"],
    Cell[308095, 13358, 212, 6, 70, "Notes",
      CellTags->"S1.1222"],
    Cell[308310, 13366, 112, 4, 70, "Notes",
      CellTags->"S1.1222"],
    Cell[308425, 13372, 201, 7, 70, "Notes",
      CellTags->"S1.1222"],
    Cell[308629, 13381, 187, 7, 70, "Notes",
      CellTags->"S1.1222"],
    Cell[308819, 13390, 193, 7, 70, "Notes",
      CellTags->"S1.1222"]},
  "S1.1223"->{
    Cell[309049, 13402, 60, 1, 70, "ObjectName",
      CellTags->"S1.1223"],
    Cell[309112, 13405, 135, 4, 70, "CharacterName",
      CellTags->"S1.1223"],
    Cell[309250, 13411, 150, 5, 70, "Notes",
      CellTags->"S1.1223"],
    Cell[309403, 13418, 87, 1, 70, "Notes",
      CellTags->"S1.1223"],
    Cell[309493, 13421, 210, 7, 70, "Notes",
      CellTags->"S1.1223"],
    Cell[309706, 13430, 188, 7, 70, "Notes",
      CellTags->"S1.1223"],
    Cell[309897, 13439, 425, 15, 70, "Notes",
      CellTags->"S1.1223"]},
  "S1.1224"->{
    Cell[310359, 13459, 49, 1, 70, "ObjectName",
      CellTags->"S1.1224"],
    Cell[310411, 13462, 113, 4, 70, "CharacterName",
      CellTags->"S1.1224"],
    Cell[310527, 13468, 87, 1, 70, "Notes",
      CellTags->"S1.1224"],
    Cell[310617, 13471, 99, 3, 70, "Notes",
      CellTags->"S1.1224"],
    Cell[310719, 13476, 112, 4, 70, "Notes",
      CellTags->"S1.1224"],
    Cell[310834, 13482, 188, 7, 70, "Notes",
      CellTags->"S1.1224"],
    Cell[311025, 13491, 303, 11, 70, "Notes",
      CellTags->"S1.1224"]},
  "S1.1225"->{
    Cell[311365, 13507, 51, 1, 70, "ObjectName",
      CellTags->"S1.1225"],
    Cell[311419, 13510, 117, 4, 70, "CharacterName",
      CellTags->"S1.1225"],
    Cell[311539, 13516, 150, 5, 70, "Notes",
      CellTags->"S1.1225"],
    Cell[311692, 13523, 80, 1, 70, "Notes",
      CellTags->"S1.1225"],
    Cell[311775, 13526, 420, 18, 70, "Notes",
      CellTags->"S1.1225"],
    Cell[312198, 13546, 187, 7, 70, "Notes",
      CellTags->"S1.1225"],
    Cell[312388, 13555, 297, 11, 70, "Notes",
      CellTags->"S1.1225"]},
  "S1.1226"->{
    Cell[312722, 13571, 58, 1, 70, "ObjectName",
      CellTags->"S1.1226"],
    Cell[312783, 13574, 131, 4, 70, "CharacterName",
      CellTags->"S1.1226"],
    Cell[312917, 13580, 151, 5, 70, "Notes",
      CellTags->"S1.1226"],
    Cell[313071, 13587, 87, 1, 70, "Notes",
      CellTags->"S1.1226"],
    Cell[313161, 13590, 188, 7, 70, "Notes",
      CellTags->"S1.1226"],
    Cell[313352, 13599, 559, 19, 70, "Notes",
      CellTags->"S1.1226"]},
  "S1.1227"->{
    Cell[313948, 13623, 50, 1, 70, "ObjectName",
      CellTags->"S1.1227"],
    Cell[314001, 13626, 115, 4, 70, "CharacterName",
      CellTags->"S1.1227"],
    Cell[314119, 13632, 220, 7, 70, "Notes",
      CellTags->"S1.1227"],
    Cell[314342, 13641, 75, 1, 70, "Notes",
      CellTags->"S1.1227"],
    Cell[314420, 13644, 220, 9, 70, "Notes",
      CellTags->"S1.1227"],
    Cell[314643, 13655, 315, 11, 70, "Notes",
      CellTags->"S1.1227"],
    Cell[314961, 13668, 437, 15, 70, "Notes",
      CellTags->"S1.1227"]},
  "S1.1228"->{
    Cell[315435, 13688, 50, 1, 70, "ObjectName",
      CellTags->"S1.1228"],
    Cell[315488, 13691, 115, 4, 70, "CharacterName",
      CellTags->"S1.1228"],
    Cell[315606, 13697, 150, 5, 70, "Notes",
      CellTags->"S1.1228"],
    Cell[315759, 13704, 76, 1, 70, "Notes",
      CellTags->"S1.1228"],
    Cell[315838, 13707, 149, 4, 70, "Notes",
      CellTags->"S1.1228"],
    Cell[315990, 13713, 188, 7, 70, "Notes",
      CellTags->"S1.1228"],
    Cell[316181, 13722, 193, 7, 70, "Notes",
      CellTags->"S1.1228"]},
  "S1.1229"->{
    Cell[316411, 13734, 72, 1, 70, "ObjectName",
      CellTags->"S1.1229"],
    Cell[316486, 13737, 204, 6, 70, "CharacterName",
      CellTags->"S1.1229"],
    Cell[316693, 13745, 227, 7, 70, "Notes",
      CellTags->"S1.1229"],
    Cell[316923, 13754, 70, 1, 70, "Notes",
      CellTags->"S1.1229"],
    Cell[316996, 13757, 155, 4, 70, "Notes",
      CellTags->"S1.1229"],
    Cell[317154, 13763, 87, 1, 70, "Notes",
      CellTags->"S1.1229"],
    Cell[317244, 13766, 221, 5, 70, "Notes",
      CellTags->"S1.1229"],
    Cell[317468, 13773, 188, 7, 70, "Notes",
      CellTags->"S1.1229"],
    Cell[317659, 13782, 448, 15, 70, "Notes",
      CellTags->"S1.1229"]},
  "S1.1230"->{
    Cell[318144, 13802, 94, 3, 70, "ObjectName",
      CellTags->"S1.1230"],
    Cell[318241, 13807, 232, 6, 70, "CharacterName",
      CellTags->"S1.1230"],
    Cell[318476, 13815, 227, 7, 70, "Notes",
      CellTags->"S1.1230"],
    Cell[318706, 13824, 70, 1, 70, "Notes",
      CellTags->"S1.1230"],
    Cell[318779, 13827, 155, 4, 70, "Notes",
      CellTags->"S1.1230"],
    Cell[318937, 13833, 316, 9, 70, "Notes",
      CellTags->"S1.1230"],
    Cell[319256, 13844, 123, 4, 70, "Notes",
      CellTags->"S1.1230"],
    Cell[319382, 13850, 229, 5, 70, "Notes",
      CellTags->"S1.1230"],
    Cell[319614, 13857, 188, 7, 70, "Notes",
      CellTags->"S1.1230"],
    Cell[319805, 13866, 462, 15, 70, "Notes",
      CellTags->"S1.1230"]},
  "S1.1231"->{
    Cell[320304, 13886, 55, 1, 70, "ObjectName",
      CellTags->"S1.1231"],
    Cell[320362, 13889, 125, 4, 70, "CharacterName",
      CellTags->"S1.1231"],
    Cell[320490, 13895, 151, 5, 70, "Notes",
      CellTags->"S1.1231"],
    Cell[320644, 13902, 87, 1, 70, "Notes",
      CellTags->"S1.1231"],
    Cell[320734, 13905, 80, 1, 70, "Notes",
      CellTags->"S1.1231"],
    Cell[320817, 13908, 188, 5, 70, "Notes",
      CellTags->"S1.1231"],
    Cell[321008, 13915, 188, 7, 70, "Notes",
      CellTags->"S1.1231"],
    Cell[321199, 13924, 323, 11, 70, "Notes",
      CellTags->"S1.1231"]},
  "S1.1232"->{
    Cell[321559, 13940, 55, 1, 70, "ObjectName",
      CellTags->"S1.1232"],
    Cell[321617, 13943, 125, 4, 70, "CharacterName",
      CellTags->"S1.1232"],
    Cell[321745, 13949, 151, 5, 70, "Notes",
      CellTags->"S1.1232"],
    Cell[321899, 13956, 87, 1, 70, "Notes",
      CellTags->"S1.1232"],
    Cell[321989, 13959, 80, 1, 70, "Notes",
      CellTags->"S1.1232"],
    Cell[322072, 13962, 188, 5, 70, "Notes",
      CellTags->"S1.1232"],
    Cell[322263, 13969, 188, 7, 70, "Notes",
      CellTags->"S1.1232"],
    Cell[322454, 13978, 325, 11, 70, "Notes",
      CellTags->"S1.1232"]},
  "S1.1233"->{
    Cell[322816, 13994, 57, 1, 70, "ObjectName",
      CellTags->"S1.1233"],
    Cell[322876, 13997, 129, 4, 70, "CharacterName",
      CellTags->"S1.1233"],
    Cell[323008, 14003, 150, 5, 70, "Notes",
      CellTags->"S1.1233"],
    Cell[323161, 14010, 126, 4, 70, "Notes",
      CellTags->"S1.1233"],
    Cell[323290, 14016, 396, 17, 70, "Notes",
      CellTags->"S1.1233"],
    Cell[323689, 14035, 316, 11, 70, "Notes",
      CellTags->"S1.1233"],
    Cell[324008, 14048, 471, 15, 70, "Notes",
      CellTags->"S1.1233"]},
  "S1.1234"->{
    Cell[324516, 14068, 61, 1, 70, "ObjectName",
      CellTags->"S1.1234"],
    Cell[324580, 14071, 137, 4, 70, "CharacterName",
      CellTags->"S1.1234"],
    Cell[324720, 14077, 86, 1, 70, "Notes",
      CellTags->"S1.1234"],
    Cell[324809, 14080, 404, 17, 70, "Notes",
      CellTags->"S1.1234"],
    Cell[325216, 14099, 188, 7, 70, "Notes",
      CellTags->"S1.1234"],
    Cell[325407, 14108, 214, 7, 70, "Notes",
      CellTags->"S1.1234"]},
  "S1.1235"->{
    Cell[325658, 14120, 61, 1, 70, "ObjectName",
      CellTags->"S1.1235"],
    Cell[325722, 14123, 137, 4, 70, "CharacterName",
      CellTags->"S1.1235"],
    Cell[325862, 14129, 86, 1, 70, "Notes",
      CellTags->"S1.1235"],
    Cell[325951, 14132, 404, 17, 70, "Notes",
      CellTags->"S1.1235"],
    Cell[326358, 14151, 188, 7, 70, "Notes",
      CellTags->"S1.1235"],
    Cell[326549, 14160, 471, 15, 70, "Notes",
      CellTags->"S1.1235"]},
  "S1.1236"->{
    Cell[327057, 14180, 59, 1, 70, "ObjectName",
      CellTags->"S1.1236"],
    Cell[327119, 14183, 133, 4, 70, "CharacterName",
      CellTags->"S1.1236"],
    Cell[327255, 14189, 86, 1, 70, "Notes",
      CellTags->"S1.1236"],
    Cell[327344, 14192, 400, 17, 70, "Notes",
      CellTags->"S1.1236"],
    Cell[327747, 14211, 217, 7, 70, "Notes",
      CellTags->"S1.1236"],
    Cell[327967, 14220, 316, 11, 70, "Notes",
      CellTags->"S1.1236"],
    Cell[328286, 14233, 495, 15, 70, "Notes",
      CellTags->"S1.1236"]},
  "S1.1237"->{
    Cell[328818, 14253, 56, 1, 70, "ObjectName",
      CellTags->"S1.1237"],
    Cell[328877, 14256, 127, 4, 70, "CharacterName",
      CellTags->"S1.1237"],
    Cell[329007, 14262, 86, 1, 70, "Notes",
      CellTags->"S1.1237"],
    Cell[329096, 14265, 394, 17, 70, "Notes",
      CellTags->"S1.1237"],
    Cell[329493, 14284, 188, 7, 70, "Notes",
      CellTags->"S1.1237"],
    Cell[329684, 14293, 339, 11, 70, "Notes",
      CellTags->"S1.1237"]},
  "S1.1238"->{
    Cell[330060, 14309, 62, 1, 70, "ObjectName",
      CellTags->"S1.1238"],
    Cell[330125, 14312, 139, 4, 70, "CharacterName",
      CellTags->"S1.1238"],
    Cell[330267, 14318, 150, 5, 70, "Notes",
      CellTags->"S1.1238"],
    Cell[330420, 14325, 126, 4, 70, "Notes",
      CellTags->"S1.1238"],
    Cell[330549, 14331, 401, 17, 70, "Notes",
      CellTags->"S1.1238"],
    Cell[330953, 14350, 188, 7, 70, "Notes",
      CellTags->"S1.1238"],
    Cell[331144, 14359, 471, 15, 70, "Notes",
      CellTags->"S1.1238"]},
  "S1.1239"->{
    Cell[331652, 14379, 57, 1, 70, "ObjectName",
      CellTags->"S1.1239"],
    Cell[33