(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     50158,       1942]*)
(*NotebookOutlinePosition[     87054,       2737]*)
(*  CellTagsIndexPosition[     84630,       2665]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.14 ", "HeadingNumber"],
  "Developer Context Objects in ",
  StyleBox["Mathematica", "SBO"],
  " 5.2"
}], "Section",
  CellTags->{"SA.14.0", "0.1"}],

Cell[CellGroupData[{

Cell["A.14.1 Introduction", "Subsection",
  CellTags->{"SA.14.1", "1.1"}],

Cell[TextData[{
  "The objects listed below are included in the ",
  StyleBox["Developer`", "MR"],
  " context in ",
  StyleBox["Mathematica", "TI"],
  " Version 5.2; some of them may change or be moved to the ",
  StyleBox["System`", "MR"],
  " context in subsequent versions of ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"SA.14.1", "1.2"}],

Cell[TextData[{
  "The ",
  StyleBox["Developer`", "MR"],
  " context includes functions that directly access specific internal \
algorithms and capabilities of ",
  StyleBox["Mathematica", "TI"],
  " that are normally used only as part of more general functions. "
}], "Text",
  CellTags->{"SA.14.1", "1.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Developer`", "MR"],
              StyleBox["name", "TI"],
              " "
            }]], Cell[TextData[{
              "access a specific object in the ",
              StyleBox["Developer`", "MR"],
              " context "
            }]]},
          {Cell[TextData[{
              StyleBox["<<Developer`", "MR"],
              " "
            }]], Cell[TextData[{
              "set up to be able to access all ",
              StyleBox["Developer`", "MR"],
              " objects by name "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.14.1"],

Cell[TextData[{
  "Ways to access functions in the ",
  StyleBox["Developer`", "MR"],
  " context. "
}], "Caption",
  CellTags->"SA.14.1"],

Cell[TextData[{
  "Note that ",
  StyleBox["<<Developer`", "MR"],
  " adds the ",
  StyleBox["Developer`", "MR"],
  " context to your ",
  StyleBox["$ContextPath", "MR"],
  "\[ThinSpace]. You can remove it again by explicitly modifying the value of \
",
  StyleBox["$ContextPath", "MR"],
  "\[ThinSpace]. You can set up to access ",
  StyleBox["Developer`", "MR"],
  " context objects automatically in all ",
  StyleBox["Mathematica", "TI"],
  " sessions by adding ",
  StyleBox["<<Developer`", "MR"],
  " to your ",
  StyleBox["init.m", "MR"],
  " file. "
}], "Text",
  CellTags->{"SA.14.1", "1.4"}],

Cell[CellGroupData[{

Cell["Developer`BesselSimplify", "ObjectName",
  CellTags->{"S1.1001", "Developer`BesselSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BesselSimplify[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " transforms Bessel functions in ",
  StyleBox["expr", "TI"],
  ", trying to either decrease the number of Bessel functions, or convert \
Bessel functions into more elementary functions. "
}], "Usage",
  CellTags->{"S1.1001", "Developer`BesselSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BesselSimplify", "MR"],
  " is automatically used inside ",
  StyleBox["FullSimplify", "MR"],
  " and ",
  StyleBox["FunctionExpand", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1001", "Developer`BesselSimplify"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`BitLength", "ObjectName",
  CellTags->{"S1.1002", "Developer`BitLength"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BitLength[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " gives the number of binary bits necessary to represent the integer ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1002", "Developer`BitLength"}],

Cell[TextData[{
  "\[FilledSmallSquare] For positive ",
  StyleBox["n", "TI"],
  ", ",
  StyleBox["BitLength[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " is effectively an efficient version of ",
  StyleBox["Floor[Log[2,", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1002", "Developer`BitLength"}],

Cell[TextData[{
  "\[FilledSmallSquare] For negative ",
  StyleBox["n", "TI"],
  " it is equivalent to ",
  StyleBox["BitLength[BitNot[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1002", "Developer`BitLength"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["IntegerExponent",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["MantissaExponent",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1002", "Developer`BitLength"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`BitShiftLeft", "ObjectName",
  CellTags->{"S1.1003", "Developer`BitShiftLeft"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BitShiftLeft[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["d", "TI"],
  StyleBox["]", "MR"],
  " shifts the binary bits in the integer ",
  StyleBox["n", "TI"],
  " to the left by ",
  StyleBox["d", "TI"],
  " places, padding with zeros on the right. "
}], "Usage",
  CellTags->{"S1.1003", "Developer`BitShiftLeft"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BitShiftLeft[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["d", "TI"],
  StyleBox["]", "MR"],
  " is equivalent to ",
  StyleBox["n", "TI"],
  " ",
  StyleBox["2^", "MR"],
  StyleBox["d", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1003", "Developer`BitShiftLeft"}],

Cell[TextData[{
  "\[FilledSmallSquare] Negative values of ",
  StyleBox["d", "TI"],
  " shift to the right. "
}], "Notes",
  CellTags->{"S1.1003", "Developer`BitShiftLeft"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`BitShiftRight", "ObjectName",
  CellTags->{"S1.1004", "Developer`BitShiftRight"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BitShiftRight[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["d", "TI"],
  StyleBox["]", "MR"],
  " shifts the binary bits in the integer ",
  StyleBox["n", "TI"],
  " to the right by ",
  StyleBox["d", "TI"],
  " places, dropping bits that are shifted past the units position on the \
right.  "
}], "Usage",
  CellTags->{"S1.1004", "Developer`BitShiftRight"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BitShiftRight[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["d", "TI"],
  StyleBox["]", "MR"],
  " is equivalent to ",
  StyleBox["IntegerPart[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["/2^", "MR"],
  StyleBox["d", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1004", "Developer`BitShiftRight"}],

Cell[TextData[{
  "\[FilledSmallSquare] Negative values of ",
  StyleBox["d", "TI"],
  " shift to the left. "
}], "Notes",
  CellTags->{"S1.1004", "Developer`BitShiftRight"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MantissaExponent",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1004", "Developer`BitShiftRight"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`ClearCache", "ObjectName",
  CellTags->{"S1.1005", "Developer`ClearCache"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ClearCache[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " clears internal caches of stored results. "
}], "Usage",
  CellTags->{"S1.1005", "Developer`ClearCache"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ClearCache", "MR"],
  " is useful if one needs to generate worst\[Hyphen]case timing results \
independent of previous computations. "
}], "Notes",
  CellTags->{"S1.1005", "Developer`ClearCache"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ClearCache[\"Numeric\"]", "MR"],
  " clears only caches of numeric results. "
}], "Notes",
  CellTags->{"S1.1005", "Developer`ClearCache"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ClearCache[\"Symbolic\"]", "MR"],
  " clears only caches of symbolic results. "
}], "Notes",
  CellTags->{"S1.1005", "Developer`ClearCache"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Update",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1005", "Developer`ClearCache"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`ClipboardNotebook", "ObjectName",
  CellTags->{"S1.1006", "Developer`ClipboardNotebook"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ClipboardNotebook[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " gives the notebook object corresponding to the invisible notebook \
corresponding to the clipboard for copy and paste operations. "
}], "Usage",
  CellTags->{"S1.1006", "Developer`ClipboardNotebook"}],

Cell["\<\
\[FilledSmallSquare] It is possible to both read and write to the \
clipboard notebook. \
\>", "Notes",
  CellTags->{"S1.1006", "Developer`ClipboardNotebook"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["NotebookWrite",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SelectedNotebook",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["EvaluationNotebook",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1006", "Developer`ClipboardNotebook"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`FibonacciSimplify", "ObjectName",
  CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FibonacciSimplify[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["assum", "TI"],
  StyleBox["]", "MR"],
  " tries to simplify combinations of symbolic Fibonacci numbers in ",
  StyleBox["expr", "TI"],
  " using assumptions ",
  StyleBox["assum", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] Example: ",
  StyleBox["Developer`FibonacciSimplify[Fibonacci[n-1]+Fibonacci[n-2],", 
    "MR"],
  " ",
  StyleBox["Element[n,", "MR"],
  " ",
  StyleBox["Integers]]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \(Fibonacci[n]\)], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FibonacciSimplify", "MR"],
  " can typically perform transformations only when arguments of Fibonacci \
numbers are specified to be integers. "
}], "Notes",
  CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FibonacciSimplify", "MR"],
  " is automatically used inside ",
  StyleBox["FullSimplify", "MR"],
  " and ",
  StyleBox["FunctionExpand", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1007", "Developer`FibonacciSimplify"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`FileInformation", "ObjectName",
  CellTags->{"S1.1008", "Developer`FileInformation"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FileInformation[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\"]", "MR"],
  " gives information about the file with the specified name. "
}], "Usage",
  CellTags->{"S1.1008", "Developer`FileInformation"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FileInformation", "MR"],
  " gives a list of rules which include information on the name, size and \
modification time of a file. "
}], "Notes",
  CellTags->{"S1.1008", "Developer`FileInformation"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ToDate", "MR"],
  " can be used to convert modification times to dates. "
}], "Notes",
  CellTags->{"S1.1008", "Developer`FileInformation"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["FileNames",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FileDate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FileByteCount",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AbsoluteOptions",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["NotebookInformation",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1008", "Developer`FileInformation"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`FromPackedArray", "ObjectName",
  CellTags->{"S1.1009", "Developer`FromPackedArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FromPackedArray[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " unpacks ",
  StyleBox["expr", "TI"],
  " so that its internal representation is not a packed array. "
}], "Usage",
  CellTags->{"S1.1009", "Developer`FromPackedArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] Using ",
  StyleBox["FromPackedArray", "MR"],
  " will not change results generated by ",
  StyleBox["Mathematica", "TI"],
  ", but can reduce speed of execution and increase memory usage. "
}], "Notes",
  CellTags->{"S1.1009", "Developer`FromPackedArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["expr", "TI"],
  " is not a packed array, ",
  StyleBox["FromPackedArray[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " returns ",
  StyleBox["expr", "TI"],
  " unchanged. "
}], "Notes",
  CellTags->{"S1.1009", "Developer`FromPackedArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ToPackedArray",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PackedArrayQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ByteCount",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1009", "Developer`FromPackedArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`GammaSimplify", "ObjectName",
  CellTags->{"S1.1010", "Developer`GammaSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GammaSimplify[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " transforms gamma functions in ",
  StyleBox["expr", "TI"],
  ", trying to either decrease the number of gamma functions, or convert \
combinations of them into more elementary functions. "
}], "Usage",
  CellTags->{"S1.1010", "Developer`GammaSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GammaSimplify", "MR"],
  " is automatically used inside ",
  StyleBox["FullSimplify", "MR"],
  " and ",
  StyleBox["FunctionExpand", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1010", "Developer`GammaSimplify"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`HelpBrowserNotebook", "ObjectName",
  CellTags->{"S1.1011", "Developer`HelpBrowserNotebook"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["HelpBrowserNotebook[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " gives the notebook object corresponding to the notebook portion of the \
Help Browser window. "
}], "Usage",
  CellTags->{"S1.1011", "Developer`HelpBrowserNotebook"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MessagesNotebook",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SelectedNotebook",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["EvaluationNotebook",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1011", "Developer`HelpBrowserNotebook"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`HermiteNormalForm", "ObjectName",
  CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["HermiteNormalForm[", "MR"],
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " gives the Hermite normal form of an integer matrix ",
  StyleBox["m", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] The result is given in the form ",
  StyleBox["{", "MR"],
  StyleBox["u", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["r", "TI"],
  StyleBox["}", "MR"],
  " where ",
  StyleBox["u", "TI"],
  " is a unimodular matrix, ",
  StyleBox["r", "TI"],
  " is an upper\[Hyphen]triangular matrix, and ",
  StyleBox["u", "TI"],
  " ",
  StyleBox[".", "MR"],
  " ",
  StyleBox["m", "TI"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["r", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["RowReduce",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LatticeReduce",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],

Cell[TextData[{
  "This gives the Hermite normal form for the integer matrix ",
  StyleBox["m", "MR"],
  ". "
}], "ExampleText",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],

Cell[BoxData[
    RowBox[{
      RowBox[{\({u, r}\), "=", 
        RowBox[{"Developer`HermiteNormalForm", "[", 
          RowBox[{"m", "=", 
            RowBox[{"(", GridBox[{
                  {"1", "2", "3"},
                  {"2", "4", \(-2\)},
                  {"1", "3", \(-1\)}
                  }], ")"}]}], "]"}]}], ";"}]], "Input",
  CellLabel->"In[1]:= ",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[MatrixForm, {u, r}]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {"1", "1", \(-2\)},
                {"1", \(-1\), "1"},
                {"2", \(-1\), "0"}
                },
              RowSpacings->1,
              ColumnSpacings->1,
              ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
          Function[ BoxForm`e$, 
            MatrixForm[ BoxForm`e$]]], ",", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {"1", "0", "3"},
                {"0", "1", "4"},
                {"0", "0", "8"}
                },
              RowSpacings->1,
              ColumnSpacings->1,
              ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
          Function[ BoxForm`e$, 
            MatrixForm[ BoxForm`e$]]]}], "}"}]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}]
}, Open  ]],

Cell["This checks the result. ", "ExampleText",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(u . m == r\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}]
}, Open  ]],

Cell[BoxData[
    \(Clear[u, r, m]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`MachineIntegerQ", "ObjectName",
  CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MachineIntegerQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " returns ",
  StyleBox["True", "MR"],
  " if ",
  StyleBox["expr", "TI"],
  " corresponds to a machine\[Hyphen]sized integer, and ",
  StyleBox["False", "MR"],
  " otherwise. "
}], "Usage",
  CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] On a typical computer system machine\[Hyphen]sized \
integers must lie in the range ",
  Cell[BoxData[
      \(TraditionalForm\`\(-2\)\^31 + 1\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+2\)\^31 - 1\)], "InlineFormula"],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`\(-2\)\^63 + 1\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+2\)\^63 - 1\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] Results from ",
  StyleBox["Mathematica", "TI"],
  " are not affected by whether an integer is machine\[Hyphen]sized or not; \
the speed of operations may however be affected. "
}], "Notes",
  CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["$MaxMachineInteger",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Precision",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1013", "Developer`MachineIntegerQ"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`MessagesNotebook", "ObjectName",
  CellTags->{"S1.1014", "Developer`MessagesNotebook"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MessagesNotebook[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " gives the notebook to which messages generated by the notebook front end \
will be sent. "
}], "Usage",
  CellTags->{"S1.1014", "Developer`MessagesNotebook"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MessagesNotebook", "MR"],
  " returns a ",
  StyleBox["NotebookObject", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1014", "Developer`MessagesNotebook"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["SelectedNotebook",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["EvaluationNotebook",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1014", "Developer`MessagesNotebook"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`NotebookConvert", "ObjectName",
  CellTags->{"S1.1015", "Developer`NotebookConvert"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["NotebookConvert[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\"]", "MR"],
  " converts a ",
  StyleBox["Mathematica", "TI"],
  " notebook from a previous version of ",
  StyleBox["Mathematica", "TI"],
  " to one for the current version. "
}], "Usage",
  CellTags->{"S1.1015", "Developer`NotebookConvert"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["NotebookConvert", "MR"],
  " takes a file named ",
  StyleBox["name", "TI"],
  StyleBox[".ma", "MR"],
  " or ",
  StyleBox["name", "TI"],
  " and generates a file named ",
  StyleBox["name", "TI"],
  StyleBox[".nb", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1015", "Developer`NotebookConvert"}],

Cell["\<\
\[FilledSmallSquare] Notebook conversion is done automatically by \
the front end if you try to open a Version 2 notebook. \
\>", "Notes",
  CellTags->{"S1.1015", "Developer`NotebookConvert"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["NotebookGet",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1015", "Developer`NotebookConvert"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`NotebookInformation", "ObjectName",
  CellTags->{"S1.1016", "Developer`NotebookInformation"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["NotebookInformation[", "MR"],
  StyleBox["obj", "TI"],
  StyleBox["]", "MR"],
  " gives information about the notebook represented by the specified \
notebook object. "
}], "Usage",
  CellTags->{"S1.1016", "Developer`NotebookInformation"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["NotebookInformation", "MR"],
  " gives a list of rules which include information on times when data \
associated with the notebook was most recently modified. "
}], "Notes",
  CellTags->{"S1.1016", "Developer`NotebookInformation"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ToDate", "MR"],
  " can be used to convert these times to dates. "
}], "Notes",
  CellTags->{"S1.1016", "Developer`NotebookInformation"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["AbsoluteOptions",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FileInformation",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1016", "Developer`NotebookInformation"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`PackedArrayForm", "ObjectName",
  CellTags->{"S1.1017", "Developer`PackedArrayForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PackedArrayForm[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " prints with packed arrays in ",
  StyleBox["expr", "TI"],
  " shown in summary form, without all of their elements explicitly given. "
}], "Usage",
  CellTags->{"S1.1017", "Developer`PackedArrayForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Short",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Shallow",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1017", "Developer`PackedArrayForm"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`PackedArrayQ", "ObjectName",
  CellTags->{"S1.1018", "Developer`PackedArrayQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PackedArrayQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " returns ",
  StyleBox["True", "MR"],
  " if ",
  StyleBox["expr", "TI"],
  " is a packed array in its internal representation, and returns ",
  StyleBox["False", "MR"],
  " otherwise. \n\[FilledSmallSquare] ",
  StyleBox["PackedArrayQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["type", "TI"],
  StyleBox["]", "MR"],
  " returns ",
  StyleBox["True", "MR"],
  " if ",
  StyleBox["expr", "TI"],
  " is a packed array of objects of the specified type. \n\
\[FilledSmallSquare] ",
  StyleBox["PackedArrayQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["type", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["rank", "TI"],
  StyleBox["]", "MR"],
  " returns ",
  StyleBox["True", "MR"],
  " if ",
  StyleBox["expr", "TI"],
  " is a packed array of the specified rank. "
}], "Usage",
  CellTags->{"S1.1018", "Developer`PackedArrayQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] Supported types are ",
  StyleBox["Integer", "MR"],
  ", ",
  StyleBox["Real", "MR"],
  " and ",
  StyleBox["Complex", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1018", "Developer`PackedArrayQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ToPackedArray",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ByteCount",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1018", "Developer`PackedArrayQ"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`PartitionMap", "ObjectName",
  CellTags->{"S1.1019", "Developer`PartitionMap"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PartitionMap[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " applies ",
  StyleBox["f", "TI"],
  " to ",
  StyleBox["list", "TI"],
  " after partitioning into non\[Hyphen]overlapping sublists of length ",
  StyleBox["n", "TI"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["PartitionMap[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["d", "TI"],
  StyleBox["]", "MR"],
  " applies ",
  StyleBox["f", "TI"],
  " to sublists obtained by partitioning with offset ",
  StyleBox["d", "TI"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["PartitionMap[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " applies ",
  StyleBox["f", "TI"],
  " after partitioning a nested list into blocks of size ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["n",
              "TI"], "1"], "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], "2"], "\[Cross]", \(\(\[Ellipsis]\)\(\ \)\)}], 
        TraditionalForm]], "InlineFormula"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["PartitionMap[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["d",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["d",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " applies ",
  StyleBox["f", "TI"],
  " after partitioning using offset ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["d",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " at level ",
  StyleBox["i", "TI"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["PartitionMap[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["d", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["k",
            "TI"], 
          StyleBox["L",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["k",
            "TI"], 
          StyleBox["R",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  " specifies where sublists should begin and end. \n\[FilledSmallSquare] ",
  StyleBox["PartitionMap[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["d", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["k",
            "TI"], 
          StyleBox["L",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["k",
            "TI"], 
          StyleBox["R",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["padding", "TI"],
  StyleBox["]", "MR"],
  " specifies what padding should be used. "
}], "Usage",
  CellTags->{"S1.1019", "Developer`PartitionMap"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PartitionMap[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " is equivalent to ",
  StyleBox["Map[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["Partition[", "MR"],
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1019", "Developer`PartitionMap"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PartitionMap[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["d",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " is equivalent to ",
  StyleBox["Map[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["Partition[", "MR"],
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["],", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["d", "TI"],
  StyleBox["}]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1019", "Developer`PartitionMap"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PartitionMap", "MR"],
  " can be used on ",
  ButtonBox["SparseArray",
    ButtonStyle->"RefGuideLink"],
  " objects. "
}], "Notes",
  CellTags->{"S1.1019", "Developer`PartitionMap"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ListCorrelate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Partition",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Map",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Apply",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1019", "Developer`PartitionMap"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`PolyGammaSimplify", "ObjectName",
  CellTags->{"S1.1020", "Developer`PolyGammaSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PolyGammaSimplify[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " transforms polygamma functions in ",
  StyleBox["expr", "TI"],
  ", trying to either decrease the number of polygamma functions, or convert \
combinations of them into more elementary functions. "
}], "Usage",
  CellTags->{"S1.1020", "Developer`PolyGammaSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PolyGammaSimplify", "MR"],
  " is automatically used inside ",
  StyleBox["FullSimplify", "MR"],
  " and ",
  StyleBox["FunctionExpand", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1020", "Developer`PolyGammaSimplify"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`PolyLogSimplify", "ObjectName",
  CellTags->{"S1.1021", "Developer`PolyLogSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PolyLogSimplify[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " transforms polylogarithm functions in ",
  StyleBox["expr", "TI"],
  ", trying to either decrease the number of polylogarithm functions, or \
convert combinations of them into more elementary functions. "
}], "Usage",
  CellTags->{"S1.1021", "Developer`PolyLogSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PolyLogSimplify", "MR"],
  " is automatically used inside ",
  StyleBox["FullSimplify", "MR"],
  " and ",
  StyleBox["FunctionExpand", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1021", "Developer`PolyLogSimplify"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`PolynomialDivision", "ObjectName",
  CellTags->{"S1.1022", "Developer`PolynomialDivision"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PolynomialDivision[", "MR"],
  StyleBox["p", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["q", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " gives a list of the quotient and remainder of ",
  StyleBox["p", "TI"],
  " and ",
  StyleBox["q", "TI"],
  ", treated as polynomials in ",
  StyleBox["x", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1022", "Developer`PolynomialDivision"}],

Cell[TextData[{
  "\[FilledSmallSquare] The remainder will always have a degree not greater \
than ",
  StyleBox["q", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1022", "Developer`PolynomialDivision"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["PolynomialQuotient",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PolynomialRemainder",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PolynomialReduce",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1022", "Developer`PolynomialDivision"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],

Cell["Here are two polynomials. ", "ExampleText",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],

Cell[BoxData[
    \(q = x\^5 - x\^4 + x\^3 - x\^2 + x - 1; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],

Cell[BoxData[
    \(r = x + 1; \)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],

Cell["\<\
Here are the quotient and remainder upon dividing the dividend by \
the divisor. \
\>", "ExampleText",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({s, t} = Developer`PolynomialDivision[q, r, x]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],

Cell[BoxData[
    \({5 - 4\ x + 3\ x\^2 - 2\ x\^3 + x\^4, \(-6\)}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}]
}, Open  ]],

Cell["This checks the result. ", "ExampleText",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[s  r + t - q]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}]
}, Open  ]],

Cell[BoxData[
    \(Clear[q, r, s, t]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`ReplaceAllUnheld", "ObjectName",
  CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ReplaceAllUnheld[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["rules", "TI"],
  StyleBox["]", "MR"],
  " applies a rule or list of rules in an attempt to transform each subpart \
of ",
  StyleBox["expr", "TI"],
  " that would be automatically evaluated. "
}], "Usage",
  CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ReplaceAll", "MR"],
  " operates on all subparts of an expression; ",
  StyleBox["ReplaceAllUnheld", "MR"],
  " operates only on those subparts that would normally be evaluated. "
}], "Notes",
  CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],

Cell[TextData[{
  "\[FilledSmallSquare] Example: ",
  StyleBox["Developer`ReplaceAllUnheld[If[a,", "MR"],
  " ",
  StyleBox["a,", "MR"],
  " ",
  StyleBox["a],", "MR"],
  " ",
  StyleBox["a->b]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \(If[b, a, a]\)], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ReplaceAll",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Hold",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Verbatim",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`SetSystemOptions", "ObjectName",
  CellTags->{"S1.1024", "Developer`SetSystemOptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SetSystemOptions[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\"->", "MR"],
  StyleBox["value", "TI"],
  StyleBox["]", "MR"],
  " sets a specified system option. "
}], "Usage",
  CellTags->{"S1.1024", "Developer`SetSystemOptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["SystemOptions",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1024", "Developer`SetSystemOptions"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`SystemOptions", "ObjectName",
  CellTags->{"S1.1025", "Developer`SystemOptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SystemOptions[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " gives the current settings for all system options. \n\[FilledSmallSquare] \
",
  StyleBox["SystemOptions[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\"]", "MR"],
  " gives the current setting for the system option with the specified name. \
"
}], "Usage",
  CellTags->{"S1.1025", "Developer`SystemOptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] System options specify parameters relevant to the \
internal operation of ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1025", "Developer`SystemOptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["SetSystemOptions",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1025", "Developer`SystemOptions"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`ToPackedArray", "ObjectName",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ToPackedArray[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " uses packed arrays if possible in the internal representation of ",
  StyleBox["expr", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] Using ",
  StyleBox["ToPackedArray", "MR"],
  " will not change results generated by ",
  StyleBox["Mathematica", "TI"],
  ", but can enhance speed of execution and reduce memory usage. "
}], "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ToPackedArray", "MR"],
  " is effectively used automatically by many functions that generate large \
lists. "
}], "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ToPackedArray", "MR"],
  " will successfully pack full lists of any depth containing \
machine\[Hyphen]sized integers and machine\[Hyphen]sized approximate real and \
complex numbers. "
}], "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ToPackedArray[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["type", "TI"],
  StyleBox["]", "MR"],
  " will when possible convert entries in ",
  StyleBox["expr", "TI"],
  " to be of the specified type. "
}], "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible types are: ",
  StyleBox["Integer", "MR"],
  ", ",
  StyleBox["Real", "MR"],
  " and ",
  StyleBox["Complex", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],

Cell["\<\
\[FilledSmallSquare] Only machine\[Hyphen]sized numbers can be \
stored in packed form. \
\>", "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] The option ",
  StyleBox["Tolerance->", "MR"],
  StyleBox["tol", "TI"],
  " can be used to specify when small numerical values can be ignored in \
conversion to more restrictive types, and when they must prevent conversion \
to packed form. "
}], "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["FromPackedArray",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ByteCount",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`TrigToRadicals", "ObjectName",
  CellTags->{"S1.1027", "Developer`TrigToRadicals"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TrigToRadicals[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " converts trigonometric functions to radicals whenever possible in ",
  StyleBox["expr", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1027", "Developer`TrigToRadicals"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TrigToRadicals", "MR"],
  " operates on trigonometric functions whose arguments are rational \
multiples of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S1.1027", "Developer`TrigToRadicals"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TrigToRadicals", "MR"],
  " is automatically used inside ",
  StyleBox["FullSimplify", "MR"],
  " and ",
  StyleBox["FunctionExpand", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1027", "Developer`TrigToRadicals"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`ZeroQ", "ObjectName",
  CellTags->{"S1.1028", "Developer`ZeroQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ZeroQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " returns ",
  StyleBox["True", "MR"],
  " if built\[Hyphen]in transformations allow it to be determined that ",
  StyleBox["expr", "TI"],
  " is numerically equal to zero, and returns ",
  StyleBox["False", "MR"],
  " otherwise. "
}], "Usage",
  CellTags->{"S1.1028", "Developer`ZeroQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ZeroQ", "MR"],
  " uses a combination of symbolic transformations and randomized numerical \
evaluation. "
}], "Notes",
  CellTags->{"S1.1028", "Developer`ZeroQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["ZeroQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " returns ",
  StyleBox["False", "MR"],
  " it does not necessarily mean that ",
  StyleBox["expr", "TI"],
  " is mathematically not equal to zero; all it means is that \
built\[Hyphen]in transformations did not allow this to be determined. "
}], "Notes",
  CellTags->{"S1.1028", "Developer`ZeroQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ImpliesQ",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1028", "Developer`ZeroQ"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`ZetaSimplify", "ObjectName",
  CellTags->{"S1.1029", "Developer`ZetaSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ZetaSimplify[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " transforms zeta functions in ",
  StyleBox["expr", "TI"],
  ", trying to either decrease the number of zeta functions, or convert \
combinations of them into more elementary functions. "
}], "Usage",
  CellTags->{"S1.1029", "Developer`ZetaSimplify"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ZetaSimplify", "MR"],
  " is automatically used inside ",
  StyleBox["FullSimplify", "MR"],
  " and ",
  StyleBox["FunctionExpand", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1029", "Developer`ZetaSimplify"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`$MaxMachineInteger", "ObjectName",
  CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$MaxMachineInteger", "MR"],
  " gives the maximum integer that is represented internally as a single \
atomic data element on your computer system. "
}], "Usage",
  CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$MaxMachineInteger", "MR"],
  " is typically ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["2", 
            RowBox[{
              StyleBox["n",
                "TI"], "-", "1"}]], "-", "1"}], TraditionalForm]], 
    "InlineFormula"],
  " on a computer system that is referred to as an ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]bit system. "
}], "Notes",
  CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] Arithmetic operations involving integers smaller than \
",
  StyleBox["$MaxMachineInteger", "MR"],
  " are typically faster than those involving larger integers. "
}], "Notes",
  CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MachineIntegerQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$MaxMachineNumber",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$MachinePrecision",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.14.0"->{
    Cell[1776, 53, 178, 6, 91, "Section",
      CellTags->{"SA.14.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 178, 6, 91, "Section",
      CellTags->{"SA.14.0", "0.1"}]},
  "SA.14.1"->{
    Cell[1979, 63, 73, 1, 70, "Subsection",
      CellTags->{"SA.14.1", "1.1"}],
    Cell[2055, 66, 366, 11, 70, "Text",
      CellTags->{"SA.14.1", "1.2"}],
    Cell[2424, 79, 309, 8, 70, "Text",
      CellTags->{"SA.14.1", "1.3"}],
    Cell[2736, 89, 773, 23, 70, "DefinitionBox",
      CellTags->"SA.14.1"],
    Cell[3512, 114, 138, 5, 70, "Caption",
      CellTags->"SA.14.1"],
    Cell[3653, 121, 600, 20, 70, "Text",
      CellTags->{"SA.14.1", "1.4"}]},
  "1.1"->{
    Cell[1979, 63, 73, 1, 70, "Subsection",
      CellTags->{"SA.14.1", "1.1"}]},
  "1.2"->{
    Cell[2055, 66, 366, 11, 70, "Text",
      CellTags->{"SA.14.1", "1.2"}]},
  "1.3"->{
    Cell[2424, 79, 309, 8, 70, "Text",
      CellTags->{"SA.14.1", "1.3"}]},
  "1.4"->{
    Cell[3653, 121, 600, 20, 70, "Text",
      CellTags->{"SA.14.1", "1.4"}]},
  "S1.1001"->{
    Cell[4278, 145, 99, 1, 70, "ObjectName",
      CellTags->{"S1.1001", "Developer`BesselSimplify"}],
    Cell[4380, 148, 385, 10, 70, "Usage",
      CellTags->{"S1.1001", "Developer`BesselSimplify"}],
    Cell[4768, 160, 268, 9, 70, "Notes",
      CellTags->{"S1.1001", "Developer`BesselSimplify"}]},
  "Developer`BesselSimplify"->{
    Cell[4278, 145, 99, 1, 70, "ObjectName",
      CellTags->{"S1.1001", "Developer`BesselSimplify"}],
    Cell[4380, 148, 385, 10, 70, "Usage",
      CellTags->{"S1.1001", "Developer`BesselSimplify"}],
    Cell[4768, 160, 268, 9, 70, "Notes",
      CellTags->{"S1.1001", "Developer`BesselSimplify"}]},
  "S1.1002"->{
    Cell[5073, 174, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1002", "Developer`BitLength"}],
    Cell[5165, 177, 285, 9, 70, "Usage",
      CellTags->{"S1.1002", "Developer`BitLength"}],
    Cell[5453, 188, 426, 18, 70, "Notes",
      CellTags->{"S1.1002", "Developer`BitLength"}],
    Cell[5882, 208, 259, 9, 70, "Notes",
      CellTags->{"S1.1002", "Developer`BitLength"}],
    Cell[6144, 219, 259, 9, 70, "Notes",
      CellTags->{"S1.1002", "Developer`BitLength"}]},
  "Developer`BitLength"->{
    Cell[5073, 174, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1002", "Developer`BitLength"}],
    Cell[5165, 177, 285, 9, 70, "Usage",
      CellTags->{"S1.1002", "Developer`BitLength"}],
    Cell[5453, 188, 426, 18, 70, "Notes",
      CellTags->{"S1.1002", "Developer`BitLength"}],
    Cell[5882, 208, 259, 9, 70, "Notes",
      CellTags->{"S1.1002", "Developer`BitLength"}],
    Cell[6144, 219, 259, 9, 70, "Notes",
      CellTags->{"S1.1002", "Developer`BitLength"}]},
  "S1.1003"->{
    Cell[6440, 233, 95, 1, 70, "ObjectName",
      CellTags->{"S1.1003", "Developer`BitShiftLeft"}],
    Cell[6538, 236, 400, 14, 70, "Usage",
      CellTags->{"S1.1003", "Developer`BitShiftLeft"}],
    Cell[6941, 252, 348, 15, 70, "Notes",
      CellTags->{"S1.1003", "Developer`BitShiftLeft"}],
    Cell[7292, 269, 174, 5, 70, "Notes",
      CellTags->{"S1.1003", "Developer`BitShiftLeft"}]},
  "Developer`BitShiftLeft"->{
    Cell[6440, 233, 95, 1, 70, "ObjectName",
      CellTags->{"S1.1003", "Developer`BitShiftLeft"}],
    Cell[6538, 236, 400, 14, 70, "Usage",
      CellTags->{"S1.1003", "Developer`BitShiftLeft"}],
    Cell[6941, 252, 348, 15, 70, "Notes",
      CellTags->{"S1.1003", "Developer`BitShiftLeft"}],
    Cell[7292, 269, 174, 5, 70, "Notes",
      CellTags->{"S1.1003", "Developer`BitShiftLeft"}]},
  "S1.1004"->{
    Cell[7503, 279, 97, 1, 70, "ObjectName",
      CellTags->{"S1.1004", "Developer`BitShiftRight"}],
    Cell[7603, 282, 442, 15, 70, "Usage",
      CellTags->{"S1.1004", "Developer`BitShiftRight"}],
    Cell[8048, 299, 401, 16, 70, "Notes",
      CellTags->{"S1.1004", "Developer`BitShiftRight"}],
    Cell[8452, 317, 174, 5, 70, "Notes",
      CellTags->{"S1.1004", "Developer`BitShiftRight"}],
    Cell[8629, 324, 190, 6, 70, "Notes",
      CellTags->{"S1.1004", "Developer`BitShiftRight"}]},
  "Developer`BitShiftRight"->{
    Cell[7503, 279, 97, 1, 70, "ObjectName",
      CellTags->{"S1.1004", "Developer`BitShiftRight"}],
    Cell[7603, 282, 442, 15, 70, "Usage",
      CellTags->{"S1.1004", "Developer`BitShiftRight"}],
    Cell[8048, 299, 401, 16, 70, "Notes",
      CellTags->{"S1.1004", "Developer`BitShiftRight"}],
    Cell[8452, 317, 174, 5, 70, "Notes",
      CellTags->{"S1.1004", "Developer`BitShiftRight"}],
    Cell[8629, 324, 190, 6, 70, "Notes",
      CellTags->{"S1.1004", "Developer`BitShiftRight"}]},
  "S1.1005"->{
    Cell[8856, 335, 91, 1, 70, "ObjectName",
      CellTags->{"S1.1005", "Developer`ClearCache"}],
    Cell[8950, 338, 215, 7, 70, "Usage",
      CellTags->{"S1.1005", "Developer`ClearCache"}],
    Cell[9168, 347, 251, 6, 70, "Notes",
      CellTags->{"S1.1005", "Developer`ClearCache"}],
    Cell[9422, 355, 194, 5, 70, "Notes",
      CellTags->{"S1.1005", "Developer`ClearCache"}],
    Cell[9619, 362, 196, 5, 70, "Notes",
      CellTags->{"S1.1005", "Developer`ClearCache"}],
    Cell[9818, 369, 177, 6, 70, "Notes",
      CellTags->{"S1.1005", "Developer`ClearCache"}]},
  "Developer`ClearCache"->{
    Cell[8856, 335, 91, 1, 70, "ObjectName",
      CellTags->{"S1.1005", "Developer`ClearCache"}],
    Cell[8950, 338, 215, 7, 70, "Usage",
      CellTags->{"S1.1005", "Developer`ClearCache"}],
    Cell[9168, 347, 251, 6, 70, "Notes",
      CellTags->{"S1.1005", "Developer`ClearCache"}],
    Cell[9422, 355, 194, 5, 70, "Notes",
      CellTags->{"S1.1005", "Developer`ClearCache"}],
    Cell[9619, 362, 196, 5, 70, "Notes",
      CellTags->{"S1.1005", "Developer`ClearCache"}],
    Cell[9818, 369, 177, 6, 70, "Notes",
      CellTags->{"S1.1005", "Developer`ClearCache"}]},
  "S1.1006"->{
    Cell[10032, 380, 105, 1, 70, "ObjectName",
      CellTags->{"S1.1006", "Developer`ClipboardNotebook"}],
    Cell[10140, 383, 317, 8, 70, "Usage",
      CellTags->{"S1.1006", "Developer`ClipboardNotebook"}],
    Cell[10460, 393, 169, 4, 70, "Notes",
      CellTags->{"S1.1006", "Developer`ClipboardNotebook"}],
    Cell[10632, 399, 341, 12, 70, "Notes",
      CellTags->{"S1.1006", "Developer`ClipboardNotebook"}]},
  "Developer`ClipboardNotebook"->{
    Cell[10032, 380, 105, 1, 70, "ObjectName",
      CellTags->{"S1.1006", "Developer`ClipboardNotebook"}],
    Cell[10140, 383, 317, 8, 70, "Usage",
      CellTags->{"S1.1006", "Developer`ClipboardNotebook"}],
    Cell[10460, 393, 169, 4, 70, "Notes",
      CellTags->{"S1.1006", "Developer`ClipboardNotebook"}],
    Cell[10632, 399, 341, 12, 70, "Notes",
      CellTags->{"S1.1006", "Developer`ClipboardNotebook"}]},
  "S1.1007"->{
    Cell[11010, 416, 105, 1, 70, "ObjectName",
      CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],
    Cell[11118, 419, 413, 14, 70, "Usage",
      CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],
    Cell[11534, 435, 371, 13, 70, "Notes",
      CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],
    Cell[11908, 450, 267, 6, 70, "Notes",
      CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],
    Cell[12178, 458, 274, 9, 70, "Notes",
      CellTags->{"S1.1007", "Developer`FibonacciSimplify"}]},
  "Developer`FibonacciSimplify"->{
    Cell[11010, 416, 105, 1, 70, "ObjectName",
      CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],
    Cell[11118, 419, 413, 14, 70, "Usage",
      CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],
    Cell[11534, 435, 371, 13, 70, "Notes",
      CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],
    Cell[11908, 450, 267, 6, 70, "Notes",
      CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],
    Cell[12178, 458, 274, 9, 70, "Notes",
      CellTags->{"S1.1007", "Developer`FibonacciSimplify"}]},
  "S1.1008"->{
    Cell[12489, 472, 101, 1, 70, "ObjectName",
      CellTags->{"S1.1008", "Developer`FileInformation"}],
    Cell[12593, 475, 264, 7, 70, "Usage",
      CellTags->{"S1.1008", "Developer`FileInformation"}],
    Cell[12860, 484, 253, 6, 70, "Notes",
      CellTags->{"S1.1008", "Developer`FileInformation"}],
    Cell[13116, 492, 195, 5, 70, "Notes",
      CellTags->{"S1.1008", "Developer`FileInformation"}],
    Cell[13314, 499, 472, 18, 70, "Notes",
      CellTags->{"S1.1008", "Developer`FileInformation"}]},
  "Developer`FileInformation"->{
    Cell[12489, 472, 101, 1, 70, "ObjectName",
      CellTags->{"S1.1008", "Developer`FileInformation"}],
    Cell[12593, 475, 264, 7, 70, "Usage",
      CellTags->{"S1.1008", "Developer`FileInformation"}],
    Cell[12860, 484, 253, 6, 70, "Notes",
      CellTags->{"S1.1008", "Developer`FileInformation"}],
    Cell[13116, 492, 195, 5, 70, "Notes",
      CellTags->{"S1.1008", "Developer`FileInformation"}],
    Cell[13314, 499, 472, 18, 70, "Notes",
      CellTags->{"S1.1008", "Developer`FileInformation"}]},
  "S1.1009"->{
    Cell[13823, 522, 101, 1, 70, "ObjectName",
      CellTags->{"S1.1009", "Developer`FromPackedArray"}],
    Cell[13927, 525, 302, 9, 70, "Usage",
      CellTags->{"S1.1009", "Developer`FromPackedArray"}],
    Cell[14232, 536, 297, 7, 70, "Notes",
      CellTags->{"S1.1009", "Developer`FromPackedArray"}],
    Cell[14532, 545, 313, 11, 70, "Notes",
      CellTags->{"S1.1009", "Developer`FromPackedArray"}],
    Cell[14848, 558, 326, 12, 70, "Notes",
      CellTags->{"S1.1009", "Developer`FromPackedArray"}]},
  "Developer`FromPackedArray"->{
    Cell[13823, 522, 101, 1, 70, "ObjectName",
      CellTags->{"S1.1009", "Developer`FromPackedArray"}],
    Cell[13927, 525, 302, 9, 70, "Usage",
      CellTags->{"S1.1009", "Developer`FromPackedArray"}],
    Cell[14232, 536, 297, 7, 70, "Notes",
      CellTags->{"S1.1009", "Developer`FromPackedArray"}],
    Cell[14532, 545, 313, 11, 70, "Notes",
      CellTags->{"S1.1009", "Developer`FromPackedArray"}],
    Cell[14848, 558, 326, 12, 70, "Notes",
      CellTags->{"S1.1009", "Developer`FromPackedArray"}]},
  "S1.1010"->{
    Cell[15211, 575, 97, 1, 70, "ObjectName",
      CellTags->{"S1.1010", "Developer`GammaSimplify"}],
    Cell[15311, 578, 385, 10, 70, "Usage",
      CellTags->{"S1.1010", "Developer`GammaSimplify"}],
    Cell[15699, 590, 266, 9, 70, "Notes",
      CellTags->{"S1.1010", "Developer`GammaSimplify"}]},
  "Developer`GammaSimplify"->{
    Cell[15211, 575, 97, 1, 70, "ObjectName",
      CellTags->{"S1.1010", "Developer`GammaSimplify"}],
    Cell[15311, 578, 385, 10, 70, "Usage",
      CellTags->{"S1.1010", "Developer`GammaSimplify"}],
    Cell[15699, 590, 266, 9, 70, "Notes",
      CellTags->{"S1.1010", "Developer`GammaSimplify"}]},
  "S1.1011"->{
    Cell[16002, 604, 109, 1, 70, "ObjectName",
      CellTags->{"S1.1011", "Developer`HelpBrowserNotebook"}],
    Cell[16114, 607, 285, 8, 70, "Usage",
      CellTags->{"S1.1011", "Developer`HelpBrowserNotebook"}],
    Cell[16402, 617, 346, 12, 70, "Notes",
      CellTags->{"S1.1011", "Developer`HelpBrowserNotebook"}]},
  "Developer`HelpBrowserNotebook"->{
    Cell[16002, 604, 109, 1, 70, "ObjectName",
      CellTags->{"S1.1011", "Developer`HelpBrowserNotebook"}],
    Cell[16114, 607, 285, 8, 70, "Usage",
      CellTags->{"S1.1011", "Developer`HelpBrowserNotebook"}],
    Cell[16402, 617, 346, 12, 70, "Notes",
      CellTags->{"S1.1011", "Developer`HelpBrowserNotebook"}]},
  "S1.1012"->{
    Cell[16785, 634, 105, 1, 70, "ObjectName",
      CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],
    Cell[16893, 637, 285, 9, 70, "Usage",
      CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],
    Cell[17181, 648, 556, 24, 70, "Notes",
      CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],
    Cell[17740, 674, 258, 9, 70, "Notes",
      CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],
    Cell[18023, 687, 98, 1, 70, "ExampleSection",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[18124, 690, 184, 5, 70, "ExampleText",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[18311, 697, 423, 11, 70, "Input",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[18759, 712, 137, 3, 70, "Input",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[18899, 717, 916, 26, 70, "Output",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[19830, 746, 103, 1, 70, "ExampleText",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[19958, 751, 124, 3, 70, "Input",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[20085, 756, 119, 3, 70, "Output",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[20219, 762, 128, 3, 70, "Input",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}]},
  "Developer`HermiteNormalForm"->{
    Cell[16785, 634, 105, 1, 70, "ObjectName",
      CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],
    Cell[16893, 637, 285, 9, 70, "Usage",
      CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],
    Cell[17181, 648, 556, 24, 70, "Notes",
      CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],
    Cell[17740, 674, 258, 9, 70, "Notes",
      CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],
    Cell[18023, 687, 98, 1, 70, "ExampleSection",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[18124, 690, 184, 5, 70, "ExampleText",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[18311, 697, 423, 11, 70, "Input",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[18759, 712, 137, 3, 70, "Input",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[18899, 717, 916, 26, 70, "Output",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[19830, 746, 103, 1, 70, "ExampleText",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[19958, 751, 124, 3, 70, "Input",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[20085, 756, 119, 3, 70, "Output",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
    Cell[20219, 762, 128, 3, 70, "Input",
      CellTags->{"Developer`HermiteNormalForm", "S1.1012"}]},
  "S1.1013"->{
    Cell[20396, 771, 101, 1, 70, "ObjectName",
      CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],
    Cell[20500, 774, 376, 13, 70, "Usage",
      CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],
    Cell[20879, 789, 542, 16, 70, "Notes",
      CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],
    Cell[21424, 807, 284, 6, 70, "Notes",
      CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],
    Cell[21711, 815, 261, 9, 70, "Notes",
      CellTags->{"S1.1013", "Developer`MachineIntegerQ"}]},
  "Developer`MachineIntegerQ"->{
    Cell[20396, 771, 101, 1, 70, "ObjectName",
      CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],
    Cell[20500, 774, 376, 13, 70, "Usage",
      CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],
    Cell[20879, 789, 542, 16, 70, "Notes",
      CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],
    Cell[21424, 807, 284, 6, 70, "Notes",
      CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],
    Cell[21711, 815, 261, 9, 70, "Notes",
      CellTags->{"S1.1013", "Developer`MachineIntegerQ"}]},
  "S1.1014"->{
    Cell[22009, 829, 103, 1, 70, "ObjectName",
      CellTags->{"S1.1014", "Developer`MessagesNotebook"}],
    Cell[22115, 832, 274, 8, 70, "Usage",
      CellTags->{"S1.1014", "Developer`MessagesNotebook"}],
    Cell[22392, 842, 208, 7, 70, "Notes",
      CellTags->{"S1.1014", "Developer`MessagesNotebook"}],
    Cell[22603, 851, 269, 9, 70, "Notes",
      CellTags->{"S1.1014", "Developer`MessagesNotebook"}]},
  "Developer`MessagesNotebook"->{
    Cell[22009, 829, 103, 1, 70, "ObjectName",
      CellTags->{"S1.1014", "Developer`MessagesNotebook"}],
    Cell[22115, 832, 274, 8, 70, "Usage",
      CellTags->{"S1.1014", "Developer`MessagesNotebook"}],
    Cell[22392, 842, 208, 7, 70, "Notes",
      CellTags->{"S1.1014", "Developer`MessagesNotebook"}],
    Cell[22603, 851, 269, 9, 70, "Notes",
      CellTags->{"S1.1014", "Developer`MessagesNotebook"}]},
  "S1.1015"->{
    Cell[22909, 865, 101, 1, 70, "ObjectName",
      CellTags->{"S1.1015", "Developer`NotebookConvert"}],
    Cell[23013, 868, 365, 11, 70, "Usage",
      CellTags->{"S1.1015", "Developer`NotebookConvert"}],
    Cell[23381, 881, 351, 13, 70, "Notes",
      CellTags->{"S1.1015", "Developer`NotebookConvert"}],
    Cell[23735, 896, 202, 4, 70, "Notes",
      CellTags->{"S1.1015", "Developer`NotebookConvert"}],
    Cell[23940, 902, 187, 6, 70, "Notes",
      CellTags->{"S1.1015", "Developer`NotebookConvert"}]},
  "Developer`NotebookConvert"->{
    Cell[22909, 865, 101, 1, 70, "ObjectName",
      CellTags->{"S1.1015", "Developer`NotebookConvert"}],
    Cell[23013, 868, 365, 11, 70, "Usage",
      CellTags->{"S1.1015", "Developer`NotebookConvert"}],
    Cell[23381, 881, 351, 13, 70, "Notes",
      CellTags->{"S1.1015", "Developer`NotebookConvert"}],
    Cell[23735, 896, 202, 4, 70, "Notes",
      CellTags->{"S1.1015", "Developer`NotebookConvert"}],
    Cell[23940, 902, 187, 6, 70, "Notes",
      CellTags->{"S1.1015", "Developer`NotebookConvert"}]},
  "S1.1016"->{
    Cell[24164, 913, 109, 1, 70, "ObjectName",
      CellTags->{"S1.1016", "Developer`NotebookInformation"}],
    Cell[24276, 916, 294, 8, 70, "Usage",
      CellTags->{"S1.1016", "Developer`NotebookInformation"}],
    Cell[24573, 926, 286, 6, 70, "Notes",
      CellTags->{"S1.1016", "Developer`NotebookInformation"}],
    Cell[24862, 934, 192, 5, 70, "Notes",
      CellTags->{"S1.1016", "Developer`NotebookInformation"}],
    Cell[25057, 941, 268, 9, 70, "Notes",
      CellTags->{"S1.1016", "Developer`NotebookInformation"}]},
  "Developer`NotebookInformation"->{
    Cell[24164, 913, 109, 1, 70, "ObjectName",
      CellTags->{"S1.1016", "Developer`NotebookInformation"}],
    Cell[24276, 916, 294, 8, 70, "Usage",
      CellTags->{"S1.1016", "Developer`NotebookInformation"}],
    Cell[24573, 926, 286, 6, 70, "Notes",
      CellTags->{"S1.1016", "Developer`NotebookInformation"}],
    Cell[24862, 934, 192, 5, 70, "Notes",
      CellTags->{"S1.1016", "Developer`NotebookInformation"}],
    Cell[25057, 941, 268, 9, 70, "Notes",
      CellTags->{"S1.1016", "Developer`NotebookInformation"}]},
  "S1.1017"->{
    Cell[25362, 955, 101, 1, 70, "ObjectName",
      CellTags->{"S1.1017", "Developer`PackedArrayForm"}],
    Cell[25466, 958, 335, 9, 70, "Usage",
      CellTags->{"S1.1017", "Developer`PackedArrayForm"}],
    Cell[25804, 969, 246, 9, 70, "Notes",
      CellTags->{"S1.1017", "Developer`PackedArrayForm"}]},
  "Developer`PackedArrayForm"->{
    Cell[25362, 955, 101, 1, 70, "ObjectName",
      CellTags->{"S1.1017", "Developer`PackedArrayForm"}],
    Cell[25466, 958, 335, 9, 70, "Usage",
      CellTags->{"S1.1017", "Developer`PackedArrayForm"}],
    Cell[25804, 969, 246, 9, 70, "Notes",
      CellTags->{"S1.1017", "Developer`PackedArrayForm"}]},
  "S1.1018"->{
    Cell[26087, 983, 95, 1, 70, "ObjectName",
      CellTags->{"S1.1018", "Developer`PackedArrayQ"}],
    Cell[26185, 986, 1025, 39, 70, "Usage",
      CellTags->{"S1.1018", "Developer`PackedArrayQ"}],
    Cell[27213, 1027, 236, 9, 70, "Notes",
      CellTags->{"S1.1018", "Developer`PackedArrayQ"}],
    Cell[27452, 1038, 253, 9, 70, "Notes",
      CellTags->{"S1.1018", "Developer`PackedArrayQ"}]},
  "Developer`PackedArrayQ"->{
    Cell[26087, 983, 95, 1, 70, "ObjectName",
      CellTags->{"S1.1018", "Developer`PackedArrayQ"}],
    Cell[26185, 986, 1025, 39, 70, "Usage",
      CellTags->{"S1.1018", "Developer`PackedArrayQ"}],
    Cell[27213, 1027, 236, 9, 70, "Notes",
      CellTags->{"S1.1018", "Developer`PackedArrayQ"}],
    Cell[27452, 1038, 253, 9, 70, "Notes",
      CellTags->{"S1.1018", "Developer`PackedArrayQ"}]},
  "S1.1019"->{
    Cell[27742, 1052, 95, 1, 70, "ObjectName",
      CellTags->{"S1.1019", "Developer`PartitionMap"}],
    Cell[27840, 1055, 4714, 199, 70, "Usage",
      CellTags->{"S1.1019", "Developer`PartitionMap"}],
    Cell[32557, 1256, 649, 32, 70, "Notes",
      CellTags->{"S1.1019", "Developer`PartitionMap"}],
    Cell[33209, 1290, 1297, 61, 70, "Notes",
      CellTags->{"S1.1019", "Developer`PartitionMap"}],
    Cell[34509, 1353, 238, 8, 70, "Notes",
      CellTags->{"S1.1019", "Developer`PartitionMap"}],
    Cell[34750, 1363, 377, 15, 70, "Notes",
      CellTags->{"S1.1019", "Developer`PartitionMap"}]},
  "Developer`PartitionMap"->{
    Cell[27742, 1052, 95, 1, 70, "ObjectName",
      CellTags->{"S1.1019", "Developer`PartitionMap"}],
    Cell[27840, 1055, 4714, 199, 70, "Usage",
      CellTags->{"S1.1019", "Developer`PartitionMap"}],
    Cell[32557, 1256, 649, 32, 70, "Notes",
      CellTags->{"S1.1019", "Developer`PartitionMap"}],
    Cell[33209, 1290, 1297, 61, 70, "Notes",
      CellTags->{"S1.1019", "Developer`PartitionMap"}],
    Cell[34509, 1353, 238, 8, 70, "Notes",
      CellTags->{"S1.1019", "Developer`PartitionMap"}],
    Cell[34750, 1363, 377, 15, 70, "Notes",
      CellTags->{"S1.1019", "Developer`PartitionMap"}]},
  "S1.1020"->{
    Cell[35164, 1383, 105, 1, 70, "ObjectName",
      CellTags->{"S1.1020", "Developer`PolyGammaSimplify"}],
    Cell[35272, 1386, 401, 10, 70, "Usage",
      CellTags->{"S1.1020", "Developer`PolyGammaSimplify"}],
    Cell[35676, 1398, 274, 9, 70, "Notes",
      CellTags->{"S1.1020", "Developer`PolyGammaSimplify"}]},
  "Developer`PolyGammaSimplify"->{
    Cell[35164, 1383, 105, 1, 70, "ObjectName",
      CellTags->{"S1.1020", "Developer`PolyGammaSimplify"}],
    Cell[35272, 1386, 401, 10, 70, "Usage",
      CellTags->{"S1.1020", "Developer`PolyGammaSimplify"}],
    Cell[35676, 1398, 274, 9, 70, "Notes",
      CellTags->{"S1.1020", "Developer`PolyGammaSimplify"}]},
  "S1.1021"->{
    Cell[35987, 1412, 101, 1, 70, "ObjectName",
      CellTags->{"S1.1021", "Developer`PolyLogSimplify"}],
    Cell[36091, 1415, 405, 10, 70, "Usage",
      CellTags->{"S1.1021", "Developer`PolyLogSimplify"}],
    Cell[36499, 1427, 270, 9, 70, "Notes",
      CellTags->{"S1.1021", "Developer`PolyLogSimplify"}]},
  "Developer`PolyLogSimplify"->{
    Cell[35987, 1412, 101, 1, 70, "ObjectName",
      CellTags->{"S1.1021", "Developer`PolyLogSimplify"}],
    Cell[36091, 1415, 405, 10, 70, "Usage",
      CellTags->{"S1.1021", "Developer`PolyLogSimplify"}],
    Cell[36499, 1427, 270, 9, 70, "Notes",
      CellTags->{"S1.1021", "Developer`PolyLogSimplify"}]},
  "S1.1022"->{
    Cell[36806, 1441, 107, 1, 70, "ObjectName",
      CellTags->{"S1.1022", "Developer`PolynomialDivision"}],
    Cell[36916, 1444, 479, 19, 70, "Usage",
      CellTags->{"S1.1022", "Developer`PolynomialDivision"}],
    Cell[37398, 1465, 201, 6, 70, "Notes",
      CellTags->{"S1.1022", "Developer`PolynomialDivision"}],
    Cell[37602, 1473, 348, 12, 70, "Notes",
      CellTags->{"S1.1022", "Developer`PolynomialDivision"}],
    Cell[37975, 1489, 99, 1, 70, "ExampleSection",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[38077, 1492, 106, 1, 70, "ExampleText",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[38186, 1495, 154, 3, 70, "Input",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[38343, 1500, 126, 3, 70, "Input",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[38472, 1505, 169, 4, 70, "ExampleText",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[38666, 1513, 161, 3, 70, "Input",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[38830, 1518, 161, 3, 70, "Output",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[39006, 1524, 104, 1, 70, "ExampleText",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[39135, 1529, 135, 3, 70, "Input",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[39273, 1534, 117, 3, 70, "Output",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[39405, 1540, 132, 3, 70, "Input",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}]},
  "Developer`PolynomialDivision"->{
    Cell[36806, 1441, 107, 1, 70, "ObjectName",
      CellTags->{"S1.1022", "Developer`PolynomialDivision"}],
    Cell[36916, 1444, 479, 19, 70, "Usage",
      CellTags->{"S1.1022", "Developer`PolynomialDivision"}],
    Cell[37398, 1465, 201, 6, 70, "Notes",
      CellTags->{"S1.1022", "Developer`PolynomialDivision"}],
    Cell[37602, 1473, 348, 12, 70, "Notes",
      CellTags->{"S1.1022", "Developer`PolynomialDivision"}],
    Cell[37975, 1489, 99, 1, 70, "ExampleSection",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[38077, 1492, 106, 1, 70, "ExampleText",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[38186, 1495, 154, 3, 70, "Input",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[38343, 1500, 126, 3, 70, "Input",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[38472, 1505, 169, 4, 70, "ExampleText",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[38666, 1513, 161, 3, 70, "Input",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[38830, 1518, 161, 3, 70, "Output",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[39006, 1524, 104, 1, 70, "ExampleText",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[39135, 1529, 135, 3, 70, "Input",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[39273, 1534, 117, 3, 70, "Output",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
    Cell[39405, 1540, 132, 3, 70, "Input",
      CellTags->{"Developer`PolynomialDivision", "S1.1022"}]},
  "S1.1023"->{
    Cell[39586, 1549, 103, 1, 70, "ObjectName",
      CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],
    Cell[39692, 1552, 410, 13, 70, "Usage",
      CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],
    Cell[40105, 1567, 302, 7, 70, "Notes",
      CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],
    Cell[40410, 1576, 357, 14, 70, "Notes",
      CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],
    Cell[40770, 1592, 315, 12, 70, "Notes",
      CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}]},
  "Developer`ReplaceAllUnheld"->{
    Cell[39586, 1549, 103, 1, 70, "ObjectName",
      CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],
    Cell[39692, 1552, 410, 13, 70, "Usage",
      CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],
    Cell[40105, 1567, 302, 7, 70, "Notes",
      CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],
    Cell[40410, 1576, 357, 14, 70, "Notes",
      CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],
    Cell[40770, 1592, 315, 12, 70, "Notes",
      CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}]},
  "S1.1024"->{
    Cell[41122, 1609, 103, 1, 70, "ObjectName",
      CellTags->{"S1.1024", "Developer`SetSystemOptions"}],
    Cell[41228, 1612, 291, 9, 70, "Usage",
      CellTags->{"S1.1024", "Developer`SetSystemOptions"}],
    Cell[41522, 1623, 190, 6, 70, "Notes",
      CellTags->{"S1.1024", "Developer`SetSystemOptions"}]},
  "Developer`SetSystemOptions"->{
    Cell[41122, 1609, 103, 1, 70, "ObjectName",
      CellTags->{"S1.1024", "Developer`SetSystemOptions"}],
    Cell[41228, 1612, 291, 9, 70, "Usage",
      CellTags->{"S1.1024", "Developer`SetSystemOptions"}],
    Cell[41522, 1623, 190, 6, 70, "Notes",
      CellTags->{"S1.1024", "Developer`SetSystemOptions"}]},
  "S1.1025"->{
    Cell[41749, 1634, 97, 1, 70, "ObjectName",
      CellTags->{"S1.1025", "Developer`SystemOptions"}],
    Cell[41849, 1637, 426, 13, 70, "Usage",
      CellTags->{"S1.1025", "Developer`SystemOptions"}],
    Cell[42278, 1652, 221, 6, 70, "Notes",
      CellTags->{"S1.1025", "Developer`SystemOptions"}],
    Cell[42502, 1660, 190, 6, 70, "Notes",
      CellTags->{"S1.1025", "Developer`SystemOptions"}]},
  "Developer`SystemOptions"->{
    Cell[41749, 1634, 97, 1, 70, "ObjectName",
      CellTags->{"S1.1025", "Developer`SystemOptions"}],
    Cell[41849, 1637, 426, 13, 70, "Usage",
      CellTags->{"S1.1025", "Developer`SystemOptions"}],
    Cell[42278, 1652, 221, 6, 70, "Notes",
      CellTags->{"S1.1025", "Developer`SystemOptions"}],
    Cell[42502, 1660, 190, 6, 70, "Notes",
      CellTags->{"S1.1025", "Developer`SystemOptions"}]},
  "S1.1026"->{
    Cell[42729, 1671, 97, 1, 70, "ObjectName",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[42829, 1674, 297, 9, 70, "Usage",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[43129, 1685, 292, 7, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[43424, 1694, 229, 6, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[43656, 1702, 305, 7, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[43964, 1711, 354, 12, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[44321, 1725, 237, 9, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[44561, 1736, 165, 4, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[44729, 1742, 347, 8, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[45079, 1752, 256, 9, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}]},
  "Developer`ToPackedArray"->{
    Cell[42729, 1671, 97, 1, 70, "ObjectName",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[42829, 1674, 297, 9, 70, "Usage",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[43129, 1685, 292, 7, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[43424, 1694, 229, 6, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[43656, 1702, 305, 7, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[43964, 1711, 354, 12, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[44321, 1725, 237, 9, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[44561, 1736, 165, 4, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[44729, 1742, 347, 8, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}],
    Cell[45079, 1752, 256, 9, 70, "Notes",
      CellTags->{"S1.1026", "Developer`ToPackedArray"}]},
  "S1.1027"->{
    Cell[45372, 1766, 99, 1, 70, "ObjectName",
      CellTags->{"S1.1027", "Developer`TrigToRadicals"}],
    Cell[45474, 1769, 300, 9, 48, "Usage",
      CellTags->{"S1.1027", "Developer`TrigToRadicals"}],
    Cell[45777, 1780, 307, 9, 70, "Notes",
      CellTags->{"S1.1027", "Developer`TrigToRadicals"}],
    Cell[46087, 1791, 268, 9, 40, "Notes",
      CellTags->{"S1.1027", "Developer`TrigToRadicals"}]},
  "Developer`TrigToRadicals"->{
    Cell[45372, 1766, 99, 1, 70, "ObjectName",
      CellTags->{"S1.1027", "Developer`TrigToRadicals"}],
    Cell[45474, 1769, 300, 9, 48, "Usage",
      CellTags->{"S1.1027", "Developer`TrigToRadicals"}],
    Cell[45777, 1780, 307, 9, 70, "Notes",
      CellTags->{"S1.1027", "Developer`TrigToRadicals"}],
    Cell[46087, 1791, 268, 9, 40, "Notes",
      CellTags->{"S1.1027", "Developer`TrigToRadicals"}]},
  "S1.1028"->{
    Cell[46392, 1805, 81, 1, 38, "ObjectName",
      CellTags->{"S1.1028", "Developer`ZeroQ"}],
    Cell[46476, 1808, 410, 13, 48, "Usage",
      CellTags->{"S1.1028", "Developer`ZeroQ"}],
    Cell[46889, 1823, 218, 6, 40, "Notes",
      CellTags->{"S1.1028", "Developer`ZeroQ"}],
    Cell[47110, 1831, 424, 12, 56, "Notes",
      CellTags->{"S1.1028", "Developer`ZeroQ"}],
    Cell[47537, 1845, 174, 6, 24, "Notes",
      CellTags->{"S1.1028", "Developer`ZeroQ"}]},
  "Developer`ZeroQ"->{
    Cell[46392, 1805, 81, 1, 38, "ObjectName",
      CellTags->{"S1.1028", "Developer`ZeroQ"}],
    Cell[46476, 1808, 410, 13, 48, "Usage",
      CellTags->{"S1.1028", "Developer`ZeroQ"}],
    Cell[46889, 1823, 218, 6, 40, "Notes",
      CellTags->{"S1.1028", "Developer`ZeroQ"}],
    Cell[47110, 1831, 424, 12, 56, "Notes",
      CellTags->{"S1.1028", "Developer`ZeroQ"}],
    Cell[47537, 1845, 174, 6, 24, "Notes",
      CellTags->{"S1.1028", "Developer`ZeroQ"}]},
  "S1.1029"->{
    Cell[47748, 1856, 95, 1, 38, "ObjectName",
      CellTags->{"S1.1029", "Developer`ZetaSimplify"}],
    Cell[47846, 1859, 381, 10, 64, "Usage",
      CellTags->{"S1.1029", "Developer`ZetaSimplify"}],
    Cell[48230, 1871, 264, 9, 40, "Notes",
      CellTags->{"S1.1029", "Developer`ZetaSimplify"}]},
  "Developer`ZetaSimplify"->{
    Cell[47748, 1856, 95, 1, 38, "ObjectName",
      CellTags->{"S1.1029", "Developer`ZetaSimplify"}],
    Cell[47846, 1859, 381, 10, 64, "Usage",
      CellTags->{"S1.1029", "Developer`ZetaSimplify"}],
    Cell[48230, 1871, 264, 9, 40, "Notes",
      CellTags->{"S1.1029", "Developer`ZetaSimplify"}]},
  "S1.1030"->{
    Cell[48531, 1885, 107, 1, 38, "ObjectName",
      CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],
    Cell[48641, 1888, 274, 6, 48, "Usage",
      CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],
    Cell[48918, 1896, 577, 19, 40, "Notes",
      CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],
    Cell[49498, 1917, 273, 6, 40, "Notes",
      CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],
    Cell[49774, 1925, 344, 12, 24, "Notes",
      CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}]},
  "Developer`$MaxMachineInteger"->{
    Cell[48531, 1885, 107, 1, 38, "ObjectName",
      CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],
    Cell[48641, 1888, 274, 6, 48, "Usage",
      CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],
    Cell[48918, 1896, 577, 19, 40, "Notes",
      CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],
    Cell[49498, 1917, 273, 6, 40, "Notes",
      CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],
    Cell[49774, 1925, 344, 12, 24, "Notes",
      CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.14.0", 50774, 1958},
  {"0.1", 50865, 1961},
  {"SA.14.1", 50960, 1964},
  {"1.1", 51432, 1977},
  {"1.2", 51525, 1980},
  {"1.3", 51614, 1983},
  {"1.4", 51702, 1986},
  {"S1.1001", 51796, 1989},
  {"Developer`BesselSimplify", 52131, 1996},
  {"S1.1002", 52449, 2003},
  {"Developer`BitLength", 52952, 2014},
  {"S1.1003", 53443, 2025},
  {"Developer`BitShiftLeft", 53868, 2034},
  {"S1.1004", 54278, 2043},
  {"Developer`BitShiftRight", 54806, 2054},
  {"S1.1005", 55318, 2065},
  {"Developer`ClearCache", 55921, 2078},
  {"S1.1006", 56511, 2091},
  {"Developer`ClipboardNotebook", 56965, 2100},
  {"S1.1007", 57399, 2109},
  {"Developer`FibonacciSimplify", 57957, 2120},
  {"S1.1008", 58495, 2131},
  {"Developer`FileInformation", 59040, 2142},
  {"S1.1009", 59567, 2153},
  {"Developer`FromPackedArray", 60113, 2164},
  {"S1.1010", 60641, 2175},
  {"Developer`GammaSimplify", 60975, 2182},
  {"S1.1011", 61293, 2189},
  {"Developer`HelpBrowserNotebook", 61652, 2196},
  {"S1.1012", 61989, 2203},
  {"Developer`HermiteNormalForm", 63394, 2230},
  {"S1.1013", 64779, 2257},
  {"Developer`MachineIntegerQ", 65325, 2268},
  {"S1.1014", 65853, 2279},
  {"Developer`MessagesNotebook", 66301, 2288},
  {"S1.1015", 66730, 2297},
  {"Developer`NotebookConvert", 67276, 2308},
  {"S1.1016", 67804, 2319},
  {"Developer`NotebookInformation", 68372, 2330},
  {"S1.1017", 68918, 2341},
  {"Developer`PackedArrayForm", 69260, 2348},
  {"S1.1018", 69584, 2355},
  {"Developer`PackedArrayQ", 70015, 2364},
  {"S1.1019", 70431, 2373},
  {"Developer`PartitionMap", 71067, 2386},
  {"S1.1020", 71688, 2399},
  {"Developer`PolyGammaSimplify", 72042, 2406},
  {"S1.1021", 72376, 2413},
  {"Developer`PolyLogSimplify", 72722, 2420},
  {"S1.1022", 73050, 2427},
  {"Developer`PolynomialDivision", 74697, 2458},
  {"S1.1023", 76323, 2489},
  {"Developer`ReplaceAllUnheld", 76881, 2500},
  {"S1.1024", 77420, 2511},
  {"Developer`SetSystemOptions", 77769, 2518},
  {"S1.1025", 78099, 2525},
  {"Developer`SystemOptions", 78536, 2534},
  {"S1.1026", 78957, 2543},
  {"Developer`ToPackedArray", 79994, 2564},
  {"S1.1027", 81015, 2585},
  {"Developer`TrigToRadicals", 81456, 2594},
  {"S1.1028", 81880, 2603},
  {"Developer`ZeroQ", 82370, 2614},
  {"S1.1029", 82852, 2625},
  {"Developer`ZetaSimplify", 83185, 2632},
  {"S1.1030", 83503, 2639},
  {"Developer`$MaxMachineInteger", 84072, 2650}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 178, 6, 91, "Section",
  CellTags->{"SA.14.0", "0.1"}],

Cell[CellGroupData[{
Cell[1979, 63, 73, 1, 70, "Subsection",
  CellTags->{"SA.14.1", "1.1"}],
Cell[2055, 66, 366, 11, 70, "Text",
  CellTags->{"SA.14.1", "1.2"}],
Cell[2424, 79, 309, 8, 70, "Text",
  CellTags->{"SA.14.1", "1.3"}],
Cell[2736, 89, 773, 23, 70, "DefinitionBox",
  CellTags->"SA.14.1"],
Cell[3512, 114, 138, 5, 70, "Caption",
  CellTags->"SA.14.1"],
Cell[3653, 121, 600, 20, 70, "Text",
  CellTags->{"SA.14.1", "1.4"}],

Cell[CellGroupData[{
Cell[4278, 145, 99, 1, 70, "ObjectName",
  CellTags->{"S1.1001", "Developer`BesselSimplify"}],
Cell[4380, 148, 385, 10, 70, "Usage",
  CellTags->{"S1.1001", "Developer`BesselSimplify"}],
Cell[4768, 160, 268, 9, 70, "Notes",
  CellTags->{"S1.1001", "Developer`BesselSimplify"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5073, 174, 89, 1, 70, "ObjectName",
  CellTags->{"S1.1002", "Developer`BitLength"}],
Cell[5165, 177, 285, 9, 70, "Usage",
  CellTags->{"S1.1002", "Developer`BitLength"}],
Cell[5453, 188, 426, 18, 70, "Notes",
  CellTags->{"S1.1002", "Developer`BitLength"}],
Cell[5882, 208, 259, 9, 70, "Notes",
  CellTags->{"S1.1002", "Developer`BitLength"}],
Cell[6144, 219, 259, 9, 70, "Notes",
  CellTags->{"S1.1002", "Developer`BitLength"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6440, 233, 95, 1, 70, "ObjectName",
  CellTags->{"S1.1003", "Developer`BitShiftLeft"}],
Cell[6538, 236, 400, 14, 70, "Usage",
  CellTags->{"S1.1003", "Developer`BitShiftLeft"}],
Cell[6941, 252, 348, 15, 70, "Notes",
  CellTags->{"S1.1003", "Developer`BitShiftLeft"}],
Cell[7292, 269, 174, 5, 70, "Notes",
  CellTags->{"S1.1003", "Developer`BitShiftLeft"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7503, 279, 97, 1, 70, "ObjectName",
  CellTags->{"S1.1004", "Developer`BitShiftRight"}],
Cell[7603, 282, 442, 15, 70, "Usage",
  CellTags->{"S1.1004", "Developer`BitShiftRight"}],
Cell[8048, 299, 401, 16, 70, "Notes",
  CellTags->{"S1.1004", "Developer`BitShiftRight"}],
Cell[8452, 317, 174, 5, 70, "Notes",
  CellTags->{"S1.1004", "Developer`BitShiftRight"}],
Cell[8629, 324, 190, 6, 70, "Notes",
  CellTags->{"S1.1004", "Developer`BitShiftRight"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8856, 335, 91, 1, 70, "ObjectName",
  CellTags->{"S1.1005", "Developer`ClearCache"}],
Cell[8950, 338, 215, 7, 70, "Usage",
  CellTags->{"S1.1005", "Developer`ClearCache"}],
Cell[9168, 347, 251, 6, 70, "Notes",
  CellTags->{"S1.1005", "Developer`ClearCache"}],
Cell[9422, 355, 194, 5, 70, "Notes",
  CellTags->{"S1.1005", "Developer`ClearCache"}],
Cell[9619, 362, 196, 5, 70, "Notes",
  CellTags->{"S1.1005", "Developer`ClearCache"}],
Cell[9818, 369, 177, 6, 70, "Notes",
  CellTags->{"S1.1005", "Developer`ClearCache"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[10032, 380, 105, 1, 70, "ObjectName",
  CellTags->{"S1.1006", "Developer`ClipboardNotebook"}],
Cell[10140, 383, 317, 8, 70, "Usage",
  CellTags->{"S1.1006", "Developer`ClipboardNotebook"}],
Cell[10460, 393, 169, 4, 70, "Notes",
  CellTags->{"S1.1006", "Developer`ClipboardNotebook"}],
Cell[10632, 399, 341, 12, 70, "Notes",
  CellTags->{"S1.1006", "Developer`ClipboardNotebook"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11010, 416, 105, 1, 70, "ObjectName",
  CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],
Cell[11118, 419, 413, 14, 70, "Usage",
  CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],
Cell[11534, 435, 371, 13, 70, "Notes",
  CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],
Cell[11908, 450, 267, 6, 70, "Notes",
  CellTags->{"S1.1007", "Developer`FibonacciSimplify"}],
Cell[12178, 458, 274, 9, 70, "Notes",
  CellTags->{"S1.1007", "Developer`FibonacciSimplify"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12489, 472, 101, 1, 70, "ObjectName",
  CellTags->{"S1.1008", "Developer`FileInformation"}],
Cell[12593, 475, 264, 7, 70, "Usage",
  CellTags->{"S1.1008", "Developer`FileInformation"}],
Cell[12860, 484, 253, 6, 70, "Notes",
  CellTags->{"S1.1008", "Developer`FileInformation"}],
Cell[13116, 492, 195, 5, 70, "Notes",
  CellTags->{"S1.1008", "Developer`FileInformation"}],
Cell[13314, 499, 472, 18, 70, "Notes",
  CellTags->{"S1.1008", "Developer`FileInformation"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13823, 522, 101, 1, 70, "ObjectName",
  CellTags->{"S1.1009", "Developer`FromPackedArray"}],
Cell[13927, 525, 302, 9, 70, "Usage",
  CellTags->{"S1.1009", "Developer`FromPackedArray"}],
Cell[14232, 536, 297, 7, 70, "Notes",
  CellTags->{"S1.1009", "Developer`FromPackedArray"}],
Cell[14532, 545, 313, 11, 70, "Notes",
  CellTags->{"S1.1009", "Developer`FromPackedArray"}],
Cell[14848, 558, 326, 12, 70, "Notes",
  CellTags->{"S1.1009", "Developer`FromPackedArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[15211, 575, 97, 1, 70, "ObjectName",
  CellTags->{"S1.1010", "Developer`GammaSimplify"}],
Cell[15311, 578, 385, 10, 70, "Usage",
  CellTags->{"S1.1010", "Developer`GammaSimplify"}],
Cell[15699, 590, 266, 9, 70, "Notes",
  CellTags->{"S1.1010", "Developer`GammaSimplify"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16002, 604, 109, 1, 70, "ObjectName",
  CellTags->{"S1.1011", "Developer`HelpBrowserNotebook"}],
Cell[16114, 607, 285, 8, 70, "Usage",
  CellTags->{"S1.1011", "Developer`HelpBrowserNotebook"}],
Cell[16402, 617, 346, 12, 70, "Notes",
  CellTags->{"S1.1011", "Developer`HelpBrowserNotebook"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16785, 634, 105, 1, 70, "ObjectName",
  CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],
Cell[16893, 637, 285, 9, 70, "Usage",
  CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],
Cell[17181, 648, 556, 24, 70, "Notes",
  CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],
Cell[17740, 674, 258, 9, 70, "Notes",
  CellTags->{"S1.1012", "Developer`HermiteNormalForm"}],

Cell[CellGroupData[{
Cell[18023, 687, 98, 1, 70, "ExampleSection",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
Cell[18124, 690, 184, 5, 70, "ExampleText",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
Cell[18311, 697, 423, 11, 70, "Input",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],

Cell[CellGroupData[{
Cell[18759, 712, 137, 3, 70, "Input",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
Cell[18899, 717, 916, 26, 70, "Output",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}]
}, Open  ]],
Cell[19830, 746, 103, 1, 70, "ExampleText",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],

Cell[CellGroupData[{
Cell[19958, 751, 124, 3, 70, "Input",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}],
Cell[20085, 756, 119, 3, 70, "Output",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}]
}, Open  ]],
Cell[20219, 762, 128, 3, 70, "Input",
  CellTags->{"Developer`HermiteNormalForm", "S1.1012"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[20396, 771, 101, 1, 70, "ObjectName",
  CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],
Cell[20500, 774, 376, 13, 70, "Usage",
  CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],
Cell[20879, 789, 542, 16, 70, "Notes",
  CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],
Cell[21424, 807, 284, 6, 70, "Notes",
  CellTags->{"S1.1013", "Developer`MachineIntegerQ"}],
Cell[21711, 815, 261, 9, 70, "Notes",
  CellTags->{"S1.1013", "Developer`MachineIntegerQ"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22009, 829, 103, 1, 70, "ObjectName",
  CellTags->{"S1.1014", "Developer`MessagesNotebook"}],
Cell[22115, 832, 274, 8, 70, "Usage",
  CellTags->{"S1.1014", "Developer`MessagesNotebook"}],
Cell[22392, 842, 208, 7, 70, "Notes",
  CellTags->{"S1.1014", "Developer`MessagesNotebook"}],
Cell[22603, 851, 269, 9, 70, "Notes",
  CellTags->{"S1.1014", "Developer`MessagesNotebook"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22909, 865, 101, 1, 70, "ObjectName",
  CellTags->{"S1.1015", "Developer`NotebookConvert"}],
Cell[23013, 868, 365, 11, 70, "Usage",
  CellTags->{"S1.1015", "Developer`NotebookConvert"}],
Cell[23381, 881, 351, 13, 70, "Notes",
  CellTags->{"S1.1015", "Developer`NotebookConvert"}],
Cell[23735, 896, 202, 4, 70, "Notes",
  CellTags->{"S1.1015", "Developer`NotebookConvert"}],
Cell[23940, 902, 187, 6, 70, "Notes",
  CellTags->{"S1.1015", "Developer`NotebookConvert"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[24164, 913, 109, 1, 70, "ObjectName",
  CellTags->{"S1.1016", "Developer`NotebookInformation"}],
Cell[24276, 916, 294, 8, 70, "Usage",
  CellTags->{"S1.1016", "Developer`NotebookInformation"}],
Cell[24573, 926, 286, 6, 70, "Notes",
  CellTags->{"S1.1016", "Developer`NotebookInformation"}],
Cell[24862, 934, 192, 5, 70, "Notes",
  CellTags->{"S1.1016", "Developer`NotebookInformation"}],
Cell[25057, 941, 268, 9, 70, "Notes",
  CellTags->{"S1.1016", "Developer`NotebookInformation"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[25362, 955, 101, 1, 70, "ObjectName",
  CellTags->{"S1.1017", "Developer`PackedArrayForm"}],
Cell[25466, 958, 335, 9, 70, "Usage",
  CellTags->{"S1.1017", "Developer`PackedArrayForm"}],
Cell[25804, 969, 246, 9, 70, "Notes",
  CellTags->{"S1.1017", "Developer`PackedArrayForm"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[26087, 983, 95, 1, 70, "ObjectName",
  CellTags->{"S1.1018", "Developer`PackedArrayQ"}],
Cell[26185, 986, 1025, 39, 70, "Usage",
  CellTags->{"S1.1018", "Developer`PackedArrayQ"}],
Cell[27213, 1027, 236, 9, 70, "Notes",
  CellTags->{"S1.1018", "Developer`PackedArrayQ"}],
Cell[27452, 1038, 253, 9, 70, "Notes",
  CellTags->{"S1.1018", "Developer`PackedArrayQ"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[27742, 1052, 95, 1, 70, "ObjectName",
  CellTags->{"S1.1019", "Developer`PartitionMap"}],
Cell[27840, 1055, 4714, 199, 70, "Usage",
  CellTags->{"S1.1019", "Developer`PartitionMap"}],
Cell[32557, 1256, 649, 32, 70, "Notes",
  CellTags->{"S1.1019", "Developer`PartitionMap"}],
Cell[33209, 1290, 1297, 61, 70, "Notes",
  CellTags->{"S1.1019", "Developer`PartitionMap"}],
Cell[34509, 1353, 238, 8, 70, "Notes",
  CellTags->{"S1.1019", "Developer`PartitionMap"}],
Cell[34750, 1363, 377, 15, 70, "Notes",
  CellTags->{"S1.1019", "Developer`PartitionMap"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[35164, 1383, 105, 1, 70, "ObjectName",
  CellTags->{"S1.1020", "Developer`PolyGammaSimplify"}],
Cell[35272, 1386, 401, 10, 70, "Usage",
  CellTags->{"S1.1020", "Developer`PolyGammaSimplify"}],
Cell[35676, 1398, 274, 9, 70, "Notes",
  CellTags->{"S1.1020", "Developer`PolyGammaSimplify"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[35987, 1412, 101, 1, 70, "ObjectName",
  CellTags->{"S1.1021", "Developer`PolyLogSimplify"}],
Cell[36091, 1415, 405, 10, 70, "Usage",
  CellTags->{"S1.1021", "Developer`PolyLogSimplify"}],
Cell[36499, 1427, 270, 9, 70, "Notes",
  CellTags->{"S1.1021", "Developer`PolyLogSimplify"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[36806, 1441, 107, 1, 70, "ObjectName",
  CellTags->{"S1.1022", "Developer`PolynomialDivision"}],
Cell[36916, 1444, 479, 19, 70, "Usage",
  CellTags->{"S1.1022", "Developer`PolynomialDivision"}],
Cell[37398, 1465, 201, 6, 70, "Notes",
  CellTags->{"S1.1022", "Developer`PolynomialDivision"}],
Cell[37602, 1473, 348, 12, 70, "Notes",
  CellTags->{"S1.1022", "Developer`PolynomialDivision"}],

Cell[CellGroupData[{
Cell[37975, 1489, 99, 1, 70, "ExampleSection",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
Cell[38077, 1492, 106, 1, 70, "ExampleText",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
Cell[38186, 1495, 154, 3, 70, "Input",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
Cell[38343, 1500, 126, 3, 70, "Input",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
Cell[38472, 1505, 169, 4, 70, "ExampleText",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],

Cell[CellGroupData[{
Cell[38666, 1513, 161, 3, 70, "Input",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
Cell[38830, 1518, 161, 3, 70, "Output",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}]
}, Open  ]],
Cell[39006, 1524, 104, 1, 70, "ExampleText",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],

Cell[CellGroupData[{
Cell[39135, 1529, 135, 3, 70, "Input",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}],
Cell[39273, 1534, 117, 3, 70, "Output",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}]
}, Open  ]],
Cell[39405, 1540, 132, 3, 70, "Input",
  CellTags->{"Developer`PolynomialDivision", "S1.1022"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[39586, 1549, 103, 1, 70, "ObjectName",
  CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],
Cell[39692, 1552, 410, 13, 70, "Usage",
  CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],
Cell[40105, 1567, 302, 7, 70, "Notes",
  CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],
Cell[40410, 1576, 357, 14, 70, "Notes",
  CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}],
Cell[40770, 1592, 315, 12, 70, "Notes",
  CellTags->{"S1.1023", "Developer`ReplaceAllUnheld"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[41122, 1609, 103, 1, 70, "ObjectName",
  CellTags->{"S1.1024", "Developer`SetSystemOptions"}],
Cell[41228, 1612, 291, 9, 70, "Usage",
  CellTags->{"S1.1024", "Developer`SetSystemOptions"}],
Cell[41522, 1623, 190, 6, 70, "Notes",
  CellTags->{"S1.1024", "Developer`SetSystemOptions"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[41749, 1634, 97, 1, 70, "ObjectName",
  CellTags->{"S1.1025", "Developer`SystemOptions"}],
Cell[41849, 1637, 426, 13, 70, "Usage",
  CellTags->{"S1.1025", "Developer`SystemOptions"}],
Cell[42278, 1652, 221, 6, 70, "Notes",
  CellTags->{"S1.1025", "Developer`SystemOptions"}],
Cell[42502, 1660, 190, 6, 70, "Notes",
  CellTags->{"S1.1025", "Developer`SystemOptions"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[42729, 1671, 97, 1, 70, "ObjectName",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],
Cell[42829, 1674, 297, 9, 70, "Usage",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],
Cell[43129, 1685, 292, 7, 70, "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],
Cell[43424, 1694, 229, 6, 70, "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],
Cell[43656, 1702, 305, 7, 70, "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],
Cell[43964, 1711, 354, 12, 70, "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],
Cell[44321, 1725, 237, 9, 70, "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],
Cell[44561, 1736, 165, 4, 70, "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],
Cell[44729, 1742, 347, 8, 70, "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}],
Cell[45079, 1752, 256, 9, 70, "Notes",
  CellTags->{"S1.1026", "Developer`ToPackedArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[45372, 1766, 99, 1, 70, "ObjectName",
  CellTags->{"S1.1027", "Developer`TrigToRadicals"}],
Cell[45474, 1769, 300, 9, 48, "Usage",
  CellTags->{"S1.1027", "Developer`TrigToRadicals"}],
Cell[45777, 1780, 307, 9, 70, "Notes",
  CellTags->{"S1.1027", "Developer`TrigToRadicals"}],
Cell[46087, 1791, 268, 9, 40, "Notes",
  CellTags->{"S1.1027", "Developer`TrigToRadicals"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[46392, 1805, 81, 1, 38, "ObjectName",
  CellTags->{"S1.1028", "Developer`ZeroQ"}],
Cell[46476, 1808, 410, 13, 48, "Usage",
  CellTags->{"S1.1028", "Developer`ZeroQ"}],
Cell[46889, 1823, 218, 6, 40, "Notes",
  CellTags->{"S1.1028", "Developer`ZeroQ"}],
Cell[47110, 1831, 424, 12, 56, "Notes",
  CellTags->{"S1.1028", "Developer`ZeroQ"}],
Cell[47537, 1845, 174, 6, 24, "Notes",
  CellTags->{"S1.1028", "Developer`ZeroQ"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[47748, 1856, 95, 1, 38, "ObjectName",
  CellTags->{"S1.1029", "Developer`ZetaSimplify"}],
Cell[47846, 1859, 381, 10, 64, "Usage",
  CellTags->{"S1.1029", "Developer`ZetaSimplify"}],
Cell[48230, 1871, 264, 9, 40, "Notes",
  CellTags->{"S1.1029", "Developer`ZetaSimplify"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[48531, 1885, 107, 1, 38, "ObjectName",
  CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],
Cell[48641, 1888, 274, 6, 48, "Usage",
  CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],
Cell[48918, 1896, 577, 19, 40, "Notes",
  CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],
Cell[49498, 1917, 273, 6, 40, "Notes",
  CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}],
Cell[49774, 1925, 344, 12, 24, "Notes",
  CellTags->{"S1.1030", "Developer`$MaxMachineInteger"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

