(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23852,        888]*)
(*NotebookOutlinePosition[     40329,       1249]*)
(*  CellTagsIndexPosition[     39474,       1220]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.15 ", "HeadingNumber"],
  "Experimental Context Objects in ",
  StyleBox["Mathematica", "SBO"],
  " 5.2"
}], "Section",
  CellTags->{"SA.15.0", "0.1"}],

Cell[CellGroupData[{

Cell["A.15.1 Introduction", "Subsection",
  CellTags->{"SA.15.1", "1.1"}],

Cell[TextData[{
  "The objects listed below are experimental in ",
  StyleBox["Mathematica", "TI"],
  " Version 5.2, and are subject to change in subsequent versions of ",
  StyleBox["Mathematica", "TI"],
  ".  "
}], "Text",
  CellTags->{"SA.15.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Experimental`", "MR"],
              StyleBox["name", "TI"],
              " "
            }]], Cell[TextData[{
              "access a specific object in the ",
              StyleBox["Experimental`", "MR"],
              " context "
            }]]},
          {Cell[TextData[{
              StyleBox["<<Experimental`", "MR"],
              " "
            }]], Cell[TextData[{
              "set up to be able to access all ",
              StyleBox["Experimental`", "MR"],
              " objects by name "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"SA.15.1"],

Cell[TextData[{
  "Ways to access functions in the ",
  StyleBox["Experimental`", "MR"],
  " context. "
}], "Caption",
  CellTags->"SA.15.1"],

Cell[TextData[{
  "Note that ",
  StyleBox["<<Experimental`", "MR"],
  " adds the ",
  StyleBox["Experimental`", "MR"],
  " context to your ",
  StyleBox["$ContextPath", "MR"],
  ". You can remove it again by explicitly modifying the value of ",
  StyleBox["$ContextPath", "MR"],
  ". You can set up to access ",
  StyleBox["Experimental`", "MR"],
  " context objects automatically in all ",
  StyleBox["Mathematica", "TI"],
  " sessions by adding ",
  StyleBox["<<Experimental`", "MR"],
  " to your ",
  StyleBox["init.m", "MR"],
  " file. "
}], "Text",
  CellTags->{"SA.15.1", "1.3"}],

Cell[CellGroupData[{

Cell["Experimental`CompileEvaluate", "ObjectName",
  CellTags->{"S1.1001", "Experimental`CompileEvaluate"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CompileEvaluate[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " compiles ",
  StyleBox["expr", "TI"],
  " and then evaluates the resulting compiled code. "
}], "Usage",
  CellTags->{"S1.1001", "Experimental`CompileEvaluate"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CompileEvaluate[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " always evaluates to the same result as ",
  StyleBox["expr", "TI"],
  " alone, but is faster for certain types of expressions, particularly ones \
representing large numerical computations. "
}], "Notes",
  CellTags->{"S1.1001", "Experimental`CompileEvaluate"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Compile",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1001", "Experimental`CompileEvaluate"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`ExistsRealQ", "ObjectName",
  CellTags->{"S1.1002", "Experimental`ExistsRealQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ExistsRealQ[", "MR"],
  StyleBox["ineqs", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " tests whether there exist real values of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " for which the inequalities and equations ",
  StyleBox["ineqs", "TI"],
  " are satisfied. "
}], "Usage",
  CellTags->{"S1.1002", "Experimental`ExistsRealQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ForAllRealQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ImpliesRealQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FindInstance",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Eliminate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CylindricalDecomposition",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1002", "Experimental`ExistsRealQ"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],

Cell[TextData[{
  "Here is a problem from a Mathematics Olympiad. Show that, for positive ",
  StyleBox["a", "MR"],
  ", ",
  StyleBox["b", "MR"],
  ", ",
  StyleBox["c", "MR"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\((a\^4 + b\^4 + c\^4)\)/\((a + b + 
              c)\) \[GreaterEqual] a\ b\ c\)], "InlineFormula"],
  ". The result is established by showing that the negation of the inequality \
is false. "
}], "ExampleText",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Experimental`ExistsRealQ[
      a > 0 && b > 0 && 
        c > 0 && \(a\^4 + b\^4 + c\^4\)\/\(a + b + c\) < a\ b\ c, {a, b, 
        c}]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}]
}, Open  ]],

Cell[TextData[{
  "This shows that ",
  Cell[BoxData[
      \( \[GreaterEqual] \)], "InlineFormula"],
  " cannot be replaced with >. "
}], "ExampleText",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`InequalityInstance[
      a > 0 && b > 0 && 
        c > 0 && \(a\^4 + b\^4 + c\^4\)\/\(a + b + c\) == a\ b\ c, {a, b, 
        c}]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],

Cell[BoxData[
    \({a \[Rule] 1, b \[Rule] 1, c \[Rule] 1}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`FileBrowse", "ObjectName",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FileBrowse[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " brings up a file browser to pick the name of a file. "
}], "Usage",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FileBrowse", "MR"],
  " returns as a string the absolute name of the file picked. "
}], "Notes",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FileBrowse[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\"]", "MR"],
  " brings up a file browser with the specified default file name. "
}], "Notes",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FileBrowse[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["\"", "MR"],
  StyleBox["directory", "TI"],
  StyleBox["\"]", "MR"],
  " brings up a file browser starting in the specified directory. "
}], "Notes",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FileBrowse", "MR"],
  " can be used to find names of files for both reading and writing. "
}], "Notes",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FileBrowse", "MR"],
  " is intended primarily for use with local kernels. "
}], "Notes",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["FileNames",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Get",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Put",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`ForAllRealQ", "ObjectName",
  CellTags->{"S1.1004", "Experimental`ForAllRealQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ForAllRealQ[", "MR"],
  StyleBox["ineqs", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " tests whether for all real values of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " the inequalities and equations ",
  StyleBox["ineqs", "TI"],
  " are satisfied. "
}], "Usage",
  CellTags->{"S1.1004", "Experimental`ForAllRealQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ExistsRealQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ImpliesRealQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SolveAlways",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CylindricalDecomposition",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1004", "Experimental`ForAllRealQ"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],

Cell["This establishes a geometric inequality. ", "ExampleText",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],

Cell[BoxData[
    \(triangle = 
      a > 0 && b > 0 && c > 0 && a + c > b && b + c > a && 
        a + b > c; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],

Cell[BoxData[
    \(ineq = 
      a\ b\ c\ \((a\^2\/b\^2 + b\^2\/c\^2 + c\^2\/a\^2)\) \[GreaterEqual] 
        a\^3 + b\^3 + c\^3 + a\ b\ \((b - a)\) + a\ c\ \((a - c)\) + 
          b\ c\ \((c - b)\); \)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Experimental`ForAllRealQ[Implies[triangle, ineq], {a, b, c}]\)], "Input",\

  CellLabel->"In[3]:= ",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}]
}, Open  ]],

Cell[TextData[{
  "Here is a problem from a Mathematics Olympiad. Let ",
  StyleBox["x", "MR"],
  ", ",
  StyleBox["y", "MR"],
  ", and ",
  StyleBox["z", "MR"],
  " be real numbers such that ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 + z\^2 = 2\)], "InlineFormula"],
  ". Prove that ",
  Cell[BoxData[
      \(TraditionalForm\`x + y + z \[LessEqual] 2 + x  y  z\)], 
    "InlineFormula"],
  ", and find values of ",
  StyleBox["x", "MR"],
  ", ",
  StyleBox["y", "MR"],
  ", ",
  StyleBox["z", "MR"],
  " for which ",
  Cell[BoxData[
      \(TraditionalForm\`x + y + z = 2 + x  y  z\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Experimental`ForAllRealQ[
      Implies[x\^2 + y\^2 + z\^2 == 2, 
        x + y + z \[LessEqual] 2 + x\ y\ z], {x, y, z}]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`InequalityInstance[
      x\^2 + y\^2 + z\^2 == 2 && x + y + z == 2 + x\ y\ z, {x, y, 
        z}]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],

Cell[BoxData[
    \({x \[Rule] 0, y \[Rule] 1, z \[Rule] 1}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}]
}, Open  ]],

Cell[BoxData[
    \(Clear[triangle, ineq]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`ImpliesQ", "ObjectName",
  CellTags->{"S1.1005", "Experimental`ImpliesQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ImpliesQ[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["]", "MR"],
  " tests whether the expression ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " implies ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S1.1005", "Experimental`ImpliesQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ImpliesQ", "MR"],
  " returns ",
  StyleBox["False", "MR"],
  " if it cannot determine whether ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " implies ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  ", using any of its built\[Hyphen]in transformation rules. "
}], "Notes",
  CellTags->{"S1.1005", "Experimental`ImpliesQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] The related function ",
  StyleBox["Implies[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["]", "MR"],
  " remains unevaluated if it cannot immediately determine whether ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " implies ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S1.1005", "Experimental`ImpliesQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Implies",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ImpliesRealQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FullSimplify",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1005", "Experimental`ImpliesQ"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->{"Experimental`ImpliesQ", "S1.1005"}],

Cell[TextData[{
  "The expression is nonnegative for all real values of ",
  StyleBox["v", "MR"],
  ". "
}], "ExampleText",
  CellTags->{"Experimental`ImpliesQ", "S1.1005"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Experimental`ImpliesQ[v \[Element] Reals, 
      2\^\(-\(2\/\[ExponentialE]\^v\)\) + 
          2\^\(2 - \[ExponentialE]\^\(-v\)\) + 
          3\^\(-\(2\/\[ExponentialE]\^v\)\) - 
          2\^\(1 - \[ExponentialE]\^\(-v\)\)\/3\^\(\[ExponentialE]\^\(-v\)\) \
\[GreaterEqual] 0]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->{"Experimental`ImpliesQ", "S1.1005"}],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->{"Experimental`ImpliesQ", "S1.1005"}]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`ImpliesRealQ", "ObjectName",
  CellTags->{"S1.1006", "Experimental`ImpliesRealQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ImpliesRealQ[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["ineqs",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["ineqs",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["]", "MR"],
  " tests whether the inequalities and equations ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["ineqs",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " imply the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["ineqs",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " for all real values of all variables. "
}], "Usage",
  CellTags->{"S1.1006", "Experimental`ImpliesRealQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ForAllRealQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ExistsRealQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ImpliesQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CylindricalDecomposition",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1006", "Experimental`ImpliesRealQ"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}],

Cell[TextData[{
  "The inequalities on the variables in the first argument of ",
  StyleBox["Experimental`ImpliesRealQ", "MR"],
  " imply the inequality in the second argument. "
}], "ExampleText",
  CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Experimental`ImpliesRealQ[
      a + c \[GreaterEqual] b && c \[GreaterEqual] 0 && 
        b + c \[GreaterEqual] a && b \[GreaterEqual] 0 && 
        a + b \[GreaterEqual] c && a \[GreaterEqual] 0, 
      3\ \((a\^2\/b\^2 + b\^2\/c\^2 + 
                c\^2\/a\^2)\) - \((\((1\/a\^2 + 1\/b\^2 + 
                  1\/c\^2)\)\ \((a\^2 + b\^2 + c\^2)\))\) \[GreaterEqual] 
        0]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`ValueFunction", "ObjectName",
  CellTags->{"S1.1007", "Experimental`ValueFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ValueFunction[", "MR"],
  StyleBox["symb", "TI"],
  StyleBox["]", "MR"],
  " represents a function to be applied whenever the symbol ",
  StyleBox["symb", "TI"],
  " gets a new value.  "
}], "Usage",
  CellTags->{"S1.1007", "Experimental`ValueFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] The assignment ",
  StyleBox["ValueFunction[", "MR"],
  StyleBox["symb", "TI"],
  StyleBox["]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["f", "TI"],
  " specifies that whenever ",
  StyleBox["symb", "TI"],
  " gets a new value ",
  StyleBox["val", "TI"],
  ", the expression ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["symb", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["val", "TI"],
  StyleBox["]", "MR"],
  " should be evaluated. "
}], "Notes",
  CellTags->{"S1.1007", "Experimental`ValueFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the value of ",
  StyleBox["symb", "TI"],
  " is cleared, ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["symb", "TI"],
  StyleBox["]", "MR"],
  " is evaluated. "
}], "Notes",
  CellTags->{"S1.1007", "Experimental`ValueFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ValueFunction", "MR"],
  " takes account of all ways that the value of a symbol can be changed, not \
just ",
  StyleBox["Set", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1007", "Experimental`ValueFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Trace",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1007", "Experimental`ValueFunction"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`$EqualTolerance", "ObjectName",
  CellTags->{"S1.1008", "Experimental`$EqualTolerance"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$EqualTolerance", "MR"],
  " gives the number of decimal digits by which two numbers can disagree and \
still be considered equal according to ",
  StyleBox["Equal", "MR"],
  ". "
}], "Usage",
  CellTags->{"S1.1008", "Experimental`$EqualTolerance"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is equal to ",
  StyleBox["Log[10,", "MR"],
  " ",
  StyleBox["2^7]", "MR"],
  ", corresponding to a tolerance of 7 binary digits. "
}], "Notes",
  CellTags->{"S1.1008", "Experimental`$EqualTolerance"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["$MachineEpsilon",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1008", "Experimental`$EqualTolerance"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`$SameQTolerance", "ObjectName",
  CellTags->{"S1.1009", "Experimental`$SameQTolerance"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$SameQTolerance", "MR"],
  " gives the number of decimal digits by which two numbers can disagree and \
still be considered the same according to ",
  StyleBox["SameQ", "MR"],
  ". "
}], "Usage",
  CellTags->{"S1.1009", "Experimental`$SameQTolerance"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is equal to ",
  StyleBox["Log[10,", "MR"],
  " ",
  StyleBox["2]", "MR"],
  ", corresponding to a tolerance of one binary digit. "
}], "Notes",
  CellTags->{"S1.1009", "Experimental`$SameQTolerance"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["$MachineEpsilon",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1009", "Experimental`$SameQTolerance"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 184}, {Automatic, 59}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.15.0"->{
    Cell[1776, 53, 181, 6, 91, "Section",
      CellTags->{"SA.15.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 181, 6, 91, "Section",
      CellTags->{"SA.15.0", "0.1"}]},
  "SA.15.1"->{
    Cell[1982, 63, 73, 1, 70, "Subsection",
      CellTags->{"SA.15.1", "1.1"}],
    Cell[2058, 66, 256, 7, 70, "Text",
      CellTags->{"SA.15.1", "1.2"}],
    Cell[2317, 75, 785, 23, 70, "DefinitionBox",
      CellTags->"SA.15.1"],
    Cell[3105, 100, 141, 5, 70, "Caption",
      CellTags->"SA.15.1"],
    Cell[3249, 107, 586, 19, 70, "Text",
      CellTags->{"SA.15.1", "1.3"}]},
  "1.1"->{
    Cell[1982, 63, 73, 1, 70, "Subsection",
      CellTags->{"SA.15.1", "1.1"}]},
  "1.2"->{
    Cell[2058, 66, 256, 7, 70, "Text",
      CellTags->{"SA.15.1", "1.2"}]},
  "1.3"->{
    Cell[3249, 107, 586, 19, 70, "Text",
      CellTags->{"SA.15.1", "1.3"}]},
  "S1.1001"->{
    Cell[3860, 130, 107, 1, 70, "ObjectName",
      CellTags->{"S1.1001", "Experimental`CompileEvaluate"}],
    Cell[3970, 133, 295, 9, 70, "Usage",
      CellTags->{"S1.1001", "Experimental`CompileEvaluate"}],
    Cell[4268, 144, 395, 10, 70, "Notes",
      CellTags->{"S1.1001", "Experimental`CompileEvaluate"}],
    Cell[4666, 156, 186, 6, 70, "Notes",
      CellTags->{"S1.1001", "Experimental`CompileEvaluate"}]},
  "Experimental`CompileEvaluate"->{
    Cell[3860, 130, 107, 1, 70, "ObjectName",
      CellTags->{"S1.1001", "Experimental`CompileEvaluate"}],
    Cell[3970, 133, 295, 9, 70, "Usage",
      CellTags->{"S1.1001", "Experimental`CompileEvaluate"}],
    Cell[4268, 144, 395, 10, 70, "Notes",
      CellTags->{"S1.1001", "Experimental`CompileEvaluate"}],
    Cell[4666, 156, 186, 6, 70, "Notes",
      CellTags->{"S1.1001", "Experimental`CompileEvaluate"}]},
  "S1.1002"->{
    Cell[4889, 167, 99, 1, 70, "ObjectName",
      CellTags->{"S1.1002", "Experimental`ExistsRealQ"}],
    Cell[4991, 170, 934, 36, 70, "Usage",
      CellTags->{"S1.1002", "Experimental`ExistsRealQ"}],
    Cell[5928, 208, 475, 18, 70, "Notes",
      CellTags->{"S1.1002", "Experimental`ExistsRealQ"}],
    Cell[6428, 230, 95, 1, 70, "ExampleSection",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
    Cell[6526, 233, 492, 14, 70, "ExampleText",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
    Cell[7043, 251, 247, 6, 70, "Input",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
    Cell[7293, 259, 117, 3, 70, "Output",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
    Cell[7425, 265, 206, 6, 70, "ExampleText",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
    Cell[7656, 275, 252, 6, 70, "Input",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
    Cell[7911, 283, 151, 3, 70, "Output",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}]},
  "Experimental`ExistsRealQ"->{
    Cell[4889, 167, 99, 1, 70, "ObjectName",
      CellTags->{"S1.1002", "Experimental`ExistsRealQ"}],
    Cell[4991, 170, 934, 36, 70, "Usage",
      CellTags->{"S1.1002", "Experimental`ExistsRealQ"}],
    Cell[5928, 208, 475, 18, 70, "Notes",
      CellTags->{"S1.1002", "Experimental`ExistsRealQ"}],
    Cell[6428, 230, 95, 1, 70, "ExampleSection",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
    Cell[6526, 233, 492, 14, 70, "ExampleText",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
    Cell[7043, 251, 247, 6, 70, "Input",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
    Cell[7293, 259, 117, 3, 70, "Output",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
    Cell[7425, 265, 206, 6, 70, "ExampleText",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
    Cell[7656, 275, 252, 6, 70, "Input",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
    Cell[7911, 283, 151, 3, 70, "Output",
      CellTags->{"Experimental`ExistsRealQ", "S1.1002"}]},
  "S1.1003"->{
    Cell[8123, 293, 97, 1, 70, "ObjectName",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[8223, 296, 229, 7, 70, "Usage",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[8455, 305, 203, 5, 70, "Notes",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[8661, 312, 262, 7, 70, "Notes",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[8926, 321, 348, 11, 70, "Notes",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[9277, 334, 210, 5, 70, "Notes",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[9490, 341, 195, 5, 70, "Notes",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[9688, 348, 305, 12, 70, "Notes",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}]},
  "Experimental`FileBrowse"->{
    Cell[8123, 293, 97, 1, 70, "ObjectName",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[8223, 296, 229, 7, 70, "Usage",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[8455, 305, 203, 5, 70, "Notes",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[8661, 312, 262, 7, 70, "Notes",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[8926, 321, 348, 11, 70, "Notes",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[9277, 334, 210, 5, 70, "Notes",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[9490, 341, 195, 5, 70, "Notes",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}],
    Cell[9688, 348, 305, 12, 70, "Notes",
      CellTags->{"S1.1003", "Experimental`FileBrowse"}]},
  "S1.1004"->{
    Cell[10030, 365, 99, 1, 70, "ObjectName",
      CellTags->{"S1.1004", "Experimental`ForAllRealQ"}],
    Cell[10132, 368, 920, 36, 70, "Usage",
      CellTags->{"S1.1004", "Experimental`ForAllRealQ"}],
    Cell[11055, 406, 407, 15, 70, "Notes",
      CellTags->{"S1.1004", "Experimental`ForAllRealQ"}],
    Cell[11487, 425, 95, 1, 70, "ExampleSection",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[11585, 428, 117, 1, 70, "ExampleText",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[11705, 431, 202, 5, 70, "Input",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[11910, 438, 293, 6, 70, "Input",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[12228, 448, 173, 4, 70, "Input",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[12404, 454, 116, 3, 70, "Output",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[12535, 460, 697, 25, 70, "ExampleText",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[13257, 489, 232, 5, 70, "Input",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[13492, 496, 116, 3, 70, "Output",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[13645, 504, 219, 5, 70, "Input",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[13867, 511, 151, 3, 70, "Output",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[14033, 517, 132, 3, 70, "Input",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}]},
  "Experimental`ForAllRealQ"->{
    Cell[10030, 365, 99, 1, 70, "ObjectName",
      CellTags->{"S1.1004", "Experimental`ForAllRealQ"}],
    Cell[10132, 368, 920, 36, 70, "Usage",
      CellTags->{"S1.1004", "Experimental`ForAllRealQ"}],
    Cell[11055, 406, 407, 15, 70, "Notes",
      CellTags->{"S1.1004", "Experimental`ForAllRealQ"}],
    Cell[11487, 425, 95, 1, 70, "ExampleSection",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[11585, 428, 117, 1, 70, "ExampleText",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[11705, 431, 202, 5, 70, "Input",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[11910, 438, 293, 6, 70, "Input",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[12228, 448, 173, 4, 70, "Input",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[12404, 454, 116, 3, 70, "Output",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[12535, 460, 697, 25, 70, "ExampleText",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[13257, 489, 232, 5, 70, "Input",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[13492, 496, 116, 3, 70, "Output",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[13645, 504, 219, 5, 70, "Input",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[13867, 511, 151, 3, 70, "Output",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
    Cell[14033, 517, 132, 3, 70, "Input",
      CellTags->{"Experimental`ForAllRealQ", "S1.1004"}]},
  "S1.1005"->{
    Cell[14214, 526, 93, 1, 70, "ObjectName",
      CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
    Cell[14310, 529, 815, 30, 70, "Usage",
      CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
    Cell[15128, 561, 577, 19, 70, "Notes",
      CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
    Cell[15708, 582, 869, 30, 70, "Notes",
      CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
    Cell[16580, 614, 319, 12, 70, "Notes",
      CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
    Cell[16924, 630, 92, 1, 70, "ExampleSection",
      CellTags->{"Experimental`ImpliesQ", "S1.1005"}],
    Cell[17019, 633, 173, 5, 70, "ExampleText",
      CellTags->{"Experimental`ImpliesQ", "S1.1005"}],
    Cell[17217, 642, 386, 8, 70, "Input",
      CellTags->{"Experimental`ImpliesQ", "S1.1005"}],
    Cell[17606, 652, 113, 3, 70, "Output",
      CellTags->{"Experimental`ImpliesQ", "S1.1005"}]},
  "Experimental`ImpliesQ"->{
    Cell[14214, 526, 93, 1, 70, "ObjectName",
      CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
    Cell[14310, 529, 815, 30, 70, "Usage",
      CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
    Cell[15128, 561, 577, 19, 70, "Notes",
      CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
    Cell[15708, 582, 869, 30, 70, "Notes",
      CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
    Cell[16580, 614, 319, 12, 70, "Notes",
      CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
    Cell[16924, 630, 92, 1, 70, "ExampleSection",
      CellTags->{"Experimental`ImpliesQ", "S1.1005"}],
    Cell[17019, 633, 173, 5, 70, "ExampleText",
      CellTags->{"Experimental`ImpliesQ", "S1.1005"}],
    Cell[17217, 642, 386, 8, 70, "Input",
      CellTags->{"Experimental`ImpliesQ", "S1.1005"}],
    Cell[17606, 652, 113, 3, 70, "Output",
      CellTags->{"Experimental`ImpliesQ", "S1.1005"}]},
  "S1.1006"->{
    Cell[17780, 662, 101, 1, 38, "ObjectName",
      CellTags->{"S1.1006", "Experimental`ImpliesRealQ"}],
    Cell[17884, 665, 882, 30, 70, "Usage",
      CellTags->{"S1.1006", "Experimental`ImpliesRealQ"}],
    Cell[18769, 697, 404, 15, 40, "Notes",
      CellTags->{"S1.1006", "Experimental`ImpliesRealQ"}],
    Cell[19198, 716, 96, 1, 38, "ExampleSection",
      CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}],
    Cell[19297, 719, 251, 5, 70, "ExampleText",
      CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}],
    Cell[19573, 728, 495, 10, 70, "Input",
      CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}],
    Cell[20071, 740, 117, 3, 70, "Output",
      CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}]},
  "Experimental`ImpliesRealQ"->{
    Cell[17780, 662, 101, 1, 38, "ObjectName",
      CellTags->{"S1.1006", "Experimental`ImpliesRealQ"}],
    Cell[17884, 665, 882, 30, 70, "Usage",
      CellTags->{"S1.1006", "Experimental`ImpliesRealQ"}],
    Cell[18769, 697, 404, 15, 40, "Notes",
      CellTags->{"S1.1006", "Experimental`ImpliesRealQ"}],
    Cell[19198, 716, 96, 1, 38, "ExampleSection",
      CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}],
    Cell[19297, 719, 251, 5, 70, "ExampleText",
      CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}],
    Cell[19573, 728, 495, 10, 70, "Input",
      CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}],
    Cell[20071, 740, 117, 3, 70, "Output",
      CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}]},
  "S1.1007"->{
    Cell[20249, 750, 103, 1, 38, "ObjectName",
      CellTags->{"S1.1007", "Experimental`ValueFunction"}],
    Cell[20355, 753, 309, 9, 48, "Usage",
      CellTags->{"S1.1007", "Experimental`ValueFunction"}],
    Cell[20667, 764, 576, 23, 40, "Notes",
      CellTags->{"S1.1007", "Experimental`ValueFunction"}],
    Cell[21246, 789, 286, 10, 24, "Notes",
      CellTags->{"S1.1007", "Experimental`ValueFunction"}],
    Cell[21535, 801, 264, 8, 40, "Notes",
      CellTags->{"S1.1007", "Experimental`ValueFunction"}],
    Cell[21802, 811, 182, 6, 24, "Notes",
      CellTags->{"S1.1007", "Experimental`ValueFunction"}]},
  "Experimental`ValueFunction"->{
    Cell[20249, 750, 103, 1, 38, "ObjectName",
      CellTags->{"S1.1007", "Experimental`ValueFunction"}],
    Cell[20355, 753, 309, 9, 48, "Usage",
      CellTags->{"S1.1007", "Experimental`ValueFunction"}],
    Cell[20667, 764, 576, 23, 40, "Notes",
      CellTags->{"S1.1007", "Experimental`ValueFunction"}],
    Cell[21246, 789, 286, 10, 24, "Notes",
      CellTags->{"S1.1007", "Experimental`ValueFunction"}],
    Cell[21535, 801, 264, 8, 40, "Notes",
      CellTags->{"S1.1007", "Experimental`ValueFunction"}],
    Cell[21802, 811, 182, 6, 24, "Notes",
      CellTags->{"S1.1007", "Experimental`ValueFunction"}]},
  "S1.1008"->{
    Cell[22021, 822, 107, 1, 38, "ObjectName",
      CellTags->{"S1.1008", "Experimental`$EqualTolerance"}],
    Cell[22131, 825, 304, 8, 48, "Usage",
      CellTags->{"S1.1008", "Experimental`$EqualTolerance"}],
    Cell[22438, 835, 262, 7, 40, "Notes",
      CellTags->{"S1.1008", "Experimental`$EqualTolerance"}],
    Cell[22703, 844, 194, 6, 24, "Notes",
      CellTags->{"S1.1008", "Experimental`$EqualTolerance"}]},
  "Experimental`$EqualTolerance"->{
    Cell[22021, 822, 107, 1, 38, "ObjectName",
      CellTags->{"S1.1008", "Experimental`$EqualTolerance"}],
    Cell[22131, 825, 304, 8, 48, "Usage",
      CellTags->{"S1.1008", "Experimental`$EqualTolerance"}],
    Cell[22438, 835, 262, 7, 40, "Notes",
      CellTags->{"S1.1008", "Experimental`$EqualTolerance"}],
    Cell[22703, 844, 194, 6, 24, "Notes",
      CellTags->{"S1.1008", "Experimental`$EqualTolerance"}]},
  "S1.1009"->{
    Cell[22934, 855, 107, 1, 38, "ObjectName",
      CellTags->{"S1.1009", "Experimental`$SameQTolerance"}],
    Cell[23044, 858, 307, 8, 48, "Usage",
      CellTags->{"S1.1009", "Experimental`$SameQTolerance"}],
    Cell[23354, 868, 261, 7, 40, "Notes",
      CellTags->{"S1.1009", "Experimental`$SameQTolerance"}],
    Cell[23618, 877, 194, 6, 24, "Notes",
      CellTags->{"S1.1009", "Experimental`$SameQTolerance"}]},
  "Experimental`$SameQTolerance"->{
    Cell[22934, 855, 107, 1, 38, "ObjectName",
      CellTags->{"S1.1009", "Experimental`$SameQTolerance"}],
    Cell[23044, 858, 307, 8, 48, "Usage",
      CellTags->{"S1.1009", "Experimental`$SameQTolerance"}],
    Cell[23354, 868, 261, 7, 40, "Notes",
      CellTags->{"S1.1009", "Experimental`$SameQTolerance"}],
    Cell[23618, 877, 194, 6, 24, "Notes",
      CellTags->{"S1.1009", "Experimental`$SameQTolerance"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.15.0", 24468, 904},
  {"0.1", 24559, 907},
  {"SA.15.1", 24654, 910},
  {"1.1", 25049, 921},
  {"1.2", 25142, 924},
  {"1.3", 25230, 927},
  {"S1.1001", 25324, 930},
  {"Experimental`CompileEvaluate", 25779, 939},
  {"S1.1002", 26213, 948},
  {"Experimental`ExistsRealQ", 27265, 969},
  {"S1.1003", 28300, 990},
  {"Experimental`FileBrowse", 29122, 1007},
  {"S1.1004", 29928, 1024},
  {"Experimental`ForAllRealQ", 31491, 1055},
  {"S1.1005", 33037, 1086},
  {"Experimental`ImpliesQ", 33963, 1105},
  {"S1.1006", 34875, 1124},
  {"Experimental`ImpliesRealQ", 35639, 1139},
  {"S1.1007", 36385, 1154},
  {"Experimental`ValueFunction", 37039, 1167},
  {"S1.1008", 37674, 1180},
  {"Experimental`$EqualTolerance", 38132, 1189},
  {"S1.1009", 38569, 1198},
  {"Experimental`$SameQTolerance", 39027, 1207}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 181, 6, 91, "Section",
  CellTags->{"SA.15.0", "0.1"}],

Cell[CellGroupData[{
Cell[1982, 63, 73, 1, 70, "Subsection",
  CellTags->{"SA.15.1", "1.1"}],
Cell[2058, 66, 256, 7, 70, "Text",
  CellTags->{"SA.15.1", "1.2"}],
Cell[2317, 75, 785, 23, 70, "DefinitionBox",
  CellTags->"SA.15.1"],
Cell[3105, 100, 141, 5, 70, "Caption",
  CellTags->"SA.15.1"],
Cell[3249, 107, 586, 19, 70, "Text",
  CellTags->{"SA.15.1", "1.3"}],

Cell[CellGroupData[{
Cell[3860, 130, 107, 1, 70, "ObjectName",
  CellTags->{"S1.1001", "Experimental`CompileEvaluate"}],
Cell[3970, 133, 295, 9, 70, "Usage",
  CellTags->{"S1.1001", "Experimental`CompileEvaluate"}],
Cell[4268, 144, 395, 10, 70, "Notes",
  CellTags->{"S1.1001", "Experimental`CompileEvaluate"}],
Cell[4666, 156, 186, 6, 70, "Notes",
  CellTags->{"S1.1001", "Experimental`CompileEvaluate"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[4889, 167, 99, 1, 70, "ObjectName",
  CellTags->{"S1.1002", "Experimental`ExistsRealQ"}],
Cell[4991, 170, 934, 36, 70, "Usage",
  CellTags->{"S1.1002", "Experimental`ExistsRealQ"}],
Cell[5928, 208, 475, 18, 70, "Notes",
  CellTags->{"S1.1002", "Experimental`ExistsRealQ"}],

Cell[CellGroupData[{
Cell[6428, 230, 95, 1, 70, "ExampleSection",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
Cell[6526, 233, 492, 14, 70, "ExampleText",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],

Cell[CellGroupData[{
Cell[7043, 251, 247, 6, 70, "Input",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
Cell[7293, 259, 117, 3, 70, "Output",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}]
}, Open  ]],
Cell[7425, 265, 206, 6, 70, "ExampleText",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],

Cell[CellGroupData[{
Cell[7656, 275, 252, 6, 70, "Input",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}],
Cell[7911, 283, 151, 3, 70, "Output",
  CellTags->{"Experimental`ExistsRealQ", "S1.1002"}]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8123, 293, 97, 1, 70, "ObjectName",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],
Cell[8223, 296, 229, 7, 70, "Usage",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],
Cell[8455, 305, 203, 5, 70, "Notes",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],
Cell[8661, 312, 262, 7, 70, "Notes",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],
Cell[8926, 321, 348, 11, 70, "Notes",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],
Cell[9277, 334, 210, 5, 70, "Notes",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],
Cell[9490, 341, 195, 5, 70, "Notes",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}],
Cell[9688, 348, 305, 12, 70, "Notes",
  CellTags->{"S1.1003", "Experimental`FileBrowse"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[10030, 365, 99, 1, 70, "ObjectName",
  CellTags->{"S1.1004", "Experimental`ForAllRealQ"}],
Cell[10132, 368, 920, 36, 70, "Usage",
  CellTags->{"S1.1004", "Experimental`ForAllRealQ"}],
Cell[11055, 406, 407, 15, 70, "Notes",
  CellTags->{"S1.1004", "Experimental`ForAllRealQ"}],

Cell[CellGroupData[{
Cell[11487, 425, 95, 1, 70, "ExampleSection",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
Cell[11585, 428, 117, 1, 70, "ExampleText",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
Cell[11705, 431, 202, 5, 70, "Input",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
Cell[11910, 438, 293, 6, 70, "Input",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],

Cell[CellGroupData[{
Cell[12228, 448, 173, 4, 70, "Input",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
Cell[12404, 454, 116, 3, 70, "Output",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}]
}, Open  ]],
Cell[12535, 460, 697, 25, 70, "ExampleText",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],

Cell[CellGroupData[{
Cell[13257, 489, 232, 5, 70, "Input",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
Cell[13492, 496, 116, 3, 70, "Output",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13645, 504, 219, 5, 70, "Input",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}],
Cell[13867, 511, 151, 3, 70, "Output",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}]
}, Open  ]],
Cell[14033, 517, 132, 3, 70, "Input",
  CellTags->{"Experimental`ForAllRealQ", "S1.1004"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14214, 526, 93, 1, 70, "ObjectName",
  CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
Cell[14310, 529, 815, 30, 70, "Usage",
  CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
Cell[15128, 561, 577, 19, 70, "Notes",
  CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
Cell[15708, 582, 869, 30, 70, "Notes",
  CellTags->{"S1.1005", "Experimental`ImpliesQ"}],
Cell[16580, 614, 319, 12, 70, "Notes",
  CellTags->{"S1.1005", "Experimental`ImpliesQ"}],

Cell[CellGroupData[{
Cell[16924, 630, 92, 1, 70, "ExampleSection",
  CellTags->{"Experimental`ImpliesQ", "S1.1005"}],
Cell[17019, 633, 173, 5, 70, "ExampleText",
  CellTags->{"Experimental`ImpliesQ", "S1.1005"}],

Cell[CellGroupData[{
Cell[17217, 642, 386, 8, 70, "Input",
  CellTags->{"Experimental`ImpliesQ", "S1.1005"}],
Cell[17606, 652, 113, 3, 70, "Output",
  CellTags->{"Experimental`ImpliesQ", "S1.1005"}]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17780, 662, 101, 1, 38, "ObjectName",
  CellTags->{"S1.1006", "Experimental`ImpliesRealQ"}],
Cell[17884, 665, 882, 30, 70, "Usage",
  CellTags->{"S1.1006", "Experimental`ImpliesRealQ"}],
Cell[18769, 697, 404, 15, 40, "Notes",
  CellTags->{"S1.1006", "Experimental`ImpliesRealQ"}],

Cell[CellGroupData[{
Cell[19198, 716, 96, 1, 38, "ExampleSection",
  CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}],
Cell[19297, 719, 251, 5, 70, "ExampleText",
  CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}],

Cell[CellGroupData[{
Cell[19573, 728, 495, 10, 70, "Input",
  CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}],
Cell[20071, 740, 117, 3, 70, "Output",
  CellTags->{"Experimental`ImpliesRealQ", "S1.1006"}]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[20249, 750, 103, 1, 38, "ObjectName",
  CellTags->{"S1.1007", "Experimental`ValueFunction"}],
Cell[20355, 753, 309, 9, 48, "Usage",
  CellTags->{"S1.1007", "Experimental`ValueFunction"}],
Cell[20667, 764, 576, 23, 40, "Notes",
  CellTags->{"S1.1007", "Experimental`ValueFunction"}],
Cell[21246, 789, 286, 10, 24, "Notes",
  CellTags->{"S1.1007", "Experimental`ValueFunction"}],
Cell[21535, 801, 264, 8, 40, "Notes",
  CellTags->{"S1.1007", "Experimental`ValueFunction"}],
Cell[21802, 811, 182, 6, 24, "Notes",
  CellTags->{"S1.1007", "Experimental`ValueFunction"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22021, 822, 107, 1, 38, "ObjectName",
  CellTags->{"S1.1008", "Experimental`$EqualTolerance"}],
Cell[22131, 825, 304, 8, 48, "Usage",
  CellTags->{"S1.1008", "Experimental`$EqualTolerance"}],
Cell[22438, 835, 262, 7, 40, "Notes",
  CellTags->{"S1.1008", "Experimental`$EqualTolerance"}],
Cell[22703, 844, 194, 6, 24, "Notes",
  CellTags->{"S1.1008", "Experimental`$EqualTolerance"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22934, 855, 107, 1, 38, "ObjectName",
  CellTags->{"S1.1009", "Experimental`$SameQTolerance"}],
Cell[23044, 858, 307, 8, 48, "Usage",
  CellTags->{"S1.1009", "Experimental`$SameQTolerance"}],
Cell[23354, 868, 261, 7, 40, "Notes",
  CellTags->{"S1.1009", "Experimental`$SameQTolerance"}],
Cell[23618, 877, 194, 6, 24, "Notes",
  CellTags->{"S1.1009", "Experimental`$SameQTolerance"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

