(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     80508,       2736]*)
(*NotebookOutlinePosition[    101440,       3317]*)
(*  CellTagsIndexPosition[     99941,       3254]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Front Matter", "ContentsTitle",
  CellTags->"C0"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["About the Author ",
    ButtonData:>{"0.1.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["About ",
    ButtonData:>{"0.2.1", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"0.2.1", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" ",
    ButtonData:>{"0.2.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["New in Version 5 ",
    ButtonData:>{"0.3.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["New in Version 5.1 ",
    ButtonData:>{"0.4.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["New in Version 5.2 ",
    ButtonData:>{"0.5.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["The Role of This Book ",
    ButtonData:>{"0.6.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["Suggestions about Learning ",
    ButtonData:>{"0.7.1", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"0.7.1", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" ",
    ButtonData:>{"0.7.1", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->"C0"],

Cell[TextData[{
  "Tour of ",
  StyleBox["Mathematica", "SBO"]
}], "ContentsTitle",
  CellTags->"CT"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Contents ",
  ButtonData:>{"T.0", None},
  ButtonStyle->"MainBookLink"]], "Contents",
  CellTags->"CT"],

Cell[TextData[{
  "A Practical Introduction to ",
  StyleBox["Mathematica", "SBO"]
}], "ContentsTitle",
  CellTags->"C1"]
}, Open  ]],

Cell[TextData[ButtonBox["Introduction ",
  ButtonData:>{"I1", None},
  ButtonStyle->"MainBookLink"]], "Contents",
  CellTags->"C1"],

Cell[CellGroupData[{

Cell[TextData[{
  "Running ",
  StyleBox["Mathematica", "SBO"]
}], "ContentsSection",
  CellTags->{"C1", "C1.0"}],

Cell[TextData[{
  ButtonBox["Introduction ",
    ButtonData:>{"1.0.0", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.0.1    Notebook Interfaces ",
    ButtonData:>{"1.0.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.0.2    Text\[Hyphen]Based Interfaces ",
    ButtonData:>{"1.0.2", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C1", "C1.0"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Calculations", "ContentsSection",
  CellTags->{"C1", "C1.1"}],

Cell[TextData[{
  ButtonBox["1.1.1    Arithmetic ",
    ButtonData:>{"1.1.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.1.2    Exact and Approximate Results ",
    ButtonData:>{"1.1.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.1.3    Some Mathematical Functions ",
    ButtonData:>{"1.1.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.1.4    Arbitrary\[Hyphen]Precision Calculations ",
    ButtonData:>{"1.1.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.1.5    Complex Numbers ",
    ButtonData:>{"1.1.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.1.6    Getting Used to ",
    ButtonData:>{"1.1.6", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"1.1.6", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" ",
    ButtonData:>{"1.1.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.1.7    Mathematical Notation in Notebooks ",
    ButtonData:>{"1.1.7", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C1", "C1.1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Building Up Calculations", "ContentsSection",
  CellTags->{"C1", "C1.2"}],

Cell[TextData[{
  ButtonBox["1.2.1    Using Previous Results ",
    ButtonData:>{"1.2.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.2.2    Defining Variables ",
    ButtonData:>{"1.2.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.2.3    Making Lists of Objects ",
    ButtonData:>{"1.2.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.2.4    Manipulating Elements of Lists ",
    ButtonData:>{"1.2.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.2.5    The Four Kinds of Bracketing in ",
    ButtonData:>{"1.2.5", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"1.2.5", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" ",
    ButtonData:>{"1.2.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.2.6    Sequences of Operations ",
    ButtonData:>{"1.2.6", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C1", "C1.2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Using the ",
  StyleBox["Mathematica", "SBO"],
  " System"
}], "ContentsSection",
  CellTags->{"C1", "C1.3"}],

Cell[TextData[{
  ButtonBox["1.3.1    The Structure of ",
    ButtonData:>{"1.3.1", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"1.3.1", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" ",
    ButtonData:>{"1.3.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.3.2    Differences between Computer Systems ",
    ButtonData:>{"1.3.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.3.3    Special Topic: Using a Text\[Hyphen]Based Interface ",
    ButtonData:>{"1.3.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.3.4    Doing Computations in Notebooks ",
    ButtonData:>{"1.3.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.3.5    Notebooks as Documents ",
    ButtonData:>{"1.3.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.3.6    Active Elements in Notebooks ",
    ButtonData:>{"1.3.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.3.7    Special Topic: Hyperlinks and Active Text ",
    ButtonData:>{"1.3.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.3.8    Getting Help in the Notebook Front End ",
    ButtonData:>{"1.3.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.3.9    Getting Help with a Text\[Hyphen]Based Interface ",
    ButtonData:>{"1.3.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.3.10    ",
    ButtonData:>{"1.3.10", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"1.3.10", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Packages ",
    ButtonData:>{"1.3.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.3.11    Warnings and Messages ",
    ButtonData:>{"1.3.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.3.12    Interrupting Calculations ",
    ButtonData:>{"1.3.12", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C1", "C1.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebraic Calculations", "ContentsSection",
  CellTags->{"C1", "C1.4"}],

Cell[TextData[{
  ButtonBox["1.4.1    Symbolic Computation ",
    ButtonData:>{"1.4.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.4.2    Values for Symbols ",
    ButtonData:>{"1.4.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.4.3    Transforming Algebraic Expressions ",
    ButtonData:>{"1.4.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.4.4    Simplifying Algebraic Expressions ",
    ButtonData:>{"1.4.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.4.5    Advanced Topic: Putting Expressions into Different \
Forms ",
    ButtonData:>{"1.4.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.4.6    Advanced Topic: Simplifying with Assumptions ",
    ButtonData:>{"1.4.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.4.7    Picking Out Pieces of Algebraic Expressions ",
    ButtonData:>{"1.4.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.4.8    Controlling the Display of Large Expressions ",
    ButtonData:>{"1.4.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.4.9    The Limits of ",
    ButtonData:>{"1.4.9", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"1.4.9", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" ",
    ButtonData:>{"1.4.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.4.10    Using Symbols to Tag Objects ",
    ButtonData:>{"1.4.10", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C1", "C1.4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic Mathematics", "ContentsSection",
  CellTags->{"C1", "C1.5"}],

Cell[TextData[{
  ButtonBox["1.5.1    Basic Operations ",
    ButtonData:>{"1.5.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.2    Differentiation ",
    ButtonData:>{"1.5.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.3    Integration ",
    ButtonData:>{"1.5.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.4    Sums and Products ",
    ButtonData:>{"1.5.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.5    Equations ",
    ButtonData:>{"1.5.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.6    Relational and Logical Operators ",
    ButtonData:>{"1.5.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.7    Solving Equations ",
    ButtonData:>{"1.5.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.8    Inequalities ",
    ButtonData:>{"1.5.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.9    Differential Equations ",
    ButtonData:>{"1.5.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.10    Power Series ",
    ButtonData:>{"1.5.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.11    Limits ",
    ButtonData:>{"1.5.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.12    Integral Transforms ",
    ButtonData:>{"1.5.12", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.13    Recurrence Equations ",
    ButtonData:>{"1.5.13", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.14    Packages for Symbolic Mathematics ",
    ButtonData:>{"1.5.14", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.15    Advanced Topic: Generic and Non\[Hyphen]Generic Cases \
",
    ButtonData:>{"1.5.15", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.5.16    Mathematical Notation in Notebooks ",
    ButtonData:>{"1.5.16", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C1", "C1.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Mathematics", "ContentsSection",
  CellTags->{"C1", "C1.6"}],

Cell[TextData[{
  ButtonBox["1.6.1    Basic Operations ",
    ButtonData:>{"1.6.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.6.2    Numerical Sums, Products and Integrals ",
    ButtonData:>{"1.6.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.6.3    Numerical Equation Solving ",
    ButtonData:>{"1.6.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.6.4    Numerical Differential Equations ",
    ButtonData:>{"1.6.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.6.5    Numerical Optimization ",
    ButtonData:>{"1.6.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.6.6    Manipulating Numerical Data ",
    ButtonData:>{"1.6.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.6.7    Statistics ",
    ButtonData:>{"1.6.7", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C1", "C1.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functions and Programs", "ContentsSection",
  CellTags->{"C1", "C1.7"}],

Cell[TextData[{
  ButtonBox["1.7.1    Defining Functions ",
    ButtonData:>{"1.7.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.7.2    Functions as Procedures ",
    ButtonData:>{"1.7.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.7.3    Repetitive Operations ",
    ButtonData:>{"1.7.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.7.4    Transformation Rules for Functions ",
    ButtonData:>{"1.7.4", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C1", "C1.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lists", "ContentsSection",
  CellTags->{"C1", "C1.8"}],

Cell[TextData[{
  ButtonBox["1.8.1    Collecting Objects Together ",
    ButtonData:>{"1.8.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.8.2    Making Tables of Values ",
    ButtonData:>{"1.8.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.8.3    Vectors and Matrices ",
    ButtonData:>{"1.8.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.8.4    Getting Pieces of Lists ",
    ButtonData:>{"1.8.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.8.5    Testing and Searching List Elements ",
    ButtonData:>{"1.8.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.8.6    Adding, Removing and Modifying List Elements ",
    ButtonData:>{"1.8.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.8.7    Combining Lists ",
    ButtonData:>{"1.8.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.8.8    Advanced Topic: Lists as Sets ",
    ButtonData:>{"1.8.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.8.9    Rearranging Lists ",
    ButtonData:>{"1.8.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.8.10    Grouping and Combining Elements of Lists ",
    ButtonData:>{"1.8.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.8.11    Ordering in Lists ",
    ButtonData:>{"1.8.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.8.12    Advanced Topic: Rearranging Nested Lists ",
    ButtonData:>{"1.8.12", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C1", "C1.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics and Sound", "ContentsSection",
  CellTags->{"C1", "C1.9"}],

Cell[TextData[{
  ButtonBox["1.9.1    Basic Plotting ",
    ButtonData:>{"1.9.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.9.2    Options ",
    ButtonData:>{"1.9.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.9.3    Redrawing and Combining Plots ",
    ButtonData:>{"1.9.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.9.4    Advanced Topic: Manipulating Options ",
    ButtonData:>{"1.9.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.9.5    Contour and Density Plots ",
    ButtonData:>{"1.9.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.9.6    Three\[Hyphen]Dimensional Surface Plots ",
    ButtonData:>{"1.9.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.9.7    Converting between Types of Graphics ",
    ButtonData:>{"1.9.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.9.8    Plotting Lists of Data ",
    ButtonData:>{"1.9.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.9.9    Parametric Plots ",
    ButtonData:>{"1.9.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.9.10    Some Special Plots ",
    ButtonData:>{"1.9.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.9.11    Special Topic: Animated Graphics ",
    ButtonData:>{"1.9.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.9.12    Sound ",
    ButtonData:>{"1.9.12", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C1", "C1.9"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input and Output in Notebooks", "ContentsSection",
  CellTags->{"C1", "C1.10"}],

Cell[TextData[{
  ButtonBox["1.10.1    Entering Greek Letters ",
    ButtonData:>{"1.10.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.2    Entering Two\[Hyphen]Dimensional Input ",
    ButtonData:>{"1.10.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.3    Editing and Evaluating Two\[Hyphen]Dimensional \
Expressions ",
    ButtonData:>{"1.10.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.4    Entering Formulas ",
    ButtonData:>{"1.10.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.5    Entering Tables and Matrices ",
    ButtonData:>{"1.10.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.6    Subscripts, Bars and Other Modifiers ",
    ButtonData:>{"1.10.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.7    Special Topic: Non\[Hyphen]English Characters and \
Keyboards ",
    ButtonData:>{"1.10.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.8    Other Mathematical Notation ",
    ButtonData:>{"1.10.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.9    Forms of Input and Output ",
    ButtonData:>{"1.10.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.10    Mixing Text and Formulas ",
    ButtonData:>{"1.10.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.11    Displaying and Printing ",
    ButtonData:>{"1.10.11", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"1.10.11", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Notebooks ",
    ButtonData:>{"1.10.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.12    Creating Your Own Palettes ",
    ButtonData:>{"1.10.12", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.13    Setting Up Hyperlinks ",
    ButtonData:>{"1.10.13", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.14    Automatic Numbering ",
    ButtonData:>{"1.10.14", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.10.15    Exposition in ",
    ButtonData:>{"1.10.15", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"1.10.15", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Notebooks ",
    ButtonData:>{"1.10.15", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C1", "C1.10"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Files and External Operations", "ContentsSection",
  CellTags->{"C1", "C1.11"}],

Cell[TextData[{
  ButtonBox["1.11.1    Reading and Writing ",
    ButtonData:>{"1.11.1", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"1.11.1", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Files ",
    ButtonData:>{"1.11.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.11.2    Advanced Topic: Finding and Manipulating Files ",
    ButtonData:>{"1.11.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.11.3    Importing and Exporting Data ",
    ButtonData:>{"1.11.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.11.4    Exporting Graphics and Sounds ",
    ButtonData:>{"1.11.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.11.5    Exporting Formulas from Notebooks ",
    ButtonData:>{"1.11.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.11.6    Generating and Importing TeX ",
    ButtonData:>{"1.11.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.11.7    Exchanging Material with the Web ",
    ButtonData:>{"1.11.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.11.8    Generating C and Fortran Expressions ",
    ButtonData:>{"1.11.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.11.9    Splicing ",
    ButtonData:>{"1.11.9", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"1.11.9", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Output into External Files ",
    ButtonData:>{"1.11.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.11.10    Running External Programs ",
    ButtonData:>{"1.11.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.11.11    ",
    ButtonData:>{"1.11.11", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>{"1.11.11", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" ",
    ButtonData:>{"1.11.11", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C1", "C1.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Special Topic: The Internals of ",
  StyleBox["Mathematica", "SBO"]
}], "ContentsSection",
  CellTags->{"C1", "C1.12"}],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["1.12.1    Why You Do Not Usually Need to Know about Internals ",
    ButtonData:>{"1.12.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.12.2    Basic Internal Architecture ",
    ButtonData:>{"1.12.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.12.3    The Algorithms of ",
    ButtonData:>{"1.12.3", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"1.12.3", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" ",
    ButtonData:>{"1.12.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.12.4    The Software Engineering of ",
    ButtonData:>{"1.12.4", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"1.12.4", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" ",
    ButtonData:>{"1.12.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["1.12.5    Testing and Verification ",
    ButtonData:>{"1.12.5", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C1", "C1.12"}],

Cell[TextData[{
  "Principles of ",
  StyleBox["Mathematica", "SBO"]
}], "ContentsTitle",
  CellTags->"C2"]
}, Open  ]],

Cell[TextData[ButtonBox["Introduction ",
  ButtonData:>{"I2", None},
  ButtonStyle->"MainBookLink"]], "Contents",
  CellTags->"C2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expressions", "ContentsSection",
  CellTags->{"C2", "C2.1"}],

Cell[TextData[{
  ButtonBox["2.1.1    Everything Is an Expression ",
    ButtonData:>{"2.1.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.1.2    The Meaning of Expressions ",
    ButtonData:>{"2.1.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.1.3    Special Ways to Input Expressions ",
    ButtonData:>{"2.1.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.1.4    Parts of Expressions ",
    ButtonData:>{"2.1.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.1.5    Manipulating Expressions like Lists ",
    ButtonData:>{"2.1.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.1.6    Expressions as Trees ",
    ButtonData:>{"2.1.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.1.7    Levels in Expressions ",
    ButtonData:>{"2.1.7", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functional Operations", "ContentsSection",
  CellTags->{"C2", "C2.2"}],

Cell[TextData[{
  ButtonBox["2.2.1    Function Names as Expressions ",
    ButtonData:>{"2.2.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.2.2    Applying Functions Repeatedly ",
    ButtonData:>{"2.2.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.2.3    Applying Functions to Lists and Other Expressions ",
    ButtonData:>{"2.2.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.2.4    Applying Functions to Parts of Expressions ",
    ButtonData:>{"2.2.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.2.5    Pure Functions ",
    ButtonData:>{"2.2.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.2.6    Building Lists from Functions ",
    ButtonData:>{"2.2.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.2.7    Selecting Parts of Expressions with Functions ",
    ButtonData:>{"2.2.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.2.8    Expressions with Heads That Are Not Symbols ",
    ButtonData:>{"2.2.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.2.9    Advanced Topic: Working with Operators ",
    ButtonData:>{"2.2.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.2.10    Structural Operations ",
    ButtonData:>{"2.2.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.2.11    Sequences ",
    ButtonData:>{"2.2.11", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Patterns", "ContentsSection",
  CellTags->{"C2", "C2.3"}],

Cell[TextData[{
  ButtonBox["2.3.1    Introduction ",
    ButtonData:>{"2.3.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.3.2    Finding Expressions That Match a Pattern ",
    ButtonData:>{"2.3.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.3.3    Naming Pieces of Patterns ",
    ButtonData:>{"2.3.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.3.4    Specifying Types of Expression in Patterns ",
    ButtonData:>{"2.3.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.3.5    Putting Constraints on Patterns ",
    ButtonData:>{"2.3.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.3.6    Patterns Involving Alternatives ",
    ButtonData:>{"2.3.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.3.7    Flat and Orderless Functions ",
    ButtonData:>{"2.3.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.3.8    Functions with Variable Numbers of Arguments ",
    ButtonData:>{"2.3.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.3.9    Optional and Default Arguments ",
    ButtonData:>{"2.3.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.3.10    Setting Up Functions with Optional Arguments ",
    ButtonData:>{"2.3.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.3.11    Repeated Patterns ",
    ButtonData:>{"2.3.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.3.12    Verbatim Patterns ",
    ButtonData:>{"2.3.12", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.3.13    Patterns for Some Common Types of Expression ",
    ButtonData:>{"2.3.13", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.3.14    An Example: Defining Your Own Integration Function ",
    ButtonData:>{"2.3.14", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Manipulating Lists", "ContentsSection",
  CellTags->{"C2", "C2.4"}],

Cell[TextData[{
  ButtonBox["2.4.1    Constructing Lists ",
    ButtonData:>{"2.4.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.4.2    Manipulating Lists by Their Indices ",
    ButtonData:>{"2.4.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.4.3    Nested Lists ",
    ButtonData:>{"2.4.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.4.4    Partitioning and Padding Lists ",
    ButtonData:>{"2.4.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.4.5    Sparse Arrays ",
    ButtonData:>{"2.4.5", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transformation Rules and Definitions", "ContentsSection",
  CellTags->{"C2", "C2.5"}],

Cell[TextData[{
  ButtonBox["2.5.1    Applying Transformation Rules ",
    ButtonData:>{"2.5.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.5.2    Manipulating Sets of Transformation Rules ",
    ButtonData:>{"2.5.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.5.3    Making Definitions ",
    ButtonData:>{"2.5.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.5.4    Special Forms of Assignment ",
    ButtonData:>{"2.5.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.5.5    Making Definitions for Indexed Objects ",
    ButtonData:>{"2.5.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.5.6    Making Definitions for Functions ",
    ButtonData:>{"2.5.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.5.7    The Ordering of Definitions ",
    ButtonData:>{"2.5.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.5.8    Immediate and Delayed Definitions ",
    ButtonData:>{"2.5.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.5.9    Functions That Remember Values They Have Found ",
    ButtonData:>{"2.5.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.5.10    Associating Definitions with Different Symbols ",
    ButtonData:>{"2.5.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.5.11    Defining Numerical Values ",
    ButtonData:>{"2.5.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.5.12    Modifying Built\[Hyphen]in Functions ",
    ButtonData:>{"2.5.12", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.5.13    Advanced Topic: Manipulating Value Lists ",
    ButtonData:>{"2.5.13", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Evaluation of Expressions", "ContentsSection",
  CellTags->{"C2", "C2.6"}],

Cell[TextData[{
  ButtonBox["2.6.1    Principles of Evaluation ",
    ButtonData:>{"2.6.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.2    Reducing Expressions to Their Standard Form ",
    ButtonData:>{"2.6.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.3    Attributes ",
    ButtonData:>{"2.6.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.4    The Standard Evaluation Procedure ",
    ButtonData:>{"2.6.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.5    Non\[Hyphen]Standard Evaluation ",
    ButtonData:>{"2.6.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.6    Evaluation in Patterns, Rules and Definitions ",
    ButtonData:>{"2.6.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.7    Evaluation in Iteration Functions ",
    ButtonData:>{"2.6.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.8    Conditionals ",
    ButtonData:>{"2.6.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.9    Loops and Control Structures ",
    ButtonData:>{"2.6.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.10    Collecting Expressions During Evaluation ",
    ButtonData:>{"2.6.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.11    Advanced Topic: Tracing Evaluation ",
    ButtonData:>{"2.6.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.12    Advanced Topic: The Evaluation Stack ",
    ButtonData:>{"2.6.12", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.13    Advanced Topic: Controlling Infinite Evaluation ",
    ButtonData:>{"2.6.13", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.14    Advanced Topic: Interrupts and Aborts ",
    ButtonData:>{"2.6.14", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.15    Compiling ",
    ButtonData:>{"2.6.15", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"2.6.15", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Expressions ",
    ButtonData:>{"2.6.15", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.6.16    Advanced Topic: Manipulating Compiled Code ",
    ButtonData:>{"2.6.16", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modularity and the Naming of Things", "ContentsSection",
  CellTags->{"C2", "C2.7"}],

Cell[TextData[{
  ButtonBox["2.7.1    Modules and Local Variables ",
    ButtonData:>{"2.7.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.7.2    Local Constants ",
    ButtonData:>{"2.7.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.7.3    How Modules Work ",
    ButtonData:>{"2.7.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.7.4    Advanced Topic: Variables in Pure Functions and Rules ",
    
    ButtonData:>{"2.7.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.7.5    Dummy Variables in Mathematics ",
    ButtonData:>{"2.7.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.7.6    Blocks and Local Values ",
    ButtonData:>{"2.7.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.7.7    Blocks Compared with Modules ",
    ButtonData:>{"2.7.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.7.8    Contexts ",
    ButtonData:>{"2.7.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.7.9    Contexts and Packages ",
    ButtonData:>{"2.7.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.7.10    Setting Up ",
    ButtonData:>{"2.7.10", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"2.7.10", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Packages ",
    ButtonData:>{"2.7.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.7.11    Automatic Loading of Packages ",
    ButtonData:>{"2.7.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.7.12    Manipulating Symbols and Contexts by Name ",
    ButtonData:>{"2.7.12", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.7.13    Advanced Topic: Intercepting the Creation of New \
Symbols ",
    ButtonData:>{"2.7.13", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Strings and Characters", "ContentsSection",
  CellTags->{"C2", "C2.8"}],

Cell[TextData[{
  ButtonBox["2.8.1    Properties of Strings ",
    ButtonData:>{"2.8.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.8.2    Operations on Strings ",
    ButtonData:>{"2.8.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.8.3    Characters in Strings ",
    ButtonData:>{"2.8.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.8.4    String Patterns ",
    ButtonData:>{"2.8.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.8.5    Advanced Topic: Regular Expressions ",
    ButtonData:>{"2.8.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.8.6    Special Characters ",
    ButtonData:>{"2.8.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.8.7    Advanced Topic: Newlines and Tabs in Strings ",
    ButtonData:>{"2.8.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.8.8    Advanced Topic: Character Codes ",
    ButtonData:>{"2.8.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.8.9    Advanced Topic: Raw Character Encodings ",
    ButtonData:>{"2.8.9", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Textual Input and Output", "ContentsSection",
  CellTags->{"C2", "C2.9"}],

Cell[TextData[{
  ButtonBox["2.9.1    Forms of Input and Output ",
    ButtonData:>{"2.9.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.2    How Input and Output Work ",
    ButtonData:>{"2.9.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.3    The Representation of Textual Forms ",
    ButtonData:>{"2.9.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.4    The Interpretation of Textual Forms ",
    ButtonData:>{"2.9.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.5    Short and Shallow Output ",
    ButtonData:>{"2.9.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.6    String\[Hyphen]Oriented Output Formats ",
    ButtonData:>{"2.9.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.7    Output Formats for Numbers ",
    ButtonData:>{"2.9.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.8    Tables and Matrices ",
    ButtonData:>{"2.9.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.9    Styles and Fonts in Output ",
    ButtonData:>{"2.9.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.10    Representing Textual Forms by Boxes ",
    ButtonData:>{"2.9.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.11    Adjusting Details of Formatting ",
    ButtonData:>{"2.9.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.12    String Representation of Boxes ",
    ButtonData:>{"2.9.12", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.13    Converting between Strings, Boxes and Expressions ",
    ButtonData:>{"2.9.13", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.14    The Syntax of the ",
    ButtonData:>{"2.9.14", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"2.9.14", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Language ",
    ButtonData:>{"2.9.14", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.15    Operators without Built\[Hyphen]in Meanings ",
    ButtonData:>{"2.9.15", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.16    Defining Output Formats ",
    ButtonData:>{"2.9.16", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.17    Advanced Topic: Low\[Hyphen]Level Input and Output \
Rules ",
    ButtonData:>{"2.9.17", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.18    Generating Unstructured Output ",
    ButtonData:>{"2.9.18", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.19    Generating Styled Output in Notebooks ",
    ButtonData:>{"2.9.19", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.20    Requesting Input ",
    ButtonData:>{"2.9.20", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.21    Messages ",
    ButtonData:>{"2.9.21", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.22    International Messages ",
    ButtonData:>{"2.9.22", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.9.23    Documentation Constructs ",
    ButtonData:>{"2.9.23", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.9"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Structure of Graphics and Sound", "ContentsSection",
  CellTags->{"C2", "C2.10"}],

Cell[TextData[{
  ButtonBox["2.10.1    The Structure of Graphics ",
    ButtonData:>{"2.10.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.2    Two\[Hyphen]Dimensional Graphics Elements ",
    ButtonData:>{"2.10.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.3    Graphics Directives and Options ",
    ButtonData:>{"2.10.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.4    Coordinate Systems for Two\[Hyphen]Dimensional \
Graphics ",
    ButtonData:>{"2.10.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.5    Labeling Two\[Hyphen]Dimensional Graphics ",
    ButtonData:>{"2.10.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.6    Making Plots within Plots ",
    ButtonData:>{"2.10.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.7    Density and Contour Plots ",
    ButtonData:>{"2.10.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.8    Three\[Hyphen]Dimensional Graphics Primitives ",
    ButtonData:>{"2.10.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.9    Three\[Hyphen]Dimensional Graphics Directives ",
    ButtonData:>{"2.10.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.10    Coordinate Systems for Three\[Hyphen]Dimensional \
Graphics ",
    ButtonData:>{"2.10.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.11    Plotting Three\[Hyphen]Dimensional Surfaces ",
    ButtonData:>{"2.10.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.12    Lighting and Surface Properties ",
    ButtonData:>{"2.10.12", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.13    Labeling Three\[Hyphen]Dimensional Graphics ",
    ButtonData:>{"2.10.13", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.14    Advanced Topic: Low\[Hyphen]Level Graphics Rendering \
",
    ButtonData:>{"2.10.14", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.15    Formats for Text in Graphics ",
    ButtonData:>{"2.10.15", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.16    Graphics Primitives for Text ",
    ButtonData:>{"2.10.16", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.17    Advanced Topic: Color Output ",
    ButtonData:>{"2.10.17", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.18    The Representation of Sound ",
    ButtonData:>{"2.10.18", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.19    Exporting Graphics and Sounds ",
    ButtonData:>{"2.10.19", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.10.20    Importing Graphics and Sounds ",
    ButtonData:>{"2.10.20", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.10"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Manipulating Notebooks", "ContentsSection",
  CellTags->{"C2", "C2.11"}],

Cell[TextData[{
  ButtonBox["2.11.1    Cells as ",
    ButtonData:>{"2.11.1", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"2.11.1", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Expressions ",
    ButtonData:>{"2.11.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.11.2    Notebooks as ",
    ButtonData:>{"2.11.2", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"2.11.2", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Expressions ",
    ButtonData:>{"2.11.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.11.3    Manipulating Notebooks from the Kernel ",
    ButtonData:>{"2.11.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.11.4    Manipulating the Front End from the Kernel ",
    ButtonData:>{"2.11.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.11.5    Advanced Topic: Executing Notebook Commands Directly \
in the Front End ",
    ButtonData:>{"2.11.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.11.6    Button Boxes and Active Elements in Notebooks ",
    ButtonData:>{"2.11.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.11.7    Advanced Topic: The Structure of Cells ",
    ButtonData:>{"2.11.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.11.8    Styles and the Inheritance of Option Settings ",
    ButtonData:>{"2.11.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.11.9    Options for Cells ",
    ButtonData:>{"2.11.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.11.10    Text and Font Options ",
    ButtonData:>{"2.11.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.11.11    Advanced Topic: Options for Expression Input and \
Output ",
    ButtonData:>{"2.11.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.11.12    Options for Graphics Cells ",
    ButtonData:>{"2.11.12", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.11.13    Options for Notebooks ",
    ButtonData:>{"2.11.13", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.11.14    Advanced Topic: Global Options for the Front End ",
    ButtonData:>{"2.11.14", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Files and Streams", "ContentsSection",
  CellTags->{"C2", "C2.12"}],

Cell[TextData[{
  ButtonBox["2.12.1    Reading and Writing ",
    ButtonData:>{"2.12.1", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"2.12.1", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Files ",
    ButtonData:>{"2.12.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.12.2    External Programs ",
    ButtonData:>{"2.12.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.12.3    Advanced Topic: Streams and Low\[Hyphen]Level Input \
and Output ",
    ButtonData:>{"2.12.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.12.4    Naming and Finding Files ",
    ButtonData:>{"2.12.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.12.5    Files for Packages ",
    ButtonData:>{"2.12.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.12.6    Manipulating Files and Directories ",
    ButtonData:>{"2.12.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.12.7    Importing and Exporting Files ",
    ButtonData:>{"2.12.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.12.8    Reading Textual Data ",
    ButtonData:>{"2.12.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.12.9    Searching Files ",
    ButtonData:>{"2.12.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.12.10    Searching and Reading Strings ",
    ButtonData:>{"2.12.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.12.11    Advanced Topic: Binary Files ",
    ButtonData:>{"2.12.11", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.12"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["MathLink", "SBO"],
  " and External Program Communication"
}], "ContentsSection",
  CellTags->{"C2", "C2.13"}],

Cell[TextData[{
  ButtonBox["2.13.1    How ",
    ButtonData:>{"2.13.1", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>{"2.13.1", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Is Used ",
    ButtonData:>{"2.13.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.13.2    Installing Existing ",
    ButtonData:>{"2.13.2", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>{"2.13.2", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox["\[Hyphen]Compatible Programs ",
    ButtonData:>{"2.13.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.13.3    Setting Up External Functions to Be Called from ",
    ButtonData:>{"2.13.3", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"2.13.3", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" ",
    ButtonData:>{"2.13.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.13.4    Handling Lists, Arrays and Other Expressions ",
    ButtonData:>{"2.13.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.13.5    Special Topic: Portability of ",
    ButtonData:>{"2.13.5", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>{"2.13.5", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Programs ",
    ButtonData:>{"2.13.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.13.6    Using ",
    ButtonData:>{"2.13.6", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>{"2.13.6", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" to Communicate between ",
    ButtonData:>{"2.13.6", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"2.13.6", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Sessions ",
    ButtonData:>{"2.13.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.13.7    Calling Subsidiary ",
    ButtonData:>{"2.13.7", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"2.13.7", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Processes ",
    ButtonData:>{"2.13.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.13.8    Special Topic: Communication with ",
    ButtonData:>{"2.13.8", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"2.13.8", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Front Ends ",
    ButtonData:>{"2.13.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.13.9    Two\[Hyphen]Way Communication with External Programs ",
    
    ButtonData:>{"2.13.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.13.10    Special Topic: Running Programs on Remote Computers ",
    
    ButtonData:>{"2.13.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.13.11    Special Topic: Running External Programs under a \
Debugger ",
    ButtonData:>{"2.13.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.13.12    Manipulating Expressions in External Programs ",
    ButtonData:>{"2.13.12", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.13.13    Advanced Topic: Error and Interrupt Handling ",
    ButtonData:>{"2.13.13", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.13.14    Running ",
    ButtonData:>{"2.13.14", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"2.13.14", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" from Within an External Program ",
    ButtonData:>{"2.13.14", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Global Aspects of ",
  StyleBox["Mathematica", "SBO"],
  " Sessions"
}], "ContentsSection",
  CellTags->{"C2", "C2.14"}],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["2.14.1    The Main Loop ",
    ButtonData:>{"2.14.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.14.2    Dialogs ",
    ButtonData:>{"2.14.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.14.3    Date and Time Functions ",
    ButtonData:>{"2.14.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.14.4    Memory Management ",
    ButtonData:>{"2.14.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["2.14.5    Advanced Topic: Global System Information ",
    ButtonData:>{"2.14.5", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C2", "C2.14"}],

Cell[TextData[{
  "Advanced Mathematics in ",
  StyleBox["Mathematica", "SBO"]
}], "ContentsTitle",
  CellTags->"C3"]
}, Open  ]],

Cell[TextData[ButtonBox["Introduction ",
  ButtonData:>{"I3", None},
  ButtonStyle->"MainBookLink"]], "Contents",
  CellTags->"C3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numbers", "ContentsSection",
  CellTags->{"C3", "C3.1"}],

Cell[TextData[{
  ButtonBox["3.1.1    Types of Numbers ",
    ButtonData:>{"3.1.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.1.2    Numeric Quantities ",
    ButtonData:>{"3.1.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.1.3    Digits in Numbers ",
    ButtonData:>{"3.1.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.1.4    Numerical Precision ",
    ButtonData:>{"3.1.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.1.5    Arbitrary\[Hyphen]Precision Numbers ",
    ButtonData:>{"3.1.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.1.6    Machine\[Hyphen]Precision Numbers ",
    ButtonData:>{"3.1.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.1.7    Advanced Topic: Interval Arithmetic ",
    ButtonData:>{"3.1.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.1.8    Advanced Topic: Indeterminate and Infinite Results ",
    ButtonData:>{"3.1.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.1.9    Advanced Topic: Controlling Numerical Evaluation ",
    ButtonData:>{"3.1.9", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C3", "C3.1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematical Functions", "ContentsSection",
  CellTags->{"C3", "C3.2"}],

Cell[TextData[{
  ButtonBox["3.2.1    Naming Conventions ",
    ButtonData:>{"3.2.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.2    Numerical Functions ",
    ButtonData:>{"3.2.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.3    Piecewise Functions ",
    ButtonData:>{"3.2.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.4    Pseudorandom Numbers ",
    ButtonData:>{"3.2.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.5    Integer and Number\[Hyphen]Theoretical Functions ",
    ButtonData:>{"3.2.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.6    Combinatorial Functions ",
    ButtonData:>{"3.2.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.7    Elementary Transcendental Functions ",
    ButtonData:>{"3.2.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.8    Functions That Do Not Have Unique Values ",
    ButtonData:>{"3.2.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.9    Mathematical Constants ",
    ButtonData:>{"3.2.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.10    Orthogonal Polynomials ",
    ButtonData:>{"3.2.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.11    Special Functions ",
    ButtonData:>{"3.2.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.12    Elliptic Integrals and Elliptic Functions ",
    ButtonData:>{"3.2.12", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.13    Mathieu and Related Functions ",
    ButtonData:>{"3.2.13", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.14    Working with Special Functions ",
    ButtonData:>{"3.2.14", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.2.15    Statistical Distributions and Related Functions ",
    ButtonData:>{"3.2.15", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C3", "C3.2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebraic Manipulation", "ContentsSection",
  CellTags->{"C3", "C3.3"}],

Cell[TextData[{
  ButtonBox["3.3.1    Structural Operations on Polynomials ",
    ButtonData:>{"3.3.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.3.2    Finding the Structure of a Polynomial ",
    ButtonData:>{"3.3.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.3.3    Structural Operations on Rational Expressions ",
    ButtonData:>{"3.3.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.3.4    Algebraic Operations on Polynomials ",
    ButtonData:>{"3.3.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.3.5    Polynomials Modulo Primes ",
    ButtonData:>{"3.3.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.3.6    Advanced Topic: Polynomials over Algebraic Number \
Fields ",
    ButtonData:>{"3.3.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.3.7    Trigonometric Expressions ",
    ButtonData:>{"3.3.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.3.8    Expressions Involving Complex Variables ",
    ButtonData:>{"3.3.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.3.9    Advanced Topic: Logical and Piecewise Functions ",
    ButtonData:>{"3.3.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.3.10    Simplification ",
    ButtonData:>{"3.3.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.3.11    Using Assumptions ",
    ButtonData:>{"3.3.11", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C3", "C3.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Manipulating Equations and Inequalities", "ContentsSection",
  CellTags->{"C3", "C3.4"}],

Cell[TextData[{
  ButtonBox["3.4.1    The Representation of Equations and Solutions ",
    ButtonData:>{"3.4.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.4.2    Equations in One Variable ",
    ButtonData:>{"3.4.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.4.3    Advanced Topic: Algebraic Numbers ",
    ButtonData:>{"3.4.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.4.4    Simultaneous Equations ",
    ButtonData:>{"3.4.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.4.5    Generic and Non\[Hyphen]Generic Solutions ",
    ButtonData:>{"3.4.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.4.6    Eliminating Variables ",
    ButtonData:>{"3.4.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.4.7    Solving Logical Combinations of Equations ",
    ButtonData:>{"3.4.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.4.8    Inequalities ",
    ButtonData:>{"3.4.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.4.9    Equations and Inequalities over Domains ",
    ButtonData:>{"3.4.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.4.10    Advanced Topic: The Representation of Solution Sets ",
    ButtonData:>{"3.4.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.4.11    Advanced Topic: Quantifiers ",
    ButtonData:>{"3.4.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.4.12    Minimization and Maximization ",
    ButtonData:>{"3.4.12", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C3", "C3.4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculus", "ContentsSection",
  CellTags->{"C3", "C3.5"}],

Cell[TextData[{
  ButtonBox["3.5.1    Differentiation ",
    ButtonData:>{"3.5.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.5.2    Total Derivatives ",
    ButtonData:>{"3.5.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.5.3    Derivatives of Unknown Functions ",
    ButtonData:>{"3.5.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.5.4    Advanced Topic: The Representation of Derivatives ",
    ButtonData:>{"3.5.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.5.5    Defining Derivatives ",
    ButtonData:>{"3.5.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.5.6    Indefinite Integrals ",
    ButtonData:>{"3.5.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.5.7    Integrals That Can and Cannot Be Done ",
    ButtonData:>{"3.5.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.5.8    Definite Integrals ",
    ButtonData:>{"3.5.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.5.9    Integrals over Regions ",
    ButtonData:>{"3.5.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.5.10    Manipulating Integrals in Symbolic Form ",
    ButtonData:>{"3.5.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.5.11    Differential Equations ",
    ButtonData:>{"3.5.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.5.12    Integral Transforms and Related Operations ",
    ButtonData:>{"3.5.12", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.5.13    Generalized Functions and Related Objects ",
    ButtonData:>{"3.5.13", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C3", "C3.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series, Limits and Residues", "ContentsSection",
  CellTags->{"C3", "C3.6"}],

Cell[TextData[{
  ButtonBox["3.6.1    Making Power Series Expansions ",
    ButtonData:>{"3.6.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.6.2    Advanced Topic: The Representation of Power Series ",
    ButtonData:>{"3.6.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.6.3    Operations on Power Series ",
    ButtonData:>{"3.6.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.6.4    Advanced Topic: Composition and Inversion of Power \
Series ",
    ButtonData:>{"3.6.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.6.5    Converting Power Series to Normal Expressions ",
    ButtonData:>{"3.6.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.6.6    Solving Equations Involving Power Series ",
    ButtonData:>{"3.6.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.6.7    Summation of Series ",
    ButtonData:>{"3.6.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.6.8    Solving Recurrence Equations ",
    ButtonData:>{"3.6.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.6.9    Finding Limits ",
    ButtonData:>{"3.6.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.6.10    Residues ",
    ButtonData:>{"3.6.10", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C3", "C3.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Linear Algebra", "ContentsSection",
  CellTags->{"C3", "C3.7"}],

Cell[TextData[{
  ButtonBox["3.7.1    Constructing Matrices ",
    ButtonData:>{"3.7.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.7.2    Getting and Setting Pieces of Matrices ",
    ButtonData:>{"3.7.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.7.3    Scalars, Vectors and Matrices ",
    ButtonData:>{"3.7.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.7.4    Operations on Scalars, Vectors and Matrices ",
    ButtonData:>{"3.7.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.7.5    Multiplying Vectors and Matrices ",
    ButtonData:>{"3.7.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.7.6    Matrix Inversion ",
    ButtonData:>{"3.7.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.7.7    Basic Matrix Operations ",
    ButtonData:>{"3.7.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.7.8    Solving Linear Systems ",
    ButtonData:>{"3.7.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.7.9    Eigenvalues and Eigenvectors ",
    ButtonData:>{"3.7.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.7.10    Advanced Matrix Operations ",
    ButtonData:>{"3.7.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.7.11    Advanced Topic: Tensors ",
    ButtonData:>{"3.7.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.7.12    Sparse Arrays ",
    ButtonData:>{"3.7.12", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C3", "C3.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Operations on Data", "ContentsSection",
  CellTags->{"C3", "C3.8"}],

Cell[TextData[{
  ButtonBox["3.8.1    Basic Statistics ",
    ButtonData:>{"3.8.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.8.2    Curve Fitting ",
    ButtonData:>{"3.8.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.8.3    Approximate Functions and Interpolation ",
    ButtonData:>{"3.8.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.8.4    Fourier Transforms ",
    ButtonData:>{"3.8.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.8.5    Convolutions and Correlations ",
    ButtonData:>{"3.8.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.8.6    Cellular Automata ",
    ButtonData:>{"3.8.6", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C3", "C3.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Operations on Functions", "ContentsSection",
  CellTags->{"C3", "C3.9"}],

Cell[TextData[{
  ButtonBox["3.9.1    Numerical Mathematics in ",
    ButtonData:>{"3.9.1", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"3.9.1", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" ",
    ButtonData:>{"3.9.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.9.2    The Uncertainties of Numerical Mathematics ",
    ButtonData:>{"3.9.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.9.3    Numerical Integration ",
    ButtonData:>{"3.9.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.9.4    Numerical Evaluation of Sums and Products ",
    ButtonData:>{"3.9.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.9.5    Numerical Solution of Polynomial Equations ",
    ButtonData:>{"3.9.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.9.6    Numerical Root Finding ",
    ButtonData:>{"3.9.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.9.7    Numerical Solution of Differential Equations ",
    ButtonData:>{"3.9.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.9.8    Numerical Optimization ",
    ButtonData:>{"3.9.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.9.9    Advanced Topic: Controlling the Precision of Results ",
    ButtonData:>{"3.9.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.9.10    Advanced Topic: Monitoring and Selecting Algorithms ",
    ButtonData:>{"3.9.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.9.11    Advanced Topic: Functions with Sensitive Dependence on \
Their Input ",
    ButtonData:>{"3.9.11", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C3", "C3.9"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematical and Other Notation", "ContentsSection",
  CellTags->{"C3", "C3.10"}],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["3.10.1    Special Characters ",
    ButtonData:>{"3.10.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.10.2    Names of Symbols and Mathematical Objects ",
    ButtonData:>{"3.10.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.10.3    Letters and Letter\[Hyphen]like Forms ",
    ButtonData:>{"3.10.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.10.4    Operators ",
    ButtonData:>{"3.10.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["3.10.5    Structural Elements and Keyboard Characters ",
    ButtonData:>{"3.10.5", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"C3", "C3.10"}],

Cell[TextData[{
  StyleBox["Mathematica", "SBO"],
  " Reference Guide"
}], "ContentsTitle",
  CellTags->"CA"]
}, Open  ]],

Cell[TextData[ButtonBox["Introduction ",
  ButtonData:>{"IA", None},
  ButtonStyle->"MainBookLink"]], "Contents",
  CellTags->"CA"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic Objects", "ContentsSection",
  CellTags->{"CA", "CA.1"}],

Cell[TextData[{
  ButtonBox["A.1.1    Expressions ",
    ButtonData:>{"A.1.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.1.2    Symbols ",
    ButtonData:>{"A.1.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.1.3    Contexts ",
    ButtonData:>{"A.1.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.1.4    Atomic Objects ",
    ButtonData:>{"A.1.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.1.5    Numbers ",
    ButtonData:>{"A.1.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.1.6    Character Strings ",
    ButtonData:>{"A.1.6", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"CA", "CA.1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input Syntax", "ContentsSection",
  CellTags->{"CA", "CA.2"}],

Cell[TextData[{
  ButtonBox["A.2.1    Entering Characters ",
    ButtonData:>{"A.2.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.2.2    Types of Input Syntax ",
    ButtonData:>{"A.2.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.2.3    Character Strings ",
    ButtonData:>{"A.2.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.2.4    Symbol Names and Contexts ",
    ButtonData:>{"A.2.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.2.5    Numbers ",
    ButtonData:>{"A.2.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.2.6    Bracketed Objects ",
    ButtonData:>{"A.2.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.2.7    Operator Input Forms ",
    ButtonData:>{"A.2.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.2.8    Two\[Hyphen]Dimensional Input Forms ",
    ButtonData:>{"A.2.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.2.9    Input of Boxes ",
    ButtonData:>{"A.2.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.2.10    The Extent of Input Expressions ",
    ButtonData:>{"A.2.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.2.11    Special Input ",
    ButtonData:>{"A.2.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.2.12    Front End Files ",
    ButtonData:>{"A.2.12", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"CA", "CA.2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some General Notations and Conventions", "ContentsSection",
  CellTags->{"CA", "CA.3"}],

Cell[TextData[{
  ButtonBox["A.3.1    Function Names ",
    ButtonData:>{"A.3.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.3.2    Function Arguments ",
    ButtonData:>{"A.3.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.3.3    Options ",
    ButtonData:>{"A.3.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.3.4    Part Numbering ",
    ButtonData:>{"A.3.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.3.5    Sequence Specifications ",
    ButtonData:>{"A.3.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.3.6    Level Specifications ",
    ButtonData:>{"A.3.6", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.3.7    Iterators ",
    ButtonData:>{"A.3.7", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.3.8    Scoping Constructs ",
    ButtonData:>{"A.3.8", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.3.9    Ordering of Expressions ",
    ButtonData:>{"A.3.9", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.3.10    Mathematical Functions ",
    ButtonData:>{"A.3.10", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.3.11    Mathematical Constants ",
    ButtonData:>{"A.3.11", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.3.12    Protection ",
    ButtonData:>{"A.3.12", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.3.13    Abbreviated String Patterns ",
    ButtonData:>{"A.3.13", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"CA", "CA.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Evaluation", "ContentsSection",
  CellTags->{"CA", "CA.4"}],

Cell[TextData[{
  ButtonBox["A.4.1    The Standard Evaluation Sequence ",
    ButtonData:>{"A.4.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.4.2    Non\[Hyphen]Standard Argument Evaluation ",
    ButtonData:>{"A.4.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.4.3    Overriding Non\[Hyphen]Standard Argument Evaluation ",
    ButtonData:>{"A.4.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.4.4    Preventing Evaluation ",
    ButtonData:>{"A.4.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.4.5    Global Control of Evaluation ",
    ButtonData:>{"A.4.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.4.6    Aborts ",
    ButtonData:>{"A.4.6", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"CA", "CA.4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Patterns and Transformation Rules", "ContentsSection",
  CellTags->{"CA", "CA.5"}],

Cell[TextData[{
  ButtonBox["A.5.1    Patterns ",
    ButtonData:>{"A.5.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.5.2    Assignments ",
    ButtonData:>{"A.5.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.5.3    Types of Values ",
    ButtonData:>{"A.5.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.5.4    Clearing and Removing Objects ",
    ButtonData:>{"A.5.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.5.5    Transformation Rules ",
    ButtonData:>{"A.5.5", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"CA", "CA.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Files and Streams", "ContentsSection",
  CellTags->{"CA", "CA.6"}],

Cell[TextData[{
  ButtonBox["A.6.1    File Names ",
    ButtonData:>{"A.6.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.6.2    Streams ",
    ButtonData:>{"A.6.2", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"CA", "CA.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica", "SBO"],
  " Sessions"
}], "ContentsSection",
  CellTags->{"CA", "CA.7"}],

Cell[TextData[{
  ButtonBox["A.7.1    Command\[Hyphen]Line Options and Environment Variables \
",
    ButtonData:>{"A.7.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.7.2    Initialization ",
    ButtonData:>{"A.7.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.7.3    The Main Loop ",
    ButtonData:>{"A.7.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.7.4    Messages ",
    ButtonData:>{"A.7.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.7.5    Termination ",
    ButtonData:>{"A.7.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.7.6    Network License Management ",
    ButtonData:>{"A.7.6", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"CA", "CA.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica", "SBO"],
  " File Organization"
}], "ContentsSection",
  CellTags->{"CA", "CA.8"}],

Cell[TextData[{
  ButtonBox["A.8.1    ",
    ButtonData:>{"A.8.1", None},
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"A.8.1", None},
    ButtonStyle->"MainBookLink"], "TI"],
  ButtonBox[" Distribution Files ",
    ButtonData:>{"A.8.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.8.2    Loadable Files ",
    ButtonData:>{"A.8.2", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"CA", "CA.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some Notes on Internal Implementation", "ContentsSection",
  CellTags->{"CA", "CA.9"}],

Cell[TextData[{
  ButtonBox["A.9.1    Introduction ",
    ButtonData:>{"A.9.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.9.2    Data Structures and Memory Management ",
    ButtonData:>{"A.9.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.9.3    Basic System Features ",
    ButtonData:>{"A.9.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.9.4    Numerical and Related Functions ",
    ButtonData:>{"A.9.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.9.5    Algebra and Calculus ",
    ButtonData:>{"A.9.5", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.9.6    Output and Interfacing ",
    ButtonData:>{"A.9.6", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"CA", "CA.9"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Listing of Major Built\[Hyphen]in ",
  StyleBox["Mathematica", "SBO"],
  " Objects"
}], "ContentsSection",
  CellTags->{"CA", "CA.10"}],

Cell[TextData[{
  ButtonBox["A.10.1    Introduction ",
    ButtonData:>{"A.10.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.10.2    Conventions in This Listing ",
    ButtonData:>{"A.10.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.10.3    Listing ",
    ButtonData:>{"A.10.3", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"CA", "CA.10"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Listing of C Functions in the ",
  StyleBox["MathLink", "SBO"],
  " Library"
}], "ContentsSection",
  CellTags->{"CA", "CA.11"}],

Cell[TextData[ButtonBox["A.11.1    Introduction ",
  ButtonData:>{"A.11.1", None},
  ButtonStyle->"MainBookLink"]], "Contents",
  CellTags->{"CA", "CA.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Listing of Named Characters", "ContentsSection",
  CellTags->{"CA", "CA.12"}],

Cell[TextData[ButtonBox["A.12.1    Introduction ",
  ButtonData:>{"A.12.1", None},
  ButtonStyle->"MainBookLink"]], "Contents",
  CellTags->{"CA", "CA.12"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Incompatible Changes", "ContentsSection",
  CellTags->{"CA", "CA.13"}],

Cell[TextData[{
  ButtonBox["A.13.1    Introduction ",
    ButtonData:>{"A.13.1", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.13.2    Between Versions 1 and 2 ",
    ButtonData:>{"A.13.2", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.13.3    Between Versions 2 and 3 ",
    ButtonData:>{"A.13.3", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.13.4    Between Versions 3 and 4 ",
    ButtonData:>{"A.13.4", None},
    ButtonStyle->"MainBookLink"],
  "\n",
  ButtonBox["A.13.5    Between Versions 4 and 5 ",
    ButtonData:>{"A.13.5", None},
    ButtonStyle->"MainBookLink"]
}], "Contents",
  CellTags->{"CA", "CA.13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Developer Context Objects in ",
  StyleBox["Mathematica", "SBO"],
  " 5.2"
}], "ContentsSection",
  CellTags->{"CA", "CA.14"}],

Cell[TextData[ButtonBox["A.14.1    Introduction ",
  ButtonData:>{"A.14.1", None},
  ButtonStyle->"MainBookLink"]], "Contents",
  CellTags->{"CA", "CA.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Experimental Context Objects in ",
  StyleBox["Mathematica", "SBO"],
  " 5.2"
}], "ContentsSection",
  CellTags->{"CA", "CA.15"}],

Cell[TextData[ButtonBox["A.15.1    Introduction ",
  ButtonData:>{"A.15.1", None},
  ButtonStyle->"MainBookLink"]], "Contents",
  CellTags->{"CA", "CA.15"}]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "C0"->{
    Cell[1754, 51, 55, 1, 70, "ContentsTitle",
      CellTags->"C0"],
    Cell[1834, 56, 1192, 41, 70, "Contents",
      CellTags->"C0"]},
  "CT"->{
    Cell[3029, 99, 101, 4, 70, "ContentsTitle",
      CellTags->"CT"],
    Cell[3167, 108, 128, 3, 70, "Contents",
      CellTags->"CT"]},
  "C1"->{
    Cell[3298, 113, 121, 4, 70, "ContentsTitle",
      CellTags->"C1"],
    Cell[3434, 120, 131, 3, 70, "Contents",
      CellTags->"C1"],
    Cell[3590, 127, 113, 4, 70, "ContentsSection",
      CellTags->{"C1", "C1.0"}],
    Cell[3706, 133, 404, 13, 70, "Contents",
      CellTags->{"C1", "C1.0"}],
    Cell[4147, 151, 77, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.1"}],
    Cell[4227, 154, 1121, 35, 70, "Contents",
      CellTags->{"C1", "C1.1"}],
    Cell[5385, 194, 79, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.2"}],
    Cell[5467, 197, 997, 31, 70, "Contents",
      CellTags->{"C1", "C1.2"}],
    Cell[6501, 233, 128, 5, 70, "ContentsSection",
      CellTags->{"C1", "C1.3"}],
    Cell[6632, 240, 2023, 61, 70, "Contents",
      CellTags->{"C1", "C1.3"}],
    Cell[8692, 306, 77, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.4"}],
    Cell[8772, 309, 1591, 48, 70, "Contents",
      CellTags->{"C1", "C1.4"}],
    Cell[10400, 362, 75, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.5"}],
    Cell[10478, 365, 2010, 66, 70, "Contents",
      CellTags->{"C1", "C1.5"}],
    Cell[12525, 436, 76, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.6"}],
    Cell[12604, 439, 928, 29, 70, "Contents",
      CellTags->{"C1", "C1.6"}],
    Cell[13569, 473, 77, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.7"}],
    Cell[13649, 476, 550, 17, 70, "Contents",
      CellTags->{"C1", "C1.7"}],
    Cell[14236, 498, 60, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.8"}],
    Cell[14299, 501, 1598, 49, 70, "Contents",
      CellTags->{"C1", "C1.8"}],
    Cell[15934, 555, 73, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.9"}],
    Cell[16010, 558, 1547, 49, 70, "Contents",
      CellTags->{"C1", "C1.9"}],
    Cell[17594, 612, 85, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.10"}],
    Cell[17682, 615, 2464, 75, 70, "Contents",
      CellTags->{"C1", "C1.10"}],
    Cell[20183, 695, 85, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.11"}],
    Cell[20271, 698, 2091, 63, 70, "Contents",
      CellTags->{"C1", "C1.11"}],
    Cell[22399, 766, 138, 4, 70, "ContentsSection",
      CellTags->{"C1", "C1.12"}],
    Cell[22562, 774, 1104, 33, 70, "Contents",
      CellTags->{"C1", "C1.12"}]},
  "C1.0"->{
    Cell[3590, 127, 113, 4, 70, "ContentsSection",
      CellTags->{"C1", "C1.0"}],
    Cell[3706, 133, 404, 13, 70, "Contents",
      CellTags->{"C1", "C1.0"}]},
  "C1.1"->{
    Cell[4147, 151, 77, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.1"}],
    Cell[4227, 154, 1121, 35, 70, "Contents",
      CellTags->{"C1", "C1.1"}]},
  "C1.2"->{
    Cell[5385, 194, 79, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.2"}],
    Cell[5467, 197, 997, 31, 70, "Contents",
      CellTags->{"C1", "C1.2"}]},
  "C1.3"->{
    Cell[6501, 233, 128, 5, 70, "ContentsSection",
      CellTags->{"C1", "C1.3"}],
    Cell[6632, 240, 2023, 61, 70, "Contents",
      CellTags->{"C1", "C1.3"}]},
  "C1.4"->{
    Cell[8692, 306, 77, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.4"}],
    Cell[8772, 309, 1591, 48, 70, "Contents",
      CellTags->{"C1", "C1.4"}]},
  "C1.5"->{
    Cell[10400, 362, 75, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.5"}],
    Cell[10478, 365, 2010, 66, 70, "Contents",
      CellTags->{"C1", "C1.5"}]},
  "C1.6"->{
    Cell[12525, 436, 76, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.6"}],
    Cell[12604, 439, 928, 29, 70, "Contents",
      CellTags->{"C1", "C1.6"}]},
  "C1.7"->{
    Cell[13569, 473, 77, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.7"}],
    Cell[13649, 476, 550, 17, 70, "Contents",
      CellTags->{"C1", "C1.7"}]},
  "C1.8"->{
    Cell[14236, 498, 60, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.8"}],
    Cell[14299, 501, 1598, 49, 70, "Contents",
      CellTags->{"C1", "C1.8"}]},
  "C1.9"->{
    Cell[15934, 555, 73, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.9"}],
    Cell[16010, 558, 1547, 49, 70, "Contents",
      CellTags->{"C1", "C1.9"}]},
  "C1.10"->{
    Cell[17594, 612, 85, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.10"}],
    Cell[17682, 615, 2464, 75, 70, "Contents",
      CellTags->{"C1", "C1.10"}]},
  "C1.11"->{
    Cell[20183, 695, 85, 1, 70, "ContentsSection",
      CellTags->{"C1", "C1.11"}],
    Cell[20271, 698, 2091, 63, 70, "Contents",
      CellTags->{"C1", "C1.11"}]},
  "C1.12"->{
    Cell[22399, 766, 138, 4, 70, "ContentsSection",
      CellTags->{"C1", "C1.12"}],
    Cell[22562, 774, 1104, 33, 70, "Contents",
      CellTags->{"C1", "C1.12"}]},
  "C2"->{
    Cell[23669, 809, 107, 4, 70, "ContentsTitle",
      CellTags->"C2"],
    Cell[23791, 816, 131, 3, 70, "Contents",
      CellTags->"C2"],
    Cell[23959, 824, 66, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.1"}],
    Cell[24028, 827, 939, 29, 70, "Contents",
      CellTags->{"C2", "C2.1"}],
    Cell[25004, 861, 76, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.2"}],
    Cell[25083, 864, 1513, 45, 70, "Contents",
      CellTags->{"C2", "C2.2"}],
    Cell[26633, 914, 63, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.3"}],
    Cell[26699, 917, 1929, 57, 70, "Contents",
      CellTags->{"C2", "C2.3"}],
    Cell[28665, 979, 73, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.4"}],
    Cell[28741, 982, 663, 21, 70, "Contents",
      CellTags->{"C2", "C2.4"}],
    Cell[29441, 1008, 91, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.5"}],
    Cell[29535, 1011, 1809, 53, 70, "Contents",
      CellTags->{"C2", "C2.5"}],
    Cell[31381, 1069, 80, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.6"}],
    Cell[31464, 1072, 2392, 71, 70, "Contents",
      CellTags->{"C2", "C2.6"}],
    Cell[33893, 1148, 90, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.7"}],
    Cell[33986, 1151, 1940, 61, 70, "Contents",
      CellTags->{"C2", "C2.7"}],
    Cell[35963, 1217, 77, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.8"}],
    Cell[36043, 1220, 1204, 37, 70, "Contents",
      CellTags->{"C2", "C2.8"}],
    Cell[37284, 1262, 79, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.9"}],
    Cell[37366, 1265, 3282, 100, 70, "Contents",
      CellTags->{"C2", "C2.9"}],
    Cell[40685, 1370, 91, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.10"}],
    Cell[40779, 1373, 2867, 84, 70, "Contents",
      CellTags->{"C2", "C2.10"}],
    Cell[43683, 1462, 78, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.11"}],
    Cell[43764, 1465, 2408, 71, 70, "Contents",
      CellTags->{"C2", "C2.11"}],
    Cell[46209, 1541, 73, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.12"}],
    Cell[46285, 1544, 1687, 52, 70, "Contents",
      CellTags->{"C2", "C2.12"}],
    Cell[48009, 1601, 138, 4, 70, "ContentsSection",
      CellTags->{"C2", "C2.13"}],
    Cell[48150, 1607, 3853, 114, 70, "Contents",
      CellTags->{"C2", "C2.13"}],
    Cell[52040, 1726, 139, 5, 70, "ContentsSection",
      CellTags->{"C2", "C2.14"}],
    Cell[52204, 1735, 667, 21, 70, "Contents",
      CellTags->{"C2", "C2.14"}]},
  "C2.1"->{
    Cell[23959, 824, 66, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.1"}],
    Cell[24028, 827, 939, 29, 70, "Contents",
      CellTags->{"C2", "C2.1"}]},
  "C2.2"->{
    Cell[25004, 861, 76, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.2"}],
    Cell[25083, 864, 1513, 45, 70, "Contents",
      CellTags->{"C2", "C2.2"}]},
  "C2.3"->{
    Cell[26633, 914, 63, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.3"}],
    Cell[26699, 917, 1929, 57, 70, "Contents",
      CellTags->{"C2", "C2.3"}]},
  "C2.4"->{
    Cell[28665, 979, 73, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.4"}],
    Cell[28741, 982, 663, 21, 70, "Contents",
      CellTags->{"C2", "C2.4"}]},
  "C2.5"->{
    Cell[29441, 1008, 91, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.5"}],
    Cell[29535, 1011, 1809, 53, 70, "Contents",
      CellTags->{"C2", "C2.5"}]},
  "C2.6"->{
    Cell[31381, 1069, 80, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.6"}],
    Cell[31464, 1072, 2392, 71, 70, "Contents",
      CellTags->{"C2", "C2.6"}]},
  "C2.7"->{
    Cell[33893, 1148, 90, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.7"}],
    Cell[33986, 1151, 1940, 61, 70, "Contents",
      CellTags->{"C2", "C2.7"}]},
  "C2.8"->{
    Cell[35963, 1217, 77, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.8"}],
    Cell[36043, 1220, 1204, 37, 70, "Contents",
      CellTags->{"C2", "C2.8"}]},
  "C2.9"->{
    Cell[37284, 1262, 79, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.9"}],
    Cell[37366, 1265, 3282, 100, 70, "Contents",
      CellTags->{"C2", "C2.9"}]},
  "C2.10"->{
    Cell[40685, 1370, 91, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.10"}],
    Cell[40779, 1373, 2867, 84, 70, "Contents",
      CellTags->{"C2", "C2.10"}]},
  "C2.11"->{
    Cell[43683, 1462, 78, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.11"}],
    Cell[43764, 1465, 2408, 71, 70, "Contents",
      CellTags->{"C2", "C2.11"}]},
  "C2.12"->{
    Cell[46209, 1541, 73, 1, 70, "ContentsSection",
      CellTags->{"C2", "C2.12"}],
    Cell[46285, 1544, 1687, 52, 70, "Contents",
      CellTags->{"C2", "C2.12"}]},
  "C2.13"->{
    Cell[48009, 1601, 138, 4, 70, "ContentsSection",
      CellTags->{"C2", "C2.13"}],
    Cell[48150, 1607, 3853, 114, 70, "Contents",
      CellTags->{"C2", "C2.13"}]},
  "C2.14"->{
    Cell[52040, 1726, 139, 5, 70, "ContentsSection",
      CellTags->{"C2", "C2.14"}],
    Cell[52204, 1735, 667, 21, 70, "Contents",
      CellTags->{"C2", "C2.14"}]},
  "C3"->{
    Cell[52874, 1758, 117, 4, 70, "ContentsTitle",
      CellTags->"C3"],
    Cell[53006, 1765, 131, 3, 70, "Contents",
      CellTags->"C3"],
    Cell[53174, 1773, 62, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.1"}],
    Cell[53239, 1776, 1230, 37, 70, "Contents",
      CellTags->{"C3", "C3.1"}],
    Cell[54506, 1818, 77, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.2"}],
    Cell[54586, 1821, 2007, 61, 70, "Contents",
      CellTags->{"C3", "C3.2"}],
    Cell[56630, 1887, 77, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.3"}],
    Cell[56710, 1890, 1543, 46, 70, "Contents",
      CellTags->{"C3", "C3.3"}],
    Cell[58290, 1941, 94, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.4"}],
    Cell[58387, 1944, 1654, 49, 70, "Contents",
      CellTags->{"C3", "C3.4"}],
    Cell[60078, 1998, 63, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.5"}],
    Cell[60144, 2001, 1745, 53, 70, "Contents",
      CellTags->{"C3", "C3.5"}],
    Cell[61926, 2059, 82, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.6"}],
    Cell[62011, 2062, 1381, 42, 70, "Contents",
      CellTags->{"C3", "C3.6"}],
    Cell[63429, 2109, 69, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.7"}],
    Cell[63501, 2112, 1582, 49, 70, "Contents",
      CellTags->{"C3", "C3.7"}],
    Cell[65120, 2166, 83, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.8"}],
    Cell[65206, 2169, 788, 25, 70, "Contents",
      CellTags->{"C3", "C3.8"}],
    Cell[66031, 2199, 88, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.9"}],
    Cell[66122, 2202, 1788, 52, 70, "Contents",
      CellTags->{"C3", "C3.9"}],
    Cell[67947, 2259, 87, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.10"}],
    Cell[68059, 2264, 714, 21, 70, "Contents",
      CellTags->{"C3", "C3.10"}]},
  "C3.1"->{
    Cell[53174, 1773, 62, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.1"}],
    Cell[53239, 1776, 1230, 37, 70, "Contents",
      CellTags->{"C3", "C3.1"}]},
  "C3.2"->{
    Cell[54506, 1818, 77, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.2"}],
    Cell[54586, 1821, 2007, 61, 70, "Contents",
      CellTags->{"C3", "C3.2"}]},
  "C3.3"->{
    Cell[56630, 1887, 77, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.3"}],
    Cell[56710, 1890, 1543, 46, 70, "Contents",
      CellTags->{"C3", "C3.3"}]},
  "C3.4"->{
    Cell[58290, 1941, 94, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.4"}],
    Cell[58387, 1944, 1654, 49, 70, "Contents",
      CellTags->{"C3", "C3.4"}]},
  "C3.5"->{
    Cell[60078, 1998, 63, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.5"}],
    Cell[60144, 2001, 1745, 53, 70, "Contents",
      CellTags->{"C3", "C3.5"}]},
  "C3.6"->{
    Cell[61926, 2059, 82, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.6"}],
    Cell[62011, 2062, 1381, 42, 70, "Contents",
      CellTags->{"C3", "C3.6"}]},
  "C3.7"->{
    Cell[63429, 2109, 69, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.7"}],
    Cell[63501, 2112, 1582, 49, 70, "Contents",
      CellTags->{"C3", "C3.7"}]},
  "C3.8"->{
    Cell[65120, 2166, 83, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.8"}],
    Cell[65206, 2169, 788, 25, 70, "Contents",
      CellTags->{"C3", "C3.8"}]},
  "C3.9"->{
    Cell[66031, 2199, 88, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.9"}],
    Cell[66122, 2202, 1788, 52, 70, "Contents",
      CellTags->{"C3", "C3.9"}]},
  "C3.10"->{
    Cell[67947, 2259, 87, 1, 70, "ContentsSection",
      CellTags->{"C3", "C3.10"}],
    Cell[68059, 2264, 714, 21, 70, "Contents",
      CellTags->{"C3", "C3.10"}]},
  "CA"->{
    Cell[68776, 2287, 109, 4, 70, "ContentsTitle",
      CellTags->"CA"],
    Cell[68900, 2294, 131, 3, 70, "Contents",
      CellTags->"CA"],
    Cell[69068, 2302, 68, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.1"}],
    Cell[69139, 2305, 720, 25, 70, "Contents",
      CellTags->{"CA", "CA.1"}],
    Cell[69896, 2335, 67, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.2"}],
    Cell[69966, 2338, 1502, 49, 70, "Contents",
      CellTags->{"CA", "CA.2"}],
    Cell[71505, 2392, 93, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.3"}],
    Cell[71601, 2395, 1598, 53, 70, "Contents",
      CellTags->{"CA", "CA.3"}],
    Cell[73236, 2453, 65, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.4"}],
    Cell[73304, 2456, 834, 25, 70, "Contents",
      CellTags->{"CA", "CA.4"}],
    Cell[74175, 2486, 88, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.5"}],
    Cell[74266, 2489, 638, 21, 70, "Contents",
      CellTags->{"CA", "CA.5"}],
    Cell[74941, 2515, 72, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.6"}],
    Cell[75016, 2518, 269, 9, 70, "Contents",
      CellTags->{"CA", "CA.6"}],
    Cell[75322, 2532, 114, 4, 70, "ContentsSection",
      CellTags->{"CA", "CA.7"}],
    Cell[75439, 2538, 784, 26, 70, "Contents",
      CellTags->{"CA", "CA.7"}],
    Cell[76260, 2569, 123, 4, 70, "ContentsSection",
      CellTags->{"CA", "CA.8"}],
    Cell[76386, 2575, 478, 15, 70, "Contents",
      CellTags->{"CA", "CA.8"}],
    Cell[76901, 2595, 92, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.9"}],
    Cell[76996, 2598, 799, 25, 70, "Contents",
      CellTags->{"CA", "CA.9"}],
    Cell[77832, 2628, 154, 5, 70, "ContentsSection",
      CellTags->{"CA", "CA.10"}],
    Cell[77989, 2635, 406, 13, 70, "Contents",
      CellTags->{"CA", "CA.10"}],
    Cell[78432, 2653, 147, 5, 70, "ContentsSection",
      CellTags->{"CA", "CA.11"}],
    Cell[78582, 2660, 156, 3, 70, "Contents",
      CellTags->{"CA", "CA.11"}],
    Cell[78775, 2668, 83, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.12"}],
    Cell[78861, 2671, 156, 3, 70, "Contents",
      CellTags->{"CA", "CA.12"}],
    Cell[79054, 2679, 76, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.13"}],
    Cell[79133, 2682, 674, 21, 70, "Contents",
      CellTags->{"CA", "CA.13"}],
    Cell[79844, 2708, 145, 5, 70, "ContentsSection",
      CellTags->{"CA", "CA.14"}],
    Cell[79992, 2715, 156, 3, 70, "Contents",
      CellTags->{"CA", "CA.14"}],
    Cell[80185, 2723, 148, 5, 70, "ContentsSection",
      CellTags->{"CA", "CA.15"}],
    Cell[80336, 2730, 156, 3, 70, "Contents",
      CellTags->{"CA", "CA.15"}]},
  "CA.1"->{
    Cell[69068, 2302, 68, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.1"}],
    Cell[69139, 2305, 720, 25, 70, "Contents",
      CellTags->{"CA", "CA.1"}]},
  "CA.2"->{
    Cell[69896, 2335, 67, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.2"}],
    Cell[69966, 2338, 1502, 49, 70, "Contents",
      CellTags->{"CA", "CA.2"}]},
  "CA.3"->{
    Cell[71505, 2392, 93, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.3"}],
    Cell[71601, 2395, 1598, 53, 70, "Contents",
      CellTags->{"CA", "CA.3"}]},
  "CA.4"->{
    Cell[73236, 2453, 65, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.4"}],
    Cell[73304, 2456, 834, 25, 70, "Contents",
      CellTags->{"CA", "CA.4"}]},
  "CA.5"->{
    Cell[74175, 2486, 88, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.5"}],
    Cell[74266, 2489, 638, 21, 70, "Contents",
      CellTags->{"CA", "CA.5"}]},
  "CA.6"->{
    Cell[74941, 2515, 72, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.6"}],
    Cell[75016, 2518, 269, 9, 70, "Contents",
      CellTags->{"CA", "CA.6"}]},
  "CA.7"->{
    Cell[75322, 2532, 114, 4, 70, "ContentsSection",
      CellTags->{"CA", "CA.7"}],
    Cell[75439, 2538, 784, 26, 70, "Contents",
      CellTags->{"CA", "CA.7"}]},
  "CA.8"->{
    Cell[76260, 2569, 123, 4, 70, "ContentsSection",
      CellTags->{"CA", "CA.8"}],
    Cell[76386, 2575, 478, 15, 70, "Contents",
      CellTags->{"CA", "CA.8"}]},
  "CA.9"->{
    Cell[76901, 2595, 92, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.9"}],
    Cell[76996, 2598, 799, 25, 70, "Contents",
      CellTags->{"CA", "CA.9"}]},
  "CA.10"->{
    Cell[77832, 2628, 154, 5, 70, "ContentsSection",
      CellTags->{"CA", "CA.10"}],
    Cell[77989, 2635, 406, 13, 70, "Contents",
      CellTags->{"CA", "CA.10"}]},
  "CA.11"->{
    Cell[78432, 2653, 147, 5, 70, "ContentsSection",
      CellTags->{"CA", "CA.11"}],
    Cell[78582, 2660, 156, 3, 70, "Contents",
      CellTags->{"CA", "CA.11"}]},
  "CA.12"->{
    Cell[78775, 2668, 83, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.12"}],
    Cell[78861, 2671, 156, 3, 70, "Contents",
      CellTags->{"CA", "CA.12"}]},
  "CA.13"->{
    Cell[79054, 2679, 76, 1, 70, "ContentsSection",
      CellTags->{"CA", "CA.13"}],
    Cell[79133, 2682, 674, 21, 70, "Contents",
      CellTags->{"CA", "CA.13"}]},
  "CA.14"->{
    Cell[79844, 2708, 145, 5, 70, "ContentsSection",
      CellTags->{"CA", "CA.14"}],
    Cell[79992, 2715, 156, 3, 70, "Contents",
      CellTags->{"CA", "CA.14"}]},
  "CA.15"->{
    Cell[80185, 2723, 148, 5, 70, "ContentsSection",
      CellTags->{"CA", "CA.15"}],
    Cell[80336, 2730, 156, 3, 70, "Contents",
      CellTags->{"CA", "CA.15"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"C0", 81119, 2752},
  {"CT", 81268, 2757},
  {"C1", 81417, 2762},
  {"C1.0", 83696, 2819},
  {"C1.1", 83871, 2824},
  {"C1.2", 84046, 2829},
  {"C1.3", 84220, 2834},
  {"C1.4", 84396, 2839},
  {"C1.5", 84571, 2844},
  {"C1.6", 84748, 2849},
  {"C1.7", 84924, 2854},
  {"C1.8", 85100, 2859},
  {"C1.9", 85277, 2864},
  {"C1.10", 85455, 2869},
  {"C1.11", 85635, 2874},
  {"C1.12", 85815, 2879},
  {"C2", 85993, 2884},
  {"C2.1", 88474, 2945},
  {"C2.2", 88650, 2950},
  {"C2.3", 88827, 2955},
  {"C2.4", 89004, 2960},
  {"C2.5", 89180, 2965},
  {"C2.6", 89359, 2970},
  {"C2.7", 89538, 2975},
  {"C2.8", 89717, 2980},
  {"C2.9", 89896, 2985},
  {"C2.10", 90077, 2990},
  {"C2.11", 90259, 2995},
  {"C2.12", 90441, 3000},
  {"C2.13", 90623, 3005},
  {"C2.14", 90807, 3010},
  {"C3", 90986, 3015},
  {"C3.1", 92802, 3060},
  {"C3.2", 92981, 3065},
  {"C3.3", 93160, 3070},
  {"C3.4", 93339, 3075},
  {"C3.5", 93518, 3080},
  {"C3.6", 93697, 3085},
  {"C3.7", 93876, 3090},
  {"C3.8", 94055, 3095},
  {"C3.9", 94233, 3100},
  {"C3.10", 94413, 3105},
  {"CA", 94591, 3110},
  {"CA.1", 97237, 3175},
  {"CA.2", 97415, 3180},
  {"CA.3", 97594, 3185},
  {"CA.4", 97773, 3190},
  {"CA.5", 97951, 3195},
  {"CA.6", 98129, 3200},
  {"CA.7", 98306, 3205},
  {"CA.8", 98485, 3210},
  {"CA.9", 98664, 3215},
  {"CA.10", 98843, 3220},
  {"CA.11", 99025, 3225},
  {"CA.12", 99206, 3230},
  {"CA.13", 99386, 3235},
  {"CA.14", 99567, 3240},
  {"CA.15", 99748, 3245}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 55, 1, 70, "ContentsTitle",
  CellTags->"C0"],

Cell[CellGroupData[{
Cell[1834, 56, 1192, 41, 70, "Contents",
  CellTags->"C0"],
Cell[3029, 99, 101, 4, 70, "ContentsTitle",
  CellTags->"CT"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3167, 108, 128, 3, 70, "Contents",
  CellTags->"CT"],
Cell[3298, 113, 121, 4, 70, "ContentsTitle",
  CellTags->"C1"]
}, Open  ]],
Cell[3434, 120, 131, 3, 70, "Contents",
  CellTags->"C1"],

Cell[CellGroupData[{
Cell[3590, 127, 113, 4, 70, "ContentsSection",
  CellTags->{"C1", "C1.0"}],
Cell[3706, 133, 404, 13, 70, "Contents",
  CellTags->{"C1", "C1.0"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[4147, 151, 77, 1, 70, "ContentsSection",
  CellTags->{"C1", "C1.1"}],
Cell[4227, 154, 1121, 35, 70, "Contents",
  CellTags->{"C1", "C1.1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5385, 194, 79, 1, 70, "ContentsSection",
  CellTags->{"C1", "C1.2"}],
Cell[5467, 197, 997, 31, 70, "Contents",
  CellTags->{"C1", "C1.2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6501, 233, 128, 5, 70, "ContentsSection",
  CellTags->{"C1", "C1.3"}],
Cell[6632, 240, 2023, 61, 70, "Contents",
  CellTags->{"C1", "C1.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8692, 306, 77, 1, 70, "ContentsSection",
  CellTags->{"C1", "C1.4"}],
Cell[8772, 309, 1591, 48, 70, "Contents",
  CellTags->{"C1", "C1.4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[10400, 362, 75, 1, 70, "ContentsSection",
  CellTags->{"C1", "C1.5"}],
Cell[10478, 365, 2010, 66, 70, "Contents",
  CellTags->{"C1", "C1.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12525, 436, 76, 1, 70, "ContentsSection",
  CellTags->{"C1", "C1.6"}],
Cell[12604, 439, 928, 29, 70, "Contents",
  CellTags->{"C1", "C1.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13569, 473, 77, 1, 70, "ContentsSection",
  CellTags->{"C1", "C1.7"}],
Cell[13649, 476, 550, 17, 70, "Contents",
  CellTags->{"C1", "C1.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[14236, 498, 60, 1, 70, "ContentsSection",
  CellTags->{"C1", "C1.8"}],
Cell[14299, 501, 1598, 49, 70, "Contents",
  CellTags->{"C1", "C1.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[15934, 555, 73, 1, 70, "ContentsSection",
  CellTags->{"C1", "C1.9"}],
Cell[16010, 558, 1547, 49, 70, "Contents",
  CellTags->{"C1", "C1.9"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[17594, 612, 85, 1, 70, "ContentsSection",
  CellTags->{"C1", "C1.10"}],
Cell[17682, 615, 2464, 75, 70, "Contents",
  CellTags->{"C1", "C1.10"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[20183, 695, 85, 1, 70, "ContentsSection",
  CellTags->{"C1", "C1.11"}],
Cell[20271, 698, 2091, 63, 70, "Contents",
  CellTags->{"C1", "C1.11"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22399, 766, 138, 4, 70, "ContentsSection",
  CellTags->{"C1", "C1.12"}],

Cell[CellGroupData[{
Cell[22562, 774, 1104, 33, 70, "Contents",
  CellTags->{"C1", "C1.12"}],
Cell[23669, 809, 107, 4, 70, "ContentsTitle",
  CellTags->"C2"]
}, Open  ]],
Cell[23791, 816, 131, 3, 70, "Contents",
  CellTags->"C2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23959, 824, 66, 1, 70, "ContentsSection",
  CellTags->{"C2", "C2.1"}],
Cell[24028, 827, 939, 29, 70, "Contents",
  CellTags->{"C2", "C2.1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[25004, 861, 76, 1, 70, "ContentsSection",
  CellTags->{"C2", "C2.2"}],
Cell[25083, 864, 1513, 45, 70, "Contents",
  CellTags->{"C2", "C2.2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[26633, 914, 63, 1, 70, "ContentsSection",
  CellTags->{"C2", "C2.3"}],
Cell[26699, 917, 1929, 57, 70, "Contents",
  CellTags->{"C2", "C2.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[28665, 979, 73, 1, 70, "ContentsSection",
  CellTags->{"C2", "C2.4"}],
Cell[28741, 982, 663, 21, 70, "Contents",
  CellTags->{"C2", "C2.4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[29441, 1008, 91, 1, 70, "ContentsSection",
  CellTags->{"C2", "C2.5"}],
Cell[29535, 1011, 1809, 53, 70, "Contents",
  CellTags->{"C2", "C2.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[31381, 1069, 80, 1, 70, "ContentsSection",
  CellTags->{"C2", "C2.6"}],
Cell[31464, 1072, 2392, 71, 70, "Contents",
  CellTags->{"C2", "C2.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[33893, 1148, 90, 1, 70, "ContentsSection",
  CellTags->{"C2", "C2.7"}],
Cell[33986, 1151, 1940, 61, 70, "Contents",
  CellTags->{"C2", "C2.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[35963, 1217, 77, 1, 70, "ContentsSection",
  CellTags->{"C2", "C2.8"}],
Cell[36043, 1220, 1204, 37, 70, "Contents",
  CellTags->{"C2", "C2.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[37284, 1262, 79, 1, 70, "ContentsSection",
  CellTags->{"C2", "C2.9"}],
Cell[37366, 1265, 3282, 100, 70, "Contents",
  CellTags->{"C2", "C2.9"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[40685, 1370, 91, 1, 70, "ContentsSection",
  CellTags->{"C2", "C2.10"}],
Cell[40779, 1373, 2867, 84, 70, "Contents",
  CellTags->{"C2", "C2.10"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[43683, 1462, 78, 1, 70, "ContentsSection",
  CellTags->{"C2", "C2.11"}],
Cell[43764, 1465, 2408, 71, 70, "Contents",
  CellTags->{"C2", "C2.11"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[46209, 1541, 73, 1, 70, "ContentsSection",
  CellTags->{"C2", "C2.12"}],
Cell[46285, 1544, 1687, 52, 70, "Contents",
  CellTags->{"C2", "C2.12"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[48009, 1601, 138, 4, 70, "ContentsSection",
  CellTags->{"C2", "C2.13"}],
Cell[48150, 1607, 3853, 114, 70, "Contents",
  CellTags->{"C2", "C2.13"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[52040, 1726, 139, 5, 70, "ContentsSection",
  CellTags->{"C2", "C2.14"}],

Cell[CellGroupData[{
Cell[52204, 1735, 667, 21, 70, "Contents",
  CellTags->{"C2", "C2.14"}],
Cell[52874, 1758, 117, 4, 70, "ContentsTitle",
  CellTags->"C3"]
}, Open  ]],
Cell[53006, 1765, 131, 3, 70, "Contents",
  CellTags->"C3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[53174, 1773, 62, 1, 70, "ContentsSection",
  CellTags->{"C3", "C3.1"}],
Cell[53239, 1776, 1230, 37, 70, "Contents",
  CellTags->{"C3", "C3.1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[54506, 1818, 77, 1, 70, "ContentsSection",
  CellTags->{"C3", "C3.2"}],
Cell[54586, 1821, 2007, 61, 70, "Contents",
  CellTags->{"C3", "C3.2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[56630, 1887, 77, 1, 70, "ContentsSection",
  CellTags->{"C3", "C3.3"}],
Cell[56710, 1890, 1543, 46, 70, "Contents",
  CellTags->{"C3", "C3.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[58290, 1941, 94, 1, 70, "ContentsSection",
  CellTags->{"C3", "C3.4"}],
Cell[58387, 1944, 1654, 49, 70, "Contents",
  CellTags->{"C3", "C3.4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[60078, 1998, 63, 1, 70, "ContentsSection",
  CellTags->{"C3", "C3.5"}],
Cell[60144, 2001, 1745, 53, 70, "Contents",
  CellTags->{"C3", "C3.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[61926, 2059, 82, 1, 70, "ContentsSection",
  CellTags->{"C3", "C3.6"}],
Cell[62011, 2062, 1381, 42, 70, "Contents",
  CellTags->{"C3", "C3.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[63429, 2109, 69, 1, 70, "ContentsSection",
  CellTags->{"C3", "C3.7"}],
Cell[63501, 2112, 1582, 49, 70, "Contents",
  CellTags->{"C3", "C3.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[65120, 2166, 83, 1, 70, "ContentsSection",
  CellTags->{"C3", "C3.8"}],
Cell[65206, 2169, 788, 25, 70, "Contents",
  CellTags->{"C3", "C3.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[66031, 2199, 88, 1, 70, "ContentsSection",
  CellTags->{"C3", "C3.9"}],
Cell[66122, 2202, 1788, 52, 70, "Contents",
  CellTags->{"C3", "C3.9"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[67947, 2259, 87, 1, 70, "ContentsSection",
  CellTags->{"C3", "C3.10"}],

Cell[CellGroupData[{
Cell[68059, 2264, 714, 21, 70, "Contents",
  CellTags->{"C3", "C3.10"}],
Cell[68776, 2287, 109, 4, 70, "ContentsTitle",
  CellTags->"CA"]
}, Open  ]],
Cell[68900, 2294, 131, 3, 70, "Contents",
  CellTags->"CA"]
}, Open  ]],

Cell[CellGroupData[{
Cell[69068, 2302, 68, 1, 70, "ContentsSection",
  CellTags->{"CA", "CA.1"}],
Cell[69139, 2305, 720, 25, 70, "Contents",
  CellTags->{"CA", "CA.1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[69896, 2335, 67, 1, 70, "ContentsSection",
  CellTags->{"CA", "CA.2"}],
Cell[69966, 2338, 1502, 49, 70, "Contents",
  CellTags->{"CA", "CA.2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[71505, 2392, 93, 1, 70, "ContentsSection",
  CellTags->{"CA", "CA.3"}],
Cell[71601, 2395, 1598, 53, 70, "Contents",
  CellTags->{"CA", "CA.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[73236, 2453, 65, 1, 70, "ContentsSection",
  CellTags->{"CA", "CA.4"}],
Cell[73304, 2456, 834, 25, 70, "Contents",
  CellTags->{"CA", "CA.4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[74175, 2486, 88, 1, 70, "ContentsSection",
  CellTags->{"CA", "CA.5"}],
Cell[74266, 2489, 638, 21, 70, "Contents",
  CellTags->{"CA", "CA.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[74941, 2515, 72, 1, 70, "ContentsSection",
  CellTags->{"CA", "CA.6"}],
Cell[75016, 2518, 269, 9, 70, "Contents",
  CellTags->{"CA", "CA.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[75322, 2532, 114, 4, 70, "ContentsSection",
  CellTags->{"CA", "CA.7"}],
Cell[75439, 2538, 784, 26, 70, "Contents",
  CellTags->{"CA", "CA.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[76260, 2569, 123, 4, 70, "ContentsSection",
  CellTags->{"CA", "CA.8"}],
Cell[76386, 2575, 478, 15, 70, "Contents",
  CellTags->{"CA", "CA.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[76901, 2595, 92, 1, 70, "ContentsSection",
  CellTags->{"CA", "CA.9"}],
Cell[76996, 2598, 799, 25, 70, "Contents",
  CellTags->{"CA", "CA.9"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[77832, 2628, 154, 5, 70, "ContentsSection",
  CellTags->{"CA", "CA.10"}],
Cell[77989, 2635, 406, 13, 70, "Contents",
  CellTags->{"CA", "CA.10"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[78432, 2653, 147, 5, 70, "ContentsSection",
  CellTags->{"CA", "CA.11"}],
Cell[78582, 2660, 156, 3, 70, "Contents",
  CellTags->{"CA", "CA.11"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[78775, 2668, 83, 1, 70, "ContentsSection",
  CellTags->{"CA", "CA.12"}],
Cell[78861, 2671, 156, 3, 70, "Contents",
  CellTags->{"CA", "CA.12"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[79054, 2679, 76, 1, 70, "ContentsSection",
  CellTags->{"CA", "CA.13"}],
Cell[79133, 2682, 674, 21, 70, "Contents",
  CellTags->{"CA", "CA.13"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[79844, 2708, 145, 5, 70, "ContentsSection",
  CellTags->{"CA", "CA.14"}],
Cell[79992, 2715, 156, 3, 70, "Contents",
  CellTags->{"CA", "CA.14"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[80185, 2723, 148, 5, 70, "ContentsSection",
  CellTags->{"CA", "CA.15"}],
Cell[80336, 2730, 156, 3, 70, "Contents",
  CellTags->{"CA", "CA.15"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

