(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23541,        748]*)
(*NotebookOutlinePosition[     27782,        887]*)
(*  CellTagsIndexPosition[     27183,        859]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.13 ", "HeadingNumber"],
  "Incompatible Changes"
}], "Section",
  CellTags->{"SA.13.0", "0.1"}],

Cell[CellGroupData[{

Cell["A.13.1 Introduction", "Subsection",
  CellTags->{"SA.13.1", "1.1"}],

Cell[TextData[{
  "Every new version of ",
  StyleBox["Mathematica", "TI"],
  " contains many new features. But careful design from the outset has \
allowed nearly total compatibility to be maintained between all versions. As \
a result, almost any program written, say, for ",
  StyleBox["Mathematica", "TI"],
  " Version 1 in 1988 should be able to run without change in ",
  StyleBox["Mathematica", "TI"],
  " Version 5.2\[LongDash]though it will often run considerably faster. "
}], "Text",
  CellTags->{"SA.13.1", "1.2"}],

Cell[TextData[{
  "One inevitable problem, however, is that if a program uses names that \
begin with upper\[Hyphen]case letters, then it is possible that since the \
version when the program was first written, built\[Hyphen]in functions may \
have been added to ",
  StyleBox["Mathematica", "TI"],
  " whose names conflict with those used in the program. "
}], "Text",
  CellTags->{"SA.13.1", "1.3"}],

Cell[TextData[{
  "In addition, to maintain the overall coherence of ",
  StyleBox["Mathematica", "TI"],
  " a few functions that existed in earlier versions have gradually been \
dropped\[LongDash]first becoming undocumented, and later generating warning \
messages if used. Furthermore, it has in a few rare cases been necessary to \
makes changes to particular functions that are not compatible with their \
earlier operation. "
}], "Text",
  CellTags->{"SA.13.1", "1.4"}],

Cell[TextData[{
  "This section lists all major incompatible changes from ",
  StyleBox["Mathematica", "TI"],
  " Version 1 onward. "
}], "Text",
  CellTags->{"SA.13.1", "1.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.13.2 Between Versions 1 and 2", "Subsection",
  CellTags->{"SA.13.2", "2.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] 260 new built\[Hyphen]in objects have been added, \
some of whose names may conflict with names already being used.  \n\
\[FilledSmallSquare] ",
  StyleBox["Accumulate", "MR"],
  " has been superseded by ",
  ButtonBox["FoldList",
    ButtonStyle->"RefGuideLink"],
  "; ",
  ButtonBox["Fold",
    ButtonStyle->"RefGuideLink"],
  " has been added.  \n\[FilledSmallSquare] ",
  ButtonBox["Condition",
    ButtonStyle->"RefGuideLink"],
  " (",
  StyleBox["/;", "MR"],
  ") can now be used in individual patterns as well as in complete rules, and \
does not evaluate by default.  \n\[FilledSmallSquare] The functionality of ",
  StyleBox["Release", "MR"],
  " has been split between ",
  ButtonBox["Evaluate",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["ReleaseHold",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["Compose", "MR"],
  " has been superseded by ",
  ButtonBox["Composition",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["Debug", "MR"],
  " has been superseded by ",
  ButtonBox["Trace",
    ButtonStyle->"RefGuideLink"],
  " and related functions.  \n\[FilledSmallSquare] ",
  ButtonBox["Power",
    ButtonStyle->"RefGuideLink"],
  " no longer automatically makes transformations such as ",
  StyleBox["Sqrt[x^2]", "MR"],
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
  StyleBox["x", "MR"],
  ".  \n\[FilledSmallSquare] ",
  ButtonBox["Limit",
    ButtonStyle->"RefGuideLink"],
  " now by default remains unevaluated if it encounters an unknown function.  \
\n\[FilledSmallSquare] ",
  ButtonBox["Mod",
    ButtonStyle->"RefGuideLink"],
  " now handles only numbers; ",
  ButtonBox["PolynomialMod",
    ButtonStyle->"RefGuideLink"],
  " handles polynomials.  \n\[FilledSmallSquare] ",
  StyleBox["CellArray", "MR"],
  " has been superseded by ",
  ButtonBox["Raster",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["RasterArray",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["FontForm", "MR"],
  " takes a slightly different form of font specification.  \n\
\[FilledSmallSquare] ",
  StyleBox["Framed", "MR"],
  " has been superseded by ",
  ButtonBox["Frame",
    ButtonStyle->"RefGuideLink"],
  " and related options.  \n\[FilledSmallSquare] ",
  StyleBox["ContourLevels", "MR"],
  " and ",
  StyleBox["ContourSpacing", "MR"],
  " have been superseded by ",
  ButtonBox["Contours",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["Plot3Matrix", "MR"],
  " has been superseded by ",
  ButtonBox["ViewCenter",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["ViewVertical",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["FromASCII", "MR"],
  " and ",
  StyleBox["ToASCII", "MR"],
  " have been superseded by ",
  ButtonBox["FromCharacterCode",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["ToCharacterCode",
    ButtonStyle->"RefGuideLink"],
  " respectively.  \n\[FilledSmallSquare] ",
  StyleBox["Alias", "MR"],
  " has been superseded by ",
  ButtonBox["$PreRead",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["ResetMedium", "MR"],
  " has been subsumed in ",
  ButtonBox["SetOptions",
    ButtonStyle->"RefGuideLink"],
  ", and ",
  StyleBox["$$Media", "MR"],
  " has been superseded by ",
  ButtonBox["Streams",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["StartProcess", "MR"],
  " has been superseded by ",
  ButtonBox["Install",
    ButtonStyle->"RefGuideLink"],
  " and by ",
  StyleBox["MathLink", "TI"],
  ".  \n\[FilledSmallSquare] Additional parts devoted to ",
  StyleBox["Mathematica", "TI"],
  " as a programming language, and to examples of ",
  StyleBox["Mathematica", "TI"],
  " packages, have been dropped from ",
  StyleBox["The Mathematica Book", "TI"],
  ".  "
}], "Notes",
  CellTags->{"SA.13.2", "2.2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.13.3 Between Versions 2 and 3", "Subsection",
  CellTags->{"SA.13.3", "3.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] 259 new built\[Hyphen]in objects have been added, \
some of whose names may conflict with names already being used.  \n\
\[FilledSmallSquare] ",
  StyleBox["N[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " now always tries to give ",
  StyleBox["n", "TI"],
  " digits of precision if possible, rather than simply starting with ",
  StyleBox["n", "TI"],
  " digits of precision.  "
}], "Notes",
  CellTags->{"SA.13.3", "3.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] All expressions containing only numeric functions and \
numerical constants are now converted to approximate numerical form whenever \
they contain any approximate numbers.  \n\[FilledSmallSquare] Many \
expressions involving exact numbers that used to remain unevaluated are now \
evaluated. Example: ",
  StyleBox["Floor[(7/3)^20]", "MR"],
  ".  \n\[FilledSmallSquare] ",
  ButtonBox["Plus",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Times",
    ButtonStyle->"RefGuideLink"],
  " now apply built\[Hyphen]in rules before user\[Hyphen]defined ones, so it \
is no longer possible to make definitions such as ",
  StyleBox["2+2=5", "MR"],
  ".  \n\[FilledSmallSquare] The operator precedence for ",
  StyleBox[".", "MR"],
  " and ",
  StyleBox["**", "MR"],
  " has been changed so as to be below ",
  StyleBox["^", "MR"],
  ". This has the consequence that expressions previously written in ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  " as ",
  StyleBox["a", "MR"],
  " ",
  StyleBox[".", "MR"],
  " ",
  StyleBox["b", "MR"],
  " ",
  StyleBox["^", "MR"],
  " ",
  StyleBox["n", "MR"],
  " must now be written as ",
  StyleBox["(a", "MR"],
  " ",
  StyleBox[".", "MR"],
  " ",
  StyleBox["b)^n", "MR"],
  ". ",
  StyleBox["V2Get[", "MR"],
  StyleBox["file", "TI"],
  StyleBox["]", "MR"],
  " will read a file using old operator precedences.  \n\[FilledSmallSquare] \
\[Backslash]",
  StyleBox["^", "MR"],
  " is now an operator used to generate a superscript. Raw octal codes must \
be used instead of \[Backslash]",
  StyleBox["^", "MR"],
  StyleBox["A", "TI"],
  " for inputting control characters.  \n\[FilledSmallSquare] In ",
  StyleBox["Mathematica", "TI"],
  " notebooks, several built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions are now output by default using special characters. Example: ",
  StyleBox["x", "TI"],
  StyleBox["->", "MR"],
  StyleBox["y", "TI"],
  " is output as ",
  StyleBox["x", "TI"],
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
  StyleBox["y", "TI"],
  " in ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] More sophisticated definite integrals now yield \
explicit ",
  ButtonBox["If",
    ButtonStyle->"RefGuideLink"],
  " constructs unless the option setting ",
  StyleBox["GenerateConditions->False", "MR"],
  " is used.  \n\[FilledSmallSquare] ",
  StyleBox["HeldPart[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["i", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["j", "TI"],
  StyleBox[", ", "MR"],
  "\[Ellipsis]",
  StyleBox[" ]", "MR"],
  " has been superseded by ",
  StyleBox["Extract[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[", {", "MR"],
  StyleBox["i", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["j", "TI"],
  StyleBox[", ", "MR"],
  "\[Ellipsis]",
  StyleBox[" }, Hold]", "MR"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["Literal[", "MR"],
  StyleBox["pattern", "TI"],
  StyleBox["]", "MR"],
  " has been replaced by ",
  StyleBox["HoldPattern[", "MR"],
  StyleBox["pattern", "TI"],
  StyleBox["]", "MR"],
  ". ",
  StyleBox["Verbatim[", "MR"],
  StyleBox["pattern", "TI"],
  StyleBox["]", "MR"],
  " has been introduced. Functions like ",
  ButtonBox["DownValues",
    ButtonStyle->"RefGuideLink"],
  " return their results wrapped in ",
  ButtonBox["HoldPattern",
    ButtonStyle->"RefGuideLink"],
  " rather than ",
  StyleBox["Literal", "MR"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["ReplaceHeldPart[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["new", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["pos", "TI"],
  StyleBox["]", "MR"],
  " has been superseded by ",
  StyleBox["ReplacePart[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[", Hold[", "MR"],
  StyleBox["new", "TI"],
  StyleBox["], ", "MR"],
  StyleBox["pos", "TI"],
  StyleBox[", 1]", "MR"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["ToHeldExpression[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " has been superseded by ",
  StyleBox["ToExpression[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["form", "TI"],
  StyleBox[", Hold]", "MR"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["Trig", "MR"],
  " as an option to algebraic manipulation functions has been superseded by \
the explicit functions ",
  ButtonBox["TrigExpand",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TrigFactor",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["TrigReduce",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["AlgebraicRules", "MR"],
  " has been superseded by ",
  ButtonBox["PolynomialReduce",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] The option ",
  StyleBox["LegendreType", "MR"],
  " has been superseded by an additional optional argument to ",
  ButtonBox["LegendreP",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["LegendreQ",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["WeierstrassP[", "MR"],
  StyleBox["u", "TI"],
  StyleBox[", {", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["g",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[", ", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["g",
            "TI"], "3"], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  " now takes ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["g",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["g",
            "TI"], "3"], TraditionalForm]], "InlineFormula"],
  " in a list.  \n\[FilledSmallSquare] ",
  StyleBox["$Letters", "MR"],
  " and ",
  StyleBox["$StringOrder", "MR"],
  " now have built\[Hyphen]in values only, but these handle all possible ",
  StyleBox["Mathematica", "TI"],
  " characters.  \n\[FilledSmallSquare] ",
  StyleBox["StringByteCount", "MR"],
  " is no longer supported.  \n\[FilledSmallSquare] \
Arbitrary\[Hyphen]precision approximate real numbers are now given by default \
as ",
  StyleBox["digits", "TI"],
  StyleBox["`", "MR"],
  StyleBox["prec", "TI"],
  " in ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  ". This behavior is controlled by ",
  ButtonBox["$NumberMarks",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] Large approximate real numbers are now given by \
default as ",
  StyleBox["digits", "TI"],
  StyleBox["*^", "MR"],
  StyleBox["exponent", "TI"],
  " in ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["HomeDirectory[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " has been replaced by ",
  ButtonBox["$HomeDirectory",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["Dump", "MR"],
  " has been superseded by ",
  ButtonBox["DumpSave",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["$PipeSupported", "MR"],
  " and ",
  StyleBox["$LinkSupported", "MR"],
  " are now obsolete, since all computer systems support pipes and links.  \n\
\[FilledSmallSquare] ",
  StyleBox["LinkOpen", "MR"],
  " has been superseded by ",
  ButtonBox["LinkCreate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkConnect",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["Subscripted", "MR"],
  " has been superseded by ",
  ButtonBox["RowBox",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SubscriptBox",
    ButtonStyle->"RefGuideLink"],
  ", etc.  \n\[FilledSmallSquare] ",
  StyleBox["Subscript", "MR"],
  " and ",
  StyleBox["Superscript", "MR"],
  " now represent complete subscripted and superscripted quantities, not just \
subscripts and superscripts.  \n\[FilledSmallSquare] ",
  StyleBox["FontForm", "MR"],
  " and ",
  ButtonBox["DefaultFont",
    ButtonStyle->"RefGuideLink"],
  " have been superseded by ",
  ButtonBox["StyleForm",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["TextStyle",
    ButtonStyle->"RefGuideLink"],
  ".  "
}], "Notes",
  CellTags->{"SA.13.3", "3.3"}],

Cell["In the notebook front end, changes that were made include: ", "Text",
  CellTags->{"SA.13.3", "3.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] The file format for notebooks has been completely \
changed in order to support new notebook capabilities.  \n\
\[FilledSmallSquare] Notebook files are now by default given ",
  StyleBox[".nb", "MR"],
  " rather than ",
  StyleBox[".ma", "MR"],
  " extensions; ",
  StyleBox[".mb", "MR"],
  " files are now superfluous.  \n\[FilledSmallSquare] The front end will \
automatically ask to convert any old notebook that you tell it to open.  \n\
\[FilledSmallSquare] The kernel command ",
  StyleBox["NotebookConvert", "MR"],
  " can be used to convert notebook files from Version 2 to Version 3 format. \
 \n\[FilledSmallSquare] The default format type for input cells is now ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  " rather than ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] The organization of style sheets, as well as the \
settings for some default styles, have been changed.  \n\[FilledSmallSquare] \
Some command key equivalents for menu items have been rearranged.  "
}], "Notes",
  CellTags->{"SA.13.3", "3.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.13.4 Between Versions 3 and 4", "Subsection",
  CellTags->{"SA.13.4", "4.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] 61 new built\[Hyphen]in objects have been added, some \
of whose names may conflict with names already being used.  \n\
\[FilledSmallSquare] ",
  StyleBox["N[0]", "MR"],
  " now yields a machine\[Hyphen]precision zero rather than an exact zero.  \n\
\[FilledSmallSquare] ",
  StyleBox["FullOptions", "MR"],
  " has been superseded by ",
  ButtonBox["AbsoluteOptions",
    ButtonStyle->"RefGuideLink"],
  ", which yields results in the same form as ",
  ButtonBox["Options",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["Element[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  " or ",
  Cell[BoxData[
      RowBox[{
        StyleBox["x",
          "TI"], "\[Element]", 
        StyleBox["y",
          "TI"]}]], "InlineFormula"],
  " now has built\[Hyphen]in evaluation rules.  \n\[FilledSmallSquare] The \
symbols ",
  ButtonBox["I",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["E",
    ButtonStyle->"RefGuideLink"],
  " are now output in ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  " as ",
  Cell[BoxData[
      \(TraditionalForm\`\[ImaginaryI]\)], "InlineFormula"],
  " (\[Backslash]",
  StyleBox["[ImaginaryI]", "MR"],
  ") and ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\)], "InlineFormula"],
  " (\[Backslash]",
  StyleBox["[ExponentialE]", "MR"],
  ") respectively.  \n\[FilledSmallSquare] A new second argument has been \
added to ",
  ButtonBox["CompiledFunction",
    ButtonStyle->"RefGuideLink"],
  " to allow easier manipulation and composition of compiled functions.  "
}], "Notes",
  CellTags->{"SA.13.4", "4.2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A.13.5 Between Versions 4 and 5", "Subsection",
  CellTags->{"SA.13.5", "5.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] 44 completely new built\[Hyphen]in objects have been \
added, some of whose names may conflict with names already being used.  \n\
\[FilledSmallSquare] ",
  ButtonBox["Precision",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Accuracy",
    ButtonStyle->"RefGuideLink"],
  " now return exact measures of uncertainty in numbers, not just estimates \
of integer numbers of digits.  \n\[FilledSmallSquare] ",
  ButtonBox["Precision",
    ButtonStyle->"RefGuideLink"],
  " now returns the symbol ",
  ButtonBox["MachinePrecision",
    ButtonStyle->"RefGuideLink"],
  " for machine numbers, rather than the numerical value ",
  ButtonBox["$MachinePrecision",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["N[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[", MachinePrecision]", "MR"],
  " is now used for numerical evaluation with machine numbers; ",
  StyleBox["N[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[", $MachinePrecision]", "MR"],
  " generates arbitrary\[Hyphen]precision numbers.  \n\[FilledSmallSquare] ",
  StyleBox["ConstrainedMin", "MR"],
  " and ",
  StyleBox["ConstrainedMax", "MR"],
  " have been superseded by ",
  ButtonBox["Minimize",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Maximize",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["NMinimize",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["NMaximize",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["SingularValues", "MR"],
  " has been superseded by ",
  ButtonBox["SingularValueList",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["SingularValueDecomposition",
    ButtonStyle->"RefGuideLink"],
  ". ",
  ButtonBox["SingularValueDecomposition",
    ButtonStyle->"RefGuideLink"],
  " uses a different and more complete definition.  \n\[FilledSmallSquare] ",
  StyleBox["LUBackSubstitution", "MR"],
  " has been superseded by the use of the more general ",
  ButtonBox["LinearSolveFunction",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["FindRoot[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[", {", "MR"],
  StyleBox["x", "TI"],
  StyleBox[", {", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  StyleBox[", ", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox["}}]", "MR"],
  " is now used to specify a starting vector value for ",
  StyleBox["x", "TI"],
  ", rather than a pair of values. The same is true for ",
  ButtonBox["FindMinimum",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["DSolveConstants", "MR"],
  " has been superseded by the more general option ",
  ButtonBox["GeneratedParameters",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["TensorRank", "MR"],
  " has been replaced by ",
  ButtonBox["ArrayDepth",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["$TopDirectory", "MR"],
  " has been superseded by ",
  ButtonBox["$InstallationDirectory",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["$BaseDirectory",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] The default setting for the ",
  StyleBox["MathLink", "TI"],
  " ",
  ButtonBox["LinkProtocol",
    ButtonStyle->"RefGuideLink"],
  " option when connecting different computer systems is now ",
  StyleBox["\"TCPIP\"", "MR"],
  " rather than ",
  StyleBox["\"TCP\"", "MR"],
  ".  "
}], "Notes",
  CellTags->{"SA.13.5", "5.2"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.13.0"->{
    Cell[1776, 53, 125, 4, 70, "Section",
      CellTags->{"SA.13.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 125, 4, 70, "Section",
      CellTags->{"SA.13.0", "0.1"}]},
  "SA.13.1"->{
    Cell[1926, 61, 73, 1, 70, "Subsection",
      CellTags->{"SA.13.1", "1.1"}],
    Cell[2002, 64, 526, 11, 70, "Text",
      CellTags->{"SA.13.1", "1.2"}],
    Cell[2531, 77, 401, 8, 70, "Text",
      CellTags->{"SA.13.1", "1.3"}],
    Cell[2935, 87, 475, 9, 70, "Text",
      CellTags->{"SA.13.1", "1.4"}],
    Cell[3413, 98, 177, 5, 70, "Text",
      CellTags->{"SA.13.1", "1.5"}]},
  "1.1"->{
    Cell[1926, 61, 73, 1, 70, "Subsection",
      CellTags->{"SA.13.1", "1.1"}]},
  "1.2"->{
    Cell[2002, 64, 526, 11, 70, "Text",
      CellTags->{"SA.13.1", "1.2"}]},
  "1.3"->{
    Cell[2531, 77, 401, 8, 70, "Text",
      CellTags->{"SA.13.1", "1.3"}]},
  "1.4"->{
    Cell[2935, 87, 475, 9, 70, "Text",
      CellTags->{"SA.13.1", "1.4"}]},
  "1.5"->{
    Cell[3413, 98, 177, 5, 70, "Text",
      CellTags->{"SA.13.1", "1.5"}]},
  "SA.13.2"->{
    Cell[3627, 108, 85, 1, 70, "Subsection",
      CellTags->{"SA.13.2", "2.1"}],
    Cell[3715, 111, 3970, 124, 70, "Notes",
      CellTags->{"SA.13.2", "2.2"}]},
  "2.1"->{
    Cell[3627, 108, 85, 1, 70, "Subsection",
      CellTags->{"SA.13.2", "2.1"}]},
  "2.2"->{
    Cell[3715, 111, 3970, 124, 70, "Notes",
      CellTags->{"SA.13.2", "2.2"}]},
  "SA.13.3"->{
    Cell[7722, 240, 85, 1, 70, "Subsection",
      CellTags->{"SA.13.3", "3.1"}],
    Cell[7810, 243, 528, 15, 70, "Notes",
      CellTags->{"SA.13.3", "3.2"}],
    Cell[8341, 260, 8290, 275, 70, "Notes",
      CellTags->{"SA.13.3", "3.3"}],
    Cell[16634, 537, 107, 1, 70, "Text",
      CellTags->{"SA.13.3", "3.4"}],
    Cell[16744, 540, 1128, 24, 70, "Notes",
      CellTags->{"SA.13.3", "3.5"}]},
  "3.1"->{
    Cell[7722, 240, 85, 1, 70, "Subsection",
      CellTags->{"SA.13.3", "3.1"}]},
  "3.2"->{
    Cell[7810, 243, 528, 15, 70, "Notes",
      CellTags->{"SA.13.3", "3.2"}]},
  "3.3"->{
    Cell[8341, 260, 8290, 275, 70, "Notes",
      CellTags->{"SA.13.3", "3.3"}]},
  "3.4"->{
    Cell[16634, 537, 107, 1, 70, "Text",
      CellTags->{"SA.13.3", "3.4"}]},
  "3.5"->{
    Cell[16744, 540, 1128, 24, 70, "Notes",
      CellTags->{"SA.13.3", "3.5"}]},
  "SA.13.4"->{
    Cell[17909, 569, 85, 1, 70, "Subsection",
      CellTags->{"SA.13.4", "4.1"}],
    Cell[17997, 572, 1707, 53, 70, "Notes",
      CellTags->{"SA.13.4", "4.2"}]},
  "4.1"->{
    Cell[17909, 569, 85, 1, 70, "Subsection",
      CellTags->{"SA.13.4", "4.1"}]},
  "4.2"->{
    Cell[17997, 572, 1707, 53, 70, "Notes",
      CellTags->{"SA.13.4", "4.2"}]},
  "SA.13.5"->{
    Cell[19741, 630, 85, 1, 70, "Subsection",
      CellTags->{"SA.13.5", "5.1"}],
    Cell[19829, 633, 3684, 111, 70, "Notes",
      CellTags->{"SA.13.5", "5.2"}]},
  "5.1"->{
    Cell[19741, 630, 85, 1, 70, "Subsection",
      CellTags->{"SA.13.5", "5.1"}]},
  "5.2"->{
    Cell[19829, 633, 3684, 111, 70, "Notes",
      CellTags->{"SA.13.5", "5.2"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.13.0", 24157, 764},
  {"0.1", 24248, 767},
  {"SA.13.1", 24343, 770},
  {"1.1", 24741, 781},
  {"1.2", 24834, 784},
  {"1.3", 24923, 787},
  {"1.4", 25011, 790},
  {"1.5", 25099, 793},
  {"SA.13.2", 25191, 796},
  {"2.1", 25366, 801},
  {"2.2", 25460, 804},
  {"SA.13.3", 25557, 807},
  {"3.1", 25970, 818},
  {"3.2", 26064, 821},
  {"3.3", 26155, 824},
  {"3.4", 26248, 827},
  {"3.5", 26338, 830},
  {"SA.13.4", 26435, 833},
  {"4.1", 26611, 838},
  {"4.2", 26706, 841},
  {"SA.13.5", 26803, 844},
  {"5.1", 26980, 849},
  {"5.2", 27075, 852}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 125, 4, 70, "Section",
  CellTags->{"SA.13.0", "0.1"}],

Cell[CellGroupData[{
Cell[1926, 61, 73, 1, 70, "Subsection",
  CellTags->{"SA.13.1", "1.1"}],
Cell[2002, 64, 526, 11, 70, "Text",
  CellTags->{"SA.13.1", "1.2"}],
Cell[2531, 77, 401, 8, 70, "Text",
  CellTags->{"SA.13.1", "1.3"}],
Cell[2935, 87, 475, 9, 70, "Text",
  CellTags->{"SA.13.1", "1.4"}],
Cell[3413, 98, 177, 5, 70, "Text",
  CellTags->{"SA.13.1", "1.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[3627, 108, 85, 1, 70, "Subsection",
  CellTags->{"SA.13.2", "2.1"}],
Cell[3715, 111, 3970, 124, 70, "Notes",
  CellTags->{"SA.13.2", "2.2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7722, 240, 85, 1, 70, "Subsection",
  CellTags->{"SA.13.3", "3.1"}],
Cell[7810, 243, 528, 15, 70, "Notes",
  CellTags->{"SA.13.3", "3.2"}],
Cell[8341, 260, 8290, 275, 70, "Notes",
  CellTags->{"SA.13.3", "3.3"}],
Cell[16634, 537, 107, 1, 70, "Text",
  CellTags->{"SA.13.3", "3.4"}],
Cell[16744, 540, 1128, 24, 70, "Notes",
  CellTags->{"SA.13.3", "3.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[17909, 569, 85, 1, 70, "Subsection",
  CellTags->{"SA.13.4", "4.1"}],
Cell[17997, 572, 1707, 53, 70, "Notes",
  CellTags->{"SA.13.4", "4.2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[19741, 630, 85, 1, 70, "Subsection",
  CellTags->{"SA.13.5", "5.1"}],
Cell[19829, 633, 3684, 111, 70, "Notes",
  CellTags->{"SA.13.5", "5.2"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

